-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-20366612-3
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-08-17 19:18:45','Actividad Generica 1','000001',NULL),(2,NULL,'2022-08-17 19:18:45','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'haydeemore@yahoo.com.ar','1151652719',NULL,1,40719,'2022-11-16'),(2,'haydeemore@yahoo.com.ar','1151652719','',1,40719,'2022-11-16'),(3,'haydeemore@yahoo.com.ar','1151652719','',1,40719,'2022-11-16'),(4,'haydeemore@yahoo.com.ar','1151652719','',1,40719,'2022-11-25'),(5,'haydeemore@yahoo.com.ar','1151652719','',1,40719,'2023-01-19'),(6,'haydeemore@yahoo.com.ar','1151652719','',1,40719,'2023-01-19'),(7,'haydeemore@yahoo.com.ar','1151652719','',1,40719,'2023-02-19'),(8,'haydeemore@yahoo.com.ar','1151652719',NULL,1,40719,'2023-03-10'),(9,'haydeemore@yahoo.com.ar','1151652719','',1,40719,'2023-03-10'),(10,'haydeemore@yahoo.com.ar','1151652719','',1,40719,'2023-03-10'),(11,'haydeemore@yahoo.com.ar','1151652719','',1,40719,'2023-03-10'),(12,'gustavocejas1@gmail.com.ar',NULL,'',1,40857,'2023-03-10'),(13,'gustavocejas1@gmail.com.ar',NULL,'',1,40857,'2023-03-11'),(14,'gustavocejas1@gmail.com.ar',NULL,'',1,40857,'2023-03-11'),(15,'gustavocejas1@gmail.com.ar',NULL,'',1,40857,'2023-03-11'),(16,'gustavocejas1@gmail.com.ar',NULL,'',1,40857,'2023-03-11'),(17,'haydeemore@yahoo.com.ar','1151652719','',1,40719,'2023-03-16'),(19,'gustavocejas1@gmail.com.ar',NULL,'',1,40857,'2023-03-19'),(20,'haydeemore@yahoo.com.ar','1151652719',NULL,1,40719,'2023-04-12'),(21,'gustavocejas1@gmail.com.ar',NULL,'',1,40857,'2023-04-21');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10934 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7561,40719,10,2,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',4000.00,NULL,NULL,1,'2022-11-16 14:21:25','2022-11-16 14:21:25',NULL),(2,7561,40719,10,2,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',170000.00,NULL,NULL,1,'2022-11-16 14:21:25','2022-11-16 14:21:25',NULL),(3,7561,40719,10,2,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',5500.00,NULL,NULL,1,'2022-11-16 14:21:25','2022-11-16 14:21:25',NULL),(4,7561,40719,10,2,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',6500.00,NULL,NULL,1,'2022-11-16 14:21:25','2022-11-16 14:21:25',NULL),(5,7561,40719,10,2,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',6600.00,NULL,NULL,1,'2022-11-16 14:21:25','2022-11-16 14:21:25',NULL),(6,7561,40719,10,2,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',37000.00,NULL,NULL,1,'2022-11-16 14:21:25','2022-11-16 14:21:25',NULL),(7,7561,40719,10,2,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11000.00,NULL,NULL,1,'2022-11-16 14:21:25','2022-11-16 14:21:25',NULL),(14,7561,40719,3,2,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',118000.00,NULL,NULL,1,'2022-11-25 15:17:14','2022-11-25 15:17:14',NULL),(15,7561,40719,3,2,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',4250.00,NULL,NULL,1,'2022-11-25 15:17:14','2022-11-25 15:17:14',NULL),(16,7561,40719,3,2,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',3550.00,NULL,NULL,1,'2022-11-25 15:17:14','2022-11-25 15:17:14',NULL),(17,7561,40719,3,2,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',6600.00,NULL,NULL,1,'2022-11-25 15:17:14','2022-11-25 15:17:14',NULL),(18,7561,40719,3,2,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',1800.00,NULL,NULL,1,'2022-11-25 15:17:15','2022-11-25 15:17:15',NULL),(19,7561,40719,3,2,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',17000.00,NULL,NULL,1,'2022-11-25 15:17:15','2022-11-25 15:17:15',NULL),(20,7561,40719,3,2,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',3500.00,NULL,NULL,1,'2022-11-25 15:17:15','2022-11-25 15:17:15',NULL),(21,7561,40719,3,2,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',3500.00,NULL,NULL,1,'2022-11-25 15:17:15','2022-11-25 15:17:15',NULL),(22,7561,40719,4,2,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',118000.00,NULL,NULL,1,'2022-11-25 19:18:58','2022-11-25 19:18:58',NULL),(23,7561,40719,4,2,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',5500.00,NULL,NULL,1,'2022-11-25 19:18:58','2022-11-25 19:18:58',NULL),(24,7561,40719,4,2,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',6500.00,NULL,NULL,1,'2022-11-25 19:18:58','2022-11-25 19:18:58',NULL),(25,7561,40719,4,2,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',4000.00,NULL,NULL,1,'2022-11-25 19:18:58','2022-11-25 19:18:58',NULL),(26,7561,40719,4,2,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',3500.00,NULL,NULL,1,'2022-11-25 19:18:58','2022-11-25 19:18:58',NULL),(27,7561,40719,4,2,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',3500.00,NULL,NULL,1,'2022-11-25 19:18:58','2022-11-25 19:18:58',NULL),(28,7561,40719,4,2,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',27000.00,NULL,NULL,1,'2022-11-25 19:18:58','2022-11-25 19:18:58',NULL);
INSERT INTO `balance_libro` VALUES (29,7561,40719,5,2,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',4000.00,NULL,NULL,1,'2022-11-25 19:20:55','2022-11-25 19:20:55',NULL),(30,7561,40719,5,2,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',21500.00,NULL,NULL,1,'2022-11-25 19:20:55','2022-11-25 19:20:55',NULL),(31,7561,40719,5,2,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',5500.00,NULL,NULL,1,'2022-11-25 19:20:55','2022-11-25 19:20:55',NULL),(32,7561,40719,5,2,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',6500.00,NULL,NULL,1,'2022-11-25 19:20:56','2022-11-25 19:20:56',NULL),(33,7561,40719,5,2,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',142000.00,NULL,NULL,1,'2022-11-25 19:20:56','2022-11-25 19:20:56',NULL),(34,7561,40719,5,2,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',3600.00,NULL,NULL,1,'2022-11-25 19:20:56','2022-11-25 19:20:56',NULL),(35,7561,40719,5,2,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',3500.00,NULL,NULL,1,'2022-11-25 19:20:56','2022-11-25 19:20:56',NULL),(36,7561,40719,5,2,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',6600.00,NULL,NULL,1,'2022-11-25 19:20:56','2022-11-25 19:20:56',NULL),(37,7561,40719,6,2,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',142000.00,NULL,NULL,1,'2022-11-25 19:21:28','2022-11-25 19:21:28',NULL),(38,7561,40719,6,2,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',4000.00,NULL,NULL,1,'2022-11-25 19:21:28','2022-11-25 19:21:28',NULL),(39,7561,40719,6,2,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',5500.00,NULL,NULL,1,'2022-11-25 19:21:28','2022-11-25 19:21:28',NULL),(40,7561,40719,6,2,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',6500.00,NULL,NULL,1,'2022-11-25 19:21:28','2022-11-25 19:21:28',NULL),(41,7561,40719,6,2,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',6600.00,NULL,NULL,1,'2022-11-25 19:21:28','2022-11-25 19:21:28',NULL),(42,7561,40719,6,2,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',3600.00,NULL,NULL,1,'2022-11-25 19:21:28','2022-11-25 19:21:28',NULL),(43,7561,40719,6,2,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',21500.00,NULL,NULL,1,'2022-11-25 19:21:28','2022-11-25 19:21:28',NULL),(44,7561,40719,6,2,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',21500.00,NULL,NULL,1,'2022-11-25 19:21:28','2022-11-25 19:21:28',NULL),(45,7561,40719,7,2,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',142000.00,NULL,NULL,1,'2022-11-25 19:21:55','2022-11-25 19:21:55',NULL),(46,7561,40719,7,2,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',6500.00,NULL,NULL,1,'2022-11-25 19:21:55','2022-11-25 19:21:55',NULL),(47,7561,40719,7,2,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',5500.00,NULL,NULL,1,'2022-11-25 19:21:55','2022-11-25 19:21:55',NULL),(48,7561,40719,7,2,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',6600.00,NULL,NULL,1,'2022-11-25 19:21:55','2022-11-25 19:21:55',NULL),(49,7561,40719,7,2,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',4000.00,NULL,NULL,1,'2022-11-25 19:21:55','2022-11-25 19:21:55',NULL),(50,7561,40719,7,2,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',5500.00,NULL,NULL,1,'2022-11-25 19:21:55','2022-11-25 19:21:55',NULL);
INSERT INTO `balance_libro` VALUES (51,7561,40719,7,2,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',5500.00,NULL,NULL,1,'2022-11-25 19:21:55','2022-11-25 19:21:55',NULL),(52,7561,40719,7,2,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',21500.00,NULL,NULL,1,'2022-11-25 19:21:55','2022-11-25 19:21:55',NULL),(53,7561,40719,8,2,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',4000.00,NULL,NULL,1,'2022-11-25 19:24:36','2022-11-25 19:24:36',NULL),(54,7561,40719,8,2,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',170000.00,NULL,NULL,1,'2022-11-25 19:24:36','2022-11-25 19:24:36',NULL),(55,7561,40719,8,2,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',5500.00,NULL,NULL,1,'2022-11-25 19:24:36','2022-11-25 19:24:36',NULL),(56,7561,40719,8,2,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',6500.00,NULL,NULL,1,'2022-11-25 19:24:36','2022-11-25 19:24:36',NULL),(57,7561,40719,8,2,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',6600.00,NULL,NULL,1,'2022-11-25 19:24:36','2022-11-25 19:24:36',NULL),(58,7561,40719,8,2,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',24000.00,NULL,NULL,1,'2022-11-25 19:24:36','2022-11-25 19:24:36',NULL),(63,7561,40719,9,2,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',4000.00,NULL,NULL,1,'2022-11-25 19:29:15','2022-11-25 19:29:15',NULL),(64,7561,40719,9,2,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',170000.00,NULL,NULL,1,'2022-11-25 19:29:15','2022-11-25 19:29:15',NULL),(65,7561,40719,9,2,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',5500.00,NULL,NULL,1,'2022-11-25 19:29:15','2022-11-25 19:29:15',NULL),(66,7561,40719,9,2,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',6500.00,NULL,NULL,1,'2022-11-25 19:29:15','2022-11-25 19:29:15',NULL),(67,7561,40719,9,2,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',6600.00,NULL,NULL,1,'2022-11-25 19:29:15','2022-11-25 19:29:15',NULL),(68,7561,40719,9,2,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',43000.00,NULL,NULL,1,'2022-11-25 19:29:15','2022-11-25 19:29:15',NULL),(69,7561,40719,9,2,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5500.00,NULL,NULL,1,'2022-11-25 19:29:15','2022-11-25 19:29:15',NULL),(70,7561,40719,9,2,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5500.00,NULL,NULL,1,'2022-11-25 19:29:15','2022-11-25 19:29:15',NULL),(71,7561,40719,12,2,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',4000.00,NULL,NULL,1,'2022-11-25 19:41:06','2022-11-25 19:50:43','2022-11-25 19:50:43'),(72,7561,40719,12,2,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',170000.00,NULL,NULL,1,'2022-11-25 19:41:06','2022-11-25 19:51:23','2022-11-25 19:51:23'),(73,7561,40719,12,2,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',6500.00,NULL,NULL,1,'2022-11-25 19:41:06','2022-11-25 19:51:36','2022-11-25 19:51:36'),(74,7561,40719,12,2,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',5500.00,NULL,NULL,1,'2022-11-25 19:41:06','2022-11-25 19:52:11','2022-11-25 19:52:11'),(75,7561,40719,12,2,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',27500.00,NULL,NULL,1,'2022-11-25 19:41:06','2022-11-25 19:52:06','2022-11-25 19:52:06');
INSERT INTO `balance_libro` VALUES (76,7561,40719,12,2,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',6000.00,NULL,NULL,1,'2022-11-25 19:41:06','2022-11-25 19:51:56','2022-11-25 19:51:56'),(77,7561,40719,12,2,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',11000.00,NULL,NULL,1,'2022-11-25 19:41:06','2022-11-25 19:51:13','2022-11-25 19:51:13'),(78,7561,40719,12,2,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',27000.00,NULL,NULL,1,'2022-11-25 19:41:06','2022-11-25 19:51:03','2022-11-25 19:51:03'),(79,7561,40719,12,2,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',194000.00,NULL,NULL,1,'2022-11-25 19:41:06','2022-11-25 19:50:51','2022-11-25 19:50:51'),(80,7561,40719,11,2,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',4000.00,NULL,NULL,1,'2022-11-26 10:12:13','2022-11-26 10:12:13',NULL),(81,7561,40719,11,2,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',170000.00,NULL,NULL,1,'2022-11-26 10:12:13','2022-11-26 10:12:13',NULL),(82,7561,40719,11,2,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',6500.00,NULL,NULL,1,'2022-11-26 10:12:13','2022-11-26 10:12:13',NULL),(83,7561,40719,11,2,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',5500.00,NULL,NULL,1,'2022-11-26 10:12:13','2022-11-26 10:12:13',NULL),(84,7561,40719,11,2,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',27500.00,NULL,NULL,1,'2022-11-26 10:12:13','2022-11-26 10:12:13',NULL),(85,7561,40719,11,2,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',6000.00,NULL,NULL,1,'2022-11-26 10:12:14','2022-11-26 10:12:14',NULL),(86,7561,40719,11,2,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',11000.00,NULL,NULL,1,'2022-11-26 10:12:14','2022-11-26 10:12:14',NULL),(87,7561,40719,11,2,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',27000.00,NULL,NULL,1,'2022-11-26 10:12:14','2022-11-26 10:12:14',NULL),(88,7561,40719,11,2,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',194000.00,NULL,NULL,1,'2022-11-26 10:12:14','2022-11-26 10:12:14',NULL),(92,7561,40719,12,2,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',4000.00,NULL,NULL,1,'2022-11-26 10:23:33','2022-11-26 10:23:33',NULL),(93,7561,40719,12,2,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',27000.00,NULL,NULL,1,'2022-11-26 10:23:33','2022-11-26 10:23:33',NULL),(94,7561,40719,12,2,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',12000.00,NULL,NULL,1,'2022-11-26 10:23:33','2022-11-26 10:23:33',NULL),(95,7561,40719,12,2,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',8000.00,NULL,NULL,1,'2022-11-26 10:23:33','2022-11-26 10:23:33',NULL),(96,7561,40719,12,2,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',11900.00,NULL,NULL,1,'2022-11-26 10:23:33','2022-11-26 10:23:33',NULL),(97,7561,40719,12,2,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',11900.00,NULL,NULL,1,'2022-11-26 10:23:33','2022-11-26 10:23:33',NULL),(98,7561,40719,12,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4000.00,NULL,NULL,1,'2022-11-26 10:23:33','2022-11-26 10:23:33',NULL),(99,7561,40719,12,2,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',208550.00,NULL,NULL,1,'2022-11-26 10:23:33','2022-11-26 10:23:33',NULL);
INSERT INTO `balance_libro` VALUES (103,7561,40727,1525,2,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',113500.30,NULL,NULL,1,'2022-12-17 09:59:51','2022-12-20 11:47:07','2022-12-20 11:47:07'),(104,7561,40727,1525,2,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',114345.00,NULL,NULL,1,'2022-12-17 09:59:51','2022-12-20 11:45:00','2022-12-20 11:45:00'),(105,7561,40727,1525,2,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',61831.00,NULL,NULL,1,'2022-12-17 09:59:51','2022-12-20 11:40:19','2022-12-20 11:40:19'),(106,7561,40727,1525,2,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',27000.00,NULL,NULL,1,'2022-12-17 09:59:51','2022-12-20 11:38:41','2022-12-20 11:38:41'),(107,7561,40727,1525,2,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',103000.04,NULL,NULL,1,'2022-12-17 09:59:51','2022-12-20 11:37:25','2022-12-20 11:37:25'),(108,7561,40727,1525,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',138908.00,NULL,NULL,1,'2022-12-17 09:59:51','2022-12-20 11:34:30','2022-12-20 11:34:30'),(109,7561,40727,1525,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',165000.44,NULL,NULL,1,'2022-12-17 09:59:51','2022-12-20 11:32:17','2022-12-20 11:32:17'),(110,7561,40727,1525,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',97000.00,NULL,NULL,1,'2022-12-17 09:59:51','2022-12-20 11:31:13','2022-12-20 11:31:13'),(111,7561,40727,1525,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',53000.00,NULL,NULL,1,'2022-12-17 09:59:51','2022-12-20 11:23:59','2022-12-20 11:23:59'),(112,7561,40727,1525,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',42350.00,NULL,NULL,1,'2022-12-17 09:59:51','2022-12-20 11:22:44','2022-12-20 11:22:44'),(113,7561,40727,1525,2,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',114000.00,NULL,NULL,1,'2022-12-17 09:59:51','2022-12-17 09:59:51',NULL),(114,7561,40727,1525,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',70000.00,NULL,NULL,1,'2022-12-17 09:59:51','2022-12-20 11:15:50','2022-12-20 11:15:50'),(115,7561,40727,1525,2,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',107350.31,NULL,NULL,1,'2022-12-17 09:59:51','2022-12-20 11:09:44','2022-12-20 11:09:44'),(116,7561,40727,1525,2,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',43560.00,NULL,NULL,1,'2022-12-17 09:59:51','2022-12-17 10:06:17','2022-12-17 10:06:17'),(117,7561,40727,1525,2,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',141570.00,NULL,NULL,1,'2022-12-17 09:59:51','2022-12-17 10:05:46','2022-12-17 10:05:46'),(118,7561,40727,1525,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',69000.00,NULL,NULL,1,'2022-12-17 09:59:51','2022-12-17 10:05:06','2022-12-17 10:05:06'),(119,7561,40727,1525,2,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',26257.00,NULL,NULL,1,'2022-12-17 09:59:51','2022-12-17 10:03:50','2022-12-17 10:03:50'),(120,7561,40727,1525,3,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',61812.85,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-20 18:41:00','2022-12-20 18:41:00'),(121,7561,40727,1525,3,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',6000.00,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-20 12:27:00','2022-12-20 12:27:00');
INSERT INTO `balance_libro` VALUES (122,7561,40727,1525,3,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',91170.09,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-20 18:39:42','2022-12-20 18:39:42'),(123,7561,40727,1525,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',20430.00,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-20 18:42:36','2022-12-20 18:42:36'),(124,7561,40727,1525,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',24103.20,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-20 18:31:32','2022-12-20 18:31:32'),(125,7561,40727,1525,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',4683.76,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-20 18:30:06','2022-12-20 18:30:06'),(126,7561,40727,1525,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',26365.91,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-20 18:27:24','2022-12-20 18:27:24'),(127,7561,40727,1525,3,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',26365.91,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-20 18:26:31','2022-12-20 18:26:31'),(128,7561,40727,1525,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',35825.66,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-20 18:28:42','2022-12-20 18:28:42'),(129,7561,40727,1525,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',23814.25,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-20 18:24:03','2022-12-20 18:24:03'),(130,7561,40727,1525,3,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',44837.41,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-20 18:25:46','2022-12-20 18:25:46'),(131,7561,40727,1525,3,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',69328.16,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-20 18:25:01','2022-12-20 18:25:01'),(132,7561,40727,1525,3,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',37536.95,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-17 10:02:44',NULL),(133,7561,40727,1525,3,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',74767.11,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-20 12:28:26','2022-12-20 12:28:26'),(134,7561,40727,1525,3,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',2874.18,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-17 10:02:44',NULL),(135,7561,40727,1525,3,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',59947.03,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-20 12:23:12','2022-12-20 12:23:12'),(136,7561,40727,1525,3,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',39784.03,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-20 12:25:00','2022-12-20 12:25:00'),(137,7561,40727,1525,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',2123.55,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-20 12:22:28','2022-12-20 12:22:28'),(138,7561,40727,1525,3,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',23357.16,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-20 12:21:46','2022-12-20 12:21:46'),(139,7561,40727,1525,3,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',2571.94,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-17 10:02:44',NULL),(140,7561,40727,1525,3,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',37219.60,NULL,NULL,1,'2022-12-17 10:02:44','2022-12-20 12:20:55','2022-12-20 12:20:55');
INSERT INTO `balance_libro` VALUES (141,7561,40727,1525,3,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',25621.29,NULL,NULL,1,'2022-12-17 10:02:45','2022-12-20 12:11:19','2022-12-20 12:11:19'),(142,7561,40727,1525,3,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',28845.06,NULL,NULL,1,'2022-12-17 10:02:45','2022-12-17 10:02:45',NULL),(143,7561,40727,1525,3,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',1329.00,NULL,NULL,1,'2022-12-17 10:02:45','2022-12-20 12:13:27','2022-12-20 12:13:27'),(144,7561,40727,1525,3,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',21118.44,NULL,NULL,1,'2022-12-17 10:02:45','2022-12-20 12:08:30','2022-12-20 12:08:30'),(145,7561,40727,1525,3,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',34977.47,NULL,NULL,1,'2022-12-17 10:02:45','2022-12-20 12:07:25','2022-12-20 12:07:25'),(146,7561,40727,1525,3,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',25816.11,NULL,NULL,1,'2022-12-17 10:02:45','2022-12-20 12:03:25','2022-12-20 12:03:25'),(147,7561,40727,1525,3,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',3300.00,NULL,NULL,1,'2022-12-17 10:02:45','2022-12-20 12:01:50','2022-12-20 12:01:50'),(148,7561,40727,1525,3,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',60391.03,NULL,NULL,1,'2022-12-17 10:02:45','2022-12-20 12:00:43','2022-12-20 12:00:43'),(149,7561,40727,1525,3,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',13647.64,NULL,NULL,1,'2022-12-17 10:02:45','2022-12-20 12:00:06','2022-12-20 12:00:06'),(150,7561,40727,1525,3,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',13000.00,NULL,NULL,1,'2022-12-17 10:02:45','2022-12-20 11:59:21','2022-12-20 11:59:21'),(151,7561,40727,1525,3,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',37053.06,NULL,NULL,1,'2022-12-17 10:02:45','2022-12-20 11:57:10','2022-12-20 11:57:10'),(152,7561,40727,1525,3,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5856.49,NULL,NULL,1,'2022-12-17 10:02:45','2022-12-20 11:50:10','2022-12-20 11:50:10'),(153,7561,40727,1525,2,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',26257.00,NULL,NULL,1,'2022-12-17 10:03:50','2022-12-17 10:04:16','2022-12-17 10:04:16'),(154,7561,40727,1525,2,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',26257.00,NULL,NULL,1,'2022-12-17 10:04:16','2022-12-20 11:07:20','2022-12-20 11:07:20'),(155,7561,40727,1525,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',69000.00,NULL,NULL,1,'2022-12-17 10:05:06','2022-12-17 10:06:46','2022-12-17 10:06:46'),(156,7561,40727,1525,2,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',141570.00,NULL,NULL,1,'2022-12-17 10:05:46','2022-12-20 11:08:24','2022-12-20 11:08:24'),(157,7561,40727,1525,2,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',43560.00,NULL,NULL,1,'2022-12-17 10:06:17','2022-12-20 11:08:40','2022-12-20 11:08:40'),(158,7561,40727,1525,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',69000.00,NULL,NULL,1,'2022-12-17 10:06:46','2022-12-19 15:35:11','2022-12-19 15:35:11'),(159,7561,40725,3037,3,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',83673.59,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-19 18:41:58','2022-12-19 18:41:58');
INSERT INTO `balance_libro` VALUES (160,7561,40725,3037,3,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',990.00,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-19 18:41:46','2022-12-19 18:41:46'),(161,7561,40725,3037,3,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',7100.00,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-19 18:17:07','2022-12-19 18:17:07'),(162,7561,40725,3037,3,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1667.75,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-17 10:13:58',NULL),(163,7561,40725,3037,3,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',105346.59,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-19 18:47:18','2022-12-19 18:47:18'),(164,7561,40725,3037,3,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',84999.01,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-19 19:29:26','2022-12-19 19:29:26'),(165,7561,40725,3037,3,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',723731.25,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-19 18:51:22','2022-12-19 18:51:22'),(166,7561,40725,3037,3,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',79999.00,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-19 19:29:47','2022-12-19 19:29:47'),(167,7561,40725,3037,3,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',136.00,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-17 10:13:58',NULL),(168,7561,40725,3037,3,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',136.00,NULL,NULL,1,'2022-12-17 10:13:58','2023-04-21 17:38:56','2023-04-21 17:38:56'),(169,7561,40725,3037,3,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',1447.83,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-19 18:48:13','2022-12-19 18:48:13'),(170,7561,40725,3037,3,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',4120.71,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-19 18:50:32','2022-12-19 18:50:32'),(171,7561,40725,3037,3,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',0.00,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-17 10:13:58',NULL),(172,7561,40725,3037,3,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',201900.60,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-19 18:45:41','2022-12-19 18:45:41'),(173,7561,40725,3037,3,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',742.50,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-19 18:21:19','2022-12-19 18:21:19'),(174,7561,40725,3037,3,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',567954.16,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-19 18:46:28','2022-12-19 18:46:28'),(175,7561,40725,3037,3,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',15817.41,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-19 18:49:03','2022-12-19 18:49:03'),(176,7561,40725,3037,3,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',36818.85,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-19 18:44:53','2022-12-19 18:44:53'),(177,7561,40725,3037,3,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',54272.74,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-19 18:49:54','2022-12-19 18:49:54'),(178,7561,40725,3037,3,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',196721.80,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-19 18:52:15','2022-12-19 18:52:15'),(179,7561,40725,3037,3,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',68.00,NULL,NULL,1,'2022-12-17 10:13:58','2022-12-17 10:13:58',NULL);
INSERT INTO `balance_libro` VALUES (180,7561,40725,3037,3,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',88.49,NULL,NULL,1,'2022-12-17 10:13:59','2022-12-17 10:13:59',NULL),(181,7561,40725,3037,3,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',1800.00,NULL,NULL,1,'2022-12-17 10:13:59','2022-12-19 19:29:03','2022-12-19 19:29:03'),(182,7561,40725,3037,3,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',350.00,NULL,NULL,1,'2022-12-17 10:13:59','2022-12-19 19:28:53','2022-12-19 19:28:53'),(183,7561,40725,3037,3,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',1150.00,NULL,NULL,1,'2022-12-17 10:13:59','2022-12-19 19:28:45','2022-12-19 19:28:45'),(184,7561,40725,3037,3,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',1150.00,NULL,NULL,1,'2022-12-17 10:13:59','2022-12-19 19:28:34','2022-12-19 19:28:34'),(185,7561,40725,3037,3,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',1199.00,NULL,NULL,1,'2022-12-17 10:13:59','2022-12-17 10:13:59',NULL),(186,7561,40725,3037,3,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',84999.01,NULL,NULL,1,'2022-12-17 10:13:59','2022-12-19 18:52:53','2022-12-19 18:52:53'),(187,7561,40725,3037,3,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',84999.01,NULL,NULL,1,'2022-12-17 10:13:59','2022-12-19 18:52:46','2022-12-19 18:52:46'),(188,7561,40725,3037,3,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',10572.98,NULL,NULL,1,'2022-12-17 10:13:59','2022-12-19 17:53:02','2022-12-19 17:53:02'),(189,7561,40725,3037,3,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',33000.00,NULL,NULL,1,'2022-12-17 10:13:59','2022-12-17 10:16:03','2022-12-17 10:16:03'),(190,7561,40725,3037,2,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',32227.14,NULL,NULL,1,'2022-12-17 10:14:30','2022-12-17 10:38:33','2022-12-17 10:38:33'),(191,7561,40725,3037,2,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',244444.20,NULL,NULL,1,'2022-12-17 10:14:30','2022-12-17 10:14:30',NULL),(192,7561,40725,3037,2,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',42797.70,NULL,NULL,1,'2022-12-17 10:14:30','2022-12-17 10:14:30',NULL),(193,7561,40725,3037,2,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',55889.90,NULL,NULL,1,'2022-12-17 10:14:30','2023-04-22 12:01:43','2023-04-22 12:01:43'),(194,7561,40725,3037,2,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',142243.74,NULL,NULL,1,'2022-12-17 10:14:30','2022-12-17 10:14:30',NULL),(195,7561,40725,3037,2,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',126396.60,NULL,NULL,1,'2022-12-17 10:14:30','2022-12-17 10:14:30',NULL),(196,7561,40725,3037,2,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',115260.00,NULL,NULL,1,'2022-12-17 10:14:30','2023-04-22 12:01:10','2023-04-22 12:01:10'),(197,7561,40725,3037,2,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',7961.80,NULL,NULL,1,'2022-12-17 10:14:30','2022-12-17 10:37:49','2022-12-17 10:37:49'),(198,7561,40725,3037,2,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',13991.67,NULL,NULL,1,'2022-12-17 10:14:30','2022-12-17 10:14:30',NULL),(199,7561,40725,3037,2,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',181127.89,NULL,NULL,1,'2022-12-17 10:14:30','2022-12-17 10:14:30',NULL);
INSERT INTO `balance_libro` VALUES (200,7561,40725,3037,2,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',112137.04,NULL,NULL,1,'2022-12-17 10:14:30','2022-12-17 10:14:30',NULL),(201,7561,40725,3037,2,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',112079.27,NULL,NULL,1,'2022-12-17 10:14:30','2023-04-26 11:51:18','2023-04-26 11:51:18'),(202,7561,40725,3037,2,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',123807.20,NULL,NULL,1,'2022-12-17 10:14:30','2022-12-17 10:14:30',NULL),(203,7561,40725,3037,2,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',249018.00,NULL,NULL,1,'2022-12-17 10:14:30','2022-12-17 10:14:30',NULL),(204,7561,40725,3037,2,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',71699.76,NULL,NULL,1,'2022-12-17 10:14:30','2022-12-17 10:35:56','2022-12-17 10:35:56'),(205,7561,40725,3037,2,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',23353.00,NULL,NULL,1,'2022-12-17 10:14:31','2022-12-17 10:14:31',NULL),(206,7561,40725,3037,2,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',193582.45,NULL,NULL,1,'2022-12-17 10:14:31','2022-12-17 10:14:31',NULL),(207,7561,40725,3037,2,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',83490.00,NULL,NULL,1,'2022-12-17 10:14:31','2022-12-17 10:37:14','2022-12-17 10:37:14'),(208,7561,40725,3037,2,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',12886.50,NULL,NULL,1,'2022-12-17 10:14:31','2022-12-17 10:36:36','2022-12-17 10:36:36'),(209,7561,40725,3037,2,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',55690.25,NULL,NULL,1,'2022-12-17 10:14:31','2023-04-22 12:14:07','2023-04-22 12:14:07'),(210,7561,40725,3037,2,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',47165.30,NULL,NULL,1,'2022-12-17 10:14:31','2022-12-17 10:14:31',NULL),(211,7561,40725,3037,2,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',111994.45,NULL,NULL,1,'2022-12-17 10:14:31','2022-12-17 10:14:31',NULL),(212,7561,40725,3037,3,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',33000.00,NULL,NULL,1,'2022-12-17 10:16:03','2022-12-19 17:52:25','2022-12-19 17:52:25'),(213,7561,40725,3037,2,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',71699.76,NULL,NULL,1,'2022-12-17 10:35:56','2022-12-17 10:37:27','2022-12-17 10:37:27'),(214,7561,40725,3037,2,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',12886.50,NULL,NULL,1,'2022-12-17 10:36:36','2022-12-17 10:36:59','2022-12-17 10:36:59'),(215,7561,40725,3037,2,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',12886.50,NULL,NULL,1,'2022-12-17 10:36:59','2023-04-22 12:14:26','2023-04-22 12:14:26'),(216,7561,40725,3037,2,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',83490.00,NULL,NULL,1,'2022-12-17 10:37:14','2022-12-17 10:37:14',NULL),(217,7561,40725,3037,2,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',71699.76,NULL,NULL,1,'2022-12-17 10:37:27','2022-12-17 10:37:27',NULL),(218,7561,40725,3037,2,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',7961.80,NULL,NULL,1,'2022-12-17 10:37:49','2022-12-17 10:38:10','2022-12-17 10:38:10'),(219,7561,40725,3037,2,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',7961.80,NULL,NULL,1,'2022-12-17 10:38:10','2022-12-17 10:38:10',NULL);
INSERT INTO `balance_libro` VALUES (220,7561,40725,3037,2,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',32227.14,NULL,NULL,1,'2022-12-17 10:38:33','2022-12-17 10:38:33',NULL),(221,7561,40719,13,2,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',10000.00,NULL,NULL,1,'2022-12-17 10:45:21','2022-12-17 10:45:21',NULL),(222,7561,40719,13,2,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',223100.00,NULL,NULL,1,'2022-12-17 10:45:21','2022-12-17 10:45:21',NULL),(223,7561,40719,13,2,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',12000.00,NULL,NULL,1,'2022-12-17 10:45:21','2022-12-17 10:45:21',NULL),(224,7561,40719,13,2,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',8000.00,NULL,NULL,1,'2022-12-17 10:45:21','2022-12-17 10:45:21',NULL),(225,7561,40719,13,2,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',11900.00,NULL,NULL,1,'2022-12-17 10:45:21','2022-12-17 10:45:21',NULL),(226,7561,40719,13,2,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',11900.00,NULL,NULL,1,'2022-12-17 10:45:21','2022-12-17 10:45:21',NULL),(227,7561,40719,13,2,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',4000.00,NULL,NULL,1,'2022-12-17 10:45:21','2022-12-17 10:45:21',NULL),(228,7561,40719,13,2,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',33000.00,NULL,NULL,1,'2022-12-17 10:45:21','2022-12-17 10:45:21',NULL),(229,7561,40727,1525,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',69000.00,NULL,NULL,1,'2022-12-19 15:35:11','2022-12-19 15:54:00','2022-12-19 15:54:00'),(230,7561,40727,1525,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',69000.00,NULL,NULL,1,'2022-12-19 15:54:00','2022-12-20 11:07:58','2022-12-20 11:07:58'),(231,7561,40725,3037,3,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',33000.00,NULL,NULL,1,'2022-12-19 17:52:25','2022-12-19 17:52:25',NULL),(232,7561,40725,3037,3,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',10572.98,NULL,NULL,1,'2022-12-19 17:53:02','2022-12-19 18:43:10','2022-12-19 18:43:10'),(233,7561,40725,3037,3,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',6601.82,NULL,NULL,1,'2022-12-19 18:00:43','2022-12-19 18:00:43',NULL),(234,7561,40725,3037,3,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',3999.97,NULL,NULL,1,'2022-12-19 18:02:36','2022-12-19 18:02:36',NULL),(235,7561,40725,3037,3,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',2999.93,NULL,NULL,1,'2022-12-19 18:04:23','2022-12-19 18:04:23',NULL),(236,7561,40725,3037,3,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',3999.92,NULL,NULL,1,'2022-12-19 18:12:42','2022-12-19 18:12:42',NULL),(237,7561,40725,3037,3,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',7100.00,NULL,NULL,1,'2022-12-19 18:17:07','2022-12-19 19:09:38','2022-12-19 19:09:38'),(238,7561,40725,3037,3,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',3499.92,NULL,NULL,1,'2022-12-19 18:20:15','2022-12-19 18:20:15',NULL),(239,7561,40725,3037,3,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',742.50,NULL,NULL,1,'2022-12-19 18:21:19','2022-12-19 18:21:19',NULL),(240,7561,40725,3037,3,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',5037.44,NULL,NULL,1,'2022-12-19 18:28:42','2022-12-19 19:37:21','2022-12-19 19:37:21');
INSERT INTO `balance_libro` VALUES (241,7561,40725,3037,3,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',10572.98,NULL,NULL,1,'2022-12-19 18:43:10','2022-12-19 18:43:10',NULL),(242,7561,40725,3037,3,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',36818.85,NULL,NULL,1,'2022-12-19 18:44:53','2022-12-19 18:44:53',NULL),(243,7561,40725,3037,3,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',201900.60,NULL,NULL,1,'2022-12-19 18:45:41','2022-12-19 18:45:41',NULL),(244,7561,40725,3037,3,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',567954.16,NULL,NULL,1,'2022-12-19 18:46:28','2022-12-19 18:46:28',NULL),(245,7561,40725,3037,3,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',105346.59,NULL,NULL,1,'2022-12-19 18:47:18','2022-12-19 18:47:18',NULL),(246,7561,40725,3037,3,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',1447.83,NULL,NULL,1,'2022-12-19 18:48:13','2022-12-20 08:13:30','2022-12-20 08:13:30'),(247,7561,40725,3037,3,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',15817.41,NULL,NULL,1,'2022-12-19 18:49:03','2022-12-19 18:49:03',NULL),(248,7561,40725,3037,3,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',54272.74,NULL,NULL,1,'2022-12-19 18:49:54','2022-12-19 18:49:54',NULL),(249,7561,40725,3037,3,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',4120.72,NULL,NULL,1,'2022-12-19 18:50:32','2022-12-19 18:50:32',NULL),(250,7561,40725,3037,3,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',723731.25,NULL,NULL,1,'2022-12-19 18:51:22','2022-12-19 18:51:22',NULL),(251,7561,40725,3037,3,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',196721.80,NULL,NULL,1,'2022-12-19 18:52:15','2022-12-19 18:52:15',NULL),(252,7561,40725,3037,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3084.25,NULL,NULL,1,'2022-12-19 18:56:53','2022-12-19 19:36:46','2022-12-19 19:36:46'),(253,7561,40725,3037,3,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',7100.00,NULL,NULL,1,'2022-12-19 19:09:38','2022-12-19 19:09:38',NULL),(254,7561,40725,3037,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3084.25,NULL,NULL,1,'2022-12-19 19:36:46','2022-12-19 19:36:46',NULL),(255,7561,40725,3037,3,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',5037.44,NULL,NULL,1,'2022-12-19 19:37:21','2022-12-19 19:37:21',NULL),(256,7561,40725,3037,3,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',1447.83,NULL,NULL,1,'2022-12-20 08:13:30','2022-12-21 16:30:48','2022-12-21 16:30:48'),(257,7561,40725,3037,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',3999.92,NULL,NULL,1,'2022-12-20 09:36:34','2022-12-20 09:36:34',NULL),(258,7561,40727,1525,2,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',26257.00,NULL,NULL,1,'2022-12-20 11:07:20','2022-12-20 11:07:20',NULL),(259,7561,40727,1525,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',69000.00,NULL,NULL,1,'2022-12-20 11:07:58','2022-12-20 11:07:58',NULL),(260,7561,40727,1525,2,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',141570.00,NULL,NULL,1,'2022-12-20 11:08:24','2022-12-20 11:08:24',NULL),(261,7561,40727,1525,2,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',43560.00,NULL,NULL,1,'2022-12-20 11:08:40','2022-12-20 11:08:40',NULL);
INSERT INTO `balance_libro` VALUES (262,7561,40727,1525,2,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',107350.32,NULL,NULL,1,'2022-12-20 11:09:44','2022-12-20 11:10:14','2022-12-20 11:10:14'),(263,7561,40727,1525,2,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',107350.32,NULL,NULL,1,'2022-12-20 11:10:14','2022-12-20 11:10:14',NULL),(264,7561,40727,1525,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',70000.00,NULL,NULL,1,'2022-12-20 11:15:50','2022-12-20 11:15:50',NULL),(265,7561,40727,1525,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',42350.00,NULL,NULL,1,'2022-12-20 11:22:44','2022-12-20 11:22:44',NULL),(266,7561,40727,1525,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',53000.00,NULL,NULL,1,'2022-12-20 11:23:59','2022-12-20 11:29:26','2022-12-20 11:29:26'),(267,7561,40727,1525,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',53000.00,NULL,NULL,1,'2022-12-20 11:29:26','2022-12-20 11:29:26',NULL),(268,7561,40727,1525,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',97000.00,NULL,NULL,1,'2022-12-20 11:31:13','2022-12-20 11:31:13',NULL),(269,7561,40727,1525,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',165000.44,NULL,NULL,1,'2022-12-20 11:32:17','2022-12-20 11:32:17',NULL),(270,7561,40727,1525,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',138908.00,NULL,NULL,1,'2022-12-20 11:34:30','2022-12-20 11:34:59','2022-12-20 11:34:59'),(271,7561,40727,1525,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',138908.00,NULL,NULL,1,'2022-12-20 11:34:59','2022-12-20 11:34:59',NULL),(272,7561,40727,1525,2,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',103000.04,NULL,NULL,1,'2022-12-20 11:37:25','2022-12-20 11:37:25',NULL),(273,7561,40727,1525,2,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',27000.00,NULL,NULL,1,'2022-12-20 11:38:41','2022-12-20 11:38:41',NULL),(274,7561,40727,1525,2,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',61831.00,NULL,NULL,1,'2022-12-20 11:40:19','2022-12-20 11:40:19',NULL),(275,7561,40727,1525,2,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',114345.00,NULL,NULL,1,'2022-12-20 11:45:00','2022-12-20 11:45:00',NULL),(276,7561,40727,1525,2,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',113500.30,NULL,NULL,1,'2022-12-20 11:47:07','2022-12-20 11:47:07',NULL),(277,7561,40727,1525,3,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5880.59,NULL,NULL,1,'2022-12-20 11:50:10','2022-12-20 11:50:39','2022-12-20 11:50:39'),(278,7561,40727,1525,3,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5856.01,NULL,NULL,1,'2022-12-20 11:50:39','2022-12-20 11:51:00','2022-12-20 11:51:00'),(279,7561,40727,1525,3,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5856.49,NULL,NULL,1,'2022-12-20 11:51:00','2022-12-20 11:51:00',NULL),(280,7561,40727,1525,3,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',37053.06,NULL,NULL,1,'2022-12-20 11:57:10','2022-12-20 11:57:10',NULL),(281,7561,40727,1525,3,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',13000.00,NULL,NULL,1,'2022-12-20 11:59:21','2022-12-20 11:59:21',NULL);
INSERT INTO `balance_libro` VALUES (282,7561,40727,1525,3,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',13647.64,NULL,NULL,1,'2022-12-20 12:00:06','2022-12-20 12:00:06',NULL),(283,7561,40727,1525,3,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',60391.03,NULL,NULL,1,'2022-12-20 12:00:43','2022-12-20 12:00:43',NULL),(284,7561,40727,1525,3,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',3300.00,NULL,NULL,1,'2022-12-20 12:01:50','2022-12-20 12:01:50',NULL),(285,7561,40727,1525,3,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',25816.11,NULL,NULL,1,'2022-12-20 12:03:25','2022-12-20 12:03:25',NULL),(286,7561,40727,1525,3,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',34977.47,NULL,NULL,1,'2022-12-20 12:07:25','2022-12-20 12:07:25',NULL),(287,7561,40727,1525,3,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',21207.07,NULL,NULL,1,'2022-12-20 12:08:30','2022-12-20 12:09:04','2022-12-20 12:09:04'),(288,7561,40727,1525,3,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',21207.07,NULL,NULL,1,'2022-12-20 12:09:04','2022-12-20 12:09:54','2022-12-20 12:09:54'),(289,7561,40727,1525,3,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',21207.07,NULL,NULL,1,'2022-12-20 12:09:54','2022-12-20 12:10:28','2022-12-20 12:10:28'),(290,7561,40727,1525,3,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',21118.44,NULL,NULL,1,'2022-12-20 12:10:28','2022-12-20 12:10:28',NULL),(291,7561,40727,1525,3,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',25621.29,NULL,NULL,1,'2022-12-20 12:11:19','2022-12-20 12:11:19',NULL),(292,7561,40727,1525,3,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',1329.00,NULL,NULL,1,'2022-12-20 12:13:27','2022-12-20 12:13:27',NULL),(293,7561,40727,1525,3,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',37219.60,NULL,NULL,1,'2022-12-20 12:20:55','2022-12-20 12:20:55',NULL),(294,7561,40727,1525,3,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',23357.16,NULL,NULL,1,'2022-12-20 12:21:46','2022-12-20 12:21:46',NULL),(295,7561,40727,1525,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',2123.55,NULL,NULL,1,'2022-12-20 12:22:28','2022-12-20 12:22:28',NULL),(296,7561,40727,1525,3,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',59947.03,NULL,NULL,1,'2022-12-20 12:23:12','2022-12-20 12:23:12',NULL),(297,7561,40727,1525,3,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',39951.01,NULL,NULL,1,'2022-12-20 12:25:00','2022-12-20 12:25:43','2022-12-20 12:25:43'),(298,7561,40727,1525,3,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',39784.03,NULL,NULL,1,'2022-12-20 12:25:43','2022-12-20 12:25:43',NULL),(299,7561,40727,1525,3,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',6000.00,NULL,NULL,1,'2022-12-20 12:27:00','2022-12-20 12:27:00',NULL),(300,7561,40727,1525,3,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',74767.11,NULL,NULL,1,'2022-12-20 12:28:26','2022-12-20 12:28:26',NULL),(301,7561,40727,1525,2,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',3403.34,NULL,NULL,1,'2022-12-20 18:12:40','2022-12-21 08:08:18','2022-12-21 08:08:18');
INSERT INTO `balance_libro` VALUES (302,7561,40727,1525,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',31.69,NULL,NULL,1,'2022-12-20 18:20:54','2022-12-21 08:21:56','2022-12-21 08:21:56'),(303,7561,40727,1525,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',23814.25,NULL,NULL,1,'2022-12-20 18:24:03','2022-12-20 18:24:03',NULL),(304,7561,40727,1525,3,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',69328.16,NULL,NULL,1,'2022-12-20 18:25:01','2022-12-20 18:25:01',NULL),(305,7561,40727,1525,3,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',44837.41,NULL,NULL,1,'2022-12-20 18:25:46','2022-12-20 18:25:46',NULL),(306,7561,40727,1525,3,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',26365.91,NULL,NULL,1,'2022-12-20 18:26:31','2022-12-20 18:26:31',NULL),(307,7561,40727,1525,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',26365.91,NULL,NULL,1,'2022-12-20 18:27:24','2022-12-20 18:27:24',NULL),(308,7561,40727,1525,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',35825.66,NULL,NULL,1,'2022-12-20 18:28:42','2022-12-20 18:28:42',NULL),(309,7561,40727,1525,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',4683.76,NULL,NULL,1,'2022-12-20 18:30:06','2022-12-20 18:30:06',NULL),(310,7561,40727,1525,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',24103.20,NULL,NULL,1,'2022-12-20 18:31:32','2022-12-20 18:31:32',NULL),(311,7561,40727,1525,3,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',2000.19,NULL,NULL,1,'2022-12-20 18:34:46','2023-01-10 19:42:12','2023-01-10 19:42:12'),(312,7561,40727,1525,3,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',91552.75,NULL,NULL,1,'2022-12-20 18:39:42','2022-12-20 18:40:12','2022-12-20 18:40:12'),(313,7561,40727,1525,3,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',91170.09,NULL,NULL,1,'2022-12-20 18:40:12','2022-12-20 18:40:12',NULL),(314,7561,40727,1525,3,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',61812.85,NULL,NULL,1,'2022-12-20 18:41:00','2022-12-20 18:41:00',NULL),(315,7561,40727,1525,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',20430.00,NULL,NULL,1,'2022-12-20 18:42:36','2022-12-20 18:42:36',NULL),(316,7561,40727,1525,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',3403.34,NULL,NULL,1,'2022-12-21 08:21:56','2022-12-21 08:21:56',NULL),(317,7561,40725,3037,3,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',1447.83,NULL,NULL,1,'2022-12-21 16:30:48','2022-12-21 16:30:48',NULL),(318,7561,40719,14,2,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',234000.00,NULL,NULL,1,'2023-01-05 18:53:32','2023-01-05 18:53:32',NULL),(319,7561,40719,14,2,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',11900.00,NULL,NULL,1,'2023-01-05 18:53:32','2023-01-05 18:53:32',NULL),(320,7561,40719,14,2,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',11900.00,NULL,NULL,1,'2023-01-05 18:53:32','2023-01-05 18:53:32',NULL),(321,7561,40719,14,2,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',6000.00,NULL,NULL,1,'2023-01-05 18:53:32','2023-01-05 18:53:32',NULL),(322,7561,40719,14,2,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',33000.00,NULL,NULL,1,'2023-01-05 18:53:32','2023-01-05 18:53:32',NULL);
INSERT INTO `balance_libro` VALUES (323,7561,40719,14,2,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',12000.00,NULL,NULL,1,'2023-01-05 18:53:32','2023-01-05 18:53:32',NULL),(324,7561,40719,14,2,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',8000.00,NULL,NULL,1,'2023-01-05 18:53:32','2023-01-05 18:53:32',NULL),(325,7561,40725,3038,2,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',23123.10,NULL,NULL,1,'2023-01-07 08:49:59','2023-04-22 12:13:45','2023-04-22 12:13:45'),(326,7561,40725,3038,2,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',622545.00,NULL,NULL,1,'2023-01-07 08:49:59','2023-01-07 08:49:59',NULL),(327,7561,40725,3038,2,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',127413.00,NULL,NULL,1,'2023-01-07 08:49:59','2023-04-22 12:13:24','2023-04-22 12:13:24'),(328,7561,40725,3038,2,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',83249.06,NULL,NULL,1,'2023-01-07 08:49:59','2023-01-07 08:49:59',NULL),(329,7561,40725,3038,2,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',146129.88,NULL,NULL,1,'2023-01-07 08:49:59','2023-04-22 12:13:04','2023-04-22 12:13:04'),(330,7561,40725,3038,2,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',119644.80,NULL,NULL,1,'2023-01-07 08:49:59','2023-04-22 12:12:30','2023-04-22 12:12:30'),(331,7561,40725,3038,2,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',242438.62,NULL,NULL,1,'2023-01-07 08:49:59','2023-01-07 08:49:59',NULL),(332,7561,40725,3038,2,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',177006.06,NULL,NULL,1,'2023-01-07 08:49:59','2023-04-22 12:12:10','2023-04-22 12:12:10'),(333,7561,40725,3038,2,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',99099.00,NULL,NULL,1,'2023-01-07 08:49:59','2023-04-22 12:11:43','2023-04-22 12:11:43'),(334,7561,40725,3038,2,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',289114.98,NULL,NULL,1,'2023-01-07 08:49:59','2023-01-07 08:49:59',NULL),(335,7561,40725,3038,2,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',128949.70,NULL,NULL,1,'2023-01-07 08:49:59','2023-04-22 12:11:16','2023-04-22 12:11:16'),(336,7561,40725,3038,2,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',161233.41,NULL,NULL,1,'2023-01-07 08:50:00','2023-01-07 08:50:00',NULL),(337,7561,40725,3038,2,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',85745.44,NULL,NULL,1,'2023-01-07 08:50:00','2023-04-22 12:10:43','2023-04-22 12:10:43'),(338,7561,40725,3038,2,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',2543.40,NULL,NULL,1,'2023-01-07 08:50:00','2023-04-22 12:10:21','2023-04-22 12:10:21'),(339,7561,40725,3038,2,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',54251.56,NULL,NULL,1,'2023-01-07 08:50:00','2023-04-22 12:09:32','2023-04-22 12:09:32'),(340,7561,40725,3038,2,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',138844.01,NULL,NULL,1,'2023-01-07 08:50:00','2023-01-07 08:50:00',NULL),(341,7561,40725,3038,2,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',6820.00,NULL,NULL,1,'2023-01-07 08:50:00','2023-01-07 08:54:07','2023-01-07 08:54:07'),(342,7561,40725,3038,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',63407.02,NULL,NULL,1,'2023-01-07 08:50:00','2023-04-22 12:08:25','2023-04-22 12:08:25');
INSERT INTO `balance_libro` VALUES (343,7561,40725,3038,2,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',68613.66,NULL,NULL,1,'2023-01-07 08:50:00','2023-04-22 12:07:55','2023-04-22 12:07:55'),(344,7561,40725,3038,2,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',105704.75,NULL,NULL,1,'2023-01-07 08:50:00','2023-04-22 12:07:24','2023-04-22 12:07:24'),(345,7561,40725,3038,2,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',82011.68,NULL,NULL,1,'2023-01-07 08:50:00','2023-04-22 12:07:04','2023-04-22 12:07:04'),(346,7561,40725,3038,2,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',41761.94,NULL,NULL,1,'2023-01-07 08:50:00','2023-04-22 12:06:38','2023-04-22 12:06:38'),(347,7561,40725,3038,2,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',68214.28,NULL,NULL,1,'2023-01-07 08:50:00','2023-01-07 08:50:00',NULL),(348,7561,40725,3038,2,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',45012.00,NULL,NULL,1,'2023-01-07 08:50:00','2023-01-07 08:50:00',NULL),(349,7561,40725,3038,2,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',35534.72,NULL,NULL,1,'2023-01-07 08:50:00','2023-04-22 12:06:03','2023-04-22 12:06:03'),(350,7561,40725,3038,2,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',35534.72,NULL,NULL,1,'2023-01-07 08:50:00','2023-04-22 12:05:33','2023-04-22 12:05:33'),(351,7561,40725,3038,2,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',163108.00,NULL,NULL,1,'2023-01-07 08:50:00','2023-01-07 08:50:00',NULL),(352,7561,40725,3038,2,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',113135.00,NULL,NULL,1,'2023-01-07 08:50:00','2023-04-22 12:04:20','2023-04-22 12:04:20'),(353,7561,40725,3038,2,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',72914.60,NULL,NULL,1,'2023-01-07 08:50:00','2023-04-22 12:03:46','2023-04-22 12:03:46'),(354,7561,40725,3038,2,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',120522.05,NULL,NULL,1,'2023-01-07 08:50:00','2023-03-16 19:52:27','2023-03-16 19:52:27'),(355,7561,40725,3038,2,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',37251.06,NULL,NULL,1,'2023-01-07 08:50:00','2023-02-19 18:31:26','2023-02-19 18:31:26'),(356,7561,40725,3038,3,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',89447.08,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-07 09:56:22','2023-01-07 09:56:22'),(357,7561,40725,3038,3,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1190.00,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-07 10:25:28','2023-01-07 10:25:28'),(358,7561,40725,3038,3,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',57342.87,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-07 08:51:01',NULL),(359,7561,40725,3038,3,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1667.75,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-11 14:26:28','2023-01-11 14:26:28'),(360,7561,40725,3038,3,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',4348.26,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-11 14:39:04','2023-01-11 14:39:04'),(361,7561,40725,3038,3,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',623510.68,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-12 09:12:01','2023-01-12 09:12:01'),(362,7561,40725,3038,3,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',143797.01,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-12 09:10:28','2023-01-12 09:10:28');
INSERT INTO `balance_libro` VALUES (363,7561,40725,3038,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',28057.48,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-11 14:13:23','2023-01-11 14:13:23'),(364,7561,40725,3038,3,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',63729.00,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-12 09:09:41','2023-01-12 09:09:41'),(365,7561,40725,3038,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',86801.81,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-11 14:14:55','2023-01-11 14:14:55'),(366,7561,40725,3038,3,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',395921.68,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-11 14:33:25','2023-01-11 14:33:25'),(367,7561,40725,3038,3,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',880275.00,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-11 14:27:35','2023-01-11 14:27:35'),(368,7561,40725,3038,3,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',25659.01,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-07 09:42:48','2023-01-07 09:42:48'),(369,7561,40725,3038,3,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',17930.26,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-11 14:37:37','2023-01-11 14:37:37'),(370,7561,40725,3038,3,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',3500.00,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-11 14:38:18','2023-01-11 14:38:18'),(371,7561,40725,3038,3,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',40561.62,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-11 14:35:28','2023-01-11 14:35:28'),(372,7561,40725,3038,3,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',144.00,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-07 09:41:44','2023-01-07 09:41:44'),(373,7561,40725,3038,3,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',122800.00,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-07 09:41:34','2023-01-07 09:41:34'),(374,7561,40725,3038,3,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',5819.94,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-07 09:41:03','2023-01-07 09:41:03'),(375,7561,40725,3038,3,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',89719.08,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-11 14:36:36','2023-01-11 14:36:36'),(376,7561,40725,3038,3,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',207106.02,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-11 14:34:28','2023-01-11 14:34:28'),(377,7561,40725,3038,3,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',33000.00,NULL,NULL,1,'2023-01-07 08:51:01','2023-01-12 09:06:52','2023-01-12 09:06:52'),(378,7561,40725,3038,2,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',6820.00,NULL,NULL,1,'2023-01-07 08:54:07','2023-04-22 12:09:03','2023-04-22 12:09:03'),(379,7561,40727,1526,2,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',40898.00,NULL,NULL,1,'2023-01-07 11:24:25','2023-01-07 11:24:25',NULL),(380,7561,40727,1526,2,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',47190.00,NULL,NULL,1,'2023-01-07 11:24:25','2023-01-10 18:40:44','2023-01-10 18:40:44'),(381,7561,40727,1526,2,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',40000.00,NULL,NULL,1,'2023-01-07 11:24:25','2023-01-10 18:42:09','2023-01-10 18:42:09');
INSERT INTO `balance_libro` VALUES (382,7561,40727,1526,2,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',47190.00,NULL,NULL,1,'2023-01-07 11:24:25','2023-01-10 18:42:34','2023-01-10 18:42:34'),(383,7561,40727,1526,2,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',69817.00,NULL,NULL,1,'2023-01-07 11:24:25','2023-01-10 18:43:23','2023-01-10 18:43:23'),(384,7561,40727,1526,2,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',93170.00,NULL,NULL,1,'2023-01-07 11:24:25','2023-01-10 18:43:47','2023-01-10 18:43:47'),(385,7561,40727,1526,2,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',90000.01,NULL,NULL,1,'2023-01-07 11:24:25','2023-01-10 18:45:12','2023-01-10 18:45:12'),(386,7561,40727,1526,2,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',65340.00,NULL,NULL,1,'2023-01-07 11:24:25','2023-01-10 18:45:43','2023-01-10 18:45:43'),(387,7561,40727,1526,2,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',95000.00,NULL,NULL,1,'2023-01-07 11:24:25','2023-01-10 18:46:25','2023-01-10 18:46:25'),(388,7561,40727,1526,2,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',54450.00,NULL,NULL,1,'2023-01-07 11:24:25','2023-01-10 18:59:51','2023-01-10 18:59:51'),(389,7561,40727,1526,2,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',60000.00,NULL,NULL,1,'2023-01-07 11:24:25','2023-01-10 19:00:26','2023-01-10 19:00:26'),(390,7561,40727,1526,2,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',428739.30,NULL,NULL,1,'2023-01-07 11:24:26','2023-01-10 19:02:02','2023-01-10 19:02:02'),(391,7561,40727,1526,2,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',42350.00,NULL,NULL,1,'2023-01-07 11:24:26','2023-01-10 19:02:48','2023-01-10 19:02:48'),(392,7561,40727,1526,2,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',166999.36,NULL,NULL,1,'2023-01-07 11:24:26','2023-01-10 19:03:12','2023-01-10 19:03:12'),(393,7561,40727,1526,2,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',39835.62,NULL,NULL,1,'2023-01-07 11:24:26','2023-01-10 19:03:49','2023-01-10 19:03:49'),(394,7561,40727,1526,2,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',77440.00,NULL,NULL,1,'2023-01-07 11:24:26','2023-01-10 19:04:25','2023-01-10 19:04:25'),(395,7561,40727,1526,2,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',120000.00,NULL,NULL,1,'2023-01-07 11:24:26','2023-01-10 19:05:07','2023-01-10 19:05:07'),(396,7561,40727,1526,2,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',20000.09,NULL,NULL,1,'2023-01-07 11:24:26','2023-01-10 19:06:07','2023-01-10 19:06:07'),(397,7561,40727,1526,2,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',160325.00,NULL,NULL,1,'2023-01-07 11:24:26','2023-01-10 19:06:23','2023-01-10 19:06:23'),(398,7561,40727,1526,2,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',115000.00,NULL,NULL,1,'2023-01-07 11:24:26','2023-01-10 19:07:39','2023-01-10 19:07:39'),(399,7561,40727,1526,2,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',100000.00,NULL,NULL,1,'2023-01-07 11:24:26','2023-01-10 19:06:53','2023-01-10 19:06:53'),(400,7561,40727,1526,3,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',6000.00,NULL,NULL,1,'2023-01-07 11:24:54','2023-01-10 19:44:16','2023-01-10 19:44:16');
INSERT INTO `balance_libro` VALUES (401,7561,40727,1526,3,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',47228.72,NULL,NULL,1,'2023-01-07 11:24:54','2023-01-10 19:39:25','2023-01-10 19:39:25'),(402,7561,40727,1526,3,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',5856.49,NULL,NULL,1,'2023-01-07 11:24:54','2023-01-10 19:41:34','2023-01-10 19:41:34'),(403,7561,40727,1526,3,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',21098.69,NULL,NULL,1,'2023-01-07 11:24:54','2023-01-10 19:38:42','2023-01-10 19:38:42'),(404,7561,40727,1526,3,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',13158.02,NULL,NULL,1,'2023-01-07 11:24:54','2023-01-10 19:37:35','2023-01-10 19:37:35'),(405,7561,40727,1526,3,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',44309.60,NULL,NULL,1,'2023-01-07 11:24:54','2023-01-10 19:23:15','2023-01-10 19:23:15'),(406,7561,40727,1526,3,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',142603.34,NULL,NULL,1,'2023-01-07 11:24:54','2023-01-10 19:23:58','2023-01-10 19:23:58'),(407,7561,40727,1526,3,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',3499.87,NULL,NULL,1,'2023-01-07 11:24:54','2023-01-07 11:24:54',NULL),(408,7561,40727,1526,3,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',29120.74,NULL,NULL,1,'2023-01-07 11:24:54','2023-01-10 19:24:50','2023-01-10 19:24:50'),(409,7561,40727,1526,3,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',112570.05,NULL,NULL,1,'2023-01-07 11:24:55','2023-01-10 19:21:11','2023-01-10 19:21:11'),(410,7561,40727,1526,3,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',10708.50,NULL,NULL,1,'2023-01-07 11:24:55','2023-01-10 19:18:26','2023-01-10 19:18:26'),(411,7561,40727,1526,3,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',100322.13,NULL,NULL,1,'2023-01-07 11:24:55','2023-01-10 19:22:40','2023-01-10 19:22:40'),(412,7561,40727,1526,3,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',58815.30,NULL,NULL,1,'2023-01-07 11:24:55','2023-01-10 19:19:17','2023-01-10 19:19:17'),(413,7561,40727,1526,3,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',4116.42,NULL,NULL,1,'2023-01-07 11:24:55','2023-01-10 19:17:50','2023-01-10 19:17:50'),(414,7561,40727,1526,3,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',74373.86,NULL,NULL,1,'2023-01-07 11:24:55','2023-01-10 19:16:53','2023-01-10 19:16:53'),(415,7561,40727,1526,3,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',33107.90,NULL,NULL,1,'2023-01-07 11:24:55','2023-01-10 19:16:23','2023-01-10 19:16:23'),(416,7561,40727,1526,3,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',7139.00,NULL,NULL,1,'2023-01-07 11:24:55','2023-01-10 19:15:43','2023-01-10 19:15:43'),(417,7561,40727,1526,3,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',22782.78,NULL,NULL,1,'2023-01-07 11:24:55','2023-01-10 19:15:08','2023-01-10 19:15:08'),(418,7561,40727,1526,3,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',130341.20,NULL,NULL,1,'2023-01-07 11:24:55','2023-01-10 19:13:59','2023-01-10 19:13:59'),(419,7561,40727,1526,3,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',42893.68,NULL,NULL,1,'2023-01-07 11:24:55','2023-01-10 19:12:30','2023-01-10 19:12:30');
INSERT INTO `balance_libro` VALUES (420,7561,40727,1526,3,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',66029.70,NULL,NULL,1,'2023-01-07 11:24:55','2023-01-10 19:13:28','2023-01-10 19:13:28'),(421,7561,40727,1526,3,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',48672.25,NULL,NULL,1,'2023-01-07 11:24:55','2023-01-10 19:11:09','2023-01-10 19:11:09'),(422,7561,40727,1526,3,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2800.19,NULL,NULL,1,'2023-01-07 11:24:55','2023-01-10 19:10:19','2023-01-10 19:10:19'),(423,7561,40727,1526,3,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',16335.00,NULL,NULL,1,'2023-01-07 11:24:55','2023-01-10 19:09:10','2023-01-10 19:09:10'),(424,7561,40727,1526,2,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',47190.00,NULL,NULL,1,'2023-01-10 18:40:44','2023-01-10 18:41:30','2023-01-10 18:41:30'),(425,7561,40727,1526,2,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',47190.00,NULL,NULL,1,'2023-01-10 18:41:30','2023-01-10 18:41:30',NULL),(426,7561,40727,1526,2,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',40000.00,NULL,NULL,1,'2023-01-10 18:42:09','2023-01-10 18:42:09',NULL),(427,7561,40727,1526,2,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',47190.00,NULL,NULL,1,'2023-01-10 18:42:34','2023-01-10 18:42:34',NULL),(428,7561,40727,1526,2,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',69817.00,NULL,NULL,1,'2023-01-10 18:43:23','2023-01-10 18:43:23',NULL),(429,7561,40727,1526,2,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',93170.00,NULL,NULL,1,'2023-01-10 18:43:47','2023-01-10 18:43:47',NULL),(430,7561,40727,1526,2,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',90000.01,NULL,NULL,1,'2023-01-10 18:45:12','2023-01-10 18:45:12',NULL),(431,7561,40727,1526,2,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',65340.00,NULL,NULL,1,'2023-01-10 18:45:43','2023-01-10 18:45:43',NULL),(432,7561,40727,1526,2,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',95000.00,NULL,NULL,1,'2023-01-10 18:46:25','2023-01-10 18:59:20','2023-01-10 18:59:20'),(433,7561,40727,1526,2,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',95000.00,NULL,NULL,1,'2023-01-10 18:59:20','2023-01-10 18:59:20',NULL),(434,7561,40727,1526,2,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',54450.00,NULL,NULL,1,'2023-01-10 18:59:51','2023-01-10 18:59:51',NULL),(435,7561,40727,1526,2,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',60000.00,NULL,NULL,1,'2023-01-10 19:00:26','2023-01-10 19:00:26',NULL),(436,7561,40727,1526,2,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',428739.30,NULL,NULL,1,'2023-01-10 19:02:02','2023-01-10 19:02:02',NULL),(437,7561,40727,1526,2,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',42350.00,NULL,NULL,1,'2023-01-10 19:02:48','2023-01-10 19:02:48',NULL),(438,7561,40727,1526,2,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',166999.36,NULL,NULL,1,'2023-01-10 19:03:12','2023-01-10 19:03:12',NULL),(439,7561,40727,1526,2,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',39835.62,NULL,NULL,1,'2023-01-10 19:03:49','2023-01-10 19:03:49',NULL);
INSERT INTO `balance_libro` VALUES (440,7561,40727,1526,2,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',77440.00,NULL,NULL,1,'2023-01-10 19:04:25','2023-01-10 19:04:25',NULL),(441,7561,40727,1526,2,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',120000.00,NULL,NULL,1,'2023-01-10 19:05:07','2023-01-10 19:05:07',NULL),(442,7561,40727,1526,2,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',20000.09,NULL,NULL,1,'2023-01-10 19:06:07','2023-01-10 19:06:07',NULL),(443,7561,40727,1526,2,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',160325.00,NULL,NULL,1,'2023-01-10 19:06:23','2023-01-10 19:06:23',NULL),(444,7561,40727,1526,2,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',100000.00,NULL,NULL,1,'2023-01-10 19:06:53','2023-01-10 19:07:12','2023-01-10 19:07:12'),(445,7561,40727,1526,2,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',100000.00,NULL,NULL,1,'2023-01-10 19:07:12','2023-01-10 19:07:12',NULL),(446,7561,40727,1526,2,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',115000.00,NULL,NULL,1,'2023-01-10 19:07:39','2023-01-10 19:07:39',NULL),(447,7561,40727,1526,3,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',16335.00,NULL,NULL,1,'2023-01-10 19:09:10','2023-01-10 19:09:10',NULL),(448,7561,40727,1526,3,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2800.20,NULL,NULL,1,'2023-01-10 19:10:19','2023-01-12 14:37:35','2023-01-12 14:37:35'),(449,7561,40727,1526,3,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',48672.25,NULL,NULL,1,'2023-01-10 19:11:09','2023-01-10 19:11:09',NULL),(450,7561,40727,1526,3,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',42893.68,NULL,NULL,1,'2023-01-10 19:12:30','2023-01-10 19:12:30',NULL),(451,7561,40727,1526,3,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',66029.70,NULL,NULL,1,'2023-01-10 19:13:28','2023-01-10 19:13:28',NULL),(452,7561,40727,1526,3,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',130341.20,NULL,NULL,1,'2023-01-10 19:13:59','2023-01-10 19:13:59',NULL),(453,7561,40727,1526,3,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',22782.78,NULL,NULL,1,'2023-01-10 19:15:08','2023-01-10 19:15:08',NULL),(454,7561,40727,1526,3,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',7139.00,NULL,NULL,1,'2023-01-10 19:15:43','2023-01-10 19:15:43',NULL),(455,7561,40727,1526,3,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',33107.90,NULL,NULL,1,'2023-01-10 19:16:23','2023-01-10 19:16:23',NULL),(456,7561,40727,1526,3,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',74373.86,NULL,NULL,1,'2023-01-10 19:16:53','2023-01-10 19:16:53',NULL),(457,7561,40727,1526,3,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',4116.42,NULL,NULL,1,'2023-01-10 19:17:50','2023-01-10 19:17:50',NULL),(458,7561,40727,1526,3,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',10708.50,NULL,NULL,1,'2023-01-10 19:18:26','2023-01-10 19:18:26',NULL),(459,7561,40727,1526,3,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',58815.29,NULL,NULL,1,'2023-01-10 19:19:17','2023-01-10 19:19:17',NULL),(460,7561,40727,1526,3,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',112570.05,NULL,NULL,1,'2023-01-10 19:21:11','2023-01-10 19:21:11',NULL);
INSERT INTO `balance_libro` VALUES (461,7561,40727,1526,3,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',100322.13,NULL,NULL,1,'2023-01-10 19:22:40','2023-01-10 19:22:40',NULL),(462,7561,40727,1526,3,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',44309.60,NULL,NULL,1,'2023-01-10 19:23:15','2023-01-10 19:23:15',NULL),(463,7561,40727,1526,3,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',142603.34,NULL,NULL,1,'2023-01-10 19:23:58','2023-01-10 19:23:58',NULL),(464,7561,40727,1526,3,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',29120.74,NULL,NULL,1,'2023-01-10 19:24:50','2023-01-10 19:24:50',NULL),(465,7561,40727,1526,3,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',3372.45,NULL,NULL,1,'2023-01-10 19:28:15','2023-01-10 19:28:15',NULL),(466,7561,40727,1526,3,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',931.76,NULL,NULL,1,'2023-01-10 19:36:26','2023-01-10 19:36:26',NULL),(467,7561,40727,1526,3,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',13158.02,NULL,NULL,1,'2023-01-10 19:37:35','2023-01-10 19:37:35',NULL),(468,7561,40727,1526,3,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',21098.69,NULL,NULL,1,'2023-01-10 19:38:42','2023-01-10 19:38:42',NULL),(469,7561,40727,1526,3,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',47228.72,NULL,NULL,1,'2023-01-10 19:39:25','2023-01-10 19:39:25',NULL),(470,7561,40727,1526,3,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',5856.49,NULL,NULL,1,'2023-01-10 19:41:34','2023-01-10 19:41:34',NULL),(471,7561,40727,1525,3,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',2000.19,NULL,NULL,1,'2023-01-10 19:42:12','2023-01-10 19:42:12',NULL),(472,7561,40727,1526,3,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',6000.00,NULL,NULL,1,'2023-01-10 19:44:16','2023-01-10 19:44:16',NULL),(473,7561,40725,3038,3,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',1600.00,NULL,NULL,1,'2023-01-11 12:57:37','2023-01-12 09:01:50','2023-01-12 09:01:50'),(474,7561,40725,3038,3,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',4600.00,NULL,NULL,1,'2023-01-11 13:01:50','2023-01-12 09:06:30','2023-01-12 09:06:30'),(475,7561,40725,3038,3,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',3500.05,NULL,NULL,1,'2023-01-11 13:05:37','2023-01-12 09:04:21','2023-01-12 09:04:21'),(476,7561,40725,3038,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',3999.92,NULL,NULL,1,'2023-01-11 13:08:13','2023-01-12 09:04:08','2023-01-12 09:04:08'),(477,7561,40725,3038,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',4000.00,NULL,NULL,1,'2023-01-11 13:12:35','2023-01-12 08:58:15','2023-01-12 08:58:15'),(478,7561,40725,3038,3,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',3499.93,NULL,NULL,1,'2023-01-11 13:18:05','2023-01-12 09:03:33','2023-01-12 09:03:33'),(479,7561,40725,3038,3,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',4089.96,NULL,NULL,1,'2023-01-11 13:26:22','2023-01-11 13:26:22',NULL),(480,7561,40725,3038,3,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',3067.57,NULL,NULL,1,'2023-01-11 13:28:09','2023-01-12 09:03:22','2023-01-12 09:03:22');
INSERT INTO `balance_libro` VALUES (481,7561,40725,3038,3,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',4000.00,NULL,NULL,1,'2023-01-11 13:30:14','2023-01-12 09:03:09','2023-01-12 09:03:09'),(482,7561,40725,3038,3,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',4000.00,NULL,NULL,1,'2023-01-11 13:31:22','2023-01-12 09:02:56','2023-01-12 09:02:56'),(483,7561,40725,3038,3,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',2000.00,NULL,NULL,1,'2023-01-11 13:38:08','2023-01-12 09:02:42','2023-01-12 09:02:42'),(484,7561,40725,3038,3,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2410.00,NULL,NULL,1,'2023-01-11 13:44:31','2023-01-11 18:08:31','2023-01-11 18:08:31'),(485,7561,40725,3038,3,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',4000.00,NULL,NULL,1,'2023-01-11 13:56:03','2023-01-11 16:20:00','2023-01-11 16:20:00'),(486,7561,40725,3038,3,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',8001.10,NULL,NULL,1,'2023-01-11 14:00:36','2023-01-12 09:02:13','2023-01-12 09:02:13'),(487,7561,40725,3038,3,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',5571.54,NULL,NULL,1,'2023-01-11 14:11:08','2023-01-11 17:30:29','2023-01-11 17:30:29'),(488,7561,40725,3038,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',28057.48,NULL,NULL,1,'2023-01-11 14:13:23','2023-01-11 14:16:04','2023-01-11 14:16:04'),(489,7561,40725,3038,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',86801.81,NULL,NULL,1,'2023-01-11 14:14:55','2023-01-11 14:15:19','2023-01-11 14:15:19'),(490,7561,40725,3038,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',86801.81,NULL,NULL,1,'2023-01-11 14:15:19','2023-01-11 14:17:19','2023-01-11 14:17:19'),(491,7561,40725,3038,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',28057.48,NULL,NULL,1,'2023-01-11 14:16:04','2023-01-12 09:10:04','2023-01-12 09:10:04'),(492,7561,40725,3038,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',86801.81,NULL,NULL,1,'2023-01-11 14:17:19','2023-01-11 14:24:21','2023-01-11 14:24:21'),(493,7561,40725,3038,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',86801.81,NULL,NULL,1,'2023-01-11 14:24:21','2023-01-12 09:09:28','2023-01-12 09:09:28'),(494,7561,40725,3038,3,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1667.75,NULL,NULL,1,'2023-01-11 14:26:28','2023-01-11 18:57:27','2023-01-11 18:57:27'),(495,7561,40725,3038,3,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',880275.00,NULL,NULL,1,'2023-01-11 14:27:35','2023-01-12 09:08:55','2023-01-12 09:08:55'),(496,7561,40725,3038,3,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',395921.68,NULL,NULL,1,'2023-01-11 14:33:25','2023-01-12 09:09:17','2023-01-12 09:09:17'),(497,7561,40725,3038,3,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',207106.02,NULL,NULL,1,'2023-01-11 14:34:28','2023-01-12 09:07:10','2023-01-12 09:07:10'),(498,7561,40725,3038,3,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',40561.62,NULL,NULL,1,'2023-01-11 14:35:28','2023-01-12 09:07:56','2023-01-12 09:07:56'),(499,7561,40725,3038,3,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',89719.08,NULL,NULL,1,'2023-01-11 14:36:36','2023-01-12 09:07:25','2023-01-12 09:07:25');
INSERT INTO `balance_libro` VALUES (500,7561,40725,3038,3,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',17930.26,NULL,NULL,1,'2023-01-11 14:37:37','2023-01-12 09:08:42','2023-01-12 09:08:42'),(501,7561,40725,3038,3,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',3500.00,NULL,NULL,1,'2023-01-11 14:38:18','2023-01-12 09:08:19','2023-01-12 09:08:19'),(502,7561,40725,3038,3,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',4348.26,NULL,NULL,1,'2023-01-11 14:39:04','2023-01-12 09:12:12','2023-01-12 09:12:12'),(503,7561,40725,3038,3,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',4000.00,NULL,NULL,1,'2023-01-11 16:20:00','2023-01-12 09:02:22','2023-01-12 09:02:22'),(504,7561,40725,3038,3,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',5571.54,NULL,NULL,1,'2023-01-11 17:30:29','2023-01-11 19:40:29','2023-01-11 19:40:29'),(505,7561,40725,3038,3,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2410.00,NULL,NULL,1,'2023-01-11 18:08:31','2023-01-11 19:42:23','2023-01-11 19:42:23'),(506,7561,40725,3038,3,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1667.76,NULL,NULL,1,'2023-01-11 18:57:27','2023-01-11 18:58:45','2023-01-11 18:58:45'),(507,7561,40725,3038,3,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1667.75,NULL,NULL,1,'2023-01-11 18:58:45','2023-01-12 09:13:03','2023-01-12 09:13:03'),(508,7561,40725,3038,3,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',5571.54,NULL,NULL,1,'2023-01-11 19:40:29','2023-01-12 09:02:03','2023-01-12 09:02:03'),(509,7561,40725,3038,3,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2410.00,NULL,NULL,1,'2023-01-11 19:42:23','2023-01-12 09:02:29','2023-01-12 09:02:29'),(510,7561,40725,3038,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',4000.00,NULL,NULL,1,'2023-01-12 08:58:15','2023-01-12 09:03:59','2023-01-12 09:03:59'),(511,7561,40725,3038,3,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',1600.00,NULL,NULL,1,'2023-01-12 09:01:50','2023-01-12 09:06:39','2023-01-12 09:06:39'),(512,7561,40725,3038,3,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',5571.54,NULL,NULL,1,'2023-01-12 09:02:03','2023-01-12 09:02:03',NULL),(513,7561,40725,3038,3,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',8001.10,NULL,NULL,1,'2023-01-12 09:02:13','2023-01-12 09:02:13',NULL),(514,7561,40725,3038,3,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',4000.00,NULL,NULL,1,'2023-01-12 09:02:22','2023-01-12 09:02:22',NULL),(515,7561,40725,3038,3,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2410.00,NULL,NULL,1,'2023-01-12 09:02:29','2023-01-12 09:02:35','2023-01-12 09:02:35'),(516,7561,40725,3038,3,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2410.00,NULL,NULL,1,'2023-01-12 09:02:35','2023-01-12 09:04:36','2023-01-12 09:04:36'),(517,7561,40725,3038,3,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',2000.00,NULL,NULL,1,'2023-01-12 09:02:42','2023-01-12 09:02:49','2023-01-12 09:02:49'),(518,7561,40725,3038,3,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',2000.00,NULL,NULL,1,'2023-01-12 09:02:49','2023-01-12 09:04:44','2023-01-12 09:04:44'),(519,7561,40725,3038,3,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',4000.00,NULL,NULL,1,'2023-01-12 09:02:56','2023-01-12 09:04:53','2023-01-12 09:04:53');
INSERT INTO `balance_libro` VALUES (520,7561,40725,3038,3,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',4000.00,NULL,NULL,1,'2023-01-12 09:03:09','2023-01-12 09:04:59','2023-01-12 09:04:59'),(521,7561,40725,3038,3,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',3067.57,NULL,NULL,1,'2023-01-12 09:03:22','2023-01-12 09:05:06','2023-01-12 09:05:06'),(522,7561,40725,3038,3,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',3499.93,NULL,NULL,1,'2023-01-12 09:03:33','2023-01-12 09:03:33',NULL),(523,7561,40725,3038,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',4000.00,NULL,NULL,1,'2023-01-12 09:03:59','2023-01-12 09:05:36','2023-01-12 09:05:36'),(524,7561,40725,3038,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',3999.92,NULL,NULL,1,'2023-01-12 09:04:08','2023-01-12 09:06:08','2023-01-12 09:06:08'),(525,7561,40725,3038,3,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',3500.05,NULL,NULL,1,'2023-01-12 09:04:21','2023-01-12 09:06:20','2023-01-12 09:06:20'),(526,7561,40725,3038,3,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2410.00,NULL,NULL,1,'2023-01-12 09:04:36','2023-01-12 09:04:36',NULL),(527,7561,40725,3038,3,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',2000.00,NULL,NULL,1,'2023-01-12 09:04:44','2023-01-12 09:04:44',NULL),(528,7561,40725,3038,3,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',4000.00,NULL,NULL,1,'2023-01-12 09:04:53','2023-01-12 09:04:53',NULL),(529,7561,40725,3038,3,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',4000.00,NULL,NULL,1,'2023-01-12 09:04:59','2023-01-12 09:04:59',NULL),(530,7561,40725,3038,3,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',3067.57,NULL,NULL,1,'2023-01-12 09:05:06','2023-01-12 09:05:06',NULL),(531,7561,40725,3038,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',4000.00,NULL,NULL,1,'2023-01-12 09:05:36','2023-01-12 09:05:36',NULL),(532,7561,40725,3038,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',3999.92,NULL,NULL,1,'2023-01-12 09:06:08','2023-01-12 09:06:08',NULL),(533,7561,40725,3038,3,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',3500.05,NULL,NULL,1,'2023-01-12 09:06:20','2023-01-12 09:06:20',NULL),(534,7561,40725,3038,3,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',4600.00,NULL,NULL,1,'2023-01-12 09:06:30','2023-01-12 09:06:30',NULL),(535,7561,40725,3038,3,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',1600.00,NULL,NULL,1,'2023-01-12 09:06:39','2023-01-12 09:06:39',NULL),(536,7561,40725,3038,3,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',33000.00,NULL,NULL,1,'2023-01-12 09:06:52','2023-01-12 09:06:52',NULL),(537,7561,40725,3038,3,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',207106.02,NULL,NULL,1,'2023-01-12 09:07:10','2023-01-12 09:07:10',NULL),(538,7561,40725,3038,3,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',89719.08,NULL,NULL,1,'2023-01-12 09:07:25','2023-01-12 09:07:35','2023-01-12 09:07:35'),(539,7561,40725,3038,3,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',89719.08,NULL,NULL,1,'2023-01-12 09:07:35','2023-01-12 09:07:47','2023-01-12 09:07:47');
INSERT INTO `balance_libro` VALUES (540,7561,40725,3038,3,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',89719.08,NULL,NULL,1,'2023-01-12 09:07:47','2023-01-12 09:07:47',NULL),(541,7561,40725,3038,3,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',40561.62,NULL,NULL,1,'2023-01-12 09:07:56','2023-01-12 09:07:56',NULL),(542,7561,40725,3038,3,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',3500.00,NULL,NULL,1,'2023-01-12 09:08:19','2023-01-12 09:08:19',NULL),(543,7561,40725,3038,3,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',17930.26,NULL,NULL,1,'2023-01-12 09:08:42','2023-01-12 09:08:42',NULL),(544,7561,40725,3038,3,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',880275.00,NULL,NULL,1,'2023-01-12 09:08:55','2023-01-12 09:08:55',NULL),(545,7561,40725,3038,3,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',395921.68,NULL,NULL,1,'2023-01-12 09:09:17','2023-01-12 09:09:17',NULL),(546,7561,40725,3038,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',86801.81,NULL,NULL,1,'2023-01-12 09:09:28','2023-01-12 09:09:28',NULL),(547,7561,40725,3038,3,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',63729.01,NULL,NULL,1,'2023-01-12 09:09:41','2023-01-12 09:09:53','2023-01-12 09:09:53'),(548,7561,40725,3038,3,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',63729.01,NULL,NULL,1,'2023-01-12 09:09:53','2023-01-12 09:09:53',NULL),(549,7561,40725,3038,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',28057.48,NULL,NULL,1,'2023-01-12 09:10:04','2023-01-12 09:10:51','2023-01-12 09:10:51'),(550,7561,40725,3038,3,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',143797.01,NULL,NULL,1,'2023-01-12 09:10:28','2023-01-12 09:11:33','2023-01-12 09:11:33'),(551,7561,40725,3038,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',28057.48,NULL,NULL,1,'2023-01-12 09:10:51','2023-01-12 09:11:11','2023-01-12 09:11:11'),(552,7561,40725,3038,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',28057.48,NULL,NULL,1,'2023-01-12 09:11:11','2023-01-12 09:11:11',NULL),(553,7561,40725,3038,3,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',143797.01,NULL,NULL,1,'2023-01-12 09:11:33','2023-01-12 09:11:33',NULL),(554,7561,40725,3038,3,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',623510.68,NULL,NULL,1,'2023-01-12 09:12:01','2023-01-12 09:12:01',NULL),(555,7561,40725,3038,3,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',4348.26,NULL,NULL,1,'2023-01-12 09:12:12','2023-01-12 09:12:12',NULL),(556,7561,40725,3038,3,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1667.75,NULL,NULL,1,'2023-01-12 09:13:03','2023-01-12 09:13:03',NULL),(557,7561,40727,1526,3,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2799.96,NULL,NULL,1,'2023-01-12 14:37:35','2023-01-12 14:44:05','2023-01-12 14:44:05'),(558,7561,40727,1526,3,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2800.19,NULL,NULL,1,'2023-01-12 14:44:05','2023-01-12 14:44:05',NULL),(559,7561,40855,12189,2,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',15554.10,NULL,NULL,1,'2023-01-19 11:31:45','2023-01-19 11:31:45',NULL),(560,7561,40855,12189,2,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',1112.10,NULL,NULL,1,'2023-01-19 11:31:45','2023-01-19 11:31:45',NULL);
INSERT INTO `balance_libro` VALUES (561,7561,40855,12189,2,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',21348.00,NULL,NULL,1,'2023-01-19 11:31:45','2023-01-19 11:31:45',NULL),(562,7561,40855,12189,2,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',2772.90,NULL,NULL,1,'2023-01-19 11:31:45','2023-01-19 11:31:45',NULL),(563,7561,40855,12189,2,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',14652.00,NULL,NULL,1,'2023-01-19 11:31:45','2023-01-19 11:31:45',NULL),(564,7561,40855,12189,2,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',18198.00,NULL,NULL,1,'2023-01-19 11:31:45','2023-01-19 11:31:45',NULL),(565,7561,40855,12189,2,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',15027.00,NULL,NULL,1,'2023-01-19 11:31:45','2023-01-19 11:31:45',NULL),(566,7561,40855,12189,2,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',13119.00,NULL,NULL,1,'2023-01-19 11:31:45','2023-01-19 11:31:45',NULL),(567,7561,40855,12189,2,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',15180.00,NULL,NULL,1,'2023-01-19 11:31:45','2023-01-19 11:31:45',NULL),(568,7561,40855,12189,2,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',8310.00,NULL,NULL,1,'2023-01-19 11:31:45','2023-01-19 11:31:45',NULL),(569,7561,40855,12189,2,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',14151.00,NULL,NULL,1,'2023-01-19 11:31:45','2023-01-19 11:31:45',NULL),(570,7561,40855,12189,2,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',18168.00,NULL,NULL,1,'2023-01-19 11:31:45','2023-01-19 11:31:45',NULL),(571,7561,40855,12189,2,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',34729.75,NULL,NULL,1,'2023-01-19 11:31:45','2023-01-19 11:31:45',NULL),(572,7561,40855,12189,2,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',31498.50,NULL,NULL,1,'2023-01-19 11:31:45','2023-01-19 11:31:45',NULL),(573,7561,40855,12189,2,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',33899.25,NULL,NULL,1,'2023-01-19 11:31:45','2023-01-19 11:31:45',NULL),(574,7561,40855,12189,2,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',38175.50,NULL,NULL,1,'2023-01-19 11:31:45','2023-01-19 11:31:45',NULL),(575,7561,40855,12189,2,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',28140.75,NULL,NULL,1,'2023-01-19 11:31:46','2023-01-19 11:31:46',NULL),(576,7561,40855,12189,2,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',30470.00,NULL,NULL,1,'2023-01-19 11:31:46','2023-01-19 11:31:46',NULL),(577,7561,40855,12189,2,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',33885.50,NULL,NULL,1,'2023-01-19 11:31:46','2023-01-19 11:31:46',NULL),(578,7561,40855,12189,2,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',24013.00,NULL,NULL,1,'2023-01-19 11:31:46','2023-01-19 11:31:46',NULL),(579,7561,40855,12189,2,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',42982.50,NULL,NULL,1,'2023-01-19 11:31:46','2023-01-19 11:31:46',NULL),(580,7561,40855,12189,2,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',25132.25,NULL,NULL,1,'2023-01-19 11:31:46','2023-01-19 11:31:46',NULL),(581,7561,40855,12189,2,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',33029.75,NULL,NULL,1,'2023-01-19 11:31:46','2023-01-19 11:31:46',NULL);
INSERT INTO `balance_libro` VALUES (582,7561,40855,12189,2,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',2675.00,NULL,NULL,1,'2023-01-19 11:31:46','2023-01-19 11:31:46',NULL),(583,7561,40855,12189,2,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',33805.70,NULL,NULL,1,'2023-01-19 11:31:46','2023-01-19 11:31:46',NULL),(584,7561,40855,12190,2,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',22952.00,NULL,NULL,1,'2023-01-19 11:39:37','2023-01-19 11:39:37',NULL),(585,7561,40855,12190,2,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',12481.80,NULL,NULL,1,'2023-01-19 11:39:37','2023-01-19 11:39:37',NULL),(586,7561,40855,12190,2,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',24748.75,NULL,NULL,1,'2023-01-19 11:39:37','2023-01-19 11:39:37',NULL),(587,7561,40855,12190,2,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',11727.30,NULL,NULL,1,'2023-01-19 11:39:37','2023-01-19 11:39:37',NULL),(588,7561,40855,12190,2,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',22552.50,NULL,NULL,1,'2023-01-19 11:39:37','2023-01-19 11:39:37',NULL),(589,7561,40855,12190,2,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',7949.64,NULL,NULL,1,'2023-01-19 11:39:37','2023-01-19 11:39:37',NULL),(590,7561,40855,12190,2,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',14953.25,NULL,NULL,1,'2023-01-19 11:39:37','2023-01-19 11:39:37',NULL),(591,7561,40855,12190,2,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',11791.65,NULL,NULL,1,'2023-01-19 11:39:37','2023-01-19 11:39:37',NULL),(592,7561,40855,12190,2,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',7656.00,NULL,NULL,1,'2023-01-19 11:39:37','2023-01-19 11:39:37',NULL),(593,7561,40855,12190,2,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',9048.00,NULL,NULL,1,'2023-01-19 11:39:37','2023-01-19 11:39:37',NULL),(594,7561,40855,12190,2,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',9501.00,NULL,NULL,1,'2023-01-19 11:39:37','2023-01-19 11:39:37',NULL),(595,7561,40855,12190,2,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',18018.00,NULL,NULL,1,'2023-01-19 11:39:37','2023-01-19 11:39:37',NULL),(596,7561,40855,12190,2,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',24270.00,NULL,NULL,1,'2023-01-19 11:39:37','2023-01-19 11:39:37',NULL),(597,7561,40855,12190,2,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',430.00,NULL,NULL,1,'2023-01-19 11:39:38','2023-01-19 11:39:38',NULL),(598,7561,40855,12190,2,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',14502.00,NULL,NULL,1,'2023-01-19 11:39:38','2023-01-19 11:39:38',NULL),(599,7561,40855,12190,2,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',22422.00,NULL,NULL,1,'2023-01-19 11:39:38','2023-01-19 11:39:38',NULL),(600,7561,40855,12190,2,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',52653.60,NULL,NULL,1,'2023-01-19 11:39:38','2023-01-19 11:39:38',NULL),(601,7561,40855,12190,2,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',17184.00,NULL,NULL,1,'2023-01-19 11:39:38','2023-01-19 11:39:38',NULL),(602,7561,40855,12190,2,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',12542.00,NULL,NULL,1,'2023-01-19 11:39:38','2023-01-19 11:39:38',NULL);
INSERT INTO `balance_libro` VALUES (603,7561,40855,12190,2,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',14098.50,NULL,NULL,1,'2023-01-19 11:39:38','2023-01-19 11:39:38',NULL),(604,7561,40855,12190,2,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',13217.75,NULL,NULL,1,'2023-01-19 11:39:38','2023-01-19 11:39:38',NULL),(605,7561,40855,12190,2,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',20715.50,NULL,NULL,1,'2023-01-19 11:39:38','2023-01-19 11:39:38',NULL),(606,7561,40855,12190,2,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',26474.50,NULL,NULL,1,'2023-01-19 11:39:38','2023-01-19 11:39:38',NULL),(607,7561,40855,12191,2,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',25425.85,NULL,NULL,1,'2023-01-19 12:52:42','2023-01-19 12:52:42',NULL),(608,7561,40855,12191,2,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',8361.64,NULL,NULL,1,'2023-01-19 12:52:42','2023-01-19 12:52:42',NULL),(609,7561,40855,12191,2,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',67419.00,NULL,NULL,1,'2023-01-19 12:52:42','2023-01-19 12:52:42',NULL),(610,7561,40855,12191,2,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',24696.75,NULL,NULL,1,'2023-01-19 12:52:42','2023-01-19 12:52:42',NULL),(611,7561,40855,12191,2,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',25450.75,NULL,NULL,1,'2023-01-19 12:52:42','2023-01-19 12:52:42',NULL),(612,7561,40855,12191,2,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',12610.00,NULL,NULL,1,'2023-01-19 12:52:42','2023-01-19 12:52:42',NULL),(613,7561,40855,12191,2,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',14134.25,NULL,NULL,1,'2023-01-19 12:52:42','2023-01-19 12:52:42',NULL),(614,7561,40855,12191,2,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',23793.25,NULL,NULL,1,'2023-01-19 12:52:42','2023-01-19 12:52:42',NULL),(615,7561,40855,12191,2,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',33445.75,NULL,NULL,1,'2023-01-19 12:52:42','2023-01-19 12:52:42',NULL),(616,7561,40855,12191,2,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',3345.00,NULL,NULL,1,'2023-01-19 12:52:42','2023-01-19 12:52:42',NULL),(617,7561,40855,12191,2,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',14220.00,NULL,NULL,1,'2023-01-19 12:52:42','2023-01-19 12:52:42',NULL),(618,7561,40855,12191,2,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',36135.00,NULL,NULL,1,'2023-01-19 12:52:43','2023-01-19 12:52:43',NULL),(619,7561,40855,12191,2,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',5780.25,NULL,NULL,1,'2023-01-19 12:52:43','2023-01-19 12:52:43',NULL),(620,7561,40855,12191,2,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',24943.75,NULL,NULL,1,'2023-01-19 12:52:43','2023-01-19 12:52:43',NULL),(621,7561,40855,12191,2,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',26973.05,NULL,NULL,1,'2023-01-19 12:52:43','2023-01-19 12:52:43',NULL),(622,7561,40855,12191,2,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',6290.00,NULL,NULL,1,'2023-01-19 12:52:43','2023-01-19 12:52:43',NULL),(623,7561,40855,12191,2,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',20000.00,NULL,NULL,1,'2023-01-19 12:52:43','2023-01-19 12:52:43',NULL);
INSERT INTO `balance_libro` VALUES (624,7561,40855,12191,2,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',13715.00,NULL,NULL,1,'2023-01-19 12:52:43','2023-01-19 12:52:43',NULL),(625,7561,40855,12191,2,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',15541.50,NULL,NULL,1,'2023-01-19 12:52:43','2023-01-19 12:52:43',NULL),(626,7561,40855,12191,2,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',16071.25,NULL,NULL,1,'2023-01-19 12:52:43','2023-01-19 12:52:43',NULL),(627,7561,40855,12191,2,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',15827.50,NULL,NULL,1,'2023-01-19 12:52:43','2023-01-19 12:52:43',NULL),(628,7561,40855,12191,2,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',16308.50,NULL,NULL,1,'2023-01-19 12:52:43','2023-01-19 12:52:43',NULL),(629,7561,40855,12191,2,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',24238.50,NULL,NULL,1,'2023-01-19 12:52:43','2023-01-19 12:52:43',NULL),(630,7561,40855,12191,2,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',22395.10,NULL,NULL,1,'2023-01-19 12:52:43','2023-01-19 12:52:43',NULL),(631,7561,40855,12191,2,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',11600.00,NULL,NULL,1,'2023-01-19 12:52:43','2023-01-19 12:52:43',NULL),(632,7561,40855,12191,2,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2002.00,NULL,NULL,1,'2023-01-19 12:52:43','2023-01-19 12:52:43',NULL),(633,7561,40855,12191,2,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',6398.00,NULL,NULL,1,'2023-01-19 12:52:43','2023-01-19 12:52:43',NULL),(634,7561,40855,12191,2,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',57128.73,NULL,NULL,1,'2023-01-19 12:52:43','2023-01-19 12:52:43',NULL),(635,7561,40855,12192,2,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',67792.00,NULL,NULL,1,'2023-01-19 12:53:25','2023-01-19 12:53:25',NULL),(636,7561,40855,12192,2,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',3740.65,NULL,NULL,1,'2023-01-19 12:53:25','2023-01-19 12:53:25',NULL),(637,7561,40855,12192,2,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',25647.00,NULL,NULL,1,'2023-01-19 12:53:25','2023-01-19 12:53:25',NULL),(638,7561,40855,12192,2,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',15035.00,NULL,NULL,1,'2023-01-19 12:53:25','2023-01-19 12:53:25',NULL),(639,7561,40855,12192,2,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',14556.98,NULL,NULL,1,'2023-01-19 12:53:25','2023-01-19 12:53:25',NULL),(640,7561,40855,12192,2,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',56215.50,NULL,NULL,1,'2023-01-19 12:53:25','2023-01-19 12:53:25',NULL),(641,7561,40855,12192,2,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',1299.00,NULL,NULL,1,'2023-01-19 12:53:25','2023-01-19 12:53:25',NULL),(642,7561,40855,12192,2,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',46189.00,NULL,NULL,1,'2023-01-19 12:53:25','2023-01-19 12:53:25',NULL),(643,7561,40855,12192,2,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',6390.00,NULL,NULL,1,'2023-01-19 12:53:25','2023-01-19 12:53:25',NULL),(644,7561,40855,12192,2,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',4000.00,NULL,NULL,1,'2023-01-19 12:53:25','2023-01-19 12:53:25',NULL);
INSERT INTO `balance_libro` VALUES (645,7561,40855,12192,2,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',2900.00,NULL,NULL,1,'2023-01-19 12:53:26','2023-01-19 12:53:26',NULL),(646,7561,40855,12192,2,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',34181.40,NULL,NULL,1,'2023-01-19 12:53:26','2023-01-19 12:53:26',NULL),(647,7561,40855,12192,2,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',52151.70,NULL,NULL,1,'2023-01-19 12:53:26','2023-01-19 12:53:26',NULL),(648,7561,40855,12192,2,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',20000.00,NULL,NULL,1,'2023-01-19 12:53:26','2023-01-19 12:53:26',NULL),(649,7561,40855,12192,2,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',22678.50,NULL,NULL,1,'2023-01-19 12:53:26','2023-01-19 12:53:26',NULL),(650,7561,40855,12192,2,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',16711.50,NULL,NULL,1,'2023-01-19 12:53:26','2023-01-19 12:53:26',NULL),(651,7561,40855,12192,2,439,'App\\Models\\Receipt',439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',5390.00,NULL,NULL,1,'2023-01-19 12:53:26','2023-01-19 12:53:26',NULL),(652,7561,40855,12193,2,440,'App\\Models\\Receipt',440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',28157.80,NULL,NULL,1,'2023-01-19 12:54:05','2023-01-19 12:54:05',NULL),(653,7561,40855,12193,2,441,'App\\Models\\Receipt',441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',40480.00,NULL,NULL,1,'2023-01-19 12:54:05','2023-01-19 12:54:05',NULL),(654,7561,40855,12193,2,442,'App\\Models\\Receipt',442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',31603.00,NULL,NULL,1,'2023-01-19 12:54:06','2023-01-19 12:54:06',NULL),(655,7561,40855,12193,2,443,'App\\Models\\Receipt',443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',33973.50,NULL,NULL,1,'2023-01-19 12:54:06','2023-01-19 12:54:06',NULL),(656,7561,40855,12193,2,444,'App\\Models\\Receipt',444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',24466.75,NULL,NULL,1,'2023-01-19 12:54:06','2023-01-19 12:54:06',NULL),(657,7561,40855,12193,2,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',50239.18,NULL,NULL,1,'2023-01-19 12:54:06','2023-01-19 12:54:06',NULL),(658,7561,40855,12193,2,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',33930.00,NULL,NULL,1,'2023-01-19 12:54:06','2023-01-19 12:54:06',NULL),(659,7561,40855,12193,2,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',24680.50,NULL,NULL,1,'2023-01-19 12:54:06','2023-01-19 12:54:06',NULL),(660,7561,40855,12193,2,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',13481.00,NULL,NULL,1,'2023-01-19 12:54:06','2023-01-19 12:54:06',NULL),(661,7561,40855,12193,2,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',20267.00,NULL,NULL,1,'2023-01-19 12:54:06','2023-01-19 12:54:06',NULL),(662,7561,40855,12193,2,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',17390.75,NULL,NULL,1,'2023-01-19 12:54:06','2023-01-19 12:54:06',NULL),(663,7561,40855,12193,2,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',57089.00,NULL,NULL,1,'2023-01-19 12:54:06','2023-01-19 12:54:06',NULL),(664,7561,40855,12193,2,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',11665.00,NULL,NULL,1,'2023-01-19 12:54:06','2023-01-19 12:54:06',NULL),(665,7561,40855,12193,2,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',7730.00,NULL,NULL,1,'2023-01-19 12:54:06','2023-01-19 12:54:06',NULL);
INSERT INTO `balance_libro` VALUES (666,7561,40855,12193,2,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',5605.00,NULL,NULL,1,'2023-01-19 12:54:06','2023-01-19 12:54:06',NULL),(667,7561,40855,12193,2,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',6745.00,NULL,NULL,1,'2023-01-19 12:54:06','2023-01-19 12:54:06',NULL),(668,7561,40855,12193,2,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',20820.56,NULL,NULL,1,'2023-01-19 12:54:06','2023-01-19 12:54:06',NULL),(669,7561,40855,12194,2,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',13708.50,NULL,NULL,1,'2023-01-19 12:54:38','2023-01-19 12:54:38',NULL),(670,7561,40855,12194,2,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',20924.75,NULL,NULL,1,'2023-01-19 12:54:39','2023-01-19 12:54:39',NULL),(671,7561,40855,12194,2,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',15694.25,NULL,NULL,1,'2023-01-19 12:54:39','2023-01-19 12:54:39',NULL),(672,7561,40855,12194,2,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',29081.00,NULL,NULL,1,'2023-01-19 12:54:39','2023-01-19 12:54:39',NULL),(673,7561,40855,12194,2,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',25335.70,NULL,NULL,1,'2023-01-19 12:54:39','2023-01-19 12:54:39',NULL),(674,7561,40855,12194,2,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',6807.45,NULL,NULL,1,'2023-01-19 12:54:39','2023-01-19 12:54:39',NULL),(675,7561,40855,12194,2,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',42746.00,NULL,NULL,1,'2023-01-19 12:54:39','2023-01-19 12:54:39',NULL),(676,7561,40855,12194,2,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',8729.50,NULL,NULL,1,'2023-01-19 12:54:39','2023-01-19 12:54:39',NULL),(677,7561,40855,12194,2,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',4000.00,NULL,NULL,1,'2023-01-19 12:54:39','2023-01-19 12:54:39',NULL),(678,7561,40855,12194,2,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',6000.00,NULL,NULL,1,'2023-01-19 12:54:39','2023-01-19 12:54:39',NULL),(679,7561,40855,12194,2,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',6800.00,NULL,NULL,1,'2023-01-19 12:54:39','2023-01-19 12:54:39',NULL),(680,7561,40855,12194,2,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',21833.40,NULL,NULL,1,'2023-01-19 12:54:39','2023-01-19 12:54:39',NULL),(681,7561,40855,12195,2,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',18027.75,NULL,NULL,1,'2023-01-19 12:55:32','2023-01-19 12:55:32',NULL),(682,7561,40855,12195,2,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',16958.50,NULL,NULL,1,'2023-01-19 12:55:32','2023-01-19 12:55:32',NULL),(683,7561,40855,12195,2,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',17004.00,NULL,NULL,1,'2023-01-19 12:55:32','2023-01-19 12:55:32',NULL),(684,7561,40855,12195,2,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',3137.40,NULL,NULL,1,'2023-01-19 12:55:32','2023-01-19 12:55:32',NULL),(685,7561,40855,12195,2,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',22620.92,NULL,NULL,1,'2023-01-19 12:55:32','2023-01-19 12:55:32',NULL),(686,7561,40855,12195,2,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',62811.00,NULL,NULL,1,'2023-01-19 12:55:32','2023-01-19 12:55:32',NULL);
INSERT INTO `balance_libro` VALUES (687,7561,40855,12195,2,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',25050.00,NULL,NULL,1,'2023-01-19 12:55:32','2023-01-19 12:55:32',NULL),(688,7561,40855,12195,2,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',24270.00,NULL,NULL,1,'2023-01-19 12:55:32','2023-01-19 12:55:32',NULL),(689,7561,40855,12195,2,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',17466.00,NULL,NULL,1,'2023-01-19 12:55:32','2023-01-19 12:55:32',NULL),(690,7561,40855,12195,2,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4479.15,NULL,NULL,1,'2023-01-19 12:55:32','2023-01-19 12:55:32',NULL),(691,7561,40855,12195,2,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',15174.25,NULL,NULL,1,'2023-01-19 12:55:32','2023-01-19 12:55:32',NULL),(692,7561,40855,12195,2,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',15969.20,NULL,NULL,1,'2023-01-19 12:55:32','2023-01-19 12:55:32',NULL),(693,7561,40855,12195,2,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',18245.50,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(694,7561,40855,12195,2,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',25135.50,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(695,7561,40855,12195,2,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',16833.05,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(696,7561,40855,12195,2,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',16214.25,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(697,7561,40855,12195,2,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',16396.25,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(698,7561,40855,12195,2,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',16958.50,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(699,7561,40855,12195,2,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',11004.50,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(700,7561,40855,12195,2,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',8712.00,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(701,7561,40855,12195,2,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',5388.00,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(702,7561,40855,12195,2,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',10286.00,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(703,7561,40855,12195,2,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',6040.00,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(704,7561,40855,12195,2,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',8133.00,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(705,7561,40855,12195,2,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1758.00,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(706,7561,40855,12195,2,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1683.00,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(707,7561,40855,12195,2,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',595.00,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL);
INSERT INTO `balance_libro` VALUES (708,7561,40855,12195,2,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',73878.00,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(709,7561,40855,12195,2,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',71610.00,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(710,7561,40855,12195,2,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',56064.00,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(711,7561,40855,12195,2,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2084.50,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(712,7561,40855,12195,2,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',12242.75,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(713,7561,40855,12195,2,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',9995.70,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(714,7561,40855,12195,2,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',26422.50,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(715,7561,40855,12195,2,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',19915.95,NULL,NULL,1,'2023-01-19 12:55:33','2023-01-19 12:55:33',NULL),(716,7561,40855,12196,2,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',25684.75,NULL,NULL,1,'2023-01-19 12:56:18','2023-01-19 12:56:18',NULL),(717,7561,40855,12196,2,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',18031.00,NULL,NULL,1,'2023-01-19 12:56:18','2023-01-19 12:56:18',NULL),(718,7561,40855,12196,2,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',19006.00,NULL,NULL,1,'2023-01-19 12:56:18','2023-01-19 12:56:18',NULL),(719,7561,40855,12196,2,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',19006.00,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(720,7561,40855,12196,2,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',14437.80,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(721,7561,40855,12196,2,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',19006.00,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(722,7561,40855,12196,2,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',10310.79,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(723,7561,40855,12196,2,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',32271.30,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(724,7561,40855,12196,2,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',47165.00,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(725,7561,40855,12196,2,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',19909.50,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(726,7561,40855,12196,2,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',17000.00,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(727,7561,40855,12196,2,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',7000.00,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(728,7561,40855,12196,2,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',20917.00,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL);
INSERT INTO `balance_libro` VALUES (729,7561,40855,12196,2,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',15757.95,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(730,7561,40855,12196,2,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',17709.25,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(731,7561,40855,12196,2,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',4200.00,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(732,7561,40855,12196,2,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',24605.10,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(733,7561,40855,12196,2,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',18817.50,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(734,7561,40855,12196,2,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',22092.00,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(735,7561,40855,12196,2,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',1447.50,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(736,7561,40855,12196,2,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',17667.00,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(737,7561,40855,12196,2,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',19221.00,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(738,7561,40855,12196,2,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',46530.00,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(739,7561,40855,12196,2,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',31980.00,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(740,7561,40855,12196,2,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',10000.00,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(741,7561,40855,12196,2,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',28499.76,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(742,7561,40855,12196,2,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',2433.55,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(743,7561,40855,12196,2,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',20796.75,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(744,7561,40855,12196,2,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',5388.50,NULL,NULL,1,'2023-01-19 12:56:19','2023-01-19 12:56:19',NULL),(745,7561,40855,12197,2,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',37775.38,NULL,NULL,1,'2023-01-19 12:58:10','2023-01-19 12:58:10',NULL),(746,7561,40855,12197,2,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',20390.50,NULL,NULL,1,'2023-01-19 12:58:10','2023-01-19 12:58:10',NULL),(747,7561,40855,12197,2,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',1323.00,NULL,NULL,1,'2023-01-19 12:58:10','2023-01-19 12:58:10',NULL),(748,7561,40855,12197,2,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',2882.00,NULL,NULL,1,'2023-01-19 12:58:10','2023-01-19 12:58:10',NULL),(749,7561,40855,12197,2,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',4226.50,NULL,NULL,1,'2023-01-19 12:58:10','2023-01-19 12:58:10',NULL);
INSERT INTO `balance_libro` VALUES (750,7561,40855,12197,2,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',2940.00,NULL,NULL,1,'2023-01-19 12:58:10','2023-01-19 12:58:10',NULL),(751,7561,40855,12197,2,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',22127.00,NULL,NULL,1,'2023-01-19 12:58:10','2023-01-19 12:58:10',NULL),(752,7561,40855,12197,2,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',14170.00,NULL,NULL,1,'2023-01-19 12:58:10','2023-01-19 12:58:10',NULL),(753,7561,40855,12197,2,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',16282.50,NULL,NULL,1,'2023-01-19 12:58:10','2023-01-19 12:58:10',NULL),(754,7561,40855,12197,2,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',11930.00,NULL,NULL,1,'2023-01-19 12:58:10','2023-01-19 12:58:10',NULL),(755,7561,40855,12197,2,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',14165.00,NULL,NULL,1,'2023-01-19 12:58:10','2023-01-19 12:58:10',NULL),(756,7561,40855,12197,2,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',12598.00,NULL,NULL,1,'2023-01-19 12:58:10','2023-01-19 12:58:10',NULL),(757,7561,40855,12197,2,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',28652.40,NULL,NULL,1,'2023-01-19 12:58:10','2023-01-19 12:58:10',NULL),(758,7561,40855,12197,2,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',33585.00,NULL,NULL,1,'2023-01-19 12:58:10','2023-01-19 12:58:10',NULL),(759,7561,40855,12197,2,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',25050.00,NULL,NULL,1,'2023-01-19 12:58:11','2023-01-19 12:58:11',NULL),(760,7561,40855,12197,2,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',2546.00,NULL,NULL,1,'2023-01-19 12:58:11','2023-01-19 12:58:11',NULL),(761,7561,40855,12197,2,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',7842.00,NULL,NULL,1,'2023-01-19 12:58:11','2023-01-19 12:58:11',NULL),(762,7561,40855,12197,2,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',46506.00,NULL,NULL,1,'2023-01-19 12:58:11','2023-01-19 12:58:11',NULL),(763,7561,40855,12197,2,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',285.00,NULL,NULL,1,'2023-01-19 12:58:11','2023-01-19 12:58:11',NULL),(764,7561,40855,12197,2,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',36265.24,NULL,NULL,1,'2023-01-19 12:58:11','2023-01-19 12:58:11',NULL),(765,7561,40855,12197,2,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',13055.00,NULL,NULL,1,'2023-01-19 12:58:11','2023-01-19 12:58:11',NULL),(766,7561,40855,12197,2,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',13945.00,NULL,NULL,1,'2023-01-19 12:58:11','2023-01-19 12:58:11',NULL),(767,7561,40855,12197,2,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',3000.00,NULL,NULL,1,'2023-01-19 12:58:11','2023-01-19 12:58:11',NULL),(768,7561,40855,12197,2,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',49902.00,NULL,NULL,1,'2023-01-19 12:58:11','2023-01-19 12:58:11',NULL),(769,7561,40855,12197,2,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',55500.00,NULL,NULL,1,'2023-01-19 12:58:11','2023-01-19 12:58:11',NULL),(770,7561,40855,12198,2,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',43896.70,NULL,NULL,1,'2023-01-19 12:58:51','2023-01-19 12:58:51',NULL);
INSERT INTO `balance_libro` VALUES (771,7561,40855,12198,2,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',34701.00,NULL,NULL,1,'2023-01-19 12:58:51','2023-01-19 12:58:51',NULL),(772,7561,40855,12198,2,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',64038.00,NULL,NULL,1,'2023-01-19 12:58:51','2023-01-19 12:58:51',NULL),(773,7561,40855,12198,2,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',47226.00,NULL,NULL,1,'2023-01-19 12:58:51','2023-01-19 12:58:51',NULL),(774,7561,40855,12198,2,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',19500.00,NULL,NULL,1,'2023-01-19 12:58:51','2023-01-19 12:58:51',NULL),(775,7561,40855,12198,2,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',11250.00,NULL,NULL,1,'2023-01-19 12:58:51','2023-01-19 12:58:51',NULL),(776,7561,40855,12198,2,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',20917.00,NULL,NULL,1,'2023-01-19 12:58:51','2023-01-19 12:58:51',NULL),(777,7561,40855,12198,2,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',14430.00,NULL,NULL,1,'2023-01-19 12:58:51','2023-01-19 12:58:51',NULL),(778,7561,40855,12198,2,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2533.40,NULL,NULL,1,'2023-01-19 12:58:51','2023-01-19 12:58:51',NULL),(779,7561,40855,12198,2,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',28388.25,NULL,NULL,1,'2023-01-19 12:58:51','2023-01-19 12:58:51',NULL),(780,7561,40855,12198,2,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',18990.00,NULL,NULL,1,'2023-01-19 12:58:51','2023-01-19 12:58:51',NULL),(781,7561,40855,12198,2,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',15870.00,NULL,NULL,1,'2023-01-19 12:58:51','2023-01-19 12:58:51',NULL),(782,7561,40855,12198,2,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',20856.00,NULL,NULL,1,'2023-01-19 12:58:51','2023-01-19 12:58:51',NULL),(783,7561,40855,12198,2,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',13800.00,NULL,NULL,1,'2023-01-19 12:58:51','2023-01-19 12:58:51',NULL),(784,7561,40855,12198,2,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',9000.00,NULL,NULL,1,'2023-01-19 12:58:51','2023-01-19 12:58:51',NULL),(785,7561,40855,12198,2,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',5600.00,NULL,NULL,1,'2023-01-19 12:58:51','2023-01-19 12:58:51',NULL),(786,7561,40855,12199,2,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',3938.72,NULL,NULL,1,'2023-01-19 12:59:21','2023-01-19 12:59:21',NULL),(787,7561,40855,12199,2,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',32972.00,NULL,NULL,1,'2023-01-19 12:59:21','2023-01-19 12:59:21',NULL),(788,7561,40855,12199,2,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',61538.25,NULL,NULL,1,'2023-01-19 12:59:21','2023-01-19 12:59:21',NULL),(789,7561,40855,12199,2,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',17850.00,NULL,NULL,1,'2023-01-19 12:59:21','2023-01-19 12:59:21',NULL),(790,7561,40855,12199,2,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',32402.50,NULL,NULL,1,'2023-01-19 12:59:22','2023-01-19 12:59:22',NULL),(791,7561,40855,12199,2,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',22945.00,NULL,NULL,1,'2023-01-19 12:59:22','2023-01-19 12:59:22',NULL);
INSERT INTO `balance_libro` VALUES (792,7561,40855,12199,2,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',29217.50,NULL,NULL,1,'2023-01-19 12:59:22','2023-01-19 12:59:22',NULL),(793,7561,40855,12199,2,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',2241.50,NULL,NULL,1,'2023-01-19 12:59:22','2023-01-19 12:59:22',NULL),(794,7561,40855,12199,2,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',1993.00,NULL,NULL,1,'2023-01-19 12:59:22','2023-01-19 12:59:22',NULL),(795,7561,40855,12199,2,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',1827.40,NULL,NULL,1,'2023-01-19 12:59:22','2023-01-19 12:59:22',NULL),(796,7561,40855,12199,2,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',14530.00,NULL,NULL,1,'2023-01-19 12:59:22','2023-01-19 12:59:22',NULL),(797,7561,40855,12199,2,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',37908.85,NULL,NULL,1,'2023-01-19 12:59:22','2023-01-19 12:59:22',NULL),(798,7561,40855,12199,2,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',9600.00,NULL,NULL,1,'2023-01-19 12:59:22','2023-01-19 12:59:22',NULL),(799,7561,40855,12200,2,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',21505.85,NULL,NULL,1,'2023-01-19 12:59:55','2023-01-19 12:59:55',NULL),(800,7561,40855,12200,2,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',26142.00,NULL,NULL,1,'2023-01-19 12:59:55','2023-01-19 12:59:55',NULL),(801,7561,40855,12200,2,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',48960.00,NULL,NULL,1,'2023-01-19 12:59:55','2023-01-19 12:59:55',NULL),(802,7561,40855,12200,2,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',7940.00,NULL,NULL,1,'2023-01-19 12:59:55','2023-01-19 12:59:55',NULL),(803,7561,40855,12200,2,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',25220.00,NULL,NULL,1,'2023-01-19 12:59:55','2023-01-19 12:59:55',NULL),(804,7561,40855,12200,2,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',28860.00,NULL,NULL,1,'2023-01-19 12:59:55','2023-01-19 12:59:55',NULL),(805,7561,40855,12200,2,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',2925.00,NULL,NULL,1,'2023-01-19 12:59:55','2023-01-19 12:59:55',NULL),(806,7561,40855,12200,2,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',37472.50,NULL,NULL,1,'2023-01-19 12:59:55','2023-01-19 12:59:55',NULL),(807,7561,40855,12200,2,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',32324.50,NULL,NULL,1,'2023-01-19 12:59:55','2023-01-19 12:59:55',NULL),(808,7561,40855,12200,2,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',47320.00,NULL,NULL,1,'2023-01-19 12:59:55','2023-01-19 12:59:55',NULL),(809,7561,40855,12200,2,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',67827.50,NULL,NULL,1,'2023-01-19 12:59:55','2023-01-19 12:59:55',NULL),(810,7561,40855,12200,2,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',44986.50,NULL,NULL,1,'2023-01-19 12:59:55','2023-01-19 12:59:55',NULL),(811,7561,40855,12200,2,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',47879.00,NULL,NULL,1,'2023-01-19 12:59:55','2023-01-19 12:59:55',NULL),(812,7561,40855,12200,2,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',28502.63,NULL,NULL,1,'2023-01-19 12:59:55','2023-01-19 12:59:55',NULL);
INSERT INTO `balance_libro` VALUES (813,7561,40855,12200,2,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',31557.50,NULL,NULL,1,'2023-01-19 12:59:55','2023-01-19 12:59:55',NULL),(814,7561,40855,12200,2,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',23520.00,NULL,NULL,1,'2023-01-19 12:59:55','2023-01-19 12:59:55',NULL),(815,7561,40855,12200,2,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',39650.00,NULL,NULL,1,'2023-01-19 12:59:55','2023-01-19 12:59:55',NULL),(816,7561,40855,12200,2,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',17034.65,NULL,NULL,1,'2023-01-19 12:59:55','2023-01-19 12:59:55',NULL),(834,7561,40850,4548,2,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2500.00,NULL,NULL,1,'2023-01-19 14:01:38','2023-01-19 14:01:38',NULL),(835,7561,40850,4548,2,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2500.00,NULL,NULL,1,'2023-01-19 14:01:38','2023-01-19 14:01:38',NULL),(836,7561,40850,4548,2,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(837,7561,40850,4548,2,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(838,7561,40850,4548,2,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(839,7561,40850,4548,2,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(840,7561,40850,4548,2,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(841,7561,40850,4548,2,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(842,7561,40850,4548,2,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(843,7561,40850,4548,2,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(844,7561,40850,4548,2,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(845,7561,40850,4548,2,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(846,7561,40850,4548,2,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(847,7561,40850,4548,2,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(848,7561,40850,4548,2,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(849,7561,40850,4548,2,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(850,7561,40850,4548,2,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL);
INSERT INTO `balance_libro` VALUES (851,7561,40850,4548,2,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(852,7561,40850,4548,2,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(853,7561,40850,4548,2,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(854,7561,40850,4548,2,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(855,7561,40850,4548,2,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(856,7561,40850,4548,2,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(857,7561,40850,4548,2,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(858,7561,40850,4548,2,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(859,7561,40850,4548,2,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(860,7561,40850,4548,2,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(861,7561,40850,4548,2,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(862,7561,40850,4548,2,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2500.00,NULL,NULL,1,'2023-01-19 14:01:39','2023-01-19 14:01:39',NULL),(863,7561,40850,4548,2,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2500.00,NULL,NULL,1,'2023-01-19 14:01:40','2023-01-19 14:01:40',NULL),(864,7561,40850,4548,2,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2500.00,NULL,NULL,1,'2023-01-19 14:01:40','2023-01-19 14:01:40',NULL),(865,7561,40850,4548,2,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',2500.00,NULL,NULL,1,'2023-01-19 14:01:40','2023-01-19 14:01:40',NULL),(866,7561,40850,4548,2,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',2500.00,NULL,NULL,1,'2023-01-19 14:01:40','2023-01-19 14:01:40',NULL),(867,7561,40850,4548,2,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2500.00,NULL,NULL,1,'2023-01-19 14:01:40','2023-01-19 14:01:40',NULL),(868,7561,40850,4548,2,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2500.00,NULL,NULL,1,'2023-01-19 14:01:40','2023-01-19 14:01:40',NULL),(869,7561,40850,4548,2,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2500.00,NULL,NULL,1,'2023-01-19 14:01:40','2023-01-19 14:01:40',NULL),(870,7561,40850,4548,2,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2500.00,NULL,NULL,1,'2023-01-19 14:01:40','2023-01-19 14:01:40',NULL),(871,7561,40850,4548,2,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2500.00,NULL,NULL,1,'2023-01-19 14:01:40','2023-01-19 14:01:40',NULL);
INSERT INTO `balance_libro` VALUES (872,7561,40850,4548,2,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2500.00,NULL,NULL,1,'2023-01-19 14:01:40','2023-01-19 14:01:40',NULL),(873,7561,40850,4548,2,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2500.00,NULL,NULL,1,'2023-01-19 14:01:40','2023-01-19 14:01:40',NULL),(874,7561,40850,4548,2,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2500.00,NULL,NULL,1,'2023-01-19 14:01:40','2023-01-19 14:01:40',NULL),(875,7561,40850,4548,2,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2500.00,NULL,NULL,1,'2023-01-19 14:01:40','2023-01-19 14:01:40',NULL),(876,7561,40850,4548,2,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2500.00,NULL,NULL,1,'2023-01-19 14:01:40','2023-01-19 14:01:40',NULL),(877,7561,40850,4548,2,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2500.00,NULL,NULL,1,'2023-01-19 14:01:40','2023-01-19 14:01:40',NULL),(878,7561,40850,4548,2,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2500.00,NULL,NULL,1,'2023-01-19 14:01:40','2023-01-19 14:01:40',NULL),(879,7561,40850,4548,2,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2500.00,NULL,NULL,1,'2023-01-19 14:01:40','2023-01-19 14:01:40',NULL),(880,7561,40850,4548,2,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2500.00,NULL,NULL,1,'2023-01-19 14:01:40','2023-01-19 14:01:40',NULL),(926,7561,40850,4549,2,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',2500.00,NULL,NULL,1,'2023-01-19 14:08:17','2023-01-19 14:08:17',NULL),(927,7561,40850,4549,2,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',2500.00,NULL,NULL,1,'2023-01-19 14:08:17','2023-01-19 14:08:17',NULL),(928,7561,40850,4549,2,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',2500.00,NULL,NULL,1,'2023-01-19 14:08:17','2023-01-19 14:08:17',NULL),(929,7561,40850,4549,2,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(930,7561,40850,4549,2,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(931,7561,40850,4549,2,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(932,7561,40850,4549,2,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(933,7561,40850,4549,2,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(934,7561,40850,4549,2,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(935,7561,40850,4549,2,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(936,7561,40850,4549,2,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(937,7561,40850,4549,2,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL);
INSERT INTO `balance_libro` VALUES (938,7561,40850,4549,2,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(939,7561,40850,4549,2,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(940,7561,40850,4549,2,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(941,7561,40850,4549,2,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(942,7561,40850,4549,2,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(943,7561,40850,4549,2,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(944,7561,40850,4549,2,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(945,7561,40850,4549,2,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(946,7561,40850,4549,2,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(947,7561,40850,4549,2,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(948,7561,40850,4549,2,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(949,7561,40850,4549,2,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(950,7561,40850,4549,2,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(951,7561,40850,4549,2,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(952,7561,40850,4549,2,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(953,7561,40850,4549,2,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(954,7561,40850,4549,2,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(955,7561,40850,4549,2,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(956,7561,40850,4549,2,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',2500.00,NULL,NULL,1,'2023-01-19 14:08:18','2023-01-19 14:08:18',NULL),(957,7561,40850,4549,2,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL),(958,7561,40850,4549,2,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL);
INSERT INTO `balance_libro` VALUES (959,7561,40850,4549,2,747,'App\\Models\\Receipt',747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL),(960,7561,40850,4549,2,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL),(961,7561,40850,4549,2,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL),(962,7561,40850,4549,2,750,'App\\Models\\Receipt',750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL),(963,7561,40850,4549,2,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL),(964,7561,40850,4549,2,752,'App\\Models\\Receipt',752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL),(965,7561,40850,4549,2,753,'App\\Models\\Receipt',753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL),(966,7561,40850,4549,2,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL),(967,7561,40850,4549,2,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL),(968,7561,40850,4549,2,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL),(969,7561,40850,4549,2,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL),(970,7561,40850,4549,2,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL),(971,7561,40850,4549,2,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL),(972,7561,40850,4549,2,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL),(973,7561,40850,4549,2,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL),(974,7561,40850,4549,2,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL),(975,7561,40850,4549,2,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL),(976,7561,40850,4549,2,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2500.00,NULL,NULL,1,'2023-01-19 14:08:19','2023-01-19 14:08:19',NULL),(977,7561,40850,4550,2,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',2500.00,NULL,NULL,1,'2023-01-19 14:09:38','2023-01-19 14:09:38',NULL),(978,7561,40850,4550,2,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',2500.00,NULL,NULL,1,'2023-01-19 14:09:38','2023-01-19 14:09:38',NULL),(979,7561,40850,4550,2,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',2500.00,NULL,NULL,1,'2023-01-19 14:09:38','2023-01-19 14:09:38',NULL);
INSERT INTO `balance_libro` VALUES (980,7561,40850,4550,2,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',2500.00,NULL,NULL,1,'2023-01-19 14:09:38','2023-01-19 14:09:38',NULL),(981,7561,40850,4550,2,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',2500.00,NULL,NULL,1,'2023-01-19 14:09:38','2023-01-19 14:09:38',NULL),(982,7561,40850,4550,2,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',2500.00,NULL,NULL,1,'2023-01-19 14:09:38','2023-01-19 14:09:38',NULL),(983,7561,40850,4550,2,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2500.00,NULL,NULL,1,'2023-01-19 14:09:38','2023-01-19 14:09:38',NULL),(984,7561,40850,4550,2,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2500.00,NULL,NULL,1,'2023-01-19 14:09:38','2023-01-19 14:09:38',NULL),(985,7561,40850,4550,2,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2500.00,NULL,NULL,1,'2023-01-19 14:09:38','2023-01-19 14:09:38',NULL),(986,7561,40850,4550,2,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2500.00,NULL,NULL,1,'2023-01-19 14:09:38','2023-01-19 14:09:38',NULL),(987,7561,40850,4550,2,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',2500.00,NULL,NULL,1,'2023-01-19 14:09:38','2023-01-19 14:09:38',NULL),(988,7561,40850,4550,2,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',2500.00,NULL,NULL,1,'2023-01-19 14:09:39','2023-01-19 14:09:39',NULL),(989,7561,40850,4550,2,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',2500.00,NULL,NULL,1,'2023-01-19 14:09:39','2023-01-19 14:09:39',NULL),(990,7561,40850,4550,2,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',2500.00,NULL,NULL,1,'2023-01-19 14:09:39','2023-01-19 14:09:39',NULL),(991,7561,40850,4550,2,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',2500.00,NULL,NULL,1,'2023-01-19 14:09:39','2023-01-19 14:09:39',NULL),(992,7561,40850,4550,2,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',2500.00,NULL,NULL,1,'2023-01-19 14:09:39','2023-01-19 14:09:39',NULL),(993,7561,40850,4550,2,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',2500.00,NULL,NULL,1,'2023-01-19 14:09:39','2023-01-19 14:09:39',NULL),(994,7561,40850,4550,2,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',2500.00,NULL,NULL,1,'2023-01-19 14:09:39','2023-01-19 14:09:39',NULL),(995,7561,40850,4550,2,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',2500.00,NULL,NULL,1,'2023-01-19 14:09:39','2023-01-19 14:09:39',NULL),(996,7561,40850,4550,2,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2500.00,NULL,NULL,1,'2023-01-19 14:09:39','2023-01-19 14:09:39',NULL),(997,7561,40850,4550,2,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2500.00,NULL,NULL,1,'2023-01-19 14:09:39','2023-01-19 14:09:39',NULL),(998,7561,40850,4550,2,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2500.00,NULL,NULL,1,'2023-01-19 14:09:39','2023-01-19 14:09:39',NULL),(999,7561,40850,4550,2,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',2500.00,NULL,NULL,1,'2023-01-19 14:09:39','2023-01-19 14:09:39',NULL),(1000,7561,40850,4550,2,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',2500.00,NULL,NULL,1,'2023-01-19 14:09:39','2023-01-19 14:09:39',NULL);
INSERT INTO `balance_libro` VALUES (1001,7561,40850,4550,2,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',2500.00,NULL,NULL,1,'2023-01-19 14:09:39','2023-01-19 14:09:39',NULL),(1002,7561,40850,4550,2,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',2500.00,NULL,NULL,1,'2023-01-19 14:09:40','2023-01-19 14:09:40',NULL),(1003,7561,40850,4550,2,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',2500.00,NULL,NULL,1,'2023-01-19 14:09:40','2023-01-19 14:09:40',NULL),(1004,7561,40850,4550,2,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2500.00,NULL,NULL,1,'2023-01-19 14:09:40','2023-01-19 14:09:40',NULL),(1005,7561,40850,4550,2,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2500.00,NULL,NULL,1,'2023-01-19 14:09:40','2023-01-19 14:09:40',NULL),(1006,7561,40850,4550,2,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',2500.00,NULL,NULL,1,'2023-01-19 14:09:40','2023-01-19 14:09:40',NULL),(1007,7561,40850,4550,2,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',2500.00,NULL,NULL,1,'2023-01-19 14:09:40','2023-01-19 14:09:40',NULL),(1008,7561,40850,4550,2,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',2500.00,NULL,NULL,1,'2023-01-19 14:09:40','2023-01-19 14:09:40',NULL),(1009,7561,40850,4550,2,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',2500.00,NULL,NULL,1,'2023-01-19 14:09:40','2023-01-19 14:09:40',NULL),(1010,7561,40850,4550,2,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2500.00,NULL,NULL,1,'2023-01-19 14:09:40','2023-01-19 14:09:40',NULL),(1011,7561,40850,4550,2,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2500.00,NULL,NULL,1,'2023-01-19 14:09:40','2023-01-19 14:09:40',NULL),(1012,7561,40850,4550,2,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2500.00,NULL,NULL,1,'2023-01-19 14:09:40','2023-01-19 14:09:40',NULL),(1013,7561,40850,4550,2,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2500.00,NULL,NULL,1,'2023-01-19 14:09:40','2023-01-19 14:09:40',NULL),(1014,7561,40850,4550,2,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2500.00,NULL,NULL,1,'2023-01-19 14:09:40','2023-01-19 14:09:40',NULL),(1015,7561,40850,4550,2,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2500.00,NULL,NULL,1,'2023-01-19 14:09:41','2023-01-19 14:09:41',NULL),(1016,7561,40850,4550,2,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2500.00,NULL,NULL,1,'2023-01-19 14:09:41','2023-01-19 14:09:41',NULL),(1017,7561,40850,4550,2,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2500.00,NULL,NULL,1,'2023-01-19 14:09:41','2023-01-19 14:09:41',NULL),(1018,7561,40850,4550,2,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',2500.00,NULL,NULL,1,'2023-01-19 14:09:41','2023-01-19 14:09:41',NULL),(1019,7561,40850,4550,2,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',2500.00,NULL,NULL,1,'2023-01-19 14:09:41','2023-01-19 14:09:41',NULL),(1020,7561,40850,4550,2,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2500.00,NULL,NULL,1,'2023-01-19 14:09:41','2023-01-19 14:09:41',NULL),(1021,7561,40850,4550,2,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2500.00,NULL,NULL,1,'2023-01-19 14:09:41','2023-01-19 14:09:41',NULL);
INSERT INTO `balance_libro` VALUES (1022,7561,40850,4550,2,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2500.00,NULL,NULL,1,'2023-01-19 14:09:41','2023-01-19 14:09:41',NULL),(1023,7561,40850,4550,2,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2500.00,NULL,NULL,1,'2023-01-19 14:09:41','2023-01-19 14:09:41',NULL),(1024,7561,40850,4550,2,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2500.00,NULL,NULL,1,'2023-01-19 14:09:41','2023-01-19 14:09:41',NULL),(1025,7561,40850,4550,2,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2500.00,NULL,NULL,1,'2023-01-19 14:09:41','2023-01-19 14:09:41',NULL),(1026,7561,40850,4541,2,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1600.00,NULL,NULL,1,'2023-01-19 14:26:49','2023-01-19 14:26:49',NULL),(1027,7561,40850,4541,2,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1600.00,NULL,NULL,1,'2023-01-19 14:26:49','2023-01-19 14:26:49',NULL),(1028,7561,40850,4541,2,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1600.00,NULL,NULL,1,'2023-01-19 14:26:49','2023-01-19 14:26:49',NULL),(1029,7561,40850,4541,2,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',1600.00,NULL,NULL,1,'2023-01-19 14:26:49','2023-01-19 14:26:49',NULL),(1030,7561,40850,4541,2,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',1600.00,NULL,NULL,1,'2023-01-19 14:26:49','2023-01-19 14:26:49',NULL),(1031,7561,40850,4541,2,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1600.00,NULL,NULL,1,'2023-01-19 14:26:49','2023-01-19 14:26:49',NULL),(1032,7561,40850,4541,2,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1600.00,NULL,NULL,1,'2023-01-19 14:26:49','2023-01-19 14:26:49',NULL),(1033,7561,40850,4541,2,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1600.00,NULL,NULL,1,'2023-01-19 14:26:49','2023-01-19 14:26:49',NULL),(1034,7561,40850,4541,2,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1600.00,NULL,NULL,1,'2023-01-19 14:26:49','2023-01-19 14:26:49',NULL),(1035,7561,40850,4541,2,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1600.00,NULL,NULL,1,'2023-01-19 14:26:49','2023-01-19 14:26:49',NULL),(1036,7561,40850,4541,2,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1037,7561,40850,4541,2,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1038,7561,40850,4541,2,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1039,7561,40850,4541,2,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1040,7561,40850,4541,2,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1041,7561,40850,4541,2,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1042,7561,40850,4541,2,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL);
INSERT INTO `balance_libro` VALUES (1043,7561,40850,4541,2,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1044,7561,40850,4541,2,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1045,7561,40850,4541,2,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1046,7561,40850,4541,2,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1047,7561,40850,4541,2,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1048,7561,40850,4541,2,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1049,7561,40850,4541,2,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1050,7561,40850,4541,2,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1051,7561,40850,4541,2,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1052,7561,40850,4541,2,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1053,7561,40850,4541,2,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1054,7561,40850,4541,2,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1055,7561,40850,4541,2,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1056,7561,40850,4541,2,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1057,7561,40850,4541,2,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1058,7561,40850,4541,2,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1059,7561,40850,4541,2,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1060,7561,40850,4541,2,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1061,7561,40850,4541,2,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1062,7561,40850,4541,2,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1600.00,NULL,NULL,1,'2023-01-19 14:26:50','2023-01-19 14:26:50',NULL),(1063,7561,40850,4542,2,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1700.00,NULL,NULL,1,'2023-01-19 14:27:28','2023-01-19 14:27:28',NULL);
INSERT INTO `balance_libro` VALUES (1064,7561,40850,4542,2,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1700.00,NULL,NULL,1,'2023-01-19 14:27:28','2023-01-19 14:27:28',NULL),(1065,7561,40850,4542,2,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1066,7561,40850,4542,2,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1067,7561,40850,4542,2,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1068,7561,40850,4542,2,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1069,7561,40850,4542,2,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1070,7561,40850,4542,2,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1071,7561,40850,4542,2,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1072,7561,40850,4542,2,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1073,7561,40850,4542,2,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1074,7561,40850,4542,2,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1075,7561,40850,4542,2,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1076,7561,40850,4542,2,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1077,7561,40850,4542,2,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1078,7561,40850,4542,2,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1079,7561,40850,4542,2,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1080,7561,40850,4542,2,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1081,7561,40850,4542,2,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1082,7561,40850,4542,2,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1083,7561,40850,4542,2,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1084,7561,40850,4542,2,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL);
INSERT INTO `balance_libro` VALUES (1085,7561,40850,4542,2,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1086,7561,40850,4542,2,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1087,7561,40850,4542,2,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1088,7561,40850,4542,2,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',1700.00,NULL,NULL,1,'2023-01-19 14:27:29','2023-01-19 14:27:29',NULL),(1089,7561,40850,4542,2,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',1700.00,NULL,NULL,1,'2023-01-19 14:27:30','2023-01-19 14:27:30',NULL),(1090,7561,40850,4542,2,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',1700.00,NULL,NULL,1,'2023-01-19 14:27:30','2023-01-19 14:27:30',NULL),(1091,7561,40850,4542,2,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',1700.00,NULL,NULL,1,'2023-01-19 14:27:30','2023-01-19 14:27:30',NULL),(1092,7561,40850,4542,2,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',1700.00,NULL,NULL,1,'2023-01-19 14:27:30','2023-01-19 14:27:30',NULL),(1093,7561,40850,4542,2,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',1700.00,NULL,NULL,1,'2023-01-19 14:27:30','2023-01-19 14:27:30',NULL),(1094,7561,40850,4542,2,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',1700.00,NULL,NULL,1,'2023-01-19 14:27:30','2023-01-19 14:27:30',NULL),(1095,7561,40850,4542,2,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',1700.00,NULL,NULL,1,'2023-01-19 14:27:30','2023-01-19 14:27:30',NULL),(1096,7561,40850,4542,2,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',1700.00,NULL,NULL,1,'2023-01-19 14:27:30','2023-01-19 14:27:30',NULL),(1097,7561,40850,4542,2,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',1700.00,NULL,NULL,1,'2023-01-19 14:27:30','2023-01-19 14:27:30',NULL),(1098,7561,40850,4542,2,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',1700.00,NULL,NULL,1,'2023-01-19 14:27:30','2023-01-19 14:27:30',NULL),(1099,7561,40850,4542,2,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',1700.00,NULL,NULL,1,'2023-01-19 14:27:30','2023-01-19 14:27:30',NULL),(1100,7561,40850,4542,2,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',1700.00,NULL,NULL,1,'2023-01-19 14:27:30','2023-01-19 14:27:30',NULL),(1101,7561,40850,4542,2,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',1700.00,NULL,NULL,1,'2023-01-19 14:27:30','2023-01-19 14:27:30',NULL),(1102,7561,40850,4542,2,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',1700.00,NULL,NULL,1,'2023-01-19 14:27:30','2023-01-19 14:27:30',NULL),(1103,7561,40850,4542,2,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1700.00,NULL,NULL,1,'2023-01-19 14:27:30','2023-01-19 14:27:30',NULL),(1104,7561,40850,4542,2,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1700.00,NULL,NULL,1,'2023-01-19 14:27:30','2023-01-19 14:27:30',NULL),(1105,7561,40850,4542,2,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1700.00,NULL,NULL,1,'2023-01-19 14:27:30','2023-01-19 14:27:30',NULL);
INSERT INTO `balance_libro` VALUES (1106,7561,40850,4542,2,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1700.00,NULL,NULL,1,'2023-01-19 14:27:30','2023-01-19 14:27:30',NULL),(1107,7561,40850,4542,2,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1700.00,NULL,NULL,1,'2023-01-19 14:27:30','2023-01-19 14:27:30',NULL),(1108,7561,40850,4543,2,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',1700.00,NULL,NULL,1,'2023-01-19 14:28:17','2023-01-19 14:28:17',NULL),(1109,7561,40850,4543,2,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',1700.00,NULL,NULL,1,'2023-01-19 14:28:17','2023-01-19 14:28:17',NULL),(1110,7561,40850,4543,2,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',1700.00,NULL,NULL,1,'2023-01-19 14:28:17','2023-01-19 14:28:17',NULL),(1111,7561,40850,4543,2,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',1700.00,NULL,NULL,1,'2023-01-19 14:28:17','2023-01-19 14:28:17',NULL),(1112,7561,40850,4543,2,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',1700.00,NULL,NULL,1,'2023-01-19 14:28:17','2023-01-19 14:28:17',NULL),(1113,7561,40850,4543,2,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',1700.00,NULL,NULL,1,'2023-01-19 14:28:17','2023-01-19 14:28:17',NULL),(1114,7561,40850,4543,2,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',1700.00,NULL,NULL,1,'2023-01-19 14:28:17','2023-01-19 14:28:17',NULL),(1115,7561,40850,4543,2,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',1700.00,NULL,NULL,1,'2023-01-19 14:28:17','2023-01-19 14:28:17',NULL),(1116,7561,40850,4543,2,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',1700.00,NULL,NULL,1,'2023-01-19 14:28:17','2023-01-19 14:28:17',NULL),(1117,7561,40850,4543,2,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',1700.00,NULL,NULL,1,'2023-01-19 14:28:17','2023-01-19 14:28:17',NULL),(1118,7561,40850,4543,2,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',1700.00,NULL,NULL,1,'2023-01-19 14:28:17','2023-01-19 14:28:17',NULL),(1119,7561,40850,4543,2,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1120,7561,40850,4543,2,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1121,7561,40850,4543,2,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1122,7561,40850,4543,2,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1123,7561,40850,4543,2,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1124,7561,40850,4543,2,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1125,7561,40850,4543,2,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1126,7561,40850,4543,2,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL);
INSERT INTO `balance_libro` VALUES (1127,7561,40850,4543,2,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1128,7561,40850,4543,2,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1129,7561,40850,4543,2,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1130,7561,40850,4543,2,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1131,7561,40850,4543,2,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1132,7561,40850,4543,2,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1133,7561,40850,4543,2,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1134,7561,40850,4543,2,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1135,7561,40850,4543,2,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1136,7561,40850,4543,2,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1137,7561,40850,4543,2,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1138,7561,40850,4543,2,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1139,7561,40850,4543,2,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1140,7561,40850,4543,2,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1141,7561,40850,4543,2,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1142,7561,40850,4543,2,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1143,7561,40850,4543,2,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1144,7561,40850,4543,2,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1145,7561,40850,4543,2,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1146,7561,40850,4543,2,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1147,7561,40850,4543,2,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL);
INSERT INTO `balance_libro` VALUES (1148,7561,40850,4543,2,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',1700.00,NULL,NULL,1,'2023-01-19 14:28:18','2023-01-19 14:28:18',NULL),(1149,7561,40850,4543,2,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',1700.00,NULL,NULL,1,'2023-01-19 14:28:19','2023-01-19 14:28:19',NULL),(1150,7561,40850,4543,2,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',1700.00,NULL,NULL,1,'2023-01-19 14:28:19','2023-01-19 14:28:19',NULL),(1151,7561,40850,4543,2,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',1700.00,NULL,NULL,1,'2023-01-19 14:28:19','2023-01-19 14:28:19',NULL),(1152,7561,40850,4543,2,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',1700.00,NULL,NULL,1,'2023-01-19 14:28:19','2023-01-19 14:28:19',NULL),(1153,7561,40850,4543,2,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',1700.00,NULL,NULL,1,'2023-01-19 14:28:19','2023-01-19 14:28:19',NULL),(1154,7561,40850,4543,2,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',1700.00,NULL,NULL,1,'2023-01-19 14:28:19','2023-01-19 14:28:19',NULL),(1155,7561,40850,4543,2,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',1700.00,NULL,NULL,1,'2023-01-19 14:28:19','2023-01-19 14:28:19',NULL),(1156,7561,40850,4543,2,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1700.00,NULL,NULL,1,'2023-01-19 14:28:19','2023-01-19 14:28:19',NULL),(1157,7561,40850,4543,2,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1700.00,NULL,NULL,1,'2023-01-19 14:28:19','2023-01-19 14:28:19',NULL),(1158,7561,40850,4543,2,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1700.00,NULL,NULL,1,'2023-01-19 14:28:19','2023-01-19 14:28:19',NULL),(1159,7561,40850,4545,2,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL),(1160,7561,40850,4545,2,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL),(1161,7561,40850,4545,2,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL),(1162,7561,40850,4545,2,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL),(1163,7561,40850,4545,2,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL),(1164,7561,40850,4545,2,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL),(1165,7561,40850,4545,2,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL),(1166,7561,40850,4545,2,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL),(1167,7561,40850,4545,2,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL),(1168,7561,40850,4545,2,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL);
INSERT INTO `balance_libro` VALUES (1169,7561,40850,4545,2,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL),(1170,7561,40850,4545,2,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL),(1171,7561,40850,4545,2,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL),(1172,7561,40850,4545,2,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL),(1173,7561,40850,4545,2,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL),(1174,7561,40850,4545,2,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL),(1175,7561,40850,4545,2,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL),(1176,7561,40850,4545,2,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL),(1177,7561,40850,4545,2,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL),(1178,7561,40850,4545,2,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1800.00,NULL,NULL,1,'2023-01-19 14:34:07','2023-01-19 14:34:07',NULL),(1179,7561,40850,4545,2,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1180,7561,40850,4545,2,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1181,7561,40850,4545,2,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1182,7561,40850,4545,2,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1183,7561,40850,4545,2,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1184,7561,40850,4545,2,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1185,7561,40850,4545,2,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1186,7561,40850,4545,2,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1187,7561,40850,4545,2,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1188,7561,40850,4545,2,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1189,7561,40850,4545,2,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL);
INSERT INTO `balance_libro` VALUES (1190,7561,40850,4545,2,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1191,7561,40850,4545,2,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1192,7561,40850,4545,2,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1193,7561,40850,4545,2,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1194,7561,40850,4545,2,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1195,7561,40850,4545,2,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1196,7561,40850,4545,2,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1197,7561,40850,4545,2,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1198,7561,40850,4545,2,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1199,7561,40850,4545,2,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1200,7561,40850,4545,2,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1201,7561,40850,4545,2,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1202,7561,40850,4545,2,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1203,7561,40850,4545,2,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1204,7561,40850,4545,2,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',1800.00,NULL,NULL,1,'2023-01-19 14:34:08','2023-01-19 14:34:08',NULL),(1205,7561,40850,4545,2,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',1800.00,NULL,NULL,1,'2023-01-19 14:34:09','2023-01-19 14:34:09',NULL),(1206,7561,40850,4545,2,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',1800.00,NULL,NULL,1,'2023-01-19 14:34:09','2023-01-19 14:34:09',NULL),(1207,7561,40850,4545,2,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1800.00,NULL,NULL,1,'2023-01-19 14:34:09','2023-01-19 14:34:09',NULL),(1208,7561,40850,4545,2,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1800.00,NULL,NULL,1,'2023-01-19 14:34:09','2023-01-19 14:34:09',NULL),(1209,7561,40850,4545,2,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1800.00,NULL,NULL,1,'2023-01-19 14:34:09','2023-01-19 14:34:09',NULL),(1210,7561,40850,4545,2,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1800.00,NULL,NULL,1,'2023-01-19 14:34:09','2023-01-19 14:34:09',NULL);
INSERT INTO `balance_libro` VALUES (1211,7561,40850,4546,2,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2000.00,NULL,NULL,1,'2023-01-19 14:34:28','2023-01-19 14:34:28',NULL),(1212,7561,40850,4546,2,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2000.00,NULL,NULL,1,'2023-01-19 14:34:28','2023-01-19 14:34:28',NULL),(1213,7561,40850,4546,2,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2000.00,NULL,NULL,1,'2023-01-19 14:34:28','2023-01-19 14:34:28',NULL),(1214,7561,40850,4546,2,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',2000.00,NULL,NULL,1,'2023-01-19 14:34:28','2023-01-19 14:34:28',NULL),(1215,7561,40850,4546,2,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',2000.00,NULL,NULL,1,'2023-01-19 14:34:28','2023-01-19 14:34:28',NULL),(1216,7561,40850,4546,2,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',2000.00,NULL,NULL,1,'2023-01-19 14:34:28','2023-01-19 14:34:28',NULL),(1217,7561,40850,4546,2,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1218,7561,40850,4546,2,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1219,7561,40850,4546,2,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1220,7561,40850,4546,2,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1221,7561,40850,4546,2,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1222,7561,40850,4546,2,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1223,7561,40850,4546,2,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1224,7561,40850,4546,2,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1225,7561,40850,4546,2,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1226,7561,40850,4546,2,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1227,7561,40850,4546,2,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1228,7561,40850,4546,2,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1229,7561,40850,4546,2,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1230,7561,40850,4546,2,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1231,7561,40850,4546,2,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL);
INSERT INTO `balance_libro` VALUES (1232,7561,40850,4546,2,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1233,7561,40850,4546,2,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1234,7561,40850,4546,2,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1235,7561,40850,4546,2,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1236,7561,40850,4546,2,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1237,7561,40850,4546,2,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1238,7561,40850,4546,2,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1239,7561,40850,4546,2,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1240,7561,40850,4546,2,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1241,7561,40850,4546,2,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1242,7561,40850,4546,2,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1243,7561,40850,4546,2,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',2000.00,NULL,NULL,1,'2023-01-19 14:34:29','2023-01-19 14:34:29',NULL),(1244,7561,40850,4546,2,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1245,7561,40850,4546,2,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1246,7561,40850,4546,2,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1247,7561,40850,4546,2,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1248,7561,40850,4546,2,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1249,7561,40850,4546,2,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1250,7561,40850,4546,2,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1251,7561,40850,4546,2,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1252,7561,40850,4546,2,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL);
INSERT INTO `balance_libro` VALUES (1253,7561,40850,4546,2,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1254,7561,40850,4546,2,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1255,7561,40850,4546,2,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1256,7561,40850,4546,2,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1257,7561,40850,4546,2,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1258,7561,40850,4546,2,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1259,7561,40850,4546,2,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1260,7561,40850,4546,2,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1261,7561,40850,4546,2,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1262,7561,40850,4546,2,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1263,7561,40850,4546,2,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1264,7561,40850,4546,2,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2000.00,NULL,NULL,1,'2023-01-19 14:34:30','2023-01-19 14:34:30',NULL),(1265,7561,40850,4547,2,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',2000.00,NULL,NULL,1,'2023-01-19 14:34:56','2023-01-19 14:34:56',NULL),(1266,7561,40850,4547,2,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',2000.00,NULL,NULL,1,'2023-01-19 14:34:56','2023-01-19 14:34:56',NULL),(1267,7561,40850,4547,2,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',2000.00,NULL,NULL,1,'2023-01-19 14:34:56','2023-01-19 14:34:56',NULL),(1268,7561,40850,4547,2,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',2000.00,NULL,NULL,1,'2023-01-19 14:34:56','2023-01-19 14:34:56',NULL),(1269,7561,40850,4547,2,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',2000.00,NULL,NULL,1,'2023-01-19 14:34:56','2023-01-19 14:34:56',NULL),(1270,7561,40850,4547,2,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1271,7561,40850,4547,2,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1272,7561,40850,4547,2,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1273,7561,40850,4547,2,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL);
INSERT INTO `balance_libro` VALUES (1274,7561,40850,4547,2,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1275,7561,40850,4547,2,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1276,7561,40850,4547,2,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1277,7561,40850,4547,2,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1278,7561,40850,4547,2,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1279,7561,40850,4547,2,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1280,7561,40850,4547,2,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1281,7561,40850,4547,2,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1282,7561,40850,4547,2,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1283,7561,40850,4547,2,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1284,7561,40850,4547,2,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1285,7561,40850,4547,2,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1286,7561,40850,4547,2,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1287,7561,40850,4547,2,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1288,7561,40850,4547,2,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1289,7561,40850,4547,2,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1290,7561,40850,4547,2,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1291,7561,40850,4547,2,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1292,7561,40850,4547,2,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1293,7561,40850,4547,2,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1294,7561,40850,4547,2,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL);
INSERT INTO `balance_libro` VALUES (1295,7561,40850,4547,2,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',2000.00,NULL,NULL,1,'2023-01-19 14:34:57','2023-01-19 14:34:57',NULL),(1296,7561,40850,4547,2,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1297,7561,40850,4547,2,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1298,7561,40850,4547,2,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1299,7561,40850,4547,2,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1300,7561,40850,4547,2,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1301,7561,40850,4547,2,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1302,7561,40850,4547,2,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1303,7561,40850,4547,2,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1304,7561,40850,4547,2,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1305,7561,40850,4547,2,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1306,7561,40850,4547,2,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1307,7561,40850,4547,2,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1308,7561,40850,4547,2,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1309,7561,40850,4547,2,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1310,7561,40850,4547,2,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1311,7561,40850,4547,2,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1312,7561,40850,4547,2,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1313,7561,40850,4547,2,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1314,7561,40850,4547,2,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1315,7561,40850,4547,2,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL);
INSERT INTO `balance_libro` VALUES (1316,7561,40850,4547,2,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2000.00,NULL,NULL,1,'2023-01-19 14:34:58','2023-01-19 14:34:58',NULL),(1317,7561,40850,4544,2,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',1800.00,NULL,NULL,1,'2023-01-19 14:39:59','2023-01-19 14:39:59',NULL),(1318,7561,40850,4544,2,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',1800.00,NULL,NULL,1,'2023-01-19 14:39:59','2023-01-19 14:39:59',NULL),(1319,7561,40850,4544,2,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',1800.00,NULL,NULL,1,'2023-01-19 14:39:59','2023-01-19 14:39:59',NULL),(1320,7561,40850,4544,2,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',1800.00,NULL,NULL,1,'2023-01-19 14:39:59','2023-01-19 14:39:59',NULL),(1321,7561,40850,4544,2,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',1800.00,NULL,NULL,1,'2023-01-19 14:39:59','2023-01-19 14:39:59',NULL),(1322,7561,40850,4544,2,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',1800.00,NULL,NULL,1,'2023-01-19 14:39:59','2023-01-19 14:39:59',NULL),(1323,7561,40850,4544,2,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',1800.00,NULL,NULL,1,'2023-01-19 14:39:59','2023-01-19 14:39:59',NULL),(1324,7561,40850,4544,2,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',1800.00,NULL,NULL,1,'2023-01-19 14:39:59','2023-01-19 14:39:59',NULL),(1325,7561,40850,4544,2,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',1800.00,NULL,NULL,1,'2023-01-19 14:39:59','2023-01-19 14:39:59',NULL),(1326,7561,40850,4544,2,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',1800.00,NULL,NULL,1,'2023-01-19 14:39:59','2023-01-19 14:39:59',NULL),(1327,7561,40850,4544,2,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',1800.00,NULL,NULL,1,'2023-01-19 14:39:59','2023-01-19 14:39:59',NULL),(1328,7561,40850,4544,2,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',1800.00,NULL,NULL,1,'2023-01-19 14:39:59','2023-01-19 14:39:59',NULL),(1329,7561,40850,4544,2,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',1800.00,NULL,NULL,1,'2023-01-19 14:39:59','2023-01-19 14:39:59',NULL),(1330,7561,40850,4544,2,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',1800.00,NULL,NULL,1,'2023-01-19 14:39:59','2023-01-19 14:39:59',NULL),(1331,7561,40850,4544,2,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',1800.00,NULL,NULL,1,'2023-01-19 14:39:59','2023-01-19 14:39:59',NULL),(1332,7561,40850,4544,2,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',1800.00,NULL,NULL,1,'2023-01-19 14:40:00','2023-01-19 14:40:00',NULL),(1333,7561,40850,4544,2,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',1800.00,NULL,NULL,1,'2023-01-19 14:40:00','2023-01-19 14:40:00',NULL),(1334,7561,40850,4544,2,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',1800.00,NULL,NULL,1,'2023-01-19 14:40:00','2023-01-19 14:40:00',NULL),(1335,7561,40850,4544,2,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',1800.00,NULL,NULL,1,'2023-01-19 14:40:00','2023-01-19 14:40:00',NULL),(1336,7561,40850,4544,2,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',1800.00,NULL,NULL,1,'2023-01-19 14:40:00','2023-01-19 14:40:00',NULL);
INSERT INTO `balance_libro` VALUES (1337,7561,40850,4544,2,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',1800.00,NULL,NULL,1,'2023-01-19 14:40:00','2023-01-19 14:40:00',NULL),(1338,7561,40850,4544,2,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',1800.00,NULL,NULL,1,'2023-01-19 14:40:00','2023-01-19 14:40:00',NULL),(1339,7561,40850,4544,2,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',1800.00,NULL,NULL,1,'2023-01-19 14:40:00','2023-01-19 14:40:00',NULL),(1340,7561,40850,4544,2,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',1800.00,NULL,NULL,1,'2023-01-19 14:40:00','2023-01-19 14:40:00',NULL),(1341,7561,40850,4544,2,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1800.00,NULL,NULL,1,'2023-01-19 14:40:00','2023-01-19 14:40:00',NULL),(1342,7561,40850,4544,2,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1800.00,NULL,NULL,1,'2023-01-19 14:40:00','2023-01-19 14:40:00',NULL),(1343,7561,40850,4544,2,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',1800.00,NULL,NULL,1,'2023-01-19 14:40:00','2023-01-19 14:40:00',NULL),(1344,7561,40850,4544,2,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',1800.00,NULL,NULL,1,'2023-01-19 14:40:00','2023-01-19 14:40:00',NULL),(1345,7561,40850,4544,2,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',1800.00,NULL,NULL,1,'2023-01-19 14:40:00','2023-01-19 14:40:00',NULL),(1346,7561,40850,4544,2,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',1800.00,NULL,NULL,1,'2023-01-19 14:40:01','2023-01-19 14:40:01',NULL),(1347,7561,40850,4544,2,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',1800.00,NULL,NULL,1,'2023-01-19 14:40:01','2023-01-19 14:40:01',NULL),(1348,7561,40850,4544,2,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',1800.00,NULL,NULL,1,'2023-01-19 14:40:01','2023-01-19 14:40:01',NULL),(1349,7561,40850,4544,2,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',1800.00,NULL,NULL,1,'2023-01-19 14:40:01','2023-01-19 14:40:01',NULL),(1350,7561,40850,4544,2,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',1800.00,NULL,NULL,1,'2023-01-19 14:40:01','2023-01-19 14:40:01',NULL),(1351,7561,40850,4544,2,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',1800.00,NULL,NULL,1,'2023-01-19 14:40:01','2023-01-19 14:40:01',NULL),(1352,7561,40850,4544,2,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',1800.00,NULL,NULL,1,'2023-01-19 14:40:01','2023-01-19 14:40:01',NULL),(1353,7561,40850,4544,2,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',1800.00,NULL,NULL,1,'2023-01-19 14:40:01','2023-01-19 14:40:01',NULL),(1354,7561,40850,4544,2,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',1800.00,NULL,NULL,1,'2023-01-19 14:40:01','2023-01-19 14:40:01',NULL),(1355,7561,40850,4544,2,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',1800.00,NULL,NULL,1,'2023-01-19 14:40:02','2023-01-19 14:40:02',NULL),(1356,7561,40850,4544,2,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',1800.00,NULL,NULL,1,'2023-01-19 14:40:02','2023-01-19 14:40:02',NULL),(1357,7561,40850,4544,2,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',1800.00,NULL,NULL,1,'2023-01-19 14:40:02','2023-01-19 14:40:02',NULL);
INSERT INTO `balance_libro` VALUES (1358,7561,40850,4544,2,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',1800.00,NULL,NULL,1,'2023-01-19 14:40:02','2023-01-19 14:40:02',NULL),(1359,7561,40850,4544,2,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1800.00,NULL,NULL,1,'2023-01-19 14:40:02','2023-01-19 14:40:02',NULL),(1360,7561,40850,4544,2,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1800.00,NULL,NULL,1,'2023-01-19 14:40:02','2023-01-19 14:40:02',NULL),(1363,7561,40851,6069,2,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',1500.00,NULL,NULL,1,'2023-01-19 15:23:23','2023-01-19 15:23:23',NULL),(1364,7561,40851,6069,2,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',1500.00,NULL,NULL,1,'2023-01-19 15:23:23','2023-01-19 15:23:23',NULL),(1365,7561,40851,6069,2,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',1500.00,NULL,NULL,1,'2023-01-19 15:23:23','2023-01-19 15:23:23',NULL),(1366,7561,40851,6069,2,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',1500.00,NULL,NULL,1,'2023-01-19 15:23:23','2023-01-19 15:23:23',NULL),(1367,7561,40851,6069,2,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',1500.00,NULL,NULL,1,'2023-01-19 15:23:23','2023-01-19 15:23:23',NULL),(1368,7561,40851,6069,2,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',1500.00,NULL,NULL,1,'2023-01-19 15:23:23','2023-01-19 15:23:23',NULL),(1369,7561,40851,6069,2,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',1500.00,NULL,NULL,1,'2023-01-19 15:23:23','2023-01-19 15:23:23',NULL),(1370,7561,40851,6069,2,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',1500.00,NULL,NULL,1,'2023-01-19 15:23:23','2023-01-19 15:23:23',NULL),(1371,7561,40851,6069,2,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',1500.00,NULL,NULL,1,'2023-01-19 15:23:23','2023-01-19 15:23:23',NULL),(1372,7561,40851,6069,2,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',1500.00,NULL,NULL,1,'2023-01-19 15:23:24','2023-01-19 15:23:24',NULL),(1373,7561,40851,6069,2,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',1500.00,NULL,NULL,1,'2023-01-19 15:23:24','2023-01-19 15:23:24',NULL),(1374,7561,40851,6069,2,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',1500.00,NULL,NULL,1,'2023-01-19 15:23:24','2023-01-19 15:23:24',NULL),(1375,7561,40851,6069,2,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',1500.00,NULL,NULL,1,'2023-01-19 15:23:24','2023-01-19 15:23:24',NULL),(1376,7561,40851,6069,2,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',1500.00,NULL,NULL,1,'2023-01-19 15:23:24','2023-01-19 15:23:24',NULL),(1377,7561,40851,6069,2,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',1500.00,NULL,NULL,1,'2023-01-19 15:23:24','2023-01-19 15:23:24',NULL),(1378,7561,40851,6069,2,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',1500.00,NULL,NULL,1,'2023-01-19 15:23:24','2023-01-19 15:23:24',NULL),(1379,7561,40851,6069,2,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1500.00,NULL,NULL,1,'2023-01-19 15:23:24','2023-01-19 15:23:24',NULL),(1380,7561,40851,6069,2,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1500.00,NULL,NULL,1,'2023-01-19 15:23:24','2023-01-19 15:23:24',NULL);
INSERT INTO `balance_libro` VALUES (1381,7561,40851,6069,2,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1500.00,NULL,NULL,1,'2023-01-19 15:23:25','2023-01-19 15:23:25',NULL),(1382,7561,40851,6069,2,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1500.00,NULL,NULL,1,'2023-01-19 15:23:25','2023-01-19 15:23:25',NULL),(1383,7561,40851,6069,2,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1500.00,NULL,NULL,1,'2023-01-19 15:23:25','2023-01-19 15:23:25',NULL),(1384,7561,40851,6070,2,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',1500.00,NULL,NULL,1,'2023-01-19 15:25:42','2023-01-19 15:25:42',NULL),(1385,7561,40851,6070,2,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',1500.00,NULL,NULL,1,'2023-01-19 15:25:42','2023-01-19 15:25:42',NULL),(1386,7561,40851,6070,2,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',1500.00,NULL,NULL,1,'2023-01-19 15:25:42','2023-01-19 15:25:42',NULL),(1387,7561,40851,6070,2,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',1500.00,NULL,NULL,1,'2023-01-19 15:25:42','2023-01-19 15:25:42',NULL),(1388,7561,40851,6070,2,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',1500.00,NULL,NULL,1,'2023-01-19 15:25:42','2023-01-19 15:25:42',NULL),(1389,7561,40851,6070,2,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',1500.00,NULL,NULL,1,'2023-01-19 15:25:42','2023-01-19 15:25:42',NULL),(1390,7561,40851,6070,2,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',1500.00,NULL,NULL,1,'2023-01-19 15:25:42','2023-01-19 15:25:42',NULL),(1391,7561,40851,6070,2,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',1500.00,NULL,NULL,1,'2023-01-19 15:25:42','2023-01-19 15:25:42',NULL),(1392,7561,40851,6070,2,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',1500.00,NULL,NULL,1,'2023-01-19 15:25:42','2023-01-19 15:25:42',NULL),(1393,7561,40851,6070,2,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',1500.00,NULL,NULL,1,'2023-01-19 15:25:43','2023-01-19 15:25:43',NULL),(1394,7561,40851,6070,2,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',1500.00,NULL,NULL,1,'2023-01-19 15:25:43','2023-01-19 15:25:43',NULL),(1395,7561,40851,6070,2,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',1500.00,NULL,NULL,1,'2023-01-19 15:25:43','2023-01-19 15:25:43',NULL),(1396,7561,40851,6070,2,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',1500.00,NULL,NULL,1,'2023-01-19 15:25:43','2023-01-19 15:25:43',NULL),(1397,7561,40851,6070,2,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',1500.00,NULL,NULL,1,'2023-01-19 15:25:43','2023-01-19 15:25:43',NULL),(1398,7561,40851,6070,2,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',1500.00,NULL,NULL,1,'2023-01-19 15:25:43','2023-01-19 15:25:43',NULL),(1399,7561,40851,6070,2,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',1500.00,NULL,NULL,1,'2023-01-19 15:25:43','2023-01-19 15:25:43',NULL),(1400,7561,40851,6070,2,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',1500.00,NULL,NULL,1,'2023-01-19 15:25:43','2023-01-19 15:25:43',NULL),(1401,7561,40851,6070,2,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',1500.00,NULL,NULL,1,'2023-01-19 15:25:43','2023-01-19 15:25:43',NULL);
INSERT INTO `balance_libro` VALUES (1402,7561,40851,6070,2,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',1500.00,NULL,NULL,1,'2023-01-19 15:25:43','2023-01-19 15:25:43',NULL),(1403,7561,40851,6070,2,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-26','2022-02-26',1500.00,NULL,NULL,1,'2023-01-19 15:25:43','2023-01-19 15:25:43',NULL),(1404,7561,40851,6070,2,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-26','2022-02-26',1500.00,NULL,NULL,1,'2023-01-19 15:25:43','2023-01-19 15:25:43',NULL),(1405,7561,40851,6071,2,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1600.00,NULL,NULL,1,'2023-01-19 15:25:59','2023-01-19 15:25:59',NULL),(1406,7561,40851,6071,2,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1600.00,NULL,NULL,1,'2023-01-19 15:25:59','2023-01-19 15:25:59',NULL),(1407,7561,40851,6071,2,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1600.00,NULL,NULL,1,'2023-01-19 15:25:59','2023-01-19 15:25:59',NULL),(1408,7561,40851,6071,2,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1600.00,NULL,NULL,1,'2023-01-19 15:25:59','2023-01-19 15:25:59',NULL),(1409,7561,40851,6071,2,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1600.00,NULL,NULL,1,'2023-01-19 15:25:59','2023-01-19 15:25:59',NULL),(1410,7561,40851,6071,2,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1600.00,NULL,NULL,1,'2023-01-19 15:25:59','2023-01-19 15:25:59',NULL),(1411,7561,40851,6071,2,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1600.00,NULL,NULL,1,'2023-01-19 15:25:59','2023-01-19 15:25:59',NULL),(1412,7561,40851,6071,2,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',1600.00,NULL,NULL,1,'2023-01-19 15:25:59','2023-01-19 15:25:59',NULL),(1413,7561,40851,6071,2,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',1600.00,NULL,NULL,1,'2023-01-19 15:25:59','2023-01-19 15:25:59',NULL),(1414,7561,40851,6071,2,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',1600.00,NULL,NULL,1,'2023-01-19 15:25:59','2023-01-19 15:25:59',NULL),(1415,7561,40851,6071,2,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',1600.00,NULL,NULL,1,'2023-01-19 15:25:59','2023-01-19 15:25:59',NULL),(1416,7561,40851,6071,2,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1600.00,NULL,NULL,1,'2023-01-19 15:25:59','2023-01-19 15:25:59',NULL),(1417,7561,40851,6071,2,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1600.00,NULL,NULL,1,'2023-01-19 15:25:59','2023-01-19 15:25:59',NULL),(1418,7561,40851,6071,2,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1600.00,NULL,NULL,1,'2023-01-19 15:25:59','2023-01-19 15:25:59',NULL),(1419,7561,40851,6071,2,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',1600.00,NULL,NULL,1,'2023-01-19 15:25:59','2023-01-19 15:25:59',NULL),(1420,7561,40851,6071,2,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',1600.00,NULL,NULL,1,'2023-01-19 15:25:59','2023-01-19 15:25:59',NULL),(1421,7561,40851,6071,2,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1600.00,NULL,NULL,1,'2023-01-19 15:25:59','2023-01-19 15:25:59',NULL),(1422,7561,40851,6071,2,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1600.00,NULL,NULL,1,'2023-01-19 15:25:59','2023-01-19 15:25:59',NULL);
INSERT INTO `balance_libro` VALUES (1423,7561,40851,6071,2,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1424,7561,40851,6071,2,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1425,7561,40851,6071,2,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1426,7561,40851,6071,2,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1427,7561,40851,6071,2,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1428,7561,40851,6071,2,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1429,7561,40851,6071,2,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1430,7561,40851,6071,2,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1431,7561,40851,6071,2,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1432,7561,40851,6071,2,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1433,7561,40851,6071,2,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1434,7561,40851,6071,2,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1435,7561,40851,6071,2,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1436,7561,40851,6071,2,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1437,7561,40851,6071,2,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1438,7561,40851,6071,2,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1439,7561,40851,6071,2,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1440,7561,40851,6071,2,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1441,7561,40851,6071,2,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1442,7561,40851,6071,2,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1600.00,NULL,NULL,1,'2023-01-19 15:26:00','2023-01-19 15:26:00',NULL),(1443,7561,40851,6071,2,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',1600.00,NULL,NULL,1,'2023-01-19 15:26:01','2023-01-19 15:26:01',NULL);
INSERT INTO `balance_libro` VALUES (1444,7561,40851,6071,2,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',1600.00,NULL,NULL,1,'2023-01-19 15:26:01','2023-01-19 15:26:01',NULL),(1445,7561,40851,6071,2,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',1600.00,NULL,NULL,1,'2023-01-19 15:26:01','2023-01-19 15:26:01',NULL),(1446,7561,40851,6071,2,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',1600.00,NULL,NULL,1,'2023-01-19 15:26:01','2023-01-19 15:26:01',NULL),(1447,7561,40851,6071,2,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',1600.00,NULL,NULL,1,'2023-01-19 15:26:01','2023-01-19 15:26:01',NULL),(1448,7561,40851,6071,2,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',1600.00,NULL,NULL,1,'2023-01-19 15:26:01','2023-01-19 15:26:01',NULL),(1449,7561,40851,6071,2,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',1600.00,NULL,NULL,1,'2023-01-19 15:26:01','2023-01-19 15:26:01',NULL),(1450,7561,40851,6071,2,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',1600.00,NULL,NULL,1,'2023-01-19 15:26:01','2023-01-19 15:26:01',NULL),(1451,7561,40851,6071,2,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',1600.00,NULL,NULL,1,'2023-01-19 15:26:01','2023-01-19 15:26:01',NULL),(1452,7561,40851,6071,2,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',1600.00,NULL,NULL,1,'2023-01-19 15:26:01','2023-01-19 15:26:01',NULL),(1453,7561,40851,6071,2,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',1600.00,NULL,NULL,1,'2023-01-19 15:26:01','2023-01-19 15:26:01',NULL),(1454,7561,40851,6071,2,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',1600.00,NULL,NULL,1,'2023-01-19 15:26:01','2023-01-19 15:26:01',NULL),(1455,7561,40851,6071,2,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',1600.00,NULL,NULL,1,'2023-01-19 15:26:01','2023-01-19 15:26:01',NULL),(1456,7561,40851,6071,2,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',1600.00,NULL,NULL,1,'2023-01-19 15:26:01','2023-01-19 15:26:01',NULL),(1457,7561,40851,6071,2,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',1600.00,NULL,NULL,1,'2023-01-19 15:26:02','2023-01-19 15:26:02',NULL),(1458,7561,40851,6071,2,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',1600.00,NULL,NULL,1,'2023-01-19 15:26:02','2023-01-19 15:26:02',NULL),(1459,7561,40851,6071,2,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',1600.00,NULL,NULL,1,'2023-01-19 15:26:02','2023-01-19 15:26:02',NULL),(1460,7561,40851,6071,2,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',1600.00,NULL,NULL,1,'2023-01-19 15:26:02','2023-01-19 15:26:02',NULL),(1461,7561,40851,6071,2,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',1600.00,NULL,NULL,1,'2023-01-19 15:26:02','2023-01-19 15:26:02',NULL),(1462,7561,40851,6071,2,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1600.00,NULL,NULL,1,'2023-01-19 15:26:02','2023-01-19 15:26:02',NULL),(1463,7561,40851,6071,2,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1600.00,NULL,NULL,1,'2023-01-19 15:26:02','2023-01-19 15:26:02',NULL),(1464,7561,40851,6071,2,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1600.00,NULL,NULL,1,'2023-01-19 15:26:02','2023-01-19 15:26:02',NULL);
INSERT INTO `balance_libro` VALUES (1465,7561,40851,6072,2,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',1700.00,NULL,NULL,1,'2023-01-19 15:26:19','2023-01-19 15:26:19',NULL),(1466,7561,40851,6072,2,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',1700.00,NULL,NULL,1,'2023-01-19 15:26:19','2023-01-19 15:26:19',NULL),(1467,7561,40851,6072,2,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1468,7561,40851,6072,2,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1469,7561,40851,6072,2,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1470,7561,40851,6072,2,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1471,7561,40851,6072,2,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1472,7561,40851,6072,2,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1473,7561,40851,6072,2,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1474,7561,40851,6072,2,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1475,7561,40851,6072,2,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1476,7561,40851,6072,2,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1477,7561,40851,6072,2,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1478,7561,40851,6072,2,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1479,7561,40851,6072,2,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1480,7561,40851,6072,2,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1481,7561,40851,6072,2,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1482,7561,40851,6072,2,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1483,7561,40851,6072,2,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1484,7561,40851,6072,2,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1485,7561,40851,6072,2,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL);
INSERT INTO `balance_libro` VALUES (1486,7561,40851,6072,2,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1487,7561,40851,6072,2,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1488,7561,40851,6072,2,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1489,7561,40851,6072,2,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1490,7561,40851,6072,2,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1491,7561,40851,6072,2,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1492,7561,40851,6072,2,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1493,7561,40851,6072,2,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1494,7561,40851,6072,2,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1495,7561,40851,6072,2,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1496,7561,40851,6072,2,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',1700.00,NULL,NULL,1,'2023-01-19 15:26:20','2023-01-19 15:26:20',NULL),(1497,7561,40851,6072,2,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',1700.00,NULL,NULL,1,'2023-01-19 15:26:21','2023-01-19 15:26:21',NULL),(1498,7561,40851,6072,2,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',1700.00,NULL,NULL,1,'2023-01-19 15:26:21','2023-01-19 15:26:21',NULL),(1499,7561,40851,6072,2,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',1700.00,NULL,NULL,1,'2023-01-19 15:26:21','2023-01-19 15:26:21',NULL),(1500,7561,40851,6072,2,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',1700.00,NULL,NULL,1,'2023-01-19 15:26:21','2023-01-19 15:26:21',NULL),(1501,7561,40851,6072,2,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1700.00,NULL,NULL,1,'2023-01-19 15:26:21','2023-01-19 15:26:21',NULL),(1502,7561,40851,6072,2,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1700.00,NULL,NULL,1,'2023-01-19 15:26:21','2023-01-19 15:26:21',NULL),(1503,7561,40851,6073,2,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',1700.00,NULL,NULL,1,'2023-01-19 15:26:39','2023-01-19 15:26:39',NULL),(1504,7561,40851,6073,2,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',1700.00,NULL,NULL,1,'2023-01-19 15:26:39','2023-01-19 15:26:39',NULL),(1505,7561,40851,6073,2,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',1700.00,NULL,NULL,1,'2023-01-19 15:26:39','2023-01-19 15:26:39',NULL),(1506,7561,40851,6073,2,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',1700.00,NULL,NULL,1,'2023-01-19 15:26:39','2023-01-19 15:26:39',NULL);
INSERT INTO `balance_libro` VALUES (1507,7561,40851,6073,2,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',1700.00,NULL,NULL,1,'2023-01-19 15:26:39','2023-01-19 15:26:39',NULL),(1508,7561,40851,6073,2,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',1700.00,NULL,NULL,1,'2023-01-19 15:26:39','2023-01-19 15:26:39',NULL),(1509,7561,40851,6073,2,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',1700.00,NULL,NULL,1,'2023-01-19 15:26:39','2023-01-19 15:26:39',NULL),(1510,7561,40851,6073,2,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',1700.00,NULL,NULL,1,'2023-01-19 15:26:39','2023-01-19 15:26:39',NULL),(1511,7561,40851,6073,2,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',1700.00,NULL,NULL,1,'2023-01-19 15:26:39','2023-01-19 15:26:39',NULL),(1512,7561,40851,6073,2,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL),(1513,7561,40851,6073,2,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL),(1514,7561,40851,6073,2,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL),(1515,7561,40851,6073,2,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL),(1516,7561,40851,6073,2,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL),(1517,7561,40851,6073,2,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL),(1518,7561,40851,6073,2,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL),(1519,7561,40851,6073,2,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL),(1520,7561,40851,6073,2,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL),(1521,7561,40851,6073,2,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL),(1522,7561,40851,6073,2,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL),(1523,7561,40851,6073,2,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL),(1524,7561,40851,6073,2,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL),(1525,7561,40851,6073,2,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL),(1526,7561,40851,6073,2,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL),(1527,7561,40851,6073,2,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL);
INSERT INTO `balance_libro` VALUES (1528,7561,40851,6073,2,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL),(1529,7561,40851,6073,2,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL),(1530,7561,40851,6073,2,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL),(1531,7561,40851,6073,2,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',1700.00,NULL,NULL,1,'2023-01-19 15:26:40','2023-01-19 15:26:40',NULL),(1532,7561,40851,6073,2,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1533,7561,40851,6073,2,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1534,7561,40851,6073,2,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1535,7561,40851,6073,2,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1536,7561,40851,6073,2,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1537,7561,40851,6073,2,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1538,7561,40851,6073,2,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1539,7561,40851,6073,2,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1540,7561,40851,6073,2,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1541,7561,40851,6073,2,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1542,7561,40851,6073,2,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1543,7561,40851,6073,2,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1544,7561,40851,6073,2,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1545,7561,40851,6073,2,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1546,7561,40851,6073,2,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1547,7561,40851,6073,2,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1548,7561,40851,6073,2,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL);
INSERT INTO `balance_libro` VALUES (1549,7561,40851,6073,2,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1550,7561,40851,6073,2,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1551,7561,40851,6073,2,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1552,7561,40851,6073,2,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1553,7561,40851,6073,2,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',1700.00,NULL,NULL,1,'2023-01-19 15:26:41','2023-01-19 15:26:41',NULL),(1554,7561,40851,6073,2,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',1700.00,NULL,NULL,1,'2023-01-19 15:26:42','2023-01-19 15:26:42',NULL),(1555,7561,40851,6073,2,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',1700.00,NULL,NULL,1,'2023-01-19 15:26:42','2023-01-19 15:26:42',NULL),(1556,7561,40851,6073,2,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',1700.00,NULL,NULL,1,'2023-01-19 15:26:42','2023-01-19 15:26:42',NULL),(1557,7561,40851,6073,2,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',1700.00,NULL,NULL,1,'2023-01-19 15:26:42','2023-01-19 15:26:42',NULL),(1558,7561,40851,6073,2,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',1700.00,NULL,NULL,1,'2023-01-19 15:26:42','2023-01-19 15:26:42',NULL),(1559,7561,40851,6073,2,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',1700.00,NULL,NULL,1,'2023-01-19 15:26:42','2023-01-19 15:26:42',NULL),(1560,7561,40851,6073,2,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',1700.00,NULL,NULL,1,'2023-01-19 15:26:42','2023-01-19 15:26:42',NULL),(1561,7561,40851,6073,2,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1700.00,NULL,NULL,1,'2023-01-19 15:26:42','2023-01-19 15:26:42',NULL),(1562,7561,40851,6073,2,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1700.00,NULL,NULL,1,'2023-01-19 15:26:42','2023-01-19 15:26:42',NULL),(1563,7561,40851,6073,2,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1700.00,NULL,NULL,1,'2023-01-19 15:26:42','2023-01-19 15:26:42',NULL),(1564,7561,40851,6074,2,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1565,7561,40851,6074,2,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1566,7561,40851,6074,2,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1567,7561,40851,6074,2,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1568,7561,40851,6074,2,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1569,7561,40851,6074,2,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL);
INSERT INTO `balance_libro` VALUES (1570,7561,40851,6074,2,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1571,7561,40851,6074,2,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1572,7561,40851,6074,2,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1573,7561,40851,6074,2,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1574,7561,40851,6074,2,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1575,7561,40851,6074,2,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1576,7561,40851,6074,2,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1577,7561,40851,6074,2,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1578,7561,40851,6074,2,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1579,7561,40851,6074,2,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1580,7561,40851,6074,2,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1581,7561,40851,6074,2,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1582,7561,40851,6074,2,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1583,7561,40851,6074,2,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1584,7561,40851,6074,2,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1585,7561,40851,6074,2,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1586,7561,40851,6074,2,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',1800.00,NULL,NULL,1,'2023-01-19 15:27:01','2023-01-19 15:27:01',NULL),(1587,7561,40851,6074,2,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1588,7561,40851,6074,2,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1589,7561,40851,6074,2,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1590,7561,40851,6074,2,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL);
INSERT INTO `balance_libro` VALUES (1591,7561,40851,6074,2,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1592,7561,40851,6074,2,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1593,7561,40851,6074,2,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1594,7561,40851,6074,2,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1595,7561,40851,6074,2,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1596,7561,40851,6074,2,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1597,7561,40851,6074,2,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1598,7561,40851,6074,2,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1599,7561,40851,6074,2,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1600,7561,40851,6074,2,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1601,7561,40851,6074,2,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1602,7561,40851,6074,2,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1603,7561,40851,6074,2,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1604,7561,40851,6074,2,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1605,7561,40851,6074,2,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1606,7561,40851,6074,2,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1607,7561,40851,6074,2,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',1800.00,NULL,NULL,1,'2023-01-19 15:27:02','2023-01-19 15:27:02',NULL),(1608,7561,40851,6074,2,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',1800.00,NULL,NULL,1,'2023-01-19 15:27:03','2023-01-19 15:27:03',NULL),(1609,7561,40851,6074,2,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',1800.00,NULL,NULL,1,'2023-01-19 15:27:03','2023-01-19 15:27:03',NULL),(1610,7561,40851,6074,2,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',1800.00,NULL,NULL,1,'2023-01-19 15:27:03','2023-01-19 15:27:03',NULL),(1611,7561,40851,6074,2,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',1800.00,NULL,NULL,1,'2023-01-19 15:27:03','2023-01-19 15:27:03',NULL);
INSERT INTO `balance_libro` VALUES (1612,7561,40851,6074,2,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',1800.00,NULL,NULL,1,'2023-01-19 15:27:03','2023-01-19 15:27:03',NULL),(1613,7561,40851,6074,2,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',1800.00,NULL,NULL,1,'2023-01-19 15:27:03','2023-01-19 15:27:03',NULL),(1614,7561,40851,6074,2,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',1800.00,NULL,NULL,1,'2023-01-19 15:27:03','2023-01-19 15:27:03',NULL),(1615,7561,40851,6074,2,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',1800.00,NULL,NULL,1,'2023-01-19 15:27:03','2023-01-19 15:27:03',NULL),(1616,7561,40851,6074,2,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',1800.00,NULL,NULL,1,'2023-01-19 15:27:03','2023-01-19 15:27:03',NULL),(1617,7561,40851,6074,2,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',1800.00,NULL,NULL,1,'2023-01-19 15:27:03','2023-01-19 15:27:03',NULL),(1618,7561,40851,6074,2,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',1800.00,NULL,NULL,1,'2023-01-19 15:27:03','2023-01-19 15:27:03',NULL),(1619,7561,40851,6074,2,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',1800.00,NULL,NULL,1,'2023-01-19 15:27:03','2023-01-19 15:27:03',NULL),(1620,7561,40851,6074,2,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',1800.00,NULL,NULL,1,'2023-01-19 15:27:03','2023-01-19 15:27:03',NULL),(1621,7561,40851,6074,2,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',1800.00,NULL,NULL,1,'2023-01-19 15:27:03','2023-01-19 15:27:03',NULL),(1622,7561,40851,6074,2,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',1800.00,NULL,NULL,1,'2023-01-19 15:27:03','2023-01-19 15:27:03',NULL),(1623,7561,40851,6074,2,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',1800.00,NULL,NULL,1,'2023-01-19 15:27:03','2023-01-19 15:27:03',NULL),(1624,7561,40851,6075,2,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',1800.00,NULL,NULL,1,'2023-01-19 15:27:23','2023-01-19 15:27:23',NULL),(1625,7561,40851,6075,2,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',1800.00,NULL,NULL,1,'2023-01-19 15:27:23','2023-01-19 15:27:23',NULL),(1626,7561,40851,6075,2,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',1800.00,NULL,NULL,1,'2023-01-19 15:27:23','2023-01-19 15:27:23',NULL),(1627,7561,40851,6075,2,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1628,7561,40851,6075,2,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1629,7561,40851,6075,2,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1630,7561,40851,6075,2,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1631,7561,40851,6075,2,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1632,7561,40851,6075,2,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL);
INSERT INTO `balance_libro` VALUES (1633,7561,40851,6075,2,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1634,7561,40851,6075,2,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1635,7561,40851,6075,2,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1636,7561,40851,6075,2,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1637,7561,40851,6075,2,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1638,7561,40851,6075,2,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1639,7561,40851,6075,2,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1640,7561,40851,6075,2,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1641,7561,40851,6075,2,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1642,7561,40851,6075,2,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1643,7561,40851,6075,2,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1644,7561,40851,6075,2,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1645,7561,40851,6075,2,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1646,7561,40851,6075,2,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1647,7561,40851,6075,2,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1648,7561,40851,6075,2,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1649,7561,40851,6075,2,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1650,7561,40851,6075,2,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1651,7561,40851,6075,2,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1652,7561,40851,6075,2,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL),(1653,7561,40851,6075,2,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1800.00,NULL,NULL,1,'2023-01-19 15:27:24','2023-01-19 15:27:24',NULL);
INSERT INTO `balance_libro` VALUES (1654,7561,40851,6075,2,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1655,7561,40851,6075,2,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1656,7561,40851,6075,2,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1657,7561,40851,6075,2,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1658,7561,40851,6075,2,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1659,7561,40851,6075,2,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1660,7561,40851,6075,2,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1661,7561,40851,6075,2,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1662,7561,40851,6075,2,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1663,7561,40851,6075,2,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1664,7561,40851,6075,2,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1665,7561,40851,6075,2,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1666,7561,40851,6075,2,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1667,7561,40851,6075,2,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1668,7561,40851,6075,2,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1669,7561,40851,6075,2,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1670,7561,40851,6075,2,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1671,7561,40851,6075,2,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1672,7561,40851,6075,2,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1673,7561,40851,6075,2,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL),(1674,7561,40851,6075,2,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1800.00,NULL,NULL,1,'2023-01-19 15:27:25','2023-01-19 15:27:25',NULL);
INSERT INTO `balance_libro` VALUES (1675,7561,40851,6075,2,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1800.00,NULL,NULL,1,'2023-01-19 15:27:26','2023-01-19 15:27:26',NULL),(1676,7561,40851,6075,2,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1800.00,NULL,NULL,1,'2023-01-19 15:27:26','2023-01-19 15:27:26',NULL),(1677,7561,40851,6075,2,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1800.00,NULL,NULL,1,'2023-01-19 15:27:26','2023-01-19 15:27:26',NULL),(1678,7561,40851,6077,2,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1679,7561,40851,6077,2,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1680,7561,40851,6077,2,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1681,7561,40851,6077,2,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1682,7561,40851,6077,2,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1683,7561,40851,6077,2,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1684,7561,40851,6077,2,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1685,7561,40851,6077,2,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1686,7561,40851,6077,2,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1687,7561,40851,6077,2,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1688,7561,40851,6077,2,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1689,7561,40851,6077,2,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1690,7561,40851,6077,2,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1691,7561,40851,6077,2,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1692,7561,40851,6077,2,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1693,7561,40851,6077,2,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1694,7561,40851,6077,2,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1695,7561,40851,6077,2,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL);
INSERT INTO `balance_libro` VALUES (1696,7561,40851,6077,2,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1697,7561,40851,6077,2,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1698,7561,40851,6077,2,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1699,7561,40851,6077,2,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1700,7561,40851,6077,2,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1701,7561,40851,6077,2,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1702,7561,40851,6077,2,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1703,7561,40851,6077,2,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1704,7561,40851,6077,2,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',2000.00,NULL,NULL,1,'2023-01-19 15:28:25','2023-01-19 15:28:25',NULL),(1705,7561,40851,6077,2,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1706,7561,40851,6077,2,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1707,7561,40851,6077,2,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1708,7561,40851,6077,2,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1709,7561,40851,6077,2,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1710,7561,40851,6077,2,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1711,7561,40851,6077,2,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1712,7561,40851,6077,2,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1713,7561,40851,6077,2,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1714,7561,40851,6077,2,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1715,7561,40851,6077,2,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1716,7561,40851,6077,2,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL);
INSERT INTO `balance_libro` VALUES (1717,7561,40851,6077,2,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1718,7561,40851,6077,2,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1719,7561,40851,6077,2,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1720,7561,40851,6077,2,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1721,7561,40851,6077,2,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1722,7561,40851,6077,2,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1723,7561,40851,6077,2,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1724,7561,40851,6077,2,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1725,7561,40851,6077,2,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1726,7561,40851,6077,2,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1727,7561,40851,6077,2,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1728,7561,40851,6077,2,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1729,7561,40851,6077,2,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1730,7561,40851,6077,2,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1731,7561,40851,6077,2,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1732,7561,40851,6077,2,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2000.00,NULL,NULL,1,'2023-01-19 15:28:26','2023-01-19 15:28:26',NULL),(1733,7561,40851,6077,2,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2000.00,NULL,NULL,1,'2023-01-19 15:28:27','2023-01-19 15:28:27',NULL),(1734,7561,40851,6077,2,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2000.00,NULL,NULL,1,'2023-01-19 15:28:27','2023-01-19 15:28:27',NULL),(1735,7561,40851,6078,2,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1736,7561,40851,6078,2,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1737,7561,40851,6078,2,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL);
INSERT INTO `balance_libro` VALUES (1738,7561,40851,6078,2,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1739,7561,40851,6078,2,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1740,7561,40851,6078,2,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1741,7561,40851,6078,2,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1742,7561,40851,6078,2,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1743,7561,40851,6078,2,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1744,7561,40851,6078,2,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1745,7561,40851,6078,2,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1746,7561,40851,6078,2,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1747,7561,40851,6078,2,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1748,7561,40851,6078,2,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1749,7561,40851,6078,2,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1750,7561,40851,6078,2,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1751,7561,40851,6078,2,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1752,7561,40851,6078,2,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1753,7561,40851,6078,2,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1754,7561,40851,6078,2,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1755,7561,40851,6078,2,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1756,7561,40851,6078,2,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1757,7561,40851,6078,2,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1758,7561,40851,6078,2,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL);
INSERT INTO `balance_libro` VALUES (1759,7561,40851,6078,2,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1760,7561,40851,6078,2,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1761,7561,40851,6078,2,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2500.00,NULL,NULL,1,'2023-01-19 15:28:45','2023-01-19 15:28:45',NULL),(1762,7561,40851,6078,2,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1763,7561,40851,6078,2,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1764,7561,40851,6078,2,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1765,7561,40851,6078,2,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1766,7561,40851,6078,2,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1767,7561,40851,6078,2,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1768,7561,40851,6078,2,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1769,7561,40851,6078,2,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1770,7561,40851,6078,2,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1771,7561,40851,6078,2,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1772,7561,40851,6078,2,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1773,7561,40851,6078,2,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1774,7561,40851,6078,2,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1775,7561,40851,6078,2,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1776,7561,40851,6078,2,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1777,7561,40851,6078,2,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1778,7561,40851,6078,2,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1779,7561,40851,6078,2,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL);
INSERT INTO `balance_libro` VALUES (1780,7561,40851,6078,2,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1781,7561,40851,6078,2,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1782,7561,40851,6078,2,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1783,7561,40851,6078,2,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1784,7561,40851,6078,2,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1785,7561,40851,6078,2,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1786,7561,40851,6078,2,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2500.00,NULL,NULL,1,'2023-01-19 15:28:46','2023-01-19 15:28:46',NULL),(1787,7561,40851,6079,2,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2500.00,NULL,NULL,1,'2023-01-19 15:29:02','2023-01-19 15:29:02',NULL),(1788,7561,40851,6079,2,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1789,7561,40851,6079,2,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1790,7561,40851,6079,2,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1791,7561,40851,6079,2,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1792,7561,40851,6079,2,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1793,7561,40851,6079,2,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1794,7561,40851,6079,2,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1795,7561,40851,6079,2,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1796,7561,40851,6079,2,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1797,7561,40851,6079,2,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1798,7561,40851,6079,2,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1799,7561,40851,6079,2,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1800,7561,40851,6079,2,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL);
INSERT INTO `balance_libro` VALUES (1801,7561,40851,6079,2,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1802,7561,40851,6079,2,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1803,7561,40851,6079,2,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1804,7561,40851,6079,2,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1805,7561,40851,6079,2,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1806,7561,40851,6079,2,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1807,7561,40851,6079,2,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1808,7561,40851,6079,2,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1809,7561,40851,6079,2,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1810,7561,40851,6079,2,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1811,7561,40851,6079,2,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1812,7561,40851,6079,2,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1813,7561,40851,6079,2,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1814,7561,40851,6079,2,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1815,7561,40851,6079,2,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',2500.00,NULL,NULL,1,'2023-01-19 15:29:03','2023-01-19 15:29:03',NULL),(1816,7561,40851,6079,2,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',2500.00,NULL,NULL,1,'2023-01-19 15:29:04','2023-01-19 15:29:04',NULL),(1817,7561,40851,6079,2,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',2500.00,NULL,NULL,1,'2023-01-19 15:29:04','2023-01-19 15:29:04',NULL),(1818,7561,40851,6079,2,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',2500.00,NULL,NULL,1,'2023-01-19 15:29:04','2023-01-19 15:29:04',NULL),(1819,7561,40851,6079,2,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',2500.00,NULL,NULL,1,'2023-01-19 15:29:04','2023-01-19 15:29:04',NULL),(1820,7561,40851,6079,2,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',2500.00,NULL,NULL,1,'2023-01-19 15:29:04','2023-01-19 15:29:04',NULL),(1821,7561,40851,6079,2,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',2500.00,NULL,NULL,1,'2023-01-19 15:29:04','2023-01-19 15:29:04',NULL);
INSERT INTO `balance_libro` VALUES (1822,7561,40851,6079,2,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',2500.00,NULL,NULL,1,'2023-01-19 15:29:04','2023-01-19 15:29:04',NULL),(1823,7561,40851,6079,2,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',2500.00,NULL,NULL,1,'2023-01-19 15:29:04','2023-01-19 15:29:04',NULL),(1824,7561,40851,6079,2,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',2500.00,NULL,NULL,1,'2023-01-19 15:29:04','2023-01-19 15:29:04',NULL),(1825,7561,40851,6079,2,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',2500.00,NULL,NULL,1,'2023-01-19 15:29:04','2023-01-19 15:29:04',NULL),(1826,7561,40851,6079,2,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',2500.00,NULL,NULL,1,'2023-01-19 15:29:04','2023-01-19 15:29:04',NULL),(1827,7561,40851,6079,2,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',2500.00,NULL,NULL,1,'2023-01-19 15:29:04','2023-01-19 15:29:04',NULL),(1828,7561,40851,6079,2,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',2500.00,NULL,NULL,1,'2023-01-19 15:29:04','2023-01-19 15:29:04',NULL),(1829,7561,40851,6079,2,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',2500.00,NULL,NULL,1,'2023-01-19 15:29:04','2023-01-19 15:29:04',NULL),(1830,7561,40851,6079,2,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',2500.00,NULL,NULL,1,'2023-01-19 15:29:04','2023-01-19 15:29:04',NULL),(1831,7561,40851,6079,2,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',2500.00,NULL,NULL,1,'2023-01-19 15:29:04','2023-01-19 15:29:04',NULL),(1832,7561,40851,6079,2,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',2500.00,NULL,NULL,1,'2023-01-19 15:29:04','2023-01-19 15:29:04',NULL),(1833,7561,40851,6079,2,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',2500.00,NULL,NULL,1,'2023-01-19 15:29:04','2023-01-19 15:29:04',NULL),(1834,7561,40851,6079,2,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',2500.00,NULL,NULL,1,'2023-01-19 15:29:04','2023-01-19 15:29:04',NULL),(1835,7561,40851,6080,2,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',2500.00,NULL,NULL,1,'2023-01-19 15:29:19','2023-01-19 15:29:19',NULL),(1836,7561,40851,6080,2,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',2500.00,NULL,NULL,1,'2023-01-19 15:29:19','2023-01-19 15:29:19',NULL),(1837,7561,40851,6080,2,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2500.00,NULL,NULL,1,'2023-01-19 15:29:19','2023-01-19 15:29:19',NULL),(1838,7561,40851,6080,2,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2500.00,NULL,NULL,1,'2023-01-19 15:29:19','2023-01-19 15:29:19',NULL),(1839,7561,40851,6080,2,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2500.00,NULL,NULL,1,'2023-01-19 15:29:19','2023-01-19 15:29:19',NULL),(1840,7561,40851,6080,2,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2500.00,NULL,NULL,1,'2023-01-19 15:29:19','2023-01-19 15:29:19',NULL),(1841,7561,40851,6080,2,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2500.00,NULL,NULL,1,'2023-01-19 15:29:19','2023-01-19 15:29:19',NULL),(1842,7561,40851,6080,2,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2500.00,NULL,NULL,1,'2023-01-19 15:29:19','2023-01-19 15:29:19',NULL);
INSERT INTO `balance_libro` VALUES (1843,7561,40851,6080,2,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',2500.00,NULL,NULL,1,'2023-01-19 15:29:19','2023-01-19 15:29:19',NULL),(1844,7561,40851,6080,2,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',2500.00,NULL,NULL,1,'2023-01-19 15:29:19','2023-01-19 15:29:19',NULL),(1845,7561,40851,6080,2,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1846,7561,40851,6080,2,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1847,7561,40851,6080,2,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1848,7561,40851,6080,2,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1849,7561,40851,6080,2,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1850,7561,40851,6080,2,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1851,7561,40851,6080,2,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1852,7561,40851,6080,2,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1853,7561,40851,6080,2,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1854,7561,40851,6080,2,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1855,7561,40851,6080,2,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1856,7561,40851,6080,2,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1857,7561,40851,6080,2,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1858,7561,40851,6080,2,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1859,7561,40851,6080,2,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1860,7561,40851,6080,2,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1861,7561,40851,6080,2,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1862,7561,40851,6080,2,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1863,7561,40851,6080,2,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL);
INSERT INTO `balance_libro` VALUES (1864,7561,40851,6080,2,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1865,7561,40851,6080,2,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',2500.00,NULL,NULL,1,'2023-01-19 15:29:20','2023-01-19 15:29:20',NULL),(1866,7561,40851,6080,2,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1867,7561,40851,6080,2,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1868,7561,40851,6080,2,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1869,7561,40851,6080,2,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1870,7561,40851,6080,2,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1871,7561,40851,6080,2,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1872,7561,40851,6080,2,1660,'App\\Models\\Receipt',1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1873,7561,40851,6080,2,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1874,7561,40851,6080,2,1662,'App\\Models\\Receipt',1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1875,7561,40851,6080,2,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1876,7561,40851,6080,2,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1877,7561,40851,6080,2,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1878,7561,40851,6080,2,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1879,7561,40851,6080,2,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1880,7561,40851,6080,2,1668,'App\\Models\\Receipt',1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1881,7561,40851,6080,2,1669,'App\\Models\\Receipt',1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1882,7561,40851,6080,2,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1883,7561,40851,6080,2,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1884,7561,40851,6080,2,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL);
INSERT INTO `balance_libro` VALUES (1885,7561,40851,6080,2,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1886,7561,40851,6080,2,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2500.00,NULL,NULL,1,'2023-01-19 15:29:21','2023-01-19 15:29:21',NULL),(1887,7561,40851,6076,2,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1888,7561,40851,6076,2,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1889,7561,40851,6076,2,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1890,7561,40851,6076,2,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1891,7561,40851,6076,2,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1892,7561,40851,6076,2,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1893,7561,40851,6076,2,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1894,7561,40851,6076,2,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1895,7561,40851,6076,2,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1896,7561,40851,6076,2,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1897,7561,40851,6076,2,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1898,7561,40851,6076,2,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1899,7561,40851,6076,2,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1900,7561,40851,6076,2,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1901,7561,40851,6076,2,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1902,7561,40851,6076,2,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1903,7561,40851,6076,2,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1904,7561,40851,6076,2,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1905,7561,40851,6076,2,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL);
INSERT INTO `balance_libro` VALUES (1906,7561,40851,6076,2,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1907,7561,40851,6076,2,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1908,7561,40851,6076,2,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1909,7561,40851,6076,2,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1910,7561,40851,6076,2,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1911,7561,40851,6076,2,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1912,7561,40851,6076,2,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',2000.00,NULL,NULL,1,'2023-01-19 15:38:31','2023-01-19 15:38:31',NULL),(1913,7561,40851,6076,2,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1914,7561,40851,6076,2,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1915,7561,40851,6076,2,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1916,7561,40851,6076,2,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1917,7561,40851,6076,2,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1918,7561,40851,6076,2,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1919,7561,40851,6076,2,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1920,7561,40851,6076,2,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1921,7561,40851,6076,2,1709,'App\\Models\\Receipt',1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1922,7561,40851,6076,2,1710,'App\\Models\\Receipt',1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1923,7561,40851,6076,2,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1924,7561,40851,6076,2,1712,'App\\Models\\Receipt',1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1925,7561,40851,6076,2,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1926,7561,40851,6076,2,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL);
INSERT INTO `balance_libro` VALUES (1927,7561,40851,6076,2,1715,'App\\Models\\Receipt',1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1928,7561,40851,6076,2,1716,'App\\Models\\Receipt',1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1929,7561,40851,6076,2,1717,'App\\Models\\Receipt',1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1930,7561,40851,6076,2,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1931,7561,40851,6076,2,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1932,7561,40851,6076,2,1720,'App\\Models\\Receipt',1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1933,7561,40851,6076,2,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1934,7561,40851,6076,2,1722,'App\\Models\\Receipt',1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1935,7561,40851,6076,2,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1936,7561,40851,6076,2,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1937,7561,40851,6076,2,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1938,7561,40851,6076,2,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1939,7561,40851,6076,2,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',2000.00,NULL,NULL,1,'2023-01-19 15:38:32','2023-01-19 15:38:32',NULL),(1940,7561,40851,6076,2,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',2000.00,NULL,NULL,1,'2023-01-19 15:38:33','2023-01-19 15:38:33',NULL),(1941,7561,40851,6076,2,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',2000.00,NULL,NULL,1,'2023-01-19 15:38:33','2023-01-19 15:38:33',NULL),(1942,7561,40851,6076,2,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',2000.00,NULL,NULL,1,'2023-01-19 15:38:33','2023-01-19 15:38:33',NULL),(1943,7561,40851,6076,2,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',2000.00,NULL,NULL,1,'2023-01-19 15:38:33','2023-01-19 15:38:33',NULL),(1944,7561,40851,6076,2,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2000.00,NULL,NULL,1,'2023-01-19 15:38:33','2023-01-19 15:38:33',NULL),(1945,7561,40851,6076,2,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2000.00,NULL,NULL,1,'2023-01-19 15:38:33','2023-01-19 15:38:33',NULL),(1946,7561,40851,6076,2,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2000.00,NULL,NULL,1,'2023-01-19 15:38:33','2023-01-19 15:38:33',NULL),(1947,7561,40734,15249,2,1735,'App\\Models\\Receipt',1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',30030.00,NULL,NULL,1,'2023-01-19 16:25:59','2023-01-19 16:25:59',NULL);
INSERT INTO `balance_libro` VALUES (1948,7561,40734,15250,2,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',59630.00,NULL,NULL,1,'2023-01-19 16:26:17','2023-01-19 16:26:17',NULL),(1949,7561,40734,15250,2,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',24024.00,NULL,NULL,1,'2023-01-19 16:26:17','2023-01-19 16:26:17',NULL),(1950,7561,40734,15252,2,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',34216.00,NULL,NULL,1,'2023-01-19 16:30:16','2023-01-19 16:30:16',NULL),(1951,7561,40734,15253,2,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',39710.00,NULL,NULL,1,'2023-01-19 16:30:35','2023-01-19 16:30:35',NULL),(1952,7561,40734,15253,2,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',21840.00,NULL,NULL,1,'2023-01-19 16:30:35','2023-01-19 16:30:35',NULL),(1953,7561,40734,15254,2,1741,'App\\Models\\Receipt',1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',51832.00,NULL,NULL,1,'2023-01-19 16:30:58','2023-01-19 16:30:58',NULL),(1954,7561,40734,15255,2,1742,'App\\Models\\Receipt',1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',39560.00,NULL,NULL,1,'2023-01-19 16:31:39','2023-01-19 16:31:39',NULL),(1955,7561,40734,15256,2,1743,'App\\Models\\Receipt',1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',57960.00,NULL,NULL,1,'2023-01-19 16:32:00','2023-01-19 16:32:00',NULL),(1956,7561,40734,15257,2,1744,'App\\Models\\Receipt',1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',43930.00,NULL,NULL,1,'2023-01-19 16:32:16','2023-01-19 16:32:16',NULL),(1957,7561,40734,15258,2,1745,'App\\Models\\Receipt',1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',102600.00,NULL,NULL,1,'2023-01-19 16:32:37','2023-01-19 16:32:37',NULL),(1958,7561,40734,15259,2,1746,'App\\Models\\Receipt',1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',46360.00,NULL,NULL,1,'2023-01-19 16:32:49','2023-01-19 16:32:49',NULL),(1959,7561,40734,15260,2,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',99066.00,NULL,NULL,1,'2023-01-19 16:33:01','2023-01-19 16:33:01',NULL),(1960,7561,40852,7599,2,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',70000.00,NULL,NULL,1,'2023-01-19 16:54:12','2023-01-19 16:54:12',NULL),(1961,7561,40852,7599,2,1749,'App\\Models\\Receipt',1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',20000.00,NULL,NULL,1,'2023-01-19 16:54:12','2023-01-19 16:54:12',NULL),(1962,7561,40852,7600,2,1750,'App\\Models\\Receipt',1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',70000.00,NULL,NULL,1,'2023-01-19 16:54:30','2023-01-19 16:54:30',NULL),(1963,7561,40852,7600,2,1751,'App\\Models\\Receipt',1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2023-01-19 16:54:30','2023-01-19 16:54:30',NULL),(1964,7561,40852,7601,2,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',70000.00,NULL,NULL,1,'2023-01-19 16:54:43','2023-01-19 16:54:43',NULL),(1965,7561,40852,7601,2,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',20000.00,NULL,NULL,1,'2023-01-19 16:54:43','2023-01-19 16:54:43',NULL),(1966,7561,40852,7602,2,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',70000.00,NULL,NULL,1,'2023-01-19 16:56:40','2023-01-19 16:56:40',NULL),(1967,7561,40852,7602,2,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',20000.00,NULL,NULL,1,'2023-01-19 16:56:40','2023-01-19 16:56:40',NULL),(1968,7561,40852,7603,2,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',70000.00,NULL,NULL,1,'2023-01-19 16:57:10','2023-01-19 16:57:10',NULL);
INSERT INTO `balance_libro` VALUES (1969,7561,40852,7603,2,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',20000.00,NULL,NULL,1,'2023-01-19 16:57:10','2023-01-19 16:57:10',NULL),(1970,7561,40852,7604,2,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',70000.00,NULL,NULL,1,'2023-01-19 16:57:32','2023-01-19 16:57:32',NULL),(1971,7561,40852,7604,2,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',20000.00,NULL,NULL,1,'2023-01-19 16:57:32','2023-01-19 16:57:32',NULL),(1972,7561,40852,7605,2,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',70000.00,NULL,NULL,1,'2023-01-19 16:58:07','2023-01-19 16:58:07',NULL),(1973,7561,40852,7605,2,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',20000.00,NULL,NULL,1,'2023-01-19 16:58:07','2023-01-19 16:58:07',NULL),(1974,7561,40852,7606,2,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',70000.00,NULL,NULL,1,'2023-01-19 16:59:37','2023-01-19 16:59:37',NULL),(1975,7561,40852,7606,2,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',20000.00,NULL,NULL,1,'2023-01-19 16:59:37','2023-01-19 16:59:37',NULL),(1976,7561,40852,7607,2,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',70000.00,NULL,NULL,1,'2023-01-19 17:00:03','2023-01-19 17:00:03',NULL),(1977,7561,40852,7607,2,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',20000.00,NULL,NULL,1,'2023-01-19 17:00:03','2023-01-19 17:00:03',NULL),(1978,7561,40852,7608,2,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',70000.00,NULL,NULL,1,'2023-01-19 17:01:10','2023-01-19 17:01:10',NULL),(1979,7561,40852,7608,2,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',20000.00,NULL,NULL,1,'2023-01-19 17:01:10','2023-01-19 17:01:10',NULL),(1980,7561,40852,7610,2,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',153150.00,NULL,NULL,1,'2023-01-19 17:01:37','2023-01-19 17:01:37',NULL),(1981,7561,40852,7610,2,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',20000.00,NULL,NULL,1,'2023-01-19 17:01:37','2023-01-19 17:01:37',NULL),(1982,7561,40852,7610,2,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',153150.00,NULL,NULL,1,'2023-01-19 17:01:37','2023-01-19 17:01:37',NULL),(1983,7561,40852,7610,2,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',20000.00,NULL,NULL,1,'2023-01-19 17:01:37','2023-01-19 17:01:37',NULL),(1984,7561,40852,7610,2,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',70000.00,NULL,NULL,1,'2023-01-19 17:01:37','2023-01-19 17:01:37',NULL),(1985,7561,40852,7610,2,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',20000.00,NULL,NULL,1,'2023-01-19 17:01:37','2023-01-19 17:01:37',NULL),(1986,7561,40852,7610,2,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',153150.00,NULL,NULL,1,'2023-01-19 17:01:37','2023-04-18 11:46:24','2023-04-18 11:46:24'),(1987,7561,40852,7610,2,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',20000.00,NULL,NULL,1,'2023-01-19 17:01:37','2023-04-18 11:45:38','2023-04-18 11:45:38'),(1988,7561,40857,18309,2,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2023-01-19 17:49:55','2023-01-19 17:49:55',NULL);
INSERT INTO `balance_libro` VALUES (1989,7561,40857,18309,2,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',30000.00,NULL,NULL,1,'2023-01-19 17:49:55','2023-01-19 17:49:55',NULL),(1990,7561,40857,18310,2,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',25000.00,NULL,NULL,1,'2023-01-19 17:50:57','2023-01-19 17:50:57',NULL),(1991,7561,40857,18310,2,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',30000.00,NULL,NULL,1,'2023-01-19 17:50:57','2023-01-19 17:50:57',NULL),(1992,7561,40857,18311,2,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',25000.00,NULL,NULL,1,'2023-01-19 17:51:12','2023-01-19 17:51:12',NULL),(1993,7561,40857,18311,2,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',30000.00,NULL,NULL,1,'2023-01-19 17:51:12','2023-01-19 17:51:12',NULL),(1994,7561,40857,18312,2,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',25000.00,NULL,NULL,1,'2023-01-19 17:51:28','2023-01-19 17:51:28',NULL),(1995,7561,40857,18313,2,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',25000.00,NULL,NULL,1,'2023-01-19 17:52:06','2023-01-19 17:52:06',NULL),(1996,7561,40857,18313,2,1784,'App\\Models\\Receipt',1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',30000.00,NULL,NULL,1,'2023-01-19 17:52:06','2023-01-19 17:52:06',NULL),(1997,7561,40857,18314,2,1785,'App\\Models\\Receipt',1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',25000.00,NULL,NULL,1,'2023-01-19 17:52:23','2023-01-19 17:52:23',NULL),(1998,7561,40857,18314,2,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',30000.00,NULL,NULL,1,'2023-01-19 17:52:23','2023-01-19 17:52:23',NULL),(1999,7561,40857,18315,2,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',25000.00,NULL,NULL,1,'2023-01-19 17:52:41','2023-01-19 17:52:41',NULL),(2000,7561,40857,18315,2,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',25000.00,NULL,NULL,1,'2023-01-19 17:52:41','2023-01-19 17:52:41',NULL),(2001,7561,40857,18315,2,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',30000.00,NULL,NULL,1,'2023-01-19 17:52:41','2023-01-19 17:52:41',NULL),(2002,7561,40857,18315,2,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',25000.00,NULL,NULL,1,'2023-01-19 17:52:41','2023-01-19 17:52:41',NULL),(2003,7561,40857,18315,2,1791,'App\\Models\\Receipt',1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',38000.00,NULL,NULL,1,'2023-01-19 17:52:41','2023-01-19 17:52:41',NULL),(2004,7561,40857,18316,2,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',33832.00,NULL,NULL,1,'2023-01-19 17:53:43','2023-01-19 17:53:43',NULL),(2005,7561,40857,18316,2,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',30000.00,NULL,NULL,1,'2023-01-19 17:53:43','2023-01-19 17:53:43',NULL),(2006,7561,40857,18316,2,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',38000.00,NULL,NULL,1,'2023-01-19 17:53:43','2023-01-19 17:53:43',NULL),(2007,7561,40857,18318,2,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',40476.00,NULL,NULL,1,'2023-01-19 17:54:58','2023-01-19 17:54:58',NULL),(2008,7561,40857,18318,2,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',49400.00,NULL,NULL,1,'2023-01-19 17:54:58','2023-01-19 17:54:58',NULL),(2009,7561,40857,18318,2,1797,'App\\Models\\Receipt',1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',38000.00,NULL,NULL,1,'2023-01-19 17:54:58','2023-01-19 17:54:58',NULL);
INSERT INTO `balance_libro` VALUES (2010,7561,40857,18319,2,1798,'App\\Models\\Receipt',1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',40476.00,NULL,NULL,1,'2023-01-19 17:55:15','2023-01-19 17:55:15',NULL),(2011,7561,40857,18319,2,1799,'App\\Models\\Receipt',1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',49400.00,NULL,NULL,1,'2023-01-19 17:55:15','2023-01-19 17:55:15',NULL),(2012,7561,40857,18319,2,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',38000.00,NULL,NULL,1,'2023-01-19 17:55:15','2023-01-19 17:55:15',NULL),(2013,7561,40857,18320,2,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',40476.00,NULL,NULL,1,'2023-01-19 17:55:30','2023-01-19 17:55:30',NULL),(2014,7561,40857,18320,2,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',49400.00,NULL,NULL,1,'2023-01-19 17:55:30','2023-01-19 17:55:30',NULL),(2015,7561,40857,18320,2,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',38000.00,NULL,NULL,1,'2023-01-19 17:55:30','2023-01-19 17:55:30',NULL),(2016,7561,40857,18317,2,1804,'App\\Models\\Receipt',1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',40476.00,NULL,NULL,1,'2023-01-19 17:57:45','2023-01-19 17:57:45',NULL),(2017,7561,40857,18317,2,1805,'App\\Models\\Receipt',1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',49400.00,NULL,NULL,1,'2023-01-19 17:57:45','2023-01-19 17:57:45',NULL),(2018,7561,40857,18317,2,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',38000.00,NULL,NULL,1,'2023-01-19 17:57:45','2023-01-19 17:57:45',NULL),(2019,7561,40853,9129,2,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',17450.00,NULL,NULL,1,'2023-01-19 18:57:48','2023-01-19 18:57:48',NULL),(2020,7561,40853,9129,2,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',9000.00,NULL,NULL,1,'2023-01-19 18:57:48','2023-01-19 18:57:48',NULL),(2021,7561,40853,9130,2,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',9000.00,NULL,NULL,1,'2023-01-19 18:58:03','2023-01-19 18:58:03',NULL),(2022,7561,40853,9131,2,1810,'App\\Models\\Receipt',1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',17450.00,NULL,NULL,1,'2023-01-19 18:58:17','2023-01-19 18:58:17',NULL),(2023,7561,40853,9131,2,1811,'App\\Models\\Receipt',1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',17450.00,NULL,NULL,1,'2023-01-19 18:58:17','2023-01-19 18:58:17',NULL),(2024,7561,40853,9131,2,1812,'App\\Models\\Receipt',1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',9000.00,NULL,NULL,1,'2023-01-19 18:58:17','2023-01-19 18:58:17',NULL),(2025,7561,40853,9132,2,1813,'App\\Models\\Receipt',1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',9000.00,NULL,NULL,1,'2023-01-19 18:58:37','2023-01-19 18:58:37',NULL),(2026,7561,40853,9132,2,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',17450.00,NULL,NULL,1,'2023-01-19 18:58:37','2023-01-19 19:13:42','2023-01-19 19:13:42'),(2027,7561,40853,9132,2,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',800.00,NULL,NULL,1,'2023-01-19 18:58:37','2023-01-19 18:58:37',NULL),(2028,7561,40853,9132,2,1816,'App\\Models\\Receipt',1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',600.00,NULL,NULL,1,'2023-01-19 18:58:37','2023-01-19 18:58:37',NULL),(2029,7561,40853,9132,2,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',600.00,NULL,NULL,1,'2023-01-19 18:58:37','2023-01-19 18:58:37',NULL),(2030,7561,40853,9132,2,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',400.00,NULL,NULL,1,'2023-01-19 18:58:37','2023-01-19 18:58:37',NULL);
INSERT INTO `balance_libro` VALUES (2031,7561,40853,9132,2,1819,'App\\Models\\Receipt',1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',600.00,NULL,NULL,1,'2023-01-19 18:58:37','2023-01-19 18:58:37',NULL),(2032,7561,40853,9132,2,1820,'App\\Models\\Receipt',1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',600.00,NULL,NULL,1,'2023-01-19 18:58:37','2023-01-19 18:58:37',NULL),(2033,7561,40853,9132,2,1821,'App\\Models\\Receipt',1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',900.00,NULL,NULL,1,'2023-01-19 18:58:37','2023-01-19 18:58:37',NULL),(2034,7561,40853,9132,2,1822,'App\\Models\\Receipt',1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',1200.00,NULL,NULL,1,'2023-01-19 18:58:37','2023-01-19 18:58:37',NULL),(2035,7561,40853,9132,2,1823,'App\\Models\\Receipt',1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',800.00,NULL,NULL,1,'2023-01-19 18:58:37','2023-01-19 18:58:37',NULL),(2036,7561,40853,9132,2,1824,'App\\Models\\Receipt',1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',700.00,NULL,NULL,1,'2023-01-19 18:58:37','2023-01-19 18:58:37',NULL),(2037,7561,40853,9132,2,1825,'App\\Models\\Receipt',1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',700.00,NULL,NULL,1,'2023-01-19 18:58:37','2023-01-19 18:58:37',NULL),(2038,7561,40853,9132,2,1826,'App\\Models\\Receipt',1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',800.00,NULL,NULL,1,'2023-01-19 18:58:37','2023-01-19 18:58:37',NULL),(2039,7561,40853,9132,2,1827,'App\\Models\\Receipt',1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',800.00,NULL,NULL,1,'2023-01-19 18:58:37','2023-01-19 18:58:37',NULL),(2040,7561,40853,9132,2,1828,'App\\Models\\Receipt',1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1500.00,NULL,NULL,1,'2023-01-19 18:58:37','2023-01-19 18:58:37',NULL),(2041,7561,40853,9133,2,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',800.00,NULL,NULL,1,'2023-01-19 18:58:54','2023-01-19 18:58:54',NULL),(2042,7561,40853,9133,2,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',900.00,NULL,NULL,1,'2023-01-19 18:58:54','2023-01-19 18:58:54',NULL),(2043,7561,40853,9133,2,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',1200.00,NULL,NULL,1,'2023-01-19 18:58:54','2023-01-19 18:58:54',NULL),(2044,7561,40853,9133,2,1832,'App\\Models\\Receipt',1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',500.00,NULL,NULL,1,'2023-01-19 18:58:54','2023-01-19 18:58:54',NULL),(2045,7561,40853,9133,2,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',600.00,NULL,NULL,1,'2023-01-19 18:58:54','2023-01-19 18:58:54',NULL),(2046,7561,40853,9133,2,1834,'App\\Models\\Receipt',1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',400.00,NULL,NULL,1,'2023-01-19 18:58:55','2023-01-19 18:58:55',NULL),(2047,7561,40853,9133,2,1835,'App\\Models\\Receipt',1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',800.00,NULL,NULL,1,'2023-01-19 18:58:55','2023-01-19 18:58:55',NULL),(2048,7561,40853,9133,2,1836,'App\\Models\\Receipt',1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',1100.00,NULL,NULL,1,'2023-01-19 18:58:55','2023-01-19 18:58:55',NULL),(2049,7561,40853,9133,2,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',800.00,NULL,NULL,1,'2023-01-19 18:58:55','2023-01-19 18:58:55',NULL),(2050,7561,40853,9133,2,1838,'App\\Models\\Receipt',1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',700.00,NULL,NULL,1,'2023-01-19 18:58:55','2023-01-19 18:58:55',NULL),(2051,7561,40853,9133,2,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',700.00,NULL,NULL,1,'2023-01-19 18:58:55','2023-01-19 18:58:55',NULL);
INSERT INTO `balance_libro` VALUES (2052,7561,40853,9133,2,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',700.00,NULL,NULL,1,'2023-01-19 18:58:55','2023-01-19 18:58:55',NULL),(2053,7561,40853,9133,2,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',600.00,NULL,NULL,1,'2023-01-19 18:58:55','2023-01-19 18:58:55',NULL),(2054,7561,40853,9133,2,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',1200.00,NULL,NULL,1,'2023-01-19 18:58:55','2023-01-19 18:58:55',NULL),(2055,7561,40853,9133,2,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',500.00,NULL,NULL,1,'2023-01-19 18:58:55','2023-01-19 18:58:55',NULL),(2056,7561,40853,9133,2,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',800.00,NULL,NULL,1,'2023-01-19 18:58:55','2023-01-19 18:58:55',NULL),(2057,7561,40853,9133,2,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',700.00,NULL,NULL,1,'2023-01-19 18:58:55','2023-01-19 18:58:55',NULL),(2058,7561,40853,9133,2,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',700.00,NULL,NULL,1,'2023-01-19 18:58:55','2023-01-19 18:58:55',NULL),(2059,7561,40853,9133,2,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',700.00,NULL,NULL,1,'2023-01-19 18:58:55','2023-01-19 18:58:55',NULL),(2060,7561,40853,9133,2,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',800.00,NULL,NULL,1,'2023-01-19 18:58:55','2023-01-19 18:58:55',NULL),(2061,7561,40853,9133,2,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',700.00,NULL,NULL,1,'2023-01-19 18:58:55','2023-01-19 18:58:55',NULL),(2062,7561,40853,9133,2,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',800.00,NULL,NULL,1,'2023-01-19 18:58:55','2023-01-19 18:58:55',NULL),(2063,7561,40853,9133,2,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',700.00,NULL,NULL,1,'2023-01-19 18:58:55','2023-01-19 18:58:55',NULL),(2064,7561,40853,9133,2,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',700.00,NULL,NULL,1,'2023-01-19 18:58:55','2023-01-19 18:58:55',NULL),(2065,7561,40853,9134,2,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',800.00,NULL,NULL,1,'2023-01-19 18:59:13','2023-01-19 18:59:13',NULL),(2066,7561,40853,9134,2,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',600.00,NULL,NULL,1,'2023-01-19 18:59:13','2023-01-19 18:59:13',NULL),(2067,7561,40853,9134,2,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',800.00,NULL,NULL,1,'2023-01-19 18:59:13','2023-01-19 18:59:13',NULL),(2068,7561,40853,9134,2,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',1200.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2069,7561,40853,9134,2,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',800.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2070,7561,40853,9134,2,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',700.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2071,7561,40853,9134,2,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',700.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2072,7561,40853,9134,2,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',600.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL);
INSERT INTO `balance_libro` VALUES (2073,7561,40853,9134,2,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',600.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2074,7561,40853,9134,2,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',700.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2075,7561,40853,9134,2,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',800.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2076,7561,40853,9134,2,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',700.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2077,7561,40853,9134,2,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',800.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2078,7561,40853,9134,2,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',800.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2079,7561,40853,9134,2,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',800.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2080,7561,40853,9134,2,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',700.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2081,7561,40853,9134,2,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',800.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2082,7561,40853,9134,2,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',500.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2083,7561,40853,9134,2,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',800.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2084,7561,40853,9134,2,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',700.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2085,7561,40853,9134,2,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',700.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2086,7561,40853,9134,2,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',800.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2087,7561,40853,9134,2,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',9000.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2088,7561,40853,9134,2,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',17450.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2089,7561,40853,9134,2,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',9000.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2090,7561,40853,9134,2,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',20591.00,NULL,NULL,1,'2023-01-19 18:59:14','2023-01-19 18:59:14',NULL),(2091,7561,40853,9135,2,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',900.00,NULL,NULL,1,'2023-01-19 18:59:31','2023-01-19 18:59:31',NULL),(2092,7561,40853,9135,2,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',900.00,NULL,NULL,1,'2023-01-19 18:59:31','2023-01-19 18:59:31',NULL),(2093,7561,40853,9135,2,1881,'App\\Models\\Receipt',1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',900.00,NULL,NULL,1,'2023-01-19 18:59:31','2023-01-19 18:59:31',NULL);
INSERT INTO `balance_libro` VALUES (2094,7561,40853,9135,2,1882,'App\\Models\\Receipt',1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',800.00,NULL,NULL,1,'2023-01-19 18:59:31','2023-01-19 18:59:31',NULL),(2095,7561,40853,9135,2,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',700.00,NULL,NULL,1,'2023-01-19 18:59:31','2023-01-19 18:59:31',NULL),(2096,7561,40853,9135,2,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',800.00,NULL,NULL,1,'2023-01-19 18:59:31','2023-01-19 18:59:31',NULL),(2097,7561,40853,9135,2,1885,'App\\Models\\Receipt',1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',800.00,NULL,NULL,1,'2023-01-19 18:59:31','2023-01-19 18:59:31',NULL),(2098,7561,40853,9135,2,1886,'App\\Models\\Receipt',1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',800.00,NULL,NULL,1,'2023-01-19 18:59:31','2023-01-19 18:59:31',NULL),(2099,7561,40853,9135,2,1887,'App\\Models\\Receipt',1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',20591.00,NULL,NULL,1,'2023-01-19 18:59:31','2023-01-19 18:59:31',NULL),(2100,7561,40853,9135,2,1888,'App\\Models\\Receipt',1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',9000.00,NULL,NULL,1,'2023-01-19 18:59:31','2023-01-19 18:59:31',NULL),(2101,7561,40853,9135,2,1889,'App\\Models\\Receipt',1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',900.00,NULL,NULL,1,'2023-01-19 18:59:31','2023-01-19 18:59:31',NULL),(2102,7561,40853,9135,2,1890,'App\\Models\\Receipt',1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',800.00,NULL,NULL,1,'2023-01-19 18:59:31','2023-01-19 18:59:31',NULL),(2103,7561,40853,9135,2,1891,'App\\Models\\Receipt',1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1000.00,NULL,NULL,1,'2023-01-19 18:59:31','2023-01-19 18:59:31',NULL),(2104,7561,40853,9135,2,1892,'App\\Models\\Receipt',1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',800.00,NULL,NULL,1,'2023-01-19 18:59:31','2023-01-19 18:59:31',NULL),(2105,7561,40853,9135,2,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',900.00,NULL,NULL,1,'2023-01-19 18:59:32','2023-01-19 18:59:32',NULL),(2106,7561,40853,9137,2,1894,'App\\Models\\Receipt',1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',900.00,NULL,NULL,1,'2023-01-19 19:00:59','2023-01-19 19:41:35','2023-01-19 19:41:35'),(2107,7561,40853,9137,2,1895,'App\\Models\\Receipt',1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',20591.00,NULL,NULL,1,'2023-01-19 19:00:59','2023-01-19 19:41:36','2023-01-19 19:41:36'),(2108,7561,40853,9137,2,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',900.00,NULL,NULL,1,'2023-01-19 19:00:59','2023-01-19 19:41:36','2023-01-19 19:41:36'),(2109,7561,40853,9137,2,1897,'App\\Models\\Receipt',1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',800.00,NULL,NULL,1,'2023-01-19 19:00:59','2023-01-19 19:41:36','2023-01-19 19:41:36'),(2110,7561,40853,9137,2,1898,'App\\Models\\Receipt',1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',900.00,NULL,NULL,1,'2023-01-19 19:01:00','2023-01-19 19:41:36','2023-01-19 19:41:36'),(2111,7561,40853,9137,2,1899,'App\\Models\\Receipt',1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',1000.00,NULL,NULL,1,'2023-01-19 19:01:00','2023-01-19 19:41:36','2023-01-19 19:41:36'),(2112,7561,40853,9137,2,1900,'App\\Models\\Receipt',1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',900.00,NULL,NULL,1,'2023-01-19 19:01:00','2023-01-19 19:41:36','2023-01-19 19:41:36'),(2113,7561,40853,9137,2,1901,'App\\Models\\Receipt',1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',800.00,NULL,NULL,1,'2023-01-19 19:01:00','2023-01-19 19:41:36','2023-01-19 19:41:36');
INSERT INTO `balance_libro` VALUES (2114,7561,40853,9137,2,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',900.00,NULL,NULL,1,'2023-01-19 19:01:00','2023-01-19 19:41:36','2023-01-19 19:41:36'),(2115,7561,40853,9137,2,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',900.00,NULL,NULL,1,'2023-01-19 19:01:00','2023-01-19 19:38:49','2023-01-19 19:38:49'),(2116,7561,40853,9137,2,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',800.00,NULL,NULL,1,'2023-01-19 19:01:00','2023-01-19 19:38:36','2023-01-19 19:38:36'),(2117,7561,40853,9137,2,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',9000.00,NULL,NULL,1,'2023-01-19 19:01:00','2023-01-19 19:38:17','2023-01-19 19:38:17'),(2118,7561,40853,9137,2,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',900.00,NULL,NULL,1,'2023-01-19 19:01:00','2023-01-19 19:37:35','2023-01-19 19:37:35'),(2119,7561,40853,9137,2,1907,'App\\Models\\Receipt',1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',900.00,NULL,NULL,1,'2023-01-19 19:01:00','2023-01-19 19:38:05','2023-01-19 19:38:05'),(2120,7561,40853,9137,2,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',900.00,NULL,NULL,1,'2023-01-19 19:01:00','2023-01-19 19:37:26','2023-01-19 19:37:26'),(2121,7561,40853,9137,2,1909,'App\\Models\\Receipt',1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',800.00,NULL,NULL,1,'2023-01-19 19:01:00','2023-01-19 19:37:52','2023-01-19 19:37:52'),(2122,7561,40853,9137,2,1910,'App\\Models\\Receipt',1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',900.00,NULL,NULL,1,'2023-01-19 19:01:00','2023-01-19 19:37:12','2023-01-19 19:37:12'),(2123,7561,40853,9137,2,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',800.00,NULL,NULL,1,'2023-01-19 19:01:00','2023-01-19 19:36:55','2023-01-19 19:36:55'),(2124,7561,40853,9139,2,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1000.00,NULL,NULL,1,'2023-01-19 19:01:35','2023-01-19 19:01:35',NULL),(2125,7561,40853,9139,2,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1100.00,NULL,NULL,1,'2023-01-19 19:01:35','2023-01-19 19:01:35',NULL),(2126,7561,40853,9139,2,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',1000.00,NULL,NULL,1,'2023-01-19 19:01:35','2023-01-19 19:01:35',NULL),(2127,7561,40853,9139,2,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',1100.00,NULL,NULL,1,'2023-01-19 19:01:35','2023-01-19 19:01:35',NULL),(2128,7561,40853,9139,2,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',1000.00,NULL,NULL,1,'2023-01-19 19:01:35','2023-01-19 19:01:35',NULL),(2129,7561,40853,9139,2,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',1100.00,NULL,NULL,1,'2023-01-19 19:01:35','2023-01-19 19:01:35',NULL),(2130,7561,40853,9139,2,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',1000.00,NULL,NULL,1,'2023-01-19 19:01:35','2023-01-19 19:01:35',NULL),(2131,7561,40853,9139,2,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',1000.00,NULL,NULL,1,'2023-01-19 19:01:35','2023-01-19 19:01:35',NULL),(2132,7561,40853,9139,2,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',1000.00,NULL,NULL,1,'2023-01-19 19:01:35','2023-01-19 19:01:35',NULL),(2133,7561,40853,9139,2,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',30000.00,NULL,NULL,1,'2023-01-19 19:01:35','2023-01-19 19:13:15','2023-01-19 19:13:15');
INSERT INTO `balance_libro` VALUES (2134,7561,40853,9139,2,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',1000.00,NULL,NULL,1,'2023-01-19 19:01:35','2023-01-19 19:01:35',NULL),(2135,7561,40853,9139,2,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',900.00,NULL,NULL,1,'2023-01-19 19:01:35','2023-01-19 19:01:35',NULL),(2136,7561,40853,9139,2,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',1100.00,NULL,NULL,1,'2023-01-19 19:01:35','2023-01-19 19:01:35',NULL),(2137,7561,40853,9139,2,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',1000.00,NULL,NULL,1,'2023-01-19 19:01:35','2023-01-19 19:01:35',NULL),(2138,7561,40853,9139,2,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',1100.00,NULL,NULL,1,'2023-01-19 19:01:35','2023-01-19 19:01:35',NULL),(2139,7561,40853,9140,2,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1100.00,NULL,NULL,1,'2023-01-19 19:01:50','2023-01-19 19:01:50',NULL),(2140,7561,40853,9140,2,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1000.00,NULL,NULL,1,'2023-01-19 19:01:50','2023-01-19 19:01:50',NULL),(2141,7561,40853,9140,2,1929,'App\\Models\\Receipt',1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1000.00,NULL,NULL,1,'2023-01-19 19:01:50','2023-01-19 19:01:50',NULL),(2142,7561,40853,9140,2,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1100.00,NULL,NULL,1,'2023-01-19 19:01:50','2023-01-19 19:01:50',NULL),(2143,7561,40853,9140,2,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',100.00,NULL,NULL,1,'2023-01-19 19:01:50','2023-01-19 19:01:50',NULL),(2144,7561,40853,9140,2,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',1000.00,NULL,NULL,1,'2023-01-19 19:01:50','2023-01-19 19:01:50',NULL),(2145,7561,40853,9140,2,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',900.00,NULL,NULL,1,'2023-01-19 19:01:51','2023-01-19 19:01:51',NULL),(2146,7561,40853,9140,2,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1000.00,NULL,NULL,1,'2023-01-19 19:01:51','2023-01-19 19:01:51',NULL),(2147,7561,40853,9140,2,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1200.00,NULL,NULL,1,'2023-01-19 19:01:51','2023-01-19 19:01:51',NULL),(2148,7561,40853,9140,2,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1100.00,NULL,NULL,1,'2023-01-19 19:01:51','2023-01-19 19:01:51',NULL),(2149,7561,40853,9140,2,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1100.00,NULL,NULL,1,'2023-01-19 19:01:51','2023-01-19 19:01:51',NULL),(2150,7561,40853,9140,2,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1000.00,NULL,NULL,1,'2023-01-19 19:01:51','2023-01-19 19:01:51',NULL),(2151,7561,40853,9140,2,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',16200.00,NULL,NULL,1,'2023-01-19 19:01:51','2023-01-19 19:12:55','2023-01-19 19:12:55'),(2152,7561,40853,9140,2,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',30000.00,NULL,NULL,1,'2023-01-19 19:01:51','2023-01-19 19:12:43','2023-01-19 19:12:43'),(2153,7561,40853,9140,2,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',16200.00,NULL,NULL,1,'2023-01-19 19:01:51','2023-01-19 19:12:25','2023-01-19 19:12:25');
INSERT INTO `balance_libro` VALUES (2154,7561,40853,9140,2,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1100.00,NULL,NULL,1,'2023-01-19 19:01:51','2023-01-19 19:01:51',NULL),(2155,7561,40853,9140,2,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1200.00,NULL,NULL,1,'2023-01-19 19:01:51','2023-01-19 19:01:51',NULL),(2156,7561,40853,9140,2,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1200.00,NULL,NULL,1,'2023-01-19 19:01:51','2023-01-19 19:01:51',NULL),(2157,7561,40853,9140,2,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1100.00,NULL,NULL,1,'2023-01-19 19:01:51','2023-01-19 19:01:51',NULL),(2158,7561,40853,9138,2,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1000.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL),(2159,7561,40853,9138,2,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',900.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL),(2160,7561,40853,9138,2,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1100.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL),(2161,7561,40853,9138,2,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1100.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL),(2162,7561,40853,9138,2,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1000.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL),(2163,7561,40853,9138,2,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1100.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL),(2164,7561,40853,9138,2,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1000.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL),(2165,7561,40853,9138,2,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1000.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL),(2166,7561,40853,9138,2,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1100.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL),(2167,7561,40853,9138,2,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1000.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL),(2168,7561,40853,9138,2,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',16200.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:11:55','2023-01-19 19:11:55'),(2169,7561,40853,9138,2,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1000.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL),(2170,7561,40853,9138,2,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1000.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL),(2171,7561,40853,9138,2,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',20591.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:11:40','2023-01-19 19:11:40'),(2172,7561,40853,9138,2,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1100.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL),(2173,7561,40853,9138,2,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1000.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL),(2174,7561,40853,9138,2,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1200.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL);
INSERT INTO `balance_libro` VALUES (2175,7561,40853,9138,2,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1000.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL),(2176,7561,40853,9138,2,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1000.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL),(2177,7561,40853,9138,2,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1200.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL),(2178,7561,40853,9138,2,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1500.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL),(2179,7561,40853,9138,2,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1000.00,NULL,NULL,1,'2023-01-19 19:04:34','2023-01-19 19:04:34',NULL),(2180,7561,40853,9138,2,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',900.00,NULL,NULL,1,'2023-01-19 19:04:35','2023-01-19 19:04:35',NULL),(2181,7561,40853,9138,2,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1100.00,NULL,NULL,1,'2023-01-19 19:04:35','2023-01-19 19:04:35',NULL),(2182,7561,40853,9138,2,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1000.00,NULL,NULL,1,'2023-01-19 19:04:35','2023-01-19 19:04:35',NULL),(2183,7561,40853,9138,2,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1000.00,NULL,NULL,1,'2023-01-19 19:04:35','2023-01-19 19:04:35',NULL),(2184,7561,40853,9138,2,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1000.00,NULL,NULL,1,'2023-01-19 19:04:35','2023-01-19 19:04:35',NULL),(2185,7561,40853,9138,2,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1100.00,NULL,NULL,1,'2023-01-19 19:04:35','2023-01-19 19:04:35',NULL),(2186,7561,40853,9138,2,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1000.00,NULL,NULL,1,'2023-01-19 19:04:35','2023-01-19 19:04:35',NULL),(2187,7561,40853,9138,2,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1200.00,NULL,NULL,1,'2023-01-19 19:04:35','2023-01-19 19:11:19','2023-01-19 19:11:19'),(2188,7561,40853,9138,2,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1200.00,NULL,NULL,1,'2023-01-19 19:11:19','2023-01-19 19:11:19',NULL),(2189,7561,40853,9138,2,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',20591.00,NULL,NULL,1,'2023-01-19 19:11:40','2023-01-19 19:11:40',NULL),(2190,7561,40853,9138,2,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',16200.00,NULL,NULL,1,'2023-01-19 19:11:55','2023-01-19 19:11:55',NULL),(2191,7561,40853,9140,2,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',16200.00,NULL,NULL,1,'2023-01-19 19:12:25','2023-01-19 19:12:25',NULL),(2192,7561,40853,9140,2,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',30000.00,NULL,NULL,1,'2023-01-19 19:12:43','2023-01-19 19:12:43',NULL),(2193,7561,40853,9140,2,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',16200.00,NULL,NULL,1,'2023-01-19 19:12:55','2023-01-19 19:12:55',NULL),(2194,7561,40853,9139,2,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',30000.00,NULL,NULL,1,'2023-01-19 19:13:15','2023-01-19 19:13:15',NULL),(2195,7561,40853,9132,2,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',17450.00,NULL,NULL,1,'2023-01-19 19:13:42','2023-01-19 19:13:42',NULL);
INSERT INTO `balance_libro` VALUES (2196,7561,40853,9136,2,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',900.00,NULL,NULL,1,'2023-01-19 19:43:18','2023-01-19 19:43:18',NULL),(2197,7561,40853,9136,2,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',20591.00,NULL,NULL,1,'2023-01-19 19:43:18','2023-01-19 19:43:18',NULL),(2198,7561,40853,9136,2,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',900.00,NULL,NULL,1,'2023-01-19 19:43:18','2023-01-19 19:43:18',NULL),(2199,7561,40853,9136,2,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',800.00,NULL,NULL,1,'2023-01-19 19:43:18','2023-01-19 19:43:18',NULL),(2200,7561,40853,9136,2,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',900.00,NULL,NULL,1,'2023-01-19 19:43:18','2023-01-19 19:43:18',NULL),(2201,7561,40853,9136,2,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',1000.00,NULL,NULL,1,'2023-01-19 19:43:18','2023-01-19 19:43:18',NULL),(2202,7561,40853,9136,2,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',900.00,NULL,NULL,1,'2023-01-19 19:43:18','2023-01-19 19:43:18',NULL),(2203,7561,40853,9136,2,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',800.00,NULL,NULL,1,'2023-01-19 19:43:18','2023-01-19 19:43:18',NULL),(2204,7561,40853,9136,2,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',900.00,NULL,NULL,1,'2023-01-19 19:43:18','2023-01-19 19:43:18',NULL),(2205,7561,40853,9136,2,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',900.00,NULL,NULL,1,'2023-01-19 19:43:19','2023-01-19 19:43:19',NULL),(2206,7561,40853,9136,2,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',800.00,NULL,NULL,1,'2023-01-19 19:43:19','2023-01-19 19:43:19',NULL),(2207,7561,40853,9136,2,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',9000.00,NULL,NULL,1,'2023-01-19 19:43:19','2023-01-19 19:43:19',NULL),(2208,7561,40853,9136,2,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',900.00,NULL,NULL,1,'2023-01-19 19:43:19','2023-01-19 19:43:19',NULL),(2209,7561,40853,9136,2,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',900.00,NULL,NULL,1,'2023-01-19 19:43:19','2023-01-19 19:43:19',NULL),(2210,7561,40853,9136,2,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',900.00,NULL,NULL,1,'2023-01-19 19:43:19','2023-01-19 19:43:19',NULL),(2211,7561,40853,9136,2,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',800.00,NULL,NULL,1,'2023-01-19 19:43:19','2023-01-19 19:43:19',NULL),(2212,7561,40853,9136,2,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',900.00,NULL,NULL,1,'2023-01-19 19:43:19','2023-01-19 19:43:19',NULL),(2213,7561,40853,9136,2,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',800.00,NULL,NULL,1,'2023-01-19 19:43:19','2023-01-19 19:43:19',NULL),(2214,7561,40853,9137,2,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',900.00,NULL,NULL,1,'2023-01-19 19:48:49','2023-01-19 19:48:49',NULL),(2215,7561,40853,9137,2,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',900.00,NULL,NULL,1,'2023-01-19 19:48:49','2023-01-19 19:48:49',NULL),(2216,7561,40853,9137,2,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',1100.00,NULL,NULL,1,'2023-01-19 19:48:49','2023-01-19 19:48:49',NULL);
INSERT INTO `balance_libro` VALUES (2217,7561,40853,9137,2,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',1000.00,NULL,NULL,1,'2023-01-19 19:48:49','2023-01-19 19:48:49',NULL),(2218,7561,40853,9137,2,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',1100.00,NULL,NULL,1,'2023-01-19 19:48:49','2023-01-19 19:48:49',NULL),(2219,7561,40853,9137,2,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',20591.00,NULL,NULL,1,'2023-01-19 19:48:49','2023-01-19 19:48:49',NULL),(2220,7561,40853,9137,2,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',1000.00,NULL,NULL,1,'2023-01-19 19:48:49','2023-01-19 19:48:49',NULL),(2221,7561,40853,9137,2,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',800.00,NULL,NULL,1,'2023-01-19 19:48:49','2023-01-19 19:48:49',NULL),(2222,7561,40853,9137,2,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',1000.00,NULL,NULL,1,'2023-01-19 19:48:49','2023-01-19 19:48:49',NULL),(2223,7561,40853,9137,2,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',900.00,NULL,NULL,1,'2023-01-19 19:48:49','2023-01-19 19:48:49',NULL),(2224,7561,40853,9137,2,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',9000.00,NULL,NULL,1,'2023-01-19 19:48:49','2023-01-19 19:48:49',NULL),(2225,7561,40853,9137,2,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',1000.00,NULL,NULL,1,'2023-01-19 19:48:50','2023-01-19 19:48:50',NULL),(2226,7561,40853,9137,2,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',900.00,NULL,NULL,1,'2023-01-19 19:48:50','2023-01-19 19:48:50',NULL),(2227,7561,40853,9137,2,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',1000.00,NULL,NULL,1,'2023-01-19 19:48:50','2023-01-19 19:48:50',NULL),(2228,7561,40853,9137,2,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',1000.00,NULL,NULL,1,'2023-01-19 19:48:50','2023-01-19 19:48:50',NULL),(2229,7561,40853,9137,2,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',900.00,NULL,NULL,1,'2023-01-19 19:48:50','2023-01-19 19:48:50',NULL),(2230,7561,40853,9137,2,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',900.00,NULL,NULL,1,'2023-01-19 19:48:50','2023-01-19 19:48:50',NULL),(2231,7561,40725,3042,1,2231,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-01-31',NULL,349195.69,NULL,NULL,1,'2023-02-01 13:27:13','2023-02-01 13:52:58','2023-02-01 13:52:58'),(2232,7561,40727,1530,1,2232,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-01-31',NULL,919135.16,NULL,NULL,1,'2023-02-04 13:44:01','2023-02-04 13:44:01',NULL),(2233,7561,40727,1530,2,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',91718.00,NULL,NULL,1,'2023-02-16 20:28:27','2023-02-18 09:05:02','2023-02-18 09:05:02'),(2234,7561,40727,1530,2,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',122000.00,NULL,NULL,1,'2023-02-16 20:28:27','2023-02-18 09:05:55','2023-02-18 09:05:55'),(2235,7561,40727,1530,2,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',35000.00,NULL,NULL,1,'2023-02-16 20:28:27','2023-02-18 10:15:31','2023-02-18 10:15:31'),(2236,7561,40727,1530,2,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',76230.00,NULL,NULL,1,'2023-02-16 20:28:27','2023-02-18 10:16:22','2023-02-18 10:16:22');
INSERT INTO `balance_libro` VALUES (2237,7561,40727,1530,2,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',74000.00,NULL,NULL,1,'2023-02-16 20:28:27','2023-02-18 10:19:02','2023-02-18 10:19:02'),(2238,7561,40727,1530,2,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',50000.00,NULL,NULL,1,'2023-02-16 20:28:27','2023-02-18 10:20:22','2023-02-18 10:20:22'),(2239,7561,40727,1530,2,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',54450.00,NULL,NULL,1,'2023-02-16 20:28:27','2023-02-18 10:21:19','2023-02-18 10:21:19'),(2240,7561,40727,1530,2,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',80000.00,NULL,NULL,1,'2023-02-16 20:28:27','2023-02-18 10:22:08','2023-02-18 10:22:08'),(2241,7561,40727,1530,2,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',70000.00,NULL,NULL,1,'2023-02-16 20:28:27','2023-02-18 10:22:55','2023-02-18 10:22:55'),(2242,7561,40727,1530,2,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',95000.00,NULL,NULL,1,'2023-02-16 20:28:27','2023-02-18 10:23:45','2023-02-18 10:23:45'),(2243,7561,40727,1530,2,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',215985.00,NULL,NULL,1,'2023-02-16 20:28:27','2023-02-18 10:24:38','2023-02-18 10:24:38'),(2244,7561,40727,1530,2,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',370223.70,NULL,NULL,1,'2023-02-16 20:28:27','2023-02-18 10:25:17','2023-02-18 10:25:17'),(2245,7561,40727,1530,2,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',247000.00,NULL,NULL,1,'2023-02-16 20:28:27','2023-02-18 10:25:50','2023-02-18 10:25:50'),(2246,7561,40727,1530,2,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',24000.00,NULL,NULL,1,'2023-02-16 20:28:27','2023-02-18 10:26:15','2023-02-18 10:26:15'),(2247,7561,40727,1530,2,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',119000.00,NULL,NULL,1,'2023-02-16 20:28:28','2023-02-18 10:26:44','2023-02-18 10:26:44'),(2248,7561,40727,1530,2,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',9000.00,NULL,NULL,1,'2023-02-16 20:28:28','2023-02-18 10:27:32','2023-02-18 10:27:32'),(2249,7561,40727,1530,2,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',130680.00,NULL,NULL,1,'2023-02-16 20:28:28','2023-02-18 10:29:51','2023-02-18 10:29:51'),(2250,7561,40727,1530,2,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',130680.00,NULL,NULL,1,'2023-02-16 20:28:28','2023-02-18 10:28:33','2023-02-18 10:28:33'),(2251,7561,40727,1530,2,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',130680.00,NULL,NULL,1,'2023-02-16 20:28:28','2023-02-18 10:28:52','2023-02-18 10:28:52'),(2252,7561,40727,1530,2,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',72300.00,NULL,NULL,1,'2023-02-16 20:28:28','2023-02-18 10:30:14','2023-02-18 10:30:14'),(2253,7561,40727,1530,2,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',87120.00,NULL,NULL,1,'2023-02-16 20:28:28','2023-02-18 09:02:05','2023-02-18 09:02:05'),(2254,7561,40727,1530,3,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',6000.00,NULL,NULL,1,'2023-02-18 09:00:39','2023-02-18 09:00:39',NULL),(2255,7561,40727,1530,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',6134.94,NULL,NULL,1,'2023-02-18 09:00:39','2023-02-18 10:35:20','2023-02-18 10:35:20');
INSERT INTO `balance_libro` VALUES (2256,7561,40727,1530,3,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1499.53,NULL,NULL,1,'2023-02-18 09:00:39','2023-02-18 10:41:04','2023-02-18 10:41:04'),(2257,7561,40727,1530,3,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',12699.71,NULL,NULL,1,'2023-02-18 09:00:39','2023-02-18 10:39:29','2023-02-18 10:39:29'),(2258,7561,40727,1530,3,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',30085.44,NULL,NULL,1,'2023-02-18 09:00:39','2023-02-18 10:42:10','2023-02-18 10:42:10'),(2259,7561,40727,1530,3,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',26403.00,NULL,NULL,1,'2023-02-18 09:00:40','2023-02-18 10:43:10','2023-02-18 10:43:10'),(2260,7561,40727,1530,3,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',28500.00,NULL,NULL,1,'2023-02-18 09:00:40','2023-02-18 10:57:43','2023-02-18 10:57:43'),(2261,7561,40727,1530,3,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',62923.91,NULL,NULL,1,'2023-02-18 09:00:40','2023-02-18 13:18:58','2023-02-18 13:18:58'),(2262,7561,40727,1530,3,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3458.47,NULL,NULL,1,'2023-02-18 09:00:40','2023-03-11 10:15:21','2023-03-11 10:15:21'),(2263,7561,40727,1530,3,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',25397.90,NULL,NULL,1,'2023-02-18 09:00:40','2023-02-18 13:20:34','2023-02-18 13:20:34'),(2264,7561,40727,1530,3,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',16400.00,NULL,NULL,1,'2023-02-18 09:00:40','2023-02-18 13:22:09','2023-02-18 13:22:09'),(2265,7561,40727,1530,3,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',27720.13,NULL,NULL,1,'2023-02-18 09:00:40','2023-02-18 13:23:18','2023-02-18 13:23:18'),(2266,7561,40727,1530,3,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',29296.62,NULL,NULL,1,'2023-02-18 09:00:40','2023-02-18 13:24:05','2023-02-18 13:24:05'),(2267,7561,40727,1530,3,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',96620.92,NULL,NULL,1,'2023-02-18 09:00:40','2023-02-18 13:26:29','2023-02-18 13:26:29'),(2268,7561,40727,1530,3,2046,'App\\Models\\Receipt',2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',117982.29,NULL,NULL,1,'2023-02-18 09:00:40','2023-02-18 13:27:39','2023-02-18 13:27:39'),(2269,7561,40727,1530,3,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',66346.72,NULL,NULL,1,'2023-02-18 09:00:40','2023-02-18 13:28:12','2023-02-18 13:28:12'),(2270,7561,40727,1530,3,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3526.05,NULL,NULL,1,'2023-02-18 09:00:40','2023-02-18 13:28:47','2023-02-18 13:28:47'),(2271,7561,40727,1530,3,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',71814.71,NULL,NULL,1,'2023-02-18 09:00:40','2023-02-18 13:40:18','2023-02-18 13:40:18'),(2272,7561,40727,1530,3,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',9020.45,NULL,NULL,1,'2023-02-18 09:00:40','2023-02-18 13:38:35','2023-02-18 13:38:35'),(2273,7561,40727,1530,3,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',12874.20,NULL,NULL,1,'2023-02-18 09:00:40','2023-02-18 13:41:24','2023-02-18 13:41:24'),(2274,7561,40727,1530,3,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',15145.72,NULL,NULL,1,'2023-02-18 09:00:40','2023-02-18 13:42:05','2023-02-18 13:42:05');
INSERT INTO `balance_libro` VALUES (2275,7561,40727,1530,3,2053,'App\\Models\\Receipt',2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19006.68,NULL,NULL,1,'2023-02-18 09:00:40','2023-02-18 09:00:40',NULL),(2276,7561,40727,1530,3,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',28599.05,NULL,NULL,1,'2023-02-18 09:00:40','2023-02-18 13:42:47','2023-02-18 13:42:47'),(2277,7561,40727,1530,2,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',87120.00,NULL,NULL,1,'2023-02-18 09:02:05','2023-02-18 10:30:33','2023-02-18 10:30:33'),(2278,7561,40727,1526,16,542,'App\\Models\\PeriodLiquidation',NULL,542,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',4589.99,NULL,NULL,1,'2023-02-18 09:03:25','2023-02-18 09:03:25',NULL),(2279,7561,40727,1525,16,365,'App\\Models\\PeriodLiquidation',NULL,365,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',4520.27,NULL,NULL,1,'2023-02-18 09:03:48','2023-02-18 09:03:48',NULL),(2280,7561,40727,1530,2,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',91718.00,NULL,NULL,1,'2023-02-18 09:05:02','2023-02-18 09:05:02',NULL),(2281,7561,40727,1530,2,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',122000.00,NULL,NULL,1,'2023-02-18 09:05:55','2023-02-18 10:14:17','2023-02-18 10:14:17'),(2282,7561,40727,1530,2,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',122000.00,NULL,NULL,1,'2023-02-18 10:14:17','2023-02-18 10:14:17',NULL),(2283,7561,40727,1530,2,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',35000.00,NULL,NULL,1,'2023-02-18 10:15:31','2023-02-18 10:15:31',NULL),(2284,7561,40727,1530,2,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',76230.00,NULL,NULL,1,'2023-02-18 10:16:22','2023-02-18 10:16:22',NULL),(2285,7561,40727,1530,2,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',74000.02,NULL,NULL,1,'2023-02-18 10:19:02','2023-02-18 10:19:47','2023-02-18 10:19:47'),(2286,7561,40727,1530,2,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',74000.01,NULL,NULL,1,'2023-02-18 10:19:47','2023-02-18 10:20:48','2023-02-18 10:20:48'),(2287,7561,40727,1530,2,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',50000.00,NULL,NULL,1,'2023-02-18 10:20:22','2023-02-18 10:20:22',NULL),(2288,7561,40727,1530,2,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',74000.01,NULL,NULL,1,'2023-02-18 10:20:48','2023-02-18 10:20:48',NULL),(2289,7561,40727,1530,2,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',54450.00,NULL,NULL,1,'2023-02-18 10:21:19','2023-02-18 10:21:19',NULL),(2290,7561,40727,1530,2,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',80000.00,NULL,NULL,1,'2023-02-18 10:22:08','2023-02-18 10:22:08',NULL),(2291,7561,40727,1530,2,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',70000.00,NULL,NULL,1,'2023-02-18 10:22:55','2023-02-18 10:22:55',NULL),(2292,7561,40727,1530,2,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',95000.00,NULL,NULL,1,'2023-02-18 10:23:45','2023-02-18 10:24:09','2023-02-18 10:24:09'),(2293,7561,40727,1530,2,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',95000.00,NULL,NULL,1,'2023-02-18 10:24:09','2023-02-18 10:24:09',NULL),(2294,7561,40727,1530,2,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',215985.00,NULL,NULL,1,'2023-02-18 10:24:38','2023-02-18 10:24:38',NULL);
INSERT INTO `balance_libro` VALUES (2295,7561,40727,1530,2,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',370223.70,NULL,NULL,1,'2023-02-18 10:25:17','2023-02-18 10:25:17',NULL),(2296,7561,40727,1530,2,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',247000.00,NULL,NULL,1,'2023-02-18 10:25:50','2023-02-18 10:25:50',NULL),(2297,7561,40727,1530,2,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',24000.00,NULL,NULL,1,'2023-02-18 10:26:15','2023-02-18 10:26:15',NULL),(2298,7561,40727,1530,2,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',119000.00,NULL,NULL,1,'2023-02-18 10:26:44','2023-02-18 10:26:44',NULL),(2299,7561,40727,1530,2,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',9000.00,NULL,NULL,1,'2023-02-18 10:27:32','2023-02-18 10:27:32',NULL),(2300,7561,40727,1530,2,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',130680.00,NULL,NULL,1,'2023-02-18 10:28:33','2023-02-18 10:29:23','2023-02-18 10:29:23'),(2301,7561,40727,1530,2,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',130680.00,NULL,NULL,1,'2023-02-18 10:28:52','2023-02-18 10:28:52',NULL),(2302,7561,40727,1530,2,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',130680.00,NULL,NULL,1,'2023-02-18 10:29:23','2023-02-18 10:29:23',NULL),(2303,7561,40727,1530,2,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',130680.00,NULL,NULL,1,'2023-02-18 10:29:51','2023-02-18 10:29:51',NULL),(2304,7561,40727,1530,2,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',72300.00,NULL,NULL,1,'2023-02-18 10:30:14','2023-02-18 10:30:14',NULL),(2305,7561,40727,1530,2,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',87120.00,NULL,NULL,1,'2023-02-18 10:30:33','2023-02-18 10:30:33',NULL),(2306,7561,40727,1530,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',6134.45,NULL,NULL,1,'2023-02-18 10:35:20','2023-02-18 10:36:28','2023-02-18 10:36:28'),(2307,7561,40727,1530,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',6134.45,NULL,NULL,1,'2023-02-18 10:36:28','2023-02-18 10:37:53','2023-02-18 10:37:53'),(2308,7561,40727,1530,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',6134.94,NULL,NULL,1,'2023-02-18 10:37:53','2023-02-18 10:37:53',NULL),(2309,7561,40727,1530,3,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',12699.71,NULL,NULL,1,'2023-02-18 10:39:29','2023-02-23 06:51:01','2023-02-23 06:51:01'),(2310,7561,40727,1530,3,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1499.53,NULL,NULL,1,'2023-02-18 10:41:04','2023-02-18 10:41:04',NULL),(2311,7561,40727,1530,3,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',30085.44,NULL,NULL,1,'2023-02-18 10:42:10','2023-02-18 10:42:10',NULL),(2312,7561,40727,1530,3,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',26403.00,NULL,NULL,1,'2023-02-18 10:43:10','2023-02-18 10:43:10',NULL),(2313,7561,40727,1530,3,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3813.33,NULL,NULL,1,'2023-02-18 10:55:27','2023-02-18 10:55:27',NULL),(2314,7561,40727,1530,3,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',28500.00,NULL,NULL,1,'2023-02-18 10:57:43','2023-02-18 13:17:43','2023-02-18 13:17:43');
INSERT INTO `balance_libro` VALUES (2315,7561,40727,1530,3,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',28500.00,NULL,NULL,1,'2023-02-18 13:17:43','2023-02-18 13:17:43',NULL),(2316,7561,40727,1530,3,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',62923.91,NULL,NULL,1,'2023-02-18 13:18:58','2023-02-18 13:18:58',NULL),(2317,7561,40727,1530,3,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',25397.90,NULL,NULL,1,'2023-02-18 13:20:34','2023-02-18 13:20:48','2023-02-18 13:20:48'),(2318,7561,40727,1530,3,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',25397.90,NULL,NULL,1,'2023-02-18 13:20:48','2023-02-18 13:20:48',NULL),(2319,7561,40727,1530,3,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',16400.01,NULL,NULL,1,'2023-02-18 13:22:09','2023-02-18 13:22:09',NULL),(2320,7561,40727,1530,3,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',27720.13,NULL,NULL,1,'2023-02-18 13:23:18','2023-02-18 13:23:18',NULL),(2321,7561,40727,1530,3,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',29296.62,NULL,NULL,1,'2023-02-18 13:24:05','2023-02-18 13:24:05',NULL),(2322,7561,40727,1530,3,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',96620.92,NULL,NULL,1,'2023-02-18 13:26:29','2023-02-18 13:26:29',NULL),(2323,7561,40727,1530,3,2046,'App\\Models\\Receipt',2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',117982.29,NULL,NULL,1,'2023-02-18 13:27:39','2023-02-18 13:27:39',NULL),(2324,7561,40727,1530,3,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',66346.72,NULL,NULL,1,'2023-02-18 13:28:12','2023-02-18 13:28:12',NULL),(2325,7561,40727,1530,3,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3526.05,NULL,NULL,1,'2023-02-18 13:28:47','2023-02-18 13:28:47',NULL),(2326,7561,40727,1530,3,2056,'App\\Models\\Receipt',2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',3000.10,NULL,NULL,1,'2023-02-18 13:32:53','2023-02-18 13:32:53',NULL),(2327,7561,40727,1530,3,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',9020.45,NULL,NULL,1,'2023-02-18 13:38:35','2023-02-18 13:38:35',NULL),(2328,7561,40727,1530,3,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',71814.71,NULL,NULL,1,'2023-02-18 13:40:18','2023-02-18 13:40:18',NULL),(2329,7561,40727,1530,3,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',12874.20,NULL,NULL,1,'2023-02-18 13:41:24','2023-02-18 13:41:24',NULL),(2330,7561,40727,1530,3,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',15145.72,NULL,NULL,1,'2023-02-18 13:42:05','2023-02-18 13:42:05',NULL),(2331,7561,40727,1530,3,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',28599.05,NULL,NULL,1,'2023-02-18 13:42:47','2023-02-18 13:42:47',NULL),(2332,7561,40727,1530,16,756,'App\\Models\\PeriodLiquidation',NULL,756,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3781.77,NULL,NULL,1,'2023-02-18 13:54:40','2023-02-18 14:00:02','2023-02-18 14:00:02'),(2333,7561,40725,3042,3,2057,'App\\Models\\Receipt',2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',95220.55,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-19 12:18:10','2023-02-19 12:18:10'),(2334,7561,40725,3042,3,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3695.36,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-19 17:43:18','2023-02-19 17:43:18');
INSERT INTO `balance_libro` VALUES (2335,7561,40725,3042,3,2059,'App\\Models\\Receipt',2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1190.00,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-20 09:48:34','2023-02-20 09:48:34'),(2336,7561,40725,3042,3,2060,'App\\Models\\Receipt',2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',4339.19,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-18 14:23:02',NULL),(2337,7561,40725,3042,3,2061,'App\\Models\\Receipt',2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',637.17,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-18 14:23:02',NULL),(2338,7561,40725,3042,3,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1788.27,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-18 14:23:02',NULL),(2339,7561,40725,3042,3,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',4339.18,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-19 17:50:50','2023-02-19 17:50:50'),(2340,7561,40725,3042,3,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',53255.37,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-19 17:33:23','2023-02-19 17:33:23'),(2341,7561,40725,3042,3,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',936.30,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-19 17:15:03','2023-02-19 17:15:03'),(2342,7561,40725,3042,3,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5000.00,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-18 14:23:02',NULL),(2343,7561,40725,3042,3,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',142040.45,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-19 17:37:51','2023-02-19 17:37:51'),(2344,7561,40725,3042,3,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',63513.60,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-19 14:02:26','2023-02-19 14:02:26'),(2345,7561,40725,3042,3,2069,'App\\Models\\Receipt',2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1177.60,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-19 18:41:48','2023-02-19 18:41:48'),(2346,7561,40725,3042,3,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',212.39,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-18 14:23:02',NULL),(2347,7561,40725,3042,3,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',61865.65,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-19 17:36:42','2023-02-19 17:36:42'),(2348,7561,40725,3042,3,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',136.00,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-18 14:23:02',NULL),(2349,7561,40725,3042,3,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',6666.00,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-19 18:41:28','2023-02-19 18:41:28'),(2350,7561,40725,3042,3,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',7800.00,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-19 17:53:33','2023-02-19 17:53:33'),(2351,7561,40725,3042,3,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',12255.26,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-20 09:44:40','2023-02-20 09:44:40'),(2352,7561,40725,3042,3,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',235704.37,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-19 17:49:13','2023-02-19 17:49:13'),(2353,7561,40725,3042,3,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',147732.53,NULL,NULL,1,'2023-02-18 14:23:02','2023-02-19 17:45:22','2023-02-19 17:45:22'),(2354,7561,40725,3042,3,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',25103.19,NULL,NULL,1,'2023-02-18 14:23:03','2023-02-18 14:23:03',NULL);
INSERT INTO `balance_libro` VALUES (2355,7561,40725,3042,3,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',25103.19,NULL,NULL,1,'2023-02-18 14:23:03','2023-02-19 17:39:04','2023-02-19 17:39:04'),(2356,7561,40725,3042,3,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',22652.29,NULL,NULL,1,'2023-02-18 14:23:03','2023-02-19 17:35:13','2023-02-19 17:35:13'),(2357,7561,40725,3042,3,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',90.00,NULL,NULL,1,'2023-02-18 14:23:03','2023-02-19 17:47:51','2023-02-19 17:47:51'),(2358,7561,40725,3042,3,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',324996.32,NULL,NULL,1,'2023-02-18 14:23:03','2023-02-18 14:23:03',NULL),(2359,7561,40725,3042,3,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',10276.84,NULL,NULL,1,'2023-02-18 14:23:03','2023-02-19 12:57:51','2023-02-19 12:57:51'),(2360,7561,40725,3042,3,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',972114.00,NULL,NULL,1,'2023-02-18 14:23:03','2023-02-19 17:16:54','2023-02-19 17:16:54'),(2361,7561,40725,3042,3,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',6000.00,NULL,NULL,1,'2023-02-18 14:23:03','2023-02-18 14:23:03',NULL),(2362,7561,40725,3042,3,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',55000.00,NULL,NULL,1,'2023-02-18 14:23:03','2023-02-18 14:23:03',NULL),(2363,7561,40725,3042,3,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',24999.99,NULL,NULL,1,'2023-02-18 14:23:03','2023-02-19 13:14:50','2023-02-19 13:14:50'),(2364,7561,40725,3042,3,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',41000.00,NULL,NULL,1,'2023-02-18 14:23:03','2023-02-19 14:04:09','2023-02-19 14:04:09'),(2365,7561,40725,3042,3,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',58639.02,NULL,NULL,1,'2023-02-18 14:23:03','2023-02-19 17:52:29','2023-02-19 17:52:29'),(2366,7561,40725,3042,3,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4000.00,NULL,NULL,1,'2023-02-19 12:47:13','2023-02-19 13:11:48','2023-02-19 13:11:48'),(2367,7561,40725,3042,3,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1177.60,NULL,NULL,1,'2023-02-19 12:53:16','2023-02-19 12:54:07','2023-02-19 12:54:07'),(2368,7561,40725,3042,3,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1177.60,NULL,NULL,1,'2023-02-19 12:54:07','2023-02-19 12:54:58','2023-02-19 12:54:58'),(2369,7561,40725,3042,3,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1177.60,NULL,NULL,1,'2023-02-19 12:54:58','2023-02-19 12:54:58',NULL),(2370,7561,40725,3042,3,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',10276.84,NULL,NULL,1,'2023-02-19 12:57:51','2023-02-19 12:57:51',NULL),(2371,7561,40725,3042,3,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',38698.99,NULL,NULL,1,'2023-02-19 13:05:44','2023-02-19 13:05:44',NULL),(2372,7561,40725,3042,3,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4000.00,NULL,NULL,1,'2023-02-19 13:11:48','2023-02-19 13:11:48',NULL),(2373,7561,40725,3042,3,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',24999.99,NULL,NULL,1,'2023-02-19 13:14:50','2023-02-19 13:14:50',NULL),(2374,7561,40725,3042,3,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3999.97,NULL,NULL,1,'2023-02-19 13:20:37','2023-02-19 13:20:37',NULL);
INSERT INTO `balance_libro` VALUES (2375,7561,40725,3042,3,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3999.97,NULL,NULL,1,'2023-02-19 13:21:28','2023-02-19 13:58:09','2023-02-19 13:58:09'),(2376,7561,40725,3042,3,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3792.86,NULL,NULL,1,'2023-02-19 13:29:06','2023-02-19 13:29:06',NULL),(2377,7561,40725,3042,3,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4000.00,NULL,NULL,1,'2023-02-19 13:33:21','2023-02-20 11:03:55','2023-02-20 11:03:55'),(2378,7561,40725,3042,3,2097,'App\\Models\\Receipt',2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4089.96,NULL,NULL,1,'2023-02-19 13:52:38','2023-02-19 13:52:38',NULL),(2379,7561,40725,3042,3,2098,'App\\Models\\Receipt',2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',3999.97,NULL,NULL,1,'2023-02-19 13:55:49','2023-02-19 13:55:49',NULL),(2380,7561,40725,3042,3,2099,'App\\Models\\Receipt',2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3999.97,NULL,NULL,1,'2023-02-19 13:56:58','2023-02-19 13:56:58',NULL),(2381,7561,40725,3042,3,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3999.97,NULL,NULL,1,'2023-02-19 13:58:09','2023-02-19 13:58:09',NULL),(2382,7561,40725,3042,3,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',63513.60,NULL,NULL,1,'2023-02-19 14:02:26','2023-02-19 17:13:23','2023-02-19 17:13:23'),(2383,7561,40725,3042,3,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',41000.00,NULL,NULL,1,'2023-02-19 14:04:09','2023-02-19 14:04:09',NULL),(2384,7561,40725,3042,3,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',63513.60,NULL,NULL,1,'2023-02-19 17:13:23','2023-02-19 17:13:23',NULL),(2385,7561,40725,3042,3,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',936.30,NULL,NULL,1,'2023-02-19 17:15:03','2023-02-19 17:15:03',NULL),(2386,7561,40725,3042,3,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',972114.00,NULL,NULL,1,'2023-02-19 17:16:54','2023-02-19 17:16:54',NULL),(2387,7561,40725,3042,3,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',5601.46,NULL,NULL,1,'2023-02-19 17:30:41','2023-02-19 17:30:41',NULL),(2388,7561,40725,3042,3,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',53255.37,NULL,NULL,1,'2023-02-19 17:33:23','2023-02-19 17:33:23',NULL),(2389,7561,40725,3042,3,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',22652.29,NULL,NULL,1,'2023-02-19 17:35:13','2023-02-19 17:35:13',NULL),(2390,7561,40725,3042,3,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',61865.65,NULL,NULL,1,'2023-02-19 17:36:42','2023-02-19 17:36:42',NULL),(2391,7561,40725,3042,3,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',142040.45,NULL,NULL,1,'2023-02-19 17:37:51','2023-02-19 17:37:51',NULL),(2392,7561,40725,3042,3,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',25103.19,NULL,NULL,1,'2023-02-19 17:39:04','2023-02-19 17:39:04',NULL),(2393,7561,40725,3042,3,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3607.65,NULL,NULL,1,'2023-02-19 17:43:18','2023-02-19 17:43:18',NULL),(2394,7561,40725,3042,3,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',147732.53,NULL,NULL,1,'2023-02-19 17:45:22','2023-02-19 17:47:06','2023-02-19 17:47:06');
INSERT INTO `balance_libro` VALUES (2395,7561,40725,3042,3,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',147732.53,NULL,NULL,1,'2023-02-19 17:47:06','2023-02-19 17:47:06',NULL),(2396,7561,40725,3042,3,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',235704.37,NULL,NULL,1,'2023-02-19 17:49:13','2023-02-19 17:49:13',NULL),(2397,7561,40725,3042,3,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',4339.18,NULL,NULL,1,'2023-02-19 17:50:50','2023-02-19 17:50:50',NULL),(2398,7561,40725,3042,3,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',58639.02,NULL,NULL,1,'2023-02-19 17:52:29','2023-02-19 17:52:29',NULL),(2399,7561,40725,3042,3,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',7800.00,NULL,NULL,1,'2023-02-19 17:53:33','2023-02-19 17:53:33',NULL),(2400,7561,40725,3042,7,2101,'App\\Models\\Receipt',2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',6395.78,NULL,NULL,1,'2023-02-19 17:59:35','2023-02-19 17:59:35',NULL),(2401,7561,40725,3042,2,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',68624.36,NULL,NULL,1,'2023-02-19 18:17:01','2023-02-19 18:35:05','2023-02-19 18:35:05'),(2402,7561,40725,3042,2,2103,'App\\Models\\Receipt',2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',101978.80,NULL,NULL,1,'2023-02-19 18:17:01','2023-02-19 18:17:01',NULL),(2403,7561,40725,3042,2,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',72261.20,NULL,NULL,1,'2023-02-19 18:17:01','2023-02-19 18:34:45','2023-02-19 18:34:45'),(2404,7561,40725,3042,2,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',37258.32,NULL,NULL,1,'2023-02-19 18:17:01','2023-02-19 18:34:15','2023-02-19 18:34:15'),(2405,7561,40725,3042,2,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',72261.20,NULL,NULL,1,'2023-02-19 18:17:01','2023-02-19 18:31:02','2023-02-19 18:31:02'),(2406,7561,40725,3042,2,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',108391.80,NULL,NULL,1,'2023-02-19 18:17:01','2023-02-19 18:30:33','2023-02-19 18:30:33'),(2407,7561,40725,3042,2,2108,'App\\Models\\Receipt',2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',33804.25,NULL,NULL,1,'2023-02-19 18:17:01','2023-02-19 18:17:01',NULL),(2408,7561,40725,3042,2,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',107587.15,NULL,NULL,1,'2023-02-19 18:17:01','2023-03-16 19:49:47','2023-03-16 19:49:47'),(2409,7561,40725,3042,2,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',13317.26,NULL,NULL,1,'2023-02-19 18:17:01','2023-03-16 19:50:05','2023-03-16 19:50:05'),(2410,7561,40725,3042,2,2111,'App\\Models\\Receipt',2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',62020.19,NULL,NULL,1,'2023-02-19 18:17:01','2023-02-19 18:17:01',NULL),(2411,7561,40725,3042,2,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',65852.38,NULL,NULL,1,'2023-02-19 18:17:01','2023-02-19 18:31:46','2023-02-19 18:31:46'),(2412,7561,40725,3042,2,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',59933.84,NULL,NULL,1,'2023-02-19 18:17:01','2023-02-19 18:29:55','2023-02-19 18:29:55'),(2413,7561,40725,3042,2,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',111629.76,NULL,NULL,1,'2023-02-19 18:17:01','2023-02-19 18:32:28','2023-02-19 18:32:28'),(2414,7561,40725,3042,2,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',37805.24,NULL,NULL,1,'2023-02-19 18:17:01','2023-02-19 18:22:38','2023-02-19 18:22:38');
INSERT INTO `balance_libro` VALUES (2415,7561,40725,3042,2,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',135217.50,NULL,NULL,1,'2023-02-19 18:17:01','2023-02-19 18:27:35','2023-02-19 18:27:35'),(2416,7561,40725,3042,2,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',209789.80,NULL,NULL,1,'2023-02-19 18:17:01','2023-02-19 18:27:16','2023-02-19 18:27:16'),(2417,7561,40725,3042,2,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',57160.70,NULL,NULL,1,'2023-02-19 18:17:01','2023-02-19 18:26:49','2023-02-19 18:26:49'),(2418,7561,40725,3042,2,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',294654.15,NULL,NULL,1,'2023-02-19 18:17:01','2023-02-19 18:26:31','2023-02-19 18:26:31'),(2419,7561,40725,3042,2,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1737559.69,NULL,NULL,1,'2023-02-19 18:17:01','2023-02-19 18:26:03','2023-02-19 18:26:03'),(2420,7561,40725,3042,2,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',196053.87,NULL,NULL,1,'2023-02-19 18:17:01','2023-02-19 18:25:40','2023-02-19 18:25:40'),(2421,7561,40725,3042,2,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19616.52,NULL,NULL,1,'2023-02-19 18:17:01','2023-02-19 18:25:00','2023-02-19 18:25:00'),(2422,7561,40725,3042,2,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',64263.10,NULL,NULL,1,'2023-02-19 18:17:02','2023-02-19 18:24:04','2023-02-19 18:24:04'),(2423,7561,40725,3042,2,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',82522.00,NULL,NULL,1,'2023-02-19 18:17:02','2023-02-19 18:23:24','2023-02-19 18:23:24'),(2424,7561,40725,3042,2,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7740.00,NULL,NULL,1,'2023-02-19 18:17:02','2023-02-19 18:21:43','2023-02-19 18:21:43'),(2425,7561,40725,3042,2,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7740.00,NULL,NULL,1,'2023-02-19 18:21:43','2023-02-20 12:04:41','2023-02-20 12:04:41'),(2426,7561,40725,3042,2,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',37805.24,NULL,NULL,1,'2023-02-19 18:22:38','2023-02-19 18:27:55','2023-02-19 18:27:55'),(2427,7561,40725,3042,2,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',82522.00,NULL,NULL,1,'2023-02-19 18:23:24','2023-03-16 19:34:57','2023-03-16 19:34:57'),(2428,7561,40725,3042,2,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',64263.10,NULL,NULL,1,'2023-02-19 18:24:04','2023-03-16 19:35:16','2023-03-16 19:35:16'),(2429,7561,40725,3042,2,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19616.52,NULL,NULL,1,'2023-02-19 18:25:00','2023-03-16 19:35:47','2023-03-16 19:35:47'),(2430,7561,40725,3042,2,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',196053.87,NULL,NULL,1,'2023-02-19 18:25:40','2023-02-19 18:25:40',NULL),(2431,7561,40725,3042,2,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1737559.69,NULL,NULL,1,'2023-02-19 18:26:03','2023-02-19 18:26:03',NULL),(2432,7561,40725,3042,2,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',294654.14,NULL,NULL,1,'2023-02-19 18:26:31','2023-02-20 12:05:31','2023-02-20 12:05:31'),(2433,7561,40725,3042,2,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',57160.69,NULL,NULL,1,'2023-02-19 18:26:49','2023-02-20 12:11:28','2023-02-20 12:11:28');
INSERT INTO `balance_libro` VALUES (2434,7561,40725,3042,2,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',209789.80,NULL,NULL,1,'2023-02-19 18:27:16','2023-02-19 18:27:16',NULL),(2435,7561,40725,3042,2,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',135217.50,NULL,NULL,1,'2023-02-19 18:27:35','2023-02-19 18:27:35',NULL),(2436,7561,40725,3042,2,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',37805.24,NULL,NULL,1,'2023-02-19 18:27:55','2023-02-19 18:27:55',NULL),(2437,7561,40725,3042,2,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',59933.84,NULL,NULL,1,'2023-02-19 18:29:55','2023-02-19 18:33:00','2023-02-19 18:33:00'),(2438,7561,40725,3042,2,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',108391.80,NULL,NULL,1,'2023-02-19 18:30:33','2023-02-19 18:30:33',NULL),(2439,7561,40725,3042,2,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',72261.20,NULL,NULL,1,'2023-02-19 18:31:02','2023-02-19 18:31:02',NULL),(2440,7561,40725,3038,2,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',37251.06,NULL,NULL,1,'2023-02-19 18:31:26','2023-02-19 18:31:26',NULL),(2441,7561,40725,3042,2,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',65852.37,NULL,NULL,1,'2023-02-19 18:31:46','2023-02-20 12:12:24','2023-02-20 12:12:24'),(2442,7561,40725,3042,2,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',111629.76,NULL,NULL,1,'2023-02-19 18:32:28','2023-03-16 19:50:31','2023-03-16 19:50:31'),(2443,7561,40725,3042,2,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',59933.84,NULL,NULL,1,'2023-02-19 18:33:00','2023-02-19 18:33:00',NULL),(2444,7561,40725,3042,2,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',37258.32,NULL,NULL,1,'2023-02-19 18:34:15','2023-02-19 18:34:15',NULL),(2445,7561,40725,3042,2,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',72261.20,NULL,NULL,1,'2023-02-19 18:34:45','2023-03-16 19:51:42','2023-03-16 19:51:42'),(2446,7561,40725,3042,2,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',68624.35,NULL,NULL,1,'2023-02-19 18:35:05','2023-02-19 18:35:05',NULL),(2447,7561,40725,3042,3,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4000.00,NULL,NULL,1,'2023-02-20 11:03:55','2023-02-20 11:03:55',NULL),(2448,7561,40725,3042,2,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7740.01,NULL,NULL,1,'2023-02-20 12:04:41','2023-03-16 19:34:29','2023-03-16 19:34:29'),(2449,7561,40725,3042,2,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',294654.15,NULL,NULL,1,'2023-02-20 12:05:31','2023-03-16 19:36:17','2023-03-16 19:36:17'),(2450,7561,40725,3042,2,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',57160.70,NULL,NULL,1,'2023-02-20 12:11:28','2023-03-16 19:36:44','2023-03-16 19:36:44'),(2451,7561,40725,3042,2,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',65852.37,NULL,NULL,1,'2023-02-20 12:12:24','2023-02-20 12:12:24',NULL),(2452,7561,40727,1530,3,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',12699.71,NULL,NULL,1,'2023-02-23 06:51:01','2023-02-23 06:51:01',NULL),(2453,7561,40725,3043,1,2453,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-02-28',NULL,588691.55,NULL,NULL,1,'2023-03-09 09:58:36','2023-03-20 09:36:28','2023-03-20 09:36:28');
INSERT INTO `balance_libro` VALUES (2454,7561,40857,18324,2,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',40476.00,NULL,NULL,1,'2023-03-10 16:33:00','2023-03-10 16:33:00',NULL),(2455,7561,40857,18324,2,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',49400.00,NULL,NULL,1,'2023-03-10 16:33:01','2023-03-10 16:33:01',NULL),(2456,7561,40857,18324,2,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',38000.00,NULL,NULL,1,'2023-03-10 16:33:01','2023-03-10 16:33:01',NULL),(2457,7561,40857,18325,2,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',40476.00,NULL,NULL,1,'2023-03-10 16:36:17','2023-03-10 16:36:17',NULL),(2458,7561,40857,18325,2,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',49400.00,NULL,NULL,1,'2023-03-10 16:36:17','2023-03-10 16:36:17',NULL),(2459,7561,40857,18325,2,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',38000.00,NULL,NULL,1,'2023-03-10 16:36:17','2023-03-10 16:36:17',NULL),(2460,7561,40857,18326,2,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',49400.00,NULL,NULL,1,'2023-03-10 16:37:21','2023-03-10 16:37:21',NULL),(2461,7561,40857,18326,2,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',38000.00,NULL,NULL,1,'2023-03-10 16:37:21','2023-03-10 16:37:21',NULL),(2462,7561,40857,18326,2,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',40476.00,NULL,NULL,1,'2023-03-10 16:37:21','2023-03-10 16:37:21',NULL),(2463,7561,40719,18,2,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',250000.00,NULL,NULL,1,'2023-03-10 16:58:59','2023-03-10 16:58:59',NULL),(2464,7561,40719,18,2,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',6000.00,NULL,NULL,1,'2023-03-10 16:58:59','2023-03-10 16:58:59',NULL),(2465,7561,40719,18,2,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17500.00,NULL,NULL,1,'2023-03-10 16:58:59','2023-03-10 16:58:59',NULL),(2466,7561,40719,18,2,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17500.00,NULL,NULL,1,'2023-03-10 16:58:59','2023-03-10 16:58:59',NULL),(2467,7561,40719,18,2,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',41000.00,NULL,NULL,1,'2023-03-10 16:58:59','2023-03-10 16:58:59',NULL),(2468,7561,40719,18,2,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',12000.00,NULL,NULL,1,'2023-03-10 16:58:59','2023-03-10 16:58:59',NULL),(2469,7561,40719,18,2,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',8000.00,NULL,NULL,1,'2023-03-10 16:58:59','2023-03-10 16:58:59',NULL),(2470,7561,40719,19,2,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',250000.00,NULL,NULL,1,'2023-03-10 16:59:40','2023-03-10 16:59:40',NULL),(2471,7561,40719,19,2,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',6000.00,NULL,NULL,1,'2023-03-10 16:59:40','2023-03-10 16:59:40',NULL),(2472,7561,40719,19,2,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',17500.00,NULL,NULL,1,'2023-03-10 16:59:41','2023-03-10 16:59:41',NULL),(2473,7561,40719,19,2,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',17500.00,NULL,NULL,1,'2023-03-10 16:59:41','2023-03-10 16:59:41',NULL),(2474,7561,40719,19,2,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',41000.00,NULL,NULL,1,'2023-03-10 16:59:41','2023-03-10 16:59:41',NULL);
INSERT INTO `balance_libro` VALUES (2475,7561,40719,19,2,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',20000.00,NULL,NULL,1,'2023-03-10 16:59:41','2023-03-10 16:59:41',NULL),(2476,7561,40855,12204,2,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',42575.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2477,7561,40855,12204,2,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',50375.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2478,7561,40855,12204,2,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',7085.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2479,7561,40855,12204,2,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',15470.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2480,7561,40855,12204,2,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',14530.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2481,7561,40855,12204,2,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',37558.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2482,7561,40855,12204,2,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',12000.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2483,7561,40855,12204,2,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',89180.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2484,7561,40855,12204,2,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',39875.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2485,7561,40855,12204,2,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',88400.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2486,7561,40855,12204,2,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',7600.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2487,7561,40855,12204,2,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',99905.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2488,7561,40855,12204,2,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',103805.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2489,7561,40855,12204,2,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',168877.50,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2490,7561,40855,12204,2,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',113575.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2491,7561,40855,12204,2,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',102547.50,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2492,7561,40855,12204,2,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',64380.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2493,7561,40855,12204,2,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',14600.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2494,7561,40855,12204,2,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',16000.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2495,7561,40855,12204,2,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4400.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL);
INSERT INTO `balance_libro` VALUES (2496,7561,40855,12204,2,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',108390.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2497,7561,40855,12204,2,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',89718.00,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2498,7561,40855,12204,2,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',18579.60,NULL,NULL,1,'2023-03-10 17:07:20','2023-03-10 17:07:20',NULL),(2505,7561,40850,4554,2,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2500.00,NULL,NULL,1,'2023-03-10 18:15:12','2023-03-10 18:15:12',NULL),(2506,7561,40850,4554,2,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2500.00,NULL,NULL,1,'2023-03-10 18:15:12','2023-03-10 18:15:12',NULL),(2507,7561,40850,4554,2,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2500.00,NULL,NULL,1,'2023-03-10 18:15:12','2023-03-10 18:15:12',NULL),(2508,7561,40850,4554,2,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2500.00,NULL,NULL,1,'2023-03-10 18:15:12','2023-03-10 18:15:12',NULL),(2509,7561,40850,4554,2,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2500.00,NULL,NULL,1,'2023-03-10 18:15:12','2023-03-10 18:15:12',NULL),(2510,7561,40850,4554,2,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2500.00,NULL,NULL,1,'2023-03-10 18:15:12','2023-03-10 18:15:12',NULL),(2511,7561,40850,4554,2,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2500.00,NULL,NULL,1,'2023-03-10 18:15:12','2023-03-10 18:15:12',NULL),(2512,7561,40850,4554,2,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2513,7561,40850,4554,2,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2514,7561,40850,4554,2,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2515,7561,40850,4554,2,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2516,7561,40850,4554,2,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2517,7561,40850,4554,2,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2518,7561,40850,4554,2,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2519,7561,40850,4554,2,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2520,7561,40850,4554,2,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2521,7561,40850,4554,2,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2522,7561,40850,4554,2,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL);
INSERT INTO `balance_libro` VALUES (2523,7561,40850,4554,2,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2524,7561,40850,4554,2,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2525,7561,40850,4554,2,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2526,7561,40850,4554,2,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2527,7561,40850,4554,2,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2528,7561,40850,4554,2,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2529,7561,40850,4554,2,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2530,7561,40850,4554,2,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2531,7561,40850,4554,2,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2532,7561,40850,4554,2,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2533,7561,40850,4554,2,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2534,7561,40850,4554,2,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2535,7561,40850,4554,2,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2536,7561,40850,4554,2,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2537,7561,40850,4554,2,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2500.00,NULL,NULL,1,'2023-03-10 18:15:13','2023-03-10 18:15:13',NULL),(2538,7561,40850,4554,2,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2500.00,NULL,NULL,1,'2023-03-10 18:15:14','2023-03-10 18:15:14',NULL),(2539,7561,40850,4554,2,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2500.00,NULL,NULL,1,'2023-03-10 18:15:14','2023-03-10 18:15:14',NULL),(2540,7561,40850,4554,2,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2500.00,NULL,NULL,1,'2023-03-10 18:15:14','2023-03-10 18:15:14',NULL),(2541,7561,40850,4554,2,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2500.00,NULL,NULL,1,'2023-03-10 18:15:14','2023-03-10 18:15:14',NULL),(2542,7561,40850,4554,2,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2500.00,NULL,NULL,1,'2023-03-10 18:15:14','2023-03-10 18:15:14',NULL),(2543,7561,40850,4554,2,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2500.00,NULL,NULL,1,'2023-03-10 18:15:14','2023-03-10 18:15:14',NULL);
INSERT INTO `balance_libro` VALUES (2544,7561,40850,4554,2,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2500.00,NULL,NULL,1,'2023-03-10 18:15:14','2023-03-10 18:15:14',NULL),(2545,7561,40850,4555,2,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2546,7561,40850,4555,2,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2547,7561,40850,4555,2,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2548,7561,40850,4555,2,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2549,7561,40850,4555,2,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2550,7561,40850,4555,2,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2551,7561,40850,4555,2,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2552,7561,40850,4555,2,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2553,7561,40850,4555,2,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2554,7561,40850,4555,2,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2555,7561,40850,4555,2,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2556,7561,40850,4555,2,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2557,7561,40850,4555,2,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2558,7561,40850,4555,2,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2559,7561,40850,4555,2,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2560,7561,40850,4555,2,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2561,7561,40850,4555,2,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2562,7561,40850,4555,2,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2563,7561,40850,4555,2,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2564,7561,40850,4555,2,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL);
INSERT INTO `balance_libro` VALUES (2565,7561,40850,4555,2,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2566,7561,40850,4555,2,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2567,7561,40850,4555,2,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',3000.00,NULL,NULL,1,'2023-03-10 18:16:17','2023-03-10 18:16:17',NULL),(2568,7561,40850,4555,2,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2569,7561,40850,4555,2,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2570,7561,40850,4555,2,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2571,7561,40850,4555,2,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2572,7561,40850,4555,2,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2573,7561,40850,4555,2,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2574,7561,40850,4555,2,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2575,7561,40850,4555,2,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2576,7561,40850,4555,2,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2577,7561,40850,4555,2,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2578,7561,40850,4555,2,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2579,7561,40850,4555,2,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2580,7561,40850,4555,2,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2581,7561,40850,4555,2,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2582,7561,40850,4555,2,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2583,7561,40850,4555,2,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2584,7561,40850,4555,2,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2585,7561,40850,4555,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL);
INSERT INTO `balance_libro` VALUES (2586,7561,40850,4555,2,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2587,7561,40850,4555,2,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2588,7561,40850,4555,2,2260,'App\\Models\\Receipt',2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2589,7561,40850,4555,2,2261,'App\\Models\\Receipt',2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2590,7561,40850,4555,2,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2591,7561,40850,4555,2,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2592,7561,40850,4555,2,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2593,7561,40850,4555,2,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3000.00,NULL,NULL,1,'2023-03-10 18:16:18','2023-03-10 18:16:18',NULL),(2594,7561,40851,6084,2,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2595,7561,40851,6084,2,2267,'App\\Models\\Receipt',2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2596,7561,40851,6084,2,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2597,7561,40851,6084,2,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2598,7561,40851,6084,2,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2599,7561,40851,6084,2,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2600,7561,40851,6084,2,2272,'App\\Models\\Receipt',2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2601,7561,40851,6084,2,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2602,7561,40851,6084,2,2274,'App\\Models\\Receipt',2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2603,7561,40851,6084,2,2275,'App\\Models\\Receipt',2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2604,7561,40851,6084,2,2276,'App\\Models\\Receipt',2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2605,7561,40851,6084,2,2277,'App\\Models\\Receipt',2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2606,7561,40851,6084,2,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL);
INSERT INTO `balance_libro` VALUES (2607,7561,40851,6084,2,2279,'App\\Models\\Receipt',2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2608,7561,40851,6084,2,2280,'App\\Models\\Receipt',2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2609,7561,40851,6084,2,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2610,7561,40851,6084,2,2282,'App\\Models\\Receipt',2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2611,7561,40851,6084,2,2283,'App\\Models\\Receipt',2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2612,7561,40851,6084,2,2284,'App\\Models\\Receipt',2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2613,7561,40851,6084,2,2285,'App\\Models\\Receipt',2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2614,7561,40851,6084,2,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2615,7561,40851,6084,2,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2616,7561,40851,6084,2,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2617,7561,40851,6084,2,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2618,7561,40851,6084,2,2290,'App\\Models\\Receipt',2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2619,7561,40851,6084,2,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2620,7561,40851,6084,2,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2500.00,NULL,NULL,1,'2023-03-10 18:17:27','2023-03-10 18:17:27',NULL),(2621,7561,40851,6084,2,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2622,7561,40851,6084,2,2294,'App\\Models\\Receipt',2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2623,7561,40851,6084,2,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2624,7561,40851,6084,2,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2625,7561,40851,6084,2,2297,'App\\Models\\Receipt',2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2626,7561,40851,6084,2,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2627,7561,40851,6084,2,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL);
INSERT INTO `balance_libro` VALUES (2628,7561,40851,6084,2,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2629,7561,40851,6084,2,2301,'App\\Models\\Receipt',2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2630,7561,40851,6084,2,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2631,7561,40851,6084,2,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2632,7561,40851,6084,2,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2633,7561,40851,6084,2,2305,'App\\Models\\Receipt',2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2634,7561,40851,6084,2,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2635,7561,40851,6084,2,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2636,7561,40851,6084,2,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2637,7561,40851,6084,2,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2638,7561,40851,6084,2,2310,'App\\Models\\Receipt',2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2639,7561,40851,6084,2,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2640,7561,40851,6084,2,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2641,7561,40851,6084,2,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2642,7561,40851,6084,2,2314,'App\\Models\\Receipt',2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2643,7561,40851,6084,2,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2644,7561,40851,6084,2,2316,'App\\Models\\Receipt',2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2645,7561,40851,6084,2,2317,'App\\Models\\Receipt',2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2646,7561,40851,6084,2,2318,'App\\Models\\Receipt',2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2500.00,NULL,NULL,1,'2023-03-10 18:17:28','2023-03-10 18:17:28',NULL),(2647,7561,40851,6084,2,2319,'App\\Models\\Receipt',2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2500.00,NULL,NULL,1,'2023-03-10 18:17:29','2023-03-10 18:17:29',NULL),(2648,7561,40851,6084,2,2320,'App\\Models\\Receipt',2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2500.00,NULL,NULL,1,'2023-03-10 18:17:29','2023-03-10 18:17:29',NULL);
INSERT INTO `balance_libro` VALUES (2649,7561,40851,6084,2,2321,'App\\Models\\Receipt',2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2500.00,NULL,NULL,1,'2023-03-10 18:17:29','2023-03-10 18:17:29',NULL),(2650,7561,40851,6084,2,2322,'App\\Models\\Receipt',2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2500.00,NULL,NULL,1,'2023-03-10 18:17:29','2023-03-10 18:17:29',NULL),(2651,7561,40851,6085,2,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',3000.00,NULL,NULL,1,'2023-03-10 18:18:23','2023-03-10 18:18:23',NULL),(2652,7561,40851,6085,2,2324,'App\\Models\\Receipt',2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',3000.00,NULL,NULL,1,'2023-03-10 18:18:23','2023-03-10 18:18:23',NULL),(2653,7561,40851,6085,2,2325,'App\\Models\\Receipt',2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',3000.00,NULL,NULL,1,'2023-03-10 18:18:23','2023-03-10 18:18:23',NULL),(2654,7561,40851,6085,2,2326,'App\\Models\\Receipt',2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',3000.00,NULL,NULL,1,'2023-03-10 18:18:23','2023-03-10 18:18:23',NULL),(2655,7561,40851,6085,2,2327,'App\\Models\\Receipt',2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',3000.00,NULL,NULL,1,'2023-03-10 18:18:23','2023-03-10 18:18:23',NULL),(2656,7561,40851,6085,2,2328,'App\\Models\\Receipt',2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',3000.00,NULL,NULL,1,'2023-03-10 18:18:23','2023-03-10 18:18:23',NULL),(2657,7561,40851,6085,2,2329,'App\\Models\\Receipt',2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',3000.00,NULL,NULL,1,'2023-03-10 18:18:23','2023-03-10 18:18:23',NULL),(2658,7561,40851,6085,2,2330,'App\\Models\\Receipt',2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',3000.00,NULL,NULL,1,'2023-03-10 18:18:23','2023-03-10 18:18:23',NULL),(2659,7561,40851,6085,2,2331,'App\\Models\\Receipt',2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',3000.00,NULL,NULL,1,'2023-03-10 18:18:23','2023-03-10 18:18:23',NULL),(2660,7561,40851,6085,2,2332,'App\\Models\\Receipt',2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3000.00,NULL,NULL,1,'2023-03-10 18:18:23','2023-03-10 18:18:23',NULL),(2661,7561,40851,6085,2,2333,'App\\Models\\Receipt',2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3000.00,NULL,NULL,1,'2023-03-10 18:18:23','2023-03-10 18:18:23',NULL),(2662,7561,40851,6085,2,2334,'App\\Models\\Receipt',2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3000.00,NULL,NULL,1,'2023-03-10 18:18:23','2023-03-10 18:18:23',NULL),(2663,7561,40851,6085,2,2335,'App\\Models\\Receipt',2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',3000.00,NULL,NULL,1,'2023-03-10 18:18:23','2023-03-10 18:18:23',NULL),(2664,7561,40851,6085,2,2336,'App\\Models\\Receipt',2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',3000.00,NULL,NULL,1,'2023-03-10 18:18:23','2023-03-10 18:18:23',NULL),(2665,7561,40851,6085,2,2337,'App\\Models\\Receipt',2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',3000.00,NULL,NULL,1,'2023-03-10 18:18:23','2023-03-10 18:18:23',NULL),(2666,7561,40851,6085,2,2338,'App\\Models\\Receipt',2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3000.00,NULL,NULL,1,'2023-03-10 18:18:24','2023-03-10 18:18:24',NULL),(2667,7561,40851,6085,2,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3000.00,NULL,NULL,1,'2023-03-10 18:18:24','2023-03-10 18:18:24',NULL),(2668,7561,40851,6085,2,2340,'App\\Models\\Receipt',2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3000.00,NULL,NULL,1,'2023-03-10 18:18:24','2023-03-10 18:18:24',NULL),(2669,7561,40851,6085,2,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3000.00,NULL,NULL,1,'2023-03-10 18:18:24','2023-03-10 18:18:24',NULL);
INSERT INTO `balance_libro` VALUES (2670,7561,40851,6085,2,2342,'App\\Models\\Receipt',2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3000.00,NULL,NULL,1,'2023-03-10 18:18:24','2023-03-10 18:18:24',NULL),(2671,7561,40851,6085,2,2343,'App\\Models\\Receipt',2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3000.00,NULL,NULL,1,'2023-03-10 18:18:24','2023-03-10 18:18:24',NULL),(2672,7561,40857,18309,16,909,'App\\Models\\PeriodLiquidation',NULL,909,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',0.00,NULL,NULL,1,'2023-03-11 09:24:29','2023-04-21 16:35:01','2023-04-21 16:35:01'),(2673,7561,40857,18311,16,910,'App\\Models\\PeriodLiquidation',NULL,910,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',0.00,NULL,NULL,1,'2023-03-11 09:25:05','2023-04-21 16:35:24','2023-04-21 16:35:24'),(2674,7561,40857,18310,16,911,'App\\Models\\PeriodLiquidation',NULL,911,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',0.00,NULL,NULL,1,'2023-03-11 09:25:30','2023-04-21 16:35:18','2023-04-21 16:35:18'),(2675,7561,40857,18312,16,912,'App\\Models\\PeriodLiquidation',NULL,912,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',0.00,NULL,NULL,1,'2023-03-11 09:34:10','2023-04-21 16:39:14','2023-04-21 16:39:14'),(2676,7561,40857,18313,16,913,'App\\Models\\PeriodLiquidation',NULL,913,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',0.00,NULL,NULL,1,'2023-03-11 09:34:31','2023-04-21 16:39:20','2023-04-21 16:39:20'),(2677,7561,40857,18314,16,914,'App\\Models\\PeriodLiquidation',NULL,914,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',0.00,NULL,NULL,1,'2023-03-11 09:34:54','2023-04-21 16:39:27','2023-04-21 16:39:27'),(2678,7561,40857,18315,16,915,'App\\Models\\PeriodLiquidation',NULL,915,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1395.00,NULL,NULL,1,'2023-03-11 09:36:08','2023-04-21 16:39:33','2023-04-21 16:39:33'),(2679,7561,40857,18316,16,916,'App\\Models\\PeriodLiquidation',NULL,916,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1527.48,NULL,NULL,1,'2023-03-11 09:36:28','2023-03-11 09:36:28',NULL),(2680,7561,40857,18317,16,917,'App\\Models\\PeriodLiquidation',NULL,917,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1918.14,NULL,NULL,1,'2023-03-11 09:36:49','2023-03-11 09:36:49',NULL),(2681,7561,40857,18318,16,918,'App\\Models\\PeriodLiquidation',NULL,918,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1918.14,NULL,NULL,1,'2023-03-11 09:37:11','2023-03-11 09:37:11',NULL),(2682,7561,40857,18319,16,919,'App\\Models\\PeriodLiquidation',NULL,919,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1918.14,NULL,NULL,1,'2023-03-11 09:37:31','2023-03-11 09:37:31',NULL),(2683,7561,40857,18320,16,920,'App\\Models\\PeriodLiquidation',NULL,920,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1918.14,NULL,NULL,1,'2023-03-11 09:37:47','2023-03-11 09:37:47',NULL),(2684,7561,40857,18324,16,921,'App\\Models\\PeriodLiquidation',NULL,921,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1918.14,NULL,NULL,1,'2023-03-11 09:38:07','2023-03-11 09:38:07',NULL),(2685,7561,40857,18325,16,922,'App\\Models\\PeriodLiquidation',NULL,922,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1918.14,NULL,NULL,1,'2023-03-11 09:38:27','2023-03-11 09:38:27',NULL),(2686,7561,40725,3043,2,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',77149.60,NULL,NULL,1,'2023-03-11 09:54:52','2023-03-16 19:33:21','2023-03-16 19:33:21'),(2687,7561,40725,3043,2,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',88463.10,NULL,NULL,1,'2023-03-11 09:54:52','2023-03-16 19:32:59','2023-03-16 19:32:59'),(2688,7561,40725,3043,2,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',158473.70,NULL,NULL,1,'2023-03-11 09:54:52','2023-03-16 19:32:24','2023-03-16 19:32:24');
INSERT INTO `balance_libro` VALUES (2689,7561,40725,3043,2,2347,'App\\Models\\Receipt',2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',52574.50,NULL,NULL,1,'2023-03-11 09:54:52','2023-03-16 19:31:56','2023-03-16 19:31:56'),(2690,7561,40725,3043,2,2348,'App\\Models\\Receipt',2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2498276.24,NULL,NULL,1,'2023-03-11 09:54:52','2023-03-16 19:31:38','2023-03-16 19:31:38'),(2691,7561,40725,3043,2,2349,'App\\Models\\Receipt',2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',84627.40,NULL,NULL,1,'2023-03-11 09:54:52','2023-03-16 19:31:27','2023-03-16 19:31:27'),(2692,7561,40725,3043,2,2350,'App\\Models\\Receipt',2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',116281.00,NULL,NULL,1,'2023-03-11 09:54:52','2023-03-16 19:31:03','2023-03-16 19:31:03'),(2693,7561,40725,3043,2,2351,'App\\Models\\Receipt',2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2498428.10,NULL,NULL,1,'2023-03-11 09:54:52','2023-03-16 19:30:48','2023-03-16 19:30:48'),(2694,7561,40725,3043,2,2352,'App\\Models\\Receipt',2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2498276.24,NULL,NULL,1,'2023-03-11 09:54:52','2023-03-16 19:30:29','2023-03-16 19:30:29'),(2695,7561,40725,3043,2,2353,'App\\Models\\Receipt',2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',87906.50,NULL,NULL,1,'2023-03-11 09:54:52','2023-03-16 19:30:01','2023-03-16 19:30:01'),(2696,7561,40725,3043,2,2354,'App\\Models\\Receipt',2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',133898.60,NULL,NULL,1,'2023-03-11 09:54:52','2023-03-16 19:29:36','2023-03-16 19:29:36'),(2697,7561,40725,3043,2,2355,'App\\Models\\Receipt',2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',140005.41,NULL,NULL,1,'2023-03-11 09:54:52','2023-03-16 19:29:12','2023-03-16 19:29:12'),(2698,7561,40725,3043,2,2356,'App\\Models\\Receipt',2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',170186.50,NULL,NULL,1,'2023-03-11 09:54:52','2023-03-16 19:28:44','2023-03-16 19:28:44'),(2699,7561,40725,3043,2,2357,'App\\Models\\Receipt',2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',68246.42,NULL,NULL,1,'2023-03-11 09:54:52','2023-03-16 19:28:22','2023-03-16 19:28:22'),(2700,7561,40725,3043,2,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',25410.00,NULL,NULL,1,'2023-03-11 09:54:52','2023-03-16 19:27:58','2023-03-16 19:27:58'),(2701,7561,40725,3043,2,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',169684.50,NULL,NULL,1,'2023-03-11 09:54:52','2023-03-16 14:36:41','2023-03-16 14:36:41'),(2702,7561,40725,3043,2,2360,'App\\Models\\Receipt',2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',106963.27,NULL,NULL,1,'2023-03-11 09:54:52','2023-03-16 19:26:59','2023-03-16 19:26:59'),(2703,7561,40725,3043,2,2361,'App\\Models\\Receipt',2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',94583.28,NULL,NULL,1,'2023-03-11 09:54:52','2023-03-16 19:26:25','2023-03-16 19:26:25'),(2704,7561,40725,3043,2,2362,'App\\Models\\Receipt',2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',237627.06,NULL,NULL,1,'2023-03-11 09:54:53','2023-03-16 19:25:48','2023-03-16 19:25:48'),(2705,7561,40725,3043,3,2363,'App\\Models\\Receipt',2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',103038.16,NULL,NULL,1,'2023-03-11 09:56:01','2023-03-16 12:46:55','2023-03-16 12:46:55'),(2706,7561,40725,3043,3,2364,'App\\Models\\Receipt',2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1390.00,NULL,NULL,1,'2023-03-11 09:56:01','2023-03-16 12:52:35','2023-03-16 12:52:35'),(2707,7561,40725,3043,3,2365,'App\\Models\\Receipt',2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2443.99,NULL,NULL,1,'2023-03-11 09:56:01','2023-03-16 13:34:45','2023-03-16 13:34:45');
INSERT INTO `balance_libro` VALUES (2708,7561,40725,3043,3,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',330.00,NULL,NULL,1,'2023-03-11 09:56:01','2023-03-16 18:13:04','2023-03-16 18:13:04'),(2709,7561,40725,3043,3,2367,'App\\Models\\Receipt',2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',292.00,NULL,NULL,1,'2023-03-11 09:56:01','2023-03-11 09:56:01',NULL),(2710,7561,40725,3043,3,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1043625.00,NULL,NULL,1,'2023-03-11 09:56:01','2023-03-16 13:32:15','2023-03-16 13:32:15'),(2711,7561,40725,3043,3,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',925650.00,NULL,NULL,1,'2023-03-11 09:56:02','2023-03-16 13:30:56','2023-03-16 13:30:56'),(2712,7561,40725,3043,3,2370,'App\\Models\\Receipt',2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',90.00,NULL,NULL,1,'2023-03-11 09:56:02','2023-03-16 12:47:36','2023-03-16 12:47:36'),(2713,7561,40725,3043,3,2371,'App\\Models\\Receipt',2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',95.00,NULL,NULL,1,'2023-03-11 09:56:02','2023-03-11 09:56:02',NULL),(2714,7561,40725,3043,3,2372,'App\\Models\\Receipt',2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',68.00,NULL,NULL,1,'2023-03-11 09:56:02','2023-03-16 18:03:11','2023-03-16 18:03:11'),(2715,7561,40725,3043,3,2373,'App\\Models\\Receipt',2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',301.00,NULL,NULL,1,'2023-03-11 09:56:02','2023-03-16 18:11:46','2023-03-16 18:11:46'),(2716,7561,40725,3043,3,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',400.00,NULL,NULL,1,'2023-03-11 09:56:02','2023-03-16 18:10:11','2023-03-16 18:10:11'),(2717,7561,40725,3043,3,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1190.01,NULL,NULL,1,'2023-03-11 09:56:02','2023-03-16 13:21:36','2023-03-16 13:21:36'),(2718,7561,40725,3043,3,2376,'App\\Models\\Receipt',2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1081.74,NULL,NULL,1,'2023-03-11 09:56:02','2023-03-16 13:16:34','2023-03-16 13:16:34'),(2719,7561,40725,3043,3,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',62349.18,NULL,NULL,1,'2023-03-11 09:56:02','2023-03-16 13:16:49','2023-03-16 13:16:49'),(2720,7561,40725,3043,3,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',4050.28,NULL,NULL,1,'2023-03-11 09:56:02','2023-03-16 13:19:26','2023-03-16 13:19:26'),(2721,7561,40725,3043,3,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1098075.00,NULL,NULL,1,'2023-03-11 09:56:02','2023-03-16 13:33:02','2023-03-16 13:33:02'),(2722,7561,40725,3043,3,2380,'App\\Models\\Receipt',2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',800.00,NULL,NULL,1,'2023-03-11 09:56:02','2023-03-16 12:47:51','2023-03-16 12:47:51'),(2723,7561,40725,3043,3,2381,'App\\Models\\Receipt',2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',9489.59,NULL,NULL,1,'2023-03-11 09:56:02','2023-03-16 13:18:19','2023-03-16 13:18:19'),(2724,7561,40725,3043,3,2382,'App\\Models\\Receipt',2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',41000.00,NULL,NULL,1,'2023-03-11 09:56:02','2023-03-16 18:08:45','2023-03-16 18:08:45'),(2725,7561,40725,3043,3,2383,'App\\Models\\Receipt',2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',16706.98,NULL,NULL,1,'2023-03-11 09:56:02','2023-03-16 14:19:20','2023-03-16 14:19:20'),(2726,7561,40725,3043,3,2384,'App\\Models\\Receipt',2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',390075.44,NULL,NULL,1,'2023-03-11 09:56:02','2023-03-16 17:58:24','2023-03-16 17:58:24');
INSERT INTO `balance_libro` VALUES (2727,7561,40727,1531,2,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',20000.00,NULL,NULL,1,'2023-03-11 09:57:33','2023-03-11 10:01:29','2023-03-11 10:01:29'),(2728,7561,40727,1531,2,2386,'App\\Models\\Receipt',2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',9500.00,NULL,NULL,1,'2023-03-11 09:57:33','2023-03-11 10:02:17','2023-03-11 10:02:17'),(2729,7561,40727,1531,2,2387,'App\\Models\\Receipt',2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',55000.01,NULL,NULL,1,'2023-03-11 09:57:33','2023-03-11 10:02:56','2023-03-11 10:02:56'),(2730,7561,40727,1531,2,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',268620.00,NULL,NULL,1,'2023-03-11 09:57:33','2023-03-11 10:03:32','2023-03-11 10:03:32'),(2731,7561,40727,1531,3,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',6000.00,NULL,NULL,1,'2023-03-11 09:59:00','2023-03-11 10:07:15','2023-03-11 10:07:15'),(2732,7561,40727,1531,3,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',4049.23,NULL,NULL,1,'2023-03-11 09:59:00','2023-03-18 06:49:48','2023-03-18 06:49:48'),(2733,7561,40727,1531,2,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',20000.01,NULL,NULL,1,'2023-03-11 10:01:29','2023-03-11 10:01:29',NULL),(2734,7561,40727,1531,2,2386,'App\\Models\\Receipt',2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',9500.00,NULL,NULL,1,'2023-03-11 10:02:17','2023-03-11 10:02:17',NULL),(2735,7561,40727,1531,2,2387,'App\\Models\\Receipt',2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',55000.01,NULL,NULL,1,'2023-03-11 10:02:56','2023-03-11 10:02:56',NULL),(2736,7561,40727,1531,2,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',268620.00,NULL,NULL,1,'2023-03-11 10:03:32','2023-03-11 10:03:32',NULL),(2737,7561,40727,1531,3,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',6000.00,NULL,NULL,1,'2023-03-11 10:07:15','2023-03-18 06:50:04','2023-03-18 06:50:04'),(2738,7561,40727,1531,3,2391,'App\\Models\\Receipt',2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',4171.89,NULL,NULL,1,'2023-03-11 10:13:29','2023-03-11 10:13:29',NULL),(2739,7561,40727,1530,3,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3458.47,NULL,NULL,1,'2023-03-11 10:15:21','2023-03-11 10:15:21',NULL),(2740,7561,40725,3043,3,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',7610.12,NULL,NULL,1,'2023-03-16 12:59:58','2023-03-16 13:00:53','2023-03-16 13:00:53'),(2741,7561,40725,3043,3,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',7630.12,NULL,NULL,1,'2023-03-16 13:00:53','2023-03-16 13:01:04','2023-03-16 13:01:04'),(2742,7561,40725,3043,3,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',7630.12,NULL,NULL,1,'2023-03-16 13:01:04','2023-03-16 13:01:04',NULL),(2743,7561,40725,3043,3,2393,'App\\Models\\Receipt',2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',6762.26,NULL,NULL,1,'2023-03-16 13:12:14','2023-03-16 13:12:14',NULL),(2744,7561,40725,3043,3,2394,'App\\Models\\Receipt',2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',3999.97,NULL,NULL,1,'2023-03-16 13:15:03','2023-03-16 13:15:03',NULL),(2745,7561,40725,3043,3,2376,'App\\Models\\Receipt',2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1081.74,NULL,NULL,1,'2023-03-16 13:16:34','2023-03-16 13:16:34',NULL),(2746,7561,40725,3043,3,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',62349.18,NULL,NULL,1,'2023-03-16 13:16:49','2023-03-16 13:27:29','2023-03-16 13:27:29');
INSERT INTO `balance_libro` VALUES (2747,7561,40725,3043,3,2381,'App\\Models\\Receipt',2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',9489.59,NULL,NULL,1,'2023-03-16 13:18:19','2023-03-16 13:18:19',NULL),(2748,7561,40725,3043,3,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',4050.48,NULL,NULL,1,'2023-03-16 13:19:26','2023-03-16 13:19:50','2023-03-16 13:19:50'),(2749,7561,40725,3043,3,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',4050.28,NULL,NULL,1,'2023-03-16 13:19:50','2023-03-16 13:20:21','2023-03-16 13:20:21'),(2750,7561,40725,3043,3,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',4050.28,NULL,NULL,1,'2023-03-16 13:20:21','2023-03-16 13:24:00','2023-03-16 13:24:00'),(2751,7561,40725,3043,3,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1190.01,NULL,NULL,1,'2023-03-16 13:21:36','2023-03-16 13:21:36',NULL),(2752,7561,40725,3043,3,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',4050.28,NULL,NULL,1,'2023-03-16 13:24:00','2023-03-16 18:04:01','2023-03-16 18:04:01'),(2753,7561,40725,3043,3,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',62349.18,NULL,NULL,1,'2023-03-16 13:27:29','2023-03-16 18:10:40','2023-03-16 18:10:40'),(2754,7561,40725,3043,3,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',925650.00,NULL,NULL,1,'2023-03-16 13:30:56','2023-03-16 18:00:52','2023-03-16 18:00:52'),(2755,7561,40725,3043,3,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1043625.00,NULL,NULL,1,'2023-03-16 13:32:15','2023-03-16 18:01:18','2023-03-16 18:01:18'),(2756,7561,40725,3043,3,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1098075.00,NULL,NULL,1,'2023-03-16 13:33:02','2023-03-16 17:59:08','2023-03-16 17:59:08'),(2757,7561,40725,3043,3,2365,'App\\Models\\Receipt',2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2443.99,NULL,NULL,1,'2023-03-16 13:34:45','2023-03-16 13:34:45',NULL),(2758,7561,40725,3043,3,2395,'App\\Models\\Receipt',2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',5804.11,NULL,NULL,1,'2023-03-16 13:40:09','2023-03-16 13:40:09',NULL),(2759,7561,40725,3043,3,2383,'App\\Models\\Receipt',2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',16706.98,NULL,NULL,1,'2023-03-16 14:19:20','2023-03-16 14:19:20',NULL),(2760,7561,40725,3043,2,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',169684.50,NULL,NULL,1,'2023-03-16 14:36:41','2023-03-16 19:27:21','2023-03-16 19:27:21'),(2761,7561,40725,3043,3,2384,'App\\Models\\Receipt',2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',390075.44,NULL,NULL,1,'2023-03-16 17:58:24','2023-03-16 17:58:24',NULL),(2762,7561,40725,3043,3,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1098075.00,NULL,NULL,1,'2023-03-16 17:59:08','2023-03-16 18:02:04','2023-03-16 18:02:04'),(2763,7561,40725,3043,3,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',925650.00,NULL,NULL,1,'2023-03-16 18:00:52','2023-03-16 18:00:52',NULL),(2764,7561,40725,3043,3,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1043625.00,NULL,NULL,1,'2023-03-16 18:01:18','2023-03-16 18:01:18',NULL),(2765,7561,40725,3043,3,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1098075.00,NULL,NULL,1,'2023-03-16 18:02:04','2023-03-16 18:02:04',NULL),(2766,7561,40725,3043,3,2372,'App\\Models\\Receipt',2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',68.00,NULL,NULL,1,'2023-03-16 18:03:11','2023-03-16 18:03:11',NULL);
INSERT INTO `balance_libro` VALUES (2767,7561,40725,3043,3,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',4050.28,NULL,NULL,1,'2023-03-16 18:04:01','2023-03-16 18:04:01',NULL),(2768,7561,40725,3043,3,2382,'App\\Models\\Receipt',2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',41000.00,NULL,NULL,1,'2023-03-16 18:08:45','2023-03-16 18:08:45',NULL),(2769,7561,40725,3043,3,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',399.99,NULL,NULL,1,'2023-03-16 18:10:11','2023-03-16 18:10:11',NULL),(2770,7561,40725,3043,3,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',62349.18,NULL,NULL,1,'2023-03-16 18:10:40','2023-03-16 18:10:40',NULL),(2771,7561,40725,3043,3,2373,'App\\Models\\Receipt',2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',301.00,NULL,NULL,1,'2023-03-16 18:11:46','2023-03-16 18:11:46',NULL),(2772,7561,40725,3043,3,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',330.00,NULL,NULL,1,'2023-03-16 18:13:04','2023-03-16 18:13:32','2023-03-16 18:13:32'),(2773,7561,40725,3043,3,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',330.00,NULL,NULL,1,'2023-03-16 18:13:32','2023-03-16 18:13:32',NULL),(2774,7561,40725,3043,2,2362,'App\\Models\\Receipt',2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',237627.06,NULL,NULL,1,'2023-03-16 19:25:48','2023-03-16 19:25:48',NULL),(2775,7561,40725,3043,2,2361,'App\\Models\\Receipt',2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',94583.27,NULL,NULL,1,'2023-03-16 19:26:25','2023-03-16 19:26:25',NULL),(2776,7561,40725,3043,2,2360,'App\\Models\\Receipt',2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',106963.27,NULL,NULL,1,'2023-03-16 19:26:59','2023-03-16 19:26:59',NULL),(2777,7561,40725,3043,2,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',169684.50,NULL,NULL,1,'2023-03-16 19:27:21','2023-03-16 19:27:21',NULL),(2778,7561,40725,3043,2,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',25410.00,NULL,NULL,1,'2023-03-16 19:27:58','2023-03-16 19:50:57','2023-03-16 19:50:57'),(2779,7561,40725,3043,2,2357,'App\\Models\\Receipt',2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',68246.42,NULL,NULL,1,'2023-03-16 19:28:22','2023-03-16 19:28:22',NULL),(2780,7561,40725,3043,2,2356,'App\\Models\\Receipt',2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',170186.50,NULL,NULL,1,'2023-03-16 19:28:44','2023-03-16 19:28:44',NULL),(2781,7561,40725,3043,2,2355,'App\\Models\\Receipt',2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',140005.41,NULL,NULL,1,'2023-03-16 19:29:12','2023-03-16 19:29:12',NULL),(2782,7561,40725,3043,2,2354,'App\\Models\\Receipt',2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',133898.60,NULL,NULL,1,'2023-03-16 19:29:36','2023-03-16 19:29:36',NULL),(2783,7561,40725,3043,2,2353,'App\\Models\\Receipt',2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',87906.50,NULL,NULL,1,'2023-03-16 19:30:01','2023-03-16 19:30:01',NULL),(2784,7561,40725,3043,2,2352,'App\\Models\\Receipt',2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2498276.23,NULL,NULL,1,'2023-03-16 19:30:29','2023-03-16 19:30:29',NULL),(2785,7561,40725,3043,2,2351,'App\\Models\\Receipt',2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2498428.10,NULL,NULL,1,'2023-03-16 19:30:48','2023-03-16 19:30:48',NULL),(2786,7561,40725,3043,2,2350,'App\\Models\\Receipt',2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',116281.00,NULL,NULL,1,'2023-03-16 19:31:03','2023-03-16 19:31:03',NULL);
INSERT INTO `balance_libro` VALUES (2787,7561,40725,3043,2,2349,'App\\Models\\Receipt',2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',84627.40,NULL,NULL,1,'2023-03-16 19:31:27','2023-03-16 19:31:27',NULL),(2788,7561,40725,3043,2,2348,'App\\Models\\Receipt',2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2498276.23,NULL,NULL,1,'2023-03-16 19:31:38','2023-03-16 19:31:38',NULL),(2789,7561,40725,3043,2,2347,'App\\Models\\Receipt',2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',52574.50,NULL,NULL,1,'2023-03-16 19:31:56','2023-03-16 19:31:56',NULL),(2790,7561,40725,3043,2,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',158473.70,NULL,NULL,1,'2023-03-16 19:32:24','2023-03-16 19:32:24',NULL),(2791,7561,40725,3043,2,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',88463.10,NULL,NULL,1,'2023-03-16 19:32:59','2023-03-16 19:33:52','2023-03-16 19:33:52'),(2792,7561,40725,3043,2,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',77149.60,NULL,NULL,1,'2023-03-16 19:33:21','2023-03-16 19:33:21',NULL),(2793,7561,40725,3043,2,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',88463.10,NULL,NULL,1,'2023-03-16 19:33:52','2023-03-16 19:33:52',NULL),(2794,7561,40725,3042,2,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7740.01,NULL,NULL,1,'2023-03-16 19:34:29','2023-03-16 19:34:29',NULL),(2795,7561,40725,3042,2,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',82522.00,NULL,NULL,1,'2023-03-16 19:34:57','2023-03-16 19:34:57',NULL),(2796,7561,40725,3042,2,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',64263.10,NULL,NULL,1,'2023-03-16 19:35:16','2023-03-16 19:35:16',NULL),(2797,7561,40725,3042,2,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19616.52,NULL,NULL,1,'2023-03-16 19:35:47','2023-03-16 19:35:47',NULL),(2798,7561,40725,3042,2,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',294654.15,NULL,NULL,1,'2023-03-16 19:36:17','2023-03-16 19:36:17',NULL),(2799,7561,40725,3042,2,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',57160.70,NULL,NULL,1,'2023-03-16 19:36:44','2023-03-16 19:36:44',NULL),(2800,7561,40725,3042,2,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',107587.15,NULL,NULL,1,'2023-03-16 19:49:47','2023-03-16 19:49:47',NULL),(2801,7561,40725,3042,2,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',13317.26,NULL,NULL,1,'2023-03-16 19:50:05','2023-03-16 19:51:17','2023-03-16 19:51:17'),(2802,7561,40725,3042,2,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',111629.76,NULL,NULL,1,'2023-03-16 19:50:31','2023-03-16 19:50:31',NULL),(2803,7561,40725,3043,2,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',25410.00,NULL,NULL,1,'2023-03-16 19:50:57','2023-03-16 19:50:57',NULL),(2804,7561,40725,3042,2,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',13317.26,NULL,NULL,1,'2023-03-16 19:51:17','2023-03-16 19:51:17',NULL),(2805,7561,40725,3042,2,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',72261.20,NULL,NULL,1,'2023-03-16 19:51:42','2023-03-16 19:51:42',NULL),(2806,7561,40725,3038,2,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',120522.05,NULL,NULL,1,'2023-03-16 19:52:27','2023-03-16 19:52:48','2023-03-16 19:52:48');
INSERT INTO `balance_libro` VALUES (2807,7561,40725,3038,2,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',120522.05,NULL,NULL,1,'2023-03-16 19:52:48','2023-03-16 19:52:48',NULL),(2808,7561,40725,3043,7,2396,'App\\Models\\Receipt',2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4583.00,NULL,NULL,1,'2023-03-17 08:46:56','2023-03-17 08:46:56',NULL),(2809,7561,40725,3043,7,2397,'App\\Models\\Receipt',2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',6690.93,NULL,NULL,1,'2023-03-17 08:48:42','2023-03-17 08:48:42',NULL),(2810,7561,40725,3043,3,2398,'App\\Models\\Receipt',2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3701.10,NULL,NULL,1,'2023-03-17 08:51:31','2023-03-17 08:51:31',NULL),(2811,7561,40725,3042,16,1106,'App\\Models\\PeriodLiquidation',NULL,1106,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',11323.14,NULL,NULL,1,'2023-03-17 10:57:40','2023-03-17 11:14:56','2023-03-17 11:14:56'),(2812,7561,40725,3042,15,1105,'App\\Models\\PeriodLiquidation',NULL,1105,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',656450.67,NULL,NULL,1,'2023-03-17 11:14:17','2023-03-17 11:14:17',NULL),(2813,7561,40725,3043,15,1108,'App\\Models\\PeriodLiquidation',NULL,1108,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1181689.99,NULL,NULL,1,'2023-03-17 11:14:36','2023-03-17 11:14:36',NULL),(2814,7561,40725,3042,16,1106,'App\\Models\\PeriodLiquidation',NULL,1106,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',11323.14,NULL,NULL,1,'2023-03-17 11:31:35','2023-03-17 11:32:26','2023-03-17 11:32:26'),(2815,7561,40725,3042,16,1109,'App\\Models\\PeriodLiquidation',NULL,1109,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',10065.53,NULL,NULL,1,'2023-03-17 11:34:32','2023-03-17 11:34:55','2023-03-17 11:34:55'),(2816,7561,40725,3042,16,1111,'App\\Models\\PeriodLiquidation',NULL,1111,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',120367.72,NULL,NULL,1,'2023-03-17 11:35:44','2023-03-17 11:35:44',NULL),(2817,7561,40725,3043,16,1110,'App\\Models\\PeriodLiquidation',NULL,1110,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',110465.07,NULL,NULL,1,'2023-03-17 11:43:21','2023-03-17 11:43:21',NULL),(2818,7561,40725,3044,3,2399,'App\\Models\\Receipt',2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',10383.74,NULL,NULL,1,'2023-03-18 06:23:06','2023-03-18 06:23:06',NULL),(2819,7561,40727,1531,3,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',4049.23,NULL,NULL,1,'2023-03-18 06:49:48','2023-03-18 06:49:48',NULL),(2820,7561,40727,1531,3,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',6000.00,NULL,NULL,1,'2023-03-18 06:50:04','2023-03-18 06:50:04',NULL),(2821,7561,40727,1530,8,2400,'App\\Models\\Receipt',2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1348.90,NULL,NULL,1,'2023-03-18 07:10:09','2023-03-18 07:11:56','2023-03-18 07:11:56'),(2822,7561,40727,1530,8,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15.01,NULL,NULL,1,'2023-03-18 07:10:25','2023-03-18 07:12:03','2023-03-18 07:12:03'),(2823,7561,40727,1531,8,2402,'App\\Models\\Receipt',2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1096.36,NULL,NULL,1,'2023-03-18 07:10:42','2023-03-18 07:12:14','2023-03-18 07:12:14'),(2824,7561,40727,1530,8,2400,'App\\Models\\Receipt',2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1348.90,NULL,NULL,1,'2023-03-18 07:11:56','2023-03-18 07:11:56',NULL),(2825,7561,40727,1530,8,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15.01,NULL,NULL,1,'2023-03-18 07:12:03','2023-03-18 07:19:48','2023-03-18 07:19:48'),(2826,7561,40727,1531,8,2402,'App\\Models\\Receipt',2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1096.36,NULL,NULL,1,'2023-03-18 07:12:14','2023-03-18 07:12:14',NULL);
INSERT INTO `balance_libro` VALUES (2827,7561,40727,1530,8,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',20.28,NULL,NULL,1,'2023-03-18 07:19:48','2023-03-18 07:21:09','2023-03-18 07:21:09'),(2828,7561,40727,1531,8,2403,'App\\Models\\Receipt',2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',15.01,NULL,NULL,1,'2023-03-18 07:20:13','2023-03-18 07:21:03','2023-03-18 07:21:03'),(2829,7561,40727,1531,8,2403,'App\\Models\\Receipt',2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',15.01,NULL,NULL,1,'2023-03-18 07:21:03','2023-03-18 07:21:03',NULL),(2830,7561,40727,1530,8,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',20.28,NULL,NULL,1,'2023-03-18 07:21:09','2023-03-18 07:21:09',NULL),(2831,7561,40727,1531,16,1141,'App\\Models\\PeriodLiquidation',NULL,1141,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1829.70,NULL,NULL,1,'2023-03-18 08:09:09','2023-03-18 08:09:09',NULL),(2832,7561,40727,1532,1,2832,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-03-31',NULL,754897.23,NULL,NULL,1,'2023-04-04 12:34:52','2023-04-04 12:34:52',NULL),(2833,7561,40727,1532,2,2404,'App\\Models\\Receipt',2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',58000.01,NULL,NULL,1,'2023-04-08 10:38:04','2023-04-08 10:58:36','2023-04-08 10:58:36'),(2834,7561,40727,1532,2,2405,'App\\Models\\Receipt',2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',60500.00,NULL,NULL,1,'2023-04-08 10:38:04','2023-04-08 10:57:48','2023-04-08 10:57:48'),(2835,7561,40727,1532,2,2406,'App\\Models\\Receipt',2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',115000.00,NULL,NULL,1,'2023-04-08 10:38:04','2023-04-08 10:58:12','2023-04-08 10:58:12'),(2836,7561,40727,1532,2,2407,'App\\Models\\Receipt',2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',157300.00,NULL,NULL,1,'2023-04-08 10:38:04','2023-04-08 10:57:26','2023-04-08 10:57:26'),(2837,7561,40727,1532,2,2408,'App\\Models\\Receipt',2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',225544.00,NULL,NULL,1,'2023-04-08 10:38:04','2023-04-08 10:56:55','2023-04-08 10:56:55'),(2838,7561,40727,1532,2,2409,'App\\Models\\Receipt',2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',81796.00,NULL,NULL,1,'2023-04-08 10:38:04','2023-04-08 10:56:27','2023-04-08 10:56:27'),(2839,7561,40727,1532,2,2410,'App\\Models\\Receipt',2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',55000.00,NULL,NULL,1,'2023-04-08 10:38:04','2023-04-08 10:55:49','2023-04-08 10:55:49'),(2840,7561,40727,1532,2,2411,'App\\Models\\Receipt',2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',90003.00,NULL,NULL,1,'2023-04-08 10:38:05','2023-04-08 10:54:36','2023-04-08 10:54:36'),(2841,7561,40727,1532,2,2412,'App\\Models\\Receipt',2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',25000.00,NULL,NULL,1,'2023-04-08 10:38:05','2023-04-08 10:53:25','2023-04-08 10:53:25'),(2842,7561,40727,1532,2,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',52000.00,NULL,NULL,1,'2023-04-08 10:38:05','2023-04-08 10:54:05','2023-04-08 10:54:05'),(2843,7561,40727,1532,2,2414,'App\\Models\\Receipt',2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',54450.00,NULL,NULL,1,'2023-04-08 10:38:05','2023-04-08 10:49:17','2023-04-08 10:49:17'),(2844,7561,40727,1532,2,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',318230.00,NULL,NULL,1,'2023-04-08 10:38:05','2023-04-08 10:46:29','2023-04-08 10:46:29'),(2845,7561,40727,1532,2,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',30000.00,NULL,NULL,1,'2023-04-08 10:38:05','2023-04-08 10:45:54','2023-04-08 10:45:54');
INSERT INTO `balance_libro` VALUES (2846,7561,40727,1532,2,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',48000.00,NULL,NULL,1,'2023-04-08 10:38:05','2023-04-08 10:45:05','2023-04-08 10:45:05'),(2847,7561,40727,1532,3,2418,'App\\Models\\Receipt',2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',6000.00,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 11:42:45','2023-04-08 11:42:45'),(2848,7561,40727,1532,3,2419,'App\\Models\\Receipt',2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',115018.97,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 11:41:03','2023-04-08 11:41:03'),(2849,7561,40727,1532,3,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',49066.74,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 11:39:58','2023-04-08 11:39:58'),(2850,7561,40727,1532,3,2421,'App\\Models\\Receipt',2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',49780.56,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 10:38:48',NULL),(2851,7561,40727,1532,3,2422,'App\\Models\\Receipt',2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',49780.56,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 10:38:48',NULL),(2852,7561,40727,1532,3,2423,'App\\Models\\Receipt',2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',65707.40,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 11:38:24','2023-04-08 11:38:24'),(2853,7561,40727,1532,3,2424,'App\\Models\\Receipt',2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',4104.98,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 10:38:48',NULL),(2854,7561,40727,1532,3,2425,'App\\Models\\Receipt',2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',37240.53,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 11:27:05','2023-04-08 11:27:05'),(2855,7561,40727,1532,3,2426,'App\\Models\\Receipt',2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',29376.56,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 11:24:29','2023-04-08 11:24:29'),(2856,7561,40727,1532,3,2427,'App\\Models\\Receipt',2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',109659.88,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 11:23:11','2023-04-08 11:23:11'),(2857,7561,40727,1532,3,2428,'App\\Models\\Receipt',2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',18914.09,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 11:13:24','2023-04-08 11:13:24'),(2858,7561,40727,1532,3,2429,'App\\Models\\Receipt',2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',47399.28,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 11:21:04','2023-04-08 11:21:04'),(2859,7561,40727,1532,3,2430,'App\\Models\\Receipt',2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',32723.00,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 11:22:09','2023-04-08 11:22:09'),(2860,7561,40727,1532,3,2431,'App\\Models\\Receipt',2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',86708.60,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 11:19:45','2023-04-08 11:19:45'),(2861,7561,40727,1532,3,2432,'App\\Models\\Receipt',2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',51866.65,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 11:16:18','2023-04-08 11:16:18'),(2862,7561,40727,1532,3,2433,'App\\Models\\Receipt',2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',58201.00,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 11:14:50','2023-04-08 11:14:50'),(2863,7561,40727,1532,3,2434,'App\\Models\\Receipt',2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',28833.96,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 11:08:55','2023-04-08 11:08:55'),(2864,7561,40727,1532,3,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',15216.85,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 11:10:07','2023-04-08 11:10:07');
INSERT INTO `balance_libro` VALUES (2865,7561,40727,1532,3,2436,'App\\Models\\Receipt',2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',32153.24,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 11:08:05','2023-04-08 11:08:05'),(2866,7561,40727,1532,3,2437,'App\\Models\\Receipt',2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',30406.48,NULL,NULL,1,'2023-04-08 10:38:48','2023-04-08 11:06:48','2023-04-08 11:06:48'),(2867,7561,40727,1532,3,2438,'App\\Models\\Receipt',2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',30599.93,NULL,NULL,1,'2023-04-08 10:38:49','2023-04-08 11:01:00','2023-04-08 11:01:00'),(2868,7561,40727,1532,2,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',48000.00,NULL,NULL,1,'2023-04-08 10:45:05','2023-04-08 10:48:11','2023-04-08 10:48:11'),(2869,7561,40727,1532,2,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',30000.00,NULL,NULL,1,'2023-04-08 10:45:54','2023-04-08 10:48:36','2023-04-08 10:48:36'),(2870,7561,40727,1532,2,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',318230.00,NULL,NULL,1,'2023-04-08 10:46:29','2023-04-08 10:48:53','2023-04-08 10:48:53'),(2871,7561,40727,1532,2,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',48000.00,NULL,NULL,1,'2023-04-08 10:48:11','2023-04-08 10:48:11',NULL),(2872,7561,40727,1532,2,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',30000.00,NULL,NULL,1,'2023-04-08 10:48:36','2023-04-08 10:48:36',NULL),(2873,7561,40727,1532,2,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',318230.00,NULL,NULL,1,'2023-04-08 10:48:53','2023-04-08 10:48:53',NULL),(2874,7561,40727,1532,2,2414,'App\\Models\\Receipt',2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',54450.00,NULL,NULL,1,'2023-04-08 10:49:17','2023-04-08 10:49:17',NULL),(2875,7561,40727,1532,2,2412,'App\\Models\\Receipt',2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',25000.00,NULL,NULL,1,'2023-04-08 10:53:25','2023-04-08 10:53:25',NULL),(2876,7561,40727,1532,2,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',52000.00,NULL,NULL,1,'2023-04-08 10:54:05','2023-04-08 10:54:05',NULL),(2877,7561,40727,1532,2,2411,'App\\Models\\Receipt',2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',90002.99,NULL,NULL,1,'2023-04-08 10:54:36','2023-04-08 10:54:36',NULL),(2878,7561,40727,1532,2,2410,'App\\Models\\Receipt',2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',5500.01,NULL,NULL,1,'2023-04-08 10:55:49','2023-04-08 10:55:49',NULL),(2879,7561,40727,1532,2,2409,'App\\Models\\Receipt',2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',81796.00,NULL,NULL,1,'2023-04-08 10:56:27','2023-04-08 10:56:27',NULL),(2880,7561,40727,1532,2,2408,'App\\Models\\Receipt',2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',225544.00,NULL,NULL,1,'2023-04-08 10:56:55','2023-04-08 10:56:55',NULL),(2881,7561,40727,1532,2,2407,'App\\Models\\Receipt',2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',157300.00,NULL,NULL,1,'2023-04-08 10:57:26','2023-04-08 10:57:26',NULL),(2882,7561,40727,1532,2,2405,'App\\Models\\Receipt',2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',60500.00,NULL,NULL,1,'2023-04-08 10:57:48','2023-04-08 10:57:48',NULL),(2883,7561,40727,1532,2,2406,'App\\Models\\Receipt',2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',115000.00,NULL,NULL,1,'2023-04-08 10:58:12','2023-04-08 10:58:12',NULL),(2884,7561,40727,1532,2,2404,'App\\Models\\Receipt',2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',58000.01,NULL,NULL,1,'2023-04-08 10:58:36','2023-04-08 10:58:36',NULL);
INSERT INTO `balance_libro` VALUES (2885,7561,40727,1532,3,2438,'App\\Models\\Receipt',2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',30599.93,NULL,NULL,1,'2023-04-08 11:01:00','2023-04-08 11:01:00',NULL),(2886,7561,40727,1532,3,2437,'App\\Models\\Receipt',2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',30406.48,NULL,NULL,1,'2023-04-08 11:06:48','2023-04-08 11:06:48',NULL),(2887,7561,40727,1532,3,2436,'App\\Models\\Receipt',2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',32153.23,NULL,NULL,1,'2023-04-08 11:08:05','2023-04-08 11:08:05',NULL),(2888,7561,40727,1532,3,2434,'App\\Models\\Receipt',2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',28833.96,NULL,NULL,1,'2023-04-08 11:08:55','2023-04-08 11:08:55',NULL),(2889,7561,40727,1532,3,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',15216.85,NULL,NULL,1,'2023-04-08 11:10:07','2023-04-08 11:10:50','2023-04-08 11:10:50'),(2890,7561,40727,1532,3,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',15216.85,NULL,NULL,1,'2023-04-08 11:10:50','2023-04-08 11:10:50',NULL),(2891,7561,40727,1532,3,2428,'App\\Models\\Receipt',2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',18914.09,NULL,NULL,1,'2023-04-08 11:13:24','2023-04-08 11:13:24',NULL),(2892,7561,40727,1532,3,2433,'App\\Models\\Receipt',2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',58201.00,NULL,NULL,1,'2023-04-08 11:14:50','2023-04-08 11:14:50',NULL),(2893,7561,40727,1532,3,2432,'App\\Models\\Receipt',2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',51866.65,NULL,NULL,1,'2023-04-08 11:16:18','2023-04-08 11:16:18',NULL),(2894,7561,40727,1532,3,2431,'App\\Models\\Receipt',2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',86708.60,NULL,NULL,1,'2023-04-08 11:19:45','2023-04-08 11:19:45',NULL),(2895,7561,40727,1532,3,2429,'App\\Models\\Receipt',2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',47399.28,NULL,NULL,1,'2023-04-08 11:21:04','2023-04-08 11:21:04',NULL),(2896,7561,40727,1532,3,2430,'App\\Models\\Receipt',2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',32723.00,NULL,NULL,1,'2023-04-08 11:22:09','2023-04-08 11:22:09',NULL),(2897,7561,40727,1532,3,2427,'App\\Models\\Receipt',2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',109659.88,NULL,NULL,1,'2023-04-08 11:23:11','2023-04-08 11:23:11',NULL),(2898,7561,40727,1532,3,2426,'App\\Models\\Receipt',2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',29376.56,NULL,NULL,1,'2023-04-08 11:24:29','2023-04-08 11:24:29',NULL),(2899,7561,40727,1532,3,2425,'App\\Models\\Receipt',2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',37240.54,NULL,NULL,1,'2023-04-08 11:27:05','2023-04-08 11:33:23','2023-04-08 11:33:23'),(2900,7561,40727,1532,3,2425,'App\\Models\\Receipt',2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',37240.54,NULL,NULL,1,'2023-04-08 11:33:23','2023-04-08 11:33:23',NULL),(2901,7561,40727,1532,3,2439,'App\\Models\\Receipt',2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4203.19,NULL,NULL,1,'2023-04-08 11:36:48','2023-04-08 11:36:48',NULL),(2902,7561,40727,1532,3,2423,'App\\Models\\Receipt',2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',65707.40,NULL,NULL,1,'2023-04-08 11:38:24','2023-04-08 11:38:24',NULL),(2903,7561,40727,1532,3,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',49066.74,NULL,NULL,1,'2023-04-08 11:39:58','2023-04-08 11:39:58',NULL),(2904,7561,40727,1532,3,2419,'App\\Models\\Receipt',2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',115018.97,NULL,NULL,1,'2023-04-08 11:41:03','2023-04-08 11:41:03',NULL);
INSERT INTO `balance_libro` VALUES (2905,7561,40727,1532,3,2418,'App\\Models\\Receipt',2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',6000.00,NULL,NULL,1,'2023-04-08 11:42:45','2023-04-08 11:42:45',NULL),(2906,7561,40725,3044,2,2440,'App\\Models\\Receipt',2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',46113.10,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 13:11:09','2023-04-12 13:11:09'),(2907,7561,40725,3044,2,2441,'App\\Models\\Receipt',2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',108816.02,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 10:02:40',NULL),(2908,7561,40725,3044,2,2442,'App\\Models\\Receipt',2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',103630.42,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 10:02:40',NULL),(2909,7561,40725,3044,2,2443,'App\\Models\\Receipt',2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',114187.70,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 13:10:44','2023-04-12 13:10:44'),(2910,7561,40725,3044,2,2444,'App\\Models\\Receipt',2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',293884.80,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 13:37:01','2023-04-12 13:37:01'),(2911,7561,40725,3044,2,2445,'App\\Models\\Receipt',2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',55042.90,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 13:10:28','2023-04-12 13:10:28'),(2912,7561,40725,3044,2,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',111622.50,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 13:36:38','2023-04-12 13:36:38'),(2913,7561,40725,3044,2,2447,'App\\Models\\Receipt',2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',134302.91,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 10:02:40',NULL),(2914,7561,40725,3044,2,2448,'App\\Models\\Receipt',2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',125803.70,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 13:36:20','2023-04-12 13:36:20'),(2915,7561,40725,3044,2,2449,'App\\Models\\Receipt',2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',72200.70,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 10:02:40',NULL),(2916,7561,40725,3044,2,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',144004.52,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 10:02:40',NULL),(2917,7561,40725,3044,2,2451,'App\\Models\\Receipt',2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',52635.00,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 10:02:40',NULL),(2918,7561,40725,3044,2,2452,'App\\Models\\Receipt',2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',7840.00,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 10:17:21','2023-04-12 10:17:21'),(2919,7561,40725,3044,2,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',29020.00,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 10:16:10','2023-04-12 10:16:10'),(2920,7561,40725,3044,2,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',332861.32,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 13:35:26','2023-04-12 13:35:26'),(2921,7561,40725,3044,2,2455,'App\\Models\\Receipt',2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',191238.90,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 10:02:40',NULL),(2922,7561,40725,3044,2,2456,'App\\Models\\Receipt',2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',129591.00,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 10:02:40',NULL),(2923,7561,40725,3044,2,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',98929.60,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 10:22:34','2023-04-12 10:22:34'),(2924,7561,40725,3044,2,2458,'App\\Models\\Receipt',2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',59774.00,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 10:02:40',NULL);
INSERT INTO `balance_libro` VALUES (2925,7561,40725,3044,2,2459,'App\\Models\\Receipt',2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',40536.21,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 13:09:34','2023-04-12 13:09:34'),(2926,7561,40725,3044,2,2460,'App\\Models\\Receipt',2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',579649.90,NULL,NULL,1,'2023-04-12 10:02:40','2023-04-12 10:02:40',NULL),(2927,7561,40725,3044,2,2461,'App\\Models\\Receipt',2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',579649.90,NULL,NULL,1,'2023-04-12 10:02:41','2023-04-12 10:02:41',NULL),(2928,7561,40725,3044,2,2462,'App\\Models\\Receipt',2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',579649.90,NULL,NULL,1,'2023-04-12 10:02:41','2023-04-12 10:02:41',NULL),(2929,7561,40725,3044,3,2463,'App\\Models\\Receipt',2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',110930.88,NULL,NULL,1,'2023-04-12 10:06:27','2023-04-12 10:25:58','2023-04-12 10:25:58'),(2930,7561,40725,3044,3,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',5145.59,NULL,NULL,1,'2023-04-12 10:06:27','2023-04-12 12:49:22','2023-04-12 12:49:22'),(2931,7561,40725,3044,3,2465,'App\\Models\\Receipt',2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',13928.31,NULL,NULL,1,'2023-04-12 10:06:27','2023-04-12 10:06:27',NULL),(2932,7561,40725,3044,3,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',1390.00,NULL,NULL,1,'2023-04-12 10:06:27','2023-04-12 10:25:46','2023-04-12 10:25:46'),(2933,7561,40725,3044,3,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',68.00,NULL,NULL,1,'2023-04-12 10:06:27','2023-04-12 13:03:43','2023-04-12 13:03:43'),(2934,7561,40725,3044,3,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',8937.80,NULL,NULL,1,'2023-04-12 10:06:27','2023-04-12 12:11:29','2023-04-12 12:11:29'),(2935,7561,40725,3044,3,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',100.00,NULL,NULL,1,'2023-04-12 10:06:27','2023-04-12 13:05:39','2023-04-12 13:05:39'),(2936,7561,40725,3044,3,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',14902.98,NULL,NULL,1,'2023-04-12 10:06:27','2023-04-12 13:02:38','2023-04-12 13:02:38'),(2937,7561,40725,3044,3,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',273937.95,NULL,NULL,1,'2023-04-12 10:06:27','2023-04-12 12:43:58','2023-04-12 12:43:58'),(2938,7561,40725,3044,3,2472,'App\\Models\\Receipt',2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',272.56,NULL,NULL,1,'2023-04-12 10:06:27','2023-04-12 13:02:57','2023-04-12 13:02:57'),(2939,7561,40725,3044,3,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',120334.50,NULL,NULL,1,'2023-04-12 10:06:27','2023-04-12 12:46:14','2023-04-12 12:46:14'),(2940,7561,40725,3044,3,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',65830.05,NULL,NULL,1,'2023-04-12 10:06:27','2023-04-12 12:50:30','2023-04-12 12:50:30'),(2941,7561,40725,3044,3,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1190.00,NULL,NULL,1,'2023-04-12 10:06:27','2023-04-12 12:19:30','2023-04-12 12:19:30'),(2942,7561,40725,3044,3,2476,'App\\Models\\Receipt',2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',107829.15,NULL,NULL,1,'2023-04-12 10:06:27','2023-04-12 12:47:30','2023-04-12 12:47:30'),(2943,7561,40725,3044,3,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3999.99,NULL,NULL,1,'2023-04-12 10:06:27','2023-04-12 12:09:52','2023-04-12 12:09:52');
INSERT INTO `balance_libro` VALUES (2944,7561,40725,3044,3,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',43888.88,NULL,NULL,1,'2023-04-12 10:06:27','2023-04-12 12:51:00','2023-04-12 12:51:00'),(2945,7561,40725,3044,3,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',136.00,NULL,NULL,1,'2023-04-12 10:06:27','2023-04-12 10:06:27',NULL),(2946,7561,40725,3044,3,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1098075.00,NULL,NULL,1,'2023-04-12 10:06:28','2023-04-12 12:37:28','2023-04-12 12:37:28'),(2947,7561,40725,3044,3,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1098075.00,NULL,NULL,1,'2023-04-12 10:06:28','2023-04-12 12:35:11','2023-04-12 12:35:11'),(2948,7561,40725,3044,3,2482,'App\\Models\\Receipt',2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',90.00,NULL,NULL,1,'2023-04-12 10:06:28','2023-04-12 10:26:11','2023-04-12 10:26:11'),(2949,7561,40725,3044,3,2483,'App\\Models\\Receipt',2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',400.00,NULL,NULL,1,'2023-04-12 10:06:28','2023-04-12 13:04:33','2023-04-12 13:04:33'),(2950,7561,40725,3044,3,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',1098075.00,NULL,NULL,1,'2023-04-12 10:06:28','2023-04-12 12:38:21','2023-04-12 12:38:21'),(2951,7561,40725,3044,3,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',418865.70,NULL,NULL,1,'2023-04-12 10:06:28','2023-04-12 12:41:49','2023-04-12 12:41:49'),(2952,7561,40725,3044,3,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',73148.13,NULL,NULL,1,'2023-04-12 10:06:28','2023-04-12 12:56:01','2023-04-12 12:56:01'),(2953,7561,40725,3044,3,2487,'App\\Models\\Receipt',2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',27225.00,NULL,NULL,1,'2023-04-12 10:06:28','2023-04-12 12:21:55','2023-04-12 12:21:55'),(2954,7561,40725,3044,3,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',41000.00,NULL,NULL,1,'2023-04-12 10:06:28','2023-04-12 10:09:10','2023-04-12 10:09:10'),(2955,7561,40725,3044,3,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',41000.00,NULL,NULL,1,'2023-04-12 10:09:10','2023-04-12 10:09:10',NULL),(2956,7561,40725,3044,2,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',29020.00,NULL,NULL,1,'2023-04-12 10:16:10','2023-04-12 13:09:55','2023-04-12 13:09:55'),(2957,7561,40725,3044,2,2452,'App\\Models\\Receipt',2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',7840.00,NULL,NULL,1,'2023-04-12 10:17:21','2023-04-12 13:10:12','2023-04-12 13:10:12'),(2958,7561,40725,3044,2,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',98929.60,NULL,NULL,1,'2023-04-12 10:22:34','2023-04-12 10:22:34',NULL),(2959,7561,40725,3044,3,2489,'App\\Models\\Receipt',2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',3999.98,NULL,NULL,1,'2023-04-12 10:30:31','2023-04-12 10:30:31',NULL),(2960,7561,40725,3044,3,2490,'App\\Models\\Receipt',2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',4797.17,NULL,NULL,1,'2023-04-12 10:33:40','2023-04-12 10:33:40',NULL),(2961,7561,40725,3044,3,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',5801.63,NULL,NULL,1,'2023-04-12 10:50:47','2023-04-12 10:50:47',NULL),(2962,7561,40725,3044,3,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',3561.10,NULL,NULL,1,'2023-04-12 10:53:15','2023-04-12 10:53:15',NULL),(2963,7561,40725,3044,3,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',8000.24,NULL,NULL,1,'2023-04-12 10:56:11','2023-04-12 10:56:11',NULL);
INSERT INTO `balance_libro` VALUES (2964,7561,40725,3044,3,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',4000.12,NULL,NULL,1,'2023-04-12 10:57:16','2023-04-12 10:57:16',NULL),(2965,7561,40725,3044,3,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3999.99,NULL,NULL,1,'2023-04-12 12:09:52','2023-04-12 12:09:52',NULL),(2966,7561,40725,3044,3,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',8937.80,NULL,NULL,1,'2023-04-12 12:11:29','2023-04-12 12:11:29',NULL),(2967,7561,40725,3044,3,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3792.86,NULL,NULL,1,'2023-04-12 12:17:35','2023-04-12 12:17:35',NULL),(2968,7561,40725,3044,3,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1190.00,NULL,NULL,1,'2023-04-12 12:19:30','2023-04-12 12:19:30',NULL),(2969,7561,40725,3044,3,2487,'App\\Models\\Receipt',2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',27225.00,NULL,NULL,1,'2023-04-12 12:21:55','2023-04-12 12:21:55',NULL),(2970,7561,40725,3044,3,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',3909.72,NULL,NULL,1,'2023-04-12 12:32:53','2023-04-12 12:32:53',NULL),(2971,7561,40725,3044,3,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1098075.00,NULL,NULL,1,'2023-04-12 12:35:11','2023-04-12 12:35:16','2023-04-12 12:35:16'),(2972,7561,40725,3044,3,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1098075.00,NULL,NULL,1,'2023-04-12 12:35:16','2023-04-12 12:52:45','2023-04-12 12:52:45'),(2973,7561,40725,3044,3,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1098075.00,NULL,NULL,1,'2023-04-12 12:37:28','2023-04-12 12:52:58','2023-04-12 12:52:58'),(2974,7561,40725,3044,3,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',1098075.00,NULL,NULL,1,'2023-04-12 12:38:21','2023-04-12 12:52:02','2023-04-12 12:52:02'),(2975,7561,40725,3044,3,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',418865.70,NULL,NULL,1,'2023-04-12 12:41:49','2023-04-12 12:42:07','2023-04-12 12:42:07'),(2976,7561,40725,3044,3,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',418865.70,NULL,NULL,1,'2023-04-12 12:42:07','2023-04-12 12:42:07',NULL),(2977,7561,40725,3044,3,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',273937.95,NULL,NULL,1,'2023-04-12 12:43:58','2023-04-12 12:43:58',NULL),(2978,7561,40725,3044,3,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',120334.50,NULL,NULL,1,'2023-04-12 12:46:14','2023-04-12 12:46:14',NULL),(2979,7561,40725,3044,3,2476,'App\\Models\\Receipt',2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',107829.15,NULL,NULL,1,'2023-04-12 12:47:30','2023-04-12 12:47:30',NULL),(2980,7561,40725,3044,3,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',5145.29,NULL,NULL,1,'2023-04-12 12:49:22','2023-04-13 19:58:32','2023-04-13 19:58:32'),(2981,7561,40725,3044,3,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',65830.05,NULL,NULL,1,'2023-04-12 12:50:30','2023-04-12 12:50:30',NULL),(2982,7561,40725,3044,3,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',43888.88,NULL,NULL,1,'2023-04-12 12:51:00','2023-04-12 12:55:19','2023-04-12 12:55:19'),(2983,7561,40725,3044,3,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',1098075.00,NULL,NULL,1,'2023-04-12 12:52:02','2023-04-12 12:52:02',NULL);
INSERT INTO `balance_libro` VALUES (2984,7561,40725,3044,3,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1098075.00,NULL,NULL,1,'2023-04-12 12:52:45','2023-04-12 12:52:45',NULL),(2985,7561,40725,3044,3,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1098075.00,NULL,NULL,1,'2023-04-12 12:52:58','2023-04-12 12:52:58',NULL),(2986,7561,40725,3044,3,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',43888.88,NULL,NULL,1,'2023-04-12 12:55:19','2023-04-12 12:55:19',NULL),(2987,7561,40725,3044,3,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',73148.13,NULL,NULL,1,'2023-04-12 12:56:01','2023-04-12 12:58:46','2023-04-12 12:58:46'),(2988,7561,40725,3044,3,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',73148.13,NULL,NULL,1,'2023-04-12 12:58:46','2023-04-12 12:58:46',NULL),(2989,7561,40725,3044,3,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',68.00,NULL,NULL,1,'2023-04-12 13:03:43','2023-04-12 13:03:43',NULL),(2990,7561,40725,3044,3,2483,'App\\Models\\Receipt',2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',399.99,NULL,NULL,1,'2023-04-12 13:04:33','2023-04-12 13:04:33',NULL),(2991,7561,40725,3044,3,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',100.01,NULL,NULL,1,'2023-04-12 13:05:39','2023-04-12 13:05:39',NULL),(2992,7561,40725,3044,2,2459,'App\\Models\\Receipt',2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',40536.21,NULL,NULL,1,'2023-04-12 13:09:34','2023-04-12 13:09:34',NULL),(2993,7561,40725,3044,2,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',29020.00,NULL,NULL,1,'2023-04-12 13:09:55','2023-04-12 13:09:55',NULL),(2994,7561,40725,3044,2,2452,'App\\Models\\Receipt',2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',7840.00,NULL,NULL,1,'2023-04-12 13:10:12','2023-04-12 13:10:12',NULL),(2995,7561,40725,3044,2,2445,'App\\Models\\Receipt',2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',55042.90,NULL,NULL,1,'2023-04-12 13:10:28','2023-04-12 13:10:28',NULL),(2996,7561,40725,3044,2,2443,'App\\Models\\Receipt',2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',114187.70,NULL,NULL,1,'2023-04-12 13:10:44','2023-04-12 13:37:18','2023-04-12 13:37:18'),(2997,7561,40725,3044,2,2440,'App\\Models\\Receipt',2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',46113.10,NULL,NULL,1,'2023-04-12 13:11:09','2023-04-12 13:11:09',NULL),(2998,7561,40725,3044,2,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',332861.32,NULL,NULL,1,'2023-04-12 13:35:26','2023-04-12 13:35:26',NULL),(2999,7561,40725,3044,2,2448,'App\\Models\\Receipt',2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',125803.70,NULL,NULL,1,'2023-04-12 13:36:20','2023-04-12 13:36:20',NULL),(3000,7561,40725,3044,2,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',111622.50,NULL,NULL,1,'2023-04-12 13:36:38','2023-04-12 13:36:38',NULL),(3001,7561,40725,3044,2,2444,'App\\Models\\Receipt',2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',293884.80,NULL,NULL,1,'2023-04-12 13:37:01','2023-04-12 13:37:01',NULL),(3002,7561,40725,3044,2,2443,'App\\Models\\Receipt',2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',114187.70,NULL,NULL,1,'2023-04-12 13:37:18','2023-04-12 13:37:18',NULL),(3003,7561,40725,3044,7,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',4412.37,NULL,NULL,1,'2023-04-12 13:44:39','2023-04-12 13:44:39',NULL);
INSERT INTO `balance_libro` VALUES (3004,7561,40719,20,2,2498,'App\\Models\\Receipt',2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',41000.00,NULL,NULL,1,'2023-04-12 19:28:00','2023-04-12 19:28:00',NULL),(3005,7561,40719,20,2,2499,'App\\Models\\Receipt',2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',17500.00,NULL,NULL,1,'2023-04-12 19:28:00','2023-04-12 19:28:00',NULL),(3006,7561,40719,20,2,2500,'App\\Models\\Receipt',2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',17500.00,NULL,NULL,1,'2023-04-12 19:28:00','2023-04-12 19:28:00',NULL),(3007,7561,40719,20,2,2501,'App\\Models\\Receipt',2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',6000.00,NULL,NULL,1,'2023-04-12 19:28:00','2023-04-12 19:28:00',NULL),(3008,7561,40719,20,2,2502,'App\\Models\\Receipt',2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',280000.00,NULL,NULL,1,'2023-04-12 19:28:00','2023-04-12 19:28:00',NULL),(3009,7561,40725,3044,3,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',5145.59,NULL,NULL,1,'2023-04-13 19:58:32','2023-04-13 19:58:32',NULL),(3010,7561,40725,3044,16,1347,'App\\Models\\PeriodLiquidation',NULL,1347,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',99588.38,NULL,NULL,1,'2023-04-13 19:59:26','2023-04-13 20:03:40','2023-04-13 20:03:40'),(3011,7561,40725,3044,15,1350,'App\\Models\\PeriodLiquidation',NULL,1350,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',785042.20,NULL,NULL,1,'2023-04-13 20:04:32','2023-04-13 20:04:32',NULL),(3012,7561,40725,3044,16,1347,'App\\Models\\PeriodLiquidation',NULL,1347,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',99588.38,NULL,NULL,1,'2023-04-13 20:04:41','2023-04-13 20:04:41',NULL),(3013,7561,40725,3044,1,3013,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-03-31',NULL,540917.36,NULL,NULL,1,'2023-04-17 15:58:17','2023-04-17 15:58:17',NULL),(3014,7561,40734,15264,2,2503,'App\\Models\\Receipt',2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',72732.00,NULL,NULL,1,'2023-04-18 11:40:02','2023-04-18 11:40:02',NULL),(3015,7561,40734,15265,2,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',52900.00,NULL,NULL,1,'2023-04-18 11:40:39','2023-04-18 11:42:16','2023-04-18 11:42:16'),(3016,7561,40734,15266,2,2505,'App\\Models\\Receipt',2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',67160.00,NULL,NULL,1,'2023-04-18 11:41:07','2023-04-18 11:41:56','2023-04-18 11:41:56'),(3017,7561,40734,15266,2,2505,'App\\Models\\Receipt',2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',67160.00,NULL,NULL,1,'2023-04-18 11:41:56','2023-04-18 11:41:56',NULL),(3018,7561,40734,15265,2,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',52900.00,NULL,NULL,1,'2023-04-18 11:42:16','2023-04-18 11:42:16',NULL),(3019,7561,40852,7610,2,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',20000.00,NULL,NULL,1,'2023-04-18 11:45:38','2023-04-18 11:45:38',NULL),(3020,7561,40852,7610,2,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',153150.00,NULL,NULL,1,'2023-04-18 11:46:24','2023-04-18 11:46:24',NULL),(3021,7561,40852,7614,2,2506,'App\\Models\\Receipt',2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',153150.00,NULL,NULL,1,'2023-04-18 12:30:22','2023-04-18 12:30:22',NULL),(3022,7561,40852,7614,2,2507,'App\\Models\\Receipt',2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',50000.00,NULL,NULL,1,'2023-04-18 12:30:22','2023-04-18 12:30:22',NULL),(3023,7561,40852,7615,2,2508,'App\\Models\\Receipt',2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',153150.00,NULL,NULL,1,'2023-04-18 12:30:54','2023-04-18 12:30:54',NULL);
INSERT INTO `balance_libro` VALUES (3024,7561,40852,7615,2,2509,'App\\Models\\Receipt',2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',50000.00,NULL,NULL,1,'2023-04-18 12:30:54','2023-04-18 12:30:54',NULL),(3025,7561,40852,7616,2,2510,'App\\Models\\Receipt',2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',153150.00,NULL,NULL,1,'2023-04-18 12:39:08','2023-04-18 12:39:08',NULL),(3026,7561,40852,7616,2,2511,'App\\Models\\Receipt',2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',50000.00,NULL,NULL,1,'2023-04-18 12:39:08','2023-04-18 12:39:08',NULL),(3027,7561,40852,7617,2,2512,'App\\Models\\Receipt',2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',153150.00,NULL,NULL,1,'2023-04-18 12:42:41','2023-04-18 12:42:41',NULL),(3028,7561,40852,7617,2,2513,'App\\Models\\Receipt',2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',50000.00,NULL,NULL,1,'2023-04-18 12:42:41','2023-04-18 12:42:41',NULL),(3029,7561,40852,7602,16,584,'App\\Models\\PeriodLiquidation',NULL,584,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',0.00,NULL,NULL,1,'2023-04-18 12:51:10','2023-04-18 12:51:10',NULL),(3030,7561,40852,7603,16,585,'App\\Models\\PeriodLiquidation',NULL,585,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',0.00,NULL,NULL,1,'2023-04-18 12:51:16','2023-04-18 12:51:16',NULL),(3031,7561,40852,7617,16,1358,'App\\Models\\PeriodLiquidation',NULL,1358,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',0.00,NULL,NULL,1,'2023-04-18 12:51:24','2023-04-18 12:51:24',NULL),(3032,7561,40852,7616,16,1357,'App\\Models\\PeriodLiquidation',NULL,1357,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',0.00,NULL,NULL,1,'2023-04-18 12:51:28','2023-04-18 12:51:28',NULL),(3033,7561,40852,7610,16,1354,'App\\Models\\PeriodLiquidation',NULL,1354,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',0.00,NULL,NULL,1,'2023-04-18 12:51:37','2023-04-18 12:51:37',NULL),(3034,7561,40852,7615,16,1356,'App\\Models\\PeriodLiquidation',NULL,1356,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',0.00,NULL,NULL,1,'2023-04-18 12:52:45','2023-04-18 12:52:45',NULL),(3035,7561,40852,7614,16,1355,'App\\Models\\PeriodLiquidation',NULL,1355,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.00,NULL,NULL,1,'2023-04-18 12:52:51','2023-04-18 12:52:51',NULL),(3036,7561,40852,7609,16,592,'App\\Models\\PeriodLiquidation',NULL,592,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',0.00,NULL,NULL,1,'2023-04-18 12:52:58','2023-04-18 12:52:58',NULL),(3037,7561,40852,7599,16,580,'App\\Models\\PeriodLiquidation',NULL,580,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',0.00,NULL,NULL,1,'2023-04-18 12:53:06','2023-04-18 12:53:06',NULL),(3038,7561,40852,7608,16,590,'App\\Models\\PeriodLiquidation',NULL,590,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',0.00,NULL,NULL,1,'2023-04-18 12:53:12','2023-04-18 12:53:12',NULL),(3039,7561,40852,7607,16,589,'App\\Models\\PeriodLiquidation',NULL,589,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',0.00,NULL,NULL,1,'2023-04-18 12:53:18','2023-04-18 12:53:18',NULL),(3040,7561,40852,7606,16,588,'App\\Models\\PeriodLiquidation',NULL,588,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',0.00,NULL,NULL,1,'2023-04-18 12:53:23','2023-04-18 12:53:23',NULL),(3041,7561,40852,7605,16,587,'App\\Models\\PeriodLiquidation',NULL,587,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',0.00,NULL,NULL,1,'2023-04-18 12:53:30','2023-04-18 12:53:30',NULL),(3042,7561,40852,7604,16,586,'App\\Models\\PeriodLiquidation',NULL,586,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',0.00,NULL,NULL,1,'2023-04-18 12:53:36','2023-04-18 12:53:36',NULL),(3043,7561,40852,7600,16,1359,'App\\Models\\PeriodLiquidation',NULL,1359,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',0.00,NULL,NULL,1,'2023-04-18 12:54:26','2023-04-18 12:54:26',NULL);
INSERT INTO `balance_libro` VALUES (3044,7561,40852,7601,16,1360,'App\\Models\\PeriodLiquidation',NULL,1360,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',0.00,NULL,NULL,1,'2023-04-18 12:54:37','2023-04-18 12:54:37',NULL),(3045,7561,40857,18327,2,2514,'App\\Models\\Receipt',2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',40476.00,NULL,NULL,1,'2023-04-18 13:13:30','2023-04-18 13:13:30',NULL),(3046,7561,40857,18327,2,2515,'App\\Models\\Receipt',2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',49400.00,NULL,NULL,1,'2023-04-18 13:13:30','2023-04-18 13:13:30',NULL),(3047,7561,40857,18327,2,2516,'App\\Models\\Receipt',2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',38000.00,NULL,NULL,1,'2023-04-18 13:13:30','2023-04-18 13:13:30',NULL),(3048,7561,40855,12205,2,2517,'App\\Models\\Receipt',2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',25315.35,NULL,NULL,1,'2023-04-18 14:11:19','2023-04-18 14:11:19',NULL),(3049,7561,40855,12205,2,2518,'App\\Models\\Receipt',2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',672.00,NULL,NULL,1,'2023-04-18 14:11:20','2023-04-18 14:11:20',NULL),(3050,7561,40855,12205,2,2519,'App\\Models\\Receipt',2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',142902.50,NULL,NULL,1,'2023-04-18 14:11:20','2023-04-18 14:11:20',NULL),(3051,7561,40855,12205,2,2520,'App\\Models\\Receipt',2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',93008.50,NULL,NULL,1,'2023-04-18 14:11:20','2023-04-18 14:11:20',NULL),(3052,7561,40855,12205,2,2521,'App\\Models\\Receipt',2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',5155.00,NULL,NULL,1,'2023-04-18 14:11:20','2023-04-18 14:11:20',NULL),(3053,7561,40855,12205,2,2522,'App\\Models\\Receipt',2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',8227.50,NULL,NULL,1,'2023-04-18 14:11:20','2023-04-18 14:11:20',NULL),(3054,7561,40855,12205,2,2523,'App\\Models\\Receipt',2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',36119.00,NULL,NULL,1,'2023-04-18 14:11:20','2023-04-18 14:11:20',NULL),(3055,7561,40855,12205,2,2524,'App\\Models\\Receipt',2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',20000.00,NULL,NULL,1,'2023-04-18 14:11:20','2023-04-18 14:11:20',NULL),(3056,7561,40855,12205,2,2525,'App\\Models\\Receipt',2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',82875.00,NULL,NULL,1,'2023-04-18 14:11:20','2023-04-18 14:11:20',NULL),(3057,7561,40855,12205,2,2526,'App\\Models\\Receipt',2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',28110.50,NULL,NULL,1,'2023-04-18 14:11:20','2023-04-18 14:11:20',NULL),(3058,7561,40855,12205,2,2527,'App\\Models\\Receipt',2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',30000.00,NULL,NULL,1,'2023-04-18 14:11:20','2023-04-18 14:11:20',NULL),(3059,7561,40855,12205,2,2528,'App\\Models\\Receipt',2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',90192.00,NULL,NULL,1,'2023-04-18 14:11:20','2023-04-18 14:11:20',NULL),(3060,7561,40855,12205,2,2529,'App\\Models\\Receipt',2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',34963.74,NULL,NULL,1,'2023-04-18 14:11:20','2023-04-18 14:11:20',NULL),(3061,7561,40855,12205,2,2530,'App\\Models\\Receipt',2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',124995.00,NULL,NULL,1,'2023-04-18 14:11:20','2023-04-18 14:11:20',NULL),(3062,7561,40855,12205,2,2531,'App\\Models\\Receipt',2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',4100.00,NULL,NULL,1,'2023-04-18 14:11:20','2023-04-18 14:11:20',NULL),(3063,7561,40855,12205,2,2532,'App\\Models\\Receipt',2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',115362.50,NULL,NULL,1,'2023-04-18 14:11:20','2023-04-18 14:11:20',NULL);
INSERT INTO `balance_libro` VALUES (3064,7561,40855,12205,2,2533,'App\\Models\\Receipt',2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',20000.00,NULL,NULL,1,'2023-04-18 14:11:20','2023-04-18 14:11:20',NULL),(3065,7561,40855,12206,2,2534,'App\\Models\\Receipt',2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',22900.00,NULL,NULL,1,'2023-04-18 14:12:03','2023-04-18 14:12:03',NULL),(3066,7561,40855,12206,2,2535,'App\\Models\\Receipt',2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',88985.00,NULL,NULL,1,'2023-04-18 14:12:03','2023-04-18 14:12:03',NULL),(3067,7561,40855,12206,2,2536,'App\\Models\\Receipt',2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',37147.50,NULL,NULL,1,'2023-04-18 14:12:03','2023-04-18 14:12:03',NULL),(3068,7561,40855,12206,2,2537,'App\\Models\\Receipt',2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',109280.95,NULL,NULL,1,'2023-04-18 14:12:03','2023-04-18 14:12:03',NULL),(3069,7561,40855,12206,2,2538,'App\\Models\\Receipt',2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',121281.00,NULL,NULL,1,'2023-04-18 14:12:03','2023-04-18 14:12:03',NULL),(3070,7561,40855,12206,2,2539,'App\\Models\\Receipt',2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',125675.00,NULL,NULL,1,'2023-04-18 14:12:03','2023-04-18 14:12:03',NULL),(3071,7561,40855,12206,2,2540,'App\\Models\\Receipt',2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',124960.00,NULL,NULL,1,'2023-04-18 14:12:03','2023-04-18 14:12:03',NULL),(3072,7561,40855,12206,2,2541,'App\\Models\\Receipt',2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',10726.20,NULL,NULL,1,'2023-04-18 14:12:03','2023-04-18 14:12:03',NULL),(3073,7561,40855,12206,2,2542,'App\\Models\\Receipt',2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',59930.00,NULL,NULL,1,'2023-04-18 14:12:03','2023-04-18 14:12:03',NULL),(3074,7561,40855,12206,2,2543,'App\\Models\\Receipt',2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',40190.00,NULL,NULL,1,'2023-04-18 14:12:03','2023-04-18 14:12:03',NULL),(3075,7561,40855,12206,2,2544,'App\\Models\\Receipt',2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',6940.00,NULL,NULL,1,'2023-04-18 14:12:03','2023-04-18 14:12:03',NULL),(3076,7561,40850,4556,2,2545,'App\\Models\\Receipt',2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3077,7561,40850,4556,2,2546,'App\\Models\\Receipt',2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3078,7561,40850,4556,2,2547,'App\\Models\\Receipt',2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3079,7561,40850,4556,2,2548,'App\\Models\\Receipt',2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3080,7561,40850,4556,2,2549,'App\\Models\\Receipt',2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3081,7561,40850,4556,2,2550,'App\\Models\\Receipt',2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3082,7561,40850,4556,2,2551,'App\\Models\\Receipt',2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3083,7561,40850,4556,2,2552,'App\\Models\\Receipt',2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3084,7561,40850,4556,2,2553,'App\\Models\\Receipt',2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL);
INSERT INTO `balance_libro` VALUES (3085,7561,40850,4556,2,2554,'App\\Models\\Receipt',2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3086,7561,40850,4556,2,2555,'App\\Models\\Receipt',2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3087,7561,40850,4556,2,2556,'App\\Models\\Receipt',2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3088,7561,40850,4556,2,2557,'App\\Models\\Receipt',2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3089,7561,40850,4556,2,2558,'App\\Models\\Receipt',2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3090,7561,40850,4556,2,2559,'App\\Models\\Receipt',2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3091,7561,40850,4556,2,2560,'App\\Models\\Receipt',2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3092,7561,40850,4556,2,2561,'App\\Models\\Receipt',2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3093,7561,40850,4556,2,2562,'App\\Models\\Receipt',2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3094,7561,40850,4556,2,2563,'App\\Models\\Receipt',2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3095,7561,40850,4556,2,2564,'App\\Models\\Receipt',2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3096,7561,40850,4556,2,2565,'App\\Models\\Receipt',2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3097,7561,40850,4556,2,2566,'App\\Models\\Receipt',2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',3000.00,NULL,NULL,1,'2023-04-18 17:02:19','2023-04-18 17:02:19',NULL),(3098,7561,40850,4556,2,2567,'App\\Models\\Receipt',2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3099,7561,40850,4556,2,2568,'App\\Models\\Receipt',2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3100,7561,40850,4556,2,2569,'App\\Models\\Receipt',2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3101,7561,40850,4556,2,2570,'App\\Models\\Receipt',2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3102,7561,40850,4556,2,2571,'App\\Models\\Receipt',2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3103,7561,40850,4556,2,2572,'App\\Models\\Receipt',2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3104,7561,40850,4556,2,2573,'App\\Models\\Receipt',2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3105,7561,40850,4556,2,2574,'App\\Models\\Receipt',2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL);
INSERT INTO `balance_libro` VALUES (3106,7561,40850,4556,2,2575,'App\\Models\\Receipt',2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3107,7561,40850,4556,2,2576,'App\\Models\\Receipt',2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3108,7561,40850,4556,2,2577,'App\\Models\\Receipt',2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3109,7561,40850,4556,2,2578,'App\\Models\\Receipt',2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3110,7561,40850,4556,2,2579,'App\\Models\\Receipt',2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3111,7561,40850,4556,2,2580,'App\\Models\\Receipt',2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3112,7561,40850,4556,2,2581,'App\\Models\\Receipt',2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3113,7561,40850,4556,2,2582,'App\\Models\\Receipt',2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3114,7561,40850,4556,2,2583,'App\\Models\\Receipt',2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3115,7561,40850,4556,2,2584,'App\\Models\\Receipt',2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3116,7561,40850,4556,2,2585,'App\\Models\\Receipt',2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3117,7561,40850,4556,2,2586,'App\\Models\\Receipt',2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3118,7561,40850,4556,2,2587,'App\\Models\\Receipt',2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3119,7561,40850,4556,2,2588,'App\\Models\\Receipt',2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3120,7561,40850,4556,2,2589,'App\\Models\\Receipt',2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3121,7561,40850,4556,2,2590,'App\\Models\\Receipt',2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3122,7561,40850,4556,2,2591,'App\\Models\\Receipt',2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3123,7561,40850,4556,2,2592,'App\\Models\\Receipt',2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3124,7561,40850,4556,2,2593,'App\\Models\\Receipt',2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3125,7561,40850,4556,2,2594,'App\\Models\\Receipt',2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3126,7561,40850,4556,2,2595,'App\\Models\\Receipt',2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL);
INSERT INTO `balance_libro` VALUES (3127,7561,40850,4556,2,2596,'App\\Models\\Receipt',2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',3000.00,NULL,NULL,1,'2023-04-18 17:02:20','2023-04-18 17:02:20',NULL),(3128,7561,40850,4556,2,2597,'App\\Models\\Receipt',2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3000.00,NULL,NULL,1,'2023-04-18 17:02:21','2023-04-18 17:02:21',NULL),(3129,7561,40850,4556,2,2598,'App\\Models\\Receipt',2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3000.00,NULL,NULL,1,'2023-04-18 17:02:21','2023-04-18 17:02:21',NULL),(3130,7561,40850,4556,2,2599,'App\\Models\\Receipt',2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3000.00,NULL,NULL,1,'2023-04-18 17:02:21','2023-04-18 17:02:21',NULL),(3131,7561,40725,3027,3,2600,'App\\Models\\Receipt',2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',1834.86,NULL,NULL,1,'2023-04-21 09:01:17','2023-04-21 10:50:41','2023-04-21 10:50:41'),(3132,7561,40725,3027,3,2601,'App\\Models\\Receipt',2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',20450.54,NULL,NULL,1,'2023-04-21 09:01:17','2023-04-21 10:50:41','2023-04-21 10:50:41'),(3133,7561,40725,3027,3,2602,'App\\Models\\Receipt',2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',69176.18,NULL,NULL,1,'2023-04-21 09:01:17','2023-04-21 10:50:41','2023-04-21 10:50:41'),(3134,7561,40725,3027,3,2603,'App\\Models\\Receipt',2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',4050.48,NULL,NULL,1,'2023-04-21 09:01:17','2023-04-21 10:50:41','2023-04-21 10:50:41'),(3135,7561,40725,3027,3,2604,'App\\Models\\Receipt',2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',4886.33,NULL,NULL,1,'2023-04-21 09:01:17','2023-04-21 10:50:41','2023-04-21 10:50:41'),(3136,7561,40725,3027,3,2605,'App\\Models\\Receipt',2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',475912.50,NULL,NULL,1,'2023-04-21 09:01:17','2023-04-21 10:50:41','2023-04-21 10:50:41'),(3137,7561,40725,3027,3,2606,'App\\Models\\Receipt',2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',475912.50,NULL,NULL,1,'2023-04-21 09:01:17','2023-04-21 10:50:41','2023-04-21 10:50:41'),(3138,7561,40725,3027,3,2607,'App\\Models\\Receipt',2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',426300.00,NULL,NULL,1,'2023-04-21 09:01:17','2023-04-21 10:50:41','2023-04-21 10:50:41'),(3139,7561,40725,3027,3,2608,'App\\Models\\Receipt',2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',2935.47,NULL,NULL,1,'2023-04-21 09:01:17','2023-04-21 10:50:41','2023-04-21 10:50:41'),(3140,7561,40725,3027,3,2609,'App\\Models\\Receipt',2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',1843.54,NULL,NULL,1,'2023-04-21 09:01:17','2023-04-21 10:50:41','2023-04-21 10:50:41'),(3141,7561,40725,3027,3,2610,'App\\Models\\Receipt',2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',1351.29,NULL,NULL,1,'2023-04-21 09:01:17','2023-04-21 10:50:41','2023-04-21 10:50:41'),(3142,7561,40725,3027,3,2611,'App\\Models\\Receipt',2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',475912.50,NULL,NULL,1,'2023-04-21 09:01:17','2023-04-21 10:50:41','2023-04-21 10:50:41'),(3143,7561,40725,3027,3,2612,'App\\Models\\Receipt',2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',511.77,NULL,NULL,1,'2023-04-21 09:01:17','2023-04-21 10:50:41','2023-04-21 10:50:41'),(3144,7561,40725,3027,3,2613,'App\\Models\\Receipt',2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',4465.51,NULL,NULL,1,'2023-04-21 09:01:17','2023-04-21 10:50:41','2023-04-21 10:50:41'),(3145,7561,40725,3027,3,2614,'App\\Models\\Receipt',2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',2200.01,NULL,NULL,1,'2023-04-21 09:01:17','2023-04-21 10:50:41','2023-04-21 10:50:41');
INSERT INTO `balance_libro` VALUES (3146,7561,40725,3027,3,2615,'App\\Models\\Receipt',2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',274.94,NULL,NULL,1,'2023-04-21 09:01:18','2023-04-21 10:50:41','2023-04-21 10:50:41'),(3147,7561,40725,3027,3,2616,'App\\Models\\Receipt',2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',4747.24,NULL,NULL,1,'2023-04-21 09:01:18','2023-04-21 10:50:41','2023-04-21 10:50:41'),(3148,7561,40725,3027,3,2617,'App\\Models\\Receipt',2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',4191.77,NULL,NULL,1,'2023-04-21 09:01:18','2023-04-21 10:50:41','2023-04-21 10:50:41'),(3149,7561,40725,3027,3,2618,'App\\Models\\Receipt',2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',3204.51,NULL,NULL,1,'2023-04-21 09:01:18','2023-04-21 10:50:41','2023-04-21 10:50:41'),(3150,7561,40725,3027,2,2619,'App\\Models\\Receipt',2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',49713.50,NULL,NULL,1,'2023-04-21 09:45:22','2023-04-21 10:44:10','2023-04-21 10:44:10'),(3151,7561,40725,3027,2,2620,'App\\Models\\Receipt',2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',20146.50,NULL,NULL,1,'2023-04-21 09:45:23','2023-04-21 10:44:10','2023-04-21 10:44:10'),(3152,7561,40725,3027,2,2621,'App\\Models\\Receipt',2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',86880.54,NULL,NULL,1,'2023-04-21 09:45:23','2023-04-21 10:44:10','2023-04-21 10:44:10'),(3153,7561,40725,3027,2,2622,'App\\Models\\Receipt',2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',37510.00,NULL,NULL,1,'2023-04-21 09:45:23','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3154,7561,40725,3027,2,2623,'App\\Models\\Receipt',2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',43248.47,NULL,NULL,1,'2023-04-21 09:45:23','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3155,7561,40725,3027,2,2624,'App\\Models\\Receipt',2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',8545.02,NULL,NULL,1,'2023-04-21 09:45:23','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3156,7561,40725,3027,2,2625,'App\\Models\\Receipt',2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',119644.80,NULL,NULL,1,'2023-04-21 09:45:23','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3157,7561,40725,3027,2,2626,'App\\Models\\Receipt',2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',27817.90,NULL,NULL,1,'2023-04-21 09:45:23','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3158,7561,40725,3027,2,2627,'App\\Models\\Receipt',2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',3940.00,NULL,NULL,1,'2023-04-21 09:45:23','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3159,7561,40725,3027,2,2628,'App\\Models\\Receipt',2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',620511.99,NULL,NULL,1,'2023-04-21 09:45:23','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3160,7561,40725,3027,2,2629,'App\\Models\\Receipt',2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',165859.54,NULL,NULL,1,'2023-04-21 09:45:23','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3161,7561,40725,3027,2,2630,'App\\Models\\Receipt',2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',139874.30,NULL,NULL,1,'2023-04-21 09:45:23','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3162,7561,40725,3027,2,2631,'App\\Models\\Receipt',2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',140126.77,NULL,NULL,1,'2023-04-21 09:45:23','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3163,7561,40725,3027,2,2632,'App\\Models\\Receipt',2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',233263.80,NULL,NULL,1,'2023-04-21 09:45:23','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3164,7561,40725,3027,2,2633,'App\\Models\\Receipt',2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',24879.86,NULL,NULL,1,'2023-04-21 09:45:23','2023-04-21 10:44:11','2023-04-21 10:44:11');
INSERT INTO `balance_libro` VALUES (3165,7561,40725,3027,2,2634,'App\\Models\\Receipt',2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',142744.53,NULL,NULL,1,'2023-04-21 09:45:23','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3166,7561,40725,3027,2,2635,'App\\Models\\Receipt',2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',64461.66,NULL,NULL,1,'2023-04-21 09:45:23','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3167,7561,40725,3027,2,2636,'App\\Models\\Receipt',2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',129406.45,NULL,NULL,1,'2023-04-21 09:45:23','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3168,7561,40725,3028,2,2637,'App\\Models\\Receipt',2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',26899.51,NULL,NULL,1,'2023-04-21 09:46:32','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3169,7561,40725,3028,2,2638,'App\\Models\\Receipt',2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',4864.20,NULL,NULL,1,'2023-04-21 09:46:32','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3170,7561,40725,3028,2,2639,'App\\Models\\Receipt',2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',75382.86,NULL,NULL,1,'2023-04-21 09:46:32','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3171,7561,40725,3028,2,2640,'App\\Models\\Receipt',2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',149961.35,NULL,NULL,1,'2023-04-21 09:46:32','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3172,7561,40725,3028,2,2641,'App\\Models\\Receipt',2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',17811.20,NULL,NULL,1,'2023-04-21 09:46:32','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3173,7561,40725,3028,2,2642,'App\\Models\\Receipt',2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',82803.76,NULL,NULL,1,'2023-04-21 09:46:32','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3174,7561,40725,3028,2,2643,'App\\Models\\Receipt',2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',19541.50,NULL,NULL,1,'2023-04-21 09:46:32','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3175,7561,40725,3028,2,2644,'App\\Models\\Receipt',2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',31339.00,NULL,NULL,1,'2023-04-21 09:46:32','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3176,7561,40725,3028,2,2645,'App\\Models\\Receipt',2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30956.58,NULL,NULL,1,'2023-04-21 09:46:32','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3177,7561,40725,3028,2,2646,'App\\Models\\Receipt',2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',61265.95,NULL,NULL,1,'2023-04-21 09:46:32','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3178,7561,40725,3028,2,2647,'App\\Models\\Receipt',2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',61334.90,NULL,NULL,1,'2023-04-21 09:46:32','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3179,7561,40725,3028,2,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',69913.80,NULL,NULL,1,'2023-04-21 09:46:32','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3180,7561,40725,3028,2,2649,'App\\Models\\Receipt',2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',31353.18,NULL,NULL,1,'2023-04-21 09:46:32','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3181,7561,40725,3028,2,2650,'App\\Models\\Receipt',2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',18471.86,NULL,NULL,1,'2023-04-21 09:46:32','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3182,7561,40725,3028,2,2651,'App\\Models\\Receipt',2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',89222.98,NULL,NULL,1,'2023-04-21 09:46:32','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3183,7561,40725,3028,2,2652,'App\\Models\\Receipt',2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',67260.56,NULL,NULL,1,'2023-04-21 09:46:32','2023-04-21 10:44:11','2023-04-21 10:44:11');
INSERT INTO `balance_libro` VALUES (3184,7561,40725,3028,2,2653,'App\\Models\\Receipt',2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',52659.20,NULL,NULL,1,'2023-04-21 09:46:32','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3185,7561,40725,3028,2,2654,'App\\Models\\Receipt',2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',201727.13,NULL,NULL,1,'2023-04-21 09:46:32','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3186,7561,40725,3028,2,2655,'App\\Models\\Receipt',2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',25745.25,NULL,NULL,1,'2023-04-21 09:46:32','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3187,7561,40725,3029,2,2656,'App\\Models\\Receipt',2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',28182.11,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3188,7561,40725,3029,2,2657,'App\\Models\\Receipt',2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',68506.76,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3189,7561,40725,3029,2,2658,'App\\Models\\Receipt',2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',20234.83,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3190,7561,40725,3029,2,2659,'App\\Models\\Receipt',2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',25855.28,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3191,7561,40725,3029,2,2660,'App\\Models\\Receipt',2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',45040.60,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3192,7561,40725,3029,2,2661,'App\\Models\\Receipt',2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',40601.55,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3193,7561,40725,3029,2,2662,'App\\Models\\Receipt',2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',38513.41,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3194,7561,40725,3029,2,2663,'App\\Models\\Receipt',2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',97792.20,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3195,7561,40725,3029,2,2664,'App\\Models\\Receipt',2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',36364.13,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3196,7561,40725,3029,2,2665,'App\\Models\\Receipt',2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',6897.00,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3197,7561,40725,3029,2,2666,'App\\Models\\Receipt',2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',73052.54,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3198,7561,40725,3029,2,2667,'App\\Models\\Receipt',2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',22152.68,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3199,7561,40725,3029,2,2668,'App\\Models\\Receipt',2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',4560.00,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3200,7561,40725,3029,2,2669,'App\\Models\\Receipt',2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',27264.93,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3201,7561,40725,3029,2,2670,'App\\Models\\Receipt',2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',41817.60,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3202,7561,40725,3029,2,2671,'App\\Models\\Receipt',2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',21961.50,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11');
INSERT INTO `balance_libro` VALUES (3203,7561,40725,3029,2,2672,'App\\Models\\Receipt',2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',21961.50,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3204,7561,40725,3029,2,2673,'App\\Models\\Receipt',2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',53084.93,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3205,7561,40725,3029,2,2674,'App\\Models\\Receipt',2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',3200.45,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3206,7561,40725,3029,2,2675,'App\\Models\\Receipt',2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',102880.25,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3207,7561,40725,3029,2,2676,'App\\Models\\Receipt',2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',38163.40,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3208,7561,40725,3029,2,2677,'App\\Models\\Receipt',2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',24435.95,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:11','2023-04-21 10:44:11'),(3209,7561,40725,3029,2,2678,'App\\Models\\Receipt',2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',42268.27,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3210,7561,40725,3029,2,2679,'App\\Models\\Receipt',2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',38833.52,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3211,7561,40725,3029,2,2680,'App\\Models\\Receipt',2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',27470.87,NULL,NULL,1,'2023-04-21 09:46:51','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3212,7561,40725,3030,2,2681,'App\\Models\\Receipt',2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',24435.95,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3213,7561,40725,3030,2,2682,'App\\Models\\Receipt',2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',43130.45,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3214,7561,40725,3030,2,2683,'App\\Models\\Receipt',2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',51997.75,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3215,7561,40725,3030,2,2684,'App\\Models\\Receipt',2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',27569.85,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3216,7561,40725,3030,2,2685,'App\\Models\\Receipt',2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',97598.60,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3217,7561,40725,3030,2,2686,'App\\Models\\Receipt',2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',63056.28,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3218,7561,40725,3030,2,2687,'App\\Models\\Receipt',2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',535841.24,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3219,7561,40725,3030,2,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',247004.56,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3220,7561,40725,3030,2,2689,'App\\Models\\Receipt',2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',52616.85,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3221,7561,40725,3030,2,2690,'App\\Models\\Receipt',2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',136028.20,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12');
INSERT INTO `balance_libro` VALUES (3222,7561,40725,3030,2,2691,'App\\Models\\Receipt',2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',48877.95,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3223,7561,40725,3030,2,2692,'App\\Models\\Receipt',2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',66005.47,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3224,7561,40725,3030,2,2693,'App\\Models\\Receipt',2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',12080.88,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3225,7561,40725,3030,2,2694,'App\\Models\\Receipt',2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',63936.40,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3226,7561,40725,3030,2,2695,'App\\Models\\Receipt',2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',76472.00,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3227,7561,40725,3030,2,2696,'App\\Models\\Receipt',2696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',80322.12,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3228,7561,40725,3030,2,2697,'App\\Models\\Receipt',2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',18780.41,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3229,7561,40725,3030,2,2698,'App\\Models\\Receipt',2698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',28984.34,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3230,7561,40725,3030,2,2699,'App\\Models\\Receipt',2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',60938.62,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3231,7561,40725,3030,2,2700,'App\\Models\\Receipt',2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',100435.97,NULL,NULL,1,'2023-04-21 09:47:09','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3232,7561,40725,3030,2,2701,'App\\Models\\Receipt',2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',93879.83,NULL,NULL,1,'2023-04-21 09:47:10','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3233,7561,40725,3030,2,2702,'App\\Models\\Receipt',2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',61147.35,NULL,NULL,1,'2023-04-21 09:47:10','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3234,7561,40725,3030,2,2703,'App\\Models\\Receipt',2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',30435.13,NULL,NULL,1,'2023-04-21 09:47:10','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3235,7561,40725,3030,2,2704,'App\\Models\\Receipt',2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',55998.80,NULL,NULL,1,'2023-04-21 09:47:10','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3236,7561,40725,3030,2,2705,'App\\Models\\Receipt',2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',61078.79,NULL,NULL,1,'2023-04-21 09:47:10','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3237,7561,40725,3030,2,2706,'App\\Models\\Receipt',2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',10962.60,NULL,NULL,1,'2023-04-21 09:47:10','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3238,7561,40725,3030,2,2707,'App\\Models\\Receipt',2707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',19577.80,NULL,NULL,1,'2023-04-21 09:47:10','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3239,7561,40725,3030,2,2708,'App\\Models\\Receipt',2708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',39195.31,NULL,NULL,1,'2023-04-21 09:47:10','2023-04-21 10:44:12','2023-04-21 10:44:12'),(3240,7561,40725,3027,2,2709,'App\\Models\\Receipt',2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',49713.50,NULL,NULL,1,'2023-04-21 10:47:54','2023-04-22 11:31:29','2023-04-22 11:31:29');
INSERT INTO `balance_libro` VALUES (3241,7561,40725,3027,2,2710,'App\\Models\\Receipt',2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',20146.50,NULL,NULL,1,'2023-04-21 10:47:55','2023-04-25 16:52:30','2023-04-25 16:52:30'),(3242,7561,40725,3027,2,2711,'App\\Models\\Receipt',2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',86880.54,NULL,NULL,1,'2023-04-21 10:47:55','2023-04-21 10:47:55',NULL),(3243,7561,40725,3027,2,2712,'App\\Models\\Receipt',2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',37510.00,NULL,NULL,1,'2023-04-21 10:47:55','2023-04-25 16:49:05','2023-04-25 16:49:05'),(3244,7561,40725,3027,2,2713,'App\\Models\\Receipt',2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',43248.47,NULL,NULL,1,'2023-04-21 10:47:55','2023-04-21 10:47:55',NULL),(3245,7561,40725,3027,2,2714,'App\\Models\\Receipt',2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',8545.02,NULL,NULL,1,'2023-04-21 10:47:55','2023-04-22 11:34:05','2023-04-22 11:34:05'),(3246,7561,40725,3027,2,2715,'App\\Models\\Receipt',2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',119644.80,NULL,NULL,1,'2023-04-21 10:47:55','2023-04-25 16:47:59','2023-04-25 16:47:59'),(3247,7561,40725,3027,2,2716,'App\\Models\\Receipt',2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',27817.90,NULL,NULL,1,'2023-04-21 10:47:55','2023-04-22 11:34:34','2023-04-22 11:34:34'),(3248,7561,40725,3027,2,2717,'App\\Models\\Receipt',2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',3940.00,NULL,NULL,1,'2023-04-21 10:47:55','2023-04-22 11:32:13','2023-04-22 11:32:13'),(3249,7561,40725,3027,2,2718,'App\\Models\\Receipt',2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',620511.99,NULL,NULL,1,'2023-04-21 10:47:55','2023-04-22 11:32:52','2023-04-22 11:32:52'),(3250,7561,40725,3027,2,2719,'App\\Models\\Receipt',2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',165859.54,NULL,NULL,1,'2023-04-21 10:47:55','2023-04-25 16:17:42','2023-04-25 16:17:42'),(3251,7561,40725,3027,2,2720,'App\\Models\\Receipt',2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',139874.30,NULL,NULL,1,'2023-04-21 10:47:55','2023-04-21 10:47:55',NULL),(3252,7561,40725,3027,2,2721,'App\\Models\\Receipt',2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',140126.77,NULL,NULL,1,'2023-04-21 10:47:55','2023-04-21 10:47:55',NULL),(3253,7561,40725,3027,2,2722,'App\\Models\\Receipt',2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',233263.80,NULL,NULL,1,'2023-04-21 10:47:55','2023-04-21 10:47:55',NULL),(3254,7561,40725,3027,2,2723,'App\\Models\\Receipt',2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',24879.86,NULL,NULL,1,'2023-04-21 10:47:55','2023-04-21 10:47:55',NULL),(3255,7561,40725,3027,2,2724,'App\\Models\\Receipt',2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',142744.53,NULL,NULL,1,'2023-04-21 10:47:55','2023-04-21 10:47:55',NULL),(3256,7561,40725,3027,2,2725,'App\\Models\\Receipt',2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',64461.66,NULL,NULL,1,'2023-04-21 10:47:55','2023-04-25 16:16:31','2023-04-25 16:16:31'),(3257,7561,40725,3027,2,2726,'App\\Models\\Receipt',2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',129406.45,NULL,NULL,1,'2023-04-21 10:47:55','2023-04-21 10:47:55',NULL),(3258,7561,40725,3028,2,2727,'App\\Models\\Receipt',2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',26899.51,NULL,NULL,1,'2023-04-21 11:21:57','2023-04-25 16:15:21','2023-04-25 16:15:21'),(3259,7561,40725,3028,2,2728,'App\\Models\\Receipt',2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',4864.20,NULL,NULL,1,'2023-04-21 11:21:57','2023-04-25 16:14:58','2023-04-25 16:14:58'),(3260,7561,40725,3028,2,2729,'App\\Models\\Receipt',2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',75382.86,NULL,NULL,1,'2023-04-21 11:21:57','2023-04-21 11:21:57',NULL);
INSERT INTO `balance_libro` VALUES (3261,7561,40725,3028,2,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',149961.35,NULL,NULL,1,'2023-04-21 11:21:58','2023-04-25 16:14:30','2023-04-25 16:14:30'),(3262,7561,40725,3028,2,2731,'App\\Models\\Receipt',2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-13','2022-02-13',17811.20,NULL,NULL,1,'2023-04-21 11:21:58','2023-04-21 11:21:58',NULL),(3263,7561,40725,3028,2,2732,'App\\Models\\Receipt',2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',82803.76,NULL,NULL,1,'2023-04-21 11:21:58','2023-04-21 11:21:58',NULL),(3264,7561,40725,3028,2,2733,'App\\Models\\Receipt',2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',19541.50,NULL,NULL,1,'2023-04-21 11:21:58','2023-04-21 11:21:58',NULL),(3265,7561,40725,3028,2,2734,'App\\Models\\Receipt',2734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',31339.00,NULL,NULL,1,'2023-04-21 11:21:58','2023-04-21 11:21:58',NULL),(3266,7561,40725,3028,2,2735,'App\\Models\\Receipt',2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',30956.58,NULL,NULL,1,'2023-04-21 11:21:58','2023-04-21 11:21:58',NULL),(3267,7561,40725,3028,2,2736,'App\\Models\\Receipt',2736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',61265.95,NULL,NULL,1,'2023-04-21 11:21:58','2023-04-21 11:21:58',NULL),(3268,7561,40725,3028,2,2737,'App\\Models\\Receipt',2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',61334.90,NULL,NULL,1,'2023-04-21 11:21:58','2023-04-21 11:21:58',NULL),(3269,7561,40725,3028,2,2738,'App\\Models\\Receipt',2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',69913.80,NULL,NULL,1,'2023-04-21 11:21:58','2023-04-21 11:21:58',NULL),(3270,7561,40725,3028,2,2739,'App\\Models\\Receipt',2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',31353.18,NULL,NULL,1,'2023-04-21 11:21:58','2023-04-21 11:21:58',NULL),(3271,7561,40725,3028,2,2740,'App\\Models\\Receipt',2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',18471.86,NULL,NULL,1,'2023-04-21 11:21:58','2023-04-25 16:10:56','2023-04-25 16:10:56'),(3272,7561,40725,3028,2,2741,'App\\Models\\Receipt',2741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',89222.98,NULL,NULL,1,'2023-04-21 11:21:58','2023-04-21 11:21:58',NULL),(3273,7561,40725,3028,2,2742,'App\\Models\\Receipt',2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',67260.56,NULL,NULL,1,'2023-04-21 11:21:58','2023-04-25 16:10:10','2023-04-25 16:10:10'),(3274,7561,40725,3028,2,2743,'App\\Models\\Receipt',2743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',52659.20,NULL,NULL,1,'2023-04-21 11:21:58','2023-04-21 11:21:58',NULL),(3275,7561,40725,3028,2,2744,'App\\Models\\Receipt',2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',201727.13,NULL,NULL,1,'2023-04-21 11:21:58','2023-04-21 11:21:58',NULL),(3276,7561,40725,3028,2,2745,'App\\Models\\Receipt',2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',25745.25,NULL,NULL,1,'2023-04-21 11:21:58','2023-04-21 11:21:58',NULL),(3277,7561,40725,3029,2,2746,'App\\Models\\Receipt',2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',28182.11,NULL,NULL,1,'2023-04-21 11:22:58','2023-04-25 16:08:27','2023-04-25 16:08:27'),(3278,7561,40725,3029,2,2747,'App\\Models\\Receipt',2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',68506.76,NULL,NULL,1,'2023-04-21 11:22:58','2023-04-21 11:22:58',NULL),(3279,7561,40725,3029,2,2748,'App\\Models\\Receipt',2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',20234.83,NULL,NULL,1,'2023-04-21 11:22:58','2023-04-25 16:07:30','2023-04-25 16:07:30'),(3280,7561,40725,3029,2,2749,'App\\Models\\Receipt',2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',25855.28,NULL,NULL,1,'2023-04-21 11:22:58','2023-04-25 16:06:26','2023-04-25 16:06:26');
INSERT INTO `balance_libro` VALUES (3281,7561,40725,3029,2,2750,'App\\Models\\Receipt',2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',45040.60,NULL,NULL,1,'2023-04-21 11:22:58','2023-04-25 16:05:53','2023-04-25 16:05:53'),(3282,7561,40725,3029,2,2751,'App\\Models\\Receipt',2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',40601.55,NULL,NULL,1,'2023-04-21 11:22:58','2023-04-25 16:05:08','2023-04-25 16:05:08'),(3283,7561,40725,3029,2,2752,'App\\Models\\Receipt',2752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',38513.41,NULL,NULL,1,'2023-04-21 11:22:58','2023-04-21 11:22:58',NULL),(3284,7561,40725,3029,2,2753,'App\\Models\\Receipt',2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',97792.20,NULL,NULL,1,'2023-04-21 11:22:58','2023-04-25 16:01:34','2023-04-25 16:01:34'),(3285,7561,40725,3029,2,2754,'App\\Models\\Receipt',2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',36364.13,NULL,NULL,1,'2023-04-21 11:22:58','2023-04-25 16:01:06','2023-04-25 16:01:06'),(3286,7561,40725,3029,2,2755,'App\\Models\\Receipt',2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',6897.00,NULL,NULL,1,'2023-04-21 11:22:58','2023-04-21 11:22:58',NULL),(3287,7561,40725,3029,2,2756,'App\\Models\\Receipt',2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',73052.54,NULL,NULL,1,'2023-04-21 11:22:58','2023-04-25 15:57:44','2023-04-25 15:57:44'),(3288,7561,40725,3029,2,2757,'App\\Models\\Receipt',2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',22152.68,NULL,NULL,1,'2023-04-21 11:22:58','2023-04-25 15:56:50','2023-04-25 15:56:50'),(3289,7561,40725,3029,2,2758,'App\\Models\\Receipt',2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',4560.00,NULL,NULL,1,'2023-04-21 11:22:58','2023-04-25 15:55:57','2023-04-25 15:55:57'),(3290,7561,40725,3029,2,2759,'App\\Models\\Receipt',2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',27264.93,NULL,NULL,1,'2023-04-21 11:22:58','2023-04-25 15:54:52','2023-04-25 15:54:52'),(3291,7561,40725,3029,2,2760,'App\\Models\\Receipt',2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',41817.60,NULL,NULL,1,'2023-04-21 11:22:59','2023-04-25 15:54:16','2023-04-25 15:54:16'),(3292,7561,40725,3029,2,2761,'App\\Models\\Receipt',2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',21961.50,NULL,NULL,1,'2023-04-21 11:22:59','2023-04-25 15:53:48','2023-04-25 15:53:48'),(3293,7561,40725,3029,2,2762,'App\\Models\\Receipt',2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',21961.50,NULL,NULL,1,'2023-04-21 11:22:59','2023-04-25 15:53:18','2023-04-25 15:53:18'),(3294,7561,40725,3029,2,2763,'App\\Models\\Receipt',2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',53084.93,NULL,NULL,1,'2023-04-21 11:22:59','2023-04-21 11:22:59',NULL),(3295,7561,40725,3029,2,2764,'App\\Models\\Receipt',2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',3200.45,NULL,NULL,1,'2023-04-21 11:22:59','2023-04-21 11:22:59',NULL),(3296,7561,40725,3029,2,2765,'App\\Models\\Receipt',2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',102880.25,NULL,NULL,1,'2023-04-21 11:22:59','2023-04-25 15:52:45','2023-04-25 15:52:45'),(3297,7561,40725,3029,2,2766,'App\\Models\\Receipt',2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',38163.40,NULL,NULL,1,'2023-04-21 11:22:59','2023-04-21 11:22:59',NULL),(3298,7561,40725,3029,2,2767,'App\\Models\\Receipt',2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',24435.95,NULL,NULL,1,'2023-04-21 11:22:59','2023-04-25 15:50:36','2023-04-25 15:50:36'),(3299,7561,40725,3029,2,2768,'App\\Models\\Receipt',2768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',42268.27,NULL,NULL,1,'2023-04-21 11:22:59','2023-04-21 11:22:59',NULL);
INSERT INTO `balance_libro` VALUES (3300,7561,40725,3029,2,2769,'App\\Models\\Receipt',2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',38833.52,NULL,NULL,1,'2023-04-21 11:22:59','2023-04-25 15:44:51','2023-04-25 15:44:51'),(3301,7561,40725,3029,2,2770,'App\\Models\\Receipt',2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',27470.87,NULL,NULL,1,'2023-04-21 11:22:59','2023-04-25 15:49:58','2023-04-25 15:49:58'),(3302,7561,40725,3030,2,2771,'App\\Models\\Receipt',2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',24435.95,NULL,NULL,1,'2023-04-21 11:23:37','2023-04-25 15:44:05','2023-04-25 15:44:05'),(3303,7561,40725,3030,2,2772,'App\\Models\\Receipt',2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',43130.45,NULL,NULL,1,'2023-04-21 11:23:37','2023-04-25 15:43:39','2023-04-25 15:43:39'),(3304,7561,40725,3030,2,2773,'App\\Models\\Receipt',2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',51997.75,NULL,NULL,1,'2023-04-21 11:23:37','2023-04-21 11:23:37',NULL),(3305,7561,40725,3030,2,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',27569.85,NULL,NULL,1,'2023-04-21 11:23:37','2023-04-25 15:43:01','2023-04-25 15:43:01'),(3306,7561,40725,3030,2,2775,'App\\Models\\Receipt',2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',97598.60,NULL,NULL,1,'2023-04-21 11:23:37','2023-04-25 15:42:37','2023-04-25 15:42:37'),(3307,7561,40725,3030,2,2776,'App\\Models\\Receipt',2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',63056.28,NULL,NULL,1,'2023-04-21 11:23:37','2023-04-21 11:23:37',NULL),(3308,7561,40725,3030,2,2777,'App\\Models\\Receipt',2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',535841.24,NULL,NULL,1,'2023-04-21 11:23:37','2023-04-25 15:41:40','2023-04-25 15:41:40'),(3309,7561,40725,3030,2,2778,'App\\Models\\Receipt',2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',247004.56,NULL,NULL,1,'2023-04-21 11:23:37','2023-04-21 11:23:37',NULL),(3310,7561,40725,3030,2,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',52616.85,NULL,NULL,1,'2023-04-21 11:23:37','2023-04-25 15:40:08','2023-04-25 15:40:08'),(3311,7561,40725,3030,2,2780,'App\\Models\\Receipt',2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-17','2022-04-17',136028.20,NULL,NULL,1,'2023-04-21 11:23:37','2023-04-25 15:39:46','2023-04-25 15:39:46'),(3312,7561,40725,3030,2,2781,'App\\Models\\Receipt',2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-17','2022-04-17',48877.95,NULL,NULL,1,'2023-04-21 11:23:37','2023-04-25 15:39:24','2023-04-25 15:39:24'),(3313,7561,40725,3030,2,2782,'App\\Models\\Receipt',2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',66005.47,NULL,NULL,1,'2023-04-21 11:23:37','2023-04-21 11:23:37',NULL),(3314,7561,40725,3030,2,2783,'App\\Models\\Receipt',2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',12080.88,NULL,NULL,1,'2023-04-21 11:23:38','2023-04-25 15:39:02','2023-04-25 15:39:02'),(3315,7561,40725,3030,2,2784,'App\\Models\\Receipt',2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',63936.40,NULL,NULL,1,'2023-04-21 11:23:38','2023-04-21 11:23:38',NULL),(3316,7561,40725,3030,2,2785,'App\\Models\\Receipt',2785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',76472.00,NULL,NULL,1,'2023-04-21 11:23:38','2023-04-21 11:23:38',NULL),(3317,7561,40725,3030,2,2786,'App\\Models\\Receipt',2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',80322.12,NULL,NULL,1,'2023-04-21 11:23:38','2023-04-25 15:37:46','2023-04-25 15:37:46'),(3318,7561,40725,3030,2,2787,'App\\Models\\Receipt',2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',18780.41,NULL,NULL,1,'2023-04-21 11:23:38','2023-04-21 11:23:38',NULL);
INSERT INTO `balance_libro` VALUES (3319,7561,40725,3030,2,2788,'App\\Models\\Receipt',2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',28984.34,NULL,NULL,1,'2023-04-21 11:23:38','2023-04-25 15:36:33','2023-04-25 15:36:33'),(3320,7561,40725,3030,2,2789,'App\\Models\\Receipt',2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',60938.62,NULL,NULL,1,'2023-04-21 11:23:38','2023-04-21 11:23:38',NULL),(3321,7561,40725,3030,2,2790,'App\\Models\\Receipt',2790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',100435.97,NULL,NULL,1,'2023-04-21 11:23:38','2023-04-21 11:23:38',NULL),(3322,7561,40725,3030,2,2791,'App\\Models\\Receipt',2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',93879.83,NULL,NULL,1,'2023-04-21 11:23:38','2023-04-25 15:35:20','2023-04-25 15:35:20'),(3323,7561,40725,3030,2,2792,'App\\Models\\Receipt',2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',61147.35,NULL,NULL,1,'2023-04-21 11:23:38','2023-04-25 15:34:30','2023-04-25 15:34:30'),(3324,7561,40725,3030,2,2793,'App\\Models\\Receipt',2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',30435.13,NULL,NULL,1,'2023-04-21 11:23:38','2023-04-25 15:33:59','2023-04-25 15:33:59'),(3325,7561,40725,3030,2,2794,'App\\Models\\Receipt',2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',55998.80,NULL,NULL,1,'2023-04-21 11:23:38','2023-04-25 15:33:04','2023-04-25 15:33:04'),(3326,7561,40725,3030,2,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',61078.79,NULL,NULL,1,'2023-04-21 11:23:38','2023-04-25 15:32:25','2023-04-25 15:32:25'),(3327,7561,40725,3030,2,2796,'App\\Models\\Receipt',2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',10962.60,NULL,NULL,1,'2023-04-21 11:23:38','2023-04-25 15:31:35','2023-04-25 15:31:35'),(3328,7561,40725,3030,2,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',19577.80,NULL,NULL,1,'2023-04-21 11:23:38','2023-04-25 15:30:48','2023-04-25 15:30:48'),(3329,7561,40725,3030,2,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',39195.31,NULL,NULL,1,'2023-04-21 11:23:38','2023-04-25 15:30:21','2023-04-25 15:30:21'),(3330,7561,40725,3031,2,2799,'App\\Models\\Receipt',2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',100885.31,NULL,NULL,1,'2023-04-21 11:38:51','2023-04-21 11:38:51',NULL),(3331,7561,40725,3031,2,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',6425.10,NULL,NULL,1,'2023-04-21 11:38:51','2023-04-21 11:38:51',NULL),(3332,7561,40725,3031,2,2801,'App\\Models\\Receipt',2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',25545.08,NULL,NULL,1,'2023-04-21 11:38:51','2023-04-25 15:28:43','2023-04-25 15:28:43'),(3333,7561,40725,3031,2,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',16226.10,NULL,NULL,1,'2023-04-21 11:38:51','2023-04-25 15:28:11','2023-04-25 15:28:11'),(3334,7561,40725,3031,2,2803,'App\\Models\\Receipt',2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-08','2022-05-08',7332.60,NULL,NULL,1,'2023-04-21 11:38:51','2023-04-21 11:38:51',NULL),(3335,7561,40725,3031,2,2804,'App\\Models\\Receipt',2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-08','2022-05-08',7332.60,NULL,NULL,1,'2023-04-21 11:38:51','2023-04-21 11:38:51',NULL),(3336,7561,40725,3031,2,2805,'App\\Models\\Receipt',2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',88871.13,NULL,NULL,1,'2023-04-21 11:38:51','2023-04-21 11:38:51',NULL),(3337,7561,40725,3031,2,2806,'App\\Models\\Receipt',2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',95989.30,NULL,NULL,1,'2023-04-21 11:38:51','2023-04-25 15:27:11','2023-04-25 15:27:11');
INSERT INTO `balance_libro` VALUES (3338,7561,40725,3031,2,2807,'App\\Models\\Receipt',2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',22545.93,NULL,NULL,1,'2023-04-21 11:38:51','2023-04-25 15:26:46','2023-04-25 15:26:46'),(3339,7561,40725,3031,2,2808,'App\\Models\\Receipt',2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',14700.00,NULL,NULL,1,'2023-04-21 11:38:51','2023-04-25 15:25:19','2023-04-25 15:25:19'),(3340,7561,40725,3031,2,2809,'App\\Models\\Receipt',2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',96613.66,NULL,NULL,1,'2023-04-21 11:38:51','2023-04-25 15:25:54','2023-04-25 15:25:54'),(3341,7561,40725,3031,2,2810,'App\\Models\\Receipt',2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',6136.00,NULL,NULL,1,'2023-04-21 11:38:51','2023-04-25 15:24:02','2023-04-25 15:24:02'),(3342,7561,40725,3031,2,2811,'App\\Models\\Receipt',2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',8760.40,NULL,NULL,1,'2023-04-21 11:38:51','2023-04-25 15:24:37','2023-04-25 15:24:37'),(3343,7561,40725,3031,2,2812,'App\\Models\\Receipt',2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-15','2022-05-15',59731.31,NULL,NULL,1,'2023-04-21 11:38:51','2023-04-25 15:22:51','2023-04-25 15:22:51'),(3344,7561,40725,3031,2,2813,'App\\Models\\Receipt',2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-15','2022-05-15',68510.20,NULL,NULL,1,'2023-04-21 11:38:51','2023-04-25 15:22:09','2023-04-25 15:22:09'),(3345,7561,40725,3031,2,2814,'App\\Models\\Receipt',2814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',73342.02,NULL,NULL,1,'2023-04-21 11:38:51','2023-04-21 11:38:51',NULL),(3346,7561,40725,3031,2,2815,'App\\Models\\Receipt',2815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',347553.74,NULL,NULL,1,'2023-04-21 11:38:51','2023-04-25 15:21:23','2023-04-25 15:21:23'),(3347,7561,40725,3031,2,2816,'App\\Models\\Receipt',2816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',15495.26,NULL,NULL,1,'2023-04-21 11:38:51','2023-04-25 15:20:34','2023-04-25 15:20:34'),(3348,7561,40725,3031,2,2817,'App\\Models\\Receipt',2817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-22','2022-05-22',29403.00,NULL,NULL,1,'2023-04-21 11:38:52','2023-04-21 11:38:52',NULL),(3349,7561,40725,3031,2,2818,'App\\Models\\Receipt',2818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',63504.09,NULL,NULL,1,'2023-04-21 11:38:52','2023-04-21 11:38:52',NULL),(3350,7561,40725,3031,2,2819,'App\\Models\\Receipt',2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',109989.00,NULL,NULL,1,'2023-04-21 11:38:52','2023-04-21 11:38:52',NULL),(3351,7561,40725,3031,2,2820,'App\\Models\\Receipt',2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-25','2022-05-25',42434.70,NULL,NULL,1,'2023-04-21 11:38:52','2023-04-21 11:38:52',NULL),(3352,7561,40725,3031,2,2821,'App\\Models\\Receipt',2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-25','2022-05-25',34932.70,NULL,NULL,1,'2023-04-21 11:38:52','2023-04-21 11:38:52',NULL),(3353,7561,40725,3031,2,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-25','2022-05-25',23909.60,NULL,NULL,1,'2023-04-21 11:38:52','2023-04-25 15:17:25','2023-04-25 15:17:25'),(3354,7561,40725,3031,2,2823,'App\\Models\\Receipt',2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',6146.80,NULL,NULL,1,'2023-04-21 11:38:52','2023-04-25 15:15:31','2023-04-25 15:15:31'),(3355,7561,40725,3031,2,2824,'App\\Models\\Receipt',2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',109449.58,NULL,NULL,1,'2023-04-21 11:38:52','2023-04-21 11:38:52',NULL),(3356,7561,40725,3031,2,2825,'App\\Models\\Receipt',2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',23377.20,NULL,NULL,1,'2023-04-21 11:38:52','2023-04-21 11:38:52',NULL),(3357,7561,40725,3032,2,2826,'App\\Models\\Receipt',2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-05','2022-06-05',46098.00,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-21 11:39:07',NULL);
INSERT INTO `balance_libro` VALUES (3358,7561,40725,3032,2,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-05','2022-06-05',161700.33,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-25 15:14:00','2023-04-25 15:14:00'),(3359,7561,40725,3032,2,2828,'App\\Models\\Receipt',2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',63783.94,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-21 11:39:07',NULL),(3360,7561,40725,3032,2,2829,'App\\Models\\Receipt',2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',73630.00,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-21 11:39:07',NULL),(3361,7561,40725,3032,2,2830,'App\\Models\\Receipt',2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',45290.30,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-25 15:12:48','2023-04-25 15:12:48'),(3362,7561,40725,3032,2,2831,'App\\Models\\Receipt',2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',27084.64,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-25 15:11:59','2023-04-25 15:11:59'),(3363,7561,40725,3032,2,2832,'App\\Models\\Receipt',2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',57039.40,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-25 15:10:40','2023-04-25 15:10:40'),(3364,7561,40725,3032,2,2833,'App\\Models\\Receipt',2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',90481.91,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-21 11:39:07',NULL),(3365,7561,40725,3032,2,2834,'App\\Models\\Receipt',2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',10490.70,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-25 15:09:57','2023-04-25 15:09:57'),(3366,7561,40725,3032,2,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',92274.60,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-25 15:08:52','2023-04-25 15:08:52'),(3367,7561,40725,3032,2,2836,'App\\Models\\Receipt',2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',88713.52,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-21 11:39:07',NULL),(3368,7561,40725,3032,2,2837,'App\\Models\\Receipt',2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',76677.70,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-21 11:39:07',NULL),(3369,7561,40725,3032,2,2838,'App\\Models\\Receipt',2838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',29860.38,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-21 11:39:07',NULL),(3370,7561,40725,3032,2,2839,'App\\Models\\Receipt',2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',50699.00,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-25 15:06:33','2023-04-25 15:06:33'),(3371,7561,40725,3032,2,2840,'App\\Models\\Receipt',2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',22022.00,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-21 11:39:07',NULL),(3372,7561,40725,3032,2,2841,'App\\Models\\Receipt',2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',26414.30,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-21 11:39:07',NULL),(3373,7561,40725,3032,2,2842,'App\\Models\\Receipt',2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',60923.50,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-25 15:05:23','2023-04-25 15:05:23'),(3374,7561,40725,3032,2,2843,'App\\Models\\Receipt',2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',89588.40,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-25 15:04:50','2023-04-25 15:04:50'),(3375,7561,40725,3032,2,2844,'App\\Models\\Receipt',2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',85930.40,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-21 11:39:07',NULL),(3376,7561,40725,3032,2,2845,'App\\Models\\Receipt',2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',176224.40,NULL,NULL,1,'2023-04-21 11:39:07','2023-04-25 14:55:33','2023-04-25 14:55:33'),(3377,7561,40725,3032,2,2846,'App\\Models\\Receipt',2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',114677.02,NULL,NULL,1,'2023-04-21 11:39:08','2023-04-25 14:54:59','2023-04-25 14:54:59');
INSERT INTO `balance_libro` VALUES (3378,7561,40725,3033,2,2847,'App\\Models\\Receipt',2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',52867.01,NULL,NULL,1,'2023-04-21 11:39:21','2023-04-21 11:39:21',NULL),(3379,7561,40725,3033,2,2848,'App\\Models\\Receipt',2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',12951.84,NULL,NULL,1,'2023-04-21 11:39:21','2023-04-21 11:39:21',NULL),(3380,7561,40725,3033,2,2849,'App\\Models\\Receipt',2849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',24418.16,NULL,NULL,1,'2023-04-21 11:39:21','2023-04-21 11:39:21',NULL),(3381,7561,40725,3033,2,2850,'App\\Models\\Receipt',2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',19420.50,NULL,NULL,1,'2023-04-21 11:39:21','2023-04-25 14:52:49','2023-04-25 14:52:49'),(3382,7561,40725,3033,2,2851,'App\\Models\\Receipt',2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-10','2022-07-10',73285.74,NULL,NULL,1,'2023-04-21 11:39:21','2023-04-25 14:53:39','2023-04-25 14:53:39'),(3383,7561,40725,3033,2,2852,'App\\Models\\Receipt',2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-10','2022-07-10',51146.70,NULL,NULL,1,'2023-04-21 11:39:21','2023-04-25 14:51:57','2023-04-25 14:51:57'),(3384,7561,40725,3033,2,2853,'App\\Models\\Receipt',2853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',64134.67,NULL,NULL,1,'2023-04-21 11:39:21','2023-04-21 11:39:21',NULL),(3385,7561,40725,3033,2,2854,'App\\Models\\Receipt',2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',24684.00,NULL,NULL,1,'2023-04-21 11:39:22','2023-04-25 14:51:23','2023-04-25 14:51:23'),(3386,7561,40725,3033,2,2855,'App\\Models\\Receipt',2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',115107.30,NULL,NULL,1,'2023-04-21 11:39:22','2023-04-25 14:50:58','2023-04-25 14:50:58'),(3387,7561,40725,3033,2,2856,'App\\Models\\Receipt',2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',85547.00,NULL,NULL,1,'2023-04-21 11:39:22','2023-04-25 14:49:08','2023-04-25 14:49:08'),(3388,7561,40725,3033,2,2857,'App\\Models\\Receipt',2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',56182.79,NULL,NULL,1,'2023-04-21 11:39:22','2023-04-21 11:39:22',NULL),(3389,7561,40725,3033,2,2858,'App\\Models\\Receipt',2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',110660.25,NULL,NULL,1,'2023-04-21 11:39:22','2023-04-21 11:39:22',NULL),(3390,7561,40725,3033,2,2859,'App\\Models\\Receipt',2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',92872.34,NULL,NULL,1,'2023-04-21 11:39:22','2023-04-25 14:50:13','2023-04-25 14:50:13'),(3391,7561,40725,3033,2,2860,'App\\Models\\Receipt',2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',47667.34,NULL,NULL,1,'2023-04-21 11:39:22','2023-04-25 14:48:20','2023-04-25 14:48:20'),(3392,7561,40725,3034,2,2861,'App\\Models\\Receipt',2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',73130.93,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-21 11:39:44',NULL),(3393,7561,40725,3034,2,2862,'App\\Models\\Receipt',2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',42483.10,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-25 14:47:41','2023-04-25 14:47:41'),(3394,7561,40725,3034,2,2863,'App\\Models\\Receipt',2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-07','2022-08-07',104704.49,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-21 11:39:44',NULL),(3395,7561,40725,3034,2,2864,'App\\Models\\Receipt',2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-07','2022-08-07',156489.30,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-25 14:46:59','2023-04-25 14:46:59'),(3396,7561,40725,3034,2,2865,'App\\Models\\Receipt',2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',113194.78,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-21 11:39:44',NULL),(3397,7561,40725,3034,2,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',89154.20,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-21 11:39:44',NULL);
INSERT INTO `balance_libro` VALUES (3398,7561,40725,3034,2,2867,'App\\Models\\Receipt',2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',84185.75,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-22 12:28:34','2023-04-22 12:28:34'),(3399,7561,40725,3034,2,2868,'App\\Models\\Receipt',2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',34776.39,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-22 12:28:18','2023-04-22 12:28:18'),(3400,7561,40725,3034,2,2869,'App\\Models\\Receipt',2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',89733.60,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-22 12:27:47','2023-04-22 12:27:47'),(3401,7561,40725,3034,2,2870,'App\\Models\\Receipt',2870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',38571.82,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-21 11:39:44',NULL),(3402,7561,40725,3034,2,2871,'App\\Models\\Receipt',2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',64614.36,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-22 12:26:53','2023-04-22 12:26:53'),(3403,7561,40725,3034,2,2872,'App\\Models\\Receipt',2872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',20461.87,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-21 11:39:44',NULL),(3404,7561,40725,3034,2,2873,'App\\Models\\Receipt',2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',33915.64,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-22 12:26:01','2023-04-22 12:26:01'),(3405,7561,40725,3034,2,2874,'App\\Models\\Receipt',2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',100255.88,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-21 11:39:44',NULL),(3406,7561,40725,3034,2,2875,'App\\Models\\Receipt',2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',2238.50,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-22 12:25:24','2023-04-22 12:25:24'),(3407,7561,40725,3034,2,2876,'App\\Models\\Receipt',2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',37103.44,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-22 12:24:57','2023-04-22 12:24:57'),(3408,7561,40725,3034,2,2877,'App\\Models\\Receipt',2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',139263.74,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-22 12:21:36','2023-04-22 12:21:36'),(3409,7561,40725,3034,2,2878,'App\\Models\\Receipt',2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',80060.52,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-21 11:39:44',NULL),(3410,7561,40725,3034,2,2879,'App\\Models\\Receipt',2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',1281256.90,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-22 12:21:17','2023-04-22 12:21:17'),(3411,7561,40725,3034,2,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',22631.84,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-22 12:20:32','2023-04-22 12:20:32'),(3412,7561,40725,3034,2,2881,'App\\Models\\Receipt',2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',83861.36,NULL,NULL,1,'2023-04-21 11:39:44','2023-04-21 11:39:44',NULL),(3413,7561,40725,3035,2,2882,'App\\Models\\Receipt',2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',244273.44,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-22 12:19:51','2023-04-22 12:19:51'),(3414,7561,40725,3035,2,2883,'App\\Models\\Receipt',2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',37103.44,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-22 12:19:29','2023-04-22 12:19:29'),(3415,7561,40725,3035,2,2884,'App\\Models\\Receipt',2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',97271.36,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-21 11:40:01',NULL),(3416,7561,40725,3035,2,2885,'App\\Models\\Receipt',2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',17545.00,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-21 11:40:01',NULL);
INSERT INTO `balance_libro` VALUES (3417,7561,40725,3035,2,2886,'App\\Models\\Receipt',2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',47508.23,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-22 12:18:55','2023-04-22 12:18:55'),(3418,7561,40725,3035,2,2887,'App\\Models\\Receipt',2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',20917.92,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-21 11:40:01',NULL),(3419,7561,40725,3035,2,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',70042.30,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-21 11:40:01',NULL),(3420,7561,40725,3035,2,2889,'App\\Models\\Receipt',2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',31551.96,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-22 12:00:22','2023-04-22 12:00:22'),(3421,7561,40725,3035,2,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',86333.50,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-22 12:16:16','2023-04-22 12:16:16'),(3422,7561,40725,3035,2,2891,'App\\Models\\Receipt',2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',6300.00,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-22 12:15:23','2023-04-22 12:15:23'),(3423,7561,40725,3035,2,2892,'App\\Models\\Receipt',2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',101322.63,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-21 11:40:01',NULL),(3424,7561,40725,3035,2,2893,'App\\Models\\Receipt',2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',32716.28,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-21 11:40:01',NULL),(3425,7561,40725,3035,2,2894,'App\\Models\\Receipt',2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',44134.75,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-22 11:59:17','2023-04-22 11:59:17'),(3426,7561,40725,3035,2,2895,'App\\Models\\Receipt',2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',63131.75,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-22 11:37:56','2023-04-22 11:37:56'),(3427,7561,40725,3035,2,2896,'App\\Models\\Receipt',2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',25576.01,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-21 11:40:01',NULL),(3428,7561,40725,3035,2,2897,'App\\Models\\Receipt',2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',75101.30,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-21 11:40:01',NULL),(3429,7561,40725,3035,2,2898,'App\\Models\\Receipt',2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',78184.15,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-21 11:40:01',NULL),(3430,7561,40725,3035,2,2899,'App\\Models\\Receipt',2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',43624.31,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-22 11:58:35','2023-04-22 11:58:35'),(3431,7561,40725,3035,2,2900,'App\\Models\\Receipt',2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',66632.76,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-21 11:40:01',NULL),(3432,7561,40725,3035,2,2901,'App\\Models\\Receipt',2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',104371.57,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-22 11:57:39','2023-04-22 11:57:39'),(3433,7561,40725,3035,2,2902,'App\\Models\\Receipt',2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',22210.00,NULL,NULL,1,'2023-04-21 11:40:01','2023-04-22 11:57:15','2023-04-22 11:57:15'),(3434,7561,40725,3035,2,2903,'App\\Models\\Receipt',2903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',54026.50,NULL,NULL,1,'2023-04-21 11:40:02','2023-04-22 11:56:58','2023-04-22 11:56:58'),(3435,7561,40725,3035,2,2904,'App\\Models\\Receipt',2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',25854.72,NULL,NULL,1,'2023-04-21 11:40:02','2023-04-22 11:56:33','2023-04-22 11:56:33'),(3436,7561,40725,3035,2,2905,'App\\Models\\Receipt',2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',120344.18,NULL,NULL,1,'2023-04-21 11:40:02','2023-04-21 11:40:02',NULL);
INSERT INTO `balance_libro` VALUES (3437,7561,40725,3035,2,2906,'App\\Models\\Receipt',2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',25754.85,NULL,NULL,1,'2023-04-21 11:40:02','2023-04-22 11:55:51','2023-04-22 11:55:51'),(3438,7561,40725,3035,2,2907,'App\\Models\\Receipt',2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',55557.86,NULL,NULL,1,'2023-04-21 11:40:02','2023-04-22 11:55:13','2023-04-22 11:55:13'),(3439,7561,40725,3035,2,2908,'App\\Models\\Receipt',2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',26656.30,NULL,NULL,1,'2023-04-21 11:40:02','2023-04-22 11:54:44','2023-04-22 11:54:44'),(3440,7561,40725,3035,2,2909,'App\\Models\\Receipt',2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',96430.41,NULL,NULL,1,'2023-04-21 11:40:02','2023-04-21 11:40:02',NULL),(3441,7561,40725,3035,2,2910,'App\\Models\\Receipt',2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',51810.99,NULL,NULL,1,'2023-04-21 11:40:02','2023-04-21 11:40:02',NULL),(3442,7561,40725,3035,2,2911,'App\\Models\\Receipt',2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',49337.75,NULL,NULL,1,'2023-04-21 11:40:02','2023-04-22 11:54:19','2023-04-22 11:54:19'),(3443,7561,40725,3036,2,2912,'App\\Models\\Receipt',2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',106974.98,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-21 11:40:16',NULL),(3444,7561,40725,3036,2,2913,'App\\Models\\Receipt',2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',33270.16,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-22 11:54:04','2023-04-22 11:54:04'),(3445,7561,40725,3036,2,2914,'App\\Models\\Receipt',2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',15325.86,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-22 11:53:32','2023-04-22 11:53:32'),(3446,7561,40725,3036,2,2915,'App\\Models\\Receipt',2915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',98766.09,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-21 11:40:16',NULL),(3447,7561,40725,3036,2,2916,'App\\Models\\Receipt',2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',69950.10,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-21 11:40:16',NULL),(3448,7561,40725,3036,2,2917,'App\\Models\\Receipt',2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',23843.05,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-22 11:44:51','2023-04-22 11:44:51'),(3449,7561,40725,3036,2,2918,'App\\Models\\Receipt',2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',35150.50,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-22 11:44:29','2023-04-22 11:44:29'),(3450,7561,40725,3036,2,2919,'App\\Models\\Receipt',2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',190280.97,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-22 11:43:56','2023-04-22 11:43:56'),(3451,7561,40725,3036,2,2920,'App\\Models\\Receipt',2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',21254.86,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-22 11:43:28','2023-04-22 11:43:28'),(3452,7561,40725,3036,2,2921,'App\\Models\\Receipt',2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',29947.50,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-22 11:41:36','2023-04-22 11:41:36'),(3453,7561,40725,3036,2,2922,'App\\Models\\Receipt',2922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',102704.69,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-21 11:40:16',NULL),(3454,7561,40725,3036,2,2923,'App\\Models\\Receipt',2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',25797.20,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-22 11:41:21','2023-04-22 11:41:21'),(3455,7561,40725,3036,2,2924,'App\\Models\\Receipt',2924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',270752.62,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-21 11:40:16',NULL),(3456,7561,40725,3036,2,2925,'App\\Models\\Receipt',2925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',107261.42,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-21 11:40:16',NULL);
INSERT INTO `balance_libro` VALUES (3457,7561,40725,3036,2,2926,'App\\Models\\Receipt',2926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',238131.42,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-21 11:40:16',NULL),(3458,7561,40725,3036,2,2927,'App\\Models\\Receipt',2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',82080.35,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-22 11:40:50','2023-04-22 11:40:50'),(3459,7561,40725,3036,2,2928,'App\\Models\\Receipt',2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',84488.25,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-22 11:40:36','2023-04-22 11:40:36'),(3460,7561,40725,3036,2,2929,'App\\Models\\Receipt',2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',89443.20,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-22 11:40:20','2023-04-22 11:40:20'),(3461,7561,40725,3036,2,2930,'App\\Models\\Receipt',2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',6300.00,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-22 11:39:52','2023-04-22 11:39:52'),(3462,7561,40725,3036,2,2931,'App\\Models\\Receipt',2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',191546.41,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-21 11:40:16',NULL),(3463,7561,40725,3036,2,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',108101.40,NULL,NULL,1,'2023-04-21 11:40:16','2023-04-21 11:40:16',NULL),(3464,7561,40725,3036,2,2933,'App\\Models\\Receipt',2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',56228.70,NULL,NULL,1,'2023-04-21 11:40:17','2023-04-22 11:39:09','2023-04-22 11:39:09'),(3465,7561,40725,3036,2,2934,'App\\Models\\Receipt',2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',56228.70,NULL,NULL,1,'2023-04-21 11:40:17','2023-04-21 11:40:17',NULL),(3466,7561,40725,3036,2,2935,'App\\Models\\Receipt',2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',29931.77,NULL,NULL,1,'2023-04-21 11:40:17','2023-04-22 11:38:15','2023-04-22 11:38:15'),(3467,7561,40725,3036,2,2936,'App\\Models\\Receipt',2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',96926.24,NULL,NULL,1,'2023-04-21 11:40:17','2023-04-21 11:40:17',NULL),(3468,7561,40725,3027,3,2937,'App\\Models\\Receipt',2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1834.86,NULL,NULL,1,'2023-04-21 12:24:59','2023-04-21 12:24:59',NULL),(3469,7561,40725,3027,3,2938,'App\\Models\\Receipt',2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',20450.54,NULL,NULL,1,'2023-04-21 12:24:59','2023-04-26 12:16:23','2023-04-26 12:16:23'),(3470,7561,40725,3027,3,2939,'App\\Models\\Receipt',2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',69176.18,NULL,NULL,1,'2023-04-21 12:24:59','2023-04-26 12:19:00','2023-04-26 12:19:00'),(3471,7561,40725,3027,3,2940,'App\\Models\\Receipt',2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',4050.48,NULL,NULL,1,'2023-04-21 12:24:59','2023-04-26 12:25:51','2023-04-26 12:25:51'),(3472,7561,40725,3027,3,2941,'App\\Models\\Receipt',2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',4886.33,NULL,NULL,1,'2023-04-21 12:24:59','2023-04-21 12:24:59',NULL),(3473,7561,40725,3027,3,2942,'App\\Models\\Receipt',2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',475912.50,NULL,NULL,1,'2023-04-21 12:24:59','2023-04-21 12:24:59',NULL),(3474,7561,40725,3027,3,2943,'App\\Models\\Receipt',2943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',475912.50,NULL,NULL,1,'2023-04-21 12:24:59','2023-04-21 12:24:59',NULL),(3475,7561,40725,3027,3,2944,'App\\Models\\Receipt',2944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',426300.00,NULL,NULL,1,'2023-04-21 12:24:59','2023-04-21 12:24:59',NULL),(3476,7561,40725,3027,3,2945,'App\\Models\\Receipt',2945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',2935.47,NULL,NULL,1,'2023-04-21 12:24:59','2023-04-21 12:24:59',NULL);
INSERT INTO `balance_libro` VALUES (3477,7561,40725,3027,3,2946,'App\\Models\\Receipt',2946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',1843.54,NULL,NULL,1,'2023-04-21 12:24:59','2023-04-21 12:24:59',NULL),(3478,7561,40725,3027,3,2947,'App\\Models\\Receipt',2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',1351.29,NULL,NULL,1,'2023-04-21 12:24:59','2023-04-21 12:24:59',NULL),(3479,7561,40725,3027,3,2948,'App\\Models\\Receipt',2948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',475912.50,NULL,NULL,1,'2023-04-21 12:24:59','2023-04-21 12:24:59',NULL),(3480,7561,40725,3027,3,2949,'App\\Models\\Receipt',2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',511.77,NULL,NULL,1,'2023-04-21 12:24:59','2023-04-26 12:23:57','2023-04-26 12:23:57'),(3481,7561,40725,3027,3,2950,'App\\Models\\Receipt',2950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',4465.51,NULL,NULL,1,'2023-04-21 12:24:59','2023-04-21 12:24:59',NULL),(3482,7561,40725,3027,3,2951,'App\\Models\\Receipt',2951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',2200.01,NULL,NULL,1,'2023-04-21 12:24:59','2023-04-21 12:24:59',NULL),(3483,7561,40725,3027,3,2952,'App\\Models\\Receipt',2952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',274.94,NULL,NULL,1,'2023-04-21 12:24:59','2023-04-21 12:24:59',NULL),(3484,7561,40725,3027,3,2953,'App\\Models\\Receipt',2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',4747.24,NULL,NULL,1,'2023-04-21 12:24:59','2023-04-21 12:24:59',NULL),(3485,7561,40725,3027,3,2954,'App\\Models\\Receipt',2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',4191.77,NULL,NULL,1,'2023-04-21 12:24:59','2023-04-21 12:24:59',NULL),(3486,7561,40725,3027,3,2955,'App\\Models\\Receipt',2955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-30','2022-01-30',3204.51,NULL,NULL,1,'2023-04-21 12:24:59','2023-04-21 12:24:59',NULL),(3487,7561,40725,3028,3,2956,'App\\Models\\Receipt',2956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',2288.99,NULL,NULL,1,'2023-04-21 12:28:22','2023-04-21 12:28:22',NULL),(3488,7561,40725,3028,3,2957,'App\\Models\\Receipt',2957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',158474.24,NULL,NULL,1,'2023-04-21 12:28:22','2023-04-21 12:28:22',NULL),(3489,7561,40725,3028,3,2958,'App\\Models\\Receipt',2958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',426300.00,NULL,NULL,1,'2023-04-21 12:28:22','2023-04-21 12:28:22',NULL),(3490,7561,40725,3028,3,2959,'App\\Models\\Receipt',2959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',6897.00,NULL,NULL,1,'2023-04-21 12:28:22','2023-04-21 12:28:22',NULL),(3491,7561,40725,3028,3,2960,'App\\Models\\Receipt',2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',1351.28,NULL,NULL,1,'2023-04-21 12:28:22','2023-04-21 12:28:22',NULL),(3492,7561,40725,3028,3,2961,'App\\Models\\Receipt',2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',112.20,NULL,NULL,1,'2023-04-21 12:28:22','2023-04-21 12:28:22',NULL),(3493,7561,40725,3028,3,2962,'App\\Models\\Receipt',2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',441000.00,NULL,NULL,1,'2023-04-21 12:28:22','2023-04-21 12:34:52','2023-04-21 12:34:52'),(3494,7561,40725,3028,3,2963,'App\\Models\\Receipt',2963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',3520.00,NULL,NULL,1,'2023-04-21 12:28:22','2023-04-21 12:28:22',NULL),(3495,7561,40725,3028,3,2964,'App\\Models\\Receipt',2964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',3038.46,NULL,NULL,1,'2023-04-21 12:28:22','2023-04-21 12:28:22',NULL),(3496,7561,40725,3028,3,2965,'App\\Models\\Receipt',2965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',4000.00,NULL,NULL,1,'2023-04-21 12:28:22','2023-04-21 12:28:22',NULL),(3497,7561,40725,3028,3,2966,'App\\Models\\Receipt',2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',2500.00,NULL,NULL,1,'2023-04-21 12:28:22','2023-04-21 12:28:22',NULL);
INSERT INTO `balance_libro` VALUES (3498,7561,40725,3028,3,2967,'App\\Models\\Receipt',2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',3000.00,NULL,NULL,1,'2023-04-21 12:28:22','2023-04-21 12:28:22',NULL),(3499,7561,40725,3028,3,2968,'App\\Models\\Receipt',2968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',2800.02,NULL,NULL,1,'2023-04-21 12:28:22','2023-04-21 12:28:22',NULL),(3500,7561,40725,3028,3,2969,'App\\Models\\Receipt',2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',48660.15,NULL,NULL,1,'2023-04-21 12:28:22','2023-04-21 12:28:22',NULL),(3501,7561,40725,3028,3,2970,'App\\Models\\Receipt',2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',64599.00,NULL,NULL,1,'2023-04-21 12:28:22','2023-04-21 12:28:22',NULL),(3502,7561,40725,3028,3,2971,'App\\Models\\Receipt',2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1814.17,NULL,NULL,1,'2023-04-21 12:28:22','2023-04-21 12:28:22',NULL),(3503,7561,40725,3028,3,2962,'App\\Models\\Receipt',2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',441000.00,NULL,NULL,1,'2023-04-21 12:34:52','2023-04-21 12:34:52',NULL),(3504,7561,40725,3029,3,2972,'App\\Models\\Receipt',2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',1059.00,NULL,NULL,1,'2023-04-21 12:37:50','2023-04-21 12:37:50',NULL),(3505,7561,40725,3029,3,2973,'App\\Models\\Receipt',2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',19293.75,NULL,NULL,1,'2023-04-21 12:37:50','2023-04-21 12:37:50',NULL),(3506,7561,40725,3029,3,2974,'App\\Models\\Receipt',2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',190.00,NULL,NULL,1,'2023-04-21 12:37:50','2023-04-21 12:37:50',NULL),(3507,7561,40725,3029,3,2975,'App\\Models\\Receipt',2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',6680.00,NULL,NULL,1,'2023-04-21 12:37:50','2023-04-21 12:37:50',NULL),(3508,7561,40725,3029,3,2976,'App\\Models\\Receipt',2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',477750.00,NULL,NULL,1,'2023-04-21 12:37:50','2023-04-21 12:37:50',NULL),(3509,7561,40725,3029,3,2977,'App\\Models\\Receipt',2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',118537.65,NULL,NULL,1,'2023-04-21 12:37:50','2023-04-21 12:37:50',NULL),(3510,7561,40725,3029,3,2978,'App\\Models\\Receipt',2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',1351.29,NULL,NULL,1,'2023-04-21 12:37:50','2023-04-21 12:37:50',NULL),(3511,7561,40725,3029,3,2979,'App\\Models\\Receipt',2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',68.00,NULL,NULL,1,'2023-04-21 12:37:50','2023-04-21 12:37:50',NULL),(3512,7561,40725,3029,3,2980,'App\\Models\\Receipt',2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',63649.53,NULL,NULL,1,'2023-04-21 12:37:50','2023-04-21 12:37:50',NULL),(3513,7561,40725,3029,3,2981,'App\\Models\\Receipt',2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',53336.33,NULL,NULL,1,'2023-04-21 12:37:50','2023-04-21 12:37:50',NULL),(3514,7561,40725,3029,3,2982,'App\\Models\\Receipt',2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',361.23,NULL,NULL,1,'2023-04-21 12:37:50','2023-04-21 12:37:50',NULL),(3515,7561,40725,3029,3,2983,'App\\Models\\Receipt',2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',2043.93,NULL,NULL,1,'2023-04-21 12:37:50','2023-04-21 12:37:50',NULL),(3516,7561,40725,3029,3,2984,'App\\Models\\Receipt',2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',3000.00,NULL,NULL,1,'2023-04-21 12:37:50','2023-04-21 12:37:50',NULL),(3517,7561,40725,3029,3,2985,'App\\Models\\Receipt',2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',2500.00,NULL,NULL,1,'2023-04-21 12:37:50','2023-04-21 12:37:50',NULL),(3518,7561,40725,3029,3,2986,'App\\Models\\Receipt',2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',2600.00,NULL,NULL,1,'2023-04-21 12:37:50','2023-04-21 12:37:50',NULL);
INSERT INTO `balance_libro` VALUES (3519,7561,40725,3029,3,2987,'App\\Models\\Receipt',2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',5760.57,NULL,NULL,1,'2023-04-21 12:37:51','2023-04-21 12:37:51',NULL),(3520,7561,40725,3029,3,2988,'App\\Models\\Receipt',2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',46125.20,NULL,NULL,1,'2023-04-21 12:37:51','2023-04-21 12:37:51',NULL),(3521,7561,40725,3029,3,2989,'App\\Models\\Receipt',2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',4187.97,NULL,NULL,1,'2023-04-21 12:37:51','2023-04-21 12:37:51',NULL),(3522,7561,40725,3029,3,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1834.86,NULL,NULL,1,'2023-04-21 12:37:51','2023-04-21 12:37:51',NULL),(3523,7561,40725,3029,3,2991,'App\\Models\\Receipt',2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',4000.03,NULL,NULL,1,'2023-04-21 12:37:51','2023-04-21 12:37:51',NULL),(3524,7561,40725,3029,3,2992,'App\\Models\\Receipt',2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',9885.04,NULL,NULL,1,'2023-04-21 12:37:51','2023-04-21 12:37:51',NULL),(3525,7561,40725,3029,3,2993,'App\\Models\\Receipt',2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',4000.00,NULL,NULL,1,'2023-04-21 12:37:51','2023-04-21 12:37:51',NULL),(3526,7561,40725,3029,3,2994,'App\\Models\\Receipt',2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',3000.00,NULL,NULL,1,'2023-04-21 12:37:51','2023-04-21 12:37:51',NULL),(3527,7561,40725,3029,3,2995,'App\\Models\\Receipt',2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',524275.50,NULL,NULL,1,'2023-04-21 12:37:51','2023-04-21 12:37:51',NULL),(3528,7561,40725,3031,3,2996,'App\\Models\\Receipt',2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',2348.23,NULL,NULL,1,'2023-04-21 13:57:48','2023-04-21 13:57:48',NULL),(3529,7561,40725,3031,3,2997,'App\\Models\\Receipt',2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',1743.00,NULL,NULL,1,'2023-04-21 13:57:48','2023-04-21 13:57:48',NULL),(3530,7561,40725,3031,3,2998,'App\\Models\\Receipt',2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',100109.59,NULL,NULL,1,'2023-04-21 13:57:48','2023-04-21 13:57:48',NULL),(3531,7561,40725,3031,3,2999,'App\\Models\\Receipt',2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',13930.49,NULL,NULL,1,'2023-04-21 13:57:48','2023-04-21 13:57:48',NULL),(3532,7561,40725,3031,3,3000,'App\\Models\\Receipt',3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',2310.37,NULL,NULL,1,'2023-04-21 13:57:48','2023-04-21 13:57:48',NULL),(3533,7561,40725,3031,3,3001,'App\\Models\\Receipt',3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',41817.60,NULL,NULL,1,'2023-04-21 13:57:48','2023-04-21 13:57:48',NULL),(3534,7561,40725,3031,3,3002,'App\\Models\\Receipt',3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',92444.00,NULL,NULL,1,'2023-04-21 13:57:48','2023-04-21 13:57:48',NULL),(3535,7561,40725,3031,3,3003,'App\\Models\\Receipt',3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',381.28,NULL,NULL,1,'2023-04-21 13:57:49','2023-04-21 13:57:49',NULL),(3536,7561,40725,3031,3,3004,'App\\Models\\Receipt',3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',571725.00,NULL,NULL,1,'2023-04-21 13:57:49','2023-04-21 13:57:49',NULL),(3537,7561,40725,3031,3,3005,'App\\Models\\Receipt',3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',1100.00,NULL,NULL,1,'2023-04-21 13:57:49','2023-04-21 13:57:49',NULL),(3538,7561,40725,3031,3,3006,'App\\Models\\Receipt',3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',1100.00,NULL,NULL,1,'2023-04-21 13:57:49','2023-04-21 13:57:49',NULL),(3539,7561,40725,3031,3,3007,'App\\Models\\Receipt',3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',4042.00,NULL,NULL,1,'2023-04-21 13:57:49','2023-04-21 13:57:49',NULL);
INSERT INTO `balance_libro` VALUES (3540,7561,40725,3031,3,3008,'App\\Models\\Receipt',3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',1046.68,NULL,NULL,1,'2023-04-21 13:57:49','2023-04-21 13:57:49',NULL),(3541,7561,40725,3031,3,3009,'App\\Models\\Receipt',3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',1066.44,NULL,NULL,1,'2023-04-21 13:57:49','2023-04-21 13:57:49',NULL),(3542,7561,40725,3031,3,3010,'App\\Models\\Receipt',3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',1439.90,NULL,NULL,1,'2023-04-21 13:57:49','2023-04-21 13:57:49',NULL),(3543,7561,40725,3031,3,3011,'App\\Models\\Receipt',3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',4000.04,NULL,NULL,1,'2023-04-21 13:57:49','2023-04-21 13:57:49',NULL),(3544,7561,40725,3031,3,3012,'App\\Models\\Receipt',3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',3500.00,NULL,NULL,1,'2023-04-21 13:57:49','2023-04-21 13:57:49',NULL),(3545,7561,40725,3031,3,3013,'App\\Models\\Receipt',3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',4000.04,NULL,NULL,1,'2023-04-21 13:57:49','2023-04-21 13:57:49',NULL),(3546,7561,40725,3031,3,3014,'App\\Models\\Receipt',3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',3500.03,NULL,NULL,1,'2023-04-21 13:57:49','2023-04-21 13:57:49',NULL),(3547,7561,40725,3031,3,3015,'App\\Models\\Receipt',3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',4000.05,NULL,NULL,1,'2023-04-21 13:57:49','2023-04-21 13:57:49',NULL),(3548,7561,40725,3031,3,3016,'App\\Models\\Receipt',3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3999.99,NULL,NULL,1,'2023-04-21 13:57:49','2023-04-21 13:57:49',NULL),(3549,7561,40725,3031,3,3017,'App\\Models\\Receipt',3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3999.99,NULL,NULL,1,'2023-04-21 13:57:49','2023-04-21 13:57:49',NULL),(3550,7561,40725,3031,3,3018,'App\\Models\\Receipt',3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',5351.09,NULL,NULL,1,'2023-04-21 13:57:49','2023-04-21 13:57:49',NULL),(3551,7561,40725,3031,3,3019,'App\\Models\\Receipt',3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',3444.86,NULL,NULL,1,'2023-04-21 13:57:49','2023-04-21 13:57:49',NULL),(3571,7561,40725,3033,3,3039,'App\\Models\\Receipt',3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1144.41,NULL,NULL,1,'2023-04-21 14:03:40','2023-04-21 14:03:40',NULL),(3572,7561,40725,3033,3,3040,'App\\Models\\Receipt',3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4064.38,NULL,NULL,1,'2023-04-21 14:03:40','2023-04-21 14:03:40',NULL),(3573,7561,40725,3033,3,3041,'App\\Models\\Receipt',3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',66.00,NULL,NULL,1,'2023-04-21 14:03:40','2023-04-21 14:03:40',NULL),(3574,7561,40725,3033,3,3042,'App\\Models\\Receipt',3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',157745.28,NULL,NULL,1,'2023-04-21 14:03:40','2023-04-21 14:03:40',NULL),(3575,7561,40725,3033,3,3043,'App\\Models\\Receipt',3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',26347.75,NULL,NULL,1,'2023-04-21 14:03:40','2023-04-21 14:03:40',NULL),(3576,7561,40725,3033,3,3044,'App\\Models\\Receipt',3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',608025.00,NULL,NULL,1,'2023-04-21 14:03:41','2023-04-21 14:03:41',NULL),(3577,7561,40725,3033,3,3045,'App\\Models\\Receipt',3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',3499.01,NULL,NULL,1,'2023-04-21 14:03:41','2023-04-21 14:03:41',NULL),(3578,7561,40725,3033,3,3046,'App\\Models\\Receipt',3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2699.01,NULL,NULL,1,'2023-04-21 14:03:41','2023-04-21 14:03:41',NULL),(3579,7561,40725,3033,3,3047,'App\\Models\\Receipt',3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',3481.08,NULL,NULL,1,'2023-04-21 14:03:41','2023-04-21 14:03:41',NULL);
INSERT INTO `balance_libro` VALUES (3580,7561,40725,3033,3,3048,'App\\Models\\Receipt',3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',5018.04,NULL,NULL,1,'2023-04-21 14:03:41','2023-04-21 14:03:41',NULL),(3581,7561,40725,3033,3,3049,'App\\Models\\Receipt',3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2499.00,NULL,NULL,1,'2023-04-21 14:03:41','2023-04-21 14:03:41',NULL),(3582,7561,40725,3033,3,3050,'App\\Models\\Receipt',3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5989.78,NULL,NULL,1,'2023-04-21 14:03:41','2023-04-21 14:03:41',NULL),(3583,7561,40725,3033,3,3051,'App\\Models\\Receipt',3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4185.27,NULL,NULL,1,'2023-04-21 14:03:41','2023-04-21 14:03:41',NULL),(3584,7561,40725,3033,3,3052,'App\\Models\\Receipt',3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',3481.08,NULL,NULL,1,'2023-04-21 14:03:41','2023-04-21 14:03:41',NULL),(3585,7561,40725,3033,3,3053,'App\\Models\\Receipt',3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',623906.25,NULL,NULL,1,'2023-04-21 14:03:41','2023-04-21 14:03:41',NULL),(3586,7561,40725,3033,3,3054,'App\\Models\\Receipt',3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',57460.00,NULL,NULL,1,'2023-04-21 14:03:41','2023-04-21 14:03:41',NULL),(3587,7561,40725,3033,3,3055,'App\\Models\\Receipt',3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3999.98,NULL,NULL,1,'2023-04-21 14:03:41','2023-04-21 14:03:41',NULL),(3588,7561,40725,3033,3,3056,'App\\Models\\Receipt',3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',41885.36,NULL,NULL,1,'2023-04-21 14:03:41','2023-04-21 14:03:41',NULL),(3589,7561,40725,3033,3,3057,'App\\Models\\Receipt',3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',3999.98,NULL,NULL,1,'2023-04-21 14:03:41','2023-04-21 14:03:41',NULL),(3590,7561,40725,3033,3,3058,'App\\Models\\Receipt',3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',3999.98,NULL,NULL,1,'2023-04-21 14:03:41','2023-04-21 14:03:41',NULL),(3591,7561,40725,3033,3,3059,'App\\Models\\Receipt',3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3880.28,NULL,NULL,1,'2023-04-21 14:03:41','2023-04-21 14:03:41',NULL),(3592,7561,40725,3033,3,3060,'App\\Models\\Receipt',3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',9221.60,NULL,NULL,1,'2023-04-21 14:03:41','2023-04-21 14:03:41',NULL),(3593,7561,40725,3033,3,3061,'App\\Models\\Receipt',3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',647.08,NULL,NULL,1,'2023-04-21 14:03:41','2023-04-21 14:03:41',NULL),(3634,7561,40725,3035,3,3102,'App\\Models\\Receipt',3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',890.00,NULL,NULL,1,'2023-04-21 14:05:19','2023-04-21 15:35:00','2023-04-21 15:35:00'),(3635,7561,40725,3035,3,3103,'App\\Models\\Receipt',3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',1336.39,NULL,NULL,1,'2023-04-21 14:05:19','2023-04-21 14:05:19',NULL),(3636,7561,40725,3035,3,3104,'App\\Models\\Receipt',3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',158270.00,NULL,NULL,1,'2023-04-21 14:05:19','2023-04-21 14:05:19',NULL),(3637,7561,40725,3035,3,3105,'App\\Models\\Receipt',3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',68.00,NULL,NULL,1,'2023-04-21 14:05:19','2023-04-21 14:05:19',NULL),(3638,7561,40725,3035,3,3106,'App\\Models\\Receipt',3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',33.00,NULL,NULL,1,'2023-04-21 14:05:19','2023-04-21 14:05:19',NULL),(3639,7561,40725,3035,3,3107,'App\\Models\\Receipt',3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',7220.01,NULL,NULL,1,'2023-04-21 14:05:19','2023-04-21 14:05:19',NULL),(3640,7561,40725,3035,3,3108,'App\\Models\\Receipt',3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',753225.00,NULL,NULL,1,'2023-04-21 14:05:19','2023-04-21 14:05:19',NULL);
INSERT INTO `balance_libro` VALUES (3641,7561,40725,3035,3,3109,'App\\Models\\Receipt',3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',68474.14,NULL,NULL,1,'2023-04-21 14:05:19','2023-04-21 14:05:19',NULL),(3642,7561,40725,3035,3,3110,'App\\Models\\Receipt',3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',46549.91,NULL,NULL,1,'2023-04-21 14:05:19','2023-04-21 14:05:19',NULL),(3643,7561,40725,3035,3,3111,'App\\Models\\Receipt',3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',423042.57,NULL,NULL,1,'2023-04-21 14:05:19','2023-04-21 14:05:19',NULL),(3644,7561,40725,3035,3,3112,'App\\Models\\Receipt',3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',12714.69,NULL,NULL,1,'2023-04-21 14:05:19','2023-04-21 14:05:19',NULL),(3645,7561,40725,3035,3,3113,'App\\Models\\Receipt',3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',38043.36,NULL,NULL,1,'2023-04-21 14:05:19','2023-04-21 14:05:19',NULL),(3646,7561,40725,3035,3,3114,'App\\Models\\Receipt',3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',798.76,NULL,NULL,1,'2023-04-21 14:05:19','2023-04-21 14:05:19',NULL),(3647,7561,40725,3035,3,3115,'App\\Models\\Receipt',3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',2662.52,NULL,NULL,1,'2023-04-21 14:05:19','2023-04-21 14:05:19',NULL),(3648,7561,40725,3035,3,3116,'App\\Models\\Receipt',3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',55713.60,NULL,NULL,1,'2023-04-21 14:05:19','2023-04-21 14:05:19',NULL),(3649,7561,40725,3035,3,3117,'App\\Models\\Receipt',3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',23731.35,NULL,NULL,1,'2023-04-21 14:05:19','2023-04-21 14:05:19',NULL),(3650,7561,40725,3035,3,3118,'App\\Models\\Receipt',3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',23731.37,NULL,NULL,1,'2023-04-21 14:05:19','2023-04-21 14:05:19',NULL),(3651,7561,40725,3035,3,3119,'App\\Models\\Receipt',3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',20616.19,NULL,NULL,1,'2023-04-21 14:05:19','2023-04-21 14:05:19',NULL),(3652,7561,40725,3035,3,3120,'App\\Models\\Receipt',3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',682.11,NULL,NULL,1,'2023-04-21 14:05:19','2023-04-21 14:05:19',NULL),(3653,7561,40725,3035,3,3121,'App\\Models\\Receipt',3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',4893.12,NULL,NULL,1,'2023-04-21 14:05:20','2023-04-21 15:37:10','2023-04-21 15:37:10'),(3654,7561,40725,3035,3,3122,'App\\Models\\Receipt',3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',136.00,NULL,NULL,1,'2023-04-21 14:05:20','2023-04-21 14:05:20',NULL),(3655,7561,40725,3035,3,3123,'App\\Models\\Receipt',3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',950.00,NULL,NULL,1,'2023-04-21 14:05:20','2023-04-21 15:34:24','2023-04-21 15:34:24'),(3656,7561,40725,3035,3,3124,'App\\Models\\Receipt',3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',2000.00,NULL,NULL,1,'2023-04-21 14:05:20','2023-04-21 15:34:13','2023-04-21 15:34:13'),(3657,7561,40725,3035,3,3125,'App\\Models\\Receipt',3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',950.00,NULL,NULL,1,'2023-04-21 14:05:20','2023-04-21 15:33:54','2023-04-21 15:33:54'),(3658,7561,40725,3035,3,3126,'App\\Models\\Receipt',3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',723731.25,NULL,NULL,1,'2023-04-21 14:05:20','2023-04-21 14:05:20',NULL),(3659,7561,40725,3035,3,3127,'App\\Models\\Receipt',3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',723731.25,NULL,NULL,1,'2023-04-21 14:05:20','2023-04-21 14:05:20',NULL),(3660,7561,40725,3035,3,3128,'App\\Models\\Receipt',3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',789525.00,NULL,NULL,1,'2023-04-21 14:05:20','2023-04-21 14:05:20',NULL);
INSERT INTO `balance_libro` VALUES (3661,7561,40725,3035,3,3129,'App\\Models\\Receipt',3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',3150.00,NULL,NULL,1,'2023-04-21 14:05:20','2023-04-26 12:19:51','2023-04-26 12:19:51'),(3662,7561,40725,3035,3,3130,'App\\Models\\Receipt',3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',121142.54,NULL,NULL,1,'2023-04-21 14:05:20','2023-04-21 14:05:20',NULL),(3663,7561,40725,3035,3,3131,'App\\Models\\Receipt',3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',59675.42,NULL,NULL,1,'2023-04-21 14:05:20','2023-04-21 14:05:20',NULL),(3664,7561,40725,3035,3,3132,'App\\Models\\Receipt',3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',7400.00,NULL,NULL,1,'2023-04-21 14:05:20','2023-04-26 12:24:44','2023-04-26 12:24:44'),(3665,7561,40725,3035,3,3133,'App\\Models\\Receipt',3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',785.34,NULL,NULL,1,'2023-04-21 14:05:20','2023-04-21 14:05:20',NULL),(3666,7561,40725,3035,3,3134,'App\\Models\\Receipt',3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',12697.59,NULL,NULL,1,'2023-04-21 14:05:20','2023-04-21 14:05:20',NULL),(3687,7561,40725,3030,3,3155,'App\\Models\\Receipt',3155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1059.00,NULL,NULL,1,'2023-04-21 14:16:27','2023-04-21 14:16:27',NULL),(3688,7561,40725,3030,3,3156,'App\\Models\\Receipt',3156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',68.00,NULL,NULL,1,'2023-04-21 14:16:27','2023-04-21 14:16:27',NULL),(3689,7561,40725,3030,3,3157,'App\\Models\\Receipt',3157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-10','2022-04-10',1493.01,NULL,NULL,1,'2023-04-21 14:16:27','2023-04-21 14:16:27',NULL),(3690,7561,40725,3030,3,3158,'App\\Models\\Receipt',3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',532875.00,NULL,NULL,1,'2023-04-21 14:16:27','2023-04-21 17:39:37','2023-04-21 17:39:37'),(3691,7561,40725,3030,3,3159,'App\\Models\\Receipt',3159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',1557.81,NULL,NULL,1,'2023-04-21 14:16:27','2023-04-21 14:16:27',NULL),(3692,7561,40725,3030,3,3160,'App\\Models\\Receipt',3160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',1557.81,NULL,NULL,1,'2023-04-21 14:16:27','2023-04-21 14:16:27',NULL),(3693,7561,40725,3030,3,3161,'App\\Models\\Receipt',3161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',68.00,NULL,NULL,1,'2023-04-21 14:16:27','2023-04-21 14:16:27',NULL),(3694,7561,40725,3030,3,3162,'App\\Models\\Receipt',3162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',190.00,NULL,NULL,1,'2023-04-21 14:16:27','2023-04-21 14:16:27',NULL),(3695,7561,40725,3030,3,3163,'App\\Models\\Receipt',3163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',42320.05,NULL,NULL,1,'2023-04-21 14:16:27','2023-04-21 14:16:27',NULL),(3696,7561,40725,3030,3,3164,'App\\Models\\Receipt',3164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',504158.37,NULL,NULL,1,'2023-04-21 14:16:28','2023-04-21 14:16:28',NULL),(3697,7561,40725,3030,3,3165,'App\\Models\\Receipt',3165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',100155.51,NULL,NULL,1,'2023-04-21 14:16:28','2023-04-21 14:16:28',NULL),(3698,7561,40725,3030,3,3166,'App\\Models\\Receipt',3166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1557.81,NULL,NULL,1,'2023-04-21 14:16:28','2023-04-21 14:16:28',NULL),(3699,7561,40725,3030,3,3167,'App\\Models\\Receipt',3167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',165.00,NULL,NULL,1,'2023-04-21 14:16:28','2023-04-21 14:16:28',NULL),(3700,7561,40725,3030,3,3168,'App\\Models\\Receipt',3168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',12370.48,NULL,NULL,1,'2023-04-21 14:16:28','2023-04-21 14:16:28',NULL);
INSERT INTO `balance_libro` VALUES (3701,7561,40725,3030,3,3169,'App\\Models\\Receipt',3169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',4000.00,NULL,NULL,1,'2023-04-21 14:16:28','2023-04-21 14:16:28',NULL),(3702,7561,40725,3030,3,3170,'App\\Models\\Receipt',3170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',4000.00,NULL,NULL,1,'2023-04-21 14:16:28','2023-04-21 14:16:28',NULL),(3703,7561,40725,3030,3,3171,'App\\Models\\Receipt',3171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',3000.00,NULL,NULL,1,'2023-04-21 14:16:28','2023-04-21 14:16:28',NULL),(3704,7561,40725,3030,3,3172,'App\\Models\\Receipt',3172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',4000.00,NULL,NULL,1,'2023-04-21 14:16:28','2023-04-21 14:16:28',NULL),(3705,7561,40725,3030,3,3173,'App\\Models\\Receipt',3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',5800.00,NULL,NULL,1,'2023-04-21 14:16:28','2023-04-21 14:16:28',NULL),(3706,7561,40725,3030,3,3174,'App\\Models\\Receipt',3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',3500.00,NULL,NULL,1,'2023-04-21 14:16:28','2023-04-21 14:16:28',NULL),(3707,7561,40725,3030,3,3175,'App\\Models\\Receipt',3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',2500.00,NULL,NULL,1,'2023-04-21 14:16:28','2023-04-21 14:16:28',NULL),(3708,7561,40725,3030,3,3176,'App\\Models\\Receipt',3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',2311.97,NULL,NULL,1,'2023-04-21 14:16:28','2023-04-21 14:16:28',NULL),(3709,7561,40725,3030,3,3177,'App\\Models\\Receipt',3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',1814.04,NULL,NULL,1,'2023-04-21 14:16:28','2023-04-21 14:16:28',NULL),(3710,7561,40725,3030,3,3178,'App\\Models\\Receipt',3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',33.00,NULL,NULL,1,'2023-04-21 14:16:28','2023-04-21 15:38:07','2023-04-21 15:38:07'),(3711,7561,40725,3030,3,3179,'App\\Models\\Receipt',3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1834.86,NULL,NULL,1,'2023-04-21 14:16:28','2023-04-21 14:16:28',NULL),(3712,7561,40725,3030,3,3180,'App\\Models\\Receipt',3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',7083.99,NULL,NULL,1,'2023-04-21 14:16:28','2023-04-21 14:16:28',NULL),(3713,7561,40725,3030,3,3181,'App\\Models\\Receipt',3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',21500.00,NULL,NULL,1,'2023-04-21 14:29:03','2023-04-21 14:29:03',NULL),(3714,7561,40725,3030,3,3182,'App\\Models\\Receipt',3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',21500.00,NULL,NULL,1,'2023-04-21 14:40:21','2023-04-21 14:40:21',NULL),(3715,7561,40725,3030,3,3183,'App\\Models\\Receipt',3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',1219.99,NULL,NULL,1,'2023-04-21 14:42:11','2023-04-21 14:42:11',NULL),(3773,7561,40725,3033,3,3241,'App\\Models\\Receipt',3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',43000.00,NULL,NULL,1,'2023-04-21 15:09:40','2023-04-21 15:09:40',NULL),(3774,7561,40725,3035,3,3242,'App\\Models\\Receipt',3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',27000.00,NULL,NULL,1,'2023-04-21 15:14:26','2023-04-21 15:14:26',NULL),(3775,7561,40725,3035,3,3243,'App\\Models\\Receipt',3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',27500.00,NULL,NULL,1,'2023-04-21 15:25:26','2023-04-21 15:25:26',NULL),(3776,7561,40725,3030,3,3178,'App\\Models\\Receipt',3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',33.00,NULL,NULL,1,'2023-04-21 15:38:07','2023-04-21 15:38:07',NULL),(3777,7561,40857,18309,16,1437,'App\\Models\\PeriodLiquidation',NULL,1437,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',825.00,NULL,NULL,1,'2023-04-21 16:38:54','2023-04-21 16:43:32','2023-04-21 16:43:32');
INSERT INTO `balance_libro` VALUES (3778,7561,40857,18310,16,1438,'App\\Models\\PeriodLiquidation',NULL,1438,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',825.00,NULL,NULL,1,'2023-04-21 16:39:01','2023-04-21 16:43:48','2023-04-21 16:43:48'),(3779,7561,40857,18311,16,1439,'App\\Models\\PeriodLiquidation',NULL,1439,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',825.00,NULL,NULL,1,'2023-04-21 16:40:26','2023-04-21 16:43:59','2023-04-21 16:43:59'),(3780,7561,40857,18326,16,1440,'App\\Models\\PeriodLiquidation',NULL,1440,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1918.14,NULL,NULL,1,'2023-04-21 16:42:10','2023-04-21 16:42:10',NULL),(3781,7561,40857,18327,16,1361,'App\\Models\\PeriodLiquidation',NULL,1361,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1918.14,NULL,NULL,1,'2023-04-21 16:42:43','2023-04-21 16:42:43',NULL),(3782,7561,40857,18312,16,912,'App\\Models\\PeriodLiquidation',NULL,912,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',0.00,NULL,NULL,1,'2023-04-21 16:42:58','2023-04-21 16:44:05','2023-04-21 16:44:05'),(3783,7561,40857,18313,16,913,'App\\Models\\PeriodLiquidation',NULL,913,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',0.00,NULL,NULL,1,'2023-04-21 16:43:05','2023-04-21 16:43:05',NULL),(3784,7561,40857,18314,16,914,'App\\Models\\PeriodLiquidation',NULL,914,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',0.00,NULL,NULL,1,'2023-04-21 16:43:12','2023-04-21 16:43:12',NULL),(3785,7561,40857,18315,16,915,'App\\Models\\PeriodLiquidation',NULL,915,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1395.00,NULL,NULL,1,'2023-04-21 16:44:29','2023-04-21 16:44:29',NULL),(3786,7561,40857,18312,16,912,'App\\Models\\PeriodLiquidation',NULL,912,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',0.00,NULL,NULL,1,'2023-04-21 16:45:42','2023-04-21 16:45:42',NULL),(3787,7561,40857,18311,16,1439,'App\\Models\\PeriodLiquidation',NULL,1439,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',825.00,NULL,NULL,1,'2023-04-21 16:46:04','2023-04-21 16:46:04',NULL),(3788,7561,40857,18309,16,1437,'App\\Models\\PeriodLiquidation',NULL,1437,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',825.00,NULL,NULL,1,'2023-04-21 16:46:27','2023-04-21 16:46:53','2023-04-21 16:46:53'),(3789,7561,40857,18310,16,1438,'App\\Models\\PeriodLiquidation',NULL,1438,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',825.00,NULL,NULL,1,'2023-04-21 16:46:35','2023-04-21 16:47:50','2023-04-21 16:47:50'),(3790,7561,40857,18309,16,1441,'App\\Models\\PeriodLiquidation',NULL,1441,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',825.00,NULL,NULL,1,'2023-04-21 16:47:36','2023-04-21 16:47:36',NULL),(3791,7561,40857,18310,16,1442,'App\\Models\\PeriodLiquidation',NULL,1442,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',825.00,NULL,NULL,1,'2023-04-21 16:48:31','2023-04-21 16:48:31',NULL),(3792,7561,40725,3037,3,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',136.00,NULL,NULL,1,'2023-04-21 17:38:56','2023-04-21 17:38:56',NULL),(3793,7561,40725,3030,3,3158,'App\\Models\\Receipt',3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',532875.00,NULL,NULL,1,'2023-04-21 17:39:37','2023-04-21 17:39:37',NULL),(3885,7561,40727,1515,3,3335,'App\\Models\\Receipt',3335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',44021.01,NULL,NULL,1,'2023-04-22 08:32:38','2023-04-22 08:32:38',NULL),(3886,7561,40727,1515,3,3336,'App\\Models\\Receipt',3336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',8400.07,NULL,NULL,1,'2023-04-22 08:32:38','2023-04-22 08:32:38',NULL),(3887,7561,40727,1515,3,3337,'App\\Models\\Receipt',3337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',58274.81,NULL,NULL,1,'2023-04-22 08:32:38','2023-04-22 08:32:38',NULL),(3888,7561,40727,1515,3,3338,'App\\Models\\Receipt',3338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',35310.22,NULL,NULL,1,'2023-04-22 08:32:38','2023-04-22 08:32:38',NULL);
INSERT INTO `balance_libro` VALUES (3889,7561,40727,1515,3,3339,'App\\Models\\Receipt',3339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',6044.39,NULL,NULL,1,'2023-04-22 08:32:38','2023-04-22 08:32:38',NULL),(3890,7561,40727,1515,3,3340,'App\\Models\\Receipt',3340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',1205.03,NULL,NULL,1,'2023-04-22 08:32:38','2023-04-22 08:32:38',NULL),(3891,7561,40727,1515,3,3341,'App\\Models\\Receipt',3341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',1548.40,NULL,NULL,1,'2023-04-22 08:32:38','2023-04-22 08:32:38',NULL),(3892,7561,40727,1515,3,3342,'App\\Models\\Receipt',3342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',765.69,NULL,NULL,1,'2023-04-22 08:32:38','2023-04-22 08:32:38',NULL),(3893,7561,40727,1515,3,3343,'App\\Models\\Receipt',3343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',1891.49,NULL,NULL,1,'2023-04-22 08:32:38','2023-04-22 08:32:38',NULL),(3894,7561,40727,1515,3,3344,'App\\Models\\Receipt',3344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',1863.28,NULL,NULL,1,'2023-04-22 08:32:38','2023-04-22 08:32:38',NULL),(3895,7561,40727,1515,3,3345,'App\\Models\\Receipt',3345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',10899.35,NULL,NULL,1,'2023-04-22 08:32:38','2023-04-22 08:32:38',NULL),(3896,7561,40727,1515,3,3346,'App\\Models\\Receipt',3346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',14489.20,NULL,NULL,1,'2023-04-22 08:32:38','2023-04-22 08:32:38',NULL),(3897,7561,40727,1515,3,3347,'App\\Models\\Receipt',3347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',14367.33,NULL,NULL,1,'2023-04-22 08:32:38','2023-04-22 08:32:38',NULL),(3898,7561,40727,1515,3,3348,'App\\Models\\Receipt',3348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',10992.15,NULL,NULL,1,'2023-04-22 08:32:38','2023-04-22 08:32:38',NULL),(3899,7561,40727,1515,3,3349,'App\\Models\\Receipt',3349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',3039.69,NULL,NULL,1,'2023-04-22 08:32:38','2023-04-22 08:32:38',NULL),(3900,7561,40727,1515,3,3350,'App\\Models\\Receipt',3350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',2000.61,NULL,NULL,1,'2023-04-22 08:32:38','2023-04-22 08:32:38',NULL),(3901,7561,40727,1515,3,3351,'App\\Models\\Receipt',3351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',12731.05,NULL,NULL,1,'2023-04-22 08:32:38','2023-04-22 08:32:38',NULL),(3913,7561,40727,1515,2,3363,'App\\Models\\Receipt',3363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',55100.00,NULL,NULL,1,'2023-04-22 08:59:05','2023-04-22 09:00:17','2023-04-22 09:00:17'),(3914,7561,40727,1515,2,3364,'App\\Models\\Receipt',3364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',43560.00,NULL,NULL,1,'2023-04-22 08:59:05','2023-04-22 08:59:05',NULL),(3915,7561,40727,1515,2,3365,'App\\Models\\Receipt',3365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',23000.06,NULL,NULL,1,'2023-04-22 08:59:05','2023-04-22 08:59:05',NULL),(3916,7561,40727,1515,2,3366,'App\\Models\\Receipt',3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',20000.06,NULL,NULL,1,'2023-04-22 08:59:05','2023-04-22 09:00:30','2023-04-22 09:00:30'),(3917,7561,40727,1515,2,3367,'App\\Models\\Receipt',3367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',71269.00,NULL,NULL,1,'2023-04-22 08:59:05','2023-04-22 08:59:05',NULL),(3918,7561,40727,1515,2,3368,'App\\Models\\Receipt',3368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',5500.06,NULL,NULL,1,'2023-04-22 08:59:05','2023-04-22 09:00:43','2023-04-22 09:00:43'),(3919,7561,40727,1515,2,3369,'App\\Models\\Receipt',3369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',43886.70,NULL,NULL,1,'2023-04-22 08:59:05','2023-04-22 08:59:28','2023-04-22 08:59:28');
INSERT INTO `balance_libro` VALUES (3920,7561,40727,1515,2,3370,'App\\Models\\Receipt',3370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',36000.00,NULL,NULL,1,'2023-04-22 08:59:05','2023-04-22 08:59:43','2023-04-22 08:59:43'),(3921,7561,40727,1515,2,3371,'App\\Models\\Receipt',3371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',75000.02,NULL,NULL,1,'2023-04-22 08:59:05','2023-04-22 08:59:05',NULL),(3922,7561,40727,1515,2,3372,'App\\Models\\Receipt',3372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',39567.00,NULL,NULL,1,'2023-04-22 08:59:05','2023-04-22 08:59:05',NULL),(3923,7561,40727,1515,2,3369,'App\\Models\\Receipt',3369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',43886.70,NULL,NULL,1,'2023-04-22 08:59:28','2023-04-22 08:59:28',NULL),(3924,7561,40727,1515,2,3370,'App\\Models\\Receipt',3370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',36000.00,NULL,NULL,1,'2023-04-22 08:59:43','2023-04-22 08:59:43',NULL),(3925,7561,40727,1515,2,3363,'App\\Models\\Receipt',3363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',55100.00,NULL,NULL,1,'2023-04-22 09:00:17','2023-04-22 09:00:17',NULL),(3926,7561,40727,1515,2,3366,'App\\Models\\Receipt',3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',20000.06,NULL,NULL,1,'2023-04-22 09:00:30','2023-05-03 15:20:50','2023-05-03 15:20:50'),(3927,7561,40727,1515,2,3368,'App\\Models\\Receipt',3368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',5500.06,NULL,NULL,1,'2023-04-22 09:00:43','2023-04-22 09:00:43',NULL),(3929,7561,40727,1516,2,3374,'App\\Models\\Receipt',3374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',19500.02,NULL,NULL,1,'2023-04-22 09:08:12','2023-04-22 09:08:12',NULL),(3930,7561,40727,1516,2,3375,'App\\Models\\Receipt',3375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',8000.00,NULL,NULL,1,'2023-04-22 09:08:12','2023-04-22 09:08:12',NULL),(3931,7561,40727,1516,2,3376,'App\\Models\\Receipt',3376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',22000.00,NULL,NULL,1,'2023-04-22 09:08:12','2023-04-22 09:08:12',NULL),(3932,7561,40727,1516,2,3377,'App\\Models\\Receipt',3377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',48450.02,NULL,NULL,1,'2023-04-22 09:08:12','2023-04-22 09:08:12',NULL),(3933,7561,40727,1516,2,3378,'App\\Models\\Receipt',3378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',35000.00,NULL,NULL,1,'2023-04-22 09:08:12','2023-04-22 09:08:12',NULL),(3934,7561,40727,1516,2,3379,'App\\Models\\Receipt',3379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',96000.04,NULL,NULL,1,'2023-04-22 09:08:12','2023-04-22 09:08:12',NULL),(3935,7561,40727,1516,2,3380,'App\\Models\\Receipt',3380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-26','2022-02-26',75000.02,NULL,NULL,1,'2023-04-22 09:08:12','2023-04-22 09:08:12',NULL),(3959,7561,40727,1518,3,3404,'App\\Models\\Receipt',3404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',24179.43,NULL,NULL,1,'2023-04-22 09:39:43','2023-04-22 09:39:43',NULL),(3960,7561,40727,1518,3,3405,'App\\Models\\Receipt',3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',9378.48,NULL,NULL,1,'2023-04-22 09:39:43','2023-04-22 09:39:43',NULL),(3961,7561,40727,1518,3,3406,'App\\Models\\Receipt',3406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',22789.57,NULL,NULL,1,'2023-04-22 09:39:43','2023-04-22 09:39:43',NULL),(3962,7561,40727,1518,3,3407,'App\\Models\\Receipt',3407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',1795.94,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3963,7561,40727,1518,3,3408,'App\\Models\\Receipt',3408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',35699.14,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL);
INSERT INTO `balance_libro` VALUES (3964,7561,40727,1518,3,3409,'App\\Models\\Receipt',3409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',4763.69,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3965,7561,40727,1518,3,3410,'App\\Models\\Receipt',3410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',2218.61,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3966,7561,40727,1518,3,3411,'App\\Models\\Receipt',3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',37858.48,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3967,7561,40727,1518,3,3412,'App\\Models\\Receipt',3412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',22894.06,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3968,7561,40727,1518,3,3413,'App\\Models\\Receipt',3413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',2909.41,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3969,7561,40727,1518,3,3414,'App\\Models\\Receipt',3414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',1223.75,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3970,7561,40727,1518,3,3415,'App\\Models\\Receipt',3415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',26473.93,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3971,7561,40727,1518,3,3416,'App\\Models\\Receipt',3416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',7610.43,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3972,7561,40727,1518,3,3417,'App\\Models\\Receipt',3417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',18521.96,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3973,7561,40727,1518,3,3418,'App\\Models\\Receipt',3418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',2099.78,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3974,7561,40727,1518,3,3419,'App\\Models\\Receipt',3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',36278.22,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3975,7561,40727,1518,3,3420,'App\\Models\\Receipt',3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',3934.23,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3976,7561,40727,1518,3,3421,'App\\Models\\Receipt',3421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',11306.09,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3977,7561,40727,1518,3,3422,'App\\Models\\Receipt',3422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',5035.53,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3978,7561,40727,1518,3,3423,'App\\Models\\Receipt',3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',1073.25,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3979,7561,40727,1518,3,3424,'App\\Models\\Receipt',3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',45787.61,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3980,7561,40727,1518,3,3425,'App\\Models\\Receipt',3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',31251.45,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3981,7561,40727,1518,3,3426,'App\\Models\\Receipt',3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',9340.99,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3982,7561,40727,1518,3,3427,'App\\Models\\Receipt',3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',2593.10,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3983,7561,40727,1518,3,3428,'App\\Models\\Receipt',3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',1534.16,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3984,7561,40727,1518,3,3429,'App\\Models\\Receipt',3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',2930.70,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL);
INSERT INTO `balance_libro` VALUES (3985,7561,40727,1518,3,3430,'App\\Models\\Receipt',3430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',119570.08,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3986,7561,40727,1518,3,3431,'App\\Models\\Receipt',3431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',1961.60,NULL,NULL,1,'2023-04-22 09:39:44','2023-04-22 09:39:44',NULL),(3987,7561,40727,1519,3,3432,'App\\Models\\Receipt',3432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',18504.24,NULL,NULL,1,'2023-04-22 09:40:54','2023-04-22 09:40:54',NULL),(3988,7561,40727,1519,3,3433,'App\\Models\\Receipt',3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',107.33,NULL,NULL,1,'2023-04-22 09:40:54','2023-04-22 09:40:54',NULL),(3989,7561,40727,1519,3,3434,'App\\Models\\Receipt',3434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',18009.74,NULL,NULL,1,'2023-04-22 09:40:54','2023-04-22 09:40:54',NULL),(3990,7561,40727,1519,3,3435,'App\\Models\\Receipt',3435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',69855.72,NULL,NULL,1,'2023-04-22 09:40:54','2023-04-22 09:40:54',NULL),(3991,7561,40727,1519,3,3436,'App\\Models\\Receipt',3436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',5500.07,NULL,NULL,1,'2023-04-22 09:40:54','2023-04-22 09:40:54',NULL),(3992,7561,40727,1519,3,3437,'App\\Models\\Receipt',3437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',8917.66,NULL,NULL,1,'2023-04-22 09:40:54','2023-04-22 09:40:54',NULL),(3993,7561,40727,1519,3,3438,'App\\Models\\Receipt',3438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',8422.23,NULL,NULL,1,'2023-04-22 09:40:54','2023-04-22 09:40:54',NULL),(3994,7561,40727,1519,3,3439,'App\\Models\\Receipt',3439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',6568.76,NULL,NULL,1,'2023-04-22 09:40:54','2023-04-22 09:40:54',NULL),(3995,7561,40727,1519,3,3440,'App\\Models\\Receipt',3440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',56638.89,NULL,NULL,1,'2023-04-22 09:40:54','2023-04-22 09:40:54',NULL),(3996,7561,40727,1519,3,3441,'App\\Models\\Receipt',3441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',5241.98,NULL,NULL,1,'2023-04-22 09:40:55','2023-04-22 09:40:55',NULL),(3997,7561,40727,1519,3,3442,'App\\Models\\Receipt',3442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',2683.02,NULL,NULL,1,'2023-04-22 09:40:55','2023-04-22 09:40:55',NULL),(3998,7561,40727,1519,3,3443,'App\\Models\\Receipt',3443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',48356.44,NULL,NULL,1,'2023-04-22 09:40:55','2023-04-22 09:40:55',NULL),(3999,7561,40727,1519,3,3444,'App\\Models\\Receipt',3444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',5133.80,NULL,NULL,1,'2023-04-22 09:40:55','2023-04-22 09:40:55',NULL),(4000,7561,40727,1519,3,3445,'App\\Models\\Receipt',3445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',8238.89,NULL,NULL,1,'2023-04-22 09:40:55','2023-04-22 09:40:55',NULL),(4001,7561,40727,1519,3,3446,'App\\Models\\Receipt',3446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',3286.49,NULL,NULL,1,'2023-04-22 09:40:55','2023-04-22 09:40:55',NULL),(4002,7561,40727,1519,3,3447,'App\\Models\\Receipt',3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',51185.42,NULL,NULL,1,'2023-04-22 09:40:55','2023-04-22 09:40:55',NULL),(4003,7561,40727,1519,3,3448,'App\\Models\\Receipt',3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',268.30,NULL,NULL,1,'2023-04-22 09:40:55','2023-04-22 09:40:55',NULL),(4004,7561,40727,1519,3,3449,'App\\Models\\Receipt',3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',6737.41,NULL,NULL,1,'2023-04-22 09:40:55','2023-04-22 09:40:55',NULL),(4005,7561,40727,1519,3,3450,'App\\Models\\Receipt',3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',2944.91,NULL,NULL,1,'2023-04-22 09:40:55','2023-04-22 09:40:55',NULL);
INSERT INTO `balance_libro` VALUES (4006,7561,40727,1519,3,3451,'App\\Models\\Receipt',3451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',45840.00,NULL,NULL,1,'2023-04-22 09:40:55','2023-04-22 09:40:55',NULL),(4007,7561,40727,1519,3,3452,'App\\Models\\Receipt',3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',9500.00,NULL,NULL,1,'2023-04-22 09:40:55','2023-04-22 09:40:55',NULL),(4008,7561,40727,1519,3,3453,'App\\Models\\Receipt',3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',53404.56,NULL,NULL,1,'2023-04-22 09:40:55','2023-04-22 09:40:55',NULL),(4009,7561,40727,1519,3,3454,'App\\Models\\Receipt',3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',1793.59,NULL,NULL,1,'2023-04-22 09:40:55','2023-04-22 09:40:55',NULL),(4010,7561,40727,1518,2,3455,'App\\Models\\Receipt',3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',12000.00,NULL,NULL,1,'2023-04-22 10:08:17','2023-04-22 10:08:17',NULL),(4011,7561,40727,1518,2,3456,'App\\Models\\Receipt',3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',133100.00,NULL,NULL,1,'2023-04-22 10:08:17','2023-04-22 10:08:17',NULL),(4012,7561,40727,1518,2,3457,'App\\Models\\Receipt',3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',58000.00,NULL,NULL,1,'2023-04-22 10:08:17','2023-04-22 10:08:17',NULL),(4013,7561,40727,1518,2,3458,'App\\Models\\Receipt',3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',29040.00,NULL,NULL,1,'2023-04-22 10:08:17','2023-04-22 10:08:17',NULL),(4014,7561,40727,1518,2,3459,'App\\Models\\Receipt',3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',50638.50,NULL,NULL,1,'2023-04-22 10:08:17','2023-04-22 10:08:17',NULL),(4015,7561,40727,1518,2,3460,'App\\Models\\Receipt',3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',12000.00,NULL,NULL,1,'2023-04-22 10:08:17','2023-04-22 10:08:17',NULL),(4016,7561,40727,1518,2,3461,'App\\Models\\Receipt',3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',10000.00,NULL,NULL,1,'2023-04-22 10:08:17','2023-04-22 10:08:17',NULL),(4017,7561,40727,1518,2,3462,'App\\Models\\Receipt',3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',68970.00,NULL,NULL,1,'2023-04-22 10:08:17','2023-04-22 10:08:17',NULL),(4018,7561,40727,1518,2,3463,'App\\Models\\Receipt',3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',57000.00,NULL,NULL,1,'2023-04-22 10:08:17','2023-04-22 10:08:17',NULL),(4019,7561,40727,1518,2,3464,'App\\Models\\Receipt',3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',11800.00,NULL,NULL,1,'2023-04-22 10:08:17','2023-04-22 10:08:17',NULL),(4020,7561,40727,1518,2,3465,'App\\Models\\Receipt',3465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',7000.00,NULL,NULL,1,'2023-04-22 10:08:17','2023-04-22 10:08:17',NULL),(4021,7561,40727,1518,2,3466,'App\\Models\\Receipt',3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',74269.80,NULL,NULL,1,'2023-04-22 10:08:17','2023-04-22 10:08:17',NULL),(4022,7561,40727,1518,2,3467,'App\\Models\\Receipt',3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',32670.00,NULL,NULL,1,'2023-04-22 10:08:17','2023-04-22 10:08:17',NULL),(4023,7561,40727,1518,2,3468,'App\\Models\\Receipt',3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',11400.00,NULL,NULL,1,'2023-04-22 10:08:17','2023-04-22 10:08:17',NULL),(4024,7561,40727,1517,2,3469,'App\\Models\\Receipt',3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',30000.00,NULL,NULL,1,'2023-04-22 10:08:54','2023-04-22 10:08:54',NULL),(4025,7561,40727,1517,2,3470,'App\\Models\\Receipt',3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',119003.50,NULL,NULL,1,'2023-04-22 10:08:54','2023-04-22 10:08:54',NULL),(4026,7561,40727,1517,2,3471,'App\\Models\\Receipt',3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',19360.00,NULL,NULL,1,'2023-04-22 10:08:54','2023-04-22 10:08:54',NULL);
INSERT INTO `balance_libro` VALUES (4027,7561,40727,1517,2,3472,'App\\Models\\Receipt',3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',37000.00,NULL,NULL,1,'2023-04-22 10:08:54','2023-04-22 10:08:54',NULL),(4028,7561,40727,1517,2,3473,'App\\Models\\Receipt',3473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',12000.00,NULL,NULL,1,'2023-04-22 10:08:54','2023-04-22 10:08:54',NULL),(4029,7561,40727,1517,2,3474,'App\\Models\\Receipt',3474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',44786.94,NULL,NULL,1,'2023-04-22 10:08:54','2023-04-22 10:08:54',NULL),(4030,7561,40727,1517,2,3475,'App\\Models\\Receipt',3475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',65000.00,NULL,NULL,1,'2023-04-22 10:08:54','2023-04-22 10:08:54',NULL),(4031,7561,40727,1517,2,3476,'App\\Models\\Receipt',3476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',33000.00,NULL,NULL,1,'2023-04-22 10:08:54','2023-04-22 10:08:54',NULL),(4032,7561,40727,1517,2,3477,'App\\Models\\Receipt',3477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',62000.04,NULL,NULL,1,'2023-04-22 10:08:54','2023-04-22 10:08:54',NULL),(4033,7561,40727,1517,2,3478,'App\\Models\\Receipt',3478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',15000.00,NULL,NULL,1,'2023-04-22 10:08:54','2023-04-22 10:08:54',NULL),(4034,7561,40727,1517,2,3479,'App\\Models\\Receipt',3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',25000.00,NULL,NULL,1,'2023-04-22 10:08:54','2023-04-22 10:08:54',NULL),(4035,7561,40727,1517,2,3480,'App\\Models\\Receipt',3480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',69400.00,NULL,NULL,1,'2023-04-22 10:08:54','2023-04-22 10:08:54',NULL),(4036,7561,40727,1517,2,3481,'App\\Models\\Receipt',3481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',52000.00,NULL,NULL,1,'2023-04-22 10:08:54','2023-04-22 10:08:54',NULL),(4037,7561,40727,1520,2,3482,'App\\Models\\Receipt',3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',79149.99,NULL,NULL,1,'2023-04-22 10:09:10','2023-04-22 10:09:10',NULL),(4038,7561,40727,1520,2,3483,'App\\Models\\Receipt',3483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',95832.00,NULL,NULL,1,'2023-04-22 10:09:10','2023-04-22 10:09:10',NULL),(4039,7561,40727,1520,2,3484,'App\\Models\\Receipt',3484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',41140.00,NULL,NULL,1,'2023-04-22 10:09:10','2023-04-22 10:09:10',NULL),(4040,7561,40727,1520,2,3485,'App\\Models\\Receipt',3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',55660.00,NULL,NULL,1,'2023-04-22 10:09:10','2023-04-22 10:09:10',NULL),(4041,7561,40727,1520,2,3486,'App\\Models\\Receipt',3486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',63525.00,NULL,NULL,1,'2023-04-22 10:09:10','2023-04-22 10:09:10',NULL),(4042,7561,40727,1520,2,3487,'App\\Models\\Receipt',3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',39930.00,NULL,NULL,1,'2023-04-22 10:09:10','2023-04-22 10:09:10',NULL),(4043,7561,40727,1520,2,3488,'App\\Models\\Receipt',3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',54014.40,NULL,NULL,1,'2023-04-22 10:09:10','2023-04-22 10:09:10',NULL),(4044,7561,40727,1520,2,3489,'App\\Models\\Receipt',3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',26620.00,NULL,NULL,1,'2023-04-22 10:09:10','2023-04-22 10:09:10',NULL),(4045,7561,40727,1520,2,3490,'App\\Models\\Receipt',3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',60000.00,NULL,NULL,1,'2023-04-22 10:09:10','2023-04-22 10:09:10',NULL),(4046,7561,40727,1520,2,3491,'App\\Models\\Receipt',3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',14000.00,NULL,NULL,1,'2023-04-22 10:09:10','2023-04-22 10:09:10',NULL),(4047,7561,40727,1520,2,3492,'App\\Models\\Receipt',3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',12800.00,NULL,NULL,1,'2023-04-22 10:09:11','2023-04-22 10:09:11',NULL);
INSERT INTO `balance_libro` VALUES (4048,7561,40727,1520,2,3493,'App\\Models\\Receipt',3493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',62000.00,NULL,NULL,1,'2023-04-22 10:09:11','2023-04-22 10:09:11',NULL),(4049,7561,40727,1520,2,3494,'App\\Models\\Receipt',3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',75050.00,NULL,NULL,1,'2023-04-22 10:09:11','2023-04-22 10:09:11',NULL),(4050,7561,40727,1520,2,3495,'App\\Models\\Receipt',3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',32670.00,NULL,NULL,1,'2023-04-22 10:09:11','2023-04-22 10:09:11',NULL),(4051,7561,40727,1520,2,3496,'App\\Models\\Receipt',3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',141570.00,NULL,NULL,1,'2023-04-22 10:09:11','2023-04-22 10:09:11',NULL),(4052,7561,40727,1520,2,3497,'App\\Models\\Receipt',3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',49000.00,NULL,NULL,1,'2023-04-22 10:09:11','2023-05-03 14:45:09','2023-05-03 14:45:09'),(4053,7561,40727,1521,2,3498,'App\\Models\\Receipt',3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',50820.00,NULL,NULL,1,'2023-04-22 10:09:42','2023-04-22 10:09:42',NULL),(4054,7561,40727,1521,2,3499,'App\\Models\\Receipt',3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',11000.00,NULL,NULL,1,'2023-04-22 10:09:42','2023-04-22 10:09:42',NULL),(4055,7561,40727,1521,2,3500,'App\\Models\\Receipt',3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',168190.00,NULL,NULL,1,'2023-04-22 10:09:42','2023-04-22 10:09:42',NULL),(4056,7561,40727,1521,2,3501,'App\\Models\\Receipt',3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',36999.98,NULL,NULL,1,'2023-04-22 10:09:43','2023-04-22 10:09:43',NULL),(4057,7561,40727,1521,2,3502,'App\\Models\\Receipt',3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',36300.00,NULL,NULL,1,'2023-04-22 10:09:43','2023-04-22 10:09:43',NULL),(4058,7561,40727,1521,2,3503,'App\\Models\\Receipt',3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',121000.00,NULL,NULL,1,'2023-04-22 10:09:43','2023-04-22 10:09:43',NULL),(4059,7561,40727,1521,2,3504,'App\\Models\\Receipt',3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',22990.00,NULL,NULL,1,'2023-04-22 10:09:43','2023-04-22 10:09:43',NULL),(4060,7561,40727,1521,2,3505,'App\\Models\\Receipt',3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',6000.00,NULL,NULL,1,'2023-04-22 10:09:43','2023-04-22 10:09:43',NULL),(4061,7561,40727,1521,2,3506,'App\\Models\\Receipt',3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',108174.00,NULL,NULL,1,'2023-04-22 10:09:43','2023-04-22 10:09:43',NULL),(4062,7561,40727,1521,2,3507,'App\\Models\\Receipt',3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',72600.00,NULL,NULL,1,'2023-04-22 10:09:43','2023-04-22 10:09:43',NULL),(4063,7561,40727,1521,2,3508,'App\\Models\\Receipt',3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',24200.00,NULL,NULL,1,'2023-04-22 10:09:43','2023-04-22 10:09:43',NULL),(4064,7561,40727,1521,2,3509,'App\\Models\\Receipt',3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',52000.00,NULL,NULL,1,'2023-04-22 10:09:43','2023-04-22 10:09:43',NULL),(4065,7561,40727,1521,2,3510,'App\\Models\\Receipt',3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',87120.00,NULL,NULL,1,'2023-04-22 10:09:43','2023-04-22 10:09:43',NULL),(4066,7561,40727,1521,2,3511,'App\\Models\\Receipt',3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',135520.00,NULL,NULL,1,'2023-04-22 10:09:43','2023-04-22 10:09:43',NULL),(4067,7561,40727,1521,2,3512,'App\\Models\\Receipt',3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',50820.00,NULL,NULL,1,'2023-04-22 10:09:43','2023-04-22 10:09:43',NULL),(4068,7561,40727,1522,2,3513,'App\\Models\\Receipt',3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',65340.00,NULL,NULL,1,'2023-04-22 10:09:57','2023-04-22 10:09:57',NULL);
INSERT INTO `balance_libro` VALUES (4069,7561,40727,1522,2,3514,'App\\Models\\Receipt',3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',42350.00,NULL,NULL,1,'2023-04-22 10:09:57','2023-04-22 10:09:57',NULL),(4070,7561,40727,1522,2,3515,'App\\Models\\Receipt',3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',33880.00,NULL,NULL,1,'2023-04-22 10:09:57','2023-04-22 10:09:57',NULL),(4071,7561,40727,1522,2,3516,'App\\Models\\Receipt',3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',77000.00,NULL,NULL,1,'2023-04-22 10:09:57','2023-04-22 10:09:57',NULL),(4072,7561,40727,1522,2,3517,'App\\Models\\Receipt',3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',79000.00,NULL,NULL,1,'2023-04-22 10:09:57','2023-04-22 10:09:57',NULL),(4073,7561,40727,1522,2,3518,'App\\Models\\Receipt',3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',40000.00,NULL,NULL,1,'2023-04-22 10:09:57','2023-04-22 10:09:57',NULL),(4074,7561,40727,1522,2,3519,'App\\Models\\Receipt',3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',116160.00,NULL,NULL,1,'2023-04-22 10:09:57','2023-04-22 10:09:57',NULL),(4075,7561,40727,1522,2,3520,'App\\Models\\Receipt',3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',79000.00,NULL,NULL,1,'2023-04-22 10:09:57','2023-04-22 10:09:57',NULL),(4076,7561,40727,1522,2,3521,'App\\Models\\Receipt',3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',128250.00,NULL,NULL,1,'2023-04-22 10:09:57','2023-04-22 10:09:57',NULL),(4077,7561,40727,1522,2,3522,'App\\Models\\Receipt',3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',35090.00,NULL,NULL,1,'2023-04-22 10:09:57','2023-04-22 10:09:57',NULL),(4078,7561,40727,1522,2,3523,'App\\Models\\Receipt',3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',42350.00,NULL,NULL,1,'2023-04-22 10:09:57','2023-04-22 10:09:57',NULL),(4079,7561,40727,1522,2,3524,'App\\Models\\Receipt',3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-14','2022-08-14',46600.00,NULL,NULL,1,'2023-04-22 10:09:57','2023-04-22 10:09:57',NULL),(4080,7561,40727,1522,2,3525,'App\\Models\\Receipt',3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',65000.00,NULL,NULL,1,'2023-04-22 10:09:58','2023-04-22 10:09:58',NULL),(4081,7561,40727,1522,2,3526,'App\\Models\\Receipt',3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',39930.00,NULL,NULL,1,'2023-04-22 10:09:58','2023-04-22 10:09:58',NULL),(4082,7561,40727,1522,2,3527,'App\\Models\\Receipt',3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',116160.00,NULL,NULL,1,'2023-04-22 10:09:58','2023-04-22 10:09:58',NULL),(4083,7561,40727,1522,2,3528,'App\\Models\\Receipt',3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',59600.00,NULL,NULL,1,'2023-04-22 10:09:58','2023-04-22 10:09:58',NULL),(4084,7561,40727,1522,2,3529,'App\\Models\\Receipt',3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',100000.00,NULL,NULL,1,'2023-04-22 10:09:58','2023-04-22 10:09:58',NULL),(4085,7561,40727,1522,2,3530,'App\\Models\\Receipt',3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',44770.00,NULL,NULL,1,'2023-04-22 10:09:58','2023-04-22 10:09:58',NULL),(4086,7561,40727,1522,2,3531,'App\\Models\\Receipt',3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',63000.00,NULL,NULL,1,'2023-04-22 10:09:58','2023-04-22 10:09:58',NULL),(4087,7561,40727,1522,2,3532,'App\\Models\\Receipt',3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',13007.50,NULL,NULL,1,'2023-04-22 10:09:58','2023-04-22 10:09:58',NULL),(4088,7561,40727,1522,2,3533,'App\\Models\\Receipt',3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',118000.00,NULL,NULL,1,'2023-04-22 10:09:58','2023-04-22 10:09:58',NULL),(4097,7561,40727,1523,2,3542,'App\\Models\\Receipt',3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',30250.00,NULL,NULL,1,'2023-04-22 10:13:54','2023-04-22 10:13:54',NULL);
INSERT INTO `balance_libro` VALUES (4098,7561,40727,1523,2,3543,'App\\Models\\Receipt',3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',100000.00,NULL,NULL,1,'2023-04-22 10:13:54','2023-04-22 10:13:54',NULL),(4099,7561,40727,1523,2,3544,'App\\Models\\Receipt',3544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',47600.00,NULL,NULL,1,'2023-04-22 10:13:54','2023-04-22 10:13:54',NULL),(4100,7561,40727,1523,2,3545,'App\\Models\\Receipt',3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',67276.00,NULL,NULL,1,'2023-04-22 10:13:54','2023-04-22 10:13:54',NULL),(4101,7561,40727,1523,2,3546,'App\\Models\\Receipt',3546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',95000.00,NULL,NULL,1,'2023-04-22 10:13:54','2023-04-22 10:13:54',NULL),(4102,7561,40727,1523,2,3547,'App\\Models\\Receipt',3547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',22999.99,NULL,NULL,1,'2023-04-22 10:13:54','2023-04-22 10:13:54',NULL),(4103,7561,40727,1523,2,3548,'App\\Models\\Receipt',3548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',4999.99,NULL,NULL,1,'2023-04-22 10:13:54','2023-04-22 10:13:54',NULL),(4104,7561,40727,1523,2,3549,'App\\Models\\Receipt',3549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',61000.00,NULL,NULL,1,'2023-04-22 10:13:54','2023-04-22 10:13:54',NULL),(4105,7561,40727,1523,2,3550,'App\\Models\\Receipt',3550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',90000.00,NULL,NULL,1,'2023-04-22 10:13:54','2023-04-22 10:13:54',NULL),(4106,7561,40727,1523,2,3551,'App\\Models\\Receipt',3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',38526.40,NULL,NULL,1,'2023-04-22 10:13:54','2023-04-22 10:13:54',NULL),(4107,7561,40727,1523,2,3552,'App\\Models\\Receipt',3552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',108900.00,NULL,NULL,1,'2023-04-22 10:13:54','2023-04-22 10:13:54',NULL),(4108,7561,40727,1523,2,3553,'App\\Models\\Receipt',3553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',70180.00,NULL,NULL,1,'2023-04-22 10:13:54','2023-04-22 10:13:54',NULL),(4109,7561,40727,1523,2,3554,'App\\Models\\Receipt',3554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',24000.00,NULL,NULL,1,'2023-04-22 10:13:54','2023-04-22 10:13:54',NULL),(4110,7561,40727,1523,2,3555,'App\\Models\\Receipt',3555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',38000.00,NULL,NULL,1,'2023-04-22 10:13:54','2023-04-22 10:13:54',NULL),(4111,7561,40727,1524,2,3556,'App\\Models\\Receipt',3556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',155364.00,NULL,NULL,1,'2023-04-22 10:14:11','2023-04-22 10:14:11',NULL),(4112,7561,40727,1524,2,3557,'App\\Models\\Receipt',3557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',122000.00,NULL,NULL,1,'2023-04-22 10:14:11','2023-04-22 10:14:11',NULL),(4113,7561,40727,1524,2,3558,'App\\Models\\Receipt',3558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',68002.00,NULL,NULL,1,'2023-04-22 10:14:11','2023-04-22 10:14:11',NULL),(4114,7561,40727,1524,2,3559,'App\\Models\\Receipt',3559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',94050.00,NULL,NULL,1,'2023-04-22 10:14:11','2023-04-22 10:14:11',NULL),(4115,7561,40727,1524,2,3560,'App\\Models\\Receipt',3560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',65000.00,NULL,NULL,1,'2023-04-22 10:14:11','2023-04-22 10:14:11',NULL),(4116,7561,40727,1524,2,3561,'App\\Models\\Receipt',3561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',65340.00,NULL,NULL,1,'2023-04-22 10:14:11','2023-04-22 10:14:11',NULL),(4117,7561,40727,1524,2,3562,'App\\Models\\Receipt',3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',26500.00,NULL,NULL,1,'2023-04-22 10:14:11','2023-04-22 10:14:11',NULL),(4118,7561,40727,1524,2,3563,'App\\Models\\Receipt',3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',119790.00,NULL,NULL,1,'2023-04-22 10:14:11','2023-04-22 10:14:11',NULL);
INSERT INTO `balance_libro` VALUES (4119,7561,40727,1524,2,3564,'App\\Models\\Receipt',3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',19500.00,NULL,NULL,1,'2023-04-22 10:14:11','2023-04-22 10:14:11',NULL),(4120,7561,40727,1524,2,3565,'App\\Models\\Receipt',3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',59653.00,NULL,NULL,1,'2023-04-22 10:14:11','2023-04-22 10:14:11',NULL),(4121,7561,40727,1524,2,3566,'App\\Models\\Receipt',3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',59000.08,NULL,NULL,1,'2023-04-22 10:14:11','2023-04-22 10:14:11',NULL),(4122,7561,40727,1524,2,3567,'App\\Models\\Receipt',3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',106480.00,NULL,NULL,1,'2023-04-22 10:14:11','2023-04-22 10:14:11',NULL),(4123,7561,40727,1524,2,3568,'App\\Models\\Receipt',3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',65000.00,NULL,NULL,1,'2023-04-22 10:14:11','2023-04-22 10:14:11',NULL),(4124,7561,40727,1524,2,3569,'App\\Models\\Receipt',3569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',194931.00,NULL,NULL,1,'2023-04-22 10:14:11','2023-04-22 10:14:11',NULL),(4125,7561,40727,1520,3,3570,'App\\Models\\Receipt',3570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',20008.56,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4126,7561,40727,1520,3,3571,'App\\Models\\Receipt',3571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',12822.07,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4127,7561,40727,1520,3,3572,'App\\Models\\Receipt',3572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',3460.25,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4128,7561,40727,1520,3,3573,'App\\Models\\Receipt',3573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',10924.15,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4129,7561,40727,1520,3,3574,'App\\Models\\Receipt',3574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',4316.00,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4130,7561,40727,1520,3,3575,'App\\Models\\Receipt',3575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',72204.33,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4131,7561,40727,1520,3,3576,'App\\Models\\Receipt',3576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',2561.09,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4132,7561,40727,1520,3,3577,'App\\Models\\Receipt',3577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',13274.34,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4133,7561,40727,1520,3,3578,'App\\Models\\Receipt',3578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',2133.61,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4134,7561,40727,1520,3,3579,'App\\Models\\Receipt',3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',2372.13,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4135,7561,40727,1520,3,3580,'App\\Models\\Receipt',3580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',52446.24,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4136,7561,40727,1520,3,3581,'App\\Models\\Receipt',3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',30003.16,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4137,7561,40727,1520,3,3582,'App\\Models\\Receipt',3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',12070.50,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4138,7561,40727,1520,3,3583,'App\\Models\\Receipt',3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',2563.98,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4139,7561,40727,1520,3,3584,'App\\Models\\Receipt',3584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',3600.01,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL);
INSERT INTO `balance_libro` VALUES (4140,7561,40727,1520,3,3585,'App\\Models\\Receipt',3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',24551.98,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4141,7561,40727,1520,3,3586,'App\\Models\\Receipt',3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',53678.02,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4142,7561,40727,1520,3,3587,'App\\Models\\Receipt',3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',2021.38,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4143,7561,40727,1520,3,3588,'App\\Models\\Receipt',3588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',3247.49,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4144,7561,40727,1520,3,3589,'App\\Models\\Receipt',3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',3774.35,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4145,7561,40727,1520,3,3590,'App\\Models\\Receipt',3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',27199.98,NULL,NULL,1,'2023-04-22 10:36:04','2023-04-22 10:36:04',NULL),(4146,7561,40727,1520,3,3591,'App\\Models\\Receipt',3591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',2205.05,NULL,NULL,1,'2023-04-22 10:36:05','2023-04-22 10:36:05',NULL),(4147,7561,40727,1520,3,3592,'App\\Models\\Receipt',3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',5413.42,NULL,NULL,1,'2023-04-22 10:36:05','2023-04-22 10:36:05',NULL),(4148,7561,40727,1520,3,3593,'App\\Models\\Receipt',3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',5994.05,NULL,NULL,1,'2023-04-22 10:36:05','2023-04-22 10:36:05',NULL),(4149,7561,40727,1520,3,3594,'App\\Models\\Receipt',3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',51261.65,NULL,NULL,1,'2023-04-22 10:36:05','2023-04-22 10:36:05',NULL),(4150,7561,40727,1520,3,3595,'App\\Models\\Receipt',3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',39774.53,NULL,NULL,1,'2023-04-22 10:36:05','2023-04-22 10:36:05',NULL),(4151,7561,40727,1520,3,3596,'App\\Models\\Receipt',3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',17504.10,NULL,NULL,1,'2023-04-22 10:36:05','2023-04-22 10:36:05',NULL),(4152,7561,40727,1520,3,3597,'App\\Models\\Receipt',3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',862.94,NULL,NULL,1,'2023-04-22 10:36:05','2023-04-22 10:36:05',NULL),(4153,7561,40727,1521,3,3598,'App\\Models\\Receipt',3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',324.75,NULL,NULL,1,'2023-04-22 10:38:22','2023-04-22 10:38:22',NULL),(4154,7561,40727,1521,3,3599,'App\\Models\\Receipt',3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',16750.27,NULL,NULL,1,'2023-04-22 10:38:22','2023-04-22 10:38:22',NULL),(4155,7561,40727,1521,3,3600,'App\\Models\\Receipt',3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',76083.59,NULL,NULL,1,'2023-04-22 10:38:23','2023-04-22 10:38:23',NULL),(4156,7561,40727,1521,3,3601,'App\\Models\\Receipt',3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',11759.26,NULL,NULL,1,'2023-04-22 10:38:23','2023-04-22 10:38:23',NULL),(4157,7561,40727,1521,3,3602,'App\\Models\\Receipt',3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2605.07,NULL,NULL,1,'2023-04-22 10:38:23','2023-04-22 10:38:23',NULL),(4158,7561,40727,1521,3,3603,'App\\Models\\Receipt',3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',50863.56,NULL,NULL,1,'2023-04-22 10:38:23','2023-04-22 10:38:23',NULL),(4159,7561,40727,1521,3,3604,'App\\Models\\Receipt',3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2588.32,NULL,NULL,1,'2023-04-22 10:38:23','2023-04-22 10:38:23',NULL),(4160,7561,40727,1521,3,3605,'App\\Models\\Receipt',3605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-10','2022-07-10',32507.62,NULL,NULL,1,'2023-04-22 10:38:23','2023-04-22 10:38:23',NULL);
INSERT INTO `balance_libro` VALUES (4161,7561,40727,1521,3,3606,'App\\Models\\Receipt',3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2399.45,NULL,NULL,1,'2023-04-22 10:38:23','2023-04-22 10:38:23',NULL),(4162,7561,40727,1521,3,3607,'App\\Models\\Receipt',3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',49105.43,NULL,NULL,1,'2023-04-22 10:38:23','2023-04-22 10:38:23',NULL),(4163,7561,40727,1521,3,3608,'App\\Models\\Receipt',3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5699.32,NULL,NULL,1,'2023-04-22 10:38:23','2023-04-22 10:38:23',NULL),(4164,7561,40727,1521,3,3609,'App\\Models\\Receipt',3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',40300.26,NULL,NULL,1,'2023-04-22 10:38:23','2023-04-22 10:38:23',NULL),(4165,7561,40727,1521,3,3610,'App\\Models\\Receipt',3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',28679.13,NULL,NULL,1,'2023-04-22 10:38:23','2023-04-22 10:38:23',NULL),(4166,7561,40727,1521,3,3611,'App\\Models\\Receipt',3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',4552.47,NULL,NULL,1,'2023-04-22 10:38:23','2023-04-22 10:38:23',NULL),(4167,7561,40727,1521,3,3612,'App\\Models\\Receipt',3612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',38971.87,NULL,NULL,1,'2023-04-22 10:38:23','2023-04-22 10:38:23',NULL),(4168,7561,40727,1521,3,3613,'App\\Models\\Receipt',3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',38913.60,NULL,NULL,1,'2023-04-22 10:38:23','2023-04-22 10:38:23',NULL),(4169,7561,40727,1521,3,3614,'App\\Models\\Receipt',3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',46729.24,NULL,NULL,1,'2023-04-22 10:38:23','2023-04-22 10:38:23',NULL),(4170,7561,40727,1521,3,3615,'App\\Models\\Receipt',3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',19037.00,NULL,NULL,1,'2023-04-22 10:38:23','2023-04-22 10:38:23',NULL),(4171,7561,40727,1521,3,3616,'App\\Models\\Receipt',3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',65915.96,NULL,NULL,1,'2023-04-22 10:38:23','2023-04-22 10:38:23',NULL),(4172,7561,40727,1521,3,3617,'App\\Models\\Receipt',3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',4086.83,NULL,NULL,1,'2023-04-22 10:38:23','2023-04-22 10:38:23',NULL),(4173,7561,40727,1521,3,3618,'App\\Models\\Receipt',3618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',6755.74,NULL,NULL,1,'2023-04-22 10:38:23','2023-04-22 10:38:23',NULL),(4174,7561,40727,1522,3,3619,'App\\Models\\Receipt',3619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',840.00,NULL,NULL,1,'2023-04-22 10:38:38','2023-04-22 10:38:38',NULL),(4175,7561,40727,1522,3,3620,'App\\Models\\Receipt',3620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',47744.00,NULL,NULL,1,'2023-04-22 10:38:38','2023-04-22 10:38:38',NULL),(4176,7561,40727,1522,3,3621,'App\\Models\\Receipt',3621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',44110.55,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4177,7561,40727,1522,3,3622,'App\\Models\\Receipt',3622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',55670.89,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4178,7561,40727,1522,3,3623,'App\\Models\\Receipt',3623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',826.25,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4179,7561,40727,1522,3,3624,'App\\Models\\Receipt',3624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',15609.89,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4180,7561,40727,1522,3,3625,'App\\Models\\Receipt',3625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',1313.28,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4181,7561,40727,1522,3,3626,'App\\Models\\Receipt',3626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',4533.26,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL);
INSERT INTO `balance_libro` VALUES (4182,7561,40727,1522,3,3627,'App\\Models\\Receipt',3627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',76027.93,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4183,7561,40727,1522,3,3628,'App\\Models\\Receipt',3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',1153.41,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4184,7561,40727,1522,3,3629,'App\\Models\\Receipt',3629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',7326.67,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4185,7561,40727,1522,3,3630,'App\\Models\\Receipt',3630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',3255.63,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4186,7561,40727,1522,3,3631,'App\\Models\\Receipt',3631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',17350.02,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4187,7561,40727,1522,3,3632,'App\\Models\\Receipt',3632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',51447.91,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4188,7561,40727,1522,3,3633,'App\\Models\\Receipt',3633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',3060.75,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4189,7561,40727,1522,3,3634,'App\\Models\\Receipt',3634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',82.63,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4190,7561,40727,1522,3,3635,'App\\Models\\Receipt',3635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',43140.53,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4191,7561,40727,1522,3,3636,'App\\Models\\Receipt',3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',33388.74,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4192,7561,40727,1522,3,3637,'App\\Models\\Receipt',3637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',2362.05,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4193,7561,40727,1522,3,3638,'App\\Models\\Receipt',3638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',25791.00,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4194,7561,40727,1522,3,3639,'App\\Models\\Receipt',3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',4496.30,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4195,7561,40727,1522,3,3640,'App\\Models\\Receipt',3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',38319.24,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4196,7561,40727,1522,3,3641,'App\\Models\\Receipt',3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',59770.37,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4197,7561,40727,1522,3,3642,'App\\Models\\Receipt',3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',5937.23,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4198,7561,40727,1522,3,3643,'App\\Models\\Receipt',3643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',27984.77,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4199,7561,40727,1522,3,3644,'App\\Models\\Receipt',3644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',40681.41,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4200,7561,40727,1522,3,3645,'App\\Models\\Receipt',3645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',33228.19,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4201,7561,40727,1522,3,3646,'App\\Models\\Receipt',3646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',47519.42,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL),(4202,7561,40727,1522,3,3647,'App\\Models\\Receipt',3647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',52191.18,NULL,NULL,1,'2023-04-22 10:38:39','2023-04-22 10:38:39',NULL);
INSERT INTO `balance_libro` VALUES (4203,7561,40727,1523,3,3648,'App\\Models\\Receipt',3648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',1536.39,NULL,NULL,1,'2023-04-22 10:39:04','2023-04-22 10:39:04',NULL),(4204,7561,40727,1523,3,3649,'App\\Models\\Receipt',3649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1369.04,NULL,NULL,1,'2023-04-22 10:39:04','2023-04-22 10:39:04',NULL),(4205,7561,40727,1523,3,3650,'App\\Models\\Receipt',3650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',6000.00,NULL,NULL,1,'2023-04-22 10:39:04','2023-04-22 10:39:04',NULL),(4206,7561,40727,1523,3,3651,'App\\Models\\Receipt',3651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',24930.14,NULL,NULL,1,'2023-04-22 10:39:04','2023-04-22 10:39:04',NULL),(4207,7561,40727,1523,3,3652,'App\\Models\\Receipt',3652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',19557.84,NULL,NULL,1,'2023-04-22 10:39:04','2023-04-22 10:39:04',NULL),(4208,7561,40727,1523,3,3653,'App\\Models\\Receipt',3653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',1572.77,NULL,NULL,1,'2023-04-22 10:39:04','2023-04-22 10:39:04',NULL),(4209,7561,40727,1523,3,3654,'App\\Models\\Receipt',3654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',52188.51,NULL,NULL,1,'2023-04-22 10:39:04','2023-04-22 10:39:04',NULL),(4210,7561,40727,1523,3,3655,'App\\Models\\Receipt',3655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',1239.58,NULL,NULL,1,'2023-04-22 10:39:04','2023-04-22 10:39:04',NULL),(4211,7561,40727,1523,3,3656,'App\\Models\\Receipt',3656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',4790.79,NULL,NULL,1,'2023-04-22 10:39:04','2023-04-22 10:39:04',NULL),(4212,7561,40727,1523,3,3657,'App\\Models\\Receipt',3657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',1105.38,NULL,NULL,1,'2023-04-22 10:39:04','2023-04-22 10:39:04',NULL),(4213,7561,40727,1523,3,3658,'App\\Models\\Receipt',3658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',42116.78,NULL,NULL,1,'2023-04-22 10:39:04','2023-04-22 10:39:04',NULL),(4214,7561,40727,1523,3,3659,'App\\Models\\Receipt',3659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',69594.36,NULL,NULL,1,'2023-04-22 10:39:04','2023-04-22 10:39:04',NULL),(4215,7561,40727,1523,3,3660,'App\\Models\\Receipt',3660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',21634.80,NULL,NULL,1,'2023-04-22 10:39:04','2023-04-22 10:39:04',NULL),(4216,7561,40727,1523,3,3661,'App\\Models\\Receipt',3661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',6199.99,NULL,NULL,1,'2023-04-22 10:39:04','2023-04-22 10:39:04',NULL),(4217,7561,40727,1523,3,3662,'App\\Models\\Receipt',3662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',123.96,NULL,NULL,1,'2023-04-22 10:39:04','2023-04-22 10:39:04',NULL),(4218,7561,40727,1523,3,3663,'App\\Models\\Receipt',3663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',21740.07,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL),(4219,7561,40727,1523,3,3664,'App\\Models\\Receipt',3664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',28867.84,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL),(4220,7561,40727,1523,3,3665,'App\\Models\\Receipt',3665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',52455.92,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL),(4221,7561,40727,1523,3,3666,'App\\Models\\Receipt',3666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',7231.32,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL),(4222,7561,40727,1523,3,3667,'App\\Models\\Receipt',3667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',2418.94,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL),(4223,7561,40727,1523,3,3668,'App\\Models\\Receipt',3668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',24779.59,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL);
INSERT INTO `balance_libro` VALUES (4224,7561,40727,1523,3,3669,'App\\Models\\Receipt',3669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',1846.90,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL),(4225,7561,40727,1523,3,3670,'App\\Models\\Receipt',3670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',22071.79,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL),(4226,7561,40727,1523,3,3671,'App\\Models\\Receipt',3671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',8822.61,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL),(4227,7561,40727,1523,3,3672,'App\\Models\\Receipt',3672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',23951.93,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL),(4228,7561,40727,1523,3,3673,'App\\Models\\Receipt',3673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',19157.52,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL),(4229,7561,40727,1523,3,3674,'App\\Models\\Receipt',3674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',40115.13,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL),(4230,7561,40727,1523,3,3675,'App\\Models\\Receipt',3675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',17434.17,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL),(4231,7561,40727,1523,3,3676,'App\\Models\\Receipt',3676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',54072.48,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL),(4232,7561,40727,1523,3,3677,'App\\Models\\Receipt',3677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',184.69,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL),(4233,7561,40727,1523,3,3678,'App\\Models\\Receipt',3678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',72279.35,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL),(4234,7561,40727,1523,3,3679,'App\\Models\\Receipt',3679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',4300.00,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL),(4235,7561,40727,1523,3,3680,'App\\Models\\Receipt',3680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',7288.57,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL),(4236,7561,40727,1523,3,3681,'App\\Models\\Receipt',3681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',3350.01,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL),(4237,7561,40727,1523,3,3682,'App\\Models\\Receipt',3682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',32713.56,NULL,NULL,1,'2023-04-22 10:39:05','2023-04-22 10:39:05',NULL),(4238,7561,40727,1516,3,3683,'App\\Models\\Receipt',3683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',31951.55,NULL,NULL,1,'2023-04-22 10:44:32','2023-04-22 10:44:32',NULL),(4239,7561,40727,1516,3,3684,'App\\Models\\Receipt',3684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',41490.90,NULL,NULL,1,'2023-04-22 10:44:32','2023-04-22 10:44:32',NULL),(4240,7561,40727,1516,3,3685,'App\\Models\\Receipt',3685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',1012.71,NULL,NULL,1,'2023-04-22 10:44:32','2023-04-22 10:44:32',NULL),(4241,7561,40727,1516,3,3686,'App\\Models\\Receipt',3686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',36695.67,NULL,NULL,1,'2023-04-22 10:44:32','2023-04-22 10:44:32',NULL),(4242,7561,40727,1516,3,3687,'App\\Models\\Receipt',3687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',1860.10,NULL,NULL,1,'2023-04-22 10:44:32','2023-04-22 10:44:32',NULL),(4243,7561,40727,1516,3,3688,'App\\Models\\Receipt',3688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',13431.00,NULL,NULL,1,'2023-04-22 10:44:32','2023-04-22 10:44:32',NULL),(4244,7561,40727,1516,3,3689,'App\\Models\\Receipt',3689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',16673.80,NULL,NULL,1,'2023-04-22 10:44:32','2023-04-22 10:44:32',NULL);
INSERT INTO `balance_libro` VALUES (4245,7561,40727,1516,3,3690,'App\\Models\\Receipt',3690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',9160.06,NULL,NULL,1,'2023-04-22 10:44:32','2023-04-22 10:44:32',NULL),(4246,7561,40727,1516,3,3691,'App\\Models\\Receipt',3691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',13838.00,NULL,NULL,1,'2023-04-22 10:44:32','2023-04-22 10:44:32',NULL),(4247,7561,40727,1516,3,3692,'App\\Models\\Receipt',3692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',24352.79,NULL,NULL,1,'2023-04-22 10:44:32','2023-04-22 10:44:32',NULL),(4248,7561,40727,1516,3,3693,'App\\Models\\Receipt',3693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',11650.00,NULL,NULL,1,'2023-04-22 10:44:32','2023-04-22 10:44:32',NULL),(4249,7561,40727,1516,3,3694,'App\\Models\\Receipt',3694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',2099.45,NULL,NULL,1,'2023-04-22 10:44:32','2023-04-22 10:44:32',NULL),(4250,7561,40727,1516,3,3695,'App\\Models\\Receipt',3695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',1649.63,NULL,NULL,1,'2023-04-22 10:44:32','2023-04-22 10:44:32',NULL),(4251,7561,40727,1517,3,3696,'App\\Models\\Receipt',3696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',62477.14,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4252,7561,40727,1517,3,3697,'App\\Models\\Receipt',3697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',17561.10,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4253,7561,40727,1517,3,3698,'App\\Models\\Receipt',3698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',29657.71,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4254,7561,40727,1517,3,3699,'App\\Models\\Receipt',3699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',29367.95,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4255,7561,40727,1517,3,3700,'App\\Models\\Receipt',3700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',29657.71,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4256,7561,40727,1517,3,3701,'App\\Models\\Receipt',3701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',15884.88,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4257,7561,40727,1517,3,3702,'App\\Models\\Receipt',3702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',28079.26,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4258,7561,40727,1517,3,3703,'App\\Models\\Receipt',3703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',2224.40,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4259,7561,40727,1517,3,3704,'App\\Models\\Receipt',3704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',1898.32,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4260,7561,40727,1517,3,3705,'App\\Models\\Receipt',3705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',37374.48,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4261,7561,40727,1517,3,3706,'App\\Models\\Receipt',3706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',21030.32,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4262,7561,40727,1517,3,3707,'App\\Models\\Receipt',3707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',6933.05,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4263,7561,40727,1517,3,3708,'App\\Models\\Receipt',3708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',27077.38,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4264,7561,40727,1517,3,3709,'App\\Models\\Receipt',3709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',9320.02,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4265,7561,40727,1517,3,3710,'App\\Models\\Receipt',3710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',2989.92,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL);
INSERT INTO `balance_libro` VALUES (4266,7561,40727,1517,3,3711,'App\\Models\\Receipt',3711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',4370.19,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4267,7561,40727,1517,3,3712,'App\\Models\\Receipt',3712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',2009.62,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4268,7561,40727,1517,3,3713,'App\\Models\\Receipt',3713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',3206.50,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4269,7561,40727,1517,3,3714,'App\\Models\\Receipt',3714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',63015.59,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4270,7561,40727,1517,3,3715,'App\\Models\\Receipt',3715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',52544.42,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4271,7561,40727,1517,3,3716,'App\\Models\\Receipt',3716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3206.50,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4272,7561,40727,1517,3,3717,'App\\Models\\Receipt',3717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',2099.44,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4273,7561,40727,1517,3,3718,'App\\Models\\Receipt',3718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',10872.00,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4274,7561,40727,1517,3,3719,'App\\Models\\Receipt',3719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1114.84,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4275,7561,40727,1517,3,3720,'App\\Models\\Receipt',3720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',21459.05,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4276,7561,40727,1517,3,3721,'App\\Models\\Receipt',3721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',10403.93,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4277,7561,40727,1517,3,3722,'App\\Models\\Receipt',3722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1125.78,NULL,NULL,1,'2023-04-22 10:44:51','2023-04-22 10:44:51',NULL),(4278,7561,40727,1524,3,3723,'App\\Models\\Receipt',3723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',32107.54,NULL,NULL,1,'2023-04-22 10:45:07','2023-04-22 10:45:07',NULL),(4279,7561,40727,1524,3,3724,'App\\Models\\Receipt',3724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',78562.88,NULL,NULL,1,'2023-04-22 10:45:07','2023-04-22 10:45:07',NULL),(4280,7561,40727,1524,3,3725,'App\\Models\\Receipt',3725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',9438.53,NULL,NULL,1,'2023-04-22 10:45:07','2023-04-22 10:45:07',NULL),(4281,7561,40727,1524,3,3726,'App\\Models\\Receipt',3726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',6000.00,NULL,NULL,1,'2023-04-22 10:45:07','2023-04-22 10:45:07',NULL),(4282,7561,40727,1524,3,3727,'App\\Models\\Receipt',3727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2743.49,NULL,NULL,1,'2023-04-22 10:45:07','2023-04-22 10:45:07',NULL),(4283,7561,40727,1524,3,3728,'App\\Models\\Receipt',3728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',271700.48,NULL,NULL,1,'2023-04-22 10:45:07','2023-04-22 10:45:07',NULL),(4284,7561,40727,1524,3,3729,'App\\Models\\Receipt',3729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',46460.37,NULL,NULL,1,'2023-04-22 10:45:07','2023-04-22 10:45:07',NULL),(4285,7561,40727,1524,3,3730,'App\\Models\\Receipt',3730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2726.17,NULL,NULL,1,'2023-04-22 10:45:07','2023-04-22 10:45:07',NULL),(4286,7561,40727,1524,3,3731,'App\\Models\\Receipt',3731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',39861.03,NULL,NULL,1,'2023-04-22 10:45:07','2023-04-22 10:45:07',NULL);
INSERT INTO `balance_libro` VALUES (4287,7561,40727,1524,3,3732,'App\\Models\\Receipt',3732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',31643.92,NULL,NULL,1,'2023-04-22 10:45:07','2023-04-22 10:45:07',NULL),(4288,7561,40727,1524,3,3733,'App\\Models\\Receipt',3733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',30133.25,NULL,NULL,1,'2023-04-22 10:45:07','2023-04-22 10:45:07',NULL),(4289,7561,40727,1524,3,3734,'App\\Models\\Receipt',3734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',4640.00,NULL,NULL,1,'2023-04-22 10:45:07','2023-04-22 10:45:07',NULL),(4290,7561,40727,1524,3,3735,'App\\Models\\Receipt',3735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',49471.91,NULL,NULL,1,'2023-04-22 10:45:07','2023-04-22 10:45:07',NULL),(4291,7561,40727,1524,3,3736,'App\\Models\\Receipt',3736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',59885.32,NULL,NULL,1,'2023-04-22 10:45:07','2023-04-22 10:45:07',NULL),(4292,7561,40727,1524,3,3737,'App\\Models\\Receipt',3737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',8158.22,NULL,NULL,1,'2023-04-22 10:45:08','2023-04-22 10:45:08',NULL),(4293,7561,40727,1524,3,3738,'App\\Models\\Receipt',3738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',30418.49,NULL,NULL,1,'2023-04-22 10:45:08','2023-04-22 10:45:08',NULL),(4294,7561,40727,1524,3,3739,'App\\Models\\Receipt',3739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',54204.37,NULL,NULL,1,'2023-04-22 10:45:08','2023-04-22 10:45:08',NULL),(4295,7561,40727,1524,3,3740,'App\\Models\\Receipt',3740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',33795.06,NULL,NULL,1,'2023-04-22 10:45:08','2023-04-22 10:45:08',NULL),(4296,7561,40727,1524,3,3741,'App\\Models\\Receipt',3741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',17344.81,NULL,NULL,1,'2023-04-22 10:45:08','2023-04-22 10:45:08',NULL),(4297,7561,40727,1524,3,3742,'App\\Models\\Receipt',3742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2111.55,NULL,NULL,1,'2023-04-22 10:45:08','2023-04-22 10:45:08',NULL),(4298,7561,40727,1524,3,3743,'App\\Models\\Receipt',3743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',8913.51,NULL,NULL,1,'2023-04-22 10:45:08','2023-04-22 10:45:08',NULL),(4318,7561,40725,3027,2,2709,'App\\Models\\Receipt',2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',49713.50,NULL,NULL,1,'2023-04-22 11:31:29','2023-04-22 11:31:29',NULL),(4319,7561,40725,3027,2,2717,'App\\Models\\Receipt',2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',3940.00,NULL,NULL,1,'2023-04-22 11:32:13','2023-04-22 11:32:13',NULL),(4320,7561,40725,3027,2,2718,'App\\Models\\Receipt',2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',620511.99,NULL,NULL,1,'2023-04-22 11:32:52','2023-04-22 11:32:52',NULL),(4321,7561,40725,3027,2,2714,'App\\Models\\Receipt',2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',8545.02,NULL,NULL,1,'2023-04-22 11:34:05','2023-04-22 11:34:05',NULL),(4322,7561,40725,3027,2,2716,'App\\Models\\Receipt',2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',27817.90,NULL,NULL,1,'2023-04-22 11:34:34','2023-04-22 11:34:34',NULL),(4323,7561,40725,3035,2,2895,'App\\Models\\Receipt',2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',63131.75,NULL,NULL,1,'2023-04-22 11:37:56','2023-04-22 11:59:29','2023-04-22 11:59:29'),(4324,7561,40725,3036,2,2935,'App\\Models\\Receipt',2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',29931.77,NULL,NULL,1,'2023-04-22 11:38:15','2023-04-22 11:38:15',NULL),(4325,7561,40725,3036,2,2933,'App\\Models\\Receipt',2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',56228.70,NULL,NULL,1,'2023-04-22 11:39:09','2023-04-22 11:39:09',NULL),(4326,7561,40725,3036,2,2930,'App\\Models\\Receipt',2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',6300.00,NULL,NULL,1,'2023-04-22 11:39:52','2023-04-22 11:39:52',NULL);
INSERT INTO `balance_libro` VALUES (4327,7561,40725,3036,2,2929,'App\\Models\\Receipt',2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',89443.20,NULL,NULL,1,'2023-04-22 11:40:20','2023-04-22 11:40:20',NULL),(4328,7561,40725,3036,2,2928,'App\\Models\\Receipt',2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',84488.25,NULL,NULL,1,'2023-04-22 11:40:36','2023-04-22 11:40:36',NULL),(4329,7561,40725,3036,2,2927,'App\\Models\\Receipt',2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',82080.35,NULL,NULL,1,'2023-04-22 11:40:50','2023-04-22 11:40:50',NULL),(4330,7561,40725,3036,2,2923,'App\\Models\\Receipt',2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',25797.20,NULL,NULL,1,'2023-04-22 11:41:21','2023-04-22 11:41:21',NULL),(4331,7561,40725,3036,2,2921,'App\\Models\\Receipt',2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',29947.50,NULL,NULL,1,'2023-04-22 11:41:36','2023-04-22 11:41:36',NULL),(4332,7561,40725,3036,2,2920,'App\\Models\\Receipt',2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',21254.86,NULL,NULL,1,'2023-04-22 11:43:28','2023-04-22 11:43:28',NULL),(4333,7561,40725,3036,2,2919,'App\\Models\\Receipt',2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',190280.97,NULL,NULL,1,'2023-04-22 11:43:56','2023-04-22 11:43:56',NULL),(4334,7561,40725,3036,2,2918,'App\\Models\\Receipt',2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',35150.50,NULL,NULL,1,'2023-04-22 11:44:29','2023-04-22 11:44:29',NULL),(4335,7561,40725,3036,2,2917,'App\\Models\\Receipt',2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',23843.05,NULL,NULL,1,'2023-04-22 11:44:51','2023-04-22 11:44:51',NULL),(4336,7561,40725,3036,2,2914,'App\\Models\\Receipt',2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',15325.86,NULL,NULL,1,'2023-04-22 11:53:32','2023-04-22 11:53:32',NULL),(4337,7561,40725,3036,2,2913,'App\\Models\\Receipt',2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',33270.16,NULL,NULL,1,'2023-04-22 11:54:04','2023-04-22 11:54:04',NULL),(4338,7561,40725,3035,2,2911,'App\\Models\\Receipt',2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',49337.75,NULL,NULL,1,'2023-04-22 11:54:19','2023-04-22 11:54:19',NULL),(4339,7561,40725,3035,2,2908,'App\\Models\\Receipt',2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',26656.30,NULL,NULL,1,'2023-04-22 11:54:44','2023-04-22 11:54:44',NULL),(4340,7561,40725,3035,2,2907,'App\\Models\\Receipt',2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',55557.86,NULL,NULL,1,'2023-04-22 11:55:13','2023-04-22 11:55:13',NULL),(4341,7561,40725,3035,2,2906,'App\\Models\\Receipt',2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',25754.85,NULL,NULL,1,'2023-04-22 11:55:51','2023-04-22 11:55:51',NULL),(4342,7561,40725,3035,2,2904,'App\\Models\\Receipt',2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',25854.72,NULL,NULL,1,'2023-04-22 11:56:33','2023-04-22 11:56:33',NULL),(4343,7561,40725,3035,2,2903,'App\\Models\\Receipt',2903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',54026.50,NULL,NULL,1,'2023-04-22 11:56:58','2023-04-22 11:56:58',NULL),(4344,7561,40725,3035,2,2902,'App\\Models\\Receipt',2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',22210.00,NULL,NULL,1,'2023-04-22 11:57:15','2023-04-22 11:57:15',NULL),(4345,7561,40725,3035,2,2901,'App\\Models\\Receipt',2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',104371.57,NULL,NULL,1,'2023-04-22 11:57:39','2023-04-22 11:57:39',NULL),(4346,7561,40725,3035,2,2899,'App\\Models\\Receipt',2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',43624.31,NULL,NULL,1,'2023-04-22 11:58:35','2023-04-22 11:58:35',NULL),(4347,7561,40725,3035,2,2894,'App\\Models\\Receipt',2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',44134.75,NULL,NULL,1,'2023-04-22 11:59:17','2023-04-22 12:14:58','2023-04-22 12:14:58');
INSERT INTO `balance_libro` VALUES (4348,7561,40725,3035,2,2895,'App\\Models\\Receipt',2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',63131.75,NULL,NULL,1,'2023-04-22 11:59:29','2023-04-22 11:59:29',NULL),(4349,7561,40725,3035,2,2889,'App\\Models\\Receipt',2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',31551.96,NULL,NULL,1,'2023-04-22 12:00:22','2023-04-22 12:00:22',NULL),(4350,7561,40725,3037,2,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',115260.00,NULL,NULL,1,'2023-04-22 12:01:10','2023-04-22 12:01:10',NULL),(4351,7561,40725,3037,2,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',55889.90,NULL,NULL,1,'2023-04-22 12:01:43','2023-04-22 12:01:43',NULL),(4352,7561,40725,3038,2,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',72914.60,NULL,NULL,1,'2023-04-22 12:03:46','2023-04-22 12:03:46',NULL),(4353,7561,40725,3038,2,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',113135.00,NULL,NULL,1,'2023-04-22 12:04:20','2023-04-22 12:04:20',NULL),(4354,7561,40725,3038,2,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',35534.72,NULL,NULL,1,'2023-04-22 12:05:33','2023-04-22 12:05:33',NULL),(4355,7561,40725,3038,2,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',35534.72,NULL,NULL,1,'2023-04-22 12:06:03','2023-04-22 12:06:03',NULL),(4356,7561,40725,3038,2,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',41761.94,NULL,NULL,1,'2023-04-22 12:06:38','2023-04-22 12:06:38',NULL),(4357,7561,40725,3038,2,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',82011.68,NULL,NULL,1,'2023-04-22 12:07:04','2023-04-22 12:07:04',NULL),(4358,7561,40725,3038,2,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',105704.75,NULL,NULL,1,'2023-04-22 12:07:24','2023-04-22 12:07:24',NULL),(4359,7561,40725,3038,2,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',68613.66,NULL,NULL,1,'2023-04-22 12:07:55','2023-04-22 12:07:55',NULL),(4360,7561,40725,3038,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',63407.02,NULL,NULL,1,'2023-04-22 12:08:25','2023-04-22 12:08:25',NULL),(4361,7561,40725,3038,2,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',6820.00,NULL,NULL,1,'2023-04-22 12:09:03','2023-04-22 12:09:03',NULL),(4362,7561,40725,3038,2,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',54251.56,NULL,NULL,1,'2023-04-22 12:09:32','2023-04-22 12:09:32',NULL),(4363,7561,40725,3038,2,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',2543.40,NULL,NULL,1,'2023-04-22 12:10:21','2023-04-22 12:10:21',NULL),(4364,7561,40725,3038,2,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',85745.44,NULL,NULL,1,'2023-04-22 12:10:43','2023-04-22 12:10:43',NULL),(4365,7561,40725,3038,2,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',128949.70,NULL,NULL,1,'2023-04-22 12:11:16','2023-04-22 12:11:16',NULL),(4366,7561,40725,3038,2,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',99099.00,NULL,NULL,1,'2023-04-22 12:11:43','2023-04-22 12:11:43',NULL),(4367,7561,40725,3038,2,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',177006.06,NULL,NULL,1,'2023-04-22 12:12:10','2023-04-22 12:12:10',NULL),(4368,7561,40725,3038,2,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',119644.80,NULL,NULL,1,'2023-04-22 12:12:30','2023-04-22 12:12:30',NULL);
INSERT INTO `balance_libro` VALUES (4369,7561,40725,3038,2,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',146129.88,NULL,NULL,1,'2023-04-22 12:13:04','2023-04-22 12:13:04',NULL),(4370,7561,40725,3038,2,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',127413.00,NULL,NULL,1,'2023-04-22 12:13:24','2023-04-22 12:13:24',NULL),(4371,7561,40725,3038,2,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',23123.10,NULL,NULL,1,'2023-04-22 12:13:45','2023-04-22 12:13:45',NULL),(4372,7561,40725,3037,2,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',55690.25,NULL,NULL,1,'2023-04-22 12:14:07','2023-04-22 12:14:07',NULL),(4373,7561,40725,3037,2,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',12886.50,NULL,NULL,1,'2023-04-22 12:14:26','2023-04-22 12:14:26',NULL),(4374,7561,40725,3035,2,2894,'App\\Models\\Receipt',2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',44134.75,NULL,NULL,1,'2023-04-22 12:14:58','2023-04-22 12:14:58',NULL),(4375,7561,40725,3035,2,2891,'App\\Models\\Receipt',2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',6300.00,NULL,NULL,1,'2023-04-22 12:15:23','2023-04-22 12:15:23',NULL),(4376,7561,40725,3035,2,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',86333.50,NULL,NULL,1,'2023-04-22 12:16:16','2023-04-22 12:16:16',NULL),(4377,7561,40725,3035,2,2886,'App\\Models\\Receipt',2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',47508.23,NULL,NULL,1,'2023-04-22 12:18:55','2023-04-22 12:18:55',NULL),(4378,7561,40725,3035,2,2883,'App\\Models\\Receipt',2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',37103.44,NULL,NULL,1,'2023-04-22 12:19:29','2023-04-22 12:19:29',NULL),(4379,7561,40725,3035,2,2882,'App\\Models\\Receipt',2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',244273.44,NULL,NULL,1,'2023-04-22 12:19:51','2023-04-22 12:19:51',NULL),(4380,7561,40725,3034,2,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',22631.84,NULL,NULL,1,'2023-04-22 12:20:32','2023-04-22 12:20:32',NULL),(4381,7561,40725,3034,2,2879,'App\\Models\\Receipt',2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',1281256.90,NULL,NULL,1,'2023-04-22 12:21:17','2023-04-22 12:21:17',NULL),(4382,7561,40725,3034,2,2877,'App\\Models\\Receipt',2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',139263.74,NULL,NULL,1,'2023-04-22 12:21:36','2023-04-22 12:21:36',NULL),(4383,7561,40725,3034,2,2876,'App\\Models\\Receipt',2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',37103.44,NULL,NULL,1,'2023-04-22 12:24:57','2023-04-22 12:24:57',NULL),(4384,7561,40725,3034,2,2875,'App\\Models\\Receipt',2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',2238.50,NULL,NULL,1,'2023-04-22 12:25:24','2023-04-22 12:25:24',NULL),(4385,7561,40725,3034,2,2873,'App\\Models\\Receipt',2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',33915.64,NULL,NULL,1,'2023-04-22 12:26:01','2023-04-22 12:26:01',NULL),(4386,7561,40725,3034,2,2871,'App\\Models\\Receipt',2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',64614.36,NULL,NULL,1,'2023-04-22 12:26:53','2023-04-22 12:26:53',NULL),(4387,7561,40725,3034,2,2869,'App\\Models\\Receipt',2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',89733.60,NULL,NULL,1,'2023-04-22 12:27:47','2023-04-22 12:27:47',NULL),(4388,7561,40725,3034,2,2868,'App\\Models\\Receipt',2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',34776.39,NULL,NULL,1,'2023-04-22 12:28:18','2023-04-22 12:28:18',NULL),(4389,7561,40725,3034,2,2867,'App\\Models\\Receipt',2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',84185.75,NULL,NULL,1,'2023-04-22 12:28:34','2023-04-22 12:28:34',NULL);
INSERT INTO `balance_libro` VALUES (4390,7561,40725,3034,2,2864,'App\\Models\\Receipt',2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-07','2022-08-07',156489.30,NULL,NULL,1,'2023-04-25 14:46:59','2023-04-25 14:46:59',NULL),(4391,7561,40725,3034,2,2862,'App\\Models\\Receipt',2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',42483.10,NULL,NULL,1,'2023-04-25 14:47:41','2023-04-25 14:47:41',NULL),(4392,7561,40725,3033,2,2860,'App\\Models\\Receipt',2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',47667.33,NULL,NULL,1,'2023-04-25 14:48:20','2023-04-25 14:48:20',NULL),(4393,7561,40725,3033,2,2856,'App\\Models\\Receipt',2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',85547.00,NULL,NULL,1,'2023-04-25 14:49:08','2023-04-25 14:49:08',NULL),(4394,7561,40725,3033,2,2859,'App\\Models\\Receipt',2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',92872.34,NULL,NULL,1,'2023-04-25 14:50:13','2023-04-25 14:50:13',NULL),(4395,7561,40725,3033,2,2855,'App\\Models\\Receipt',2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',115107.30,NULL,NULL,1,'2023-04-25 14:50:58','2023-04-25 14:50:58',NULL),(4396,7561,40725,3033,2,2854,'App\\Models\\Receipt',2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',24684.00,NULL,NULL,1,'2023-04-25 14:51:23','2023-04-25 14:51:23',NULL),(4397,7561,40725,3033,2,2852,'App\\Models\\Receipt',2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-10','2022-07-10',51146.70,NULL,NULL,1,'2023-04-25 14:51:57','2023-04-25 14:51:57',NULL),(4398,7561,40725,3033,2,2850,'App\\Models\\Receipt',2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',19420.50,NULL,NULL,1,'2023-04-25 14:52:49','2023-04-25 14:52:49',NULL),(4399,7561,40725,3033,2,2851,'App\\Models\\Receipt',2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-10','2022-07-10',73285.74,NULL,NULL,1,'2023-04-25 14:53:39','2023-04-25 14:53:39',NULL),(4400,7561,40725,3032,2,2846,'App\\Models\\Receipt',2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',114677.02,NULL,NULL,1,'2023-04-25 14:54:59','2023-04-25 14:54:59',NULL),(4401,7561,40725,3032,2,2845,'App\\Models\\Receipt',2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',176224.40,NULL,NULL,1,'2023-04-25 14:55:33','2023-04-25 14:55:33',NULL),(4402,7561,40725,3032,2,2843,'App\\Models\\Receipt',2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',89588.40,NULL,NULL,1,'2023-04-25 15:04:50','2023-04-25 15:04:50',NULL),(4403,7561,40725,3032,2,2842,'App\\Models\\Receipt',2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',60923.50,NULL,NULL,1,'2023-04-25 15:05:23','2023-04-25 15:05:23',NULL),(4404,7561,40725,3032,2,2839,'App\\Models\\Receipt',2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',50699.00,NULL,NULL,1,'2023-04-25 15:06:33','2023-04-25 15:08:24','2023-04-25 15:08:24'),(4405,7561,40725,3032,2,2839,'App\\Models\\Receipt',2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',50699.00,NULL,NULL,1,'2023-04-25 15:08:24','2023-04-25 15:08:24',NULL),(4406,7561,40725,3032,2,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',92274.60,NULL,NULL,1,'2023-04-25 15:08:52','2023-04-25 15:08:52',NULL),(4407,7561,40725,3032,2,2834,'App\\Models\\Receipt',2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',10490.70,NULL,NULL,1,'2023-04-25 15:09:57','2023-04-25 15:09:57',NULL),(4408,7561,40725,3032,2,2832,'App\\Models\\Receipt',2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',57039.40,NULL,NULL,1,'2023-04-25 15:10:40','2023-04-25 15:11:35','2023-04-25 15:11:35'),(4409,7561,40725,3032,2,2832,'App\\Models\\Receipt',2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',57039.40,NULL,NULL,1,'2023-04-25 15:11:35','2023-04-25 15:11:35',NULL);
INSERT INTO `balance_libro` VALUES (4410,7561,40725,3032,2,2831,'App\\Models\\Receipt',2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',27084.64,NULL,NULL,1,'2023-04-25 15:11:59','2023-04-25 15:11:59',NULL),(4411,7561,40725,3032,2,2830,'App\\Models\\Receipt',2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',45290.30,NULL,NULL,1,'2023-04-25 15:12:48','2023-04-25 15:12:48',NULL),(4412,7561,40725,3032,2,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-05','2022-06-05',161700.33,NULL,NULL,1,'2023-04-25 15:14:00','2023-04-25 15:14:00',NULL),(4413,7561,40725,3031,2,2823,'App\\Models\\Receipt',2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',6146.80,NULL,NULL,1,'2023-04-25 15:15:31','2023-04-25 15:15:31',NULL),(4414,7561,40725,3031,2,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-25','2022-05-25',23909.60,NULL,NULL,1,'2023-04-25 15:17:25','2023-04-25 15:17:25',NULL),(4415,7561,40725,3031,2,2816,'App\\Models\\Receipt',2816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',15495.26,NULL,NULL,1,'2023-04-25 15:20:34','2023-04-25 15:20:34',NULL),(4416,7561,40725,3031,2,2815,'App\\Models\\Receipt',2815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',347553.74,NULL,NULL,1,'2023-04-25 15:21:23','2023-04-25 15:21:23',NULL),(4417,7561,40725,3031,2,2813,'App\\Models\\Receipt',2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-15','2022-05-15',68510.20,NULL,NULL,1,'2023-04-25 15:22:09','2023-04-25 15:22:09',NULL),(4418,7561,40725,3031,2,2812,'App\\Models\\Receipt',2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-15','2022-05-15',59731.31,NULL,NULL,1,'2023-04-25 15:22:51','2023-04-25 15:22:51',NULL),(4419,7561,40725,3031,2,2810,'App\\Models\\Receipt',2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',6135.99,NULL,NULL,1,'2023-04-25 15:24:02','2023-04-25 15:24:02',NULL),(4420,7561,40725,3031,2,2811,'App\\Models\\Receipt',2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',8760.40,NULL,NULL,1,'2023-04-25 15:24:37','2023-04-25 15:24:37',NULL),(4421,7561,40725,3031,2,2808,'App\\Models\\Receipt',2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',14700.00,NULL,NULL,1,'2023-04-25 15:25:19','2023-04-25 15:25:19',NULL),(4422,7561,40725,3031,2,2809,'App\\Models\\Receipt',2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',96613.66,NULL,NULL,1,'2023-04-25 15:25:54','2023-04-25 15:25:54',NULL),(4423,7561,40725,3031,2,2807,'App\\Models\\Receipt',2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',22545.93,NULL,NULL,1,'2023-04-25 15:26:46','2023-04-25 15:26:46',NULL),(4424,7561,40725,3031,2,2806,'App\\Models\\Receipt',2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',95989.30,NULL,NULL,1,'2023-04-25 15:27:11','2023-04-25 15:27:11',NULL),(4425,7561,40725,3031,2,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',16226.10,NULL,NULL,1,'2023-04-25 15:28:11','2023-04-25 15:28:11',NULL),(4426,7561,40725,3031,2,2801,'App\\Models\\Receipt',2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',25545.08,NULL,NULL,1,'2023-04-25 15:28:43','2023-04-25 15:28:43',NULL),(4427,7561,40725,3030,2,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',39195.31,NULL,NULL,1,'2023-04-25 15:30:21','2023-04-25 15:30:21',NULL),(4428,7561,40725,3030,2,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',19577.80,NULL,NULL,1,'2023-04-25 15:30:48','2023-04-25 15:30:48',NULL),(4429,7561,40725,3030,2,2796,'App\\Models\\Receipt',2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',10962.60,NULL,NULL,1,'2023-04-25 15:31:35','2023-04-25 15:31:35',NULL),(4430,7561,40725,3030,2,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',61078.79,NULL,NULL,1,'2023-04-25 15:32:25','2023-04-25 15:32:25',NULL);
INSERT INTO `balance_libro` VALUES (4431,7561,40725,3030,2,2794,'App\\Models\\Receipt',2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',55998.80,NULL,NULL,1,'2023-04-25 15:33:04','2023-04-25 15:33:04',NULL),(4432,7561,40725,3030,2,2793,'App\\Models\\Receipt',2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',30435.13,NULL,NULL,1,'2023-04-25 15:33:59','2023-04-25 15:33:59',NULL),(4433,7561,40725,3030,2,2792,'App\\Models\\Receipt',2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',61147.35,NULL,NULL,1,'2023-04-25 15:34:30','2023-04-25 15:34:30',NULL),(4434,7561,40725,3030,2,2791,'App\\Models\\Receipt',2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',93879.83,NULL,NULL,1,'2023-04-25 15:35:20','2023-04-25 15:35:20',NULL),(4435,7561,40725,3030,2,2788,'App\\Models\\Receipt',2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',28984.34,NULL,NULL,1,'2023-04-25 15:36:33','2023-04-25 15:36:33',NULL),(4436,7561,40725,3030,2,2786,'App\\Models\\Receipt',2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',80322.12,NULL,NULL,1,'2023-04-25 15:37:46','2023-04-25 15:37:46',NULL),(4437,7561,40725,3030,2,2783,'App\\Models\\Receipt',2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',12080.88,NULL,NULL,1,'2023-04-25 15:39:02','2023-04-25 15:39:02',NULL),(4438,7561,40725,3030,2,2781,'App\\Models\\Receipt',2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-17','2022-04-17',48877.95,NULL,NULL,1,'2023-04-25 15:39:24','2023-04-25 15:39:24',NULL),(4439,7561,40725,3030,2,2780,'App\\Models\\Receipt',2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-17','2022-04-17',136028.20,NULL,NULL,1,'2023-04-25 15:39:46','2023-04-25 15:39:46',NULL),(4440,7561,40725,3030,2,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',52616.85,NULL,NULL,1,'2023-04-25 15:40:08','2023-04-25 15:40:08',NULL),(4441,7561,40725,3030,2,2777,'App\\Models\\Receipt',2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',535841.24,NULL,NULL,1,'2023-04-25 15:41:40','2023-04-25 15:41:40',NULL),(4442,7561,40725,3030,2,2775,'App\\Models\\Receipt',2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',97598.60,NULL,NULL,1,'2023-04-25 15:42:37','2023-04-25 15:42:37',NULL),(4443,7561,40725,3030,2,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',27569.85,NULL,NULL,1,'2023-04-25 15:43:01','2023-04-25 15:43:01',NULL),(4444,7561,40725,3030,2,2772,'App\\Models\\Receipt',2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',43130.45,NULL,NULL,1,'2023-04-25 15:43:39','2023-04-25 15:43:39',NULL),(4445,7561,40725,3030,2,2771,'App\\Models\\Receipt',2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',24435.95,NULL,NULL,1,'2023-04-25 15:44:05','2023-04-25 15:44:05',NULL),(4446,7561,40725,3029,2,2769,'App\\Models\\Receipt',2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',38833.52,NULL,NULL,1,'2023-04-25 15:44:51','2023-04-25 15:44:51',NULL),(4447,7561,40725,3029,2,2770,'App\\Models\\Receipt',2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',27470.87,NULL,NULL,1,'2023-04-25 15:49:58','2023-04-25 15:52:05','2023-04-25 15:52:05'),(4448,7561,40725,3029,2,2767,'App\\Models\\Receipt',2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',24435.95,NULL,NULL,1,'2023-04-25 15:50:36','2023-04-25 15:50:36',NULL),(4449,7561,40725,3029,2,2770,'App\\Models\\Receipt',2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',27470.87,NULL,NULL,1,'2023-04-25 15:52:05','2023-04-25 15:52:05',NULL),(4450,7561,40725,3029,2,2765,'App\\Models\\Receipt',2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',102880.25,NULL,NULL,1,'2023-04-25 15:52:45','2023-04-25 15:52:45',NULL),(4451,7561,40725,3029,2,2762,'App\\Models\\Receipt',2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',21961.50,NULL,NULL,1,'2023-04-25 15:53:18','2023-04-25 15:53:18',NULL);
INSERT INTO `balance_libro` VALUES (4452,7561,40725,3029,2,2761,'App\\Models\\Receipt',2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',21961.50,NULL,NULL,1,'2023-04-25 15:53:48','2023-04-25 15:53:48',NULL),(4453,7561,40725,3029,2,2760,'App\\Models\\Receipt',2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',41817.60,NULL,NULL,1,'2023-04-25 15:54:16','2023-04-25 15:54:16',NULL),(4454,7561,40725,3029,2,2759,'App\\Models\\Receipt',2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',27264.93,NULL,NULL,1,'2023-04-25 15:54:52','2023-04-25 15:55:15','2023-04-25 15:55:15'),(4455,7561,40725,3029,2,2759,'App\\Models\\Receipt',2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',27264.93,NULL,NULL,1,'2023-04-25 15:55:15','2023-04-25 15:55:15',NULL),(4456,7561,40725,3029,2,2758,'App\\Models\\Receipt',2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',4560.01,NULL,NULL,1,'2023-04-25 15:55:57','2023-04-25 15:55:57',NULL),(4457,7561,40725,3029,2,2757,'App\\Models\\Receipt',2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',22152.68,NULL,NULL,1,'2023-04-25 15:56:50','2023-04-25 15:56:50',NULL),(4458,7561,40725,3029,2,2756,'App\\Models\\Receipt',2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',73052.54,NULL,NULL,1,'2023-04-25 15:57:44','2023-04-25 15:57:44',NULL),(4459,7561,40725,3029,2,2754,'App\\Models\\Receipt',2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',36364.13,NULL,NULL,1,'2023-04-25 16:01:06','2023-04-25 16:01:06',NULL),(4460,7561,40725,3029,2,2753,'App\\Models\\Receipt',2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',97792.20,NULL,NULL,1,'2023-04-25 16:01:34','2023-04-25 16:01:34',NULL),(4461,7561,40725,3029,2,2751,'App\\Models\\Receipt',2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',40601.55,NULL,NULL,1,'2023-04-25 16:05:08','2023-04-25 16:05:08',NULL),(4462,7561,40725,3029,2,2750,'App\\Models\\Receipt',2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',45040.60,NULL,NULL,1,'2023-04-25 16:05:53','2023-04-25 16:05:53',NULL),(4463,7561,40725,3029,2,2749,'App\\Models\\Receipt',2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',25855.28,NULL,NULL,1,'2023-04-25 16:06:26','2023-04-25 16:06:26',NULL),(4464,7561,40725,3029,2,2748,'App\\Models\\Receipt',2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',20234.83,NULL,NULL,1,'2023-04-25 16:07:30','2023-04-25 16:07:30',NULL),(4465,7561,40725,3029,2,2746,'App\\Models\\Receipt',2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',28182.11,NULL,NULL,1,'2023-04-25 16:08:27','2023-04-25 16:08:27',NULL),(4466,7561,40725,3028,2,2742,'App\\Models\\Receipt',2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',67260.56,NULL,NULL,1,'2023-04-25 16:10:10','2023-04-25 16:10:10',NULL),(4467,7561,40725,3028,2,2740,'App\\Models\\Receipt',2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',18471.86,NULL,NULL,1,'2023-04-25 16:10:56','2023-04-25 16:10:56',NULL),(4468,7561,40725,3028,2,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',149961.35,NULL,NULL,1,'2023-04-25 16:14:30','2023-04-25 16:14:30',NULL),(4469,7561,40725,3028,2,2728,'App\\Models\\Receipt',2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',4864.20,NULL,NULL,1,'2023-04-25 16:14:58','2023-04-25 16:14:58',NULL),(4470,7561,40725,3028,2,2727,'App\\Models\\Receipt',2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',26899.51,NULL,NULL,1,'2023-04-25 16:15:21','2023-04-25 16:15:21',NULL),(4471,7561,40725,3027,2,2725,'App\\Models\\Receipt',2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',64461.66,NULL,NULL,1,'2023-04-25 16:16:31','2023-04-25 16:16:31',NULL),(4472,7561,40725,3027,2,2719,'App\\Models\\Receipt',2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',165859.54,NULL,NULL,1,'2023-04-25 16:17:42','2023-04-25 16:17:42',NULL);
INSERT INTO `balance_libro` VALUES (4473,7561,40725,3027,2,2715,'App\\Models\\Receipt',2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',119644.80,NULL,NULL,1,'2023-04-25 16:47:59','2023-04-25 16:47:59',NULL),(4474,7561,40725,3027,2,2712,'App\\Models\\Receipt',2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',37510.00,NULL,NULL,1,'2023-04-25 16:49:05','2023-04-25 16:49:05',NULL),(4475,7561,40725,3027,2,2710,'App\\Models\\Receipt',2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',20146.50,NULL,NULL,1,'2023-04-25 16:52:30','2023-04-25 16:52:30',NULL),(4476,7561,40725,3037,2,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',112079.28,NULL,NULL,1,'2023-04-26 11:51:18','2023-04-26 11:51:18',NULL),(4477,7561,40725,3027,3,2938,'App\\Models\\Receipt',2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',20450.54,NULL,NULL,1,'2023-04-26 12:16:23','2023-04-26 12:16:23',NULL),(4478,7561,40725,3027,3,2939,'App\\Models\\Receipt',2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',69176.18,NULL,NULL,1,'2023-04-26 12:19:00','2023-04-26 12:19:00',NULL),(4479,7561,40725,3035,3,3129,'App\\Models\\Receipt',3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',3150.00,NULL,NULL,1,'2023-04-26 12:19:51','2023-04-26 12:19:51',NULL),(4480,7561,40725,3027,3,2949,'App\\Models\\Receipt',2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',511.77,NULL,NULL,1,'2023-04-26 12:23:57','2023-04-26 12:23:57',NULL),(4481,7561,40725,3035,3,3132,'App\\Models\\Receipt',3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',7400.00,NULL,NULL,1,'2023-04-26 12:24:44','2023-04-26 12:24:44',NULL),(4482,7561,40725,3027,3,2940,'App\\Models\\Receipt',2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',4050.48,NULL,NULL,1,'2023-04-26 12:25:51','2023-04-26 12:25:51',NULL),(4483,7561,40727,1520,2,3497,'App\\Models\\Receipt',3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',48999.99,NULL,NULL,1,'2023-05-03 14:45:09','2023-05-03 14:45:09',NULL),(4484,7561,40727,1519,2,3744,'App\\Models\\Receipt',3744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',136125.00,NULL,NULL,1,'2023-05-03 15:10:49','2023-05-03 15:10:49',NULL),(4485,7561,40727,1519,2,3745,'App\\Models\\Receipt',3745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',75020.00,NULL,NULL,1,'2023-05-03 15:10:49','2023-05-03 15:10:49',NULL),(4486,7561,40727,1519,2,3746,'App\\Models\\Receipt',3746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',8000.00,NULL,NULL,1,'2023-05-03 15:10:49','2023-05-03 15:10:49',NULL),(4487,7561,40727,1519,2,3747,'App\\Models\\Receipt',3747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',50000.00,NULL,NULL,1,'2023-05-03 15:10:49','2023-05-03 15:10:49',NULL),(4488,7561,40727,1519,2,3748,'App\\Models\\Receipt',3748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',44899.47,NULL,NULL,1,'2023-05-03 15:10:49','2023-05-03 15:12:15','2023-05-03 15:12:15'),(4489,7561,40727,1519,2,3749,'App\\Models\\Receipt',3749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',82000.00,NULL,NULL,1,'2023-05-03 15:10:49','2023-05-03 15:10:49',NULL),(4490,7561,40727,1519,2,3750,'App\\Models\\Receipt',3750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',54000.00,NULL,NULL,1,'2023-05-03 15:10:49','2023-05-03 15:12:36','2023-05-03 15:12:36'),(4491,7561,40727,1519,2,3751,'App\\Models\\Receipt',3751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',49005.00,NULL,NULL,1,'2023-05-03 15:10:49','2023-05-03 15:10:49',NULL),(4492,7561,40727,1519,2,3752,'App\\Models\\Receipt',3752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',71000.38,NULL,NULL,1,'2023-05-03 15:10:49','2023-05-03 15:10:49',NULL);
INSERT INTO `balance_libro` VALUES (4493,7561,40727,1519,2,3753,'App\\Models\\Receipt',3753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',44899.47,NULL,NULL,1,'2023-05-03 15:10:49','2023-05-03 15:12:00','2023-05-03 15:12:00'),(4494,7561,40727,1519,2,3754,'App\\Models\\Receipt',3754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',39930.00,NULL,NULL,1,'2023-05-03 15:10:50','2023-05-03 15:10:50',NULL),(4495,7561,40727,1519,2,3755,'App\\Models\\Receipt',3755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',55660.00,NULL,NULL,1,'2023-05-03 15:10:50','2023-05-03 15:10:50',NULL),(4496,7561,40727,1519,2,3756,'App\\Models\\Receipt',3756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',14400.00,NULL,NULL,1,'2023-05-03 15:10:50','2023-05-03 15:11:48','2023-05-03 15:11:48'),(4497,7561,40727,1519,2,3757,'App\\Models\\Receipt',3757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',42750.00,NULL,NULL,1,'2023-05-03 15:10:50','2023-05-03 15:11:30','2023-05-03 15:11:30'),(4498,7561,40727,1519,2,3757,'App\\Models\\Receipt',3757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',42750.00,NULL,NULL,1,'2023-05-03 15:11:30','2023-05-03 15:11:30',NULL),(4499,7561,40727,1519,2,3756,'App\\Models\\Receipt',3756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',14400.00,NULL,NULL,1,'2023-05-03 15:11:48','2023-05-03 15:11:48',NULL),(4500,7561,40727,1519,2,3753,'App\\Models\\Receipt',3753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',44899.47,NULL,NULL,1,'2023-05-03 15:12:00','2023-05-03 15:12:00',NULL),(4501,7561,40727,1519,2,3748,'App\\Models\\Receipt',3748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',44899.47,NULL,NULL,1,'2023-05-03 15:12:15','2023-05-03 15:12:15',NULL),(4502,7561,40727,1519,2,3750,'App\\Models\\Receipt',3750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',54000.00,NULL,NULL,1,'2023-05-03 15:12:36','2023-05-03 15:12:36',NULL),(4503,7561,40727,1515,2,3366,'App\\Models\\Receipt',3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',20000.04,NULL,NULL,1,'2023-05-03 15:20:50','2023-05-03 15:22:17','2023-05-03 15:22:17'),(4504,7561,40727,1515,2,3366,'App\\Models\\Receipt',3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',20000.04,NULL,NULL,1,'2023-05-03 15:22:17','2023-05-03 15:22:17',NULL),(4505,7561,40727,1533,2,3758,'App\\Models\\Receipt',3758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',72600.00,NULL,NULL,1,'2023-05-06 13:57:44','2023-05-06 13:57:44',NULL),(4506,7561,40727,1533,2,3759,'App\\Models\\Receipt',3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',215000.00,NULL,NULL,1,'2023-05-06 13:57:44','2023-05-10 15:17:16','2023-05-10 15:17:16'),(4507,7561,40727,1533,2,3760,'App\\Models\\Receipt',3760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',50000.10,NULL,NULL,1,'2023-05-06 13:57:44','2023-05-10 15:18:58','2023-05-10 15:18:58'),(4508,7561,40727,1533,2,3761,'App\\Models\\Receipt',3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',192148.00,NULL,NULL,1,'2023-05-06 13:57:44','2023-05-10 15:17:55','2023-05-10 15:17:55'),(4509,7561,40727,1533,2,3762,'App\\Models\\Receipt',3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',15000.00,NULL,NULL,1,'2023-05-06 13:57:44','2023-05-10 15:19:52','2023-05-10 15:19:52'),(4510,7561,40727,1533,2,3763,'App\\Models\\Receipt',3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',24500.00,NULL,NULL,1,'2023-05-06 13:57:44','2023-05-10 15:23:05','2023-05-10 15:23:05'),(4511,7561,40727,1533,2,3764,'App\\Models\\Receipt',3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',47000.00,NULL,NULL,1,'2023-05-06 13:57:44','2023-05-10 15:24:31','2023-05-10 15:24:31'),(4512,7561,40727,1533,2,3765,'App\\Models\\Receipt',3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',84000.00,NULL,NULL,1,'2023-05-06 13:57:44','2023-05-10 15:25:15','2023-05-10 15:25:15');
INSERT INTO `balance_libro` VALUES (4513,7561,40727,1533,2,3766,'App\\Models\\Receipt',3766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',38000.00,NULL,NULL,1,'2023-05-06 13:57:44','2023-05-10 15:25:35','2023-05-10 15:25:35'),(4514,7561,40727,1533,2,3767,'App\\Models\\Receipt',3767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',121000.00,NULL,NULL,1,'2023-05-06 13:57:44','2023-05-10 15:26:04','2023-05-10 15:26:04'),(4515,7561,40727,1533,2,3768,'App\\Models\\Receipt',3768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',165165.00,NULL,NULL,1,'2023-05-06 13:57:44','2023-05-10 15:26:32','2023-05-10 15:26:32'),(4516,7561,40727,1533,2,3769,'App\\Models\\Receipt',3769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',70180.00,NULL,NULL,1,'2023-05-06 13:57:44','2023-05-06 13:57:44',NULL),(4517,7561,40727,1533,2,3770,'App\\Models\\Receipt',3770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',44000.44,NULL,NULL,1,'2023-05-06 13:57:44','2023-05-06 13:57:44',NULL),(4518,7561,40727,1533,2,3771,'App\\Models\\Receipt',3771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',90750.00,NULL,NULL,1,'2023-05-06 13:57:44','2023-05-10 15:28:35','2023-05-10 15:28:35'),(4519,7561,40727,1533,2,3772,'App\\Models\\Receipt',3772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',112980.12,NULL,NULL,1,'2023-05-06 13:57:44','2023-05-10 15:29:02','2023-05-10 15:29:02'),(4520,7561,40727,1533,2,3773,'App\\Models\\Receipt',3773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',65500.00,NULL,NULL,1,'2023-05-06 13:57:45','2023-05-10 15:29:30','2023-05-10 15:29:30'),(4521,7561,40727,1533,2,3774,'App\\Models\\Receipt',3774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',120000.00,NULL,NULL,1,'2023-05-06 13:57:45','2023-05-10 15:30:04','2023-05-10 15:30:04'),(4522,7561,40727,1533,3,3775,'App\\Models\\Receipt',3775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',6000.00,NULL,NULL,1,'2023-05-06 13:58:15','2023-05-10 17:50:28','2023-05-10 17:50:28'),(4523,7561,40727,1533,3,3776,'App\\Models\\Receipt',3776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',25560.03,NULL,NULL,1,'2023-05-06 13:58:15','2023-05-10 17:57:18','2023-05-10 17:57:18'),(4524,7561,40727,1533,3,3777,'App\\Models\\Receipt',3777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',84655.23,NULL,NULL,1,'2023-05-06 13:58:15','2023-05-10 17:56:28','2023-05-10 17:56:28'),(4525,7561,40727,1533,3,3778,'App\\Models\\Receipt',3778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',27550.61,NULL,NULL,1,'2023-05-06 13:58:15','2023-05-10 17:55:35','2023-05-10 17:55:35'),(4526,7561,40727,1533,3,3779,'App\\Models\\Receipt',3779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',26140.52,NULL,NULL,1,'2023-05-06 13:58:15','2023-05-10 17:51:42','2023-05-10 17:51:42'),(4527,7561,40727,1533,3,3780,'App\\Models\\Receipt',3780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',82583.71,NULL,NULL,1,'2023-05-06 13:58:15','2023-05-10 17:45:38','2023-05-10 17:45:38'),(4528,7561,40727,1533,3,3781,'App\\Models\\Receipt',3781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',66783.92,NULL,NULL,1,'2023-05-06 13:58:15','2023-05-10 17:44:13','2023-05-10 17:44:13'),(4529,7561,40727,1533,3,3782,'App\\Models\\Receipt',3782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',4201.50,NULL,NULL,1,'2023-05-06 13:58:15','2023-05-06 13:58:15',NULL),(4530,7561,40727,1533,3,3783,'App\\Models\\Receipt',3783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',67308.08,NULL,NULL,1,'2023-05-06 13:58:15','2023-05-10 17:42:45','2023-05-10 17:42:45'),(4531,7561,40727,1533,3,3784,'App\\Models\\Receipt',3784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',55923.35,NULL,NULL,1,'2023-05-06 13:58:15','2023-05-10 17:38:53','2023-05-10 17:38:53');
INSERT INTO `balance_libro` VALUES (4532,7561,40727,1533,3,3785,'App\\Models\\Receipt',3785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',5514.28,NULL,NULL,1,'2023-05-06 13:58:15','2023-05-10 17:44:50','2023-05-10 17:44:50'),(4533,7561,40727,1533,3,3786,'App\\Models\\Receipt',3786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',22520.04,NULL,NULL,1,'2023-05-06 13:58:16','2023-05-10 17:38:09','2023-05-10 17:38:09'),(4534,7561,40727,1533,3,3787,'App\\Models\\Receipt',3787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',57777.51,NULL,NULL,1,'2023-05-06 13:58:16','2023-05-10 15:56:40','2023-05-10 15:56:40'),(4535,7561,40727,1533,3,3788,'App\\Models\\Receipt',3788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',121000.00,NULL,NULL,1,'2023-05-06 13:58:16','2023-05-10 15:55:29','2023-05-10 15:55:29'),(4536,7561,40727,1533,3,3789,'App\\Models\\Receipt',3789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',21098.78,NULL,NULL,1,'2023-05-06 13:58:16','2023-05-10 15:42:36','2023-05-10 15:42:36'),(4537,7561,40727,1533,3,3790,'App\\Models\\Receipt',3790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',42337.95,NULL,NULL,1,'2023-05-06 13:58:16','2023-05-10 15:41:39','2023-05-10 15:41:39'),(4538,7561,40727,1533,3,3791,'App\\Models\\Receipt',3791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',75092.60,NULL,NULL,1,'2023-05-06 13:58:16','2023-05-10 15:39:29','2023-05-10 15:39:29'),(4539,7561,40727,1533,3,3792,'App\\Models\\Receipt',3792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',109835.33,NULL,NULL,1,'2023-05-06 13:58:16','2023-05-10 15:38:00','2023-05-10 15:38:00'),(4540,7561,40727,1533,3,3793,'App\\Models\\Receipt',3793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',8779.45,NULL,NULL,1,'2023-05-06 13:58:16','2023-05-10 15:36:56','2023-05-10 15:36:56'),(4541,7561,40725,3045,2,3794,'App\\Models\\Receipt',3794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',143302.72,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-06 13:59:39',NULL),(4542,7561,40725,3045,2,3795,'App\\Models\\Receipt',3795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',115279.12,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-06 13:59:39',NULL),(4543,7561,40725,3045,2,3796,'App\\Models\\Receipt',3796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',83006.00,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-06 13:59:39',NULL),(4544,7561,40725,3045,2,3797,'App\\Models\\Receipt',3797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',132488.56,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-06 13:59:39',NULL),(4545,7561,40725,3045,2,3798,'App\\Models\\Receipt',3798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',178257.20,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-11 14:53:25','2023-05-11 14:53:25'),(4546,7561,40725,3045,2,3799,'App\\Models\\Receipt',3799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',53391.25,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-11 14:53:09','2023-05-11 14:53:09'),(4547,7561,40725,3045,2,3800,'App\\Models\\Receipt',3800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',53651.40,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-06 13:59:39',NULL),(4548,7561,40725,3045,2,3801,'App\\Models\\Receipt',3801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',48406.05,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-11 15:24:03','2023-05-11 15:24:03'),(4549,7561,40725,3045,2,3802,'App\\Models\\Receipt',3802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',48400.60,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-11 15:22:53','2023-05-11 15:22:53'),(4550,7561,40725,3045,2,3803,'App\\Models\\Receipt',3803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',38901.50,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-11 15:22:19','2023-05-11 15:22:19');
INSERT INTO `balance_libro` VALUES (4551,7561,40725,3045,2,3804,'App\\Models\\Receipt',3804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',71898.20,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-11 14:52:27','2023-05-11 14:52:27'),(4552,7561,40725,3045,2,3805,'App\\Models\\Receipt',3805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',140149.27,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-06 13:59:39',NULL),(4553,7561,40725,3045,2,3806,'App\\Models\\Receipt',3806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',72043.40,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-11 14:52:47','2023-05-11 14:52:47'),(4554,7561,40725,3045,2,3807,'App\\Models\\Receipt',3807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',63041.00,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-06 13:59:39',NULL),(4555,7561,40725,3045,2,3808,'App\\Models\\Receipt',3808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',41382.00,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-06 13:59:39',NULL),(4556,7561,40725,3045,2,3809,'App\\Models\\Receipt',3809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',142238.30,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-06 13:59:39',NULL),(4557,7561,40725,3045,2,3810,'App\\Models\\Receipt',3810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',199204.13,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-11 15:21:42','2023-05-11 15:21:42'),(4558,7561,40725,3045,2,3811,'App\\Models\\Receipt',3811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',87201.80,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-11 15:21:32','2023-05-11 15:21:32'),(4559,7561,40725,3045,2,3812,'App\\Models\\Receipt',3812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',201226.02,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-11 15:21:18','2023-05-11 15:21:18'),(4560,7561,40725,3045,2,3813,'App\\Models\\Receipt',3813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',100877.70,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-11 14:51:48','2023-05-11 14:51:48'),(4561,7561,40725,3045,2,3814,'App\\Models\\Receipt',3814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',29487.70,NULL,NULL,1,'2023-05-06 13:59:39','2023-05-11 14:51:36','2023-05-11 14:51:36'),(4562,7561,40725,3045,2,3815,'App\\Models\\Receipt',3815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',127364.60,NULL,NULL,1,'2023-05-06 13:59:40','2023-05-11 14:51:25','2023-05-11 14:51:25'),(4563,7561,40725,3045,2,3816,'App\\Models\\Receipt',3816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',221067.00,NULL,NULL,1,'2023-05-06 13:59:40','2023-05-11 14:51:16','2023-05-11 14:51:16'),(4564,7561,40725,3045,3,3817,'App\\Models\\Receipt',3817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',113548.85,NULL,NULL,1,'2023-05-06 14:00:04','2023-05-06 14:03:05','2023-05-06 14:03:05'),(4565,7561,40725,3045,3,3818,'App\\Models\\Receipt',3818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',6024.47,NULL,NULL,1,'2023-05-06 14:00:04','2023-05-11 14:34:12','2023-05-11 14:34:12'),(4566,7561,40725,3045,3,3819,'App\\Models\\Receipt',3819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1490.00,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-10 19:46:40','2023-05-10 19:46:40'),(4567,7561,40725,3045,3,3820,'App\\Models\\Receipt',3820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',2579.78,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-11 14:32:05','2023-05-11 14:32:05'),(4568,7561,40725,3045,3,3821,'App\\Models\\Receipt',3821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',95.00,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-06 14:00:05',NULL),(4569,7561,40725,3045,3,3822,'App\\Models\\Receipt',3822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',21600.00,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-11 14:31:20','2023-05-11 14:31:20');
INSERT INTO `balance_libro` VALUES (4570,7561,40725,3045,3,3823,'App\\Models\\Receipt',3823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',7530.50,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-06 14:00:05',NULL),(4571,7561,40725,3045,3,3824,'App\\Models\\Receipt',3824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',1016400.00,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-11 14:35:11','2023-05-11 14:35:11'),(4572,7561,40725,3045,3,3825,'App\\Models\\Receipt',3825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',19069.60,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-11 14:23:20','2023-05-11 14:23:20'),(4573,7561,40725,3045,3,3826,'App\\Models\\Receipt',3826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',304102.04,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-11 14:22:41','2023-05-11 14:22:41'),(4574,7561,40725,3045,3,3827,'App\\Models\\Receipt',3827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',190.00,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-06 14:02:43','2023-05-06 14:02:43'),(4575,7561,40725,3045,3,3828,'App\\Models\\Receipt',3828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',90.00,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-11 13:38:15','2023-05-11 13:38:15'),(4576,7561,40725,3045,3,3829,'App\\Models\\Receipt',3829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',9931.39,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-11 13:38:02','2023-05-11 13:38:02'),(4577,7561,40725,3045,3,3830,'App\\Models\\Receipt',3830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',549.70,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-11 14:24:56','2023-05-11 14:24:56'),(4578,7561,40725,3045,3,3831,'App\\Models\\Receipt',3831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',95193.12,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-11 14:24:06','2023-05-11 14:24:06'),(4579,7561,40725,3045,3,3832,'App\\Models\\Receipt',3832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',177003.88,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-11 14:36:03','2023-05-11 14:36:03'),(4580,7561,40725,3045,3,3833,'App\\Models\\Receipt',3833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',120699.32,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-11 14:36:26','2023-05-11 14:36:26'),(4581,7561,40725,3045,3,3834,'App\\Models\\Receipt',3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',6441.04,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-11 14:05:24','2023-05-11 14:05:24'),(4582,7561,40725,3045,3,3835,'App\\Models\\Receipt',3835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',800.96,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-11 14:04:35','2023-05-11 14:04:35'),(4583,7561,40725,3045,3,3836,'App\\Models\\Receipt',3836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',270259.31,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-11 14:25:20','2023-05-11 14:25:20'),(4584,7561,40725,3045,3,3837,'App\\Models\\Receipt',3837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',7500.00,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-10 19:43:34','2023-05-10 19:43:34'),(4585,7561,40725,3045,3,3838,'App\\Models\\Receipt',3838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',2500.01,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-11 14:26:43','2023-05-11 14:26:43'),(4586,7561,40725,3045,3,3839,'App\\Models\\Receipt',3839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',41000.00,NULL,NULL,1,'2023-05-06 14:00:05','2023-05-10 19:42:50','2023-05-10 19:42:50'),(4587,7561,40725,3045,3,3827,'App\\Models\\Receipt',3827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',189.99,NULL,NULL,1,'2023-05-06 14:02:43','2023-05-06 14:02:43',NULL),(4588,7561,40727,1533,2,3759,'App\\Models\\Receipt',3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',215000.00,NULL,NULL,1,'2023-05-10 15:17:16','2023-05-10 15:23:24','2023-05-10 15:23:24');
INSERT INTO `balance_libro` VALUES (4589,7561,40727,1533,2,3761,'App\\Models\\Receipt',3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',192148.00,NULL,NULL,1,'2023-05-10 15:17:55','2023-05-10 15:17:55',NULL),(4590,7561,40727,1533,2,3760,'App\\Models\\Receipt',3760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',50000.10,NULL,NULL,1,'2023-05-10 15:18:58','2023-05-10 15:18:58',NULL),(4591,7561,40727,1533,2,3762,'App\\Models\\Receipt',3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',14999.99,NULL,NULL,1,'2023-05-10 15:19:52','2023-05-10 15:22:33','2023-05-10 15:22:33'),(4592,7561,40727,1533,2,3762,'App\\Models\\Receipt',3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',15000.01,NULL,NULL,1,'2023-05-10 15:22:33','2023-05-10 15:23:39','2023-05-10 15:23:39'),(4593,7561,40727,1533,2,3763,'App\\Models\\Receipt',3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',24500.00,NULL,NULL,1,'2023-05-10 15:23:05','2023-05-10 15:23:05',NULL),(4594,7561,40727,1533,2,3759,'App\\Models\\Receipt',3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',215000.00,NULL,NULL,1,'2023-05-10 15:23:24','2023-05-10 15:23:24',NULL),(4595,7561,40727,1533,2,3762,'App\\Models\\Receipt',3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',15000.01,NULL,NULL,1,'2023-05-10 15:23:39','2023-05-10 15:23:39',NULL),(4596,7561,40727,1533,2,3764,'App\\Models\\Receipt',3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',47000.01,NULL,NULL,1,'2023-05-10 15:24:31','2023-05-10 15:24:31',NULL),(4597,7561,40727,1533,2,3765,'App\\Models\\Receipt',3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',84000.00,NULL,NULL,1,'2023-05-10 15:25:15','2023-05-10 15:25:15',NULL),(4598,7561,40727,1533,2,3766,'App\\Models\\Receipt',3766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',38000.00,NULL,NULL,1,'2023-05-10 15:25:35','2023-05-10 15:25:35',NULL),(4599,7561,40727,1533,2,3767,'App\\Models\\Receipt',3767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',121000.00,NULL,NULL,1,'2023-05-10 15:26:04','2023-05-10 15:26:04',NULL),(4600,7561,40727,1533,2,3768,'App\\Models\\Receipt',3768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',165165.00,NULL,NULL,1,'2023-05-10 15:26:32','2023-05-10 15:26:32',NULL),(4601,7561,40727,1533,2,3771,'App\\Models\\Receipt',3771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',90750.00,NULL,NULL,1,'2023-05-10 15:28:35','2023-05-10 15:28:35',NULL),(4602,7561,40727,1533,2,3772,'App\\Models\\Receipt',3772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',112980.12,NULL,NULL,1,'2023-05-10 15:29:02','2023-05-10 15:29:02',NULL),(4603,7561,40727,1533,2,3773,'App\\Models\\Receipt',3773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',65500.00,NULL,NULL,1,'2023-05-10 15:29:30','2023-05-10 15:29:30',NULL),(4604,7561,40727,1533,2,3774,'App\\Models\\Receipt',3774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',120000.00,NULL,NULL,1,'2023-05-10 15:30:04','2023-05-10 15:30:04',NULL),(4605,7561,40727,1533,3,3840,'App\\Models\\Receipt',3840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',8026.90,NULL,NULL,1,'2023-05-10 15:35:02','2023-05-10 15:35:02',NULL),(4606,7561,40727,1533,3,3793,'App\\Models\\Receipt',3793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',8816.30,NULL,NULL,1,'2023-05-10 15:36:56','2023-05-10 15:37:15','2023-05-10 15:37:15'),(4607,7561,40727,1533,3,3793,'App\\Models\\Receipt',3793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',8779.45,NULL,NULL,1,'2023-05-10 15:37:15','2023-05-10 15:40:21','2023-05-10 15:40:21'),(4608,7561,40727,1533,3,3792,'App\\Models\\Receipt',3792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',109835.33,NULL,NULL,1,'2023-05-10 15:38:00','2023-05-10 15:38:00',NULL);
INSERT INTO `balance_libro` VALUES (4609,7561,40727,1533,3,3791,'App\\Models\\Receipt',3791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',75092.60,NULL,NULL,1,'2023-05-10 15:39:29','2023-05-10 15:39:29',NULL),(4610,7561,40727,1533,3,3793,'App\\Models\\Receipt',3793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',8779.45,NULL,NULL,1,'2023-05-10 15:40:21','2023-05-10 15:40:21',NULL),(4611,7561,40727,1533,3,3790,'App\\Models\\Receipt',3790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',42337.95,NULL,NULL,1,'2023-05-10 15:41:39','2023-05-10 15:41:39',NULL),(4612,7561,40727,1533,3,3789,'App\\Models\\Receipt',3789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',21098.78,NULL,NULL,1,'2023-05-10 15:42:36','2023-05-10 15:42:36',NULL),(4613,7561,40727,1533,3,3841,'App\\Models\\Receipt',3841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',2000.30,NULL,NULL,1,'2023-05-10 15:47:01','2023-05-10 15:47:01',NULL),(4614,7561,40727,1533,3,3788,'App\\Models\\Receipt',3788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',121000.00,NULL,NULL,1,'2023-05-10 15:55:29','2023-05-10 15:55:29',NULL),(4615,7561,40727,1533,3,3787,'App\\Models\\Receipt',3787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',57777.51,NULL,NULL,1,'2023-05-10 15:56:40','2023-05-10 15:56:40',NULL),(4616,7561,40727,1533,3,3786,'App\\Models\\Receipt',3786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',22520.04,NULL,NULL,1,'2023-05-10 17:38:09','2023-05-10 17:38:09',NULL),(4617,7561,40727,1533,3,3784,'App\\Models\\Receipt',3784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',55923.34,NULL,NULL,1,'2023-05-10 17:38:53','2023-05-10 17:38:53',NULL),(4618,7561,40727,1533,3,3783,'App\\Models\\Receipt',3783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',67308.08,NULL,NULL,1,'2023-05-10 17:42:45','2023-05-10 17:42:45',NULL),(4619,7561,40727,1533,3,3781,'App\\Models\\Receipt',3781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',66783.92,NULL,NULL,1,'2023-05-10 17:44:13','2023-05-10 17:44:13',NULL),(4620,7561,40727,1533,3,3785,'App\\Models\\Receipt',3785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',5514.28,NULL,NULL,1,'2023-05-10 17:44:50','2023-05-10 17:44:50',NULL),(4621,7561,40727,1533,3,3780,'App\\Models\\Receipt',3780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',82583.71,NULL,NULL,1,'2023-05-10 17:45:38','2023-05-10 17:45:38',NULL),(4622,7561,40727,1533,3,3842,'App\\Models\\Receipt',3842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2544.95,NULL,NULL,1,'2023-05-10 17:49:07','2023-05-10 17:49:07',NULL),(4623,7561,40727,1533,3,3775,'App\\Models\\Receipt',3775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',6000.00,NULL,NULL,1,'2023-05-10 17:50:28','2023-05-10 17:50:28',NULL),(4624,7561,40727,1533,3,3779,'App\\Models\\Receipt',3779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',26140.52,NULL,NULL,1,'2023-05-10 17:51:42','2023-05-10 17:51:42',NULL),(4625,7561,40727,1533,3,3843,'App\\Models\\Receipt',3843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',4434.86,NULL,NULL,1,'2023-05-10 17:54:46','2023-05-10 17:54:46',NULL),(4626,7561,40727,1533,3,3778,'App\\Models\\Receipt',3778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',27550.61,NULL,NULL,1,'2023-05-10 17:55:35','2023-05-10 17:55:35',NULL),(4627,7561,40727,1533,3,3777,'App\\Models\\Receipt',3777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',84655.23,NULL,NULL,1,'2023-05-10 17:56:28','2023-05-10 17:56:28',NULL),(4628,7561,40727,1533,3,3776,'App\\Models\\Receipt',3776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',25560.03,NULL,NULL,1,'2023-05-10 17:57:18','2023-05-10 17:57:18',NULL),(4629,7561,40727,1533,3,3844,'App\\Models\\Receipt',3844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',1200.00,NULL,NULL,1,'2023-05-10 18:02:37','2023-05-10 18:02:37',NULL);
INSERT INTO `balance_libro` VALUES (4630,7561,40727,1533,3,3845,'App\\Models\\Receipt',3845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',83256.00,NULL,NULL,1,'2023-05-10 18:04:09','2023-05-10 18:04:09',NULL),(4631,7561,40727,1530,16,1146,'App\\Models\\PeriodLiquidation',NULL,1146,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',26518.79,NULL,NULL,1,'2023-05-10 19:13:07','2023-05-10 19:13:07',NULL),(4632,7561,40727,1532,16,1352,'App\\Models\\PeriodLiquidation',NULL,1352,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',10455.49,NULL,NULL,1,'2023-05-10 19:13:16','2023-05-10 19:13:16',NULL),(4633,7561,40727,1533,16,1943,'App\\Models\\PeriodLiquidation',NULL,1943,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',19178.05,NULL,NULL,1,'2023-05-10 19:17:04','2023-05-10 19:17:04',NULL),(4634,7561,40725,3045,3,3839,'App\\Models\\Receipt',3839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',41000.00,NULL,NULL,1,'2023-05-10 19:42:50','2023-05-10 19:42:50',NULL),(4635,7561,40725,3045,3,3837,'App\\Models\\Receipt',3837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',7500.00,NULL,NULL,1,'2023-05-10 19:43:34','2023-05-10 19:43:34',NULL),(4636,7561,40725,3045,3,3846,'App\\Models\\Receipt',3846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',2070.31,NULL,NULL,1,'2023-05-10 19:53:06','2023-05-10 19:53:06',NULL),(4637,7561,40725,3045,3,3847,'App\\Models\\Receipt',3847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',4000.12,NULL,NULL,1,'2023-05-10 19:56:01','2023-05-10 19:56:01',NULL),(4638,7561,40719,21,2,3848,'App\\Models\\Receipt',3848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',12000.00,NULL,NULL,1,'2023-05-11 12:38:33','2023-05-11 12:38:33',NULL),(4639,7561,40719,21,2,3849,'App\\Models\\Receipt',3849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',8000.00,NULL,NULL,1,'2023-05-11 12:38:33','2023-05-11 12:38:33',NULL),(4640,7561,40719,21,2,3850,'App\\Models\\Receipt',3850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',6000.00,NULL,NULL,1,'2023-05-11 12:38:33','2023-05-11 12:38:33',NULL),(4641,7561,40719,21,2,3851,'App\\Models\\Receipt',3851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',17500.00,NULL,NULL,1,'2023-05-11 12:38:33','2023-05-11 12:38:33',NULL),(4642,7561,40719,21,2,3852,'App\\Models\\Receipt',3852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',17500.00,NULL,NULL,1,'2023-05-11 12:38:33','2023-05-11 12:38:33',NULL),(4643,7561,40719,21,2,3853,'App\\Models\\Receipt',3853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',41000.00,NULL,NULL,1,'2023-05-11 12:38:33','2023-05-11 12:38:33',NULL),(4644,7561,40719,21,2,3854,'App\\Models\\Receipt',3854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',12000.00,NULL,NULL,1,'2023-05-11 12:38:33','2023-05-11 12:38:33',NULL),(4645,7561,40719,21,2,3855,'App\\Models\\Receipt',3855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',8000.00,NULL,NULL,1,'2023-05-11 12:38:33','2023-05-11 12:38:33',NULL),(4646,7561,40719,21,2,3856,'App\\Models\\Receipt',3856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',295000.00,NULL,NULL,1,'2023-05-11 12:38:33','2023-05-11 12:38:33',NULL),(4647,7561,40725,3045,3,3857,'App\\Models\\Receipt',3857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',2901.20,NULL,NULL,1,'2023-05-11 13:33:48','2023-05-11 13:33:48',NULL),(4648,7561,40725,3045,3,3858,'App\\Models\\Receipt',3858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',4000.05,NULL,NULL,1,'2023-05-11 13:34:57','2023-05-11 13:34:57',NULL),(4649,7561,40725,3045,3,3859,'App\\Models\\Receipt',3859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',4740.16,NULL,NULL,1,'2023-05-11 13:36:45','2023-05-11 13:36:45',NULL),(4650,7561,40725,3045,3,3860,'App\\Models\\Receipt',3860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',2070.00,NULL,NULL,1,'2023-05-11 13:44:18','2023-05-11 13:44:18',NULL);
INSERT INTO `balance_libro` VALUES (4651,7561,40725,3045,3,3861,'App\\Models\\Receipt',3861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',6068.58,NULL,NULL,1,'2023-05-11 13:46:58','2023-05-11 13:47:51','2023-05-11 13:47:51'),(4652,7561,40725,3045,3,3861,'App\\Models\\Receipt',3861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',6068.58,NULL,NULL,1,'2023-05-11 13:47:51','2023-05-11 13:48:31','2023-05-11 13:48:31'),(4653,7561,40725,3045,3,3861,'App\\Models\\Receipt',3861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',6068.58,NULL,NULL,1,'2023-05-11 13:48:31','2023-05-11 13:48:31',NULL),(4654,7561,40725,3045,7,3862,'App\\Models\\Receipt',3862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',4412.33,NULL,NULL,1,'2023-05-11 14:00:46','2023-05-11 14:00:46',NULL),(4655,7561,40725,3045,3,3835,'App\\Models\\Receipt',3835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',800.96,NULL,NULL,1,'2023-05-11 14:04:35','2023-05-11 14:04:35',NULL),(4656,7561,40725,3045,3,3834,'App\\Models\\Receipt',3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',6441.04,NULL,NULL,1,'2023-05-11 14:05:24','2023-05-11 14:12:40','2023-05-11 14:12:40'),(4657,7561,40725,3045,3,3834,'App\\Models\\Receipt',3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',6441.04,NULL,NULL,1,'2023-05-11 14:12:40','2023-05-11 14:21:52','2023-05-11 14:21:52'),(4658,7561,40725,3045,3,3834,'App\\Models\\Receipt',3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',6441.04,NULL,NULL,1,'2023-05-11 14:21:52','2023-05-11 14:21:52',NULL),(4659,7561,40725,3045,3,3826,'App\\Models\\Receipt',3826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',304102.04,NULL,NULL,1,'2023-05-11 14:22:41','2023-05-11 14:24:40','2023-05-11 14:24:40'),(4660,7561,40725,3045,3,3825,'App\\Models\\Receipt',3825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',19069.60,NULL,NULL,1,'2023-05-11 14:23:20','2023-05-11 14:23:20',NULL),(4661,7561,40725,3045,3,3831,'App\\Models\\Receipt',3831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',95193.12,NULL,NULL,1,'2023-05-11 14:24:06','2023-05-11 14:24:06',NULL),(4662,7561,40725,3045,3,3826,'App\\Models\\Receipt',3826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',304102.04,NULL,NULL,1,'2023-05-11 14:24:40','2023-05-11 14:24:40',NULL),(4663,7561,40725,3045,3,3836,'App\\Models\\Receipt',3836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',270259.31,NULL,NULL,1,'2023-05-11 14:25:20','2023-05-11 14:25:20',NULL),(4664,7561,40725,3045,3,3838,'App\\Models\\Receipt',3838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',2500.01,NULL,NULL,1,'2023-05-11 14:26:43','2023-05-11 14:26:43',NULL),(4665,7561,40725,3045,3,3822,'App\\Models\\Receipt',3822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',21600.00,NULL,NULL,1,'2023-05-11 14:31:20','2023-05-11 14:31:20',NULL),(4666,7561,40725,3045,3,3820,'App\\Models\\Receipt',3820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',2579.78,NULL,NULL,1,'2023-05-11 14:32:05','2023-05-11 14:32:05',NULL),(4667,7561,40725,3045,3,3818,'App\\Models\\Receipt',3818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',6024.47,NULL,NULL,1,'2023-05-11 14:34:12','2023-05-11 14:34:12',NULL),(4668,7561,40725,3045,3,3824,'App\\Models\\Receipt',3824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',1016400.00,NULL,NULL,1,'2023-05-11 14:35:11','2023-05-11 14:35:11',NULL),(4669,7561,40725,3045,3,3832,'App\\Models\\Receipt',3832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',177003.88,NULL,NULL,1,'2023-05-11 14:36:03','2023-05-11 14:36:03',NULL),(4670,7561,40725,3045,3,3833,'App\\Models\\Receipt',3833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',120699.31,NULL,NULL,1,'2023-05-11 14:36:26','2023-05-11 14:36:26',NULL);
INSERT INTO `balance_libro` VALUES (4671,7561,40725,3045,3,3863,'App\\Models\\Receipt',3863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',4031.42,NULL,NULL,1,'2023-05-11 14:43:14','2023-05-11 15:34:26','2023-05-11 15:34:26'),(4672,7561,40725,3045,2,3816,'App\\Models\\Receipt',3816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',221067.00,NULL,NULL,1,'2023-05-11 14:51:16','2023-05-11 14:51:16',NULL),(4673,7561,40725,3045,2,3815,'App\\Models\\Receipt',3815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',127364.60,NULL,NULL,1,'2023-05-11 14:51:25','2023-05-11 14:51:25',NULL),(4674,7561,40725,3045,2,3814,'App\\Models\\Receipt',3814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',29487.70,NULL,NULL,1,'2023-05-11 14:51:36','2023-05-11 14:51:36',NULL),(4675,7561,40725,3045,2,3813,'App\\Models\\Receipt',3813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',100877.70,NULL,NULL,1,'2023-05-11 14:51:48','2023-05-11 14:51:48',NULL),(4676,7561,40725,3045,2,3804,'App\\Models\\Receipt',3804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',71898.20,NULL,NULL,1,'2023-05-11 14:52:27','2023-05-11 14:52:27',NULL),(4677,7561,40725,3045,2,3806,'App\\Models\\Receipt',3806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',72043.40,NULL,NULL,1,'2023-05-11 14:52:47','2023-05-11 14:52:47',NULL),(4678,7561,40725,3045,2,3799,'App\\Models\\Receipt',3799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',53391.25,NULL,NULL,1,'2023-05-11 14:53:09','2023-05-11 14:53:09',NULL),(4679,7561,40725,3045,2,3798,'App\\Models\\Receipt',3798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',178257.20,NULL,NULL,1,'2023-05-11 14:53:25','2023-05-11 14:53:25',NULL),(4680,7561,40725,3045,2,3812,'App\\Models\\Receipt',3812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',201226.03,NULL,NULL,1,'2023-05-11 15:21:18','2023-05-11 15:21:18',NULL),(4681,7561,40725,3045,2,3811,'App\\Models\\Receipt',3811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',87201.80,NULL,NULL,1,'2023-05-11 15:21:32','2023-05-11 15:21:32',NULL),(4682,7561,40725,3045,2,3810,'App\\Models\\Receipt',3810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',199204.14,NULL,NULL,1,'2023-05-11 15:21:42','2023-05-11 15:21:42',NULL),(4683,7561,40725,3045,2,3803,'App\\Models\\Receipt',3803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',38901.50,NULL,NULL,1,'2023-05-11 15:22:19','2023-05-11 15:22:19',NULL),(4684,7561,40725,3045,2,3802,'App\\Models\\Receipt',3802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',48400.60,NULL,NULL,1,'2023-05-11 15:22:53','2023-05-11 15:22:53',NULL),(4685,7561,40725,3045,2,3801,'App\\Models\\Receipt',3801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',48406.05,NULL,NULL,1,'2023-05-11 15:24:03','2023-05-11 15:25:03','2023-05-11 15:25:03'),(4686,7561,40725,3045,2,3801,'App\\Models\\Receipt',3801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',48406.05,NULL,NULL,1,'2023-05-11 15:25:03','2023-05-11 15:25:03',NULL),(4687,7561,40725,3045,3,3863,'App\\Models\\Receipt',3863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',4031.42,NULL,NULL,1,'2023-05-11 15:34:26','2023-05-11 15:34:26',NULL),(4688,7561,40725,3045,15,2040,'App\\Models\\PeriodLiquidation',NULL,2040,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',418496.18,NULL,NULL,1,'2023-05-12 12:25:53','2023-05-12 12:25:53',NULL),(4689,7561,40725,3045,16,2045,'App\\Models\\PeriodLiquidation',NULL,2045,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',91584.32,NULL,NULL,1,'2023-05-12 12:26:13','2023-05-12 12:26:13',NULL),(4690,7561,40727,1533,15,1939,'App\\Models\\PeriodLiquidation',NULL,1939,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',266116.50,NULL,NULL,1,'2023-05-12 17:20:04','2023-05-12 17:20:04',NULL);
INSERT INTO `balance_libro` VALUES (4691,7561,40727,1533,1,4691,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-04-30',NULL,908366.43,NULL,NULL,1,'2023-05-17 09:08:03','2023-05-17 09:08:03',NULL),(4692,7561,40734,15267,2,3864,'App\\Models\\Receipt',3864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',74520.00,NULL,NULL,1,'2023-05-20 09:51:11','2023-05-20 09:51:11',NULL),(4693,7561,40734,15268,2,3865,'App\\Models\\Receipt',3865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',75440.00,NULL,NULL,1,'2023-05-20 09:51:39','2023-05-20 09:51:39',NULL),(4694,7561,40852,7618,2,3866,'App\\Models\\Receipt',3866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',153150.00,NULL,NULL,1,'2023-05-20 11:05:13','2023-05-20 11:05:13',NULL),(4695,7561,40852,7618,2,3867,'App\\Models\\Receipt',3867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',50000.00,NULL,NULL,1,'2023-05-20 11:05:13','2023-05-20 11:05:13',NULL),(4696,7561,40857,18328,16,2050,'App\\Models\\PeriodLiquidation',NULL,2050,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',0.00,NULL,NULL,1,'2023-05-20 11:40:31','2023-05-20 11:42:16','2023-05-20 11:42:16'),(4697,7561,40857,18328,2,3868,'App\\Models\\Receipt',3868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',40476.00,NULL,NULL,1,'2023-05-20 11:42:54','2023-05-20 11:42:54',NULL),(4698,7561,40857,18328,2,3869,'App\\Models\\Receipt',3869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',40476.00,NULL,NULL,1,'2023-05-20 11:42:54','2023-05-20 11:42:54',NULL),(4699,7561,40857,18328,2,3870,'App\\Models\\Receipt',3870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',49400.00,NULL,NULL,1,'2023-05-20 11:42:54','2023-05-20 11:42:54',NULL),(4700,7561,40857,18328,2,3871,'App\\Models\\Receipt',3871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',38000.00,NULL,NULL,1,'2023-05-20 11:42:54','2023-05-20 11:42:54',NULL),(4701,7561,40857,18328,2,3872,'App\\Models\\Receipt',3872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',40476.00,NULL,NULL,1,'2023-05-20 11:42:54','2023-05-20 11:42:54',NULL),(4753,7561,40850,4557,2,3924,'App\\Models\\Receipt',3924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',3000.00,NULL,NULL,1,'2023-05-22 08:44:31','2023-05-22 08:44:31',NULL),(4754,7561,40850,4557,2,3925,'App\\Models\\Receipt',3925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',3000.00,NULL,NULL,1,'2023-05-22 08:44:31','2023-05-22 08:44:31',NULL),(4755,7561,40850,4557,2,3926,'App\\Models\\Receipt',3926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4756,7561,40850,4557,2,3927,'App\\Models\\Receipt',3927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4757,7561,40850,4557,2,3928,'App\\Models\\Receipt',3928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4758,7561,40850,4557,2,3929,'App\\Models\\Receipt',3929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4759,7561,40850,4557,2,3930,'App\\Models\\Receipt',3930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4760,7561,40850,4557,2,3931,'App\\Models\\Receipt',3931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4761,7561,40850,4557,2,3932,'App\\Models\\Receipt',3932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4762,7561,40850,4557,2,3933,'App\\Models\\Receipt',3933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL);
INSERT INTO `balance_libro` VALUES (4763,7561,40850,4557,2,3934,'App\\Models\\Receipt',3934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4764,7561,40850,4557,2,3935,'App\\Models\\Receipt',3935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4765,7561,40850,4557,2,3936,'App\\Models\\Receipt',3936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4766,7561,40850,4557,2,3937,'App\\Models\\Receipt',3937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4767,7561,40850,4557,2,3938,'App\\Models\\Receipt',3938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4768,7561,40850,4557,2,3939,'App\\Models\\Receipt',3939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4769,7561,40850,4557,2,3940,'App\\Models\\Receipt',3940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4770,7561,40850,4557,2,3941,'App\\Models\\Receipt',3941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4771,7561,40850,4557,2,3942,'App\\Models\\Receipt',3942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4772,7561,40850,4557,2,3943,'App\\Models\\Receipt',3943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4773,7561,40850,4557,2,3944,'App\\Models\\Receipt',3944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4774,7561,40850,4557,2,3945,'App\\Models\\Receipt',3945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4775,7561,40850,4557,2,3946,'App\\Models\\Receipt',3946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',3000.00,NULL,NULL,1,'2023-05-22 08:44:32','2023-05-22 08:44:32',NULL),(4776,7561,40850,4557,2,3947,'App\\Models\\Receipt',3947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',3000.00,NULL,NULL,1,'2023-05-22 08:44:33','2023-05-22 08:44:33',NULL),(4777,7561,40850,4557,2,3948,'App\\Models\\Receipt',3948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',3000.00,NULL,NULL,1,'2023-05-22 08:44:33','2023-05-22 08:44:33',NULL),(4778,7561,40850,4557,2,3949,'App\\Models\\Receipt',3949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',3000.00,NULL,NULL,1,'2023-05-22 08:44:33','2023-05-22 08:44:33',NULL),(4779,7561,40850,4557,2,3950,'App\\Models\\Receipt',3950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',3000.00,NULL,NULL,1,'2023-05-22 08:44:33','2023-05-22 08:44:33',NULL),(4780,7561,40850,4557,2,3951,'App\\Models\\Receipt',3951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',3000.00,NULL,NULL,1,'2023-05-22 08:44:33','2023-05-22 08:44:33',NULL),(4781,7561,40850,4557,2,3952,'App\\Models\\Receipt',3952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',3000.00,NULL,NULL,1,'2023-05-22 08:44:33','2023-05-22 08:44:33',NULL),(4782,7561,40850,4557,2,3953,'App\\Models\\Receipt',3953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',3000.00,NULL,NULL,1,'2023-05-22 08:44:33','2023-05-22 08:44:33',NULL),(4783,7561,40850,4557,2,3954,'App\\Models\\Receipt',3954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',3000.00,NULL,NULL,1,'2023-05-22 08:44:33','2023-05-22 08:44:33',NULL);
INSERT INTO `balance_libro` VALUES (4784,7561,40850,4557,2,3955,'App\\Models\\Receipt',3955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',3000.00,NULL,NULL,1,'2023-05-22 08:44:33','2023-05-22 08:44:33',NULL),(4785,7561,40850,4557,2,3956,'App\\Models\\Receipt',3956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',3000.00,NULL,NULL,1,'2023-05-22 08:44:33','2023-05-22 08:44:33',NULL),(4786,7561,40850,4557,2,3957,'App\\Models\\Receipt',3957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',3000.00,NULL,NULL,1,'2023-05-22 08:44:33','2023-05-22 08:44:33',NULL),(4787,7561,40850,4557,2,3958,'App\\Models\\Receipt',3958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',3000.00,NULL,NULL,1,'2023-05-22 08:44:33','2023-05-22 08:44:33',NULL),(4788,7561,40850,4557,2,3959,'App\\Models\\Receipt',3959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',3000.00,NULL,NULL,1,'2023-05-22 08:44:33','2023-05-22 08:44:33',NULL),(4789,7561,40850,4557,2,3960,'App\\Models\\Receipt',3960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',3000.00,NULL,NULL,1,'2023-05-22 08:44:33','2023-05-22 08:44:33',NULL),(4790,7561,40850,4557,2,3961,'App\\Models\\Receipt',3961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',3000.00,NULL,NULL,1,'2023-05-22 08:44:33','2023-05-22 08:44:33',NULL),(4791,7561,40850,4557,2,3962,'App\\Models\\Receipt',3962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',3000.00,NULL,NULL,1,'2023-05-22 08:44:33','2023-05-22 08:44:33',NULL),(4792,7561,40850,4557,2,3963,'App\\Models\\Receipt',3963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',3000.00,NULL,NULL,1,'2023-05-22 08:44:33','2023-05-22 08:44:33',NULL),(4793,7561,40850,4557,2,3964,'App\\Models\\Receipt',3964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',3000.00,NULL,NULL,1,'2023-05-22 08:44:33','2023-05-22 08:44:33',NULL),(4794,7561,40850,4557,2,3965,'App\\Models\\Receipt',3965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',3000.00,NULL,NULL,1,'2023-05-22 08:44:33','2023-05-22 08:44:33',NULL),(4795,7561,40850,4557,2,3966,'App\\Models\\Receipt',3966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',3000.00,NULL,NULL,1,'2023-05-22 08:44:34','2023-05-22 08:44:34',NULL),(4796,7561,40850,4557,2,3967,'App\\Models\\Receipt',3967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',3000.00,NULL,NULL,1,'2023-05-22 08:44:34','2023-05-22 08:44:34',NULL),(4797,7561,40850,4557,2,3968,'App\\Models\\Receipt',3968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',3000.00,NULL,NULL,1,'2023-05-22 08:44:34','2023-05-22 08:44:34',NULL),(4798,7561,40850,4557,2,3969,'App\\Models\\Receipt',3969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',3000.00,NULL,NULL,1,'2023-05-22 08:44:34','2023-05-22 08:44:34',NULL),(4799,7561,40850,4557,2,3970,'App\\Models\\Receipt',3970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',3000.00,NULL,NULL,1,'2023-05-22 08:44:34','2023-05-22 08:44:34',NULL),(4800,7561,40850,4557,2,3971,'App\\Models\\Receipt',3971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',3000.00,NULL,NULL,1,'2023-05-22 08:44:34','2023-05-22 08:44:34',NULL),(4801,7561,40850,4557,2,3972,'App\\Models\\Receipt',3972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',3000.00,NULL,NULL,1,'2023-05-22 08:44:34','2023-05-22 08:44:34',NULL),(4802,7561,40850,4557,2,3973,'App\\Models\\Receipt',3973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',3000.00,NULL,NULL,1,'2023-05-22 08:44:34','2023-05-22 08:44:34',NULL),(4803,7561,40850,4557,2,3974,'App\\Models\\Receipt',3974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',3000.00,NULL,NULL,1,'2023-05-22 08:44:34','2023-05-22 08:44:34',NULL),(4804,7561,40850,4557,2,3975,'App\\Models\\Receipt',3975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',3000.00,NULL,NULL,1,'2023-05-22 08:44:34','2023-05-22 08:44:34',NULL);
INSERT INTO `balance_libro` VALUES (4805,7561,40850,4557,2,3976,'App\\Models\\Receipt',3976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',3000.00,NULL,NULL,1,'2023-05-22 08:44:34','2023-05-22 08:44:34',NULL),(4806,7561,40850,4557,2,3977,'App\\Models\\Receipt',3977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',3000.00,NULL,NULL,1,'2023-05-22 08:44:34','2023-05-22 08:44:34',NULL),(4807,7561,40850,4557,2,3978,'App\\Models\\Receipt',3978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',3000.00,NULL,NULL,1,'2023-05-22 08:44:34','2023-05-22 08:44:34',NULL),(4808,7561,40850,4557,2,3979,'App\\Models\\Receipt',3979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',3000.00,NULL,NULL,1,'2023-05-22 08:44:34','2023-05-22 08:44:34',NULL),(4809,7561,40850,4557,2,3980,'App\\Models\\Receipt',3980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',3000.00,NULL,NULL,1,'2023-05-22 08:44:34','2023-05-22 08:44:34',NULL),(4810,7561,40850,4557,2,3981,'App\\Models\\Receipt',3981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',3000.00,NULL,NULL,1,'2023-05-22 08:44:34','2023-05-22 08:44:34',NULL),(4811,7561,40850,4557,2,3982,'App\\Models\\Receipt',3982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',3000.00,NULL,NULL,1,'2023-05-22 08:44:34','2023-05-22 08:44:34',NULL),(4812,7561,40853,9144,2,3983,'App\\Models\\Receipt',3983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',30000.00,NULL,NULL,1,'2023-05-22 09:08:02','2023-05-22 09:08:02',NULL),(4813,7561,40853,9144,2,3984,'App\\Models\\Receipt',3984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',16200.00,NULL,NULL,1,'2023-05-22 09:08:02','2023-05-22 09:08:02',NULL),(4814,7561,40853,9145,2,3985,'App\\Models\\Receipt',3985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1300.00,NULL,NULL,1,'2023-05-22 09:08:24','2023-05-22 09:08:24',NULL),(4815,7561,40853,9145,2,3986,'App\\Models\\Receipt',3986,NU