-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-22228854-7
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-11-08 09:47:10','Actividad Generica 1','000001',NULL),(2,NULL,'2022-11-08 09:47:10','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'Laura160671',NULL,1,40719,'2022-11-22'),(2,NULL,'German*5656','lab',1,40720,'2022-11-23'),(3,NULL,'Laura160671',NULL,1,40719,'2022-11-23'),(4,NULL,'German*5656','lab',1,40720,'2022-11-26'),(5,NULL,'GeneralChoi1955','lab',1,40918,'2022-11-29'),(6,NULL,'Zingueria09',NULL,1,40943,'2022-11-29'),(7,NULL,'Zingueria09',NULL,1,40943,'2022-11-29'),(8,NULL,'Zingueria09',NULL,1,40943,'2022-11-29'),(9,NULL,'Sotoma*1974','lab',1,41120,'2022-12-09'),(10,NULL,'Marta*1974',NULL,3,41120,'2022-12-09'),(11,NULL,'German*5656','lab',1,40720,'2022-12-09'),(12,NULL,'German*5656','lab',1,40720,'2022-12-09'),(13,NULL,'123456','pers.',3,40720,'2022-12-09'),(14,NULL,'Melina*2926',NULL,1,41123,'2022-12-09'),(15,NULL,'Melina2926',NULL,3,41123,'2022-12-09'),(16,NULL,'Pablo400457','lab',1,40731,'2022-12-09'),(17,NULL,'Batman2021',NULL,1,41147,'2022-12-09'),(18,NULL,'Luana123456',NULL,3,41147,'2022-12-09'),(19,NULL,'Batman2021',NULL,1,41147,'2022-12-09'),(20,NULL,'Luana123456',NULL,3,41147,'2022-12-09'),(21,NULL,'GeneralChoi1955','lab',1,40918,'2022-12-12'),(22,NULL,'Melina*2926',NULL,1,41123,'2022-12-15'),(23,NULL,'Melina2926',NULL,3,41123,'2022-12-15'),(24,NULL,'Melina*2926',NULL,1,41123,'2022-12-15'),(25,NULL,'Melina2926',NULL,3,41123,'2022-12-15'),(26,NULL,'Melina*2926',NULL,1,41123,'2022-12-21'),(27,NULL,'Melina2926',NULL,3,41123,'2022-12-21'),(28,NULL,'Melina*2926',NULL,1,41123,'2022-12-21'),(29,NULL,'Melina2926',NULL,3,41123,'2022-12-21'),(30,NULL,'Pablo400457','lab',1,40731,'2023-01-15'),(31,NULL,'Equise0457',NULL,3,40731,'2023-01-15'),(32,NULL,'Diegoroma22',NULL,1,41360,'2023-01-31'),(33,NULL,'Diegoroma22',NULL,1,41360,'2023-01-31'),(34,NULL,'German*5656','lab',1,40720,'2023-02-20'),(35,NULL,'123456','pers.',3,40720,'2023-02-20'),(36,NULL,'Melina*2926','PERS',1,41123,'2023-02-21'),(37,NULL,'Melina2926',NULL,3,41123,'2023-02-21'),(38,NULL,'Melina*2926','PERS',1,41123,'2023-02-21'),(39,NULL,'Melina2926',NULL,3,41123,'2023-02-21'),(40,NULL,'Melina*2926','PERS',1,41123,'2023-02-21'),(41,NULL,'Melina2926',NULL,3,41123,'2023-02-21'),(42,NULL,'Melina*2926','PERS',1,41123,'2023-02-21'),(43,NULL,'Melina2926',NULL,3,41123,'2023-02-21'),(44,NULL,'Sotoma*1974','lab',1,41120,'2023-03-22'),(45,NULL,'Marta*1974',NULL,3,41120,'2023-03-22');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'laura8548@hotmail.com','1163653274',NULL,1,40719,'2022-11-22'),(2,'laura8548@hotmail.com','1163653274','',1,40719,'2022-11-22'),(3,'techadosgerman@gmail.com',NULL,'lab',1,40720,'2022-11-23'),(4,'german-8@live.com.ar',NULL,'pers.',2,40720,'2022-11-23'),(5,'laura8548@hotmail.com','1163653274','',1,40719,'2022-11-23'),(6,'techadosgerman@gmail.com',NULL,'lab',1,40720,'2022-11-26'),(7,'german-8@live.com.ar',NULL,'pers.',2,40720,'2022-11-26'),(8,'christianquantin95@gmail.com',NULL,'lab',1,40918,'2022-11-29'),(9,'seramista2011@hotmail.com',NULL,'lab',1,41120,'2022-12-09'),(10,'techadosgerman@gmail.com',NULL,'lab',1,40720,'2022-12-09'),(11,'german-8@live.com.ar',NULL,'pers.',2,40720,'2022-12-09'),(12,'techadosgerman@gmail.com',NULL,'lab',1,40720,'2022-12-09'),(13,'german-8@live.com.ar',NULL,'pers.',2,40720,'2022-12-09'),(14,'melina.velasco.s@gmail.com',NULL,'',1,41123,'2022-12-09'),(15,'pabloelcuervo-29@hotmail.com',NULL,'lab',1,40731,'2022-12-09'),(16,'luanaaferreyra18@gmail.com',NULL,'',1,41147,'2022-12-09'),(17,'luanaaferreyra18@gmail.com',NULL,'',1,41147,'2022-12-09'),(18,'christianquantin95@gmail.com',NULL,'lab',1,40918,'2022-12-12'),(19,'melina.velasco.s@gmail.com',NULL,'',1,41123,'2022-12-15'),(20,'melina.velasco.s@gmail.com',NULL,'',1,41123,'2022-12-15'),(21,'melina.velasco.s@gmail.com',NULL,'',1,41123,'2022-12-21'),(22,'melina.velasco.s@gmail.com',NULL,'',1,41123,'2022-12-21'),(23,'pabloelcuervo-29@hotmail.com',NULL,'lab',1,40731,'2023-01-15'),(24,'diegoromanellisoluciones@hotmail.com',NULL,'',1,41360,'2023-01-31'),(25,'diegoromanellisoluciones@hotmail.com',NULL,'',1,41360,'2023-01-31'),(26,'techadosgerman@gmail.com',NULL,'lab',1,40720,'2023-02-20'),(27,'german-8@live.com.ar',NULL,'pers.',2,40720,'2023-02-20'),(28,'melina.velasco.s@gmail.com',NULL,'PERS',1,41123,'2023-02-21'),(29,'melina.velasco.s@gmail.com',NULL,'PERS',1,41123,'2023-02-21'),(30,'melina.velasco.s@gmail.com',NULL,'PERS',1,41123,'2023-02-21'),(31,'melina.velasco.s@gmail.com',NULL,'PERS',1,41123,'2023-02-21'),(32,'seramista2011@hotmail.com',NULL,'lab',1,41120,'2023-03-22');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2492 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,8081,40720,1515,8,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',0.00,NULL,NULL,1,'2022-11-22 21:52:30','2022-11-22 21:58:52','2022-11-22 21:58:52'),(2,8081,40720,1515,8,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',0.00,NULL,NULL,1,'2022-11-22 21:58:52','2022-11-22 21:59:17','2022-11-22 21:59:17'),(3,8081,40720,1515,8,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',0.00,NULL,NULL,1,'2022-11-22 21:59:17','2022-11-28 11:20:36','2022-11-28 11:20:36'),(4,8081,40719,12,8,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',416.00,NULL,NULL,1,'2022-11-25 18:22:32','2022-11-25 18:22:32',NULL),(5,8081,40720,1515,3,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',697.11,NULL,NULL,1,'2022-11-26 20:45:57','2022-11-26 20:45:57',NULL),(6,8081,40720,1515,3,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1766.00,NULL,NULL,1,'2022-11-26 20:45:57','2022-11-26 20:45:57',NULL),(7,8081,40720,1515,3,6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1100.00,NULL,NULL,1,'2022-11-26 20:45:57','2022-11-26 20:45:57',NULL),(8,8081,40720,1515,3,7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1195.00,NULL,NULL,1,'2022-11-26 20:45:58','2022-11-26 20:45:58',NULL),(9,8081,40720,1515,3,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',44741.92,NULL,NULL,1,'2022-11-26 20:45:58','2022-11-26 20:45:58',NULL),(10,8081,40720,1515,3,9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1652.00,NULL,NULL,1,'2022-11-26 20:45:58','2022-11-26 20:45:58',NULL),(11,8081,40731,9027,2,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',5700.00,NULL,NULL,1,'2022-11-26 22:46:11','2022-11-26 22:46:11',NULL),(12,8081,40731,9027,2,11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',45300.00,NULL,NULL,1,'2022-11-26 22:46:11','2022-11-26 22:46:11',NULL),(13,8081,40731,9027,2,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',46000.00,NULL,NULL,1,'2022-11-26 22:46:11','2022-11-26 22:46:11',NULL),(14,8081,40731,9027,2,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',3300.00,NULL,NULL,1,'2022-11-26 22:46:11','2022-11-26 22:46:11',NULL),(15,8081,40731,9027,2,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',4645.00,NULL,NULL,1,'2022-11-26 22:46:11','2022-11-26 22:46:11',NULL),(16,8081,40731,9027,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',17080.00,NULL,NULL,1,'2022-11-26 22:46:11','2022-11-26 22:46:11',NULL),(17,8081,40731,9027,2,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',5700.00,NULL,NULL,1,'2022-11-26 22:46:12','2022-11-26 22:46:12',NULL),(18,8081,40731,9027,2,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',64390.00,NULL,NULL,1,'2022-11-26 22:46:12','2022-11-26 22:46:12',NULL),(19,8081,40731,9027,2,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',3300.00,NULL,NULL,1,'2022-11-26 22:46:12','2022-11-26 22:46:12',NULL),(20,8081,40731,9027,2,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',53335.00,NULL,NULL,1,'2022-11-26 22:46:12','2022-11-26 22:46:12',NULL),(21,8081,40731,9027,2,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',53335.00,NULL,NULL,1,'2022-11-26 22:46:12','2022-11-26 22:46:12',NULL),(22,8081,40731,9027,2,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',18130.00,NULL,NULL,1,'2022-11-26 22:46:12','2022-11-26 22:46:12',NULL),(23,8081,40731,9027,3,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',31022.59,NULL,NULL,1,'2022-11-26 22:47:36','2022-11-27 00:47:35','2022-11-27 00:47:35'),(24,8081,40731,9027,3,23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',17933.01,NULL,NULL,1,'2022-11-26 22:47:36','2022-11-27 00:46:43','2022-11-27 00:46:43'),(25,8081,40731,9027,3,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-09','2022-10-09',34397.75,NULL,NULL,1,'2022-11-26 22:47:36','2022-11-27 00:46:12','2022-11-27 00:46:12');
INSERT INTO `balance_libro` VALUES (26,8081,40731,9027,3,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',12.46,NULL,NULL,1,'2022-11-26 22:47:36','2022-11-27 00:45:38','2022-11-27 00:45:38'),(27,8081,40731,9027,3,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',64386.60,NULL,NULL,1,'2022-11-26 22:47:37','2022-11-27 00:45:02','2022-11-27 00:45:02'),(28,8081,40731,9027,3,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',10400.00,NULL,NULL,1,'2022-11-26 22:47:37','2022-11-26 22:47:37',NULL),(29,8081,40731,9027,3,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',54928.62,NULL,NULL,1,'2022-11-26 22:47:37','2022-11-27 00:44:22','2022-11-27 00:44:22'),(30,8081,40731,9027,3,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',19.86,NULL,NULL,1,'2022-11-26 22:47:37','2022-11-26 22:47:37',NULL),(31,8081,40731,9027,3,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',68.00,NULL,NULL,1,'2022-11-26 22:47:37','2022-11-26 22:47:37',NULL),(32,8081,40731,9027,3,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',28591.12,NULL,NULL,1,'2022-11-26 22:47:37','2022-11-27 00:43:45','2022-11-27 00:43:45'),(33,8081,40731,9027,3,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1387.13,NULL,NULL,1,'2022-11-26 22:47:37','2022-11-27 00:43:05','2022-11-27 00:43:05'),(34,8081,40731,9027,3,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1387.13,NULL,NULL,1,'2022-11-27 00:43:05','2022-11-27 00:43:05',NULL),(35,8081,40731,9027,3,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',28591.12,NULL,NULL,1,'2022-11-27 00:43:45','2022-11-27 00:43:45',NULL),(36,8081,40731,9027,3,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',54928.61,NULL,NULL,1,'2022-11-27 00:44:22','2022-11-27 00:44:22',NULL),(37,8081,40731,9027,3,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',64386.60,NULL,NULL,1,'2022-11-27 00:45:02','2022-11-27 00:45:02',NULL),(38,8081,40731,9027,3,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',12.46,NULL,NULL,1,'2022-11-27 00:45:38','2022-11-27 00:45:38',NULL),(39,8081,40731,9027,3,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-09','2022-10-09',34397.75,NULL,NULL,1,'2022-11-27 00:46:12','2022-11-27 00:46:12',NULL),(40,8081,40731,9027,3,23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',17933.01,NULL,NULL,1,'2022-11-27 00:46:43','2022-11-27 00:46:43',NULL),(41,8081,40731,9027,3,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',31022.59,NULL,NULL,1,'2022-11-27 00:47:35','2022-11-27 00:47:35',NULL),(42,8081,40731,9027,8,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-27','2022-11-27',1110.43,NULL,NULL,1,'2022-11-27 00:58:55','2022-11-27 00:58:55',NULL),(43,8081,40731,9027,8,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-27','2022-11-27',71.27,NULL,NULL,1,'2022-11-27 00:58:55','2022-11-27 00:58:55',NULL),(44,8081,40731,9027,16,NULL,28,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',12757.45,NULL,NULL,1,'2022-11-27 01:01:17','2022-11-27 01:01:17',NULL),(45,8081,40771,48402,2,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',1300.00,NULL,NULL,1,'2022-11-27 18:43:18','2022-11-27 18:43:18',NULL),(46,8081,40771,48402,2,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',1100.00,NULL,NULL,1,'2022-11-27 18:43:18','2022-11-27 18:43:18',NULL),(47,8081,40771,48402,2,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',10000.00,NULL,NULL,1,'2022-11-27 18:43:18','2022-11-27 18:43:18',NULL),(48,8081,40771,48402,2,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',1200.00,NULL,NULL,1,'2022-11-27 18:43:18','2022-11-27 18:43:18',NULL),(49,8081,40771,48402,2,39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',4000.00,NULL,NULL,1,'2022-11-27 18:43:18','2022-11-27 18:43:18',NULL);
INSERT INTO `balance_libro` VALUES (50,8081,40771,48402,2,40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',2500.00,NULL,NULL,1,'2022-11-27 18:43:18','2022-11-27 18:43:18',NULL),(51,8081,40771,48402,2,41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',2800.00,NULL,NULL,1,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(52,8081,40771,48402,2,42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',1100.00,NULL,NULL,1,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(53,8081,40771,48402,2,43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',1000.00,NULL,NULL,1,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(54,8081,40771,48402,2,44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',1000.00,NULL,NULL,1,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(55,8081,40771,48402,2,45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',1000.00,NULL,NULL,1,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(56,8081,40771,48402,2,46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',23800.00,NULL,NULL,1,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(57,8081,40771,48402,2,47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',11900.00,NULL,NULL,1,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(58,8081,40771,48402,2,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',3700.00,NULL,NULL,1,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(59,8081,40771,48402,2,49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',850.00,NULL,NULL,1,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(84,8081,40771,48404,2,74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',1000.00,NULL,NULL,1,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(85,8081,40771,48404,2,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1500.00,NULL,NULL,1,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(86,8081,40771,48404,2,76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',2200.00,NULL,NULL,1,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(87,8081,40771,48404,2,77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1300.00,NULL,NULL,1,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(88,8081,40771,48404,2,78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1200.00,NULL,NULL,1,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(89,8081,40771,48404,2,79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',1400.00,NULL,NULL,1,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(90,8081,40771,48404,2,80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',3500.00,NULL,NULL,1,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(91,8081,40771,48404,2,81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',2500.00,NULL,NULL,1,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(92,8081,40771,48404,2,82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',1300.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(93,8081,40771,48404,2,83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',1300.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(94,8081,40771,48404,2,84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',1300.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(95,8081,40771,48404,2,85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',1300.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(96,8081,40771,48404,2,86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',8400.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(97,8081,40771,48404,2,87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',1300.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(98,8081,40771,48404,2,88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',1300.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL);
INSERT INTO `balance_libro` VALUES (99,8081,40771,48404,2,89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',1300.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(100,8081,40771,48404,2,90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',2500.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(101,8081,40771,48404,2,91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',3500.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(102,8081,40771,48404,2,92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',1300.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(103,8081,40771,48404,2,93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',1300.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(104,8081,40771,48404,2,94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1300.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(105,8081,40771,48404,2,95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1300.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(106,8081,40771,48404,2,96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',2500.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(107,8081,40771,48404,2,97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1300.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(108,8081,40771,48404,2,98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',7000.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(109,8081,40771,48404,2,99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1300.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(110,8081,40771,48404,2,100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',5600.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(111,8081,40771,48404,2,101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',5000.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(112,8081,40771,48404,2,102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1300.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(113,8081,40771,48404,2,103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1300.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(114,8081,40771,48404,2,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',7800.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(115,8081,40771,48404,2,105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1300.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(116,8081,40771,48404,2,106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1300.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(117,8081,40771,48404,2,107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1100.00,NULL,NULL,1,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(118,8081,40771,48405,2,108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',19150.00,NULL,NULL,1,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(119,8081,40771,48405,2,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1100.00,NULL,NULL,1,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(120,8081,40771,48405,2,110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',28050.00,NULL,NULL,1,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(121,8081,40771,48405,2,111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1200.00,NULL,NULL,1,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(122,8081,40771,48405,2,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',1100.00,NULL,NULL,1,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(123,8081,40771,48405,2,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',1100.00,NULL,NULL,1,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL);
INSERT INTO `balance_libro` VALUES (124,8081,40771,48405,2,114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',4900.00,NULL,NULL,1,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(125,8081,40771,48405,2,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',1100.00,NULL,NULL,1,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(126,8081,40771,48405,2,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',5000.00,NULL,NULL,1,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(127,8081,40771,48405,2,117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',2500.00,NULL,NULL,1,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(128,8081,40771,48405,2,118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',2500.00,NULL,NULL,1,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(129,8081,40771,48405,2,119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',5000.00,NULL,NULL,1,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(130,8081,40771,48405,2,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',2500.00,NULL,NULL,1,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(131,8081,40771,48405,2,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',1100.00,NULL,NULL,1,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(132,8081,40771,48405,2,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',5000.00,NULL,NULL,1,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(133,8081,40771,48405,2,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1300.00,NULL,NULL,1,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(134,8081,40771,48405,2,124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1300.00,NULL,NULL,1,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(135,8081,40771,48406,2,125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',1400.00,NULL,NULL,1,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(136,8081,40771,48406,2,126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',1100.00,NULL,NULL,1,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(137,8081,40771,48406,2,127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',1100.00,NULL,NULL,1,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(138,8081,40771,48406,2,128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',1300.00,NULL,NULL,1,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(139,8081,40771,48406,2,129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',1100.00,NULL,NULL,1,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(140,8081,40771,48406,2,130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',1100.00,NULL,NULL,1,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(141,8081,40771,48406,2,131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',1400.00,NULL,NULL,1,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(142,8081,40771,48406,2,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',21750.00,NULL,NULL,1,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(143,8081,40771,48406,2,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',1300.00,NULL,NULL,1,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(144,8081,40771,48406,2,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',1100.00,NULL,NULL,1,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(145,8081,40771,48406,2,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',1400.00,NULL,NULL,1,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(146,8081,40771,48406,2,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',1100.00,NULL,NULL,1,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(147,8081,40771,48406,2,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',25650.00,NULL,NULL,1,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(148,8081,40771,48406,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',42750.00,NULL,NULL,1,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL);
INSERT INTO `balance_libro` VALUES (149,8081,40771,48406,2,139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1950.00,NULL,NULL,1,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(150,8081,40771,48407,2,140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',1100.00,NULL,NULL,1,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(151,8081,40771,48407,2,141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',1100.00,NULL,NULL,1,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(152,8081,40771,48407,2,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',2500.00,NULL,NULL,1,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(153,8081,40771,48407,2,143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',2600.00,NULL,NULL,1,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(154,8081,40771,48407,2,144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',2800.00,NULL,NULL,1,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(155,8081,40771,48407,2,145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',1400.00,NULL,NULL,1,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(156,8081,40771,48407,2,146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',1400.00,NULL,NULL,1,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(157,8081,40771,48407,2,147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',1200.00,NULL,NULL,1,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(158,8081,40771,48407,2,148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',1500.00,NULL,NULL,1,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(159,8081,40771,48407,2,149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',1200.00,NULL,NULL,1,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(160,8081,40771,48407,2,150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',5000.00,NULL,NULL,1,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(161,8081,40771,48407,2,151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1500.00,NULL,NULL,1,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(162,8081,40771,48407,2,152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',5000.00,NULL,NULL,1,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(163,8081,40771,48407,2,153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3000.00,NULL,NULL,1,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(164,8081,40771,48407,2,154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3000.00,NULL,NULL,1,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(165,8081,40771,48407,2,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3000.00,NULL,NULL,1,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(166,8081,40771,48407,2,156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2000.00,NULL,NULL,1,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(167,8081,40771,48407,2,157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',5000.00,NULL,NULL,1,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(168,8081,40771,48407,2,158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',5000.00,NULL,NULL,1,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(169,8081,40771,48407,2,159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2500.00,NULL,NULL,1,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(170,8081,40771,48407,2,160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',5000.00,NULL,NULL,1,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(171,8081,40771,48407,2,161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',9000.00,NULL,NULL,1,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(172,8081,40771,48407,2,162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',4500.00,NULL,NULL,1,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(173,8081,40771,48408,2,163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1200.00,NULL,NULL,1,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL);
INSERT INTO `balance_libro` VALUES (174,8081,40771,48408,2,164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',1200.00,NULL,NULL,1,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(175,8081,40771,48408,2,165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',1400.00,NULL,NULL,1,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(176,8081,40771,48408,2,166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1400.00,NULL,NULL,1,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(177,8081,40771,48408,2,167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',15000.00,NULL,NULL,1,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(178,8081,40771,48408,2,168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',13500.00,NULL,NULL,1,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(179,8081,40771,48408,2,169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1200.00,NULL,NULL,1,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(180,8081,40771,48408,2,170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',5000.00,NULL,NULL,1,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(181,8081,40771,48408,2,171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',6000.00,NULL,NULL,1,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(182,8081,40771,48408,2,172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',5000.00,NULL,NULL,1,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(183,8081,40771,48408,2,173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',1500.00,NULL,NULL,1,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(184,8081,40771,48408,2,174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',4500.00,NULL,NULL,1,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(185,8081,40771,48408,2,175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',3300.00,NULL,NULL,1,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(186,8081,40771,48408,2,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1300.00,NULL,NULL,1,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(187,8081,40771,48408,2,177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',14500.00,NULL,NULL,1,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(188,8081,40771,48408,2,178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',7000.00,NULL,NULL,1,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(189,8081,40771,48408,2,179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15000.00,NULL,NULL,1,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(190,8081,40771,48408,2,180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7500.00,NULL,NULL,1,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(191,8081,40771,48408,2,181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2500.00,NULL,NULL,1,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(192,8081,40771,48408,2,182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6600.00,NULL,NULL,1,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(193,8081,40771,48409,2,183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',28600.00,NULL,NULL,1,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(194,8081,40771,48409,2,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',35200.00,NULL,NULL,1,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(195,8081,40771,48409,2,185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',1300.00,NULL,NULL,1,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(196,8081,40771,48409,2,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',1300.00,NULL,NULL,1,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(197,8081,40771,48409,2,187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',1700.00,NULL,NULL,1,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(198,8081,40771,48409,2,188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',1500.00,NULL,NULL,1,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL);
INSERT INTO `balance_libro` VALUES (199,8081,40771,48409,2,189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',1500.00,NULL,NULL,1,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(200,8081,40771,48409,2,190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',1300.00,NULL,NULL,1,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(201,8081,40771,48409,2,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',1500.00,NULL,NULL,1,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(202,8081,40771,48409,2,192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',21750.00,NULL,NULL,1,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(203,8081,40771,48409,2,193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',1500.00,NULL,NULL,1,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(204,8081,40771,48409,2,194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',9000.00,NULL,NULL,1,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(205,8081,40771,48409,2,195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',1500.00,NULL,NULL,1,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(206,8081,40771,48409,2,196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',2000.00,NULL,NULL,1,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(207,8081,40771,48409,2,197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',1700.00,NULL,NULL,1,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(208,8081,40771,48409,2,198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',2500.00,NULL,NULL,1,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(209,8081,40771,48409,2,199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2000.00,NULL,NULL,1,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(210,8081,40771,48409,2,200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',5000.00,NULL,NULL,1,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(211,8081,40771,48409,2,201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',4500.00,NULL,NULL,1,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(212,8081,40771,48410,2,202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',2000.00,NULL,NULL,1,'2022-11-27 19:43:31','2022-11-27 19:43:31',NULL),(213,8081,40771,48410,2,203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',1500.00,NULL,NULL,1,'2022-11-27 19:43:31','2022-11-27 19:43:31',NULL),(214,8081,40771,48410,2,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',2000.00,NULL,NULL,1,'2022-11-27 19:43:31','2022-11-27 19:43:31',NULL),(215,8081,40771,48410,2,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',11000.00,NULL,NULL,1,'2022-11-27 19:43:31','2022-11-27 19:43:31',NULL),(216,8081,40771,48410,2,206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',1500.00,NULL,NULL,1,'2022-11-27 19:43:31','2022-11-27 19:43:31',NULL),(217,8081,40771,48410,2,207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',1500.00,NULL,NULL,1,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(218,8081,40771,48410,2,208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',2000.00,NULL,NULL,1,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(219,8081,40771,48410,2,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',12100.00,NULL,NULL,1,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(220,8081,40771,48410,2,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',1500.00,NULL,NULL,1,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(221,8081,40771,48410,2,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',1500.00,NULL,NULL,1,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(222,8081,40771,48410,2,212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',3400.00,NULL,NULL,1,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(223,8081,40771,48410,2,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',1800.00,NULL,NULL,1,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL);
INSERT INTO `balance_libro` VALUES (224,8081,40771,48410,2,214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',1800.00,NULL,NULL,1,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(225,8081,40771,48410,2,215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',40800.00,NULL,NULL,1,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(226,8081,40771,48410,2,216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',7200.00,NULL,NULL,1,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(227,8081,40771,48410,2,217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2200.00,NULL,NULL,1,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(228,8081,40771,48410,2,218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1600.00,NULL,NULL,1,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(229,8081,40771,48410,2,219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',68400.00,NULL,NULL,1,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(230,8081,40771,48411,2,220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2000.00,NULL,NULL,1,'2022-11-27 19:44:02','2022-11-27 19:44:02',NULL),(231,8081,40771,48411,2,221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1600.00,NULL,NULL,1,'2022-11-27 19:44:02','2022-11-27 19:44:02',NULL),(232,8081,40771,48411,2,222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3000.00,NULL,NULL,1,'2022-11-27 19:44:02','2022-11-27 19:44:02',NULL),(233,8081,40771,48411,2,223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1600.00,NULL,NULL,1,'2022-11-27 19:44:02','2022-11-27 19:44:02',NULL),(234,8081,40771,48411,2,224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1600.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(235,8081,40771,48411,2,225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1600.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(236,8081,40771,48411,2,226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2500.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(237,8081,40771,48411,2,227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',6000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(238,8081,40771,48411,2,228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',3500.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(239,8081,40771,48411,2,229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',6000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(240,8081,40771,48411,2,230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',6000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(241,8081,40771,48411,2,231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(242,8081,40771,48411,2,232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(243,8081,40771,48411,2,233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',4000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(244,8081,40771,48411,2,234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1800.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(245,8081,40771,48411,2,235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',6000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(246,8081,40771,48411,2,236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(247,8081,40771,48411,2,237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(248,8081,40771,48411,2,238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',2000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL);
INSERT INTO `balance_libro` VALUES (249,8081,40771,48411,2,239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',5000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(250,8081,40771,48411,2,240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',5000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(251,8081,40771,48411,2,241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(252,8081,40771,48411,2,242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1800.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(253,8081,40771,48411,2,243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1800.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(254,8081,40771,48411,2,244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(255,8081,40771,48411,2,245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(256,8081,40771,48411,2,246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(257,8081,40771,48411,2,247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2800.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(258,8081,40771,48411,2,248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(259,8081,40771,48411,2,249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(260,8081,40771,48411,2,250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',4500.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(261,8081,40771,48411,2,251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(262,8081,40771,48411,2,252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2000.00,NULL,NULL,1,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(263,8081,40771,48411,2,253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2000.00,NULL,NULL,1,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(264,8081,40771,48411,2,254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',2000.00,NULL,NULL,1,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(265,8081,40771,48411,2,255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1800.00,NULL,NULL,1,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(266,8081,40771,48411,2,256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2000.00,NULL,NULL,1,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(267,8081,40771,48411,2,257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2000.00,NULL,NULL,1,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(268,8081,40771,48411,2,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4500.00,NULL,NULL,1,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(269,8081,40771,48411,2,259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',5000.00,NULL,NULL,1,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(270,8081,40771,48411,2,260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',5000.00,NULL,NULL,1,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(283,8081,40771,48403,2,273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',1000.00,NULL,NULL,1,'2022-11-27 19:51:51','2022-11-27 19:51:51',NULL),(284,8081,40771,48403,2,274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',1000.00,NULL,NULL,1,'2022-11-27 19:51:51','2022-11-30 21:14:50','2022-11-30 21:14:50');
INSERT INTO `balance_libro` VALUES (285,8081,40771,48403,2,275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',3200.00,NULL,NULL,1,'2022-11-27 19:51:51','2022-11-27 19:51:51',NULL),(286,8081,40771,48403,2,276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',1300.00,NULL,NULL,1,'2022-11-27 19:51:51','2022-11-30 21:15:17','2022-11-30 21:15:17'),(287,8081,40771,48403,2,277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',1300.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(288,8081,40771,48403,2,278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',1800.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-30 21:15:39','2022-11-30 21:15:39'),(289,8081,40771,48403,2,279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',1000.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-30 21:16:00','2022-11-30 21:16:00'),(290,8081,40771,48403,2,280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',1000.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(291,8081,40771,48403,2,281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',1000.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-30 21:16:24','2022-11-30 21:16:24'),(292,8081,40771,48403,2,282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',1000.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(293,8081,40771,48403,2,283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',1000.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-30 21:14:06','2022-11-30 21:14:06'),(294,8081,40771,48403,2,284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',7000.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(295,8081,40771,48403,2,285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',3000.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(296,8081,40771,48403,2,286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',8000.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(297,8081,40771,48403,2,287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',2500.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(298,8081,40771,48403,2,288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',1500.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(299,8081,40771,48403,2,289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',1000.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(300,8081,40771,48403,2,290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',8000.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(301,8081,40771,48403,2,291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',1000.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(302,8081,40771,48403,2,292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',3500.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(303,8081,40771,48403,2,293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',8000.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(304,8081,40771,48403,2,294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-26','2022-02-26',2000.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(305,8081,40771,48403,2,295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-26','2022-02-26',1500.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(306,8081,40771,48403,2,296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-26','2022-02-26',2500.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(307,8081,40771,48403,2,297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-27','2022-02-27',3500.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(308,8081,40771,48403,2,298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-27','2022-02-27',1500.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL);
INSERT INTO `balance_libro` VALUES (309,8081,40771,48403,2,299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1500.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(310,8081,40771,48403,2,300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',6000.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(311,8081,40771,48403,2,301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1500.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(312,8081,40771,48403,2,302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1500.00,NULL,NULL,1,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(313,8081,40771,48412,2,303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',6000.00,NULL,NULL,1,'2022-11-27 20:16:00','2022-11-27 20:16:52','2022-11-27 20:16:52'),(314,8081,40720,1515,8,304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',416.00,NULL,NULL,1,'2022-11-28 11:29:09','2022-11-28 11:29:09',NULL),(315,8081,40720,1515,16,NULL,30,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',17466.58,NULL,NULL,1,'2022-11-28 20:47:31','2022-11-28 20:47:31',NULL),(316,8081,40918,178692,3,305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',8985.00,NULL,NULL,1,'2022-11-30 00:04:18','2022-11-30 00:04:18',NULL),(317,8081,40918,178692,3,306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',1581.07,NULL,NULL,1,'2022-11-30 00:04:18','2022-11-30 00:04:18',NULL),(318,8081,40918,178692,3,307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',27818.00,NULL,NULL,1,'2022-11-30 00:04:18','2022-11-30 00:04:18',NULL),(319,8081,40918,178692,3,308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',23000.00,NULL,NULL,1,'2022-11-30 00:04:18','2022-11-30 00:04:18',NULL),(320,8081,40918,178692,2,309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',6500.00,NULL,NULL,1,'2022-11-30 00:04:34','2022-11-30 00:04:34',NULL),(321,8081,40918,178692,2,310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',1800.00,NULL,NULL,1,'2022-11-30 00:04:34','2022-11-30 00:04:34',NULL),(322,8081,40918,178692,2,311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',1800.00,NULL,NULL,1,'2022-11-30 00:04:34','2022-11-30 00:04:34',NULL),(323,8081,40918,178692,2,312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',2500.00,NULL,NULL,1,'2022-11-30 00:04:34','2022-11-30 00:04:34',NULL),(324,8081,40918,178692,2,313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',4500.00,NULL,NULL,1,'2022-11-30 00:04:34','2022-11-30 00:04:34',NULL),(325,8081,40918,178692,2,314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',3000.00,NULL,NULL,1,'2022-11-30 00:04:34','2022-11-30 00:04:34',NULL),(326,8081,40918,178693,2,315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',6000.00,NULL,NULL,1,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(327,8081,40918,178693,2,316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',6300.00,NULL,NULL,1,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(328,8081,40918,178693,2,317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3000.00,NULL,NULL,1,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(329,8081,40918,178693,2,318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',4000.00,NULL,NULL,1,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(330,8081,40918,178693,2,319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1800.00,NULL,NULL,1,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(331,8081,40918,178693,2,320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',4600.00,NULL,NULL,1,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(332,8081,40918,178693,2,321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',5400.00,NULL,NULL,1,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL);
INSERT INTO `balance_libro` VALUES (333,8081,40918,178694,2,322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-05','2022-06-05',2200.00,NULL,NULL,1,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(334,8081,40918,178694,2,323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-05','2022-06-05',2200.00,NULL,NULL,1,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(335,8081,40918,178694,2,324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-05','2022-06-05',6300.00,NULL,NULL,1,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(336,8081,40918,178694,2,325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',4000.00,NULL,NULL,1,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(337,8081,40918,178694,2,326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',3300.00,NULL,NULL,1,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(338,8081,40918,178694,2,327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',2200.00,NULL,NULL,1,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(339,8081,40918,178694,2,328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',2200.00,NULL,NULL,1,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(340,8081,40918,178694,2,329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',2200.00,NULL,NULL,1,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(341,8081,40918,178694,2,330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',1900.00,NULL,NULL,1,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(342,8081,40918,178694,2,331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',2200.00,NULL,NULL,1,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(343,8081,40918,178694,2,332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',4000.00,NULL,NULL,1,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(344,8081,40918,178694,2,333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',2000.00,NULL,NULL,1,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(345,8081,40918,178694,2,334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',3000.00,NULL,NULL,1,'2022-11-30 00:05:38','2022-11-30 00:05:38',NULL),(346,8081,40918,178694,2,335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',4000.00,NULL,NULL,1,'2022-11-30 00:05:38','2022-11-30 00:05:38',NULL),(347,8081,40918,178694,2,336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',4400.00,NULL,NULL,1,'2022-11-30 00:05:38','2022-11-30 00:05:38',NULL),(348,8081,40918,178694,2,337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',4400.00,NULL,NULL,1,'2022-11-30 00:05:38','2022-11-30 00:05:38',NULL),(349,8081,40918,178694,2,338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',8000.00,NULL,NULL,1,'2022-11-30 00:05:38','2022-11-30 00:05:38',NULL),(350,8081,40918,178696,2,339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',2500.00,NULL,NULL,1,'2022-11-30 00:06:27','2022-11-30 00:06:27',NULL),(351,8081,40918,178696,2,340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',4400.00,NULL,NULL,1,'2022-11-30 00:06:27','2022-11-30 00:06:27',NULL),(352,8081,40918,178696,2,341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',10000.00,NULL,NULL,1,'2022-11-30 00:06:27','2022-11-30 00:06:27',NULL),(353,8081,40918,178696,2,342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',3200.00,NULL,NULL,1,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(354,8081,40918,178696,2,343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',2500.00,NULL,NULL,1,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(355,8081,40918,178696,2,344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',2500.00,NULL,NULL,1,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(356,8081,40918,178696,2,345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',2500.00,NULL,NULL,1,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL);
INSERT INTO `balance_libro` VALUES (357,8081,40918,178696,2,346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',2500.00,NULL,NULL,1,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(358,8081,40918,178696,2,347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',12100.00,NULL,NULL,1,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(359,8081,40918,178696,2,348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',9000.00,NULL,NULL,1,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(360,8081,40918,178696,2,349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',12800.00,NULL,NULL,1,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(361,8081,40918,178696,2,350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',8100.00,NULL,NULL,1,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(362,8081,40918,178697,2,351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2500.00,NULL,NULL,1,'2022-11-30 00:06:49','2022-11-30 00:06:49',NULL),(363,8081,40918,178697,2,352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',7200.00,NULL,NULL,1,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(364,8081,40918,178697,2,353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',8400.00,NULL,NULL,1,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(365,8081,40918,178697,2,354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',12600.00,NULL,NULL,1,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(366,8081,40918,178697,2,355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',12500.00,NULL,NULL,1,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(367,8081,40918,178697,2,356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2500.00,NULL,NULL,1,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(368,8081,40918,178697,2,357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2500.00,NULL,NULL,1,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(369,8081,40918,178697,2,358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2500.00,NULL,NULL,1,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(370,8081,40918,178695,2,359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',9500.00,NULL,NULL,1,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(371,8081,40918,178695,2,360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',4000.00,NULL,NULL,1,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(372,8081,40918,178695,2,361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1100.00,NULL,NULL,1,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(373,8081,40918,178695,2,362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2200.00,NULL,NULL,1,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(374,8081,40918,178695,2,363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2200.00,NULL,NULL,1,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(375,8081,40918,178695,2,364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2200.00,NULL,NULL,1,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(376,8081,40918,178695,2,365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2200.00,NULL,NULL,1,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(377,8081,40918,178695,2,366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',4000.00,NULL,NULL,1,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(378,8081,40918,178695,2,367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2200.00,NULL,NULL,1,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(379,8081,40918,178695,2,368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2200.00,NULL,NULL,1,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(380,8081,40918,178695,2,369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2200.00,NULL,NULL,1,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL);
INSERT INTO `balance_libro` VALUES (381,8081,40918,178695,2,370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2200.00,NULL,NULL,1,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(382,8081,40918,178695,2,371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2200.00,NULL,NULL,1,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(383,8081,40918,178695,2,372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5000.00,NULL,NULL,1,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(384,8081,40918,178695,2,373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',12000.00,NULL,NULL,1,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(385,8081,40918,178695,2,374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',6300.00,NULL,NULL,1,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(386,8081,40918,178695,2,375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',4000.00,NULL,NULL,1,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(387,8081,40918,178695,2,376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',6000.00,NULL,NULL,1,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(388,8081,40918,178695,2,377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',4000.00,NULL,NULL,1,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(389,8081,40918,178695,2,378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',3000.00,NULL,NULL,1,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(390,8081,40918,178695,2,379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2200.00,NULL,NULL,1,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(391,8081,40918,178695,2,380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2200.00,NULL,NULL,1,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(392,8081,40918,178695,2,381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',4400.00,NULL,NULL,1,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(393,8081,40918,178695,2,382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',4000.00,NULL,NULL,1,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(394,8081,40918,178695,2,383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2200.00,NULL,NULL,1,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(395,8081,40918,178695,2,384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',3000.00,NULL,NULL,1,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(396,8081,40918,178695,2,385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',4000.00,NULL,NULL,1,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(397,8081,40918,178693,3,386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',8585.00,NULL,NULL,1,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(398,8081,40918,178693,3,387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',2498.81,NULL,NULL,1,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(399,8081,40918,178693,3,388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',23000.00,NULL,NULL,1,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(400,8081,40918,178693,3,389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',16827.11,NULL,NULL,1,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(401,8081,40918,178693,3,390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',5313.00,NULL,NULL,1,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(402,8081,40918,178694,3,391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',10987.00,NULL,NULL,1,'2022-11-30 00:26:51','2022-11-30 00:26:51',NULL),(403,8081,40918,178694,3,392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',11999.00,NULL,NULL,1,'2022-11-30 00:26:51','2022-11-30 00:26:51',NULL),(404,8081,40918,178694,3,393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1368.00,NULL,NULL,1,'2022-11-30 00:26:51','2022-11-30 00:26:51',NULL);
INSERT INTO `balance_libro` VALUES (405,8081,40918,178694,3,394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',28600.00,NULL,NULL,1,'2022-11-30 00:26:51','2022-11-30 00:26:51',NULL),(406,8081,40918,178695,3,395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',10381.00,NULL,NULL,1,'2022-11-30 00:27:17','2022-11-30 00:27:17',NULL),(407,8081,40918,178695,3,396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2150.00,NULL,NULL,1,'2022-11-30 00:27:17','2022-11-30 00:27:17',NULL),(408,8081,40918,178695,3,397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5617.41,NULL,NULL,1,'2022-11-30 00:27:17','2022-11-30 00:27:17',NULL),(409,8081,40918,178696,3,398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',11779.00,NULL,NULL,1,'2022-11-30 00:27:55','2022-11-30 00:27:55',NULL),(410,8081,40918,178696,3,399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',3510.00,NULL,NULL,1,'2022-11-30 00:27:55','2022-11-30 00:27:55',NULL),(411,8081,40918,178696,3,400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',4840.00,NULL,NULL,1,'2022-11-30 00:27:55','2022-11-30 00:27:55',NULL),(412,8081,40918,178696,3,401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',3294.30,NULL,NULL,1,'2022-11-30 00:27:55','2022-11-30 00:27:55',NULL),(413,8081,40918,178697,3,402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',10192.00,NULL,NULL,1,'2022-11-30 00:30:11','2022-11-30 00:30:11',NULL),(414,8081,40918,178697,3,403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',73000.00,NULL,NULL,1,'2022-11-30 00:30:11','2022-11-30 00:30:11',NULL),(415,8081,40918,178697,3,404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',26500.00,NULL,NULL,1,'2022-11-30 00:30:11','2022-11-30 00:30:11',NULL),(416,8081,40866,99909,3,405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',1157.00,NULL,NULL,1,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(417,8081,40866,99909,3,406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-23','2022-01-23',220.00,NULL,NULL,1,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(418,8081,40866,99909,3,407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',4194.10,NULL,NULL,1,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(419,8081,40866,99909,3,408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',585.00,NULL,NULL,1,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(420,8081,40866,99909,3,409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',23583.18,NULL,NULL,1,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(421,8081,40866,99909,3,410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',8130.27,NULL,NULL,1,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(422,8081,40866,99909,3,411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',800.00,NULL,NULL,1,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(423,8081,40866,99910,3,412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',105268.00,NULL,NULL,1,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(424,8081,40866,99910,3,413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20454.15,NULL,NULL,1,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(425,8081,40866,99910,3,414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',9600.00,NULL,NULL,1,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(426,8081,40866,99910,3,415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',25224.99,NULL,NULL,1,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(427,8081,40866,99910,3,416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',12758.06,NULL,NULL,1,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(428,8081,40866,99910,3,417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',1040.00,NULL,NULL,1,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL);
INSERT INTO `balance_libro` VALUES (429,8081,40866,99910,3,418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',10612.62,NULL,NULL,1,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(430,8081,40866,99910,3,419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',9255.62,NULL,NULL,1,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(431,8081,40866,99910,3,420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',8205.33,NULL,NULL,1,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(432,8081,40866,99910,3,421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-26','2022-02-26',800.00,NULL,NULL,1,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(433,8081,40866,99911,3,422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',10600.23,NULL,NULL,1,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(434,8081,40866,99911,3,423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',663.00,NULL,NULL,1,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(435,8081,40866,99911,3,424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',10582.96,NULL,NULL,1,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(436,8081,40866,99911,3,425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',800.00,NULL,NULL,1,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(437,8081,40866,99911,3,426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',12471.89,NULL,NULL,1,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(438,8081,40866,99912,3,427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',23413.40,NULL,NULL,1,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(439,8081,40866,99912,3,428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',23215.50,NULL,NULL,1,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(440,8081,40866,99912,3,429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',9065.55,NULL,NULL,1,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(441,8081,40866,99912,3,430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',3671.99,NULL,NULL,1,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(442,8081,40866,99912,3,431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',31388.90,NULL,NULL,1,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(443,8081,40866,99912,3,432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',18181.85,NULL,NULL,1,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(444,8081,40866,99912,3,433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',800.00,NULL,NULL,1,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(445,8081,40866,99913,3,434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',12086.29,NULL,NULL,1,'2022-11-30 01:04:45','2022-11-30 01:04:45',NULL),(446,8081,40866,99913,3,435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',6948.76,NULL,NULL,1,'2022-11-30 01:04:45','2022-11-30 01:04:45',NULL),(447,8081,40866,99913,3,436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',13638.29,NULL,NULL,1,'2022-11-30 01:04:45','2022-11-30 01:04:45',NULL),(448,8081,40866,99913,3,437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',559.00,NULL,NULL,1,'2022-11-30 01:04:45','2022-11-30 01:04:45',NULL),(449,8081,40866,99913,3,438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',990.00,NULL,NULL,1,'2022-11-30 01:04:46','2022-11-30 01:04:46',NULL),(450,8081,40866,99914,3,439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',7109.67,NULL,NULL,1,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(451,8081,40866,99914,3,440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',6599.98,NULL,NULL,1,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(452,8081,40866,99914,3,441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',15801.47,NULL,NULL,1,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(453,8081,40866,99914,3,442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',13134.84,NULL,NULL,1,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL);
INSERT INTO `balance_libro` VALUES (454,8081,40866,99914,3,443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-20','2022-06-20',71982.00,NULL,NULL,1,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(455,8081,40866,99914,3,444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-20','2022-06-20',10074.15,NULL,NULL,1,'2022-11-30 01:05:08','2022-11-30 01:05:08',NULL),(456,8081,40866,99914,3,445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',18482.12,NULL,NULL,1,'2022-11-30 01:05:08','2022-11-30 01:05:08',NULL),(457,8081,40866,99914,3,446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',13715.31,NULL,NULL,1,'2022-11-30 01:05:08','2022-11-30 01:05:08',NULL),(458,8081,40866,99914,3,447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',395.00,NULL,NULL,1,'2022-11-30 01:05:08','2022-11-30 01:05:08',NULL),(459,8081,40866,99915,3,448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',13401.99,NULL,NULL,1,'2022-11-30 01:05:39','2022-11-30 01:05:39',NULL),(460,8081,40866,99915,3,449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',750.01,NULL,NULL,1,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(461,8081,40866,99915,3,450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',29658.21,NULL,NULL,1,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(462,8081,40866,99915,3,451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',58907.05,NULL,NULL,1,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(463,8081,40866,99915,3,452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6398.60,NULL,NULL,1,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(464,8081,40866,99915,3,453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1020.00,NULL,NULL,1,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(465,8081,40866,99915,3,454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',38934.83,NULL,NULL,1,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(466,8081,40866,99915,3,455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',12870.00,NULL,NULL,1,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(467,8081,40866,99915,3,456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',740.00,NULL,NULL,1,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(468,8081,40866,99916,3,457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',9315.99,NULL,NULL,1,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(469,8081,40866,99916,3,458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-07','2022-08-07',1796.89,NULL,NULL,1,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(470,8081,40866,99916,3,459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-07','2022-08-07',26756.06,NULL,NULL,1,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(471,8081,40866,99916,3,460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-07','2022-08-07',21741.37,NULL,NULL,1,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(472,8081,40866,99916,3,461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-07','2022-08-07',5390.68,NULL,NULL,1,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(473,8081,40866,99916,3,462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',1480.00,NULL,NULL,1,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(474,8081,40866,99916,3,463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',16416.48,NULL,NULL,1,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(475,8081,40866,99916,3,464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',5999.00,NULL,NULL,1,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(476,8081,40866,99916,3,465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',35889.11,NULL,NULL,1,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(477,8081,40866,99916,3,466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',9038.99,NULL,NULL,1,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL);
INSERT INTO `balance_libro` VALUES (478,8081,40866,99917,3,467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',7043.50,NULL,NULL,1,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(479,8081,40866,99917,3,468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',515.16,NULL,NULL,1,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(480,8081,40866,99917,3,469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',716.00,NULL,NULL,1,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(481,8081,40866,99917,3,470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',8748.01,NULL,NULL,1,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(482,8081,40866,99917,3,471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',21642.73,NULL,NULL,1,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(483,8081,40866,99917,3,472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',21684.35,NULL,NULL,1,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(484,8081,40866,99917,3,473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',24728.04,NULL,NULL,1,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(485,8081,40866,99917,3,474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',10458.02,NULL,NULL,1,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(487,8081,40771,48403,2,476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',1000.00,NULL,NULL,1,'2022-11-30 20:33:09','2022-11-30 20:33:09',NULL),(488,8081,40771,48403,2,477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',1300.00,NULL,NULL,1,'2022-11-30 20:33:09','2022-11-30 20:33:09',NULL),(489,8081,40771,48403,2,478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',1800.00,NULL,NULL,1,'2022-11-30 20:33:09','2022-11-30 20:33:09',NULL),(490,8081,40771,48403,2,479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',1000.00,NULL,NULL,1,'2022-11-30 20:33:09','2022-11-30 20:33:09',NULL),(491,8081,40771,48403,2,480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',1000.00,NULL,NULL,1,'2022-11-30 20:33:09','2022-11-30 20:33:09',NULL),(492,8081,40771,48403,2,481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',1000.00,NULL,NULL,1,'2022-11-30 20:33:09','2022-11-30 20:33:09',NULL),(493,8081,40771,48402,3,482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',8300.00,NULL,NULL,1,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(494,8081,40771,48402,3,483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',3480.00,NULL,NULL,1,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(495,8081,40771,48402,3,484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',1040.65,NULL,NULL,1,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(496,8081,40771,48402,3,485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',10925.00,NULL,NULL,1,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(497,8081,40771,48402,3,486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',8725.00,NULL,NULL,1,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(498,8081,40771,48402,3,487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',1710.00,NULL,NULL,1,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(499,8081,40771,48403,3,488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',3700.00,NULL,NULL,1,'2022-11-30 20:43:34','2022-11-30 20:43:34',NULL),(500,8081,40771,48403,3,489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',11250.00,NULL,NULL,1,'2022-11-30 20:43:34','2022-11-30 20:43:34',NULL),(501,8081,40771,48403,3,490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',6500.00,NULL,NULL,1,'2022-11-30 20:43:34','2022-11-30 20:43:34',NULL),(502,8081,40771,48403,3,491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',8175.00,NULL,NULL,1,'2022-11-30 20:43:34','2022-11-30 20:43:34',NULL),(503,8081,40771,48404,3,492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',4155.00,NULL,NULL,1,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL);
INSERT INTO `balance_libro` VALUES (504,8081,40771,48404,3,493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',5200.00,NULL,NULL,1,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(505,8081,40771,48404,3,494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',4000.00,NULL,NULL,1,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(506,8081,40771,48404,3,495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',10875.00,NULL,NULL,1,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(507,8081,40771,48404,3,496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',3900.00,NULL,NULL,1,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(508,8081,40771,48404,3,497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',13875.00,NULL,NULL,1,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(509,8081,40771,48405,3,498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',4300.00,NULL,NULL,1,'2022-11-30 20:44:42','2022-11-30 20:44:42',NULL),(510,8081,40771,48405,3,499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',9000.00,NULL,NULL,1,'2022-11-30 20:44:42','2022-11-30 20:44:42',NULL),(511,8081,40771,48405,3,500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',10475.00,NULL,NULL,1,'2022-11-30 20:44:42','2022-11-30 20:44:42',NULL),(512,8081,40771,48406,3,501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',6000.00,NULL,NULL,1,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(513,8081,40771,48406,3,502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',449.30,NULL,NULL,1,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(514,8081,40771,48406,3,503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',63999.01,NULL,NULL,1,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(515,8081,40771,48406,3,504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',621.97,NULL,NULL,1,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(516,8081,40771,48406,3,505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',2397.00,NULL,NULL,1,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(517,8081,40771,48406,3,506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',12750.00,NULL,NULL,1,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(518,8081,40771,48406,3,507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',5000.00,NULL,NULL,1,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(519,8081,40771,48407,3,508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',4599.00,NULL,NULL,1,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(520,8081,40771,48407,3,509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',5900.00,NULL,NULL,1,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(521,8081,40771,48407,3,510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',1639.47,NULL,NULL,1,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(522,8081,40771,48407,3,511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',2000.00,NULL,NULL,1,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(523,8081,40771,48407,3,512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',15270.00,NULL,NULL,1,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(524,8081,40771,48407,3,513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-20','2022-06-20',5000.00,NULL,NULL,1,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(525,8081,40771,48407,3,514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',4000.00,NULL,NULL,1,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(526,8081,40771,48407,3,515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3000.00,NULL,NULL,1,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(527,8081,40771,48408,3,516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',17470.00,NULL,NULL,1,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL),(528,8081,40771,48408,3,517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',14624.21,NULL,NULL,1,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL);
INSERT INTO `balance_libro` VALUES (529,8081,40771,48408,3,518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',6156.59,NULL,NULL,1,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL),(530,8081,40771,48408,3,519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',3500.00,NULL,NULL,1,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL),(531,8081,40771,48408,3,520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',15564.88,NULL,NULL,1,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL),(532,8081,40771,48408,3,521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1000.00,NULL,NULL,1,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL),(533,8081,40771,48409,3,522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',15470.00,NULL,NULL,1,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(534,8081,40771,48409,3,523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',79.00,NULL,NULL,1,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(535,8081,40771,48409,3,524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',3500.00,NULL,NULL,1,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(536,8081,40771,48409,3,525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',1207.92,NULL,NULL,1,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(537,8081,40771,48409,3,526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',8500.00,NULL,NULL,1,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(538,8081,40771,48409,3,527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',4000.00,NULL,NULL,1,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(539,8081,40771,48409,3,528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',3000.00,NULL,NULL,1,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(540,8081,40771,48409,3,529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',16374.00,NULL,NULL,1,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(541,8081,40771,48410,3,530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',3300.00,NULL,NULL,1,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(542,8081,40771,48410,3,531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',79.00,NULL,NULL,1,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(543,8081,40771,48410,3,532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',6000.00,NULL,NULL,1,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(544,8081,40771,48410,3,533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',2001.07,NULL,NULL,1,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(545,8081,40771,48410,3,534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',7900.00,NULL,NULL,1,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(546,8081,40771,48410,3,535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',22125.00,NULL,NULL,1,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(547,8081,40771,48410,3,536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',5000.00,NULL,NULL,1,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(548,8081,40771,48410,3,537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',8000.00,NULL,NULL,1,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(549,8081,40771,48410,3,538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',19950.00,NULL,NULL,1,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(550,8081,40771,48411,3,539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',3500.00,NULL,NULL,1,'2022-11-30 20:48:15','2022-11-30 20:48:15',NULL),(551,8081,40771,48411,3,540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1447.00,NULL,NULL,1,'2022-11-30 20:48:15','2022-11-30 20:48:15',NULL),(552,8081,40771,48411,3,541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1770.61,NULL,NULL,1,'2022-11-30 20:48:15','2022-11-30 20:48:15',NULL),(553,8081,40771,48411,3,542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',21650.00,NULL,NULL,1,'2022-11-30 20:48:15','2022-11-30 20:48:15',NULL);
INSERT INTO `balance_libro` VALUES (554,8081,40771,48411,3,543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',4000.00,NULL,NULL,1,'2022-11-30 20:48:15','2022-11-30 20:48:15',NULL),(555,8081,40943,216569,2,544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',150.00,NULL,NULL,1,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(556,8081,40943,216569,2,545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',150.00,NULL,NULL,1,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(557,8081,40943,216569,2,546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',11350.00,NULL,NULL,1,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(558,8081,40943,216569,2,547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',150.00,NULL,NULL,1,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(559,8081,40943,216569,2,548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',45250.00,NULL,NULL,1,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(560,8081,40943,216569,2,549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',1350.00,NULL,NULL,1,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(561,8081,40943,216569,2,550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',1600.00,NULL,NULL,1,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(562,8081,40943,216569,2,551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',3050.00,NULL,NULL,1,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(563,8081,40943,216569,2,552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',14400.00,NULL,NULL,1,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(564,8081,40943,216569,2,553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',950.00,NULL,NULL,1,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(565,8081,40943,216569,2,554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',180000.00,NULL,NULL,1,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(566,8081,40943,216570,2,555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2400.00,NULL,NULL,1,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(567,8081,40943,216570,2,556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',3600.00,NULL,NULL,1,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(568,8081,40943,216570,2,557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',100000.00,NULL,NULL,1,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(569,8081,40943,216570,2,558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',320.00,NULL,NULL,1,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(570,8081,40943,216570,2,559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',1300.00,NULL,NULL,1,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(571,8081,40943,216570,2,560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',25220.00,NULL,NULL,1,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(572,8081,40943,216570,2,561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1080.00,NULL,NULL,1,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(573,8081,40943,216570,2,562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',2340.00,NULL,NULL,1,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(574,8081,40943,216570,2,563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',75000.00,NULL,NULL,1,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(575,8081,40943,216570,2,564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4080.00,NULL,NULL,1,'2022-11-30 21:37:28','2022-11-30 21:37:28',NULL),(576,8081,40943,216570,2,565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',3791.00,NULL,NULL,1,'2022-11-30 21:37:28','2022-11-30 21:37:28',NULL),(577,8081,40943,216570,2,566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',37310.00,NULL,NULL,1,'2022-11-30 21:37:28','2022-11-30 21:37:28',NULL);
INSERT INTO `balance_libro` VALUES (578,8081,40943,216570,2,567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',3700.00,NULL,NULL,1,'2022-11-30 21:37:28','2022-11-30 21:37:28',NULL),(579,8081,40943,216572,2,568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',3575.00,NULL,NULL,1,'2022-11-30 21:47:55','2022-11-30 21:47:55',NULL),(580,8081,40943,216572,2,569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',2700.00,NULL,NULL,1,'2022-11-30 21:47:55','2022-11-30 21:47:55',NULL),(581,8081,40943,216572,2,570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',6000.00,NULL,NULL,1,'2022-11-30 21:47:55','2022-11-30 21:47:55',NULL),(582,8081,40943,216572,2,571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',1950.00,NULL,NULL,1,'2022-11-30 21:47:55','2022-11-30 21:47:55',NULL),(583,8081,40943,216572,2,572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',5940.00,NULL,NULL,1,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(584,8081,40943,216572,2,573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',890.00,NULL,NULL,1,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(585,8081,40943,216572,2,574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',15000.00,NULL,NULL,1,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(586,8081,40943,216572,2,575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',20000.00,NULL,NULL,1,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(587,8081,40943,216572,2,576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',3504.00,NULL,NULL,1,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(588,8081,40943,216572,2,577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',2500.00,NULL,NULL,1,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(589,8081,40943,216572,2,578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',3575.00,NULL,NULL,1,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(590,8081,40943,216572,2,579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',3640.00,NULL,NULL,1,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(591,8081,40943,216572,2,580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1900.00,NULL,NULL,1,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(592,8081,40943,216569,3,581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',990.00,NULL,NULL,1,'2022-11-30 21:49:32','2022-11-30 21:49:32',NULL),(593,8081,40943,216569,3,582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',4008.00,NULL,NULL,1,'2022-11-30 21:49:32','2022-11-30 21:49:32',NULL),(594,8081,40943,216570,3,583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4270.00,NULL,NULL,1,'2022-11-30 21:49:58','2022-11-30 21:49:58',NULL),(595,8081,40943,216570,3,584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',756.29,NULL,NULL,1,'2022-11-30 21:49:58','2022-11-30 21:49:58',NULL),(596,8081,40943,216570,3,585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',3579.21,NULL,NULL,1,'2022-11-30 21:49:58','2022-11-30 21:49:58',NULL),(597,8081,40943,216570,3,586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',444.94,NULL,NULL,1,'2022-11-30 21:49:58','2022-11-30 21:49:58',NULL),(598,8081,40943,216571,3,587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',2147.21,NULL,NULL,1,'2022-11-30 21:50:16','2022-11-30 21:50:16',NULL),(599,8081,40943,216571,3,588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',5470.00,NULL,NULL,1,'2022-11-30 21:50:16','2022-11-30 21:50:16',NULL),(600,8081,40943,216572,3,589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',3838.36,NULL,NULL,1,'2022-11-30 21:50:35','2022-11-30 21:50:35',NULL),(601,8081,40866,99912,2,590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-03','2022-04-03',24370.00,NULL,NULL,1,'2022-11-30 22:05:37','2022-11-30 22:05:37',NULL);
INSERT INTO `balance_libro` VALUES (602,8081,40866,99912,2,591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-03','2022-04-03',380.00,NULL,NULL,1,'2022-11-30 22:05:37','2022-11-30 22:05:37',NULL),(603,8081,40866,99912,2,592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',13612.00,NULL,NULL,1,'2022-11-30 22:05:37','2022-11-30 22:05:37',NULL),(604,8081,40866,99912,2,593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',18107.50,NULL,NULL,1,'2022-11-30 22:05:37','2022-11-30 22:05:37',NULL),(605,8081,40866,99912,2,594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',20695.00,NULL,NULL,1,'2022-11-30 22:05:37','2022-11-30 22:05:37',NULL),(606,8081,40866,99912,2,595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-15','2022-04-15',14830.00,NULL,NULL,1,'2022-11-30 22:05:37','2022-11-30 22:05:37',NULL),(607,8081,40866,99912,2,596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',15354.00,NULL,NULL,1,'2022-11-30 22:05:37','2022-11-30 22:05:37',NULL),(608,8081,40866,99912,2,597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',13432.00,NULL,NULL,1,'2022-11-30 22:05:38','2022-11-30 22:05:38',NULL),(609,8081,40866,99912,2,598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',17292.00,NULL,NULL,1,'2022-11-30 22:05:38','2022-11-30 22:05:38',NULL),(610,8081,40866,99912,2,599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',9300.00,NULL,NULL,1,'2022-11-30 22:05:38','2022-11-30 22:05:38',NULL),(611,8081,40866,99912,2,600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',12808.00,NULL,NULL,1,'2022-11-30 22:05:38','2022-11-30 22:05:38',NULL),(612,8081,40866,99913,2,601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',15550.00,NULL,NULL,1,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(613,8081,40866,99913,2,602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',15000.00,NULL,NULL,1,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(614,8081,40866,99913,2,603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',12065.00,NULL,NULL,1,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(615,8081,40866,99913,2,604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',17230.00,NULL,NULL,1,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(616,8081,40866,99913,2,605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',21257.00,NULL,NULL,1,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(617,8081,40866,99913,2,606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',8895.00,NULL,NULL,1,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(618,8081,40866,99913,2,607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',8567.00,NULL,NULL,1,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(619,8081,40866,99914,2,608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',12150.00,NULL,NULL,1,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(620,8081,40866,99914,2,609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',9325.00,NULL,NULL,1,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(621,8081,40866,99914,2,610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',9600.00,NULL,NULL,1,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(622,8081,40866,99914,2,611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',10175.00,NULL,NULL,1,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(623,8081,40866,99914,2,612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',4050.00,NULL,NULL,1,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(624,8081,40866,99914,2,613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',3950.00,NULL,NULL,1,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(625,8081,40866,99914,2,614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',5708.00,NULL,NULL,1,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL);
INSERT INTO `balance_libro` VALUES (626,8081,40866,99914,2,615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',2800.00,NULL,NULL,1,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(627,8081,40866,99914,2,616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',15200.00,NULL,NULL,1,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(628,8081,40866,99914,2,617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',9800.00,NULL,NULL,1,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(629,8081,40866,99914,2,618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',11480.00,NULL,NULL,1,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(630,8081,40866,99914,2,619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',7820.00,NULL,NULL,1,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(631,8081,40866,99914,2,620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',12900.00,NULL,NULL,1,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(632,8081,40866,99914,2,621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',13330.00,NULL,NULL,1,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(633,8081,40866,99914,2,622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',15200.00,NULL,NULL,1,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(634,8081,40866,99915,2,623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',13490.00,NULL,NULL,1,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(635,8081,40866,99915,2,624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',19050.00,NULL,NULL,1,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(636,8081,40866,99915,2,625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',19050.00,NULL,NULL,1,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(637,8081,40866,99915,2,626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',17455.00,NULL,NULL,1,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(638,8081,40866,99915,2,627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',15625.00,NULL,NULL,1,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(639,8081,40866,99915,2,628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',9375.00,NULL,NULL,1,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(640,8081,40866,99915,2,629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',6500.00,NULL,NULL,1,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(641,8081,40866,99915,2,630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',6700.00,NULL,NULL,1,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(642,8081,40866,99915,2,631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',7400.00,NULL,NULL,1,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(643,8081,40866,99915,2,632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6200.00,NULL,NULL,1,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(644,8081,40866,99915,2,633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',12330.00,NULL,NULL,1,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(645,8081,40866,99915,2,634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',8200.00,NULL,NULL,1,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(646,8081,40866,99916,2,635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',10300.00,NULL,NULL,1,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(647,8081,40866,99916,2,636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',12700.00,NULL,NULL,1,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(648,8081,40866,99916,2,637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',9200.00,NULL,NULL,1,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(649,8081,40866,99916,2,638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',8700.00,NULL,NULL,1,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL);
INSERT INTO `balance_libro` VALUES (650,8081,40866,99916,2,639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',16500.00,NULL,NULL,1,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(651,8081,40866,99916,2,640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',15700.00,NULL,NULL,1,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(652,8081,40866,99916,2,641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',16730.00,NULL,NULL,1,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(653,8081,40866,99916,2,642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',19600.00,NULL,NULL,1,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(654,8081,40866,99916,2,643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',20080.00,NULL,NULL,1,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(655,8081,40866,99916,2,644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-14','2022-08-14',20800.00,NULL,NULL,1,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(656,8081,40866,99916,2,645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',14000.00,NULL,NULL,1,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(657,8081,40866,99916,2,646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',16500.00,NULL,NULL,1,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(658,8081,40866,99916,2,647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',17770.00,NULL,NULL,1,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(659,8081,40866,99916,2,648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',7260.00,NULL,NULL,1,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(660,8081,40866,99916,2,649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',13600.00,NULL,NULL,1,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(661,8081,40866,99916,2,650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',15660.00,NULL,NULL,1,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(662,8081,40866,99916,2,651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',10600.00,NULL,NULL,1,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(663,8081,40866,99916,2,652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',6180.00,NULL,NULL,1,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(664,8081,40866,99917,2,653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',13470.00,NULL,NULL,1,'2022-12-06 22:40:49','2022-12-06 22:40:49',NULL),(665,8081,40866,99917,2,654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',11700.00,NULL,NULL,1,'2022-12-06 22:40:49','2022-12-06 22:40:49',NULL),(666,8081,40866,99917,2,655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',12290.00,NULL,NULL,1,'2022-12-06 22:40:49','2022-12-06 22:40:49',NULL),(667,8081,40866,99917,2,656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',6650.00,NULL,NULL,1,'2022-12-06 22:40:49','2022-12-06 22:40:49',NULL),(668,8081,40866,99917,2,657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',6300.00,NULL,NULL,1,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(669,8081,40866,99917,2,658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',18200.00,NULL,NULL,1,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(670,8081,40866,99917,2,659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',9000.00,NULL,NULL,1,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(671,8081,40866,99917,2,660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',9000.00,NULL,NULL,1,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(672,8081,40866,99917,2,661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',11750.00,NULL,NULL,1,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(673,8081,40866,99917,2,662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',7340.00,NULL,NULL,1,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL);
INSERT INTO `balance_libro` VALUES (674,8081,40866,99917,2,663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',17550.00,NULL,NULL,1,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(675,8081,40866,99917,2,664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',6900.00,NULL,NULL,1,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(676,8081,40866,99917,2,665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',17380.00,NULL,NULL,1,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(677,8081,40866,99917,2,666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',12900.00,NULL,NULL,1,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(678,8081,40866,99917,2,667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',8500.00,NULL,NULL,1,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(679,8081,40866,99917,2,668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',13000.00,NULL,NULL,1,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(680,8081,40866,99917,2,669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',6900.00,NULL,NULL,1,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(681,8081,40866,99917,2,670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',8340.00,NULL,NULL,1,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(682,8081,40866,99918,2,671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',12100.00,NULL,NULL,1,'2022-12-06 22:50:25','2022-12-06 22:50:25',NULL),(683,8081,40866,99918,2,672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',13000.00,NULL,NULL,1,'2022-12-06 22:50:25','2022-12-06 22:50:25',NULL),(684,8081,40866,99918,2,673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',13300.00,NULL,NULL,1,'2022-12-06 22:50:25','2022-12-06 22:50:25',NULL),(685,8081,40866,99918,2,674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',7500.00,NULL,NULL,1,'2022-12-06 22:50:25','2022-12-06 22:50:25',NULL),(686,8081,40866,99918,2,675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-09','2022-10-09',8340.00,NULL,NULL,1,'2022-12-06 22:50:25','2022-12-06 22:50:25',NULL),(687,8081,40866,99918,2,676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-09','2022-10-09',5450.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(688,8081,40866,99918,2,677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',8400.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(689,8081,40866,99918,2,678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',5070.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(690,8081,40866,99918,2,679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',6800.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(691,8081,40866,99918,2,680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',7540.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(692,8081,40866,99918,2,681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',11200.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(693,8081,40866,99918,2,682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',9600.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(694,8081,40866,99918,2,683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',9600.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(695,8081,40866,99918,2,684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',7500.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(696,8081,40866,99918,2,685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',8600.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(697,8081,40866,99918,2,686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',7900.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL);
INSERT INTO `balance_libro` VALUES (698,8081,40866,99918,2,687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',9100.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(699,8081,40866,99918,2,688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',9200.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(700,8081,40866,99918,2,689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',6900.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(701,8081,40866,99918,2,690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',7700.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(702,8081,40866,99918,2,691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',5600.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(703,8081,40866,99918,2,692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',10400.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(704,8081,40866,99918,2,693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',5130.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(705,8081,40866,99918,2,694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',9340.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(706,8081,40866,99918,2,695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',6350.00,NULL,NULL,1,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(707,8081,40918,178699,2,696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3000.00,NULL,NULL,1,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(708,8081,40918,178699,2,697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3000.00,NULL,NULL,1,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(709,8081,40918,178699,2,698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3200.00,NULL,NULL,1,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(710,8081,40918,178699,2,699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3000.00,NULL,NULL,1,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(711,8081,40918,178699,2,700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3000.00,NULL,NULL,1,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(712,8081,40918,178699,2,701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3000.00,NULL,NULL,1,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(713,8081,40918,178699,2,702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3000.00,NULL,NULL,1,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(714,8081,40918,178699,2,703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3000.00,NULL,NULL,1,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(715,8081,40918,178699,2,704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3000.00,NULL,NULL,1,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(716,8081,40918,178699,2,705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',7500.00,NULL,NULL,1,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(717,8081,40918,178699,2,706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',13000.00,NULL,NULL,1,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(718,8081,40918,178699,2,707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3000.00,NULL,NULL,1,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(719,8081,40918,178699,2,708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3000.00,NULL,NULL,1,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(720,8081,40918,178699,2,709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3000.00,NULL,NULL,1,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(721,8081,40918,178699,2,710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5500.00,NULL,NULL,1,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL);
INSERT INTO `balance_libro` VALUES (722,8081,40918,178699,2,711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3000.00,NULL,NULL,1,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(723,8081,40918,178699,2,712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',4500.00,NULL,NULL,1,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(724,8081,40918,178699,2,713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5500.00,NULL,NULL,1,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(725,8081,40918,178699,2,714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3000.00,NULL,NULL,1,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(726,8081,40918,178699,2,715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3000.00,NULL,NULL,1,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(727,8081,40918,178699,2,716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3000.00,NULL,NULL,1,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(728,8081,40918,178699,2,717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3000.00,NULL,NULL,1,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(729,8081,40918,178699,2,718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3000.00,NULL,NULL,1,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(730,8081,40918,178699,2,719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',11500.00,NULL,NULL,1,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(731,8081,40918,178699,2,720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',10000.00,NULL,NULL,1,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(732,8081,40918,178698,3,721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',11367.00,NULL,NULL,1,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL),(733,8081,40918,178698,3,722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',6050.00,NULL,NULL,1,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL),(734,8081,40918,178698,3,723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1582.08,NULL,NULL,1,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL),(735,8081,40918,178698,3,724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',190.00,NULL,NULL,1,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL),(736,8081,40918,178698,3,725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',18802.00,NULL,NULL,1,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL),(737,8081,40918,178699,3,726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',11367.00,NULL,NULL,1,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(738,8081,40918,178699,3,727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',10590.00,NULL,NULL,1,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(739,8081,40918,178699,3,728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',56999.00,NULL,NULL,1,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(740,8081,40918,178699,3,729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',4300.00,NULL,NULL,1,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(741,8081,40918,178699,3,730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',3614.99,NULL,NULL,1,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(742,8081,40918,178699,3,731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',1405.94,NULL,NULL,1,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(743,8081,40731,9028,2,732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',3485.96,NULL,NULL,1,'2022-12-07 15:05:58','2022-12-07 15:05:58',NULL),(744,8081,40731,9028,2,733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',1937.00,NULL,NULL,1,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(745,8081,40731,9028,2,734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',72000.00,NULL,NULL,1,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL);
INSERT INTO `balance_libro` VALUES (746,8081,40731,9028,2,735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',90000.00,NULL,NULL,1,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(747,8081,40731,9028,2,736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',19220.00,NULL,NULL,1,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(748,8081,40731,9028,2,737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',53000.00,NULL,NULL,1,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(749,8081,40731,9028,2,738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',63437.00,NULL,NULL,1,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(750,8081,40731,9028,2,739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',21000.00,NULL,NULL,1,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(751,8081,40731,9028,2,740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',15000.00,NULL,NULL,1,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(752,8081,40731,9028,2,741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',46647.00,NULL,NULL,1,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(753,8081,40731,9028,2,742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',8000.00,NULL,NULL,1,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(754,8081,40731,9028,3,743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',11.68,NULL,NULL,1,'2022-12-07 15:06:39','2022-12-07 15:06:39',NULL),(755,8081,40731,9028,3,744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',5647.83,NULL,NULL,1,'2022-12-07 15:06:39','2022-12-10 22:03:42','2022-12-10 22:03:42'),(756,8081,40731,9028,3,745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',26148.37,NULL,NULL,1,'2022-12-07 15:06:40','2022-12-10 22:03:00','2022-12-10 22:03:00'),(757,8081,40731,9028,3,746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',37047.08,NULL,NULL,1,'2022-12-07 15:06:40','2022-12-10 22:07:25','2022-12-10 22:07:25'),(758,8081,40731,9028,3,747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',37059.16,NULL,NULL,1,'2022-12-07 15:06:40','2022-12-10 22:04:16','2022-12-10 22:04:16'),(759,8081,40731,9028,3,748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',703.46,NULL,NULL,1,'2022-12-07 15:06:40','2022-12-10 22:04:48','2022-12-10 22:04:48'),(760,8081,40731,9028,3,749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',51003.95,NULL,NULL,1,'2022-12-07 15:06:40','2022-12-10 22:05:19','2022-12-10 22:05:19'),(761,8081,40731,9028,3,750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',750.27,NULL,NULL,1,'2022-12-07 15:06:40','2022-12-10 22:07:53','2022-12-10 22:07:53'),(762,8081,40731,9028,3,751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',11030.00,NULL,NULL,1,'2022-12-07 15:06:40','2022-12-07 15:06:40',NULL),(763,8081,40731,9028,3,752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',513.39,NULL,NULL,1,'2022-12-07 15:06:40','2022-12-07 15:06:40',NULL),(764,8081,40731,9028,3,753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',55381.38,NULL,NULL,1,'2022-12-07 15:06:40','2022-12-10 22:05:51','2022-12-10 22:05:51'),(765,8081,40731,9028,3,754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',23038.53,NULL,NULL,1,'2022-12-07 15:06:40','2022-12-10 22:06:18','2022-12-10 22:06:18'),(766,8081,40731,9028,3,755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',32477.39,NULL,NULL,1,'2022-12-07 15:06:40','2022-12-10 22:06:54','2022-12-10 22:06:54'),(767,8081,40997,263531,2,756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-20','2022-06-20',5000.00,NULL,NULL,1,'2022-12-07 15:12:02','2022-12-07 15:12:02',NULL),(768,8081,40997,263531,2,757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',5000.00,NULL,NULL,1,'2022-12-07 15:12:02','2022-12-07 15:12:02',NULL),(769,8081,40997,263531,2,758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3000.00,NULL,NULL,1,'2022-12-07 15:12:02','2022-12-07 15:12:02',NULL);
INSERT INTO `balance_libro` VALUES (770,8081,40997,263532,2,759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',3500.00,NULL,NULL,1,'2022-12-07 15:12:26','2022-12-07 15:12:26',NULL),(771,8081,40997,263532,2,760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',8000.00,NULL,NULL,1,'2022-12-07 15:12:26','2022-12-07 15:12:26',NULL),(772,8081,40997,263532,2,761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6500.00,NULL,NULL,1,'2022-12-07 15:12:26','2022-12-07 15:12:26',NULL),(773,8081,40997,263533,2,762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',2200.00,NULL,NULL,1,'2022-12-07 15:13:12','2022-12-07 15:13:12',NULL),(774,8081,40997,263533,2,763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',6550.14,NULL,NULL,1,'2022-12-07 15:13:12','2022-12-07 15:13:12',NULL),(775,8081,40997,263534,2,764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',6000.00,NULL,NULL,1,'2022-12-07 15:13:31','2022-12-07 15:13:31',NULL),(776,8081,40997,263534,2,765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',3000.00,NULL,NULL,1,'2022-12-07 15:13:31','2022-12-07 15:13:31',NULL),(777,8081,40997,263534,2,766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',6000.00,NULL,NULL,1,'2022-12-07 15:13:31','2022-12-07 15:13:31',NULL),(778,8081,40997,263534,2,767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',5500.00,NULL,NULL,1,'2022-12-07 15:13:31','2022-12-07 15:13:31',NULL),(779,8081,40997,263534,2,768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',6500.00,NULL,NULL,1,'2022-12-07 15:13:32','2022-12-07 15:13:32',NULL),(780,8081,40997,263535,2,769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',3500.00,NULL,NULL,1,'2022-12-07 15:14:10','2022-12-07 15:14:10',NULL),(781,8081,40997,263535,2,770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',6000.00,NULL,NULL,1,'2022-12-07 15:14:10','2022-12-07 15:14:10',NULL),(782,8081,40997,263535,2,771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',9000.00,NULL,NULL,1,'2022-12-07 15:14:10','2022-12-07 15:14:10',NULL),(783,8081,40997,263535,2,772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4000.00,NULL,NULL,1,'2022-12-07 15:14:10','2022-12-07 15:14:10',NULL),(784,8081,40997,263536,2,773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',7000.00,NULL,NULL,1,'2022-12-07 15:14:30','2022-12-07 15:14:30',NULL),(785,8081,40997,263536,2,774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',10000.00,NULL,NULL,1,'2022-12-07 15:14:30','2022-12-07 15:14:30',NULL),(786,8081,40997,263536,2,775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',6000.00,NULL,NULL,1,'2022-12-07 15:14:30','2022-12-07 15:14:30',NULL),(787,8081,40997,263536,2,776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',7000.00,NULL,NULL,1,'2022-12-07 15:14:30','2022-12-07 15:14:30',NULL),(788,8081,40997,263532,3,777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',18068.87,NULL,NULL,1,'2022-12-07 15:15:42','2022-12-07 15:15:42',NULL),(789,8081,40997,263532,3,778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5404.00,NULL,NULL,1,'2022-12-07 15:15:43','2022-12-07 15:15:43',NULL),(790,8081,40997,263532,3,779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',299.00,NULL,NULL,1,'2022-12-07 15:15:43','2022-12-07 15:15:43',NULL),(791,8081,40997,263532,3,780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',3339.73,NULL,NULL,1,'2022-12-07 15:15:43','2022-12-07 15:15:43',NULL),(792,8081,40997,263534,3,781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',50.00,NULL,NULL,1,'2022-12-07 15:17:04','2022-12-07 15:17:04',NULL),(793,8081,40997,263534,3,782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',2502.00,NULL,NULL,1,'2022-12-07 15:17:04','2022-12-07 15:17:04',NULL);
INSERT INTO `balance_libro` VALUES (794,8081,40997,263535,3,783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',136.00,NULL,NULL,1,'2022-12-07 15:17:24','2022-12-07 15:17:24',NULL),(795,8081,40997,263535,3,784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',960.00,NULL,NULL,1,'2022-12-07 15:17:24','2022-12-07 15:17:24',NULL),(796,8081,40997,263536,3,785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4170.24,NULL,NULL,1,'2022-12-07 15:18:01','2022-12-07 15:18:01',NULL),(797,8081,40997,263536,3,786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2700.00,NULL,NULL,1,'2022-12-07 15:18:01','2022-12-07 15:18:01',NULL),(798,8081,40943,216573,2,787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1800.00,NULL,NULL,1,'2022-12-07 16:08:19','2022-12-07 16:08:19',NULL),(799,8081,40943,216573,2,788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',16420.00,NULL,NULL,1,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(800,8081,40943,216573,2,789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',12840.00,NULL,NULL,1,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(801,8081,40943,216573,2,790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',10980.00,NULL,NULL,1,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(802,8081,40943,216573,2,791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2050.00,NULL,NULL,1,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(803,8081,40943,216573,2,792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',12750.00,NULL,NULL,1,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(804,8081,40943,216573,2,793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',12045.00,NULL,NULL,1,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(805,8081,40943,216573,2,794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',5000.00,NULL,NULL,1,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(806,8081,40943,216573,2,795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',149000.00,NULL,NULL,1,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(807,8081,40943,216574,2,796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',6810.00,NULL,NULL,1,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(808,8081,40943,216574,2,797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',49000.00,NULL,NULL,1,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(809,8081,40943,216574,2,798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',5175.00,NULL,NULL,1,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(810,8081,40943,216574,2,799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',11080.00,NULL,NULL,1,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(811,8081,40943,216574,2,800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',12800.00,NULL,NULL,1,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(812,8081,40943,216574,2,801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',12800.00,NULL,NULL,1,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(813,8081,40943,216574,2,802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4800.00,NULL,NULL,1,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(814,8081,40943,216574,2,803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',2600.00,NULL,NULL,1,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(815,8081,40943,216574,2,804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',5760.00,NULL,NULL,1,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(816,8081,40943,216574,2,805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',13600.00,NULL,NULL,1,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(817,8081,40943,216574,2,806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2500.00,NULL,NULL,1,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL);
INSERT INTO `balance_libro` VALUES (818,8081,40943,216573,3,807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',2810.40,NULL,NULL,1,'2022-12-07 16:10:32','2022-12-07 16:10:32',NULL),(819,8081,40943,216573,3,808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',51202.08,NULL,NULL,1,'2022-12-07 16:10:32','2022-12-07 16:10:32',NULL),(820,8081,40943,216573,3,809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42068.94,NULL,NULL,1,'2022-12-07 16:10:32','2022-12-07 16:10:32',NULL),(821,8081,40943,216574,3,810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',2171.90,NULL,NULL,1,'2022-12-07 16:10:51','2022-12-07 16:10:51',NULL),(822,8081,40943,216574,3,811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',14919.30,NULL,NULL,1,'2022-12-07 16:10:51','2022-12-07 16:10:51',NULL),(823,8081,40943,216574,3,812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1455.00,NULL,NULL,1,'2022-12-07 16:10:51','2022-12-07 16:10:51',NULL),(824,8081,41068,293828,2,813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',10000.00,NULL,NULL,1,'2022-12-07 16:12:48','2022-12-07 16:12:48',NULL),(825,8081,41068,293828,2,814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',11000.00,NULL,NULL,1,'2022-12-07 16:12:48','2022-12-07 16:12:48',NULL),(826,8081,41068,293828,2,815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',16000.00,NULL,NULL,1,'2022-12-07 16:12:48','2022-12-07 16:12:48',NULL),(827,8081,41068,293828,2,816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',20000.00,NULL,NULL,1,'2022-12-07 16:12:48','2022-12-07 16:12:48',NULL),(828,8081,41068,293828,2,817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',20000.00,NULL,NULL,1,'2022-12-07 16:12:48','2022-12-07 16:12:48',NULL),(829,8081,40720,296865,2,818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',55000.00,NULL,NULL,1,'2022-12-09 16:04:30','2022-12-09 16:04:30',NULL),(830,8081,40720,296865,2,819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',160000.00,NULL,NULL,1,'2022-12-09 16:04:30','2022-12-09 16:04:30',NULL),(831,8081,40720,296866,2,820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',100.00,NULL,NULL,1,'2022-12-09 16:07:36','2022-12-09 16:07:36',NULL),(832,8081,40720,296866,2,821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',108500.00,NULL,NULL,1,'2022-12-09 16:07:36','2022-12-09 16:07:36',NULL),(833,8081,40720,296866,2,822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',110000.00,NULL,NULL,1,'2022-12-09 16:07:36','2022-12-09 16:07:36',NULL),(834,8081,40720,296865,3,823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',800.00,NULL,NULL,1,'2022-12-09 16:09:07','2022-12-09 16:09:07',NULL),(835,8081,40720,296865,3,824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',697.11,NULL,NULL,1,'2022-12-09 16:09:07','2022-12-09 16:09:07',NULL),(836,8081,40720,296865,3,825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',671.30,NULL,NULL,1,'2022-12-09 16:09:07','2022-12-09 16:09:07',NULL),(837,8081,40720,296865,3,826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',800.00,NULL,NULL,1,'2022-12-09 16:09:07','2022-12-09 16:09:07',NULL),(838,8081,40720,296865,3,827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',500.00,NULL,NULL,1,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(839,8081,40720,296865,3,828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',563.20,NULL,NULL,1,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(840,8081,40720,296865,3,829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',800.00,NULL,NULL,1,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(841,8081,40720,296865,3,830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',532.00,NULL,NULL,1,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL);
INSERT INTO `balance_libro` VALUES (842,8081,40720,296865,3,831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',21696.12,NULL,NULL,1,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(843,8081,40731,298410,2,832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',618.99,NULL,NULL,1,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(844,8081,40731,298410,2,833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',29530.00,NULL,NULL,1,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(845,8081,40731,298410,2,834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',32900.00,NULL,NULL,1,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(846,8081,40731,298410,2,835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',27600.00,NULL,NULL,1,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(847,8081,40731,298410,2,836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',35200.00,NULL,NULL,1,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(848,8081,40731,298410,2,837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',3000.00,NULL,NULL,1,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(849,8081,40731,298410,2,838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',6360.00,NULL,NULL,1,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(850,8081,40731,298410,2,839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',2995.00,NULL,NULL,1,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(851,8081,40731,9028,3,745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',26148.37,NULL,NULL,1,'2022-12-10 22:03:00','2022-12-10 22:03:00',NULL),(852,8081,40731,9028,3,744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',5647.83,NULL,NULL,1,'2022-12-10 22:03:42','2022-12-10 22:03:42',NULL),(853,8081,40731,9028,3,747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',37059.16,NULL,NULL,1,'2022-12-10 22:04:16','2022-12-10 22:04:16',NULL),(854,8081,40731,9028,3,748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',703.46,NULL,NULL,1,'2022-12-10 22:04:48','2022-12-10 22:04:48',NULL),(855,8081,40731,9028,3,749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',51003.95,NULL,NULL,1,'2022-12-10 22:05:19','2022-12-10 22:05:19',NULL),(856,8081,40731,9028,3,753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',69931.38,NULL,NULL,1,'2022-12-10 22:05:51','2022-12-10 22:39:51','2022-12-10 22:39:51'),(857,8081,40731,9028,3,754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',23038.53,NULL,NULL,1,'2022-12-10 22:06:18','2022-12-10 22:06:18',NULL),(858,8081,40731,9028,3,755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',32477.39,NULL,NULL,1,'2022-12-10 22:06:54','2022-12-10 22:06:54',NULL),(859,8081,40731,9028,3,746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',37047.08,NULL,NULL,1,'2022-12-10 22:07:25','2022-12-10 22:07:25',NULL),(860,8081,40731,9028,3,750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',750.27,NULL,NULL,1,'2022-12-10 22:07:53','2022-12-10 22:07:53',NULL),(861,8081,40731,9028,8,840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',177.65,NULL,NULL,1,'2022-12-10 22:12:50','2022-12-10 22:12:50',NULL),(862,8081,40731,9028,3,753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',55381.38,NULL,NULL,1,'2022-12-10 22:39:51','2022-12-10 22:39:51',NULL),(863,8081,40731,9028,16,NULL,48,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',13074.61,NULL,NULL,1,'2022-12-10 22:42:34','2022-12-10 22:42:34',NULL),(864,8081,40720,1516,2,841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',200000.00,NULL,NULL,1,'2022-12-11 20:18:17','2022-12-11 20:18:17',NULL),(865,8081,40720,1516,3,842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',697.11,NULL,NULL,1,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL);
INSERT INTO `balance_libro` VALUES (866,8081,40720,1516,3,843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',992.00,NULL,NULL,1,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(867,8081,40720,1516,3,844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',1999.20,NULL,NULL,1,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(868,8081,40720,1516,3,845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',1100.00,NULL,NULL,1,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(869,8081,40720,1516,3,846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',733.00,NULL,NULL,1,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(870,8081,40720,1516,3,847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',500.00,NULL,NULL,1,'2022-12-11 20:18:40','2022-12-11 20:20:08','2022-12-11 20:20:08'),(871,8081,40720,1516,3,848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',55568.06,NULL,NULL,1,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(872,8081,40720,1516,3,849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',4060.00,NULL,NULL,1,'2022-12-11 20:18:40','2022-12-11 20:21:53','2022-12-11 20:21:53'),(873,8081,40720,1516,3,850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',331.50,NULL,NULL,1,'2022-12-11 20:18:41','2022-12-11 20:18:41',NULL),(874,8081,40720,1516,3,851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',1532.00,NULL,NULL,1,'2022-12-11 20:18:41','2022-12-11 20:18:41',NULL),(875,8081,40720,1516,3,852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',6110.00,NULL,NULL,1,'2022-12-11 20:18:41','2022-12-11 20:18:41',NULL),(876,8081,40720,1516,3,853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',136999.00,NULL,NULL,1,'2022-12-11 20:18:41','2022-12-11 20:18:41',NULL),(877,8081,40720,1516,3,847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',500.00,NULL,NULL,1,'2022-12-11 20:20:08','2022-12-11 20:20:08',NULL),(878,8081,40720,1516,3,849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',4060.00,NULL,NULL,1,'2022-12-11 20:21:53','2022-12-11 20:21:53',NULL),(879,8081,40720,1516,8,854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',149.50,NULL,NULL,1,'2022-12-11 20:24:16','2022-12-11 20:24:16',NULL),(880,8081,40720,1516,16,NULL,53,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5000.00,NULL,NULL,1,'2022-12-11 21:32:39','2022-12-11 21:32:39',NULL),(881,8081,41120,295345,8,855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',1145.90,NULL,NULL,1,'2022-12-12 00:14:22','2022-12-12 00:14:22',NULL),(882,8081,41120,295345,8,856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',5.30,NULL,NULL,1,'2022-12-12 00:14:22','2022-12-12 00:14:22',NULL),(883,8081,40720,296867,2,857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',27000.00,NULL,NULL,1,'2022-12-12 11:36:09','2022-12-12 11:36:09',NULL),(884,8081,40720,296867,2,858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',4200.00,NULL,NULL,1,'2022-12-12 11:36:09','2022-12-12 11:36:09',NULL),(885,8081,40720,296867,2,859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',189000.00,NULL,NULL,1,'2022-12-12 11:36:09','2022-12-12 11:36:09',NULL),(886,8081,40720,296868,2,860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',120000.00,NULL,NULL,1,'2022-12-12 11:36:32','2022-12-12 11:36:32',NULL),(887,8081,40720,296868,2,861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',8000.00,NULL,NULL,1,'2022-12-12 11:36:32','2022-12-12 11:36:32',NULL),(888,8081,40720,296868,2,862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',10400.00,NULL,NULL,1,'2022-12-12 11:36:32','2022-12-12 11:36:32',NULL),(889,8081,40720,296868,2,863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',5000.00,NULL,NULL,1,'2022-12-12 11:36:32','2022-12-12 11:36:32',NULL);
INSERT INTO `balance_libro` VALUES (890,8081,40720,296868,2,864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',6000.00,NULL,NULL,1,'2022-12-12 11:36:32','2022-12-12 11:36:32',NULL),(891,8081,40720,296868,2,865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',79500.00,NULL,NULL,1,'2022-12-12 11:36:32','2022-12-12 11:36:32',NULL),(892,8081,40720,296869,2,866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',10000.00,NULL,NULL,1,'2022-12-12 11:36:49','2022-12-12 11:36:49',NULL),(893,8081,40720,296869,2,867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',28800.00,NULL,NULL,1,'2022-12-12 11:36:49','2022-12-12 11:36:49',NULL),(894,8081,40720,296869,2,868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',180000.00,NULL,NULL,1,'2022-12-12 11:36:49','2022-12-12 11:36:49',NULL),(895,8081,40720,296869,2,869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',10000.00,NULL,NULL,1,'2022-12-12 11:36:49','2022-12-12 11:36:49',NULL),(896,8081,40720,296869,2,870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',340000.00,NULL,NULL,1,'2022-12-12 11:36:49','2022-12-12 11:36:49',NULL),(897,8081,40720,296870,2,871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',29025.00,NULL,NULL,1,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(898,8081,40720,296870,2,872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',11350.00,NULL,NULL,1,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(899,8081,40720,296870,2,873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',11350.00,NULL,NULL,1,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(900,8081,40720,296870,2,874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',1350.00,NULL,NULL,1,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(901,8081,40720,296870,2,875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',1350.00,NULL,NULL,1,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(902,8081,40720,296870,2,876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',45250.00,NULL,NULL,1,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(903,8081,40720,296870,2,877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',45250.00,NULL,NULL,1,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(904,8081,40720,296870,2,878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',1600.00,NULL,NULL,1,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(905,8081,40720,296870,2,879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',1600.00,NULL,NULL,1,'2022-12-12 11:37:09','2022-12-12 11:37:09',NULL),(906,8081,40720,296871,2,880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',250000.00,NULL,NULL,1,'2022-12-12 11:37:27','2022-12-12 11:37:27',NULL),(907,8081,40720,296872,2,881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',120000.00,NULL,NULL,1,'2022-12-12 11:37:45','2022-12-12 11:37:45',NULL),(908,8081,40720,296873,2,882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',55000.00,NULL,NULL,1,'2022-12-12 11:38:32','2022-12-12 11:38:32',NULL),(909,8081,40720,296866,3,883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',151.71,NULL,NULL,1,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(910,8081,40720,296866,3,884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',800.00,NULL,NULL,1,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(911,8081,40720,296866,3,885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',697.11,NULL,NULL,1,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(912,8081,40720,296866,3,886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',563.20,NULL,NULL,1,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(913,8081,40720,296866,3,887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',4900.00,NULL,NULL,1,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL);
INSERT INTO `balance_libro` VALUES (914,8081,40720,296866,3,888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',2062.01,NULL,NULL,1,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(915,8081,40720,296866,3,889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',600.00,NULL,NULL,1,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(916,8081,40720,296866,3,890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',1034.90,NULL,NULL,1,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(917,8081,40720,296866,3,891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',21696.12,NULL,NULL,1,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(918,8081,40720,296866,3,892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-20','2022-02-20',492.00,NULL,NULL,1,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(919,8081,40720,296866,3,893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',800.00,NULL,NULL,1,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(920,8081,40720,296866,3,894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',200.00,NULL,NULL,1,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(921,8081,40720,296866,3,895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',2580.00,NULL,NULL,1,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(922,8081,40720,296867,3,896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',697.11,NULL,NULL,1,'2022-12-12 11:40:42','2022-12-12 11:40:42',NULL),(923,8081,40720,296867,3,897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',182372.40,NULL,NULL,1,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(924,8081,40720,296867,3,898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',182372.40,NULL,NULL,1,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(925,8081,40720,296867,3,899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1324.00,NULL,NULL,1,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(926,8081,40720,296867,3,900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',550.00,NULL,NULL,1,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(927,8081,40720,296867,3,901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',800.00,NULL,NULL,1,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(928,8081,40720,296867,3,902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',2800.00,NULL,NULL,1,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(929,8081,40720,296867,3,903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',600.00,NULL,NULL,1,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(930,8081,40720,296867,3,904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',1412.00,NULL,NULL,1,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(931,8081,40720,296867,3,905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',25686.33,NULL,NULL,1,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(932,8081,40720,296867,3,906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',712.00,NULL,NULL,1,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(933,8081,40720,296867,3,907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',300.00,NULL,NULL,1,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(934,8081,40720,296868,3,908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-03','2022-04-03',697.11,NULL,NULL,1,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(935,8081,40720,296868,3,909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',1260.00,NULL,NULL,1,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(936,8081,40720,296868,3,910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',2186.35,NULL,NULL,1,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(937,8081,40720,296868,3,911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',33399.00,NULL,NULL,1,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL);
INSERT INTO `balance_libro` VALUES (938,8081,40720,296868,3,912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',706.00,NULL,NULL,1,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(939,8081,40720,296868,3,913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',600.00,NULL,NULL,1,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(940,8081,40720,296868,3,914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',1012.00,NULL,NULL,1,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(941,8081,40720,296868,3,915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',200.00,NULL,NULL,1,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(942,8081,40720,296868,3,916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',23604.24,NULL,NULL,1,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(943,8081,40720,296868,3,917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',7866.00,NULL,NULL,1,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(944,8081,40720,296868,3,918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',4315.17,NULL,NULL,1,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(945,8081,40720,296868,3,919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',19320.00,NULL,NULL,1,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(946,8081,40720,296869,3,920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',697.11,NULL,NULL,1,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(947,8081,40720,296869,3,921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',489.00,NULL,NULL,1,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(948,8081,40720,296869,3,922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',9880.47,NULL,NULL,1,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(949,8081,40720,296869,3,923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-15','2022-05-15',600.00,NULL,NULL,1,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(950,8081,40720,296869,3,924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',1128.00,NULL,NULL,1,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(951,8081,40720,296869,3,925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',33753.28,NULL,NULL,1,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(952,8081,40720,296869,3,926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',700.00,NULL,NULL,1,'2022-12-12 11:41:25','2022-12-12 11:41:25',NULL),(953,8081,40720,296869,3,927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',2500.00,NULL,NULL,1,'2022-12-12 11:41:25','2022-12-12 11:41:25',NULL),(954,8081,40720,296869,3,928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',4750.00,NULL,NULL,1,'2022-12-12 11:41:25','2022-12-12 11:41:25',NULL),(955,8081,40720,296869,3,929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',3990.00,NULL,NULL,1,'2022-12-12 11:41:25','2022-12-12 11:41:25',NULL),(956,8081,40720,296870,3,930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',697.11,NULL,NULL,1,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(957,8081,40720,296870,3,931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',1399.00,NULL,NULL,1,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(958,8081,40720,296870,3,932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',9300.00,NULL,NULL,1,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(959,8081,40720,296870,3,933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',1510.88,NULL,NULL,1,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(960,8081,40720,296870,3,934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',750.00,NULL,NULL,1,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(961,8081,40720,296870,3,935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',2214.00,NULL,NULL,1,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL);
INSERT INTO `balance_libro` VALUES (962,8081,40720,296870,3,936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-20','2022-06-20',2892.00,NULL,NULL,1,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(963,8081,40720,296870,3,937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-20','2022-06-20',121.46,NULL,NULL,1,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(964,8081,40720,296870,3,938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',35257.26,NULL,NULL,1,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(965,8081,40720,296870,3,939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',4002.20,NULL,NULL,1,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(966,8081,40720,296870,3,940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',21790.60,NULL,NULL,1,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(967,8081,40720,296870,3,941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',1000.00,NULL,NULL,1,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(968,8081,40720,296871,3,942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',697.11,NULL,NULL,1,'2022-12-12 11:42:02','2022-12-12 11:42:02',NULL),(969,8081,40720,296871,3,943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',5492.68,NULL,NULL,1,'2022-12-12 11:42:02','2022-12-12 11:42:02',NULL),(970,8081,40720,296871,3,944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1345.00,NULL,NULL,1,'2022-12-12 11:42:02','2022-12-12 11:42:02',NULL),(971,8081,40720,296871,3,945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2691.44,NULL,NULL,1,'2022-12-12 11:42:02','2022-12-12 11:42:02',NULL),(972,8081,40720,296871,3,946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',750.00,NULL,NULL,1,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(973,8081,40720,296871,3,947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1400.00,NULL,NULL,1,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(974,8081,40720,296871,3,948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',39727.56,NULL,NULL,1,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(975,8081,40720,296871,3,949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2652.00,NULL,NULL,1,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(976,8081,40720,296871,3,950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',100.00,NULL,NULL,1,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(977,8081,40720,296871,3,951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',200.00,NULL,NULL,1,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(978,8081,40720,296871,3,952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',120.00,NULL,NULL,1,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(979,8081,40720,296872,3,953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',2978.00,NULL,NULL,1,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(980,8081,40720,296872,3,954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',697.11,NULL,NULL,1,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(981,8081,40720,296872,3,955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',1521.00,NULL,NULL,1,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(982,8081,40720,296872,3,956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',750.00,NULL,NULL,1,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(983,8081,40720,296872,3,957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',1114.00,NULL,NULL,1,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(984,8081,40720,296872,3,958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',39727.56,NULL,NULL,1,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(985,8081,40720,296872,3,959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',100.00,NULL,NULL,1,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL);
INSERT INTO `balance_libro` VALUES (986,8081,40720,296872,3,960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',1302.00,NULL,NULL,1,'2022-12-12 11:42:23','2022-12-12 11:42:23',NULL),(987,8081,40720,296872,3,961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',4189.00,NULL,NULL,1,'2022-12-12 11:42:23','2022-12-12 11:42:23',NULL),(988,8081,40720,296873,3,962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',1100.00,NULL,NULL,1,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(989,8081,40720,296873,3,963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',697.11,NULL,NULL,1,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(990,8081,40720,296873,3,964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',10150.00,NULL,NULL,1,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(991,8081,40720,296873,3,965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',10880.00,NULL,NULL,1,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(992,8081,40720,296873,3,966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',1100.00,NULL,NULL,1,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(993,8081,40720,296873,3,967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',10150.00,NULL,NULL,1,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(994,8081,40720,296873,3,968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',1100.00,NULL,NULL,1,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(995,8081,40720,296873,3,969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',44777.88,NULL,NULL,1,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(996,8081,40720,296873,3,970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',1042.00,NULL,NULL,1,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(997,8081,40720,296873,3,971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',10880.00,NULL,NULL,1,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(998,8081,41120,295337,2,972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',2600.00,NULL,NULL,1,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(999,8081,41120,295337,2,973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',6300.00,NULL,NULL,1,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(1000,8081,41120,295337,2,974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',4700.00,NULL,NULL,1,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(1001,8081,41120,295337,2,975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',7400.00,NULL,NULL,1,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(1002,8081,41120,295337,2,976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',3720.00,NULL,NULL,1,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(1003,8081,41120,295337,2,977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',8750.00,NULL,NULL,1,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(1004,8081,41120,295337,2,978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',1350.00,NULL,NULL,1,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(1005,8081,41120,295337,2,979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',1600.00,NULL,NULL,1,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(1006,8081,41120,295337,2,980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',1200.00,NULL,NULL,1,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(1007,8081,41120,295337,2,981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',350.00,NULL,NULL,1,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(1008,8081,41120,295337,2,982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',2300.00,NULL,NULL,1,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(1009,8081,41120,295337,2,983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',2300.00,NULL,NULL,1,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL);
INSERT INTO `balance_libro` VALUES (1010,8081,41120,295337,2,984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',5255.00,NULL,NULL,1,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(1011,8081,41120,295337,2,985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1150.00,NULL,NULL,1,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(1012,8081,41120,295337,2,986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1200.00,NULL,NULL,1,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(1013,8081,41120,295338,2,987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',136100.00,NULL,NULL,1,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(1014,8081,41120,295338,2,988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',1800.00,NULL,NULL,1,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(1015,8081,41120,295338,2,989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',1100.00,NULL,NULL,1,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(1016,8081,41120,295338,2,990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',700.00,NULL,NULL,1,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(1017,8081,41120,295338,2,991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',500.00,NULL,NULL,1,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(1018,8081,41120,295338,2,992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-03','2022-04-03',1100.00,NULL,NULL,1,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(1019,8081,41120,295338,2,993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',1050.00,NULL,NULL,1,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(1020,8081,41120,295338,2,994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',1550.00,NULL,NULL,1,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(1021,8081,41120,295338,2,995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',8800.00,NULL,NULL,1,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(1022,8081,41120,295338,2,996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',2250.00,NULL,NULL,1,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(1023,8081,41120,295338,2,997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',2100.00,NULL,NULL,1,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(1024,8081,41120,295338,2,998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',3800.00,NULL,NULL,1,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(1025,8081,41120,295338,2,999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',2550.00,NULL,NULL,1,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(1026,8081,41120,295338,2,1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',900.00,NULL,NULL,1,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(1027,8081,41120,295338,2,1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',2050.00,NULL,NULL,1,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(1028,8081,41120,295338,2,1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',3500.00,NULL,NULL,1,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(1029,8081,41120,295338,2,1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',6800.00,NULL,NULL,1,'2022-12-12 12:09:15','2022-12-12 12:09:15',NULL),(1030,8081,41120,295338,2,1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',500.00,NULL,NULL,1,'2022-12-12 12:09:15','2022-12-12 12:09:15',NULL),(1031,8081,41120,295339,2,1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',132200.00,NULL,NULL,1,'2022-12-12 12:09:33','2022-12-12 12:09:33',NULL),(1032,8081,41120,295339,2,1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',500.00,NULL,NULL,1,'2022-12-12 12:09:33','2022-12-12 12:09:33',NULL),(1033,8081,41120,295339,2,1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',3900.00,NULL,NULL,1,'2022-12-12 12:09:33','2022-12-12 12:09:33',NULL);
INSERT INTO `balance_libro` VALUES (1034,8081,41120,295339,2,1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-29','2022-05-29',14950.00,NULL,NULL,1,'2022-12-12 12:09:34','2022-12-12 12:09:34',NULL),(1035,8081,41120,295339,2,1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',2000.00,NULL,NULL,1,'2022-12-12 12:09:34','2022-12-12 12:09:34',NULL),(1036,8081,41120,295339,2,1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',1000.00,NULL,NULL,1,'2022-12-12 12:09:34','2022-12-12 12:09:34',NULL),(1037,8081,41120,295339,2,1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1200.00,NULL,NULL,1,'2022-12-12 12:09:34','2022-12-12 12:09:34',NULL),(1038,8081,41120,295339,2,1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',500.00,NULL,NULL,1,'2022-12-12 12:09:34','2022-12-12 12:09:34',NULL),(1039,8081,41120,295340,2,1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-05','2022-06-05',600.00,NULL,NULL,1,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(1040,8081,41120,295340,2,1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-05','2022-06-05',2340.00,NULL,NULL,1,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(1041,8081,41120,295340,2,1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-05','2022-06-05',260.00,NULL,NULL,1,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(1042,8081,41120,295340,2,1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',35400.00,NULL,NULL,1,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(1043,8081,41120,295340,2,1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-19','2022-06-19',10000.00,NULL,NULL,1,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(1044,8081,41120,295340,2,1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-19','2022-06-19',2400.00,NULL,NULL,1,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(1045,8081,41120,295340,2,1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-19','2022-06-19',800.00,NULL,NULL,1,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(1046,8081,41120,295340,2,1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-19','2022-06-19',8200.00,NULL,NULL,1,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(1047,8081,41120,295340,2,1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-19','2022-06-19',8700.00,NULL,NULL,1,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(1048,8081,41120,295340,2,1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-19','2022-06-19',2000.00,NULL,NULL,1,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(1049,8081,41120,295340,2,1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-20','2022-06-20',1500.00,NULL,NULL,1,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(1050,8081,41120,295340,2,1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-20','2022-06-20',7300.00,NULL,NULL,1,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(1051,8081,41120,295340,2,1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-20','2022-06-20',400.00,NULL,NULL,1,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(1052,8081,41120,295340,2,1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-20','2022-06-20',2000.00,NULL,NULL,1,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(1053,8081,41120,295340,2,1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-20','2022-06-20',2500.00,NULL,NULL,1,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(1054,8081,41120,295340,2,1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-20','2022-06-20',2700.00,NULL,NULL,1,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(1055,8081,41120,295340,2,1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',1000.00,NULL,NULL,1,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(1056,8081,41120,295340,2,1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',1300.00,NULL,NULL,1,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(1057,8081,41120,295340,2,1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',1100.00,NULL,NULL,1,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL);
INSERT INTO `balance_libro` VALUES (1058,8081,41120,295340,2,1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',3800.00,NULL,NULL,1,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(1059,8081,41120,295340,2,1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',2700.00,NULL,NULL,1,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(1060,8081,41120,295340,2,1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',2400.00,NULL,NULL,1,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(1061,8081,41120,295340,2,1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',5900.00,NULL,NULL,1,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(1062,8081,41120,295340,2,1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',500.00,NULL,NULL,1,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(1063,8081,41120,295340,2,1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',2400.00,NULL,NULL,1,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(1064,8081,41120,295340,2,1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',4000.00,NULL,NULL,1,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(1065,8081,41120,295340,2,1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',4600.00,NULL,NULL,1,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(1066,8081,41120,295340,2,1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',113690.00,NULL,NULL,1,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(1067,8081,41120,295341,2,1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',1850.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1068,8081,41120,295341,2,1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',1000.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1069,8081,41120,295341,2,1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',1000.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1070,8081,41120,295341,2,1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',2200.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1071,8081,41120,295341,2,1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',1150.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1072,8081,41120,295341,2,1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',2400.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1073,8081,41120,295341,2,1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',2000.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1074,8081,41120,295341,2,1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',2400.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1075,8081,41120,295341,2,1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',2200.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1076,8081,41120,295341,2,1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',3400.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1077,8081,41120,295341,2,1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',1800.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1078,8081,41120,295341,2,1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',37800.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1079,8081,41120,295341,2,1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',2400.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1080,8081,41120,295341,2,1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',1400.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1081,8081,41120,295341,2,1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',2600.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL);
INSERT INTO `balance_libro` VALUES (1082,8081,41120,295341,2,1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',3000.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1083,8081,41120,295341,2,1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',2700.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1084,8081,41120,295341,2,1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',3300.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1085,8081,41120,295341,2,1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',3600.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1086,8081,41120,295341,2,1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',2300.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1087,8081,41120,295341,2,1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',2350.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1088,8081,41120,295341,2,1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',10900.00,NULL,NULL,1,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(1089,8081,41120,295341,2,1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',100.00,NULL,NULL,1,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(1090,8081,41120,295341,2,1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2400.00,NULL,NULL,1,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(1091,8081,41120,295341,2,1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3300.00,NULL,NULL,1,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(1092,8081,41120,295341,2,1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2800.00,NULL,NULL,1,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(1093,8081,41120,295341,2,1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2600.00,NULL,NULL,1,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(1094,8081,41120,295341,2,1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2100.00,NULL,NULL,1,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(1095,8081,41120,295341,2,1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2550.00,NULL,NULL,1,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(1096,8081,41120,295341,2,1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5500.00,NULL,NULL,1,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(1097,8081,41120,295342,2,1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',128800.00,NULL,NULL,1,'2022-12-12 12:10:36','2022-12-12 12:10:36',NULL),(1098,8081,41120,295342,2,1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',10100.00,NULL,NULL,1,'2022-12-12 12:10:36','2022-12-12 12:10:36',NULL),(1099,8081,41120,295342,2,1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',4300.00,NULL,NULL,1,'2022-12-12 12:10:36','2022-12-12 12:10:36',NULL),(1100,8081,41120,295342,2,1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',5400.00,NULL,NULL,1,'2022-12-12 12:10:36','2022-12-12 12:10:36',NULL),(1101,8081,41120,295342,2,1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',2500.00,NULL,NULL,1,'2022-12-12 12:10:36','2022-12-12 12:10:36',NULL),(1102,8081,41120,295342,2,1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',9800.00,NULL,NULL,1,'2022-12-12 12:10:36','2022-12-12 12:10:36',NULL),(1103,8081,41120,295342,2,1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-14','2022-08-14',4720.00,NULL,NULL,1,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(1104,8081,41120,295342,2,1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-14','2022-08-14',5200.00,NULL,NULL,1,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(1105,8081,41120,295342,2,1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-14','2022-08-14',7300.00,NULL,NULL,1,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL);
INSERT INTO `balance_libro` VALUES (1106,8081,41120,295342,2,1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-14','2022-08-14',3200.00,NULL,NULL,1,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(1107,8081,41120,295342,2,1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-14','2022-08-14',3800.00,NULL,NULL,1,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(1108,8081,41120,295342,2,1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',5400.00,NULL,NULL,1,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(1109,8081,41120,295342,2,1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',5800.00,NULL,NULL,1,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(1110,8081,41120,295342,2,1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',6600.00,NULL,NULL,1,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(1111,8081,41120,295342,2,1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2800.00,NULL,NULL,1,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(1112,8081,41120,295342,2,1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',9500.00,NULL,NULL,1,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(1113,8081,41120,295342,2,1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',4800.00,NULL,NULL,1,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(1114,8081,41120,295342,2,1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',5600.00,NULL,NULL,1,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(1115,8081,41120,295342,2,1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2400.00,NULL,NULL,1,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(1116,8081,41120,295343,2,1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',2500.00,NULL,NULL,1,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(1117,8081,41120,295343,2,1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',1200.00,NULL,NULL,1,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(1118,8081,41120,295343,2,1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',3200.00,NULL,NULL,1,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(1119,8081,41120,295343,2,1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',4400.00,NULL,NULL,1,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(1120,8081,41120,295343,2,1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',5600.00,NULL,NULL,1,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(1121,8081,41120,295343,2,1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',4100.00,NULL,NULL,1,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(1122,8081,41120,295343,2,1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',3600.00,NULL,NULL,1,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(1123,8081,41120,295343,2,1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',5400.00,NULL,NULL,1,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(1124,8081,41120,295343,2,1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',4400.00,NULL,NULL,1,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(1125,8081,41120,295343,2,1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',1200.00,NULL,NULL,1,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(1126,8081,41120,295343,2,1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',4000.00,NULL,NULL,1,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(1127,8081,41120,295343,2,1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',3600.00,NULL,NULL,1,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(1128,8081,41120,295343,2,1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',3000.00,NULL,NULL,1,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(1129,8081,41120,295343,2,1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',2000.00,NULL,NULL,1,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL);
INSERT INTO `balance_libro` VALUES (1130,8081,41120,295343,2,1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',1200.00,NULL,NULL,1,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(1131,8081,41120,295343,2,1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',3700.00,NULL,NULL,1,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(1132,8081,41120,295343,2,1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',1200.00,NULL,NULL,1,'2022-12-12 12:11:31','2022-12-12 12:11:31',NULL),(1133,8081,41120,295343,2,1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',1900.00,NULL,NULL,1,'2022-12-12 12:11:31','2022-12-12 12:11:31',NULL),(1134,8081,41120,295343,2,1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',2400.00,NULL,NULL,1,'2022-12-12 12:11:31','2022-12-12 12:11:31',NULL),(1135,8081,41120,295343,2,1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',2400.00,NULL,NULL,1,'2022-12-12 12:11:31','2022-12-12 12:11:31',NULL),(1136,8081,41120,295343,2,1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',5000.00,NULL,NULL,1,'2022-12-12 12:11:31','2022-12-12 12:11:31',NULL),(1137,8081,41120,295344,2,1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',2000.00,NULL,NULL,1,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(1138,8081,41120,295344,2,1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',7800.00,NULL,NULL,1,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(1139,8081,41120,295344,2,1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',2500.00,NULL,NULL,1,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(1140,8081,41120,295344,2,1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',2000.00,NULL,NULL,1,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(1141,8081,41120,295344,2,1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',2400.00,NULL,NULL,1,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(1142,8081,41120,295344,2,1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',1300.00,NULL,NULL,1,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(1143,8081,41120,295344,2,1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',3500.00,NULL,NULL,1,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(1144,8081,41120,295344,2,1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',3500.00,NULL,NULL,1,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(1145,8081,41120,295344,2,1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',8000.00,NULL,NULL,1,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(1146,8081,41120,295344,2,1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-09','2022-10-09',2900.00,NULL,NULL,1,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(1147,8081,41120,295344,2,1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-09','2022-10-09',3000.00,NULL,NULL,1,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(1148,8081,41120,295344,2,1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-09','2022-10-09',1300.00,NULL,NULL,1,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(1149,8081,41120,295344,2,1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-09','2022-10-09',1500.00,NULL,NULL,1,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(1150,8081,41120,295344,2,1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-09','2022-10-09',4300.00,NULL,NULL,1,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(1151,8081,41120,295344,2,1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-09','2022-10-09',1700.00,NULL,NULL,1,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(1152,8081,41120,295344,2,1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-09','2022-10-09',2700.00,NULL,NULL,1,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(1153,8081,41120,295344,2,1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',7900.00,NULL,NULL,1,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL);
INSERT INTO `balance_libro` VALUES (1154,8081,41120,295344,2,1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',8930.00,NULL,NULL,1,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(1155,8081,41120,295344,2,1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',7200.00,NULL,NULL,1,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(1156,8081,41120,295344,2,1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',3200.00,NULL,NULL,1,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(1157,8081,41120,295344,2,1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',3500.00,NULL,NULL,1,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(1158,8081,41120,295344,2,1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',3900.00,NULL,NULL,1,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(1159,8081,41120,295344,2,1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',5100.00,NULL,NULL,1,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(1160,8081,41120,295344,2,1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1200.00,NULL,NULL,1,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(1161,8081,41120,295344,2,1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2500.00,NULL,NULL,1,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(1162,8081,41120,295344,2,1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',118250.00,NULL,NULL,1,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(1163,8081,41120,295345,2,1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',2000.00,NULL,NULL,1,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(1164,8081,41120,295345,2,1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',1900.00,NULL,NULL,1,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(1165,8081,41120,295345,2,1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',4400.00,NULL,NULL,1,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(1166,8081,41120,295345,2,1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',1400.00,NULL,NULL,1,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(1167,8081,41120,295345,2,1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',2150.00,NULL,NULL,1,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(1168,8081,41120,295345,2,1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',5150.00,NULL,NULL,1,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(1169,8081,41120,295345,2,1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',2700.00,NULL,NULL,1,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(1170,8081,41120,295345,2,1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-27','2022-11-27',1800.00,NULL,NULL,1,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(1171,8081,41120,295345,2,1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',145500.00,NULL,NULL,1,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(1172,8081,41120,295345,2,1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',72105.00,NULL,NULL,1,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(1173,8081,41120,295335,3,1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',49999.00,NULL,NULL,1,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(1174,8081,41120,295335,3,1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',32460.14,NULL,NULL,1,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(1175,8081,41120,295335,3,1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',735.24,NULL,NULL,1,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(1176,8081,41120,295335,3,1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',28349.10,NULL,NULL,1,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(1177,8081,41120,295335,3,1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',26136.00,NULL,NULL,1,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL);
INSERT INTO `balance_libro` VALUES (1178,8081,41120,295336,3,1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',1999.73,NULL,NULL,1,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(1179,8081,41120,295336,3,1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',49999.00,NULL,NULL,1,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(1180,8081,41120,295336,3,1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',15639.25,NULL,NULL,1,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(1181,8081,41120,295336,3,1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',5076.19,NULL,NULL,1,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(1182,8081,41120,295336,3,1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',5462.42,NULL,NULL,1,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(1183,8081,41120,295337,3,1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1260.00,NULL,NULL,1,'2022-12-12 12:16:10','2022-12-12 12:16:10',NULL),(1184,8081,41120,295337,3,1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',985.92,NULL,NULL,1,'2022-12-12 12:16:10','2022-12-12 12:16:10',NULL),(1185,8081,41120,295337,3,1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',70625.58,NULL,NULL,1,'2022-12-12 12:16:10','2022-12-12 12:16:10',NULL),(1186,8081,41120,295337,3,1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',5500.00,NULL,NULL,1,'2022-12-12 12:16:10','2022-12-12 12:16:10',NULL),(1187,8081,41120,295338,3,1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',300.00,NULL,NULL,1,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(1188,8081,41120,295338,3,1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',24535.59,NULL,NULL,1,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(1189,8081,41120,295338,3,1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',17382.63,NULL,NULL,1,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(1190,8081,41120,295338,3,1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',8400.00,NULL,NULL,1,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(1191,8081,41120,295338,3,1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',35988.00,NULL,NULL,1,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(1192,8081,41120,295338,3,1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',824.11,NULL,NULL,1,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(1193,8081,41120,295338,3,1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',28749.60,NULL,NULL,1,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(1194,8081,41120,295339,3,1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',40089.62,NULL,NULL,1,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL),(1195,8081,41120,295339,3,1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',2105.91,NULL,NULL,1,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL),(1196,8081,41120,295339,3,1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',40422.14,NULL,NULL,1,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL),(1197,8081,41120,295339,3,1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',40089.62,NULL,NULL,1,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL),(1198,8081,41120,295340,3,1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',1279.60,NULL,NULL,1,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL),(1199,8081,41120,295340,3,1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',25164.12,NULL,NULL,1,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL),(1200,8081,41120,295340,3,1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',5607.89,NULL,NULL,1,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL),(1201,8081,41120,295340,3,1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',19556.23,NULL,NULL,1,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL);
INSERT INTO `balance_libro` VALUES (1202,8081,41120,295341,3,1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',29596.12,NULL,NULL,1,'2022-12-12 12:17:35','2022-12-12 12:17:35',NULL),(1203,8081,41120,295341,3,1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1755.60,NULL,NULL,1,'2022-12-12 12:17:35','2022-12-12 12:17:35',NULL),(1204,8081,41120,295341,3,1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',39488.35,NULL,NULL,1,'2022-12-12 12:17:35','2022-12-12 12:17:35',NULL),(1205,8081,41120,295341,3,1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6800.00,NULL,NULL,1,'2022-12-12 12:17:35','2022-12-12 12:17:35',NULL),(1206,8081,41120,295342,3,1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-07','2022-08-07',1420.13,NULL,NULL,1,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(1207,8081,41120,295342,3,1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',23017.32,NULL,NULL,1,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(1208,8081,41120,295342,3,1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',13841.42,NULL,NULL,1,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(1209,8081,41120,295342,3,1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',13841.42,NULL,NULL,1,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(1210,8081,41120,295342,3,1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',25061.55,NULL,NULL,1,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(1211,8081,41120,295343,3,1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',1520.01,NULL,NULL,1,'2022-12-12 12:19:08','2022-12-12 12:19:08',NULL),(1212,8081,41120,295343,3,1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',31506.17,NULL,NULL,1,'2022-12-12 12:19:08','2022-12-12 12:19:08',NULL),(1213,8081,41120,295343,3,1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',42749.09,NULL,NULL,1,'2022-12-12 12:19:08','2022-12-12 12:19:08',NULL),(1214,8081,41120,295343,3,1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',45435.50,NULL,NULL,1,'2022-12-12 12:19:08','2022-12-12 12:19:08',NULL),(1215,8081,41120,295344,3,1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',869.76,NULL,NULL,1,'2022-12-12 12:19:40','2022-12-12 12:19:40',NULL),(1216,8081,41120,295344,3,1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',92453.01,NULL,NULL,1,'2022-12-12 12:19:40','2022-12-12 12:19:40',NULL),(1217,8081,41120,295344,3,1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',24684.00,NULL,NULL,1,'2022-12-12 12:19:40','2022-12-12 12:19:40',NULL),(1218,8081,41120,295345,3,1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',987.83,NULL,NULL,1,'2022-12-12 12:19:58','2022-12-12 12:19:58',NULL),(1219,8081,41120,295345,3,1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',56688.50,NULL,NULL,1,'2022-12-12 12:19:58','2022-12-12 12:19:58',NULL),(1220,8081,41120,295345,3,1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-27','2022-11-27',8189.09,NULL,NULL,1,'2022-12-12 12:19:58','2022-12-12 12:19:58',NULL),(1221,8081,41120,295345,3,1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',15621.60,NULL,NULL,1,'2022-12-12 12:19:58','2022-12-12 12:19:58',NULL),(1222,8081,41123,296880,2,1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',17500.00,NULL,NULL,1,'2022-12-12 12:24:33','2022-12-12 12:24:33',NULL),(1223,8081,41123,296881,2,1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',10050.00,NULL,NULL,1,'2022-12-12 12:24:53','2022-12-12 12:24:53',NULL),(1224,8081,41123,296881,2,1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',2900.00,NULL,NULL,1,'2022-12-12 12:24:53','2022-12-12 12:24:53',NULL),(1225,8081,41123,296881,2,1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',21450.00,NULL,NULL,1,'2022-12-12 12:24:53','2022-12-12 12:24:53',NULL);
INSERT INTO `balance_libro` VALUES (1226,8081,41123,296882,2,1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',62920.00,NULL,NULL,1,'2022-12-12 12:25:20','2022-12-12 12:25:20',NULL),(1227,8081,41123,296882,2,1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',2050.00,NULL,NULL,1,'2022-12-12 12:25:20','2022-12-12 12:25:20',NULL),(1228,8081,41123,296882,2,1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',22850.00,NULL,NULL,1,'2022-12-12 12:25:20','2022-12-12 12:25:20',NULL),(1229,8081,41123,296883,2,1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',62920.00,NULL,NULL,1,'2022-12-12 12:25:38','2022-12-12 12:25:38',NULL),(1230,8081,41123,296884,2,1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',45900.00,NULL,NULL,1,'2022-12-12 12:25:54','2022-12-12 12:25:54',NULL),(1231,8081,41123,296884,2,1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',62920.00,NULL,NULL,1,'2022-12-12 12:25:54','2022-12-12 12:25:54',NULL),(1232,8081,41123,296885,2,1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',45900.00,NULL,NULL,1,'2022-12-12 12:26:18','2022-12-12 12:26:18',NULL),(1233,8081,41123,296885,2,1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',62920.00,NULL,NULL,1,'2022-12-12 12:26:18','2022-12-12 12:26:18',NULL),(1234,8081,41123,296886,2,1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',45900.00,NULL,NULL,1,'2022-12-12 12:26:42','2022-12-12 12:26:42',NULL),(1235,8081,41123,296886,2,1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',62920.00,NULL,NULL,1,'2022-12-12 12:26:42','2022-12-12 12:26:42',NULL),(1236,8081,41123,296886,2,1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',6380.00,NULL,NULL,1,'2022-12-12 12:26:42','2022-12-12 12:26:42',NULL),(1237,8081,41123,296886,2,1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',7100.00,NULL,NULL,1,'2022-12-12 12:26:42','2022-12-12 12:26:42',NULL),(1238,8081,41123,296886,2,1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',7100.00,NULL,NULL,1,'2022-12-12 12:26:42','2022-12-12 12:26:42',NULL),(1239,8081,41123,296887,2,1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',78650.00,NULL,NULL,1,'2022-12-12 12:26:58','2022-12-12 12:26:58',NULL),(1240,8081,41123,296887,2,1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',57400.00,NULL,NULL,1,'2022-12-12 12:26:58','2022-12-12 12:26:58',NULL),(1241,8081,41123,296888,2,1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',57400.00,NULL,NULL,1,'2022-12-12 12:27:17','2022-12-12 12:27:17',NULL),(1242,8081,41123,296888,2,1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',78650.00,NULL,NULL,1,'2022-12-12 12:27:17','2022-12-12 12:27:17',NULL),(1243,8081,41123,296889,2,1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',39400.00,NULL,NULL,1,'2022-12-12 12:27:38','2022-12-12 12:27:38',NULL),(1244,8081,41123,296889,2,1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',57400.00,NULL,NULL,1,'2022-12-12 12:27:38','2022-12-12 12:27:38',NULL),(1245,8081,41123,296890,2,1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',78650.00,NULL,NULL,1,'2022-12-12 12:27:59','2022-12-12 12:27:59',NULL),(1246,8081,41123,296890,2,1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',57400.00,NULL,NULL,1,'2022-12-12 12:27:59','2022-12-12 12:27:59',NULL),(1247,8081,41123,296880,3,1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',9240.01,NULL,NULL,1,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(1248,8081,41123,296880,3,1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',104.63,NULL,NULL,1,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(1249,8081,41123,296880,3,1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',1000.50,NULL,NULL,1,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL);
INSERT INTO `balance_libro` VALUES (1250,8081,41123,296880,3,1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',4356.50,NULL,NULL,1,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(1251,8081,41123,296880,3,1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',3077.80,NULL,NULL,1,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(1252,8081,41123,296880,3,1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',49.30,NULL,NULL,1,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(1253,8081,41123,296880,3,1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',104.62,NULL,NULL,1,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(1254,8081,41123,296880,3,1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',98.60,NULL,NULL,1,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(1255,8081,41123,296880,3,1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',302.30,NULL,NULL,1,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(1256,8081,41123,296881,3,1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',9240.01,NULL,NULL,1,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(1257,8081,41123,296881,3,1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',88.50,NULL,NULL,1,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(1258,8081,41123,296881,3,1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',28.70,NULL,NULL,1,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(1259,8081,41123,296881,3,1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',736.12,NULL,NULL,1,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(1260,8081,41123,296881,3,1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',65.00,NULL,NULL,1,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(1261,8081,41123,296881,3,1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',215.00,NULL,NULL,1,'2022-12-12 12:29:09','2022-12-12 12:29:09',NULL),(1262,8081,41123,296881,3,1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',176.55,NULL,NULL,1,'2022-12-12 12:29:09','2022-12-12 12:29:09',NULL),(1263,8081,41123,296881,3,1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',579.75,NULL,NULL,1,'2022-12-12 12:29:09','2022-12-12 12:29:09',NULL),(1264,8081,41123,296881,3,1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',5834.06,NULL,NULL,1,'2022-12-12 12:29:09','2022-12-12 12:29:09',NULL),(1265,8081,41123,296882,3,1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',9240.01,NULL,NULL,1,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(1266,8081,41123,296882,3,1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',136.00,NULL,NULL,1,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(1267,8081,41123,296882,3,1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',127.00,NULL,NULL,1,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(1268,8081,41123,296882,3,1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',391.91,NULL,NULL,1,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(1269,8081,41123,296882,3,1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',127.00,NULL,NULL,1,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(1270,8081,41123,296882,3,1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',495.00,NULL,NULL,1,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(1271,8081,41123,296883,3,1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',215.00,NULL,NULL,1,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL),(1272,8081,41123,296883,3,1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',3800.68,NULL,NULL,1,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL),(1273,8081,41123,296883,3,1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',229.00,NULL,NULL,1,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL);
INSERT INTO `balance_libro` VALUES (1274,8081,41123,296883,3,1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',10935.09,NULL,NULL,1,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL),(1275,8081,41123,296883,3,1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',4762.50,NULL,NULL,1,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL),(1276,8081,41123,296883,3,1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',556.33,NULL,NULL,1,'2022-12-12 12:29:53','2022-12-12 12:29:53',NULL),(1277,8081,41123,296883,3,1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',621.00,NULL,NULL,1,'2022-12-12 12:29:53','2022-12-12 12:29:53',NULL),(1278,8081,41123,296883,3,1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',2599.00,NULL,NULL,1,'2022-12-12 12:29:53','2022-12-12 12:29:53',NULL),(1279,8081,41123,296884,3,1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',132.00,NULL,NULL,1,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(1280,8081,41123,296884,3,1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',10381.48,NULL,NULL,1,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(1281,8081,41123,296884,3,1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',151.71,NULL,NULL,1,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(1282,8081,41123,296884,3,1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',95.00,NULL,NULL,1,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(1283,8081,41123,296884,3,1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',207.00,NULL,NULL,1,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(1284,8081,41123,296884,3,1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',2000.00,NULL,NULL,1,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(1285,8081,41123,296885,3,1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',13163.87,NULL,NULL,1,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(1286,8081,41123,296885,3,1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',46676.80,NULL,NULL,1,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(1287,8081,41123,296885,3,1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',404.62,NULL,NULL,1,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(1288,8081,41123,296885,3,1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',68.00,NULL,NULL,1,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(1289,8081,41123,296885,3,1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',51.00,NULL,NULL,1,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(1290,8081,41123,296885,3,1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',66.00,NULL,NULL,1,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(1291,8081,41123,296885,3,1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',3270.00,NULL,NULL,1,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(1292,8081,41123,296885,3,1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',297.15,NULL,NULL,1,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(1293,8081,41123,296885,3,1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',207.00,NULL,NULL,1,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(1294,8081,41123,296885,3,1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',166.86,NULL,NULL,1,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(1295,8081,41123,296886,3,1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',489.11,NULL,NULL,1,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(1296,8081,41123,296886,3,1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',12826.84,NULL,NULL,1,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(1297,8081,41123,296886,3,1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',1106.13,NULL,NULL,1,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL);
INSERT INTO `balance_libro` VALUES (1298,8081,41123,296886,3,1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4690.68,NULL,NULL,1,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(1299,8081,41123,296886,3,1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',2504.15,NULL,NULL,1,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(1300,8081,41123,296886,3,1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',63.21,NULL,NULL,1,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(1301,8081,41123,296886,3,1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',10500.00,NULL,NULL,1,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(1302,8081,41123,296886,3,1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',441.00,NULL,NULL,1,'2022-12-12 12:30:45','2022-12-12 12:30:45',NULL),(1303,8081,41123,296886,3,1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',2547.45,NULL,NULL,1,'2022-12-12 12:30:45','2022-12-12 12:30:45',NULL),(1304,8081,41123,296886,3,1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',7500.00,NULL,NULL,1,'2022-12-12 12:30:45','2022-12-12 12:30:45',NULL),(1305,8081,41123,296886,3,1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',578.58,NULL,NULL,1,'2022-12-12 12:30:45','2022-12-12 12:30:45',NULL),(1306,8081,41123,296887,3,1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',14281.02,NULL,NULL,1,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(1307,8081,41123,296887,3,1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',618.83,NULL,NULL,1,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(1308,8081,41123,296887,3,1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',68.00,NULL,NULL,1,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(1309,8081,41123,296887,3,1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',9173.50,NULL,NULL,1,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(1310,8081,41123,296887,3,1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',3373.83,NULL,NULL,1,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(1311,8081,41123,296887,3,1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',144.00,NULL,NULL,1,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(1312,8081,41123,296887,3,1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',252.00,NULL,NULL,1,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(1313,8081,41123,296887,3,1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',9500.00,NULL,NULL,1,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(1314,8081,41123,296887,3,1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',164.76,NULL,NULL,1,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(1315,8081,41123,296888,3,1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',14281.02,NULL,NULL,1,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(1316,8081,41123,296888,3,1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',76.00,NULL,NULL,1,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(1317,8081,41123,296888,3,1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',2262.50,NULL,NULL,1,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(1318,8081,41123,296888,3,1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',606.90,NULL,NULL,1,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(1319,8081,41123,296888,3,1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',518.41,NULL,NULL,1,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(1320,8081,41123,296888,3,1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',659.09,NULL,NULL,1,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(1321,8081,41123,296888,3,1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',14990.00,NULL,NULL,1,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL);
INSERT INTO `balance_libro` VALUES (1322,8081,41123,296888,3,1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',351.00,NULL,NULL,1,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(1323,8081,41123,296888,3,1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',1119.90,NULL,NULL,1,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(1324,8081,41123,296888,3,1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',9500.00,NULL,NULL,1,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(1325,8081,41123,296888,3,1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',424.56,NULL,NULL,1,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(1326,8081,41123,296889,3,1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',15927.47,NULL,NULL,1,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(1327,8081,41123,296889,3,1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',163.00,NULL,NULL,1,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(1328,8081,41123,296889,3,1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',163.00,NULL,NULL,1,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(1329,8081,41123,296889,3,1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',518.35,NULL,NULL,1,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(1330,8081,41123,296889,3,1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1114.38,NULL,NULL,1,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(1331,8081,41123,296889,3,1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',4985.00,NULL,NULL,1,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(1332,8081,41123,296889,3,1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',350.00,NULL,NULL,1,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(1333,8081,41123,296889,3,1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',2990.00,NULL,NULL,1,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(1334,8081,41123,296889,3,1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',45.00,NULL,NULL,1,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(1335,8081,41123,296889,3,1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',9500.00,NULL,NULL,1,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(1336,8081,41123,296890,3,1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',15927.47,NULL,NULL,1,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(1337,8081,41123,296890,3,1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',12834.00,NULL,NULL,1,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(1338,8081,41123,296890,3,1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',212.39,NULL,NULL,1,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(1339,8081,41123,296890,3,1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',163.00,NULL,NULL,1,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(1340,8081,41123,296890,3,1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',7898.20,NULL,NULL,1,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(1341,8081,41123,296890,3,1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',7350.00,NULL,NULL,1,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(1342,8081,41123,296890,3,1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',265.47,NULL,NULL,1,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(1343,8081,41123,296890,3,1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',5725.00,NULL,NULL,1,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(1344,8081,41123,296890,3,1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',360.00,NULL,NULL,1,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(1345,8081,41123,296890,3,1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',10500.00,NULL,NULL,1,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL);
INSERT INTO `balance_libro` VALUES (1346,8081,41123,296890,3,1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',18060.44,NULL,NULL,1,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(1347,8081,41123,296890,3,1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3822.45,NULL,NULL,1,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(1348,8081,40731,298411,2,1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',35200.00,NULL,NULL,1,'2022-12-12 13:25:15','2022-12-12 13:25:15',NULL),(1349,8081,40731,298411,2,1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',39100.00,NULL,NULL,1,'2022-12-12 13:25:16','2022-12-12 13:25:16',NULL),(1350,8081,40731,298411,2,1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',39100.00,NULL,NULL,1,'2022-12-12 13:25:16','2022-12-12 13:25:16',NULL),(1351,8081,40731,298411,2,1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',35200.00,NULL,NULL,1,'2022-12-12 13:25:16','2022-12-12 13:25:16',NULL),(1352,8081,40731,298411,2,1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',28000.00,NULL,NULL,1,'2022-12-12 13:25:16','2022-12-12 13:25:16',NULL),(1353,8081,40731,298411,2,1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',3300.00,NULL,NULL,1,'2022-12-12 13:25:16','2022-12-12 13:25:16',NULL),(1354,8081,40731,298412,2,1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',44910.00,NULL,NULL,1,'2022-12-12 13:25:34','2022-12-12 13:25:34',NULL),(1355,8081,40731,298412,2,1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',37990.00,NULL,NULL,1,'2022-12-12 13:25:34','2022-12-12 13:25:34',NULL),(1356,8081,40731,298412,2,1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',31685.00,NULL,NULL,1,'2022-12-12 13:25:34','2022-12-12 13:25:34',NULL),(1357,8081,40731,298412,2,1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',38000.00,NULL,NULL,1,'2022-12-12 13:25:34','2022-12-12 13:25:34',NULL),(1358,8081,40731,298413,2,1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',21760.00,NULL,NULL,1,'2022-12-12 13:25:50','2022-12-12 13:25:50',NULL),(1359,8081,40731,298413,2,1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',19990.00,NULL,NULL,1,'2022-12-12 13:25:50','2022-12-12 13:25:50',NULL),(1360,8081,40731,298413,2,1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',37990.00,NULL,NULL,1,'2022-12-12 13:25:50','2022-12-12 13:25:50',NULL),(1361,8081,40731,298413,2,1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',42230.00,NULL,NULL,1,'2022-12-12 13:25:50','2022-12-12 13:25:50',NULL),(1362,8081,40731,298413,2,1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',34200.00,NULL,NULL,1,'2022-12-12 13:25:50','2022-12-12 13:25:50',NULL),(1363,8081,40731,298413,2,1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',3600.00,NULL,NULL,1,'2022-12-12 13:25:50','2022-12-12 13:25:50',NULL),(1364,8081,40731,298414,2,1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',31685.00,NULL,NULL,1,'2022-12-12 13:26:08','2022-12-12 13:26:08',NULL),(1365,8081,40731,298414,2,1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',42000.00,NULL,NULL,1,'2022-12-12 13:26:08','2022-12-12 13:26:08',NULL),(1366,8081,40731,298414,2,1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-25','2022-05-25',12000.00,NULL,NULL,1,'2022-12-12 13:26:08','2022-12-12 13:26:08',NULL),(1367,8081,40731,298415,2,1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',415.07,NULL,NULL,1,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(1368,8081,40731,298415,2,1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',36890.00,NULL,NULL,1,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(1369,8081,40731,298415,2,1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',45910.00,NULL,NULL,1,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL);
INSERT INTO `balance_libro` VALUES (1370,8081,40731,298415,2,1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',4470.00,NULL,NULL,1,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(1371,8081,40731,298415,2,1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',45910.00,NULL,NULL,1,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(1372,8081,40731,298415,2,1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-20','2022-06-20',7000.00,NULL,NULL,1,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(1373,8081,40731,298415,2,1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',35190.00,NULL,NULL,1,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(1374,8081,40731,298415,2,1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',2090.00,NULL,NULL,1,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(1375,8081,40731,298416,2,1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',45910.00,NULL,NULL,1,'2022-12-12 13:26:52','2022-12-12 13:26:52',NULL),(1376,8081,40731,298416,2,1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',15630.00,NULL,NULL,1,'2022-12-12 13:26:52','2022-12-12 13:26:52',NULL),(1377,8081,40731,298416,2,1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',41000.00,NULL,NULL,1,'2022-12-12 13:26:52','2022-12-12 13:26:52',NULL),(1378,8081,40731,298417,2,1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',55105.00,NULL,NULL,1,'2022-12-12 13:27:12','2022-12-12 13:27:12',NULL),(1379,8081,40731,298417,2,1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',23580.00,NULL,NULL,1,'2022-12-12 13:27:12','2022-12-12 13:27:12',NULL),(1380,8081,40731,298417,2,1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',45910.00,NULL,NULL,1,'2022-12-12 13:27:12','2022-12-12 13:27:12',NULL),(1381,8081,40731,298417,2,1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',59135.00,NULL,NULL,1,'2022-12-12 13:27:12','2022-12-12 13:27:12',NULL),(1382,8081,40731,298417,2,1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',7950.00,NULL,NULL,1,'2022-12-12 13:27:12','2022-12-12 13:27:12',NULL),(1383,8081,40731,298417,2,1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',24820.00,NULL,NULL,1,'2022-12-12 13:27:13','2022-12-12 13:27:13',NULL),(1384,8081,40731,298417,2,1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',45910.00,NULL,NULL,1,'2022-12-12 13:27:13','2022-12-12 13:27:13',NULL),(1385,8081,40731,298417,2,1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',72000.00,NULL,NULL,1,'2022-12-12 13:27:13','2022-12-12 13:27:13',NULL),(1386,8081,40731,298418,2,1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',401.07,NULL,NULL,1,'2022-12-12 13:27:31','2022-12-12 13:27:31',NULL),(1387,8081,40731,298418,2,1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',49950.00,NULL,NULL,1,'2022-12-12 13:27:31','2022-12-12 13:27:31',NULL),(1388,8081,40731,298418,2,1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',46000.00,NULL,NULL,1,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(1389,8081,40731,298418,2,1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',18905.00,NULL,NULL,1,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(1390,8081,40731,298418,2,1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',34275.00,NULL,NULL,1,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(1391,8081,40731,298418,2,1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',49950.00,NULL,NULL,1,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(1392,8081,40731,298418,2,1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',3300.00,NULL,NULL,1,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(1393,8081,40731,298418,2,1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',3300.00,NULL,NULL,1,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL);
INSERT INTO `balance_libro` VALUES (1394,8081,40731,298418,2,1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',4645.00,NULL,NULL,1,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(1395,8081,40731,298418,2,1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',18000.00,NULL,NULL,1,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(1396,8081,40731,298418,2,1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',53541.00,NULL,NULL,1,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(1397,8081,40731,298410,3,1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',46799.85,NULL,NULL,1,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(1398,8081,40731,298410,3,1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',17673.66,NULL,NULL,1,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(1399,8081,40731,298410,3,1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',426.23,NULL,NULL,1,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(1400,8081,40731,298410,3,1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',2392.90,NULL,NULL,1,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(1401,8081,40731,298410,3,1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',209.25,NULL,NULL,1,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(1402,8081,40731,298410,3,1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',1405.04,NULL,NULL,1,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(1403,8081,40731,298410,3,1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',0.00,NULL,NULL,1,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(1404,8081,40731,298411,3,1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-06','2022-02-06',18740.56,NULL,NULL,1,'2022-12-12 13:29:46','2022-12-12 13:29:46',NULL),(1405,8081,40731,298411,3,1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',22862.13,NULL,NULL,1,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(1406,8081,40731,298411,3,1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',22576.42,NULL,NULL,1,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(1407,8081,40731,298411,3,1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',22576.42,NULL,NULL,1,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(1408,8081,40731,298411,3,1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',456.15,NULL,NULL,1,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(1409,8081,40731,298411,3,1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',215.00,NULL,NULL,1,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(1410,8081,40731,298411,3,1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',64972.93,NULL,NULL,1,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(1411,8081,40731,298411,3,1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',6887.55,NULL,NULL,1,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(1412,8081,40731,298411,3,1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-20','2022-02-20',100.00,NULL,NULL,1,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(1413,8081,40731,298411,3,1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',2485.12,NULL,NULL,1,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(1414,8081,40731,298411,3,1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1510.21,NULL,NULL,1,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(1415,8081,40731,298412,3,1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',2156.10,NULL,NULL,1,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(1416,8081,40731,298412,3,1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',22744.91,NULL,NULL,1,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(1417,8081,40731,298412,3,1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',22606.64,NULL,NULL,1,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL);
INSERT INTO `balance_libro` VALUES (1418,8081,40731,298412,3,1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',30541.83,NULL,NULL,1,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(1419,8081,40731,298412,3,1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',492.29,NULL,NULL,1,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(1420,8081,40731,298412,3,1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',0.00,NULL,NULL,1,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(1421,8081,40731,298412,3,1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-20','2022-03-20',0.00,NULL,NULL,1,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(1422,8081,40731,298412,3,1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',72.00,NULL,NULL,1,'2022-12-12 13:30:01','2022-12-12 13:30:01',NULL),(1423,8081,40731,298412,3,1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',19831.87,NULL,NULL,1,'2022-12-12 13:30:01','2022-12-12 13:30:01',NULL),(1424,8081,40731,298412,3,1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1585.72,NULL,NULL,1,'2022-12-12 13:30:01','2022-12-12 13:30:01',NULL),(1425,8081,40731,298413,3,1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',49514.25,NULL,NULL,1,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(1426,8081,40731,298413,3,1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',21373.55,NULL,NULL,1,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(1427,8081,40731,298413,3,1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',20617.97,NULL,NULL,1,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(1428,8081,40731,298413,3,1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',492.29,NULL,NULL,1,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(1429,8081,40731,298413,3,1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',303.49,NULL,NULL,1,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(1430,8081,40731,298413,3,1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',30811.50,NULL,NULL,1,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(1431,8081,40731,298413,3,1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',2822.00,NULL,NULL,1,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(1432,8081,40731,298413,3,1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',14325.60,NULL,NULL,1,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(1433,8081,40731,298413,3,1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',4257.76,NULL,NULL,1,'2022-12-12 13:30:18','2022-12-12 13:30:18',NULL),(1434,8081,40731,298413,3,1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1803.07,NULL,NULL,1,'2022-12-12 13:30:18','2022-12-12 13:30:18',NULL),(1435,8081,40731,298413,3,1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',24383.74,NULL,NULL,1,'2022-12-12 13:30:18','2022-12-12 13:30:18',NULL),(1436,8081,40731,298414,3,1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',532.17,NULL,NULL,1,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(1437,8081,40731,298414,3,1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',240.20,NULL,NULL,1,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(1438,8081,40731,298414,3,1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',190.00,NULL,NULL,1,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(1439,8081,40731,298414,3,1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',20.00,NULL,NULL,1,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(1440,8081,40731,298414,3,1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-28','2022-05-28',1889.11,NULL,NULL,1,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(1441,8081,40731,298415,3,1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',11.51,NULL,NULL,1,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL);
INSERT INTO `balance_libro` VALUES (1442,8081,40731,298415,3,1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',31808.45,NULL,NULL,1,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(1443,8081,40731,298415,3,1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',1966.66,NULL,NULL,1,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(1444,8081,40731,298415,3,1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',1630.16,NULL,NULL,1,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(1445,8081,40731,298415,3,1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',4261.29,NULL,NULL,1,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(1446,8081,40731,298415,3,1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',59304.73,NULL,NULL,1,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(1447,8081,40731,298415,3,1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',29485.34,NULL,NULL,1,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(1448,8081,40731,298415,3,1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',29503.47,NULL,NULL,1,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(1449,8081,40731,298417,3,1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',92306.40,NULL,NULL,1,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(1450,8081,40731,298417,3,1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',6170.48,NULL,NULL,1,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(1451,8081,40731,298417,3,1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',103537.18,NULL,NULL,1,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(1452,8081,40731,298417,3,1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',649.32,NULL,NULL,1,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(1453,8081,40731,298417,3,1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',190.00,NULL,NULL,1,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(1454,8081,40731,298417,3,1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2235.34,NULL,NULL,1,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(1455,8081,40731,298418,3,1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',800.12,NULL,NULL,1,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(1456,8081,40731,298418,3,1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',9778.66,NULL,NULL,1,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(1457,8081,40731,298418,3,1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',32072.41,NULL,NULL,1,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(1458,8081,40731,298418,3,1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',13791.01,NULL,NULL,1,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(1459,8081,40731,298418,3,1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-11','2022-09-11',12.46,NULL,NULL,1,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(1460,8081,40731,298418,3,1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',3348.81,NULL,NULL,1,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(1461,8081,40731,298418,3,1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',430.00,NULL,NULL,1,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(1462,8081,40731,298418,3,1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',410.47,NULL,NULL,1,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(1463,8081,40731,298418,3,1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',8803.86,NULL,NULL,1,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(1464,8081,40731,298418,3,1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',10400.00,NULL,NULL,1,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(1465,8081,40731,298418,3,1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',124472.73,NULL,NULL,1,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL);
INSERT INTO `balance_libro` VALUES (1466,8081,41147,322665,2,1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',9500.00,NULL,NULL,1,'2022-12-12 13:36:08','2022-12-12 13:36:08',NULL),(1467,8081,41147,322665,2,1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',9500.00,NULL,NULL,1,'2022-12-12 13:36:08','2022-12-12 13:36:08',NULL),(1468,8081,41147,322665,2,1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',9500.00,NULL,NULL,1,'2022-12-12 13:36:08','2022-12-12 13:36:08',NULL),(1469,8081,41147,322665,2,1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',2000.00,NULL,NULL,1,'2022-12-12 13:36:08','2022-12-12 13:36:08',NULL),(1470,8081,41147,322665,2,1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',9800.00,NULL,NULL,1,'2022-12-12 13:36:08','2022-12-12 13:36:08',NULL),(1471,8081,41147,322665,2,1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',2500.00,NULL,NULL,1,'2022-12-12 13:36:08','2022-12-12 13:36:08',NULL),(1472,8081,41147,322665,2,1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',9500.00,NULL,NULL,1,'2022-12-12 13:36:09','2022-12-12 13:36:09',NULL),(1473,8081,41147,322665,2,1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',9500.00,NULL,NULL,1,'2022-12-12 13:36:09','2022-12-12 13:36:09',NULL),(1474,8081,41147,322665,2,1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',9800.00,NULL,NULL,1,'2022-12-12 13:36:09','2022-12-12 13:36:09',NULL),(1475,8081,41147,322665,2,1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',9800.00,NULL,NULL,1,'2022-12-12 13:36:09','2022-12-12 13:36:09',NULL),(1476,8081,41147,322665,2,1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',9200.00,NULL,NULL,1,'2022-12-12 13:36:09','2022-12-12 13:36:09',NULL),(1477,8081,41147,322665,2,1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',2600.00,NULL,NULL,1,'2022-12-12 13:36:09','2022-12-12 13:36:09',NULL),(1478,8081,41147,322666,2,1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',9800.00,NULL,NULL,1,'2022-12-12 13:36:37','2022-12-12 13:36:37',NULL),(1479,8081,41147,322666,2,1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',9500.00,NULL,NULL,1,'2022-12-12 13:36:37','2022-12-12 13:36:37',NULL),(1480,8081,41147,322666,2,1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',2000.00,NULL,NULL,1,'2022-12-12 13:36:38','2022-12-12 13:36:38',NULL),(1481,8081,41147,322666,2,1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',3500.00,NULL,NULL,1,'2022-12-12 13:36:38','2022-12-12 13:36:38',NULL),(1482,8081,41147,322666,2,1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',3500.00,NULL,NULL,1,'2022-12-12 13:36:38','2022-12-12 13:36:38',NULL),(1483,8081,41147,322666,2,1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',9600.00,NULL,NULL,1,'2022-12-12 13:36:38','2022-12-12 13:36:38',NULL),(1484,8081,41147,322667,2,1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',9200.00,NULL,NULL,1,'2022-12-12 13:36:58','2022-12-12 13:36:58',NULL),(1485,8081,41147,322667,2,1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',2500.00,NULL,NULL,1,'2022-12-12 13:36:58','2022-12-12 13:36:58',NULL),(1486,8081,41147,322667,2,1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',4000.00,NULL,NULL,1,'2022-12-12 13:36:59','2022-12-12 13:36:59',NULL),(1487,8081,41147,322667,2,1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',9500.00,NULL,NULL,1,'2022-12-12 13:36:59','2022-12-12 13:36:59',NULL),(1488,8081,41147,322667,2,1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',9800.00,NULL,NULL,1,'2022-12-12 13:36:59','2022-12-12 13:36:59',NULL),(1489,8081,41147,322667,2,1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2000.00,NULL,NULL,1,'2022-12-12 13:36:59','2022-12-12 13:36:59',NULL);
INSERT INTO `balance_libro` VALUES (1490,8081,41147,322668,2,1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',5000.00,NULL,NULL,1,'2022-12-12 13:37:14','2022-12-12 13:37:14',NULL),(1491,8081,41147,322668,2,1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',9800.00,NULL,NULL,1,'2022-12-12 13:37:14','2022-12-12 13:37:14',NULL),(1492,8081,41147,322668,2,1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',9500.00,NULL,NULL,1,'2022-12-12 13:37:14','2022-12-12 13:37:14',NULL),(1493,8081,41147,322668,2,1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',4000.00,NULL,NULL,1,'2022-12-12 13:37:14','2022-12-12 13:37:14',NULL),(1494,8081,41147,322668,2,1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',9000.00,NULL,NULL,1,'2022-12-12 13:37:14','2022-12-12 13:37:14',NULL),(1495,8081,41147,322669,2,1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',4000.00,NULL,NULL,1,'2022-12-12 13:37:29','2022-12-12 13:37:29',NULL),(1496,8081,41147,322669,2,1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',9500.00,NULL,NULL,1,'2022-12-12 13:37:29','2022-12-12 13:37:29',NULL),(1497,8081,41147,322669,2,1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',9500.00,NULL,NULL,1,'2022-12-12 13:37:29','2022-12-12 13:37:29',NULL),(1498,8081,41147,322669,2,1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',4500.00,NULL,NULL,1,'2022-12-12 13:37:29','2022-12-12 13:37:29',NULL),(1499,8081,41147,322669,2,1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',9800.00,NULL,NULL,1,'2022-12-12 13:37:29','2022-12-12 13:37:29',NULL),(1500,8081,41147,322670,2,1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',9500.00,NULL,NULL,1,'2022-12-12 13:37:45','2022-12-12 13:37:45',NULL),(1501,8081,41147,322670,2,1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',18500.00,NULL,NULL,1,'2022-12-12 13:37:45','2022-12-12 13:37:45',NULL),(1502,8081,41147,322670,2,1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',5000.00,NULL,NULL,1,'2022-12-12 13:37:45','2022-12-12 13:37:45',NULL),(1503,8081,41147,322671,2,1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',5000.00,NULL,NULL,1,'2022-12-12 13:37:59','2022-12-12 13:37:59',NULL),(1504,8081,41147,322671,2,1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',30000.00,NULL,NULL,1,'2022-12-12 13:37:59','2022-12-12 13:37:59',NULL),(1505,8081,41147,322671,2,1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2000.00,NULL,NULL,1,'2022-12-12 13:37:59','2022-12-12 13:37:59',NULL),(1506,8081,41147,322672,2,1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',3000.00,NULL,NULL,1,'2022-12-12 13:38:13','2022-12-12 13:38:13',NULL),(1507,8081,41147,322672,2,1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',30000.00,NULL,NULL,1,'2022-12-12 13:38:13','2022-12-12 13:38:13',NULL),(1508,8081,41068,293823,2,1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',20000.00,NULL,NULL,1,'2022-12-12 15:58:02','2022-12-12 15:58:02',NULL),(1509,8081,41068,293823,2,1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',2500.00,NULL,NULL,1,'2022-12-12 15:58:02','2022-12-12 15:58:02',NULL),(1510,8081,41068,293823,2,1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',22000.00,NULL,NULL,1,'2022-12-12 15:58:02','2022-12-12 15:58:02',NULL),(1511,8081,41068,293823,2,1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',26000.00,NULL,NULL,1,'2022-12-12 15:58:02','2022-12-12 15:58:02',NULL),(1512,8081,41068,293824,2,1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',30000.00,NULL,NULL,1,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL),(1513,8081,41068,293824,2,1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',25000.00,NULL,NULL,1,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL);
INSERT INTO `balance_libro` VALUES (1514,8081,41068,293824,2,1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',500.00,NULL,NULL,1,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL),(1515,8081,41068,293824,2,1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',6000.00,NULL,NULL,1,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL),(1516,8081,41068,293824,2,1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',7000.00,NULL,NULL,1,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL),(1517,8081,41068,293824,2,1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',2500.00,NULL,NULL,1,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL),(1518,8081,41068,293824,2,1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',5500.00,NULL,NULL,1,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL),(1519,8081,41068,293825,2,1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',2500.00,NULL,NULL,1,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(1520,8081,41068,293825,2,1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',10000.00,NULL,NULL,1,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(1521,8081,41068,293825,2,1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',16000.00,NULL,NULL,1,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(1522,8081,41068,293825,2,1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',2500.00,NULL,NULL,1,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(1523,8081,41068,293825,2,1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',10000.00,NULL,NULL,1,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(1524,8081,41068,293825,2,1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',30700.00,NULL,NULL,1,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(1525,8081,41068,293825,2,1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',8000.00,NULL,NULL,1,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(1526,8081,41068,293826,2,1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',24000.00,NULL,NULL,1,'2022-12-12 15:59:00','2022-12-12 15:59:00',NULL),(1527,8081,41068,293826,2,1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',3500.00,NULL,NULL,1,'2022-12-12 15:59:00','2022-12-12 15:59:00',NULL),(1528,8081,41068,293826,2,1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',20000.00,NULL,NULL,1,'2022-12-12 15:59:00','2022-12-12 15:59:00',NULL),(1529,8081,41068,293826,2,1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',40000.00,NULL,NULL,1,'2022-12-12 15:59:00','2022-12-12 15:59:00',NULL),(1530,8081,41068,293827,2,1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',39560.00,NULL,NULL,1,'2022-12-12 15:59:18','2022-12-12 15:59:18',NULL),(1531,8081,41068,293827,2,1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',2500.00,NULL,NULL,1,'2022-12-12 15:59:18','2022-12-12 15:59:18',NULL),(1532,8081,41068,293827,2,1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',2500.00,NULL,NULL,1,'2022-12-12 15:59:18','2022-12-12 15:59:18',NULL),(1533,8081,41068,293827,2,1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',22000.00,NULL,NULL,1,'2022-12-12 15:59:18','2022-12-12 15:59:18',NULL),(1534,8081,41068,293827,2,1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',10500.00,NULL,NULL,1,'2022-12-12 15:59:18','2022-12-12 15:59:18',NULL),(1535,8081,41068,293827,2,1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',22000.00,NULL,NULL,1,'2022-12-12 15:59:18','2022-12-12 15:59:18',NULL),(1536,8081,41068,293829,2,1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5000.00,NULL,NULL,1,'2022-12-12 16:00:12','2022-12-12 16:00:12',NULL),(1537,8081,41068,293829,2,1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',20000.00,NULL,NULL,1,'2022-12-12 16:00:12','2022-12-12 16:00:12',NULL);
INSERT INTO `balance_libro` VALUES (1538,8081,41068,293829,2,1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',20000.00,NULL,NULL,1,'2022-12-12 16:00:12','2022-12-12 16:00:12',NULL),(1539,8081,41068,293829,2,1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',16000.00,NULL,NULL,1,'2022-12-12 16:00:12','2022-12-12 16:00:12',NULL),(1540,8081,41068,293829,2,1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',50000.00,NULL,NULL,1,'2022-12-12 16:00:12','2022-12-12 16:00:12',NULL),(1541,8081,41068,293830,2,1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',21600.00,NULL,NULL,1,'2022-12-12 16:00:33','2022-12-12 16:00:33',NULL),(1542,8081,41068,293830,2,1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',10000.00,NULL,NULL,1,'2022-12-12 16:00:33','2022-12-12 16:00:33',NULL),(1543,8081,41068,293830,2,1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',12000.00,NULL,NULL,1,'2022-12-12 16:00:33','2022-12-12 16:00:33',NULL),(1544,8081,41068,293830,2,1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',80000.00,NULL,NULL,1,'2022-12-12 16:00:33','2022-12-12 16:00:33',NULL),(1545,8081,41068,293831,2,1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',10000.00,NULL,NULL,1,'2022-12-12 16:00:49','2022-12-12 16:00:49',NULL),(1546,8081,41068,293831,2,1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',25000.00,NULL,NULL,1,'2022-12-12 16:00:49','2022-12-12 16:00:49',NULL),(1547,8081,41068,293831,2,1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',11500.00,NULL,NULL,1,'2022-12-12 16:00:49','2022-12-12 16:00:49',NULL),(1548,8081,41068,293831,2,1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',4000.00,NULL,NULL,1,'2022-12-12 16:00:49','2022-12-12 16:00:49',NULL),(1549,8081,41068,293831,2,1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',20000.00,NULL,NULL,1,'2022-12-12 16:00:49','2022-12-12 16:00:49',NULL),(1550,8081,41068,293831,2,1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',41000.00,NULL,NULL,1,'2022-12-12 16:00:49','2022-12-12 16:00:49',NULL),(1551,8081,41068,293832,2,1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',33000.00,NULL,NULL,1,'2022-12-12 16:01:06','2022-12-12 16:01:06',NULL),(1552,8081,41068,293832,2,1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',18000.00,NULL,NULL,1,'2022-12-12 16:01:06','2022-12-12 16:01:06',NULL),(1553,8081,41068,293832,2,1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',26000.00,NULL,NULL,1,'2022-12-12 16:01:06','2022-12-12 16:01:06',NULL),(1554,8081,41068,293832,2,1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',14000.00,NULL,NULL,1,'2022-12-12 16:01:06','2022-12-12 16:01:06',NULL),(1555,8081,41068,293832,2,1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',6000.00,NULL,NULL,1,'2022-12-12 16:01:06','2022-12-12 16:01:06',NULL),(1556,8081,41068,293833,2,1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',6000.00,NULL,NULL,1,'2022-12-12 16:01:27','2022-12-12 16:01:27',NULL),(1557,8081,41068,293833,2,1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',18000.00,NULL,NULL,1,'2022-12-12 16:01:27','2022-12-12 16:01:27',NULL),(1558,8081,41068,293833,2,1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',18000.00,NULL,NULL,1,'2022-12-12 16:01:27','2022-12-12 16:01:27',NULL),(1559,8081,41068,293833,2,1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',70000.00,NULL,NULL,1,'2022-12-12 16:01:27','2022-12-12 16:01:27',NULL),(1560,8081,41068,293833,2,1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',10000.00,NULL,NULL,1,'2022-12-12 16:01:28','2022-12-12 16:01:28',NULL),(1561,8081,41068,293833,2,1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',20000.00,NULL,NULL,1,'2022-12-12 16:01:28','2022-12-12 16:01:28',NULL);
INSERT INTO `balance_libro` VALUES (1562,8081,41068,293833,2,1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',18000.00,NULL,NULL,1,'2022-12-12 16:01:28','2022-12-12 16:01:28',NULL),(1563,8081,41068,293833,2,1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',12000.00,NULL,NULL,1,'2022-12-12 16:01:28','2022-12-12 16:01:28',NULL),(1564,8081,41068,293823,3,1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',240.00,NULL,NULL,1,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(1565,8081,41068,293823,3,1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',3400.00,NULL,NULL,1,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(1566,8081,41068,293823,3,1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',900.00,NULL,NULL,1,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(1567,8081,41068,293823,3,1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',1496.85,NULL,NULL,1,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(1568,8081,41068,293823,3,1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',900.00,NULL,NULL,1,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(1569,8081,41068,293823,3,1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',12750.01,NULL,NULL,1,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(1570,8081,41068,293823,3,1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',1199.98,NULL,NULL,1,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(1571,8081,41068,293823,3,1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',899.99,NULL,NULL,1,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(1572,8081,41068,293823,3,1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',2399.97,NULL,NULL,1,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(1573,8081,41068,293823,3,1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',1750000.00,NULL,NULL,1,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(1574,8081,41068,293823,3,1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',300.00,NULL,NULL,1,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(1575,8081,41068,293823,3,1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',300.00,NULL,NULL,1,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(1576,8081,41068,293823,3,1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',599.99,NULL,NULL,1,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(1577,8081,41068,293823,3,1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',49.30,NULL,NULL,1,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(1578,8081,41068,293823,3,1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',49.30,NULL,NULL,1,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(1579,8081,41068,293823,3,1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',300.00,NULL,NULL,1,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(1580,8081,41068,293823,3,1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',1052.00,NULL,NULL,1,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(1581,8081,41068,293823,3,1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',1700.00,NULL,NULL,1,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(1582,8081,41068,293823,3,1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',9999.00,NULL,NULL,1,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(1583,8081,41068,293823,3,1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',300.00,NULL,NULL,1,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(1584,8081,41068,293823,3,1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',899.99,NULL,NULL,1,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(1585,8081,41068,293823,3,1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',1199.99,NULL,NULL,1,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL);
INSERT INTO `balance_libro` VALUES (1586,8081,41068,293823,3,1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',300.00,NULL,NULL,1,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(1587,8081,41068,293823,3,1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',599.99,NULL,NULL,1,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(1588,8081,41068,293823,3,1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',300.00,NULL,NULL,1,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(1589,8081,41068,293824,3,1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',599.99,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1590,8081,41068,293824,3,1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',300.00,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1591,8081,41068,293824,3,1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',644.80,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1592,8081,41068,293824,3,1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',900.00,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1593,8081,41068,293824,3,1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',129.90,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1594,8081,41068,293824,3,1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',1199.98,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1595,8081,41068,293824,3,1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',599.99,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1596,8081,41068,293824,3,1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',599.99,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1597,8081,41068,293824,3,1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',300.00,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1598,8081,41068,293824,3,1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',1199.99,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1599,8081,41068,293824,3,1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',899.99,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1600,8081,41068,293824,3,1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',599.99,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1601,8081,41068,293824,3,1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',303.42,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1602,8081,41068,293824,3,1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',599.99,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1603,8081,41068,293824,3,1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',90.40,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1604,8081,41068,293824,3,1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',350.00,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1605,8081,41068,293824,3,1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-20','2022-02-20',1572.00,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1606,8081,41068,293824,3,1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',899.99,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1607,8081,41068,293824,3,1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',1199.98,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1608,8081,41068,293824,3,1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',599.99,NULL,NULL,1,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(1609,8081,41068,293825,3,1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1199.98,NULL,NULL,1,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL);
INSERT INTO `balance_libro` VALUES (1610,8081,41068,293825,3,1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',163.00,NULL,NULL,1,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(1611,8081,41068,293825,3,1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',899.99,NULL,NULL,1,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(1612,8081,41068,293825,3,1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',300.00,NULL,NULL,1,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(1613,8081,41068,293825,3,1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',599.99,NULL,NULL,1,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(1614,8081,41068,293825,3,1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',645.00,NULL,NULL,1,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(1615,8081,41068,293825,3,1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',300.00,NULL,NULL,1,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(1616,8081,41068,293825,3,1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',300.00,NULL,NULL,1,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(1617,8081,41068,293825,3,1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',561.00,NULL,NULL,1,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(1618,8081,41068,293825,3,1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',300.00,NULL,NULL,1,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(1619,8081,41068,293825,3,1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',599.99,NULL,NULL,1,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(1620,8081,41068,293825,3,1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',1499.99,NULL,NULL,1,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(1621,8081,41068,293825,3,1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',11341.00,NULL,NULL,1,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(1622,8081,41068,293825,3,1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',81306.99,NULL,NULL,1,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(1623,8081,41068,293825,3,1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',2112.00,NULL,NULL,1,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(1624,8081,41068,293825,3,1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',1499.99,NULL,NULL,1,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(1625,8081,41068,293825,3,1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',600.00,NULL,NULL,1,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(1626,8081,41068,293825,3,1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',2399.99,NULL,NULL,1,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(1627,8081,41068,293825,3,1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',599.99,NULL,NULL,1,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(1628,8081,41068,293825,3,1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',81306.99,NULL,NULL,1,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(1629,8081,41068,293825,3,1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2550.00,NULL,NULL,1,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(1630,8081,41068,293826,3,1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',66.00,NULL,NULL,1,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(1631,8081,41068,293826,3,1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',68.00,NULL,NULL,1,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(1632,8081,41068,293826,3,1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',1800.00,NULL,NULL,1,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(1633,8081,41068,293826,3,1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',9350.01,NULL,NULL,1,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL);
INSERT INTO `balance_libro` VALUES (1634,8081,41068,293826,3,1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',900.00,NULL,NULL,1,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(1635,8081,41068,293826,3,1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',1700.00,NULL,NULL,1,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(1636,8081,41068,293826,3,1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',1512.00,NULL,NULL,1,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(1637,8081,41068,293826,3,1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',2550.00,NULL,NULL,1,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(1638,8081,41068,293826,3,1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',900.00,NULL,NULL,1,'2022-12-12 16:18:17','2022-12-12 16:18:17',NULL),(1639,8081,41068,293826,3,1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',6800.01,NULL,NULL,1,'2022-12-12 16:18:17','2022-12-12 16:18:17',NULL),(1640,8081,41068,293827,3,1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',303.42,NULL,NULL,1,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(1641,8081,41068,293827,3,1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',66.00,NULL,NULL,1,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(1642,8081,41068,293827,3,1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',68.00,NULL,NULL,1,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(1643,8081,41068,293827,3,1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',900.00,NULL,NULL,1,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(1644,8081,41068,293827,3,1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',1500.00,NULL,NULL,1,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(1645,8081,41068,293827,3,1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',900.00,NULL,NULL,1,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(1646,8081,41068,293827,3,1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',9350.01,NULL,NULL,1,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(1647,8081,41068,293827,3,1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',7644.01,NULL,NULL,1,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(1648,8081,41068,293827,3,1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',5100.00,NULL,NULL,1,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(1649,8081,41068,293827,3,1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',204.00,NULL,NULL,1,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(1650,8081,41068,293827,3,1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',231.00,NULL,NULL,1,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(1651,8081,41068,293827,3,1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',400.00,NULL,NULL,1,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(1652,8081,41068,293827,3,1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',850.00,NULL,NULL,1,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(1653,8081,41068,293827,3,1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',1232.00,NULL,NULL,1,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(1654,8081,41068,293827,3,1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',1700.11,NULL,NULL,1,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(1655,8081,41068,293827,3,1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',14158.00,NULL,NULL,1,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(1656,8081,41068,293827,3,1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',900.00,NULL,NULL,1,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(1657,8081,41068,293827,3,1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',5100.00,NULL,NULL,1,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL);
INSERT INTO `balance_libro` VALUES (1658,8081,41068,293827,3,1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-29','2022-05-29',9499.00,NULL,NULL,1,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(1659,8081,41068,293828,3,1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',3974.00,NULL,NULL,1,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(1660,8081,41068,293828,3,1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',900.00,NULL,NULL,1,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(1661,8081,41068,293828,3,1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',136.00,NULL,NULL,1,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(1662,8081,41068,293828,3,1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',7650.01,NULL,NULL,1,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(1663,8081,41068,293828,3,1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',1500.00,NULL,NULL,1,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(1664,8081,41068,293828,3,1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',4250.00,NULL,NULL,1,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(1665,8081,41068,293828,3,1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',1500.00,NULL,NULL,1,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(1666,8081,41068,293828,3,1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-20','2022-06-20',1872.00,NULL,NULL,1,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(1667,8081,41068,293828,3,1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',900.00,NULL,NULL,1,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(1668,8081,41068,293828,3,1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',1500.00,NULL,NULL,1,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(1669,8081,41068,293828,3,1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',2550.00,NULL,NULL,1,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(1670,8081,41068,293828,3,1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',3900.00,NULL,NULL,1,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(1671,8081,41068,293828,3,1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',5950.01,NULL,NULL,1,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(1672,8081,41068,293829,3,1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',900.00,NULL,NULL,1,'2022-12-12 16:19:35','2022-12-12 16:19:35',NULL),(1673,8081,41068,293829,3,1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',303.42,NULL,NULL,1,'2022-12-12 16:19:35','2022-12-12 16:19:35',NULL),(1674,8081,41068,293829,3,1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',163.00,NULL,NULL,1,'2022-12-12 16:19:35','2022-12-12 16:19:35',NULL),(1675,8081,41068,293829,3,1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',900.00,NULL,NULL,1,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(1676,8081,41068,293829,3,1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',900.00,NULL,NULL,1,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(1677,8081,41068,293829,3,1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',900.00,NULL,NULL,1,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(1678,8081,41068,293829,3,1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2400.00,NULL,NULL,1,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(1679,8081,41068,293829,3,1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',13600.01,NULL,NULL,1,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(1680,8081,41068,293829,3,1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',900.00,NULL,NULL,1,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(1681,8081,41068,293829,3,1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1500.00,NULL,NULL,1,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL);
INSERT INTO `balance_libro` VALUES (1682,8081,41068,293829,3,1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6800.01,NULL,NULL,1,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(1683,8081,41068,293829,3,1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2322.00,NULL,NULL,1,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(1684,8081,41068,293829,3,1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4250.00,NULL,NULL,1,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(1685,8081,41068,293829,3,1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5950.01,NULL,NULL,1,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(1686,8081,41068,293830,3,1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',303.42,NULL,NULL,1,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(1687,8081,41068,293830,3,1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',627.00,NULL,NULL,1,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(1688,8081,41068,293830,3,1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',136.00,NULL,NULL,1,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(1689,8081,41068,293830,3,1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',1800.00,NULL,NULL,1,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(1690,8081,41068,293830,3,1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',6200.40,NULL,NULL,1,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(1691,8081,41068,293830,3,1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-07','2022-08-07',279.65,NULL,NULL,1,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(1692,8081,41068,293830,3,1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',1500.00,NULL,NULL,1,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(1693,8081,41068,293830,3,1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',10200.01,NULL,NULL,1,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(1694,8081,41068,293830,3,1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',2000.01,NULL,NULL,1,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(1695,8081,41068,293830,3,1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',5100.00,NULL,NULL,1,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(1696,8081,41068,293830,3,1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',1000.00,NULL,NULL,1,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(1697,8081,41068,293830,3,1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',163.00,NULL,NULL,1,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(1698,8081,41068,293830,3,1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',231.00,NULL,NULL,1,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(1699,8081,41068,293830,3,1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',6262.00,NULL,NULL,1,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(1700,8081,41068,293830,3,1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',1000.00,NULL,NULL,1,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(1701,8081,41068,293830,3,1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',1722.00,NULL,NULL,1,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(1702,8081,41068,293830,3,1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',5599.98,NULL,NULL,1,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(1703,8081,41068,293830,3,1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',1000.00,NULL,NULL,1,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(1704,8081,41068,293830,3,1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',18632.00,NULL,NULL,1,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(1705,8081,41068,293830,3,1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',2849.99,NULL,NULL,1,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL);
INSERT INTO `balance_libro` VALUES (1706,8081,41068,293830,3,1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',0.01,NULL,NULL,1,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(1707,8081,41068,293830,3,1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',1000.00,NULL,NULL,1,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(1708,8081,41068,293831,3,1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',190.00,NULL,NULL,1,'2022-12-12 16:20:17','2022-12-12 16:20:17',NULL),(1709,8081,41068,293831,3,1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',12349.94,NULL,NULL,1,'2022-12-12 16:20:17','2022-12-12 16:20:17',NULL),(1710,8081,41068,293831,3,1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',10449.95,NULL,NULL,1,'2022-12-12 16:20:17','2022-12-12 16:20:17',NULL),(1711,8081,41068,293831,3,1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',4749.98,NULL,NULL,1,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(1712,8081,41068,293831,3,1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',190.00,NULL,NULL,1,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(1713,8081,41068,293831,3,1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',303.42,NULL,NULL,1,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(1714,8081,41068,293831,3,1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',1000.00,NULL,NULL,1,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(1715,8081,41068,293831,3,1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',3042.00,NULL,NULL,1,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(1716,8081,41068,293831,3,1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',13920.01,NULL,NULL,1,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(1717,8081,41068,293831,3,1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',1000.00,NULL,NULL,1,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(1718,8081,41068,293831,3,1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',900.00,NULL,NULL,1,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(1719,8081,41068,293831,3,1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',5699.97,NULL,NULL,1,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(1720,8081,41068,293831,3,1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',1000.00,NULL,NULL,1,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(1721,8081,41068,293831,3,1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2000.01,NULL,NULL,1,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(1722,8081,41068,293831,3,1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2849.99,NULL,NULL,1,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(1723,8081,41068,293832,3,1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',190.00,NULL,NULL,1,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(1724,8081,41068,293832,3,1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',9499.95,NULL,NULL,1,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(1725,8081,41068,293832,3,1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1000.00,NULL,NULL,1,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(1726,8081,41068,293832,3,1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1000.00,NULL,NULL,1,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(1727,8081,41068,293832,3,1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',400.00,NULL,NULL,1,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(1728,8081,41068,293832,3,1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',68.00,NULL,NULL,1,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(1729,8081,41068,293832,3,1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',214.92,NULL,NULL,1,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL);
INSERT INTO `balance_libro` VALUES (1730,8081,41068,293832,3,1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',5699.97,NULL,NULL,1,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(1731,8081,41068,293832,3,1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',2732.00,NULL,NULL,1,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(1732,8081,41068,293832,3,1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',3799.98,NULL,NULL,1,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(1733,8081,41068,293832,3,1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1000.00,NULL,NULL,1,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(1734,8081,41068,293832,3,1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1600.01,NULL,NULL,1,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(1735,8081,41068,293832,3,1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2849.99,NULL,NULL,1,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(1736,8081,41068,293832,3,1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',6649.97,NULL,NULL,1,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(1740,8081,41123,296890,8,1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',381.16,NULL,NULL,1,'2022-12-14 21:58:25','2022-12-14 21:58:25',NULL),(1741,8081,41123,296890,16,NULL,147,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',13468.56,NULL,NULL,1,'2022-12-14 22:21:13','2022-12-14 22:21:13',NULL),(1742,8081,41123,296889,16,NULL,120,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1427.22,NULL,NULL,1,'2022-12-14 22:22:27','2022-12-14 22:22:27',NULL),(1743,8081,41147,322673,2,1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',30000.00,NULL,NULL,1,'2022-12-15 17:18:47','2022-12-15 17:18:47',NULL),(1744,8081,41147,322673,2,1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',5000.00,NULL,NULL,1,'2022-12-15 17:18:47','2022-12-15 17:18:47',NULL),(1745,8081,41147,322674,2,1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',30000.00,NULL,NULL,1,'2022-12-15 17:19:05','2022-12-15 17:19:05',NULL),(1746,8081,41147,322674,2,1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',5000.00,NULL,NULL,1,'2022-12-15 17:19:05','2022-12-15 17:19:05',NULL),(1747,8081,41147,322674,2,1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',6000.00,NULL,NULL,1,'2022-12-15 17:19:05','2022-12-15 17:19:05',NULL),(1748,8081,41147,322675,2,1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',8000.00,NULL,NULL,1,'2022-12-15 17:19:21','2022-12-15 17:19:21',NULL),(1749,8081,41147,322675,2,1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',10000.00,NULL,NULL,1,'2022-12-15 17:19:21','2022-12-15 17:19:21',NULL),(1750,8081,41147,322675,2,1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',30000.00,NULL,NULL,1,'2022-12-15 17:19:21','2022-12-15 17:19:21',NULL),(1751,8081,41147,322666,3,1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',2593.48,NULL,NULL,1,'2022-12-15 17:20:13','2022-12-15 17:20:13',NULL),(1752,8081,41147,322668,3,1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',7885.00,NULL,NULL,1,'2022-12-15 17:21:09','2022-12-15 17:21:09',NULL),(1753,8081,41147,322668,3,1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',41.00,NULL,NULL,1,'2022-12-15 17:21:09','2022-12-15 17:21:09',NULL),(1754,8081,41147,322669,3,1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',33.35,NULL,NULL,1,'2022-12-15 17:21:27','2022-12-15 17:21:27',NULL),(1755,8081,41147,322672,3,1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',1745.00,NULL,NULL,1,'2022-12-15 17:22:41','2022-12-15 17:22:41',NULL),(1756,8081,40918,178700,2,1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3000.00,NULL,NULL,1,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL);
INSERT INTO `balance_libro` VALUES (1757,8081,40918,178700,2,1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2000.00,NULL,NULL,1,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(1758,8081,40918,178700,2,1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2000.00,NULL,NULL,1,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(1759,8081,40918,178700,2,1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3000.00,NULL,NULL,1,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(1760,8081,40918,178700,2,1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3000.00,NULL,NULL,1,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(1761,8081,40918,178700,2,1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3000.00,NULL,NULL,1,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(1762,8081,40918,178700,2,1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3000.00,NULL,NULL,1,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(1763,8081,40918,178700,2,1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3000.00,NULL,NULL,1,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(1764,8081,40918,178700,2,1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3000.00,NULL,NULL,1,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(1765,8081,40918,178700,2,1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',10000.00,NULL,NULL,1,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(1766,8081,40918,178700,2,1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',19700.00,NULL,NULL,1,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(1767,8081,40918,178700,2,1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1000.00,NULL,NULL,1,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(1768,8081,40918,178700,2,1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',5500.00,NULL,NULL,1,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(1769,8081,40918,178700,2,1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',8500.00,NULL,NULL,1,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(1770,8081,40918,178700,2,1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',9000.00,NULL,NULL,1,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(1771,8081,40918,178700,2,1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3000.00,NULL,NULL,1,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(1772,8081,40918,178700,2,1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',5000.00,NULL,NULL,1,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(1773,8081,40918,178700,2,1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',5000.00,NULL,NULL,1,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(1774,8081,40918,178700,2,1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',5000.00,NULL,NULL,1,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(1775,8081,40918,178700,2,1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3000.00,NULL,NULL,1,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(1776,8081,40918,178700,2,1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',5000.00,NULL,NULL,1,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(1777,8081,40918,178700,2,1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',17500.00,NULL,NULL,1,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(1778,8081,40918,178700,2,1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',6000.00,NULL,NULL,1,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(1779,8081,40918,178700,2,1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3000.00,NULL,NULL,1,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(1780,8081,40918,178700,2,1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2500.00,NULL,NULL,1,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL);
INSERT INTO `balance_libro` VALUES (1781,8081,40918,178700,3,1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',12152.00,NULL,NULL,1,'2023-01-09 13:11:55','2023-01-09 13:11:55',NULL),(1782,8081,40918,178700,3,1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',1135.00,NULL,NULL,1,'2023-01-09 13:11:55','2023-01-09 13:11:55',NULL),(1783,8081,40918,178700,3,1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',1405.94,NULL,NULL,1,'2023-01-09 13:11:55','2023-01-09 13:11:55',NULL),(1784,8081,40918,178700,3,1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',800.00,NULL,NULL,1,'2023-01-09 13:11:55','2023-01-09 13:11:55',NULL),(1785,8081,40731,9029,2,1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',584.36,NULL,NULL,1,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(1786,8081,40731,9029,2,1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',1937.00,NULL,NULL,1,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(1787,8081,40731,9029,2,1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',57720.00,NULL,NULL,1,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(1788,8081,40731,9029,2,1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',35133.00,NULL,NULL,1,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(1789,8081,40731,9029,2,1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',64250.00,NULL,NULL,1,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(1790,8081,40731,9029,2,1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',64250.00,NULL,NULL,1,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(1791,8081,40731,9029,2,1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',64250.00,NULL,NULL,1,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(1792,8081,40731,9029,2,1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',57825.00,NULL,NULL,1,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(1793,8081,40731,9029,3,1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',29623.43,NULL,NULL,1,'2023-01-09 13:19:47','2023-01-15 18:11:37','2023-01-15 18:11:37'),(1794,8081,40731,9029,3,1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',750.27,NULL,NULL,1,'2023-01-09 13:19:47','2023-01-15 18:23:37','2023-01-15 18:23:37'),(1795,8081,40731,9029,3,1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',703.46,NULL,NULL,1,'2023-01-09 13:19:47','2023-01-15 18:12:29','2023-01-15 18:12:29'),(1796,8081,40731,9029,3,1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',14890.91,NULL,NULL,1,'2023-01-09 13:19:47','2023-01-15 18:13:45','2023-01-15 18:13:45'),(1797,8081,40731,9029,3,1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',111177.50,NULL,NULL,1,'2023-01-09 13:19:47','2023-01-15 18:21:04','2023-01-15 18:21:04'),(1798,8081,40731,9029,3,1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',12630.00,NULL,NULL,1,'2023-01-09 13:19:47','2023-01-09 13:19:47',NULL),(1799,8081,40731,9029,3,1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',424.78,NULL,NULL,1,'2023-01-09 13:19:47','2023-01-09 13:19:47',NULL),(1800,8081,40731,9029,3,1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',23.70,NULL,NULL,1,'2023-01-09 13:19:47','2023-01-09 13:19:47',NULL),(1801,8081,40731,9029,3,1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',0.00,NULL,NULL,1,'2023-01-09 13:19:47','2023-01-09 13:19:47',NULL),(1802,8081,40731,298416,3,1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',595.73,NULL,NULL,1,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(1803,8081,40731,298416,3,1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3122.80,NULL,NULL,1,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(1804,8081,40731,298416,3,1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',15214.83,NULL,NULL,1,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL);
INSERT INTO `balance_libro` VALUES (1805,8081,40731,298416,3,1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',215.00,NULL,NULL,1,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(1806,8081,40731,298416,3,1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',88474.16,NULL,NULL,1,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(1807,8081,40731,298416,3,1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',59006.95,NULL,NULL,1,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(1808,8081,40731,298416,3,1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',1336.27,NULL,NULL,1,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(1809,8081,40731,298416,3,1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',21626.17,NULL,NULL,1,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(1810,8081,40731,298416,3,1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',28579.81,NULL,NULL,1,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(1811,8081,40731,298416,3,1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2900.01,NULL,NULL,1,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(1812,8081,41068,293834,2,1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',50000.00,NULL,NULL,1,'2023-01-09 13:29:06','2023-01-09 13:29:06',NULL),(1813,8081,41068,293834,2,1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',35000.00,NULL,NULL,1,'2023-01-09 13:29:06','2023-01-09 13:29:06',NULL),(1814,8081,41068,293834,2,1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',16000.00,NULL,NULL,1,'2023-01-09 13:29:06','2023-01-09 13:29:06',NULL),(1815,8081,41068,293834,2,1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',63000.00,NULL,NULL,1,'2023-01-09 13:29:06','2023-01-09 13:29:06',NULL),(1816,8081,41068,293834,3,1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1900.00,NULL,NULL,1,'2023-01-09 13:29:25','2023-01-09 13:29:25',NULL),(1817,8081,41068,293834,3,1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1000.00,NULL,NULL,1,'2023-01-09 13:29:25','2023-01-09 13:29:25',NULL),(1818,8081,41068,293834,3,1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',13582.00,NULL,NULL,1,'2023-01-09 13:29:25','2023-01-09 13:29:25',NULL),(1819,8081,41068,293834,3,1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',200.00,NULL,NULL,1,'2023-01-09 13:29:25','2023-01-09 13:29:25',NULL),(1820,8081,41068,293834,3,1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1000.00,NULL,NULL,1,'2023-01-09 13:29:25','2023-01-09 13:29:25',NULL),(1821,8081,41068,293834,3,1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',3799.98,NULL,NULL,1,'2023-01-09 13:29:25','2023-01-09 13:29:25',NULL),(1822,8081,41068,293834,3,1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',68.00,NULL,NULL,1,'2023-01-09 13:29:25','2023-01-09 13:29:25',NULL),(1823,8081,41068,293834,3,1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',424.78,NULL,NULL,1,'2023-01-09 13:29:25','2023-01-09 13:29:25',NULL),(1824,8081,41068,293834,3,1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1900.00,NULL,NULL,1,'2023-01-09 13:29:25','2023-01-09 13:29:25',NULL),(1825,8081,41068,293834,3,1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1600.01,NULL,NULL,1,'2023-01-09 13:29:25','2023-01-09 13:29:25',NULL),(1826,8081,41068,293834,3,1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',5291.19,NULL,NULL,1,'2023-01-09 13:29:25','2023-01-09 13:29:25',NULL),(1827,8081,41068,293834,3,1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',3200.01,NULL,NULL,1,'2023-01-09 13:29:25','2023-01-09 13:29:25',NULL),(1828,8081,41068,293834,3,1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',6649.97,NULL,NULL,1,'2023-01-09 13:29:25','2023-01-09 13:29:25',NULL);
INSERT INTO `balance_libro` VALUES (1829,8081,41068,293834,3,1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',2600.01,NULL,NULL,1,'2023-01-09 13:29:25','2023-01-09 13:29:25',NULL),(1830,8081,41068,293834,3,1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',9499.95,NULL,NULL,1,'2023-01-09 13:29:26','2023-01-09 13:29:26',NULL),(1831,8081,41068,293834,3,1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',272.00,NULL,NULL,1,'2023-01-09 13:29:26','2023-01-09 13:29:26',NULL),(1832,8081,41068,293834,3,1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',7960.01,NULL,NULL,1,'2023-01-09 13:29:26','2023-01-09 13:29:26',NULL),(1833,8081,41068,293834,3,1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',1600.01,NULL,NULL,1,'2023-01-09 13:29:26','2023-01-09 13:29:26',NULL),(1834,8081,41068,293834,3,1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3532.00,NULL,NULL,1,'2023-01-09 13:29:26','2023-01-09 13:29:26',NULL),(1835,8081,41068,293834,3,1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',2502.00,NULL,NULL,1,'2023-01-09 13:29:26','2023-01-09 13:29:26',NULL),(1836,8081,41068,293834,3,1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',10449.95,NULL,NULL,1,'2023-01-09 13:29:26','2023-01-09 13:29:26',NULL),(1837,8081,41068,293834,3,1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',1900.00,NULL,NULL,1,'2023-01-09 13:29:26','2023-01-09 13:29:26',NULL),(1838,8081,41068,293834,3,1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2299.99,NULL,NULL,1,'2023-01-09 13:29:26','2023-01-09 13:29:26',NULL),(1839,8081,41068,293834,3,1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',8300.54,NULL,NULL,1,'2023-01-09 13:29:26','2023-01-09 13:29:26',NULL),(1840,8081,41068,293834,3,1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2299.99,NULL,NULL,1,'2023-01-09 13:29:26','2023-01-09 13:29:26',NULL),(1841,8081,41068,293834,3,1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',12350.00,NULL,NULL,1,'2023-01-09 13:29:26','2023-01-09 13:29:26',NULL),(1842,8081,41068,293834,3,1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',20000.00,NULL,NULL,1,'2023-01-09 13:29:26','2023-01-09 13:29:26',NULL),(1843,8081,40720,1517,2,1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',230000.00,NULL,NULL,1,'2023-01-09 13:35:36','2023-01-09 13:35:36',NULL),(1844,8081,40720,1517,3,1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',697.11,NULL,NULL,1,'2023-01-09 13:36:05','2023-01-09 13:36:05',NULL),(1845,8081,40720,1517,3,1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',68.00,NULL,NULL,1,'2023-01-09 13:36:05','2023-01-09 13:36:05',NULL),(1846,8081,40720,1517,3,1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',584.00,NULL,NULL,1,'2023-01-09 13:36:05','2023-01-09 13:36:05',NULL),(1847,8081,40720,1517,3,1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1474.29,NULL,NULL,1,'2023-01-09 13:36:05','2023-01-09 13:36:05',NULL),(1848,8081,40720,1517,3,1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',53999.00,NULL,NULL,1,'2023-01-09 13:36:05','2023-01-09 13:36:05',NULL),(1849,8081,40720,1517,3,1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1500.00,NULL,NULL,1,'2023-01-09 13:36:05','2023-01-09 13:36:05',NULL),(1850,8081,40720,1517,3,1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',666.00,NULL,NULL,1,'2023-01-09 13:36:06','2023-01-09 13:36:06',NULL),(1851,8081,40720,1517,3,1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',59461.33,NULL,NULL,1,'2023-01-09 13:36:06','2023-01-09 13:36:06',NULL),(1852,8081,40720,1517,3,1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1012.00,NULL,NULL,1,'2023-01-09 13:36:06','2023-01-09 13:36:06',NULL);
INSERT INTO `balance_libro` VALUES (1853,8081,40997,263537,3,1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',3290.04,NULL,NULL,1,'2023-01-09 14:03:28','2023-01-09 14:03:28',NULL),(1854,8081,40997,263537,3,1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',3290.04,NULL,NULL,1,'2023-01-09 14:03:28','2023-01-09 14:03:28',NULL),(1855,8081,40997,263537,3,1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',24359.00,NULL,NULL,1,'2023-01-09 14:03:28','2023-01-09 14:03:28',NULL),(1856,8081,40997,263533,3,1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',2200.00,NULL,NULL,1,'2023-01-09 14:04:56','2023-01-09 14:04:56',NULL),(1857,8081,40997,263533,3,1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',6550.14,NULL,NULL,1,'2023-01-09 14:04:56','2023-01-09 14:04:56',NULL),(1858,8081,41123,296891,2,1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',81000.00,NULL,NULL,1,'2023-01-09 14:13:06','2023-01-09 14:13:06',NULL),(1859,8081,41123,296891,2,1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',78650.00,NULL,NULL,1,'2023-01-09 14:13:06','2023-01-09 14:13:06',NULL),(1860,8081,41123,296891,2,1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',46250.00,NULL,NULL,1,'2023-01-09 14:13:06','2023-01-09 14:13:06',NULL),(1861,8081,41123,296891,2,1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',9900.00,NULL,NULL,1,'2023-01-09 14:13:06','2023-01-09 14:13:06',NULL),(1862,8081,41123,296891,3,1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',17026.95,NULL,NULL,1,'2023-01-09 14:13:23','2023-01-09 14:13:23',NULL),(1863,8081,41123,296891,3,1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',163.00,NULL,NULL,1,'2023-01-09 14:13:23','2023-01-09 14:13:23',NULL),(1864,8081,41123,296891,3,1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',887.44,NULL,NULL,1,'2023-01-09 14:13:23','2023-01-09 14:13:23',NULL),(1865,8081,41123,296891,3,1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',338.77,NULL,NULL,1,'2023-01-09 14:13:23','2023-01-09 14:13:23',NULL),(1866,8081,41123,296891,3,1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2402.04,NULL,NULL,1,'2023-01-09 14:13:23','2023-01-09 14:13:23',NULL),(1867,8081,41123,296891,3,1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',1480.00,NULL,NULL,1,'2023-01-09 14:13:23','2023-01-09 14:13:23',NULL),(1868,8081,41123,296891,3,1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',270.00,NULL,NULL,1,'2023-01-09 14:13:23','2023-01-09 14:13:23',NULL),(1869,8081,41123,296891,3,1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',10500.00,NULL,NULL,1,'2023-01-09 14:13:24','2023-01-09 14:13:24',NULL),(1870,8081,41123,296891,3,1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',10622.66,NULL,NULL,1,'2023-01-09 14:13:24','2023-01-09 14:13:24',NULL),(1871,8081,40771,48412,2,1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',1800.00,NULL,NULL,1,'2023-01-09 14:27:26','2023-01-09 14:27:26',NULL),(1872,8081,40771,48412,2,1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',2000.00,NULL,NULL,1,'2023-01-09 14:27:26','2023-01-09 14:27:26',NULL),(1873,8081,40771,48412,2,1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',2000.00,NULL,NULL,1,'2023-01-09 14:27:26','2023-01-09 14:27:26',NULL),(1874,8081,40771,48412,2,1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',2000.00,NULL,NULL,1,'2023-01-09 14:27:26','2023-01-09 14:27:26',NULL),(1875,8081,40771,48412,2,1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',3800.00,NULL,NULL,1,'2023-01-09 14:27:26','2023-01-09 14:27:26',NULL),(1876,8081,40771,48412,2,1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',2400.00,NULL,NULL,1,'2023-01-09 14:27:26','2023-01-09 14:27:26',NULL);
INSERT INTO `balance_libro` VALUES (1877,8081,40771,48412,2,1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',2000.00,NULL,NULL,1,'2023-01-09 14:27:26','2023-01-09 14:27:26',NULL),(1878,8081,40771,48412,2,1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',2400.00,NULL,NULL,1,'2023-01-09 14:27:26','2023-01-09 14:27:26',NULL),(1879,8081,40771,48412,2,1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',2000.00,NULL,NULL,1,'2023-01-09 14:27:26','2023-01-09 14:27:26',NULL),(1880,8081,40771,48412,2,1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',2800.00,NULL,NULL,1,'2023-01-09 14:27:27','2023-01-09 14:27:27',NULL),(1881,8081,40771,48412,2,1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',1800.00,NULL,NULL,1,'2023-01-09 14:27:27','2023-01-09 14:27:27',NULL),(1882,8081,40771,48412,2,1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',6000.00,NULL,NULL,1,'2023-01-09 14:27:27','2023-01-09 14:27:27',NULL),(1883,8081,40771,48412,2,1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',2500.00,NULL,NULL,1,'2023-01-09 14:27:27','2023-01-09 14:27:27',NULL),(1884,8081,40771,48412,2,1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',2500.00,NULL,NULL,1,'2023-01-09 14:27:27','2023-01-09 14:27:27',NULL),(1885,8081,40771,48412,2,1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',5000.00,NULL,NULL,1,'2023-01-09 14:27:27','2023-01-09 14:27:27',NULL),(1886,8081,40771,48412,2,1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',2500.00,NULL,NULL,1,'2023-01-09 14:27:27','2023-01-09 14:27:27',NULL),(1887,8081,40771,48412,2,1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',7000.00,NULL,NULL,1,'2023-01-09 14:27:27','2023-01-09 14:27:27',NULL),(1888,8081,40771,48412,2,1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',5000.00,NULL,NULL,1,'2023-01-09 14:27:27','2023-01-09 14:27:27',NULL),(1889,8081,40771,48412,2,1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',2500.00,NULL,NULL,1,'2023-01-09 14:27:27','2023-01-09 14:27:27',NULL),(1890,8081,40771,48412,2,1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',2500.00,NULL,NULL,1,'2023-01-09 14:27:27','2023-01-09 14:27:27',NULL),(1891,8081,40771,48412,2,1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',2500.00,NULL,NULL,1,'2023-01-09 14:27:28','2023-01-09 14:27:28',NULL),(1892,8081,40771,48412,2,1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',16000.00,NULL,NULL,1,'2023-01-09 14:27:28','2023-01-09 14:27:28',NULL),(1893,8081,40771,48412,2,1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',2500.00,NULL,NULL,1,'2023-01-09 14:27:28','2023-01-09 14:27:28',NULL),(1894,8081,40771,48412,2,1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',2500.00,NULL,NULL,1,'2023-01-09 14:27:28','2023-01-09 14:27:28',NULL),(1895,8081,40771,48412,2,1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',2400.00,NULL,NULL,1,'2023-01-09 14:27:28','2023-01-09 14:27:28',NULL),(1896,8081,40771,48412,2,1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',21000.00,NULL,NULL,1,'2023-01-09 14:27:28','2023-01-09 14:27:28',NULL),(1897,8081,40771,48412,2,1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',2500.00,NULL,NULL,1,'2023-01-09 14:27:28','2023-01-09 14:27:28',NULL),(1898,8081,40771,48412,2,1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',5000.00,NULL,NULL,1,'2023-01-09 14:27:28','2023-01-09 14:27:28',NULL),(1899,8081,40771,48412,2,1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',1800.00,NULL,NULL,1,'2023-01-09 14:27:28','2023-01-09 14:27:28',NULL),(1900,8081,40771,48412,2,1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',1800.00,NULL,NULL,1,'2023-01-09 14:27:28','2023-01-09 14:27:28',NULL);
INSERT INTO `balance_libro` VALUES (1901,8081,40771,48412,2,1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',6000.00,NULL,NULL,1,'2023-01-09 14:27:28','2023-01-09 14:27:28',NULL),(1902,8081,40771,48412,2,1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',2500.00,NULL,NULL,1,'2023-01-09 14:27:28','2023-01-09 14:27:28',NULL),(1903,8081,40771,48412,2,1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',7000.00,NULL,NULL,1,'2023-01-09 14:27:28','2023-01-09 14:27:28',NULL),(1904,8081,40771,48412,2,1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',2400.00,NULL,NULL,1,'2023-01-09 14:27:29','2023-01-09 14:27:29',NULL),(1905,8081,40771,48412,2,1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',2000.00,NULL,NULL,1,'2023-01-09 14:27:29','2023-01-09 14:27:29',NULL),(1906,8081,40771,48412,2,1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',12600.00,NULL,NULL,1,'2023-01-09 14:27:29','2023-01-09 14:27:29',NULL),(1907,8081,40771,48412,2,1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',2000.00,NULL,NULL,1,'2023-01-09 14:27:29','2023-01-09 14:27:29',NULL),(1908,8081,40771,48412,2,1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',56000.00,NULL,NULL,1,'2023-01-09 14:27:29','2023-01-09 14:27:29',NULL),(1909,8081,40771,48412,2,1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',70400.00,NULL,NULL,1,'2023-01-09 14:27:29','2023-01-09 14:27:29',NULL),(1910,8081,40771,48413,2,1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1800.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1911,8081,40771,48413,2,1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',2000.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1912,8081,40771,48413,2,1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',2000.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1913,8081,40771,48413,2,1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2600.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1914,8081,40771,48413,2,1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',2000.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1915,8081,40771,48413,2,1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',2200.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1916,8081,40771,48413,2,1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3000.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1917,8081,40771,48413,2,1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',8000.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1918,8081,40771,48413,2,1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',3000.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1919,8081,40771,48413,2,1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',8500.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1920,8081,40771,48413,2,1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',3000.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1921,8081,40771,48413,2,1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',7500.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1922,8081,40771,48413,2,1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2500.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1923,8081,40771,48413,2,1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',5000.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1924,8081,40771,48413,2,1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2000.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL);
INSERT INTO `balance_libro` VALUES (1925,8081,40771,48413,2,1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2000.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1926,8081,40771,48413,2,1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',2500.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1927,8081,40771,48413,2,1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',2000.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1928,8081,40771,48413,2,1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',2500.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1929,8081,40771,48413,2,1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',2000.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1930,8081,40771,48413,2,1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',5000.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1931,8081,40771,48413,2,1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',3000.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1932,8081,40771,48413,2,1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2200.00,NULL,NULL,1,'2023-01-09 14:27:52','2023-01-09 14:27:52',NULL),(1933,8081,40771,48413,2,1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',5000.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1934,8081,40771,48413,2,1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',3000.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1935,8081,40771,48413,2,1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',3000.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1936,8081,40771,48413,2,1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',2600.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1937,8081,40771,48413,2,1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',2600.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1938,8081,40771,48413,2,1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2200.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1939,8081,40771,48413,2,1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2000.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1940,8081,40771,48413,2,1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2200.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1941,8081,40771,48413,2,1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',5000.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1942,8081,40771,48413,2,1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',5000.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1943,8081,40771,48413,2,1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3000.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1944,8081,40771,48413,2,1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2500.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1945,8081,40771,48413,2,1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2500.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1946,8081,40771,48413,2,1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3000.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1947,8081,40771,48413,2,1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',5000.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1948,8081,40771,48413,2,1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',5500.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL);
INSERT INTO `balance_libro` VALUES (1949,8081,40771,48413,2,1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',4000.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1950,8081,40771,48413,2,1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',9000.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1951,8081,40771,48413,2,1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3000.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1952,8081,40771,48413,2,1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3000.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1953,8081,40771,48413,2,1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3000.00,NULL,NULL,1,'2023-01-09 14:27:53','2023-01-09 14:27:53',NULL),(1954,8081,40771,48412,3,1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',3210.00,NULL,NULL,1,'2023-01-09 14:28:16','2023-01-09 14:28:16',NULL),(1955,8081,40771,48412,3,1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',3799.00,NULL,NULL,1,'2023-01-09 14:28:16','2023-01-09 14:28:16',NULL),(1956,8081,40771,48412,3,1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',2122.12,NULL,NULL,1,'2023-01-09 14:28:16','2023-01-09 14:28:16',NULL),(1957,8081,40771,48412,3,1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-13','2022-11-13',9000.00,NULL,NULL,1,'2023-01-09 14:28:16','2023-01-09 14:28:16',NULL),(1958,8081,40771,48412,3,1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',17998.56,NULL,NULL,1,'2023-01-09 14:28:16','2023-01-09 14:28:16',NULL),(1959,8081,40771,48412,3,1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',6840.00,NULL,NULL,1,'2023-01-09 14:28:16','2023-01-09 14:28:16',NULL),(1960,8081,40771,48412,3,1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',22250.00,NULL,NULL,1,'2023-01-09 14:28:16','2023-01-09 14:28:16',NULL),(1961,8081,40771,48412,3,1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',7000.00,NULL,NULL,1,'2023-01-09 14:28:16','2023-01-09 14:28:16',NULL),(1962,8081,40771,48412,3,1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',113220.00,NULL,NULL,1,'2023-01-09 14:28:16','2023-01-09 14:28:16',NULL),(1963,8081,40771,48412,3,1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',16000.00,NULL,NULL,1,'2023-01-09 14:28:16','2023-01-09 14:28:16',NULL),(1964,8081,40771,48413,3,1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',3358.14,NULL,NULL,1,'2023-01-09 14:28:54','2023-01-09 14:28:54',NULL),(1965,8081,40771,48413,3,1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',1248.40,NULL,NULL,1,'2023-01-09 14:28:54','2023-01-09 14:28:54',NULL),(1966,8081,40771,48413,3,1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',20625.00,NULL,NULL,1,'2023-01-09 14:28:54','2023-01-09 14:28:54',NULL),(1967,8081,40771,48413,3,1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',19078.90,NULL,NULL,1,'2023-01-09 14:28:54','2023-01-09 14:28:54',NULL),(1968,8081,41120,295346,2,1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',800.00,NULL,NULL,1,'2023-01-09 14:33:12','2023-01-09 14:33:12',NULL),(1969,8081,41120,295346,2,1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',4000.00,NULL,NULL,1,'2023-01-09 14:33:12','2023-01-09 14:33:12',NULL),(1970,8081,41120,295346,2,1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',1000.00,NULL,NULL,1,'2023-01-09 14:33:12','2023-01-09 14:33:12',NULL),(1971,8081,41120,295346,2,1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1600.00,NULL,NULL,1,'2023-01-09 14:33:12','2023-01-09 14:33:12',NULL),(1972,8081,41120,295346,2,1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1800.00,NULL,NULL,1,'2023-01-09 14:33:12','2023-01-09 14:33:12',NULL);
INSERT INTO `balance_libro` VALUES (1973,8081,41120,295346,2,1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',5500.00,NULL,NULL,1,'2023-01-09 14:33:12','2023-01-09 14:33:12',NULL),(1974,8081,41120,295346,2,1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',7500.00,NULL,NULL,1,'2023-01-09 14:33:12','2023-01-09 14:33:12',NULL),(1975,8081,41120,295346,2,1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2300.00,NULL,NULL,1,'2023-01-09 14:33:12','2023-01-09 14:33:12',NULL),(1976,8081,41120,295346,2,1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3000.00,NULL,NULL,1,'2023-01-09 14:33:12','2023-01-09 14:33:12',NULL),(1977,8081,41120,295346,2,1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',8000.00,NULL,NULL,1,'2023-01-09 14:33:12','2023-01-09 14:33:12',NULL),(1978,8081,41120,295346,2,1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',7500.00,NULL,NULL,1,'2023-01-09 14:33:12','2023-01-09 14:33:12',NULL),(1979,8081,41120,295346,2,1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2800.00,NULL,NULL,1,'2023-01-09 14:33:12','2023-01-09 14:33:12',NULL),(1980,8081,41120,295346,2,1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',41700.00,NULL,NULL,1,'2023-01-09 14:33:12','2023-01-09 14:33:12',NULL),(1981,8081,41120,295346,2,1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3000.00,NULL,NULL,1,'2023-01-09 14:33:12','2023-01-09 14:33:12',NULL),(1982,8081,41120,295346,2,1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3200.00,NULL,NULL,1,'2023-01-09 14:33:13','2023-01-09 14:33:13',NULL),(1983,8081,41120,295346,2,1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',8400.00,NULL,NULL,1,'2023-01-09 14:33:13','2023-01-09 14:33:13',NULL),(1984,8081,41120,295346,2,1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3850.00,NULL,NULL,1,'2023-01-09 14:33:13','2023-01-09 14:33:13',NULL),(1985,8081,41120,295346,2,1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2600.00,NULL,NULL,1,'2023-01-09 14:33:13','2023-01-09 14:33:13',NULL),(1986,8081,41120,295346,2,1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',6000.00,NULL,NULL,1,'2023-01-09 14:33:13','2023-01-09 14:33:13',NULL),(1987,8081,41120,295346,2,1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',7200.00,NULL,NULL,1,'2023-01-09 14:33:13','2023-01-09 14:33:13',NULL),(1988,8081,41120,295346,2,1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3600.00,NULL,NULL,1,'2023-01-09 14:33:13','2023-01-09 14:33:13',NULL),(1989,8081,41120,295346,3,1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',4693.50,NULL,NULL,1,'2023-01-09 14:33:38','2023-01-09 14:33:38',NULL),(1990,8081,40943,216575,2,1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',1000.00,NULL,NULL,1,'2023-01-09 14:54:33','2023-01-09 14:54:33',NULL),(1991,8081,40943,216575,2,1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',1000.00,NULL,NULL,1,'2023-01-09 14:54:33','2023-01-09 14:54:33',NULL),(1992,8081,40943,216575,2,1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',1000.00,NULL,NULL,1,'2023-01-09 14:54:33','2023-01-09 14:54:33',NULL),(1993,8081,40943,216575,2,1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',600.00,NULL,NULL,1,'2023-01-09 14:54:33','2023-01-09 14:54:33',NULL),(1994,8081,40943,216575,2,1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',41440.00,NULL,NULL,1,'2023-01-09 14:54:33','2023-01-09 14:54:33',NULL),(1995,8081,40943,216575,2,1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',76540.00,NULL,NULL,1,'2023-01-09 14:54:33','2023-01-09 14:54:33',NULL),(1996,8081,40943,216575,2,1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',2600.00,NULL,NULL,1,'2023-01-09 14:54:33','2023-01-09 14:54:33',NULL);
INSERT INTO `balance_libro` VALUES (1997,8081,40943,216575,2,1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',4680.00,NULL,NULL,1,'2023-01-09 14:54:33','2023-01-09 14:54:33',NULL),(1998,8081,40943,216575,2,1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',32380.00,NULL,NULL,1,'2023-01-09 14:54:33','2023-01-09 14:54:33',NULL),(1999,8081,40943,216575,2,1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3050.00,NULL,NULL,1,'2023-01-09 14:54:33','2023-01-09 14:54:33',NULL),(2000,8081,40943,216575,3,1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',543.00,NULL,NULL,1,'2023-01-09 14:54:52','2023-01-09 14:54:52',NULL),(2001,8081,40943,216575,3,1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',197.17,NULL,NULL,1,'2023-01-09 14:54:52','2023-01-09 14:54:52',NULL),(2002,8081,40943,216575,3,1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',39857.40,NULL,NULL,1,'2023-01-09 14:54:52','2023-01-09 14:54:52',NULL),(2003,8081,40943,216575,3,1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',1081.00,NULL,NULL,1,'2023-01-09 14:54:52','2023-01-09 14:54:52',NULL),(2004,8081,40943,216575,3,1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',1440.00,NULL,NULL,1,'2023-01-09 14:54:53','2023-01-09 14:54:53',NULL),(2005,8081,40943,216571,2,1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',1230.00,NULL,NULL,1,'2023-01-09 14:55:37','2023-01-09 14:55:37',NULL),(2006,8081,40943,216571,2,1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',10400.00,NULL,NULL,1,'2023-01-09 14:55:37','2023-01-09 14:55:37',NULL),(2007,8081,40943,216571,2,1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',2120.00,NULL,NULL,1,'2023-01-09 14:55:37','2023-01-09 14:55:37',NULL),(2008,8081,40943,216571,2,1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',4720.00,NULL,NULL,1,'2023-01-09 14:55:37','2023-01-09 14:55:37',NULL),(2009,8081,40943,216571,2,1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',1290.00,NULL,NULL,1,'2023-01-09 14:55:37','2023-01-09 14:55:37',NULL),(2010,8081,40943,216571,2,1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',5280.00,NULL,NULL,1,'2023-01-09 14:55:37','2023-01-09 14:55:37',NULL),(2011,8081,40943,216571,2,1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',12420.00,NULL,NULL,1,'2023-01-09 14:55:37','2023-01-09 14:55:37',NULL),(2012,8081,40943,216571,2,1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',16470.00,NULL,NULL,1,'2023-01-09 14:55:37','2023-01-09 14:55:37',NULL),(2013,8081,40943,216571,2,1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',14095.00,NULL,NULL,1,'2023-01-09 14:55:37','2023-01-09 14:55:37',NULL),(2014,8081,40943,216571,2,1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',14095.00,NULL,NULL,1,'2023-01-09 14:55:37','2023-01-09 14:55:37',NULL),(2015,8081,40943,216571,2,1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',850.00,NULL,NULL,1,'2023-01-09 14:55:37','2023-01-09 14:55:37',NULL),(2016,8081,40943,216571,2,1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',11480.00,NULL,NULL,1,'2023-01-09 14:55:37','2023-01-09 14:55:37',NULL),(2017,8081,40943,216571,2,1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',6560.00,NULL,NULL,1,'2023-01-09 14:55:37','2023-01-09 14:55:37',NULL),(2018,8081,40943,216571,2,1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',1200.00,NULL,NULL,1,'2023-01-09 14:55:37','2023-01-09 14:55:37',NULL),(2019,8081,40943,216571,2,1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',5720.00,NULL,NULL,1,'2023-01-09 14:55:37','2023-01-09 14:55:37',NULL),(2020,8081,40943,216571,2,1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',21200.00,NULL,NULL,1,'2023-01-09 14:55:37','2023-01-09 14:55:37',NULL);
INSERT INTO `balance_libro` VALUES (2021,8081,40866,99920,2,1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',7590.00,NULL,NULL,1,'2023-01-09 15:00:31','2023-01-09 15:00:31',NULL),(2022,8081,40866,99920,2,1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',12800.00,NULL,NULL,1,'2023-01-09 15:00:31','2023-01-09 15:00:31',NULL),(2023,8081,40866,99920,2,1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',10650.00,NULL,NULL,1,'2023-01-09 15:00:31','2023-01-09 15:00:31',NULL),(2024,8081,40866,99920,2,1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',19890.00,NULL,NULL,1,'2023-01-09 15:00:31','2023-01-09 15:00:31',NULL),(2025,8081,40866,99920,2,1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',10650.00,NULL,NULL,1,'2023-01-09 15:00:31','2023-01-09 15:00:31',NULL),(2026,8081,40866,99920,2,1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',16230.00,NULL,NULL,1,'2023-01-09 15:00:31','2023-01-09 15:00:31',NULL),(2027,8081,40866,99920,2,1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',11630.00,NULL,NULL,1,'2023-01-09 15:00:31','2023-01-09 15:00:31',NULL),(2028,8081,40866,99920,2,2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',10430.00,NULL,NULL,1,'2023-01-09 15:00:31','2023-01-09 15:00:31',NULL),(2029,8081,40866,99920,2,2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',21500.00,NULL,NULL,1,'2023-01-09 15:00:31','2023-01-09 15:00:31',NULL),(2030,8081,40866,99920,2,2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',11990.00,NULL,NULL,1,'2023-01-09 15:00:31','2023-01-09 15:00:31',NULL),(2031,8081,40866,99920,2,2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',11100.00,NULL,NULL,1,'2023-01-09 15:00:31','2023-01-09 15:00:31',NULL),(2032,8081,40866,99920,2,2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',16100.00,NULL,NULL,1,'2023-01-09 15:00:31','2023-01-09 15:00:31',NULL),(2033,8081,40866,99920,2,2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',19650.00,NULL,NULL,1,'2023-01-09 15:00:31','2023-01-09 15:00:31',NULL),(2034,8081,40866,99920,2,2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',12500.00,NULL,NULL,1,'2023-01-09 15:00:31','2023-01-09 15:00:31',NULL),(2035,8081,40866,99920,2,2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',13200.00,NULL,NULL,1,'2023-01-09 15:00:32','2023-01-09 15:00:32',NULL),(2036,8081,40866,99920,2,2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',12800.00,NULL,NULL,1,'2023-01-09 15:00:32','2023-01-09 15:00:32',NULL),(2037,8081,40866,99920,2,2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',13800.00,NULL,NULL,1,'2023-01-09 15:00:32','2023-01-09 15:00:32',NULL),(2038,8081,40866,99920,2,2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',6800.00,NULL,NULL,1,'2023-01-09 15:00:32','2023-01-09 15:00:32',NULL),(2039,8081,40866,99920,2,2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',7200.00,NULL,NULL,1,'2023-01-09 15:00:32','2023-01-09 15:00:32',NULL),(2040,8081,40866,99920,2,2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',11000.00,NULL,NULL,1,'2023-01-09 15:00:32','2023-01-09 15:00:32',NULL),(2041,8081,40866,99920,2,2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',8500.00,NULL,NULL,1,'2023-01-09 15:00:32','2023-01-09 15:00:32',NULL),(2042,8081,40866,99920,2,2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',8500.00,NULL,NULL,1,'2023-01-09 15:00:32','2023-01-09 15:00:32',NULL),(2043,8081,40866,99920,2,2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',8500.00,NULL,NULL,1,'2023-01-09 15:00:32','2023-01-09 15:00:32',NULL),(2044,8081,40866,99920,2,2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',6000.00,NULL,NULL,1,'2023-01-09 15:00:32','2023-01-09 15:00:32',NULL);
INSERT INTO `balance_libro` VALUES (2045,8081,40866,99920,2,2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',4500.00,NULL,NULL,1,'2023-01-09 15:00:32','2023-01-09 15:00:32',NULL),(2046,8081,40866,99920,2,2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',6500.00,NULL,NULL,1,'2023-01-09 15:00:32','2023-01-09 15:00:32',NULL),(2047,8081,40866,99920,2,2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',5500.00,NULL,NULL,1,'2023-01-09 15:00:32','2023-01-09 15:00:32',NULL),(2048,8081,40866,99920,2,2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',5000.00,NULL,NULL,1,'2023-01-09 15:00:32','2023-01-09 15:00:32',NULL),(2049,8081,40866,99920,2,2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',6000.00,NULL,NULL,1,'2023-01-09 15:00:32','2023-01-09 15:00:32',NULL),(2050,8081,40866,99920,2,2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',10860.00,NULL,NULL,1,'2023-01-09 15:00:32','2023-01-09 15:00:32',NULL),(2051,8081,40866,99920,2,2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',5000.00,NULL,NULL,1,'2023-01-09 15:00:32','2023-01-09 15:00:32',NULL),(2052,8081,40866,99920,2,2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',5000.00,NULL,NULL,1,'2023-01-09 15:00:32','2023-01-09 15:00:32',NULL),(2053,8081,40866,99920,3,2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',26722.15,NULL,NULL,1,'2023-01-09 15:00:50','2023-01-09 15:00:50',NULL),(2054,8081,40866,99920,3,2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',211.63,NULL,NULL,1,'2023-01-09 15:00:50','2023-01-09 15:00:50',NULL),(2055,8081,40866,99920,3,2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',26484.63,NULL,NULL,1,'2023-01-09 15:00:50','2023-01-09 15:00:50',NULL),(2056,8081,40866,99920,3,2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',4785.07,NULL,NULL,1,'2023-01-09 15:00:50','2023-01-09 15:00:50',NULL),(2057,8081,40866,99920,3,2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',17351.99,NULL,NULL,1,'2023-01-09 15:00:50','2023-01-09 15:00:50',NULL),(2058,8081,40866,99920,3,2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',33067.79,NULL,NULL,1,'2023-01-09 15:00:50','2023-01-09 15:00:50',NULL),(2059,8081,40866,99920,3,2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',38690.00,NULL,NULL,1,'2023-01-09 15:00:50','2023-01-09 15:00:50',NULL),(2060,8081,40866,99919,2,2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',20106.01,NULL,NULL,1,'2023-01-09 15:01:12','2023-01-09 15:01:12',NULL),(2061,8081,40866,99919,2,2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',1499.07,NULL,NULL,1,'2023-01-09 15:01:12','2023-01-09 15:01:12',NULL),(2062,8081,40866,99919,2,2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',9447.99,NULL,NULL,1,'2023-01-09 15:01:12','2023-01-09 15:01:12',NULL),(2063,8081,40866,99919,2,2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',54829.11,NULL,NULL,1,'2023-01-09 15:01:12','2023-01-09 15:01:12',NULL),(2064,8081,40866,99919,2,2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',20075.00,NULL,NULL,1,'2023-01-09 15:01:12','2023-01-09 15:01:12',NULL),(2065,8081,40866,99919,2,2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',899.01,NULL,NULL,1,'2023-01-09 15:01:12','2023-01-09 15:01:12',NULL),(2066,8081,40866,99919,2,2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',10457.99,NULL,NULL,1,'2023-01-09 15:01:12','2023-01-09 15:01:12',NULL),(2067,8081,40866,99919,3,2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',20106.01,NULL,NULL,1,'2023-01-09 15:01:40','2023-01-09 15:01:40',NULL),(2068,8081,40866,99919,3,2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',1499.07,NULL,NULL,1,'2023-01-09 15:01:40','2023-01-09 15:01:40',NULL);
INSERT INTO `balance_libro` VALUES (2069,8081,40866,99919,3,2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',9447.99,NULL,NULL,1,'2023-01-09 15:01:40','2023-01-09 15:01:40',NULL),(2070,8081,40866,99919,3,2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',54829.11,NULL,NULL,1,'2023-01-09 15:01:40','2023-01-09 15:01:40',NULL),(2071,8081,40866,99919,3,2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',20075.00,NULL,NULL,1,'2023-01-09 15:01:40','2023-01-09 15:01:40',NULL),(2072,8081,40866,99919,3,2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',899.01,NULL,NULL,1,'2023-01-09 15:01:40','2023-01-09 15:01:40',NULL),(2073,8081,40866,99919,3,2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',10457.99,NULL,NULL,1,'2023-01-09 15:01:40','2023-01-09 15:01:40',NULL),(2075,8081,40731,9029,3,1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',29623.43,NULL,NULL,1,'2023-01-15 18:11:37','2023-01-15 18:11:37',NULL),(2076,8081,40731,9029,3,1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',703.46,NULL,NULL,1,'2023-01-15 18:12:29','2023-01-15 18:12:29',NULL),(2077,8081,40731,9029,3,1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',14890.91,NULL,NULL,1,'2023-01-15 18:13:45','2023-01-15 18:13:45',NULL),(2078,8081,40731,9029,3,1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',111177.50,NULL,NULL,1,'2023-01-15 18:21:04','2023-01-15 18:21:04',NULL),(2079,8081,40731,9029,3,1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',750.27,NULL,NULL,1,'2023-01-15 18:23:37','2023-01-15 18:23:37',NULL),(2082,8081,40731,9029,16,NULL,178,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',11506.80,NULL,NULL,1,'2023-01-15 18:46:07','2023-01-15 18:46:07',NULL),(2083,8081,41360,365498,2,2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',21500.00,NULL,NULL,1,'2023-01-31 01:22:49','2023-01-31 01:22:49',NULL),(2084,8081,41360,365498,2,2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',21000.00,NULL,NULL,1,'2023-01-31 01:22:49','2023-01-31 01:22:49',NULL),(2085,8081,41360,365498,2,2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',12220.00,NULL,NULL,1,'2023-01-31 01:22:49','2023-01-31 01:22:49',NULL),(2086,8081,41360,365498,2,2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',21000.00,NULL,NULL,1,'2023-01-31 01:22:49','2023-01-31 01:22:49',NULL),(2087,8081,41360,365498,2,2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',21250.00,NULL,NULL,1,'2023-01-31 01:22:49','2023-01-31 01:22:49',NULL),(2088,8081,41360,365498,2,2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',37498.00,NULL,NULL,1,'2023-01-31 01:22:49','2023-01-31 01:22:49',NULL),(2089,8081,41360,365498,2,2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',42350.00,NULL,NULL,1,'2023-01-31 01:22:49','2023-01-31 01:22:49',NULL),(2090,8081,41360,365498,2,2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',14100.00,NULL,NULL,1,'2023-01-31 01:22:49','2023-01-31 01:22:49',NULL),(2091,8081,41360,365498,2,2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',29650.00,NULL,NULL,1,'2023-01-31 01:22:50','2023-01-31 01:22:50',NULL),(2092,8081,41360,365498,2,2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',18700.00,NULL,NULL,1,'2023-01-31 01:22:50','2023-01-31 01:22:50',NULL),(2093,8081,41360,365498,2,2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',9160.00,NULL,NULL,1,'2023-01-31 01:22:50','2023-01-31 01:22:50',NULL),(2094,8081,41360,365498,2,2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',5500.00,NULL,NULL,1,'2023-01-31 01:22:50','2023-01-31 01:22:50',NULL),(2095,8081,41360,365498,2,2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',6500.00,NULL,NULL,1,'2023-01-31 01:22:50','2023-01-31 01:22:50',NULL);
INSERT INTO `balance_libro` VALUES (2096,8081,41360,365498,2,2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3025.00,NULL,NULL,1,'2023-01-31 01:22:50','2023-01-31 01:22:50',NULL),(2097,8081,41360,365498,2,2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',18499.00,NULL,NULL,1,'2023-01-31 01:22:50','2023-01-31 01:22:50',NULL),(2098,8081,41360,365498,2,2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',6500.00,NULL,NULL,1,'2023-01-31 01:22:50','2023-01-31 01:22:50',NULL),(2099,8081,40731,9030,2,2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',52000.00,NULL,NULL,1,'2023-02-17 22:42:58','2023-02-17 22:42:58',NULL),(2100,8081,40731,9030,2,2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',65000.00,NULL,NULL,1,'2023-02-17 22:42:58','2023-02-17 22:42:58',NULL),(2101,8081,40731,9030,2,2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',69990.00,NULL,NULL,1,'2023-02-17 22:42:58','2023-02-21 15:57:13','2023-02-21 15:57:13'),(2102,8081,40731,9030,2,2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',31260.00,NULL,NULL,1,'2023-02-17 22:42:58','2023-02-21 15:57:00','2023-02-21 15:57:00'),(2103,8081,40731,9030,2,2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',88000.00,NULL,NULL,1,'2023-02-17 22:42:58','2023-02-21 15:56:48','2023-02-21 15:56:48'),(2104,8081,40731,9030,3,2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',70749.63,NULL,NULL,1,'2023-02-17 22:43:17','2023-02-17 22:47:28','2023-02-17 22:47:28'),(2105,8081,40731,9030,3,2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7241.00,NULL,NULL,1,'2023-02-17 22:43:17','2023-02-17 22:43:17',NULL),(2106,8081,40731,9030,3,2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7241.00,NULL,NULL,1,'2023-02-17 22:43:17','2023-02-17 22:43:17',NULL),(2107,8081,40731,9030,3,2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2767.00,NULL,NULL,1,'2023-02-17 22:43:17','2023-02-17 22:43:17',NULL),(2108,8081,40731,9030,3,2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5518.68,NULL,NULL,1,'2023-02-17 22:43:17','2023-02-17 22:45:45','2023-02-17 22:45:45'),(2109,8081,40731,9030,3,2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',9630.00,NULL,NULL,1,'2023-02-17 22:43:17','2023-02-21 16:24:51','2023-02-21 16:24:51'),(2110,8081,40731,9030,3,2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',750.27,NULL,NULL,1,'2023-02-17 22:43:18','2023-02-17 22:47:57','2023-02-17 22:47:57'),(2111,8081,40731,9030,3,2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',40395.77,NULL,NULL,1,'2023-02-17 22:43:18','2023-02-17 22:46:11','2023-02-17 22:46:11'),(2112,8081,40731,9030,3,2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',21463.78,NULL,NULL,1,'2023-02-17 22:43:18','2023-02-17 22:48:29','2023-02-17 22:48:29'),(2113,8081,40731,9030,3,2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',21131.77,NULL,NULL,1,'2023-02-17 22:43:18','2023-02-17 22:46:41','2023-02-17 22:46:41'),(2114,8081,40731,9030,3,2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',94887.43,NULL,NULL,1,'2023-02-17 22:43:18','2023-02-17 22:49:00','2023-02-17 22:49:00'),(2115,8081,40731,9030,3,2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5518.68,NULL,NULL,1,'2023-02-17 22:45:45','2023-02-21 16:00:50','2023-02-21 16:00:50'),(2116,8081,40731,9030,3,2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',41572.35,NULL,NULL,1,'2023-02-17 22:46:11','2023-02-21 16:00:23','2023-02-21 16:00:23'),(2117,8081,40731,9030,3,2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',21131.77,NULL,NULL,1,'2023-02-17 22:46:41','2023-02-21 15:59:43','2023-02-21 15:59:43'),(2118,8081,40731,9030,3,2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',70749.64,NULL,NULL,1,'2023-02-17 22:47:28','2023-02-17 22:47:28',NULL);
INSERT INTO `balance_libro` VALUES (2119,8081,40731,9030,3,2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',750.27,NULL,NULL,1,'2023-02-17 22:47:57','2023-02-21 16:00:34','2023-02-21 16:00:34'),(2120,8081,40731,9030,3,2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',22088.94,NULL,NULL,1,'2023-02-17 22:48:29','2023-02-21 15:59:52','2023-02-21 15:59:52'),(2121,8081,40731,9030,3,2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',94887.42,NULL,NULL,1,'2023-02-17 22:49:00','2023-02-21 15:59:24','2023-02-21 15:59:24'),(2123,8081,40731,9030,8,2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',44.16,NULL,NULL,1,'2023-02-17 22:58:04','2023-02-17 22:58:04',NULL),(2124,8081,40731,9030,8,2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',339.84,NULL,NULL,1,'2023-02-17 22:58:04','2023-02-17 22:58:04',NULL),(2125,8081,40731,9030,16,NULL,192,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',10076.07,NULL,NULL,1,'2023-02-17 23:01:56','2023-02-17 23:04:14','2023-02-17 23:04:14'),(2126,8081,40731,9030,16,NULL,192,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',10076.07,NULL,NULL,1,'2023-02-19 19:32:12','2023-02-21 15:56:25','2023-02-21 15:56:25'),(2127,8081,40720,1518,2,2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',200000.00,NULL,NULL,1,'2023-02-20 00:39:39','2023-02-20 00:39:39',NULL),(2130,8081,40720,1518,8,2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.00,NULL,NULL,1,'2023-02-20 00:47:34','2023-02-20 00:47:42','2023-02-20 00:47:42'),(2131,8081,40731,9030,2,2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',88000.00,NULL,NULL,1,'2023-02-21 15:56:48','2023-02-21 15:56:48',NULL),(2132,8081,40731,9030,2,2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',31260.00,NULL,NULL,1,'2023-02-21 15:57:00','2023-02-21 15:57:00',NULL),(2133,8081,40731,9030,2,2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',69990.00,NULL,NULL,1,'2023-02-21 15:57:13','2023-02-21 15:57:13',NULL),(2134,8081,40731,9030,3,2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',94887.42,NULL,NULL,1,'2023-02-21 15:59:24','2023-02-21 15:59:24',NULL),(2135,8081,40731,9030,3,2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',21131.77,NULL,NULL,1,'2023-02-21 15:59:43','2023-02-21 15:59:43',NULL),(2136,8081,40731,9030,3,2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',22088.94,NULL,NULL,1,'2023-02-21 15:59:52','2023-02-21 15:59:52',NULL),(2137,8081,40731,9030,3,2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',41572.35,NULL,NULL,1,'2023-02-21 16:00:23','2023-02-21 16:00:23',NULL),(2138,8081,40731,9030,3,2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',750.27,NULL,NULL,1,'2023-02-21 16:00:34','2023-02-21 16:00:34',NULL),(2139,8081,40731,9030,3,2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5518.68,NULL,NULL,1,'2023-02-21 16:00:50','2023-02-21 16:00:50',NULL),(2140,8081,40731,9030,3,2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',9630.00,NULL,NULL,1,'2023-02-21 16:24:51','2023-02-21 16:24:51',NULL),(2141,8081,40731,9030,16,NULL,220,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',10076.07,NULL,NULL,1,'2023-02-21 16:25:12','2023-02-21 16:25:12',NULL),(2142,8081,41123,296895,2,2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',105800.00,NULL,NULL,1,'2023-02-21 16:46:08','2023-02-21 16:46:08',NULL),(2143,8081,41123,296895,2,2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',102300.00,NULL,NULL,1,'2023-02-21 16:46:09','2023-02-21 16:46:09',NULL),(2144,8081,41123,296895,2,2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',7000.00,NULL,NULL,1,'2023-02-21 16:46:09','2023-02-21 16:46:09',NULL),(2145,8081,41147,322676,2,2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',5000.00,NULL,NULL,1,'2023-02-27 01:08:06','2023-02-27 01:08:06',NULL);
INSERT INTO `balance_libro` VALUES (2146,8081,41147,322676,2,2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',13000.00,NULL,NULL,1,'2023-02-27 01:08:07','2023-02-27 01:08:07',NULL),(2147,8081,41147,322676,2,2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',30000.00,NULL,NULL,1,'2023-02-27 01:08:07','2023-02-27 01:08:07',NULL),(2148,8081,41147,322676,2,2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',6000.00,NULL,NULL,1,'2023-02-27 01:08:07','2023-02-27 01:08:07',NULL),(2149,8081,40720,1518,3,2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',697.11,NULL,NULL,1,'2023-02-27 12:38:01','2023-02-27 12:38:01',NULL),(2150,8081,40720,1518,3,2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',856.00,NULL,NULL,1,'2023-02-27 12:38:01','2023-02-27 12:38:01',NULL),(2151,8081,40720,1518,3,2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1331.24,NULL,NULL,1,'2023-02-27 12:38:01','2023-02-27 12:38:01',NULL),(2152,8081,40720,1518,3,2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1500.00,NULL,NULL,1,'2023-02-27 12:38:01','2023-02-27 12:38:01',NULL),(2153,8081,40720,1518,3,2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',462.00,NULL,NULL,1,'2023-02-27 12:38:01','2023-02-27 12:38:01',NULL),(2154,8081,40720,1518,3,2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',12655.00,NULL,NULL,1,'2023-02-27 12:38:01','2023-02-27 12:38:01',NULL),(2155,8081,40720,1518,3,2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1132.00,NULL,NULL,1,'2023-02-27 12:38:01','2023-02-27 12:38:01',NULL),(2156,8081,40720,1518,3,2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',64677.59,NULL,NULL,1,'2023-02-27 12:38:02','2023-02-27 12:38:02',NULL),(2157,8081,40720,1518,3,2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',33375.81,NULL,NULL,1,'2023-02-27 12:38:02','2023-02-27 12:38:02',NULL),(2158,8081,40720,1518,3,2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',62550.00,NULL,NULL,1,'2023-02-27 12:38:02','2023-02-27 12:38:02',NULL),(2159,8081,41123,296895,3,2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',18126.42,NULL,NULL,1,'2023-02-27 12:41:18','2023-02-27 12:41:18',NULL),(2160,8081,41123,296895,3,2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',163.00,NULL,NULL,1,'2023-02-27 12:41:18','2023-02-27 12:41:18',NULL),(2161,8081,41123,296895,3,2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',176.98,NULL,NULL,1,'2023-02-27 12:41:18','2023-02-27 12:41:18',NULL),(2162,8081,41123,296895,3,2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',20780.00,NULL,NULL,1,'2023-02-27 12:41:18','2023-02-27 12:41:18',NULL),(2163,8081,41123,296895,3,2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',12701.40,NULL,NULL,1,'2023-02-27 12:41:18','2023-02-27 12:41:18',NULL),(2164,8081,41123,296895,3,2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',725.66,NULL,NULL,1,'2023-02-27 12:41:18','2023-02-27 12:41:18',NULL),(2165,8081,41123,296895,3,2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',10500.00,NULL,NULL,1,'2023-02-27 12:41:18','2023-02-27 12:41:18',NULL),(2166,8081,40918,178704,2,2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3000.00,NULL,NULL,1,'2023-03-16 20:56:52','2023-03-16 20:56:52',NULL),(2167,8081,40918,178704,2,2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3000.00,NULL,NULL,1,'2023-03-16 20:56:52','2023-03-16 20:56:52',NULL),(2168,8081,40918,178704,2,2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3000.00,NULL,NULL,1,'2023-03-16 20:56:52','2023-03-16 20:56:52',NULL),(2169,8081,40918,178704,2,2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3000.00,NULL,NULL,1,'2023-03-16 20:56:52','2023-03-16 20:56:52',NULL);
INSERT INTO `balance_libro` VALUES (2170,8081,40918,178704,2,2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2500.00,NULL,NULL,1,'2023-03-16 20:56:52','2023-03-16 20:56:52',NULL),(2171,8081,40918,178704,2,2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3000.00,NULL,NULL,1,'2023-03-16 20:56:52','2023-03-16 20:56:52',NULL),(2172,8081,40918,178704,2,2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5500.00,NULL,NULL,1,'2023-03-16 20:56:52','2023-03-16 20:56:52',NULL),(2173,8081,40918,178704,2,2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3200.00,NULL,NULL,1,'2023-03-16 20:56:52','2023-03-16 20:56:52',NULL),(2174,8081,40918,178704,2,2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3000.00,NULL,NULL,1,'2023-03-16 20:56:52','2023-03-16 20:56:52',NULL),(2175,8081,40918,178704,2,2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',6000.00,NULL,NULL,1,'2023-03-16 20:56:52','2023-03-16 20:56:52',NULL),(2176,8081,40918,178704,2,2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3000.00,NULL,NULL,1,'2023-03-16 20:56:52','2023-03-16 20:56:52',NULL),(2177,8081,40918,178704,2,2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5500.00,NULL,NULL,1,'2023-03-16 20:56:52','2023-03-16 20:56:52',NULL),(2178,8081,40918,178704,2,2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3000.00,NULL,NULL,1,'2023-03-16 20:56:53','2023-03-16 20:56:53',NULL),(2179,8081,40918,178704,2,2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3000.00,NULL,NULL,1,'2023-03-16 20:56:53','2023-03-16 20:56:53',NULL),(2180,8081,40918,178704,2,2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3000.00,NULL,NULL,1,'2023-03-16 20:56:53','2023-03-16 20:56:53',NULL),(2181,8081,40918,178704,2,2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3000.00,NULL,NULL,1,'2023-03-16 20:56:53','2023-03-16 20:56:53',NULL),(2182,8081,40918,178704,2,2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3000.00,NULL,NULL,1,'2023-03-16 20:56:53','2023-03-16 20:56:53',NULL),(2183,8081,40918,178704,2,2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3000.00,NULL,NULL,1,'2023-03-16 20:56:53','2023-03-16 20:56:53',NULL),(2184,8081,40918,178705,2,2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4000.00,NULL,NULL,1,'2023-03-16 20:58:57','2023-03-16 20:58:57',NULL),(2185,8081,40918,178705,2,2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3200.00,NULL,NULL,1,'2023-03-16 20:58:57','2023-03-16 20:58:57',NULL),(2186,8081,40918,178705,2,2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',9500.00,NULL,NULL,1,'2023-03-16 20:58:57','2023-03-16 20:58:57',NULL),(2187,8081,40918,178705,2,2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4000.00,NULL,NULL,1,'2023-03-16 20:58:57','2023-03-16 20:58:57',NULL),(2188,8081,40918,178705,2,2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5500.00,NULL,NULL,1,'2023-03-16 20:58:57','2023-03-16 20:58:57',NULL),(2189,8081,40918,178705,2,2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4000.00,NULL,NULL,1,'2023-03-16 20:58:57','2023-03-16 20:58:57',NULL),(2190,8081,40918,178705,2,2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',9500.00,NULL,NULL,1,'2023-03-16 20:58:58','2023-03-16 20:58:58',NULL),(2191,8081,40918,178705,2,2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4000.00,NULL,NULL,1,'2023-03-16 20:58:58','2023-03-16 20:58:58',NULL),(2192,8081,40918,178705,2,2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4000.00,NULL,NULL,1,'2023-03-16 20:58:58','2023-03-16 20:58:58',NULL),(2193,8081,40918,178705,2,2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7500.00,NULL,NULL,1,'2023-03-16 20:58:58','2023-03-16 20:58:58',NULL);
INSERT INTO `balance_libro` VALUES (2194,8081,40918,178705,2,2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',8000.00,NULL,NULL,1,'2023-03-16 20:58:58','2023-03-16 20:58:58',NULL),(2195,8081,40918,178705,2,2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1200.00,NULL,NULL,1,'2023-03-16 20:58:58','2023-03-16 20:58:58',NULL),(2196,8081,40918,178704,3,2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',12936.00,NULL,NULL,1,'2023-03-16 21:02:01','2023-03-16 21:02:01',NULL),(2197,8081,40918,178704,3,2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',29595.00,NULL,NULL,1,'2023-03-16 21:02:01','2023-03-16 21:02:01',NULL),(2198,8081,40918,178704,3,2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1405.94,NULL,NULL,1,'2023-03-16 21:02:01','2023-03-16 21:02:01',NULL),(2199,8081,40918,178705,3,2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',13998.00,NULL,NULL,1,'2023-03-16 21:03:38','2023-03-16 21:03:38',NULL),(2200,8081,40918,178705,3,2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1405.94,NULL,NULL,1,'2023-03-16 21:03:38','2023-03-16 21:03:38',NULL),(2201,8081,40731,9031,2,2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',91330.00,NULL,NULL,1,'2023-03-16 21:10:13','2023-03-16 21:10:13',NULL),(2202,8081,40731,9031,2,2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',62875.00,NULL,NULL,1,'2023-03-16 21:10:13','2023-03-16 21:10:13',NULL),(2203,8081,40731,9031,2,2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',69990.00,NULL,NULL,1,'2023-03-16 21:10:13','2023-03-16 21:10:13',NULL),(2204,8081,40731,9031,2,2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',56130.00,NULL,NULL,1,'2023-03-16 21:10:13','2023-03-16 21:10:13',NULL),(2205,8081,40731,9031,2,2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',4100.00,NULL,NULL,1,'2023-03-16 21:10:13','2023-03-16 21:10:13',NULL),(2206,8081,40731,9031,2,2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',82000.00,NULL,NULL,1,'2023-03-16 21:10:13','2023-03-16 21:10:13',NULL),(2207,8081,40731,9031,3,2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',4140.21,NULL,NULL,1,'2023-03-16 21:12:32','2023-03-19 20:53:14','2023-03-19 20:53:14'),(2208,8081,40731,9031,3,2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',12630.00,NULL,NULL,1,'2023-03-16 21:12:32','2023-03-16 21:12:32',NULL),(2209,8081,40731,9031,3,2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',750.27,NULL,NULL,1,'2023-03-16 21:12:32','2023-03-19 20:59:28','2023-03-19 20:59:28'),(2210,8081,40731,9031,3,2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',120783.04,NULL,NULL,1,'2023-03-16 21:12:32','2023-03-19 20:55:16','2023-03-19 20:55:16'),(2211,8081,40731,9031,3,2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',20069.66,NULL,NULL,1,'2023-03-16 21:12:32','2023-03-19 20:55:50','2023-03-19 20:55:50'),(2212,8081,40731,9031,3,2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',44995.66,NULL,NULL,1,'2023-03-16 21:12:32','2023-03-19 20:56:39','2023-03-19 20:56:39'),(2213,8081,40731,9031,3,2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',353.00,NULL,NULL,1,'2023-03-16 21:12:32','2023-03-16 21:12:32',NULL),(2214,8081,40731,9031,3,2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1242.41,NULL,NULL,1,'2023-03-16 21:12:32','2023-03-16 21:12:32',NULL),(2215,8081,40731,9031,3,2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',2529.99,NULL,NULL,1,'2023-03-16 21:12:32','2023-03-19 20:57:21','2023-03-19 20:57:21'),(2216,8081,40731,9031,3,2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',92034.40,NULL,NULL,1,'2023-03-16 21:12:32','2023-03-19 20:57:55','2023-03-19 20:57:55');
INSERT INTO `balance_libro` VALUES (2217,8081,41068,293838,2,2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',26000.00,NULL,NULL,1,'2023-03-16 21:17:50','2023-03-16 21:17:50',NULL),(2218,8081,41068,293838,2,2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',32000.00,NULL,NULL,1,'2023-03-16 21:17:50','2023-03-16 21:17:50',NULL),(2219,8081,41068,293838,2,2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',30000.00,NULL,NULL,1,'2023-03-16 21:17:50','2023-03-16 21:17:50',NULL),(2220,8081,41068,293838,2,2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',40000.00,NULL,NULL,1,'2023-03-16 21:17:50','2023-03-16 21:17:50',NULL),(2221,8081,41068,293838,2,2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',38500.00,NULL,NULL,1,'2023-03-16 21:17:50','2023-03-16 21:17:50',NULL),(2222,8081,41068,293839,2,2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',30000.00,NULL,NULL,1,'2023-03-16 21:18:07','2023-03-16 21:18:07',NULL),(2223,8081,41068,293839,2,2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',25000.00,NULL,NULL,1,'2023-03-16 21:18:07','2023-03-16 21:18:07',NULL),(2224,8081,41068,293839,2,2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',12000.00,NULL,NULL,1,'2023-03-16 21:18:07','2023-03-16 21:18:07',NULL),(2225,8081,41068,293839,2,2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',95000.00,NULL,NULL,1,'2023-03-16 21:18:07','2023-03-16 21:18:07',NULL),(2226,8081,41068,293839,2,2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30000.00,NULL,NULL,1,'2023-03-16 21:18:08','2023-03-16 21:18:08',NULL),(2227,8081,41068,293838,3,2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',204.00,NULL,NULL,1,'2023-03-16 21:20:54','2023-03-16 21:20:54',NULL),(2228,8081,41068,293838,3,2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2299.99,NULL,NULL,1,'2023-03-16 21:20:54','2023-03-16 21:20:54',NULL),(2229,8081,41068,293838,3,2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3699.99,NULL,NULL,1,'2023-03-16 21:20:54','2023-03-16 21:20:54',NULL),(2230,8081,41068,293838,3,2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2299.99,NULL,NULL,1,'2023-03-16 21:20:54','2023-03-16 21:20:54',NULL),(2231,8081,41068,293838,3,2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2299.99,NULL,NULL,1,'2023-03-16 21:20:54','2023-03-16 21:20:54',NULL),(2232,8081,41068,293838,3,2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',11300.00,NULL,NULL,1,'2023-03-16 21:20:55','2023-03-16 21:20:55',NULL),(2233,8081,41068,293838,3,2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2299.99,NULL,NULL,1,'2023-03-16 21:20:55','2023-03-16 21:20:55',NULL),(2234,8081,41068,293838,3,2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',12800.00,NULL,NULL,1,'2023-03-16 21:20:55','2023-03-16 21:20:55',NULL),(2235,8081,41068,293838,3,2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',68.00,NULL,NULL,1,'2023-03-16 21:20:55','2023-03-16 21:20:55',NULL),(2236,8081,41068,293838,3,2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',81.60,NULL,NULL,1,'2023-03-16 21:20:55','2023-03-16 21:20:55',NULL),(2237,8081,41068,293838,3,2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3699.99,NULL,NULL,1,'2023-03-16 21:20:55','2023-03-16 21:20:55',NULL),(2238,8081,41068,293838,3,2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2299.99,NULL,NULL,1,'2023-03-16 21:20:55','2023-03-16 21:20:55',NULL),(2239,8081,41068,293838,3,2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2732.00,NULL,NULL,1,'2023-03-16 21:20:55','2023-03-16 21:20:55',NULL),(2240,8081,41068,293838,3,2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',100.00,NULL,NULL,1,'2023-03-16 21:20:55','2023-03-16 21:20:55',NULL);
INSERT INTO `balance_libro` VALUES (2241,8081,41068,293838,3,2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',100.00,NULL,NULL,1,'2023-03-16 21:20:55','2023-03-16 21:20:55',NULL),(2242,8081,41068,293838,3,2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',7200.00,NULL,NULL,1,'2023-03-16 21:20:55','2023-03-16 21:20:55',NULL),(2243,8081,41068,293838,3,2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',5999.00,NULL,NULL,1,'2023-03-16 21:20:55','2023-03-16 21:20:55',NULL),(2244,8081,41068,293838,3,2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',3700.00,NULL,NULL,1,'2023-03-16 21:20:55','2023-03-16 21:20:55',NULL),(2245,8081,41068,293838,3,2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',8000.00,NULL,NULL,1,'2023-03-16 21:20:55','2023-03-16 21:20:55',NULL),(2246,8081,41068,293838,3,2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',16200.00,NULL,NULL,1,'2023-03-16 21:20:55','2023-03-16 21:20:55',NULL),(2247,8081,41068,293838,3,2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3699.99,NULL,NULL,1,'2023-03-16 21:20:55','2023-03-16 21:20:55',NULL),(2248,8081,41068,293839,3,2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2299.99,NULL,NULL,1,'2023-03-16 21:21:19','2023-03-16 21:21:19',NULL),(2249,8081,41068,293839,3,2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',7300.00,NULL,NULL,1,'2023-03-16 21:21:19','2023-03-16 21:21:19',NULL),(2250,8081,41068,293839,3,2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',15.84,NULL,NULL,1,'2023-03-16 21:21:19','2023-03-16 21:21:19',NULL),(2251,8081,41068,293839,3,2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',285.00,NULL,NULL,1,'2023-03-16 21:21:19','2023-03-16 21:21:19',NULL),(2252,8081,41068,293839,3,2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',16200.00,NULL,NULL,1,'2023-03-16 21:21:19','2023-03-16 21:21:19',NULL),(2253,8081,41068,293839,3,2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',2299.99,NULL,NULL,1,'2023-03-16 21:21:19','2023-03-16 21:21:19',NULL),(2254,8081,41068,293839,3,2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',50919.97,NULL,NULL,1,'2023-03-16 21:21:19','2023-03-16 21:21:19',NULL),(2255,8081,41068,293839,3,2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',163.00,NULL,NULL,1,'2023-03-16 21:21:19','2023-03-16 21:21:19',NULL),(2256,8081,41068,293839,3,2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',12799.96,NULL,NULL,1,'2023-03-16 21:21:19','2023-03-16 21:21:19',NULL),(2257,8081,41068,293839,3,2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',200.00,NULL,NULL,1,'2023-03-16 21:21:19','2023-03-16 21:21:19',NULL),(2258,8081,41068,293839,3,2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',3012.00,NULL,NULL,1,'2023-03-16 21:21:19','2023-03-16 21:21:19',NULL),(2259,8081,41068,293839,3,2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',3199.99,NULL,NULL,1,'2023-03-16 21:21:19','2023-03-16 21:21:19',NULL),(2260,8081,41068,293839,3,2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',4999.99,NULL,NULL,1,'2023-03-16 21:21:19','2023-03-16 21:21:19',NULL),(2261,8081,41068,293839,3,2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',14400.00,NULL,NULL,1,'2023-03-16 21:21:19','2023-03-16 21:21:19',NULL),(2262,8081,41147,322680,2,2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',30000.00,NULL,NULL,1,'2023-03-16 21:29:16','2023-03-16 21:29:16',NULL),(2263,8081,41147,322680,2,2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',15000.00,NULL,NULL,1,'2023-03-16 21:29:16','2023-03-16 21:29:16',NULL),(2264,8081,41147,322680,2,2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',10000.00,NULL,NULL,1,'2023-03-16 21:29:16','2023-03-16 21:29:16',NULL);
INSERT INTO `balance_libro` VALUES (2265,8081,41147,322680,2,2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',6000.00,NULL,NULL,1,'2023-03-16 21:29:16','2023-03-16 21:29:16',NULL),(2266,8081,41147,322680,2,2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',12000.00,NULL,NULL,1,'2023-03-16 21:29:17','2023-03-16 21:29:17',NULL),(2267,8081,41147,322681,2,2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',12000.00,NULL,NULL,1,'2023-03-16 21:32:49','2023-03-16 21:32:49',NULL),(2268,8081,41147,322681,2,2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',15000.00,NULL,NULL,1,'2023-03-16 21:32:49','2023-03-16 21:32:49',NULL),(2269,8081,41147,322681,2,2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',15000.00,NULL,NULL,1,'2023-03-16 21:32:49','2023-03-16 21:32:49',NULL),(2270,8081,41147,322681,2,2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30000.00,NULL,NULL,1,'2023-03-16 21:32:49','2023-03-16 21:32:49',NULL),(2271,8081,41147,322681,2,2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',15000.00,NULL,NULL,1,'2023-03-16 21:32:49','2023-03-16 21:32:49',NULL),(2272,8081,40720,1519,2,2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',250000.00,NULL,NULL,1,'2023-03-16 21:42:19','2023-03-16 21:42:19',NULL),(2273,8081,40720,1519,3,2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',697.11,NULL,NULL,1,'2023-03-16 21:42:37','2023-03-16 21:42:37',NULL),(2274,8081,40720,1519,3,2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',68.00,NULL,NULL,1,'2023-03-16 21:42:37','2023-03-16 21:42:37',NULL),(2275,8081,40720,1519,3,2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1195.00,NULL,NULL,1,'2023-03-16 21:42:37','2023-03-16 21:42:37',NULL),(2276,8081,40720,1519,3,2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',10974.00,NULL,NULL,1,'2023-03-16 21:42:37','2023-03-16 21:42:37',NULL),(2277,8081,40720,1519,3,2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1500.00,NULL,NULL,1,'2023-03-16 21:42:37','2023-03-16 21:42:37',NULL),(2278,8081,40720,1519,3,2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',9142.16,NULL,NULL,1,'2023-03-16 21:42:37','2023-03-16 21:42:37',NULL),(2279,8081,40720,1519,3,2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',163.00,NULL,NULL,1,'2023-03-16 21:42:37','2023-03-16 21:42:37',NULL),(2280,8081,40720,1519,3,2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',202.13,NULL,NULL,1,'2023-03-16 21:42:37','2023-03-19 19:39:59','2023-03-19 19:39:59'),(2281,8081,40720,1519,3,2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',800.00,NULL,NULL,1,'2023-03-16 21:42:37','2023-03-16 21:42:37',NULL),(2282,8081,40720,1519,3,2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',35000.00,NULL,NULL,1,'2023-03-16 21:42:37','2023-03-16 21:42:37',NULL),(2283,8081,40720,1519,3,2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',69943.98,NULL,NULL,1,'2023-03-16 21:42:37','2023-03-16 21:42:37',NULL),(2284,8081,40997,263541,2,2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',15000.00,NULL,NULL,1,'2023-03-16 21:48:25','2023-03-16 21:48:25',NULL),(2285,8081,40997,263541,2,2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',18000.00,NULL,NULL,1,'2023-03-16 21:48:25','2023-03-16 21:48:25',NULL),(2286,8081,40997,263541,2,2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15000.00,NULL,NULL,1,'2023-03-16 21:48:25','2023-03-16 21:48:25',NULL),(2287,8081,40997,263541,2,2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',8000.00,NULL,NULL,1,'2023-03-16 21:48:25','2023-03-16 21:48:25',NULL),(2288,8081,40997,263542,2,2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',20000.00,NULL,NULL,1,'2023-03-16 21:49:04','2023-03-16 21:49:04',NULL);
INSERT INTO `balance_libro` VALUES (2289,8081,40997,263542,2,2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',18000.00,NULL,NULL,1,'2023-03-16 21:49:04','2023-03-16 21:49:04',NULL),(2290,8081,40997,263542,2,2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',20000.00,NULL,NULL,1,'2023-03-16 21:49:04','2023-03-16 21:49:04',NULL),(2291,8081,40997,263542,2,2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',8000.00,NULL,NULL,1,'2023-03-16 21:49:04','2023-03-16 21:49:04',NULL),(2292,8081,40997,263542,2,2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',6000.00,NULL,NULL,1,'2023-03-16 21:49:04','2023-03-16 21:49:04',NULL),(2293,8081,40997,263542,2,2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',8000.00,NULL,NULL,1,'2023-03-16 21:49:04','2023-03-16 21:49:04',NULL),(2294,8081,40997,263541,3,2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',5460.10,NULL,NULL,1,'2023-03-16 21:50:14','2023-03-16 21:50:14',NULL),(2295,8081,40997,263542,3,2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',136.00,NULL,NULL,1,'2023-03-16 21:50:44','2023-03-16 21:50:44',NULL),(2296,8081,40997,263542,3,2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',3679.48,NULL,NULL,1,'2023-03-16 21:50:44','2023-03-16 21:50:44',NULL),(2297,8081,41123,296896,2,2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',105300.00,NULL,NULL,1,'2023-03-16 22:01:37','2023-03-16 22:01:37',NULL),(2298,8081,41123,296896,2,2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',102300.00,NULL,NULL,1,'2023-03-16 22:01:37','2023-03-16 22:01:37',NULL),(2299,8081,41123,296896,3,2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',19613.75,NULL,NULL,1,'2023-03-16 22:01:54','2023-03-16 22:01:54',NULL),(2300,8081,41123,296896,3,2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',915.00,NULL,NULL,1,'2023-03-16 22:01:54','2023-03-16 22:01:54',NULL),(2301,8081,41123,296896,3,2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',190.00,NULL,NULL,1,'2023-03-16 22:01:54','2023-03-16 22:01:54',NULL),(2302,8081,41123,296896,3,2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',513.39,NULL,NULL,1,'2023-03-16 22:01:54','2023-03-16 22:01:54',NULL),(2303,8081,41123,296896,3,2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',76.00,NULL,NULL,1,'2023-03-16 22:01:54','2023-03-16 22:01:54',NULL),(2304,8081,41123,296896,3,2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',3470.00,NULL,NULL,1,'2023-03-16 22:01:54','2023-03-16 22:01:54',NULL),(2305,8081,41123,296896,3,2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',3150.18,NULL,NULL,1,'2023-03-16 22:01:54','2023-03-16 22:01:54',NULL),(2306,8081,41123,296896,3,2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',51.00,NULL,NULL,1,'2023-03-16 22:01:54','2023-03-16 22:01:54',NULL),(2307,8081,41123,296896,3,2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',265.47,NULL,NULL,1,'2023-03-16 22:01:54','2023-03-16 22:01:54',NULL),(2308,8081,41123,296896,3,2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',10500.00,NULL,NULL,1,'2023-03-16 22:01:54','2023-03-16 22:01:54',NULL),(2309,8081,40771,48417,2,2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',4000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2310,8081,40771,48417,2,2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2311,8081,40771,48417,2,2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2312,8081,40771,48417,2,2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL);
INSERT INTO `balance_libro` VALUES (2313,8081,40771,48417,2,2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',5000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2314,8081,40771,48417,2,2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2315,8081,40771,48417,2,2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2316,8081,40771,48417,2,2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',40000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2317,8081,40771,48417,2,2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2500.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2318,8081,40771,48417,2,2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2319,8081,40771,48417,2,2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2320,8081,40771,48417,2,2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2321,8081,40771,48417,2,2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2322,8081,40771,48417,2,2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',6000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2323,8081,40771,48417,2,2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',3000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2324,8081,40771,48417,2,2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',7000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2325,8081,40771,48417,2,2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',3000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2326,8081,40771,48417,2,2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',18000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2327,8081,40771,48417,2,2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',3000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2328,8081,40771,48417,2,2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',12000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2329,8081,40771,48417,2,2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4500.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2330,8081,40771,48417,2,2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2000.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2331,8081,40771,48417,2,2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',3500.00,NULL,NULL,1,'2023-03-16 22:37:03','2023-03-16 22:37:03',NULL),(2332,8081,40771,48417,2,2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',6000.00,NULL,NULL,1,'2023-03-16 22:37:04','2023-03-16 22:37:04',NULL),(2333,8081,40771,48417,2,2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3500.00,NULL,NULL,1,'2023-03-16 22:37:04','2023-03-16 22:37:04',NULL),(2334,8081,40771,48417,2,2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3500.00,NULL,NULL,1,'2023-03-16 22:37:04','2023-03-16 22:37:04',NULL),(2335,8081,40771,48417,2,2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',18000.00,NULL,NULL,1,'2023-03-16 22:37:04','2023-03-16 22:37:04',NULL),(2336,8081,40771,48417,2,2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3500.00,NULL,NULL,1,'2023-03-16 22:37:04','2023-03-16 22:37:04',NULL);
INSERT INTO `balance_libro` VALUES (2337,8081,40771,48417,2,2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3500.00,NULL,NULL,1,'2023-03-16 22:37:04','2023-03-16 22:37:04',NULL),(2338,8081,40771,48417,2,2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2400.00,NULL,NULL,1,'2023-03-16 22:37:04','2023-03-16 22:37:04',NULL),(2339,8081,40771,48417,2,2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3500.00,NULL,NULL,1,'2023-03-16 22:37:04','2023-03-16 22:37:04',NULL),(2340,8081,40771,48417,2,2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2400.00,NULL,NULL,1,'2023-03-16 22:37:04','2023-03-16 22:37:04',NULL),(2341,8081,40771,48417,2,2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2400.00,NULL,NULL,1,'2023-03-16 22:37:04','2023-03-16 22:37:04',NULL),(2342,8081,40771,48417,2,2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',3000.00,NULL,NULL,1,'2023-03-16 22:37:04','2023-03-16 22:37:04',NULL),(2343,8081,40771,48417,2,2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2600.00,NULL,NULL,1,'2023-03-16 22:37:04','2023-03-16 22:37:04',NULL),(2344,8081,40771,48417,2,2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',5250.00,NULL,NULL,1,'2023-03-16 22:37:04','2023-03-16 22:37:04',NULL),(2345,8081,40771,48417,2,2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2300.00,NULL,NULL,1,'2023-03-16 22:37:04','2023-03-16 22:37:04',NULL),(2346,8081,40771,48417,2,2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',4800.00,NULL,NULL,1,'2023-03-16 22:37:04','2023-03-16 22:37:04',NULL),(2347,8081,40771,48417,2,2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',46800.00,NULL,NULL,1,'2023-03-16 22:37:04','2023-03-16 22:37:04',NULL),(2348,8081,40771,48417,2,2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',97200.00,NULL,NULL,1,'2023-03-16 22:37:04','2023-03-16 22:37:04',NULL),(2349,8081,40771,48418,2,2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',5400.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2350,8081,40771,48418,2,2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',2600.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2351,8081,40771,48418,2,2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',2300.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2352,8081,40771,48418,2,2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',2600.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2353,8081,40771,48418,2,2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',3000.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2354,8081,40771,48418,2,2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',2300.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2355,8081,40771,48418,2,2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',3200.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2356,8081,40771,48418,2,2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',11000.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2357,8081,40771,48418,2,2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',10000.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2358,8081,40771,48418,2,2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',3000.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2359,8081,40771,48418,2,2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',3000.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2360,8081,40771,48418,2,2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',5000.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL);
INSERT INTO `balance_libro` VALUES (2361,8081,40771,48418,2,2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',2300.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2362,8081,40771,48418,2,2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',15000.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2363,8081,40771,48418,2,2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',10000.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2364,8081,40771,48418,2,2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',8000.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2365,8081,40771,48418,2,2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',3000.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2366,8081,40771,48418,2,2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',3500.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2367,8081,40771,48418,2,2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3500.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2368,8081,40771,48418,2,2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3500.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2369,8081,40771,48418,2,2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',3000.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2370,8081,40771,48418,2,2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',5000.00,NULL,NULL,1,'2023-03-16 22:37:55','2023-03-16 22:37:55',NULL),(2371,8081,40771,48418,2,2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',3000.00,NULL,NULL,1,'2023-03-16 22:37:56','2023-03-16 22:37:56',NULL),(2372,8081,40771,48418,2,2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',5000.00,NULL,NULL,1,'2023-03-16 22:37:56','2023-03-16 22:37:56',NULL),(2373,8081,40771,48418,2,2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3500.00,NULL,NULL,1,'2023-03-16 22:37:56','2023-03-16 22:37:56',NULL),(2374,8081,40771,48418,2,2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3500.00,NULL,NULL,1,'2023-03-16 22:37:56','2023-03-16 22:37:56',NULL),(2375,8081,40771,48418,2,2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',5000.00,NULL,NULL,1,'2023-03-16 22:37:56','2023-03-16 22:37:56',NULL),(2376,8081,40771,48418,2,2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',8000.00,NULL,NULL,1,'2023-03-16 22:37:56','2023-03-16 22:37:56',NULL),(2377,8081,40771,48418,2,2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',10000.00,NULL,NULL,1,'2023-03-16 22:37:56','2023-03-16 22:37:56',NULL),(2378,8081,40771,48418,2,2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2600.00,NULL,NULL,1,'2023-03-16 22:37:56','2023-03-16 22:37:56',NULL),(2379,8081,40771,48417,3,2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',11450.00,NULL,NULL,1,'2023-03-16 22:38:21','2023-03-16 22:38:21',NULL),(2380,8081,40771,48417,3,2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5404.00,NULL,NULL,1,'2023-03-16 22:38:21','2023-03-16 22:38:21',NULL),(2381,8081,40771,48417,3,2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2800.00,NULL,NULL,1,'2023-03-16 22:38:22','2023-03-16 22:38:22',NULL),(2382,8081,40771,48417,3,2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2704.29,NULL,NULL,1,'2023-03-16 22:38:22','2023-03-16 22:38:22',NULL),(2383,8081,40771,48417,3,2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',6800.00,NULL,NULL,1,'2023-03-16 22:38:22','2023-03-16 22:38:22',NULL),(2384,8081,40771,48417,3,2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',16200.00,NULL,NULL,1,'2023-03-16 22:38:22','2023-03-16 22:38:22',NULL);
INSERT INTO `balance_libro` VALUES (2385,8081,40771,48417,3,2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',3500.00,NULL,NULL,1,'2023-03-16 22:38:22','2023-03-16 22:38:22',NULL),(2386,8081,40771,48417,3,2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15000.00,NULL,NULL,1,'2023-03-16 22:38:22','2023-03-16 22:38:22',NULL),(2387,8081,40771,48418,3,2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',83399.00,NULL,NULL,1,'2023-03-16 22:38:43','2023-03-16 22:38:43',NULL),(2388,8081,40771,48418,3,2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',26125.00,NULL,NULL,1,'2023-03-16 22:38:44','2023-03-16 22:38:44',NULL),(2389,8081,40771,48418,3,2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',2751.07,NULL,NULL,1,'2023-03-16 22:38:44','2023-03-16 22:38:44',NULL),(2390,8081,40771,48418,3,2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',8000.00,NULL,NULL,1,'2023-03-16 22:38:44','2023-03-16 22:38:44',NULL),(2391,8081,40771,48418,3,2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',5000.00,NULL,NULL,1,'2023-03-16 22:38:44','2023-03-16 22:38:44',NULL),(2392,8081,40771,48418,3,2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',20000.00,NULL,NULL,1,'2023-03-16 22:38:44','2023-03-16 22:38:44',NULL),(2393,8081,40771,48418,3,2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',22400.00,NULL,NULL,1,'2023-03-16 22:38:44','2023-03-16 22:38:44',NULL),(2394,8081,41120,295350,2,2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',4000.00,NULL,NULL,1,'2023-03-16 22:43:58','2023-03-16 22:43:58',NULL),(2395,8081,41120,295350,2,2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',190850.00,NULL,NULL,1,'2023-03-16 22:43:58','2023-03-16 22:43:58',NULL),(2396,8081,41120,295350,2,2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1200.00,NULL,NULL,1,'2023-03-16 22:43:58','2023-03-16 22:43:58',NULL),(2397,8081,41120,295350,2,2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2100.00,NULL,NULL,1,'2023-03-16 22:43:58','2023-03-16 22:43:58',NULL),(2398,8081,41120,295350,2,2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2000.00,NULL,NULL,1,'2023-03-16 22:43:58','2023-03-16 22:43:58',NULL),(2399,8081,41120,295350,2,2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1800.00,NULL,NULL,1,'2023-03-16 22:43:58','2023-03-16 22:43:58',NULL),(2400,8081,41120,295350,2,2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2500.00,NULL,NULL,1,'2023-03-16 22:43:58','2023-03-16 22:43:58',NULL),(2401,8081,41120,295350,2,2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',4800.00,NULL,NULL,1,'2023-03-16 22:43:58','2023-03-16 22:43:58',NULL),(2402,8081,41120,295350,2,2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',8505.00,NULL,NULL,1,'2023-03-16 22:43:58','2023-03-16 22:43:58',NULL),(2403,8081,41120,295350,2,2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',11040.00,NULL,NULL,1,'2023-03-16 22:43:58','2023-03-16 22:43:58',NULL),(2404,8081,41120,295350,2,2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',5100.00,NULL,NULL,1,'2023-03-16 22:43:58','2023-03-16 22:43:58',NULL),(2405,8081,41120,295350,2,2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',3200.00,NULL,NULL,1,'2023-03-16 22:43:58','2023-03-16 22:43:58',NULL),(2406,8081,41120,295350,2,2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',14425.00,NULL,NULL,1,'2023-03-16 22:43:58','2023-03-16 22:43:58',NULL),(2407,8081,41120,295351,2,2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',15600.00,NULL,NULL,1,'2023-03-16 22:44:23','2023-03-16 22:44:23',NULL),(2408,8081,41120,295351,2,2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',15000.00,NULL,NULL,1,'2023-03-16 22:44:23','2023-03-16 22:44:23',NULL);
INSERT INTO `balance_libro` VALUES (2409,8081,41120,295351,2,2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',16000.00,NULL,NULL,1,'2023-03-16 22:44:23','2023-03-16 22:44:23',NULL),(2410,8081,41120,295351,2,2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',15400.00,NULL,NULL,1,'2023-03-16 22:44:23','2023-03-16 22:44:23',NULL),(2411,8081,41120,295351,2,2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',17200.00,NULL,NULL,1,'2023-03-16 22:44:23','2023-03-16 22:44:23',NULL),(2412,8081,41120,295351,2,2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',24700.00,NULL,NULL,1,'2023-03-16 22:44:23','2023-03-16 22:44:23',NULL),(2413,8081,41120,295351,2,2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',20650.00,NULL,NULL,1,'2023-03-16 22:44:23','2023-03-16 22:44:23',NULL),(2414,8081,41120,295351,2,2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',19370.00,NULL,NULL,1,'2023-03-16 22:44:24','2023-03-16 22:44:24',NULL),(2415,8081,41120,295351,2,2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',13370.00,NULL,NULL,1,'2023-03-16 22:44:24','2023-03-16 22:44:24',NULL),(2416,8081,41120,295351,2,2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',17700.00,NULL,NULL,1,'2023-03-16 22:44:24','2023-03-16 22:44:24',NULL),(2417,8081,41120,295351,2,2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',13100.00,NULL,NULL,1,'2023-03-16 22:44:24','2023-03-16 22:44:24',NULL),(2418,8081,41120,295351,2,2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',10200.00,NULL,NULL,1,'2023-03-16 22:44:24','2023-03-16 22:44:24',NULL),(2419,8081,41120,295351,2,2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',12900.00,NULL,NULL,1,'2023-03-16 22:44:24','2023-03-16 22:44:24',NULL),(2420,8081,41120,295351,2,2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',6000.00,NULL,NULL,1,'2023-03-16 22:44:24','2023-03-16 22:44:24',NULL),(2421,8081,41120,295351,2,2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',15000.00,NULL,NULL,1,'2023-03-16 22:44:24','2023-03-16 22:44:24',NULL),(2422,8081,41120,295351,2,2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',12600.00,NULL,NULL,1,'2023-03-16 22:44:24','2023-03-16 22:44:24',NULL),(2423,8081,41120,295351,2,2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',16000.00,NULL,NULL,1,'2023-03-16 22:44:24','2023-03-16 22:44:24',NULL),(2424,8081,41120,295351,2,2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',7250.00,NULL,NULL,1,'2023-03-16 22:44:24','2023-03-16 22:44:24',NULL),(2425,8081,41120,295351,2,2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',14000.00,NULL,NULL,1,'2023-03-16 22:44:24','2023-03-16 22:44:24',NULL),(2426,8081,41120,295351,2,2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',27900.00,NULL,NULL,1,'2023-03-16 22:44:24','2023-03-16 22:44:24',NULL),(2427,8081,41120,295351,2,2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',18300.00,NULL,NULL,1,'2023-03-16 22:44:24','2023-03-16 22:44:24',NULL),(2428,8081,41120,295351,2,2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3500.00,NULL,NULL,1,'2023-03-16 22:44:24','2023-03-16 22:44:24',NULL),(2429,8081,41120,295351,2,2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',6500.00,NULL,NULL,1,'2023-03-16 22:44:24','2023-03-16 22:44:24',NULL),(2430,8081,41120,295350,3,2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',748.00,NULL,NULL,1,'2023-03-16 22:44:46','2023-03-16 22:44:46',NULL),(2431,8081,41120,295350,3,2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',34333.00,NULL,NULL,1,'2023-03-16 22:44:46','2023-03-16 22:44:46',NULL),(2432,8081,41120,295350,3,2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',659.14,NULL,NULL,1,'2023-03-16 22:44:46','2023-03-16 22:44:46',NULL);
INSERT INTO `balance_libro` VALUES (2433,8081,41120,295350,3,2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',68.00,NULL,NULL,1,'2023-03-16 22:44:47','2023-03-16 22:44:47',NULL),(2434,8081,41120,295350,3,2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',68454.57,NULL,NULL,1,'2023-03-16 22:44:47','2023-03-16 22:44:47',NULL),(2435,8081,41120,295350,3,2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',350.00,NULL,NULL,1,'2023-03-16 22:44:47','2023-03-16 22:44:47',NULL),(2436,8081,41120,295351,3,2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',2687.52,NULL,NULL,1,'2023-03-16 22:45:12','2023-03-21 20:57:06','2023-03-21 20:57:06'),(2437,8081,41120,295351,3,2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',4663.17,NULL,NULL,1,'2023-03-16 22:45:12','2023-03-21 20:56:29','2023-03-21 20:56:29'),(2438,8081,41120,295351,3,2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',5017.19,NULL,NULL,1,'2023-03-16 22:45:12','2023-03-16 22:45:12',NULL),(2439,8081,41120,295351,3,2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2100.00,NULL,NULL,1,'2023-03-16 22:45:12','2023-03-16 22:45:12',NULL),(2440,8081,40943,216579,2,2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3518.00,NULL,NULL,1,'2023-03-16 22:51:25','2023-03-16 22:51:25',NULL),(2441,8081,40943,216579,2,2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',7360.00,NULL,NULL,1,'2023-03-16 22:51:25','2023-03-16 22:51:25',NULL),(2442,8081,40943,216579,2,2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',3790.00,NULL,NULL,1,'2023-03-16 22:51:25','2023-03-16 22:51:25',NULL),(2443,8081,40943,216579,2,2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',18000.00,NULL,NULL,1,'2023-03-16 22:51:25','2023-03-16 22:51:25',NULL),(2444,8081,40943,216579,2,2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5780.00,NULL,NULL,1,'2023-03-16 22:51:25','2023-03-16 22:51:25',NULL),(2445,8081,40943,216580,2,2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3680.00,NULL,NULL,1,'2023-03-16 22:51:43','2023-03-16 22:51:43',NULL),(2446,8081,40943,216580,2,2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',39750.00,NULL,NULL,1,'2023-03-16 22:51:43','2023-03-16 22:51:43',NULL),(2447,8081,40943,216580,2,2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',39750.00,NULL,NULL,1,'2023-03-16 22:51:43','2023-03-16 22:51:43',NULL),(2448,8081,40943,216580,2,2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',39750.00,NULL,NULL,1,'2023-03-16 22:51:43','2023-03-16 22:51:43',NULL),(2449,8081,40943,216580,2,2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3360.00,NULL,NULL,1,'2023-03-16 22:51:43','2023-03-16 22:51:43',NULL),(2450,8081,40943,216580,2,2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',2650.00,NULL,NULL,1,'2023-03-16 22:51:43','2023-03-16 22:51:43',NULL),(2451,8081,40943,216580,2,2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',68892.00,NULL,NULL,1,'2023-03-16 22:51:43','2023-03-16 22:51:43',NULL),(2452,8081,40943,216580,2,2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',3153.00,NULL,NULL,1,'2023-03-16 22:51:43','2023-03-16 22:51:43',NULL),(2453,8081,40943,216580,2,2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',66431.00,NULL,NULL,1,'2023-03-16 22:51:43','2023-03-16 22:51:43',NULL),(2454,8081,40943,216580,2,2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',31380.00,NULL,NULL,1,'2023-03-16 22:51:43','2023-03-16 22:51:43',NULL),(2455,8081,40943,216580,2,2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',5000.00,NULL,NULL,1,'2023-03-16 22:51:43','2023-03-16 22:51:43',NULL),(2456,8081,40943,216580,2,2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',95780.00,NULL,NULL,1,'2023-03-16 22:51:43','2023-03-16 22:51:43',NULL);
INSERT INTO `balance_libro` VALUES (2457,8081,40943,216580,2,2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',16460.00,NULL,NULL,1,'2023-03-16 22:51:43','2023-03-16 22:51:43',NULL),(2458,8081,40943,216580,2,2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',12595.00,NULL,NULL,1,'2023-03-16 22:51:43','2023-03-16 22:51:43',NULL),(2459,8081,40943,216580,2,2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',95780.00,NULL,NULL,1,'2023-03-16 22:51:43','2023-03-16 22:51:43',NULL),(2460,8081,40943,216580,2,2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',95780.00,NULL,NULL,1,'2023-03-16 22:51:43','2023-03-16 22:51:43',NULL),(2461,8081,40943,216579,3,2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6131.81,NULL,NULL,1,'2023-03-16 22:52:14','2023-03-16 22:52:14',NULL),(2462,8081,40943,216579,3,2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',543.00,NULL,NULL,1,'2023-03-16 22:52:14','2023-03-16 22:52:14',NULL),(2463,8081,40943,216580,3,2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',720.00,NULL,NULL,1,'2023-03-16 22:52:34','2023-03-16 22:52:34',NULL),(2464,8081,40943,216580,3,2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',153.50,NULL,NULL,1,'2023-03-16 22:52:34','2023-03-16 22:52:34',NULL),(2466,8081,40720,1519,8,2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',2172.80,NULL,NULL,1,'2023-03-19 18:55:40','2023-03-19 18:55:40',NULL),(2468,8081,40720,1519,8,2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',6017.20,NULL,NULL,1,'2023-03-19 19:36:35','2023-03-19 19:36:35',NULL),(2469,8081,40720,1519,3,2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',202.13,NULL,NULL,1,'2023-03-19 19:39:59','2023-03-19 19:39:59',NULL),(2470,8081,40720,1519,16,NULL,251,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',8549.33,NULL,NULL,1,'2023-03-19 19:40:59','2023-03-19 19:40:59',NULL),(2471,8081,40731,9031,8,2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',13.80,NULL,NULL,1,'2023-03-19 20:33:03','2023-03-19 20:33:03',NULL),(2472,8081,40731,9031,3,2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',4140.21,NULL,NULL,1,'2023-03-19 20:53:14','2023-03-19 20:53:14',NULL),(2473,8081,40731,9031,3,2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',120783.04,NULL,NULL,1,'2023-03-19 20:55:16','2023-03-19 20:55:16',NULL),(2474,8081,40731,9031,3,2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',20069.66,NULL,NULL,1,'2023-03-19 20:55:50','2023-03-19 20:55:50',NULL),(2475,8081,40731,9031,3,2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',44995.66,NULL,NULL,1,'2023-03-19 20:56:39','2023-03-19 20:56:39',NULL),(2476,8081,40731,9031,3,2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',2529.99,NULL,NULL,1,'2023-03-19 20:57:21','2023-03-19 20:57:21',NULL),(2477,8081,40731,9031,3,2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',92034.39,NULL,NULL,1,'2023-03-19 20:57:55','2023-03-19 20:57:55',NULL),(2478,8081,40731,9031,3,2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',750.27,NULL,NULL,1,'2023-03-19 20:59:28','2023-03-19 20:59:28',NULL),(2479,8081,40731,9031,8,2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',106.20,NULL,NULL,1,'2023-03-19 21:24:51','2023-03-19 21:24:51',NULL),(2480,8081,40731,9031,16,NULL,260,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',13210.00,NULL,NULL,1,'2023-03-19 21:26:13','2023-03-19 21:26:13',NULL),(2481,8081,41147,322681,8,2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',548.90,NULL,NULL,1,'2023-03-20 22:07:59','2023-03-20 22:07:59',NULL),(2482,8081,41147,322681,8,2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',5.50,NULL,NULL,1,'2023-03-20 22:07:59','2023-03-20 22:07:59',NULL);
INSERT INTO `balance_libro` VALUES (2483,8081,41147,322681,16,NULL,261,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2634.66,NULL,NULL,1,'2023-03-20 22:09:14','2023-03-20 22:09:14',NULL),(2484,8081,41120,295351,8,2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',3983.19,NULL,NULL,1,'2023-03-21 20:50:22','2023-03-21 20:50:22',NULL),(2485,8081,41120,295351,8,2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',172.91,NULL,NULL,1,'2023-03-21 20:50:22','2023-03-21 20:50:22',NULL),(2486,8081,41120,295351,3,2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',4663.17,NULL,NULL,1,'2023-03-21 20:56:29','2023-03-21 20:57:56','2023-03-21 20:57:56'),(2487,8081,41120,295351,3,2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',2687.52,NULL,NULL,1,'2023-03-21 20:57:06','2023-03-21 20:57:06',NULL),(2488,8081,41120,295351,3,2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',4663.17,NULL,NULL,1,'2023-03-21 20:57:56','2023-03-21 21:42:06','2023-03-21 21:42:06'),(2489,8081,41120,295351,2,2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5.51,NULL,NULL,1,'2023-03-21 21:09:42','2023-03-21 21:29:12','2023-03-21 21:29:12'),(2490,8081,41120,295351,3,2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',4663.17,NULL,NULL,1,'2023-03-21 21:42:06','2023-03-21 21:42:06',NULL),(2491,8081,41120,295351,16,NULL,271,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',16147.37,NULL,NULL,1,'2023-03-21 21:43:46','2023-03-21 21:43:46',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6350 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,8081,1,40720,1515,8,277,1,0.00,NULL,'2022-11-22 21:52:30','2022-11-22 21:58:52','2022-11-22 21:58:52'),(2,8081,1,40720,1515,8,351,2,0.00,NULL,'2022-11-22 21:52:30','2022-11-22 21:58:52','2022-11-22 21:58:52'),(3,8081,2,40720,1515,8,277,1,0.00,NULL,'2022-11-22 21:58:52','2022-11-22 21:59:17','2022-11-22 21:59:17'),(4,8081,2,40720,1515,8,351,2,0.00,NULL,'2022-11-22 21:58:52','2022-11-22 21:59:17','2022-11-22 21:59:17'),(5,8081,3,40720,1515,8,277,1,0.00,NULL,'2022-11-22 21:59:17','2022-11-28 11:20:36','2022-11-28 11:20:36'),(6,8081,3,40720,1515,8,351,2,0.00,NULL,'2022-11-22 21:59:17','2022-11-28 11:20:36','2022-11-28 11:20:36'),(7,8081,4,40719,12,8,277,1,416.00,NULL,'2022-11-25 18:22:32','2022-11-25 18:22:32',NULL),(8,8081,4,40719,12,8,351,2,416.00,NULL,'2022-11-25 18:22:32','2022-11-25 18:22:32',NULL),(9,8081,5,40720,1515,3,250,2,0.00,NULL,'2022-11-26 20:45:57','2022-11-26 20:45:57',NULL),(10,8081,5,40720,1515,3,250,2,697.11,NULL,'2022-11-26 20:45:57','2022-11-26 20:45:57',NULL),(11,8081,5,40720,1515,3,57,1,697.11,NULL,'2022-11-26 20:45:57','2022-11-26 20:45:57',NULL),(12,8081,6,40720,1515,3,217,1,1459.50,NULL,'2022-11-26 20:45:57','2022-11-26 20:45:57',NULL),(13,8081,6,40720,1515,3,68,1,306.50,NULL,'2022-11-26 20:45:57','2022-11-26 20:45:57',NULL),(14,8081,6,40720,1515,3,57,2,1766.00,NULL,'2022-11-26 20:45:57','2022-11-26 20:45:57',NULL),(15,8081,7,40720,1515,3,217,1,909.09,NULL,'2022-11-26 20:45:57','2022-11-26 20:45:57',NULL),(16,8081,7,40720,1515,3,68,1,190.91,NULL,'2022-11-26 20:45:57','2022-11-26 20:45:57',NULL),(17,8081,7,40720,1515,3,57,2,1100.00,NULL,'2022-11-26 20:45:57','2022-11-26 20:45:57',NULL),(18,8081,8,40720,1515,3,217,1,987.59,NULL,'2022-11-26 20:45:58','2022-11-26 20:45:58',NULL),(19,8081,8,40720,1515,3,68,1,207.41,NULL,'2022-11-26 20:45:58','2022-11-26 20:45:58',NULL),(20,8081,8,40720,1515,3,57,2,1195.00,NULL,'2022-11-26 20:45:58','2022-11-26 20:45:58',NULL),(21,8081,9,40720,1515,3,250,1,0.00,NULL,'2022-11-26 20:45:58','2022-11-26 20:45:58',NULL),(22,8081,9,40720,1515,3,250,1,44741.92,NULL,'2022-11-26 20:45:58','2022-11-26 20:45:58',NULL),(23,8081,9,40720,1515,3,57,2,44741.92,NULL,'2022-11-26 20:45:58','2022-11-26 20:45:58',NULL),(24,8081,10,40720,1515,3,217,1,1365.29,NULL,'2022-11-26 20:45:58','2022-11-26 20:45:58',NULL),(25,8081,10,40720,1515,3,68,1,286.71,NULL,'2022-11-26 20:45:58','2022-11-26 20:45:58',NULL),(26,8081,10,40720,1515,3,57,2,1652.00,NULL,'2022-11-26 20:45:58','2022-11-26 20:45:58',NULL),(27,8081,11,40731,9027,2,218,2,5700.00,NULL,'2022-11-26 22:46:11','2022-11-26 22:46:11',NULL),(28,8081,11,40731,9027,2,13,1,5700.00,NULL,'2022-11-26 22:46:11','2022-11-26 22:46:11',NULL),(29,8081,12,40731,9027,2,218,2,45300.00,NULL,'2022-11-26 22:46:11','2022-11-26 22:46:11',NULL),(30,8081,12,40731,9027,2,13,1,45300.00,NULL,'2022-11-26 22:46:11','2022-11-26 22:46:11',NULL),(31,8081,13,40731,9027,2,218,2,46000.00,NULL,'2022-11-26 22:46:11','2022-11-26 22:46:11',NULL),(32,8081,13,40731,9027,2,13,1,46000.00,NULL,'2022-11-26 22:46:11','2022-11-26 22:46:11',NULL),(33,8081,14,40731,9027,2,218,2,3300.00,NULL,'2022-11-26 22:46:11','2022-11-26 22:46:11',NULL),(34,8081,14,40731,9027,2,13,1,3300.00,NULL,'2022-11-26 22:46:11','2022-11-26 22:46:11',NULL),(35,8081,15,40731,9027,2,218,2,4645.00,NULL,'2022-11-26 22:46:11','2022-11-26 22:46:11',NULL),(36,8081,15,40731,9027,2,13,1,4645.00,NULL,'2022-11-26 22:46:11','2022-11-26 22:46:11',NULL),(37,8081,16,40731,9027,2,218,2,17080.00,NULL,'2022-11-26 22:46:11','2022-11-26 22:46:11',NULL),(38,8081,16,40731,9027,2,13,1,17080.00,NULL,'2022-11-26 22:46:11','2022-11-26 22:46:11',NULL),(39,8081,17,40731,9027,2,218,2,5700.00,NULL,'2022-11-26 22:46:12','2022-11-26 22:46:12',NULL),(40,8081,17,40731,9027,2,13,1,5700.00,NULL,'2022-11-26 22:46:12','2022-11-26 22:46:12',NULL),(41,8081,18,40731,9027,2,218,2,64390.00,NULL,'2022-11-26 22:46:12','2022-11-26 22:46:12',NULL),(42,8081,18,40731,9027,2,13,1,64390.00,NULL,'2022-11-26 22:46:12','2022-11-26 22:46:12',NULL);
INSERT INTO `balance_libro_details` VALUES (43,8081,19,40731,9027,2,218,2,3300.00,NULL,'2022-11-26 22:46:12','2022-11-26 22:46:12',NULL),(44,8081,19,40731,9027,2,13,1,3300.00,NULL,'2022-11-26 22:46:12','2022-11-26 22:46:12',NULL),(45,8081,20,40731,9027,2,218,2,53335.00,NULL,'2022-11-26 22:46:12','2022-11-26 22:46:12',NULL),(46,8081,20,40731,9027,2,13,1,53335.00,NULL,'2022-11-26 22:46:12','2022-11-26 22:46:12',NULL),(47,8081,21,40731,9027,2,218,2,53335.00,NULL,'2022-11-26 22:46:12','2022-11-26 22:46:12',NULL),(48,8081,21,40731,9027,2,13,1,53335.00,NULL,'2022-11-26 22:46:12','2022-11-26 22:46:12',NULL),(49,8081,22,40731,9027,2,218,2,18130.00,NULL,'2022-11-26 22:46:12','2022-11-26 22:46:12',NULL),(50,8081,22,40731,9027,2,13,1,18130.00,NULL,'2022-11-26 22:46:12','2022-11-26 22:46:12',NULL),(51,8081,23,40731,9027,3,217,1,24891.75,NULL,'2022-11-26 22:47:36','2022-11-27 00:47:35','2022-11-27 00:47:35'),(52,8081,23,40731,9027,3,68,1,5227.27,NULL,'2022-11-26 22:47:36','2022-11-27 00:47:35','2022-11-27 00:47:35'),(53,8081,23,40731,9027,3,217,1,903.57,NULL,'2022-11-26 22:47:36','2022-11-27 00:47:35','2022-11-27 00:47:35'),(54,8081,23,40731,9027,3,57,2,31022.59,NULL,'2022-11-26 22:47:36','2022-11-27 00:47:35','2022-11-27 00:47:35'),(55,8081,24,40731,9027,3,217,1,14389.00,NULL,'2022-11-26 22:47:36','2022-11-27 00:46:43','2022-11-27 00:46:43'),(56,8081,24,40731,9027,3,68,1,3021.69,NULL,'2022-11-26 22:47:36','2022-11-27 00:46:43','2022-11-27 00:46:43'),(57,8081,24,40731,9027,3,217,1,522.32,NULL,'2022-11-26 22:47:36','2022-11-27 00:46:43','2022-11-27 00:46:43'),(58,8081,24,40731,9027,3,57,2,17933.01,NULL,'2022-11-26 22:47:36','2022-11-27 00:46:43','2022-11-27 00:46:43'),(59,8081,25,40731,9027,3,217,1,27599.89,NULL,'2022-11-26 22:47:36','2022-11-27 00:46:12','2022-11-27 00:46:12'),(60,8081,25,40731,9027,3,68,1,5795.98,NULL,'2022-11-26 22:47:36','2022-11-27 00:46:12','2022-11-27 00:46:12'),(61,8081,25,40731,9027,3,217,1,1001.88,NULL,'2022-11-26 22:47:36','2022-11-27 00:46:12','2022-11-27 00:46:12'),(62,8081,25,40731,9027,3,57,2,34397.75,NULL,'2022-11-26 22:47:36','2022-11-27 00:46:12','2022-11-27 00:46:12'),(63,8081,26,40731,9027,3,217,1,10.00,NULL,'2022-11-26 22:47:36','2022-11-27 00:45:38','2022-11-27 00:45:38'),(64,8081,26,40731,9027,3,68,1,2.10,NULL,'2022-11-26 22:47:36','2022-11-27 00:45:38','2022-11-27 00:45:38'),(65,8081,26,40731,9027,3,217,1,0.36,NULL,'2022-11-26 22:47:36','2022-11-27 00:45:38','2022-11-27 00:45:38'),(66,8081,26,40731,9027,3,57,2,12.46,NULL,'2022-11-26 22:47:36','2022-11-27 00:45:38','2022-11-27 00:45:38'),(67,8081,27,40731,9027,3,217,1,51662.20,NULL,'2022-11-26 22:47:37','2022-11-27 00:45:02','2022-11-27 00:45:02'),(68,8081,27,40731,9027,3,68,1,10849.06,NULL,'2022-11-26 22:47:37','2022-11-27 00:45:02','2022-11-27 00:45:02'),(69,8081,27,40731,9027,3,217,1,1875.34,NULL,'2022-11-26 22:47:37','2022-11-27 00:45:02','2022-11-27 00:45:02'),(70,8081,27,40731,9027,3,57,2,64386.60,NULL,'2022-11-26 22:47:37','2022-11-27 00:45:02','2022-11-27 00:45:02'),(71,8081,28,40731,9027,3,250,1,10400.00,NULL,'2022-11-26 22:47:37','2022-11-26 22:47:37',NULL),(72,8081,28,40731,9027,3,57,2,10400.00,NULL,'2022-11-26 22:47:37','2022-11-26 22:47:37',NULL),(73,8081,29,40731,9027,3,217,1,44073.35,NULL,'2022-11-26 22:47:37','2022-11-27 00:44:22','2022-11-27 00:44:22'),(74,8081,29,40731,9027,3,68,1,9255.41,NULL,'2022-11-26 22:47:37','2022-11-27 00:44:22','2022-11-27 00:44:22'),(75,8081,29,40731,9027,3,217,1,1599.86,NULL,'2022-11-26 22:47:37','2022-11-27 00:44:22','2022-11-27 00:44:22'),(76,8081,29,40731,9027,3,57,2,54928.62,NULL,'2022-11-26 22:47:37','2022-11-27 00:44:22','2022-11-27 00:44:22'),(77,8081,30,40731,9027,3,217,1,16.41,NULL,'2022-11-26 22:47:37','2022-11-26 22:47:37',NULL),(78,8081,30,40731,9027,3,68,1,3.45,NULL,'2022-11-26 22:47:37','2022-11-26 22:47:37',NULL),(79,8081,30,40731,9027,3,57,2,19.86,NULL,'2022-11-26 22:47:37','2022-11-26 22:47:37',NULL),(80,8081,31,40731,9027,3,217,1,56.20,NULL,'2022-11-26 22:47:37','2022-11-26 22:47:37',NULL);
INSERT INTO `balance_libro_details` VALUES (81,8081,31,40731,9027,3,68,1,11.80,NULL,'2022-11-26 22:47:37','2022-11-26 22:47:37',NULL),(82,8081,31,40731,9027,3,57,2,68.00,NULL,'2022-11-26 22:47:37','2022-11-26 22:47:37',NULL),(83,8081,32,40731,9027,3,217,1,22940.80,NULL,'2022-11-26 22:47:37','2022-11-27 00:43:45','2022-11-27 00:43:45'),(84,8081,32,40731,9027,3,68,1,4817.57,NULL,'2022-11-26 22:47:37','2022-11-27 00:43:45','2022-11-27 00:43:45'),(85,8081,32,40731,9027,3,217,1,832.75,NULL,'2022-11-26 22:47:37','2022-11-27 00:43:45','2022-11-27 00:43:45'),(86,8081,32,40731,9027,3,57,2,28591.12,NULL,'2022-11-26 22:47:37','2022-11-27 00:43:45','2022-11-27 00:43:45'),(87,8081,33,40731,9027,3,217,1,1113.00,NULL,'2022-11-26 22:47:37','2022-11-27 00:43:05','2022-11-27 00:43:05'),(88,8081,33,40731,9027,3,68,1,233.73,NULL,'2022-11-26 22:47:37','2022-11-27 00:43:05','2022-11-27 00:43:05'),(89,8081,33,40731,9027,3,217,1,40.40,NULL,'2022-11-26 22:47:37','2022-11-27 00:43:05','2022-11-27 00:43:05'),(90,8081,33,40731,9027,3,57,2,1387.13,NULL,'2022-11-26 22:47:37','2022-11-27 00:43:05','2022-11-27 00:43:05'),(91,8081,34,40731,9027,3,217,1,1113.00,NULL,'2022-11-27 00:43:05','2022-11-27 00:43:05',NULL),(92,8081,34,40731,9027,3,68,1,233.73,NULL,'2022-11-27 00:43:05','2022-11-27 00:43:05',NULL),(93,8081,34,40731,9027,3,226,1,40.40,NULL,'2022-11-27 00:43:05','2022-11-27 00:43:05',NULL),(94,8081,34,40731,9027,3,57,2,1387.13,NULL,'2022-11-27 00:43:05','2022-11-27 00:43:05',NULL),(95,8081,35,40731,9027,3,217,1,22940.80,NULL,'2022-11-27 00:43:45','2022-11-27 00:43:45',NULL),(96,8081,35,40731,9027,3,68,1,4817.57,NULL,'2022-11-27 00:43:45','2022-11-27 00:43:45',NULL),(97,8081,35,40731,9027,3,226,1,832.75,NULL,'2022-11-27 00:43:45','2022-11-27 00:43:45',NULL),(98,8081,35,40731,9027,3,57,2,28591.12,NULL,'2022-11-27 00:43:45','2022-11-27 00:43:45',NULL),(99,8081,36,40731,9027,3,217,1,44073.35,NULL,'2022-11-27 00:44:22','2022-11-27 00:44:22',NULL),(100,8081,36,40731,9027,3,68,1,9255.40,NULL,'2022-11-27 00:44:22','2022-11-27 00:44:22',NULL),(101,8081,36,40731,9027,3,225,1,1599.86,NULL,'2022-11-27 00:44:22','2022-11-27 00:44:22',NULL),(102,8081,36,40731,9027,3,57,2,54928.61,NULL,'2022-11-27 00:44:22','2022-11-27 00:44:22',NULL),(103,8081,37,40731,9027,3,217,1,51662.20,NULL,'2022-11-27 00:45:02','2022-11-27 00:45:02',NULL),(104,8081,37,40731,9027,3,68,1,10849.06,NULL,'2022-11-27 00:45:02','2022-11-27 00:45:02',NULL),(105,8081,37,40731,9027,3,226,1,1875.34,NULL,'2022-11-27 00:45:02','2022-11-27 00:45:02',NULL),(106,8081,37,40731,9027,3,57,2,64386.60,NULL,'2022-11-27 00:45:02','2022-11-27 00:45:02',NULL),(107,8081,38,40731,9027,3,217,1,10.00,NULL,'2022-11-27 00:45:38','2022-11-27 00:45:38',NULL),(108,8081,38,40731,9027,3,68,1,2.10,NULL,'2022-11-27 00:45:38','2022-11-27 00:45:38',NULL),(109,8081,38,40731,9027,3,225,1,0.36,NULL,'2022-11-27 00:45:38','2022-11-27 00:45:38',NULL),(110,8081,38,40731,9027,3,57,2,12.46,NULL,'2022-11-27 00:45:38','2022-11-27 00:45:38',NULL),(111,8081,39,40731,9027,3,217,1,27599.89,NULL,'2022-11-27 00:46:12','2022-11-27 00:46:12',NULL),(112,8081,39,40731,9027,3,68,1,5795.98,NULL,'2022-11-27 00:46:12','2022-11-27 00:46:12',NULL),(113,8081,39,40731,9027,3,226,1,1001.88,NULL,'2022-11-27 00:46:12','2022-11-27 00:46:12',NULL),(114,8081,39,40731,9027,3,57,2,34397.75,NULL,'2022-11-27 00:46:12','2022-11-27 00:46:12',NULL),(115,8081,40,40731,9027,3,217,1,14389.00,NULL,'2022-11-27 00:46:43','2022-11-27 00:46:43',NULL),(116,8081,40,40731,9027,3,68,1,3021.69,NULL,'2022-11-27 00:46:43','2022-11-27 00:46:43',NULL),(117,8081,40,40731,9027,3,226,1,522.32,NULL,'2022-11-27 00:46:43','2022-11-27 00:46:43',NULL),(118,8081,40,40731,9027,3,57,2,17933.01,NULL,'2022-11-27 00:46:43','2022-11-27 00:46:43',NULL),(119,8081,41,40731,9027,3,217,1,24891.75,NULL,'2022-11-27 00:47:35','2022-11-27 00:47:35',NULL),(120,8081,41,40731,9027,3,68,1,5227.27,NULL,'2022-11-27 00:47:35','2022-11-27 00:47:35',NULL),(121,8081,41,40731,9027,3,226,1,903.57,NULL,'2022-11-27 00:47:35','2022-11-27 00:47:35',NULL);
INSERT INTO `balance_libro_details` VALUES (122,8081,41,40731,9027,3,57,2,31022.59,NULL,'2022-11-27 00:47:35','2022-11-27 00:47:35',NULL),(123,8081,42,40731,9027,8,277,1,1110.43,NULL,'2022-11-27 00:58:55','2022-11-27 00:58:55',NULL),(124,8081,42,40731,9027,8,351,2,1110.43,NULL,'2022-11-27 00:58:55','2022-11-27 00:58:55',NULL),(125,8081,43,40731,9027,8,276,1,71.27,NULL,'2022-11-27 00:58:55','2022-11-27 00:58:55',NULL),(126,8081,43,40731,9027,8,351,2,71.27,NULL,'2022-11-27 00:58:55','2022-11-27 00:58:55',NULL),(127,8081,44,40731,9027,16,156,1,4459.31,NULL,'2022-11-27 01:01:17','2022-11-27 01:01:17',NULL),(128,8081,44,40731,9027,16,277,2,1110.43,NULL,'2022-11-27 01:01:17','2022-11-27 01:01:17',NULL),(129,8081,44,40731,9027,16,226,2,5176.26,NULL,'2022-11-27 01:01:17','2022-11-27 01:01:17',NULL),(130,8081,44,40731,9027,16,302,1,1827.38,NULL,'2022-11-27 01:01:17','2022-11-27 01:01:17',NULL),(131,8081,44,40731,9027,16,156,1,4289.28,NULL,'2022-11-27 01:01:17','2022-11-27 01:01:17',NULL),(132,8081,44,40731,9027,16,301,2,4799.27,NULL,'2022-11-27 01:01:17','2022-11-27 01:01:17',NULL),(133,8081,44,40731,9027,16,276,2,71.27,NULL,'2022-11-27 01:01:17','2022-11-27 01:01:17',NULL),(134,8081,44,40731,9027,16,225,2,1600.22,NULL,'2022-11-27 01:01:17','2022-11-27 01:01:17',NULL),(135,8081,44,40731,9027,16,301,1,2181.48,NULL,'2022-11-27 01:01:17','2022-11-27 01:01:17',NULL),(136,8081,45,40771,48402,2,218,2,1300.00,NULL,'2022-11-27 18:43:18','2022-11-27 18:43:18',NULL),(137,8081,45,40771,48402,2,13,1,1300.00,NULL,'2022-11-27 18:43:18','2022-11-27 18:43:18',NULL),(138,8081,46,40771,48402,2,218,2,1100.00,NULL,'2022-11-27 18:43:18','2022-11-27 18:43:18',NULL),(139,8081,46,40771,48402,2,13,1,1100.00,NULL,'2022-11-27 18:43:18','2022-11-27 18:43:18',NULL),(140,8081,47,40771,48402,2,218,2,10000.00,NULL,'2022-11-27 18:43:18','2022-11-27 18:43:18',NULL),(141,8081,47,40771,48402,2,13,1,10000.00,NULL,'2022-11-27 18:43:18','2022-11-27 18:43:18',NULL),(142,8081,48,40771,48402,2,218,2,1200.00,NULL,'2022-11-27 18:43:18','2022-11-27 18:43:18',NULL),(143,8081,48,40771,48402,2,13,1,1200.00,NULL,'2022-11-27 18:43:18','2022-11-27 18:43:18',NULL),(144,8081,49,40771,48402,2,218,2,4000.00,NULL,'2022-11-27 18:43:18','2022-11-27 18:43:18',NULL),(145,8081,49,40771,48402,2,13,1,4000.00,NULL,'2022-11-27 18:43:18','2022-11-27 18:43:18',NULL),(146,8081,50,40771,48402,2,218,2,2500.00,NULL,'2022-11-27 18:43:18','2022-11-27 18:43:18',NULL),(147,8081,50,40771,48402,2,13,1,2500.00,NULL,'2022-11-27 18:43:18','2022-11-27 18:43:18',NULL),(148,8081,51,40771,48402,2,218,2,2800.00,NULL,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(149,8081,51,40771,48402,2,13,1,2800.00,NULL,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(150,8081,52,40771,48402,2,218,2,1100.00,NULL,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(151,8081,52,40771,48402,2,13,1,1100.00,NULL,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(152,8081,53,40771,48402,2,218,2,1000.00,NULL,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(153,8081,53,40771,48402,2,13,1,1000.00,NULL,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(154,8081,54,40771,48402,2,218,2,1000.00,NULL,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(155,8081,54,40771,48402,2,13,1,1000.00,NULL,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(156,8081,55,40771,48402,2,218,2,1000.00,NULL,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(157,8081,55,40771,48402,2,13,1,1000.00,NULL,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(158,8081,56,40771,48402,2,218,2,23800.00,NULL,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(159,8081,56,40771,48402,2,13,1,23800.00,NULL,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(160,8081,57,40771,48402,2,218,2,11900.00,NULL,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(161,8081,57,40771,48402,2,13,1,11900.00,NULL,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(162,8081,58,40771,48402,2,218,2,3700.00,NULL,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL);
INSERT INTO `balance_libro_details` VALUES (163,8081,58,40771,48402,2,13,1,3700.00,NULL,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(164,8081,59,40771,48402,2,218,2,850.00,NULL,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(165,8081,59,40771,48402,2,13,1,850.00,NULL,'2022-11-27 18:43:19','2022-11-27 18:43:19',NULL),(214,8081,84,40771,48404,2,218,2,1000.00,NULL,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(215,8081,84,40771,48404,2,13,1,1000.00,NULL,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(216,8081,85,40771,48404,2,218,2,1500.00,NULL,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(217,8081,85,40771,48404,2,13,1,1500.00,NULL,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(218,8081,86,40771,48404,2,218,2,2200.00,NULL,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(219,8081,86,40771,48404,2,13,1,2200.00,NULL,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(220,8081,87,40771,48404,2,218,2,1300.00,NULL,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(221,8081,87,40771,48404,2,13,1,1300.00,NULL,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(222,8081,88,40771,48404,2,218,2,1200.00,NULL,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(223,8081,88,40771,48404,2,13,1,1200.00,NULL,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(224,8081,89,40771,48404,2,218,2,1400.00,NULL,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(225,8081,89,40771,48404,2,13,1,1400.00,NULL,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(226,8081,90,40771,48404,2,218,2,3500.00,NULL,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(227,8081,90,40771,48404,2,13,1,3500.00,NULL,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(228,8081,91,40771,48404,2,218,2,2500.00,NULL,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(229,8081,91,40771,48404,2,13,1,2500.00,NULL,'2022-11-27 19:35:40','2022-11-27 19:35:40',NULL),(230,8081,92,40771,48404,2,218,2,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(231,8081,92,40771,48404,2,13,1,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(232,8081,93,40771,48404,2,218,2,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(233,8081,93,40771,48404,2,13,1,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(234,8081,94,40771,48404,2,218,2,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(235,8081,94,40771,48404,2,13,1,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(236,8081,95,40771,48404,2,218,2,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(237,8081,95,40771,48404,2,13,1,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(238,8081,96,40771,48404,2,218,2,8400.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(239,8081,96,40771,48404,2,13,1,8400.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(240,8081,97,40771,48404,2,218,2,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(241,8081,97,40771,48404,2,13,1,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(242,8081,98,40771,48404,2,218,2,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(243,8081,98,40771,48404,2,13,1,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(244,8081,99,40771,48404,2,218,2,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(245,8081,99,40771,48404,2,13,1,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(246,8081,100,40771,48404,2,218,2,2500.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(247,8081,100,40771,48404,2,13,1,2500.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(248,8081,101,40771,48404,2,218,2,3500.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(249,8081,101,40771,48404,2,13,1,3500.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(250,8081,102,40771,48404,2,218,2,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(251,8081,102,40771,48404,2,13,1,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL);
INSERT INTO `balance_libro_details` VALUES (252,8081,103,40771,48404,2,218,2,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(253,8081,103,40771,48404,2,13,1,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(254,8081,104,40771,48404,2,218,2,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(255,8081,104,40771,48404,2,13,1,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(256,8081,105,40771,48404,2,218,2,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(257,8081,105,40771,48404,2,13,1,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(258,8081,106,40771,48404,2,218,2,2500.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(259,8081,106,40771,48404,2,13,1,2500.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(260,8081,107,40771,48404,2,218,2,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(261,8081,107,40771,48404,2,13,1,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(262,8081,108,40771,48404,2,218,2,7000.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(263,8081,108,40771,48404,2,13,1,7000.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(264,8081,109,40771,48404,2,218,2,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(265,8081,109,40771,48404,2,13,1,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(266,8081,110,40771,48404,2,218,2,5600.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(267,8081,110,40771,48404,2,13,1,5600.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(268,8081,111,40771,48404,2,218,2,5000.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(269,8081,111,40771,48404,2,13,1,5000.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(270,8081,112,40771,48404,2,218,2,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(271,8081,112,40771,48404,2,13,1,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(272,8081,113,40771,48404,2,218,2,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(273,8081,113,40771,48404,2,13,1,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(274,8081,114,40771,48404,2,218,2,7800.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(275,8081,114,40771,48404,2,13,1,7800.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(276,8081,115,40771,48404,2,218,2,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(277,8081,115,40771,48404,2,13,1,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(278,8081,116,40771,48404,2,218,2,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(279,8081,116,40771,48404,2,13,1,1300.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(280,8081,117,40771,48404,2,218,2,1100.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(281,8081,117,40771,48404,2,13,1,1100.00,NULL,'2022-11-27 19:35:41','2022-11-27 19:35:41',NULL),(282,8081,118,40771,48405,2,218,2,19150.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(283,8081,118,40771,48405,2,13,1,19150.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(284,8081,119,40771,48405,2,218,2,1100.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(285,8081,119,40771,48405,2,13,1,1100.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(286,8081,120,40771,48405,2,218,2,28050.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(287,8081,120,40771,48405,2,13,1,28050.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(288,8081,121,40771,48405,2,218,2,1200.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(289,8081,121,40771,48405,2,13,1,1200.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(290,8081,122,40771,48405,2,218,2,1100.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(291,8081,122,40771,48405,2,13,1,1100.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(292,8081,123,40771,48405,2,218,2,1100.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL);
INSERT INTO `balance_libro_details` VALUES (293,8081,123,40771,48405,2,13,1,1100.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(294,8081,124,40771,48405,2,218,2,4900.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(295,8081,124,40771,48405,2,13,1,4900.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(296,8081,125,40771,48405,2,218,2,1100.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(297,8081,125,40771,48405,2,13,1,1100.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(298,8081,126,40771,48405,2,218,2,5000.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(299,8081,126,40771,48405,2,13,1,5000.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(300,8081,127,40771,48405,2,218,2,2500.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(301,8081,127,40771,48405,2,13,1,2500.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(302,8081,128,40771,48405,2,218,2,2500.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(303,8081,128,40771,48405,2,13,1,2500.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(304,8081,129,40771,48405,2,218,2,5000.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(305,8081,129,40771,48405,2,13,1,5000.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(306,8081,130,40771,48405,2,218,2,2500.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(307,8081,130,40771,48405,2,13,1,2500.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(308,8081,131,40771,48405,2,218,2,1100.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(309,8081,131,40771,48405,2,13,1,1100.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(310,8081,132,40771,48405,2,218,2,5000.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(311,8081,132,40771,48405,2,13,1,5000.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(312,8081,133,40771,48405,2,218,2,1300.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(313,8081,133,40771,48405,2,13,1,1300.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(314,8081,134,40771,48405,2,218,2,1300.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(315,8081,134,40771,48405,2,13,1,1300.00,NULL,'2022-11-27 19:37:34','2022-11-27 19:37:34',NULL),(316,8081,135,40771,48406,2,218,2,1400.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(317,8081,135,40771,48406,2,13,1,1400.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(318,8081,136,40771,48406,2,218,2,1100.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(319,8081,136,40771,48406,2,13,1,1100.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(320,8081,137,40771,48406,2,218,2,1100.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(321,8081,137,40771,48406,2,13,1,1100.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(322,8081,138,40771,48406,2,218,2,1300.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(323,8081,138,40771,48406,2,13,1,1300.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(324,8081,139,40771,48406,2,218,2,1100.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(325,8081,139,40771,48406,2,13,1,1100.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(326,8081,140,40771,48406,2,218,2,1100.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(327,8081,140,40771,48406,2,13,1,1100.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(328,8081,141,40771,48406,2,218,2,1400.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(329,8081,141,40771,48406,2,13,1,1400.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(330,8081,142,40771,48406,2,218,2,21750.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(331,8081,142,40771,48406,2,13,1,21750.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(332,8081,143,40771,48406,2,218,2,1300.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(333,8081,143,40771,48406,2,13,1,1300.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL);
INSERT INTO `balance_libro_details` VALUES (334,8081,144,40771,48406,2,218,2,1100.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(335,8081,144,40771,48406,2,13,1,1100.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(336,8081,145,40771,48406,2,218,2,1400.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(337,8081,145,40771,48406,2,13,1,1400.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(338,8081,146,40771,48406,2,218,2,1100.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(339,8081,146,40771,48406,2,13,1,1100.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(340,8081,147,40771,48406,2,218,2,25650.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(341,8081,147,40771,48406,2,13,1,25650.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(342,8081,148,40771,48406,2,218,2,42750.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(343,8081,148,40771,48406,2,13,1,42750.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(344,8081,149,40771,48406,2,218,2,1950.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(345,8081,149,40771,48406,2,13,1,1950.00,NULL,'2022-11-27 19:39:33','2022-11-27 19:39:33',NULL),(346,8081,150,40771,48407,2,218,2,1100.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(347,8081,150,40771,48407,2,13,1,1100.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(348,8081,151,40771,48407,2,218,2,1100.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(349,8081,151,40771,48407,2,13,1,1100.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(350,8081,152,40771,48407,2,218,2,2500.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(351,8081,152,40771,48407,2,13,1,2500.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(352,8081,153,40771,48407,2,218,2,2600.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(353,8081,153,40771,48407,2,13,1,2600.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(354,8081,154,40771,48407,2,218,2,2800.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(355,8081,154,40771,48407,2,13,1,2800.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(356,8081,155,40771,48407,2,218,2,1400.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(357,8081,155,40771,48407,2,13,1,1400.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(358,8081,156,40771,48407,2,218,2,1400.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(359,8081,156,40771,48407,2,13,1,1400.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(360,8081,157,40771,48407,2,218,2,1200.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(361,8081,157,40771,48407,2,13,1,1200.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(362,8081,158,40771,48407,2,218,2,1500.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(363,8081,158,40771,48407,2,13,1,1500.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(364,8081,159,40771,48407,2,218,2,1200.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(365,8081,159,40771,48407,2,13,1,1200.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(366,8081,160,40771,48407,2,218,2,5000.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(367,8081,160,40771,48407,2,13,1,5000.00,NULL,'2022-11-27 19:40:11','2022-11-27 19:40:11',NULL),(368,8081,161,40771,48407,2,218,2,1500.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(369,8081,161,40771,48407,2,13,1,1500.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(370,8081,162,40771,48407,2,218,2,5000.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(371,8081,162,40771,48407,2,13,1,5000.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(372,8081,163,40771,48407,2,218,2,3000.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(373,8081,163,40771,48407,2,13,1,3000.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(374,8081,164,40771,48407,2,218,2,3000.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL);
INSERT INTO `balance_libro_details` VALUES (375,8081,164,40771,48407,2,13,1,3000.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(376,8081,165,40771,48407,2,218,2,3000.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(377,8081,165,40771,48407,2,13,1,3000.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(378,8081,166,40771,48407,2,218,2,2000.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(379,8081,166,40771,48407,2,13,1,2000.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(380,8081,167,40771,48407,2,218,2,5000.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(381,8081,167,40771,48407,2,13,1,5000.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(382,8081,168,40771,48407,2,218,2,5000.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(383,8081,168,40771,48407,2,13,1,5000.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(384,8081,169,40771,48407,2,218,2,2500.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(385,8081,169,40771,48407,2,13,1,2500.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(386,8081,170,40771,48407,2,218,2,5000.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(387,8081,170,40771,48407,2,13,1,5000.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(388,8081,171,40771,48407,2,218,2,9000.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(389,8081,171,40771,48407,2,13,1,9000.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(390,8081,172,40771,48407,2,218,2,4500.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(391,8081,172,40771,48407,2,13,1,4500.00,NULL,'2022-11-27 19:40:12','2022-11-27 19:40:12',NULL),(392,8081,173,40771,48408,2,218,2,1200.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(393,8081,173,40771,48408,2,13,1,1200.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(394,8081,174,40771,48408,2,218,2,1200.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(395,8081,174,40771,48408,2,13,1,1200.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(396,8081,175,40771,48408,2,218,2,1400.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(397,8081,175,40771,48408,2,13,1,1400.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(398,8081,176,40771,48408,2,218,2,1400.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(399,8081,176,40771,48408,2,13,1,1400.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(400,8081,177,40771,48408,2,218,2,15000.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(401,8081,177,40771,48408,2,13,1,15000.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(402,8081,178,40771,48408,2,218,2,13500.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(403,8081,178,40771,48408,2,13,1,13500.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(404,8081,179,40771,48408,2,218,2,1200.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(405,8081,179,40771,48408,2,13,1,1200.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(406,8081,180,40771,48408,2,218,2,5000.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(407,8081,180,40771,48408,2,13,1,5000.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(408,8081,181,40771,48408,2,218,2,6000.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(409,8081,181,40771,48408,2,13,1,6000.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(410,8081,182,40771,48408,2,218,2,5000.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(411,8081,182,40771,48408,2,13,1,5000.00,NULL,'2022-11-27 19:40:54','2022-11-27 19:40:54',NULL),(412,8081,183,40771,48408,2,218,2,1500.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(413,8081,183,40771,48408,2,13,1,1500.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(414,8081,184,40771,48408,2,218,2,4500.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(415,8081,184,40771,48408,2,13,1,4500.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL);
INSERT INTO `balance_libro_details` VALUES (416,8081,185,40771,48408,2,218,2,3300.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(417,8081,185,40771,48408,2,13,1,3300.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(418,8081,186,40771,48408,2,218,2,1300.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(419,8081,186,40771,48408,2,13,1,1300.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(420,8081,187,40771,48408,2,218,2,14500.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(421,8081,187,40771,48408,2,13,1,14500.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(422,8081,188,40771,48408,2,218,2,7000.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(423,8081,188,40771,48408,2,13,1,7000.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(424,8081,189,40771,48408,2,218,2,15000.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(425,8081,189,40771,48408,2,13,1,15000.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(426,8081,190,40771,48408,2,218,2,7500.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(427,8081,190,40771,48408,2,13,1,7500.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(428,8081,191,40771,48408,2,218,2,2500.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(429,8081,191,40771,48408,2,13,1,2500.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(430,8081,192,40771,48408,2,218,2,6600.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(431,8081,192,40771,48408,2,13,1,6600.00,NULL,'2022-11-27 19:40:55','2022-11-27 19:40:55',NULL),(432,8081,193,40771,48409,2,218,2,28600.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(433,8081,193,40771,48409,2,13,1,28600.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(434,8081,194,40771,48409,2,218,2,35200.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(435,8081,194,40771,48409,2,13,1,35200.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(436,8081,195,40771,48409,2,218,2,1300.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(437,8081,195,40771,48409,2,13,1,1300.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(438,8081,196,40771,48409,2,218,2,1300.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(439,8081,196,40771,48409,2,13,1,1300.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(440,8081,197,40771,48409,2,218,2,1700.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(441,8081,197,40771,48409,2,13,1,1700.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(442,8081,198,40771,48409,2,218,2,1500.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(443,8081,198,40771,48409,2,13,1,1500.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(444,8081,199,40771,48409,2,218,2,1500.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(445,8081,199,40771,48409,2,13,1,1500.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(446,8081,200,40771,48409,2,218,2,1300.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(447,8081,200,40771,48409,2,13,1,1300.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(448,8081,201,40771,48409,2,218,2,1500.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(449,8081,201,40771,48409,2,13,1,1500.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(450,8081,202,40771,48409,2,218,2,21750.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(451,8081,202,40771,48409,2,13,1,21750.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(452,8081,203,40771,48409,2,218,2,1500.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(453,8081,203,40771,48409,2,13,1,1500.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(454,8081,204,40771,48409,2,218,2,9000.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(455,8081,204,40771,48409,2,13,1,9000.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(456,8081,205,40771,48409,2,218,2,1500.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL);
INSERT INTO `balance_libro_details` VALUES (457,8081,205,40771,48409,2,13,1,1500.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(458,8081,206,40771,48409,2,218,2,2000.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(459,8081,206,40771,48409,2,13,1,2000.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(460,8081,207,40771,48409,2,218,2,1700.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(461,8081,207,40771,48409,2,13,1,1700.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(462,8081,208,40771,48409,2,218,2,2500.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(463,8081,208,40771,48409,2,13,1,2500.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(464,8081,209,40771,48409,2,218,2,2000.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(465,8081,209,40771,48409,2,13,1,2000.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(466,8081,210,40771,48409,2,218,2,5000.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(467,8081,210,40771,48409,2,13,1,5000.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(468,8081,211,40771,48409,2,218,2,4500.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(469,8081,211,40771,48409,2,13,1,4500.00,NULL,'2022-11-27 19:43:08','2022-11-27 19:43:08',NULL),(470,8081,212,40771,48410,2,218,2,2000.00,NULL,'2022-11-27 19:43:31','2022-11-27 19:43:31',NULL),(471,8081,212,40771,48410,2,13,1,2000.00,NULL,'2022-11-27 19:43:31','2022-11-27 19:43:31',NULL),(472,8081,213,40771,48410,2,218,2,1500.00,NULL,'2022-11-27 19:43:31','2022-11-27 19:43:31',NULL),(473,8081,213,40771,48410,2,13,1,1500.00,NULL,'2022-11-27 19:43:31','2022-11-27 19:43:31',NULL),(474,8081,214,40771,48410,2,218,2,2000.00,NULL,'2022-11-27 19:43:31','2022-11-27 19:43:31',NULL),(475,8081,214,40771,48410,2,13,1,2000.00,NULL,'2022-11-27 19:43:31','2022-11-27 19:43:31',NULL),(476,8081,215,40771,48410,2,218,2,11000.00,NULL,'2022-11-27 19:43:31','2022-11-27 19:43:31',NULL),(477,8081,215,40771,48410,2,13,1,11000.00,NULL,'2022-11-27 19:43:31','2022-11-27 19:43:31',NULL),(478,8081,216,40771,48410,2,218,2,1500.00,NULL,'2022-11-27 19:43:31','2022-11-27 19:43:31',NULL),(479,8081,216,40771,48410,2,13,1,1500.00,NULL,'2022-11-27 19:43:31','2022-11-27 19:43:31',NULL),(480,8081,217,40771,48410,2,218,2,1500.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(481,8081,217,40771,48410,2,13,1,1500.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(482,8081,218,40771,48410,2,218,2,2000.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(483,8081,218,40771,48410,2,13,1,2000.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(484,8081,219,40771,48410,2,218,2,12100.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(485,8081,219,40771,48410,2,13,1,12100.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(486,8081,220,40771,48410,2,218,2,1500.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(487,8081,220,40771,48410,2,13,1,1500.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(488,8081,221,40771,48410,2,218,2,1500.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(489,8081,221,40771,48410,2,13,1,1500.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(490,8081,222,40771,48410,2,218,2,3400.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(491,8081,222,40771,48410,2,13,1,3400.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(492,8081,223,40771,48410,2,218,2,1800.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(493,8081,223,40771,48410,2,13,1,1800.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(494,8081,224,40771,48410,2,218,2,1800.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(495,8081,224,40771,48410,2,13,1,1800.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(496,8081,225,40771,48410,2,218,2,40800.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(497,8081,225,40771,48410,2,13,1,40800.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL);
INSERT INTO `balance_libro_details` VALUES (498,8081,226,40771,48410,2,218,2,7200.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(499,8081,226,40771,48410,2,13,1,7200.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(500,8081,227,40771,48410,2,218,2,2200.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(501,8081,227,40771,48410,2,13,1,2200.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(502,8081,228,40771,48410,2,218,2,1600.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(503,8081,228,40771,48410,2,13,1,1600.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(504,8081,229,40771,48410,2,218,2,68400.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(505,8081,229,40771,48410,2,13,1,68400.00,NULL,'2022-11-27 19:43:32','2022-11-27 19:43:32',NULL),(506,8081,230,40771,48411,2,218,2,2000.00,NULL,'2022-11-27 19:44:02','2022-11-27 19:44:02',NULL),(507,8081,230,40771,48411,2,13,1,2000.00,NULL,'2022-11-27 19:44:02','2022-11-27 19:44:02',NULL),(508,8081,231,40771,48411,2,218,2,1600.00,NULL,'2022-11-27 19:44:02','2022-11-27 19:44:02',NULL),(509,8081,231,40771,48411,2,13,1,1600.00,NULL,'2022-11-27 19:44:02','2022-11-27 19:44:02',NULL),(510,8081,232,40771,48411,2,218,2,3000.00,NULL,'2022-11-27 19:44:02','2022-11-27 19:44:02',NULL),(511,8081,232,40771,48411,2,13,1,3000.00,NULL,'2022-11-27 19:44:02','2022-11-27 19:44:02',NULL),(512,8081,233,40771,48411,2,218,2,1600.00,NULL,'2022-11-27 19:44:02','2022-11-27 19:44:02',NULL),(513,8081,233,40771,48411,2,13,1,1600.00,NULL,'2022-11-27 19:44:02','2022-11-27 19:44:02',NULL),(514,8081,234,40771,48411,2,218,2,1600.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(515,8081,234,40771,48411,2,13,1,1600.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(516,8081,235,40771,48411,2,218,2,1600.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(517,8081,235,40771,48411,2,13,1,1600.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(518,8081,236,40771,48411,2,218,2,2500.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(519,8081,236,40771,48411,2,13,1,2500.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(520,8081,237,40771,48411,2,218,2,6000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(521,8081,237,40771,48411,2,13,1,6000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(522,8081,238,40771,48411,2,218,2,3500.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(523,8081,238,40771,48411,2,13,1,3500.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(524,8081,239,40771,48411,2,218,2,6000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(525,8081,239,40771,48411,2,13,1,6000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(526,8081,240,40771,48411,2,218,2,6000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(527,8081,240,40771,48411,2,13,1,6000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(528,8081,241,40771,48411,2,218,2,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(529,8081,241,40771,48411,2,13,1,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(530,8081,242,40771,48411,2,218,2,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(531,8081,242,40771,48411,2,13,1,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(532,8081,243,40771,48411,2,218,2,4000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(533,8081,243,40771,48411,2,13,1,4000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(534,8081,244,40771,48411,2,218,2,1800.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(535,8081,244,40771,48411,2,13,1,1800.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(536,8081,245,40771,48411,2,218,2,6000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(537,8081,245,40771,48411,2,13,1,6000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(538,8081,246,40771,48411,2,218,2,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL);
INSERT INTO `balance_libro_details` VALUES (539,8081,246,40771,48411,2,13,1,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(540,8081,247,40771,48411,2,218,2,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(541,8081,247,40771,48411,2,13,1,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(542,8081,248,40771,48411,2,218,2,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(543,8081,248,40771,48411,2,13,1,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(544,8081,249,40771,48411,2,218,2,5000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(545,8081,249,40771,48411,2,13,1,5000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(546,8081,250,40771,48411,2,218,2,5000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(547,8081,250,40771,48411,2,13,1,5000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(548,8081,251,40771,48411,2,218,2,6000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(549,8081,251,40771,48411,2,13,1,6000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(550,8081,252,40771,48411,2,218,2,1800.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(551,8081,252,40771,48411,2,13,1,1800.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(552,8081,253,40771,48411,2,218,2,1800.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(553,8081,253,40771,48411,2,13,1,1800.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(554,8081,254,40771,48411,2,218,2,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(555,8081,254,40771,48411,2,13,1,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(556,8081,255,40771,48411,2,218,2,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(557,8081,255,40771,48411,2,13,1,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(558,8081,256,40771,48411,2,218,2,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(559,8081,256,40771,48411,2,13,1,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(560,8081,257,40771,48411,2,218,2,2800.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(561,8081,257,40771,48411,2,13,1,2800.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(562,8081,258,40771,48411,2,218,2,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(563,8081,258,40771,48411,2,13,1,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(564,8081,259,40771,48411,2,218,2,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(565,8081,259,40771,48411,2,13,1,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(566,8081,260,40771,48411,2,218,2,4500.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(567,8081,260,40771,48411,2,13,1,4500.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(568,8081,261,40771,48411,2,218,2,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(569,8081,261,40771,48411,2,13,1,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(570,8081,262,40771,48411,2,218,2,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(571,8081,262,40771,48411,2,13,1,2000.00,NULL,'2022-11-27 19:44:03','2022-11-27 19:44:03',NULL),(572,8081,263,40771,48411,2,218,2,2000.00,NULL,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(573,8081,263,40771,48411,2,13,1,2000.00,NULL,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(574,8081,264,40771,48411,2,218,2,2000.00,NULL,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(575,8081,264,40771,48411,2,13,1,2000.00,NULL,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(576,8081,265,40771,48411,2,218,2,1800.00,NULL,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(577,8081,265,40771,48411,2,13,1,1800.00,NULL,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(578,8081,266,40771,48411,2,218,2,2000.00,NULL,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(579,8081,266,40771,48411,2,13,1,2000.00,NULL,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL);
INSERT INTO `balance_libro_details` VALUES (580,8081,267,40771,48411,2,218,2,2000.00,NULL,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(581,8081,267,40771,48411,2,13,1,2000.00,NULL,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(582,8081,268,40771,48411,2,218,2,4500.00,NULL,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(583,8081,268,40771,48411,2,13,1,4500.00,NULL,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(584,8081,269,40771,48411,2,218,2,5000.00,NULL,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(585,8081,269,40771,48411,2,13,1,5000.00,NULL,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(586,8081,270,40771,48411,2,218,2,5000.00,NULL,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(587,8081,270,40771,48411,2,13,1,5000.00,NULL,'2022-11-27 19:44:04','2022-11-27 19:44:04',NULL),(612,8081,283,40771,48403,2,218,2,1000.00,NULL,'2022-11-27 19:51:51','2022-11-27 19:51:51',NULL),(613,8081,283,40771,48403,2,13,1,1000.00,NULL,'2022-11-27 19:51:51','2022-11-27 19:51:51',NULL),(614,8081,284,40771,48403,2,218,2,1000.00,NULL,'2022-11-27 19:51:51','2022-11-30 21:14:50','2022-11-30 21:14:50'),(615,8081,284,40771,48403,2,13,1,1000.00,NULL,'2022-11-27 19:51:51','2022-11-30 21:14:50','2022-11-30 21:14:50'),(616,8081,285,40771,48403,2,218,2,3200.00,NULL,'2022-11-27 19:51:51','2022-11-27 19:51:51',NULL),(617,8081,285,40771,48403,2,13,1,3200.00,NULL,'2022-11-27 19:51:51','2022-11-27 19:51:51',NULL),(618,8081,286,40771,48403,2,218,2,1300.00,NULL,'2022-11-27 19:51:51','2022-11-30 21:15:17','2022-11-30 21:15:17'),(619,8081,286,40771,48403,2,13,1,1300.00,NULL,'2022-11-27 19:51:51','2022-11-30 21:15:17','2022-11-30 21:15:17'),(620,8081,287,40771,48403,2,218,2,1300.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(621,8081,287,40771,48403,2,13,1,1300.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(622,8081,288,40771,48403,2,218,2,1800.00,NULL,'2022-11-27 19:51:52','2022-11-30 21:15:39','2022-11-30 21:15:39'),(623,8081,288,40771,48403,2,13,1,1800.00,NULL,'2022-11-27 19:51:52','2022-11-30 21:15:39','2022-11-30 21:15:39'),(624,8081,289,40771,48403,2,218,2,1000.00,NULL,'2022-11-27 19:51:52','2022-11-30 21:16:00','2022-11-30 21:16:00'),(625,8081,289,40771,48403,2,13,1,1000.00,NULL,'2022-11-27 19:51:52','2022-11-30 21:16:00','2022-11-30 21:16:00'),(626,8081,290,40771,48403,2,218,2,1000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(627,8081,290,40771,48403,2,13,1,1000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(628,8081,291,40771,48403,2,218,2,1000.00,NULL,'2022-11-27 19:51:52','2022-11-30 21:16:24','2022-11-30 21:16:24'),(629,8081,291,40771,48403,2,13,1,1000.00,NULL,'2022-11-27 19:51:52','2022-11-30 21:16:24','2022-11-30 21:16:24'),(630,8081,292,40771,48403,2,218,2,1000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(631,8081,292,40771,48403,2,13,1,1000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(632,8081,293,40771,48403,2,218,2,1000.00,NULL,'2022-11-27 19:51:52','2022-11-30 21:14:06','2022-11-30 21:14:06'),(633,8081,293,40771,48403,2,13,1,1000.00,NULL,'2022-11-27 19:51:52','2022-11-30 21:14:06','2022-11-30 21:14:06'),(634,8081,294,40771,48403,2,218,2,7000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(635,8081,294,40771,48403,2,13,1,7000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(636,8081,295,40771,48403,2,218,2,3000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(637,8081,295,40771,48403,2,13,1,3000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(638,8081,296,40771,48403,2,218,2,8000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(639,8081,296,40771,48403,2,13,1,8000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(640,8081,297,40771,48403,2,218,2,2500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(641,8081,297,40771,48403,2,13,1,2500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(642,8081,298,40771,48403,2,218,2,1500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL);
INSERT INTO `balance_libro_details` VALUES (643,8081,298,40771,48403,2,13,1,1500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(644,8081,299,40771,48403,2,218,2,1000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(645,8081,299,40771,48403,2,13,1,1000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(646,8081,300,40771,48403,2,218,2,8000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(647,8081,300,40771,48403,2,13,1,8000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(648,8081,301,40771,48403,2,218,2,1000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(649,8081,301,40771,48403,2,13,1,1000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(650,8081,302,40771,48403,2,218,2,3500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(651,8081,302,40771,48403,2,13,1,3500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(652,8081,303,40771,48403,2,218,1,8000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(653,8081,303,40771,48403,2,13,2,8000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(654,8081,304,40771,48403,2,218,2,2000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(655,8081,304,40771,48403,2,13,1,2000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(656,8081,305,40771,48403,2,218,2,1500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(657,8081,305,40771,48403,2,13,1,1500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(658,8081,306,40771,48403,2,218,2,2500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(659,8081,306,40771,48403,2,13,1,2500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(660,8081,307,40771,48403,2,218,2,3500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(661,8081,307,40771,48403,2,13,1,3500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(662,8081,308,40771,48403,2,218,2,1500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(663,8081,308,40771,48403,2,13,1,1500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(664,8081,309,40771,48403,2,218,2,1500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(665,8081,309,40771,48403,2,13,1,1500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(666,8081,310,40771,48403,2,218,2,6000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(667,8081,310,40771,48403,2,13,1,6000.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(668,8081,311,40771,48403,2,218,2,1500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(669,8081,311,40771,48403,2,13,1,1500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(670,8081,312,40771,48403,2,218,2,1500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(671,8081,312,40771,48403,2,13,1,1500.00,NULL,'2022-11-27 19:51:52','2022-11-27 19:51:52',NULL),(672,8081,313,40771,48412,2,218,2,6000.00,NULL,'2022-11-27 20:16:00','2022-11-27 20:16:52','2022-11-27 20:16:52'),(673,8081,313,40771,48412,2,13,1,6000.00,NULL,'2022-11-27 20:16:00','2022-11-27 20:16:52','2022-11-27 20:16:52'),(674,8081,314,40720,1515,8,277,1,416.00,NULL,'2022-11-28 11:29:09','2022-11-28 11:29:09',NULL),(675,8081,314,40720,1515,8,351,2,416.00,NULL,'2022-11-28 11:29:09','2022-11-28 11:29:09',NULL),(676,8081,315,40720,1515,16,156,1,6582.40,NULL,'2022-11-28 20:47:31','2022-11-28 20:47:31',NULL),(677,8081,315,40720,1515,16,302,2,861.99,NULL,'2022-11-28 20:47:31','2022-11-28 20:47:31',NULL),(678,8081,315,40720,1515,16,277,2,416.00,NULL,'2022-11-28 20:47:31','2022-11-28 20:47:31',NULL),(679,8081,315,40720,1515,16,327,2,5304.41,NULL,'2022-11-28 20:47:31','2022-11-28 20:47:31',NULL),(680,8081,315,40720,1515,16,156,1,10417.60,NULL,'2022-11-28 20:47:31','2022-11-28 20:47:31',NULL),(681,8081,315,40720,1515,16,301,2,10884.18,NULL,'2022-11-28 20:47:31','2022-11-28 20:47:31',NULL),(682,8081,315,40720,1515,16,301,1,466.58,NULL,'2022-11-28 20:47:31','2022-11-28 20:47:31',NULL),(683,8081,316,40918,178692,3,217,1,8102.89,NULL,'2022-11-30 00:04:18','2022-11-30 00:04:18',NULL);
INSERT INTO `balance_libro_details` VALUES (684,8081,316,40918,178692,3,68,1,882.12,NULL,'2022-11-30 00:04:18','2022-11-30 00:04:18',NULL),(685,8081,316,40918,178692,3,57,2,8985.00,NULL,'2022-11-30 00:04:18','2022-11-30 00:04:18',NULL),(686,8081,316,40918,178692,3,136,2,0.01,NULL,'2022-11-30 00:04:18','2022-11-30 00:04:18',NULL),(687,8081,317,40918,178692,3,217,1,1306.67,NULL,'2022-11-30 00:04:18','2022-11-30 00:04:18',NULL),(688,8081,317,40918,178692,3,68,1,274.40,NULL,'2022-11-30 00:04:18','2022-11-30 00:04:18',NULL),(689,8081,317,40918,178692,3,57,2,1581.07,NULL,'2022-11-30 00:04:18','2022-11-30 00:04:18',NULL),(690,8081,318,40918,178692,3,217,1,22990.08,NULL,'2022-11-30 00:04:18','2022-11-30 00:04:18',NULL),(691,8081,318,40918,178692,3,68,1,4827.92,NULL,'2022-11-30 00:04:18','2022-11-30 00:04:18',NULL),(692,8081,318,40918,178692,3,57,2,27818.00,NULL,'2022-11-30 00:04:18','2022-11-30 00:04:18',NULL),(693,8081,319,40918,178692,3,217,1,19008.26,NULL,'2022-11-30 00:04:18','2022-11-30 00:04:18',NULL),(694,8081,319,40918,178692,3,68,1,3991.74,NULL,'2022-11-30 00:04:18','2022-11-30 00:04:18',NULL),(695,8081,319,40918,178692,3,57,2,23000.00,NULL,'2022-11-30 00:04:18','2022-11-30 00:04:18',NULL),(696,8081,320,40918,178692,2,218,2,6500.00,NULL,'2022-11-30 00:04:34','2022-11-30 00:04:34',NULL),(697,8081,320,40918,178692,2,13,1,6500.00,NULL,'2022-11-30 00:04:34','2022-11-30 00:04:34',NULL),(698,8081,321,40918,178692,2,218,2,1800.00,NULL,'2022-11-30 00:04:34','2022-11-30 00:04:34',NULL),(699,8081,321,40918,178692,2,13,1,1800.00,NULL,'2022-11-30 00:04:34','2022-11-30 00:04:34',NULL),(700,8081,322,40918,178692,2,218,2,1800.00,NULL,'2022-11-30 00:04:34','2022-11-30 00:04:34',NULL),(701,8081,322,40918,178692,2,13,1,1800.00,NULL,'2022-11-30 00:04:34','2022-11-30 00:04:34',NULL),(702,8081,323,40918,178692,2,218,2,2500.00,NULL,'2022-11-30 00:04:34','2022-11-30 00:04:34',NULL),(703,8081,323,40918,178692,2,13,1,2500.00,NULL,'2022-11-30 00:04:34','2022-11-30 00:04:34',NULL),(704,8081,324,40918,178692,2,218,2,4500.00,NULL,'2022-11-30 00:04:34','2022-11-30 00:04:34',NULL),(705,8081,324,40918,178692,2,13,1,4500.00,NULL,'2022-11-30 00:04:34','2022-11-30 00:04:34',NULL),(706,8081,325,40918,178692,2,218,2,3000.00,NULL,'2022-11-30 00:04:34','2022-11-30 00:04:34',NULL),(707,8081,325,40918,178692,2,13,1,3000.00,NULL,'2022-11-30 00:04:34','2022-11-30 00:04:34',NULL),(708,8081,326,40918,178693,2,218,2,6000.00,NULL,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(709,8081,326,40918,178693,2,13,1,6000.00,NULL,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(710,8081,327,40918,178693,2,218,2,6300.00,NULL,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(711,8081,327,40918,178693,2,13,1,6300.00,NULL,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(712,8081,328,40918,178693,2,218,2,3000.00,NULL,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(713,8081,328,40918,178693,2,13,1,3000.00,NULL,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(714,8081,329,40918,178693,2,218,2,4000.00,NULL,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(715,8081,329,40918,178693,2,13,1,4000.00,NULL,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(716,8081,330,40918,178693,2,218,2,1800.00,NULL,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(717,8081,330,40918,178693,2,13,1,1800.00,NULL,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(718,8081,331,40918,178693,2,218,2,4600.00,NULL,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(719,8081,331,40918,178693,2,13,1,4600.00,NULL,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(720,8081,332,40918,178693,2,218,2,5400.00,NULL,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(721,8081,332,40918,178693,2,13,1,5400.00,NULL,'2022-11-30 00:05:09','2022-11-30 00:05:09',NULL),(722,8081,333,40918,178694,2,218,2,2200.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(723,8081,333,40918,178694,2,13,1,2200.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(724,8081,334,40918,178694,2,218,2,2200.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL);
INSERT INTO `balance_libro_details` VALUES (725,8081,334,40918,178694,2,13,1,2200.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(726,8081,335,40918,178694,2,218,2,6300.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(727,8081,335,40918,178694,2,13,1,6300.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(728,8081,336,40918,178694,2,218,2,4000.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(729,8081,336,40918,178694,2,13,1,4000.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(730,8081,337,40918,178694,2,218,2,3300.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(731,8081,337,40918,178694,2,13,1,3300.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(732,8081,338,40918,178694,2,218,2,2200.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(733,8081,338,40918,178694,2,13,1,2200.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(734,8081,339,40918,178694,2,218,2,2200.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(735,8081,339,40918,178694,2,13,1,2200.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(736,8081,340,40918,178694,2,218,2,2200.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(737,8081,340,40918,178694,2,13,1,2200.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(738,8081,341,40918,178694,2,218,2,1900.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(739,8081,341,40918,178694,2,13,1,1900.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(740,8081,342,40918,178694,2,218,2,2200.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(741,8081,342,40918,178694,2,13,1,2200.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(742,8081,343,40918,178694,2,218,2,4000.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(743,8081,343,40918,178694,2,13,1,4000.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(744,8081,344,40918,178694,2,218,2,2000.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(745,8081,344,40918,178694,2,13,1,2000.00,NULL,'2022-11-30 00:05:37','2022-11-30 00:05:37',NULL),(746,8081,345,40918,178694,2,218,2,3000.00,NULL,'2022-11-30 00:05:38','2022-11-30 00:05:38',NULL),(747,8081,345,40918,178694,2,13,1,3000.00,NULL,'2022-11-30 00:05:38','2022-11-30 00:05:38',NULL),(748,8081,346,40918,178694,2,218,2,4000.00,NULL,'2022-11-30 00:05:38','2022-11-30 00:05:38',NULL),(749,8081,346,40918,178694,2,13,1,4000.00,NULL,'2022-11-30 00:05:38','2022-11-30 00:05:38',NULL),(750,8081,347,40918,178694,2,218,2,4400.00,NULL,'2022-11-30 00:05:38','2022-11-30 00:05:38',NULL),(751,8081,347,40918,178694,2,13,1,4400.00,NULL,'2022-11-30 00:05:38','2022-11-30 00:05:38',NULL),(752,8081,348,40918,178694,2,218,2,4400.00,NULL,'2022-11-30 00:05:38','2022-11-30 00:05:38',NULL),(753,8081,348,40918,178694,2,13,1,4400.00,NULL,'2022-11-30 00:05:38','2022-11-30 00:05:38',NULL),(754,8081,349,40918,178694,2,218,2,8000.00,NULL,'2022-11-30 00:05:38','2022-11-30 00:05:38',NULL),(755,8081,349,40918,178694,2,13,1,8000.00,NULL,'2022-11-30 00:05:38','2022-11-30 00:05:38',NULL),(756,8081,350,40918,178696,2,218,2,2500.00,NULL,'2022-11-30 00:06:27','2022-11-30 00:06:27',NULL),(757,8081,350,40918,178696,2,13,1,2500.00,NULL,'2022-11-30 00:06:27','2022-11-30 00:06:27',NULL),(758,8081,351,40918,178696,2,218,2,4400.00,NULL,'2022-11-30 00:06:27','2022-11-30 00:06:27',NULL),(759,8081,351,40918,178696,2,13,1,4400.00,NULL,'2022-11-30 00:06:27','2022-11-30 00:06:27',NULL),(760,8081,352,40918,178696,2,218,2,10000.00,NULL,'2022-11-30 00:06:27','2022-11-30 00:06:27',NULL),(761,8081,352,40918,178696,2,13,1,10000.00,NULL,'2022-11-30 00:06:27','2022-11-30 00:06:27',NULL),(762,8081,353,40918,178696,2,218,2,3200.00,NULL,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(763,8081,353,40918,178696,2,13,1,3200.00,NULL,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(764,8081,354,40918,178696,2,218,2,2500.00,NULL,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(765,8081,354,40918,178696,2,13,1,2500.00,NULL,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL);
INSERT INTO `balance_libro_details` VALUES (766,8081,355,40918,178696,2,218,2,2500.00,NULL,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(767,8081,355,40918,178696,2,13,1,2500.00,NULL,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(768,8081,356,40918,178696,2,218,2,2500.00,NULL,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(769,8081,356,40918,178696,2,13,1,2500.00,NULL,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(770,8081,357,40918,178696,2,218,2,2500.00,NULL,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(771,8081,357,40918,178696,2,13,1,2500.00,NULL,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(772,8081,358,40918,178696,2,218,2,12100.00,NULL,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(773,8081,358,40918,178696,2,13,1,12100.00,NULL,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(774,8081,359,40918,178696,2,218,2,9000.00,NULL,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(775,8081,359,40918,178696,2,13,1,9000.00,NULL,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(776,8081,360,40918,178696,2,218,2,12800.00,NULL,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(777,8081,360,40918,178696,2,13,1,12800.00,NULL,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(778,8081,361,40918,178696,2,218,2,8100.00,NULL,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(779,8081,361,40918,178696,2,13,1,8100.00,NULL,'2022-11-30 00:06:28','2022-11-30 00:06:28',NULL),(780,8081,362,40918,178697,2,218,2,2500.00,NULL,'2022-11-30 00:06:49','2022-11-30 00:06:49',NULL),(781,8081,362,40918,178697,2,13,1,2500.00,NULL,'2022-11-30 00:06:49','2022-11-30 00:06:49',NULL),(782,8081,363,40918,178697,2,218,2,7200.00,NULL,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(783,8081,363,40918,178697,2,13,1,7200.00,NULL,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(784,8081,364,40918,178697,2,218,2,8400.00,NULL,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(785,8081,364,40918,178697,2,13,1,8400.00,NULL,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(786,8081,365,40918,178697,2,218,2,12600.00,NULL,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(787,8081,365,40918,178697,2,13,1,12600.00,NULL,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(788,8081,366,40918,178697,2,218,2,12500.00,NULL,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(789,8081,366,40918,178697,2,13,1,12500.00,NULL,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(790,8081,367,40918,178697,2,218,2,2500.00,NULL,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(791,8081,367,40918,178697,2,13,1,2500.00,NULL,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(792,8081,368,40918,178697,2,218,2,2500.00,NULL,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(793,8081,368,40918,178697,2,13,1,2500.00,NULL,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(794,8081,369,40918,178697,2,218,2,2500.00,NULL,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(795,8081,369,40918,178697,2,13,1,2500.00,NULL,'2022-11-30 00:06:50','2022-11-30 00:06:50',NULL),(796,8081,370,40918,178695,2,218,2,9500.00,NULL,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(797,8081,370,40918,178695,2,13,1,9500.00,NULL,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(798,8081,371,40918,178695,2,218,2,4000.00,NULL,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(799,8081,371,40918,178695,2,13,1,4000.00,NULL,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(800,8081,372,40918,178695,2,218,2,1100.00,NULL,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(801,8081,372,40918,178695,2,13,1,1100.00,NULL,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(802,8081,373,40918,178695,2,218,2,2200.00,NULL,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(803,8081,373,40918,178695,2,13,1,2200.00,NULL,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(804,8081,374,40918,178695,2,218,2,2200.00,NULL,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(805,8081,374,40918,178695,2,13,1,2200.00,NULL,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(806,8081,375,40918,178695,2,218,2,2200.00,NULL,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL);
INSERT INTO `balance_libro_details` VALUES (807,8081,375,40918,178695,2,13,1,2200.00,NULL,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(808,8081,376,40918,178695,2,218,2,2200.00,NULL,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(809,8081,376,40918,178695,2,13,1,2200.00,NULL,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(810,8081,377,40918,178695,2,218,2,4000.00,NULL,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(811,8081,377,40918,178695,2,13,1,4000.00,NULL,'2022-11-30 00:07:48','2022-11-30 00:07:48',NULL),(812,8081,378,40918,178695,2,218,2,2200.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(813,8081,378,40918,178695,2,13,1,2200.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(814,8081,379,40918,178695,2,218,2,2200.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(815,8081,379,40918,178695,2,13,1,2200.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(816,8081,380,40918,178695,2,218,2,2200.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(817,8081,380,40918,178695,2,13,1,2200.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(818,8081,381,40918,178695,2,218,2,2200.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(819,8081,381,40918,178695,2,13,1,2200.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(820,8081,382,40918,178695,2,218,2,2200.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(821,8081,382,40918,178695,2,13,1,2200.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(822,8081,383,40918,178695,2,218,2,5000.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(823,8081,383,40918,178695,2,13,1,5000.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(824,8081,384,40918,178695,2,218,2,12000.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(825,8081,384,40918,178695,2,13,1,12000.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(826,8081,385,40918,178695,2,218,2,6300.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(827,8081,385,40918,178695,2,13,1,6300.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(828,8081,386,40918,178695,2,218,2,4000.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(829,8081,386,40918,178695,2,13,1,4000.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(830,8081,387,40918,178695,2,218,2,6000.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(831,8081,387,40918,178695,2,13,1,6000.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(832,8081,388,40918,178695,2,218,2,4000.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(833,8081,388,40918,178695,2,13,1,4000.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(834,8081,389,40918,178695,2,218,2,3000.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(835,8081,389,40918,178695,2,13,1,3000.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(836,8081,390,40918,178695,2,218,2,2200.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(837,8081,390,40918,178695,2,13,1,2200.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(838,8081,391,40918,178695,2,218,2,2200.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(839,8081,391,40918,178695,2,13,1,2200.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(840,8081,392,40918,178695,2,218,2,4400.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(841,8081,392,40918,178695,2,13,1,4400.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(842,8081,393,40918,178695,2,218,2,4000.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(843,8081,393,40918,178695,2,13,1,4000.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(844,8081,394,40918,178695,2,218,2,2200.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(845,8081,394,40918,178695,2,13,1,2200.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(846,8081,395,40918,178695,2,218,2,3000.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(847,8081,395,40918,178695,2,13,1,3000.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL);
INSERT INTO `balance_libro_details` VALUES (848,8081,396,40918,178695,2,218,2,4000.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(849,8081,396,40918,178695,2,13,1,4000.00,NULL,'2022-11-30 00:07:49','2022-11-30 00:07:49',NULL),(850,8081,397,40918,178693,3,217,1,7737.97,NULL,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(851,8081,397,40918,178693,3,68,1,847.03,NULL,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(852,8081,397,40918,178693,3,57,2,8585.00,NULL,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(853,8081,398,40918,178693,3,217,1,2065.13,NULL,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(854,8081,398,40918,178693,3,68,1,433.68,NULL,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(855,8081,398,40918,178693,3,57,2,2498.81,NULL,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(856,8081,399,40918,178693,3,217,1,19008.26,NULL,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(857,8081,399,40918,178693,3,68,1,3991.74,NULL,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(858,8081,399,40918,178693,3,57,2,23000.00,NULL,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(859,8081,400,40918,178693,3,217,1,13906.70,NULL,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(860,8081,400,40918,178693,3,68,1,2920.41,NULL,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(861,8081,400,40918,178693,3,57,2,16827.11,NULL,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(862,8081,401,40918,178693,3,217,1,4390.91,NULL,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(863,8081,401,40918,178693,3,68,1,922.09,NULL,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(864,8081,401,40918,178693,3,57,2,5313.00,NULL,'2022-11-30 00:26:29','2022-11-30 00:26:29',NULL),(865,8081,402,40918,178694,3,217,1,9895.40,NULL,'2022-11-30 00:26:51','2022-11-30 00:26:51',NULL),(866,8081,402,40918,178694,3,68,1,1091.60,NULL,'2022-11-30 00:26:51','2022-11-30 00:26:51',NULL),(867,8081,402,40918,178694,3,57,2,10987.00,NULL,'2022-11-30 00:26:51','2022-11-30 00:26:51',NULL),(868,8081,403,40918,178694,3,250,1,0.00,NULL,'2022-11-30 00:26:51','2022-11-30 00:26:51',NULL),(869,8081,403,40918,178694,3,250,1,11999.00,NULL,'2022-11-30 00:26:51','2022-11-30 00:26:51',NULL),(870,8081,403,40918,178694,3,57,2,11999.00,NULL,'2022-11-30 00:26:51','2022-11-30 00:26:51',NULL),(871,8081,404,40918,178694,3,217,1,1130.58,NULL,'2022-11-30 00:26:51','2022-11-30 00:26:51',NULL),(872,8081,404,40918,178694,3,68,1,237.42,NULL,'2022-11-30 00:26:51','2022-11-30 00:26:51',NULL),(873,8081,404,40918,178694,3,57,2,1368.00,NULL,'2022-11-30 00:26:51','2022-11-30 00:26:51',NULL),(874,8081,405,40918,178694,3,217,1,23636.36,NULL,'2022-11-30 00:26:51','2022-11-30 00:26:51',NULL),(875,8081,405,40918,178694,3,68,1,4963.64,NULL,'2022-11-30 00:26:51','2022-11-30 00:26:51',NULL),(876,8081,405,40918,178694,3,57,2,28600.00,NULL,'2022-11-30 00:26:51','2022-11-30 00:26:51',NULL),(877,8081,406,40918,178695,3,217,1,9373.69,NULL,'2022-11-30 00:27:17','2022-11-30 00:27:17',NULL),(878,8081,406,40918,178695,3,68,1,1007.31,NULL,'2022-11-30 00:27:17','2022-11-30 00:27:17',NULL),(879,8081,406,40918,178695,3,57,2,10381.00,NULL,'2022-11-30 00:27:17','2022-11-30 00:27:17',NULL),(880,8081,407,40918,178695,3,217,1,1776.86,NULL,'2022-11-30 00:27:17','2022-11-30 00:27:17',NULL),(881,8081,407,40918,178695,3,68,1,373.14,NULL,'2022-11-30 00:27:17','2022-11-30 00:27:17',NULL),(882,8081,407,40918,178695,3,57,2,2150.00,NULL,'2022-11-30 00:27:17','2022-11-30 00:27:17',NULL),(883,8081,408,40918,178695,3,217,1,4642.49,NULL,'2022-11-30 00:27:17','2022-11-30 00:27:17',NULL),(884,8081,408,40918,178695,3,68,1,974.92,NULL,'2022-11-30 00:27:17','2022-11-30 00:27:17',NULL),(885,8081,408,40918,178695,3,57,2,5617.41,NULL,'2022-11-30 00:27:17','2022-11-30 00:27:17',NULL),(886,8081,409,40918,178696,3,217,1,10619.14,NULL,'2022-11-30 00:27:55','2022-11-30 00:27:55',NULL),(887,8081,409,40918,178696,3,68,1,1159.86,NULL,'2022-11-30 00:27:55','2022-11-30 00:27:55',NULL),(888,8081,409,40918,178696,3,57,2,11779.00,NULL,'2022-11-30 00:27:55','2022-11-30 00:27:55',NULL);
INSERT INTO `balance_libro_details` VALUES (889,8081,410,40918,178696,3,217,1,2900.83,NULL,'2022-11-30 00:27:55','2022-11-30 00:27:55',NULL),(890,8081,410,40918,178696,3,68,1,609.17,NULL,'2022-11-30 00:27:55','2022-11-30 00:27:55',NULL),(891,8081,410,40918,178696,3,57,2,3510.00,NULL,'2022-11-30 00:27:55','2022-11-30 00:27:55',NULL),(892,8081,411,40918,178696,3,217,1,4000.00,NULL,'2022-11-30 00:27:55','2022-11-30 00:27:55',NULL),(893,8081,411,40918,178696,3,68,1,840.00,NULL,'2022-11-30 00:27:55','2022-11-30 00:27:55',NULL),(894,8081,411,40918,178696,3,57,2,4840.00,NULL,'2022-11-30 00:27:55','2022-11-30 00:27:55',NULL),(895,8081,412,40918,178696,3,217,1,2722.56,NULL,'2022-11-30 00:27:55','2022-11-30 00:27:55',NULL),(896,8081,412,40918,178696,3,68,1,571.74,NULL,'2022-11-30 00:27:55','2022-11-30 00:27:55',NULL),(897,8081,412,40918,178696,3,57,2,3294.30,NULL,'2022-11-30 00:27:55','2022-11-30 00:27:55',NULL),(898,8081,413,40918,178697,3,250,1,0.00,NULL,'2022-11-30 00:30:11','2022-11-30 00:30:11',NULL),(899,8081,413,40918,178697,3,250,1,10192.00,NULL,'2022-11-30 00:30:11','2022-11-30 00:30:11',NULL),(900,8081,413,40918,178697,3,57,2,10192.00,NULL,'2022-11-30 00:30:11','2022-11-30 00:30:11',NULL),(901,8081,414,40918,178697,3,217,1,60330.58,NULL,'2022-11-30 00:30:11','2022-11-30 00:30:11',NULL),(902,8081,414,40918,178697,3,68,1,12669.42,NULL,'2022-11-30 00:30:11','2022-11-30 00:30:11',NULL),(903,8081,414,40918,178697,3,57,2,73000.00,NULL,'2022-11-30 00:30:11','2022-11-30 00:30:11',NULL),(904,8081,415,40918,178697,3,217,1,21900.83,NULL,'2022-11-30 00:30:11','2022-11-30 00:30:11',NULL),(905,8081,415,40918,178697,3,68,1,4599.17,NULL,'2022-11-30 00:30:11','2022-11-30 00:30:11',NULL),(906,8081,415,40918,178697,3,57,2,26500.00,NULL,'2022-11-30 00:30:11','2022-11-30 00:30:11',NULL),(907,8081,416,40866,99909,3,250,1,1157.00,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(908,8081,416,40866,99909,3,57,2,1157.00,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(909,8081,417,40866,99909,3,217,1,174.24,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(910,8081,417,40866,99909,3,68,1,36.59,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(911,8081,417,40866,99909,3,217,1,9.17,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(912,8081,417,40866,99909,3,57,2,220.00,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(913,8081,418,40866,99909,3,217,1,3082.74,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(914,8081,418,40866,99909,3,68,1,647.38,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(915,8081,418,40866,99909,3,217,1,463.98,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(916,8081,418,40866,99909,3,57,2,4194.10,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(917,8081,419,40866,99909,3,250,1,585.00,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(918,8081,419,40866,99909,3,57,2,585.00,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(919,8081,420,40866,99909,3,217,1,18231.38,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(920,8081,420,40866,99909,3,68,1,3828.59,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(921,8081,420,40866,99909,3,217,1,1523.21,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(922,8081,420,40866,99909,3,57,2,23583.18,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(923,8081,421,40866,99909,3,217,1,5804.36,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(924,8081,421,40866,99909,3,68,1,1218.92,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(925,8081,421,40866,99909,3,217,1,1106.99,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(926,8081,421,40866,99909,3,57,2,8130.27,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(927,8081,422,40866,99909,3,217,1,633.60,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(928,8081,422,40866,99909,3,68,1,133.06,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(929,8081,422,40866,99909,3,217,1,33.34,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL);
INSERT INTO `balance_libro_details` VALUES (930,8081,422,40866,99909,3,57,2,800.00,NULL,'2022-11-30 00:53:39','2022-11-30 00:53:39',NULL),(931,8081,423,40866,99910,3,217,1,86998.35,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(932,8081,423,40866,99910,3,68,1,18269.65,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(933,8081,423,40866,99910,3,57,2,105268.00,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(934,8081,424,40866,99910,3,217,1,14789.87,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(935,8081,424,40866,99910,3,68,1,3105.87,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(936,8081,424,40866,99910,3,217,1,2558.41,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(937,8081,424,40866,99910,3,57,2,20454.15,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(938,8081,425,40866,99910,3,217,1,6989.16,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(939,8081,425,40866,99910,3,68,1,1467.72,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(940,8081,425,40866,99910,3,217,1,1143.12,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(941,8081,425,40866,99910,3,57,2,9600.00,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(942,8081,426,40866,99910,3,217,1,19500.14,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(943,8081,426,40866,99910,3,68,1,4095.03,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(944,8081,426,40866,99910,3,217,1,1629.82,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(945,8081,426,40866,99910,3,57,2,25224.99,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(946,8081,427,40866,99910,3,217,1,9166.39,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(947,8081,427,40866,99910,3,68,1,1924.94,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(948,8081,427,40866,99910,3,217,1,1666.73,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(949,8081,427,40866,99910,3,57,2,12758.06,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(950,8081,428,40866,99910,3,250,1,1040.00,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(951,8081,428,40866,99910,3,57,2,1040.00,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(952,8081,429,40866,99910,3,217,1,7589.30,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(953,8081,429,40866,99910,3,68,1,1593.75,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(954,8081,429,40866,99910,3,217,1,1429.57,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(955,8081,429,40866,99910,3,57,2,10612.62,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(956,8081,430,40866,99910,3,217,1,6607.78,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(957,8081,430,40866,99910,3,68,1,1387.63,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(958,8081,430,40866,99910,3,217,1,1260.21,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(959,8081,430,40866,99910,3,57,2,9255.62,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(960,8081,431,40866,99910,3,217,1,5884.79,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(961,8081,431,40866,99910,3,68,1,1235.81,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(962,8081,431,40866,99910,3,217,1,1084.73,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(963,8081,431,40866,99910,3,57,2,8205.33,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(964,8081,432,40866,99910,3,217,1,633.60,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(965,8081,432,40866,99910,3,68,1,133.06,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(966,8081,432,40866,99910,3,217,1,33.34,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(967,8081,432,40866,99910,3,57,2,800.00,NULL,'2022-11-30 00:59:32','2022-11-30 00:59:32',NULL),(968,8081,433,40866,99911,3,217,1,7567.72,NULL,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(969,8081,433,40866,99911,3,68,1,1589.22,NULL,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(970,8081,433,40866,99911,3,217,1,1443.29,NULL,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL);
INSERT INTO `balance_libro_details` VALUES (971,8081,433,40866,99911,3,57,2,10600.23,NULL,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(972,8081,434,40866,99911,3,217,1,663.00,NULL,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(973,8081,434,40866,99911,3,57,2,663.00,NULL,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(974,8081,435,40866,99911,3,217,1,7608.17,NULL,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(975,8081,435,40866,99911,3,68,1,1597.72,NULL,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(976,8081,435,40866,99911,3,217,1,1377.07,NULL,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(977,8081,435,40866,99911,3,57,2,10582.96,NULL,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(978,8081,436,40866,99911,3,217,1,633.60,NULL,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(979,8081,436,40866,99911,3,68,1,133.06,NULL,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(980,8081,436,40866,99911,3,217,1,33.34,NULL,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(981,8081,436,40866,99911,3,57,2,800.00,NULL,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(982,8081,437,40866,99911,3,217,1,9002.83,NULL,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(983,8081,437,40866,99911,3,68,1,1890.59,NULL,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(984,8081,437,40866,99911,3,217,1,1578.47,NULL,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(985,8081,437,40866,99911,3,57,2,12471.89,NULL,'2022-11-30 01:04:06','2022-11-30 01:04:06',NULL),(986,8081,438,40866,99912,3,217,1,18118.24,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(987,8081,438,40866,99912,3,68,1,3804.83,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(988,8081,438,40866,99912,3,217,1,1490.33,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(989,8081,438,40866,99912,3,57,2,23413.40,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(990,8081,439,40866,99912,3,217,1,16765.45,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(991,8081,439,40866,99912,3,68,1,3520.74,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(992,8081,439,40866,99912,3,217,1,2929.31,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(993,8081,439,40866,99912,3,57,2,23215.50,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(994,8081,440,40866,99912,3,217,1,6502.69,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(995,8081,440,40866,99912,3,68,1,1365.56,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(996,8081,440,40866,99912,3,217,1,1197.30,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(997,8081,440,40866,99912,3,57,2,9065.55,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(998,8081,441,40866,99912,3,217,1,3034.70,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(999,8081,441,40866,99912,3,68,1,637.29,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(1000,8081,441,40866,99912,3,57,2,3671.99,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(1001,8081,442,40866,99912,3,217,1,24332.48,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(1002,8081,442,40866,99912,3,68,1,5109.82,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(1003,8081,442,40866,99912,3,217,1,1946.60,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(1004,8081,442,40866,99912,3,57,2,31388.90,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(1005,8081,443,40866,99912,3,217,1,13068.77,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(1006,8081,443,40866,99912,3,68,1,2744.44,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(1007,8081,443,40866,99912,3,217,1,2368.64,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(1008,8081,443,40866,99912,3,57,2,18181.85,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(1009,8081,444,40866,99912,3,217,1,633.60,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(1010,8081,444,40866,99912,3,68,1,133.06,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(1011,8081,444,40866,99912,3,217,1,33.34,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL);
INSERT INTO `balance_libro_details` VALUES (1012,8081,444,40866,99912,3,57,2,800.00,NULL,'2022-11-30 01:04:27','2022-11-30 01:04:27',NULL),(1013,8081,445,40866,99913,3,217,1,8702.82,NULL,'2022-11-30 01:04:45','2022-11-30 01:04:45',NULL),(1014,8081,445,40866,99913,3,68,1,1827.59,NULL,'2022-11-30 01:04:45','2022-11-30 01:04:45',NULL),(1015,8081,445,40866,99913,3,217,1,1555.88,NULL,'2022-11-30 01:04:45','2022-11-30 01:04:45',NULL),(1016,8081,445,40866,99913,3,57,2,12086.29,NULL,'2022-11-30 01:04:45','2022-11-30 01:04:45',NULL),(1017,8081,446,40866,99913,3,217,1,4960.86,NULL,'2022-11-30 01:04:45','2022-11-30 01:04:45',NULL),(1018,8081,446,40866,99913,3,68,1,1041.78,NULL,'2022-11-30 01:04:45','2022-11-30 01:04:45',NULL),(1019,8081,446,40866,99913,3,217,1,946.12,NULL,'2022-11-30 01:04:45','2022-11-30 01:04:45',NULL),(1020,8081,446,40866,99913,3,57,2,6948.76,NULL,'2022-11-30 01:04:45','2022-11-30 01:04:45',NULL),(1021,8081,447,40866,99913,3,217,1,9770.75,NULL,'2022-11-30 01:04:45','2022-11-30 01:04:45',NULL),(1022,8081,447,40866,99913,3,68,1,2051.86,NULL,'2022-11-30 01:04:45','2022-11-30 01:04:45',NULL),(1023,8081,447,40866,99913,3,217,1,1815.68,NULL,'2022-11-30 01:04:45','2022-11-30 01:04:45',NULL),(1024,8081,447,40866,99913,3,57,2,13638.29,NULL,'2022-11-30 01:04:45','2022-11-30 01:04:45',NULL),(1025,8081,448,40866,99913,3,250,1,559.00,NULL,'2022-11-30 01:04:45','2022-11-30 01:04:45',NULL),(1026,8081,448,40866,99913,3,57,2,559.00,NULL,'2022-11-30 01:04:45','2022-11-30 01:04:45',NULL),(1027,8081,449,40866,99913,3,217,1,784.08,NULL,'2022-11-30 01:04:46','2022-11-30 01:04:46',NULL),(1028,8081,449,40866,99913,3,68,1,164.66,NULL,'2022-11-30 01:04:46','2022-11-30 01:04:46',NULL),(1029,8081,449,40866,99913,3,217,1,41.26,NULL,'2022-11-30 01:04:46','2022-11-30 01:04:46',NULL),(1030,8081,449,40866,99913,3,57,2,990.00,NULL,'2022-11-30 01:04:46','2022-11-30 01:04:46',NULL),(1031,8081,450,40866,99914,3,217,1,5134.28,NULL,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(1032,8081,450,40866,99914,3,68,1,1078.20,NULL,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(1033,8081,450,40866,99914,3,217,1,897.19,NULL,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(1034,8081,450,40866,99914,3,57,2,7109.67,NULL,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(1035,8081,451,40866,99914,3,217,1,5454.53,NULL,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(1036,8081,451,40866,99914,3,68,1,1145.45,NULL,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(1037,8081,451,40866,99914,3,57,2,6599.98,NULL,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(1038,8081,452,40866,99914,3,217,1,11560.55,NULL,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(1039,8081,452,40866,99914,3,68,1,2427.72,NULL,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(1040,8081,452,40866,99914,3,217,1,1813.20,NULL,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(1041,8081,452,40866,99914,3,57,2,15801.47,NULL,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(1042,8081,453,40866,99914,3,217,1,10307.51,NULL,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(1043,8081,453,40866,99914,3,68,1,2164.58,NULL,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(1044,8081,453,40866,99914,3,217,1,662.75,NULL,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(1045,8081,453,40866,99914,3,57,2,13134.84,NULL,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(1046,8081,454,40866,99914,3,217,1,59489.26,NULL,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(1047,8081,454,40866,99914,3,68,1,12492.74,NULL,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(1048,8081,454,40866,99914,3,57,2,71982.00,NULL,'2022-11-30 01:05:07','2022-11-30 01:05:07',NULL),(1049,8081,455,40866,99914,3,217,1,7932.41,NULL,'2022-11-30 01:05:08','2022-11-30 01:05:08',NULL),(1050,8081,455,40866,99914,3,68,1,1665.81,NULL,'2022-11-30 01:05:08','2022-11-30 01:05:08',NULL),(1051,8081,455,40866,99914,3,217,1,475.93,NULL,'2022-11-30 01:05:08','2022-11-30 01:05:08',NULL),(1052,8081,455,40866,99914,3,57,2,10074.15,NULL,'2022-11-30 01:05:08','2022-11-30 01:05:08',NULL);
INSERT INTO `balance_libro_details` VALUES (1053,8081,456,40866,99914,3,217,1,13562.63,NULL,'2022-11-30 01:05:08','2022-11-30 01:05:08',NULL),(1054,8081,456,40866,99914,3,68,1,2848.15,NULL,'2022-11-30 01:05:08','2022-11-30 01:05:08',NULL),(1055,8081,456,40866,99914,3,217,1,2071.34,NULL,'2022-11-30 01:05:08','2022-11-30 01:05:08',NULL),(1056,8081,456,40866,99914,3,57,2,18482.12,NULL,'2022-11-30 01:05:08','2022-11-30 01:05:08',NULL),(1057,8081,457,40866,99914,3,217,1,10106.87,NULL,'2022-11-30 01:05:08','2022-11-30 01:05:08',NULL),(1058,8081,457,40866,99914,3,68,1,2122.44,NULL,'2022-11-30 01:05:08','2022-11-30 01:05:08',NULL),(1059,8081,457,40866,99914,3,217,1,1486.00,NULL,'2022-11-30 01:05:08','2022-11-30 01:05:08',NULL),(1060,8081,457,40866,99914,3,57,2,13715.31,NULL,'2022-11-30 01:05:08','2022-11-30 01:05:08',NULL),(1061,8081,458,40866,99914,3,250,1,395.00,NULL,'2022-11-30 01:05:08','2022-11-30 01:05:08',NULL),(1062,8081,458,40866,99914,3,57,2,395.00,NULL,'2022-11-30 01:05:08','2022-11-30 01:05:08',NULL),(1063,8081,459,40866,99915,3,217,1,10405.22,NULL,'2022-11-30 01:05:39','2022-11-30 01:05:39',NULL),(1064,8081,459,40866,99915,3,68,1,2185.10,NULL,'2022-11-30 01:05:39','2022-11-30 01:05:39',NULL),(1065,8081,459,40866,99915,3,217,1,811.67,NULL,'2022-11-30 01:05:39','2022-11-30 01:05:39',NULL),(1066,8081,459,40866,99915,3,57,2,13401.99,NULL,'2022-11-30 01:05:39','2022-11-30 01:05:39',NULL),(1067,8081,460,40866,99915,3,217,1,619.84,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1068,8081,460,40866,99915,3,68,1,130.17,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1069,8081,460,40866,99915,3,57,2,750.01,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1070,8081,461,40866,99915,3,217,1,24438.86,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1071,8081,461,40866,99915,3,68,1,5132.16,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1072,8081,461,40866,99915,3,217,1,87.19,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1073,8081,461,40866,99915,3,57,2,29658.21,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1074,8081,462,40866,99915,3,217,1,48683.51,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1075,8081,462,40866,99915,3,68,1,10223.54,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1076,8081,462,40866,99915,3,57,2,58907.05,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1077,8081,463,40866,99915,3,217,1,5288.10,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1078,8081,463,40866,99915,3,68,1,1110.50,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1079,8081,463,40866,99915,3,57,2,6398.60,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1080,8081,464,40866,99915,3,250,1,1020.00,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1081,8081,464,40866,99915,3,57,2,1020.00,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1082,8081,465,40866,99915,3,217,1,31364.77,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1083,8081,465,40866,99915,3,68,1,6586.60,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1084,8081,465,40866,99915,3,217,1,983.46,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1085,8081,465,40866,99915,3,57,2,38934.83,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1086,8081,466,40866,99915,3,217,1,9993.44,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1087,8081,466,40866,99915,3,68,1,2098.62,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1088,8081,466,40866,99915,3,217,1,777.94,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1089,8081,466,40866,99915,3,57,2,12870.00,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1090,8081,467,40866,99915,3,250,1,740.00,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1091,8081,467,40866,99915,3,57,2,740.00,NULL,'2022-11-30 01:05:40','2022-11-30 01:05:40',NULL),(1092,8081,468,40866,99916,3,217,1,7182.96,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1093,8081,468,40866,99916,3,68,1,1508.42,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL);
INSERT INTO `balance_libro_details` VALUES (1094,8081,468,40866,99916,3,217,1,624.61,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1095,8081,468,40866,99916,3,57,2,9315.99,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1096,8081,469,40866,99916,3,217,1,1485.04,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1097,8081,469,40866,99916,3,68,1,311.86,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1098,8081,469,40866,99916,3,57,2,1796.89,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1099,8081,469,40866,99916,3,136,2,0.01,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1100,8081,470,40866,99916,3,217,1,22198.04,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1101,8081,470,40866,99916,3,68,1,4558.01,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1102,8081,470,40866,99916,3,217,1,0.01,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1103,8081,470,40866,99916,3,57,2,26756.06,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1104,8081,471,40866,99916,3,217,1,17894.52,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1105,8081,471,40866,99916,3,68,1,3757.85,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1106,8081,471,40866,99916,3,217,1,89.00,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1107,8081,471,40866,99916,3,57,2,21741.37,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1108,8081,472,40866,99916,3,217,1,4455.11,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1109,8081,472,40866,99916,3,68,1,935.57,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1110,8081,472,40866,99916,3,57,2,5390.68,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1111,8081,473,40866,99916,3,250,1,1480.00,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1112,8081,473,40866,99916,3,57,2,1480.00,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1113,8081,474,40866,99916,3,217,1,12772.08,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1114,8081,474,40866,99916,3,68,1,2682.14,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1115,8081,474,40866,99916,3,217,1,962.26,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1116,8081,474,40866,99916,3,57,2,16416.48,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1117,8081,475,40866,99916,3,217,1,4957.85,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1118,8081,475,40866,99916,3,68,1,1041.15,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1119,8081,475,40866,99916,3,57,2,5999.00,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1120,8081,476,40866,99916,3,217,1,29660.42,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1121,8081,476,40866,99916,3,68,1,6228.69,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1122,8081,476,40866,99916,3,57,2,35889.11,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1123,8081,477,40866,99916,3,217,1,7023.21,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1124,8081,477,40866,99916,3,68,1,1474.87,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1125,8081,477,40866,99916,3,217,1,540.91,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1126,8081,477,40866,99916,3,57,2,9038.99,NULL,'2022-11-30 01:06:02','2022-11-30 01:06:02',NULL),(1127,8081,478,40866,99917,3,217,1,5484.99,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1128,8081,478,40866,99917,3,68,1,1151.85,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1129,8081,478,40866,99917,3,217,1,406.66,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1130,8081,478,40866,99917,3,57,2,7043.50,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1131,8081,479,40866,99917,3,217,1,425.75,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1132,8081,479,40866,99917,3,68,1,89.41,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1133,8081,479,40866,99917,3,57,2,515.16,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1134,8081,480,40866,99917,3,250,1,716.00,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL);
INSERT INTO `balance_libro_details` VALUES (1135,8081,480,40866,99917,3,57,2,716.00,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1136,8081,481,40866,99917,3,217,1,7229.76,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1137,8081,481,40866,99917,3,68,1,1518.25,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1138,8081,481,40866,99917,3,57,2,8748.01,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1139,8081,482,40866,99917,3,217,1,17871.88,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1140,8081,482,40866,99917,3,68,1,3753.09,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1141,8081,482,40866,99917,3,217,1,17.76,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1142,8081,482,40866,99917,3,57,2,21642.73,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1143,8081,483,40866,99917,3,217,1,17812.85,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1144,8081,483,40866,99917,3,68,1,3740.70,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1145,8081,483,40866,99917,3,217,1,130.80,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1146,8081,483,40866,99917,3,57,2,21684.35,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1147,8081,484,40866,99917,3,217,1,19155.57,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1148,8081,484,40866,99917,3,68,1,4022.67,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1149,8081,484,40866,99917,3,217,1,1549.80,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1150,8081,484,40866,99917,3,57,2,24728.04,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1151,8081,485,40866,99917,3,217,1,8063.51,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1152,8081,485,40866,99917,3,68,1,1693.34,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1153,8081,485,40866,99917,3,217,1,701.17,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1154,8081,485,40866,99917,3,57,2,10458.02,NULL,'2022-11-30 01:06:17','2022-11-30 01:06:17',NULL),(1157,8081,487,40771,48403,2,218,2,1000.00,NULL,'2022-11-30 20:33:09','2022-11-30 20:33:09',NULL),(1158,8081,487,40771,48403,2,13,1,1000.00,NULL,'2022-11-30 20:33:09','2022-11-30 20:33:09',NULL),(1159,8081,488,40771,48403,2,218,2,1300.00,NULL,'2022-11-30 20:33:09','2022-11-30 20:33:09',NULL),(1160,8081,488,40771,48403,2,13,1,1300.00,NULL,'2022-11-30 20:33:09','2022-11-30 20:33:09',NULL),(1161,8081,489,40771,48403,2,218,2,1800.00,NULL,'2022-11-30 20:33:09','2022-11-30 20:33:09',NULL),(1162,8081,489,40771,48403,2,13,1,1800.00,NULL,'2022-11-30 20:33:09','2022-11-30 20:33:09',NULL),(1163,8081,490,40771,48403,2,218,2,1000.00,NULL,'2022-11-30 20:33:09','2022-11-30 20:33:09',NULL),(1164,8081,490,40771,48403,2,13,1,1000.00,NULL,'2022-11-30 20:33:09','2022-11-30 20:33:09',NULL),(1165,8081,491,40771,48403,2,218,2,1000.00,NULL,'2022-11-30 20:33:09','2022-11-30 20:33:09',NULL),(1166,8081,491,40771,48403,2,13,1,1000.00,NULL,'2022-11-30 20:33:09','2022-11-30 20:33:09',NULL),(1167,8081,492,40771,48403,2,218,2,1000.00,NULL,'2022-11-30 20:33:09','2022-11-30 20:33:09',NULL),(1168,8081,492,40771,48403,2,13,1,1000.00,NULL,'2022-11-30 20:33:09','2022-11-30 20:33:09',NULL),(1169,8081,493,40771,48402,3,250,1,8300.00,NULL,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(1170,8081,493,40771,48402,3,57,2,8300.00,NULL,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(1171,8081,494,40771,48402,3,217,1,2876.03,NULL,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(1172,8081,494,40771,48402,3,68,1,603.97,NULL,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(1173,8081,494,40771,48402,3,57,2,3480.00,NULL,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(1174,8081,495,40771,48402,3,217,1,860.04,NULL,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(1175,8081,495,40771,48402,3,68,1,180.61,NULL,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(1176,8081,495,40771,48402,3,57,2,1040.65,NULL,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(1177,8081,496,40771,48402,3,250,1,10925.00,NULL,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL);
INSERT INTO `balance_libro_details` VALUES (1178,8081,496,40771,48402,3,57,2,10925.00,NULL,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(1179,8081,497,40771,48402,3,250,1,8725.00,NULL,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(1180,8081,497,40771,48402,3,57,2,8725.00,NULL,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(1181,8081,498,40771,48402,3,217,1,1413.22,NULL,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(1182,8081,498,40771,48402,3,68,1,296.78,NULL,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(1183,8081,498,40771,48402,3,57,2,1710.00,NULL,'2022-11-30 20:42:50','2022-11-30 20:42:50',NULL),(1184,8081,499,40771,48403,3,250,1,3700.00,NULL,'2022-11-30 20:43:34','2022-11-30 20:43:34',NULL),(1185,8081,499,40771,48403,3,57,2,3700.00,NULL,'2022-11-30 20:43:34','2022-11-30 20:43:34',NULL),(1186,8081,500,40771,48403,3,250,1,11250.00,NULL,'2022-11-30 20:43:34','2022-11-30 20:43:34',NULL),(1187,8081,500,40771,48403,3,57,2,11250.00,NULL,'2022-11-30 20:43:34','2022-11-30 20:43:34',NULL),(1188,8081,501,40771,48403,3,217,1,5371.90,NULL,'2022-11-30 20:43:34','2022-11-30 20:43:34',NULL),(1189,8081,501,40771,48403,3,68,1,1128.10,NULL,'2022-11-30 20:43:34','2022-11-30 20:43:34',NULL),(1190,8081,501,40771,48403,3,57,2,6500.00,NULL,'2022-11-30 20:43:34','2022-11-30 20:43:34',NULL),(1191,8081,502,40771,48403,3,250,1,8175.00,NULL,'2022-11-30 20:43:34','2022-11-30 20:43:34',NULL),(1192,8081,502,40771,48403,3,57,2,8175.00,NULL,'2022-11-30 20:43:34','2022-11-30 20:43:34',NULL),(1193,8081,503,40771,48404,3,250,1,4155.00,NULL,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(1194,8081,503,40771,48404,3,57,2,4155.00,NULL,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(1195,8081,504,40771,48404,3,217,1,4297.52,NULL,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(1196,8081,504,40771,48404,3,68,1,902.48,NULL,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(1197,8081,504,40771,48404,3,57,2,5200.00,NULL,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(1198,8081,505,40771,48404,3,217,1,3305.79,NULL,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(1199,8081,505,40771,48404,3,68,1,694.21,NULL,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(1200,8081,505,40771,48404,3,57,2,4000.00,NULL,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(1201,8081,506,40771,48404,3,250,1,10875.00,NULL,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(1202,8081,506,40771,48404,3,57,2,10875.00,NULL,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(1203,8081,507,40771,48404,3,217,1,3223.14,NULL,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(1204,8081,507,40771,48404,3,68,1,676.86,NULL,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(1205,8081,507,40771,48404,3,57,2,3900.00,NULL,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(1206,8081,508,40771,48404,3,250,1,13875.00,NULL,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(1207,8081,508,40771,48404,3,57,2,13875.00,NULL,'2022-11-30 20:44:17','2022-11-30 20:44:17',NULL),(1208,8081,509,40771,48405,3,217,1,3553.72,NULL,'2022-11-30 20:44:42','2022-11-30 20:44:42',NULL),(1209,8081,509,40771,48405,3,68,1,746.28,NULL,'2022-11-30 20:44:42','2022-11-30 20:44:42',NULL),(1210,8081,509,40771,48405,3,57,2,4300.00,NULL,'2022-11-30 20:44:42','2022-11-30 20:44:42',NULL),(1211,8081,510,40771,48405,3,217,1,7438.02,NULL,'2022-11-30 20:44:42','2022-11-30 20:44:42',NULL),(1212,8081,510,40771,48405,3,68,1,1561.98,NULL,'2022-11-30 20:44:42','2022-11-30 20:44:42',NULL),(1213,8081,510,40771,48405,3,57,2,9000.00,NULL,'2022-11-30 20:44:42','2022-11-30 20:44:42',NULL),(1214,8081,511,40771,48405,3,250,1,10475.00,NULL,'2022-11-30 20:44:42','2022-11-30 20:44:42',NULL),(1215,8081,511,40771,48405,3,57,2,10475.00,NULL,'2022-11-30 20:44:42','2022-11-30 20:44:42',NULL),(1216,8081,512,40771,48406,3,250,1,6000.00,NULL,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(1217,8081,512,40771,48406,3,57,2,6000.00,NULL,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(1218,8081,513,40771,48406,3,217,1,371.32,NULL,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL);
INSERT INTO `balance_libro_details` VALUES (1219,8081,513,40771,48406,3,68,1,77.98,NULL,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(1220,8081,513,40771,48406,3,57,2,449.30,NULL,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(1221,8081,514,40771,48406,3,217,1,52891.74,NULL,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(1222,8081,514,40771,48406,3,68,1,11107.27,NULL,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(1223,8081,514,40771,48406,3,57,2,63999.01,NULL,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(1224,8081,515,40771,48406,3,217,1,514.02,NULL,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(1225,8081,515,40771,48406,3,68,1,107.95,NULL,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(1226,8081,515,40771,48406,3,57,2,621.97,NULL,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(1227,8081,516,40771,48406,3,217,1,1980.99,NULL,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(1228,8081,516,40771,48406,3,68,1,416.01,NULL,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(1229,8081,516,40771,48406,3,57,2,2397.00,NULL,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(1230,8081,517,40771,48406,3,250,1,12750.00,NULL,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(1231,8081,517,40771,48406,3,57,2,12750.00,NULL,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(1232,8081,518,40771,48406,3,217,1,4132.23,NULL,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(1233,8081,518,40771,48406,3,68,1,867.77,NULL,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(1234,8081,518,40771,48406,3,57,2,5000.00,NULL,'2022-11-30 20:46:45','2022-11-30 20:46:45',NULL),(1235,8081,519,40771,48407,3,217,1,3800.83,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1236,8081,519,40771,48407,3,68,1,798.17,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1237,8081,519,40771,48407,3,57,2,4599.00,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1238,8081,520,40771,48407,3,217,1,4876.03,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1239,8081,520,40771,48407,3,68,1,1023.97,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1240,8081,520,40771,48407,3,57,2,5900.00,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1241,8081,521,40771,48407,3,217,1,1354.93,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1242,8081,521,40771,48407,3,68,1,284.54,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1243,8081,521,40771,48407,3,57,2,1639.47,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1244,8081,522,40771,48407,3,250,1,0.00,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1245,8081,522,40771,48407,3,250,1,2000.00,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1246,8081,522,40771,48407,3,57,2,2000.00,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1247,8081,523,40771,48407,3,250,1,15270.00,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1248,8081,523,40771,48407,3,57,2,15270.00,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1249,8081,524,40771,48407,3,250,1,5000.00,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1250,8081,524,40771,48407,3,57,2,5000.00,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1251,8081,525,40771,48407,3,217,1,3305.79,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1252,8081,525,40771,48407,3,68,1,694.21,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1253,8081,525,40771,48407,3,57,2,4000.00,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1254,8081,526,40771,48407,3,250,1,3000.00,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1255,8081,526,40771,48407,3,57,2,3000.00,NULL,'2022-11-30 20:47:03','2022-11-30 20:47:03',NULL),(1256,8081,527,40771,48408,3,250,1,17470.00,NULL,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL),(1257,8081,527,40771,48408,3,57,2,17470.00,NULL,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL),(1258,8081,528,40771,48408,3,217,1,12161.71,NULL,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL),(1259,8081,528,40771,48408,3,68,1,2462.50,NULL,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL);
INSERT INTO `balance_libro_details` VALUES (1260,8081,528,40771,48408,3,57,2,14624.21,NULL,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL),(1261,8081,529,40771,48408,3,217,1,5088.09,NULL,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL),(1262,8081,529,40771,48408,3,68,1,1068.50,NULL,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL),(1263,8081,529,40771,48408,3,57,2,6156.59,NULL,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL),(1264,8081,530,40771,48408,3,250,1,3500.00,NULL,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL),(1265,8081,530,40771,48408,3,57,2,3500.00,NULL,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL),(1266,8081,531,40771,48408,3,217,1,12876.44,NULL,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL),(1267,8081,531,40771,48408,3,68,1,2688.44,NULL,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL),(1268,8081,531,40771,48408,3,57,2,15564.88,NULL,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL),(1269,8081,532,40771,48408,3,250,1,1000.00,NULL,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL),(1270,8081,532,40771,48408,3,57,2,1000.00,NULL,'2022-11-30 20:47:26','2022-11-30 20:47:26',NULL),(1271,8081,533,40771,48409,3,250,1,15470.00,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1272,8081,533,40771,48409,3,57,2,15470.00,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1273,8081,534,40771,48409,3,217,1,65.29,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1274,8081,534,40771,48409,3,68,1,13.71,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1275,8081,534,40771,48409,3,57,2,79.00,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1276,8081,535,40771,48409,3,217,1,2892.56,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1277,8081,535,40771,48409,3,68,1,607.44,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1278,8081,535,40771,48409,3,57,2,3500.00,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1279,8081,536,40771,48409,3,217,1,998.28,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1280,8081,536,40771,48409,3,68,1,209.64,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1281,8081,536,40771,48409,3,57,2,1207.92,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1282,8081,537,40771,48409,3,250,1,8500.00,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1283,8081,537,40771,48409,3,57,2,8500.00,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1284,8081,538,40771,48409,3,217,1,3305.79,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1285,8081,538,40771,48409,3,68,1,694.21,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1286,8081,538,40771,48409,3,57,2,4000.00,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1287,8081,539,40771,48409,3,217,1,2479.34,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1288,8081,539,40771,48409,3,68,1,520.66,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1289,8081,539,40771,48409,3,57,2,3000.00,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1290,8081,540,40771,48409,3,250,1,16374.00,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1291,8081,540,40771,48409,3,57,2,16374.00,NULL,'2022-11-30 20:47:44','2022-11-30 20:47:44',NULL),(1292,8081,541,40771,48410,3,217,1,2727.27,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1293,8081,541,40771,48410,3,68,1,572.73,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1294,8081,541,40771,48410,3,57,2,3300.00,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1295,8081,542,40771,48410,3,217,2,65.29,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1296,8081,542,40771,48410,3,67,2,13.71,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1297,8081,542,40771,48410,3,57,1,79.00,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1298,8081,543,40771,48410,3,250,1,6000.00,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1299,8081,543,40771,48410,3,57,2,6000.00,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1300,8081,544,40771,48410,3,217,1,1653.78,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL);
INSERT INTO `balance_libro_details` VALUES (1301,8081,544,40771,48410,3,68,1,347.29,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1302,8081,544,40771,48410,3,57,2,2001.07,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1303,8081,545,40771,48410,3,217,1,6528.92,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1304,8081,545,40771,48410,3,68,1,1371.08,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1305,8081,545,40771,48410,3,57,2,7900.00,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1306,8081,546,40771,48410,3,250,1,22125.00,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1307,8081,546,40771,48410,3,57,2,22125.00,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1308,8081,547,40771,48410,3,217,1,4132.23,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1309,8081,547,40771,48410,3,68,1,867.77,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1310,8081,547,40771,48410,3,57,2,5000.00,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1311,8081,548,40771,48410,3,217,1,6611.57,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1312,8081,548,40771,48410,3,68,1,1388.43,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1313,8081,548,40771,48410,3,57,2,8000.00,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1314,8081,549,40771,48410,3,250,1,19950.00,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1315,8081,549,40771,48410,3,57,2,19950.00,NULL,'2022-11-30 20:47:59','2022-11-30 20:47:59',NULL),(1316,8081,550,40771,48411,3,250,1,3500.00,NULL,'2022-11-30 20:48:15','2022-11-30 20:48:15',NULL),(1317,8081,550,40771,48411,3,57,2,3500.00,NULL,'2022-11-30 20:48:15','2022-11-30 20:48:15',NULL),(1318,8081,551,40771,48411,3,217,1,1195.87,NULL,'2022-11-30 20:48:15','2022-11-30 20:48:15',NULL),(1319,8081,551,40771,48411,3,68,1,251.13,NULL,'2022-11-30 20:48:15','2022-11-30 20:48:15',NULL),(1320,8081,551,40771,48411,3,57,2,1447.00,NULL,'2022-11-30 20:48:15','2022-11-30 20:48:15',NULL),(1321,8081,552,40771,48411,3,217,1,1463.31,NULL,'2022-11-30 20:48:15','2022-11-30 20:48:15',NULL),(1322,8081,552,40771,48411,3,68,1,307.30,NULL,'2022-11-30 20:48:15','2022-11-30 20:48:15',NULL),(1323,8081,552,40771,48411,3,57,2,1770.61,NULL,'2022-11-30 20:48:15','2022-11-30 20:48:15',NULL),(1324,8081,553,40771,48411,3,250,1,21650.00,NULL,'2022-11-30 20:48:15','2022-11-30 20:48:15',NULL),(1325,8081,553,40771,48411,3,57,2,21650.00,NULL,'2022-11-30 20:48:15','2022-11-30 20:48:15',NULL),(1326,8081,554,40771,48411,3,217,1,3305.79,NULL,'2022-11-30 20:48:15','2022-11-30 20:48:15',NULL),(1327,8081,554,40771,48411,3,68,1,694.21,NULL,'2022-11-30 20:48:15','2022-11-30 20:48:15',NULL),(1328,8081,554,40771,48411,3,57,2,4000.00,NULL,'2022-11-30 20:48:15','2022-11-30 20:48:15',NULL),(1329,8081,555,40943,216569,2,218,2,150.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1330,8081,555,40943,216569,2,13,1,150.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1331,8081,556,40943,216569,2,218,2,150.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1332,8081,556,40943,216569,2,13,1,150.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1333,8081,557,40943,216569,2,218,2,11350.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1334,8081,557,40943,216569,2,13,1,11350.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1335,8081,558,40943,216569,2,218,1,150.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1336,8081,558,40943,216569,2,13,2,150.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1337,8081,559,40943,216569,2,218,2,45250.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1338,8081,559,40943,216569,2,13,1,45250.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1339,8081,560,40943,216569,2,218,2,1350.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1340,8081,560,40943,216569,2,13,1,1350.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1341,8081,561,40943,216569,2,218,2,1600.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL);
INSERT INTO `balance_libro_details` VALUES (1342,8081,561,40943,216569,2,13,1,1600.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1343,8081,562,40943,216569,2,218,2,3050.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1344,8081,562,40943,216569,2,13,1,3050.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1345,8081,563,40943,216569,2,218,2,14400.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1346,8081,563,40943,216569,2,13,1,14400.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1347,8081,564,40943,216569,2,218,2,950.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1348,8081,564,40943,216569,2,13,1,950.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1349,8081,565,40943,216569,2,218,2,180000.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1350,8081,565,40943,216569,2,13,1,180000.00,NULL,'2022-11-30 21:36:54','2022-11-30 21:36:54',NULL),(1351,8081,566,40943,216570,2,218,2,2400.00,NULL,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(1352,8081,566,40943,216570,2,13,1,2400.00,NULL,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(1353,8081,567,40943,216570,2,218,2,3600.00,NULL,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(1354,8081,567,40943,216570,2,13,1,3600.00,NULL,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(1355,8081,568,40943,216570,2,218,2,100000.00,NULL,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(1356,8081,568,40943,216570,2,13,1,100000.00,NULL,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(1357,8081,569,40943,216570,2,218,2,320.00,NULL,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(1358,8081,569,40943,216570,2,13,1,320.00,NULL,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(1359,8081,570,40943,216570,2,218,2,1300.00,NULL,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(1360,8081,570,40943,216570,2,13,1,1300.00,NULL,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(1361,8081,571,40943,216570,2,218,2,25220.00,NULL,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(1362,8081,571,40943,216570,2,13,1,25220.00,NULL,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(1363,8081,572,40943,216570,2,218,2,1080.00,NULL,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(1364,8081,572,40943,216570,2,13,1,1080.00,NULL,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(1365,8081,573,40943,216570,2,218,2,2340.00,NULL,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(1366,8081,573,40943,216570,2,13,1,2340.00,NULL,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(1367,8081,574,40943,216570,2,218,2,75000.00,NULL,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(1368,8081,574,40943,216570,2,13,1,75000.00,NULL,'2022-11-30 21:37:27','2022-11-30 21:37:27',NULL),(1369,8081,575,40943,216570,2,218,2,4080.00,NULL,'2022-11-30 21:37:28','2022-11-30 21:37:28',NULL),(1370,8081,575,40943,216570,2,13,1,4080.00,NULL,'2022-11-30 21:37:28','2022-11-30 21:37:28',NULL),(1371,8081,576,40943,216570,2,218,2,3791.00,NULL,'2022-11-30 21:37:28','2022-11-30 21:37:28',NULL),(1372,8081,576,40943,216570,2,13,1,3791.00,NULL,'2022-11-30 21:37:28','2022-11-30 21:37:28',NULL),(1373,8081,577,40943,216570,2,218,2,37310.00,NULL,'2022-11-30 21:37:28','2022-11-30 21:37:28',NULL),(1374,8081,577,40943,216570,2,13,1,37310.00,NULL,'2022-11-30 21:37:28','2022-11-30 21:37:28',NULL),(1375,8081,578,40943,216570,2,218,2,3700.00,NULL,'2022-11-30 21:37:28','2022-11-30 21:37:28',NULL),(1376,8081,578,40943,216570,2,13,1,3700.00,NULL,'2022-11-30 21:37:28','2022-11-30 21:37:28',NULL),(1377,8081,579,40943,216572,2,218,2,3575.00,NULL,'2022-11-30 21:47:55','2022-11-30 21:47:55',NULL),(1378,8081,579,40943,216572,2,13,1,3575.00,NULL,'2022-11-30 21:47:55','2022-11-30 21:47:55',NULL),(1379,8081,580,40943,216572,2,218,2,2700.00,NULL,'2022-11-30 21:47:55','2022-11-30 21:47:55',NULL),(1380,8081,580,40943,216572,2,13,1,2700.00,NULL,'2022-11-30 21:47:55','2022-11-30 21:47:55',NULL),(1381,8081,581,40943,216572,2,218,2,6000.00,NULL,'2022-11-30 21:47:55','2022-11-30 21:47:55',NULL);
INSERT INTO `balance_libro_details` VALUES (1382,8081,581,40943,216572,2,13,1,6000.00,NULL,'2022-11-30 21:47:55','2022-11-30 21:47:55',NULL),(1383,8081,582,40943,216572,2,218,2,1950.00,NULL,'2022-11-30 21:47:55','2022-11-30 21:47:55',NULL),(1384,8081,582,40943,216572,2,13,1,1950.00,NULL,'2022-11-30 21:47:55','2022-11-30 21:47:55',NULL),(1385,8081,583,40943,216572,2,218,2,5940.00,NULL,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(1386,8081,583,40943,216572,2,13,1,5940.00,NULL,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(1387,8081,584,40943,216572,2,218,2,890.00,NULL,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(1388,8081,584,40943,216572,2,13,1,890.00,NULL,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(1389,8081,585,40943,216572,2,218,2,15000.00,NULL,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(1390,8081,585,40943,216572,2,13,1,15000.00,NULL,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(1391,8081,586,40943,216572,2,218,2,20000.00,NULL,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(1392,8081,586,40943,216572,2,13,1,20000.00,NULL,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(1393,8081,587,40943,216572,2,218,2,3504.00,NULL,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(1394,8081,587,40943,216572,2,13,1,3504.00,NULL,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(1395,8081,588,40943,216572,2,218,2,2500.00,NULL,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(1396,8081,588,40943,216572,2,13,1,2500.00,NULL,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(1397,8081,589,40943,216572,2,218,2,3575.00,NULL,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(1398,8081,589,40943,216572,2,13,1,3575.00,NULL,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(1399,8081,590,40943,216572,2,218,2,3640.00,NULL,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(1400,8081,590,40943,216572,2,13,1,3640.00,NULL,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(1401,8081,591,40943,216572,2,218,2,1900.00,NULL,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(1402,8081,591,40943,216572,2,13,1,1900.00,NULL,'2022-11-30 21:47:56','2022-11-30 21:47:56',NULL),(1403,8081,592,40943,216569,3,217,1,784.08,NULL,'2022-11-30 21:49:32','2022-11-30 21:49:32',NULL),(1404,8081,592,40943,216569,3,68,1,164.66,NULL,'2022-11-30 21:49:32','2022-11-30 21:49:32',NULL),(1405,8081,592,40943,216569,3,217,1,41.26,NULL,'2022-11-30 21:49:32','2022-11-30 21:49:32',NULL),(1406,8081,592,40943,216569,3,57,2,990.00,NULL,'2022-11-30 21:49:32','2022-11-30 21:49:32',NULL),(1407,8081,593,40943,216569,3,217,1,3312.40,NULL,'2022-11-30 21:49:32','2022-11-30 21:49:32',NULL),(1408,8081,593,40943,216569,3,68,1,695.60,NULL,'2022-11-30 21:49:32','2022-11-30 21:49:32',NULL),(1409,8081,593,40943,216569,3,57,2,4008.00,NULL,'2022-11-30 21:49:32','2022-11-30 21:49:32',NULL),(1410,8081,594,40943,216570,3,217,1,3528.93,NULL,'2022-11-30 21:49:58','2022-11-30 21:49:58',NULL),(1411,8081,594,40943,216570,3,68,1,741.07,NULL,'2022-11-30 21:49:58','2022-11-30 21:49:58',NULL),(1412,8081,594,40943,216570,3,57,2,4270.00,NULL,'2022-11-30 21:49:58','2022-11-30 21:49:58',NULL),(1413,8081,595,40943,216570,3,217,1,625.03,NULL,'2022-11-30 21:49:58','2022-11-30 21:49:58',NULL),(1414,8081,595,40943,216570,3,68,1,131.26,NULL,'2022-11-30 21:49:58','2022-11-30 21:49:58',NULL),(1415,8081,595,40943,216570,3,57,2,756.29,NULL,'2022-11-30 21:49:58','2022-11-30 21:49:58',NULL),(1416,8081,596,40943,216570,3,217,1,2958.02,NULL,'2022-11-30 21:49:58','2022-11-30 21:49:58',NULL),(1417,8081,596,40943,216570,3,68,1,621.19,NULL,'2022-11-30 21:49:58','2022-11-30 21:49:58',NULL),(1418,8081,596,40943,216570,3,57,2,3579.21,NULL,'2022-11-30 21:49:58','2022-11-30 21:49:58',NULL),(1419,8081,597,40943,216570,3,217,1,367.72,NULL,'2022-11-30 21:49:58','2022-11-30 21:49:58',NULL),(1420,8081,597,40943,216570,3,68,1,77.22,NULL,'2022-11-30 21:49:58','2022-11-30 21:49:58',NULL),(1421,8081,597,40943,216570,3,57,2,444.94,NULL,'2022-11-30 21:49:58','2022-11-30 21:49:58',NULL);
INSERT INTO `balance_libro_details` VALUES (1422,8081,598,40943,216571,3,217,1,1774.55,NULL,'2022-11-30 21:50:16','2022-11-30 21:50:16',NULL),(1423,8081,598,40943,216571,3,68,1,372.66,NULL,'2022-11-30 21:50:16','2022-11-30 21:50:16',NULL),(1424,8081,598,40943,216571,3,57,2,2147.21,NULL,'2022-11-30 21:50:16','2022-11-30 21:50:16',NULL),(1425,8081,599,40943,216571,3,250,1,5470.00,NULL,'2022-11-30 21:50:16','2022-11-30 21:50:16',NULL),(1426,8081,599,40943,216571,3,57,2,5470.00,NULL,'2022-11-30 21:50:16','2022-11-30 21:50:16',NULL),(1427,8081,600,40943,216572,3,217,1,3172.20,NULL,'2022-11-30 21:50:35','2022-11-30 21:50:35',NULL),(1428,8081,600,40943,216572,3,68,1,666.16,NULL,'2022-11-30 21:50:35','2022-11-30 21:50:35',NULL),(1429,8081,600,40943,216572,3,57,2,3838.36,NULL,'2022-11-30 21:50:35','2022-11-30 21:50:35',NULL),(1430,8081,601,40866,99912,2,218,2,24370.00,NULL,'2022-11-30 22:05:37','2022-11-30 22:05:37',NULL),(1431,8081,601,40866,99912,2,13,1,24370.00,NULL,'2022-11-30 22:05:37','2022-11-30 22:05:37',NULL),(1432,8081,602,40866,99912,2,218,2,380.00,NULL,'2022-11-30 22:05:37','2022-11-30 22:05:37',NULL),(1433,8081,602,40866,99912,2,13,1,380.00,NULL,'2022-11-30 22:05:37','2022-11-30 22:05:37',NULL),(1434,8081,603,40866,99912,2,218,2,13612.00,NULL,'2022-11-30 22:05:37','2022-11-30 22:05:37',NULL),(1435,8081,603,40866,99912,2,13,1,13612.00,NULL,'2022-11-30 22:05:37','2022-11-30 22:05:37',NULL),(1436,8081,604,40866,99912,2,218,2,18107.50,NULL,'2022-11-30 22:05:37','2022-11-30 22:05:37',NULL),(1437,8081,604,40866,99912,2,13,1,18107.50,NULL,'2022-11-30 22:05:37','2022-11-30 22:05:37',NULL),(1438,8081,605,40866,99912,2,218,2,20695.00,NULL,'2022-11-30 22:05:37','2022-11-30 22:05:37',NULL),(1439,8081,605,40866,99912,2,13,1,20695.00,NULL,'2022-11-30 22:05:37','2022-11-30 22:05:37',NULL),(1440,8081,606,40866,99912,2,218,2,14830.00,NULL,'2022-11-30 22:05:37','2022-11-30 22:05:37',NULL),(1441,8081,606,40866,99912,2,13,1,14830.00,NULL,'2022-11-30 22:05:37','2022-11-30 22:05:37',NULL),(1442,8081,607,40866,99912,2,218,2,15354.00,NULL,'2022-11-30 22:05:38','2022-11-30 22:05:38',NULL),(1443,8081,607,40866,99912,2,13,1,15354.00,NULL,'2022-11-30 22:05:38','2022-11-30 22:05:38',NULL),(1444,8081,608,40866,99912,2,218,2,13432.00,NULL,'2022-11-30 22:05:38','2022-11-30 22:05:38',NULL),(1445,8081,608,40866,99912,2,13,1,13432.00,NULL,'2022-11-30 22:05:38','2022-11-30 22:05:38',NULL),(1446,8081,609,40866,99912,2,218,2,17292.00,NULL,'2022-11-30 22:05:38','2022-11-30 22:05:38',NULL),(1447,8081,609,40866,99912,2,13,1,17292.00,NULL,'2022-11-30 22:05:38','2022-11-30 22:05:38',NULL),(1448,8081,610,40866,99912,2,218,2,9300.00,NULL,'2022-11-30 22:05:38','2022-11-30 22:05:38',NULL),(1449,8081,610,40866,99912,2,13,1,9300.00,NULL,'2022-11-30 22:05:38','2022-11-30 22:05:38',NULL),(1450,8081,611,40866,99912,2,218,2,12808.00,NULL,'2022-11-30 22:05:38','2022-11-30 22:05:38',NULL),(1451,8081,611,40866,99912,2,13,1,12808.00,NULL,'2022-11-30 22:05:38','2022-11-30 22:05:38',NULL),(1452,8081,612,40866,99913,2,218,2,15550.00,NULL,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(1453,8081,612,40866,99913,2,13,1,15550.00,NULL,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(1454,8081,613,40866,99913,2,218,2,15000.00,NULL,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(1455,8081,613,40866,99913,2,13,1,15000.00,NULL,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(1456,8081,614,40866,99913,2,218,2,12065.00,NULL,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(1457,8081,614,40866,99913,2,13,1,12065.00,NULL,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(1458,8081,615,40866,99913,2,218,2,17230.00,NULL,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(1459,8081,615,40866,99913,2,13,1,17230.00,NULL,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(1460,8081,616,40866,99913,2,218,2,21257.00,NULL,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(1461,8081,616,40866,99913,2,13,1,21257.00,NULL,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL);
INSERT INTO `balance_libro_details` VALUES (1462,8081,617,40866,99913,2,218,2,8895.00,NULL,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(1463,8081,617,40866,99913,2,13,1,8895.00,NULL,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(1464,8081,618,40866,99913,2,218,2,8567.00,NULL,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(1465,8081,618,40866,99913,2,13,1,8567.00,NULL,'2022-11-30 22:05:58','2022-11-30 22:05:58',NULL),(1466,8081,619,40866,99914,2,218,2,12150.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1467,8081,619,40866,99914,2,13,1,12150.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1468,8081,620,40866,99914,2,218,2,9325.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1469,8081,620,40866,99914,2,13,1,9325.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1470,8081,621,40866,99914,2,218,2,9600.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1471,8081,621,40866,99914,2,13,1,9600.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1472,8081,622,40866,99914,2,218,2,10175.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1473,8081,622,40866,99914,2,13,1,10175.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1474,8081,623,40866,99914,2,218,2,4050.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1475,8081,623,40866,99914,2,13,1,4050.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1476,8081,624,40866,99914,2,218,2,3950.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1477,8081,624,40866,99914,2,13,1,3950.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1478,8081,625,40866,99914,2,218,2,5708.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1479,8081,625,40866,99914,2,13,1,5708.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1480,8081,626,40866,99914,2,218,2,2800.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1481,8081,626,40866,99914,2,13,1,2800.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1482,8081,627,40866,99914,2,218,2,15200.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1483,8081,627,40866,99914,2,13,1,15200.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1484,8081,628,40866,99914,2,218,2,9800.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1485,8081,628,40866,99914,2,13,1,9800.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1486,8081,629,40866,99914,2,218,2,11480.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1487,8081,629,40866,99914,2,13,1,11480.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1488,8081,630,40866,99914,2,218,2,7820.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1489,8081,630,40866,99914,2,13,1,7820.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1490,8081,631,40866,99914,2,218,2,12900.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1491,8081,631,40866,99914,2,13,1,12900.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1492,8081,632,40866,99914,2,218,2,13330.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1493,8081,632,40866,99914,2,13,1,13330.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1494,8081,633,40866,99914,2,218,2,15200.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1495,8081,633,40866,99914,2,13,1,15200.00,NULL,'2022-11-30 22:06:31','2022-11-30 22:06:31',NULL),(1496,8081,634,40866,99915,2,218,2,13490.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1497,8081,634,40866,99915,2,13,1,13490.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1498,8081,635,40866,99915,2,218,2,19050.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1499,8081,635,40866,99915,2,13,1,19050.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1500,8081,636,40866,99915,2,218,2,19050.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1501,8081,636,40866,99915,2,13,1,19050.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL);
INSERT INTO `balance_libro_details` VALUES (1502,8081,637,40866,99915,2,218,2,17455.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1503,8081,637,40866,99915,2,13,1,17455.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1504,8081,638,40866,99915,2,218,2,15625.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1505,8081,638,40866,99915,2,13,1,15625.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1506,8081,639,40866,99915,2,218,2,9375.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1507,8081,639,40866,99915,2,13,1,9375.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1508,8081,640,40866,99915,2,218,2,6500.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1509,8081,640,40866,99915,2,13,1,6500.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1510,8081,641,40866,99915,2,218,2,6700.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1511,8081,641,40866,99915,2,13,1,6700.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1512,8081,642,40866,99915,2,218,2,7400.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1513,8081,642,40866,99915,2,13,1,7400.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1514,8081,643,40866,99915,2,218,2,6200.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1515,8081,643,40866,99915,2,13,1,6200.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1516,8081,644,40866,99915,2,218,2,12330.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1517,8081,644,40866,99915,2,13,1,12330.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1518,8081,645,40866,99915,2,218,2,8200.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1519,8081,645,40866,99915,2,13,1,8200.00,NULL,'2022-11-30 22:06:52','2022-11-30 22:06:52',NULL),(1520,8081,646,40866,99916,2,218,2,10300.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1521,8081,646,40866,99916,2,13,1,10300.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1522,8081,647,40866,99916,2,218,2,12700.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1523,8081,647,40866,99916,2,13,1,12700.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1524,8081,648,40866,99916,2,218,2,9200.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1525,8081,648,40866,99916,2,13,1,9200.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1526,8081,649,40866,99916,2,218,2,8700.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1527,8081,649,40866,99916,2,13,1,8700.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1528,8081,650,40866,99916,2,218,2,16500.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1529,8081,650,40866,99916,2,13,1,16500.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1530,8081,651,40866,99916,2,218,2,15700.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1531,8081,651,40866,99916,2,13,1,15700.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1532,8081,652,40866,99916,2,218,2,16730.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1533,8081,652,40866,99916,2,13,1,16730.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1534,8081,653,40866,99916,2,218,2,19600.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1535,8081,653,40866,99916,2,13,1,19600.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1536,8081,654,40866,99916,2,218,2,20080.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1537,8081,654,40866,99916,2,13,1,20080.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1538,8081,655,40866,99916,2,218,2,20800.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1539,8081,655,40866,99916,2,13,1,20800.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1540,8081,656,40866,99916,2,218,2,14000.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1541,8081,656,40866,99916,2,13,1,14000.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL);
INSERT INTO `balance_libro_details` VALUES (1542,8081,657,40866,99916,2,218,2,16500.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1543,8081,657,40866,99916,2,13,1,16500.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1544,8081,658,40866,99916,2,218,2,17770.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1545,8081,658,40866,99916,2,13,1,17770.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1546,8081,659,40866,99916,2,218,2,7260.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1547,8081,659,40866,99916,2,13,1,7260.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1548,8081,660,40866,99916,2,218,2,13600.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1549,8081,660,40866,99916,2,13,1,13600.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1550,8081,661,40866,99916,2,218,2,15660.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1551,8081,661,40866,99916,2,13,1,15660.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1552,8081,662,40866,99916,2,218,2,10600.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1553,8081,662,40866,99916,2,13,1,10600.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1554,8081,663,40866,99916,2,218,2,6180.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1555,8081,663,40866,99916,2,13,1,6180.00,NULL,'2022-12-06 22:40:07','2022-12-06 22:40:07',NULL),(1556,8081,664,40866,99917,2,218,2,13470.00,NULL,'2022-12-06 22:40:49','2022-12-06 22:40:49',NULL),(1557,8081,664,40866,99917,2,13,1,13470.00,NULL,'2022-12-06 22:40:49','2022-12-06 22:40:49',NULL),(1558,8081,665,40866,99917,2,218,2,11700.00,NULL,'2022-12-06 22:40:49','2022-12-06 22:40:49',NULL),(1559,8081,665,40866,99917,2,13,1,11700.00,NULL,'2022-12-06 22:40:49','2022-12-06 22:40:49',NULL),(1560,8081,666,40866,99917,2,218,2,12290.00,NULL,'2022-12-06 22:40:49','2022-12-06 22:40:49',NULL),(1561,8081,666,40866,99917,2,13,1,12290.00,NULL,'2022-12-06 22:40:49','2022-12-06 22:40:49',NULL),(1562,8081,667,40866,99917,2,218,2,6650.00,NULL,'2022-12-06 22:40:49','2022-12-06 22:40:49',NULL),(1563,8081,667,40866,99917,2,13,1,6650.00,NULL,'2022-12-06 22:40:49','2022-12-06 22:40:49',NULL),(1564,8081,668,40866,99917,2,218,2,6300.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1565,8081,668,40866,99917,2,13,1,6300.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1566,8081,669,40866,99917,2,218,2,18200.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1567,8081,669,40866,99917,2,13,1,18200.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1568,8081,670,40866,99917,2,218,2,9000.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1569,8081,670,40866,99917,2,13,1,9000.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1570,8081,671,40866,99917,2,218,2,9000.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1571,8081,671,40866,99917,2,13,1,9000.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1572,8081,672,40866,99917,2,218,2,11750.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1573,8081,672,40866,99917,2,13,1,11750.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1574,8081,673,40866,99917,2,218,2,7340.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1575,8081,673,40866,99917,2,13,1,7340.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1576,8081,674,40866,99917,2,218,2,17550.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1577,8081,674,40866,99917,2,13,1,17550.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1578,8081,675,40866,99917,2,218,2,6900.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1579,8081,675,40866,99917,2,13,1,6900.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1580,8081,676,40866,99917,2,218,2,17380.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1581,8081,676,40866,99917,2,13,1,17380.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL);
INSERT INTO `balance_libro_details` VALUES (1582,8081,677,40866,99917,2,218,2,12900.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1583,8081,677,40866,99917,2,13,1,12900.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1584,8081,678,40866,99917,2,218,2,8500.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1585,8081,678,40866,99917,2,13,1,8500.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1586,8081,679,40866,99917,2,218,2,13000.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1587,8081,679,40866,99917,2,13,1,13000.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1588,8081,680,40866,99917,2,218,2,6900.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1589,8081,680,40866,99917,2,13,1,6900.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1590,8081,681,40866,99917,2,218,2,8340.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1591,8081,681,40866,99917,2,13,1,8340.00,NULL,'2022-12-06 22:40:50','2022-12-06 22:40:50',NULL),(1592,8081,682,40866,99918,2,218,2,12100.00,NULL,'2022-12-06 22:50:25','2022-12-06 22:50:25',NULL),(1593,8081,682,40866,99918,2,13,1,12100.00,NULL,'2022-12-06 22:50:25','2022-12-06 22:50:25',NULL),(1594,8081,683,40866,99918,2,218,2,13000.00,NULL,'2022-12-06 22:50:25','2022-12-06 22:50:25',NULL),(1595,8081,683,40866,99918,2,13,1,13000.00,NULL,'2022-12-06 22:50:25','2022-12-06 22:50:25',NULL),(1596,8081,684,40866,99918,2,218,2,13300.00,NULL,'2022-12-06 22:50:25','2022-12-06 22:50:25',NULL),(1597,8081,684,40866,99918,2,13,1,13300.00,NULL,'2022-12-06 22:50:25','2022-12-06 22:50:25',NULL),(1598,8081,685,40866,99918,2,218,2,7500.00,NULL,'2022-12-06 22:50:25','2022-12-06 22:50:25',NULL),(1599,8081,685,40866,99918,2,13,1,7500.00,NULL,'2022-12-06 22:50:25','2022-12-06 22:50:25',NULL),(1600,8081,686,40866,99918,2,218,2,8340.00,NULL,'2022-12-06 22:50:25','2022-12-06 22:50:25',NULL),(1601,8081,686,40866,99918,2,13,1,8340.00,NULL,'2022-12-06 22:50:25','2022-12-06 22:50:25',NULL),(1602,8081,687,40866,99918,2,218,2,5450.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1603,8081,687,40866,99918,2,13,1,5450.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1604,8081,688,40866,99918,2,218,2,8400.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1605,8081,688,40866,99918,2,13,1,8400.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1606,8081,689,40866,99918,2,218,2,5070.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1607,8081,689,40866,99918,2,13,1,5070.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1608,8081,690,40866,99918,2,218,2,6800.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1609,8081,690,40866,99918,2,13,1,6800.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1610,8081,691,40866,99918,2,218,2,7540.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1611,8081,691,40866,99918,2,13,1,7540.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1612,8081,692,40866,99918,2,218,2,11200.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1613,8081,692,40866,99918,2,13,1,11200.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1614,8081,693,40866,99918,2,218,2,9600.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1615,8081,693,40866,99918,2,13,1,9600.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1616,8081,694,40866,99918,2,218,2,9600.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1617,8081,694,40866,99918,2,13,1,9600.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1618,8081,695,40866,99918,2,218,2,7500.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1619,8081,695,40866,99918,2,13,1,7500.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1620,8081,696,40866,99918,2,218,2,8600.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1621,8081,696,40866,99918,2,13,1,8600.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL);
INSERT INTO `balance_libro_details` VALUES (1622,8081,697,40866,99918,2,218,2,7900.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1623,8081,697,40866,99918,2,13,1,7900.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1624,8081,698,40866,99918,2,218,2,9100.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1625,8081,698,40866,99918,2,13,1,9100.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1626,8081,699,40866,99918,2,218,2,9200.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1627,8081,699,40866,99918,2,13,1,9200.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1628,8081,700,40866,99918,2,218,2,6900.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1629,8081,700,40866,99918,2,13,1,6900.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1630,8081,701,40866,99918,2,218,2,7700.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1631,8081,701,40866,99918,2,13,1,7700.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1632,8081,702,40866,99918,2,218,2,5600.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1633,8081,702,40866,99918,2,13,1,5600.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1634,8081,703,40866,99918,2,218,2,10400.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1635,8081,703,40866,99918,2,13,1,10400.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1636,8081,704,40866,99918,2,218,2,5130.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1637,8081,704,40866,99918,2,13,1,5130.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1638,8081,705,40866,99918,2,218,2,9340.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1639,8081,705,40866,99918,2,13,1,9340.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1640,8081,706,40866,99918,2,218,2,6350.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1641,8081,706,40866,99918,2,13,1,6350.00,NULL,'2022-12-06 22:50:26','2022-12-06 22:50:26',NULL),(1642,8081,707,40918,178699,2,218,2,3000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1643,8081,707,40918,178699,2,13,1,3000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1644,8081,708,40918,178699,2,218,2,3000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1645,8081,708,40918,178699,2,13,1,3000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1646,8081,709,40918,178699,2,218,2,3200.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1647,8081,709,40918,178699,2,13,1,3200.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1648,8081,710,40918,178699,2,218,2,3000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1649,8081,710,40918,178699,2,13,1,3000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1650,8081,711,40918,178699,2,218,2,3000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1651,8081,711,40918,178699,2,13,1,3000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1652,8081,712,40918,178699,2,218,2,3000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1653,8081,712,40918,178699,2,13,1,3000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1654,8081,713,40918,178699,2,218,2,3000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1655,8081,713,40918,178699,2,13,1,3000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1656,8081,714,40918,178699,2,218,2,3000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1657,8081,714,40918,178699,2,13,1,3000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1658,8081,715,40918,178699,2,218,2,3000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1659,8081,715,40918,178699,2,13,1,3000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1660,8081,716,40918,178699,2,218,2,7500.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1661,8081,716,40918,178699,2,13,1,7500.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL);
INSERT INTO `balance_libro_details` VALUES (1662,8081,717,40918,178699,2,218,2,13000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1663,8081,717,40918,178699,2,13,1,13000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1664,8081,718,40918,178699,2,218,2,3000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1665,8081,718,40918,178699,2,13,1,3000.00,NULL,'2022-12-07 14:55:59','2022-12-07 14:55:59',NULL),(1666,8081,719,40918,178699,2,218,2,3000.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1667,8081,719,40918,178699,2,13,1,3000.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1668,8081,720,40918,178699,2,218,2,3000.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1669,8081,720,40918,178699,2,13,1,3000.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1670,8081,721,40918,178699,2,218,2,5500.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1671,8081,721,40918,178699,2,13,1,5500.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1672,8081,722,40918,178699,2,218,2,3000.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1673,8081,722,40918,178699,2,13,1,3000.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1674,8081,723,40918,178699,2,218,2,4500.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1675,8081,723,40918,178699,2,13,1,4500.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1676,8081,724,40918,178699,2,218,2,5500.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1677,8081,724,40918,178699,2,13,1,5500.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1678,8081,725,40918,178699,2,218,2,3000.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1679,8081,725,40918,178699,2,13,1,3000.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1680,8081,726,40918,178699,2,218,2,3000.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1681,8081,726,40918,178699,2,13,1,3000.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1682,8081,727,40918,178699,2,218,2,3000.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1683,8081,727,40918,178699,2,13,1,3000.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1684,8081,728,40918,178699,2,218,2,3000.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1685,8081,728,40918,178699,2,13,1,3000.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1686,8081,729,40918,178699,2,218,2,3000.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1687,8081,729,40918,178699,2,13,1,3000.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1688,8081,730,40918,178699,2,218,2,11500.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1689,8081,730,40918,178699,2,13,1,11500.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1690,8081,731,40918,178699,2,218,2,10000.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1691,8081,731,40918,178699,2,13,1,10000.00,NULL,'2022-12-07 14:56:00','2022-12-07 14:56:00',NULL),(1692,8081,732,40918,178698,3,250,1,0.00,NULL,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL),(1693,8081,732,40918,178698,3,250,1,11367.00,NULL,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL),(1694,8081,732,40918,178698,3,57,2,11367.00,NULL,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL),(1695,8081,733,40918,178698,3,217,1,5000.00,NULL,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL),(1696,8081,733,40918,178698,3,68,1,1050.00,NULL,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL),(1697,8081,733,40918,178698,3,57,2,6050.00,NULL,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL),(1698,8081,734,40918,178698,3,217,1,1307.50,NULL,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL),(1699,8081,734,40918,178698,3,68,1,274.58,NULL,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL),(1700,8081,734,40918,178698,3,57,2,1582.08,NULL,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL),(1701,8081,735,40918,178698,3,217,1,157.02,NULL,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL);
INSERT INTO `balance_libro_details` VALUES (1702,8081,735,40918,178698,3,68,1,32.98,NULL,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL),(1703,8081,735,40918,178698,3,57,2,190.00,NULL,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL),(1704,8081,736,40918,178698,3,217,1,15538.84,NULL,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL),(1705,8081,736,40918,178698,3,68,1,3263.16,NULL,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL),(1706,8081,736,40918,178698,3,57,2,18802.00,NULL,'2022-12-07 15:00:39','2022-12-07 15:00:39',NULL),(1707,8081,737,40918,178699,3,250,1,0.00,NULL,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(1708,8081,737,40918,178699,3,250,1,11367.00,NULL,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(1709,8081,737,40918,178699,3,57,2,11367.00,NULL,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(1710,8081,738,40918,178699,3,217,1,8752.07,NULL,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(1711,8081,738,40918,178699,3,68,1,1837.93,NULL,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(1712,8081,738,40918,178699,3,57,2,10590.00,NULL,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(1713,8081,739,40918,178699,3,217,1,47106.61,NULL,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(1714,8081,739,40918,178699,3,68,1,9892.39,NULL,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(1715,8081,739,40918,178699,3,57,2,56999.00,NULL,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(1716,8081,740,40918,178699,3,217,1,3553.72,NULL,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(1717,8081,740,40918,178699,3,68,1,746.28,NULL,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(1718,8081,740,40918,178699,3,57,2,4300.00,NULL,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(1719,8081,741,40918,178699,3,217,1,2987.60,NULL,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(1720,8081,741,40918,178699,3,68,1,627.39,NULL,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(1721,8081,741,40918,178699,3,57,2,3614.99,NULL,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(1722,8081,742,40918,178699,3,250,2,0.00,NULL,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(1723,8081,742,40918,178699,3,250,2,1405.94,NULL,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(1724,8081,742,40918,178699,3,57,1,1405.94,NULL,'2022-12-07 15:02:48','2022-12-07 15:02:48',NULL),(1725,8081,743,40731,9028,2,218,2,3485.96,NULL,'2022-12-07 15:05:58','2022-12-07 15:05:58',NULL),(1726,8081,743,40731,9028,2,13,1,3485.96,NULL,'2022-12-07 15:05:58','2022-12-07 15:05:58',NULL),(1727,8081,744,40731,9028,2,218,2,1937.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(1728,8081,744,40731,9028,2,13,1,1937.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(1729,8081,745,40731,9028,2,218,2,72000.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(1730,8081,745,40731,9028,2,13,1,72000.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(1731,8081,746,40731,9028,2,218,2,90000.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(1732,8081,746,40731,9028,2,13,1,90000.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(1733,8081,747,40731,9028,2,218,2,19220.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(1734,8081,747,40731,9028,2,13,1,19220.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(1735,8081,748,40731,9028,2,218,2,53000.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(1736,8081,748,40731,9028,2,13,1,53000.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(1737,8081,749,40731,9028,2,218,2,63437.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(1738,8081,749,40731,9028,2,13,1,63437.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(1739,8081,750,40731,9028,2,218,2,21000.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(1740,8081,750,40731,9028,2,13,1,21000.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(1741,8081,751,40731,9028,2,218,2,15000.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL);
INSERT INTO `balance_libro_details` VALUES (1742,8081,751,40731,9028,2,13,1,15000.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(1743,8081,752,40731,9028,2,218,2,46647.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(1744,8081,752,40731,9028,2,13,1,46647.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(1745,8081,753,40731,9028,2,218,2,8000.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(1746,8081,753,40731,9028,2,13,1,8000.00,NULL,'2022-12-07 15:05:59','2022-12-07 15:05:59',NULL),(1747,8081,754,40731,9028,3,217,1,9.65,NULL,'2022-12-07 15:06:39','2022-12-07 15:06:39',NULL),(1748,8081,754,40731,9028,3,68,1,2.03,NULL,'2022-12-07 15:06:39','2022-12-07 15:06:39',NULL),(1749,8081,754,40731,9028,3,57,2,11.68,NULL,'2022-12-07 15:06:39','2022-12-07 15:06:39',NULL),(1750,8081,755,40731,9028,3,217,1,4531.68,NULL,'2022-12-07 15:06:39','2022-12-10 22:03:42','2022-12-10 22:03:42'),(1751,8081,755,40731,9028,3,68,1,951.65,NULL,'2022-12-07 15:06:39','2022-12-10 22:03:42','2022-12-10 22:03:42'),(1752,8081,755,40731,9028,3,217,1,164.50,NULL,'2022-12-07 15:06:39','2022-12-10 22:03:42','2022-12-10 22:03:42'),(1753,8081,755,40731,9028,3,57,2,5647.83,NULL,'2022-12-07 15:06:39','2022-12-10 22:03:42','2022-12-10 22:03:42'),(1754,8081,756,40731,9028,3,217,1,20980.80,NULL,'2022-12-07 15:06:40','2022-12-10 22:03:00','2022-12-10 22:03:00'),(1755,8081,756,40731,9028,3,68,1,4405.97,NULL,'2022-12-07 15:06:40','2022-12-10 22:03:00','2022-12-10 22:03:00'),(1756,8081,756,40731,9028,3,217,1,761.60,NULL,'2022-12-07 15:06:40','2022-12-10 22:03:00','2022-12-10 22:03:00'),(1757,8081,756,40731,9028,3,57,2,26148.37,NULL,'2022-12-07 15:06:40','2022-12-10 22:03:00','2022-12-10 22:03:00'),(1758,8081,757,40731,9028,3,217,1,29725.65,NULL,'2022-12-07 15:06:40','2022-12-10 22:07:25','2022-12-10 22:07:25'),(1759,8081,757,40731,9028,3,68,1,6242.39,NULL,'2022-12-07 15:06:40','2022-12-10 22:07:25','2022-12-10 22:07:25'),(1760,8081,757,40731,9028,3,217,1,1079.04,NULL,'2022-12-07 15:06:40','2022-12-10 22:07:25','2022-12-10 22:07:25'),(1761,8081,757,40731,9028,3,57,2,37047.08,NULL,'2022-12-07 15:06:40','2022-12-10 22:07:25','2022-12-10 22:07:25'),(1762,8081,758,40731,9028,3,217,1,29735.35,NULL,'2022-12-07 15:06:40','2022-12-10 22:04:16','2022-12-10 22:04:16'),(1763,8081,758,40731,9028,3,68,1,6244.42,NULL,'2022-12-07 15:06:40','2022-12-10 22:04:16','2022-12-10 22:04:16'),(1764,8081,758,40731,9028,3,217,1,1079.39,NULL,'2022-12-07 15:06:40','2022-12-10 22:04:16','2022-12-10 22:04:16'),(1765,8081,758,40731,9028,3,57,2,37059.16,NULL,'2022-12-07 15:06:40','2022-12-10 22:04:16','2022-12-10 22:04:16'),(1766,8081,759,40731,9028,3,217,1,564.44,NULL,'2022-12-07 15:06:40','2022-12-10 22:04:48','2022-12-10 22:04:48'),(1767,8081,759,40731,9028,3,68,1,118.53,NULL,'2022-12-07 15:06:40','2022-12-10 22:04:48','2022-12-10 22:04:48'),(1768,8081,759,40731,9028,3,217,1,20.49,NULL,'2022-12-07 15:06:40','2022-12-10 22:04:48','2022-12-10 22:04:48'),(1769,8081,759,40731,9028,3,57,2,703.46,NULL,'2022-12-07 15:06:40','2022-12-10 22:04:48','2022-12-10 22:04:48'),(1770,8081,760,40731,9028,3,217,1,40924.30,NULL,'2022-12-07 15:06:40','2022-12-10 22:05:19','2022-12-10 22:05:19'),(1771,8081,760,40731,9028,3,68,1,8594.10,NULL,'2022-12-07 15:06:40','2022-12-10 22:05:19','2022-12-10 22:05:19'),(1772,8081,760,40731,9028,3,217,1,1485.55,NULL,'2022-12-07 15:06:40','2022-12-10 22:05:19','2022-12-10 22:05:19'),(1773,8081,760,40731,9028,3,57,2,51003.95,NULL,'2022-12-07 15:06:40','2022-12-10 22:05:19','2022-12-10 22:05:19'),(1774,8081,761,40731,9028,3,217,1,602.00,NULL,'2022-12-07 15:06:40','2022-12-10 22:07:53','2022-12-10 22:07:53'),(1775,8081,761,40731,9028,3,68,1,126.42,NULL,'2022-12-07 15:06:40','2022-12-10 22:07:53','2022-12-10 22:07:53'),(1776,8081,761,40731,9028,3,217,1,21.85,NULL,'2022-12-07 15:06:40','2022-12-10 22:07:53','2022-12-10 22:07:53'),(1777,8081,761,40731,9028,3,57,2,750.27,NULL,'2022-12-07 15:06:40','2022-12-10 22:07:53','2022-12-10 22:07:53');
INSERT INTO `balance_libro_details` VALUES (1778,8081,762,40731,9028,3,250,1,11030.00,NULL,'2022-12-07 15:06:40','2022-12-07 15:06:40',NULL),(1779,8081,762,40731,9028,3,57,2,11030.00,NULL,'2022-12-07 15:06:40','2022-12-07 15:06:40',NULL),(1780,8081,763,40731,9028,3,217,1,391.91,NULL,'2022-12-07 15:06:40','2022-12-07 15:06:40',NULL),(1781,8081,763,40731,9028,3,68,1,82.30,NULL,'2022-12-07 15:06:40','2022-12-07 15:06:40',NULL),(1782,8081,763,40731,9028,3,217,1,39.18,NULL,'2022-12-07 15:06:40','2022-12-07 15:06:40',NULL),(1783,8081,763,40731,9028,3,57,2,513.39,NULL,'2022-12-07 15:06:40','2022-12-07 15:06:40',NULL),(1784,8081,764,40731,9028,3,217,1,44436.64,NULL,'2022-12-07 15:06:40','2022-12-10 22:05:51','2022-12-10 22:05:51'),(1785,8081,764,40731,9028,3,68,1,9331.69,NULL,'2022-12-07 15:06:40','2022-12-10 22:05:51','2022-12-10 22:05:51'),(1786,8081,764,40731,9028,3,217,1,1613.05,NULL,'2022-12-07 15:06:40','2022-12-10 22:05:51','2022-12-10 22:05:51'),(1787,8081,764,40731,9028,3,57,2,55381.38,NULL,'2022-12-07 15:06:40','2022-12-10 22:05:51','2022-12-10 22:05:51'),(1788,8081,765,40731,9028,3,217,1,18485.54,NULL,'2022-12-07 15:06:40','2022-12-10 22:06:18','2022-12-10 22:06:18'),(1789,8081,765,40731,9028,3,68,1,3881.96,NULL,'2022-12-07 15:06:40','2022-12-10 22:06:18','2022-12-10 22:06:18'),(1790,8081,765,40731,9028,3,217,1,671.03,NULL,'2022-12-07 15:06:40','2022-12-10 22:06:18','2022-12-10 22:06:18'),(1791,8081,765,40731,9028,3,57,2,23038.53,NULL,'2022-12-07 15:06:40','2022-12-10 22:06:18','2022-12-10 22:06:18'),(1792,8081,766,40731,9028,3,217,1,26059.05,NULL,'2022-12-07 15:06:40','2022-12-10 22:06:54','2022-12-10 22:06:54'),(1793,8081,766,40731,9028,3,68,1,5472.40,NULL,'2022-12-07 15:06:40','2022-12-10 22:06:54','2022-12-10 22:06:54'),(1794,8081,766,40731,9028,3,217,1,945.94,NULL,'2022-12-07 15:06:40','2022-12-10 22:06:54','2022-12-10 22:06:54'),(1795,8081,766,40731,9028,3,57,2,32477.39,NULL,'2022-12-07 15:06:40','2022-12-10 22:06:54','2022-12-10 22:06:54'),(1796,8081,767,40997,263531,2,218,2,5000.00,NULL,'2022-12-07 15:12:02','2022-12-07 15:12:02',NULL),(1797,8081,767,40997,263531,2,13,1,5000.00,NULL,'2022-12-07 15:12:02','2022-12-07 15:12:02',NULL),(1798,8081,768,40997,263531,2,218,2,5000.00,NULL,'2022-12-07 15:12:02','2022-12-07 15:12:02',NULL),(1799,8081,768,40997,263531,2,13,1,5000.00,NULL,'2022-12-07 15:12:02','2022-12-07 15:12:02',NULL),(1800,8081,769,40997,263531,2,218,2,3000.00,NULL,'2022-12-07 15:12:02','2022-12-07 15:12:02',NULL),(1801,8081,769,40997,263531,2,13,1,3000.00,NULL,'2022-12-07 15:12:02','2022-12-07 15:12:02',NULL),(1802,8081,770,40997,263532,2,218,2,3500.00,NULL,'2022-12-07 15:12:26','2022-12-07 15:12:26',NULL),(1803,8081,770,40997,263532,2,13,1,3500.00,NULL,'2022-12-07 15:12:26','2022-12-07 15:12:26',NULL),(1804,8081,771,40997,263532,2,218,2,8000.00,NULL,'2022-12-07 15:12:26','2022-12-07 15:12:26',NULL),(1805,8081,771,40997,263532,2,13,1,8000.00,NULL,'2022-12-07 15:12:26','2022-12-07 15:12:26',NULL),(1806,8081,772,40997,263532,2,218,2,6500.00,NULL,'2022-12-07 15:12:26','2022-12-07 15:12:26',NULL),(1807,8081,772,40997,263532,2,13,1,6500.00,NULL,'2022-12-07 15:12:26','2022-12-07 15:12:26',NULL),(1808,8081,773,40997,263533,2,218,2,0.00,NULL,'2022-12-07 15:13:12','2022-12-07 15:13:12',NULL),(1809,8081,773,40997,263533,2,218,2,2200.00,NULL,'2022-12-07 15:13:12','2022-12-07 15:13:12',NULL),(1810,8081,773,40997,263533,2,13,1,2200.00,NULL,'2022-12-07 15:13:12','2022-12-07 15:13:12',NULL),(1811,8081,774,40997,263533,2,96,2,5413.31,NULL,'2022-12-07 15:13:12','2022-12-07 15:13:12',NULL),(1812,8081,774,40997,263533,2,67,2,1136.80,NULL,'2022-12-07 15:13:12','2022-12-07 15:13:12',NULL),(1813,8081,774,40997,263533,2,218,2,0.03,NULL,'2022-12-07 15:13:12','2022-12-07 15:13:12',NULL),(1814,8081,774,40997,263533,2,13,1,6550.14,NULL,'2022-12-07 15:13:12','2022-12-07 15:13:12',NULL),(1815,8081,775,40997,263534,2,218,2,6000.00,NULL,'2022-12-07 15:13:31','2022-12-07 15:13:31',NULL),(1816,8081,775,40997,263534,2,13,1,6000.00,NULL,'2022-12-07 15:13:31','2022-12-07 15:13:31',NULL);
INSERT INTO `balance_libro_details` VALUES (1817,8081,776,40997,263534,2,218,2,3000.00,NULL,'2022-12-07 15:13:31','2022-12-07 15:13:31',NULL),(1818,8081,776,40997,263534,2,13,1,3000.00,NULL,'2022-12-07 15:13:31','2022-12-07 15:13:31',NULL),(1819,8081,777,40997,263534,2,218,2,6000.00,NULL,'2022-12-07 15:13:31','2022-12-07 15:13:31',NULL),(1820,8081,777,40997,263534,2,13,1,6000.00,NULL,'2022-12-07 15:13:31','2022-12-07 15:13:31',NULL),(1821,8081,778,40997,263534,2,218,2,5500.00,NULL,'2022-12-07 15:13:31','2022-12-07 15:13:31',NULL),(1822,8081,778,40997,263534,2,13,1,5500.00,NULL,'2022-12-07 15:13:31','2022-12-07 15:13:31',NULL),(1823,8081,779,40997,263534,2,218,2,6500.00,NULL,'2022-12-07 15:13:32','2022-12-07 15:13:32',NULL),(1824,8081,779,40997,263534,2,13,1,6500.00,NULL,'2022-12-07 15:13:32','2022-12-07 15:13:32',NULL),(1825,8081,780,40997,263535,2,218,2,3500.00,NULL,'2022-12-07 15:14:10','2022-12-07 15:14:10',NULL),(1826,8081,780,40997,263535,2,13,1,3500.00,NULL,'2022-12-07 15:14:10','2022-12-07 15:14:10',NULL),(1827,8081,781,40997,263535,2,218,2,6000.00,NULL,'2022-12-07 15:14:10','2022-12-07 15:14:10',NULL),(1828,8081,781,40997,263535,2,13,1,6000.00,NULL,'2022-12-07 15:14:10','2022-12-07 15:14:10',NULL),(1829,8081,782,40997,263535,2,218,2,9000.00,NULL,'2022-12-07 15:14:10','2022-12-07 15:14:10',NULL),(1830,8081,782,40997,263535,2,13,1,9000.00,NULL,'2022-12-07 15:14:10','2022-12-07 15:14:10',NULL),(1831,8081,783,40997,263535,2,218,2,4000.00,NULL,'2022-12-07 15:14:10','2022-12-07 15:14:10',NULL),(1832,8081,783,40997,263535,2,13,1,4000.00,NULL,'2022-12-07 15:14:10','2022-12-07 15:14:10',NULL),(1833,8081,784,40997,263536,2,218,2,7000.00,NULL,'2022-12-07 15:14:30','2022-12-07 15:14:30',NULL),(1834,8081,784,40997,263536,2,13,1,7000.00,NULL,'2022-12-07 15:14:30','2022-12-07 15:14:30',NULL),(1835,8081,785,40997,263536,2,218,2,10000.00,NULL,'2022-12-07 15:14:30','2022-12-07 15:14:30',NULL),(1836,8081,785,40997,263536,2,13,1,10000.00,NULL,'2022-12-07 15:14:30','2022-12-07 15:14:30',NULL),(1837,8081,786,40997,263536,2,218,2,6000.00,NULL,'2022-12-07 15:14:30','2022-12-07 15:14:30',NULL),(1838,8081,786,40997,263536,2,13,1,6000.00,NULL,'2022-12-07 15:14:30','2022-12-07 15:14:30',NULL),(1839,8081,787,40997,263536,2,218,2,7000.00,NULL,'2022-12-07 15:14:30','2022-12-07 15:14:30',NULL),(1840,8081,787,40997,263536,2,13,1,7000.00,NULL,'2022-12-07 15:14:30','2022-12-07 15:14:30',NULL),(1841,8081,788,40997,263532,3,217,1,14932.95,NULL,'2022-12-07 15:15:42','2022-12-07 15:15:42',NULL),(1842,8081,788,40997,263532,3,68,1,3135.92,NULL,'2022-12-07 15:15:42','2022-12-07 15:15:42',NULL),(1843,8081,788,40997,263532,3,57,2,18068.87,NULL,'2022-12-07 15:15:42','2022-12-07 15:15:42',NULL),(1844,8081,789,40997,263532,3,250,1,5404.00,NULL,'2022-12-07 15:15:43','2022-12-07 15:15:43',NULL),(1845,8081,789,40997,263532,3,57,2,5404.00,NULL,'2022-12-07 15:15:43','2022-12-07 15:15:43',NULL),(1846,8081,790,40997,263532,3,217,1,247.11,NULL,'2022-12-07 15:15:43','2022-12-07 15:15:43',NULL),(1847,8081,790,40997,263532,3,68,1,51.89,NULL,'2022-12-07 15:15:43','2022-12-07 15:15:43',NULL),(1848,8081,790,40997,263532,3,57,2,299.00,NULL,'2022-12-07 15:15:43','2022-12-07 15:15:43',NULL),(1849,8081,791,40997,263532,3,217,1,2760.10,NULL,'2022-12-07 15:15:43','2022-12-07 15:15:43',NULL),(1850,8081,791,40997,263532,3,68,1,579.63,NULL,'2022-12-07 15:15:43','2022-12-07 15:15:43',NULL),(1851,8081,791,40997,263532,3,57,2,3339.73,NULL,'2022-12-07 15:15:43','2022-12-07 15:15:43',NULL),(1852,8081,792,40997,263534,3,217,1,41.32,NULL,'2022-12-07 15:17:04','2022-12-07 15:17:04',NULL),(1853,8081,792,40997,263534,3,68,1,8.68,NULL,'2022-12-07 15:17:04','2022-12-07 15:17:04',NULL),(1854,8081,792,40997,263534,3,57,2,50.00,NULL,'2022-12-07 15:17:04','2022-12-07 15:17:04',NULL),(1855,8081,793,40997,263534,3,250,1,2502.00,NULL,'2022-12-07 15:17:04','2022-12-07 15:17:04',NULL),(1856,8081,793,40997,263534,3,57,2,2502.00,NULL,'2022-12-07 15:17:04','2022-12-07 15:17:04',NULL);
INSERT INTO `balance_libro_details` VALUES (1857,8081,794,40997,263535,3,217,1,112.40,NULL,'2022-12-07 15:17:24','2022-12-07 15:17:24',NULL),(1858,8081,794,40997,263535,3,68,1,23.60,NULL,'2022-12-07 15:17:24','2022-12-07 15:17:24',NULL),(1859,8081,794,40997,263535,3,57,2,136.00,NULL,'2022-12-07 15:17:24','2022-12-07 15:17:24',NULL),(1860,8081,795,40997,263535,3,217,1,793.39,NULL,'2022-12-07 15:17:24','2022-12-07 15:17:24',NULL),(1861,8081,795,40997,263535,3,68,1,166.61,NULL,'2022-12-07 15:17:24','2022-12-07 15:17:24',NULL),(1862,8081,795,40997,263535,3,57,2,960.00,NULL,'2022-12-07 15:17:24','2022-12-07 15:17:24',NULL),(1863,8081,796,40997,263536,3,217,1,3446.48,NULL,'2022-12-07 15:18:01','2022-12-07 15:18:01',NULL),(1864,8081,796,40997,263536,3,68,1,723.76,NULL,'2022-12-07 15:18:01','2022-12-07 15:18:01',NULL),(1865,8081,796,40997,263536,3,57,2,4170.24,NULL,'2022-12-07 15:18:01','2022-12-07 15:18:01',NULL),(1866,8081,797,40997,263536,3,250,1,2700.00,NULL,'2022-12-07 15:18:01','2022-12-07 15:18:01',NULL),(1867,8081,797,40997,263536,3,57,2,2700.00,NULL,'2022-12-07 15:18:01','2022-12-07 15:18:01',NULL),(1868,8081,798,40943,216573,2,218,2,1800.00,NULL,'2022-12-07 16:08:19','2022-12-07 16:08:19',NULL),(1869,8081,798,40943,216573,2,13,1,1800.00,NULL,'2022-12-07 16:08:19','2022-12-07 16:08:19',NULL),(1870,8081,799,40943,216573,2,218,2,16420.00,NULL,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(1871,8081,799,40943,216573,2,13,1,16420.00,NULL,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(1872,8081,800,40943,216573,2,218,2,12840.00,NULL,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(1873,8081,800,40943,216573,2,13,1,12840.00,NULL,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(1874,8081,801,40943,216573,2,218,2,10980.00,NULL,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(1875,8081,801,40943,216573,2,13,1,10980.00,NULL,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(1876,8081,802,40943,216573,2,218,2,2050.00,NULL,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(1877,8081,802,40943,216573,2,13,1,2050.00,NULL,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(1878,8081,803,40943,216573,2,218,2,12750.00,NULL,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(1879,8081,803,40943,216573,2,13,1,12750.00,NULL,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(1880,8081,804,40943,216573,2,218,2,12045.00,NULL,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(1881,8081,804,40943,216573,2,13,1,12045.00,NULL,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(1882,8081,805,40943,216573,2,218,2,5000.00,NULL,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(1883,8081,805,40943,216573,2,13,1,5000.00,NULL,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(1884,8081,806,40943,216573,2,218,2,149000.00,NULL,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(1885,8081,806,40943,216573,2,13,1,149000.00,NULL,'2022-12-07 16:08:20','2022-12-07 16:08:20',NULL),(1886,8081,807,40943,216574,2,218,2,6810.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1887,8081,807,40943,216574,2,13,1,6810.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1888,8081,808,40943,216574,2,218,2,49000.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1889,8081,808,40943,216574,2,13,1,49000.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1890,8081,809,40943,216574,2,218,2,5175.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1891,8081,809,40943,216574,2,13,1,5175.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1892,8081,810,40943,216574,2,218,2,11080.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1893,8081,810,40943,216574,2,13,1,11080.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1894,8081,811,40943,216574,2,218,2,12800.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1895,8081,811,40943,216574,2,13,1,12800.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1896,8081,812,40943,216574,2,218,2,12800.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL);
INSERT INTO `balance_libro_details` VALUES (1897,8081,812,40943,216574,2,13,1,12800.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1898,8081,813,40943,216574,2,218,2,4800.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1899,8081,813,40943,216574,2,13,1,4800.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1900,8081,814,40943,216574,2,218,2,2600.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1901,8081,814,40943,216574,2,13,1,2600.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1902,8081,815,40943,216574,2,218,2,5760.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1903,8081,815,40943,216574,2,13,1,5760.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1904,8081,816,40943,216574,2,218,2,13600.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1905,8081,816,40943,216574,2,13,1,13600.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1906,8081,817,40943,216574,2,218,2,2500.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1907,8081,817,40943,216574,2,13,1,2500.00,NULL,'2022-12-07 16:08:58','2022-12-07 16:08:58',NULL),(1908,8081,818,40943,216573,3,217,1,2322.64,NULL,'2022-12-07 16:10:32','2022-12-07 16:10:32',NULL),(1909,8081,818,40943,216573,3,68,1,487.76,NULL,'2022-12-07 16:10:32','2022-12-07 16:10:32',NULL),(1910,8081,818,40943,216573,3,57,2,2810.40,NULL,'2022-12-07 16:10:32','2022-12-07 16:10:32',NULL),(1911,8081,819,40943,216573,3,217,1,41292.00,NULL,'2022-12-07 16:10:32','2022-12-07 16:10:32',NULL),(1912,8081,819,40943,216573,3,68,1,8671.32,NULL,'2022-12-07 16:10:32','2022-12-07 16:10:32',NULL),(1913,8081,819,40943,216573,3,217,1,1238.76,NULL,'2022-12-07 16:10:32','2022-12-07 16:10:32',NULL),(1914,8081,819,40943,216573,3,57,2,51202.08,NULL,'2022-12-07 16:10:32','2022-12-07 16:10:32',NULL),(1915,8081,820,40943,216573,3,217,1,34767.72,NULL,'2022-12-07 16:10:32','2022-12-07 16:10:32',NULL),(1916,8081,820,40943,216573,3,68,1,7301.22,NULL,'2022-12-07 16:10:32','2022-12-07 16:10:32',NULL),(1917,8081,820,40943,216573,3,57,2,42068.94,NULL,'2022-12-07 16:10:32','2022-12-07 16:10:32',NULL),(1918,8081,821,40943,216574,3,217,1,1794.96,NULL,'2022-12-07 16:10:51','2022-12-07 16:10:51',NULL),(1919,8081,821,40943,216574,3,68,1,376.94,NULL,'2022-12-07 16:10:51','2022-12-07 16:10:51',NULL),(1920,8081,821,40943,216574,3,57,2,2171.90,NULL,'2022-12-07 16:10:51','2022-12-07 16:10:51',NULL),(1921,8081,822,40943,216574,3,217,1,12330.00,NULL,'2022-12-07 16:10:51','2022-12-07 16:10:51',NULL),(1922,8081,822,40943,216574,3,68,1,2589.30,NULL,'2022-12-07 16:10:51','2022-12-07 16:10:51',NULL),(1923,8081,822,40943,216574,3,57,2,14919.30,NULL,'2022-12-07 16:10:51','2022-12-07 16:10:51',NULL),(1924,8081,823,40943,216574,3,250,1,1455.00,NULL,'2022-12-07 16:10:51','2022-12-07 16:10:51',NULL),(1925,8081,823,40943,216574,3,57,2,1455.00,NULL,'2022-12-07 16:10:51','2022-12-07 16:10:51',NULL),(1926,8081,824,41068,293828,2,218,2,10000.00,NULL,'2022-12-07 16:12:48','2022-12-07 16:12:48',NULL),(1927,8081,824,41068,293828,2,13,1,10000.00,NULL,'2022-12-07 16:12:48','2022-12-07 16:12:48',NULL),(1928,8081,825,41068,293828,2,218,2,11000.00,NULL,'2022-12-07 16:12:48','2022-12-07 16:12:48',NULL),(1929,8081,825,41068,293828,2,13,1,11000.00,NULL,'2022-12-07 16:12:48','2022-12-07 16:12:48',NULL),(1930,8081,826,41068,293828,2,218,2,16000.00,NULL,'2022-12-07 16:12:48','2022-12-07 16:12:48',NULL),(1931,8081,826,41068,293828,2,13,1,16000.00,NULL,'2022-12-07 16:12:48','2022-12-07 16:12:48',NULL),(1932,8081,827,41068,293828,2,218,2,20000.00,NULL,'2022-12-07 16:12:48','2022-12-07 16:12:48',NULL),(1933,8081,827,41068,293828,2,13,1,20000.00,NULL,'2022-12-07 16:12:48','2022-12-07 16:12:48',NULL),(1934,8081,828,41068,293828,2,218,2,20000.00,NULL,'2022-12-07 16:12:48','2022-12-07 16:12:48',NULL),(1935,8081,828,41068,293828,2,13,1,20000.00,NULL,'2022-12-07 16:12:48','2022-12-07 16:12:48',NULL),(1936,8081,829,40720,296865,2,218,2,55000.00,NULL,'2022-12-09 16:04:30','2022-12-09 16:04:30',NULL);
INSERT INTO `balance_libro_details` VALUES (1937,8081,829,40720,296865,2,13,1,55000.00,NULL,'2022-12-09 16:04:30','2022-12-09 16:04:30',NULL),(1938,8081,830,40720,296865,2,218,2,160000.00,NULL,'2022-12-09 16:04:30','2022-12-09 16:04:30',NULL),(1939,8081,830,40720,296865,2,13,1,160000.00,NULL,'2022-12-09 16:04:30','2022-12-09 16:04:30',NULL),(1940,8081,831,40720,296866,2,218,2,100.00,NULL,'2022-12-09 16:07:36','2022-12-09 16:07:36',NULL),(1941,8081,831,40720,296866,2,13,1,100.00,NULL,'2022-12-09 16:07:36','2022-12-09 16:07:36',NULL),(1942,8081,832,40720,296866,2,218,2,108500.00,NULL,'2022-12-09 16:07:36','2022-12-09 16:07:36',NULL),(1943,8081,832,40720,296866,2,13,1,108500.00,NULL,'2022-12-09 16:07:36','2022-12-09 16:07:36',NULL),(1944,8081,833,40720,296866,2,218,2,110000.00,NULL,'2022-12-09 16:07:36','2022-12-09 16:07:36',NULL),(1945,8081,833,40720,296866,2,13,1,110000.00,NULL,'2022-12-09 16:07:36','2022-12-09 16:07:36',NULL),(1946,8081,834,40720,296865,3,217,1,633.60,NULL,'2022-12-09 16:09:07','2022-12-09 16:09:07',NULL),(1947,8081,834,40720,296865,3,68,1,133.06,NULL,'2022-12-09 16:09:07','2022-12-09 16:09:07',NULL),(1948,8081,834,40720,296865,3,217,1,33.34,NULL,'2022-12-09 16:09:07','2022-12-09 16:09:07',NULL),(1949,8081,834,40720,296865,3,57,2,800.00,NULL,'2022-12-09 16:09:07','2022-12-09 16:09:07',NULL),(1950,8081,835,40720,296865,3,250,2,0.00,NULL,'2022-12-09 16:09:07','2022-12-09 16:09:07',NULL),(1951,8081,835,40720,296865,3,250,2,697.11,NULL,'2022-12-09 16:09:07','2022-12-09 16:09:07',NULL),(1952,8081,835,40720,296865,3,57,1,697.11,NULL,'2022-12-09 16:09:07','2022-12-09 16:09:07',NULL),(1953,8081,836,40720,296865,3,217,1,554.77,NULL,'2022-12-09 16:09:07','2022-12-09 16:09:07',NULL),(1954,8081,836,40720,296865,3,68,1,116.53,NULL,'2022-12-09 16:09:07','2022-12-09 16:09:07',NULL),(1955,8081,836,40720,296865,3,57,2,671.30,NULL,'2022-12-09 16:09:07','2022-12-09 16:09:07',NULL),(1956,8081,837,40720,296865,3,217,1,633.60,NULL,'2022-12-09 16:09:07','2022-12-09 16:09:07',NULL),(1957,8081,837,40720,296865,3,68,1,133.06,NULL,'2022-12-09 16:09:07','2022-12-09 16:09:07',NULL),(1958,8081,837,40720,296865,3,217,1,33.34,NULL,'2022-12-09 16:09:07','2022-12-09 16:09:07',NULL),(1959,8081,837,40720,296865,3,57,2,800.00,NULL,'2022-12-09 16:09:07','2022-12-09 16:09:07',NULL),(1960,8081,838,40720,296865,3,217,1,413.22,NULL,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(1961,8081,838,40720,296865,3,68,1,86.78,NULL,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(1962,8081,838,40720,296865,3,57,2,500.00,NULL,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(1963,8081,839,40720,296865,3,217,1,465.44,NULL,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(1964,8081,839,40720,296865,3,68,1,97.76,NULL,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(1965,8081,839,40720,296865,3,57,2,563.20,NULL,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(1966,8081,840,40720,296865,3,217,1,633.60,NULL,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(1967,8081,840,40720,296865,3,68,1,133.06,NULL,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(1968,8081,840,40720,296865,3,217,1,33.34,NULL,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(1969,8081,840,40720,296865,3,57,2,800.00,NULL,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(1970,8081,841,40720,296865,3,217,1,439.67,NULL,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(1971,8081,841,40720,296865,3,68,1,92.33,NULL,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(1972,8081,841,40720,296865,3,57,2,532.00,NULL,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(1973,8081,842,40720,296865,3,250,1,0.00,NULL,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(1974,8081,842,40720,296865,3,250,1,21696.12,NULL,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(1975,8081,842,40720,296865,3,57,2,21696.12,NULL,'2022-12-09 16:09:08','2022-12-09 16:09:08',NULL),(1976,8081,843,40731,298410,2,218,2,618.99,NULL,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL);
INSERT INTO `balance_libro_details` VALUES (1977,8081,843,40731,298410,2,13,1,618.99,NULL,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(1978,8081,844,40731,298410,2,218,2,29530.00,NULL,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(1979,8081,844,40731,298410,2,13,1,29530.00,NULL,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(1980,8081,845,40731,298410,2,218,2,32900.00,NULL,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(1981,8081,845,40731,298410,2,13,1,32900.00,NULL,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(1982,8081,846,40731,298410,2,218,2,27600.00,NULL,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(1983,8081,846,40731,298410,2,13,1,27600.00,NULL,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(1984,8081,847,40731,298410,2,218,2,35200.00,NULL,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(1985,8081,847,40731,298410,2,13,1,35200.00,NULL,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(1986,8081,848,40731,298410,2,218,2,3000.00,NULL,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(1987,8081,848,40731,298410,2,13,1,3000.00,NULL,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(1988,8081,849,40731,298410,2,218,2,6360.00,NULL,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(1989,8081,849,40731,298410,2,13,1,6360.00,NULL,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(1990,8081,850,40731,298410,2,218,2,2995.00,NULL,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(1991,8081,850,40731,298410,2,13,1,2995.00,NULL,'2022-12-09 18:19:24','2022-12-09 18:19:24',NULL),(1992,8081,851,40731,9028,3,217,1,20980.80,NULL,'2022-12-10 22:03:00','2022-12-10 22:03:00',NULL),(1993,8081,851,40731,9028,3,68,1,4405.97,NULL,'2022-12-10 22:03:00','2022-12-10 22:03:00',NULL),(1994,8081,851,40731,9028,3,226,1,761.60,NULL,'2022-12-10 22:03:00','2022-12-10 22:03:00',NULL),(1995,8081,851,40731,9028,3,57,2,26148.37,NULL,'2022-12-10 22:03:00','2022-12-10 22:03:00',NULL),(1996,8081,852,40731,9028,3,217,1,4531.68,NULL,'2022-12-10 22:03:42','2022-12-10 22:03:42',NULL),(1997,8081,852,40731,9028,3,68,1,951.65,NULL,'2022-12-10 22:03:42','2022-12-10 22:03:42',NULL),(1998,8081,852,40731,9028,3,226,1,164.50,NULL,'2022-12-10 22:03:42','2022-12-10 22:03:42',NULL),(1999,8081,852,40731,9028,3,57,2,5647.83,NULL,'2022-12-10 22:03:42','2022-12-10 22:03:42',NULL),(2000,8081,853,40731,9028,3,217,1,29735.35,NULL,'2022-12-10 22:04:16','2022-12-10 22:04:16',NULL),(2001,8081,853,40731,9028,3,68,1,6244.42,NULL,'2022-12-10 22:04:16','2022-12-10 22:04:16',NULL),(2002,8081,853,40731,9028,3,226,1,1079.39,NULL,'2022-12-10 22:04:16','2022-12-10 22:04:16',NULL),(2003,8081,853,40731,9028,3,57,2,37059.16,NULL,'2022-12-10 22:04:16','2022-12-10 22:04:16',NULL),(2004,8081,854,40731,9028,3,217,1,564.44,NULL,'2022-12-10 22:04:48','2022-12-10 22:04:48',NULL),(2005,8081,854,40731,9028,3,68,1,118.53,NULL,'2022-12-10 22:04:48','2022-12-10 22:04:48',NULL),(2006,8081,854,40731,9028,3,226,1,20.49,NULL,'2022-12-10 22:04:48','2022-12-10 22:04:48',NULL),(2007,8081,854,40731,9028,3,57,2,703.46,NULL,'2022-12-10 22:04:48','2022-12-10 22:04:48',NULL),(2008,8081,855,40731,9028,3,217,1,40924.30,NULL,'2022-12-10 22:05:19','2022-12-10 22:05:19',NULL),(2009,8081,855,40731,9028,3,68,1,8594.10,NULL,'2022-12-10 22:05:19','2022-12-10 22:05:19',NULL),(2010,8081,855,40731,9028,3,226,1,1485.55,NULL,'2022-12-10 22:05:19','2022-12-10 22:05:19',NULL),(2011,8081,855,40731,9028,3,57,2,51003.95,NULL,'2022-12-10 22:05:19','2022-12-10 22:05:19',NULL),(2012,8081,856,40731,9028,3,217,1,44436.64,NULL,'2022-12-10 22:05:51','2022-12-10 22:39:51','2022-12-10 22:39:51'),(2013,8081,856,40731,9028,3,68,1,9331.69,NULL,'2022-12-10 22:05:51','2022-12-10 22:39:51','2022-12-10 22:39:51'),(2014,8081,856,40731,9028,3,226,1,16163.05,NULL,'2022-12-10 22:05:51','2022-12-10 22:39:51','2022-12-10 22:39:51'),(2015,8081,856,40731,9028,3,57,2,69931.38,NULL,'2022-12-10 22:05:51','2022-12-10 22:39:51','2022-12-10 22:39:51'),(2016,8081,857,40731,9028,3,217,1,18485.54,NULL,'2022-12-10 22:06:18','2022-12-10 22:06:18',NULL);
INSERT INTO `balance_libro_details` VALUES (2017,8081,857,40731,9028,3,68,1,3881.96,NULL,'2022-12-10 22:06:18','2022-12-10 22:06:18',NULL),(2018,8081,857,40731,9028,3,226,1,671.03,NULL,'2022-12-10 22:06:18','2022-12-10 22:06:18',NULL),(2019,8081,857,40731,9028,3,57,2,23038.53,NULL,'2022-12-10 22:06:18','2022-12-10 22:06:18',NULL),(2020,8081,858,40731,9028,3,217,1,26059.05,NULL,'2022-12-10 22:06:54','2022-12-10 22:06:54',NULL),(2021,8081,858,40731,9028,3,68,1,5472.40,NULL,'2022-12-10 22:06:54','2022-12-10 22:06:54',NULL),(2022,8081,858,40731,9028,3,225,1,945.94,NULL,'2022-12-10 22:06:54','2022-12-10 22:06:54',NULL),(2023,8081,858,40731,9028,3,57,2,32477.39,NULL,'2022-12-10 22:06:54','2022-12-10 22:06:54',NULL),(2024,8081,859,40731,9028,3,217,1,29725.65,NULL,'2022-12-10 22:07:25','2022-12-10 22:07:25',NULL),(2025,8081,859,40731,9028,3,68,1,6242.39,NULL,'2022-12-10 22:07:25','2022-12-10 22:07:25',NULL),(2026,8081,859,40731,9028,3,225,1,1079.04,NULL,'2022-12-10 22:07:25','2022-12-10 22:07:25',NULL),(2027,8081,859,40731,9028,3,57,2,37047.08,NULL,'2022-12-10 22:07:25','2022-12-10 22:07:25',NULL),(2028,8081,860,40731,9028,3,217,1,602.00,NULL,'2022-12-10 22:07:53','2022-12-10 22:07:53',NULL),(2029,8081,860,40731,9028,3,68,1,126.42,NULL,'2022-12-10 22:07:53','2022-12-10 22:07:53',NULL),(2030,8081,860,40731,9028,3,225,1,21.85,NULL,'2022-12-10 22:07:53','2022-12-10 22:07:53',NULL),(2031,8081,860,40731,9028,3,57,2,750.27,NULL,'2022-12-10 22:07:53','2022-12-10 22:07:53',NULL),(2032,8081,861,40731,9028,8,277,1,177.65,NULL,'2022-12-10 22:12:50','2022-12-10 22:12:50',NULL),(2033,8081,861,40731,9028,8,351,2,177.65,NULL,'2022-12-10 22:12:50','2022-12-10 22:12:50',NULL),(2034,8081,862,40731,9028,3,217,1,44436.64,NULL,'2022-12-10 22:39:51','2022-12-10 22:39:51',NULL),(2035,8081,862,40731,9028,3,68,1,9331.69,NULL,'2022-12-10 22:39:51','2022-12-10 22:39:51',NULL),(2036,8081,862,40731,9028,3,226,1,1613.05,NULL,'2022-12-10 22:39:51','2022-12-10 22:39:51',NULL),(2037,8081,862,40731,9028,3,57,2,55381.38,NULL,'2022-12-10 22:39:51','2022-12-10 22:39:51',NULL),(2038,8081,863,40731,9028,16,156,1,5483.04,NULL,'2022-12-10 22:42:34','2022-12-10 22:42:34',NULL),(2039,8081,863,40731,9028,16,302,2,1827.38,NULL,'2022-12-10 22:42:34','2022-12-10 22:42:34',NULL),(2040,8081,863,40731,9028,16,277,2,177.65,NULL,'2022-12-10 22:42:34','2022-12-10 22:42:34',NULL),(2041,8081,863,40731,9028,16,226,2,5795.61,NULL,'2022-12-10 22:42:34','2022-12-10 22:42:34',NULL),(2042,8081,863,40731,9028,16,302,1,2317.60,NULL,'2022-12-10 22:42:34','2022-12-10 22:42:34',NULL),(2043,8081,863,40731,9028,16,156,1,5273.97,NULL,'2022-12-10 22:42:34','2022-12-10 22:42:34',NULL),(2044,8081,863,40731,9028,16,301,2,2181.48,NULL,'2022-12-10 22:42:34','2022-12-10 22:42:34',NULL),(2045,8081,863,40731,9028,16,225,2,2046.83,NULL,'2022-12-10 22:42:34','2022-12-10 22:42:34',NULL),(2046,8081,863,40731,9028,16,326,2,1045.66,NULL,'2022-12-10 22:42:34','2022-12-10 22:42:34',NULL),(2047,8081,864,40720,1516,2,218,2,200000.00,NULL,'2022-12-11 20:18:17','2022-12-11 20:18:17',NULL),(2048,8081,864,40720,1516,2,13,1,200000.00,NULL,'2022-12-11 20:18:17','2022-12-11 20:18:17',NULL),(2049,8081,865,40720,1516,3,250,2,0.00,NULL,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(2050,8081,865,40720,1516,3,250,2,697.11,NULL,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(2051,8081,865,40720,1516,3,57,1,697.11,NULL,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(2052,8081,866,40720,1516,3,217,1,819.84,NULL,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(2053,8081,866,40720,1516,3,68,1,172.16,NULL,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(2054,8081,866,40720,1516,3,57,2,992.00,NULL,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(2055,8081,867,40720,1516,3,217,1,1652.23,NULL,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(2056,8081,867,40720,1516,3,68,1,346.97,NULL,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(2057,8081,867,40720,1516,3,57,2,1999.20,NULL,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL);
INSERT INTO `balance_libro_details` VALUES (2058,8081,868,40720,1516,3,217,1,909.09,NULL,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(2059,8081,868,40720,1516,3,68,1,190.91,NULL,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(2060,8081,868,40720,1516,3,57,2,1100.00,NULL,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(2061,8081,869,40720,1516,3,217,1,605.77,NULL,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(2062,8081,869,40720,1516,3,68,1,127.23,NULL,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(2063,8081,869,40720,1516,3,57,2,733.00,NULL,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(2064,8081,870,40720,1516,3,217,1,396.00,NULL,'2022-12-11 20:18:40','2022-12-11 20:20:08','2022-12-11 20:20:08'),(2065,8081,870,40720,1516,3,68,1,83.16,NULL,'2022-12-11 20:18:40','2022-12-11 20:20:08','2022-12-11 20:20:08'),(2066,8081,870,40720,1516,3,217,1,20.84,NULL,'2022-12-11 20:18:40','2022-12-11 20:20:08','2022-12-11 20:20:08'),(2067,8081,870,40720,1516,3,57,2,500.00,NULL,'2022-12-11 20:18:40','2022-12-11 20:20:08','2022-12-11 20:20:08'),(2068,8081,871,40720,1516,3,250,1,0.00,NULL,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(2069,8081,871,40720,1516,3,250,1,55568.06,NULL,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(2070,8081,871,40720,1516,3,57,2,55568.06,NULL,'2022-12-11 20:18:40','2022-12-11 20:18:40',NULL),(2071,8081,872,40720,1516,3,250,1,4060.00,NULL,'2022-12-11 20:18:40','2022-12-11 20:21:53','2022-12-11 20:21:53'),(2072,8081,872,40720,1516,3,57,2,4060.00,NULL,'2022-12-11 20:18:40','2022-12-11 20:21:53','2022-12-11 20:21:53'),(2073,8081,873,40720,1516,3,217,1,273.96,NULL,'2022-12-11 20:18:41','2022-12-11 20:18:41',NULL),(2074,8081,873,40720,1516,3,68,1,57.54,NULL,'2022-12-11 20:18:41','2022-12-11 20:18:41',NULL),(2075,8081,873,40720,1516,3,57,2,331.50,NULL,'2022-12-11 20:18:41','2022-12-11 20:18:41',NULL),(2076,8081,874,40720,1516,3,217,1,1266.10,NULL,'2022-12-11 20:18:41','2022-12-11 20:18:41',NULL),(2077,8081,874,40720,1516,3,68,1,265.88,NULL,'2022-12-11 20:18:41','2022-12-11 20:18:41',NULL),(2078,8081,874,40720,1516,3,217,1,0.02,NULL,'2022-12-11 20:18:41','2022-12-11 20:18:41',NULL),(2079,8081,874,40720,1516,3,57,2,1532.00,NULL,'2022-12-11 20:18:41','2022-12-11 20:18:41',NULL),(2080,8081,875,40720,1516,3,217,1,5049.57,NULL,'2022-12-11 20:18:41','2022-12-11 20:18:41',NULL),(2081,8081,875,40720,1516,3,68,1,1060.41,NULL,'2022-12-11 20:18:41','2022-12-11 20:18:41',NULL),(2082,8081,875,40720,1516,3,217,1,0.02,NULL,'2022-12-11 20:18:41','2022-12-11 20:18:41',NULL),(2083,8081,875,40720,1516,3,57,2,6110.00,NULL,'2022-12-11 20:18:41','2022-12-11 20:18:41',NULL),(2084,8081,876,40720,1516,3,217,1,113222.31,NULL,'2022-12-11 20:18:41','2022-12-11 20:18:41',NULL),(2085,8081,876,40720,1516,3,68,1,23776.69,NULL,'2022-12-11 20:18:41','2022-12-11 20:18:41',NULL),(2086,8081,876,40720,1516,3,57,2,136999.00,NULL,'2022-12-11 20:18:41','2022-12-11 20:18:41',NULL),(2087,8081,877,40720,1516,3,217,1,396.00,NULL,'2022-12-11 20:20:08','2022-12-11 20:20:08',NULL),(2088,8081,877,40720,1516,3,68,1,83.16,NULL,'2022-12-11 20:20:08','2022-12-11 20:20:08',NULL),(2089,8081,877,40720,1516,3,217,1,20.84,NULL,'2022-12-11 20:20:08','2022-12-11 20:20:08',NULL),(2090,8081,877,40720,1516,3,57,2,500.00,NULL,'2022-12-11 20:20:08','2022-12-11 20:20:08',NULL),(2091,8081,878,40720,1516,3,250,1,4060.00,NULL,'2022-12-11 20:21:53','2022-12-11 20:21:53',NULL),(2092,8081,878,40720,1516,3,57,2,4060.00,NULL,'2022-12-11 20:21:53','2022-12-11 20:21:53',NULL),(2093,8081,879,40720,1516,8,277,1,149.50,NULL,'2022-12-11 20:24:16','2022-12-11 20:24:16',NULL),(2094,8081,879,40720,1516,8,351,2,149.50,NULL,'2022-12-11 20:24:16','2022-12-11 20:24:16',NULL),(2095,8081,880,40720,1516,16,156,1,1936.00,NULL,'2022-12-11 21:32:39','2022-12-11 21:32:39',NULL),(2096,8081,880,40720,1516,16,277,2,149.50,NULL,'2022-12-11 21:32:39','2022-12-11 21:32:39',NULL),(2097,8081,880,40720,1516,16,327,2,1786.50,NULL,'2022-12-11 21:32:39','2022-12-11 21:32:39',NULL);
INSERT INTO `balance_libro_details` VALUES (2098,8081,880,40720,1516,16,156,1,3064.00,NULL,'2022-12-11 21:32:39','2022-12-11 21:32:39',NULL),(2099,8081,880,40720,1516,16,301,2,466.58,NULL,'2022-12-11 21:32:39','2022-12-11 21:32:39',NULL),(2100,8081,880,40720,1516,16,326,2,2597.42,NULL,'2022-12-11 21:32:39','2022-12-11 21:32:39',NULL),(2101,8081,881,41120,295345,8,277,1,1145.90,NULL,'2022-12-12 00:14:22','2022-12-12 00:14:22',NULL),(2102,8081,881,41120,295345,8,351,2,1145.90,NULL,'2022-12-12 00:14:22','2022-12-12 00:14:22',NULL),(2103,8081,882,41120,295345,8,276,1,5.30,NULL,'2022-12-12 00:14:22','2022-12-12 00:14:22',NULL),(2104,8081,882,41120,295345,8,351,2,5.30,NULL,'2022-12-12 00:14:22','2022-12-12 00:14:22',NULL),(2105,8081,883,40720,296867,2,218,2,27000.00,NULL,'2022-12-12 11:36:09','2022-12-12 11:36:09',NULL),(2106,8081,883,40720,296867,2,13,1,27000.00,NULL,'2022-12-12 11:36:09','2022-12-12 11:36:09',NULL),(2107,8081,884,40720,296867,2,218,2,4200.00,NULL,'2022-12-12 11:36:09','2022-12-12 11:36:09',NULL),(2108,8081,884,40720,296867,2,13,1,4200.00,NULL,'2022-12-12 11:36:09','2022-12-12 11:36:09',NULL),(2109,8081,885,40720,296867,2,218,2,189000.00,NULL,'2022-12-12 11:36:09','2022-12-12 11:36:09',NULL),(2110,8081,885,40720,296867,2,13,1,189000.00,NULL,'2022-12-12 11:36:09','2022-12-12 11:36:09',NULL),(2111,8081,886,40720,296868,2,218,2,120000.00,NULL,'2022-12-12 11:36:32','2022-12-12 11:36:32',NULL),(2112,8081,886,40720,296868,2,13,1,120000.00,NULL,'2022-12-12 11:36:32','2022-12-12 11:36:32',NULL),(2113,8081,887,40720,296868,2,218,2,8000.00,NULL,'2022-12-12 11:36:32','2022-12-12 11:36:32',NULL),(2114,8081,887,40720,296868,2,13,1,8000.00,NULL,'2022-12-12 11:36:32','2022-12-12 11:36:32',NULL),(2115,8081,888,40720,296868,2,218,2,10400.00,NULL,'2022-12-12 11:36:32','2022-12-12 11:36:32',NULL),(2116,8081,888,40720,296868,2,13,1,10400.00,NULL,'2022-12-12 11:36:32','2022-12-12 11:36:32',NULL),(2117,8081,889,40720,296868,2,218,2,5000.00,NULL,'2022-12-12 11:36:32','2022-12-12 11:36:32',NULL),(2118,8081,889,40720,296868,2,13,1,5000.00,NULL,'2022-12-12 11:36:32','2022-12-12 11:36:32',NULL),(2119,8081,890,40720,296868,2,218,2,6000.00,NULL,'2022-12-12 11:36:32','2022-12-12 11:36:32',NULL),(2120,8081,890,40720,296868,2,13,1,6000.00,NULL,'2022-12-12 11:36:32','2022-12-12 11:36:32',NULL),(2121,8081,891,40720,296868,2,218,2,79500.00,NULL,'2022-12-12 11:36:32','2022-12-12 11:36:32',NULL),(2122,8081,891,40720,296868,2,13,1,79500.00,NULL,'2022-12-12 11:36:32','2022-12-12 11:36:32',NULL),(2123,8081,892,40720,296869,2,218,2,10000.00,NULL,'2022-12-12 11:36:49','2022-12-12 11:36:49',NULL),(2124,8081,892,40720,296869,2,13,1,10000.00,NULL,'2022-12-12 11:36:49','2022-12-12 11:36:49',NULL),(2125,8081,893,40720,296869,2,218,2,28800.00,NULL,'2022-12-12 11:36:49','2022-12-12 11:36:49',NULL),(2126,8081,893,40720,296869,2,13,1,28800.00,NULL,'2022-12-12 11:36:49','2022-12-12 11:36:49',NULL),(2127,8081,894,40720,296869,2,218,2,180000.00,NULL,'2022-12-12 11:36:49','2022-12-12 11:36:49',NULL),(2128,8081,894,40720,296869,2,13,1,180000.00,NULL,'2022-12-12 11:36:49','2022-12-12 11:36:49',NULL),(2129,8081,895,40720,296869,2,218,1,10000.00,NULL,'2022-12-12 11:36:49','2022-12-12 11:36:49',NULL),(2130,8081,895,40720,296869,2,13,2,10000.00,NULL,'2022-12-12 11:36:49','2022-12-12 11:36:49',NULL),(2131,8081,896,40720,296869,2,218,2,340000.00,NULL,'2022-12-12 11:36:49','2022-12-12 11:36:49',NULL),(2132,8081,896,40720,296869,2,13,1,340000.00,NULL,'2022-12-12 11:36:49','2022-12-12 11:36:49',NULL),(2133,8081,897,40720,296870,2,218,2,29025.00,NULL,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(2134,8081,897,40720,296870,2,13,1,29025.00,NULL,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(2135,8081,898,40720,296870,2,218,2,11350.00,NULL,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(2136,8081,898,40720,296870,2,13,1,11350.00,NULL,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(2137,8081,899,40720,296870,2,218,1,11350.00,NULL,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL);
INSERT INTO `balance_libro_details` VALUES (2138,8081,899,40720,296870,2,13,2,11350.00,NULL,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(2139,8081,900,40720,296870,2,218,2,1350.00,NULL,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(2140,8081,900,40720,296870,2,13,1,1350.00,NULL,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(2141,8081,901,40720,296870,2,218,1,1350.00,NULL,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(2142,8081,901,40720,296870,2,13,2,1350.00,NULL,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(2143,8081,902,40720,296870,2,218,2,45250.00,NULL,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(2144,8081,902,40720,296870,2,13,1,45250.00,NULL,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(2145,8081,903,40720,296870,2,218,1,45250.00,NULL,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(2146,8081,903,40720,296870,2,13,2,45250.00,NULL,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(2147,8081,904,40720,296870,2,218,2,1600.00,NULL,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(2148,8081,904,40720,296870,2,13,1,1600.00,NULL,'2022-12-12 11:37:08','2022-12-12 11:37:08',NULL),(2149,8081,905,40720,296870,2,218,1,1600.00,NULL,'2022-12-12 11:37:09','2022-12-12 11:37:09',NULL),(2150,8081,905,40720,296870,2,13,2,1600.00,NULL,'2022-12-12 11:37:09','2022-12-12 11:37:09',NULL),(2151,8081,906,40720,296871,2,218,2,250000.00,NULL,'2022-12-12 11:37:27','2022-12-12 11:37:27',NULL),(2152,8081,906,40720,296871,2,13,1,250000.00,NULL,'2022-12-12 11:37:27','2022-12-12 11:37:27',NULL),(2153,8081,907,40720,296872,2,218,2,120000.00,NULL,'2022-12-12 11:37:45','2022-12-12 11:37:45',NULL),(2154,8081,907,40720,296872,2,13,1,120000.00,NULL,'2022-12-12 11:37:45','2022-12-12 11:37:45',NULL),(2155,8081,908,40720,296873,2,218,2,55000.00,NULL,'2022-12-12 11:38:32','2022-12-12 11:38:32',NULL),(2156,8081,908,40720,296873,2,13,1,55000.00,NULL,'2022-12-12 11:38:32','2022-12-12 11:38:32',NULL),(2157,8081,909,40720,296866,3,217,1,115.81,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2158,8081,909,40720,296866,3,68,1,24.32,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2159,8081,909,40720,296866,3,217,1,11.58,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2160,8081,909,40720,296866,3,57,2,151.71,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2161,8081,910,40720,296866,3,217,1,633.60,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2162,8081,910,40720,296866,3,68,1,133.06,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2163,8081,910,40720,296866,3,217,1,33.34,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2164,8081,910,40720,296866,3,57,2,800.00,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2165,8081,911,40720,296866,3,250,2,0.00,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2166,8081,911,40720,296866,3,250,2,697.11,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2167,8081,911,40720,296866,3,57,1,697.11,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2168,8081,912,40720,296866,3,217,1,465.44,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2169,8081,912,40720,296866,3,68,1,97.76,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2170,8081,912,40720,296866,3,57,2,563.20,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2171,8081,913,40720,296866,3,217,1,4049.59,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2172,8081,913,40720,296866,3,68,1,850.41,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2173,8081,913,40720,296866,3,57,2,4900.00,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2174,8081,914,40720,296866,3,217,1,1704.14,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2175,8081,914,40720,296866,3,68,1,357.87,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2176,8081,914,40720,296866,3,57,2,2062.01,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2177,8081,915,40720,296866,3,217,1,495.87,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL);
INSERT INTO `balance_libro_details` VALUES (2178,8081,915,40720,296866,3,68,1,104.13,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2179,8081,915,40720,296866,3,57,2,600.00,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2180,8081,916,40720,296866,3,217,1,855.26,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2181,8081,916,40720,296866,3,68,1,179.64,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2182,8081,916,40720,296866,3,57,2,1034.90,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2183,8081,917,40720,296866,3,250,1,0.00,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2184,8081,917,40720,296866,3,250,1,21696.12,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2185,8081,917,40720,296866,3,57,2,21696.12,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2186,8081,918,40720,296866,3,217,1,406.61,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2187,8081,918,40720,296866,3,68,1,85.39,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2188,8081,918,40720,296866,3,57,2,492.00,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2189,8081,919,40720,296866,3,217,1,633.60,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2190,8081,919,40720,296866,3,68,1,133.06,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2191,8081,919,40720,296866,3,217,1,33.34,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2192,8081,919,40720,296866,3,57,2,800.00,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2193,8081,920,40720,296866,3,217,1,158.40,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2194,8081,920,40720,296866,3,68,1,33.26,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2195,8081,920,40720,296866,3,217,1,8.34,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2196,8081,920,40720,296866,3,57,2,200.00,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2197,8081,921,40720,296866,3,217,1,2132.23,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2198,8081,921,40720,296866,3,68,1,447.77,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2199,8081,921,40720,296866,3,57,2,2580.00,NULL,'2022-12-12 11:40:26','2022-12-12 11:40:26',NULL),(2200,8081,922,40720,296867,3,250,2,0.00,NULL,'2022-12-12 11:40:42','2022-12-12 11:40:42',NULL),(2201,8081,922,40720,296867,3,250,2,697.11,NULL,'2022-12-12 11:40:42','2022-12-12 11:40:42',NULL),(2202,8081,922,40720,296867,3,57,1,697.11,NULL,'2022-12-12 11:40:42','2022-12-12 11:40:42',NULL),(2203,8081,923,40720,296867,3,217,1,63801.48,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2204,8081,923,40720,296867,3,68,1,13398.32,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2205,8081,923,40720,296867,3,217,1,105172.60,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2206,8081,923,40720,296867,3,57,2,182372.40,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2207,8081,924,40720,296867,3,217,2,67301.49,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2208,8081,924,40720,296867,3,67,2,14133.31,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2209,8081,924,40720,296867,3,217,2,100937.60,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2210,8081,924,40720,296867,3,57,1,182372.40,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2211,8081,925,40720,296867,3,217,1,1094.21,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2212,8081,925,40720,296867,3,68,1,229.79,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2213,8081,925,40720,296867,3,57,2,1324.00,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2214,8081,926,40720,296867,3,217,1,435.60,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2215,8081,926,40720,296867,3,68,1,91.48,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2216,8081,926,40720,296867,3,217,1,22.92,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2217,8081,926,40720,296867,3,57,2,550.00,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL);
INSERT INTO `balance_libro_details` VALUES (2218,8081,927,40720,296867,3,217,1,633.60,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2219,8081,927,40720,296867,3,68,1,133.06,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2220,8081,927,40720,296867,3,217,1,33.34,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2221,8081,927,40720,296867,3,57,2,800.00,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2222,8081,928,40720,296867,3,217,1,2314.05,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2223,8081,928,40720,296867,3,68,1,485.95,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2224,8081,928,40720,296867,3,57,2,2800.00,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2225,8081,929,40720,296867,3,217,1,495.87,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2226,8081,929,40720,296867,3,68,1,104.13,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2227,8081,929,40720,296867,3,57,2,600.00,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2228,8081,930,40720,296867,3,217,1,1166.92,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2229,8081,930,40720,296867,3,68,1,245.08,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2230,8081,930,40720,296867,3,57,2,1412.00,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2231,8081,931,40720,296867,3,250,1,0.00,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2232,8081,931,40720,296867,3,250,1,25686.33,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2233,8081,931,40720,296867,3,57,2,25686.33,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2234,8081,932,40720,296867,3,217,1,588.43,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2235,8081,932,40720,296867,3,68,1,123.57,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2236,8081,932,40720,296867,3,57,2,712.00,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2237,8081,933,40720,296867,3,217,1,247.93,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2238,8081,933,40720,296867,3,68,1,52.07,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2239,8081,933,40720,296867,3,57,2,300.00,NULL,'2022-12-12 11:40:43','2022-12-12 11:40:43',NULL),(2240,8081,934,40720,296868,3,250,2,0.00,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2241,8081,934,40720,296868,3,250,2,697.11,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2242,8081,934,40720,296868,3,57,1,697.11,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2243,8081,935,40720,296868,3,217,1,1041.32,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2244,8081,935,40720,296868,3,68,1,218.68,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2245,8081,935,40720,296868,3,57,2,1260.00,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2246,8081,936,40720,296868,3,217,1,1791.94,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2247,8081,936,40720,296868,3,68,1,376.31,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2248,8081,936,40720,296868,3,217,1,18.10,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2249,8081,936,40720,296868,3,57,2,2186.35,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2250,8081,937,40720,296868,3,217,1,27602.48,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2251,8081,937,40720,296868,3,68,1,5796.52,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2252,8081,937,40720,296868,3,57,2,33399.00,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2253,8081,938,40720,296868,3,217,1,583.46,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2254,8081,938,40720,296868,3,68,1,122.54,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2255,8081,938,40720,296868,3,57,2,706.00,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2256,8081,939,40720,296868,3,217,1,495.87,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2257,8081,939,40720,296868,3,68,1,104.13,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2258,8081,939,40720,296868,3,57,2,600.00,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL);
INSERT INTO `balance_libro_details` VALUES (2259,8081,940,40720,296868,3,217,1,836.36,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2260,8081,940,40720,296868,3,68,1,175.64,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2261,8081,940,40720,296868,3,57,2,1012.00,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2262,8081,941,40720,296868,3,217,1,165.29,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2263,8081,941,40720,296868,3,68,1,34.71,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2264,8081,941,40720,296868,3,57,2,200.00,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2265,8081,942,40720,296868,3,250,1,0.00,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2266,8081,942,40720,296868,3,250,1,23604.24,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2267,8081,942,40720,296868,3,57,2,23604.24,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2268,8081,943,40720,296868,3,250,1,0.00,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2269,8081,943,40720,296868,3,250,1,7866.00,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2270,8081,943,40720,296868,3,57,2,7866.00,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2271,8081,944,40720,296868,3,217,1,3566.26,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2272,8081,944,40720,296868,3,68,1,748.91,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2273,8081,944,40720,296868,3,57,2,4315.17,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2274,8081,945,40720,296868,3,217,1,15966.94,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2275,8081,945,40720,296868,3,68,1,3353.06,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2276,8081,945,40720,296868,3,57,2,19320.00,NULL,'2022-12-12 11:40:59','2022-12-12 11:40:59',NULL),(2277,8081,946,40720,296869,3,250,2,0.00,NULL,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(2278,8081,946,40720,296869,3,250,2,697.11,NULL,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(2279,8081,946,40720,296869,3,57,1,697.11,NULL,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(2280,8081,947,40720,296869,3,217,1,404.13,NULL,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(2281,8081,947,40720,296869,3,68,1,84.87,NULL,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(2282,8081,947,40720,296869,3,57,2,489.00,NULL,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(2283,8081,948,40720,296869,3,217,1,7936.12,NULL,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(2284,8081,948,40720,296869,3,68,1,1666.59,NULL,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(2285,8081,948,40720,296869,3,217,1,277.76,NULL,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(2286,8081,948,40720,296869,3,57,2,9880.47,NULL,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(2287,8081,949,40720,296869,3,217,1,495.87,NULL,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(2288,8081,949,40720,296869,3,68,1,104.13,NULL,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(2289,8081,949,40720,296869,3,57,2,600.00,NULL,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(2290,8081,950,40720,296869,3,217,1,932.24,NULL,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(2291,8081,950,40720,296869,3,68,1,195.76,NULL,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(2292,8081,950,40720,296869,3,57,2,1128.00,NULL,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(2293,8081,951,40720,296869,3,250,1,0.00,NULL,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(2294,8081,951,40720,296869,3,250,1,33753.28,NULL,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(2295,8081,951,40720,296869,3,57,2,33753.28,NULL,'2022-12-12 11:41:24','2022-12-12 11:41:24',NULL),(2296,8081,952,40720,296869,3,217,1,578.51,NULL,'2022-12-12 11:41:25','2022-12-12 11:41:25',NULL),(2297,8081,952,40720,296869,3,68,1,121.49,NULL,'2022-12-12 11:41:25','2022-12-12 11:41:25',NULL),(2298,8081,952,40720,296869,3,57,2,700.00,NULL,'2022-12-12 11:41:25','2022-12-12 11:41:25',NULL);
INSERT INTO `balance_libro_details` VALUES (2299,8081,953,40720,296869,3,250,1,2500.00,NULL,'2022-12-12 11:41:25','2022-12-12 11:41:25',NULL),(2300,8081,953,40720,296869,3,57,2,2500.00,NULL,'2022-12-12 11:41:25','2022-12-12 11:41:25',NULL),(2301,8081,954,40720,296869,3,217,1,4298.64,NULL,'2022-12-12 11:41:25','2022-12-12 11:41:25',NULL),(2302,8081,954,40720,296869,3,68,1,451.36,NULL,'2022-12-12 11:41:25','2022-12-12 11:41:25',NULL),(2303,8081,954,40720,296869,3,57,2,4750.00,NULL,'2022-12-12 11:41:25','2022-12-12 11:41:25',NULL),(2304,8081,955,40720,296869,3,250,1,3990.00,NULL,'2022-12-12 11:41:25','2022-12-12 11:41:25',NULL),(2305,8081,955,40720,296869,3,57,2,3990.00,NULL,'2022-12-12 11:41:25','2022-12-12 11:41:25',NULL),(2306,8081,956,40720,296870,3,250,2,0.00,NULL,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(2307,8081,956,40720,296870,3,250,2,697.11,NULL,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(2308,8081,956,40720,296870,3,57,1,697.11,NULL,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(2309,8081,957,40720,296870,3,217,1,1156.19,NULL,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(2310,8081,957,40720,296870,3,68,1,242.81,NULL,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(2311,8081,957,40720,296870,3,57,2,1399.00,NULL,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(2312,8081,958,40720,296870,3,217,1,7685.95,NULL,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(2313,8081,958,40720,296870,3,68,1,1614.05,NULL,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(2314,8081,958,40720,296870,3,57,2,9300.00,NULL,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(2315,8081,959,40720,296870,3,217,1,1213.55,NULL,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(2316,8081,959,40720,296870,3,68,1,254.85,NULL,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(2317,8081,959,40720,296870,3,217,1,42.48,NULL,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(2318,8081,959,40720,296870,3,57,2,1510.88,NULL,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(2319,8081,960,40720,296870,3,217,1,619.83,NULL,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(2320,8081,960,40720,296870,3,68,1,130.17,NULL,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(2321,8081,960,40720,296870,3,57,2,750.00,NULL,'2022-12-12 11:41:43','2022-12-12 11:41:43',NULL),(2322,8081,961,40720,296870,3,217,1,1829.74,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2323,8081,961,40720,296870,3,68,1,384.26,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2324,8081,961,40720,296870,3,57,2,2214.00,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2325,8081,962,40720,296870,3,217,1,2390.08,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2326,8081,962,40720,296870,3,68,1,501.92,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2327,8081,962,40720,296870,3,57,2,2892.00,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2328,8081,963,40720,296870,3,217,1,98.35,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2329,8081,963,40720,296870,3,68,1,20.65,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2330,8081,963,40720,296870,3,217,1,2.46,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2331,8081,963,40720,296870,3,57,2,121.46,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2332,8081,964,40720,296870,3,250,1,0.00,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2333,8081,964,40720,296870,3,250,1,35257.26,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2334,8081,964,40720,296870,3,57,2,35257.26,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2335,8081,965,40720,296870,3,217,1,3307.60,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2336,8081,965,40720,296870,3,68,1,694.60,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2337,8081,965,40720,296870,3,57,2,4002.20,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2338,8081,966,40720,296870,3,217,1,18008.76,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL);
INSERT INTO `balance_libro_details` VALUES (2339,8081,966,40720,296870,3,68,1,3781.84,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2340,8081,966,40720,296870,3,57,2,21790.60,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2341,8081,967,40720,296870,3,250,1,1000.00,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2342,8081,967,40720,296870,3,57,2,1000.00,NULL,'2022-12-12 11:41:44','2022-12-12 11:41:44',NULL),(2343,8081,968,40720,296871,3,250,2,0.00,NULL,'2022-12-12 11:42:02','2022-12-12 11:42:02',NULL),(2344,8081,968,40720,296871,3,250,2,697.11,NULL,'2022-12-12 11:42:02','2022-12-12 11:42:02',NULL),(2345,8081,968,40720,296871,3,57,1,697.11,NULL,'2022-12-12 11:42:02','2022-12-12 11:42:02',NULL),(2346,8081,969,40720,296871,3,217,1,4539.41,NULL,'2022-12-12 11:42:02','2022-12-12 11:42:02',NULL),(2347,8081,969,40720,296871,3,68,1,953.28,NULL,'2022-12-12 11:42:02','2022-12-12 11:42:02',NULL),(2348,8081,969,40720,296871,3,57,2,5492.68,NULL,'2022-12-12 11:42:02','2022-12-12 11:42:02',NULL),(2349,8081,969,40720,296871,3,136,2,0.01,NULL,'2022-12-12 11:42:02','2022-12-12 11:42:02',NULL),(2350,8081,970,40720,296871,3,217,1,1111.57,NULL,'2022-12-12 11:42:02','2022-12-12 11:42:02',NULL),(2351,8081,970,40720,296871,3,68,1,233.43,NULL,'2022-12-12 11:42:02','2022-12-12 11:42:02',NULL),(2352,8081,970,40720,296871,3,57,2,1345.00,NULL,'2022-12-12 11:42:02','2022-12-12 11:42:02',NULL),(2353,8081,971,40720,296871,3,217,1,2206.10,NULL,'2022-12-12 11:42:02','2022-12-12 11:42:02',NULL),(2354,8081,971,40720,296871,3,68,1,463.28,NULL,'2022-12-12 11:42:02','2022-12-12 11:42:02',NULL),(2355,8081,971,40720,296871,3,217,1,22.06,NULL,'2022-12-12 11:42:02','2022-12-12 11:42:02',NULL),(2356,8081,971,40720,296871,3,57,2,2691.44,NULL,'2022-12-12 11:42:02','2022-12-12 11:42:02',NULL),(2357,8081,972,40720,296871,3,217,1,619.83,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2358,8081,972,40720,296871,3,68,1,130.17,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2359,8081,972,40720,296871,3,57,2,750.00,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2360,8081,973,40720,296871,3,217,1,1157.04,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2361,8081,973,40720,296871,3,68,1,242.96,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2362,8081,973,40720,296871,3,57,2,1400.00,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2363,8081,974,40720,296871,3,250,1,0.00,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2364,8081,974,40720,296871,3,250,1,39727.56,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2365,8081,974,40720,296871,3,57,2,39727.56,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2366,8081,975,40720,296871,3,217,1,2191.71,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2367,8081,975,40720,296871,3,68,1,460.26,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2368,8081,975,40720,296871,3,217,1,0.03,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2369,8081,975,40720,296871,3,57,2,2652.00,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2370,8081,976,40720,296871,3,217,1,82.64,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2371,8081,976,40720,296871,3,68,1,17.36,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2372,8081,976,40720,296871,3,57,2,100.00,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2373,8081,977,40720,296871,3,217,1,165.29,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2374,8081,977,40720,296871,3,68,1,34.71,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2375,8081,977,40720,296871,3,57,2,200.00,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2376,8081,978,40720,296871,3,217,1,99.17,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2377,8081,978,40720,296871,3,68,1,20.83,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2378,8081,978,40720,296871,3,57,2,120.00,NULL,'2022-12-12 11:42:03','2022-12-12 11:42:03',NULL),(2379,8081,979,40720,296872,3,217,1,2461.16,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL);
INSERT INTO `balance_libro_details` VALUES (2380,8081,979,40720,296872,3,68,1,516.84,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2381,8081,979,40720,296872,3,57,2,2978.00,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2382,8081,980,40720,296872,3,250,2,0.00,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2383,8081,980,40720,296872,3,250,2,697.11,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2384,8081,980,40720,296872,3,57,1,697.11,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2385,8081,981,40720,296872,3,217,1,1257.01,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2386,8081,981,40720,296872,3,68,1,263.99,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2387,8081,981,40720,296872,3,57,2,1521.00,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2388,8081,982,40720,296872,3,217,1,619.83,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2389,8081,982,40720,296872,3,68,1,130.17,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2390,8081,982,40720,296872,3,57,2,750.00,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2391,8081,983,40720,296872,3,217,1,920.66,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2392,8081,983,40720,296872,3,68,1,193.34,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2393,8081,983,40720,296872,3,57,2,1114.00,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2394,8081,984,40720,296872,3,250,1,0.00,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2395,8081,984,40720,296872,3,250,1,39727.56,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2396,8081,984,40720,296872,3,57,2,39727.56,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2397,8081,985,40720,296872,3,217,1,82.64,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2398,8081,985,40720,296872,3,68,1,17.36,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2399,8081,985,40720,296872,3,57,2,100.00,NULL,'2022-12-12 11:42:22','2022-12-12 11:42:22',NULL),(2400,8081,986,40720,296872,3,217,1,1076.03,NULL,'2022-12-12 11:42:23','2022-12-12 11:42:23',NULL),(2401,8081,986,40720,296872,3,68,1,225.97,NULL,'2022-12-12 11:42:23','2022-12-12 11:42:23',NULL),(2402,8081,986,40720,296872,3,57,2,1302.00,NULL,'2022-12-12 11:42:23','2022-12-12 11:42:23',NULL),(2403,8081,987,40720,296872,3,217,1,3461.98,NULL,'2022-12-12 11:42:23','2022-12-12 11:42:23',NULL),(2404,8081,987,40720,296872,3,68,1,727.02,NULL,'2022-12-12 11:42:23','2022-12-12 11:42:23',NULL),(2405,8081,987,40720,296872,3,57,2,4189.00,NULL,'2022-12-12 11:42:23','2022-12-12 11:42:23',NULL),(2406,8081,988,40720,296873,3,217,1,909.08,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2407,8081,988,40720,296873,3,68,1,190.92,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2408,8081,988,40720,296873,3,57,2,1100.00,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2409,8081,989,40720,296873,3,250,2,0.00,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2410,8081,989,40720,296873,3,250,2,697.11,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2411,8081,989,40720,296873,3,57,1,697.11,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2412,8081,990,40720,296873,3,217,1,8388.43,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2413,8081,990,40720,296873,3,68,1,1761.57,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2414,8081,990,40720,296873,3,57,2,10150.00,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2415,8081,991,40720,296873,3,217,1,8991.74,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2416,8081,991,40720,296873,3,68,1,1888.26,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2417,8081,991,40720,296873,3,57,2,10880.00,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2418,8081,992,40720,296873,3,217,1,909.09,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2419,8081,992,40720,296873,3,68,1,190.91,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2420,8081,992,40720,296873,3,57,2,1100.00,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL);
INSERT INTO `balance_libro_details` VALUES (2421,8081,993,40720,296873,3,217,2,8388.43,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2422,8081,993,40720,296873,3,67,2,1761.57,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2423,8081,993,40720,296873,3,57,1,10150.00,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2424,8081,994,40720,296873,3,217,1,909.08,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2425,8081,994,40720,296873,3,68,1,190.92,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2426,8081,994,40720,296873,3,57,2,1100.00,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2427,8081,995,40720,296873,3,250,1,0.00,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2428,8081,995,40720,296873,3,250,1,44777.88,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2429,8081,995,40720,296873,3,57,2,44777.88,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2430,8081,996,40720,296873,3,217,1,861.16,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2431,8081,996,40720,296873,3,68,1,180.84,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2432,8081,996,40720,296873,3,57,2,1042.00,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2433,8081,997,40720,296873,3,217,2,8991.74,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2434,8081,997,40720,296873,3,67,2,1888.26,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2435,8081,997,40720,296873,3,57,1,10880.00,NULL,'2022-12-12 11:42:44','2022-12-12 11:42:44',NULL),(2436,8081,998,41120,295337,2,218,2,2600.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2437,8081,998,41120,295337,2,13,1,2600.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2438,8081,999,41120,295337,2,218,2,6300.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2439,8081,999,41120,295337,2,13,1,6300.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2440,8081,1000,41120,295337,2,218,2,4700.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2441,8081,1000,41120,295337,2,13,1,4700.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2442,8081,1001,41120,295337,2,218,2,7400.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2443,8081,1001,41120,295337,2,13,1,7400.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2444,8081,1002,41120,295337,2,218,2,3720.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2445,8081,1002,41120,295337,2,13,1,3720.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2446,8081,1003,41120,295337,2,218,2,8750.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2447,8081,1003,41120,295337,2,13,1,8750.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2448,8081,1004,41120,295337,2,218,2,1350.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2449,8081,1004,41120,295337,2,13,1,1350.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2450,8081,1005,41120,295337,2,218,2,1600.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2451,8081,1005,41120,295337,2,13,1,1600.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2452,8081,1006,41120,295337,2,218,2,1200.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2453,8081,1006,41120,295337,2,13,1,1200.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2454,8081,1007,41120,295337,2,218,2,350.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2455,8081,1007,41120,295337,2,13,1,350.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2456,8081,1008,41120,295337,2,218,2,2300.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2457,8081,1008,41120,295337,2,13,1,2300.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2458,8081,1009,41120,295337,2,218,2,2300.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2459,8081,1009,41120,295337,2,13,1,2300.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2460,8081,1010,41120,295337,2,218,2,5255.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL);
INSERT INTO `balance_libro_details` VALUES (2461,8081,1010,41120,295337,2,13,1,5255.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2462,8081,1011,41120,295337,2,218,2,1150.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2463,8081,1011,41120,295337,2,13,1,1150.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2464,8081,1012,41120,295337,2,218,2,1200.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2465,8081,1012,41120,295337,2,13,1,1200.00,NULL,'2022-12-12 12:08:56','2022-12-12 12:08:56',NULL),(2466,8081,1013,41120,295338,2,218,2,136100.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2467,8081,1013,41120,295338,2,13,1,136100.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2468,8081,1014,41120,295338,2,218,2,1800.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2469,8081,1014,41120,295338,2,13,1,1800.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2470,8081,1015,41120,295338,2,218,2,1100.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2471,8081,1015,41120,295338,2,13,1,1100.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2472,8081,1016,41120,295338,2,218,2,700.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2473,8081,1016,41120,295338,2,13,1,700.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2474,8081,1017,41120,295338,2,218,2,500.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2475,8081,1017,41120,295338,2,13,1,500.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2476,8081,1018,41120,295338,2,218,2,1100.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2477,8081,1018,41120,295338,2,13,1,1100.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2478,8081,1019,41120,295338,2,218,2,1050.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2479,8081,1019,41120,295338,2,13,1,1050.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2480,8081,1020,41120,295338,2,218,2,1550.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2481,8081,1020,41120,295338,2,13,1,1550.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2482,8081,1021,41120,295338,2,218,2,8800.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2483,8081,1021,41120,295338,2,13,1,8800.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2484,8081,1022,41120,295338,2,218,2,2250.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2485,8081,1022,41120,295338,2,13,1,2250.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2486,8081,1023,41120,295338,2,218,2,2100.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2487,8081,1023,41120,295338,2,13,1,2100.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2488,8081,1024,41120,295338,2,218,2,3800.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2489,8081,1024,41120,295338,2,13,1,3800.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2490,8081,1025,41120,295338,2,218,2,2550.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2491,8081,1025,41120,295338,2,13,1,2550.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2492,8081,1026,41120,295338,2,218,2,900.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2493,8081,1026,41120,295338,2,13,1,900.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2494,8081,1027,41120,295338,2,218,2,2050.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2495,8081,1027,41120,295338,2,13,1,2050.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2496,8081,1028,41120,295338,2,218,2,3500.00,NULL,'2022-12-12 12:09:14','2022-12-12 12:09:14',NULL),(2497,8081,1028,41120,295338,2,13,1,3500.00,NULL,'2022-12-12 12:09:15','2022-12-12 12:09:15',NULL),(2498,8081,1029,41120,295338,2,218,2,6800.00,NULL,'2022-12-12 12:09:15','2022-12-12 12:09:15',NULL),(2499,8081,1029,41120,295338,2,13,1,6800.00,NULL,'2022-12-12 12:09:15','2022-12-12 12:09:15',NULL),(2500,8081,1030,41120,295338,2,218,2,500.00,NULL,'2022-12-12 12:09:15','2022-12-12 12:09:15',NULL);
INSERT INTO `balance_libro_details` VALUES (2501,8081,1030,41120,295338,2,13,1,500.00,NULL,'2022-12-12 12:09:15','2022-12-12 12:09:15',NULL),(2502,8081,1031,41120,295339,2,218,2,132200.00,NULL,'2022-12-12 12:09:33','2022-12-12 12:09:33',NULL),(2503,8081,1031,41120,295339,2,13,1,132200.00,NULL,'2022-12-12 12:09:33','2022-12-12 12:09:33',NULL),(2504,8081,1032,41120,295339,2,218,2,500.00,NULL,'2022-12-12 12:09:33','2022-12-12 12:09:33',NULL),(2505,8081,1032,41120,295339,2,13,1,500.00,NULL,'2022-12-12 12:09:33','2022-12-12 12:09:33',NULL),(2506,8081,1033,41120,295339,2,218,2,3900.00,NULL,'2022-12-12 12:09:33','2022-12-12 12:09:33',NULL),(2507,8081,1033,41120,295339,2,13,1,3900.00,NULL,'2022-12-12 12:09:33','2022-12-12 12:09:33',NULL),(2508,8081,1034,41120,295339,2,218,2,14950.00,NULL,'2022-12-12 12:09:34','2022-12-12 12:09:34',NULL),(2509,8081,1034,41120,295339,2,13,1,14950.00,NULL,'2022-12-12 12:09:34','2022-12-12 12:09:34',NULL),(2510,8081,1035,41120,295339,2,218,2,2000.00,NULL,'2022-12-12 12:09:34','2022-12-12 12:09:34',NULL),(2511,8081,1035,41120,295339,2,13,1,2000.00,NULL,'2022-12-12 12:09:34','2022-12-12 12:09:34',NULL),(2512,8081,1036,41120,295339,2,218,2,1000.00,NULL,'2022-12-12 12:09:34','2022-12-12 12:09:34',NULL),(2513,8081,1036,41120,295339,2,13,1,1000.00,NULL,'2022-12-12 12:09:34','2022-12-12 12:09:34',NULL),(2514,8081,1037,41120,295339,2,218,2,1200.00,NULL,'2022-12-12 12:09:34','2022-12-12 12:09:34',NULL),(2515,8081,1037,41120,295339,2,13,1,1200.00,NULL,'2022-12-12 12:09:34','2022-12-12 12:09:34',NULL),(2516,8081,1038,41120,295339,2,218,2,500.00,NULL,'2022-12-12 12:09:34','2022-12-12 12:09:34',NULL),(2517,8081,1038,41120,295339,2,13,1,500.00,NULL,'2022-12-12 12:09:34','2022-12-12 12:09:34',NULL),(2518,8081,1039,41120,295340,2,218,2,600.00,NULL,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(2519,8081,1039,41120,295340,2,13,1,600.00,NULL,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(2520,8081,1040,41120,295340,2,218,2,2340.00,NULL,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(2521,8081,1040,41120,295340,2,13,1,2340.00,NULL,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(2522,8081,1041,41120,295340,2,218,2,260.00,NULL,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(2523,8081,1041,41120,295340,2,13,1,260.00,NULL,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(2524,8081,1042,41120,295340,2,218,2,35400.00,NULL,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(2525,8081,1042,41120,295340,2,13,1,35400.00,NULL,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(2526,8081,1043,41120,295340,2,218,2,10000.00,NULL,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(2527,8081,1043,41120,295340,2,13,1,10000.00,NULL,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(2528,8081,1044,41120,295340,2,218,2,2400.00,NULL,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(2529,8081,1044,41120,295340,2,13,1,2400.00,NULL,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(2530,8081,1045,41120,295340,2,218,2,800.00,NULL,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(2531,8081,1045,41120,295340,2,13,1,800.00,NULL,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(2532,8081,1046,41120,295340,2,218,2,8200.00,NULL,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(2533,8081,1046,41120,295340,2,13,1,8200.00,NULL,'2022-12-12 12:09:55','2022-12-12 12:09:55',NULL),(2534,8081,1047,41120,295340,2,218,2,8700.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2535,8081,1047,41120,295340,2,13,1,8700.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2536,8081,1048,41120,295340,2,218,2,2000.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2537,8081,1048,41120,295340,2,13,1,2000.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2538,8081,1049,41120,295340,2,218,2,1500.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2539,8081,1049,41120,295340,2,13,1,1500.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2540,8081,1050,41120,295340,2,218,2,7300.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL);
INSERT INTO `balance_libro_details` VALUES (2541,8081,1050,41120,295340,2,13,1,7300.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2542,8081,1051,41120,295340,2,218,2,400.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2543,8081,1051,41120,295340,2,13,1,400.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2544,8081,1052,41120,295340,2,218,2,2000.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2545,8081,1052,41120,295340,2,13,1,2000.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2546,8081,1053,41120,295340,2,218,2,2500.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2547,8081,1053,41120,295340,2,13,1,2500.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2548,8081,1054,41120,295340,2,218,2,2700.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2549,8081,1054,41120,295340,2,13,1,2700.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2550,8081,1055,41120,295340,2,218,2,1000.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2551,8081,1055,41120,295340,2,13,1,1000.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2552,8081,1056,41120,295340,2,218,2,1300.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2553,8081,1056,41120,295340,2,13,1,1300.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2554,8081,1057,41120,295340,2,218,2,1100.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2555,8081,1057,41120,295340,2,13,1,1100.00,NULL,'2022-12-12 12:09:56','2022-12-12 12:09:56',NULL),(2556,8081,1058,41120,295340,2,218,2,3800.00,NULL,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(2557,8081,1058,41120,295340,2,13,1,3800.00,NULL,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(2558,8081,1059,41120,295340,2,218,2,2700.00,NULL,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(2559,8081,1059,41120,295340,2,13,1,2700.00,NULL,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(2560,8081,1060,41120,295340,2,218,2,2400.00,NULL,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(2561,8081,1060,41120,295340,2,13,1,2400.00,NULL,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(2562,8081,1061,41120,295340,2,218,2,5900.00,NULL,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(2563,8081,1061,41120,295340,2,13,1,5900.00,NULL,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(2564,8081,1062,41120,295340,2,218,2,500.00,NULL,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(2565,8081,1062,41120,295340,2,13,1,500.00,NULL,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(2566,8081,1063,41120,295340,2,218,2,2400.00,NULL,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(2567,8081,1063,41120,295340,2,13,1,2400.00,NULL,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(2568,8081,1064,41120,295340,2,218,2,4000.00,NULL,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(2569,8081,1064,41120,295340,2,13,1,4000.00,NULL,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(2570,8081,1065,41120,295340,2,218,2,4600.00,NULL,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(2571,8081,1065,41120,295340,2,13,1,4600.00,NULL,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(2572,8081,1066,41120,295340,2,218,2,113690.00,NULL,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(2573,8081,1066,41120,295340,2,13,1,113690.00,NULL,'2022-12-12 12:09:57','2022-12-12 12:09:57',NULL),(2574,8081,1067,41120,295341,2,218,2,1850.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2575,8081,1067,41120,295341,2,13,1,1850.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2576,8081,1068,41120,295341,2,218,2,1000.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2577,8081,1068,41120,295341,2,13,1,1000.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2578,8081,1069,41120,295341,2,218,2,1000.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2579,8081,1069,41120,295341,2,13,1,1000.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2580,8081,1070,41120,295341,2,218,2,2200.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL);
INSERT INTO `balance_libro_details` VALUES (2581,8081,1070,41120,295341,2,13,1,2200.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2582,8081,1071,41120,295341,2,218,2,1150.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2583,8081,1071,41120,295341,2,13,1,1150.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2584,8081,1072,41120,295341,2,218,2,2400.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2585,8081,1072,41120,295341,2,13,1,2400.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2586,8081,1073,41120,295341,2,218,2,2000.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2587,8081,1073,41120,295341,2,13,1,2000.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2588,8081,1074,41120,295341,2,218,2,2400.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2589,8081,1074,41120,295341,2,13,1,2400.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2590,8081,1075,41120,295341,2,218,2,2200.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2591,8081,1075,41120,295341,2,13,1,2200.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2592,8081,1076,41120,295341,2,218,2,3400.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2593,8081,1076,41120,295341,2,13,1,3400.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2594,8081,1077,41120,295341,2,218,2,1800.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2595,8081,1077,41120,295341,2,13,1,1800.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2596,8081,1078,41120,295341,2,218,2,37800.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2597,8081,1078,41120,295341,2,13,1,37800.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2598,8081,1079,41120,295341,2,218,2,2400.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2599,8081,1079,41120,295341,2,13,1,2400.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2600,8081,1080,41120,295341,2,218,2,1400.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2601,8081,1080,41120,295341,2,13,1,1400.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2602,8081,1081,41120,295341,2,218,2,2600.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2603,8081,1081,41120,295341,2,13,1,2600.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2604,8081,1082,41120,295341,2,218,2,3000.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2605,8081,1082,41120,295341,2,13,1,3000.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2606,8081,1083,41120,295341,2,218,2,2700.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2607,8081,1083,41120,295341,2,13,1,2700.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2608,8081,1084,41120,295341,2,218,2,3300.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2609,8081,1084,41120,295341,2,13,1,3300.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2610,8081,1085,41120,295341,2,218,2,3600.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2611,8081,1085,41120,295341,2,13,1,3600.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2612,8081,1086,41120,295341,2,218,2,2300.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2613,8081,1086,41120,295341,2,13,1,2300.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2614,8081,1087,41120,295341,2,218,2,2350.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2615,8081,1087,41120,295341,2,13,1,2350.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2616,8081,1088,41120,295341,2,218,2,10900.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2617,8081,1088,41120,295341,2,13,1,10900.00,NULL,'2022-12-12 12:10:17','2022-12-12 12:10:17',NULL),(2618,8081,1089,41120,295341,2,218,2,100.00,NULL,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(2619,8081,1089,41120,295341,2,13,1,100.00,NULL,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(2620,8081,1090,41120,295341,2,218,2,2400.00,NULL,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL);
INSERT INTO `balance_libro_details` VALUES (2621,8081,1090,41120,295341,2,13,1,2400.00,NULL,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(2622,8081,1091,41120,295341,2,218,2,3300.00,NULL,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(2623,8081,1091,41120,295341,2,13,1,3300.00,NULL,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(2624,8081,1092,41120,295341,2,218,2,2800.00,NULL,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(2625,8081,1092,41120,295341,2,13,1,2800.00,NULL,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(2626,8081,1093,41120,295341,2,218,2,2600.00,NULL,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(2627,8081,1093,41120,295341,2,13,1,2600.00,NULL,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(2628,8081,1094,41120,295341,2,218,2,2100.00,NULL,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(2629,8081,1094,41120,295341,2,13,1,2100.00,NULL,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(2630,8081,1095,41120,295341,2,218,2,2550.00,NULL,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(2631,8081,1095,41120,295341,2,13,1,2550.00,NULL,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(2632,8081,1096,41120,295341,2,218,2,5500.00,NULL,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(2633,8081,1096,41120,295341,2,13,1,5500.00,NULL,'2022-12-12 12:10:18','2022-12-12 12:10:18',NULL),(2634,8081,1097,41120,295342,2,218,2,128800.00,NULL,'2022-12-12 12:10:36','2022-12-12 12:10:36',NULL),(2635,8081,1097,41120,295342,2,13,1,128800.00,NULL,'2022-12-12 12:10:36','2022-12-12 12:10:36',NULL),(2636,8081,1098,41120,295342,2,218,2,10100.00,NULL,'2022-12-12 12:10:36','2022-12-12 12:10:36',NULL),(2637,8081,1098,41120,295342,2,13,1,10100.00,NULL,'2022-12-12 12:10:36','2022-12-12 12:10:36',NULL),(2638,8081,1099,41120,295342,2,218,2,4300.00,NULL,'2022-12-12 12:10:36','2022-12-12 12:10:36',NULL),(2639,8081,1099,41120,295342,2,13,1,4300.00,NULL,'2022-12-12 12:10:36','2022-12-12 12:10:36',NULL),(2640,8081,1100,41120,295342,2,218,2,5400.00,NULL,'2022-12-12 12:10:36','2022-12-12 12:10:36',NULL),(2641,8081,1100,41120,295342,2,13,1,5400.00,NULL,'2022-12-12 12:10:36','2022-12-12 12:10:36',NULL),(2642,8081,1101,41120,295342,2,218,2,2500.00,NULL,'2022-12-12 12:10:36','2022-12-12 12:10:36',NULL),(2643,8081,1101,41120,295342,2,13,1,2500.00,NULL,'2022-12-12 12:10:36','2022-12-12 12:10:36',NULL),(2644,8081,1102,41120,295342,2,218,2,9800.00,NULL,'2022-12-12 12:10:36','2022-12-12 12:10:36',NULL),(2645,8081,1102,41120,295342,2,13,1,9800.00,NULL,'2022-12-12 12:10:36','2022-12-12 12:10:36',NULL),(2646,8081,1103,41120,295342,2,218,2,4720.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2647,8081,1103,41120,295342,2,13,1,4720.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2648,8081,1104,41120,295342,2,218,2,5200.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2649,8081,1104,41120,295342,2,13,1,5200.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2650,8081,1105,41120,295342,2,218,2,7300.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2651,8081,1105,41120,295342,2,13,1,7300.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2652,8081,1106,41120,295342,2,218,2,3200.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2653,8081,1106,41120,295342,2,13,1,3200.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2654,8081,1107,41120,295342,2,218,2,3800.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2655,8081,1107,41120,295342,2,13,1,3800.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2656,8081,1108,41120,295342,2,218,2,5400.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2657,8081,1108,41120,295342,2,13,1,5400.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2658,8081,1109,41120,295342,2,218,2,5800.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2659,8081,1109,41120,295342,2,13,1,5800.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2660,8081,1110,41120,295342,2,218,2,6600.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL);
INSERT INTO `balance_libro_details` VALUES (2661,8081,1110,41120,295342,2,13,1,6600.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2662,8081,1111,41120,295342,2,218,2,2800.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2663,8081,1111,41120,295342,2,13,1,2800.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2664,8081,1112,41120,295342,2,218,2,9500.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2665,8081,1112,41120,295342,2,13,1,9500.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2666,8081,1113,41120,295342,2,218,2,4800.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2667,8081,1113,41120,295342,2,13,1,4800.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2668,8081,1114,41120,295342,2,218,2,5600.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2669,8081,1114,41120,295342,2,13,1,5600.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2670,8081,1115,41120,295342,2,218,2,2400.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2671,8081,1115,41120,295342,2,13,1,2400.00,NULL,'2022-12-12 12:10:37','2022-12-12 12:10:37',NULL),(2672,8081,1116,41120,295343,2,218,2,2500.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2673,8081,1116,41120,295343,2,13,1,2500.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2674,8081,1117,41120,295343,2,218,2,1200.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2675,8081,1117,41120,295343,2,13,1,1200.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2676,8081,1118,41120,295343,2,218,2,3200.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2677,8081,1118,41120,295343,2,13,1,3200.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2678,8081,1119,41120,295343,2,218,2,4400.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2679,8081,1119,41120,295343,2,13,1,4400.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2680,8081,1120,41120,295343,2,218,2,5600.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2681,8081,1120,41120,295343,2,13,1,5600.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2682,8081,1121,41120,295343,2,218,2,4100.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2683,8081,1121,41120,295343,2,13,1,4100.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2684,8081,1122,41120,295343,2,218,2,3600.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2685,8081,1122,41120,295343,2,13,1,3600.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2686,8081,1123,41120,295343,2,218,2,5400.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2687,8081,1123,41120,295343,2,13,1,5400.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2688,8081,1124,41120,295343,2,218,2,4400.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2689,8081,1124,41120,295343,2,13,1,4400.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2690,8081,1125,41120,295343,2,218,2,1200.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2691,8081,1125,41120,295343,2,13,1,1200.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2692,8081,1126,41120,295343,2,218,2,4000.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2693,8081,1126,41120,295343,2,13,1,4000.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2694,8081,1127,41120,295343,2,218,2,3600.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2695,8081,1127,41120,295343,2,13,1,3600.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2696,8081,1128,41120,295343,2,218,2,3000.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2697,8081,1128,41120,295343,2,13,1,3000.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2698,8081,1129,41120,295343,2,218,2,2000.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2699,8081,1129,41120,295343,2,13,1,2000.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2700,8081,1130,41120,295343,2,218,2,1200.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL);
INSERT INTO `balance_libro_details` VALUES (2701,8081,1130,41120,295343,2,13,1,1200.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2702,8081,1131,41120,295343,2,218,2,3700.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2703,8081,1131,41120,295343,2,13,1,3700.00,NULL,'2022-12-12 12:11:30','2022-12-12 12:11:30',NULL),(2704,8081,1132,41120,295343,2,218,2,1200.00,NULL,'2022-12-12 12:11:31','2022-12-12 12:11:31',NULL),(2705,8081,1132,41120,295343,2,13,1,1200.00,NULL,'2022-12-12 12:11:31','2022-12-12 12:11:31',NULL),(2706,8081,1133,41120,295343,2,218,2,1900.00,NULL,'2022-12-12 12:11:31','2022-12-12 12:11:31',NULL),(2707,8081,1133,41120,295343,2,13,1,1900.00,NULL,'2022-12-12 12:11:31','2022-12-12 12:11:31',NULL),(2708,8081,1134,41120,295343,2,218,2,2400.00,NULL,'2022-12-12 12:11:31','2022-12-12 12:11:31',NULL),(2709,8081,1134,41120,295343,2,13,1,2400.00,NULL,'2022-12-12 12:11:31','2022-12-12 12:11:31',NULL),(2710,8081,1135,41120,295343,2,218,2,2400.00,NULL,'2022-12-12 12:11:31','2022-12-12 12:11:31',NULL),(2711,8081,1135,41120,295343,2,13,1,2400.00,NULL,'2022-12-12 12:11:31','2022-12-12 12:11:31',NULL),(2712,8081,1136,41120,295343,2,218,2,5000.00,NULL,'2022-12-12 12:11:31','2022-12-12 12:11:31',NULL),(2713,8081,1136,41120,295343,2,13,1,5000.00,NULL,'2022-12-12 12:11:31','2022-12-12 12:11:31',NULL),(2714,8081,1137,41120,295344,2,218,2,2000.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2715,8081,1137,41120,295344,2,13,1,2000.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2716,8081,1138,41120,295344,2,218,2,7800.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2717,8081,1138,41120,295344,2,13,1,7800.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2718,8081,1139,41120,295344,2,218,2,2500.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2719,8081,1139,41120,295344,2,13,1,2500.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2720,8081,1140,41120,295344,2,218,2,2000.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2721,8081,1140,41120,295344,2,13,1,2000.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2722,8081,1141,41120,295344,2,218,2,2400.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2723,8081,1141,41120,295344,2,13,1,2400.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2724,8081,1142,41120,295344,2,218,2,1300.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2725,8081,1142,41120,295344,2,13,1,1300.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2726,8081,1143,41120,295344,2,218,2,3500.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2727,8081,1143,41120,295344,2,13,1,3500.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2728,8081,1144,41120,295344,2,218,2,3500.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2729,8081,1144,41120,295344,2,13,1,3500.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2730,8081,1145,41120,295344,2,218,2,8000.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2731,8081,1145,41120,295344,2,13,1,8000.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2732,8081,1146,41120,295344,2,218,2,2900.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2733,8081,1146,41120,295344,2,13,1,2900.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2734,8081,1147,41120,295344,2,218,2,3000.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2735,8081,1147,41120,295344,2,13,1,3000.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2736,8081,1148,41120,295344,2,218,2,1300.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2737,8081,1148,41120,295344,2,13,1,1300.00,NULL,'2022-12-12 12:11:52','2022-12-12 12:11:52',NULL),(2738,8081,1149,41120,295344,2,218,2,1500.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2739,8081,1149,41120,295344,2,13,1,1500.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2740,8081,1150,41120,295344,2,218,2,4300.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL);
INSERT INTO `balance_libro_details` VALUES (2741,8081,1150,41120,295344,2,13,1,4300.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2742,8081,1151,41120,295344,2,218,2,1700.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2743,8081,1151,41120,295344,2,13,1,1700.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2744,8081,1152,41120,295344,2,218,2,2700.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2745,8081,1152,41120,295344,2,13,1,2700.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2746,8081,1153,41120,295344,2,218,2,7900.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2747,8081,1153,41120,295344,2,13,1,7900.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2748,8081,1154,41120,295344,2,218,2,8930.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2749,8081,1154,41120,295344,2,13,1,8930.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2750,8081,1155,41120,295344,2,218,2,7200.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2751,8081,1155,41120,295344,2,13,1,7200.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2752,8081,1156,41120,295344,2,218,2,3200.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2753,8081,1156,41120,295344,2,13,1,3200.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2754,8081,1157,41120,295344,2,218,2,3500.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2755,8081,1157,41120,295344,2,13,1,3500.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2756,8081,1158,41120,295344,2,218,2,3900.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2757,8081,1158,41120,295344,2,13,1,3900.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2758,8081,1159,41120,295344,2,218,2,5100.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2759,8081,1159,41120,295344,2,13,1,5100.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2760,8081,1160,41120,295344,2,218,2,1200.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2761,8081,1160,41120,295344,2,13,1,1200.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2762,8081,1161,41120,295344,2,218,2,2500.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2763,8081,1161,41120,295344,2,13,1,2500.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2764,8081,1162,41120,295344,2,218,2,118250.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2765,8081,1162,41120,295344,2,13,1,118250.00,NULL,'2022-12-12 12:11:53','2022-12-12 12:11:53',NULL),(2766,8081,1163,41120,295345,2,218,2,2000.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(2767,8081,1163,41120,295345,2,13,1,2000.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(2768,8081,1164,41120,295345,2,218,2,1900.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(2769,8081,1164,41120,295345,2,13,1,1900.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(2770,8081,1165,41120,295345,2,218,2,4400.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(2771,8081,1165,41120,295345,2,13,1,4400.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(2772,8081,1166,41120,295345,2,218,2,1400.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(2773,8081,1166,41120,295345,2,13,1,1400.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(2774,8081,1167,41120,295345,2,218,2,2150.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(2775,8081,1167,41120,295345,2,13,1,2150.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(2776,8081,1168,41120,295345,2,218,2,5150.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(2777,8081,1168,41120,295345,2,13,1,5150.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(2778,8081,1169,41120,295345,2,218,2,2700.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(2779,8081,1169,41120,295345,2,13,1,2700.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(2780,8081,1170,41120,295345,2,218,2,1800.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL);
INSERT INTO `balance_libro_details` VALUES (2781,8081,1170,41120,295345,2,13,1,1800.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(2782,8081,1171,41120,295345,2,218,2,145500.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(2783,8081,1171,41120,295345,2,13,1,145500.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(2784,8081,1172,41120,295345,2,218,2,72105.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(2785,8081,1172,41120,295345,2,13,1,72105.00,NULL,'2022-12-12 12:12:35','2022-12-12 12:12:35',NULL),(2786,8081,1173,41120,295335,3,217,1,41321.49,NULL,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(2787,8081,1173,41120,295335,3,68,1,8677.51,NULL,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(2788,8081,1173,41120,295335,3,57,2,49999.00,NULL,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(2789,8081,1174,41120,295335,3,217,1,26824.35,NULL,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(2790,8081,1174,41120,295335,3,68,1,5633.11,NULL,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(2791,8081,1174,41120,295335,3,217,1,2.68,NULL,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(2792,8081,1174,41120,295335,3,57,2,32460.14,NULL,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(2793,8081,1175,41120,295335,3,217,1,592.94,NULL,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(2794,8081,1175,41120,295335,3,68,1,124.52,NULL,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(2795,8081,1175,41120,295335,3,217,1,17.78,NULL,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(2796,8081,1175,41120,295335,3,57,2,735.24,NULL,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(2797,8081,1176,41120,295335,3,217,1,23429.01,NULL,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(2798,8081,1176,41120,295335,3,68,1,4920.09,NULL,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(2799,8081,1176,41120,295335,3,57,2,28349.10,NULL,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(2800,8081,1177,41120,295335,3,217,1,21600.00,NULL,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(2801,8081,1177,41120,295335,3,68,1,4536.00,NULL,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(2802,8081,1177,41120,295335,3,57,2,26136.00,NULL,'2022-12-12 12:15:25','2022-12-12 12:15:25',NULL),(2803,8081,1178,41120,295336,3,217,1,1612.68,NULL,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(2804,8081,1178,41120,295336,3,68,1,338.66,NULL,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(2805,8081,1178,41120,295336,3,217,1,48.39,NULL,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(2806,8081,1178,41120,295336,3,57,2,1999.73,NULL,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(2807,8081,1179,41120,295336,3,217,1,41321.49,NULL,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(2808,8081,1179,41120,295336,3,68,1,8677.51,NULL,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(2809,8081,1179,41120,295336,3,57,2,49999.00,NULL,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(2810,8081,1180,41120,295336,3,217,1,12925.00,NULL,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(2811,8081,1180,41120,295336,3,68,1,2714.25,NULL,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(2812,8081,1180,41120,295336,3,57,2,15639.25,NULL,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(2813,8081,1181,41120,295336,3,217,1,4195.20,NULL,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(2814,8081,1181,41120,295336,3,68,1,880.99,NULL,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(2815,8081,1181,41120,295336,3,57,2,5076.19,NULL,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(2816,8081,1182,41120,295336,3,217,1,4514.40,NULL,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(2817,8081,1182,41120,295336,3,68,1,948.02,NULL,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(2818,8081,1182,41120,295336,3,57,2,5462.42,NULL,'2022-12-12 12:15:44','2022-12-12 12:15:44',NULL),(2819,8081,1183,41120,295337,3,250,1,1260.00,NULL,'2022-12-12 12:16:10','2022-12-12 12:16:10',NULL),(2820,8081,1183,41120,295337,3,57,2,1260.00,NULL,'2022-12-12 12:16:10','2022-12-12 12:16:10',NULL);
INSERT INTO `balance_libro_details` VALUES (2821,8081,1184,41120,295337,3,217,1,795.09,NULL,'2022-12-12 12:16:10','2022-12-12 12:16:10',NULL),(2822,8081,1184,41120,295337,3,68,1,166.97,NULL,'2022-12-12 12:16:10','2022-12-12 12:16:10',NULL),(2823,8081,1184,41120,295337,3,217,1,23.86,NULL,'2022-12-12 12:16:10','2022-12-12 12:16:10',NULL),(2824,8081,1184,41120,295337,3,57,2,985.92,NULL,'2022-12-12 12:16:10','2022-12-12 12:16:10',NULL),(2825,8081,1185,41120,295337,3,217,1,58368.25,NULL,'2022-12-12 12:16:10','2022-12-12 12:16:10',NULL),(2826,8081,1185,41120,295337,3,68,1,12257.33,NULL,'2022-12-12 12:16:10','2022-12-12 12:16:10',NULL),(2827,8081,1185,41120,295337,3,57,2,70625.58,NULL,'2022-12-12 12:16:10','2022-12-12 12:16:10',NULL),(2828,8081,1186,41120,295337,3,250,1,5500.00,NULL,'2022-12-12 12:16:10','2022-12-12 12:16:10',NULL),(2829,8081,1186,41120,295337,3,57,2,5500.00,NULL,'2022-12-12 12:16:10','2022-12-12 12:16:10',NULL),(2830,8081,1187,41120,295338,3,250,1,300.00,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2831,8081,1187,41120,295338,3,57,2,300.00,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2832,8081,1188,41120,295338,3,217,1,19866.88,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2833,8081,1188,41120,295338,3,68,1,4172.04,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2834,8081,1188,41120,295338,3,217,1,496.67,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2835,8081,1188,41120,295338,3,57,2,24535.59,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2836,8081,1189,41120,295338,3,217,1,14075.00,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2837,8081,1189,41120,295338,3,68,1,2955.75,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2838,8081,1189,41120,295338,3,217,1,351.88,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2839,8081,1189,41120,295338,3,57,2,17382.63,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2840,8081,1190,41120,295338,3,250,1,8400.00,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2841,8081,1190,41120,295338,3,57,2,8400.00,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2842,8081,1191,41120,295338,3,217,1,29742.15,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2843,8081,1191,41120,295338,3,68,1,6245.85,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2844,8081,1191,41120,295338,3,57,2,35988.00,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2845,8081,1192,41120,295338,3,217,1,651.47,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2846,8081,1192,41120,295338,3,68,1,136.81,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2847,8081,1192,41120,295338,3,217,1,35.83,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2848,8081,1192,41120,295338,3,57,2,824.11,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2849,8081,1193,41120,295338,3,217,1,23760.00,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2850,8081,1193,41120,295338,3,68,1,4989.60,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2851,8081,1193,41120,295338,3,57,2,28749.60,NULL,'2022-12-12 12:16:31','2022-12-12 12:16:31',NULL),(2852,8081,1194,41120,295339,3,217,1,32461.23,NULL,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL),(2853,8081,1194,41120,295339,3,68,1,6816.86,NULL,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL),(2854,8081,1194,41120,295339,3,217,1,811.53,NULL,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL),(2855,8081,1194,41120,295339,3,57,2,40089.62,NULL,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL),(2856,8081,1195,41120,295339,3,217,1,1664.75,NULL,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL),(2857,8081,1195,41120,295339,3,68,1,349.60,NULL,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL),(2858,8081,1195,41120,295339,3,217,1,91.56,NULL,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL),(2859,8081,1195,41120,295339,3,57,2,2105.91,NULL,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL),(2860,8081,1196,41120,295339,3,217,1,32730.48,NULL,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL);
INSERT INTO `balance_libro_details` VALUES (2861,8081,1196,41120,295339,3,68,1,6873.40,NULL,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL),(2862,8081,1196,41120,295339,3,217,1,818.26,NULL,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL),(2863,8081,1196,41120,295339,3,57,2,40422.14,NULL,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL),(2864,8081,1197,41120,295339,3,217,2,32461.23,NULL,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL),(2865,8081,1197,41120,295339,3,67,2,6816.86,NULL,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL),(2866,8081,1197,41120,295339,3,217,2,811.53,NULL,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL),(2867,8081,1197,41120,295339,3,57,1,40089.62,NULL,'2022-12-12 12:16:53','2022-12-12 12:16:53',NULL),(2868,8081,1198,41120,295340,3,217,1,1011.54,NULL,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL),(2869,8081,1198,41120,295340,3,68,1,212.42,NULL,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL),(2870,8081,1198,41120,295340,3,217,1,55.64,NULL,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL),(2871,8081,1198,41120,295340,3,57,2,1279.60,NULL,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL),(2872,8081,1199,41120,295340,3,217,1,20375.80,NULL,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL),(2873,8081,1199,41120,295340,3,68,1,4278.92,NULL,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL),(2874,8081,1199,41120,295340,3,217,1,509.40,NULL,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL),(2875,8081,1199,41120,295340,3,57,2,25164.12,NULL,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL),(2876,8081,1200,41120,295340,3,217,2,4540.80,NULL,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL),(2877,8081,1200,41120,295340,3,67,2,953.57,NULL,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL),(2878,8081,1200,41120,295340,3,217,2,113.52,NULL,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL),(2879,8081,1200,41120,295340,3,57,1,5607.89,NULL,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL),(2880,8081,1201,41120,295340,3,217,1,15835.00,NULL,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL),(2881,8081,1201,41120,295340,3,68,1,3325.35,NULL,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL),(2882,8081,1201,41120,295340,3,217,1,395.88,NULL,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL),(2883,8081,1201,41120,295340,3,57,2,19556.23,NULL,'2022-12-12 12:17:11','2022-12-12 12:17:11',NULL),(2884,8081,1202,41120,295341,3,217,1,24459.60,NULL,'2022-12-12 12:17:35','2022-12-12 12:17:35',NULL),(2885,8081,1202,41120,295341,3,68,1,5136.52,NULL,'2022-12-12 12:17:35','2022-12-12 12:17:35',NULL),(2886,8081,1202,41120,295341,3,57,2,29596.12,NULL,'2022-12-12 12:17:35','2022-12-12 12:17:35',NULL),(2887,8081,1203,41120,295341,3,217,1,1415.81,NULL,'2022-12-12 12:17:35','2022-12-12 12:17:35',NULL),(2888,8081,1203,41120,295341,3,68,1,297.32,NULL,'2022-12-12 12:17:35','2022-12-12 12:17:35',NULL),(2889,8081,1203,41120,295341,3,217,1,42.47,NULL,'2022-12-12 12:17:35','2022-12-12 12:17:35',NULL),(2890,8081,1203,41120,295341,3,57,2,1755.60,NULL,'2022-12-12 12:17:35','2022-12-12 12:17:35',NULL),(2891,8081,1204,41120,295341,3,217,1,32635.00,NULL,'2022-12-12 12:17:35','2022-12-12 12:17:35',NULL),(2892,8081,1204,41120,295341,3,68,1,6853.35,NULL,'2022-12-12 12:17:35','2022-12-12 12:17:35',NULL),(2893,8081,1204,41120,295341,3,57,2,39488.35,NULL,'2022-12-12 12:17:35','2022-12-12 12:17:35',NULL),(2894,8081,1205,41120,295341,3,250,1,6800.00,NULL,'2022-12-12 12:17:35','2022-12-12 12:17:35',NULL),(2895,8081,1205,41120,295341,3,57,2,6800.00,NULL,'2022-12-12 12:17:35','2022-12-12 12:17:35',NULL),(2896,8081,1206,41120,295342,3,217,1,1122.63,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(2897,8081,1206,41120,295342,3,68,1,235.75,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(2898,8081,1206,41120,295342,3,217,1,61.75,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(2899,8081,1206,41120,295342,3,57,2,1420.13,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(2900,8081,1207,41120,295342,3,217,1,18637.50,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL);
INSERT INTO `balance_libro_details` VALUES (2901,8081,1207,41120,295342,3,68,1,3913.88,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(2902,8081,1207,41120,295342,3,217,1,465.94,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(2903,8081,1207,41120,295342,3,57,2,23017.32,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(2904,8081,1208,41120,295342,3,217,1,11207.63,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(2905,8081,1208,41120,295342,3,68,1,2353.60,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(2906,8081,1208,41120,295342,3,217,1,280.19,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(2907,8081,1208,41120,295342,3,57,2,13841.42,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(2908,8081,1209,41120,295342,3,217,2,11207.63,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(2909,8081,1209,41120,295342,3,67,2,2353.60,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(2910,8081,1209,41120,295342,3,217,2,280.19,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(2911,8081,1209,41120,295342,3,57,1,13841.42,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(2912,8081,1210,41120,295342,3,217,1,20292.75,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(2913,8081,1210,41120,295342,3,68,1,4261.48,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(2914,8081,1210,41120,295342,3,217,1,507.32,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(2915,8081,1210,41120,295342,3,57,2,25061.55,NULL,'2022-12-12 12:17:55','2022-12-12 12:17:55',NULL),(2916,8081,1211,41120,295343,3,217,1,1225.82,NULL,'2022-12-12 12:19:08','2022-12-12 12:19:08',NULL),(2917,8081,1211,41120,295343,3,68,1,257.42,NULL,'2022-12-12 12:19:08','2022-12-12 12:19:08',NULL),(2918,8081,1211,41120,295343,3,217,1,36.77,NULL,'2022-12-12 12:19:08','2022-12-12 12:19:08',NULL),(2919,8081,1211,41120,295343,3,57,2,1520.01,NULL,'2022-12-12 12:19:08','2022-12-12 12:19:08',NULL),(2920,8081,1212,41120,295343,3,217,1,26038.16,NULL,'2022-12-12 12:19:08','2022-12-12 12:19:08',NULL),(2921,8081,1212,41120,295343,3,68,1,5468.01,NULL,'2022-12-12 12:19:08','2022-12-12 12:19:08',NULL),(2922,8081,1212,41120,295343,3,57,2,31506.17,NULL,'2022-12-12 12:19:08','2022-12-12 12:19:08',NULL),(2923,8081,1213,41120,295343,3,217,1,35329.83,NULL,'2022-12-12 12:19:08','2022-12-12 12:19:08',NULL),(2924,8081,1213,41120,295343,3,68,1,7419.26,NULL,'2022-12-12 12:19:08','2022-12-12 12:19:08',NULL),(2925,8081,1213,41120,295343,3,57,2,42749.09,NULL,'2022-12-12 12:19:08','2022-12-12 12:19:08',NULL),(2926,8081,1214,41120,295343,3,217,1,37550.00,NULL,'2022-12-12 12:19:08','2022-12-12 12:19:08',NULL),(2927,8081,1214,41120,295343,3,68,1,7885.50,NULL,'2022-12-12 12:19:08','2022-12-12 12:19:08',NULL),(2928,8081,1214,41120,295343,3,57,2,45435.50,NULL,'2022-12-12 12:19:08','2022-12-12 12:19:08',NULL),(2929,8081,1215,41120,295344,3,217,1,687.55,NULL,'2022-12-12 12:19:40','2022-12-12 12:19:40',NULL),(2930,8081,1215,41120,295344,3,68,1,144.39,NULL,'2022-12-12 12:19:40','2022-12-12 12:19:40',NULL),(2931,8081,1215,41120,295344,3,217,1,37.82,NULL,'2022-12-12 12:19:40','2022-12-12 12:19:40',NULL),(2932,8081,1215,41120,295344,3,57,2,869.76,NULL,'2022-12-12 12:19:40','2022-12-12 12:19:40',NULL),(2933,8081,1216,41120,295344,3,217,1,76407.45,NULL,'2022-12-12 12:19:40','2022-12-12 12:19:40',NULL),(2934,8081,1216,41120,295344,3,68,1,16045.56,NULL,'2022-12-12 12:19:40','2022-12-12 12:19:40',NULL),(2935,8081,1216,41120,295344,3,57,2,92453.01,NULL,'2022-12-12 12:19:40','2022-12-12 12:19:40',NULL),(2936,8081,1217,41120,295344,3,217,1,20400.00,NULL,'2022-12-12 12:19:40','2022-12-12 12:19:40',NULL),(2937,8081,1217,41120,295344,3,68,1,4284.00,NULL,'2022-12-12 12:19:40','2022-12-12 12:19:40',NULL),(2938,8081,1217,41120,295344,3,57,2,24684.00,NULL,'2022-12-12 12:19:40','2022-12-12 12:19:40',NULL),(2939,8081,1218,41120,295345,3,217,1,796.64,NULL,'2022-12-12 12:19:58','2022-12-12 12:19:58',NULL),(2940,8081,1218,41120,295345,3,68,1,167.29,NULL,'2022-12-12 12:19:58','2022-12-12 12:19:58',NULL);
INSERT INTO `balance_libro_details` VALUES (2941,8081,1218,41120,295345,3,217,1,23.90,NULL,'2022-12-12 12:19:58','2022-12-12 12:19:58',NULL),(2942,8081,1218,41120,295345,3,57,2,987.83,NULL,'2022-12-12 12:19:58','2022-12-12 12:19:58',NULL),(2943,8081,1219,41120,295345,3,217,1,46850.00,NULL,'2022-12-12 12:19:58','2022-12-12 12:19:58',NULL),(2944,8081,1219,41120,295345,3,68,1,9838.50,NULL,'2022-12-12 12:19:58','2022-12-12 12:19:58',NULL),(2945,8081,1219,41120,295345,3,57,2,56688.50,NULL,'2022-12-12 12:19:58','2022-12-12 12:19:58',NULL),(2946,8081,1220,41120,295345,3,217,1,6767.84,NULL,'2022-12-12 12:19:58','2022-12-12 12:19:58',NULL),(2947,8081,1220,41120,295345,3,68,1,1421.25,NULL,'2022-12-12 12:19:58','2022-12-12 12:19:58',NULL),(2948,8081,1220,41120,295345,3,57,2,8189.09,NULL,'2022-12-12 12:19:58','2022-12-12 12:19:58',NULL),(2949,8081,1221,41120,295345,3,217,1,12910.41,NULL,'2022-12-12 12:19:58','2022-12-12 12:19:58',NULL),(2950,8081,1221,41120,295345,3,68,1,2711.19,NULL,'2022-12-12 12:19:58','2022-12-12 12:19:58',NULL),(2951,8081,1221,41120,295345,3,57,2,15621.60,NULL,'2022-12-12 12:19:58','2022-12-12 12:19:58',NULL),(2952,8081,1222,41123,296880,2,218,2,17500.00,NULL,'2022-12-12 12:24:33','2022-12-12 12:24:33',NULL),(2953,8081,1222,41123,296880,2,13,1,17500.00,NULL,'2022-12-12 12:24:33','2022-12-12 12:24:33',NULL),(2954,8081,1223,41123,296881,2,218,2,10050.00,NULL,'2022-12-12 12:24:53','2022-12-12 12:24:53',NULL),(2955,8081,1223,41123,296881,2,13,1,10050.00,NULL,'2022-12-12 12:24:53','2022-12-12 12:24:53',NULL),(2956,8081,1224,41123,296881,2,218,2,2900.00,NULL,'2022-12-12 12:24:53','2022-12-12 12:24:53',NULL),(2957,8081,1224,41123,296881,2,13,1,2900.00,NULL,'2022-12-12 12:24:53','2022-12-12 12:24:53',NULL),(2958,8081,1225,41123,296881,2,218,2,21450.00,NULL,'2022-12-12 12:24:53','2022-12-12 12:24:53',NULL),(2959,8081,1225,41123,296881,2,13,1,21450.00,NULL,'2022-12-12 12:24:53','2022-12-12 12:24:53',NULL),(2960,8081,1226,41123,296882,2,218,2,62920.00,NULL,'2022-12-12 12:25:20','2022-12-12 12:25:20',NULL),(2961,8081,1226,41123,296882,2,13,1,62920.00,NULL,'2022-12-12 12:25:20','2022-12-12 12:25:20',NULL),(2962,8081,1227,41123,296882,2,218,2,2050.00,NULL,'2022-12-12 12:25:20','2022-12-12 12:25:20',NULL),(2963,8081,1227,41123,296882,2,13,1,2050.00,NULL,'2022-12-12 12:25:20','2022-12-12 12:25:20',NULL),(2964,8081,1228,41123,296882,2,218,2,22850.00,NULL,'2022-12-12 12:25:20','2022-12-12 12:25:20',NULL),(2965,8081,1228,41123,296882,2,13,1,22850.00,NULL,'2022-12-12 12:25:20','2022-12-12 12:25:20',NULL),(2966,8081,1229,41123,296883,2,218,2,62920.00,NULL,'2022-12-12 12:25:38','2022-12-12 12:25:38',NULL),(2967,8081,1229,41123,296883,2,13,1,62920.00,NULL,'2022-12-12 12:25:38','2022-12-12 12:25:38',NULL),(2968,8081,1230,41123,296884,2,218,2,45900.00,NULL,'2022-12-12 12:25:54','2022-12-12 12:25:54',NULL),(2969,8081,1230,41123,296884,2,13,1,45900.00,NULL,'2022-12-12 12:25:54','2022-12-12 12:25:54',NULL),(2970,8081,1231,41123,296884,2,218,2,62920.00,NULL,'2022-12-12 12:25:54','2022-12-12 12:25:54',NULL),(2971,8081,1231,41123,296884,2,13,1,62920.00,NULL,'2022-12-12 12:25:54','2022-12-12 12:25:54',NULL),(2972,8081,1232,41123,296885,2,218,2,45900.00,NULL,'2022-12-12 12:26:18','2022-12-12 12:26:18',NULL),(2973,8081,1232,41123,296885,2,13,1,45900.00,NULL,'2022-12-12 12:26:18','2022-12-12 12:26:18',NULL),(2974,8081,1233,41123,296885,2,218,2,62920.00,NULL,'2022-12-12 12:26:18','2022-12-12 12:26:18',NULL),(2975,8081,1233,41123,296885,2,13,1,62920.00,NULL,'2022-12-12 12:26:18','2022-12-12 12:26:18',NULL),(2976,8081,1234,41123,296886,2,218,2,45900.00,NULL,'2022-12-12 12:26:42','2022-12-12 12:26:42',NULL),(2977,8081,1234,41123,296886,2,13,1,45900.00,NULL,'2022-12-12 12:26:42','2022-12-12 12:26:42',NULL),(2978,8081,1235,41123,296886,2,218,2,62920.00,NULL,'2022-12-12 12:26:42','2022-12-12 12:26:42',NULL),(2979,8081,1235,41123,296886,2,13,1,62920.00,NULL,'2022-12-12 12:26:42','2022-12-12 12:26:42',NULL),(2980,8081,1236,41123,296886,2,218,2,6380.00,NULL,'2022-12-12 12:26:42','2022-12-12 12:26:42',NULL);
INSERT INTO `balance_libro_details` VALUES (2981,8081,1236,41123,296886,2,13,1,6380.00,NULL,'2022-12-12 12:26:42','2022-12-12 12:26:42',NULL),(2982,8081,1237,41123,296886,2,218,2,7100.00,NULL,'2022-12-12 12:26:42','2022-12-12 12:26:42',NULL),(2983,8081,1237,41123,296886,2,13,1,7100.00,NULL,'2022-12-12 12:26:42','2022-12-12 12:26:42',NULL),(2984,8081,1238,41123,296886,2,218,2,7100.00,NULL,'2022-12-12 12:26:42','2022-12-12 12:26:42',NULL),(2985,8081,1238,41123,296886,2,13,1,7100.00,NULL,'2022-12-12 12:26:42','2022-12-12 12:26:42',NULL),(2986,8081,1239,41123,296887,2,218,2,78650.00,NULL,'2022-12-12 12:26:58','2022-12-12 12:26:58',NULL),(2987,8081,1239,41123,296887,2,13,1,78650.00,NULL,'2022-12-12 12:26:58','2022-12-12 12:26:58',NULL),(2988,8081,1240,41123,296887,2,218,2,57400.00,NULL,'2022-12-12 12:26:58','2022-12-12 12:26:58',NULL),(2989,8081,1240,41123,296887,2,13,1,57400.00,NULL,'2022-12-12 12:26:58','2022-12-12 12:26:58',NULL),(2990,8081,1241,41123,296888,2,218,2,57400.00,NULL,'2022-12-12 12:27:17','2022-12-12 12:27:17',NULL),(2991,8081,1241,41123,296888,2,13,1,57400.00,NULL,'2022-12-12 12:27:17','2022-12-12 12:27:17',NULL),(2992,8081,1242,41123,296888,2,218,2,78650.00,NULL,'2022-12-12 12:27:17','2022-12-12 12:27:17',NULL),(2993,8081,1242,41123,296888,2,13,1,78650.00,NULL,'2022-12-12 12:27:17','2022-12-12 12:27:17',NULL),(2994,8081,1243,41123,296889,2,218,2,39400.00,NULL,'2022-12-12 12:27:38','2022-12-12 12:27:38',NULL),(2995,8081,1243,41123,296889,2,13,1,39400.00,NULL,'2022-12-12 12:27:38','2022-12-12 12:27:38',NULL),(2996,8081,1244,41123,296889,2,218,2,57400.00,NULL,'2022-12-12 12:27:38','2022-12-12 12:27:38',NULL),(2997,8081,1244,41123,296889,2,13,1,57400.00,NULL,'2022-12-12 12:27:38','2022-12-12 12:27:38',NULL),(2998,8081,1245,41123,296890,2,218,2,78650.00,NULL,'2022-12-12 12:27:59','2022-12-12 12:27:59',NULL),(2999,8081,1245,41123,296890,2,13,1,78650.00,NULL,'2022-12-12 12:27:59','2022-12-12 12:27:59',NULL),(3000,8081,1246,41123,296890,2,218,2,57400.00,NULL,'2022-12-12 12:27:59','2022-12-12 12:27:59',NULL),(3001,8081,1246,41123,296890,2,13,1,57400.00,NULL,'2022-12-12 12:27:59','2022-12-12 12:27:59',NULL),(3002,8081,1247,41123,296880,3,217,1,8362.00,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3003,8081,1247,41123,296880,3,68,1,878.01,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3004,8081,1247,41123,296880,3,57,2,9240.01,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3005,8081,1248,41123,296880,3,217,1,79.88,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3006,8081,1248,41123,296880,3,68,1,16.77,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3007,8081,1248,41123,296880,3,217,1,7.98,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3008,8081,1248,41123,296880,3,57,2,104.63,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3009,8081,1249,41123,296880,3,217,1,826.86,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3010,8081,1249,41123,296880,3,68,1,173.64,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3011,8081,1249,41123,296880,3,57,2,1000.50,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3012,8081,1250,41123,296880,3,217,1,3342.56,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3013,8081,1250,41123,296880,3,68,1,701.94,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3014,8081,1250,41123,296880,3,217,1,312.00,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3015,8081,1250,41123,296880,3,57,2,4356.50,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3016,8081,1251,41123,296880,3,217,1,2546.37,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3017,8081,1251,41123,296880,3,68,1,531.43,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3018,8081,1251,41123,296880,3,57,2,3077.80,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3019,8081,1252,41123,296880,3,217,1,40.74,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3020,8081,1252,41123,296880,3,68,1,8.56,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL);
INSERT INTO `balance_libro_details` VALUES (3021,8081,1252,41123,296880,3,57,2,49.30,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3022,8081,1253,41123,296880,3,217,1,79.88,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3023,8081,1253,41123,296880,3,68,1,16.77,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3024,8081,1253,41123,296880,3,217,1,7.97,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3025,8081,1253,41123,296880,3,57,2,104.62,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3026,8081,1254,41123,296880,3,217,1,81.48,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3027,8081,1254,41123,296880,3,68,1,17.12,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3028,8081,1254,41123,296880,3,57,2,98.60,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3029,8081,1255,41123,296880,3,217,1,249.84,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3030,8081,1255,41123,296880,3,68,1,52.46,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3031,8081,1255,41123,296880,3,57,2,302.30,NULL,'2022-12-12 12:28:49','2022-12-12 12:28:49',NULL),(3032,8081,1256,41123,296881,3,217,1,8362.00,NULL,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(3033,8081,1256,41123,296881,3,68,1,878.01,NULL,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(3034,8081,1256,41123,296881,3,57,2,9240.01,NULL,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(3035,8081,1257,41123,296881,3,217,1,67.56,NULL,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(3036,8081,1257,41123,296881,3,68,1,14.19,NULL,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(3037,8081,1257,41123,296881,3,217,1,6.75,NULL,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(3038,8081,1257,41123,296881,3,57,2,88.50,NULL,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(3039,8081,1258,41123,296881,3,217,1,23.72,NULL,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(3040,8081,1258,41123,296881,3,68,1,4.98,NULL,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(3041,8081,1258,41123,296881,3,57,2,28.70,NULL,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(3042,8081,1259,41123,296881,3,217,1,608.36,NULL,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(3043,8081,1259,41123,296881,3,68,1,127.76,NULL,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(3044,8081,1259,41123,296881,3,57,2,736.12,NULL,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(3045,8081,1260,41123,296881,3,217,1,53.72,NULL,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(3046,8081,1260,41123,296881,3,68,1,11.28,NULL,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(3047,8081,1260,41123,296881,3,57,2,65.00,NULL,'2022-12-12 12:29:08','2022-12-12 12:29:08',NULL),(3048,8081,1261,41123,296881,3,217,1,164.12,NULL,'2022-12-12 12:29:09','2022-12-12 12:29:09',NULL),(3049,8081,1261,41123,296881,3,68,1,34.47,NULL,'2022-12-12 12:29:09','2022-12-12 12:29:09',NULL),(3050,8081,1261,41123,296881,3,217,1,16.41,NULL,'2022-12-12 12:29:09','2022-12-12 12:29:09',NULL),(3051,8081,1261,41123,296881,3,57,2,215.00,NULL,'2022-12-12 12:29:09','2022-12-12 12:29:09',NULL),(3052,8081,1262,41123,296881,3,217,1,145.90,NULL,'2022-12-12 12:29:09','2022-12-12 12:29:09',NULL),(3053,8081,1262,41123,296881,3,68,1,30.65,NULL,'2022-12-12 12:29:09','2022-12-12 12:29:09',NULL),(3054,8081,1262,41123,296881,3,57,2,176.55,NULL,'2022-12-12 12:29:09','2022-12-12 12:29:09',NULL),(3055,8081,1263,41123,296881,3,217,1,479.13,NULL,'2022-12-12 12:29:09','2022-12-12 12:29:09',NULL),(3056,8081,1263,41123,296881,3,68,1,100.62,NULL,'2022-12-12 12:29:09','2022-12-12 12:29:09',NULL),(3057,8081,1263,41123,296881,3,57,2,579.75,NULL,'2022-12-12 12:29:09','2022-12-12 12:29:09',NULL),(3058,8081,1264,41123,296881,3,217,1,4821.54,NULL,'2022-12-12 12:29:09','2022-12-12 12:29:09',NULL),(3059,8081,1264,41123,296881,3,68,1,1012.52,NULL,'2022-12-12 12:29:09','2022-12-12 12:29:09',NULL),(3060,8081,1264,41123,296881,3,57,2,5834.06,NULL,'2022-12-12 12:29:09','2022-12-12 12:29:09',NULL);
INSERT INTO `balance_libro_details` VALUES (3061,8081,1265,41123,296882,3,217,1,8362.00,NULL,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(3062,8081,1265,41123,296882,3,68,1,878.01,NULL,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(3063,8081,1265,41123,296882,3,57,2,9240.01,NULL,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(3064,8081,1266,41123,296882,3,217,1,112.40,NULL,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(3065,8081,1266,41123,296882,3,68,1,23.60,NULL,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(3066,8081,1266,41123,296882,3,57,2,136.00,NULL,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(3067,8081,1267,41123,296882,3,217,1,104.96,NULL,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(3068,8081,1267,41123,296882,3,68,1,22.04,NULL,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(3069,8081,1267,41123,296882,3,57,2,127.00,NULL,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(3070,8081,1268,41123,296882,3,217,1,299.18,NULL,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(3071,8081,1268,41123,296882,3,68,1,62.82,NULL,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(3072,8081,1268,41123,296882,3,217,1,29.91,NULL,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(3073,8081,1268,41123,296882,3,57,2,391.91,NULL,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(3074,8081,1269,41123,296882,3,217,1,104.96,NULL,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(3075,8081,1269,41123,296882,3,68,1,22.04,NULL,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(3076,8081,1269,41123,296882,3,57,2,127.00,NULL,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(3077,8081,1270,41123,296882,3,217,1,409.09,NULL,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(3078,8081,1270,41123,296882,3,68,1,85.91,NULL,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(3079,8081,1270,41123,296882,3,57,2,495.00,NULL,'2022-12-12 12:29:30','2022-12-12 12:29:30',NULL),(3080,8081,1271,41123,296883,3,217,1,164.12,NULL,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL),(3081,8081,1271,41123,296883,3,68,1,34.47,NULL,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL),(3082,8081,1271,41123,296883,3,217,1,16.41,NULL,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL),(3083,8081,1271,41123,296883,3,57,2,215.00,NULL,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL),(3084,8081,1272,41123,296883,3,250,1,3800.68,NULL,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL),(3085,8081,1272,41123,296883,3,57,2,3800.68,NULL,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL),(3086,8081,1273,41123,296883,3,217,1,189.26,NULL,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL),(3087,8081,1273,41123,296883,3,68,1,39.74,NULL,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL),(3088,8081,1273,41123,296883,3,57,2,229.00,NULL,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL),(3089,8081,1274,41123,296883,3,217,1,9896.00,NULL,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL),(3090,8081,1274,41123,296883,3,68,1,1039.09,NULL,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL),(3091,8081,1274,41123,296883,3,57,2,10935.09,NULL,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL),(3092,8081,1275,41123,296883,3,217,1,3935.95,NULL,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL),(3093,8081,1275,41123,296883,3,68,1,826.55,NULL,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL),(3094,8081,1275,41123,296883,3,57,2,4762.50,NULL,'2022-12-12 12:29:52','2022-12-12 12:29:52',NULL),(3095,8081,1276,41123,296883,3,217,1,424.69,NULL,'2022-12-12 12:29:53','2022-12-12 12:29:53',NULL),(3096,8081,1276,41123,296883,3,68,1,89.18,NULL,'2022-12-12 12:29:53','2022-12-12 12:29:53',NULL),(3097,8081,1276,41123,296883,3,217,1,42.46,NULL,'2022-12-12 12:29:53','2022-12-12 12:29:53',NULL),(3098,8081,1276,41123,296883,3,57,2,556.33,NULL,'2022-12-12 12:29:53','2022-12-12 12:29:53',NULL),(3099,8081,1277,41123,296883,3,217,1,513.22,NULL,'2022-12-12 12:29:53','2022-12-12 12:29:53',NULL),(3100,8081,1277,41123,296883,3,68,1,107.78,NULL,'2022-12-12 12:29:53','2022-12-12 12:29:53',NULL);
INSERT INTO `balance_libro_details` VALUES (3101,8081,1277,41123,296883,3,57,2,621.00,NULL,'2022-12-12 12:29:53','2022-12-12 12:29:53',NULL),(3102,8081,1278,41123,296883,3,250,1,2599.00,NULL,'2022-12-12 12:29:53','2022-12-12 12:29:53',NULL),(3103,8081,1278,41123,296883,3,57,2,2599.00,NULL,'2022-12-12 12:29:53','2022-12-12 12:29:53',NULL),(3104,8081,1279,41123,296884,3,217,1,109.09,NULL,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(3105,8081,1279,41123,296884,3,68,1,22.91,NULL,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(3106,8081,1279,41123,296884,3,57,2,132.00,NULL,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(3107,8081,1280,41123,296884,3,217,1,9395.00,NULL,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(3108,8081,1280,41123,296884,3,68,1,986.48,NULL,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(3109,8081,1280,41123,296884,3,57,2,10381.48,NULL,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(3110,8081,1281,41123,296884,3,217,1,115.81,NULL,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(3111,8081,1281,41123,296884,3,68,1,24.32,NULL,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(3112,8081,1281,41123,296884,3,217,1,11.58,NULL,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(3113,8081,1281,41123,296884,3,57,2,151.71,NULL,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(3114,8081,1282,41123,296884,3,217,1,78.51,NULL,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(3115,8081,1282,41123,296884,3,68,1,16.49,NULL,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(3116,8081,1282,41123,296884,3,57,2,95.00,NULL,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(3117,8081,1283,41123,296884,3,217,1,171.08,NULL,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(3118,8081,1283,41123,296884,3,68,1,35.92,NULL,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(3119,8081,1283,41123,296884,3,57,2,207.00,NULL,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(3120,8081,1284,41123,296884,3,217,1,1652.89,NULL,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(3121,8081,1284,41123,296884,3,68,1,347.11,NULL,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(3122,8081,1284,41123,296884,3,57,2,2000.00,NULL,'2022-12-12 12:30:09','2022-12-12 12:30:09',NULL),(3123,8081,1285,41123,296885,3,217,1,11913.00,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3124,8081,1285,41123,296885,3,68,1,1250.87,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3125,8081,1285,41123,296885,3,57,2,13163.87,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3126,8081,1286,41123,296885,3,217,1,38575.87,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3127,8081,1286,41123,296885,3,68,1,8100.93,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3128,8081,1286,41123,296885,3,57,2,46676.80,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3129,8081,1287,41123,296885,3,217,1,308.88,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3130,8081,1287,41123,296885,3,68,1,64.86,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3131,8081,1287,41123,296885,3,217,1,30.88,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3132,8081,1287,41123,296885,3,57,2,404.62,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3133,8081,1288,41123,296885,3,217,1,56.20,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3134,8081,1288,41123,296885,3,68,1,11.80,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3135,8081,1288,41123,296885,3,57,2,68.00,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3136,8081,1289,41123,296885,3,217,1,42.15,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3137,8081,1289,41123,296885,3,68,1,8.85,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3138,8081,1289,41123,296885,3,57,2,51.00,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3139,8081,1290,41123,296885,3,217,1,54.54,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3140,8081,1290,41123,296885,3,68,1,11.46,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL);
INSERT INTO `balance_libro_details` VALUES (3141,8081,1290,41123,296885,3,57,2,66.00,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3142,8081,1291,41123,296885,3,217,1,2115.70,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3143,8081,1291,41123,296885,3,68,1,444.30,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3144,8081,1291,41123,296885,3,217,1,710.00,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3145,8081,1291,41123,296885,3,57,2,3270.00,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3146,8081,1292,41123,296885,3,217,1,237.72,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3147,8081,1292,41123,296885,3,68,1,49.92,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3148,8081,1292,41123,296885,3,217,1,9.51,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3149,8081,1292,41123,296885,3,57,2,297.15,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3150,8081,1293,41123,296885,3,217,1,171.08,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3151,8081,1293,41123,296885,3,68,1,35.92,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3152,8081,1293,41123,296885,3,57,2,207.00,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3153,8081,1294,41123,296885,3,217,1,124.80,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3154,8081,1294,41123,296885,3,68,1,26.20,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3155,8081,1294,41123,296885,3,217,1,15.86,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3156,8081,1294,41123,296885,3,57,2,166.86,NULL,'2022-12-12 12:30:25','2022-12-12 12:30:25',NULL),(3157,8081,1295,41123,296886,3,217,1,404.22,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3158,8081,1295,41123,296886,3,68,1,84.89,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3159,8081,1295,41123,296886,3,57,2,489.11,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3160,8081,1296,41123,296886,3,217,1,11608.00,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3161,8081,1296,41123,296886,3,68,1,1218.84,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3162,8081,1296,41123,296886,3,57,2,12826.84,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3163,8081,1297,41123,296886,3,217,1,844.77,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3164,8081,1297,41123,296886,3,68,1,177.39,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3165,8081,1297,41123,296886,3,217,1,83.97,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3166,8081,1297,41123,296886,3,57,2,1106.13,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3167,8081,1298,41123,296886,3,217,1,3782.81,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3168,8081,1298,41123,296886,3,68,1,794.39,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3169,8081,1298,41123,296886,3,217,1,113.48,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3170,8081,1298,41123,296886,3,57,2,4690.68,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3171,8081,1299,41123,296886,3,217,1,2112.67,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3172,8081,1299,41123,296886,3,68,1,391.48,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3173,8081,1299,41123,296886,3,57,2,2504.15,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3174,8081,1300,41123,296886,3,217,1,48.26,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3175,8081,1300,41123,296886,3,68,1,10.13,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3176,8081,1300,41123,296886,3,217,1,4.82,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3177,8081,1300,41123,296886,3,57,2,63.21,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3178,8081,1301,41123,296886,3,217,1,8677.69,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3179,8081,1301,41123,296886,3,68,1,1822.31,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL),(3180,8081,1301,41123,296886,3,57,2,10500.00,NULL,'2022-12-12 12:30:44','2022-12-12 12:30:44',NULL);
INSERT INTO `balance_libro_details` VALUES (3181,8081,1302,41123,296886,3,217,1,364.46,NULL,'2022-12-12 12:30:45','2022-12-12 12:30:45',NULL),(3182,8081,1302,41123,296886,3,68,1,76.54,NULL,'2022-12-12 12:30:45','2022-12-12 12:30:45',NULL),(3183,8081,1302,41123,296886,3,57,2,441.00,NULL,'2022-12-12 12:30:45','2022-12-12 12:30:45',NULL),(3184,8081,1303,41123,296886,3,217,1,2105.33,NULL,'2022-12-12 12:30:45','2022-12-12 12:30:45',NULL),(3185,8081,1303,41123,296886,3,68,1,442.12,NULL,'2022-12-12 12:30:45','2022-12-12 12:30:45',NULL),(3186,8081,1303,41123,296886,3,57,2,2547.45,NULL,'2022-12-12 12:30:45','2022-12-12 12:30:45',NULL),(3187,8081,1304,41123,296886,3,217,1,6198.35,NULL,'2022-12-12 12:30:45','2022-12-12 12:30:45',NULL),(3188,8081,1304,41123,296886,3,68,1,1301.65,NULL,'2022-12-12 12:30:45','2022-12-12 12:30:45',NULL),(3189,8081,1304,41123,296886,3,57,2,7500.00,NULL,'2022-12-12 12:30:45','2022-12-12 12:30:45',NULL),(3190,8081,1305,41123,296886,3,217,1,478.17,NULL,'2022-12-12 12:30:45','2022-12-12 12:30:45',NULL),(3191,8081,1305,41123,296886,3,68,1,100.41,NULL,'2022-12-12 12:30:45','2022-12-12 12:30:45',NULL),(3192,8081,1305,41123,296886,3,57,2,578.58,NULL,'2022-12-12 12:30:45','2022-12-12 12:30:45',NULL),(3193,8081,1306,41123,296887,3,217,1,12924.00,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3194,8081,1306,41123,296887,3,68,1,1357.02,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3195,8081,1306,41123,296887,3,57,2,14281.02,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3196,8081,1307,41123,296887,3,217,1,473.16,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3197,8081,1307,41123,296887,3,68,1,99.36,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3198,8081,1307,41123,296887,3,217,1,46.31,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3199,8081,1307,41123,296887,3,57,2,618.83,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3200,8081,1308,41123,296887,3,217,1,56.20,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3201,8081,1308,41123,296887,3,68,1,11.80,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3202,8081,1308,41123,296887,3,57,2,68.00,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3203,8081,1309,41123,296887,3,217,1,7581.41,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3204,8081,1309,41123,296887,3,68,1,1592.10,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3205,8081,1309,41123,296887,3,57,2,9173.50,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3206,8081,1309,41123,296887,3,136,2,0.01,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3207,8081,1310,41123,296887,3,217,1,2635.81,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3208,8081,1310,41123,296887,3,68,1,553.52,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3209,8081,1310,41123,296887,3,217,1,184.50,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3210,8081,1310,41123,296887,3,57,2,3373.83,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3211,8081,1311,41123,296887,3,217,1,119.01,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3212,8081,1311,41123,296887,3,68,1,24.99,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3213,8081,1311,41123,296887,3,57,2,144.00,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3214,8081,1312,41123,296887,3,217,1,208.27,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3215,8081,1312,41123,296887,3,68,1,43.73,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3216,8081,1312,41123,296887,3,57,2,252.00,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3217,8081,1313,41123,296887,3,217,1,7851.24,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3218,8081,1313,41123,296887,3,68,1,1648.76,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3219,8081,1313,41123,296887,3,57,2,9500.00,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3220,8081,1314,41123,296887,3,217,1,136.17,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL);
INSERT INTO `balance_libro_details` VALUES (3221,8081,1314,41123,296887,3,68,1,28.59,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3222,8081,1314,41123,296887,3,57,2,164.76,NULL,'2022-12-12 12:31:13','2022-12-12 12:31:13',NULL),(3223,8081,1315,41123,296888,3,217,1,12924.00,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3224,8081,1315,41123,296888,3,68,1,1357.02,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3225,8081,1315,41123,296888,3,57,2,14281.02,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3226,8081,1316,41123,296888,3,217,1,62.81,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3227,8081,1316,41123,296888,3,68,1,13.19,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3228,8081,1316,41123,296888,3,57,2,76.00,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3229,8081,1317,41123,296888,3,217,1,1869.83,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3230,8081,1317,41123,296888,3,68,1,392.67,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3231,8081,1317,41123,296888,3,57,2,2262.50,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3232,8081,1318,41123,296888,3,217,1,485.52,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3233,8081,1318,41123,296888,3,68,1,101.96,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3234,8081,1318,41123,296888,3,217,1,19.42,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3235,8081,1318,41123,296888,3,57,2,606.90,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3236,8081,1319,41123,296888,3,217,1,395.74,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3237,8081,1319,41123,296888,3,68,1,83.10,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3238,8081,1319,41123,296888,3,217,1,39.57,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3239,8081,1319,41123,296888,3,57,2,518.41,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3240,8081,1320,41123,296888,3,217,1,527.27,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3241,8081,1320,41123,296888,3,68,1,110.73,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3242,8081,1320,41123,296888,3,217,1,21.09,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3243,8081,1320,41123,296888,3,57,2,659.09,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3244,8081,1321,41123,296888,3,217,1,12388.43,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3245,8081,1321,41123,296888,3,68,1,2601.57,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3246,8081,1321,41123,296888,3,57,2,14990.00,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3247,8081,1322,41123,296888,3,217,1,290.08,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3248,8081,1322,41123,296888,3,68,1,60.92,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3249,8081,1322,41123,296888,3,57,2,351.00,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3250,8081,1323,41123,296888,3,217,1,925.54,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3251,8081,1323,41123,296888,3,68,1,194.36,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3252,8081,1323,41123,296888,3,57,2,1119.90,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3253,8081,1324,41123,296888,3,217,1,7851.24,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3254,8081,1324,41123,296888,3,68,1,1648.76,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3255,8081,1324,41123,296888,3,57,2,9500.00,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3256,8081,1325,41123,296888,3,217,1,350.88,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3257,8081,1325,41123,296888,3,68,1,73.68,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3258,8081,1325,41123,296888,3,57,2,424.56,NULL,'2022-12-12 12:31:34','2022-12-12 12:31:34',NULL),(3259,8081,1326,41123,296889,3,217,1,14414.00,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3260,8081,1326,41123,296889,3,68,1,1513.47,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL);
INSERT INTO `balance_libro_details` VALUES (3261,8081,1326,41123,296889,3,57,2,15927.47,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3262,8081,1327,41123,296889,3,217,1,134.71,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3263,8081,1327,41123,296889,3,68,1,28.29,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3264,8081,1327,41123,296889,3,57,2,163.00,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3265,8081,1328,41123,296889,3,217,1,134.71,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3266,8081,1328,41123,296889,3,68,1,28.29,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3267,8081,1328,41123,296889,3,57,2,163.00,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3268,8081,1329,41123,296889,3,217,1,395.70,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3269,8081,1329,41123,296889,3,68,1,83.09,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3270,8081,1329,41123,296889,3,217,1,39.56,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3271,8081,1329,41123,296889,3,57,2,518.35,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3272,8081,1330,41123,296889,3,217,1,870.61,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3273,8081,1330,41123,296889,3,68,1,182.83,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3274,8081,1330,41123,296889,3,217,1,60.94,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3275,8081,1330,41123,296889,3,57,2,1114.38,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3276,8081,1331,41123,296889,3,217,1,4128.67,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3277,8081,1331,41123,296889,3,68,1,856.33,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3278,8081,1331,41123,296889,3,57,2,4985.00,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3279,8081,1332,41123,296889,3,250,1,350.00,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3280,8081,1332,41123,296889,3,57,2,350.00,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3281,8081,1333,41123,296889,3,217,1,2471.07,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3282,8081,1333,41123,296889,3,68,1,518.93,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3283,8081,1333,41123,296889,3,57,2,2990.00,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3284,8081,1334,41123,296889,3,217,1,37.19,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3285,8081,1334,41123,296889,3,68,1,7.81,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3286,8081,1334,41123,296889,3,57,2,45.00,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3287,8081,1335,41123,296889,3,217,1,7851.24,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3288,8081,1335,41123,296889,3,68,1,1648.76,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3289,8081,1335,41123,296889,3,57,2,9500.00,NULL,'2022-12-12 12:31:52','2022-12-12 12:31:52',NULL),(3290,8081,1336,41123,296890,3,217,1,14414.00,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3291,8081,1336,41123,296890,3,68,1,1513.47,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3292,8081,1336,41123,296890,3,57,2,15927.47,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3293,8081,1337,41123,296890,3,217,1,10606.61,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3294,8081,1337,41123,296890,3,68,1,2227.39,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3295,8081,1337,41123,296890,3,57,2,12834.00,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3296,8081,1338,41123,296890,3,217,1,162.13,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3297,8081,1338,41123,296890,3,68,1,34.05,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3298,8081,1338,41123,296890,3,217,1,16.21,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3299,8081,1338,41123,296890,3,57,2,212.39,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3300,8081,1339,41123,296890,3,217,1,134.71,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL);
INSERT INTO `balance_libro_details` VALUES (3301,8081,1339,41123,296890,3,68,1,28.29,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3302,8081,1339,41123,296890,3,57,2,163.00,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3303,8081,1340,41123,296890,3,217,1,6527.44,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3304,8081,1340,41123,296890,3,68,1,1370.76,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3305,8081,1340,41123,296890,3,57,2,7898.20,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3306,8081,1341,41123,296890,3,250,1,7350.00,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3307,8081,1341,41123,296890,3,57,2,7350.00,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3308,8081,1342,41123,296890,3,217,1,202.67,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3309,8081,1342,41123,296890,3,68,1,42.55,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3310,8081,1342,41123,296890,3,217,1,20.25,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3311,8081,1342,41123,296890,3,57,2,265.47,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3312,8081,1343,41123,296890,3,217,1,4731.40,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3313,8081,1343,41123,296890,3,68,1,993.60,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3314,8081,1343,41123,296890,3,57,2,5725.00,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3315,8081,1344,41123,296890,3,217,1,297.52,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3316,8081,1344,41123,296890,3,68,1,62.48,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3317,8081,1344,41123,296890,3,57,2,360.00,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3318,8081,1345,41123,296890,3,217,1,8677.69,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3319,8081,1345,41123,296890,3,68,1,1822.31,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3320,8081,1345,41123,296890,3,57,2,10500.00,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3321,8081,1346,41123,296890,3,217,1,14925.98,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3322,8081,1346,41123,296890,3,68,1,3134.46,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3323,8081,1346,41123,296890,3,57,2,18060.44,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3324,8081,1347,41123,296890,3,217,1,3159.05,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3325,8081,1347,41123,296890,3,68,1,663.40,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3326,8081,1347,41123,296890,3,57,2,3822.45,NULL,'2022-12-12 12:32:10','2022-12-12 12:32:10',NULL),(3327,8081,1348,40731,298411,2,218,2,35200.00,NULL,'2022-12-12 13:25:15','2022-12-12 13:25:15',NULL),(3328,8081,1348,40731,298411,2,13,1,35200.00,NULL,'2022-12-12 13:25:15','2022-12-12 13:25:15',NULL),(3329,8081,1349,40731,298411,2,218,2,39100.00,NULL,'2022-12-12 13:25:16','2022-12-12 13:25:16',NULL),(3330,8081,1349,40731,298411,2,13,1,39100.00,NULL,'2022-12-12 13:25:16','2022-12-12 13:25:16',NULL),(3331,8081,1350,40731,298411,2,218,2,39100.00,NULL,'2022-12-12 13:25:16','2022-12-12 13:25:16',NULL),(3332,8081,1350,40731,298411,2,13,1,39100.00,NULL,'2022-12-12 13:25:16','2022-12-12 13:25:16',NULL),(3333,8081,1351,40731,298411,2,218,2,35200.00,NULL,'2022-12-12 13:25:16','2022-12-12 13:25:16',NULL),(3334,8081,1351,40731,298411,2,13,1,35200.00,NULL,'2022-12-12 13:25:16','2022-12-12 13:25:16',NULL),(3335,8081,1352,40731,298411,2,218,2,28000.00,NULL,'2022-12-12 13:25:16','2022-12-12 13:25:16',NULL),(3336,8081,1352,40731,298411,2,13,1,28000.00,NULL,'2022-12-12 13:25:16','2022-12-12 13:25:16',NULL),(3337,8081,1353,40731,298411,2,218,2,3300.00,NULL,'2022-12-12 13:25:16','2022-12-12 13:25:16',NULL),(3338,8081,1353,40731,298411,2,13,1,3300.00,NULL,'2022-12-12 13:25:16','2022-12-12 13:25:16',NULL),(3339,8081,1354,40731,298412,2,218,2,44910.00,NULL,'2022-12-12 13:25:34','2022-12-12 13:25:34',NULL),(3340,8081,1354,40731,298412,2,13,1,44910.00,NULL,'2022-12-12 13:25:34','2022-12-12 13:25:34',NULL);
INSERT INTO `balance_libro_details` VALUES (3341,8081,1355,40731,298412,2,218,2,37990.00,NULL,'2022-12-12 13:25:34','2022-12-12 13:25:34',NULL),(3342,8081,1355,40731,298412,2,13,1,37990.00,NULL,'2022-12-12 13:25:34','2022-12-12 13:25:34',NULL),(3343,8081,1356,40731,298412,2,218,2,31685.00,NULL,'2022-12-12 13:25:34','2022-12-12 13:25:34',NULL),(3344,8081,1356,40731,298412,2,13,1,31685.00,NULL,'2022-12-12 13:25:34','2022-12-12 13:25:34',NULL),(3345,8081,1357,40731,298412,2,218,2,38000.00,NULL,'2022-12-12 13:25:34','2022-12-12 13:25:34',NULL),(3346,8081,1357,40731,298412,2,13,1,38000.00,NULL,'2022-12-12 13:25:34','2022-12-12 13:25:34',NULL),(3347,8081,1358,40731,298413,2,218,2,21760.00,NULL,'2022-12-12 13:25:50','2022-12-12 13:25:50',NULL),(3348,8081,1358,40731,298413,2,13,1,21760.00,NULL,'2022-12-12 13:25:50','2022-12-12 13:25:50',NULL),(3349,8081,1359,40731,298413,2,218,2,19990.00,NULL,'2022-12-12 13:25:50','2022-12-12 13:25:50',NULL),(3350,8081,1359,40731,298413,2,13,1,19990.00,NULL,'2022-12-12 13:25:50','2022-12-12 13:25:50',NULL),(3351,8081,1360,40731,298413,2,218,2,37990.00,NULL,'2022-12-12 13:25:50','2022-12-12 13:25:50',NULL),(3352,8081,1360,40731,298413,2,13,1,37990.00,NULL,'2022-12-12 13:25:50','2022-12-12 13:25:50',NULL),(3353,8081,1361,40731,298413,2,218,2,42230.00,NULL,'2022-12-12 13:25:50','2022-12-12 13:25:50',NULL),(3354,8081,1361,40731,298413,2,13,1,42230.00,NULL,'2022-12-12 13:25:50','2022-12-12 13:25:50',NULL),(3355,8081,1362,40731,298413,2,218,2,34200.00,NULL,'2022-12-12 13:25:50','2022-12-12 13:25:50',NULL),(3356,8081,1362,40731,298413,2,13,1,34200.00,NULL,'2022-12-12 13:25:50','2022-12-12 13:25:50',NULL),(3357,8081,1363,40731,298413,2,218,2,3600.00,NULL,'2022-12-12 13:25:50','2022-12-12 13:25:50',NULL),(3358,8081,1363,40731,298413,2,13,1,3600.00,NULL,'2022-12-12 13:25:50','2022-12-12 13:25:50',NULL),(3359,8081,1364,40731,298414,2,218,2,31685.00,NULL,'2022-12-12 13:26:08','2022-12-12 13:26:08',NULL),(3360,8081,1364,40731,298414,2,13,1,31685.00,NULL,'2022-12-12 13:26:08','2022-12-12 13:26:08',NULL),(3361,8081,1365,40731,298414,2,218,2,42000.00,NULL,'2022-12-12 13:26:08','2022-12-12 13:26:08',NULL),(3362,8081,1365,40731,298414,2,13,1,42000.00,NULL,'2022-12-12 13:26:08','2022-12-12 13:26:08',NULL),(3363,8081,1366,40731,298414,2,218,2,12000.00,NULL,'2022-12-12 13:26:08','2022-12-12 13:26:08',NULL),(3364,8081,1366,40731,298414,2,13,1,12000.00,NULL,'2022-12-12 13:26:08','2022-12-12 13:26:08',NULL),(3365,8081,1367,40731,298415,2,218,2,415.07,NULL,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(3366,8081,1367,40731,298415,2,13,1,415.07,NULL,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(3367,8081,1368,40731,298415,2,218,2,36890.00,NULL,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(3368,8081,1368,40731,298415,2,13,1,36890.00,NULL,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(3369,8081,1369,40731,298415,2,218,2,45910.00,NULL,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(3370,8081,1369,40731,298415,2,13,1,45910.00,NULL,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(3371,8081,1370,40731,298415,2,218,2,4470.00,NULL,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(3372,8081,1370,40731,298415,2,13,1,4470.00,NULL,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(3373,8081,1371,40731,298415,2,218,2,45910.00,NULL,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(3374,8081,1371,40731,298415,2,13,1,45910.00,NULL,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(3375,8081,1372,40731,298415,2,218,2,7000.00,NULL,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(3376,8081,1372,40731,298415,2,13,1,7000.00,NULL,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(3377,8081,1373,40731,298415,2,218,2,35190.00,NULL,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(3378,8081,1373,40731,298415,2,13,1,35190.00,NULL,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(3379,8081,1374,40731,298415,2,218,2,2090.00,NULL,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL),(3380,8081,1374,40731,298415,2,13,1,2090.00,NULL,'2022-12-12 13:26:30','2022-12-12 13:26:30',NULL);
INSERT INTO `balance_libro_details` VALUES (3381,8081,1375,40731,298416,2,218,2,45910.00,NULL,'2022-12-12 13:26:52','2022-12-12 13:26:52',NULL),(3382,8081,1375,40731,298416,2,13,1,45910.00,NULL,'2022-12-12 13:26:52','2022-12-12 13:26:52',NULL),(3383,8081,1376,40731,298416,2,218,2,15630.00,NULL,'2022-12-12 13:26:52','2022-12-12 13:26:52',NULL),(3384,8081,1376,40731,298416,2,13,1,15630.00,NULL,'2022-12-12 13:26:52','2022-12-12 13:26:52',NULL),(3385,8081,1377,40731,298416,2,218,2,41000.00,NULL,'2022-12-12 13:26:52','2022-12-12 13:26:52',NULL),(3386,8081,1377,40731,298416,2,13,1,41000.00,NULL,'2022-12-12 13:26:52','2022-12-12 13:26:52',NULL),(3387,8081,1378,40731,298417,2,218,2,55105.00,NULL,'2022-12-12 13:27:12','2022-12-12 13:27:12',NULL),(3388,8081,1378,40731,298417,2,13,1,55105.00,NULL,'2022-12-12 13:27:12','2022-12-12 13:27:12',NULL),(3389,8081,1379,40731,298417,2,218,2,23580.00,NULL,'2022-12-12 13:27:12','2022-12-12 13:27:12',NULL),(3390,8081,1379,40731,298417,2,13,1,23580.00,NULL,'2022-12-12 13:27:12','2022-12-12 13:27:12',NULL),(3391,8081,1380,40731,298417,2,218,2,45910.00,NULL,'2022-12-12 13:27:12','2022-12-12 13:27:12',NULL),(3392,8081,1380,40731,298417,2,13,1,45910.00,NULL,'2022-12-12 13:27:12','2022-12-12 13:27:12',NULL),(3393,8081,1381,40731,298417,2,218,2,59135.00,NULL,'2022-12-12 13:27:12','2022-12-12 13:27:12',NULL),(3394,8081,1381,40731,298417,2,13,1,59135.00,NULL,'2022-12-12 13:27:12','2022-12-12 13:27:12',NULL),(3395,8081,1382,40731,298417,2,218,2,7950.00,NULL,'2022-12-12 13:27:12','2022-12-12 13:27:12',NULL),(3396,8081,1382,40731,298417,2,13,1,7950.00,NULL,'2022-12-12 13:27:12','2022-12-12 13:27:12',NULL),(3397,8081,1383,40731,298417,2,218,2,24820.00,NULL,'2022-12-12 13:27:13','2022-12-12 13:27:13',NULL),(3398,8081,1383,40731,298417,2,13,1,24820.00,NULL,'2022-12-12 13:27:13','2022-12-12 13:27:13',NULL),(3399,8081,1384,40731,298417,2,218,2,45910.00,NULL,'2022-12-12 13:27:13','2022-12-12 13:27:13',NULL),(3400,8081,1384,40731,298417,2,13,1,45910.00,NULL,'2022-12-12 13:27:13','2022-12-12 13:27:13',NULL),(3401,8081,1385,40731,298417,2,218,2,72000.00,NULL,'2022-12-12 13:27:13','2022-12-12 13:27:13',NULL),(3402,8081,1385,40731,298417,2,13,1,72000.00,NULL,'2022-12-12 13:27:13','2022-12-12 13:27:13',NULL),(3403,8081,1386,40731,298418,2,218,2,401.07,NULL,'2022-12-12 13:27:31','2022-12-12 13:27:31',NULL),(3404,8081,1386,40731,298418,2,13,1,401.07,NULL,'2022-12-12 13:27:31','2022-12-12 13:27:31',NULL),(3405,8081,1387,40731,298418,2,218,2,49950.00,NULL,'2022-12-12 13:27:31','2022-12-12 13:27:31',NULL),(3406,8081,1387,40731,298418,2,13,1,49950.00,NULL,'2022-12-12 13:27:31','2022-12-12 13:27:31',NULL),(3407,8081,1388,40731,298418,2,218,2,46000.00,NULL,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(3408,8081,1388,40731,298418,2,13,1,46000.00,NULL,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(3409,8081,1389,40731,298418,2,218,2,18905.00,NULL,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(3410,8081,1389,40731,298418,2,13,1,18905.00,NULL,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(3411,8081,1390,40731,298418,2,218,2,34275.00,NULL,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(3412,8081,1390,40731,298418,2,13,1,34275.00,NULL,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(3413,8081,1391,40731,298418,2,218,2,49950.00,NULL,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(3414,8081,1391,40731,298418,2,13,1,49950.00,NULL,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(3415,8081,1392,40731,298418,2,218,2,3300.00,NULL,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(3416,8081,1392,40731,298418,2,13,1,3300.00,NULL,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(3417,8081,1393,40731,298418,2,218,2,3300.00,NULL,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(3418,8081,1393,40731,298418,2,13,1,3300.00,NULL,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(3419,8081,1394,40731,298418,2,218,2,4645.00,NULL,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(3420,8081,1394,40731,298418,2,13,1,4645.00,NULL,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL);
INSERT INTO `balance_libro_details` VALUES (3421,8081,1395,40731,298418,2,218,2,18000.00,NULL,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(3422,8081,1395,40731,298418,2,13,1,18000.00,NULL,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(3423,8081,1396,40731,298418,2,218,2,53541.00,NULL,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(3424,8081,1396,40731,298418,2,13,1,53541.00,NULL,'2022-12-12 13:27:32','2022-12-12 13:27:32',NULL),(3425,8081,1397,40731,298410,3,217,1,37551.03,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3426,8081,1397,40731,298410,3,68,1,7885.72,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3427,8081,1397,40731,298410,3,217,1,1363.10,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3428,8081,1397,40731,298410,3,57,2,46799.85,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3429,8081,1398,40731,298410,3,217,1,14180.90,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3430,8081,1398,40731,298410,3,68,1,2977.99,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3431,8081,1398,40731,298410,3,217,1,514.77,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3432,8081,1398,40731,298410,3,57,2,17673.66,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3433,8081,1399,40731,298410,3,217,1,342.00,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3434,8081,1399,40731,298410,3,68,1,71.82,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3435,8081,1399,40731,298410,3,217,1,12.41,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3436,8081,1399,40731,298410,3,57,2,426.23,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3437,8081,1400,40731,298410,3,217,1,1920.00,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3438,8081,1400,40731,298410,3,68,1,403.20,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3439,8081,1400,40731,298410,3,217,1,69.70,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3440,8081,1400,40731,298410,3,57,2,2392.90,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3441,8081,1401,40731,298410,3,217,1,159.76,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3442,8081,1401,40731,298410,3,68,1,33.54,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3443,8081,1401,40731,298410,3,217,1,15.95,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3444,8081,1401,40731,298410,3,57,2,209.25,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3445,8081,1402,40731,298410,3,217,1,1161.19,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3446,8081,1402,40731,298410,3,68,1,243.85,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3447,8081,1402,40731,298410,3,57,2,1405.04,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3448,8081,1403,40731,298410,3,250,1,0.00,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3449,8081,1403,40731,298410,3,57,2,0.00,NULL,'2022-12-12 13:29:29','2022-12-12 13:29:29',NULL),(3450,8081,1404,40731,298411,3,217,1,15036.96,NULL,'2022-12-12 13:29:46','2022-12-12 13:29:46',NULL),(3451,8081,1404,40731,298411,3,68,1,3157.76,NULL,'2022-12-12 13:29:46','2022-12-12 13:29:46',NULL),(3452,8081,1404,40731,298411,3,217,1,545.84,NULL,'2022-12-12 13:29:46','2022-12-12 13:29:46',NULL),(3453,8081,1404,40731,298411,3,57,2,18740.56,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3454,8081,1405,40731,298411,3,217,1,18344.00,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3455,8081,1405,40731,298411,3,68,1,3852.24,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3456,8081,1405,40731,298411,3,217,1,665.89,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3457,8081,1405,40731,298411,3,57,2,22862.13,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3458,8081,1406,40731,298411,3,217,1,18114.75,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3459,8081,1406,40731,298411,3,68,1,3804.10,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3460,8081,1406,40731,298411,3,217,1,657.57,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL);
INSERT INTO `balance_libro_details` VALUES (3461,8081,1406,40731,298411,3,57,2,22576.42,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3462,8081,1407,40731,298411,3,217,1,18114.75,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3463,8081,1407,40731,298411,3,68,1,3804.10,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3464,8081,1407,40731,298411,3,217,1,657.57,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3465,8081,1407,40731,298411,3,57,2,22576.42,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3466,8081,1408,40731,298411,3,217,1,366.00,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3467,8081,1408,40731,298411,3,68,1,76.86,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3468,8081,1408,40731,298411,3,217,1,13.29,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3469,8081,1408,40731,298411,3,57,2,456.15,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3470,8081,1409,40731,298411,3,217,1,164.12,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3471,8081,1409,40731,298411,3,68,1,34.47,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3472,8081,1409,40731,298411,3,217,1,16.41,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3473,8081,1409,40731,298411,3,57,2,215.00,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3474,8081,1410,40731,298411,3,217,1,52132.65,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3475,8081,1410,40731,298411,3,68,1,10947.86,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3476,8081,1410,40731,298411,3,217,1,1892.42,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3477,8081,1410,40731,298411,3,57,2,64972.93,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3478,8081,1411,40731,298411,3,217,1,5526.40,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3479,8081,1411,40731,298411,3,68,1,1160.54,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3480,8081,1411,40731,298411,3,217,1,200.61,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3481,8081,1411,40731,298411,3,57,2,6887.55,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3482,8081,1412,40731,298411,3,217,1,82.62,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3483,8081,1412,40731,298411,3,68,1,17.35,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3484,8081,1412,40731,298411,3,217,1,0.03,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3485,8081,1412,40731,298411,3,57,2,100.00,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3486,8081,1413,40731,298411,3,217,1,1994.00,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3487,8081,1413,40731,298411,3,68,1,418.74,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3488,8081,1413,40731,298411,3,217,1,72.38,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3489,8081,1413,40731,298411,3,57,2,2485.12,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3490,8081,1414,40731,298411,3,217,1,1248.11,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3491,8081,1414,40731,298411,3,68,1,262.10,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3492,8081,1414,40731,298411,3,57,2,1510.21,NULL,'2022-12-12 13:29:47','2022-12-12 13:29:47',NULL),(3493,8081,1415,40731,298412,3,217,1,1730.00,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3494,8081,1415,40731,298412,3,68,1,363.30,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3495,8081,1415,40731,298412,3,217,1,62.80,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3496,8081,1415,40731,298412,3,57,2,2156.10,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3497,8081,1416,40731,298412,3,217,1,18249.95,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3498,8081,1416,40731,298412,3,68,1,3832.49,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3499,8081,1416,40731,298412,3,217,1,662.47,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3500,8081,1416,40731,298412,3,57,2,22744.91,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL);
INSERT INTO `balance_libro_details` VALUES (3501,8081,1417,40731,298412,3,217,1,18139.00,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3502,8081,1417,40731,298412,3,68,1,3809.19,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3503,8081,1417,40731,298412,3,217,1,658.45,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3504,8081,1417,40731,298412,3,57,2,22606.64,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3505,8081,1418,40731,298412,3,217,1,24506.00,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3506,8081,1418,40731,298412,3,68,1,5146.26,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3507,8081,1418,40731,298412,3,217,1,889.57,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3508,8081,1418,40731,298412,3,57,2,30541.83,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3509,8081,1419,40731,298412,3,217,1,395.00,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3510,8081,1419,40731,298412,3,68,1,82.95,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3511,8081,1419,40731,298412,3,217,1,14.34,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3512,8081,1419,40731,298412,3,57,2,492.29,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3513,8081,1420,40731,298412,3,250,1,0.00,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3514,8081,1420,40731,298412,3,57,2,0.00,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3515,8081,1421,40731,298412,3,250,1,0.00,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3516,8081,1421,40731,298412,3,57,2,0.00,NULL,'2022-12-12 13:30:00','2022-12-12 13:30:00',NULL),(3517,8081,1422,40731,298412,3,217,1,59.50,NULL,'2022-12-12 13:30:01','2022-12-12 13:30:01',NULL),(3518,8081,1422,40731,298412,3,68,1,12.50,NULL,'2022-12-12 13:30:01','2022-12-12 13:30:01',NULL),(3519,8081,1422,40731,298412,3,57,2,72.00,NULL,'2022-12-12 13:30:01','2022-12-12 13:30:01',NULL),(3520,8081,1423,40731,298412,3,217,1,15912.59,NULL,'2022-12-12 13:30:01','2022-12-12 13:30:01',NULL),(3521,8081,1423,40731,298412,3,68,1,3341.65,NULL,'2022-12-12 13:30:01','2022-12-12 13:30:01',NULL),(3522,8081,1423,40731,298412,3,217,1,577.63,NULL,'2022-12-12 13:30:01','2022-12-12 13:30:01',NULL),(3523,8081,1423,40731,298412,3,57,2,19831.87,NULL,'2022-12-12 13:30:01','2022-12-12 13:30:01',NULL),(3524,8081,1424,40731,298412,3,217,1,1310.51,NULL,'2022-12-12 13:30:01','2022-12-12 13:30:01',NULL),(3525,8081,1424,40731,298412,3,68,1,275.21,NULL,'2022-12-12 13:30:01','2022-12-12 13:30:01',NULL),(3526,8081,1424,40731,298412,3,57,2,1585.72,NULL,'2022-12-12 13:30:01','2022-12-12 13:30:01',NULL),(3527,8081,1425,40731,298413,3,217,1,39729.00,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3528,8081,1425,40731,298413,3,68,1,8343.09,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3529,8081,1425,40731,298413,3,217,1,1442.16,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3530,8081,1425,40731,298413,3,57,2,49514.25,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3531,8081,1426,40731,298413,3,217,1,17149.60,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3532,8081,1426,40731,298413,3,68,1,3601.42,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3533,8081,1426,40731,298413,3,217,1,622.53,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3534,8081,1426,40731,298413,3,57,2,21373.55,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3535,8081,1427,40731,298413,3,217,1,16543.35,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3536,8081,1427,40731,298413,3,68,1,3474.10,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3537,8081,1427,40731,298413,3,217,1,600.52,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3538,8081,1427,40731,298413,3,57,2,20617.97,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3539,8081,1428,40731,298413,3,217,1,395.00,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3540,8081,1428,40731,298413,3,68,1,82.95,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL);
INSERT INTO `balance_libro_details` VALUES (3541,8081,1428,40731,298413,3,217,1,14.34,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3542,8081,1428,40731,298413,3,57,2,492.29,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3543,8081,1429,40731,298413,3,217,1,231.68,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3544,8081,1429,40731,298413,3,68,1,48.65,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3545,8081,1429,40731,298413,3,217,1,23.16,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3546,8081,1429,40731,298413,3,57,2,303.49,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3547,8081,1430,40731,298413,3,217,1,25464.05,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3548,8081,1430,40731,298413,3,68,1,5347.45,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3549,8081,1430,40731,298413,3,57,2,30811.50,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3550,8081,1431,40731,298413,3,217,1,2332.23,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3551,8081,1431,40731,298413,3,68,1,489.77,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3552,8081,1431,40731,298413,3,57,2,2822.00,NULL,'2022-12-12 13:30:17','2022-12-12 13:30:17',NULL),(3553,8081,1432,40731,298413,3,217,1,11494.50,NULL,'2022-12-12 13:30:18','2022-12-12 13:30:18',NULL),(3554,8081,1432,40731,298413,3,68,1,2413.85,NULL,'2022-12-12 13:30:18','2022-12-12 13:30:18',NULL),(3555,8081,1432,40731,298413,3,217,1,417.25,NULL,'2022-12-12 13:30:18','2022-12-12 13:30:18',NULL),(3556,8081,1432,40731,298413,3,57,2,14325.60,NULL,'2022-12-12 13:30:18','2022-12-12 13:30:18',NULL),(3557,8081,1433,40731,298413,3,217,1,3416.32,NULL,'2022-12-12 13:30:18','2022-12-12 13:30:18',NULL),(3558,8081,1433,40731,298413,3,68,1,717.43,NULL,'2022-12-12 13:30:18','2022-12-12 13:30:18',NULL),(3559,8081,1433,40731,298413,3,217,1,124.01,NULL,'2022-12-12 13:30:18','2022-12-12 13:30:18',NULL),(3560,8081,1433,40731,298413,3,57,2,4257.76,NULL,'2022-12-12 13:30:18','2022-12-12 13:30:18',NULL),(3561,8081,1434,40731,298413,3,217,1,1490.14,NULL,'2022-12-12 13:30:18','2022-12-12 13:30:18',NULL),(3562,8081,1434,40731,298413,3,68,1,312.93,NULL,'2022-12-12 13:30:18','2022-12-12 13:30:18',NULL),(3563,8081,1434,40731,298413,3,57,2,1803.07,NULL,'2022-12-12 13:30:18','2022-12-12 13:30:18',NULL),(3564,8081,1435,40731,298413,3,217,1,19564.90,NULL,'2022-12-12 13:30:18','2022-12-12 13:30:18',NULL),(3565,8081,1435,40731,298413,3,68,1,4108.63,NULL,'2022-12-12 13:30:18','2022-12-12 13:30:18',NULL),(3566,8081,1435,40731,298413,3,217,1,710.21,NULL,'2022-12-12 13:30:18','2022-12-12 13:30:18',NULL),(3567,8081,1435,40731,298413,3,57,2,24383.74,NULL,'2022-12-12 13:30:18','2022-12-12 13:30:18',NULL),(3568,8081,1436,40731,298414,3,217,1,427.00,NULL,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(3569,8081,1436,40731,298414,3,68,1,89.67,NULL,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(3570,8081,1436,40731,298414,3,217,1,15.50,NULL,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(3571,8081,1436,40731,298414,3,57,2,532.17,NULL,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(3572,8081,1437,40731,298414,3,217,1,183.37,NULL,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(3573,8081,1437,40731,298414,3,68,1,38.50,NULL,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(3574,8081,1437,40731,298414,3,217,1,18.33,NULL,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(3575,8081,1437,40731,298414,3,57,2,240.20,NULL,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(3576,8081,1438,40731,298414,3,217,1,157.02,NULL,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(3577,8081,1438,40731,298414,3,68,1,32.98,NULL,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(3578,8081,1438,40731,298414,3,57,2,190.00,NULL,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(3579,8081,1439,40731,298414,3,217,1,16.53,NULL,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(3580,8081,1439,40731,298414,3,68,1,3.47,NULL,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL);
INSERT INTO `balance_libro_details` VALUES (3581,8081,1439,40731,298414,3,57,2,20.00,NULL,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(3582,8081,1440,40731,298414,3,217,1,1561.25,NULL,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(3583,8081,1440,40731,298414,3,68,1,327.86,NULL,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(3584,8081,1440,40731,298414,3,57,2,1889.11,NULL,'2022-12-12 13:30:32','2022-12-12 13:30:32',NULL),(3585,8081,1441,40731,298415,3,217,1,9.51,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3586,8081,1441,40731,298415,3,68,1,2.00,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3587,8081,1441,40731,298415,3,57,2,11.51,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3588,8081,1442,40731,298415,3,217,1,25522.31,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3589,8081,1442,40731,298415,3,68,1,5359.68,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3590,8081,1442,40731,298415,3,217,1,926.46,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3591,8081,1442,40731,298415,3,57,2,31808.45,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3592,8081,1443,40731,298415,3,217,1,1578.00,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3593,8081,1443,40731,298415,3,68,1,331.38,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3594,8081,1443,40731,298415,3,217,1,57.28,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3595,8081,1443,40731,298415,3,57,2,1966.66,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3596,8081,1444,40731,298415,3,217,1,1308.00,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3597,8081,1444,40731,298415,3,68,1,274.68,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3598,8081,1444,40731,298415,3,217,1,47.48,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3599,8081,1444,40731,298415,3,57,2,1630.16,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3600,8081,1445,40731,298415,3,217,1,3419.15,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3601,8081,1445,40731,298415,3,68,1,718.02,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3602,8081,1445,40731,298415,3,217,1,124.12,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3603,8081,1445,40731,298415,3,57,2,4261.29,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3604,8081,1446,40731,298415,3,217,1,47584.63,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3605,8081,1446,40731,298415,3,68,1,9992.78,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3606,8081,1446,40731,298415,3,217,1,1727.32,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3607,8081,1446,40731,298415,3,57,2,59304.73,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3608,8081,1447,40731,298415,3,217,1,23658.30,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3609,8081,1447,40731,298415,3,68,1,4968.24,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3610,8081,1447,40731,298415,3,217,1,858.80,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3611,8081,1447,40731,298415,3,57,2,29485.34,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3612,8081,1448,40731,298415,3,217,1,23672.85,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3613,8081,1448,40731,298415,3,68,1,4971.30,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3614,8081,1448,40731,298415,3,217,1,859.32,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3615,8081,1448,40731,298415,3,57,2,29503.47,NULL,'2022-12-12 13:30:51','2022-12-12 13:30:51',NULL),(3616,8081,1449,40731,298417,3,217,1,74064.35,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3617,8081,1449,40731,298417,3,68,1,15553.51,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3618,8081,1449,40731,298417,3,217,1,2688.54,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3619,8081,1449,40731,298417,3,57,2,92306.40,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3620,8081,1450,40731,298417,3,217,1,4951.04,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL);
INSERT INTO `balance_libro_details` VALUES (3621,8081,1450,40731,298417,3,68,1,1039.72,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3622,8081,1450,40731,298417,3,217,1,179.72,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3623,8081,1450,40731,298417,3,57,2,6170.48,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3624,8081,1451,40731,298417,3,217,1,83075.65,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3625,8081,1451,40731,298417,3,68,1,17445.88,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3626,8081,1451,40731,298417,3,217,1,3015.65,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3627,8081,1451,40731,298417,3,57,2,103537.18,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3628,8081,1452,40731,298417,3,217,1,521.00,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3629,8081,1452,40731,298417,3,68,1,109.41,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3630,8081,1452,40731,298417,3,217,1,18.91,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3631,8081,1452,40731,298417,3,57,2,649.32,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3632,8081,1453,40731,298417,3,217,1,157.02,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3633,8081,1453,40731,298417,3,68,1,32.98,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3634,8081,1453,40731,298417,3,57,2,190.00,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3635,8081,1454,40731,298417,3,217,1,1793.58,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3636,8081,1454,40731,298417,3,68,1,376.65,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3637,8081,1454,40731,298417,3,217,1,65.11,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3638,8081,1454,40731,298417,3,57,2,2235.34,NULL,'2022-12-12 13:33:06','2022-12-12 13:33:06',NULL),(3639,8081,1455,40731,298418,3,217,1,642.00,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3640,8081,1455,40731,298418,3,68,1,134.82,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3641,8081,1455,40731,298418,3,217,1,23.30,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3642,8081,1455,40731,298418,3,57,2,800.12,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3643,8081,1456,40731,298418,3,217,1,7846.15,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3644,8081,1456,40731,298418,3,68,1,1647.69,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3645,8081,1456,40731,298418,3,217,1,284.82,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3646,8081,1456,40731,298418,3,57,2,9778.66,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3647,8081,1457,40731,298418,3,217,1,25734.10,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3648,8081,1457,40731,298418,3,68,1,5404.16,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3649,8081,1457,40731,298418,3,217,1,934.15,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3650,8081,1457,40731,298418,3,57,2,32072.41,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3651,8081,1458,40731,298418,3,217,1,11065.56,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3652,8081,1458,40731,298418,3,68,1,2323.77,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3653,8081,1458,40731,298418,3,217,1,401.68,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3654,8081,1458,40731,298418,3,57,2,13791.01,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3655,8081,1459,40731,298418,3,217,1,10.00,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3656,8081,1459,40731,298418,3,68,1,2.10,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3657,8081,1459,40731,298418,3,217,1,0.36,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3658,8081,1459,40731,298418,3,57,2,12.46,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3659,8081,1460,40731,298418,3,217,1,2687.00,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3660,8081,1460,40731,298418,3,68,1,564.27,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL);
INSERT INTO `balance_libro_details` VALUES (3661,8081,1460,40731,298418,3,217,1,97.54,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3662,8081,1460,40731,298418,3,57,2,3348.81,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3663,8081,1461,40731,298418,3,217,1,328.25,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3664,8081,1461,40731,298418,3,68,1,68.93,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3665,8081,1461,40731,298418,3,217,1,32.82,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3666,8081,1461,40731,298418,3,57,2,430.00,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3667,8081,1462,40731,298418,3,217,1,329.35,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3668,8081,1462,40731,298418,3,68,1,69.16,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3669,8081,1462,40731,298418,3,217,1,11.96,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3670,8081,1462,40731,298418,3,57,2,410.47,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3671,8081,1463,40731,298418,3,217,1,7064.00,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3672,8081,1463,40731,298418,3,68,1,1483.44,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3673,8081,1463,40731,298418,3,217,1,256.42,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3674,8081,1463,40731,298418,3,57,2,8803.86,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3675,8081,1464,40731,298418,3,250,1,10400.00,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3676,8081,1464,40731,298418,3,57,2,10400.00,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3677,8081,1465,40731,298418,3,217,1,99873.81,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3678,8081,1465,40731,298418,3,68,1,20973.50,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3679,8081,1465,40731,298418,3,217,1,3625.42,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3680,8081,1465,40731,298418,3,57,2,124472.73,NULL,'2022-12-12 13:34:04','2022-12-12 13:34:04',NULL),(3681,8081,1466,41147,322665,2,218,2,9500.00,NULL,'2022-12-12 13:36:08','2022-12-12 13:36:08',NULL),(3682,8081,1466,41147,322665,2,13,1,9500.00,NULL,'2022-12-12 13:36:08','2022-12-12 13:36:08',NULL),(3683,8081,1467,41147,322665,2,218,2,9500.00,NULL,'2022-12-12 13:36:08','2022-12-12 13:36:08',NULL),(3684,8081,1467,41147,322665,2,13,1,9500.00,NULL,'2022-12-12 13:36:08','2022-12-12 13:36:08',NULL),(3685,8081,1468,41147,322665,2,218,2,9500.00,NULL,'2022-12-12 13:36:08','2022-12-12 13:36:08',NULL),(3686,8081,1468,41147,322665,2,13,1,9500.00,NULL,'2022-12-12 13:36:08','2022-12-12 13:36:08',NULL),(3687,8081,1469,41147,322665,2,218,2,2000.00,NULL,'2022-12-12 13:36:08','2022-12-12 13:36:08',NULL),(3688,8081,1469,41147,322665,2,13,1,2000.00,NULL,'2022-12-12 13:36:08','2022-12-12 13:36:08',NULL),(3689,8081,1470,41147,322665,2,218,2,9800.00,NULL,'2022-12-12 13:36:08','2022-12-12 13:36:08',NULL),(3690,8081,1470,41147,322665,2,13,1,9800.00,NULL,'2022-12-12 13:36:08','2022-12-12 13:36:08',NULL),(3691,8081,1471,41147,322665,2,218,2,2500.00,NULL,'2022-12-12 13:36:08','2022-12-12 13:36:08',NULL),(3692,8081,1471,41147,322665,2,13,1,2500.00,NULL,'2022-12-12 13:36:08','2022-12-12 13:36:08',NULL),(3693,8081,1472,41147,322665,2,218,1,9500.00,NULL,'2022-12-12 13:36:09','2022-12-12 13:36:09',NULL),(3694,8081,1472,41147,322665,2,13,2,9500.00,NULL,'2022-12-12 13:36:09','2022-12-12 13:36:09',NULL),(3695,8081,1473,41147,322665,2,218,1,9500.00,NULL,'2022-12-12 13:36:09','2022-12-12 13:36:09',NULL),(3696,8081,1473,41147,322665,2,13,2,9500.00,NULL,'2022-12-12 13:36:09','2022-12-12 13:36:09',NULL),(3697,8081,1474,41147,322665,2,218,1,9800.00,NULL,'2022-12-12 13:36:09','2022-12-12 13:36:09',NULL),(3698,8081,1474,41147,322665,2,13,2,9800.00,NULL,'2022-12-12 13:36:09','2022-12-12 13:36:09',NULL),(3699,8081,1475,41147,322665,2,218,2,9800.00,NULL,'2022-12-12 13:36:09','2022-12-12 13:36:09',NULL),(3700,8081,1475,41147,322665,2,13,1,9800.00,NULL,'2022-12-12 13:36:09','2022-12-12 13:36:09',NULL);
INSERT INTO `balance_libro_details` VALUES (3701,8081,1476,41147,322665,2,218,2,9200.00,NULL,'2022-12-12 13:36:09','2022-12-12 13:36:09',NULL),(3702,8081,1476,41147,322665,2,13,1,9200.00,NULL,'2022-12-12 13:36:09','2022-12-12 13:36:09',NULL),(3703,8081,1477,41147,322665,2,218,2,2600.00,NULL,'2022-12-12 13:36:09','2022-12-12 13:36:09',NULL),(3704,8081,1477,41147,322665,2,13,1,2600.00,NULL,'2022-12-12 13:36:09','2022-12-12 13:36:09',NULL),(3705,8081,1478,41147,322666,2,218,2,9800.00,NULL,'2022-12-12 13:36:37','2022-12-12 13:36:37',NULL),(3706,8081,1478,41147,322666,2,13,1,9800.00,NULL,'2022-12-12 13:36:37','2022-12-12 13:36:37',NULL),(3707,8081,1479,41147,322666,2,218,2,9500.00,NULL,'2022-12-12 13:36:37','2022-12-12 13:36:37',NULL),(3708,8081,1479,41147,322666,2,13,1,9500.00,NULL,'2022-12-12 13:36:37','2022-12-12 13:36:37',NULL),(3709,8081,1480,41147,322666,2,218,2,2000.00,NULL,'2022-12-12 13:36:38','2022-12-12 13:36:38',NULL),(3710,8081,1480,41147,322666,2,13,1,2000.00,NULL,'2022-12-12 13:36:38','2022-12-12 13:36:38',NULL),(3711,8081,1481,41147,322666,2,218,2,3500.00,NULL,'2022-12-12 13:36:38','2022-12-12 13:36:38',NULL),(3712,8081,1481,41147,322666,2,13,1,3500.00,NULL,'2022-12-12 13:36:38','2022-12-12 13:36:38',NULL),(3713,8081,1482,41147,322666,2,218,2,3500.00,NULL,'2022-12-12 13:36:38','2022-12-12 13:36:38',NULL),(3714,8081,1482,41147,322666,2,13,1,3500.00,NULL,'2022-12-12 13:36:38','2022-12-12 13:36:38',NULL),(3715,8081,1483,41147,322666,2,218,2,9600.00,NULL,'2022-12-12 13:36:38','2022-12-12 13:36:38',NULL),(3716,8081,1483,41147,322666,2,13,1,9600.00,NULL,'2022-12-12 13:36:38','2022-12-12 13:36:38',NULL),(3717,8081,1484,41147,322667,2,218,2,9200.00,NULL,'2022-12-12 13:36:58','2022-12-12 13:36:58',NULL),(3718,8081,1484,41147,322667,2,13,1,9200.00,NULL,'2022-12-12 13:36:58','2022-12-12 13:36:58',NULL),(3719,8081,1485,41147,322667,2,218,2,2500.00,NULL,'2022-12-12 13:36:58','2022-12-12 13:36:58',NULL),(3720,8081,1485,41147,322667,2,13,1,2500.00,NULL,'2022-12-12 13:36:58','2022-12-12 13:36:58',NULL),(3721,8081,1486,41147,322667,2,218,2,4000.00,NULL,'2022-12-12 13:36:59','2022-12-12 13:36:59',NULL),(3722,8081,1486,41147,322667,2,13,1,4000.00,NULL,'2022-12-12 13:36:59','2022-12-12 13:36:59',NULL),(3723,8081,1487,41147,322667,2,218,2,9500.00,NULL,'2022-12-12 13:36:59','2022-12-12 13:36:59',NULL),(3724,8081,1487,41147,322667,2,13,1,9500.00,NULL,'2022-12-12 13:36:59','2022-12-12 13:36:59',NULL),(3725,8081,1488,41147,322667,2,218,2,9800.00,NULL,'2022-12-12 13:36:59','2022-12-12 13:36:59',NULL),(3726,8081,1488,41147,322667,2,13,1,9800.00,NULL,'2022-12-12 13:36:59','2022-12-12 13:36:59',NULL),(3727,8081,1489,41147,322667,2,218,2,2000.00,NULL,'2022-12-12 13:36:59','2022-12-12 13:36:59',NULL),(3728,8081,1489,41147,322667,2,13,1,2000.00,NULL,'2022-12-12 13:36:59','2022-12-12 13:36:59',NULL),(3729,8081,1490,41147,322668,2,218,2,5000.00,NULL,'2022-12-12 13:37:14','2022-12-12 13:37:14',NULL),(3730,8081,1490,41147,322668,2,13,1,5000.00,NULL,'2022-12-12 13:37:14','2022-12-12 13:37:14',NULL),(3731,8081,1491,41147,322668,2,218,2,9800.00,NULL,'2022-12-12 13:37:14','2022-12-12 13:37:14',NULL),(3732,8081,1491,41147,322668,2,13,1,9800.00,NULL,'2022-12-12 13:37:14','2022-12-12 13:37:14',NULL),(3733,8081,1492,41147,322668,2,218,2,9500.00,NULL,'2022-12-12 13:37:14','2022-12-12 13:37:14',NULL),(3734,8081,1492,41147,322668,2,13,1,9500.00,NULL,'2022-12-12 13:37:14','2022-12-12 13:37:14',NULL),(3735,8081,1493,41147,322668,2,218,2,4000.00,NULL,'2022-12-12 13:37:14','2022-12-12 13:37:14',NULL),(3736,8081,1493,41147,322668,2,13,1,4000.00,NULL,'2022-12-12 13:37:14','2022-12-12 13:37:14',NULL),(3737,8081,1494,41147,322668,2,218,2,9000.00,NULL,'2022-12-12 13:37:14','2022-12-12 13:37:14',NULL),(3738,8081,1494,41147,322668,2,13,1,9000.00,NULL,'2022-12-12 13:37:14','2022-12-12 13:37:14',NULL),(3739,8081,1495,41147,322669,2,218,2,4000.00,NULL,'2022-12-12 13:37:29','2022-12-12 13:37:29',NULL),(3740,8081,1495,41147,322669,2,13,1,4000.00,NULL,'2022-12-12 13:37:29','2022-12-12 13:37:29',NULL);
INSERT INTO `balance_libro_details` VALUES (3741,8081,1496,41147,322669,2,218,2,9500.00,NULL,'2022-12-12 13:37:29','2022-12-12 13:37:29',NULL),(3742,8081,1496,41147,322669,2,13,1,9500.00,NULL,'2022-12-12 13:37:29','2022-12-12 13:37:29',NULL),(3743,8081,1497,41147,322669,2,218,2,9500.00,NULL,'2022-12-12 13:37:29','2022-12-12 13:37:29',NULL),(3744,8081,1497,41147,322669,2,13,1,9500.00,NULL,'2022-12-12 13:37:29','2022-12-12 13:37:29',NULL),(3745,8081,1498,41147,322669,2,218,2,4500.00,NULL,'2022-12-12 13:37:29','2022-12-12 13:37:29',NULL),(3746,8081,1498,41147,322669,2,13,1,4500.00,NULL,'2022-12-12 13:37:29','2022-12-12 13:37:29',NULL),(3747,8081,1499,41147,322669,2,218,2,9800.00,NULL,'2022-12-12 13:37:29','2022-12-12 13:37:29',NULL),(3748,8081,1499,41147,322669,2,13,1,9800.00,NULL,'2022-12-12 13:37:29','2022-12-12 13:37:29',NULL),(3749,8081,1500,41147,322670,2,218,2,9500.00,NULL,'2022-12-12 13:37:45','2022-12-12 13:37:45',NULL),(3750,8081,1500,41147,322670,2,13,1,9500.00,NULL,'2022-12-12 13:37:45','2022-12-12 13:37:45',NULL),(3751,8081,1501,41147,322670,2,218,2,18500.00,NULL,'2022-12-12 13:37:45','2022-12-12 13:37:45',NULL),(3752,8081,1501,41147,322670,2,13,1,18500.00,NULL,'2022-12-12 13:37:45','2022-12-12 13:37:45',NULL),(3753,8081,1502,41147,322670,2,218,2,5000.00,NULL,'2022-12-12 13:37:45','2022-12-12 13:37:45',NULL),(3754,8081,1502,41147,322670,2,13,1,5000.00,NULL,'2022-12-12 13:37:45','2022-12-12 13:37:45',NULL),(3755,8081,1503,41147,322671,2,218,2,5000.00,NULL,'2022-12-12 13:37:59','2022-12-12 13:37:59',NULL),(3756,8081,1503,41147,322671,2,13,1,5000.00,NULL,'2022-12-12 13:37:59','2022-12-12 13:37:59',NULL),(3757,8081,1504,41147,322671,2,218,2,30000.00,NULL,'2022-12-12 13:37:59','2022-12-12 13:37:59',NULL),(3758,8081,1504,41147,322671,2,13,1,30000.00,NULL,'2022-12-12 13:37:59','2022-12-12 13:37:59',NULL),(3759,8081,1505,41147,322671,2,218,2,2000.00,NULL,'2022-12-12 13:37:59','2022-12-12 13:37:59',NULL),(3760,8081,1505,41147,322671,2,13,1,2000.00,NULL,'2022-12-12 13:37:59','2022-12-12 13:37:59',NULL),(3761,8081,1506,41147,322672,2,218,2,3000.00,NULL,'2022-12-12 13:38:13','2022-12-12 13:38:13',NULL),(3762,8081,1506,41147,322672,2,13,1,3000.00,NULL,'2022-12-12 13:38:13','2022-12-12 13:38:13',NULL),(3763,8081,1507,41147,322672,2,218,2,30000.00,NULL,'2022-12-12 13:38:13','2022-12-12 13:38:13',NULL),(3764,8081,1507,41147,322672,2,13,1,30000.00,NULL,'2022-12-12 13:38:13','2022-12-12 13:38:13',NULL),(3765,8081,1508,41068,293823,2,218,2,20000.00,NULL,'2022-12-12 15:58:02','2022-12-12 15:58:02',NULL),(3766,8081,1508,41068,293823,2,13,1,20000.00,NULL,'2022-12-12 15:58:02','2022-12-12 15:58:02',NULL),(3767,8081,1509,41068,293823,2,218,2,2500.00,NULL,'2022-12-12 15:58:02','2022-12-12 15:58:02',NULL),(3768,8081,1509,41068,293823,2,13,1,2500.00,NULL,'2022-12-12 15:58:02','2022-12-12 15:58:02',NULL),(3769,8081,1510,41068,293823,2,218,2,22000.00,NULL,'2022-12-12 15:58:02','2022-12-12 15:58:02',NULL),(3770,8081,1510,41068,293823,2,13,1,22000.00,NULL,'2022-12-12 15:58:02','2022-12-12 15:58:02',NULL),(3771,8081,1511,41068,293823,2,218,2,26000.00,NULL,'2022-12-12 15:58:02','2022-12-12 15:58:02',NULL),(3772,8081,1511,41068,293823,2,13,1,26000.00,NULL,'2022-12-12 15:58:02','2022-12-12 15:58:02',NULL),(3773,8081,1512,41068,293824,2,218,2,30000.00,NULL,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL),(3774,8081,1512,41068,293824,2,13,1,30000.00,NULL,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL),(3775,8081,1513,41068,293824,2,218,2,25000.00,NULL,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL),(3776,8081,1513,41068,293824,2,13,1,25000.00,NULL,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL),(3777,8081,1514,41068,293824,2,218,2,500.00,NULL,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL),(3778,8081,1514,41068,293824,2,13,1,500.00,NULL,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL),(3779,8081,1515,41068,293824,2,218,2,6000.00,NULL,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL),(3780,8081,1515,41068,293824,2,13,1,6000.00,NULL,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL);
INSERT INTO `balance_libro_details` VALUES (3781,8081,1516,41068,293824,2,218,2,7000.00,NULL,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL),(3782,8081,1516,41068,293824,2,13,1,7000.00,NULL,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL),(3783,8081,1517,41068,293824,2,218,2,2500.00,NULL,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL),(3784,8081,1517,41068,293824,2,13,1,2500.00,NULL,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL),(3785,8081,1518,41068,293824,2,218,2,5500.00,NULL,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL),(3786,8081,1518,41068,293824,2,13,1,5500.00,NULL,'2022-12-12 15:58:20','2022-12-12 15:58:20',NULL),(3787,8081,1519,41068,293825,2,218,2,2500.00,NULL,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(3788,8081,1519,41068,293825,2,13,1,2500.00,NULL,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(3789,8081,1520,41068,293825,2,218,2,10000.00,NULL,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(3790,8081,1520,41068,293825,2,13,1,10000.00,NULL,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(3791,8081,1521,41068,293825,2,218,2,16000.00,NULL,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(3792,8081,1521,41068,293825,2,13,1,16000.00,NULL,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(3793,8081,1522,41068,293825,2,218,2,2500.00,NULL,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(3794,8081,1522,41068,293825,2,13,1,2500.00,NULL,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(3795,8081,1523,41068,293825,2,218,2,10000.00,NULL,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(3796,8081,1523,41068,293825,2,13,1,10000.00,NULL,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(3797,8081,1524,41068,293825,2,218,2,30700.00,NULL,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(3798,8081,1524,41068,293825,2,13,1,30700.00,NULL,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(3799,8081,1525,41068,293825,2,218,2,8000.00,NULL,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(3800,8081,1525,41068,293825,2,13,1,8000.00,NULL,'2022-12-12 15:58:37','2022-12-12 15:58:37',NULL),(3801,8081,1526,41068,293826,2,218,2,24000.00,NULL,'2022-12-12 15:59:00','2022-12-12 15:59:00',NULL),(3802,8081,1526,41068,293826,2,13,1,24000.00,NULL,'2022-12-12 15:59:00','2022-12-12 15:59:00',NULL),(3803,8081,1527,41068,293826,2,218,2,3500.00,NULL,'2022-12-12 15:59:00','2022-12-12 15:59:00',NULL),(3804,8081,1527,41068,293826,2,13,1,3500.00,NULL,'2022-12-12 15:59:00','2022-12-12 15:59:00',NULL),(3805,8081,1528,41068,293826,2,218,2,20000.00,NULL,'2022-12-12 15:59:00','2022-12-12 15:59:00',NULL),(3806,8081,1528,41068,293826,2,13,1,20000.00,NULL,'2022-12-12 15:59:00','2022-12-12 15:59:00',NULL),(3807,8081,1529,41068,293826,2,218,2,40000.00,NULL,'2022-12-12 15:59:00','2022-12-12 15:59:00',NULL),(3808,8081,1529,41068,293826,2,13,1,40000.00,NULL,'2022-12-12 15:59:00','2022-12-12 15:59:00',NULL),(3809,8081,1530,41068,293827,2,218,2,39560.00,NULL,'2022-12-12 15:59:18','2022-12-12 15:59:18',NULL),(3810,8081,1530,41068,293827,2,13,1,39560.00,NULL,'2022-12-12 15:59:18','2022-12-12 15:59:18',NULL),(3811,8081,1531,41068,293827,2,218,2,2500.00,NULL,'2022-12-12 15:59:18','2022-12-12 15:59:18',NULL),(3812,8081,1531,41068,293827,2,13,1,2500.00,NULL,'2022-12-12 15:59:18','2022-12-12 15:59:18',NULL),(3813,8081,1532,41068,293827,2,218,2,2500.00,NULL,'2022-12-12 15:59:18','2022-12-12 15:59:18',NULL),(3814,8081,1532,41068,293827,2,13,1,2500.00,NULL,'2022-12-12 15:59:18','2022-12-12 15:59:18',NULL),(3815,8081,1533,41068,293827,2,218,2,22000.00,NULL,'2022-12-12 15:59:18','2022-12-12 15:59:18',NULL),(3816,8081,1533,41068,293827,2,13,1,22000.00,NULL,'2022-12-12 15:59:18','2022-12-12 15:59:18',NULL),(3817,8081,1534,41068,293827,2,218,2,10500.00,NULL,'2022-12-12 15:59:18','2022-12-12 15:59:18',NULL),(3818,8081,1534,41068,293827,2,13,1,10500.00,NULL,'2022-12-12 15:59:18','2022-12-12 15:59:18',NULL),(3819,8081,1535,41068,293827,2,218,2,22000.00,NULL,'2022-12-12 15:59:18','2022-12-12 15:59:18',NULL),(3820,8081,1535,41068,293827,2,13,1,22000.00,NULL,'2022-12-12 15:59:18','2022-12-12 15:59:18',NULL);
INSERT INTO `balance_libro_details` VALUES (3821,8081,1536,41068,293829,2,218,2,5000.00,NULL,'2022-12-12 16:00:12','2022-12-12 16:00:12',NULL),(3822,8081,1536,41068,293829,2,13,1,5000.00,NULL,'2022-12-12 16:00:12','2022-12-12 16:00:12',NULL),(3823,8081,1537,41068,293829,2,218,2,20000.00,NULL,'2022-12-12 16:00:12','2022-12-12 16:00:12',NULL),(3824,8081,1537,41068,293829,2,13,1,20000.00,NULL,'2022-12-12 16:00:12','2022-12-12 16:00:12',NULL),(3825,8081,1538,41068,293829,2,218,2,20000.00,NULL,'2022-12-12 16:00:12','2022-12-12 16:00:12',NULL),(3826,8081,1538,41068,293829,2,13,1,20000.00,NULL,'2022-12-12 16:00:12','2022-12-12 16:00:12',NULL),(3827,8081,1539,41068,293829,2,218,2,16000.00,NULL,'2022-12-12 16:00:12','2022-12-12 16:00:12',NULL),(3828,8081,1539,41068,293829,2,13,1,16000.00,NULL,'2022-12-12 16:00:12','2022-12-12 16:00:12',NULL),(3829,8081,1540,41068,293829,2,218,2,50000.00,NULL,'2022-12-12 16:00:12','2022-12-12 16:00:12',NULL),(3830,8081,1540,41068,293829,2,13,1,50000.00,NULL,'2022-12-12 16:00:12','2022-12-12 16:00:12',NULL),(3831,8081,1541,41068,293830,2,218,2,21600.00,NULL,'2022-12-12 16:00:33','2022-12-12 16:00:33',NULL),(3832,8081,1541,41068,293830,2,13,1,21600.00,NULL,'2022-12-12 16:00:33','2022-12-12 16:00:33',NULL),(3833,8081,1542,41068,293830,2,218,2,10000.00,NULL,'2022-12-12 16:00:33','2022-12-12 16:00:33',NULL),(3834,8081,1542,41068,293830,2,13,1,10000.00,NULL,'2022-12-12 16:00:33','2022-12-12 16:00:33',NULL),(3835,8081,1543,41068,293830,2,218,2,12000.00,NULL,'2022-12-12 16:00:33','2022-12-12 16:00:33',NULL),(3836,8081,1543,41068,293830,2,13,1,12000.00,NULL,'2022-12-12 16:00:33','2022-12-12 16:00:33',NULL),(3837,8081,1544,41068,293830,2,218,2,80000.00,NULL,'2022-12-12 16:00:33','2022-12-12 16:00:33',NULL),(3838,8081,1544,41068,293830,2,13,1,80000.00,NULL,'2022-12-12 16:00:33','2022-12-12 16:00:33',NULL),(3839,8081,1545,41068,293831,2,218,2,10000.00,NULL,'2022-12-12 16:00:49','2022-12-12 16:00:49',NULL),(3840,8081,1545,41068,293831,2,13,1,10000.00,NULL,'2022-12-12 16:00:49','2022-12-12 16:00:49',NULL),(3841,8081,1546,41068,293831,2,218,2,25000.00,NULL,'2022-12-12 16:00:49','2022-12-12 16:00:49',NULL),(3842,8081,1546,41068,293831,2,13,1,25000.00,NULL,'2022-12-12 16:00:49','2022-12-12 16:00:49',NULL),(3843,8081,1547,41068,293831,2,218,2,11500.00,NULL,'2022-12-12 16:00:49','2022-12-12 16:00:49',NULL),(3844,8081,1547,41068,293831,2,13,1,11500.00,NULL,'2022-12-12 16:00:49','2022-12-12 16:00:49',NULL),(3845,8081,1548,41068,293831,2,218,2,4000.00,NULL,'2022-12-12 16:00:49','2022-12-12 16:00:49',NULL),(3846,8081,1548,41068,293831,2,13,1,4000.00,NULL,'2022-12-12 16:00:49','2022-12-12 16:00:49',NULL),(3847,8081,1549,41068,293831,2,218,2,20000.00,NULL,'2022-12-12 16:00:49','2022-12-12 16:00:49',NULL),(3848,8081,1549,41068,293831,2,13,1,20000.00,NULL,'2022-12-12 16:00:49','2022-12-12 16:00:49',NULL),(3849,8081,1550,41068,293831,2,218,2,41000.00,NULL,'2022-12-12 16:00:49','2022-12-12 16:00:49',NULL),(3850,8081,1550,41068,293831,2,13,1,41000.00,NULL,'2022-12-12 16:00:49','2022-12-12 16:00:49',NULL),(3851,8081,1551,41068,293832,2,218,2,33000.00,NULL,'2022-12-12 16:01:06','2022-12-12 16:01:06',NULL),(3852,8081,1551,41068,293832,2,13,1,33000.00,NULL,'2022-12-12 16:01:06','2022-12-12 16:01:06',NULL),(3853,8081,1552,41068,293832,2,218,2,18000.00,NULL,'2022-12-12 16:01:06','2022-12-12 16:01:06',NULL),(3854,8081,1552,41068,293832,2,13,1,18000.00,NULL,'2022-12-12 16:01:06','2022-12-12 16:01:06',NULL),(3855,8081,1553,41068,293832,2,218,2,26000.00,NULL,'2022-12-12 16:01:06','2022-12-12 16:01:06',NULL),(3856,8081,1553,41068,293832,2,13,1,26000.00,NULL,'2022-12-12 16:01:06','2022-12-12 16:01:06',NULL),(3857,8081,1554,41068,293832,2,218,2,14000.00,NULL,'2022-12-12 16:01:06','2022-12-12 16:01:06',NULL),(3858,8081,1554,41068,293832,2,13,1,14000.00,NULL,'2022-12-12 16:01:06','2022-12-12 16:01:06',NULL),(3859,8081,1555,41068,293832,2,218,2,6000.00,NULL,'2022-12-12 16:01:06','2022-12-12 16:01:06',NULL);
INSERT INTO `balance_libro_details` VALUES (3860,8081,1555,41068,293832,2,13,1,6000.00,NULL,'2022-12-12 16:01:06','2022-12-12 16:01:06',NULL),(3861,8081,1556,41068,293833,2,218,2,6000.00,NULL,'2022-12-12 16:01:27','2022-12-12 16:01:27',NULL),(3862,8081,1556,41068,293833,2,13,1,6000.00,NULL,'2022-12-12 16:01:27','2022-12-12 16:01:27',NULL),(3863,8081,1557,41068,293833,2,218,2,18000.00,NULL,'2022-12-12 16:01:27','2022-12-12 16:01:27',NULL),(3864,8081,1557,41068,293833,2,13,1,18000.00,NULL,'2022-12-12 16:01:27','2022-12-12 16:01:27',NULL),(3865,8081,1558,41068,293833,2,218,2,18000.00,NULL,'2022-12-12 16:01:27','2022-12-12 16:01:27',NULL),(3866,8081,1558,41068,293833,2,13,1,18000.00,NULL,'2022-12-12 16:01:27','2022-12-12 16:01:27',NULL),(3867,8081,1559,41068,293833,2,218,2,70000.00,NULL,'2022-12-12 16:01:27','2022-12-12 16:01:27',NULL),(3868,8081,1559,41068,293833,2,13,1,70000.00,NULL,'2022-12-12 16:01:27','2022-12-12 16:01:27',NULL),(3869,8081,1560,41068,293833,2,218,2,10000.00,NULL,'2022-12-12 16:01:28','2022-12-12 16:01:28',NULL),(3870,8081,1560,41068,293833,2,13,1,10000.00,NULL,'2022-12-12 16:01:28','2022-12-12 16:01:28',NULL),(3871,8081,1561,41068,293833,2,218,2,20000.00,NULL,'2022-12-12 16:01:28','2022-12-12 16:01:28',NULL),(3872,8081,1561,41068,293833,2,13,1,20000.00,NULL,'2022-12-12 16:01:28','2022-12-12 16:01:28',NULL),(3873,8081,1562,41068,293833,2,218,2,18000.00,NULL,'2022-12-12 16:01:28','2022-12-12 16:01:28',NULL),(3874,8081,1562,41068,293833,2,13,1,18000.00,NULL,'2022-12-12 16:01:28','2022-12-12 16:01:28',NULL),(3875,8081,1563,41068,293833,2,218,2,12000.00,NULL,'2022-12-12 16:01:28','2022-12-12 16:01:28',NULL),(3876,8081,1563,41068,293833,2,13,1,12000.00,NULL,'2022-12-12 16:01:28','2022-12-12 16:01:28',NULL),(3877,8081,1564,41068,293823,3,217,1,198.35,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3878,8081,1564,41068,293823,3,68,1,41.65,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3879,8081,1564,41068,293823,3,57,2,240.00,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3880,8081,1565,41068,293823,3,217,1,2809.92,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3881,8081,1565,41068,293823,3,68,1,590.08,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3882,8081,1565,41068,293823,3,57,2,3400.00,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3883,8081,1566,41068,293823,3,217,1,743.80,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3884,8081,1566,41068,293823,3,68,1,156.20,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3885,8081,1566,41068,293823,3,57,2,900.00,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3886,8081,1567,41068,293823,3,217,1,1237.07,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3887,8081,1567,41068,293823,3,68,1,259.78,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3888,8081,1567,41068,293823,3,57,2,1496.85,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3889,8081,1568,41068,293823,3,217,1,743.80,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3890,8081,1568,41068,293823,3,68,1,156.20,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3891,8081,1568,41068,293823,3,57,2,900.00,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3892,8081,1569,41068,293823,3,217,1,10537.20,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3893,8081,1569,41068,293823,3,68,1,2212.81,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3894,8081,1569,41068,293823,3,57,2,12750.01,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3895,8081,1570,41068,293823,3,217,1,991.72,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3896,8081,1570,41068,293823,3,68,1,208.26,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3897,8081,1570,41068,293823,3,57,2,1199.98,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3898,8081,1571,41068,293823,3,217,1,743.79,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3899,8081,1571,41068,293823,3,68,1,156.20,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL);
INSERT INTO `balance_libro_details` VALUES (3900,8081,1571,41068,293823,3,57,2,899.99,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3901,8081,1572,41068,293823,3,217,1,1983.45,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3902,8081,1572,41068,293823,3,68,1,416.52,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3903,8081,1572,41068,293823,3,57,2,2399.97,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3904,8081,1573,41068,293823,3,217,1,1446280.99,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3905,8081,1573,41068,293823,3,68,1,303719.01,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3906,8081,1573,41068,293823,3,57,2,1750000.00,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3907,8081,1574,41068,293823,3,217,1,247.93,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3908,8081,1574,41068,293823,3,68,1,52.07,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3909,8081,1574,41068,293823,3,57,2,300.00,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3910,8081,1575,41068,293823,3,217,1,247.93,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3911,8081,1575,41068,293823,3,68,1,52.07,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3912,8081,1575,41068,293823,3,57,2,300.00,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3913,8081,1576,41068,293823,3,217,1,495.86,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3914,8081,1576,41068,293823,3,68,1,104.13,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3915,8081,1576,41068,293823,3,57,2,599.99,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3916,8081,1577,41068,293823,3,217,1,40.74,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3917,8081,1577,41068,293823,3,68,1,8.56,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3918,8081,1577,41068,293823,3,57,2,49.30,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3919,8081,1578,41068,293823,3,217,1,40.74,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3920,8081,1578,41068,293823,3,68,1,8.56,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3921,8081,1578,41068,293823,3,57,2,49.30,NULL,'2022-12-12 16:17:13','2022-12-12 16:17:13',NULL),(3922,8081,1579,41068,293823,3,217,1,247.93,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3923,8081,1579,41068,293823,3,68,1,52.07,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3924,8081,1579,41068,293823,3,57,2,300.00,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3925,8081,1580,41068,293823,3,217,1,869.42,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3926,8081,1580,41068,293823,3,68,1,182.58,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3927,8081,1580,41068,293823,3,57,2,1052.00,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3928,8081,1581,41068,293823,3,217,1,1404.96,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3929,8081,1581,41068,293823,3,68,1,295.04,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3930,8081,1581,41068,293823,3,57,2,1700.00,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3931,8081,1582,41068,293823,3,217,1,8263.64,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3932,8081,1582,41068,293823,3,68,1,1735.36,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3933,8081,1582,41068,293823,3,57,2,9999.00,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3934,8081,1583,41068,293823,3,217,1,247.93,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3935,8081,1583,41068,293823,3,68,1,52.07,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3936,8081,1583,41068,293823,3,57,2,300.00,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3937,8081,1584,41068,293823,3,217,1,743.79,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3938,8081,1584,41068,293823,3,68,1,156.20,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3939,8081,1584,41068,293823,3,57,2,899.99,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL);
INSERT INTO `balance_libro_details` VALUES (3940,8081,1585,41068,293823,3,217,1,991.73,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3941,8081,1585,41068,293823,3,68,1,208.26,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3942,8081,1585,41068,293823,3,57,2,1199.99,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3943,8081,1586,41068,293823,3,217,1,247.93,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3944,8081,1586,41068,293823,3,68,1,52.07,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3945,8081,1586,41068,293823,3,57,2,300.00,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3946,8081,1587,41068,293823,3,217,1,495.86,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3947,8081,1587,41068,293823,3,68,1,104.13,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3948,8081,1587,41068,293823,3,57,2,599.99,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3949,8081,1588,41068,293823,3,217,1,247.93,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3950,8081,1588,41068,293823,3,68,1,52.07,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3951,8081,1588,41068,293823,3,57,2,300.00,NULL,'2022-12-12 16:17:14','2022-12-12 16:17:14',NULL),(3952,8081,1589,41068,293824,3,217,1,495.86,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3953,8081,1589,41068,293824,3,68,1,104.13,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3954,8081,1589,41068,293824,3,57,2,599.99,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3955,8081,1590,41068,293824,3,217,1,247.93,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3956,8081,1590,41068,293824,3,68,1,52.07,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3957,8081,1590,41068,293824,3,57,2,300.00,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3958,8081,1591,41068,293824,3,217,1,532.89,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3959,8081,1591,41068,293824,3,68,1,111.91,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3960,8081,1591,41068,293824,3,57,2,644.80,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3961,8081,1592,41068,293824,3,217,1,743.80,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3962,8081,1592,41068,293824,3,68,1,156.20,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3963,8081,1592,41068,293824,3,57,2,900.00,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3964,8081,1593,41068,293824,3,217,1,107.35,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3965,8081,1593,41068,293824,3,68,1,22.55,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3966,8081,1593,41068,293824,3,57,2,129.90,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3967,8081,1594,41068,293824,3,217,1,991.72,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3968,8081,1594,41068,293824,3,68,1,208.26,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3969,8081,1594,41068,293824,3,57,2,1199.98,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3970,8081,1595,41068,293824,3,217,1,495.86,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3971,8081,1595,41068,293824,3,68,1,104.13,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3972,8081,1595,41068,293824,3,57,2,599.99,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3973,8081,1596,41068,293824,3,217,1,495.86,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3974,8081,1596,41068,293824,3,68,1,104.13,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3975,8081,1596,41068,293824,3,57,2,599.99,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3976,8081,1597,41068,293824,3,217,1,247.93,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3977,8081,1597,41068,293824,3,68,1,52.07,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3978,8081,1597,41068,293824,3,57,2,300.00,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3979,8081,1598,41068,293824,3,217,1,991.73,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL);
INSERT INTO `balance_libro_details` VALUES (3980,8081,1598,41068,293824,3,68,1,208.26,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3981,8081,1598,41068,293824,3,57,2,1199.99,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3982,8081,1599,41068,293824,3,217,1,743.79,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3983,8081,1599,41068,293824,3,68,1,156.20,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3984,8081,1599,41068,293824,3,57,2,899.99,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3985,8081,1600,41068,293824,3,217,1,495.86,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3986,8081,1600,41068,293824,3,68,1,104.13,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3987,8081,1600,41068,293824,3,57,2,599.99,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3988,8081,1601,41068,293824,3,217,1,231.62,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3989,8081,1601,41068,293824,3,68,1,48.64,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3990,8081,1601,41068,293824,3,217,1,23.16,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3991,8081,1601,41068,293824,3,57,2,303.42,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3992,8081,1602,41068,293824,3,217,1,495.86,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3993,8081,1602,41068,293824,3,68,1,104.13,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3994,8081,1602,41068,293824,3,57,2,599.99,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3995,8081,1603,41068,293824,3,217,1,74.71,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3996,8081,1603,41068,293824,3,68,1,15.69,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3997,8081,1603,41068,293824,3,57,2,90.40,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3998,8081,1604,41068,293824,3,217,1,289.26,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(3999,8081,1604,41068,293824,3,68,1,60.74,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(4000,8081,1604,41068,293824,3,57,2,350.00,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(4001,8081,1605,41068,293824,3,217,1,1299.17,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(4002,8081,1605,41068,293824,3,68,1,272.83,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(4003,8081,1605,41068,293824,3,57,2,1572.00,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(4004,8081,1606,41068,293824,3,217,1,743.79,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(4005,8081,1606,41068,293824,3,68,1,156.20,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(4006,8081,1606,41068,293824,3,57,2,899.99,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(4007,8081,1607,41068,293824,3,217,1,991.72,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(4008,8081,1607,41068,293824,3,68,1,208.26,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(4009,8081,1607,41068,293824,3,57,2,1199.98,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(4010,8081,1608,41068,293824,3,217,1,495.86,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(4011,8081,1608,41068,293824,3,68,1,104.13,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(4012,8081,1608,41068,293824,3,57,2,599.99,NULL,'2022-12-12 16:17:36','2022-12-12 16:17:36',NULL),(4013,8081,1609,41068,293825,3,217,1,991.72,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4014,8081,1609,41068,293825,3,68,1,208.26,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4015,8081,1609,41068,293825,3,57,2,1199.98,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4016,8081,1610,41068,293825,3,217,1,134.71,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4017,8081,1610,41068,293825,3,68,1,28.29,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4018,8081,1610,41068,293825,3,57,2,163.00,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4019,8081,1611,41068,293825,3,217,1,743.79,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL);
INSERT INTO `balance_libro_details` VALUES (4020,8081,1611,41068,293825,3,68,1,156.20,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4021,8081,1611,41068,293825,3,57,2,899.99,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4022,8081,1612,41068,293825,3,217,1,247.93,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4023,8081,1612,41068,293825,3,68,1,52.07,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4024,8081,1612,41068,293825,3,57,2,300.00,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4025,8081,1613,41068,293825,3,217,1,495.86,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4026,8081,1613,41068,293825,3,68,1,104.13,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4027,8081,1613,41068,293825,3,57,2,599.99,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4028,8081,1614,41068,293825,3,217,1,533.06,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4029,8081,1614,41068,293825,3,68,1,111.94,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4030,8081,1614,41068,293825,3,57,2,645.00,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4031,8081,1615,41068,293825,3,217,1,247.93,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4032,8081,1615,41068,293825,3,68,1,52.07,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4033,8081,1615,41068,293825,3,57,2,300.00,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4034,8081,1616,41068,293825,3,217,1,247.93,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4035,8081,1616,41068,293825,3,68,1,52.07,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4036,8081,1616,41068,293825,3,57,2,300.00,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4037,8081,1617,41068,293825,3,217,1,463.64,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4038,8081,1617,41068,293825,3,68,1,97.36,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4039,8081,1617,41068,293825,3,57,2,561.00,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4040,8081,1618,41068,293825,3,217,1,247.93,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4041,8081,1618,41068,293825,3,68,1,52.07,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4042,8081,1618,41068,293825,3,57,2,300.00,NULL,'2022-12-12 16:17:58','2022-12-12 16:17:58',NULL),(4043,8081,1619,41068,293825,3,217,1,495.86,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4044,8081,1619,41068,293825,3,68,1,104.13,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4045,8081,1619,41068,293825,3,57,2,599.99,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4046,8081,1620,41068,293825,3,217,1,1239.66,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4047,8081,1620,41068,293825,3,68,1,260.33,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4048,8081,1620,41068,293825,3,57,2,1499.99,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4049,8081,1621,41068,293825,3,217,1,9372.73,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4050,8081,1621,41068,293825,3,68,1,1968.27,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4051,8081,1621,41068,293825,3,57,2,11341.00,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4052,8081,1622,41068,293825,3,217,1,67195.86,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4053,8081,1622,41068,293825,3,68,1,14111.13,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4054,8081,1622,41068,293825,3,57,2,81306.99,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4055,8081,1623,41068,293825,3,217,1,1745.45,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4056,8081,1623,41068,293825,3,68,1,366.54,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4057,8081,1623,41068,293825,3,217,1,0.01,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4058,8081,1623,41068,293825,3,57,2,2112.00,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4059,8081,1624,41068,293825,3,217,1,1239.66,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL);
INSERT INTO `balance_libro_details` VALUES (4060,8081,1624,41068,293825,3,68,1,260.33,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4061,8081,1624,41068,293825,3,57,2,1499.99,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4062,8081,1625,41068,293825,3,217,1,495.87,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4063,8081,1625,41068,293825,3,68,1,104.13,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4064,8081,1625,41068,293825,3,57,2,600.00,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4065,8081,1626,41068,293825,3,217,1,1983.46,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4066,8081,1626,41068,293825,3,68,1,416.53,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4067,8081,1626,41068,293825,3,57,2,2399.99,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4068,8081,1627,41068,293825,3,217,1,495.86,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4069,8081,1627,41068,293825,3,68,1,104.13,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4070,8081,1627,41068,293825,3,57,2,599.99,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4071,8081,1628,41068,293825,3,217,2,67195.86,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4072,8081,1628,41068,293825,3,67,2,14111.13,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4073,8081,1628,41068,293825,3,57,1,81306.99,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4074,8081,1629,41068,293825,3,217,1,2107.44,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4075,8081,1629,41068,293825,3,68,1,442.56,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4076,8081,1629,41068,293825,3,57,2,2550.00,NULL,'2022-12-12 16:17:59','2022-12-12 16:17:59',NULL),(4077,8081,1630,41068,293826,3,217,1,54.54,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4078,8081,1630,41068,293826,3,68,1,11.46,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4079,8081,1630,41068,293826,3,57,2,66.00,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4080,8081,1631,41068,293826,3,217,1,56.20,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4081,8081,1631,41068,293826,3,68,1,11.80,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4082,8081,1631,41068,293826,3,57,2,68.00,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4083,8081,1632,41068,293826,3,217,1,1487.60,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4084,8081,1632,41068,293826,3,68,1,312.40,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4085,8081,1632,41068,293826,3,57,2,1800.00,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4086,8081,1633,41068,293826,3,217,1,7727.28,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4087,8081,1633,41068,293826,3,68,1,1622.73,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4088,8081,1633,41068,293826,3,57,2,9350.01,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4089,8081,1634,41068,293826,3,217,1,743.80,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4090,8081,1634,41068,293826,3,68,1,156.20,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4091,8081,1634,41068,293826,3,57,2,900.00,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4092,8081,1635,41068,293826,3,217,1,1404.96,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4093,8081,1635,41068,293826,3,68,1,295.04,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4094,8081,1635,41068,293826,3,57,2,1700.00,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4095,8081,1636,41068,293826,3,217,1,1249.59,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4096,8081,1636,41068,293826,3,68,1,262.41,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4097,8081,1636,41068,293826,3,57,2,1512.00,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4098,8081,1637,41068,293826,3,217,1,2107.44,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4099,8081,1637,41068,293826,3,68,1,442.56,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL);
INSERT INTO `balance_libro_details` VALUES (4100,8081,1637,41068,293826,3,57,2,2550.00,NULL,'2022-12-12 16:18:16','2022-12-12 16:18:16',NULL),(4101,8081,1638,41068,293826,3,217,1,743.80,NULL,'2022-12-12 16:18:17','2022-12-12 16:18:17',NULL),(4102,8081,1638,41068,293826,3,68,1,156.20,NULL,'2022-12-12 16:18:17','2022-12-12 16:18:17',NULL),(4103,8081,1638,41068,293826,3,57,2,900.00,NULL,'2022-12-12 16:18:17','2022-12-12 16:18:17',NULL),(4104,8081,1639,41068,293826,3,217,1,5619.84,NULL,'2022-12-12 16:18:17','2022-12-12 16:18:17',NULL),(4105,8081,1639,41068,293826,3,68,1,1180.17,NULL,'2022-12-12 16:18:17','2022-12-12 16:18:17',NULL),(4106,8081,1639,41068,293826,3,57,2,6800.01,NULL,'2022-12-12 16:18:17','2022-12-12 16:18:17',NULL),(4107,8081,1640,41068,293827,3,217,1,231.62,NULL,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(4108,8081,1640,41068,293827,3,68,1,48.64,NULL,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(4109,8081,1640,41068,293827,3,217,1,23.16,NULL,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(4110,8081,1640,41068,293827,3,57,2,303.42,NULL,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(4111,8081,1641,41068,293827,3,217,1,54.54,NULL,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(4112,8081,1641,41068,293827,3,68,1,11.46,NULL,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(4113,8081,1641,41068,293827,3,57,2,66.00,NULL,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(4114,8081,1642,41068,293827,3,217,1,56.20,NULL,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(4115,8081,1642,41068,293827,3,68,1,11.80,NULL,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(4116,8081,1642,41068,293827,3,57,2,68.00,NULL,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(4117,8081,1643,41068,293827,3,217,1,743.80,NULL,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(4118,8081,1643,41068,293827,3,68,1,156.20,NULL,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(4119,8081,1643,41068,293827,3,57,2,900.00,NULL,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(4120,8081,1644,41068,293827,3,217,1,1239.67,NULL,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(4121,8081,1644,41068,293827,3,68,1,260.33,NULL,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(4122,8081,1644,41068,293827,3,57,2,1500.00,NULL,'2022-12-12 16:18:36','2022-12-12 16:18:36',NULL),(4123,8081,1645,41068,293827,3,217,1,743.80,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4124,8081,1645,41068,293827,3,68,1,156.20,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4125,8081,1645,41068,293827,3,57,2,900.00,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4126,8081,1646,41068,293827,3,217,1,7727.28,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4127,8081,1646,41068,293827,3,68,1,1622.73,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4128,8081,1646,41068,293827,3,57,2,9350.01,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4129,8081,1647,41068,293827,3,217,1,6317.36,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4130,8081,1647,41068,293827,3,68,1,1326.65,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4131,8081,1647,41068,293827,3,57,2,7644.01,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4132,8081,1648,41068,293827,3,217,1,4214.88,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4133,8081,1648,41068,293827,3,68,1,885.12,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4134,8081,1648,41068,293827,3,57,2,5100.00,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4135,8081,1649,41068,293827,3,217,1,168.60,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4136,8081,1649,41068,293827,3,68,1,35.40,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4137,8081,1649,41068,293827,3,57,2,204.00,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4138,8081,1650,41068,293827,3,217,1,190.91,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4139,8081,1650,41068,293827,3,68,1,40.09,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL);
INSERT INTO `balance_libro_details` VALUES (4140,8081,1650,41068,293827,3,57,2,231.00,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4141,8081,1651,41068,293827,3,217,1,330.58,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4142,8081,1651,41068,293827,3,68,1,69.42,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4143,8081,1651,41068,293827,3,57,2,400.00,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4144,8081,1652,41068,293827,3,217,1,702.48,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4145,8081,1652,41068,293827,3,68,1,147.52,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4146,8081,1652,41068,293827,3,57,2,850.00,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4147,8081,1653,41068,293827,3,217,1,1018.18,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4148,8081,1653,41068,293827,3,68,1,213.82,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4149,8081,1653,41068,293827,3,57,2,1232.00,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4150,8081,1654,41068,293827,3,217,1,1405.05,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4151,8081,1654,41068,293827,3,68,1,295.06,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4152,8081,1654,41068,293827,3,57,2,1700.11,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4153,8081,1655,41068,293827,3,217,1,11700.83,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4154,8081,1655,41068,293827,3,68,1,2457.17,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4155,8081,1655,41068,293827,3,57,2,14158.00,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4156,8081,1656,41068,293827,3,217,1,743.80,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4157,8081,1656,41068,293827,3,68,1,156.20,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4158,8081,1656,41068,293827,3,57,2,900.00,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4159,8081,1657,41068,293827,3,217,1,4214.88,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4160,8081,1657,41068,293827,3,68,1,885.12,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4161,8081,1657,41068,293827,3,57,2,5100.00,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4162,8081,1658,41068,293827,3,217,1,7850.41,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4163,8081,1658,41068,293827,3,68,1,1648.59,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4164,8081,1658,41068,293827,3,57,2,9499.00,NULL,'2022-12-12 16:18:37','2022-12-12 16:18:37',NULL),(4165,8081,1659,41068,293828,3,217,1,3284.30,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4166,8081,1659,41068,293828,3,68,1,689.70,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4167,8081,1659,41068,293828,3,57,2,3974.00,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4168,8081,1660,41068,293828,3,217,1,743.80,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4169,8081,1660,41068,293828,3,68,1,156.20,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4170,8081,1660,41068,293828,3,57,2,900.00,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4171,8081,1661,41068,293828,3,217,1,112.40,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4172,8081,1661,41068,293828,3,68,1,23.60,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4173,8081,1661,41068,293828,3,57,2,136.00,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4174,8081,1662,41068,293828,3,217,1,6322.32,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4175,8081,1662,41068,293828,3,68,1,1327.69,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4176,8081,1662,41068,293828,3,57,2,7650.01,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4177,8081,1663,41068,293828,3,217,1,1239.67,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4178,8081,1663,41068,293828,3,68,1,260.33,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4179,8081,1663,41068,293828,3,57,2,1500.00,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL);
INSERT INTO `balance_libro_details` VALUES (4180,8081,1664,41068,293828,3,217,1,3512.40,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4181,8081,1664,41068,293828,3,68,1,737.60,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4182,8081,1664,41068,293828,3,57,2,4250.00,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4183,8081,1665,41068,293828,3,217,1,1239.67,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4184,8081,1665,41068,293828,3,68,1,260.33,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4185,8081,1665,41068,293828,3,57,2,1500.00,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4186,8081,1666,41068,293828,3,217,1,1547.11,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4187,8081,1666,41068,293828,3,68,1,324.89,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4188,8081,1666,41068,293828,3,57,2,1872.00,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4189,8081,1667,41068,293828,3,217,1,743.80,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4190,8081,1667,41068,293828,3,68,1,156.20,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4191,8081,1667,41068,293828,3,57,2,900.00,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4192,8081,1668,41068,293828,3,217,1,1239.67,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4193,8081,1668,41068,293828,3,68,1,260.33,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4194,8081,1668,41068,293828,3,57,2,1500.00,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4195,8081,1669,41068,293828,3,217,1,2107.44,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4196,8081,1669,41068,293828,3,68,1,442.56,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4197,8081,1669,41068,293828,3,57,2,2550.00,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4198,8081,1670,41068,293828,3,217,1,3223.14,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4199,8081,1670,41068,293828,3,68,1,676.86,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4200,8081,1670,41068,293828,3,57,2,3900.00,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4201,8081,1671,41068,293828,3,217,1,4917.36,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4202,8081,1671,41068,293828,3,68,1,1032.65,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4203,8081,1671,41068,293828,3,57,2,5950.01,NULL,'2022-12-12 16:19:19','2022-12-12 16:19:19',NULL),(4204,8081,1672,41068,293829,3,217,1,743.80,NULL,'2022-12-12 16:19:35','2022-12-12 16:19:35',NULL),(4205,8081,1672,41068,293829,3,68,1,156.20,NULL,'2022-12-12 16:19:35','2022-12-12 16:19:35',NULL),(4206,8081,1672,41068,293829,3,57,2,900.00,NULL,'2022-12-12 16:19:35','2022-12-12 16:19:35',NULL),(4207,8081,1673,41068,293829,3,217,1,231.62,NULL,'2022-12-12 16:19:35','2022-12-12 16:19:35',NULL),(4208,8081,1673,41068,293829,3,68,1,48.64,NULL,'2022-12-12 16:19:35','2022-12-12 16:19:35',NULL),(4209,8081,1673,41068,293829,3,217,1,23.16,NULL,'2022-12-12 16:19:35','2022-12-12 16:19:35',NULL),(4210,8081,1673,41068,293829,3,57,2,303.42,NULL,'2022-12-12 16:19:35','2022-12-12 16:19:35',NULL),(4211,8081,1674,41068,293829,3,217,1,134.71,NULL,'2022-12-12 16:19:35','2022-12-12 16:19:35',NULL),(4212,8081,1674,41068,293829,3,68,1,28.29,NULL,'2022-12-12 16:19:35','2022-12-12 16:19:35',NULL),(4213,8081,1674,41068,293829,3,57,2,163.00,NULL,'2022-12-12 16:19:35','2022-12-12 16:19:35',NULL),(4214,8081,1675,41068,293829,3,217,1,743.80,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4215,8081,1675,41068,293829,3,68,1,156.20,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4216,8081,1675,41068,293829,3,57,2,900.00,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4217,8081,1676,41068,293829,3,217,1,743.80,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4218,8081,1676,41068,293829,3,68,1,156.20,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4219,8081,1676,41068,293829,3,57,2,900.00,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL);
INSERT INTO `balance_libro_details` VALUES (4220,8081,1677,41068,293829,3,217,1,743.80,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4221,8081,1677,41068,293829,3,68,1,156.20,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4222,8081,1677,41068,293829,3,57,2,900.00,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4223,8081,1678,41068,293829,3,217,1,1983.47,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4224,8081,1678,41068,293829,3,68,1,416.53,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4225,8081,1678,41068,293829,3,57,2,2400.00,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4226,8081,1679,41068,293829,3,217,1,11239.68,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4227,8081,1679,41068,293829,3,68,1,2360.33,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4228,8081,1679,41068,293829,3,57,2,13600.01,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4229,8081,1680,41068,293829,3,217,1,743.80,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4230,8081,1680,41068,293829,3,68,1,156.20,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4231,8081,1680,41068,293829,3,57,2,900.00,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4232,8081,1681,41068,293829,3,217,1,1239.67,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4233,8081,1681,41068,293829,3,68,1,260.33,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4234,8081,1681,41068,293829,3,57,2,1500.00,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4235,8081,1682,41068,293829,3,217,1,5619.84,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4236,8081,1682,41068,293829,3,68,1,1180.17,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4237,8081,1682,41068,293829,3,57,2,6800.01,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4238,8081,1683,41068,293829,3,217,1,1919.01,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4239,8081,1683,41068,293829,3,68,1,402.99,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4240,8081,1683,41068,293829,3,57,2,2322.00,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4241,8081,1684,41068,293829,3,217,1,3512.40,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4242,8081,1684,41068,293829,3,68,1,737.60,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4243,8081,1684,41068,293829,3,57,2,4250.00,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4244,8081,1685,41068,293829,3,217,1,4917.36,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4245,8081,1685,41068,293829,3,68,1,1032.65,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4246,8081,1685,41068,293829,3,57,2,5950.01,NULL,'2022-12-12 16:19:36','2022-12-12 16:19:36',NULL),(4247,8081,1686,41068,293830,3,217,1,231.62,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4248,8081,1686,41068,293830,3,68,1,48.64,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4249,8081,1686,41068,293830,3,217,1,23.16,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4250,8081,1686,41068,293830,3,57,2,303.42,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4251,8081,1687,41068,293830,3,217,1,518.18,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4252,8081,1687,41068,293830,3,68,1,108.82,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4253,8081,1687,41068,293830,3,57,2,627.00,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4254,8081,1688,41068,293830,3,217,1,112.40,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4255,8081,1688,41068,293830,3,68,1,23.60,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4256,8081,1688,41068,293830,3,57,2,136.00,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4257,8081,1689,41068,293830,3,217,1,1487.60,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4258,8081,1689,41068,293830,3,68,1,312.40,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4259,8081,1689,41068,293830,3,57,2,1800.00,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL);
INSERT INTO `balance_libro_details` VALUES (4260,8081,1690,41068,293830,3,217,1,5124.30,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4261,8081,1690,41068,293830,3,68,1,1076.10,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4262,8081,1690,41068,293830,3,57,2,6200.40,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4263,8081,1691,41068,293830,3,217,1,231.12,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4264,8081,1691,41068,293830,3,68,1,48.53,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4265,8081,1691,41068,293830,3,57,2,279.65,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4266,8081,1692,41068,293830,3,217,1,1239.67,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4267,8081,1692,41068,293830,3,68,1,260.33,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4268,8081,1692,41068,293830,3,57,2,1500.00,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4269,8081,1693,41068,293830,3,217,1,8429.76,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4270,8081,1693,41068,293830,3,68,1,1770.25,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4271,8081,1693,41068,293830,3,57,2,10200.01,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4272,8081,1694,41068,293830,3,217,1,1652.90,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4273,8081,1694,41068,293830,3,68,1,347.11,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4274,8081,1694,41068,293830,3,57,2,2000.01,NULL,'2022-12-12 16:19:54','2022-12-12 16:19:54',NULL),(4275,8081,1695,41068,293830,3,217,1,4214.88,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4276,8081,1695,41068,293830,3,68,1,885.12,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4277,8081,1695,41068,293830,3,57,2,5100.00,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4278,8081,1696,41068,293830,3,217,1,826.45,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4279,8081,1696,41068,293830,3,68,1,173.55,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4280,8081,1696,41068,293830,3,57,2,1000.00,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4281,8081,1697,41068,293830,3,217,1,134.71,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4282,8081,1697,41068,293830,3,68,1,28.29,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4283,8081,1697,41068,293830,3,57,2,163.00,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4284,8081,1698,41068,293830,3,217,1,190.91,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4285,8081,1698,41068,293830,3,68,1,40.09,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4286,8081,1698,41068,293830,3,57,2,231.00,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4287,8081,1699,41068,293830,3,217,1,5175.21,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4288,8081,1699,41068,293830,3,68,1,1086.79,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4289,8081,1699,41068,293830,3,57,2,6262.00,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4290,8081,1700,41068,293830,3,217,1,826.45,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4291,8081,1700,41068,293830,3,68,1,173.55,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4292,8081,1700,41068,293830,3,57,2,1000.00,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4293,8081,1701,41068,293830,3,217,1,1423.14,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4294,8081,1701,41068,293830,3,68,1,298.86,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4295,8081,1701,41068,293830,3,57,2,1722.00,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4296,8081,1702,41068,293830,3,217,1,4628.08,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4297,8081,1702,41068,293830,3,68,1,971.90,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4298,8081,1702,41068,293830,3,57,2,5599.98,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4299,8081,1703,41068,293830,3,217,1,826.45,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL);
INSERT INTO `balance_libro_details` VALUES (4300,8081,1703,41068,293830,3,68,1,173.55,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4301,8081,1703,41068,293830,3,57,2,1000.00,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4302,8081,1704,41068,293830,3,217,1,15398.35,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4303,8081,1704,41068,293830,3,68,1,3233.65,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4304,8081,1704,41068,293830,3,57,2,18632.00,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4305,8081,1705,41068,293830,3,217,1,2355.36,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4306,8081,1705,41068,293830,3,68,1,494.63,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4307,8081,1705,41068,293830,3,57,2,2849.99,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4308,8081,1706,41068,293830,3,217,1,0.01,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4309,8081,1706,41068,293830,3,57,2,0.01,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4310,8081,1707,41068,293830,3,217,1,826.45,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4311,8081,1707,41068,293830,3,68,1,173.55,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4312,8081,1707,41068,293830,3,57,2,1000.00,NULL,'2022-12-12 16:19:55','2022-12-12 16:19:55',NULL),(4313,8081,1708,41068,293831,3,217,1,157.02,NULL,'2022-12-12 16:20:17','2022-12-12 16:20:17',NULL),(4314,8081,1708,41068,293831,3,68,1,32.98,NULL,'2022-12-12 16:20:17','2022-12-12 16:20:17',NULL),(4315,8081,1708,41068,293831,3,57,2,190.00,NULL,'2022-12-12 16:20:17','2022-12-12 16:20:17',NULL),(4316,8081,1709,41068,293831,3,217,1,10206.56,NULL,'2022-12-12 16:20:17','2022-12-12 16:20:17',NULL),(4317,8081,1709,41068,293831,3,68,1,2143.38,NULL,'2022-12-12 16:20:17','2022-12-12 16:20:17',NULL),(4318,8081,1709,41068,293831,3,57,2,12349.94,NULL,'2022-12-12 16:20:17','2022-12-12 16:20:17',NULL),(4319,8081,1710,41068,293831,3,217,1,8636.32,NULL,'2022-12-12 16:20:17','2022-12-12 16:20:17',NULL),(4320,8081,1710,41068,293831,3,68,1,1813.63,NULL,'2022-12-12 16:20:17','2022-12-12 16:20:17',NULL),(4321,8081,1710,41068,293831,3,57,2,10449.95,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4322,8081,1711,41068,293831,3,217,1,3925.60,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4323,8081,1711,41068,293831,3,68,1,824.38,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4324,8081,1711,41068,293831,3,57,2,4749.98,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4325,8081,1712,41068,293831,3,217,1,157.02,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4326,8081,1712,41068,293831,3,68,1,32.98,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4327,8081,1712,41068,293831,3,57,2,190.00,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4328,8081,1713,41068,293831,3,217,1,231.62,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4329,8081,1713,41068,293831,3,68,1,48.64,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4330,8081,1713,41068,293831,3,217,1,23.16,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4331,8081,1713,41068,293831,3,57,2,303.42,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4332,8081,1714,41068,293831,3,217,1,826.45,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4333,8081,1714,41068,293831,3,68,1,173.55,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4334,8081,1714,41068,293831,3,57,2,1000.00,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4335,8081,1715,41068,293831,3,217,1,2514.05,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4336,8081,1715,41068,293831,3,68,1,527.95,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4337,8081,1715,41068,293831,3,57,2,3042.00,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4338,8081,1716,41068,293831,3,217,1,11504.14,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4339,8081,1716,41068,293831,3,68,1,2415.87,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL);
INSERT INTO `balance_libro_details` VALUES (4340,8081,1716,41068,293831,3,57,2,13920.01,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4341,8081,1717,41068,293831,3,217,1,826.45,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4342,8081,1717,41068,293831,3,68,1,173.55,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4343,8081,1717,41068,293831,3,57,2,1000.00,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4344,8081,1718,41068,293831,3,217,1,743.80,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4345,8081,1718,41068,293831,3,68,1,156.20,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4346,8081,1718,41068,293831,3,57,2,900.00,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4347,8081,1719,41068,293831,3,217,1,4710.72,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4348,8081,1719,41068,293831,3,68,1,989.25,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4349,8081,1719,41068,293831,3,57,2,5699.97,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4350,8081,1720,41068,293831,3,217,1,826.45,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4351,8081,1720,41068,293831,3,68,1,173.55,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4352,8081,1720,41068,293831,3,57,2,1000.00,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4353,8081,1721,41068,293831,3,217,1,1652.90,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4354,8081,1721,41068,293831,3,68,1,347.11,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4355,8081,1721,41068,293831,3,57,2,2000.01,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4356,8081,1722,41068,293831,3,217,1,2355.36,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4357,8081,1722,41068,293831,3,68,1,494.63,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4358,8081,1722,41068,293831,3,57,2,2849.99,NULL,'2022-12-12 16:20:18','2022-12-12 16:20:18',NULL),(4359,8081,1723,41068,293832,3,217,1,157.03,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4360,8081,1723,41068,293832,3,68,1,32.97,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4361,8081,1723,41068,293832,3,57,2,190.00,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4362,8081,1724,41068,293832,3,217,1,7851.20,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4363,8081,1724,41068,293832,3,68,1,1648.75,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4364,8081,1724,41068,293832,3,57,2,9499.95,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4365,8081,1725,41068,293832,3,217,1,826.45,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4366,8081,1725,41068,293832,3,68,1,173.55,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4367,8081,1725,41068,293832,3,57,2,1000.00,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4368,8081,1726,41068,293832,3,217,1,826.45,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4369,8081,1726,41068,293832,3,68,1,173.55,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4370,8081,1726,41068,293832,3,57,2,1000.00,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4371,8081,1727,41068,293832,3,217,1,330.58,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4372,8081,1727,41068,293832,3,68,1,69.42,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4373,8081,1727,41068,293832,3,57,2,400.00,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4374,8081,1728,41068,293832,3,217,1,56.20,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4375,8081,1728,41068,293832,3,68,1,11.80,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4376,8081,1728,41068,293832,3,57,2,68.00,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4377,8081,1729,41068,293832,3,217,1,164.07,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4378,8081,1729,41068,293832,3,68,1,34.45,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4379,8081,1729,41068,293832,3,217,1,16.40,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL);
INSERT INTO `balance_libro_details` VALUES (4380,8081,1729,41068,293832,3,57,2,214.92,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4381,8081,1730,41068,293832,3,217,1,4710.72,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4382,8081,1730,41068,293832,3,68,1,989.25,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4383,8081,1730,41068,293832,3,57,2,5699.97,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4384,8081,1731,41068,293832,3,217,1,2257.85,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4385,8081,1731,41068,293832,3,68,1,474.15,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4386,8081,1731,41068,293832,3,57,2,2732.00,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4387,8081,1732,41068,293832,3,217,1,3140.48,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4388,8081,1732,41068,293832,3,68,1,659.50,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4389,8081,1732,41068,293832,3,57,2,3799.98,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4390,8081,1733,41068,293832,3,217,1,826.45,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4391,8081,1733,41068,293832,3,68,1,173.55,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4392,8081,1733,41068,293832,3,57,2,1000.00,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4393,8081,1734,41068,293832,3,217,1,1322.32,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4394,8081,1734,41068,293832,3,68,1,277.69,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4395,8081,1734,41068,293832,3,57,2,1600.01,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4396,8081,1735,41068,293832,3,217,1,2355.36,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4397,8081,1735,41068,293832,3,68,1,494.63,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4398,8081,1735,41068,293832,3,57,2,2849.99,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4399,8081,1736,41068,293832,3,217,1,5495.84,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4400,8081,1736,41068,293832,3,68,1,1154.13,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4401,8081,1736,41068,293832,3,57,2,6649.97,NULL,'2022-12-12 16:20:39','2022-12-12 16:20:39',NULL),(4408,8081,1740,41123,296890,8,277,1,381.16,NULL,'2022-12-14 21:58:25','2022-12-14 21:58:25',NULL),(4409,8081,1740,41123,296890,8,351,2,381.16,NULL,'2022-12-14 21:58:25','2022-12-14 21:58:25',NULL),(4410,8081,1741,41123,296890,16,156,1,1731.78,NULL,'2022-12-14 22:21:13','2022-12-14 22:21:13',NULL),(4411,8081,1741,41123,296890,16,302,2,1596.68,NULL,'2022-12-14 22:21:13','2022-12-14 22:21:13',NULL),(4412,8081,1741,41123,296890,16,277,2,381.16,NULL,'2022-12-14 22:21:13','2022-12-14 22:21:13',NULL),(4413,8081,1741,41123,296890,16,302,1,246.06,NULL,'2022-12-14 22:21:13','2022-12-14 22:21:13',NULL),(4414,8081,1741,41123,296890,16,156,1,2741.34,NULL,'2022-12-14 22:21:13','2022-12-14 22:21:13',NULL),(4415,8081,1741,41123,296890,16,301,2,11490.72,NULL,'2022-12-14 22:21:13','2022-12-14 22:21:13',NULL),(4416,8081,1741,41123,296890,16,301,1,8749.38,NULL,'2022-12-14 22:21:13','2022-12-14 22:21:13',NULL),(4417,8081,1742,41123,296889,16,156,1,1232.17,NULL,'2022-12-14 22:22:27','2022-12-14 22:22:27',NULL),(4418,8081,1742,41123,296889,16,327,2,1232.17,NULL,'2022-12-14 22:22:27','2022-12-14 22:22:27',NULL),(4419,8081,1742,41123,296889,16,156,1,195.05,NULL,'2022-12-14 22:22:27','2022-12-14 22:22:27',NULL),(4420,8081,1742,41123,296889,16,326,2,195.05,NULL,'2022-12-14 22:22:27','2022-12-14 22:22:27',NULL),(4421,8081,1743,41147,322673,2,218,2,30000.00,NULL,'2022-12-15 17:18:47','2022-12-15 17:18:47',NULL),(4422,8081,1743,41147,322673,2,13,1,30000.00,NULL,'2022-12-15 17:18:47','2022-12-15 17:18:47',NULL),(4423,8081,1744,41147,322673,2,218,2,5000.00,NULL,'2022-12-15 17:18:47','2022-12-15 17:18:47',NULL),(4424,8081,1744,41147,322673,2,13,1,5000.00,NULL,'2022-12-15 17:18:47','2022-12-15 17:18:47',NULL),(4425,8081,1745,41147,322674,2,218,2,30000.00,NULL,'2022-12-15 17:19:05','2022-12-15 17:19:05',NULL);
INSERT INTO `balance_libro_details` VALUES (4426,8081,1745,41147,322674,2,13,1,30000.00,NULL,'2022-12-15 17:19:05','2022-12-15 17:19:05',NULL),(4427,8081,1746,41147,322674,2,218,2,5000.00,NULL,'2022-12-15 17:19:05','2022-12-15 17:19:05',NULL),(4428,8081,1746,41147,322674,2,13,1,5000.00,NULL,'2022-12-15 17:19:05','2022-12-15 17:19:05',NULL),(4429,8081,1747,41147,322674,2,218,2,6000.00,NULL,'2022-12-15 17:19:05','2022-12-15 17:19:05',NULL),(4430,8081,1747,41147,322674,2,13,1,6000.00,NULL,'2022-12-15 17:19:05','2022-12-15 17:19:05',NULL),(4431,8081,1748,41147,322675,2,218,2,8000.00,NULL,'2022-12-15 17:19:21','2022-12-15 17:19:21',NULL),(4432,8081,1748,41147,322675,2,13,1,8000.00,NULL,'2022-12-15 17:19:21','2022-12-15 17:19:21',NULL),(4433,8081,1749,41147,322675,2,218,2,10000.00,NULL,'2022-12-15 17:19:21','2022-12-15 17:19:21',NULL),(4434,8081,1749,41147,322675,2,13,1,10000.00,NULL,'2022-12-15 17:19:21','2022-12-15 17:19:21',NULL),(4435,8081,1750,41147,322675,2,218,2,30000.00,NULL,'2022-12-15 17:19:21','2022-12-15 17:19:21',NULL),(4436,8081,1750,41147,322675,2,13,1,30000.00,NULL,'2022-12-15 17:19:21','2022-12-15 17:19:21',NULL),(4437,8081,1751,41147,322666,3,217,1,2143.37,NULL,'2022-12-15 17:20:13','2022-12-15 17:20:13',NULL),(4438,8081,1751,41147,322666,3,68,1,450.11,NULL,'2022-12-15 17:20:13','2022-12-15 17:20:13',NULL),(4439,8081,1751,41147,322666,3,57,2,2593.48,NULL,'2022-12-15 17:20:13','2022-12-15 17:20:13',NULL),(4440,8081,1752,41147,322668,3,217,1,6516.53,NULL,'2022-12-15 17:21:09','2022-12-15 17:21:09',NULL),(4441,8081,1752,41147,322668,3,68,1,1368.47,NULL,'2022-12-15 17:21:09','2022-12-15 17:21:09',NULL),(4442,8081,1752,41147,322668,3,57,2,7885.00,NULL,'2022-12-15 17:21:09','2022-12-15 17:21:09',NULL),(4443,8081,1753,41147,322668,3,217,1,33.89,NULL,'2022-12-15 17:21:09','2022-12-15 17:21:09',NULL),(4444,8081,1753,41147,322668,3,68,1,7.11,NULL,'2022-12-15 17:21:09','2022-12-15 17:21:09',NULL),(4445,8081,1753,41147,322668,3,57,2,41.00,NULL,'2022-12-15 17:21:09','2022-12-15 17:21:09',NULL),(4446,8081,1754,41147,322669,3,217,1,27.56,NULL,'2022-12-15 17:21:27','2022-12-15 17:21:27',NULL),(4447,8081,1754,41147,322669,3,68,1,5.79,NULL,'2022-12-15 17:21:27','2022-12-15 17:21:27',NULL),(4448,8081,1754,41147,322669,3,57,2,33.35,NULL,'2022-12-15 17:21:27','2022-12-15 17:21:27',NULL),(4449,8081,1755,41147,322672,3,217,1,1442.15,NULL,'2022-12-15 17:22:41','2022-12-15 17:22:41',NULL),(4450,8081,1755,41147,322672,3,68,1,302.85,NULL,'2022-12-15 17:22:41','2022-12-15 17:22:41',NULL),(4451,8081,1755,41147,322672,3,57,2,1745.00,NULL,'2022-12-15 17:22:41','2022-12-15 17:22:41',NULL),(4452,8081,1756,40918,178700,2,218,2,3000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4453,8081,1756,40918,178700,2,13,1,3000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4454,8081,1757,40918,178700,2,218,2,2000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4455,8081,1757,40918,178700,2,13,1,2000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4456,8081,1758,40918,178700,2,218,2,2000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4457,8081,1758,40918,178700,2,13,1,2000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4458,8081,1759,40918,178700,2,218,2,3000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4459,8081,1759,40918,178700,2,13,1,3000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4460,8081,1760,40918,178700,2,218,2,3000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4461,8081,1760,40918,178700,2,13,1,3000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4462,8081,1761,40918,178700,2,218,2,3000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4463,8081,1761,40918,178700,2,13,1,3000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4464,8081,1762,40918,178700,2,218,2,3000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4465,8081,1762,40918,178700,2,13,1,3000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL);
INSERT INTO `balance_libro_details` VALUES (4466,8081,1763,40918,178700,2,218,2,3000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4467,8081,1763,40918,178700,2,13,1,3000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4468,8081,1764,40918,178700,2,218,2,3000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4469,8081,1764,40918,178700,2,13,1,3000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4470,8081,1765,40918,178700,2,218,2,10000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4471,8081,1765,40918,178700,2,13,1,10000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4472,8081,1766,40918,178700,2,218,2,19700.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4473,8081,1766,40918,178700,2,13,1,19700.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4474,8081,1767,40918,178700,2,218,2,1000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4475,8081,1767,40918,178700,2,13,1,1000.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4476,8081,1768,40918,178700,2,218,2,5500.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4477,8081,1768,40918,178700,2,13,1,5500.00,NULL,'2023-01-09 13:11:33','2023-01-09 13:11:33',NULL),(4478,8081,1769,40918,178700,2,218,2,8500.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4479,8081,1769,40918,178700,2,13,1,8500.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4480,8081,1770,40918,178700,2,218,2,9000.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4481,8081,1770,40918,178700,2,13,1,9000.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4482,8081,1771,40918,178700,2,218,2,3000.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4483,8081,1771,40918,178700,2,13,1,3000.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4484,8081,1772,40918,178700,2,218,2,5000.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4485,8081,1772,40918,178700,2,13,1,5000.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4486,8081,1773,40918,178700,2,218,2,5000.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4487,8081,1773,40918,178700,2,13,1,5000.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4488,8081,1774,40918,178700,2,218,2,5000.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4489,8081,1774,40918,178700,2,13,1,5000.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4490,8081,1775,40918,178700,2,218,2,3000.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4491,8081,1775,40918,178700,2,13,1,3000.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4492,8081,1776,40918,178700,2,218,2,5000.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4493,8081,1776,40918,178700,2,13,1,5000.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4494,8081,1777,40918,178700,2,218,2,17500.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4495,8081,1777,40918,178700,2,13,1,17500.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4496,8081,1778,40918,178700,2,218,2,6000.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4497,8081,1778,40918,178700,2,13,1,6000.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4498,8081,1779,40918,178700,2,218,2,3000.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4499,8081,1779,40918,178700,2,13,1,3000.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4500,8081,1780,40918,178700,2,218,2,2500.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4501,8081,1780,40918,178700,2,13,1,2500.00,NULL,'2023-01-09 13:11:34','2023-01-09 13:11:34',NULL),(4502,8081,1781,40918,178700,3,250,1,0.00,NULL,'2023-01-09 13:11:55','2023-01-09 13:11:55',NULL),(4503,8081,1781,40918,178700,3,250,1,12152.00,NULL,'2023-01-09 13:11:55','2023-01-09 13:11:55',NULL),(4504,8081,1781,40918,178700,3,57,2,12152.00,NULL,'2023-01-09 13:11:55','2023-01-09 13:11:55',NULL),(4505,8081,1782,40918,178700,3,217,1,938.02,NULL,'2023-01-09 13:11:55','2023-01-09 13:11:55',NULL);
INSERT INTO `balance_libro_details` VALUES (4506,8081,1782,40918,178700,3,68,1,196.98,NULL,'2023-01-09 13:11:55','2023-01-09 13:11:55',NULL),(4507,8081,1782,40918,178700,3,57,2,1135.00,NULL,'2023-01-09 13:11:55','2023-01-09 13:11:55',NULL),(4508,8081,1783,40918,178700,3,250,2,0.00,NULL,'2023-01-09 13:11:55','2023-01-09 13:11:55',NULL),(4509,8081,1783,40918,178700,3,250,2,1405.94,NULL,'2023-01-09 13:11:55','2023-01-09 13:11:55',NULL),(4510,8081,1783,40918,178700,3,57,1,1405.94,NULL,'2023-01-09 13:11:55','2023-01-09 13:11:55',NULL),(4511,8081,1784,40918,178700,3,217,1,661.16,NULL,'2023-01-09 13:11:55','2023-01-09 13:11:55',NULL),(4512,8081,1784,40918,178700,3,68,1,138.84,NULL,'2023-01-09 13:11:55','2023-01-09 13:11:55',NULL),(4513,8081,1784,40918,178700,3,57,2,800.00,NULL,'2023-01-09 13:11:55','2023-01-09 13:11:55',NULL),(4514,8081,1785,40731,9029,2,218,2,584.36,NULL,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(4515,8081,1785,40731,9029,2,13,1,584.36,NULL,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(4516,8081,1786,40731,9029,2,218,2,1937.00,NULL,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(4517,8081,1786,40731,9029,2,13,1,1937.00,NULL,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(4518,8081,1787,40731,9029,2,218,2,57720.00,NULL,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(4519,8081,1787,40731,9029,2,13,1,57720.00,NULL,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(4520,8081,1788,40731,9029,2,218,2,35133.00,NULL,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(4521,8081,1788,40731,9029,2,13,1,35133.00,NULL,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(4522,8081,1789,40731,9029,2,218,2,64250.00,NULL,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(4523,8081,1789,40731,9029,2,13,1,64250.00,NULL,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(4524,8081,1790,40731,9029,2,218,2,64250.00,NULL,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(4525,8081,1790,40731,9029,2,13,1,64250.00,NULL,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(4526,8081,1791,40731,9029,2,218,2,64250.00,NULL,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(4527,8081,1791,40731,9029,2,13,1,64250.00,NULL,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(4528,8081,1792,40731,9029,2,218,2,57825.00,NULL,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(4529,8081,1792,40731,9029,2,13,1,57825.00,NULL,'2023-01-09 13:19:31','2023-01-09 13:19:31',NULL),(4530,8081,1793,40731,9029,3,217,1,23769.10,NULL,'2023-01-09 13:19:47','2023-01-15 18:11:37','2023-01-15 18:11:37'),(4531,8081,1793,40731,9029,3,68,1,4991.51,NULL,'2023-01-09 13:19:47','2023-01-15 18:11:37','2023-01-15 18:11:37'),(4532,8081,1793,40731,9029,3,217,1,862.82,NULL,'2023-01-09 13:19:47','2023-01-15 18:11:37','2023-01-15 18:11:37'),(4533,8081,1793,40731,9029,3,57,2,29623.43,NULL,'2023-01-09 13:19:47','2023-01-15 18:11:37','2023-01-15 18:11:37'),(4534,8081,1794,40731,9029,3,217,1,602.00,NULL,'2023-01-09 13:19:47','2023-01-15 18:23:37','2023-01-15 18:23:37'),(4535,8081,1794,40731,9029,3,68,1,126.42,NULL,'2023-01-09 13:19:47','2023-01-15 18:23:37','2023-01-15 18:23:37'),(4536,8081,1794,40731,9029,3,217,1,21.85,NULL,'2023-01-09 13:19:47','2023-01-15 18:23:37','2023-01-15 18:23:37'),(4537,8081,1794,40731,9029,3,57,2,750.27,NULL,'2023-01-09 13:19:47','2023-01-15 18:23:37','2023-01-15 18:23:37'),(4538,8081,1795,40731,9029,3,217,1,564.44,NULL,'2023-01-09 13:19:47','2023-01-15 18:12:29','2023-01-15 18:12:29'),(4539,8081,1795,40731,9029,3,68,1,118.53,NULL,'2023-01-09 13:19:47','2023-01-15 18:12:29','2023-01-15 18:12:29'),(4540,8081,1795,40731,9029,3,217,1,20.49,NULL,'2023-01-09 13:19:47','2023-01-15 18:12:29','2023-01-15 18:12:29'),(4541,8081,1795,40731,9029,3,57,2,703.46,NULL,'2023-01-09 13:19:47','2023-01-15 18:12:29','2023-01-15 18:12:29'),(4542,8081,1796,40731,9029,3,217,1,11948.09,NULL,'2023-01-09 13:19:47','2023-01-15 18:13:45','2023-01-15 18:13:45'),(4543,8081,1796,40731,9029,3,68,1,2509.10,NULL,'2023-01-09 13:19:47','2023-01-15 18:13:45','2023-01-15 18:13:45');
INSERT INTO `balance_libro_details` VALUES (4544,8081,1796,40731,9029,3,217,1,433.72,NULL,'2023-01-09 13:19:47','2023-01-15 18:13:45','2023-01-15 18:13:45'),(4545,8081,1796,40731,9029,3,57,2,14890.91,NULL,'2023-01-09 13:19:47','2023-01-15 18:13:45','2023-01-15 18:13:45'),(4546,8081,1797,40731,9029,3,217,1,89206.05,NULL,'2023-01-09 13:19:47','2023-01-15 18:21:04','2023-01-15 18:21:04'),(4547,8081,1797,40731,9029,3,68,1,18733.27,NULL,'2023-01-09 13:19:47','2023-01-15 18:21:04','2023-01-15 18:21:04'),(4548,8081,1797,40731,9029,3,217,1,3238.18,NULL,'2023-01-09 13:19:47','2023-01-15 18:21:04','2023-01-15 18:21:04'),(4549,8081,1797,40731,9029,3,57,2,111177.50,NULL,'2023-01-09 13:19:47','2023-01-15 18:21:04','2023-01-15 18:21:04'),(4550,8081,1798,40731,9029,3,250,1,12630.00,NULL,'2023-01-09 13:19:47','2023-01-09 13:19:47',NULL),(4551,8081,1798,40731,9029,3,57,2,12630.00,NULL,'2023-01-09 13:19:47','2023-01-09 13:19:47',NULL),(4552,8081,1799,40731,9029,3,217,1,324.27,NULL,'2023-01-09 13:19:47','2023-01-09 13:19:47',NULL),(4553,8081,1799,40731,9029,3,68,1,68.09,NULL,'2023-01-09 13:19:47','2023-01-09 13:19:47',NULL),(4554,8081,1799,40731,9029,3,217,1,32.42,NULL,'2023-01-09 13:19:47','2023-01-09 13:19:47',NULL),(4555,8081,1799,40731,9029,3,57,2,424.78,NULL,'2023-01-09 13:19:47','2023-01-09 13:19:47',NULL),(4556,8081,1800,40731,9029,3,217,1,19.59,NULL,'2023-01-09 13:19:47','2023-01-09 13:19:47',NULL),(4557,8081,1800,40731,9029,3,68,1,4.11,NULL,'2023-01-09 13:19:47','2023-01-09 13:19:47',NULL),(4558,8081,1800,40731,9029,3,57,2,23.70,NULL,'2023-01-09 13:19:47','2023-01-09 13:19:47',NULL),(4559,8081,1801,40731,9029,3,250,1,0.00,NULL,'2023-01-09 13:19:47','2023-01-09 13:19:47',NULL),(4560,8081,1801,40731,9029,3,57,2,0.00,NULL,'2023-01-09 13:19:47','2023-01-09 13:19:47',NULL),(4561,8081,1802,40731,298416,3,217,1,478.00,NULL,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(4562,8081,1802,40731,298416,3,68,1,100.38,NULL,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(4563,8081,1802,40731,298416,3,217,1,17.35,NULL,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(4564,8081,1802,40731,298416,3,57,2,595.73,NULL,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(4565,8081,1803,40731,298416,3,217,1,2505.65,NULL,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(4566,8081,1803,40731,298416,3,68,1,526.19,NULL,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(4567,8081,1803,40731,298416,3,217,1,90.96,NULL,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(4568,8081,1803,40731,298416,3,57,2,3122.80,NULL,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(4569,8081,1804,40731,298416,3,217,1,12208.00,NULL,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(4570,8081,1804,40731,298416,3,68,1,2563.68,NULL,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(4571,8081,1804,40731,298416,3,217,1,443.15,NULL,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(4572,8081,1804,40731,298416,3,57,2,15214.83,NULL,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(4573,8081,1805,40731,298416,3,217,1,164.12,NULL,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(4574,8081,1805,40731,298416,3,68,1,34.47,NULL,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(4575,8081,1805,40731,298416,3,217,1,16.41,NULL,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(4576,8081,1805,40731,298416,3,57,2,215.00,NULL,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(4577,8081,1806,40731,298416,3,217,1,70989.45,NULL,'2023-01-09 13:22:55','2023-01-09 13:22:55',NULL),(4578,8081,1806,40731,298416,3,68,1,14907.79,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4579,8081,1806,40731,298416,3,217,1,2576.92,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4580,8081,1806,40731,298416,3,57,2,88474.16,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4581,8081,1807,40731,298416,3,217,1,47345.70,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4582,8081,1807,40731,298416,3,68,1,9942.60,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL);
INSERT INTO `balance_libro_details` VALUES (4583,8081,1807,40731,298416,3,217,1,1718.65,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4584,8081,1807,40731,298416,3,57,2,59006.95,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4585,8081,1808,40731,298416,3,217,1,1072.19,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4586,8081,1808,40731,298416,3,68,1,225.16,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4587,8081,1808,40731,298416,3,217,1,38.92,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4588,8081,1808,40731,298416,3,57,2,1336.27,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4589,8081,1809,40731,298416,3,217,1,17352.30,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4590,8081,1809,40731,298416,3,68,1,3643.98,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4591,8081,1809,40731,298416,3,217,1,629.89,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4592,8081,1809,40731,298416,3,57,2,21626.17,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4593,8081,1810,40731,298416,3,217,1,22931.73,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4594,8081,1810,40731,298416,3,68,1,4815.66,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4595,8081,1810,40731,298416,3,217,1,832.42,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4596,8081,1810,40731,298416,3,57,2,28579.81,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4597,8081,1811,40731,298416,3,217,1,2396.70,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4598,8081,1811,40731,298416,3,68,1,503.31,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4599,8081,1811,40731,298416,3,57,2,2900.01,NULL,'2023-01-09 13:22:56','2023-01-09 13:22:56',NULL),(4600,8081,1812,41068,293834,2,218,2,50000.00,NULL,'2023-01-09 13:29:06','2023-01-09 13:29:06',NULL),(4601,8081,1812,41068,293834,2,13,1,50000.00,NULL,'2023-01-09 13:29:06','2023-01-09 13:29:06',NULL),(4602,8081,1813,41068,293834,2,218,2,35000.00,NULL,'2023-01-09 13:29:06','2023-01-09 13:29:06',NULL),(4603,8081,1813,41068,293834,2,13,1,35000.00,NULL,'2023-01-09 13:29:06','2023-01-09 13:29:06',NULL),(4604,8081,1814,41068,293834,2,218,2,16000.00,NULL,'2023-01-09 13:29:06','2023-01-09 13:29:06',NULL),(4605,8081,1814,41068,293834,2,13,1,16000.00,NULL,'2023-01-09 13:29:06','