-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-22278182-0
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-08-09 23:09:12','Actividad Generica 1','000001',NULL),(2,NULL,'2022-08-09 23:09:12','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'123456Manuek',NULL,1,40721,'2022-12-15'),(2,NULL,'Huracan1973',NULL,1,40839,'2022-12-15'),(3,NULL,'Federico2022',NULL,1,40849,'2022-12-15'),(4,NULL,'Pasaje2022',NULL,1,40856,'2022-12-16'),(5,NULL,'T',NULL,1,40720,'2023-01-04'),(6,NULL,'T',NULL,1,40720,'2023-01-04'),(7,NULL,'Luciano2460',NULL,1,40991,'2023-01-13'),(8,NULL,'Guadax1411',NULL,1,40875,'2023-01-19'),(9,NULL,'Mateok2022',NULL,1,40983,'2023-03-05'),(10,NULL,'Panqueque33',NULL,1,41023,'2023-03-23'),(11,NULL,'Viviana2418',NULL,1,40719,'2023-03-26'),(12,NULL,'Huracan1973',NULL,1,40839,'2023-03-26'),(13,NULL,'GUadax1411',NULL,1,40875,'2023-09-04'),(14,NULL,'Luciano2460',NULL,1,40991,'2024-01-26'),(15,NULL,'Mateok2022',NULL,1,40983,'2024-01-26'),(16,NULL,'2604Duster',NULL,1,41204,'2024-09-10'),(17,NULL,'2604Duster',NULL,1,41204,'2024-09-10'),(18,NULL,'Panqueque33',NULL,1,41023,'2024-09-10');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'vgache@hotmail.com','1161752195',NULL,1,40719,'2022-11-08'),(2,'vgache@hotmail.com','1161752195','',1,40719,'2023-03-26');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10109 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7525,40721,3039,2,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',47324.80,NULL,NULL,1,'2022-11-08 12:35:13','2022-11-08 12:35:13',NULL),(2,7525,40721,3039,2,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',9374.70,NULL,NULL,1,'2022-11-08 12:35:13','2022-11-08 12:35:13',NULL),(3,7525,40720,1527,2,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1297.00,NULL,NULL,1,'2022-11-08 12:52:31','2022-11-08 12:52:31',NULL),(4,7525,40720,1527,2,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',16245.01,NULL,NULL,1,'2022-11-08 12:52:31','2022-11-08 12:52:31',NULL),(5,7525,40720,1527,2,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1420.00,NULL,NULL,1,'2022-11-08 12:52:31','2022-11-08 12:52:31',NULL),(6,7525,40720,1527,2,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',56239.86,NULL,NULL,1,'2022-11-08 12:52:31','2022-11-08 12:52:31',NULL),(7,7525,40720,1527,2,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',11759.99,NULL,NULL,1,'2022-11-08 12:52:31','2022-11-08 12:52:31',NULL),(8,7525,40720,1527,2,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1560.00,NULL,NULL,1,'2022-11-08 12:52:32','2022-11-08 12:52:32',NULL),(9,7525,40720,1527,2,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1540.00,NULL,NULL,1,'2022-11-08 12:52:32','2022-11-08 12:52:32',NULL),(10,7525,40720,1527,2,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',3314.88,NULL,NULL,1,'2022-11-08 12:52:32','2022-11-08 12:52:32',NULL),(11,7525,40720,1527,2,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',6555.00,NULL,NULL,1,'2022-11-08 12:52:32','2022-11-08 12:52:32',NULL),(12,7525,40720,1527,2,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',289.99,NULL,NULL,1,'2022-11-08 12:52:32','2022-11-08 12:52:32',NULL),(13,7525,40720,1527,2,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1689.99,NULL,NULL,1,'2022-11-08 12:52:32','2022-11-08 12:52:32',NULL),(14,7525,40720,1527,2,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',8275.00,NULL,NULL,1,'2022-11-08 12:52:32','2022-11-08 12:52:32',NULL),(15,7525,40720,1527,2,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',29899.95,NULL,NULL,1,'2022-11-08 12:52:32','2022-11-08 12:52:32',NULL),(16,7525,40720,1527,2,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',5590.00,NULL,NULL,1,'2022-11-08 12:52:32','2022-11-08 12:52:32',NULL),(17,7525,40720,1527,2,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',47499.82,NULL,NULL,1,'2022-11-08 12:52:32','2022-11-08 12:52:32',NULL),(18,7525,40720,1527,2,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',16369.95,NULL,NULL,1,'2022-11-08 12:52:32','2022-11-08 12:52:32',NULL),(19,7525,40720,1527,2,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',19500.00,NULL,NULL,1,'2022-11-08 12:52:32','2022-11-08 12:52:32',NULL),(20,7525,40720,1527,2,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',9500.00,NULL,NULL,1,'2022-11-08 12:52:32','2022-11-08 12:52:32',NULL),(21,7525,40720,1527,2,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1560.00,NULL,NULL,1,'2022-11-08 12:52:32','2022-11-08 12:52:32',NULL),(22,7525,40720,1527,2,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',7804.98,NULL,NULL,1,'2022-11-08 12:52:32','2022-11-08 12:52:32',NULL);
INSERT INTO `balance_libro` VALUES (23,7525,40720,1527,2,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',999.94,NULL,NULL,1,'2022-11-08 12:52:32','2022-11-08 12:52:32',NULL),(24,7525,40720,1527,2,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',22025.00,NULL,NULL,1,'2022-11-08 12:52:33','2022-11-08 12:52:33',NULL),(25,7525,40720,1527,2,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',599.99,NULL,NULL,1,'2022-11-08 12:52:33','2022-11-08 12:52:33',NULL),(26,7525,40720,1527,2,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1310.00,NULL,NULL,1,'2022-11-08 12:52:33','2022-11-08 12:52:33',NULL),(27,7525,40720,1527,2,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',12539.99,NULL,NULL,1,'2022-11-08 12:52:33','2022-11-08 12:52:33',NULL),(28,7525,40720,1527,2,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',3019.99,NULL,NULL,1,'2022-11-08 12:52:33','2022-11-08 12:52:33',NULL),(29,7525,40720,1527,2,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',67459.78,NULL,NULL,1,'2022-11-08 12:52:33','2022-11-08 12:52:33',NULL),(30,7525,40720,1527,2,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',3974.97,NULL,NULL,1,'2022-11-08 12:52:33','2022-11-08 12:52:33',NULL),(31,7525,40720,1527,2,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',500.00,NULL,NULL,1,'2022-11-08 12:52:33','2022-11-08 12:52:33',NULL),(32,7525,40720,1527,2,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',800.00,NULL,NULL,1,'2022-11-08 12:52:33','2022-11-08 12:52:33',NULL),(33,7525,40720,1527,2,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',4950.00,NULL,NULL,1,'2022-11-08 12:52:33','2022-11-08 12:52:33',NULL),(34,7525,40720,1527,2,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',50300.00,NULL,NULL,1,'2022-11-08 12:52:33','2022-11-08 12:52:33',NULL),(35,7525,40720,1527,2,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',5000.00,NULL,NULL,1,'2022-11-08 12:52:34','2022-11-08 12:52:34',NULL),(36,7525,40720,1527,2,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2879.99,NULL,NULL,1,'2022-11-08 12:52:34','2022-11-08 12:52:34',NULL),(37,7525,40720,1527,2,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1910.00,NULL,NULL,1,'2022-11-08 12:52:34','2022-11-08 12:52:34',NULL),(38,7525,40720,1527,2,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',200.00,NULL,NULL,1,'2022-11-08 12:52:34','2022-11-08 12:52:34',NULL),(39,7525,40720,1527,2,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',4930.00,NULL,NULL,1,'2022-11-08 12:52:34','2022-11-08 12:52:34',NULL),(40,7525,40720,1527,2,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',19810.00,NULL,NULL,1,'2022-11-08 12:52:34','2022-11-08 12:52:34',NULL),(41,7525,40720,1527,2,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1099.95,NULL,NULL,1,'2022-11-08 12:52:34','2022-11-08 12:52:34',NULL),(42,7525,40720,1527,2,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2099.99,NULL,NULL,1,'2022-11-08 12:52:34','2022-11-08 12:52:34',NULL),(43,7525,40720,1527,2,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',4020.83,NULL,NULL,1,'2022-11-08 12:52:34','2022-11-08 12:52:34',NULL);
INSERT INTO `balance_libro` VALUES (44,7525,40720,1527,2,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',599.99,NULL,NULL,1,'2022-11-08 12:52:34','2022-11-08 12:52:34',NULL),(45,7525,40720,1527,2,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3320.00,NULL,NULL,1,'2022-11-08 12:52:34','2022-11-08 12:52:34',NULL),(46,7525,40720,1527,2,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3359.98,NULL,NULL,1,'2022-11-08 12:52:35','2022-11-08 12:52:35',NULL),(47,7525,40720,1527,2,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',25879.91,NULL,NULL,1,'2022-11-08 12:52:35','2022-11-08 12:52:35',NULL),(48,7525,40720,1527,2,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',36599.98,NULL,NULL,1,'2022-11-08 12:52:35','2022-11-08 12:52:35',NULL),(49,7525,40720,1527,2,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',5127.97,NULL,NULL,1,'2022-11-08 12:52:35','2022-11-08 12:52:35',NULL),(50,7525,40720,1527,2,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3549.99,NULL,NULL,1,'2022-11-08 12:52:35','2022-11-08 12:52:35',NULL),(51,7525,40720,1527,2,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',14260.00,NULL,NULL,1,'2022-11-08 12:52:35','2022-11-08 12:52:35',NULL),(52,7525,40720,1527,2,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',9050.00,NULL,NULL,1,'2022-11-08 12:52:35','2022-11-08 12:52:35',NULL),(53,7525,40720,1527,2,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',999.99,NULL,NULL,1,'2022-11-08 12:52:35','2022-11-08 12:52:35',NULL),(54,7525,40720,1527,2,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4120.05,NULL,NULL,1,'2022-11-08 12:52:35','2022-11-08 12:52:35',NULL),(55,7525,40720,1527,2,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',1379.99,NULL,NULL,1,'2022-11-08 12:53:05','2022-11-08 12:53:05',NULL),(56,7525,40720,1527,2,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',11950.00,NULL,NULL,1,'2022-11-08 12:53:05','2022-11-08 12:53:05',NULL),(57,7525,40720,1527,2,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',18910.01,NULL,NULL,1,'2022-11-08 12:53:05','2022-11-08 12:53:05',NULL),(58,7525,40720,1527,2,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',25100.00,NULL,NULL,1,'2022-11-08 12:53:05','2022-11-08 12:53:05',NULL),(59,7525,40720,1527,2,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',1709.99,NULL,NULL,1,'2022-11-08 12:53:05','2022-11-08 12:53:05',NULL),(60,7525,40720,1527,2,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',7000.00,NULL,NULL,1,'2022-11-08 12:53:06','2022-11-08 12:53:06',NULL),(61,7525,40720,1527,2,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',20149.99,NULL,NULL,1,'2022-11-08 12:53:06','2022-11-08 12:53:06',NULL),(62,7525,40720,1527,2,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',4950.00,NULL,NULL,1,'2022-11-08 12:53:06','2022-11-08 12:53:06',NULL),(63,7525,40720,1527,2,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',2920.00,NULL,NULL,1,'2022-11-08 12:53:06','2022-11-08 12:53:06',NULL),(64,7525,40720,1527,2,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',2800.00,NULL,NULL,1,'2022-11-08 12:53:06','2022-11-08 12:53:06',NULL);
INSERT INTO `balance_libro` VALUES (65,7525,40720,1527,2,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',3210.00,NULL,NULL,1,'2022-11-08 12:53:06','2022-11-08 12:53:06',NULL),(66,7525,40720,1527,2,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',9370.00,NULL,NULL,1,'2022-11-08 12:53:06','2022-11-08 12:53:06',NULL),(67,7525,40720,1527,2,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',500.00,NULL,NULL,1,'2022-11-08 12:53:06','2022-11-08 12:53:06',NULL),(68,7525,40720,1527,2,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',19900.00,NULL,NULL,1,'2022-11-08 12:53:06','2022-11-08 12:53:06',NULL),(69,7525,40720,1527,2,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',2459.99,NULL,NULL,1,'2022-11-08 12:53:06','2022-11-08 12:53:06',NULL),(70,7525,40720,1527,2,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',5140.00,NULL,NULL,1,'2022-11-08 12:53:06','2022-11-08 12:53:06',NULL),(71,7525,40720,1527,2,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',2600.05,NULL,NULL,1,'2022-11-08 12:53:06','2022-11-08 12:53:06',NULL),(72,7525,40720,1527,2,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',2640.00,NULL,NULL,1,'2022-11-08 12:53:06','2022-11-08 12:53:06',NULL),(73,7525,40720,1527,2,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',23414.63,NULL,NULL,1,'2022-11-08 12:53:06','2022-11-08 12:53:06',NULL),(74,7525,40720,1527,2,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',3680.00,NULL,NULL,1,'2022-11-08 12:53:07','2022-11-08 12:53:07',NULL),(75,7525,40720,1527,2,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',10709.99,NULL,NULL,1,'2022-11-08 12:53:07','2022-11-08 12:53:07',NULL),(76,7525,40720,1527,2,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',1434.98,NULL,NULL,1,'2022-11-08 12:53:07','2022-11-08 12:53:07',NULL),(77,7525,40720,1527,2,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',44469.99,NULL,NULL,1,'2022-11-08 12:53:07','2022-11-08 12:53:07',NULL),(78,7525,40720,1527,2,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',5705.00,NULL,NULL,1,'2022-11-08 12:53:07','2022-11-08 12:53:07',NULL),(79,7525,40720,1527,2,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',1899.99,NULL,NULL,1,'2022-11-08 12:53:07','2022-11-08 12:53:07',NULL),(80,7525,40720,1527,2,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',2465.00,NULL,NULL,1,'2022-11-08 12:53:07','2022-11-08 12:53:07',NULL),(81,7525,40720,1527,2,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',2460.00,NULL,NULL,1,'2022-11-08 12:53:07','2022-11-08 12:53:07',NULL),(82,7525,40720,1527,2,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',3810.00,NULL,NULL,1,'2022-11-08 12:53:07','2022-11-08 12:53:07',NULL),(83,7525,40720,1527,2,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',1724.99,NULL,NULL,1,'2022-11-08 12:53:07','2022-11-08 12:53:07',NULL),(84,7525,40720,1527,2,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',459.99,NULL,NULL,1,'2022-11-08 12:53:07','2022-11-08 12:53:07',NULL),(85,7525,40720,1527,2,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',8310.00,NULL,NULL,1,'2022-11-08 12:53:08','2022-11-08 12:53:08',NULL);
INSERT INTO `balance_libro` VALUES (86,7525,40720,1527,2,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',12310.01,NULL,NULL,1,'2022-11-08 12:53:08','2022-11-08 12:53:08',NULL),(87,7525,40720,1527,2,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',5569.99,NULL,NULL,1,'2022-11-08 12:53:08','2022-11-08 12:53:08',NULL),(88,7525,40720,1527,2,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',4299.99,NULL,NULL,1,'2022-11-08 12:53:08','2022-11-08 12:53:08',NULL),(89,7525,40720,1527,2,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',1759.99,NULL,NULL,1,'2022-11-08 12:53:08','2022-11-08 12:53:08',NULL),(90,7525,40720,1527,2,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',60499.90,NULL,NULL,1,'2022-11-08 12:53:08','2022-11-08 12:53:08',NULL),(91,7525,40720,1527,2,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',47499.82,NULL,NULL,1,'2022-11-08 12:53:08','2022-11-08 12:53:08',NULL),(92,7525,40720,1527,2,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',6160.00,NULL,NULL,1,'2022-11-08 12:53:08','2022-11-08 12:53:08',NULL),(93,7525,40720,1527,2,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',60499.90,NULL,NULL,1,'2022-11-08 12:53:08','2022-11-08 12:53:08',NULL),(94,7525,40720,1527,2,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',5170.00,NULL,NULL,1,'2022-11-08 12:53:08','2022-11-08 12:53:08',NULL),(95,7525,40720,1527,2,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',2345.00,NULL,NULL,1,'2022-11-08 12:53:08','2022-11-08 12:53:08',NULL),(96,7525,40720,1527,2,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',1759.99,NULL,NULL,1,'2022-11-08 12:53:08','2022-11-08 12:53:08',NULL),(97,7525,40720,1527,2,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',1730.00,NULL,NULL,1,'2022-11-08 12:53:08','2022-11-08 12:53:08',NULL),(98,7525,40720,1527,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',27059.99,NULL,NULL,1,'2022-11-08 12:53:08','2022-11-08 12:53:08',NULL),(99,7525,40720,1527,2,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',6479.96,NULL,NULL,1,'2022-11-08 12:53:09','2022-11-08 12:53:09',NULL),(100,7525,40720,1527,2,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',1759.99,NULL,NULL,1,'2022-11-08 12:53:09','2022-11-08 12:53:09',NULL),(101,7525,40720,1527,2,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',6819.98,NULL,NULL,1,'2022-11-08 12:53:09','2022-11-08 12:53:09',NULL),(102,7525,40720,1527,2,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',2350.00,NULL,NULL,1,'2022-11-08 12:53:09','2022-11-08 12:53:09',NULL),(103,7525,40720,1527,2,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',22364.90,NULL,NULL,1,'2022-11-08 12:53:09','2022-11-08 12:53:09',NULL),(104,7525,40720,1527,2,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',12339.99,NULL,NULL,1,'2022-11-08 12:53:09','2022-11-08 12:53:09',NULL),(105,7525,40720,1527,2,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',8160.00,NULL,NULL,1,'2022-11-08 12:53:09','2022-11-08 12:53:09',NULL),(106,7525,40720,1527,2,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',2759.96,NULL,NULL,1,'2022-11-08 12:53:09','2022-11-08 12:53:09',NULL);
INSERT INTO `balance_libro` VALUES (107,7525,40720,1527,2,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',19500.00,NULL,NULL,1,'2022-11-08 12:53:09','2022-11-08 12:53:09',NULL),(108,7525,40720,1527,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',7650.00,NULL,NULL,1,'2022-11-08 12:53:09','2022-11-08 12:53:09',NULL),(109,7525,40720,1527,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',940.00,NULL,NULL,1,'2022-11-08 12:53:09','2022-11-08 12:53:09',NULL),(110,7525,40720,1527,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',1935.00,NULL,NULL,1,'2022-11-08 12:53:09','2022-11-08 12:53:09',NULL),(111,7525,40720,1527,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',10829.98,NULL,NULL,1,'2022-11-08 12:53:10','2022-11-08 12:53:10',NULL),(112,7525,40720,1527,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',5414.99,NULL,NULL,1,'2022-11-08 12:53:10','2022-11-08 12:53:10',NULL),(113,7525,40720,1527,2,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',54634.82,NULL,NULL,1,'2022-11-08 12:53:10','2022-11-08 12:53:10',NULL),(114,7525,40720,1527,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',17099.99,NULL,NULL,1,'2022-11-08 12:53:10','2022-11-08 12:53:10',NULL),(115,7525,40720,1527,2,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',1860.00,NULL,NULL,1,'2022-11-08 12:53:10','2022-11-08 12:53:10',NULL),(116,7525,40720,1527,2,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1140.00,NULL,NULL,1,'2022-11-08 12:53:10','2022-11-08 12:53:10',NULL),(117,7525,40720,1527,2,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',11969.99,NULL,NULL,1,'2022-11-08 12:53:10','2022-11-08 12:53:10',NULL),(118,7525,40720,1527,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',839.99,NULL,NULL,1,'2022-11-08 12:53:44','2022-11-08 12:53:44',NULL),(119,7525,40720,1527,2,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2940.00,NULL,NULL,1,'2022-11-08 12:53:44','2022-11-08 12:53:44',NULL),(120,7525,40720,1527,2,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',3415.00,NULL,NULL,1,'2022-11-08 12:53:44','2022-11-08 12:53:44',NULL),(121,7525,40720,1527,2,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',1150.00,NULL,NULL,1,'2022-11-08 12:53:44','2022-11-08 12:53:44',NULL),(122,7525,40720,1527,2,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',9599.99,NULL,NULL,1,'2022-11-08 12:53:44','2022-11-08 12:53:44',NULL),(123,7525,40720,1527,2,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',26049.73,NULL,NULL,1,'2022-11-08 12:53:44','2022-11-08 12:53:44',NULL),(124,7525,40720,1527,2,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',360.00,NULL,NULL,1,'2022-11-08 12:53:44','2022-11-08 12:53:44',NULL),(125,7525,40720,1527,2,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',20879.80,NULL,NULL,1,'2022-11-08 12:53:44','2022-11-08 12:53:44',NULL),(126,7525,40720,1527,2,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',23600.00,NULL,NULL,1,'2022-11-08 12:53:44','2022-11-08 12:53:44',NULL),(127,7525,40720,1527,2,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',450.00,NULL,NULL,1,'2022-11-08 12:53:44','2022-11-08 12:53:44',NULL);
INSERT INTO `balance_libro` VALUES (128,7525,40720,1527,2,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',18900.00,NULL,NULL,1,'2022-11-08 12:53:44','2022-11-08 12:53:44',NULL),(129,7525,40720,1527,2,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',5063.85,NULL,NULL,1,'2022-11-08 12:53:44','2022-11-08 12:53:44',NULL),(130,7525,40720,1527,2,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',360.58,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(131,7525,40720,1527,2,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',2601.50,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(132,7525,40720,1527,2,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',4770.18,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(133,7525,40720,1527,2,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',339.90,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(134,7525,40720,1527,2,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',1210.00,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(135,7525,40720,1527,2,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',1699.99,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(136,7525,40720,1527,2,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',3880.00,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(137,7525,40720,1527,2,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',1860.00,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(138,7525,40720,1527,2,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',2170.00,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(139,7525,40720,1527,2,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',4990.00,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(140,7525,40720,1527,2,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',2330.00,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(141,7525,40720,1527,2,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',11929.99,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(142,7525,40720,1527,2,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',3300.00,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(143,7525,40720,1527,2,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',24199.92,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(144,7525,40720,1527,2,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',4590.00,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(145,7525,40720,1527,2,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',8909.96,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(146,7525,40720,1527,2,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',400.00,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(147,7525,40720,1527,2,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',549.99,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(148,7525,40720,1527,2,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',7867.00,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL);
INSERT INTO `balance_libro` VALUES (149,7525,40720,1527,2,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',2530.00,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(150,7525,40720,1527,2,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',1850.00,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(151,7525,40720,1527,2,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',10829.98,NULL,NULL,1,'2022-11-08 12:53:45','2022-11-08 12:53:45',NULL),(152,7525,40720,1527,2,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',300.00,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL),(153,7525,40720,1527,2,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',540.00,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL),(154,7525,40720,1527,2,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',8100.01,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL),(155,7525,40720,1527,2,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',1140.00,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL),(156,7525,40720,1527,2,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',22350.00,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL),(157,7525,40720,1527,2,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',2680.00,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL),(158,7525,40720,1527,2,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',9090.61,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL),(159,7525,40720,1527,2,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',670.00,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL),(160,7525,40720,1527,2,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',16245.01,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL),(161,7525,40720,1527,2,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',3240.00,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL),(162,7525,40720,1527,2,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',1049.99,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL),(163,7525,40720,1527,2,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',1519.99,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL),(164,7525,40720,1527,2,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',8174.94,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL),(165,7525,40720,1527,2,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',1150.10,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL),(166,7525,40720,1527,2,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',28480.00,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL),(167,7525,40720,1527,2,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',10964.97,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL),(168,7525,40720,1527,2,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',10519.99,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL),(169,7525,40720,1527,2,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',6779.99,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL);
INSERT INTO `balance_libro` VALUES (170,7525,40720,1527,2,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',749.99,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL),(171,7525,40720,1527,2,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',860.00,NULL,NULL,1,'2022-11-08 12:53:46','2022-11-08 12:53:46',NULL),(172,7525,40720,1527,3,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',78209.85,NULL,NULL,1,'2022-11-08 12:54:35','2022-11-08 12:54:35',NULL),(173,7525,40720,1527,3,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',107.07,NULL,NULL,1,'2022-11-08 12:54:35','2022-11-08 12:54:35',NULL),(174,7525,40720,1527,3,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',90.00,NULL,NULL,1,'2022-11-08 12:54:35','2022-11-08 12:54:35',NULL),(175,7525,40720,1527,3,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',44581.68,NULL,NULL,1,'2022-11-08 12:54:35','2022-11-08 12:54:35',NULL),(176,7525,40720,1527,3,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',62363.40,NULL,NULL,1,'2022-11-08 12:54:35','2022-11-08 12:54:35',NULL),(177,7525,40720,1527,3,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',62363.40,NULL,NULL,1,'2022-11-08 12:54:35','2022-11-08 12:54:35',NULL),(178,7525,40720,1527,3,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',6081.60,NULL,NULL,1,'2022-11-08 12:54:35','2022-11-08 12:54:35',NULL),(179,7525,40720,1527,3,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',17026.54,NULL,NULL,1,'2022-11-08 12:54:35','2022-11-08 12:54:35',NULL),(180,7525,40720,1527,3,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',30604.00,NULL,NULL,1,'2022-11-08 12:54:35','2022-11-08 12:54:35',NULL),(181,7525,40720,1527,3,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',45254.48,NULL,NULL,1,'2022-11-08 12:54:35','2022-11-08 12:54:35',NULL),(182,7525,40720,1527,3,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',215.00,NULL,NULL,1,'2022-11-08 12:54:35','2022-11-08 12:54:35',NULL),(183,7525,40720,1527,3,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',3127.22,NULL,NULL,1,'2022-11-08 12:54:35','2022-11-08 12:54:35',NULL),(184,7525,40720,1527,3,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',404.54,NULL,NULL,1,'2022-11-08 12:54:35','2022-11-08 12:54:35',NULL),(185,7525,40720,1527,3,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',20.00,NULL,NULL,1,'2022-11-08 12:54:35','2022-11-08 12:54:35',NULL),(186,7525,40720,1527,3,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',428.00,NULL,NULL,1,'2022-11-08 12:54:35','2022-11-08 12:54:35',NULL),(187,7525,40720,1527,3,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',53004.53,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(188,7525,40720,1527,3,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',72405.00,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(189,7525,40720,1527,3,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',272.00,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(190,7525,40720,1527,3,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',34.00,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL);
INSERT INTO `balance_libro` VALUES (191,7525,40720,1527,3,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',250901.55,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(192,7525,40720,1527,3,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',29889.00,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(193,7525,40720,1527,3,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',309.92,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(194,7525,40720,1527,3,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1845765.82,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(195,7525,40720,1527,3,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',17325.00,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(196,7525,40720,1527,3,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',7008.79,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(197,7525,40720,1527,3,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',16605.32,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(198,7525,40720,1527,3,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',40861.32,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(199,7525,40720,1527,3,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',36314.00,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(200,7525,40720,1527,3,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',66000.00,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(201,7525,40720,1527,3,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',41872.28,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(202,7525,40720,1527,3,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',74418.75,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(203,7525,40720,1527,3,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',320.00,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(204,7525,40720,1527,3,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',17843.00,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(205,7525,40720,1527,3,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',35000.00,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(206,7525,40720,1527,3,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1679.67,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(207,7525,40720,1527,3,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',38844.21,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(208,7525,40720,1527,3,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',25838.84,NULL,NULL,1,'2022-11-08 12:54:36','2022-11-08 12:54:36',NULL),(209,7525,40720,1527,3,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',210600.00,NULL,NULL,1,'2022-11-08 12:54:37','2022-11-08 12:54:37',NULL),(210,7525,40720,1527,3,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',128812.50,NULL,NULL,1,'2022-11-08 12:54:37','2022-11-08 12:54:37',NULL),(211,7525,40720,1527,3,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',25436.25,NULL,NULL,1,'2022-11-08 12:54:37','2022-11-08 12:54:37',NULL);
INSERT INTO `balance_libro` VALUES (212,7525,40720,1527,3,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',18118.06,NULL,NULL,1,'2022-11-08 12:54:37','2022-11-08 12:54:37',NULL),(213,7525,40720,1527,3,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',10457.75,NULL,NULL,1,'2022-11-08 12:54:37','2022-11-08 12:54:37',NULL),(214,7525,40839,12124,2,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',245025.00,NULL,NULL,1,'2022-12-15 12:20:53','2022-12-15 12:20:53',NULL),(215,7525,40839,12124,2,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',149132.50,NULL,NULL,1,'2022-12-15 12:20:53','2022-12-15 12:20:53',NULL),(216,7525,40839,12124,2,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',435600.00,NULL,NULL,1,'2022-12-15 12:20:53','2022-12-15 12:20:53',NULL),(217,7525,40839,12124,2,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',60500.00,NULL,NULL,1,'2022-12-15 12:20:53','2022-12-15 12:20:53',NULL),(218,7525,40839,12124,3,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',795.00,NULL,NULL,1,'2022-12-15 12:21:15','2022-12-15 15:00:10','2022-12-15 15:00:10'),(219,7525,40839,12124,3,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',959.16,NULL,NULL,1,'2022-12-15 12:21:15','2022-12-15 15:00:56','2022-12-15 15:00:56'),(220,7525,40839,12124,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',4000.00,NULL,NULL,1,'2022-12-15 12:21:15','2022-12-29 14:59:19','2022-12-29 14:59:19'),(221,7525,40839,12124,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',3408.81,NULL,NULL,1,'2022-12-15 12:21:15','2022-12-29 15:08:45','2022-12-29 15:08:45'),(222,7525,40839,12124,3,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',183.00,NULL,NULL,1,'2022-12-15 12:21:15','2022-12-29 15:07:18','2022-12-29 15:07:18'),(223,7525,40839,12124,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',6000.00,NULL,NULL,1,'2022-12-15 12:21:15','2022-12-29 15:09:42','2022-12-29 15:09:42'),(224,7525,40839,12124,3,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',6836.40,NULL,NULL,1,'2022-12-15 12:21:15','2022-12-29 15:11:14','2022-12-29 15:11:14'),(225,7525,40839,12124,3,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',460.00,NULL,NULL,1,'2022-12-15 12:21:15','2022-12-15 15:04:50','2022-12-15 15:04:50'),(226,7525,40839,12124,3,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',99.00,NULL,NULL,1,'2022-12-15 12:21:15','2022-12-15 15:00:47','2022-12-15 15:00:47'),(227,7525,40839,12124,3,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',580.53,NULL,NULL,1,'2022-12-15 12:21:15','2022-12-15 15:00:30','2022-12-15 15:00:30'),(228,7525,40839,12124,3,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',8300.30,NULL,NULL,1,'2022-12-15 12:21:15','2022-12-29 15:10:37','2022-12-29 15:10:37'),(229,7525,40839,12124,3,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',120.00,NULL,NULL,1,'2022-12-15 12:21:15','2022-12-15 15:00:19','2022-12-15 15:00:19'),(230,7525,40839,12124,3,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',2999.99,NULL,NULL,1,'2022-12-15 15:16:27','2022-12-29 15:09:23','2022-12-29 15:09:23'),(231,7525,40839,12124,3,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4000.00,NULL,NULL,1,'2022-12-15 15:19:29','2022-12-15 15:20:47','2022-12-15 15:20:47');
INSERT INTO `balance_libro` VALUES (232,7525,40839,12124,3,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4000.00,NULL,NULL,1,'2022-12-15 15:20:47','2022-12-15 15:21:41','2022-12-15 15:21:41'),(233,7525,40839,12124,3,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4000.00,NULL,NULL,1,'2022-12-15 15:21:41','2022-12-15 15:24:10','2022-12-15 15:24:10'),(234,7525,40839,12124,3,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4000.00,NULL,NULL,1,'2022-12-15 15:24:10','2022-12-15 15:24:32','2022-12-15 15:24:32'),(235,7525,40839,12124,3,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4000.00,NULL,NULL,1,'2022-12-15 15:24:32','2022-12-29 14:58:19','2022-12-29 14:58:19'),(236,7525,40839,12124,7,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2.00,NULL,NULL,1,'2022-12-15 15:36:35','2022-12-15 15:38:11','2022-12-15 15:38:11'),(237,7525,40839,12124,7,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',247.92,NULL,NULL,1,'2022-12-15 15:38:11','2022-12-29 15:14:57','2022-12-29 15:14:57'),(238,7525,40849,13639,3,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',14746.56,NULL,NULL,1,'2022-12-16 14:16:31','2022-12-16 14:19:50','2022-12-16 14:19:50'),(239,7525,40849,13639,3,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',5286.18,NULL,NULL,1,'2022-12-16 14:16:31','2022-12-16 14:24:09','2022-12-16 14:24:09'),(240,7525,40849,13639,3,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',4821.42,NULL,NULL,1,'2022-12-16 14:16:31','2022-12-16 14:21:05','2022-12-16 14:21:05'),(241,7525,40849,13639,3,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',1872.34,NULL,NULL,1,'2022-12-16 14:16:31','2022-12-16 15:09:58','2022-12-16 15:09:58'),(242,7525,40849,13639,3,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',4978.34,NULL,NULL,1,'2022-12-16 14:16:31','2022-12-16 14:16:31',NULL),(243,7525,40849,13639,3,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',4950.54,NULL,NULL,1,'2022-12-16 14:16:31','2022-12-16 14:48:04','2022-12-16 14:48:04'),(244,7525,40849,13639,3,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',276.67,NULL,NULL,1,'2022-12-16 14:16:31','2022-12-16 14:46:23','2022-12-16 14:46:23'),(245,7525,40849,13639,3,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',17003.61,NULL,NULL,1,'2022-12-16 14:16:31','2022-12-16 14:16:31',NULL),(246,7525,40849,13639,3,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',119708.32,NULL,NULL,1,'2022-12-16 14:16:31','2022-12-16 14:16:31',NULL),(247,7525,40849,13639,3,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',4491.61,NULL,NULL,1,'2022-12-16 14:16:31','2022-12-16 14:16:31',NULL),(248,7525,40849,13639,3,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',4491.61,NULL,NULL,1,'2022-12-16 14:16:31','2022-12-16 14:50:40','2022-12-16 14:50:40'),(249,7525,40849,13639,3,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',2869.06,NULL,NULL,1,'2022-12-16 14:16:31','2022-12-16 14:16:31',NULL),(250,7525,40849,13639,3,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',6000.00,NULL,NULL,1,'2022-12-16 14:16:31','2022-12-16 14:16:31',NULL),(251,7525,40849,13639,3,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',3872.00,NULL,NULL,1,'2022-12-16 14:16:31','2022-12-16 15:09:01','2022-12-16 15:09:01');
INSERT INTO `balance_libro` VALUES (252,7525,40849,13639,3,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',675.07,NULL,NULL,1,'2022-12-16 14:16:31','2022-12-16 14:16:31',NULL),(253,7525,40849,13639,3,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',5980.76,NULL,NULL,1,'2022-12-16 14:16:31','2022-12-16 14:16:31',NULL),(254,7525,40849,13639,3,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',13377.67,NULL,NULL,1,'2022-12-16 14:16:31','2022-12-16 14:16:31',NULL),(255,7525,40849,13639,3,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',106969.20,NULL,NULL,1,'2022-12-16 14:16:31','2022-12-16 14:16:31',NULL),(256,7525,40849,13639,3,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',12052.60,NULL,NULL,1,'2022-12-16 14:16:31','2022-12-16 14:16:31',NULL),(257,7525,40849,13639,3,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',10900.85,NULL,NULL,1,'2022-12-16 14:16:32','2022-12-16 14:16:32',NULL),(258,7525,40849,13639,3,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',24433.83,NULL,NULL,1,'2022-12-16 14:16:32','2022-12-16 15:06:38','2022-12-16 15:06:38'),(259,7525,40849,13639,3,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',1370.00,NULL,NULL,1,'2022-12-16 14:16:32','2022-12-16 15:06:15','2022-12-16 15:06:15'),(260,7525,40849,13639,3,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',6746.47,NULL,NULL,1,'2022-12-16 14:16:32','2022-12-16 15:07:52','2022-12-16 15:07:52'),(261,7525,40849,13639,3,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',1370.00,NULL,NULL,1,'2022-12-16 14:16:32','2022-12-16 15:06:02','2022-12-16 15:06:02'),(262,7525,40849,13639,3,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',1370.00,NULL,NULL,1,'2022-12-16 14:16:32','2022-12-16 15:05:46','2022-12-16 15:05:46'),(263,7525,40849,13639,3,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',1227.33,NULL,NULL,1,'2022-12-16 14:16:32','2022-12-16 14:16:32',NULL),(264,7525,40849,13639,3,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',109787.53,NULL,NULL,1,'2022-12-16 14:16:32','2022-12-16 14:16:32',NULL),(265,7525,40849,13639,3,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',16878.55,NULL,NULL,1,'2022-12-16 14:16:32','2022-12-16 14:16:32',NULL),(266,7525,40849,13639,3,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',12985.39,NULL,NULL,1,'2022-12-16 14:16:32','2022-12-16 14:16:32',NULL),(267,7525,40849,13639,3,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',10260.27,NULL,NULL,1,'2022-12-16 14:16:32','2022-12-16 14:16:32',NULL),(268,7525,40849,13639,3,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5040.38,NULL,NULL,1,'2022-12-16 14:16:32','2022-12-16 14:23:18','2022-12-16 14:23:18'),(269,7525,40849,13639,3,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',14746.56,NULL,NULL,1,'2022-12-16 14:19:50','2022-12-16 14:19:50',NULL),(270,7525,40849,13639,3,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',4821.42,NULL,NULL,1,'2022-12-16 14:21:05','2022-12-16 14:21:05',NULL),(271,7525,40849,13639,3,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',5286.18,NULL,NULL,1,'2022-12-16 14:24:09','2022-12-16 14:24:09',NULL);
INSERT INTO `balance_libro` VALUES (272,7525,40849,13639,3,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',276.67,NULL,NULL,1,'2022-12-16 14:46:23','2022-12-16 14:46:23',NULL),(273,7525,40849,13639,3,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',4950.55,NULL,NULL,1,'2022-12-16 14:48:04','2022-12-16 14:48:04',NULL),(274,7525,40849,13639,3,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',3872.00,NULL,NULL,1,'2022-12-16 15:11:49','2022-12-16 15:11:49',NULL),(275,7525,40856,15151,2,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',118701.00,NULL,NULL,1,'2022-12-16 15:41:10','2022-12-16 15:41:10',NULL),(276,7525,40856,15151,2,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',378730.00,NULL,NULL,1,'2022-12-16 15:41:10','2022-12-16 15:41:10',NULL),(277,7525,40856,15151,3,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',9840.64,NULL,NULL,1,'2022-12-16 15:41:23','2022-12-16 15:41:23',NULL),(278,7525,40856,15151,3,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4899.99,NULL,NULL,1,'2022-12-16 15:41:23','2022-12-16 15:41:23',NULL),(279,7525,40856,15151,3,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',21567.15,NULL,NULL,1,'2022-12-16 15:41:23','2022-12-16 19:06:51','2022-12-16 19:06:51'),(280,7525,40856,15151,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',3199.99,NULL,NULL,1,'2022-12-16 15:41:23','2022-12-16 15:41:23',NULL),(281,7525,40856,15151,3,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',4900.00,NULL,NULL,1,'2022-12-16 15:41:23','2022-12-16 15:41:23',NULL),(282,7525,40856,15151,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',8500.00,NULL,NULL,1,'2022-12-16 15:41:23','2022-12-16 15:41:23',NULL),(283,7525,40856,15151,3,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',163.00,NULL,NULL,1,'2022-12-16 15:41:23','2022-12-16 19:00:07','2022-12-16 19:00:07'),(284,7525,40856,15151,3,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',151.71,NULL,NULL,1,'2022-12-16 15:41:24','2022-12-16 16:51:04','2022-12-16 16:51:04'),(285,7525,40856,15151,3,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2500.00,NULL,NULL,1,'2022-12-16 15:41:24','2022-12-16 15:41:24',NULL),(286,7525,40856,15151,3,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',3000.00,NULL,NULL,1,'2022-12-16 15:41:24','2022-12-16 15:41:24',NULL),(287,7525,40856,15151,3,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',18000.00,NULL,NULL,1,'2022-12-16 15:41:24','2022-12-16 15:41:24',NULL),(288,7525,40856,15151,3,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',7800.00,NULL,NULL,1,'2022-12-16 15:41:24','2022-12-16 15:41:24',NULL),(289,7525,40856,15151,3,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',17013.69,NULL,NULL,1,'2022-12-16 15:41:24','2022-12-16 19:05:22','2022-12-16 19:05:22'),(290,7525,40856,15151,3,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',15935.09,NULL,NULL,1,'2022-12-16 15:41:24','2022-12-16 19:04:41','2022-12-16 19:04:41'),(291,7525,40856,15151,3,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',4790.38,NULL,NULL,1,'2022-12-16 15:41:25','2022-12-16 19:03:24','2022-12-16 19:03:24');
INSERT INTO `balance_libro` VALUES (292,7525,40856,15151,3,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',2000.00,NULL,NULL,1,'2022-12-16 15:41:25','2022-12-16 15:41:25',NULL),(293,7525,40856,15151,3,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',2550.20,NULL,NULL,1,'2022-12-16 15:41:25','2022-12-16 15:41:25',NULL),(294,7525,40856,15151,3,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',1100.00,NULL,NULL,1,'2022-12-16 15:41:25','2022-12-16 15:41:25',NULL),(295,7525,40856,15151,3,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',10001.50,NULL,NULL,1,'2022-12-16 15:41:25','2022-12-16 19:10:13','2022-12-16 19:10:13'),(296,7525,40856,15151,3,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',7000.00,NULL,NULL,1,'2022-12-16 15:41:25','2022-12-16 15:41:25',NULL),(297,7525,40856,15151,3,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',7437.00,NULL,NULL,1,'2022-12-16 15:41:25','2022-12-16 16:54:28','2022-12-16 16:54:28'),(298,7525,40856,15151,3,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',3500.00,NULL,NULL,1,'2022-12-16 15:41:25','2022-12-16 19:11:56','2022-12-16 19:11:56'),(299,7525,40856,15151,3,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',259.07,NULL,NULL,1,'2022-12-16 15:41:26','2022-12-16 19:00:18','2022-12-16 19:00:18'),(300,7525,40856,15151,3,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',5121.75,NULL,NULL,1,'2022-12-16 15:41:26','2022-12-16 19:11:42','2022-12-16 19:11:42'),(301,7525,40856,15151,3,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',160.00,NULL,NULL,1,'2022-12-16 15:41:26','2022-12-16 16:54:43','2022-12-16 16:54:43'),(302,7525,40856,15151,3,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',6500.00,NULL,NULL,1,'2022-12-16 15:41:26','2022-12-16 15:41:26',NULL),(303,7525,40856,15151,3,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',1857.64,NULL,NULL,1,'2022-12-16 15:41:27','2022-12-18 21:52:20','2022-12-18 21:52:20'),(304,7525,40856,15151,3,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',55499.83,NULL,NULL,1,'2022-12-16 15:41:27','2022-12-16 15:41:27',NULL),(305,7525,40856,15151,3,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',70999.97,NULL,NULL,1,'2022-12-16 15:41:27','2022-12-16 15:41:27',NULL),(306,7525,40856,15151,3,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',5501.40,NULL,NULL,1,'2022-12-16 15:41:27','2022-12-18 22:14:09','2022-12-18 22:14:09'),(307,7525,40856,15151,3,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',11200.00,NULL,NULL,1,'2022-12-16 15:41:28','2022-12-16 16:53:31','2022-12-16 16:53:31'),(308,7525,40856,15151,3,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',11999.00,NULL,NULL,1,'2022-12-16 15:41:28','2022-12-16 16:53:16','2022-12-16 16:53:16'),(309,7525,40856,15151,3,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',444.94,NULL,NULL,1,'2022-12-16 15:41:28','2022-12-18 22:09:29','2022-12-18 22:09:29'),(310,7525,40856,15151,3,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',3579.20,NULL,NULL,1,'2022-12-16 15:41:28','2022-12-16 15:41:28',NULL),(311,7525,40856,15151,3,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',899.01,NULL,NULL,1,'2022-12-16 15:41:28','2022-12-16 16:51:56','2022-12-16 16:51:56');
INSERT INTO `balance_libro` VALUES (312,7525,40856,15151,3,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1399.00,NULL,NULL,1,'2022-12-16 15:41:28','2022-12-16 16:51:46','2022-12-16 16:51:46'),(313,7525,40856,15151,3,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',899.01,NULL,NULL,1,'2022-12-16 15:41:28','2022-12-16 16:51:39','2022-12-16 16:51:39'),(314,7525,40856,15151,3,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1399.00,NULL,NULL,1,'2022-12-16 15:41:28','2022-12-16 16:51:32','2022-12-16 16:51:32'),(315,7525,40856,15151,3,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',899.01,NULL,NULL,1,'2022-12-16 15:41:29','2022-12-16 16:51:25','2022-12-16 16:51:25'),(316,7525,40856,15151,3,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',26179.98,NULL,NULL,1,'2022-12-16 15:41:29','2022-12-16 15:41:29',NULL),(317,7525,40849,13639,2,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',26852.00,NULL,NULL,1,'2022-12-16 18:32:34','2022-12-16 18:32:34',NULL),(318,7525,40849,13639,2,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',2355.00,NULL,NULL,1,'2022-12-16 18:32:34','2022-12-16 18:32:34',NULL),(319,7525,40849,13639,2,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',16310.00,NULL,NULL,1,'2022-12-16 18:32:34','2022-12-16 18:32:34',NULL),(320,7525,40849,13639,2,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',31641.00,NULL,NULL,1,'2022-12-16 18:32:34','2022-12-16 18:32:34',NULL),(321,7525,40849,13639,2,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',50151.00,NULL,NULL,1,'2022-12-16 18:32:34','2022-12-16 18:32:34',NULL),(322,7525,40849,13639,2,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',32450.00,NULL,NULL,1,'2022-12-16 18:32:34','2022-12-16 18:32:34',NULL),(323,7525,40849,13639,2,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',32543.00,NULL,NULL,1,'2022-12-16 18:32:34','2022-12-16 18:32:34',NULL),(324,7525,40849,13639,2,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',380.00,NULL,NULL,1,'2022-12-16 18:32:34','2022-12-16 18:32:34',NULL),(325,7525,40849,13639,2,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',10860.00,NULL,NULL,1,'2022-12-16 18:32:34','2022-12-16 18:32:34',NULL),(326,7525,40849,13639,2,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',2440.00,NULL,NULL,1,'2022-12-16 18:32:34','2022-12-16 18:32:34',NULL),(327,7525,40849,13639,2,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',6270.00,NULL,NULL,1,'2022-12-16 18:32:34','2022-12-16 18:32:34',NULL),(328,7525,40849,13639,2,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',26330.00,NULL,NULL,1,'2022-12-16 18:32:34','2022-12-16 18:32:34',NULL),(329,7525,40849,13639,2,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',24479.00,NULL,NULL,1,'2022-12-16 18:32:34','2022-12-16 18:32:34',NULL),(330,7525,40849,13639,2,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',22772.00,NULL,NULL,1,'2022-12-16 18:32:35','2022-12-16 18:32:35',NULL),(331,7525,40849,13639,2,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',22704.00,NULL,NULL,1,'2022-12-16 18:32:35','2022-12-16 18:32:35',NULL),(332,7525,40849,13639,2,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',10575.00,NULL,NULL,1,'2022-12-16 18:32:35','2022-12-16 18:32:35',NULL);
INSERT INTO `balance_libro` VALUES (333,7525,40849,13639,2,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',55057.00,NULL,NULL,1,'2022-12-16 18:32:35','2022-12-16 18:32:35',NULL),(334,7525,40849,13639,2,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',11266.00,NULL,NULL,1,'2022-12-16 18:32:35','2022-12-16 18:32:35',NULL),(335,7525,40849,13639,2,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',22881.00,NULL,NULL,1,'2022-12-16 18:32:35','2022-12-16 18:32:35',NULL),(336,7525,40849,13639,2,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',7595.00,NULL,NULL,1,'2022-12-16 18:32:35','2022-12-16 18:32:35',NULL),(337,7525,40849,13639,2,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',32148.00,NULL,NULL,1,'2022-12-16 18:32:35','2022-12-16 18:32:35',NULL),(338,7525,40849,13639,2,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',32899.00,NULL,NULL,1,'2022-12-16 18:32:35','2022-12-16 18:32:35',NULL),(339,7525,40849,13639,2,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',74250.00,NULL,NULL,1,'2022-12-16 18:32:35','2022-12-16 18:32:35',NULL),(340,7525,40849,13639,2,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',9202.00,NULL,NULL,1,'2022-12-16 18:32:35','2022-12-16 18:32:35',NULL),(341,7525,40849,13639,2,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',33094.00,NULL,NULL,1,'2022-12-16 18:32:35','2022-12-16 18:32:35',NULL),(342,7525,40849,13639,2,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',26890.70,NULL,NULL,1,'2022-12-16 18:32:35','2022-12-16 18:32:35',NULL),(343,7525,40849,13639,7,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',5000.00,NULL,NULL,1,'2022-12-16 18:36:55','2022-12-16 18:38:10','2022-12-16 18:38:10'),(344,7525,40849,13639,7,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',4909.60,NULL,NULL,1,'2022-12-16 18:38:10','2022-12-16 18:38:10',NULL),(345,7525,40856,15151,3,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',4790.42,NULL,NULL,1,'2022-12-16 19:03:24','2022-12-16 19:03:24',NULL),(346,7525,40856,15151,3,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',15935.21,NULL,NULL,1,'2022-12-16 19:04:41','2022-12-16 19:04:41',NULL),(347,7525,40856,15151,3,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',17013.69,NULL,NULL,1,'2022-12-16 19:05:22','2022-12-16 19:05:22',NULL),(348,7525,40856,15151,3,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',21567.15,NULL,NULL,1,'2022-12-16 19:06:51','2022-12-16 19:06:51',NULL),(349,7525,40856,15151,3,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1299.96,NULL,NULL,1,'2022-12-18 21:13:27','2022-12-18 21:13:27',NULL),(350,7525,40856,15151,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',36899.97,NULL,NULL,1,'2022-12-18 21:14:47','2022-12-18 21:14:47',NULL),(351,7525,40856,15151,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1300.00,NULL,NULL,1,'2022-12-18 21:16:08','2022-12-18 21:16:08',NULL),(352,7525,40856,15151,3,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',77600.01,NULL,NULL,1,'2022-12-18 21:16:32','2022-12-18 21:16:32',NULL),(353,7525,40856,15151,3,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1600.00,NULL,NULL,1,'2022-12-18 21:17:24','2022-12-18 21:17:24',NULL);
INSERT INTO `balance_libro` VALUES (354,7525,40856,15151,3,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4199.96,NULL,NULL,1,'2022-12-18 21:17:44','2022-12-18 21:17:44',NULL),(355,7525,40856,15151,3,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',6100.00,NULL,NULL,1,'2022-12-18 21:18:12','2022-12-18 21:18:12',NULL),(356,7525,40856,15151,3,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',9900.00,NULL,NULL,1,'2022-12-18 21:18:33','2022-12-18 21:18:33',NULL),(357,7525,40856,15151,3,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2699.99,NULL,NULL,1,'2022-12-18 21:18:56','2022-12-18 21:18:56',NULL),(358,7525,40856,15151,3,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1200.01,NULL,NULL,1,'2022-12-18 21:19:17','2022-12-18 21:19:17',NULL),(359,7525,40856,15151,3,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2800.00,NULL,NULL,1,'2022-12-18 21:20:50','2022-12-18 21:20:50',NULL),(360,7525,40856,15151,3,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',8600.00,NULL,NULL,1,'2022-12-18 21:21:19','2022-12-18 21:21:19',NULL),(361,7525,40856,15151,3,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',5600.00,NULL,NULL,1,'2022-12-18 21:21:51','2022-12-18 21:21:51',NULL),(362,7525,40856,15151,3,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',6300.00,NULL,NULL,1,'2022-12-18 21:23:26','2022-12-18 21:23:26',NULL),(363,7525,40856,15151,3,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1800.00,NULL,NULL,1,'2022-12-18 21:23:59','2022-12-18 21:23:59',NULL),(364,7525,40856,15151,3,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1100.00,NULL,NULL,1,'2022-12-18 21:24:16','2022-12-18 21:24:16',NULL),(365,7525,40856,15151,3,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1700.00,NULL,NULL,1,'2022-12-18 21:24:31','2022-12-18 21:24:31',NULL),(366,7525,40856,15151,3,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2899.99,NULL,NULL,1,'2022-12-18 21:24:57','2022-12-18 21:24:57',NULL),(367,7525,40856,15151,3,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',6500.00,NULL,NULL,1,'2022-12-18 21:25:17','2022-12-18 21:25:17',NULL),(368,7525,40856,15151,3,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2500.01,NULL,NULL,1,'2022-12-18 21:25:37','2022-12-18 21:25:37',NULL),(369,7525,40856,15151,3,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2000.00,NULL,NULL,1,'2022-12-18 21:26:21','2022-12-18 21:26:21',NULL),(370,7525,40856,15151,3,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2300.00,NULL,NULL,1,'2022-12-18 21:26:38','2022-12-18 21:26:38',NULL),(371,7525,40856,15151,3,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2400.00,NULL,NULL,1,'2022-12-18 21:26:57','2022-12-18 21:26:57',NULL),(372,7525,40856,15151,3,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',5501.40,NULL,NULL,1,'2022-12-18 22:14:09','2022-12-18 22:14:09',NULL),(373,7525,40856,15151,7,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',254.19,NULL,NULL,1,'2022-12-18 22:23:14','2022-12-18 22:23:14',NULL),(374,7525,40875,16663,2,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',128000.00,NULL,NULL,1,'2022-12-19 11:11:13','2022-12-19 11:14:42','2022-12-19 11:14:42');
INSERT INTO `balance_libro` VALUES (375,7525,40875,16663,2,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',138000.00,NULL,NULL,1,'2022-12-19 11:11:13','2022-12-19 11:16:08','2022-12-19 11:16:08'),(376,7525,40875,16663,2,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',18599.12,NULL,NULL,1,'2022-12-19 11:11:13','2022-12-19 11:11:13',NULL),(377,7525,40875,16663,2,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',9299.56,NULL,NULL,1,'2022-12-19 11:11:13','2022-12-19 11:11:13',NULL),(378,7525,40875,16663,2,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',3736.00,NULL,NULL,1,'2022-12-19 11:11:13','2022-12-19 11:11:13',NULL),(379,7525,40875,16663,2,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',4640.00,NULL,NULL,1,'2022-12-19 11:11:13','2022-12-19 11:11:13',NULL),(380,7525,40875,16663,2,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',2660.00,NULL,NULL,1,'2022-12-19 11:11:13','2022-12-19 11:11:13',NULL),(381,7525,40875,16663,2,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',199680.00,NULL,NULL,1,'2022-12-19 11:11:13','2022-12-19 11:15:47','2022-12-19 11:15:47'),(382,7525,40875,16663,2,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',8800.00,NULL,NULL,1,'2022-12-19 11:11:13','2022-12-19 11:11:13',NULL),(383,7525,40875,16663,2,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',521100.00,NULL,NULL,1,'2022-12-19 11:11:13','2022-12-19 11:15:33','2022-12-19 11:15:33'),(384,7525,40875,16663,2,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',247400.00,NULL,NULL,1,'2022-12-19 11:11:13','2022-12-19 11:15:16','2022-12-19 11:15:16'),(385,7525,40875,16663,2,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',10648.00,NULL,NULL,1,'2022-12-19 11:11:13','2022-12-19 11:11:13',NULL),(386,7525,40875,16663,2,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',8800.00,NULL,NULL,1,'2022-12-19 11:11:13','2022-12-19 11:11:13',NULL),(387,7525,40875,16663,2,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',233000.00,NULL,NULL,1,'2022-12-19 11:11:13','2022-12-19 11:16:48','2022-12-19 11:16:48'),(388,7525,40875,16663,2,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',8800.00,NULL,NULL,1,'2022-12-19 11:11:13','2022-12-19 11:11:13',NULL),(389,7525,40875,16663,2,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',10648.00,NULL,NULL,1,'2022-12-19 11:11:13','2022-12-19 11:11:13',NULL),(390,7525,40875,16663,2,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',8800.00,NULL,NULL,1,'2022-12-19 11:11:13','2022-12-19 11:11:13',NULL),(391,7525,40875,16663,2,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',8800.00,NULL,NULL,1,'2022-12-19 11:11:13','2022-12-19 11:11:13',NULL),(392,7525,40875,16663,2,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',8800.00,NULL,NULL,1,'2022-12-19 11:11:13','2022-12-19 11:11:13',NULL),(393,7525,40875,16663,3,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',25598.00,NULL,NULL,1,'2022-12-19 11:11:26','2022-12-19 11:11:26',NULL),(394,7525,40875,16663,3,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',15722.27,NULL,NULL,1,'2022-12-19 11:11:26','2022-12-19 14:01:01','2022-12-19 14:01:01');
INSERT INTO `balance_libro` VALUES (395,7525,40875,16663,3,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',188257.35,NULL,NULL,1,'2022-12-19 11:11:26','2022-12-19 11:11:26',NULL),(396,7525,40875,16663,3,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',150705.62,NULL,NULL,1,'2022-12-19 11:11:26','2022-12-19 11:11:26',NULL),(397,7525,40875,16663,3,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',95.00,NULL,NULL,1,'2022-12-19 11:11:26','2022-12-19 14:02:30','2022-12-19 14:02:30'),(398,7525,40875,16663,3,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',4998.99,NULL,NULL,1,'2022-12-19 11:11:26','2022-12-19 15:05:03','2022-12-19 15:05:03'),(399,7525,40875,16663,3,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',46430.84,NULL,NULL,1,'2022-12-19 11:11:26','2022-12-19 15:52:26','2022-12-19 15:52:26'),(400,7525,40875,16663,3,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',93356.34,NULL,NULL,1,'2022-12-19 11:11:26','2022-12-19 11:11:26',NULL),(401,7525,40875,16663,3,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',12390.00,NULL,NULL,1,'2022-12-19 11:11:26','2022-12-19 11:11:26',NULL),(402,7525,40875,16663,3,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',84050.42,NULL,NULL,1,'2022-12-19 11:11:26','2022-12-19 11:11:26',NULL),(403,7525,40875,16663,3,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',13660.00,NULL,NULL,1,'2022-12-19 11:11:26','2022-12-19 11:11:26',NULL),(404,7525,40875,16663,3,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',13950.00,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 11:11:27',NULL),(405,7525,40875,16663,3,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',5500.00,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 11:11:27',NULL),(406,7525,40875,16663,3,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',15722.27,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 14:00:44','2022-12-19 14:00:44'),(407,7525,40875,16663,3,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',16552.14,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 14:14:51','2022-12-19 14:14:51'),(408,7525,40875,16663,3,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',18000.00,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 11:11:27',NULL),(409,7525,40875,16663,3,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',5700.00,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 14:15:30','2022-12-19 14:15:30'),(410,7525,40875,16663,3,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',7616.69,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 14:32:03','2022-12-19 14:32:03'),(411,7525,40875,16663,3,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',11003.85,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 14:08:30','2022-12-19 14:08:30'),(412,7525,40875,16663,3,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',11003.85,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 14:08:43','2022-12-19 14:08:43'),(413,7525,40875,16663,3,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',215735.24,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 14:16:32','2022-12-19 14:16:32'),(414,7525,40875,16663,3,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',81000.04,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 14:11:09','2022-12-19 14:11:09');
INSERT INTO `balance_libro` VALUES (415,7525,40875,16663,3,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',29950.00,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 11:11:27',NULL),(416,7525,40875,16663,3,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',100000.00,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 11:11:27',NULL),(417,7525,40875,16663,3,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',136.00,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 14:09:28','2022-12-19 14:09:28'),(418,7525,40875,16663,3,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',1350.00,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 15:05:44','2022-12-19 15:05:44'),(419,7525,40875,16663,3,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',23825.04,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 15:23:29','2022-12-19 15:23:29'),(420,7525,40875,16663,3,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',182.15,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 14:00:32','2022-12-19 14:00:32'),(421,7525,40875,16663,3,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',215735.24,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 14:10:08','2022-12-19 14:10:08'),(422,7525,40875,16663,3,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',14996.98,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 11:11:27',NULL),(423,7525,40875,16663,3,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',468.00,NULL,NULL,1,'2022-12-19 11:11:27','2022-12-19 14:00:25','2022-12-19 14:00:25'),(424,7525,40875,16663,3,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',458.40,NULL,NULL,1,'2022-12-19 11:11:28','2022-12-19 14:00:18','2022-12-19 14:00:18'),(425,7525,40875,16663,3,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4345.00,NULL,NULL,1,'2022-12-19 11:11:28','2022-12-19 14:00:10','2022-12-19 14:00:10'),(426,7525,40875,16663,3,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',660.00,NULL,NULL,1,'2022-12-19 11:11:28','2022-12-19 14:00:03','2022-12-19 14:00:03'),(427,7525,40875,16663,3,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',179.00,NULL,NULL,1,'2022-12-19 11:11:28','2022-12-19 13:59:57','2022-12-19 13:59:57'),(428,7525,40875,16663,3,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',48109.60,NULL,NULL,1,'2022-12-19 11:11:28','2022-12-19 11:11:28',NULL),(429,7525,40875,16663,2,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',128000.00,NULL,NULL,1,'2022-12-19 11:14:42','2022-12-19 11:16:24','2022-12-19 11:16:24'),(430,7525,40875,16663,2,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',232396.26,NULL,NULL,1,'2022-12-19 11:15:16','2022-12-19 12:49:06','2022-12-19 12:49:06'),(431,7525,40875,16663,2,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',521100.00,NULL,NULL,1,'2022-12-19 11:15:33','2022-12-19 11:15:33',NULL),(432,7525,40875,16663,2,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',199680.00,NULL,NULL,1,'2022-12-19 11:15:47','2022-12-19 11:15:47',NULL),(433,7525,40875,16663,2,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',138000.00,NULL,NULL,1,'2022-12-19 11:16:08','2022-12-19 11:16:08',NULL),(434,7525,40875,16663,2,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',128000.00,NULL,NULL,1,'2022-12-19 11:16:24','2022-12-19 11:16:24',NULL);
INSERT INTO `balance_libro` VALUES (435,7525,40875,16663,2,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',233000.00,NULL,NULL,1,'2022-12-19 11:16:48','2022-12-19 11:16:48',NULL),(436,7525,40875,16663,2,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',157896.23,NULL,NULL,1,'2022-12-19 12:49:06','2022-12-19 12:50:05','2022-12-19 12:50:05'),(437,7525,40875,16663,2,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',247400.00,NULL,NULL,1,'2022-12-19 12:50:05','2022-12-19 12:50:05',NULL),(438,7525,40875,16663,3,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',81000.04,NULL,NULL,1,'2022-12-19 14:13:26','2022-12-19 15:32:41','2022-12-19 15:32:41'),(439,7525,40875,16663,3,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',8850.33,NULL,NULL,1,'2022-12-19 14:24:02','2022-12-19 14:24:02',NULL),(440,7525,40875,16663,3,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',9099.87,NULL,NULL,1,'2022-12-19 14:24:42','2022-12-19 14:24:42',NULL),(441,7525,40875,16663,3,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',4001.47,NULL,NULL,1,'2022-12-19 14:25:33','2022-12-19 14:25:33',NULL),(442,7525,40875,16663,3,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',7616.69,NULL,NULL,1,'2022-12-19 14:32:03','2022-12-19 15:42:05','2022-12-19 15:42:05'),(443,7525,40875,16663,3,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',4998.99,NULL,NULL,1,'2022-12-19 15:05:03','2022-12-19 15:05:03',NULL),(444,7525,40875,16663,3,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',1350.00,NULL,NULL,1,'2022-12-19 15:05:44','2022-12-19 15:05:44',NULL),(445,7525,40875,16663,3,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',23825.04,NULL,NULL,1,'2022-12-19 15:23:29','2022-12-19 15:24:40','2022-12-19 15:24:40'),(446,7525,40875,16663,3,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',23825.04,NULL,NULL,1,'2022-12-19 15:24:40','2022-12-19 15:24:40',NULL),(447,7525,40875,16663,3,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',81000.04,NULL,NULL,1,'2022-12-19 15:32:41','2022-12-19 15:34:41','2022-12-19 15:34:41'),(448,7525,40875,16663,3,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',81000.04,NULL,NULL,1,'2022-12-19 15:34:41','2022-12-19 15:34:41',NULL),(449,7525,40875,16663,3,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',7616.69,NULL,NULL,1,'2022-12-19 15:42:05','2022-12-19 15:53:26','2022-12-19 15:53:26'),(450,7525,40875,16663,3,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',46430.83,NULL,NULL,1,'2022-12-19 15:52:26','2022-12-19 15:52:26',NULL),(451,7525,40875,16663,3,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',7616.69,NULL,NULL,1,'2022-12-19 15:53:26','2022-12-19 15:53:26',NULL),(452,7525,40906,18175,2,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',8000.00,NULL,NULL,1,'2022-12-20 12:33:50','2022-12-20 12:33:50',NULL),(453,7525,40906,18175,2,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',44710.00,NULL,NULL,1,'2022-12-20 12:33:50','2022-12-20 12:33:50',NULL),(454,7525,40906,18175,2,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',44010.00,NULL,NULL,1,'2022-12-20 12:33:50','2022-12-20 12:33:50',NULL);
INSERT INTO `balance_libro` VALUES (455,7525,40906,18175,2,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',130000.00,NULL,NULL,1,'2022-12-20 12:33:50','2022-12-20 12:33:50',NULL),(456,7525,40906,18175,3,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',32990.00,NULL,NULL,1,'2022-12-20 12:34:04','2022-12-20 12:34:04',NULL),(457,7525,40906,18175,3,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',1500.00,NULL,NULL,1,'2022-12-20 12:34:05','2022-12-20 12:38:59','2022-12-20 12:38:59'),(458,7525,40906,18175,3,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',3464.65,NULL,NULL,1,'2022-12-20 12:34:05','2022-12-20 12:34:05',NULL),(459,7525,40906,18175,3,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',6000.00,NULL,NULL,1,'2022-12-20 12:34:05','2022-12-20 12:40:04','2022-12-20 12:40:04'),(460,7525,40906,18175,3,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',14455.45,NULL,NULL,1,'2022-12-20 12:34:05','2022-12-20 12:34:05',NULL),(461,7525,40906,18175,3,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',2891.30,NULL,NULL,1,'2022-12-20 12:34:05','2022-12-20 12:34:05',NULL),(462,7525,40906,18175,3,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',89999.00,NULL,NULL,1,'2022-12-20 12:34:05','2022-12-20 12:34:05',NULL),(463,7525,40906,18175,3,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',945.05,NULL,NULL,1,'2022-12-20 12:34:05','2022-12-20 12:41:17','2022-12-20 12:41:17'),(464,7525,40906,18175,3,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',24926.00,NULL,NULL,1,'2022-12-20 12:34:05','2022-12-20 12:34:05',NULL),(465,7525,40906,18175,3,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',20062.24,NULL,NULL,1,'2022-12-20 12:34:05','2022-12-20 12:34:05',NULL),(466,7525,40906,18175,3,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',39812.63,NULL,NULL,1,'2022-12-20 12:34:05','2022-12-20 12:34:05',NULL),(467,7525,40906,18175,3,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',6000.00,NULL,NULL,1,'2022-12-20 12:40:04','2022-12-20 12:40:04',NULL),(468,7525,40906,18175,3,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1808.03,NULL,NULL,1,'2022-12-20 13:26:49','2022-12-20 13:26:49',NULL),(469,7525,40906,18175,3,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',7317.66,NULL,NULL,1,'2022-12-20 13:27:48','2022-12-20 13:27:48',NULL),(470,7525,40906,18175,3,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',8610.00,NULL,NULL,1,'2022-12-20 13:29:30','2022-12-20 13:29:30',NULL),(471,7525,40906,18175,3,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2800.06,NULL,NULL,1,'2022-12-20 13:31:14','2022-12-20 13:31:14',NULL),(472,7525,40906,18175,7,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',26120.70,NULL,NULL,1,'2022-12-20 13:45:30','2022-12-20 13:45:30',NULL),(473,7525,40917,19690,2,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',102000.45,NULL,NULL,1,'2022-12-20 16:39:46','2022-12-20 16:39:46',NULL),(474,7525,40917,19690,2,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',7500.03,NULL,NULL,1,'2022-12-20 16:39:46','2022-12-20 16:39:46',NULL),(475,7525,40917,19690,2,439,'App\\Models\\Receipt',439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',23660.00,NULL,NULL,1,'2022-12-20 16:39:46','2022-12-20 16:39:46',NULL);
INSERT INTO `balance_libro` VALUES (476,7525,40917,19690,2,440,'App\\Models\\Receipt',440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',115000.46,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(477,7525,40917,19690,2,441,'App\\Models\\Receipt',441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',44000.32,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(478,7525,40917,19690,2,442,'App\\Models\\Receipt',442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',146000.54,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(479,7525,40917,19690,2,443,'App\\Models\\Receipt',443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',9080.02,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(480,7525,40917,19690,2,444,'App\\Models\\Receipt',444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',9760.02,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(481,7525,40917,19690,2,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',19600.00,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(482,7525,40917,19690,2,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',651.28,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(483,7525,40917,19690,2,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',3653.88,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(484,7525,40917,19690,2,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',4774.76,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(485,7525,40917,19690,2,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',4774.76,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(486,7525,40917,19690,2,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',2602.85,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(487,7525,40917,19690,2,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',4997.06,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(488,7525,40917,19690,2,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',11000.11,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(489,7525,40917,19690,2,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',2997.97,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(490,7525,40917,19690,2,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',1745.55,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(491,7525,40917,19690,2,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',2822.98,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(492,7525,40917,19690,2,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',7099.73,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(493,7525,40917,19690,2,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',3132.03,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(494,7525,40917,19690,2,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',4914.56,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(495,7525,40917,19690,2,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',4914.56,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(496,7525,40917,19690,2,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',484.65,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL);
INSERT INTO `balance_libro` VALUES (497,7525,40917,19690,2,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',4914.56,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(498,7525,40917,19690,2,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',5868.56,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(499,7525,40917,19690,2,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',4652.06,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(500,7525,40917,19690,2,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',14753.35,NULL,NULL,1,'2022-12-20 16:39:47','2022-12-20 16:39:47',NULL),(501,7525,40917,19690,2,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',1534.85,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(502,7525,40917,19690,2,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',6326.95,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(503,7525,40917,19690,2,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',3005.03,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(504,7525,40917,19690,2,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',5091.39,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(505,7525,40917,19690,2,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',1779.60,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(506,7525,40917,19690,2,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',3690.57,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(507,7525,40917,19690,2,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',5672.21,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(508,7525,40917,19690,2,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',4079.01,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(509,7525,40917,19690,2,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',4490.01,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(510,7525,40917,19690,2,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',4692.36,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(511,7525,40917,19690,2,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',2212.13,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(512,7525,40917,19690,2,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',6710.11,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(513,7525,40917,19690,2,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',4079.01,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(514,7525,40917,19690,2,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',5697.06,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(515,7525,40917,19690,2,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',6933.16,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(516,7525,40917,19690,2,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',4804.56,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(517,7525,40917,19690,2,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',3709.00,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL);
INSERT INTO `balance_libro` VALUES (518,7525,40917,19690,2,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',5359.86,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(519,7525,40917,19690,2,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',5457.36,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(520,7525,40917,19690,2,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',6084.08,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(521,7525,40917,19690,2,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',1407.62,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(522,7525,40917,19690,2,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',4804.56,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(523,7525,40917,19690,2,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',4902.06,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(524,7525,40917,19690,2,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',4472.05,NULL,NULL,1,'2022-12-20 16:39:48','2022-12-20 16:39:48',NULL),(525,7525,40917,19690,2,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',4631.05,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(526,7525,40917,19690,2,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',594.30,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(527,7525,40917,19690,2,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',664.64,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(528,7525,40917,19690,2,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',6702.01,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(529,7525,40917,19690,2,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',4944.36,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(530,7525,40917,19690,2,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',9880.04,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(531,7525,40917,19690,2,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',3900.03,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(532,7525,40917,19690,2,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',140400.41,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(533,7525,40917,19690,2,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',115000.46,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(534,7525,40917,19690,2,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',18000.01,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(535,7525,40917,19690,2,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',48000.03,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(536,7525,40917,19690,2,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',140400.41,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(537,7525,40917,19690,2,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',131500.62,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(538,7525,40917,19690,2,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',7830.03,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL);
INSERT INTO `balance_libro` VALUES (539,7525,40917,19690,2,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',8530.00,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:43:29','2022-12-20 16:43:29'),(540,7525,40917,19690,2,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',92720.53,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(541,7525,40917,19690,2,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',156000.46,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(542,7525,40917,19690,2,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',3690.57,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(543,7525,40917,19690,2,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',2997.97,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(544,7525,40917,19690,2,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1745.55,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(545,7525,40917,19690,2,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',2822.98,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(546,7525,40917,19690,2,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',7099.73,NULL,NULL,1,'2022-12-20 16:39:49','2022-12-20 16:39:49',NULL),(547,7525,40917,19690,2,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',3132.03,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL),(548,7525,40917,19690,2,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4914.56,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL),(549,7525,40917,19690,2,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4914.56,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL),(550,7525,40917,19690,2,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',484.65,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL),(551,7525,40917,19690,2,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',651.28,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL),(552,7525,40917,19690,2,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',3653.88,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL),(553,7525,40917,19690,2,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4774.76,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL),(554,7525,40917,19690,2,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4774.76,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL),(555,7525,40917,19690,2,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',2602.85,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL),(556,7525,40917,19690,2,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4997.06,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL),(557,7525,40917,19690,2,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4914.56,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL),(558,7525,40917,19690,2,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',5868.56,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL),(559,7525,40917,19690,2,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4652.06,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL);
INSERT INTO `balance_libro` VALUES (560,7525,40917,19690,2,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',14753.35,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL),(561,7525,40917,19690,2,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',101540.43,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL),(562,7525,40917,19690,2,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1534.85,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL),(563,7525,40917,19690,2,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',6326.95,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL),(564,7525,40917,19690,2,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',3005.03,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL),(565,7525,40917,19690,2,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',5091.39,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL),(566,7525,40917,19690,2,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1779.60,NULL,NULL,1,'2022-12-20 16:39:50','2022-12-20 16:39:50',NULL),(567,7525,40917,19690,2,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',5672.21,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL),(568,7525,40917,19690,2,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4079.01,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL),(569,7525,40917,19690,2,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4490.01,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL),(570,7525,40917,19690,2,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4692.36,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL),(571,7525,40917,19690,2,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',2212.13,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL),(572,7525,40917,19690,2,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',6710.11,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL),(573,7525,40917,19690,2,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4079.01,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL),(574,7525,40917,19690,2,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',5697.06,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL),(575,7525,40917,19690,2,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',6933.16,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL),(576,7525,40917,19690,2,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4804.56,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL),(577,7525,40917,19690,2,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',3709.00,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL),(578,7525,40917,19690,2,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',5359.86,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL),(579,7525,40917,19690,2,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',5457.36,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL),(580,7525,40917,19690,2,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',6084.08,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL);
INSERT INTO `balance_libro` VALUES (581,7525,40917,19690,2,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1407.62,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL),(582,7525,40917,19690,2,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4804.56,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL),(583,7525,40917,19690,2,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4902.06,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL),(584,7525,40917,19690,2,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4472.05,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL),(585,7525,40917,19690,2,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4631.05,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL),(586,7525,40917,19690,2,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',594.30,NULL,NULL,1,'2022-12-20 16:39:51','2022-12-20 16:39:51',NULL),(587,7525,40917,19690,2,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',664.64,NULL,NULL,1,'2022-12-20 16:39:52','2022-12-20 16:39:52',NULL),(588,7525,40917,19690,2,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',6702.01,NULL,NULL,1,'2022-12-20 16:39:52','2022-12-20 16:39:52',NULL),(589,7525,40917,19690,2,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4944.36,NULL,NULL,1,'2022-12-20 16:39:52','2022-12-20 16:39:52',NULL),(590,7525,40917,19690,2,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',96800.00,NULL,NULL,1,'2022-12-20 16:39:52','2022-12-20 16:39:52',NULL),(591,7525,40917,19690,2,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',115736.50,NULL,NULL,1,'2022-12-20 16:39:52','2022-12-20 16:39:52',NULL),(592,7525,40917,19690,3,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',29766.00,NULL,NULL,1,'2022-12-20 16:40:28','2022-12-20 16:57:20','2022-12-20 16:57:20'),(593,7525,40917,19690,3,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',173840.15,NULL,NULL,1,'2022-12-20 16:40:28','2022-12-20 16:58:47','2022-12-20 16:58:47'),(594,7525,40917,19690,3,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',19500.00,NULL,NULL,1,'2022-12-20 16:40:28','2022-12-20 16:58:38','2022-12-20 16:58:38'),(595,7525,40917,19690,3,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',215560.52,NULL,NULL,1,'2022-12-20 16:40:28','2022-12-20 16:40:28',NULL),(596,7525,40917,19690,3,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',1350.00,NULL,NULL,1,'2022-12-20 16:40:28','2022-12-20 16:40:28',NULL),(597,7525,40917,19690,3,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',38999.99,NULL,NULL,1,'2022-12-20 16:40:28','2022-12-20 17:06:26','2022-12-20 17:06:26'),(598,7525,40917,19690,3,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',138629.70,NULL,NULL,1,'2022-12-20 16:40:28','2022-12-20 16:59:30','2022-12-20 16:59:30'),(599,7525,40917,19690,3,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',13200.01,NULL,NULL,1,'2022-12-20 16:40:28','2022-12-20 16:40:28',NULL),(600,7525,40917,19690,3,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',6000.00,NULL,NULL,1,'2022-12-20 16:40:28','2022-12-20 17:02:32','2022-12-20 17:02:32');
INSERT INTO `balance_libro` VALUES (601,7525,40917,19690,3,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',6828.25,NULL,NULL,1,'2022-12-20 16:40:28','2022-12-20 17:03:32','2022-12-20 17:03:32'),(602,7525,40917,19690,3,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',190.00,NULL,NULL,1,'2022-12-20 16:40:29','2022-12-20 17:03:45','2022-12-20 17:03:45'),(603,7525,40917,19690,3,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',28545.86,NULL,NULL,1,'2022-12-20 16:40:29','2022-12-20 17:05:03','2022-12-20 17:05:03'),(604,7525,40917,19690,3,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',320.00,NULL,NULL,1,'2022-12-20 16:40:29','2022-12-20 17:05:22','2022-12-20 17:05:22'),(605,7525,40917,19690,3,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',132029.92,NULL,NULL,1,'2022-12-20 16:40:29','2022-12-20 16:40:29',NULL),(606,7525,40917,19690,3,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',100000.45,NULL,NULL,1,'2022-12-20 16:40:29','2022-12-20 17:06:05','2022-12-20 17:06:05'),(607,7525,40917,19690,3,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',189691.66,NULL,NULL,1,'2022-12-20 16:40:29','2022-12-20 16:40:29',NULL),(608,7525,40917,19690,2,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',8530.00,NULL,NULL,1,'2022-12-20 16:43:29','2022-12-20 16:43:29',NULL),(609,7525,40917,19690,3,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',29766.00,NULL,NULL,1,'2022-12-20 16:57:20','2022-12-20 16:57:20',NULL),(610,7525,40917,19690,3,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',138629.70,NULL,NULL,1,'2022-12-20 16:59:30','2022-12-20 16:59:30',NULL),(611,7525,40917,19690,3,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',6000.00,NULL,NULL,1,'2022-12-20 17:02:32','2022-12-20 17:02:32',NULL),(612,7525,40917,19690,3,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',28545.86,NULL,NULL,1,'2022-12-20 17:05:03','2022-12-20 17:05:03',NULL),(613,7525,40917,19690,3,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',100000.45,NULL,NULL,1,'2022-12-20 17:06:05','2022-12-20 17:06:05',NULL),(614,7525,40917,19690,3,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',38999.99,NULL,NULL,1,'2022-12-20 17:08:50','2022-12-20 17:08:50',NULL),(615,7525,40917,19690,3,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',120048.37,NULL,NULL,1,'2022-12-20 17:10:49','2022-12-20 17:10:49',NULL),(616,7525,40917,19690,3,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',167308.78,NULL,NULL,1,'2022-12-20 17:11:40','2022-12-20 17:11:40',NULL),(617,7525,40917,19690,3,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',180201.55,NULL,NULL,1,'2022-12-20 17:12:36','2022-12-20 17:12:36',NULL),(618,7525,40917,19690,3,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',120082.98,NULL,NULL,1,'2022-12-20 17:13:42','2022-12-20 17:13:42',NULL),(619,7525,40917,19690,3,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',100700.87,NULL,NULL,1,'2022-12-20 17:15:21','2022-12-20 17:15:21',NULL),(620,7525,40917,19690,3,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',59993.89,NULL,NULL,1,'2022-12-20 17:16:54','2022-12-20 17:16:54',NULL);
INSERT INTO `balance_libro` VALUES (621,7525,40917,19690,3,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',200499.07,NULL,NULL,1,'2022-12-20 17:18:04','2022-12-20 17:18:04',NULL),(622,7525,40917,19690,3,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',203353.39,NULL,NULL,1,'2022-12-20 17:18:55','2022-12-20 17:18:55',NULL),(623,7525,40917,19690,7,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1272.88,NULL,NULL,1,'2022-12-20 17:32:41','2022-12-20 17:32:41',NULL),(624,7525,40983,21205,2,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',30250.00,NULL,NULL,1,'2022-12-20 21:10:16','2022-12-20 21:10:16',NULL),(625,7525,40983,21205,2,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',260150.00,NULL,NULL,1,'2022-12-20 21:10:16','2022-12-20 21:10:16',NULL),(626,7525,40983,21205,3,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',240.20,NULL,NULL,1,'2022-12-20 21:10:28','2022-12-21 11:13:51','2022-12-21 11:13:51'),(627,7525,40983,21205,3,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',1227.00,NULL,NULL,1,'2022-12-20 21:10:28','2022-12-21 11:34:56','2022-12-21 11:34:56'),(628,7525,40983,21205,3,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',5500.00,NULL,NULL,1,'2022-12-20 21:10:28','2022-12-21 11:15:58','2022-12-21 11:15:58'),(629,7525,40983,21205,3,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',3195.14,NULL,NULL,1,'2022-12-20 21:10:28','2022-12-21 11:15:35','2022-12-21 11:15:35'),(630,7525,40983,21205,3,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',163.00,NULL,NULL,1,'2022-12-20 21:10:28','2022-12-21 11:13:41','2022-12-21 11:13:41'),(631,7525,40983,21205,3,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',119.00,NULL,NULL,1,'2022-12-20 21:10:29','2022-12-21 11:13:34','2022-12-21 11:13:34'),(632,7525,40983,21205,3,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',360.00,NULL,NULL,1,'2022-12-20 21:10:29','2022-12-21 11:13:20','2022-12-21 11:13:20'),(633,7525,40983,21205,3,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',3187.71,NULL,NULL,1,'2022-12-21 11:15:35','2022-12-21 11:36:22','2022-12-21 11:36:22'),(634,7525,40983,21205,3,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',5500.00,NULL,NULL,1,'2022-12-21 11:15:58','2022-12-21 11:15:58',NULL),(635,7525,40983,21205,3,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',3187.71,NULL,NULL,1,'2022-12-21 11:36:22','2022-12-21 11:36:22',NULL),(636,7525,40915,22717,2,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',18658.20,NULL,NULL,1,'2022-12-22 14:17:06','2022-12-22 14:17:06',NULL),(637,7525,40915,22717,2,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',39812.63,NULL,NULL,1,'2022-12-22 14:17:06','2022-12-22 14:17:06',NULL),(638,7525,40915,22717,2,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',39485.80,NULL,NULL,1,'2022-12-22 14:17:06','2022-12-22 14:17:06',NULL),(639,7525,40915,22717,3,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',6000.00,NULL,NULL,1,'2022-12-22 14:17:19','2022-12-22 14:28:11','2022-12-22 14:28:11'),(640,7525,40915,22717,3,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1840.00,NULL,NULL,1,'2022-12-22 14:17:19','2022-12-22 14:19:24','2022-12-22 14:19:24');
INSERT INTO `balance_libro` VALUES (641,7525,40915,22717,3,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',0.00,NULL,NULL,1,'2022-12-22 14:17:19','2022-12-22 14:19:16','2022-12-22 14:19:16'),(642,7525,40915,22717,3,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',6000.00,NULL,NULL,1,'2022-12-22 14:28:11','2022-12-22 14:28:11',NULL),(643,7525,40915,22717,3,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',7375.00,NULL,NULL,1,'2022-12-22 14:30:29','2022-12-22 14:30:29',NULL),(644,7525,40915,22717,3,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',7200.20,NULL,NULL,1,'2022-12-22 14:32:56','2022-12-22 14:32:56',NULL),(645,7525,40915,22717,3,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',7402.00,NULL,NULL,1,'2022-12-22 14:33:53','2022-12-22 14:33:53',NULL),(646,7525,40991,24232,2,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',319742.50,NULL,NULL,1,'2022-12-22 16:49:04','2022-12-22 16:49:04',NULL),(647,7525,40991,24232,2,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',54450.00,NULL,NULL,1,'2022-12-22 16:49:04','2022-12-22 16:49:04',NULL),(648,7525,40991,24232,2,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',320000.00,NULL,NULL,1,'2022-12-22 16:49:04','2022-12-22 16:49:04',NULL),(649,7525,40991,24232,3,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',39099.00,NULL,NULL,1,'2022-12-22 16:49:15','2022-12-28 16:36:57','2022-12-28 16:36:57'),(650,7525,40991,24232,3,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',1175.50,NULL,NULL,1,'2022-12-22 16:49:15','2022-12-28 16:38:11','2022-12-28 16:38:11'),(651,7525,40991,24232,3,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',1080.87,NULL,NULL,1,'2022-12-22 16:49:15','2022-12-28 16:37:50','2022-12-28 16:37:50'),(652,7525,40991,24232,3,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',9455.00,NULL,NULL,1,'2022-12-22 16:49:15','2022-12-28 16:36:34','2022-12-28 16:36:34'),(653,7525,40991,24232,3,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',42990.54,NULL,NULL,1,'2022-12-22 16:49:15','2022-12-28 16:39:28','2022-12-28 16:39:28'),(654,7525,40991,24232,3,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',103000.00,NULL,NULL,1,'2022-12-22 16:49:15','2022-12-22 16:49:15',NULL),(655,7525,40991,24232,3,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',10164.00,NULL,NULL,1,'2022-12-22 16:49:15','2022-12-22 16:49:15',NULL),(656,7525,40991,24232,3,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',103469.52,NULL,NULL,1,'2022-12-22 16:49:15','2022-12-22 16:49:15',NULL),(657,7525,40991,24232,3,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',6000.39,NULL,NULL,1,'2022-12-22 16:49:15','2022-12-22 16:49:15',NULL),(658,7525,40991,24232,3,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',49493.49,NULL,NULL,1,'2022-12-22 16:49:15','2022-12-28 16:41:13','2022-12-28 16:41:13'),(659,7525,40991,24232,3,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',8299.00,NULL,NULL,1,'2022-12-22 16:49:15','2022-12-22 16:49:15',NULL),(660,7525,40991,24232,3,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',21676.75,NULL,NULL,1,'2022-12-22 16:49:15','2022-12-22 16:49:15',NULL);
INSERT INTO `balance_libro` VALUES (661,7525,40991,24232,3,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',15107.46,NULL,NULL,1,'2022-12-22 16:49:15','2022-12-22 16:49:15',NULL),(662,7525,40991,24232,3,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',3964.83,NULL,NULL,1,'2022-12-22 16:49:15','2022-12-28 16:43:51','2022-12-28 16:43:51'),(663,7525,40991,24232,3,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',8489.99,NULL,NULL,1,'2022-12-22 16:49:15','2022-12-28 16:45:08','2022-12-28 16:45:08'),(664,7525,40991,24232,3,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',20171.32,NULL,NULL,1,'2022-12-22 16:49:16','2022-12-22 16:49:16',NULL),(665,7525,40991,24232,3,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',16681.08,NULL,NULL,1,'2022-12-22 16:49:16','2022-12-22 16:49:16',NULL),(666,7525,40991,24232,3,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',8346.30,NULL,NULL,1,'2022-12-22 16:49:16','2022-12-28 16:46:47','2022-12-28 16:46:47'),(667,7525,40991,24232,3,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',11043.28,NULL,NULL,1,'2022-12-22 16:49:16','2022-12-28 16:47:39','2022-12-28 16:47:39'),(668,7525,40991,24232,3,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',4180.11,NULL,NULL,1,'2022-12-22 16:49:16','2022-12-28 16:49:22','2022-12-28 16:49:22'),(669,7525,40991,24232,3,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',6000.39,NULL,NULL,1,'2022-12-22 16:49:16','2022-12-22 16:49:16',NULL),(670,7525,40991,24232,3,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',8000.52,NULL,NULL,1,'2022-12-22 16:49:16','2022-12-28 16:49:48','2022-12-28 16:49:48'),(671,7525,40991,24232,3,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',8000.52,NULL,NULL,1,'2022-12-22 16:49:16','2022-12-22 16:49:16',NULL),(672,7525,40991,24232,3,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',63000.00,NULL,NULL,1,'2022-12-22 16:49:16','2022-12-28 16:50:30','2022-12-28 16:50:30'),(673,7525,40991,24232,3,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',800.00,NULL,NULL,1,'2022-12-22 16:49:16','2022-12-23 11:48:49','2022-12-23 11:48:49'),(674,7525,40991,24232,3,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',7000.00,NULL,NULL,1,'2022-12-22 16:49:16','2022-12-28 16:42:45','2022-12-28 16:42:45'),(675,7525,40991,24232,3,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',39099.00,NULL,NULL,1,'2022-12-28 16:36:57','2022-12-28 16:36:57',NULL),(676,7525,40991,24232,3,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',1080.87,NULL,NULL,1,'2022-12-28 16:37:50','2022-12-28 16:37:50',NULL),(677,7525,40991,24232,3,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',1175.50,NULL,NULL,1,'2022-12-28 16:38:11','2022-12-28 16:38:11',NULL),(678,7525,40991,24232,3,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',42990.54,NULL,NULL,1,'2022-12-28 16:39:28','2022-12-28 16:39:28',NULL),(679,7525,40991,24232,3,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',7000.00,NULL,NULL,1,'2022-12-28 16:42:45','2022-12-28 16:42:45',NULL),(680,7525,40991,24232,3,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',3964.83,NULL,NULL,1,'2022-12-28 16:43:51','2022-12-28 16:43:51',NULL);
INSERT INTO `balance_libro` VALUES (681,7525,40991,24232,3,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',8346.31,NULL,NULL,1,'2022-12-28 16:46:47','2022-12-28 16:46:47',NULL),(682,7525,40991,24232,3,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',4180.12,NULL,NULL,1,'2022-12-28 16:49:22','2022-12-28 16:49:22',NULL),(683,7525,40991,24232,3,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',49493.49,NULL,NULL,1,'2022-12-28 16:54:22','2022-12-28 16:54:22',NULL),(684,7525,40991,24232,3,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',1999.99,NULL,NULL,1,'2022-12-28 16:56:15','2022-12-28 16:56:15',NULL),(685,7525,40991,24232,3,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',8401.06,NULL,NULL,1,'2022-12-28 16:56:45','2022-12-28 16:56:45',NULL),(686,7525,40991,24232,3,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',3652.92,NULL,NULL,1,'2022-12-28 16:57:17','2022-12-28 16:57:17',NULL),(687,7525,40991,24232,3,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',2000.18,NULL,NULL,1,'2022-12-28 16:58:31','2022-12-28 16:58:31',NULL),(688,7525,40991,24232,3,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-13','2022-11-13',2000.23,NULL,NULL,1,'2022-12-28 16:59:24','2022-12-28 16:59:24',NULL),(689,7525,40991,24232,3,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',10502.14,NULL,NULL,1,'2022-12-28 17:01:44','2022-12-28 17:01:44',NULL),(690,7525,40991,24232,3,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',2659.99,NULL,NULL,1,'2022-12-28 17:02:49','2022-12-28 17:02:49',NULL),(691,7525,40991,24232,3,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',4000.01,NULL,NULL,1,'2022-12-28 17:03:24','2022-12-28 17:03:24',NULL),(692,7525,40991,24232,7,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',960.95,NULL,NULL,1,'2022-12-28 17:19:05','2022-12-28 17:19:05',NULL),(693,7525,41011,25744,2,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',17769.99,NULL,NULL,1,'2022-12-28 17:35:34','2022-12-28 17:35:34',NULL),(694,7525,41011,25744,2,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',26849.99,NULL,NULL,1,'2022-12-28 17:35:34','2022-12-28 17:35:34',NULL),(695,7525,41011,25744,2,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',44900.01,NULL,NULL,1,'2022-12-28 17:35:34','2022-12-28 17:35:34',NULL),(696,7525,41011,25744,2,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',33040.00,NULL,NULL,1,'2022-12-28 17:35:34','2022-12-28 17:35:34',NULL),(697,7525,41011,25744,2,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',22460.03,NULL,NULL,1,'2022-12-28 17:35:34','2022-12-28 17:35:34',NULL),(698,7525,41011,25744,2,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',19090.00,NULL,NULL,1,'2022-12-28 17:35:34','2022-12-28 17:35:34',NULL),(699,7525,41011,25744,2,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',5200.01,NULL,NULL,1,'2022-12-28 17:35:34','2022-12-28 17:35:34',NULL),(700,7525,41011,25744,2,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',44237.60,NULL,NULL,1,'2022-12-28 17:35:34','2022-12-28 17:35:34',NULL),(701,7525,41011,25744,3,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',20851.35,NULL,NULL,1,'2022-12-28 17:35:45','2022-12-28 17:35:45',NULL);
INSERT INTO `balance_libro` VALUES (702,7525,41011,25744,3,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',12354.75,NULL,NULL,1,'2022-12-28 17:35:45','2022-12-28 17:41:53','2022-12-28 17:41:53'),(703,7525,41011,25744,3,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',17017.00,NULL,NULL,1,'2022-12-28 17:35:45','2022-12-28 17:35:45',NULL),(704,7525,41011,25744,3,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',8885.05,NULL,NULL,1,'2022-12-28 17:35:45','2022-12-28 17:35:45',NULL),(705,7525,41011,25744,3,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',20144.15,NULL,NULL,1,'2022-12-28 17:35:45','2022-12-28 17:35:45',NULL),(706,7525,41011,25744,3,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',8468.34,NULL,NULL,1,'2022-12-28 17:35:45','2022-12-28 17:44:19','2022-12-28 17:44:19'),(707,7525,41011,25744,3,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',33579.43,NULL,NULL,1,'2022-12-28 17:35:45','2022-12-28 17:44:45','2022-12-28 17:44:45'),(708,7525,41011,25744,3,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',33150.00,NULL,NULL,1,'2022-12-28 17:35:45','2022-12-28 17:35:45',NULL),(709,7525,41011,25744,3,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',1513.85,NULL,NULL,1,'2022-12-28 17:35:45','2022-12-28 17:35:45',NULL),(710,7525,41011,25744,3,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',9771.15,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:47:07','2022-12-28 17:47:07'),(711,7525,41011,25744,3,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',20718.75,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:35:46',NULL),(712,7525,41011,25744,3,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',21348.60,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:35:46',NULL),(713,7525,41011,25744,3,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',3470.00,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:47:55','2022-12-28 17:47:55'),(714,7525,41011,25744,3,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',23352.05,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:47:35','2022-12-28 17:47:35'),(715,7525,41011,25744,3,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',6500.00,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:49:01','2022-12-28 17:49:01'),(716,7525,41011,25744,3,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',27072.50,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:35:46',NULL),(717,7525,41011,25744,3,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',6026.85,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:51:58','2022-12-28 17:51:58'),(718,7525,41011,25744,3,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',5608.44,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:50:45','2022-12-28 17:50:45'),(719,7525,41011,25744,3,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',20442.50,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:35:46',NULL),(720,7525,41011,25744,3,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',12265.50,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:35:46',NULL),(721,7525,41011,25744,3,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',10640.49,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:54:03','2022-12-28 17:54:03');
INSERT INTO `balance_libro` VALUES (722,7525,41011,25744,3,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',20077.85,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:35:46',NULL),(723,7525,41011,25744,3,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',30221.75,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:35:46',NULL),(724,7525,41011,25744,3,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',27072.50,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:35:46',NULL),(725,7525,41011,25744,3,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',8051.36,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:55:36','2022-12-28 17:55:36'),(726,7525,41011,25744,3,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',20200.25,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:35:46',NULL),(727,7525,41011,25744,3,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',19061.25,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:35:46',NULL),(728,7525,41011,25744,3,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',25094.55,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:35:46',NULL),(729,7525,41011,25744,3,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',9644.25,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:57:41','2022-12-28 17:57:41'),(730,7525,41011,25744,3,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',40000.00,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:56:32','2022-12-28 17:56:32'),(731,7525,41011,25744,3,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',2000.00,NULL,NULL,1,'2022-12-28 17:35:46','2022-12-28 17:56:26','2022-12-28 17:56:26'),(732,7525,41011,25744,3,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',10185.80,NULL,NULL,1,'2022-12-28 17:35:47','2022-12-28 18:02:38','2022-12-28 18:02:38'),(733,7525,41011,25744,3,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',20000.50,NULL,NULL,1,'2022-12-28 17:35:47','2022-12-28 17:35:47',NULL),(734,7525,41011,25744,3,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',28343.25,NULL,NULL,1,'2022-12-28 17:35:47','2022-12-28 17:35:47',NULL),(735,7525,41011,25744,3,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',12265.50,NULL,NULL,1,'2022-12-28 17:41:53','2022-12-28 17:41:53',NULL),(736,7525,41011,25744,3,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',8468.31,NULL,NULL,1,'2022-12-28 17:44:19','2022-12-28 17:44:19',NULL),(737,7525,41011,25744,3,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',9771.15,NULL,NULL,1,'2022-12-28 17:47:07','2022-12-28 17:47:07',NULL),(738,7525,41011,25744,3,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',6500.00,NULL,NULL,1,'2022-12-28 17:49:01','2022-12-28 17:49:01',NULL),(739,7525,41011,25744,3,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',5608.93,NULL,NULL,1,'2022-12-28 17:50:45','2022-12-28 17:50:45',NULL),(740,7525,41011,25744,3,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',6006.86,NULL,NULL,1,'2022-12-28 17:51:58','2022-12-28 17:51:58',NULL),(741,7525,41011,25744,3,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',10640.59,NULL,NULL,1,'2022-12-28 17:54:03','2022-12-28 17:54:03',NULL);
INSERT INTO `balance_libro` VALUES (742,7525,41011,25744,3,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',8051.38,NULL,NULL,1,'2022-12-28 17:55:36','2022-12-28 17:55:36',NULL),(743,7525,41011,25744,3,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',9644.25,NULL,NULL,1,'2022-12-28 17:57:41','2022-12-28 17:57:41',NULL),(744,7525,41011,25744,3,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',10186.71,NULL,NULL,1,'2022-12-28 18:02:38','2022-12-28 18:02:38',NULL),(745,7525,41011,25744,3,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',25415.13,NULL,NULL,1,'2022-12-28 18:05:50','2022-12-28 18:05:50',NULL),(746,7525,41011,25744,3,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',17127.50,NULL,NULL,1,'2022-12-28 18:06:44','2022-12-28 18:06:44',NULL),(747,7525,41011,25744,3,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',3000.01,NULL,NULL,1,'2022-12-28 18:08:08','2022-12-28 18:08:08',NULL),(748,7525,41011,25744,3,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',5997.00,NULL,NULL,1,'2022-12-28 18:09:14','2022-12-28 18:09:14',NULL),(749,7525,40991,24232,3,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',63000.01,NULL,NULL,1,'2022-12-28 19:17:41','2022-12-28 19:17:41',NULL),(750,7525,41023,27263,3,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',3067.35,NULL,NULL,1,'2022-12-29 13:37:11','2022-12-29 13:39:54','2022-12-29 13:39:54'),(751,7525,41023,27263,3,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',6069.95,NULL,NULL,1,'2022-12-29 13:37:11','2022-12-29 13:37:11',NULL),(752,7525,41023,27263,3,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',6886.47,NULL,NULL,1,'2022-12-29 13:37:11','2022-12-29 14:16:27','2022-12-29 14:16:27'),(753,7525,41023,27263,3,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',11000.00,NULL,NULL,1,'2022-12-29 13:37:11','2022-12-29 13:45:20','2022-12-29 13:45:20'),(754,7525,41023,27263,3,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',352.52,NULL,NULL,1,'2022-12-29 13:37:12','2022-12-29 13:37:12',NULL),(755,7525,41023,27263,3,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',14930.48,NULL,NULL,1,'2022-12-29 13:37:12','2022-12-29 13:48:52','2022-12-29 13:48:52'),(756,7525,41023,27263,3,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',5693.42,NULL,NULL,1,'2022-12-29 13:37:12','2022-12-29 13:50:35','2022-12-29 13:50:35'),(757,7525,41023,27263,3,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',8948.28,NULL,NULL,1,'2022-12-29 13:37:12','2022-12-29 14:21:32','2022-12-29 14:21:32'),(758,7525,41023,27263,3,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',17099.91,NULL,NULL,1,'2022-12-29 13:37:12','2022-12-29 14:20:19','2022-12-29 14:20:19'),(759,7525,41023,27263,3,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',75.00,NULL,NULL,1,'2022-12-29 13:37:12','2022-12-29 14:32:22','2022-12-29 14:32:22'),(760,7525,41023,27263,3,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',3067.35,NULL,NULL,1,'2022-12-29 13:39:54','2022-12-29 13:39:54',NULL),(761,7525,41023,27263,3,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',11000.00,NULL,NULL,1,'2022-12-29 13:45:20','2022-12-29 13:45:20',NULL);
INSERT INTO `balance_libro` VALUES (762,7525,41023,27263,3,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',14930.48,NULL,NULL,1,'2022-12-29 13:48:52','2022-12-29 13:48:52',NULL),(763,7525,41023,27263,3,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',5693.62,NULL,NULL,1,'2022-12-29 13:50:35','2022-12-29 13:50:35',NULL),(764,7525,41023,27263,3,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',17099.91,NULL,NULL,1,'2022-12-29 14:20:19','2022-12-29 14:20:42','2022-12-29 14:20:42'),(765,7525,41023,27263,3,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',17099.90,NULL,NULL,1,'2022-12-29 14:20:42','2022-12-29 14:20:42',NULL),(766,7525,41023,27263,3,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',8948.29,NULL,NULL,1,'2022-12-29 14:21:32','2022-12-29 14:21:32',NULL),(767,7525,41023,27263,3,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',4393.24,NULL,NULL,1,'2022-12-29 14:39:14','2022-12-29 14:39:14',NULL),(768,7525,41023,27263,3,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',14826.98,NULL,NULL,1,'2022-12-29 14:39:54','2022-12-29 14:39:54',NULL),(769,7525,41023,27263,7,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',105.97,NULL,NULL,1,'2022-12-29 14:41:14','2022-12-29 14:41:14',NULL),(770,7525,40839,12124,3,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4000.00,NULL,NULL,1,'2022-12-29 14:58:19','2022-12-29 15:21:54','2022-12-29 15:21:54'),(771,7525,40839,12124,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',4000.00,NULL,NULL,1,'2022-12-29 14:59:19','2022-12-29 15:23:04','2022-12-29 15:23:04'),(772,7525,40839,12124,3,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',183.00,NULL,NULL,1,'2022-12-29 15:07:18','2022-12-29 15:22:41','2022-12-29 15:22:41'),(773,7525,40839,12124,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',3408.81,NULL,NULL,1,'2022-12-29 15:08:45','2022-12-29 15:22:50','2022-12-29 15:22:50'),(774,7525,40839,12124,3,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',2999.99,NULL,NULL,1,'2022-12-29 15:09:23','2022-12-29 15:22:13','2022-12-29 15:22:13'),(775,7525,40839,12124,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',6000.00,NULL,NULL,1,'2022-12-29 15:09:42','2022-12-29 15:22:31','2022-12-29 15:22:31'),(776,7525,40839,12124,3,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',8300.29,NULL,NULL,1,'2022-12-29 15:10:37','2022-12-29 15:22:04','2022-12-29 15:22:04'),(777,7525,40839,12124,3,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',6836.40,NULL,NULL,1,'2022-12-29 15:11:14','2022-12-29 15:22:21','2022-12-29 15:22:21'),(778,7525,40839,12124,7,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2.00,NULL,NULL,1,'2022-12-29 15:14:22','2022-12-29 15:14:22',NULL),(779,7525,40839,12124,3,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4000.00,NULL,NULL,1,'2022-12-29 15:21:54','2022-12-29 15:21:54',NULL),(780,7525,40839,12124,3,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',8300.29,NULL,NULL,1,'2022-12-29 15:22:04','2022-12-29 15:22:04',NULL),(781,7525,40839,12124,3,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',2999.99,NULL,NULL,1,'2022-12-29 15:22:13','2022-12-29 15:22:13',NULL);
INSERT INTO `balance_libro` VALUES (782,7525,40839,12124,3,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',6836.40,NULL,NULL,1,'2022-12-29 15:22:21','2022-12-29 15:22:21',NULL),(783,7525,40839,12124,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',6000.00,NULL,NULL,1,'2022-12-29 15:22:31','2022-12-29 15:22:31',NULL),(784,7525,40839,12124,3,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',183.00,NULL,NULL,1,'2022-12-29 15:22:41','2022-12-29 15:22:41',NULL),(785,7525,40839,12124,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',3408.81,NULL,NULL,1,'2022-12-29 15:22:50','2022-12-29 15:22:50',NULL),(786,7525,40839,12124,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',4000.00,NULL,NULL,1,'2022-12-29 15:23:04','2022-12-29 15:23:04',NULL),(787,7525,40720,1528,1,787,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-11-30',NULL,292456.55,NULL,NULL,1,'2023-01-04 10:47:28','2023-01-04 10:47:28',NULL),(788,7525,40839,12125,2,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',74566.25,NULL,NULL,1,'2023-01-17 11:34:15','2023-01-17 11:44:06','2023-01-17 11:44:06'),(789,7525,40839,12125,2,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',72600.00,NULL,NULL,1,'2023-01-17 11:34:15','2023-01-17 11:44:06','2023-01-17 11:44:06'),(790,7525,40839,12125,3,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',120.00,NULL,NULL,1,'2023-01-17 11:34:28','2023-01-17 12:09:47','2023-01-17 12:09:47'),(791,7525,40839,12125,3,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1075.20,NULL,NULL,1,'2023-01-17 11:34:28','2023-01-17 12:10:42','2023-01-17 12:10:42'),(792,7525,40839,12125,3,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',785.64,NULL,NULL,1,'2023-01-17 11:34:28','2023-01-17 12:15:13','2023-01-17 12:15:13'),(793,7525,40839,12125,3,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',129775.17,NULL,NULL,1,'2023-01-17 11:34:28','2023-01-17 12:25:30','2023-01-17 12:25:30'),(794,7525,40839,12125,3,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',6000.00,NULL,NULL,1,'2023-01-17 11:34:28','2023-01-17 12:14:38','2023-01-17 12:14:38'),(795,7525,40839,12125,3,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',1980.00,NULL,NULL,1,'2023-01-17 11:34:28','2023-01-17 11:34:28',NULL),(796,7525,40839,12125,3,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',9114.52,NULL,NULL,1,'2023-01-17 11:34:28','2023-01-17 12:13:35','2023-01-17 12:13:35'),(797,7525,40839,12125,3,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',14199.99,NULL,NULL,1,'2023-01-17 11:34:28','2023-01-17 11:34:28',NULL),(798,7525,40839,12125,3,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',84.95,NULL,NULL,1,'2023-01-17 11:34:28','2023-01-17 12:10:23','2023-01-17 12:10:23'),(799,7525,40839,12125,3,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',3530.00,NULL,NULL,1,'2023-01-17 11:34:28','2023-01-17 11:34:28',NULL),(800,7525,40839,12125,3,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',8548.35,NULL,NULL,1,'2023-01-17 11:34:28','2023-01-17 12:52:00','2023-01-17 12:52:00'),(801,7525,40839,12125,3,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',530.00,NULL,NULL,1,'2023-01-17 11:34:29','2023-01-17 12:10:11','2023-01-17 12:10:11');
INSERT INTO `balance_libro` VALUES (802,7525,40839,12125,3,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',99.00,NULL,NULL,1,'2023-01-17 11:34:29','2023-01-17 12:10:02','2023-01-17 12:10:02'),(803,7525,40839,12125,3,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',15730.01,NULL,NULL,1,'2023-01-17 11:34:29','2023-01-17 11:34:29',NULL),(804,7525,40839,12125,3,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',20440.19,NULL,NULL,1,'2023-01-17 11:34:29','2023-01-17 11:34:29',NULL),(805,7525,40839,12125,3,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',26030.14,NULL,NULL,1,'2023-01-17 11:34:29','2023-01-17 11:34:29',NULL),(806,7525,40839,12125,3,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',720.00,NULL,NULL,1,'2023-01-17 11:34:29','2023-01-17 11:34:29',NULL),(807,7525,40839,12125,3,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',2900.00,NULL,NULL,1,'2023-01-17 11:34:29','2023-01-17 11:34:29',NULL),(808,7525,40839,12125,3,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',180.00,NULL,NULL,1,'2023-01-17 11:34:29','2023-01-17 12:07:00','2023-01-17 12:07:00'),(809,7525,40839,12125,2,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',74566.25,NULL,NULL,1,'2023-01-17 11:58:21','2023-01-17 11:58:21',NULL),(810,7525,40839,12125,2,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',72600.00,NULL,NULL,1,'2023-01-17 11:58:22','2023-01-17 11:58:22',NULL),(811,7525,40839,12125,3,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',9114.52,NULL,NULL,1,'2023-01-17 12:13:35','2023-01-17 13:22:37','2023-01-17 13:22:37'),(812,7525,40839,12125,3,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',6000.00,NULL,NULL,1,'2023-01-17 12:14:38','2023-01-17 13:32:14','2023-01-17 13:32:14'),(813,7525,40839,12125,3,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',129775.17,NULL,NULL,1,'2023-01-17 12:25:30','2023-01-17 13:31:43','2023-01-17 13:31:43'),(814,7525,40839,12125,3,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',8548.35,NULL,NULL,1,'2023-01-17 12:52:00','2023-01-17 13:44:18','2023-01-17 13:44:18'),(815,7525,40839,12125,3,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',8617.49,NULL,NULL,1,'2023-01-17 12:55:09','2023-01-19 16:18:25','2023-01-19 16:18:25'),(816,7525,40839,12125,3,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',28438.68,NULL,NULL,1,'2023-01-17 12:56:34','2023-01-19 16:17:55','2023-01-19 16:17:55'),(817,7525,40839,12125,3,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',8900.98,NULL,NULL,1,'2023-01-17 13:04:07','2023-01-19 16:17:47','2023-01-19 16:17:47'),(818,7525,40839,12125,3,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',8002.85,NULL,NULL,1,'2023-01-17 13:04:49','2023-01-19 16:17:37','2023-01-19 16:17:37'),(819,7525,40839,12125,3,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',53492.17,NULL,NULL,1,'2023-01-17 13:13:06','2023-01-19 16:18:14','2023-01-19 16:18:14'),(820,7525,40839,12125,3,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',9063.40,NULL,NULL,1,'2023-01-17 13:22:37','2023-01-17 13:22:37',NULL),(821,7525,40839,12125,3,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',129775.17,NULL,NULL,1,'2023-01-17 13:31:43','2023-01-17 13:38:51','2023-01-17 13:38:51');
INSERT INTO `balance_libro` VALUES (822,7525,40839,12125,3,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',6000.00,NULL,NULL,1,'2023-01-17 13:32:14','2023-01-17 13:35:34','2023-01-17 13:35:34'),(823,7525,40839,12125,3,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',6000.00,NULL,NULL,1,'2023-01-17 13:35:34','2023-01-17 13:35:34',NULL),(824,7525,40839,12125,3,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',129775.17,NULL,NULL,1,'2023-01-17 13:38:51','2023-01-19 15:33:02','2023-01-19 15:33:02'),(825,7525,40839,12125,3,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',8548.35,NULL,NULL,1,'2023-01-17 13:44:18','2023-01-19 16:23:49','2023-01-19 16:23:49'),(826,7525,40849,13640,3,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',8211.41,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:25:17','2023-01-17 14:25:17'),(827,7525,40849,13640,3,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',23067.22,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:24:38','2023-01-17 14:24:38'),(828,7525,40849,13640,3,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',15274.22,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:24:00','2023-01-17 14:24:00'),(829,7525,40849,13640,3,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',4955.04,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:23:20','2023-01-17 14:23:20'),(830,7525,40849,13640,3,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',4955.04,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:09:43','2023-01-17 14:09:43'),(831,7525,40849,13640,3,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',12268.07,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:22:48','2023-01-17 14:22:48'),(832,7525,40849,13640,3,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',104432.44,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 13:58:25',NULL),(833,7525,40849,13640,3,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2613.60,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 13:58:25',NULL),(834,7525,40849,13640,3,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',10112.00,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:21:39','2023-01-17 14:21:39'),(835,7525,40849,13640,3,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',6000.00,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:21:08','2023-01-17 14:21:08'),(836,7525,40849,13640,3,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',4057.11,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:20:29','2023-01-17 14:20:29'),(837,7525,40849,13640,3,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',14746.45,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:19:35','2023-01-17 14:19:35'),(838,7525,40849,13640,3,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',124857.36,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 13:58:25',NULL),(839,7525,40849,13640,3,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',11156.54,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:18:57','2023-01-17 14:18:57'),(840,7525,40849,13640,3,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',8853.76,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:17:39','2023-01-17 14:17:39');
INSERT INTO `balance_libro` VALUES (841,7525,40849,13640,3,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',8308.52,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:09:22','2023-01-17 14:09:22'),(842,7525,40849,13640,3,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',15614.58,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:17:03','2023-01-17 14:17:03'),(843,7525,40849,13640,3,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',14746.45,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:09:05','2023-01-17 14:09:05'),(844,7525,40849,13640,3,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',3872.00,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 13:58:25',NULL),(845,7525,40849,13640,3,747,'App\\Models\\Receipt',747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',814.61,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:15:57','2023-01-17 14:15:57'),(846,7525,40849,13640,3,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',11708.62,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:13:51','2023-01-17 14:13:51'),(847,7525,40849,13640,3,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',33707.89,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:08:27','2023-01-17 14:08:27'),(848,7525,40849,13640,3,750,'App\\Models\\Receipt',750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1370.00,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:08:02','2023-01-17 14:08:02'),(849,7525,40849,13640,3,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',26010.03,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:07:49','2023-01-17 14:07:49'),(850,7525,40849,13640,3,752,'App\\Models\\Receipt',752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',11708.62,NULL,NULL,1,'2023-01-17 13:58:25','2023-01-17 14:07:36','2023-01-17 14:07:36'),(851,7525,40849,13640,3,753,'App\\Models\\Receipt',753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',222332.06,NULL,NULL,1,'2023-01-17 13:58:26','2023-01-17 13:58:26',NULL),(852,7525,40849,13640,3,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',11513.75,NULL,NULL,1,'2023-01-17 13:58:26','2023-01-17 14:15:24','2023-01-17 14:15:24'),(853,7525,40849,13640,3,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2489.27,NULL,NULL,1,'2023-01-17 13:58:26','2023-01-17 14:07:19','2023-01-17 14:07:19'),(854,7525,40849,13640,3,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',5798.78,NULL,NULL,1,'2023-01-17 13:58:26','2023-01-17 14:12:35','2023-01-17 14:12:35'),(855,7525,40849,13640,3,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2489.27,NULL,NULL,1,'2023-01-17 13:58:26','2023-01-17 14:06:39','2023-01-17 14:06:39'),(856,7525,40849,13640,3,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',20411.09,NULL,NULL,1,'2023-01-17 13:58:26','2023-01-17 14:11:53','2023-01-17 14:11:53'),(857,7525,40849,13640,3,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1728.00,NULL,NULL,1,'2023-01-17 13:58:26','2023-01-17 14:06:02','2023-01-17 14:06:02'),(858,7525,40849,13640,3,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',10697.93,NULL,NULL,1,'2023-01-17 13:58:26','2023-01-17 14:04:59','2023-01-17 14:04:59'),(859,7525,40849,13640,3,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',156976.08,NULL,NULL,1,'2023-01-17 13:58:26','2023-01-17 13:58:26',NULL);
INSERT INTO `balance_libro` VALUES (860,7525,40849,13640,3,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',180.64,NULL,NULL,1,'2023-01-17 13:58:26','2023-01-17 14:04:14','2023-01-17 14:04:14'),(861,7525,40849,13640,3,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',7477.95,NULL,NULL,1,'2023-01-17 13:58:26','2023-01-17 14:03:51','2023-01-17 14:03:51'),(862,7525,40849,13640,3,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',5342.80,NULL,NULL,1,'2023-01-17 13:58:26','2023-01-17 14:02:31','2023-01-17 14:02:31'),(863,7525,40849,13640,3,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',10847.55,NULL,NULL,1,'2023-01-17 13:58:26','2023-01-17 14:02:20','2023-01-17 14:02:20'),(864,7525,40849,13640,3,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',10847.48,NULL,NULL,1,'2023-01-17 14:02:20','2023-01-17 14:02:20',NULL),(865,7525,40849,13640,3,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',7477.94,NULL,NULL,1,'2023-01-17 14:03:51','2023-01-17 14:03:51',NULL),(866,7525,40849,13640,3,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',180.64,NULL,NULL,1,'2023-01-17 14:04:14','2023-01-17 14:04:14',NULL),(867,7525,40849,13640,3,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',10697.94,NULL,NULL,1,'2023-01-17 14:04:59','2023-01-17 14:04:59',NULL),(868,7525,40849,13640,3,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',20411.89,NULL,NULL,1,'2023-01-17 14:11:53','2023-01-17 14:11:53',NULL),(869,7525,40849,13640,3,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',5798.79,NULL,NULL,1,'2023-01-17 14:12:35','2023-01-17 14:12:35',NULL),(870,7525,40849,13640,3,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',11513.75,NULL,NULL,1,'2023-01-17 14:15:24','2023-01-17 14:15:24',NULL),(871,7525,40849,13640,3,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',15614.58,NULL,NULL,1,'2023-01-17 14:17:03','2023-01-17 14:17:03',NULL),(872,7525,40849,13640,3,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',8853.75,NULL,NULL,1,'2023-01-17 14:17:39','2023-01-17 14:17:39',NULL),(873,7525,40849,13640,3,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',11156.54,NULL,NULL,1,'2023-01-17 14:18:57','2023-01-17 14:18:57',NULL),(874,7525,40849,13640,3,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',4057.11,NULL,NULL,1,'2023-01-17 14:20:29','2023-01-17 14:20:29',NULL),(875,7525,40849,13640,3,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',6000.00,NULL,NULL,1,'2023-01-17 14:21:08','2023-01-17 14:21:08',NULL),(876,7525,40849,13640,3,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',10112.00,NULL,NULL,1,'2023-01-17 14:21:39','2023-01-17 14:21:39',NULL),(877,7525,40849,13640,3,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',12268.07,NULL,NULL,1,'2023-01-17 14:22:48','2023-01-17 14:22:48',NULL),(878,7525,40849,13640,3,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',15274.22,NULL,NULL,1,'2023-01-17 14:24:00','2023-01-17 14:24:00',NULL),(879,7525,40849,13640,3,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',8211.41,NULL,NULL,1,'2023-01-17 14:25:17','2023-01-17 14:25:17',NULL);
INSERT INTO `balance_libro` VALUES (880,7525,40849,13640,2,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',27280.00,NULL,NULL,1,'2023-01-17 14:59:10','2023-01-17 15:20:59','2023-01-17 15:20:59'),(881,7525,40849,13640,2,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',44784.00,NULL,NULL,1,'2023-01-17 14:59:10','2023-01-17 15:20:59','2023-01-17 15:20:59'),(882,7525,40849,13640,2,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-03','2023-12-03',93412.00,NULL,NULL,1,'2023-01-17 14:59:10','2023-01-17 15:20:59','2023-01-17 15:20:59'),(883,7525,40849,13640,2,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',30854.00,NULL,NULL,1,'2023-01-17 14:59:10','2023-01-17 15:20:59','2023-01-17 15:20:59'),(884,7525,40849,13640,2,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',25442.00,NULL,NULL,1,'2023-01-17 14:59:10','2023-01-17 15:20:59','2023-01-17 15:20:59'),(885,7525,40849,13640,2,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',28900.00,NULL,NULL,1,'2023-01-17 14:59:10','2023-01-17 15:20:59','2023-01-17 15:20:59'),(886,7525,40849,13640,2,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-08','2023-12-08',22911.00,NULL,NULL,1,'2023-01-17 14:59:10','2023-01-17 15:20:59','2023-01-17 15:20:59'),(887,7525,40849,13640,2,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',47838.00,NULL,NULL,1,'2023-01-17 14:59:10','2023-01-17 15:20:59','2023-01-17 15:20:59'),(888,7525,40849,13640,2,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-10','2023-12-10',62714.00,NULL,NULL,1,'2023-01-17 14:59:10','2023-01-17 15:20:59','2023-01-17 15:20:59'),(889,7525,40849,13640,2,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',14940.00,NULL,NULL,1,'2023-01-17 14:59:10','2023-01-17 15:20:59','2023-01-17 15:20:59'),(890,7525,40849,13640,2,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',16430.00,NULL,NULL,1,'2023-01-17 14:59:11','2023-01-17 15:21:00','2023-01-17 15:21:00'),(891,7525,40849,13640,2,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',32949.00,NULL,NULL,1,'2023-01-17 14:59:11','2023-01-17 15:21:00','2023-01-17 15:21:00'),(892,7525,40849,13640,2,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',9368.00,NULL,NULL,1,'2023-01-17 14:59:11','2023-01-17 15:21:00','2023-01-17 15:21:00'),(893,7525,40849,13640,2,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',67143.00,NULL,NULL,1,'2023-01-17 14:59:11','2023-01-17 15:21:00','2023-01-17 15:21:00'),(894,7525,40849,13640,2,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-17','2023-12-17',68430.00,NULL,NULL,1,'2023-01-17 14:59:11','2023-01-17 15:21:00','2023-01-17 15:21:00'),(895,7525,40849,13640,2,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',10324.00,NULL,NULL,1,'2023-01-17 14:59:11','2023-01-17 15:21:00','2023-01-17 15:21:00'),(896,7525,40849,13640,2,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',36047.00,NULL,NULL,1,'2023-01-17 14:59:11','2023-01-17 15:21:00','2023-01-17 15:21:00'),(897,7525,40849,13640,2,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',11120.00,NULL,NULL,1,'2023-01-17 14:59:11','2023-01-17 15:21:00','2023-01-17 15:21:00'),(898,7525,40849,13640,2,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',66118.00,NULL,NULL,1,'2023-01-17 14:59:11','2023-01-17 15:21:00','2023-01-17 15:21:00');
INSERT INTO `balance_libro` VALUES (899,7525,40849,13640,2,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-23','2023-12-23',120549.00,NULL,NULL,1,'2023-01-17 14:59:11','2023-01-17 15:21:00','2023-01-17 15:21:00'),(900,7525,40849,13640,2,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',78864.00,NULL,NULL,1,'2023-01-17 14:59:11','2023-01-17 15:21:00','2023-01-17 15:21:00'),(901,7525,40849,13640,2,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',3880.00,NULL,NULL,1,'2023-01-17 14:59:11','2023-01-17 15:21:00','2023-01-17 15:21:00'),(902,7525,40849,13640,2,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',2297.00,NULL,NULL,1,'2023-01-17 14:59:11','2023-01-17 15:21:00','2023-01-17 15:21:00'),(903,7525,40849,13640,2,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',1750.00,NULL,NULL,1,'2023-01-17 14:59:11','2023-01-17 15:21:00','2023-01-17 15:21:00'),(904,7525,40849,13640,2,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',2600.00,NULL,NULL,1,'2023-01-17 14:59:11','2023-01-17 15:21:00','2023-01-17 15:21:00'),(905,7525,40849,13640,2,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',1700.00,NULL,NULL,1,'2023-01-17 14:59:11','2023-01-17 15:21:00','2023-01-17 15:21:00'),(906,7525,40849,13640,2,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1500.00,NULL,NULL,1,'2023-01-17 14:59:11','2023-01-17 15:21:00','2023-01-17 15:21:00'),(907,7525,40849,13640,2,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',27280.00,NULL,NULL,1,'2023-01-17 15:21:50','2023-01-17 15:21:50',NULL),(908,7525,40849,13640,2,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',44784.00,NULL,NULL,1,'2023-01-17 15:21:50','2023-01-17 15:21:50',NULL),(909,7525,40849,13640,2,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',93412.00,NULL,NULL,1,'2023-01-17 15:21:50','2023-01-17 15:21:50',NULL),(910,7525,40849,13640,2,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',30854.00,NULL,NULL,1,'2023-01-17 15:21:50','2023-01-17 15:21:50',NULL),(911,7525,40849,13640,2,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',25442.00,NULL,NULL,1,'2023-01-17 15:21:50','2023-01-17 15:21:50',NULL),(912,7525,40849,13640,2,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',28900.00,NULL,NULL,1,'2023-01-17 15:21:50','2023-01-17 15:21:50',NULL),(913,7525,40849,13640,2,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',22911.00,NULL,NULL,1,'2023-01-17 15:21:50','2023-01-17 15:21:50',NULL),(914,7525,40849,13640,2,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',47838.00,NULL,NULL,1,'2023-01-17 15:21:50','2023-01-17 15:21:50',NULL),(915,7525,40849,13640,2,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',62714.00,NULL,NULL,1,'2023-01-17 15:21:51','2023-01-17 15:21:51',NULL),(916,7525,40849,13640,2,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',14940.00,NULL,NULL,1,'2023-01-17 15:21:51','2023-01-17 15:21:51',NULL),(917,7525,40849,13640,2,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',16430.00,NULL,NULL,1,'2023-01-17 15:21:51','2023-01-17 15:21:51',NULL),(918,7525,40849,13640,2,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',32949.00,NULL,NULL,1,'2023-01-17 15:21:51','2023-01-17 15:21:51',NULL);
INSERT INTO `balance_libro` VALUES (919,7525,40849,13640,2,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',9368.00,NULL,NULL,1,'2023-01-17 15:21:51','2023-01-17 15:21:51',NULL),(920,7525,40849,13640,2,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',67143.00,NULL,NULL,1,'2023-01-17 15:21:51','2023-01-17 15:21:51',NULL),(921,7525,40849,13640,2,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',68430.00,NULL,NULL,1,'2023-01-17 15:21:51','2023-01-17 15:21:51',NULL),(922,7525,40849,13640,2,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',10324.00,NULL,NULL,1,'2023-01-17 15:21:51','2023-01-17 15:21:51',NULL),(923,7525,40849,13640,2,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',36047.00,NULL,NULL,1,'2023-01-17 15:21:51','2023-01-17 15:21:51',NULL),(924,7525,40849,13640,2,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',11120.00,NULL,NULL,1,'2023-01-17 15:21:51','2023-01-17 15:21:51',NULL),(925,7525,40849,13640,2,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',66118.00,NULL,NULL,1,'2023-01-17 15:21:51','2023-01-17 15:21:51',NULL),(926,7525,40849,13640,2,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',120549.00,NULL,NULL,1,'2023-01-17 15:21:51','2023-01-17 15:21:51',NULL),(927,7525,40849,13640,2,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',78864.00,NULL,NULL,1,'2023-01-17 15:21:51','2023-01-17 15:21:51',NULL),(928,7525,40849,13640,2,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',3880.00,NULL,NULL,1,'2023-01-17 15:21:51','2023-01-17 15:21:51',NULL),(929,7525,40849,13640,2,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2297.00,NULL,NULL,1,'2023-01-17 15:21:51','2023-01-17 15:21:51',NULL),(930,7525,40849,13640,2,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',1750.00,NULL,NULL,1,'2023-01-17 15:21:51','2023-01-17 15:21:51',NULL),(931,7525,40849,13640,2,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2600.00,NULL,NULL,1,'2023-01-17 15:21:51','2023-01-17 15:21:51',NULL),(932,7525,40849,13640,2,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1700.00,NULL,NULL,1,'2023-01-17 15:21:51','2023-01-17 15:21:51',NULL),(933,7525,40849,13640,2,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1500.00,NULL,NULL,1,'2023-01-17 15:21:51','2023-01-17 15:21:51',NULL),(934,7525,40856,15152,2,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',118701.00,NULL,NULL,1,'2023-01-17 15:37:19','2023-01-17 15:37:19',NULL),(935,7525,40856,15152,2,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',449999.00,NULL,NULL,1,'2023-01-17 15:37:19','2023-01-17 15:37:19',NULL),(936,7525,40856,15152,2,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',669507.52,NULL,NULL,1,'2023-01-17 15:37:19','2023-01-17 15:37:19',NULL),(937,7525,40856,15152,3,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',23054.85,NULL,NULL,1,'2023-01-17 15:37:30','2023-01-17 15:53:36','2023-01-17 15:53:36'),(938,7525,40856,15152,3,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1499.99,NULL,NULL,1,'2023-01-17 15:37:30','2023-01-17 15:37:30',NULL),(939,7525,40856,15152,3,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',9438.00,NULL,NULL,1,'2023-01-17 15:37:30','2023-01-17 15:37:30',NULL);
INSERT INTO `balance_libro` VALUES (940,7525,40856,15152,3,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',4900.00,NULL,NULL,1,'2023-01-17 15:37:30','2023-01-17 15:37:30',NULL),(941,7525,40856,15152,3,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',7230.55,NULL,NULL,1,'2023-01-17 15:37:30','2023-01-17 15:52:10','2023-01-17 15:52:10'),(942,7525,40856,15152,3,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',7000.00,NULL,NULL,1,'2023-01-17 15:37:30','2023-01-17 15:51:15','2023-01-17 15:51:15'),(943,7525,40856,15152,3,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',6009.39,NULL,NULL,1,'2023-01-17 15:37:30','2023-01-17 15:51:00','2023-01-17 15:51:00'),(944,7525,40856,15152,3,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',6500.00,NULL,NULL,1,'2023-01-17 15:37:30','2023-01-17 16:08:32','2023-01-17 16:08:32'),(945,7525,40856,15152,3,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',1960.00,NULL,NULL,1,'2023-01-17 15:37:30','2023-01-17 15:47:41','2023-01-17 15:47:41'),(946,7525,40856,15152,3,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',34.00,NULL,NULL,1,'2023-01-17 15:37:30','2023-01-17 15:47:10','2023-01-17 15:47:10'),(947,7525,40856,15152,3,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',230.00,NULL,NULL,1,'2023-01-17 15:37:30','2023-01-17 15:47:00','2023-01-17 15:47:00'),(948,7525,40856,15152,3,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',141.59,NULL,NULL,1,'2023-01-17 15:37:30','2023-01-17 15:46:52','2023-01-17 15:46:52'),(949,7525,40856,15152,3,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',5140.46,NULL,NULL,1,'2023-01-17 15:37:30','2023-01-17 15:46:42','2023-01-17 15:46:42'),(950,7525,40856,15152,3,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1530.00,NULL,NULL,1,'2023-01-17 15:37:30','2023-01-17 15:45:27','2023-01-17 15:45:27'),(951,7525,40856,15152,3,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',6000.00,NULL,NULL,1,'2023-01-17 15:37:31','2023-01-17 15:44:55','2023-01-17 15:44:55'),(952,7525,40856,15152,3,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',35500.00,NULL,NULL,1,'2023-01-17 15:37:31','2023-01-17 16:08:41','2023-01-17 16:08:41'),(953,7525,40856,15152,3,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',13728.47,NULL,NULL,1,'2023-01-17 15:37:31','2023-01-17 15:43:16','2023-01-17 15:43:16'),(954,7525,40856,15152,3,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',13728.41,NULL,NULL,1,'2023-01-17 15:43:16','2023-01-17 15:43:16',NULL),(955,7525,40856,15152,3,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',5140.46,NULL,NULL,1,'2023-01-17 15:46:42','2023-01-17 15:46:42',NULL),(956,7525,40856,15152,3,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',6009.36,NULL,NULL,1,'2023-01-17 15:51:00','2023-01-17 15:51:00',NULL),(957,7525,40856,15152,3,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',7000.00,NULL,NULL,1,'2023-01-17 15:51:15','2023-01-17 15:51:15',NULL),(958,7525,40856,15152,3,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',7230.54,NULL,NULL,1,'2023-01-17 15:52:10','2023-01-17 15:52:10',NULL),(959,7525,40856,15152,3,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',23054.88,NULL,NULL,1,'2023-01-17 15:53:36','2023-01-17 15:53:36',NULL);
INSERT INTO `balance_libro` VALUES (960,7525,40856,15152,3,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',31500.00,NULL,NULL,1,'2023-01-17 15:56:16','2023-01-17 15:56:16',NULL),(961,7525,40875,16664,2,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',115600.00,NULL,NULL,1,'2023-01-17 17:02:21','2023-01-17 17:05:50','2023-01-17 17:05:50'),(962,7525,40875,16664,2,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',17413.41,NULL,NULL,1,'2023-01-17 17:02:21','2023-01-17 17:06:33','2023-01-17 17:06:33'),(963,7525,40875,16664,2,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',21203.04,NULL,NULL,1,'2023-01-17 17:02:22','2023-01-17 17:07:01','2023-01-17 17:07:01'),(964,7525,40875,16664,2,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',3636.00,NULL,NULL,1,'2023-01-17 17:02:22','2023-01-17 17:02:22',NULL),(965,7525,40875,16664,2,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',650.96,NULL,NULL,1,'2023-01-17 17:02:22','2023-01-17 17:02:22',NULL),(966,7525,40875,16664,2,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',13251.90,NULL,NULL,1,'2023-01-17 17:02:22','2023-01-17 17:02:22',NULL),(967,7525,40875,16664,2,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1301.92,NULL,NULL,1,'2023-01-17 17:02:22','2023-01-17 17:02:22',NULL),(968,7525,40875,16664,2,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',21203.04,NULL,NULL,1,'2023-01-17 17:02:22','2023-01-17 17:02:22',NULL),(969,7525,40875,16664,2,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',9600.00,NULL,NULL,1,'2023-01-17 17:02:22','2023-01-17 17:02:22',NULL),(970,7525,40875,16664,2,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',614200.00,NULL,NULL,1,'2023-01-17 17:02:22','2023-01-17 17:08:33','2023-01-17 17:08:33'),(971,7525,40875,16664,2,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',23600.00,NULL,NULL,1,'2023-01-17 17:02:22','2023-01-17 17:08:06','2023-01-17 17:08:06'),(972,7525,40875,16664,2,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',334110.00,NULL,NULL,1,'2023-01-17 17:02:22','2023-01-17 17:08:45','2023-01-17 17:08:45'),(973,7525,40875,16664,2,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',115800.00,NULL,NULL,1,'2023-01-17 17:02:22','2023-01-17 17:08:58','2023-01-17 17:08:58'),(974,7525,40875,16664,2,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',106000.00,NULL,NULL,1,'2023-01-17 17:02:22','2023-01-17 17:09:05','2023-01-17 17:09:05'),(975,7525,40875,16664,2,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',222550.00,NULL,NULL,1,'2023-01-17 17:02:22','2023-01-17 17:09:15','2023-01-17 17:09:15'),(976,7525,40875,16664,2,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',536850.00,NULL,NULL,1,'2023-01-17 17:02:22','2023-01-17 17:09:22','2023-01-17 17:09:22'),(977,7525,40875,16664,2,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',9600.00,NULL,NULL,1,'2023-01-17 17:02:22','2023-01-17 17:02:22',NULL),(978,7525,40875,16664,3,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',280.31,NULL,NULL,1,'2023-01-17 17:02:34','2023-01-19 16:51:33','2023-01-19 16:51:33'),(979,7525,40875,16664,3,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',9594.02,NULL,NULL,1,'2023-01-17 17:02:34','2023-01-17 17:02:34',NULL);
INSERT INTO `balance_libro` VALUES (980,7525,40875,16664,3,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',8183.60,NULL,NULL,1,'2023-01-17 17:02:34','2023-01-19 16:51:08','2023-01-19 16:51:08'),(981,7525,40875,16664,3,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',8183.60,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-19 16:50:58','2023-01-19 16:50:58'),(982,7525,40875,16664,3,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',89540.00,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-17 17:02:35',NULL),(983,7525,40875,16664,3,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',8183.61,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-17 17:02:35',NULL),(984,7525,40875,16664,3,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',16999.00,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-19 16:50:11','2023-01-19 16:50:11'),(985,7525,40875,16664,3,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',3600.02,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-17 17:02:35',NULL),(986,7525,40875,16664,3,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',426.14,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-19 16:49:15','2023-01-19 16:49:15'),(987,7525,40875,16664,3,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',451.92,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-19 16:49:04','2023-01-19 16:49:04'),(988,7525,40875,16664,3,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',60960.36,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-19 16:48:38','2023-01-19 16:48:38'),(989,7525,40875,16664,3,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',6119.97,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-17 17:02:35',NULL),(990,7525,40875,16664,3,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',9001.29,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-19 16:47:58','2023-01-19 16:47:58'),(991,7525,40875,16664,3,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',3215.93,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-19 16:47:19','2023-01-19 16:47:19'),(992,7525,40875,16664,3,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',5845.00,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-19 16:47:10','2023-01-19 16:47:10'),(993,7525,40875,16664,3,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',32999.99,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-17 17:02:35',NULL),(994,7525,40875,16664,3,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',5896.81,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-17 17:02:35',NULL),(995,7525,40875,16664,3,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',21604.01,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-17 17:02:35',NULL),(996,7525,40875,16664,3,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',4853.99,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-19 16:46:17','2023-01-19 16:46:17'),(997,7525,40875,16664,3,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',3000.00,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-17 17:02:35',NULL),(998,7525,40875,16664,3,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',5500.00,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-19 16:44:59','2023-01-19 16:44:59'),(999,7525,40875,16664,3,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',351370.70,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-17 17:02:35',NULL);
INSERT INTO `balance_libro` VALUES (1000,7525,40875,16664,3,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',2249.99,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-19 17:21:57','2023-01-19 17:21:57'),(1001,7525,40875,16664,3,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',4803.14,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-17 17:02:35',NULL),(1002,7525,40875,16664,3,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',23500.02,NULL,NULL,1,'2023-01-17 17:02:35','2023-01-17 17:02:35',NULL),(1003,7525,40875,16664,3,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',38956.46,NULL,NULL,1,'2023-01-17 17:02:36','2023-01-19 16:43:12','2023-01-19 16:43:12'),(1004,7525,40875,16664,3,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',16999.00,NULL,NULL,1,'2023-01-17 17:02:36','2023-01-19 16:42:28','2023-01-19 16:42:28'),(1005,7525,40875,16664,3,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',16999.00,NULL,NULL,1,'2023-01-17 17:02:36','2023-01-19 16:42:47','2023-01-19 16:42:47'),(1006,7525,40875,16664,3,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',16999.00,NULL,NULL,1,'2023-01-17 17:02:36','2023-01-19 16:42:10','2023-01-19 16:42:10'),(1007,7525,40875,16664,3,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',48109.60,NULL,NULL,1,'2023-01-17 17:02:36','2023-01-17 17:02:36',NULL),(1008,7525,40875,16664,3,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',48109.60,NULL,NULL,1,'2023-01-17 17:02:36','2023-01-19 16:41:48','2023-01-19 16:41:48'),(1009,7525,40875,16664,3,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',5569.45,NULL,NULL,1,'2023-01-17 17:02:36','2023-01-19 16:41:28','2023-01-19 16:41:28'),(1010,7525,40875,16664,3,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',3897.00,NULL,NULL,1,'2023-01-17 17:02:36','2023-01-19 16:38:21','2023-01-19 16:38:21'),(1011,7525,40875,16664,3,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',5845.00,NULL,NULL,1,'2023-01-17 17:02:36','2023-01-19 16:08:57','2023-01-19 16:08:57'),(1012,7525,40875,16664,3,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',5845.00,NULL,NULL,1,'2023-01-17 17:02:36','2023-01-17 17:02:36',NULL),(1013,7525,40875,16664,3,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',136.00,NULL,NULL,1,'2023-01-17 17:02:36','2023-01-19 16:10:07','2023-01-19 16:10:07'),(1014,7525,40875,16664,3,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',19990.00,NULL,NULL,1,'2023-01-17 17:02:36','2023-01-17 17:02:36',NULL),(1015,7525,40875,16664,3,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',27810.00,NULL,NULL,1,'2023-01-17 17:02:36','2023-01-17 17:02:36',NULL),(1016,7525,40875,16664,3,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',20000.09,NULL,NULL,1,'2023-01-17 17:02:36','2023-01-17 17:02:36',NULL),(1017,7525,40875,16664,3,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',3897.00,NULL,NULL,1,'2023-01-17 17:02:36','2023-01-19 16:04:13','2023-01-19 16:04:13'),(1018,7525,40875,16664,3,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',3897.00,NULL,NULL,1,'2023-01-17 17:02:36','2023-01-19 16:04:01','2023-01-19 16:04:01'),(1019,7525,40875,16664,3,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',34260.00,NULL,NULL,1,'2023-01-17 17:02:36','2023-01-17 17:02:36',NULL);
INSERT INTO `balance_libro` VALUES (1020,7525,40875,16664,3,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',30500.00,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-19 15:47:03','2023-01-19 15:47:03'),(1021,7525,40875,16664,3,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',23418.68,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-19 15:46:52','2023-01-19 15:46:52'),(1022,7525,40875,16664,3,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',17411.21,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-19 15:46:23','2023-01-19 15:46:23'),(1023,7525,40875,16664,3,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',28473.94,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-19 15:45:21','2023-01-19 15:45:21'),(1024,7525,40875,16664,3,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',28473.94,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-19 15:45:11','2023-01-19 15:45:11'),(1025,7525,40875,16664,3,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',28473.94,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-19 15:45:02','2023-01-19 15:45:02'),(1026,7525,40875,16664,3,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',25363.26,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-19 15:44:48','2023-01-19 15:44:48'),(1027,7525,40875,16664,3,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',28473.94,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-19 15:44:01','2023-01-19 15:44:01'),(1028,7525,40875,16664,3,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',28473.94,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-19 15:43:21','2023-01-19 15:43:21'),(1029,7525,40875,16664,3,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',17265.60,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-19 15:43:09','2023-01-19 15:43:09'),(1030,7525,40875,16664,3,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',3799.00,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-19 15:43:00','2023-01-19 15:43:00'),(1031,7525,40875,16664,3,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',21495.00,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-19 15:42:09','2023-01-19 15:42:09'),(1032,7525,40875,16664,3,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',21495.00,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-19 15:41:54','2023-01-19 15:41:54'),(1033,7525,40875,16664,3,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',3215.93,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-19 15:42:02','2023-01-19 15:42:02'),(1034,7525,40875,16664,3,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',3215.93,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-19 15:41:43','2023-01-19 15:41:43'),(1035,7525,40875,16664,3,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2957.16,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-19 15:41:09','2023-01-19 15:41:09'),(1036,7525,40875,16664,3,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',108302.42,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-19 15:40:20','2023-01-19 15:40:20'),(1037,7525,40875,16664,3,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',17100.00,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-17 17:02:37',NULL),(1038,7525,40875,16664,3,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',204340.34,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-19 15:15:25','2023-01-19 15:15:25');
INSERT INTO `balance_libro` VALUES (1039,7525,40875,16664,3,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',989.97,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-17 17:02:37',NULL),(1040,7525,40875,16664,3,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',10230.11,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-17 17:02:37',NULL),(1041,7525,40875,16664,3,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',78988.80,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-17 17:02:37',NULL),(1042,7525,40875,16664,3,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',23583.92,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-17 17:02:37',NULL),(1043,7525,40875,16664,3,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3888.00,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-17 17:25:35','2023-01-17 17:25:35'),(1044,7525,40875,16664,3,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',34890.00,NULL,NULL,1,'2023-01-17 17:02:37','2023-01-17 17:02:37',NULL),(1045,7525,40875,16664,3,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1962.00,NULL,NULL,1,'2023-01-17 17:02:38','2023-01-17 17:24:37','2023-01-17 17:24:37'),(1046,7525,40875,16664,3,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',14600.00,NULL,NULL,1,'2023-01-17 17:02:38','2023-01-17 17:20:19','2023-01-17 17:20:19'),(1047,7525,40875,16664,3,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',328430.30,NULL,NULL,1,'2023-01-17 17:02:38','2023-01-17 17:02:38',NULL),(1048,7525,40875,16664,2,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',115600.00,NULL,NULL,1,'2023-01-17 17:05:50','2023-01-17 17:05:50',NULL),(1049,7525,40875,16664,2,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',17413.41,NULL,NULL,1,'2023-01-17 17:06:33','2023-01-17 17:06:33',NULL),(1050,7525,40875,16664,2,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',21203.04,NULL,NULL,1,'2023-01-17 17:07:01','2023-01-17 17:07:01',NULL),(1051,7525,40875,16664,2,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',23600.00,NULL,NULL,1,'2023-01-17 17:08:06','2023-01-17 17:08:06',NULL),(1052,7525,40875,16664,2,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',614200.01,NULL,NULL,1,'2023-01-17 17:08:33','2023-01-17 17:08:33',NULL),(1053,7525,40875,16664,2,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',334110.02,NULL,NULL,1,'2023-01-17 17:08:45','2023-01-17 17:08:45',NULL),(1054,7525,40875,16664,2,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',115800.00,NULL,NULL,1,'2023-01-17 17:08:58','2023-01-17 17:08:58',NULL),(1055,7525,40875,16664,2,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',106000.01,NULL,NULL,1,'2023-01-17 17:09:05','2023-01-17 17:09:05',NULL),(1056,7525,40875,16664,2,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',222550.01,NULL,NULL,1,'2023-01-17 17:09:15','2023-01-17 17:09:15',NULL),(1057,7525,40875,16664,2,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',536849.99,NULL,NULL,1,'2023-01-17 17:09:22','2023-01-17 17:09:22',NULL),(1058,7525,40875,16664,3,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',204340.33,NULL,NULL,1,'2023-01-19 15:15:25','2023-01-19 15:15:25',NULL);
INSERT INTO `balance_libro` VALUES (1059,7525,40839,12125,3,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',129775.27,NULL,NULL,1,'2023-01-19 15:33:02','2023-01-19 16:12:56','2023-01-19 16:12:56'),(1060,7525,40875,16664,3,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',108302.39,NULL,NULL,1,'2023-01-19 15:40:20','2023-01-19 15:40:20',NULL),(1061,7525,40875,16664,3,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',25363.26,NULL,NULL,1,'2023-01-19 15:44:48','2023-01-19 15:44:48',NULL),(1062,7525,40875,16664,3,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',17411.21,NULL,NULL,1,'2023-01-19 15:46:23','2023-01-19 15:46:23',NULL),(1063,7525,40875,16664,3,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',23418.68,NULL,NULL,1,'2023-01-19 15:46:52','2023-01-19 15:46:52',NULL),(1064,7525,40839,12125,3,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',129775.27,NULL,NULL,1,'2023-01-19 16:12:56','2023-01-19 16:12:56',NULL),(1065,7525,40839,12125,3,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',8002.85,NULL,NULL,1,'2023-01-19 16:17:37','2023-01-19 16:17:37',NULL),(1066,7525,40839,12125,3,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',8900.98,NULL,NULL,1,'2023-01-19 16:17:47','2023-01-19 16:17:47',NULL),(1067,7525,40839,12125,3,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',28438.68,NULL,NULL,1,'2023-01-19 16:17:55','2023-01-19 16:18:04','2023-01-19 16:18:04'),(1068,7525,40839,12125,3,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',28438.68,NULL,NULL,1,'2023-01-19 16:18:04','2023-01-19 16:18:04',NULL),(1069,7525,40839,12125,3,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',53492.17,NULL,NULL,1,'2023-01-19 16:18:14','2023-01-19 16:18:14',NULL),(1070,7525,40839,12125,3,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',8617.49,NULL,NULL,1,'2023-01-19 16:18:25','2023-01-19 16:18:25',NULL),(1071,7525,40839,12125,3,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',8548.35,NULL,NULL,1,'2023-01-19 16:23:49','2023-01-19 16:28:38','2023-01-19 16:28:38'),(1072,7525,40839,12125,3,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',8548.35,NULL,NULL,1,'2023-01-19 16:28:38','2023-01-19 16:28:38',NULL),(1073,7525,40875,16664,3,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',5569.46,NULL,NULL,1,'2023-01-19 16:41:28','2023-01-19 17:46:32','2023-01-19 17:46:32'),(1074,7525,40875,16664,3,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',48109.60,NULL,NULL,1,'2023-01-19 16:41:48','2023-01-19 16:41:48',NULL),(1075,7525,40875,16664,3,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',5500.00,NULL,NULL,1,'2023-01-19 16:44:59','2023-01-19 16:44:59',NULL),(1076,7525,40875,16664,3,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',4853.98,NULL,NULL,1,'2023-01-19 16:46:17','2023-01-19 16:46:17',NULL),(1077,7525,40875,16664,3,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',9001.29,NULL,NULL,1,'2023-01-19 16:47:58','2023-01-19 16:47:58',NULL),(1078,7525,40875,16664,3,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',60960.37,NULL,NULL,1,'2023-01-19 16:48:38','2023-01-19 16:48:38',NULL);
INSERT INTO `balance_libro` VALUES (1079,7525,40875,16664,3,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',215735.23,NULL,NULL,1,'2023-01-19 16:54:33','2023-01-19 16:54:33',NULL),(1080,7525,40875,16664,3,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',9702.90,NULL,NULL,1,'2023-01-19 16:55:45','2023-01-19 16:55:45',NULL),(1081,7525,40875,16664,3,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',8718.47,NULL,NULL,1,'2023-01-19 16:56:26','2023-01-19 16:56:26',NULL),(1082,7525,40875,16664,2,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',50797.99,NULL,NULL,1,'2023-01-19 16:58:37','2023-01-19 16:58:37',NULL),(1083,7525,40875,16664,3,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',2249.99,NULL,NULL,1,'2023-01-19 17:21:57','2023-01-19 17:38:11','2023-01-19 17:38:11'),(1084,7525,40875,16664,3,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',2250.00,NULL,NULL,1,'2023-01-19 17:38:11','2023-01-19 17:38:11',NULL),(1085,7525,40875,16664,3,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',5569.46,NULL,NULL,1,'2023-01-19 17:46:32','2023-01-19 17:46:32',NULL),(1086,7525,40875,16664,7,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',70.86,NULL,NULL,1,'2023-01-19 18:18:24','2023-01-19 18:18:24',NULL),(1087,7525,41011,25745,2,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',42499.99,NULL,NULL,1,'2023-01-19 18:38:28','2023-01-19 18:38:28',NULL),(1088,7525,41011,25745,2,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',32550.05,NULL,NULL,1,'2023-01-19 18:38:28','2023-01-19 18:38:28',NULL),(1089,7525,41011,25745,2,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',21900.00,NULL,NULL,1,'2023-01-19 18:38:28','2023-01-19 18:38:28',NULL),(1090,7525,41011,25745,2,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',42300.00,NULL,NULL,1,'2023-01-19 18:38:28','2023-01-19 18:38:28',NULL),(1091,7525,41011,25745,2,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',45360.00,NULL,NULL,1,'2023-01-19 18:38:29','2023-01-19 18:38:29',NULL),(1092,7525,41011,25745,2,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',19720.01,NULL,NULL,1,'2023-01-19 18:38:29','2023-01-19 18:38:29',NULL),(1093,7525,41011,25745,2,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',42149.98,NULL,NULL,1,'2023-01-19 18:38:29','2023-01-19 18:38:29',NULL),(1094,7525,41011,25745,2,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',36300.00,NULL,NULL,1,'2023-01-19 18:38:29','2023-01-19 18:38:29',NULL),(1095,7525,41011,25745,2,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',64069.50,NULL,NULL,1,'2023-01-19 18:38:29','2023-01-19 18:38:29',NULL),(1096,7525,41011,25745,2,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',55176.00,NULL,NULL,1,'2023-01-19 18:38:29','2023-01-19 18:38:29',NULL),(1097,7525,41011,25745,2,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',13733.50,NULL,NULL,1,'2023-01-19 18:38:29','2023-01-19 18:38:29',NULL),(1098,7525,41011,25745,3,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',22188.40,NULL,NULL,1,'2023-01-19 18:38:42','2023-01-20 11:31:44','2023-01-20 11:31:44'),(1099,7525,41011,25745,3,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',3200.00,NULL,NULL,1,'2023-01-19 18:38:42','2023-01-20 09:37:21','2023-01-20 09:37:21');
INSERT INTO `balance_libro` VALUES (1100,7525,41011,25745,3,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',8143.52,NULL,NULL,1,'2023-01-19 18:38:42','2023-01-20 11:11:34','2023-01-20 11:11:34'),(1101,7525,41011,25745,3,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',7673.54,NULL,NULL,1,'2023-01-19 18:38:42','2023-01-20 11:08:16','2023-01-20 11:08:16'),(1102,7525,41011,25745,3,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',29631.07,NULL,NULL,1,'2023-01-19 18:38:42','2023-01-20 09:37:06','2023-01-20 09:37:06'),(1103,7525,41011,25745,3,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',34255.00,NULL,NULL,1,'2023-01-19 18:38:42','2023-01-19 18:38:42',NULL),(1104,7525,41011,25745,3,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',20774.00,NULL,NULL,1,'2023-01-19 18:38:42','2023-01-20 11:31:27','2023-01-20 11:31:27'),(1105,7525,41011,25745,3,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',9901.43,NULL,NULL,1,'2023-01-19 18:38:42','2023-01-20 10:54:06','2023-01-20 10:54:06'),(1106,7525,41011,25745,3,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',23536.50,NULL,NULL,1,'2023-01-19 18:38:42','2023-01-20 11:31:13','2023-01-20 11:31:13'),(1107,7525,41011,25745,3,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',16499.00,NULL,NULL,1,'2023-01-19 18:38:42','2023-01-20 09:36:47','2023-01-20 09:36:47'),(1108,7525,41011,25745,3,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',3836.45,NULL,NULL,1,'2023-01-19 18:38:42','2023-01-20 10:48:20','2023-01-20 10:48:20'),(1109,7525,41011,25745,3,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',11550.20,NULL,NULL,1,'2023-01-19 18:38:42','2023-01-20 10:46:12','2023-01-20 10:46:12'),(1110,7525,41011,25745,3,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',38675.00,NULL,NULL,1,'2023-01-19 18:38:42','2023-01-20 11:30:56','2023-01-20 11:30:56'),(1111,7525,41011,25745,3,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',6500.00,NULL,NULL,1,'2023-01-19 18:38:42','2023-01-20 10:40:25','2023-01-20 10:40:25'),(1112,7525,41011,25745,3,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',3665.28,NULL,NULL,1,'2023-01-19 18:38:42','2023-01-20 09:36:07','2023-01-20 09:36:07'),(1113,7525,41011,25745,3,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',32571.53,NULL,NULL,1,'2023-01-19 18:38:42','2023-01-20 09:35:51','2023-01-20 09:35:51'),(1114,7525,41011,25745,3,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',27901.25,NULL,NULL,1,'2023-01-19 18:38:42','2023-01-19 18:38:42',NULL),(1115,7525,41011,25745,3,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',30111.25,NULL,NULL,1,'2023-01-19 18:38:42','2023-01-20 11:30:44','2023-01-20 11:30:44'),(1116,7525,41011,25745,3,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',19448.00,NULL,NULL,1,'2023-01-19 18:38:42','2023-01-19 18:38:42',NULL),(1117,7525,41011,25745,3,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1944.80,NULL,NULL,1,'2023-01-19 18:38:43','2023-01-20 11:30:27','2023-01-20 11:30:27'),(1118,7525,41011,25745,3,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',8551.29,NULL,NULL,1,'2023-01-19 18:38:43','2023-01-20 10:36:25','2023-01-20 10:36:25');
INSERT INTO `balance_libro` VALUES (1119,7525,41011,25745,3,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',27625.00,NULL,NULL,1,'2023-01-19 18:38:43','2023-01-19 18:38:43',NULL),(1120,7525,41011,25745,3,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',6242.38,NULL,NULL,1,'2023-01-19 18:38:43','2023-01-20 10:33:30','2023-01-20 10:33:30'),(1121,7525,41011,25745,3,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',35857.25,NULL,NULL,1,'2023-01-19 18:38:43','2023-01-20 11:30:10','2023-01-20 11:30:10'),(1122,7525,41011,25745,3,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',23591.89,NULL,NULL,1,'2023-01-19 18:38:43','2023-01-20 09:35:38','2023-01-20 09:35:38'),(1123,7525,41011,25745,3,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',19006.00,NULL,NULL,1,'2023-01-19 18:38:43','2023-01-19 18:38:43',NULL),(1124,7525,41011,25745,3,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',11470.75,NULL,NULL,1,'2023-01-19 18:38:43','2023-01-19 18:38:43',NULL),(1125,7525,41011,25745,3,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',10531.12,NULL,NULL,1,'2023-01-19 18:38:43','2023-01-20 10:01:36','2023-01-20 10:01:36'),(1126,7525,41011,25745,3,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',22431.50,NULL,NULL,1,'2023-01-19 18:38:43','2023-01-19 18:38:43',NULL),(1127,7525,41011,25745,3,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',20000.50,NULL,NULL,1,'2023-01-19 18:38:43','2023-01-19 18:38:43',NULL),(1128,7525,41011,25745,3,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',7464.82,NULL,NULL,1,'2023-01-19 18:38:43','2023-01-20 09:57:53','2023-01-20 09:57:53'),(1129,7525,41011,25745,3,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',64186.80,NULL,NULL,1,'2023-01-19 18:38:43','2023-01-20 09:35:27','2023-01-20 09:35:27'),(1130,7525,41011,25745,3,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',64186.80,NULL,NULL,1,'2023-01-19 18:38:43','2023-01-20 09:35:08','2023-01-20 09:35:08'),(1131,7525,41011,25745,3,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',64186.80,NULL,NULL,1,'2023-01-19 18:38:43','2023-01-20 09:34:58','2023-01-20 09:34:58'),(1132,7525,41011,25745,3,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',12485.59,NULL,NULL,1,'2023-01-19 18:38:43','2023-01-20 09:55:06','2023-01-20 09:55:06'),(1133,7525,41011,25745,3,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',30498.00,NULL,NULL,1,'2023-01-19 18:38:43','2023-01-19 18:38:43',NULL),(1134,7525,41011,25745,3,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',12485.60,NULL,NULL,1,'2023-01-20 09:55:06','2023-01-20 11:36:17','2023-01-20 11:36:17'),(1135,7525,41011,25745,3,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',7464.81,NULL,NULL,1,'2023-01-20 09:57:53','2023-01-20 09:57:53',NULL),(1136,7525,41011,25745,3,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',10531.52,NULL,NULL,1,'2023-01-20 10:01:36','2023-01-20 10:01:36',NULL),(1137,7525,41011,25745,3,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',6242.38,NULL,NULL,1,'2023-01-20 10:33:30','2023-01-20 10:33:30',NULL),(1138,7525,41011,25745,3,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',8551.30,NULL,NULL,1,'2023-01-20 10:36:25','2023-01-20 10:36:25',NULL);
INSERT INTO `balance_libro` VALUES (1139,7525,41011,25745,3,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',6500.00,NULL,NULL,1,'2023-01-20 10:40:25','2023-01-20 10:40:25',NULL),(1140,7525,41011,25745,3,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',11550.21,NULL,NULL,1,'2023-01-20 10:46:12','2023-01-20 10:46:12',NULL),(1141,7525,41011,25745,3,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',9901.42,NULL,NULL,1,'2023-01-20 10:54:06','2023-01-20 10:54:06',NULL),(1142,7525,41011,25745,3,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',7673.53,NULL,NULL,1,'2023-01-20 11:08:16','2023-01-20 11:08:16',NULL),(1143,7525,41011,25745,3,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',8143.53,NULL,NULL,1,'2023-01-20 11:11:34','2023-01-20 11:11:34',NULL),(1144,7525,41011,25745,3,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',5496.18,NULL,NULL,1,'2023-01-20 11:16:23','2023-01-20 11:16:23',NULL),(1145,7525,41011,25745,3,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',90000.01,NULL,NULL,1,'2023-01-20 11:18:03','2023-01-20 11:18:03',NULL),(1146,7525,41011,25745,3,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',5496.00,NULL,NULL,1,'2023-01-20 11:19:13','2023-01-20 11:19:13',NULL),(1147,7525,41011,25745,3,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',7328.19,NULL,NULL,1,'2023-01-20 11:23:39','2023-01-20 11:23:39',NULL),(1148,7525,41011,25745,3,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',78000.00,NULL,NULL,1,'2023-01-20 11:28:18','2023-01-20 11:28:18',NULL),(1149,7525,41011,25745,3,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',12563.94,NULL,NULL,1,'2023-01-20 11:36:17','2023-01-20 11:36:17',NULL),(1150,7525,40906,18176,2,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',133000.00,NULL,NULL,1,'2023-01-20 12:33:24','2023-01-20 12:33:24',NULL),(1151,7525,40906,18176,2,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',300000.00,NULL,NULL,1,'2023-01-20 12:33:24','2023-01-20 12:33:24',NULL),(1152,7525,40906,18176,3,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',6000.00,NULL,NULL,1,'2023-01-20 12:33:42','2023-01-20 12:56:31','2023-01-20 12:56:31'),(1153,7525,40906,18176,3,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',184275.74,NULL,NULL,1,'2023-01-20 12:33:42','2023-01-20 12:33:42',NULL),(1154,7525,40906,18176,3,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',64069.50,NULL,NULL,1,'2023-01-20 12:33:42','2023-01-20 12:33:42',NULL),(1155,7525,40906,18176,3,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1602.00,NULL,NULL,1,'2023-01-20 12:33:42','2023-01-20 12:35:09','2023-01-20 12:35:09'),(1156,7525,40906,18176,3,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',121000.00,NULL,NULL,1,'2023-01-20 12:33:42','2023-01-20 12:33:42',NULL),(1157,7525,40906,18176,3,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',12100.00,NULL,NULL,1,'2023-01-20 12:33:42','2023-01-20 12:33:42',NULL),(1158,7525,40906,18176,3,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3299.00,NULL,NULL,1,'2023-01-20 12:33:42','2023-01-20 12:34:53','2023-01-20 12:34:53'),(1159,7525,40906,18176,3,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',56688.50,NULL,NULL,1,'2023-01-20 12:33:42','2023-01-20 12:33:42',NULL);
INSERT INTO `balance_libro` VALUES (1160,7525,40906,18176,3,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',6000.00,NULL,NULL,1,'2023-01-20 12:56:31','2023-01-20 12:56:31',NULL),(1161,7525,40906,18176,7,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',37574.38,NULL,NULL,1,'2023-01-20 13:03:50','2023-01-20 13:04:13','2023-01-20 13:04:13'),(1162,7525,40906,18176,7,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',37574.38,NULL,NULL,1,'2023-01-20 13:04:13','2023-01-20 13:04:13',NULL),(1163,7525,40917,19691,2,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',32020.28,NULL,NULL,1,'2023-01-20 13:56:13','2023-01-20 13:56:13',NULL),(1164,7525,40917,19691,2,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',5280.05,NULL,NULL,1,'2023-01-20 13:56:13','2023-01-20 13:56:13',NULL),(1165,7525,40917,19691,2,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',40450.04,NULL,NULL,1,'2023-01-20 13:56:13','2023-01-20 13:56:13',NULL),(1166,7525,40917,19691,2,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',48510.17,NULL,NULL,1,'2023-01-20 13:56:13','2023-01-20 13:56:13',NULL),(1167,7525,40917,19691,2,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',195000.58,NULL,NULL,1,'2023-01-20 13:56:13','2023-01-20 13:56:13',NULL),(1168,7525,40917,19691,2,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',20620.06,NULL,NULL,1,'2023-01-20 13:56:13','2023-01-20 13:56:13',NULL),(1169,7525,40917,19691,2,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',195000.58,NULL,NULL,1,'2023-01-20 13:56:13','2023-01-20 13:56:13',NULL),(1170,7525,40917,19691,2,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',40780.38,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1171,7525,40917,19691,2,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',8760.01,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1172,7525,40917,19691,2,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',54600.16,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1173,7525,40917,19691,2,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',195000.58,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1174,7525,40917,19691,2,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',12940.00,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1175,7525,40917,19691,2,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',22480.01,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1176,7525,40917,19691,2,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',15900.00,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1177,7525,40917,19691,2,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',160001.32,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1178,7525,40917,19691,2,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',5960.02,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1179,7525,40917,19691,2,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',24460.20,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1180,7525,40917,19691,2,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',15250.06,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL);
INSERT INTO `balance_libro` VALUES (1181,7525,40917,19691,2,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',10860.06,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1182,7525,40917,19691,2,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',75250.19,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1183,7525,40917,19691,2,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',13000.05,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1184,7525,40917,19691,2,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',93800.65,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1185,7525,40917,19691,2,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',2960.02,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1186,7525,40917,19691,2,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',18020.13,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1187,7525,40917,19691,2,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',8510.07,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1188,7525,40917,19691,2,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',163551.27,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1189,7525,40917,19691,2,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',28800.05,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1190,7525,40917,19691,2,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2640.03,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1191,7525,40917,19691,2,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',84700.00,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1192,7525,40917,19691,2,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',105601.06,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1193,7525,40917,19691,2,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',66550.00,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1194,7525,40917,19691,2,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',99300.70,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1195,7525,40917,19691,2,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',168410.74,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1196,7525,40917,19691,2,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',121000.00,NULL,NULL,1,'2023-01-20 13:56:14','2023-01-20 13:56:14',NULL),(1197,7525,40917,19691,3,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',26620.00,NULL,NULL,1,'2023-01-20 13:56:24','2023-01-20 13:56:24',NULL),(1198,7525,40917,19691,3,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',116549.86,NULL,NULL,1,'2023-01-20 13:56:24','2023-01-20 13:56:24',NULL),(1199,7525,40917,19691,3,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',105960.00,NULL,NULL,1,'2023-01-20 13:56:24','2023-01-20 14:20:35','2023-01-20 14:20:35'),(1200,7525,40917,19691,3,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',177649.98,NULL,NULL,1,'2023-01-20 13:56:24','2023-01-20 13:56:24',NULL);
INSERT INTO `balance_libro` VALUES (1201,7525,40917,19691,3,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',71699.75,NULL,NULL,1,'2023-01-20 13:56:24','2023-01-20 13:56:24',NULL),(1202,7525,40917,19691,3,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',13800.10,NULL,NULL,1,'2023-01-20 13:56:24','2023-01-20 14:20:12','2023-01-20 14:20:12'),(1203,7525,40917,19691,3,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',219063.17,NULL,NULL,1,'2023-01-20 13:56:24','2023-01-20 14:20:00','2023-01-20 14:20:00'),(1204,7525,40917,19691,3,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',6000.00,NULL,NULL,1,'2023-01-20 13:56:24','2023-01-20 14:19:06','2023-01-20 14:19:06'),(1205,7525,40917,19691,3,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',195950.42,NULL,NULL,1,'2023-01-20 13:56:24','2023-01-20 13:56:24',NULL),(1206,7525,40917,19691,3,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',79637.71,NULL,NULL,1,'2023-01-20 13:56:24','2023-01-20 14:18:47','2023-01-20 14:18:47'),(1207,7525,40917,19691,3,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',33200.10,NULL,NULL,1,'2023-01-20 13:56:24','2023-01-20 14:18:37','2023-01-20 14:18:37'),(1208,7525,40917,19691,3,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',33200.10,NULL,NULL,1,'2023-01-20 13:56:24','2023-01-20 14:18:22','2023-01-20 14:18:22'),(1209,7525,40917,19691,3,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',109860.00,NULL,NULL,1,'2023-01-20 13:56:24','2023-01-20 14:18:06','2023-01-20 14:18:06'),(1210,7525,40917,19691,3,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',10913.29,NULL,NULL,1,'2023-01-20 13:56:24','2023-01-20 13:56:24',NULL),(1211,7525,40917,19691,3,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',101580.04,NULL,NULL,1,'2023-01-20 13:56:24','2023-01-20 13:56:24',NULL),(1212,7525,40917,19691,3,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',53219.85,NULL,NULL,1,'2023-01-20 13:56:24','2023-01-20 14:16:34','2023-01-20 14:16:34'),(1213,7525,40917,19691,3,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',153759.93,NULL,NULL,1,'2023-01-20 13:56:24','2023-01-20 13:56:24',NULL),(1214,7525,40917,19691,3,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',36900.04,NULL,NULL,1,'2023-01-20 13:56:24','2023-01-20 13:56:24',NULL),(1215,7525,40917,19691,3,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',291119.19,NULL,NULL,1,'2023-01-20 13:56:24','2023-01-20 13:56:24',NULL),(1216,7525,40917,19691,3,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',173649.88,NULL,NULL,1,'2023-01-20 13:56:25','2023-01-20 13:56:25',NULL),(1217,7525,40917,19691,3,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',20351.99,NULL,NULL,1,'2023-01-20 13:56:25','2023-01-20 14:14:57','2023-01-20 14:14:57'),(1218,7525,40917,19691,7,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3151.98,NULL,NULL,1,'2023-01-20 13:57:53','2023-01-20 13:57:53',NULL),(1219,7525,40917,19691,3,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',53219.85,NULL,NULL,1,'2023-01-20 14:16:34','2023-01-20 16:13:21','2023-01-20 16:13:21'),(1220,7525,40917,19691,3,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',6000.00,NULL,NULL,1,'2023-01-20 14:19:06','2023-01-20 14:19:06',NULL);
INSERT INTO `balance_libro` VALUES (1221,7525,40917,19691,3,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',219063.17,NULL,NULL,1,'2023-01-20 14:20:00','2023-01-20 14:20:00',NULL),(1222,7525,40917,19691,3,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',143261.97,NULL,NULL,1,'2023-01-20 15:09:36','2023-01-20 15:09:36',NULL),(1223,7525,40917,19691,3,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',58099.34,NULL,NULL,1,'2023-01-20 15:43:04','2023-01-20 15:43:04',NULL),(1224,7525,40917,19691,3,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',81339.08,NULL,NULL,1,'2023-01-20 15:46:52','2023-01-20 15:46:52',NULL),(1225,7525,40917,19691,3,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',72019.95,NULL,NULL,1,'2023-01-20 15:48:50','2023-01-20 15:48:50',NULL),(1226,7525,40917,19691,3,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',170029.79,NULL,NULL,1,'2023-01-20 15:49:55','2023-01-20 15:49:55',NULL),(1227,7525,40917,19691,3,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',70072.52,NULL,NULL,1,'2023-01-20 15:52:04','2023-01-20 15:52:04',NULL),(1228,7525,40917,19691,3,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',156962.45,NULL,NULL,1,'2023-01-20 15:55:56','2023-01-20 15:55:56',NULL),(1229,7525,40917,19691,3,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',30831.91,NULL,NULL,1,'2023-01-20 15:58:23','2023-01-20 15:58:23',NULL),(1230,7525,40917,19691,3,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',98101.53,NULL,NULL,1,'2023-01-20 16:00:13','2023-01-20 16:00:13',NULL),(1231,7525,40917,19691,3,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',53478.66,NULL,NULL,1,'2023-01-20 16:13:21','2023-01-20 16:13:21',NULL),(1232,7525,40915,22718,2,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',72600.00,NULL,NULL,1,'2023-01-20 16:58:20','2023-01-20 16:58:20',NULL),(1233,7525,40915,22718,2,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',39385.50,NULL,NULL,1,'2023-01-20 16:58:20','2023-01-20 16:58:20',NULL),(1234,7525,40915,22718,2,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',69514.50,NULL,NULL,1,'2023-01-20 16:58:21','2023-01-20 16:58:21',NULL),(1235,7525,40915,22718,2,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',12100.00,NULL,NULL,1,'2023-01-20 16:58:21','2023-01-20 16:58:21',NULL),(1236,7525,40915,22718,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',6000.00,NULL,NULL,1,'2023-01-20 16:58:54','2023-01-20 17:07:43','2023-01-20 17:07:43'),(1237,7525,40915,22718,3,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',30000.00,NULL,NULL,1,'2023-01-20 16:58:54','2023-01-20 17:08:09','2023-01-20 17:08:09'),(1238,7525,40915,22718,3,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',0.00,NULL,NULL,1,'2023-01-20 16:58:54','2023-01-20 17:07:22','2023-01-20 17:07:22'),(1239,7525,40915,22718,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',6000.00,NULL,NULL,1,'2023-01-20 17:07:43','2023-01-20 17:07:43',NULL),(1240,7525,40915,22718,3,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',30000.00,NULL,NULL,1,'2023-01-20 17:08:09','2023-01-20 17:08:09',NULL);
INSERT INTO `balance_libro` VALUES (1241,7525,40915,22718,3,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',9599.99,NULL,NULL,1,'2023-01-20 17:10:34','2023-01-20 17:10:34',NULL),(1242,7525,40915,22718,3,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',16499.00,NULL,NULL,1,'2023-01-20 17:12:03','2023-01-20 17:12:03',NULL),(1243,7525,40915,22718,3,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',42380.02,NULL,NULL,1,'2023-01-20 17:13:43','2023-01-20 17:13:43',NULL),(1244,7525,40915,22718,3,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',5500.40,NULL,NULL,1,'2023-01-20 17:18:53','2023-01-20 17:18:53',NULL),(1245,7525,40915,22718,3,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',7500.00,NULL,NULL,1,'2023-01-20 17:43:46','2023-01-20 17:43:46',NULL),(1246,7525,40915,22718,3,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',6800.09,NULL,NULL,1,'2023-01-20 17:45:06','2023-01-20 17:45:06',NULL),(1247,7525,40915,22718,3,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',7600.80,NULL,NULL,1,'2023-01-20 17:45:44','2023-01-20 17:45:44',NULL),(1248,7525,40915,22718,3,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',5801.36,NULL,NULL,1,'2023-01-20 17:46:36','2023-01-20 17:46:36',NULL),(1249,7525,40915,22718,3,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',11829.95,NULL,NULL,1,'2023-01-20 17:47:12','2023-01-20 17:47:12',NULL),(1250,7525,40915,22718,3,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',5000.10,NULL,NULL,1,'2023-01-20 17:50:15','2023-01-20 17:50:15',NULL),(1251,7525,40915,22718,3,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',10499.59,NULL,NULL,1,'2023-01-20 17:50:55','2023-01-20 17:50:55',NULL),(1252,7525,40915,22718,3,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',12200.10,NULL,NULL,1,'2023-01-20 17:51:52','2023-01-20 17:51:52',NULL),(1253,7525,40991,24233,3,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',48540.07,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:28:50','2023-01-20 19:28:50'),(1254,7525,40991,24233,3,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2916.05,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:29:06','2023-01-20 19:29:06'),(1255,7525,40991,24233,3,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1350.33,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:13:05',NULL),(1256,7525,40991,24233,3,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1564.68,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:13:05',NULL),(1257,7525,40991,24233,3,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',579.00,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:30:27','2023-01-20 19:30:27'),(1258,7525,40991,24233,3,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',7000.00,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:30:53','2023-01-20 19:30:53'),(1259,7525,40991,24233,3,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',116308.83,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:13:05',NULL),(1260,7525,40991,24233,3,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',353.00,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:32:04','2023-01-20 19:32:04');
INSERT INTO `balance_libro` VALUES (1261,7525,40991,24233,3,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',288.00,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:32:12','2023-01-20 19:32:12'),(1262,7525,40991,24233,3,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',94087.59,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:13:05',NULL),(1263,7525,40991,24233,3,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',22139.99,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:31:35','2023-01-20 19:31:35'),(1264,7525,40991,24233,3,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',26716.80,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:33:41','2023-01-20 19:33:41'),(1265,7525,40991,24233,3,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',3300.00,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:22:07','2023-01-20 19:22:07'),(1266,7525,40991,24233,3,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',18235.95,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:21:57','2023-01-20 19:21:57'),(1267,7525,40991,24233,3,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',15550.92,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:21:50','2023-01-20 19:21:50'),(1268,7525,40991,24233,3,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',4999.72,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:13:05',NULL),(1269,7525,40991,24233,3,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',640.00,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:21:24','2023-01-20 19:21:24'),(1270,7525,40991,24233,3,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',3000.20,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:13:05',NULL),(1271,7525,40991,24233,3,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',62450.52,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:21:11','2023-01-20 19:21:11'),(1272,7525,40991,24233,3,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',63000.00,NULL,NULL,1,'2023-01-20 19:13:05','2023-01-20 19:20:57','2023-01-20 19:20:57'),(1273,7525,40991,24233,3,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',18235.95,NULL,NULL,1,'2023-01-20 19:27:49','2023-01-20 19:27:49',NULL),(1274,7525,40991,24233,3,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2916.05,NULL,NULL,1,'2023-01-20 19:29:06','2023-01-20 19:29:17','2023-01-20 19:29:17'),(1275,7525,40991,24233,3,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',7000.00,NULL,NULL,1,'2023-01-20 19:30:53','2023-01-20 19:30:53',NULL),(1276,7525,40991,24233,3,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',8802.58,NULL,NULL,1,'2023-01-20 19:36:00','2023-01-20 19:36:00',NULL),(1277,7525,40991,24233,3,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',5000.10,NULL,NULL,1,'2023-01-20 19:48:02','2023-01-20 19:48:02',NULL),(1278,7525,40991,24233,3,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',6000.09,NULL,NULL,1,'2023-01-20 19:48:37','2023-01-20 19:48:37',NULL),(1279,7525,41023,27264,2,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',59400.00,NULL,NULL,1,'2023-01-20 20:24:10','2023-01-20 20:24:10',NULL),(1280,7525,41023,27264,3,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',106625.46,NULL,NULL,1,'2023-01-20 20:24:24','2023-01-20 20:36:35','2023-01-20 20:36:35');
INSERT INTO `balance_libro` VALUES (1281,7525,41023,27264,3,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',11125.13,NULL,NULL,1,'2023-01-20 20:24:24','2023-01-20 20:45:34','2023-01-20 20:45:34'),(1282,7525,41023,27264,3,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',9780.29,NULL,NULL,1,'2023-01-20 20:24:24','2023-01-20 21:03:48','2023-01-20 21:03:48'),(1283,7525,41023,27264,3,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',11000.00,NULL,NULL,1,'2023-01-20 20:24:24','2023-01-20 20:46:01','2023-01-20 20:46:01'),(1284,7525,41023,27264,3,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',13099.72,NULL,NULL,1,'2023-01-20 20:24:24','2023-01-20 20:46:13','2023-01-20 20:46:13'),(1285,7525,41023,27264,3,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',300000.00,NULL,NULL,1,'2023-01-20 20:24:24','2023-01-20 20:46:41','2023-01-20 20:46:41'),(1286,7525,41023,27264,3,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',300000.00,NULL,NULL,1,'2023-01-20 20:24:24','2023-01-20 20:46:36','2023-01-20 20:46:36'),(1287,7525,41023,27264,3,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',106624.99,NULL,NULL,1,'2023-01-20 20:36:35','2023-01-20 20:36:35',NULL),(1288,7525,41023,27264,3,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',11125.13,NULL,NULL,1,'2023-01-20 20:45:34','2023-01-20 20:45:34',NULL),(1289,7525,41023,27264,3,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',11000.00,NULL,NULL,1,'2023-01-20 20:46:01','2023-01-20 20:46:01',NULL),(1290,7525,41023,27264,3,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',9780.30,NULL,NULL,1,'2023-01-20 21:03:48','2023-01-20 21:03:48',NULL),(1291,7525,40720,1529,2,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',28317.11,NULL,NULL,1,'2023-02-13 13:10:49','2023-02-13 13:10:49',NULL),(1292,7525,40720,1529,2,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',200.00,NULL,NULL,1,'2023-02-13 13:10:49','2023-02-13 13:10:49',NULL),(1293,7525,40720,1529,2,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',21366.99,NULL,NULL,1,'2023-02-13 13:10:49','2023-02-13 13:10:49',NULL),(1294,7525,40720,1529,2,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',37247.08,NULL,NULL,1,'2023-02-13 13:10:49','2023-02-13 13:10:49',NULL),(1295,7525,40720,1529,2,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',37753.04,NULL,NULL,1,'2023-02-13 13:10:49','2023-02-13 13:10:49',NULL),(1296,7525,40720,1529,2,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',46825.04,NULL,NULL,1,'2023-02-13 13:10:49','2023-02-13 13:10:49',NULL),(1297,7525,40720,1529,2,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',20470.09,NULL,NULL,1,'2023-02-13 13:10:49','2023-02-13 13:10:49',NULL),(1298,7525,40720,1529,2,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',13275.08,NULL,NULL,1,'2023-02-13 13:11:00','2023-02-13 13:11:00',NULL),(1299,7525,40720,1529,2,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',32508.95,NULL,NULL,1,'2023-02-13 13:11:01','2023-02-13 13:11:01',NULL),(1300,7525,40720,1529,2,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',40987.02,NULL,NULL,1,'2023-02-13 13:11:01','2023-02-13 13:11:01',NULL);
INSERT INTO `balance_libro` VALUES (1301,7525,40720,1529,2,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',494.03,NULL,NULL,1,'2023-02-13 13:11:01','2023-02-13 13:11:01',NULL),(1302,7525,40720,1529,2,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',12541.94,NULL,NULL,1,'2023-02-13 13:11:01','2023-02-13 13:11:01',NULL),(1303,7525,40720,1529,2,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',61115.95,NULL,NULL,1,'2023-02-13 13:11:01','2023-02-13 13:11:01',NULL),(1304,7525,40849,13644,2,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',17093.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1305,7525,40849,13644,2,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',32058.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1306,7525,40849,13644,2,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',32145.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1307,7525,40849,13644,2,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',53348.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1308,7525,40849,13644,2,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',51731.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1309,7525,40849,13644,2,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',53525.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1310,7525,40849,13644,2,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',4335.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1311,7525,40849,13644,2,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2500.10,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1312,7525,40849,13644,2,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',3410.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1313,7525,40849,13644,2,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1784.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1314,7525,40849,13644,2,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1586.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1315,7525,40849,13644,2,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2200.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1316,7525,40849,13644,2,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',24213.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1317,7525,40849,13644,2,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',28107.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1318,7525,40849,13644,2,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',31893.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1319,7525,40849,13644,2,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',56805.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1320,7525,40849,13644,2,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',26291.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1321,7525,40849,13644,2,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',55769.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL);
INSERT INTO `balance_libro` VALUES (1322,7525,40849,13644,2,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',40150.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1323,7525,40849,13644,2,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',28439.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1324,7525,40849,13644,2,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',28900.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1325,7525,40849,13644,2,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',37000.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1326,7525,40849,13644,2,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',35899.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1327,7525,40849,13644,2,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',52225.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1328,7525,40849,13644,2,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',27918.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1329,7525,40849,13644,2,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',37634.00,NULL,NULL,1,'2023-02-25 20:07:58','2023-02-25 20:07:58',NULL),(1330,7525,40849,13644,3,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',33901.35,NULL,NULL,1,'2023-02-25 20:11:15','2023-02-25 20:46:27','2023-02-25 20:46:27'),(1331,7525,40849,13644,3,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',7270.06,NULL,NULL,1,'2023-02-25 20:11:15','2023-02-25 20:46:04','2023-02-25 20:46:04'),(1332,7525,40849,13644,3,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2344.73,NULL,NULL,1,'2023-02-25 20:11:16','2023-02-25 20:45:24','2023-02-25 20:45:24'),(1333,7525,40849,13644,3,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',25011.70,NULL,NULL,1,'2023-02-25 20:11:16','2023-02-25 20:43:59','2023-02-25 20:43:59'),(1334,7525,40849,13644,3,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',187.86,NULL,NULL,1,'2023-02-25 20:11:16','2023-02-25 20:43:27','2023-02-25 20:43:27'),(1335,7525,40849,13644,3,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3040.89,NULL,NULL,1,'2023-02-25 20:11:16','2023-02-25 20:42:07','2023-02-25 20:42:07'),(1336,7525,40849,13644,3,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',206065.42,NULL,NULL,1,'2023-02-25 20:11:16','2023-02-25 20:11:16',NULL),(1337,7525,40849,13644,3,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',8992.76,NULL,NULL,1,'2023-02-25 20:11:16','2023-02-25 20:41:26','2023-02-25 20:41:26'),(1338,7525,40849,13644,3,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',22564.70,NULL,NULL,1,'2023-02-25 20:11:16','2023-02-25 20:40:54','2023-02-25 20:40:54'),(1339,7525,40849,13644,3,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',11955.84,NULL,NULL,1,'2023-02-25 20:11:16','2023-02-25 20:40:08','2023-02-25 20:40:08'),(1340,7525,40849,13644,3,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',6000.00,NULL,NULL,1,'2023-02-25 20:11:16','2023-02-25 20:11:16',NULL),(1341,7525,40849,13644,3,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',23906.15,NULL,NULL,1,'2023-02-25 20:11:16','2023-02-25 20:39:12','2023-02-25 20:39:12');
INSERT INTO `balance_libro` VALUES (1342,7525,40849,13644,3,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',4629.91,NULL,NULL,1,'2023-02-25 20:11:16','2023-02-25 20:38:24','2023-02-25 20:38:24'),(1343,7525,40849,13644,3,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',4054.52,NULL,NULL,1,'2023-02-25 20:11:16','2023-02-25 20:37:38','2023-02-25 20:37:38'),(1344,7525,40849,13644,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',6587.93,NULL,NULL,1,'2023-02-25 20:11:16','2023-02-25 20:36:39','2023-02-25 20:36:39'),(1345,7525,40849,13644,3,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3285.26,NULL,NULL,1,'2023-02-25 20:11:16','2023-02-25 20:35:53','2023-02-25 20:35:53'),(1346,7525,40849,13644,3,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',9729.21,NULL,NULL,1,'2023-02-25 20:11:16','2023-02-25 20:35:19','2023-02-25 20:35:19'),(1347,7525,40849,13644,3,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',5250.45,NULL,NULL,1,'2023-02-25 20:11:17','2023-02-25 20:34:34','2023-02-25 20:34:34'),(1348,7525,40849,13644,3,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',29994.71,NULL,NULL,1,'2023-02-25 20:11:17','2023-02-25 20:32:56','2023-02-25 20:32:56'),(1349,7525,40849,13644,3,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',152600.00,NULL,NULL,1,'2023-02-25 20:11:17','2023-02-25 20:11:17',NULL),(1350,7525,40849,13644,3,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',16424.52,NULL,NULL,1,'2023-02-25 20:11:17','2023-02-25 20:32:03','2023-02-25 20:32:03'),(1351,7525,40849,13644,3,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',28146.12,NULL,NULL,1,'2023-02-25 20:11:17','2023-02-25 20:12:59','2023-02-25 20:12:59'),(1352,7525,40849,13644,3,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2740.00,NULL,NULL,1,'2023-02-25 20:11:17','2023-02-25 20:12:31','2023-02-25 20:12:31'),(1353,7525,40849,13644,3,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',203951.79,NULL,NULL,1,'2023-02-25 20:11:17','2023-02-25 20:11:17',NULL),(1354,7525,40849,13644,3,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3543.17,NULL,NULL,1,'2023-02-25 20:11:17','2023-02-25 20:31:35','2023-02-25 20:31:35'),(1355,7525,40849,13644,3,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',4235.00,NULL,NULL,1,'2023-02-25 20:11:17','2023-02-25 20:11:17',NULL),(1356,7525,40849,13644,3,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',17026.04,NULL,NULL,1,'2023-02-25 20:11:17','2023-02-25 20:30:35','2023-02-25 20:30:35'),(1357,7525,40849,13644,3,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',27556.10,NULL,NULL,1,'2023-02-25 20:11:17','2023-02-25 20:29:52','2023-02-25 20:29:52'),(1358,7525,40849,13644,3,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',11800.52,NULL,NULL,1,'2023-02-25 20:11:17','2023-02-25 20:24:54','2023-02-25 20:24:54'),(1359,7525,40849,13644,3,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',6249.26,NULL,NULL,1,'2023-02-25 20:11:17','2023-02-25 20:23:53','2023-02-25 20:23:53'),(1360,7525,40849,13644,3,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',18300.93,NULL,NULL,1,'2023-02-25 20:11:17','2023-02-25 20:23:22','2023-02-25 20:23:22');
INSERT INTO `balance_libro` VALUES (1361,7525,40849,13644,3,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',439.10,NULL,NULL,1,'2023-02-25 20:11:17','2023-02-25 20:22:47','2023-02-25 20:22:47'),(1362,7525,40849,13644,3,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16227.12,NULL,NULL,1,'2023-02-25 20:11:17','2023-02-25 20:20:07','2023-02-25 20:20:07'),(1363,7525,40849,13644,3,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',11144.47,NULL,NULL,1,'2023-02-25 20:11:17','2023-02-25 20:19:49','2023-02-25 20:19:49'),(1364,7525,40849,13644,3,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5342.80,NULL,NULL,1,'2023-02-25 20:11:17','2023-02-25 20:12:14','2023-02-25 20:12:14'),(1365,7525,40849,13644,3,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',11144.46,NULL,NULL,1,'2023-02-25 20:19:49','2023-02-25 20:19:49',NULL),(1366,7525,40849,13644,3,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15689.01,NULL,NULL,1,'2023-02-25 20:20:07','2023-02-25 20:20:46','2023-02-25 20:20:46'),(1367,7525,40849,13644,3,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16227.12,NULL,NULL,1,'2023-02-25 20:20:46','2023-02-25 20:20:46',NULL),(1368,7525,40849,13644,3,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',18300.93,NULL,NULL,1,'2023-02-25 20:23:22','2023-02-25 20:23:22',NULL),(1369,7525,40849,13644,3,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',6249.26,NULL,NULL,1,'2023-02-25 20:23:53','2023-02-25 20:23:53',NULL),(1370,7525,40849,13644,3,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',11800.51,NULL,NULL,1,'2023-02-25 20:24:54','2023-02-25 20:24:54',NULL),(1371,7525,40849,13644,3,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',27556.10,NULL,NULL,1,'2023-02-25 20:29:52','2023-02-25 20:29:52',NULL),(1372,7525,40849,13644,3,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',17026.04,NULL,NULL,1,'2023-02-25 20:30:35','2023-02-25 20:30:35',NULL),(1373,7525,40849,13644,3,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3543.17,NULL,NULL,1,'2023-02-25 20:31:35','2023-02-25 20:31:35',NULL),(1374,7525,40849,13644,3,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',29994.71,NULL,NULL,1,'2023-02-25 20:32:56','2023-02-25 20:32:56',NULL),(1375,7525,40849,13644,3,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',5250.45,NULL,NULL,1,'2023-02-25 20:34:34','2023-02-25 20:34:34',NULL),(1376,7525,40849,13644,3,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',9729.21,NULL,NULL,1,'2023-02-25 20:35:19','2023-02-25 20:35:19',NULL),(1377,7525,40849,13644,3,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3285.26,NULL,NULL,1,'2023-02-25 20:35:53','2023-02-25 20:35:53',NULL),(1378,7525,40849,13644,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',5946.41,NULL,NULL,1,'2023-02-25 20:36:39','2023-02-25 20:37:09','2023-02-25 20:37:09'),(1379,7525,40849,13644,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',6587.84,NULL,NULL,1,'2023-02-25 20:37:09','2023-02-25 20:56:12','2023-02-25 20:56:12'),(1380,7525,40849,13644,3,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',4054.52,NULL,NULL,1,'2023-02-25 20:37:38','2023-02-25 21:01:41','2023-02-25 21:01:41');
INSERT INTO `balance_libro` VALUES (1381,7525,40849,13644,3,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',4629.91,NULL,NULL,1,'2023-02-25 20:38:24','2023-02-25 20:38:24',NULL),(1382,7525,40849,13644,3,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',23906.15,NULL,NULL,1,'2023-02-25 20:39:12','2023-02-25 20:39:12',NULL),(1383,7525,40849,13644,3,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',11955.83,NULL,NULL,1,'2023-02-25 20:40:08','2023-02-25 20:40:08',NULL),(1384,7525,40849,13644,3,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',22564.70,NULL,NULL,1,'2023-02-25 20:40:54','2023-02-25 20:40:54',NULL),(1385,7525,40849,13644,3,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',8992.76,NULL,NULL,1,'2023-02-25 20:41:26','2023-02-25 20:41:26',NULL),(1386,7525,40849,13644,3,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3040.82,NULL,NULL,1,'2023-02-25 20:42:07','2023-02-25 21:02:36','2023-02-25 21:02:36'),(1387,7525,40849,13644,3,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',25011.70,NULL,NULL,1,'2023-02-25 20:43:59','2023-02-25 21:07:20','2023-02-25 21:07:20'),(1388,7525,40849,13644,3,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2344.73,NULL,NULL,1,'2023-02-25 20:45:24','2023-02-25 20:45:24',NULL),(1389,7525,40849,13644,3,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',7270.05,NULL,NULL,1,'2023-02-25 20:46:04','2023-02-25 20:46:04',NULL),(1390,7525,40849,13644,3,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',32719.94,NULL,NULL,1,'2023-02-25 20:46:27','2023-02-25 20:47:17','2023-02-25 20:47:17'),(1391,7525,40849,13644,3,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',33901.35,NULL,NULL,1,'2023-02-25 20:47:17','2023-02-25 20:47:17',NULL),(1392,7525,40849,13644,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',6587.84,NULL,NULL,1,'2023-02-25 20:56:12','2023-02-25 20:58:42','2023-02-25 20:58:42'),(1393,7525,40849,13644,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',6587.84,NULL,NULL,1,'2023-02-25 20:58:42','2023-02-25 21:01:19','2023-02-25 21:01:19'),(1394,7525,40849,13644,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',6587.84,NULL,NULL,1,'2023-02-25 21:01:19','2023-02-25 21:01:19',NULL),(1395,7525,40849,13644,3,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',4054.52,NULL,NULL,1,'2023-02-25 21:01:41','2023-02-25 21:01:41',NULL),(1396,7525,40849,13644,3,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3040.82,NULL,NULL,1,'2023-02-25 21:02:36','2023-02-25 21:02:36',NULL),(1397,7525,40849,13644,3,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',25011.70,NULL,NULL,1,'2023-02-25 21:07:20','2023-02-25 21:07:20',NULL),(1398,7525,40856,15156,2,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',223898.40,NULL,NULL,1,'2023-02-25 21:25:25','2023-02-25 21:25:25',NULL),(1399,7525,40856,15156,2,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',102850.00,NULL,NULL,1,'2023-02-25 21:25:25','2023-02-25 21:25:25',NULL),(1400,7525,40856,15156,3,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',4900.00,NULL,NULL,1,'2023-02-25 21:25:39','2023-02-27 16:23:48','2023-02-27 16:23:48');
INSERT INTO `balance_libro` VALUES (1401,7525,40856,15156,3,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',24645.01,NULL,NULL,1,'2023-02-25 21:25:39','2023-02-27 16:22:52','2023-02-27 16:22:52'),(1402,7525,40856,15156,3,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',163.00,NULL,NULL,1,'2023-02-25 21:25:39','2023-02-28 16:11:16','2023-02-28 16:11:16'),(1403,7525,40856,15156,3,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',617.96,NULL,NULL,1,'2023-02-25 21:25:39','2023-02-28 16:10:52','2023-02-28 16:10:52'),(1404,7525,40856,15156,3,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',100.00,NULL,NULL,1,'2023-02-25 21:25:39','2023-02-25 22:10:00','2023-02-25 22:10:00'),(1405,7525,40856,15156,3,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',136.00,NULL,NULL,1,'2023-02-25 21:25:39','2023-02-28 16:05:21','2023-02-28 16:05:21'),(1406,7525,40856,15156,3,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',27980.83,NULL,NULL,1,'2023-02-25 21:25:39','2023-02-28 16:05:09','2023-02-28 16:05:09'),(1407,7525,40856,15156,3,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',25000.00,NULL,NULL,1,'2023-02-25 21:25:39','2023-02-28 16:04:46','2023-02-28 16:04:46'),(1408,7525,40856,15156,3,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',10560.00,NULL,NULL,1,'2023-02-25 21:25:39','2023-02-28 16:04:20','2023-02-28 16:04:20'),(1409,7525,40856,15156,3,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1232.00,NULL,NULL,1,'2023-02-25 21:25:39','2023-02-25 22:09:19','2023-02-25 22:09:19'),(1410,7525,40856,15156,3,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',8000.00,NULL,NULL,1,'2023-02-25 21:25:39','2023-02-25 22:09:46','2023-02-25 22:09:46'),(1411,7525,40856,15156,3,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',12800.00,NULL,NULL,1,'2023-02-25 21:25:39','2023-02-25 22:09:29','2023-02-25 22:09:29'),(1412,7525,40856,15156,3,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',7000.00,NULL,NULL,1,'2023-02-25 21:25:39','2023-02-27 16:22:00','2023-02-27 16:22:00'),(1413,7525,40856,15156,3,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',950.00,NULL,NULL,1,'2023-02-25 21:25:39','2023-02-25 22:09:07','2023-02-25 22:09:07'),(1414,7525,40856,15156,3,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',6500.00,NULL,NULL,1,'2023-02-25 21:25:39','2023-02-28 16:03:37','2023-02-28 16:03:37'),(1415,7525,40856,15156,3,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',25000.00,NULL,NULL,1,'2023-02-25 21:25:39','2023-02-28 16:03:17','2023-02-28 16:03:17'),(1416,7525,40856,15156,3,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',34.00,NULL,NULL,1,'2023-02-25 21:25:39','2023-02-25 22:11:04','2023-02-25 22:11:04'),(1417,7525,40856,15156,3,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',6308.99,NULL,NULL,1,'2023-02-25 21:25:40','2023-02-28 16:02:51','2023-02-28 16:02:51'),(1418,7525,40856,15156,3,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',25000.00,NULL,NULL,1,'2023-02-25 21:25:40','2023-02-28 16:02:36','2023-02-28 16:02:36'),(1419,7525,40856,15156,3,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',680.00,NULL,NULL,1,'2023-02-25 21:25:40','2023-02-28 16:02:21','2023-02-28 16:02:21');
INSERT INTO `balance_libro` VALUES (1420,7525,40856,15156,3,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1697.55,NULL,NULL,1,'2023-02-25 21:25:40','2023-02-28 16:02:10','2023-02-28 16:02:10'),(1421,7525,40856,15156,3,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',20331.63,NULL,NULL,1,'2023-02-25 21:25:40','2023-02-25 22:08:38','2023-02-25 22:08:38'),(1422,7525,40856,15156,3,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',53564.28,NULL,NULL,1,'2023-02-25 21:25:40','2023-02-28 16:01:28','2023-02-28 16:01:28'),(1423,7525,40856,15156,3,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',106106.00,NULL,NULL,1,'2023-02-25 21:25:40','2023-02-27 16:21:31','2023-02-27 16:21:31'),(1424,7525,40856,15156,3,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',40708.35,NULL,NULL,1,'2023-02-25 21:25:40','2023-02-27 16:21:14','2023-02-27 16:21:14'),(1425,7525,40856,15156,3,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',8850.44,NULL,NULL,1,'2023-02-25 21:25:40','2023-02-28 16:00:51','2023-02-28 16:00:51'),(1426,7525,40856,15156,3,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',8765.00,NULL,NULL,1,'2023-02-25 21:25:40','2023-02-25 22:10:31','2023-02-25 22:10:31'),(1427,7525,40856,15156,3,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',40708.35,NULL,NULL,1,'2023-02-27 16:21:14','2023-02-27 16:21:14',NULL),(1428,7525,40856,15156,3,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',106106.00,NULL,NULL,1,'2023-02-27 16:21:31','2023-02-27 16:21:31',NULL),(1429,7525,40856,15156,3,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',7000.00,NULL,NULL,1,'2023-02-27 16:22:00','2023-02-28 16:03:54','2023-02-28 16:03:54'),(1430,7525,40856,15156,3,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',24645.00,NULL,NULL,1,'2023-02-27 16:22:52','2023-02-27 16:22:52',NULL),(1431,7525,40856,15156,3,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',4900.00,NULL,NULL,1,'2023-02-27 16:23:48','2023-02-27 16:23:48',NULL),(1432,7525,40875,16668,3,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',25318.08,NULL,NULL,1,'2023-02-27 17:02:24','2023-02-28 17:37:06','2023-02-28 17:37:06'),(1433,7525,40875,16668,3,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3990.00,NULL,NULL,1,'2023-02-27 17:02:24','2023-02-28 17:36:59','2023-02-28 17:36:59'),(1434,7525,40875,16668,3,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',25318.08,NULL,NULL,1,'2023-02-27 17:02:24','2023-02-28 17:36:52','2023-02-28 17:36:52'),(1435,7525,40875,16668,3,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',11252.48,NULL,NULL,1,'2023-02-27 17:02:24','2023-02-28 17:36:43','2023-02-28 17:36:43'),(1436,7525,40875,16668,3,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',16900.00,NULL,NULL,1,'2023-02-27 17:02:25','2023-02-28 17:36:35','2023-02-28 17:36:35'),(1437,7525,40875,16668,3,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',589500.00,NULL,NULL,1,'2023-02-27 17:02:25','2023-02-28 17:36:29','2023-02-28 17:36:29'),(1438,7525,40875,16668,3,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',68500.00,NULL,NULL,1,'2023-02-27 17:02:25','2023-02-28 17:36:23','2023-02-28 17:36:23');
INSERT INTO `balance_libro` VALUES (1439,7525,40875,16668,3,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1805040.00,NULL,NULL,1,'2023-02-27 17:02:25','2023-02-28 17:36:17','2023-02-28 17:36:17'),(1440,7525,40875,16668,3,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9600.00,NULL,NULL,1,'2023-02-27 17:02:25','2023-02-28 17:36:07','2023-02-28 17:36:07'),(1441,7525,40875,16668,3,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9600.00,NULL,NULL,1,'2023-02-27 17:02:25','2023-02-28 17:36:01','2023-02-28 17:36:01'),(1442,7525,40875,16668,3,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2600.00,NULL,NULL,1,'2023-02-27 17:02:25','2023-02-28 17:35:54','2023-02-28 17:35:54'),(1443,7525,40875,16668,2,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',25318.08,NULL,NULL,1,'2023-02-27 17:02:34','2023-02-27 17:02:34',NULL),(1444,7525,40875,16668,2,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3990.00,NULL,NULL,1,'2023-02-27 17:02:34','2023-02-27 17:02:34',NULL),(1445,7525,40875,16668,2,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',25318.08,NULL,NULL,1,'2023-02-27 17:02:34','2023-02-27 17:02:34',NULL),(1446,7525,40875,16668,2,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',11252.48,NULL,NULL,1,'2023-02-27 17:02:34','2023-02-27 17:02:34',NULL),(1447,7525,40875,16668,2,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',16900.00,NULL,NULL,1,'2023-02-27 17:02:35','2023-02-27 17:02:35',NULL),(1448,7525,40875,16668,2,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',589500.00,NULL,NULL,1,'2023-02-27 17:02:35','2023-02-27 17:18:41','2023-02-27 17:18:41'),(1449,7525,40875,16668,2,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',68500.00,NULL,NULL,1,'2023-02-27 17:02:35','2023-02-27 17:19:14','2023-02-27 17:19:14'),(1450,7525,40875,16668,2,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1805040.00,NULL,NULL,1,'2023-02-27 17:02:35','2023-02-27 18:47:50','2023-02-27 18:47:50'),(1451,7525,40875,16668,2,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9600.00,NULL,NULL,1,'2023-02-27 17:02:35','2023-02-27 17:13:44','2023-02-27 17:13:44'),(1452,7525,40875,16668,2,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9600.00,NULL,NULL,1,'2023-02-27 17:02:35','2023-02-27 17:13:08','2023-02-27 17:13:08'),(1453,7525,40875,16668,2,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2600.00,NULL,NULL,1,'2023-02-27 17:02:35','2023-02-27 17:12:24','2023-02-27 17:12:24'),(1454,7525,40875,16668,2,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2600.00,NULL,NULL,1,'2023-02-27 17:12:24','2023-02-27 17:12:41','2023-02-27 17:12:41'),(1455,7525,40875,16668,2,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2600.00,NULL,NULL,1,'2023-02-27 17:12:41','2023-02-27 17:12:41',NULL),(1456,7525,40875,16668,2,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9599.99,NULL,NULL,1,'2023-02-27 17:13:08','2023-02-27 17:13:08',NULL),(1457,7525,40875,16668,2,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9599.99,NULL,NULL,1,'2023-02-27 17:13:44','2023-02-27 17:13:44',NULL),(1458,7525,40875,16668,2,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',589500.00,NULL,NULL,1,'2023-02-27 17:18:41','2023-02-27 17:18:41',NULL);
INSERT INTO `balance_libro` VALUES (1459,7525,40875,16668,2,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',68500.00,NULL,NULL,1,'2023-02-27 17:19:14','2023-02-27 17:19:14',NULL),(1460,7525,40875,16668,2,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1805039.76,NULL,NULL,1,'2023-02-27 18:47:50','2023-02-27 18:47:50',NULL),(1461,7525,40856,15156,3,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',8850.44,NULL,NULL,1,'2023-02-28 16:00:51','2023-02-28 16:00:51',NULL),(1462,7525,40856,15156,3,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',53564.28,NULL,NULL,1,'2023-02-28 16:01:28','2023-02-28 16:01:28',NULL),(1463,7525,40856,15156,3,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',25000.00,NULL,NULL,1,'2023-02-28 16:02:36','2023-02-28 16:02:36',NULL),(1464,7525,40856,15156,3,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',25000.00,NULL,NULL,1,'2023-02-28 16:03:17','2023-02-28 16:03:17',NULL),(1465,7525,40856,15156,3,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',6500.00,NULL,NULL,1,'2023-02-28 16:03:37','2023-02-28 16:03:37',NULL),(1466,7525,40856,15156,3,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',7000.00,NULL,NULL,1,'2023-02-28 16:03:54','2023-02-28 16:03:54',NULL),(1467,7525,40856,15156,3,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',10560.00,NULL,NULL,1,'2023-02-28 16:04:20','2023-02-28 16:04:20',NULL),(1468,7525,40856,15156,3,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',25000.00,NULL,NULL,1,'2023-02-28 16:04:46','2023-02-28 16:04:46',NULL),(1469,7525,40856,15156,3,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',27980.83,NULL,NULL,1,'2023-02-28 16:05:09','2023-02-28 16:05:09',NULL),(1470,7525,40875,16668,3,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2760.00,NULL,NULL,1,'2023-02-28 17:37:52','2023-02-28 17:37:52',NULL),(1471,7525,40875,16668,3,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',389.50,NULL,NULL,1,'2023-02-28 17:37:52','2023-02-28 18:34:53','2023-02-28 18:34:53'),(1472,7525,40875,16668,3,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',163.00,NULL,NULL,1,'2023-02-28 17:37:52','2023-02-28 18:35:08','2023-02-28 18:35:08'),(1473,7525,40875,16668,3,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',21495.00,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 18:34:24','2023-02-28 18:34:24'),(1474,7525,40875,16668,3,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',21495.00,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 17:37:53',NULL),(1475,7525,40875,16668,3,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7157.20,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 18:36:46','2023-02-28 18:36:46'),(1476,7525,40875,16668,3,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',14755.18,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 17:37:53',NULL),(1477,7525,40875,16668,3,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',30500.00,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 18:34:03','2023-02-28 18:34:03'),(1478,7525,40875,16668,3,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',30500.00,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 17:37:53',NULL);
INSERT INTO `balance_libro` VALUES (1479,7525,40875,16668,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2280.00,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 18:32:36','2023-02-28 18:32:36'),(1480,7525,40875,16668,3,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2280.00,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 18:33:15','2023-02-28 18:33:15'),(1481,7525,40875,16668,3,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',384800.02,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 18:30:57','2023-02-28 18:30:57'),(1482,7525,40875,16668,3,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3358.45,NULL,NULL,1,'2023-02-28 17:37:53','2023-03-01 09:10:02','2023-03-01 09:10:02'),(1483,7525,40875,16668,3,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',5500.00,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 18:27:20','2023-02-28 18:27:20'),(1484,7525,40875,16668,3,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',10150.00,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 17:37:53',NULL),(1485,7525,40875,16668,3,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',89999.00,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 17:37:53',NULL),(1486,7525,40875,16668,3,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3540.00,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 17:37:53',NULL),(1487,7525,40875,16668,3,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9500.24,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 17:37:53',NULL),(1488,7525,40875,16668,3,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9454.95,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 18:25:03','2023-02-28 18:25:03'),(1489,7525,40875,16668,3,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',95.00,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 18:20:42','2023-02-28 18:20:42'),(1490,7525,40875,16668,3,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',3801.20,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 18:19:52','2023-02-28 18:19:52'),(1491,7525,40875,16668,3,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',7182.62,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 17:37:53',NULL),(1492,7525,40875,16668,3,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',50329.42,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 18:18:25','2023-02-28 18:18:25'),(1493,7525,40875,16668,3,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',27445.50,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 18:17:10','2023-02-28 18:17:10'),(1494,7525,40875,16668,3,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',11730.10,NULL,NULL,1,'2023-02-28 17:37:53','2023-02-28 18:32:01','2023-02-28 18:32:01'),(1495,7525,40875,16668,3,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',17850.00,NULL,NULL,1,'2023-02-28 17:37:54','2023-02-28 18:15:49','2023-02-28 18:15:49'),(1496,7525,40875,16668,3,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',2159.99,NULL,NULL,1,'2023-02-28 17:37:54','2023-02-28 18:00:23','2023-02-28 18:00:23'),(1497,7525,40875,16668,3,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',255218.04,NULL,NULL,1,'2023-02-28 17:37:54','2023-02-28 18:15:29','2023-02-28 18:15:29');
INSERT INTO `balance_libro` VALUES (1498,7525,40875,16668,3,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',173800.00,NULL,NULL,1,'2023-02-28 17:37:54','2023-02-28 18:13:53','2023-02-28 18:13:53'),(1499,7525,40875,16668,3,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3120.00,NULL,NULL,1,'2023-02-28 17:37:54','2023-02-28 17:37:54',NULL),(1500,7525,40875,16668,3,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',12460.00,NULL,NULL,1,'2023-02-28 17:37:54','2023-02-28 17:37:54',NULL),(1501,7525,40875,16668,3,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',32700.00,NULL,NULL,1,'2023-02-28 17:37:54','2023-02-28 17:37:54',NULL),(1502,7525,40875,16668,3,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',16420.00,NULL,NULL,1,'2023-02-28 17:37:54','2023-02-28 17:37:54',NULL),(1503,7525,40875,16668,3,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',21090.00,NULL,NULL,1,'2023-02-28 17:37:54','2023-02-28 17:56:08','2023-02-28 17:56:08'),(1504,7525,40875,16668,3,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',4800.00,NULL,NULL,1,'2023-02-28 17:37:54','2023-02-28 17:55:01','2023-02-28 17:55:01'),(1505,7525,40875,16668,3,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2799.99,NULL,NULL,1,'2023-02-28 17:37:54','2023-02-28 17:55:37','2023-02-28 17:55:37'),(1506,7525,40875,16668,3,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',6250.00,NULL,NULL,1,'2023-02-28 17:37:54','2023-02-28 17:37:54',NULL),(1507,7525,40875,16668,3,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',12650.01,NULL,NULL,1,'2023-02-28 17:37:54','2023-02-28 17:37:54',NULL),(1508,7525,40875,16668,3,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',21090.00,NULL,NULL,1,'2023-02-28 17:56:08','2023-02-28 17:56:08',NULL),(1509,7525,40875,16668,3,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',173800.01,NULL,NULL,1,'2023-02-28 18:13:53','2023-02-28 18:13:53',NULL),(1510,7525,40875,16668,3,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',255218.04,NULL,NULL,1,'2023-02-28 18:15:29','2023-03-01 09:06:14','2023-03-01 09:06:14'),(1511,7525,40875,16668,3,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',27445.50,NULL,NULL,1,'2023-02-28 18:17:10','2023-02-28 18:17:10',NULL),(1512,7525,40875,16668,3,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',50329.42,NULL,NULL,1,'2023-02-28 18:18:25','2023-02-28 18:18:25',NULL),(1513,7525,40875,16668,3,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',3801.21,NULL,NULL,1,'2023-02-28 18:19:52','2023-03-01 09:02:57','2023-03-01 09:02:57'),(1514,7525,40875,16668,3,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9454.94,NULL,NULL,1,'2023-02-28 18:25:03','2023-02-28 18:25:03',NULL),(1515,7525,40875,16668,3,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',5500.00,NULL,NULL,1,'2023-02-28 18:27:20','2023-02-28 18:27:20',NULL),(1516,7525,40875,16668,3,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',384799.98,NULL,NULL,1,'2023-02-28 18:30:57','2023-02-28 18:30:57',NULL),(1517,7525,40875,16668,3,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',11730.10,NULL,NULL,1,'2023-02-28 18:32:01','2023-03-01 08:57:42','2023-03-01 08:57:42');
INSERT INTO `balance_libro` VALUES (1518,7525,40875,16668,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2280.00,NULL,NULL,1,'2023-02-28 18:32:36','2023-02-28 18:32:36',NULL),(1519,7525,40875,16668,3,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',9791.29,NULL,NULL,1,'2023-02-28 18:40:39','2023-02-28 18:40:39',NULL),(1520,7525,40875,16668,3,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',112507.25,NULL,NULL,1,'2023-02-28 18:41:48','2023-02-28 18:41:48',NULL),(1521,7525,40875,16668,3,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',11501.40,NULL,NULL,1,'2023-02-28 18:45:00','2023-02-28 18:45:00',NULL),(1522,7525,40875,16668,3,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',17849.99,NULL,NULL,1,'2023-02-28 18:50:33','2023-02-28 18:50:33',NULL),(1523,7525,40875,16668,3,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',8701.67,NULL,NULL,1,'2023-02-28 19:11:16','2023-02-28 19:11:16',NULL),(1524,7525,40875,16668,3,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',11730.10,NULL,NULL,1,'2023-03-01 08:57:42','2023-03-01 09:00:34','2023-03-01 09:00:34'),(1525,7525,40875,16668,3,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',11730.10,NULL,NULL,1,'2023-03-01 09:00:34','2023-03-01 09:00:34',NULL),(1526,7525,40875,16668,3,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',3801.21,NULL,NULL,1,'2023-03-01 09:02:57','2023-03-01 09:02:57',NULL),(1527,7525,40875,16668,3,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',255218.04,NULL,NULL,1,'2023-03-01 09:06:14','2023-03-01 09:06:14',NULL),(1528,7525,40875,16668,3,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3358.45,NULL,NULL,1,'2023-03-01 09:10:02','2023-03-01 09:10:02',NULL),(1529,7525,41011,25749,3,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',24453.65,NULL,NULL,1,'2023-03-01 09:41:21','2023-03-01 09:41:21',NULL),(1530,7525,41011,25749,3,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5795.55,NULL,NULL,1,'2023-03-01 09:41:21','2023-03-01 13:23:42','2023-03-01 13:23:42'),(1531,7525,41011,25749,3,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',21669.05,NULL,NULL,1,'2023-03-01 09:41:21','2023-03-01 09:41:21',NULL),(1532,7525,41011,25749,3,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',29835.00,NULL,NULL,1,'2023-03-01 09:41:21','2023-03-01 13:22:15','2023-03-01 13:22:15'),(1533,7525,41011,25749,3,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',29542.26,NULL,NULL,1,'2023-03-01 09:41:21','2023-03-01 09:42:44','2023-03-01 09:42:44'),(1534,7525,41011,25749,3,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',8048.71,NULL,NULL,1,'2023-03-01 09:41:22','2023-03-01 13:21:30','2023-03-01 13:21:30'),(1535,7525,41011,25749,3,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',22100.00,NULL,NULL,1,'2023-03-01 09:41:22','2023-03-01 13:20:28','2023-03-01 13:20:28'),(1536,7525,41011,25749,3,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',28730.00,NULL,NULL,1,'2023-03-01 09:41:22','2023-03-01 13:20:00','2023-03-01 13:20:00'),(1537,7525,41011,25749,3,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',90168.00,NULL,NULL,1,'2023-03-01 09:41:22','2023-03-01 13:19:39','2023-03-01 13:19:39');
INSERT INTO `balance_libro` VALUES (1538,7525,41011,25749,3,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',8604.93,NULL,NULL,1,'2023-03-01 09:41:23','2023-03-01 13:18:52','2023-03-01 13:18:52'),(1539,7525,41011,25749,3,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',6500.00,NULL,NULL,1,'2023-03-01 09:41:23','2023-03-01 13:12:50','2023-03-01 13:12:50'),(1540,7525,41011,25749,3,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',21823.75,NULL,NULL,1,'2023-03-01 09:41:23','2023-03-01 13:12:30','2023-03-01 13:12:30'),(1541,7525,41011,25749,3,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',23017.15,NULL,NULL,1,'2023-03-01 09:41:23','2023-03-01 09:41:23',NULL),(1542,7525,41011,25749,3,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',5150.62,NULL,NULL,1,'2023-03-01 09:41:24','2023-03-01 13:09:43','2023-03-01 13:09:43'),(1543,7525,41011,25749,3,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',28730.00,NULL,NULL,1,'2023-03-01 09:41:24','2023-03-01 09:41:24',NULL),(1544,7525,41011,25749,3,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',20829.25,NULL,NULL,1,'2023-03-01 09:41:24','2023-03-01 13:02:50','2023-03-01 13:02:50'),(1545,7525,41011,25749,3,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',27127.75,NULL,NULL,1,'2023-03-01 09:41:24','2023-03-01 13:02:29','2023-03-01 13:02:29'),(1546,7525,41011,25749,3,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5472.18,NULL,NULL,1,'2023-03-01 09:41:24','2023-03-01 13:01:47','2023-03-01 13:01:47'),(1547,7525,41011,25749,3,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',19890.00,NULL,NULL,1,'2023-03-01 09:41:25','2023-03-01 12:49:57','2023-03-01 12:49:57'),(1548,7525,41011,25749,3,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',26333.00,NULL,NULL,1,'2023-03-01 09:41:25','2023-03-01 12:49:44','2023-03-01 12:49:44'),(1549,7525,41011,25749,3,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',16586.05,NULL,NULL,1,'2023-03-01 09:41:25','2023-03-01 12:49:16','2023-03-01 12:49:16'),(1550,7525,41011,25749,3,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',8070.77,NULL,NULL,1,'2023-03-01 09:41:25','2023-03-01 12:48:54','2023-03-01 12:48:54'),(1551,7525,41011,25749,3,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',7082.63,NULL,NULL,1,'2023-03-01 09:41:25','2023-03-01 12:47:46','2023-03-01 12:47:46'),(1552,7525,41011,25749,3,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',27625.00,NULL,NULL,1,'2023-03-01 09:41:26','2023-03-01 12:46:26','2023-03-01 12:46:26'),(1553,7525,41011,25749,3,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',28917.85,NULL,NULL,1,'2023-03-01 09:41:26','2023-03-01 12:46:08','2023-03-01 12:46:08'),(1554,7525,41011,25749,3,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',26520.00,NULL,NULL,1,'2023-03-01 09:41:26','2023-03-01 09:41:26',NULL),(1555,7525,41011,25749,3,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',6673.71,NULL,NULL,1,'2023-03-01 09:41:26','2023-03-01 10:02:17','2023-03-01 10:02:17'),(1556,7525,41011,25749,3,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',8232.25,NULL,NULL,1,'2023-03-01 09:41:27','2023-03-01 10:00:47','2023-03-01 10:00:47');
INSERT INTO `balance_libro` VALUES (1557,7525,41011,25749,3,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',24022.70,NULL,NULL,1,'2023-03-01 09:41:27','2023-03-01 09:56:57','2023-03-01 09:56:57'),(1558,7525,41011,25749,3,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',28730.00,NULL,NULL,1,'2023-03-01 09:41:27','2023-03-01 09:41:27',NULL),(1559,7525,41011,25749,3,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',25787.46,NULL,NULL,1,'2023-03-01 09:41:27','2023-03-01 09:42:18','2023-03-01 09:42:18'),(1560,7525,41011,25749,3,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9079.02,NULL,NULL,1,'2023-03-01 09:41:28','2023-03-01 09:55:02','2023-03-01 09:55:02'),(1561,7525,41011,25749,3,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',80000.00,NULL,NULL,1,'2023-03-01 09:56:31','2023-03-01 09:56:31',NULL),(1562,7525,41011,25749,3,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',6673.71,NULL,NULL,1,'2023-03-01 10:02:17','2023-03-01 13:29:09','2023-03-01 13:29:09'),(1563,7525,41011,25749,3,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',28917.85,NULL,NULL,1,'2023-03-01 12:46:08','2023-03-01 12:46:08',NULL),(1564,7525,41011,25749,3,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',27625.00,NULL,NULL,1,'2023-03-01 12:46:26','2023-03-01 12:49:30','2023-03-01 12:49:30'),(1565,7525,41011,25749,3,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',7082.65,NULL,NULL,1,'2023-03-01 12:47:46','2023-03-01 12:47:46',NULL),(1566,7525,41011,25749,3,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',8070.77,NULL,NULL,1,'2023-03-01 12:48:54','2023-03-01 12:48:54',NULL),(1567,7525,41011,25749,3,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',16586.05,NULL,NULL,1,'2023-03-01 12:49:16','2023-03-01 12:49:16',NULL),(1568,7525,41011,25749,3,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',27625.00,NULL,NULL,1,'2023-03-01 12:49:30','2023-03-01 12:49:30',NULL),(1569,7525,41011,25749,3,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',26243.75,NULL,NULL,1,'2023-03-01 12:49:44','2023-03-01 12:49:44',NULL),(1570,7525,41011,25749,3,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',19890.00,NULL,NULL,1,'2023-03-01 12:49:57','2023-03-01 12:49:57',NULL),(1571,7525,41011,25749,3,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5472.18,NULL,NULL,1,'2023-03-01 13:01:47','2023-03-01 13:01:47',NULL),(1572,7525,41011,25749,3,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',27127.75,NULL,NULL,1,'2023-03-01 13:02:29','2023-03-01 13:02:29',NULL),(1573,7525,41011,25749,3,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',20829.25,NULL,NULL,1,'2023-03-01 13:02:50','2023-03-01 13:02:50',NULL),(1574,7525,41011,25749,3,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',5150.61,NULL,NULL,1,'2023-03-01 13:09:43','2023-03-01 13:09:43',NULL),(1575,7525,41011,25749,3,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',21823.75,NULL,NULL,1,'2023-03-01 13:12:30','2023-03-01 13:12:30',NULL),(1576,7525,41011,25749,3,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',6500.00,NULL,NULL,1,'2023-03-01 13:12:50','2023-03-01 13:12:50',NULL);
INSERT INTO `balance_libro` VALUES (1577,7525,41011,25749,3,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',7750.19,NULL,NULL,1,'2023-03-01 13:18:52','2023-03-01 13:27:05','2023-03-01 13:27:05'),(1578,7525,41011,25749,3,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',90168.00,NULL,NULL,1,'2023-03-01 13:19:39','2023-03-01 13:19:39',NULL),(1579,7525,41011,25749,3,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',28730.00,NULL,NULL,1,'2023-03-01 13:20:00','2023-03-01 13:21:54','2023-03-01 13:21:54'),(1580,7525,41011,25749,3,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',22100.00,NULL,NULL,1,'2023-03-01 13:20:28','2023-03-01 13:20:28',NULL),(1581,7525,41011,25749,3,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',8048.71,NULL,NULL,1,'2023-03-01 13:21:30','2023-03-01 13:21:30',NULL),(1582,7525,41011,25749,3,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',28730.00,NULL,NULL,1,'2023-03-01 13:21:54','2023-03-01 13:21:54',NULL),(1583,7525,41011,25749,3,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',29835.00,NULL,NULL,1,'2023-03-01 13:22:15','2023-03-01 13:22:15',NULL),(1584,7525,41011,25749,3,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5795.55,NULL,NULL,1,'2023-03-01 13:23:42','2023-03-01 13:23:42',NULL),(1585,7525,41011,25749,3,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',8604.93,NULL,NULL,1,'2023-03-01 13:27:05','2023-03-01 13:27:05',NULL),(1586,7525,41011,25749,3,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',6864.57,NULL,NULL,1,'2023-03-01 13:29:09','2023-03-01 13:29:09',NULL),(1587,7525,40906,18180,3,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',6000.00,NULL,NULL,1,'2023-03-01 16:41:39','2023-03-01 16:41:39',NULL),(1588,7525,40917,19695,3,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',0.99,NULL,NULL,1,'2023-03-05 14:53:41','2023-03-05 15:10:39','2023-03-05 15:10:39'),(1589,7525,40917,19695,3,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',125844.10,NULL,NULL,1,'2023-03-05 14:53:41','2023-03-05 15:10:08','2023-03-05 15:10:08'),(1590,7525,40917,19695,3,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',17100.00,NULL,NULL,1,'2023-03-05 14:53:41','2023-03-05 15:09:36','2023-03-05 15:09:36'),(1591,7525,40917,19695,3,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',227120.17,NULL,NULL,1,'2023-03-05 14:53:41','2023-03-05 14:53:41',NULL),(1592,7525,40917,19695,3,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',6000.00,NULL,NULL,1,'2023-03-05 14:53:41','2023-03-05 15:09:17','2023-03-05 15:09:17'),(1593,7525,40917,19695,3,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',165129.59,NULL,NULL,1,'2023-03-05 14:53:41','2023-03-05 14:53:41',NULL),(1594,7525,40917,19695,3,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',20351.99,NULL,NULL,1,'2023-03-05 14:53:42','2023-03-05 14:53:42',NULL),(1595,7525,40917,19695,3,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',663.17,NULL,NULL,1,'2023-03-05 14:53:42','2023-03-05 15:08:37','2023-03-05 15:08:37'),(1596,7525,40917,19695,3,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',63200.24,NULL,NULL,1,'2023-03-05 14:53:42','2023-03-05 14:53:42',NULL);
INSERT INTO `balance_libro` VALUES (1597,7525,40917,19695,3,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',136.00,NULL,NULL,1,'2023-03-05 14:53:42','2023-03-05 15:05:46','2023-03-05 15:05:46'),(1598,7525,40917,19695,3,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',19027.00,NULL,NULL,1,'2023-03-05 14:53:42','2023-03-05 15:09:00','2023-03-05 15:09:00'),(1599,7525,40917,19695,3,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',141959.79,NULL,NULL,1,'2023-03-05 14:53:42','2023-03-05 14:53:42',NULL),(1600,7525,40917,19695,3,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',275750.13,NULL,NULL,1,'2023-03-05 14:53:42','2023-03-05 14:53:42',NULL),(1601,7525,40917,19695,3,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',320.00,NULL,NULL,1,'2023-03-05 14:53:42','2023-03-05 15:03:44','2023-03-05 15:03:44'),(1602,7525,40917,19695,2,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',201000.96,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:12','2023-03-05 15:02:12'),(1603,7525,40917,19695,2,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',9700.02,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:12','2023-03-05 15:02:12'),(1604,7525,40917,19695,2,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',26450.24,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:12','2023-03-05 15:02:12'),(1605,7525,40917,19695,2,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',6040.01,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:12','2023-03-05 15:02:12'),(1606,7525,40917,19695,2,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',102500.79,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:12','2023-03-05 15:02:12'),(1607,7525,40917,19695,2,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',4620.01,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:12','2023-03-05 15:02:12'),(1608,7525,40917,19695,2,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',19160.07,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:12','2023-03-05 15:02:12'),(1609,7525,40917,19695,2,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',172500.99,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:12','2023-03-05 15:02:12'),(1610,7525,40917,19695,2,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',80800.29,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:12','2023-03-05 15:02:12'),(1611,7525,40917,19695,2,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',40500.16,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:12','2023-03-05 15:02:12'),(1612,7525,40917,19695,2,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',207501.08,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:12','2023-03-05 15:02:12'),(1613,7525,40917,19695,2,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',44400.15,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:12','2023-03-05 15:02:12'),(1614,7525,40917,19695,2,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',169400.61,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:12','2023-03-05 15:02:12'),(1615,7525,40917,19695,2,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',172500.99,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:12','2023-03-05 15:02:12');
INSERT INTO `balance_libro` VALUES (1616,7525,40917,19695,2,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',85890.33,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:12','2023-03-05 15:02:12'),(1617,7525,40917,19695,2,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',124300.58,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:12','2023-03-05 15:02:12'),(1618,7525,40917,19695,2,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',4620.01,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:12','2023-03-05 15:02:12'),(1619,7525,40917,19695,2,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',24700.10,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:13','2023-03-05 15:02:13'),(1620,7525,40917,19695,2,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',207300.77,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:13','2023-03-05 15:02:13'),(1621,7525,40917,19695,2,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',85500.78,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:13','2023-03-05 15:02:13'),(1622,7525,40917,19695,2,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',210000.94,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:13','2023-03-05 15:02:13'),(1623,7525,40917,19695,2,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',120000.66,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:02:13','2023-03-05 15:02:13'),(1624,7525,40917,19695,2,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',60000.00,NULL,NULL,1,'2023-03-05 14:54:35','2023-03-05 15:00:53','2023-03-05 15:00:53'),(1625,7525,40917,19695,2,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',201000.96,NULL,NULL,1,'2023-03-05 15:03:00','2023-03-05 15:03:00',NULL),(1626,7525,40917,19695,2,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',9700.02,NULL,NULL,1,'2023-03-05 15:03:00','2023-03-05 15:03:00',NULL),(1627,7525,40917,19695,2,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',26450.24,NULL,NULL,1,'2023-03-05 15:03:00','2023-03-05 15:03:00',NULL),(1628,7525,40917,19695,2,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',6040.01,NULL,NULL,1,'2023-03-05 15:03:00','2023-03-05 15:03:00',NULL),(1629,7525,40917,19695,2,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',102500.79,NULL,NULL,1,'2023-03-05 15:03:00','2023-03-05 15:03:00',NULL),(1630,7525,40917,19695,2,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',4620.01,NULL,NULL,1,'2023-03-05 15:03:00','2023-03-05 15:03:00',NULL),(1631,7525,40917,19695,2,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',19160.07,NULL,NULL,1,'2023-03-05 15:03:00','2023-03-05 15:03:00',NULL),(1632,7525,40917,19695,2,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',172500.99,NULL,NULL,1,'2023-03-05 15:03:00','2023-03-05 15:03:00',NULL),(1633,7525,40917,19695,2,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',80800.29,NULL,NULL,1,'2023-03-05 15:03:00','2023-03-05 15:03:00',NULL),(1634,7525,40917,19695,2,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',40500.16,NULL,NULL,1,'2023-03-05 15:03:00','2023-03-05 15:03:00',NULL),(1635,7525,40917,19695,2,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',207501.08,NULL,NULL,1,'2023-03-05 15:03:00','2023-03-05 15:03:00',NULL);
INSERT INTO `balance_libro` VALUES (1636,7525,40917,19695,2,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',44400.15,NULL,NULL,1,'2023-03-05 15:03:00','2023-03-05 15:03:00',NULL),(1637,7525,40917,19695,2,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',169400.61,NULL,NULL,1,'2023-03-05 15:03:00','2023-03-05 15:03:00',NULL),(1638,7525,40917,19695,2,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',172500.99,NULL,NULL,1,'2023-03-05 15:03:00','2023-03-05 15:03:00',NULL),(1639,7525,40917,19695,2,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',85890.33,NULL,NULL,1,'2023-03-05 15:03:00','2023-03-05 15:03:00',NULL),(1640,7525,40917,19695,2,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',124300.58,NULL,NULL,1,'2023-03-05 15:03:01','2023-03-05 15:03:01',NULL),(1641,7525,40917,19695,2,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',4620.01,NULL,NULL,1,'2023-03-05 15:03:01','2023-03-05 15:03:01',NULL),(1642,7525,40917,19695,2,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',24700.10,NULL,NULL,1,'2023-03-05 15:03:01','2023-03-05 15:03:01',NULL),(1643,7525,40917,19695,2,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',207300.77,NULL,NULL,1,'2023-03-05 15:03:01','2023-03-05 15:03:01',NULL),(1644,7525,40917,19695,2,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',85500.78,NULL,NULL,1,'2023-03-05 15:03:01','2023-03-05 15:03:01',NULL),(1645,7525,40917,19695,2,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',210000.94,NULL,NULL,1,'2023-03-05 15:03:01','2023-03-05 15:03:01',NULL),(1646,7525,40917,19695,2,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',120000.66,NULL,NULL,1,'2023-03-05 15:03:01','2023-03-05 15:03:01',NULL),(1647,7525,40917,19695,2,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',60000.00,NULL,NULL,1,'2023-03-05 15:03:01','2023-03-05 15:03:01',NULL),(1648,7525,40917,19695,3,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',663.17,NULL,NULL,1,'2023-03-05 15:08:37','2023-03-05 15:08:37',NULL),(1649,7525,40917,19695,3,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',19027.00,NULL,NULL,1,'2023-03-05 15:09:00','2023-03-05 15:09:00',NULL),(1650,7525,40917,19695,3,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',6000.00,NULL,NULL,1,'2023-03-05 15:09:17','2023-03-05 15:09:17',NULL),(1651,7525,40917,19695,3,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',0.99,NULL,NULL,1,'2023-03-05 15:10:39','2023-03-05 15:10:39',NULL),(1652,7525,40917,19695,3,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',60136.24,NULL,NULL,1,'2023-03-05 15:14:59','2023-03-05 15:14:59',NULL),(1653,7525,40917,19695,3,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',192435.97,NULL,NULL,1,'2023-03-05 15:15:46','2023-03-05 15:15:46',NULL),(1654,7525,40917,19695,3,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',138313.35,NULL,NULL,1,'2023-03-05 15:17:15','2023-03-05 15:17:15',NULL),(1655,7525,40917,19695,3,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',210476.84,NULL,NULL,1,'2023-03-05 15:18:44','2023-03-05 15:18:44',NULL),(1656,7525,40917,19695,3,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',159361.03,NULL,NULL,1,'2023-03-05 15:39:11','2023-03-05 15:39:11',NULL);
INSERT INTO `balance_libro` VALUES (1657,7525,40917,19695,3,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',175089.38,NULL,NULL,1,'2023-03-05 16:08:47','2023-03-05 16:08:47',NULL),(1658,7525,40917,19695,3,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',101673.84,NULL,NULL,1,'2023-03-05 16:15:27','2023-03-05 16:15:27',NULL),(1659,7525,40917,19695,3,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',185065.67,NULL,NULL,1,'2023-03-05 16:16:25','2023-03-05 16:16:25',NULL),(1660,7525,40917,19695,7,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1492.79,NULL,NULL,1,'2023-03-05 16:30:39','2023-03-05 16:39:54','2023-03-05 16:39:54'),(1661,7525,40917,19695,7,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1103.34,NULL,NULL,1,'2023-03-05 16:39:54','2023-03-05 16:39:54',NULL),(1662,7525,40915,22722,2,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',188542.20,NULL,NULL,1,'2023-03-05 17:07:13','2023-03-05 17:07:13',NULL),(1663,7525,40915,22722,2,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',97368.70,NULL,NULL,1,'2023-03-05 17:07:13','2023-03-05 17:07:13',NULL),(1664,7525,40915,22722,3,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6899.99,NULL,NULL,1,'2023-03-05 17:07:22','2023-03-05 17:13:28','2023-03-05 17:13:28'),(1665,7525,40915,22722,3,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',6000.00,NULL,NULL,1,'2023-03-05 17:07:22','2023-03-05 17:13:08','2023-03-05 17:13:08'),(1666,7525,40915,22722,3,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8317.83,NULL,NULL,1,'2023-03-05 17:07:22','2023-03-05 17:12:48','2023-03-05 17:12:48'),(1667,7525,40915,22722,3,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',16329.56,NULL,NULL,1,'2023-03-05 17:07:22','2023-03-05 17:12:07','2023-03-05 17:12:07'),(1668,7525,40915,22722,3,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',5105.56,NULL,NULL,1,'2023-03-05 17:07:22','2023-03-05 17:11:41','2023-03-05 17:11:41'),(1669,7525,40915,22722,3,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',5105.56,NULL,NULL,1,'2023-03-05 17:11:41','2023-03-05 17:11:41',NULL),(1670,7525,40915,22722,3,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',16329.56,NULL,NULL,1,'2023-03-05 17:12:07','2023-03-05 17:12:07',NULL),(1671,7525,40915,22722,3,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8317.83,NULL,NULL,1,'2023-03-05 17:12:48','2023-03-05 17:12:48',NULL),(1672,7525,40915,22722,3,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',6000.00,NULL,NULL,1,'2023-03-05 17:13:08','2023-03-05 17:13:08',NULL),(1673,7525,40915,22722,3,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6899.99,NULL,NULL,1,'2023-03-05 17:13:28','2023-03-05 17:13:28',NULL),(1674,7525,40915,22722,3,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',6500.66,NULL,NULL,1,'2023-03-05 17:18:51','2023-03-05 17:18:51',NULL),(1675,7525,40915,22722,3,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',13001.31,NULL,NULL,1,'2023-03-05 17:19:25','2023-03-05 17:19:25',NULL),(1676,7525,40915,22722,3,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7700.80,NULL,NULL,1,'2023-03-05 17:20:02','2023-03-05 17:20:02',NULL);
INSERT INTO `balance_libro` VALUES (1677,7525,40915,22722,3,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5702.02,NULL,NULL,1,'2023-03-05 17:21:15','2023-03-05 17:21:15',NULL),(1678,7525,40915,22722,3,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',8200.04,NULL,NULL,1,'2023-03-05 17:25:23','2023-03-05 17:25:23',NULL),(1679,7525,40915,22722,3,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',13950.01,NULL,NULL,1,'2023-03-05 17:26:02','2023-03-05 17:26:02',NULL),(1680,7525,40915,22722,3,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',6200.70,NULL,NULL,1,'2023-03-05 17:27:25','2023-03-05 17:27:25',NULL),(1681,7525,40991,24237,2,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',135943.50,NULL,NULL,1,'2023-03-05 17:49:01','2023-03-05 17:50:33','2023-03-05 17:50:33'),(1682,7525,40991,24237,2,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',127655.00,NULL,NULL,1,'2023-03-05 17:49:01','2023-03-05 17:50:33','2023-03-05 17:50:33'),(1683,7525,40991,24237,2,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',340000.00,NULL,NULL,1,'2023-03-05 17:49:01','2023-03-05 17:50:33','2023-03-05 17:50:33'),(1684,7525,40991,24237,2,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',340000.00,NULL,NULL,1,'2023-03-05 17:49:01','2023-03-05 17:50:33','2023-03-05 17:50:33'),(1685,7525,40991,24237,2,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',30000.00,NULL,NULL,1,'2023-03-05 17:49:01','2023-03-05 17:50:07','2023-03-05 17:50:07'),(1686,7525,40991,24237,3,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',114700.74,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20'),(1687,7525,40991,24237,3,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',38757.22,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20'),(1688,7525,40991,24237,3,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1448.02,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20'),(1689,7525,40991,24237,3,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',17472.52,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20'),(1690,7525,40991,24237,3,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',699.00,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20'),(1691,7525,40991,24237,3,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',7000.00,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20'),(1692,7525,40991,24237,3,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',30872.74,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20'),(1693,7525,40991,24237,3,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',815.00,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20'),(1694,7525,40991,24237,3,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',95.00,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20'),(1695,7525,40991,24237,3,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',40787.59,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20');
INSERT INTO `balance_libro` VALUES (1696,7525,40991,24237,3,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',101585.55,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20'),(1697,7525,40991,24237,3,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',23569.00,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20'),(1698,7525,40991,24237,3,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2135.65,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20'),(1699,7525,40991,24237,3,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',17714.29,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20'),(1700,7525,40991,24237,3,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',15669.50,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20'),(1701,7525,40991,24237,3,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1250.00,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20'),(1702,7525,40991,24237,3,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1250.00,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20'),(1703,7525,40991,24237,3,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1250.00,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20'),(1704,7525,40991,24237,3,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',640.00,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:52:32','2023-03-05 17:52:32'),(1705,7525,40991,24237,3,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2029.93,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20'),(1706,7525,40991,24237,3,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',6650.00,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:52:25','2023-03-05 17:52:25'),(1707,7525,40991,24237,3,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',6650.00,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:52:17','2023-03-05 17:52:17'),(1708,7525,40991,24237,3,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',29018.28,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:20','2023-03-05 17:53:20'),(1709,7525,40991,24237,3,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',63000.00,NULL,NULL,1,'2023-03-05 17:49:12','2023-03-05 17:53:21','2023-03-05 17:53:21'),(1710,7525,40991,24237,2,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',135943.50,NULL,NULL,1,'2023-03-05 17:51:21','2023-03-05 17:51:21',NULL),(1711,7525,40991,24237,2,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',127655.00,NULL,NULL,1,'2023-03-05 17:51:21','2023-03-05 17:51:21',NULL),(1712,7525,40991,24237,2,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',340000.00,NULL,NULL,1,'2023-03-05 17:51:21','2023-03-05 17:51:21',NULL),(1713,7525,40991,24237,2,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',340000.00,NULL,NULL,1,'2023-03-05 17:51:21','2023-03-05 17:51:21',NULL),(1714,7525,40991,24237,2,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',30000.00,NULL,NULL,1,'2023-03-05 17:51:21','2023-03-05 17:51:21',NULL);
INSERT INTO `balance_libro` VALUES (1715,7525,40991,24237,3,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',114700.74,NULL,NULL,1,'2023-03-05 17:54:53','2023-03-05 17:54:53',NULL),(1716,7525,40991,24237,3,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',38757.22,NULL,NULL,1,'2023-03-05 17:54:53','2023-03-05 17:54:53',NULL),(1717,7525,40991,24237,3,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1448.02,NULL,NULL,1,'2023-03-05 17:54:53','2023-03-05 18:12:19','2023-03-05 18:12:19'),(1718,7525,40991,24237,3,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',17472.52,NULL,NULL,1,'2023-03-05 17:54:53','2023-03-05 18:11:18','2023-03-05 18:11:18'),(1719,7525,40991,24237,3,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',7000.00,NULL,NULL,1,'2023-03-05 17:54:53','2023-03-05 18:10:53','2023-03-05 18:10:53'),(1720,7525,40991,24237,3,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',30872.74,NULL,NULL,1,'2023-03-05 17:54:53','2023-03-05 17:54:53',NULL),(1721,7525,40991,24237,3,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',40787.59,NULL,NULL,1,'2023-03-05 17:54:53','2023-03-05 17:54:53',NULL),(1722,7525,40991,24237,3,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',101585.55,NULL,NULL,1,'2023-03-05 17:54:53','2023-03-05 17:54:53',NULL),(1723,7525,40991,24237,3,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2135.65,NULL,NULL,1,'2023-03-05 17:54:53','2023-03-05 17:54:53',NULL),(1724,7525,40991,24237,3,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',17714.29,NULL,NULL,1,'2023-03-05 17:54:53','2023-03-06 18:43:13','2023-03-06 18:43:13'),(1725,7525,40991,24237,3,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',15669.50,NULL,NULL,1,'2023-03-05 17:54:53','2023-03-06 18:43:00','2023-03-06 18:43:00'),(1726,7525,40991,24237,3,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2029.93,NULL,NULL,1,'2023-03-05 17:54:53','2023-03-05 18:08:05','2023-03-05 18:08:05'),(1727,7525,40991,24237,3,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',29018.28,NULL,NULL,1,'2023-03-05 17:54:53','2023-03-05 17:54:53',NULL),(1728,7525,40991,24237,3,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',63000.00,NULL,NULL,1,'2023-03-05 17:54:53','2023-03-06 18:42:16','2023-03-06 18:42:16'),(1729,7525,40991,24237,3,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',7000.00,NULL,NULL,1,'2023-03-05 18:10:53','2023-03-05 18:10:53',NULL),(1730,7525,40991,24237,3,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',15602.49,NULL,NULL,1,'2023-03-05 18:11:18','2023-03-05 18:11:42','2023-03-05 18:11:42'),(1731,7525,40991,24237,3,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',17472.53,NULL,NULL,1,'2023-03-05 18:11:42','2023-03-05 18:11:58','2023-03-05 18:11:58'),(1732,7525,40991,24237,3,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',17472.53,NULL,NULL,1,'2023-03-05 18:11:58','2023-03-05 18:11:58',NULL),(1733,7525,40991,24237,3,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1448.02,NULL,NULL,1,'2023-03-05 18:12:19','2023-03-05 18:12:19',NULL),(1734,7525,40991,24237,3,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2734.65,NULL,NULL,1,'2023-03-05 18:17:52','2023-03-05 18:17:52',NULL);
INSERT INTO `balance_libro` VALUES (1735,7525,40991,24237,3,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3741.83,NULL,NULL,1,'2023-03-05 18:19:26','2023-03-05 18:19:26',NULL),(1736,7525,40991,24237,3,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',11501.01,NULL,NULL,1,'2023-03-05 18:20:35','2023-03-05 18:20:35',NULL),(1737,7525,40991,24237,3,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4002.20,NULL,NULL,1,'2023-03-05 18:21:09','2023-03-05 18:21:09',NULL),(1738,7525,40991,24237,3,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',5974.72,NULL,NULL,1,'2023-03-05 18:22:24','2023-03-05 18:22:24',NULL),(1739,7525,40991,24237,7,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1723.37,NULL,NULL,1,'2023-03-05 18:54:28','2023-03-05 18:54:28',NULL),(1740,7525,40839,12129,2,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',302500.00,NULL,NULL,1,'2023-03-05 19:37:27','2023-03-05 19:37:27',NULL),(1741,7525,40839,12129,2,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',302500.00,NULL,NULL,1,'2023-03-05 19:37:27','2023-03-05 19:37:27',NULL),(1742,7525,40839,12129,2,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',302500.00,NULL,NULL,1,'2023-03-05 19:37:27','2023-03-05 19:37:27',NULL),(1743,7525,40839,12129,3,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5395.00,NULL,NULL,1,'2023-03-05 19:37:37','2023-03-05 19:37:37',NULL),(1744,7525,40839,12129,3,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',584.47,NULL,NULL,1,'2023-03-05 19:37:37','2023-03-05 19:37:37',NULL),(1745,7525,40839,12129,3,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',6000.00,NULL,NULL,1,'2023-03-05 19:37:37','2023-03-20 15:53:49','2023-03-20 15:53:49'),(1746,7525,40839,12129,3,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',9298.28,NULL,NULL,1,'2023-03-05 19:37:37','2023-03-20 15:53:30','2023-03-20 15:53:30'),(1747,7525,40839,12129,3,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',18818.18,NULL,NULL,1,'2023-03-05 19:37:37','2023-03-20 15:52:36','2023-03-20 15:52:36'),(1748,7525,40839,12129,3,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',3136.36,NULL,NULL,1,'2023-03-05 19:37:37','2023-03-05 19:37:37',NULL),(1749,7525,40839,12129,3,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',7140.00,NULL,NULL,1,'2023-03-05 19:37:37','2023-03-05 19:37:37',NULL),(1750,7525,40839,12129,3,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',567071.00,NULL,NULL,1,'2023-03-05 19:37:37','2023-03-20 15:50:53','2023-03-20 15:50:53'),(1751,7525,40839,12129,3,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',567071.00,NULL,NULL,1,'2023-03-05 19:37:37','2023-03-20 15:51:16','2023-03-20 15:51:16'),(1752,7525,40839,12129,3,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',11023.00,NULL,NULL,1,'2023-03-05 19:37:37','2023-03-20 15:49:34','2023-03-20 15:49:34'),(1753,7525,40839,12129,3,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',567071.00,NULL,NULL,1,'2023-03-05 19:37:37','2023-03-20 15:49:06','2023-03-20 15:49:06'),(1754,7525,40839,12129,3,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',42000.00,NULL,NULL,1,'2023-03-05 19:37:37','2023-03-20 15:47:42','2023-03-20 15:47:42');
INSERT INTO `balance_libro` VALUES (1755,7525,40839,12129,3,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',10519.02,NULL,NULL,1,'2023-03-05 19:37:37','2023-03-05 19:37:37',NULL),(1756,7525,40839,12129,3,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',22760.00,NULL,NULL,1,'2023-03-05 19:37:37','2023-03-05 19:37:37',NULL),(1757,7525,40839,12129,3,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',7502.10,NULL,NULL,1,'2023-03-05 19:37:37','2023-03-05 19:42:37','2023-03-05 19:42:37'),(1758,7525,40839,12129,3,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',7502.10,NULL,NULL,1,'2023-03-05 19:42:37','2023-03-05 19:42:37',NULL),(1759,7525,41023,27268,2,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1593487.35,NULL,NULL,1,'2023-03-05 20:22:54','2023-03-05 20:22:54',NULL),(1760,7525,41023,27268,2,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',798832.12,NULL,NULL,1,'2023-03-05 20:22:54','2023-03-05 20:22:54',NULL),(1761,7525,41023,27268,2,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1593487.35,NULL,NULL,1,'2023-03-05 20:22:54','2023-03-05 20:22:54',NULL),(1762,7525,41023,27268,2,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',325834.85,NULL,NULL,1,'2023-03-05 20:22:54','2023-03-05 20:22:54',NULL),(1763,7525,41023,27268,2,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',82000.00,NULL,NULL,1,'2023-03-05 20:22:54','2023-03-05 20:24:30','2023-03-05 20:24:30'),(1764,7525,41023,27268,3,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',14270.57,NULL,NULL,1,'2023-03-05 20:23:06','2023-03-05 20:36:24','2023-03-05 20:36:24'),(1765,7525,41023,27268,3,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',12501.72,NULL,NULL,1,'2023-03-05 20:23:06','2023-03-05 20:23:06',NULL),(1766,7525,41023,27268,3,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',11000.00,NULL,NULL,1,'2023-03-05 20:23:06','2023-03-05 20:34:47','2023-03-05 20:34:47'),(1767,7525,41023,27268,3,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1021.01,NULL,NULL,1,'2023-03-05 20:23:06','2023-03-05 20:34:18','2023-03-05 20:34:18'),(1768,7525,41023,27268,3,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',8616.46,NULL,NULL,1,'2023-03-05 20:23:06','2023-03-05 20:23:06',NULL),(1769,7525,41023,27268,3,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',10276.58,NULL,NULL,1,'2023-03-05 20:23:06','2023-03-05 20:33:32','2023-03-05 20:33:32'),(1770,7525,41023,27268,3,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',45373.50,NULL,NULL,1,'2023-03-05 20:23:06','2023-03-05 20:33:01','2023-03-05 20:33:01'),(1771,7525,41023,27268,3,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',10659.93,NULL,NULL,1,'2023-03-05 20:23:06','2023-03-05 20:32:11','2023-03-05 20:32:11'),(1772,7525,41023,27268,3,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',11270.00,NULL,NULL,1,'2023-03-05 20:23:06','2023-03-05 20:23:06',NULL),(1773,7525,41023,27268,3,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',100000.00,NULL,NULL,1,'2023-03-05 20:23:06','2023-03-05 20:31:33','2023-03-05 20:31:33'),(1774,7525,41023,27268,2,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',67768.59,NULL,NULL,1,'2023-03-05 20:24:30','2023-03-05 20:25:07','2023-03-05 20:25:07');
INSERT INTO `balance_libro` VALUES (1775,7525,41023,27268,2,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',81999.99,NULL,NULL,1,'2023-03-05 20:25:07','2023-03-05 20:26:10','2023-03-05 20:26:10'),(1776,7525,41023,27268,2,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',81999.99,NULL,NULL,1,'2023-03-05 20:26:10','2023-03-05 20:26:10',NULL),(1777,7525,41023,27268,3,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',10659.94,NULL,NULL,1,'2023-03-05 20:32:11','2023-03-05 20:32:11',NULL),(1778,7525,41023,27268,3,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',45373.50,NULL,NULL,1,'2023-03-05 20:33:01','2023-03-05 20:33:01',NULL),(1779,7525,41023,27268,3,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',10276.58,NULL,NULL,1,'2023-03-05 20:33:32','2023-03-05 20:33:32',NULL),(1780,7525,41023,27268,3,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1021.01,NULL,NULL,1,'2023-03-05 20:34:18','2023-03-05 20:34:18',NULL),(1781,7525,41023,27268,3,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',11000.00,NULL,NULL,1,'2023-03-05 20:34:47','2023-03-05 20:34:47',NULL),(1782,7525,41023,27268,3,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',14270.57,NULL,NULL,1,'2023-03-05 20:36:24','2023-03-05 20:36:24',NULL),(1783,7525,41023,27268,3,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1538.66,NULL,NULL,1,'2023-03-05 20:38:15','2023-03-05 20:38:15',NULL),(1784,7525,41184,28765,2,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',9680.00,NULL,NULL,1,'2023-03-17 14:23:45','2023-03-17 14:23:45',NULL),(1785,7525,41184,28765,2,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',156390.00,NULL,NULL,1,'2023-03-17 14:23:45','2023-03-17 14:23:45',NULL),(1786,7525,41184,28765,2,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',452419.00,NULL,NULL,1,'2023-03-17 14:23:45','2023-03-17 14:23:45',NULL),(1787,7525,41184,28765,2,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',77924.00,NULL,NULL,1,'2023-03-17 14:23:45','2023-03-17 14:23:45',NULL),(1788,7525,41184,28765,2,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',9377.50,NULL,NULL,1,'2023-03-17 14:23:45','2023-03-17 14:23:45',NULL),(1789,7525,41184,28765,3,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',48250.00,NULL,NULL,1,'2023-03-17 14:24:02','2023-03-17 14:29:32','2023-03-17 14:29:32'),(1790,7525,41184,28765,3,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',48250.00,NULL,NULL,1,'2023-03-17 14:24:02','2023-03-17 14:28:52','2023-03-17 14:28:52'),(1791,7525,41184,28765,3,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',10401.50,NULL,NULL,1,'2023-03-17 14:24:02','2023-03-17 14:30:45','2023-03-17 14:30:45'),(1792,7525,41184,28765,3,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1320.00,NULL,NULL,1,'2023-03-17 14:24:02','2023-03-17 14:28:30','2023-03-17 14:28:30'),(1793,7525,41184,28765,3,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',11300.60,NULL,NULL,1,'2023-03-17 14:24:02','2023-03-17 14:30:28','2023-03-17 14:30:28'),(1794,7525,41184,28765,3,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',316355.14,NULL,NULL,1,'2023-03-17 14:24:02','2023-03-17 14:28:17','2023-03-17 14:28:17');
INSERT INTO `balance_libro` VALUES (1795,7525,41184,28765,3,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',54369.84,NULL,NULL,1,'2023-03-17 14:24:02','2023-03-17 14:27:56','2023-03-17 14:27:56'),(1796,7525,41184,28765,3,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',14520.00,NULL,NULL,1,'2023-03-17 14:24:02','2023-03-17 14:24:02',NULL),(1797,7525,41184,28765,3,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',6994.11,NULL,NULL,1,'2023-03-17 14:24:02','2023-03-17 14:27:14','2023-03-17 14:27:14'),(1798,7525,41184,28765,3,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',13700.00,NULL,NULL,1,'2023-03-17 14:24:03','2023-03-17 14:24:03',NULL),(1799,7525,41184,28765,3,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',6994.11,NULL,NULL,1,'2023-03-17 14:27:14','2023-03-17 14:27:14',NULL),(1800,7525,41184,28765,3,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',54369.84,NULL,NULL,1,'2023-03-17 14:27:56','2023-03-17 14:27:56',NULL),(1801,7525,41184,28765,3,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',316355.14,NULL,NULL,1,'2023-03-17 14:28:17','2023-03-17 14:28:17',NULL),(1802,7525,41184,28765,3,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',11300.60,NULL,NULL,1,'2023-03-17 14:30:28','2023-03-17 14:30:28',NULL),(1803,7525,41184,28765,3,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',10401.49,NULL,NULL,1,'2023-03-17 14:30:45','2023-03-17 14:30:45',NULL),(1804,8694,41023,27269,2,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',30876.78,NULL,NULL,1,'2023-03-17 16:11:08','2023-03-17 16:11:08',NULL),(1805,7525,41023,27269,2,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',67000.00,NULL,NULL,1,'2023-03-17 16:25:33','2023-03-17 16:34:49','2023-03-17 16:34:49'),(1806,7525,41023,27269,2,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',120000.00,NULL,NULL,1,'2023-03-17 16:25:33','2023-03-17 16:35:30','2023-03-17 16:35:30'),(1807,7525,41023,27269,3,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3680.82,NULL,NULL,1,'2023-03-17 16:26:12','2023-03-17 16:26:12',NULL),(1808,7525,41023,27269,3,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',5679.27,NULL,NULL,1,'2023-03-17 16:26:12','2023-03-17 16:29:32','2023-03-17 16:29:32'),(1809,7525,41023,27269,3,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3430.00,NULL,NULL,1,'2023-03-17 16:26:12','2023-03-17 16:26:12',NULL),(1810,7525,41023,27269,3,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',4921.68,NULL,NULL,1,'2023-03-17 16:26:12','2023-03-31 12:59:27','2023-03-31 12:59:27'),(1811,7525,41023,27269,3,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',4757.80,NULL,NULL,1,'2023-03-17 16:26:12','2023-03-17 17:03:32','2023-03-17 17:03:32'),(1812,7525,41023,27269,3,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',62683.84,NULL,NULL,1,'2023-03-17 16:26:12','2023-03-17 16:53:16','2023-03-17 16:53:16'),(1813,7525,41023,27269,3,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',702.57,NULL,NULL,1,'2023-03-17 16:26:12','2023-03-17 16:26:12',NULL),(1814,7525,41023,27269,3,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',30930.01,NULL,NULL,1,'2023-03-17 16:26:12','2023-03-17 16:47:01','2023-03-17 16:47:01');
INSERT INTO `balance_libro` VALUES (1815,7525,41023,27269,3,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',3939.98,NULL,NULL,1,'2023-03-17 16:26:12','2023-03-17 16:37:42','2023-03-17 16:37:42'),(1816,7525,41023,27269,3,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',9758.41,NULL,NULL,1,'2023-03-17 16:26:12','2023-03-17 16:26:12',NULL),(1817,7525,41023,27269,3,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',21634.67,NULL,NULL,1,'2023-03-17 16:26:12','2023-03-31 12:53:23','2023-03-31 12:53:23'),(1818,7525,41023,27269,3,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',90360.12,NULL,NULL,1,'2023-03-17 16:26:12','2023-03-31 12:47:54','2023-03-31 12:47:54'),(1819,7525,41023,27269,3,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30235.66,NULL,NULL,1,'2023-03-17 16:26:13','2023-03-31 12:46:23','2023-03-31 12:46:23'),(1820,7525,41023,27269,3,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',9758.41,NULL,NULL,1,'2023-03-17 16:26:13','2023-03-17 16:26:13',NULL),(1821,7525,41023,27269,3,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',185.00,NULL,NULL,1,'2023-03-17 16:26:13','2023-03-31 12:45:52','2023-03-31 12:45:52'),(1822,7525,41023,27269,3,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',18890.52,NULL,NULL,1,'2023-03-17 16:26:13','2023-03-31 12:45:42','2023-03-31 12:45:42'),(1823,7525,41023,27269,3,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',5679.27,NULL,NULL,1,'2023-03-17 16:29:32','2023-03-31 12:59:54','2023-03-31 12:59:54'),(1824,8694,41023,27269,2,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',67000.00,NULL,NULL,1,'2023-03-17 16:34:49','2023-03-17 16:34:49',NULL),(1825,8694,41023,27269,2,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',120000.00,NULL,NULL,1,'2023-03-17 16:35:30','2023-03-17 16:35:30',NULL),(1826,8694,41023,27269,3,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',3939.98,NULL,NULL,1,'2023-03-17 16:37:42','2023-03-31 12:54:35','2023-03-31 12:54:35'),(1827,8694,41023,27269,3,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',30930.01,NULL,NULL,1,'2023-03-17 16:47:01','2023-03-31 12:55:18','2023-03-31 12:55:18'),(1828,8694,41023,27269,3,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',62683.84,NULL,NULL,1,'2023-03-17 16:53:16','2023-03-17 16:53:16',NULL),(1829,7525,41023,27268,7,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',95.65,NULL,NULL,1,'2023-03-17 16:55:28','2023-03-17 16:55:28',NULL),(1830,7525,41023,27268,15,933,'App\\Models\\PeriodLiquidation',NULL,933,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',298105.73,NULL,NULL,1,'2023-03-17 16:59:47','2023-03-17 16:59:47',NULL),(1831,8694,41023,27269,3,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',4757.79,NULL,NULL,1,'2023-03-17 17:03:32','2023-03-17 17:03:32',NULL),(1832,7525,41023,27263,15,305,'App\\Models\\PeriodLiquidation',NULL,305,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',12996.56,NULL,NULL,1,'2023-03-17 17:04:41','2023-03-17 17:04:41',NULL),(1833,7525,41023,27264,15,595,'App\\Models\\PeriodLiquidation',NULL,595,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',35328.92,NULL,NULL,1,'2023-03-17 17:04:55','2023-03-17 17:04:55',NULL),(1834,8694,40849,13645,3,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',126.75,NULL,NULL,1,'2023-03-17 17:47:14','2023-03-20 16:14:00','2023-03-20 16:14:00');
INSERT INTO `balance_libro` VALUES (1835,8694,40849,13645,3,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',26994.21,NULL,NULL,1,'2023-03-17 17:47:14','2023-03-20 16:14:30','2023-03-20 16:14:30'),(1836,8694,40849,13645,3,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',33353.52,NULL,NULL,1,'2023-03-17 17:47:14','2023-03-17 18:08:03','2023-03-17 18:08:03'),(1837,8694,40849,13645,3,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',6180.55,NULL,NULL,1,'2023-03-17 17:47:14','2023-03-17 17:57:06','2023-03-17 17:57:06'),(1838,8694,40849,13645,3,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',17805.34,NULL,NULL,1,'2023-03-17 17:47:14','2023-03-17 18:14:41','2023-03-17 18:14:41'),(1839,8694,40849,13645,3,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',5811.65,NULL,NULL,1,'2023-03-17 17:47:14','2023-03-17 18:41:31','2023-03-17 18:41:31'),(1840,8694,40849,13645,3,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',193855.20,NULL,NULL,1,'2023-03-17 17:47:14','2023-03-17 17:47:14',NULL),(1841,8694,40849,13645,3,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',3581.42,NULL,NULL,1,'2023-03-17 17:47:14','2023-03-17 18:51:54','2023-03-17 18:51:54'),(1842,8694,40849,13645,3,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',7090.87,NULL,NULL,1,'2023-03-17 17:47:14','2023-03-17 19:00:17','2023-03-17 19:00:17'),(1843,8694,40849,13645,3,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',14193.33,NULL,NULL,1,'2023-03-17 17:47:15','2023-03-17 18:49:32','2023-03-17 18:49:32'),(1844,8694,40849,13645,3,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',8000.00,NULL,NULL,1,'2023-03-17 17:47:15','2023-03-17 19:03:23','2023-03-17 19:03:23'),(1845,8694,40849,13645,3,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',7815.40,NULL,NULL,1,'2023-03-17 17:47:15','2023-03-17 20:02:36','2023-03-17 20:02:36'),(1846,8694,40849,13645,3,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',3906.26,NULL,NULL,1,'2023-03-17 17:47:15','2023-03-17 20:09:24','2023-03-17 20:09:24'),(1847,8694,40849,13645,3,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',1037.43,NULL,NULL,1,'2023-03-17 17:47:15','2023-03-20 16:13:18','2023-03-20 16:13:18'),(1848,8694,40849,13645,3,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',105000.00,NULL,NULL,1,'2023-03-17 17:47:15','2023-03-20 16:12:46','2023-03-20 16:12:46'),(1849,8694,40849,13645,3,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1037.43,NULL,NULL,1,'2023-03-17 17:47:15','2023-03-20 16:13:08','2023-03-20 16:13:08'),(1850,8694,40849,13645,3,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',16399.00,NULL,NULL,1,'2023-03-17 17:47:15','2023-03-17 20:34:00','2023-03-17 20:34:00'),(1851,8694,40849,13645,3,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',13660.09,NULL,NULL,1,'2023-03-17 17:47:15','2023-03-17 20:16:44','2023-03-17 20:16:44'),(1852,8694,40849,13645,3,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',5140.74,NULL,NULL,1,'2023-03-17 17:47:15','2023-03-17 20:23:03','2023-03-17 20:23:03'),(1853,8694,40849,13645,3,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',4235.00,NULL,NULL,1,'2023-03-17 17:47:15','2023-03-17 20:19:05','2023-03-17 20:19:05');
INSERT INTO `balance_libro` VALUES (1854,8694,40849,13645,3,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',213944.94,NULL,NULL,1,'2023-03-17 17:47:15','2023-03-17 20:27:33','2023-03-17 20:27:33'),(1855,8694,40849,13645,3,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',11278.54,NULL,NULL,1,'2023-03-17 17:47:15','2023-03-17 20:25:44','2023-03-17 20:25:44'),(1856,8694,40849,13645,3,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3150.17,NULL,NULL,1,'2023-03-17 17:47:15','2023-03-17 20:33:28','2023-03-17 20:33:28'),(1857,8694,40849,13645,3,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',15019.03,NULL,NULL,1,'2023-03-17 17:47:15','2023-03-17 20:31:22','2023-03-17 20:31:22'),(1858,8694,40849,13645,3,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7576.53,NULL,NULL,1,'2023-03-17 17:47:15','2023-03-20 16:11:38','2023-03-20 16:11:38'),(1859,8694,40849,13645,3,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7576.53,NULL,NULL,1,'2023-03-17 17:47:15','2023-03-20 16:11:29','2023-03-20 16:11:29'),(1860,8694,40849,13645,3,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5342.80,NULL,NULL,1,'2023-03-17 17:47:15','2023-03-17 20:33:43','2023-03-17 20:33:43'),(1861,8694,40849,13645,3,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',6180.54,NULL,NULL,1,'2023-03-17 17:57:06','2023-03-17 17:57:06',NULL),(1862,8694,40849,13645,3,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',33353.52,NULL,NULL,1,'2023-03-17 18:08:03','2023-03-17 18:08:03',NULL),(1863,8694,40849,13645,3,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',17805.34,NULL,NULL,1,'2023-03-17 18:14:41','2023-03-17 18:14:41',NULL),(1864,8694,40849,13645,3,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',10135.25,NULL,NULL,1,'2023-03-17 18:29:36','2023-03-17 18:29:36',NULL),(1865,8694,40849,13645,3,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',5811.64,NULL,NULL,1,'2023-03-17 18:41:31','2023-03-17 18:41:31',NULL),(1866,8694,40849,13645,3,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',14193.33,NULL,NULL,1,'2023-03-17 18:49:32','2023-03-17 18:49:32',NULL),(1867,8694,40849,13645,3,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',3581.42,NULL,NULL,1,'2023-03-17 18:51:54','2023-03-17 18:51:54',NULL),(1868,8694,40849,13645,3,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',7090.87,NULL,NULL,1,'2023-03-17 19:00:17','2023-03-17 19:00:17',NULL),(1869,8694,40849,13645,3,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',8000.00,NULL,NULL,1,'2023-03-17 19:03:23','2023-03-17 19:03:23',NULL),(1870,7525,40849,13645,2,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',31367.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1871,7525,40849,13645,2,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',48961.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1872,7525,40849,13645,2,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',43725.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1873,7525,40849,13645,2,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',67605.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL);
INSERT INTO `balance_libro` VALUES (1874,7525,40849,13645,2,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',23807.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1875,7525,40849,13645,2,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',48236.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1876,7525,40849,13645,2,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',30145.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1877,7525,40849,13645,2,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',48417.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1878,7525,40849,13645,2,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',67732.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1879,7525,40849,13645,2,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',55573.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1880,7525,40849,13645,2,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',44390.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1881,7525,40849,13645,2,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',26295.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1882,7525,40849,13645,2,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',2500.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1883,7525,40849,13645,2,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',3000.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1884,7525,40849,13645,2,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',2700.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1885,7525,40849,13645,2,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',3000.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1886,7525,40849,13645,2,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',2500.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1887,7525,40849,13645,2,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',3100.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1888,7525,40849,13645,2,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',3600.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1889,7525,40849,13645,2,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',4140.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1890,7525,40849,13645,2,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',4100.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1891,7525,40849,13645,2,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',3200.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1892,7525,40849,13645,2,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3100.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1893,7525,40849,13645,2,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',32551.00,NULL,NULL,1,'2023-03-17 19:45:57','2023-03-17 19:45:57',NULL),(1894,8694,40849,13645,3,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',7815.40,NULL,NULL,1,'2023-03-17 20:02:36','2023-03-17 20:02:36',NULL);
INSERT INTO `balance_libro` VALUES (1895,8694,40849,13645,3,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',3906.26,NULL,NULL,1,'2023-03-17 20:09:24','2023-03-17 20:09:24',NULL),(1896,8694,40849,13645,3,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',13660.09,NULL,NULL,1,'2023-03-17 20:16:44','2023-03-17 20:16:44',NULL),(1897,8694,40849,13645,3,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',4235.00,NULL,NULL,1,'2023-03-17 20:19:05','2023-03-17 20:19:05',NULL),(1898,8694,40849,13645,3,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',5140.75,NULL,NULL,1,'2023-03-17 20:23:03','2023-03-17 20:23:03',NULL),(1899,8694,40849,13645,3,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',11278.54,NULL,NULL,1,'2023-03-17 20:25:44','2023-03-17 20:25:44',NULL),(1900,8694,40849,13645,3,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',213944.94,NULL,NULL,1,'2023-03-17 20:27:33','2023-03-17 20:27:33',NULL),(1901,8694,40849,13645,3,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',15019.03,NULL,NULL,1,'2023-03-17 20:31:22','2023-03-17 20:31:22',NULL),(1902,7525,41204,30280,3,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',29061.75,NULL,NULL,1,'2023-03-17 21:33:42','2023-03-17 21:43:47','2023-03-17 21:43:47'),(1903,7525,41204,30281,3,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',301.00,NULL,NULL,1,'2023-03-17 21:39:15','2023-03-17 21:40:43','2023-03-17 21:40:43'),(1904,7525,41204,30281,3,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',400.00,NULL,NULL,1,'2023-03-17 21:39:15','2023-03-17 21:40:35','2023-03-17 21:40:35'),(1905,7525,41204,30281,3,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',68.00,NULL,NULL,1,'2023-03-17 21:39:15','2023-03-17 21:40:27','2023-03-17 21:40:27'),(1906,7525,41204,30281,3,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',66000.00,NULL,NULL,1,'2023-03-17 21:39:15','2023-03-17 21:57:43','2023-03-17 21:57:43'),(1907,7525,41204,30281,3,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',7800.00,NULL,NULL,1,'2023-03-17 21:39:15','2023-03-17 21:57:28','2023-03-17 21:57:28'),(1908,7525,41204,30281,3,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',4428.00,NULL,NULL,1,'2023-03-17 21:39:15','2023-03-17 21:40:21','2023-03-17 21:40:21'),(1909,7525,41204,30281,3,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',25500.00,NULL,NULL,1,'2023-03-17 21:39:15','2023-03-17 21:57:15','2023-03-17 21:57:15'),(1910,7525,41204,30281,3,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',9000.00,NULL,NULL,1,'2023-03-17 21:39:15','2023-03-17 21:40:13','2023-03-17 21:40:13'),(1911,7525,41204,30280,3,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',29166.95,NULL,NULL,1,'2023-03-17 21:43:47','2023-03-17 21:48:35','2023-03-17 21:48:35'),(1912,7525,41204,30281,2,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',309276.00,NULL,NULL,1,'2023-03-17 21:46:32','2023-03-17 21:46:32',NULL),(1913,7525,41204,30281,2,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',257004.00,NULL,NULL,1,'2023-03-17 21:46:32','2023-03-17 21:46:32',NULL),(1914,7525,41204,30281,2,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',261360.00,NULL,NULL,1,'2023-03-17 21:46:32','2023-03-17 21:46:32',NULL);
INSERT INTO `balance_libro` VALUES (1915,7525,41204,30280,3,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',29166.95,NULL,NULL,1,'2023-03-17 21:48:35','2023-03-17 21:58:04','2023-03-17 21:58:04'),(1916,7525,41204,30281,3,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',25500.00,NULL,NULL,1,'2023-03-17 21:57:15','2023-03-17 21:57:15',NULL),(1917,7525,41204,30281,3,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',7800.00,NULL,NULL,1,'2023-03-17 21:57:28','2023-03-17 21:57:28',NULL),(1918,7525,41204,30281,3,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',66000.00,NULL,NULL,1,'2023-03-17 21:57:43','2023-03-17 21:57:43',NULL),(1919,7525,41204,30280,3,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',29166.95,NULL,NULL,1,'2023-03-17 21:58:04','2023-03-17 22:10:01','2023-03-17 22:10:01'),(1920,7525,41204,30281,3,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2200.00,NULL,NULL,1,'2023-03-17 21:59:43','2023-03-17 21:59:43',NULL),(1921,7525,41204,30281,3,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',23392.32,NULL,NULL,1,'2023-03-17 22:01:36','2023-03-17 22:01:36',NULL),(1922,7525,41204,30281,3,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4999.90,NULL,NULL,1,'2023-03-17 22:02:18','2023-03-17 22:02:18',NULL),(1923,7525,41204,30281,3,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',19104.88,NULL,NULL,1,'2023-03-17 22:03:22','2023-03-17 22:03:22',NULL),(1924,7525,41204,30281,3,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',55447.60,NULL,NULL,1,'2023-03-17 22:04:50','2023-03-17 22:04:50',NULL),(1925,7525,41204,30280,3,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',29061.77,NULL,NULL,1,'2023-03-17 22:10:01','2023-03-17 22:10:01',NULL),(1926,7525,41204,30281,7,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1261.68,NULL,NULL,1,'2023-03-17 22:13:52','2023-03-17 22:13:52',NULL),(1927,7525,41204,30280,15,998,'App\\Models\\PeriodLiquidation',NULL,998,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',5020.75,NULL,NULL,1,'2023-03-17 22:16:37','2023-03-17 22:16:37',NULL),(1928,8694,40856,15157,2,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',206521.59,NULL,NULL,1,'2023-03-18 20:46:57','2023-03-18 20:53:31','2023-03-18 20:53:31'),(1929,8694,40856,15157,3,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',5000.01,NULL,NULL,1,'2023-03-18 20:48:05','2023-03-25 19:58:36','2023-03-25 19:58:36'),(1930,8694,40856,15157,3,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',5380.00,NULL,NULL,1,'2023-03-18 20:48:05','2023-03-20 19:12:31','2023-03-20 19:12:31'),(1931,8694,40856,15157,3,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',26669.13,NULL,NULL,1,'2023-03-18 20:48:05','2023-03-20 19:09:43','2023-03-20 19:09:43'),(1932,8694,40856,15157,3,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',190.00,NULL,NULL,1,'2023-03-18 20:48:05','2023-03-18 20:48:05',NULL),(1933,8694,40856,15157,3,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',163.00,NULL,NULL,1,'2023-03-18 20:48:05','2023-03-25 19:59:16','2023-03-25 19:59:16'),(1934,8694,40856,15157,3,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',35000.00,NULL,NULL,1,'2023-03-18 20:48:05','2023-03-22 15:16:30','2023-03-22 15:16:30');
INSERT INTO `balance_libro` VALUES (1935,8694,40856,15157,3,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',16106.00,NULL,NULL,1,'2023-03-18 20:48:06','2023-03-20 19:38:58','2023-03-20 19:38:58'),(1936,8694,40856,15157,3,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',10013.49,NULL,NULL,1,'2023-03-18 20:48:06','2023-03-20 19:58:01','2023-03-20 19:58:01'),(1937,8694,40856,15157,3,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',31004.22,NULL,NULL,1,'2023-03-18 20:48:06','2023-03-20 20:00:55','2023-03-20 20:00:55'),(1938,8694,40856,15157,3,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',9005.70,NULL,NULL,1,'2023-03-18 20:48:06','2023-03-25 19:58:22','2023-03-25 19:58:22'),(1939,8694,40856,15157,3,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',9000.00,NULL,NULL,1,'2023-03-18 20:48:06','2023-03-20 20:11:32','2023-03-20 20:11:32'),(1940,8694,40856,15157,3,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',6500.00,NULL,NULL,1,'2023-03-18 20:48:06','2023-03-18 20:48:06',NULL),(1941,8694,40856,15157,3,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',6050.00,NULL,NULL,1,'2023-03-18 20:48:06','2023-03-20 20:13:11','2023-03-20 20:13:11'),(1942,8694,40856,15157,3,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',4500.00,NULL,NULL,1,'2023-03-18 20:48:06','2023-03-18 20:48:06',NULL),(1943,8694,40856,15157,3,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',68.00,NULL,NULL,1,'2023-03-18 20:48:06','2023-03-25 19:59:55','2023-03-25 19:59:55'),(1944,8694,40856,15157,3,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',4500.00,NULL,NULL,1,'2023-03-18 20:48:06','2023-03-18 20:48:06',NULL),(1945,8694,40856,15157,3,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',190.00,NULL,NULL,1,'2023-03-18 20:48:06','2023-03-25 19:59:02','2023-03-25 19:59:02'),(1946,8694,40856,15157,3,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',125.14,NULL,NULL,1,'2023-03-18 20:48:06','2023-03-25 19:58:49','2023-03-25 19:58:49'),(1947,8694,40856,15157,3,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',7209.07,NULL,NULL,1,'2023-03-18 20:48:06','2023-03-20 20:24:13','2023-03-20 20:24:13'),(1948,8694,40856,15157,3,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',7100.80,NULL,NULL,1,'2023-03-18 20:48:06','2023-03-25 19:58:05','2023-03-25 19:58:05'),(1949,8694,40856,15157,3,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1812.00,NULL,NULL,1,'2023-03-18 20:48:06','2023-03-25 20:00:15','2023-03-25 20:00:15'),(1950,8694,40856,15157,3,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',9000.00,NULL,NULL,1,'2023-03-18 20:48:06','2023-03-18 20:49:08','2023-03-18 20:49:08'),(1951,8694,40856,15157,2,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',206521.59,NULL,NULL,1,'2023-03-18 20:53:31','2023-03-18 20:53:31',NULL),(1952,8694,40856,15157,3,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1530.00,NULL,NULL,1,'2023-03-18 21:12:00','2023-03-18 21:12:00',NULL),(1953,8694,40856,15157,3,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',35500.00,NULL,NULL,1,'2023-03-18 21:15:41','2023-03-18 21:15:41',NULL);
INSERT INTO `balance_libro` VALUES (1954,7525,40839,12124,15,21,'App\\Models\\PeriodLiquidation',NULL,21,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',154507.50,NULL,NULL,1,'2023-03-20 15:36:43','2023-03-20 15:36:43',NULL),(1955,7525,40839,12125,15,309,'App\\Models\\PeriodLiquidation',NULL,309,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',59513.09,NULL,NULL,1,'2023-03-20 15:37:06','2023-03-20 15:37:06',NULL),(1956,7525,40839,12129,3,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',42000.00,NULL,NULL,1,'2023-03-20 15:47:42','2023-03-20 15:47:42',NULL),(1957,7525,40839,12129,3,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',567071.00,NULL,NULL,1,'2023-03-20 15:49:06','2023-03-20 15:49:06',NULL),(1958,7525,40839,12129,3,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',11023.00,NULL,NULL,1,'2023-03-20 15:49:34','2023-03-20 15:51:28','2023-03-20 15:51:28'),(1959,7525,40839,12129,3,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',567071.00,NULL,NULL,1,'2023-03-20 15:50:53','2023-03-20 15:50:53',NULL),(1960,7525,40839,12129,3,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',567071.00,NULL,NULL,1,'2023-03-20 15:51:16','2023-03-20 15:51:16',NULL),(1961,7525,40839,12129,3,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',11023.00,NULL,NULL,1,'2023-03-20 15:51:28','2023-03-20 15:51:28',NULL),(1962,7525,40839,12129,3,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',18818.18,NULL,NULL,1,'2023-03-20 15:52:36','2023-03-20 15:52:36',NULL),(1963,7525,40839,12129,3,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',9298.28,NULL,NULL,1,'2023-03-20 15:53:30','2023-03-20 15:53:30',NULL),(1964,7525,40839,12129,3,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',6000.00,NULL,NULL,1,'2023-03-20 15:53:49','2023-03-20 15:53:49',NULL),(1965,7525,40849,13639,15,57,'App\\Models\\PeriodLiquidation',NULL,57,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',109178.08,NULL,NULL,1,'2023-03-20 15:58:07','2023-03-20 15:58:07',NULL),(1966,7525,40849,13640,7,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',5388.03,NULL,NULL,1,'2023-03-20 16:01:22','2023-03-20 16:01:22',NULL),(1967,7525,40849,13640,15,1009,'App\\Models\\PeriodLiquidation',NULL,1009,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',161429.95,NULL,NULL,1,'2023-03-20 16:02:03','2023-03-20 16:02:03',NULL),(1968,7525,40849,13644,7,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',3958.21,NULL,NULL,1,'2023-03-20 16:04:57','2023-03-20 16:04:57',NULL),(1969,7525,40849,13644,15,1010,'App\\Models\\PeriodLiquidation',NULL,1010,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',145980.67,NULL,NULL,1,'2023-03-20 16:06:20','2023-03-20 16:06:20',NULL),(1970,7525,40849,13645,3,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',26994.21,NULL,NULL,1,'2023-03-20 16:14:30','2023-03-20 16:14:30',NULL),(1971,7525,40849,13645,7,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',2937.24,NULL,NULL,1,'2023-03-20 16:32:42','2023-03-20 16:32:42',NULL),(1972,7525,40856,15151,15,95,'App\\Models\\PeriodLiquidation',NULL,95,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',229401.45,NULL,NULL,1,'2023-03-20 16:43:05','2023-03-20 16:43:05',NULL),(1973,7525,40856,15156,15,690,'App\\Models\\PeriodLiquidation',NULL,690,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',58459.59,NULL,NULL,1,'2023-03-20 16:45:15','2023-03-20 16:45:15',NULL);
INSERT INTO `balance_libro` VALUES (1974,8694,40856,15157,3,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',6308.99,NULL,NULL,1,'2023-03-20 18:18:58','2023-03-22 20:07:45','2023-03-22 20:07:45'),(1975,8694,40856,15157,3,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1900.36,NULL,NULL,1,'2023-03-20 18:31:35','2023-03-20 18:31:35',NULL),(1976,8694,40856,15157,3,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',500.00,NULL,NULL,1,'2023-03-20 18:35:07','2023-03-20 18:35:07',NULL),(1977,8694,40856,15157,3,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2400.00,NULL,NULL,1,'2023-03-20 18:52:22','2023-03-20 18:52:22',NULL),(1978,8694,40856,15157,3,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',5900.00,NULL,NULL,1,'2023-03-20 18:54:36','2023-03-20 18:54:36',NULL),(1979,8694,40856,15157,3,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',5300.99,NULL,NULL,1,'2023-03-20 19:03:33','2023-03-20 19:03:33',NULL),(1980,8694,40856,15157,3,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',26669.13,NULL,NULL,1,'2023-03-20 19:09:43','2023-03-20 19:09:43',NULL),(1981,8694,40856,15157,3,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',5380.00,NULL,NULL,1,'2023-03-20 19:12:31','2023-03-20 19:12:31',NULL),(1982,8694,40856,15157,3,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',6399.99,NULL,NULL,1,'2023-03-20 19:23:06','2023-03-20 19:23:06',NULL),(1983,8694,40856,15157,3,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',7000.50,NULL,NULL,1,'2023-03-20 19:26:03','2023-03-20 19:26:03',NULL),(1984,8694,40856,15157,3,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',16106.00,NULL,NULL,1,'2023-03-20 19:38:58','2023-03-20 19:38:58',NULL),(1985,8694,40856,15157,3,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',10013.49,NULL,NULL,1,'2023-03-20 19:58:01','2023-03-20 19:58:01',NULL),(1986,8694,40856,15157,3,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',31004.22,NULL,NULL,1,'2023-03-20 20:00:55','2023-03-20 20:00:55',NULL),(1987,8694,40856,15157,3,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',5700.40,NULL,NULL,1,'2023-03-20 20:04:28','2023-03-20 20:04:28',NULL),(1988,8694,40856,15157,3,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',7600.50,NULL,NULL,1,'2023-03-20 20:07:09','2023-03-20 20:07:09',NULL),(1989,8694,40856,15157,3,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',9000.00,NULL,NULL,1,'2023-03-20 20:11:32','2023-03-20 20:11:32',NULL),(1990,8694,40856,15157,3,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',6050.00,NULL,NULL,1,'2023-03-20 20:13:11','2023-03-20 20:13:11',NULL),(1991,8694,40856,15157,3,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',7209.07,NULL,NULL,1,'2023-03-20 20:24:13','2023-03-20 20:24:13',NULL),(1992,8694,40856,15157,3,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',8400.09,NULL,NULL,1,'2023-03-20 20:29:03','2023-03-20 20:29:03',NULL),(1993,8694,40875,16669,2,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',4800.00,NULL,NULL,1,'2023-03-20 20:43:22','2023-03-25 20:25:41','2023-03-25 20:25:41');
INSERT INTO `balance_libro` VALUES (1994,8694,40875,16669,2,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',106000.00,NULL,NULL,1,'2023-03-20 20:43:22','2023-03-20 20:50:03','2023-03-20 20:50:03'),(1995,8694,40875,16669,2,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',20950.00,NULL,NULL,1,'2023-03-20 20:43:22','2023-03-25 20:24:44','2023-03-25 20:24:44'),(1996,8694,40875,16669,2,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',6775.00,NULL,NULL,1,'2023-03-20 20:43:22','2023-03-25 20:24:11','2023-03-25 20:24:11'),(1997,8694,40875,16669,2,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',6000.00,NULL,NULL,1,'2023-03-20 20:43:22','2023-03-25 20:23:55','2023-03-25 20:23:55'),(1998,8694,40875,16669,2,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',15000.00,NULL,NULL,1,'2023-03-20 20:43:22','2023-03-25 20:23:35','2023-03-25 20:23:35'),(1999,8694,40875,16669,3,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',6880.00,NULL,NULL,1,'2023-03-20 20:44:09','2023-03-20 21:12:26','2023-03-20 21:12:26'),(2000,8694,40875,16669,3,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',886.45,NULL,NULL,1,'2023-03-20 20:44:09','2023-03-25 20:39:15','2023-03-25 20:39:15'),(2001,8694,40875,16669,3,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',212.39,NULL,NULL,1,'2023-03-20 20:44:09','2023-03-20 20:44:09',NULL),(2002,8694,40875,16669,3,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1900.00,NULL,NULL,1,'2023-03-20 20:44:09','2023-03-25 20:28:59','2023-03-25 20:28:59'),(2003,8694,40875,16669,3,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',4780.00,NULL,NULL,1,'2023-03-20 20:44:09','2023-03-20 21:38:54','2023-03-20 21:38:54'),(2004,8694,40875,16669,3,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',18278.60,NULL,NULL,1,'2023-03-20 20:44:09','2023-03-20 21:14:08','2023-03-20 21:14:08'),(2005,8694,40875,16669,3,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',7990.00,NULL,NULL,1,'2023-03-20 20:44:09','2023-03-20 21:17:12','2023-03-20 21:17:12'),(2006,8694,40875,16669,3,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',30250.00,NULL,NULL,1,'2023-03-20 20:44:09','2023-03-20 21:15:16','2023-03-20 21:15:16'),(2007,8694,40875,16669,3,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',126055.50,NULL,NULL,1,'2023-03-20 20:44:09','2023-03-20 21:18:48','2023-03-20 21:18:48'),(2008,8694,40875,16669,3,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',4780.00,NULL,NULL,1,'2023-03-20 20:44:09','2023-03-20 21:47:34','2023-03-20 21:47:34'),(2009,8694,40875,16669,3,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1945.00,NULL,NULL,1,'2023-03-20 20:44:09','2023-03-20 21:08:54','2023-03-20 21:08:54'),(2010,8694,40875,16669,3,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',7500.00,NULL,NULL,1,'2023-03-20 20:44:09','2023-03-20 21:22:20','2023-03-20 21:22:20'),(2011,8694,40875,16669,3,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',10897.07,NULL,NULL,1,'2023-03-20 20:44:09','2023-03-25 20:28:16','2023-03-25 20:28:16'),(2012,8694,40875,16669,3,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',231.00,NULL,NULL,1,'2023-03-20 20:44:09','2023-03-20 20:44:09',NULL);
INSERT INTO `balance_libro` VALUES (2013,8694,40875,16669,3,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',549.92,NULL,NULL,1,'2023-03-20 20:44:09','2023-03-25 20:27:54','2023-03-25 20:27:54'),(2014,8694,40875,16669,3,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',9700.07,NULL,NULL,1,'2023-03-20 20:44:09','2023-03-20 21:59:34','2023-03-20 21:59:34'),(2015,8694,40875,16669,3,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',3724.00,NULL,NULL,1,'2023-03-20 20:44:09','2023-03-20 22:04:28','2023-03-20 22:04:28'),(2016,8694,40875,16669,3,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',29547.77,NULL,NULL,1,'2023-03-20 20:44:09','2023-03-20 21:24:46','2023-03-20 21:24:46'),(2017,8694,40875,16669,3,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',5584.60,NULL,NULL,1,'2023-03-20 20:44:09','2023-03-25 20:27:27','2023-03-25 20:27:27'),(2018,8694,40875,16669,3,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',6310.00,NULL,NULL,1,'2023-03-20 20:44:10','2023-03-20 21:08:19','2023-03-20 21:08:19'),(2019,8694,40875,16669,3,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4780.00,NULL,NULL,1,'2023-03-20 20:44:10','2023-03-20 22:05:22','2023-03-20 22:05:22'),(2020,8694,40875,16669,3,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4350.00,NULL,NULL,1,'2023-03-20 20:44:10','2023-03-20 20:44:10',NULL),(2021,8694,40875,16669,3,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',23798.35,NULL,NULL,1,'2023-03-20 20:44:10','2023-03-25 20:26:36','2023-03-25 20:26:36'),(2022,8694,40875,16669,2,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',106000.01,NULL,NULL,1,'2023-03-20 20:50:03','2023-03-25 20:25:25','2023-03-25 20:25:25'),(2023,8694,40875,16669,3,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',6880.00,NULL,NULL,1,'2023-03-20 21:12:26','2023-03-20 21:12:26',NULL),(2024,8694,40875,16669,3,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',18278.60,NULL,NULL,1,'2023-03-20 21:14:08','2023-03-20 21:14:08',NULL),(2025,8694,40875,16669,3,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',30250.00,NULL,NULL,1,'2023-03-20 21:15:16','2023-03-20 21:15:16',NULL),(2026,8694,40875,16669,3,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',7990.01,NULL,NULL,1,'2023-03-20 21:17:12','2023-03-20 21:17:12',NULL),(2027,8694,40875,16669,3,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',126055.50,NULL,NULL,1,'2023-03-20 21:18:48','2023-03-20 21:21:02','2023-03-20 21:21:02'),(2028,8694,40875,16669,3,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',126055.50,NULL,NULL,1,'2023-03-20 21:21:02','2023-03-20 21:21:02',NULL),(2029,8694,40875,16669,3,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',7500.00,NULL,NULL,1,'2023-03-20 21:22:20','2023-03-20 21:22:20',NULL),(2030,8694,40875,16669,3,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',29547.77,NULL,NULL,1,'2023-03-20 21:24:46','2023-03-20 21:24:46',NULL),(2031,8694,40875,16669,3,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',10099.68,NULL,NULL,1,'2023-03-20 21:35:24','2023-03-20 21:35:24',NULL),(2032,8694,40875,16669,3,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',4780.00,NULL,NULL,1,'2023-03-20 21:38:54','2023-03-20 21:38:54',NULL);
INSERT INTO `balance_libro` VALUES (2033,8694,40875,16669,3,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',96195.27,NULL,NULL,1,'2023-03-20 21:45:43','2023-03-20 21:45:43',NULL),(2034,8694,40875,16669,3,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',4780.00,NULL,NULL,1,'2023-03-20 21:47:34','2023-03-20 21:47:34',NULL),(2035,8694,40875,16669,3,1660,'App\\Models\\Receipt',1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',45184.71,NULL,NULL,1,'2023-03-20 21:54:06','2023-03-20 21:54:06',NULL),(2036,8694,40875,16669,3,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',9700.07,NULL,NULL,1,'2023-03-20 21:59:34','2023-03-20 21:59:34',NULL),(2037,8694,40875,16669,3,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',3724.00,NULL,NULL,1,'2023-03-20 22:04:28','2023-03-20 22:04:28',NULL),(2038,8694,40875,16669,3,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4780.00,NULL,NULL,1,'2023-03-20 22:05:22','2023-03-20 22:05:22',NULL),(2039,7525,40856,15157,3,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',6308.99,NULL,NULL,1,'2023-03-22 20:07:45','2023-03-22 20:07:45',NULL),(2040,7525,40856,15157,3,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',6300.80,NULL,NULL,1,'2023-03-22 20:40:52','2023-03-22 20:40:52',NULL),(2041,7525,40856,15157,3,1662,'App\\Models\\Receipt',1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',8000.00,NULL,NULL,1,'2023-03-22 20:41:40','2023-03-22 20:41:40',NULL),(2042,7525,41023,31904,2,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-28','2020-07-28',53845.00,NULL,NULL,1,'2023-03-23 19:14:15','2023-03-23 19:59:19','2023-03-23 19:59:19'),(2043,7525,41023,31904,2,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',81554.00,NULL,NULL,1,'2023-03-23 19:14:15','2023-03-23 19:59:13','2023-03-23 19:59:13'),(2044,7525,41023,31904,3,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',28543.56,NULL,NULL,1,'2023-03-23 19:14:26','2023-03-23 19:17:39','2023-03-23 19:17:39'),(2045,7525,41023,31904,3,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-14','2020-07-14',60874.02,NULL,NULL,1,'2023-03-23 19:14:26','2023-03-23 19:59:51','2023-03-23 19:59:51'),(2046,7525,41023,31904,3,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-14','2020-07-14',51132.95,NULL,NULL,1,'2023-03-23 19:14:26','2023-03-23 19:59:51','2023-03-23 19:59:51'),(2047,7525,41023,31904,3,1668,'App\\Models\\Receipt',1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',11784.09,NULL,NULL,1,'2023-03-23 19:14:26','2023-03-23 19:59:51','2023-03-23 19:59:51'),(2048,7525,41023,31904,3,1669,'App\\Models\\Receipt',1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-14','2020-07-14',60874.02,NULL,NULL,1,'2023-03-23 19:14:26','2023-03-23 19:59:51','2023-03-23 19:59:51'),(2049,7525,41023,31904,3,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-24','2020-07-24',28543.56,NULL,NULL,1,'2023-03-23 19:14:26','2023-03-23 19:59:51','2023-03-23 19:59:51'),(2050,7525,41023,31904,3,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-24','2020-07-24',28543.56,NULL,NULL,1,'2023-03-23 19:14:26','2023-03-23 19:59:51','2023-03-23 19:59:51'),(2051,7525,41023,31904,3,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',1160.00,NULL,NULL,1,'2023-03-23 19:14:26','2023-03-23 19:59:51','2023-03-23 19:59:51'),(2052,7525,41023,31904,3,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',711.24,NULL,NULL,1,'2023-03-23 19:14:26','2023-03-23 19:59:28','2023-03-23 19:59:28');
INSERT INTO `balance_libro` VALUES (2053,7525,41023,31904,3,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',28543.56,NULL,NULL,1,'2023-03-23 19:17:39','2023-03-23 19:59:51','2023-03-23 19:59:51'),(2054,7525,41023,31904,19,2054,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',2418108.43,'Asiento Apertura',NULL,1,'2023-03-23 19:58:48','2023-03-23 20:47:02','2023-03-23 20:47:02'),(2055,7525,41023,31904,19,2055,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',2418108.43,'Asiento Apertura',NULL,1,'2023-03-23 20:47:02','2023-03-23 20:47:02',NULL),(2056,8694,40917,19696,2,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',185500.74,NULL,NULL,1,'2023-03-24 17:27:13','2023-03-24 17:31:49','2023-03-24 17:31:49'),(2057,8694,40917,19696,2,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',60000.00,NULL,NULL,1,'2023-03-24 17:27:13','2023-03-24 17:34:11','2023-03-24 17:34:11'),(2058,8694,40917,19696,2,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',60000.00,NULL,NULL,1,'2023-03-24 17:27:13','2023-03-24 17:37:25','2023-03-24 17:37:25'),(2059,8694,40917,19696,2,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',39600.03,NULL,NULL,1,'2023-03-24 17:27:13','2023-03-24 17:39:11','2023-03-24 17:39:11'),(2060,8694,40917,19696,2,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',64420.27,NULL,NULL,1,'2023-03-24 17:27:13','2023-03-24 17:40:25','2023-03-24 17:40:25'),(2061,8694,40917,19696,2,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',185500.74,NULL,NULL,1,'2023-03-24 17:27:13','2023-03-24 17:41:31','2023-03-24 17:41:31'),(2062,8694,40917,19696,2,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',29900.07,NULL,NULL,1,'2023-03-24 17:27:13','2023-03-24 17:43:12','2023-03-24 17:43:12'),(2063,8694,40917,19696,2,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',74300.35,NULL,NULL,1,'2023-03-24 17:27:13','2023-03-24 17:44:04','2023-03-24 17:44:04'),(2064,8694,40917,19696,2,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',185500.74,NULL,NULL,1,'2023-03-24 17:27:13','2023-03-24 17:45:42','2023-03-24 17:45:42'),(2065,8694,40917,19696,2,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',107150.46,NULL,NULL,1,'2023-03-24 17:27:13','2023-03-24 17:50:31','2023-03-24 17:50:31'),(2066,8694,40917,19696,2,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',296501.06,NULL,NULL,1,'2023-03-24 17:27:13','2023-03-24 17:55:06','2023-03-24 17:55:06'),(2067,8694,40917,19696,2,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',15770.00,NULL,NULL,1,'2023-03-24 17:27:14','2023-03-24 17:57:34','2023-03-24 17:57:34'),(2068,8694,40917,19696,2,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',319001.25,NULL,NULL,1,'2023-03-24 17:27:14','2023-03-24 17:58:53','2023-03-24 17:58:53'),(2069,8694,40917,19696,2,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',16000.01,NULL,NULL,1,'2023-03-24 17:27:14','2023-03-24 18:00:04','2023-03-24 18:00:04'),(2070,8694,40917,19696,2,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',109560.79,NULL,NULL,1,'2023-03-24 17:27:14','2023-03-24 18:01:29','2023-03-24 18:01:29'),(2071,8694,40917,19696,2,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',176800.48,NULL,NULL,1,'2023-03-24 17:27:14','2023-03-24 18:02:36','2023-03-24 18:02:36');
INSERT INTO `balance_libro` VALUES (2072,8694,40917,19696,2,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',150000.68,NULL,NULL,1,'2023-03-24 17:27:14','2023-03-24 18:03:39','2023-03-24 18:03:39'),(2073,8694,40917,19696,2,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',161200.80,NULL,NULL,1,'2023-03-24 17:27:14','2023-03-24 18:04:47','2023-03-24 18:04:47'),(2074,8694,40917,19696,2,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',111000.13,NULL,NULL,1,'2023-03-24 17:27:14','2023-03-24 18:08:00','2023-03-24 18:08:00'),(2075,8694,40917,19696,2,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',131480.86,NULL,NULL,1,'2023-03-24 17:27:14','2023-03-24 18:09:00','2023-03-24 18:09:00'),(2076,8694,40917,19696,2,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',13920.01,NULL,NULL,1,'2023-03-24 17:27:14','2023-03-24 18:10:13','2023-03-24 18:10:13'),(2077,8694,40917,19696,2,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',13000.01,NULL,NULL,1,'2023-03-24 17:27:14','2023-03-24 18:11:34','2023-03-24 18:11:34'),(2078,8694,40917,19696,2,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',36300.18,NULL,NULL,1,'2023-03-24 17:27:14','2023-03-24 18:12:13','2023-03-24 18:12:13'),(2079,8694,40917,19696,3,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',8600.00,NULL,NULL,1,'2023-03-24 17:29:18','2023-03-24 18:26:58','2023-03-24 18:26:58'),(2080,8694,40917,19696,3,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',184899.73,NULL,NULL,1,'2023-03-24 17:29:18','2023-03-24 17:29:18',NULL),(2081,8694,40917,19696,3,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',204700.10,NULL,NULL,1,'2023-03-24 17:29:18','2023-03-24 18:30:46','2023-03-24 18:30:46'),(2082,8694,40917,19696,3,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',32046.86,NULL,NULL,1,'2023-03-24 17:29:18','2023-03-24 18:58:39','2023-03-24 18:58:39'),(2083,8694,40917,19696,3,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',160099.98,NULL,NULL,1,'2023-03-24 17:29:18','2023-03-24 19:03:07','2023-03-24 19:03:07'),(2084,8694,40917,19696,3,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',8000.00,NULL,NULL,1,'2023-03-24 17:29:19','2023-03-24 19:18:34','2023-03-24 19:18:34'),(2085,8694,40917,19696,3,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',52519.26,NULL,NULL,1,'2023-03-24 17:29:19','2023-03-24 19:16:50','2023-03-24 19:16:50'),(2086,8694,40917,19696,3,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',12038.17,NULL,NULL,1,'2023-03-24 17:29:19','2023-03-25 21:22:04','2023-03-25 21:22:04'),(2087,8694,40917,19696,3,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',166074.88,NULL,NULL,1,'2023-03-24 17:29:19','2023-03-24 19:47:16','2023-03-24 19:47:16'),(2088,8694,40917,19696,3,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',320933.76,NULL,NULL,1,'2023-03-24 17:29:19','2023-03-25 21:26:58','2023-03-25 21:26:58'),(2089,8694,40917,19696,3,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',20351.99,NULL,NULL,1,'2023-03-24 17:29:19','2023-03-25 21:26:43','2023-03-25 21:26:43'),(2090,8694,40917,19696,3,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',150469.81,NULL,NULL,1,'2023-03-24 17:29:19','2023-03-24 17:29:19',NULL);
INSERT INTO `balance_libro` VALUES (2091,8694,40917,19696,2,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',185500.74,NULL,NULL,1,'2023-03-24 17:31:49','2023-03-24 17:31:49',NULL),(2092,8694,40917,19696,2,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',60000.00,NULL,NULL,1,'2023-03-24 17:34:11','2023-03-24 17:34:11',NULL),(2093,8694,40917,19696,2,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',60000.00,NULL,NULL,1,'2023-03-24 17:37:25','2023-03-24 17:37:25',NULL),(2094,8694,40917,19696,2,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',39600.03,NULL,NULL,1,'2023-03-24 17:39:11','2023-03-24 17:39:11',NULL),(2095,8694,40917,19696,2,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',64420.28,NULL,NULL,1,'2023-03-24 17:40:25','2023-03-24 17:40:25',NULL),(2096,8694,40917,19696,2,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',185500.74,NULL,NULL,1,'2023-03-24 17:41:31','2023-03-24 17:41:31',NULL),(2097,8694,40917,19696,2,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',29900.07,NULL,NULL,1,'2023-03-24 17:43:12','2023-03-24 17:43:12',NULL),(2098,8694,40917,19696,2,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',74300.35,NULL,NULL,1,'2023-03-24 17:44:04','2023-03-24 17:44:04',NULL),(2099,8694,40917,19696,2,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',185500.74,NULL,NULL,1,'2023-03-24 17:45:42','2023-03-24 17:45:42',NULL),(2100,8694,40917,19696,2,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',107150.46,NULL,NULL,1,'2023-03-24 17:50:31','2023-03-24 17:50:31',NULL),(2101,8694,40917,19696,2,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',296501.06,NULL,NULL,1,'2023-03-24 17:55:06','2023-03-24 17:55:06',NULL),(2102,8694,40917,19696,2,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',15770.00,NULL,NULL,1,'2023-03-24 17:57:34','2023-03-24 17:57:34',NULL),(2103,8694,40917,19696,2,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',319001.25,NULL,NULL,1,'2023-03-24 17:58:53','2023-03-24 17:58:53',NULL),(2104,8694,40917,19696,2,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',16000.01,NULL,NULL,1,'2023-03-24 18:00:04','2023-03-24 18:00:04',NULL),(2105,8694,40917,19696,2,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',109560.78,NULL,NULL,1,'2023-03-24 18:01:29','2023-03-24 18:01:29',NULL),(2106,8694,40917,19696,2,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',176800.48,NULL,NULL,1,'2023-03-24 18:02:36','2023-03-24 18:02:36',NULL),(2107,8694,40917,19696,2,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',150000.67,NULL,NULL,1,'2023-03-24 18:03:39','2023-03-24 18:03:39',NULL),(2108,8694,40917,19696,2,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',161200.80,NULL,NULL,1,'2023-03-24 18:04:47','2023-03-24 18:04:47',NULL),(2109,8694,40917,19696,2,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',111000.14,NULL,NULL,1,'2023-03-24 18:08:00','2023-03-24 18:08:00',NULL),(2110,8694,40917,19696,2,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',131480.85,NULL,NULL,1,'2023-03-24 18:09:00','2023-03-24 18:09:00',NULL);
INSERT INTO `balance_libro` VALUES (2111,8694,40917,19696,2,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',13920.01,NULL,NULL,1,'2023-03-24 18:10:13','2023-03-24 18:10:13',NULL),(2112,8694,40917,19696,2,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',13000.01,NULL,NULL,1,'2023-03-24 18:11:34','2023-03-24 18:11:34',NULL),(2113,8694,40917,19696,2,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',36300.18,NULL,NULL,1,'2023-03-24 18:12:13','2023-03-24 18:12:13',NULL),(2114,8694,40917,19696,3,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',204700.12,NULL,NULL,1,'2023-03-24 18:30:46','2023-03-24 18:30:46',NULL),(2115,8694,40917,19696,3,1709,'App\\Models\\Receipt',1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',135217.48,NULL,NULL,1,'2023-03-24 18:39:56','2023-03-24 18:39:56',NULL),(2116,8694,40917,19696,3,1710,'App\\Models\\Receipt',1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',100051.69,NULL,NULL,1,'2023-03-24 18:42:50','2023-03-24 18:42:50',NULL),(2117,8694,40917,19696,3,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',49230.42,NULL,NULL,1,'2023-03-24 18:50:57','2023-03-24 18:50:57',NULL),(2118,8694,40917,19696,3,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',32046.86,NULL,NULL,1,'2023-03-24 18:58:39','2023-03-24 18:58:39',NULL),(2119,8694,40917,19696,3,1712,'App\\Models\\Receipt',1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',37056.01,NULL,NULL,1,'2023-03-24 19:00:53','2023-03-24 19:00:53',NULL),(2120,8694,40917,19696,3,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',160099.99,NULL,NULL,1,'2023-03-24 19:03:07','2023-03-24 19:03:07',NULL),(2121,8694,40917,19696,3,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',17126.64,NULL,NULL,1,'2023-03-24 19:10:13','2023-03-24 19:10:13',NULL),(2122,8694,40917,19696,3,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',150099.99,NULL,NULL,1,'2023-03-24 19:13:21','2023-03-24 19:13:21',NULL),(2123,8694,40917,19696,3,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',52519.25,NULL,NULL,1,'2023-03-24 19:16:50','2023-03-24 19:16:50',NULL),(2124,8694,40917,19696,3,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',8000.00,NULL,NULL,1,'2023-03-24 19:18:34','2023-03-24 19:18:34',NULL),(2125,8694,40917,19696,3,1715,'App\\Models\\Receipt',1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',100000.02,NULL,NULL,1,'2023-03-24 19:20:40','2023-03-24 19:20:40',NULL),(2126,8694,40917,19696,3,1716,'App\\Models\\Receipt',1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',203032.56,NULL,NULL,1,'2023-03-24 19:23:09','2023-03-24 19:23:09',NULL),(2127,7525,40839,12129,3,1717,'App\\Models\\Receipt',1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',11677.45,NULL,NULL,1,'2023-03-24 19:24:17','2023-03-24 19:24:17',NULL),(2128,7525,40839,12129,3,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',9000.29,NULL,NULL,1,'2023-03-24 19:24:59','2023-03-24 19:24:59',NULL),(2129,7525,40839,12129,3,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2777.00,NULL,NULL,1,'2023-03-24 19:29:24','2023-03-24 19:29:24',NULL),(2130,7525,40839,12129,3,1720,'App\\Models\\Receipt',1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',21800.00,NULL,NULL,1,'2023-03-24 19:30:30','2023-03-24 19:30:30',NULL);
INSERT INTO `balance_libro` VALUES (2131,8694,40917,19696,3,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',69972.42,NULL,NULL,1,'2023-03-24 19:36:07','2023-03-24 19:36:07',NULL),(2132,7525,40839,12129,7,1722,'App\\Models\\Receipt',1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7.00,NULL,NULL,1,'2023-03-24 19:36:55','2023-03-24 19:36:55',NULL),(2133,7525,40839,12123,15,19,'App\\Models\\PeriodLiquidation',NULL,19,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42368.08,NULL,NULL,1,'2023-03-24 19:46:10','2023-03-24 19:46:10',NULL),(2134,8694,40917,19696,3,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',166074.90,NULL,NULL,1,'2023-03-24 19:47:16','2023-03-24 19:47:16',NULL),(2135,8694,40917,19696,3,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',110589.08,NULL,NULL,1,'2023-03-24 19:50:09','2023-03-24 19:50:09',NULL),(2136,8694,40917,19696,3,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',63193.76,NULL,NULL,1,'2023-03-24 19:52:32','2023-03-24 19:52:32',NULL),(2137,7525,40839,12130,2,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',72600.00,NULL,NULL,1,'2023-03-24 22:04:53','2023-03-24 22:04:53',NULL),(2138,7525,40839,12130,2,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',82280.00,NULL,NULL,1,'2023-03-24 22:04:53','2023-03-24 22:04:53',NULL),(2139,7525,40839,12130,2,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',145200.00,NULL,NULL,1,'2023-03-24 22:04:53','2023-03-24 22:04:53',NULL),(2140,7525,40839,12130,2,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',181500.00,NULL,NULL,1,'2023-03-24 22:04:53','2023-03-24 22:04:53',NULL),(2141,7525,40839,12130,3,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',535.00,NULL,NULL,1,'2023-03-24 22:05:12','2023-03-24 22:39:57','2023-03-24 22:39:57'),(2142,7525,40839,12130,3,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',190.00,NULL,NULL,1,'2023-03-24 22:05:12','2023-03-24 22:39:42','2023-03-24 22:39:42'),(2143,7525,40839,12130,3,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1729.15,NULL,NULL,1,'2023-03-24 22:05:12','2023-03-24 22:39:30','2023-03-24 22:39:30'),(2144,7525,40839,12130,3,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',437.30,NULL,NULL,1,'2023-03-24 22:05:12','2023-03-24 22:56:00','2023-03-24 22:56:00'),(2145,7525,40839,12130,3,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',10000.00,NULL,NULL,1,'2023-03-24 22:05:12','2023-03-24 22:56:51','2023-03-24 22:56:51'),(2146,7525,40839,12130,3,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',21180.00,NULL,NULL,1,'2023-03-24 22:05:12','2023-03-24 22:57:06','2023-03-24 22:57:06'),(2147,7525,40839,12130,3,1735,'App\\Models\\Receipt',1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',115200.00,NULL,NULL,1,'2023-03-24 22:05:12','2023-03-24 22:05:12',NULL),(2148,7525,40839,12130,3,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',24300.00,NULL,NULL,1,'2023-03-24 22:05:12','2023-03-24 22:54:58','2023-03-24 22:54:58'),(2149,7525,40839,12130,3,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',8000.00,NULL,NULL,1,'2023-03-24 22:05:12','2023-03-24 22:43:56','2023-03-24 22:43:56'),(2150,7525,40839,12130,3,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',17056.78,NULL,NULL,1,'2023-03-24 22:05:12','2023-03-24 22:46:41','2023-03-24 22:46:41');
INSERT INTO `balance_libro` VALUES (2151,7525,40839,12130,3,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',16406.32,NULL,NULL,1,'2023-03-24 22:05:12','2023-03-24 22:45:34','2023-03-24 22:45:34'),(2152,7525,40839,12130,3,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',62990.00,NULL,NULL,1,'2023-03-24 22:05:12','2023-03-24 22:47:17','2023-03-24 22:47:17'),(2153,7525,40839,12130,3,1741,'App\\Models\\Receipt',1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',555.00,NULL,NULL,1,'2023-03-24 22:05:12','2023-03-24 22:39:11','2023-03-24 22:39:11'),(2154,7525,40839,12130,3,1742,'App\\Models\\Receipt',1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',1785.00,NULL,NULL,1,'2023-03-24 22:05:12','2023-03-24 22:39:00','2023-03-24 22:39:00'),(2155,7525,40839,12130,3,1743,'App\\Models\\Receipt',1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',212.39,NULL,NULL,1,'2023-03-24 22:05:12','2023-03-24 22:38:52','2023-03-24 22:38:52'),(2156,7525,40839,12130,3,1744,'App\\Models\\Receipt',1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',18410.05,NULL,NULL,1,'2023-03-24 22:05:12','2023-03-24 22:05:12',NULL),(2157,7525,40839,12130,3,1745,'App\\Models\\Receipt',1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',450.00,NULL,NULL,1,'2023-03-24 22:05:12','2023-03-24 22:38:44','2023-03-24 22:38:44'),(2158,7525,40839,12130,3,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',8000.00,NULL,NULL,1,'2023-03-24 22:43:56','2023-03-24 22:43:56',NULL),(2159,7525,40839,12130,3,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',16406.32,NULL,NULL,1,'2023-03-24 22:45:34','2023-03-24 23:18:57','2023-03-24 23:18:57'),(2160,7525,40839,12130,3,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',17056.78,NULL,NULL,1,'2023-03-24 22:46:41','2023-03-24 22:46:41',NULL),(2161,7525,40839,12130,3,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',62990.00,NULL,NULL,1,'2023-03-24 22:47:17','2023-03-24 22:47:17',NULL),(2162,7525,40839,12130,3,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',24299.99,NULL,NULL,1,'2023-03-24 22:54:58','2023-03-24 22:54:58',NULL),(2163,7525,40839,12130,3,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',426.25,NULL,NULL,1,'2023-03-24 22:56:00','2023-03-24 22:56:00',NULL),(2164,7525,40839,12130,3,1746,'App\\Models\\Receipt',1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',5444.69,NULL,NULL,1,'2023-03-24 23:05:47','2023-03-24 23:05:47',NULL),(2165,7525,40839,12130,3,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',5199.27,NULL,NULL,1,'2023-03-24 23:06:50','2023-03-24 23:06:50',NULL),(2166,7525,40839,12130,3,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',9301.53,NULL,NULL,1,'2023-03-24 23:07:23','2023-03-24 23:07:23',NULL),(2167,7525,40839,12130,3,1749,'App\\Models\\Receipt',1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',9100.02,NULL,NULL,1,'2023-03-24 23:08:11','2023-03-24 23:08:11',NULL),(2168,7525,40839,12130,3,1750,'App\\Models\\Receipt',1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',6347.01,NULL,NULL,1,'2023-03-24 23:08:50','2023-03-24 23:08:50',NULL),(2169,7525,40839,12130,3,1751,'App\\Models\\Receipt',1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',20500.00,NULL,NULL,1,'2023-03-24 23:09:53','2023-03-24 23:09:53',NULL),(2170,7525,40839,12130,3,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',7400.71,NULL,NULL,1,'2023-03-24 23:13:50','2023-03-24 23:13:50',NULL);
INSERT INTO `balance_libro` VALUES (2171,7525,40839,12130,3,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',5302.11,NULL,NULL,1,'2023-03-24 23:14:54','2023-03-24 23:14:54',NULL),(2172,7525,40839,12130,3,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',16237.76,NULL,NULL,1,'2023-03-24 23:18:57','2023-03-24 23:18:57',NULL),(2173,7525,40839,12129,15,1138,'App\\Models\\PeriodLiquidation',NULL,1138,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',308486.27,NULL,NULL,1,'2023-03-24 23:23:16','2023-03-24 23:23:16',NULL),(2174,7525,40839,12130,15,1142,'App\\Models\\PeriodLiquidation',NULL,1142,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',160551.99,NULL,NULL,1,'2023-03-24 23:32:57','2023-03-24 23:32:57',NULL),(2175,7525,40856,15157,3,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',7100.79,NULL,NULL,1,'2023-03-25 19:58:05','2023-03-25 20:02:14','2023-03-25 20:02:14'),(2176,7525,40856,15157,3,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',9005.70,NULL,NULL,1,'2023-03-25 19:58:22','2023-03-25 19:58:22',NULL),(2177,7525,40856,15157,3,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',5000.00,NULL,NULL,1,'2023-03-25 19:58:36','2023-03-25 19:58:36',NULL),(2178,7525,40856,15157,3,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',125.14,NULL,NULL,1,'2023-03-25 19:58:49','2023-03-25 19:58:49',NULL),(2179,7525,40856,15157,3,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',189.99,NULL,NULL,1,'2023-03-25 19:59:02','2023-03-25 19:59:02',NULL),(2180,7525,40856,15157,3,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',163.00,NULL,NULL,1,'2023-03-25 19:59:16','2023-03-25 19:59:16',NULL),(2181,7525,40856,15157,3,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',68.00,NULL,NULL,1,'2023-03-25 19:59:55','2023-03-25 19:59:55',NULL),(2182,7525,40856,15157,3,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1812.00,NULL,NULL,1,'2023-03-25 20:00:15','2023-03-25 20:00:15',NULL),(2183,7525,40856,15157,3,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',7100.79,NULL,NULL,1,'2023-03-25 20:02:14','2023-03-25 20:02:14',NULL),(2184,8694,41011,25750,2,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',26399.98,NULL,NULL,1,'2023-03-25 20:19:49','2023-03-25 20:23:36','2023-03-25 20:23:36'),(2185,8694,41011,25750,2,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',53310.36,NULL,NULL,1,'2023-03-25 20:19:49','2023-03-25 20:24:33','2023-03-25 20:24:33'),(2186,8694,41011,25750,2,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',69450.01,NULL,NULL,1,'2023-03-25 20:19:49','2023-03-25 20:25:49','2023-03-25 20:25:49'),(2187,8694,41011,25750,2,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',8000.01,NULL,NULL,1,'2023-03-25 20:19:49','2023-03-25 20:26:39','2023-03-25 20:26:39'),(2188,8694,41011,25750,2,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',37140.00,NULL,NULL,1,'2023-03-25 20:19:49','2023-03-25 20:27:31','2023-03-25 20:27:31'),(2189,8694,41011,25750,2,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',22830.01,NULL,NULL,1,'2023-03-25 20:19:49','2023-03-25 20:28:51','2023-03-25 20:28:51'),(2190,8694,41011,25750,2,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',29700.00,NULL,NULL,1,'2023-03-25 20:19:49','2023-03-25 20:31:02','2023-03-25 20:31:02');
INSERT INTO `balance_libro` VALUES (2191,8694,41011,25750,2,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30700.01,NULL,NULL,1,'2023-03-25 20:19:50','2023-03-25 20:31:38','2023-03-25 20:31:38'),(2192,8694,41011,25750,2,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',20700.00,NULL,NULL,1,'2023-03-25 20:19:50','2023-03-25 20:32:17','2023-03-25 20:32:17'),(2193,8694,41011,25750,2,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',14450.00,NULL,NULL,1,'2023-03-25 20:19:50','2023-03-25 20:33:01','2023-03-25 20:33:01'),(2194,8694,41011,25750,2,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',46299.98,NULL,NULL,1,'2023-03-25 20:19:50','2023-03-25 20:34:13','2023-03-25 20:34:13'),(2195,8694,41011,25750,2,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',47824.04,NULL,NULL,1,'2023-03-25 20:19:50','2023-03-25 20:34:59','2023-03-25 20:34:59'),(2196,8694,41011,25750,2,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',172957.40,NULL,NULL,1,'2023-03-25 20:19:50','2023-03-25 20:35:50','2023-03-25 20:35:50'),(2197,8694,41011,25750,3,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',19890.00,NULL,NULL,1,'2023-03-25 20:20:48','2023-03-25 21:08:54','2023-03-25 21:08:54'),(2198,8694,41011,25750,3,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',7620.07,NULL,NULL,1,'2023-03-25 20:20:48','2023-03-25 21:08:08','2023-03-25 21:08:08'),(2199,8694,41011,25750,3,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',29614.00,NULL,NULL,1,'2023-03-25 20:20:48','2023-03-25 21:09:49','2023-03-25 21:09:49'),(2200,8694,41011,25750,3,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',22321.00,NULL,NULL,1,'2023-03-25 20:20:48','2023-03-25 20:20:48',NULL),(2201,8694,41011,25750,3,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',6777.98,NULL,NULL,1,'2023-03-25 20:20:48','2023-03-25 21:13:31','2023-03-25 21:13:31'),(2202,8694,41011,25750,3,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',19890.00,NULL,NULL,1,'2023-03-25 20:20:48','2023-03-25 21:24:15','2023-03-25 21:24:15'),(2203,8694,41011,25750,3,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',5793.68,NULL,NULL,1,'2023-03-25 20:20:48','2023-03-25 21:23:07','2023-03-25 21:23:07'),(2204,8694,41011,25750,3,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',7077.12,NULL,NULL,1,'2023-03-25 20:20:48','2023-03-25 21:37:21','2023-03-25 21:37:21'),(2205,8694,41011,25750,3,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',6037.70,NULL,NULL,1,'2023-03-25 20:20:48','2023-03-25 21:30:48','2023-03-25 21:30:48'),(2206,8694,41011,25750,3,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',25171.90,NULL,NULL,1,'2023-03-25 20:20:48','2023-03-25 20:20:48',NULL),(2207,8694,41011,25750,3,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',6507.06,NULL,NULL,1,'2023-03-25 20:20:48','2023-03-25 21:40:23','2023-03-25 21:40:23'),(2208,8694,41011,25750,3,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',30387.50,NULL,NULL,1,'2023-03-25 20:20:48','2023-03-25 21:41:31','2023-03-25 21:41:31'),(2209,8694,41011,25750,3,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',19735.30,NULL,NULL,1,'2023-03-25 20:20:48','2023-03-25 20:20:48',NULL);
INSERT INTO `balance_libro` VALUES (2210,8694,41011,25750,3,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',8304.54,NULL,NULL,1,'2023-03-25 20:20:48','2023-03-25 21:44:25','2023-03-25 21:44:25'),(2211,8694,41011,25750,3,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',8500.00,NULL,NULL,1,'2023-03-25 20:20:48','2023-03-25 21:46:11','2023-03-25 21:46:11'),(2212,8694,41011,25750,3,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',19890.00,NULL,NULL,1,'2023-03-25 20:20:49','2023-03-25 21:47:09','2023-03-25 21:47:09'),(2213,8694,41011,25750,3,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',9206.52,NULL,NULL,1,'2023-03-25 20:20:49','2023-03-25 21:49:40','2023-03-25 21:49:40'),(2214,8694,41011,25750,3,1784,'App\\Models\\Receipt',1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',25857.00,NULL,NULL,1,'2023-03-25 20:20:49','2023-03-25 20:20:49',NULL),(2215,8694,41011,25750,3,1785,'App\\Models\\Receipt',1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',50531.65,NULL,NULL,1,'2023-03-25 20:20:49','2023-03-25 20:20:49',NULL),(2216,8694,41011,25750,3,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',6985.51,NULL,NULL,1,'2023-03-25 20:20:49','2023-03-25 21:58:00','2023-03-25 21:58:00'),(2217,8694,41011,25750,3,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',19890.00,NULL,NULL,1,'2023-03-25 20:20:49','2023-03-25 21:59:19','2023-03-25 21:59:19'),(2218,8694,41011,25750,3,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',23459.15,NULL,NULL,1,'2023-03-25 20:20:49','2023-03-25 20:20:49',NULL),(2219,8694,41011,25750,3,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',5399.83,NULL,NULL,1,'2023-03-25 20:20:49','2023-03-25 22:08:47','2023-03-25 22:08:47'),(2220,8694,41011,25750,3,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',6232.85,NULL,NULL,1,'2023-03-25 20:20:49','2023-03-25 22:13:00','2023-03-25 22:13:00'),(2221,8694,41011,25750,3,1791,'App\\Models\\Receipt',1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',53868.75,NULL,NULL,1,'2023-03-25 20:20:49','2023-03-25 20:20:49',NULL),(2222,8694,41011,25750,3,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',75140.00,NULL,NULL,1,'2023-03-25 20:20:49','2023-03-25 22:18:05','2023-03-25 22:18:05'),(2223,8694,41011,25750,3,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5938.11,NULL,NULL,1,'2023-03-25 20:20:49','2023-03-25 22:16:24','2023-03-25 22:16:24'),(2224,7525,40875,16669,2,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',14999.99,NULL,NULL,1,'2023-03-25 20:23:35','2023-03-25 20:23:35',NULL),(2225,8694,41011,25750,2,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',26399.99,NULL,NULL,1,'2023-03-25 20:23:36','2023-03-25 20:23:36',NULL),(2226,7525,40875,16669,2,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',6000.00,NULL,NULL,1,'2023-03-25 20:23:55','2023-03-25 20:23:55',NULL),(2227,7525,40875,16669,2,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',6775.00,NULL,NULL,1,'2023-03-25 20:24:11','2023-03-25 20:24:11',NULL),(2228,8694,41011,25750,2,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',53310.36,NULL,NULL,1,'2023-03-25 20:24:33','2023-03-25 20:24:33',NULL),(2229,7525,40875,16669,2,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',20950.00,NULL,NULL,1,'2023-03-25 20:24:44','2023-03-25 20:25:09','2023-03-25 20:25:09');
INSERT INTO `balance_libro` VALUES (2230,7525,40875,16669,2,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',20950.00,NULL,NULL,1,'2023-03-25 20:25:09','2023-03-25 20:25:09',NULL),(2231,7525,40875,16669,2,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',106000.01,NULL,NULL,1,'2023-03-25 20:25:25','2023-03-25 20:25:25',NULL),(2232,7525,40875,16669,2,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',4800.00,NULL,NULL,1,'2023-03-25 20:25:41','2023-03-25 20:25:41',NULL),(2233,8694,41011,25750,2,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',69450.01,NULL,NULL,1,'2023-03-25 20:25:49','2023-03-25 20:25:49',NULL),(2234,7525,40875,16669,3,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',23798.35,NULL,NULL,1,'2023-03-25 20:26:36','2023-03-25 20:26:36',NULL),(2235,8694,41011,25750,2,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',8000.00,NULL,NULL,1,'2023-03-25 20:26:39','2023-03-25 20:26:39',NULL),(2236,8694,41011,25750,2,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',37140.01,NULL,NULL,1,'2023-03-25 20:27:31','2023-03-25 20:27:31',NULL),(2237,7525,40875,16669,3,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',549.93,NULL,NULL,1,'2023-03-25 20:27:54','2023-03-25 20:27:54',NULL),(2238,8694,41011,25750,2,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',22830.01,NULL,NULL,1,'2023-03-25 20:28:51','2023-03-25 20:28:51',NULL),(2239,8694,41011,25750,2,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',29699.99,NULL,NULL,1,'2023-03-25 20:31:02','2023-03-25 20:31:02',NULL),(2240,8694,41011,25750,2,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30700.01,NULL,NULL,1,'2023-03-25 20:31:38','2023-03-25 20:31:38',NULL),(2241,8694,41011,25750,2,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',20700.00,NULL,NULL,1,'2023-03-25 20:32:17','2023-03-25 20:32:17',NULL),(2242,8694,41011,25750,2,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',14450.01,NULL,NULL,1,'2023-03-25 20:33:01','2023-03-25 20:33:01',NULL),(2243,7525,40875,16663,15,181,'App\\Models\\PeriodLiquidation',NULL,181,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',240618.76,NULL,NULL,1,'2023-03-25 20:33:48','2023-03-25 20:33:48',NULL),(2244,7525,40875,16664,15,493,'App\\Models\\PeriodLiquidation',NULL,493,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',389086.24,NULL,NULL,1,'2023-03-25 20:34:11','2023-03-25 20:34:11',NULL),(2245,8694,41011,25750,2,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',46300.00,NULL,NULL,1,'2023-03-25 20:34:13','2023-03-25 20:34:13',NULL),(2246,7525,40875,16668,15,778,'App\\Models\\PeriodLiquidation',NULL,778,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',411591.32,NULL,NULL,1,'2023-03-25 20:34:43','2023-03-25 20:34:43',NULL),(2247,8694,41011,25750,2,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',47824.04,NULL,NULL,1,'2023-03-25 20:34:59','2023-03-25 20:34:59',NULL),(2248,8694,41011,25750,2,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',172957.40,NULL,NULL,1,'2023-03-25 20:35:50','2023-03-25 20:35:50',NULL),(2249,7525,40875,16669,3,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',886.45,NULL,NULL,1,'2023-03-25 20:39:15','2023-03-25 20:39:15',NULL);
INSERT INTO `balance_libro` VALUES (2250,7525,40875,16669,15,1191,'App\\Models\\PeriodLiquidation',NULL,1191,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',70855.90,NULL,NULL,1,'2023-03-25 20:57:56','2023-03-25 20:57:56',NULL),(2251,7525,40906,18175,15,188,'App\\Models\\PeriodLiquidation',NULL,188,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',70002.06,NULL,NULL,1,'2023-03-25 21:00:52','2023-03-25 21:00:52',NULL),(2252,7525,40906,18176,15,533,'App\\Models\\PeriodLiquidation',NULL,533,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',144268.08,NULL,NULL,1,'2023-03-25 21:01:18','2023-03-25 21:01:18',NULL),(2253,7525,40906,18180,15,814,'App\\Models\\PeriodLiquidation',NULL,814,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',69119.32,NULL,NULL,1,'2023-03-25 21:01:40','2023-03-25 21:01:40',NULL),(2254,7525,41011,25743,15,278,'App\\Models\\PeriodLiquidation',NULL,278,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',33277.40,NULL,NULL,1,'2023-03-25 21:02:42','2023-03-25 21:02:42',NULL),(2255,7525,41011,25744,15,279,'App\\Models\\PeriodLiquidation',NULL,279,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',88616.09,NULL,NULL,1,'2023-03-25 21:02:59','2023-03-25 21:02:59',NULL),(2256,7525,41011,25745,15,812,'App\\Models\\PeriodLiquidation',NULL,812,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',117617.24,NULL,NULL,1,'2023-03-25 21:03:47','2023-03-25 21:03:47',NULL),(2257,7525,41011,25749,15,813,'App\\Models\\PeriodLiquidation',NULL,813,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',117525.86,NULL,NULL,1,'2023-03-25 21:04:11','2023-03-25 21:04:11',NULL),(2258,8694,41011,25750,3,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',7620.07,NULL,NULL,1,'2023-03-25 21:08:08','2023-03-25 21:08:08',NULL),(2259,8694,41011,25750,3,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',19890.00,NULL,NULL,1,'2023-03-25 21:08:54','2023-03-25 21:08:54',NULL),(2260,8694,41011,25750,3,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',29614.00,NULL,NULL,1,'2023-03-25 21:09:49','2023-03-25 21:09:49',NULL),(2261,8694,41011,25750,3,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',6777.98,NULL,NULL,1,'2023-03-25 21:13:31','2023-03-25 21:13:31',NULL),(2262,8694,41011,25750,3,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3858.18,NULL,NULL,1,'2023-03-25 21:19:25','2023-03-25 21:19:25',NULL),(2263,7525,40917,19696,3,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',13634.14,NULL,NULL,1,'2023-03-25 21:22:04','2023-03-25 21:29:55','2023-03-25 21:29:55'),(2264,8694,41011,25750,3,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',5793.68,NULL,NULL,1,'2023-03-25 21:23:07','2023-03-25 21:23:07',NULL),(2265,8694,41011,25750,3,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',19890.00,NULL,NULL,1,'2023-03-25 21:24:15','2023-03-25 21:24:15',NULL),(2266,7525,40917,19689,15,212,'App\\Models\\PeriodLiquidation',NULL,212,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',770256.72,NULL,NULL,1,'2023-03-25 21:24:35','2023-03-25 21:24:35',NULL),(2267,7525,40917,19690,15,214,'App\\Models\\PeriodLiquidation',NULL,214,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1138522.73,NULL,NULL,1,'2023-03-25 21:24:59','2023-03-25 21:24:59',NULL),(2268,7525,40917,19691,15,557,'App\\Models\\PeriodLiquidation',NULL,557,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1224046.27,NULL,NULL,1,'2023-03-25 21:25:16','2023-03-25 21:25:16',NULL),(2269,7525,40917,19695,15,838,'App\\Models\\PeriodLiquidation',NULL,838,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1196484.93,NULL,NULL,1,'2023-03-25 21:26:11','2023-03-25 21:26:11',NULL);
INSERT INTO `balance_libro` VALUES (2270,7525,40917,19696,3,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',11863.26,NULL,NULL,1,'2023-03-25 21:29:55','2023-03-25 21:29:55',NULL),(2271,8694,41011,25750,3,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',6037.69,NULL,NULL,1,'2023-03-25 21:30:48','2023-03-25 21:30:48',NULL),(2272,7525,40917,19696,7,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1321.00,NULL,NULL,1,'2023-03-25 21:35:03','2023-03-25 21:35:03',NULL),(2273,8694,41011,25750,3,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',7077.12,NULL,NULL,1,'2023-03-25 21:37:21','2023-03-25 21:37:21',NULL),(2274,8694,41011,25750,3,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',6507.08,NULL,NULL,1,'2023-03-25 21:40:23','2023-03-25 21:40:23',NULL),(2275,8694,41011,25750,3,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',30387.50,NULL,NULL,1,'2023-03-25 21:41:31','2023-03-25 21:41:31',NULL),(2276,8694,41011,25750,3,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',8304.54,NULL,NULL,1,'2023-03-25 21:44:25','2023-03-25 21:44:25',NULL),(2277,8694,41011,25750,3,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',8500.00,NULL,NULL,1,'2023-03-25 21:46:11','2023-03-25 21:46:11',NULL),(2278,8694,41011,25750,3,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',19890.00,NULL,NULL,1,'2023-03-25 21:47:09','2023-03-25 21:47:09',NULL),(2279,8694,41011,25750,3,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',9206.52,NULL,NULL,1,'2023-03-25 21:49:40','2023-03-25 21:49:40',NULL),(2280,8694,41011,25750,3,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',5781.00,NULL,NULL,1,'2023-03-25 21:53:55','2023-03-25 21:53:55',NULL),(2281,7525,40917,19696,15,1205,'App\\Models\\PeriodLiquidation',NULL,1205,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1148115.19,NULL,NULL,1,'2023-03-25 21:55:32','2023-03-25 21:55:32',NULL),(2282,8694,41011,25750,3,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',6985.52,NULL,NULL,1,'2023-03-25 21:58:00','2023-03-25 21:58:00',NULL),(2283,8694,41011,25750,3,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',19890.00,NULL,NULL,1,'2023-03-25 21:59:19','2023-03-25 21:59:19',NULL),(2284,8694,41011,25750,3,1797,'App\\Models\\Receipt',1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',9244.04,NULL,NULL,1,'2023-03-25 22:04:53','2023-03-25 22:54:41','2023-03-25 22:54:41'),(2285,8694,41011,25750,3,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',5399.82,NULL,NULL,1,'2023-03-25 22:08:47','2023-03-25 22:08:47',NULL),(2286,8694,41011,25750,3,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',6232.85,NULL,NULL,1,'2023-03-25 22:13:00','2023-03-25 22:13:00',NULL),(2287,8694,41011,25750,3,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5938.12,NULL,NULL,1,'2023-03-25 22:16:24','2023-03-25 22:16:24',NULL),(2288,8694,41011,25750,3,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',75140.00,NULL,NULL,1,'2023-03-25 22:18:05','2023-03-25 22:18:05',NULL),(2289,8694,40906,18181,2,1798,'App\\Models\\Receipt',1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',35000.00,NULL,NULL,1,'2023-03-25 22:27:22','2023-03-25 22:37:22','2023-03-25 22:37:22');
INSERT INTO `balance_libro` VALUES (2290,8694,40906,18181,2,1799,'App\\Models\\Receipt',1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',225000.00,NULL,NULL,1,'2023-03-25 22:27:22','2023-03-25 22:39:04','2023-03-25 22:39:04'),(2291,8694,40906,18181,2,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',105000.00,NULL,NULL,1,'2023-03-25 22:27:22','2023-03-25 22:39:56','2023-03-25 22:39:56'),(2292,8694,40906,18181,2,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',128142.00,NULL,NULL,1,'2023-03-25 22:27:22','2023-03-25 22:41:22','2023-03-25 22:41:22'),(2293,8694,40906,18181,3,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',8000.00,NULL,NULL,1,'2023-03-25 22:28:16','2023-03-25 22:42:29','2023-03-25 22:42:29'),(2294,8694,40906,18181,3,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',145200.00,NULL,NULL,1,'2023-03-25 22:28:16','2023-03-25 22:43:02','2023-03-25 22:43:02'),(2295,8694,40906,18181,2,1798,'App\\Models\\Receipt',1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',35000.00,NULL,NULL,1,'2023-03-25 22:37:22','2023-03-25 22:37:22',NULL),(2296,8694,40906,18181,2,1799,'App\\Models\\Receipt',1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',225000.01,NULL,NULL,1,'2023-03-25 22:39:04','2023-03-25 22:39:04',NULL),(2297,8694,40906,18181,2,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',105000.01,NULL,NULL,1,'2023-03-25 22:39:56','2023-03-25 22:39:56',NULL),(2298,8694,40906,18181,2,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',128141.99,NULL,NULL,1,'2023-03-25 22:41:22','2023-03-25 22:41:22',NULL),(2299,8694,40906,18181,3,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',8000.00,NULL,NULL,1,'2023-03-25 22:42:29','2023-03-25 22:42:29',NULL),(2300,8694,40906,18181,3,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',145200.00,NULL,NULL,1,'2023-03-25 22:43:02','2023-03-25 22:43:02',NULL),(2301,7525,41011,25750,3,1797,'App\\Models\\Receipt',1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',9244.04,NULL,NULL,1,'2023-03-25 22:54:41','2023-03-25 22:54:41',NULL),(2302,7525,41011,25750,15,1221,'App\\Models\\PeriodLiquidation',NULL,1221,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',175534.92,NULL,NULL,1,'2023-03-25 23:08:59','2023-03-25 23:08:59',NULL),(2303,7525,40915,22718,15,558,'App\\Models\\PeriodLiquidation',NULL,558,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',55531.32,NULL,NULL,1,'2023-03-25 23:11:01','2023-03-25 23:11:01',NULL),(2304,7525,40915,22722,15,840,'App\\Models\\PeriodLiquidation',NULL,840,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',49620.90,NULL,NULL,1,'2023-03-25 23:11:24','2023-03-25 23:11:24',NULL),(2305,7525,40915,22717,15,228,'App\\Models\\PeriodLiquidation',NULL,228,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',43911.75,NULL,NULL,1,'2023-03-25 23:11:48','2023-03-25 23:11:48',NULL),(2306,7525,40991,24232,15,280,'App\\Models\\PeriodLiquidation',NULL,280,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',120479.69,NULL,NULL,1,'2023-03-25 23:12:37','2023-03-25 23:12:37',NULL),(2307,7525,40991,24233,15,578,'App\\Models\\PeriodLiquidation',NULL,578,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',44577.25,NULL,NULL,1,'2023-03-25 23:12:55','2023-03-25 23:12:55',NULL),(2308,7525,40991,24237,15,893,'App\\Models\\PeriodLiquidation',NULL,893,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',171064.32,NULL,NULL,1,'2023-03-25 23:13:20','2023-03-25 23:13:20',NULL),(2309,7525,40906,18181,7,1804,'App\\Models\\Receipt',1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',22239.52,NULL,NULL,1,'2023-03-25 23:23:36','2023-03-25 23:23:36',NULL);
INSERT INTO `balance_libro` VALUES (2310,7525,40906,18181,7,1805,'App\\Models\\Receipt',1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',57272.73,NULL,NULL,1,'2023-03-25 23:24:03','2023-03-25 23:24:03',NULL),(2311,7525,40906,18181,15,1222,'App\\Models\\PeriodLiquidation',NULL,1222,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',173831.57,NULL,NULL,1,'2023-03-25 23:54:02','2023-03-25 23:54:02',NULL),(2312,8694,41204,30282,2,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',284592.00,NULL,NULL,1,'2023-03-26 19:21:44','2023-03-26 19:25:15','2023-03-26 19:25:15'),(2313,8694,41204,30282,2,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',393250.00,NULL,NULL,1,'2023-03-26 19:21:44','2023-03-26 19:26:11','2023-03-26 19:26:11'),(2314,8694,41204,30282,2,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',280962.00,NULL,NULL,1,'2023-03-26 19:21:44','2023-03-26 19:27:01','2023-03-26 19:27:01'),(2315,8694,41204,30282,2,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',397720.95,NULL,NULL,1,'2023-03-26 19:21:44','2023-03-26 19:27:50','2023-03-26 19:27:50'),(2316,8694,41204,30282,2,1810,'App\\Models\\Receipt',1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',295845.00,NULL,NULL,1,'2023-03-26 19:21:44','2023-03-26 19:28:32','2023-03-26 19:28:32'),(2317,8694,41204,30282,3,1811,'App\\Models\\Receipt',1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',6145.69,NULL,NULL,1,'2023-03-26 19:22:53','2023-03-26 19:22:53',NULL),(2318,8694,41204,30282,3,1812,'App\\Models\\Receipt',1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',6145.69,NULL,NULL,1,'2023-03-26 19:22:53','2023-03-26 19:22:53',NULL),(2319,8694,41204,30282,3,1813,'App\\Models\\Receipt',1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',57311.55,NULL,NULL,1,'2023-03-26 19:22:53','2023-03-26 19:40:55','2023-03-26 19:40:55'),(2320,8694,41204,30282,3,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',20500.22,NULL,NULL,1,'2023-03-26 19:22:53','2023-03-26 19:50:06','2023-03-26 19:50:06'),(2321,8694,41204,30282,3,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',3400.00,NULL,NULL,1,'2023-03-26 19:22:53','2023-03-26 19:52:16','2023-03-26 19:52:16'),(2322,8694,41204,30282,3,1816,'App\\Models\\Receipt',1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',6227.43,NULL,NULL,1,'2023-03-26 19:22:53','2023-03-26 19:53:42','2023-03-26 19:53:42'),(2323,8694,41204,30282,3,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',91650.00,NULL,NULL,1,'2023-03-26 19:22:53','2023-03-26 19:54:49','2023-03-26 19:54:49'),(2324,8694,41204,30282,3,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',4483.67,NULL,NULL,1,'2023-03-26 19:22:53','2023-03-26 19:57:47','2023-03-26 19:57:47'),(2325,8694,41204,30282,3,1819,'App\\Models\\Receipt',1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',18379.93,NULL,NULL,1,'2023-03-26 19:22:53','2023-03-26 19:56:19','2023-03-26 19:56:19'),(2326,8694,41204,30282,3,1820,'App\\Models\\Receipt',1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',257730.00,NULL,NULL,1,'2023-03-26 19:22:53','2023-03-26 20:09:29','2023-03-26 20:09:29'),(2327,8694,41204,30282,3,1821,'App\\Models\\Receipt',1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',172957.40,NULL,NULL,1,'2023-03-26 19:22:53','2023-03-26 20:06:29','2023-03-26 20:06:29'),(2328,8694,41204,30282,3,1822,'App\\Models\\Receipt',1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',179836.25,NULL,NULL,1,'2023-03-26 19:22:53','2023-03-26 20:08:12','2023-03-26 20:08:12');
INSERT INTO `balance_libro` VALUES (2329,8694,41204,30282,3,1823,'App\\Models\\Receipt',1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4360.05,NULL,NULL,1,'2023-03-26 19:22:53','2023-03-26 20:04:41','2023-03-26 20:04:41'),(2330,8694,41204,30282,3,1824,'App\\Models\\Receipt',1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',151966.32,NULL,NULL,1,'2023-03-26 19:22:53','2023-03-26 20:07:15','2023-03-26 20:07:15'),(2331,8694,41204,30282,2,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',284592.00,NULL,NULL,1,'2023-03-26 19:25:15','2023-03-26 19:25:15',NULL),(2332,8694,41204,30282,2,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',393250.00,NULL,NULL,1,'2023-03-26 19:26:11','2023-03-26 19:26:11',NULL),(2333,8694,41204,30282,2,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',280962.00,NULL,NULL,1,'2023-03-26 19:27:01','2023-03-26 19:27:01',NULL),(2334,8694,41204,30282,2,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',397720.95,NULL,NULL,1,'2023-03-26 19:27:50','2023-03-26 19:27:50',NULL),(2335,8694,41204,30282,2,1810,'App\\Models\\Receipt',1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',295845.00,NULL,NULL,1,'2023-03-26 19:28:32','2023-03-26 19:28:32',NULL),(2336,8694,41204,30282,3,1825,'App\\Models\\Receipt',1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',9303.92,NULL,NULL,1,'2023-03-26 19:38:07','2023-03-26 19:38:07',NULL),(2337,8694,41204,30282,3,1813,'App\\Models\\Receipt',1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',57311.55,NULL,NULL,1,'2023-03-26 19:40:55','2023-03-26 19:40:55',NULL),(2338,8694,41204,30282,3,1826,'App\\Models\\Receipt',1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',8900.00,NULL,NULL,1,'2023-03-26 19:48:30','2023-03-26 19:48:30',NULL),(2339,8694,41204,30282,3,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',20500.22,NULL,NULL,1,'2023-03-26 19:50:06','2023-03-26 19:50:06',NULL),(2340,8694,41204,30282,3,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',3400.00,NULL,NULL,1,'2023-03-26 19:52:16','2023-03-26 19:52:16',NULL),(2341,8694,41204,30282,3,1816,'App\\Models\\Receipt',1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',6227.43,NULL,NULL,1,'2023-03-26 19:53:42','2023-03-26 19:53:42',NULL),(2342,8694,41204,30282,3,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',91650.00,NULL,NULL,1,'2023-03-26 19:54:49','2023-03-26 19:54:49',NULL),(2343,8694,41204,30282,3,1819,'App\\Models\\Receipt',1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',18379.93,NULL,NULL,1,'2023-03-26 19:56:19','2023-03-26 19:56:19',NULL),(2344,8694,41204,30282,3,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',4483.67,NULL,NULL,1,'2023-03-26 19:57:47','2023-03-26 19:57:47',NULL),(2345,8694,41204,30282,3,1827,'App\\Models\\Receipt',1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2600.00,NULL,NULL,1,'2023-03-26 20:01:56','2023-03-26 20:01:56',NULL),(2346,8694,41204,30282,3,1823,'App\\Models\\Receipt',1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4360.05,NULL,NULL,1,'2023-03-26 20:04:41','2023-03-26 20:04:41',NULL),(2347,8694,41204,30282,3,1821,'App\\Models\\Receipt',1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',172957.40,NULL,NULL,1,'2023-03-26 20:06:29','2023-03-26 20:06:29',NULL),(2348,8694,41204,30282,3,1824,'App\\Models\\Receipt',1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',151966.32,NULL,NULL,1,'2023-03-26 20:07:15','2023-03-26 20:07:15',NULL);
INSERT INTO `balance_libro` VALUES (2349,8694,41204,30282,3,1822,'App\\Models\\Receipt',1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',179836.25,NULL,NULL,1,'2023-03-26 20:08:12','2023-03-26 20:08:12',NULL),(2350,8694,41204,30282,3,1820,'App\\Models\\Receipt',1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',257730.00,NULL,NULL,1,'2023-03-26 20:09:29','2023-03-26 20:09:29',NULL),(2351,8694,40915,22723,2,1828,'App\\Models\\Receipt',1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',77502.92,NULL,NULL,1,'2023-03-26 20:15:12','2023-03-26 20:19:05','2023-03-26 20:19:05'),(2352,8694,40915,22723,2,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',31251.88,NULL,NULL,1,'2023-03-26 20:15:13','2023-03-26 20:19:39','2023-03-26 20:19:39'),(2353,8694,40915,22723,2,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',102462.80,NULL,NULL,1,'2023-03-26 20:15:13','2023-03-26 20:20:41','2023-03-26 20:20:41'),(2354,8694,40915,22723,2,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',85305.00,NULL,NULL,1,'2023-03-26 20:15:13','2023-03-26 20:21:27','2023-03-26 20:21:27'),(2355,8694,40915,22723,2,1832,'App\\Models\\Receipt',1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',151966.32,NULL,NULL,1,'2023-03-26 20:15:13','2023-03-26 20:22:55','2023-03-26 20:22:55'),(2356,8694,40915,22723,3,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',20715.84,NULL,NULL,1,'2023-03-26 20:16:20','2023-03-26 20:36:04','2023-03-26 20:36:04'),(2357,8694,40915,22723,3,1834,'App\\Models\\Receipt',1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',32286.81,NULL,NULL,1,'2023-03-26 20:16:20','2023-03-26 20:45:48','2023-03-26 20:45:48'),(2358,8694,40915,22723,3,1835,'App\\Models\\Receipt',1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',19249.12,NULL,NULL,1,'2023-03-26 20:16:20','2023-03-26 20:49:31','2023-03-26 20:49:31'),(2359,8694,40915,22723,3,1836,'App\\Models\\Receipt',1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',50000.00,NULL,NULL,1,'2023-03-26 20:16:20','2023-03-26 20:50:42','2023-03-26 20:50:42'),(2360,8694,40915,22723,3,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',75549.46,NULL,NULL,1,'2023-03-26 20:16:20','2023-03-26 20:57:14','2023-03-26 20:57:14'),(2361,8694,40915,22723,3,1838,'App\\Models\\Receipt',1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',23083.05,NULL,NULL,1,'2023-03-26 20:16:20','2023-03-26 20:16:20',NULL),(2362,8694,40915,22723,3,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',14697.54,NULL,NULL,1,'2023-03-26 20:16:20','2023-03-26 20:59:00','2023-03-26 20:59:00'),(2363,8694,40915,22723,3,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',8000.00,NULL,NULL,1,'2023-03-26 20:16:20','2023-03-26 21:02:30','2023-03-26 21:02:30'),(2364,8694,40915,22723,3,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',14585.34,NULL,NULL,1,'2023-03-26 20:16:20','2023-03-26 21:03:36','2023-03-26 21:03:36'),(2365,8694,40915,22723,3,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',23133.99,NULL,NULL,1,'2023-03-26 20:16:20','2023-03-26 21:05:16','2023-03-26 21:05:16'),(2366,8694,40915,22723,3,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',69183.93,NULL,NULL,1,'2023-03-26 20:16:20','2023-03-26 21:04:34','2023-03-26 21:04:34'),(2367,8694,40915,22723,3,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',17227.98,NULL,NULL,1,'2023-03-26 20:16:20','2023-03-26 21:07:16','2023-03-26 21:07:16');
INSERT INTO `balance_libro` VALUES (2368,8694,40915,22723,3,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',15500.00,NULL,NULL,1,'2023-03-26 20:16:20','2023-03-26 21:12:01','2023-03-26 21:12:01'),(2369,8694,40915,22723,3,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',52932.66,NULL,NULL,1,'2023-03-26 20:16:20','2023-03-26 20:16:20',NULL),(2370,8694,40915,22723,3,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',9272.84,NULL,NULL,1,'2023-03-26 20:16:20','2023-03-26 20:16:20',NULL),(2371,8694,40915,22723,3,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',0.00,NULL,NULL,1,'2023-03-26 20:16:20','2023-03-26 20:16:20',NULL),(2372,8694,40915,22723,2,1828,'App\\Models\\Receipt',1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',77502.92,NULL,NULL,1,'2023-03-26 20:19:05','2023-03-26 20:19:05',NULL),(2373,8694,40915,22723,2,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',31251.88,NULL,NULL,1,'2023-03-26 20:19:39','2023-03-26 20:19:39',NULL),(2374,8694,40915,22723,2,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',102462.80,NULL,NULL,1,'2023-03-26 20:20:41','2023-03-26 20:20:41',NULL),(2375,8694,40915,22723,2,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',85305.00,NULL,NULL,1,'2023-03-26 20:21:27','2023-03-26 20:21:27',NULL),(2376,8694,40915,22723,2,1832,'App\\Models\\Receipt',1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',151966.32,NULL,NULL,1,'2023-03-26 20:22:55','2023-03-26 20:22:55',NULL),(2377,8694,40915,22723,3,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',8200.91,NULL,NULL,1,'2023-03-26 20:27:06','2023-03-26 20:27:06',NULL),(2378,8694,40915,22723,3,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',20715.84,NULL,NULL,1,'2023-03-26 20:36:04','2023-03-26 20:36:04',NULL),(2379,8694,40915,22723,3,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',5000.00,NULL,NULL,1,'2023-03-26 20:41:05','2023-03-26 20:41:05',NULL),(2380,8694,40915,22723,3,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',7501.30,NULL,NULL,1,'2023-03-26 20:44:35','2023-03-26 20:44:35',NULL),(2381,8694,40915,22723,3,1834,'App\\Models\\Receipt',1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',32286.81,NULL,NULL,1,'2023-03-26 20:45:48','2023-03-26 20:45:48',NULL),(2382,8694,40915,22723,3,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',5000.00,NULL,NULL,1,'2023-03-26 20:48:06','2023-03-26 20:48:06',NULL),(2383,8694,40915,22723,3,1835,'App\\Models\\Receipt',1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',19249.13,NULL,NULL,1,'2023-03-26 20:49:31','2023-03-26 20:49:31',NULL),(2384,8694,40915,22723,3,1836,'App\\Models\\Receipt',1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',50000.00,NULL,NULL,1,'2023-03-26 20:50:42','2023-03-26 20:50:42',NULL),(2385,8694,40915,22723,3,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',5000.02,NULL,NULL,1,'2023-03-26 20:52:51','2023-03-26 20:52:51',NULL),(2386,8694,40915,22723,3,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',75549.46,NULL,NULL,1,'2023-03-26 20:57:14','2023-03-26 20:57:14',NULL),(2387,8694,40915,22723,3,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',14697.54,NULL,NULL,1,'2023-03-26 20:59:00','2023-03-26 20:59:00',NULL);
INSERT INTO `balance_libro` VALUES (2388,8694,40915,22723,3,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',8701.06,NULL,NULL,1,'2023-03-26 21:01:30','2023-03-26 21:01:30',NULL),(2389,8694,40915,22723,3,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',8000.00,NULL,NULL,1,'2023-03-26 21:02:30','2023-03-26 21:02:30',NULL),(2390,8694,40915,22723,3,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',14585.34,NULL,NULL,1,'2023-03-26 21:03:36','2023-03-26 21:03:36',NULL),(2391,8694,40915,22723,3,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',69183.93,NULL,NULL,1,'2023-03-26 21:04:34','2023-03-26 21:04:34',NULL),(2392,8694,40915,22723,3,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',23133.99,NULL,NULL,1,'2023-03-26 21:05:16','2023-03-26 21:05:16',NULL),(2393,8694,40915,22723,3,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',17227.98,NULL,NULL,1,'2023-03-26 21:07:16','2023-03-26 21:07:16',NULL),(2394,8694,40915,22723,3,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',13950.01,NULL,NULL,1,'2023-03-26 21:09:42','2023-03-26 21:09:42',NULL),(2395,8694,40915,22723,3,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',15499.99,NULL,NULL,1,'2023-03-26 21:12:01','2023-03-26 21:12:01',NULL),(2396,7525,41184,28766,2,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',108900.00,NULL,NULL,1,'2023-03-28 17:49:03','2023-03-28 17:49:03',NULL),(2397,7525,41184,28766,2,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',209451.00,NULL,NULL,1,'2023-03-28 17:49:03','2023-03-28 17:49:03',NULL),(2398,7525,41184,28766,2,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',67760.00,NULL,NULL,1,'2023-03-28 17:49:03','2023-03-28 17:56:18','2023-03-28 17:56:18'),(2399,7525,41184,28766,2,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',331842.50,NULL,NULL,1,'2023-03-28 17:49:03','2023-03-28 17:49:03',NULL),(2400,7525,41184,28766,2,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',101640.00,NULL,NULL,1,'2023-03-28 17:49:03','2023-03-28 17:49:03',NULL),(2401,7525,41184,28766,2,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',338679.00,NULL,NULL,1,'2023-03-28 17:49:03','2023-03-28 17:49:03',NULL),(2402,7525,41184,28766,2,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',338800.00,NULL,NULL,1,'2023-03-28 17:49:03','2023-03-28 17:49:03',NULL),(2403,7525,41184,28766,2,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',57777.50,NULL,NULL,1,'2023-03-28 17:49:03','2023-03-28 17:49:03',NULL),(2404,7525,41184,28766,2,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',268015.00,NULL,NULL,1,'2023-03-28 17:49:03','2023-03-28 17:49:03',NULL),(2405,7525,41184,28766,2,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',321860.00,NULL,NULL,1,'2023-03-28 17:49:03','2023-03-28 17:49:03',NULL),(2406,7525,41184,28766,3,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',46804.77,NULL,NULL,1,'2023-03-28 17:49:14','2023-03-28 18:06:19','2023-03-28 18:06:19'),(2407,7525,41184,28766,3,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',144257.48,NULL,NULL,1,'2023-03-28 17:49:14','2023-03-28 18:06:51','2023-03-28 18:06:51');
INSERT INTO `balance_libro` VALUES (2408,7525,41184,28766,3,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',11631.40,NULL,NULL,1,'2023-03-28 17:49:14','2023-03-28 18:07:05','2023-03-28 18:07:05'),(2409,7525,41184,28766,3,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',138636.96,NULL,NULL,1,'2023-03-28 17:49:14','2023-03-28 18:08:43','2023-03-28 18:08:43'),(2410,7525,41184,28766,3,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',170100.00,NULL,NULL,1,'2023-03-28 17:49:14','2023-03-28 18:07:38','2023-03-28 18:07:38'),(2411,7525,41184,28766,3,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',20800.00,NULL,NULL,1,'2023-03-28 17:49:14','2023-03-28 17:49:14',NULL),(2412,7525,41184,28766,3,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',14142.93,NULL,NULL,1,'2023-03-28 17:49:14','2023-03-28 18:11:35','2023-03-28 18:11:35'),(2413,7525,41184,28766,3,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',260992.12,NULL,NULL,1,'2023-03-28 17:49:14','2023-03-28 18:09:48','2023-03-28 18:09:48'),(2414,7525,41184,28766,3,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',47178.51,NULL,NULL,1,'2023-03-28 17:49:14','2023-03-28 18:10:19','2023-03-28 18:10:19'),(2415,7525,41184,28766,3,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',704.00,NULL,NULL,1,'2023-03-28 17:49:15','2023-03-28 18:11:47','2023-03-28 18:11:47'),(2416,7525,41184,28766,3,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',2385.60,NULL,NULL,1,'2023-03-28 17:49:15','2023-03-28 18:12:11','2023-03-28 18:12:11'),(2417,7525,41184,28766,3,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',5334.00,NULL,NULL,1,'2023-03-28 17:49:15','2023-03-28 18:11:17','2023-03-28 18:11:17'),(2418,7525,41184,28766,3,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',11403.20,NULL,NULL,1,'2023-03-28 17:49:15','2023-04-12 11:51:53','2023-04-12 11:51:53'),(2419,7525,41184,28766,3,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',51304.00,NULL,NULL,1,'2023-03-28 17:49:15','2023-03-28 17:49:15',NULL),(2420,7525,41184,28766,3,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',12199.71,NULL,NULL,1,'2023-03-28 17:49:15','2023-04-12 11:48:43','2023-04-12 11:48:43'),(2421,7525,41184,28766,3,1881,'App\\Models\\Receipt',1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',970.00,NULL,NULL,1,'2023-03-28 17:49:15','2023-03-28 18:10:57','2023-03-28 18:10:57'),(2422,7525,41184,28766,3,1882,'App\\Models\\Receipt',1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',31500.00,NULL,NULL,1,'2023-03-28 17:49:15','2023-03-28 17:49:15',NULL),(2423,7525,41184,28766,3,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',75000.00,NULL,NULL,1,'2023-03-28 17:49:15','2023-04-12 11:47:18','2023-04-12 11:47:18'),(2424,7525,41184,28766,3,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',209944.99,NULL,NULL,1,'2023-03-28 17:49:15','2023-04-12 11:46:13','2023-04-12 11:46:13'),(2425,7525,41184,28766,3,1885,'App\\Models\\Receipt',1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',195415.00,NULL,NULL,1,'2023-03-28 17:49:15','2023-03-28 17:49:15',NULL),(2426,7525,41184,28766,3,1886,'App\\Models\\Receipt',1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',10193.04,NULL,NULL,1,'2023-03-28 17:49:15','2023-03-28 17:49:15',NULL);
INSERT INTO `balance_libro` VALUES (2427,7525,41184,28766,3,1887,'App\\Models\\Receipt',1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',22506.00,NULL,NULL,1,'2023-03-28 17:49:15','2023-03-28 17:49:15',NULL),(2428,7525,41184,28766,3,1888,'App\\Models\\Receipt',1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',57898.50,NULL,NULL,1,'2023-03-28 17:49:15','2023-03-28 17:49:15',NULL),(2429,7525,41184,28766,3,1889,'App\\Models\\Receipt',1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',69411.65,NULL,NULL,1,'2023-03-28 17:49:15','2023-03-28 17:49:15',NULL),(2430,7525,41184,28766,3,1890,'App\\Models\\Receipt',1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',14900.00,NULL,NULL,1,'2023-03-28 17:49:15','2023-03-28 18:06:31','2023-03-28 18:06:31'),(2431,7525,41184,28766,3,1891,'App\\Models\\Receipt',1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',147060.00,NULL,NULL,1,'2023-03-28 17:49:15','2023-03-28 17:49:15',NULL),(2432,7525,41184,28766,2,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',67760.00,NULL,NULL,1,'2023-03-28 17:56:18','2023-03-28 17:56:18',NULL),(2433,7525,41184,28765,15,912,'App\\Models\\PeriodLiquidation',NULL,912,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',122492.57,NULL,NULL,1,'2023-03-28 18:02:22','2023-03-28 18:02:22',NULL),(2434,7525,41184,28766,3,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',46804.77,NULL,NULL,1,'2023-03-28 18:06:19','2023-03-28 18:06:19',NULL),(2435,7525,41184,28766,3,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',144257.48,NULL,NULL,1,'2023-03-28 18:06:51','2023-04-12 11:52:45','2023-04-12 11:52:45'),(2436,7525,41184,28766,3,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',170100.00,NULL,NULL,1,'2023-03-28 18:07:38','2023-03-28 18:07:38',NULL),(2437,7525,41184,28766,3,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',138636.96,NULL,NULL,1,'2023-03-28 18:08:43','2023-03-28 18:08:43',NULL),(2438,7525,41184,28766,3,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',260992.12,NULL,NULL,1,'2023-03-28 18:09:48','2023-03-28 18:09:48',NULL),(2439,7525,41184,28766,3,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',47178.51,NULL,NULL,1,'2023-03-28 18:10:19','2023-03-28 18:10:19',NULL),(2440,7525,41023,27269,3,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',18890.52,NULL,NULL,1,'2023-03-31 12:45:42','2023-03-31 12:45:42',NULL),(2441,7525,41023,27269,3,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',87746.32,NULL,NULL,1,'2023-03-31 12:47:54','2023-03-31 12:48:17','2023-03-31 12:48:17'),(2442,7525,41023,27269,3,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',88532.39,NULL,NULL,1,'2023-03-31 12:48:17','2023-03-31 12:52:25','2023-03-31 12:52:25'),(2443,7525,41023,27269,3,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',90360.06,NULL,NULL,1,'2023-03-31 12:52:25','2023-03-31 12:52:25',NULL),(2444,7525,41023,27269,3,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',21634.68,NULL,NULL,1,'2023-03-31 12:53:23','2023-03-31 12:53:23',NULL),(2445,7525,41023,27269,3,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',30930.01,NULL,NULL,1,'2023-03-31 12:55:18','2023-03-31 12:55:18',NULL),(2446,7525,41023,27269,3,1892,'App\\Models\\Receipt',1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',3939.98,NULL,NULL,1,'2023-03-31 12:57:01','2023-03-31 12:57:01',NULL);
INSERT INTO `balance_libro` VALUES (2447,7525,41184,28766,3,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',11631.40,NULL,NULL,1,'2023-04-12 11:39:28','2023-04-12 11:44:33','2023-04-12 11:44:33'),(2448,7525,41184,28766,3,1894,'App\\Models\\Receipt',1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',14142.93,NULL,NULL,1,'2023-04-12 11:39:28','2023-04-12 11:44:18','2023-04-12 11:44:18'),(2449,7525,41184,28766,3,1895,'App\\Models\\Receipt',1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',704.00,NULL,NULL,1,'2023-04-12 11:39:28','2023-04-12 11:43:50','2023-04-12 11:43:50'),(2450,7525,41184,28766,3,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',2385.60,NULL,NULL,1,'2023-04-12 11:39:28','2023-04-12 11:43:42','2023-04-12 11:43:42'),(2451,7525,41184,28766,3,1897,'App\\Models\\Receipt',1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',5334.00,NULL,NULL,1,'2023-04-12 11:39:28','2023-04-12 11:43:35','2023-04-12 11:43:35'),(2452,7525,41184,28766,3,1898,'App\\Models\\Receipt',1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',970.00,NULL,NULL,1,'2023-04-12 11:39:28','2023-04-12 11:43:26','2023-04-12 11:43:26'),(2453,7525,41184,28766,3,1899,'App\\Models\\Receipt',1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',14900.00,NULL,NULL,1,'2023-04-12 11:39:28','2023-04-12 11:43:18','2023-04-12 11:43:18'),(2454,7525,41184,28766,3,1900,'App\\Models\\Receipt',1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',0.00,NULL,NULL,1,'2023-04-12 11:39:28','2023-04-12 11:41:50','2023-04-12 11:41:50'),(2455,7525,41184,28766,3,1901,'App\\Models\\Receipt',1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',166738.00,NULL,NULL,1,'2023-04-12 11:39:28','2023-04-12 11:39:28',NULL),(2456,7525,41184,28766,3,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',209944.99,NULL,NULL,1,'2023-04-12 11:46:13','2023-04-12 11:46:13',NULL),(2457,7525,41184,28766,3,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',75000.00,NULL,NULL,1,'2023-04-12 11:47:18','2023-04-12 11:47:18',NULL),(2458,7525,41184,28766,3,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',12199.71,NULL,NULL,1,'2023-04-12 11:48:43','2023-04-12 11:48:43',NULL),(2459,7525,41184,28766,3,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',11403.20,NULL,NULL,1,'2023-04-12 11:51:53','2023-04-12 11:51:53',NULL),(2460,7525,41184,28766,3,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',144257.48,NULL,NULL,1,'2023-04-12 11:52:45','2023-04-12 11:52:45',NULL),(2461,7525,41184,28766,3,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',11401.00,NULL,NULL,1,'2023-04-12 12:05:31','2023-04-12 12:05:31',NULL),(2462,7525,41184,28766,3,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',11001.37,NULL,NULL,1,'2023-04-12 12:06:24','2023-04-12 12:06:24',NULL),(2463,7525,41184,28766,3,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',7601.36,NULL,NULL,1,'2023-04-12 12:07:55','2023-04-12 12:07:55',NULL),(2464,7525,41184,28766,3,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',12004.79,NULL,NULL,1,'2023-04-12 12:08:53','2023-04-12 12:08:53',NULL),(2465,7525,41184,28766,3,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',11702.31,NULL,NULL,1,'2023-04-12 12:09:54','2023-04-12 12:09:54',NULL),(2466,7525,41184,28766,7,1907,'App\\Models\\Receipt',1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1005.00,NULL,NULL,1,'2023-04-14 15:10:29','2023-04-14 15:10:29',NULL);
INSERT INTO `balance_libro` VALUES (2467,7525,41184,28766,3,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',196404.25,NULL,NULL,1,'2023-04-14 15:19:55','2023-04-14 15:19:55',NULL),(2468,7525,40849,13646,3,1909,'App\\Models\\Receipt',1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',164999.00,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 13:45:23',NULL),(2469,7525,40849,13646,3,1910,'App\\Models\\Receipt',1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',209170.52,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 13:45:23',NULL),(2470,7525,40849,13646,3,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',4558.90,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 15:25:27','2023-04-24 15:25:27'),(2471,7525,40849,13646,3,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',67.05,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 15:20:32','2023-04-24 15:20:32'),(2472,7525,40849,13646,3,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',3040.55,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 13:45:23',NULL),(2473,7525,40849,13646,3,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',21813.17,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 15:16:06','2023-04-24 15:16:06'),(2474,7525,40849,13646,3,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',24172.10,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 15:14:19','2023-04-24 15:14:19'),(2475,7525,40849,13646,3,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',20674.55,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 15:10:57','2023-04-24 15:10:57'),(2476,7525,40849,13646,3,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',21924.56,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 15:07:29','2023-04-24 15:07:29'),(2477,7525,40849,13646,3,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',7095.15,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 15:06:58','2023-04-24 15:06:58'),(2478,7525,40849,13646,3,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',4401.73,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 15:04:41','2023-04-24 15:04:41'),(2479,7525,40849,13646,3,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',4401.73,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 15:04:55','2023-04-24 15:04:55'),(2480,7525,40849,13646,3,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',4054.07,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 15:04:16','2023-04-24 15:04:16'),(2481,7525,40849,13646,3,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',11278.54,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 15:03:05','2023-04-24 15:03:05'),(2482,7525,40849,13646,3,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',10744.40,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 15:02:33','2023-04-24 15:02:33'),(2483,7525,40849,13646,3,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',16657.00,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 15:02:02','2023-04-24 15:02:02'),(2484,7525,40849,13646,3,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',244016.34,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 15:00:47','2023-04-24 15:00:47'),(2485,7525,40849,13646,3,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',8000.00,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 15:00:12','2023-04-24 15:00:12');
INSERT INTO `balance_libro` VALUES (2486,7525,40849,13646,3,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',4235.00,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 13:45:23',NULL),(2487,7525,40849,13646,3,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',16786.00,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 14:13:42','2023-04-24 14:13:42'),(2488,7525,40849,13646,3,1929,'App\\Models\\Receipt',1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',7812.51,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 13:45:23',NULL),(2489,7525,40849,13646,3,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',18226.39,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 14:58:48','2023-04-24 14:58:48'),(2490,7525,40849,13646,3,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',20470.76,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 14:58:10','2023-04-24 14:58:10'),(2491,7525,40849,13646,3,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',5692.60,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 14:57:39','2023-04-24 14:57:39'),(2492,7525,40849,13646,3,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',13543.12,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 14:57:17','2023-04-24 14:57:17'),(2493,7525,40849,13646,3,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',199214.28,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 13:45:23',NULL),(2494,7525,40849,13646,3,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',2629.22,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 14:56:32','2023-04-24 14:56:32'),(2495,7525,40849,13646,3,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',2629.22,NULL,NULL,1,'2023-04-24 13:45:23','2023-04-24 14:56:22','2023-04-24 14:56:22'),(2496,7525,40849,13646,3,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',5067.51,NULL,NULL,1,'2023-04-24 13:45:24','2023-04-24 14:55:59','2023-04-24 14:55:59'),(2497,7525,40849,13646,3,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',206315.89,NULL,NULL,1,'2023-04-24 13:45:24','2023-04-24 14:54:37','2023-04-24 14:54:37'),(2498,7525,40849,13646,3,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',7812.51,NULL,NULL,1,'2023-04-24 13:45:24','2023-04-24 14:54:17','2023-04-24 14:54:17'),(2499,7525,40849,13646,3,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',30128.59,NULL,NULL,1,'2023-04-24 13:45:24','2023-04-24 14:53:37','2023-04-24 14:53:37'),(2500,7525,40849,13646,3,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',7418.01,NULL,NULL,1,'2023-04-24 13:45:24','2023-04-24 14:52:57','2023-04-24 14:52:57'),(2501,7525,40849,13646,3,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',10329.74,NULL,NULL,1,'2023-04-24 13:45:24','2023-04-24 14:52:17','2023-04-24 14:52:17'),(2502,7525,40849,13646,3,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3660.95,NULL,NULL,1,'2023-04-24 13:45:24','2023-04-24 14:51:46','2023-04-24 14:51:46'),(2503,7525,40849,13646,3,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',0.00,NULL,NULL,1,'2023-04-24 13:45:24','2023-04-24 14:13:24','2023-04-24 14:13:24'),(2504,7525,40849,13646,2,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',62611.00,NULL,NULL,1,'2023-04-24 14:38:27','2023-04-24 14:38:27',NULL);
INSERT INTO `balance_libro` VALUES (2505,7525,40849,13646,2,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',45982.00,NULL,NULL,1,'2023-04-24 14:38:27','2023-04-24 14:38:27',NULL),(2506,7525,40849,13646,2,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',81744.00,NULL,NULL,1,'2023-04-24 14:38:27','2023-04-24 14:38:27',NULL),(2507,7525,40849,13646,2,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',89960.00,NULL,NULL,1,'2023-04-24 14:38:27','2023-04-24 14:38:27',NULL),(2508,7525,40849,13646,2,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',43338.00,NULL,NULL,1,'2023-04-24 14:38:27','2023-04-24 14:38:27',NULL),(2509,7525,40849,13646,2,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',40821.00,NULL,NULL,1,'2023-04-24 14:38:27','2023-04-24 14:38:27',NULL),(2510,7525,40849,13646,2,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',61050.00,NULL,NULL,1,'2023-04-24 14:38:27','2023-04-24 14:38:27',NULL),(2511,7525,40849,13646,2,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',75141.00,NULL,NULL,1,'2023-04-24 14:38:27','2023-04-24 14:38:27',NULL),(2512,7525,40849,13646,2,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',40807.00,NULL,NULL,1,'2023-04-24 14:38:27','2023-04-24 14:38:27',NULL),(2513,7525,40849,13646,2,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',92606.00,NULL,NULL,1,'2023-04-24 14:38:27','2023-04-24 14:38:27',NULL),(2514,7525,40849,13646,2,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',22740.00,NULL,NULL,1,'2023-04-24 14:38:27','2023-04-24 14:38:27',NULL),(2515,7525,40849,13646,2,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',42078.00,NULL,NULL,1,'2023-04-24 14:38:27','2023-04-24 14:38:27',NULL),(2516,7525,40849,13646,2,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',37725.00,NULL,NULL,1,'2023-04-24 14:38:27','2023-04-24 14:38:27',NULL),(2517,7525,40849,13646,2,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',33616.00,NULL,NULL,1,'2023-04-24 14:38:28','2023-04-24 14:38:28',NULL),(2518,7525,40849,13646,2,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',45900.00,NULL,NULL,1,'2023-04-24 14:38:28','2023-04-24 14:38:28',NULL),(2519,7525,40849,13646,2,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',69376.00,NULL,NULL,1,'2023-04-24 14:38:28','2023-04-24 14:38:28',NULL),(2520,7525,40849,13646,2,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',37364.00,NULL,NULL,1,'2023-04-24 14:38:28','2023-04-24 14:38:28',NULL),(2521,7525,40849,13646,2,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',58000.00,NULL,NULL,1,'2023-04-24 14:38:28','2023-04-24 14:38:28',NULL),(2522,7525,40849,13646,2,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',10450.00,NULL,NULL,1,'2023-04-24 14:38:28','2023-04-24 14:38:28',NULL),(2523,7525,40849,13646,2,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',2160.00,NULL,NULL,1,'2023-04-24 14:38:28','2023-04-24 14:38:28',NULL),(2524,7525,40849,13646,2,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',3500.00,NULL,NULL,1,'2023-04-24 14:38:28','2023-04-24 14:38:28',NULL),(2525,7525,40849,13646,2,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',2272.00,NULL,NULL,1,'2023-04-24 14:38:28','2023-04-24 14:38:28',NULL);
INSERT INTO `balance_libro` VALUES (2526,7525,40849,13646,2,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',3500.00,NULL,NULL,1,'2023-04-24 14:38:28','2023-04-24 14:38:28',NULL),(2527,7525,40849,13646,2,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',3000.00,NULL,NULL,1,'2023-04-24 14:38:28','2023-04-24 14:38:28',NULL),(2528,7525,40849,13646,2,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',18300.00,NULL,NULL,1,'2023-04-24 14:38:28','2023-04-24 14:38:28',NULL),(2529,7525,40849,13646,2,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',44664.00,NULL,NULL,1,'2023-04-24 14:38:28','2023-04-24 14:38:28',NULL),(2530,7525,40849,13646,2,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',33683.00,NULL,NULL,1,'2023-04-24 14:38:28','2023-04-24 14:38:28',NULL),(2531,7525,40849,13646,3,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3660.95,NULL,NULL,1,'2023-04-24 14:51:46','2023-04-24 14:51:46',NULL),(2532,7525,40849,13646,3,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',10329.74,NULL,NULL,1,'2023-04-24 14:52:17','2023-04-24 14:52:17',NULL),(2533,7525,40849,13646,3,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',7418.01,NULL,NULL,1,'2023-04-24 14:52:57','2023-04-24 14:52:57',NULL),(2534,7525,40849,13646,3,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',30128.59,NULL,NULL,1,'2023-04-24 14:53:37','2023-04-24 14:53:37',NULL),(2535,7525,40849,13646,3,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',7812.52,NULL,NULL,1,'2023-04-24 14:54:17','2023-04-24 14:54:17',NULL),(2536,7525,40849,13646,3,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',206315.89,NULL,NULL,1,'2023-04-24 14:54:37','2023-04-24 14:54:37',NULL),(2537,7525,40849,13646,3,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',5067.51,NULL,NULL,1,'2023-04-24 14:55:59','2023-04-24 14:55:59',NULL),(2538,7525,40849,13646,3,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',13543.11,NULL,NULL,1,'2023-04-24 14:57:17','2023-04-24 14:57:17',NULL),(2539,7525,40849,13646,3,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',5692.60,NULL,NULL,1,'2023-04-24 14:57:39','2023-04-24 14:57:39',NULL),(2540,7525,40849,13646,3,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',20470.78,NULL,NULL,1,'2023-04-24 14:58:10','2023-04-24 14:58:10',NULL),(2541,7525,40849,13646,3,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',18226.39,NULL,NULL,1,'2023-04-24 14:58:48','2023-04-24 15:45:51','2023-04-24 15:45:51'),(2542,7525,40849,13646,3,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',8000.00,NULL,NULL,1,'2023-04-24 15:00:12','2023-04-24 15:00:12',NULL),(2543,7525,40849,13646,3,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',244016.34,NULL,NULL,1,'2023-04-24 15:00:47','2023-04-24 15:00:47',NULL),(2544,7525,40849,13646,3,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',16656.99,NULL,NULL,1,'2023-04-24 15:02:02','2023-04-24 15:02:02',NULL),(2545,7525,40849,13646,3,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',10744.40,NULL,NULL,1,'2023-04-24 15:02:33','2023-04-24 15:02:33',NULL);
INSERT INTO `balance_libro` VALUES (2546,7525,40849,13646,3,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',11278.54,NULL,NULL,1,'2023-04-24 15:03:05','2023-04-24 15:03:05',NULL),(2547,7525,40849,13646,3,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',4054.06,NULL,NULL,1,'2023-04-24 15:04:16','2023-04-24 15:04:16',NULL),(2548,7525,40849,13646,3,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',7095.14,NULL,NULL,1,'2023-04-24 15:06:58','2023-04-24 15:06:58',NULL),(2549,7525,40849,13646,3,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',21924.56,NULL,NULL,1,'2023-04-24 15:07:29','2023-04-24 15:07:29',NULL),(2550,7525,40849,13646,3,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',20674.55,NULL,NULL,1,'2023-04-24 15:10:57','2023-04-24 15:10:57',NULL),(2551,7525,40849,13646,3,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',24172.10,NULL,NULL,1,'2023-04-24 15:14:19','2023-04-24 15:14:19',NULL),(2552,7525,40849,13646,3,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',21813.17,NULL,NULL,1,'2023-04-24 15:16:06','2023-04-24 15:16:06',NULL),(2553,7525,40849,13646,3,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',67.05,NULL,NULL,1,'2023-04-24 15:20:32','2023-04-24 15:20:32',NULL),(2554,7525,40849,13646,3,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',4558.90,NULL,NULL,1,'2023-04-24 15:25:27','2023-04-24 15:25:27',NULL),(2555,7525,40849,13645,15,1018,'App\\Models\\PeriodLiquidation',NULL,1018,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',120540.85,NULL,NULL,1,'2023-04-24 15:26:13','2023-04-24 15:26:13',NULL),(2556,7525,40849,13646,7,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',4892.27,NULL,NULL,1,'2023-04-24 15:44:54','2023-04-24 15:44:54',NULL),(2557,7525,40849,13646,3,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',18571.84,NULL,NULL,1,'2023-04-24 15:45:51','2023-04-24 15:45:51',NULL),(2558,7525,40849,13646,15,1402,'App\\Models\\PeriodLiquidation',NULL,1402,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',249281.43,NULL,NULL,1,'2023-04-24 16:30:31','2023-04-24 16:30:31',NULL),(2559,7525,40856,15157,15,1151,'App\\Models\\PeriodLiquidation',NULL,1151,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',41506.12,NULL,NULL,1,'2023-04-24 16:31:06','2023-04-24 16:31:06',NULL),(2560,7525,40856,15158,2,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',184706.50,NULL,NULL,1,'2023-04-24 16:45:47','2023-04-24 16:45:47',NULL),(2561,7525,40856,15158,3,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',5380.00,NULL,NULL,1,'2023-04-24 16:45:57','2023-04-24 17:10:14','2023-04-24 17:10:14'),(2562,7525,40856,15158,3,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',28711.33,NULL,NULL,1,'2023-04-24 16:45:57','2023-04-24 17:09:40','2023-04-24 17:09:40'),(2563,7525,40856,15158,3,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',163.00,NULL,NULL,1,'2023-04-24 16:45:57','2023-04-24 16:45:57',NULL),(2564,7525,40856,15158,3,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',231.00,NULL,NULL,1,'2023-04-24 16:45:57','2023-04-24 17:08:39','2023-04-24 17:08:39'),(2565,7525,40856,15158,3,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',100.00,NULL,NULL,1,'2023-04-24 16:45:57','2023-04-24 17:08:27','2023-04-24 17:08:27');
INSERT INTO `balance_libro` VALUES (2566,7525,40856,15158,3,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',10779.55,NULL,NULL,1,'2023-04-24 16:45:57','2023-04-24 17:08:07','2023-04-24 17:08:07'),(2567,7525,40856,15158,3,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',5442.59,NULL,NULL,1,'2023-04-24 16:45:57','2023-04-24 17:06:37','2023-04-24 17:06:37'),(2568,7525,40856,15158,3,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',24179.97,NULL,NULL,1,'2023-04-24 16:45:57','2023-04-24 17:05:02','2023-04-24 17:05:02'),(2569,7525,40856,15158,3,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',614.27,NULL,NULL,1,'2023-04-24 16:45:57','2023-04-24 17:03:46','2023-04-24 17:03:46'),(2570,7525,40856,15158,3,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',4600.00,NULL,NULL,1,'2023-04-24 16:45:57','2023-04-24 17:03:26','2023-04-24 17:03:26'),(2571,7525,40856,15158,3,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',14999.99,NULL,NULL,1,'2023-04-24 16:45:57','2023-04-24 17:03:14','2023-04-24 17:03:14'),(2572,7525,40856,15158,3,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',19012.31,NULL,NULL,1,'2023-04-24 16:45:57','2023-04-24 16:57:26','2023-04-24 16:57:26'),(2573,7525,40856,15158,3,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',6500.00,NULL,NULL,1,'2023-04-24 16:45:57','2023-04-24 16:59:31','2023-04-24 16:59:31'),(2574,7525,40856,15158,3,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',368.52,NULL,NULL,1,'2023-04-24 16:45:57','2023-04-24 16:53:53','2023-04-24 16:53:53'),(2575,7525,40856,15158,3,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',9000.00,NULL,NULL,1,'2023-04-24 16:45:57','2023-04-24 16:53:33','2023-04-24 16:53:33'),(2576,7525,40856,15158,3,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',382.07,NULL,NULL,1,'2023-04-24 16:45:57','2023-04-24 16:53:22','2023-04-24 16:53:22'),(2577,7525,40856,15158,3,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',867.26,NULL,NULL,1,'2023-04-24 16:45:57','2023-04-24 16:53:10','2023-04-24 16:53:10'),(2578,7525,40856,15158,3,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',36034.24,NULL,NULL,1,'2023-04-24 16:45:58','2023-04-24 16:52:58','2023-04-24 16:52:58'),(2579,7525,40856,15158,3,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1582.00,NULL,NULL,1,'2023-04-24 16:45:58','2023-04-24 16:50:28','2023-04-24 16:50:28'),(2580,7525,40856,15158,3,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',110000.00,NULL,NULL,1,'2023-04-24 16:45:58','2023-04-24 16:50:15','2023-04-24 16:50:15'),(2581,7525,40856,15158,3,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',5021.22,NULL,NULL,1,'2023-04-24 16:45:58','2023-04-24 16:49:43','2023-04-24 16:49:43'),(2582,7525,40856,15158,3,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',6399.65,NULL,NULL,1,'2023-04-24 16:45:58','2023-04-24 16:49:14','2023-04-24 16:49:14'),(2583,7525,40856,15158,3,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',7455.53,NULL,NULL,1,'2023-04-24 16:45:58','2023-04-24 16:45:58',NULL),(2584,7525,40856,15158,3,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',5021.22,NULL,NULL,1,'2023-04-24 16:49:44','2023-04-24 16:49:44',NULL);
INSERT INTO `balance_libro` VALUES (2585,7525,40856,15158,3,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1582.00,NULL,NULL,1,'2023-04-24 16:50:28','2023-04-24 16:50:28',NULL),(2586,7525,40856,15158,3,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',36034.24,NULL,NULL,1,'2023-04-24 16:52:58','2023-04-24 16:52:58',NULL),(2587,7525,40856,15158,3,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',867.27,NULL,NULL,1,'2023-04-24 16:53:10','2023-04-24 16:53:10',NULL),(2588,7525,40856,15158,3,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',382.08,NULL,NULL,1,'2023-04-24 16:53:22','2023-04-24 16:53:22',NULL),(2589,7525,40856,15158,3,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',9000.00,NULL,NULL,1,'2023-04-24 16:53:33','2023-04-24 16:53:33',NULL),(2590,7525,40856,15158,3,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',368.53,NULL,NULL,1,'2023-04-24 16:53:53','2023-04-24 16:54:05','2023-04-24 16:54:05'),(2591,7525,40856,15158,3,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',368.53,NULL,NULL,1,'2023-04-24 16:54:05','2023-04-24 16:54:05',NULL),(2592,7525,40856,15158,3,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',19012.27,NULL,NULL,1,'2023-04-24 16:57:26','2023-04-24 16:57:26',NULL),(2593,7525,40856,15158,3,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',6500.00,NULL,NULL,1,'2023-04-24 16:59:31','2023-04-24 20:57:30','2023-04-24 20:57:30'),(2594,7525,40856,15158,3,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',14999.99,NULL,NULL,1,'2023-04-24 17:03:14','2023-04-24 17:03:14',NULL),(2595,7525,40856,15158,3,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',4600.00,NULL,NULL,1,'2023-04-24 17:03:26','2023-04-24 17:03:26',NULL),(2596,7525,40856,15158,3,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',614.27,NULL,NULL,1,'2023-04-24 17:03:46','2023-04-24 17:03:46',NULL),(2597,7525,40856,15158,3,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',24179.96,NULL,NULL,1,'2023-04-24 17:05:02','2023-04-24 17:05:41','2023-04-24 17:05:41'),(2598,7525,40856,15158,3,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',24179.96,NULL,NULL,1,'2023-04-24 17:05:41','2023-04-24 17:05:41',NULL),(2599,7525,40856,15158,3,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',5442.59,NULL,NULL,1,'2023-04-24 17:06:37','2023-04-24 17:06:37',NULL),(2600,7525,40856,15158,3,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',10788.12,NULL,NULL,1,'2023-04-24 17:08:07','2023-04-24 17:08:07',NULL),(2601,7525,40856,15158,3,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',100.01,NULL,NULL,1,'2023-04-24 17:08:27','2023-04-24 17:08:27',NULL),(2602,7525,40856,15158,3,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',231.00,NULL,NULL,1,'2023-04-24 17:08:39','2023-04-24 17:08:39',NULL),(2603,7525,40856,15158,3,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',28711.33,NULL,NULL,1,'2023-04-24 17:09:40','2023-04-24 17:09:40',NULL),(2604,7525,40856,15158,3,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',5380.00,NULL,NULL,1,'2023-04-24 17:10:14','2023-04-24 17:10:14',NULL);
INSERT INTO `balance_libro` VALUES (2605,7525,40856,15158,3,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',29343.60,NULL,NULL,1,'2023-04-24 17:16:02','2023-04-24 21:10:27','2023-04-24 21:10:27'),(2606,7525,40856,15158,3,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',43617.78,NULL,NULL,1,'2023-04-24 17:17:20','2023-04-24 17:17:20',NULL),(2607,7525,40856,15158,3,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',7300.29,NULL,NULL,1,'2023-04-24 17:19:07','2023-04-24 17:19:07',NULL),(2608,7525,40856,15158,3,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',7000.80,NULL,NULL,1,'2023-04-24 17:19:58','2023-04-24 17:19:58',NULL),(2609,7525,40856,15158,3,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',8399.22,NULL,NULL,1,'2023-04-24 17:20:48','2023-04-24 17:20:48',NULL),(2610,7525,40856,15158,3,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',6901.31,NULL,NULL,1,'2023-04-24 17:21:23','2023-04-24 17:21:23',NULL),(2611,7525,40856,15158,3,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',7800.69,NULL,NULL,1,'2023-04-24 17:22:43','2023-04-24 17:22:43',NULL),(2612,7525,40856,15158,3,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',6598.01,NULL,NULL,1,'2023-04-24 17:58:41','2023-04-24 17:58:41',NULL),(2613,7525,40856,15158,3,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',6700.70,NULL,NULL,1,'2023-04-24 17:59:29','2023-04-24 17:59:29',NULL),(2614,7525,40856,15158,3,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',4200.00,NULL,NULL,1,'2023-04-24 18:08:03','2023-04-24 18:08:03',NULL),(2615,7525,40856,15158,3,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',27915.89,NULL,NULL,1,'2023-04-24 21:10:27','2023-04-24 21:10:27',NULL),(2616,7525,40856,15158,15,1439,'App\\Models\\PeriodLiquidation',NULL,1439,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',53933.00,NULL,NULL,1,'2023-04-24 21:24:07','2023-05-25 15:20:35','2023-05-25 15:20:35'),(2617,7525,41184,28767,2,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',15730.00,NULL,NULL,1,'2023-04-25 12:21:47','2023-04-25 12:21:47',NULL),(2618,7525,41184,28767,2,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',225060.00,NULL,NULL,1,'2023-04-25 12:21:47','2023-04-25 12:21:47',NULL),(2619,7525,41184,28767,2,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',154154.00,NULL,NULL,1,'2023-04-25 12:21:47','2023-04-25 12:21:47',NULL),(2620,7525,41184,28767,2,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',102850.00,NULL,NULL,1,'2023-04-25 12:21:47','2023-04-25 12:21:47',NULL),(2621,7525,41184,28767,3,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',199592.72,NULL,NULL,1,'2023-04-25 12:21:58','2023-04-25 12:21:58',NULL),(2622,7525,41184,28767,3,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',7245.27,NULL,NULL,1,'2023-04-25 12:21:58','2023-04-25 12:21:58',NULL),(2623,7525,41184,28767,3,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',7673.41,NULL,NULL,1,'2023-04-25 12:21:58','2023-04-25 12:21:58',NULL),(2624,7525,41184,28767,3,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',544.00,NULL,NULL,1,'2023-04-25 12:21:58','2023-04-25 12:25:42','2023-04-25 12:25:42');
INSERT INTO `balance_libro` VALUES (2625,7525,41184,28767,3,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',8038.01,NULL,NULL,1,'2023-04-25 12:21:58','2023-04-25 12:21:58',NULL),(2626,7525,41184,28767,3,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',4908.90,NULL,NULL,1,'2023-04-25 12:21:58','2023-04-25 12:21:58',NULL),(2627,7525,41184,28767,3,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',8000.00,NULL,NULL,1,'2023-04-25 12:21:58','2023-04-25 12:25:34','2023-04-25 12:25:34'),(2628,7525,41184,28767,3,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',299.00,NULL,NULL,1,'2023-04-25 12:21:58','2023-04-25 12:25:29','2023-04-25 12:25:29'),(2629,7525,41184,28767,3,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',68.00,NULL,NULL,1,'2023-04-25 12:21:59','2023-04-25 12:25:22','2023-04-25 12:25:22'),(2630,7525,41184,28767,3,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',3300.00,NULL,NULL,1,'2023-04-25 12:21:59','2023-04-25 12:25:15','2023-04-25 12:25:15'),(2631,7525,41184,28766,15,1367,'App\\Models\\PeriodLiquidation',NULL,1367,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',372225.00,NULL,NULL,1,'2023-04-25 12:23:14','2023-04-25 12:23:14',NULL),(2632,7525,40875,16670,2,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',22504.96,NULL,NULL,1,'2023-04-25 13:03:18','2023-04-25 13:06:26','2023-04-25 13:06:26'),(2633,7525,40875,16670,2,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',25318.08,NULL,NULL,1,'2023-04-25 13:03:18','2023-04-25 13:06:10','2023-04-25 13:06:10'),(2634,7525,40875,16670,2,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',22504.96,NULL,NULL,1,'2023-04-25 13:03:18','2023-04-25 13:05:51','2023-04-25 13:05:51'),(2635,7525,40875,16670,2,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',9600.00,NULL,NULL,1,'2023-04-25 13:03:18','2023-04-25 13:05:35','2023-04-25 13:05:35'),(2636,7525,40875,16670,2,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',301000.00,NULL,NULL,1,'2023-04-25 13:03:18','2023-04-25 13:05:19','2023-04-25 13:05:19'),(2637,7525,40875,16670,2,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',405000.00,NULL,NULL,1,'2023-04-25 13:03:18','2023-04-25 13:05:09','2023-04-25 13:05:09'),(2638,7525,40875,16670,3,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',3254.90,NULL,NULL,1,'2023-04-25 13:03:27','2023-04-25 13:03:27',NULL),(2639,7525,40875,16670,3,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',14918.15,NULL,NULL,1,'2023-04-25 13:03:27','2023-04-25 13:03:27',NULL),(2640,7525,40875,16670,3,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',922.31,NULL,NULL,1,'2023-04-25 13:03:27','2023-04-25 13:50:00','2023-04-25 13:50:00'),(2641,7525,40875,16670,3,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',14030.00,NULL,NULL,1,'2023-04-25 13:03:27','2023-04-25 13:19:45','2023-04-25 13:19:45'),(2642,7525,40875,16670,3,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',5000.00,NULL,NULL,1,'2023-04-25 13:03:27','2023-04-25 13:03:27',NULL),(2643,7525,40875,16670,3,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3400.32,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:49:23','2023-04-25 13:49:23');
INSERT INTO `balance_libro` VALUES (2644,7525,40875,16670,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',6860.14,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:03:28',NULL),(2645,7525,40875,16670,3,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',93218.40,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:03:28',NULL),(2646,7525,40875,16670,3,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',37370.85,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:03:28',NULL),(2647,7525,40875,16670,3,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',7978.99,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:20:13','2023-04-25 13:20:13'),(2648,7525,40875,16670,3,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',7978.99,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:19:28','2023-04-25 13:19:28'),(2649,7525,40875,16670,3,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',7978.99,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:03:28',NULL),(2650,7525,40875,16670,3,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',8034.63,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:47:57','2023-04-25 13:47:57'),(2651,7525,40875,16670,3,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',9008.20,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:40:15','2023-04-25 13:40:15'),(2652,7525,40875,16670,3,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',7500.00,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:39:28','2023-04-25 13:39:28'),(2653,7525,40875,16670,3,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',8975.48,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:18:42','2023-04-25 13:18:42'),(2654,7525,40875,16670,3,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',5820.00,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:39:14','2023-04-25 13:39:14'),(2655,7525,40875,16670,3,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',30245.72,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:38:58','2023-04-25 13:38:58'),(2656,7525,40875,16670,3,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',108900.00,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:03:28',NULL),(2657,7525,40875,16670,3,2046,'App\\Models\\Receipt',2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',29999.41,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:03:28',NULL),(2658,7525,40875,16670,3,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',218905.00,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:37:06','2023-04-25 13:37:06'),(2659,7525,40875,16670,3,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',37557.00,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:03:28',NULL),(2660,7525,40875,16670,3,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',9200.00,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:18:55','2023-04-25 13:18:55'),(2661,7525,40875,16670,3,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',30886.94,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:03:28',NULL),(2662,7525,40875,16670,3,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',14918.15,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:03:28',NULL),(2663,7525,40875,16670,3,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',516.00,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:18:29','2023-04-25 13:18:29');
INSERT INTO `balance_libro` VALUES (2664,7525,40875,16670,3,2053,'App\\Models\\Receipt',2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',2041.00,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:03:28',NULL),(2665,7525,40875,16670,3,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',711.84,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:03:28',NULL),(2666,7525,40875,16670,3,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',4680.00,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:03:28',NULL),(2667,7525,40875,16670,3,2056,'App\\Models\\Receipt',2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',16600.00,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:03:28',NULL),(2668,7525,40875,16670,3,2057,'App\\Models\\Receipt',2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',3253.36,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:03:28',NULL),(2669,7525,40875,16670,3,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',9008.20,NULL,NULL,1,'2023-04-25 13:03:28','2023-04-25 13:33:45','2023-04-25 13:33:45'),(2670,7525,40875,16670,3,2059,'App\\Models\\Receipt',2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',38990.00,NULL,NULL,1,'2023-04-25 13:03:29','2023-04-25 13:03:29',NULL),(2671,7525,40875,16670,3,2060,'App\\Models\\Receipt',2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',2318.99,NULL,NULL,1,'2023-04-25 13:03:29','2023-04-25 13:18:03','2023-04-25 13:18:03'),(2672,7525,40875,16670,3,2061,'App\\Models\\Receipt',2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',812740.88,NULL,NULL,1,'2023-04-25 13:03:29','2023-04-25 13:03:29',NULL),(2673,7525,40875,16670,3,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',4999.99,NULL,NULL,1,'2023-04-25 13:03:29','2023-04-25 13:32:32','2023-04-25 13:32:32'),(2674,7525,40875,16670,2,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',405000.00,NULL,NULL,1,'2023-04-25 13:05:09','2023-04-25 13:05:09',NULL),(2675,7525,40875,16670,2,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',301000.00,NULL,NULL,1,'2023-04-25 13:05:19','2023-04-25 13:05:19',NULL),(2676,7525,40875,16670,2,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',9599.99,NULL,NULL,1,'2023-04-25 13:05:35','2023-04-25 13:05:35',NULL),(2677,7525,40875,16670,2,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',22504.96,NULL,NULL,1,'2023-04-25 13:05:51','2023-04-25 13:05:51',NULL),(2678,7525,40875,16670,2,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',25318.08,NULL,NULL,1,'2023-04-25 13:06:10','2023-04-25 13:06:10',NULL),(2679,7525,40875,16670,2,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',22504.96,NULL,NULL,1,'2023-04-25 13:06:26','2023-04-25 13:06:26',NULL),(2680,7525,40875,16670,3,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',4999.99,NULL,NULL,1,'2023-04-25 13:32:32','2023-04-25 13:32:32',NULL),(2681,7525,40875,16670,3,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',9008.20,NULL,NULL,1,'2023-04-25 13:33:45','2023-04-25 13:33:45',NULL),(2682,7525,40875,16670,3,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',218905.00,NULL,NULL,1,'2023-04-25 13:37:06','2023-04-25 13:37:06',NULL),(2683,7525,40875,16670,3,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',30245.72,NULL,NULL,1,'2023-04-25 13:38:58','2023-04-25 13:38:58',NULL);
INSERT INTO `balance_libro` VALUES (2684,7525,40875,16670,3,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',5820.00,NULL,NULL,1,'2023-04-25 13:39:14','2023-04-25 13:39:14',NULL),(2685,7525,40875,16670,3,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',7500.00,NULL,NULL,1,'2023-04-25 13:39:28','2023-04-25 13:39:28',NULL),(2686,7525,40875,16670,3,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',9008.20,NULL,NULL,1,'2023-04-25 13:40:15','2023-04-25 13:40:15',NULL),(2687,7525,40875,16670,3,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',7722.00,NULL,NULL,1,'2023-04-25 13:47:57','2023-04-25 13:47:57',NULL),(2688,7525,40875,16670,3,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',922.31,NULL,NULL,1,'2023-04-25 13:50:00','2023-04-25 13:50:00',NULL),(2689,7525,40875,16670,3,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',10502.72,NULL,NULL,1,'2023-04-25 13:52:43','2023-04-25 13:52:43',NULL),(2690,7525,40875,16670,3,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',24000.00,NULL,NULL,1,'2023-04-25 13:54:07','2023-04-25 13:54:07',NULL),(2691,7525,41011,25751,3,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',23205.00,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 14:23:49',NULL),(2692,7525,41011,25751,3,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',6087.40,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 15:44:19','2023-04-25 15:44:19'),(2693,7525,41011,25751,3,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',6238.42,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 15:43:32','2023-04-25 15:43:32'),(2694,7525,41011,25751,3,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',6628.81,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 15:36:10','2023-04-25 15:36:10'),(2695,7525,41011,25751,3,2069,'App\\Models\\Receipt',2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',29282.50,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 14:23:49',NULL),(2696,7525,41011,25751,3,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',6117.00,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 15:32:42','2023-04-25 15:32:42'),(2697,7525,41011,25751,3,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',6743.86,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 15:31:44','2023-04-25 15:31:44'),(2698,7525,41011,25751,3,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',19890.00,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 14:23:49',NULL),(2699,7525,41011,25751,3,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',32210.75,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 14:23:49',NULL),(2700,7525,41011,25751,3,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',6675.39,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 15:29:59','2023-04-25 15:29:59'),(2701,7525,41011,25751,3,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',7512.05,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 15:27:25','2023-04-25 15:27:25'),(2702,7525,41011,25751,3,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',40332.50,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 14:23:49',NULL),(2703,7525,41011,25751,3,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4795.55,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 15:26:04','2023-04-25 15:26:04');
INSERT INTO `balance_libro` VALUES (2704,7525,41011,25751,3,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',30387.50,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 14:23:49',NULL),(2705,7525,41011,25751,3,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',6655.81,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 14:54:53','2023-04-25 14:54:53'),(2706,7525,41011,25751,3,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',8500.00,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 14:54:00','2023-04-25 14:54:00'),(2707,7525,41011,25751,3,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',19890.00,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 14:23:49',NULL),(2708,7525,41011,25751,3,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',4979.11,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 14:53:38','2023-04-25 14:53:38'),(2709,7525,41011,25751,3,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',19890.00,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 14:23:49',NULL),(2710,7525,41011,25751,3,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',7589.73,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 14:52:06','2023-04-25 14:52:06'),(2711,7525,41011,25751,3,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',21304.40,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 14:23:49',NULL),(2712,7525,41011,25751,3,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',30991.38,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 14:50:45','2023-04-25 14:50:45'),(2713,7525,41011,25751,3,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',27625.00,NULL,NULL,1,'2023-04-25 14:23:49','2023-04-25 14:23:49',NULL),(2714,7525,41011,25751,3,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',6360.14,NULL,NULL,1,'2023-04-25 14:23:50','2023-04-25 14:50:28','2023-04-25 14:50:28'),(2715,7525,41011,25751,3,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',26520.00,NULL,NULL,1,'2023-04-25 14:23:50','2023-04-25 14:23:50',NULL),(2716,7525,41011,25751,3,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',25470.25,NULL,NULL,1,'2023-04-25 14:23:50','2023-04-25 14:23:50',NULL),(2717,7525,41011,25751,3,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',7100.99,NULL,NULL,1,'2023-04-25 14:23:50','2023-04-25 14:46:25','2023-04-25 14:46:25'),(2718,7525,41011,25751,3,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',8455.93,NULL,NULL,1,'2023-04-25 14:23:50','2023-04-25 14:45:22','2023-04-25 14:45:22'),(2719,7525,41011,25751,2,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',55800.00,NULL,NULL,1,'2023-04-25 14:24:05','2023-04-25 14:24:05',NULL),(2720,7525,41011,25751,2,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',26100.05,NULL,NULL,1,'2023-04-25 14:24:05','2023-04-25 14:24:05',NULL),(2721,7525,41011,25751,2,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',30650.00,NULL,NULL,1,'2023-04-25 14:24:05','2023-04-25 14:24:05',NULL),(2722,7525,41011,25751,2,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',35600.02,NULL,NULL,1,'2023-04-25 14:24:05','2023-04-25 14:24:05',NULL),(2723,7525,41011,25751,2,2097,'App\\Models\\Receipt',2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',33099.99,NULL,NULL,1,'2023-04-25 14:24:05','2023-04-25 14:24:05',NULL);
INSERT INTO `balance_libro` VALUES (2724,7525,41011,25751,2,2098,'App\\Models\\Receipt',2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',26100.01,NULL,NULL,1,'2023-04-25 14:24:05','2023-04-25 14:24:05',NULL),(2725,7525,41011,25751,2,2099,'App\\Models\\Receipt',2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',30650.00,NULL,NULL,1,'2023-04-25 14:24:05','2023-04-25 14:24:05',NULL),(2726,7525,41011,25751,2,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',24600.04,NULL,NULL,1,'2023-04-25 14:24:05','2023-04-25 14:24:05',NULL),(2727,7525,41011,25751,2,2101,'App\\Models\\Receipt',2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',65642.50,NULL,NULL,1,'2023-04-25 14:24:05','2023-04-25 14:24:05',NULL),(2728,7525,41011,25751,3,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',8455.93,NULL,NULL,1,'2023-04-25 14:45:22','2023-04-25 14:45:22',NULL),(2729,7525,41011,25751,3,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',7100.99,NULL,NULL,1,'2023-04-25 14:46:25','2023-04-25 14:46:25',NULL),(2730,7525,41011,25751,3,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',6360.15,NULL,NULL,1,'2023-04-25 14:50:28','2023-04-25 14:50:28',NULL),(2731,7525,41011,25751,3,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',7589.72,NULL,NULL,1,'2023-04-25 14:52:06','2023-04-25 14:52:06',NULL),(2732,7525,41011,25751,3,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',4979.10,NULL,NULL,1,'2023-04-25 14:53:38','2023-04-25 14:53:38',NULL),(2733,7525,41011,25751,3,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',8500.00,NULL,NULL,1,'2023-04-25 14:54:00','2023-04-25 14:54:00',NULL),(2734,7525,41011,25751,3,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',6655.80,NULL,NULL,1,'2023-04-25 14:54:53','2023-04-25 14:54:53',NULL),(2735,7525,41011,25751,3,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4795.55,NULL,NULL,1,'2023-04-25 15:26:04','2023-04-25 15:26:04',NULL),(2736,7525,41011,25751,3,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',7512.03,NULL,NULL,1,'2023-04-25 15:27:25','2023-04-25 15:27:25',NULL),(2737,7525,41011,25751,3,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',6675.38,NULL,NULL,1,'2023-04-25 15:29:59','2023-04-25 15:29:59',NULL),(2738,7525,41011,25751,3,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',6743.87,NULL,NULL,1,'2023-04-25 15:31:44','2023-04-25 15:31:44',NULL),(2739,7525,41011,25751,3,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',6116.99,NULL,NULL,1,'2023-04-25 15:32:42','2023-04-25 15:32:42',NULL),(2740,7525,41011,25751,3,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',6628.81,NULL,NULL,1,'2023-04-25 15:36:10','2023-04-25 15:36:10',NULL),(2741,7525,41011,25751,3,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',6238.42,NULL,NULL,1,'2023-04-25 15:43:32','2023-04-25 15:43:32',NULL),(2742,7525,41011,25751,3,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',6087.40,NULL,NULL,1,'2023-04-25 15:44:19','2023-04-25 15:44:19',NULL),(2743,7525,41011,25751,3,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',5100.00,NULL,NULL,1,'2023-04-25 15:46:13','2023-04-25 15:46:13',NULL),(2744,7525,41011,25751,3,2103,'App\\Models\\Receipt',2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',5100.00,NULL,NULL,1,'2023-04-25 15:46:38','2023-04-25 15:46:38',NULL);
INSERT INTO `balance_libro` VALUES (2745,7525,41011,25751,3,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',130000.00,NULL,NULL,1,'2023-04-25 15:47:28','2023-04-25 15:47:28',NULL),(2746,7525,41011,25751,3,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',8876.44,NULL,NULL,1,'2023-04-25 15:49:22','2023-04-25 15:49:22',NULL),(2747,7525,41011,25751,3,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',8193.64,NULL,NULL,1,'2023-04-25 15:51:56','2023-04-25 15:51:56',NULL),(2748,7525,41011,25751,3,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',8379.53,NULL,NULL,1,'2023-04-25 15:53:22','2023-04-25 15:53:22',NULL),(2749,7525,41011,25751,15,1531,'App\\Models\\PeriodLiquidation',NULL,1531,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',148730.96,NULL,NULL,1,'2023-04-25 16:10:18','2023-04-25 16:10:18',NULL),(2750,7525,40875,16670,15,1506,'App\\Models\\PeriodLiquidation',NULL,1506,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',306435.10,NULL,NULL,1,'2023-04-25 16:10:43','2023-04-25 16:10:43',NULL),(2758,7525,40906,18182,3,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',57500.00,NULL,NULL,1,'2023-04-25 16:53:26','2023-04-25 16:53:26',NULL),(2759,7525,40906,18182,3,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1260.00,NULL,NULL,1,'2023-04-25 16:53:26','2023-04-25 16:56:30','2023-04-25 16:56:30'),(2760,7525,40906,18182,3,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',2762.49,NULL,NULL,1,'2023-04-25 16:53:26','2023-04-25 16:56:25','2023-04-25 16:56:25'),(2761,7525,40906,18182,3,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',8000.00,NULL,NULL,1,'2023-04-25 16:53:26','2023-04-25 16:56:03','2023-04-25 16:56:03'),(2762,7525,40906,18182,3,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1211.00,NULL,NULL,1,'2023-04-25 16:53:26','2023-04-25 16:55:56','2023-04-25 16:55:56'),(2763,7525,40906,18182,3,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',999.00,NULL,NULL,1,'2023-04-25 16:53:26','2023-04-25 16:55:50','2023-04-25 16:55:50'),(2764,7525,40906,18182,3,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',26600.00,NULL,NULL,1,'2023-04-25 16:53:26','2023-04-25 16:55:44','2023-04-25 16:55:44'),(2765,7525,40906,18182,3,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2199.00,NULL,NULL,1,'2023-04-25 16:53:26','2023-04-25 16:55:37','2023-04-25 16:55:37'),(2766,7525,40906,18182,3,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',8000.00,NULL,NULL,1,'2023-04-25 16:56:03','2023-04-25 16:56:03',NULL),(2767,7525,40906,18182,7,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',85586.63,NULL,NULL,1,'2023-04-25 17:00:26','2023-04-25 17:00:26',NULL),(2768,7525,40906,18182,15,1532,'App\\Models\\PeriodLiquidation',NULL,1532,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',183810.91,NULL,NULL,1,'2023-04-25 17:01:54','2023-04-25 17:01:54',NULL),(2769,7525,40917,19697,2,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',344000.70,NULL,NULL,1,'2023-04-25 17:54:14','2023-04-25 17:54:14',NULL),(2770,7525,40917,19697,2,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',5340.02,NULL,NULL,1,'2023-04-25 17:54:14','2023-04-25 17:54:14',NULL),(2771,7525,40917,19697,2,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',23450.07,NULL,NULL,1,'2023-04-25 17:54:14','2023-04-25 17:54:14',NULL);
INSERT INTO `balance_libro` VALUES (2772,7525,40917,19697,2,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',144000.41,NULL,NULL,1,'2023-04-25 17:54:14','2023-04-25 17:54:14',NULL),(2773,7525,40917,19697,2,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',18000.03,NULL,NULL,1,'2023-04-25 17:54:14','2023-04-25 17:54:14',NULL),(2774,7525,40917,19697,2,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',107801.08,NULL,NULL,1,'2023-04-25 17:54:14','2023-04-25 17:54:14',NULL),(2775,7525,40917,19697,2,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',92000.11,NULL,NULL,1,'2023-04-25 17:54:14','2023-04-25 17:54:14',NULL),(2776,7525,40917,19697,2,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',23260.17,NULL,NULL,1,'2023-04-25 17:54:14','2023-04-25 17:54:14',NULL),(2777,7525,40917,19697,2,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',344000.70,NULL,NULL,1,'2023-04-25 17:54:14','2023-04-25 17:54:14',NULL),(2778,7525,40917,19697,2,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',20000.03,NULL,NULL,1,'2023-04-25 17:54:14','2023-04-25 17:54:14',NULL),(2779,7525,40917,19697,2,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',169000.33,NULL,NULL,1,'2023-04-25 17:54:15','2023-04-25 17:54:15',NULL),(2780,7525,40917,19697,2,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',150800.39,NULL,NULL,1,'2023-04-25 17:54:15','2023-04-25 17:54:15',NULL),(2781,7525,40917,19697,2,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',181601.40,NULL,NULL,1,'2023-04-25 17:54:15','2023-04-25 17:54:15',NULL),(2782,7525,40917,19697,2,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',147750.37,NULL,NULL,1,'2023-04-25 17:54:15','2023-04-25 17:54:15',NULL),(2783,7525,40917,19697,2,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',242000.00,NULL,NULL,1,'2023-04-25 17:54:15','2023-04-25 17:54:15',NULL),(2784,7525,40917,19697,2,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',140161.17,NULL,NULL,1,'2023-04-25 17:54:15','2023-04-25 17:54:15',NULL),(2785,7525,40917,19697,2,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',151250.00,NULL,NULL,1,'2023-04-25 17:54:15','2023-04-25 17:54:15',NULL),(2786,7525,40917,19697,2,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',138500.54,NULL,NULL,1,'2023-04-25 17:54:15','2023-04-25 17:54:15',NULL),(2787,7525,40917,19697,2,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',175400.82,NULL,NULL,1,'2023-04-25 17:54:15','2023-04-25 17:54:15',NULL),(2788,7525,40917,19697,2,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',220002.20,NULL,NULL,1,'2023-04-25 17:54:15','2023-04-25 17:54:15',NULL),(2789,7525,40917,19697,2,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',336000.66,NULL,NULL,1,'2023-04-25 17:54:15','2023-04-25 17:54:15',NULL),(2790,7525,40917,19697,2,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',302500.00,NULL,NULL,1,'2023-04-25 17:54:15','2023-04-25 17:54:15',NULL),(2791,7525,40917,19697,2,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',19700.16,NULL,NULL,1,'2023-04-25 17:54:15','2023-04-25 17:54:15',NULL);
INSERT INTO `balance_libro` VALUES (2792,7525,40917,19697,2,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',15960.06,NULL,NULL,1,'2023-04-25 17:54:15','2023-04-25 17:54:15',NULL),(2793,7525,40917,19697,2,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',108980.92,NULL,NULL,1,'2023-04-25 17:54:15','2023-04-25 17:54:15',NULL),(2794,7525,40917,19697,2,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',217800.00,NULL,NULL,1,'2023-04-25 17:54:15','2023-04-25 17:54:15',NULL),(2795,7525,40917,19697,2,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',149000.18,NULL,NULL,1,'2023-04-25 17:54:15','2023-04-25 17:54:15',NULL),(2796,7525,40917,19697,3,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',34783.65,NULL,NULL,1,'2023-04-25 17:55:18','2023-04-25 18:09:13','2023-04-25 18:09:13'),(2797,7525,40917,19697,3,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',188079.98,NULL,NULL,1,'2023-04-25 17:55:18','2023-04-25 17:55:18',NULL),(2798,7525,40917,19697,3,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',43937.30,NULL,NULL,1,'2023-04-25 17:55:18','2023-04-25 18:08:24','2023-04-25 18:08:24'),(2799,7525,40917,19697,3,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',233477.59,NULL,NULL,1,'2023-04-25 17:55:18','2023-04-25 17:55:18',NULL),(2800,7525,40917,19697,3,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',115314.12,NULL,NULL,1,'2023-04-25 17:55:18','2023-04-25 18:06:02','2023-04-25 18:06:02'),(2801,7525,40917,19697,3,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',296182.08,NULL,NULL,1,'2023-04-25 17:55:18','2023-04-25 17:55:18',NULL),(2802,7525,40917,19697,3,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',115314.34,NULL,NULL,1,'2023-04-25 17:55:18','2023-04-25 18:04:52','2023-04-25 18:04:52'),(2803,7525,40917,19697,3,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',20351.99,NULL,NULL,1,'2023-04-25 17:55:18','2023-04-25 17:55:18',NULL),(2804,7525,40917,19697,3,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',159244.81,NULL,NULL,1,'2023-04-25 17:55:18','2023-04-25 17:55:18',NULL),(2805,7525,40917,19697,3,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',12431.59,NULL,NULL,1,'2023-04-25 17:55:18','2023-04-25 18:03:31','2023-04-25 18:03:31'),(2806,7525,40917,19697,3,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',102119.96,NULL,NULL,1,'2023-04-25 17:55:19','2023-04-25 17:55:19',NULL),(2807,7525,40917,19697,3,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',8000.00,NULL,NULL,1,'2023-04-25 17:55:19','2023-04-25 18:02:46','2023-04-25 18:02:46'),(2808,7525,40917,19697,3,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',55580.02,NULL,NULL,1,'2023-04-25 17:55:19','2023-04-25 18:02:36','2023-04-25 18:02:36'),(2809,7525,40917,19697,3,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',90399.58,NULL,NULL,1,'2023-04-25 17:55:19','2023-04-25 17:55:19',NULL),(2810,7525,40917,19697,3,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',143619.85,NULL,NULL,1,'2023-04-25 17:55:19','2023-04-25 17:55:19',NULL),(2811,7525,40917,19697,3,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',88799.97,NULL,NULL,1,'2023-04-25 17:55:19','2023-04-25 17:55:19',NULL);
INSERT INTO `balance_libro` VALUES (2812,7525,40917,19697,3,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',63040.87,NULL,NULL,1,'2023-04-25 17:55:19','2023-04-25 18:01:09','2023-04-25 18:01:09'),(2813,7525,40917,19697,3,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',189094.82,NULL,NULL,1,'2023-04-25 17:55:19','2023-04-25 17:55:19',NULL),(2814,7525,40917,19697,3,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',63040.87,NULL,NULL,1,'2023-04-25 18:01:09','2023-04-26 10:06:24','2023-04-26 10:06:24'),(2815,7525,40917,19697,3,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',55580.02,NULL,NULL,1,'2023-04-25 18:02:36','2023-04-25 18:02:36',NULL),(2816,7525,40917,19697,3,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',8000.00,NULL,NULL,1,'2023-04-25 18:02:46','2023-04-25 18:02:46',NULL),(2817,7525,40917,19697,3,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',14150.52,NULL,NULL,1,'2023-04-25 18:03:31','2023-04-25 18:03:31',NULL),(2818,7525,40917,19697,3,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',115314.35,NULL,NULL,1,'2023-04-25 18:04:52','2023-04-25 18:04:52',NULL),(2819,7525,40917,19697,3,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',115314.12,NULL,NULL,1,'2023-04-25 18:06:02','2023-04-25 18:06:02',NULL),(2820,7525,40917,19697,3,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',43937.30,NULL,NULL,1,'2023-04-25 18:08:24','2023-04-25 18:08:24',NULL),(2821,7525,40917,19697,3,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',34783.64,NULL,NULL,1,'2023-04-25 18:09:13','2023-04-25 18:09:13',NULL),(2822,7525,40917,19697,3,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',110589.08,NULL,NULL,1,'2023-04-26 09:32:11','2023-04-26 09:32:11',NULL),(2823,7525,40917,19697,3,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',95055.24,NULL,NULL,1,'2023-04-26 09:32:46','2023-04-26 09:32:46',NULL),(2824,7525,40917,19697,3,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',124450.43,NULL,NULL,1,'2023-04-26 09:34:38','2023-04-26 09:34:38',NULL),(2825,7525,40917,19697,3,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',57179.93,NULL,NULL,1,'2023-04-26 09:35:17','2023-04-26 09:35:17',NULL),(2826,7525,40917,19697,3,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',246165.92,NULL,NULL,1,'2023-04-26 09:36:16','2023-04-26 09:36:16',NULL),(2827,7525,40917,19697,3,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',153010.92,NULL,NULL,1,'2023-04-26 09:37:54','2023-04-26 09:37:54',NULL),(2828,7525,40917,19697,3,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',121086.91,NULL,NULL,1,'2023-04-26 09:39:22','2023-04-26 09:39:22',NULL),(2829,7525,40917,19697,3,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',20181.15,NULL,NULL,1,'2023-04-26 09:40:14','2023-04-26 09:40:14',NULL),(2830,7525,40917,19697,3,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',90815.17,NULL,NULL,1,'2023-04-26 09:40:45','2023-04-26 09:40:45',NULL),(2831,7525,40917,19697,3,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',221992.67,NULL,NULL,1,'2023-04-26 09:45:33','2023-04-26 09:45:33',NULL);
INSERT INTO `balance_libro` VALUES (2832,7525,40917,19697,3,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',62797.80,NULL,NULL,1,'2023-04-26 09:46:37','2023-04-26 09:46:37',NULL),(2833,7525,40917,19697,3,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',63906.98,NULL,NULL,1,'2023-04-26 09:50:42','2023-04-26 09:50:42',NULL),(2834,7525,40917,19697,3,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',20181.15,NULL,NULL,1,'2023-04-26 09:51:35','2023-04-26 09:51:35',NULL),(2835,7525,40917,19697,3,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',47089.36,NULL,NULL,1,'2023-04-26 09:52:25','2023-04-26 09:52:25',NULL),(2836,7525,40917,19697,3,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',84088.13,NULL,NULL,1,'2023-04-26 09:53:11','2023-04-26 09:53:11',NULL),(2837,7525,40917,19697,3,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',63398.69,NULL,NULL,1,'2023-04-26 10:06:24','2023-04-26 10:06:24',NULL),(2838,7525,40917,19697,7,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',2259.43,NULL,NULL,1,'2023-04-26 10:07:10','2023-04-26 10:07:10',NULL),(2839,7525,40917,19697,15,1559,'App\\Models\\PeriodLiquidation',NULL,1559,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1284799.80,NULL,NULL,1,'2023-04-26 10:48:40','2023-04-26 10:48:40',NULL),(2840,7525,41204,30282,15,1265,'App\\Models\\PeriodLiquidation',NULL,1265,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',287815.75,NULL,NULL,1,'2023-04-26 10:55:58','2023-04-26 10:55:58',NULL),(2841,7525,41204,30281,15,1000,'App\\Models\\PeriodLiquidation',NULL,1000,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',143640.00,NULL,NULL,1,'2023-04-26 10:56:53','2023-04-26 10:56:53',NULL),(2842,7525,41204,30283,2,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',91960.00,NULL,NULL,1,'2023-04-26 11:07:47','2023-04-26 11:07:47',NULL),(2843,7525,41204,30283,3,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',2409.93,NULL,NULL,1,'2023-04-26 11:07:58','2023-04-26 11:12:02','2023-04-26 11:12:02'),(2844,7525,41204,30283,3,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',2000.00,NULL,NULL,1,'2023-04-26 11:07:58','2023-04-26 11:07:58',NULL),(2845,7525,41204,30283,3,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',66550.00,NULL,NULL,1,'2023-04-26 11:07:58','2023-04-26 11:07:58',NULL),(2846,7525,41204,30283,3,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',55000.01,NULL,NULL,1,'2023-04-26 11:07:58','2023-04-26 11:07:58',NULL),(2847,7525,41204,30283,3,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',66550.00,NULL,NULL,1,'2023-04-26 11:07:59','2023-04-26 11:07:59',NULL),(2848,7525,41204,30283,3,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',5000.00,NULL,NULL,1,'2023-04-26 11:07:59','2023-04-26 11:07:59',NULL),(2849,7525,41204,30283,3,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',14164.86,NULL,NULL,1,'2023-04-26 11:07:59','2023-04-26 11:07:59',NULL),(2850,7525,41204,30283,3,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',13990.00,NULL,NULL,1,'2023-04-26 11:07:59','2023-04-26 11:07:59',NULL),(2851,7525,41204,30283,3,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',8000.00,NULL,NULL,1,'2023-04-26 11:07:59','2023-04-26 11:09:53','2023-04-26 11:09:53');
INSERT INTO `balance_libro` VALUES (2852,7525,41204,30283,3,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',8000.00,NULL,NULL,1,'2023-04-26 11:07:59','2023-04-26 11:09:46','2023-04-26 11:09:46'),(2853,7525,41204,30283,3,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3500.00,NULL,NULL,1,'2023-04-26 11:07:59','2023-04-26 11:10:13','2023-04-26 11:10:13'),(2854,7525,41204,30283,3,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',6500.12,NULL,NULL,1,'2023-04-26 11:07:59','2023-04-26 11:07:59',NULL),(2855,7525,41204,30283,3,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',8000.00,NULL,NULL,1,'2023-04-26 11:09:46','2023-04-26 11:09:46',NULL),(2856,7525,41204,30283,3,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',8000.00,NULL,NULL,1,'2023-04-26 11:09:53','2023-04-26 11:09:53',NULL),(2857,7525,41204,30283,3,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',2409.93,NULL,NULL,1,'2023-04-26 11:12:02','2023-04-26 11:12:02',NULL),(2858,7525,41204,30283,3,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',12101.04,NULL,NULL,1,'2023-04-26 11:13:36','2023-04-26 11:13:36',NULL),(2859,7525,41204,30283,3,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',32002.98,NULL,NULL,1,'2023-04-26 11:14:08','2023-04-26 11:14:08',NULL),(2860,7525,41204,30283,3,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',19961.93,NULL,NULL,1,'2023-04-26 11:14:41','2023-04-26 11:14:41',NULL),(2861,7525,41204,30283,3,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',11010.95,NULL,NULL,1,'2023-04-26 11:15:16','2023-04-26 11:15:16',NULL),(2862,7525,41204,30283,7,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1418.57,NULL,NULL,1,'2023-04-26 11:19:27','2023-04-26 11:27:37','2023-04-26 11:27:37'),(2863,7525,41204,30283,7,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1428.49,NULL,NULL,1,'2023-04-26 11:27:37','2023-04-26 11:27:37',NULL),(2864,7525,41204,30283,15,1582,'App\\Models\\PeriodLiquidation',NULL,1582,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',42240.67,NULL,NULL,1,'2023-04-26 11:39:29','2023-04-26 11:39:29',NULL),(2865,7525,40915,22723,15,1267,'App\\Models\\PeriodLiquidation',NULL,1267,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',83732.75,NULL,NULL,1,'2023-04-26 11:41:07','2023-04-26 11:41:07',NULL),(2866,7525,40915,22724,2,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',337851.36,NULL,NULL,1,'2023-04-26 11:53:42','2023-04-26 11:53:42',NULL),(2867,7525,40915,22724,2,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',80404.50,NULL,NULL,1,'2023-04-26 11:53:42','2023-04-26 11:53:42',NULL),(2868,7525,40915,22724,2,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',115682.05,NULL,NULL,1,'2023-04-26 11:53:42','2023-04-26 11:53:42',NULL),(2869,7525,40915,22724,3,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',39843.25,NULL,NULL,1,'2023-04-26 11:53:51','2023-04-26 12:06:28','2023-04-26 12:06:28'),(2870,7525,40915,22724,3,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',35500.19,NULL,NULL,1,'2023-04-26 11:53:51','2023-04-26 11:53:51',NULL),(2871,7525,40915,22724,3,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',61661.60,NULL,NULL,1,'2023-04-26 11:53:51','2023-04-26 11:53:51',NULL);
INSERT INTO `balance_libro` VALUES (2872,7525,40915,22724,3,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',302734.86,NULL,NULL,1,'2023-04-26 11:53:51','2023-04-26 11:53:51',NULL),(2873,7525,40915,22724,3,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',26000.00,NULL,NULL,1,'2023-04-26 11:53:51','2023-04-26 11:53:51',NULL),(2874,7525,40915,22724,3,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',8000.00,NULL,NULL,1,'2023-04-26 11:53:51','2023-04-26 12:02:19','2023-04-26 12:02:19'),(2875,7525,40915,22724,3,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',28052.64,NULL,NULL,1,'2023-04-26 11:53:51','2023-04-26 11:53:51',NULL),(2876,7525,40915,22724,3,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',64135.14,NULL,NULL,1,'2023-04-26 11:53:51','2023-04-26 11:53:51',NULL),(2877,7525,40915,22724,3,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',5701.71,NULL,NULL,1,'2023-04-26 11:53:51','2023-04-26 12:01:30','2023-04-26 12:01:30'),(2878,7525,40915,22724,3,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',40167.16,NULL,NULL,1,'2023-04-26 11:53:51','2023-04-26 11:53:51',NULL),(2879,7525,40915,22724,3,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',20987.45,NULL,NULL,1,'2023-04-26 11:53:52','2023-04-26 11:53:52',NULL),(2880,7525,40915,22724,3,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',7699.95,NULL,NULL,1,'2023-04-26 11:53:52','2023-04-26 12:00:04','2023-04-26 12:00:04'),(2881,7525,40915,22724,3,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',9350.88,NULL,NULL,1,'2023-04-26 11:53:52','2023-04-26 11:53:52',NULL),(2882,7525,40915,22724,3,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',75843.41,NULL,NULL,1,'2023-04-26 11:53:52','2023-04-26 11:53:52',NULL),(2883,7525,40915,22724,3,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',0.00,NULL,NULL,1,'2023-04-26 11:53:52','2023-04-26 11:59:35','2023-04-26 11:59:35'),(2884,7525,40915,22724,3,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',7699.95,NULL,NULL,1,'2023-04-26 12:00:04','2023-04-26 12:00:04',NULL),(2885,7525,40915,22724,3,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',5701.70,NULL,NULL,1,'2023-04-26 12:01:30','2023-04-26 12:01:30',NULL),(2886,7525,40915,22724,3,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',8000.00,NULL,NULL,1,'2023-04-26 12:02:19','2023-04-26 12:02:19',NULL),(2887,7525,40915,22724,3,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',39843.26,NULL,NULL,1,'2023-04-26 12:06:28','2023-04-26 12:06:28',NULL),(2888,7525,40915,22724,3,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',8301.40,NULL,NULL,1,'2023-04-26 12:09:28','2023-04-26 12:09:28',NULL),(2889,7525,40915,22724,3,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',8233.74,NULL,NULL,1,'2023-04-26 12:09:57','2023-04-26 12:09:57',NULL),(2890,7525,40915,22724,3,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',6001.94,NULL,NULL,1,'2023-04-26 12:10:30','2023-04-26 12:10:30',NULL),(2891,7525,40915,22724,3,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',7000.01,NULL,NULL,1,'2023-04-26 12:11:03','2023-04-26 12:11:03',NULL);
INSERT INTO `balance_libro` VALUES (2892,7525,40915,22724,3,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',3999.98,NULL,NULL,1,'2023-04-26 12:18:03','2023-04-26 12:18:03',NULL),(2893,7525,40915,22724,3,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',8366.42,NULL,NULL,1,'2023-04-26 12:21:09','2023-04-26 12:21:09',NULL),(2894,7525,40915,22724,3,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',4999.82,NULL,NULL,1,'2023-04-26 12:21:40','2023-04-26 12:21:40',NULL),(2895,7525,40915,22724,3,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',8400.90,NULL,NULL,1,'2023-04-26 12:30:25','2023-04-26 12:30:25',NULL),(2896,7525,40915,22724,3,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',39446.52,NULL,NULL,1,'2023-04-26 12:32:53','2023-04-26 12:32:53',NULL),(2897,7525,40915,22724,3,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',6801.20,NULL,NULL,1,'2023-04-26 12:47:09','2023-04-26 12:47:09',NULL),(2898,7525,40915,22724,15,1584,'App\\Models\\PeriodLiquidation',NULL,1584,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',146402.30,NULL,NULL,1,'2023-04-26 13:19:10','2023-04-26 13:19:10',NULL),(2899,7525,40839,12131,2,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',108900.00,NULL,NULL,1,'2023-04-26 17:24:40','2023-04-26 17:24:40',NULL),(2900,7525,40839,12131,2,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',105875.00,NULL,NULL,1,'2023-04-26 17:24:40','2023-04-26 17:24:40',NULL),(2901,7525,40839,12131,3,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',240.00,NULL,NULL,1,'2023-04-26 17:24:53','2023-04-26 17:28:20','2023-04-26 17:28:20'),(2902,7525,40839,12131,3,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',9301.00,NULL,NULL,1,'2023-04-26 17:24:53','2023-04-26 17:29:06','2023-04-26 17:29:06'),(2903,7525,40839,12131,3,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',8000.00,NULL,NULL,1,'2023-04-26 17:24:53','2023-04-26 17:27:55','2023-04-26 17:27:55'),(2904,7525,40839,12131,3,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',8333.33,NULL,NULL,1,'2023-04-26 17:24:53','2023-04-26 17:27:49','2023-04-26 17:27:49'),(2905,7525,40839,12131,3,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',698.98,NULL,NULL,1,'2023-04-26 17:24:53','2023-04-26 17:27:20','2023-04-26 17:27:20'),(2906,7525,40839,12131,3,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',93055.23,NULL,NULL,1,'2023-04-26 17:24:53','2023-04-26 17:27:09','2023-04-26 17:27:09'),(2907,7525,40839,12131,3,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',11290.00,NULL,NULL,1,'2023-04-26 17:24:53','2023-04-26 17:26:10','2023-04-26 17:26:10'),(2908,7525,40839,12131,3,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',11290.00,NULL,NULL,1,'2023-04-26 17:26:10','2023-04-26 17:26:10',NULL),(2909,7525,40839,12131,3,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',93055.23,NULL,NULL,1,'2023-04-26 17:27:09','2023-04-26 17:27:09',NULL),(2910,7525,40839,12131,3,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',698.98,NULL,NULL,1,'2023-04-26 17:27:20','2023-04-26 17:27:20',NULL),(2911,7525,40839,12131,3,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',8360.09,NULL,NULL,1,'2023-04-26 17:27:49','2023-04-26 17:27:49',NULL);
INSERT INTO `balance_libro` VALUES (2912,7525,40839,12131,3,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',8000.00,NULL,NULL,1,'2023-04-26 17:27:55','2023-04-26 17:27:55',NULL),(2913,7525,40839,12131,3,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',240.09,NULL,NULL,1,'2023-04-26 17:28:20','2023-04-26 17:28:20',NULL),(2914,7525,40839,12131,3,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',9301.00,NULL,NULL,1,'2023-04-26 17:29:06','2023-04-26 17:29:06',NULL),(2915,7525,40839,12131,3,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',10463.92,NULL,NULL,1,'2023-04-26 17:30:26','2023-04-26 17:30:26',NULL),(2916,7525,40839,12131,3,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',7447.23,NULL,NULL,1,'2023-04-26 17:31:10','2023-04-26 17:31:10',NULL),(2917,7525,40839,12131,3,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',5376.93,NULL,NULL,1,'2023-04-26 17:32:28','2023-04-26 17:32:28',NULL),(2918,7525,40839,12131,3,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',10000.87,NULL,NULL,1,'2023-04-26 17:33:46','2023-04-26 17:33:46',NULL),(2919,7525,41184,28767,2,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',43560.00,NULL,NULL,1,'2023-05-02 14:16:28','2023-05-02 14:16:28',NULL),(2920,7525,41184,28767,3,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',54223.00,NULL,NULL,1,'2023-05-02 14:16:48','2023-05-02 14:16:48',NULL),(2921,7525,41184,28767,3,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',182412.00,NULL,NULL,1,'2023-05-02 14:16:48','2023-05-02 14:16:48',NULL),(2922,7525,41184,28767,3,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',112944.01,NULL,NULL,1,'2023-05-02 14:16:48','2023-05-02 14:16:48',NULL),(2923,7525,41184,28767,3,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',13003.59,NULL,NULL,1,'2023-05-02 14:16:48','2023-05-12 11:05:54','2023-05-12 11:05:54'),(2924,7525,41184,28767,3,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',544.00,NULL,NULL,1,'2023-05-11 16:46:18','2023-05-11 16:47:00','2023-05-11 16:47:00'),(2925,7525,41184,28767,3,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',123420.00,NULL,NULL,1,'2023-05-11 16:46:18','2023-05-11 16:46:18',NULL),(2926,7525,41184,28767,3,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',13003.59,NULL,NULL,1,'2023-05-12 11:05:54','2023-05-12 11:05:54',NULL),(2927,7525,41184,28767,3,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',11801.04,NULL,NULL,1,'2023-05-12 11:09:54','2023-05-12 11:09:54',NULL),(2928,7525,41184,28767,3,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',6230.53,NULL,NULL,1,'2023-05-12 11:11:29','2023-05-12 11:11:29',NULL),(2929,7525,41184,28767,15,1600,'App\\Models\\PeriodLiquidation',NULL,1600,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',94834.19,NULL,NULL,1,'2023-05-16 17:23:00','2023-05-16 17:23:00',NULL),(2930,8694,41023,27270,2,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',266564.21,NULL,NULL,1,'2023-05-19 20:22:33','2023-05-19 20:22:33',NULL),(2931,8694,41023,27270,3,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',16672.23,NULL,NULL,1,'2023-05-19 20:23:49','2023-05-19 20:31:00','2023-05-19 20:31:00');
INSERT INTO `balance_libro` VALUES (2932,8694,41023,27270,3,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',7360.00,NULL,NULL,1,'2023-05-19 20:23:49','2023-05-19 20:34:40','2023-05-19 20:34:40'),(2933,8694,41023,27270,3,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',15000.00,NULL,NULL,1,'2023-05-19 20:23:49','2023-05-19 20:33:11','2023-05-19 20:33:11'),(2934,8694,41023,27270,3,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',15000.00,NULL,NULL,1,'2023-05-19 20:23:49','2023-05-19 20:23:49',NULL),(2935,8694,41023,27270,3,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',11085.65,NULL,NULL,1,'2023-05-19 20:23:49','2023-05-19 20:36:23','2023-05-19 20:36:23'),(2936,8694,41023,27270,3,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',855.00,NULL,NULL,1,'2023-05-19 20:23:49','2023-05-23 13:15:32','2023-05-23 13:15:32'),(2937,8694,41023,27270,3,2260,'App\\Models\\Receipt',2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',4599.97,NULL,NULL,1,'2023-05-19 20:23:49','2023-05-23 13:37:25','2023-05-23 13:37:25'),(2938,8694,41023,27270,3,2261,'App\\Models\\Receipt',2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',3600.00,NULL,NULL,1,'2023-05-19 20:23:49','2023-05-19 20:23:49',NULL),(2939,8694,41023,27270,3,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',271390.58,NULL,NULL,1,'2023-05-19 20:23:49','2023-05-19 20:23:49',NULL),(2940,8694,41023,27270,3,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',16672.23,NULL,NULL,1,'2023-05-19 20:31:00','2023-05-19 20:31:00',NULL),(2941,8694,41023,27270,3,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',15000.00,NULL,NULL,1,'2023-05-19 20:33:11','2023-05-19 20:33:11',NULL),(2942,8694,41023,27270,3,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',7360.00,NULL,NULL,1,'2023-05-19 20:34:40','2023-05-19 20:34:40',NULL),(2943,8694,41023,27270,3,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',11085.64,NULL,NULL,1,'2023-05-19 20:36:23','2023-05-19 20:36:23',NULL),(2944,8694,41023,27271,2,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',1151932.66,NULL,NULL,1,'2023-05-19 20:43:14','2023-05-19 20:49:28','2023-05-19 20:49:28'),(2945,8694,41023,27271,2,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',1195250.88,NULL,NULL,1,'2023-05-19 20:43:14','2023-05-19 20:50:29','2023-05-19 20:50:29'),(2946,8694,41023,27271,2,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',1151932.66,NULL,NULL,1,'2023-05-19 20:43:14','2023-05-19 20:52:02','2023-05-19 20:52:02'),(2947,8694,41023,27271,3,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',100000.00,NULL,NULL,1,'2023-05-19 20:44:03','2023-05-23 14:06:57','2023-05-23 14:06:57'),(2948,8694,41023,27271,3,2267,'App\\Models\\Receipt',2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',100000.00,NULL,NULL,1,'2023-05-19 20:44:03','2023-05-23 14:06:49','2023-05-23 14:06:49'),(2949,8694,41023,27271,3,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1005.00,NULL,NULL,1,'2023-05-19 20:44:03','2023-05-23 14:06:39','2023-05-23 14:06:39'),(2950,8694,41023,27271,3,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',8550.00,NULL,NULL,1,'2023-05-19 20:44:03','2023-05-19 20:56:15','2023-05-19 20:56:15');
INSERT INTO `balance_libro` VALUES (2951,8694,41023,27271,3,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',100000.00,NULL,NULL,1,'2023-05-19 20:44:03','2023-05-23 14:06:26','2023-05-23 14:06:26'),(2952,8694,41023,27271,3,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',15000.00,NULL,NULL,1,'2023-05-19 20:44:03','2023-05-19 20:58:58','2023-05-19 20:58:58'),(2953,8694,41023,27271,3,2272,'App\\Models\\Receipt',2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',15720.00,NULL,NULL,1,'2023-05-19 20:44:03','2023-05-19 21:00:08','2023-05-19 21:00:08'),(2954,8694,41023,27271,3,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',48548.60,NULL,NULL,1,'2023-05-19 20:44:03','2023-05-19 21:03:09','2023-05-19 21:03:09'),(2955,8694,41023,27271,3,2274,'App\\Models\\Receipt',2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',8800.00,NULL,NULL,1,'2023-05-19 20:44:03','2023-05-19 21:04:12','2023-05-19 21:04:12'),(2956,8694,41023,27271,2,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',1151932.66,NULL,NULL,1,'2023-05-19 20:49:28','2023-05-19 20:49:28',NULL),(2957,8694,41023,27271,2,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',1195250.88,NULL,NULL,1,'2023-05-19 20:50:29','2023-05-19 20:50:29',NULL),(2958,8694,41023,27271,2,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',1151932.66,NULL,NULL,1,'2023-05-19 20:52:02','2023-05-19 20:52:02',NULL),(2959,8694,41023,27271,3,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',8550.01,NULL,NULL,1,'2023-05-19 20:56:15','2023-05-19 20:56:15',NULL),(2960,8694,41023,27271,3,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',15000.00,NULL,NULL,1,'2023-05-19 20:58:58','2023-05-19 20:58:58',NULL),(2961,8694,41023,27271,3,2272,'App\\Models\\Receipt',2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',15720.01,NULL,NULL,1,'2023-05-19 21:00:08','2023-05-19 21:00:08',NULL),(2962,8694,41023,27271,3,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',48548.60,NULL,NULL,1,'2023-05-19 21:03:09','2023-05-19 21:03:09',NULL),(2963,8694,41023,27271,3,2274,'App\\Models\\Receipt',2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',8800.00,NULL,NULL,1,'2023-05-19 21:04:12','2023-05-19 21:04:12',NULL),(2964,8694,41023,27271,3,2275,'App\\Models\\Receipt',2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',24227.93,NULL,NULL,1,'2023-05-19 21:12:53','2023-05-19 21:12:53',NULL),(2965,8694,40849,13647,3,2276,'App\\Models\\Receipt',2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',87603.40,NULL,NULL,1,'2023-05-19 21:34:29','2023-05-19 21:52:07','2023-05-19 21:52:07'),(2966,8694,40849,13647,3,2277,'App\\Models\\Receipt',2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',12288.95,NULL,NULL,1,'2023-05-19 21:34:29','2023-05-24 13:57:51','2023-05-24 13:57:51'),(2967,8694,40849,13647,3,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',89635.71,NULL,NULL,1,'2023-05-19 21:34:29','2023-05-19 21:53:40','2023-05-19 21:53:40'),(2968,8694,40849,13647,3,2279,'App\\Models\\Receipt',2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',7094.99,NULL,NULL,1,'2023-05-19 21:34:29','2023-05-24 13:57:29','2023-05-24 13:57:29'),(2969,8694,40849,13647,3,2280,'App\\Models\\Receipt',2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',29956.65,NULL,NULL,1,'2023-05-19 21:34:29','2023-05-24 15:19:35','2023-05-24 15:19:35'),(2970,8694,40849,13647,3,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',6012.52,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 22:16:36','2023-05-19 22:16:36');
INSERT INTO `balance_libro` VALUES (2971,8694,40849,13647,3,2282,'App\\Models\\Receipt',2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',190.28,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-24 13:53:25','2023-05-24 13:53:25'),(2972,8694,40849,13647,3,2283,'App\\Models\\Receipt',2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',4197.39,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-24 13:57:03','2023-05-24 13:57:03'),(2973,8694,40849,13647,3,2284,'App\\Models\\Receipt',2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',15684.68,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 21:36:44','2023-05-19 21:36:44'),(2974,8694,40849,13647,3,2285,'App\\Models\\Receipt',2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',94149.61,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 21:55:09','2023-05-19 21:55:09'),(2975,8694,40849,13647,3,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',0.01,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 22:18:18','2023-05-19 22:18:18'),(2976,8694,40849,13647,3,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3531.61,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-24 14:21:09','2023-05-24 14:21:09'),(2977,8694,40849,13647,3,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3531.61,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-24 14:24:19','2023-05-24 14:24:19'),(2978,8694,40849,13647,3,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',5067.51,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 22:22:23','2023-05-19 22:22:23'),(2979,8694,40849,13647,3,2290,'App\\Models\\Receipt',2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',14030.61,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 21:49:02','2023-05-19 21:49:02'),(2980,8694,40849,13647,3,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',14341.38,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 22:27:18','2023-05-19 22:27:18'),(2981,8694,40849,13647,3,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',1728.00,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-24 14:24:37','2023-05-24 14:24:37'),(2982,8694,40849,13647,3,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',12055.75,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 22:04:26','2023-05-19 22:04:26'),(2983,8694,40849,13647,3,2294,'App\\Models\\Receipt',2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',15705.58,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 22:29:13','2023-05-19 22:29:13'),(2984,8694,40849,13647,3,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',14294.17,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 21:39:57','2023-05-19 21:39:57'),(2985,8694,40849,13647,3,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8000.00,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 21:40:36','2023-05-19 21:40:36'),(2986,8694,40849,13647,3,2297,'App\\Models\\Receipt',2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',13239.12,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 22:32:32','2023-05-19 22:32:32'),(2987,8694,40849,13647,3,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',1728.00,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-24 14:39:24','2023-05-24 14:39:24'),(2988,8694,40849,13647,3,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',8662.03,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 22:06:22','2023-05-19 22:06:22'),(2989,8694,40849,13647,3,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',7652.36,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 21:42:56','2023-05-19 21:42:56');
INSERT INTO `balance_libro` VALUES (2990,8694,40849,13647,3,2301,'App\\Models\\Receipt',2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',17585.00,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 21:36:07','2023-05-19 21:36:07'),(2991,8694,40849,13647,3,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',87529.10,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 21:57:31','2023-05-19 21:57:31'),(2992,8694,40849,13647,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',5067.43,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 22:24:17','2023-05-19 22:24:17'),(2993,8694,40849,13647,3,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',13317.55,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 22:34:09','2023-05-19 22:34:09'),(2994,8694,40849,13647,3,2305,'App\\Models\\Receipt',2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',4235.00,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 21:44:03','2023-05-19 21:44:03'),(2995,8694,40849,13647,3,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',89251.29,NULL,NULL,1,'2023-05-19 21:34:30','2023-05-19 21:59:30','2023-05-19 21:59:30'),(2996,8694,40849,13647,3,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',9777.45,NULL,NULL,1,'2023-05-19 21:34:31','2023-05-19 21:45:22','2023-05-19 21:45:22'),(2997,8694,40849,13647,3,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',27487.32,NULL,NULL,1,'2023-05-19 21:34:31','2023-05-19 22:36:34','2023-05-19 22:36:34'),(2998,8694,40849,13647,3,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',7079.18,NULL,NULL,1,'2023-05-19 21:34:31','2023-05-19 22:08:14','2023-05-19 22:08:14'),(2999,8694,40849,13647,3,2310,'App\\Models\\Receipt',2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',15060.00,NULL,NULL,1,'2023-05-19 21:34:31','2023-05-19 21:35:34','2023-05-19 21:35:34'),(3000,8694,40849,13647,3,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',14288.29,NULL,NULL,1,'2023-05-19 21:34:31','2023-05-19 22:38:20','2023-05-19 22:38:20'),(3001,8694,40849,13647,3,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',363605.00,NULL,NULL,1,'2023-05-19 21:34:31','2023-05-19 22:00:35','2023-05-19 22:00:35'),(3002,8694,40849,13647,3,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',13401.85,NULL,NULL,1,'2023-05-19 21:34:31','2023-05-19 21:50:45','2023-05-19 21:50:45'),(3003,8694,40849,13647,3,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',14294.17,NULL,NULL,1,'2023-05-19 21:39:57','2023-05-19 21:39:57',NULL),(3004,8694,40849,13647,3,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8000.00,NULL,NULL,1,'2023-05-19 21:40:36','2023-05-19 21:40:36',NULL),(3005,8694,40849,13647,3,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',7652.36,NULL,NULL,1,'2023-05-19 21:42:56','2023-05-19 21:42:56',NULL),(3006,8694,40849,13647,3,2305,'App\\Models\\Receipt',2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',4235.00,NULL,NULL,1,'2023-05-19 21:44:03','2023-05-19 21:44:03',NULL),(3007,8694,40849,13647,3,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',9777.45,NULL,NULL,1,'2023-05-19 21:45:22','2023-05-24 15:23:59','2023-05-24 15:23:59'),(3008,8694,40849,13647,3,2290,'App\\Models\\Receipt',2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',14030.62,NULL,NULL,1,'2023-05-19 21:49:02','2023-05-19 21:49:02',NULL);
INSERT INTO `balance_libro` VALUES (3009,8694,40849,13647,3,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',13401.85,NULL,NULL,1,'2023-05-19 21:50:45','2023-05-24 15:23:11','2023-05-24 15:23:11'),(3010,8694,40849,13647,3,2276,'App\\Models\\Receipt',2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',87603.40,NULL,NULL,1,'2023-05-19 21:52:07','2023-05-19 21:52:07',NULL),(3011,8694,40849,13647,3,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',89635.71,NULL,NULL,1,'2023-05-19 21:53:40','2023-05-19 21:53:40',NULL),(3012,8694,40849,13647,3,2285,'App\\Models\\Receipt',2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',94149.62,NULL,NULL,1,'2023-05-19 21:55:09','2023-05-19 21:55:09',NULL),(3013,8694,40849,13647,3,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',87529.10,NULL,NULL,1,'2023-05-19 21:57:31','2023-05-24 15:25:01','2023-05-24 15:25:01'),(3014,8694,40849,13647,3,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',89251.29,NULL,NULL,1,'2023-05-19 21:59:30','2023-05-19 21:59:30',NULL),(3015,8694,40849,13647,3,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',363605.00,NULL,NULL,1,'2023-05-19 22:00:35','2023-05-24 14:25:28','2023-05-24 14:25:28'),(3016,8694,40849,13647,3,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',12055.76,NULL,NULL,1,'2023-05-19 22:04:26','2023-05-24 14:24:52','2023-05-24 14:24:52'),(3017,8694,40849,13647,3,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',8662.03,NULL,NULL,1,'2023-05-19 22:06:22','2023-05-24 14:39:10','2023-05-24 14:39:10'),(3018,8694,40849,13647,3,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',7079.19,NULL,NULL,1,'2023-05-19 22:08:14','2023-05-24 14:21:28','2023-05-24 14:21:28'),(3019,8694,40849,13647,3,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',6012.52,NULL,NULL,1,'2023-05-19 22:16:36','2023-05-24 15:28:30','2023-05-24 15:28:30'),(3020,8694,40849,13647,3,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',0.01,NULL,NULL,1,'2023-05-19 22:18:18','2023-05-19 22:18:18',NULL),(3021,8694,40849,13647,3,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',5067.50,NULL,NULL,1,'2023-05-19 22:22:23','2023-05-24 14:54:51','2023-05-24 14:54:51'),(3022,8694,40849,13647,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',5067.43,NULL,NULL,1,'2023-05-19 22:24:17','2023-05-24 14:48:29','2023-05-24 14:48:29'),(3023,8694,40849,13647,3,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',14341.38,NULL,NULL,1,'2023-05-19 22:27:18','2023-05-19 22:27:18',NULL),(3024,8694,40849,13647,3,2294,'App\\Models\\Receipt',2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',15705.58,NULL,NULL,1,'2023-05-19 22:29:13','2023-05-19 22:29:13',NULL),(3025,8694,40849,13647,3,2297,'App\\Models\\Receipt',2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',13239.12,NULL,NULL,1,'2023-05-19 22:32:32','2023-05-19 22:32:32',NULL),(3026,8694,40849,13647,3,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',13317.55,NULL,NULL,1,'2023-05-19 22:34:09','2023-05-24 15:24:10','2023-05-24 15:24:10'),(3027,8694,40849,13647,3,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',27487.32,NULL,NULL,1,'2023-05-19 22:36:34','2023-05-24 15:23:49','2023-05-24 15:23:49'),(3028,8694,40849,13647,3,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',14288.29,NULL,NULL,1,'2023-05-19 22:38:20','2023-05-24 15:23:32','2023-05-24 15:23:32');
INSERT INTO `balance_libro` VALUES (3029,8694,40839,12132,2,2314,'App\\Models\\Receipt',2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',157300.00,NULL,NULL,1,'2023-05-21 19:36:22','2023-05-21 19:42:27','2023-05-21 19:42:27'),(3030,8694,40839,12132,2,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',217800.00,NULL,NULL,1,'2023-05-21 19:36:22','2023-05-21 19:43:09','2023-05-21 19:43:09'),(3031,8694,40839,12132,2,2316,'App\\Models\\Receipt',2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',317625.00,NULL,NULL,1,'2023-05-21 19:36:22','2023-05-21 19:43:43','2023-05-21 19:43:43'),(3032,8694,40839,12132,2,2317,'App\\Models\\Receipt',2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',108900.00,NULL,NULL,1,'2023-05-21 19:36:22','2023-05-21 19:44:20','2023-05-21 19:44:20'),(3033,8694,40839,12132,2,2318,'App\\Models\\Receipt',2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',66550.00,NULL,NULL,1,'2023-05-21 19:36:22','2023-05-21 19:44:54','2023-05-21 19:44:54'),(3034,8694,40839,12132,3,2319,'App\\Models\\Receipt',2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',280.00,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 19:46:59','2023-05-21 19:46:59'),(3035,8694,40839,12132,3,2320,'App\\Models\\Receipt',2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1488.67,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 19:47:25','2023-05-21 19:47:25'),(3036,8694,40839,12132,3,2321,'App\\Models\\Receipt',2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',136.00,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 19:48:35','2023-05-21 19:48:35'),(3037,8694,40839,12132,3,2322,'App\\Models\\Receipt',2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',3278.62,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-24 15:57:18','2023-05-24 15:57:18'),(3038,8694,40839,12132,3,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',9801.90,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 20:23:07','2023-05-21 20:23:07'),(3039,8694,40839,12132,3,2324,'App\\Models\\Receipt',2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',92829.65,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 20:40:32','2023-05-21 20:40:32'),(3040,8694,40839,12132,3,2325,'App\\Models\\Receipt',2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',6309.90,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 20:46:46','2023-05-21 20:46:46'),(3041,8694,40839,12132,3,2326,'App\\Models\\Receipt',2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',23014.94,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 19:48:57','2023-05-21 19:48:57'),(3042,8694,40839,12132,3,2327,'App\\Models\\Receipt',2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',26190.17,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 19:50:29','2023-05-21 19:50:29'),(3043,8694,40839,12132,3,2328,'App\\Models\\Receipt',2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',44700.92,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 19:51:45','2023-05-21 19:51:45'),(3044,8694,40839,12132,3,2329,'App\\Models\\Receipt',2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',8077.86,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 19:52:02','2023-05-21 19:52:02'),(3045,8694,40839,12132,3,2330,'App\\Models\\Receipt',2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',6678.58,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 21:46:41','2023-05-21 21:46:41'),(3046,8694,40839,12132,3,2331,'App\\Models\\Receipt',2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',5408.37,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 19:52:35','2023-05-21 19:52:35'),(3047,8694,40839,12132,3,2332,'App\\Models\\Receipt',2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',698.98,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-24 15:56:36','2023-05-24 15:56:36');
INSERT INTO `balance_libro` VALUES (3048,8694,40839,12132,3,2333,'App\\Models\\Receipt',2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',8869.60,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 21:13:47','2023-05-21 21:13:47'),(3049,8694,40839,12132,3,2334,'App\\Models\\Receipt',2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',6165.18,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 20:42:21','2023-05-21 20:42:21'),(3050,8694,40839,12132,3,2335,'App\\Models\\Receipt',2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',46465.67,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 20:44:44','2023-05-21 20:44:44'),(3051,8694,40839,12132,3,2336,'App\\Models\\Receipt',2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8000.00,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 20:42:52','2023-05-21 20:42:52'),(3052,8694,40839,12132,3,2337,'App\\Models\\Receipt',2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',10964.61,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 21:24:27','2023-05-21 21:24:27'),(3053,8694,40839,12132,3,2338,'App\\Models\\Receipt',2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',12792.05,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 21:25:51','2023-05-21 21:25:51'),(3054,8694,40839,12132,3,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',10964.61,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 21:17:57','2023-05-21 21:17:57'),(3055,8694,40839,12132,3,2340,'App\\Models\\Receipt',2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',1586.37,NULL,NULL,1,'2023-05-21 19:36:43','2023-05-21 19:53:11','2023-05-21 19:53:11'),(3056,8694,40839,12132,3,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',114999.00,NULL,NULL,1,'2023-05-21 19:36:44','2023-05-21 19:53:43','2023-05-21 19:53:43'),(3057,8694,40839,12132,3,2342,'App\\Models\\Receipt',2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',20.00,NULL,NULL,1,'2023-05-21 19:36:44','2023-05-21 19:53:59','2023-05-21 19:53:59'),(3058,8694,40839,12132,3,2343,'App\\Models\\Receipt',2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',141062.58,NULL,NULL,1,'2023-05-21 19:36:44','2023-05-21 21:39:24','2023-05-21 21:39:24'),(3059,8694,40839,12132,3,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',21200.00,NULL,NULL,1,'2023-05-21 19:36:44','2023-05-21 21:40:13','2023-05-21 21:40:13'),(3060,8694,40839,12132,3,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',450.00,NULL,NULL,1,'2023-05-21 19:36:44','2023-05-21 19:54:29','2023-05-21 19:54:29'),(3061,8694,40839,12132,3,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',13350.00,NULL,NULL,1,'2023-05-21 19:36:44','2023-05-21 21:41:23','2023-05-21 21:41:23'),(3062,8694,40839,12132,3,2347,'App\\Models\\Receipt',2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',3819.96,NULL,NULL,1,'2023-05-21 19:36:44','2023-05-21 21:48:43','2023-05-21 21:48:43'),(3063,8694,40839,12132,3,2348,'App\\Models\\Receipt',2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',21710.00,NULL,NULL,1,'2023-05-21 19:36:44','2023-05-21 21:51:50','2023-05-21 21:51:50'),(3064,8694,40839,12132,3,2349,'App\\Models\\Receipt',2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',7340.00,NULL,NULL,1,'2023-05-21 19:36:44','2023-05-21 21:50:11','2023-05-21 21:50:11'),(3065,8694,40839,12132,3,2350,'App\\Models\\Receipt',2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1455.00,NULL,NULL,1,'2023-05-21 19:36:44','2023-05-21 19:54:45','2023-05-21 19:54:45'),(3066,8694,40839,12132,2,2314,'App\\Models\\Receipt',2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',157300.00,NULL,NULL,1,'2023-05-21 19:42:27','2023-05-21 19:42:27',NULL);
INSERT INTO `balance_libro` VALUES (3067,8694,40839,12132,2,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',217800.00,NULL,NULL,1,'2023-05-21 19:43:09','2023-05-21 19:43:09',NULL),(3068,8694,40839,12132,2,2316,'App\\Models\\Receipt',2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',317625.00,NULL,NULL,1,'2023-05-21 19:43:43','2023-05-21 19:43:43',NULL),(3069,8694,40839,12132,2,2317,'App\\Models\\Receipt',2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',108900.00,NULL,NULL,1,'2023-05-21 19:44:20','2023-05-21 19:44:20',NULL),(3070,8694,40839,12132,2,2318,'App\\Models\\Receipt',2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',66550.00,NULL,NULL,1,'2023-05-21 19:44:54','2023-05-21 19:44:54',NULL),(3071,8694,40839,12132,3,2351,'App\\Models\\Receipt',2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',46621.06,NULL,NULL,1,'2023-05-21 20:18:35','2023-05-21 20:18:35',NULL),(3072,8694,40839,12132,3,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',9801.90,NULL,NULL,1,'2023-05-21 20:23:07','2023-05-24 16:01:39','2023-05-24 16:01:39'),(3073,8694,40839,12132,3,2324,'App\\Models\\Receipt',2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',92829.65,NULL,NULL,1,'2023-05-21 20:40:32','2023-05-21 20:40:32',NULL),(3074,8694,40839,12132,3,2334,'App\\Models\\Receipt',2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',6165.18,NULL,NULL,1,'2023-05-21 20:42:21','2023-05-21 20:42:21',NULL),(3075,8694,40839,12132,3,2336,'App\\Models\\Receipt',2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8000.00,NULL,NULL,1,'2023-05-21 20:42:52','2023-05-21 20:42:52',NULL),(3076,8694,40839,12132,3,2335,'App\\Models\\Receipt',2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',46465.67,NULL,NULL,1,'2023-05-21 20:44:44','2023-05-21 20:44:44',NULL),(3077,8694,40839,12132,3,2325,'App\\Models\\Receipt',2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',6309.90,NULL,NULL,1,'2023-05-21 20:46:46','2023-05-21 20:46:46',NULL),(3078,8694,40839,12132,3,2352,'App\\Models\\Receipt',2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',28900.00,NULL,NULL,1,'2023-05-21 20:55:52','2023-05-21 20:55:52',NULL),(3079,8694,40839,12132,3,2353,'App\\Models\\Receipt',2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',16761.16,NULL,NULL,1,'2023-05-21 21:06:39','2023-05-21 21:06:39',NULL),(3080,8694,40839,12132,3,2333,'App\\Models\\Receipt',2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',8869.60,NULL,NULL,1,'2023-05-21 21:13:47','2023-05-24 16:23:09','2023-05-24 16:23:09'),(3081,8694,40839,12132,3,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',10964.61,NULL,NULL,1,'2023-05-21 21:17:57','2023-05-21 21:17:57',NULL),(3082,8694,40839,12132,3,2354,'App\\Models\\Receipt',2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',41400.00,NULL,NULL,1,'2023-05-21 21:22:33','2023-05-21 21:22:33',NULL),(3083,8694,40839,12132,3,2337,'App\\Models\\Receipt',2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',10964.61,NULL,NULL,1,'2023-05-21 21:24:27','2023-05-21 21:24:27',NULL),(3084,8694,40839,12132,3,2338,'App\\Models\\Receipt',2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',12792.05,NULL,NULL,1,'2023-05-21 21:25:51','2023-05-21 21:25:51',NULL),(3085,8694,40839,12132,3,2355,'App\\Models\\Receipt',2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',10101.34,NULL,NULL,1,'2023-05-21 21:29:44','2023-05-21 21:29:44',NULL),(3086,8694,40839,12132,3,2356,'App\\Models\\Receipt',2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',29738.96,NULL,NULL,1,'2023-05-21 21:37:18','2023-05-21 21:37:18',NULL);
INSERT INTO `balance_libro` VALUES (3087,8694,40839,12132,3,2343,'App\\Models\\Receipt',2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',141062.57,NULL,NULL,1,'2023-05-21 21:39:24','2023-05-21 21:39:24',NULL),(3088,8694,40839,12132,3,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',21200.00,NULL,NULL,1,'2023-05-21 21:40:13','2023-05-21 21:40:13',NULL),(3089,8694,40839,12132,3,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',13350.00,NULL,NULL,1,'2023-05-21 21:41:23','2023-05-21 21:41:23',NULL),(3090,8694,40839,12132,3,2357,'App\\Models\\Receipt',2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',10501.53,NULL,NULL,1,'2023-05-21 21:44:19','2023-05-21 21:44:19',NULL),(3091,8694,40839,12132,3,2330,'App\\Models\\Receipt',2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',6678.58,NULL,NULL,1,'2023-05-21 21:46:41','2023-05-21 21:46:41',NULL),(3092,8694,40839,12132,3,2347,'App\\Models\\Receipt',2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',3819.96,NULL,NULL,1,'2023-05-21 21:48:43','2023-05-21 21:48:43',NULL),(3093,8694,40839,12132,3,2349,'App\\Models\\Receipt',2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',7340.01,NULL,NULL,1,'2023-05-21 21:50:11','2023-05-21 21:50:11',NULL),(3094,8694,40839,12132,3,2348,'App\\Models\\Receipt',2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',21710.00,NULL,NULL,1,'2023-05-21 21:51:50','2023-05-21 21:51:50',NULL),(3095,8694,40856,15159,2,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',104665.00,NULL,NULL,1,'2023-05-21 21:57:56','2023-05-21 21:59:37','2023-05-21 21:59:37'),(3096,8694,40856,15159,2,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',147136.00,NULL,NULL,1,'2023-05-21 21:57:56','2023-05-21 22:00:42','2023-05-21 22:00:42'),(3097,8694,40856,15159,2,2360,'App\\Models\\Receipt',2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',189244.00,NULL,NULL,1,'2023-05-21 21:57:56','2023-05-21 22:01:47','2023-05-21 22:01:47'),(3098,8694,40856,15159,3,2361,'App\\Models\\Receipt',2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',29389.38,NULL,NULL,1,'2023-05-21 21:58:09','2023-05-21 23:01:05','2023-05-21 23:01:05'),(3099,8694,40856,15159,3,2362,'App\\Models\\Receipt',2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',340.00,NULL,NULL,1,'2023-05-21 21:58:09','2023-05-24 17:39:38','2023-05-24 17:39:38'),(3100,8694,40856,15159,3,2363,'App\\Models\\Receipt',2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1052.39,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-24 17:38:33','2023-05-24 17:38:33'),(3101,8694,40856,15159,3,2364,'App\\Models\\Receipt',2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',5799.99,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-21 23:02:05','2023-05-21 23:02:05'),(3102,8694,40856,15159,3,2365,'App\\Models\\Receipt',2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',47.50,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-24 17:38:25','2023-05-24 17:38:25'),(3103,8694,40856,15159,3,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3716.27,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-21 23:04:34','2023-05-21 23:04:34'),(3104,8694,40856,15159,3,2367,'App\\Models\\Receipt',2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',55372.71,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-21 23:11:17','2023-05-21 23:11:17'),(3105,8694,40856,15159,3,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',34900.00,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-21 23:12:35','2023-05-21 23:12:35');
INSERT INTO `balance_libro` VALUES (3106,8694,40856,15159,3,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',14100.01,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-21 23:13:34','2023-05-21 23:13:34'),(3107,8694,40856,15159,3,2370,'App\\Models\\Receipt',2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',9000.00,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-21 23:23:31','2023-05-21 23:23:31'),(3108,8694,40856,15159,3,2371,'App\\Models\\Receipt',2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',27424.90,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-21 23:20:45','2023-05-21 23:20:45'),(3109,8694,40856,15159,3,2372,'App\\Models\\Receipt',2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',37523.48,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-21 23:22:58','2023-05-21 23:22:58'),(3110,8694,40856,15159,3,2373,'App\\Models\\Receipt',2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',68.00,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-24 17:41:02','2023-05-24 17:41:02'),(3111,8694,40856,15159,3,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',586.41,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-24 17:40:46','2023-05-24 17:40:46'),(3112,8694,40856,15159,3,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',92896.19,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-21 23:27:29','2023-05-21 23:27:29'),(3113,8694,40856,15159,3,2376,'App\\Models\\Receipt',2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',347.93,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-24 17:38:14','2023-05-24 17:38:14'),(3114,8694,40856,15159,3,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',9503.42,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-24 17:40:39','2023-05-24 17:40:39'),(3115,8694,40856,15159,3,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',9503.42,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-24 17:40:34','2023-05-24 17:40:34'),(3116,8694,40856,15159,3,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',9503.42,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-24 17:40:28','2023-05-24 17:40:28'),(3117,8694,40856,15159,3,2380,'App\\Models\\Receipt',2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',9934.44,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-24 17:40:22','2023-05-24 17:40:22'),(3118,8694,40856,15159,3,2381,'App\\Models\\Receipt',2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',7800.00,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-24 17:40:09','2023-05-24 17:40:09'),(3119,8694,40856,15159,3,2382,'App\\Models\\Receipt',2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',4000.00,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-21 21:58:10',NULL),(3120,8694,40856,15159,3,2383,'App\\Models\\Receipt',2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',1252.00,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-24 17:39:49','2023-05-24 17:39:49'),(3121,8694,40856,15159,3,2384,'App\\Models\\Receipt',2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',216655.64,NULL,NULL,1,'2023-05-21 21:58:10','2023-05-21 23:28:38','2023-05-21 23:28:38'),(3122,8694,40856,15159,2,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',104665.00,NULL,NULL,1,'2023-05-21 21:59:37','2023-05-21 21:59:37',NULL),(3123,8694,40856,15159,2,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',147136.00,NULL,NULL,1,'2023-05-21 22:00:42','2023-05-21 22:00:42',NULL),(3124,8694,40856,15159,2,2360,'App\\Models\\Receipt',2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',189244.00,NULL,NULL,1,'2023-05-21 22:01:47','2023-05-21 22:01:47',NULL);
INSERT INTO `balance_libro` VALUES (3125,8694,40856,15159,3,2361,'App\\Models\\Receipt',2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',29389.38,NULL,NULL,1,'2023-05-21 23:01:05','2023-05-21 23:01:05',NULL),(3126,8694,40856,15159,3,2364,'App\\Models\\Receipt',2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',5800.00,NULL,NULL,1,'2023-05-21 23:02:05','2023-05-21 23:02:05',NULL),(3127,8694,40856,15159,3,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3716.27,NULL,NULL,1,'2023-05-21 23:04:34','2023-05-21 23:04:34',NULL),(3128,8694,40856,15159,3,2367,'App\\Models\\Receipt',2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',55372.71,NULL,NULL,1,'2023-05-21 23:11:17','2023-05-21 23:11:17',NULL),(3129,8694,40856,15159,3,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',34900.00,NULL,NULL,1,'2023-05-21 23:12:35','2023-05-21 23:12:35',NULL),(3130,8694,40856,15159,3,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',14100.01,NULL,NULL,1,'2023-05-21 23:13:34','2023-05-21 23:13:34',NULL),(3131,8694,40856,15159,3,2371,'App\\Models\\Receipt',2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',27424.90,NULL,NULL,1,'2023-05-21 23:20:45','2023-05-21 23:20:45',NULL),(3132,8694,40856,15159,3,2372,'App\\Models\\Receipt',2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',37523.47,NULL,NULL,1,'2023-05-21 23:22:58','2023-05-21 23:22:58',NULL),(3133,8694,40856,15159,3,2370,'App\\Models\\Receipt',2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',9000.00,NULL,NULL,1,'2023-05-21 23:23:31','2023-05-21 23:23:31',NULL),(3134,8694,40856,15159,3,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',92896.18,NULL,NULL,1,'2023-05-21 23:27:29','2023-05-21 23:27:29',NULL),(3135,8694,40856,15159,3,2384,'App\\Models\\Receipt',2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',216655.64,NULL,NULL,1,'2023-05-21 23:28:38','2023-05-21 23:28:38',NULL),(3136,8694,40906,18183,2,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',180000.00,NULL,NULL,1,'2023-05-21 23:37:43','2023-05-21 23:40:35','2023-05-21 23:40:35'),(3137,8694,40906,18183,3,2386,'App\\Models\\Receipt',2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',2199.00,NULL,NULL,1,'2023-05-21 23:38:01','2023-05-21 23:41:49','2023-05-21 23:41:49'),(3138,8694,40906,18183,3,2387,'App\\Models\\Receipt',2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8708.70,NULL,NULL,1,'2023-05-21 23:38:01','2023-05-21 23:41:32','2023-05-21 23:41:32'),(3139,8694,40906,18183,3,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8000.00,NULL,NULL,1,'2023-05-21 23:38:01','2023-05-21 23:42:24','2023-05-21 23:42:24'),(3140,8694,40906,18183,3,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',5990.00,NULL,NULL,1,'2023-05-21 23:38:01','2023-05-21 23:41:19','2023-05-21 23:41:19'),(3141,8694,40906,18183,2,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',180000.00,NULL,NULL,1,'2023-05-21 23:40:35','2023-05-21 23:40:35',NULL),(3142,8694,40906,18183,3,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8000.00,NULL,NULL,1,'2023-05-21 23:42:24','2023-05-21 23:42:24',NULL),(3143,8694,40875,16671,2,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',9956.00,NULL,NULL,1,'2023-05-22 20:37:38','2023-05-22 21:01:39','2023-05-22 21:01:39'),(3144,8694,40875,16671,2,2391,'App\\Models\\Receipt',2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',4978.00,NULL,NULL,1,'2023-05-22 20:37:38','2023-05-22 21:02:15','2023-05-22 21:02:15');
INSERT INTO `balance_libro` VALUES (3145,8694,40875,16671,2,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',12000.00,NULL,NULL,1,'2023-05-22 20:37:38','2023-05-22 21:03:01','2023-05-22 21:03:01'),(3146,8694,40875,16671,2,2393,'App\\Models\\Receipt',2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',13500.00,NULL,NULL,1,'2023-05-22 20:37:38','2023-05-22 21:03:27','2023-05-22 21:03:27'),(3147,8694,40875,16671,2,2394,'App\\Models\\Receipt',2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',3370.08,NULL,NULL,1,'2023-05-22 20:37:38','2023-05-22 21:04:15','2023-05-22 21:04:15'),(3148,8694,40875,16671,2,2395,'App\\Models\\Receipt',2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',30330.72,NULL,NULL,1,'2023-05-22 20:37:38','2023-05-22 21:05:06','2023-05-22 21:05:06'),(3149,8694,40875,16671,2,2396,'App\\Models\\Receipt',2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',3370.93,NULL,NULL,1,'2023-05-22 20:37:38','2023-05-22 21:05:49','2023-05-22 21:05:49'),(3150,8694,40875,16671,2,2397,'App\\Models\\Receipt',2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',33799.30,NULL,NULL,1,'2023-05-22 20:37:38','2023-05-22 21:06:51','2023-05-22 21:06:51'),(3151,8694,40875,16671,2,2398,'App\\Models\\Receipt',2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',30419.37,NULL,NULL,1,'2023-05-22 20:37:38','2023-05-22 21:08:28','2023-05-22 21:08:28'),(3152,8694,40875,16671,2,2399,'App\\Models\\Receipt',2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',12000.00,NULL,NULL,1,'2023-05-22 20:37:38','2023-05-22 21:09:10','2023-05-22 21:09:10'),(3153,8694,40875,16671,2,2400,'App\\Models\\Receipt',2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',30330.72,NULL,NULL,1,'2023-05-22 20:37:38','2023-05-22 21:07:50','2023-05-22 21:07:50'),(3154,8694,40875,16671,2,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',16899.65,NULL,NULL,1,'2023-05-22 20:37:38','2023-05-22 21:09:38','2023-05-22 21:09:38'),(3155,8694,40875,16671,2,2402,'App\\Models\\Receipt',2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',3082600.00,NULL,NULL,1,'2023-05-22 20:37:38','2023-05-22 20:59:00','2023-05-22 20:59:00'),(3156,8694,40875,16671,2,2403,'App\\Models\\Receipt',2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',23659.51,NULL,NULL,1,'2023-05-22 20:37:38','2023-05-22 21:10:10','2023-05-22 21:10:10'),(3157,8694,40875,16671,2,2404,'App\\Models\\Receipt',2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',157500.00,NULL,NULL,1,'2023-05-22 20:37:38','2023-05-22 21:00:08','2023-05-22 21:00:08'),(3158,8694,40875,16671,2,2405,'App\\Models\\Receipt',2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',20300.00,NULL,NULL,1,'2023-05-22 20:37:38','2023-05-22 21:11:43','2023-05-22 21:11:43'),(3159,8694,40875,16671,2,2406,'App\\Models\\Receipt',2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',30419.37,NULL,NULL,1,'2023-05-22 20:37:38','2023-05-22 21:12:57','2023-05-22 21:12:57'),(3160,8694,40875,16671,3,2407,'App\\Models\\Receipt',2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',4442.40,NULL,NULL,1,'2023-05-22 20:37:53','2023-05-22 21:34:36','2023-05-22 21:34:36'),(3161,8694,40875,16671,3,2408,'App\\Models\\Receipt',2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',10298.99,NULL,NULL,1,'2023-05-22 20:37:53','2023-05-22 22:34:33','2023-05-22 22:34:33'),(3162,8694,40875,16671,3,2409,'App\\Models\\Receipt',2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',25800.00,NULL,NULL,1,'2023-05-22 20:37:53','2023-05-22 22:01:40','2023-05-22 22:01:40'),(3163,8694,40875,16671,3,2410,'App\\Models\\Receipt',2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',8800.00,NULL,NULL,1,'2023-05-22 20:37:53','2023-05-22 21:53:24','2023-05-22 21:53:24');
INSERT INTO `balance_libro` VALUES (3164,8694,40875,16671,3,2411,'App\\Models\\Receipt',2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',615.94,NULL,NULL,1,'2023-05-22 20:37:53','2023-05-24 18:59:18','2023-05-24 18:59:18'),(3165,8694,40875,16671,3,2412,'App\\Models\\Receipt',2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',5400.00,NULL,NULL,1,'2023-05-22 20:37:53','2023-05-22 22:36:56','2023-05-22 22:36:56'),(3166,8694,40875,16671,3,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1232181.81,NULL,NULL,1,'2023-05-22 20:37:53','2023-05-22 21:56:57','2023-05-22 21:56:57'),(3167,8694,40875,16671,3,2414,'App\\Models\\Receipt',2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',29999.41,NULL,NULL,1,'2023-05-22 20:37:53','2023-05-24 19:01:01','2023-05-24 19:01:01'),(3168,8694,40875,16671,3,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1859.49,NULL,NULL,1,'2023-05-22 20:37:53','2023-05-24 19:01:16','2023-05-24 19:01:16'),(3169,8694,40875,16671,3,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',96905.62,NULL,NULL,1,'2023-05-22 20:37:53','2023-05-22 22:42:17','2023-05-22 22:42:17'),(3170,8694,40875,16671,3,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',79860.00,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-22 22:00:47','2023-05-22 22:00:47'),(3171,8694,40875,16671,3,2418,'App\\Models\\Receipt',2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',5440.00,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-22 22:48:58','2023-05-22 22:48:58'),(3172,8694,40875,16671,3,2419,'App\\Models\\Receipt',2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',101750.00,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-22 21:59:18','2023-05-22 21:59:18'),(3173,8694,40875,16671,3,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',4442.40,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-24 19:03:51','2023-05-24 19:03:51'),(3174,8694,40875,16671,3,2421,'App\\Models\\Receipt',2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',41091.83,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-22 22:07:50','2023-05-22 22:07:50'),(3175,8694,40875,16671,3,2422,'App\\Models\\Receipt',2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',9196.98,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-22 22:29:23','2023-05-22 22:29:23'),(3176,8694,40875,16671,3,2423,'App\\Models\\Receipt',2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',7500.00,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-22 22:10:41','2023-05-22 22:10:41'),(3177,8694,40875,16671,3,2424,'App\\Models\\Receipt',2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',19000.00,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-22 22:08:58','2023-05-22 22:08:58'),(3178,8694,40875,16671,3,2425,'App\\Models\\Receipt',2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',5400.00,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-22 22:54:29','2023-05-22 22:54:29'),(3179,8694,40875,16671,3,2426,'App\\Models\\Receipt',2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',190.00,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-24 19:07:21','2023-05-24 19:07:21'),(3180,8694,40875,16671,3,2427,'App\\Models\\Receipt',2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',190.00,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-24 19:07:39','2023-05-24 19:07:39'),(3181,8694,40875,16671,3,2428,'App\\Models\\Receipt',2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',4850.00,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-22 22:02:16','2023-05-22 22:02:16'),(3182,8694,40875,16671,3,2429,'App\\Models\\Receipt',2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',32773.82,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-22 22:15:39','2023-05-22 22:15:39');
INSERT INTO `balance_libro` VALUES (3183,8694,40875,16671,3,2430,'App\\Models\\Receipt',2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',16840.83,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-22 22:16:57','2023-05-22 22:16:57'),(3184,8694,40875,16671,3,2431,'App\\Models\\Receipt',2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',8650.00,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-22 22:55:40','2023-05-22 22:55:40'),(3185,8694,40875,16671,3,2432,'App\\Models\\Receipt',2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',258.26,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-24 19:09:05','2023-05-24 19:09:05'),(3186,8694,40875,16671,3,2433,'App\\Models\\Receipt',2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',11755.00,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-22 22:18:09','2023-05-22 22:18:09'),(3187,8694,40875,16671,3,2434,'App\\Models\\Receipt',2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',6420.00,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-22 23:01:13','2023-05-22 23:01:13'),(3188,8694,40875,16671,3,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',18000.00,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-22 22:18:55','2023-05-22 22:18:55'),(3189,8694,40875,16671,3,2436,'App\\Models\\Receipt',2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',1680.00,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-22 22:02:45','2023-05-22 22:02:45'),(3190,8694,40875,16671,3,2437,'App\\Models\\Receipt',2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',9378.40,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-24 19:10:06','2023-05-24 19:10:06'),(3191,8694,40875,16671,3,2438,'App\\Models\\Receipt',2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',80707.00,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-22 22:31:54','2023-05-22 22:31:54'),(3192,8694,40875,16671,3,2439,'App\\Models\\Receipt',2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',19000.00,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-24 19:11:17','2023-05-24 19:11:17'),(3193,8694,40875,16671,3,2440,'App\\Models\\Receipt',2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',149870.60,NULL,NULL,1,'2023-05-22 20:37:54','2023-05-22 22:30:40','2023-05-22 22:30:40'),(3194,8694,40875,16671,3,2441,'App\\Models\\Receipt',2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',140529.40,NULL,NULL,1,'2023-05-22 20:37:55','2023-05-22 22:32:24','2023-05-22 22:32:24'),(3195,8694,40875,16671,2,2402,'App\\Models\\Receipt',2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',3082599.99,NULL,NULL,1,'2023-05-22 20:59:00','2023-05-22 20:59:00',NULL),(3196,8694,40875,16671,2,2404,'App\\Models\\Receipt',2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',157500.00,NULL,NULL,1,'2023-05-22 21:00:08','2023-05-22 21:00:08',NULL),(3197,8694,40875,16671,2,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',9956.00,NULL,NULL,1,'2023-05-22 21:01:39','2023-05-22 21:01:39',NULL),(3198,8694,40875,16671,2,2391,'App\\Models\\Receipt',2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',4978.00,NULL,NULL,1,'2023-05-22 21:02:15','2023-05-22 21:02:15',NULL),(3199,8694,40875,16671,2,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',12000.01,NULL,NULL,1,'2023-05-22 21:03:01','2023-05-22 21:03:01',NULL),(3200,8694,40875,16671,2,2393,'App\\Models\\Receipt',2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',13499.99,NULL,NULL,1,'2023-05-22 21:03:27','2023-05-22 21:03:27',NULL),(3201,8694,40875,16671,2,2394,'App\\Models\\Receipt',2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',3370.08,NULL,NULL,1,'2023-05-22 21:04:15','2023-05-22 21:04:15',NULL);
INSERT INTO `balance_libro` VALUES (3202,8694,40875,16671,2,2395,'App\\Models\\Receipt',2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',30330.72,NULL,NULL,1,'2023-05-22 21:05:06','2023-05-22 21:05:06',NULL),(3203,8694,40875,16671,2,2396,'App\\Models\\Receipt',2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',3370.93,NULL,NULL,1,'2023-05-22 21:05:49','2023-05-22 21:05:49',NULL),(3204,8694,40875,16671,2,2397,'App\\Models\\Receipt',2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',33799.31,NULL,NULL,1,'2023-05-22 21:06:51','2023-05-22 21:06:51',NULL),(3205,8694,40875,16671,2,2400,'App\\Models\\Receipt',2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',30330.72,NULL,NULL,1,'2023-05-22 21:07:50','2023-05-22 21:07:50',NULL),(3206,8694,40875,16671,2,2398,'App\\Models\\Receipt',2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',30419.38,NULL,NULL,1,'2023-05-22 21:08:28','2023-05-22 21:08:28',NULL),(3207,8694,40875,16671,2,2399,'App\\Models\\Receipt',2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',12000.01,NULL,NULL,1,'2023-05-22 21:09:10','2023-05-22 21:09:10',NULL),(3208,8694,40875,16671,2,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',16899.65,NULL,NULL,1,'2023-05-22 21:09:38','2023-05-22 21:09:38',NULL),(3209,8694,40875,16671,2,2403,'App\\Models\\Receipt',2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',23659.51,NULL,NULL,1,'2023-05-22 21:10:10','2023-05-22 21:10:10',NULL),(3210,8694,40875,16671,2,2405,'App\\Models\\Receipt',2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',20300.00,NULL,NULL,1,'2023-05-22 21:11:43','2023-05-22 21:11:43',NULL),(3211,8694,40875,16671,2,2406,'App\\Models\\Receipt',2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',30419.38,NULL,NULL,1,'2023-05-22 21:12:57','2023-05-22 21:12:57',NULL),(3212,8694,40875,16671,3,2407,'App\\Models\\Receipt',2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',4442.40,NULL,NULL,1,'2023-05-22 21:34:36','2023-05-22 21:34:36',NULL),(3213,8694,40875,16671,3,2410,'App\\Models\\Receipt',2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',8800.00,NULL,NULL,1,'2023-05-22 21:53:24','2023-05-22 21:53:24',NULL),(3214,8694,40875,16671,3,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1232181.81,NULL,NULL,1,'2023-05-22 21:56:57','2023-05-24 19:00:16','2023-05-24 19:00:16'),(3215,8694,40875,16671,3,2419,'App\\Models\\Receipt',2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',101750.00,NULL,NULL,1,'2023-05-22 21:59:18','2023-05-22 21:59:18',NULL),(3216,8694,40875,16671,3,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',79860.00,NULL,NULL,1,'2023-05-22 22:00:47','2023-05-22 22:00:47',NULL),(3217,8694,40875,16671,3,2421,'App\\Models\\Receipt',2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',41091.83,NULL,NULL,1,'2023-05-22 22:07:50','2023-05-24 19:04:31','2023-05-24 19:04:31'),(3218,8694,40875,16671,3,2424,'App\\Models\\Receipt',2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',19000.00,NULL,NULL,1,'2023-05-22 22:08:58','2023-05-22 22:08:58',NULL),(3219,8694,40875,16671,3,2423,'App\\Models\\Receipt',2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',7500.00,NULL,NULL,1,'2023-05-22 22:10:41','2023-05-22 22:10:41',NULL),(3220,8694,40875,16671,3,2429,'App\\Models\\Receipt',2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',32773.82,NULL,NULL,1,'2023-05-22 22:15:39','2023-05-22 22:15:39',NULL),(3221,8694,40875,16671,3,2430,'App\\Models\\Receipt',2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',16840.83,NULL,NULL,1,'2023-05-22 22:16:57','2023-05-22 22:16:57',NULL);
INSERT INTO `balance_libro` VALUES (3222,8694,40875,16671,3,2433,'App\\Models\\Receipt',2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',11755.00,NULL,NULL,1,'2023-05-22 22:18:09','2023-05-22 22:18:09',NULL),(3223,8694,40875,16671,3,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',18000.00,NULL,NULL,1,'2023-05-22 22:18:55','2023-05-22 22:18:55',NULL),(3224,8694,40875,16671,3,2422,'App\\Models\\Receipt',2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',9196.98,NULL,NULL,1,'2023-05-22 22:29:24','2023-05-24 19:05:53','2023-05-24 19:05:53'),(3225,8694,40875,16671,3,2440,'App\\Models\\Receipt',2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',149870.60,NULL,NULL,1,'2023-05-22 22:30:40','2023-05-22 22:30:40',NULL),(3226,8694,40875,16671,3,2438,'App\\Models\\Receipt',2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',80707.00,NULL,NULL,1,'2023-05-22 22:31:54','2023-05-22 22:31:54',NULL),(3227,8694,40875,16671,3,2441,'App\\Models\\Receipt',2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',140529.40,NULL,NULL,1,'2023-05-22 22:32:24','2023-05-22 22:32:24',NULL),(3228,8694,40875,16671,3,2408,'App\\Models\\Receipt',2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',10298.99,NULL,NULL,1,'2023-05-22 22:34:33','2023-05-22 22:34:33',NULL),(3229,8694,40875,16671,3,2412,'App\\Models\\Receipt',2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',5400.00,NULL,NULL,1,'2023-05-22 22:36:56','2023-05-22 22:36:56',NULL),(3230,8694,40875,16671,3,2442,'App\\Models\\Receipt',2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',21120.01,NULL,NULL,1,'2023-05-22 22:40:59','2023-05-22 22:40:59',NULL),(3231,8694,40875,16671,3,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',96905.62,NULL,NULL,1,'2023-05-22 22:42:17','2023-05-24 19:01:59','2023-05-24 19:01:59'),(3232,8694,40875,16671,3,2418,'App\\Models\\Receipt',2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',5440.00,NULL,NULL,1,'2023-05-22 22:48:58','2023-05-22 22:48:58',NULL),(3233,8694,40875,16671,3,2443,'App\\Models\\Receipt',2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',10501.09,NULL,NULL,1,'2023-05-22 22:53:39','2023-05-22 22:53:39',NULL),(3234,8694,40875,16671,3,2425,'App\\Models\\Receipt',2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',5400.00,NULL,NULL,1,'2023-05-22 22:54:29','2023-05-22 22:54:29',NULL),(3235,8694,40875,16671,3,2431,'App\\Models\\Receipt',2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',8650.00,NULL,NULL,1,'2023-05-22 22:55:40','2023-05-22 22:55:40',NULL),(3236,8694,40875,16671,3,2444,'App\\Models\\Receipt',2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',50319.99,NULL,NULL,1,'2023-05-22 23:00:07','2023-05-22 23:00:07',NULL),(3237,8694,40875,16671,3,2434,'App\\Models\\Receipt',2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',6419.99,NULL,NULL,1,'2023-05-22 23:01:13','2023-05-22 23:01:13',NULL),(3238,8694,40875,16671,3,2445,'App\\Models\\Receipt',2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',11407.02,NULL,NULL,1,'2023-05-22 23:04:26','2023-05-22 23:04:26',NULL),(3239,8694,41011,25752,2,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',17700.00,NULL,NULL,1,'2023-05-22 23:14:09','2023-05-22 23:16:09','2023-05-22 23:16:09'),(3240,8694,41011,25752,2,2447,'App\\Models\\Receipt',2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',41999.99,NULL,NULL,1,'2023-05-22 23:14:09','2023-05-22 23:16:49','2023-05-22 23:16:49'),(3241,8694,41011,25752,2,2448,'App\\Models\\Receipt',2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',96399.99,NULL,NULL,1,'2023-05-22 23:14:09','2023-05-22 23:17:53','2023-05-22 23:17:53');
INSERT INTO `balance_libro` VALUES (3242,8694,41011,25752,2,2449,'App\\Models\\Receipt',2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',48000.00,NULL,NULL,1,'2023-05-22 23:14:09','2023-05-22 23:18:35','2023-05-22 23:18:35'),(3243,8694,41011,25752,2,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',73200.00,NULL,NULL,1,'2023-05-22 23:14:09','2023-05-22 23:19:07','2023-05-22 23:19:07'),(3244,8694,41011,25752,2,2451,'App\\Models\\Receipt',2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',18900.01,NULL,NULL,1,'2023-05-22 23:14:09','2023-05-22 23:19:51','2023-05-22 23:19:51'),(3245,8694,41011,25752,2,2452,'App\\Models\\Receipt',2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',43549.99,NULL,NULL,1,'2023-05-22 23:14:09','2023-05-22 23:20:24','2023-05-22 23:20:24'),(3246,8694,41011,25752,2,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',46300.05,NULL,NULL,1,'2023-05-22 23:14:09','2023-05-22 23:21:16','2023-05-22 23:21:16'),(3247,8694,41011,25752,2,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',108779.00,NULL,NULL,1,'2023-05-22 23:14:09','2023-05-22 23:21:46','2023-05-22 23:21:46'),(3248,8694,41011,25752,2,2455,'App\\Models\\Receipt',2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',73326.00,NULL,NULL,1,'2023-05-22 23:14:09','2023-05-22 23:22:16','2023-05-22 23:22:16'),(3249,8694,41011,25752,3,2456,'App\\Models\\Receipt',2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',34531.25,NULL,NULL,1,'2023-05-22 23:14:28','2023-05-22 23:26:08','2023-05-22 23:26:08'),(3250,8694,41011,25752,3,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',6943.97,NULL,NULL,1,'2023-05-22 23:14:28','2023-05-23 00:03:38','2023-05-23 00:03:38'),(3251,8694,41011,25752,3,2458,'App\\Models\\Receipt',2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',20442.50,NULL,NULL,1,'2023-05-22 23:14:28','2023-05-22 23:27:11','2023-05-22 23:27:11'),(3252,8694,41011,25752,3,2459,'App\\Models\\Receipt',2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',6545.98,NULL,NULL,1,'2023-05-22 23:14:28','2023-05-23 00:05:54','2023-05-23 00:05:54'),(3253,8694,41011,25752,3,2460,'App\\Models\\Receipt',2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',68134.30,NULL,NULL,1,'2023-05-22 23:14:28','2023-05-22 23:14:28',NULL),(3254,8694,41011,25752,3,2461,'App\\Models\\Receipt',2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',34255.00,NULL,NULL,1,'2023-05-22 23:14:28','2023-05-22 23:14:28',NULL),(3255,8694,41011,25752,3,2462,'App\\Models\\Receipt',2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',8815.72,NULL,NULL,1,'2023-05-22 23:14:28','2023-05-23 00:08:18','2023-05-23 00:08:18'),(3256,8694,41011,25752,3,2463,'App\\Models\\Receipt',2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',37779.95,NULL,NULL,1,'2023-05-22 23:14:28','2023-05-22 23:14:28',NULL),(3257,8694,41011,25752,3,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',5559.19,NULL,NULL,1,'2023-05-22 23:14:28','2023-05-23 00:10:19','2023-05-23 00:10:19'),(3258,8694,41011,25752,3,2465,'App\\Models\\Receipt',2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',20995.00,NULL,NULL,1,'2023-05-22 23:14:28','2023-05-22 23:28:27','2023-05-22 23:28:27'),(3259,8694,41011,25752,3,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',28498.00,NULL,NULL,1,'2023-05-22 23:14:28','2023-05-22 23:24:46','2023-05-22 23:24:46'),(3260,8694,41011,25752,3,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',11344.30,NULL,NULL,1,'2023-05-22 23:14:28','2023-05-23 00:12:50','2023-05-23 00:12:50');
INSERT INTO `balance_libro` VALUES (3261,8694,41011,25752,3,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8500.00,NULL,NULL,1,'2023-05-22 23:14:28','2023-05-22 23:29:12','2023-05-22 23:29:12'),(3262,8694,41011,25752,3,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',44200.00,NULL,NULL,1,'2023-05-22 23:14:28','2023-05-22 23:14:28',NULL),(3263,8694,41011,25752,3,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',7727.66,NULL,NULL,1,'2023-05-22 23:14:28','2023-05-23 00:14:40','2023-05-23 00:14:40'),(3264,8694,41011,25752,3,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',20995.00,NULL,NULL,1,'2023-05-22 23:14:28','2023-05-22 23:29:59','2023-05-22 23:29:59'),(3265,8694,41011,25752,3,2472,'App\\Models\\Receipt',2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',44067.40,NULL,NULL,1,'2023-05-22 23:14:28','2023-05-22 23:14:28',NULL),(3266,8694,41011,25752,3,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',6812.51,NULL,NULL,1,'2023-05-22 23:14:28','2023-05-23 00:19:13','2023-05-23 00:19:13'),(3267,8694,41011,25752,3,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',25000.00,NULL,NULL,1,'2023-05-22 23:14:29','2023-05-22 23:31:56','2023-05-22 23:31:56'),(3268,8694,41011,25752,3,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',6023.08,NULL,NULL,1,'2023-05-22 23:14:29','2023-05-23 00:16:28','2023-05-23 00:16:28'),(3269,8694,41011,25752,3,2476,'App\\Models\\Receipt',2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',36527.22,NULL,NULL,1,'2023-05-22 23:14:29','2023-05-22 23:25:18','2023-05-22 23:25:18'),(3270,8694,41011,25752,3,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',6725.24,NULL,NULL,1,'2023-05-22 23:14:29','2023-05-23 00:21:02','2023-05-23 00:21:02'),(3271,8694,41011,25752,3,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',26796.25,NULL,NULL,1,'2023-05-22 23:14:29','2023-05-22 23:32:37','2023-05-22 23:32:37'),(3272,8694,41011,25752,3,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',28288.00,NULL,NULL,1,'2023-05-22 23:14:29','2023-05-22 23:14:29',NULL),(3273,8694,41011,25752,3,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',6087.90,NULL,NULL,1,'2023-05-22 23:14:29','2023-05-23 00:22:48','2023-05-23 00:22:48'),(3274,8694,41011,25752,3,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',6438.15,NULL,NULL,1,'2023-05-22 23:14:29','2023-05-23 00:24:37','2023-05-23 00:24:37'),(3275,8694,41011,25752,2,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',17700.00,NULL,NULL,1,'2023-05-22 23:16:09','2023-05-22 23:16:09',NULL),(3276,8694,41011,25752,2,2447,'App\\Models\\Receipt',2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',41999.98,NULL,NULL,1,'2023-05-22 23:16:49','2023-05-22 23:16:49',NULL),(3277,8694,41011,25752,2,2448,'App\\Models\\Receipt',2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',96400.00,NULL,NULL,1,'2023-05-22 23:17:53','2023-05-22 23:17:53',NULL),(3278,8694,41011,25752,2,2449,'App\\Models\\Receipt',2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',48000.00,NULL,NULL,1,'2023-05-22 23:18:35','2023-05-22 23:18:35',NULL),(3279,8694,41011,25752,2,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',73200.00,NULL,NULL,1,'2023-05-22 23:19:07','2023-05-22 23:19:07',NULL),(3280,8694,41011,25752,2,2451,'App\\Models\\Receipt',2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',18899.99,NULL,NULL,1,'2023-05-22 23:19:51','2023-05-22 23:19:51',NULL);
INSERT INTO `balance_libro` VALUES (3281,8694,41011,25752,2,2452,'App\\Models\\Receipt',2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',43549.98,NULL,NULL,1,'2023-05-22 23:20:24','2023-05-22 23:20:24',NULL),(3282,8694,41011,25752,2,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',46300.06,NULL,NULL,1,'2023-05-22 23:21:16','2023-05-22 23:21:16',NULL),(3283,8694,41011,25752,2,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',108779.00,NULL,NULL,1,'2023-05-22 23:21:46','2023-05-22 23:21:46',NULL),(3284,8694,41011,25752,2,2455,'App\\Models\\Receipt',2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',73326.00,NULL,NULL,1,'2023-05-22 23:22:16','2023-05-22 23:22:16',NULL),(3285,8694,41011,25752,3,2456,'App\\Models\\Receipt',2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',34531.25,NULL,NULL,1,'2023-05-22 23:26:08','2023-05-22 23:26:08',NULL),(3286,8694,41011,25752,3,2458,'App\\Models\\Receipt',2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',20442.50,NULL,NULL,1,'2023-05-22 23:27:11','2023-05-22 23:27:11',NULL),(3287,8694,41011,25752,3,2465,'App\\Models\\Receipt',2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',20995.00,NULL,NULL,1,'2023-05-22 23:28:27','2023-05-22 23:28:27',NULL),(3288,8694,41011,25752,3,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8500.00,NULL,NULL,1,'2023-05-22 23:29:12','2023-05-22 23:29:12',NULL),(3289,8694,41011,25752,3,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',20995.00,NULL,NULL,1,'2023-05-22 23:29:59','2023-05-22 23:29:59',NULL),(3290,8694,41011,25752,3,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',25000.00,NULL,NULL,1,'2023-05-22 23:31:56','2023-05-22 23:31:56',NULL),(3291,8694,41011,25752,3,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',26796.25,NULL,NULL,1,'2023-05-22 23:32:37','2023-05-22 23:32:37',NULL),(3292,8694,41011,25752,3,2482,'App\\Models\\Receipt',2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',8700.48,NULL,NULL,1,'2023-05-22 23:44:57','2023-05-22 23:44:57',NULL),(3293,8694,41011,25752,3,2483,'App\\Models\\Receipt',2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',5100.00,NULL,NULL,1,'2023-05-22 23:58:35','2023-05-22 23:58:35',NULL),(3294,8694,41011,25752,3,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',6943.97,NULL,NULL,1,'2023-05-23 00:03:38','2023-05-23 00:03:38',NULL),(3295,8694,41011,25752,3,2459,'App\\Models\\Receipt',2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',6545.98,NULL,NULL,1,'2023-05-23 00:05:54','2023-05-23 00:05:54',NULL),(3296,8694,41011,25752,3,2462,'App\\Models\\Receipt',2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',8815.72,NULL,NULL,1,'2023-05-23 00:08:18','2023-05-23 00:08:18',NULL),(3297,8694,41011,25752,3,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',5559.19,NULL,NULL,1,'2023-05-23 00:10:19','2023-05-23 00:10:19',NULL),(3298,8694,41011,25752,3,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',11344.31,NULL,NULL,1,'2023-05-23 00:12:50','2023-05-23 00:12:50',NULL),(3299,8694,41011,25752,3,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',7727.67,NULL,NULL,1,'2023-05-23 00:14:40','2023-05-23 00:14:40',NULL),(3300,8694,41011,25752,3,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',6023.07,NULL,NULL,1,'2023-05-23 00:16:28','2023-05-23 00:16:28',NULL),(3301,8694,41011,25752,3,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',6812.51,NULL,NULL,1,'2023-05-23 00:19:13','2023-05-23 00:19:13',NULL);
INSERT INTO `balance_libro` VALUES (3302,8694,41011,25752,3,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',6725.24,NULL,NULL,1,'2023-05-23 00:21:02','2023-05-23 00:21:02',NULL),(3303,8694,41011,25752,3,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',6087.91,NULL,NULL,1,'2023-05-23 00:22:48','2023-05-23 00:22:48',NULL),(3304,8694,41011,25752,3,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',6438.14,NULL,NULL,1,'2023-05-23 00:24:37','2023-05-23 00:24:37',NULL),(3305,7525,41023,27269,15,1324,'App\\Models\\PeriodLiquidation',NULL,1324,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',39506.93,NULL,NULL,1,'2023-05-23 13:13:12','2023-05-23 13:13:12',NULL),(3306,7525,41023,27270,15,1816,'App\\Models\\PeriodLiquidation',NULL,1816,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',53434.40,NULL,NULL,1,'2023-05-23 13:53:35','2023-05-23 13:53:35',NULL),(3307,7525,40849,13647,2,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',110000.00,NULL,NULL,1,'2023-05-24 13:06:54','2023-05-24 13:06:54',NULL),(3308,7525,40849,13647,2,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',32602.00,NULL,NULL,1,'2023-05-24 13:06:54','2023-05-24 13:06:54',NULL),(3309,7525,40849,13647,2,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',38500.00,NULL,NULL,1,'2023-05-24 13:06:54','2023-05-24 13:06:54',NULL),(3310,7525,40849,13647,2,2487,'App\\Models\\Receipt',2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',71101.00,NULL,NULL,1,'2023-05-24 13:06:55','2023-05-24 13:06:55',NULL),(3311,7525,40849,13647,2,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',94276.00,NULL,NULL,1,'2023-05-24 13:06:55','2023-05-24 13:06:55',NULL),(3312,7525,40849,13647,2,2489,'App\\Models\\Receipt',2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',45112.00,NULL,NULL,1,'2023-05-24 13:06:55','2023-05-24 13:06:55',NULL),(3313,7525,40849,13647,2,2490,'App\\Models\\Receipt',2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',71915.69,NULL,NULL,1,'2023-05-24 13:06:55','2023-05-24 13:06:55',NULL),(3314,7525,40849,13647,2,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',42680.00,NULL,NULL,1,'2023-05-24 13:06:55','2023-05-24 13:06:55',NULL),(3315,7525,40849,13647,2,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',30000.00,NULL,NULL,1,'2023-05-24 13:06:55','2023-05-24 13:06:55',NULL),(3316,7525,40849,13647,2,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',46600.00,NULL,NULL,1,'2023-05-24 13:06:55','2023-05-24 13:06:55',NULL),(3317,7525,40849,13647,2,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',46563.00,NULL,NULL,1,'2023-05-24 13:06:55','2023-05-24 13:06:55',NULL),(3318,7525,40849,13647,2,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',36883.00,NULL,NULL,1,'2023-05-24 13:06:55','2023-05-24 13:06:55',NULL),(3319,7525,40849,13647,2,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',123002.00,NULL,NULL,1,'2023-05-24 13:06:55','2023-05-24 13:06:55',NULL),(3320,7525,40849,13647,2,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',28258.00,NULL,NULL,1,'2023-05-24 13:06:55','2023-05-24 13:06:55',NULL),(3321,7525,40849,13647,2,2498,'App\\Models\\Receipt',2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',28500.00,NULL,NULL,1,'2023-05-24 13:06:55','2023-05-24 13:06:55',NULL);
INSERT INTO `balance_libro` VALUES (3322,7525,40849,13647,2,2499,'App\\Models\\Receipt',2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',47800.00,NULL,NULL,1,'2023-05-24 13:06:55','2023-05-24 13:06:55',NULL),(3323,7525,40849,13647,2,2500,'App\\Models\\Receipt',2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',52490.00,NULL,NULL,1,'2023-05-24 13:06:55','2023-05-24 13:06:55',NULL),(3324,7525,40849,13647,2,2501,'App\\Models\\Receipt',2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',69232.00,NULL,NULL,1,'2023-05-24 13:06:55','2023-05-24 13:06:55',NULL),(3325,7525,40849,13647,2,2502,'App\\Models\\Receipt',2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',85062.00,NULL,NULL,1,'2023-05-24 13:06:55','2023-05-24 13:06:55',NULL),(3326,7525,40849,13647,2,2503,'App\\Models\\Receipt',2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',62846.00,NULL,NULL,1,'2023-05-24 13:06:55','2023-05-24 13:06:55',NULL),(3327,7525,40849,13647,2,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',41860.00,NULL,NULL,1,'2023-05-24 13:06:55','2023-05-24 13:06:55',NULL),(3328,7525,40849,13647,2,2505,'App\\Models\\Receipt',2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',7301.00,NULL,NULL,1,'2023-05-24 13:06:55','2023-05-24 13:06:55',NULL),(3329,7525,40849,13647,7,2506,'App\\Models\\Receipt',2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',4940.34,NULL,NULL,1,'2023-05-24 14:07:24','2023-05-24 14:07:24',NULL),(3330,7525,40849,13647,3,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3531.61,NULL,NULL,1,'2023-05-24 14:21:09','2023-05-24 14:29:05','2023-05-24 14:29:05'),(3331,7525,40849,13647,3,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',7079.19,NULL,NULL,1,'2023-05-24 14:21:28','2023-05-24 14:38:56','2023-05-24 14:38:56'),(3332,7525,40849,13647,3,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3531.61,NULL,NULL,1,'2023-05-24 14:24:19','2023-05-24 14:29:28','2023-05-24 14:29:28'),(3333,7525,40849,13647,3,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',1728.00,NULL,NULL,1,'2023-05-24 14:24:37','2023-05-24 14:38:41','2023-05-24 14:38:41'),(3334,7525,40849,13647,3,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',12055.76,NULL,NULL,1,'2023-05-24 14:24:52','2023-05-24 14:38:23','2023-05-24 14:38:23'),(3335,7525,40849,13647,3,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',363605.00,NULL,NULL,1,'2023-05-24 14:25:28','2023-05-24 15:23:21','2023-05-24 15:23:21'),(3336,7525,40849,13647,3,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3531.61,NULL,NULL,1,'2023-05-24 14:29:05','2023-05-24 14:32:23','2023-05-24 14:32:23'),(3337,7525,40849,13647,3,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3531.61,NULL,NULL,1,'2023-05-24 14:29:28','2023-05-24 14:32:58','2023-05-24 14:32:58'),(3338,7525,40849,13647,3,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3531.61,NULL,NULL,1,'2023-05-24 14:32:23','2023-05-24 14:35:31','2023-05-24 14:35:31'),(3339,7525,40849,13647,3,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3531.61,NULL,NULL,1,'2023-05-24 14:32:58','2023-05-24 14:43:44','2023-05-24 14:43:44'),(3340,7525,40849,13647,3,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3531.61,NULL,NULL,1,'2023-05-24 14:35:31','2023-05-24 14:43:24','2023-05-24 14:43:24'),(3341,7525,40849,13647,3,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',12055.76,NULL,NULL,1,'2023-05-24 14:38:23','2023-05-24 14:42:40','2023-05-24 14:42:40');
INSERT INTO `balance_libro` VALUES (3342,7525,40849,13647,3,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',1728.00,NULL,NULL,1,'2023-05-24 14:38:41','2023-05-24 14:42:56','2023-05-24 14:42:56'),(3343,7525,40849,13647,3,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',7079.19,NULL,NULL,1,'2023-05-24 14:38:56','2023-05-24 14:41:39','2023-05-24 14:41:39'),(3344,7525,40849,13647,3,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',8662.03,NULL,NULL,1,'2023-05-24 14:39:10','2023-05-24 14:42:06','2023-05-24 14:42:06'),(3345,7525,40849,13647,3,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',1728.00,NULL,NULL,1,'2023-05-24 14:39:24','2023-05-24 14:42:23','2023-05-24 14:42:23'),(3346,7525,40849,13647,3,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',7079.19,NULL,NULL,1,'2023-05-24 14:41:39','2023-05-24 15:23:40','2023-05-24 15:23:40'),(3347,7525,40849,13647,3,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',8662.03,NULL,NULL,1,'2023-05-24 14:42:06','2023-05-24 14:42:06',NULL),(3348,7525,40849,13647,3,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',1728.00,NULL,NULL,1,'2023-05-24 14:42:23','2023-05-24 14:42:23',NULL),(3349,7525,40849,13647,3,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',12055.76,NULL,NULL,1,'2023-05-24 14:42:40','2023-05-24 14:42:40',NULL),(3350,7525,40849,13647,3,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',1728.00,NULL,NULL,1,'2023-05-24 14:42:56','2023-05-24 14:42:56',NULL),(3351,7525,40849,13647,3,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3531.61,NULL,NULL,1,'2023-05-24 14:43:24','2023-05-24 14:45:58','2023-05-24 14:45:58'),(3352,7525,40849,13647,3,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3531.61,NULL,NULL,1,'2023-05-24 14:43:44','2023-05-24 14:46:09','2023-05-24 14:46:09'),(3353,7525,40849,13647,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',5067.43,NULL,NULL,1,'2023-05-24 14:48:29','2023-05-24 14:55:09','2023-05-24 14:55:09'),(3354,7525,40849,13647,3,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',5067.50,NULL,NULL,1,'2023-05-24 14:54:51','2023-05-24 14:55:44','2023-05-24 14:55:44'),(3355,7525,40849,13647,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',5067.43,NULL,NULL,1,'2023-05-24 14:55:09','2023-05-24 14:58:58','2023-05-24 14:58:58'),(3356,7525,40849,13647,3,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',5067.50,NULL,NULL,1,'2023-05-24 14:55:44','2023-05-24 15:03:15','2023-05-24 15:03:15'),(3357,7525,40849,13647,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',5067.43,NULL,NULL,1,'2023-05-24 14:58:58','2023-05-24 14:59:13','2023-05-24 14:59:13'),(3358,7525,40849,13647,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',5067.43,NULL,NULL,1,'2023-05-24 14:59:13','2023-05-24 15:04:12','2023-05-24 15:04:12'),(3359,7525,40849,13647,3,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',5067.50,NULL,NULL,1,'2023-05-24 15:03:15','2023-05-24 15:03:50','2023-05-24 15:03:50'),(3360,7525,40849,13647,3,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',5067.50,NULL,NULL,1,'2023-05-24 15:03:50','2023-05-24 15:27:43','2023-05-24 15:27:43');
INSERT INTO `balance_libro` VALUES (3361,7525,40849,13647,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',5067.43,NULL,NULL,1,'2023-05-24 15:04:12','2023-05-24 15:08:10','2023-05-24 15:08:10'),(3362,7525,40849,13647,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',5067.43,NULL,NULL,1,'2023-05-24 15:08:10','2023-05-24 15:24:21','2023-05-24 15:24:21'),(3363,7525,40849,13647,3,2280,'App\\Models\\Receipt',2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',29956.66,NULL,NULL,1,'2023-05-24 15:19:35','2023-05-24 15:19:35',NULL),(3364,7525,40849,13647,3,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',13401.85,NULL,NULL,1,'2023-05-24 15:23:11','2023-05-24 15:25:28','2023-05-24 15:25:28'),(3365,7525,40849,13647,3,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',363605.00,NULL,NULL,1,'2023-05-24 15:23:21','2023-05-24 15:25:38','2023-05-24 15:25:38'),(3366,7525,40849,13647,3,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',14288.29,NULL,NULL,1,'2023-05-24 15:23:32','2023-05-24 15:25:52','2023-05-24 15:25:52'),(3367,7525,40849,13647,3,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',7079.19,NULL,NULL,1,'2023-05-24 15:23:40','2023-05-24 15:23:40',NULL),(3368,7525,40849,13647,3,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',27487.32,NULL,NULL,1,'2023-05-24 15:23:49','2023-05-24 15:23:49',NULL),(3369,7525,40849,13647,3,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',9777.45,NULL,NULL,1,'2023-05-24 15:23:59','2023-05-24 15:23:59',NULL),(3370,7525,40849,13647,3,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',13317.55,NULL,NULL,1,'2023-05-24 15:24:10','2023-05-24 15:24:47','2023-05-24 15:24:47'),(3371,7525,40849,13647,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',5067.43,NULL,NULL,1,'2023-05-24 15:24:21','2023-05-24 15:26:40','2023-05-24 15:26:40'),(3372,7525,40849,13647,3,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',13317.55,NULL,NULL,1,'2023-05-24 15:24:47','2023-05-24 15:24:47',NULL),(3373,7525,40849,13647,3,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',87529.10,NULL,NULL,1,'2023-05-24 15:25:01','2023-05-24 15:25:01',NULL),(3374,7525,40849,13647,3,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',13401.85,NULL,NULL,1,'2023-05-24 15:25:28','2023-05-24 15:25:28',NULL),(3375,7525,40849,13647,3,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',363605.00,NULL,NULL,1,'2023-05-24 15:25:38','2023-05-24 15:25:38',NULL),(3376,7525,40849,13647,3,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',14288.29,NULL,NULL,1,'2023-05-24 15:25:52','2023-05-24 15:25:52',NULL),(3377,7525,40849,13647,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',5067.43,NULL,NULL,1,'2023-05-24 15:26:40','2023-05-24 15:33:04','2023-05-24 15:33:04'),(3378,7525,40849,13647,3,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',5067.50,NULL,NULL,1,'2023-05-24 15:27:43','2023-05-24 15:33:34','2023-05-24 15:33:34'),(3379,7525,40849,13647,3,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',6012.52,NULL,NULL,1,'2023-05-24 15:28:30','2023-05-24 15:28:30',NULL),(3380,7525,40849,13647,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',5067.43,NULL,NULL,1,'2023-05-24 15:33:04','2023-05-24 15:33:49','2023-05-24 15:33:49');
INSERT INTO `balance_libro` VALUES (3381,7525,40849,13647,3,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',5067.50,NULL,NULL,1,'2023-05-24 15:33:34','2023-05-24 15:36:10','2023-05-24 15:36:10'),(3382,7525,40849,13647,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',5067.43,NULL,NULL,1,'2023-05-24 15:33:49','2023-05-24 15:40:25','2023-05-24 15:40:25'),(3383,7525,40849,13647,3,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',5067.51,NULL,NULL,1,'2023-05-24 15:36:10','2023-05-24 15:45:52','2023-05-24 15:45:52'),(3384,7525,40849,13647,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',5067.43,NULL,NULL,1,'2023-05-24 15:40:25','2023-05-24 15:42:59','2023-05-24 15:42:59'),(3385,7525,40849,13647,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',5067.43,NULL,NULL,1,'2023-05-24 15:42:59','2023-05-24 15:46:04','2023-05-24 15:46:04'),(3386,7525,40839,12131,15,1585,'App\\Models\\PeriodLiquidation',NULL,1585,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',105050.32,NULL,NULL,1,'2023-05-24 15:51:52','2023-05-24 15:51:52',NULL),(3387,7525,40839,12132,3,2322,'App\\Models\\Receipt',2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',3278.62,NULL,NULL,1,'2023-05-24 15:57:18','2023-05-24 15:57:18',NULL),(3388,7525,40839,12132,3,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',9801.91,NULL,NULL,1,'2023-05-24 16:01:39','2023-05-24 16:05:11','2023-05-24 16:05:11'),(3389,7525,40839,12132,3,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',9801.91,NULL,NULL,1,'2023-05-24 16:05:11','2023-05-24 16:05:11',NULL),(3390,7525,40839,12132,7,2507,'App\\Models\\Receipt',2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',10.50,NULL,NULL,1,'2023-05-24 16:11:40','2023-05-24 16:11:40',NULL),(3391,7525,40839,12132,3,2333,'App\\Models\\Receipt',2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',8852.64,NULL,NULL,1,'2023-05-24 16:23:09','2023-05-24 16:23:09',NULL),(3392,7525,40839,12132,15,1895,'App\\Models\\PeriodLiquidation',NULL,1895,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',164712.24,NULL,NULL,1,'2023-05-24 16:33:06','2023-05-24 16:33:06',NULL),(3393,7525,40856,15152,15,364,'App\\Models\\PeriodLiquidation',NULL,364,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',215783.36,NULL,NULL,1,'2023-05-24 17:53:29','2023-05-24 17:53:29',NULL),(3394,7525,40875,16671,3,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1232181.81,NULL,NULL,1,'2023-05-24 19:00:16','2023-05-24 19:00:16',NULL),(3395,7525,40875,16671,3,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',96905.62,NULL,NULL,1,'2023-05-24 19:01:59','2023-05-24 19:01:59',NULL),(3396,7525,40875,16671,3,2421,'App\\Models\\Receipt',2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',41091.83,NULL,NULL,1,'2023-05-24 19:04:31','2023-05-24 19:04:31',NULL),(3397,7525,40875,16671,3,2422,'App\\Models\\Receipt',2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',9196.98,NULL,NULL,1,'2023-05-24 19:05:53','2023-05-24 19:05:53',NULL),(3398,7525,41011,25752,15,1813,'App\\Models\\PeriodLiquidation',NULL,1813,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',148002.26,NULL,NULL,1,'2023-05-25 15:02:16','2023-05-25 15:02:16',NULL),(3399,7525,40906,18183,15,1935,'App\\Models\\PeriodLiquidation',NULL,1935,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',183810.91,NULL,NULL,1,'2023-05-25 15:20:35','2023-05-25 15:20:35',NULL),(3400,7525,40915,22725,2,2508,'App\\Models\\Receipt',2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',59229.50,NULL,NULL,1,'2023-05-25 15:28:56','2023-05-25 15:28:56',NULL);
INSERT INTO `balance_libro` VALUES (3401,7525,40915,22725,2,2509,'App\\Models\\Receipt',2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',158389.00,NULL,NULL,1,'2023-05-25 15:28:56','2023-05-25 15:28:56',NULL),(3402,7525,40915,22725,2,2510,'App\\Models\\Receipt',2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',227056.50,NULL,NULL,1,'2023-05-25 15:28:56','2023-05-25 15:28:56',NULL),(3403,7525,40915,22725,2,2511,'App\\Models\\Receipt',2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',149870.60,NULL,NULL,1,'2023-05-25 15:28:56','2023-05-25 15:28:56',NULL),(3404,7525,40915,22725,3,2512,'App\\Models\\Receipt',2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',6230.73,NULL,NULL,1,'2023-05-25 15:29:07','2023-05-25 15:49:07','2023-05-25 15:49:07'),(3405,7525,40915,22725,3,2513,'App\\Models\\Receipt',2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',32732.92,NULL,NULL,1,'2023-05-25 15:29:07','2023-05-25 15:29:07',NULL),(3406,7525,40915,22725,3,2514,'App\\Models\\Receipt',2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',13657.88,NULL,NULL,1,'2023-05-25 15:29:07','2023-05-25 15:29:07',NULL),(3407,7525,40915,22725,3,2515,'App\\Models\\Receipt',2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',114983.03,NULL,NULL,1,'2023-05-25 15:29:07','2023-05-25 15:50:32','2023-05-25 15:50:32'),(3408,7525,40915,22725,3,2516,'App\\Models\\Receipt',2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',460.06,NULL,NULL,1,'2023-05-25 15:29:07','2023-05-25 15:47:33','2023-05-25 15:47:33'),(3409,7525,40915,22725,3,2517,'App\\Models\\Receipt',2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',48957.51,NULL,NULL,1,'2023-05-25 15:29:07','2023-05-25 15:29:07',NULL),(3410,7525,40915,22725,3,2518,'App\\Models\\Receipt',2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',102985.96,NULL,NULL,1,'2023-05-25 15:29:07','2023-05-25 15:29:07',NULL),(3411,7525,40915,22725,3,2519,'App\\Models\\Receipt',2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',137557.68,NULL,NULL,1,'2023-05-25 15:29:07','2023-05-25 15:29:07',NULL),(3412,7525,40915,22725,3,2520,'App\\Models\\Receipt',2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',18606.78,NULL,NULL,1,'2023-05-25 15:29:07','2023-05-25 15:29:07',NULL),(3413,7525,40915,22725,3,2521,'App\\Models\\Receipt',2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8000.00,NULL,NULL,1,'2023-05-25 15:29:07','2023-05-25 15:46:59','2023-05-25 15:46:59'),(3414,7525,40915,22725,3,2522,'App\\Models\\Receipt',2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',82824.69,NULL,NULL,1,'2023-05-25 15:29:07','2023-05-25 15:46:49','2023-05-25 15:46:49'),(3415,7525,40915,22725,3,2523,'App\\Models\\Receipt',2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',113980.84,NULL,NULL,1,'2023-05-25 15:29:07','2023-05-25 15:46:39','2023-05-25 15:46:39'),(3416,7525,40915,22725,3,2524,'App\\Models\\Receipt',2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',74097.98,NULL,NULL,1,'2023-05-25 15:29:07','2023-05-25 15:29:07',NULL),(3417,7525,40915,22725,3,2525,'App\\Models\\Receipt',2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',7442.71,NULL,NULL,1,'2023-05-25 15:29:07','2023-05-25 15:46:28','2023-05-25 15:46:28'),(3418,7525,40915,22725,3,2526,'App\\Models\\Receipt',2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',5463.15,NULL,NULL,1,'2023-05-25 15:29:07','2023-05-25 15:46:22','2023-05-25 15:46:22'),(3419,7525,40915,22725,3,2527,'App\\Models\\Receipt',2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',20478.04,NULL,NULL,1,'2023-05-25 15:29:07','2023-05-25 15:46:15','2023-05-25 15:46:15'),(3420,7525,40915,22725,3,2528,'App\\Models\\Receipt',2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',0.00,NULL,NULL,1,'2023-05-25 15:29:07','2023-05-25 15:46:04','2023-05-25 15:46:04');
INSERT INTO `balance_libro` VALUES (3421,7525,40915,22725,3,2527,'App\\Models\\Receipt',2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',20478.04,NULL,NULL,1,'2023-05-25 15:46:15','2023-05-25 15:46:15',NULL),(3422,7525,40915,22725,3,2526,'App\\Models\\Receipt',2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',5463.15,NULL,NULL,1,'2023-05-25 15:46:22','2023-05-25 15:46:22',NULL),(3423,7525,40915,22725,3,2525,'App\\Models\\Receipt',2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',7442.71,NULL,NULL,1,'2023-05-25 15:46:28','2023-05-25 15:46:28',NULL),(3424,7525,40915,22725,3,2523,'App\\Models\\Receipt',2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',113980.84,NULL,NULL,1,'2023-05-25 15:46:39','2023-05-25 15:46:39',NULL),(3425,7525,40915,22725,3,2522,'App\\Models\\Receipt',2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',82824.69,NULL,NULL,1,'2023-05-25 15:46:49','2023-05-25 15:46:49',NULL),(3426,7525,40915,22725,3,2521,'App\\Models\\Receipt',2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8000.00,NULL,NULL,1,'2023-05-25 15:46:59','2023-05-25 15:46:59',NULL),(3427,7525,40915,22725,3,2516,'App\\Models\\Receipt',2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',460.06,NULL,NULL,1,'2023-05-25 15:47:33','2023-05-25 15:47:33',NULL),(3428,7525,40915,22725,3,2512,'App\\Models\\Receipt',2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',6230.73,NULL,NULL,1,'2023-05-25 15:49:07','2023-05-25 15:49:07',NULL),(3429,7525,40915,22725,3,2515,'App\\Models\\Receipt',2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',114983.05,NULL,NULL,1,'2023-05-25 15:50:32','2023-05-25 15:50:32',NULL),(3430,7525,40915,22725,3,2529,'App\\Models\\Receipt',2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',6000.79,NULL,NULL,1,'2023-05-25 16:00:30','2023-05-25 16:00:30',NULL),(3431,7525,40915,22725,3,2530,'App\\Models\\Receipt',2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',6900.95,NULL,NULL,1,'2023-05-25 16:01:24','2023-05-25 16:01:24',NULL),(3432,7525,40915,22725,3,2531,'App\\Models\\Receipt',2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',3449.89,NULL,NULL,1,'2023-05-25 16:02:04','2023-05-25 16:02:04',NULL),(3433,7525,40915,22725,3,2532,'App\\Models\\Receipt',2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',5000.00,NULL,NULL,1,'2023-05-25 16:02:40','2023-05-25 16:02:40',NULL),(3434,7525,40915,22725,3,2533,'App\\Models\\Receipt',2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',5000.04,NULL,NULL,1,'2023-05-25 16:03:23','2023-05-25 16:03:23',NULL),(3435,7525,40915,22725,3,2534,'App\\Models\\Receipt',2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',4999.98,NULL,NULL,1,'2023-05-25 16:04:09','2023-05-25 16:04:09',NULL),(3436,7525,40915,22725,3,2535,'App\\Models\\Receipt',2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',4999.99,NULL,NULL,1,'2023-05-25 16:04:39','2023-05-25 16:04:39',NULL),(3437,7525,40915,22725,3,2536,'App\\Models\\Receipt',2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',9740.03,NULL,NULL,1,'2023-05-25 16:05:46','2023-05-25 16:05:46',NULL),(3438,7525,40915,22725,3,2537,'App\\Models\\Receipt',2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',9752.81,NULL,NULL,1,'2023-05-25 16:06:18','2023-05-25 16:06:18',NULL),(3439,7525,40915,22725,3,2538,'App\\Models\\Receipt',2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',6000.01,NULL,NULL,1,'2023-05-25 16:06:43','2023-05-25 16:06:43',NULL),(3440,7525,40915,22725,3,2539,'App\\Models\\Receipt',2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',15000.83,NULL,NULL,1,'2023-05-25 16:07:35','2023-05-25 16:07:35',NULL),(3441,7525,40915,22725,3,2540,'App\\Models\\Receipt',2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',7513.36,NULL,NULL,1,'2023-05-25 16:10:09','2023-05-25 16:10:09',NULL);
INSERT INTO `balance_libro` VALUES (3442,7525,40915,22725,3,2541,'App\\Models\\Receipt',2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',9201.30,NULL,NULL,1,'2023-05-25 16:10:44','2023-05-25 16:10:44',NULL),(3443,7525,41204,30284,2,2542,'App\\Models\\Receipt',2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',77246.40,NULL,NULL,1,'2023-05-25 16:25:08','2023-05-25 16:25:08',NULL),(3444,7525,41204,30284,2,2543,'App\\Models\\Receipt',2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',203643.00,NULL,NULL,1,'2023-05-25 16:25:08','2023-05-25 16:25:08',NULL),(3445,7525,41204,30284,2,2544,'App\\Models\\Receipt',2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',405368.15,NULL,NULL,1,'2023-05-25 16:25:08','2023-05-25 16:25:08',NULL),(3446,7525,41204,30284,3,2545,'App\\Models\\Receipt',2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',5850.04,NULL,NULL,1,'2023-05-25 16:25:56','2023-05-25 16:25:56',NULL),(3447,7525,41204,30284,3,2546,'App\\Models\\Receipt',2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',114000.00,NULL,NULL,1,'2023-05-25 16:25:56','2023-05-25 16:25:56',NULL),(3448,7525,41204,30284,3,2547,'App\\Models\\Receipt',2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',3721.00,NULL,NULL,1,'2023-05-25 16:25:56','2023-05-25 16:25:56',NULL),(3449,7525,41204,30284,3,2548,'App\\Models\\Receipt',2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',2440.00,NULL,NULL,1,'2023-05-25 16:25:56','2023-05-25 16:25:56',NULL),(3450,7525,41204,30284,3,2549,'App\\Models\\Receipt',2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8000.00,NULL,NULL,1,'2023-05-25 16:25:56','2023-05-25 16:28:28','2023-05-25 16:28:28'),(3451,7525,41204,30284,3,2550,'App\\Models\\Receipt',2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',37330.00,NULL,NULL,1,'2023-05-25 16:25:56','2023-05-25 16:25:56',NULL),(3452,7525,41204,30284,3,2551,'App\\Models\\Receipt',2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',100.00,NULL,NULL,1,'2023-05-25 16:25:56','2023-05-25 16:28:05','2023-05-25 16:28:05'),(3453,7525,41204,30284,3,2552,'App\\Models\\Receipt',2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',216590.00,NULL,NULL,1,'2023-05-25 16:25:56','2023-05-25 16:25:56',NULL),(3454,7525,41204,30284,3,2549,'App\\Models\\Receipt',2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8000.00,NULL,NULL,1,'2023-05-25 16:28:28','2023-05-25 16:28:28',NULL),(3455,7525,41204,30284,3,2553,'App\\Models\\Receipt',2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',10000.11,NULL,NULL,1,'2023-05-25 16:33:56','2023-05-25 16:33:56',NULL),(3456,7525,41204,30284,3,2554,'App\\Models\\Receipt',2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',9999.77,NULL,NULL,1,'2023-05-25 16:34:40','2023-05-25 16:34:40',NULL),(3457,7525,41204,30284,3,2555,'App\\Models\\Receipt',2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',20240.00,NULL,NULL,1,'2023-05-25 16:36:06','2023-05-25 16:36:06',NULL),(3458,7525,41204,30284,3,2556,'App\\Models\\Receipt',2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',5470.00,NULL,NULL,1,'2023-05-25 16:36:32','2023-05-25 16:36:32',NULL),(3459,7525,41204,30284,3,2557,'App\\Models\\Receipt',2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',5990.00,NULL,NULL,1,'2023-05-25 16:37:23','2023-05-25 16:37:23',NULL),(3460,7525,41204,30284,3,2558,'App\\Models\\Receipt',2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',2500.01,NULL,NULL,1,'2023-05-25 16:37:52','2023-05-25 16:37:52',NULL),(3461,7525,41204,30284,3,2559,'App\\Models\\Receipt',2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',2499.95,NULL,NULL,1,'2023-05-25 16:38:24','2023-05-25 16:38:24',NULL);
INSERT INTO `balance_libro` VALUES (3462,7525,41204,30284,3,2560,'App\\Models\\Receipt',2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',4499.95,NULL,NULL,1,'2023-05-25 16:38:54','2023-05-25 16:38:54',NULL),(3463,7525,41204,30284,3,2561,'App\\Models\\Receipt',2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3000.00,NULL,NULL,1,'2023-05-25 16:39:22','2023-05-25 16:39:22',NULL),(3464,7525,41204,30284,3,2562,'App\\Models\\Receipt',2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',8000.00,NULL,NULL,1,'2023-05-25 16:39:55','2023-05-25 16:39:55',NULL),(3465,7525,41204,30284,3,2563,'App\\Models\\Receipt',2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',4560.06,NULL,NULL,1,'2023-05-25 16:40:26','2023-05-25 16:40:26',NULL),(3466,7525,41204,30284,3,2564,'App\\Models\\Receipt',2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',8200.10,NULL,NULL,1,'2023-05-25 16:41:04','2023-05-25 16:41:04',NULL),(3467,7525,41204,30284,3,2565,'App\\Models\\Receipt',2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',3679.95,NULL,NULL,1,'2023-05-25 16:41:30','2023-05-25 16:41:30',NULL),(3468,7525,41204,30284,3,2566,'App\\Models\\Receipt',2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',4350.03,NULL,NULL,1,'2023-05-25 16:42:00','2023-05-25 16:42:00',NULL),(3469,7525,41204,30284,3,2567,'App\\Models\\Receipt',2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',5299.97,NULL,NULL,1,'2023-05-25 16:42:38','2023-05-25 16:42:38',NULL),(3470,7525,41204,30284,3,2568,'App\\Models\\Receipt',2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',2500.01,NULL,NULL,1,'2023-05-25 16:43:07','2023-05-25 16:43:07',NULL),(3471,7525,41204,30284,3,2569,'App\\Models\\Receipt',2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',6000.00,NULL,NULL,1,'2023-05-25 16:43:55','2023-05-25 16:43:55',NULL),(3472,7525,41184,28768,3,2570,'App\\Models\\Receipt',2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',120516.00,NULL,NULL,1,'2023-05-29 11:39:46','2023-05-29 11:39:46',NULL),(3473,7525,41184,28768,3,2571,'App\\Models\\Receipt',2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',36009.96,NULL,NULL,1,'2023-05-29 11:39:46','2023-05-29 11:39:46',NULL),(3474,7525,41184,28768,3,2572,'App\\Models\\Receipt',2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',1029.31,NULL,NULL,1,'2023-05-29 11:39:46','2023-05-29 11:39:46',NULL),(3475,7525,41184,28768,3,2573,'App\\Models\\Receipt',2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',77853.99,NULL,NULL,1,'2023-05-29 11:39:46','2023-05-29 11:39:46',NULL),(3476,7525,41184,28768,3,2574,'App\\Models\\Receipt',2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',3177.95,NULL,NULL,1,'2023-05-29 11:39:46','2023-05-29 11:39:46',NULL),(3477,7525,41184,28768,3,2575,'App\\Models\\Receipt',2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',12101.11,NULL,NULL,1,'2023-05-29 11:39:46','2023-06-09 11:17:40','2023-06-09 11:17:40'),(3478,7525,41184,28768,3,2576,'App\\Models\\Receipt',2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',192828.35,NULL,NULL,1,'2023-05-29 11:39:46','2023-05-29 11:39:46',NULL),(3479,7525,41184,28768,3,2577,'App\\Models\\Receipt',2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',85284.00,NULL,NULL,1,'2023-05-29 11:39:46','2023-06-09 11:17:27','2023-06-09 11:17:27'),(3480,7525,41184,28768,3,2578,'App\\Models\\Receipt',2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',318133.20,NULL,NULL,1,'2023-05-29 11:39:46','2023-05-29 11:39:46',NULL),(3481,7525,41184,28768,3,2579,'App\\Models\\Receipt',2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',54450.00,NULL,NULL,1,'2023-05-29 11:39:46','2023-05-29 11:39:46',NULL);
INSERT INTO `balance_libro` VALUES (3482,7525,41184,28768,3,2580,'App\\Models\\Receipt',2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',12966.78,NULL,NULL,1,'2023-05-29 11:39:46','2023-06-09 11:17:15','2023-06-09 11:17:15'),(3483,7525,41184,28768,3,2581,'App\\Models\\Receipt',2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',61200.01,NULL,NULL,1,'2023-05-29 11:39:46','2023-05-29 11:39:46',NULL),(3484,7525,41184,28768,3,2582,'App\\Models\\Receipt',2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',12800.99,NULL,NULL,1,'2023-05-29 11:39:47','2023-06-09 11:16:56','2023-06-09 11:16:56'),(3485,7525,41184,28768,2,2583,'App\\Models\\Receipt',2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',16940.00,NULL,NULL,1,'2023-05-29 11:40:00','2023-05-29 11:40:00',NULL),(3486,7525,41184,28768,2,2584,'App\\Models\\Receipt',2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',450120.00,NULL,NULL,1,'2023-05-29 11:40:00','2023-05-29 11:40:00',NULL),(3487,7525,41184,28768,2,2585,'App\\Models\\Receipt',2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',5445.00,NULL,NULL,1,'2023-05-29 11:40:00','2023-05-29 11:40:00',NULL),(3488,7525,41184,28768,2,2586,'App\\Models\\Receipt',2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',75020.00,NULL,NULL,1,'2023-05-29 11:40:00','2023-05-29 11:40:00',NULL),(3489,7525,41184,28768,2,2587,'App\\Models\\Receipt',2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',112530.00,NULL,NULL,1,'2023-05-29 11:40:00','2023-05-29 11:40:00',NULL),(3490,7525,41184,28768,2,2588,'App\\Models\\Receipt',2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',514250.00,NULL,NULL,1,'2023-05-29 11:40:00','2023-05-29 11:40:00',NULL),(3491,7525,40915,22725,15,1982,'App\\Models\\PeriodLiquidation',NULL,1982,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',187955.27,NULL,NULL,1,'2023-05-29 15:29:55','2023-05-29 15:29:55',NULL),(3492,7525,41204,30284,15,1976,'App\\Models\\PeriodLiquidation',NULL,1976,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',119102.55,NULL,NULL,1,'2023-05-29 15:30:26','2023-05-29 15:30:26',NULL),(3493,7525,40856,15159,15,1908,'App\\Models\\PeriodLiquidation',NULL,1908,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',129658.04,NULL,NULL,1,'2023-05-29 15:31:33','2023-05-29 15:31:33',NULL),(3494,7525,40849,13647,15,1896,'App\\Models\\PeriodLiquidation',NULL,1896,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',243971.49,NULL,NULL,1,'2023-05-29 15:32:14','2023-05-29 15:32:14',NULL),(3495,7525,40917,19698,2,2589,'App\\Models\\Receipt',2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',29100.07,NULL,NULL,1,'2023-05-29 15:35:38','2023-05-29 15:35:38',NULL),(3496,7525,40917,19698,2,2590,'App\\Models\\Receipt',2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',19300.04,NULL,NULL,1,'2023-05-29 15:35:38','2023-05-29 15:35:38',NULL),(3497,7525,40917,19698,2,2591,'App\\Models\\Receipt',2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',17650.03,NULL,NULL,1,'2023-05-29 15:35:38','2023-05-29 15:35:38',NULL),(3498,7525,40917,19698,2,2592,'App\\Models\\Receipt',2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',306000.29,NULL,NULL,1,'2023-05-29 15:35:38','2023-05-29 15:35:38',NULL),(3499,7525,40917,19698,2,2593,'App\\Models\\Receipt',2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',120000.54,NULL,NULL,1,'2023-05-29 15:35:38','2023-05-29 15:35:38',NULL),(3500,7525,40917,19698,2,2594,'App\\Models\\Receipt',2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',19650.07,NULL,NULL,1,'2023-05-29 15:35:38','2023-05-29 15:35:38',NULL),(3501,7525,40917,19698,2,2595,'App\\Models\\Receipt',2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',21050.11,NULL,NULL,1,'2023-05-29 15:35:38','2023-05-29 15:35:38',NULL);
INSERT INTO `balance_libro` VALUES (3502,7525,40917,19698,2,2596,'App\\Models\\Receipt',2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',14900.00,NULL,NULL,1,'2023-05-29 15:35:38','2023-05-29 15:35:38',NULL),(3503,7525,40917,19698,2,2597,'App\\Models\\Receipt',2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',23450.12,NULL,NULL,1,'2023-05-29 15:35:38','2023-05-29 15:35:38',NULL),(3504,7525,40917,19698,2,2598,'App\\Models\\Receipt',2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',21230.06,NULL,NULL,1,'2023-05-29 15:35:38','2023-05-29 15:35:38',NULL),(3505,7525,40917,19698,2,2599,'App\\Models\\Receipt',2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',84600.07,NULL,NULL,1,'2023-05-29 15:35:38','2023-05-29 15:35:38',NULL),(3506,7525,40917,19698,2,2600,'App\\Models\\Receipt',2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',115500.55,NULL,NULL,1,'2023-05-29 15:35:38','2023-05-29 15:35:38',NULL),(3507,7525,40917,19698,2,2601,'App\\Models\\Receipt',2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',357000.33,NULL,NULL,1,'2023-05-29 15:35:39','2023-05-29 15:35:39',NULL),(3508,7525,40917,19698,2,2602,'App\\Models\\Receipt',2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',140529.40,NULL,NULL,1,'2023-05-29 15:35:39','2023-05-29 15:35:39',NULL),(3509,7525,40917,19698,2,2603,'App\\Models\\Receipt',2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',78439.46,NULL,NULL,1,'2023-05-29 15:35:39','2023-05-29 15:35:39',NULL),(3510,7525,40917,19698,2,2604,'App\\Models\\Receipt',2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',148000.42,NULL,NULL,1,'2023-05-29 15:35:39','2023-05-29 15:35:39',NULL),(3511,7525,40917,19698,2,2605,'App\\Models\\Receipt',2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',217800.00,NULL,NULL,1,'2023-05-29 15:35:39','2023-05-29 15:35:39',NULL),(3512,7525,40917,19698,2,2606,'App\\Models\\Receipt',2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',67370.02,NULL,NULL,1,'2023-05-29 15:35:39','2023-05-29 15:35:39',NULL),(3513,7525,40917,19698,2,2607,'App\\Models\\Receipt',2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',112500.35,NULL,NULL,1,'2023-05-29 15:35:39','2023-05-29 15:35:39',NULL),(3514,7525,40917,19698,2,2608,'App\\Models\\Receipt',2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',120000.54,NULL,NULL,1,'2023-05-29 15:35:39','2023-05-29 15:35:39',NULL),(3515,7525,40917,19698,2,2609,'App\\Models\\Receipt',2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',164000.01,NULL,NULL,1,'2023-05-29 15:35:39','2023-05-29 15:35:39',NULL),(3516,7525,40917,19698,2,2610,'App\\Models\\Receipt',2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',181500.00,NULL,NULL,1,'2023-05-29 15:35:39','2023-05-29 15:35:39',NULL),(3517,7525,40917,19698,2,2611,'App\\Models\\Receipt',2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',118000.65,NULL,NULL,1,'2023-05-29 15:35:39','2023-05-29 15:35:39',NULL),(3518,7525,40917,19698,3,2612,'App\\Models\\Receipt',2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',120873.95,NULL,NULL,1,'2023-05-29 15:35:51','2023-05-29 15:35:51',NULL),(3519,7525,40917,19698,3,2613,'App\\Models\\Receipt',2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',5267.26,NULL,NULL,1,'2023-05-29 15:35:51','2023-05-29 16:19:08','2023-05-29 16:19:08'),(3520,7525,40917,19698,3,2614,'App\\Models\\Receipt',2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',150879.81,NULL,NULL,1,'2023-05-29 15:35:51','2023-05-29 15:35:51',NULL),(3521,7525,40917,19698,3,2615,'App\\Models\\Receipt',2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',15928.38,NULL,NULL,1,'2023-05-29 15:35:51','2023-05-29 16:10:54','2023-05-29 16:10:54');
INSERT INTO `balance_libro` VALUES (3522,7525,40917,19698,3,2616,'App\\Models\\Receipt',2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8000.00,NULL,NULL,1,'2023-05-29 15:35:51','2023-05-29 16:11:04','2023-05-29 16:11:04'),(3523,7525,40917,19698,3,2617,'App\\Models\\Receipt',2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',92662.57,NULL,NULL,1,'2023-05-29 15:35:52','2023-05-29 16:10:21','2023-05-29 16:10:21'),(3524,7525,40917,19698,3,2618,'App\\Models\\Receipt',2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',165560.33,NULL,NULL,1,'2023-05-29 15:35:52','2023-05-29 15:35:52',NULL),(3525,7525,40917,19698,3,2619,'App\\Models\\Receipt',2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',253272.34,NULL,NULL,1,'2023-05-29 15:35:52','2023-05-29 15:35:52',NULL),(3526,7525,40917,19698,3,2620,'App\\Models\\Receipt',2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',16963.99,NULL,NULL,1,'2023-05-29 15:35:52','2023-05-29 15:35:52',NULL),(3527,7525,40917,19698,3,2621,'App\\Models\\Receipt',2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',89000.00,NULL,NULL,1,'2023-05-29 15:35:52','2023-05-29 15:35:52',NULL),(3528,7525,40917,19698,3,2622,'App\\Models\\Receipt',2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',256279.64,NULL,NULL,1,'2023-05-29 15:35:52','2023-05-29 15:35:52',NULL),(3529,7525,40917,19698,3,2623,'App\\Models\\Receipt',2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',33165.05,NULL,NULL,1,'2023-05-29 15:35:52','2023-05-29 16:09:31','2023-05-29 16:09:31'),(3530,7525,40917,19698,3,2623,'App\\Models\\Receipt',2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',33165.05,NULL,NULL,1,'2023-05-29 16:09:31','2023-05-29 16:09:31',NULL),(3531,7525,40917,19698,3,2617,'App\\Models\\Receipt',2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',92662.57,NULL,NULL,1,'2023-05-29 16:10:21','2023-05-29 16:10:21',NULL),(3532,7525,40917,19698,3,2615,'App\\Models\\Receipt',2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',15928.38,NULL,NULL,1,'2023-05-29 16:10:54','2023-05-29 16:10:54',NULL),(3533,7525,40917,19698,3,2616,'App\\Models\\Receipt',2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8000.00,NULL,NULL,1,'2023-05-29 16:11:04','2023-05-29 16:11:04',NULL),(3534,7525,40917,19698,7,2624,'App\\Models\\Receipt',2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1463.94,NULL,NULL,1,'2023-05-29 16:18:34','2023-05-29 16:18:34',NULL),(3535,7525,40917,19698,15,1990,'App\\Models\\PeriodLiquidation',NULL,1990,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',795274.72,NULL,NULL,1,'2023-05-29 16:28:14','2023-05-29 16:28:14',NULL),(3536,7525,41184,28768,2,2625,'App\\Models\\Receipt',2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',582736.00,NULL,NULL,1,'2023-06-09 10:46:19','2023-06-09 10:46:19',NULL),(3537,7525,41184,28768,2,2626,'App\\Models\\Receipt',2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',283140.00,NULL,NULL,1,'2023-06-09 10:46:19','2023-06-09 10:46:19',NULL),(3538,7525,41184,28768,2,2627,'App\\Models\\Receipt',2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',65340.00,NULL,NULL,1,'2023-06-09 10:46:19','2023-06-09 10:46:19',NULL),(3539,7525,41184,28768,2,2628,'App\\Models\\Receipt',2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',283140.00,NULL,NULL,1,'2023-06-09 10:46:19','2023-06-09 10:46:19',NULL),(3540,7525,41184,28768,2,2629,'App\\Models\\Receipt',2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',765264.50,NULL,NULL,1,'2023-06-09 10:46:19','2023-06-09 10:46:19',NULL),(3541,7525,41184,28768,3,2630,'App\\Models\\Receipt',2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',12800.00,NULL,NULL,1,'2023-06-09 10:46:32','2023-06-09 10:52:07','2023-06-09 10:52:07');
INSERT INTO `balance_libro` VALUES (3542,7525,41184,28768,3,2631,'App\\Models\\Receipt',2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',220500.00,NULL,NULL,1,'2023-06-09 10:46:32','2023-06-09 10:51:07','2023-06-09 10:51:07'),(3543,7525,41184,28768,3,2631,'App\\Models\\Receipt',2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',220500.00,NULL,NULL,1,'2023-06-09 10:51:07','2023-06-09 11:16:32','2023-06-09 11:16:32'),(3544,7525,41184,28768,3,2630,'App\\Models\\Receipt',2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',12800.00,NULL,NULL,1,'2023-06-09 10:52:07','2023-06-09 11:16:40','2023-06-09 11:16:40'),(3545,7525,41184,28768,3,2631,'App\\Models\\Receipt',2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',220500.00,NULL,NULL,1,'2023-06-09 11:16:32','2023-06-09 11:16:32',NULL),(3546,7525,41184,28768,3,2630,'App\\Models\\Receipt',2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',12800.00,NULL,NULL,1,'2023-06-09 11:16:40','2023-06-13 17:41:33','2023-06-13 17:41:33'),(3547,7525,41184,28768,3,2582,'App\\Models\\Receipt',2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',12800.99,NULL,NULL,1,'2023-06-09 11:16:56','2023-06-09 11:16:56',NULL),(3548,7525,41184,28768,3,2580,'App\\Models\\Receipt',2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',12966.78,NULL,NULL,1,'2023-06-09 11:17:15','2023-06-09 11:17:15',NULL),(3549,7525,41184,28768,3,2577,'App\\Models\\Receipt',2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',85284.00,NULL,NULL,1,'2023-06-09 11:17:27','2023-06-09 11:17:27',NULL),(3550,7525,41184,28768,3,2575,'App\\Models\\Receipt',2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',12101.11,NULL,NULL,1,'2023-06-09 11:17:40','2023-06-09 11:17:40',NULL),(3551,7525,41184,28768,3,2632,'App\\Models\\Receipt',2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',10885.50,NULL,NULL,1,'2023-06-09 11:19:31','2023-06-09 11:19:31',NULL),(3552,7525,41184,28768,3,2633,'App\\Models\\Receipt',2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',23000.00,NULL,NULL,1,'2023-06-09 11:21:28','2023-06-09 11:21:28',NULL),(3553,7525,41184,28768,15,2015,'App\\Models\\PeriodLiquidation',NULL,2015,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',498235.50,NULL,NULL,1,'2023-06-23 14:41:02','2023-06-23 14:41:02',NULL),(3554,7525,41184,28768,16,2016,'App\\Models\\PeriodLiquidation',NULL,2016,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',0.00,NULL,NULL,1,'2023-06-23 14:41:12','2023-06-23 14:41:12',NULL),(3555,7525,41184,28769,2,2634,'App\\Models\\Receipt',2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',137800.00,NULL,NULL,1,'2023-06-23 14:54:43','2023-06-23 14:54:43',NULL),(3556,7525,41184,28769,2,2635,'App\\Models\\Receipt',2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',136215.00,NULL,NULL,1,'2023-06-23 14:54:43','2023-06-23 14:54:43',NULL),(3557,7525,41184,28769,2,2636,'App\\Models\\Receipt',2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',102850.00,NULL,NULL,1,'2023-06-23 14:54:43','2023-06-23 14:54:43',NULL),(3558,7525,41184,28769,2,2637,'App\\Models\\Receipt',2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',59713.50,NULL,NULL,1,'2023-06-23 14:54:43','2023-06-23 14:54:43',NULL),(3559,7525,41184,28769,2,2638,'App\\Models\\Receipt',2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',86394.00,NULL,NULL,1,'2023-06-23 14:54:43','2023-06-23 14:54:43',NULL),(3560,7525,41184,28769,2,2639,'App\\Models\\Receipt',2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',500067.75,NULL,NULL,1,'2023-06-23 14:54:43','2023-06-23 14:54:43',NULL),(3561,7525,41184,28769,2,2640,'App\\Models\\Receipt',2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',100672.00,NULL,NULL,1,'2023-06-23 14:54:43','2023-06-23 14:54:43',NULL);
INSERT INTO `balance_libro` VALUES (3562,7525,41184,28769,2,2641,'App\\Models\\Receipt',2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',200060.25,NULL,NULL,1,'2023-06-23 14:54:43','2023-06-23 14:54:43',NULL),(3563,7525,41184,28769,2,2642,'App\\Models\\Receipt',2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',699931.20,NULL,NULL,1,'2023-06-23 14:54:44','2023-06-23 14:54:44',NULL),(3564,7525,41184,28769,3,2643,'App\\Models\\Receipt',2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',95844.26,NULL,NULL,1,'2023-06-23 14:54:57','2023-06-23 14:54:57',NULL),(3565,7525,41184,28769,3,2644,'App\\Models\\Receipt',2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',80846.15,NULL,NULL,1,'2023-06-23 14:54:57','2023-06-23 14:54:57',NULL),(3566,7525,41184,28769,3,2645,'App\\Models\\Receipt',2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',220500.00,NULL,NULL,1,'2023-06-23 14:54:57','2023-06-23 14:54:57',NULL),(3567,7525,41184,28769,3,2646,'App\\Models\\Receipt',2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',13230.00,NULL,NULL,1,'2023-06-23 14:54:57','2023-06-23 14:54:57',NULL),(3568,7525,41184,28769,3,2647,'App\\Models\\Receipt',2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',44100.00,NULL,NULL,1,'2023-06-23 14:54:57','2023-06-23 14:54:57',NULL),(3569,7525,41184,28769,3,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',561670.30,NULL,NULL,1,'2023-06-23 14:54:57','2023-06-23 14:54:57',NULL),(3570,7525,41184,28769,3,2649,'App\\Models\\Receipt',2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',4171.72,NULL,NULL,1,'2023-06-23 14:54:57','2023-06-23 14:54:57',NULL),(3571,7525,41184,28769,3,2650,'App\\Models\\Receipt',2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',11478.04,NULL,NULL,1,'2023-06-23 14:54:57','2023-06-23 14:54:57',NULL),(3572,7525,41184,28769,3,2651,'App\\Models\\Receipt',2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',7230.26,NULL,NULL,1,'2023-06-23 14:54:57','2023-06-23 14:54:57',NULL),(3573,7525,41184,28769,3,2652,'App\\Models\\Receipt',2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',40656.57,NULL,NULL,1,'2023-06-23 14:54:57','2023-06-23 14:54:57',NULL),(3574,7525,41184,28769,3,2653,'App\\Models\\Receipt',2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',496584.00,NULL,NULL,1,'2023-06-23 14:54:57','2023-06-23 14:54:57',NULL),(3575,7525,41184,28769,3,2654,'App\\Models\\Receipt',2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',45923.89,NULL,NULL,1,'2023-06-23 14:54:57','2023-06-23 14:54:57',NULL),(3576,7525,41184,28769,3,2655,'App\\Models\\Receipt',2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',1394173.30,NULL,NULL,1,'2023-06-23 14:54:57','2023-07-01 20:26:43','2023-07-01 20:26:43'),(3577,7525,41184,28769,3,2656,'App\\Models\\Receipt',2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',22320.00,NULL,NULL,1,'2023-06-23 14:54:57','2023-06-23 14:54:57',NULL),(3578,7525,41184,28769,3,2657,'App\\Models\\Receipt',2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',8389.83,NULL,NULL,1,'2023-06-23 14:54:57','2023-07-01 20:25:47','2023-07-01 20:25:47'),(3579,7525,41184,28769,3,2658,'App\\Models\\Receipt',2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',527802.00,NULL,NULL,1,'2023-06-23 14:54:58','2023-06-23 14:54:58',NULL),(3580,7525,41184,28769,3,2659,'App\\Models\\Receipt',2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',172485.50,NULL,NULL,1,'2023-06-23 14:54:58','2023-06-23 14:54:58',NULL),(3581,8694,40839,12133,2,2660,'App\\Models\\Receipt',2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',332750.00,NULL,NULL,1,'2023-06-24 19:36:58','2023-06-24 19:40:21','2023-06-24 19:40:21');
INSERT INTO `balance_libro` VALUES (3582,8694,40839,12133,2,2661,'App\\Models\\Receipt',2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',23838.21,NULL,NULL,1,'2023-06-24 19:36:58','2023-06-24 19:41:11','2023-06-24 19:41:11'),(3583,8694,40839,12133,3,2662,'App\\Models\\Receipt',2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',6650.00,NULL,NULL,1,'2023-06-24 19:37:22','2023-06-24 20:16:47','2023-06-24 20:16:47'),(3584,8694,40839,12133,3,2663,'App\\Models\\Receipt',2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',6650.00,NULL,NULL,1,'2023-06-24 19:37:22','2023-06-24 19:37:22',NULL),(3585,8694,40839,12133,3,2664,'App\\Models\\Receipt',2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',6650.00,NULL,NULL,1,'2023-06-24 19:37:22','2023-06-24 20:17:38','2023-06-24 20:17:38'),(3586,8694,40839,12133,3,2665,'App\\Models\\Receipt',2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',1175.57,NULL,NULL,1,'2023-06-24 19:37:22','2023-06-24 19:54:41','2023-06-24 19:54:41'),(3587,8694,40839,12133,3,2666,'App\\Models\\Receipt',2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',299.00,NULL,NULL,1,'2023-06-24 19:37:22','2023-06-24 19:55:12','2023-06-24 19:55:12'),(3588,8694,40839,12133,3,2667,'App\\Models\\Receipt',2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',29783.22,NULL,NULL,1,'2023-06-24 19:37:22','2023-06-24 19:55:44','2023-06-24 19:55:44'),(3589,8694,40839,12133,3,2668,'App\\Models\\Receipt',2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',0.03,NULL,NULL,1,'2023-06-24 19:37:22','2023-06-24 20:21:07','2023-06-24 20:21:07'),(3590,8694,40839,12133,3,2669,'App\\Models\\Receipt',2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',527.58,NULL,NULL,1,'2023-06-24 19:37:22','2023-06-24 19:37:22',NULL),(3591,8694,40839,12133,3,2670,'App\\Models\\Receipt',2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',25941.90,NULL,NULL,1,'2023-06-24 19:37:22','2023-06-24 20:41:29','2023-06-24 20:41:29'),(3592,8694,40839,12133,3,2671,'App\\Models\\Receipt',2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',25200.00,NULL,NULL,1,'2023-06-24 19:37:22','2023-06-24 19:59:53','2023-06-24 19:59:53'),(3593,8694,40839,12133,3,2672,'App\\Models\\Receipt',2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',12195.80,NULL,NULL,1,'2023-06-24 19:37:22','2023-06-24 20:45:33','2023-06-24 20:45:33'),(3594,8694,40839,12133,3,2673,'App\\Models\\Receipt',2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',8000.00,NULL,NULL,1,'2023-06-24 19:37:22','2023-06-24 20:49:19','2023-06-24 20:49:19'),(3595,8694,40839,12133,3,2674,'App\\Models\\Receipt',2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',3490.10,NULL,NULL,1,'2023-06-24 19:37:22','2023-06-24 20:01:05','2023-06-24 20:01:05'),(3596,8694,40839,12133,3,2675,'App\\Models\\Receipt',2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',6078.30,NULL,NULL,1,'2023-06-24 19:37:23','2023-06-24 19:57:16','2023-06-24 19:57:16'),(3597,8694,40839,12133,3,2676,'App\\Models\\Receipt',2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',11340.35,NULL,NULL,1,'2023-06-24 19:37:23','2023-06-24 20:14:04','2023-06-24 20:14:04'),(3598,8694,40839,12133,3,2677,'App\\Models\\Receipt',2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',698.98,NULL,NULL,1,'2023-06-24 19:37:23','2023-06-24 19:37:23',NULL),(3599,8694,40839,12133,3,2678,'App\\Models\\Receipt',2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',1904.51,NULL,NULL,1,'2023-06-24 19:37:23','2023-06-24 19:57:35','2023-06-24 19:57:35'),(3600,8694,40839,12133,3,2679,'App\\Models\\Receipt',2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',20.00,NULL,NULL,1,'2023-06-24 19:37:23','2023-06-24 19:57:48','2023-06-24 19:57:48');
INSERT INTO `balance_libro` VALUES (3601,8694,40839,12133,3,2680,'App\\Models\\Receipt',2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',120.00,NULL,NULL,1,'2023-06-24 19:37:23','2023-06-24 19:58:02','2023-06-24 19:58:02'),(3602,8694,40839,12133,3,2681,'App\\Models\\Receipt',2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',35734.06,NULL,NULL,1,'2023-06-24 19:37:23','2023-06-24 20:48:06','2023-06-24 20:48:06'),(3603,8694,40839,12133,3,2682,'App\\Models\\Receipt',2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',42700.07,NULL,NULL,1,'2023-06-24 19:37:23','2023-06-24 20:24:46','2023-06-24 20:24:46'),(3604,8694,40839,12133,3,2683,'App\\Models\\Receipt',2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',3285.00,NULL,NULL,1,'2023-06-24 19:37:23','2023-06-24 19:58:14','2023-06-24 19:58:14'),(3605,8694,40839,12133,2,2660,'App\\Models\\Receipt',2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',332750.00,NULL,NULL,1,'2023-06-24 19:40:21','2023-06-27 14:19:21','2023-06-27 14:19:21'),(3606,8694,40839,12133,2,2661,'App\\Models\\Receipt',2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',23838.21,NULL,NULL,1,'2023-06-24 19:41:11','2023-06-27 14:19:21','2023-06-27 14:19:21'),(3607,8694,40839,12133,3,2671,'App\\Models\\Receipt',2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',25200.00,NULL,NULL,1,'2023-06-24 19:59:53','2023-06-24 19:59:53',NULL),(3608,8694,40839,12133,3,2674,'App\\Models\\Receipt',2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',3490.10,NULL,NULL,1,'2023-06-24 20:01:05','2023-06-24 20:01:05',NULL),(3609,8694,40839,12133,3,2676,'App\\Models\\Receipt',2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',11340.35,NULL,NULL,1,'2023-06-24 20:14:04','2023-06-24 20:14:04',NULL),(3610,8694,40839,12133,3,2662,'App\\Models\\Receipt',2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',6650.00,NULL,NULL,1,'2023-06-24 20:16:47','2023-06-24 20:16:47',NULL),(3611,8694,40839,12133,3,2664,'App\\Models\\Receipt',2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',6650.00,NULL,NULL,1,'2023-06-24 20:17:38','2023-06-24 20:17:38',NULL),(3612,8694,40839,12133,3,2668,'App\\Models\\Receipt',2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',0.03,NULL,NULL,1,'2023-06-24 20:21:07','2023-06-24 20:21:07',NULL),(3613,8694,40839,12133,3,2682,'App\\Models\\Receipt',2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',42700.07,NULL,NULL,1,'2023-06-24 20:24:46','2023-06-24 20:24:46',NULL),(3614,8694,40839,12133,3,2684,'App\\Models\\Receipt',2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-28','2023-05-28',16250.01,NULL,NULL,1,'2023-06-24 20:28:44','2023-06-24 20:28:44',NULL),(3615,8694,40839,12133,3,2670,'App\\Models\\Receipt',2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',25941.90,NULL,NULL,1,'2023-06-24 20:41:29','2023-06-24 20:41:29',NULL),(3616,8694,40839,12133,3,2672,'App\\Models\\Receipt',2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',12195.80,NULL,NULL,1,'2023-06-24 20:45:33','2023-06-24 20:45:33',NULL),(3617,8694,40839,12133,3,2681,'App\\Models\\Receipt',2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',35734.06,NULL,NULL,1,'2023-06-24 20:48:06','2023-06-24 20:48:06',NULL),(3618,8694,40839,12133,3,2673,'App\\Models\\Receipt',2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',8000.00,NULL,NULL,1,'2023-06-24 20:49:19','2023-06-24 20:49:19',NULL),(3619,8694,40839,12133,3,2685,'App\\Models\\Receipt',2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',9701.55,NULL,NULL,1,'2023-06-24 21:18:01','2023-06-24 21:18:01',NULL),(3620,8694,40839,12133,3,2686,'App\\Models\\Receipt',2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',68827.01,NULL,NULL,1,'2023-06-24 21:22:24','2023-06-24 21:22:24',NULL);
INSERT INTO `balance_libro` VALUES (3621,8694,40839,12133,3,2687,'App\\Models\\Receipt',2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',7819.71,NULL,NULL,1,'2023-06-24 21:25:50','2023-06-24 21:25:50',NULL),(3622,8694,40839,12133,3,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',11399.44,NULL,NULL,1,'2023-06-24 21:34:19','2023-06-24 21:34:19',NULL),(3623,8694,40839,12133,3,2689,'App\\Models\\Receipt',2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',7610.51,NULL,NULL,1,'2023-06-24 21:36:35','2023-06-24 21:36:35',NULL),(3624,8694,40839,12133,3,2690,'App\\Models\\Receipt',2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',10500.53,NULL,NULL,1,'2023-06-24 21:39:13','2023-06-24 21:39:13',NULL),(3625,8694,40839,12133,3,2691,'App\\Models\\Receipt',2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',11780.87,NULL,NULL,1,'2023-06-24 21:41:20','2023-06-24 21:41:20',NULL),(3626,8694,40849,13648,3,2692,'App\\Models\\Receipt',2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',5067.43,NULL,NULL,1,'2023-06-24 21:51:45','2023-06-24 22:39:28','2023-06-24 22:39:28'),(3627,8694,40849,13648,3,2693,'App\\Models\\Receipt',2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',4054.19,NULL,NULL,1,'2023-06-24 21:51:45','2023-06-24 22:41:32','2023-06-24 22:41:32'),(3628,8694,40849,13648,3,2694,'App\\Models\\Receipt',2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',76.46,NULL,NULL,1,'2023-06-24 21:51:45','2023-06-24 21:51:45',NULL),(3629,8694,40849,13648,3,2695,'App\\Models\\Receipt',2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',76.46,NULL,NULL,1,'2023-06-24 21:51:45','2023-06-24 21:51:45',NULL),(3630,8694,40849,13648,3,2696,'App\\Models\\Receipt',2696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',36567.20,NULL,NULL,1,'2023-06-24 21:51:45','2023-06-24 21:51:45',NULL),(3631,8694,40849,13648,3,2697,'App\\Models\\Receipt',2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',8406.27,NULL,NULL,1,'2023-06-24 21:51:45','2023-06-24 22:51:57','2023-06-24 22:51:57'),(3632,8694,40849,13648,3,2698,'App\\Models\\Receipt',2698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',66.78,NULL,NULL,1,'2023-06-24 21:51:45','2023-06-24 21:51:45',NULL),(3633,8694,40849,13648,3,2699,'App\\Models\\Receipt',2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',10406.29,NULL,NULL,1,'2023-06-24 21:51:45','2023-06-24 22:14:59','2023-06-24 22:14:59'),(3634,8694,40849,13648,3,2700,'App\\Models\\Receipt',2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',4053.94,NULL,NULL,1,'2023-06-24 21:51:45','2023-06-24 22:42:33','2023-06-24 22:42:33'),(3635,8694,40849,13648,3,2701,'App\\Models\\Receipt',2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',41584.05,NULL,NULL,1,'2023-06-24 21:51:45','2023-06-24 22:54:53','2023-06-24 22:54:53'),(3636,8694,40849,13648,3,2702,'App\\Models\\Receipt',2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',95936.42,NULL,NULL,1,'2023-06-24 21:51:45','2023-06-24 22:16:38','2023-06-24 22:16:38'),(3637,8694,40849,13648,3,2703,'App\\Models\\Receipt',2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',8000.00,NULL,NULL,1,'2023-06-24 21:51:45','2023-06-24 22:15:29','2023-06-24 22:15:29'),(3638,8694,40849,13648,3,2704,'App\\Models\\Receipt',2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',5604.54,NULL,NULL,1,'2023-06-24 21:51:45','2023-06-24 22:57:06','2023-06-24 22:57:06'),(3639,8694,40849,13648,3,2705,'App\\Models\\Receipt',2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',7030.29,NULL,NULL,1,'2023-06-24 21:51:45','2023-06-24 22:17:45','2023-06-24 22:17:45'),(3640,8694,40849,13648,3,2706,'App\\Models\\Receipt',2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',97770.30,NULL,NULL,1,'2023-06-24 21:51:45','2023-06-24 22:18:27','2023-06-24 22:18:27');
INSERT INTO `balance_libro` VALUES (3641,8694,40849,13648,3,2707,'App\\Models\\Receipt',2707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',95482.31,NULL,NULL,1,'2023-06-24 21:51:45','2023-06-24 22:20:59','2023-06-24 22:20:59'),(3642,8694,40849,13648,3,2708,'App\\Models\\Receipt',2708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',14645.68,NULL,NULL,1,'2023-06-24 21:51:45','2023-06-25 00:18:37','2023-06-25 00:18:37'),(3643,8694,40849,13648,3,2709,'App\\Models\\Receipt',2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',10507.22,NULL,NULL,1,'2023-06-24 21:51:46','2023-06-24 22:20:03','2023-06-24 22:20:03'),(3644,8694,40849,13648,3,2710,'App\\Models\\Receipt',2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',13887.76,NULL,NULL,1,'2023-06-24 21:51:46','2023-06-24 22:43:48','2023-06-24 22:43:48'),(3645,8694,40849,13648,3,2711,'App\\Models\\Receipt',2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',4840.00,NULL,NULL,1,'2023-06-24 21:51:46','2023-06-24 22:21:52','2023-06-24 22:21:52'),(3646,8694,40849,13648,3,2712,'App\\Models\\Receipt',2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',13672.65,NULL,NULL,1,'2023-06-24 21:51:46','2023-06-25 00:20:38','2023-06-25 00:20:38'),(3647,8694,40849,13648,3,2713,'App\\Models\\Receipt',2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',23072.68,NULL,NULL,1,'2023-06-24 21:51:46','2023-06-24 22:22:55','2023-06-24 22:22:55'),(3648,8694,40849,13648,3,2714,'App\\Models\\Receipt',2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',18551.01,NULL,NULL,1,'2023-06-24 21:51:46','2023-06-27 14:14:34','2023-06-27 14:14:34'),(3649,8694,40849,13648,3,2715,'App\\Models\\Receipt',2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',16567.66,NULL,NULL,1,'2023-06-24 21:51:46','2023-06-25 00:21:59','2023-06-25 00:21:59'),(3650,8694,40849,13648,3,2716,'App\\Models\\Receipt',2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',10009.12,NULL,NULL,1,'2023-06-24 21:51:46','2023-06-24 22:24:10','2023-06-24 22:24:10'),(3651,8694,40849,13648,3,2717,'App\\Models\\Receipt',2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',96683.84,NULL,NULL,1,'2023-06-24 21:51:46','2023-06-24 22:25:16','2023-06-24 22:25:16'),(3652,8694,40849,13648,3,2718,'App\\Models\\Receipt',2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',97135.05,NULL,NULL,1,'2023-06-24 21:51:46','2023-06-24 22:27:24','2023-06-24 22:27:24'),(3653,8694,40849,13648,3,2719,'App\\Models\\Receipt',2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',400050.00,NULL,NULL,1,'2023-06-24 21:51:46','2023-06-24 21:51:46',NULL),(3654,8694,40849,13648,3,2720,'App\\Models\\Receipt',2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',7093.64,NULL,NULL,1,'2023-06-24 21:51:46','2023-06-24 22:26:30','2023-06-24 22:26:30'),(3655,8694,40849,13648,3,2721,'App\\Models\\Receipt',2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',96484.19,NULL,NULL,1,'2023-06-24 21:51:46','2023-06-24 22:28:10','2023-06-24 22:28:10'),(3656,8694,40849,13648,3,2722,'App\\Models\\Receipt',2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',36349.88,NULL,NULL,1,'2023-06-24 21:51:46','2023-06-25 00:23:39','2023-06-25 00:23:39'),(3657,8694,40849,13648,3,2723,'App\\Models\\Receipt',2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',7865.00,NULL,NULL,1,'2023-06-24 21:51:46','2023-06-24 22:29:16','2023-06-24 22:29:16'),(3658,8694,40849,13648,3,2724,'App\\Models\\Receipt',2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',301895.00,NULL,NULL,1,'2023-06-24 21:51:46','2023-06-24 22:30:08','2023-06-24 22:30:08'),(3659,8694,40849,13648,3,2725,'App\\Models\\Receipt',2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',156695.00,NULL,NULL,1,'2023-06-24 21:51:46','2023-06-24 21:51:46',NULL);
INSERT INTO `balance_libro` VALUES (3660,8694,40849,13648,3,2726,'App\\Models\\Receipt',2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',99643.50,NULL,NULL,1,'2023-06-24 21:51:46','2023-06-24 22:32:26','2023-06-24 22:32:26'),(3661,8694,40849,13648,3,2727,'App\\Models\\Receipt',2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',183496.50,NULL,NULL,1,'2023-06-24 21:51:46','2023-06-24 22:31:44','2023-06-24 22:31:44'),(3662,8694,40849,13648,3,2728,'App\\Models\\Receipt',2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',4197.39,NULL,NULL,1,'2023-06-24 22:11:07','2023-06-24 22:11:07',NULL),(3663,8694,40849,13648,3,2729,'App\\Models\\Receipt',2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',12288.95,NULL,NULL,1,'2023-06-24 22:13:02','2023-06-24 22:13:02',NULL),(3664,8694,40849,13648,3,2699,'App\\Models\\Receipt',2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',10406.30,NULL,NULL,1,'2023-06-24 22:14:59','2023-06-24 22:14:59',NULL),(3665,8694,40849,13648,3,2703,'App\\Models\\Receipt',2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',8000.00,NULL,NULL,1,'2023-06-24 22:15:29','2023-06-24 22:15:29',NULL),(3666,8694,40849,13648,3,2702,'App\\Models\\Receipt',2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',95936.42,NULL,NULL,1,'2023-06-24 22:16:38','2023-06-24 22:16:38',NULL),(3667,8694,40849,13648,3,2705,'App\\Models\\Receipt',2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',7030.30,NULL,NULL,1,'2023-06-24 22:17:45','2023-06-24 22:17:45',NULL),(3668,8694,40849,13648,3,2706,'App\\Models\\Receipt',2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',97770.30,NULL,NULL,1,'2023-06-24 22:18:27','2023-06-24 22:18:27',NULL),(3669,8694,40849,13648,3,2709,'App\\Models\\Receipt',2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',10507.22,NULL,NULL,1,'2023-06-24 22:20:03','2023-06-24 22:20:03',NULL),(3670,8694,40849,13648,3,2707,'App\\Models\\Receipt',2707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',95482.31,NULL,NULL,1,'2023-06-24 22:20:59','2023-06-24 22:20:59',NULL),(3671,8694,40849,13648,3,2711,'App\\Models\\Receipt',2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',4840.00,NULL,NULL,1,'2023-06-24 22:21:52','2023-06-24 22:21:52',NULL),(3672,8694,40849,13648,3,2713,'App\\Models\\Receipt',2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',23072.68,NULL,NULL,1,'2023-06-24 22:22:55','2023-06-24 22:22:55',NULL),(3673,8694,40849,13648,3,2716,'App\\Models\\Receipt',2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',10009.11,NULL,NULL,1,'2023-06-24 22:24:10','2023-06-24 22:24:10',NULL),(3674,8694,40849,13648,3,2717,'App\\Models\\Receipt',2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',96683.84,NULL,NULL,1,'2023-06-24 22:25:16','2023-06-24 22:25:16',NULL),(3675,8694,40849,13648,3,2720,'App\\Models\\Receipt',2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',7093.64,NULL,NULL,1,'2023-06-24 22:26:30','2023-06-24 22:26:30',NULL),(3676,8694,40849,13648,3,2718,'App\\Models\\Receipt',2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',97135.05,NULL,NULL,1,'2023-06-24 22:27:24','2023-06-24 22:27:24',NULL),(3677,8694,40849,13648,3,2721,'App\\Models\\Receipt',2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',96484.19,NULL,NULL,1,'2023-06-24 22:28:10','2023-06-24 22:28:10',NULL),(3678,8694,40849,13648,3,2723,'App\\Models\\Receipt',2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',7864.99,NULL,NULL,1,'2023-06-24 22:29:16','2023-06-24 22:29:16',NULL),(3679,8694,40849,13648,3,2724,'App\\Models\\Receipt',2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',301895.00,NULL,NULL,1,'2023-06-24 22:30:08','2023-06-24 22:30:08',NULL);
INSERT INTO `balance_libro` VALUES (3680,8694,40849,13648,3,2727,'App\\Models\\Receipt',2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',183496.50,NULL,NULL,1,'2023-06-24 22:31:44','2023-06-24 22:31:44',NULL),(3681,8694,40849,13648,3,2726,'App\\Models\\Receipt',2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',99643.50,NULL,NULL,1,'2023-06-24 22:32:26','2023-06-24 22:32:26',NULL),(3682,8694,40849,13648,3,2692,'App\\Models\\Receipt',2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',5067.43,NULL,NULL,1,'2023-06-24 22:39:28','2023-06-24 22:39:28',NULL),(3683,8694,40849,13648,3,2693,'App\\Models\\Receipt',2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',4054.19,NULL,NULL,1,'2023-06-24 22:41:32','2023-06-24 22:41:32',NULL),(3684,8694,40849,13648,3,2700,'App\\Models\\Receipt',2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',4053.94,NULL,NULL,1,'2023-06-24 22:42:33','2023-06-24 22:42:33',NULL),(3685,8694,40849,13648,3,2710,'App\\Models\\Receipt',2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',13887.76,NULL,NULL,1,'2023-06-24 22:43:48','2023-06-24 22:43:48',NULL),(3686,8694,40849,13648,3,2697,'App\\Models\\Receipt',2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',8406.27,NULL,NULL,1,'2023-06-24 22:51:57','2023-06-24 22:51:57',NULL),(3687,8694,40849,13648,3,2701,'App\\Models\\Receipt',2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',41584.05,NULL,NULL,1,'2023-06-24 22:54:53','2023-06-24 22:54:53',NULL),(3688,8694,40849,13648,3,2704,'App\\Models\\Receipt',2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',5604.54,NULL,NULL,1,'2023-06-24 22:57:06','2023-06-24 22:57:06',NULL),(3689,8694,40849,13648,3,2708,'App\\Models\\Receipt',2708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',14645.68,NULL,NULL,1,'2023-06-25 00:18:37','2023-06-25 00:18:37',NULL),(3690,8694,40849,13648,3,2712,'App\\Models\\Receipt',2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',13672.65,NULL,NULL,1,'2023-06-25 00:20:38','2023-06-25 00:20:38',NULL),(3691,8694,40849,13648,3,2715,'App\\Models\\Receipt',2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',16567.66,NULL,NULL,1,'2023-06-25 00:21:59','2023-06-25 00:21:59',NULL),(3692,8694,40849,13648,3,2722,'App\\Models\\Receipt',2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',36349.88,NULL,NULL,1,'2023-06-25 00:23:39','2023-06-25 00:23:39',NULL),(3693,8694,40856,15160,2,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',107293.12,NULL,NULL,1,'2023-06-25 01:23:14','2023-06-25 01:25:22','2023-06-25 01:25:22'),(3694,8694,40856,15160,2,2731,'App\\Models\\Receipt',2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',223218.38,NULL,NULL,1,'2023-06-25 01:23:14','2023-06-25 01:25:57','2023-06-25 01:25:57'),(3695,8694,40856,15160,3,2732,'App\\Models\\Receipt',2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',5799.99,NULL,NULL,1,'2023-06-25 01:23:28','2023-06-25 01:59:50','2023-06-25 01:59:50'),(3696,8694,40856,15160,3,2733,'App\\Models\\Receipt',2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',30787.68,NULL,NULL,1,'2023-06-25 01:23:28','2023-06-25 01:57:00','2023-06-25 01:57:00'),(3697,8694,40856,15160,3,2734,'App\\Models\\Receipt',2734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',136.00,NULL,NULL,1,'2023-06-25 01:23:28','2023-06-27 15:49:17','2023-06-27 15:49:17'),(3698,8694,40856,15160,3,2735,'App\\Models\\Receipt',2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',13857.03,NULL,NULL,1,'2023-06-25 01:23:28','2023-06-25 01:58:20','2023-06-25 01:58:20'),(3699,8694,40856,15160,3,2736,'App\\Models\\Receipt',2736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',231.00,NULL,NULL,1,'2023-06-25 01:23:28','2023-06-27 15:49:57','2023-06-27 15:49:57');
INSERT INTO `balance_libro` VALUES (3700,8694,40856,15160,3,2737,'App\\Models\\Receipt',2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',1412999.99,NULL,NULL,1,'2023-06-25 01:23:28','2023-06-25 01:55:49','2023-06-25 01:55:49'),(3701,8694,40856,15160,3,2738,'App\\Models\\Receipt',2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',9000.00,NULL,NULL,1,'2023-06-25 01:23:28','2023-06-25 02:00:27','2023-06-25 02:00:27'),(3702,8694,40856,15160,3,2739,'App\\Models\\Receipt',2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',440000.00,NULL,NULL,1,'2023-06-25 01:23:28','2023-06-25 01:55:10','2023-06-25 01:55:10'),(3703,8694,40856,15160,3,2740,'App\\Models\\Receipt',2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',3000.10,NULL,NULL,1,'2023-06-25 01:23:28','2023-06-27 15:50:58','2023-06-27 15:50:58'),(3704,8694,40856,15160,3,2741,'App\\Models\\Receipt',2741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',427.76,NULL,NULL,1,'2023-06-25 01:23:28','2023-06-27 15:51:26','2023-06-27 15:51:26'),(3705,8694,40856,15160,3,2742,'App\\Models\\Receipt',2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',790.66,NULL,NULL,1,'2023-06-25 01:23:28','2023-06-27 15:50:24','2023-06-27 15:50:24'),(3706,8694,40856,15160,3,2743,'App\\Models\\Receipt',2743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',672.28,NULL,NULL,1,'2023-06-25 01:23:29','2023-06-27 15:50:34','2023-06-27 15:50:34'),(3707,8694,40856,15160,3,2744,'App\\Models\\Receipt',2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',200000.00,NULL,NULL,1,'2023-06-25 01:23:29','2023-06-25 01:54:04','2023-06-25 01:54:04'),(3708,8694,40856,15160,3,2745,'App\\Models\\Receipt',2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',27424.90,NULL,NULL,1,'2023-06-25 01:23:29','2023-06-25 01:37:55','2023-06-25 01:37:55'),(3709,8694,40856,15160,3,2746,'App\\Models\\Receipt',2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',0.00,NULL,NULL,1,'2023-06-25 01:23:29','2023-06-27 15:51:55','2023-06-27 15:51:55'),(3710,8694,40856,15160,3,2747,'App\\Models\\Receipt',2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',1262.00,NULL,NULL,1,'2023-06-25 01:23:29','2023-06-27 15:51:41','2023-06-27 15:51:41'),(3711,8694,40856,15160,3,2748,'App\\Models\\Receipt',2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',9176.64,NULL,NULL,1,'2023-06-25 01:23:29','2023-06-27 15:52:30','2023-06-27 15:52:30'),(3712,8694,40856,15160,3,2749,'App\\Models\\Receipt',2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',150.00,NULL,NULL,1,'2023-06-25 01:23:29','2023-06-27 15:52:53','2023-06-27 15:52:53'),(3713,8694,40856,15160,3,2750,'App\\Models\\Receipt',2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',75804.93,NULL,NULL,1,'2023-06-25 01:23:29','2023-06-27 15:56:31','2023-06-27 15:56:31'),(3714,8694,40856,15160,3,2751,'App\\Models\\Receipt',2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',14719.00,NULL,NULL,1,'2023-06-25 01:23:29','2023-06-27 15:56:43','2023-06-27 15:56:43'),(3715,8694,40856,15160,3,2752,'App\\Models\\Receipt',2752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',80.00,NULL,NULL,1,'2023-06-25 01:23:29','2023-06-27 15:50:47','2023-06-27 15:50:47'),(3716,8694,40856,15160,2,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',107293.12,NULL,NULL,1,'2023-06-25 01:25:22','2023-06-25 01:25:22',NULL),(3717,8694,40856,15160,2,2731,'App\\Models\\Receipt',2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',223218.38,NULL,NULL,1,'2023-06-25 01:25:57','2023-06-25 01:25:57',NULL),(3718,8694,40856,15160,3,2745,'App\\Models\\Receipt',2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',27424.90,NULL,NULL,1,'2023-06-25 01:37:55','2023-06-25 01:37:55',NULL);
INSERT INTO `balance_libro` VALUES (3719,8694,40856,15160,3,2753,'App\\Models\\Receipt',2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',9934.44,NULL,NULL,1,'2023-06-25 01:53:12','2023-06-25 01:53:12',NULL),(3720,8694,40856,15160,3,2744,'App\\Models\\Receipt',2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',200000.00,NULL,NULL,1,'2023-06-25 01:54:04','2023-06-25 01:54:04',NULL),(3721,8694,40856,15160,3,2739,'App\\Models\\Receipt',2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',440000.00,NULL,NULL,1,'2023-06-25 01:55:10','2023-06-25 01:55:10',NULL),(3722,8694,40856,15160,3,2737,'App\\Models\\Receipt',2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',1412999.99,NULL,NULL,1,'2023-06-25 01:55:49','2023-06-25 01:55:49',NULL),(3723,8694,40856,15160,3,2733,'App\\Models\\Receipt',2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',30787.68,NULL,NULL,1,'2023-06-25 01:57:00','2023-06-25 01:57:00',NULL),(3724,8694,40856,15160,3,2735,'App\\Models\\Receipt',2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',13857.03,NULL,NULL,1,'2023-06-25 01:58:20','2023-06-25 01:58:20',NULL),(3725,8694,40856,15160,3,2732,'App\\Models\\Receipt',2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',5800.00,NULL,NULL,1,'2023-06-25 01:59:50','2023-06-25 01:59:50',NULL),(3726,8694,40856,15160,3,2738,'App\\Models\\Receipt',2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',9000.00,NULL,NULL,1,'2023-06-25 02:00:27','2023-06-25 02:00:27',NULL),(3727,8694,40856,15160,3,2754,'App\\Models\\Receipt',2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',30095.89,NULL,NULL,1,'2023-06-25 02:05:31','2023-06-25 02:05:31',NULL),(3728,8694,40856,15160,3,2755,'App\\Models\\Receipt',2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',56620.51,NULL,NULL,1,'2023-06-25 02:18:43','2023-06-25 02:18:43',NULL),(3729,8694,40875,16672,2,2756,'App\\Models\\Receipt',2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',10500.00,NULL,NULL,1,'2023-06-25 18:38:57','2023-06-25 18:44:03','2023-06-25 18:44:03'),(3730,8694,40875,16672,2,2757,'App\\Models\\Receipt',2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',4800.00,NULL,NULL,1,'2023-06-25 18:38:57','2023-06-25 18:45:18','2023-06-25 18:45:18'),(3731,8694,40875,16672,2,2758,'App\\Models\\Receipt',2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',14060.52,NULL,NULL,1,'2023-06-25 18:38:57','2023-06-25 18:45:51','2023-06-25 18:45:51'),(3732,8694,40875,16672,2,2759,'App\\Models\\Receipt',2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',17575.65,NULL,NULL,1,'2023-06-25 18:38:57','2023-06-25 18:46:17','2023-06-25 18:46:17'),(3733,8694,40875,16672,2,2760,'App\\Models\\Receipt',2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',28121.04,NULL,NULL,1,'2023-06-25 18:38:57','2023-06-25 18:46:44','2023-06-25 18:46:44'),(3734,8694,40875,16672,2,2761,'App\\Models\\Receipt',2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',99600.00,NULL,NULL,1,'2023-06-25 18:38:57','2023-06-25 18:49:07','2023-06-25 18:49:07'),(3735,8694,40875,16672,2,2762,'App\\Models\\Receipt',2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',382470.00,NULL,NULL,1,'2023-06-25 18:38:57','2023-06-25 18:49:37','2023-06-25 18:49:37'),(3736,8694,40875,16672,2,2763,'App\\Models\\Receipt',2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',13500.00,NULL,NULL,1,'2023-06-25 18:38:57','2023-06-25 18:47:22','2023-06-25 18:47:22'),(3737,8694,40875,16672,2,2764,'App\\Models\\Receipt',2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',500626.00,NULL,NULL,1,'2023-06-25 18:38:57','2023-06-25 18:50:18','2023-06-25 18:50:18'),(3738,8694,40875,16672,2,2765,'App\\Models\\Receipt',2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',19425.00,NULL,NULL,1,'2023-06-25 18:38:57','2023-06-25 18:47:44','2023-06-25 18:47:44');
INSERT INTO `balance_libro` VALUES (3739,8694,40875,16672,2,2766,'App\\Models\\Receipt',2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',378100.00,NULL,NULL,1,'2023-06-25 18:38:58','2023-06-25 18:50:51','2023-06-25 18:50:51'),(3740,8694,40875,16672,3,2767,'App\\Models\\Receipt',2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',6360.00,NULL,NULL,1,'2023-06-25 18:39:17','2023-06-25 20:23:29','2023-06-25 20:23:29'),(3741,8694,40875,16672,3,2768,'App\\Models\\Receipt',2768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',181.45,NULL,NULL,1,'2023-06-25 18:39:17','2023-06-28 20:46:29','2023-06-28 20:46:29'),(3742,8694,40875,16672,3,2769,'App\\Models\\Receipt',2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',95.00,NULL,NULL,1,'2023-06-25 18:39:17','2023-06-28 20:48:42','2023-06-28 20:48:42'),(3743,8694,40875,16672,3,2770,'App\\Models\\Receipt',2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',51.00,NULL,NULL,1,'2023-06-25 18:39:17','2023-06-28 20:46:40','2023-06-28 20:46:40'),(3744,8694,40875,16672,3,2771,'App\\Models\\Receipt',2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',10118.80,NULL,NULL,1,'2023-06-25 18:39:17','2023-06-25 18:39:17',NULL),(3745,8694,40875,16672,3,2772,'App\\Models\\Receipt',2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',19000.00,NULL,NULL,1,'2023-06-25 18:39:17','2023-06-25 18:39:17',NULL),(3746,8694,40875,16672,3,2773,'App\\Models\\Receipt',2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',40270.00,NULL,NULL,1,'2023-06-25 18:39:17','2023-06-25 18:39:17',NULL),(3747,8694,40875,16672,3,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',73760.00,NULL,NULL,1,'2023-06-25 18:39:17','2023-06-25 18:39:17',NULL),(3748,8694,40875,16672,3,2775,'App\\Models\\Receipt',2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',6420.00,NULL,NULL,1,'2023-06-25 18:39:17','2023-06-25 20:24:21','2023-06-25 20:24:21'),(3749,8694,40875,16672,3,2776,'App\\Models\\Receipt',2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',7500.00,NULL,NULL,1,'2023-06-25 18:39:17','2023-06-25 19:10:59','2023-06-25 19:10:59'),(3750,8694,40875,16672,3,2777,'App\\Models\\Receipt',2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',16854.29,NULL,NULL,1,'2023-06-25 18:39:17','2023-06-25 19:12:46','2023-06-25 19:12:46'),(3751,8694,40875,16672,3,2778,'App\\Models\\Receipt',2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',180590.91,NULL,NULL,1,'2023-06-25 18:39:17','2023-06-25 19:15:38','2023-06-25 19:15:38'),(3752,8694,40875,16672,3,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',6204.49,NULL,NULL,1,'2023-06-25 18:39:17','2023-06-25 19:03:23','2023-06-25 19:03:23'),(3753,8694,40875,16672,3,2780,'App\\Models\\Receipt',2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',3675.98,NULL,NULL,1,'2023-06-25 18:39:17','2023-06-28 20:50:10','2023-06-28 20:50:10'),(3754,8694,40875,16672,3,2781,'App\\Models\\Receipt',2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',3909.49,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-25 19:04:02','2023-06-25 19:04:02'),(3755,8694,40875,16672,3,2782,'App\\Models\\Receipt',2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',11600.71,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-25 20:43:08','2023-06-25 20:43:08'),(3756,8694,40875,16672,3,2783,'App\\Models\\Receipt',2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',9769.31,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-25 19:22:44','2023-06-25 19:22:44'),(3757,8694,40875,16672,3,2784,'App\\Models\\Receipt',2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',46795.00,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-25 19:04:23','2023-06-25 19:04:23');
INSERT INTO `balance_libro` VALUES (3758,8694,40875,16672,3,2785,'App\\Models\\Receipt',2785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',431.16,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-28 20:46:49','2023-06-28 20:46:49'),(3759,8694,40875,16672,3,2786,'App\\Models\\Receipt',2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',100.00,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-28 20:46:57','2023-06-28 20:46:57'),(3760,8694,40875,16672,3,2787,'App\\Models\\Receipt',2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',8000.00,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-25 19:04:55','2023-06-25 19:04:55'),(3761,8694,40875,16672,3,2788,'App\\Models\\Receipt',2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',6204.49,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-25 19:05:55','2023-06-25 19:05:55'),(3762,8694,40875,16672,3,2789,'App\\Models\\Receipt',2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',6204.49,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-25 19:24:07','2023-06-25 19:24:07'),(3763,8694,40875,16672,3,2790,'App\\Models\\Receipt',2790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',46795.00,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-25 19:05:18','2023-06-25 19:05:18'),(3764,8694,40875,16672,3,2791,'App\\Models\\Receipt',2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',46795.00,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-25 19:24:53','2023-06-25 19:24:53'),(3765,8694,40875,16672,3,2792,'App\\Models\\Receipt',2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',6779.99,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-25 19:06:23','2023-06-25 19:06:23'),(3766,8694,40875,16672,3,2793,'App\\Models\\Receipt',2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',28595.52,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-25 19:34:25','2023-06-25 19:34:25'),(3767,8694,40875,16672,3,2794,'App\\Models\\Receipt',2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',35955.44,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-25 19:37:52','2023-06-25 19:37:52'),(3768,8694,40875,16672,3,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',34573.14,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-25 19:45:07','2023-06-25 19:45:07'),(3769,8694,40875,16672,3,2796,'App\\Models\\Receipt',2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',5400.00,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-25 19:07:50','2023-06-25 19:07:50'),(3770,8694,40875,16672,3,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',11249.98,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-25 19:08:08','2023-06-25 19:08:08'),(3771,8694,40875,16672,3,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',5000.00,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-25 20:05:14','2023-06-25 20:05:14'),(3772,8694,40875,16672,3,2799,'App\\Models\\Receipt',2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',256434.48,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-25 20:01:13','2023-06-25 20:01:13'),(3773,8694,40875,16672,3,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',10118.80,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-25 19:48:19','2023-06-25 19:48:19'),(3774,8694,40875,16672,3,2801,'App\\Models\\Receipt',2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',78008.70,NULL,NULL,1,'2023-06-25 18:39:18','2023-06-25 20:06:21','2023-06-25 20:06:21'),(3775,8694,40875,16672,3,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',18359.92,NULL,NULL,1,'2023-06-25 18:39:19','2023-06-25 20:10:01','2023-06-25 20:10:01'),(3776,8694,40875,16672,3,2803,'App\\Models\\Receipt',2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',18990.00,NULL,NULL,1,'2023-06-25 18:39:19','2023-06-25 20:11:03','2023-06-25 20:11:03');
INSERT INTO `balance_libro` VALUES (3777,8694,40875,16672,3,2804,'App\\Models\\Receipt',2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',11250.04,NULL,NULL,1,'2023-06-25 18:39:19','2023-06-25 20:07:26','2023-06-25 20:07:26'),(3778,8694,40875,16672,3,2805,'App\\Models\\Receipt',2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',29940.00,NULL,NULL,1,'2023-06-25 18:39:19','2023-06-25 20:08:48','2023-06-25 20:08:48'),(3779,8694,40875,16672,3,2806,'App\\Models\\Receipt',2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',4500.00,NULL,NULL,1,'2023-06-25 18:39:19','2023-06-25 19:08:27','2023-06-25 19:08:27'),(3780,8694,40875,16672,3,2807,'App\\Models\\Receipt',2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',31032.02,NULL,NULL,1,'2023-06-25 18:39:19','2023-06-25 19:08:51','2023-06-25 19:08:51'),(3781,8694,40875,16672,3,2808,'App\\Models\\Receipt',2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2993.99,NULL,NULL,1,'2023-06-25 18:39:19','2023-06-25 19:09:01','2023-06-25 19:09:01'),(3782,8694,40875,16672,3,2809,'App\\Models\\Receipt',2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',37000.00,NULL,NULL,1,'2023-06-25 18:39:19','2023-06-25 19:09:10','2023-06-25 19:09:10'),(3783,8694,40875,16672,3,2810,'App\\Models\\Receipt',2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',49305.45,NULL,NULL,1,'2023-06-25 18:39:19','2023-06-25 18:39:19',NULL),(3784,8694,40875,16672,3,2811,'App\\Models\\Receipt',2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',13529.17,NULL,NULL,1,'2023-06-25 18:39:19','2023-06-25 20:49:36','2023-06-25 20:49:36'),(3785,8694,40875,16672,3,2812,'App\\Models\\Receipt',2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',7077.49,NULL,NULL,1,'2023-06-25 18:39:19','2023-06-25 18:39:19',NULL),(3786,8694,40875,16672,3,2813,'App\\Models\\Receipt',2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',8077.00,NULL,NULL,1,'2023-06-25 18:39:19','2023-06-25 20:14:16','2023-06-25 20:14:16'),(3787,8694,40875,16672,3,2814,'App\\Models\\Receipt',2814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',13817.00,NULL,NULL,1,'2023-06-25 18:39:19','2023-06-25 20:15:37','2023-06-25 20:15:37'),(3788,8694,40875,16672,2,2756,'App\\Models\\Receipt',2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',10500.00,NULL,NULL,1,'2023-06-25 18:44:03','2023-06-25 18:44:03',NULL),(3789,8694,40875,16672,2,2757,'App\\Models\\Receipt',2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',4800.00,NULL,NULL,1,'2023-06-25 18:45:18','2023-06-25 18:45:18',NULL),(3790,8694,40875,16672,2,2758,'App\\Models\\Receipt',2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',14060.51,NULL,NULL,1,'2023-06-25 18:45:51','2023-06-25 18:45:51',NULL),(3791,8694,40875,16672,2,2759,'App\\Models\\Receipt',2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',17575.65,NULL,NULL,1,'2023-06-25 18:46:17','2023-06-25 18:46:17',NULL),(3792,8694,40875,16672,2,2760,'App\\Models\\Receipt',2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',28121.04,NULL,NULL,1,'2023-06-25 18:46:44','2023-06-25 18:46:44',NULL),(3793,8694,40875,16672,2,2763,'App\\Models\\Receipt',2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',13499.99,NULL,NULL,1,'2023-06-25 18:47:22','2023-06-25 18:47:22',NULL),(3794,8694,40875,16672,2,2765,'App\\Models\\Receipt',2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',19425.00,NULL,NULL,1,'2023-06-25 18:47:44','2023-06-25 18:47:44',NULL),(3795,8694,40875,16672,2,2761,'App\\Models\\Receipt',2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',99600.00,NULL,NULL,1,'2023-06-25 18:49:07','2023-06-25 18:49:07',NULL),(3796,8694,40875,16672,2,2762,'App\\Models\\Receipt',2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',382470.00,NULL,NULL,1,'2023-06-25 18:49:37','2023-06-25 18:49:37',NULL);
INSERT INTO `balance_libro` VALUES (3797,8694,40875,16672,2,2764,'App\\Models\\Receipt',2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',500625.99,NULL,NULL,1,'2023-06-25 18:50:18','2023-06-25 18:50:18',NULL),(3798,8694,40875,16672,2,2766,'App\\Models\\Receipt',2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',378099.99,NULL,NULL,1,'2023-06-25 18:50:51','2023-06-25 18:50:51',NULL),(3799,8694,40875,16672,3,2776,'App\\Models\\Receipt',2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',7500.00,NULL,NULL,1,'2023-06-25 19:10:59','2023-06-25 19:10:59',NULL),(3800,8694,40875,16672,3,2777,'App\\Models\\Receipt',2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',16854.29,NULL,NULL,1,'2023-06-25 19:12:46','2023-06-25 19:12:46',NULL),(3801,8694,40875,16672,3,2778,'App\\Models\\Receipt',2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',180590.91,NULL,NULL,1,'2023-06-25 19:15:38','2023-06-25 19:15:38',NULL),(3802,8694,40875,16672,3,2783,'App\\Models\\Receipt',2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',9769.31,NULL,NULL,1,'2023-06-25 19:22:44','2023-06-25 19:22:44',NULL),(3803,8694,40875,16672,3,2789,'App\\Models\\Receipt',2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',6204.49,NULL,NULL,1,'2023-06-25 19:24:07','2023-06-25 19:24:07',NULL),(3804,8694,40875,16672,3,2791,'App\\Models\\Receipt',2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',46795.00,NULL,NULL,1,'2023-06-25 19:24:53','2023-06-25 19:24:53',NULL),(3805,8694,40875,16672,3,2793,'App\\Models\\Receipt',2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',28595.52,NULL,NULL,1,'2023-06-25 19:34:25','2023-06-25 19:34:25',NULL),(3806,8694,40875,16672,3,2794,'App\\Models\\Receipt',2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',35955.44,NULL,NULL,1,'2023-06-25 19:37:52','2023-06-25 19:37:52',NULL),(3807,8694,40875,16672,3,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',34573.14,NULL,NULL,1,'2023-06-25 19:45:07','2023-06-25 19:45:07',NULL),(3808,8694,40875,16672,3,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',10118.80,NULL,NULL,1,'2023-06-25 19:48:19','2023-06-25 19:48:19',NULL),(3809,8694,40875,16672,3,2799,'App\\Models\\Receipt',2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',256433.36,NULL,NULL,1,'2023-06-25 20:01:13','2023-06-25 20:01:13',NULL),(3810,8694,40875,16672,3,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',5000.00,NULL,NULL,1,'2023-06-25 20:05:14','2023-06-25 20:05:14',NULL),(3811,8694,40875,16672,3,2801,'App\\Models\\Receipt',2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',78008.70,NULL,NULL,1,'2023-06-25 20:06:21','2023-06-25 20:06:21',NULL),(3812,8694,40875,16672,3,2804,'App\\Models\\Receipt',2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',11250.04,NULL,NULL,1,'2023-06-25 20:07:26','2023-06-25 20:07:26',NULL),(3813,8694,40875,16672,3,2805,'App\\Models\\Receipt',2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',29940.00,NULL,NULL,1,'2023-06-25 20:08:48','2023-06-25 20:08:48',NULL),(3814,8694,40875,16672,3,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',18359.92,NULL,NULL,1,'2023-06-25 20:10:01','2023-06-25 20:10:01',NULL),(3815,8694,40875,16672,3,2803,'App\\Models\\Receipt',2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',18989.99,NULL,NULL,1,'2023-06-25 20:11:03','2023-06-25 20:11:03',NULL),(3816,8694,40875,16672,3,2813,'App\\Models\\Receipt',2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',8077.00,NULL,NULL,1,'2023-06-25 20:14:16','2023-06-25 20:14:16',NULL),(3817,8694,40875,16672,3,2814,'App\\Models\\Receipt',2814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',13817.00,NULL,NULL,1,'2023-06-25 20:15:37','2023-06-25 20:15:37',NULL);
INSERT INTO `balance_libro` VALUES (3818,8694,40875,16672,3,2815,'App\\Models\\Receipt',2815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',13189.00,NULL,NULL,1,'2023-06-25 20:21:59','2023-06-25 20:21:59',NULL),(3819,8694,40875,16672,3,2767,'App\\Models\\Receipt',2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',6360.00,NULL,NULL,1,'2023-06-25 20:23:29','2023-06-25 20:23:29',NULL),(3820,8694,40875,16672,3,2775,'App\\Models\\Receipt',2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',6420.01,NULL,NULL,1,'2023-06-25 20:24:21','2023-06-25 20:24:21',NULL),(3821,8694,40875,16672,3,2816,'App\\Models\\Receipt',2816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',24099.00,NULL,NULL,1,'2023-06-25 20:28:34','2023-06-25 20:28:34',NULL),(3822,8694,40875,16672,3,2817,'App\\Models\\Receipt',2817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',25380.00,NULL,NULL,1,'2023-06-25 20:36:25','2023-06-25 20:36:25',NULL),(3823,8694,40875,16672,3,2818,'App\\Models\\Receipt',2818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',24121.92,NULL,NULL,1,'2023-06-25 20:41:22','2023-06-25 20:41:22',NULL),(3824,8694,40875,16672,3,2782,'App\\Models\\Receipt',2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',11600.72,NULL,NULL,1,'2023-06-25 20:43:08','2023-06-25 20:43:08',NULL),(3825,8694,40875,16672,3,2819,'App\\Models\\Receipt',2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',1679.90,NULL,NULL,1,'2023-06-25 20:46:16','2023-06-25 20:46:16',NULL),(3826,8694,40875,16672,3,2811,'App\\Models\\Receipt',2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',13529.17,NULL,NULL,1,'2023-06-25 20:49:36','2023-06-25 20:49:36',NULL),(3827,8694,41011,25753,2,2820,'App\\Models\\Receipt',2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',44100.01,NULL,NULL,1,'2023-06-25 21:20:21','2023-06-25 21:25:21','2023-06-25 21:25:21'),(3828,8694,41011,25753,2,2821,'App\\Models\\Receipt',2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',37349.88,NULL,NULL,1,'2023-06-25 21:20:21','2023-06-25 21:25:58','2023-06-25 21:25:58'),(3829,8694,41011,25753,2,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',46600.01,NULL,NULL,1,'2023-06-25 21:20:21','2023-06-25 21:26:31','2023-06-25 21:26:31'),(3830,8694,41011,25753,2,2823,'App\\Models\\Receipt',2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',46550.02,NULL,NULL,1,'2023-06-25 21:20:21','2023-06-25 21:27:10','2023-06-25 21:27:10'),(3831,8694,41011,25753,2,2824,'App\\Models\\Receipt',2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',46600.01,NULL,NULL,1,'2023-06-25 21:20:21','2023-06-25 21:28:28','2023-06-25 21:28:28'),(3832,8694,41011,25753,2,2825,'App\\Models\\Receipt',2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',46600.01,NULL,NULL,1,'2023-06-25 21:20:21','2023-06-25 21:29:50','2023-06-25 21:29:50'),(3833,8694,41011,25753,2,2826,'App\\Models\\Receipt',2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',39499.99,NULL,NULL,1,'2023-06-25 21:20:21','2023-06-25 21:30:21','2023-06-25 21:30:21'),(3834,8694,41011,25753,2,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',53250.00,NULL,NULL,1,'2023-06-25 21:20:21','2023-06-25 21:31:17','2023-06-25 21:31:17'),(3835,8694,41011,25753,2,2828,'App\\Models\\Receipt',2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',34050.00,NULL,NULL,1,'2023-06-25 21:20:21','2023-06-25 21:32:32','2023-06-25 21:32:32'),(3836,8694,41011,25753,2,2829,'App\\Models\\Receipt',2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',31950.00,NULL,NULL,1,'2023-06-25 21:20:21','2023-06-25 21:33:22','2023-06-25 21:33:22'),(3837,8694,41011,25753,2,2830,'App\\Models\\Receipt',2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',46600.00,NULL,NULL,1,'2023-06-25 21:20:21','2023-06-25 21:29:18','2023-06-25 21:29:18');
INSERT INTO `balance_libro` VALUES (3838,8694,41011,25753,2,2831,'App\\Models\\Receipt',2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',132640.20,NULL,NULL,1,'2023-06-25 21:20:22','2023-06-25 21:33:48','2023-06-25 21:33:48'),(3839,8694,41011,25753,3,2832,'App\\Models\\Receipt',2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',41990.00,NULL,NULL,1,'2023-06-25 21:20:37','2023-06-25 22:01:37','2023-06-25 22:01:37'),(3840,8694,41011,25753,3,2833,'App\\Models\\Receipt',2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',86000.00,NULL,NULL,1,'2023-06-25 21:20:37','2023-06-25 22:00:54','2023-06-25 22:00:54'),(3841,8694,41011,25753,3,2834,'App\\Models\\Receipt',2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',7829.68,NULL,NULL,1,'2023-06-25 21:20:37','2023-06-27 16:27:44','2023-06-27 16:27:44'),(3842,8694,41011,25753,3,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',7803.98,NULL,NULL,1,'2023-06-25 21:20:37','2023-06-25 23:19:02','2023-06-25 23:19:02'),(3843,8694,41011,25753,3,2836,'App\\Models\\Receipt',2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',23481.25,NULL,NULL,1,'2023-06-25 21:20:37','2023-06-25 22:02:17','2023-06-25 22:02:17'),(3844,8694,41011,25753,3,2837,'App\\Models\\Receipt',2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',32129.02,NULL,NULL,1,'2023-06-25 21:20:37','2023-06-27 16:34:53','2023-06-27 16:34:53'),(3845,8694,41011,25753,3,2838,'App\\Models\\Receipt',2838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',66999.00,NULL,NULL,1,'2023-06-25 21:20:37','2023-06-27 16:35:06','2023-06-27 16:35:06'),(3846,8694,41011,25753,3,2839,'App\\Models\\Receipt',2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',25238.20,NULL,NULL,1,'2023-06-25 21:20:37','2023-06-27 16:28:09','2023-06-27 16:28:09'),(3847,8694,41011,25753,3,2840,'App\\Models\\Receipt',2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',7234.57,NULL,NULL,1,'2023-06-25 21:20:37','2023-06-25 23:25:55','2023-06-25 23:25:55'),(3848,8694,41011,25753,3,2841,'App\\Models\\Receipt',2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',31216.25,NULL,NULL,1,'2023-06-25 21:20:37','2023-06-25 22:03:04','2023-06-25 22:03:04'),(3849,8694,41011,25753,3,2842,'App\\Models\\Receipt',2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',23481.25,NULL,NULL,1,'2023-06-25 21:20:37','2023-06-25 22:03:45','2023-06-25 22:03:45'),(3850,8694,41011,25753,3,2843,'App\\Models\\Receipt',2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',6061.97,NULL,NULL,1,'2023-06-25 21:20:37','2023-06-25 23:27:27','2023-06-25 23:27:27'),(3851,8694,41011,25753,3,2844,'App\\Models\\Receipt',2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',8500.00,NULL,NULL,1,'2023-06-25 21:20:38','2023-06-25 22:04:05','2023-06-25 22:04:05'),(3852,8694,41011,25753,3,2845,'App\\Models\\Receipt',2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',27492.40,NULL,NULL,1,'2023-06-25 21:20:38','2023-06-25 21:20:38',NULL),(3853,8694,41011,25753,3,2846,'App\\Models\\Receipt',2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',7715.34,NULL,NULL,1,'2023-06-25 21:20:38','2023-06-25 23:29:23','2023-06-25 23:29:23'),(3854,8694,41011,25753,3,2847,'App\\Models\\Receipt',2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',6085.12,NULL,NULL,1,'2023-06-25 21:20:38','2023-06-25 23:32:22','2023-06-25 23:32:22'),(3855,8694,41011,25753,3,2848,'App\\Models\\Receipt',2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',31492.50,NULL,NULL,1,'2023-06-25 21:20:38','2023-06-25 23:02:18','2023-06-25 23:02:18'),(3856,8694,41011,25753,3,2849,'App\\Models\\Receipt',2849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',39144.83,NULL,NULL,1,'2023-06-25 21:20:38','2023-06-27 16:35:15','2023-06-27 16:35:15');
INSERT INTO `balance_libro` VALUES (3857,8694,41011,25753,3,2850,'App\\Models\\Receipt',2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',50609.00,NULL,NULL,1,'2023-06-25 21:20:38','2023-06-25 21:20:38',NULL),(3858,8694,41011,25753,3,2851,'App\\Models\\Receipt',2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',6296.26,NULL,NULL,1,'2023-06-25 21:20:38','2023-06-25 23:33:49','2023-06-25 23:33:49'),(3859,8694,41011,25753,3,2852,'App\\Models\\Receipt',2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',2000.00,NULL,NULL,1,'2023-06-25 21:20:38','2023-06-27 16:35:43','2023-06-27 16:35:43'),(3860,8694,41011,25753,3,2853,'App\\Models\\Receipt',2853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',2552.55,NULL,NULL,1,'2023-06-25 21:20:38','2023-06-25 21:20:38',NULL),(3861,8694,41011,25753,3,2854,'App\\Models\\Receipt',2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',6186.51,NULL,NULL,1,'2023-06-25 21:20:38','2023-06-25 23:37:10','2023-06-25 23:37:10'),(3862,8694,41011,25753,3,2855,'App\\Models\\Receipt',2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',32597.50,NULL,NULL,1,'2023-06-25 21:20:38','2023-06-25 23:04:44','2023-06-25 23:04:44'),(3863,8694,41011,25753,3,2856,'App\\Models\\Receipt',2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',49026.97,NULL,NULL,1,'2023-06-25 21:20:38','2023-06-25 23:03:49','2023-06-25 23:03:49'),(3864,8694,41011,25753,3,2857,'App\\Models\\Receipt',2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',7793.87,NULL,NULL,1,'2023-06-25 21:20:38','2023-06-25 23:38:41','2023-06-25 23:38:41'),(3865,8694,41011,25753,3,2858,'App\\Models\\Receipt',2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',36465.00,NULL,NULL,1,'2023-06-25 21:20:38','2023-06-25 23:05:39','2023-06-25 23:05:39'),(3866,8694,41011,25753,3,2859,'App\\Models\\Receipt',2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',12236.93,NULL,NULL,1,'2023-06-25 21:20:38','2023-06-25 23:40:25','2023-06-25 23:40:25'),(3867,8694,41011,25753,3,2860,'App\\Models\\Receipt',2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',39006.50,NULL,NULL,1,'2023-06-25 21:20:38','2023-06-25 21:20:38',NULL),(3868,8694,41011,25753,3,2861,'App\\Models\\Receipt',2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',6703.88,NULL,NULL,1,'2023-06-25 21:20:38','2023-06-25 23:41:50','2023-06-25 23:41:50'),(3869,8694,41011,25753,3,2862,'App\\Models\\Receipt',2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',28730.00,NULL,NULL,1,'2023-06-25 21:20:39','2023-06-25 23:06:23','2023-06-25 23:06:23'),(3870,8694,41011,25753,3,2863,'App\\Models\\Receipt',2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',5573.20,NULL,NULL,1,'2023-06-25 21:20:39','2023-06-25 23:46:41','2023-06-25 23:46:41'),(3871,8694,41011,25753,3,2864,'App\\Models\\Receipt',2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',6867.78,NULL,NULL,1,'2023-06-25 21:20:39','2023-06-25 23:49:47','2023-06-25 23:49:47'),(3872,8694,41011,25753,3,2865,'App\\Models\\Receipt',2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',29006.25,NULL,NULL,1,'2023-06-25 21:20:39','2023-06-25 23:07:07','2023-06-25 23:07:07'),(3873,8694,41011,25753,3,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',19669.00,NULL,NULL,1,'2023-06-25 21:20:39','2023-06-25 21:20:39',NULL),(3874,8694,41011,25753,3,2867,'App\\Models\\Receipt',2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',6294.59,NULL,NULL,1,'2023-06-25 21:20:39','2023-06-25 23:55:08','2023-06-25 23:55:08'),(3875,8694,41011,25753,2,2820,'App\\Models\\Receipt',2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',44100.01,NULL,NULL,1,'2023-06-25 21:25:21','2023-06-25 21:25:21',NULL);
INSERT INTO `balance_libro` VALUES (3876,8694,41011,25753,2,2821,'App\\Models\\Receipt',2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',37349.87,NULL,NULL,1,'2023-06-25 21:25:58','2023-06-25 21:25:58',NULL),(3877,8694,41011,25753,2,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',46600.00,NULL,NULL,1,'2023-06-25 21:26:31','2023-06-25 21:26:31',NULL),(3878,8694,41011,25753,2,2823,'App\\Models\\Receipt',2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',46550.03,NULL,NULL,1,'2023-06-25 21:27:10','2023-06-25 21:27:10',NULL),(3879,8694,41011,25753,2,2824,'App\\Models\\Receipt',2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',46600.00,NULL,NULL,1,'2023-06-25 21:28:28','2023-06-25 21:28:28',NULL),(3880,8694,41011,25753,2,2830,'App\\Models\\Receipt',2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',46600.00,NULL,NULL,1,'2023-06-25 21:29:18','2023-06-25 21:29:18',NULL),(3881,8694,41011,25753,2,2825,'App\\Models\\Receipt',2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',46600.00,NULL,NULL,1,'2023-06-25 21:29:50','2023-06-25 21:29:50',NULL),(3882,8694,41011,25753,2,2826,'App\\Models\\Receipt',2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',39499.99,NULL,NULL,1,'2023-06-25 21:30:21','2023-06-25 21:30:21',NULL),(3883,8694,41011,25753,2,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',53249.98,NULL,NULL,1,'2023-06-25 21:31:17','2023-06-25 21:31:17',NULL),(3884,8694,41011,25753,2,2828,'App\\Models\\Receipt',2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',34049.99,NULL,NULL,1,'2023-06-25 21:32:32','2023-06-25 21:32:32',NULL),(3885,8694,41011,25753,2,2829,'App\\Models\\Receipt',2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',31949.99,NULL,NULL,1,'2023-06-25 21:33:22','2023-06-25 21:33:22',NULL),(3886,8694,41011,25753,2,2831,'App\\Models\\Receipt',2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',132640.20,NULL,NULL,1,'2023-06-25 21:33:48','2023-06-25 21:33:48',NULL),(3887,8694,41011,25753,3,2833,'App\\Models\\Receipt',2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',86000.00,NULL,NULL,1,'2023-06-25 22:00:54','2023-06-25 22:00:54',NULL),(3888,8694,41011,25753,3,2832,'App\\Models\\Receipt',2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',41990.00,NULL,NULL,1,'2023-06-25 22:01:37','2023-06-25 22:01:37',NULL),(3889,8694,41011,25753,3,2836,'App\\Models\\Receipt',2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',23481.25,NULL,NULL,1,'2023-06-25 22:02:17','2023-06-25 22:02:17',NULL),(3890,8694,41011,25753,3,2841,'App\\Models\\Receipt',2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',31216.25,NULL,NULL,1,'2023-06-25 22:03:04','2023-06-25 22:03:04',NULL),(3891,8694,41011,25753,3,2842,'App\\Models\\Receipt',2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',23481.25,NULL,NULL,1,'2023-06-25 22:03:45','2023-06-25 22:03:45',NULL),(3892,8694,41011,25753,3,2844,'App\\Models\\Receipt',2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',8500.00,NULL,NULL,1,'2023-06-25 22:04:05','2023-06-25 22:04:05',NULL),(3893,8694,41011,25753,3,2848,'App\\Models\\Receipt',2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',31492.50,NULL,NULL,1,'2023-06-25 23:02:18','2023-06-25 23:02:18',NULL),(3894,8694,41011,25753,3,2856,'App\\Models\\Receipt',2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',49026.97,NULL,NULL,1,'2023-06-25 23:03:49','2023-06-25 23:03:49',NULL),(3895,8694,41011,25753,3,2855,'App\\Models\\Receipt',2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',32597.50,NULL,NULL,1,'2023-06-25 23:04:44','2023-06-25 23:04:44',NULL),(3896,8694,41011,25753,3,2858,'App\\Models\\Receipt',2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',36465.00,NULL,NULL,1,'2023-06-25 23:05:39','2023-06-25 23:05:39',NULL);
INSERT INTO `balance_libro` VALUES (3897,8694,41011,25753,3,2862,'App\\Models\\Receipt',2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',28730.00,NULL,NULL,1,'2023-06-25 23:06:23','2023-06-25 23:06:23',NULL),(3898,8694,41011,25753,3,2865,'App\\Models\\Receipt',2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',29006.25,NULL,NULL,1,'2023-06-25 23:07:07','2023-06-25 23:07:07',NULL),(3899,8694,41011,25753,3,2868,'App\\Models\\Receipt',2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',3450.00,NULL,NULL,1,'2023-06-25 23:13:56','2023-06-25 23:13:56',NULL),(3900,8694,41011,25753,3,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',7803.97,NULL,NULL,1,'2023-06-25 23:19:02','2023-06-25 23:19:02',NULL),(3901,8694,41011,25753,3,2869,'App\\Models\\Receipt',2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',8862.17,NULL,NULL,1,'2023-06-25 23:24:04','2023-06-25 23:24:04',NULL),(3902,8694,41011,25753,3,2840,'App\\Models\\Receipt',2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',7234.57,NULL,NULL,1,'2023-06-25 23:25:55','2023-06-25 23:25:55',NULL),(3903,8694,41011,25753,3,2843,'App\\Models\\Receipt',2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',6061.97,NULL,NULL,1,'2023-06-25 23:27:27','2023-06-25 23:27:27',NULL),(3904,8694,41011,25753,3,2846,'App\\Models\\Receipt',2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',7715.34,NULL,NULL,1,'2023-06-25 23:29:23','2023-06-25 23:29:23',NULL),(3905,8694,41011,25753,3,2847,'App\\Models\\Receipt',2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',6085.13,NULL,NULL,1,'2023-06-25 23:32:22','2023-06-25 23:32:22',NULL),(3906,8694,41011,25753,3,2851,'App\\Models\\Receipt',2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',6296.26,NULL,NULL,1,'2023-06-25 23:33:49','2023-06-25 23:33:49',NULL),(3907,8694,41011,25753,3,2870,'App\\Models\\Receipt',2870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',5100.00,NULL,NULL,1,'2023-06-25 23:35:41','2023-06-25 23:35:41',NULL),(3908,8694,41011,25753,3,2854,'App\\Models\\Receipt',2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',6186.51,NULL,NULL,1,'2023-06-25 23:37:10','2023-06-25 23:37:10',NULL),(3909,8694,41011,25753,3,2857,'App\\Models\\Receipt',2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',7793.86,NULL,NULL,1,'2023-06-25 23:38:41','2023-06-25 23:38:41',NULL),(3910,8694,41011,25753,3,2859,'App\\Models\\Receipt',2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',12236.95,NULL,NULL,1,'2023-06-25 23:40:25','2023-06-25 23:40:25',NULL),(3911,8694,41011,25753,3,2861,'App\\Models\\Receipt',2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',6703.87,NULL,NULL,1,'2023-06-25 23:41:50','2023-06-25 23:41:50',NULL),(3912,8694,41011,25753,3,2871,'App\\Models\\Receipt',2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',194999.99,NULL,NULL,1,'2023-06-25 23:44:10','2023-06-25 23:44:10',NULL),(3913,8694,41011,25753,3,2863,'App\\Models\\Receipt',2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',5573.20,NULL,NULL,1,'2023-06-25 23:46:41','2023-06-25 23:46:41',NULL),(3914,8694,41011,25753,3,2864,'App\\Models\\Receipt',2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',6867.78,NULL,NULL,1,'2023-06-25 23:49:47','2023-06-25 23:49:47',NULL),(3915,8694,41011,25753,3,2872,'App\\Models\\Receipt',2872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',10005.71,NULL,NULL,1,'2023-06-25 23:53:26','2023-06-25 23:53:26',NULL),(3916,8694,41011,25753,3,2867,'App\\Models\\Receipt',2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',6294.60,NULL,NULL,1,'2023-06-25 23:55:08','2023-06-25 23:55:08',NULL);
INSERT INTO `balance_libro` VALUES (3917,8694,40915,22726,2,2873,'App\\Models\\Receipt',2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',105686.24,NULL,NULL,1,'2023-06-26 00:00:15','2023-06-26 00:02:44','2023-06-26 00:02:44'),(3918,8694,40915,22726,2,2874,'App\\Models\\Receipt',2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',89070.52,NULL,NULL,1,'2023-06-26 00:00:15','2023-06-26 00:03:18','2023-06-26 00:03:18'),(3919,8694,40915,22726,2,2875,'App\\Models\\Receipt',2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',262267.50,NULL,NULL,1,'2023-06-26 00:00:16','2023-06-26 00:04:06','2023-06-26 00:04:06'),(3920,8694,40915,22726,2,2876,'App\\Models\\Receipt',2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',84482.20,NULL,NULL,1,'2023-06-26 00:00:16','2023-06-26 00:04:44','2023-06-26 00:04:44'),(3921,8694,40915,22726,2,2877,'App\\Models\\Receipt',2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',121580.80,NULL,NULL,1,'2023-06-26 00:00:16','2023-06-26 00:05:12','2023-06-26 00:05:12'),(3922,8694,40915,22726,3,2878,'App\\Models\\Receipt',2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',2464.17,NULL,NULL,1,'2023-06-26 00:00:32','2023-06-26 00:18:45','2023-06-26 00:18:45'),(3923,8694,40915,22726,3,2879,'App\\Models\\Receipt',2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',78184.00,NULL,NULL,1,'2023-06-26 00:00:32','2023-06-29 00:27:33','2023-06-29 00:27:33'),(3924,8694,40915,22726,3,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',94602.64,NULL,NULL,1,'2023-06-26 00:00:32','2023-06-26 00:19:27','2023-06-26 00:19:27'),(3925,8694,40915,22726,3,2881,'App\\Models\\Receipt',2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',68442.72,NULL,NULL,1,'2023-06-26 00:00:32','2023-06-26 00:20:00','2023-06-26 00:20:00'),(3926,8694,40915,22726,3,2882,'App\\Models\\Receipt',2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',78184.00,NULL,NULL,1,'2023-06-26 00:00:32','2023-06-29 00:27:51','2023-06-29 00:27:51'),(3927,8694,40915,22726,3,2883,'App\\Models\\Receipt',2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',26269.10,NULL,NULL,1,'2023-06-26 00:00:32','2023-06-26 00:21:47','2023-06-26 00:21:47'),(3928,8694,40915,22726,3,2884,'App\\Models\\Receipt',2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',8000.00,NULL,NULL,1,'2023-06-26 00:00:32','2023-06-26 00:23:38','2023-06-26 00:23:38'),(3929,8694,40915,22726,3,2885,'App\\Models\\Receipt',2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',70330.04,NULL,NULL,1,'2023-06-26 00:00:33','2023-06-26 00:23:02','2023-06-26 00:23:02'),(3930,8694,40915,22726,3,2886,'App\\Models\\Receipt',2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',39344.36,NULL,NULL,1,'2023-06-26 00:00:33','2023-06-26 00:24:11','2023-06-26 00:24:11'),(3931,8694,40915,22726,3,2887,'App\\Models\\Receipt',2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',15609.00,NULL,NULL,1,'2023-06-26 00:00:33','2023-06-26 00:25:12','2023-06-26 00:25:12'),(3932,8694,40915,22726,3,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',255.17,NULL,NULL,1,'2023-06-26 00:00:33','2023-06-26 00:00:33',NULL),(3933,8694,40915,22726,3,2889,'App\\Models\\Receipt',2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',79242.90,NULL,NULL,1,'2023-06-26 00:00:33','2023-06-26 00:25:50','2023-06-26 00:25:50'),(3934,8694,40915,22726,3,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',46998.82,NULL,NULL,1,'2023-06-26 00:00:33','2023-06-26 00:26:25','2023-06-26 00:26:25'),(3935,8694,40915,22726,3,2891,'App\\Models\\Receipt',2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',29478.63,NULL,NULL,1,'2023-06-26 00:00:33','2023-06-26 00:27:14','2023-06-26 00:27:14');
INSERT INTO `balance_libro` VALUES (3936,8694,40915,22726,3,2892,'App\\Models\\Receipt',2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',10399.90,NULL,NULL,1,'2023-06-26 00:00:33','2023-06-26 00:44:22','2023-06-26 00:44:22'),(3937,8694,40915,22726,3,2893,'App\\Models\\Receipt',2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',18340.29,NULL,NULL,1,'2023-06-26 00:00:33','2023-06-26 00:28:28','2023-06-26 00:28:28'),(3938,8694,40915,22726,3,2894,'App\\Models\\Receipt',2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',9433.16,NULL,NULL,1,'2023-06-26 00:00:33','2023-06-26 00:29:36','2023-06-26 00:29:36'),(3939,8694,40915,22726,3,2895,'App\\Models\\Receipt',2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',48181.72,NULL,NULL,1,'2023-06-26 00:00:33','2023-06-26 00:30:08','2023-06-26 00:30:08'),(3940,8694,40915,22726,3,2896,'App\\Models\\Receipt',2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',10507.64,NULL,NULL,1,'2023-06-26 00:00:33','2023-06-26 00:30:51','2023-06-26 00:30:51'),(3941,8694,40915,22726,3,2897,'App\\Models\\Receipt',2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',76163.45,NULL,NULL,1,'2023-06-26 00:00:33','2023-06-26 00:31:34','2023-06-26 00:31:34'),(3942,8694,40915,22726,3,2898,'App\\Models\\Receipt',2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',11791.45,NULL,NULL,1,'2023-06-26 00:00:33','2023-06-26 00:32:54','2023-06-26 00:32:54'),(3943,8694,40915,22726,3,2899,'App\\Models\\Receipt',2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',14477.65,NULL,NULL,1,'2023-06-26 00:00:33','2023-06-26 00:32:09','2023-06-26 00:32:09'),(3944,8694,40915,22726,2,2873,'App\\Models\\Receipt',2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',105686.24,NULL,NULL,1,'2023-06-26 00:02:44','2023-06-26 00:02:44',NULL),(3945,8694,40915,22726,2,2874,'App\\Models\\Receipt',2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',89070.52,NULL,NULL,1,'2023-06-26 00:03:18','2023-06-26 00:03:18',NULL),(3946,8694,40915,22726,2,2875,'App\\Models\\Receipt',2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',262267.50,NULL,NULL,1,'2023-06-26 00:04:06','2023-06-26 00:04:06',NULL),(3947,8694,40915,22726,2,2876,'App\\Models\\Receipt',2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',84482.20,NULL,NULL,1,'2023-06-26 00:04:44','2023-06-26 00:04:44',NULL),(3948,8694,40915,22726,2,2877,'App\\Models\\Receipt',2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',121580.80,NULL,NULL,1,'2023-06-26 00:05:12','2023-06-26 00:05:12',NULL),(3949,8694,40915,22726,3,2878,'App\\Models\\Receipt',2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',2464.17,NULL,NULL,1,'2023-06-26 00:18:45','2023-06-26 00:18:45',NULL),(3950,8694,40915,22726,3,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',94602.64,NULL,NULL,1,'2023-06-26 00:19:27','2023-06-26 00:19:27',NULL),(3951,8694,40915,22726,3,2881,'App\\Models\\Receipt',2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',68442.72,NULL,NULL,1,'2023-06-26 00:20:00','2023-06-26 00:20:00',NULL),(3952,8694,40915,22726,3,2883,'App\\Models\\Receipt',2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',26269.10,NULL,NULL,1,'2023-06-26 00:21:47','2023-06-26 00:21:47',NULL),(3953,8694,40915,22726,3,2885,'App\\Models\\Receipt',2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',70330.04,NULL,NULL,1,'2023-06-26 00:23:02','2023-06-26 00:23:02',NULL),(3954,8694,40915,22726,3,2884,'App\\Models\\Receipt',2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',8000.00,NULL,NULL,1,'2023-06-26 00:23:38','2023-06-26 00:23:38',NULL),(3955,8694,40915,22726,3,2886,'App\\Models\\Receipt',2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',39344.36,NULL,NULL,1,'2023-06-26 00:24:11','2023-06-26 00:24:11',NULL);
INSERT INTO `balance_libro` VALUES (3956,8694,40915,22726,3,2887,'App\\Models\\Receipt',2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',15609.00,NULL,NULL,1,'2023-06-26 00:25:12','2023-06-26 00:25:12',NULL),(3957,8694,40915,22726,3,2889,'App\\Models\\Receipt',2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',79242.90,NULL,NULL,1,'2023-06-26 00:25:50','2023-06-26 00:25:50',NULL),(3958,8694,40915,22726,3,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',46998.82,NULL,NULL,1,'2023-06-26 00:26:25','2023-06-26 00:26:25',NULL),(3959,8694,40915,22726,3,2891,'App\\Models\\Receipt',2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',29478.63,NULL,NULL,1,'2023-06-26 00:27:14','2023-06-26 00:27:14',NULL),(3960,8694,40915,22726,3,2893,'App\\Models\\Receipt',2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',18340.29,NULL,NULL,1,'2023-06-26 00:28:28','2023-06-26 00:28:28',NULL),(3961,8694,40915,22726,3,2894,'App\\Models\\Receipt',2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',9433.16,NULL,NULL,1,'2023-06-26 00:29:36','2023-06-26 00:29:36',NULL),(3962,8694,40915,22726,3,2895,'App\\Models\\Receipt',2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',48181.72,NULL,NULL,1,'2023-06-26 00:30:08','2023-06-26 00:30:08',NULL),(3963,8694,40915,22726,3,2896,'App\\Models\\Receipt',2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',10507.64,NULL,NULL,1,'2023-06-26 00:30:51','2023-06-26 00:30:51',NULL),(3964,8694,40915,22726,3,2897,'App\\Models\\Receipt',2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',76163.45,NULL,NULL,1,'2023-06-26 00:31:34','2023-06-26 00:31:34',NULL),(3965,8694,40915,22726,3,2899,'App\\Models\\Receipt',2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',14477.65,NULL,NULL,1,'2023-06-26 00:32:09','2023-06-26 00:32:09',NULL),(3966,8694,40915,22726,3,2898,'App\\Models\\Receipt',2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',11791.45,NULL,NULL,1,'2023-06-26 00:32:54','2023-06-26 00:32:54',NULL),(3967,8694,40915,22726,3,2900,'App\\Models\\Receipt',2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',11803.59,NULL,NULL,1,'2023-06-26 00:35:23','2023-06-26 00:35:23',NULL),(3968,8694,40915,22726,3,2901,'App\\Models\\Receipt',2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',10132.77,NULL,NULL,1,'2023-06-26 00:37:46','2023-06-26 00:37:46',NULL),(3969,8694,40915,22726,3,2902,'App\\Models\\Receipt',2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',13001.12,NULL,NULL,1,'2023-06-26 00:39:41','2023-06-26 00:39:41',NULL),(3970,8694,40915,22726,3,2892,'App\\Models\\Receipt',2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',10399.91,NULL,NULL,1,'2023-06-26 00:44:22','2023-06-26 00:44:22',NULL),(3971,8694,40915,22726,3,2903,'App\\Models\\Receipt',2903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',10472.73,NULL,NULL,1,'2023-06-26 00:46:30','2023-06-26 00:46:30',NULL),(3972,8694,40915,22726,3,2904,'App\\Models\\Receipt',2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-28','2023-05-28',2000.94,NULL,NULL,1,'2023-06-26 00:47:39','2023-06-26 00:47:39',NULL),(3973,8694,40915,22726,3,2905,'App\\Models\\Receipt',2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',8400.21,NULL,NULL,1,'2023-06-26 00:48:50','2023-06-26 00:48:50',NULL),(3974,8694,41204,30285,2,2906,'App\\Models\\Receipt',2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',628628.15,NULL,NULL,1,'2023-06-26 00:52:53','2023-06-26 00:54:58','2023-06-26 00:54:58'),(3975,8694,41204,30285,3,2907,'App\\Models\\Receipt',2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',307.97,NULL,NULL,1,'2023-06-26 00:53:07','2023-06-28 23:25:40','2023-06-28 23:25:40');
INSERT INTO `balance_libro` VALUES (3976,8694,41204,30285,3,2908,'App\\Models\\Receipt',2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',65000.00,NULL,NULL,1,'2023-06-26 00:53:07','2023-06-26 00:57:19','2023-06-26 00:57:19'),(3977,8694,41204,30285,3,2909,'App\\Models\\Receipt',2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',15817.80,NULL,NULL,1,'2023-06-26 00:53:07','2023-06-26 00:53:07',NULL),(3978,8694,41204,30285,3,2910,'App\\Models\\Receipt',2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',6315.90,NULL,NULL,1,'2023-06-26 00:53:07','2023-06-26 01:26:48','2023-06-26 01:26:48'),(3979,8694,41204,30285,3,2911,'App\\Models\\Receipt',2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',8000.00,NULL,NULL,1,'2023-06-26 00:53:07','2023-06-26 00:57:44','2023-06-26 00:57:44'),(3980,8694,41204,30285,3,2912,'App\\Models\\Receipt',2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',4090.28,NULL,NULL,1,'2023-06-26 00:53:07','2023-06-26 01:28:12','2023-06-26 01:28:12'),(3981,8694,41204,30285,3,2913,'App\\Models\\Receipt',2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',20080.98,NULL,NULL,1,'2023-06-26 00:53:07','2023-06-26 01:38:45','2023-06-26 01:38:45'),(3982,8694,41204,30285,3,2914,'App\\Models\\Receipt',2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',10025.28,NULL,NULL,1,'2023-06-26 00:53:07','2023-06-26 01:56:37','2023-06-26 01:56:37'),(3983,8694,41204,30285,3,2915,'App\\Models\\Receipt',2915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',90.00,NULL,NULL,1,'2023-06-26 00:53:07','2023-06-29 00:05:48','2023-06-29 00:05:48'),(3984,8694,41204,30285,3,2916,'App\\Models\\Receipt',2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',2804.00,NULL,NULL,1,'2023-06-26 00:53:07','2023-06-26 00:58:34','2023-06-26 00:58:34'),(3985,8694,41204,30285,2,2906,'App\\Models\\Receipt',2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',628628.15,NULL,NULL,1,'2023-06-26 00:54:58','2023-06-26 00:54:58',NULL),(3986,8694,41204,30285,3,2908,'App\\Models\\Receipt',2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',65000.00,NULL,NULL,1,'2023-06-26 00:57:19','2023-06-26 00:57:19',NULL),(3987,8694,41204,30285,3,2911,'App\\Models\\Receipt',2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',8000.00,NULL,NULL,1,'2023-06-26 00:57:44','2023-06-26 00:57:44',NULL),(3988,8694,41204,30285,3,2916,'App\\Models\\Receipt',2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',2803.99,NULL,NULL,1,'2023-06-26 00:58:34','2023-06-26 00:58:34',NULL),(3989,8694,41204,30285,3,2917,'App\\Models\\Receipt',2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',7800.53,NULL,NULL,1,'2023-06-26 01:11:43','2023-06-26 01:11:43',NULL),(3990,8694,41204,30285,3,2918,'App\\Models\\Receipt',2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',15001.70,NULL,NULL,1,'2023-06-26 01:16:20','2023-06-26 01:16:20',NULL),(3991,8694,41204,30285,3,2919,'App\\Models\\Receipt',2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',6000.02,NULL,NULL,1,'2023-06-26 01:18:55','2023-06-26 01:18:55',NULL),(3992,8694,41204,30285,3,2920,'App\\Models\\Receipt',2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',8521.65,NULL,NULL,1,'2023-06-26 01:21:50','2023-06-26 01:21:50',NULL),(3993,8694,41204,30285,3,2921,'App\\Models\\Receipt',2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',4812.17,NULL,NULL,1,'2023-06-26 01:23:49','2023-06-26 01:23:49',NULL),(3994,8694,41204,30285,3,2910,'App\\Models\\Receipt',2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',6315.89,NULL,NULL,1,'2023-06-26 01:26:48','2023-06-26 01:26:48',NULL),(3995,8694,41204,30285,3,2912,'App\\Models\\Receipt',2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',4090.28,NULL,NULL,1,'2023-06-26 01:28:12','2023-06-26 01:28:12',NULL);
INSERT INTO `balance_libro` VALUES (3996,8694,41204,30285,3,2922,'App\\Models\\Receipt',2922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',9480.83,NULL,NULL,1,'2023-06-26 01:33:01','2023-06-26 01:33:01',NULL),(3997,8694,41204,30285,3,2923,'App\\Models\\Receipt',2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',8158.63,NULL,NULL,1,'2023-06-26 01:36:43','2023-06-26 01:36:43',NULL),(3998,8694,41204,30285,3,2913,'App\\Models\\Receipt',2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',20080.98,NULL,NULL,1,'2023-06-26 01:38:45','2023-06-26 01:38:45',NULL),(3999,8694,41204,30285,3,2924,'App\\Models\\Receipt',2924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',8020.34,NULL,NULL,1,'2023-06-26 01:41:17','2023-06-26 01:41:17',NULL),(4000,8694,41204,30285,3,2925,'App\\Models\\Receipt',2925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',5914.81,NULL,NULL,1,'2023-06-26 01:44:19','2023-06-26 01:44:19',NULL),(4001,8694,41204,30285,3,2926,'App\\Models\\Receipt',2926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',8020.34,NULL,NULL,1,'2023-06-26 01:45:48','2023-06-26 01:45:48',NULL),(4002,8694,41204,30285,3,2927,'App\\Models\\Receipt',2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',8521.62,NULL,NULL,1,'2023-06-26 01:47:32','2023-06-26 01:47:32',NULL),(4003,8694,41204,30285,3,2914,'App\\Models\\Receipt',2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',10025.28,NULL,NULL,1,'2023-06-26 01:56:37','2023-06-26 01:56:37',NULL),(4004,8694,41204,30285,3,2928,'App\\Models\\Receipt',2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',4010.04,NULL,NULL,1,'2023-06-26 01:59:19','2023-06-26 01:59:19',NULL),(4005,8694,41204,30285,3,2929,'App\\Models\\Receipt',2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',20049.17,NULL,NULL,1,'2023-06-26 02:02:05','2023-06-26 02:02:05',NULL),(4006,8694,41204,30285,3,2930,'App\\Models\\Receipt',2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',5313.28,NULL,NULL,1,'2023-06-26 02:04:35','2023-06-26 02:04:35',NULL),(4007,8694,41204,30285,3,2931,'App\\Models\\Receipt',2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-21','2023-05-21',13302.12,NULL,NULL,1,'2023-06-26 02:06:55','2023-06-26 02:06:55',NULL),(4008,8694,41204,30285,3,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',4000.09,NULL,NULL,1,'2023-06-26 02:08:36','2023-06-26 02:08:36',NULL),(4009,8694,41204,30285,3,2933,'App\\Models\\Receipt',2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',5012.70,NULL,NULL,1,'2023-06-26 02:10:50','2023-06-26 02:10:50',NULL),(4010,8694,41204,30285,3,2934,'App\\Models\\Receipt',2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',8521.58,NULL,NULL,1,'2023-06-26 02:13:31','2023-06-26 02:13:31',NULL),(4011,8694,41204,30285,3,2935,'App\\Models\\Receipt',2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',5012.70,NULL,NULL,1,'2023-06-26 02:15:01','2023-06-26 02:15:01',NULL),(4012,8694,41204,30285,3,2936,'App\\Models\\Receipt',2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',14999.35,NULL,NULL,1,'2023-06-26 02:17:27','2023-06-26 02:17:27',NULL),(4013,7525,40839,12133,2,2937,'App\\Models\\Receipt',2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',15200.00,NULL,NULL,1,'2023-06-27 14:17:42','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4014,7525,40839,12133,2,2938,'App\\Models\\Receipt',2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',47183.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4015,7525,40839,12133,2,2939,'App\\Models\\Receipt',2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',40975.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21');
INSERT INTO `balance_libro` VALUES (4016,7525,40839,12133,2,2940,'App\\Models\\Receipt',2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',55830.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4017,7525,40839,12133,2,2941,'App\\Models\\Receipt',2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',112600.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4018,7525,40839,12133,2,2942,'App\\Models\\Receipt',2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',40104.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4019,7525,40839,12133,2,2943,'App\\Models\\Receipt',2943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',49911.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4020,7525,40839,12133,2,2944,'App\\Models\\Receipt',2944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',34513.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4021,7525,40839,12133,2,2945,'App\\Models\\Receipt',2945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',46714.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4022,7525,40839,12133,2,2946,'App\\Models\\Receipt',2946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',126376.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4023,7525,40839,12133,2,2947,'App\\Models\\Receipt',2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',99751.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4024,7525,40839,12133,2,2948,'App\\Models\\Receipt',2948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',31000.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4025,7525,40839,12133,2,2949,'App\\Models\\Receipt',2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',52740.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4026,7525,40839,12133,2,2950,'App\\Models\\Receipt',2950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',26830.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4027,7525,40839,12133,2,2951,'App\\Models\\Receipt',2951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',67807.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4028,7525,40839,12133,2,2952,'App\\Models\\Receipt',2952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',61959.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4029,7525,40839,12133,2,2953,'App\\Models\\Receipt',2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',104600.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4030,7525,40839,12133,2,2954,'App\\Models\\Receipt',2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',31400.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4031,7525,40839,12133,2,2955,'App\\Models\\Receipt',2955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',23646.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4032,7525,40839,12133,2,2956,'App\\Models\\Receipt',2956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',64743.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4033,7525,40839,12133,2,2957,'App\\Models\\Receipt',2957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',31076.00,NULL,NULL,1,'2023-06-27 14:17:43','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4034,7525,40839,12133,2,2958,'App\\Models\\Receipt',2958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',37932.00,NULL,NULL,1,'2023-06-27 14:17:44','2023-06-27 14:19:21','2023-06-27 14:19:21');
INSERT INTO `balance_libro` VALUES (4035,7525,40839,12133,2,2959,'App\\Models\\Receipt',2959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',106448.00,NULL,NULL,1,'2023-06-27 14:17:44','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4036,7525,40839,12133,2,2960,'App\\Models\\Receipt',2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',1500.00,NULL,NULL,1,'2023-06-27 14:17:44','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4037,7525,40839,12133,2,2961,'App\\Models\\Receipt',2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1060.00,NULL,NULL,1,'2023-06-27 14:17:44','2023-06-27 14:19:21','2023-06-27 14:19:21'),(4038,7525,40849,13648,2,2962,'App\\Models\\Receipt',2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',15200.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL),(4039,7525,40849,13648,2,2963,'App\\Models\\Receipt',2963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',47183.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL),(4040,7525,40849,13648,2,2964,'App\\Models\\Receipt',2964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',40975.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL),(4041,7525,40849,13648,2,2965,'App\\Models\\Receipt',2965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',55830.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL),(4042,7525,40849,13648,2,2966,'App\\Models\\Receipt',2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',112600.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL),(4043,7525,40849,13648,2,2967,'App\\Models\\Receipt',2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',40104.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL),(4044,7525,40849,13648,2,2968,'App\\Models\\Receipt',2968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',49911.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL),(4045,7525,40849,13648,2,2969,'App\\Models\\Receipt',2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',34513.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL),(4046,7525,40849,13648,2,2970,'App\\Models\\Receipt',2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',46714.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL),(4047,7525,40849,13648,2,2971,'App\\Models\\Receipt',2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',126376.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL),(4048,7525,40849,13648,2,2972,'App\\Models\\Receipt',2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',99751.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL),(4049,7525,40849,13648,2,2973,'App\\Models\\Receipt',2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',31000.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL),(4050,7525,40849,13648,2,2974,'App\\Models\\Receipt',2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',52740.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL),(4051,7525,40849,13648,2,2975,'App\\Models\\Receipt',2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',26830.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL),(4052,7525,40849,13648,2,2976,'App\\Models\\Receipt',2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',67807.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL),(4053,7525,40849,13648,2,2977,'App\\Models\\Receipt',2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',61959.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL),(4054,7525,40849,13648,2,2978,'App\\Models\\Receipt',2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',104600.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL);
INSERT INTO `balance_libro` VALUES (4055,7525,40849,13648,2,2979,'App\\Models\\Receipt',2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',31400.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL),(4056,7525,40849,13648,2,2980,'App\\Models\\Receipt',2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',23646.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL),(4057,7525,40849,13648,2,2981,'App\\Models\\Receipt',2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',64743.00,NULL,NULL,1,'2023-06-27 14:23:53','2023-06-27 14:23:53',NULL),(4058,7525,40849,13648,2,2982,'App\\Models\\Receipt',2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',31076.00,NULL,NULL,1,'2023-06-27 14:23:54','2023-06-27 14:23:54',NULL),(4059,7525,40849,13648,2,2983,'App\\Models\\Receipt',2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',37932.00,NULL,NULL,1,'2023-06-27 14:23:54','2023-06-27 14:23:54',NULL),(4060,7525,40849,13648,2,2984,'App\\Models\\Receipt',2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',106448.00,NULL,NULL,1,'2023-06-27 14:23:54','2023-06-27 14:23:54',NULL),(4061,7525,40849,13648,2,2985,'App\\Models\\Receipt',2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',1500.00,NULL,NULL,1,'2023-06-27 14:23:54','2023-06-27 14:23:54',NULL),(4062,7525,40849,13648,2,2986,'App\\Models\\Receipt',2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1060.00,NULL,NULL,1,'2023-06-27 14:23:54','2023-06-27 14:23:54',NULL),(4063,7525,40849,13648,7,2987,'App\\Models\\Receipt',2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',7612.44,NULL,NULL,1,'2023-06-27 14:49:18','2023-06-27 14:49:18',NULL),(4064,7525,40839,12133,2,2988,'App\\Models\\Receipt',2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',332750.00,NULL,NULL,1,'2023-06-27 15:03:24','2023-06-27 15:03:24',NULL),(4065,7525,40839,12133,2,2989,'App\\Models\\Receipt',2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',23838.21,NULL,NULL,1,'2023-06-27 15:03:24','2023-06-27 15:03:24',NULL),(4066,7525,40839,12133,15,2281,'App\\Models\\PeriodLiquidation',NULL,2281,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',63050.30,NULL,NULL,1,'2023-06-27 15:04:31','2023-09-30 21:02:47','2023-09-30 21:02:47'),(4067,7525,40849,13648,15,2284,'App\\Models\\PeriodLiquidation',NULL,2284,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',290582.28,NULL,NULL,1,'2023-06-27 15:04:57','2023-06-27 15:04:57',NULL),(4068,7525,40875,16671,15,1933,'App\\Models\\PeriodLiquidation',NULL,1933,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',596050.04,NULL,NULL,1,'2023-06-27 15:18:14','2023-06-27 15:18:14',NULL),(4069,7525,40856,15160,15,2297,'App\\Models\\PeriodLiquidation',NULL,2297,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',343866.03,NULL,NULL,1,'2023-06-27 16:13:29','2023-06-27 16:13:29',NULL),(4070,7525,40875,16672,15,2314,'App\\Models\\PeriodLiquidation',NULL,2314,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',254838.16,NULL,NULL,1,'2023-06-28 21:24:09','2023-06-28 21:24:09',NULL),(4071,7525,41204,30285,3,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',7017.83,NULL,NULL,1,'2023-06-28 22:58:56','2023-06-28 22:58:56',NULL),(4072,7525,41204,30285,15,2320,'App\\Models\\PeriodLiquidation',NULL,2320,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',109100.75,NULL,NULL,1,'2023-06-29 00:23:38','2023-06-29 00:23:38',NULL),(4073,7525,40915,22726,15,2322,'App\\Models\\PeriodLiquidation',NULL,2322,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',192356.91,NULL,NULL,1,'2023-06-29 00:39:02','2023-06-29 00:39:02',NULL),(4074,7525,41184,28769,2,2991,'App\\Models\\Receipt',2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',1382216.28,NULL,NULL,1,'2023-07-01 20:15:49','2023-07-01 20:15:49',NULL);
INSERT INTO `balance_libro` VALUES (4075,7525,41184,28769,2,2992,'App\\Models\\Receipt',2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',116462.50,NULL,NULL,1,'2023-07-01 20:15:49','2023-07-01 20:15:49',NULL),(4076,7525,41184,28769,3,2993,'App\\Models\\Receipt',2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',87666.32,NULL,NULL,1,'2023-07-01 20:16:06','2023-07-01 20:16:06',NULL),(4077,7525,41184,28769,3,2994,'App\\Models\\Receipt',2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',1001943.03,NULL,NULL,1,'2023-07-01 20:16:06','2023-07-01 20:17:41','2023-07-01 20:17:41'),(4078,7525,41184,28769,3,2995,'App\\Models\\Receipt',2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',69296.70,NULL,NULL,1,'2023-07-01 20:16:06','2023-07-01 20:16:06',NULL),(4079,7525,41184,28769,3,2994,'App\\Models\\Receipt',2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',1001943.03,NULL,NULL,1,'2023-07-01 20:17:41','2023-07-01 20:17:41',NULL),(4080,7525,41184,28769,3,2657,'App\\Models\\Receipt',2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',8389.83,NULL,NULL,1,'2023-07-01 20:25:47','2023-07-01 20:25:47',NULL),(4081,7525,41184,28769,3,2655,'App\\Models\\Receipt',2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',1394173.30,NULL,NULL,1,'2023-07-01 20:26:43','2023-07-01 20:26:43',NULL),(4082,7525,41184,28769,3,2996,'App\\Models\\Receipt',2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',10800.00,NULL,NULL,1,'2023-07-01 20:35:12','2023-07-01 20:35:12',NULL),(4083,7525,41184,28769,3,2997,'App\\Models\\Receipt',2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',13094.43,NULL,NULL,1,'2023-07-01 20:36:18','2023-07-01 20:36:18',NULL),(4084,7525,41184,28769,3,2998,'App\\Models\\Receipt',2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',12896.00,NULL,NULL,1,'2023-07-01 20:37:32','2023-07-01 20:37:32',NULL),(4085,7525,41184,28769,3,2999,'App\\Models\\Receipt',2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',7157.85,NULL,NULL,1,'2023-07-01 20:39:17','2023-07-01 20:39:17',NULL),(4086,8694,40849,13649,3,3000,'App\\Models\\Receipt',3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',95320.17,NULL,NULL,1,'2023-07-24 19:41:12','2023-07-24 20:19:59','2023-07-24 20:19:59'),(4087,8694,40849,13649,3,3001,'App\\Models\\Receipt',3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',11172.37,NULL,NULL,1,'2023-07-24 19:41:12','2023-07-24 19:55:33','2023-07-24 19:55:33'),(4088,8694,40849,13649,3,3002,'App\\Models\\Receipt',3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',93514.24,NULL,NULL,1,'2023-07-24 19:41:12','2023-07-24 20:19:02','2023-07-24 20:19:02'),(4089,8694,40849,13649,3,3003,'App\\Models\\Receipt',3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',147.56,NULL,NULL,1,'2023-07-24 19:41:12','2023-07-24 19:41:12',NULL),(4090,8694,40849,13649,3,3004,'App\\Models\\Receipt',3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',4084.11,NULL,NULL,1,'2023-07-24 19:41:12','2023-07-24 20:32:50','2023-07-24 20:32:50'),(4091,8694,40849,13649,3,3005,'App\\Models\\Receipt',3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',11149.63,NULL,NULL,1,'2023-07-24 19:41:12','2023-07-24 19:49:03','2023-07-24 19:49:03'),(4092,8694,40849,13649,3,3006,'App\\Models\\Receipt',3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',42699.59,NULL,NULL,1,'2023-07-24 19:41:12','2023-07-24 19:41:12',NULL),(4093,8694,40849,13649,3,3007,'App\\Models\\Receipt',3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',95542.93,NULL,NULL,1,'2023-07-24 19:41:12','2023-07-24 20:18:13','2023-07-24 20:18:13'),(4094,8694,40849,13649,3,3008,'App\\Models\\Receipt',3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',13636.36,NULL,NULL,1,'2023-07-24 19:41:12','2023-07-24 20:34:53','2023-07-24 20:34:53');
INSERT INTO `balance_libro` VALUES (4095,8694,40849,13649,3,3009,'App\\Models\\Receipt',3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',21989.39,NULL,NULL,1,'2023-07-24 19:41:12','2023-07-24 19:58:55','2023-07-24 19:58:55'),(4096,8694,40849,13649,3,3010,'App\\Models\\Receipt',3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',93651.35,NULL,NULL,1,'2023-07-24 19:41:13','2023-07-24 20:23:09','2023-07-24 20:23:09'),(4097,8694,40849,13649,3,3011,'App\\Models\\Receipt',3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',8813.37,NULL,NULL,1,'2023-07-24 19:41:13','2023-07-24 20:00:44','2023-07-24 20:00:44'),(4098,8694,40849,13649,3,3012,'App\\Models\\Receipt',3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',9200.08,NULL,NULL,1,'2023-07-24 19:41:13','2023-07-24 20:36:17','2023-07-24 20:36:17'),(4099,8694,40849,13649,3,3013,'App\\Models\\Receipt',3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',99500.00,NULL,NULL,1,'2023-07-24 19:41:13','2023-07-24 20:11:38','2023-07-24 20:11:38'),(4100,8694,40849,13649,3,3014,'App\\Models\\Receipt',3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',1946.49,NULL,NULL,1,'2023-07-24 19:41:13','2023-07-24 20:02:04','2023-07-24 20:02:04'),(4101,8694,40849,13649,3,3015,'App\\Models\\Receipt',3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',11268.03,NULL,NULL,1,'2023-07-24 19:41:13','2023-07-24 20:30:49','2023-07-24 20:30:49'),(4102,8694,40849,13649,3,3016,'App\\Models\\Receipt',3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',10957.02,NULL,NULL,1,'2023-07-24 19:41:13','2023-07-24 20:05:28','2023-07-24 20:05:28'),(4103,8694,40849,13649,3,3017,'App\\Models\\Receipt',3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',10000.00,NULL,NULL,1,'2023-07-24 19:41:13','2023-07-24 20:39:44','2023-07-24 20:39:44'),(4104,8694,40849,13649,3,3018,'App\\Models\\Receipt',3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',19488.13,NULL,NULL,1,'2023-07-24 19:41:13','2023-07-24 20:07:08','2023-07-24 20:07:08'),(4105,8694,40849,13649,3,3019,'App\\Models\\Receipt',3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',6050.00,NULL,NULL,1,'2023-07-24 19:41:13','2023-07-24 20:17:22','2023-07-24 20:17:22'),(4106,8694,40849,13649,3,3020,'App\\Models\\Receipt',3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',9560.25,NULL,NULL,1,'2023-07-24 19:41:13','2023-07-24 20:28:24','2023-07-24 20:28:24'),(4107,8694,40849,13649,3,3021,'App\\Models\\Receipt',3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',14158.06,NULL,NULL,1,'2023-07-24 19:41:13','2023-07-24 20:37:36','2023-07-24 20:37:36'),(4108,8694,40849,13649,3,3022,'App\\Models\\Receipt',3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',98990.10,NULL,NULL,1,'2023-07-24 19:41:14','2023-07-24 20:22:00','2023-07-24 20:22:00'),(4109,8694,40849,13649,3,3023,'App\\Models\\Receipt',3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',20125.99,NULL,NULL,1,'2023-07-24 19:41:14','2023-07-24 19:45:04','2023-07-24 19:45:04'),(4110,8694,40849,13649,3,3024,'App\\Models\\Receipt',3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',32208.34,NULL,NULL,1,'2023-07-24 19:41:14','2023-07-24 20:08:46','2023-07-24 20:08:46'),(4111,8694,40849,13649,3,3025,'App\\Models\\Receipt',3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',5423.12,NULL,NULL,1,'2023-07-24 19:41:14','2023-07-24 19:41:14',NULL),(4112,8694,40849,13649,3,3026,'App\\Models\\Receipt',3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',5423.12,NULL,NULL,1,'2023-07-24 19:41:14','2023-07-24 19:41:14',NULL),(4113,8694,40849,13649,3,3027,'App\\Models\\Receipt',3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',5067.69,NULL,NULL,1,'2023-07-24 19:41:14','2023-07-24 19:50:16','2023-07-24 19:50:16');
INSERT INTO `balance_libro` VALUES (4114,8694,40849,13649,3,3028,'App\\Models\\Receipt',3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',15912.26,NULL,NULL,1,'2023-07-24 19:41:14','2023-07-24 19:51:23','2023-07-24 19:51:23'),(4115,8694,40849,13649,3,3029,'App\\Models\\Receipt',3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',21306.42,NULL,NULL,1,'2023-07-24 19:41:14','2023-07-24 20:39:03','2023-07-24 20:39:03'),(4116,8694,40849,13649,3,3030,'App\\Models\\Receipt',3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',158510.00,NULL,NULL,1,'2023-07-24 19:41:14','2023-07-24 20:24:14','2023-07-24 20:24:14'),(4117,8694,40849,13649,3,3031,'App\\Models\\Receipt',3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',9418.44,NULL,NULL,1,'2023-07-24 19:41:14','2023-07-24 20:14:00','2023-07-24 20:14:00'),(4118,8694,40849,13649,3,3032,'App\\Models\\Receipt',3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',7133.59,NULL,NULL,1,'2023-07-24 19:41:14','2023-07-24 19:41:14',NULL),(4119,8694,40849,13649,3,3033,'App\\Models\\Receipt',3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',7133.59,NULL,NULL,1,'2023-07-24 19:41:15','2023-07-26 21:03:43','2023-07-26 21:03:43'),(4120,8694,40849,13649,3,3034,'App\\Models\\Receipt',3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',6400.01,NULL,NULL,1,'2023-07-24 19:41:15','2023-07-24 19:45:49','2023-07-24 19:45:49'),(4121,8694,40849,13649,3,3035,'App\\Models\\Receipt',3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',97231.97,NULL,NULL,1,'2023-07-24 19:41:15','2023-07-24 20:20:41','2023-07-24 20:20:41'),(4122,8694,40849,13649,3,3036,'App\\Models\\Receipt',3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',27067.93,NULL,NULL,1,'2023-07-24 19:41:15','2023-07-24 20:15:39','2023-07-24 20:15:39'),(4123,8694,40849,13649,3,3037,'App\\Models\\Receipt',3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',8393.63,NULL,NULL,1,'2023-07-24 19:41:15','2023-07-24 19:41:15',NULL),(4124,8694,40849,13649,3,3038,'App\\Models\\Receipt',3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',8393.63,NULL,NULL,1,'2023-07-24 19:41:15','2023-07-26 21:03:31','2023-07-26 21:03:31'),(4125,8694,40849,13649,3,3005,'App\\Models\\Receipt',3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',11149.63,NULL,NULL,1,'2023-07-24 19:49:03','2023-07-24 19:49:03',NULL),(4126,8694,40849,13649,3,3027,'App\\Models\\Receipt',3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',5067.69,NULL,NULL,1,'2023-07-24 19:50:16','2023-07-24 19:50:16',NULL),(4127,8694,40849,13649,3,3028,'App\\Models\\Receipt',3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',15912.26,NULL,NULL,1,'2023-07-24 19:51:23','2023-07-24 19:51:23',NULL),(4128,8694,40849,13649,3,3001,'App\\Models\\Receipt',3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',11172.37,NULL,NULL,1,'2023-07-24 19:55:33','2023-07-24 19:55:33',NULL),(4129,8694,40849,13649,3,3009,'App\\Models\\Receipt',3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',21989.39,NULL,NULL,1,'2023-07-24 19:58:55','2023-07-24 19:58:55',NULL),(4130,8694,40849,13649,3,3011,'App\\Models\\Receipt',3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',8813.37,NULL,NULL,1,'2023-07-24 20:00:44','2023-07-24 20:00:44',NULL),(4131,8694,40849,13649,3,3014,'App\\Models\\Receipt',3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',1946.49,NULL,NULL,1,'2023-07-24 20:02:04','2023-07-24 20:02:04',NULL),(4132,8694,40849,13649,3,3016,'App\\Models\\Receipt',3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',10957.02,NULL,NULL,1,'2023-07-24 20:05:28','2023-07-24 20:05:28',NULL),(4133,8694,40849,13649,3,3018,'App\\Models\\Receipt',3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',19488.13,NULL,NULL,1,'2023-07-24 20:07:08','2023-07-24 20:07:08',NULL);
INSERT INTO `balance_libro` VALUES (4134,8694,40849,13649,3,3024,'App\\Models\\Receipt',3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',32208.34,NULL,NULL,1,'2023-07-24 20:08:46','2023-07-24 20:08:46',NULL),(4135,8694,40849,13649,3,3013,'App\\Models\\Receipt',3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',99499.99,NULL,NULL,1,'2023-07-24 20:11:38','2023-07-24 20:11:38',NULL),(4136,8694,40849,13649,3,3031,'App\\Models\\Receipt',3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',9418.44,NULL,NULL,1,'2023-07-24 20:14:00','2023-07-24 20:14:00',NULL),(4137,8694,40849,13649,3,3036,'App\\Models\\Receipt',3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',27067.93,NULL,NULL,1,'2023-07-24 20:15:39','2023-07-24 20:15:39',NULL),(4138,8694,40849,13649,3,3019,'App\\Models\\Receipt',3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',6050.00,NULL,NULL,1,'2023-07-24 20:17:22','2023-07-24 20:17:22',NULL),(4139,8694,40849,13649,3,3007,'App\\Models\\Receipt',3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',95542.93,NULL,NULL,1,'2023-07-24 20:18:13','2023-07-24 20:18:13',NULL),(4140,8694,40849,13649,3,3002,'App\\Models\\Receipt',3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',93514.25,NULL,NULL,1,'2023-07-24 20:19:02','2023-07-24 20:19:02',NULL),(4141,8694,40849,13649,3,3000,'App\\Models\\Receipt',3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',95320.17,NULL,NULL,1,'2023-07-24 20:19:59','2023-07-24 20:19:59',NULL),(4142,8694,40849,13649,3,3035,'App\\Models\\Receipt',3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',97231.97,NULL,NULL,1,'2023-07-24 20:20:41','2023-07-24 20:20:41',NULL),(4143,8694,40849,13649,3,3022,'App\\Models\\Receipt',3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',98990.10,NULL,NULL,1,'2023-07-24 20:22:00','2023-07-24 20:22:00',NULL),(4144,8694,40849,13649,3,3010,'App\\Models\\Receipt',3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',93651.35,NULL,NULL,1,'2023-07-24 20:23:09','2023-07-24 20:23:09',NULL),(4145,8694,40849,13649,3,3030,'App\\Models\\Receipt',3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',158510.00,NULL,NULL,1,'2023-07-24 20:24:14','2023-07-24 20:24:14',NULL),(4146,8694,40849,13649,3,3020,'App\\Models\\Receipt',3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',9560.24,NULL,NULL,1,'2023-07-24 20:28:24','2023-07-24 20:28:24',NULL),(4147,8694,40849,13649,3,3015,'App\\Models\\Receipt',3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',11268.04,NULL,NULL,1,'2023-07-24 20:30:49','2023-07-24 20:30:49',NULL),(4148,8694,40849,13649,3,3004,'App\\Models\\Receipt',3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',4084.11,NULL,NULL,1,'2023-07-24 20:32:50','2023-07-24 20:32:50',NULL),(4149,8694,40849,13649,3,3008,'App\\Models\\Receipt',3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',13636.35,NULL,NULL,1,'2023-07-24 20:34:53','2023-07-24 20:34:53',NULL),(4150,8694,40849,13649,3,3012,'App\\Models\\Receipt',3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',9200.08,NULL,NULL,1,'2023-07-24 20:36:17','2023-07-24 20:36:17',NULL),(4151,8694,40849,13649,3,3021,'App\\Models\\Receipt',3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',14158.06,NULL,NULL,1,'2023-07-24 20:37:36','2023-07-24 20:37:36',NULL),(4152,8694,40849,13649,3,3029,'App\\Models\\Receipt',3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',21306.42,NULL,NULL,1,'2023-07-24 20:39:03','2023-07-24 20:39:03',NULL),(4153,8694,40849,13649,3,3017,'App\\Models\\Receipt',3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',10000.00,NULL,NULL,1,'2023-07-24 20:39:44','2023-07-24 20:39:44',NULL),(4154,8694,40849,13649,3,3039,'App\\Models\\Receipt',3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',71452.25,NULL,NULL,1,'2023-07-24 21:13:39','2023-07-24 21:13:39',NULL);
INSERT INTO `balance_libro` VALUES (4155,8694,40839,12134,2,3040,'App\\Models\\Receipt',3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',302500.00,NULL,NULL,1,'2023-07-25 00:12:31','2023-07-25 00:14:23','2023-07-25 00:14:23'),(4156,8694,40839,12134,2,3041,'App\\Models\\Receipt',3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',121000.00,NULL,NULL,1,'2023-07-25 00:12:31','2023-07-25 00:14:50','2023-07-25 00:14:50'),(4157,8694,40839,12134,2,3042,'App\\Models\\Receipt',3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',121000.00,NULL,NULL,1,'2023-07-25 00:12:32','2023-07-25 00:15:16','2023-07-25 00:15:16'),(4158,8694,40839,12134,3,3043,'App\\Models\\Receipt',3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',300.00,NULL,NULL,1,'2023-07-25 00:12:47','2023-07-25 00:16:34','2023-07-25 00:16:34'),(4159,8694,40839,12134,3,3044,'App\\Models\\Receipt',3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',1001.60,NULL,NULL,1,'2023-07-25 00:12:47','2023-07-25 00:16:46','2023-07-25 00:16:46'),(4160,8694,40839,12134,3,3045,'App\\Models\\Receipt',3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',150.00,NULL,NULL,1,'2023-07-25 00:12:48','2023-07-25 00:16:57','2023-07-25 00:16:57'),(4161,8694,40839,12134,3,3046,'App\\Models\\Receipt',3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',134244.96,NULL,NULL,1,'2023-07-25 00:12:48','2023-07-26 20:01:11','2023-07-26 20:01:11'),(4162,8694,40839,12134,3,3047,'App\\Models\\Receipt',3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',3324.68,NULL,NULL,1,'2023-07-25 00:12:48','2023-07-25 00:12:48',NULL),(4163,8694,40839,12134,3,3048,'App\\Models\\Receipt',3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',38839.67,NULL,NULL,1,'2023-07-25 00:12:48','2023-07-25 00:35:08','2023-07-25 00:35:08'),(4164,8694,40839,12134,3,3049,'App\\Models\\Receipt',3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',6579.56,NULL,NULL,1,'2023-07-25 00:12:48','2023-07-25 00:17:25','2023-07-25 00:17:25'),(4165,8694,40839,12134,3,3050,'App\\Models\\Receipt',3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',5499.00,NULL,NULL,1,'2023-07-25 00:12:48','2023-07-25 00:22:11','2023-07-25 00:22:11'),(4166,8694,40839,12134,3,3051,'App\\Models\\Receipt',3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',999.00,NULL,NULL,1,'2023-07-25 00:12:48','2023-07-25 00:12:48',NULL),(4167,8694,40839,12134,3,3052,'App\\Models\\Receipt',3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',10000.00,NULL,NULL,1,'2023-07-25 00:12:48','2023-07-25 00:55:34','2023-07-25 00:55:34'),(4168,8694,40839,12134,3,3053,'App\\Models\\Receipt',3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',11734.90,NULL,NULL,1,'2023-07-25 00:12:48','2023-07-25 00:31:00','2023-07-25 00:31:00'),(4169,8694,40839,12134,3,3054,'App\\Models\\Receipt',3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',20.00,NULL,NULL,1,'2023-07-25 00:12:48','2023-07-25 00:17:47','2023-07-25 00:17:47'),(4170,8694,40839,12134,3,3055,'App\\Models\\Receipt',3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',250.00,NULL,NULL,1,'2023-07-25 00:12:48','2023-07-25 00:17:57','2023-07-25 00:17:57'),(4171,8694,40839,12134,3,3056,'App\\Models\\Receipt',3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',12053.85,NULL,NULL,1,'2023-07-25 00:12:49','2023-07-25 00:55:02','2023-07-25 00:55:02'),(4172,8694,40839,12134,3,3057,'App\\Models\\Receipt',3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',433.66,NULL,NULL,1,'2023-07-25 00:12:49','2023-07-25 00:18:12','2023-07-25 00:18:12'),(4173,8694,40839,12134,3,3058,'App\\Models\\Receipt',3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',11702.99,NULL,NULL,1,'2023-07-25 00:12:49','2023-07-25 00:50:03','2023-07-25 00:50:03');
INSERT INTO `balance_libro` VALUES (4174,8694,40839,12134,3,3059,'App\\Models\\Receipt',3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',40800.00,NULL,NULL,1,'2023-07-25 00:12:49','2023-07-25 00:20:05','2023-07-25 00:20:05'),(4175,8694,40839,12134,3,3060,'App\\Models\\Receipt',3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1665.00,NULL,NULL,1,'2023-07-25 00:12:49','2023-07-25 00:20:18','2023-07-25 00:20:18'),(4176,8694,40839,12134,3,3061,'App\\Models\\Receipt',3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',29667.26,NULL,NULL,1,'2023-07-25 00:12:49','2023-07-25 00:23:55','2023-07-25 00:23:55'),(4177,8694,40839,12134,2,3040,'App\\Models\\Receipt',3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',302500.00,NULL,NULL,1,'2023-07-25 00:14:23','2023-07-25 00:14:23',NULL),(4178,8694,40839,12134,2,3041,'App\\Models\\Receipt',3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',121000.00,NULL,NULL,1,'2023-07-25 00:14:50','2023-07-25 00:14:50',NULL),(4179,8694,40839,12134,2,3042,'App\\Models\\Receipt',3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',121000.00,NULL,NULL,1,'2023-07-25 00:15:16','2023-07-25 00:15:16',NULL),(4180,8694,40839,12134,3,3050,'App\\Models\\Receipt',3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',5499.00,NULL,NULL,1,'2023-07-25 00:22:11','2023-07-25 00:22:11',NULL),(4181,8694,40839,12134,3,3061,'App\\Models\\Receipt',3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',29667.26,NULL,NULL,1,'2023-07-25 00:23:55','2023-07-25 00:23:55',NULL),(4182,8694,40839,12134,3,3053,'App\\Models\\Receipt',3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',11734.90,NULL,NULL,1,'2023-07-25 00:31:00','2023-07-26 20:12:59','2023-07-26 20:12:59'),(4183,8694,40839,12134,3,3048,'App\\Models\\Receipt',3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',38839.67,NULL,NULL,1,'2023-07-25 00:35:08','2023-07-25 00:35:08',NULL),(4184,8694,40839,12134,3,3062,'App\\Models\\Receipt',3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',5837.49,NULL,NULL,1,'2023-07-25 00:40:04','2023-07-25 00:40:04',NULL),(4185,8694,40839,12134,3,3063,'App\\Models\\Receipt',3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',11700.13,NULL,NULL,1,'2023-07-25 00:42:48','2023-07-25 00:42:48',NULL),(4186,8694,40839,12134,3,3064,'App\\Models\\Receipt',3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',8200.27,NULL,NULL,1,'2023-07-25 00:45:47','2023-07-25 00:45:47',NULL),(4187,8694,40839,12134,3,3058,'App\\Models\\Receipt',3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',11702.99,NULL,NULL,1,'2023-07-25 00:50:03','2023-07-25 00:50:03',NULL),(4188,8694,40839,12134,3,3056,'App\\Models\\Receipt',3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',12053.85,NULL,NULL,1,'2023-07-25 00:55:02','2023-09-03 19:58:56','2023-09-03 19:58:56'),(4189,8694,40839,12134,3,3052,'App\\Models\\Receipt',3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',10000.00,NULL,NULL,1,'2023-07-25 00:55:34','2023-07-25 00:55:34',NULL),(4190,8694,40856,15161,2,3065,'App\\Models\\Receipt',3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',212058.55,NULL,NULL,1,'2023-07-25 20:30:11','2023-07-25 20:32:30','2023-07-25 20:32:30'),(4191,8694,40856,15161,3,3066,'App\\Models\\Receipt',3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',6737.99,NULL,NULL,1,'2023-07-25 20:30:26','2023-07-25 20:33:30','2023-07-25 20:33:30'),(4192,8694,40856,15161,3,3067,'App\\Models\\Receipt',3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',1027.90,NULL,NULL,1,'2023-07-25 20:30:26','2023-07-25 21:01:13','2023-07-25 21:01:13'),(4193,8694,40856,15161,3,3068,'App\\Models\\Receipt',3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',32478.30,NULL,NULL,1,'2023-07-25 20:30:26','2023-07-25 20:45:32','2023-07-25 20:45:32');
INSERT INTO `balance_libro` VALUES (4194,8694,40856,15161,3,3069,'App\\Models\\Receipt',3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',5799.99,NULL,NULL,1,'2023-07-25 20:30:26','2023-07-25 21:02:51','2023-07-25 21:02:51'),(4195,8694,40856,15161,3,3070,'App\\Models\\Receipt',3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',301.24,NULL,NULL,1,'2023-07-25 20:30:26','2023-07-26 22:27:33','2023-07-26 22:27:33'),(4196,8694,40856,15161,3,3071,'App\\Models\\Receipt',3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',2264.26,NULL,NULL,1,'2023-07-25 20:30:26','2023-07-26 22:28:09','2023-07-26 22:28:09'),(4197,8694,40856,15161,3,3072,'App\\Models\\Receipt',3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',8268.10,NULL,NULL,1,'2023-07-25 20:30:26','2023-07-25 20:44:04','2023-07-25 20:44:04'),(4198,8694,40856,15161,3,3073,'App\\Models\\Receipt',3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',11000.00,NULL,NULL,1,'2023-07-25 20:30:26','2023-07-25 20:33:57','2023-07-25 20:33:57'),(4199,8694,40856,15161,3,3074,'App\\Models\\Receipt',3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',11000.00,NULL,NULL,1,'2023-07-25 20:30:26','2023-07-25 21:20:06','2023-07-25 21:20:06'),(4200,8694,40856,15161,3,3075,'App\\Models\\Receipt',3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',401.65,NULL,NULL,1,'2023-07-25 20:30:26','2023-07-26 22:28:29','2023-07-26 22:28:29'),(4201,8694,40856,15161,3,3076,'App\\Models\\Receipt',3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',67742.78,NULL,NULL,1,'2023-07-25 20:30:27','2023-07-25 21:26:31','2023-07-25 21:26:31'),(4202,8694,40856,15161,3,3077,'App\\Models\\Receipt',3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',14719.00,NULL,NULL,1,'2023-07-25 20:30:27','2023-07-25 20:34:19','2023-07-25 20:34:19'),(4203,8694,40856,15161,3,3078,'App\\Models\\Receipt',3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',8500.55,NULL,NULL,1,'2023-07-25 20:30:27','2023-07-25 21:04:31','2023-07-25 21:04:31'),(4204,8694,40856,15161,3,3079,'App\\Models\\Receipt',3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',2490.00,NULL,NULL,1,'2023-07-25 20:30:27','2023-07-25 20:34:37','2023-07-25 20:34:37'),(4205,8694,40856,15161,3,3080,'App\\Models\\Receipt',3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',6737.99,NULL,NULL,1,'2023-07-25 20:30:27','2023-07-25 20:34:52','2023-07-25 20:34:52'),(4206,8694,40856,15161,3,3081,'App\\Models\\Receipt',3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',5990.00,NULL,NULL,1,'2023-07-25 20:30:27','2023-07-25 20:53:44','2023-07-25 20:53:44'),(4207,8694,40856,15161,3,3082,'App\\Models\\Receipt',3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',83592.85,NULL,NULL,1,'2023-07-25 20:30:27','2023-07-25 20:46:20','2023-07-25 20:46:20'),(4208,8694,40856,15161,3,3083,'App\\Models\\Receipt',3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',11000.00,NULL,NULL,1,'2023-07-25 20:30:27','2023-07-25 21:20:53','2023-07-25 21:20:53'),(4209,8694,40856,15161,3,3084,'App\\Models\\Receipt',3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',602.48,NULL,NULL,1,'2023-07-25 20:30:27','2023-07-26 22:27:21','2023-07-26 22:27:21'),(4210,8694,40856,15161,3,3085,'App\\Models\\Receipt',3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',7900.00,NULL,NULL,1,'2023-07-25 20:30:27','2023-07-25 21:08:57','2023-07-25 21:08:57'),(4211,8694,40856,15161,3,3086,'App\\Models\\Receipt',3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',502.07,NULL,NULL,1,'2023-07-25 20:30:27','2023-07-26 22:28:39','2023-07-26 22:28:39'),(4212,8694,40856,15161,3,3087,'App\\Models\\Receipt',3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',431.16,NULL,NULL,1,'2023-07-25 20:30:28','2023-07-26 22:28:19','2023-07-26 22:28:19');
INSERT INTO `balance_libro` VALUES (4213,8694,40856,15161,3,3088,'App\\Models\\Receipt',3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',7932.88,NULL,NULL,1,'2023-07-25 20:30:28','2023-07-25 20:59:48','2023-07-25 20:59:48'),(4214,8694,40856,15161,3,3089,'App\\Models\\Receipt',3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',3845.02,NULL,NULL,1,'2023-07-25 20:30:28','2023-07-26 22:29:30','2023-07-26 22:29:30'),(4215,8694,40856,15161,3,3090,'App\\Models\\Receipt',3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',4746.99,NULL,NULL,1,'2023-07-25 20:30:28','2023-07-25 20:35:17','2023-07-25 20:35:17'),(4216,8694,40856,15161,3,3091,'App\\Models\\Receipt',3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',100.00,NULL,NULL,1,'2023-07-25 20:30:28','2023-07-25 20:30:28',NULL),(4217,8694,40856,15161,3,3092,'App\\Models\\Receipt',3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',7580.00,NULL,NULL,1,'2023-07-25 20:30:28','2023-07-25 20:30:28',NULL),(4218,8694,40856,15161,2,3065,'App\\Models\\Receipt',3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',212058.55,NULL,NULL,1,'2023-07-25 20:32:30','2023-07-25 20:32:30',NULL),(4219,8694,40856,15161,3,3093,'App\\Models\\Receipt',3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',75804.93,NULL,NULL,1,'2023-07-25 20:42:39','2023-08-27 00:23:16','2023-08-27 00:23:16'),(4220,8694,40856,15161,3,3072,'App\\Models\\Receipt',3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',8268.10,NULL,NULL,1,'2023-07-25 20:44:04','2023-07-25 20:44:04',NULL),(4221,8694,40856,15161,3,3068,'App\\Models\\Receipt',3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',32478.30,NULL,NULL,1,'2023-07-25 20:45:32','2023-07-25 20:45:32',NULL),(4222,8694,40856,15161,3,3082,'App\\Models\\Receipt',3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',83592.85,NULL,NULL,1,'2023-07-25 20:46:20','2023-07-25 20:46:20',NULL),(4223,8694,40856,15161,3,3094,'App\\Models\\Receipt',3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',14719.00,NULL,NULL,1,'2023-07-25 20:52:08','2023-07-25 20:52:08',NULL),(4224,8694,40856,15161,3,3081,'App\\Models\\Receipt',3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',5990.00,NULL,NULL,1,'2023-07-25 20:53:44','2023-07-25 20:53:44',NULL),(4225,8694,40856,15161,3,3088,'App\\Models\\Receipt',3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',7932.87,NULL,NULL,1,'2023-07-25 20:59:48','2023-07-25 20:59:48',NULL),(4226,8694,40856,15161,3,3067,'App\\Models\\Receipt',3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',1027.90,NULL,NULL,1,'2023-07-25 21:01:13','2023-07-25 21:01:13',NULL),(4227,8694,40856,15161,3,3069,'App\\Models\\Receipt',3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',5800.00,NULL,NULL,1,'2023-07-25 21:02:51','2023-07-25 21:02:51',NULL),(4228,8694,40856,15161,3,3078,'App\\Models\\Receipt',3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',8500.55,NULL,NULL,1,'2023-07-25 21:04:31','2023-07-25 21:04:31',NULL),(4229,8694,40856,15161,3,3085,'App\\Models\\Receipt',3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',7900.01,NULL,NULL,1,'2023-07-25 21:08:57','2023-07-25 21:08:57',NULL),(4230,8694,40856,15161,3,3074,'App\\Models\\Receipt',3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',11000.00,NULL,NULL,1,'2023-07-25 21:20:06','2023-07-25 21:20:06',NULL),(4231,8694,40856,15161,3,3083,'App\\Models\\Receipt',3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',11000.00,NULL,NULL,1,'2023-07-25 21:20:53','2023-07-25 21:20:53',NULL),(4232,8694,40856,15161,3,3095,'App\\Models\\Receipt',3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',5000.00,NULL,NULL,1,'2023-07-25 21:24:51','2023-07-25 21:24:51',NULL);
INSERT INTO `balance_libro` VALUES (4233,8694,40856,15161,3,3076,'App\\Models\\Receipt',3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',67742.78,NULL,NULL,1,'2023-07-25 21:26:31','2023-07-25 21:26:31',NULL),(4234,8694,40856,15161,3,3096,'App\\Models\\Receipt',3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',27600.00,NULL,NULL,1,'2023-07-25 21:30:29','2023-07-25 21:30:29',NULL),(4235,8694,40856,15161,3,3097,'App\\Models\\Receipt',3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',4000.27,NULL,NULL,1,'2023-07-25 21:33:15','2023-07-25 21:33:15',NULL),(4236,8694,40875,16673,2,3098,'App\\Models\\Receipt',3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',28000.00,NULL,NULL,1,'2023-07-25 21:38:35','2023-07-26 00:07:32','2023-07-26 00:07:32'),(4237,8694,40875,16673,2,3099,'App\\Models\\Receipt',3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',31636.17,NULL,NULL,1,'2023-07-25 21:38:35','2023-07-26 00:08:12','2023-07-26 00:08:12'),(4238,8694,40875,16673,2,3100,'App\\Models\\Receipt',3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',7500.00,NULL,NULL,1,'2023-07-25 21:38:35','2023-07-26 00:10:55','2023-07-26 00:10:55'),(4239,8694,40875,16673,2,3101,'App\\Models\\Receipt',3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',2980129.00,NULL,NULL,1,'2023-07-25 21:38:35','2023-07-26 00:04:20','2023-07-26 00:04:20'),(4240,8694,40875,16673,2,3102,'App\\Models\\Receipt',3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',28000.00,NULL,NULL,1,'2023-07-25 21:38:36','2023-07-26 00:11:57','2023-07-26 00:11:57'),(4241,8694,40875,16673,2,3103,'App\\Models\\Receipt',3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',17575.65,NULL,NULL,1,'2023-07-25 21:38:36','2023-07-26 00:13:46','2023-07-26 00:13:46'),(4242,8694,40875,16673,2,3104,'App\\Models\\Receipt',3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',31636.17,NULL,NULL,1,'2023-07-25 21:38:36','2023-07-26 00:14:09','2023-07-26 00:14:09'),(4243,8694,40875,16673,2,3105,'App\\Models\\Receipt',3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',28000.00,NULL,NULL,1,'2023-07-25 21:38:36','2023-07-26 00:11:21','2023-07-26 00:11:21'),(4244,8694,40875,16673,2,3106,'App\\Models\\Receipt',3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',16700.00,NULL,NULL,1,'2023-07-25 21:38:36','2023-07-26 00:15:20','2023-07-26 00:15:20'),(4245,8694,40875,16673,2,3107,'App\\Models\\Receipt',3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',16700.00,NULL,NULL,1,'2023-07-25 21:38:36','2023-07-26 00:14:30','2023-07-26 00:14:30'),(4246,8694,40875,16673,3,3108,'App\\Models\\Receipt',3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',41359.00,NULL,NULL,1,'2023-07-25 21:38:50','2023-07-26 00:16:40','2023-07-26 00:16:40'),(4247,8694,40875,16673,3,3109,'App\\Models\\Receipt',3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',9998.00,NULL,NULL,1,'2023-07-25 21:38:50','2023-07-26 00:16:51','2023-07-26 00:16:51'),(4248,8694,40875,16673,3,3110,'App\\Models\\Receipt',3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',8500.00,NULL,NULL,1,'2023-07-25 21:38:50','2023-07-26 00:17:04','2023-07-26 00:17:04'),(4249,8694,40875,16673,3,3111,'App\\Models\\Receipt',3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',249027.68,NULL,NULL,1,'2023-07-25 21:38:50','2023-07-26 01:07:48','2023-07-26 01:07:48'),(4250,8694,40875,16673,3,3112,'App\\Models\\Receipt',3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',55414.65,NULL,NULL,1,'2023-07-25 21:38:50','2023-07-25 21:38:50',NULL),(4251,8694,40875,16673,3,3113,'App\\Models\\Receipt',3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',11000.00,NULL,NULL,1,'2023-07-25 21:38:50','2023-07-25 21:38:50',NULL);
INSERT INTO `balance_libro` VALUES (4252,8694,40875,16673,3,3114,'App\\Models\\Receipt',3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',27979.98,NULL,NULL,1,'2023-07-25 21:38:50','2023-07-25 21:38:50',NULL),(4253,8694,40875,16673,3,3115,'App\\Models\\Receipt',3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',212540.06,NULL,NULL,1,'2023-07-25 21:38:50','2023-07-26 01:15:30','2023-07-26 01:15:30'),(4254,8694,40875,16673,3,3116,'App\\Models\\Receipt',3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',24500.01,NULL,NULL,1,'2023-07-25 21:38:50','2023-07-25 21:38:50',NULL),(4255,8694,40875,16673,3,3117,'App\\Models\\Receipt',3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',100.00,NULL,NULL,1,'2023-07-25 21:38:50','2023-07-26 23:06:06','2023-07-26 23:06:06'),(4256,8694,40875,16673,3,3118,'App\\Models\\Receipt',3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',3508.96,NULL,NULL,1,'2023-07-25 21:38:50','2023-07-26 23:07:15','2023-07-26 23:07:15'),(4257,8694,40875,16673,3,3119,'App\\Models\\Receipt',3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',86878.00,NULL,NULL,1,'2023-07-25 21:38:51','2023-07-26 01:17:17','2023-07-26 01:17:17'),(4258,8694,40875,16673,3,3120,'App\\Models\\Receipt',3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',3508.96,NULL,NULL,1,'2023-07-25 21:38:51','2023-07-26 23:07:39','2023-07-26 23:07:39'),(4259,8694,40875,16673,3,3121,'App\\Models\\Receipt',3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',11703.49,NULL,NULL,1,'2023-07-25 21:38:51','2023-07-26 00:31:51','2023-07-26 00:31:51'),(4260,8694,40875,16673,3,3122,'App\\Models\\Receipt',3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',13189.00,NULL,NULL,1,'2023-07-25 21:38:51','2023-07-26 00:57:36','2023-07-26 00:57:36'),(4261,8694,40875,16673,3,3123,'App\\Models\\Receipt',3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',47415.00,NULL,NULL,1,'2023-07-25 21:38:51','2023-07-25 21:38:51',NULL),(4262,8694,40875,16673,3,3124,'App\\Models\\Receipt',3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',2360.00,NULL,NULL,1,'2023-07-25 21:38:51','2023-07-26 00:17:44','2023-07-26 00:17:44'),(4263,8694,40875,16673,3,3125,'App\\Models\\Receipt',3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',23281.59,NULL,NULL,1,'2023-07-25 21:38:51','2023-07-26 00:17:57','2023-07-26 00:17:57'),(4264,8694,40875,16673,3,3126,'App\\Models\\Receipt',3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',188760.00,NULL,NULL,1,'2023-07-25 21:38:51','2023-07-26 01:16:42','2023-07-26 01:16:42'),(4265,8694,40875,16673,3,3127,'App\\Models\\Receipt',3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',4531.74,NULL,NULL,1,'2023-07-25 21:38:51','2023-07-26 00:18:12','2023-07-26 00:18:12'),(4266,8694,40875,16673,3,3128,'App\\Models\\Receipt',3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',9500.00,NULL,NULL,1,'2023-07-25 21:38:51','2023-07-26 01:19:49','2023-07-26 01:19:49'),(4267,8694,40875,16673,3,3129,'App\\Models\\Receipt',3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',4531.74,NULL,NULL,1,'2023-07-25 21:38:51','2023-07-26 00:18:26','2023-07-26 00:18:26'),(4268,8694,40875,16673,3,3130,'App\\Models\\Receipt',3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',4531.74,NULL,NULL,1,'2023-07-25 21:38:51','2023-07-26 23:08:33','2023-07-26 23:08:33'),(4269,8694,40875,16673,3,3131,'App\\Models\\Receipt',3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',13048.72,NULL,NULL,1,'2023-07-25 21:38:52','2023-07-26 00:55:45','2023-07-26 00:55:45'),(4270,8694,40875,16673,3,3132,'App\\Models\\Receipt',3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',258.26,NULL,NULL,1,'2023-07-25 21:38:52','2023-07-26 23:06:17','2023-07-26 23:06:17');
INSERT INTO `balance_libro` VALUES (4271,8694,40875,16673,3,3133,'App\\Models\\Receipt',3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-18','2023-06-18',20461.97,NULL,NULL,1,'2023-07-25 21:38:52','2023-07-26 00:29:57','2023-07-26 00:29:57'),(4272,8694,40875,16673,3,3134,'App\\Models\\Receipt',3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-18','2023-06-18',25900.00,NULL,NULL,1,'2023-07-25 21:38:52','2023-07-26 00:58:40','2023-07-26 00:58:40'),(4273,8694,40875,16673,3,3135,'App\\Models\\Receipt',3135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',14950.00,NULL,NULL,1,'2023-07-25 21:38:52','2023-07-26 23:08:46','2023-07-26 23:08:46'),(4274,8694,40875,16673,3,3136,'App\\Models\\Receipt',3136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',1296.22,NULL,NULL,1,'2023-07-25 21:38:52','2023-07-26 23:06:46','2023-07-26 23:06:46'),(4275,8694,40875,16673,3,3137,'App\\Models\\Receipt',3137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-20','2023-06-20',2005.00,NULL,NULL,1,'2023-07-25 21:38:52','2023-07-26 00:18:46','2023-07-26 00:18:46'),(4276,8694,40875,16673,3,3138,'App\\Models\\Receipt',3138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',9748.60,NULL,NULL,1,'2023-07-25 21:38:52','2023-07-26 01:03:31','2023-07-26 01:03:31'),(4277,8694,40875,16673,3,3139,'App\\Models\\Receipt',3139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',18232.96,NULL,NULL,1,'2023-07-25 21:38:52','2023-07-26 01:14:37','2023-07-26 01:14:37'),(4278,8694,40875,16673,3,3140,'App\\Models\\Receipt',3140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',37026.00,NULL,NULL,1,'2023-07-25 21:38:52','2023-07-26 01:12:30','2023-07-26 01:12:30'),(4279,8694,40875,16673,3,3141,'App\\Models\\Receipt',3141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',37508.76,NULL,NULL,1,'2023-07-25 21:38:52','2023-07-25 21:38:52',NULL),(4280,8694,40875,16673,3,3142,'App\\Models\\Receipt',3142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',169400.00,NULL,NULL,1,'2023-07-25 21:38:52','2023-07-26 01:18:46','2023-07-26 01:18:46'),(4281,8694,40875,16673,3,3143,'App\\Models\\Receipt',3143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',13000.00,NULL,NULL,1,'2023-07-25 21:38:52','2023-07-25 21:38:52',NULL),(4282,8694,40875,16673,3,3144,'App\\Models\\Receipt',3144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',7810.00,NULL,NULL,1,'2023-07-25 21:38:53','2023-07-25 21:38:53',NULL),(4283,8694,40875,16673,3,3145,'App\\Models\\Receipt',3145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',23050.80,NULL,NULL,1,'2023-07-25 21:38:53','2023-07-25 21:38:53',NULL),(4284,8694,40875,16673,3,3146,'App\\Models\\Receipt',3146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',99220.00,NULL,NULL,1,'2023-07-25 21:38:53','2023-07-26 01:19:17','2023-07-26 01:19:17'),(4285,8694,40875,16673,3,3147,'App\\Models\\Receipt',3147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',179080.00,NULL,NULL,1,'2023-07-25 21:38:53','2023-07-26 01:18:13','2023-07-26 01:18:13'),(4286,8694,40875,16673,3,3148,'App\\Models\\Receipt',3148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',209814.00,NULL,NULL,1,'2023-07-25 21:38:53','2023-07-26 01:09:07','2023-07-26 01:09:07'),(4287,8694,40875,16673,3,3149,'App\\Models\\Receipt',3149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',181500.00,NULL,NULL,1,'2023-07-25 21:38:53','2023-07-26 01:17:47','2023-07-26 01:17:47'),(4288,8694,40875,16673,3,3150,'App\\Models\\Receipt',3150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',268620.00,NULL,NULL,1,'2023-07-25 21:38:53','2023-07-26 01:10:49','2023-07-26 01:10:49'),(4289,8694,40875,16673,3,3151,'App\\Models\\Receipt',3151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',14200.00,NULL,NULL,1,'2023-07-25 21:38:53','2023-07-25 21:38:53',NULL);
INSERT INTO `balance_libro` VALUES (4290,8694,40875,16673,3,3152,'App\\Models\\Receipt',3152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',2796.24,NULL,NULL,1,'2023-07-25 21:38:53','2023-07-26 00:18:59','2023-07-26 00:18:59'),(4291,8694,40875,16673,3,3153,'App\\Models\\Receipt',3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',123902.79,NULL,NULL,1,'2023-07-25 21:38:53','2023-07-26 00:21:10','2023-07-26 00:21:10'),(4292,8694,40875,16673,2,3101,'App\\Models\\Receipt',3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',2980129.00,NULL,NULL,1,'2023-07-26 00:04:20','2023-07-27 08:04:19','2023-07-27 08:04:19'),(4293,8694,40875,16673,2,3098,'App\\Models\\Receipt',3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',28000.00,NULL,NULL,1,'2023-07-26 00:07:32','2023-07-26 00:07:32',NULL),(4294,8694,40875,16673,2,3099,'App\\Models\\Receipt',3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',31636.17,NULL,NULL,1,'2023-07-26 00:08:12','2023-07-26 00:08:12',NULL),(4295,8694,40875,16673,2,3100,'App\\Models\\Receipt',3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',7500.00,NULL,NULL,1,'2023-07-26 00:10:55','2023-07-26 00:10:55',NULL),(4296,8694,40875,16673,2,3105,'App\\Models\\Receipt',3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',28000.00,NULL,NULL,1,'2023-07-26 00:11:21','2023-07-26 00:11:21',NULL),(4297,8694,40875,16673,2,3102,'App\\Models\\Receipt',3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',28000.00,NULL,NULL,1,'2023-07-26 00:11:57','2023-07-26 00:11:57',NULL),(4298,8694,40875,16673,2,3103,'App\\Models\\Receipt',3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',17575.65,NULL,NULL,1,'2023-07-26 00:13:46','2023-07-26 00:13:46',NULL),(4299,8694,40875,16673,2,3104,'App\\Models\\Receipt',3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',31636.17,NULL,NULL,1,'2023-07-26 00:14:09','2023-07-26 00:14:09',NULL),(4300,8694,40875,16673,2,3107,'App\\Models\\Receipt',3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',16700.00,NULL,NULL,1,'2023-07-26 00:14:30','2023-07-26 00:14:30',NULL),(4301,8694,40875,16673,2,3106,'App\\Models\\Receipt',3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',16700.00,NULL,NULL,1,'2023-07-26 00:15:20','2023-07-26 00:15:20',NULL),(4302,8694,40875,16673,3,3153,'App\\Models\\Receipt',3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',123902.79,NULL,NULL,1,'2023-07-26 00:21:10','2023-07-26 00:21:10',NULL),(4303,8694,40875,16673,3,3133,'App\\Models\\Receipt',3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-18','2023-06-18',20461.97,NULL,NULL,1,'2023-07-26 00:29:57','2023-07-26 00:29:57',NULL),(4304,8694,40875,16673,3,3121,'App\\Models\\Receipt',3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',11703.49,NULL,NULL,1,'2023-07-26 00:31:51','2023-07-2