-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-22697418-6
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-11-08 11:40:46','Actividad Generica 1','000001',NULL),(2,NULL,'2022-11-08 11:40:46','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,'A.F.I.P.','GBBerg4186',NULL,1,40719,'2023-01-24');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'estudioberg@cpenet.com.ar','2302485649',NULL,1,40719,'2022-11-11'),(2,'estudioberg@cpenet.com.ar','2302485649','',1,40719,'2022-11-11'),(3,'estudioberg@cpenet.com.ar','2302485649','',1,40719,'2023-01-13'),(4,'estudioberg@cpenet.com.ar','2302485649','',1,40719,'2023-01-13'),(5,'estudioberg@cpenet.com.ar','2302485649','',1,40719,'2023-01-13'),(6,'estudioberg@cpenet.com.ar','2302485649','',1,40719,'2023-01-14'),(7,'estudioberg@cpenet.com.ar','2302485649','',1,40719,'2023-01-24');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=430 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,8082,40719,3,2,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',25250.00,NULL,NULL,1,'2022-11-10 13:08:20','2022-11-11 13:02:50','2022-11-11 13:02:50'),(2,8082,40719,3,3,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',12500.00,NULL,NULL,1,'2022-11-10 13:11:52','2022-11-11 13:02:57','2022-11-11 13:02:57'),(3,8082,40720,1527,3,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',31623.72,NULL,NULL,1,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(4,8082,40720,1527,3,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',65239.20,NULL,NULL,1,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(5,8082,40720,1527,3,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',89720.00,NULL,NULL,1,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(6,8082,40720,1527,3,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',3380.00,NULL,NULL,1,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(7,8082,40720,1527,3,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',23982.26,NULL,NULL,1,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(8,8082,40720,1527,3,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',26837.80,NULL,NULL,1,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(9,8082,40720,1527,3,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',304891.16,NULL,NULL,1,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(10,8082,40720,1527,3,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',6851.86,NULL,NULL,1,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(11,8082,40720,1527,3,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',20493.16,NULL,NULL,1,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(12,8082,40720,1527,3,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',24632.49,NULL,NULL,1,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(13,8082,40720,1527,3,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',14762.23,NULL,NULL,1,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(14,8082,40720,1527,3,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',5689.35,NULL,NULL,1,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(15,8082,40720,1527,3,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',36180.43,NULL,NULL,1,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(16,8082,40720,1527,3,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',5000.01,NULL,NULL,1,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(17,8082,40720,1527,3,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',20912.19,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(18,8082,40720,1527,3,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',23193.57,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(19,8082,40720,1527,3,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',20244.22,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(20,8082,40720,1527,3,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',30275.62,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(21,8082,40720,1527,3,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3928.48,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL);
INSERT INTO `balance_libro` VALUES (22,8082,40720,1527,3,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',508.40,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(23,8082,40720,1527,3,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',19495.12,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(24,8082,40720,1527,3,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',8089.25,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(25,8082,40720,1527,3,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',39617.37,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(26,8082,40720,1527,3,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',50664.25,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(27,8082,40720,1527,3,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',6525.00,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(28,8082,40720,1527,3,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',5642.56,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(29,8082,40720,1527,3,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',18180.83,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(30,8082,40720,1527,3,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',14890.26,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(31,8082,40720,1527,3,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',18830.92,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(32,8082,40720,1527,3,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',49890.75,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(33,8082,40720,1527,3,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',3417.04,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(34,8082,40720,1527,3,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',29382.37,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(35,8082,40720,1527,3,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',37090.00,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(36,8082,40720,1527,3,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',71332.58,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(37,8082,40720,1527,3,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',7205.82,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(38,8082,40720,1527,3,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',700.00,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(39,8082,40720,1527,3,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',3420.41,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(40,8082,40720,1527,3,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',15738.43,NULL,NULL,1,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(41,8082,40720,1527,3,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',4736.30,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(42,8082,40720,1527,3,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',0.05,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL);
INSERT INTO `balance_libro` VALUES (43,8082,40720,1527,3,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',31602.21,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(44,8082,40720,1527,3,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',29796.46,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(45,8082,40720,1527,3,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',39215.42,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(46,8082,40720,1527,3,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',5818.48,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(47,8082,40720,1527,3,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',3830.24,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(48,8082,40720,1527,3,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',49224.90,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(49,8082,40720,1527,3,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',93641.28,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(50,8082,40720,1527,3,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',3921.00,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(51,8082,40720,1527,3,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',19790.00,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(52,8082,40720,1527,3,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',59697.52,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(53,8082,40720,1527,3,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',17119.47,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(54,8082,40720,1527,3,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',20404.03,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(55,8082,40720,1527,3,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',6015.27,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(56,8082,40720,1527,3,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',3472.73,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(57,8082,40720,1527,3,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',20367.31,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(58,8082,40720,1527,3,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',3204.37,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(59,8082,40720,1527,3,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',77365.36,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(60,8082,40720,1527,3,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',6761.10,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(61,8082,40720,1527,3,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2090.00,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(62,8082,40720,1527,3,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',24404.78,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(63,8082,40720,1527,3,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',46907.11,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL);
INSERT INTO `balance_libro` VALUES (64,8082,40720,1527,3,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',81741.76,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(65,8082,40720,1527,3,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',67570.75,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(66,8082,40720,1527,3,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',304100.18,NULL,NULL,1,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(67,8082,40720,1527,3,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',6908.48,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(68,8082,40720,1527,3,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',118425.00,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(69,8082,40720,1527,3,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',3900.00,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(70,8082,40720,1527,3,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',28008.32,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(71,8082,40720,1527,3,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',26053.03,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(72,8082,40720,1527,3,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',13758.16,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(73,8082,40720,1527,3,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',15305.29,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(74,8082,40720,1527,3,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',6239.59,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(75,8082,40720,1527,3,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1460.79,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(76,8082,40720,1527,3,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',36810.76,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(77,8082,40720,1527,3,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',25930.52,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(78,8082,40720,1527,3,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',15589.00,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(79,8082,40720,1527,3,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',19380.00,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(80,8082,40720,1527,3,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',9157.86,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(81,8082,40720,1527,3,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',20478.28,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(82,8082,40720,1527,3,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',20768.94,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(83,8082,40720,1527,3,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',7000.00,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(84,8082,40720,1527,3,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1191.08,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL);
INSERT INTO `balance_libro` VALUES (85,8082,40720,1527,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',29773.80,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(86,8082,40720,1527,3,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',17872.10,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(87,8082,40720,1527,3,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',6323.99,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(88,8082,40720,1527,3,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',4010.80,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(89,8082,40720,1527,3,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',10998.04,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(90,8082,40720,1527,3,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',15468.38,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(91,8082,40720,1527,3,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',14055.60,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(92,8082,40720,1527,3,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',41355.00,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(93,8082,40720,1527,3,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',52598.00,NULL,NULL,1,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(94,8082,40720,1527,3,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',52598.00,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(95,8082,40720,1527,3,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',13036.16,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(96,8082,40720,1527,3,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1509.95,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(97,8082,40720,1527,3,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',28262.84,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(98,8082,40720,1527,3,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',12027.30,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(99,8082,40720,1527,3,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',5472.38,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(100,8082,40720,1527,3,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',48637.12,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(101,8082,40720,1527,3,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',52598.00,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(102,8082,40720,1527,3,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',4648.00,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(103,8082,40720,1527,3,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',35714.48,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(104,8082,40720,1527,3,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',51389.46,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(105,8082,40720,1527,3,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',78.65,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL);
INSERT INTO `balance_libro` VALUES (106,8082,40720,1527,3,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',310896.03,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(107,8082,40720,1527,3,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',23162.01,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(108,8082,40720,1527,3,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',17439.13,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(109,8082,40720,1527,3,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',6556.86,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(110,8082,40720,1527,3,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',111860.02,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(111,8082,40720,1527,3,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2170.00,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(112,8082,40720,1527,3,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',31133.88,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(113,8082,40720,1527,3,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',10545.58,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(114,8082,40720,1527,3,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',19861.25,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(115,8082,40720,1527,3,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',9955.00,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(116,8082,40720,1527,3,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',10200.74,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(117,8082,40720,1527,3,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',28187.33,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(118,8082,40720,1527,3,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',2502.27,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(119,8082,40720,1527,3,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',24090.55,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(120,8082,40720,1527,3,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',33538.93,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(121,8082,40720,1527,3,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',28742.71,NULL,NULL,1,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(122,8082,40720,1527,3,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',20240.69,NULL,NULL,1,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(123,8082,40720,1527,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',5002.43,NULL,NULL,1,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(124,8082,40720,1527,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1887.44,NULL,NULL,1,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(125,8082,40720,1527,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',30477.65,NULL,NULL,1,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(126,8082,40720,1527,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',21706.51,NULL,NULL,1,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL);
INSERT INTO `balance_libro` VALUES (127,8082,40720,1527,3,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',4988.57,NULL,NULL,1,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(128,8082,40720,1527,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',13082.69,NULL,NULL,1,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(129,8082,40720,1527,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',46410.00,NULL,NULL,1,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(130,8082,40720,1527,3,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',33477.98,NULL,NULL,1,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(131,8082,40720,1527,3,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',970.81,NULL,NULL,1,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(132,8082,40720,1527,3,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',11200.00,NULL,NULL,1,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(133,8082,40720,1527,3,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',9300.00,NULL,NULL,1,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(134,8082,40720,1527,3,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',6408.73,NULL,NULL,1,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(135,8082,40720,1527,3,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2751.29,NULL,NULL,1,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(136,8082,40720,1527,3,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',45708.57,NULL,NULL,1,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(137,8082,40720,1527,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',40627.52,NULL,NULL,1,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(138,8082,40720,1527,3,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',2818.63,NULL,NULL,1,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(139,8082,40720,1527,3,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',51485.32,NULL,NULL,1,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(140,8082,40720,1527,3,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',30700.00,NULL,NULL,1,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(141,8082,40720,1527,3,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',60480.00,NULL,NULL,1,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(142,8082,40720,1527,3,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',29430.98,NULL,NULL,1,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(143,8082,40720,1527,3,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',27065.96,NULL,NULL,1,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(144,8082,40720,1527,3,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1899.02,NULL,NULL,1,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(145,8082,40720,1527,3,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',101700.00,NULL,NULL,1,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(146,8082,40720,1527,3,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',88695.63,NULL,NULL,1,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(147,8082,40720,1527,3,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',18695.30,NULL,NULL,1,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL);
INSERT INTO `balance_libro` VALUES (148,8082,40720,1527,3,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',61880.00,NULL,NULL,1,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(149,8082,40720,1527,3,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',265727.63,NULL,NULL,1,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(150,8082,40720,1527,3,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1924.79,NULL,NULL,1,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(151,8082,40720,1527,3,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',10072.44,NULL,NULL,1,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(152,8082,40721,3037,2,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',208144.20,NULL,NULL,1,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(153,8082,40721,3037,2,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',237482.46,NULL,NULL,1,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(154,8082,40721,3037,2,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',72006.06,NULL,NULL,1,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(155,8082,40721,3037,2,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-07','2022-08-07',14820.04,NULL,NULL,1,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(156,8082,40721,3037,2,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-07','2022-08-07',379076.06,NULL,NULL,1,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(157,8082,40721,3037,2,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',196504.00,NULL,NULL,1,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(158,8082,40721,3037,2,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',320948.68,NULL,NULL,1,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(159,8082,40721,3037,2,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',40656.00,NULL,NULL,1,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(160,8082,40721,3037,2,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',74140.06,NULL,NULL,1,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(161,8082,40721,3037,2,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',323258.32,NULL,NULL,1,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(162,8082,40721,3037,2,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',502476.02,NULL,NULL,1,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(163,8082,40721,3037,2,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',339268.30,NULL,NULL,1,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(164,8082,40721,3037,2,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',180822.47,NULL,NULL,1,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(165,8082,40721,3037,2,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',43802.00,NULL,NULL,1,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(166,8082,40721,3037,2,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',182637.40,NULL,NULL,1,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(167,8082,40721,3037,2,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',205001.10,NULL,NULL,1,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(168,8082,40721,3037,2,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',277524.97,NULL,NULL,1,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL);
INSERT INTO `balance_libro` VALUES (169,8082,40721,3037,2,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',217538.64,NULL,NULL,1,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(170,8082,40721,3037,2,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',282522.34,NULL,NULL,1,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(171,8082,40721,3037,2,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',772805.22,NULL,NULL,1,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(172,8082,40721,3037,2,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',895484.70,NULL,NULL,1,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(173,8082,40721,3037,2,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',980100.00,NULL,NULL,1,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(174,8082,40721,3037,3,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',17621.47,NULL,NULL,1,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(175,8082,40721,3037,3,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',46404.54,NULL,NULL,1,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(176,8082,40721,3037,3,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',24823.47,NULL,NULL,1,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(177,8082,40721,3037,3,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',901573.54,NULL,NULL,1,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(178,8082,40721,3037,3,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',37433.39,NULL,NULL,1,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(179,8082,40721,3037,3,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',7467.36,NULL,NULL,1,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(180,8082,40721,3037,3,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',63607.32,NULL,NULL,1,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(181,8082,40721,3037,3,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',108705.57,NULL,NULL,1,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(182,8082,40721,3037,3,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',18380.00,NULL,NULL,1,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(183,8082,40721,3037,3,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',26164.09,NULL,NULL,1,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(184,8082,40721,3037,3,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',69979.14,NULL,NULL,1,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(185,8082,40721,3037,3,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',255788.58,NULL,NULL,1,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(186,8082,40721,3037,3,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',598977.43,NULL,NULL,1,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(187,8082,40721,3037,3,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',2097200.00,NULL,NULL,1,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(188,8082,40721,3037,3,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',917836.30,NULL,NULL,1,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(189,8082,40721,3037,3,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',14595.80,NULL,NULL,1,'2022-12-10 08:41:52','2022-12-10 08:41:52',NULL);
INSERT INTO `balance_libro` VALUES (190,8082,40723,4555,3,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',164616.18,NULL,NULL,1,'2022-12-10 09:01:08','2022-12-10 09:01:08',NULL),(191,8082,40719,14,16,34,'App\\Models\\PeriodLiquidation',NULL,34,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',0.00,NULL,NULL,1,'2023-01-12 21:30:08','2023-01-12 21:32:10','2023-01-12 21:32:10'),(192,8082,40864,112062,2,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',139294.33,NULL,NULL,1,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(193,8082,40864,112062,2,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',79106.64,NULL,NULL,1,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(194,8082,40864,112062,2,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',125610.11,NULL,NULL,1,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(195,8082,40864,112062,2,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',103091.18,NULL,NULL,1,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(196,8082,40864,112062,2,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',86772.80,NULL,NULL,1,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(197,8082,40864,112062,2,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-28','2022-08-28',212047.65,NULL,NULL,1,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(198,8082,40864,112062,2,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-28','2022-08-28',50192.15,NULL,NULL,1,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(199,8082,40864,112062,2,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',111580.11,NULL,NULL,1,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(200,8082,40864,112062,2,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',63768.42,NULL,NULL,1,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(201,8082,40864,112062,2,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',111357.48,NULL,NULL,1,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(202,8082,40864,112062,2,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',118852.66,NULL,NULL,1,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(203,8082,40864,112062,2,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',150812.76,NULL,NULL,1,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(204,8082,40864,112062,2,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',176666.63,NULL,NULL,1,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(205,8082,40864,112062,2,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',69596.83,NULL,NULL,1,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(206,8082,40864,112062,2,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',143527.32,NULL,NULL,1,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(207,8082,40864,112062,2,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',92770.73,NULL,NULL,1,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(208,8082,40864,112062,2,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',95665.90,NULL,NULL,1,'2023-01-17 23:54:03','2023-01-17 23:54:03',NULL),(209,8082,40864,112062,2,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',135772.66,NULL,NULL,1,'2023-01-17 23:54:08','2023-01-17 23:54:08',NULL),(210,8082,40864,112062,2,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',150638.74,NULL,NULL,1,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL);
INSERT INTO `balance_libro` VALUES (211,8082,40864,112062,2,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',139245.77,NULL,NULL,1,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(212,8082,40864,112062,2,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',2752.00,NULL,NULL,1,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(213,8082,40864,112062,2,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',196846.09,NULL,NULL,1,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(214,8082,40864,112062,2,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',189175.82,NULL,NULL,1,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(215,8082,40864,112062,2,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',53140.98,NULL,NULL,1,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(216,8082,40864,112062,2,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',232966.67,NULL,NULL,1,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(217,8082,40864,112062,2,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',115368.23,NULL,NULL,1,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(218,8082,40864,112062,2,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',108217.57,NULL,NULL,1,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(219,8082,40864,112062,2,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',132503.74,NULL,NULL,1,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(220,8082,40864,112062,2,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',151379.97,NULL,NULL,1,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(221,8082,40864,112062,2,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-14','2022-08-14',218151.04,NULL,NULL,1,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(222,8082,40864,112062,2,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-14','2022-08-14',34774.68,NULL,NULL,1,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(223,8082,40864,112062,2,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',76500.00,NULL,NULL,1,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(224,8082,40864,112062,2,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1762.99,NULL,NULL,1,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(225,8082,40864,112062,2,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',5790.04,NULL,NULL,1,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(226,8082,40864,112062,2,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',6960.06,NULL,NULL,1,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(227,8082,40864,112062,2,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',5055.00,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(228,8082,40864,112062,2,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',2578.00,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(229,8082,40864,112062,2,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',2658.04,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(230,8082,40864,112062,2,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',4681.00,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(231,8082,40864,112062,2,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',113710.00,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL);
INSERT INTO `balance_libro` VALUES (232,8082,40864,112062,2,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',6910.00,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(233,8082,40864,112062,2,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1531.00,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(234,8082,40864,112062,2,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',3571.00,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(235,8082,40864,112062,2,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',156549.00,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(236,8082,40864,112062,2,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1500.00,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(237,8082,40864,112062,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',12064.99,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(238,8082,40864,112062,2,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',13539.00,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(239,8082,40864,112062,2,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',3903.06,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(240,8082,40864,112062,2,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',6671.06,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(241,8082,40864,112062,2,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',3160.00,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(242,8082,40864,112062,2,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',22000.04,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(243,8082,40864,112062,2,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2661.02,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(244,8082,40864,112062,2,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2920.00,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(245,8082,40864,112062,2,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',5344.11,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(246,8082,40864,112062,2,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',6543.00,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(247,8082,40864,112062,2,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',550.00,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(248,8082,40864,112062,2,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',5659.02,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(249,8082,40864,112062,2,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',3310.06,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(250,8082,40864,112062,2,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',8183.99,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(251,8082,40864,112062,2,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',86000.00,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(252,8082,40864,112062,2,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',5925.00,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL);
INSERT INTO `balance_libro` VALUES (253,8082,40864,112062,2,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',3873.09,NULL,NULL,1,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(254,8082,40864,112062,2,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',3386.04,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(255,8082,40864,112062,2,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',15830.06,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(256,8082,40864,112062,2,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',5613.00,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(257,8082,40864,112062,2,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',5551.08,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(258,8082,40864,112062,2,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',10654.00,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(259,8082,40864,112062,2,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',4875.00,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(260,8082,40864,112062,2,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',4900.00,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(261,8082,40864,112062,2,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',10259.02,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(262,8082,40864,112062,2,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1852.00,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(263,8082,40864,112062,2,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',5477.02,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(264,8082,40864,112062,2,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3870.99,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(265,8082,40864,112062,2,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',3055.00,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(266,8082,40864,112062,2,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',6222.99,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(267,8082,40864,112062,2,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',8436.99,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(268,8082,40864,112062,2,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',4473.99,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(269,8082,40864,112062,2,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',6364.02,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(270,8082,40864,112062,2,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',11190.04,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(271,8082,40864,112062,2,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',99999.99,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(272,8082,40864,112062,2,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',760300.00,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(273,8082,40864,112062,2,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',7449.00,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL);
INSERT INTO `balance_libro` VALUES (274,8082,40864,112062,2,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',2938.00,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(275,8082,40864,112062,2,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',6130.00,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(276,8082,40864,112062,2,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',66999.99,NULL,NULL,1,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(277,8082,40864,112062,2,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',7943.06,NULL,NULL,1,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(278,8082,40864,112062,2,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',4986.00,NULL,NULL,1,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(279,8082,40864,112062,2,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',8102.00,NULL,NULL,1,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(280,8082,40864,112062,2,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',3136.11,NULL,NULL,1,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(281,8082,40864,112062,2,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',3339.00,NULL,NULL,1,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(282,8082,40864,112062,2,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',20600.08,NULL,NULL,1,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(283,8082,40864,112062,2,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3653.00,NULL,NULL,1,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(284,8082,40864,112062,2,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',5299.00,NULL,NULL,1,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(285,8082,40864,112062,2,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',4201.99,NULL,NULL,1,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(286,8082,40864,112062,2,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',12360.99,NULL,NULL,1,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(287,8082,40864,112062,3,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',2264.93,NULL,NULL,1,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(288,8082,40864,112062,3,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',53674.87,NULL,NULL,1,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(289,8082,40864,112062,3,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1195.50,NULL,NULL,1,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(290,8082,40864,112062,3,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',5852.50,NULL,NULL,1,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(291,8082,40864,112062,3,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',28065.16,NULL,NULL,1,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(292,8082,40864,112062,3,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',37880.86,NULL,NULL,1,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(293,8082,40864,112062,3,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',7765.02,NULL,NULL,1,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(294,8082,40864,112062,3,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',21168.76,NULL,NULL,1,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL);
INSERT INTO `balance_libro` VALUES (295,8082,40864,112062,3,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',44975.97,NULL,NULL,1,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(296,8082,40864,112062,3,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',3204.37,NULL,NULL,1,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(297,8082,40864,112062,3,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',34601.99,NULL,NULL,1,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(298,8082,40864,112062,3,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',57183.75,NULL,NULL,1,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(299,8082,40864,112062,3,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',9681.86,NULL,NULL,1,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(300,8082,40864,112062,3,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',42940.03,NULL,NULL,1,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(301,8082,40864,112062,3,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',306569.70,NULL,NULL,1,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(302,8082,40864,112062,3,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',22462.35,NULL,NULL,1,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(303,8082,40864,112062,3,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',20371.00,NULL,NULL,1,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(304,8082,40864,112062,3,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',21047.87,NULL,NULL,1,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(305,8082,40864,112062,3,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',9500.01,NULL,NULL,1,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(306,8082,40864,112062,3,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',121890.03,NULL,NULL,1,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(307,8082,40864,112062,3,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',25864.94,NULL,NULL,1,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(308,8082,40864,112062,3,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',49565.24,NULL,NULL,1,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(309,8082,40864,112062,3,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',5831.67,NULL,NULL,1,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(310,8082,40864,112062,3,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',4814.54,NULL,NULL,1,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(311,8082,40864,112062,3,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',12887.40,NULL,NULL,1,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(312,8082,40864,112062,3,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',37888.22,NULL,NULL,1,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(313,8082,40864,112062,3,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',44350.08,NULL,NULL,1,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(314,8082,40864,112062,3,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',25444.49,NULL,NULL,1,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(315,8082,40864,112062,3,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',16837.42,NULL,NULL,1,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL);
INSERT INTO `balance_libro` VALUES (316,8082,40864,112062,3,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',12166.94,NULL,NULL,1,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(317,8082,40864,112062,3,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',50111.75,NULL,NULL,1,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(318,8082,40864,112062,3,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',31804.98,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(319,8082,40864,112062,3,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',16837.42,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(320,8082,40864,112062,3,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',12166.94,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(321,8082,40864,112062,3,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',49409.60,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(322,8082,40864,112062,3,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',49504.00,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(323,8082,40864,112062,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',4107.95,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(324,8082,40864,112062,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',13645.00,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(325,8082,40864,112062,3,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',23437.70,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(326,8082,40864,112062,3,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',12826.37,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(327,8082,40864,112062,3,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',17043.77,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(328,8082,40864,112062,3,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',36514.85,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(329,8082,40864,112062,3,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',37928.73,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(330,8082,40864,112062,3,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',14327.35,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(331,8082,40864,112062,3,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',4147.54,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(332,8082,40864,112062,3,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',37596.26,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(333,8082,40864,112062,3,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',39956.05,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(334,8082,40864,112062,3,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',3300.01,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(335,8082,40864,112062,3,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',17987.80,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(336,8082,40864,112062,3,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',117844.99,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL);
INSERT INTO `balance_libro` VALUES (337,8082,40864,112062,3,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',24512.44,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(338,8082,40864,112062,3,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',21978.14,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(339,8082,40864,112062,3,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1000.00,NULL,NULL,1,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(340,8082,40864,112062,3,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1000.00,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(341,8082,40864,112062,3,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',11801.63,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(342,8082,40864,112062,3,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',9905.32,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(343,8082,40864,112062,3,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',6688.27,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(344,8082,40864,112062,3,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',12211.21,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(345,8082,40864,112062,3,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',71539.87,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(346,8082,40864,112062,3,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',25194.00,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(347,8082,40864,112062,3,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',70720.00,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(348,8082,40864,112062,3,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',13094.02,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(349,8082,40864,112062,3,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',20083.79,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(350,8082,40864,112062,3,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',33687.55,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(351,8082,40864,112062,3,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',1963.34,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(352,8082,40864,112062,3,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',8447.40,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(353,8082,40864,112062,3,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',52121.85,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(354,8082,40864,112062,3,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',994.21,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(355,8082,40864,112062,3,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',75004.34,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(356,8082,40864,112062,3,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',5977.31,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(357,8082,40864,112062,3,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',1834.19,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL);
INSERT INTO `balance_libro` VALUES (358,8082,40864,112062,3,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',994.21,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(359,8082,40864,112062,3,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',56576.00,NULL,NULL,1,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(360,8082,40864,112062,3,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',7296.37,NULL,NULL,1,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(361,8082,40864,112062,3,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',58606.48,NULL,NULL,1,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(362,8082,40864,112062,3,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',22334.25,NULL,NULL,1,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(363,8082,40864,112062,3,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',11549.93,NULL,NULL,1,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(364,8082,40864,112062,3,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',30558.35,NULL,NULL,1,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(365,8082,40864,112062,3,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',284425.92,NULL,NULL,1,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(366,8082,40864,112062,3,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',3496.76,NULL,NULL,1,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(367,8082,40864,112062,3,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',43376.24,NULL,NULL,1,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(368,8082,40864,112062,3,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',27675.32,NULL,NULL,1,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(369,8082,40864,112062,3,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',54967.90,NULL,NULL,1,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(370,8082,40864,112062,3,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',39480.41,NULL,NULL,1,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(371,8082,40864,112062,3,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',183680.00,NULL,NULL,1,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(372,8082,40864,112062,3,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',82315.28,NULL,NULL,1,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(373,8082,40864,112062,3,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',21856.80,NULL,NULL,1,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(374,8082,40864,112062,3,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',21856.80,NULL,NULL,1,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(375,8082,40864,112062,3,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',21856.80,NULL,NULL,1,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(376,8082,40864,112062,3,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',24140.55,NULL,NULL,1,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(377,8082,40864,112062,3,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',6039.90,NULL,NULL,1,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(378,8082,40864,112062,3,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',11553.43,NULL,NULL,1,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL);
INSERT INTO `balance_libro` VALUES (379,8082,40864,112062,3,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',8806.37,NULL,NULL,1,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(380,8082,40864,112062,3,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',2038.46,NULL,NULL,1,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(381,8082,40864,112062,3,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',45979.80,NULL,NULL,1,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(382,8082,40864,112062,3,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',16283.70,NULL,NULL,1,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(383,8082,40864,112062,3,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',12749.91,NULL,NULL,1,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(384,8082,40864,112062,3,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',5418.92,NULL,NULL,1,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(385,8082,40864,112062,3,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',72129.95,NULL,NULL,1,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(386,8082,40864,112062,3,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',7296.37,NULL,NULL,1,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(387,8082,40864,112062,3,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',26520.00,NULL,NULL,1,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(388,8082,40864,112062,3,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',3384.10,NULL,NULL,1,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(389,8082,40864,112062,3,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',17235.11,NULL,NULL,1,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(390,8082,40864,112062,3,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',76682.41,NULL,NULL,1,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(391,8082,40864,112062,3,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',5926.84,NULL,NULL,1,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(392,8082,40864,112062,3,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',45044.22,NULL,NULL,1,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(393,8082,40864,112062,3,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',53758.25,NULL,NULL,1,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(394,8082,40864,112062,3,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-25','2022-12-25',11841.64,NULL,NULL,1,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(395,8082,40864,112062,3,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-25','2022-12-25',7954.93,NULL,NULL,1,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(396,8082,40864,112062,3,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-25','2022-12-25',11841.64,NULL,NULL,1,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(397,8082,40864,112062,3,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-25','2022-12-25',17332.77,NULL,NULL,1,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(398,8082,40864,112062,3,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',52818.97,NULL,NULL,1,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(399,8082,40864,112062,3,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',47313.78,NULL,NULL,1,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL);
INSERT INTO `balance_libro` VALUES (400,8082,40864,112062,3,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',51002.20,NULL,NULL,1,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(401,8082,40864,112062,3,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',56493.77,NULL,NULL,1,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(402,8082,40864,112062,3,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',253059.74,NULL,NULL,1,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(403,8082,40864,112062,3,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',7409.99,NULL,NULL,1,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(404,8082,40864,112062,3,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',4777.21,NULL,NULL,1,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(405,8082,40864,112062,3,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',13334.00,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(406,8082,40864,112062,3,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',41000.14,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(407,8082,40864,112062,3,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',3267.03,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(408,8082,40864,112062,3,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',36729.21,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(409,8082,40864,112062,3,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',37743.38,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(410,8082,40864,112062,3,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2662.53,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(411,8082,40864,112062,3,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',364.43,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(412,8082,40864,112062,3,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',28669.41,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(413,8082,40864,112062,3,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',57908.55,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(414,8082,40864,112062,3,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',7852.13,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(415,8082,40864,112062,3,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',2371.08,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(416,8082,40864,112062,3,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',11340.00,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(417,8082,40864,112062,3,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',10947.08,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(418,8082,40864,112062,3,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',12684.74,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(419,8082,40864,112062,3,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',4734.30,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(420,8082,40864,112062,3,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',124880.00,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL);
INSERT INTO `balance_libro` VALUES (421,8082,40864,112062,3,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2333.28,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(422,8082,40864,112062,3,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',16227.58,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(423,8082,40864,112062,3,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',50868.58,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(424,8082,40864,112062,3,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',78.65,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(425,8082,40864,112062,3,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',56474.40,NULL,NULL,1,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(426,8082,40864,112062,3,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',69785.00,NULL,NULL,1,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(427,8082,40864,112062,3,439,'App\\Models\\Receipt',439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',22251.47,NULL,NULL,1,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(428,8082,40864,112062,3,440,'App\\Models\\Receipt',440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2999.00,NULL,NULL,1,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(429,8082,40719,18,16,92,'App\\Models\\PeriodLiquidation',NULL,92,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',150.00,NULL,NULL,1,'2023-08-29 21:45:26','2023-08-29 21:45:26',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1709 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,8082,1,40719,3,2,218,2,25000.00,NULL,'2022-11-10 13:08:20','2022-11-11 13:02:50','2022-11-11 13:02:50'),(2,8082,1,40719,3,2,220,2,250.00,NULL,'2022-11-10 13:08:20','2022-11-11 13:02:50','2022-11-11 13:02:50'),(3,8082,1,40719,3,2,13,1,25250.00,NULL,'2022-11-10 13:08:20','2022-11-11 13:02:50','2022-11-11 13:02:50'),(4,8082,2,40719,3,3,217,1,12500.00,NULL,'2022-11-10 13:11:52','2022-11-11 13:02:57','2022-11-11 13:02:57'),(5,8082,2,40719,3,3,57,2,12500.00,NULL,'2022-11-10 13:11:52','2022-11-11 13:02:57','2022-11-11 13:02:57'),(6,8082,3,40720,1527,3,217,1,25606.25,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(7,8082,3,40720,1527,3,68,1,5377.31,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(8,8082,3,40720,1527,3,217,1,640.16,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(9,8082,3,40720,1527,3,57,2,31623.72,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(10,8082,4,40720,1527,3,217,1,59040.00,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(11,8082,4,40720,1527,3,68,1,6199.20,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(12,8082,4,40720,1527,3,57,2,65239.20,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(13,8082,5,40720,1527,3,217,1,81194.57,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(14,8082,5,40720,1527,3,68,1,8525.43,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(15,8082,5,40720,1527,3,57,2,89720.00,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(16,8082,6,40720,1527,3,217,1,3058.82,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(17,8082,6,40720,1527,3,68,1,321.18,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(18,8082,6,40720,1527,3,57,2,3380.00,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(19,8082,7,40720,1527,3,217,1,19820.05,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(20,8082,7,40720,1527,3,68,1,4162.21,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(21,8082,7,40720,1527,3,57,2,23982.26,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(22,8082,8,40720,1527,3,217,1,22180.00,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(23,8082,8,40720,1527,3,68,1,4657.80,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(24,8082,8,40720,1527,3,57,2,26837.80,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(25,8082,9,40720,1527,3,217,1,271617.96,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(26,8082,9,40720,1527,3,68,1,28519.89,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(27,8082,9,40720,1527,3,217,1,4753.31,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(28,8082,9,40720,1527,3,57,2,304891.16,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(29,8082,10,40720,1527,3,217,1,5548.07,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(30,8082,10,40720,1527,3,68,1,1165.09,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(31,8082,10,40720,1527,3,217,1,138.70,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(32,8082,10,40720,1527,3,57,2,6851.86,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(33,8082,11,40720,1527,3,217,1,16593.65,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(34,8082,11,40720,1527,3,68,1,3484.67,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(35,8082,11,40720,1527,3,217,1,414.84,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(36,8082,11,40720,1527,3,57,2,20493.16,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(37,8082,12,40720,1527,3,217,1,18462.17,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(38,8082,12,40720,1527,3,68,1,3877.06,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(39,8082,12,40720,1527,3,217,1,2293.26,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(40,8082,12,40720,1527,3,57,2,24632.49,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(41,8082,13,40720,1527,3,217,1,11953.22,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(42,8082,13,40720,1527,3,68,1,2510.18,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL);
INSERT INTO `balance_libro_details` VALUES (43,8082,13,40720,1527,3,217,1,298.83,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(44,8082,13,40720,1527,3,57,2,14762.23,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(45,8082,14,40720,1527,3,217,1,4606.76,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(46,8082,14,40720,1527,3,68,1,967.42,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(47,8082,14,40720,1527,3,217,1,115.17,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(48,8082,14,40720,1527,3,57,2,5689.35,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(49,8082,15,40720,1527,3,217,1,29295.89,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(50,8082,15,40720,1527,3,68,1,6152.14,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(51,8082,15,40720,1527,3,217,1,732.40,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(52,8082,15,40720,1527,3,57,2,36180.43,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(53,8082,16,40720,1527,3,217,1,3794.22,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(54,8082,16,40720,1527,3,68,1,796.79,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(55,8082,16,40720,1527,3,217,1,409.00,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(56,8082,16,40720,1527,3,57,2,5000.01,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(57,8082,17,40720,1527,3,217,1,17282.80,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(58,8082,17,40720,1527,3,68,1,3629.39,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(59,8082,17,40720,1527,3,57,2,20912.19,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(60,8082,18,40720,1527,3,217,1,19168.24,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(61,8082,18,40720,1527,3,68,1,4025.33,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(62,8082,18,40720,1527,3,57,2,23193.57,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(63,8082,19,40720,1527,3,217,1,16392.08,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(64,8082,19,40720,1527,3,68,1,3442.34,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(65,8082,19,40720,1527,3,217,1,409.80,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(66,8082,19,40720,1527,3,57,2,20244.22,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(67,8082,20,40720,1527,3,217,1,24415.82,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(68,8082,20,40720,1527,3,68,1,5127.32,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(69,8082,20,40720,1527,3,217,1,732.48,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(70,8082,20,40720,1527,3,57,2,30275.62,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(71,8082,21,40720,1527,3,217,1,3180.96,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(72,8082,21,40720,1527,3,68,1,668.00,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(73,8082,21,40720,1527,3,217,1,79.52,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(74,8082,21,40720,1527,3,57,2,3928.48,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(75,8082,22,40720,1527,3,217,1,411.66,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(76,8082,22,40720,1527,3,68,1,86.45,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(77,8082,22,40720,1527,3,217,1,10.29,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(78,8082,22,40720,1527,3,57,2,508.40,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(79,8082,23,40720,1527,3,217,1,15785.52,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(80,8082,23,40720,1527,3,68,1,3314.96,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(81,8082,23,40720,1527,3,217,1,394.64,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(82,8082,23,40720,1527,3,57,2,19495.12,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(83,8082,24,40720,1527,3,217,1,6550.00,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(84,8082,24,40720,1527,3,68,1,1375.50,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL);
INSERT INTO `balance_libro_details` VALUES (85,8082,24,40720,1527,3,217,1,163.75,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(86,8082,24,40720,1527,3,57,2,8089.25,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(87,8082,25,40720,1527,3,217,1,32741.64,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(88,8082,25,40720,1527,3,68,1,6875.73,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(89,8082,25,40720,1527,3,57,2,39617.37,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(90,8082,26,40720,1527,3,217,1,45850.00,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(91,8082,26,40720,1527,3,68,1,4814.25,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(92,8082,26,40720,1527,3,57,2,50664.25,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(93,8082,27,40720,1527,3,250,1,6525.00,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(94,8082,27,40720,1527,3,57,2,6525.00,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(95,8082,28,40720,1527,3,217,1,4568.88,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(96,8082,28,40720,1527,3,68,1,959.46,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(97,8082,28,40720,1527,3,217,1,114.22,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(98,8082,28,40720,1527,3,57,2,5642.56,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(99,8082,29,40720,1527,3,217,1,14721.32,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(100,8082,29,40720,1527,3,68,1,3091.48,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(101,8082,29,40720,1527,3,217,1,368.03,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(102,8082,29,40720,1527,3,57,2,18180.83,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(103,8082,30,40720,1527,3,217,1,12306.00,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(104,8082,30,40720,1527,3,68,1,2584.26,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(105,8082,30,40720,1527,3,57,2,14890.26,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(106,8082,31,40720,1527,3,217,1,15458.50,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(107,8082,31,40720,1527,3,68,1,2985.96,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(108,8082,31,40720,1527,3,217,1,386.46,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(109,8082,31,40720,1527,3,57,2,18830.92,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(110,8082,32,40720,1527,3,217,1,45150.00,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(111,8082,32,40720,1527,3,68,1,4740.75,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(112,8082,32,40720,1527,3,57,2,49890.75,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(113,8082,33,40720,1527,3,217,1,2824.00,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(114,8082,33,40720,1527,3,68,1,593.04,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(115,8082,33,40720,1527,3,57,2,3417.04,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(116,8082,34,40720,1527,3,217,1,24282.95,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(117,8082,34,40720,1527,3,68,1,5099.42,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(118,8082,34,40720,1527,3,57,2,29382.37,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(119,8082,35,40720,1527,3,217,1,33565.61,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(120,8082,35,40720,1527,3,68,1,3524.39,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(121,8082,35,40720,1527,3,57,2,37090.00,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(122,8082,36,40720,1527,3,217,1,64469.40,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(123,8082,36,40720,1527,3,68,1,6863.18,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(124,8082,36,40720,1527,3,57,2,71332.58,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(125,8082,37,40720,1527,3,217,1,5834.67,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(126,8082,37,40720,1527,3,68,1,1225.28,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL);
INSERT INTO `balance_libro_details` VALUES (127,8082,37,40720,1527,3,217,1,145.87,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(128,8082,37,40720,1527,3,57,2,7205.82,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(129,8082,38,40720,1527,3,250,1,700.00,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(130,8082,38,40720,1527,3,57,2,700.00,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(131,8082,39,40720,1527,3,217,1,2769.56,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(132,8082,39,40720,1527,3,68,1,581.61,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(133,8082,39,40720,1527,3,217,1,69.24,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(134,8082,39,40720,1527,3,57,2,3420.41,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(135,8082,40,40720,1527,3,217,1,12743.67,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(136,8082,40,40720,1527,3,68,1,2676.17,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(137,8082,40,40720,1527,3,217,1,318.59,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(138,8082,40,40720,1527,3,57,2,15738.43,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(139,8082,41,40720,1527,3,217,1,3835.06,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(140,8082,41,40720,1527,3,68,1,805.36,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(141,8082,41,40720,1527,3,217,1,95.88,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(142,8082,41,40720,1527,3,57,2,4736.30,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(143,8082,42,40720,1527,3,217,1,0.04,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(144,8082,42,40720,1527,3,68,1,0.01,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(145,8082,42,40720,1527,3,57,2,0.05,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(146,8082,43,40720,1527,3,217,1,26117.53,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(147,8082,43,40720,1527,3,68,1,5484.68,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(148,8082,43,40720,1527,3,57,2,31602.21,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(149,8082,44,40720,1527,3,217,1,24126.69,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(150,8082,44,40720,1527,3,68,1,5066.60,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(151,8082,44,40720,1527,3,217,1,603.17,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(152,8082,44,40720,1527,3,57,2,29796.46,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(153,8082,45,40720,1527,3,217,1,31753.38,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(154,8082,45,40720,1527,3,68,1,6668.21,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(155,8082,45,40720,1527,3,217,1,793.83,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(156,8082,45,40720,1527,3,57,2,39215.42,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(157,8082,46,40720,1527,3,217,1,4711.32,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(158,8082,46,40720,1527,3,68,1,989.38,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(159,8082,46,40720,1527,3,217,1,117.78,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(160,8082,46,40720,1527,3,57,2,5818.48,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(161,8082,47,40720,1527,3,217,1,3101.40,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(162,8082,47,40720,1527,3,68,1,651.29,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(163,8082,47,40720,1527,3,217,1,77.55,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(164,8082,47,40720,1527,3,57,2,3830.24,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(165,8082,48,40720,1527,3,217,1,44040.00,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(166,8082,48,40720,1527,3,68,1,5184.90,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(167,8082,48,40720,1527,3,57,2,49224.90,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(168,8082,49,40720,1527,3,217,1,75517.16,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL);
INSERT INTO `balance_libro_details` VALUES (169,8082,49,40720,1527,3,68,1,15858.60,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(170,8082,49,40720,1527,3,217,1,2265.52,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(171,8082,49,40720,1527,3,57,2,93641.28,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(172,8082,50,40720,1527,3,217,1,3240.50,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(173,8082,50,40720,1527,3,68,1,680.50,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(174,8082,50,40720,1527,3,57,2,3921.00,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(175,8082,51,40720,1527,3,217,1,16355.37,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(176,8082,51,40720,1527,3,68,1,3434.63,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(177,8082,51,40720,1527,3,57,2,19790.00,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(178,8082,52,40720,1527,3,217,1,49336.78,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(179,8082,52,40720,1527,3,68,1,10360.74,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(180,8082,52,40720,1527,3,57,2,59697.52,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(181,8082,53,40720,1527,3,217,1,13861.91,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(182,8082,53,40720,1527,3,68,1,2911.00,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(183,8082,53,40720,1527,3,217,1,346.56,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(184,8082,53,40720,1527,3,57,2,17119.47,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(185,8082,54,40720,1527,3,217,1,16521.49,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(186,8082,54,40720,1527,3,68,1,3469.51,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(187,8082,54,40720,1527,3,217,1,413.03,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(188,8082,54,40720,1527,3,57,2,20404.03,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(189,8082,55,40720,1527,3,217,1,4870.66,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(190,8082,55,40720,1527,3,68,1,1022.83,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(191,8082,55,40720,1527,3,217,1,121.78,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(192,8082,55,40720,1527,3,57,2,6015.27,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(193,8082,56,40720,1527,3,217,1,2811.93,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(194,8082,56,40720,1527,3,68,1,590.51,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(195,8082,56,40720,1527,3,217,1,70.29,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(196,8082,56,40720,1527,3,57,2,3472.73,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(197,8082,57,40720,1527,3,217,1,16491.74,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(198,8082,57,40720,1527,3,68,1,3463.27,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(199,8082,57,40720,1527,3,217,1,412.30,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(200,8082,57,40720,1527,3,57,2,20367.31,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(201,8082,58,40720,1527,3,217,1,2594.63,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(202,8082,58,40720,1527,3,68,1,544.87,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(203,8082,58,40720,1527,3,217,1,64.87,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(204,8082,58,40720,1527,3,57,2,3204.37,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(205,8082,59,40720,1527,3,217,1,62644.01,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(206,8082,59,40720,1527,3,68,1,13155.24,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(207,8082,59,40720,1527,3,217,1,1566.11,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(208,8082,59,40720,1527,3,57,2,77365.36,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(209,8082,60,40720,1527,3,217,1,5474.58,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(210,8082,60,40720,1527,3,68,1,1149.66,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL);
INSERT INTO `balance_libro_details` VALUES (211,8082,60,40720,1527,3,217,1,136.86,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(212,8082,60,40720,1527,3,57,2,6761.10,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(213,8082,61,40720,1527,3,217,1,1727.27,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(214,8082,61,40720,1527,3,68,1,362.73,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(215,8082,61,40720,1527,3,57,2,2090.00,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(216,8082,62,40720,1527,3,217,1,19760.96,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(217,8082,62,40720,1527,3,68,1,4149.80,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(218,8082,62,40720,1527,3,217,1,494.02,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(219,8082,62,40720,1527,3,57,2,24404.78,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(220,8082,63,40720,1527,3,217,1,38766.21,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(221,8082,63,40720,1527,3,68,1,8140.90,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(222,8082,63,40720,1527,3,57,2,46907.11,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(223,8082,64,40720,1527,3,217,1,73974.44,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(224,8082,64,40720,1527,3,68,1,7767.32,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(225,8082,64,40720,1527,3,57,2,81741.76,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(226,8082,65,40720,1527,3,217,1,61150.00,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(227,8082,65,40720,1527,3,68,1,6420.75,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(228,8082,65,40720,1527,3,57,2,67570.75,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(229,8082,66,40720,1527,3,217,1,270913.30,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(230,8082,66,40720,1527,3,68,1,28445.90,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(231,8082,66,40720,1527,3,217,1,4740.98,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(232,8082,66,40720,1527,3,57,2,304100.18,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(233,8082,67,40720,1527,3,217,1,5593.91,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(234,8082,67,40720,1527,3,68,1,1174.72,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(235,8082,67,40720,1527,3,217,1,139.85,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(236,8082,67,40720,1527,3,57,2,6908.48,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(237,8082,68,40720,1527,3,217,1,107171.95,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(238,8082,68,40720,1527,3,68,1,11253.05,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(239,8082,68,40720,1527,3,57,2,118425.00,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(240,8082,69,40720,1527,3,217,1,3529.41,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(241,8082,69,40720,1527,3,68,1,370.59,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(242,8082,69,40720,1527,3,57,2,3900.00,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(243,8082,70,40720,1527,3,217,1,21796.46,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(244,8082,70,40720,1527,3,68,1,4577.26,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(245,8082,70,40720,1527,3,217,1,1634.60,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(246,8082,70,40720,1527,3,57,2,28008.32,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(247,8082,71,40720,1527,3,217,1,21095.57,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(248,8082,71,40720,1527,3,68,1,4430.07,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(249,8082,71,40720,1527,3,217,1,527.39,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(250,8082,71,40720,1527,3,57,2,26053.03,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(251,8082,72,40720,1527,3,217,1,11140.21,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(252,8082,72,40720,1527,3,68,1,2339.44,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL);
INSERT INTO `balance_libro_details` VALUES (253,8082,72,40720,1527,3,217,1,278.51,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(254,8082,72,40720,1527,3,57,2,13758.16,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(255,8082,73,40720,1527,3,217,1,12392.95,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(256,8082,73,40720,1527,3,68,1,2602.52,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(257,8082,73,40720,1527,3,217,1,309.82,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(258,8082,73,40720,1527,3,57,2,15305.29,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(259,8082,74,40720,1527,3,217,1,5052.30,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(260,8082,74,40720,1527,3,68,1,1060.98,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(261,8082,74,40720,1527,3,217,1,126.31,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(262,8082,74,40720,1527,3,57,2,6239.59,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(263,8082,75,40720,1527,3,217,2,1182.83,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(264,8082,75,40720,1527,3,67,2,248.39,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(265,8082,75,40720,1527,3,217,2,29.57,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(266,8082,75,40720,1527,3,57,1,1460.79,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(267,8082,76,40720,1527,3,217,1,29806.28,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(268,8082,76,40720,1527,3,68,1,6259.32,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(269,8082,76,40720,1527,3,217,1,745.16,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(270,8082,76,40720,1527,3,57,2,36810.76,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(271,8082,77,40720,1527,3,217,1,21430.18,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(272,8082,77,40720,1527,3,68,1,4500.34,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(273,8082,77,40720,1527,3,57,2,25930.52,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(274,8082,78,40720,1527,3,217,1,12883.47,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(275,8082,78,40720,1527,3,68,1,2705.53,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(276,8082,78,40720,1527,3,57,2,15589.00,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(277,8082,79,40720,1527,3,217,1,16016.53,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(278,8082,79,40720,1527,3,68,1,3363.47,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(279,8082,79,40720,1527,3,57,2,19380.00,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(280,8082,80,40720,1527,3,217,1,7568.48,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(281,8082,80,40720,1527,3,68,1,1589.38,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(282,8082,80,40720,1527,3,57,2,9157.86,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(283,8082,81,40720,1527,3,217,1,16924.20,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(284,8082,81,40720,1527,3,68,1,3554.08,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(285,8082,81,40720,1527,3,57,2,20478.28,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(286,8082,82,40720,1527,3,217,1,17164.41,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(287,8082,82,40720,1527,3,68,1,3604.53,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(288,8082,82,40720,1527,3,57,2,20768.94,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(289,8082,83,40720,1527,3,250,1,7000.00,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(290,8082,83,40720,1527,3,57,2,7000.00,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(291,8082,84,40720,1527,3,217,2,964.44,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(292,8082,84,40720,1527,3,67,2,202.53,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(293,8082,84,40720,1527,3,217,2,24.11,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(294,8082,84,40720,1527,3,57,1,1191.08,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL);
INSERT INTO `balance_libro_details` VALUES (295,8082,85,40720,1527,3,217,1,24011.13,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(296,8082,85,40720,1527,3,68,1,5042.34,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(297,8082,85,40720,1527,3,217,1,720.33,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(298,8082,85,40720,1527,3,57,2,29773.80,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(299,8082,86,40720,1527,3,217,1,14471.34,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(300,8082,86,40720,1527,3,68,1,3038.98,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(301,8082,86,40720,1527,3,217,1,361.78,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(302,8082,86,40720,1527,3,57,2,17872.10,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(303,8082,87,40720,1527,3,217,2,5099.99,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(304,8082,87,40720,1527,3,67,2,1071.00,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(305,8082,87,40720,1527,3,217,2,153.00,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(306,8082,87,40720,1527,3,57,1,6323.99,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(307,8082,88,40720,1527,3,217,1,3247.61,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(308,8082,88,40720,1527,3,68,1,682.00,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(309,8082,88,40720,1527,3,217,1,81.19,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(310,8082,88,40720,1527,3,57,2,4010.80,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(311,8082,89,40720,1527,3,217,1,8905.30,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(312,8082,89,40720,1527,3,68,1,1870.11,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(313,8082,89,40720,1527,3,217,1,222.63,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(314,8082,89,40720,1527,3,57,2,10998.04,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(315,8082,90,40720,1527,3,217,1,12525.00,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(316,8082,90,40720,1527,3,68,1,2630.25,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(317,8082,90,40720,1527,3,217,1,313.13,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(318,8082,90,40720,1527,3,57,2,15468.38,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(319,8082,91,40720,1527,3,217,1,12720.00,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(320,8082,91,40720,1527,3,68,1,1335.60,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(321,8082,91,40720,1527,3,57,2,14055.60,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(322,8082,92,40720,1527,3,217,1,34177.68,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(323,8082,92,40720,1527,3,68,1,7177.32,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(324,8082,92,40720,1527,3,57,2,41355.00,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(325,8082,93,40720,1527,3,217,1,47600.00,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(326,8082,93,40720,1527,3,68,1,4998.00,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(327,8082,93,40720,1527,3,57,2,52598.00,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(328,8082,94,40720,1527,3,217,1,47600.00,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(329,8082,94,40720,1527,3,68,1,4998.00,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(330,8082,94,40720,1527,3,57,2,52598.00,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(331,8082,95,40720,1527,3,217,1,10555.58,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(332,8082,95,40720,1527,3,68,1,2216.67,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(333,8082,95,40720,1527,3,217,1,263.91,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(334,8082,95,40720,1527,3,57,2,13036.16,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(335,8082,96,40720,1527,3,217,2,1222.63,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(336,8082,96,40720,1527,3,67,2,256.75,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL);
INSERT INTO `balance_libro_details` VALUES (337,8082,96,40720,1527,3,217,2,30.57,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(338,8082,96,40720,1527,3,57,1,1509.95,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(339,8082,97,40720,1527,3,217,1,23357.72,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(340,8082,97,40720,1527,3,68,1,4905.12,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(341,8082,97,40720,1527,3,57,2,28262.84,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(342,8082,98,40720,1527,3,217,1,9738.70,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(343,8082,98,40720,1527,3,68,1,2045.13,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(344,8082,98,40720,1527,3,217,1,243.47,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(345,8082,98,40720,1527,3,57,2,12027.30,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(346,8082,99,40720,1527,3,217,1,4431.07,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(347,8082,99,40720,1527,3,68,1,930.53,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(348,8082,99,40720,1527,3,217,1,110.78,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(349,8082,99,40720,1527,3,57,2,5472.38,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(350,8082,100,40720,1527,3,217,1,39382.28,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(351,8082,100,40720,1527,3,68,1,8270.28,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(352,8082,100,40720,1527,3,217,1,984.56,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(353,8082,100,40720,1527,3,57,2,48637.12,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(354,8082,101,40720,1527,3,217,1,47600.00,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(355,8082,101,40720,1527,3,68,1,4998.00,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(356,8082,101,40720,1527,3,57,2,52598.00,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(357,8082,102,40720,1527,3,217,1,3841.32,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(358,8082,102,40720,1527,3,68,1,806.68,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(359,8082,102,40720,1527,3,57,2,4648.00,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(360,8082,103,40720,1527,3,217,1,29516.10,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(361,8082,103,40720,1527,3,68,1,6198.38,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(362,8082,103,40720,1527,3,57,2,35714.48,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(363,8082,104,40720,1527,3,217,1,46407.82,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(364,8082,104,40720,1527,3,68,1,4981.64,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(365,8082,104,40720,1527,3,57,2,51389.46,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(366,8082,105,40720,1527,3,217,1,65.00,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(367,8082,105,40720,1527,3,68,1,13.65,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(368,8082,105,40720,1527,3,57,2,78.65,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(369,8082,106,40720,1527,3,217,1,276967.51,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(370,8082,106,40720,1527,3,68,1,29081.59,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(371,8082,106,40720,1527,3,217,1,4846.93,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(372,8082,106,40720,1527,3,57,2,310896.03,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(373,8082,107,40720,1527,3,217,1,18754.66,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(374,8082,107,40720,1527,3,68,1,3938.48,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(375,8082,107,40720,1527,3,217,1,468.87,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(376,8082,107,40720,1527,3,57,2,23162.01,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(377,8082,108,40720,1527,3,217,1,14120.75,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(378,8082,108,40720,1527,3,68,1,2965.36,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL);
INSERT INTO `balance_libro_details` VALUES (379,8082,108,40720,1527,3,217,1,353.02,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(380,8082,108,40720,1527,3,57,2,17439.13,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(381,8082,109,40720,1527,3,217,1,5418.89,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(382,8082,109,40720,1527,3,68,1,1137.97,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(383,8082,109,40720,1527,3,57,2,6556.86,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(384,8082,110,40720,1527,3,217,1,101230.79,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(385,8082,110,40720,1527,3,68,1,10629.23,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(386,8082,110,40720,1527,3,57,2,111860.02,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(387,8082,111,40720,1527,3,217,1,1963.80,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(388,8082,111,40720,1527,3,68,1,206.20,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(389,8082,111,40720,1527,3,57,2,2170.00,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(390,8082,112,40720,1527,3,217,1,24016.30,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(391,8082,112,40720,1527,3,68,1,5043.42,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(392,8082,112,40720,1527,3,217,1,2074.16,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(393,8082,112,40720,1527,3,57,2,31133.88,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(394,8082,113,40720,1527,3,217,1,8538.93,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(395,8082,113,40720,1527,3,68,1,1793.18,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(396,8082,113,40720,1527,3,217,1,213.47,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(397,8082,113,40720,1527,3,57,2,10545.58,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(398,8082,114,40720,1527,3,217,1,16081.98,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(399,8082,114,40720,1527,3,68,1,3377.22,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(400,8082,114,40720,1527,3,217,1,402.05,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(401,8082,114,40720,1527,3,57,2,19861.25,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(402,8082,115,40720,1527,3,217,1,8227.27,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(403,8082,115,40720,1527,3,68,1,1727.73,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(404,8082,115,40720,1527,3,57,2,9955.00,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(405,8082,116,40720,1527,3,217,1,8259.71,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(406,8082,116,40720,1527,3,68,1,1734.54,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(407,8082,116,40720,1527,3,217,1,206.49,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(408,8082,116,40720,1527,3,57,2,10200.74,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(409,8082,117,40720,1527,3,217,1,23295.31,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(410,8082,117,40720,1527,3,68,1,4892.02,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(411,8082,117,40720,1527,3,57,2,28187.33,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(412,8082,118,40720,1527,3,217,1,2026.13,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(413,8082,118,40720,1527,3,68,1,425.49,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(414,8082,118,40720,1527,3,217,1,50.65,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(415,8082,118,40720,1527,3,57,2,2502.27,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(416,8082,119,40720,1527,3,217,1,19427.86,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(417,8082,119,40720,1527,3,68,1,4079.85,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(418,8082,119,40720,1527,3,217,1,582.84,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(419,8082,119,40720,1527,3,57,2,24090.55,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL);
INSERT INTO `balance_libro_details` VALUES (420,8082,120,40720,1527,3,217,1,27157.02,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(421,8082,120,40720,1527,3,68,1,5702.98,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(422,8082,120,40720,1527,3,217,1,678.93,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(423,8082,120,40720,1527,3,57,2,33538.93,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(424,8082,121,40720,1527,3,217,1,26011.50,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(425,8082,121,40720,1527,3,68,1,2731.21,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(426,8082,121,40720,1527,3,57,2,28742.71,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(427,8082,122,40720,1527,3,217,1,16607.80,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(428,8082,122,40720,1527,3,68,1,3217.63,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(429,8082,122,40720,1527,3,217,1,415.21,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(430,8082,122,40720,1527,3,217,1,0.05,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(431,8082,122,40720,1527,3,57,2,20240.69,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(432,8082,123,40720,1527,3,217,1,4050.55,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(433,8082,123,40720,1527,3,68,1,850.62,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(434,8082,123,40720,1527,3,217,1,101.26,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(435,8082,123,40720,1527,3,57,2,5002.43,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(436,8082,124,40720,1527,3,217,1,1528.29,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(437,8082,124,40720,1527,3,68,1,320.94,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(438,8082,124,40720,1527,3,217,1,38.21,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(439,8082,124,40720,1527,3,57,2,1887.44,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(440,8082,125,40720,1527,3,217,1,24093.01,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(441,8082,125,40720,1527,3,68,1,5059.52,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(442,8082,125,40720,1527,3,217,1,1325.12,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(443,8082,125,40720,1527,3,57,2,30477.65,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(444,8082,126,40720,1527,3,217,1,17576.14,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(445,8082,126,40720,1527,3,68,1,3690.98,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(446,8082,126,40720,1527,3,217,1,439.39,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(447,8082,126,40720,1527,3,57,2,21706.51,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(448,8082,127,40720,1527,3,217,1,4039.33,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(449,8082,127,40720,1527,3,68,1,848.25,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(450,8082,127,40720,1527,3,217,1,100.99,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(451,8082,127,40720,1527,3,57,2,4988.57,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(452,8082,128,40720,1527,3,217,1,10593.26,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(453,8082,128,40720,1527,3,68,1,2224.58,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(454,8082,128,40720,1527,3,217,1,264.85,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(455,8082,128,40720,1527,3,57,2,13082.69,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(456,8082,129,40720,1527,3,217,1,42000.00,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(457,8082,129,40720,1527,3,68,1,4410.00,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(458,8082,129,40720,1527,3,57,2,46410.00,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(459,8082,130,40720,1527,3,217,1,27107.67,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(460,8082,130,40720,1527,3,68,1,5692.61,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL);
INSERT INTO `balance_libro_details` VALUES (461,8082,130,40720,1527,3,217,1,677.70,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(462,8082,130,40720,1527,3,57,2,33477.98,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(463,8082,131,40720,1527,3,217,1,786.08,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(464,8082,131,40720,1527,3,68,1,165.08,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(465,8082,131,40720,1527,3,217,1,19.65,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(466,8082,131,40720,1527,3,57,2,970.81,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(467,8082,132,40720,1527,3,250,1,11200.00,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(468,8082,132,40720,1527,3,57,2,11200.00,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(469,8082,133,40720,1527,3,250,1,9300.00,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(470,8082,133,40720,1527,3,57,2,9300.00,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(471,8082,134,40720,1527,3,217,1,5189.26,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(472,8082,134,40720,1527,3,68,1,1089.74,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(473,8082,134,40720,1527,3,217,1,129.73,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(474,8082,134,40720,1527,3,57,2,6408.73,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(475,8082,135,40720,1527,3,217,2,2227.77,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(476,8082,135,40720,1527,3,67,2,467.83,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(477,8082,135,40720,1527,3,217,2,55.69,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(478,8082,135,40720,1527,3,57,1,2751.29,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(479,8082,136,40720,1527,3,217,1,37010.99,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(480,8082,136,40720,1527,3,68,1,7772.31,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(481,8082,136,40720,1527,3,217,1,925.27,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(482,8082,136,40720,1527,3,57,2,45708.57,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(483,8082,137,40720,1527,3,217,1,33576.46,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(484,8082,137,40720,1527,3,68,1,7051.06,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(485,8082,137,40720,1527,3,57,2,40627.52,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(486,8082,138,40720,1527,3,217,2,2282.29,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(487,8082,138,40720,1527,3,67,2,479.28,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(488,8082,138,40720,1527,3,217,2,57.06,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(489,8082,138,40720,1527,3,57,1,2818.63,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(490,8082,139,40720,1527,3,217,1,41799.87,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(491,8082,139,40720,1527,3,68,1,8640.45,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(492,8082,139,40720,1527,3,217,1,1045.00,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(493,8082,139,40720,1527,3,57,2,51485.32,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(494,8082,140,40720,1527,3,250,1,30700.00,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(495,8082,140,40720,1527,3,57,2,30700.00,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(496,8082,141,40720,1527,3,217,1,54000.00,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(497,8082,141,40720,1527,3,68,1,5670.00,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(498,8082,141,40720,1527,3,217,1,810.00,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(499,8082,141,40720,1527,3,57,2,60480.00,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(500,8082,142,40720,1527,3,217,1,24323.12,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(501,8082,142,40720,1527,3,68,1,5107.86,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL);
INSERT INTO `balance_libro_details` VALUES (502,8082,142,40720,1527,3,57,2,29430.98,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(503,8082,143,40720,1527,3,217,1,21915.76,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(504,8082,143,40720,1527,3,68,1,4602.31,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(505,8082,143,40720,1527,3,217,1,547.89,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(506,8082,143,40720,1527,3,57,2,27065.96,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(507,8082,144,40720,1527,3,217,1,1569.44,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(508,8082,144,40720,1527,3,68,1,329.58,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(509,8082,144,40720,1527,3,57,2,1899.02,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(510,8082,145,40720,1527,3,217,1,90000.00,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(511,8082,145,40720,1527,3,68,1,9450.00,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(512,8082,145,40720,1527,3,217,1,2250.00,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(513,8082,145,40720,1527,3,57,2,101700.00,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(514,8082,146,40720,1527,3,217,1,80267.54,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(515,8082,146,40720,1527,3,68,1,8428.09,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(516,8082,146,40720,1527,3,57,2,88695.63,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(517,8082,147,40720,1527,3,217,1,15450.66,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(518,8082,147,40720,1527,3,68,1,3244.64,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(519,8082,147,40720,1527,3,57,2,18695.30,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(520,8082,148,40720,1527,3,217,1,56000.00,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(521,8082,148,40720,1527,3,68,1,5880.00,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(522,8082,148,40720,1527,3,57,2,61880.00,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(523,8082,149,40720,1527,3,217,1,236728.40,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(524,8082,149,40720,1527,3,68,1,24856.48,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(525,8082,149,40720,1527,3,217,1,4142.75,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(526,8082,149,40720,1527,3,57,2,265727.63,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(527,8082,150,40720,1527,3,217,2,1558.54,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(528,8082,150,40720,1527,3,67,2,327.29,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(529,8082,150,40720,1527,3,217,2,38.96,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(530,8082,150,40720,1527,3,57,1,1924.79,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(531,8082,151,40720,1527,3,217,1,8155.82,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(532,8082,151,40720,1527,3,68,1,1712.72,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(533,8082,151,40720,1527,3,217,1,203.90,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(534,8082,151,40720,1527,3,57,2,10072.44,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(535,8082,152,40721,3037,2,96,2,172020.00,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(536,8082,152,40721,3037,2,67,2,36124.20,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(537,8082,152,40721,3037,2,13,1,208144.20,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(538,8082,153,40721,3037,2,96,2,196266.48,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(539,8082,153,40721,3037,2,67,2,41215.96,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(540,8082,153,40721,3037,2,218,2,0.02,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(541,8082,153,40721,3037,2,13,1,237482.46,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(542,8082,154,40721,3037,2,96,2,59509.14,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL);
INSERT INTO `balance_libro_details` VALUES (543,8082,154,40721,3037,2,67,2,12496.92,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(544,8082,154,40721,3037,2,13,1,72006.06,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(545,8082,155,40721,3037,2,96,2,12247.95,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(546,8082,155,40721,3037,2,67,2,2572.07,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(547,8082,155,40721,3037,2,218,2,0.02,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(548,8082,155,40721,3037,2,13,1,14820.04,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(549,8082,156,40721,3037,2,96,2,313286.00,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(550,8082,156,40721,3037,2,67,2,65790.06,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(551,8082,156,40721,3037,2,13,1,379076.06,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(552,8082,157,40721,3037,2,96,2,162400.00,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(553,8082,157,40721,3037,2,67,2,34104.00,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(554,8082,157,40721,3037,2,13,1,196504.00,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(555,8082,158,40721,3037,2,96,2,265246.81,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(556,8082,158,40721,3037,2,67,2,55701.83,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(557,8082,158,40721,3037,2,218,2,0.04,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(558,8082,158,40721,3037,2,13,1,320948.68,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(559,8082,159,40721,3037,2,96,2,33600.00,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(560,8082,159,40721,3037,2,67,2,7056.00,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(561,8082,159,40721,3037,2,13,1,40656.00,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(562,8082,160,40721,3037,2,96,2,61272.76,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(563,8082,160,40721,3037,2,67,2,12867.28,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(564,8082,160,40721,3037,2,218,2,0.02,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(565,8082,160,40721,3037,2,13,1,74140.06,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(566,8082,161,40721,3037,2,96,2,267155.62,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(567,8082,161,40721,3037,2,67,2,56102.68,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(568,8082,161,40721,3037,2,218,2,0.02,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(569,8082,161,40721,3037,2,13,1,323258.32,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(570,8082,162,40721,3037,2,96,2,415269.43,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(571,8082,162,40721,3037,2,67,2,87206.58,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(572,8082,162,40721,3037,2,218,2,0.01,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(573,8082,162,40721,3037,2,13,1,502476.02,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(574,8082,163,40721,3037,2,96,2,280386.90,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(575,8082,163,40721,3037,2,67,2,58881.25,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(576,8082,163,40721,3037,2,218,2,0.15,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(577,8082,163,40721,3037,2,13,1,339268.30,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(578,8082,164,40721,3037,2,96,2,149440.05,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(579,8082,164,40721,3037,2,67,2,31382.41,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(580,8082,164,40721,3037,2,218,2,0.01,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(581,8082,164,40721,3037,2,13,1,180822.47,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(582,8082,165,40721,3037,2,96,2,36200.00,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(583,8082,165,40721,3037,2,67,2,7602.00,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL);
INSERT INTO `balance_libro_details` VALUES (584,8082,165,40721,3037,2,13,1,43802.00,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(585,8082,166,40721,3037,2,96,2,150940.00,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(586,8082,166,40721,3037,2,67,2,31697.40,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(587,8082,166,40721,3037,2,13,1,182637.40,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(588,8082,167,40721,3037,2,96,2,169422.38,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(589,8082,167,40721,3037,2,67,2,35578.70,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(590,8082,167,40721,3037,2,218,2,0.02,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(591,8082,167,40721,3037,2,13,1,205001.10,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(592,8082,168,40721,3037,2,96,2,229359.48,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(593,8082,168,40721,3037,2,67,2,48165.49,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(594,8082,168,40721,3037,2,13,1,277524.97,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(595,8082,169,40721,3037,2,96,2,179784.00,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(596,8082,169,40721,3037,2,67,2,37754.64,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(597,8082,169,40721,3037,2,13,1,217538.64,NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(598,8082,170,40721,3037,2,96,2,233489.52,NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(599,8082,170,40721,3037,2,67,2,49032.80,NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(600,8082,170,40721,3037,2,218,2,0.02,NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(601,8082,170,40721,3037,2,13,1,282522.34,NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(602,8082,171,40721,3037,2,96,2,638682.00,NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(603,8082,171,40721,3037,2,67,2,134123.22,NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(604,8082,171,40721,3037,2,13,1,772805.22,NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(605,8082,172,40721,3037,2,96,2,740070.00,NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(606,8082,172,40721,3037,2,67,2,155414.70,NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(607,8082,172,40721,3037,2,13,1,895484.70,NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(608,8082,173,40721,3037,2,96,2,810000.00,NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(609,8082,173,40721,3037,2,67,2,170100.00,NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(610,8082,173,40721,3037,2,13,1,980100.00,NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(611,8082,174,40721,3037,3,250,1,14563.22,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(612,8082,174,40721,3037,3,68,1,3058.25,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(613,8082,174,40721,3037,3,57,2,17621.47,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(614,8082,175,40721,3037,3,221,1,1096.17,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(615,8082,175,40721,3037,3,235,1,1096.18,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(616,8082,175,40721,3037,3,250,1,36539.00,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(617,8082,175,40721,3037,3,68,1,7673.19,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(618,8082,175,40721,3037,3,57,2,46404.54,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(619,8082,176,40721,3037,3,250,1,20600.39,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(620,8082,176,40721,3037,3,68,1,2163.04,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(621,8082,176,40721,3037,3,250,1,2060.04,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(622,8082,176,40721,3037,3,57,2,24823.47,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(623,8082,177,40721,3037,3,250,1,745102.10,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(624,8082,177,40721,3037,3,68,1,156471.44,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL);
INSERT INTO `balance_libro_details` VALUES (625,8082,177,40721,3037,3,57,2,901573.54,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(626,8082,178,40721,3037,3,235,1,154.05,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(627,8082,178,40721,3037,3,250,1,30809.37,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(628,8082,178,40721,3037,3,68,1,6469.97,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(629,8082,178,40721,3037,3,57,2,37433.39,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(630,8082,179,40721,3037,3,250,1,6171.38,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(631,8082,179,40721,3037,3,68,1,1295.98,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(632,8082,179,40721,3037,3,57,2,7467.36,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(633,8082,180,40721,3037,3,235,1,1538.89,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(634,8082,180,40721,3037,3,250,1,51296.22,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(635,8082,180,40721,3037,3,68,1,10772.21,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(636,8082,180,40721,3037,3,57,2,63607.32,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(637,8082,181,40721,3037,3,221,1,447.35,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(638,8082,181,40721,3037,3,250,1,89469.60,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(639,8082,181,40721,3037,3,68,1,18788.62,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(640,8082,181,40721,3037,3,57,2,108705.57,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(641,8082,182,40721,3037,3,221,1,2937.81,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(642,8082,182,40721,3037,3,235,1,221.07,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(643,8082,182,40721,3037,3,250,1,11274.10,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(644,8082,182,40721,3037,3,68,1,2367.56,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(645,8082,182,40721,3037,3,250,1,1579.46,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(646,8082,182,40721,3037,3,57,2,18380.00,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(647,8082,183,40721,3037,3,250,1,21623.21,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(648,8082,183,40721,3037,3,68,1,4540.88,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(649,8082,183,40721,3037,3,57,2,26164.09,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(650,8082,184,40721,3037,3,250,1,57834.00,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(651,8082,184,40721,3037,3,68,1,12145.14,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(652,8082,184,40721,3037,3,57,2,69979.14,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(653,8082,185,40721,3037,3,235,1,1052.63,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(654,8082,185,40721,3037,3,250,1,210525.58,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(655,8082,185,40721,3037,3,68,1,44210.37,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(656,8082,185,40721,3037,3,57,2,255788.58,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(657,8082,186,40721,3037,3,221,1,14149.07,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(658,8082,186,40721,3037,3,235,1,14149.07,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(659,8082,186,40721,3037,3,217,1,471635.76,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(660,8082,186,40721,3037,3,68,1,99043.51,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(661,8082,186,40721,3037,3,217,1,0.02,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(662,8082,186,40721,3037,3,57,2,598977.43,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(663,8082,187,40721,3037,3,250,1,1733223.14,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(664,8082,187,40721,3037,3,68,1,363976.86,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(665,8082,187,40721,3037,3,57,2,2097200.00,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL);
INSERT INTO `balance_libro_details` VALUES (666,8082,188,40721,3037,3,217,1,758542.38,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(667,8082,188,40721,3037,3,68,1,159293.90,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(668,8082,188,40721,3037,3,217,1,0.02,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(669,8082,188,40721,3037,3,57,2,917836.30,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(670,8082,189,40721,3037,3,217,1,11942.15,NULL,'2022-12-10 08:41:52','2022-12-10 08:41:52',NULL),(671,8082,189,40721,3037,3,68,1,2507.85,NULL,'2022-12-10 08:41:52','2022-12-10 08:41:52',NULL),(672,8082,189,40721,3037,3,224,1,145.80,NULL,'2022-12-10 08:41:52','2022-12-10 08:41:52',NULL),(673,8082,189,40721,3037,3,57,2,14595.80,NULL,'2022-12-10 08:41:52','2022-12-10 08:41:52',NULL),(674,8082,190,40723,4555,3,217,1,125648.00,NULL,'2022-12-10 09:01:08','2022-12-10 09:01:08',NULL),(675,8082,190,40723,4555,3,68,1,26386.08,NULL,'2022-12-10 09:01:08','2022-12-10 09:01:08',NULL),(676,8082,190,40723,4555,3,222,1,12582.10,NULL,'2022-12-10 09:01:08','2022-12-10 09:01:08',NULL),(677,8082,190,40723,4555,3,57,2,164616.18,NULL,'2022-12-10 09:01:08','2022-12-10 09:01:08',NULL),(678,8082,192,40864,112062,2,96,2,84634.24,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(679,8082,192,40864,112062,2,67,2,17773.19,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(680,8082,192,40864,112062,2,96,2,33381.81,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(681,8082,192,40864,112062,2,67,2,3505.09,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(682,8082,192,40864,112062,2,13,1,139294.33,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(683,8082,193,40864,112062,2,96,2,43370.71,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(684,8082,193,40864,112062,2,67,2,9107.85,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(685,8082,193,40864,112062,2,96,2,24097.81,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(686,8082,193,40864,112062,2,67,2,2530.27,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(687,8082,193,40864,112062,2,13,1,79106.64,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(688,8082,194,40864,112062,2,96,2,79103.76,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(689,8082,194,40864,112062,2,67,2,16611.79,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(690,8082,194,40864,112062,2,96,2,27053.90,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(691,8082,194,40864,112062,2,67,2,2840.66,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(692,8082,194,40864,112062,2,13,1,125610.11,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(693,8082,195,40864,112062,2,96,2,61748.71,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(694,8082,195,40864,112062,2,67,2,12967.23,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(695,8082,195,40864,112062,2,96,2,25678.95,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(696,8082,195,40864,112062,2,67,2,2696.29,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(697,8082,195,40864,112062,2,13,1,103091.18,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(698,8082,196,40864,112062,2,96,2,49729.95,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(699,8082,196,40864,112062,2,67,2,10443.29,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(700,8082,196,40864,112062,2,96,2,24072.00,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(701,8082,196,40864,112062,2,67,2,2527.56,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(702,8082,196,40864,112062,2,13,1,86772.80,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(703,8082,197,40864,112062,2,96,2,111809.86,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(704,8082,197,40864,112062,2,67,2,23480.07,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(705,8082,197,40864,112062,2,96,2,69464.00,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(706,8082,197,40864,112062,2,67,2,7293.72,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL);
INSERT INTO `balance_libro_details` VALUES (707,8082,197,40864,112062,2,13,1,212047.65,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(708,8082,198,40864,112062,2,96,2,31157.52,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(709,8082,198,40864,112062,2,67,2,6543.08,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(710,8082,198,40864,112062,2,96,2,11304.57,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(711,8082,198,40864,112062,2,67,2,1186.98,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(712,8082,198,40864,112062,2,13,1,50192.15,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(713,8082,199,40864,112062,2,96,2,69435.62,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(714,8082,199,40864,112062,2,67,2,14581.48,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(715,8082,199,40864,112062,2,96,2,24943.90,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(716,8082,199,40864,112062,2,67,2,2619.11,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(717,8082,199,40864,112062,2,13,1,111580.11,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(718,8082,200,40864,112062,2,96,2,37330.24,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(719,8082,200,40864,112062,2,67,2,7839.35,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(720,8082,200,40864,112062,2,96,2,16831.52,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(721,8082,200,40864,112062,2,67,2,1767.31,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(722,8082,200,40864,112062,2,13,1,63768.42,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(723,8082,201,40864,112062,2,96,2,65212.57,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(724,8082,201,40864,112062,2,67,2,13694.64,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(725,8082,201,40864,112062,2,96,2,29366.76,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(726,8082,201,40864,112062,2,67,2,3083.51,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(727,8082,201,40864,112062,2,13,1,111357.48,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(728,8082,202,40864,112062,2,96,2,73123.10,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(729,8082,202,40864,112062,2,67,2,15355.85,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(730,8082,202,40864,112062,2,96,2,27487.52,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(731,8082,202,40864,112062,2,67,2,2886.19,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(732,8082,202,40864,112062,2,13,1,118852.66,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(733,8082,203,40864,112062,2,96,2,91819.67,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(734,8082,203,40864,112062,2,67,2,19282.13,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(735,8082,203,40864,112062,2,96,2,35937.52,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(736,8082,203,40864,112062,2,67,2,3773.44,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(737,8082,203,40864,112062,2,13,1,150812.76,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(738,8082,204,40864,112062,2,96,2,101534.38,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(739,8082,204,40864,112062,2,67,2,21322.22,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(740,8082,204,40864,112062,2,96,2,48696.86,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(741,8082,204,40864,112062,2,67,2,5113.17,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(742,8082,204,40864,112062,2,13,1,176666.63,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(743,8082,205,40864,112062,2,96,2,38396.19,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(744,8082,205,40864,112062,2,67,2,8063.20,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(745,8082,205,40864,112062,2,96,2,20938.86,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(746,8082,205,40864,112062,2,67,2,2198.58,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL);
INSERT INTO `balance_libro_details` VALUES (747,8082,205,40864,112062,2,13,1,69596.83,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(748,8082,206,40864,112062,2,96,2,83026.10,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(749,8082,206,40864,112062,2,67,2,17435.48,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(750,8082,206,40864,112062,2,96,2,38973.52,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(751,8082,206,40864,112062,2,67,2,4092.22,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(752,8082,206,40864,112062,2,13,1,143527.32,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(753,8082,207,40864,112062,2,96,2,51866.62,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(754,8082,207,40864,112062,2,67,2,10891.99,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(755,8082,207,40864,112062,2,96,2,27160.29,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(756,8082,207,40864,112062,2,67,2,2851.83,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(757,8082,207,40864,112062,2,13,1,92770.73,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(758,8082,208,40864,112062,2,96,2,62540.52,NULL,'2023-01-17 23:54:03','2023-01-17 23:54:03',NULL),(759,8082,208,40864,112062,2,67,2,13133.51,NULL,'2023-01-17 23:54:03','2023-01-17 23:54:03',NULL),(760,8082,208,40864,112062,2,96,2,18092.19,NULL,'2023-01-17 23:54:03','2023-01-17 23:54:03',NULL),(761,8082,208,40864,112062,2,67,2,1899.68,NULL,'2023-01-17 23:54:03','2023-01-17 23:54:03',NULL),(762,8082,208,40864,112062,2,13,1,95665.90,NULL,'2023-01-17 23:54:03','2023-01-17 23:54:03',NULL),(763,8082,209,40864,112062,2,96,2,77224.10,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(764,8082,209,40864,112062,2,67,2,16217.06,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(765,8082,209,40864,112062,2,96,2,38309.05,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(766,8082,209,40864,112062,2,67,2,4022.45,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(767,8082,209,40864,112062,2,13,1,135772.66,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(768,8082,210,40864,112062,2,96,2,91319.52,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(769,8082,210,40864,112062,2,67,2,19177.10,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(770,8082,210,40864,112062,2,96,2,36327.71,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(771,8082,210,40864,112062,2,67,2,3814.41,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(772,8082,210,40864,112062,2,13,1,150638.74,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(773,8082,211,40864,112062,2,96,2,89048.90,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(774,8082,211,40864,112062,2,67,2,18700.27,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(775,8082,211,40864,112062,2,96,2,28503.71,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(776,8082,211,40864,112062,2,67,2,2992.89,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(777,8082,211,40864,112062,2,13,1,139245.77,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(778,8082,212,40864,112062,2,96,2,2274.38,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(779,8082,212,40864,112062,2,67,2,477.62,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(780,8082,212,40864,112062,2,13,1,2752.00,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(781,8082,213,40864,112062,2,96,2,114916.19,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(782,8082,213,40864,112062,2,67,2,24132.40,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(783,8082,213,40864,112062,2,96,2,52305.43,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(784,8082,213,40864,112062,2,67,2,5492.07,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(785,8082,213,40864,112062,2,13,1,196846.09,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(786,8082,214,40864,112062,2,96,2,120862.24,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL);
INSERT INTO `balance_libro_details` VALUES (787,8082,214,40864,112062,2,67,2,25381.07,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(788,8082,214,40864,112062,2,96,2,38852.95,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(789,8082,214,40864,112062,2,67,2,4079.56,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(790,8082,214,40864,112062,2,13,1,189175.82,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(791,8082,215,40864,112062,2,96,2,31298.38,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(792,8082,215,40864,112062,2,67,2,6572.66,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(793,8082,215,40864,112062,2,96,2,13818.95,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(794,8082,215,40864,112062,2,67,2,1450.99,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(795,8082,215,40864,112062,2,13,1,53140.98,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(796,8082,216,40864,112062,2,96,2,129747.48,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(797,8082,216,40864,112062,2,67,2,27246.97,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(798,8082,216,40864,112062,2,96,2,68753.14,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(799,8082,216,40864,112062,2,67,2,7219.08,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(800,8082,216,40864,112062,2,13,1,232966.67,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(801,8082,217,40864,112062,2,96,2,69560.57,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(802,8082,217,40864,112062,2,67,2,14607.72,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(803,8082,217,40864,112062,2,96,2,28235.24,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(804,8082,217,40864,112062,2,67,2,2964.70,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(805,8082,217,40864,112062,2,13,1,115368.23,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(806,8082,218,40864,112062,2,96,2,72324.90,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(807,8082,218,40864,112062,2,67,2,15188.23,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(808,8082,218,40864,112062,2,96,2,18737.05,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(809,8082,218,40864,112062,2,67,2,1967.39,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(810,8082,218,40864,112062,2,13,1,108217.57,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(811,8082,219,40864,112062,2,96,2,82816.67,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(812,8082,219,40864,112062,2,67,2,17391.50,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(813,8082,219,40864,112062,2,96,2,29226.76,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(814,8082,219,40864,112062,2,67,2,3068.81,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(815,8082,219,40864,112062,2,13,1,132503.74,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(816,8082,220,40864,112062,2,96,2,84981.52,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(817,8082,220,40864,112062,2,67,2,17846.12,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(818,8082,220,40864,112062,2,96,2,43938.76,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(819,8082,220,40864,112062,2,67,2,4613.57,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(820,8082,220,40864,112062,2,13,1,151379.97,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(821,8082,221,40864,112062,2,96,2,116575.67,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(822,8082,221,40864,112062,2,67,2,24480.89,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(823,8082,221,40864,112062,2,96,2,69768.76,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(824,8082,221,40864,112062,2,67,2,7325.72,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(825,8082,221,40864,112062,2,13,1,218151.04,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(826,8082,222,40864,112062,2,96,2,24818.29,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL);
INSERT INTO `balance_libro_details` VALUES (827,8082,222,40864,112062,2,67,2,5211.84,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(828,8082,222,40864,112062,2,96,2,4293.71,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(829,8082,222,40864,112062,2,67,2,450.84,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(830,8082,222,40864,112062,2,13,1,34774.68,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(831,8082,223,40864,112062,2,96,2,26171.90,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(832,8082,223,40864,112062,2,67,2,2748.05,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(833,8082,223,40864,112062,2,96,2,39322.33,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(834,8082,223,40864,112062,2,67,2,8257.69,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(835,8082,223,40864,112062,2,218,2,0.03,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(836,8082,223,40864,112062,2,13,1,76500.00,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(837,8082,224,40864,112062,2,96,2,179.14,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(838,8082,224,40864,112062,2,67,2,18.81,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(839,8082,224,40864,112062,2,96,2,1293.38,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(840,8082,224,40864,112062,2,67,2,271.61,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(841,8082,224,40864,112062,2,218,2,0.05,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(842,8082,224,40864,112062,2,13,1,1762.99,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(843,8082,225,40864,112062,2,96,2,4785.14,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(844,8082,225,40864,112062,2,67,2,1004.88,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(845,8082,225,40864,112062,2,218,2,0.02,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(846,8082,225,40864,112062,2,13,1,5790.04,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(847,8082,226,40864,112062,2,96,2,6298.67,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(848,8082,226,40864,112062,2,67,2,661.36,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(849,8082,226,40864,112062,2,218,2,0.03,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(850,8082,226,40864,112062,2,13,1,6960.06,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(851,8082,227,40864,112062,2,96,2,4177.67,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(852,8082,227,40864,112062,2,67,2,877.31,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(853,8082,227,40864,112062,2,218,2,0.02,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(854,8082,227,40864,112062,2,13,1,5055.00,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(855,8082,228,40864,112062,2,96,2,618.10,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(856,8082,228,40864,112062,2,67,2,64.90,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(857,8082,228,40864,112062,2,96,2,1566.10,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(858,8082,228,40864,112062,2,67,2,328.88,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(859,8082,228,40864,112062,2,218,2,0.02,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(860,8082,228,40864,112062,2,13,1,2578.00,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(861,8082,229,40864,112062,2,96,2,221.71,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(862,8082,229,40864,112062,2,67,2,23.28,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(863,8082,229,40864,112062,2,96,2,1994.24,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(864,8082,229,40864,112062,2,67,2,418.79,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(865,8082,229,40864,112062,2,218,2,0.02,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(866,8082,229,40864,112062,2,13,1,2658.04,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(867,8082,230,40864,112062,2,96,2,3868.57,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL);
INSERT INTO `balance_libro_details` VALUES (868,8082,230,40864,112062,2,67,2,812.40,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(869,8082,230,40864,112062,2,218,2,0.03,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(870,8082,230,40864,112062,2,13,1,4681.00,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(871,8082,231,40864,112062,2,96,2,48325.81,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(872,8082,231,40864,112062,2,67,2,5074.21,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(873,8082,231,40864,112062,2,96,2,49842.95,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(874,8082,231,40864,112062,2,67,2,10467.02,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(875,8082,231,40864,112062,2,218,2,0.01,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(876,8082,231,40864,112062,2,13,1,113710.00,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(877,8082,232,40864,112062,2,96,2,180.95,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(878,8082,232,40864,112062,2,67,2,19.00,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(879,8082,232,40864,112062,2,96,2,5545.48,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(880,8082,232,40864,112062,2,67,2,1164.55,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(881,8082,232,40864,112062,2,218,2,0.02,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(882,8082,232,40864,112062,2,13,1,6910.00,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(883,8082,233,40864,112062,2,96,2,1385.52,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(884,8082,233,40864,112062,2,67,2,145.48,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(885,8082,233,40864,112062,2,13,1,1531.00,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(886,8082,234,40864,112062,2,96,2,1214.48,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(887,8082,234,40864,112062,2,67,2,127.52,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(888,8082,234,40864,112062,2,96,2,1842.14,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(889,8082,234,40864,112062,2,67,2,386.85,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(890,8082,234,40864,112062,2,218,2,0.01,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(891,8082,234,40864,112062,2,13,1,3571.00,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(892,8082,235,40864,112062,2,96,2,23559.24,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(893,8082,235,40864,112062,2,67,2,2473.72,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(894,8082,235,40864,112062,2,96,2,107864.48,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(895,8082,235,40864,112062,2,67,2,22651.54,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(896,8082,235,40864,112062,2,218,2,0.02,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(897,8082,235,40864,112062,2,13,1,156549.00,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(898,8082,236,40864,112062,2,96,2,1239.67,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(899,8082,236,40864,112062,2,67,2,260.33,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(900,8082,236,40864,112062,2,13,1,1500.00,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(901,8082,237,40864,112062,2,96,2,5366.48,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(902,8082,237,40864,112062,2,67,2,563.48,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(903,8082,237,40864,112062,2,96,2,5070.24,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(904,8082,237,40864,112062,2,67,2,1064.75,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(905,8082,237,40864,112062,2,218,2,0.04,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(906,8082,237,40864,112062,2,13,1,12064.99,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(907,8082,238,40864,112062,2,96,2,3564.67,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(908,8082,238,40864,112062,2,67,2,374.29,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL);
INSERT INTO `balance_libro_details` VALUES (909,8082,238,40864,112062,2,96,2,7933.90,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(910,8082,238,40864,112062,2,67,2,1666.12,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(911,8082,238,40864,112062,2,218,2,0.02,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(912,8082,238,40864,112062,2,13,1,13539.00,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(913,8082,239,40864,112062,2,96,2,2572.86,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(914,8082,239,40864,112062,2,67,2,270.15,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(915,8082,239,40864,112062,2,96,2,876.05,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(916,8082,239,40864,112062,2,67,2,183.97,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(917,8082,239,40864,112062,2,218,2,0.03,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(918,8082,239,40864,112062,2,13,1,3903.06,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(919,8082,240,40864,112062,2,96,2,4849.81,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(920,8082,240,40864,112062,2,67,2,509.23,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(921,8082,240,40864,112062,2,96,2,1084.29,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(922,8082,240,40864,112062,2,67,2,227.70,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(923,8082,240,40864,112062,2,218,2,0.03,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(924,8082,240,40864,112062,2,13,1,6671.06,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(925,8082,241,40864,112062,2,96,2,2859.71,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(926,8082,241,40864,112062,2,67,2,300.27,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(927,8082,241,40864,112062,2,218,2,0.02,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(928,8082,241,40864,112062,2,13,1,3160.00,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(929,8082,242,40864,112062,2,96,2,19909.52,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(930,8082,242,40864,112062,2,67,2,2090.50,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(931,8082,242,40864,112062,2,218,2,0.02,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(932,8082,242,40864,112062,2,13,1,22000.04,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(933,8082,243,40864,112062,2,96,2,819.90,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(934,8082,243,40864,112062,2,67,2,86.09,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(935,8082,243,40864,112062,2,96,2,1450.43,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(936,8082,243,40864,112062,2,67,2,304.59,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(937,8082,243,40864,112062,2,218,2,0.01,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(938,8082,243,40864,112062,2,13,1,2661.02,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(939,8082,244,40864,112062,2,96,2,488.67,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(940,8082,244,40864,112062,2,67,2,51.31,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(941,8082,244,40864,112062,2,96,2,1966.95,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(942,8082,244,40864,112062,2,67,2,413.06,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(943,8082,244,40864,112062,2,218,2,0.01,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(944,8082,244,40864,112062,2,13,1,2920.00,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(945,8082,245,40864,112062,2,96,2,2896.86,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(946,8082,245,40864,112062,2,67,2,304.17,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(947,8082,245,40864,112062,2,96,2,1771.10,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(948,8082,245,40864,112062,2,67,2,371.93,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(949,8082,245,40864,112062,2,218,2,0.05,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL);
INSERT INTO `balance_libro_details` VALUES (950,8082,245,40864,112062,2,13,1,5344.11,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(951,8082,246,40864,112062,2,96,2,5921.24,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(952,8082,246,40864,112062,2,67,2,621.73,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(953,8082,246,40864,112062,2,218,2,0.03,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(954,8082,246,40864,112062,2,13,1,6543.00,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(955,8082,247,40864,112062,2,96,2,454.52,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(956,8082,247,40864,112062,2,67,2,95.45,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(957,8082,247,40864,112062,2,218,2,0.03,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(958,8082,247,40864,112062,2,13,1,550.00,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(959,8082,248,40864,112062,2,96,2,3320.38,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(960,8082,248,40864,112062,2,67,2,348.64,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(961,8082,248,40864,112062,2,96,2,1644.62,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(962,8082,248,40864,112062,2,67,2,345.37,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(963,8082,248,40864,112062,2,218,2,0.01,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(964,8082,248,40864,112062,2,13,1,5659.02,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(965,8082,249,40864,112062,2,96,2,2658.86,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(966,8082,249,40864,112062,2,67,2,279.18,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(967,8082,249,40864,112062,2,96,2,307.43,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(968,8082,249,40864,112062,2,67,2,64.56,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(969,8082,249,40864,112062,2,218,2,0.03,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(970,8082,249,40864,112062,2,13,1,3310.06,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(971,8082,250,40864,112062,2,96,2,901.33,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(972,8082,250,40864,112062,2,67,2,94.64,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(973,8082,250,40864,112062,2,96,2,5940.48,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(974,8082,250,40864,112062,2,67,2,1247.50,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(975,8082,250,40864,112062,2,218,2,0.04,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(976,8082,250,40864,112062,2,13,1,8183.99,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(977,8082,251,40864,112062,2,96,2,52533.90,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(978,8082,251,40864,112062,2,67,2,5516.06,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(979,8082,251,40864,112062,2,96,2,23099.19,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(980,8082,251,40864,112062,2,67,2,4850.83,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(981,8082,251,40864,112062,2,218,2,0.02,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(982,8082,251,40864,112062,2,13,1,86000.00,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(983,8082,252,40864,112062,2,96,2,2285.05,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(984,8082,252,40864,112062,2,67,2,239.93,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(985,8082,252,40864,112062,2,96,2,2809.90,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(986,8082,252,40864,112062,2,67,2,590.08,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(987,8082,252,40864,112062,2,218,2,0.04,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(988,8082,252,40864,112062,2,13,1,5925.00,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(989,8082,253,40864,112062,2,96,2,1448.00,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(990,8082,253,40864,112062,2,67,2,152.04,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL);
INSERT INTO `balance_libro_details` VALUES (991,8082,253,40864,112062,2,96,2,1878.52,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(992,8082,253,40864,112062,2,67,2,394.49,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(993,8082,253,40864,112062,2,218,2,0.04,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(994,8082,253,40864,112062,2,13,1,3873.09,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(995,8082,254,40864,112062,2,96,2,1876.95,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(996,8082,254,40864,112062,2,67,2,197.08,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(997,8082,254,40864,112062,2,96,2,1084.29,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(998,8082,254,40864,112062,2,67,2,227.70,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(999,8082,254,40864,112062,2,218,2,0.02,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1000,8082,254,40864,112062,2,13,1,3386.04,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1001,8082,255,40864,112062,2,96,2,13082.67,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1002,8082,255,40864,112062,2,67,2,2747.36,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1003,8082,255,40864,112062,2,218,2,0.03,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1004,8082,255,40864,112062,2,13,1,15830.06,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1005,8082,256,40864,112062,2,96,2,3950.19,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1006,8082,256,40864,112062,2,67,2,414.77,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1007,8082,256,40864,112062,2,96,2,1031.43,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1008,8082,256,40864,112062,2,67,2,216.60,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1009,8082,256,40864,112062,2,218,2,0.01,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1010,8082,256,40864,112062,2,13,1,5613.00,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1011,8082,257,40864,112062,2,96,2,4824.48,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1012,8082,257,40864,112062,2,67,2,506.57,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1013,8082,257,40864,112062,2,96,2,181.81,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1014,8082,257,40864,112062,2,67,2,38.18,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1015,8082,257,40864,112062,2,218,2,0.04,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1016,8082,257,40864,112062,2,13,1,5551.08,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1017,8082,258,40864,112062,2,96,2,8804.95,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1018,8082,258,40864,112062,2,67,2,1849.04,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1019,8082,258,40864,112062,2,218,2,0.01,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1020,8082,258,40864,112062,2,13,1,10654.00,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1021,8082,259,40864,112062,2,96,2,1045.24,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1022,8082,259,40864,112062,2,67,2,109.75,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1023,8082,259,40864,112062,2,96,2,3074.38,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1024,8082,259,40864,112062,2,67,2,645.62,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1025,8082,259,40864,112062,2,218,2,0.01,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1026,8082,259,40864,112062,2,13,1,4875.00,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1027,8082,260,40864,112062,2,96,2,4434.38,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1028,8082,260,40864,112062,2,67,2,465.61,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1029,8082,260,40864,112062,2,218,2,0.01,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1030,8082,260,40864,112062,2,13,1,4900.00,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1031,8082,261,40864,112062,2,96,2,8478.52,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL);
INSERT INTO `balance_libro_details` VALUES (1032,8082,261,40864,112062,2,67,2,1780.49,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1033,8082,261,40864,112062,2,218,2,0.01,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1034,8082,261,40864,112062,2,13,1,10259.02,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1035,8082,262,40864,112062,2,96,2,427.14,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1036,8082,262,40864,112062,2,67,2,44.85,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1037,8082,262,40864,112062,2,96,2,1140.48,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1038,8082,262,40864,112062,2,67,2,239.50,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1039,8082,262,40864,112062,2,218,2,0.03,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1040,8082,262,40864,112062,2,13,1,1852.00,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1041,8082,263,40864,112062,2,96,2,4956.57,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1042,8082,263,40864,112062,2,67,2,520.44,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1043,8082,263,40864,112062,2,218,2,0.01,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1044,8082,263,40864,112062,2,13,1,5477.02,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1045,8082,264,40864,112062,2,96,2,1355.62,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1046,8082,264,40864,112062,2,67,2,142.34,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1047,8082,264,40864,112062,2,96,2,1961.14,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1048,8082,264,40864,112062,2,67,2,411.84,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1049,8082,264,40864,112062,2,218,2,0.05,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1050,8082,264,40864,112062,2,13,1,3870.99,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1051,8082,265,40864,112062,2,96,2,823.52,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1052,8082,265,40864,112062,2,67,2,86.47,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1053,8082,265,40864,112062,2,96,2,1772.71,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1054,8082,265,40864,112062,2,67,2,372.27,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1055,8082,265,40864,112062,2,218,2,0.03,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1056,8082,265,40864,112062,2,13,1,3055.00,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1057,8082,266,40864,112062,2,96,2,117.62,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1058,8082,266,40864,112062,2,67,2,12.35,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1059,8082,266,40864,112062,2,96,2,5035.52,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1060,8082,266,40864,112062,2,67,2,1057.46,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1061,8082,266,40864,112062,2,218,2,0.04,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1062,8082,266,40864,112062,2,13,1,6222.99,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1063,8082,267,40864,112062,2,96,2,4961.05,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1064,8082,267,40864,112062,2,67,2,520.91,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1065,8082,267,40864,112062,2,96,2,2442.14,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1066,8082,267,40864,112062,2,67,2,512.85,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1067,8082,267,40864,112062,2,218,2,0.04,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1068,8082,267,40864,112062,2,13,1,8436.99,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1069,8082,268,40864,112062,2,96,2,1175.52,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1070,8082,268,40864,112062,2,67,2,123.43,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1071,8082,268,40864,112062,2,96,2,2623.95,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1072,8082,268,40864,112062,2,67,2,551.03,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL);
INSERT INTO `balance_libro_details` VALUES (1073,8082,268,40864,112062,2,218,2,0.06,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1074,8082,268,40864,112062,2,13,1,4473.99,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1075,8082,269,40864,112062,2,96,2,3143.90,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1076,8082,269,40864,112062,2,67,2,330.11,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1077,8082,269,40864,112062,2,96,2,2388.43,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1078,8082,269,40864,112062,2,67,2,501.57,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1079,8082,269,40864,112062,2,218,2,0.01,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1080,8082,269,40864,112062,2,13,1,6364.02,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1081,8082,270,40864,112062,2,96,2,9247.95,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1082,8082,270,40864,112062,2,67,2,1942.07,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1083,8082,270,40864,112062,2,218,2,0.02,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1084,8082,270,40864,112062,2,13,1,11190.04,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1085,8082,271,40864,112062,2,96,2,55746.57,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1086,8082,271,40864,112062,2,67,2,5853.39,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1087,8082,271,40864,112062,2,96,2,31735.52,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1088,8082,271,40864,112062,2,67,2,6664.46,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1089,8082,271,40864,112062,2,218,2,0.05,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1090,8082,271,40864,112062,2,13,1,99999.99,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1091,8082,272,40864,112062,2,96,2,445248.86,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1092,8082,272,40864,112062,2,67,2,46751.13,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1093,8082,272,40864,112062,2,96,2,221735.52,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1094,8082,272,40864,112062,2,67,2,46564.46,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1095,8082,272,40864,112062,2,218,2,0.03,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1096,8082,272,40864,112062,2,13,1,760300.00,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1097,8082,273,40864,112062,2,96,2,6575.52,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1098,8082,273,40864,112062,2,67,2,690.43,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1099,8082,273,40864,112062,2,96,2,151.24,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1100,8082,273,40864,112062,2,67,2,31.76,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1101,8082,273,40864,112062,2,218,2,0.05,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1102,8082,273,40864,112062,2,13,1,7449.00,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1103,8082,274,40864,112062,2,96,2,185.52,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1104,8082,274,40864,112062,2,67,2,19.48,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1105,8082,274,40864,112062,2,96,2,2258.67,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1106,8082,274,40864,112062,2,67,2,474.32,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1107,8082,274,40864,112062,2,218,2,0.01,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1108,8082,274,40864,112062,2,13,1,2938.00,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1109,8082,275,40864,112062,2,96,2,5066.10,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1110,8082,275,40864,112062,2,67,2,1063.88,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1111,8082,275,40864,112062,2,218,2,0.02,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1112,8082,275,40864,112062,2,13,1,6130.00,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1113,8082,276,40864,112062,2,96,2,40542.95,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL);
INSERT INTO `balance_libro_details` VALUES (1114,8082,276,40864,112062,2,67,2,4257.01,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1115,8082,276,40864,112062,2,96,2,18347.10,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1116,8082,276,40864,112062,2,67,2,3852.89,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1117,8082,276,40864,112062,2,218,2,0.04,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1118,8082,276,40864,112062,2,13,1,66999.99,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(1119,8082,277,40864,112062,2,96,2,426.29,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1120,8082,277,40864,112062,2,67,2,44.76,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1121,8082,277,40864,112062,2,96,2,6175.19,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1122,8082,277,40864,112062,2,67,2,1296.79,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1123,8082,277,40864,112062,2,218,2,0.03,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1124,8082,277,40864,112062,2,13,1,7943.06,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1125,8082,278,40864,112062,2,96,2,4512.19,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1126,8082,278,40864,112062,2,67,2,473.78,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1127,8082,278,40864,112062,2,218,2,0.03,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1128,8082,278,40864,112062,2,13,1,4986.00,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1129,8082,279,40864,112062,2,96,2,6695.86,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1130,8082,279,40864,112062,2,67,2,1406.13,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1131,8082,279,40864,112062,2,218,2,0.01,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1132,8082,279,40864,112062,2,13,1,8102.00,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1133,8082,280,40864,112062,2,96,2,2235.33,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1134,8082,280,40864,112062,2,67,2,234.71,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1135,8082,280,40864,112062,2,96,2,550.43,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1136,8082,280,40864,112062,2,67,2,115.59,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1137,8082,280,40864,112062,2,218,2,0.05,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1138,8082,280,40864,112062,2,13,1,3136.11,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1139,8082,281,40864,112062,2,96,2,2695.90,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1140,8082,281,40864,112062,2,67,2,283.07,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1141,8082,281,40864,112062,2,96,2,297.52,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1142,8082,281,40864,112062,2,67,2,62.48,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1143,8082,281,40864,112062,2,218,2,0.03,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1144,8082,281,40864,112062,2,13,1,3339.00,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1145,8082,282,40864,112062,2,96,2,18642.57,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1146,8082,282,40864,112062,2,67,2,1957.47,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1147,8082,282,40864,112062,2,218,2,0.04,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1148,8082,282,40864,112062,2,13,1,20600.08,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1149,8082,283,40864,112062,2,96,2,1088.67,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1150,8082,283,40864,112062,2,67,2,114.31,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1151,8082,283,40864,112062,2,96,2,2024.81,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1152,8082,283,40864,112062,2,67,2,425.21,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1153,8082,283,40864,112062,2,13,1,3653.00,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1154,8082,284,40864,112062,2,96,2,4379.33,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL);
INSERT INTO `balance_libro_details` VALUES (1155,8082,284,40864,112062,2,67,2,919.66,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1156,8082,284,40864,112062,2,218,2,0.01,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1157,8082,284,40864,112062,2,13,1,5299.00,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1158,8082,285,40864,112062,2,96,2,580.95,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1159,8082,285,40864,112062,2,67,2,61.00,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1160,8082,285,40864,112062,2,96,2,2942.14,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1161,8082,285,40864,112062,2,67,2,617.85,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1162,8082,285,40864,112062,2,218,2,0.05,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1163,8082,285,40864,112062,2,13,1,4201.99,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1164,8082,286,40864,112062,2,96,2,9726.67,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1165,8082,286,40864,112062,2,67,2,1021.30,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1166,8082,286,40864,112062,2,96,2,1333.05,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1167,8082,286,40864,112062,2,67,2,279.94,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1168,8082,286,40864,112062,2,218,2,0.03,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1169,8082,286,40864,112062,2,13,1,12360.99,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(1170,8082,287,40864,112062,3,235,1,45.85,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1171,8082,287,40864,112062,3,250,1,1833.95,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1172,8082,287,40864,112062,3,68,1,385.13,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1173,8082,287,40864,112062,3,57,2,2264.93,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1174,8082,288,40864,112062,3,217,1,44359.38,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1175,8082,288,40864,112062,3,68,1,9315.47,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1176,8082,288,40864,112062,3,217,1,0.02,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1177,8082,288,40864,112062,3,57,2,53674.87,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1178,8082,289,40864,112062,3,235,1,24.20,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1179,8082,289,40864,112062,3,250,1,968.00,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1180,8082,289,40864,112062,3,68,1,203.28,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1181,8082,289,40864,112062,3,250,1,0.02,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1182,8082,289,40864,112062,3,57,2,1195.50,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1183,8082,290,40864,112062,3,217,1,5852.50,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1184,8082,290,40864,112062,3,57,2,5852.50,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1185,8082,291,40864,112062,3,235,1,568.13,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1186,8082,291,40864,112062,3,250,1,22724.82,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1187,8082,291,40864,112062,3,68,1,4772.21,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1188,8082,291,40864,112062,3,57,2,28065.16,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1189,8082,292,40864,112062,3,235,1,766.82,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1190,8082,292,40864,112062,3,250,1,30672.76,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1191,8082,292,40864,112062,3,68,1,6441.28,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1192,8082,292,40864,112062,3,57,2,37880.86,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(1193,8082,293,40864,112062,3,235,1,157.17,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1194,8082,293,40864,112062,3,250,1,6287.48,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL);
INSERT INTO `balance_libro_details` VALUES (1195,8082,293,40864,112062,3,68,1,1320.37,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1196,8082,293,40864,112062,3,57,2,7765.02,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1197,8082,294,40864,112062,3,235,1,428.52,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1198,8082,294,40864,112062,3,250,1,17140.70,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1199,8082,294,40864,112062,3,68,1,3599.54,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1200,8082,294,40864,112062,3,57,2,21168.76,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1201,8082,295,40864,112062,3,217,1,40702.19,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1202,8082,295,40864,112062,3,68,1,4273.73,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1203,8082,295,40864,112062,3,217,1,0.05,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1204,8082,295,40864,112062,3,57,2,44975.97,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1205,8082,296,40864,112062,3,235,1,64.87,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1206,8082,296,40864,112062,3,250,1,2594.63,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1207,8082,296,40864,112062,3,68,1,544.87,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1208,8082,296,40864,112062,3,57,2,3204.37,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1209,8082,297,40864,112062,3,217,1,34601.99,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1210,8082,297,40864,112062,3,57,2,34601.99,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1211,8082,298,40864,112062,3,250,1,51750.00,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1212,8082,298,40864,112062,3,68,1,5433.75,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1213,8082,298,40864,112062,3,57,2,57183.75,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1214,8082,299,40864,112062,3,221,1,195.99,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1215,8082,299,40864,112062,3,250,1,7839.55,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1216,8082,299,40864,112062,3,68,1,1646.31,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1217,8082,299,40864,112062,3,250,1,0.01,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1218,8082,299,40864,112062,3,57,2,9681.86,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1219,8082,300,40864,112062,3,250,1,35487.62,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1220,8082,300,40864,112062,3,68,1,7452.40,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1221,8082,300,40864,112062,3,250,1,0.01,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1222,8082,300,40864,112062,3,57,2,42940.03,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1223,8082,301,40864,112062,3,235,1,4779.48,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1224,8082,301,40864,112062,3,250,1,273113.32,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1225,8082,301,40864,112062,3,68,1,28676.90,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1226,8082,301,40864,112062,3,57,2,306569.70,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(1227,8082,302,40864,112062,3,221,1,454.70,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(1228,8082,302,40864,112062,3,250,1,18188.14,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(1229,8082,302,40864,112062,3,68,1,3819.51,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(1230,8082,302,40864,112062,3,57,2,22462.35,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(1231,8082,303,40864,112062,3,217,1,20371.00,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(1232,8082,303,40864,112062,3,57,2,20371.00,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(1233,8082,304,40864,112062,3,221,1,1149.53,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(1234,8082,304,40864,112062,3,235,1,430.96,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL);
INSERT INTO `balance_libro_details` VALUES (1235,8082,304,40864,112062,3,250,1,16088.74,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(1236,8082,304,40864,112062,3,68,1,3378.64,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(1237,8082,304,40864,112062,3,57,2,21047.87,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(1238,8082,305,40864,112062,3,250,1,8597.29,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(1239,8082,305,40864,112062,3,68,1,902.72,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(1240,8082,305,40864,112062,3,57,2,9500.01,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(1241,8082,306,40864,112062,3,250,1,110307.72,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(1242,8082,306,40864,112062,3,68,1,11582.31,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(1243,8082,306,40864,112062,3,57,2,121890.03,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(1244,8082,307,40864,112062,3,221,1,523.58,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1245,8082,307,40864,112062,3,250,1,20943.27,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1246,8082,307,40864,112062,3,68,1,4398.09,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1247,8082,307,40864,112062,3,57,2,25864.94,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1248,8082,308,40864,112062,3,220,1,1199.16,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1249,8082,308,40864,112062,3,250,1,39971.97,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1250,8082,308,40864,112062,3,68,1,8394.11,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1251,8082,308,40864,112062,3,57,2,49565.24,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1252,8082,309,40864,112062,3,235,1,118.05,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1253,8082,309,40864,112062,3,250,1,4722.00,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1254,8082,309,40864,112062,3,68,1,991.62,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1255,8082,309,40864,112062,3,57,2,5831.67,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1256,8082,310,40864,112062,3,235,1,97.46,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1257,8082,310,40864,112062,3,250,1,3898.40,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1258,8082,310,40864,112062,3,68,1,818.66,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1259,8082,310,40864,112062,3,250,1,0.02,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1260,8082,310,40864,112062,3,57,2,4814.54,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1261,8082,311,40864,112062,3,221,1,260.88,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1262,8082,311,40864,112062,3,250,1,10435.14,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1263,8082,311,40864,112062,3,68,1,2191.38,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1264,8082,311,40864,112062,3,57,2,12887.40,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1265,8082,312,40864,112062,3,220,1,916.65,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1266,8082,312,40864,112062,3,250,1,30555.02,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1267,8082,312,40864,112062,3,68,1,6416.55,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1268,8082,312,40864,112062,3,57,2,37888.22,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1269,8082,313,40864,112062,3,250,1,36652.96,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1270,8082,313,40864,112062,3,68,1,7697.12,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1271,8082,313,40864,112062,3,57,2,44350.08,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1272,8082,314,40864,112062,3,250,1,21028.50,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1273,8082,314,40864,112062,3,68,1,4415.99,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1274,8082,314,40864,112062,3,57,2,25444.49,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL);
INSERT INTO `balance_libro_details` VALUES (1275,8082,315,40864,112062,3,235,1,340.85,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1276,8082,315,40864,112062,3,250,1,13633.53,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1277,8082,315,40864,112062,3,68,1,2863.04,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1278,8082,315,40864,112062,3,57,2,16837.42,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1279,8082,316,40864,112062,3,235,1,246.29,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1280,8082,316,40864,112062,3,250,1,9851.78,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1281,8082,316,40864,112062,3,68,1,2068.87,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1282,8082,316,40864,112062,3,57,2,12166.94,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1283,8082,317,40864,112062,3,250,1,45350.00,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1284,8082,317,40864,112062,3,68,1,4761.75,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1285,8082,317,40864,112062,3,57,2,50111.75,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(1286,8082,318,40864,112062,3,250,1,26285.10,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1287,8082,318,40864,112062,3,68,1,5519.87,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1288,8082,318,40864,112062,3,250,1,0.01,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1289,8082,318,40864,112062,3,57,2,31804.98,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1290,8082,319,40864,112062,3,235,2,340.85,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1291,8082,319,40864,112062,3,250,2,13633.53,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1292,8082,319,40864,112062,3,67,2,2863.04,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1293,8082,319,40864,112062,3,57,1,16837.42,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1294,8082,320,40864,112062,3,235,2,246.29,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1295,8082,320,40864,112062,3,250,2,9851.78,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1296,8082,320,40864,112062,3,67,2,2068.87,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1297,8082,320,40864,112062,3,57,1,12166.94,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1298,8082,321,40864,112062,3,235,1,1000.19,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1299,8082,321,40864,112062,3,250,1,40007.78,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1300,8082,321,40864,112062,3,68,1,8401.63,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1301,8082,321,40864,112062,3,57,2,49409.60,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1302,8082,322,40864,112062,3,250,1,44800.00,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1303,8082,322,40864,112062,3,68,1,4704.00,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1304,8082,322,40864,112062,3,57,2,49504.00,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1305,8082,323,40864,112062,3,217,1,4107.95,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1306,8082,323,40864,112062,3,57,2,4107.95,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1307,8082,324,40864,112062,3,250,1,11276.86,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1308,8082,324,40864,112062,3,68,1,2368.14,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1309,8082,324,40864,112062,3,57,2,13645.00,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1310,8082,325,40864,112062,3,250,1,19370.00,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1311,8082,325,40864,112062,3,68,1,4067.70,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1312,8082,325,40864,112062,3,57,2,23437.70,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1313,8082,326,40864,112062,3,217,1,12826.37,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1314,8082,326,40864,112062,3,57,2,12826.37,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL);
INSERT INTO `balance_libro_details` VALUES (1315,8082,327,40864,112062,3,217,1,17043.77,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1316,8082,327,40864,112062,3,57,2,17043.77,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1317,8082,328,40864,112062,3,235,1,739.17,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1318,8082,328,40864,112062,3,250,1,29566.68,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1319,8082,328,40864,112062,3,68,1,6209.00,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1320,8082,328,40864,112062,3,57,2,36514.85,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1321,8082,329,40864,112062,3,250,1,31346.05,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1322,8082,329,40864,112062,3,68,1,6582.67,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1323,8082,329,40864,112062,3,250,1,0.01,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1324,8082,329,40864,112062,3,57,2,37928.73,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1325,8082,330,40864,112062,3,221,1,290.03,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1326,8082,330,40864,112062,3,250,1,11601.09,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1327,8082,330,40864,112062,3,68,1,2436.23,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1328,8082,330,40864,112062,3,57,2,14327.35,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1329,8082,331,40864,112062,3,250,1,3427.72,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1330,8082,331,40864,112062,3,68,1,719.82,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1331,8082,331,40864,112062,3,57,2,4147.54,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1332,8082,332,40864,112062,3,250,1,31071.29,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1333,8082,332,40864,112062,3,68,1,6524.97,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1334,8082,332,40864,112062,3,57,2,37596.26,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1335,8082,333,40864,112062,3,250,1,33021.53,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1336,8082,333,40864,112062,3,68,1,6934.52,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1337,8082,333,40864,112062,3,57,2,39956.05,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1338,8082,334,40864,112062,3,250,1,2986.43,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1339,8082,334,40864,112062,3,68,1,313.58,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1340,8082,334,40864,112062,3,57,2,3300.01,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1341,8082,335,40864,112062,3,221,1,364.13,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1342,8082,335,40864,112062,3,250,1,14565.02,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1343,8082,335,40864,112062,3,68,1,3058.65,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1344,8082,335,40864,112062,3,57,2,17987.80,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1345,8082,336,40864,112062,3,250,1,106647.05,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1346,8082,336,40864,112062,3,68,1,11197.94,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1347,8082,336,40864,112062,3,57,2,117844.99,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1348,8082,337,40864,112062,3,221,1,510.06,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1349,8082,337,40864,112062,3,250,1,6518.78,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1350,8082,337,40864,112062,3,68,1,684.47,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1351,8082,337,40864,112062,3,250,1,13883.58,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1352,8082,337,40864,112062,3,68,1,2915.55,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1353,8082,337,40864,112062,3,57,2,24512.44,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1354,8082,338,40864,112062,3,250,1,18163.75,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL);
INSERT INTO `balance_libro_details` VALUES (1355,8082,338,40864,112062,3,68,1,3814.39,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1356,8082,338,40864,112062,3,57,2,21978.14,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1357,8082,339,40864,112062,3,217,1,1000.00,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1358,8082,339,40864,112062,3,217,1,1000.00,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1359,8082,339,40864,112062,3,57,2,1000.00,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1360,8082,339,40864,112062,3,136,2,1000.00,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(1361,8082,340,40864,112062,3,217,1,1000.00,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1362,8082,340,40864,112062,3,217,1,1000.00,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1363,8082,340,40864,112062,3,57,2,1000.00,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1364,8082,340,40864,112062,3,136,2,1000.00,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1365,8082,341,40864,112062,3,235,1,238.90,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1366,8082,341,40864,112062,3,250,1,9555.98,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1367,8082,341,40864,112062,3,68,1,2006.75,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1368,8082,341,40864,112062,3,57,2,11801.63,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1369,8082,342,40864,112062,3,221,1,194.99,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1370,8082,342,40864,112062,3,217,1,7830.91,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1371,8082,342,40864,112062,3,68,1,1644.49,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1372,8082,342,40864,112062,3,217,1,234.93,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1373,8082,342,40864,112062,3,57,2,9905.32,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1374,8082,343,40864,112062,3,235,1,135.39,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1375,8082,343,40864,112062,3,250,1,5415.60,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1376,8082,343,40864,112062,3,68,1,1137.28,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1377,8082,343,40864,112062,3,57,2,6688.27,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1378,8082,344,40864,112062,3,235,1,247.20,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1379,8082,344,40864,112062,3,250,1,9887.60,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1380,8082,344,40864,112062,3,68,1,2076.40,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1381,8082,344,40864,112062,3,250,1,0.01,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1382,8082,344,40864,112062,3,57,2,12211.21,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1383,8082,345,40864,112062,3,250,1,59123.86,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1384,8082,345,40864,112062,3,68,1,12416.01,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1385,8082,345,40864,112062,3,57,2,71539.87,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1386,8082,346,40864,112062,3,250,1,22800.00,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1387,8082,346,40864,112062,3,68,1,2394.00,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1388,8082,346,40864,112062,3,57,2,25194.00,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1389,8082,347,40864,112062,3,250,1,64000.00,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1390,8082,347,40864,112062,3,68,1,6720.00,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1391,8082,347,40864,112062,3,57,2,70720.00,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1392,8082,348,40864,112062,3,235,1,265.06,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1393,8082,348,40864,112062,3,250,1,10602.45,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1394,8082,348,40864,112062,3,68,1,2226.51,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL);
INSERT INTO `balance_libro_details` VALUES (1395,8082,348,40864,112062,3,57,2,13094.02,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1396,8082,349,40864,112062,3,235,1,406.56,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1397,8082,349,40864,112062,3,250,1,16262.18,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1398,8082,349,40864,112062,3,68,1,3415.05,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1399,8082,349,40864,112062,3,57,2,20083.79,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1400,8082,350,40864,112062,3,250,1,27840.95,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1401,8082,350,40864,112062,3,68,1,5846.60,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1402,8082,350,40864,112062,3,57,2,33687.55,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1403,8082,351,40864,112062,3,235,1,39.74,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1404,8082,351,40864,112062,3,250,1,1589.75,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1405,8082,351,40864,112062,3,68,1,333.85,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1406,8082,351,40864,112062,3,57,2,1963.34,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1407,8082,352,40864,112062,3,235,1,171.00,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1408,8082,352,40864,112062,3,250,1,6840.00,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1409,8082,352,40864,112062,3,68,1,1436.40,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1410,8082,352,40864,112062,3,57,2,8447.40,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1411,8082,353,40864,112062,3,235,1,1055.12,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1412,8082,353,40864,112062,3,250,1,42203.91,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1413,8082,353,40864,112062,3,68,1,8862.82,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1414,8082,353,40864,112062,3,57,2,52121.85,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1415,8082,354,40864,112062,3,235,1,20.13,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1416,8082,354,40864,112062,3,250,1,805.03,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1417,8082,354,40864,112062,3,68,1,169.05,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1418,8082,354,40864,112062,3,57,2,994.21,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1419,8082,355,40864,112062,3,235,1,1518.31,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1420,8082,355,40864,112062,3,250,1,60732.26,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1421,8082,355,40864,112062,3,68,1,12753.77,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1422,8082,355,40864,112062,3,57,2,75004.34,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1423,8082,356,40864,112062,3,235,2,121.00,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1424,8082,356,40864,112062,3,250,2,4839.93,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1425,8082,356,40864,112062,3,67,2,1016.38,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1426,8082,356,40864,112062,3,57,1,5977.31,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1427,8082,357,40864,112062,3,235,2,37.13,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1428,8082,357,40864,112062,3,250,2,1485.17,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1429,8082,357,40864,112062,3,67,2,311.89,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1430,8082,357,40864,112062,3,57,1,1834.19,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1431,8082,358,40864,112062,3,235,2,20.13,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1432,8082,358,40864,112062,3,250,2,805.03,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1433,8082,358,40864,112062,3,67,2,169.05,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1434,8082,358,40864,112062,3,57,1,994.21,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL);
INSERT INTO `balance_libro_details` VALUES (1435,8082,359,40864,112062,3,250,1,51200.00,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1436,8082,359,40864,112062,3,68,1,5376.00,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1437,8082,359,40864,112062,3,57,2,56576.00,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(1438,8082,360,40864,112062,3,221,1,147.70,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1439,8082,360,40864,112062,3,250,1,5907.98,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1440,8082,360,40864,112062,3,68,1,1240.68,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1441,8082,360,40864,112062,3,250,1,0.01,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1442,8082,360,40864,112062,3,57,2,7296.37,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1443,8082,361,40864,112062,3,250,1,48435.10,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1444,8082,361,40864,112062,3,68,1,10171.37,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1445,8082,361,40864,112062,3,250,1,0.01,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1446,8082,361,40864,112062,3,57,2,58606.48,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1447,8082,362,40864,112062,3,221,1,452.11,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1448,8082,362,40864,112062,3,250,1,18084.41,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1449,8082,362,40864,112062,3,68,1,3797.73,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1450,8082,362,40864,112062,3,57,2,22334.25,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1451,8082,363,40864,112062,3,250,1,9545.40,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1452,8082,363,40864,112062,3,68,1,2004.53,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1453,8082,363,40864,112062,3,57,2,11549.93,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1454,8082,364,40864,112062,3,235,1,618.59,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1455,8082,364,40864,112062,3,250,1,24743.60,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1456,8082,364,40864,112062,3,68,1,5196.16,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1457,8082,364,40864,112062,3,57,2,30558.35,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1458,8082,365,40864,112062,3,235,1,4434.26,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1459,8082,365,40864,112062,3,250,1,253386.12,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1460,8082,365,40864,112062,3,68,1,26605.54,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1461,8082,365,40864,112062,3,57,2,284425.92,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1462,8082,366,40864,112062,3,235,1,70.78,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1463,8082,366,40864,112062,3,250,1,2831.39,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1464,8082,366,40864,112062,3,68,1,594.59,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1465,8082,366,40864,112062,3,57,2,3496.76,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1466,8082,367,40864,112062,3,221,1,878.06,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1467,8082,367,40864,112062,3,250,1,35122.46,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1468,8082,367,40864,112062,3,68,1,7375.72,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1469,8082,367,40864,112062,3,57,2,43376.24,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1470,8082,368,40864,112062,3,217,1,25045.52,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1471,8082,368,40864,112062,3,68,1,2629.78,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1472,8082,368,40864,112062,3,217,1,0.02,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1473,8082,368,40864,112062,3,57,2,27675.32,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1474,8082,369,40864,112062,3,221,1,2243.31,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL);
INSERT INTO `balance_libro_details` VALUES (1475,8082,369,40864,112062,3,235,1,1122.25,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1476,8082,369,40864,112062,3,250,1,42646.56,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1477,8082,369,40864,112062,3,68,1,8955.78,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1478,8082,369,40864,112062,3,57,2,54967.90,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1479,8082,370,40864,112062,3,250,1,32628.44,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1480,8082,370,40864,112062,3,68,1,6851.97,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1481,8082,370,40864,112062,3,57,2,39480.41,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1482,8082,371,40864,112062,3,235,1,2460.00,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1483,8082,371,40864,112062,3,250,1,164000.00,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1484,8082,371,40864,112062,3,68,1,17220.00,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1485,8082,371,40864,112062,3,57,2,183680.00,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1486,8082,372,40864,112062,3,220,1,1991.50,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1487,8082,372,40864,112062,3,250,1,66383.28,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1488,8082,372,40864,112062,3,68,1,13940.49,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1489,8082,372,40864,112062,3,250,1,0.01,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1490,8082,372,40864,112062,3,57,2,82315.28,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1491,8082,373,40864,112062,3,235,1,442.45,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1492,8082,373,40864,112062,3,250,1,17697.81,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1493,8082,373,40864,112062,3,68,1,3716.54,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1494,8082,373,40864,112062,3,57,2,21856.80,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1495,8082,374,40864,112062,3,235,1,442.45,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1496,8082,374,40864,112062,3,250,1,17697.81,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1497,8082,374,40864,112062,3,68,1,3716.54,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1498,8082,374,40864,112062,3,57,2,21856.80,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1499,8082,375,40864,112062,3,235,2,442.45,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1500,8082,375,40864,112062,3,250,2,17697.81,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1501,8082,375,40864,112062,3,67,2,3716.54,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1502,8082,375,40864,112062,3,57,1,21856.80,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1503,8082,376,40864,112062,3,221,1,572.51,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1504,8082,376,40864,112062,3,235,1,477.08,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1505,8082,376,40864,112062,3,217,1,19083.43,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1506,8082,376,40864,112062,3,68,1,4007.52,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1507,8082,376,40864,112062,3,217,1,0.01,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1508,8082,376,40864,112062,3,57,2,24140.55,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1509,8082,377,40864,112062,3,235,1,122.27,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1510,8082,377,40864,112062,3,250,1,4890.60,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1511,8082,377,40864,112062,3,68,1,1027.03,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1512,8082,377,40864,112062,3,57,2,6039.90,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1513,8082,378,40864,112062,3,235,1,233.88,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1514,8082,378,40864,112062,3,250,1,9355.00,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL);
INSERT INTO `balance_libro_details` VALUES (1515,8082,378,40864,112062,3,68,1,1964.55,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1516,8082,378,40864,112062,3,57,2,11553.43,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(1517,8082,379,40864,112062,3,235,1,178.27,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1518,8082,379,40864,112062,3,250,1,7130.66,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1519,8082,379,40864,112062,3,68,1,1497.44,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1520,8082,379,40864,112062,3,57,2,8806.37,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1521,8082,380,40864,112062,3,235,1,41.26,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1522,8082,380,40864,112062,3,250,1,1650.58,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1523,8082,380,40864,112062,3,68,1,346.62,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1524,8082,380,40864,112062,3,57,2,2038.46,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1525,8082,381,40864,112062,3,250,1,37800.00,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1526,8082,381,40864,112062,3,68,1,3969.00,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1527,8082,381,40864,112062,3,250,1,3480.00,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1528,8082,381,40864,112062,3,68,1,730.80,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1529,8082,381,40864,112062,3,57,2,45979.80,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1530,8082,382,40864,112062,3,235,1,329.63,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1531,8082,382,40864,112062,3,250,1,13185.19,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1532,8082,382,40864,112062,3,68,1,2768.88,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1533,8082,382,40864,112062,3,57,2,16283.70,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1534,8082,383,40864,112062,3,235,1,258.10,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1535,8082,383,40864,112062,3,250,1,10323.81,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1536,8082,383,40864,112062,3,68,1,2168.00,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1537,8082,383,40864,112062,3,57,2,12749.91,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1538,8082,384,40864,112062,3,250,1,4904.00,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1539,8082,384,40864,112062,3,68,1,514.92,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1540,8082,384,40864,112062,3,57,2,5418.92,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1541,8082,385,40864,112062,3,217,1,59611.52,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1542,8082,385,40864,112062,3,68,1,12518.42,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1543,8082,385,40864,112062,3,217,1,0.01,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1544,8082,385,40864,112062,3,57,2,72129.95,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1545,8082,386,40864,112062,3,221,2,147.70,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1546,8082,386,40864,112062,3,217,2,5907.98,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1547,8082,386,40864,112062,3,67,2,1240.68,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1548,8082,386,40864,112062,3,217,2,0.01,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1549,8082,386,40864,112062,3,57,1,7296.37,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1550,8082,387,40864,112062,3,250,1,24000.00,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1551,8082,387,40864,112062,3,68,1,2520.00,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1552,8082,387,40864,112062,3,57,2,26520.00,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1553,8082,388,40864,112062,3,235,1,68.50,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1554,8082,388,40864,112062,3,250,1,2740.17,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL);
INSERT INTO `balance_libro_details` VALUES (1555,8082,388,40864,112062,3,68,1,575.43,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1556,8082,388,40864,112062,3,57,2,3384.10,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1557,8082,389,40864,112062,3,235,1,348.88,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1558,8082,389,40864,112062,3,250,1,13955.56,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1559,8082,389,40864,112062,3,68,1,2930.67,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1560,8082,389,40864,112062,3,57,2,17235.11,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1561,8082,390,40864,112062,3,235,1,1552.28,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1562,8082,390,40864,112062,3,250,1,62091.01,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1563,8082,390,40864,112062,3,68,1,13039.11,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1564,8082,390,40864,112062,3,250,1,0.01,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1565,8082,390,40864,112062,3,57,2,76682.41,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1566,8082,391,40864,112062,3,235,2,119.98,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1567,8082,391,40864,112062,3,250,2,4799.06,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1568,8082,391,40864,112062,3,67,2,1007.80,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1569,8082,391,40864,112062,3,57,1,5926.84,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1570,8082,392,40864,112062,3,235,1,911.83,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1571,8082,392,40864,112062,3,250,1,36473.05,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1572,8082,392,40864,112062,3,68,1,7659.34,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1573,8082,392,40864,112062,3,57,2,45044.22,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1574,8082,393,40864,112062,3,250,1,48650.00,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1575,8082,393,40864,112062,3,68,1,5108.25,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1576,8082,393,40864,112062,3,57,2,53758.25,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1577,8082,394,40864,112062,3,217,1,11841.64,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1578,8082,394,40864,112062,3,57,2,11841.64,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1579,8082,395,40864,112062,3,217,1,7954.93,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1580,8082,395,40864,112062,3,57,2,7954.93,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(1581,8082,396,40864,112062,3,217,1,11841.64,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1582,8082,396,40864,112062,3,57,2,11841.64,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1583,8082,397,40864,112062,3,217,1,17332.77,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1584,8082,397,40864,112062,3,57,2,17332.77,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1585,8082,398,40864,112062,3,250,1,43652.03,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1586,8082,398,40864,112062,3,68,1,9166.93,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1587,8082,398,40864,112062,3,250,1,0.01,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1588,8082,398,40864,112062,3,57,2,52818.97,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1589,8082,399,40864,112062,3,217,1,39102.29,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1590,8082,399,40864,112062,3,68,1,8211.48,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1591,8082,399,40864,112062,3,217,1,0.01,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1592,8082,399,40864,112062,3,57,2,47313.78,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1593,8082,400,40864,112062,3,235,1,1032.43,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1594,8082,400,40864,112062,3,250,1,41297.33,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL);
INSERT INTO `balance_libro_details` VALUES (1595,8082,400,40864,112062,3,68,1,8672.44,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1596,8082,400,40864,112062,3,57,2,51002.20,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1597,8082,401,40864,112062,3,217,1,47810.67,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1598,8082,401,40864,112062,3,68,1,5020.12,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1599,8082,401,40864,112062,3,217,1,3027.24,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1600,8082,401,40864,112062,3,68,1,635.72,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1601,8082,401,40864,112062,3,217,1,0.02,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1602,8082,401,40864,112062,3,57,2,56493.77,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1603,8082,402,40864,112062,3,235,1,3945.25,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1604,8082,402,40864,112062,3,250,1,225442.98,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1605,8082,402,40864,112062,3,68,1,23671.51,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1606,8082,402,40864,112062,3,57,2,253059.74,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1607,8082,403,40864,112062,3,221,1,150.00,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1608,8082,403,40864,112062,3,250,1,5999.99,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1609,8082,403,40864,112062,3,68,1,1260.00,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1610,8082,403,40864,112062,3,57,2,7409.99,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1611,8082,404,40864,112062,3,221,1,96.70,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1612,8082,404,40864,112062,3,250,1,3868.19,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1613,8082,404,40864,112062,3,68,1,812.32,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1614,8082,404,40864,112062,3,57,2,4777.21,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(1615,8082,405,40864,112062,3,217,1,13334.00,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1616,8082,405,40864,112062,3,217,1,13334.00,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1617,8082,405,40864,112062,3,57,2,13334.00,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1618,8082,405,40864,112062,3,136,2,13334.00,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1619,8082,406,40864,112062,3,221,1,3149.48,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1620,8082,406,40864,112062,3,235,1,843.35,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1621,8082,406,40864,112062,3,250,1,30584.55,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1622,8082,406,40864,112062,3,68,1,6422.76,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1623,8082,406,40864,112062,3,57,2,41000.14,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1624,8082,407,40864,112062,3,235,1,66.13,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1625,8082,407,40864,112062,3,250,1,2645.37,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1626,8082,407,40864,112062,3,68,1,555.53,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1627,8082,407,40864,112062,3,57,2,3267.03,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1628,8082,408,40864,112062,3,221,1,743.51,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1629,8082,408,40864,112062,3,250,1,29740.25,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1630,8082,408,40864,112062,3,68,1,6245.45,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1631,8082,408,40864,112062,3,57,2,36729.21,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1632,8082,409,40864,112062,3,250,1,31192.88,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1633,8082,409,40864,112062,3,68,1,6550.50,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1634,8082,409,40864,112062,3,57,2,37743.38,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL);
INSERT INTO `balance_libro_details` VALUES (1635,8082,410,40864,112062,3,221,1,53.90,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1636,8082,410,40864,112062,3,250,1,2155.89,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1637,8082,410,40864,112062,3,68,1,452.74,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1638,8082,410,40864,112062,3,57,2,2662.53,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1639,8082,411,40864,112062,3,250,2,301.18,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1640,8082,411,40864,112062,3,67,2,63.25,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1641,8082,411,40864,112062,3,57,1,364.43,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1642,8082,412,40864,112062,3,250,1,23693.73,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1643,8082,412,40864,112062,3,68,1,4975.68,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1644,8082,412,40864,112062,3,57,2,28669.41,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1645,8082,413,40864,112062,3,250,1,48650.00,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1646,8082,413,40864,112062,3,68,1,5108.25,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1647,8082,413,40864,112062,3,250,1,3430.00,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1648,8082,413,40864,112062,3,68,1,720.30,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1649,8082,413,40864,112062,3,57,2,57908.55,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1650,8082,414,40864,112062,3,221,1,158.95,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1651,8082,414,40864,112062,3,250,1,6358.00,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1652,8082,414,40864,112062,3,68,1,1335.18,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1653,8082,414,40864,112062,3,57,2,7852.13,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1654,8082,415,40864,112062,3,235,1,48.00,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1655,8082,415,40864,112062,3,250,1,1919.90,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1656,8082,415,40864,112062,3,68,1,403.18,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1657,8082,415,40864,112062,3,57,2,2371.08,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1658,8082,416,40864,112062,3,217,1,11340.00,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1659,8082,416,40864,112062,3,217,1,11340.00,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1660,8082,416,40864,112062,3,57,2,11340.00,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1661,8082,416,40864,112062,3,136,2,11340.00,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1662,8082,417,40864,112062,3,235,1,221.60,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1663,8082,417,40864,112062,3,250,1,8864.03,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1664,8082,417,40864,112062,3,68,1,1861.45,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1665,8082,417,40864,112062,3,57,2,10947.08,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1666,8082,418,40864,112062,3,221,1,249.71,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1667,8082,418,40864,112062,3,217,1,10028.25,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1668,8082,418,40864,112062,3,68,1,2105.93,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1669,8082,418,40864,112062,3,217,1,300.85,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1670,8082,418,40864,112062,3,57,2,12684.74,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1671,8082,419,40864,112062,3,235,1,95.84,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1672,8082,419,40864,112062,3,250,1,3833.44,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1673,8082,419,40864,112062,3,68,1,805.02,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1674,8082,419,40864,112062,3,57,2,4734.30,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL);
INSERT INTO `balance_libro_details` VALUES (1675,8082,420,40864,112062,3,235,1,1672.50,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1676,8082,420,40864,112062,3,250,1,111500.00,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1677,8082,420,40864,112062,3,68,1,11707.50,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1678,8082,420,40864,112062,3,57,2,124880.00,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1679,8082,421,40864,112062,3,235,1,47.23,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1680,8082,421,40864,112062,3,250,1,1889.30,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1681,8082,421,40864,112062,3,68,1,396.75,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1682,8082,421,40864,112062,3,57,2,2333.28,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1683,8082,422,40864,112062,3,235,1,328.49,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1684,8082,422,40864,112062,3,250,1,13139.75,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1685,8082,422,40864,112062,3,68,1,2759.34,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1686,8082,422,40864,112062,3,57,2,16227.58,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1687,8082,423,40864,112062,3,217,1,50868.58,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1688,8082,423,40864,112062,3,57,2,50868.58,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1689,8082,424,40864,112062,3,250,1,65.00,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1690,8082,424,40864,112062,3,68,1,13.65,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1691,8082,424,40864,112062,3,57,2,78.65,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1692,8082,425,40864,112062,3,217,1,46673.00,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1693,8082,425,40864,112062,3,68,1,9801.33,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1694,8082,425,40864,112062,3,217,1,0.07,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1695,8082,425,40864,112062,3,57,2,56474.40,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(1696,8082,426,40864,112062,3,235,1,1412.65,NULL,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(1697,8082,426,40864,112062,3,217,1,56506.07,NULL,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(1698,8082,426,40864,112062,3,68,1,11866.27,NULL,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(1699,8082,426,40864,112062,3,217,1,0.01,NULL,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(1700,8082,426,40864,112062,3,57,2,69785.00,NULL,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(1701,8082,427,40864,112062,3,235,1,450.45,NULL,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(1702,8082,427,40864,112062,3,250,1,18017.37,NULL,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(1703,8082,427,40864,112062,3,68,1,3783.65,NULL,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(1704,8082,427,40864,112062,3,57,2,22251.47,NULL,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(1705,8082,428,40864,112062,3,217,1,2999.00,NULL,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(1706,8082,428,40864,112062,3,57,2,2999.00,NULL,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(1707,8082,429,40719,18,16,156,1,150.00,NULL,'2023-08-29 21:45:26','2023-08-29 21:45:26',NULL),(1708,8082,429,40719,18,16,336,2,150.00,NULL,'2023-08-29 21:45:26','2023-08-29 21:45:26',NULL);
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2022-11-08 11:40:45',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2022-11-08 11:40:45',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2022-11-08 11:40:45',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-11-08 11:40:45','2022-11-08 11:40:45',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-11-08 11:40:52','2022-11-08 11:40:52',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-11-08 11:40:52','2022-11-08 11:40:52',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-11-08 11:40:52','2022-11-08 11:40:52',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-11-08 11:40:52','2022-11-08 11:40:52',NULL),(11,2021,6000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-11-08 11:41:02','2022-11-08 11:41:02',NULL),(12,2021,6000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-11-08 11:41:02','2022-11-08 11:41:02',NULL),(13,2021,6000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-11-08 11:41:02','2022-11-08 11:41:02',NULL),(14,2021,6000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-11-08 11:41:02','2022-11-08 11:41:02',NULL),(15,2022,11282141.08,0.00,5641070.54,0.00,0.0050,0.00,'2023-05-30 15:05:36','2023-05-30 15:05:36',NULL),(16,2022,11282141.08,5641070.54,12222319.51,28205.35,0.0075,5641070.54,'2023-05-30 15:05:36','2023-05-30 15:05:36',NULL),(17,2022,11282141.08,12222319.51,33846423.25,77564.72,0.0100,12222319.51,'2023-05-30 15:05:36','2023-05-30 15:05:36',NULL),(18,2022,11282141.08,33846423.25,188035684.71,293802.76,0.0125,33846423.25,'2023-05-30 15:05:36','2023-05-30 15:05:36',NULL),(19,2022,11282141.08,188035684.71,564107054.14,2221171.53,0.0150,188035684.71,'2023-05-30 15:05:36','2023-05-30 15:05:36',NULL),(20,2022,11282141.08,564107054.14,999999999999.00,7682242.07,0.0175,564107054.14,'2023-05-30 15:05:36','2023-05-30 15:05:36',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar`
--

DROP TABLE IF EXISTS `calendar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `ws_telefono_id` bigint(20) unsigned DEFAULT NULL,
  `title` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion_text` longtext COLLATE utf8mb4_unicode_ci,
  `url` text COLLATE utf8mb4_unicode_ci,
  `start` datetime DEFAULT NULL,
  `startEditable` tinyint(1) NOT NULL DEFAULT '1',
  `startStr` text COLLATE utf8mb4_unicode_ci,
  `end` datetime DEFAULT NULL,
  `endStr` text COLLATE utf8mb4_unicode_ci,
  `allDay` tinyint(1) NOT NULL DEFAULT '1',
  `allow` tinyint(1) DEFAULT NULL,
  `backgroundColor` text COLLATE utf8mb4_unicode_ci,
  `borderColor` text COLLATE utf8mb4_unicode_ci,
  `classNames` longtext COLLATE utf8mb4_unicode_ci,
  `constraint` text COLLATE utf8mb4_unicode_ci,
  `display` text COLLATE utf8mb4_unicode_ci,
  `durationEditable` tinyint(1) NOT NULL DEFAULT '1',
  `extendedProps` longtext COLLATE utf8mb4_unicode_ci,
  `groupId` text COLLATE utf8mb4_unicode_ci,
  `overlap` text COLLATE utf8mb4_unicode_ci,
  `source` longtext COLLATE utf8mb4_unicode_ci,
  `textColor` text COLLATE utf8mb4_unicode_ci,
  `is_impuesto_from_taxes` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_person_id_foreign` (`person_id`),
  KEY `calendar_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `calendar_ws_telefono_id_foreign` (`ws_telefono_id`),
  CONSTRAINT `calendar_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_ws_telefono_id_foreign` FOREIGN KEY (`ws_telefono_id`) REFERENCES `ws_telefonos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=446 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar`
--

LOCK TABLES `calendar` WRITE;
/*!40000 ALTER TABLE `calendar` DISABLE KEYS */;
INSERT INTO `calendar` VALUES (1,NULL,40721,NULL,NULL,'Autonomos',NULL,NULL,'','2023-01-06 10:00:00',1,NULL,'2023-01-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(2,NULL,40721,NULL,NULL,'Autonomos',NULL,NULL,'','2023-02-07 10:00:00',1,NULL,'2023-02-07 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(3,NULL,40721,NULL,NULL,'Autonomos',NULL,NULL,'','2023-03-07 10:00:00',1,NULL,'2023-03-07 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(4,NULL,40721,NULL,NULL,'Autonomos',NULL,NULL,'','2023-04-06 10:00:00',1,NULL,'2023-04-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(5,NULL,40721,NULL,NULL,'Autonomos',NULL,NULL,'','2023-05-08 10:00:00',1,NULL,'2023-05-08 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(6,NULL,40721,NULL,NULL,'Autonomos',NULL,NULL,'','2023-06-06 10:00:00',1,NULL,'2023-06-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(7,NULL,40721,NULL,NULL,'Autonomos',NULL,NULL,'','2023-07-06 10:00:00',1,NULL,'2023-07-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(8,NULL,40721,NULL,NULL,'Autonomos',NULL,NULL,'','2023-08-08 10:00:00',1,NULL,'2023-08-08 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(9,NULL,40721,NULL,NULL,'Autonomos',NULL,NULL,'','2023-09-06 10:00:00',1,NULL,'2023-09-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(10,NULL,40721,NULL,NULL,'Autonomos',NULL,NULL,'','2023-10-06 10:00:00',1,NULL,'2023-10-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(11,NULL,40721,NULL,NULL,'Autonomos',NULL,NULL,'','2023-11-07 10:00:00',1,NULL,'2023-11-07 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(12,NULL,40721,NULL,NULL,'Autonomos',NULL,NULL,'','2023-12-06 10:00:00',1,NULL,'2023-12-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(13,NULL,40721,NULL,NULL,'Bienes Personales',NULL,NULL,'','2023-06-13 10:00:00',1,NULL,'2023-06-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(14,NULL,40721,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-02-14 10:00:00',1,NULL,'2023-02-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(15,NULL,40721,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-04-14 10:00:00',1,NULL,'2023-04-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(16,NULL,40721,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-08-15 10:00:00',1,NULL,'2023-08-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(17,NULL,40721,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-10-18 10:00:00',1,NULL,'2023-10-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(18,NULL,40721,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-12-13 10:00:00',1,NULL,'2023-12-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(19,NULL,40721,NULL,NULL,'Convenio Multilateral - Anual',NULL,NULL,'','2023-05-15 10:00:00',1,NULL,'2023-05-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(20,NULL,40721,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-01-17 10:00:00',1,NULL,'2023-01-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (21,NULL,40721,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-02-16 10:00:00',1,NULL,'2023-02-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(22,NULL,40721,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-03-16 10:00:00',1,NULL,'2023-03-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(23,NULL,40721,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-04-18 10:00:00',1,NULL,'2023-04-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(24,NULL,40721,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-05-16 10:00:00',1,NULL,'2023-05-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(25,NULL,40721,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-06-16 10:00:00',1,NULL,'2023-06-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(26,NULL,40721,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-07-18 10:00:00',1,NULL,'2023-07-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(27,NULL,40721,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-08-16 10:00:00',1,NULL,'2023-08-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(28,NULL,40721,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-09-18 10:00:00',1,NULL,'2023-09-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(29,NULL,40721,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-10-18 10:00:00',1,NULL,'2023-10-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(30,NULL,40721,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-11-16 10:00:00',1,NULL,'2023-11-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(31,NULL,40721,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-12-18 10:00:00',1,NULL,'2023-12-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(32,NULL,40721,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-02-14 10:00:00',1,NULL,'2023-02-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(33,NULL,40721,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-04-14 10:00:00',1,NULL,'2023-04-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(34,NULL,40721,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-08-15 10:00:00',1,NULL,'2023-08-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(35,NULL,40721,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-10-18 10:00:00',1,NULL,'2023-10-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(36,NULL,40721,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-12-13 10:00:00',1,NULL,'2023-12-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(37,NULL,40721,NULL,NULL,'Ganancia Personas Humanas',NULL,NULL,'','2023-06-13 10:00:00',1,NULL,'2023-06-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(38,NULL,40721,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-01-10 10:00:00',1,NULL,'2023-01-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (39,NULL,40721,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-02-10 10:00:00',1,NULL,'2023-02-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(40,NULL,40721,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-03-10 10:00:00',1,NULL,'2023-03-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(41,NULL,40721,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-04-10 10:00:00',1,NULL,'2023-04-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(42,NULL,40721,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-05-10 10:00:00',1,NULL,'2023-05-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(43,NULL,40721,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-06-10 10:00:00',1,NULL,'2023-06-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(44,NULL,40721,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-07-10 10:00:00',1,NULL,'2023-07-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(45,NULL,40721,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-08-10 10:00:00',1,NULL,'2023-08-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(46,NULL,40721,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-09-10 10:00:00',1,NULL,'2023-09-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(47,NULL,40721,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-10-10 10:00:00',1,NULL,'2023-10-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(48,NULL,40721,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-11-10 10:00:00',1,NULL,'2023-11-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(49,NULL,40721,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-12-10 10:00:00',1,NULL,'2023-12-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(50,NULL,40721,NULL,NULL,'IVA',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(51,NULL,40721,NULL,NULL,'IVA',NULL,NULL,'','2023-02-24 10:00:00',1,NULL,'2023-02-24 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(52,NULL,40721,NULL,NULL,'IVA',NULL,NULL,'','2023-03-22 10:00:00',1,NULL,'2023-03-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(53,NULL,40721,NULL,NULL,'IVA',NULL,NULL,'','2023-04-20 10:00:00',1,NULL,'2023-04-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(54,NULL,40721,NULL,NULL,'IVA',NULL,NULL,'','2023-05-22 10:00:00',1,NULL,'2023-05-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(55,NULL,40721,NULL,NULL,'IVA',NULL,NULL,'','2023-06-23 10:00:00',1,NULL,'2023-06-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(56,NULL,40721,NULL,NULL,'IVA',NULL,NULL,'','2023-07-20 10:00:00',1,NULL,'2023-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(57,NULL,40721,NULL,NULL,'IVA',NULL,NULL,'','2023-08-23 10:00:00',1,NULL,'2023-08-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(58,NULL,40721,NULL,NULL,'IVA',NULL,NULL,'','2023-09-20 10:00:00',1,NULL,'2023-09-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (59,NULL,40721,NULL,NULL,'IVA',NULL,NULL,'','2023-10-20 10:00:00',1,NULL,'2023-10-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(60,NULL,40721,NULL,NULL,'IVA',NULL,NULL,'','2023-11-23 10:00:00',1,NULL,'2023-11-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(61,NULL,40721,NULL,NULL,'IVA',NULL,NULL,'','2023-12-20 10:00:00',1,NULL,'2023-12-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(62,NULL,40721,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(63,NULL,40721,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-02-24 10:00:00',1,NULL,'2023-02-24 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(64,NULL,40721,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-03-22 10:00:00',1,NULL,'2023-03-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(65,NULL,40721,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-04-20 10:00:00',1,NULL,'2023-04-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(66,NULL,40721,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-05-22 10:00:00',1,NULL,'2023-05-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(67,NULL,40721,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-06-23 10:00:00',1,NULL,'2023-06-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(68,NULL,40721,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-07-20 10:00:00',1,NULL,'2023-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(69,NULL,40721,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-08-23 10:00:00',1,NULL,'2023-08-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(70,NULL,40721,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-09-20 10:00:00',1,NULL,'2023-09-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(71,NULL,40721,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-10-20 10:00:00',1,NULL,'2023-10-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(72,NULL,40721,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-11-23 10:00:00',1,NULL,'2023-11-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(73,NULL,40721,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-12-20 10:00:00',1,NULL,'2023-12-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(74,NULL,40719,NULL,NULL,'Bienes Personales',NULL,NULL,'','2023-06-13 10:00:00',1,NULL,'2023-06-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(75,NULL,40719,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-02-14 10:00:00',1,NULL,'2023-02-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(76,NULL,40719,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-04-14 10:00:00',1,NULL,'2023-04-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(77,NULL,40719,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-08-15 10:00:00',1,NULL,'2023-08-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (78,NULL,40719,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-10-18 10:00:00',1,NULL,'2023-10-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(79,NULL,40719,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-12-13 10:00:00',1,NULL,'2023-12-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(80,NULL,40719,NULL,NULL,'IIBB Regimen Simplificado',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(81,NULL,40719,NULL,NULL,'IIBB Regimen Simplificado',NULL,NULL,'','2023-03-22 10:00:00',1,NULL,'2023-03-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(82,NULL,40719,NULL,NULL,'IIBB Regimen Simplificado',NULL,NULL,'','2023-05-22 10:00:00',1,NULL,'2023-05-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(83,NULL,40719,NULL,NULL,'IIBB Regimen Simplificado',NULL,NULL,'','2023-07-20 10:00:00',1,NULL,'2023-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(84,NULL,40719,NULL,NULL,'IIBB Regimen Simplificado',NULL,NULL,'','2023-09-21 10:00:00',1,NULL,'2023-09-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(85,NULL,40719,NULL,NULL,'IIBB Regimen Simplificado',NULL,NULL,'','2023-11-23 10:00:00',1,NULL,'2023-11-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(86,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(87,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-02-22 10:00:00',1,NULL,'2023-02-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(88,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-03-20 10:00:00',1,NULL,'2023-03-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(89,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-04-20 10:00:00',1,NULL,'2023-04-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(90,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-05-22 10:00:00',1,NULL,'2023-05-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(91,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-06-21 10:00:00',1,NULL,'2023-06-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(92,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-07-20 10:00:00',1,NULL,'2023-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(93,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-08-22 10:00:00',1,NULL,'2023-08-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(94,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-09-20 10:00:00',1,NULL,'2023-09-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(95,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-10-20 10:00:00',1,NULL,'2023-10-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(96,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-11-21 10:00:00',1,NULL,'2023-11-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (97,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-12-20 10:00:00',1,NULL,'2023-12-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(98,NULL,40719,NULL,NULL,'Monotributo - Recategorizacion',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(99,NULL,40719,NULL,NULL,'Monotributo - Recategorizacion',NULL,NULL,'','2022-07-20 10:00:00',1,NULL,'2022-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(100,NULL,40719,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-01-10 10:00:00',1,NULL,'2023-01-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(101,NULL,40719,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-02-10 10:00:00',1,NULL,'2023-02-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(102,NULL,40719,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-03-10 10:00:00',1,NULL,'2023-03-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(103,NULL,40719,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-04-10 10:00:00',1,NULL,'2023-04-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(104,NULL,40719,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-05-10 10:00:00',1,NULL,'2023-05-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(105,NULL,40719,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-06-12 10:00:00',1,NULL,'2023-06-12 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(106,NULL,40719,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-07-10 10:00:00',1,NULL,'2023-07-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(107,NULL,40719,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-08-10 10:00:00',1,NULL,'2023-08-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(108,NULL,40719,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-09-11 10:00:00',1,NULL,'2023-09-11 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(109,NULL,40719,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-10-10 10:00:00',1,NULL,'2023-10-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(110,NULL,40719,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-11-10 10:00:00',1,NULL,'2023-11-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(111,NULL,40719,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-12-11 10:00:00',1,NULL,'2023-12-11 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(112,NULL,40719,NULL,NULL,'SIRADIG',NULL,NULL,'','2024-01-16 10:00:00',1,NULL,'2024-01-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(113,NULL,40719,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-02-15 10:00:00',1,NULL,'2023-02-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(114,NULL,40719,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-02-22 10:00:00',1,NULL,'2023-02-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(115,NULL,40719,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-03-17 10:00:00',1,NULL,'2023-03-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (116,NULL,40719,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-04-18 10:00:00',1,NULL,'2023-04-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(117,NULL,40719,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-05-15 10:00:00',1,NULL,'2023-05-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(118,NULL,40719,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-05-18 10:00:00',1,NULL,'2023-05-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(119,NULL,40719,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-06-21 10:00:00',1,NULL,'2023-06-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(120,NULL,40719,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-07-18 10:00:00',1,NULL,'2023-07-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(121,NULL,40719,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-08-15 10:00:00',1,NULL,'2023-08-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(122,NULL,40719,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-08-18 10:00:00',1,NULL,'2023-08-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(123,NULL,40719,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-09-19 10:00:00',1,NULL,'2023-09-19 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(124,NULL,40720,NULL,NULL,'Autonomos',NULL,NULL,'','2023-01-06 10:00:00',1,NULL,'2023-01-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(125,NULL,40720,NULL,NULL,'Autonomos',NULL,NULL,'','2023-02-07 10:00:00',1,NULL,'2023-02-07 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(126,NULL,40720,NULL,NULL,'Autonomos',NULL,NULL,'','2023-03-07 10:00:00',1,NULL,'2023-03-07 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(127,NULL,40720,NULL,NULL,'Autonomos',NULL,NULL,'','2023-04-06 10:00:00',1,NULL,'2023-04-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(128,NULL,40720,NULL,NULL,'Autonomos',NULL,NULL,'','2023-05-08 10:00:00',1,NULL,'2023-05-08 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(129,NULL,40720,NULL,NULL,'Autonomos',NULL,NULL,'','2023-06-06 10:00:00',1,NULL,'2023-06-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(130,NULL,40720,NULL,NULL,'Autonomos',NULL,NULL,'','2023-07-06 10:00:00',1,NULL,'2023-07-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(131,NULL,40720,NULL,NULL,'Autonomos',NULL,NULL,'','2023-08-08 10:00:00',1,NULL,'2023-08-08 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(132,NULL,40720,NULL,NULL,'Autonomos',NULL,NULL,'','2023-09-06 10:00:00',1,NULL,'2023-09-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(133,NULL,40720,NULL,NULL,'Autonomos',NULL,NULL,'','2023-10-06 10:00:00',1,NULL,'2023-10-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(134,NULL,40720,NULL,NULL,'Autonomos',NULL,NULL,'','2023-11-07 10:00:00',1,NULL,'2023-11-07 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(135,NULL,40720,NULL,NULL,'Autonomos',NULL,NULL,'','2023-12-06 10:00:00',1,NULL,'2023-12-06 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (136,NULL,40720,NULL,NULL,'Bienes Personales',NULL,NULL,'','2023-06-13 10:00:00',1,NULL,'2023-06-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(137,NULL,40720,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-02-14 10:00:00',1,NULL,'2023-02-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(138,NULL,40720,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-04-14 10:00:00',1,NULL,'2023-04-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(139,NULL,40720,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-08-15 10:00:00',1,NULL,'2023-08-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(140,NULL,40720,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-10-18 10:00:00',1,NULL,'2023-10-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(141,NULL,40720,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-12-13 10:00:00',1,NULL,'2023-12-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(142,NULL,40720,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-02-14 10:00:00',1,NULL,'2023-02-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(143,NULL,40720,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-04-14 10:00:00',1,NULL,'2023-04-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(144,NULL,40720,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-08-15 10:00:00',1,NULL,'2023-08-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(145,NULL,40720,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-10-18 10:00:00',1,NULL,'2023-10-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(146,NULL,40720,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-12-13 10:00:00',1,NULL,'2023-12-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(147,NULL,40720,NULL,NULL,'Ganancia Personas Humanas',NULL,NULL,'','2023-06-13 10:00:00',1,NULL,'2023-06-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(148,NULL,40720,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-01-10 10:00:00',1,NULL,'2023-01-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(149,NULL,40720,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-02-10 10:00:00',1,NULL,'2023-02-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(150,NULL,40720,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-03-10 10:00:00',1,NULL,'2023-03-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(151,NULL,40720,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-04-10 10:00:00',1,NULL,'2023-04-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(152,NULL,40720,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-05-10 10:00:00',1,NULL,'2023-05-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(153,NULL,40720,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-06-10 10:00:00',1,NULL,'2023-06-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(154,NULL,40720,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-07-10 10:00:00',1,NULL,'2023-07-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (155,NULL,40720,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-08-10 10:00:00',1,NULL,'2023-08-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(156,NULL,40720,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-09-10 10:00:00',1,NULL,'2023-09-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(157,NULL,40720,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-10-10 10:00:00',1,NULL,'2023-10-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(158,NULL,40720,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-11-10 10:00:00',1,NULL,'2023-11-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(159,NULL,40720,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-12-10 10:00:00',1,NULL,'2023-12-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(160,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(161,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-02-24 10:00:00',1,NULL,'2023-02-24 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(162,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-03-22 10:00:00',1,NULL,'2023-03-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(163,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-04-20 10:00:00',1,NULL,'2023-04-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(164,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-05-22 10:00:00',1,NULL,'2023-05-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(165,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-06-23 10:00:00',1,NULL,'2023-06-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(166,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-07-20 10:00:00',1,NULL,'2023-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(167,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-08-23 10:00:00',1,NULL,'2023-08-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(168,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-09-20 10:00:00',1,NULL,'2023-09-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(169,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-10-20 10:00:00',1,NULL,'2023-10-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(170,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-11-23 10:00:00',1,NULL,'2023-11-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(171,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-12-20 10:00:00',1,NULL,'2023-12-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(172,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(173,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-02-24 10:00:00',1,NULL,'2023-02-24 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(174,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-03-22 10:00:00',1,NULL,'2023-03-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (175,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-04-20 10:00:00',1,NULL,'2023-04-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(176,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-05-22 10:00:00',1,NULL,'2023-05-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(177,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-06-23 10:00:00',1,NULL,'2023-06-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(178,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-07-20 10:00:00',1,NULL,'2023-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(179,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-08-23 10:00:00',1,NULL,'2023-08-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(180,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-09-20 10:00:00',1,NULL,'2023-09-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(181,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-10-20 10:00:00',1,NULL,'2023-10-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(182,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-11-23 10:00:00',1,NULL,'2023-11-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(183,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-12-20 10:00:00',1,NULL,'2023-12-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(184,NULL,40720,NULL,NULL,'Sindicato - FAECYS',NULL,NULL,'','2023-01-10 10:00:00',1,NULL,'2023-01-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(185,NULL,40720,NULL,NULL,'Sindicato - FAECYS',NULL,NULL,'','2023-02-10 10:00:00',1,NULL,'2023-02-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(186,NULL,40720,NULL,NULL,'Sindicato - FAECYS',NULL,NULL,'','2023-03-10 10:00:00',1,NULL,'2023-03-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(187,NULL,40720,NULL,NULL,'Sindicato - FAECYS',NULL,NULL,'','2023-04-11 10:00:00',1,NULL,'2023-04-11 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(188,NULL,40720,NULL,NULL,'Sindicato - FAECYS',NULL,NULL,'','2023-05-10 10:00:00',1,NULL,'2023-05-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(189,NULL,40720,NULL,NULL,'Sindicato - FAECYS',NULL,NULL,'','2023-06-12 10:00:00',1,NULL,'2023-06-12 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(190,NULL,40720,NULL,NULL,'Sindicato - FAECYS',NULL,NULL,'','2023-07-11 10:00:00',1,NULL,'2023-07-11 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(191,NULL,40720,NULL,NULL,'Sindicato - FAECYS',NULL,NULL,'','2023-08-10 10:00:00',1,NULL,'2023-08-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(192,NULL,40720,NULL,NULL,'Sindicato - FAECYS',NULL,NULL,'','2023-09-12 10:00:00',1,NULL,'2023-09-12 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(193,NULL,40720,NULL,NULL,'Sindicato - FAECYS',NULL,NULL,'','2023-10-10 10:00:00',1,NULL,'2023-10-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (194,NULL,40720,NULL,NULL,'Sindicato - FAECYS',NULL,NULL,'','2023-11-10 10:00:00',1,NULL,'2023-11-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(195,NULL,40720,NULL,NULL,'Sindicato - FAECYS',NULL,NULL,'','2023-12-12 10:00:00',1,NULL,'2023-12-12 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(196,NULL,40720,NULL,NULL,'Sindicato - INACAP',NULL,NULL,'','2023-01-10 10:00:00',1,NULL,'2023-01-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(197,NULL,40720,NULL,NULL,'Sindicato - INACAP',NULL,NULL,'','2023-02-10 10:00:00',1,NULL,'2023-02-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(198,NULL,40720,NULL,NULL,'Sindicato - INACAP',NULL,NULL,'','2023-03-10 10:00:00',1,NULL,'2023-03-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(199,NULL,40720,NULL,NULL,'Sindicato - INACAP',NULL,NULL,'','2023-04-11 10:00:00',1,NULL,'2023-04-11 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(200,NULL,40720,NULL,NULL,'Sindicato - INACAP',NULL,NULL,'','2023-05-10 10:00:00',1,NULL,'2023-05-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(201,NULL,40720,NULL,NULL,'Sindicato - INACAP',NULL,NULL,'','2023-06-12 10:00:00',1,NULL,'2023-06-12 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(202,NULL,40720,NULL,NULL,'Sindicato - INACAP',NULL,NULL,'','2023-07-11 10:00:00',1,NULL,'2023-07-11 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(203,NULL,40720,NULL,NULL,'Sindicato - INACAP',NULL,NULL,'','2023-08-10 10:00:00',1,NULL,'2023-08-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(204,NULL,40720,NULL,NULL,'Sindicato - INACAP',NULL,NULL,'','2023-09-12 10:00:00',1,NULL,'2023-09-12 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(205,NULL,40720,NULL,NULL,'Sindicato - INACAP',NULL,NULL,'','2023-10-10 10:00:00',1,NULL,'2023-10-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(206,NULL,40720,NULL,NULL,'Sindicato - INACAP',NULL,NULL,'','2023-11-10 10:00:00',1,NULL,'2023-11-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(207,NULL,40720,NULL,NULL,'Sindicato - INACAP',NULL,NULL,'','2023-12-12 10:00:00',1,NULL,'2023-12-12 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(208,NULL,40720,NULL,NULL,'Sindicato - La Estrella',NULL,NULL,'','2023-01-10 10:00:00',1,NULL,'2023-01-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(209,NULL,40720,NULL,NULL,'Sindicato - La Estrella',NULL,NULL,'','2023-02-10 10:00:00',1,NULL,'2023-02-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(210,NULL,40720,NULL,NULL,'Sindicato - La Estrella',NULL,NULL,'','2023-03-10 10:00:00',1,NULL,'2023-03-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(211,NULL,40720,NULL,NULL,'Sindicato - La Estrella',NULL,NULL,'','2023-04-11 10:00:00',1,NULL,'2023-04-11 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(212,NULL,40720,NULL,NULL,'Sindicato - La Estrella',NULL,NULL,'','2023-05-10 10:00:00',1,NULL,'2023-05-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (213,NULL,40720,NULL,NULL,'Sindicato - La Estrella',NULL,NULL,'','2023-06-12 10:00:00',1,NULL,'2023-06-12 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(214,NULL,40720,NULL,NULL,'Sindicato - La Estrella',NULL,NULL,'','2023-07-11 10:00:00',1,NULL,'2023-07-11 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(215,NULL,40720,NULL,NULL,'Sindicato - La Estrella',NULL,NULL,'','2023-08-10 10:00:00',1,NULL,'2023-08-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(216,NULL,40720,NULL,NULL,'Sindicato - La Estrella',NULL,NULL,'','2023-09-12 10:00:00',1,NULL,'2023-09-12 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(217,NULL,40720,NULL,NULL,'Sindicato - La Estrella',NULL,NULL,'','2023-10-10 10:00:00',1,NULL,'2023-10-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(218,NULL,40720,NULL,NULL,'Sindicato - La Estrella',NULL,NULL,'','2023-11-10 10:00:00',1,NULL,'2023-11-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(219,NULL,40720,NULL,NULL,'Sindicato - La Estrella',NULL,NULL,'','2023-12-12 10:00:00',1,NULL,'2023-12-12 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(220,NULL,40720,NULL,NULL,'Sindicato - Sind. Emp. Comercio',NULL,NULL,'','2023-01-10 10:00:00',1,NULL,'2023-01-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(221,NULL,40720,NULL,NULL,'Sindicato - Sind. Emp. Comercio',NULL,NULL,'','2023-02-10 10:00:00',1,NULL,'2023-02-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(222,NULL,40720,NULL,NULL,'Sindicato - Sind. Emp. Comercio',NULL,NULL,'','2023-03-10 10:00:00',1,NULL,'2023-03-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(223,NULL,40720,NULL,NULL,'Sindicato - Sind. Emp. Comercio',NULL,NULL,'','2023-04-11 10:00:00',1,NULL,'2023-04-11 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(224,NULL,40720,NULL,NULL,'Sindicato - Sind. Emp. Comercio',NULL,NULL,'','2023-05-10 10:00:00',1,NULL,'2023-05-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(225,NULL,40720,NULL,NULL,'Sindicato - Sind. Emp. Comercio',NULL,NULL,'','2023-06-12 10:00:00',1,NULL,'2023-06-12 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(226,NULL,40720,NULL,NULL,'Sindicato - Sind. Emp. Comercio',NULL,NULL,'','2023-07-11 10:00:00',1,NULL,'2023-07-11 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(227,NULL,40720,NULL,NULL,'Sindicato - Sind. Emp. Comercio',NULL,NULL,'','2023-08-10 10:00:00',1,NULL,'2023-08-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(228,NULL,40720,NULL,NULL,'Sindicato - Sind. Emp. Comercio',NULL,NULL,'','2023-09-12 10:00:00',1,NULL,'2023-09-12 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(229,NULL,40720,NULL,NULL,'Sindicato - Sind. Emp. Comercio',NULL,NULL,'','2023-10-10 10:00:00',1,NULL,'2023-10-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(230,NULL,40720,NULL,NULL,'Sindicato - Sind. Emp. Comercio',NULL,NULL,'','2023-11-10 10:00:00',1,NULL,'2023-11-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (231,NULL,40720,NULL,NULL,'Sindicato - Sind. Emp. Comercio',NULL,NULL,'','2023-12-12 10:00:00',1,NULL,'2023-12-12 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(232,NULL,40723,NULL,NULL,'Bienes Personales',NULL,NULL,'','2023-06-13 10:00:00',1,NULL,'2023-06-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(233,NULL,40723,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-02-14 10:00:00',1,NULL,'2023-02-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(234,NULL,40723,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-04-14 10:00:00',1,NULL,'2023-04-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(235,NULL,40723,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-08-15 10:00:00',1,NULL,'2023-08-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(236,NULL,40723,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-10-18 10:00:00',1,NULL,'2023-10-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(237,NULL,40723,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-12-13 10:00:00',1,NULL,'2023-12-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(238,NULL,40723,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-02-14 10:00:00',1,NULL,'2023-02-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(239,NULL,40723,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-04-14 10:00:00',1,NULL,'2023-04-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(240,NULL,40723,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-08-15 10:00:00',1,NULL,'2023-08-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(241,NULL,40723,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-10-18 10:00:00',1,NULL,'2023-10-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(242,NULL,40723,NULL,NULL,'Ganancia Pers. Hum. Anticipos',NULL,NULL,'','2023-12-13 10:00:00',1,NULL,'2023-12-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(243,NULL,40723,NULL,NULL,'Ganancia Personas Humanas',NULL,NULL,'','2023-06-13 10:00:00',1,NULL,'2023-06-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(244,NULL,40723,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-01-10 10:00:00',1,NULL,'2023-01-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(245,NULL,40723,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-02-10 10:00:00',1,NULL,'2023-02-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(246,NULL,40723,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-03-10 10:00:00',1,NULL,'2023-03-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(247,NULL,40723,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-04-10 10:00:00',1,NULL,'2023-04-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(248,NULL,40723,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-05-10 10:00:00',1,NULL,'2023-05-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(249,NULL,40723,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-06-10 10:00:00',1,NULL,'2023-06-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (250,NULL,40723,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-07-10 10:00:00',1,NULL,'2023-07-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(251,NULL,40723,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-08-10 10:00:00',1,NULL,'2023-08-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(252,NULL,40723,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-09-10 10:00:00',1,NULL,'2023-09-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(253,NULL,40723,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-10-10 10:00:00',1,NULL,'2023-10-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(254,NULL,40723,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-11-10 10:00:00',1,NULL,'2023-11-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(255,NULL,40723,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-12-10 10:00:00',1,NULL,'2023-12-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(256,NULL,40723,NULL,NULL,'IVA',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(257,NULL,40723,NULL,NULL,'IVA',NULL,NULL,'','2023-02-24 10:00:00',1,NULL,'2023-02-24 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(258,NULL,40723,NULL,NULL,'IVA',NULL,NULL,'','2023-03-22 10:00:00',1,NULL,'2023-03-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(259,NULL,40723,NULL,NULL,'IVA',NULL,NULL,'','2023-04-20 10:00:00',1,NULL,'2023-04-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(260,NULL,40723,NULL,NULL,'IVA',NULL,NULL,'','2023-05-22 10:00:00',1,NULL,'2023-05-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(261,NULL,40723,NULL,NULL,'IVA',NULL,NULL,'','2023-06-23 10:00:00',1,NULL,'2023-06-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(262,NULL,40723,NULL,NULL,'IVA',NULL,NULL,'','2023-07-20 10:00:00',1,NULL,'2023-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(263,NULL,40723,NULL,NULL,'IVA',NULL,NULL,'','2023-08-23 10:00:00',1,NULL,'2023-08-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(264,NULL,40723,NULL,NULL,'IVA',NULL,NULL,'','2023-09-20 10:00:00',1,NULL,'2023-09-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(265,NULL,40723,NULL,NULL,'IVA',NULL,NULL,'','2023-10-20 10:00:00',1,NULL,'2023-10-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(266,NULL,40723,NULL,NULL,'IVA',NULL,NULL,'','2023-11-23 10:00:00',1,NULL,'2023-11-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(267,NULL,40723,NULL,NULL,'IVA',NULL,NULL,'','2023-12-20 10:00:00',1,NULL,'2023-12-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(268,NULL,40723,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(269,NULL,40723,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-02-24 10:00:00',1,NULL,'2023-02-24 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (270,NULL,40723,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-03-22 10:00:00',1,NULL,'2023-03-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(271,NULL,40723,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-04-20 10:00:00',1,NULL,'2023-04-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(272,NULL,40723,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-05-22 10:00:00',1,NULL,'2023-05-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(273,NULL,40723,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-06-23 10:00:00',1,NULL,'2023-06-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(274,NULL,40723,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-07-20 10:00:00',1,NULL,'2023-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(275,NULL,40723,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-08-23 10:00:00',1,NULL,'2023-08-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(276,NULL,40723,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-09-20 10:00:00',1,NULL,'2023-09-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(277,NULL,40723,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-10-20 10:00:00',1,NULL,'2023-10-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(278,NULL,40723,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-11-23 10:00:00',1,NULL,'2023-11-23 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(279,NULL,40723,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-12-20 10:00:00',1,NULL,'2023-12-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(280,NULL,40773,NULL,NULL,'Bienes Personales',NULL,NULL,'','2023-06-14 10:00:00',1,NULL,'2023-06-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(281,NULL,40773,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-01-10 10:00:00',1,NULL,'2023-01-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(282,NULL,40773,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-02-10 10:00:00',1,NULL,'2023-02-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(283,NULL,40773,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-03-10 10:00:00',1,NULL,'2023-03-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(284,NULL,40773,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-04-10 10:00:00',1,NULL,'2023-04-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(285,NULL,40773,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-05-10 10:00:00',1,NULL,'2023-05-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(286,NULL,40773,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-06-10 10:00:00',1,NULL,'2023-06-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(287,NULL,40773,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-07-10 10:00:00',1,NULL,'2023-07-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (288,NULL,40773,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-08-10 10:00:00',1,NULL,'2023-08-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(289,NULL,40773,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-09-10 10:00:00',1,NULL,'2023-09-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(290,NULL,40773,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-10-10 10:00:00',1,NULL,'2023-10-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(291,NULL,40773,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-11-10 10:00:00',1,NULL,'2023-11-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(292,NULL,40773,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-12-10 10:00:00',1,NULL,'2023-12-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(293,NULL,40773,NULL,NULL,'Monotributo',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(294,NULL,40773,NULL,NULL,'Monotributo',NULL,NULL,'','2023-02-22 10:00:00',1,NULL,'2023-02-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(295,NULL,40773,NULL,NULL,'Monotributo',NULL,NULL,'','2023-03-20 10:00:00',1,NULL,'2023-03-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(296,NULL,40773,NULL,NULL,'Monotributo',NULL,NULL,'','2023-04-20 10:00:00',1,NULL,'2023-04-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(297,NULL,40773,NULL,NULL,'Monotributo',NULL,NULL,'','2023-05-22 10:00:00',1,NULL,'2023-05-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(298,NULL,40773,NULL,NULL,'Monotributo',NULL,NULL,'','2023-06-21 10:00:00',1,NULL,'2023-06-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(299,NULL,40773,NULL,NULL,'Monotributo',NULL,NULL,'','2023-07-20 10:00:00',1,NULL,'2023-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(300,NULL,40773,NULL,NULL,'Monotributo',NULL,NULL,'','2023-08-22 10:00:00',1,NULL,'2023-08-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(301,NULL,40773,NULL,NULL,'Monotributo',NULL,NULL,'','2023-09-20 10:00:00',1,NULL,'2023-09-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(302,NULL,40773,NULL,NULL,'Monotributo',NULL,NULL,'','2023-10-20 10:00:00',1,NULL,'2023-10-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(303,NULL,40773,NULL,NULL,'Monotributo',NULL,NULL,'','2023-11-21 10:00:00',1,NULL,'2023-11-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(304,NULL,40773,NULL,NULL,'Monotributo',NULL,NULL,'','2023-12-20 10:00:00',1,NULL,'2023-12-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(305,NULL,40773,NULL,NULL,'Monotributo - Recategorizacion',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(306,NULL,40773,NULL,NULL,'Monotributo - Recategorizacion',NULL,NULL,'','2022-07-20 10:00:00',1,NULL,'2022-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(307,NULL,40773,NULL,NULL,'SIRADIG',NULL,NULL,'','2024-01-17 10:00:00',1,NULL,'2024-01-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (308,NULL,40773,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-02-16 10:00:00',1,NULL,'2023-02-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(309,NULL,40773,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-03-15 10:00:00',1,NULL,'2023-03-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(310,NULL,40773,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-03-20 10:00:00',1,NULL,'2023-03-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(311,NULL,40773,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-04-19 10:00:00',1,NULL,'2023-04-19 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(312,NULL,40773,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-05-16 10:00:00',1,NULL,'2023-05-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(313,NULL,40773,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-06-15 10:00:00',1,NULL,'2023-06-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(314,NULL,40773,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-06-22 10:00:00',1,NULL,'2023-06-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(315,NULL,40773,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-07-19 10:00:00',1,NULL,'2023-07-19 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(316,NULL,40773,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-08-16 10:00:00',1,NULL,'2023-08-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(317,NULL,40773,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-09-15 10:00:00',1,NULL,'2023-09-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(318,NULL,40773,NULL,NULL,'SIRADIG',NULL,NULL,'','2023-09-20 10:00:00',1,NULL,'2023-09-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(319,NULL,40773,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-01-10 10:00:00',1,NULL,'2023-01-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(320,NULL,40773,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-02-10 10:00:00',1,NULL,'2023-02-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(321,NULL,40773,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-03-10 10:00:00',1,NULL,'2023-03-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(322,NULL,40773,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-04-10 10:00:00',1,NULL,'2023-04-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(323,NULL,40773,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-05-10 10:00:00',1,NULL,'2023-05-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(324,NULL,40773,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-06-12 10:00:00',1,NULL,'2023-06-12 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(325,NULL,40773,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-07-10 10:00:00',1,NULL,'2023-07-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(326,NULL,40773,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-08-10 10:00:00',1,NULL,'2023-08-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(327,NULL,40773,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-09-11 10:00:00',1,NULL,'2023-09-11 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (328,NULL,40773,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-10-10 10:00:00',1,NULL,'2023-10-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(329,NULL,40773,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-11-10 10:00:00',1,NULL,'2023-11-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(330,NULL,40773,NULL,NULL,'Servicio Domestico',NULL,NULL,'','2023-12-11 10:00:00',1,NULL,'2023-12-11 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(331,NULL,40801,NULL,NULL,'Bienes Personales',NULL,NULL,'','2023-06-12 10:00:00',1,NULL,'2023-06-12 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(332,NULL,40801,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-02-13 10:00:00',1,NULL,'2023-02-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(333,NULL,40801,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-04-13 10:00:00',1,NULL,'2023-04-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(334,NULL,40801,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-08-14 10:00:00',1,NULL,'2023-08-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(335,NULL,40801,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-10-17 10:00:00',1,NULL,'2023-10-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(336,NULL,40801,NULL,NULL,'Bienes Personales Anticipos',NULL,NULL,'','2023-12-15 10:00:00',1,NULL,'2023-12-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(337,NULL,40801,NULL,NULL,'Ganancias Sociedades',NULL,NULL,'','2023-05-15 10:00:00',1,NULL,'2023-05-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(338,NULL,40801,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-01-13 10:00:00',1,NULL,'2023-01-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(339,NULL,40801,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-02-13 10:00:00',1,NULL,'2023-02-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(340,NULL,40801,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-03-13 10:00:00',1,NULL,'2023-03-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(341,NULL,40801,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-06-13 10:00:00',1,NULL,'2023-06-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(342,NULL,40801,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-07-13 10:00:00',1,NULL,'2023-07-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(343,NULL,40801,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-08-14 10:00:00',1,NULL,'2023-08-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(344,NULL,40801,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-09-13 10:00:00',1,NULL,'2023-09-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(345,NULL,40801,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-10-17 10:00:00',1,NULL,'2023-10-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(346,NULL,40801,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-11-13 10:00:00',1,NULL,'2023-11-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (347,NULL,40801,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-12-13 10:00:00',1,NULL,'2023-12-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(348,NULL,40801,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-01-10 10:00:00',1,NULL,'2023-01-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(349,NULL,40801,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-02-10 10:00:00',1,NULL,'2023-02-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(350,NULL,40801,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-03-10 10:00:00',1,NULL,'2023-03-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(351,NULL,40801,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-04-10 10:00:00',1,NULL,'2023-04-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(352,NULL,40801,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-05-10 10:00:00',1,NULL,'2023-05-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(353,NULL,40801,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-06-10 10:00:00',1,NULL,'2023-06-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(354,NULL,40801,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-07-10 10:00:00',1,NULL,'2023-07-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(355,NULL,40801,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-08-10 10:00:00',1,NULL,'2023-08-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(356,NULL,40801,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-09-10 10:00:00',1,NULL,'2023-09-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(357,NULL,40801,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-10-10 10:00:00',1,NULL,'2023-10-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(358,NULL,40801,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-11-10 10:00:00',1,NULL,'2023-11-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(359,NULL,40801,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-12-10 10:00:00',1,NULL,'2023-12-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(360,NULL,40801,NULL,NULL,'IVA',NULL,NULL,'','2023-01-18 10:00:00',1,NULL,'2023-01-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(361,NULL,40801,NULL,NULL,'IVA',NULL,NULL,'','2023-02-22 10:00:00',1,NULL,'2023-02-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(362,NULL,40801,NULL,NULL,'IVA',NULL,NULL,'','2023-03-20 10:00:00',1,NULL,'2023-03-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(363,NULL,40801,NULL,NULL,'IVA',NULL,NULL,'','2023-04-18 10:00:00',1,NULL,'2023-04-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(364,NULL,40801,NULL,NULL,'IVA',NULL,NULL,'','2023-05-18 10:00:00',1,NULL,'2023-05-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(365,NULL,40801,NULL,NULL,'IVA',NULL,NULL,'','2023-06-21 10:00:00',1,NULL,'2023-06-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(366,NULL,40801,NULL,NULL,'IVA',NULL,NULL,'','2023-07-18 10:00:00',1,NULL,'2023-07-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (367,NULL,40801,NULL,NULL,'IVA',NULL,NULL,'','2023-08-18 10:00:00',1,NULL,'2023-08-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(368,NULL,40801,NULL,NULL,'IVA',NULL,NULL,'','2023-09-18 10:00:00',1,NULL,'2023-09-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(369,NULL,40801,NULL,NULL,'IVA',NULL,NULL,'','2023-10-18 10:00:00',1,NULL,'2023-10-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(370,NULL,40801,NULL,NULL,'IVA',NULL,NULL,'','2023-11-21 10:00:00',1,NULL,'2023-11-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(371,NULL,40801,NULL,NULL,'IVA',NULL,NULL,'','2023-12-18 10:00:00',1,NULL,'2023-12-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(372,NULL,40801,NULL,NULL,'SICOSS',NULL,NULL,'','2023-01-09 10:00:00',1,NULL,'2023-01-09 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(373,NULL,40801,NULL,NULL,'SICOSS',NULL,NULL,'','2023-02-09 10:00:00',1,NULL,'2023-02-09 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(374,NULL,40801,NULL,NULL,'SICOSS',NULL,NULL,'','2023-03-09 10:00:00',1,NULL,'2023-03-09 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(375,NULL,40801,NULL,NULL,'SICOSS',NULL,NULL,'','2023-04-10 10:00:00',1,NULL,'2023-04-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(376,NULL,40801,NULL,NULL,'SICOSS',NULL,NULL,'','2023-05-09 10:00:00',1,NULL,'2023-05-09 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(377,NULL,40801,NULL,NULL,'SICOSS',NULL,NULL,'','2023-06-09 10:00:00',1,NULL,'2023-06-09 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(378,NULL,40801,NULL,NULL,'SICOSS',NULL,NULL,'','2023-07-10 10:00:00',1,NULL,'2023-07-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(379,NULL,40801,NULL,NULL,'SICOSS',NULL,NULL,'','2023-08-09 10:00:00',1,NULL,'2023-08-09 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(380,NULL,40801,NULL,NULL,'SICOSS',NULL,NULL,'','2023-09-11 10:00:00',1,NULL,'2023-09-11 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(381,NULL,40801,NULL,NULL,'SICOSS',NULL,NULL,'','2023-10-09 10:00:00',1,NULL,'2023-10-09 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(382,NULL,40801,NULL,NULL,'SICOSS',NULL,NULL,'','2023-11-09 10:00:00',1,NULL,'2023-11-09 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(383,NULL,40801,NULL,NULL,'SICOSS',NULL,NULL,'','2023-12-11 10:00:00',1,NULL,'2023-12-11 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(384,NULL,40819,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-01-16 10:00:00',1,NULL,'2023-01-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(385,NULL,40819,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-02-15 10:00:00',1,NULL,'2023-02-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(386,NULL,40819,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-03-15 10:00:00',1,NULL,'2023-03-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (387,NULL,40819,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-04-17 10:00:00',1,NULL,'2023-04-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(388,NULL,40819,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-05-15 10:00:00',1,NULL,'2023-05-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(389,NULL,40819,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-06-15 10:00:00',1,NULL,'2023-06-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(390,NULL,40819,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-07-17 10:00:00',1,NULL,'2023-07-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(391,NULL,40819,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-08-15 10:00:00',1,NULL,'2023-08-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(392,NULL,40819,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-09-15 10:00:00',1,NULL,'2023-09-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(393,NULL,40819,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-10-17 10:00:00',1,NULL,'2023-10-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(394,NULL,40819,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-11-15 10:00:00',1,NULL,'2023-11-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(395,NULL,40819,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-12-15 10:00:00',1,NULL,'2023-12-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(396,NULL,40819,NULL,NULL,'Convenio Multilateral - Anual',NULL,NULL,'','2023-05-15 10:00:00',1,NULL,'2023-05-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(397,NULL,40819,NULL,NULL,'Ganancia Personas Humanas',NULL,NULL,'','2023-06-12 10:00:00',1,NULL,'2023-06-12 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(398,NULL,40819,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-01-13 10:00:00',1,NULL,'2023-01-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(399,NULL,40819,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-02-13 10:00:00',1,NULL,'2023-02-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(400,NULL,40819,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-03-13 10:00:00',1,NULL,'2023-03-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(401,NULL,40819,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-06-13 10:00:00',1,NULL,'2023-06-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(402,NULL,40819,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-07-13 10:00:00',1,NULL,'2023-07-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(403,NULL,40819,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-08-14 10:00:00',1,NULL,'2023-08-14 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(404,NULL,40819,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-09-13 10:00:00',1,NULL,'2023-09-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (405,NULL,40819,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-10-17 10:00:00',1,NULL,'2023-10-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(406,NULL,40819,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-11-13 10:00:00',1,NULL,'2023-11-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(407,NULL,40819,NULL,NULL,'Ganancia Sociedades Anticipos',NULL,NULL,'','2023-12-13 10:00:00',1,NULL,'2023-12-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(408,NULL,40819,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-01-10 10:00:00',1,NULL,'2023-01-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(409,NULL,40819,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-02-10 10:00:00',1,NULL,'2023-02-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(410,NULL,40819,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-03-10 10:00:00',1,NULL,'2023-03-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(411,NULL,40819,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-04-10 10:00:00',1,NULL,'2023-04-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(412,NULL,40819,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-05-10 10:00:00',1,NULL,'2023-05-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(413,NULL,40819,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-06-10 10:00:00',1,NULL,'2023-06-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(414,NULL,40819,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-07-10 10:00:00',1,NULL,'2023-07-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(415,NULL,40819,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-08-10 10:00:00',1,NULL,'2023-08-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(416,NULL,40819,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-09-10 10:00:00',1,NULL,'2023-09-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(417,NULL,40819,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-10-10 10:00:00',1,NULL,'2023-10-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(418,NULL,40819,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-11-10 10:00:00',1,NULL,'2023-11-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(419,NULL,40819,NULL,NULL,'Honorarios Contables',NULL,NULL,'','2023-12-10 10:00:00',1,NULL,'2023-12-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(420,NULL,40819,NULL,NULL,'IVA',NULL,NULL,'','2023-01-18 10:00:00',1,NULL,'2023-01-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(421,NULL,40819,NULL,NULL,'IVA',NULL,NULL,'','2023-02-22 10:00:00',1,NULL,'2023-02-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(422,NULL,40819,NULL,NULL,'IVA',NULL,NULL,'','2023-03-20 10:00:00',1,NULL,'2023-03-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(423,NULL,40819,NULL,NULL,'IVA',NULL,NULL,'','2023-04-18 10:00:00',1,NULL,'2023-04-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (424,NULL,40819,NULL,NULL,'IVA',NULL,NULL,'','2023-05-18 10:00:00',1,NULL,'2023-05-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(425,NULL,40819,NULL,NULL,'IVA',NULL,NULL,'','2023-06-21 10:00:00',1,NULL,'2023-06-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(426,NULL,40819,NULL,NULL,'IVA',NULL,NULL,'','2023-07-18 10:00:00',1,NULL,'2023-07-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(427,NULL,40819,NULL,NULL,'IVA',NULL,NULL,'','2023-08-18 10:00:00',1,NULL,'2023-08-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(428,NULL,40819,NULL,NULL,'IVA',NULL,NULL,'','2023-09-18 10:00:00',1,NULL,'2023-09-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(429,NULL,40819,NULL,NULL,'IVA',NULL,NULL,'','2023-10-18 10:00:00',1,NULL,'2023-10-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(430,NULL,40819,NULL,NULL,'IVA',NULL,NULL,'','2023-11-21 10:00:00',1,NULL,'2023-11-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(431,NULL,40819,NULL,NULL,'IVA',NULL,NULL,'','2023-12-18 10:00:00',1,NULL,'2023-12-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(432,NULL,40820,NULL,NULL,'Monotributo',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(433,NULL,40820,NULL,NULL,'Monotributo',NULL,NULL,'','2023-02-22 10:00:00',1,NULL,'2023-02-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(434,NULL,40820,NULL,NULL,'Monotributo',NULL,NULL,'','2023-03-20 10:00:00',1,NULL,'2023-03-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(435,NULL,40820,NULL,NULL,'Monotributo',NULL,NULL,'','2023-04-20 10:00:00',1,NULL,'2023-04-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(436,NULL,40820,NULL,NULL,'Monotributo',NULL,NULL,'','2023-05-22 10:00:00',1,NULL,'2023-05-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(437,NULL,40820,NULL,NULL,'Monotributo',NULL,NULL,'','2023-06-21 10:00:00',1,NULL,'2023-06-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(438,NULL,40820,NULL,NULL,'Monotributo',NULL,NULL,'','2023-07-20 10:00:00',1,NULL,'2023-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(439,NULL,40820,NULL,NULL,'Monotributo',NULL,NULL,'','2023-08-22 10:00:00',1,NULL,'2023-08-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(440,NULL,40820,NULL,NULL,'Monotributo',NULL,NULL,'','2023-09-20 10:00:00',1,NULL,'2023-09-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(441,NULL,40820,NULL,NULL,'Monotributo',NULL,NULL,'','2023-10-20 10:00:00',1,NULL,'2023-10-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(442,NULL,40820,NULL,NULL,'Monotributo',NULL,NULL,'','2023-11-21 10:00:00',1,NULL,'2023-11-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(443,NULL,40820,NULL,NULL,'Monotributo',NULL,NULL,'','2023-12-20 10:00:00',1,NULL,'2023-12-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (444,NULL,40820,NULL,NULL,'Monotributo - Recategorizacion',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(445,NULL,40820,NULL,NULL,'Monotributo - Recategorizacion',NULL,NULL,'','2022-07-20 10:00:00',1,NULL,'2022-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `calendar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_emails_telefonos`
--

DROP TABLE IF EXISTS `calendar_emails_telefonos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_emails_telefonos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci,
  `celular` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_emails_telefonos_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_emails_telefonos_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_emails_telefonos`
--

LOCK TABLES `calendar_emails_telefonos` WRITE;
/*!40000 ALTER TABLE `calendar_emails_telefonos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_emails_telefonos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_files`
--

DROP TABLE IF EXISTS `calendar_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_files_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_files_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_files`
--

LOCK TABLES `calendar_files` WRITE;
/*!40000 ALTER TABLE `calendar_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1`
--

DROP TABLE IF EXISTS `calendar_niv_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_1_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1`
--

LOCK TABLES `calendar_niv_1` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1_2`
--

DROP TABLE IF EXISTS `calendar_niv_1_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_2_person_id_foreign` (`person_id`),
  KEY `calendar_niv_1_2_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_niv_1_2_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_niv_1_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1_2`
--

LOCK TABLES `calendar_niv_1_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_2`
--

DROP TABLE IF EXISTS `calendar_niv_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_2_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_2`
--

LOCK TABLES `calendar_niv_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_notificaciones`
--

DROP TABLE IF EXISTS `calendar_notificaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_notificaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `start` datetime DEFAULT NULL,
  `tipo_de_notificacion_id` int(10) unsigned NOT NULL,
  `cantidad` int(10) unsigned NOT NULL,
  `unidad_de_tiempo_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_notificaciones_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_notificaciones_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_notificaciones`
--

LOCK TABLES `calendar_notificaciones` WRITE;
/*!40000 ALTER TABLE `calendar_notificaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_notificaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo`
--

DROP TABLE IF EXISTS `calendar_tur_dispo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `dia_hora` datetime(5) DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00:30',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_tur_dispo_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_tur_dispo_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo`
--

LOCK TABLES `calendar_tur_dispo` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo_datos`
--

DROP TABLE IF EXISTS `calendar_tur_dispo_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_tur_dispo_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre_ape` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_datos_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` (`calendar_tur_dispo_id`),
  CONSTRAINT `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` FOREIGN KEY (`calendar_tur_dispo_id`) REFERENCES `calendar_tur_dispo` (`id`),
  CONSTRAINT `calendar_tur_dispo_datos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo_datos`
--

LOCK TABLES `calendar_tur_dispo_datos` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1850.00,11100.00,370000.00,30,3300,NULL,'1',NULL,'2022-11-08 11:41:05',NULL),(2,'B',2750.00,16500.00,550000.00,45,5000,NULL,'1',NULL,'2022-11-08 11:41:05',NULL),(3,'C',3850.00,23100.00,770000.00,60,6700,NULL,'1',NULL,'2022-11-08 11:41:05',NULL),(4,'D',5300.00,31800.00,1060000.00,85,10000,NULL,'1',NULL,'2022-11-08 11:41:05',NULL),(5,'E',7000.00,42000.00,1400000.00,110,13000,NULL,'1',NULL,'2022-11-08 11:41:05',NULL),(6,'F',8750.00,52500.00,1750000.00,150,16500,NULL,'1',NULL,'2022-11-08 11:41:05',NULL),(7,'G',10500.00,63000.00,2100000.00,200,20000,NULL,'1',NULL,'2022-11-08 11:41:05',NULL),(8,'H',13000.00,78000.00,2600000.00,200,20000,NULL,'1',NULL,'2022-11-08 11:41:05',NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',6450000.00,537500.00,'No Excluida','0',30,3330,1500000.00,3000.00,3000.00,9800.00,13800.00,26600.00,26600.00,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',9450000.00,787500.00,'No Excluida','0',45,5000,1500000.00,5700.00,5700.00,10780.00,13800.00,30280.00,30280.00,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',13250000.00,1104166.67,'No Excluida','0',60,6700,2050000.00,9800.00,9000.00,11858.00,13800.00,35458.00,34658.00,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',16450000.00,1370833.33,'No Excluida','0',85,10000,2050000.00,16000.00,14900.00,13043.80,16400.00,45443.80,44343.80,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',19350000.00,1612500.00,'No Excluida','0',110,13000,2600000.00,30000.00,23800.00,14348.18,20000.00,64348.18,58148.18,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',24250000.00,2020833.33,'No Excluida','0',150,16500,2600000.00,42200.00,31000.00,15783.00,23000.00,80983.00,69783.00,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',29000000.00,2416666.67,'No Excluida','0',200,20000,3100000.00,76800.00,38400.00,22096.20,24800.00,123696.20,85296.20,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',44000000.00,3666666.67,'No Excluida','0',200,20000,4500000.00,220000.00,110000.00,30934.68,29800.00,280734.68,170734.68,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',49250000.00,4104166.67,'Venta de Bs Muebles','0',200,20000,4500000.00,437500.00,175000.00,43308.55,36800.00,517608.55,255108.55,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',56400000.00,4700000.00,'Venta de Bs Muebles','0',200,20000,4500000.00,525000.00,210000.00,60631.97,41300.00,626931.97,311931.97,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',68000000.00,5666666.67,'Venta de Bs Muebles','0',200,20000,4500000.00,735000.00,245000.00,84884.76,47200.00,867084.76,377084.76,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',1414762.00,117896.00,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL),(13,'A Exento',1414762.00,117896.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2192.15,3061.75,5253.90,5253.90,'',NULL,NULL,'0',NULL,NULL,NULL),(14,'B Exento',2103025.00,175252.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2411.36,3061.75,5473.11,5473.11,'',NULL,NULL,'0',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `chequeras_tipos`
--

DROP TABLE IF EXISTS `chequeras_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chequeras_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chequeras_tipos`
--

LOCK TABLES `chequeras_tipos` WRITE;
/*!40000 ALTER TABLE `chequeras_tipos` DISABLE KEYS */;
INSERT INTO `chequeras_tipos` VALUES (1,NULL,'Fisica',1,NULL,NULL,NULL),(2,NULL,'Electronica',1,NULL,NULL,NULL),(3,NULL,'Transferencias',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `chequeras_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cheques_transfer_emitidas`
--

DROP TABLE IF EXISTS `cheques_transfer_emitidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cheques_transfer_emitidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_cheq_id` int(10) unsigned NOT NULL,
  `fecha_emision` date NOT NULL,
  `fecha_cobro` date NOT NULL,
  `numero_cheque` int(11) NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cheques_transfer_emitidas_person_id_foreign` (`person_id`),
  KEY `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cte_tes_ban_che_id_foreign` (`cta_cte_tesoreria_banco_cheq_id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cte_tes_ban_che_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_cheq_id`) REFERENCES `cta_cte_tesoreria_banco_cheq` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cheques_transfer_emitidas`
--

LOCK TABLES `cheques_transfer_emitidas` WRITE;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,NULL,'Clave Fiscal',NULL,NULL,NULL),(2,NULL,'Clave Ciudad',NULL,NULL,NULL),(3,NULL,'Clave ARBA',NULL,NULL,NULL),(4,NULL,'Clave ANSES',NULL,NULL,NULL),(5,NULL,'Catedral',NULL,NULL,NULL),(6,NULL,'CEMIBA',NULL,NULL,NULL),(7,NULL,'COMPRA ARG',NULL,NULL,NULL),(8,NULL,'Consejo Ciencias Economicas',NULL,NULL,NULL),(9,NULL,'Correo',NULL,NULL,NULL),(10,NULL,'CUR',NULL,NULL,NULL),(11,NULL,'Firma Digital',NULL,NULL,NULL),(12,NULL,'Interbanking',NULL,NULL,NULL),(13,NULL,'Banco Citibank',NULL,NULL,NULL),(14,NULL,'Banco Ciudad',NULL,NULL,NULL),(15,NULL,'Banco Frances',NULL,NULL,NULL),(16,NULL,'Banco Galicia',NULL,NULL,NULL),(17,NULL,'Banco HSBC',NULL,NULL,NULL),(18,NULL,'Banco Itau',NULL,NULL,NULL),(19,NULL,'Banco Nacion',NULL,NULL,NULL),(20,NULL,'Banco Macro',NULL,NULL,NULL),(21,NULL,'Banco Patagonia',NULL,NULL,NULL),(22,NULL,'Banco Provincia',NULL,NULL,NULL),(23,NULL,'Banco Santander',NULL,NULL,NULL),(24,NULL,'Banco Supervielle',NULL,NULL,NULL),(25,NULL,'Seguridad e Higiene',NULL,NULL,NULL),(26,NULL,'Sindicato - ANSES',NULL,NULL,NULL),(27,NULL,'Sindicato - AOT',NULL,NULL,NULL),(28,NULL,'Sindicato - ATSA',NULL,NULL,NULL),(29,NULL,'Sindicato - Camioneros',NULL,NULL,NULL),(30,NULL,'Sindicato - Guinchero',NULL,NULL,NULL),(31,NULL,'Sindicato - IERIC',NULL,NULL,NULL),(32,NULL,'Sindicato - La Estrella',NULL,NULL,NULL),(33,NULL,'Sindicato - Nemesis',NULL,NULL,NULL),(34,NULL,'Sindicato - Pasta',NULL,NULL,NULL),(35,NULL,'Sindicato - SEC',NULL,NULL,NULL),(36,NULL,'Sindicato - SICOP',NULL,NULL,NULL),(37,NULL,'Sindicato - SOCAYA',NULL,NULL,NULL),(38,NULL,'Sindicato - UTHGRA',NULL,NULL,NULL),(39,NULL,'Sindicato - INACAP',NULL,NULL,NULL),(40,NULL,'Sindicato - Otro',NULL,NULL,NULL),(41,NULL,'Otra',NULL,NULL,NULL),(42,NULL,'Prisma - Firma Digital',NULL,NULL,NULL),(43,NULL,'Sindicato - FATSA',NULL,NULL,NULL),(44,8082,'D.G.R. La Pampa','2023-01-12 22:12:31','2023-01-12 22:12:31',NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
INSERT INTO `claves_details` VALUES (1,8082,'A.F.I.P.','ElCoraje2855',NULL,1,40801,1,'2023-01-04 17:18:25','2023-01-04 17:18:25',NULL),(2,8082,'D.G.R.','pundang',NULL,41,40801,1,'2023-01-04 17:18:25','2023-01-04 17:18:25',NULL),(4,8082,'A.F.I.P.','GBBerg4186',NULL,1,40719,1,'2023-01-24 16:40:11','2023-01-24 16:40:11',NULL);
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2022-11-08 11:40:53','2022-11-08 11:40:53',NULL),(2,NULL,'Articulo 6',6,0,'2022-11-08 11:40:53','2022-11-08 11:40:53',NULL),(3,NULL,'Articulo 7',7,0,'2022-11-08 11:40:53','2022-11-08 11:40:53',NULL),(4,NULL,'Articulo 8',8,0,'2022-11-08 11:40:53','2022-11-08 11:40:53',NULL),(5,NULL,'Articulo 9',9,0,'2022-11-08 11:40:53','2022-11-08 11:40:53',NULL),(6,NULL,'Articulo 10',10,0,'2022-11-08 11:40:53','2022-11-08 11:40:53',NULL),(7,NULL,'Articulo 11',11,0,'2022-11-08 11:40:53','2022-11-08 11:40:53',NULL),(8,NULL,'Articulo 12',12,0,'2022-11-08 11:40:53','2022-11-08 11:40:53',NULL),(9,NULL,'Articulo 13',13,0,'2022-11-08 11:40:53','2022-11-08 11:40:53',NULL),(10,NULL,'Articulo 14',14,1,'2022-11-08 11:40:53','2022-11-08 11:40:53',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores`
--

DROP TABLE IF EXISTS `cobradores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores`
--

LOCK TABLES `cobradores` WRITE;
/*!40000 ALTER TABLE `cobradores` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_datos`
--

DROP TABLE IF EXISTS `cobradores_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `url_panel` longtext COLLATE utf8mb4_unicode_ci,
  `usuario` text COLLATE utf8mb4_unicode_ci,
  `clave` text COLLATE utf8mb4_unicode_ci,
  `numero_de_soporte` text COLLATE utf8mb4_unicode_ci,
  `inicial_create_user` text COLLATE utf8mb4_unicode_ci,
  `imp_min_p_retirar` int(11) DEFAULT NULL,
  `secret_recarga` text COLLATE utf8mb4_unicode_ci,
  `secret_on_off` text COLLATE utf8mb4_unicode_ci,
  `clave_new_user` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_datos_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_datos_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_datos`
--

LOCK TABLES `cobradores_datos` WRITE;
/*!40000 ALTER TABLE `cobradores_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_metodos`
--

DROP TABLE IF EXISTS `cobradores_metodos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_metodos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cobradores_metodos_descripcion_unique` (`descripcion`),
  KEY `cobradores_metodos_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_metodos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_metodos`
--

LOCK TABLES `cobradores_metodos` WRITE;
/*!40000 ALTER TABLE `cobradores_metodos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_metodos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_on_off`
--

DROP TABLE IF EXISTS `cobradores_on_off`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_on_off` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `on_off` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_on_off_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_on_off_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_on_off`
--

LOCK TABLES `cobradores_on_off` WRITE;
/*!40000 ALTER TABLE `cobradores_on_off` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_on_off` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condicion_frente_al_iva`
--

DROP TABLE IF EXISTS `condicion_frente_al_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condicion_frente_al_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo_afip` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_comprobantes_a` tinyint(1) NOT NULL DEFAULT '0',
  `show_comprobantes_b` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condicion_frente_al_iva`
--

LOCK TABLES `condicion_frente_al_iva` WRITE;
/*!40000 ALTER TABLE `condicion_frente_al_iva` DISABLE KEYS */;
INSERT INTO `condicion_frente_al_iva` VALUES (1,NULL,1,'IVA Responsable Inscripto',1,0,1,NULL,NULL,NULL),(2,NULL,2,'IVA Responsable no Inscripto',0,0,1,NULL,NULL,NULL),(3,NULL,3,'IVA no Responsable',0,0,1,NULL,NULL,NULL),(4,NULL,4,'IVA Sujeto Exento',0,1,1,NULL,NULL,NULL),(5,NULL,5,'Consumidor Final',0,1,1,NULL,NULL,NULL),(6,NULL,6,'Responsable Monotributo',1,0,1,NULL,NULL,NULL),(7,NULL,7,'Sujeto no Categorizado',0,1,1,NULL,NULL,NULL),(8,NULL,8,'Proveedor del Exterior',0,1,1,NULL,NULL,NULL),(9,NULL,9,'Cliente del Exterior',0,1,1,NULL,NULL,NULL),(10,NULL,10,'IVA Liberado – Ley Nº 19.640',0,1,1,NULL,NULL,NULL),(11,NULL,11,'IVA Responsable Inscripto – Agente de Percepción',0,0,1,NULL,NULL,NULL),(12,NULL,12,'Pequeño Contribuyente Eventual',0,0,1,NULL,NULL,NULL),(13,NULL,13,'Monotributista Social',1,0,1,NULL,NULL,NULL),(14,NULL,14,'Pequeño Contribuyente Eventual Social',0,0,1,NULL,NULL,NULL),(15,NULL,NULL,'Monotributista Trabajador Independiente Promovido',1,0,1,NULL,NULL,NULL),(16,NULL,NULL,'IVA No Alcanzado',0,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `condicion_frente_al_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones_venta`
--

LOCK TABLES `condiciones_venta` WRITE;
/*!40000 ALTER TABLE `condiciones_venta` DISABLE KEYS */;
INSERT INTO `condiciones_venta` VALUES (1,'Contado',NULL,NULL),(2,'Tarjeta de Debito',NULL,NULL),(3,'Tarjeta de Credito',NULL,NULL),(4,'Cuenta Corriente',NULL,NULL),(5,'Cheque',NULL,NULL),(6,'Ticket',NULL,NULL),(7,'Transferencia',NULL,NULL),(8,'Otra',NULL,NULL);
/*!40000 ALTER TABLE `condiciones_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas`
--

DROP TABLE IF EXISTS `consultas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas`
--

LOCK TABLES `consultas` WRITE;
/*!40000 ALTER TABLE `consultas` DISABLE KEYS */;
INSERT INTO `consultas` VALUES (1,NULL,'Estado Liquidaciones',1,NULL,NULL,NULL),(2,NULL,'Consumo',1,NULL,NULL,NULL),(3,NULL,'Resultado Liquidacion Hijas',1,'2023-03-12 23:45:02','2023-03-12 23:45:02',NULL);
/*!40000 ALTER TABLE `consultas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas_aux`
--

DROP TABLE IF EXISTS `consultas_aux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas_aux` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `consulta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `estado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consultas_aux_consulta_id_foreign` (`consulta_id`),
  KEY `consultas_aux_person_id_foreign` (`person_id`),
  CONSTRAINT `consultas_aux_consulta_id_foreign` FOREIGN KEY (`consulta_id`) REFERENCES `consultas` (`id`),
  CONSTRAINT `consultas_aux_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas_aux`
--

LOCK TABLES `consultas_aux` WRITE;
/*!40000 ALTER TABLE `consultas_aux` DISABLE KEYS */;
INSERT INTO `consultas_aux` VALUES (1,NULL,1,NULL,'[{\"id\":40820,\"user_id\":8082,\"field_name1\":\"ADROVER, JUAN CARLOS\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-10909198-8\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-04T23:18:01.000000Z\",\"updated_at\":\"2023-01-04T23:18:01.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":34,\"user_id\":8082,\"person_id\":40820,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-04T23:18:01.000000Z\",\"updated_at\":\"2023-01-04T23:18:24.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40820,\"person_id_titular\":40820,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":\"202719\\/3\",\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":19,\"user_id\":8082,\"person_id\":40820,\"liquidator_id\":8,\"created_at\":\"2023-01-04T23:18:24.000000Z\",\"updated_at\":\"2023-01-04T23:18:24.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":48435,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40820,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40821,\"user_id\":8082,\"field_name1\":\"ALONSO, LUIS ABEL\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-13351416-4\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-04T23:23:04.000000Z\",\"updated_at\":\"2023-01-04T23:23:04.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"status_liq_sueldos\":\"Sin Usar\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":35,\"user_id\":8082,\"person_id\":40821,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-04T23:23:04.000000Z\",\"updated_at\":\"2023-01-04T23:23:04.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":1,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":2,\"person_id_administrador\":40821,\"person_id_titular\":40821,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":\"247905\\/5\",\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":20,\"user_id\":8082,\"person_id\":40821,\"liquidator_id\":8,\"created_at\":\"2023-01-04T23:23:04.000000Z\",\"updated_at\":\"2023-01-04T23:23:04.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":49950,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40821,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40822,\"user_id\":8082,\"field_name1\":\"ALVAREZ, HERNAN EDUARDO\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-13510794-9\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-04T23:27:51.000000Z\",\"updated_at\":\"2023-01-04T23:27:51.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":36,\"user_id\":8082,\"person_id\":40822,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-04T23:27:51.000000Z\",\"updated_at\":\"2023-01-04T23:27:51.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":2,\"person_id_administrador\":40822,\"person_id_titular\":40822,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"-000001-11-30T03:53:48.000000Z\",\"iibb\":\"159321\\/7\",\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":21,\"user_id\":8082,\"person_id\":40822,\"liquidator_id\":8,\"created_at\":\"2023-01-04T23:27:51.000000Z\",\"updated_at\":\"2023-01-04T23:27:51.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":51465,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40822,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40823,\"user_id\":8082,\"field_name1\":\"BAIGORRIA, DORA MABEL\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-10614546-1\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-04T23:33:33.000000Z\",\"updated_at\":\"2023-01-04T23:33:33.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":37,\"user_id\":8082,\"person_id\":40823,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-04T23:33:34.000000Z\",\"updated_at\":\"2023-01-04T23:33:34.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":2,\"person_id_administrador\":40823,\"person_id_titular\":40823,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":\"2544139\",\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":22,\"user_id\":8082,\"person_id\":40823,\"liquidator_id\":8,\"created_at\":\"2023-01-04T23:33:34.000000Z\",\"updated_at\":\"2023-01-04T23:33:34.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":52980,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40823,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40719,\"user_id\":8082,\"field_name1\":\"Berg Graciela\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-22697418-6\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2022-11-08T20:40:31.000000Z\",\"updated_at\":\"2022-11-11T11:02:37.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":2,\"user_id\":8082,\"person_id\":40719,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2022-11-08T14:41:05.000000Z\",\"updated_at\":\"2022-11-11T16:13:55.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":0,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":0,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2022-1\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":2,\"person_id_administrador\":40719,\"person_id_titular\":40719,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-11-11T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":null,\"periods\":[{\"id\":18,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40719,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40829,\"user_id\":8082,\"field_name1\":\"Bernigaud, Mar\\u00eda Jose\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-20928845-7\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-11T21:45:01.000000Z\",\"updated_at\":\"2023-01-11T21:45:01.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":43,\"user_id\":8082,\"person_id\":40829,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-11T21:45:01.000000Z\",\"updated_at\":\"2023-01-11T21:45:01.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":0,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40829,\"person_id_titular\":40829,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":28,\"user_id\":8082,\"person_id\":40829,\"liquidator_id\":8,\"created_at\":\"2023-01-11T21:45:01.000000Z\",\"updated_at\":\"2023-01-11T21:45:01.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":62067,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40829,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40830,\"user_id\":8082,\"field_name1\":\"Breit, Gricelda\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-17009213-4\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-11T21:46:47.000000Z\",\"updated_at\":\"2023-01-11T21:46:47.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":44,\"user_id\":8082,\"person_id\":40830,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-11T21:46:47.000000Z\",\"updated_at\":\"2023-01-11T21:46:47.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40830,\"person_id_titular\":40830,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":29,\"user_id\":8082,\"person_id\":40830,\"liquidator_id\":8,\"created_at\":\"2023-01-11T21:46:47.000000Z\",\"updated_at\":\"2023-01-11T21:46:47.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":63582,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40830,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40831,\"user_id\":8082,\"field_name1\":\"Carassay, Griselda\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-14617601-7\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-11T21:50:30.000000Z\",\"updated_at\":\"2023-01-11T21:50:30.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":45,\"user_id\":8082,\"person_id\":40831,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-11T21:50:30.000000Z\",\"updated_at\":\"2023-01-11T21:50:30.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40831,\"person_id_titular\":40831,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":30,\"user_id\":8082,\"person_id\":40831,\"liquidator_id\":8,\"created_at\":\"2023-01-11T21:50:30.000000Z\",\"updated_at\":\"2023-01-11T21:50:30.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":65097,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40831,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40833,\"user_id\":8082,\"field_name1\":\"Cedro, Daniela Viviana\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-23612018-5\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-11T21:59:14.000000Z\",\"updated_at\":\"2023-01-11T21:59:14.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":47,\"user_id\":8082,\"person_id\":40833,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-11T21:59:14.000000Z\",\"updated_at\":\"2023-01-11T21:59:14.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":1,\"priority_order\":2,\"person_id_administrador\":40833,\"person_id_titular\":40833,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":32,\"user_id\":8082,\"person_id\":40833,\"liquidator_id\":8,\"created_at\":\"2023-01-11T21:59:14.000000Z\",\"updated_at\":\"2023-01-11T21:59:14.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":68127,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40833,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40832,\"user_id\":8082,\"field_name1\":\"Cobreros, Melina\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-25851209-5\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-11T21:52:40.000000Z\",\"updated_at\":\"2023-01-11T21:52:40.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":46,\"user_id\":8082,\"person_id\":40832,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-11T21:52:40.000000Z\",\"updated_at\":\"2023-01-11T21:52:40.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40832,\"person_id_titular\":40832,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":31,\"user_id\":8082,\"person_id\":40832,\"liquidator_id\":8,\"created_at\":\"2023-01-11T21:52:40.000000Z\",\"updated_at\":\"2023-01-11T21:52:40.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":66612,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40832,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40834,\"user_id\":8082,\"field_name1\":\"Cornelis, Maria Rosa\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-10075767-8\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-11T22:01:11.000000Z\",\"updated_at\":\"2023-01-11T22:01:11.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":48,\"user_id\":8082,\"person_id\":40834,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-11T22:01:11.000000Z\",\"updated_at\":\"2023-01-11T22:01:11.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40834,\"person_id_titular\":40834,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":33,\"user_id\":8082,\"person_id\":40834,\"liquidator_id\":8,\"created_at\":\"2023-01-11T22:01:11.000000Z\",\"updated_at\":\"2023-01-11T22:01:11.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":69642,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40834,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40801,\"user_id\":8082,\"field_name1\":\"El Coraje S.H.\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"30-71446692-1\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-04T20:18:25.000000Z\",\"updated_at\":\"2023-01-04T20:18:25.000000Z\",\"activity_id\":null,\"address\":\"San Martin N\\u00b0 265 - Winifreda\",\"person_type_id\":2,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"status_liq_sueldos\":\"Sin Usar\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":15,\"user_id\":8082,\"person_id\":40801,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-04T20:18:25.000000Z\",\"updated_at\":\"2023-01-04T20:18:25.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":1,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":1,\"priority_order\":1,\"person_id_administrador\":40801,\"person_id_titular\":40801,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2023-01-01T03:00:00.000000Z\",\"iibb\":\"242331\\/1\",\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":1,\"atencion_iibb_comentario\":\"La venta de animales est\\u00e1 gravada al 0,7% si es dentro de la provincia y al 1,5% si es fuera de a provincia.\",\"deleted_at\":null}],\"liquidador\":{\"id\":16,\"user_id\":8082,\"person_id\":40801,\"liquidator_id\":8,\"created_at\":\"2023-01-04T20:18:25.000000Z\",\"updated_at\":\"2023-01-04T20:18:25.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":19650,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40801,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40835,\"user_id\":8082,\"field_name1\":\"Eleva, Sergio\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-27796644-2\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-11T22:41:38.000000Z\",\"updated_at\":\"2023-01-11T22:41:38.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":49,\"user_id\":8082,\"person_id\":40835,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-11T22:41:39.000000Z\",\"updated_at\":\"2023-01-11T22:41:39.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40835,\"person_id_titular\":40835,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":34,\"user_id\":8082,\"person_id\":40835,\"liquidator_id\":8,\"created_at\":\"2023-01-11T22:41:39.000000Z\",\"updated_at\":\"2023-01-11T22:41:39.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":71157,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40835,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40836,\"user_id\":8082,\"field_name1\":\"Frias, Silvia\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-16873019-0\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-11T22:43:23.000000Z\",\"updated_at\":\"2023-01-11T22:43:23.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":50,\"user_id\":8082,\"person_id\":40836,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-11T22:43:23.000000Z\",\"updated_at\":\"2023-01-11T22:43:23.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40836,\"person_id_titular\":40836,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":35,\"user_id\":8082,\"person_id\":40836,\"liquidator_id\":8,\"created_at\":\"2023-01-11T22:43:23.000000Z\",\"updated_at\":\"2023-01-11T22:43:23.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":72672,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40836,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40837,\"user_id\":8082,\"field_name1\":\"Fridel, Marcelo Alberto\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-20108315-0\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-11T22:49:47.000000Z\",\"updated_at\":\"2023-01-11T22:49:47.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":51,\"user_id\":8082,\"person_id\":40837,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-11T22:49:47.000000Z\",\"updated_at\":\"2023-01-11T22:49:47.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":1,\"is_itc\":0,\"priority_order\":1,\"person_id_administrador\":40837,\"person_id_titular\":40837,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":36,\"user_id\":8082,\"person_id\":40837,\"liquidator_id\":8,\"created_at\":\"2023-01-11T22:49:47.000000Z\",\"updated_at\":\"2023-01-11T22:49:47.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":74187,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40837,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40849,\"user_id\":8082,\"field_name1\":\"Fridel, Nestor Fabian\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-17783934-6\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-11T22:57:36.000000Z\",\"updated_at\":\"2023-01-11T22:57:36.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":61,\"user_id\":8082,\"person_id\":40849,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-11T22:57:36.000000Z\",\"updated_at\":\"2023-01-11T22:57:36.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":1,\"person_id_administrador\":40849,\"person_id_titular\":40849,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":46,\"user_id\":8082,\"person_id\":40849,\"liquidator_id\":8,\"created_at\":\"2023-01-11T22:57:36.000000Z\",\"updated_at\":\"2023-01-11T22:57:36.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":89337,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40849,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40722,\"user_id\":8082,\"field_name1\":\"Fundaci\\u00f3n Winifreda y M. Mayer\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"30-70712129-3\",\"cond_frente_al_iva_id\":4,\"country_id\":null,\"state_id\":8,\"zone_id\":8,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2022-11-10T16:11:47.000000Z\",\"updated_at\":\"2022-12-01T00:16:24.000000Z\",\"activity_id\":null,\"address\":\"25 de mayo N\\u00b0 35\",\"person_type_id\":2,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"status_liq_sueldos\":\"Sin Usar\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":14,\"user_id\":8082,\"person_id\":40722,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2022-12-01T00:16:24.000000Z\",\"updated_at\":\"2022-12-01T00:16:24.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":1,\"iva_condition_id\":3,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2022-01\",\"obligation_salaries\":1,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":null,\"person_id_administrador\":40722,\"person_id_titular\":40722,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"-000001-11-30T03:53:48.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":1,\"atencion_iva_comentario\":null,\"atencion_iibb\":1,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":null,\"periods\":[{\"id\":18153,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40722,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40850,\"user_id\":8082,\"field_name1\":\"Furch, Hugo\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-12478402-7\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-11T23:00:23.000000Z\",\"updated_at\":\"2023-01-11T23:00:23.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":62,\"user_id\":8082,\"person_id\":40850,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-11T23:00:23.000000Z\",\"updated_at\":\"2023-01-11T23:00:23.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":null,\"person_id_administrador\":40850,\"person_id_titular\":40850,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":47,\"user_id\":8082,\"person_id\":40850,\"liquidator_id\":8,\"created_at\":\"2023-01-11T23:00:23.000000Z\",\"updated_at\":\"2023-01-11T23:00:23.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":90852,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40850,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40851,\"user_id\":8082,\"field_name1\":\"Garcia, Carina\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-25311139-4\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-11T23:01:47.000000Z\",\"updated_at\":\"2023-01-11T23:01:47.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":63,\"user_id\":8082,\"person_id\":40851,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-11T23:01:47.000000Z\",\"updated_at\":\"2023-01-11T23:01:47.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40851,\"person_id_titular\":40851,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":48,\"user_id\":8082,\"person_id\":40851,\"liquidator_id\":8,\"created_at\":\"2023-01-11T23:01:47.000000Z\",\"updated_at\":\"2023-01-11T23:01:47.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":92367,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40851,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40852,\"user_id\":8082,\"field_name1\":\"Gross, Armando E.\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-07359309-4\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-11T23:04:19.000000Z\",\"updated_at\":\"2023-01-11T23:04:19.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":64,\"user_id\":8082,\"person_id\":40852,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-11T23:04:19.000000Z\",\"updated_at\":\"2023-01-11T23:04:19.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":1,\"is_itc\":0,\"priority_order\":2,\"person_id_administrador\":40852,\"person_id_titular\":40852,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-02T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":49,\"user_id\":8082,\"person_id\":40852,\"liquidator_id\":8,\"created_at\":\"2023-01-11T23:04:19.000000Z\",\"updated_at\":\"2023-01-11T23:04:19.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":93882,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40852,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40853,\"user_id\":8082,\"field_name1\":\"Heck, Juana\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-10269520-3\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-11T23:06:16.000000Z\",\"updated_at\":\"2023-01-11T23:06:16.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":65,\"user_id\":8082,\"person_id\":40853,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-11T23:06:17.000000Z\",\"updated_at\":\"2023-01-11T23:06:17.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40853,\"person_id_titular\":40853,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2023-01-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":50,\"user_id\":8082,\"person_id\":40853,\"liquidator_id\":8,\"created_at\":\"2023-01-11T23:06:17.000000Z\",\"updated_at\":\"2023-01-11T23:06:17.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":95397,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40853,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40854,\"user_id\":8082,\"field_name1\":\"Koller, Juan Carlos\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"23-29979260-9\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-11T23:08:59.000000Z\",\"updated_at\":\"2023-01-11T23:08:59.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":66,\"user_id\":8082,\"person_id\":40854,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-11T23:08:59.000000Z\",\"updated_at\":\"2023-01-11T23:08:59.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":1,\"priority_order\":2,\"person_id_administrador\":40854,\"person_id_titular\":40854,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":51,\"user_id\":8082,\"person_id\":40854,\"liquidator_id\":8,\"created_at\":\"2023-01-11T23:08:59.000000Z\",\"updated_at\":\"2023-01-11T23:08:59.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":96912,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40854,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40855,\"user_id\":8082,\"field_name1\":\"Leguizam\\u00f3n, Carlos\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-17009211-3\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-11T23:11:26.000000Z\",\"updated_at\":\"2023-01-11T23:11:26.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":67,\"user_id\":8082,\"person_id\":40855,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-11T23:11:26.000000Z\",\"updated_at\":\"2023-01-11T23:11:26.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":1,\"priority_order\":1,\"person_id_administrador\":40855,\"person_id_titular\":40855,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2023-01-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":52,\"user_id\":8082,\"person_id\":40855,\"liquidator_id\":8,\"created_at\":\"2023-01-11T23:11:26.000000Z\",\"updated_at\":\"2023-01-11T23:11:26.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":98427,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40855,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40856,\"user_id\":8082,\"field_name1\":\"Luque, Mar\\u00eda del Carmen\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-22700948-4\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T01:01:33.000000Z\",\"updated_at\":\"2023-01-12T01:01:33.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":68,\"user_id\":8082,\"person_id\":40856,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T01:01:33.000000Z\",\"updated_at\":\"2023-01-12T01:01:33.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40856,\"person_id_titular\":40856,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":53,\"user_id\":8082,\"person_id\":40856,\"liquidator_id\":8,\"created_at\":\"2023-01-12T01:01:33.000000Z\",\"updated_at\":\"2023-01-12T01:01:33.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":99942,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40856,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40720,\"user_id\":8082,\"field_name1\":\"Martin, M\\u00f3nica Daniela\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-25311102-5\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2022-11-08T18:12:56.000000Z\",\"updated_at\":\"2022-11-08T18:12:56.000000Z\",\"activity_id\":null,\"address\":\"Espa\\u00f1a N\\u00b0 120\",\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"status_liq_sueldos\":\"Sin Usar\",\"status_liq_domestica\":\"Sin Usar\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":3,\"user_id\":8082,\"person_id\":40720,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2022-11-08T18:12:56.000000Z\",\"updated_at\":\"2022-12-10T00:41:02.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2022-01\",\"obligation_salaries\":1,\"empleada_domestica\":1,\"prorratear_iva\":0,\"is_itc\":1,\"priority_order\":1,\"person_id_administrador\":40720,\"person_id_titular\":40720,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2021-09-01T03:00:00.000000Z\",\"iibb\":\"125658\\/8\",\"fe_leyenda\":null,\"atencion_iva\":1,\"atencion_iva_comentario\":\"cigarrillos\",\"atencion_iibb\":1,\"atencion_iibb_comentario\":\"CM\",\"deleted_at\":null}],\"liquidador\":{\"id\":15,\"user_id\":8082,\"person_id\":40720,\"liquidator_id\":8,\"created_at\":\"2022-12-10T00:41:02.000000Z\",\"updated_at\":\"2022-12-10T00:41:02.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":1533,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40720,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40721,\"user_id\":8082,\"field_name1\":\"Naab, Nestor Javier\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-18222259-4\",\"cond_frente_al_iva_id\":1,\"country_id\":null,\"state_id\":8,\"zone_id\":8,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2022-11-10T16:07:57.000000Z\",\"updated_at\":\"2022-11-11T11:01:47.000000Z\",\"activity_id\":null,\"address\":\"Primera Junta N\\u00b0 471\",\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"status_liq_sueldos\":\"Sin Usar\",\"status_liq_domestica\":\"Sin Usar\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":4,\"user_id\":8082,\"person_id\":40721,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2022-11-11T11:01:48.000000Z\",\"updated_at\":\"2022-11-11T16:09:30.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":4,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2022-01\",\"obligation_salaries\":1,\"empleada_domestica\":1,\"prorratear_iva\":1,\"is_itc\":1,\"priority_order\":1,\"person_id_administrador\":40721,\"person_id_titular\":40721,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2021-07-01T03:00:00.000000Z\",\"iibb\":\"20182222594\",\"fe_leyenda\":null,\"atencion_iva\":1,\"atencion_iva_comentario\":null,\"atencion_iibb\":1,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":11,\"user_id\":8082,\"person_id\":40721,\"liquidator_id\":8,\"created_at\":\"2022-11-11T15:59:27.000000Z\",\"updated_at\":\"2022-11-11T15:59:27.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":3045,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40721,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40857,\"user_id\":8082,\"field_name1\":\"Navarro, Emilio\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"23-22887219-9\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T01:02:46.000000Z\",\"updated_at\":\"2023-01-12T01:02:46.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":69,\"user_id\":8082,\"person_id\":40857,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T01:02:46.000000Z\",\"updated_at\":\"2023-01-12T01:02:46.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40857,\"person_id_titular\":40857,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":54,\"user_id\":8082,\"person_id\":40857,\"liquidator_id\":8,\"created_at\":\"2023-01-12T01:02:46.000000Z\",\"updated_at\":\"2023-01-12T01:02:46.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":101457,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40857,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40773,\"user_id\":8082,\"field_name1\":\"Norverto, L\\u00eda\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-22036270-7\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2022-11-14T01:08:23.000000Z\",\"updated_at\":\"2022-11-14T01:08:23.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_domestica\":\"Sin Usar\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":8,\"user_id\":8082,\"person_id\":40773,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2022-11-14T01:08:23.000000Z\",\"updated_at\":\"2022-11-14T01:08:23.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":3,\"obligation_sell\":0,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":0,\"obligation_iibb\":1,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2022-10\",\"obligation_salaries\":0,\"empleada_domestica\":1,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":null,\"person_id_administrador\":40773,\"person_id_titular\":40773,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"-000001-11-30T03:53:48.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":13,\"user_id\":8082,\"person_id\":40773,\"liquidator_id\":8,\"created_at\":\"2022-11-14T01:08:23.000000Z\",\"updated_at\":\"2022-11-14T01:08:23.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":9066,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40773,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40858,\"user_id\":8082,\"field_name1\":\"Petengaizer, Gonzalo\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-32650749-1\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T01:06:13.000000Z\",\"updated_at\":\"2023-01-12T01:06:13.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":70,\"user_id\":8082,\"person_id\":40858,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T01:06:13.000000Z\",\"updated_at\":\"2023-01-12T01:06:13.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40858,\"person_id_titular\":40858,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":55,\"user_id\":8082,\"person_id\":40858,\"liquidator_id\":8,\"created_at\":\"2023-01-12T01:06:13.000000Z\",\"updated_at\":\"2023-01-12T01:06:13.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":102972,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40858,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40859,\"user_id\":8082,\"field_name1\":\"Petengaizer, Gustavo\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-34199408-0\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T01:07:22.000000Z\",\"updated_at\":\"2023-01-12T01:07:22.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":71,\"user_id\":8082,\"person_id\":40859,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T01:07:22.000000Z\",\"updated_at\":\"2023-01-12T01:07:22.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40859,\"person_id_titular\":40859,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":56,\"user_id\":8082,\"person_id\":40859,\"liquidator_id\":8,\"created_at\":\"2023-01-12T01:07:22.000000Z\",\"updated_at\":\"2023-01-12T01:07:22.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":104487,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40859,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40861,\"user_id\":8082,\"field_name1\":\"Petengaizer, Jos\\u00e9\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-12478447-7\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T01:13:25.000000Z\",\"updated_at\":\"2023-01-12T01:13:25.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":73,\"user_id\":8082,\"person_id\":40861,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T01:13:26.000000Z\",\"updated_at\":\"2023-01-12T01:13:26.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":1,\"person_id_administrador\":40861,\"person_id_titular\":40861,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":58,\"user_id\":8082,\"person_id\":40861,\"liquidator_id\":8,\"created_at\":\"2023-01-12T01:13:26.000000Z\",\"updated_at\":\"2023-01-12T01:13:26.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":107517,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40861,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40860,\"user_id\":8082,\"field_name1\":\"Petengaizer, Pablo\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-31139128-4\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T01:10:24.000000Z\",\"updated_at\":\"2023-01-12T01:10:24.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":72,\"user_id\":8082,\"person_id\":40860,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T01:10:25.000000Z\",\"updated_at\":\"2023-01-12T01:10:25.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40860,\"person_id_titular\":40860,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":1,\"atencion_iibb_comentario\":\"Ventas dentro de la provincia de L.P. 0,7% \\r\\nFuera de la Provincia de L.P. 1,50%\",\"deleted_at\":null}],\"liquidador\":{\"id\":57,\"user_id\":8082,\"person_id\":40860,\"liquidator_id\":8,\"created_at\":\"2023-01-12T01:10:25.000000Z\",\"updated_at\":\"2023-01-12T01:10:25.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":106002,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40860,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40862,\"user_id\":8082,\"field_name1\":\"Pitz, Raul\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-20108323-1\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T01:18:05.000000Z\",\"updated_at\":\"2023-01-12T01:18:05.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":74,\"user_id\":8082,\"person_id\":40862,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T01:18:06.000000Z\",\"updated_at\":\"2023-01-12T01:18:06.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40862,\"person_id_titular\":40862,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":59,\"user_id\":8082,\"person_id\":40862,\"liquidator_id\":8,\"created_at\":\"2023-01-12T01:18:06.000000Z\",\"updated_at\":\"2023-01-12T01:18:06.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":109032,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40862,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40863,\"user_id\":8082,\"field_name1\":\"Ponce, Oscar\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-13705764-7\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T02:11:57.000000Z\",\"updated_at\":\"2023-01-12T02:11:57.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":75,\"user_id\":8082,\"person_id\":40863,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T02:11:57.000000Z\",\"updated_at\":\"2023-01-12T02:11:57.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40863,\"person_id_titular\":40863,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":60,\"user_id\":8082,\"person_id\":40863,\"liquidator_id\":8,\"created_at\":\"2023-01-12T02:11:57.000000Z\",\"updated_at\":\"2023-01-12T02:11:57.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":110547,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40863,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40864,\"user_id\":8082,\"field_name1\":\"Pundang, Mauricio\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-25903340-4\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T02:14:24.000000Z\",\"updated_at\":\"2023-01-12T02:14:24.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":76,\"user_id\":8082,\"person_id\":40864,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T02:14:24.000000Z\",\"updated_at\":\"2023-01-12T02:14:24.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":1,\"person_id_administrador\":40864,\"person_id_titular\":40864,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":61,\"user_id\":8082,\"person_id\":40864,\"liquidator_id\":8,\"created_at\":\"2023-01-12T02:14:24.000000Z\",\"updated_at\":\"2023-01-12T02:14:24.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":112062,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40864,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40865,\"user_id\":8082,\"field_name1\":\"Pundang, Sergio\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"23-22490318-9\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T02:16:02.000000Z\",\"updated_at\":\"2023-01-12T02:16:02.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":77,\"user_id\":8082,\"person_id\":40865,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T02:16:02.000000Z\",\"updated_at\":\"2023-01-12T02:16:02.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":1,\"priority_order\":1,\"person_id_administrador\":40865,\"person_id_titular\":40865,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":62,\"user_id\":8082,\"person_id\":40865,\"liquidator_id\":8,\"created_at\":\"2023-01-12T02:16:02.000000Z\",\"updated_at\":\"2023-01-12T02:16:02.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":113577,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40865,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40866,\"user_id\":8082,\"field_name1\":\"Rinienart, Daniel\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-17009221-0\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T02:17:54.000000Z\",\"updated_at\":\"2023-01-12T02:17:54.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":78,\"user_id\":8082,\"person_id\":40866,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T02:17:55.000000Z\",\"updated_at\":\"2023-01-12T02:17:55.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40866,\"person_id_titular\":40866,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":63,\"user_id\":8082,\"person_id\":40866,\"liquidator_id\":8,\"created_at\":\"2023-01-12T02:17:55.000000Z\",\"updated_at\":\"2023-01-12T02:17:55.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":115092,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40866,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40867,\"user_id\":8082,\"field_name1\":\"Rosa, Mauro Duilio\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-24056326-7\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T02:20:54.000000Z\",\"updated_at\":\"2023-01-12T02:20:54.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":79,\"user_id\":8082,\"person_id\":40867,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T02:20:54.000000Z\",\"updated_at\":\"2023-01-12T02:20:54.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":1,\"priority_order\":2,\"person_id_administrador\":40867,\"person_id_titular\":40867,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":64,\"user_id\":8082,\"person_id\":40867,\"liquidator_id\":8,\"created_at\":\"2023-01-12T02:20:54.000000Z\",\"updated_at\":\"2023-01-12T02:20:54.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":116607,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40867,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40868,\"user_id\":8082,\"field_name1\":\"Schall, Julio Nelson\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-17009248-2\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T09:17:21.000000Z\",\"updated_at\":\"2023-01-12T09:17:21.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":80,\"user_id\":8082,\"person_id\":40868,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T09:17:21.000000Z\",\"updated_at\":\"2023-01-12T09:17:21.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40868,\"person_id_titular\":40868,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":65,\"user_id\":8082,\"person_id\":40868,\"liquidator_id\":8,\"created_at\":\"2023-01-12T09:17:21.000000Z\",\"updated_at\":\"2023-01-12T09:17:21.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":118119,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40868,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40869,\"user_id\":8082,\"field_name1\":\"Schall, Sergio\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-18222254-3\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T09:18:40.000000Z\",\"updated_at\":\"2023-01-12T09:18:40.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":81,\"user_id\":8082,\"person_id\":40869,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T09:18:40.000000Z\",\"updated_at\":\"2023-01-12T09:18:40.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40869,\"person_id_titular\":40869,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":66,\"user_id\":8082,\"person_id\":40869,\"liquidator_id\":8,\"created_at\":\"2023-01-12T09:18:40.000000Z\",\"updated_at\":\"2023-01-12T09:18:40.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":119634,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40869,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40870,\"user_id\":8082,\"field_name1\":\"Schiebelbein, Raul\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-14788807-5\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T09:19:49.000000Z\",\"updated_at\":\"2023-01-12T09:19:49.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":82,\"user_id\":8082,\"person_id\":40870,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T09:19:50.000000Z\",\"updated_at\":\"2023-01-12T09:19:50.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40870,\"person_id_titular\":40870,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":67,\"user_id\":8082,\"person_id\":40870,\"liquidator_id\":8,\"created_at\":\"2023-01-12T09:19:50.000000Z\",\"updated_at\":\"2023-01-12T09:19:50.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":121149,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40870,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40723,\"user_id\":8082,\"field_name1\":\"Sereno, Oscar\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-07363559-5\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2022-11-11T11:05:14.000000Z\",\"updated_at\":\"2022-11-11T11:05:14.000000Z\",\"activity_id\":null,\"address\":\"9 de Julio N\\u00b0 605\",\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"status_liq_sueldos\":\"Sin Usar\",\"status_liq_domestica\":\"Sin Usar\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":5,\"user_id\":8082,\"person_id\":40723,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2022-11-11T11:05:14.000000Z\",\"updated_at\":\"2022-11-11T16:12:33.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2022-01\",\"obligation_salaries\":1,\"empleada_domestica\":1,\"prorratear_iva\":1,\"is_itc\":1,\"priority_order\":1,\"person_id_administrador\":40723,\"person_id_titular\":40723,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2020-09-02T03:00:00.000000Z\",\"iibb\":\"20073635595\",\"fe_leyenda\":null,\"atencion_iva\":1,\"atencion_iva_comentario\":null,\"atencion_iibb\":1,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":12,\"user_id\":8082,\"person_id\":40723,\"liquidator_id\":8,\"created_at\":\"2022-11-11T16:12:33.000000Z\",\"updated_at\":\"2022-11-11T16:12:33.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":4560,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40723,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40871,\"user_id\":8082,\"field_name1\":\"Soncini, Ruben\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"23-12078166-9\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T09:23:22.000000Z\",\"updated_at\":\"2023-01-12T09:23:22.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":83,\"user_id\":8082,\"person_id\":40871,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T09:23:22.000000Z\",\"updated_at\":\"2023-01-12T09:23:22.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":1,\"priority_order\":1,\"person_id_administrador\":40871,\"person_id_titular\":40871,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":68,\"user_id\":8082,\"person_id\":40871,\"liquidator_id\":8,\"created_at\":\"2023-01-12T09:23:22.000000Z\",\"updated_at\":\"2023-01-12T09:23:22.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":122664,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40871,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40872,\"user_id\":8082,\"field_name1\":\"Stroh, Griselda\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-23872653-6\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T09:25:22.000000Z\",\"updated_at\":\"2023-01-12T09:25:22.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":84,\"user_id\":8082,\"person_id\":40872,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T09:25:23.000000Z\",\"updated_at\":\"2023-01-12T09:25:23.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40872,\"person_id_titular\":40872,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":69,\"user_id\":8082,\"person_id\":40872,\"liquidator_id\":8,\"created_at\":\"2023-01-12T09:25:23.000000Z\",\"updated_at\":\"2023-01-12T09:25:23.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":124179,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40872,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40873,\"user_id\":8082,\"field_name1\":\"Sulca, Ignacio\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-07260138-7\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T09:27:04.000000Z\",\"updated_at\":\"2023-01-12T09:27:04.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":85,\"user_id\":8082,\"person_id\":40873,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T09:27:04.000000Z\",\"updated_at\":\"2023-01-12T09:27:04.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40873,\"person_id_titular\":40873,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":70,\"user_id\":8082,\"person_id\":40873,\"liquidator_id\":8,\"created_at\":\"2023-01-12T09:27:04.000000Z\",\"updated_at\":\"2023-01-12T09:27:04.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":125694,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40873,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40874,\"user_id\":8082,\"field_name1\":\"Ternovoy, Georgina\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-28559363-3\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T09:28:12.000000Z\",\"updated_at\":\"2023-01-12T09:28:12.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":86,\"user_id\":8082,\"person_id\":40874,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T09:28:12.000000Z\",\"updated_at\":\"2023-01-12T09:28:12.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40874,\"person_id_titular\":40874,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":71,\"user_id\":8082,\"person_id\":40874,\"liquidator_id\":8,\"created_at\":\"2023-01-12T09:28:13.000000Z\",\"updated_at\":\"2023-01-12T09:28:13.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":127209,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40874,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40875,\"user_id\":8082,\"field_name1\":\"Thome, Juan Jose\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-17009231-8\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T09:30:16.000000Z\",\"updated_at\":\"2023-01-12T09:30:16.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":87,\"user_id\":8082,\"person_id\":40875,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T09:30:16.000000Z\",\"updated_at\":\"2023-01-12T09:30:16.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40875,\"person_id_titular\":40875,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":72,\"user_id\":8082,\"person_id\":40875,\"liquidator_id\":8,\"created_at\":\"2023-01-12T09:30:16.000000Z\",\"updated_at\":\"2023-01-12T09:30:16.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":128724,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40875,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40876,\"user_id\":8082,\"field_name1\":\"Thome, Luciano\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-34199422-6\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T09:31:30.000000Z\",\"updated_at\":\"2023-01-12T09:31:30.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":88,\"user_id\":8082,\"person_id\":40876,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T09:31:30.000000Z\",\"updated_at\":\"2023-01-12T09:31:30.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40876,\"person_id_titular\":40876,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":73,\"user_id\":8082,\"person_id\":40876,\"liquidator_id\":8,\"created_at\":\"2023-01-12T09:31:30.000000Z\",\"updated_at\":\"2023-01-12T09:31:30.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":130239,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40876,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40877,\"user_id\":8082,\"field_name1\":\"Thome, Maximiliano\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-32650710-6\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T09:32:46.000000Z\",\"updated_at\":\"2023-01-12T09:41:27.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":89,\"user_id\":8082,\"person_id\":40877,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T09:32:46.000000Z\",\"updated_at\":\"2023-01-12T09:41:27.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40877,\"person_id_titular\":40877,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":80,\"user_id\":8082,\"person_id\":40877,\"liquidator_id\":8,\"created_at\":\"2023-01-12T09:41:27.000000Z\",\"updated_at\":\"2023-01-12T09:41:27.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":131754,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40877,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40878,\"user_id\":8082,\"field_name1\":\"Torres, Jes\\u00fas\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-31799011-2\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T09:34:37.000000Z\",\"updated_at\":\"2023-01-12T09:34:37.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":90,\"user_id\":8082,\"person_id\":40878,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T09:34:37.000000Z\",\"updated_at\":\"2023-01-12T09:37:13.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40878,\"person_id_titular\":40878,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":77,\"user_id\":8082,\"person_id\":40878,\"liquidator_id\":8,\"created_at\":\"2023-01-12T09:37:13.000000Z\",\"updated_at\":\"2023-01-12T09:37:13.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":133269,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40878,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40879,\"user_id\":8082,\"field_name1\":\"Urlacher, Estela\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-13312075-6\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T09:36:01.000000Z\",\"updated_at\":\"2023-01-12T09:36:01.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":91,\"user_id\":8082,\"person_id\":40879,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T09:36:01.000000Z\",\"updated_at\":\"2023-01-12T09:36:01.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":2,\"person_id_administrador\":40879,\"person_id_titular\":40879,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":76,\"user_id\":8082,\"person_id\":40879,\"liquidator_id\":8,\"created_at\":\"2023-01-12T09:36:01.000000Z\",\"updated_at\":\"2023-01-12T09:36:01.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":134784,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40879,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40819,\"user_id\":8082,\"field_name1\":\"Urricariet, Alicia Susana\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-11121330-0\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-04T20:54:21.000000Z\",\"updated_at\":\"2023-01-04T20:54:21.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":33,\"user_id\":8082,\"person_id\":40819,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-04T20:54:21.000000Z\",\"updated_at\":\"2023-01-04T20:54:21.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":4,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":1,\"priority_order\":1,\"person_id_administrador\":40819,\"person_id_titular\":40819,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":\"27111213300\",\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":17,\"user_id\":8082,\"person_id\":40819,\"liquidator_id\":8,\"created_at\":\"2023-01-04T20:54:21.000000Z\",\"updated_at\":\"2023-01-04T20:54:21.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":46920,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40819,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40880,\"user_id\":8082,\"field_name1\":\"Vazquez, Pamela\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-27647945-3\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T09:38:36.000000Z\",\"updated_at\":\"2023-01-12T09:38:36.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":92,\"user_id\":8082,\"person_id\":40880,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T09:38:36.000000Z\",\"updated_at\":\"2023-01-12T09:38:36.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":2,\"person_id_administrador\":40880,\"person_id_titular\":40880,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":78,\"user_id\":8082,\"person_id\":40880,\"liquidator_id\":8,\"created_at\":\"2023-01-12T09:38:36.000000Z\",\"updated_at\":\"2023-01-12T09:38:36.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":136299,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40880,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40881,\"user_id\":8082,\"field_name1\":\"Wiggenhauser, Jose\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-31799005-8\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-01-12T09:41:06.000000Z\",\"updated_at\":\"2023-01-12T09:41:06.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":93,\"user_id\":8082,\"person_id\":40881,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-01-12T09:41:06.000000Z\",\"updated_at\":\"2023-01-12T09:41:06.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":3,\"person_id_administrador\":40881,\"person_id_titular\":40881,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-01T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":79,\"user_id\":8082,\"person_id\":40881,\"liquidator_id\":8,\"created_at\":\"2023-01-12T09:41:06.000000Z\",\"updated_at\":\"2023-01-12T09:41:06.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":8082,\"name\":\"Graciela Berg\",\"created_at\":\"2022-11-08T14:54:35.000000Z\",\"updated_at\":\"2022-11-08T14:54:35.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":137814,\"user_id\":null,\"code\":\"2023-01\",\"year\":2023,\"period_number\":1,\"date_from\":\"2023-01-01\",\"date_to\":\"2023-01-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40881,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]}]',1,'2023-01-12 06:42:42','2023-01-12 06:42:43',NULL);
/*!40000 ALTER TABLE `consultas_aux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos`
--

DROP TABLE IF EXISTS `conta_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `debe_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `haber_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `ctactecheque_id` int(10) unsigned DEFAULT NULL,
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `adjunto` text COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `radioChecked` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `CuentaTipo_id` int(10) unsigned DEFAULT NULL,
  `CentroCosto_id` int(10) unsigned DEFAULT NULL,
  `pagado` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_person_id_foreign` (`person_id`),
  KEY `conta_asientos_period_id_foreign` (`period_id`),
  KEY `conta_asientos_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `conta_asientos_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `conta_asientos_ctactecheque_id_foreign` (`ctactecheque_id`),
  KEY `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` (`haber_cta_cte_tesoreria_cuenta_id`),
  KEY `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` (`debe_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `conta_asientos_ctactecheque_id_foreign` FOREIGN KEY (`ctactecheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `conta_asientos_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`debe_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`haber_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos`
--

LOCK TABLES `conta_asientos` WRITE;
/*!40000 ALTER TABLE `conta_asientos` DISABLE KEYS */;
INSERT INTO `conta_asientos` VALUES (1,8082,40720,NULL,2,NULL,NULL,NULL,NULL,'2022-11-11','2022-11-11',7000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2022-11-11 13:09:02','2022-11-11 13:09:02',NULL),(2,8082,40721,NULL,2,NULL,NULL,NULL,NULL,'2022-11-11','2022-11-11',5000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2022-11-11 13:09:02','2022-11-11 13:09:02',NULL),(3,8082,40723,NULL,2,NULL,NULL,NULL,NULL,'2022-11-11','2022-11-11',7000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2022-11-11 13:09:02','2022-11-11 13:09:02',NULL),(4,8082,40820,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',2000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(5,8082,40821,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(6,8082,40822,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',3000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(7,8082,40823,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(8,8082,40829,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',5000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(9,8082,40830,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',5000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(10,8082,40831,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',3000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(11,8082,40833,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',5000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(12,8082,40832,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',5000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(13,8082,40834,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',5000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(14,8082,40801,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',10000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(15,8082,40835,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',5000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(16,8082,40836,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',2000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(17,8082,40837,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(18,8082,40849,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',5000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(19,8082,40722,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',15000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(20,8082,40850,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',4000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(21,8082,40851,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',3000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(22,8082,40852,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(23,8082,40853,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',2000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL);
INSERT INTO `conta_asientos` VALUES (24,8082,40854,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(25,8082,40855,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(26,8082,40856,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(27,8082,40720,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(28,8082,40721,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(29,8082,40857,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(30,8082,40773,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(31,8082,40858,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(32,8082,40859,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(33,8082,40861,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(34,8082,40860,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(35,8082,40862,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(36,8082,40863,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(37,8082,40864,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(38,8082,40865,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(39,8082,40866,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(40,8082,40867,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(41,8082,40868,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(42,8082,40869,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(43,8082,40870,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(44,8082,40723,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(45,8082,40871,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(46,8082,40872,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL);
INSERT INTO `conta_asientos` VALUES (47,8082,40873,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(48,8082,40874,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(49,8082,40875,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(50,8082,40876,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(51,8082,40877,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(52,8082,40878,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(53,8082,40879,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(54,8082,40819,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(55,8082,40880,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',6000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(56,8082,40881,NULL,2,NULL,NULL,NULL,NULL,'2023-02-09','2023-02-09',2500.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-09 20:02:26','2023-02-28 10:19:38','2023-02-28 10:19:38'),(57,8082,40881,NULL,2,13,480,NULL,NULL,'2023-02-09','2023-02-28',2500.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-02-28 10:19:38','2023-02-28 10:19:38',NULL);
/*!40000 ALTER TABLE `conta_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos_details`
--

DROP TABLE IF EXISTS `conta_asientos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_details_conta_asiento_id_foreign` (`conta_asiento_id`),
  KEY `conta_asientos_details_person_id_foreign` (`person_id`),
  KEY `conta_asientos_details_period_id_foreign` (`period_id`),
  KEY `conta_asientos_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_details_saldo_id_foreign` (`saldo_id`),
  KEY `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_details_conta_asiento_id_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_asientos_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=115 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos_details`
--

LOCK TABLES `conta_asientos_details` WRITE;
/*!40000 ALTER TABLE `conta_asientos_details` DISABLE KEYS */;
INSERT INTO `conta_asientos_details` VALUES (1,8082,1,40720,NULL,2,13,1,7000.00,'2022-11-11 13:09:02','2022-11-11 13:09:02',NULL),(2,8082,1,40720,NULL,2,480,2,7000.00,'2022-11-11 13:09:02','2022-11-11 13:09:02',NULL),(3,8082,2,40721,NULL,2,13,1,5000.00,'2022-11-11 13:09:02','2022-11-11 13:09:02',NULL),(4,8082,2,40721,NULL,2,480,2,5000.00,'2022-11-11 13:09:02','2022-11-11 13:09:02',NULL),(5,8082,3,40723,NULL,2,13,1,7000.00,'2022-11-11 13:09:02','2022-11-11 13:09:02',NULL),(6,8082,3,40723,NULL,2,480,2,7000.00,'2022-11-11 13:09:02','2022-11-11 13:09:02',NULL),(7,8082,4,40820,NULL,2,13,1,2000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(8,8082,4,40820,NULL,2,480,2,2000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(9,8082,5,40821,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(10,8082,5,40821,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(11,8082,6,40822,NULL,2,13,1,3000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(12,8082,6,40822,NULL,2,480,2,3000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(13,8082,7,40823,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(14,8082,7,40823,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(15,8082,8,40829,NULL,2,13,1,5000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(16,8082,8,40829,NULL,2,480,2,5000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(17,8082,9,40830,NULL,2,13,1,5000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(18,8082,9,40830,NULL,2,480,2,5000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(19,8082,10,40831,NULL,2,13,1,3000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(20,8082,10,40831,NULL,2,480,2,3000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(21,8082,11,40833,NULL,2,13,1,5000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(22,8082,11,40833,NULL,2,480,2,5000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(23,8082,12,40832,NULL,2,13,1,5000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(24,8082,12,40832,NULL,2,480,2,5000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(25,8082,13,40834,NULL,2,13,1,5000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(26,8082,13,40834,NULL,2,480,2,5000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(27,8082,14,40801,NULL,2,13,1,10000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(28,8082,14,40801,NULL,2,480,2,10000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(29,8082,15,40835,NULL,2,13,1,5000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(30,8082,15,40835,NULL,2,480,2,5000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(31,8082,16,40836,NULL,2,13,1,2000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(32,8082,16,40836,NULL,2,480,2,2000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(33,8082,17,40837,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(34,8082,17,40837,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(35,8082,18,40849,NULL,2,13,1,5000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(36,8082,18,40849,NULL,2,480,2,5000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(37,8082,19,40722,NULL,2,13,1,15000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(38,8082,19,40722,NULL,2,480,2,15000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(39,8082,20,40850,NULL,2,13,1,4000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(40,8082,20,40850,NULL,2,480,2,4000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(41,8082,21,40851,NULL,2,13,1,3000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(42,8082,21,40851,NULL,2,480,2,3000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(43,8082,22,40852,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(44,8082,22,40852,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(45,8082,23,40853,NULL,2,13,1,2000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL);
INSERT INTO `conta_asientos_details` VALUES (46,8082,23,40853,NULL,2,480,2,2000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(47,8082,24,40854,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(48,8082,24,40854,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(49,8082,25,40855,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(50,8082,25,40855,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(51,8082,26,40856,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(52,8082,26,40856,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(53,8082,27,40720,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(54,8082,27,40720,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(55,8082,28,40721,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(56,8082,28,40721,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(57,8082,29,40857,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(58,8082,29,40857,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(59,8082,30,40773,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(60,8082,30,40773,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(61,8082,31,40858,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(62,8082,31,40858,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(63,8082,32,40859,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(64,8082,32,40859,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(65,8082,33,40861,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(66,8082,33,40861,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(67,8082,34,40860,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(68,8082,34,40860,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(69,8082,35,40862,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(70,8082,35,40862,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(71,8082,36,40863,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(72,8082,36,40863,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(73,8082,37,40864,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(74,8082,37,40864,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(75,8082,38,40865,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(76,8082,38,40865,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(77,8082,39,40866,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(78,8082,39,40866,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(79,8082,40,40867,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(80,8082,40,40867,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(81,8082,41,40868,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(82,8082,41,40868,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(83,8082,42,40869,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(84,8082,42,40869,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(85,8082,43,40870,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(86,8082,43,40870,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(87,8082,44,40723,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(88,8082,44,40723,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(89,8082,45,40871,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(90,8082,45,40871,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL);
INSERT INTO `conta_asientos_details` VALUES (91,8082,46,40872,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(92,8082,46,40872,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(93,8082,47,40873,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(94,8082,47,40873,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(95,8082,48,40874,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(96,8082,48,40874,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(97,8082,49,40875,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(98,8082,49,40875,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(99,8082,50,40876,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(100,8082,50,40876,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(101,8082,51,40877,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(102,8082,51,40877,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(103,8082,52,40878,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(104,8082,52,40878,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(105,8082,53,40879,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(106,8082,53,40879,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(107,8082,54,40819,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(108,8082,54,40819,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(109,8082,55,40880,NULL,2,13,1,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(110,8082,55,40880,NULL,2,480,2,6000.00,'2023-02-09 20:02:26','2023-02-09 20:02:26',NULL),(111,8082,56,40881,NULL,2,13,1,2500.00,'2023-02-09 20:02:26','2023-02-28 10:19:38','2023-02-28 10:19:38'),(112,8082,56,40881,NULL,2,480,2,2500.00,'2023-02-09 20:02:26','2023-02-28 10:19:38','2023-02-28 10:19:38'),(113,8082,57,40881,NULL,2,13,1,2500.00,'2023-02-28 10:19:38','2023-02-28 10:19:38',NULL),(114,8082,57,40881,NULL,2,480,2,2500.00,'2023-02-28 10:19:38','2023-02-28 10:19:38',NULL);
/*!40000 ALTER TABLE `conta_asientos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costo_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_centro_costo_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costo_plan_cuenta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_centro_costo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` (`conta_centro_costo_id`),
  KEY `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` (`conta_plan_cuenta_id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` FOREIGN KEY (`conta_centro_costo_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` FOREIGN KEY (`conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costo_plan_cuenta`
--

LOCK TABLES `conta_centro_costo_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_centro_costo_plan_cuenta` VALUES (1,8082,1,392,NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costos`
--

DROP TABLE IF EXISTS `conta_centro_costos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costos_person_id_foreign` (`person_id`),
  CONSTRAINT `conta_centro_costos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costos`
--

LOCK TABLES `conta_centro_costos` WRITE;
/*!40000 ALTER TABLE `conta_centro_costos` DISABLE KEYS */;
INSERT INTO `conta_centro_costos` VALUES (1,8082,40720,'Ventas',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_centro_costos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_plan_cuenta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo` int(11) NOT NULL,
  `tipo_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `padre` int(11) NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rubro` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `no_editable` int(11) NOT NULL DEFAULT '1',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_plan_cuenta_tipo_cuenta_id_foreign` (`tipo_cuenta_id`),
  KEY `conta_plan_cuenta_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `conta_plan_cuenta_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_plan_cuenta_tipo_cuenta_id_foreign` FOREIGN KEY (`tipo_cuenta_id`) REFERENCES `conta_tipo_cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1433 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_plan_cuenta`
--

LOCK TABLES `conta_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_plan_cuenta` VALUES (1,NULL,1000000,1,1,0,'ACTIVO','Activo',NULL,1,1,0,0,0,0,NULL),(2,NULL,1100000,2,1,1000000,'ACTIVO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(3,NULL,1110000,3,1,1100000,'CAJA Y BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(4,NULL,1110100,4,1,1110000,'CAJAS','Activo',NULL,1,1,0,0,0,0,NULL),(5,NULL,1110101,5,1,1110100,'Caja Oficina','Activo',NULL,0,1,0,0,0,0,NULL),(6,NULL,1110102,5,1,1110100,'Caja Casa','Activo',NULL,0,1,0,0,0,0,NULL),(7,NULL,1110103,5,1,1110100,'Caja Dolares Casa','Activo',NULL,0,1,0,0,0,0,NULL),(8,NULL,1110104,5,1,1110100,'Banco Santander 015-372795/5','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(9,NULL,1110200,4,1,1110000,'BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(10,NULL,1110201,5,1,1110200,'Banco Santander Rio Cta Corriente','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(11,NULL,1110202,5,1,1110200,'Banco Santander Rio Cta Corriente DOLARES','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(12,NULL,1130000,3,1,1100000,'CREDITOS POR VENTAS','Activo',NULL,1,1,0,0,0,0,NULL),(13,NULL,1130101,5,1,1130100,'Clientes - Deudores','Activo',NULL,1,2,0,0,0,1,NULL),(14,NULL,1130102,5,1,1130100,'Deudores por ventas comunes','Activo',NULL,1,1,0,0,0,1,NULL),(15,NULL,1130103,5,1,1130100,'Deudores por ventas morosos','Activo',NULL,1,1,0,0,0,1,NULL),(16,NULL,1130104,5,1,1130100,'Deudores en gestión judicial','Activo',NULL,1,1,0,0,0,1,NULL),(17,NULL,1130105,5,1,1130100,'Previsión deudores incobrables','Activo',NULL,1,1,0,0,0,1,NULL),(18,NULL,1140000,3,1,1100000,'OTROS CREDITOS','Activo',NULL,1,1,0,0,0,0,NULL),(19,NULL,1140100,4,1,1140000,'Retenciones Sufridas','Activo',NULL,1,1,0,0,0,0,NULL),(20,NULL,1140301,5,1,1140300,'Anticipos Impuesto a las Ganancias','Activo',NULL,1,2,0,0,1,1,NULL),(21,NULL,1140102,5,1,1140100,'Retenciones Ingr. Brutos','Activo',NULL,0,1,0,0,0,0,NULL),(22,NULL,1140329,5,1,1140300,'Anticipo Impto.Ganancia Mínima Presunta','Activo',NULL,1,1,0,0,0,1,NULL),(23,NULL,1140105,5,1,1140100,'Retenciones Impuesto a las Ganancias','Activo',NULL,1,2,1,0,0,1,NULL),(24,NULL,1140106,5,1,1140100,'Impuesto a las Ganancias (Saldo a favor)','Activo',NULL,1,1,0,0,0,1,NULL),(25,NULL,1140107,5,1,1140100,'Retenciones de IVA','Activo',NULL,1,2,1,0,0,1,NULL),(26,NULL,1140200,4,1,1140000,'CREDITOS DIVERSOS','Activo',NULL,1,1,0,0,0,0,NULL),(27,NULL,1140201,5,1,1140200,'Anticipos de proveedores','Activo',NULL,1,1,0,0,0,1,NULL),(28,NULL,1140205,5,1,1140200,'Depósito en garantía alquileres','Activo',NULL,1,1,0,0,0,1,NULL),(29,NULL,1140206,5,1,1140200,'Derechos adquiridos a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(30,NULL,1140207,5,1,1140200,'Intereses a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(31,NULL,1140208,5,1,1140200,'Cuentas a rendir - Directores','Activo',NULL,1,1,0,0,0,1,NULL),(32,NULL,1140210,5,1,1140200,'Alquileres no devengados','Activo',NULL,1,1,0,0,0,1,NULL),(33,NULL,1150000,3,1,1100000,'BIENES DE CAMBIO','Activo',NULL,1,1,0,0,0,0,NULL),(34,NULL,1150400,4,1,1150000,'MERCADERIA DE REVENTA','Activo',NULL,1,1,0,0,0,0,NULL),(35,NULL,1200000,2,1,1000000,'ACTIVO NO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(36,NULL,1220000,3,1,1200000,'BIENES DE USO','Activo',NULL,1,1,0,0,0,0,NULL),(37,NULL,1220100,4,1,1220000,'EQUIPOS DE COMPUTACION','Activo',NULL,1,1,0,0,0,0,NULL),(38,NULL,1220101,5,1,1220100,'Equipos de computación valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(39,NULL,1220102,5,1,1220100,'Equipos de computación ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(40,NULL,1220108,5,1,1220100,'Amortización Acumulada Equipos de comput.','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(41,NULL,1220200,4,1,1220000,'INSTALACIONES','Activo',NULL,1,1,0,0,0,0,NULL),(42,NULL,1220201,5,1,1220200,'Instalaciones valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(43,NULL,1220202,5,1,1220200,'Instalaciones ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(44,NULL,1220206,5,1,1220200,'Amortización Acumulada Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(45,NULL,1220300,4,1,1220000,'MUEBLES Y UTILES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (46,NULL,1220301,5,1,1220300,'Muebles y utiles valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(47,NULL,1220302,5,1,1220300,'Muebles y utiles ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(48,NULL,1220306,5,1,1220300,'Amortización Acumulada Muebles y Útiles','Activo',NULL,1,1,0,0,0,1,NULL),(49,NULL,1230000,3,1,1200000,'ACTIVOS INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(50,NULL,1230101,5,1,1230100,'Gastos de organización valores historicos','Activo',NULL,1,1,0,0,0,1,NULL),(51,NULL,1230102,5,1,1230100,'Gastos de organización ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(52,NULL,1230103,5,1,1230100,'Amortización acumulada gs. de organización','Activo',NULL,1,1,0,0,0,1,NULL),(53,NULL,2000000,1,2,0,'PASIVO','Pasivo',NULL,1,1,0,0,0,0,NULL),(54,NULL,2100000,2,2,2000000,'PASIVO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(55,NULL,2110000,3,2,2100000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(56,NULL,2110100,4,2,2110000,'Comerciales','Pasivo',NULL,1,1,0,0,0,0,NULL),(57,NULL,2110101,5,2,2110100,'Proveedores en Cta. Cte. locales','Pasivo',NULL,1,2,0,0,0,1,NULL),(58,NULL,2110102,5,2,2110100,'Proveedores en cta. cte. exterior','Pasivo',NULL,1,1,0,0,0,1,NULL),(59,NULL,2110103,5,2,2110100,'Derechos de exhibición a devengar','Pasivo',NULL,1,1,0,0,0,1,NULL),(60,NULL,2110104,5,2,2110100,'Cheques emitidos ','Pasivo',NULL,1,2,1,1,1,1,NULL),(61,NULL,2110200,4,2,2110000,'REMUNERACIONES Y CARGAS SOCIALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(62,NULL,2110201,5,2,2110200,'Sueldos y Jornales a pagar','Pasivo',NULL,1,2,0,0,1,1,NULL),(63,NULL,2110202,5,2,2110200,'Cargas sociales a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(64,NULL,2110203,5,2,2110200,'Sindicatos a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(65,NULL,2110300,4,2,2110000,'CARGAS FISCALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(67,NULL,2110301,5,2,2110300,'IVA Debito Fiscal','Pasivo',NULL,1,2,0,0,0,1,NULL),(68,NULL,1140222,5,1,1140200,'IVA Credito Fiscal','Activo',NULL,1,2,0,0,0,1,NULL),(69,NULL,2110303,5,2,2110300,'Impuestos Internos','Pasivo',NULL,1,1,0,0,0,1,NULL),(70,NULL,2110304,5,2,2110300,'Impuestos al Combustible','Pasivo',NULL,1,1,0,0,0,1,NULL),(71,NULL,2110601,5,2,2110600,'IVA Retenciones de terceros','Pasivo',NULL,1,1,0,0,0,1,NULL),(72,NULL,2110306,5,2,2110300,'IVA Percepciones realiz.por terceros','Pasivo',NULL,1,2,0,0,0,1,NULL),(73,NULL,2110307,5,2,2110300,'IVA Saldo a favor','Pasivo',NULL,1,1,0,0,0,1,NULL),(74,NULL,2110308,5,2,2110300,'IVA a pagar','Pasivo',NULL,1,2,0,0,0,1,NULL),(75,NULL,2110309,5,2,2110300,'Percepciones Ingresos Brutos','Pasivo',NULL,1,1,0,0,0,1,NULL),(76,NULL,2110310,5,2,2110300,'Otros Pagos AFIP','Pasivo',NULL,1,1,0,0,0,1,NULL),(78,NULL,2110350,5,2,2110300,'Impuesto a los Ingresos Brutos Pasivo','Pasivo',NULL,1,1,0,0,0,1,NULL),(79,NULL,2110313,5,2,2110300,'Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(80,NULL,2110314,5,2,2110300,'Impuesto a la Ganancia Mínima Presunta','Pasivo',NULL,1,1,0,0,0,1,NULL),(81,NULL,2110602,5,2,2110600,'AFIP - Retenciones Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(82,NULL,2110316,5,2,2110300,'AFIP - Plan de Facilidades Decreto 338/02','Pasivo',NULL,1,1,0,0,0,1,NULL),(83,NULL,2200000,2,2,2000000,'PASIVO NO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(84,NULL,3000000,1,2,0,'PATRIMONIO NETO','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(85,NULL,3100000,2,2,3000000,'APORTE DE LOS PROPIETARIOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(86,NULL,3110100,4,2,3110000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(87,NULL,3110101,5,2,3110100,'Acciones en circulación','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(88,NULL,3110102,5,2,3110100,'Ajuste del Capital','Patrimonio Neto',NULL,1,2,0,0,0,1,NULL),(89,NULL,3110103,5,2,3110100,'Aportes Irrevocables Futuras Suscripciones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(90,NULL,3400000,2,2,3000000,'RESULTADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(91,NULL,3410101,5,2,3410100,'Resultado del ejercicio','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (92,NULL,3410102,5,2,3410100,'Resultado ejercicios anteriores','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(93,NULL,3410103,5,2,3410100,'A.R.E.A.','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(94,NULL,4000000,1,2,0,'INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(95,NULL,4100000,2,2,4000000,'INGRESOS ORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(96,NULL,4110101,5,2,4110100,'VENTAS','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(97,NULL,4110102,5,2,4110100,'Honorarios','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(98,NULL,4110103,5,2,4110100,'Sueldo Vane','Result. Positivo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(99,NULL,4110104,5,2,4110100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(100,NULL,4110105,5,2,4110100,'Reintegros por exportaciones','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(101,NULL,4120000,3,2,4100000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(102,NULL,4120101,5,2,4120100,'Intereses Cobrados','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(103,NULL,4120102,5,2,4120100,'Diferencias de cambio','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(104,NULL,4120103,5,2,4120100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(107,NULL,5000000,1,1,0,'GASTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(108,NULL,5100000,2,1,5000000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(109,NULL,5110100,4,1,5110000,'ASIENTO DE SUELDO','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(110,NULL,5110101,5,1,5110100,'Sueldos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(111,NULL,5110102,5,1,5110100,'Contribuciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(112,NULL,5110103,5,1,5110100,'Sindicato','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(113,NULL,5120100,4,1,5120000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(114,NULL,5120101,5,1,5120100,'ACA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(115,NULL,5120102,5,1,5120100,'Aereos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(116,NULL,5120103,5,1,5120100,'Alquiler','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(117,NULL,5120104,5,1,5120100,'AGUA AYSA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(118,NULL,5120105,5,1,5120100,'TV Cablevision','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(119,NULL,5120106,5,1,5120100,'Caja Jubilacion Consejo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(120,NULL,5120107,5,1,5120100,'Celulares','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(121,NULL,5120108,5,1,5120100,'Cheques','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(122,NULL,5120109,5,1,5120100,'Club la Nacion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(123,NULL,5120110,5,1,5120100,'Comida','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(124,NULL,5120111,5,1,5120100,'Diario Clarin','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(125,NULL,5120112,5,1,5120100,'Digital Ocean','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(126,NULL,5120113,5,1,5120100,'Fletes y acarreos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(127,NULL,5120114,5,1,5120100,'Luz Edesur','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(128,NULL,5120115,5,1,5120100,'Movilidad y Viáticos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(129,NULL,5120116,5,1,5120100,'Mantenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(130,NULL,5120117,5,1,5120100,'IVA No Computable','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(131,NULL,5120118,5,1,5120100,'Entretenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(132,NULL,5120119,5,1,5120100,'Amortización Bienes de Uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(133,NULL,5120120,5,1,5120100,'Errepar','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(134,NULL,5120121,5,1,5120100,'Hosting Página Web To Webs','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(135,NULL,5120122,5,1,5120100,'Gastos varios','Result. Negativo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (136,NULL,5120123,5,1,5120100,'Ajuste por redondeo','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(137,NULL,5120124,5,1,5120100,'Deudores Incobrables','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(138,NULL,5120125,5,1,5120100,'Faby Goncalves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(139,NULL,5130100,4,1,5130000,'GASTOS FINANCIEROS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(140,NULL,5130101,5,1,5130100,'Intereses y Gastos bancarios','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(141,NULL,5130102,5,1,5130100,'Intereses Proveedores','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(142,NULL,5130103,5,1,5130100,'Damian Financiera','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(143,NULL,5130104,5,1,5130100,'Diferencias de cambio','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(144,NULL,5130105,5,1,5130100,'Diferencia de Cambio Bces. en M.Extranjera','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(145,NULL,5130106,5,1,5130100,'Diferencia tipo cambio Vendedor/Comprador','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(146,NULL,5130107,5,1,5130100,'Diferencia por conversion en Bce. en Mon. Extranj.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(147,NULL,5130108,5,1,5130100,'Diferencia de cambio CMV','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(148,NULL,5130109,5,1,5130100,'Diferencia de cambio PT','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(149,NULL,5130110,5,1,5130100,'Resultado por Exposición a la Inflación','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(150,NULL,5130111,5,1,5130100,'Diferencia de cambio PE','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(151,NULL,5130112,5,1,5130100,'Diferencia de cambio Ds.Vtas.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(152,NULL,5130113,5,1,5130100,'Diferencia de cambio ME','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(153,NULL,5130114,5,1,5130100,'Descuentos otorgados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(154,NULL,5140100,4,1,5140000,'IMPUESTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(155,NULL,5140101,5,1,5140100,'Impuesto a las Ganancias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(156,NULL,5140164,5,1,5140100,'Impuesto a los Ingresos Brutos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(157,NULL,5140102,5,1,5140100,'Impuesto al Debito y Credito Bancario','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(158,NULL,5200000,2,1,5000000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(159,NULL,5210101,5,1,5210100,'Pérdida por venta bienes de uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(160,NULL,5210102,5,1,5210100,'Inversiones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(161,NULL,5210103,5,1,5210100,'Amortizaciones extraordinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(162,NULL,1140103,5,1,1140100,'Retenciones SUSS','Activo',NULL,1,2,1,0,0,1,NULL),(163,NULL,1110122,5,1,1110100,'Banco Patagonia Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(164,NULL,1110106,5,1,1110100,'Banco HSBC','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(165,NULL,1110123,5,1,1110100,'Banco Ciudad Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(166,NULL,1110124,5,1,1110100,'Banco Nacion Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(167,NULL,1110109,5,1,1110100,'Banco Galicia Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(168,NULL,1110110,5,1,1110100,'Banco Frances Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(169,NULL,1110111,5,1,1110100,'Banco Patagonia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(170,NULL,1110112,5,1,1110100,'Banco Ciudad In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(171,NULL,1110113,5,1,1110100,'Banco Provincia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(172,NULL,1110114,5,1,1110100,'Banco Macro PedimeOnline','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(173,NULL,1110115,5,1,1110100,'Banco Patagonia Problema Resuelto','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (174,NULL,1110116,5,1,1110100,'Banco Patagonia Graciela','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(175,NULL,1110117,5,1,1110100,'Banco Patagonia Omar','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(176,NULL,1110118,5,1,1110100,'Cheques','Activo',NULL,1,2,1,1,1,0,NULL),(177,NULL,5120126,5,1,5120100,'Gisela Larzabal','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(178,NULL,5120127,5,1,5120100,'Google','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(179,NULL,5120128,5,1,5120100,'Seguro Moto','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(180,NULL,5120129,5,1,5120100,'Sueldo Agustina','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(181,NULL,5120130,5,1,5120100,'Sueldo Betty','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(182,NULL,5120131,5,1,5120100,'Sueldo Elizabet','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(183,NULL,5120132,5,1,5120100,'Sueldo Florencia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(184,NULL,5120133,5,1,5120100,'Sueldo Graciela','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(185,NULL,5120134,5,1,5120100,'Sueldo Franco Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(186,NULL,5120135,5,1,5120100,'Sueldo Santiago Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(187,NULL,5120136,5,1,5120100,'Sueldo Jose Luis','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(188,NULL,5120137,5,1,5120100,'Publicidad','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(189,NULL,5120138,5,1,5120100,'Las Nieves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(190,NULL,5120139,5,1,5120100,'Sueldo Lidia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(191,NULL,5120140,5,1,5120100,'Cargas Sociales','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(192,NULL,5120141,5,1,5120100,'Honorarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(193,NULL,5120142,5,1,5120100,'Telefono Fijo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(194,NULL,5120143,5,1,5120100,'ONE DRIVE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(195,NULL,5120144,5,1,5120100,'OSDE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(196,NULL,5120145,5,1,5120100,'SAS Constitucion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(197,NULL,5120146,5,1,5120100,'Seguro de Vida Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(198,NULL,5120147,5,1,5120100,'Seguros','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(199,NULL,5120148,5,1,5120100,'Internet','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(200,NULL,5120149,5,1,5120100,'Seguro de Retiro Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(201,NULL,5140165,5,1,5140100,'Monotributo','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(202,NULL,5140104,5,1,5140100,'IVA In Time SRL','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(203,NULL,5140105,5,1,5140100,'Autonomos','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(204,NULL,5140106,5,1,5140100,'Multas Impositivas','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(207,NULL,5120150,5,1,5120100,'Vanesa Gastos','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(208,NULL,5140166,5,1,5140100,'Impuesto a los Ingresos Brutos - BS AS','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(209,NULL,5140107,5,1,5140100,'SIRCREB','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(210,NULL,5140108,5,1,5140100,'Consejo Ciencias Economicas','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(211,NULL,5120152,5,1,5120100,'Albano Andres','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(212,NULL,5120153,5,1,5120100,'Tarjeta Visa','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(213,NULL,5120154,5,1,5120100,'Tarjeta American Express','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(214,NULL,5120155,5,1,5120100,'Tarjeta Mastercard','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(215,NULL,5120156,5,1,5120100,'Imp. Municipales Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (216,NULL,5120157,5,1,5120100,'Perc/Ret. Imp. Ganancias Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(217,NULL,5120158,5,1,5120100,'Compras','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(218,NULL,4110106,5,2,4110100,'Ventas No Gravadas','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(219,NULL,6110103,5,1,6110100,'Pagos AFIP','Movimiento',NULL,1,2,0,0,1,1,NULL),(220,NULL,5140167,5,1,5140100,'Perc IVA -RG3337 Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(221,NULL,5140109,5,1,5140100,'Imps. Internos Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(222,NULL,5140110,5,1,5140100,'Imp. Gasoil Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(223,NULL,5140111,5,1,5140100,'Imp. Hídricos Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(224,NULL,5140112,5,1,5140100,'ITC Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(225,NULL,5140113,5,1,5140100,'Perc IIBB  Buenos Aires Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(226,NULL,5140114,5,1,5140100,'Perc IIBB  Capital Federal Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(227,NULL,5140115,5,1,5140100,'Perc IIBB  Catamarca Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(228,NULL,5140116,5,1,5140100,'Perc IIBB  Chaco Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(229,NULL,5140117,5,1,5140100,'Perc IIBB  Chubut Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(230,NULL,5140118,5,1,5140100,'Perc IIBB  Córdoba Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(231,NULL,5140119,5,1,5140100,'Perc IIBB  Corrientes Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(232,NULL,5140120,5,1,5140100,'Perc IIBB  Entre Ríos Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(233,NULL,5140121,5,1,5140100,'Perc IIBB  Formosa Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(234,NULL,5140122,5,1,5140100,'Perc IIBB  Jujuy Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(235,NULL,5140123,5,1,5140100,'Perc IIBB  La Pampa Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(236,NULL,5140124,5,1,5140100,'Perc IIBB  La Rioja Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(237,NULL,5140125,5,1,5140100,'Perc IIBB  Mendoza Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(238,NULL,5140126,5,1,5140100,'Perc IIBB  Misiones Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(239,NULL,5140127,5,1,5140100,'Perc IIBB  Neuquén Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(240,NULL,5140128,5,1,5140100,'Perc IIBB  Pascua Lama Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(241,NULL,5140129,5,1,5140100,'Perc IIBB  Río Negro Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(242,NULL,5140130,5,1,5140100,'Perc IIBB  Salta Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(243,NULL,5140131,5,1,5140100,'Perc IIBB  San Juan Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(244,NULL,5140132,5,1,5140100,'Perc IIBB  San Luis Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(245,NULL,5140133,5,1,5140100,'Perc IIBB  Santa Cruz Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(246,NULL,5140134,5,1,5140100,'Perc IIBB  Santa Fe Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(247,NULL,5140135,5,1,5140100,'Perc IIBB  Santiago del Estero Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(248,NULL,5140136,5,1,5140100,'Perc IIBB  Tierra del Fuego Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(249,NULL,5140137,5,1,5140100,'Perc IIBB  Tucuman Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(250,NULL,5140138,5,1,5140100,'Compras No Gravadas','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(251,NULL,1140108,5,1,1140100,'Retenciones de IIBB Buenos Aires','Activo',NULL,1,2,1,0,0,1,NULL),(252,NULL,1140109,5,1,1140100,'Retenciones de IIBB Capital Federal','Activo',NULL,1,2,1,0,0,1,NULL),(253,NULL,1140110,5,1,1140100,'Retenciones de IIBB Catamarca','Activo',NULL,1,2,1,0,0,1,NULL),(254,NULL,1140111,5,1,1140100,'Retenciones de IIBB Chaco','Activo',NULL,1,2,1,0,0,1,NULL),(255,NULL,1140112,5,1,1140100,'Retenciones de IIBB Chubut','Activo',NULL,1,2,1,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (256,NULL,1140113,5,1,1140100,'Retenciones de IIBB Córdoba','Activo',NULL,1,2,1,0,0,1,NULL),(257,NULL,1140114,5,1,1140100,'Retenciones de IIBB Corrientes','Activo',NULL,1,2,1,0,0,1,NULL),(258,NULL,1140115,5,1,1140100,'Retenciones de IIBB Entre Ríos','Activo',NULL,1,2,1,0,0,1,NULL),(259,NULL,1140116,5,1,1140100,'Retenciones de IIBB Formosa','Activo',NULL,1,2,1,0,0,1,NULL),(260,NULL,1140117,5,1,1140100,'Retenciones de IIBB Jujuy','Activo',NULL,1,2,1,0,0,1,NULL),(261,NULL,1140118,5,1,1140100,'Retenciones de IIBB La Pampa','Activo',NULL,1,2,1,0,0,1,NULL),(262,NULL,1140119,5,1,1140100,'Retenciones de IIBB La Rioja','Activo',NULL,1,2,1,0,0,1,NULL),(263,NULL,1140120,5,1,1140100,'Retenciones de IIBB Mendoza','Activo',NULL,1,2,1,0,0,1,NULL),(264,NULL,1140121,5,1,1140100,'Retenciones de IIBB Misiones','Activo',NULL,1,2,1,0,0,1,NULL),(265,NULL,1140122,5,1,1140100,'Retenciones de IIBB Neuquén','Activo',NULL,1,2,1,0,0,1,NULL),(266,NULL,1140123,5,1,1140100,'Retenciones de IIBB Pascua Lama','Activo',NULL,1,2,1,0,0,1,NULL),(267,NULL,1140124,5,1,1140100,'Retenciones de IIBB Río Negro','Activo',NULL,1,2,1,0,0,1,NULL),(268,NULL,1140125,5,1,1140100,'Retenciones de IIBB Salta','Activo',NULL,1,2,1,0,0,1,NULL),(269,NULL,1140126,5,1,1140100,'Retenciones de IIBB San Juan','Activo',NULL,1,2,1,0,0,1,NULL),(270,NULL,1140127,5,1,1140100,'Retenciones de IIBB San Luis','Activo',NULL,1,2,1,0,0,1,NULL),(271,NULL,1140128,5,1,1140100,'Retenciones de IIBB Santa Cruz','Activo',NULL,1,2,1,0,0,1,NULL),(272,NULL,1140129,5,1,1140100,'Retenciones de IIBB Santa Fe','Activo',NULL,1,2,1,0,0,1,NULL),(273,NULL,1140130,5,1,1140100,'Retenciones de IIBB Santiago del Estero','Activo',NULL,1,2,1,0,0,1,NULL),(274,NULL,1140131,5,1,1140100,'Retenciones de IIBB Tierra del Fuego','Activo',NULL,1,2,1,0,0,1,NULL),(275,NULL,1140132,5,1,1140100,'Retenciones de IIBB Tucuman','Activo',NULL,1,2,1,0,0,1,NULL),(276,NULL,5140168,5,1,5140100,'SIRCREB Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(277,NULL,5140139,5,1,5140100,'SIRCREB Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(278,NULL,5140140,5,1,5140100,'SIRCREB Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(279,NULL,5140141,5,1,5140100,'SIRCREB Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(280,NULL,5140142,5,1,5140100,'SIRCREB Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(281,NULL,5140143,5,1,5140100,'SIRCREB Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(282,NULL,5140144,5,1,5140100,'SIRCREB Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(283,NULL,5140145,5,1,5140100,'SIRCREB Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(284,NULL,5140146,5,1,5140100,'SIRCREB Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(285,NULL,5140147,5,1,5140100,'SIRCREB Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(286,NULL,5140148,5,1,5140100,'SIRCREB La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(287,NULL,5140149,5,1,5140100,'SIRCREB La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(288,NULL,5140150,5,1,5140100,'SIRCREB Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(289,NULL,5140151,5,1,5140100,'SIRCREB Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(290,NULL,5140152,5,1,5140100,'SIRCREB Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(291,NULL,5140153,5,1,5140100,'SIRCREB Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(292,NULL,5140154,5,1,5140100,'SIRCREB Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(293,NULL,5140155,5,1,5140100,'SIRCREB Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(294,NULL,5140156,5,1,5140100,'SIRCREB San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(295,NULL,5140157,5,1,5140100,'SIRCREB San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(296,NULL,5140158,5,1,5140100,'SIRCREB Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(297,NULL,5140159,5,1,5140100,'SIRCREB Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(298,NULL,5140160,5,1,5140100,'SIRCREB Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (299,NULL,5140161,5,1,5140100,'SIRCREB Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(300,NULL,5140162,5,1,5140100,'SIRCREB Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(301,NULL,1140326,5,1,1140300,'IIBB a Favor Buenos Aires','Activo',NULL,1,2,0,0,0,1,NULL),(302,NULL,1140302,5,1,1140300,'IIBB a Favor Capital Federal','Activo',NULL,1,2,0,0,0,1,NULL),(303,NULL,1140303,5,1,1140300,'IIBB a Favor Catamarca','Activo',NULL,1,2,0,0,0,1,NULL),(304,NULL,1140304,5,1,1140300,'IIBB a Favor Chaco','Activo',NULL,1,2,0,0,0,1,NULL),(305,NULL,1140305,5,1,1140300,'IIBB a Favor Chubut','Activo',NULL,1,2,0,0,0,1,NULL),(306,NULL,1140306,5,1,1140300,'IIBB a Favor Córdoba','Activo',NULL,1,2,0,0,0,1,NULL),(307,NULL,1140307,5,1,1140300,'IIBB a Favor Corrientes','Activo',NULL,1,2,0,0,0,1,NULL),(308,NULL,1140308,5,1,1140300,'IIBB a Favor Entre Ríos','Activo',NULL,1,2,0,0,0,1,NULL),(309,NULL,1140309,5,1,1140300,'IIBB a Favor Formosa','Activo',NULL,1,2,0,0,0,1,NULL),(310,NULL,1140310,5,1,1140300,'IIBB a Favor Jujuy','Activo',NULL,1,2,0,0,0,1,NULL),(311,NULL,1140311,5,1,1140300,'IIBB a Favor La Pampa','Activo',NULL,1,2,0,0,0,1,NULL),(312,NULL,1140312,5,1,1140300,'IIBB a Favor La Rioja','Activo',NULL,1,2,0,0,0,1,NULL),(313,NULL,1140313,5,1,1140300,'IIBB a Favor Mendoza','Activo',NULL,1,2,0,0,0,1,NULL),(314,NULL,1140314,5,1,1140300,'IIBB a Favor Misiones','Activo',NULL,1,2,0,0,0,1,NULL),(315,NULL,1140315,5,1,1140300,'IIBB a Favor Neuquén','Activo',NULL,1,2,0,0,0,1,NULL),(316,NULL,1140316,5,1,1140300,'IIBB a Favor Pascua Lama','Activo',NULL,1,2,0,0,0,1,NULL),(317,NULL,1140317,5,1,1140300,'IIBB a Favor Río Negro','Activo',NULL,1,2,0,0,0,1,NULL),(318,NULL,1140318,5,1,1140300,'IIBB a Favor Salta','Activo',NULL,1,2,0,0,0,1,NULL),(319,NULL,1140319,5,1,1140300,'IIBB a Favor San Juan','Activo',NULL,1,2,0,0,0,1,NULL),(320,NULL,1140320,5,1,1140300,'IIBB a Favor San Luis','Activo',NULL,1,2,0,0,0,1,NULL),(321,NULL,1140321,5,1,1140300,'IIBB a Favor Santa Cruz','Activo',NULL,1,2,0,0,0,1,NULL),(322,NULL,1140322,5,1,1140300,'IIBB a Favor Santa Fe','Activo',NULL,1,2,0,0,0,1,NULL),(323,NULL,1140323,5,1,1140300,'IIBB a Favor Santiago del Estero','Activo',NULL,1,2,0,0,0,1,NULL),(324,NULL,1140324,5,1,1140300,'IIBB a Favor Tierra del Fuego','Activo',NULL,1,2,0,0,0,1,NULL),(325,NULL,1140325,5,1,1140300,'IIBB a Favor Tucuman','Activo',NULL,1,2,0,0,0,1,NULL),(326,NULL,2110317,5,2,2110300,'IIBB a Pagar Buenos Aires','Pasivo',NULL,1,2,0,0,0,1,NULL),(327,NULL,2110318,5,2,2110300,'IIBB a Pagar Capital Federal','Pasivo',NULL,1,2,0,0,0,1,NULL),(328,NULL,2110319,5,2,2110300,'IIBB a Pagar Catamarca','Pasivo',NULL,1,2,0,0,0,1,NULL),(329,NULL,2110320,5,2,2110300,'IIBB a Pagar Chaco','Pasivo',NULL,1,2,0,0,0,1,NULL),(330,NULL,2110321,5,2,2110300,'IIBB a Pagar Chubut','Pasivo',NULL,1,2,0,0,0,1,NULL),(331,NULL,2110322,5,2,2110300,'IIBB a Pagar Córdoba','Pasivo',NULL,1,2,0,0,0,1,NULL),(332,NULL,2110323,5,2,2110300,'IIBB a Pagar Corrientes','Pasivo',NULL,1,2,0,0,0,1,NULL),(333,NULL,2110324,5,2,2110300,'IIBB a Pagar Entre Ríos','Pasivo',NULL,1,2,0,0,0,1,NULL),(334,NULL,2110325,5,2,2110300,'IIBB a Pagar Formosa','Pasivo',NULL,1,2,0,0,0,1,NULL),(335,NULL,2110326,5,2,2110300,'IIBB a Pagar Jujuy','Pasivo',NULL,1,2,0,0,0,1,NULL),(336,NULL,2110327,5,2,2110300,'IIBB a Pagar La Pampa','Pasivo',NULL,1,2,0,0,0,1,NULL),(337,NULL,2110328,5,2,2110300,'IIBB a Pagar La Rioja','Pasivo',NULL,1,2,0,0,0,1,NULL),(338,NULL,2110329,5,2,2110300,'IIBB a Pagar Mendoza','Pasivo',NULL,1,2,0,0,0,1,NULL),(339,NULL,2110330,5,2,2110300,'IIBB a Pagar Misiones','Pasivo',NULL,1,2,0,0,0,1,NULL),(340,NULL,2110331,5,2,2110300,'IIBB a Pagar Neuquén','Pasivo',NULL,1,2,0,0,0,1,NULL),(341,NULL,2110332,5,2,2110300,'IIBB a Pagar Pascua Lama','Pasivo',NULL,1,2,0,0,0,1,NULL),(342,NULL,2110333,5,2,2110300,'IIBB a Pagar Río Negro','Pasivo',NULL,1,2,0,0,0,1,NULL),(343,NULL,2110334,5,2,2110300,'IIBB a Pagar Salta','Pasivo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (344,NULL,2110335,5,2,2110300,'IIBB a Pagar San Juan','Pasivo',NULL,1,2,0,0,0,1,NULL),(345,NULL,2110336,5,2,2110300,'IIBB a Pagar San Luis','Pasivo',NULL,1,2,0,0,0,1,NULL),(346,NULL,2110337,5,2,2110300,'IIBB a Pagar Santa Cruz','Pasivo',NULL,1,2,0,0,0,1,NULL),(347,NULL,2110338,5,2,2110300,'IIBB a Pagar Santa Fe','Pasivo',NULL,1,2,0,0,0,1,NULL),(348,NULL,2110339,5,2,2110300,'IIBB a Pagar Santiago del Estero','Pasivo',NULL,1,2,0,0,0,1,NULL),(349,NULL,2110340,5,2,2110300,'IIBB a Pagar Tierra del Fuego','Pasivo',NULL,1,2,0,0,0,1,NULL),(350,NULL,2110341,5,2,2110300,'IIBB a Pagar Tucuman','Pasivo',NULL,1,2,0,0,0,1,NULL),(351,NULL,6110101,5,1,6110100,'BANCO SIRCREB','Movimiento',NULL,1,2,0,0,1,1,NULL),(352,NULL,6110102,5,1,6110100,'Compensacion','Movimiento',NULL,1,2,0,0,0,1,NULL),(353,NULL,1140327,5,1,1140300,'IVA Saldo Tecnico','Activo',NULL,1,2,0,0,0,1,NULL),(354,NULL,1140328,5,1,1140300,'IVA Saldo Libre Disponibilidad','Activo',NULL,1,2,0,0,0,1,NULL),(355,NULL,6000000,1,1,0,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(356,NULL,6100000,2,1,6000000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(357,NULL,6110000,3,1,6100000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(358,NULL,4110000,3,2,4100000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(359,NULL,1110120,5,1,1110100,'Caja en Pesos','Activo',NULL,1,2,1,1,1,0,NULL),(360,NULL,1140211,5,1,1140200,'Retenciones Bancarias de Ganancias a Favor','Activo',NULL,1,2,0,0,1,1,NULL),(361,NULL,1220104,5,1,1220100,'Equipos de Computación','Activo',NULL,1,1,0,0,0,1,NULL),(362,NULL,1220105,5,1,1220100,'Computadoras','Activo',NULL,1,1,0,0,0,1,NULL),(363,NULL,1220304,5,1,1220300,'Muebles y Utiles','Activo',NULL,1,1,0,0,0,1,NULL),(364,NULL,2110105,5,2,2110100,'Anticipo de Clientes','Pasivo',NULL,1,2,0,0,1,1,NULL),(365,NULL,2110401,5,2,2110400,'Provision Honorarios','Pasivo',NULL,1,1,0,0,0,1,NULL),(366,NULL,2110106,5,2,2110100,'Cta. Cte Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(367,NULL,2110107,5,2,2110100,'Provisión Honorarios Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(368,NULL,2110110,5,2,2110100,'Cuenta Particular Socio 1','Pasivo',NULL,1,1,0,0,0,1,NULL),(369,NULL,3110104,5,2,3110100,'Capital','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(370,NULL,1120000,3,1,1100000,'INVERSIONES','Activo',NULL,1,1,0,0,0,0,NULL),(371,NULL,1160000,3,1,1100000,'OTROS ACTIVOS','Activo',NULL,1,1,0,0,0,0,NULL),(372,NULL,1160100,4,1,1160000,'OTROS','Activo',NULL,1,1,0,0,0,0,NULL),(373,NULL,2110400,4,2,2110000,'Provision de Honorarios','Pasivo',NULL,1,1,0,0,0,0,NULL),(374,NULL,3410100,4,1,3410000,'RESULTADOS ACUMULADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(375,NULL,3420000,3,1,3400000,'GANACIAS RESERVADAS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(376,NULL,3420100,4,1,3420000,'Rerva Legal','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(377,NULL,1220400,4,1,1220000,'INMUEBLES','Activo',NULL,1,1,0,0,0,0,NULL),(378,NULL,1220500,4,1,1220000,'RODADOS','Activo',NULL,1,1,0,0,0,0,NULL),(379,NULL,1220600,4,1,1220000,'MAQUINARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(380,NULL,1220204,5,1,1220200,'Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(381,NULL,3420101,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(382,NULL,3420102,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(383,NULL,3410105,5,2,3410100,'Resultado no asignado','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(384,NULL,1110121,5,1,1110100,'Caja en Dolares','Activo',NULL,1,2,1,1,1,0,NULL),(385,NULL,1120100,4,1,1120000,'TEMPORARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(386,NULL,1120101,5,1,1120100,'PLAZO FIJO','Activo',NULL,1,1,0,0,0,1,NULL),(387,NULL,1120200,4,1,1120000,'PERMANENTES','Activo',NULL,1,1,0,0,0,0,NULL),(388,NULL,1120201,5,1,1120200,'ACCIONES','Activo',NULL,1,1,0,0,0,1,NULL),(389,NULL,1220401,5,1,1220400,'Inmuebles','Activo',NULL,1,1,0,0,0,1,NULL),(390,NULL,1220501,5,1,1220500,'Vehiculos','Activo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (391,NULL,1220601,5,1,1220600,'Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(392,NULL,1150401,5,1,1150400,'MERCADERIAS','Activo',NULL,1,1,0,0,0,1,NULL),(393,NULL,1160101,5,1,1160100,'OTROS','Activo',NULL,1,1,0,0,0,1,NULL),(394,NULL,1230100,4,1,1230000,'INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(395,NULL,2110119,5,2,2110100,'Cuenta Particular Socio 2','Pasivo',NULL,1,1,0,0,0,1,NULL),(396,NULL,5120160,5,1,5120100,'Comisiones Y gastos Bancarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(397,NULL,4110100,4,2,4110000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(398,NULL,4120100,4,2,4120000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(399,NULL,5110000,3,1,5100000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(400,NULL,5120000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(401,NULL,5130000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(402,NULL,5140000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(403,NULL,5210000,3,1,5200000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(404,NULL,5210100,4,1,5210000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(405,NULL,6110100,4,1,6110000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(406,NULL,1130100,4,1,1130000,'Operaciones Ordinarias','Activo',NULL,1,1,0,0,0,0,NULL),(407,NULL,3110000,3,2,3100000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(408,NULL,3410000,3,2,3400000,'RESULTADOS ANTERIORES','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(409,NULL,5110101,5,2,5110000,'IVA Crédito Fiscal No computable','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(410,NULL,1110203,5,1,1110200,'Banco ICBC Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(411,NULL,2110342,5,2,2110300,'Provisión Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(412,NULL,5120107,5,2,5120000,'Amortización Muebles y Útiles','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(413,NULL,5120102,5,2,5120000,'Amortización Equipos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(414,NULL,1220109,5,1,1220100,'Amortizacion Acumulada Equipos','Activo',NULL,1,1,0,0,0,1,NULL),(415,NULL,1220602,5,1,1220600,'Amortización Acumulada Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(416,NULL,1160102,5,1,1160100,'Materias Primas','Activo',NULL,1,1,0,0,0,1,NULL),(417,NULL,1110204,5,1,1110200,'Banco Itaú Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(418,NULL,2110113,5,2,2110100,'Deudas Bancarias','Pasivo',NULL,1,2,0,1,1,1,NULL),(419,NULL,1220502,5,1,1220500,'Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(420,NULL,1220503,5,1,1220500,'Amortización Acumulada Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(421,NULL,5120105,5,2,5120000,'Amortización Rodados','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(422,NULL,5120109,5,2,5120000,'Amortización Maquinarias','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(423,NULL,1220504,5,1,1220500,'Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(424,NULL,1220505,5,1,1220500,'Amortización Acumulada Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(425,NULL,1110205,5,1,1110200,'Banco Galicia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(426,NULL,3420101,5,2,3420000,'Reserva Facultativa','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(427,NULL,1140212,5,1,1140200,'Créditos por Impuestos Diferidos','Activo',NULL,1,1,0,0,0,1,NULL),(428,NULL,1160103,5,1,1160100,'Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(429,NULL,1160104,5,1,1160100,'Amortizacion Acumulada Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(430,NULL,1140213,5,1,1140200,'Intereses a devengar AGIP','Activo',NULL,1,1,0,0,0,1,NULL),(431,NULL,2110343,5,2,2110300,'PFP IIBB','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(432,NULL,1140330,5,1,1140300,'Pago a Cuenta ITC','Activo',NULL,1,2,0,0,0,1,NULL),(433,NULL,2110114,5,2,2110100,'Préstamo','Pasivo',NULL,1,2,0,1,1,1,NULL),(434,NULL,1160106,5,1,1160100,'Productos','Activo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (435,NULL,2110345,5,2,2110300,'Intereses a devengar PFP','Pasivo',NULL,1,1,0,0,0,1,NULL),(436,NULL,1110206,5,1,1110200,'Banco Provincia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(437,NULL,1140215,5,1,1140200,'Imp. Ley 25413 Cred 0.6%','Activo',NULL,1,1,0,0,0,1,NULL),(438,NULL,2110402,5,2,2110400,'Honorarios Directorio a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(439,NULL,3110101,5,2,3110100,'Reserva para Futuras Inversiones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(440,NULL,1130106,5,1,1130100,'TEAC - Trabajos Ejecutados a Certificar','Activo',NULL,1,1,0,0,0,1,NULL),(441,NULL,2110115,5,2,2110100,'Leasing','Pasivo',NULL,1,2,0,1,1,1,NULL),(442,NULL,1110207,5,1,1110200,'Banco Comafi Cta. Cte','Activo',NULL,1,2,1,1,1,0,NULL),(443,NULL,2110500,4,2,2110000,'Deudas Financieras','Pasivo',NULL,1,1,0,0,0,0,NULL),(444,NULL,2110501,5,2,2110500,'Banco Santander Rio Cta Cte','Pasivo',NULL,1,1,0,0,0,1,NULL),(446,NULL,2210000,3,2,2200000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(447,NULL,2210100,4,2,2210000,'Otras Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(448,NULL,2210101,5,2,2210100,'Planes de Pagos AFIP','Pasivo',NULL,1,2,0,1,1,1,NULL),(449,NULL,2110502,5,2,2110500,'Leasing','Pasivo',NULL,1,1,0,0,0,1,NULL),(450,NULL,6110101,5,1,6110000,'Cheques Rechazados','Movimiento',NULL,1,2,0,0,1,1,NULL),(451,NULL,1110208,5,1,1110200,'Banco Patagonia Taxes Software','Activo',NULL,1,2,1,1,1,0,NULL),(452,NULL,1110209,5,1,1110200,'Banco Macro Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(453,NULL,1120202,5,1,1120200,'Inversión Central Caribe','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(454,NULL,1120102,5,1,1120100,'Otras Inversiones','Activo',NULL,1,1,0,0,0,1,NULL),(455,NULL,1140216,5,1,1140200,'Otros Créditos','Activo',NULL,1,1,0,0,0,1,NULL),(456,NULL,2110403,5,2,2110400,'Provisión Honorarios Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(457,NULL,1110210,5,1,1110200,'Cheque Diferido Banco Santander Rio','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(458,NULL,1110211,5,1,1110200,'Cheque Diferido Banco Macro','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(459,NULL,2110204,5,2,2110200,'Moratoria SUSS a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(460,NULL,2110344,5,2,2110300,'Impuestos Municipales a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(461,NULL,5110103,5,2,5110000,'Amortización Instalaciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(462,NULL,5120110,5,2,5120000,'Amortización Equipos de comput.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(463,NULL,2110118,5,2,2110100,'Cuenta Particular Socio 3','Pasivo',NULL,1,1,0,0,0,1,NULL),(464,NULL,2110120,5,2,2110100,'Cuenta Particular Socio 4','Pasivo',NULL,1,1,0,0,0,1,NULL),(465,NULL,3110102,5,2,3110100,'Otras Reservas','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(466,NULL,1140331,5,1,1140300,'IGMP (Saldo a Favor)','Activo',NULL,1,1,0,0,0,1,NULL),(467,NULL,5110104,5,2,5110000,'Interés','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(468,NULL,1150402,5,1,1150400,'Productos en Proceso','Activo',NULL,1,1,0,0,0,1,NULL),(469,NULL,2110205,5,2,2110200,'Depósitos en Garantía Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(470,NULL,2110346,5,2,2110300,'Fondos Embargados','Pasivo',NULL,1,1,0,0,0,1,NULL),(471,NULL,2110347,5,2,2110300,'Cuota Solid.','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(472,NULL,1140332,5,1,1140300,'Anticipo Honorarios Directores','Activo',NULL,1,1,0,0,0,1,NULL),(473,NULL,2110348,5,2,2110300,'SICORE a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(474,NULL,1110212,5,1,1110200,'Banco Credicoop Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(475,NULL,1110213,5,1,1110200,'Banco Superville Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(476,NULL,5110105,5,2,5110000,'RECPAM','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(477,NULL,1110125,5,1,1110100,'Caja Reales','Activo',NULL,1,2,1,1,1,0,NULL),(478,NULL,5140169,5,1,5140100,'CO2 - Imp. Al Carbono Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(479,NULL,1140300,4,1,1140000,'Anticipo de Impuestos','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (480,NULL,2110600,4,2,2110000,'Retenciones Efectuadas','Pasivo',NULL,1,1,0,0,0,0,NULL),(481,NULL,4200000,2,2,4000000,'INGRESOS EXTRAORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(1001,NULL,5140170,5,1,5140100,'SIRTAC Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1002,NULL,5140171,5,1,5140100,'SIRTAC Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1003,NULL,5140172,5,1,5140100,'SIRTAC Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1004,NULL,5140173,5,1,5140100,'SIRTAC Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1005,NULL,5140174,5,1,5140100,'SIRTAC Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1006,NULL,5140175,5,1,5140100,'SIRTAC Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1007,NULL,5140176,5,1,5140100,'SIRTAC Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1008,NULL,5140177,5,1,5140100,'SIRTAC La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1009,NULL,5140178,5,1,5140100,'SIRTAC La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1010,NULL,5140179,5,1,5140100,'SIRTAC Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1011,NULL,5140180,5,1,5140100,'SIRTAC Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1012,NULL,5140181,5,1,5140100,'SIRTAC Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1013,NULL,5140182,5,1,5140100,'SIRTAC Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1014,NULL,5140183,5,1,5140100,'SIRTAC Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1015,NULL,5140184,5,1,5140100,'SIRTAC San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1016,NULL,5140185,5,1,5140100,'SIRTAC San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1017,NULL,5140186,5,1,5140100,'SIRTAC Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1018,NULL,5140187,5,1,5140100,'SIRTAC Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1019,NULL,5140188,5,1,5140100,'SIRTAC Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1020,NULL,5140189,5,1,5140100,'SIRTAC Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1021,NULL,5140190,5,1,5140100,'SIRTAC Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1022,NULL,5140191,5,1,5140100,'SIRTAC Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1023,NULL,5140192,5,1,5140100,'SIRTAC Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1024,NULL,5140193,5,1,5140100,'SIRTAC Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1025,NULL,5140194,5,1,5140100,'SIRTAC Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1026,NULL,6110104,5,1,6110100,'BANCO SIRTAC','Movimiento',NULL,1,2,0,0,1,1,NULL),(1400,NULL,5140267,5,1,5140100,'Perc IVA -RG3337 Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1401,NULL,5140209,5,1,5140100,'Imps. Internos Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1402,NULL,5140210,5,1,5140100,'Imp. Gasoil Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1403,NULL,5140211,5,1,5140100,'Imp. Hídricos Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1404,NULL,5140212,5,1,5140100,'ITC Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1405,NULL,5140213,5,1,5140100,'Perc IIBB  Buenos Aires Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1406,NULL,5140214,5,1,5140100,'Perc IIBB  Capital Federal Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1407,NULL,5140215,5,1,5140100,'Perc IIBB  Catamarca Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1408,NULL,5140216,5,1,5140100,'Perc IIBB  Chaco Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1409,NULL,5140217,5,1,5140100,'Perc IIBB  Chubut Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1410,NULL,5140218,5,1,5140100,'Perc IIBB  Córdoba Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1411,NULL,5140219,5,1,5140100,'Perc IIBB  Corrientes Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1412,NULL,5140220,5,1,5140100,'Perc IIBB  Entre Ríos Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (1413,NULL,5140221,5,1,5140100,'Perc IIBB  Formosa Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1414,NULL,5140222,5,1,5140100,'Perc IIBB  Jujuy Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1415,NULL,5140223,5,1,5140100,'Perc IIBB  La Pampa Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1416,NULL,5140224,5,1,5140100,'Perc IIBB  La Rioja Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1417,NULL,5140225,5,1,5140100,'Perc IIBB  Mendoza Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1418,NULL,5140226,5,1,5140100,'Perc IIBB  Misiones Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1419,NULL,5140227,5,1,5140100,'Perc IIBB  Neuquén Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1420,NULL,5140228,5,1,5140100,'Perc IIBB  Pascua Lama Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1421,NULL,5140229,5,1,5140100,'Perc IIBB  Río Negro Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1422,NULL,5140230,5,1,5140100,'Perc IIBB  Salta Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1423,NULL,5140231,5,1,5140100,'Perc IIBB  San Juan Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1424,NULL,5140232,5,1,5140100,'Perc IIBB  San Luis Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1425,NULL,5140233,5,1,5140100,'Perc IIBB  Santa Cruz Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1426,NULL,5140234,5,1,5140100,'Perc IIBB  Santa Fe Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1427,NULL,5140235,5,1,5140100,'Perc IIBB  Santiago del Estero Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1428,NULL,5140236,5,1,5140100,'Perc IIBB  Tierra del Fuego Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1429,NULL,5140237,5,1,5140100,'Perc IIBB  Tucuman Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1430,NULL,5140269,5,1,5140100,'CO2 - Imp. Al Carbono Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1431,NULL,5120256,5,1,5120100,'Imp. Municipales Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1432,NULL,5120257,5,1,5120100,'Perc/Ret. Imp. Ganancias Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
/*!40000 ALTER TABLE `conta_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_asientos`
--

DROP TABLE IF EXISTS `conta_tipo_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_asientos`
--

LOCK TABLES `conta_tipo_asientos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_asientos` DISABLE KEYS */;
INSERT INTO `conta_tipo_asientos` VALUES (1,'Sueldos',NULL,NULL,NULL,11),(2,'Ingresos',NULL,NULL,NULL,9),(3,'Egresos',NULL,NULL,NULL,10),(4,'Amortizaciones',NULL,NULL,NULL,4),(5,'Banco',NULL,NULL,NULL,15),(6,'Ganancias',NULL,NULL,NULL,12),(7,'Retenciones',NULL,NULL,NULL,13),(8,'SIRCREB',NULL,NULL,NULL,14),(9,'Compensaciones',NULL,NULL,NULL,16),(10,'Pagos AFIP',NULL,NULL,NULL,17),(11,'Ajustes',NULL,NULL,NULL,3),(12,'Saldos Iniciales',NULL,NULL,NULL,1),(13,'Cancelacion de Iniciales',NULL,NULL,NULL,2),(14,'Patrimonio Neto',NULL,NULL,NULL,8),(15,'Liquidaciones IVA',NULL,NULL,NULL,18),(16,'Liquidacion IIBB',NULL,NULL,NULL,19),(17,'Asientos de Cierre',NULL,NULL,NULL,5),(18,'Reclasificacion',NULL,NULL,NULL,6),(19,'Otros',NULL,NULL,NULL,7),(20,'Cobranzas','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(21,'Pagos','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(22,'Tesoreria','2019-10-19 02:10:24','2019-10-19 02:10:24',NULL,NULL),(23,'Ajuste por Inflacion','2020-03-01 06:39:20','2020-03-01 06:39:20',NULL,NULL),(24,'SIRTAC','2023-10-16 21:16:09','2023-10-16 21:16:09',NULL,20);
/*!40000 ALTER TABLE `conta_tipo_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_cuentas`
--

DROP TABLE IF EXISTS `conta_tipo_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_cuentas`
--

LOCK TABLES `conta_tipo_cuentas` WRITE;
/*!40000 ALTER TABLE `conta_tipo_cuentas` DISABLE KEYS */;
INSERT INTO `conta_tipo_cuentas` VALUES (1,'Rubro',NULL,NULL,NULL),(2,'SubRubro',NULL,NULL,NULL),(3,'Grupo',NULL,NULL,NULL),(4,'SubGrupo',NULL,NULL,NULL),(5,'Cuenta',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_saldos`
--

DROP TABLE IF EXISTS `conta_tipo_saldos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_saldos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `saldo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_saldos`
--

LOCK TABLES `conta_tipo_saldos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_saldos` DISABLE KEYS */;
INSERT INTO `conta_tipo_saldos` VALUES (1,'Deudor',NULL,NULL,NULL),(2,'Acreedor',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_saldos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_cuits_afip`
--

DROP TABLE IF EXISTS `control_cuits_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_cuits_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `control_cuits_afip_person_id_foreign` (`person_id`),
  CONSTRAINT `control_cuits_afip_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_cuits_afip`
--

LOCK TABLES `control_cuits_afip` WRITE;
/*!40000 ALTER TABLE `control_cuits_afip` DISABLE KEYS */;
/*!40000 ALTER TABLE `control_cuits_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_general`
--

DROP TABLE IF EXISTS `control_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_general` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `control_general_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_general`
--

LOCK TABLES `control_general` WRITE;
/*!40000 ALTER TABLE `control_general` DISABLE KEYS */;
INSERT INTO `control_general` VALUES (1,'Ingresos - Egresos - Resultado',1,'Proyeccion Ganancias','control_general/proyecGanancias',NULL,NULL),(2,'IVA',2,'IVA','control_general/iva',NULL,NULL),(3,'IIBB',3,'IIBB','control_general/iibb',NULL,NULL),(4,'Por Mes',4,'Vto. Impuestos','control_general/vto',NULL,NULL),(5,'Por Impuesto',4,'Vto. Impuestos','control_general/vtoPorImpuestos',NULL,NULL);
/*!40000 ALTER TABLE `control_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente`
--

DROP TABLE IF EXISTS `cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `numero` bigint(20) DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `compensado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_cliente_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_cliente_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=428 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente`
--

LOCK TABLES `cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente` VALUES (1,8082,1,2,40719,40721,13,3,1,0,'2022-01-04','2022-01-04',25250.00,1,1.00,'Factura C N°: 0003-00000918',NULL,'2022-11-10 13:08:20','2022-11-11 13:02:50','2022-11-11 13:02:50'),(2,8082,2,3,40719,40722,57,3,2,0,'2022-01-05','2022-01-05',12500.00,1,1.00,'Factura B N°: 0001-00000256',NULL,'2022-11-10 13:11:52','2022-11-11 13:02:57','2022-11-11 13:02:57'),(3,8082,3,3,40720,40724,57,1527,2,0,'2022-10-01','2022-10-01',31623.72,1,1.00,'Factura A N°: 0006-00067462',NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(4,8082,4,3,40720,40725,57,1527,2,0,'2022-10-01','2022-10-01',65239.20,1,1.00,'Factura A N°: 0003-00006845',NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(5,8082,5,3,40720,40726,57,1527,2,0,'2022-10-03','2022-10-03',89720.00,1,1.00,'Factura A N°: 0007-00020390',NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(6,8082,6,3,40720,40726,57,1527,2,0,'2022-10-03','2022-10-03',3380.00,1,1.00,'Factura A N°: 0007-00020391',NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(7,8082,7,3,40720,40727,57,1527,2,0,'2022-10-03','2022-10-03',23982.26,1,1.00,'Factura A N°: 0003-00002130',NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(8,8082,8,3,40720,40728,57,1527,2,0,'2022-10-03','2022-10-03',26837.80,1,1.00,'Factura A N°: 0005-00039006',NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(9,8082,9,3,40720,40729,57,1527,2,0,'2022-10-03','2022-10-03',304891.16,1,1.00,'Factura A N°: 0006-00058583',NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(10,8082,10,3,40720,40730,57,1527,2,0,'2022-10-03','2022-10-03',6851.86,1,1.00,'Factura A N°: 0002-00248146',NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(11,8082,11,3,40720,40731,57,1527,2,0,'2022-10-04','2022-10-04',20493.16,1,1.00,'Factura A N°: 0010-00030865',NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(12,8082,12,3,40720,40732,57,1527,2,0,'2022-10-04','2022-10-04',24632.49,1,1.00,'Factura A N°: 0003-00254933',NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(13,8082,13,3,40720,40733,57,1527,2,0,'2022-10-04','2022-10-04',14762.23,1,1.00,'Factura A N°: 0002-00095931',NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(14,8082,14,3,40720,40734,57,1527,2,0,'2022-10-04','2022-10-04',5689.35,1,1.00,'Factura A N°: 0055-00089435',NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(15,8082,15,3,40720,40735,57,1527,2,0,'2022-10-04','2022-10-04',36180.43,1,1.00,'Factura A N°: 0001-00033123',NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(16,8082,16,3,40720,40736,57,1527,2,0,'2022-10-05','2022-10-05',5000.01,1,1.00,'Factura B N°: 0010-00013409',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(17,8082,17,3,40720,40737,57,1527,2,0,'2022-10-05','2022-10-05',20912.19,1,1.00,'Factura A N°: 0007-00040738',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(18,8082,18,3,40720,40738,57,1527,2,0,'2022-10-05','2022-10-05',23193.57,1,1.00,'Factura A N°: 0003-00003370',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(19,8082,19,3,40720,40739,57,1527,2,0,'2022-10-05','2022-10-05',20244.22,1,1.00,'Factura A N°: 0004-00026481',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(20,8082,20,3,40720,40740,57,1527,2,0,'2022-10-05','2022-10-05',30275.62,1,1.00,'Factura A N°: 2365-00027700',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(21,8082,21,3,40720,40741,57,1527,2,0,'2022-10-06','2022-10-06',3928.48,1,1.00,'Factura A N°: 0006-00128684',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(22,8082,22,3,40720,40741,57,1527,2,0,'2022-10-06','2022-10-06',508.40,1,1.00,'Factura A N°: 0006-00128685',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(23,8082,23,3,40720,40742,57,1527,2,0,'2022-10-06','2022-10-06',19495.12,1,1.00,'Factura A N°: 0002-00013950',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(24,8082,24,3,40720,40743,57,1527,2,0,'2022-10-06','2022-10-06',8089.25,1,1.00,'Factura A N°: 0003-00066623',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL);
INSERT INTO `cta_cte_cliente` VALUES (25,8082,25,3,40720,40744,57,1527,2,0,'2022-10-06','2022-10-06',39617.37,1,1.00,'Factura A N°: 0003-00002021',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(26,8082,26,3,40720,40725,57,1527,2,0,'2022-10-06','2022-10-06',50664.25,1,1.00,'Factura A N°: 0003-00006877',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(27,8082,27,3,40720,40745,57,1527,2,0,'2022-10-06','2022-10-06',6525.00,1,1.00,'Factura C N°: 0001-00000316',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(28,8082,28,3,40720,40746,57,1527,2,0,'2022-10-07','2022-10-07',5642.56,1,1.00,'Factura A N°: 0002-00273712',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(29,8082,29,3,40720,40746,57,1527,2,0,'2022-10-07','2022-10-07',18180.83,1,1.00,'Factura A N°: 0002-00273714',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(30,8082,30,3,40720,40747,57,1527,2,0,'2022-10-07','2022-10-07',14890.26,1,1.00,'Factura A N°: 0002-00000828',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(31,8082,31,3,40720,40748,57,1527,2,0,'2022-10-08','2022-10-08',18830.92,1,1.00,'Factura A N°: 0006-00043437',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(32,8082,32,3,40720,40725,57,1527,2,0,'2022-10-10','2022-10-10',49890.75,1,1.00,'Factura A N°: 0003-00006898',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(33,8082,33,3,40720,40749,57,1527,2,0,'2022-10-10','2022-10-10',3417.04,1,1.00,'Factura B N°: 0006-09974402',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(34,8082,34,3,40720,40727,57,1527,2,0,'2022-10-11','2022-10-11',29382.37,1,1.00,'Factura A N°: 0003-00002147',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(35,8082,35,3,40720,40726,57,1527,2,0,'2022-10-11','2022-10-11',37090.00,1,1.00,'Factura A N°: 0007-00020516',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(36,8082,36,3,40720,40750,57,1527,2,0,'2022-10-11','2022-10-11',71332.58,1,1.00,'Factura A N°: 0004-00003079',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(37,8082,37,3,40720,40734,57,1527,2,0,'2022-10-11','2022-10-11',7205.82,1,1.00,'Factura A N°: 0055-00089836',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(38,8082,38,3,40720,40751,57,1527,2,0,'2022-10-11','2022-10-11',700.00,1,1.00,'Factura C N°: 0002-00000596',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(39,8082,39,3,40720,40730,57,1527,2,0,'2022-10-11','2022-10-11',3420.41,1,1.00,'Factura A N°: 0002-00249219',NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(40,8082,40,3,40720,40730,57,1527,2,0,'2022-10-11','2022-10-11',15738.43,1,1.00,'Factura A N°: 0002-00249095',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(41,8082,41,3,40720,40752,57,1527,2,0,'2022-10-12','2022-10-12',4736.30,1,1.00,'Factura A N°: 0007-00094361',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(42,8082,42,3,40720,40737,57,1527,2,0,'2022-10-12','2022-10-12',0.05,1,1.00,'Factura A N°: 0007-00040943',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(43,8082,43,3,40720,40737,57,1527,2,0,'2022-10-12','2022-10-12',31602.21,1,1.00,'Factura A N°: 0007-00040942',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(44,8082,44,3,40720,40733,57,1527,2,0,'2022-10-12','2022-10-12',29796.46,1,1.00,'Factura A N°: 0002-00096413',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(45,8082,45,3,40720,40735,57,1527,2,0,'2022-10-12','2022-10-12',39215.42,1,1.00,'Factura A N°: 0001-00033267',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(46,8082,46,3,40720,40741,57,1527,2,0,'2022-10-13','2022-10-13',5818.48,1,1.00,'Factura A N°: 0006-00129012',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(47,8082,47,3,40720,40753,57,1527,2,0,'2022-10-13','2022-10-13',3830.24,1,1.00,'Factura A N°: 0004-00012419',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(48,8082,48,3,40720,40754,57,1527,2,0,'2022-10-13','2022-10-13',49224.90,1,1.00,'Factura A N°: 0003-00008364',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL);
INSERT INTO `cta_cte_cliente` VALUES (49,8082,49,3,40720,40740,57,1527,2,0,'2022-10-13','2022-10-13',93641.28,1,1.00,'Factura A N°: 2365-00027878',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(50,8082,50,3,40720,40755,57,1527,2,0,'2022-10-14','2022-10-14',3921.00,1,1.00,'Factura B N°: 0030-00848827',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(51,8082,51,3,40720,40756,57,1527,2,0,'2022-10-14','2022-10-14',19790.00,1,1.00,'Factura B N°: 9009-00017523',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(52,8082,52,3,40720,40744,57,1527,2,0,'2022-10-14','2022-10-14',59697.52,1,1.00,'Factura A N°: 0003-00002056',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(53,8082,53,3,40720,40757,57,1527,2,0,'2022-10-14','2022-10-14',17119.47,1,1.00,'Factura A N°: 0006-00334866',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(54,8082,54,3,40720,40757,57,1527,2,0,'2022-10-14','2022-10-14',20404.03,1,1.00,'Factura A N°: 0006-00334865',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(55,8082,55,3,40720,40757,57,1527,2,0,'2022-10-14','2022-10-14',6015.27,1,1.00,'Factura A N°: 0006-00334867',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(56,8082,56,3,40720,40746,57,1527,2,0,'2022-10-14','2022-10-14',3472.73,1,1.00,'Factura A N°: 0002-00274743',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(57,8082,57,3,40720,40746,57,1527,2,0,'2022-10-14','2022-10-14',20367.31,1,1.00,'Factura A N°: 0002-00274750',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(58,8082,58,3,40720,40758,57,1527,2,0,'2022-10-14','2022-10-14',3204.37,1,1.00,'Factura A N°: 0008-00092540',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(59,8082,59,3,40720,40758,57,1527,2,0,'2022-10-14','2022-10-14',77365.36,1,1.00,'Factura A N°: 0007-00079661',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(60,8082,60,3,40720,40724,57,1527,2,0,'2022-10-15','2022-10-15',6761.10,1,1.00,'Factura A N°: 0006-00068074',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(61,8082,61,3,40720,40759,57,1527,2,0,'2022-10-17','2022-10-17',2090.00,1,1.00,'Factura B N°: 0007-00010455',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(62,8082,62,3,40720,40731,57,1527,2,0,'2022-10-17','2022-10-17',24404.78,1,1.00,'Factura A N°: 0010-00031178',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(63,8082,63,3,40720,40727,57,1527,2,0,'2022-10-17','2022-10-17',46907.11,1,1.00,'Factura A N°: 0003-00002164',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(64,8082,64,3,40720,40750,57,1527,2,0,'2022-10-17','2022-10-17',81741.76,1,1.00,'Factura A N°: 0004-00003090',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(65,8082,65,3,40720,40725,57,1527,2,0,'2022-10-17','2022-10-17',67570.75,1,1.00,'Factura A N°: 0003-00006952',NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(66,8082,66,3,40720,40729,57,1527,2,0,'2022-10-17','2022-10-17',304100.18,1,1.00,'Factura A N°: 0006-00059216',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(67,8082,67,3,40720,40730,57,1527,2,0,'2022-10-17','2022-10-17',6908.48,1,1.00,'Factura A N°: 0002-00249953',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(68,8082,68,3,40720,40726,57,1527,2,0,'2022-10-18','2022-10-18',118425.00,1,1.00,'Factura A N°: 0007-00020598',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(69,8082,69,3,40720,40726,57,1527,2,0,'2022-10-18','2022-10-18',3900.00,1,1.00,'Factura A N°: 0007-00020599',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(70,8082,70,3,40720,40732,57,1527,2,0,'2022-10-18','2022-10-18',28008.32,1,1.00,'Factura A N°: 0003-00257254',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(71,8082,71,3,40720,40733,57,1527,2,0,'2022-10-18','2022-10-18',26053.03,1,1.00,'Factura A N°: 0002-00096793',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(72,8082,72,3,40720,40760,57,1527,2,0,'2022-10-18','2022-10-18',13758.16,1,1.00,'Factura A N°: 0005-00040044',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL);
INSERT INTO `cta_cte_cliente` VALUES (73,8082,73,3,40720,40734,57,1527,2,0,'2022-10-18','2022-10-18',15305.29,1,1.00,'Factura A N°: 0055-00090361',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(74,8082,74,3,40720,40733,57,1527,2,0,'2022-10-18','2022-10-18',6239.59,1,1.00,'Factura A N°: 0002-00096802',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(75,8082,75,3,40720,40735,57,1527,1,0,'2022-10-18','2022-10-18',1460.79,1,1.00,'Nota de crédito A N°: 0001-00012981',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(76,8082,76,3,40720,40735,57,1527,2,0,'2022-10-18','2022-10-18',36810.76,1,1.00,'Factura A N°: 0001-00033371',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(77,8082,77,3,40720,40761,57,1527,2,0,'2022-10-19','2022-10-19',25930.52,1,1.00,'Factura B N°: 0003-00068724',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(78,8082,78,3,40720,40761,57,1527,2,0,'2022-10-19','2022-10-19',15589.00,1,1.00,'Factura B N°: 0003-00068478',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(79,8082,79,3,40720,40761,57,1527,2,0,'2022-10-19','2022-10-19',19380.00,1,1.00,'Factura B N°: 0003-00068503',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(80,8082,80,3,40720,40761,57,1527,2,0,'2022-10-19','2022-10-19',9157.86,1,1.00,'Factura B N°: 0003-00068802',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(81,8082,81,3,40720,40737,57,1527,2,0,'2022-10-19','2022-10-19',20478.28,1,1.00,'Factura A N°: 0007-00041186',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(82,8082,82,3,40720,40738,57,1527,2,0,'2022-10-19','2022-10-19',20768.94,1,1.00,'Factura A N°: 0003-00003406',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(83,8082,83,3,40720,40719,57,1527,2,0,'2022-10-19','2022-10-19',7000.00,1,1.00,'RECIBO C N°: 0003-00000909',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(84,8082,84,3,40720,40732,57,1527,1,0,'2022-10-19','2022-10-19',1191.08,1,1.00,'Nota de crédito A N°: 0003-00026169',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(85,8082,85,3,40720,40740,57,1527,2,0,'2022-10-19','2022-10-19',29773.80,1,1.00,'Factura A N°: 2365-00028035',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(86,8082,86,3,40720,40739,57,1527,2,0,'2022-10-19','2022-10-19',17872.10,1,1.00,'Factura A N°: 0004-00026748',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(87,8082,87,3,40720,40740,57,1527,1,0,'2022-10-19','2022-10-19',6323.99,1,1.00,'Nota de crédito A N°: 2365-00001732',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(88,8082,88,3,40720,40741,57,1527,2,0,'2022-10-20','2022-10-20',4010.80,1,1.00,'Factura A N°: 0006-00129327',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(89,8082,89,3,40720,40743,57,1527,2,0,'2022-10-20','2022-10-20',10998.04,1,1.00,'Factura A N°: 0003-00066994',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(90,8082,90,3,40720,40743,57,1527,2,0,'2022-10-20','2022-10-20',15468.38,1,1.00,'Factura A N°: 0003-00066993',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(91,8082,91,3,40720,40762,57,1527,2,0,'2022-10-20','2022-10-20',14055.60,1,1.00,'Factura A N°: 0002-00008805',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(92,8082,92,3,40720,40744,57,1527,2,0,'2022-10-20','2022-10-20',41355.00,1,1.00,'Factura A N°: 0003-00002092',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(93,8082,93,3,40720,40754,57,1527,2,0,'2022-10-20','2022-10-20',52598.00,1,1.00,'Factura A N°: 0003-00008411',NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(94,8082,94,3,40720,40754,57,1527,2,0,'2022-10-20','2022-10-20',52598.00,1,1.00,'Factura A N°: 0003-00008412',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(95,8082,95,3,40720,40757,57,1527,2,0,'2022-10-20','2022-10-20',13036.16,1,1.00,'Factura A N°: 0006-00336304',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(96,8082,96,3,40720,40741,57,1527,1,0,'2022-10-21','2022-10-21',1509.95,1,1.00,'Nota de crédito A N°: 0006-00017731',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL);
INSERT INTO `cta_cte_cliente` VALUES (97,8082,97,3,40720,40763,57,1527,2,0,'2022-10-21','2022-10-21',28262.84,1,1.00,'Factura A N°: 0011-00001129',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(98,8082,98,3,40720,40746,57,1527,2,0,'2022-10-21','2022-10-21',12027.30,1,1.00,'Factura A N°: 0002-00275766',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(99,8082,99,3,40720,40758,57,1527,2,0,'2022-10-21','2022-10-21',5472.38,1,1.00,'Factura A N°: 0008-00093121',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(100,8082,100,3,40720,40758,57,1527,2,0,'2022-10-21','2022-10-21',48637.12,1,1.00,'Factura A N°: 0007-00080320',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(101,8082,101,3,40720,40725,57,1527,2,0,'2022-10-22','2022-10-22',52598.00,1,1.00,'Factura A N°: 0003-00006981',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(102,8082,102,3,40720,40755,57,1527,2,0,'2022-10-24','2022-10-24',4648.00,1,1.00,'Factura B N°: 0030-00856426',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(103,8082,103,3,40720,40727,57,1527,2,0,'2022-10-24','2022-10-24',35714.48,1,1.00,'Factura A N°: 0003-00002182',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(104,8082,104,3,40720,40750,57,1527,2,0,'2022-10-24','2022-10-24',51389.46,1,1.00,'Factura A N°: 0004-00003110',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(105,8082,105,3,40720,40764,57,1527,2,0,'2022-10-24','2022-10-24',78.65,1,1.00,'Factura A N°: 0014-00201381',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(106,8082,106,3,40720,40729,57,1527,2,0,'2022-10-24','2022-10-24',310896.03,1,1.00,'Factura A N°: 0006-00059504',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(107,8082,107,3,40720,40748,57,1527,2,0,'2022-10-24','2022-10-24',23162.01,1,1.00,'Factura A N°: 0006-00043848',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(108,8082,108,3,40720,40730,57,1527,2,0,'2022-10-24','2022-10-24',17439.13,1,1.00,'Factura A N°: 0002-00251062',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(109,8082,109,3,40720,40761,57,1527,2,0,'2022-10-25','2022-10-25',6556.86,1,1.00,'Factura B N°: 0003-00069684',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(110,8082,110,3,40720,40726,57,1527,2,0,'2022-10-25','2022-10-25',111860.02,1,1.00,'Factura A N°: 0007-00020732',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(111,8082,111,3,40720,40726,57,1527,2,0,'2022-10-25','2022-10-25',2170.00,1,1.00,'Factura A N°: 0007-00020733',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(112,8082,112,3,40720,40732,57,1527,2,0,'2022-10-25','2022-10-25',31133.88,1,1.00,'Factura A N°: 0003-00258549',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(113,8082,113,3,40720,40734,57,1527,2,0,'2022-10-25','2022-10-25',10545.58,1,1.00,'Factura A N°: 0055-00090926',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(114,8082,114,3,40720,40733,57,1527,2,0,'2022-10-25','2022-10-25',19861.25,1,1.00,'Factura A N°: 0002-00097257',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(115,8082,115,3,40720,40765,57,1527,2,0,'2022-10-26','2022-10-26',9955.00,1,1.00,'Factura B N°: 0011-00221237',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(116,8082,116,3,40720,40753,57,1527,2,0,'2022-10-26','2022-10-26',10200.74,1,1.00,'Factura A N°: 0004-00012724',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(117,8082,117,3,40720,40737,57,1527,2,0,'2022-10-26','2022-10-26',28187.33,1,1.00,'Factura A N°: 0007-00041415',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(118,8082,118,3,40720,40734,57,1527,2,0,'2022-10-26','2022-10-26',2502.27,1,1.00,'Factura A N°: 0055-00090932',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(119,8082,119,3,40720,40740,57,1527,2,0,'2022-10-26','2022-10-26',24090.55,1,1.00,'Factura A N°: 2365-00028199',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(120,8082,120,3,40720,40735,57,1527,2,0,'2022-10-26','2022-10-26',33538.93,1,1.00,'Factura A N°: 0001-00033518',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL);
INSERT INTO `cta_cte_cliente` VALUES (121,8082,121,3,40720,40766,57,1527,2,0,'2022-10-27','2022-10-27',28742.71,1,1.00,'Factura B N°: 0011-00225893',NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(122,8082,122,3,40720,40743,57,1527,2,0,'2022-10-27','2022-10-27',20240.69,1,1.00,'Factura A N°: 0003-00067258',NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(123,8082,123,3,40720,40741,57,1527,2,0,'2022-10-27','2022-10-27',5002.43,1,1.00,'Factura A N°: 0006-00129660',NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(124,8082,124,3,40720,40741,57,1527,2,0,'2022-10-27','2022-10-27',1887.44,1,1.00,'Factura A N°: 0006-00129661',NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(125,8082,125,3,40720,40767,57,1527,2,0,'2022-10-27','2022-10-27',30477.65,1,1.00,'Factura A N°: 0160-00244960',NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(126,8082,126,3,40720,40757,57,1527,2,0,'2022-10-27','2022-10-27',21706.51,1,1.00,'Factura A N°: 0006-00337937',NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(127,8082,127,3,40720,40757,57,1527,2,0,'2022-10-27','2022-10-27',4988.57,1,1.00,'Factura A N°: 0006-00337939',NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(128,8082,128,3,40720,40757,57,1527,2,0,'2022-10-27','2022-10-27',13082.69,1,1.00,'Factura A N°: 0006-00337938',NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(129,8082,129,3,40720,40725,57,1527,2,0,'2022-10-27','2022-10-27',46410.00,1,1.00,'Factura A N°: 0003-00007000',NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(130,8082,130,3,40720,40746,57,1527,2,0,'2022-10-28','2022-10-28',33477.98,1,1.00,'Factura A N°: 0002-00277061',NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(131,8082,131,3,40720,40746,57,1527,2,0,'2022-10-28','2022-10-28',970.81,1,1.00,'Factura A N°: 0002-00277062',NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(132,8082,132,3,40720,40745,57,1527,2,0,'2022-10-28','2022-10-28',11200.00,1,1.00,'Factura C N°: 0001-00000345',NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(133,8082,133,3,40720,40745,57,1527,2,0,'2022-10-28','2022-10-28',9300.00,1,1.00,'Factura C N°: 0001-00000343',NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(134,8082,134,3,40720,40758,57,1527,2,0,'2022-10-28','2022-10-28',6408.73,1,1.00,'Factura A N°: 0008-00093728',NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(135,8082,135,3,40720,40758,57,1527,1,0,'2022-10-28','2022-10-28',2751.29,1,1.00,'Nota de crédito A N°: 0007-00017445',NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(136,8082,136,3,40720,40758,57,1527,2,0,'2022-10-28','2022-10-28',45708.57,1,1.00,'Factura A N°: 0007-00080965',NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(137,8082,137,3,40720,40744,57,1527,2,0,'2022-10-29','2022-10-29',40627.52,1,1.00,'Factura A N°: 0004-00000299',NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(138,8082,138,3,40720,40757,57,1527,1,0,'2022-10-29','2022-10-29',2818.63,1,1.00,'Nota de crédito A N°: 0006-00020652',NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(139,8082,139,3,40720,40724,57,1527,2,0,'2022-10-29','2022-10-29',51485.32,1,1.00,'Factura A N°: 0006-00068777',NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(140,8082,140,3,40720,40768,57,1527,2,0,'2022-10-31','2022-10-31',30700.00,1,1.00,'Factura C N°: 0003-00000197',NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(141,8082,141,3,40720,40762,57,1527,2,0,'2022-10-31','2022-10-31',60480.00,1,1.00,'Factura A N°: 0003-00001501',NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(142,8082,142,3,40720,40727,57,1527,2,0,'2022-10-31','2022-10-31',29430.98,1,1.00,'Factura A N°: 0003-00002203',NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(143,8082,143,3,40720,40731,57,1527,2,0,'2022-10-31','2022-10-31',27065.96,1,1.00,'Factura A N°: 0010-00031522',NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL);
INSERT INTO `cta_cte_cliente` VALUES (144,8082,144,3,40720,40769,57,1527,2,0,'2022-10-31','2022-10-31',1899.02,1,1.00,'Factura A N°: 0003-00012160',NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(145,8082,145,3,40720,40770,57,1527,2,0,'2022-10-31','2022-10-31',101700.00,1,1.00,'Factura A N°: 0004-00002132',NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(146,8082,146,3,40720,40750,57,1527,2,0,'2022-10-31','2022-10-31',88695.63,1,1.00,'Factura A N°: 0004-00003127',NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(147,8082,147,3,40720,40728,57,1527,2,0,'2022-10-31','2022-10-31',18695.30,1,1.00,'Factura A N°: 0005-00039775',NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(148,8082,148,3,40720,40725,57,1527,2,0,'2022-10-31','2022-10-31',61880.00,1,1.00,'Factura A N°: 0003-00007023',NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(149,8082,149,3,40720,40729,57,1527,2,0,'2022-10-31','2022-10-31',265727.63,1,1.00,'Factura A N°: 0006-00059716',NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(150,8082,150,3,40720,40746,57,1527,1,0,'2022-10-31','2022-10-31',1924.79,1,1.00,'Nota de crédito A N°: 0002-00015340',NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(151,8082,151,3,40720,40730,57,1527,2,0,'2022-10-31','2022-10-31',10072.44,1,1.00,'Factura A N°: 0002-00252033',NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(152,8082,152,2,40721,40774,13,3037,1,0,'2022-08-02','2022-08-02',208144.20,1,1.00,'Factura A N°: 0002-00000336',NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(153,8082,153,2,40721,40774,13,3037,1,0,'2022-08-02','2022-08-02',237482.46,1,1.00,'Factura A N°: 0002-00000337',NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(154,8082,154,2,40721,40774,13,3037,1,0,'2022-08-02','2022-08-02',72006.06,1,1.00,'Factura A N°: 0002-00000338',NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(155,8082,155,2,40721,40775,13,3037,1,0,'2022-08-07','2022-08-07',14820.04,1,1.00,'Factura A N°: 0003-00000151',NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(156,8082,156,2,40721,40776,13,3037,1,0,'2022-08-07','2022-08-07',379076.06,1,1.00,'Factura A N°: 0003-00000150',NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(157,8082,157,2,40721,40777,13,3037,1,0,'2022-08-16','2022-08-16',196504.00,1,1.00,'Factura A N°: 0002-00000339',NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(158,8082,158,2,40721,40777,13,3037,1,0,'2022-08-16','2022-08-16',320948.68,1,1.00,'Factura A N°: 0003-00000155',NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(159,8082,159,2,40721,40723,13,3037,1,0,'2022-08-16','2022-08-16',40656.00,1,1.00,'Factura A N°: 0003-00000153',NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(160,8082,160,2,40721,40778,13,3037,1,0,'2022-08-16','2022-08-16',74140.06,1,1.00,'Factura A N°: 0003-00000152',NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(161,8082,161,2,40721,40723,13,3037,1,0,'2022-08-16','2022-08-16',323258.32,1,1.00,'Factura A N°: 0003-00000154',NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(162,8082,162,2,40721,40779,13,3037,1,0,'2022-08-16','2022-08-16',502476.02,1,1.00,'Factura B N°: 0003-00000065',NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(163,8082,163,2,40721,40780,13,3037,1,0,'2022-08-16','2022-08-16',339268.30,1,1.00,'Factura B N°: 0003-00000066',NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(164,8082,164,2,40721,40781,13,3037,1,0,'2022-08-17','2022-08-17',180822.47,1,1.00,'Factura A N°: 0003-00000156',NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(165,8082,165,2,40721,40782,13,3037,1,0,'2022-08-17','2022-08-17',43802.00,1,1.00,'Factura A N°: 0002-00000340',NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(166,8082,166,2,40721,40776,13,3037,1,0,'2022-08-17','2022-08-17',182637.40,1,1.00,'Factura A N°: 0003-00000157',NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL);
INSERT INTO `cta_cte_cliente` VALUES (167,8082,167,2,40721,40776,13,3037,1,0,'2022-08-17','2022-08-17',205001.10,1,1.00,'Factura A N°: 0003-00000158',NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(168,8082,168,2,40721,40783,13,3037,1,0,'2022-08-17','2022-08-17',277524.97,1,1.00,'Cuenta de Venta y Líquido Producto A N°: 0005-00019250',NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(169,8082,169,2,40721,40784,13,3037,1,0,'2022-08-24','2022-08-24',217538.64,1,1.00,'Cuenta de Venta y Líquido Producto A N°: 0002-00007249',NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(170,8082,170,2,40721,40774,13,3037,1,0,'2022-08-26','2022-08-26',282522.34,1,1.00,'Factura A N°: 0002-00000341',NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(171,8082,171,2,40721,40785,13,3037,1,0,'2022-08-29','2022-08-29',772805.22,1,1.00,'Factura A N°: 0003-00000159',NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(172,8082,172,2,40721,40786,13,3037,1,0,'2022-08-31','2022-08-31',895484.70,1,1.00,'Factura A N°: 0003-00000160',NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(173,8082,173,2,40721,40786,13,3037,1,0,'2022-08-31','2022-08-31',980100.00,1,1.00,'Factura A N°: 0002-00000342',NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(174,8082,174,3,40721,40787,57,3037,2,0,'2022-08-01','2022-08-01',17621.47,1,1.00,'Factura A N°: 0003-00012625',NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(175,8082,175,3,40721,40788,57,3037,2,0,'2022-08-03','2022-08-03',46404.54,1,1.00,'Factura A N°: 0121-00015048',NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(176,8082,176,3,40721,40789,57,3037,2,0,'2022-08-04','2022-08-04',24823.47,1,1.00,'Factura A N°: 0022-00315197',NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(177,8082,177,3,40721,40790,57,3037,2,0,'2022-08-06','2022-08-06',901573.54,1,1.00,'Factura A N°: 0001-00000014',NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(178,8082,178,3,40721,40791,57,3037,2,0,'2022-08-08','2022-08-08',37433.39,1,1.00,'Factura A N°: 0002-00008737',NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(179,8082,179,3,40721,40787,57,3037,2,0,'2022-08-09','2022-08-09',7467.36,1,1.00,'Factura A N°: 0003-00012694',NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(180,8082,180,3,40721,40792,57,3037,2,0,'2022-08-11','2022-08-11',63607.32,1,1.00,'Factura A N°: 0005-00113440',NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(181,8082,181,3,40721,40793,57,3037,2,0,'2022-08-12','2022-08-12',108705.57,1,1.00,'Factura A N°: 0030-00000897',NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(182,8082,182,3,40721,40794,57,3037,2,0,'2022-08-12','2022-08-12',18380.00,1,1.00,'Tique Factura A N°: 0051-00023652',NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(183,8082,183,3,40721,40795,57,3037,2,0,'2022-08-18','2022-08-18',26164.09,1,1.00,'Factura A N°: 0006-00007959',NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(184,8082,184,3,40721,40796,57,3037,2,0,'2022-08-19','2022-08-19',69979.14,1,1.00,'Factura A N°: 0008-00005306',NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(185,8082,185,3,40721,40791,57,3037,2,0,'2022-08-19','2022-08-19',255788.58,1,1.00,'Factura A N°: 0002-00008780',NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(186,8082,186,3,40721,40797,57,3037,2,0,'2022-08-23','2022-08-23',598977.43,1,1.00,'Factura A N°: 1832-00034958',NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(187,8082,187,3,40721,40798,57,3037,2,0,'2022-08-24','2022-08-24',2097200.00,1,1.00,'Factura A N°: 0334-00011011',NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(188,8082,188,3,40721,40790,57,3037,2,0,'2022-08-30','2022-08-30',917836.30,1,1.00,'Factura A N°: 0001-00000031',NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(189,8082,189,3,40721,40799,57,3037,2,0,'2022-08-04','2022-08-04',14595.80,1,1.00,'Factura A N°: 0001-00031087',NULL,'2022-12-10 08:41:52','2022-12-10 08:41:52',NULL);
INSERT INTO `cta_cte_cliente` VALUES (190,8082,190,3,40723,40800,57,4555,2,0,'2022-11-02','2022-11-02',164616.18,1,1.00,'Factura A N°: 0001-00012568',NULL,'2022-12-10 09:01:08','2022-12-10 09:01:08',NULL),(191,8082,191,2,40864,40718,13,112062,1,0,'2022-08-22','2022-08-22',139294.33,1,1.00,'Tique (Informe Diario Z) N°: 0003-00013836',NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(192,8082,192,2,40864,40718,13,112062,1,0,'2022-08-23','2022-08-23',79106.64,1,1.00,'Tique (Informe Diario Z) N°: 0003-00013901',NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(193,8082,193,2,40864,40718,13,112062,1,0,'2022-08-24','2022-08-24',125610.11,1,1.00,'Tique (Informe Diario Z) N°: 0003-00013942',NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(194,8082,194,2,40864,40718,13,112062,1,0,'2022-08-25','2022-08-25',103091.18,1,1.00,'Tique (Informe Diario Z) N°: 0003-00013996',NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(195,8082,195,2,40864,40718,13,112062,1,0,'2022-08-26','2022-08-26',86772.80,1,1.00,'Tique (Informe Diario Z) N°: 0003-00014041',NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(196,8082,196,2,40864,40718,13,112062,1,0,'2022-08-28','2022-08-28',212047.65,1,1.00,'Tique (Informe Diario Z) N°: 0003-00014082',NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(197,8082,197,2,40864,40718,13,112062,1,0,'2022-08-28','2022-08-28',50192.15,1,1.00,'Tique (Informe Diario Z) N°: 0003-00014153',NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(198,8082,198,2,40864,40718,13,112062,1,0,'2022-08-29','2022-08-29',111580.11,1,1.00,'Tique (Informe Diario Z) N°: 0003-00014174',NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(199,8082,199,2,40864,40718,13,112062,1,0,'2022-08-30','2022-08-30',63768.42,1,1.00,'Tique (Informe Diario Z) N°: 0003-00014228',NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(200,8082,200,2,40864,40718,13,112062,1,0,'2022-08-31','2022-08-31',111357.48,1,1.00,'Tique (Informe Diario Z) N°: 0003-00014265',NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(201,8082,201,2,40864,40718,13,112062,1,0,'2022-09-15','2022-09-15',118852.66,1,1.00,'Tique (Informe Diario Z) N°: 0003-00015071',NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(202,8082,202,2,40864,40718,13,112062,1,0,'2022-09-16','2022-09-16',150812.76,1,1.00,'Tique (Informe Diario Z) N°: 0003-00015116',NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(203,8082,203,2,40864,40718,13,112062,1,0,'2022-09-17','2022-09-17',176666.63,1,1.00,'Tique (Informe Diario Z) N°: 0003-00015178',NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(204,8082,204,2,40864,40718,13,112062,1,0,'2022-09-18','2022-09-18',69596.83,1,1.00,'Tique (Informe Diario Z) N°: 0003-00015239',NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(205,8082,205,2,40864,40718,13,112062,1,0,'2022-09-19','2022-09-19',143527.32,1,1.00,'Tique (Informe Diario Z) N°: 0003-00015262',NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(206,8082,206,2,40864,40718,13,112062,1,0,'2022-09-20','2022-09-20',92770.73,1,1.00,'Tique (Informe Diario Z) N°: 0003-00015322',NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(207,8082,207,2,40864,40718,13,112062,1,0,'2022-09-21','2022-09-21',95665.90,1,1.00,'Tique (Informe Diario Z) N°: 0003-00015368',NULL,'2023-01-17 23:54:03','2023-01-17 23:54:03',NULL),(208,8082,208,2,40864,40718,13,112062,1,0,'2022-08-15','2022-08-15',135772.66,1,1.00,'Tique (Informe Diario Z) N°: 0003-00013401',NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(209,8082,209,2,40864,40718,13,112062,1,0,'2022-08-16','2022-08-16',150638.74,1,1.00,'Tique (Informe Diario Z) N°: 0003-00013457',NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(210,8082,210,2,40864,40718,13,112062,1,0,'2022-08-17','2022-08-17',139245.77,1,1.00,'Tique (Informe Diario Z) N°: 0003-00013530',NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL);
INSERT INTO `cta_cte_cliente` VALUES (211,8082,211,2,40864,40718,13,112062,1,0,'2022-08-18','2022-08-18',2752.00,1,1.00,'RECIBO B N°: 0003-00000001',NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(212,8082,212,2,40864,40718,13,112062,1,0,'2022-08-19','2022-08-19',196846.09,1,1.00,'Tique (Informe Diario Z) N°: 0003-00013656',NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(213,8082,213,2,40864,40718,13,112062,1,0,'2022-08-21','2022-08-21',189175.82,1,1.00,'Tique (Informe Diario Z) N°: 0003-00013744',NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(214,8082,214,2,40864,40718,13,112062,1,0,'2022-08-21','2022-08-21',53140.98,1,1.00,'Tique (Informe Diario Z) N°: 0003-00013810',NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(215,8082,215,2,40864,40718,13,112062,1,0,'2022-08-08','2022-08-08',232966.67,1,1.00,'Tique (Informe Diario Z) N°: 0003-00012872',NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(216,8082,216,2,40864,40718,13,112062,1,0,'2022-08-09','2022-08-09',115368.23,1,1.00,'Tique (Informe Diario Z) N°: 0003-00012980',NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(217,8082,217,2,40864,40718,13,112062,1,0,'2022-08-10','2022-08-10',108217.57,1,1.00,'Tique (Informe Diario Z) N°: 0003-00013041',NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(218,8082,218,2,40864,40718,13,112062,1,0,'2022-08-12','2022-08-12',132503.74,1,1.00,'Tique (Informe Diario Z) N°: 0003-00013110',NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(219,8082,219,2,40864,40718,13,112062,1,0,'2022-08-12','2022-08-12',151379.97,1,1.00,'Tique (Informe Diario Z) N°: 0003-00013181',NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(220,8082,220,2,40864,40718,13,112062,1,0,'2022-08-14','2022-08-14',218151.04,1,1.00,'Tique (Informe Diario Z) N°: 0003-00013273',NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(221,8082,221,2,40864,40718,13,112062,1,0,'2022-08-14','2022-08-14',34774.68,1,1.00,'Tique (Informe Diario Z) N°: 0003-00013383',NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(222,8082,222,2,40864,40882,13,112062,1,0,'2022-12-01','2022-12-01',76500.00,1,1.00,'Tique Factura A N°: 0004-00000777',NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(223,8082,223,2,40864,40883,13,112062,1,0,'2022-12-01','2022-12-01',1762.99,1,1.00,'Tique Factura A N°: 0004-00000778',NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(224,8082,224,2,40864,40884,13,112062,1,0,'2022-12-02','2022-12-02',5790.04,1,1.00,'Tique Factura A N°: 0004-00000779',NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(225,8082,225,2,40864,40777,13,112062,1,0,'2022-12-02','2022-12-02',6960.06,1,1.00,'Tique Factura A N°: 0004-00000780',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(226,8082,226,2,40864,40885,13,112062,1,0,'2022-12-03','2022-12-03',5055.00,1,1.00,'Tique Factura A N°: 0004-00000781',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(227,8082,227,2,40864,40883,13,112062,1,0,'2022-12-03','2022-12-03',2578.00,1,1.00,'Tique Factura A N°: 0004-00000782',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(228,8082,228,2,40864,40883,13,112062,1,0,'2022-12-03','2022-12-03',2658.04,1,1.00,'Tique Factura A N°: 0004-00000783',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(229,8082,229,2,40864,40886,13,112062,1,0,'2022-12-05','2022-12-05',4681.00,1,1.00,'Tique Factura A N°: 0004-00000784',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(230,8082,230,2,40864,40887,13,112062,1,0,'2022-12-05','2022-12-05',113710.00,1,1.00,'Tique Factura A N°: 0004-00000785',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(231,8082,231,2,40864,40777,13,112062,1,0,'2022-12-05','2022-12-05',6910.00,1,1.00,'Tique Factura A N°: 0004-00000786',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(232,8082,232,2,40864,40888,13,112062,1,0,'2022-12-05','2022-12-05',1531.00,1,1.00,'Tique Factura A N°: 0004-00000787',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL);
INSERT INTO `cta_cte_cliente` VALUES (233,8082,233,2,40864,40889,13,112062,1,0,'2022-12-06','2022-12-06',3571.00,1,1.00,'Tique Factura A N°: 0004-00000788',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(234,8082,234,2,40864,40785,13,112062,1,0,'2022-12-06','2022-12-06',156549.00,1,1.00,'Tique Factura A N°: 0004-00000789',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(235,8082,235,2,40864,40883,13,112062,1,0,'2022-12-07','2022-12-07',1500.00,1,1.00,'Tique Factura A N°: 0004-00000790',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(236,8082,236,2,40864,40883,13,112062,1,0,'2022-12-07','2022-12-07',12064.99,1,1.00,'Tique Factura A N°: 0004-00000791',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(237,8082,237,2,40864,40889,13,112062,1,0,'2022-12-08','2022-12-08',13539.00,1,1.00,'Tique Factura A N°: 0004-00000792',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(238,8082,238,2,40864,40883,13,112062,1,0,'2022-12-08','2022-12-08',3903.06,1,1.00,'Tique Factura A N°: 0004-00000793',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(239,8082,239,2,40864,40890,13,112062,1,0,'2022-12-09','2022-12-09',6671.06,1,1.00,'Tique Factura A N°: 0004-00000794',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(240,8082,240,2,40864,40885,13,112062,1,0,'2022-12-10','2022-12-10',3160.00,1,1.00,'Tique Factura A N°: 0004-00000795',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(241,8082,241,2,40864,40886,13,112062,1,0,'2022-12-10','2022-12-10',22000.04,1,1.00,'Tique Factura A N°: 0004-00000796',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(242,8082,242,2,40864,40777,13,112062,1,0,'2022-12-10','2022-12-10',2661.02,1,1.00,'Tique Factura A N°: 0004-00000797',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(243,8082,243,2,40864,40883,13,112062,1,0,'2022-12-10','2022-12-10',2920.00,1,1.00,'Tique Factura A N°: 0004-00000798',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(244,8082,244,2,40864,40889,13,112062,1,0,'2022-12-12','2022-12-12',5344.11,1,1.00,'Tique Factura A N°: 0004-00000799',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(245,8082,245,2,40864,40891,13,112062,1,0,'2022-12-12','2022-12-12',6543.00,1,1.00,'Tique Factura A N°: 0004-00000800',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(246,8082,246,2,40864,40883,13,112062,1,0,'2022-12-13','2022-12-13',550.00,1,1.00,'Tique Factura A N°: 0004-00000801',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(247,8082,247,2,40864,40777,13,112062,1,0,'2022-12-13','2022-12-13',5659.02,1,1.00,'Tique Factura A N°: 0004-00000802',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(248,8082,248,2,40864,40885,13,112062,1,0,'2022-12-14','2022-12-14',3310.06,1,1.00,'Tique Factura A N°: 0004-00000803',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(249,8082,249,2,40864,40777,13,112062,1,0,'2022-12-14','2022-12-14',8183.99,1,1.00,'Tique Factura A N°: 0004-00000804',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(250,8082,250,2,40864,40891,13,112062,1,0,'2022-12-16','2022-12-16',86000.00,1,1.00,'Tique Factura A N°: 0004-00000805',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(251,8082,251,2,40864,40889,13,112062,1,0,'2022-12-16','2022-12-16',5925.00,1,1.00,'Tique Factura A N°: 0004-00000806',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(252,8082,252,2,40864,40885,13,112062,1,0,'2022-12-17','2022-12-17',3873.09,1,1.00,'Tique Factura A N°: 0004-00000807',NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(253,8082,253,2,40864,40883,13,112062,1,0,'2022-12-17','2022-12-17',3386.04,1,1.00,'Tique Factura A N°: 0004-00000808',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(254,8082,254,2,40864,40892,13,112062,1,0,'2022-12-19','2022-12-19',15830.06,1,1.00,'Tique Factura A N°: 0004-00000809',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(255,8082,255,2,40864,40889,13,112062,1,0,'2022-12-19','2022-12-19',5613.00,1,1.00,'Tique Factura A N°: 0004-00000810',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL);
INSERT INTO `cta_cte_cliente` VALUES (256,8082,256,2,40864,40884,13,112062,1,0,'2022-12-19','2022-12-19',5551.08,1,1.00,'Tique Factura A N°: 0004-00000811',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(257,8082,257,2,40864,40777,13,112062,1,0,'2022-12-19','2022-12-19',10654.00,1,1.00,'Tique Factura A N°: 0004-00000812',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(258,8082,258,2,40864,40883,13,112062,1,0,'2022-12-20','2022-12-20',4875.00,1,1.00,'Tique Factura A N°: 0004-00000813',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(259,8082,259,2,40864,40891,13,112062,1,0,'2022-12-20','2022-12-20',4900.00,1,1.00,'Tique Factura A N°: 0004-00000814',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(260,8082,260,2,40864,40892,13,112062,1,0,'2022-12-20','2022-12-20',10259.02,1,1.00,'Tique Factura A N°: 0004-00000815',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(261,8082,261,2,40864,40883,13,112062,1,0,'2022-12-21','2022-12-21',1852.00,1,1.00,'Tique Factura A N°: 0004-00000816',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(262,8082,262,2,40864,40892,13,112062,1,0,'2022-12-21','2022-12-21',5477.02,1,1.00,'Tique Factura A N°: 0004-00000817',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(263,8082,263,2,40864,40886,13,112062,1,0,'2022-12-21','2022-12-21',3870.99,1,1.00,'Tique Factura A N°: 0004-00000818',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(264,8082,264,2,40864,40883,13,112062,1,0,'2022-12-22','2022-12-22',3055.00,1,1.00,'Tique Factura A N°: 0004-00000819',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(265,8082,265,2,40864,40883,13,112062,1,0,'2022-12-22','2022-12-22',6222.99,1,1.00,'Tique Factura A N°: 0004-00000820',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(266,8082,266,2,40864,40884,13,112062,1,0,'2022-12-22','2022-12-22',8436.99,1,1.00,'Tique Factura A N°: 0004-00000821',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(267,8082,267,2,40864,40889,13,112062,1,0,'2022-12-23','2022-12-23',4473.99,1,1.00,'Tique Factura A N°: 0004-00000822',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(268,8082,268,2,40864,40885,13,112062,1,0,'2022-12-23','2022-12-23',6364.02,1,1.00,'Tique Factura A N°: 0004-00000823',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(269,8082,269,2,40864,40777,13,112062,1,0,'2022-12-23','2022-12-23',11190.04,1,1.00,'Tique Factura A N°: 0004-00000824',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(270,8082,270,2,40864,40893,13,112062,1,0,'2022-12-23','2022-12-23',99999.99,1,1.00,'Tique Factura A N°: 0004-00000825',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(271,8082,271,2,40864,40894,13,112062,1,0,'2022-12-23','2022-12-23',760300.00,1,1.00,'Tique Factura A N°: 0004-00000826',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(272,8082,272,2,40864,40889,13,112062,1,0,'2022-12-23','2022-12-23',7449.00,1,1.00,'Tique Factura A N°: 0004-00000827',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(273,8082,273,2,40864,40883,13,112062,1,0,'2022-12-24','2022-12-24',2938.00,1,1.00,'Tique Factura A N°: 0004-00000828',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(274,8082,274,2,40864,40777,13,112062,1,0,'2022-12-24','2022-12-24',6130.00,1,1.00,'Tique Factura A N°: 0004-00000829',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(275,8082,275,2,40864,40895,13,112062,1,0,'2022-12-24','2022-12-24',66999.99,1,1.00,'Tique Factura A N°: 0004-00000830',NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(276,8082,276,2,40864,40889,13,112062,1,0,'2022-12-26','2022-12-26',7943.06,1,1.00,'Tique Factura A N°: 0004-00000831',NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(277,8082,277,2,40864,40885,13,112062,1,0,'2022-12-27','2022-12-27',4986.00,1,1.00,'Tique Factura A N°: 0004-00000832',NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL);
INSERT INTO `cta_cte_cliente` VALUES (278,8082,278,2,40864,40883,13,112062,1,0,'2022-12-27','2022-12-27',8102.00,1,1.00,'Tique Factura A N°: 0004-00000833',NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(279,8082,279,2,40864,40885,13,112062,1,0,'2022-12-28','2022-12-28',3136.11,1,1.00,'Tique Factura A N°: 0004-00000834',NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(280,8082,280,2,40864,40886,13,112062,1,0,'2022-12-28','2022-12-28',3339.00,1,1.00,'Tique Factura A N°: 0004-00000835',NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(281,8082,281,2,40864,40885,13,112062,1,0,'2022-12-29','2022-12-29',20600.08,1,1.00,'Tique Factura A N°: 0004-00000836',NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(282,8082,282,2,40864,40883,13,112062,1,0,'2022-12-29','2022-12-29',3653.00,1,1.00,'Tique Factura A N°: 0004-00000837',NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(283,8082,283,2,40864,40883,13,112062,1,0,'2022-12-30','2022-12-30',5299.00,1,1.00,'Tique Factura A N°: 0004-00000838',NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(284,8082,284,2,40864,40883,13,112062,1,0,'2022-12-30','2022-12-30',4201.99,1,1.00,'Tique Factura A N°: 0004-00000839',NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(285,8082,285,2,40864,40888,13,112062,1,0,'2022-12-30','2022-12-30',12360.99,1,1.00,'Tique Factura A N°: 0004-00000840',NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(286,8082,286,3,40864,40741,57,112062,2,0,'2022-12-01','2022-12-01',2264.93,1,1.00,'Factura A N°: 0006-00131325',NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(287,8082,287,3,40864,40744,57,112062,2,0,'2022-12-01','2022-12-01',53674.87,1,1.00,'Factura A N°: 0003-00002287',NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(288,8082,288,3,40864,40743,57,112062,2,0,'2022-12-01','2022-12-01',1195.50,1,1.00,'Factura A N°: 0003-00068412',NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(289,8082,289,3,40864,40896,57,112062,2,0,'2022-12-01','2022-12-01',5852.50,1,1.00,'Factura B N°: 0006-00005219',NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(290,8082,290,3,40864,40746,57,112062,2,0,'2022-12-02','2022-12-02',28065.16,1,1.00,'Factura A N°: 0002-00282776',NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(291,8082,291,3,40864,40758,57,112062,2,0,'2022-12-02','2022-12-02',37880.86,1,1.00,'Factura A N°: 0007-00084102',NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(292,8082,292,3,40864,40757,57,112062,2,0,'2022-12-02','2022-12-02',7765.02,1,1.00,'Factura A N°: 0006-00346286',NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(293,8082,293,3,40864,40757,57,112062,2,0,'2022-12-02','2022-12-02',21168.76,1,1.00,'Factura A N°: 0006-00346285',NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(294,8082,294,3,40864,40750,57,112062,2,0,'2022-12-02','2022-12-02',44975.97,1,1.00,'Factura A N°: 0004-00003212',NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(295,8082,295,3,40864,40758,57,112062,2,0,'2022-12-02','2022-12-02',3204.37,1,1.00,'Factura A N°: 0008-00097009',NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(296,8082,296,3,40864,40766,57,112062,2,0,'2022-12-02','2022-12-02',34601.99,1,1.00,'Factura B N°: 0011-00229104',NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(297,8082,297,3,40864,40725,57,112062,2,0,'2022-12-03','2022-12-03',57183.75,1,1.00,'Factura A N°: 0003-00007215',NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(298,8082,298,3,40864,40753,57,112062,2,0,'2022-12-05','2022-12-05',9681.86,1,1.00,'Factura A N°: 0004-00013627',NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(299,8082,299,3,40864,40727,57,112062,2,0,'2022-12-05','2022-12-05',42940.03,1,1.00,'Factura A N°: 0003-00002298',NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(300,8082,300,3,40864,40729,57,112062,2,0,'2022-12-05','2022-12-05',306569.70,1,1.00,'Factura A N°: 0006-00061204',NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL);
INSERT INTO `cta_cte_cliente` VALUES (301,8082,301,3,40864,40730,57,112062,2,0,'2022-12-05','2022-12-05',22462.35,1,1.00,'Factura A N°: 0002-00257479',NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(302,8082,302,3,40864,40755,57,112062,2,0,'2022-12-05','2022-12-05',20371.00,1,1.00,'Factura B N°: 0030-00905491',NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(303,8082,303,3,40864,40732,57,112062,2,0,'2022-12-06','2022-12-06',21047.87,1,1.00,'Factura A N°: 0003-00266408',NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(304,8082,304,3,40864,40726,57,112062,2,0,'2022-12-06','2022-12-06',9500.01,1,1.00,'Factura A N°: 0007-00021447',NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(305,8082,305,3,40864,40726,57,112062,2,0,'2022-12-06','2022-12-06',121890.03,1,1.00,'Factura A N°: 0007-00021446',NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(306,8082,306,3,40864,40733,57,112062,2,0,'2022-12-06','2022-12-06',25864.94,1,1.00,'Factura A N°: 0002-00099770',NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(307,8082,307,3,40864,40740,57,112062,2,0,'2022-12-07','2022-12-07',49565.24,1,1.00,'Factura A N°: 2365-00029345',NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(308,8082,308,3,40864,40743,57,112062,2,0,'2022-12-07','2022-12-07',5831.67,1,1.00,'Factura A N°: 0003-00068571',NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(309,8082,309,3,40864,40743,57,112062,2,0,'2022-12-07','2022-12-07',4814.54,1,1.00,'Factura A N°: 0003-00068570',NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(310,8082,310,3,40864,40734,57,112062,2,0,'2022-12-07','2022-12-07',12887.40,1,1.00,'Factura A N°: 0055-00093964',NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(311,8082,311,3,40864,40740,57,112062,2,0,'2022-12-07','2022-12-07',37888.22,1,1.00,'Factura A N°: 2365-00029336',NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(312,8082,312,3,40864,40735,57,112062,2,0,'2022-12-07','2022-12-07',44350.08,1,1.00,'Factura A N°: 0001-00034241',NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(313,8082,313,3,40864,40737,57,112062,2,0,'2022-12-07','2022-12-07',25444.49,1,1.00,'Factura A N°: 0007-00042918',NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(314,8082,314,3,40864,40757,57,112062,2,0,'2022-12-08','2022-12-08',16837.42,1,1.00,'Factura A N°: 0006-00347795',NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(315,8082,315,3,40864,40757,57,112062,2,0,'2022-12-08','2022-12-08',12166.94,1,1.00,'Factura A N°: 0006-00347796',NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(316,8082,316,3,40864,40754,57,112062,2,0,'2022-12-08','2022-12-08',50111.75,1,1.00,'Factura A N°: 0003-00008782',NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(317,8082,317,3,40864,40744,57,112062,2,0,'2022-12-08','2022-12-08',31804.98,1,1.00,'Factura A N°: 0003-00002317',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(318,8082,318,3,40864,40757,57,112062,1,0,'2022-12-09','2022-12-09',16837.42,1,1.00,'Nota de crédito A N°: 0006-00021272',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(319,8082,319,3,40864,40757,57,112062,1,0,'2022-12-09','2022-12-09',12166.94,1,1.00,'Nota de crédito A N°: 0006-00021271',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(320,8082,320,3,40864,40724,57,112062,2,0,'2022-12-10','2022-12-10',49409.60,1,1.00,'Factura A N°: 0006-00070795',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(321,8082,321,3,40864,40725,57,112062,2,0,'2022-12-10','2022-12-10',49504.00,1,1.00,'Factura A N°: 0003-00007246',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(322,8082,322,3,40864,40749,57,112062,2,0,'2022-12-10','2022-12-10',4107.95,1,1.00,'Factura B N°: 0006-10215175',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(323,8082,323,3,40864,40897,57,112062,2,0,'2022-12-11','2022-12-11',13645.00,1,1.00,'Factura A N°: 0004-00185899',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL);
INSERT INTO `cta_cte_cliente` VALUES (324,8082,324,3,40864,40747,57,112062,2,0,'2022-12-11','2022-12-11',23437.70,1,1.00,'Factura A N°: 0002-00000883',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(325,8082,325,3,40864,40761,57,112062,2,0,'2022-12-11','2022-12-11',12826.37,1,1.00,'Factura B N°: 0003-00071958',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(326,8082,326,3,40864,40761,57,112062,2,0,'2022-12-11','2022-12-11',17043.77,1,1.00,'Factura B N°: 0003-00071934',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(327,8082,327,3,40864,40731,57,112062,2,0,'2022-12-12','2022-12-12',36514.85,1,1.00,'Factura A N°: 0010-00032407',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(328,8082,328,3,40864,40727,57,112062,2,0,'2022-12-12','2022-12-12',37928.73,1,1.00,'Factura A N°: 0003-00002316',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(329,8082,329,3,40864,40730,57,112062,2,0,'2022-12-12','2022-12-12',14327.35,1,1.00,'Factura A N°: 0002-00258484',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(330,8082,330,3,40864,40769,57,112062,2,0,'2022-12-12','2022-12-12',4147.54,1,1.00,'Factura A N°: 0003-00012705',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(331,8082,331,3,40864,40728,57,112062,2,0,'2022-12-12','2022-12-12',37596.26,1,1.00,'Factura A N°: 0005-00041127',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(332,8082,332,3,40864,40735,57,112062,2,0,'2022-12-13','2022-12-13',39956.05,1,1.00,'Factura A N°: 0001-00034346',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(333,8082,333,3,40864,40726,57,112062,2,0,'2022-12-13','2022-12-13',3300.01,1,1.00,'Factura A N°: 0007-00021594',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(334,8082,334,3,40864,40734,57,112062,2,0,'2022-12-13','2022-12-13',17987.80,1,1.00,'Factura A N°: 0055-00094433',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(335,8082,335,3,40864,40726,57,112062,2,0,'2022-12-13','2022-12-13',117844.99,1,1.00,'Factura A N°: 0007-00021593',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(336,8082,336,3,40864,40733,57,112062,2,0,'2022-12-13','2022-12-13',24512.44,1,1.00,'Factura A N°: 0002-00100142',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(337,8082,337,3,40864,40737,57,112062,2,0,'2022-12-14','2022-12-14',21978.14,1,1.00,'Factura A N°: 0007-00043206',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(338,8082,338,3,40864,40751,57,112062,2,0,'2022-12-14','2022-12-14',1000.00,1,1.00,'Factura C N°: 0002-00000616',NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(339,8082,339,3,40864,40751,57,112062,2,0,'2022-12-14','2022-12-14',1000.00,1,1.00,'Factura C N°: 0002-00000617',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(340,8082,340,3,40864,40741,57,112062,2,0,'2022-12-15','2022-12-15',11801.63,1,1.00,'Factura A N°: 0006-00131989',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(341,8082,341,3,40864,40898,57,112062,2,0,'2022-12-15','2022-12-15',9905.32,1,1.00,'Factura A N°: 0324-00029833',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(342,8082,342,3,40864,40743,57,112062,2,0,'2022-12-15','2022-12-15',6688.27,1,1.00,'Factura A N°: 0003-00068804',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(343,8082,343,3,40864,40743,57,112062,2,0,'2022-12-15','2022-12-15',12211.21,1,1.00,'Factura A N°: 0003-00068803',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(344,8082,344,3,40864,40744,57,112062,2,0,'2022-12-15','2022-12-15',71539.87,1,1.00,'Factura A N°: 0003-00002345',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(345,8082,345,3,40864,40762,57,112062,2,0,'2022-12-15','2022-12-15',25194.00,1,1.00,'Factura A N°: 0002-00009015',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(346,8082,346,3,40864,40754,57,112062,2,0,'2022-12-15','2022-12-15',70720.00,1,1.00,'Factura A N°: 0003-00008835',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL);
INSERT INTO `cta_cte_cliente` VALUES (347,8082,347,3,40864,40757,57,112062,2,0,'2022-12-16','2022-12-16',13094.02,1,1.00,'Factura A N°: 0006-00349355',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(348,8082,348,3,40864,40757,57,112062,2,0,'2022-12-16','2022-12-16',20083.79,1,1.00,'Factura A N°: 0006-00349354',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(349,8082,349,3,40864,40763,57,112062,2,0,'2022-12-16','2022-12-16',33687.55,1,1.00,'Factura A N°: 0011-00001772',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(350,8082,350,3,40864,40758,57,112062,2,0,'2022-12-16','2022-12-16',1963.34,1,1.00,'Factura A N°: 0008-00098365',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(351,8082,351,3,40864,40742,57,112062,2,0,'2022-12-16','2022-12-16',8447.40,1,1.00,'Factura A N°: 0002-00014397',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(352,8082,352,3,40864,40746,57,112062,2,0,'2022-12-16','2022-12-16',52121.85,1,1.00,'Factura A N°: 0002-00284413',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(353,8082,353,3,40864,40757,57,112062,2,0,'2022-12-16','2022-12-16',994.21,1,1.00,'Factura A N°: 0006-00349402',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(354,8082,354,3,40864,40758,57,112062,2,0,'2022-12-16','2022-12-16',75004.34,1,1.00,'Factura A N°: 0007-00085349',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(355,8082,355,3,40864,40758,57,112062,1,0,'2022-12-16','2022-12-16',5977.31,1,1.00,'Nota de crédito A N°: 0007-00018485',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(356,8082,356,3,40864,40741,57,112062,1,0,'2022-12-17','2022-12-17',1834.19,1,1.00,'Nota de crédito A N°: 0006-00018175',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(357,8082,357,3,40864,40757,57,112062,1,0,'2022-12-17','2022-12-17',994.21,1,1.00,'Nota de crédito A N°: 0006-00021412',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(358,8082,358,3,40864,40725,57,112062,2,0,'2022-12-19','2022-12-19',56576.00,1,1.00,'Factura A N°: 0003-00007280',NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(359,8082,359,3,40864,40753,57,112062,2,0,'2022-12-19','2022-12-19',7296.37,1,1.00,'Factura A N°: 0004-00013921',NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(360,8082,360,3,40864,40727,57,112062,2,0,'2022-12-19','2022-12-19',58606.48,1,1.00,'Factura A N°: 0003-00002334',NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(361,8082,361,3,40864,40899,57,112062,2,0,'2022-12-19','2022-12-19',22334.25,1,1.00,'Factura A N°: 0009-00005785',NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(362,8082,362,3,40864,40900,57,112062,2,0,'2022-12-19','2022-12-19',11549.93,1,1.00,'Factura A N°: 0002-00029128',NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(363,8082,363,3,40864,40748,57,112062,2,0,'2022-12-19','2022-12-19',30558.35,1,1.00,'Factura A N°: 0006-00045696',NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(364,8082,364,3,40864,40729,57,112062,2,0,'2022-12-20','2022-12-20',284425.92,1,1.00,'Factura A N°: 0006-00061754',NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(365,8082,365,3,40864,40752,57,112062,2,0,'2022-12-20','2022-12-20',3496.76,1,1.00,'Factura A N°: 0007-00097452',NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(366,8082,366,3,40864,40733,57,112062,2,0,'2022-12-20','2022-12-20',43376.24,1,1.00,'Factura A N°: 0002-00100649',NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(367,8082,367,3,40864,40750,57,112062,2,0,'2022-12-20','2022-12-20',27675.32,1,1.00,'Factura A N°: 0004-00003256',NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(368,8082,368,3,40864,40732,57,112062,2,0,'2022-12-20','2022-12-20',54967.90,1,1.00,'Factura A N°: 0003-00269201',NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(369,8082,369,3,40864,40737,57,112062,2,0,'2022-12-21','2022-12-21',39480.41,1,1.00,'Factura A N°: 0007-00043518',NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL);
INSERT INTO `cta_cte_cliente` VALUES (370,8082,370,3,40864,40762,57,112062,2,0,'2022-12-21','2022-12-21',183680.00,1,1.00,'Factura A N°: 0002-00009072',NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(371,8082,371,3,40864,40740,57,112062,2,0,'2022-12-21','2022-12-21',82315.28,1,1.00,'Factura A N°: 2365-00029676',NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(372,8082,372,3,40864,40760,57,112062,2,0,'2022-12-21','2022-12-21',21856.80,1,1.00,'Factura A N°: 0005-00041419',NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(373,8082,373,3,40864,40760,57,112062,2,0,'2022-12-21','2022-12-21',21856.80,1,1.00,'Factura A N°: 0005-00041420',NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(374,8082,374,3,40864,40760,57,112062,1,0,'2022-12-21','2022-12-21',21856.80,1,1.00,'Nota de crédito A N°: 0005-00001915',NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(375,8082,375,3,40864,40767,57,112062,2,0,'2022-12-22','2022-12-22',24140.55,1,1.00,'Factura A N°: 0160-00249514',NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(376,8082,376,3,40864,40743,57,112062,2,0,'2022-12-22','2022-12-22',6039.90,1,1.00,'Factura A N°: 0003-00069013',NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(377,8082,377,3,40864,40743,57,112062,2,0,'2022-12-22','2022-12-22',11553.43,1,1.00,'Factura A N°: 0003-00069012',NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(378,8082,378,3,40864,40741,57,112062,2,0,'2022-12-22','2022-12-22',8806.37,1,1.00,'Factura A N°: 0006-00132365',NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(379,8082,379,3,40864,40741,57,112062,2,0,'2022-12-22','2022-12-22',2038.46,1,1.00,'Factura A N°: 0006-00132366',NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(380,8082,380,3,40864,40754,57,112062,2,0,'2022-12-22','2022-12-22',45979.80,1,1.00,'Factura A N°: 0003-00008892',NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(381,8082,381,3,40864,40757,57,112062,2,0,'2022-12-22','2022-12-22',16283.70,1,1.00,'Factura A N°: 0006-00351007',NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(382,8082,382,3,40864,40757,57,112062,2,0,'2022-12-22','2022-12-22',12749.91,1,1.00,'Factura A N°: 0006-00351008',NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(383,8082,383,3,40864,40901,57,112062,2,0,'2022-12-22','2022-12-22',5418.92,1,1.00,'Factura A N°: 0026-00018229',NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(384,8082,384,3,40864,40744,57,112062,2,0,'2022-12-22','2022-12-22',72129.95,1,1.00,'Factura A N°: 0003-00002379',NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(385,8082,385,3,40864,40753,57,112062,1,0,'2022-12-22','2022-12-22',7296.37,1,1.00,'Nota de crédito A N°: 0004-00001157',NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(386,8082,386,3,40864,40762,57,112062,2,0,'2022-12-23','2022-12-23',26520.00,1,1.00,'Factura A N°: 0002-00009085',NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(387,8082,387,3,40864,40758,57,112062,2,0,'2022-12-23','2022-12-23',3384.10,1,1.00,'Factura A N°: 0008-00099091',NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(388,8082,388,3,40864,40746,57,112062,2,0,'2022-12-23','2022-12-23',17235.11,1,1.00,'Factura A N°: 0002-00285368',NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(389,8082,389,3,40864,40758,57,112062,2,0,'2022-12-23','2022-12-23',76682.41,1,1.00,'Factura A N°: 0007-00085936',NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(390,8082,390,3,40864,40758,57,112062,1,0,'2022-12-23','2022-12-23',5926.84,1,1.00,'Nota de crédito A N°: 0007-00018645',NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(391,8082,391,3,40864,40724,57,112062,2,0,'2022-12-24','2022-12-24',45044.22,1,1.00,'Factura A N°: 0006-00071451',NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(392,8082,392,3,40864,40725,57,112062,2,0,'2022-12-24','2022-12-24',53758.25,1,1.00,'Factura A N°: 0003-00007313',NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL);
INSERT INTO `cta_cte_cliente` VALUES (393,8082,393,3,40864,40761,57,112062,2,0,'2022-12-25','2022-12-25',11841.64,1,1.00,'Factura B N°: 0003-00072590',NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(394,8082,394,3,40864,40761,57,112062,2,0,'2022-12-25','2022-12-25',7954.93,1,1.00,'Factura B N°: 0003-00072534',NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(395,8082,395,3,40864,40761,57,112062,2,0,'2022-12-25','2022-12-25',11841.64,1,1.00,'Factura B N°: 0003-00072578',NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(396,8082,396,3,40864,40761,57,112062,2,0,'2022-12-25','2022-12-25',17332.77,1,1.00,'Factura B N°: 0003-00072696',NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(397,8082,397,3,40864,40728,57,112062,2,0,'2022-12-26','2022-12-26',52818.97,1,1.00,'Factura A N°: 0005-00041638',NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(398,8082,398,3,40864,40727,57,112062,2,0,'2022-12-26','2022-12-26',47313.78,1,1.00,'Factura A N°: 0003-00002354',NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(399,8082,399,3,40864,40731,57,112062,2,0,'2022-12-26','2022-12-26',51002.20,1,1.00,'Factura A N°: 0010-00032696',NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(400,8082,400,3,40864,40750,57,112062,2,0,'2022-12-26','2022-12-26',56493.77,1,1.00,'Factura A N°: 0004-00003268',NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(401,8082,401,3,40864,40729,57,112062,2,0,'2022-12-26','2022-12-26',253059.74,1,1.00,'Factura A N°: 0006-00062004',NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(402,8082,402,3,40864,40730,57,112062,2,0,'2022-12-26','2022-12-26',7409.99,1,1.00,'Factura A N°: 0002-00261355',NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(403,8082,403,3,40864,40730,57,112062,2,0,'2022-12-26','2022-12-26',4777.21,1,1.00,'Factura A N°: 0002-00261358',NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(404,8082,404,3,40864,40902,57,112062,2,0,'2022-12-26','2022-12-26',13334.00,1,1.00,'Factura C N°: 0002-00000172',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(405,8082,405,3,40864,40732,57,112062,2,0,'2022-12-27','2022-12-27',41000.14,1,1.00,'Factura A N°: 0003-00270585',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(406,8082,406,3,40864,40732,57,112062,2,0,'2022-12-27','2022-12-27',3267.03,1,1.00,'Factura A N°: 0003-00270586',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(407,8082,407,3,40864,40733,57,112062,2,0,'2022-12-27','2022-12-27',36729.21,1,1.00,'Factura A N°: 0002-00101041',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(408,8082,408,3,40864,40735,57,112062,2,0,'2022-12-27','2022-12-27',37743.38,1,1.00,'Factura A N°: 0001-00034644',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(409,8082,409,3,40864,40734,57,112062,2,0,'2022-12-27','2022-12-27',2662.53,1,1.00,'Factura A N°: 0055-00095232',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(410,8082,410,3,40864,40735,57,112062,1,0,'2022-12-27','2022-12-27',364.43,1,1.00,'Nota de crédito A N°: 0001-00013454',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(411,8082,411,3,40864,40737,57,112062,2,0,'2022-12-28','2022-12-28',28669.41,1,1.00,'Factura A N°: 0007-00043747',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(412,8082,412,3,40864,40754,57,112062,2,0,'2022-12-28','2022-12-28',57908.55,1,1.00,'Factura A N°: 0003-00008937',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(413,8082,413,3,40864,40734,57,112062,2,0,'2022-12-28','2022-12-28',7852.13,1,1.00,'Factura A N°: 0055-00095252',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(414,8082,414,3,40864,40739,57,112062,2,0,'2022-12-28','2022-12-28',2371.08,1,1.00,'Factura A N°: 0004-00027964',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(415,8082,415,3,40864,40903,57,112062,2,0,'2022-12-28','2022-12-28',11340.00,1,1.00,'Factura C N°: 0004-00001974',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL);
INSERT INTO `cta_cte_cliente` VALUES (416,8082,416,3,40864,40741,57,112062,2,0,'2022-12-29','2022-12-29',10947.08,1,1.00,'Factura A N°: 0006-00132717',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(417,8082,417,3,40864,40898,57,112062,2,0,'2022-12-29','2022-12-29',12684.74,1,1.00,'Factura A N°: 0324-00030310',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(418,8082,418,3,40864,40739,57,112062,2,0,'2022-12-29','2022-12-29',4734.30,1,1.00,'Factura A N°: 0004-00027982',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(419,8082,419,3,40864,40762,57,112062,2,0,'2022-12-29','2022-12-29',124880.00,1,1.00,'Factura A N°: 0002-00009137',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(420,8082,420,3,40864,40757,57,112062,2,0,'2022-12-29','2022-12-29',2333.28,1,1.00,'Factura A N°: 0006-00352447',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(421,8082,421,3,40864,40757,57,112062,2,0,'2022-12-29','2022-12-29',16227.58,1,1.00,'Factura A N°: 0006-00352446',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(422,8082,422,3,40864,40766,57,112062,2,0,'2022-12-29','2022-12-29',50868.58,1,1.00,'Factura B N°: 0011-00229504',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(423,8082,423,3,40864,40764,57,112062,2,0,'2022-12-30','2022-12-30',78.65,1,1.00,'Factura A N°: 0014-00209096',NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(424,8082,424,3,40864,40744,57,112062,2,0,'2022-12-30','2022-12-30',56474.40,1,1.00,'Factura A N°: 0003-00002402',NULL,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(425,8082,425,3,40864,40758,57,112062,2,0,'2022-12-30','2022-12-30',69785.00,1,1.00,'Factura A N°: 0007-00086182',NULL,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(426,8082,426,3,40864,40746,57,112062,2,0,'2022-12-30','2022-12-30',22251.47,1,1.00,'Factura A N°: 0002-00286319',NULL,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(427,8082,427,3,40864,40904,57,112062,2,0,'2022-12-30','2022-12-30',2999.00,1,1.00,'Factura B N°: 0004-01339077',NULL,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_details`
--

DROP TABLE IF EXISTS `cta_cte_cliente_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_details_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_cliente_details_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_details_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_details_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_details_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_details`
--

LOCK TABLES `cta_cte_cliente_details` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_pivot_receipt`
--

DROP TABLE IF EXISTS `cta_cte_cliente_pivot_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_pivot_receipt` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `receipt_id` int(11) DEFAULT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `is_a_cuenta` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `cccpr_a_cuenta_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_cccpr_a_cuenta_id` (`cccpr_a_cuenta_id`),
  CONSTRAINT `fk_cccpr_a_cuenta_id` FOREIGN KEY (`cccpr_a_cuenta_id`) REFERENCES `cta_cte_cliente_pivot_receipt` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=428 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_pivot_receipt`
--

LOCK TABLES `cta_cte_cliente_pivot_receipt` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (1,8082,1,1,NULL,0,NULL,'2022-11-10 13:08:20','2022-11-10 13:08:20',NULL),(2,8082,2,2,NULL,0,NULL,'2022-11-10 13:11:52','2022-11-10 13:11:52',NULL),(3,8082,3,3,NULL,0,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(4,8082,4,4,NULL,0,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(5,8082,5,5,NULL,0,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(6,8082,6,6,NULL,0,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(7,8082,7,7,NULL,0,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(8,8082,8,8,NULL,0,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(9,8082,9,9,NULL,0,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(10,8082,10,10,NULL,0,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(11,8082,11,11,NULL,0,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(12,8082,12,12,NULL,0,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(13,8082,13,13,NULL,0,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(14,8082,14,14,NULL,0,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(15,8082,15,15,NULL,0,NULL,'2022-11-13 21:52:13','2022-11-13 21:52:13',NULL),(16,8082,16,16,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(17,8082,17,17,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(18,8082,18,18,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(19,8082,19,19,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(20,8082,20,20,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(21,8082,21,21,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(22,8082,22,22,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(23,8082,23,23,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(24,8082,24,24,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(25,8082,25,25,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(26,8082,26,26,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(27,8082,27,27,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(28,8082,28,28,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(29,8082,29,29,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(30,8082,30,30,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(31,8082,31,31,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(32,8082,32,32,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(33,8082,33,33,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(34,8082,34,34,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(35,8082,35,35,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(36,8082,36,36,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(37,8082,37,37,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(38,8082,38,38,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(39,8082,39,39,NULL,0,NULL,'2022-11-13 21:52:14','2022-11-13 21:52:14',NULL),(40,8082,40,40,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(41,8082,41,41,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(42,8082,42,42,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(43,8082,43,43,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(44,8082,44,44,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(45,8082,45,45,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(46,8082,46,46,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(47,8082,47,47,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(48,8082,48,48,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(49,8082,49,49,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(50,8082,50,50,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(51,8082,51,51,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(52,8082,52,52,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (53,8082,53,53,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(54,8082,54,54,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(55,8082,55,55,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(56,8082,56,56,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(57,8082,57,57,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(58,8082,58,58,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(59,8082,59,59,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(60,8082,60,60,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(61,8082,61,61,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(62,8082,62,62,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(63,8082,63,63,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(64,8082,64,64,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(65,8082,65,65,NULL,0,NULL,'2022-11-13 21:52:15','2022-11-13 21:52:15',NULL),(66,8082,66,66,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(67,8082,67,67,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(68,8082,68,68,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(69,8082,69,69,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(70,8082,70,70,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(71,8082,71,71,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(72,8082,72,72,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(73,8082,73,73,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(74,8082,74,74,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(75,8082,75,75,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(76,8082,76,76,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(77,8082,77,77,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(78,8082,78,78,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(79,8082,79,79,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(80,8082,80,80,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(81,8082,81,81,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(82,8082,82,82,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(83,8082,83,83,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(84,8082,84,84,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(85,8082,85,85,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(86,8082,86,86,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(87,8082,87,87,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(88,8082,88,88,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(89,8082,89,89,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(90,8082,90,90,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(91,8082,91,91,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(92,8082,92,92,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(93,8082,93,93,NULL,0,NULL,'2022-11-13 21:52:16','2022-11-13 21:52:16',NULL),(94,8082,94,94,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(95,8082,95,95,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(96,8082,96,96,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(97,8082,97,97,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(98,8082,98,98,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(99,8082,99,99,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(100,8082,100,100,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(101,8082,101,101,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(102,8082,102,102,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(103,8082,103,103,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (104,8082,104,104,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(105,8082,105,105,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(106,8082,106,106,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(107,8082,107,107,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(108,8082,108,108,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(109,8082,109,109,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(110,8082,110,110,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(111,8082,111,111,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(112,8082,112,112,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(113,8082,113,113,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(114,8082,114,114,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(115,8082,115,115,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(116,8082,116,116,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(117,8082,117,117,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(118,8082,118,118,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(119,8082,119,119,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(120,8082,120,120,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(121,8082,121,121,NULL,0,NULL,'2022-11-13 21:52:17','2022-11-13 21:52:17',NULL),(122,8082,122,122,NULL,0,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(123,8082,123,123,NULL,0,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(124,8082,124,124,NULL,0,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(125,8082,125,125,NULL,0,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(126,8082,126,126,NULL,0,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(127,8082,127,127,NULL,0,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(128,8082,128,128,NULL,0,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(129,8082,129,129,NULL,0,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(130,8082,130,130,NULL,0,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(131,8082,131,131,NULL,0,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(132,8082,132,132,NULL,0,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(133,8082,133,133,NULL,0,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(134,8082,134,134,NULL,0,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(135,8082,135,135,NULL,0,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(136,8082,136,136,NULL,0,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(137,8082,137,137,NULL,0,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(138,8082,138,138,NULL,0,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(139,8082,139,139,NULL,0,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(140,8082,140,140,NULL,0,NULL,'2022-11-13 21:52:18','2022-11-13 21:52:18',NULL),(141,8082,141,141,NULL,0,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(142,8082,142,142,NULL,0,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(143,8082,143,143,NULL,0,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(144,8082,144,144,NULL,0,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(145,8082,145,145,NULL,0,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(146,8082,146,146,NULL,0,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(147,8082,147,147,NULL,0,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(148,8082,148,148,NULL,0,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(149,8082,149,149,NULL,0,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(150,8082,150,150,NULL,0,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(151,8082,151,151,NULL,0,NULL,'2022-11-13 21:52:19','2022-11-13 21:52:19',NULL),(152,8082,152,152,NULL,0,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (153,8082,153,153,NULL,0,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(154,8082,154,154,NULL,0,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(155,8082,155,155,NULL,0,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(156,8082,156,156,NULL,0,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(157,8082,157,157,NULL,0,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(158,8082,158,158,NULL,0,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(159,8082,159,159,NULL,0,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(160,8082,160,160,NULL,0,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(161,8082,161,161,NULL,0,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(162,8082,162,162,NULL,0,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(163,8082,163,163,NULL,0,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(164,8082,164,164,NULL,0,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(165,8082,165,165,NULL,0,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(166,8082,166,166,NULL,0,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(167,8082,167,167,NULL,0,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(168,8082,168,168,NULL,0,NULL,'2022-11-15 14:09:05','2022-11-15 14:09:05',NULL),(169,8082,169,169,NULL,0,NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(170,8082,170,170,NULL,0,NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(171,8082,171,171,NULL,0,NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(172,8082,172,172,NULL,0,NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(173,8082,173,173,NULL,0,NULL,'2022-11-15 14:09:06','2022-11-15 14:09:06',NULL),(174,8082,174,174,NULL,0,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(175,8082,175,175,NULL,0,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(176,8082,176,176,NULL,0,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(177,8082,177,177,NULL,0,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(178,8082,178,178,NULL,0,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(179,8082,179,179,NULL,0,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(180,8082,180,180,NULL,0,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(181,8082,181,181,NULL,0,NULL,'2022-11-15 14:11:19','2022-11-15 14:11:19',NULL),(182,8082,182,182,NULL,0,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(183,8082,183,183,NULL,0,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(184,8082,184,184,NULL,0,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(185,8082,185,185,NULL,0,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(186,8082,186,186,NULL,0,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(187,8082,187,187,NULL,0,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(188,8082,188,188,NULL,0,NULL,'2022-11-15 14:11:20','2022-11-15 14:11:20',NULL),(189,8082,189,189,NULL,0,NULL,'2022-12-10 08:41:52','2022-12-10 08:41:52',NULL),(190,8082,190,190,NULL,0,NULL,'2022-12-10 09:01:08','2022-12-10 09:01:08',NULL),(191,8082,191,204,NULL,0,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(192,8082,192,205,NULL,0,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(193,8082,193,206,NULL,0,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(194,8082,194,207,NULL,0,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(195,8082,195,208,NULL,0,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(196,8082,196,209,NULL,0,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(197,8082,197,210,NULL,0,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(198,8082,198,211,NULL,0,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(199,8082,199,212,NULL,0,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(200,8082,200,213,NULL,0,NULL,'2023-01-17 23:53:54','2023-01-17 23:53:54',NULL),(201,8082,201,214,NULL,0,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (202,8082,202,215,NULL,0,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(203,8082,203,216,NULL,0,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(204,8082,204,217,NULL,0,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(205,8082,205,218,NULL,0,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(206,8082,206,219,NULL,0,NULL,'2023-01-17 23:54:02','2023-01-17 23:54:02',NULL),(207,8082,207,220,NULL,0,NULL,'2023-01-17 23:54:03','2023-01-17 23:54:03',NULL),(208,8082,208,221,NULL,0,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(209,8082,209,222,NULL,0,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(210,8082,210,223,NULL,0,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(211,8082,211,224,NULL,0,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(212,8082,212,225,NULL,0,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(213,8082,213,226,NULL,0,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(214,8082,214,227,NULL,0,NULL,'2023-01-17 23:54:09','2023-01-17 23:54:09',NULL),(215,8082,215,228,NULL,0,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(216,8082,216,229,NULL,0,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(217,8082,217,230,NULL,0,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(218,8082,218,231,NULL,0,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(219,8082,219,232,NULL,0,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(220,8082,220,233,NULL,0,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(221,8082,221,234,NULL,0,NULL,'2023-01-17 23:54:36','2023-01-17 23:54:36',NULL),(222,8082,222,235,NULL,0,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(223,8082,223,236,NULL,0,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(224,8082,224,237,NULL,0,NULL,'2023-01-17 23:57:53','2023-01-17 23:57:53',NULL),(225,8082,225,238,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(226,8082,226,239,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(227,8082,227,240,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(228,8082,228,241,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(229,8082,229,242,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(230,8082,230,243,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(231,8082,231,244,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(232,8082,232,245,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(233,8082,233,246,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(234,8082,234,247,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(235,8082,235,248,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(236,8082,236,249,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(237,8082,237,250,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(238,8082,238,251,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(239,8082,239,252,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(240,8082,240,253,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(241,8082,241,254,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(242,8082,242,255,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(243,8082,243,256,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(244,8082,244,257,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(245,8082,245,258,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(246,8082,246,259,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(247,8082,247,260,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(248,8082,248,261,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(249,8082,249,262,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(250,8082,250,263,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (251,8082,251,264,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(252,8082,252,265,NULL,0,NULL,'2023-01-17 23:57:54','2023-01-17 23:57:54',NULL),(253,8082,253,266,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(254,8082,254,267,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(255,8082,255,268,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(256,8082,256,269,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(257,8082,257,270,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(258,8082,258,271,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(259,8082,259,272,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(260,8082,260,273,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(261,8082,261,274,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(262,8082,262,275,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(263,8082,263,276,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(264,8082,264,277,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(265,8082,265,278,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(266,8082,266,279,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(267,8082,267,280,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(268,8082,268,281,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(269,8082,269,282,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(270,8082,270,283,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(271,8082,271,284,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(272,8082,272,285,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(273,8082,273,286,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(274,8082,274,287,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(275,8082,275,288,NULL,0,NULL,'2023-01-17 23:57:55','2023-01-17 23:57:55',NULL),(276,8082,276,289,NULL,0,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(277,8082,277,290,NULL,0,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(278,8082,278,291,NULL,0,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(279,8082,279,292,NULL,0,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(280,8082,280,293,NULL,0,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(281,8082,281,294,NULL,0,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(282,8082,282,295,NULL,0,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(283,8082,283,296,NULL,0,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(284,8082,284,297,NULL,0,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(285,8082,285,298,NULL,0,NULL,'2023-01-17 23:57:56','2023-01-17 23:57:56',NULL),(286,8082,286,299,NULL,0,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(287,8082,287,300,NULL,0,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(288,8082,288,301,NULL,0,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(289,8082,289,302,NULL,0,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(290,8082,290,303,NULL,0,NULL,'2023-01-18 00:00:02','2023-01-18 00:00:02',NULL),(291,8082,291,304,NULL,0,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(292,8082,292,305,NULL,0,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(293,8082,293,306,NULL,0,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(294,8082,294,307,NULL,0,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(295,8082,295,308,NULL,0,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(296,8082,296,309,NULL,0,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(297,8082,297,310,NULL,0,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(298,8082,298,311,NULL,0,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(299,8082,299,312,NULL,0,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (300,8082,300,313,NULL,0,NULL,'2023-01-18 00:00:03','2023-01-18 00:00:03',NULL),(301,8082,301,314,NULL,0,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(302,8082,302,315,NULL,0,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(303,8082,303,316,NULL,0,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(304,8082,304,317,NULL,0,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(305,8082,305,318,NULL,0,NULL,'2023-01-18 00:00:04','2023-01-18 00:00:04',NULL),(306,8082,306,319,NULL,0,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(307,8082,307,320,NULL,0,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(308,8082,308,321,NULL,0,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(309,8082,309,322,NULL,0,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(310,8082,310,323,NULL,0,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(311,8082,311,324,NULL,0,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(312,8082,312,325,NULL,0,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(313,8082,313,326,NULL,0,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(314,8082,314,327,NULL,0,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(315,8082,315,328,NULL,0,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(316,8082,316,329,NULL,0,NULL,'2023-01-18 00:00:05','2023-01-18 00:00:05',NULL),(317,8082,317,330,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(318,8082,318,331,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(319,8082,319,332,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(320,8082,320,333,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(321,8082,321,334,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(322,8082,322,335,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(323,8082,323,336,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(324,8082,324,337,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(325,8082,325,338,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(326,8082,326,339,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(327,8082,327,340,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(328,8082,328,341,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(329,8082,329,342,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(330,8082,330,343,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(331,8082,331,344,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(332,8082,332,345,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(333,8082,333,346,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(334,8082,334,347,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(335,8082,335,348,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(336,8082,336,349,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(337,8082,337,350,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(338,8082,338,351,NULL,0,NULL,'2023-01-18 00:00:06','2023-01-18 00:00:06',NULL),(339,8082,339,352,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(340,8082,340,353,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(341,8082,341,354,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(342,8082,342,355,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(343,8082,343,356,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(344,8082,344,357,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(345,8082,345,358,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(346,8082,346,359,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(347,8082,347,360,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(348,8082,348,361,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (349,8082,349,362,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(350,8082,350,363,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(351,8082,351,364,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(352,8082,352,365,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(353,8082,353,366,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(354,8082,354,367,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(355,8082,355,368,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(356,8082,356,369,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(357,8082,357,370,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(358,8082,358,371,NULL,0,NULL,'2023-01-18 00:00:07','2023-01-18 00:00:07',NULL),(359,8082,359,372,NULL,0,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(360,8082,360,373,NULL,0,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(361,8082,361,374,NULL,0,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(362,8082,362,375,NULL,0,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(363,8082,363,376,NULL,0,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(364,8082,364,377,NULL,0,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(365,8082,365,378,NULL,0,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(366,8082,366,379,NULL,0,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(367,8082,367,380,NULL,0,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(368,8082,368,381,NULL,0,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(369,8082,369,382,NULL,0,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(370,8082,370,383,NULL,0,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(371,8082,371,384,NULL,0,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(372,8082,372,385,NULL,0,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(373,8082,373,386,NULL,0,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(374,8082,374,387,NULL,0,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(375,8082,375,388,NULL,0,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(376,8082,376,389,NULL,0,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(377,8082,377,390,NULL,0,NULL,'2023-01-18 00:00:08','2023-01-18 00:00:08',NULL),(378,8082,378,391,NULL,0,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(379,8082,379,392,NULL,0,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(380,8082,380,393,NULL,0,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(381,8082,381,394,NULL,0,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(382,8082,382,395,NULL,0,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(383,8082,383,396,NULL,0,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(384,8082,384,397,NULL,0,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(385,8082,385,398,NULL,0,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(386,8082,386,399,NULL,0,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(387,8082,387,400,NULL,0,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(388,8082,388,401,NULL,0,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(389,8082,389,402,NULL,0,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(390,8082,390,403,NULL,0,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(391,8082,391,404,NULL,0,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(392,8082,392,405,NULL,0,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(393,8082,393,406,NULL,0,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(394,8082,394,407,NULL,0,NULL,'2023-01-18 00:00:09','2023-01-18 00:00:09',NULL),(395,8082,395,408,NULL,0,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(396,8082,396,409,NULL,0,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(397,8082,397,410,NULL,0,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (398,8082,398,411,NULL,0,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(399,8082,399,412,NULL,0,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(400,8082,400,413,NULL,0,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(401,8082,401,414,NULL,0,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(402,8082,402,415,NULL,0,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(403,8082,403,416,NULL,0,NULL,'2023-01-18 00:00:10','2023-01-18 00:00:10',NULL),(404,8082,404,417,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(405,8082,405,418,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(406,8082,406,419,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(407,8082,407,420,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(408,8082,408,421,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(409,8082,409,422,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(410,8082,410,423,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(411,8082,411,424,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(412,8082,412,425,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(413,8082,413,426,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(414,8082,414,427,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(415,8082,415,428,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(416,8082,416,429,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(417,8082,417,430,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(418,8082,418,431,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(419,8082,419,432,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(420,8082,420,433,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(421,8082,421,434,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(422,8082,422,435,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(423,8082,423,436,NULL,0,NULL,'2023-01-18 00:00:11','2023-01-18 00:00:11',NULL),(424,8082,424,437,NULL,0,NULL,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(425,8082,425,438,NULL,0,NULL,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(426,8082,426,439,NULL,0,NULL,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL),(427,8082,427,440,NULL,0,NULL,'2023-01-18 00:00:12','2023-01-18 00:00:12',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `ticket_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `cta_cte_tesoreria_moneda_id_foreign` (`moneda_id`),
  KEY `cta_cte_tesoreria_ticket_id_foreign` (`ticket_id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `cta_cte_tesoreria_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_ticket_id_foreign` FOREIGN KEY (`ticket_id`) REFERENCES `tickets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria`
--

LOCK TABLES `cta_cte_tesoreria` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_cheq`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_cheq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_cheq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `chequera_tipo_id` int(10) unsigned NOT NULL,
  `serie` text COLLATE utf8mb4_unicode_ci,
  `numero_cheque` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_cheq_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` (`cta_cte_tesoreria_banco_id`),
  KEY `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` (`chequera_tipo_id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` FOREIGN KEY (`chequera_tipo_id`) REFERENCES `chequeras_tipos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_cheq`
--

LOCK TABLES `cta_cte_tesoreria_banco_cheq` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_claves`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_claves_person_id_foreign` (`person_id`),
  KEY `ct_cuenta_id` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ct_banco_id` (`cta_cte_tesoreria_banco_id`),
  CONSTRAINT `ct_banco_id` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `ct_cuenta_id` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_claves_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_claves`
--

LOCK TABLES `cta_cte_tesoreria_banco_claves` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_claves` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_bancos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `ctacte_banco_id` int(10) unsigned NOT NULL,
  `persona_empresa` int(11) NOT NULL DEFAULT '1',
  `zone_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id_diferido` int(10) unsigned DEFAULT NULL,
  `cuenta_contable_id_pend_acred` int(10) unsigned DEFAULT NULL,
  `numero_cuenta` text COLLATE utf8mb4_unicode_ci,
  `cbu` text COLLATE utf8mb4_unicode_ci,
  `alias` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_bancos_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` (`ctacte_banco_id`),
  KEY `cta_cte_tesoreria_bancos_zone_id_foreign` (`zone_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` (`cuenta_contable_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` (`cuenta_contable_id_diferido`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` (`cuenta_contable_id_pend_acred`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` FOREIGN KEY (`ctacte_banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` FOREIGN KEY (`cuenta_contable_id_diferido`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` FOREIGN KEY (`cuenta_contable_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` FOREIGN KEY (`cuenta_contable_id_pend_acred`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_bancos`
--

LOCK TABLES `cta_cte_tesoreria_bancos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuenta_tipos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuenta_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuenta_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuenta_tipos`
--

LOCK TABLES `cta_cte_tesoreria_cuenta_tipos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuenta_tipos` VALUES (1,NULL,'CAJA',1,NULL,NULL,NULL),(2,NULL,'BANCOS',1,NULL,NULL,NULL),(3,NULL,'CHEQUES',1,NULL,NULL,NULL),(4,NULL,'RETENCIONES EFECTUADAS',1,NULL,'2024-05-26 20:59:31',NULL),(5,NULL,'PERCEPCIONES EFECTUADAS',1,NULL,'2024-05-26 20:59:31',NULL),(6,NULL,'RESULTADO NEGATIVO',1,NULL,NULL,NULL),(7,NULL,'RESULTADO POSITIVO',1,NULL,NULL,NULL),(8,NULL,'MOVIMIENTO',1,NULL,NULL,NULL),(9,NULL,'RETENCIONES SUFRIDAS',1,NULL,NULL,NULL),(10,NULL,'PERCEPCIONES SUFRIDAS',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuentas`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_tipo_id` int(10) unsigned NOT NULL DEFAULT '8',
  `retention_type_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cuit` text COLLATE utf8mb4_unicode_ci,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_cuentas_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `cta_tes_tipo_id_foreign` (`cta_cte_tesoreria_cuenta_tipo_id`),
  KEY `cta_cte_tesoreria_cuentas_moneda_id_foreign` (`moneda_id`),
  KEY `cta_cte_tesoreria_cuentas_retention_type_id_foreign` (`retention_type_id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_retention_type_id_foreign` FOREIGN KEY (`retention_type_id`) REFERENCES `retention_types` (`id`),
  CONSTRAINT `cta_tes_tipo_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_tipo_id`) REFERENCES `cta_cte_tesoreria_cuenta_tipos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=757 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuentas`
--

LOCK TABLES `cta_cte_tesoreria_cuentas` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (13,NULL,1,13,NULL,8,NULL,'Clientes - Deudores',NULL,0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(20,NULL,1,20,NULL,8,NULL,'Anticipos Impuesto a las Ganancias',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(23,NULL,1,23,NULL,4,NULL,'Retenciones Impuesto a las Ganancias',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(25,NULL,1,25,NULL,4,NULL,'Retenciones de IVA',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(57,NULL,1,57,NULL,8,NULL,'Proveedores en Cta. Cte. locales',NULL,0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(60,NULL,1,60,NULL,3,NULL,'Cheques emitidos ',NULL,0,1,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(62,NULL,1,62,NULL,8,NULL,'Sueldos y Jornales a pagar',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(140,NULL,1,140,NULL,6,NULL,'Intereses y Gastos bancarios',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(162,NULL,1,162,NULL,4,NULL,'Retenciones SUSS',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(176,NULL,1,176,NULL,3,NULL,'Cheques en Cartera',NULL,1,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(201,NULL,1,201,NULL,6,NULL,'Monotributo',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(203,NULL,1,203,NULL,6,NULL,'Autonomos',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(219,NULL,1,219,NULL,8,NULL,'Pagos AFIP',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(251,NULL,1,251,NULL,4,NULL,'Retenciones de IIBB Buenos Aires',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(252,NULL,1,252,NULL,4,NULL,'Retenciones de IIBB Capital Federal',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(253,NULL,1,253,NULL,4,NULL,'Retenciones de IIBB Catamarca',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(254,NULL,1,254,NULL,4,NULL,'Retenciones de IIBB Chaco',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(255,NULL,1,255,NULL,4,NULL,'Retenciones de IIBB Chubut',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(256,NULL,1,256,NULL,4,NULL,'Retenciones de IIBB Córdoba',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(257,NULL,1,257,NULL,4,NULL,'Retenciones de IIBB Corrientes',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(258,NULL,1,258,NULL,4,NULL,'Retenciones de IIBB Entre Ríos',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(259,NULL,1,259,NULL,4,NULL,'Retenciones de IIBB Formosa',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(260,NULL,1,260,NULL,4,NULL,'Retenciones de IIBB Jujuy',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(261,NULL,1,261,NULL,4,NULL,'Retenciones de IIBB La Pampa',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(262,NULL,1,262,NULL,4,NULL,'Retenciones de IIBB La Rioja',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(263,NULL,1,263,NULL,4,NULL,'Retenciones de IIBB Mendoza',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(264,NULL,1,264,NULL,4,NULL,'Retenciones de IIBB Misiones',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(265,NULL,1,265,NULL,4,NULL,'Retenciones de IIBB Neuquén',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(266,NULL,1,266,NULL,4,NULL,'Retenciones de IIBB Pascua Lama',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(267,NULL,1,267,NULL,4,NULL,'Retenciones de IIBB Río Negro',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(268,NULL,1,268,NULL,4,NULL,'Retenciones de IIBB Salta',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(269,NULL,1,269,NULL,4,NULL,'Retenciones de IIBB San Juan',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (270,NULL,1,270,NULL,4,NULL,'Retenciones de IIBB San Luis',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(271,NULL,1,271,NULL,4,NULL,'Retenciones de IIBB Santa Cruz',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(272,NULL,1,272,NULL,4,NULL,'Retenciones de IIBB Santa Fe',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(273,NULL,1,273,NULL,4,NULL,'Retenciones de IIBB Santiago del Estero',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(274,NULL,1,274,NULL,4,NULL,'Retenciones de IIBB Tierra del Fuego',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(275,NULL,1,275,NULL,4,NULL,'Retenciones de IIBB Tucuman',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(351,NULL,1,351,NULL,8,NULL,'BANCO SIRCREB',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(359,NULL,1,359,NULL,8,NULL,'Caja en Pesos',NULL,0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:16:02','2023-03-20 23:16:02'),(360,NULL,1,360,NULL,8,NULL,'Retenciones Bancarias de Ganancias a Favor',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(364,NULL,1,364,NULL,8,NULL,'Anticipo de Clientes',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(384,NULL,1,384,NULL,8,NULL,'Caja en Dolares',NULL,0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:16:02','2023-03-20 23:16:02'),(409,NULL,1,409,NULL,6,NULL,'IVA Crédito Fiscal No computable',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(418,NULL,1,418,NULL,8,NULL,'Deudas Bancarias',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(433,NULL,1,433,NULL,8,NULL,'Préstamo',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(441,NULL,1,441,NULL,8,NULL,'Leasing',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(448,NULL,1,448,NULL,8,NULL,'Planes de Pagos AFIP',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(450,NULL,1,450,NULL,3,NULL,'Cheques Rechazados',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(467,NULL,1,467,NULL,6,NULL,'Interés',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:25',NULL),(468,NULL,1,14,NULL,8,NULL,'Deudores por ventas comunes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(469,NULL,1,15,NULL,8,NULL,'Deudores por ventas morosos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(470,NULL,1,16,NULL,8,NULL,'Deudores en gestión judicial',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(471,NULL,1,17,NULL,8,NULL,'Previsión deudores incobrables',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(472,NULL,1,22,NULL,8,NULL,'Anticipo Impto.Ganancia Mínima Presunta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(473,NULL,1,24,NULL,4,NULL,'Impuesto a las Ganancias (Saldo a favor)',NULL,0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:56:05',NULL),(474,NULL,1,27,NULL,8,NULL,'Anticipos de proveedores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(475,NULL,1,28,NULL,8,NULL,'Depósito en garantía alquileres',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(476,NULL,1,29,NULL,8,NULL,'Derechos adquiridos a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(477,NULL,1,30,NULL,8,NULL,'Intereses a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(478,NULL,1,31,NULL,8,NULL,'Cuentas a rendir - Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(479,NULL,1,32,NULL,8,NULL,'Alquileres no devengados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(480,NULL,1,38,NULL,8,NULL,'Equipos de computación valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (481,NULL,1,39,NULL,8,NULL,'Equipos de computación ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(482,NULL,1,40,NULL,8,NULL,'Amortización Acumulada Equipos de comput.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(483,NULL,1,42,NULL,8,NULL,'Instalaciones valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(484,NULL,1,43,NULL,8,NULL,'Instalaciones ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(485,NULL,1,44,NULL,8,NULL,'Amortización Acumulada Instalaciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(486,NULL,1,46,NULL,8,NULL,'Muebles y utiles valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(487,NULL,1,47,NULL,8,NULL,'Muebles y utiles ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(488,NULL,1,48,NULL,8,NULL,'Amortización Acumulada Muebles y Útiles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(489,NULL,1,50,NULL,8,NULL,'Gastos de organización valores historicos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(490,NULL,1,51,NULL,8,NULL,'Gastos de organización ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(491,NULL,1,52,NULL,8,NULL,'Amortización acumulada gs. de organización',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(492,NULL,1,58,NULL,8,NULL,'Proveedores en cta. cte. exterior',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(493,NULL,1,59,NULL,8,NULL,'Derechos de exhibición a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(494,NULL,1,63,NULL,8,NULL,'Cargas sociales a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(495,NULL,1,64,NULL,8,NULL,'Sindicatos a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(496,NULL,1,67,NULL,8,NULL,'IVA Debito Fiscal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(497,NULL,1,68,NULL,8,NULL,'IVA Credito Fiscal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(498,NULL,1,69,NULL,8,NULL,'Impuestos Internos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(499,NULL,1,70,NULL,8,NULL,'Impuestos al Combustible',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(500,NULL,1,71,NULL,8,NULL,'IVA Retenciones de terceros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(501,NULL,1,72,NULL,5,NULL,'IVA Percepciones realiz.por terceros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(502,NULL,1,73,NULL,8,NULL,'IVA Saldo a favor',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(503,NULL,1,74,NULL,8,NULL,'IVA a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(504,NULL,1,75,NULL,5,NULL,'Percepciones Ingresos Brutos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(505,NULL,1,76,NULL,8,NULL,'Otros Pagos AFIP',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(506,NULL,1,78,NULL,8,NULL,'Impuesto a los Ingresos Brutos Pasivo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(507,NULL,1,79,NULL,8,NULL,'Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(508,NULL,1,80,NULL,8,NULL,'Impuesto a la Ganancia Mínima Presunta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(509,NULL,1,81,NULL,8,NULL,'AFIP - Retenciones Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(510,NULL,1,82,NULL,8,NULL,'AFIP - Plan de Facilidades Decreto 338/02',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(511,NULL,1,87,NULL,8,NULL,'Acciones en circulación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (512,NULL,1,88,NULL,8,NULL,'Ajuste del Capital',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(513,NULL,1,89,NULL,8,NULL,'Aportes Irrevocables Futuras Suscripciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(514,NULL,1,91,NULL,8,NULL,'Resultado del ejercicio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(515,NULL,1,92,NULL,8,NULL,'Resultado ejercicios anteriores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(516,NULL,1,93,NULL,8,NULL,'A.R.E.A.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(517,NULL,1,96,NULL,7,NULL,'VENTAS',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(518,NULL,1,97,NULL,7,NULL,'Honorarios',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(519,NULL,1,99,NULL,7,NULL,'Descuentos obtenidos',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(520,NULL,1,100,NULL,7,NULL,'Reintegros por exportaciones',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(521,NULL,1,102,NULL,7,NULL,'Intereses Cobrados',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(522,NULL,1,103,NULL,7,NULL,'Diferencias de cambio',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(523,NULL,1,104,NULL,7,NULL,'Descuentos obtenidos',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(524,NULL,1,110,NULL,6,NULL,'Sueldos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(525,NULL,1,111,NULL,6,NULL,'Contribuciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(526,NULL,1,112,NULL,6,NULL,'Sindicato',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(527,NULL,1,114,NULL,8,NULL,'ACA',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(528,NULL,1,115,NULL,6,NULL,'Aereos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(529,NULL,1,116,NULL,6,NULL,'Alquiler',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(530,NULL,1,117,NULL,8,NULL,'AGUA AYSA',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(531,NULL,1,118,NULL,8,NULL,'TV Cablevision',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(532,NULL,1,119,NULL,1,NULL,'Caja Jubilacion Consejo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(533,NULL,1,120,NULL,6,NULL,'Celulares',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(534,NULL,1,121,NULL,3,NULL,'Cheques',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(535,NULL,1,123,NULL,8,NULL,'Comida',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(536,NULL,1,126,NULL,6,NULL,'Fletes y acarreos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(537,NULL,1,127,NULL,8,NULL,'Luz Edesur',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(538,NULL,1,128,NULL,6,NULL,'Movilidad y Viáticos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(539,NULL,1,129,NULL,8,NULL,'Mantenimiento',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(540,NULL,1,130,NULL,8,NULL,'IVA No Computable',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(541,NULL,1,131,NULL,8,NULL,'Entretenimiento',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(542,NULL,1,132,NULL,6,NULL,'Amortización Bienes de Uso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(543,NULL,1,135,NULL,6,NULL,'Gastos varios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(544,NULL,1,136,NULL,6,NULL,'Ajuste por redondeo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(545,NULL,1,137,NULL,6,NULL,'Deudores Incobrables',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (546,NULL,1,141,NULL,6,NULL,'Intereses Proveedores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(547,NULL,1,143,NULL,6,NULL,'Diferencias de cambio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(548,NULL,1,144,NULL,8,NULL,'Diferencia de Cambio Bces. en M.Extranjera',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(549,NULL,1,145,NULL,6,NULL,'Diferencia tipo cambio Vendedor/Comprador',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(550,NULL,1,146,NULL,8,NULL,'Diferencia por conversion en Bce. en Mon. Extranj.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(551,NULL,1,147,NULL,8,NULL,'Diferencia de cambio CMV',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(552,NULL,1,148,NULL,8,NULL,'Diferencia de cambio PT',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(553,NULL,1,149,NULL,8,NULL,'Resultado por Exposición a la Inflación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(554,NULL,1,150,NULL,8,NULL,'Diferencia de cambio PE',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(555,NULL,1,151,NULL,8,NULL,'Diferencia de cambio Ds.Vtas.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(556,NULL,1,152,NULL,6,NULL,'Diferencia de cambio ME',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(557,NULL,1,153,NULL,6,NULL,'Descuentos otorgados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(558,NULL,1,155,NULL,6,NULL,'Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(559,NULL,1,156,NULL,6,NULL,'Impuesto a los Ingresos Brutos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(560,NULL,1,157,NULL,6,NULL,'Impuesto al Debito y Credito Bancario',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(561,NULL,1,159,NULL,6,NULL,'Pérdida por venta bienes de uso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(562,NULL,1,160,NULL,6,NULL,'Inversiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(563,NULL,1,161,NULL,6,NULL,'Amortizaciones extraordinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(564,NULL,1,178,NULL,8,NULL,'Google',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(565,NULL,1,188,NULL,6,NULL,'Publicidad',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(566,NULL,1,191,NULL,6,NULL,'Cargas Sociales',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(567,NULL,1,192,NULL,6,NULL,'Honorarios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(568,NULL,1,193,NULL,6,NULL,'Telefono Fijo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(569,NULL,1,198,NULL,6,NULL,'Seguros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(570,NULL,1,199,NULL,6,NULL,'Internet',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(571,NULL,1,204,NULL,6,NULL,'Multas Impositivas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(572,NULL,1,208,NULL,6,NULL,'Impuesto a los Ingresos Brutos - BS AS',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(573,NULL,1,209,NULL,6,NULL,'SIRCREB',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(574,NULL,1,212,NULL,6,NULL,'Tarjeta Visa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(575,NULL,1,213,NULL,6,NULL,'Tarjeta American Express',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(576,NULL,1,214,NULL,6,NULL,'Tarjeta Mastercard',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(577,NULL,1,215,NULL,8,NULL,'Tarjeta Shopping',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (578,NULL,1,216,NULL,6,NULL,'Tarjeta Cencosud',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(579,NULL,1,217,NULL,6,NULL,'Compras',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(580,NULL,1,218,NULL,7,NULL,'Ventas No Gravadas',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(581,NULL,1,220,NULL,5,NULL,'Perc IVA -RG3337',NULL,0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:56:05',NULL),(582,NULL,1,221,NULL,6,NULL,'Imps. Internos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(583,NULL,1,222,NULL,6,NULL,'Imp. Gasoil',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(584,NULL,1,223,NULL,6,NULL,'Imp. Hídricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(585,NULL,1,224,NULL,6,NULL,'ITC',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(586,NULL,1,225,NULL,5,NULL,'Perc IIBB  Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(587,NULL,1,226,NULL,5,NULL,'Perc IIBB  Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(588,NULL,1,227,NULL,5,NULL,'Perc IIBB  Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(589,NULL,1,228,NULL,5,NULL,'Perc IIBB  Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(590,NULL,1,229,NULL,5,NULL,'Perc IIBB  Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(591,NULL,1,230,NULL,5,NULL,'Perc IIBB  Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(592,NULL,1,231,NULL,5,NULL,'Perc IIBB  Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(593,NULL,1,232,NULL,5,NULL,'Perc IIBB  Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(594,NULL,1,233,NULL,5,NULL,'Perc IIBB  Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(595,NULL,1,234,NULL,5,NULL,'Perc IIBB  Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(596,NULL,1,235,NULL,5,NULL,'Perc IIBB  La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(597,NULL,1,236,NULL,5,NULL,'Perc IIBB  La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(598,NULL,1,237,NULL,5,NULL,'Perc IIBB  Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(599,NULL,1,238,NULL,5,NULL,'Perc IIBB  Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(600,NULL,1,239,NULL,5,NULL,'Perc IIBB  Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(601,NULL,1,240,NULL,5,NULL,'Perc IIBB  Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(602,NULL,1,241,NULL,5,NULL,'Perc IIBB  Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(603,NULL,1,242,NULL,5,NULL,'Perc IIBB  Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(604,NULL,1,243,NULL,5,NULL,'Perc IIBB  San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(605,NULL,1,244,NULL,5,NULL,'Perc IIBB  San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(606,NULL,1,245,NULL,5,NULL,'Perc IIBB  Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(607,NULL,1,246,NULL,5,NULL,'Perc IIBB  Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(608,NULL,1,247,NULL,5,NULL,'Perc IIBB  Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(609,NULL,1,248,NULL,5,NULL,'Perc IIBB  Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(610,NULL,1,249,NULL,5,NULL,'Perc IIBB  Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (611,NULL,1,250,NULL,6,NULL,'Compras No Gravadas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(612,NULL,1,276,NULL,6,NULL,'SIRCREB Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(613,NULL,1,277,NULL,6,NULL,'SIRCREB Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(614,NULL,1,278,NULL,6,NULL,'SIRCREB Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(615,NULL,1,279,NULL,6,NULL,'SIRCREB Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(616,NULL,1,280,NULL,6,NULL,'SIRCREB Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(617,NULL,1,281,NULL,6,NULL,'SIRCREB Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(618,NULL,1,282,NULL,6,NULL,'SIRCREB Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(619,NULL,1,283,NULL,6,NULL,'SIRCREB Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(620,NULL,1,284,NULL,6,NULL,'SIRCREB Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(621,NULL,1,285,NULL,6,NULL,'SIRCREB Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(622,NULL,1,286,NULL,6,NULL,'SIRCREB La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(623,NULL,1,287,NULL,6,NULL,'SIRCREB La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(624,NULL,1,288,NULL,6,NULL,'SIRCREB Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(625,NULL,1,289,NULL,6,NULL,'SIRCREB Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(626,NULL,1,290,NULL,6,NULL,'SIRCREB Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(627,NULL,1,291,NULL,6,NULL,'SIRCREB Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(628,NULL,1,292,NULL,6,NULL,'SIRCREB Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(629,NULL,1,293,NULL,6,NULL,'SIRCREB Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(630,NULL,1,294,NULL,6,NULL,'SIRCREB San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(631,NULL,1,295,NULL,6,NULL,'SIRCREB San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(632,NULL,1,296,NULL,6,NULL,'SIRCREB Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(633,NULL,1,297,NULL,6,NULL,'SIRCREB Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(634,NULL,1,298,NULL,6,NULL,'SIRCREB Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(635,NULL,1,299,NULL,6,NULL,'SIRCREB Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(636,NULL,1,300,NULL,6,NULL,'SIRCREB Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(637,NULL,1,301,NULL,8,NULL,'IIBB a Favor Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(638,NULL,1,302,NULL,8,NULL,'IIBB a Favor Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(639,NULL,1,303,NULL,8,NULL,'IIBB a Favor Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(640,NULL,1,304,NULL,8,NULL,'IIBB a Favor Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(641,NULL,1,305,NULL,8,NULL,'IIBB a Favor Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(642,NULL,1,306,NULL,8,NULL,'IIBB a Favor Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(643,NULL,1,307,NULL,8,NULL,'IIBB a Favor Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (644,NULL,1,308,NULL,8,NULL,'IIBB a Favor Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(645,NULL,1,309,NULL,8,NULL,'IIBB a Favor Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(646,NULL,1,310,NULL,8,NULL,'IIBB a Favor Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(647,NULL,1,311,NULL,8,NULL,'IIBB a Favor La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(648,NULL,1,312,NULL,8,NULL,'IIBB a Favor La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(649,NULL,1,313,NULL,8,NULL,'IIBB a Favor Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:25',NULL),(650,NULL,1,314,NULL,8,NULL,'IIBB a Favor Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:25',NULL),(651,NULL,1,315,NULL,8,NULL,'IIBB a Favor Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(652,NULL,1,316,NULL,8,NULL,'IIBB a Favor Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(653,NULL,1,317,NULL,8,NULL,'IIBB a Favor Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(654,NULL,1,318,NULL,8,NULL,'IIBB a Favor Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(655,NULL,1,319,NULL,8,NULL,'IIBB a Favor San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(656,NULL,1,320,NULL,8,NULL,'IIBB a Favor San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(657,NULL,1,321,NULL,8,NULL,'IIBB a Favor Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(658,NULL,1,322,NULL,8,NULL,'IIBB a Favor Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(659,NULL,1,323,NULL,8,NULL,'IIBB a Favor Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(660,NULL,1,324,NULL,8,NULL,'IIBB a Favor Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(661,NULL,1,325,NULL,8,NULL,'IIBB a Favor Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(662,NULL,1,326,NULL,8,NULL,'IIBB a Pagar Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(663,NULL,1,327,NULL,8,NULL,'IIBB a Pagar Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(664,NULL,1,328,NULL,8,NULL,'IIBB a Pagar Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(665,NULL,1,329,NULL,8,NULL,'IIBB a Pagar Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(666,NULL,1,330,NULL,8,NULL,'IIBB a Pagar Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(667,NULL,1,331,NULL,8,NULL,'IIBB a Pagar Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(668,NULL,1,332,NULL,8,NULL,'IIBB a Pagar Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(669,NULL,1,333,NULL,8,NULL,'IIBB a Pagar Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(670,NULL,1,334,NULL,8,NULL,'IIBB a Pagar Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(671,NULL,1,335,NULL,8,NULL,'IIBB a Pagar Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(672,NULL,1,336,NULL,8,NULL,'IIBB a Pagar La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(673,NULL,1,337,NULL,8,NULL,'IIBB a Pagar La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(674,NULL,1,338,NULL,8,NULL,'IIBB a Pagar Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(675,NULL,1,339,NULL,8,NULL,'IIBB a Pagar Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (676,NULL,1,340,NULL,8,NULL,'IIBB a Pagar Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(677,NULL,1,341,NULL,8,NULL,'IIBB a Pagar Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(678,NULL,1,342,NULL,8,NULL,'IIBB a Pagar Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(679,NULL,1,343,NULL,8,NULL,'IIBB a Pagar Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(680,NULL,1,344,NULL,8,NULL,'IIBB a Pagar San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(681,NULL,1,345,NULL,8,NULL,'IIBB a Pagar San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(682,NULL,1,346,NULL,8,NULL,'IIBB a Pagar Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(683,NULL,1,347,NULL,8,NULL,'IIBB a Pagar Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(684,NULL,1,348,NULL,8,NULL,'IIBB a Pagar Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(685,NULL,1,349,NULL,8,NULL,'IIBB a Pagar Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(686,NULL,1,350,NULL,8,NULL,'IIBB a Pagar Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(687,NULL,1,352,NULL,8,NULL,'Compensacion',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(688,NULL,1,353,NULL,8,NULL,'IVA Saldo Tecnico',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(689,NULL,1,354,NULL,8,NULL,'IVA Saldo Libre Disponibilidad',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(690,NULL,1,361,NULL,8,NULL,'Equipos de Computación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(691,NULL,1,362,NULL,8,NULL,'Computadoras',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(692,NULL,1,363,NULL,8,NULL,'Muebles y Utiles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(693,NULL,1,365,NULL,8,NULL,'Provision Honorarios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(694,NULL,1,366,NULL,8,NULL,'Cta. Cte Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(695,NULL,1,367,NULL,8,NULL,'Provisión Honorarios Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(696,NULL,1,368,NULL,8,NULL,'Cuenta Particular Socio 1',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(697,NULL,1,369,NULL,8,NULL,'Capital',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(698,NULL,1,380,NULL,8,NULL,'Instalaciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(699,NULL,1,381,NULL,8,NULL,'Reserva Legal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(700,NULL,1,382,NULL,8,NULL,'Reserva Legal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(701,NULL,1,383,NULL,8,NULL,'Resultado no asignado',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(702,NULL,1,386,NULL,8,NULL,'PLAZO FIJO',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(703,NULL,1,388,NULL,8,NULL,'ACCIONES',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(704,NULL,1,389,NULL,8,NULL,'Inmuebles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(705,NULL,1,390,NULL,8,NULL,'Vehiculos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(706,NULL,1,391,NULL,8,NULL,'Maquinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(707,NULL,1,392,NULL,8,NULL,'MERCADERIAS',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(708,NULL,1,393,NULL,8,NULL,'OTROS',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (709,NULL,1,395,NULL,8,NULL,'Cuenta Particular Socio 2',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(710,NULL,1,396,NULL,6,NULL,'Comisiones Y gastos Bancarios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(711,NULL,1,411,NULL,8,NULL,'Provisión Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(712,NULL,1,412,NULL,6,NULL,'Amortización Muebles y Útiles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(713,NULL,1,413,NULL,6,NULL,'Amortización Equipos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(714,NULL,1,414,NULL,8,NULL,'Amortizacion Acumulada Equipos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(715,NULL,1,415,NULL,8,NULL,'Amortización Acumulada Maquinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(716,NULL,1,416,NULL,8,NULL,'Materias Primas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(717,NULL,1,419,NULL,8,NULL,'Rodados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(718,NULL,1,420,NULL,8,NULL,'Amortización Acumulada Rodados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(719,NULL,1,421,NULL,8,NULL,'Amortización Rodados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(720,NULL,1,422,NULL,8,NULL,'Amortización Maquinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(721,NULL,1,423,NULL,8,NULL,'Accesorios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(722,NULL,1,424,NULL,8,NULL,'Amortización Acumulada Accesorios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(723,NULL,1,426,NULL,8,NULL,'Reserva Facultativa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(724,NULL,1,427,NULL,8,NULL,'Créditos por Impuestos Diferidos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(725,NULL,1,428,NULL,8,NULL,'Fondo de Comercio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(726,NULL,1,429,NULL,8,NULL,'Amortizacion Acumulada Fondo de Comercio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(727,NULL,1,430,NULL,8,NULL,'Intereses a devengar AGIP',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(728,NULL,1,431,NULL,8,NULL,'PFP IIBB',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(729,NULL,1,434,NULL,8,NULL,'Productos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(730,NULL,1,435,NULL,8,NULL,'Intereses a devengar PFP',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(731,NULL,1,437,NULL,8,NULL,'Imp. Ley 25413 Cred 0.6%',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(732,NULL,1,438,NULL,8,NULL,'Honorarios Directorio a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(733,NULL,1,439,NULL,8,NULL,'Reserva para Futuras Inversiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(734,NULL,1,440,NULL,8,NULL,'TEAC - Trabajos Ejecutados a Certificar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(735,NULL,1,444,NULL,8,NULL,'Banco Santander Rio Cta Cte',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(736,NULL,1,449,NULL,8,NULL,'Leasing',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(737,NULL,1,453,NULL,8,NULL,'Inversión Central Caribe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(738,NULL,1,454,NULL,8,NULL,'Otras Inversiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(739,NULL,1,455,NULL,8,NULL,'Otros Créditos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(740,NULL,1,456,NULL,8,NULL,'Provisión Honorarios Socio Gerente',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (741,NULL,1,459,NULL,8,NULL,'Moratoria SUSS a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(742,NULL,1,460,NULL,8,NULL,'Impuestos Municipales a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(743,NULL,1,461,NULL,6,NULL,'Amortización Instalaciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(744,NULL,1,462,NULL,8,NULL,'Amortización Equipos de comput.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(745,NULL,1,463,NULL,8,NULL,'Cuenta Particular Socio 3',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(746,NULL,1,464,NULL,8,NULL,'Cuenta Particular Socio 4',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(747,NULL,1,465,NULL,8,NULL,'Otras Reservas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(748,NULL,1,466,NULL,8,NULL,'IGMP (Saldo a Favor)',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(749,NULL,1,468,NULL,8,NULL,'Productos en Proceso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(750,NULL,1,469,NULL,8,NULL,'Depósitos en Garantía Socio Gerente',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(751,NULL,1,470,NULL,8,NULL,'Fondos Embargados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(752,NULL,1,471,NULL,8,NULL,'Cuota Solid.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(753,NULL,1,472,NULL,8,NULL,'Anticipo Honorarios Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(754,NULL,1,473,NULL,8,NULL,'SICORE a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(755,NULL,1,476,NULL,6,NULL,'RECPAM',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL),(756,NULL,1,478,NULL,6,NULL,'CO2 - Imp. Al Carbono',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:26',NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_detail`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `is_conciliado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_detail_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_detail_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_detail`
--

LOCK TABLES `cta_cte_tesoreria_detail` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos`
--

DROP TABLE IF EXISTS `ctacte_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigoBCRA` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos`
--

LOCK TABLES `ctacte_bancos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos` DISABLE KEYS */;
INSERT INTO `ctacte_bancos` VALUES (1,NULL,'BANCO DE GALICIA Y BUENOS AIRES S.A.',7,NULL,NULL,NULL),(2,NULL,'BANCO DE LA NACION ARGENTINA',11,NULL,NULL,NULL),(3,NULL,'BANCO DE LA PROVINCIA DE BUENOS AIRES',14,NULL,NULL,NULL),(4,NULL,'INDUSTRIAL AND COMMERCIAL BANK OF CHINA',15,NULL,NULL,NULL),(5,NULL,'CITIBANK N.A.',16,NULL,NULL,NULL),(6,NULL,'BBVA BANCO FRANCES S.A.',17,NULL,NULL,NULL),(7,NULL,'THE BANK OF TOKYO-MITSUBISHI UFJ, LTD.',18,NULL,NULL,NULL),(8,NULL,'BANCO DE LA PROVINCIA DE CORDOBA S.A.',20,NULL,NULL,NULL),(9,NULL,'BANCO SUPERVIELLE S.A.',27,NULL,NULL,NULL),(10,NULL,'BANCO DE LA CIUDAD DE BUENOS AIRES',29,NULL,NULL,NULL),(11,NULL,'BANCO PATAGONIA S.A.',34,NULL,NULL,NULL),(12,NULL,'BANCO HIPOTECARIO S.A.',44,NULL,NULL,NULL),(13,NULL,'BANCO DE SAN JUAN S.A.',45,NULL,NULL,NULL),(14,NULL,'BANCO DEL TUCUMAN S.A.',60,NULL,NULL,NULL),(15,NULL,'BANCO MUNICIPAL DE ROSARIO',65,NULL,NULL,NULL),(16,NULL,'BANCO SANTANDER RIO S.A.',72,NULL,NULL,NULL),(17,NULL,'BANCO DEL CHUBUT S.A.',83,NULL,NULL,NULL),(18,NULL,'BANCO DE SANTA CRUZ S.A.',86,NULL,NULL,NULL),(19,NULL,'BANCO DE LA PAMPA SOCIEDAD DE ECONOMÍA M',93,NULL,NULL,NULL),(20,NULL,'BANCO DE CORRIENTES S.A.',94,NULL,NULL,NULL),(21,NULL,'BANCO PROVINCIA DEL NEUQUÉN SOCIEDAD ANÓ',97,NULL,NULL,NULL),(22,NULL,'BANCO INTERFINANZAS S.A.',147,NULL,NULL,NULL),(23,NULL,'HSBC BANK ARGENTINA S.A.',150,NULL,NULL,NULL),(24,NULL,'JPMORGAN CHASE BANK, NATIONAL ASSOCIATIO',165,NULL,NULL,NULL),(25,NULL,'BANCO CREDICOOP COOPERATIVO LIMITADO',191,NULL,NULL,NULL),(26,NULL,'BANCO DE VALORES S.A.',198,NULL,NULL,NULL),(27,NULL,'BANCO ROELA S.A.',247,NULL,NULL,NULL),(28,NULL,'BANCO MARIVA S.A.',254,NULL,NULL,NULL),(29,NULL,'BANCO ITAU ARGENTINA S.A.',259,NULL,NULL,NULL),(30,NULL,'BANK OF AMERICA, NATIONAL ASSOCIATION',262,NULL,NULL,NULL),(31,NULL,'BNP PARIBAS',266,NULL,NULL,NULL),(32,NULL,'BANCO PROVINCIA DE TIERRA DEL FUEGO',268,NULL,NULL,NULL),(33,NULL,'BANCO DE LA REPUBLICA ORIENTAL DEL URUGU',269,NULL,NULL,NULL),(34,NULL,'BANCO SAENZ S.A.',277,NULL,NULL,NULL),(35,NULL,'BANCO MERIDIAN S.A.',281,NULL,NULL,NULL),(36,NULL,'BANCO MACRO S.A.',285,NULL,NULL,NULL),(37,NULL,'BANCO COMAFI SOCIEDAD ANONIMA',299,NULL,NULL,NULL),(38,NULL,'BANCO DE INVERSION Y COMERCIO EXTERIOR S',300,NULL,NULL,NULL),(39,NULL,'BANCO PIANO S.A.',301,NULL,NULL,NULL),(40,NULL,'BANCO JULIO SOCIEDAD ANONIMA',305,NULL,NULL,NULL),(41,NULL,'BANCO RIOJA SOCIEDAD ANONIMA UNIPERSONAL',309,NULL,NULL,NULL),(42,NULL,'BANCO DEL SOL S.A.',310,NULL,NULL,NULL),(43,NULL,'NUEVO BANCO DEL CHACO S. A.',311,NULL,NULL,NULL),(44,NULL,'BANCO VOII S.A.',312,NULL,NULL,NULL),(45,NULL,'BANCO DE FORMOSA S.A.',315,NULL,NULL,NULL),(46,NULL,'BANCO CMF S.A.',319,NULL,NULL,NULL),(47,NULL,'BANCO DE SANTIAGO DEL ESTERO S.A.',321,NULL,NULL,NULL),(48,NULL,'BANCO INDUSTRIAL S.A.',322,NULL,NULL,NULL),(49,NULL,'NUEVO BANCO DE SANTA FE SOCIEDAD ANONIMA',330,NULL,NULL,NULL),(50,NULL,'BANCO CETELEM ARGENTINA S.A.',331,NULL,NULL,NULL),(51,NULL,'BANCO DE SERVICIOS FINANCIEROS S.A.',332,NULL,NULL,NULL),(52,NULL,'BANCO BRADESCO ARGENTINA S.A.U.',336,NULL,NULL,NULL),(53,NULL,'BANCO DE SERVICIOS Y TRANSACCIONES S.A.',338,NULL,NULL,NULL),(54,NULL,'RCI BANQUE S.A.',339,NULL,NULL,NULL),(55,NULL,'BACS BANCO DE CREDITO Y SECURITIZACION S',340,NULL,NULL,NULL),(56,NULL,'BANCO MASVENTAS S.A.',341,NULL,NULL,NULL),(57,NULL,'BANCO WANAP S.A.',384,NULL,NULL,NULL),(58,NULL,'NUEVO BANCO DE ENTRE RÍOS S.A.',386,NULL,NULL,NULL),(59,NULL,'BANCO COLUMBIA S.A.',389,NULL,NULL,NULL),(60,NULL,'BANCO BICA S.A.',426,NULL,NULL,NULL),(61,NULL,'BANCO COINAG S.A.',431,NULL,NULL,NULL),(62,NULL,'BANCO DE COMERCIO S.A.',432,NULL,NULL,NULL),(63,NULL,'FORD CREDIT COMPAÑIA FINANCIERA S.A.',44059,NULL,NULL,NULL),(64,NULL,'COMPAÑIA FINANCIERA ARGENTINA S.A.',44077,NULL,NULL,NULL),(65,NULL,'VOLKWAGEN FINANCIAL SERVICES CIA.FIN.S.A',44088,NULL,NULL,NULL),(66,NULL,'CORDIAL COMPAÑÍA FINANCIERA S.A.',44090,NULL,NULL,NULL),(67,NULL,'FCA COMPAÑIA FINANCIERA S.A.',44092,NULL,NULL,NULL);
INSERT INTO `ctacte_bancos` VALUES (68,NULL,'GPAT COMPAÑIA FINANCIERA S.A.',44093,NULL,NULL,NULL),(69,NULL,'MERCEDES-BENZ COMPAÑÍA FINANCIERA ARGENT',44094,NULL,NULL,NULL),(70,NULL,'ROMBO COMPAÑÍA FINANCIERA S.A.',44095,NULL,NULL,NULL),(71,NULL,'JOHN DEERE CREDIT COMPAÑÍA FINANCIERA S.',44096,NULL,NULL,NULL),(72,NULL,'PSA FINANCE ARGENTINA COMPAÑÍA FINANCIER',44098,NULL,NULL,NULL),(73,NULL,'TOYOTA COMPAÑÍA FINANCIERA DE ARGENTINA',44099,NULL,NULL,NULL),(74,NULL,'FINANDINO COMPAÑIA FINANCIERA S.A.',44100,NULL,NULL,NULL),(75,NULL,'MONTEMAR COMPAÑIA FINANCIERA S.A.',45056,NULL,NULL,NULL),(76,NULL,'MULTIFINANZAS COMPAÑIA FINANCIERA S.A.',45072,NULL,NULL,NULL),(77,NULL,'CAJA DE CREDITO \"CUENCA\" COOPERATIVA LIM',65203,NULL,NULL,NULL),(78,NULL,'MERCADO PAGO',NULL,NULL,NULL,NULL),(79,NULL,'UALA',NULL,NULL,NULL,NULL),(80,NULL,'ICBC',NULL,NULL,NULL,NULL),(81,NULL,'BMA SAU',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctacte_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos_datos`
--

DROP TABLE IF EXISTS `ctacte_bancos_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos_datos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `num_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cbu` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_bancos_datos_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  CONSTRAINT `ctacte_bancos_datos_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos_datos`
--

LOCK TABLES `ctacte_bancos_datos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_bancos_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_cheques`
--

DROP TABLE IF EXISTS `ctacte_cheques`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_cheques` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `asiento_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id2` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) DEFAULT NULL,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_cobro` date DEFAULT NULL,
  `banco_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `cuit` text COLLATE utf8mb4_unicode_ci,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abierto_cruzado` int(11) NOT NULL DEFAULT '1',
  `is_no_a_la_orden` tinyint(1) NOT NULL DEFAULT '0',
  `numero` int(10) unsigned DEFAULT NULL,
  `foto` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_cheques_asiento_id_foreign` (`asiento_id`),
  KEY `ctacte_cheques_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  KEY `ctacte_cheques_banco_id_foreign` (`banco_id`),
  KEY `ctacte_cheques_person_id_foreign` (`person_id`),
  KEY `ctacte_cheques_cta_cte_cliente_id2_foreign` (`cta_cte_cliente_id2`),
  KEY `ctacte_cheques_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesorer_id` (`cta_cte_tesoreria_id`),
  KEY `ctacte_cheques_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `ctacte_cheques_nf_cta_cte_id2_foreign` (`nf_cta_cte_id2`),
  KEY `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ctacte_cheques_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `ctacte_cheques_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  CONSTRAINT `cta_cte_tesorer_id` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `ctacte_cheques_banco_id_foreign` FOREIGN KEY (`banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id2_foreign` FOREIGN KEY (`cta_cte_cliente_id2`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `ctacte_cheques_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id2_foreign` FOREIGN KEY (`nf_cta_cte_id2`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_cheques`
--

LOCK TABLES `ctacte_cheques` WRITE;
/*!40000 ALTER TABLE `ctacte_cheques` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_cheques` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_centrocosto`
--

DROP TABLE IF EXISTS `ctactegastos_centrocosto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_centrocosto` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_centrocosto`
--

LOCK TABLES `ctactegastos_centrocosto` WRITE;
/*!40000 ALTER TABLE `ctactegastos_centrocosto` DISABLE KEYS */;
INSERT INTO `ctactegastos_centrocosto` VALUES (1,NULL,'OFICINA',NULL,NULL,NULL),(2,NULL,'FIJO',NULL,NULL,NULL),(3,NULL,'VARIABLE',NULL,NULL,NULL),(4,NULL,'GISELA',NULL,NULL,NULL),(5,NULL,'LIA',NULL,NULL,NULL),(6,NULL,'PADRES',NULL,NULL,NULL),(7,NULL,'CASA',NULL,NULL,NULL),(8,NULL,'VANESA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_centrocosto` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_cuenta_tipo`
--

DROP TABLE IF EXISTS `ctactegastos_cuenta_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_cuenta_tipo` (
  `idCuentaTipo` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `idTipo` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`idCuentaTipo`),
  KEY `ctactegastos_cuenta_tipo_idtipo_foreign` (`idTipo`),
  KEY `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_idtipo_foreign` FOREIGN KEY (`idTipo`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_cuenta_tipo`
--

LOCK TABLES `ctactegastos_cuenta_tipo` WRITE;
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` DISABLE KEYS */;
INSERT INTO `ctactegastos_cuenta_tipo` VALUES (1,NULL,NULL,3,NULL,NULL,NULL),(2,NULL,NULL,6,NULL,NULL,NULL),(3,NULL,NULL,3,NULL,NULL,NULL),(4,NULL,NULL,4,NULL,NULL,NULL),(5,NULL,NULL,5,NULL,NULL,NULL),(6,NULL,NULL,3,NULL,NULL,NULL),(7,NULL,NULL,4,NULL,NULL,NULL),(8,NULL,NULL,3,NULL,NULL,NULL),(9,NULL,NULL,4,NULL,NULL,NULL),(10,NULL,NULL,7,NULL,NULL,NULL),(11,NULL,NULL,8,NULL,NULL,NULL),(12,NULL,NULL,3,NULL,NULL,NULL),(13,NULL,NULL,3,NULL,NULL,NULL),(14,NULL,NULL,4,NULL,NULL,NULL),(15,NULL,NULL,1,NULL,NULL,NULL),(16,NULL,NULL,2,NULL,NULL,NULL),(17,NULL,NULL,5,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_mensuales`
--

DROP TABLE IF EXISTS `ctactegastos_mensuales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_mensuales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `CuentaTipo_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `TipoDeGasto_id` int(10) unsigned NOT NULL,
  `CentroCosto_id` int(10) unsigned NOT NULL,
  `gasto_cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `monto` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctactegastos_mensuales_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `ctactegastos_mensuales_tipodegasto_id_foreign` (`TipoDeGasto_id`),
  KEY `ctactegastos_mensuales_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` (`gasto_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_mensuales_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`gasto_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_tipodegasto_id_foreign` FOREIGN KEY (`TipoDeGasto_id`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_mensuales`
--

LOCK TABLES `ctactegastos_mensuales` WRITE;
/*!40000 ALTER TABLE `ctactegastos_mensuales` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctactegastos_mensuales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_tiposdegastos`
--

DROP TABLE IF EXISTS `ctactegastos_tiposdegastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_tiposdegastos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_tiposdegastos`
--

LOCK TABLES `ctactegastos_tiposdegastos` WRITE;
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` DISABLE KEYS */;
INSERT INTO `ctactegastos_tiposdegastos` VALUES (1,NULL,'Oficina',NULL,NULL,NULL),(2,NULL,'Personales',NULL,NULL,NULL),(3,NULL,'Tarjeta VISA',NULL,NULL,NULL),(4,NULL,'Tarjeta Mastercard',NULL,NULL,NULL),(5,NULL,'Debito Automatico',NULL,NULL,NULL),(6,NULL,'American Express',NULL,NULL,NULL),(7,NULL,'Tarjeta Shopping',NULL,NULL,NULL),(8,NULL,'Tarjeta Cencosud',NULL,NULL,NULL),(9,NULL,'Tarjeta Coto',NULL,NULL,NULL),(10,NULL,'Tarjeta Nativa',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos`
--

DROP TABLE IF EXISTS `cursos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fecha` date DEFAULT NULL,
  `hora` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profesor` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cant_clases` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjuntos` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_zoom` longtext COLLATE utf8mb4_unicode_ci,
  `cod_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contraseña_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_youtube` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `materiales` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos`
--

LOCK TABLES `cursos` WRITE;
/*!40000 ALTER TABLE `cursos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos_detail`
--

DROP TABLE IF EXISTS `cursos_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `curso_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cursos_detail_curso_id_foreign` (`curso_id`),
  CONSTRAINT `cursos_detail_curso_id_foreign` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos_detail`
--

LOCK TABLES `cursos_detail` WRITE;
/*!40000 ALTER TABLE `cursos_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `data_types`
--

DROP TABLE IF EXISTS `data_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `data_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `data_types_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `data_types`
--

LOCK TABLES `data_types` WRITE;
/*!40000 ALTER TABLE `data_types` DISABLE KEYS */;
INSERT INTO `data_types` VALUES (1,'Comprobantes XLS',1,'Importación','XLS','data/imports/receipts/xls',NULL,NULL),(2,'CITI-Ventas',1,'Importación','TXT','data/imports/receipts/CitiVentas',NULL,NULL),(3,'CITI Compras',2,'Exportación','TXT','data/exports/receipts/citi',NULL,NULL),(4,'CITI Ventas',2,'Exportación','TXT','data/exports/receipts/CitiVentasExport',NULL,NULL),(5,'Convenio Multilateral',2,'Exportación','TXT','data/exports/receipts/convenio',NULL,NULL),(6,'Libro IVA Digital',2,'Exportación','TXT','data/exports/receipts/libro_iva_digital',NULL,'2019-11-20 21:43:44'),(7,'Mis Comprobantes',1,'Importacion','','data/imports/receipts/mis_comprobantes',NULL,NULL),(8,'Consulta AFIP',3,'AFIP','','data/afip/index','2019-12-06 14:49:55','2019-12-06 14:49:55');
/*!40000 ALTER TABLE `data_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_estados`
--

DROP TABLE IF EXISTS `dc_estados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_estados` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_estados`
--

LOCK TABLES `dc_estados` WRITE;
/*!40000 ALTER TABLE `dc_estados` DISABLE KEYS */;
INSERT INTO `dc_estados` VALUES (1,NULL,'BORRADOR',1,NULL,'2023-08-07 00:01:21',NULL),(2,NULL,'TERMINADO',1,NULL,'2023-08-07 00:01:21',NULL),(3,NULL,'ELIMINADO',1,NULL,'2023-08-13 09:18:41',NULL),(4,NULL,'PAGADO',1,NULL,'2023-08-07 00:01:21','2023-08-07 00:01:21'),(5,NULL,'CONCILIADO',1,NULL,'2023-08-07 00:01:21','2023-08-07 00:01:21');
/*!40000 ALTER TABLE `dc_estados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas`
--

DROP TABLE IF EXISTS `dc_firmas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_firmante_dc` tinyint(1) NOT NULL DEFAULT '0',
  `show_create_dc` tinyint(1) NOT NULL DEFAULT '0',
  `faltan_firmas` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas`
--

LOCK TABLES `dc_firmas` WRITE;
/*!40000 ALTER TABLE `dc_firmas` DISABLE KEYS */;
INSERT INTO `dc_firmas` VALUES (1,NULL,'NO',1,1,0,1,NULL,'2023-08-07 00:01:21',NULL),(2,NULL,'RECHAZADO',1,1,0,1,NULL,'2023-08-07 00:01:21',NULL),(3,NULL,'ACEPTADO',1,0,0,1,NULL,'2023-08-07 00:01:21',NULL),(4,NULL,'FALTAN FIRMAS',0,0,1,1,'2023-08-07 00:01:21','2023-08-07 00:01:21',NULL),(5,NULL,'EMITIDO',1,0,0,1,'2023-10-12 08:08:41','2023-10-12 08:08:41',NULL);
/*!40000 ALTER TABLE `dc_firmas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas_ordenes`
--

DROP TABLE IF EXISTS `dc_firmas_ordenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas_ordenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `user_id_que_firma` int(10) unsigned NOT NULL,
  `dc_firma_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_firmas_ordenes_person_id_foreign` (`person_id`),
  KEY `dc_firmas_ordenes_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_firmas_ordenes_dc_firma_id_foreign` (`dc_firma_id`),
  CONSTRAINT `dc_firmas_ordenes_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_firmas_ordenes_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_firmas_ordenes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas_ordenes`
--

LOCK TABLES `dc_firmas_ordenes` WRITE;
/*!40000 ALTER TABLE `dc_firmas_ordenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_firmas_ordenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas_reglas`
--

DROP TABLE IF EXISTS `dc_firmas_reglas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas_reglas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL,
  `grupos_users_ids` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_firmas_reglas_person_id_foreign` (`person_id`),
  KEY `dc_firmas_reglas_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_firmas_reglas_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_firmas_reglas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas_reglas`
--

LOCK TABLES `dc_firmas_reglas` WRITE;
/*!40000 ALTER TABLE `dc_firmas_reglas` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_firmas_reglas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_de_pago`
--

DROP TABLE IF EXISTS `dc_orden_de_pago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_de_pago` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-09-28 16:32:12',
  `dc_orden_id` bigint(20) unsigned NOT NULL DEFAULT '10',
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dc_estado_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `dc_firma_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_de_pago_person_id_foreign` (`person_id`),
  KEY `dc_orden_de_pago_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `dc_orden_de_pago_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_orden_de_pago_dc_firma_id_foreign` (`dc_firma_id`),
  KEY `dc_orden_de_pago_dc_estado_id_foreign` (`dc_estado_id`),
  CONSTRAINT `dc_orden_de_pago_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `dc_orden_de_pago_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_orden_de_pago_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_orden_de_pago_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_orden_de_pago_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_de_pago`
--

LOCK TABLES `dc_orden_de_pago` WRITE;
/*!40000 ALTER TABLE `dc_orden_de_pago` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_de_pago` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_de_pago_cheques`
--

DROP TABLE IF EXISTS `dc_orden_de_pago_cheques`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_de_pago_cheques` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_de_pago_id` bigint(20) unsigned NOT NULL,
  `ctacte_cheque_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_de_pago_cheques_dc_orden_de_pago_id_foreign` (`dc_orden_de_pago_id`),
  KEY `dc_orden_de_pago_cheques_ctacte_cheque_id_foreign` (`ctacte_cheque_id`),
  CONSTRAINT `dc_orden_de_pago_cheques_ctacte_cheque_id_foreign` FOREIGN KEY (`ctacte_cheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `dc_orden_de_pago_cheques_dc_orden_de_pago_id_foreign` FOREIGN KEY (`dc_orden_de_pago_id`) REFERENCES `dc_orden_de_pago` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_de_pago_cheques`
--

LOCK TABLES `dc_orden_de_pago_cheques` WRITE;
/*!40000 ALTER TABLE `dc_orden_de_pago_cheques` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_de_pago_cheques` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_de_pago_receipts`
--

DROP TABLE IF EXISTS `dc_orden_de_pago_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_de_pago_receipts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_de_pago_id` bigint(20) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_de_pago_receipts_dc_orden_de_pago_id_foreign` (`dc_orden_de_pago_id`),
  KEY `dc_orden_de_pago_receipts_receipt_id_foreign` (`receipt_id`),
  CONSTRAINT `dc_orden_de_pago_receipts_dc_orden_de_pago_id_foreign` FOREIGN KEY (`dc_orden_de_pago_id`) REFERENCES `dc_orden_de_pago` (`id`),
  CONSTRAINT `dc_orden_de_pago_receipts_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_de_pago_receipts`
--

LOCK TABLES `dc_orden_de_pago_receipts` WRITE;
/*!40000 ALTER TABLE `dc_orden_de_pago_receipts` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_de_pago_receipts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_files`
--

DROP TABLE IF EXISTS `dc_orden_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `file` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_files_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_orden_files_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_files`
--

LOCK TABLES `dc_orden_files` WRITE;
/*!40000 ALTER TABLE `dc_orden_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes`
--

DROP TABLE IF EXISTS `dc_ordenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_tipo_id` bigint(20) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `titulo` text COLLATE utf8mb4_unicode_ci,
  `sucursal` int(11) NOT NULL DEFAULT '1',
  `numero` int(11) NOT NULL,
  `sector` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `solicitante` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `syj_empleado_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `fecha_entrega` date DEFAULT NULL,
  `fecha_asignacion` datetime DEFAULT NULL,
  `fecha_cumplido` datetime DEFAULT NULL,
  `condicion_venta_id` int(10) unsigned DEFAULT NULL,
  `is_pago_adelantado` tinyint(1) DEFAULT NULL,
  `forma_de_entrega_id` int(10) unsigned DEFAULT NULL,
  `plazo_de_pago_id` int(10) unsigned DEFAULT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(16,2) NOT NULL DEFAULT '1.00',
  `neto` decimal(16,2) NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `total` decimal(16,2) NOT NULL,
  `facturada` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dc_estado_id` bigint(20) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_cc_id` bigint(20) unsigned DEFAULT NULL,
  `origendestinoable_type` text COLLATE utf8mb4_unicode_ci,
  `origendestinoable_id` int(10) unsigned DEFAULT NULL,
  `is_multiples_ot` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `dc_orden_origen_destino_id` bigint(20) unsigned DEFAULT NULL,
  `is_completado` tinyint(1) NOT NULL DEFAULT '0',
  `dc_firma_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_dc_orden_tipo_id_foreign` (`dc_orden_tipo_id`),
  KEY `dc_ordenes_person_id_foreign` (`person_id`),
  KEY `dc_ordenes_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `dc_ordenes_dc_estado_id_foreign` (`dc_estado_id`),
  KEY `dc_ordenes_conta_cc_id_foreign` (`conta_cc_id`),
  KEY `dc_ordenes_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `dc_ordenes_dc_orden_origen_destino_id_foreign` (`dc_orden_origen_destino_id`),
  KEY `dc_ordenes_moneda_id_foreign` (`moneda_id`),
  KEY `dc_ordenes_dc_firma_id_foreign` (`dc_firma_id`),
  KEY `dc_ordenes_syj_empleado_id_foreign` (`syj_empleado_id`),
  CONSTRAINT `dc_ordenes_conta_cc_id_foreign` FOREIGN KEY (`conta_cc_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `dc_ordenes_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `dc_ordenes_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_ordenes_dc_orden_origen_destino_id_foreign` FOREIGN KEY (`dc_orden_origen_destino_id`) REFERENCES `dc_ordenes_origen_destino` (`id`),
  CONSTRAINT `dc_ordenes_dc_orden_tipo_id_foreign` FOREIGN KEY (`dc_orden_tipo_id`) REFERENCES `dc_ordenes_tipos` (`id`),
  CONSTRAINT `dc_ordenes_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `dc_ordenes_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `dc_ordenes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_ordenes_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_ordenes_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes`
--

LOCK TABLES `dc_ordenes` WRITE;
/*!40000 ALTER TABLE `dc_ordenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_compra_coti`
--

DROP TABLE IF EXISTS `dc_ordenes_compra_coti`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_compra_coti` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_coti_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_compra_coti_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_compra_coti_dc_orden_coti_id_foreign` (`dc_orden_coti_id`),
  CONSTRAINT `dc_ordenes_compra_coti_dc_orden_coti_id_foreign` FOREIGN KEY (`dc_orden_coti_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_compra_coti_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_compra_coti`
--

LOCK TABLES `dc_ordenes_compra_coti` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_compra_coti` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_compra_coti` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_compra_req`
--

DROP TABLE IF EXISTS `dc_ordenes_compra_req`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_compra_req` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_compra_req_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_compra_req_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_compra_req_dc_orden_req_id_foreign` (`dc_orden_req_id`),
  KEY `dc_ordenes_compra_req_dc_orden_req_detail_id_foreign` (`dc_orden_req_detail_id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_req_detail_id_foreign` FOREIGN KEY (`dc_orden_req_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_req_id_foreign` FOREIGN KEY (`dc_orden_req_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_compra_req`
--

LOCK TABLES `dc_ordenes_compra_req` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_compra_req` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_compra_req` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_cotizacion_req`
--

DROP TABLE IF EXISTS `dc_ordenes_cotizacion_req`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_cotizacion_req` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_cotizacion_req_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_cotizacion_req_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_cotizacion_req_dc_orden_req_id_foreign` (`dc_orden_req_id`),
  KEY `dc_ordenes_cotizacion_req_dc_orden_req_detail_id_foreign` (`dc_orden_req_detail_id`),
  CONSTRAINT `dc_ordenes_cotizacion_req_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_cotizacion_req_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_cotizacion_req_dc_orden_req_detail_id_foreign` FOREIGN KEY (`dc_orden_req_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_cotizacion_req_dc_orden_req_id_foreign` FOREIGN KEY (`dc_orden_req_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_cotizacion_req`
--

LOCK TABLES `dc_ordenes_cotizacion_req` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_cotizacion_req` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_cotizacion_req` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_details`
--

DROP TABLE IF EXISTS `dc_ordenes_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_origen_destino_id` bigint(20) unsigned DEFAULT NULL,
  `origendestinoable_id` int(10) unsigned DEFAULT NULL,
  `origendestinoable_type` text COLLATE utf8mb4_unicode_ci,
  `cantidades` decimal(16,2) NOT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id_destino` bigint(20) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `neto` decimal(16,2) NOT NULL,
  `desc_porc` decimal(16,2) DEFAULT NULL,
  `descuento` decimal(16,2) DEFAULT NULL,
 