-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-23897344-4
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-08-02 18:39:07','Actividad Generica 1','000001',NULL),(2,NULL,'2022-08-02 18:39:07','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,'2023-11-05 13:28:29','2023-11-05 13:28:29',NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,'2023-11-05 13:28:57','2023-11-05 13:28:57',NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,'2023-11-05 13:29:13','2023-11-05 13:29:13',NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,'2023-11-05 13:29:24','2023-11-05 13:29:24',NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,'2023-11-05 13:29:38','2023-11-05 13:29:38',NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,'2023-11-05 13:29:51','2023-11-05 13:29:51',NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,'2023-11-05 13:30:02','2023-11-05 13:30:02',NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,'2023-11-05 13:30:18','2023-11-05 13:30:18',NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,'2023-11-05 13:30:34','2023-11-05 13:30:34',NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL),('2023-11','2023-11',2023,11,'2023-11-01','2023-11-30',2816.0628,'2024-01-24 15:47:08','2024-01-24 15:47:08',NULL),('2023-12','2023-12',2023,12,'2023-12-01','2023-12-31',3533.1922,'2024-01-24 15:48:17','2024-01-24 15:48:17',NULL),('2024-1','2024-01',2024,1,'2024-01-01','2024-01-31',4261.5324,'2024-11-12 23:44:40','2024-11-12 23:44:40',NULL),('2024-2','2024-02',2024,2,'2024-02-01','2024-02-28',4825.7881,'2024-11-12 23:45:07','2024-11-12 23:45:07',NULL),('2024-3','2024-03',2024,3,'2024-03-01','2024-03-31',5357.0929,'2024-11-12 23:45:26','2024-11-12 23:45:26',NULL),('2024-4','2024-04',2024,4,'2024-04-01','2024-04-30',5830.2271,'2024-11-12 23:45:43','2024-11-12 23:45:43',NULL),('2024-5','2024-05',2024,5,'2024-05-01','2024-05-31',6073.7165,'2024-11-12 23:46:03','2024-11-12 23:46:03',NULL),('2024-6','2024-06',2024,6,'2024-06-01','2024-06-30',6351.7145,'2024-11-12 23:46:18','2024-11-12 23:46:18',NULL),('2024-7','2024-07',2024,7,'2024-07-01','2024-07-31',6607.7479,'2024-11-12 23:46:34','2024-11-12 23:46:34',NULL),('2024-8','2024-08',2024,8,'2024-08-01','2024-08-31',6883.4412,'2024-11-12 23:46:52','2024-11-12 23:46:52',NULL),('2024-9','2024-09',2024,9,'2024-09-01','2024-09-30',7122.2421,'2024-11-12 23:47:06','2024-11-12 23:47:06',NULL),('2024-10','2024-10',2024,10,'2024-10-01','2024-10-31',7313.9542,'2025-11-05 15:37:13','2025-11-05 15:37:13',NULL),('2024-11','2024-11',2024,11,'2024-11-01','2024-11-30',7491.4314,'2025-11-05 15:37:32','2025-11-05 15:37:32',NULL),('2024-12','2024-12',2024,12,'2024-12-01','2024-12-31',7694.0075,'2025-11-05 15:37:52','2025-11-05 15:37:52',NULL),('2025-1','2025-01',2025,1,'2025-01-01','2025-01-31',7864.1257,'2025-11-05 15:38:06','2025-11-05 15:38:06',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2025-2','2025-02',2025,2,'2025-02-01','2025-02-28',8052.9927,'2025-11-05 15:38:19','2025-11-05 15:38:19',NULL),('2025-3','2025-03',2025,3,'2025-03-01','2025-03-31',8353.3158,'2025-11-05 15:38:31','2025-11-05 15:38:31',NULL),('2025-4','2025-04',2025,4,'2025-04-01','2025-04-30',8585.6078,'2025-11-05 15:38:50','2025-11-05 15:38:50',NULL),('2025-5','2025-05',2025,5,'2025-05-01','2025-05-31',8714.4871,'2025-11-05 15:39:02','2025-11-05 15:39:02',NULL),('2025-6','2025-06',2025,6,'2025-06-01','2025-06-30',8855.5681,'2025-11-05 15:39:14','2025-11-05 15:39:14',NULL),('2025-7','2025-07',2025,7,'2025-07-01','2025-07-31',9023.9730,'2025-11-05 15:39:28','2025-11-05 15:39:28',NULL),('2025-8','2025-08',2025,8,'2025-08-01','2025-08-31',9193.2441,'2025-11-05 15:39:39','2025-11-05 15:39:39',NULL),('2025-9','2025-09',2025,9,'2025-09-01','2025-09-30',9384.0922,'2025-11-05 15:39:54','2025-11-05 15:39:54',NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'PEVsrl2022',NULL,1,40719,'2023-12-12'),(2,NULL,'PEVsrl2022',NULL,1,40719,'2023-12-12'),(3,NULL,'PEVsrl2022',NULL,1,40719,'2023-12-12');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'andrea201206@yahoo.com.ar','1136499329',NULL,1,40719,'2022-08-24'),(2,'andrea201206@yahoo.com.ar','1136499329',NULL,1,40719,'2023-12-12'),(3,'andrea201206@yahoo.com.ar','1136499329','',1,40719,'2023-12-12'),(4,'andrea201206@yahoo.com.ar','1136499329','',1,40719,'2023-12-12');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=121 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (5,3,2,482,NULL,0.00,'2023-11-06 18:55:51','2023-11-06 18:55:51',NULL),(6,3,2,13,NULL,0.00,'2023-11-06 18:55:51','2023-11-06 18:55:51',NULL),(7,3,2,67,NULL,0.00,'2023-11-06 18:55:51','2023-11-06 18:55:51',NULL),(17,5,15,68,NULL,0.00,'2023-11-06 19:01:45','2023-11-06 19:01:45',NULL),(18,5,15,353,NULL,0.00,'2023-11-06 19:01:45','2023-11-06 19:01:45',NULL),(19,5,15,484,NULL,0.00,'2023-11-06 19:01:45','2023-11-06 19:01:45',NULL),(20,5,15,354,NULL,0.00,'2023-11-06 19:01:45','2023-11-06 19:01:45',NULL),(21,5,15,67,NULL,0.00,'2023-11-06 19:01:45','2023-11-06 19:01:45',NULL),(22,5,15,74,NULL,0.00,'2023-11-06 19:01:45','2023-11-06 19:01:45',NULL),(29,7,1,515,NULL,0.00,'2023-11-06 19:10:22','2023-11-06 19:10:22',NULL),(30,7,1,111,NULL,0.00,'2023-11-06 19:10:22','2023-11-06 19:10:22',NULL),(31,7,1,162,NULL,0.00,'2023-11-06 19:10:22','2023-11-06 19:10:22',NULL),(32,7,1,516,NULL,0.00,'2023-11-06 19:10:22','2023-11-06 19:10:22',NULL),(33,7,1,517,NULL,0.00,'2023-11-06 19:10:22','2023-11-06 19:10:22',NULL),(34,7,1,518,NULL,0.00,'2023-11-06 19:10:22','2023-11-06 19:10:22',NULL),(35,7,1,62,NULL,0.00,'2023-11-06 19:10:22','2023-11-06 19:10:22',NULL),(36,7,1,63,NULL,0.00,'2023-11-06 19:10:22','2023-11-06 19:10:22',NULL),(37,7,1,64,NULL,0.00,'2023-11-06 19:10:22','2023-11-06 19:10:22',NULL),(38,7,1,64,NULL,0.00,'2023-11-06 19:10:22','2023-11-06 19:10:22',NULL),(39,8,6,20,NULL,0.00,'2023-11-06 19:38:06','2023-11-06 19:38:06',NULL),(40,8,6,166,NULL,0.00,'2023-11-06 19:38:06','2023-11-06 19:38:06',NULL),(43,10,3,1032,NULL,0.00,'2023-11-06 20:20:34','2023-11-06 20:20:34',NULL),(44,10,3,392,NULL,0.00,'2023-11-06 20:20:34','2023-11-06 20:20:34',NULL),(45,11,3,160,NULL,0.00,'2023-11-07 06:33:34','2023-11-07 06:33:34',NULL),(46,11,3,199,NULL,0.00,'2023-11-07 06:33:34','2023-11-07 06:33:34',NULL),(47,11,3,198,NULL,0.00,'2023-11-07 06:33:34','2023-11-07 06:33:34',NULL),(48,11,3,128,NULL,0.00,'2023-11-07 06:33:34','2023-11-07 06:33:34',NULL),(49,11,3,212,NULL,0.00,'2023-11-07 06:33:34','2023-11-07 06:33:34',NULL),(50,11,3,121,NULL,0.00,'2023-11-07 06:33:34','2023-11-07 06:33:34',NULL),(51,11,3,180,NULL,0.00,'2023-11-07 06:33:34','2023-11-07 06:33:34',NULL),(52,11,3,483,NULL,0.00,'2023-11-07 06:33:34','2023-11-07 06:33:34',NULL),(53,11,3,193,NULL,0.00,'2023-11-07 06:33:34','2023-11-07 06:33:34',NULL),(54,11,3,507,NULL,0.00,'2023-11-07 06:33:34','2023-11-07 06:33:34',NULL),(55,11,3,68,NULL,0.00,'2023-11-07 06:33:34','2023-11-07 06:33:34',NULL),(56,11,3,68,NULL,0.00,'2023-11-07 06:33:34','2023-11-07 06:33:34',NULL),(57,11,3,485,NULL,0.00,'2023-11-07 06:33:34','2023-11-07 06:33:34',NULL),(58,11,3,486,NULL,0.00,'2023-11-07 06:33:34','2023-11-07 06:33:34',NULL),(59,11,3,484,NULL,0.00,'2023-11-07 06:33:34','2023-11-07 06:33:34',NULL),(60,11,3,503,NULL,0.00,'2023-11-07 06:33:34','2023-11-07 06:33:34',NULL),(61,11,3,166,NULL,0.00,'2023-11-07 06:33:34','2023-11-07 06:33:34',NULL),(62,11,3,359,NULL,0.00,'2023-11-07 06:33:34','2023-11-07 06:33:34',NULL),(63,12,16,252,NULL,0.00,'2023-11-07 10:07:11','2023-11-07 10:07:11',NULL),(64,12,16,251,NULL,0.00,'2023-11-07 10:07:12','2023-11-07 10:07:12',NULL),(65,12,16,497,NULL,0.00,'2023-11-07 10:07:12','2023-11-07 10:07:12',NULL),(66,12,16,498,NULL,0.00,'2023-11-07 10:07:12','2023-11-07 10:07:12',NULL),(67,12,16,499,NULL,0.00,'2023-11-07 10:07:12','2023-11-07 10:07:12',NULL),(68,12,16,500,NULL,0.00,'2023-11-07 10:07:12','2023-11-07 10:07:12',NULL),(69,12,16,485,NULL,0.00,'2023-11-07 10:07:12','2023-11-07 10:07:12',NULL),(70,12,16,486,NULL,0.00,'2023-11-07 10:07:12','2023-11-07 10:07:12',NULL),(71,12,16,326,NULL,0.00,'2023-11-07 10:07:12','2023-11-07 10:07:12',NULL),(72,12,16,327,NULL,0.00,'2023-11-07 10:07:12','2023-11-07 10:07:12',NULL),(73,12,16,208,NULL,0.00,'2023-11-07 10:07:12','2023-11-07 10:07:12',NULL),(74,12,16,496,NULL,0.00,'2023-11-07 10:07:12','2023-11-07 10:07:12',NULL),(75,13,1,63,NULL,0.00,'2023-11-07 10:27:50','2023-11-07 10:27:50',NULL);
INSERT INTO `balance_asiento_modelo_detail` VALUES (76,13,1,516,NULL,0.00,'2023-11-07 10:27:50','2023-11-07 10:27:50',NULL),(77,13,1,517,NULL,0.00,'2023-11-07 10:27:50','2023-11-07 10:27:50',NULL),(78,13,1,64,NULL,0.00,'2023-11-07 10:27:50','2023-11-07 10:27:50',NULL),(79,13,1,518,NULL,0.00,'2023-11-07 10:27:50','2023-11-07 10:27:50',NULL),(80,13,1,519,NULL,0.00,'2023-11-07 10:27:50','2023-11-07 10:27:50',NULL),(81,13,1,520,NULL,0.00,'2023-11-07 10:27:50','2023-11-07 10:27:50',NULL),(82,13,1,359,NULL,0.00,'2023-11-07 10:27:50','2023-11-07 10:27:50',NULL),(83,13,1,166,NULL,0.00,'2023-11-07 10:27:50','2023-11-07 10:27:50',NULL),(84,14,20,166,NULL,0.00,'2023-11-07 10:53:30','2023-11-07 10:53:30',NULL),(85,14,20,13,NULL,0.00,'2023-11-07 10:53:30','2023-11-07 10:53:30',NULL),(86,15,19,506,NULL,0.00,'2023-11-09 06:12:26','2023-11-09 06:12:26',NULL),(87,15,19,1033,NULL,0.00,'2023-11-09 06:12:26','2023-11-09 06:12:26',NULL),(88,16,17,359,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(89,16,17,165,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(90,16,17,166,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(91,16,17,13,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(92,16,17,162,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(93,16,17,23,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(94,16,17,68,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(95,16,17,302,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(96,16,17,437,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(97,16,17,20,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(98,16,17,392,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(99,16,17,363,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(100,16,17,48,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(101,16,17,507,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(102,16,17,1038,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(103,16,17,419,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(104,16,17,420,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(105,16,17,57,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(106,16,17,62,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(107,16,17,63,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(108,16,17,64,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(109,16,17,518,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(110,16,17,1027,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(111,16,17,519,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(112,16,17,67,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(113,16,17,368,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(114,16,17,326,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(115,16,17,327,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(116,16,17,506,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(117,16,17,369,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(118,16,17,88,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(119,16,17,91,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL),(120,16,17,92,NULL,0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,7492,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2023-11-06 19:03:46','2023-11-06 19:03:46'),(2,7492,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2023-11-06 19:03:50','2023-11-06 19:03:50'),(3,7492,2,2,'VENTAS',0.00,'2023-11-06 18:55:51','2023-11-06 18:55:51',NULL),(4,7492,2,2,'VENTAS',0.00,'2023-11-06 18:57:39','2023-11-06 19:00:58','2023-11-06 19:00:58'),(5,7492,15,2,'IVA',0.00,'2023-11-06 19:01:45','2023-11-06 19:01:45',NULL),(6,7492,16,2,'IIBB',0.00,'2023-11-06 19:03:15','2023-11-07 10:05:14','2023-11-07 10:05:14'),(7,7492,1,2,'SUELDOS',0.00,'2023-11-06 19:10:22','2023-11-06 19:10:22',NULL),(8,7492,6,2,'PAGO ANTICIPOS',0.00,'2023-11-06 19:38:06','2023-11-06 19:38:06',NULL),(9,7492,3,2,'COSTO DEL SERVICIO',0.00,'2023-11-06 20:19:13','2023-11-06 20:19:46','2023-11-06 20:19:46'),(10,7492,3,2,'COSTO DEL SERVICIO',0.00,'2023-11-06 20:20:34','2023-11-06 20:20:34',NULL),(11,7492,3,2,'COMPRAS',0.00,'2023-11-07 06:33:34','2023-11-07 06:33:34',NULL),(12,7492,16,2,'IIBB',0.00,'2023-11-07 10:07:11','2023-11-07 10:07:11',NULL),(13,7492,1,2,'PAGO SUELDOS /CARGAS SOCIALES',0.00,'2023-11-07 10:27:50','2023-11-07 10:27:50',NULL),(14,7492,20,2,'COBRANZAS',0.00,'2023-11-07 10:53:30','2023-11-07 10:53:30',NULL),(15,7492,19,2,'Devengamiento intereses Afip',0.00,'2023-11-09 06:12:26','2023-11-09 06:12:26',NULL),(16,7492,17,2,'ASIENTO DE CIERRE',0.00,'2025-11-13 12:14:48','2025-11-13 12:14:48',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1422 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7492,40787,102487,2,1,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3194133.80,'INGRESOS POR SERVICIOS',NULL,1,'2022-10-31 10:40:08','2023-03-08 16:47:23','2023-03-08 16:47:23'),(2,7492,40787,102490,3,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',128615.43,NULL,NULL,1,'2022-10-31 12:48:56','2023-11-05 14:01:10','2023-11-05 14:01:10'),(3,7492,40787,102487,3,3,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1357395.67,'Egesos del mes',NULL,1,'2022-10-31 16:09:37','2022-10-31 16:12:16','2022-10-31 16:12:16'),(4,7492,40787,102487,3,4,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1357395.67,'Egesos del mes',NULL,1,'2022-10-31 16:12:16','2023-03-08 16:47:34','2023-03-08 16:47:34'),(5,7492,40787,102487,2,5,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3194133.80,'INGRESOS POR SERVICIOS',NULL,1,'2023-03-08 16:47:23','2023-03-08 16:47:32','2023-03-08 16:47:32'),(6,7492,40787,102487,2,6,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3194133.80,NULL,NULL,1,'2023-03-09 15:34:53','2023-03-16 16:03:33','2023-03-16 16:03:33'),(7,7492,40787,102487,2,7,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3194133.80,NULL,NULL,1,'2023-03-16 16:03:33','2023-11-05 14:01:10','2023-11-05 14:01:10'),(8,7492,40787,102487,3,8,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1357395.67,NULL,NULL,1,'2023-03-16 16:21:32','2023-03-16 16:22:50','2023-03-16 16:22:50'),(9,7492,40787,102487,3,9,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1357395.67,NULL,NULL,1,'2023-03-16 16:22:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(10,7492,40787,102487,16,10,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',118789.94,NULL,NULL,1,'2023-03-16 16:32:41','2023-11-05 14:01:10','2023-11-05 14:01:10'),(11,7492,40787,102487,15,11,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',554353.80,NULL,NULL,1,'2023-03-16 16:38:05','2023-03-16 16:38:50','2023-03-16 16:38:50'),(12,7492,40787,102487,15,12,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',554353.80,NULL,NULL,1,'2023-03-16 16:38:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(13,7492,40787,102488,2,13,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',8550105.23,NULL,NULL,1,'2023-03-16 16:46:53','2023-11-05 14:01:10','2023-11-05 14:01:10'),(14,7492,40787,102488,3,14,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1848790.33,NULL,NULL,1,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(15,7492,40787,102488,3,15,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1848790.33,NULL,NULL,1,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10'),(16,7492,40787,102488,16,16,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',176655.07,NULL,NULL,1,'2023-03-17 15:43:34','2023-11-05 14:01:10','2023-11-05 14:01:10'),(17,7492,40787,102488,15,17,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1483902.56,NULL,NULL,1,'2023-03-17 15:47:11','2023-11-05 14:01:10','2023-11-05 14:01:10'),(18,7492,40787,102489,2,18,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',18408358.15,NULL,NULL,1,'2023-03-17 15:50:54','2023-11-05 14:01:10','2023-11-05 14:01:10');
INSERT INTO `balance_libro` VALUES (19,7492,40787,102489,3,19,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',3511884.04,NULL,NULL,1,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(20,7492,40787,102489,3,20,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',3511884.04,NULL,NULL,1,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(21,7492,40787,102489,16,21,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',380337.98,NULL,NULL,1,'2023-03-17 16:13:28','2023-11-05 14:01:10','2023-11-05 14:01:10'),(22,7492,40787,102489,15,22,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',3194839.02,NULL,NULL,1,'2023-03-17 16:15:54','2023-11-05 14:01:10','2023-11-05 14:01:10'),(23,7492,40787,102490,2,23,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4509016.99,NULL,NULL,1,'2023-03-17 16:39:12','2023-11-05 14:01:10','2023-11-05 14:01:10'),(24,7492,40787,102490,3,24,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4566130.98,NULL,NULL,1,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(25,7492,40787,102490,3,25,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4566130.98,NULL,NULL,1,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(26,7492,40787,102490,16,26,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',51122.67,NULL,NULL,1,'2023-03-20 15:37:28','2023-11-05 14:01:10','2023-11-05 14:01:10'),(27,7492,40787,102490,15,27,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1036015.03,NULL,NULL,1,'2023-03-20 15:42:35','2023-03-20 17:49:21','2023-03-20 17:49:21'),(28,7492,40787,102491,2,28,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',8300712.32,NULL,NULL,1,'2023-03-20 15:45:04','2023-03-20 22:21:03','2023-03-20 22:21:03'),(29,7492,40787,102491,3,29,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',4553149.74,NULL,NULL,1,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(30,7492,40787,102491,16,30,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',171502.32,NULL,NULL,1,'2023-03-20 16:05:18','2023-03-20 16:11:01','2023-03-20 16:11:01'),(31,7492,40787,102491,15,31,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1440619.51,NULL,NULL,1,'2023-03-20 16:09:50','2023-03-20 17:57:25','2023-03-20 17:57:25'),(32,7492,40787,102491,16,32,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',171502.32,NULL,NULL,1,'2023-03-20 16:11:01','2023-03-20 17:55:52','2023-03-20 17:55:52'),(33,7492,40787,102492,2,33,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',14800064.02,NULL,NULL,1,'2023-03-20 16:15:59','2023-03-20 22:22:20','2023-03-20 22:22:20'),(34,7492,40787,102492,3,34,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3156512.86,NULL,NULL,1,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(35,7492,40787,102492,16,35,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',305786.45,NULL,NULL,1,'2023-03-20 16:38:35','2023-03-20 18:00:40','2023-03-20 18:00:40'),(36,7492,40787,102492,15,36,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2568606.15,NULL,NULL,1,'2023-03-20 16:41:23','2023-03-20 22:23:08','2023-03-20 22:23:08');
INSERT INTO `balance_libro` VALUES (37,7492,40787,102490,15,37,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1036015.03,NULL,NULL,1,'2023-03-20 17:49:21','2023-03-20 22:20:35','2023-03-20 22:20:35'),(38,7492,40787,102492,3,38,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3156512.86,NULL,NULL,1,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(39,7492,40787,102491,3,39,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',4553149.74,NULL,NULL,1,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(40,7492,40787,102491,16,40,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',171502.32,NULL,NULL,1,'2023-03-20 17:55:52','2023-03-20 22:21:41','2023-03-20 22:21:41'),(41,7492,40787,102491,15,41,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1440619.51,NULL,NULL,1,'2023-03-20 17:57:25','2023-03-20 22:21:59','2023-03-20 22:21:59'),(42,7492,40787,102492,3,42,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3156512.86,NULL,NULL,1,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(43,7492,40787,102492,16,43,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',305786.45,NULL,NULL,1,'2023-03-20 18:00:40','2023-03-20 22:22:54','2023-03-20 22:22:54'),(44,7492,40787,102491,3,44,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',4553149.74,NULL,NULL,1,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(45,7492,40787,102490,15,45,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1036015.03,NULL,NULL,1,'2023-03-20 22:20:35','2023-11-05 14:01:10','2023-11-05 14:01:10'),(46,7492,40787,102491,2,46,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',8300712.32,NULL,NULL,1,'2023-03-20 22:21:03','2023-11-05 14:01:10','2023-11-05 14:01:10'),(47,7492,40787,102491,3,47,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',4553149.74,NULL,NULL,1,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(48,7492,40787,102491,16,48,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',171502.32,NULL,NULL,1,'2023-03-20 22:21:41','2023-11-05 14:01:10','2023-11-05 14:01:10'),(49,7492,40787,102491,15,49,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1440619.51,NULL,NULL,1,'2023-03-20 22:21:59','2023-11-05 14:01:10','2023-11-05 14:01:10'),(50,7492,40787,102492,2,50,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',14800064.02,NULL,NULL,1,'2023-03-20 22:22:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(51,7492,40787,102492,3,51,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3156512.86,NULL,NULL,1,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(52,7492,40787,102492,16,52,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',305786.45,NULL,NULL,1,'2023-03-20 22:22:54','2023-11-05 14:01:10','2023-11-05 14:01:10'),(53,7492,40787,102492,15,53,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2568606.15,NULL,NULL,1,'2023-03-20 22:23:08','2023-11-05 14:01:10','2023-11-05 14:01:10'),(54,7492,40787,102494,2,54,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7327235.31,NULL,NULL,1,'2023-03-21 15:26:11','2023-11-05 14:01:10','2023-11-05 14:01:10');
INSERT INTO `balance_libro` VALUES (55,7492,40787,102494,3,55,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4996942.29,NULL,NULL,1,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(56,7492,40787,102494,16,56,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',152887.87,NULL,NULL,1,'2023-03-21 15:48:37','2023-03-22 15:52:35','2023-03-22 15:52:35'),(57,7492,40787,102494,15,57,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1271668.94,NULL,NULL,1,'2023-03-21 15:50:44','2023-03-22 15:52:52','2023-03-22 15:52:52'),(58,7492,40787,102495,2,58,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7248764.35,NULL,NULL,1,'2023-03-21 15:52:45','2023-03-22 15:53:05','2023-03-22 15:53:05'),(59,7492,40787,102495,3,59,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2735029.70,NULL,NULL,1,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(60,7492,40787,102495,16,60,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',151627.93,NULL,NULL,1,'2023-03-21 16:10:46','2023-03-22 16:00:42','2023-03-22 16:00:42'),(61,7492,40787,102495,15,61,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1258050.01,NULL,NULL,1,'2023-03-21 16:13:07','2023-03-22 16:00:57','2023-03-22 16:00:57'),(62,7492,40787,102494,3,62,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4996942.29,NULL,NULL,1,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(63,7492,40787,102494,3,63,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4996942.29,NULL,NULL,1,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(64,7492,40787,102494,16,64,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',152887.87,NULL,NULL,1,'2023-03-22 15:52:35','2023-11-05 14:01:10','2023-11-05 14:01:10'),(65,7492,40787,102494,15,65,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1271668.94,NULL,NULL,1,'2023-03-22 15:52:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(66,7492,40787,102495,2,66,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7248764.35,NULL,NULL,1,'2023-03-22 15:53:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(67,7492,40787,102495,3,67,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2735029.70,NULL,NULL,1,'2023-03-22 15:55:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(68,7492,40787,102495,16,68,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',150129.22,NULL,NULL,1,'2023-03-22 16:00:42','2023-11-05 14:01:10','2023-11-05 14:01:10'),(69,7492,40787,102495,15,69,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1258050.01,NULL,NULL,1,'2023-03-22 16:00:57','2023-11-05 14:01:10','2023-11-05 14:01:10'),(70,7492,40787,102487,1,70,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1022518.47,NULL,NULL,1,'2023-04-14 11:48:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(71,7492,40787,102487,1,71,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',431270.67,NULL,NULL,1,'2023-04-14 11:50:37','2023-11-05 14:01:10','2023-11-05 14:01:10'),(72,7492,40787,102487,1,72,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1721.50,NULL,NULL,1,'2023-04-14 11:54:42','2023-10-12 12:57:44','2023-10-12 12:57:44');
INSERT INTO `balance_libro` VALUES (73,7492,40787,102488,1,73,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',381144.17,NULL,NULL,1,'2023-04-14 11:56:48','2023-11-05 14:01:10','2023-11-05 14:01:10'),(74,7492,40787,102488,1,74,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',39019.19,NULL,NULL,1,'2023-04-14 11:59:44','2023-04-14 15:25:53','2023-04-14 15:25:53'),(75,7492,40787,102488,1,75,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1643.78,NULL,NULL,1,'2023-04-14 12:01:34','2023-10-12 12:57:22','2023-10-12 12:57:22'),(76,7492,40787,102488,1,76,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1310488.35,NULL,NULL,1,'2023-04-14 12:06:09','2023-11-05 14:01:10','2023-11-05 14:01:10'),(77,7492,40787,102489,1,77,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',466995.01,NULL,NULL,1,'2023-04-14 12:19:16','2023-11-05 14:01:10','2023-11-05 14:01:10'),(78,7492,40787,102489,1,78,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',48873.19,NULL,NULL,1,'2023-04-14 12:21:10','2023-04-14 15:30:23','2023-04-14 15:30:23'),(79,7492,40787,102490,1,79,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2143.06,NULL,NULL,1,'2023-04-14 12:22:28','2023-04-14 15:28:03','2023-04-14 15:28:03'),(80,7492,40787,102489,1,80,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1541795.32,NULL,NULL,1,'2023-04-14 12:30:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(81,7492,40787,102490,1,81,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',502127.30,NULL,NULL,1,'2023-04-14 12:32:26','2023-11-05 14:01:10','2023-11-05 14:01:10'),(82,7492,40787,102490,1,82,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',55846.00,NULL,NULL,1,'2023-04-14 12:34:12','2023-04-14 15:31:50','2023-04-14 15:31:50'),(83,7492,40787,102490,1,83,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2365.32,NULL,NULL,1,'2023-04-14 12:35:33','2023-10-12 12:56:48','2023-10-12 12:56:48'),(84,7492,40787,102490,1,84,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1609179.31,NULL,NULL,1,'2023-04-14 12:42:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(85,7492,40787,102491,1,85,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',567509.67,NULL,NULL,1,'2023-04-14 12:54:29','2023-11-05 14:01:10','2023-11-05 14:01:10'),(86,7492,40787,102491,1,86,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',58055.63,NULL,NULL,1,'2023-04-14 12:56:19','2023-04-14 15:32:59','2023-04-14 15:32:59'),(87,7492,40787,102491,1,87,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2637.46,NULL,NULL,1,'2023-04-14 12:57:12','2023-10-12 12:56:29','2023-10-12 12:56:29'),(88,7492,40787,102491,1,88,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2282417.78,NULL,NULL,1,'2023-04-14 14:32:37','2023-11-05 14:01:10','2023-11-05 14:01:10'),(89,7492,40787,102492,1,89,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',768911.84,NULL,NULL,1,'2023-04-14 14:34:48','2023-11-05 14:01:10','2023-11-05 14:01:10'),(90,7492,40787,102492,1,90,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',75645.13,NULL,NULL,1,'2023-04-14 14:36:37','2023-04-14 15:34:10','2023-04-14 15:34:10'),(91,7492,40787,102492,1,91,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3779.78,NULL,NULL,1,'2023-04-14 14:37:31','2023-10-12 12:56:11','2023-10-12 12:56:11');
INSERT INTO `balance_libro` VALUES (92,7492,40787,102492,1,92,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3159854.06,NULL,NULL,1,'2023-04-14 14:43:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(93,7492,40787,102494,1,93,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',988340.98,NULL,NULL,1,'2023-04-14 14:45:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(94,7492,40787,102494,1,94,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',79556.41,NULL,NULL,1,'2023-04-14 14:47:40','2023-04-14 15:35:20','2023-04-14 15:35:20'),(95,7492,40787,102494,1,95,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3427.47,NULL,NULL,1,'2023-04-14 14:48:24','2023-10-12 12:55:47','2023-10-12 12:55:47'),(96,7492,40787,102494,1,96,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2055052.50,NULL,NULL,1,'2023-04-14 14:52:18','2023-11-05 14:01:10','2023-11-05 14:01:10'),(97,7492,40787,102495,1,97,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',723175.79,NULL,NULL,1,'2023-04-14 14:54:03','2023-11-05 14:01:10','2023-11-05 14:01:10'),(98,7492,40787,102495,1,98,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',53793.80,NULL,NULL,1,'2023-04-14 14:55:47','2023-04-14 15:36:12','2023-04-14 15:36:12'),(99,7492,40787,102495,1,99,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3315.96,NULL,NULL,1,'2023-04-14 14:56:47','2023-10-12 12:55:27','2023-10-12 12:55:27'),(100,7492,40787,102495,1,100,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1869502.69,NULL,NULL,1,'2023-04-14 15:01:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(101,7492,40787,102496,1,101,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',701047.91,NULL,NULL,1,'2023-04-14 15:02:59','2023-11-05 14:01:10','2023-11-05 14:01:10'),(102,7492,40787,102496,1,102,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',58521.81,NULL,NULL,1,'2023-04-14 15:04:32','2023-04-14 15:37:10','2023-04-14 15:37:10'),(103,7492,40787,102496,1,103,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2993.92,NULL,NULL,1,'2023-04-14 15:05:19','2023-10-12 12:55:01','2023-10-12 12:55:01'),(104,7492,40787,102487,1,104,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',31376.71,NULL,NULL,1,'2023-04-14 15:23:26','2023-11-05 14:01:10','2023-11-05 14:01:10'),(105,7492,40787,102488,1,105,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',39019.19,NULL,NULL,1,'2023-04-14 15:25:53','2023-11-05 14:01:10','2023-11-05 14:01:10'),(106,7492,40787,102489,1,106,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2143.06,NULL,NULL,1,'2023-04-14 15:28:03','2023-10-12 12:57:05','2023-10-12 12:57:05'),(107,7492,40787,102489,1,107,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',48873.19,NULL,NULL,1,'2023-04-14 15:30:23','2023-11-05 14:01:10','2023-11-05 14:01:10'),(108,7492,40787,102490,1,108,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',55846.00,NULL,NULL,1,'2023-04-14 15:31:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(109,7492,40787,102491,1,109,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',58055.63,NULL,NULL,1,'2023-04-14 15:32:59','2023-11-05 14:01:10','2023-11-05 14:01:10'),(110,7492,40787,102492,1,110,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',75645.13,NULL,NULL,1,'2023-04-14 15:34:10','2023-11-05 14:01:10','2023-11-05 14:01:10');
INSERT INTO `balance_libro` VALUES (111,7492,40787,102494,1,111,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',79556.41,NULL,NULL,1,'2023-04-14 15:35:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(112,7492,40787,102495,1,112,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',53793.80,NULL,NULL,1,'2023-04-14 15:36:12','2023-11-05 14:01:10','2023-11-05 14:01:10'),(113,7492,40787,102496,1,113,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',58521.81,NULL,NULL,1,'2023-04-14 15:37:10','2023-11-05 14:01:10','2023-11-05 14:01:10'),(114,7492,40787,102496,2,114,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',24311592.15,NULL,NULL,1,'2023-04-20 15:53:37','2023-11-05 14:01:09','2023-11-05 14:01:09'),(115,7492,40787,102496,3,115,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3841982.88,NULL,NULL,1,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(116,7492,40787,102496,16,116,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',502305.62,NULL,NULL,1,'2023-04-20 16:27:15','2023-11-05 14:01:09','2023-11-05 14:01:09'),(117,7492,40787,102496,15,117,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',4219367.23,NULL,NULL,1,'2023-04-20 16:29:45','2023-11-05 14:01:09','2023-11-05 14:01:09'),(118,7492,40787,102496,3,118,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3841982.88,NULL,NULL,1,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(119,7492,40787,102496,1,119,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',1873489.33,NULL,NULL,1,'2023-10-12 11:54:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(120,7492,40787,102496,1,120,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',523340.71,NULL,NULL,1,'2023-10-12 11:55:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(121,7492,40787,102496,1,121,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',53460.80,NULL,NULL,1,'2023-10-12 11:56:32','2023-11-05 14:01:09','2023-11-05 14:01:09'),(122,7492,40787,102496,1,122,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2872.64,NULL,NULL,1,'2023-10-12 11:57:43','2023-10-12 12:54:35','2023-10-12 12:54:35'),(123,7492,40787,102497,1,123,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',2354816.85,NULL,NULL,1,'2023-10-12 12:00:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(124,7492,40787,102497,1,124,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',629959.46,NULL,NULL,1,'2023-10-12 12:02:01','2023-11-05 14:01:09','2023-11-05 14:01:09'),(125,7492,40787,102497,1,125,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',58293.26,NULL,NULL,1,'2023-10-12 12:03:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(126,7492,40787,102497,1,126,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',3709.70,NULL,NULL,1,'2023-10-12 12:04:25','2023-11-05 14:01:09','2023-11-05 14:01:09'),(127,7492,40787,102498,1,127,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',3084396.74,NULL,NULL,1,'2023-10-12 12:13:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(128,7492,40787,102499,1,128,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',1156767.46,NULL,NULL,1,'2023-10-12 12:14:58','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro` VALUES (129,7492,40787,102499,1,129,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',67360.03,NULL,NULL,1,'2023-10-12 12:16:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(130,7492,40787,102499,1,130,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4775.23,NULL,NULL,1,'2023-10-12 12:17:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(131,7492,40787,102499,1,131,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4915924.94,NULL,NULL,1,'2023-10-12 12:22:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(132,7492,40787,102499,1,132,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',5958.68,NULL,NULL,1,'2023-10-12 12:41:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(133,7492,40787,102499,1,133,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',5958.67,NULL,NULL,1,'2023-10-12 12:46:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(134,7492,40787,102496,1,134,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2872.64,NULL,NULL,1,'2023-10-12 12:54:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(135,7492,40787,102496,1,135,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2993.92,NULL,NULL,1,'2023-10-12 12:55:01','2023-11-05 14:01:09','2023-11-05 14:01:09'),(136,7492,40787,102495,1,136,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3315.96,NULL,NULL,1,'2023-10-12 12:55:27','2023-11-05 14:01:09','2023-11-05 14:01:09'),(137,7492,40787,102494,1,137,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3427.47,NULL,NULL,1,'2023-10-12 12:55:47','2023-11-05 14:01:09','2023-11-05 14:01:09'),(138,7492,40787,102492,1,138,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3779.78,NULL,NULL,1,'2023-10-12 12:56:11','2023-11-05 14:01:09','2023-11-05 14:01:09'),(139,7492,40787,102491,1,139,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2637.46,NULL,NULL,1,'2023-10-12 12:56:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(140,7492,40787,102490,1,140,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2365.32,NULL,NULL,1,'2023-10-12 12:56:48','2023-11-05 14:01:09','2023-11-05 14:01:09'),(141,7492,40787,102489,1,141,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2143.06,NULL,NULL,1,'2023-10-12 12:57:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(142,7492,40787,102488,1,142,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1643.78,NULL,NULL,1,'2023-10-12 12:57:22','2023-11-05 14:01:09','2023-11-05 14:01:09'),(143,7492,40787,102487,1,143,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1721.50,NULL,NULL,1,'2023-10-12 12:57:44','2023-11-05 14:01:09','2023-11-05 14:01:09'),(144,7492,40787,102497,2,144,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',48499454.74,NULL,NULL,1,'2023-10-12 13:14:34','2023-11-05 14:01:09','2023-11-05 14:01:09'),(145,7492,40787,102498,2,145,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',11667038.66,NULL,NULL,1,'2023-10-12 13:15:23','2023-11-05 14:01:09','2023-11-05 14:01:09'),(146,7492,40787,102499,2,146,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',28418537.48,NULL,NULL,1,'2023-10-12 13:16:11','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro` VALUES (147,7492,40787,102497,3,147,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',11262317.65,NULL,NULL,1,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(148,7492,40787,102498,3,148,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',11405242.42,NULL,NULL,1,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(149,7492,40787,102499,3,149,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',7174843.93,NULL,NULL,1,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(150,7492,40787,102497,15,150,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',8417260.74,NULL,NULL,1,'2023-10-12 14:11:23','2023-11-05 14:01:09','2023-11-05 14:01:09'),(151,7492,40787,102498,15,151,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2024857.95,NULL,NULL,1,'2023-10-12 14:12:19','2023-11-05 14:01:09','2023-11-05 14:01:09'),(152,7492,40787,102499,15,152,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4932142.87,NULL,NULL,1,'2023-10-12 14:13:09','2023-11-05 14:01:09','2023-11-05 14:01:09'),(153,7492,40787,102497,16,153,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',1002347.60,NULL,NULL,1,'2023-10-12 14:18:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(154,7492,40787,102498,15,154,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',241502.03,NULL,NULL,1,'2023-10-12 14:21:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(155,7492,40787,102499,16,155,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',587159.86,NULL,NULL,1,'2023-10-12 14:23:44','2023-11-05 14:01:09','2023-11-05 14:01:09'),(156,7492,40787,102487,20,156,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1922543.52,NULL,NULL,1,'2023-10-12 14:39:07','2023-11-05 14:01:09','2023-11-05 14:01:09'),(157,7492,40787,102488,20,157,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3904693.28,NULL,NULL,1,'2023-10-12 14:40:06','2023-11-05 14:01:09','2023-11-05 14:01:09'),(158,7492,40787,102489,20,158,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',10927074.94,NULL,NULL,1,'2023-10-12 14:41:22','2023-11-05 14:01:09','2023-11-05 14:01:09'),(159,7492,40787,102490,20,159,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',6413486.31,NULL,NULL,1,'2023-10-12 15:18:31','2023-11-05 14:01:09','2023-11-05 14:01:09'),(160,7492,40787,102491,20,160,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',16154783.44,NULL,NULL,1,'2023-10-12 15:19:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(161,7492,40787,102492,20,161,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',12731467.70,NULL,NULL,1,'2023-10-12 15:20:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(162,7492,40787,102494,20,162,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',13767864.28,NULL,NULL,1,'2023-10-12 15:21:24','2023-11-05 14:01:09','2023-11-05 14:01:09'),(163,7492,40787,102495,20,163,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4019952.60,NULL,NULL,1,'2023-10-12 15:22:10','2023-11-05 14:01:09','2023-11-05 14:01:09'),(164,7492,40787,102496,20,164,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',23436611.92,NULL,NULL,1,'2023-10-12 15:22:52','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro` VALUES (165,7492,40787,102497,20,165,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',25019501.20,NULL,NULL,1,'2023-10-12 15:23:27','2023-11-05 14:01:09','2023-11-05 14:01:09'),(166,7492,40787,102498,20,166,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',21385950.97,NULL,NULL,1,'2023-10-12 15:24:17','2023-11-05 14:01:09','2023-11-05 14:01:09'),(167,7492,40787,102499,20,167,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',17443107.34,NULL,NULL,1,'2023-10-12 15:26:07','2023-11-05 14:01:09','2023-11-05 14:01:09'),(168,7492,40787,102487,18,168,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',200000.00,NULL,NULL,1,'2023-10-12 15:28:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(169,7492,40787,102488,18,169,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',150000.00,NULL,NULL,1,'2023-10-12 15:29:14','2023-11-05 14:01:09','2023-11-05 14:01:09'),(170,7492,40787,102492,18,170,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1556914.65,NULL,NULL,1,'2023-10-12 15:31:19','2023-11-05 14:01:09','2023-11-05 14:01:09'),(171,7492,40787,102494,18,171,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',500000.00,NULL,NULL,1,'2023-10-12 15:33:24','2023-11-05 14:01:09','2023-11-05 14:01:09'),(172,7492,40787,102495,20,172,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',814018.23,NULL,NULL,1,'2023-10-12 15:34:09','2023-11-05 14:01:09','2023-11-05 14:01:09'),(173,7492,40787,102496,20,173,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',4429204.54,NULL,NULL,1,'2023-10-12 15:35:18','2023-11-05 14:01:09','2023-11-05 14:01:09'),(174,7492,40787,102498,18,174,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',300000.00,NULL,NULL,1,'2023-10-12 15:35:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(175,7492,40787,102499,20,175,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4445403.53,NULL,NULL,1,'2023-10-12 15:37:41','2023-11-05 14:01:09','2023-11-05 14:01:09'),(176,7492,40787,102494,3,176,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',3325320.00,NULL,NULL,1,'2023-10-12 15:45:12','2023-10-25 20:18:34','2023-10-25 20:18:34'),(185,7492,40787,102487,12,185,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',11524705.60,NULL,NULL,1,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(186,7492,40787,102487,12,186,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',579571.26,NULL,NULL,1,'2023-10-20 14:39:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(187,7492,40787,102487,12,187,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',10945134.43,NULL,NULL,1,'2023-10-20 14:45:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(188,7492,40787,102494,21,188,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1992662.05,NULL,NULL,1,'2023-10-23 12:29:50','2023-11-05 14:01:09','2023-11-05 14:01:09'),(189,7492,40787,102494,19,189,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',184172.29,NULL,NULL,1,'2023-10-23 12:32:18','2023-11-05 14:01:09','2023-11-05 14:01:09'),(190,7492,40787,102495,3,190,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4184608.28,NULL,NULL,1,'2023-10-23 12:34:42','2023-11-05 10:46:28','2023-11-05 10:46:28');
INSERT INTO `balance_libro` VALUES (191,7492,40787,102495,3,191,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',540339.56,NULL,NULL,1,'2023-10-23 12:35:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(192,7492,40787,102495,3,192,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',84372.75,NULL,NULL,1,'2023-10-23 12:37:33','2023-11-05 14:01:09','2023-11-05 14:01:09'),(193,7492,40787,102496,3,193,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',10548892.03,NULL,NULL,1,'2023-10-23 12:38:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(194,7492,40787,102496,3,194,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2308148.79,NULL,NULL,1,'2023-10-23 12:40:09','2023-10-25 13:09:00','2023-10-25 13:09:00'),(195,7492,40787,102496,3,195,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',317563.14,NULL,NULL,1,'2023-10-23 13:21:34','2023-11-05 14:01:09','2023-11-05 14:01:09'),(196,7492,40787,102497,3,196,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',10940469.96,NULL,NULL,1,'2023-10-23 13:23:35','2023-11-05 10:45:49','2023-11-05 10:45:49'),(197,7492,40787,102497,3,197,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',826301.49,NULL,NULL,1,'2023-10-23 13:25:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(198,7492,40787,102497,3,198,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',347987.02,NULL,NULL,1,'2023-10-23 13:28:24','2023-11-05 14:01:09','2023-11-05 14:01:09'),(199,7492,40787,102498,3,199,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',16754991.03,NULL,NULL,1,'2023-10-23 13:30:03','2023-11-05 10:45:31','2023-11-05 10:45:31'),(200,7492,40787,102497,3,200,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1755204.41,NULL,NULL,1,'2023-10-23 13:33:13','2023-11-05 14:01:09','2023-11-05 14:01:09'),(201,7492,40787,102497,3,201,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',21723.78,NULL,NULL,1,'2023-10-23 13:33:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(202,7492,40787,102498,3,202,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',354249.59,NULL,NULL,1,'2023-10-23 13:35:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(203,7492,40787,102499,3,203,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',11347205.28,NULL,NULL,1,'2023-10-23 13:39:20','2023-11-05 10:36:26','2023-11-05 10:36:26'),(204,7492,40787,102494,3,204,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',164534.53,NULL,NULL,1,'2023-10-23 13:41:45','2023-11-05 14:01:09','2023-11-05 14:01:09'),(205,7492,40787,102494,3,205,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',108894.83,NULL,NULL,1,'2023-10-23 13:43:22','2023-11-05 14:01:09','2023-11-05 14:01:09'),(206,7492,40787,102495,3,206,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',138484.82,NULL,NULL,1,'2023-10-23 13:46:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(207,7492,40787,102496,3,207,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',242943.91,NULL,NULL,1,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(208,7492,40787,102496,3,208,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',242943.91,NULL,NULL,1,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro` VALUES (209,7492,40787,102497,3,209,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',354701.90,NULL,NULL,1,'2023-10-23 14:04:07','2023-11-05 14:01:09','2023-11-05 14:01:09'),(210,7492,40787,102498,3,210,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2616105.36,NULL,NULL,1,'2023-10-23 14:07:33','2023-11-05 14:01:09','2023-11-05 14:01:09'),(211,7492,40787,102499,3,211,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',2193102.53,NULL,NULL,1,'2023-10-23 14:13:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(212,7492,40787,102487,3,212,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1506270.00,NULL,NULL,1,'2023-10-23 14:18:49','2023-11-05 10:48:58','2023-11-05 10:48:58'),(213,7492,40787,102487,3,213,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',70542.58,NULL,NULL,1,'2023-10-23 14:25:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(214,7492,40787,102488,3,214,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1642021.22,NULL,NULL,1,'2023-10-23 14:29:32','2023-11-05 10:48:36','2023-11-05 10:48:36'),(215,7492,40787,102488,3,215,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',4425441.78,NULL,NULL,1,'2023-10-23 14:34:59','2023-10-23 14:49:38','2023-10-23 14:49:38'),(216,7492,40787,102489,3,216,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',4425441.78,NULL,NULL,1,'2023-10-23 14:49:38','2023-11-05 10:48:12','2023-11-05 10:48:12'),(217,7492,40787,102503,3,217,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',4907759.99,NULL,NULL,1,'2023-10-23 15:30:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(218,7492,40787,102504,3,218,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',8639429.01,NULL,NULL,1,'2023-10-23 15:36:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(219,7492,40787,102505,3,219,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',9500403.26,NULL,NULL,1,'2023-10-23 15:41:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(220,7492,40787,102487,3,220,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',83825.48,NULL,NULL,1,'2023-10-23 15:44:52','2023-11-05 14:01:09','2023-11-05 14:01:09'),(221,7492,40787,102488,3,221,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',67770.85,NULL,NULL,1,'2023-10-23 15:51:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(222,7492,40787,102489,3,222,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',48341.70,NULL,NULL,1,'2023-10-23 15:55:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(223,7492,40787,102490,3,223,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',64557.75,NULL,NULL,1,'2023-10-23 15:57:38','2023-11-05 14:01:09','2023-11-05 14:01:09'),(224,7492,40787,102491,3,224,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',123875.04,NULL,NULL,1,'2023-10-23 15:59:39','2023-11-05 14:01:09','2023-11-05 14:01:09'),(225,7492,40787,102492,3,225,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',112917.26,NULL,NULL,1,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(226,7492,40787,102492,3,226,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',112917.26,NULL,NULL,1,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro` VALUES (227,7492,40787,102499,19,227,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',3204497.27,NULL,NULL,1,'2023-10-24 12:39:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(228,7492,40787,102490,5,228,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',223500.00,NULL,NULL,1,'2023-10-24 12:55:34','2023-11-05 10:47:45','2023-11-05 10:47:45'),(229,7492,40787,102491,5,229,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',182112.00,NULL,NULL,1,'2023-10-24 12:56:12','2023-11-05 10:47:27','2023-11-05 10:47:27'),(230,7492,40787,102492,5,230,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',162000.00,NULL,NULL,1,'2023-10-24 12:57:11','2023-11-05 10:47:04','2023-11-05 10:47:04'),(231,7492,40787,102494,5,231,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',285000.00,NULL,NULL,1,'2023-10-24 12:57:45','2023-11-05 10:46:48','2023-11-05 10:46:48'),(232,7492,40787,102496,19,232,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',214000.00,NULL,NULL,1,'2023-10-24 13:00:05','2023-11-05 10:46:09','2023-11-05 10:46:09'),(233,7492,40787,102499,21,233,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1090700.17,NULL,NULL,1,'2023-10-24 13:06:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(234,7492,40787,102499,18,234,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',3024068.98,NULL,NULL,1,'2023-10-24 13:10:36','2023-10-25 12:57:05','2023-10-25 12:57:05'),(235,7492,40787,102487,18,235,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1568953.87,NULL,NULL,1,'2023-10-24 13:19:56','2023-11-05 14:01:09','2023-11-05 14:01:09'),(236,7492,40787,102491,10,236,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',837335.32,NULL,NULL,1,'2023-10-25 12:50:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(237,7492,40787,102499,18,237,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',3523796.50,NULL,NULL,1,'2023-10-25 12:58:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(238,7492,40787,102496,3,238,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2308148.79,NULL,NULL,1,'2023-10-25 13:09:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(239,7492,40787,102499,10,239,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',38144.41,NULL,NULL,1,'2023-10-25 13:12:33','2023-10-25 13:14:14','2023-10-25 13:14:14'),(240,7492,40787,102499,10,240,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',38156.53,NULL,NULL,1,'2023-10-25 13:14:14','2023-11-05 14:01:09','2023-11-05 14:01:09'),(241,7492,40787,102499,18,241,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1411725.04,NULL,NULL,1,'2023-10-25 13:19:11','2023-11-05 14:01:09','2023-11-05 14:01:09'),(242,7492,40787,102499,15,242,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1376375.47,NULL,NULL,1,'2023-10-25 15:43:38','2023-11-05 14:01:09','2023-11-05 14:01:09'),(243,7492,40787,102499,19,243,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',91852072.71,NULL,NULL,1,'2023-10-25 16:09:12','2023-11-05 11:10:41','2023-11-05 11:10:41'),(244,7492,40787,102499,19,244,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',20309457.46,NULL,NULL,1,'2023-10-25 16:14:27','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro` VALUES (245,7492,40787,102499,4,245,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',589440.41,NULL,NULL,1,'2023-10-25 16:20:21','2023-10-25 18:34:33','2023-10-25 18:34:33'),(246,7492,40787,102499,18,246,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',117867.73,NULL,NULL,1,'2023-10-25 16:21:48','2023-11-05 14:01:09','2023-11-05 14:01:09'),(247,7492,40787,102499,9,247,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',19335.37,NULL,NULL,1,'2023-10-25 16:27:19','2023-10-25 16:59:57','2023-10-25 16:59:57'),(248,7492,40787,102494,4,248,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',81473.03,NULL,NULL,1,'2023-10-25 16:33:34','2023-10-25 18:38:55','2023-10-25 18:38:55'),(249,7492,40787,102487,18,249,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',285000.00,NULL,NULL,1,'2023-10-25 16:36:12','2023-11-05 10:50:00','2023-11-05 10:50:00'),(250,7492,40787,102499,16,250,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1424636.31,NULL,NULL,1,'2023-10-25 16:56:06','2023-11-05 14:01:09','2023-11-05 14:01:09'),(251,7492,40787,102499,9,251,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',19335.37,NULL,NULL,1,'2023-10-25 16:59:57','2023-11-05 14:01:09','2023-11-05 14:01:09'),(252,7492,40787,102499,18,252,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',95844.56,NULL,NULL,1,'2023-10-25 17:03:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(253,7492,40787,102499,18,253,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',92682.27,NULL,NULL,1,'2023-10-25 17:04:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(254,7492,40787,102499,4,254,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',589440.41,NULL,NULL,1,'2023-10-25 18:34:33','2023-10-25 18:38:35','2023-10-25 18:38:35'),(255,7492,40787,102499,4,255,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',589440.41,NULL,NULL,1,'2023-10-25 18:38:35','2023-11-05 11:40:04','2023-11-05 11:40:04'),(256,7492,40787,102494,4,256,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',81473.03,NULL,NULL,1,'2023-10-25 18:38:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(257,7492,40787,102487,18,257,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',101271.99,NULL,NULL,1,'2023-10-25 19:17:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(258,7492,40787,102499,18,258,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',15003.27,NULL,NULL,1,'2023-10-25 19:26:50','2023-11-05 14:01:09','2023-11-05 14:01:09'),(259,7492,40787,102487,18,259,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',50252.58,NULL,NULL,1,'2023-10-25 20:06:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(260,7492,40787,102488,18,260,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',56104.14,NULL,NULL,1,'2023-10-25 20:07:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(261,7492,40787,102499,18,261,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',2771245.19,NULL,NULL,1,'2023-10-25 20:08:17','2023-11-05 14:01:09','2023-11-05 14:01:09'),(262,7492,40787,102494,3,262,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',3610320.00,NULL,NULL,1,'2023-10-25 20:18:34','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro` VALUES (263,7492,40787,102499,18,263,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',396767.50,NULL,NULL,1,'2023-10-25 20:25:20','2023-11-05 14:01:09','2023-11-05 14:01:09'),(264,7492,40787,102499,18,264,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',6554.03,NULL,NULL,1,'2023-10-25 20:37:45','2023-11-05 14:01:09','2023-11-05 14:01:09'),(265,7492,40787,102499,18,265,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1702.50,NULL,NULL,1,'2023-10-25 20:40:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(266,7492,40787,102487,1,266,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',603346.96,NULL,NULL,1,'2023-10-25 20:47:19','2023-11-05 14:01:09','2023-11-05 14:01:09'),(267,7492,40787,102488,1,267,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',776749.46,NULL,NULL,1,'2023-10-25 20:48:17','2023-11-05 14:01:09','2023-11-05 14:01:09'),(268,7492,40787,102489,1,268,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',917171.54,NULL,NULL,1,'2023-10-25 20:48:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(269,7492,40787,102490,1,269,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',937215.52,NULL,NULL,1,'2023-10-25 20:49:31','2023-11-05 14:01:09','2023-11-05 14:01:09'),(270,7492,40787,102491,1,270,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1333000.89,NULL,NULL,1,'2023-10-25 20:50:06','2023-11-05 14:01:09','2023-11-05 14:01:09'),(271,7492,40787,102492,1,271,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1991738.51,NULL,NULL,1,'2023-10-25 20:50:50','2023-11-05 14:01:09','2023-11-05 14:01:09'),(272,7492,40787,102494,1,272,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1212124.05,NULL,NULL,1,'2023-10-25 20:51:20','2023-11-05 14:01:09','2023-11-05 14:01:09'),(273,7492,40787,102495,1,273,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1099566.76,NULL,NULL,1,'2023-10-25 20:51:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(274,7492,40787,102496,1,274,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1121118.71,NULL,NULL,1,'2023-10-25 20:52:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(275,7492,40787,102497,1,275,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1360657.48,NULL,NULL,1,'2023-10-25 20:52:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(276,7492,40787,102498,1,276,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1787041.28,NULL,NULL,1,'2023-10-25 20:53:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(277,7492,40787,102487,1,277,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',874320.75,NULL,NULL,1,'2023-10-25 21:00:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(278,7492,40787,102495,1,278,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',55400.00,NULL,NULL,1,'2023-10-25 21:06:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(279,7492,40787,102499,18,279,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',12.12,NULL,NULL,1,'2023-11-04 19:12:41','2023-11-05 14:01:09','2023-11-05 14:01:09'),(280,7492,40787,102499,3,280,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',39825.34,'plan 558750',NULL,1,'2023-11-04 19:56:01','2023-11-04 20:10:31','2023-11-04 20:10:31');
INSERT INTO `balance_libro` VALUES (281,7492,40787,102499,3,281,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',33144.41,'´plan 199778',NULL,1,'2023-11-04 19:57:03','2023-11-04 20:10:57','2023-11-04 20:10:57'),(282,7492,40787,102499,3,282,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',65750.24,'plan 887056',NULL,1,'2023-11-04 19:57:59','2023-11-04 20:11:32','2023-11-04 20:11:32'),(283,7492,40787,102499,3,283,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',125764.60,'plan 886887',NULL,1,'2023-11-04 19:58:49','2023-11-04 20:12:17','2023-11-04 20:12:17'),(284,7492,40787,102499,3,284,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',52301.50,'plan 886619',NULL,1,'2023-11-04 20:00:52','2023-11-04 20:19:14','2023-11-04 20:19:14'),(285,7492,40787,102499,3,285,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',50070.27,'plan 700084',NULL,1,'2023-11-04 20:02:28','2023-11-04 20:12:46','2023-11-04 20:12:46'),(286,7492,40787,102499,3,286,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',491869.34,'plan 700041',NULL,1,'2023-11-04 20:03:40','2023-11-04 20:13:14','2023-11-04 20:13:14'),(287,7492,40787,102499,3,287,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',39825.34,'plan 558750',NULL,1,'2023-11-04 20:10:31','2023-11-05 14:01:09','2023-11-05 14:01:09'),(288,7492,40787,102499,3,288,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',33144.41,'´plan 199778',NULL,1,'2023-11-04 20:10:57','2023-11-05 14:01:09','2023-11-05 14:01:09'),(289,7492,40787,102499,3,289,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',65750.24,'plan 887056',NULL,1,'2023-11-04 20:11:32','2023-11-05 14:01:09','2023-11-05 14:01:09'),(290,7492,40787,102499,3,290,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',125764.60,'plan 886887',NULL,1,'2023-11-04 20:12:17','2023-11-05 14:01:09','2023-11-05 14:01:09'),(291,7492,40787,102499,3,291,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',50070.27,'plan 700084',NULL,1,'2023-11-04 20:12:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(292,7492,40787,102499,3,292,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',491869.34,'plan 700041',NULL,1,'2023-11-04 20:13:14','2023-11-05 14:01:09','2023-11-05 14:01:09'),(293,7492,40787,102499,3,293,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',52301.50,'plan 886619',NULL,1,'2023-11-04 20:19:14','2023-11-05 14:01:09','2023-11-05 14:01:09'),(294,7492,40787,102499,21,294,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1391784.47,NULL,NULL,1,'2023-11-04 20:42:34','2023-11-05 14:01:09','2023-11-05 14:01:09'),(295,7492,40719,23,17,295,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4719688.92,'Plan faciliades AFIP 2023 (reconocimiento de intereses a devengar)',NULL,1,'2023-11-05 09:30:34','2023-11-05 09:33:19','2023-11-05 09:33:19'),(296,7492,40719,23,17,296,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',5578414.62,'Plan faciliades AFIP 2023 (reconocimiento de intereses a devengar)',NULL,1,'2023-11-05 09:33:19','2023-11-05 09:33:47','2023-11-05 09:33:47'),(297,7492,40719,23,17,297,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4719688.92,'Plan faciliades AFIP 2023 (reconocimiento de intereses a devengar)',NULL,1,'2023-11-05 09:33:47','2023-11-05 09:33:47',NULL);
INSERT INTO `balance_libro` VALUES (298,7492,40787,102499,11,298,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4719688.92,'Plan faciliades AFIP 2023 (reconocimiento de intereses a devengar)',NULL,1,'2023-11-05 09:36:26','2023-11-05 09:36:26',NULL),(299,7492,40787,102499,11,299,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',370254.51,'AJUSTE PLAN AFIP',NULL,1,'2023-11-05 09:38:21','2023-11-05 09:38:21',NULL),(300,7492,40787,102499,11,300,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',9404.28,'Plan facilidades AGIP 2023 (reconocimiento de intereses a devengar)',NULL,1,'2023-11-05 09:51:02','2023-11-05 09:51:02',NULL),(301,7492,40787,102499,11,301,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',18808.56,'int devengados AGIP 2023',NULL,1,'2023-11-05 09:52:05','2023-11-09 06:14:35','2023-11-09 06:14:35'),(302,7492,40787,102499,11,302,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',34541.88,NULL,NULL,1,'2023-11-05 09:53:59','2023-11-05 09:53:59',NULL),(303,7492,40787,102499,3,303,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',11347205.28,NULL,NULL,1,'2023-11-05 10:36:26','2023-11-05 10:45:08','2023-11-05 10:45:08'),(304,7492,40787,102499,3,304,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',11347205.28,NULL,NULL,1,'2023-11-05 10:45:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(305,7492,40787,102498,3,305,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',16754991.03,NULL,NULL,1,'2023-11-05 10:45:31','2023-11-05 14:01:09','2023-11-05 14:01:09'),(306,7492,40787,102497,3,306,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',10940469.96,NULL,NULL,1,'2023-11-05 10:45:49','2023-11-05 14:01:09','2023-11-05 14:01:09'),(307,7492,40787,102496,19,307,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',214000.00,NULL,NULL,1,'2023-11-05 10:46:09','2023-11-05 14:01:09','2023-11-05 14:01:09'),(308,7492,40787,102495,3,308,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4184608.28,NULL,NULL,1,'2023-11-05 10:46:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(309,7492,40787,102494,5,309,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',285000.00,NULL,NULL,1,'2023-11-05 10:46:48','2023-11-05 14:01:09','2023-11-05 14:01:09'),(310,7492,40787,102492,5,310,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',162000.00,NULL,NULL,1,'2023-11-05 10:47:04','2023-11-05 14:01:09','2023-11-05 14:01:09'),(311,7492,40787,102491,5,311,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',182112.00,NULL,NULL,1,'2023-11-05 10:47:27','2023-11-05 14:01:09','2023-11-05 14:01:09'),(312,7492,40787,102490,5,312,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',223500.00,NULL,NULL,1,'2023-11-05 10:47:45','2023-11-05 14:01:09','2023-11-05 14:01:09'),(313,7492,40787,102489,3,313,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',4425441.78,NULL,NULL,1,'2023-11-05 10:48:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(314,7492,40787,102488,3,314,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1642021.22,NULL,NULL,1,'2023-11-05 10:48:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(315,7492,40787,102487,3,315,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1506270.00,NULL,NULL,1,'2023-11-05 10:48:58','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro` VALUES (316,7492,40787,102487,18,316,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',285000.00,NULL,NULL,1,'2023-11-05 10:50:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(317,7492,40787,102499,19,317,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',76543393.93,NULL,NULL,1,'2023-11-05 11:10:41','2023-11-05 13:38:03','2023-11-05 13:38:03'),(318,7492,40787,102499,22,318,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',10000000.00,NULL,NULL,1,'2023-11-05 11:13:17','2023-11-05 14:01:09','2023-11-05 14:01:09'),(319,7492,40787,102499,4,319,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',589440.41,NULL,NULL,1,'2023-11-05 11:40:04','2023-11-05 14:01:09','2023-11-05 14:01:09'),(320,7492,40787,102499,18,320,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1831066.25,NULL,NULL,1,'2023-11-05 13:33:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(321,7492,40787,102499,19,321,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',81135997.56,NULL,NULL,1,'2023-11-05 13:38:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(322,7492,40787,102487,23,322,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',524383.53,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:16','2023-11-05 14:01:09','2023-11-05 14:01:09'),(323,7492,40787,102487,23,323,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',18835.02,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:16','2023-11-05 14:01:09','2023-11-05 14:01:09'),(324,7492,40787,102487,23,324,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',74162.46,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:16','2023-11-05 14:01:09','2023-11-05 14:01:09'),(325,7492,40787,102487,23,325,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',867005.31,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(326,7492,40787,102487,23,326,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',30008.55,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(327,7492,40787,102487,23,327,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1043271.05,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(328,7492,40787,102487,23,328,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1714.94,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(329,7492,40787,102487,23,329,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2621917.62,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(330,7492,40787,102487,23,330,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6735.07,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(331,7492,40787,102487,23,331,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5065473.66,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(332,7492,40787,102487,23,332,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1733.81,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro` VALUES (333,7492,40787,102487,23,333,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',44188.68,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(334,7492,40787,102487,23,334,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',18940.33,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(335,7492,40787,102487,23,335,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',101490.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(336,7492,40787,102487,23,336,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',29275.72,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(337,7492,40787,102487,23,337,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',64611.14,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(338,7492,40787,102487,23,338,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',85607.69,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(339,7492,40787,102487,23,339,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',100714.93,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(340,7492,40787,102487,23,340,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',42189.23,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(341,7492,40787,102487,23,341,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',201929.60,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(342,7492,40787,102487,23,342,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',59331.27,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(343,7492,40787,102487,23,343,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',19120.90,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(344,7492,40787,102487,23,344,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',524.66,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(345,7492,40787,102487,23,345,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',593311.73,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(346,7492,40787,102487,23,346,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',13590.56,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(347,7492,40787,102487,23,347,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',46056.11,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(348,7492,40787,102487,23,348,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2658652.59,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro` VALUES (349,7492,40787,102487,23,349,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',39067.32,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(350,7492,40787,102487,23,350,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',101996.01,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(351,7492,40787,102487,23,351,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',22277.64,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(352,7492,40787,102487,23,352,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5786.37,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(353,7492,40787,102487,23,353,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1831049.70,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(354,7492,40787,102487,23,354,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1694.22,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(355,7492,40787,102487,23,355,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',55365.00,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(356,7492,40787,102487,23,356,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',75536.20,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(357,7492,40787,102488,23,357,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',34764.74,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(358,7492,40787,102488,23,358,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',950441.66,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(359,7492,40787,102488,23,359,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',26290.82,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(360,7492,40787,102488,23,360,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',12271.51,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(361,7492,40787,102488,23,361,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',6560.47,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(362,7492,40787,102488,23,362,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',846824.41,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(363,7492,40787,102488,23,363,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',193928.98,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(364,7492,40787,102488,23,364,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',87636.07,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro` VALUES (365,7492,40787,102488,23,365,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1455.41,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(366,7492,40787,102488,23,366,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',211263.69,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(367,7492,40787,102488,23,367,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',184035.74,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(368,7492,40787,102488,23,368,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',554.36,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(369,7492,40787,102488,23,369,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',69399.57,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(370,7492,40787,102488,23,370,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1709.25,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(371,7492,40787,102488,23,371,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',5951.13,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(372,7492,40787,102488,23,372,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',30377.66,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(373,7492,40787,102488,23,373,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',45049.38,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(374,7492,40787,102488,23,374,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',34685.39,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(375,7492,40787,102488,23,375,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',6192542.11,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(376,7492,40787,102488,23,376,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',154813.56,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(377,7492,40787,102488,23,377,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1440.54,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(378,7492,40787,102488,23,378,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',118854.66,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(379,7492,40787,102488,23,379,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',36977.82,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(380,7492,40787,102488,23,380,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',87636.07,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro` VALUES (381,7492,40787,102488,23,381,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',82789.71,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(382,7492,40787,102489,23,382,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',30442.00,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(383,7492,40787,102489,23,383,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',6230.43,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(384,7492,40787,102489,23,384,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',28536.55,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(385,7492,40787,102489,23,385,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',6268.62,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(386,7492,40787,102489,23,386,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',66810.41,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(387,7492,40787,102489,23,387,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',331513.25,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(388,7492,40787,102489,23,388,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',16967.03,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(389,7492,40787,102489,23,389,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',11674729.51,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(390,7492,40787,102489,23,390,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',253361.03,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(391,7492,40787,102489,23,391,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',513.98,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(392,7492,40787,102489,23,392,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',9513.12,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(393,7492,40787,102489,23,393,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1644.57,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(394,7492,40787,102489,23,394,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',122837.17,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(395,7492,40787,102489,23,395,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1046.29,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(396,7492,40787,102489,23,396,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2877.72,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro` VALUES (397,7492,40787,102489,23,397,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',671237.59,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(398,7492,40787,102489,23,398,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',133018.54,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(399,7492,40787,102489,23,399,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',16672.76,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(400,7492,40787,102489,23,400,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',39500.15,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(401,7492,40787,102489,23,401,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',291868.24,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(402,7492,40787,102489,23,402,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',971763.31,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(403,7492,40787,102489,23,403,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',3132.98,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(404,7492,40787,102489,23,404,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',85205.38,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(405,7492,40787,102489,23,405,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',46043.51,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(406,7492,40787,102489,23,406,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',937088.54,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(407,7492,40787,102489,23,407,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',73115.62,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(408,7492,40787,102489,23,408,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',117842.22,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(409,7492,40787,102489,23,409,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',21738.19,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(410,7492,40787,102490,23,410,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',21632.17,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(411,7492,40787,102490,23,411,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',7192.17,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(412,7492,40787,102490,23,412,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',81745.25,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro` VALUES (413,7492,40787,102490,23,413,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',807.42,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(414,7492,40787,102490,23,414,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',214905.53,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(415,7492,40787,102490,23,415,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2466562.19,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(416,7492,40787,102490,23,416,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',54813.47,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(417,7492,40787,102490,23,417,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',344.81,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(418,7492,40787,102490,23,418,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',8395.30,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(419,7492,40787,102490,23,419,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2934.74,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(420,7492,40787,102490,23,420,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',24821.43,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(421,7492,40787,102490,23,421,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',86438.69,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(422,7492,40787,102490,23,422,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',41779.34,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(423,7492,40787,102490,23,423,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1066.16,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(424,7492,40787,102490,23,424,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',5820.94,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(425,7492,40787,102490,23,425,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',13783.79,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(426,7492,40787,102490,23,426,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1845563.75,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(427,7492,40787,102490,23,427,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',29388.48,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(428,7492,40787,102490,23,428,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',33838.34,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro` VALUES (429,7492,40787,102490,23,429,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',74973.17,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(430,7492,40787,102490,23,430,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',54776.60,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(431,7492,40787,102490,23,431,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',922835.83,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(432,7492,40787,102490,23,432,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',67032.42,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(433,7492,40787,102490,23,433,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4923.26,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(434,7492,40787,102490,23,434,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',7899.85,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(435,7492,40787,102490,23,435,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1565.62,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(436,7492,40787,102490,23,436,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',316592.87,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(437,7492,40787,102491,23,437,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5643.86,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(438,7492,40787,102491,23,438,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',4480.85,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(439,7492,40787,102491,23,439,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',264825.71,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(440,7492,40787,102491,23,440,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',10183.38,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(441,7492,40787,102491,23,441,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1538.74,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(442,7492,40787,102491,23,442,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',72127.90,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(443,7492,40787,102491,23,443,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',434.64,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(444,7492,40787,102491,23,444,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2332.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro` VALUES (445,7492,40787,102491,23,445,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',4006510.62,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(446,7492,40787,102491,23,446,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',25113.36,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(447,7492,40787,102491,23,447,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',159727.75,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(448,7492,40787,102491,23,448,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',49642.68,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(449,7492,40787,102491,23,449,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',116806.31,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(450,7492,40787,102491,23,450,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',23954.49,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(451,7492,40787,102491,23,451,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1540.36,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(452,7492,40787,102491,23,452,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',9750.96,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(453,7492,40787,102491,23,453,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',100162.76,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(454,7492,40787,102491,23,454,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',56909.93,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(455,7492,40787,102491,23,455,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',93844.55,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(456,7492,40787,102491,23,456,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',938.25,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(457,7492,40787,102491,23,457,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',17316.54,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(458,7492,40787,102491,23,458,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',478855.54,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(459,7492,40787,102491,23,459,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1080258.22,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(460,7492,40787,102491,23,460,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3856.55,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro` VALUES (461,7492,40787,102491,23,461,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2172.02,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(462,7492,40787,102491,23,462,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1171764.20,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(463,7492,40787,102491,23,463,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',23949.03,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(464,7492,40787,102491,23,464,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',27029.59,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(465,7492,40787,102491,23,465,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',36494.39,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(466,7492,40787,102492,23,466,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',6199065.15,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(467,7492,40787,102492,23,467,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',6457.59,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(468,7492,40787,102492,23,468,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',101362.65,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(469,7492,40787,102492,23,469,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',26607.70,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(470,7492,40787,102492,23,470,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2613.64,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(471,7492,40787,102492,23,471,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',24678.63,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(472,7492,40787,102492,23,472,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',816.34,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(473,7492,40787,102492,23,473,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',49140.82,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(474,7492,40787,102492,23,474,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',142816.37,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(475,7492,40787,102492,23,475,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',9833.96,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(476,7492,40787,102492,23,476,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',708.11,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro` VALUES (477,7492,40787,102492,23,477,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',115366.63,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(478,7492,40787,102492,23,478,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',653257.83,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(479,7492,40787,102492,23,479,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',6056.31,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(480,7492,40787,102492,23,480,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',60716.23,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(481,7492,40787,102492,23,481,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1284358.34,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(482,7492,40787,102492,23,482,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',53179.92,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(483,7492,40787,102492,23,483,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',144441.78,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(484,7492,40787,102492,23,484,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1884.84,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(485,7492,40787,102492,23,485,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',43653.22,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(486,7492,40787,102492,23,486,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',4397.23,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(487,7492,40787,102492,23,487,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',12160.26,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(488,7492,40787,102492,23,488,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',118777.34,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(489,7492,40787,102492,23,489,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',45177.48,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(490,7492,40787,102492,23,490,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',283476.43,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(491,7492,40787,102492,23,491,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',83734.80,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(492,7492,40787,102492,23,492,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',38199.48,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07');
INSERT INTO `balance_libro` VALUES (493,7492,40787,102492,23,493,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',358.31,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(494,7492,40787,102492,23,494,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1915.64,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(495,7492,40787,102494,23,495,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',21646.14,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(496,7492,40787,102494,23,496,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9720.91,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(497,7492,40787,102494,23,497,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',45653.38,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(498,7492,40787,102494,23,498,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2199.71,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(499,7492,40787,102494,23,499,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3828.62,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(500,7492,40787,102494,23,500,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',631.18,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(501,7492,40787,102494,23,501,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16980.70,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(502,7492,40787,102494,23,502,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',27103.87,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(503,7492,40787,102494,23,503,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',63757.28,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(504,7492,40787,102494,23,504,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2550291.18,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(505,7492,40787,102494,23,505,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',63635.05,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(506,7492,40787,102494,23,506,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1151.74,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(507,7492,40787,102494,23,507,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',6637.30,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(508,7492,40787,102494,23,508,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',34312.22,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07');
INSERT INTO `balance_libro` VALUES (509,7492,40787,102494,23,509,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',753816.34,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(510,7492,40787,102494,23,510,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',31391.31,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(511,7492,40787,102494,23,511,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',24005.45,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(512,7492,40787,102494,23,512,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1443.47,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(513,7492,40787,102494,23,513,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',100536.09,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(514,7492,40787,102494,23,514,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',44405.87,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(515,7492,40787,102494,23,515,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',981.52,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(516,7492,40787,102494,23,516,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',29381.70,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(517,7492,40787,102494,23,517,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2620.85,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(518,7492,40787,102494,23,518,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1767.30,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(519,7492,40787,102494,23,519,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1444912.93,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(520,7492,40787,102494,23,520,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',167775.55,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(521,7492,40787,102494,23,521,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',20471.73,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(522,7492,40787,102494,23,522,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',60684.21,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(523,7492,40787,102494,23,523,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',282.08,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(524,7492,40787,102494,23,524,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',48455.38,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07');
INSERT INTO `balance_libro` VALUES (525,7492,40787,102494,23,525,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',34312.22,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(526,7492,40787,102494,23,526,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',52011.81,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(527,7492,40787,102494,23,527,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4339.71,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(528,7492,40787,102495,23,528,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',16776.45,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(529,7492,40787,102495,23,529,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',27710.42,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(530,7492,40787,102495,23,530,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',19541.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(531,7492,40787,102495,23,531,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',982.97,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(532,7492,40787,102495,23,532,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1185.47,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(533,7492,40787,102495,23,533,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',454775.41,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(534,7492,40787,102495,23,534,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',49844.71,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(535,7492,40787,102495,23,535,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',44363.26,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(536,7492,40787,102495,23,536,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',31617.25,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(537,7492,40787,102495,23,537,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',501823.59,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(538,7492,40787,102495,23,538,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',25514.90,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(539,7492,40787,102495,23,539,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',21125.87,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(540,7492,40787,102495,23,540,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',115431.15,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07');
INSERT INTO `balance_libro` VALUES (541,7492,40787,102495,23,541,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3679.57,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(542,7492,40787,102495,23,542,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1207.48,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(543,7492,40787,102495,23,543,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',28209.00,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(544,7492,40787,102495,23,544,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',646.10,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(545,7492,40787,102495,23,545,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',23177.40,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(546,7492,40787,102495,23,546,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4236.88,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(547,7492,40787,102495,23,547,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',119728.95,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(548,7492,40787,102495,23,548,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1993788.25,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(549,7492,40787,102495,23,549,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',210.53,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(550,7492,40787,102495,23,550,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',796.55,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(551,7492,40787,102495,23,551,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',27197.16,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(552,7492,40787,102495,23,552,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',15808.62,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(553,7492,40787,102495,23,553,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',41102.42,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(554,7492,40787,102496,23,554,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',21387.46,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(555,7492,40787,102496,23,555,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',461.59,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(556,7492,40787,102496,23,556,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',45371.05,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07');
INSERT INTO `balance_libro` VALUES (557,7492,40787,102496,23,557,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',29066.69,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(558,7492,40787,102496,23,558,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',378301.85,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(559,7492,40787,102496,23,559,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3211.50,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(560,7492,40787,102496,23,560,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',70849.72,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(561,7492,40787,102496,23,561,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1219.70,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(562,7492,40787,102496,23,562,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',341.02,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(563,7492,40787,102496,23,563,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',30739.77,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(564,7492,40787,102496,23,564,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',4778098.79,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(565,7492,40787,102496,23,565,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1179.22,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(566,7492,40787,102496,23,566,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',9036.72,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(567,7492,40787,102496,23,567,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',29369.33,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(568,7492,40787,102496,23,568,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',67168.11,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(569,7492,40787,102496,23,569,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',20630.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(570,7492,40787,102496,23,570,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1395.12,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(571,7492,40787,102496,23,571,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',78261.78,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(572,7492,40787,102496,23,572,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',710.39,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07');
INSERT INTO `balance_libro` VALUES (573,7492,40787,102496,23,573,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',335.42,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(574,7492,40787,102496,23,574,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',573581.27,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(575,7492,40787,102496,23,575,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1379.29,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(576,7492,40787,102496,23,576,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',8102.91,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(577,7492,40787,102496,23,577,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',11626.93,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(578,7492,40787,102496,23,578,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',19744.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(579,7492,40787,102496,23,579,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',111349.56,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(580,7492,40787,102496,23,580,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',23510.13,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(581,7492,40787,102496,23,581,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3133.50,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(582,7492,40787,102496,23,582,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',15200.12,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(583,7492,40787,102496,23,583,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2.88,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(584,7492,40787,102496,23,584,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',6312.73,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(585,7492,40787,102497,23,585,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',9964.28,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(586,7492,40787,102497,23,586,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',10185.64,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(587,7492,40787,102497,23,587,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',28924.32,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(588,7492,40787,102497,23,588,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',339.88,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07');
INSERT INTO `balance_libro` VALUES (589,7492,40787,102497,23,589,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',344385.86,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(590,7492,40787,102497,23,590,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',106265.36,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(591,7492,40787,102497,23,591,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1165335.15,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(592,7492,40787,102497,23,592,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',3081.76,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(593,7492,40787,102497,23,593,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',15268.89,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(594,7492,40787,102497,23,594,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',703.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(595,7492,40787,102497,23,595,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',2695.36,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(596,7492,40787,102497,23,596,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',526.26,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(597,7492,40787,102497,23,597,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',17519.87,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(598,7492,40787,102497,23,598,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',64116.92,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(599,7492,40787,102497,23,599,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',10350.28,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(600,7492,40787,102497,23,600,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',11964.73,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(601,7492,40787,102497,23,601,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',188.98,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(602,7492,40787,102497,23,602,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',616.69,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(603,7492,40787,102497,23,603,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',10976.26,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(604,7492,40787,102497,23,604,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',38631.50,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07');
INSERT INTO `balance_libro` VALUES (605,7492,40787,102497,23,605,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1546.05,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(606,7492,40787,102497,23,606,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',5686111.51,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(607,7492,40787,102497,23,607,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',14186.13,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(608,7492,40787,102497,23,608,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',142152.79,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(609,7492,40787,102497,23,609,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',12830.35,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(610,7492,40787,102497,23,610,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',280.21,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(611,7492,40787,102497,23,611,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',526.26,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(612,7492,40787,102498,23,612,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',9296.82,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(613,7492,40787,102498,23,613,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2855.87,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(614,7492,40787,102498,23,614,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2294.26,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(615,7492,40787,102498,23,615,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',297.54,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(616,7492,40787,102498,23,616,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',512821.77,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(617,7492,40787,102498,23,617,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',573789.97,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(618,7492,40787,102498,23,618,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',14344.75,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(619,7492,40787,102498,23,619,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',35557.56,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(620,7492,40787,102498,23,620,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',83.94,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07');
INSERT INTO `balance_libro` VALUES (621,7492,40787,102498,23,621,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1256.31,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(622,7492,40787,102498,23,622,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',295.08,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(623,7492,40787,102498,23,623,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2582.83,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(624,7492,40787,102498,23,624,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',8725.41,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(625,7492,40787,102498,23,625,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2410.09,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(626,7492,40787,102498,23,626,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',3707.99,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(627,7492,40787,102498,23,627,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',16846.69,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(628,7492,40787,102498,23,628,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',4784.33,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(629,7492,40787,102498,23,629,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',15830.62,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(630,7492,40787,102498,23,630,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',18649.49,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(631,7492,40787,102498,23,631,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',162245.86,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(632,7492,40787,102498,23,632,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',449.66,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(633,7492,40787,102498,23,633,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1344.76,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(634,7492,40787,102487,12,634,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',13543790.04,'apertura',NULL,1,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(635,7492,40787,102487,12,635,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2460527.83,'recla',NULL,1,'2023-11-06 19:26:20','2023-11-06 19:27:57','2023-11-06 19:27:57'),(636,7492,40787,102487,12,636,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',13543790.04,'apertura',NULL,1,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26');
INSERT INTO `balance_libro` VALUES (637,7492,40787,102491,6,637,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',837335.32,'pago dj ganancias 2022',NULL,1,'2023-11-06 19:34:12','2023-11-06 19:34:12',NULL),(638,7492,40787,102491,10,638,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',62879.44,NULL,NULL,1,'2023-11-06 19:34:58','2023-11-06 19:34:58',NULL),(639,7492,40787,102491,6,639,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',214158.65,'recupero de prov',NULL,1,'2023-11-06 19:36:20','2023-11-09 05:57:24','2023-11-09 05:57:24'),(640,7492,40787,102492,6,640,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',9233.50,'PAGO ANTICIPOS',NULL,1,'2023-11-06 19:38:35','2023-11-06 19:38:35',NULL),(641,7492,40787,102494,6,641,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3076.60,'PAGO ANTICIPOS',NULL,1,'2023-11-06 19:38:58','2023-11-06 19:38:58',NULL),(642,7492,40787,102495,6,642,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3076.60,'PAGO ANTICIPOS',NULL,1,'2023-11-06 19:39:15','2023-11-06 19:39:15',NULL),(643,7492,40787,102496,6,643,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',3076.60,'PAGO ANTICIPOS',NULL,1,'2023-11-06 19:39:31','2023-11-06 19:39:31',NULL),(644,7492,40787,102497,6,644,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',3076.60,'PAGO ANTICIPOS',NULL,1,'2023-11-06 19:39:47','2023-11-06 19:39:47',NULL),(645,7492,40787,102498,6,645,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',3076.60,'PAGO ANTICIPOS',NULL,1,'2023-11-06 19:40:03','2023-11-06 19:40:03',NULL),(646,7492,40787,102499,6,646,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',3076.60,'PAGO ANTICIPOS',NULL,1,'2023-11-06 19:40:23','2023-11-06 19:40:23',NULL),(647,7492,40787,102500,6,647,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',3076.60,'PAGO ANTICIPOS',NULL,1,'2023-11-06 19:40:42','2024-10-02 18:08:25','2024-10-02 18:08:25'),(648,7492,40787,102501,6,648,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',3076.60,'PAGO ANTICIPOS',NULL,1,'2023-11-06 19:40:57','2024-10-03 09:29:28','2024-10-03 09:29:28'),(649,7492,40787,102502,6,649,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',3076.60,'PAGO ANTICIPOS',NULL,1,'2023-11-06 19:41:30','2024-10-03 09:54:56','2024-10-03 09:54:56'),(650,7492,40787,102487,1,650,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1022518.47,'SUELDOS',NULL,1,'2023-11-06 19:45:53','2023-11-06 19:49:40','2023-11-06 19:49:40'),(651,7492,40787,102487,1,651,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1022518.47,'SUELDOS',NULL,1,'2023-11-06 19:49:40','2023-11-06 19:49:40',NULL),(652,7492,40787,102488,1,652,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1310488.35,'SUELDOS',NULL,1,'2023-11-06 19:52:45','2023-11-06 19:52:45',NULL),(653,7492,40787,102489,1,653,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1541795.33,'SUELDOS',NULL,1,'2023-11-06 19:55:14','2023-11-06 19:55:14',NULL),(654,7492,40787,102490,1,654,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1609179.32,'SUELDOS',NULL,1,'2023-11-06 19:58:20','2023-11-06 19:58:20',NULL),(655,7492,40787,102491,1,655,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2282417.78,'SUELDOS',NULL,1,'2023-11-06 20:01:01','2023-11-06 20:01:01',NULL);
INSERT INTO `balance_libro` VALUES (656,7492,40787,102492,1,656,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3159854.07,'SUELDOS',NULL,1,'2023-11-06 20:03:24','2023-11-06 20:03:24',NULL),(657,7492,40787,102494,1,657,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2055052.50,'SUELDOS',NULL,1,'2023-11-06 20:08:03','2023-11-06 20:08:03',NULL),(658,7492,40787,102495,1,658,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1869502.69,'SUELDOS',NULL,1,'2023-11-06 20:09:48','2023-11-06 20:09:48',NULL),(659,7492,40787,102496,1,659,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1873489.33,'SUELDOS',NULL,1,'2023-11-06 20:11:40','2023-11-06 20:11:40',NULL),(660,7492,40787,102497,1,660,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',2354816.85,'SUELDOS',NULL,1,'2023-11-06 20:13:22','2023-11-06 20:13:22',NULL),(661,7492,40787,102498,1,661,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',3084396.74,'SUELDOS',NULL,1,'2023-11-06 20:15:27','2023-11-06 20:15:27',NULL),(662,7492,40787,102499,1,662,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4915924.94,'SUELDOS',NULL,1,'2023-11-06 20:17:09','2023-11-06 20:17:09',NULL),(663,7492,40787,102487,3,663,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1504674.60,'COSTO DEL SERVICIO',NULL,1,'2023-11-06 20:21:10','2023-11-08 08:55:09','2023-11-08 08:55:09'),(664,7492,40787,102488,3,664,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',4027735.52,'COSTO DEL SERVICIO',NULL,1,'2023-11-06 20:21:56','2023-11-08 08:55:39','2023-11-08 08:55:39'),(665,7492,40787,102489,3,665,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',8671705.90,'COSTO DEL SERVICIO',NULL,1,'2023-11-06 20:22:37','2023-11-08 08:56:04','2023-11-08 08:56:04'),(666,7492,40787,102490,3,666,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2124082.39,'COSTO DEL SERVICIO',NULL,1,'2023-11-06 20:23:15','2023-11-09 07:13:32','2023-11-09 07:13:32'),(667,7492,40787,102491,3,667,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3910252.96,'COSTO DEL SERVICIO',NULL,1,'2023-11-06 20:23:44','2023-11-06 20:23:44',NULL),(668,7492,40787,102492,3,668,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',6971930.99,'COSTO DEL SERVICIO',NULL,1,'2023-11-06 20:24:09','2023-11-08 08:56:37','2023-11-08 08:56:37'),(669,7492,40787,102494,3,669,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',34516728.31,'COSTO DEL SERVICIO',NULL,1,'2023-11-06 20:25:05','2023-11-08 08:58:31','2023-11-08 08:58:31'),(670,7492,40787,102495,3,670,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3414707.17,'COSTO DEL SERVICIO',NULL,1,'2023-11-06 20:25:22','2023-11-08 08:59:28','2023-11-08 08:59:28'),(671,7492,40787,102496,3,671,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',11452568.20,'COSTO DEL SERVICIO',NULL,1,'2023-11-06 20:25:48','2023-11-08 08:57:19','2023-11-08 08:57:19'),(672,7492,40787,102497,3,672,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',22846850.58,'COSTO DEL SERVICIO',NULL,1,'2023-11-06 20:26:10','2023-11-08 08:57:53','2023-11-08 08:57:53'),(673,7492,40787,102498,3,673,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',5496043.00,'COSTO DEL SERVICIO',NULL,1,'2023-11-06 20:26:40','2023-11-08 08:59:57','2023-11-08 08:59:57');
INSERT INTO `balance_libro` VALUES (674,7492,40787,102498,3,674,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',5496043.00,'COSTO DEL SERVICIO',NULL,1,'2023-11-06 20:26:40','2023-11-06 20:26:40',NULL),(675,7492,40787,102499,3,675,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',13387244.93,'COSTO DEL SERVICIO',NULL,1,'2023-11-06 20:27:13','2023-11-08 08:42:53','2023-11-08 08:42:53'),(676,7492,40787,102487,2,676,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3194133.80,'VENTAS',NULL,1,'2023-11-07 06:18:44','2023-11-07 06:18:44',NULL),(677,7492,40787,102488,2,677,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',8550105.23,'VENTAS',NULL,1,'2023-11-07 06:19:24','2023-11-07 06:19:24',NULL),(678,7492,40787,102489,2,678,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',18408358.15,'VENTAS',NULL,1,'2023-11-07 06:19:57','2023-11-07 06:19:57',NULL),(679,7492,40787,102490,2,679,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4509016.99,'VENTAS',NULL,1,'2023-11-07 06:21:15','2023-11-07 06:21:15',NULL),(680,7492,40787,102491,2,680,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',8300712.32,'VENTAS',NULL,1,'2023-11-07 06:21:59','2023-11-07 06:21:59',NULL),(681,7492,40787,102492,2,681,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',14800064.02,'VENTAS',NULL,1,'2023-11-07 06:22:31','2023-11-07 06:22:31',NULL),(682,7492,40787,102494,2,682,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7327235.31,'VENTAS',NULL,1,'2023-11-07 06:23:18','2023-11-07 06:23:18',NULL),(683,7492,40787,102495,2,683,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7248764.35,'VENTAS',NULL,1,'2023-11-07 06:23:57','2023-11-07 06:23:57',NULL),(684,7492,40787,102496,2,684,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',24311592.15,'VENTAS',NULL,1,'2023-11-07 06:24:34','2023-11-07 06:24:34',NULL),(685,7492,40787,102497,2,685,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',48499454.74,'VENTAS',NULL,1,'2023-11-07 06:25:11','2023-11-07 06:25:11',NULL),(686,7492,40787,102498,2,686,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',11667038.66,'VENTAS',NULL,1,'2023-11-07 06:25:43','2023-11-07 06:25:43',NULL),(687,7492,40787,102499,2,687,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',28418537.48,'VENTAS',NULL,1,'2023-11-07 06:26:16','2023-11-07 06:26:16',NULL),(688,7492,40787,102487,3,688,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1357395.67,'COMPRAS',NULL,1,'2023-11-07 06:37:08','2023-11-07 06:37:08',NULL),(689,7492,40787,102488,3,689,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1848790.33,'COMPRAS',NULL,1,'2023-11-07 06:40:11','2023-11-07 06:40:11',NULL),(690,7492,40787,102489,3,690,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',3511884.04,'COMPRAS',NULL,1,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(691,7492,40787,102490,3,691,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4524752.98,'COMPRAS',NULL,1,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(692,7492,40787,102491,3,692,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',4553149.74,'COMPRAS',NULL,1,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL);
INSERT INTO `balance_libro` VALUES (693,7492,40787,102492,3,693,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3156512.86,'COMPRAS',NULL,1,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(694,7492,40787,102494,3,694,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4996942.34,'COMPRAS',NULL,1,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(695,7492,40787,102495,3,695,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2735029.70,'COMPRAS',NULL,1,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(696,7492,40787,102496,3,696,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3841982.88,'COMPRAS',NULL,1,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(697,7492,40787,102497,3,697,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',11262317.65,'COMPRAS',NULL,1,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(698,7492,40787,102498,3,698,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',7047593.68,'COMPRAS',NULL,1,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL),(699,7492,40787,102499,3,699,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',7174843.93,'COMPRAS',NULL,1,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(700,7492,40787,102487,15,700,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',554353.80,'IVA',NULL,1,'2023-11-07 09:49:13','2023-11-07 09:49:13',NULL),(701,7492,40787,102488,15,701,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1483902.56,'IVA',NULL,1,'2023-11-07 09:50:02','2023-11-07 09:50:02',NULL),(702,7492,40787,102489,15,702,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',3194839.02,'IVA',NULL,1,'2023-11-07 09:51:03','2023-11-07 09:51:03',NULL),(703,7492,40787,102490,15,703,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1036015.03,'IVA',NULL,1,'2023-11-07 09:52:36','2023-11-07 09:52:36',NULL),(704,7492,40787,102491,15,704,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1440619.51,'IVA',NULL,1,'2023-11-07 09:53:36','2023-11-07 09:53:36',NULL),(705,7492,40787,102492,15,705,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2568606.15,'IVA',NULL,1,'2023-11-07 09:54:30','2023-11-07 09:54:30',NULL),(706,7492,40787,102494,15,706,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1271668.94,'IVA',NULL,1,'2023-11-07 09:55:22','2023-11-07 09:55:22',NULL),(707,7492,40787,102495,15,707,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',1258050.01,'IVA',NULL,1,'2023-11-07 09:56:26','2023-11-07 09:56:26',NULL),(708,7492,40787,102496,15,708,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',4219367.23,'IVA',NULL,1,'2023-11-07 09:57:22','2023-11-07 09:57:22',NULL),(709,7492,40787,102497,15,709,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',8417260.74,'IVA',NULL,1,'2023-11-07 09:58:05','2023-11-07 09:58:05',NULL),(710,7492,40787,102498,15,710,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',2024857.95,'IVA',NULL,1,'2023-11-07 09:58:56','2023-11-07 09:58:56',NULL),(711,7492,40787,102499,15,711,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',4932142.87,'IVA',NULL,1,'2023-11-07 09:59:43','2023-11-07 09:59:43',NULL),(712,7492,40787,102487,1,712,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',288000.00,NULL,NULL,1,'2023-11-07 10:03:25','2023-11-07 10:03:25',NULL);
INSERT INTO `balance_libro` VALUES (713,7492,40787,102487,16,713,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',97157.72,'IIBB',NULL,1,'2023-11-07 10:05:03','2023-11-07 10:05:03',NULL),(714,7492,40787,102488,1,714,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',110216.00,NULL,NULL,1,'2023-11-07 10:06:05','2023-11-07 10:06:05',NULL),(715,7492,40787,102489,1,715,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',121200.00,NULL,NULL,1,'2023-11-07 10:08:18','2023-11-07 10:08:18',NULL),(716,7492,40787,102488,16,716,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',176655.07,'IIBB',NULL,1,'2023-11-07 10:08:23','2023-11-07 10:08:23',NULL),(717,7492,40787,102489,16,717,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',380337.98,'IIBB',NULL,1,'2023-11-07 10:09:12','2023-11-07 10:09:12',NULL),(718,7492,40787,102490,1,718,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',223500.00,NULL,NULL,1,'2023-11-07 10:09:46','2023-11-07 10:09:46',NULL),(719,7492,40787,102490,16,719,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',51122.67,'IIBB',NULL,1,'2023-11-07 10:10:11','2023-11-07 10:10:11',NULL),(720,7492,40787,102491,1,720,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',182112.00,NULL,NULL,1,'2023-11-07 10:10:59','2023-11-07 10:10:59',NULL),(721,7492,40787,102491,16,721,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',171502.32,'IIBB',NULL,1,'2023-11-07 10:11:38','2023-11-07 10:11:38',NULL),(722,7492,40787,102492,16,722,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',305786.45,'IIBB',NULL,1,'2023-11-07 10:12:53','2023-11-07 10:12:53',NULL),(723,7492,40787,102492,1,723,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',162000.00,NULL,NULL,1,'2023-11-07 10:13:28','2023-11-07 10:13:28',NULL),(724,7492,40787,102494,16,724,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',152887.87,'IIBB',NULL,1,'2023-11-07 10:14:12','2023-11-07 10:14:12',NULL),(725,7492,40787,102494,1,725,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',285000.00,NULL,NULL,1,'2023-11-07 10:14:18','2023-11-07 10:14:18',NULL),(726,7492,40787,102495,1,726,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',132000.00,NULL,NULL,1,'2023-11-07 10:15:33','2023-11-07 10:15:33',NULL),(727,7492,40787,102495,16,727,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',150129.22,'IIBB',NULL,1,'2023-11-07 10:15:41','2023-11-07 10:15:41',NULL),(728,7492,40787,102496,16,728,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',502305.62,'IIBB',NULL,1,'2023-11-07 10:17:11','2023-11-07 10:17:11',NULL),(729,7492,40787,102496,1,729,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',269000.00,NULL,NULL,1,'2023-11-07 10:17:28','2023-11-07 10:17:28',NULL),(730,7492,40787,102497,1,730,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',730000.00,NULL,NULL,1,'2023-11-07 10:18:14','2023-11-07 10:18:14',NULL),(731,7492,40787,102497,16,731,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',1002347.60,'IIBB',NULL,1,'2023-11-07 10:18:33','2023-11-07 10:18:33',NULL),(732,7492,40787,102498,1,732,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',507000.00,NULL,NULL,1,'2023-11-07 10:19:00','2023-11-07 10:19:00',NULL);
INSERT INTO `balance_libro` VALUES (733,7492,40787,102499,1,733,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',500000.00,NULL,NULL,1,'2023-11-07 10:19:57','2023-11-07 10:19:57',NULL),(734,7492,40787,102498,16,734,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',241209.27,'IIBB',NULL,1,'2023-11-07 10:20:03','2023-11-07 10:20:03',NULL),(735,7492,40787,102499,16,735,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',587159.86,'IIBB',NULL,1,'2023-11-07 10:21:45','2023-11-07 10:21:45',NULL),(736,7492,40787,102487,1,736,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',462666.11,'PAGO SUELDOS /CARGAS SOCIALES',NULL,1,'2023-11-07 10:37:18','2023-11-07 10:37:18',NULL),(737,7492,40787,102488,1,737,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',421807.14,'PAGO SUELDOS /CARGAS SOCIALES',NULL,1,'2023-11-07 10:38:30','2023-11-07 10:38:30',NULL),(738,7492,40787,102489,1,738,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',518011.26,'PAGO SUELDOS /CARGAS SOCIALES',NULL,1,'2023-11-07 10:39:52','2023-11-07 10:39:52',NULL),(739,7492,40787,102490,1,739,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',560338.62,'PAGO SUELDOS /CARGAS SOCIALES',NULL,1,'2023-11-07 10:41:19','2023-11-07 10:41:19',NULL),(740,7492,40787,102491,1,740,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',628202.75,'PAGO SUELDOS /CARGAS SOCIALES',NULL,1,'2023-11-07 10:42:52','2023-11-07 10:42:52',NULL),(741,7492,40787,102492,1,741,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',848336.75,'PAGO SUELDOS /CARGAS SOCIALES',NULL,1,'2023-11-07 10:43:48','2023-11-07 10:43:48',NULL),(742,7492,40787,102494,1,742,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1071324.86,'PAGO SUELDOS /CARGAS SOCIALES',NULL,1,'2023-11-07 10:44:50','2023-11-07 10:44:50',NULL),(743,7492,40787,102495,1,743,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',780285.55,'PAGO SUELDOS /CARGAS SOCIALES',NULL,1,'2023-11-07 10:46:07','2023-11-07 10:46:07',NULL),(744,7492,40787,102496,1,744,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',762563.64,'PAGO SUELDOS /CARGAS SOCIALES',NULL,1,'2023-11-07 10:47:08','2023-11-07 10:47:08',NULL),(745,7492,40787,102497,1,745,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',579674.15,'PAGO SUELDOS /CARGAS SOCIALES',NULL,1,'2023-11-07 10:48:09','2023-11-07 10:48:09',NULL),(746,7492,40787,102498,1,746,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',691962.42,'PAGO SUELDOS /CARGAS SOCIALES',NULL,1,'2023-11-07 10:50:03','2023-11-07 10:50:03',NULL),(747,7492,40787,102499,1,747,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',1228902.72,'PAGO SUELDOS /CARGAS SOCIALES',NULL,1,'2023-11-07 10:51:22','2023-11-07 10:51:22',NULL),(748,7492,40787,102487,3,748,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2013379.42,NULL,NULL,1,'2023-11-07 11:15:04','2023-11-07 11:15:04',NULL),(749,7492,40787,102487,3,749,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',44521.18,NULL,NULL,1,'2023-11-07 11:18:37','2023-11-07 11:18:37',NULL),(750,7492,40787,102487,3,750,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',50039.61,NULL,NULL,1,'2023-11-07 11:20:03','2023-11-07 11:20:03',NULL);
INSERT INTO `balance_libro` VALUES (751,7492,40787,102488,3,751,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',932734.17,NULL,NULL,1,'2023-11-07 11:24:21','2023-11-07 11:24:21',NULL),(752,7492,40787,102488,3,752,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',47548.59,NULL,NULL,1,'2023-11-07 11:26:31','2023-11-07 11:26:31',NULL),(753,7492,40787,102488,3,753,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',38988.95,NULL,NULL,1,'2023-11-07 11:27:46','2023-11-07 11:27:46',NULL),(754,7492,40787,102487,20,754,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1922543.52,NULL,NULL,1,'2023-11-07 11:29:02','2023-11-07 11:29:02',NULL),(755,7492,40787,102488,20,755,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3904693.28,NULL,NULL,1,'2023-11-07 11:30:26','2023-11-07 11:30:26',NULL),(756,7492,40787,102489,20,756,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',10927074.94,NULL,NULL,1,'2023-11-07 11:31:35','2023-11-07 11:31:35',NULL),(757,7492,40787,102489,3,757,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',6520057.73,NULL,NULL,1,'2023-11-07 11:32:24','2023-11-08 08:06:32','2023-11-08 08:06:32'),(758,7492,40787,102490,20,758,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',6413486.31,NULL,NULL,1,'2023-11-07 11:32:51','2023-11-07 11:32:51',NULL),(759,7492,40787,102491,20,759,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',16154783.44,NULL,NULL,1,'2023-11-07 11:34:00','2023-11-07 11:34:00',NULL),(760,7492,40787,102492,20,760,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',12731467.70,NULL,NULL,1,'2023-11-07 11:34:56','2023-11-07 11:34:56',NULL),(761,7492,40787,102494,20,761,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',13767864.28,NULL,NULL,1,'2023-11-07 11:36:03','2023-11-07 11:36:03',NULL),(762,7492,40787,102495,20,762,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4019952.60,NULL,NULL,1,'2023-11-07 11:37:11','2023-11-07 11:37:11',NULL),(763,7492,40787,102496,20,763,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',23436611.92,NULL,NULL,1,'2023-11-07 11:38:18','2023-11-07 11:38:18',NULL),(764,7492,40787,102497,20,764,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',25019501.20,NULL,NULL,1,'2023-11-07 11:39:13','2023-11-07 11:39:13',NULL),(765,7492,40787,102498,20,765,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',21385950.97,NULL,NULL,1,'2023-11-07 11:40:13','2023-11-08 08:37:54','2023-11-08 08:37:54'),(766,7492,40787,102499,20,766,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',17443107.34,NULL,NULL,1,'2023-11-07 11:42:21','2023-11-07 11:42:21',NULL),(767,7492,40787,102490,3,767,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',8280305.77,NULL,NULL,1,'2023-11-07 11:43:26','2023-11-07 11:43:26',NULL),(768,7492,40787,102491,3,768,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',13308180.61,NULL,NULL,1,'2023-11-08 06:23:04','2023-11-08 06:23:04',NULL),(769,7492,40787,102492,3,769,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',11750316.71,NULL,NULL,1,'2023-11-08 06:28:57','2023-11-08 08:06:10','2023-11-08 08:06:10'),(770,7492,40787,102487,3,770,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',54222.09,NULL,NULL,1,'2023-11-08 06:31:57','2023-11-08 06:31:57',NULL);
INSERT INTO `balance_libro` VALUES (771,7492,40787,102488,3,771,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',102765.27,NULL,NULL,1,'2023-11-08 06:34:04','2023-11-08 06:34:04',NULL),(772,7492,40787,102489,3,772,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',38616.05,NULL,NULL,1,'2023-11-08 06:36:30','2023-11-08 06:36:30',NULL),(773,7492,40787,102490,3,773,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',64557.75,NULL,NULL,1,'2023-11-08 06:38:23','2023-11-08 06:38:23',NULL),(774,7492,40787,102491,3,774,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',47256.23,NULL,NULL,1,'2023-11-08 06:40:13','2023-11-08 06:40:13',NULL),(775,7492,40787,102492,3,775,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',75567.83,NULL,NULL,1,'2023-11-08 06:42:07','2023-11-08 06:42:07',NULL),(776,7492,40787,102494,3,776,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5214077.74,NULL,NULL,1,'2023-11-08 06:46:26','2023-11-09 06:08:06','2023-11-09 06:08:06'),(777,7492,40787,102495,3,777,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',4674243.99,NULL,NULL,1,'2023-11-08 06:49:34','2023-11-08 06:49:34',NULL),(778,7492,40787,102496,3,778,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',13171515.24,NULL,NULL,1,'2023-11-08 06:52:18','2023-11-08 06:52:18',NULL),(779,7492,40787,102497,3,779,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',11381681.87,NULL,NULL,1,'2023-11-08 06:54:55','2023-11-08 06:54:55',NULL),(780,7492,40787,102498,3,780,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',18376092.11,NULL,NULL,1,'2023-11-08 06:58:52','2023-11-08 06:58:52',NULL),(781,7492,40787,102499,3,781,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',10789128.68,NULL,NULL,1,'2023-11-08 07:01:52','2023-11-08 07:01:52',NULL),(782,7492,40787,102494,3,782,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',232869.57,NULL,NULL,1,'2023-11-08 07:04:26','2023-11-08 07:04:26',NULL),(783,7492,40787,102495,3,783,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',31374.41,NULL,NULL,1,'2023-11-08 07:06:23','2023-11-08 07:06:23',NULL),(784,7492,40787,102496,3,784,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',195558.56,NULL,NULL,1,'2023-11-08 07:08:39','2023-11-08 07:08:39',NULL),(785,7492,40787,102497,3,785,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',306335.06,NULL,NULL,1,'2023-11-08 07:10:54','2023-11-08 07:10:54',NULL),(786,7492,40787,102498,3,786,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2565391.25,NULL,NULL,1,'2023-11-08 07:13:11','2023-11-08 07:13:11',NULL),(787,7492,40787,102499,3,787,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',2139651.69,NULL,NULL,1,'2023-11-08 07:15:33','2023-11-08 07:15:33',NULL),(788,7492,40787,102499,2,788,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',3204497.27,NULL,NULL,1,'2023-11-08 08:00:14','2023-11-08 08:00:14',NULL),(789,7492,40787,102499,2,789,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',2676094.87,NULL,NULL,1,'2023-11-08 08:01:19','2023-11-08 08:01:19',NULL),(790,7492,40787,102499,3,790,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',252551.35,NULL,NULL,1,'2023-11-08 08:03:19','2023-11-08 08:07:42','2023-11-08 08:07:42');
INSERT INTO `balance_libro` VALUES (791,7492,40787,102492,3,791,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',11750316.71,NULL,NULL,1,'2023-11-08 08:06:10','2023-11-08 08:06:10',NULL),(792,7492,40787,102489,3,792,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',6520057.73,NULL,NULL,1,'2023-11-08 08:06:32','2023-11-09 06:17:49','2023-11-09 06:17:49'),(793,7492,40787,102499,3,793,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',10180.00,NULL,NULL,1,'2023-11-08 08:09:44','2023-11-08 08:09:44',NULL),(794,7492,40787,102498,20,794,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',21385950.97,NULL,NULL,1,'2023-11-08 08:37:54','2023-11-08 08:42:11','2023-11-08 08:42:11'),(795,7492,40787,102498,20,795,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',21385950.97,NULL,NULL,1,'2023-11-08 08:42:11','2023-11-08 08:42:11',NULL),(796,7492,40787,102499,3,796,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',13387244.93,'COSTO DEL SERVICIO',NULL,1,'2023-11-08 08:42:53','2023-11-08 08:54:15','2023-11-08 08:54:15'),(797,7492,40787,102499,4,797,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',650386.53,NULL,NULL,1,'2023-11-08 08:45:56','2023-11-08 09:26:08','2023-11-08 09:26:08'),(798,7492,40787,102487,12,798,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',11524705.60,'apertura',NULL,1,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(799,7492,40787,102499,3,799,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',13387244.93,'COSTO DEL SERVICIO',NULL,1,'2023-11-08 08:54:15','2023-11-08 09:00:20','2023-11-08 09:00:20'),(800,7492,40787,102487,3,800,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1319890.00,'COSTO DEL SERVICIO',NULL,1,'2023-11-08 08:55:09','2023-11-08 08:55:09',NULL),(801,7492,40787,102488,3,801,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3533101.34,'COSTO DEL SERVICIO',NULL,1,'2023-11-08 08:55:39','2023-11-08 08:55:39',NULL),(802,7492,40787,102489,3,802,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',7606759.57,'COSTO DEL SERVICIO',NULL,1,'2023-11-08 08:56:04','2023-11-09 07:13:58','2023-11-09 07:13:58'),(803,7492,40787,102492,3,803,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',6115728.94,'COSTO DEL SERVICIO',NULL,1,'2023-11-08 08:56:37','2023-11-08 08:56:37',NULL),(804,7492,40787,102496,3,804,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',10046112.46,'COSTO DEL SERVICIO',NULL,1,'2023-11-08 08:57:19','2023-11-09 07:18:17','2023-11-09 07:18:17'),(805,7492,40787,102497,3,805,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',20041097.00,'COSTO DEL SERVICIO',NULL,1,'2023-11-08 08:57:53','2023-11-08 09:00:53','2023-11-08 09:00:53'),(806,7492,40787,102494,3,806,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3027783.19,'COSTO DEL SERVICIO',NULL,1,'2023-11-08 08:58:31','2023-11-09 07:28:57','2023-11-09 07:28:57'),(807,7492,40787,102495,3,807,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2995357.17,'COSTO DEL SERVICIO',NULL,1,'2023-11-08 08:59:28','2023-11-08 08:59:28',NULL),(808,7492,40787,102498,3,808,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',4821090.36,'COSTO DEL SERVICIO',NULL,1,'2023-11-08 08:59:57','2023-11-08 08:59:57',NULL);
INSERT INTO `balance_libro` VALUES (809,7492,40787,102499,3,809,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',11273469.41,'COSTO DEL SERVICIO',NULL,1,'2023-11-08 09:00:20','2023-11-09 07:14:28','2023-11-09 07:14:28'),(810,7492,40787,102497,3,810,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',16032877.60,'COSTO DEL SERVICIO',NULL,1,'2023-11-08 09:00:53','2023-11-09 07:14:13','2023-11-09 07:14:13'),(816,7492,40787,102499,18,816,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',95769514.57,NULL,NULL,1,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(817,7492,40787,102499,18,817,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',42771901.94,NULL,NULL,1,'2023-11-08 09:23:49','2023-11-08 09:23:49',NULL),(818,7492,40787,102499,4,818,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',650386.53,NULL,NULL,1,'2023-11-08 09:26:08','2023-11-09 06:37:06','2023-11-09 06:37:06'),(819,7492,40787,102499,1,819,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',22951967.70,NULL,NULL,1,'2023-11-08 09:28:41','2023-11-08 09:28:41',NULL),(820,7492,40787,102499,18,820,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',3612697.36,NULL,NULL,1,'2023-11-08 09:39:26','2023-11-09 05:56:30','2023-11-09 05:56:30'),(821,7492,40787,102499,18,821,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',10180.00,NULL,NULL,1,'2023-11-08 09:49:59','2023-11-08 09:49:59',NULL),(822,7492,40787,102487,12,822,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',13543790.04,'apertura',NULL,1,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(823,7492,40787,102499,18,823,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1825113.18,NULL,NULL,1,'2023-11-09 05:44:44','2023-11-11 09:32:20','2023-11-11 09:32:20'),(824,7492,40787,102487,12,824,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',13543790.04,'apertura',NULL,1,'2023-11-09 05:55:38','2023-11-09 05:55:38',NULL),(825,7492,40787,102499,18,825,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',3612697.36,NULL,NULL,1,'2023-11-09 05:56:30','2023-11-09 05:56:30',NULL),(826,7492,40787,102491,6,826,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',214158.65,'recupero de prov',NULL,1,'2023-11-09 05:57:24','2023-11-09 05:57:24',NULL),(827,7492,40787,102494,3,827,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5214077.74,NULL,NULL,1,'2023-11-09 06:08:06','2023-11-09 06:08:06',NULL),(828,7492,40787,102487,19,828,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',71560.47,'Devengamiento intereses Afip',NULL,1,'2023-11-09 06:13:01','2023-11-09 06:14:52','2023-11-09 06:14:52'),(829,7492,40787,102488,19,829,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',71560.47,'Devengamiento intereses Afip',NULL,1,'2023-11-09 06:13:23','2023-11-09 06:18:08','2023-11-09 06:18:08'),(830,7492,40787,102489,19,830,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',71560.47,'Devengamiento intereses Afip',NULL,1,'2023-11-09 06:13:52','2023-11-09 06:15:05','2023-11-09 06:15:05'),(831,7492,40787,102499,11,831,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',18808.56,'int devengados AGIP 2023',NULL,1,'2023-11-09 06:14:35','2023-11-09 06:14:35',NULL);
INSERT INTO `balance_libro` VALUES (832,7492,40787,102487,19,832,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',71560.47,'Devengamiento intereses Afip',NULL,1,'2023-11-09 06:14:52','2023-11-09 06:14:52',NULL),(833,7492,40787,102489,19,833,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',71560.47,'Devengamiento intereses Afip',NULL,1,'2023-11-09 06:15:05','2023-11-09 06:15:05',NULL),(834,7492,40787,102489,3,834,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',6520057.73,NULL,NULL,1,'2023-11-09 06:17:49','2023-11-09 06:17:49',NULL),(835,7492,40787,102488,19,835,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',71560.47,'Devengamiento intereses Afip',NULL,1,'2023-11-09 06:18:09','2023-11-09 06:18:09',NULL),(836,7492,40787,102490,19,836,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',71560.47,'Devengamiento intereses Afip',NULL,1,'2023-11-09 06:18:42','2023-11-09 06:18:42',NULL),(837,7492,40787,102491,19,837,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',71560.47,'Devengamiento intereses Afip',NULL,1,'2023-11-09 06:18:59','2023-11-09 06:18:59',NULL),(838,7492,40787,102492,19,838,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',71560.47,'Devengamiento intereses Afip',NULL,1,'2023-11-09 06:19:15','2023-11-09 06:19:15',NULL),(839,7492,40787,102494,19,839,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',71560.47,'Devengamiento intereses Afip',NULL,1,'2023-11-09 06:19:29','2023-11-09 06:19:29',NULL),(840,7492,40787,102495,19,840,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',71560.47,'Devengamiento intereses Afip',NULL,1,'2023-11-09 06:19:49','2023-11-09 06:19:49',NULL),(841,7492,40787,102496,19,841,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',71560.47,'Devengamiento intereses Afip',NULL,1,'2023-11-09 06:20:03','2023-11-09 06:20:03',NULL),(842,7492,40787,102497,19,842,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',71560.47,'Devengamiento intereses Afip',NULL,1,'2023-11-09 06:20:18','2023-11-09 06:20:18',NULL),(843,7492,40787,102498,19,843,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',71560.47,'Devengamiento intereses Afip',NULL,1,'2023-11-09 06:20:34','2023-11-09 06:20:34',NULL),(844,7492,40787,102499,19,844,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',71560.47,'Devengamiento intereses Afip',NULL,1,'2023-11-09 06:20:52','2023-11-09 06:20:52',NULL),(845,7492,40787,102499,18,845,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',94911200.71,NULL,NULL,1,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(846,7492,40787,102499,18,846,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',94911200.71,NULL,NULL,1,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(847,7492,40787,102499,18,847,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',94911200.72,NULL,NULL,1,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(848,7492,40787,102499,4,848,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',650386.53,NULL,NULL,1,'2023-11-09 06:37:06','2023-11-09 06:37:06',NULL),(849,7492,40787,102499,18,849,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',94911200.73,NULL,NULL,1,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58');
INSERT INTO `balance_libro` VALUES (850,7492,40787,102490,3,850,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2424082.39,'COSTO DEL SERVICIO',NULL,1,'2023-11-09 07:13:32','2023-11-09 07:13:32',NULL),(851,7492,40787,102489,3,851,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',7906759.57,'COSTO DEL SERVICIO',NULL,1,'2023-11-09 07:13:58','2023-11-09 07:13:58',NULL),(852,7492,40787,102497,3,852,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',16332877.60,'COSTO DEL SERVICIO',NULL,1,'2023-11-09 07:14:13','2023-11-09 07:14:13',NULL),(853,7492,40787,102499,3,853,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',11573469.41,'COSTO DEL SERVICIO',NULL,1,'2023-11-09 07:14:28','2023-11-09 07:14:28',NULL),(854,7492,40787,102496,3,854,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',10346112.46,'COSTO DEL SERVICIO',NULL,1,'2023-11-09 07:18:17','2023-11-09 07:18:17',NULL),(855,7492,40787,102494,3,855,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3327783.19,'COSTO DEL SERVICIO',NULL,1,'2023-11-09 07:28:57','2023-11-09 07:28:57',NULL),(856,7492,40787,102499,18,856,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1825113.18,NULL,NULL,1,'2023-11-11 09:32:20','2023-11-11 09:33:00','2023-11-11 09:33:00'),(857,7492,40787,102499,18,857,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',94911200.73,NULL,NULL,1,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(858,7492,40787,102499,18,858,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',94911200.73,NULL,NULL,1,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(859,7492,40787,102499,23,859,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',65627295.52,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-11-11 10:36:30','2023-11-11 10:36:43',NULL),(860,7492,40787,102499,6,860,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',5860955.98,NULL,NULL,1,'2023-11-11 11:24:47','2023-11-11 11:24:47',NULL),(861,7492,40787,102500,2,861,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',16531425.34,NULL,NULL,1,'2023-11-29 13:34:07','2023-11-29 13:34:07',NULL),(862,7492,40787,102500,3,862,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2878973.07,NULL,NULL,1,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(863,7492,40787,102500,16,863,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',277692.70,NULL,NULL,1,'2023-11-29 14:09:40','2024-09-19 17:27:39','2024-09-19 17:27:39'),(864,7492,40787,102500,15,864,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2869090.35,NULL,NULL,1,'2023-11-29 14:14:21','2024-09-19 17:11:08','2024-09-19 17:11:08'),(865,7492,40787,102501,2,865,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',37100035.75,NULL,NULL,1,'2023-11-29 14:17:15','2023-11-29 14:17:15',NULL),(866,7492,40787,102501,3,866,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',17049233.30,NULL,NULL,1,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(867,7492,40787,102501,16,867,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',814499.04,NULL,NULL,1,'2023-11-29 14:55:43','2023-11-29 17:30:53','2023-11-29 17:30:53');
INSERT INTO `balance_libro` VALUES (868,7492,40787,102501,15,868,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',7791007.50,NULL,NULL,1,'2023-11-29 14:58:08','2024-09-19 17:17:42','2024-09-19 17:17:42'),(869,7492,40787,102501,3,869,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',17049233.30,NULL,NULL,1,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(870,7492,40787,102501,16,870,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',814499.04,NULL,NULL,1,'2023-11-29 17:30:53','2024-09-19 17:30:15','2024-09-19 17:30:15'),(871,7492,40789,104002,3,871,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',724484.67,'asiento 08-2023',NULL,1,'2023-12-19 11:41:29','2023-12-19 13:46:47','2023-12-19 13:46:47'),(872,7492,40789,104002,3,872,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',22687.00,'asiento 02-2023',NULL,1,'2023-12-19 13:55:46','2023-12-19 13:55:46',NULL),(873,7492,40789,104002,3,873,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',199040.41,'asiento 07-2023',NULL,1,'2023-12-19 14:00:12','2023-12-19 14:45:25','2023-12-19 14:45:25'),(874,7492,40789,104002,3,874,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',199040.41,'asiento 07-2023',NULL,1,'2023-12-19 14:45:25','2023-12-19 14:45:25',NULL),(875,7492,40789,104002,15,875,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',3304.54,NULL,NULL,1,'2023-12-19 14:46:44','2023-12-19 14:55:12','2023-12-19 14:55:12'),(876,7492,40789,104002,3,876,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',1090198.00,'asiento 08-2023',NULL,1,'2023-12-19 14:52:16','2023-12-19 14:58:07','2023-12-19 14:58:07'),(877,7492,40789,104002,15,877,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',47892.34,'posisicion IVA 08-2023',NULL,1,'2023-12-19 14:53:40','2023-12-19 14:53:40',NULL),(878,7492,40789,104002,2,878,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',165000.00,'asiento 10-2023',NULL,1,'2023-12-19 14:54:45','2023-12-19 14:54:45',NULL),(879,7492,40789,104002,15,879,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',3304.54,'posicion IVA 08-2023',NULL,1,'2023-12-19 14:55:12','2023-12-19 14:55:12',NULL),(880,7492,40789,104002,15,880,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',47892.34,'posicion IVA 10-2023',NULL,1,'2023-12-19 14:56:18','2023-12-19 14:56:18',NULL),(881,7492,40789,104002,3,881,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',1057698.00,'asiento 08-2023',NULL,1,'2023-12-19 14:58:07','2023-12-25 12:13:37','2023-12-25 12:13:37'),(882,7492,40789,104002,3,882,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',32500.00,NULL,NULL,1,'2023-12-19 15:04:18','2023-12-19 15:04:18',NULL),(883,7492,40789,104002,2,883,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',109200.00,NULL,NULL,1,'2023-12-19 15:05:22','2023-12-26 09:57:25','2023-12-26 09:57:25'),(884,7492,40789,104002,12,884,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',192000.00,'ASIENTO inicio',NULL,1,'2023-12-19 15:32:31','2023-12-23 09:28:45','2023-12-23 09:28:45'),(885,7492,40789,104002,12,885,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',47088.00,'REPCAM',NULL,1,'2023-12-19 15:34:59','2023-12-23 09:28:39','2023-12-23 09:28:39');
INSERT INTO `balance_libro` VALUES (886,7492,40789,104002,4,886,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',62714.93,'AMORTIZACIONES',NULL,1,'2023-12-19 15:45:32','2023-12-27 13:39:52','2023-12-27 13:39:52'),(887,7492,40789,104002,4,887,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',11071.11,'AMORTIZACIONES',NULL,1,'2023-12-19 15:46:48','2023-12-27 13:40:21','2023-12-27 13:40:21'),(888,7492,40789,103991,12,888,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',239088.18,'Saldo anterior',NULL,1,'2023-12-23 09:21:12','2023-12-23 09:21:30','2023-12-23 09:21:30'),(889,7492,40789,103991,12,889,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',239088.18,'Saldo anterior',NULL,1,'2023-12-23 09:21:30','2023-12-23 09:26:38','2023-12-23 09:26:38'),(890,7492,40789,103991,12,890,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',239088.18,'Saldo anterior',NULL,1,'2023-12-23 09:26:38','2023-12-23 09:28:58','2023-12-23 09:28:58'),(891,7492,40789,103991,12,891,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',239088.18,'Saldo anterior',NULL,1,'2023-12-23 09:28:58','2023-12-23 09:28:58',NULL),(892,7492,40789,103995,18,892,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',182400.00,'CAPITAL SUSCRIPTO TOTAL',NULL,1,'2023-12-23 09:31:16','2023-12-23 09:31:16',NULL),(893,7492,40789,104002,3,893,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',1057698.00,'asiento 08-2023',NULL,1,'2023-12-25 12:13:37','2023-12-25 12:13:37',NULL),(894,7492,40789,104002,2,894,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',725850.00,NULL,NULL,1,'2023-12-26 09:57:25','2023-12-26 09:57:25',NULL),(895,7492,40789,104002,4,895,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',5553.55,'AMORTIZACIONES',NULL,1,'2023-12-27 13:39:52','2024-01-04 09:18:14','2024-01-04 09:18:14'),(896,7492,40789,104002,4,896,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',31357.47,'AMORTIZACIONES',NULL,1,'2023-12-27 13:40:21','2023-12-27 13:40:21',NULL),(897,7492,40789,104002,4,897,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',5553.55,'AMORTIZACIONES',NULL,1,'2024-01-04 09:18:14','2024-01-04 09:18:14',NULL),(898,7492,40789,104006,15,898,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-04','2024-01-04',125973.98,'LIQ IVA 12-2023',NULL,1,'2024-01-04 09:22:44','2024-01-04 09:22:44',NULL),(899,7492,40789,104002,15,899,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',125973.98,NULL,NULL,1,'2024-01-24 12:30:06','2024-01-24 12:30:06',NULL),(900,7492,40789,104002,23,900,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',463122.33,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-01-24 12:54:43','2024-01-24 12:54:43',NULL),(901,7492,40787,102500,2,901,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',16531425.34,NULL,NULL,1,'2024-06-19 12:15:22','2024-09-19 17:22:35','2024-09-19 17:22:35'),(902,7492,40787,102500,16,902,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',277692.70,NULL,NULL,1,'2024-06-27 16:38:26','2024-09-19 17:39:19','2024-09-19 17:39:19'),(903,7492,40787,102500,15,903,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2869090.35,NULL,NULL,1,'2024-06-27 16:40:51','2024-06-27 16:40:51',NULL);
INSERT INTO `balance_libro` VALUES (904,7492,40787,102501,2,904,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',37100035.75,NULL,NULL,1,'2024-06-27 16:44:35','2024-09-19 17:23:37','2024-09-19 17:23:37'),(905,7492,40787,102501,3,905,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',17049233.30,NULL,NULL,1,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15'),(906,7492,40787,102501,16,906,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',814499.04,NULL,NULL,1,'2024-06-27 17:59:48','2024-09-19 17:41:05','2024-09-19 17:41:05'),(907,7492,40787,102501,15,907,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',7791007.50,NULL,NULL,1,'2024-06-27 18:01:26','2024-06-27 18:01:26',NULL),(908,7492,40787,102502,2,908,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',13627391.00,NULL,NULL,1,'2024-06-28 14:29:11','2024-06-28 14:29:11',NULL),(909,7492,40787,102502,3,909,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',12858890.63,NULL,NULL,1,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(910,7492,40787,102502,16,910,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',293027.17,NULL,NULL,1,'2024-06-28 14:51:06','2024-06-28 14:51:06',NULL),(911,7492,40787,102502,15,911,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',2861752.11,NULL,NULL,1,'2024-06-28 14:54:52','2024-06-28 14:54:52',NULL),(912,7492,40787,102503,2,912,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',26574056.24,NULL,NULL,1,'2024-06-28 15:07:09','2024-06-28 15:07:09',NULL),(913,7492,40787,102503,3,913,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',5692429.80,NULL,NULL,1,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30'),(914,7492,40787,102503,16,914,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',460406.52,NULL,NULL,1,'2024-07-01 14:28:21','2024-07-01 14:28:21',NULL),(915,7492,40787,102503,15,915,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',4612026.29,NULL,NULL,1,'2024-07-01 14:32:15','2024-07-01 14:32:15',NULL),(916,7492,40787,102504,2,916,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',22552523.86,NULL,NULL,1,'2024-07-01 14:34:15','2024-07-01 14:34:15',NULL),(917,7492,40787,102504,3,917,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',11183579.91,NULL,NULL,1,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44'),(918,7492,40787,102504,16,918,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',324376.30,NULL,NULL,1,'2024-07-01 14:49:17','2024-07-01 14:49:17',NULL),(919,7492,40787,102504,16,919,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',174618.23,NULL,NULL,1,'2024-07-01 14:53:02','2024-07-01 14:53:02',NULL),(920,7492,40787,102504,15,920,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',3914074.39,NULL,NULL,1,'2024-07-01 14:54:11','2024-07-01 14:54:11',NULL),(921,7492,40787,102505,2,921,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',2698222.56,NULL,NULL,1,'2024-07-01 15:07:19','2024-07-01 15:07:19',NULL),(922,7492,40787,102505,3,922,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1413130.39,NULL,NULL,1,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40');
INSERT INTO `balance_libro` VALUES (923,7492,40787,102505,16,923,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',185376.19,NULL,NULL,1,'2024-07-01 16:13:55','2024-09-19 18:34:55','2024-09-19 18:34:55'),(924,7492,40787,102505,15,924,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',468286.56,NULL,NULL,1,'2024-07-01 16:14:54','2024-07-01 16:14:54',NULL),(925,7492,40787,102500,1,925,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',4001206.48,'SUELDOS',NULL,1,'2024-09-13 11:37:57','2024-09-13 11:37:57',NULL),(926,7492,40787,102500,3,926,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1486636.73,'PAGO F 931 07-2023_  03-08-2023',NULL,1,'2024-09-13 11:41:58','2024-10-02 18:02:09','2024-10-02 18:02:09'),(927,7492,40787,102515,3,927,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',134542.34,'PAGO SIND. S.V. UOCA .  03-08-2023',NULL,1,'2024-09-13 12:06:56','2025-10-21 10:04:03','2025-10-21 10:04:03'),(928,7492,40787,102515,3,928,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',88029.24,'PAGO DEL MES 06-2023_ 06-07-2023',NULL,1,'2024-09-13 12:16:11','2025-10-21 09:34:38','2025-10-21 09:34:38'),(929,7492,40787,102500,3,929,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',5958.68,'PAGOS 14-07-2023',NULL,1,'2024-09-13 12:19:56','2024-09-25 13:34:57','2024-09-25 13:34:57'),(930,7492,40787,102516,1,930,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',3678755.10,'SUELDOS 08-2023',NULL,1,'2024-09-13 12:26:38','2025-10-21 10:32:29','2025-10-21 10:32:29'),(931,7492,40787,102501,3,931,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1048793.35,'pago  F 931 MES AGOSTO - 03-09-2023',NULL,1,'2024-09-13 12:29:20','2024-10-03 09:28:35','2024-10-03 09:28:35'),(932,7492,40787,102501,3,932,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',144057.04,'PAGOS  11-09-2023',NULL,1,'2024-09-13 12:31:48','2024-10-03 09:21:39','2024-10-03 09:21:39'),(933,7492,40787,102502,1,933,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',3926110.45,'F 931 SEPT 2023',NULL,1,'2024-09-13 12:56:16','2024-09-13 12:56:16',NULL),(934,7492,40787,102502,3,934,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',1085293.50,'PAGOS 17-10-2023',NULL,1,'2024-09-13 13:04:23','2024-10-03 09:38:24','2024-10-03 09:38:24'),(935,7492,40787,102502,3,935,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',149441.51,'PAGOS 10-10-2023',NULL,1,'2024-09-13 13:05:38','2024-10-03 09:38:51','2024-10-03 09:38:51'),(936,7492,40787,102517,3,936,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',6320.55,'PAGO IERC 06-10-2023',NULL,1,'2024-09-13 13:06:23','2025-10-21 15:45:59','2025-10-21 15:45:59'),(937,7492,40787,102503,1,937,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',4226288.22,'F 931 10-2023',NULL,1,'2024-09-13 13:14:58','2024-09-23 13:22:28','2024-09-23 13:22:28'),(938,7492,40787,102518,3,938,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1283114.88,'PAGOS F 931 10-2023_  07-11-2023',NULL,1,'2024-09-13 14:16:17','2025-10-21 11:38:48','2025-10-21 11:38:48'),(939,7492,40787,102518,3,939,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',3376.59,'IERIC 10-2023',NULL,1,'2024-09-13 14:19:18','2025-10-21 11:38:21','2025-10-21 11:38:21');
INSERT INTO `balance_libro` VALUES (940,7492,40787,102504,1,940,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1302499.55,'F 931_-- 11-2023',NULL,1,'2024-09-13 14:25:26','2024-09-23 12:24:09','2024-09-23 12:24:09'),(941,7492,40787,102504,3,941,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1193240.71,'07-12 PAGOS',NULL,1,'2024-09-13 14:34:05','2024-09-25 13:22:33','2024-09-25 13:22:33'),(942,7492,40787,102505,1,942,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',1539423.26,'F 931 11-2023',NULL,1,'2024-09-13 14:44:18','2024-09-13 14:44:18',NULL),(943,7492,40787,102505,3,943,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',588358.26,'pagos 10-01-2024',NULL,1,'2024-09-13 15:25:44','2024-10-04 12:16:12','2024-10-04 12:16:12'),(944,7492,40787,102509,2,944,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',17327939.78,'INGRESOS POR SERVICIOS',NULL,1,'2024-09-19 12:33:29','2024-09-19 12:33:29',NULL),(945,7492,40787,102509,3,945,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',9855990.75,'ASIENTO  DE GASTOS',NULL,1,'2024-09-19 12:48:18','2024-10-04 14:51:38','2024-10-04 14:51:38'),(946,7492,40787,102509,16,946,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',435261.32,'POSISION II.-BB.',NULL,1,'2024-09-19 12:53:07','2024-09-19 17:54:42','2024-09-19 17:54:42'),(947,7492,40787,102509,15,947,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',3007328.39,'POSICION IVA 01-2024',NULL,1,'2024-09-19 12:54:49','2024-09-19 12:54:49',NULL),(948,7492,40787,102510,2,948,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',5057525.33,NULL,NULL,1,'2024-09-19 13:28:40','2024-09-19 13:28:40',NULL),(949,7492,40787,102510,3,949,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',3291883.85,'GASTO 02-2024',NULL,1,'2024-09-19 13:38:58','2024-10-07 12:26:24','2024-10-07 12:26:24'),(950,7492,40787,102510,16,950,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',122976.99,'POSICION II.B 02-2024',NULL,1,'2024-09-19 13:49:37','2024-09-19 13:49:37',NULL),(951,7492,40787,102510,15,951,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',877752.33,'POSICION IVA 02-024',NULL,1,'2024-09-19 13:51:13','2024-09-19 13:51:13',NULL),(952,7492,40787,102511,3,952,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',1555149.98,'GASTOS 03-20274',NULL,1,'2024-09-19 15:43:24','2024-10-07 13:02:02','2024-10-07 13:02:02'),(953,7492,40787,102511,16,953,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',167643.09,'posicion ii.-bb 03-2024',NULL,1,'2024-09-19 15:45:39','2024-09-19 15:45:39',NULL),(954,7492,40787,102511,15,954,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',2026723.58,'posicion iva 2024-03',NULL,1,'2024-09-19 15:47:02','2024-09-19 15:47:02',NULL),(955,7492,40787,102512,2,955,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',2752000.03,'servicios ingresos 04-2024',NULL,1,'2024-09-19 15:49:16','2024-09-19 15:49:16',NULL),(956,7492,40787,102512,3,956,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',2057053.90,'gastos 04-2024',NULL,1,'2024-09-19 15:56:27','2024-10-07 13:05:11','2024-10-07 13:05:11'),(957,7492,40787,102512,16,957,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',45487.60,'II.BB. 04-2024',NULL,1,'2024-09-19 16:02:40','2024-09-19 16:02:40',NULL);
INSERT INTO `balance_libro` VALUES (958,7492,40787,102512,15,958,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',477619.84,'04-2024 LIQUIDAC IVA',NULL,1,'2024-09-19 16:04:31','2024-09-19 16:04:31',NULL),(959,7492,40787,102513,2,959,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',2494036.85,'05-2024 INGRESO SERVICIOS',NULL,1,'2024-09-19 16:06:24','2024-09-19 16:06:24',NULL),(960,7492,40787,102513,3,960,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1220737.36,'GASTOS 05-2024',NULL,1,'2024-09-19 16:10:34','2024-10-07 13:08:41','2024-10-07 13:08:41'),(961,7492,40787,102513,16,961,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',41223.75,'II.BB 05-2024',NULL,1,'2024-09-19 16:20:35','2024-09-19 16:22:06','2024-09-19 16:22:06'),(962,7492,40787,102513,16,962,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',41628.14,'II.BB 05-2024',NULL,1,'2024-09-19 16:22:06','2024-09-19 16:22:06',NULL),(963,7492,40787,102513,15,963,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',432849.37,'IV A05-2024',NULL,1,'2024-09-19 16:25:52','2024-09-19 16:25:52',NULL),(964,7492,40787,102514,2,964,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',61163258.11,'INGRESOS 06-2024',NULL,1,'2024-09-19 16:27:58','2024-09-19 16:27:58',NULL),(965,7492,40787,102514,3,965,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',16201689.37,'GASTOS 06-2024',NULL,1,'2024-09-19 16:35:51','2024-10-07 13:11:43','2024-10-07 13:11:43'),(966,7492,40787,102514,16,966,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',1021681.85,'II BB 06-2024',NULL,1,'2024-09-19 16:39:23','2024-09-19 16:39:23',NULL),(967,7492,40787,102514,15,967,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',10615110.91,'LIQUIDACION IVA 06-2024',NULL,1,'2024-09-19 16:40:46','2024-09-19 16:40:46',NULL),(968,7492,40787,102514,19,968,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',6505064.00,'MULTA IERIC',NULL,1,'2024-09-19 16:51:39','2024-09-25 12:24:26','2024-09-25 12:24:26'),(969,7492,40787,102511,2,969,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',11677788.25,'SERVICIOS 03-2024',NULL,1,'2024-09-19 17:02:42','2024-09-19 17:02:42',NULL),(970,7492,40787,102500,16,970,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',277692.70,NULL,NULL,1,'2024-09-19 17:39:19','2024-09-19 17:39:19',NULL),(971,7492,40787,102501,16,971,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',814499.04,NULL,NULL,1,'2024-09-19 17:41:05','2024-09-19 17:41:05',NULL),(972,7492,40787,102511,16,972,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',31722.76,'II BB BS AS',NULL,1,'2024-09-19 17:52:19','2024-09-19 17:52:19',NULL),(973,7492,40787,102509,16,973,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',435261.32,'POSISION II.-BB.',NULL,1,'2024-09-19 17:54:42','2024-09-19 18:41:36','2024-09-19 18:41:36'),(974,7492,40787,102504,3,974,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',11183579.91,NULL,NULL,1,'2024-09-19 17:56:44','2024-10-04 12:15:23','2024-10-04 12:15:23'),(975,7492,40787,102505,16,975,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',185376.19,NULL,NULL,1,'2024-09-19 18:34:55','2024-09-19 18:34:55',NULL);
INSERT INTO `balance_libro` VALUES (976,7492,40787,102509,16,976,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',435261.37,'POSISION II.-BB.',NULL,1,'2024-09-19 18:41:36','2024-09-19 18:41:36',NULL),(977,7492,40787,102501,1,977,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',3678755.10,NULL,NULL,1,'2024-09-23 12:15:49','2024-09-23 12:15:49',NULL),(978,7492,40787,102504,1,978,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1302499.55,'F 931_-- 11-2023',NULL,1,'2024-09-23 12:24:09','2024-09-23 12:24:09',NULL),(979,7492,40787,102503,3,979,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1155248.35,'PAGOS 07-11-2023',NULL,1,'2024-09-23 12:38:32','2024-10-03 10:07:54','2024-10-03 10:07:54'),(980,7492,40787,102503,1,980,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',4220220.71,'F 931 10-2023',NULL,1,'2024-09-23 13:22:28','2024-09-23 13:22:28',NULL),(981,7492,40787,102500,3,981,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',134542.34,'PAGOS 03/08/2023',NULL,1,'2024-09-23 14:04:20','2024-10-02 18:05:54','2024-10-02 18:05:54'),(982,7492,40787,102503,3,982,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',127866.53,'PAGOS 07/11/2023',NULL,1,'2024-09-23 14:07:32','2024-10-03 10:08:22','2024-10-03 10:08:22'),(983,7492,40787,102560,3,983,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',6130.72,'PAGO 08-08/2023',NULL,1,'2024-09-23 14:19:46','2024-09-23 14:19:46',NULL),(984,7492,40787,102517,3,984,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',6320.55,'PAGO 06-10-2023',NULL,1,'2024-09-23 14:20:45','2025-10-21 10:34:39','2025-10-21 10:34:39'),(985,7492,40787,102503,3,985,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',3376.59,'PAGO 15-11-2023',NULL,1,'2024-09-23 14:21:35','2024-10-03 10:08:45','2024-10-03 10:08:45'),(986,7492,40787,102500,3,986,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',6130.72,'PAGO 08/08/2023',NULL,1,'2024-09-23 14:26:33','2024-10-02 18:10:17','2024-10-02 18:10:17'),(987,7492,40787,102502,3,987,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',6320.55,'PAGO 06-10-2023',NULL,1,'2024-09-23 14:28:21','2024-10-03 09:39:16','2024-10-03 09:39:16'),(988,7492,40787,102500,3,988,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',88029.24,'Pagos del mes 06-2023',NULL,1,'2024-09-23 14:51:38','2024-09-25 13:27:59','2024-09-25 13:27:59'),(989,7492,40787,102509,1,989,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',1496196.72,'SUELDOS 01-2024',NULL,1,'2024-09-24 13:45:25','2024-09-24 13:45:25',NULL),(990,7492,40787,102509,3,990,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',520263.53,'PAGOS 14/02/2024',NULL,1,'2024-09-24 13:47:18','2024-10-04 14:47:13','2024-10-04 14:47:13'),(991,7492,40787,102509,3,991,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',48431.75,'PAGOS 14-02-2024',NULL,1,'2024-09-24 13:48:59','2024-10-04 14:47:43','2024-10-04 14:47:43'),(992,7492,40787,102509,3,992,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',2033.03,'IERIC PAGO  15/02/2024',NULL,1,'2024-09-24 13:49:52','2024-10-04 14:48:10','2024-10-04 14:48:10'),(993,7492,40787,102510,1,993,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',1624764.90,'SUELDO 02-2024',NULL,1,'2024-09-24 13:52:35','2024-09-24 13:52:35',NULL);
INSERT INTO `balance_libro` VALUES (994,7492,40787,102510,3,994,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',577279.27,NULL,NULL,1,'2024-09-24 13:53:37','2024-10-07 12:47:26','2024-10-07 12:47:26'),(995,7492,40787,102510,3,995,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',49555.18,'PAGOS 15-03-2024',NULL,1,'2024-09-24 13:55:23','2024-10-07 12:19:27','2024-10-07 12:19:27'),(996,7492,40787,102511,1,996,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',1040824.04,'SUELDO S03-2024',NULL,1,'2024-09-24 13:59:36','2024-09-24 13:59:36',NULL),(997,7492,40787,102511,3,997,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',331611.84,'PAGOS 09-04-2023',NULL,1,'2024-09-24 14:00:56','2024-10-07 12:20:33','2024-10-07 12:20:33'),(998,7492,40787,102511,3,998,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',26211.45,'PAG0SM 09-04-2024',NULL,1,'2024-09-24 14:02:34','2024-10-07 12:21:24','2024-10-07 12:21:24'),(999,7492,40787,102513,1,999,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',966453.43,NULL,NULL,1,'2024-09-24 14:05:10','2024-09-25 12:31:23','2024-09-25 12:31:23'),(1000,7492,40787,102512,3,1000,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',317894.03,'PAGOS 10/05/2024',NULL,1,'2024-09-24 14:06:31','2024-10-07 12:22:09','2024-10-07 12:22:09'),(1001,7492,40787,102512,3,1001,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',15833.46,'PAGOS 08/05/2024',NULL,1,'2024-09-24 14:07:53','2024-10-07 12:22:28','2024-10-07 12:22:28'),(1002,7492,40787,102513,1,1002,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',315189.74,NULL,NULL,1,'2024-09-24 14:10:46','2024-09-24 14:10:46',NULL),(1003,7492,40787,102513,3,1003,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',114289.10,'PAGOS 14/06/2024',NULL,1,'2024-09-24 14:11:58','2024-10-07 12:22:54','2024-10-07 12:22:54'),(1004,7492,40787,102513,3,1004,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',17794.42,'PAGOS 14/06/2024',NULL,1,'2024-09-24 14:13:30','2024-10-07 12:23:13','2024-10-07 12:23:13'),(1005,7492,40787,102514,1,1005,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',3547434.60,NULL,NULL,1,'2024-09-24 14:16:33','2024-09-24 14:16:33',NULL),(1006,7492,40787,102514,19,1006,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',6505064.00,'MULTA IERIC',NULL,1,'2024-09-25 12:24:26','2024-09-25 12:24:26',NULL),(1007,7492,40787,102514,3,1007,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',32199.66,NULL,NULL,1,'2024-09-25 12:25:44','2024-11-12 11:57:40','2024-11-12 11:57:40'),(1008,7492,40787,102512,1,1008,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',966453.43,NULL,NULL,1,'2024-09-25 12:31:23','2024-09-25 12:31:23',NULL),(1009,7492,40787,102504,3,1009,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',385723.69,'07-12 PAGOS',NULL,1,'2024-09-25 13:22:33','2024-10-04 12:10:43','2024-10-04 12:10:43'),(1010,7492,40787,102500,3,1010,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',88029.24,'Pagos del mes 06-2023',NULL,1,'2024-09-25 13:27:59','2024-09-25 13:27:59',NULL),(1011,7492,40787,102500,3,1011,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',5958.68,'PAGOS 14-07-2023',NULL,1,'2024-09-25 13:34:57','2024-09-25 13:34:57',NULL);
INSERT INTO `balance_libro` VALUES (1012,7492,40787,102500,3,1012,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',5439350.84,NULL,NULL,1,'2024-10-02 16:15:20','2024-10-02 17:47:35','2024-10-02 17:47:35'),(1013,7492,40787,102500,5,1013,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',28158565.05,'BANCO FRANCES INGRESOS',NULL,1,'2024-10-02 16:20:01','2024-10-02 17:41:30','2024-10-02 17:41:30'),(1014,7492,40787,102500,5,1014,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',15277752.68,'BCO FRANCES',NULL,1,'2024-10-02 16:43:52','2024-10-02 17:44:44','2024-10-02 17:44:44'),(1015,7492,40787,102500,5,1015,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',12574800.77,'pagos mes 06-2023',NULL,1,'2024-10-02 17:03:50','2024-10-02 17:03:50',NULL),(1016,7492,40787,102500,5,1016,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',623884.49,'COMISIONES BCO',NULL,1,'2024-10-02 17:10:31','2024-10-02 17:10:31',NULL),(1017,7492,40787,102500,5,1017,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',28158565.05,'BANCO FRANCES INGRESOS',NULL,1,'2024-10-02 17:41:30','2024-10-02 17:41:30',NULL),(1018,7492,40787,102500,5,1018,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',15677752.68,'BCO FRANCES',NULL,1,'2024-10-02 17:44:44','2024-10-02 17:44:44',NULL),(1019,7492,40787,102500,3,1019,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',5839350.84,NULL,NULL,1,'2024-10-02 17:47:35','2024-10-08 16:28:44','2024-10-08 16:28:44'),(1020,7492,40787,102501,3,1020,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',1486636.73,'PAGO F 931 07-2023_  03-08-2023',NULL,1,'2024-10-02 18:02:09','2024-10-02 18:02:09',NULL),(1021,7492,40787,102501,3,1021,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',134542.34,'MES 07-2023_PAGOS 03/08/2023',NULL,1,'2024-10-02 18:05:54','2024-10-02 18:05:54',NULL),(1022,7492,40787,102501,3,1022,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',6130.72,'DEL MES 07-2023-PAGO 08/08/2023',NULL,1,'2024-10-02 18:10:17','2024-10-02 18:10:17',NULL),(1023,7492,40787,102501,5,1023,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',42495772.21,'INGRESOS POR SERVICIOS_ PLAZO FIJO',NULL,1,'2024-10-02 18:35:17','2024-10-08 10:58:32','2024-10-08 10:58:32'),(1024,7492,40787,102516,5,1024,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',42023147.12,'banco frances',NULL,1,'2024-10-02 18:40:19','2025-10-21 10:34:02','2025-10-21 10:34:02'),(1025,7492,40787,102501,5,1025,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',37642.37,'pago plan facilidades',NULL,1,'2024-10-03 08:44:40','2024-10-03 08:44:40',NULL),(1026,7492,40787,102501,5,1026,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',1157741.57,'gastos banco 08-2023',NULL,1,'2024-10-03 09:12:11','2024-10-03 09:12:11',NULL),(1027,7492,40787,102501,3,1027,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',17049233.30,NULL,NULL,1,'2024-10-03 09:20:15','2024-10-03 09:20:15',NULL),(1028,7492,40787,102502,3,1028,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',144057.04,'PAGOS  11-09-2023 del  mes 08-2023',NULL,1,'2024-10-03 09:21:39','2024-10-03 09:21:39',NULL),(1029,7492,40787,102501,5,1029,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',42023147.12,'pagos mes 08-2023',NULL,1,'2024-10-03 09:24:27','2024-10-03 09:24:27',NULL);
INSERT INTO `balance_libro` VALUES (1030,7492,40787,102502,3,1030,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-03','2023-09-03',1048793.35,'pago  F 931 MES AGOSTO - 03-09-2023',NULL,1,'2024-10-03 09:28:35','2024-10-03 09:28:35',NULL),(1031,7492,40787,102503,3,1031,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',1085293.50,'PAGOS 17-10-2023 del mes 09-2023',NULL,1,'2024-10-03 09:38:24','2024-10-03 09:38:24',NULL),(1032,7492,40787,102503,3,1032,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',149441.51,'PAGOS 10-10-2023 del mes 09-2023',NULL,1,'2024-10-03 09:38:51','2024-10-03 09:38:51',NULL),(1033,7492,40787,102503,3,1033,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',6320.55,'PAGO 06-10-2023 del mes 09-2023',NULL,1,'2024-10-03 09:39:16','2024-10-03 11:12:16','2024-10-03 11:12:16'),(1034,7492,40787,102502,3,1034,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',12858890.63,NULL,NULL,1,'2024-10-03 09:42:23','2024-10-08 12:44:15','2024-10-08 12:44:15'),(1035,7492,40787,102502,5,1035,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',15876287.57,'INGRESOS POR SERVICIOS',NULL,1,'2024-10-03 09:43:41','2024-10-03 09:43:41',NULL),(1036,7492,40787,102502,5,1036,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',3004799.89,'PAGOS IMPUESTOS DL MES 08-2023',NULL,1,'2024-10-03 09:46:39','2024-10-03 09:46:39',NULL),(1037,7492,40787,102502,5,1037,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',256531.63,'COMISIONES BCO 09-2023',NULL,1,'2024-10-03 09:47:54','2024-10-03 09:47:54',NULL),(1038,7492,40787,102502,5,1038,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',11461153.91,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-03 09:53:49','2024-10-03 09:53:49',NULL),(1039,7492,40787,102503,3,1039,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',7943153.11,NULL,NULL,1,'2024-10-03 10:07:30','2024-10-08 16:29:10','2024-10-08 16:29:10'),(1040,7492,40787,102504,3,1040,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',1155248.35,'PAGOS 07-11-2023',NULL,1,'2024-10-03 10:07:54','2024-10-03 10:07:54',NULL),(1041,7492,40787,102504,3,1041,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',127866.53,'PAGOS 07/11/2023 del mes 10-2023',NULL,1,'2024-10-03 10:08:22','2024-10-03 10:08:22',NULL),(1042,7492,40787,102504,3,1042,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',3376.59,'PAGO 15-11-2023 del mes 10-2023',NULL,1,'2024-10-03 10:08:45','2024-10-03 10:08:45',NULL),(1043,7492,40787,102503,5,1043,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',31238623.12,'INGRESOS POR SERVICIOS',NULL,1,'2024-10-03 10:09:51','2024-10-03 10:09:51',NULL),(1044,7492,40787,102503,5,1044,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',22893721.53,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-03 10:14:44','2024-10-03 10:47:24','2024-10-03 10:47:24'),(1045,7492,40787,102503,5,1045,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',3552729.76,'PAGO9S DEL MES 09-2023- 06 Y 07 IVA',NULL,1,'2024-10-03 10:19:16','2024-10-03 10:19:16',NULL),(1046,7492,40787,102518,5,1046,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',714435.85,'COMISIONES BCO 10-2023',NULL,1,'2024-10-03 10:20:51','2025-10-21 11:39:30','2025-10-21 11:39:30');
INSERT INTO `balance_libro` VALUES (1047,7492,40787,102503,5,1047,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',714435.85,'GASTOS BCO 10-2023',NULL,1,'2024-10-03 10:31:15','2024-10-03 10:31:15',NULL),(1048,7492,40787,102503,5,1048,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',22893451.52,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-03 10:47:24','2024-10-03 11:16:41','2024-10-03 11:16:41'),(1049,7492,40787,102503,3,1049,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',6320.54,'PAGO 06-10-2023 del mes 09-2023',NULL,1,'2024-10-03 11:12:16','2024-10-03 11:12:16',NULL),(1050,7492,40787,102503,5,1050,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',22893451.49,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-03 11:16:41','2024-10-03 11:19:15','2024-10-03 11:19:15'),(1051,7492,40787,102503,5,1051,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',22893451.18,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-03 11:19:16','2024-10-03 11:21:56','2024-10-03 11:21:56'),(1052,7492,40787,102503,5,1052,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',22893451.16,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-03 11:21:56','2024-10-03 11:21:56',NULL),(1053,7492,40787,102505,3,1053,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',385723.69,'07-12 PAGOS del mes 11-2023',NULL,1,'2024-10-04 12:10:43','2024-10-04 12:10:43',NULL),(1054,7492,40787,102504,3,1054,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',11283579.91,NULL,NULL,1,'2024-10-04 12:15:23','2024-10-04 12:15:23',NULL),(1055,7492,40787,102509,3,1055,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',588358.26,'pagos 10-01-2024_ DEL MES 12-2023',NULL,1,'2024-10-04 12:16:12','2024-10-04 12:16:12',NULL),(1056,7492,40787,102505,3,1056,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1413130.39,NULL,NULL,1,'2024-10-04 12:18:40','2024-10-04 12:18:40',NULL),(1057,7492,40787,102504,5,1057,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',33737424.91,'INGRESOS POR SERVICIOS 11-2023',NULL,1,'2024-10-04 12:23:16','2024-10-04 12:23:16',NULL),(1058,7492,40787,102504,5,1058,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',15885710.47,'EGRESOSO BCO',NULL,1,'2024-10-04 12:25:11','2024-10-04 13:07:12','2024-10-04 13:07:12'),(1059,7492,40787,102504,5,1059,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',6248558.65,'PAGOS IMPUESTOS',NULL,1,'2024-10-04 12:35:04','2024-11-12 12:23:48','2024-11-12 12:23:48'),(1060,7492,40787,102504,5,1060,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',187741.64,'OSPECOM AJUSTE',NULL,1,'2024-10-04 12:39:55','2024-10-04 12:39:55',NULL),(1061,7492,40787,102504,5,1061,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',790934.22,'COMISIONES BCO 11-2023',NULL,1,'2024-10-04 12:42:38','2024-10-04 12:42:38',NULL),(1062,7492,40787,102504,5,1062,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',26326793.57,'EGRESOSO BCO',NULL,1,'2024-10-04 13:07:12','2024-10-04 13:07:12',NULL),(1063,7492,40787,102505,5,1063,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',4296275.02,'INGRESOS POR SERVICIOS',NULL,1,'2024-10-04 13:14:12','2024-10-04 13:14:12',NULL),(1064,7492,40787,102505,5,1064,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',3363849.68,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-04 13:19:11','2024-10-07 11:55:43','2024-10-07 11:55:43');
INSERT INTO `balance_libro` VALUES (1065,7492,40787,102505,5,1065,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',1554295.23,'PAGO IMPUESTOS',NULL,1,'2024-10-04 13:22:46','2024-10-04 13:22:46',NULL),(1066,7492,40787,102505,5,1066,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',113056.36,'COMISIONES BCO 12-2023',NULL,1,'2024-10-04 13:23:50','2024-10-04 13:23:50',NULL),(1067,7492,40787,102510,3,1067,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',520263.53,'PAGOS 14/02/2024 DEL MES 01-2024',NULL,1,'2024-10-04 14:47:13','2024-10-04 14:47:13',NULL),(1068,7492,40787,102510,3,1068,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',48431.75,'PAGOS 14-02-2024',NULL,1,'2024-10-04 14:47:43','2024-10-04 14:47:43',NULL),(1069,7492,40787,102510,3,1069,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',2033.03,'IERIC PAGO  15/02/2024',NULL,1,'2024-10-04 14:48:10','2024-10-04 14:48:10',NULL),(1070,7492,40787,102509,3,1070,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',9855990.75,'ASIENTO  DE GASTOS',NULL,1,'2024-10-04 14:51:38','2024-10-04 14:51:38',NULL),(1071,7492,40787,102505,5,1071,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',3363849.60,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-07 11:55:43','2024-10-07 11:55:43',NULL),(1072,7492,40787,102509,5,1072,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',17627751.92,'INGRESOS POR SERVICIOS',NULL,1,'2024-10-07 11:58:09','2024-10-07 11:58:09',NULL),(1073,7492,40787,102509,5,1073,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',2530117.06,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-07 12:00:40','2024-10-07 12:00:40',NULL),(1074,7492,40787,102509,5,1074,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',4072200.31,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-07 12:03:18','2024-11-12 10:34:40','2024-11-12 10:34:40'),(1075,7492,40787,102509,5,1075,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',181869.43,'comisiones bco 01-2024',NULL,1,'2024-10-07 12:05:22','2024-10-07 12:05:22',NULL),(1076,7492,40787,102511,3,1076,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',49555.18,'PAGOS 15-03-2024 DEL MES 02-2024',NULL,1,'2024-10-07 12:19:27','2024-10-07 13:38:10','2024-10-07 13:38:10'),(1077,7492,40787,102512,3,1077,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',331611.84,'PAGOS 09-04-2023',NULL,1,'2024-10-07 12:20:33','2024-10-07 12:20:33',NULL),(1078,7492,40787,102512,3,1078,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',26211.45,'PAG0S MES 09-04-2024',NULL,1,'2024-10-07 12:21:24','2024-10-07 12:21:24',NULL),(1079,7492,40787,102513,3,1079,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',317894.03,'PAGOS 10/05/2024 DEL MES 04-2024',NULL,1,'2024-10-07 12:22:09','2024-10-07 12:22:09',NULL),(1080,7492,40787,102513,3,1080,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',15833.46,'PAGOS 08/05/2024',NULL,1,'2024-10-07 12:22:28','2024-10-07 12:22:28',NULL),(1081,7492,40787,102514,3,1081,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',114289.10,'PAGOS 14/06/2024 DEL MES 05-2024',NULL,1,'2024-10-07 12:22:54','2024-10-07 12:22:54',NULL),(1082,7492,40787,102514,3,1082,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',17794.42,'PAGOS 14/06/2024',NULL,1,'2024-10-07 12:23:13','2024-10-07 12:23:13',NULL);
INSERT INTO `balance_libro` VALUES (1083,7492,40787,102510,3,1083,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',6949485.43,'GASTO 02-2024',NULL,1,'2024-10-07 12:26:24','2024-10-08 15:04:03','2024-10-08 15:04:03'),(1084,7492,40787,102510,5,1084,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',5172204.42,'INGRESOS POR SERVICIOS',NULL,1,'2024-10-07 12:27:48','2024-10-07 12:27:48',NULL),(1085,7492,40787,102510,5,1085,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',10920481.04,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-07 12:29:59','2024-10-07 12:29:59',NULL),(1086,7492,40787,102510,5,1086,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',2795014.23,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-07 12:32:37','2024-10-07 12:32:37',NULL),(1087,7492,40787,102510,5,1087,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',203320.48,'COMISIONES BCO FRANCES',NULL,1,'2024-10-07 12:35:41','2024-10-07 12:35:41',NULL),(1088,7492,40787,102511,3,1088,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',577279.27,'12-03-2024 PAGOS DEL MES 02-204',NULL,1,'2024-10-07 12:47:26','2024-10-07 12:47:26',NULL),(1089,7492,40787,102500,2,1089,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',3299118.60,'ASIENTO BCO FRANCES PARA APERTURA',NULL,1,'2024-10-07 12:51:34','2024-10-07 12:55:05','2024-10-07 12:55:05'),(1090,7492,40787,102500,2,1090,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',3299118.60,'ASIENTO BCO FRANCES PARA APERTURA',NULL,1,'2024-10-07 12:55:05','2024-10-07 12:55:05',NULL),(1091,7492,40787,102511,3,1091,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',1555149.98,'GASTOS 03-20274',NULL,1,'2024-10-07 13:02:02','2024-10-07 13:27:20','2024-10-07 13:27:20'),(1092,7492,40787,102512,3,1092,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',2602057.29,'gastos 04-2024',NULL,1,'2024-10-07 13:05:11','2024-10-08 16:30:40','2024-10-08 16:30:40'),(1093,7492,40787,102513,3,1093,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',1220737.36,'GASTOS 05-2024',NULL,1,'2024-10-07 13:08:41','2024-10-07 13:08:41',NULL),(1094,7492,40787,102514,3,1094,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',16201689.37,'GASTOS 06-2024',NULL,1,'2024-10-07 13:11:43','2024-10-07 15:31:40','2024-10-07 15:31:40'),(1095,7492,40787,102511,5,1095,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',12537608.99,'INGRESOS POR SERVICIOS',NULL,1,'2024-10-07 13:13:48','2024-10-08 15:37:19','2024-10-08 15:37:19'),(1096,7492,40787,102511,5,1096,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',9475051.61,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-07 13:25:59','2024-10-07 13:25:59',NULL),(1097,7492,40787,102511,3,1097,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',1555149.98,'GASTOS 03-20274',NULL,1,'2024-10-07 13:27:20','2024-10-07 13:27:20',NULL),(1098,7492,40787,102511,5,1098,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',595967.71,'PAGOS',NULL,1,'2024-10-07 13:28:45','2024-10-08 13:35:38','2024-10-08 13:35:38'),(1099,7492,40787,102511,5,1099,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',185617.98,'COMISIONES BCO',NULL,1,'2024-10-07 13:29:41','2024-10-07 13:29:41',NULL);
INSERT INTO `balance_libro` VALUES (1100,7492,40787,102511,3,1100,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',47488.55,'PAGOS 15-03-2024 DEL MES 02-2024',NULL,1,'2024-10-07 13:38:10','2024-10-07 13:38:10',NULL),(1101,7492,40787,102512,5,1101,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',2753740.11,'INGRESOS POR SERVICIOS',NULL,1,'2024-10-07 13:47:23','2024-10-08 15:50:28','2024-10-08 15:50:28'),(1102,7492,40787,102512,5,1102,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',3451546.46,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-07 13:50:02','2024-10-07 13:50:02',NULL),(1103,7492,40787,102512,5,1103,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',127001.73,'COMISIONES BCO 04-2024',NULL,1,'2024-10-07 13:51:00','2024-10-07 13:51:00',NULL),(1104,7492,40787,102512,5,1104,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1712986.23,NULL,NULL,1,'2024-10-07 13:57:26','2024-11-12 10:40:35','2024-11-12 10:40:35'),(1105,7492,40787,102513,5,1105,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',2800000.00,'INGRESOS POR SERVICIOS',NULL,1,'2024-10-07 14:05:22','2024-10-07 14:05:22',NULL),(1106,7492,40787,102513,3,1106,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',2008380.80,'BANCO FRANCES EGRESOS 05-2024',NULL,1,'2024-10-07 14:07:54','2024-10-07 14:26:55','2024-10-07 14:26:55'),(1107,7492,40787,102513,5,1107,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',721561.99,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-07 14:11:24','2024-10-08 13:44:38','2024-10-08 13:44:38'),(1108,7492,40787,102513,5,1108,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',87416.39,'COMISIONES BCO 05-2024',NULL,1,'2024-10-07 14:12:34','2024-10-07 14:12:34',NULL),(1109,7492,40787,102513,3,1109,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',2008380.79,'BANCO FRANCES EGRESOS 05-2024',NULL,1,'2024-10-07 14:26:55','2024-10-07 14:26:55',NULL),(1110,7492,40787,102514,5,1110,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',17036003.75,NULL,NULL,1,'2024-10-07 14:34:55','2024-10-07 14:34:55',NULL),(1111,7492,40787,102514,5,1111,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',3016669.58,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-07 14:37:13','2024-10-07 14:51:08','2024-10-07 14:51:08'),(1112,7492,40787,102514,5,1112,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',380275.70,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-07 14:42:28','2024-10-07 14:42:28',NULL),(1113,7492,40787,102514,5,1113,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',173824.47,'COMISIONES BCO 06-2024',NULL,1,'2024-10-07 14:44:15','2024-10-07 14:44:15',NULL),(1114,7492,40787,102514,5,1114,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',3016669.57,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-07 14:51:08','2024-10-07 14:53:14','2024-10-07 14:53:14'),(1115,7492,40787,102514,5,1115,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',3016669.59,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-07 14:53:14','2024-10-07 14:53:14',NULL),(1116,7492,40787,102514,11,1116,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',185732.56,'ASIENTO SICORE  30-06-2024',NULL,1,'2024-10-07 15:26:52','2024-10-07 15:34:02','2024-10-07 15:34:02');
INSERT INTO `balance_libro` VALUES (1117,7492,40787,102514,3,1117,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',16201689.47,'GASTOS 06-2024',NULL,1,'2024-10-07 15:31:40','2024-10-07 15:31:40',NULL),(1118,7492,40787,102514,11,1118,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',185732.56,'ASIENTO SICORE  30-06-2024',NULL,1,'2024-10-07 15:34:02','2024-10-07 15:34:02',NULL),(1119,7492,40787,102500,5,1119,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',249863.76,'ASIENTO BCO HSBC PARA APERTURA',NULL,1,'2024-10-08 10:27:30','2024-10-08 10:27:30',NULL),(1120,7492,40787,102515,3,1120,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1972843.47,'SERVICIOS COBRADOS EN BCO',NULL,1,'2024-10-08 10:28:27','2025-10-21 13:00:42','2025-10-21 13:00:42'),(1121,7492,40787,102500,5,1121,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1504107.00,'EGRESOS BANCO HSBC',NULL,1,'2024-10-08 10:33:04','2024-10-08 10:33:04',NULL),(1122,7492,40787,102500,5,1122,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',29199.15,'COMISIONES BCO HSBC',NULL,1,'2024-10-08 10:35:17','2024-10-08 10:35:17',NULL),(1123,7492,40787,102500,5,1123,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1972843.47,'INGRESOS POR SERVICIOS',NULL,1,'2024-10-08 10:38:47','2024-10-08 10:43:42','2024-10-08 10:43:42'),(1124,7492,40787,102500,5,1124,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1572843.47,'INGRESOS POR SERVICIOS',NULL,1,'2024-10-08 10:43:42','2024-10-08 10:47:00','2024-10-08 10:47:00'),(1125,7492,40787,102500,5,1125,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1072843.47,'INGRESOS POR SERVICIOS',NULL,1,'2024-10-08 10:47:00','2024-10-08 10:47:00',NULL),(1126,7492,40787,102501,5,1126,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',5172570.21,'INGRESOS POR SERVICIOS',NULL,1,'2024-10-08 10:50:20','2024-10-08 10:50:20',NULL),(1127,7492,40787,102501,5,1127,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',42495772.21,'INGRESOS POR SERVICIOS_ PLAZO FIJO',NULL,1,'2024-10-08 10:58:32','2024-10-08 10:58:32',NULL),(1128,7492,40787,102501,5,1128,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',2173884.30,'EGRESOS BCO HBC',NULL,1,'2024-10-08 11:07:34','2024-10-08 11:07:34',NULL),(1129,7492,40787,102501,5,1129,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',68399.37,'COMISIONES BCO HSBC',NULL,1,'2024-10-08 11:08:28','2024-10-08 11:08:28',NULL),(1130,7492,40787,102502,5,1130,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',182635.38,'EGRESOS BCO HSBC',NULL,1,'2024-10-08 11:17:26','2024-10-08 11:24:53','2024-10-08 11:24:53'),(1131,7492,40787,102502,5,1131,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',8292.23,'COMISIONES BCO',NULL,1,'2024-10-08 11:18:58','2024-10-08 11:18:58',NULL),(1132,7492,40787,102502,5,1132,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',182635.28,'EGRESOS BCO HSBC',NULL,1,'2024-10-08 11:24:53','2024-10-08 11:24:53',NULL),(1133,7492,40787,102502,3,1133,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',12858890.63,NULL,NULL,1,'2024-10-08 12:44:15','2024-10-08 12:44:15',NULL),(1134,7492,40787,102503,5,1134,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',781091.28,'GASTOS',NULL,1,'2024-10-08 12:49:17','2024-10-08 12:49:17',NULL);
INSERT INTO `balance_libro` VALUES (1135,7492,40787,102518,5,1135,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',17408.97,'COMISIONES BCO HSBC',NULL,1,'2024-10-08 12:50:25','2025-10-21 11:39:57','2025-10-21 11:39:57'),(1136,7492,40787,102503,5,1136,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',17408.97,'COMISIONES BCO',NULL,1,'2024-10-08 12:56:09','2024-10-08 12:56:09',NULL),(1137,7492,40787,102504,5,1137,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1505974.77,'GASTOS BCO',NULL,1,'2024-10-08 13:00:47','2024-10-08 13:09:16','2024-10-08 13:09:16'),(1138,7492,40787,102504,5,1138,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',20568.94,'COMISIONES BCO',NULL,1,'2024-10-08 13:01:50','2024-10-08 13:01:50',NULL),(1139,7492,40787,102504,5,1139,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',1405927.77,'GASTOS BCO',NULL,1,'2024-10-08 13:09:16','2024-10-08 13:09:16',NULL),(1140,7492,40787,102505,5,1140,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',146999.77,'EGRESOSO BCO HSBC',NULL,1,'2024-10-08 13:17:37','2024-10-08 13:17:37',NULL),(1141,7492,40787,102505,5,1141,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',18641.51,'COMISIONES BCO',NULL,1,'2024-10-08 13:18:31','2024-10-08 13:18:31',NULL),(1142,7492,40787,102511,5,1142,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',595967.71,'PAGOS',NULL,1,'2024-10-08 13:35:38','2024-11-12 10:38:48','2024-11-12 10:38:48'),(1143,7492,40787,102513,5,1143,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',722561.99,'EGRESOS BANCO FRANCES',NULL,1,'2024-10-08 13:44:38','2024-11-12 10:41:36','2024-11-12 10:41:36'),(1144,7492,40787,102509,5,1144,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',206307.17,'GASTOS BCO HSBC',NULL,1,'2024-10-08 14:49:43','2024-10-08 14:49:43',NULL),(1145,7492,40787,102509,5,1145,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',19039.52,'COMISIONES BCO',NULL,1,'2024-10-08 14:55:47','2024-10-08 14:55:47',NULL),(1146,7492,40787,102510,5,1146,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',219483.86,'EGRESOS BCO',NULL,1,'2024-10-08 15:02:17','2024-10-08 15:02:17',NULL),(1147,7492,40787,102510,3,1147,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',6959719.67,'GASTO 02-2024',NULL,1,'2024-10-08 15:04:03','2024-10-08 16:29:58','2024-10-08 16:29:58'),(1148,7492,40787,102510,5,1148,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',26663.75,'COMISIONES BCO',NULL,1,'2024-10-08 15:05:05','2024-10-08 15:05:05',NULL),(1149,7492,40787,102510,5,1149,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',23443.00,NULL,NULL,1,'2024-10-08 15:09:04','2024-10-08 15:09:04',NULL),(1150,7492,40787,102511,5,1150,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',32445.42,'EGRESOS BCO',NULL,1,'2024-10-08 15:19:35','2024-10-08 15:19:35',NULL),(1151,7492,40787,102511,5,1151,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',26054.80,'COMISIONES BCO',NULL,1,'2024-10-08 15:20:29','2024-10-08 15:20:29',NULL),(1152,7492,40787,102511,5,1152,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',12537608.99,'INGRESOS POR SERVICIOS',NULL,1,'2024-10-08 15:37:19','2024-10-08 15:37:19',NULL);
INSERT INTO `balance_libro` VALUES (1153,7492,40787,102512,5,1153,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',467789.62,'EGRESOS BCO',NULL,1,'2024-10-08 15:42:11','2024-10-08 15:42:11',NULL),(1154,7492,40787,102512,5,1154,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',28082.26,'COMISIONES BCO',NULL,1,'2024-10-08 15:43:02','2024-10-08 15:43:02',NULL),(1155,7492,40787,102512,5,1155,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',2753740.11,'INGRESOS POR SERVICIOS',NULL,1,'2024-10-08 15:50:28','2024-10-08 15:50:28',NULL),(1156,7492,40787,102513,5,1156,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',8189.91,'INGREOS, CREDITOS VARIOS',NULL,1,'2024-10-08 15:58:30','2024-10-08 15:58:30',NULL),(1157,7492,40787,102513,5,1157,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',248537.27,'COMISIONES Y EGRESOS BCO HSBC',NULL,1,'2024-10-08 16:01:54','2024-11-12 12:39:52','2024-11-12 12:39:52'),(1158,7492,40787,102514,5,1158,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',349657.86,NULL,NULL,1,'2024-10-08 16:09:08','2024-10-08 16:09:08',NULL),(1159,7492,40787,102500,3,1159,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',5839350.84,NULL,NULL,1,'2024-10-08 16:28:44','2024-10-08 16:28:44',NULL),(1160,7492,40787,102503,3,1160,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',7943153.11,NULL,NULL,1,'2024-10-08 16:29:10','2024-10-08 16:29:10',NULL),(1161,7492,40787,102510,3,1161,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',6959719.67,'GASTO 02-2024',NULL,1,'2024-10-08 16:29:58','2024-10-08 16:29:58',NULL),(1162,7492,40787,102512,3,1162,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',2602057.29,'gastos 04-2024',NULL,1,'2024-10-08 16:30:40','2024-10-08 16:30:40',NULL),(1163,7492,40787,102500,12,1163,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',42072877.69,NULL,NULL,1,'2024-11-12 09:33:16','2024-11-12 12:16:35','2024-11-12 12:16:35'),(1164,7492,40787,102504,6,1164,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',5860955.98,'ig 2023 - pago',NULL,1,'2024-11-12 10:19:23','2024-11-12 10:19:23',NULL),(1165,7492,40787,102509,5,1165,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',4072200.31,'EGRESOS BANCO FRANCES',NULL,1,'2024-11-12 10:34:40','2024-11-12 10:34:40',NULL),(1166,7492,40787,102511,5,1166,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',595967.71,'PAGOS',NULL,1,'2024-11-12 10:38:48','2024-11-12 10:38:48',NULL),(1167,7492,40787,102512,5,1167,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',1712986.23,NULL,NULL,1,'2024-11-12 10:40:35','2024-11-12 10:40:35',NULL),(1168,7492,40787,102513,5,1168,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',722561.99,'EGRESOS BANCO FRANCES',NULL,1,'2024-11-12 10:41:36','2024-11-12 10:41:36',NULL),(1169,7492,40787,102514,11,1169,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',46108915.04,NULL,NULL,1,'2024-11-12 10:44:21','2024-11-12 10:44:21',NULL),(1170,7492,40787,102514,11,1170,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',18692344.47,NULL,NULL,1,'2024-11-12 10:53:01','2024-11-12 10:53:01',NULL),(1171,7492,40719,38,3,1171,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',55974.87,NULL,NULL,1,'2024-11-12 11:33:49','2024-11-12 11:33:49',NULL);
INSERT INTO `balance_libro` VALUES (1172,7492,40719,38,11,1172,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',235415.62,NULL,NULL,1,'2024-11-12 11:44:43','2024-11-12 11:44:43',NULL),(1173,7492,40787,102514,11,1173,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',235415.62,NULL,NULL,1,'2024-11-12 11:47:49','2024-11-12 11:47:49',NULL),(1174,7492,40787,102514,3,1174,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',32199.66,NULL,NULL,1,'2024-11-12 11:57:40','2024-11-12 11:57:40',NULL),(1175,7492,40787,102514,3,1175,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',5958.64,NULL,NULL,1,'2024-11-12 11:58:41','2024-11-12 11:58:41',NULL),(1176,7492,40787,102500,12,1176,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',42072877.69,NULL,NULL,1,'2024-11-12 12:16:35','2024-11-12 12:57:59','2024-11-12 12:57:59'),(1177,7492,40787,102504,5,1177,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',5352177.40,'PAGOS IMPUESTOS',NULL,1,'2024-11-12 12:23:48','2024-11-12 12:23:48',NULL),(1178,7492,40787,102514,11,1178,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',444760.13,NULL,NULL,1,'2024-11-12 12:32:11','2024-11-12 12:32:11',NULL),(1179,7492,40787,102514,1,1179,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',11720463.58,NULL,NULL,1,'2024-11-12 12:33:17','2024-11-12 12:33:17',NULL),(1180,7492,40787,102514,3,1180,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',5149050.00,NULL,NULL,1,'2024-11-12 12:36:49','2024-11-12 12:36:49',NULL),(1181,7492,40787,102513,5,1181,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',248537.27,'COMISIONES Y EGRESOS BCO HSBC',NULL,1,'2024-11-12 12:39:52','2024-11-12 12:39:52',NULL),(1182,7492,40787,102514,3,1182,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',140473.48,'FINALIZACION PLANES DE PAGO AFIP',NULL,1,'2024-11-12 12:41:39','2024-11-12 12:41:39',NULL),(1183,7492,40787,102500,12,1183,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',42072877.69,NULL,NULL,1,'2024-11-12 12:57:59','2024-11-12 13:52:00','2024-11-12 13:52:00'),(1184,7492,40787,102514,11,1184,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',11256020.26,NULL,NULL,1,'2024-11-12 13:38:20','2024-11-12 13:38:20',NULL),(1185,7492,40787,102500,3,1185,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',4986071.96,'COSTO DEL SERVICIO',NULL,1,'2024-11-12 13:43:56','2024-11-12 13:43:56',NULL),(1186,7492,40787,102501,3,1186,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',10696335.88,'COSTO DEL SERVICIO',NULL,1,'2024-11-12 13:44:26','2024-11-12 13:44:26',NULL),(1187,7492,40787,102502,3,1187,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',3928922.12,'COSTO DEL SERVICIO',NULL,1,'2024-11-12 13:44:54','2024-11-12 13:44:54',NULL),(1188,7492,40787,102503,3,1188,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',8015047.34,'COSTO DEL SERVICIO',NULL,1,'2024-11-12 13:45:19','2024-11-12 13:45:19',NULL),(1189,7492,40787,102504,3,1189,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',6802105.96,'COSTO DEL SERVICIO',NULL,1,'2024-11-12 13:45:43','2024-11-12 13:45:43',NULL),(1190,7492,40787,102505,3,1190,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',813815.60,'COSTO DEL SERVICIO',NULL,1,'2024-11-12 13:46:10','2024-11-12 13:46:10',NULL);
INSERT INTO `balance_libro` VALUES (1191,7492,40787,102509,3,1191,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',4226310.07,'COSTO DEL SERVICIO',NULL,1,'2024-11-12 13:46:52','2024-11-12 13:46:52',NULL),(1192,7492,40787,102510,3,1192,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',1525409.01,'COSTO DEL SERVICIO',NULL,1,'2024-11-12 13:47:15','2024-11-12 13:47:15',NULL),(1193,7492,40787,102511,3,1193,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',2522158.03,'COSTO DEL SERVICIO',NULL,1,'2024-11-12 13:47:47','2024-11-12 13:47:47',NULL),(1194,7492,40787,102512,3,1194,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',830035.52,'COSTO DEL SERVICIO',NULL,1,'2024-11-12 13:48:05','2024-11-12 13:48:05',NULL),(1195,7492,40787,102513,3,1195,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',752230.79,'COSTO DEL SERVICIO',NULL,1,'2024-11-12 13:48:22','2024-11-12 13:48:22',NULL),(1196,7492,40787,102514,3,1196,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',18447556.70,'COSTO DEL SERVICIO',NULL,1,'2024-11-12 13:48:43','2024-11-12 13:48:43',NULL),(1197,7492,40787,102500,12,1197,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',42072877.69,NULL,NULL,1,'2024-11-12 13:52:00','2024-11-12 13:52:00',NULL),(1198,7492,40787,102514,19,1198,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',370986.00,'Devengamiento intereses Afip',NULL,1,'2024-11-12 14:08:21','2024-11-12 14:08:21',NULL),(1199,7492,40787,102514,11,1199,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',242342.90,NULL,NULL,1,'2024-11-12 14:11:30','2024-11-12 14:11:30',NULL),(1200,7492,40787,102514,4,1200,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',2037793.02,NULL,NULL,1,'2024-11-12 14:25:04','2024-11-12 14:25:04',NULL),(1201,7492,40787,102514,11,1201,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',9000000.00,NULL,NULL,1,'2024-11-12 18:51:18','2024-11-12 18:51:18',NULL),(1202,7492,40787,102514,11,1202,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',44886.65,NULL,NULL,1,'2024-11-12 19:14:33','2024-11-12 19:14:33',NULL),(1203,7492,40787,102514,6,1203,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',8661445.64,NULL,NULL,1,'2024-11-12 20:34:21','2024-11-12 20:34:21',NULL),(1204,7492,40787,102514,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',219110543.32,'Ajuste por Inflacion Asiento Anual',NULL,1,'2024-11-12 20:49:23','2024-11-12 20:49:38',NULL),(1205,7492,40787,102515,2,1205,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',14586583.59,'INGRESO 07-2024',NULL,1,'2025-10-20 14:49:07','2025-10-20 14:49:07',NULL),(1206,7492,40787,102515,3,1206,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',14530522.48,'EGRESOS 07-2024',NULL,1,'2025-10-20 15:17:01','2025-10-20 16:13:35','2025-10-20 16:13:35'),(1207,7492,40787,102515,16,1207,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',344292.12,'Posicion II.BB 07-2024',NULL,1,'2025-10-20 15:25:45','2025-10-20 15:25:45',NULL),(1208,7492,40787,102515,15,1208,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',2531555.83,'POSICION IVA 07-2024',NULL,1,'2025-10-20 15:32:07','2025-10-20 15:32:07',NULL),(1209,7492,40787,102515,5,1209,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',46279106.00,'BCO FRANCES',NULL,1,'2025-10-20 15:40:39','2025-10-20 15:40:39',NULL);
INSERT INTO `balance_libro` VALUES (1210,7492,40787,102515,5,1210,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',30211574.59,'BCO FRANCES',NULL,1,'2025-10-20 15:45:48','2025-10-28 18:49:00','2025-10-28 18:49:00'),(1211,7492,40787,102515,5,1211,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',7824251.37,'PAGO IMP. BCO FRANCES 07-2024',NULL,1,'2025-10-20 15:49:36','2025-10-21 13:11:10','2025-10-21 13:11:10'),(1212,7492,40787,102515,5,1212,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',650783.84,'BCO FRANCES',NULL,1,'2025-10-20 15:53:50','2025-10-21 09:55:19','2025-10-21 09:55:19'),(1213,7492,40787,102515,3,1213,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',14530522.48,'EGRESOS 07-2024',NULL,1,'2025-10-20 16:13:35','2025-10-20 16:28:07','2025-10-20 16:28:07'),(1214,7492,40787,102515,3,1214,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',14530522.48,'EGRESOS 07-2024',NULL,1,'2025-10-20 16:28:07','2025-10-28 16:02:27','2025-10-28 16:02:27'),(1215,7492,40787,102515,3,1215,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',8181263.09,'ASIENTO BCO FRAN SALDO INICIO',NULL,1,'2025-10-21 09:34:38','2025-10-21 09:38:48','2025-10-21 09:38:48'),(1216,7492,40787,102515,3,1216,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',8181263.09,'ASIENTO BCO FRAN SALDO INICIO',NULL,1,'2025-10-21 09:38:48','2025-11-13 11:38:14','2025-11-13 11:38:14'),(1217,7492,40787,102515,5,1217,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',650783.84,'BCO FRANCES',NULL,1,'2025-10-21 09:55:19','2025-10-21 10:09:14','2025-10-21 10:09:14'),(1218,7492,40787,102500,3,1218,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',134542.34,'PAGO SIND. S.V. UOCA .  03-08-2023',NULL,1,'2025-10-21 10:04:03','2025-10-21 10:04:03',NULL),(1219,7492,40787,102515,5,1219,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',650783.84,'BCO FRANCES',NULL,1,'2025-10-21 10:09:14','2025-10-21 10:09:14',NULL),(1220,7492,40787,102516,2,1220,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',38757629.79,'Ingresos 08-2024',NULL,1,'2025-10-21 10:26:38','2025-10-21 10:26:39',NULL),(1221,7492,40787,102516,1,1221,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',3678755.10,'SUELDOS 08-2023',NULL,1,'2025-10-21 10:32:29','2025-10-21 10:32:56','2025-10-21 10:32:56'),(1222,7492,40787,102501,1,1222,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',3678755.10,'SUELDOS 08-2023',NULL,1,'2025-10-21 10:32:56','2025-10-21 10:32:56',NULL),(1223,7492,40787,102501,5,1223,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',42023147.12,'banco frances',NULL,1,'2025-10-21 10:34:02','2025-10-21 10:34:02',NULL),(1224,7492,40787,102502,3,1224,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',6320.55,'PAGO 06-10-2023',NULL,1,'2025-10-21 10:34:39','2025-10-21 10:34:39',NULL),(1225,7492,40787,102516,3,1225,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',11918891.63,'EGRESOS 08-2024',NULL,1,'2025-10-21 10:51:35','2025-10-21 10:51:35',NULL),(1226,7492,40787,102516,16,1226,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',725971.99,'POSICICON II. BB 8-2024',NULL,1,'2025-10-21 10:58:04','2025-10-21 10:58:04',NULL);
INSERT INTO `balance_libro` VALUES (1227,7492,40787,102517,15,1227,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',6726530.79,'IVA 09-2024',NULL,1,'2025-10-21 10:59:43','2025-10-21 11:01:11','2025-10-21 11:01:11'),(1228,7492,40787,102516,15,1228,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',6726530.79,'IVA 08-2024',NULL,1,'2025-10-21 11:01:11','2025-10-21 11:13:31','2025-10-21 11:13:31'),(1229,7492,40787,102517,2,1229,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',34958864.11,'INGRESOS 09-2024',NULL,1,'2025-10-21 11:02:43','2025-10-21 11:02:43',NULL),(1230,7492,40787,102517,3,1230,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',14643467.46,'EGRESOS 09-2024',NULL,1,'2025-10-21 11:12:49','2025-10-21 11:12:49',NULL),(1231,7492,40787,102516,15,1231,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',6726530.79,'IVA 08-2024',NULL,1,'2025-10-21 11:13:31','2025-10-21 11:13:31',NULL),(1232,7492,40787,102517,16,1232,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',635919.34,'LIQUIDACION II.BB09-2024',NULL,1,'2025-10-21 11:18:55','2025-10-21 11:18:55',NULL),(1233,7492,40787,102518,2,1233,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',42293311.62,'INGRESOS 10-2024',NULL,1,'2025-10-21 11:23:43','2025-10-28 17:33:36','2025-10-28 17:33:36'),(1234,7492,40787,102518,3,1234,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',68875197.81,'EGRESOS 10-2024',NULL,1,'2025-10-21 11:36:59','2025-10-21 12:18:53','2025-10-21 12:18:53'),(1235,7492,40787,102503,3,1235,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',3376.59,'IERIC 10-2023',NULL,1,'2025-10-21 11:38:21','2025-10-21 11:38:21',NULL),(1236,7492,40787,102503,3,1236,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',1283114.88,'PAGOS F 931 10-2023_  07-11-2023',NULL,1,'2025-10-21 11:38:48','2025-10-21 11:38:48',NULL),(1237,7492,40787,102503,5,1237,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',714435.85,'COMISIONES BCO 10-2023',NULL,1,'2025-10-21 11:39:30','2025-10-21 11:39:30',NULL),(1238,7492,40787,102503,5,1238,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',17408.97,'COMISIONES BCO HSBC',NULL,1,'2025-10-21 11:39:57','2025-10-21 11:39:57',NULL),(1239,7492,40787,102518,16,1239,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',924107.34,'POSICION II BB 10-2024',NULL,1,'2025-10-21 11:49:17','2025-10-21 11:49:17',NULL),(1240,7492,40787,102518,15,1240,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',11557570.36,'posicion iva 10-2024',NULL,1,'2025-10-21 11:51:58','2025-10-21 12:14:43','2025-10-21 12:14:43'),(1241,7492,40787,102519,2,1241,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',54156011.83,'ingresoso 11-2024',NULL,1,'2025-10-21 11:56:11','2025-10-21 11:56:11',NULL),(1242,7492,40787,102519,3,1242,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',27187973.05,'EGRESOS 11-2024',NULL,1,'2025-10-21 12:03:35','2025-10-21 12:03:35',NULL),(1243,7492,40787,102519,16,1243,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',974577.04,'posicion ii bb 11-2024',NULL,1,'2025-10-21 12:08:54','2025-10-21 12:08:54',NULL),(1244,7492,40787,102519,15,1244,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',9398977.26,'Posicion IVA 11-2024',NULL,1,'2025-10-21 12:12:54','2025-10-21 12:12:54',NULL);
INSERT INTO `balance_libro` VALUES (1245,7492,40787,102518,15,1245,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',11560297.11,'posicion iva 10-2024',NULL,1,'2025-10-21 12:14:43','2025-10-21 12:14:43',NULL),(1246,7492,40787,102518,3,1246,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',68875197.81,'EGRESOS 10-2024',NULL,1,'2025-10-21 12:18:53','2025-10-21 12:44:24','2025-10-21 12:44:24'),(1247,7492,40787,102520,2,1247,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',94002229.82,'INGRESOS 12-2024',NULL,1,'2025-10-21 12:20:53','2025-10-21 12:20:53',NULL),(1248,7492,40787,102520,3,1248,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',45419581.03,'EGRESOS 12-2024',NULL,1,'2025-10-21 12:29:29','2025-10-21 12:49:34','2025-10-21 12:49:34'),(1249,7492,40787,102520,16,1249,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1703506.82,'POSISION II BB 12-2024',NULL,1,'2025-10-21 12:36:11','2025-10-21 12:36:11',NULL),(1250,7492,40787,102520,15,1250,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',16314436.58,'posision iva 12-2024',NULL,1,'2025-10-21 12:37:42','2025-10-21 12:37:42',NULL),(1251,7492,40787,102518,3,1251,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',68875197.81,'EGRESOS 10-2024',NULL,1,'2025-10-21 12:44:24','2025-10-21 12:47:02','2025-10-21 12:47:02'),(1252,7492,40787,102518,3,1252,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',68875197.81,'EGRESOS 10-2024',NULL,1,'2025-10-21 12:47:02','2025-10-21 12:47:02',NULL),(1253,7492,40787,102520,3,1253,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',45419581.03,'EGRESOS 12-2024',NULL,1,'2025-10-21 12:49:34','2025-10-21 12:49:34',NULL),(1254,7492,40787,102500,3,1254,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1972843.47,'SERVICIOS COBRADOS EN BCO',NULL,1,'2025-10-21 13:00:42','2025-10-21 13:00:42',NULL),(1255,7492,40787,102515,5,1255,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',6397272.38,'PAGO IMP. BCO FRANCES 07-2024',NULL,1,'2025-10-21 13:11:10','2025-10-28 18:47:57','2025-10-28 18:47:57'),(1256,7492,40787,102515,1,1256,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',4837307.97,'SUELDOS 07-2024',NULL,1,'2025-10-21 13:19:46','2025-10-21 13:19:47',NULL),(1257,7492,40787,102515,3,1257,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',5599.84,'PAGO IERIC 06-2024',NULL,1,'2025-10-21 13:20:58','2025-10-21 13:20:58',NULL),(1258,7492,40787,102515,3,1258,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-11','2024-07-11',1275982.49,'PAFO F 931 07- 2024',NULL,1,'2025-10-21 13:22:26','2025-10-28 15:51:27','2025-10-28 15:51:27'),(1259,7492,40787,102515,3,1259,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-11','2024-07-11',145396.66,'PAGO UOCRA 06-2024',NULL,1,'2025-10-21 13:37:50','2025-10-21 13:37:50',NULL),(1260,7492,40787,102516,5,1260,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',35083807.14,'BCO FRANCES 08-2024',NULL,1,'2025-10-21 14:11:56','2025-10-21 14:11:56',NULL),(1261,7492,40787,102516,5,1261,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',16701662.18,'PAGOS BCO FRANCES 08-2024',NULL,1,'2025-10-21 14:22:14','2025-10-21 14:45:48','2025-10-21 14:45:48'),(1262,7492,40787,102516,5,1262,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',1805006.41,'PAGOS IMPUESTOS BCO FRANCES 08-2024',NULL,1,'2025-10-21 14:25:18','2025-10-21 14:25:18',NULL);
INSERT INTO `balance_libro` VALUES (1263,7492,40787,102516,5,1263,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',452270.59,'GASTO BCO  FRANCES 08-2024',NULL,1,'2025-10-21 14:27:55','2025-10-21 14:27:55',NULL),(1264,7492,40787,102516,1,1264,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',4630619.51,'SUELDOS 08-2024',NULL,1,'2025-10-21 14:35:02','2025-10-21 14:35:02',NULL),(1265,7492,40787,102516,21,1265,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-12','2024-08-12',7912.82,'PAGO IERICA 07-2024',NULL,1,'2025-10-21 14:36:20','2025-10-21 14:36:20',NULL),(1266,7492,40787,102516,5,1266,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-12','2024-08-12',1372627.69,'PAGO F 931 07-2024',NULL,1,'2025-10-21 14:38:19','2025-10-21 14:38:19',NULL),(1267,7492,40787,102516,5,1267,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-10','2024-08-10',160791.46,'PAGO UOCRA 07-2024',NULL,1,'2025-10-21 14:39:39','2025-10-21 14:39:39',NULL),(1268,7492,40787,102516,5,1268,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',16701662.15,'PAGOS BCO FRANCES 08-2024',NULL,1,'2025-10-21 14:45:48','2025-10-21 14:49:21','2025-10-21 14:49:21'),(1269,7492,40787,102516,5,1269,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',16701662.21,'PAGOS BCO FRANCES 08-2024',NULL,1,'2025-10-21 14:49:21','2025-10-21 14:55:42','2025-10-21 14:55:42'),(1270,7492,40787,102516,5,1270,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',16701661.88,'PAGOS BCO FRANCES 08-2024',NULL,1,'2025-10-21 14:55:42','2025-10-21 14:55:42',NULL),(1271,7492,40787,102517,5,1271,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',26020337.91,'BCO FRANCES 09-2024',NULL,1,'2025-10-21 15:26:30','2025-10-21 15:26:30',NULL),(1272,7492,40787,102517,5,1272,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',10429685.03,'BCO FRANCES 09-2024',NULL,1,'2025-10-21 15:29:04','2025-10-21 15:29:04',NULL),(1273,7492,40787,102517,5,1273,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',8904966.02,'BCO FRANCES 09-2024',NULL,1,'2025-10-21 15:33:19','2025-10-21 15:33:19',NULL),(1274,7492,40787,102517,6,1274,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',332271.42,'GASTPS BCO FRANCES 09-2024',NULL,1,'2025-10-21 15:34:59','2025-10-21 15:34:59',NULL),(1275,7492,40787,102517,1,1275,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',5767405.57,'SUELDOS 09-2024',NULL,1,'2025-10-21 15:38:07','2025-10-21 15:38:07',NULL),(1276,7492,40787,102517,21,1276,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-09','2024-09-09',7694.06,'PAGO IERIC',NULL,1,'2025-10-21 15:39:19','2025-10-21 15:39:19',NULL),(1277,7492,40787,102517,21,1277,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-09','2024-09-09',1620613.44,'BCO FRANCES',NULL,1,'2025-10-21 15:41:58','2025-10-21 15:41:58',NULL),(1278,7492,40787,102502,3,1278,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',6320.55,'PAGO IERC 06-10-2023',NULL,1,'2025-10-21 15:45:59','2025-10-21 15:45:59',NULL),(1279,7492,40787,102518,1,1279,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-30','2024-10-30',7256431.26,'SUELDOS 10-2024',NULL,1,'2025-10-21 15:54:51','2025-10-21 15:54:51',NULL),(1280,7492,40787,102518,5,1280,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-09','2024-10-09',2489488.48,'BCO FRANCES 10-2024',NULL,1,'2025-10-21 15:58:14','2025-10-21 15:58:14',NULL);
INSERT INTO `balance_libro` VALUES (1281,7492,40787,102518,5,1281,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-30','2024-10-30',45452471.11,'BCO FRANCES 10-2024',NULL,1,'2025-10-21 16:01:04','2025-10-21 16:12:48','2025-10-21 16:12:48'),(1282,7492,40787,102518,21,1282,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',11510884.03,'PAGOS 10-2024',NULL,1,'2025-10-21 16:03:23','2025-10-21 16:56:36','2025-10-21 16:56:36'),(1283,7492,40787,102518,5,1283,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',2689415.95,'BCO FRANCES 10-2024',NULL,1,'2025-10-21 16:07:10','2025-10-21 16:07:10',NULL),(1284,7492,40787,102518,5,1284,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',45452471.11,'BCO FRANCES 10-2024',NULL,1,'2025-10-21 16:12:48','2025-10-21 16:12:48',NULL),(1285,7492,40787,102518,21,1285,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',10746990.36,'PAGOS 10-2024',NULL,1,'2025-10-21 16:56:36','2025-10-21 16:56:36',NULL),(1286,7492,40787,102519,5,1286,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',66407250.63,'BCO FRANCES 11-2024',NULL,1,'2025-10-21 17:07:36','2025-10-21 17:07:36',NULL),(1287,7492,40787,102519,5,1287,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',14315558.40,'PAGOS BCO',NULL,1,'2025-10-21 17:10:31','2025-10-21 17:38:50','2025-10-21 17:38:50'),(1288,7492,40787,102519,5,1288,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',7738566.91,'PAGOS  11-2024 BCO FRANCES',NULL,1,'2025-10-21 17:14:23','2025-10-21 17:14:23',NULL),(1289,7492,40787,102519,5,1289,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',606301.64,'BCO FRANCES 11-2024',NULL,1,'2025-10-21 17:15:28','2025-10-21 17:17:07','2025-10-21 17:17:07'),(1290,7492,40787,102519,5,1290,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',725934.60,'BCO FRANCES 11-2024',NULL,1,'2025-10-21 17:17:07','2025-10-21 17:17:07',NULL),(1291,7492,40787,102519,1,1291,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',10367770.49,'SUELDOS 11-2024',NULL,1,'2025-10-21 17:20:12','2025-10-21 17:20:12',NULL),(1292,7492,40787,102519,21,1292,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-15','2024-11-15',11853.60,'PAGO IERIC',NULL,1,'2025-10-21 17:21:16','2025-10-21 17:21:16',NULL),(1293,7492,40787,102519,21,1293,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-10','2024-11-10',2835446.09,'PAGOS BCO FRANCES 11-2024',NULL,1,'2025-10-21 17:24:05','2025-10-21 17:24:05',NULL),(1294,7492,40787,102519,5,1294,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',14314858.40,'PAGOS BCO',NULL,1,'2025-10-21 17:38:50','2025-10-21 17:38:50',NULL),(1295,7492,40787,102520,5,1295,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',72110890.68,'BCO FRANCES 12-2024',NULL,1,'2025-10-21 17:51:49','2025-10-21 17:51:49',NULL),(1296,7492,40787,102520,5,1296,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',23237204.03,'BCO FRANCES',NULL,1,'2025-10-21 17:55:12','2025-10-21 17:55:12',NULL),(1297,7492,40787,102520,5,1297,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',6778753.65,'BCO FRANCES',NULL,1,'2025-10-21 17:59:09','2025-10-21 17:59:09',NULL),(1298,7492,40787,102520,5,1298,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',1069215.43,'GASTOS BCO FRANCES',NULL,1,'2025-10-21 18:02:04','2025-10-21 18:02:04',NULL);
INSERT INTO `balance_libro` VALUES (1299,7492,40787,102520,1,1299,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',13348758.69,'SUELDOS 12-2024',NULL,1,'2025-10-21 18:07:13','2025-10-21 18:07:13',NULL),(1300,7492,40787,102520,5,1300,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-11','2024-12-11',3917621.78,'PAGOS BCO FRANCES',NULL,1,'2025-10-21 18:09:57','2025-10-21 18:09:57',NULL),(1301,7492,40787,102515,5,1301,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',282590.42,'BANCO HSBC 07-2024',NULL,1,'2025-10-22 12:31:20','2025-10-22 12:37:51','2025-10-22 12:37:51'),(1302,7492,40787,102515,5,1302,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',2251.97,'GASTOS BCO HSBC 07-2024',NULL,1,'2025-10-22 12:33:16','2025-10-22 12:33:16',NULL),(1303,7492,40787,102515,5,1303,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',314788.19,'BANCO HSBC 07-2024',NULL,1,'2025-10-22 12:37:51','2025-10-22 12:44:46','2025-10-22 12:44:46'),(1304,7492,40787,102515,5,1304,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',25693.25,'ASIENTO APETURA  HCBS',NULL,1,'2025-10-22 12:39:03','2025-10-22 12:39:03',NULL),(1305,7492,40787,102515,5,1305,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',314788.69,'BANCO HSBC 07-2024',NULL,1,'2025-10-22 12:44:46','2025-10-22 12:44:46',NULL),(1306,7492,40787,102516,5,1306,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',295296.84,'BANCO HSBC 08-2024',NULL,1,'2025-10-22 12:47:44','2025-10-22 12:47:44',NULL),(1307,7492,40787,102517,5,1307,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',324244.69,'BANCO HSBC 09-2024',NULL,1,'2025-10-22 12:51:09','2025-10-22 12:51:09',NULL),(1308,7492,40787,102518,5,1308,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',338488.11,'banco hsbc 10-2024',NULL,1,'2025-10-22 12:53:53','2025-10-22 12:53:53',NULL),(1309,7492,40787,102519,5,1309,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',372901.19,'BCO HSBC 11-2024',NULL,1,'2025-10-22 12:57:33','2025-10-22 12:57:33',NULL),(1310,7492,40787,102520,5,1310,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',610097.88,'BCO HSBC 12-2024',NULL,1,'2025-10-22 12:59:27','2025-10-22 13:04:04','2025-10-22 13:04:04'),(1311,7492,40787,102520,5,1311,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',610097.87,'BCO HSBC 12-2024',NULL,1,'2025-10-22 13:04:04','2025-10-22 13:04:04',NULL),(1312,7492,40787,102524,2,1312,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',59297842.24,'INGRESOS 01-2025',NULL,1,'2025-10-22 13:29:13','2025-10-22 13:29:13',NULL),(1313,7492,40787,102524,3,1313,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',46607754.11,'EGRESOS 01-2025',NULL,1,'2025-10-22 13:43:09','2025-10-22 13:45:39','2025-10-22 13:45:39'),(1314,7492,40787,102524,3,1314,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',46607754.11,'EGRESOS 01-2025',NULL,1,'2025-10-22 13:45:39','2025-10-27 13:27:00','2025-10-27 13:27:00'),(1315,7492,40787,102524,16,1315,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',1236886.49,'posicion ii.bb 01-2025',NULL,1,'2025-10-22 13:53:07','2025-10-22 13:53:07',NULL),(1316,7492,40787,102524,15,1316,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',10291361.05,'POSICION IVA 01-2025',NULL,1,'2025-10-22 13:54:33','2025-10-22 13:54:33',NULL);
INSERT INTO `balance_libro` VALUES (1317,7492,40787,102525,2,1317,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',51051892.87,'INGRESOS 02-2025',NULL,1,'2025-10-22 13:55:34','2025-10-22 13:55:34',NULL),(1318,7492,40787,102525,3,1318,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',32207169.10,'EGRESOS 02-2025',NULL,1,'2025-10-22 14:02:21','2025-10-22 14:02:21',NULL),(1319,7492,40787,102525,16,1319,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',1015362.60,'POSICION II. BB 02-2025',NULL,1,'2025-10-22 14:07:12','2025-10-22 14:07:12',NULL),(1320,7492,40787,102525,15,1320,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',8860245.87,'POSICION IVA 02-2025',NULL,1,'2025-10-22 14:08:29','2025-10-22 14:08:29',NULL),(1321,7492,40787,102526,2,1321,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',30195224.28,'INGRESOS 03-2025',NULL,1,'2025-10-22 14:12:29','2025-10-22 14:12:29',NULL),(1322,7492,40787,102526,3,1322,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',17611116.12,'EGRESOS 03-2025',NULL,1,'2025-10-22 14:20:56','2025-10-22 14:20:56',NULL),(1323,7492,40787,102526,16,1323,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',561538.31,'POSICION II.BB 03-2025',NULL,1,'2025-10-22 14:25:31','2025-10-22 14:25:31',NULL),(1324,7492,40787,102526,15,1324,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',5240493.47,'POSICION IVA 03-2025',NULL,1,'2025-10-22 14:27:02','2025-10-22 14:27:02',NULL),(1325,7492,40787,102527,2,1325,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',17448668.73,'ingressos 04-2025',NULL,1,'2025-10-22 14:28:14','2025-10-22 14:28:14',NULL),(1326,7492,40787,102527,3,1326,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',10799221.68,'EGRESOSO 04-2025',NULL,1,'2025-10-22 14:39:42','2025-10-22 14:39:42',NULL),(1327,7492,40787,102527,16,1327,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',289711.43,'POSICION II BB04-2025',NULL,1,'2025-10-22 14:42:43','2025-10-22 14:42:43',NULL),(1328,7492,40787,102527,15,1328,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',3028281.35,'POSICION IVA 04-2025',NULL,1,'2025-10-22 14:43:46','2025-10-22 14:43:46',NULL),(1329,7492,40787,102528,3,1329,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',13963879.31,'EGRESOS 05-2025',NULL,1,'2025-10-22 14:48:57','2025-10-22 14:48:57',NULL),(1330,7492,40787,102528,16,1330,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',18898.18,'POSICION II.BB',NULL,1,'2025-10-22 14:51:03','2025-10-22 14:51:03',NULL),(1331,7492,40787,102528,15,1331,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',2191634.66,'POSICION IVA 05-2025',NULL,1,'2025-10-22 14:53:05','2025-10-22 14:53:05',NULL),(1332,7492,40787,102529,2,1332,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',116672467.44,'INGRESOS 06-2025',NULL,1,'2025-10-22 14:54:20','2025-10-22 14:54:20',NULL),(1333,7492,40787,102529,3,1333,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',102401081.72,'EGRESOS 06-2025',NULL,1,'2025-10-22 15:01:52','2025-10-22 15:01:52',NULL),(1334,7492,40787,102529,16,1334,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',2875803.52,'POSICION II BB 06-2025',NULL,1,'2025-10-22 15:07:11','2025-10-22 15:07:11',NULL);
INSERT INTO `balance_libro` VALUES (1335,7492,40787,102529,15,1335,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',20248940.63,'POSICION IVA 06-2025',NULL,1,'2025-10-22 15:10:30','2025-10-22 15:10:30',NULL),(1336,7492,40787,102524,5,1336,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',91879153.42,'BCO FRANCES 01-2025',NULL,1,'2025-10-24 15:31:52','2025-10-27 14:31:58','2025-10-27 14:31:58'),(1337,7492,40787,102524,5,1337,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',31613649.49,'BCO FRANCES 01-2025',NULL,1,'2025-10-24 15:39:12','2025-10-24 16:14:27','2025-10-24 16:14:27'),(1338,7492,40787,102524,5,1338,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',1524109.89,'BCO FRANCES 01-2025',NULL,1,'2025-10-24 15:44:10','2025-10-24 15:44:10',NULL),(1339,7492,40787,102524,5,1339,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',1163716.91,'BCO FRANCES 01-2025',NULL,1,'2025-10-24 15:46:38','2025-10-24 15:46:38',NULL),(1340,7492,40787,102524,1,1340,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',12147899.77,'SUELDOS 01-2025',NULL,1,'2025-10-24 15:53:50','2025-10-24 15:53:50',NULL),(1341,7492,40787,102524,5,1341,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-13','2025-01-13',5299245.94,'PAGOS 01-2025',NULL,1,'2025-10-24 15:56:53','2025-10-28 16:58:20','2025-10-28 16:58:20'),(1342,7492,40787,102524,5,1342,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',31610799.49,'BCO FRANCES 01-2025',NULL,1,'2025-10-24 16:14:27','2025-10-24 16:18:32','2025-10-24 16:18:32'),(1343,7492,40787,102524,5,1343,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',31610798.50,'BCO FRANCES 01-2025',NULL,1,'2025-10-24 16:18:32','2025-10-24 16:18:32',NULL),(1344,7492,40787,102525,5,1344,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',49883707.65,'banco frances 02-2025',NULL,1,'2025-10-27 09:49:12','2025-10-27 09:49:12',NULL),(1345,7492,40787,102531,5,1345,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',9487248.03,'BCO FRANCES 02-2025',NULL,1,'2025-10-27 09:51:47','2025-10-27 09:51:47',NULL),(1346,7492,40787,102525,5,1346,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',4632257.22,'BCO FRANCES 02-2025',NULL,1,'2025-10-27 09:54:50','2025-10-27 09:54:50',NULL),(1347,7492,40787,102525,5,1347,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',636239.00,'BCO FRANCES 02-2025',NULL,1,'2025-10-27 09:56:20','2025-10-27 09:56:20',NULL),(1348,7492,40787,102525,1,1348,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',9770881.15,'sueldos 02-2025',NULL,1,'2025-10-27 09:59:19','2025-10-28 16:46:03','2025-10-28 16:46:03'),(1349,7492,40787,102525,21,1349,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-10','2025-02-10',4632203.18,'BCO FRANCES pagos',NULL,1,'2025-10-27 10:04:42','2025-10-27 10:04:42',NULL),(1350,7492,40787,102525,5,1350,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',9487248.02,'BCO FRANCES',NULL,1,'2025-10-27 10:21:23','2025-10-27 10:25:54','2025-10-27 10:25:54'),(1351,7492,40787,102525,5,1351,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',9487245.04,'BCO FRANCES',NULL,1,'2025-10-27 10:25:54','2025-10-27 10:25:54',NULL),(1352,7492,40787,102526,2,1352,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',38017841.41,'ingresos 03-2025',NULL,1,'2025-10-27 11:20:36','2025-10-27 11:20:36',NULL);
INSERT INTO `balance_libro` VALUES (1353,7492,40787,102526,3,1353,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',9451454.03,'pagos',NULL,1,'2025-10-27 11:22:17','2025-10-27 11:22:17',NULL),(1354,7492,40787,102526,5,1354,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',10018250.28,'BCO FRANCES',NULL,1,'2025-10-27 11:24:18','2025-10-27 11:24:18',NULL),(1355,7492,40787,102526,21,1355,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',504056.13,'BCO FRANCES',NULL,1,'2025-10-27 11:25:36','2025-10-27 11:25:36',NULL),(1356,7492,40787,102526,1,1356,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',10310369.76,'sueldos',NULL,1,'2025-10-27 11:29:14','2025-10-27 11:29:14',NULL),(1357,7492,40787,102526,5,1357,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-13','2025-03-13',3848167.18,'BCO FRANCES',NULL,1,'2025-10-27 11:32:09','2025-10-27 11:32:09',NULL),(1358,7492,40787,102527,2,1358,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',15134035.42,'ingresos',NULL,1,'2025-10-27 11:34:52','2025-10-27 11:34:52',NULL),(1359,7492,40787,102527,3,1359,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',6943254.03,'egresos',NULL,1,'2025-10-27 11:36:31','2025-10-27 11:36:31',NULL),(1360,7492,40787,102527,21,1360,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',3593981.44,'pagos',NULL,1,'2025-10-27 11:38:53','2025-10-27 11:38:53',NULL),(1361,7492,40787,102527,5,1361,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',184786.30,'BCO FRANCES',NULL,1,'2025-10-27 11:42:42','2025-10-27 11:42:42',NULL),(1362,7492,40787,102527,1,1362,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',3309635.80,'sueldos',NULL,1,'2025-10-27 11:45:29','2025-10-27 11:45:29',NULL),(1363,7492,40787,102527,21,1363,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-09','2025-04-09',3531106.55,'pagos',NULL,1,'2025-10-27 11:49:56','2025-10-27 11:49:56',NULL),(1364,7492,40787,102528,2,1364,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',4899645.20,'BCO FRANCES',NULL,1,'2025-10-27 12:04:41','2025-10-27 12:04:41',NULL),(1365,7492,40787,102528,3,1365,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',1651260.73,'pagos',NULL,1,'2025-10-27 12:08:44','2025-10-27 12:08:44',NULL),(1366,7492,40787,102528,21,1366,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',3398505.84,'pagos',NULL,1,'2025-10-27 12:10:27','2025-10-27 12:10:27',NULL),(1367,7492,40787,102528,4,1367,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',101219.00,'pagos',NULL,1,'2025-10-27 12:11:26','2025-10-27 12:11:26',NULL),(1368,7492,40787,102528,1,1368,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',1766331.00,'sueldos',NULL,1,'2025-10-27 12:14:19','2025-10-28 16:37:13','2025-10-28 16:37:13'),(1369,7492,40787,102528,3,1369,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-12','2025-05-12',1306999.39,'pagos',NULL,1,'2025-10-27 12:17:03','2025-10-27 12:17:03',NULL),(1370,7492,40787,102529,2,1370,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',66001007.60,'BCO FRANCES',NULL,1,'2025-10-27 12:21:45','2025-10-27 14:12:16','2025-10-27 14:12:16'),(1371,7492,40787,102529,3,1371,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',4784291.21,'pagos',NULL,1,'2025-10-27 12:23:39','2025-10-27 12:23:39',NULL);
INSERT INTO `balance_libro` VALUES (1372,7492,40787,102529,21,1372,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',4948139.72,'pagos',NULL,1,'2025-10-27 12:27:43','2025-10-27 12:40:57','2025-10-27 12:40:57'),(1373,7492,40787,102529,5,1373,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',874687.94,'BCO FRANCES',NULL,1,'2025-10-27 12:28:50','2025-10-27 12:28:50',NULL),(1374,7492,40787,102529,1,1374,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',8049568.92,'sueldos',NULL,1,'2025-10-27 12:32:12','2025-10-27 12:32:12',NULL),(1375,7492,40787,102529,21,1375,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-10','2025-06-10',661423.46,'pagos',NULL,1,'2025-10-27 12:34:43','2025-10-27 12:39:33','2025-10-27 12:39:33'),(1376,7492,40787,102529,3,1376,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',57399.38,'deudas',NULL,1,'2025-10-27 12:36:15','2025-10-27 12:36:15',NULL),(1377,7492,40787,102529,21,1377,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-10','2025-06-10',661423.46,'pagos',NULL,1,'2025-10-27 12:39:33','2025-10-27 12:39:33',NULL),(1378,7492,40787,102529,21,1378,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',4948516.74,'pagos',NULL,1,'2025-10-27 12:40:57','2025-10-29 09:44:32','2025-10-29 09:44:32'),(1379,7492,40787,102524,5,1379,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',1550836.43,'banco hsbc',NULL,1,'2025-10-27 13:18:09','2025-10-27 13:18:09',NULL),(1380,7492,40787,102525,5,1380,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',1246306.56,'bco HCBS',NULL,1,'2025-10-27 13:21:01','2025-10-27 13:21:01',NULL),(1381,7492,40787,102524,3,1381,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',46607754.11,'EGRESOS 01-2025',NULL,1,'2025-10-27 13:27:00','2025-10-27 13:27:00',NULL),(1382,7492,40787,102526,5,1382,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',3234736.85,'BCO HSBC',NULL,1,'2025-10-27 13:31:06','2025-10-27 13:31:06',NULL),(1383,7492,40787,102527,5,1383,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-30','2025-04-30',387396.77,'BCO HSBC',NULL,1,'2025-10-27 13:50:44','2025-10-27 13:50:44',NULL),(1384,7492,40787,102528,5,1384,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',401328.97,'BCO HSBC',NULL,1,'2025-10-27 13:52:22','2025-10-27 13:52:22',NULL),(1385,7492,40787,102529,5,1385,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',613065.51,'BCO HSBC',NULL,1,'2025-10-27 13:55:40','2025-10-27 13:55:40',NULL),(1386,7492,40787,102529,2,1386,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',66592613.10,'BCO FRANCES',NULL,1,'2025-10-27 14:12:16','2025-10-27 14:17:20','2025-10-27 14:17:20'),(1387,7492,40787,102529,2,1387,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',67248580.42,'BCO FRANCES',NULL,1,'2025-10-27 14:17:20','2025-10-27 14:17:20',NULL),(1388,7492,40787,102524,5,1388,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',91761530.05,'BCO FRANCES 01-2025',NULL,1,'2025-10-27 14:31:58','2025-10-27 14:31:58',NULL),(1389,7492,40787,102515,3,1389,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-11','2024-07-11',1273982.49,'PAFO F 931 07- 2024',NULL,1,'2025-10-28 15:51:27','2025-10-28 16:21:17','2025-10-28 16:21:17');
INSERT INTO `balance_libro` VALUES (1390,7492,40787,102515,3,1390,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',14530522.48,'EGRESOS 07-2024',NULL,1,'2025-10-28 16:02:27','2025-10-28 16:19:40','2025-10-28 16:19:40'),(1391,7492,40787,102515,3,1391,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',14530522.48,'EGRESOS 07-2024',NULL,1,'2025-10-28 16:19:40','2025-10-28 17:23:33','2025-10-28 17:23:33'),(1392,7492,40787,102515,3,1392,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-11','2024-07-11',1275982.49,'PAFO F 931 07- 2024',NULL,1,'2025-10-28 16:21:17','2025-10-28 16:21:17',NULL),(1393,7492,40787,102528,1,1393,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',1766331.00,'sueldos',NULL,1,'2025-10-28 16:37:13','2025-10-28 16:37:13',NULL),(1394,7492,40787,102525,1,1394,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',9770881.15,'sueldos 02-2025',NULL,1,'2025-10-28 16:46:03','2025-10-28 16:46:03',NULL),(1395,7492,40787,102524,5,1395,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-13','2025-01-13',5299245.94,'PAGOS 01-2025',NULL,1,'2025-10-28 16:58:20','2025-10-28 16:58:20',NULL),(1396,7492,40787,102517,15,1396,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',6067240.88,'IVA',NULL,1,'2025-10-28 17:19:49','2025-10-28 17:19:49',NULL),(1397,7492,40787,102515,3,1397,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',14530522.48,'EGRESOS 07-2024',NULL,1,'2025-10-28 17:23:33','2025-10-28 17:23:33',NULL),(1398,7492,40787,102518,2,1398,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',42293311.62,'INGRESOS 10-2024',NULL,1,'2025-10-28 17:33:36','2025-10-28 17:33:36',NULL),(1399,7492,40787,102515,5,1399,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',4597272.38,'PAGO IMP. BCO FRANCES 07-2024',NULL,1,'2025-10-28 18:47:57','2025-10-28 18:47:57',NULL),(1400,7492,40787,102515,5,1400,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',32011574.59,'BCO FRANCES',NULL,1,'2025-10-28 18:49:00','2025-10-28 18:49:00',NULL),(1401,7492,40787,102529,21,1401,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',4948516.74,'pagos',NULL,1,'2025-10-29 09:44:33','2025-10-29 10:00:07','2025-10-29 10:00:07'),(1402,7492,40787,102529,21,1402,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',4948516.74,'pagos',NULL,1,'2025-10-29 10:00:07','2025-10-29 10:00:07',NULL),(1403,7492,40787,102514,17,1403,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',459159525.16,NULL,NULL,1,'2025-11-09 17:44:15','2025-11-09 17:44:15',NULL),(1404,7492,40787,102515,12,1404,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',157131259.82,NULL,NULL,1,'2025-11-09 17:53:40','2025-11-13 13:05:46','2025-11-13 13:05:46'),(1405,7492,40787,102515,12,1405,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',157131259.85,'ASIENTO DE APERTURA',NULL,1,'2025-11-13 12:26:28','2025-11-13 12:26:28',NULL),(1406,7492,40787,102518,4,1406,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',4811766.94,NULL,NULL,1,'2025-11-13 13:13:36','2025-11-13 19:56:56','2025-11-13 19:56:56'),(1407,7492,40787,102518,3,1407,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',29064050.86,'baja de rodado',NULL,1,'2025-11-13 13:20:36','2025-11-13 13:20:36',NULL);
INSERT INTO `balance_libro` VALUES (1408,7492,40787,102518,2,1408,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',29064050.86,NULL,NULL,1,'2025-11-13 19:46:01','2025-11-13 20:02:06','2025-11-13 20:02:06'),(1409,7492,40787,102529,4,1409,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',11856653.10,NULL,NULL,1,'2025-11-13 19:52:51','2025-11-13 19:52:51',NULL),(1410,7492,40787,102529,4,1410,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',4811766.94,NULL,NULL,1,'2025-11-13 19:56:56','2025-11-13 19:56:56',NULL),(1411,7492,40787,102529,3,1411,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',182058253.33,NULL,NULL,1,'2025-11-13 20:06:21','2025-11-13 20:06:21',NULL),(1412,7492,40787,102529,3,1412,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',1100770.43,NULL,NULL,1,'2025-11-13 20:26:10','2025-11-13 20:26:10',NULL),(1413,7492,40787,102529,18,1413,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',6504705.15,NULL,NULL,1,'2025-11-13 21:13:11','2025-11-13 21:13:11',NULL),(1414,7492,40787,102520,6,1414,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',352347.76,NULL,NULL,1,'2025-11-13 21:21:50','2025-11-13 21:23:16','2025-11-13 21:23:16'),(1415,7492,40787,102520,6,1415,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-01','2024-12-01',8661445.64,NULL,NULL,1,'2025-11-13 21:27:18','2025-11-13 21:27:18',NULL),(1416,7492,40787,102520,5,1416,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',2388805.62,NULL,NULL,1,'2025-11-13 21:51:25','2025-11-13 21:51:25',NULL),(1417,7492,40787,102529,11,1417,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',60334706.80,NULL,NULL,1,'2025-11-13 22:08:39','2025-11-13 22:08:39',NULL),(1418,7492,40787,102519,6,1418,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',352347.76,NULL,NULL,1,'2025-11-13 22:16:59','2025-11-13 22:16:59',NULL),(1419,7492,40787,102529,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',96420453.93,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-11-13 22:51:24','2025-11-14 12:18:28','2025-11-14 12:18:28'),(1420,7492,40787,102529,2,1420,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',12831000.00,NULL,NULL,1,'2025-11-14 11:50:58','2025-11-14 11:50:59',NULL),(1421,7492,40787,102529,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',96420453.93,'Ajuste por Inflacion Asiento Anual',NULL,1,'2025-11-14 12:23:26','2025-11-14 12:23:46',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8804 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7492,1,40787,102487,2,482,2,2639780.00,NULL,'2022-10-31 10:40:08','2023-03-08 16:47:23','2023-03-08 16:47:23'),(2,7492,1,40787,102487,2,67,2,554353.80,NULL,'2022-10-31 10:40:08','2023-03-08 16:47:23','2023-03-08 16:47:23'),(3,7492,1,40787,102487,2,14,1,3194133.80,NULL,'2022-10-31 10:40:08','2023-03-08 16:47:23','2023-03-08 16:47:23'),(4,7492,2,40787,102490,3,217,1,101271.99,NULL,'2022-10-31 12:48:56','2023-11-05 14:01:10','2023-11-05 14:01:10'),(5,7492,2,40787,102490,3,68,1,21267.12,NULL,'2022-10-31 12:48:56','2023-11-05 14:01:10','2023-11-05 14:01:10'),(6,7492,2,40787,102490,3,226,1,6076.32,NULL,'2022-10-31 12:48:56','2023-11-05 14:01:10','2023-11-05 14:01:10'),(7,7492,2,40787,102490,3,57,2,128615.43,NULL,'2022-10-31 12:48:56','2023-11-05 14:01:10','2023-11-05 14:01:10'),(8,7492,3,40787,102487,3,128,1,29795.53,NULL,'2022-10-31 16:09:37','2022-10-31 16:12:16','2022-10-31 16:12:16'),(9,7492,3,40787,102487,3,160,1,16125.79,NULL,'2022-10-31 16:09:37','2022-10-31 16:12:16','2022-10-31 16:12:16'),(10,7492,3,40787,102487,3,121,1,18701.32,NULL,'2022-10-31 16:09:37','2022-10-31 16:12:16','2022-10-31 16:12:16'),(11,7492,3,40787,102487,3,180,1,41889.75,NULL,'2022-10-31 16:09:37','2022-10-31 16:12:16','2022-10-31 16:12:16'),(12,7492,3,40787,102487,3,198,1,13494.09,NULL,'2022-10-31 16:09:37','2022-10-31 16:12:16','2022-10-31 16:12:16'),(13,7492,3,40787,102487,3,392,1,861094.21,NULL,'2022-10-31 16:09:37','2022-10-31 16:12:16','2022-10-31 16:12:16'),(14,7492,3,40787,102487,3,135,1,18985.17,NULL,'2022-10-31 16:09:37','2022-10-31 16:12:16','2022-10-31 16:12:16'),(15,7492,3,40787,102487,3,483,1,37500.00,NULL,'2022-10-31 16:09:37','2022-10-31 16:12:16','2022-10-31 16:12:16'),(16,7492,3,40787,102487,3,193,1,85000.00,NULL,'2022-10-31 16:09:37','2022-10-31 16:12:16','2022-10-31 16:12:16'),(17,7492,3,40787,102487,3,199,1,6687.26,NULL,'2022-10-31 16:09:37','2022-10-31 16:12:16','2022-10-31 16:12:16'),(18,7492,3,40787,102487,3,250,1,1682.19,NULL,'2022-10-31 16:09:37','2022-10-31 16:12:16','2022-10-31 16:12:16'),(19,7492,3,40787,102487,3,484,1,1223.94,NULL,'2022-10-31 16:09:37','2022-10-31 16:12:16','2022-10-31 16:12:16'),(20,7492,3,40787,102487,3,485,1,2053.08,NULL,'2022-10-31 16:09:37','2022-10-31 16:12:16','2022-10-31 16:12:16'),(21,7492,3,40787,102487,3,486,1,14980.81,NULL,'2022-10-31 16:09:37','2022-10-31 16:12:16','2022-10-31 16:12:16'),(22,7492,3,40787,102487,3,359,2,1357395.67,NULL,'2022-10-31 16:09:37','2022-10-31 16:12:16','2022-10-31 16:12:16'),(23,7492,3,40787,102487,3,68,1,208182.53,NULL,'2022-10-31 16:09:37','2022-10-31 16:12:16','2022-10-31 16:12:16'),(24,7492,4,40787,102487,3,128,1,29795.53,NULL,'2022-10-31 16:12:16','2023-03-08 16:47:34','2023-03-08 16:47:34'),(25,7492,4,40787,102487,3,160,1,16125.79,NULL,'2022-10-31 16:12:16','2023-03-08 16:47:34','2023-03-08 16:47:34'),(26,7492,4,40787,102487,3,121,1,18701.32,NULL,'2022-10-31 16:12:16','2023-03-08 16:47:34','2023-03-08 16:47:34'),(27,7492,4,40787,102487,3,180,1,41889.75,NULL,'2022-10-31 16:12:16','2023-03-08 16:47:34','2023-03-08 16:47:34'),(28,7492,4,40787,102487,3,198,1,13494.09,NULL,'2022-10-31 16:12:16','2023-03-08 16:47:34','2023-03-08 16:47:34'),(29,7492,4,40787,102487,3,392,1,861094.21,NULL,'2022-10-31 16:12:16','2023-03-08 16:47:34','2023-03-08 16:47:34'),(30,7492,4,40787,102487,3,483,1,37500.00,NULL,'2022-10-31 16:12:16','2023-03-08 16:47:34','2023-03-08 16:47:34'),(31,7492,4,40787,102487,3,193,1,85000.00,NULL,'2022-10-31 16:12:16','2023-03-08 16:47:34','2023-03-08 16:47:34'),(32,7492,4,40787,102487,3,199,1,6687.26,NULL,'2022-10-31 16:12:16','2023-03-08 16:47:34','2023-03-08 16:47:34'),(33,7492,4,40787,102487,3,250,1,1682.19,NULL,'2022-10-31 16:12:16','2023-03-08 16:47:34','2023-03-08 16:47:34'),(34,7492,4,40787,102487,3,484,1,1223.94,NULL,'2022-10-31 16:12:16','2023-03-08 16:47:34','2023-03-08 16:47:34'),(35,7492,4,40787,102487,3,485,1,2053.08,NULL,'2022-10-31 16:12:16','2023-03-08 16:47:34','2023-03-08 16:47:34');
INSERT INTO `balance_libro_details` VALUES (36,7492,4,40787,102487,3,486,1,14980.81,NULL,'2022-10-31 16:12:16','2023-03-08 16:47:34','2023-03-08 16:47:34'),(37,7492,4,40787,102487,3,359,2,1357395.67,NULL,'2022-10-31 16:12:16','2023-03-08 16:47:34','2023-03-08 16:47:34'),(38,7492,4,40787,102487,3,68,1,208182.53,NULL,'2022-10-31 16:12:16','2023-03-08 16:47:34','2023-03-08 16:47:34'),(39,7492,4,40787,102487,3,212,1,18985.17,NULL,'2022-10-31 16:12:16','2023-03-08 16:47:34','2023-03-08 16:47:34'),(40,7492,5,40787,102487,2,482,2,2639780.00,NULL,'2023-03-08 16:47:23','2023-03-08 16:47:32','2023-03-08 16:47:32'),(41,7492,5,40787,102487,2,67,2,554353.80,NULL,'2023-03-08 16:47:23','2023-03-08 16:47:32','2023-03-08 16:47:32'),(42,7492,5,40787,102487,2,14,1,3194133.80,NULL,'2023-03-08 16:47:23','2023-03-08 16:47:32','2023-03-08 16:47:32'),(43,7492,6,40787,102487,2,14,1,3194133.80,NULL,'2023-03-09 15:34:53','2023-03-16 16:03:33','2023-03-16 16:03:33'),(44,7492,6,40787,102487,2,67,2,554353.80,NULL,'2023-03-09 15:34:53','2023-03-16 16:03:33','2023-03-16 16:03:33'),(45,7492,6,40787,102487,2,482,2,2639780.00,NULL,'2023-03-09 15:34:53','2023-03-16 16:03:33','2023-03-16 16:03:33'),(46,7492,7,40787,102487,2,14,1,3194133.80,NULL,'2023-03-16 16:03:33','2023-11-05 14:01:10','2023-11-05 14:01:10'),(47,7492,7,40787,102487,2,67,2,554353.80,NULL,'2023-03-16 16:03:33','2023-11-05 14:01:10','2023-11-05 14:01:10'),(48,7492,7,40787,102487,2,482,2,2639780.00,NULL,'2023-03-16 16:03:33','2023-11-05 14:01:10','2023-11-05 14:01:10'),(49,7492,8,40787,102487,3,392,1,832026.31,NULL,'2023-03-16 16:21:32','2023-03-16 16:22:50','2023-03-16 16:22:50'),(50,7492,8,40787,102487,3,491,1,16125.79,NULL,'2023-03-16 16:21:32','2023-03-16 16:22:50','2023-03-16 16:22:50'),(51,7492,8,40787,102487,3,199,1,6687.26,NULL,'2023-03-16 16:21:32','2023-03-16 16:22:50','2023-03-16 16:22:50'),(52,7492,8,40787,102487,3,492,1,13494.09,NULL,'2023-03-16 16:21:32','2023-03-16 16:22:50','2023-03-16 16:22:50'),(53,7492,8,40787,102487,3,490,1,29795.53,NULL,'2023-03-16 16:21:32','2023-03-16 16:22:50','2023-03-16 16:22:50'),(54,7492,8,40787,102487,3,489,1,18985.17,NULL,'2023-03-16 16:21:32','2023-03-16 16:22:50','2023-03-16 16:22:50'),(55,7492,8,40787,102487,3,121,1,18701.32,NULL,'2023-03-16 16:21:32','2023-03-16 16:22:50','2023-03-16 16:22:50'),(56,7492,8,40787,102487,3,180,1,41889.75,NULL,'2023-03-16 16:21:32','2023-03-16 16:22:50','2023-03-16 16:22:50'),(57,7492,8,40787,102487,3,483,1,37500.00,NULL,'2023-03-16 16:21:32','2023-03-16 16:22:50','2023-03-16 16:22:50'),(58,7492,8,40787,102487,3,193,1,85000.00,NULL,'2023-03-16 16:21:32','2023-03-16 16:22:50','2023-03-16 16:22:50'),(59,7492,8,40787,102487,3,68,1,208182.53,NULL,'2023-03-16 16:21:32','2023-03-16 16:22:50','2023-03-16 16:22:50'),(60,7492,8,40787,102487,3,485,1,1649.33,NULL,'2023-03-16 16:21:32','2023-03-16 16:22:50','2023-03-16 16:22:50'),(61,7492,8,40787,102487,3,484,1,1223.94,NULL,'2023-03-16 16:21:32','2023-03-16 16:22:50','2023-03-16 16:22:50'),(62,7492,8,40787,102487,3,503,1,1682.19,NULL,'2023-03-16 16:21:32','2023-03-16 16:22:50','2023-03-16 16:22:50'),(63,7492,8,40787,102487,3,359,1,44452.46,NULL,'2023-03-16 16:21:32','2023-03-16 16:22:50','2023-03-16 16:22:50'),(64,7492,8,40787,102487,3,166,2,806554.73,NULL,'2023-03-16 16:21:32','2023-03-16 16:22:50','2023-03-16 16:22:50'),(65,7492,8,40787,102487,3,359,2,550840.94,NULL,'2023-03-16 16:21:32','2023-03-16 16:22:50','2023-03-16 16:22:50'),(66,7492,9,40787,102487,3,392,1,832026.31,NULL,'2023-03-16 16:22:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(67,7492,9,40787,102487,3,491,1,16125.79,NULL,'2023-03-16 16:22:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(68,7492,9,40787,102487,3,199,1,6687.26,NULL,'2023-03-16 16:22:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(69,7492,9,40787,102487,3,492,1,13494.09,NULL,'2023-03-16 16:22:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(70,7492,9,40787,102487,3,490,1,29795.53,NULL,'2023-03-16 16:22:50','2023-11-05 14:01:10','2023-11-05 14:01:10');
INSERT INTO `balance_libro_details` VALUES (71,7492,9,40787,102487,3,489,1,18985.17,NULL,'2023-03-16 16:22:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(72,7492,9,40787,102487,3,121,1,18701.32,NULL,'2023-03-16 16:22:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(73,7492,9,40787,102487,3,180,1,41889.75,NULL,'2023-03-16 16:22:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(74,7492,9,40787,102487,3,483,1,37500.00,NULL,'2023-03-16 16:22:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(75,7492,9,40787,102487,3,193,1,85000.00,NULL,'2023-03-16 16:22:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(76,7492,9,40787,102487,3,68,1,208182.53,NULL,'2023-03-16 16:22:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(77,7492,9,40787,102487,3,485,1,1649.33,NULL,'2023-03-16 16:22:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(78,7492,9,40787,102487,3,484,1,1223.94,NULL,'2023-03-16 16:22:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(79,7492,9,40787,102487,3,503,1,1682.19,NULL,'2023-03-16 16:22:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(80,7492,9,40787,102487,3,166,2,806554.73,NULL,'2023-03-16 16:22:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(81,7492,9,40787,102487,3,359,2,550840.94,NULL,'2023-03-16 16:22:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(82,7492,9,40787,102487,3,507,1,29067.90,NULL,'2023-03-16 16:22:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(83,7492,9,40787,102487,3,508,1,15384.56,NULL,'2023-03-16 16:22:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(84,7492,10,40787,102487,16,496,1,22119.50,NULL,'2023-03-16 16:32:41','2023-11-05 14:01:10','2023-11-05 14:01:10'),(85,7492,10,40787,102487,16,497,1,47790.08,NULL,'2023-03-16 16:32:41','2023-11-05 14:01:10','2023-11-05 14:01:10'),(86,7492,10,40787,102487,16,208,1,43875.00,NULL,'2023-03-16 16:32:41','2023-11-05 14:01:10','2023-11-05 14:01:10'),(87,7492,10,40787,102487,16,498,1,5005.36,NULL,'2023-03-16 16:32:41','2023-11-05 14:01:10','2023-11-05 14:01:10'),(88,7492,10,40787,102487,16,508,2,14980.81,NULL,'2023-03-16 16:32:41','2023-11-05 14:01:10','2023-11-05 14:01:10'),(89,7492,10,40787,102487,16,485,2,1649.30,NULL,'2023-03-16 16:32:41','2023-11-05 14:01:10','2023-11-05 14:01:10'),(90,7492,10,40787,102487,16,252,2,41470.45,NULL,'2023-03-16 16:32:41','2023-11-05 14:01:10','2023-11-05 14:01:10'),(91,7492,10,40787,102487,16,499,2,7379.77,NULL,'2023-03-16 16:32:41','2023-11-05 14:01:10','2023-11-05 14:01:10'),(92,7492,10,40787,102487,16,497,2,19410.03,NULL,'2023-03-16 16:32:41','2023-11-05 14:01:10','2023-11-05 14:01:10'),(93,7492,10,40787,102487,16,251,2,31677.39,NULL,'2023-03-16 16:32:41','2023-11-05 14:01:10','2023-11-05 14:01:10'),(94,7492,10,40787,102487,16,498,2,2222.19,NULL,'2023-03-16 16:32:41','2023-11-05 14:01:10','2023-11-05 14:01:10'),(95,7492,11,40787,102487,15,67,1,554353.80,NULL,'2023-03-16 16:38:05','2023-03-16 16:38:50','2023-03-16 16:38:50'),(96,7492,11,40787,102487,15,68,2,208182.53,NULL,'2023-03-16 16:38:05','2023-03-16 16:38:50','2023-03-16 16:38:50'),(97,7492,11,40787,102487,15,74,2,137203.10,NULL,'2023-03-16 16:38:05','2023-03-16 16:38:50','2023-03-16 16:38:50'),(98,7492,11,40787,102487,15,484,2,1223.94,NULL,'2023-03-16 16:38:05','2023-03-16 16:38:50','2023-03-16 16:38:50'),(99,7492,11,40787,102487,15,354,2,2898.23,NULL,'2023-03-16 16:38:05','2023-03-16 16:38:50','2023-03-16 16:38:50'),(100,7492,11,40787,102487,15,359,2,204846.00,NULL,'2023-03-16 16:38:05','2023-03-16 16:38:50','2023-03-16 16:38:50'),(101,7492,12,40787,102487,15,67,1,554353.80,NULL,'2023-03-16 16:38:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(102,7492,12,40787,102487,15,68,2,208182.53,NULL,'2023-03-16 16:38:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(103,7492,12,40787,102487,15,74,2,137203.10,NULL,'2023-03-16 16:38:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(104,7492,12,40787,102487,15,484,2,1223.94,NULL,'2023-03-16 16:38:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(105,7492,12,40787,102487,15,354,2,2898.23,NULL,'2023-03-16 16:38:50','2023-11-05 14:01:10','2023-11-05 14:01:10');
INSERT INTO `balance_libro_details` VALUES (106,7492,12,40787,102487,15,509,2,204846.00,NULL,'2023-03-16 16:38:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(107,7492,13,40787,102488,2,67,2,1483902.56,NULL,'2023-03-16 16:46:53','2023-11-05 14:01:10','2023-11-05 14:01:10'),(108,7492,13,40787,102488,2,482,2,7066202.67,NULL,'2023-03-16 16:46:53','2023-11-05 14:01:10','2023-11-05 14:01:10'),(109,7492,13,40787,102488,2,14,1,8550105.23,NULL,'2023-03-16 16:46:53','2023-11-05 14:01:10','2023-11-05 14:01:10'),(110,7492,14,40787,102488,3,392,1,966296.68,NULL,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(111,7492,14,40787,102488,3,491,1,18671.49,NULL,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(112,7492,14,40787,102488,3,493,1,7486.04,NULL,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(113,7492,14,40787,102488,3,490,1,34663.42,NULL,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(114,7492,14,40787,102488,3,489,1,14002.81,NULL,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(115,7492,14,40787,102488,3,359,1,100000.00,NULL,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(116,7492,14,40787,102488,3,120,1,1950.40,NULL,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(117,7492,14,40787,102488,3,483,1,30000.00,NULL,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(118,7492,14,40787,102488,3,180,1,79190.65,NULL,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(119,7492,14,40787,102488,3,121,1,39669.44,NULL,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(120,7492,14,40787,102488,3,193,1,210000.00,NULL,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(121,7492,14,40787,102488,3,494,1,100000.00,NULL,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(122,7492,14,40787,102488,3,68,1,241116.15,NULL,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(123,7492,14,40787,102488,3,485,1,1355.69,NULL,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(124,7492,14,40787,102488,3,484,1,1487.98,NULL,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(125,7492,14,40787,102488,3,503,1,1660.74,NULL,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(126,7492,14,40787,102488,3,492,1,1238.84,NULL,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(127,7492,14,40787,102488,3,166,2,755847.12,NULL,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(128,7492,14,40787,102488,3,359,2,1092943.21,NULL,'2023-03-17 15:30:49','2023-03-17 15:33:21','2023-03-17 15:33:21'),(129,7492,15,40787,102488,3,392,1,966296.68,NULL,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10'),(130,7492,15,40787,102488,3,491,1,18671.49,NULL,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10'),(131,7492,15,40787,102488,3,493,1,7486.04,NULL,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10'),(132,7492,15,40787,102488,3,490,1,34663.42,NULL,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10'),(133,7492,15,40787,102488,3,489,1,14002.81,NULL,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10'),(134,7492,15,40787,102488,3,120,1,1950.40,NULL,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10'),(135,7492,15,40787,102488,3,483,1,30000.00,NULL,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10'),(136,7492,15,40787,102488,3,180,1,79190.65,NULL,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10'),(137,7492,15,40787,102488,3,121,1,39669.44,NULL,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10'),(138,7492,15,40787,102488,3,193,1,210000.00,NULL,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10'),(139,7492,15,40787,102488,3,494,1,100000.00,NULL,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10');
INSERT INTO `balance_libro_details` VALUES (140,7492,15,40787,102488,3,68,1,241116.15,NULL,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10'),(141,7492,15,40787,102488,3,485,1,1355.69,NULL,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10'),(142,7492,15,40787,102488,3,484,1,1487.98,NULL,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10'),(143,7492,15,40787,102488,3,503,1,1660.74,NULL,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10'),(144,7492,15,40787,102488,3,492,1,1238.84,NULL,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10'),(145,7492,15,40787,102488,3,166,2,755847.12,NULL,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10'),(146,7492,15,40787,102488,3,359,2,1092943.21,NULL,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10'),(147,7492,15,40787,102488,3,116,1,100000.00,NULL,'2023-03-17 15:33:21','2023-11-05 14:01:10','2023-11-05 14:01:10'),(148,7492,16,40787,102488,16,496,1,176655.07,NULL,'2023-03-17 15:43:34','2023-11-05 14:01:10','2023-11-05 14:01:10'),(149,7492,16,40787,102488,16,485,2,1355.69,NULL,'2023-03-17 15:43:34','2023-11-05 14:01:10','2023-11-05 14:01:10'),(150,7492,16,40787,102488,16,252,2,11908.38,NULL,'2023-03-17 15:43:34','2023-11-05 14:01:10','2023-11-05 14:01:10'),(151,7492,16,40787,102488,16,499,2,2267.85,NULL,'2023-03-17 15:43:34','2023-11-05 14:01:10','2023-11-05 14:01:10'),(152,7492,16,40787,102488,16,497,2,43910.09,NULL,'2023-03-17 15:43:34','2023-11-05 14:01:10','2023-11-05 14:01:10'),(153,7492,16,40787,102488,16,327,2,117213.06,NULL,'2023-03-17 15:43:34','2023-11-05 14:01:10','2023-11-05 14:01:10'),(154,7492,17,40787,102488,15,67,1,1483902.56,NULL,'2023-03-17 15:47:11','2023-11-05 14:01:10','2023-11-05 14:01:10'),(155,7492,17,40787,102488,15,68,2,241116.15,NULL,'2023-03-17 15:47:11','2023-11-05 14:01:10','2023-11-05 14:01:10'),(156,7492,17,40787,102488,15,74,2,1241298.43,NULL,'2023-03-17 15:47:11','2023-11-05 14:01:10','2023-11-05 14:01:10'),(157,7492,17,40787,102488,15,484,2,1487.98,NULL,'2023-03-17 15:47:11','2023-11-05 14:01:10','2023-11-05 14:01:10'),(158,7492,18,40787,102489,2,14,1,18408358.15,NULL,'2023-03-17 15:50:54','2023-11-05 14:01:10','2023-11-05 14:01:10'),(159,7492,18,40787,102489,2,67,2,3194839.02,NULL,'2023-03-17 15:50:54','2023-11-05 14:01:10','2023-11-05 14:01:10'),(160,7492,18,40787,102489,2,482,2,15213519.13,NULL,'2023-03-17 15:50:54','2023-11-05 14:01:10','2023-11-05 14:01:10'),(161,7492,19,40787,102489,3,392,1,1266319.68,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(162,7492,19,40787,102489,3,116,1,432000.00,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(163,7492,19,40787,102489,3,491,1,18671.49,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(164,7492,19,40787,102489,3,493,1,8168.73,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(165,7492,19,40787,102489,3,492,1,1238.84,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(166,7492,19,40787,102489,3,490,1,37186.41,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(167,7492,19,40787,102489,3,180,1,173338.50,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(168,7492,19,40787,102489,3,121,1,39669.44,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(169,7492,19,40787,102489,3,193,1,874700.00,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(170,7492,19,40787,102489,3,489,1,28327.37,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(171,7492,19,40787,102489,3,120,1,1363.44,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(172,7492,19,40787,102489,3,137,1,95278.09,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(173,7492,19,40787,102489,3,510,1,12396.69,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00');
INSERT INTO `balance_libro_details` VALUES (174,7492,19,40787,102489,3,359,1,4082.63,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(175,7492,19,40787,102489,3,483,1,30000.00,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(176,7492,19,40787,102489,3,384,1,22110.00,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(177,7492,19,40787,102489,3,226,1,1917.39,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(178,7492,19,40787,102489,3,484,1,1701.27,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(179,7492,19,40787,102489,3,68,1,463414.07,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(180,7492,19,40787,102489,3,166,2,2232055.07,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(181,7492,19,40787,102489,3,359,2,1279828.97,NULL,'2023-03-17 16:04:23','2023-03-17 16:08:00','2023-03-17 16:08:00'),(182,7492,20,40787,102489,3,392,1,1266319.68,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(183,7492,20,40787,102489,3,116,1,432000.00,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(184,7492,20,40787,102489,3,491,1,18671.49,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(185,7492,20,40787,102489,3,493,1,8168.73,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(186,7492,20,40787,102489,3,492,1,1238.84,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(187,7492,20,40787,102489,3,490,1,37186.41,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(188,7492,20,40787,102489,3,180,1,173338.50,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(189,7492,20,40787,102489,3,121,1,39669.44,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(190,7492,20,40787,102489,3,193,1,874700.00,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(191,7492,20,40787,102489,3,489,1,28327.37,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(192,7492,20,40787,102489,3,120,1,1363.44,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(193,7492,20,40787,102489,3,137,1,95278.09,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(194,7492,20,40787,102489,3,510,1,12396.69,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(195,7492,20,40787,102489,3,483,1,30000.00,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(196,7492,20,40787,102489,3,226,1,1917.39,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(197,7492,20,40787,102489,3,484,1,1701.27,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(198,7492,20,40787,102489,3,68,1,463414.07,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(199,7492,20,40787,102489,3,166,2,2232055.07,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(200,7492,20,40787,102489,3,359,2,1279828.97,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(201,7492,20,40787,102489,3,512,1,4082.63,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(202,7492,20,40787,102489,3,396,1,22110.00,NULL,'2023-03-17 16:08:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(203,7492,21,40787,102489,16,496,1,380337.98,NULL,'2023-03-17 16:13:28','2023-11-05 14:01:10','2023-11-05 14:01:10'),(204,7492,21,40787,102489,16,226,2,1917.39,NULL,'2023-03-17 16:13:28','2023-11-05 14:01:10','2023-11-05 14:01:10'),(205,7492,21,40787,102489,16,252,2,10588.48,NULL,'2023-03-17 16:13:28','2023-11-05 14:01:10','2023-11-05 14:01:10'),(206,7492,21,40787,102489,16,327,2,367832.11,NULL,'2023-03-17 16:13:28','2023-11-05 14:01:10','2023-11-05 14:01:10'),(207,7492,22,40787,102489,15,67,1,3194839.02,NULL,'2023-03-17 16:15:54','2023-11-05 14:01:10','2023-11-05 14:01:10');
INSERT INTO `balance_libro_details` VALUES (208,7492,22,40787,102489,15,68,2,463414.07,NULL,'2023-03-17 16:15:54','2023-11-05 14:01:10','2023-11-05 14:01:10'),(209,7492,22,40787,102489,15,74,2,2729723.68,NULL,'2023-03-17 16:15:54','2023-11-05 14:01:10','2023-11-05 14:01:10'),(210,7492,22,40787,102489,15,484,2,1701.27,NULL,'2023-03-17 16:15:54','2023-11-05 14:01:10','2023-11-05 14:01:10'),(211,7492,23,40787,102490,2,14,1,4509016.99,NULL,'2023-03-17 16:39:12','2023-11-05 14:01:10','2023-11-05 14:01:10'),(212,7492,23,40787,102490,2,67,2,782556.67,NULL,'2023-03-17 16:39:12','2023-11-05 14:01:10','2023-11-05 14:01:10'),(213,7492,23,40787,102490,2,482,2,3726460.32,NULL,'2023-03-17 16:39:12','2023-11-05 14:01:10','2023-11-05 14:01:10'),(214,7492,24,40787,102490,3,392,1,2788261.37,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(215,7492,24,40787,102490,3,116,1,123500.00,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(216,7492,24,40787,102490,3,491,1,20824.43,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(217,7492,24,40787,102490,3,199,1,10865.87,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(218,7492,24,40787,102490,3,492,1,1610.74,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(219,7492,24,40787,102490,3,490,1,32681.69,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(220,7492,24,40787,102490,3,180,1,63119.85,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(221,7492,24,40787,102490,3,193,1,250000.00,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(222,7492,24,40787,102490,3,359,1,228305.70,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(223,7492,24,40787,102490,3,137,1,130590.80,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(224,7492,24,40787,102490,3,384,1,82811.71,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(225,7492,24,40787,102490,3,489,1,11935.03,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(226,7492,24,40787,102490,3,483,1,37500.00,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(227,7492,24,40787,102490,3,495,1,7438.02,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(228,7492,24,40787,102490,3,503,1,4433.78,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(229,7492,24,40787,102490,3,396,1,41378.00,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(230,7492,24,40787,102490,3,226,1,6607.22,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(231,7492,24,40787,102490,3,396,1,41378.00,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(232,7492,24,40787,102490,3,484,1,1998.74,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(233,7492,24,40787,102490,3,68,1,680890.03,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(234,7492,24,40787,102490,3,166,2,3802998.95,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(235,7492,24,40787,102490,3,359,2,763132.03,NULL,'2023-03-17 16:57:08','2023-03-17 21:52:49','2023-03-17 21:52:49'),(236,7492,25,40787,102490,3,392,1,2788261.37,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(237,7492,25,40787,102490,3,116,1,123500.00,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(238,7492,25,40787,102490,3,491,1,20824.43,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(239,7492,25,40787,102490,3,199,1,10865.87,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(240,7492,25,40787,102490,3,492,1,1610.74,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(241,7492,25,40787,102490,3,490,1,32681.69,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10');
INSERT INTO `balance_libro_details` VALUES (242,7492,25,40787,102490,3,180,1,63119.85,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(243,7492,25,40787,102490,3,193,1,250000.00,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(244,7492,25,40787,102490,3,137,1,130590.80,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(245,7492,25,40787,102490,3,489,1,11935.03,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(246,7492,25,40787,102490,3,483,1,37500.00,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(247,7492,25,40787,102490,3,495,1,7438.02,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(248,7492,25,40787,102490,3,503,1,4433.78,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(249,7492,25,40787,102490,3,396,1,41378.00,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(250,7492,25,40787,102490,3,226,1,6607.22,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(251,7492,25,40787,102490,3,396,1,41378.00,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(252,7492,25,40787,102490,3,484,1,1998.74,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(253,7492,25,40787,102490,3,68,1,680890.03,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(254,7492,25,40787,102490,3,166,2,3802998.95,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(255,7492,25,40787,102490,3,359,2,763132.03,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(256,7492,25,40787,102490,3,193,1,228305.70,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(257,7492,25,40787,102490,3,507,1,82811.71,NULL,'2023-03-17 21:52:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(258,7492,26,40787,102490,16,496,1,51122.67,NULL,'2023-03-20 15:37:28','2023-11-05 14:01:10','2023-11-05 14:01:10'),(259,7492,26,40787,102490,16,485,2,6607.22,NULL,'2023-03-20 15:37:28','2023-11-05 14:01:10','2023-11-05 14:01:10'),(260,7492,26,40787,102490,16,499,2,19240.42,NULL,'2023-03-20 15:37:28','2023-11-05 14:01:10','2023-11-05 14:01:10'),(261,7492,26,40787,102490,16,327,2,25275.03,NULL,'2023-03-20 15:37:28','2023-11-05 14:01:10','2023-11-05 14:01:10'),(262,7492,27,40787,102490,15,67,1,782556.67,NULL,'2023-03-20 15:42:35','2023-03-20 17:49:21','2023-03-20 17:49:21'),(263,7492,27,40787,102490,15,68,2,680890.03,NULL,'2023-03-20 15:42:35','2023-03-20 17:49:21','2023-03-20 17:49:21'),(264,7492,27,40787,102490,15,359,2,353126.26,NULL,'2023-03-20 15:42:35','2023-03-20 17:49:21','2023-03-20 17:49:21'),(265,7492,27,40787,102490,15,384,1,251459.62,NULL,'2023-03-20 15:42:35','2023-03-20 17:49:21','2023-03-20 17:49:21'),(266,7492,27,40787,102490,15,477,1,1998.74,NULL,'2023-03-20 15:42:35','2023-03-20 17:49:21','2023-03-20 17:49:21'),(267,7492,27,40787,102490,15,484,2,1998.74,NULL,'2023-03-20 15:42:35','2023-03-20 17:49:21','2023-03-20 17:49:21'),(268,7492,28,40787,102491,2,14,1,8300712.32,NULL,'2023-03-20 15:45:04','2023-03-20 22:21:03','2023-03-20 22:21:03'),(269,7492,28,40787,102491,2,67,2,1440619.41,NULL,'2023-03-20 15:45:04','2023-03-20 22:21:03','2023-03-20 22:21:03'),(270,7492,28,40787,102491,2,482,2,6860092.91,NULL,'2023-03-20 15:45:04','2023-03-20 22:21:03','2023-03-20 22:21:03'),(271,7492,29,40787,102491,3,392,1,819913.83,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(272,7492,29,40787,102491,3,116,1,123500.00,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(273,7492,29,40787,102491,3,491,1,20824.43,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(274,7492,29,40787,102491,3,493,1,7672.27,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(275,7492,29,40787,102491,3,492,1,16695.94,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28');
INSERT INTO `balance_libro_details` VALUES (276,7492,29,40787,102491,3,490,1,62487.02,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(277,7492,29,40787,102491,3,180,1,41015.75,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(278,7492,29,40787,102491,3,121,1,46281.04,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(279,7492,29,40787,102491,3,193,1,200000.00,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(280,7492,29,40787,102491,3,489,1,41006.39,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(281,7492,29,40787,102491,3,494,1,85000.00,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(282,7492,29,40787,102491,3,137,1,2006337.20,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(283,7492,29,40787,102491,3,507,1,273491.65,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(284,7492,29,40787,102491,3,359,1,17436.36,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(285,7492,29,40787,102491,3,495,1,3719.01,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(286,7492,29,40787,102491,3,483,1,43000.00,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(287,7492,29,40787,102491,3,120,1,6603.33,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(288,7492,29,40787,102491,3,503,1,3993.69,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(289,7492,29,40787,102491,3,226,1,2521.54,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(290,7492,29,40787,102491,3,484,1,4878.27,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(291,7492,29,40787,102491,3,68,1,726772.02,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(292,7492,29,40787,102491,3,166,2,4553149.74,NULL,'2023-03-20 15:57:30','2023-03-20 17:53:28','2023-03-20 17:53:28'),(293,7492,30,40787,102491,16,496,1,171502.32,NULL,'2023-03-20 16:05:18','2023-03-20 16:11:01','2023-03-20 16:11:01'),(294,7492,30,40787,102491,16,226,2,2521.54,NULL,'2023-03-20 16:05:18','2023-03-20 16:11:01','2023-03-20 16:11:01'),(295,7492,30,40787,102491,16,359,2,41688.24,NULL,'2023-03-20 16:05:18','2023-03-20 16:11:01','2023-03-20 16:11:01'),(296,7492,30,40787,102491,16,499,2,48464.31,NULL,'2023-03-20 16:05:18','2023-03-20 16:11:01','2023-03-20 16:11:01'),(297,7492,30,40787,102491,16,384,2,1606.50,NULL,'2023-03-20 16:05:18','2023-03-20 16:11:01','2023-03-20 16:11:01'),(298,7492,30,40787,102491,16,327,2,77221.73,NULL,'2023-03-20 16:05:18','2023-03-20 16:11:01','2023-03-20 16:11:01'),(299,7492,31,40787,102491,15,67,1,1440619.51,NULL,'2023-03-20 16:09:50','2023-03-20 17:57:25','2023-03-20 17:57:25'),(300,7492,31,40787,102491,15,68,2,726772.02,NULL,'2023-03-20 16:09:50','2023-03-20 17:57:25','2023-03-20 17:57:25'),(301,7492,31,40787,102491,15,74,2,455510.86,NULL,'2023-03-20 16:09:50','2023-03-20 17:57:25','2023-03-20 17:57:25'),(302,7492,31,40787,102491,15,509,2,251459.62,NULL,'2023-03-20 16:09:50','2023-03-20 17:57:25','2023-03-20 17:57:25'),(303,7492,31,40787,102491,15,359,2,1998.74,NULL,'2023-03-20 16:09:50','2023-03-20 17:57:25','2023-03-20 17:57:25'),(304,7492,31,40787,102491,15,484,2,4878.27,NULL,'2023-03-20 16:09:50','2023-03-20 17:57:25','2023-03-20 17:57:25'),(305,7492,32,40787,102491,16,496,1,171502.32,NULL,'2023-03-20 16:11:01','2023-03-20 17:55:52','2023-03-20 17:55:52'),(306,7492,32,40787,102491,16,226,2,2521.54,NULL,'2023-03-20 16:11:01','2023-03-20 17:55:52','2023-03-20 17:55:52'),(307,7492,32,40787,102491,16,359,2,41688.24,NULL,'2023-03-20 16:11:01','2023-03-20 17:55:52','2023-03-20 17:55:52'),(308,7492,32,40787,102491,16,499,2,48464.31,NULL,'2023-03-20 16:11:01','2023-03-20 17:55:52','2023-03-20 17:55:52'),(309,7492,32,40787,102491,16,384,2,1606.50,NULL,'2023-03-20 16:11:01','2023-03-20 17:55:52','2023-03-20 17:55:52');
INSERT INTO `balance_libro_details` VALUES (310,7492,32,40787,102491,16,327,2,77221.73,NULL,'2023-03-20 16:11:01','2023-03-20 17:55:52','2023-03-20 17:55:52'),(311,7492,33,40787,102492,2,14,1,14800064.02,NULL,'2023-03-20 16:15:59','2023-03-20 22:22:20','2023-03-20 22:22:20'),(312,7492,33,40787,102492,2,67,2,2568606.15,NULL,'2023-03-20 16:15:59','2023-03-20 22:22:20','2023-03-20 22:22:20'),(313,7492,33,40787,102492,2,482,2,12231457.87,NULL,'2023-03-20 16:15:59','2023-03-20 22:22:20','2023-03-20 22:22:20'),(314,7492,34,40787,102492,3,392,1,1288951.72,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(315,7492,34,40787,102492,3,507,1,165218.25,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(316,7492,34,40787,102492,3,137,1,19403.52,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(317,7492,34,40787,102492,3,359,1,89140.29,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(318,7492,34,40787,102492,3,180,1,234361.15,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(319,7492,34,40787,102492,3,491,1,22261.54,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(320,7492,34,40787,102492,3,493,1,8676.23,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(321,7492,34,40787,102492,3,492,1,1610.74,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(322,7492,34,40787,102492,3,490,1,86132.74,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(323,7492,34,40787,102492,3,489,1,48693.74,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(324,7492,34,40787,102492,3,495,1,3719.01,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(325,7492,34,40787,102492,3,120,1,5157.00,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(326,7492,34,40787,102492,3,494,1,285000.00,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(327,7492,34,40787,102492,3,483,1,52500.00,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(328,7492,34,40787,102492,3,68,1,439854.25,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(329,7492,34,40787,102492,3,226,1,3756.29,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(330,7492,34,40787,102492,3,193,1,200000.00,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(331,7492,34,40787,102492,3,484,1,5507.30,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(332,7492,34,40787,102492,3,396,1,119800.00,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(333,7492,34,40787,102492,3,501,1,75371.90,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(334,7492,34,40787,102492,3,503,1,1397.19,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(335,7492,34,40787,102492,3,166,2,2929487.63,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(336,7492,34,40787,102492,3,359,2,227025.23,NULL,'2023-03-20 16:28:58','2023-03-20 17:52:06','2023-03-20 17:52:06'),(337,7492,35,40787,102492,16,496,1,281792.88,NULL,'2023-03-20 16:38:35','2023-03-20 18:00:40','2023-03-20 18:00:40'),(338,7492,35,40787,102492,16,226,2,3756.29,NULL,'2023-03-20 16:38:35','2023-03-20 18:00:40','2023-03-20 18:00:40'),(339,7492,35,40787,102492,16,499,2,39595.11,NULL,'2023-03-20 16:38:35','2023-03-20 18:00:40','2023-03-20 18:00:40'),(340,7492,35,40787,102492,16,252,2,43212.05,NULL,'2023-03-20 16:38:35','2023-03-20 18:00:40','2023-03-20 18:00:40'),(341,7492,35,40787,102492,16,327,2,195229.43,NULL,'2023-03-20 16:38:35','2023-03-20 18:00:40','2023-03-20 18:00:40'),(342,7492,35,40787,102492,16,208,1,23993.57,NULL,'2023-03-20 16:38:35','2023-03-20 18:00:40','2023-03-20 18:00:40'),(343,7492,35,40787,102492,16,359,2,5005.36,NULL,'2023-03-20 16:38:35','2023-03-20 18:00:40','2023-03-20 18:00:40');
INSERT INTO `balance_libro_details` VALUES (344,7492,35,40787,102492,16,326,2,18988.21,NULL,'2023-03-20 16:38:35','2023-03-20 18:00:40','2023-03-20 18:00:40'),(345,7492,36,40787,102492,15,67,1,2568606.15,NULL,'2023-03-20 16:41:23','2023-03-20 22:23:08','2023-03-20 22:23:08'),(346,7492,36,40787,102492,15,68,2,439854.25,NULL,'2023-03-20 16:41:23','2023-03-20 22:23:08','2023-03-20 22:23:08'),(347,7492,36,40787,102492,15,74,2,2123244.60,NULL,'2023-03-20 16:41:23','2023-03-20 22:23:08','2023-03-20 22:23:08'),(348,7492,36,40787,102492,15,484,2,5507.30,NULL,'2023-03-20 16:41:23','2023-03-20 22:23:08','2023-03-20 22:23:08'),(349,7492,37,40787,102490,15,67,1,782556.67,NULL,'2023-03-20 17:49:21','2023-03-20 22:20:35','2023-03-20 22:20:35'),(350,7492,37,40787,102490,15,484,2,1998.74,NULL,'2023-03-20 17:49:21','2023-03-20 22:20:35','2023-03-20 22:20:35'),(351,7492,37,40787,102490,15,68,2,1034016.29,NULL,'2023-03-20 17:49:21','2023-03-20 22:20:35','2023-03-20 22:20:35'),(352,7492,37,40787,102490,15,353,1,251459.62,NULL,'2023-03-20 17:49:21','2023-03-20 22:20:35','2023-03-20 22:20:35'),(353,7492,37,40787,102490,15,354,1,1998.74,NULL,'2023-03-20 17:49:21','2023-03-20 22:20:35','2023-03-20 22:20:35'),(354,7492,38,40787,102492,3,392,1,1288951.72,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(355,7492,38,40787,102492,3,507,1,165218.25,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(356,7492,38,40787,102492,3,137,1,19403.52,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(357,7492,38,40787,102492,3,359,1,89140.29,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(358,7492,38,40787,102492,3,180,1,234361.15,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(359,7492,38,40787,102492,3,491,1,22261.54,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(360,7492,38,40787,102492,3,493,1,8676.23,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(361,7492,38,40787,102492,3,492,1,1610.74,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(362,7492,38,40787,102492,3,490,1,86132.74,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(363,7492,38,40787,102492,3,489,1,48693.74,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(364,7492,38,40787,102492,3,495,1,3719.01,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(365,7492,38,40787,102492,3,120,1,5157.00,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(366,7492,38,40787,102492,3,494,1,285000.00,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(367,7492,38,40787,102492,3,483,1,52500.00,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(368,7492,38,40787,102492,3,68,1,439854.25,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(369,7492,38,40787,102492,3,226,1,3756.29,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(370,7492,38,40787,102492,3,193,1,200000.00,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(371,7492,38,40787,102492,3,484,1,5507.30,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(372,7492,38,40787,102492,3,396,1,119800.00,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(373,7492,38,40787,102492,3,501,1,75371.90,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(374,7492,38,40787,102492,3,503,1,1397.19,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(375,7492,38,40787,102492,3,166,2,2929487.63,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(376,7492,38,40787,102492,3,359,2,227025.23,NULL,'2023-03-20 17:52:06','2023-03-20 17:58:53','2023-03-20 17:58:53'),(377,7492,39,40787,102491,3,392,1,819913.83,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35');
INSERT INTO `balance_libro_details` VALUES (378,7492,39,40787,102491,3,116,1,123500.00,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(379,7492,39,40787,102491,3,491,1,20824.43,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(380,7492,39,40787,102491,3,493,1,7672.27,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(381,7492,39,40787,102491,3,492,1,16695.94,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(382,7492,39,40787,102491,3,490,1,62487.02,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(383,7492,39,40787,102491,3,180,1,41015.75,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(384,7492,39,40787,102491,3,121,1,46281.04,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(385,7492,39,40787,102491,3,193,1,200000.00,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(386,7492,39,40787,102491,3,489,1,41006.39,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(387,7492,39,40787,102491,3,494,1,85000.00,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(388,7492,39,40787,102491,3,137,1,2006337.20,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(389,7492,39,40787,102491,3,507,1,290928.01,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(390,7492,39,40787,102491,3,495,1,3719.01,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(391,7492,39,40787,102491,3,483,1,43000.00,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(392,7492,39,40787,102491,3,120,1,6603.33,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(393,7492,39,40787,102491,3,503,1,3993.69,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(394,7492,39,40787,102491,3,226,1,2521.54,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(395,7492,39,40787,102491,3,484,1,4878.27,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(396,7492,39,40787,102491,3,68,1,726772.02,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(397,7492,39,40787,102491,3,166,2,4553149.74,NULL,'2023-03-20 17:53:28','2023-03-20 21:57:35','2023-03-20 21:57:35'),(398,7492,40,40787,102491,16,496,1,171502.32,NULL,'2023-03-20 17:55:52','2023-03-20 22:21:41','2023-03-20 22:21:41'),(399,7492,40,40787,102491,16,226,2,2521.54,NULL,'2023-03-20 17:55:52','2023-03-20 22:21:41','2023-03-20 22:21:41'),(400,7492,40,40787,102491,16,499,2,48464.31,NULL,'2023-03-20 17:55:52','2023-03-20 22:21:41','2023-03-20 22:21:41'),(401,7492,40,40787,102491,16,327,2,77221.73,NULL,'2023-03-20 17:55:52','2023-03-20 22:21:41','2023-03-20 22:21:41'),(402,7492,40,40787,102491,16,252,2,41688.24,NULL,'2023-03-20 17:55:52','2023-03-20 22:21:41','2023-03-20 22:21:41'),(403,7492,40,40787,102491,16,226,2,1606.50,NULL,'2023-03-20 17:55:52','2023-03-20 22:21:41','2023-03-20 22:21:41'),(404,7492,41,40787,102491,15,67,1,1440619.51,NULL,'2023-03-20 17:57:25','2023-03-20 22:21:59','2023-03-20 22:21:59'),(405,7492,41,40787,102491,15,68,2,726772.02,NULL,'2023-03-20 17:57:25','2023-03-20 22:21:59','2023-03-20 22:21:59'),(406,7492,41,40787,102491,15,74,2,455510.86,NULL,'2023-03-20 17:57:25','2023-03-20 22:21:59','2023-03-20 22:21:59'),(407,7492,41,40787,102491,15,509,2,251459.62,NULL,'2023-03-20 17:57:25','2023-03-20 22:21:59','2023-03-20 22:21:59'),(408,7492,41,40787,102491,15,484,2,4878.27,NULL,'2023-03-20 17:57:25','2023-03-20 22:21:59','2023-03-20 22:21:59'),(409,7492,41,40787,102491,15,354,2,1998.74,NULL,'2023-03-20 17:57:25','2023-03-20 22:21:59','2023-03-20 22:21:59'),(410,7492,42,40787,102492,3,392,1,1288951.72,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(411,7492,42,40787,102492,3,507,1,165218.25,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38');
INSERT INTO `balance_libro_details` VALUES (412,7492,42,40787,102492,3,137,1,19403.52,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(413,7492,42,40787,102492,3,180,1,234361.15,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(414,7492,42,40787,102492,3,491,1,22261.54,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(415,7492,42,40787,102492,3,493,1,8676.23,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(416,7492,42,40787,102492,3,492,1,1610.74,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(417,7492,42,40787,102492,3,490,1,86132.74,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(418,7492,42,40787,102492,3,489,1,48693.74,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(419,7492,42,40787,102492,3,495,1,3719.01,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(420,7492,42,40787,102492,3,120,1,5157.00,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(421,7492,42,40787,102492,3,494,1,285000.00,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(422,7492,42,40787,102492,3,483,1,52500.00,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(423,7492,42,40787,102492,3,68,1,439854.25,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(424,7492,42,40787,102492,3,226,1,3756.29,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(425,7492,42,40787,102492,3,193,1,200000.00,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(426,7492,42,40787,102492,3,484,1,5507.30,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(427,7492,42,40787,102492,3,396,1,119800.00,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(428,7492,42,40787,102492,3,501,1,75371.90,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(429,7492,42,40787,102492,3,503,1,1397.19,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(430,7492,42,40787,102492,3,166,2,2929487.63,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(431,7492,42,40787,102492,3,359,2,227025.23,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(432,7492,42,40787,102492,3,363,1,89140.29,NULL,'2023-03-20 17:58:53','2023-03-20 22:22:38','2023-03-20 22:22:38'),(433,7492,43,40787,102492,16,496,1,281792.88,NULL,'2023-03-20 18:00:40','2023-03-20 22:22:54','2023-03-20 22:22:54'),(434,7492,43,40787,102492,16,226,2,3756.29,NULL,'2023-03-20 18:00:40','2023-03-20 22:22:54','2023-03-20 22:22:54'),(435,7492,43,40787,102492,16,499,2,39595.11,NULL,'2023-03-20 18:00:40','2023-03-20 22:22:54','2023-03-20 22:22:54'),(436,7492,43,40787,102492,16,252,2,43212.05,NULL,'2023-03-20 18:00:40','2023-03-20 22:22:54','2023-03-20 22:22:54'),(437,7492,43,40787,102492,16,327,2,195229.43,NULL,'2023-03-20 18:00:40','2023-03-20 22:22:54','2023-03-20 22:22:54'),(438,7492,43,40787,102492,16,208,1,23993.57,NULL,'2023-03-20 18:00:40','2023-03-20 22:22:54','2023-03-20 22:22:54'),(439,7492,43,40787,102492,16,326,2,18988.21,NULL,'2023-03-20 18:00:40','2023-03-20 22:22:54','2023-03-20 22:22:54'),(440,7492,43,40787,102492,16,498,2,5005.36,NULL,'2023-03-20 18:00:40','2023-03-20 22:22:54','2023-03-20 22:22:54'),(441,7492,44,40787,102491,3,392,1,819913.83,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(442,7492,44,40787,102491,3,116,1,123500.00,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(443,7492,44,40787,102491,3,491,1,20824.43,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(444,7492,44,40787,102491,3,493,1,7672.27,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(445,7492,44,40787,102491,3,492,1,16695.94,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27');
INSERT INTO `balance_libro_details` VALUES (446,7492,44,40787,102491,3,490,1,62487.02,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(447,7492,44,40787,102491,3,180,1,41015.75,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(448,7492,44,40787,102491,3,121,1,46281.04,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(449,7492,44,40787,102491,3,193,1,200000.00,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(450,7492,44,40787,102491,3,489,1,41006.39,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(451,7492,44,40787,102491,3,494,1,85000.00,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(452,7492,44,40787,102491,3,137,1,2006337.20,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(453,7492,44,40787,102491,3,507,1,273491.65,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(454,7492,44,40787,102491,3,495,1,3719.01,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(455,7492,44,40787,102491,3,483,1,43000.00,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(456,7492,44,40787,102491,3,120,1,6603.33,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(457,7492,44,40787,102491,3,503,1,3993.69,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(458,7492,44,40787,102491,3,226,1,2521.54,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(459,7492,44,40787,102491,3,484,1,4878.27,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(460,7492,44,40787,102491,3,68,1,726772.02,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(461,7492,44,40787,102491,3,166,2,4553149.74,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(462,7492,44,40787,102491,3,363,1,17436.36,NULL,'2023-03-20 21:57:35','2023-03-20 22:21:27','2023-03-20 22:21:27'),(463,7492,45,40787,102490,15,67,1,782556.67,NULL,'2023-03-20 22:20:35','2023-11-05 14:01:10','2023-11-05 14:01:10'),(464,7492,45,40787,102490,15,484,2,1998.74,NULL,'2023-03-20 22:20:35','2023-11-05 14:01:10','2023-11-05 14:01:10'),(465,7492,45,40787,102490,15,68,2,1034016.29,NULL,'2023-03-20 22:20:35','2023-11-05 14:01:10','2023-11-05 14:01:10'),(466,7492,45,40787,102490,15,353,1,251459.62,NULL,'2023-03-20 22:20:35','2023-11-05 14:01:10','2023-11-05 14:01:10'),(467,7492,45,40787,102490,15,354,1,1998.74,NULL,'2023-03-20 22:20:35','2023-11-05 14:01:10','2023-11-05 14:01:10'),(468,7492,46,40787,102491,2,14,1,8300712.32,NULL,'2023-03-20 22:21:03','2023-11-05 14:01:10','2023-11-05 14:01:10'),(469,7492,46,40787,102491,2,67,2,1440619.41,NULL,'2023-03-20 22:21:03','2023-11-05 14:01:10','2023-11-05 14:01:10'),(470,7492,46,40787,102491,2,482,2,6860092.91,NULL,'2023-03-20 22:21:03','2023-11-05 14:01:10','2023-11-05 14:01:10'),(471,7492,47,40787,102491,3,392,1,819913.83,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(472,7492,47,40787,102491,3,116,1,123500.00,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(473,7492,47,40787,102491,3,491,1,20824.43,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(474,7492,47,40787,102491,3,493,1,7672.27,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(475,7492,47,40787,102491,3,492,1,16695.94,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(476,7492,47,40787,102491,3,490,1,62487.02,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(477,7492,47,40787,102491,3,180,1,41015.75,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(478,7492,47,40787,102491,3,121,1,46281.04,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(479,7492,47,40787,102491,3,193,1,200000.00,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10');
INSERT INTO `balance_libro_details` VALUES (480,7492,47,40787,102491,3,489,1,41006.39,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(481,7492,47,40787,102491,3,494,1,85000.00,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(482,7492,47,40787,102491,3,137,1,2006337.20,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(483,7492,47,40787,102491,3,507,1,273491.65,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(484,7492,47,40787,102491,3,495,1,3719.01,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(485,7492,47,40787,102491,3,483,1,43000.00,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(486,7492,47,40787,102491,3,120,1,6603.33,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(487,7492,47,40787,102491,3,503,1,3993.69,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(488,7492,47,40787,102491,3,226,1,2521.54,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(489,7492,47,40787,102491,3,484,1,4878.27,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(490,7492,47,40787,102491,3,68,1,726772.02,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(491,7492,47,40787,102491,3,166,2,4553149.74,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(492,7492,47,40787,102491,3,363,1,17436.36,NULL,'2023-03-20 22:21:27','2023-11-05 14:01:10','2023-11-05 14:01:10'),(493,7492,48,40787,102491,16,496,1,171502.32,NULL,'2023-03-20 22:21:41','2023-11-05 14:01:10','2023-11-05 14:01:10'),(494,7492,48,40787,102491,16,226,2,2521.54,NULL,'2023-03-20 22:21:41','2023-11-05 14:01:10','2023-11-05 14:01:10'),(495,7492,48,40787,102491,16,499,2,48464.31,NULL,'2023-03-20 22:21:41','2023-11-05 14:01:10','2023-11-05 14:01:10'),(496,7492,48,40787,102491,16,327,2,77221.73,NULL,'2023-03-20 22:21:41','2023-11-05 14:01:10','2023-11-05 14:01:10'),(497,7492,48,40787,102491,16,252,2,41688.24,NULL,'2023-03-20 22:21:41','2023-11-05 14:01:10','2023-11-05 14:01:10'),(498,7492,48,40787,102491,16,226,2,1606.50,NULL,'2023-03-20 22:21:41','2023-11-05 14:01:10','2023-11-05 14:01:10'),(499,7492,49,40787,102491,15,67,1,1440619.51,NULL,'2023-03-20 22:21:59','2023-11-05 14:01:10','2023-11-05 14:01:10'),(500,7492,49,40787,102491,15,68,2,726772.02,NULL,'2023-03-20 22:21:59','2023-11-05 14:01:10','2023-11-05 14:01:10'),(501,7492,49,40787,102491,15,74,2,455510.86,NULL,'2023-03-20 22:21:59','2023-11-05 14:01:10','2023-11-05 14:01:10'),(502,7492,49,40787,102491,15,509,2,251459.62,NULL,'2023-03-20 22:21:59','2023-11-05 14:01:10','2023-11-05 14:01:10'),(503,7492,49,40787,102491,15,484,2,4878.27,NULL,'2023-03-20 22:21:59','2023-11-05 14:01:10','2023-11-05 14:01:10'),(504,7492,49,40787,102491,15,354,2,1998.74,NULL,'2023-03-20 22:21:59','2023-11-05 14:01:10','2023-11-05 14:01:10'),(505,7492,50,40787,102492,2,14,1,14800064.02,NULL,'2023-03-20 22:22:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(506,7492,50,40787,102492,2,67,2,2568606.15,NULL,'2023-03-20 22:22:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(507,7492,50,40787,102492,2,482,2,12231457.87,NULL,'2023-03-20 22:22:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(508,7492,51,40787,102492,3,392,1,1288951.72,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(509,7492,51,40787,102492,3,507,1,165218.25,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(510,7492,51,40787,102492,3,137,1,19403.52,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(511,7492,51,40787,102492,3,180,1,234361.15,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(512,7492,51,40787,102492,3,491,1,22261.54,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(513,7492,51,40787,102492,3,493,1,8676.23,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10');
INSERT INTO `balance_libro_details` VALUES (514,7492,51,40787,102492,3,492,1,1610.74,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(515,7492,51,40787,102492,3,490,1,86132.74,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(516,7492,51,40787,102492,3,489,1,48693.74,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(517,7492,51,40787,102492,3,495,1,3719.01,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(518,7492,51,40787,102492,3,120,1,5157.00,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(519,7492,51,40787,102492,3,494,1,285000.00,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(520,7492,51,40787,102492,3,483,1,52500.00,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(521,7492,51,40787,102492,3,68,1,439854.25,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(522,7492,51,40787,102492,3,226,1,3756.29,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(523,7492,51,40787,102492,3,193,1,200000.00,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(524,7492,51,40787,102492,3,484,1,5507.30,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(525,7492,51,40787,102492,3,396,1,119800.00,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(526,7492,51,40787,102492,3,501,1,75371.90,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(527,7492,51,40787,102492,3,503,1,1397.19,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(528,7492,51,40787,102492,3,166,2,2929487.63,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(529,7492,51,40787,102492,3,359,2,227025.23,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(530,7492,51,40787,102492,3,363,1,89140.29,NULL,'2023-03-20 22:22:38','2023-11-05 14:01:10','2023-11-05 14:01:10'),(531,7492,52,40787,102492,16,496,1,281792.88,NULL,'2023-03-20 22:22:54','2023-11-05 14:01:10','2023-11-05 14:01:10'),(532,7492,52,40787,102492,16,226,2,3756.29,NULL,'2023-03-20 22:22:54','2023-11-05 14:01:10','2023-11-05 14:01:10'),(533,7492,52,40787,102492,16,499,2,39595.11,NULL,'2023-03-20 22:22:54','2023-11-05 14:01:10','2023-11-05 14:01:10'),(534,7492,52,40787,102492,16,252,2,43212.05,NULL,'2023-03-20 22:22:54','2023-11-05 14:01:10','2023-11-05 14:01:10'),(535,7492,52,40787,102492,16,327,2,195229.43,NULL,'2023-03-20 22:22:54','2023-11-05 14:01:10','2023-11-05 14:01:10'),(536,7492,52,40787,102492,16,208,1,23993.57,NULL,'2023-03-20 22:22:54','2023-11-05 14:01:10','2023-11-05 14:01:10'),(537,7492,52,40787,102492,16,326,2,18988.21,NULL,'2023-03-20 22:22:54','2023-11-05 14:01:10','2023-11-05 14:01:10'),(538,7492,52,40787,102492,16,498,2,5005.36,NULL,'2023-03-20 22:22:54','2023-11-05 14:01:10','2023-11-05 14:01:10'),(539,7492,53,40787,102492,15,67,1,2568606.15,NULL,'2023-03-20 22:23:08','2023-11-05 14:01:10','2023-11-05 14:01:10'),(540,7492,53,40787,102492,15,68,2,439854.25,NULL,'2023-03-20 22:23:08','2023-11-05 14:01:10','2023-11-05 14:01:10'),(541,7492,53,40787,102492,15,74,2,2123244.60,NULL,'2023-03-20 22:23:08','2023-11-05 14:01:10','2023-11-05 14:01:10'),(542,7492,53,40787,102492,15,484,2,5507.30,NULL,'2023-03-20 22:23:08','2023-11-05 14:01:10','2023-11-05 14:01:10'),(543,7492,54,40787,102494,2,14,1,7327235.31,NULL,'2023-03-21 15:26:11','2023-11-05 14:01:10','2023-11-05 14:01:10'),(544,7492,54,40787,102494,2,67,2,1271668.94,NULL,'2023-03-21 15:26:11','2023-11-05 14:01:10','2023-11-05 14:01:10'),(545,7492,54,40787,102494,2,482,2,6055566.37,NULL,'2023-03-21 15:26:11','2023-11-05 14:01:10','2023-11-05 14:01:10'),(546,7492,55,40787,102494,3,392,1,3430889.08,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(547,7492,55,40787,102494,3,491,1,23797.29,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18');
INSERT INTO `balance_libro_details` VALUES (548,7492,55,40787,102494,3,493,1,5313.21,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(549,7492,55,40787,102494,3,359,1,909.90,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(550,7492,55,40787,102494,3,492,1,9090.90,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(551,7492,55,40787,102494,3,490,1,69765.69,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(552,7492,55,40787,102494,3,512,1,5223.13,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(553,7492,55,40787,102494,3,495,1,3719.01,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(554,7492,55,40787,102494,3,120,1,2330.57,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(555,7492,55,40787,102494,3,489,1,23081.92,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(556,7492,55,40787,102494,3,193,1,135000.00,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(557,7492,55,40787,102494,3,180,1,51397.90,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(558,7492,55,40787,102494,3,483,1,57000.00,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(559,7492,55,40787,102494,3,384,1,48609.33,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(560,7492,55,40787,102494,3,116,1,123500.00,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(561,7492,55,40787,102494,3,507,1,74537.44,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(562,7492,55,40787,102494,3,137,1,115055.40,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(563,7492,55,40787,102494,3,68,1,806461.39,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(564,7492,55,40787,102494,3,485,1,4196.39,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(565,7492,55,40787,102494,3,508,1,1498.71,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(566,7492,55,40787,102494,3,484,1,2830.28,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(567,7492,55,40787,102494,3,503,1,2734.75,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(568,7492,55,40787,102494,3,165,2,4996942.29,NULL,'2023-03-21 15:41:10','2023-03-22 14:20:18','2023-03-22 14:20:18'),(569,7492,56,40787,102494,16,496,1,151389.16,NULL,'2023-03-21 15:48:37','2023-03-22 15:52:35','2023-03-22 15:52:35'),(570,7492,56,40787,102494,16,226,2,4196.39,NULL,'2023-03-21 15:48:37','2023-03-22 15:52:35','2023-03-22 15:52:35'),(571,7492,56,40787,102494,16,252,2,54644.35,NULL,'2023-03-21 15:48:37','2023-03-22 15:52:35','2023-03-22 15:52:35'),(572,7492,56,40787,102494,16,499,2,41310.04,NULL,'2023-03-21 15:48:37','2023-03-22 15:52:35','2023-03-22 15:52:35'),(573,7492,56,40787,102494,16,327,2,51238.38,NULL,'2023-03-21 15:48:37','2023-03-22 15:52:35','2023-03-22 15:52:35'),(574,7492,56,40787,102494,16,225,2,1498.71,NULL,'2023-03-21 15:48:37','2023-03-22 15:52:35','2023-03-22 15:52:35'),(575,7492,56,40787,102494,16,498,1,1498.71,NULL,'2023-03-21 15:48:37','2023-03-22 15:52:35','2023-03-22 15:52:35'),(576,7492,57,40787,102494,15,67,1,1271668.94,NULL,'2023-03-21 15:50:44','2023-03-22 15:52:52','2023-03-22 15:52:52'),(577,7492,57,40787,102494,15,68,2,806461.39,NULL,'2023-03-21 15:50:44','2023-03-22 15:52:52','2023-03-22 15:52:52'),(578,7492,57,40787,102494,15,74,2,462377.27,NULL,'2023-03-21 15:50:44','2023-03-22 15:52:52','2023-03-22 15:52:52'),(579,7492,57,40787,102494,15,484,2,2830.28,NULL,'2023-03-21 15:50:44','2023-03-22 15:52:52','2023-03-22 15:52:52'),(580,7492,58,40787,102495,2,14,1,7248764.35,NULL,'2023-03-21 15:52:45','2023-03-22 15:53:05','2023-03-22 15:53:05'),(581,7492,58,40787,102495,2,67,2,1258050.01,NULL,'2023-03-21 15:52:45','2023-03-22 15:53:05','2023-03-22 15:53:05');
INSERT INTO `balance_libro_details` VALUES (582,7492,58,40787,102495,2,482,2,5990714.34,NULL,'2023-03-21 15:52:45','2023-03-22 15:53:05','2023-03-22 15:53:05'),(583,7492,59,40787,102495,3,392,1,1366458.85,NULL,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(584,7492,59,40787,102495,3,491,1,25751.13,NULL,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(585,7492,59,40787,102495,3,493,1,3561.98,NULL,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(586,7492,59,40787,102495,3,492,1,1941.32,NULL,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(587,7492,59,40787,102495,3,490,1,83261.21,NULL,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(588,7492,59,40787,102495,3,489,1,84759.29,NULL,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(589,7492,59,40787,102495,3,116,1,123500.00,NULL,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(590,7492,59,40787,102495,3,120,1,3628.10,NULL,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(591,7492,59,40787,102495,3,483,1,47500.00,NULL,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(592,7492,59,40787,102495,3,180,1,346834.75,NULL,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(593,7492,59,40787,102495,3,193,1,78000.00,NULL,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(594,7492,59,40787,102495,3,495,1,3719.01,NULL,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(595,7492,59,40787,102495,3,396,1,63476.67,NULL,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(596,7492,59,40787,102495,3,137,1,2393.38,NULL,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(597,7492,59,40787,102495,3,494,1,95000.00,NULL,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(598,7492,59,40787,102495,3,68,1,397412.72,NULL,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(599,7492,59,40787,102495,3,226,1,3545.00,NULL,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(600,7492,59,40787,102495,3,484,1,4286.29,NULL,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(601,7492,59,40787,102495,3,165,2,2735029.70,NULL,'2023-03-21 16:04:46','2023-03-22 15:55:05','2023-03-22 15:55:05'),(602,7492,60,40787,102495,16,496,1,149767.86,NULL,'2023-03-21 16:10:46','2023-03-22 16:00:42','2023-03-22 16:00:42'),(603,7492,60,40787,102495,16,226,2,3545.00,NULL,'2023-03-21 16:10:46','2023-03-22 16:00:42','2023-03-22 16:00:42'),(604,7492,60,40787,102495,16,252,2,7405.20,NULL,'2023-03-21 16:10:46','2023-03-22 16:00:42','2023-03-22 16:00:42'),(605,7492,60,40787,102495,16,277,2,12730.52,NULL,'2023-03-21 16:10:46','2023-03-22 16:00:42','2023-03-22 16:00:42'),(606,7492,60,40787,102495,16,327,2,126087.14,NULL,'2023-03-21 16:10:46','2023-03-22 16:00:42','2023-03-22 16:00:42'),(607,7492,60,40787,102495,16,500,2,361.36,NULL,'2023-03-21 16:10:46','2023-03-22 16:00:42','2023-03-22 16:00:42'),(608,7492,60,40787,102495,16,498,1,1860.07,NULL,'2023-03-21 16:10:46','2023-03-22 16:00:42','2023-03-22 16:00:42'),(609,7492,60,40787,102495,16,359,2,1498.71,NULL,'2023-03-21 16:10:46','2023-03-22 16:00:42','2023-03-22 16:00:42'),(610,7492,61,40787,102495,15,67,1,1258050.01,NULL,'2023-03-21 16:13:07','2023-03-22 16:00:57','2023-03-22 16:00:57'),(611,7492,61,40787,102495,15,68,2,397412.72,NULL,'2023-03-21 16:13:07','2023-03-22 16:00:57','2023-03-22 16:00:57'),(612,7492,61,40787,102495,15,74,2,856351.00,NULL,'2023-03-21 16:13:07','2023-03-22 16:00:57','2023-03-22 16:00:57'),(613,7492,61,40787,102495,15,484,2,4286.29,NULL,'2023-03-21 16:13:07','2023-03-22 16:00:57','2023-03-22 16:00:57'),(614,7492,62,40787,102494,3,392,1,3430889.08,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(615,7492,62,40787,102494,3,491,1,23797.29,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52');
INSERT INTO `balance_libro_details` VALUES (616,7492,62,40787,102494,3,493,1,5313.21,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(617,7492,62,40787,102494,3,359,1,909.90,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(618,7492,62,40787,102494,3,492,1,9090.90,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(619,7492,62,40787,102494,3,490,1,69765.69,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(620,7492,62,40787,102494,3,512,1,5223.13,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(621,7492,62,40787,102494,3,495,1,3719.01,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(622,7492,62,40787,102494,3,120,1,2330.57,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(623,7492,62,40787,102494,3,489,1,23081.92,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(624,7492,62,40787,102494,3,193,1,135000.00,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(625,7492,62,40787,102494,3,180,1,51397.90,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(626,7492,62,40787,102494,3,483,1,57000.00,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(627,7492,62,40787,102494,3,116,1,123500.00,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(628,7492,62,40787,102494,3,507,1,74537.44,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(629,7492,62,40787,102494,3,137,1,115055.40,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(630,7492,62,40787,102494,3,68,1,806461.39,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(631,7492,62,40787,102494,3,485,1,4196.39,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(632,7492,62,40787,102494,3,508,1,1498.71,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(633,7492,62,40787,102494,3,484,1,2830.28,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(634,7492,62,40787,102494,3,503,1,2734.75,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(635,7492,62,40787,102494,3,165,2,4996942.29,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(636,7492,62,40787,102494,3,396,1,48609.33,NULL,'2023-03-22 14:20:18','2023-03-22 15:51:52','2023-03-22 15:51:52'),(637,7492,63,40787,102494,3,392,1,3430889.08,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(638,7492,63,40787,102494,3,491,1,23797.29,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(639,7492,63,40787,102494,3,493,1,6223.11,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(640,7492,63,40787,102494,3,492,1,9090.90,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(641,7492,63,40787,102494,3,490,1,69765.69,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(642,7492,63,40787,102494,3,512,1,5223.13,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(643,7492,63,40787,102494,3,120,1,2330.57,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(644,7492,63,40787,102494,3,489,1,23081.92,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(645,7492,63,40787,102494,3,193,1,138719.01,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(646,7492,63,40787,102494,3,180,1,51397.90,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(647,7492,63,40787,102494,3,483,1,57000.00,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(648,7492,63,40787,102494,3,116,1,123500.00,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(649,7492,63,40787,102494,3,507,1,74537.44,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10');
INSERT INTO `balance_libro_details` VALUES (650,7492,63,40787,102494,3,137,1,115055.40,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(651,7492,63,40787,102494,3,68,1,806461.39,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(652,7492,63,40787,102494,3,485,1,4196.39,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(653,7492,63,40787,102494,3,508,1,1498.71,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(654,7492,63,40787,102494,3,484,1,2830.28,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(655,7492,63,40787,102494,3,503,1,2734.75,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(656,7492,63,40787,102494,3,165,2,4996942.29,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(657,7492,63,40787,102494,3,396,1,48609.33,NULL,'2023-03-22 15:51:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(658,7492,64,40787,102494,16,496,1,151389.16,NULL,'2023-03-22 15:52:35','2023-11-05 14:01:10','2023-11-05 14:01:10'),(659,7492,64,40787,102494,16,226,2,4196.39,NULL,'2023-03-22 15:52:35','2023-11-05 14:01:10','2023-11-05 14:01:10'),(660,7492,64,40787,102494,16,252,2,54644.35,NULL,'2023-03-22 15:52:35','2023-11-05 14:01:10','2023-11-05 14:01:10'),(661,7492,64,40787,102494,16,499,2,41310.04,NULL,'2023-03-22 15:52:35','2023-11-05 14:01:10','2023-11-05 14:01:10'),(662,7492,64,40787,102494,16,327,2,51238.38,NULL,'2023-03-22 15:52:35','2023-11-05 14:01:10','2023-11-05 14:01:10'),(663,7492,64,40787,102494,16,225,2,1498.71,NULL,'2023-03-22 15:52:35','2023-11-05 14:01:10','2023-11-05 14:01:10'),(664,7492,64,40787,102494,16,498,1,1498.71,NULL,'2023-03-22 15:52:35','2023-11-05 14:01:10','2023-11-05 14:01:10'),(665,7492,65,40787,102494,15,67,1,1271668.94,NULL,'2023-03-22 15:52:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(666,7492,65,40787,102494,15,68,2,806461.39,NULL,'2023-03-22 15:52:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(667,7492,65,40787,102494,15,74,2,462377.27,NULL,'2023-03-22 15:52:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(668,7492,65,40787,102494,15,484,2,2830.28,NULL,'2023-03-22 15:52:52','2023-11-05 14:01:10','2023-11-05 14:01:10'),(669,7492,66,40787,102495,2,14,1,7248764.35,NULL,'2023-03-22 15:53:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(670,7492,66,40787,102495,2,67,2,1258050.01,NULL,'2023-03-22 15:53:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(671,7492,66,40787,102495,2,482,2,5990714.34,NULL,'2023-03-22 15:53:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(672,7492,67,40787,102495,3,392,1,1366458.85,NULL,'2023-03-22 15:55:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(673,7492,67,40787,102495,3,491,1,25751.13,NULL,'2023-03-22 15:55:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(674,7492,67,40787,102495,3,493,1,3561.98,NULL,'2023-03-22 15:55:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(675,7492,67,40787,102495,3,492,1,1941.32,NULL,'2023-03-22 15:55:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(676,7492,67,40787,102495,3,490,1,83261.21,NULL,'2023-03-22 15:55:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(677,7492,67,40787,102495,3,489,1,84759.29,NULL,'2023-03-22 15:55:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(678,7492,67,40787,102495,3,116,1,123500.00,NULL,'2023-03-22 15:55:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(679,7492,67,40787,102495,3,120,1,3628.10,NULL,'2023-03-22 15:55:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(680,7492,67,40787,102495,3,483,1,47500.00,NULL,'2023-03-22 15:55:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(681,7492,67,40787,102495,3,180,1,346834.75,NULL,'2023-03-22 15:55:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(682,7492,67,40787,102495,3,193,1,81719.01,NULL,'2023-03-22 15:55:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(683,7492,67,40787,102495,3,396,1,63476.67,NULL,'2023-03-22 15:55:05','2023-11-05 14:01:10','2023-11-05 14:01:10');
INSERT INTO `balance_libro_details` VALUES (684,7492,67,40787,102495,3,137,1,2393.38,NULL,'2023-03-22 15:55:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(685,7492,67,40787,102495,3,494,1,95000.00,NULL,'2023-03-22 15:55:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(686,7492,67,40787,102495,3,68,1,397412.72,NULL,'2023-03-22 15:55:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(687,7492,67,40787,102495,3,226,1,3545.00,NULL,'2023-03-22 15:55:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(688,7492,67,40787,102495,3,484,1,4286.29,NULL,'2023-03-22 15:55:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(689,7492,67,40787,102495,3,165,2,2735029.70,NULL,'2023-03-22 15:55:05','2023-11-05 14:01:10','2023-11-05 14:01:10'),(690,7492,68,40787,102495,16,496,1,149767.86,NULL,'2023-03-22 16:00:42','2023-11-05 14:01:10','2023-11-05 14:01:10'),(691,7492,68,40787,102495,16,226,2,3545.00,NULL,'2023-03-22 16:00:42','2023-11-05 14:01:10','2023-11-05 14:01:10'),(692,7492,68,40787,102495,16,252,2,7405.20,NULL,'2023-03-22 16:00:42','2023-11-05 14:01:10','2023-11-05 14:01:10'),(693,7492,68,40787,102495,16,277,2,12730.52,NULL,'2023-03-22 16:00:42','2023-11-05 14:01:10','2023-11-05 14:01:10'),(694,7492,68,40787,102495,16,327,2,126087.14,NULL,'2023-03-22 16:00:42','2023-11-05 14:01:10','2023-11-05 14:01:10'),(695,7492,68,40787,102495,16,500,2,361.36,NULL,'2023-03-22 16:00:42','2023-11-05 14:01:10','2023-11-05 14:01:10'),(696,7492,68,40787,102495,16,498,1,361.36,NULL,'2023-03-22 16:00:42','2023-11-05 14:01:10','2023-11-05 14:01:10'),(697,7492,69,40787,102495,15,67,1,1258050.01,NULL,'2023-03-22 16:00:57','2023-11-05 14:01:10','2023-11-05 14:01:10'),(698,7492,69,40787,102495,15,68,2,397412.72,NULL,'2023-03-22 16:00:57','2023-11-05 14:01:10','2023-11-05 14:01:10'),(699,7492,69,40787,102495,15,74,2,856351.00,NULL,'2023-03-22 16:00:57','2023-11-05 14:01:10','2023-11-05 14:01:10'),(700,7492,69,40787,102495,15,484,2,4286.29,NULL,'2023-03-22 16:00:57','2023-11-05 14:01:10','2023-11-05 14:01:10'),(701,7492,70,40787,102487,1,110,1,747865.33,NULL,'2023-04-14 11:48:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(702,7492,70,40787,102487,1,514,1,520.94,NULL,'2023-04-14 11:48:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(703,7492,70,40787,102487,1,515,1,73636.01,NULL,'2023-04-14 11:48:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(704,7492,70,40787,102487,1,191,1,200496.19,NULL,'2023-04-14 11:48:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(705,7492,70,40787,102487,1,162,2,5798.88,NULL,'2023-04-14 11:48:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(706,7492,70,40787,102487,1,516,2,520.94,NULL,'2023-04-14 11:48:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(707,7492,70,40787,102487,1,517,2,73636.01,NULL,'2023-04-14 11:48:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(708,7492,70,40787,102487,1,64,2,13726.34,NULL,'2023-04-14 11:48:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(709,7492,70,40787,102487,1,518,2,18502.12,NULL,'2023-04-14 11:48:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(710,7492,70,40787,102487,1,62,2,603346.96,NULL,'2023-04-14 11:48:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(711,7492,70,40787,102487,1,63,2,306987.22,NULL,'2023-04-14 11:48:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(712,7492,71,40787,102487,1,63,1,334960.87,NULL,'2023-04-14 11:50:37','2023-11-05 14:01:10','2023-11-05 14:01:10'),(713,7492,71,40787,102487,1,516,1,595.36,NULL,'2023-04-14 11:50:37','2023-11-05 14:01:10','2023-11-05 14:01:10'),(714,7492,71,40787,102487,1,517,1,95714.44,NULL,'2023-04-14 11:50:37','2023-11-05 14:01:10','2023-11-05 14:01:10'),(715,7492,71,40787,102487,1,166,2,431270.67,NULL,'2023-04-14 11:50:37','2023-11-05 14:01:10','2023-11-05 14:01:10'),(716,7492,72,40787,102487,1,519,1,1721.50,NULL,'2023-04-14 11:54:42','2023-10-12 12:57:44','2023-10-12 12:57:44'),(717,7492,72,40787,102487,1,359,2,1721.50,NULL,'2023-04-14 11:54:42','2023-10-12 12:57:44','2023-10-12 12:57:44');
INSERT INTO `balance_libro_details` VALUES (718,7492,73,40787,102488,1,63,1,306987.22,NULL,'2023-04-14 11:56:48','2023-11-05 14:01:10','2023-11-05 14:01:10'),(719,7492,73,40787,102488,1,516,1,520.94,NULL,'2023-04-14 11:56:48','2023-11-05 14:01:10','2023-11-05 14:01:10'),(720,7492,73,40787,102488,1,517,1,73636.01,NULL,'2023-04-14 11:56:48','2023-11-05 14:01:10','2023-11-05 14:01:10'),(721,7492,73,40787,102488,1,166,2,381144.17,NULL,'2023-04-14 11:56:48','2023-11-05 14:01:10','2023-11-05 14:01:10'),(722,7492,74,40787,102488,1,64,1,13726.34,NULL,'2023-04-14 11:59:44','2023-04-14 15:25:53','2023-04-14 15:25:53'),(723,7492,74,40787,102488,1,518,1,18502.12,NULL,'2023-04-14 11:59:44','2023-04-14 15:25:53','2023-04-14 15:25:53'),(724,7492,74,40787,102488,1,384,1,6790.73,NULL,'2023-04-14 11:59:44','2023-04-14 15:25:53','2023-04-14 15:25:53'),(725,7492,74,40787,102488,1,166,2,39019.19,NULL,'2023-04-14 11:59:44','2023-04-14 15:25:53','2023-04-14 15:25:53'),(726,7492,75,40787,102488,1,519,1,1643.78,NULL,'2023-04-14 12:01:34','2023-10-12 12:57:22','2023-10-12 12:57:22'),(727,7492,75,40787,102488,1,359,2,1643.78,NULL,'2023-04-14 12:01:34','2023-10-12 12:57:22','2023-10-12 12:57:22'),(728,7492,76,40787,102488,1,110,1,974316.53,NULL,'2023-04-14 12:06:09','2023-11-05 14:01:10','2023-11-05 14:01:10'),(729,7492,76,40787,102488,1,514,1,632.57,NULL,'2023-04-14 12:06:09','2023-11-05 14:01:10','2023-11-05 14:01:10'),(730,7492,76,40787,102488,1,515,1,94469.91,NULL,'2023-04-14 12:06:09','2023-11-05 14:01:10','2023-11-05 14:01:10'),(731,7492,76,40787,102488,1,191,1,241069.34,NULL,'2023-04-14 12:06:09','2023-11-05 14:01:10','2023-11-05 14:01:10'),(732,7492,76,40787,102488,1,162,2,25989.66,NULL,'2023-04-14 12:06:09','2023-11-05 14:01:10','2023-11-05 14:01:10'),(733,7492,76,40787,102488,1,516,2,632.57,NULL,'2023-04-14 12:06:09','2023-11-05 14:01:10','2023-11-05 14:01:10'),(734,7492,76,40787,102488,1,517,2,94469.91,NULL,'2023-04-14 12:06:09','2023-11-05 14:01:10','2023-11-05 14:01:10'),(735,7492,76,40787,102488,1,64,2,16789.32,NULL,'2023-04-14 12:06:09','2023-11-05 14:01:10','2023-11-05 14:01:10'),(736,7492,76,40787,102488,1,518,2,23964.90,NULL,'2023-04-14 12:06:09','2023-11-05 14:01:10','2023-11-05 14:01:10'),(737,7492,76,40787,102488,1,62,2,776749.46,NULL,'2023-04-14 12:06:09','2023-11-05 14:01:10','2023-11-05 14:01:10'),(738,7492,76,40787,102488,1,63,2,371892.53,NULL,'2023-04-14 12:06:09','2023-11-05 14:01:10','2023-11-05 14:01:10'),(739,7492,77,40787,102489,1,63,1,371892.53,NULL,'2023-04-14 12:19:16','2023-11-05 14:01:10','2023-11-05 14:01:10'),(740,7492,77,40787,102489,1,516,1,632.57,NULL,'2023-04-14 12:19:16','2023-11-05 14:01:10','2023-11-05 14:01:10'),(741,7492,77,40787,102489,1,517,1,94469.91,NULL,'2023-04-14 12:19:16','2023-11-05 14:01:10','2023-11-05 14:01:10'),(742,7492,77,40787,102489,1,166,2,466995.01,NULL,'2023-04-14 12:19:16','2023-11-05 14:01:10','2023-11-05 14:01:10'),(743,7492,78,40787,102489,1,64,1,16789.32,NULL,'2023-04-14 12:21:10','2023-04-14 15:30:23','2023-04-14 15:30:23'),(744,7492,78,40787,102489,1,518,1,23964.90,NULL,'2023-04-14 12:21:10','2023-04-14 15:30:23','2023-04-14 15:30:23'),(745,7492,78,40787,102489,1,384,1,8118.97,NULL,'2023-04-14 12:21:10','2023-04-14 15:30:23','2023-04-14 15:30:23'),(746,7492,78,40787,102489,1,166,2,48873.19,NULL,'2023-04-14 12:21:10','2023-04-14 15:30:23','2023-04-14 15:30:23'),(747,7492,79,40787,102490,1,519,1,2143.06,NULL,'2023-04-14 12:22:28','2023-04-14 15:28:03','2023-04-14 15:28:03'),(748,7492,79,40787,102490,1,359,2,2143.06,NULL,'2023-04-14 12:22:28','2023-04-14 15:28:03','2023-04-14 15:28:03'),(749,7492,80,40787,102489,1,110,1,1099934.45,NULL,'2023-04-14 12:30:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(750,7492,80,40787,102489,1,514,1,669.78,NULL,'2023-04-14 12:30:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(751,7492,80,40787,102489,1,515,1,111032.44,NULL,'2023-04-14 12:30:49','2023-11-05 14:01:10','2023-11-05 14:01:10');
INSERT INTO `balance_libro_details` VALUES (752,7492,80,40787,102489,1,191,1,330158.65,NULL,'2023-04-14 12:30:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(753,7492,80,40787,102489,1,162,2,75444.70,NULL,'2023-04-14 12:30:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(754,7492,80,40787,102489,1,516,2,669.78,NULL,'2023-04-14 12:30:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(755,7492,80,40787,102489,1,517,2,111032.44,NULL,'2023-04-14 12:30:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(756,7492,80,40787,102489,1,64,2,19100.30,NULL,'2023-04-14 12:30:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(757,7492,80,40787,102489,1,518,2,27951.48,NULL,'2023-04-14 12:30:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(758,7492,80,40787,102489,1,62,2,917171.54,NULL,'2023-04-14 12:30:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(759,7492,80,40787,102489,1,63,2,390425.08,NULL,'2023-04-14 12:30:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(760,7492,81,40787,102490,1,63,1,390425.08,NULL,'2023-04-14 12:32:26','2023-11-05 14:01:10','2023-11-05 14:01:10'),(761,7492,81,40787,102490,1,516,1,669.78,NULL,'2023-04-14 12:32:26','2023-11-05 14:01:10','2023-11-05 14:01:10'),(762,7492,81,40787,102490,1,517,1,111032.44,NULL,'2023-04-14 12:32:26','2023-11-05 14:01:10','2023-11-05 14:01:10'),(763,7492,81,40787,102490,1,166,2,502127.30,NULL,'2023-04-14 12:32:26','2023-11-05 14:01:10','2023-11-05 14:01:10'),(764,7492,82,40787,102490,1,64,1,19100.30,NULL,'2023-04-14 12:34:12','2023-04-14 15:31:50','2023-04-14 15:31:50'),(765,7492,82,40787,102490,1,518,1,27951.48,NULL,'2023-04-14 12:34:12','2023-04-14 15:31:50','2023-04-14 15:31:50'),(766,7492,82,40787,102490,1,384,1,8794.22,NULL,'2023-04-14 12:34:12','2023-04-14 15:31:50','2023-04-14 15:31:50'),(767,7492,82,40787,102490,1,166,2,55846.00,NULL,'2023-04-14 12:34:12','2023-04-14 15:31:50','2023-04-14 15:31:50'),(768,7492,83,40787,102490,1,519,1,2365.32,NULL,'2023-04-14 12:35:33','2023-10-12 12:56:48','2023-10-12 12:56:48'),(769,7492,83,40787,102490,1,359,2,2365.32,NULL,'2023-04-14 12:35:33','2023-10-12 12:56:48','2023-10-12 12:56:48'),(770,7492,84,40787,102490,1,110,1,1170712.20,NULL,'2023-04-14 12:42:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(771,7492,84,40787,102490,1,514,1,520.94,NULL,'2023-04-14 12:42:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(772,7492,84,40787,102490,1,515,1,113268.80,NULL,'2023-04-14 12:42:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(773,7492,84,40787,102490,1,191,1,324677.37,NULL,'2023-04-14 12:42:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(774,7492,84,40787,102490,1,162,2,56062.12,NULL,'2023-04-14 12:42:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(775,7492,84,40787,102490,1,516,2,520.94,NULL,'2023-04-14 12:42:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(776,7492,84,40787,102490,1,517,2,113268.80,NULL,'2023-04-14 12:42:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(777,7492,84,40787,102490,1,64,2,19559.33,NULL,'2023-04-14 12:42:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(778,7492,84,40787,102490,1,518,2,28832.68,NULL,'2023-04-14 12:42:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(779,7492,84,40787,102490,1,62,2,937215.52,NULL,'2023-04-14 12:42:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(780,7492,84,40787,102490,1,63,2,453719.92,NULL,'2023-04-14 12:42:00','2023-11-05 14:01:10','2023-11-05 14:01:10'),(781,7492,85,40787,102491,1,63,1,453719.93,NULL,'2023-04-14 12:54:29','2023-11-05 14:01:10','2023-11-05 14:01:10'),(782,7492,85,40787,102491,1,516,1,520.94,NULL,'2023-04-14 12:54:29','2023-11-05 14:01:10','2023-11-05 14:01:10'),(783,7492,85,40787,102491,1,517,1,113268.80,NULL,'2023-04-14 12:54:29','2023-11-05 14:01:10','2023-11-05 14:01:10'),(784,7492,85,40787,102491,1,166,2,567509.67,NULL,'2023-04-14 12:54:29','2023-11-05 14:01:10','2023-11-05 14:01:10'),(785,7492,86,40787,102491,1,64,1,19559.33,NULL,'2023-04-14 12:56:19','2023-04-14 15:32:59','2023-04-14 15:32:59');
INSERT INTO `balance_libro_details` VALUES (786,7492,86,40787,102491,1,518,1,28832.68,NULL,'2023-04-14 12:56:19','2023-04-14 15:32:59','2023-04-14 15:32:59'),(787,7492,86,40787,102491,1,384,1,9663.62,NULL,'2023-04-14 12:56:19','2023-04-14 15:32:59','2023-04-14 15:32:59'),(788,7492,86,40787,102491,1,166,2,58055.63,NULL,'2023-04-14 12:56:19','2023-04-14 15:32:59','2023-04-14 15:32:59'),(789,7492,87,40787,102491,1,519,1,2637.46,NULL,'2023-04-14 12:57:12','2023-10-12 12:56:29','2023-10-12 12:56:29'),(790,7492,87,40787,102491,1,359,2,2637.46,NULL,'2023-04-14 12:57:12','2023-10-12 12:56:29','2023-10-12 12:56:29'),(791,7492,88,40787,102491,1,110,1,1667545.34,NULL,'2023-04-14 14:32:37','2023-11-05 14:01:10','2023-11-05 14:01:10'),(792,7492,88,40787,102491,1,514,1,744.20,NULL,'2023-04-14 14:32:37','2023-11-05 14:01:10','2023-11-05 14:01:10'),(793,7492,88,40787,102491,1,515,1,160684.05,NULL,'2023-04-14 14:32:37','2023-11-05 14:01:10','2023-11-05 14:01:10'),(794,7492,88,40787,102491,1,191,1,453444.19,NULL,'2023-04-14 14:32:37','2023-11-05 14:01:10','2023-11-05 14:01:10'),(795,7492,88,40787,102491,1,162,2,116809.71,NULL,'2023-04-14 14:32:37','2023-11-05 14:01:10','2023-11-05 14:01:10'),(796,7492,88,40787,102491,1,516,2,744.20,NULL,'2023-04-14 14:32:37','2023-11-05 14:01:10','2023-11-05 14:01:10'),(797,7492,88,40787,102491,1,517,2,160684.05,NULL,'2023-04-14 14:32:37','2023-11-05 14:01:10','2023-11-05 14:01:10'),(798,7492,88,40787,102491,1,64,2,27131.34,NULL,'2023-04-14 14:32:37','2023-11-05 14:01:10','2023-11-05 14:01:10'),(799,7492,88,40787,102491,1,518,2,36564.00,NULL,'2023-04-14 14:32:37','2023-11-05 14:01:10','2023-11-05 14:01:10'),(800,7492,88,40787,102491,1,62,2,1333000.89,NULL,'2023-04-14 14:32:37','2023-11-05 14:01:10','2023-11-05 14:01:10'),(801,7492,88,40787,102491,1,63,2,607483.59,NULL,'2023-04-14 14:32:37','2023-11-05 14:01:10','2023-11-05 14:01:10'),(802,7492,89,40787,102492,1,63,1,607483.59,NULL,'2023-04-14 14:34:48','2023-11-05 14:01:10','2023-11-05 14:01:10'),(803,7492,89,40787,102492,1,516,1,744.20,NULL,'2023-04-14 14:34:48','2023-11-05 14:01:10','2023-11-05 14:01:10'),(804,7492,89,40787,102492,1,517,1,160684.05,NULL,'2023-04-14 14:34:48','2023-11-05 14:01:10','2023-11-05 14:01:10'),(805,7492,89,40787,102492,1,166,2,768911.84,NULL,'2023-04-14 14:34:48','2023-11-05 14:01:10','2023-11-05 14:01:10'),(806,7492,90,40787,102492,1,64,1,27131.34,NULL,'2023-04-14 14:36:37','2023-04-14 15:34:10','2023-04-14 15:34:10'),(807,7492,90,40787,102492,1,518,1,36564.00,NULL,'2023-04-14 14:36:37','2023-04-14 15:34:10','2023-04-14 15:34:10'),(808,7492,90,40787,102492,1,384,1,11949.79,NULL,'2023-04-14 14:36:37','2023-04-14 15:34:10','2023-04-14 15:34:10'),(809,7492,90,40787,102492,1,166,2,75645.13,NULL,'2023-04-14 14:36:37','2023-04-14 15:34:10','2023-04-14 15:34:10'),(810,7492,91,40787,102492,1,519,1,3779.78,NULL,'2023-04-14 14:37:31','2023-10-12 12:56:11','2023-10-12 12:56:11'),(811,7492,91,40787,102492,1,359,2,3779.78,NULL,'2023-04-14 14:37:31','2023-10-12 12:56:11','2023-10-12 12:56:11'),(812,7492,92,40787,102492,1,110,1,2372184.51,NULL,'2023-04-14 14:43:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(813,7492,92,40787,102492,1,514,1,706.99,NULL,'2023-04-14 14:43:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(814,7492,92,40787,102492,1,515,1,227631.44,NULL,'2023-04-14 14:43:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(815,7492,92,40787,102492,1,191,1,559331.12,NULL,'2023-04-14 14:43:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(816,7492,92,40787,102492,1,162,2,110522.63,NULL,'2023-04-14 14:43:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(817,7492,92,40787,102492,1,516,2,706.99,NULL,'2023-04-14 14:43:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(818,7492,92,40787,102492,1,517,2,227631.44,NULL,'2023-04-14 14:43:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(819,7492,92,40787,102492,1,64,2,32842.25,NULL,'2023-04-14 14:43:20','2023-11-05 14:01:10','2023-11-05 14:01:10');
INSERT INTO `balance_libro_details` VALUES (820,7492,92,40787,102492,1,518,2,36409.70,NULL,'2023-04-14 14:43:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(821,7492,92,40787,102492,1,62,2,1991738.50,NULL,'2023-04-14 14:43:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(822,7492,92,40787,102492,1,63,2,760002.55,NULL,'2023-04-14 14:43:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(823,7492,93,40787,102494,1,63,1,760002.55,NULL,'2023-04-14 14:45:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(824,7492,93,40787,102494,1,516,1,706.99,NULL,'2023-04-14 14:45:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(825,7492,93,40787,102494,1,517,1,227631.44,NULL,'2023-04-14 14:45:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(826,7492,93,40787,102494,1,166,2,988340.98,NULL,'2023-04-14 14:45:49','2023-11-05 14:01:10','2023-11-05 14:01:10'),(827,7492,94,40787,102494,1,64,1,32842.25,NULL,'2023-04-14 14:47:40','2023-04-14 15:35:20','2023-04-14 15:35:20'),(828,7492,94,40787,102494,1,518,1,36409.70,NULL,'2023-04-14 14:47:40','2023-04-14 15:35:20','2023-04-14 15:35:20'),(829,7492,94,40787,102494,1,384,1,10304.46,NULL,'2023-04-14 14:47:40','2023-04-14 15:35:20','2023-04-14 15:35:20'),(830,7492,94,40787,102494,1,166,2,79556.41,NULL,'2023-04-14 14:47:40','2023-04-14 15:35:20','2023-04-14 15:35:20'),(831,7492,95,40787,102494,1,519,1,3427.47,NULL,'2023-04-14 14:48:24','2023-10-12 12:55:47','2023-10-12 12:55:47'),(832,7492,95,40787,102494,1,359,2,3427.47,NULL,'2023-04-14 14:48:24','2023-10-12 12:55:47','2023-10-12 12:55:47'),(833,7492,96,40787,102494,1,110,1,1504907.34,NULL,'2023-04-14 14:52:18','2023-11-05 14:01:10','2023-11-05 14:01:10'),(834,7492,96,40787,102494,1,514,1,669.78,NULL,'2023-04-14 14:52:18','2023-11-05 14:01:10','2023-11-05 14:01:10'),(835,7492,96,40787,102494,1,515,1,151098.92,NULL,'2023-04-14 14:52:18','2023-11-05 14:01:10','2023-11-05 14:01:10'),(836,7492,96,40787,102494,1,191,1,398376.46,NULL,'2023-04-14 14:52:18','2023-11-05 14:01:10','2023-11-05 14:01:10'),(837,7492,96,40787,102494,1,162,2,77014.82,NULL,'2023-04-14 14:52:18','2023-11-05 14:01:10','2023-11-05 14:01:10'),(838,7492,96,40787,102494,1,516,2,669.78,NULL,'2023-04-14 14:52:18','2023-11-05 14:01:10','2023-11-05 14:01:10'),(839,7492,96,40787,102494,1,517,2,151098.92,NULL,'2023-04-14 14:52:18','2023-11-05 14:01:10','2023-11-05 14:01:10'),(840,7492,96,40787,102494,1,64,2,5667.20,NULL,'2023-04-14 14:52:18','2023-11-05 14:01:10','2023-11-05 14:01:10'),(841,7492,96,40787,102494,1,518,2,37070.64,NULL,'2023-04-14 14:52:18','2023-11-05 14:01:10','2023-11-05 14:01:10'),(842,7492,96,40787,102494,1,62,2,1212124.05,NULL,'2023-04-14 14:52:18','2023-11-05 14:01:10','2023-11-05 14:01:10'),(843,7492,96,40787,102494,1,63,2,571407.09,NULL,'2023-04-14 14:52:18','2023-11-05 14:01:10','2023-11-05 14:01:10'),(844,7492,97,40787,102495,1,63,1,571407.09,NULL,'2023-04-14 14:54:03','2023-11-05 14:01:10','2023-11-05 14:01:10'),(845,7492,97,40787,102495,1,516,1,669.78,NULL,'2023-04-14 14:54:03','2023-11-05 14:01:10','2023-11-05 14:01:10'),(846,7492,97,40787,102495,1,517,1,151098.92,NULL,'2023-04-14 14:54:03','2023-11-05 14:01:10','2023-11-05 14:01:10'),(847,7492,97,40787,102495,1,166,2,723175.79,NULL,'2023-04-14 14:54:03','2023-11-05 14:01:10','2023-11-05 14:01:10'),(848,7492,98,40787,102495,1,64,1,5667.20,NULL,'2023-04-14 14:55:47','2023-04-14 15:36:12','2023-04-14 15:36:12'),(849,7492,98,40787,102495,1,518,1,37070.64,NULL,'2023-04-14 14:55:47','2023-04-14 15:36:12','2023-04-14 15:36:12'),(850,7492,98,40787,102495,1,384,1,11055.96,NULL,'2023-04-14 14:55:47','2023-04-14 15:36:12','2023-04-14 15:36:12'),(851,7492,98,40787,102495,1,166,2,53793.80,NULL,'2023-04-14 14:55:47','2023-04-14 15:36:12','2023-04-14 15:36:12'),(852,7492,99,40787,102495,1,519,1,3315.96,NULL,'2023-04-14 14:56:47','2023-10-12 12:55:27','2023-10-12 12:55:27'),(853,7492,99,40787,102495,1,359,2,3315.96,NULL,'2023-04-14 14:56:47','2023-10-12 12:55:27','2023-10-12 12:55:27');
INSERT INTO `balance_libro_details` VALUES (854,7492,100,40787,102495,1,110,1,1375824.00,NULL,'2023-04-14 15:01:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(855,7492,100,40787,102495,1,514,1,632.57,NULL,'2023-04-14 15:01:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(856,7492,100,40787,102495,1,515,1,133297.81,NULL,'2023-04-14 15:01:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(857,7492,100,40787,102495,1,191,1,359748.31,NULL,'2023-04-14 15:01:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(858,7492,100,40787,102495,1,162,2,20670.14,NULL,'2023-04-14 15:01:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(859,7492,100,40787,102495,1,516,2,632.57,NULL,'2023-04-14 15:01:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(860,7492,100,40787,102495,1,517,2,133297.81,NULL,'2023-04-14 15:01:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(861,7492,100,40787,102495,1,64,2,10773.00,NULL,'2023-04-14 15:01:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(862,7492,100,40787,102495,1,518,2,37444.88,NULL,'2023-04-14 15:01:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(863,7492,100,40787,102495,1,62,2,1099566.76,NULL,'2023-04-14 15:01:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(864,7492,100,40787,102495,1,63,2,567117.53,NULL,'2023-04-14 15:01:14','2023-11-05 14:01:10','2023-11-05 14:01:10'),(865,7492,101,40787,102496,1,63,1,567117.53,NULL,'2023-04-14 15:02:59','2023-11-05 14:01:10','2023-11-05 14:01:10'),(866,7492,101,40787,102496,1,516,1,632.57,NULL,'2023-04-14 15:02:59','2023-11-05 14:01:10','2023-11-05 14:01:10'),(867,7492,101,40787,102496,1,517,1,133297.81,NULL,'2023-04-14 15:02:59','2023-11-05 14:01:10','2023-11-05 14:01:10'),(868,7492,101,40787,102496,1,166,2,701047.91,NULL,'2023-04-14 15:02:59','2023-11-05 14:01:10','2023-11-05 14:01:10'),(869,7492,102,40787,102496,1,64,1,10773.00,NULL,'2023-04-14 15:04:32','2023-04-14 15:37:10','2023-04-14 15:37:10'),(870,7492,102,40787,102496,1,518,1,37444.88,NULL,'2023-04-14 15:04:32','2023-04-14 15:37:10','2023-04-14 15:37:10'),(871,7492,102,40787,102496,1,384,1,10303.93,NULL,'2023-04-14 15:04:32','2023-04-14 15:37:10','2023-04-14 15:37:10'),(872,7492,102,40787,102496,1,166,2,58521.81,NULL,'2023-04-14 15:04:32','2023-04-14 15:37:10','2023-04-14 15:37:10'),(873,7492,103,40787,102496,1,519,1,2993.92,NULL,'2023-04-14 15:05:19','2023-10-12 12:55:01','2023-10-12 12:55:01'),(874,7492,103,40787,102496,1,359,2,2993.92,NULL,'2023-04-14 15:05:19','2023-10-12 12:55:01','2023-10-12 12:55:01'),(875,7492,104,40787,102487,1,64,1,8528.66,NULL,'2023-04-14 15:23:26','2023-11-05 14:01:10','2023-11-05 14:01:10'),(876,7492,104,40787,102487,1,518,1,21145.28,NULL,'2023-04-14 15:23:26','2023-11-05 14:01:10','2023-11-05 14:01:10'),(877,7492,104,40787,102487,1,520,1,1702.77,NULL,'2023-04-14 15:23:26','2023-11-05 14:01:10','2023-11-05 14:01:10'),(878,7492,104,40787,102487,1,166,2,31376.71,NULL,'2023-04-14 15:23:26','2023-11-05 14:01:10','2023-11-05 14:01:10'),(879,7492,105,40787,102488,1,64,1,13726.34,NULL,'2023-04-14 15:25:53','2023-11-05 14:01:10','2023-11-05 14:01:10'),(880,7492,105,40787,102488,1,518,1,18502.12,NULL,'2023-04-14 15:25:53','2023-11-05 14:01:10','2023-11-05 14:01:10'),(881,7492,105,40787,102488,1,166,2,39019.19,NULL,'2023-04-14 15:25:53','2023-11-05 14:01:10','2023-11-05 14:01:10'),(882,7492,105,40787,102488,1,520,1,6790.73,NULL,'2023-04-14 15:25:53','2023-11-05 14:01:10','2023-11-05 14:01:10'),(883,7492,106,40787,102489,1,519,1,2143.06,NULL,'2023-04-14 15:28:03','2023-10-12 12:57:05','2023-10-12 12:57:05'),(884,7492,106,40787,102489,1,359,2,2143.06,NULL,'2023-04-14 15:28:03','2023-10-12 12:57:05','2023-10-12 12:57:05'),(885,7492,107,40787,102489,1,64,1,16789.32,NULL,'2023-04-14 15:30:23','2023-11-05 14:01:10','2023-11-05 14:01:10'),(886,7492,107,40787,102489,1,518,1,23964.90,NULL,'2023-04-14 15:30:23','2023-11-05 14:01:10','2023-11-05 14:01:10'),(887,7492,107,40787,102489,1,166,2,48873.19,NULL,'2023-04-14 15:30:23','2023-11-05 14:01:10','2023-11-05 14:01:10');
INSERT INTO `balance_libro_details` VALUES (888,7492,107,40787,102489,1,520,1,8118.97,NULL,'2023-04-14 15:30:23','2023-11-05 14:01:10','2023-11-05 14:01:10'),(889,7492,108,40787,102490,1,64,1,19100.30,NULL,'2023-04-14 15:31:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(890,7492,108,40787,102490,1,518,1,27951.48,NULL,'2023-04-14 15:31:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(891,7492,108,40787,102490,1,166,2,55846.00,NULL,'2023-04-14 15:31:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(892,7492,108,40787,102490,1,520,1,8794.22,NULL,'2023-04-14 15:31:50','2023-11-05 14:01:10','2023-11-05 14:01:10'),(893,7492,109,40787,102491,1,64,1,19559.33,NULL,'2023-04-14 15:32:59','2023-11-05 14:01:10','2023-11-05 14:01:10'),(894,7492,109,40787,102491,1,518,1,28832.68,NULL,'2023-04-14 15:32:59','2023-11-05 14:01:10','2023-11-05 14:01:10'),(895,7492,109,40787,102491,1,166,2,58055.63,NULL,'2023-04-14 15:32:59','2023-11-05 14:01:10','2023-11-05 14:01:10'),(896,7492,109,40787,102491,1,520,1,9663.62,NULL,'2023-04-14 15:32:59','2023-11-05 14:01:10','2023-11-05 14:01:10'),(897,7492,110,40787,102492,1,64,1,27131.34,NULL,'2023-04-14 15:34:10','2023-11-05 14:01:10','2023-11-05 14:01:10'),(898,7492,110,40787,102492,1,518,1,36564.00,NULL,'2023-04-14 15:34:10','2023-11-05 14:01:10','2023-11-05 14:01:10'),(899,7492,110,40787,102492,1,166,2,75645.13,NULL,'2023-04-14 15:34:10','2023-11-05 14:01:10','2023-11-05 14:01:10'),(900,7492,110,40787,102492,1,520,1,11949.79,NULL,'2023-04-14 15:34:10','2023-11-05 14:01:10','2023-11-05 14:01:10'),(901,7492,111,40787,102494,1,64,1,32842.25,NULL,'2023-04-14 15:35:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(902,7492,111,40787,102494,1,518,1,36409.70,NULL,'2023-04-14 15:35:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(903,7492,111,40787,102494,1,166,2,79556.41,NULL,'2023-04-14 15:35:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(904,7492,111,40787,102494,1,520,1,10304.46,NULL,'2023-04-14 15:35:20','2023-11-05 14:01:10','2023-11-05 14:01:10'),(905,7492,112,40787,102495,1,64,1,5667.20,NULL,'2023-04-14 15:36:12','2023-11-05 14:01:10','2023-11-05 14:01:10'),(906,7492,112,40787,102495,1,518,1,37070.64,NULL,'2023-04-14 15:36:12','2023-11-05 14:01:10','2023-11-05 14:01:10'),(907,7492,112,40787,102495,1,166,2,53793.80,NULL,'2023-04-14 15:36:12','2023-11-05 14:01:10','2023-11-05 14:01:10'),(908,7492,112,40787,102495,1,520,1,11055.96,NULL,'2023-04-14 15:36:12','2023-11-05 14:01:10','2023-11-05 14:01:10'),(909,7492,113,40787,102496,1,64,1,10773.00,NULL,'2023-04-14 15:37:10','2023-11-05 14:01:10','2023-11-05 14:01:10'),(910,7492,113,40787,102496,1,518,1,37444.88,NULL,'2023-04-14 15:37:10','2023-11-05 14:01:10','2023-11-05 14:01:10'),(911,7492,113,40787,102496,1,166,2,58521.81,NULL,'2023-04-14 15:37:10','2023-11-05 14:01:10','2023-11-05 14:01:10'),(912,7492,113,40787,102496,1,520,1,10303.93,NULL,'2023-04-14 15:37:10','2023-11-05 14:01:10','2023-11-05 14:01:10'),(913,7492,114,40787,102496,2,14,1,24311592.15,NULL,'2023-04-20 15:53:37','2023-11-05 14:01:09','2023-11-05 14:01:09'),(914,7492,114,40787,102496,2,67,2,4219367.23,NULL,'2023-04-20 15:53:37','2023-11-05 14:01:09','2023-11-05 14:01:09'),(915,7492,114,40787,102496,2,482,2,20092224.92,NULL,'2023-04-20 15:53:37','2023-11-05 14:01:09','2023-11-05 14:01:09'),(916,7492,115,40787,102496,3,392,1,2411947.60,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(917,7492,115,40787,102496,3,491,1,27723.98,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(918,7492,115,40787,102496,3,493,1,2987.24,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(919,7492,115,40787,102496,3,492,1,1941.00,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(920,7492,115,40787,102496,3,490,1,86752.36,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(921,7492,115,40787,102496,3,489,1,89935.72,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46');
INSERT INTO `balance_libro_details` VALUES (922,7492,115,40787,102496,3,116,1,123500.00,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(923,7492,115,40787,102496,3,120,1,26545.45,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(924,7492,115,40787,102496,3,483,1,38000.00,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(925,7492,115,40787,102496,3,180,1,63917.50,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(926,7492,115,40787,102496,3,384,1,5800.00,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(927,7492,115,40787,102496,3,193,1,4958.68,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(928,7492,115,40787,102496,3,396,1,98861.66,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(929,7492,115,40787,102496,3,137,1,129262.80,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(930,7492,115,40787,102496,3,507,1,83026.67,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(931,7492,115,40787,102496,3,68,1,612166.23,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(932,7492,115,40787,102496,3,484,1,5577.41,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(933,7492,115,40787,102496,3,486,1,13504.56,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(934,7492,115,40787,102496,3,226,1,9011.08,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(935,7492,115,40787,102496,3,477,1,1434.00,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(936,7492,115,40787,102496,3,503,1,5128.94,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(937,7492,115,40787,102496,3,166,2,3128246.14,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(938,7492,115,40787,102496,3,165,2,159289.76,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(939,7492,115,40787,102496,3,359,2,554446.98,NULL,'2023-04-20 16:16:03','2023-04-21 11:34:46','2023-04-21 11:34:46'),(940,7492,116,40787,102496,16,496,1,468232.35,NULL,'2023-04-20 16:27:15','2023-11-05 14:01:09','2023-11-05 14:01:09'),(941,7492,116,40787,102496,16,226,2,10445.08,NULL,'2023-04-20 16:27:15','2023-11-05 14:01:09','2023-11-05 14:01:09'),(942,7492,116,40787,102496,16,252,2,64628.40,NULL,'2023-04-20 16:27:15','2023-11-05 14:01:09','2023-11-05 14:01:09'),(943,7492,116,40787,102496,16,499,2,70323.12,NULL,'2023-04-20 16:27:15','2023-11-05 14:01:09','2023-11-05 14:01:09'),(944,7492,116,40787,102496,16,327,2,322835.75,NULL,'2023-04-20 16:27:15','2023-11-05 14:01:09','2023-11-05 14:01:09'),(945,7492,116,40787,102496,16,208,1,34073.27,NULL,'2023-04-20 16:27:15','2023-11-05 14:01:09','2023-11-05 14:01:09'),(946,7492,116,40787,102496,16,225,2,13504.56,NULL,'2023-04-20 16:27:15','2023-11-05 14:01:09','2023-11-05 14:01:09'),(947,7492,116,40787,102496,16,251,2,15258.82,NULL,'2023-04-20 16:27:15','2023-11-05 14:01:09','2023-11-05 14:01:09'),(948,7492,116,40787,102496,16,498,2,1860.07,NULL,'2023-04-20 16:27:15','2023-11-05 14:01:09','2023-11-05 14:01:09'),(949,7492,116,40787,102496,16,326,2,3449.82,NULL,'2023-04-20 16:27:15','2023-11-05 14:01:09','2023-11-05 14:01:09'),(950,7492,117,40787,102496,15,67,1,4219367.23,NULL,'2023-04-20 16:29:45','2023-11-05 14:01:09','2023-11-05 14:01:09'),(951,7492,117,40787,102496,15,68,2,612166.23,NULL,'2023-04-20 16:29:45','2023-11-05 14:01:09','2023-11-05 14:01:09'),(952,7492,117,40787,102496,15,74,2,3601623.59,NULL,'2023-04-20 16:29:45','2023-11-05 14:01:09','2023-11-05 14:01:09'),(953,7492,117,40787,102496,15,484,2,5577.41,NULL,'2023-04-20 16:29:45','2023-11-05 14:01:09','2023-11-05 14:01:09'),(954,7492,118,40787,102496,3,392,1,2411947.60,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(955,7492,118,40787,102496,3,491,1,27723.98,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (956,7492,118,40787,102496,3,493,1,2987.24,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(957,7492,118,40787,102496,3,492,1,1941.00,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(958,7492,118,40787,102496,3,490,1,86752.36,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(959,7492,118,40787,102496,3,489,1,89935.72,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(960,7492,118,40787,102496,3,116,1,123500.00,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(961,7492,118,40787,102496,3,120,1,26545.45,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(962,7492,118,40787,102496,3,483,1,38000.00,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(963,7492,118,40787,102496,3,180,1,63917.50,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(964,7492,118,40787,102496,3,193,1,4958.68,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(965,7492,118,40787,102496,3,396,1,98861.66,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(966,7492,118,40787,102496,3,137,1,129262.80,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(967,7492,118,40787,102496,3,507,1,83026.67,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(968,7492,118,40787,102496,3,68,1,612166.23,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(969,7492,118,40787,102496,3,484,1,5577.41,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(970,7492,118,40787,102496,3,486,1,13504.56,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(971,7492,118,40787,102496,3,226,1,9011.08,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(972,7492,118,40787,102496,3,503,1,5128.94,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(973,7492,118,40787,102496,3,166,2,3128246.14,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(974,7492,118,40787,102496,3,165,2,159289.76,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(975,7492,118,40787,102496,3,359,2,554446.98,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(976,7492,118,40787,102496,3,97,1,5800.00,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(977,7492,118,40787,102496,3,485,1,1434.00,NULL,'2023-04-21 11:34:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(978,7492,119,40787,102496,1,110,1,1376784.57,NULL,'2023-10-12 11:54:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(979,7492,119,40787,102496,1,198,1,1410.48,NULL,'2023-10-12 11:54:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(980,7492,119,40787,102496,1,515,1,166198.26,NULL,'2023-10-12 11:54:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(981,7492,119,40787,102496,1,191,1,329096.02,NULL,'2023-10-12 11:54:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(982,7492,119,40787,102496,1,516,2,1410.48,NULL,'2023-10-12 11:54:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(983,7492,119,40787,102496,1,517,2,166198.26,NULL,'2023-10-12 11:54:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(984,7492,119,40787,102496,1,162,2,178441.75,NULL,'2023-10-12 11:54:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(985,7492,119,40787,102496,1,64,2,9949.20,NULL,'2023-10-12 11:54:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(986,7492,119,40787,102496,1,518,2,40638.96,NULL,'2023-10-12 11:54:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(987,7492,119,40787,102496,1,63,2,355731.97,NULL,'2023-10-12 11:54:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(988,7492,119,40787,102496,1,62,2,1121118.71,NULL,'2023-10-12 11:54:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(989,7492,120,40787,102496,1,63,1,355731.97,NULL,'2023-10-12 11:55:03','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (990,7492,120,40787,102496,1,516,1,1410.48,NULL,'2023-10-12 11:55:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(991,7492,120,40787,102496,1,517,1,166198.26,NULL,'2023-10-12 11:55:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(992,7492,120,40787,102496,1,166,2,523340.71,NULL,'2023-10-12 11:55:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(993,7492,121,40787,102496,1,64,1,9949.20,NULL,'2023-10-12 11:56:32','2023-11-05 14:01:09','2023-11-05 14:01:09'),(994,7492,121,40787,102496,1,518,1,40638.96,NULL,'2023-10-12 11:56:32','2023-11-05 14:01:09','2023-11-05 14:01:09'),(995,7492,121,40787,102496,1,520,1,2872.64,NULL,'2023-10-12 11:56:32','2023-11-05 14:01:09','2023-11-05 14:01:09'),(996,7492,121,40787,102496,1,166,2,53460.80,NULL,'2023-10-12 11:56:32','2023-11-05 14:01:09','2023-11-05 14:01:09'),(997,7492,122,40787,102496,1,519,1,2872.64,NULL,'2023-10-12 11:57:43','2023-10-12 12:54:35','2023-10-12 12:54:35'),(998,7492,122,40787,102496,1,359,2,2872.64,NULL,'2023-10-12 11:57:43','2023-10-12 12:54:35','2023-10-12 12:54:35'),(999,7492,123,40787,102497,1,110,1,1697624.00,NULL,'2023-10-12 12:00:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1000,7492,123,40787,102497,1,514,1,1332.12,NULL,'2023-10-12 12:00:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1001,7492,123,40787,102497,1,515,1,203891.58,NULL,'2023-10-12 12:00:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1002,7492,123,40787,102497,1,191,1,451969.15,NULL,'2023-10-12 12:00:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1003,7492,123,40787,102497,1,162,2,309616.35,NULL,'2023-10-12 12:00:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1004,7492,123,40787,102497,1,516,2,1332.12,NULL,'2023-10-12 12:00:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1005,7492,123,40787,102497,1,517,2,203891.58,NULL,'2023-10-12 12:00:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1006,7492,123,40787,102497,1,64,2,12364.40,NULL,'2023-10-12 12:00:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1007,7492,123,40787,102497,1,518,2,42219.16,NULL,'2023-10-12 12:00:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1008,7492,123,40787,102497,1,63,2,424735.76,NULL,'2023-10-12 12:00:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1009,7492,123,40787,102497,1,62,2,1360657.48,NULL,'2023-10-12 12:00:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1010,7492,124,40787,102497,1,63,1,424735.76,NULL,'2023-10-12 12:02:01','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1011,7492,124,40787,102497,1,516,1,1332.12,NULL,'2023-10-12 12:02:01','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1012,7492,124,40787,102497,1,517,1,203891.58,NULL,'2023-10-12 12:02:01','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1013,7492,124,40787,102497,1,166,2,629959.46,NULL,'2023-10-12 12:02:01','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1014,7492,125,40787,102497,1,64,1,12364.40,NULL,'2023-10-12 12:03:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1015,7492,125,40787,102497,1,518,1,42219.16,NULL,'2023-10-12 12:03:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1016,7492,125,40787,102497,1,520,1,3709.70,NULL,'2023-10-12 12:03:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1017,7492,125,40787,102497,1,166,2,58293.26,NULL,'2023-10-12 12:03:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1018,7492,126,40787,102497,1,488,1,3709.70,NULL,'2023-10-12 12:04:25','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1019,7492,126,40787,102497,1,359,2,3709.70,NULL,'2023-10-12 12:04:25','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1020,7492,127,40787,102498,1,110,1,2219440.00,NULL,'2023-10-12 12:13:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1021,7492,127,40787,102498,1,514,1,1410.48,NULL,'2023-10-12 12:13:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1022,7492,127,40787,102498,1,515,1,266023.72,NULL,'2023-10-12 12:13:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1023,7492,127,40787,102498,1,191,1,597522.54,NULL,'2023-10-12 12:13:28','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (1024,7492,127,40787,102498,1,162,2,78003.20,NULL,'2023-10-12 12:13:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1025,7492,127,40787,102498,1,516,2,1410.48,NULL,'2023-10-12 12:13:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1026,7492,127,40787,102498,1,517,2,266023.72,NULL,'2023-10-12 12:13:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1027,7492,127,40787,102498,1,518,2,47953.80,NULL,'2023-10-12 12:13:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1028,7492,127,40787,102498,1,63,2,889333.26,NULL,'2023-10-12 12:13:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1029,7492,127,40787,102498,1,62,2,1787041.28,NULL,'2023-10-12 12:13:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1030,7492,127,40787,102498,1,64,2,14631.00,NULL,'2023-10-12 12:13:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1031,7492,128,40787,102499,1,63,1,889333.26,NULL,'2023-10-12 12:14:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1032,7492,128,40787,102499,1,516,1,1410.48,NULL,'2023-10-12 12:14:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1033,7492,128,40787,102499,1,517,1,266023.72,NULL,'2023-10-12 12:14:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1034,7492,128,40787,102499,1,166,2,1156767.46,NULL,'2023-10-12 12:14:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1035,7492,129,40787,102499,1,64,1,14631.00,NULL,'2023-10-12 12:16:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1036,7492,129,40787,102499,1,518,1,47953.80,NULL,'2023-10-12 12:16:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1037,7492,129,40787,102499,1,520,1,4775.23,NULL,'2023-10-12 12:16:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1038,7492,129,40787,102499,1,166,2,67360.03,NULL,'2023-10-12 12:16:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1039,7492,130,40787,102499,1,488,1,4775.23,NULL,'2023-10-12 12:17:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1040,7492,130,40787,102499,1,359,2,4775.23,NULL,'2023-10-12 12:17:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1041,7492,131,40787,102499,1,110,1,3528493.42,NULL,'2023-10-12 12:22:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1042,7492,131,40787,102499,1,514,1,1723.92,NULL,'2023-10-12 12:22:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1043,7492,131,40787,102499,1,515,1,422479.07,NULL,'2023-10-12 12:22:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1044,7492,131,40787,102499,1,191,1,963228.53,NULL,'2023-10-12 12:22:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1045,7492,131,40787,102499,1,162,2,214741.11,NULL,'2023-10-12 12:22:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1046,7492,131,40787,102499,1,516,2,1723.92,NULL,'2023-10-12 12:22:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1047,7492,131,40787,102499,1,517,2,422479.07,NULL,'2023-10-12 12:22:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1048,7492,131,40787,102499,1,64,2,21473.77,NULL,'2023-10-12 12:22:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1049,7492,131,40787,102499,1,518,2,60596.80,NULL,'2023-10-12 12:22:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1050,7492,131,40787,102499,1,63,2,1336784.91,NULL,'2023-10-12 12:22:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1051,7492,131,40787,102499,1,62,2,2858125.36,NULL,'2023-10-12 12:22:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1052,7492,132,40787,102499,1,519,2,5958.68,NULL,'2023-10-12 12:41:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1053,7492,132,40787,102499,1,488,1,5958.68,NULL,'2023-10-12 12:41:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1054,7492,133,40787,102499,1,518,2,5958.67,NULL,'2023-10-12 12:46:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1055,7492,133,40787,102499,1,520,1,5958.67,NULL,'2023-10-12 12:46:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1056,7492,134,40787,102496,1,359,2,2872.64,NULL,'2023-10-12 12:54:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1057,7492,134,40787,102496,1,488,1,2872.64,NULL,'2023-10-12 12:54:35','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (1058,7492,135,40787,102496,1,359,2,2993.92,NULL,'2023-10-12 12:55:01','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1059,7492,135,40787,102496,1,488,1,2993.92,NULL,'2023-10-12 12:55:01','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1060,7492,136,40787,102495,1,359,2,3315.96,NULL,'2023-10-12 12:55:27','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1061,7492,136,40787,102495,1,488,1,3315.96,NULL,'2023-10-12 12:55:27','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1062,7492,137,40787,102494,1,359,2,3427.47,NULL,'2023-10-12 12:55:47','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1063,7492,137,40787,102494,1,488,1,3427.47,NULL,'2023-10-12 12:55:47','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1064,7492,138,40787,102492,1,359,2,3779.78,NULL,'2023-10-12 12:56:11','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1065,7492,138,40787,102492,1,488,1,3779.78,NULL,'2023-10-12 12:56:11','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1066,7492,139,40787,102491,1,359,2,2637.46,NULL,'2023-10-12 12:56:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1067,7492,139,40787,102491,1,488,1,2637.46,NULL,'2023-10-12 12:56:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1068,7492,140,40787,102490,1,359,2,2365.32,NULL,'2023-10-12 12:56:48','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1069,7492,140,40787,102490,1,488,1,2365.32,NULL,'2023-10-12 12:56:48','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1070,7492,141,40787,102489,1,359,2,2143.06,NULL,'2023-10-12 12:57:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1071,7492,141,40787,102489,1,488,1,2143.06,NULL,'2023-10-12 12:57:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1072,7492,142,40787,102488,1,359,2,1643.78,NULL,'2023-10-12 12:57:22','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1073,7492,142,40787,102488,1,488,1,1643.78,NULL,'2023-10-12 12:57:22','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1074,7492,143,40787,102487,1,359,2,1721.50,NULL,'2023-10-12 12:57:44','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1075,7492,143,40787,102487,1,488,1,1721.50,NULL,'2023-10-12 12:57:44','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1076,7492,144,40787,102497,2,14,1,48499454.74,NULL,'2023-10-12 13:14:34','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1077,7492,144,40787,102497,2,67,2,8417260.74,NULL,'2023-10-12 13:14:34','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1078,7492,144,40787,102497,2,482,2,40082194.00,NULL,'2023-10-12 13:14:34','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1079,7492,145,40787,102498,2,14,1,11667038.66,NULL,'2023-10-12 13:15:23','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1080,7492,145,40787,102498,2,67,2,2024857.95,NULL,'2023-10-12 13:15:23','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1081,7492,145,40787,102498,2,482,2,9642180.71,NULL,'2023-10-12 13:15:23','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1082,7492,146,40787,102499,2,14,1,28418537.48,NULL,'2023-10-12 13:16:11','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1083,7492,146,40787,102499,2,67,2,4932142.87,NULL,'2023-10-12 13:16:11','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1084,7492,146,40787,102499,2,482,2,23486394.61,NULL,'2023-10-12 13:16:11','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1085,7492,147,40787,102497,3,392,1,8214610.19,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1086,7492,147,40787,102497,3,491,1,29006.33,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1087,7492,147,40787,102497,3,135,1,222604.00,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1088,7492,147,40787,102497,3,493,1,4347.11,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1089,7492,147,40787,102497,3,198,1,2395.87,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1090,7492,147,40787,102497,3,490,1,72960.59,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1091,7492,147,40787,102497,3,489,1,35570.33,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (1092,7492,147,40787,102497,3,121,1,123500.00,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1093,7492,147,40787,102497,3,120,1,1975.24,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1094,7492,147,40787,102497,3,483,1,19000.00,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1095,7492,147,40787,102497,3,180,1,90442.90,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1096,7492,147,40787,102497,3,489,1,34669.26,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1097,7492,147,40787,102497,3,135,1,35536.35,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1098,7492,147,40787,102497,3,495,1,4958.68,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1099,7492,147,40787,102497,3,494,1,100000.00,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1100,7492,147,40787,102497,3,135,1,222562.00,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1101,7492,147,40787,102497,3,396,1,107632.52,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1102,7492,147,40787,102497,3,135,1,28099.18,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1103,7492,147,40787,102497,3,68,1,1891648.92,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1104,7492,147,40787,102497,3,484,1,5983.76,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1105,7492,147,40787,102497,3,485,1,3623.33,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1106,7492,147,40787,102497,3,508,1,292.76,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1107,7492,147,40787,102497,3,503,1,10898.33,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1108,7492,147,40787,102497,3,166,2,9747380.82,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1109,7492,147,40787,102497,3,165,2,185346.28,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1110,7492,147,40787,102497,3,359,2,1329590.55,NULL,'2023-10-12 13:33:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1111,7492,148,40787,102498,3,392,1,8617648.34,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1112,7492,148,40787,102498,3,491,1,29728.51,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1113,7492,148,40787,102498,3,493,1,5000.00,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1114,7492,148,40787,102498,3,490,1,38194.19,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1115,7492,148,40787,102498,3,120,1,12685.94,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1116,7492,148,40787,102498,3,483,1,40500.00,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1117,7492,148,40787,102498,3,180,1,156227.25,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1118,7492,148,40787,102498,3,116,1,146625.00,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1119,7492,148,40787,102498,3,120,1,25867.59,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1120,7492,148,40787,102498,3,489,1,22597.84,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1121,7492,148,40787,102498,3,490,1,24116.28,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1122,7492,148,40787,102498,3,495,1,4958.68,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1123,7492,148,40787,102498,3,68,1,1908952.10,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1124,7492,148,40787,102498,3,484,1,10976.94,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1125,7492,148,40787,102498,3,485,1,19103.00,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (1126,7492,148,40787,102498,3,503,1,7556.24,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1127,7492,148,40787,102498,3,166,2,5336455.27,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1128,7492,148,40787,102498,3,165,2,412230.72,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1129,7492,148,40787,102498,3,359,2,5656556.43,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1130,7492,148,40787,102498,3,198,1,21111.57,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1131,7492,148,40787,102498,3,396,1,313392.95,NULL,'2023-10-12 13:57:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1132,7492,149,40787,102499,3,392,1,4659614.59,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1133,7492,149,40787,102499,3,491,1,31361.09,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1134,7492,149,40787,102499,3,493,1,5756.20,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1135,7492,149,40787,102499,3,495,1,38823.52,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1136,7492,149,40787,102499,3,192,1,200000.00,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1137,7492,149,40787,102499,3,198,1,2395.87,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1138,7492,149,40787,102499,3,490,1,33116.12,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1139,7492,149,40787,102499,3,116,1,146625.00,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1140,7492,149,40787,102499,3,120,1,20264.48,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1141,7492,149,40787,102499,3,483,1,40500.00,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1142,7492,149,40787,102499,3,180,1,185521.95,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1143,7492,149,40787,102499,3,489,1,45870.30,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1144,7492,149,40787,102499,3,490,1,19310.02,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1145,7492,149,40787,102499,3,495,1,4958.68,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1146,7492,149,40787,102499,3,396,1,134850.00,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1147,7492,149,40787,102499,3,135,1,310820.00,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1148,7492,149,40787,102499,3,121,1,72500.00,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1149,7492,149,40787,102499,3,68,1,1112551.84,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1150,7492,149,40787,102499,3,484,1,5297.30,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1151,7492,149,40787,102499,3,485,1,9671.37,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1152,7492,149,40787,102499,3,508,1,89281.24,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1153,7492,149,40787,102499,3,503,1,5754.36,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1154,7492,149,40787,102499,3,165,2,1855147.33,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1155,7492,149,40787,102499,3,57,2,1205239.00,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1156,7492,149,40787,102499,3,166,2,4114457.60,NULL,'2023-10-12 14:05:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1157,7492,150,40787,102497,15,67,1,8417260.74,NULL,'2023-10-12 14:11:23','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1158,7492,150,40787,102497,15,68,2,1891648.92,NULL,'2023-10-12 14:11:23','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1159,7492,150,40787,102497,15,74,2,6519628.06,NULL,'2023-10-12 14:11:23','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (1160,7492,150,40787,102497,15,484,2,5983.76,NULL,'2023-10-12 14:11:23','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1161,7492,151,40787,102498,15,67,1,2024857.95,NULL,'2023-10-12 14:12:19','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1162,7492,151,40787,102498,15,68,2,1908952.10,NULL,'2023-10-12 14:12:19','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1163,7492,151,40787,102498,15,74,2,104928.91,NULL,'2023-10-12 14:12:19','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1164,7492,151,40787,102498,15,484,2,10976.94,NULL,'2023-10-12 14:12:19','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1165,7492,152,40787,102499,15,67,1,4932142.87,NULL,'2023-10-12 14:13:09','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1166,7492,152,40787,102499,15,68,2,1112551.84,NULL,'2023-10-12 14:13:09','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1167,7492,152,40787,102499,15,74,2,3814293.73,NULL,'2023-10-12 14:13:09','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1168,7492,152,40787,102499,15,484,2,5297.30,NULL,'2023-10-12 14:13:09','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1169,7492,153,40787,102497,16,496,1,1002054.85,NULL,'2023-10-12 14:18:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1170,7492,153,40787,102497,16,485,2,56207.38,NULL,'2023-10-12 14:18:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1171,7492,153,40787,102497,16,499,2,86067.41,NULL,'2023-10-12 14:18:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1172,7492,153,40787,102497,16,508,2,292.76,NULL,'2023-10-12 14:18:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1173,7492,153,40787,102497,16,327,2,859780.05,NULL,'2023-10-12 14:18:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1174,7492,153,40787,102497,16,498,1,292.75,NULL,'2023-10-12 14:18:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1175,7492,154,40787,102498,15,496,1,241054.52,NULL,'2023-10-12 14:21:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1176,7492,154,40787,102498,15,485,2,19103.01,NULL,'2023-10-12 14:21:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1177,7492,154,40787,102498,15,499,2,64314.28,NULL,'2023-10-12 14:21:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1178,7492,154,40787,102498,15,327,2,115841.99,NULL,'2023-10-12 14:21:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1179,7492,154,40787,102498,15,498,1,447.51,NULL,'2023-10-12 14:21:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1180,7492,154,40787,102498,15,513,2,154.75,NULL,'2023-10-12 14:21:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1181,7492,154,40787,102498,15,252,2,41795.24,NULL,'2023-10-12 14:21:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1182,7492,154,40787,102498,15,498,2,292.76,NULL,'2023-10-12 14:21:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1183,7492,155,40787,102499,16,496,1,488076.05,NULL,'2023-10-12 14:23:44','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1184,7492,155,40787,102499,16,485,2,9671.37,NULL,'2023-10-12 14:23:44','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1185,7492,155,40787,102499,16,252,2,192351.24,NULL,'2023-10-12 14:23:44','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1186,7492,155,40787,102499,16,499,2,41282.76,NULL,'2023-10-12 14:23:44','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1187,7492,155,40787,102499,16,327,2,244770.68,NULL,'2023-10-12 14:23:44','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1188,7492,155,40787,102499,16,326,2,9355.06,NULL,'2023-10-12 14:23:44','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1189,7492,155,40787,102499,16,208,1,99083.81,NULL,'2023-10-12 14:23:44','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1190,7492,155,40787,102499,16,498,2,447.51,NULL,'2023-10-12 14:23:44','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1191,7492,155,40787,102499,16,75,2,89281.24,NULL,'2023-10-12 14:23:44','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1192,7492,156,40787,102487,20,14,2,1922543.52,NULL,'2023-10-12 14:39:07','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1193,7492,156,40787,102487,20,166,1,1922543.52,NULL,'2023-10-12 14:39:07','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (1194,7492,157,40787,102488,20,14,2,3904693.28,NULL,'2023-10-12 14:40:06','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1195,7492,157,40787,102488,20,166,1,3904693.28,NULL,'2023-10-12 14:40:06','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1196,7492,158,40787,102489,20,14,2,10927074.94,NULL,'2023-10-12 14:41:22','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1197,7492,158,40787,102489,20,166,1,10927074.94,NULL,'2023-10-12 14:41:22','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1198,7492,159,40787,102490,20,14,2,6413486.31,NULL,'2023-10-12 15:18:31','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1199,7492,159,40787,102490,20,166,1,6413486.31,NULL,'2023-10-12 15:18:31','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1200,7492,160,40787,102491,20,14,2,16154783.44,NULL,'2023-10-12 15:19:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1201,7492,160,40787,102491,20,166,1,16154783.44,NULL,'2023-10-12 15:19:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1202,7492,161,40787,102492,20,14,2,12731467.70,NULL,'2023-10-12 15:20:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1203,7492,161,40787,102492,20,166,1,12731467.70,NULL,'2023-10-12 15:20:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1204,7492,162,40787,102494,20,14,2,13767864.28,NULL,'2023-10-12 15:21:24','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1205,7492,162,40787,102494,20,166,1,13767864.28,NULL,'2023-10-12 15:21:24','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1206,7492,163,40787,102495,20,14,2,4019952.60,NULL,'2023-10-12 15:22:10','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1207,7492,163,40787,102495,20,166,1,4019952.60,NULL,'2023-10-12 15:22:10','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1208,7492,164,40787,102496,20,14,2,23436611.92,NULL,'2023-10-12 15:22:52','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1209,7492,164,40787,102496,20,166,1,23436611.92,NULL,'2023-10-12 15:22:52','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1210,7492,165,40787,102497,20,14,2,25019501.20,NULL,'2023-10-12 15:23:27','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1211,7492,165,40787,102497,20,166,1,25019501.20,NULL,'2023-10-12 15:23:27','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1212,7492,166,40787,102498,20,14,2,21385950.97,NULL,'2023-10-12 15:24:17','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1213,7492,166,40787,102498,20,166,1,21385950.97,NULL,'2023-10-12 15:24:17','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1214,7492,167,40787,102499,20,14,2,17443107.34,NULL,'2023-10-12 15:26:07','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1215,7492,167,40787,102499,20,166,1,17443107.34,NULL,'2023-10-12 15:26:07','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1216,7492,168,40787,102487,18,165,1,200000.00,NULL,'2023-10-12 15:28:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1217,7492,168,40787,102487,18,166,2,200000.00,NULL,'2023-10-12 15:28:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1218,7492,169,40787,102488,18,165,1,150000.00,NULL,'2023-10-12 15:29:14','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1219,7492,169,40787,102488,18,166,2,150000.00,NULL,'2023-10-12 15:29:14','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1220,7492,170,40787,102492,18,165,1,1556914.65,NULL,'2023-10-12 15:31:19','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1221,7492,170,40787,102492,18,166,2,1556914.65,NULL,'2023-10-12 15:31:19','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1222,7492,171,40787,102494,18,165,1,500000.00,NULL,'2023-10-12 15:33:24','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1223,7492,171,40787,102494,18,166,2,500000.00,NULL,'2023-10-12 15:33:24','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1224,7492,172,40787,102495,20,14,2,814018.23,NULL,'2023-10-12 15:34:09','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1225,7492,172,40787,102495,20,165,1,814018.23,NULL,'2023-10-12 15:34:09','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1226,7492,173,40787,102496,20,14,2,3629204.54,NULL,'2023-10-12 15:35:18','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (1227,7492,173,40787,102496,20,165,1,4429204.54,NULL,'2023-10-12 15:35:18','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1228,7492,173,40787,102496,20,166,2,800000.00,NULL,'2023-10-12 15:35:18','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1229,7492,174,40787,102498,18,165,1,300000.00,NULL,'2023-10-12 15:35:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1230,7492,174,40787,102498,18,166,2,300000.00,NULL,'2023-10-12 15:35:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1231,7492,175,40787,102499,20,165,1,4445403.53,NULL,'2023-10-12 15:37:41','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1232,7492,175,40787,102499,20,14,2,1519308.66,NULL,'2023-10-12 15:37:41','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1233,7492,175,40787,102499,20,166,2,250000.00,NULL,'2023-10-12 15:37:41','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1234,7492,175,40787,102499,20,386,2,2500000.00,NULL,'2023-10-12 15:37:41','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1235,7492,175,40787,102499,20,102,2,176094.87,NULL,'2023-10-12 15:37:41','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1236,7492,176,40787,102494,3,521,1,40320.00,NULL,'2023-10-12 15:45:12','2023-10-25 20:18:34','2023-10-25 20:18:34'),(1237,7492,176,40787,102494,3,504,1,285000.00,NULL,'2023-10-12 15:45:12','2023-10-25 20:18:34','2023-10-25 20:18:34'),(1238,7492,176,40787,102494,3,165,1,500000.00,NULL,'2023-10-12 15:45:12','2023-10-25 20:18:34','2023-10-25 20:18:34'),(1239,7492,176,40787,102494,3,193,1,100000.00,NULL,'2023-10-12 15:45:12','2023-10-25 20:18:34','2023-10-25 20:18:34'),(1240,7492,176,40787,102494,3,359,1,2400000.00,NULL,'2023-10-12 15:45:12','2023-10-25 20:18:34','2023-10-25 20:18:34'),(1241,7492,176,40787,102494,3,166,2,3325320.00,NULL,'2023-10-12 15:45:12','2023-10-25 20:18:34','2023-10-25 20:18:34'),(1394,7492,185,40787,102487,12,359,1,139313.91,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1395,7492,185,40787,102487,12,166,1,1150694.78,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1396,7492,185,40787,102487,12,165,1,27041.52,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1397,7492,185,40787,102487,12,13,1,1568953.87,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1398,7492,185,40787,102487,12,24,1,117867.73,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1399,7492,185,40787,102487,12,497,1,19410.03,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1400,7492,185,40787,102487,12,498,1,2222.19,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1401,7492,185,40787,102487,12,20,1,125777.75,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1402,7492,185,40787,102487,12,393,1,79594.84,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1403,7492,185,40787,102487,12,23,1,569083.29,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1404,7492,185,40787,102487,12,500,1,34.01,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1405,7492,185,40787,102487,12,485,1,49529.27,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1406,7492,185,40787,102487,12,508,1,1498.57,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1407,7492,185,40787,102487,12,162,1,72131.14,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1408,7492,185,40787,102487,12,73,1,207835.23,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1409,7492,185,40787,102487,12,252,1,594.72,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1410,7492,185,40787,102487,12,392,1,4197489.80,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1411,7492,185,40787,102487,12,419,1,2603305.79,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (1412,7492,185,40787,102487,12,363,1,589100.07,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1413,7492,185,40787,102487,12,484,1,3227.09,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1414,7492,185,40787,102487,12,383,2,11524705.60,NULL,'2023-10-20 14:37:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1415,7492,186,40787,102487,12,48,2,58910.10,NULL,'2023-10-20 14:39:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1416,7492,186,40787,102487,12,420,2,520661.16,NULL,'2023-10-20 14:39:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1417,7492,186,40787,102487,12,383,1,579571.26,NULL,'2023-10-20 14:39:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1418,7492,187,40787,102487,12,506,2,1140325.25,NULL,'2023-10-20 14:45:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1419,7492,187,40787,102487,12,1029,2,120977.18,NULL,'2023-10-20 14:45:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1420,7492,187,40787,102487,12,517,2,95714.44,NULL,'2023-10-20 14:45:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1421,7492,187,40787,102487,12,518,2,21740.64,NULL,'2023-10-20 14:45:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1422,7492,187,40787,102487,12,1027,2,1702.50,NULL,'2023-10-20 14:45:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1423,7492,187,40787,102487,12,516,2,595.36,NULL,'2023-10-20 14:45:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1424,7492,187,40787,102487,12,64,2,8528.66,NULL,'2023-10-20 14:45:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1425,7492,187,40787,102487,12,57,2,4842224.20,NULL,'2023-10-20 14:45:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1426,7492,187,40787,102487,12,62,2,874320.75,NULL,'2023-10-20 14:45:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1427,7492,187,40787,102487,12,63,2,334960.87,NULL,'2023-10-20 14:45:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1428,7492,187,40787,102487,12,411,2,606017.30,NULL,'2023-10-20 14:45:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1429,7492,187,40787,102487,12,369,2,100000.00,NULL,'2023-10-20 14:45:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1430,7492,187,40787,102487,12,88,2,54971.99,NULL,'2023-10-20 14:45:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1431,7492,187,40787,102487,12,381,2,64152.49,NULL,'2023-10-20 14:45:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1432,7492,187,40787,102487,12,383,2,860850.91,NULL,'2023-10-20 14:45:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1433,7492,187,40787,102487,12,92,2,1818051.89,NULL,'2023-10-20 14:45:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1434,7492,187,40787,102487,12,383,1,10945134.43,NULL,'2023-10-20 14:45:35','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1435,7492,188,40787,102494,21,20,1,3076.60,NULL,'2023-10-23 12:29:50','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1436,7492,188,40787,102494,21,74,1,1729723.68,NULL,'2023-10-23 12:29:50','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1437,7492,188,40787,102494,21,467,1,15760.00,NULL,'2023-10-23 12:29:50','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1438,7492,188,40787,102494,21,326,1,214217.64,NULL,'2023-10-23 12:29:50','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1439,7492,188,40787,102494,21,506,1,29884.13,NULL,'2023-10-23 12:29:50','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1440,7492,188,40787,102494,21,166,2,1992662.05,NULL,'2023-10-23 12:29:50','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1441,7492,189,40787,102494,19,485,1,726.30,NULL,'2023-10-23 12:32:18','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1442,7492,189,40787,102494,19,499,1,41303.56,NULL,'2023-10-23 12:32:18','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1443,7492,189,40787,102494,19,484,1,1296.00,NULL,'2023-10-23 12:32:18','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1444,7492,189,40787,102494,19,157,1,140846.43,NULL,'2023-10-23 12:32:18','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (1445,7492,189,40787,102494,19,166,2,184172.29,NULL,'2023-10-23 12:32:18','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1446,7492,190,40787,102495,3,135,1,2200.25,NULL,'2023-10-23 12:34:42','2023-11-05 10:46:28','2023-11-05 10:46:28'),(1447,7492,190,40787,102495,3,1028,1,132000.00,NULL,'2023-10-23 12:34:42','2023-11-05 10:46:28','2023-11-05 10:46:28'),(1448,7492,190,40787,102495,3,165,1,400000.00,NULL,'2023-10-23 12:34:42','2023-11-05 10:46:28','2023-11-05 10:46:28'),(1449,7492,190,40787,102495,3,521,1,50408.03,NULL,'2023-10-23 12:34:42','2023-11-05 10:46:28','2023-11-05 10:46:28'),(1450,7492,190,40787,102495,3,359,1,3600000.00,NULL,'2023-10-23 12:34:42','2023-11-05 10:46:28','2023-11-05 10:46:28'),(1451,7492,190,40787,102495,3,166,2,4184608.28,NULL,'2023-10-23 12:34:42','2023-11-05 10:46:28','2023-11-05 10:46:28'),(1452,7492,191,40787,102495,3,20,1,3076.60,NULL,'2023-10-23 12:35:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1453,7492,191,40787,102495,3,74,1,455510.86,NULL,'2023-10-23 12:35:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1454,7492,191,40787,102495,3,327,1,51238.38,NULL,'2023-10-23 12:35:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1455,7492,191,40787,102495,3,506,1,30513.72,NULL,'2023-10-23 12:35:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1456,7492,191,40787,102495,3,166,2,540339.56,NULL,'2023-10-23 12:35:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1457,7492,192,40787,102495,3,485,1,853.50,NULL,'2023-10-23 12:37:33','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1458,7492,192,40787,102495,3,499,1,11849.83,NULL,'2023-10-23 12:37:33','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1459,7492,192,40787,102495,3,484,1,1707.00,NULL,'2023-10-23 12:37:33','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1460,7492,192,40787,102495,3,157,1,69962.42,NULL,'2023-10-23 12:37:33','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1461,7492,192,40787,102495,3,166,2,84372.75,NULL,'2023-10-23 12:37:33','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1462,7492,193,40787,102496,3,521,1,48892.03,NULL,'2023-10-23 12:38:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1463,7492,193,40787,102496,3,165,1,800000.00,NULL,'2023-10-23 12:38:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1464,7492,193,40787,102496,3,359,1,9700000.00,NULL,'2023-10-23 12:38:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1465,7492,193,40787,102496,3,166,2,10548892.03,NULL,'2023-10-23 12:38:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1466,7492,194,40787,102496,3,20,1,3088.72,NULL,'2023-10-23 12:40:09','2023-10-25 13:09:00','2023-10-25 13:09:00'),(1467,7492,194,40787,102496,3,74,1,2123244.57,NULL,'2023-10-23 12:40:09','2023-10-25 13:09:00','2023-10-25 13:09:00'),(1468,7492,194,40787,102496,3,327,1,126087.14,NULL,'2023-10-23 12:40:09','2023-10-25 13:09:00','2023-10-25 13:09:00'),(1469,7492,194,40787,102496,3,506,1,31138.33,NULL,'2023-10-23 12:40:09','2023-10-25 13:09:00','2023-10-25 13:09:00'),(1470,7492,194,40787,102496,3,515,1,24590.03,NULL,'2023-10-23 12:40:09','2023-10-25 13:09:00','2023-10-25 13:09:00'),(1471,7492,194,40787,102496,3,166,2,2308148.79,NULL,'2023-10-23 12:40:09','2023-10-25 13:09:00','2023-10-25 13:09:00'),(1472,7492,195,40787,102496,3,485,1,1366.50,NULL,'2023-10-23 13:21:34','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1473,7492,195,40787,102496,3,499,1,70309.79,NULL,'2023-10-23 13:21:34','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1474,7492,195,40787,102496,3,484,1,2733.00,NULL,'2023-10-23 13:21:34','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1475,7492,195,40787,102496,3,157,1,243153.85,NULL,'2023-10-23 13:21:34','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1476,7492,195,40787,102496,3,166,2,317563.14,NULL,'2023-10-23 13:21:34','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1477,7492,196,40787,102497,3,1028,1,730000.00,NULL,'2023-10-23 13:23:35','2023-11-05 10:45:49','2023-11-05 10:45:49'),(1478,7492,196,40787,102497,3,135,1,26128.93,NULL,'2023-10-23 13:23:35','2023-11-05 10:45:49','2023-11-05 10:45:49');
INSERT INTO `balance_libro_details` VALUES (1479,7492,196,40787,102497,3,521,1,84341.03,NULL,'2023-10-23 13:23:35','2023-11-05 10:45:49','2023-11-05 10:45:49'),(1480,7492,196,40787,102497,3,359,1,10100000.00,NULL,'2023-10-23 13:23:35','2023-11-05 10:45:49','2023-11-05 10:45:49'),(1481,7492,196,40787,102497,3,166,2,10940469.96,NULL,'2023-10-23 13:23:35','2023-11-05 10:45:49','2023-11-05 10:45:49'),(1482,7492,197,40787,102497,3,20,1,3076.60,NULL,'2023-10-23 13:25:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1483,7492,197,40787,102497,3,74,1,462377.27,NULL,'2023-10-23 13:25:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1484,7492,197,40787,102497,3,327,1,326285.57,NULL,'2023-10-23 13:25:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1485,7492,197,40787,102497,3,506,1,34562.05,NULL,'2023-10-23 13:25:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1486,7492,197,40787,102497,3,166,2,826301.49,NULL,'2023-10-23 13:25:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1487,7492,198,40787,102497,3,485,1,1474.50,NULL,'2023-10-23 13:28:24','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1488,7492,198,40787,102497,3,499,1,75058.48,NULL,'2023-10-23 13:28:24','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1489,7492,198,40787,102497,3,157,1,268505.04,NULL,'2023-10-23 13:28:24','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1490,7492,198,40787,102497,3,166,2,347987.02,NULL,'2023-10-23 13:28:24','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1491,7492,198,40787,102497,3,484,1,2949.00,NULL,'2023-10-23 13:28:24','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1492,7492,199,40787,102498,3,1028,1,507000.00,NULL,'2023-10-23 13:30:03','2023-11-05 10:45:31','2023-11-05 10:45:31'),(1493,7492,199,40787,102498,3,521,1,47991.03,NULL,'2023-10-23 13:30:03','2023-11-05 10:45:31','2023-11-05 10:45:31'),(1494,7492,199,40787,102498,3,386,1,3000000.00,NULL,'2023-10-23 13:30:03','2023-11-05 10:45:31','2023-11-05 10:45:31'),(1495,7492,199,40787,102498,3,359,1,13200000.00,NULL,'2023-10-23 13:30:03','2023-11-05 10:45:31','2023-11-05 10:45:31'),(1496,7492,199,40787,102498,3,166,2,16754991.03,NULL,'2023-10-23 13:30:03','2023-11-05 10:45:31','2023-11-05 10:45:31'),(1497,7492,200,40787,102497,3,20,1,3076.70,NULL,'2023-10-23 13:33:13','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1498,7492,200,40787,102497,3,74,1,856351.00,NULL,'2023-10-23 13:33:13','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1499,7492,200,40787,102497,3,327,1,859780.05,NULL,'2023-10-23 13:33:13','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1500,7492,200,40787,102497,3,506,1,35996.66,NULL,'2023-10-23 13:33:13','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1501,7492,200,40787,102497,3,166,2,1755204.41,NULL,'2023-10-23 13:33:13','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1502,7492,201,40787,102497,3,1030,1,21723.78,NULL,'2023-10-23 13:33:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1503,7492,201,40787,102497,3,166,2,21723.78,NULL,'2023-10-23 13:33:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1504,7492,202,40787,102498,3,485,1,4521.00,NULL,'2023-10-23 13:35:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1505,7492,202,40787,102498,3,499,1,62563.13,NULL,'2023-10-23 13:35:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1506,7492,202,40787,102498,3,484,1,9042.00,NULL,'2023-10-23 13:35:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1507,7492,202,40787,102498,3,157,1,278123.46,NULL,'2023-10-23 13:35:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1508,7492,202,40787,102498,3,166,2,354249.59,NULL,'2023-10-23 13:35:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1509,7492,203,40787,102499,3,1028,1,555000.00,NULL,'2023-10-23 13:39:20','2023-11-05 10:36:26','2023-11-05 10:36:26'),(1510,7492,203,40787,102499,3,135,1,4792.85,NULL,'2023-10-23 13:39:20','2023-11-05 10:36:26','2023-11-05 10:36:26'),(1511,7492,203,40787,102499,3,521,1,62174.03,NULL,'2023-10-23 13:39:20','2023-11-05 10:36:26','2023-11-05 10:36:26'),(1512,7492,203,40787,102499,3,165,1,250000.00,NULL,'2023-10-23 13:39:20','2023-11-05 10:36:26','2023-11-05 10:36:26');
INSERT INTO `balance_libro_details` VALUES (1513,7492,203,40787,102499,3,359,1,6500000.00,NULL,'2023-10-23 13:39:20','2023-11-05 10:36:26','2023-11-05 10:36:26'),(1514,7492,203,40787,102499,3,20,1,3076.60,NULL,'2023-10-23 13:39:20','2023-11-05 10:36:26','2023-11-05 10:36:26'),(1515,7492,203,40787,102499,3,74,1,3601623.59,NULL,'2023-10-23 13:39:20','2023-11-05 10:36:26','2023-11-05 10:36:26'),(1516,7492,203,40787,102499,3,327,1,115841.99,NULL,'2023-10-23 13:39:20','2023-11-05 10:36:26','2023-11-05 10:36:26'),(1517,7492,203,40787,102499,3,506,1,36489.58,NULL,'2023-10-23 13:39:20','2023-11-05 10:36:26','2023-11-05 10:36:26'),(1518,7492,203,40787,102499,3,485,1,1678.50,NULL,'2023-10-23 13:39:20','2023-11-05 10:36:26','2023-11-05 10:36:26'),(1519,7492,203,40787,102499,3,499,1,38310.52,NULL,'2023-10-23 13:39:20','2023-11-05 10:36:26','2023-11-05 10:36:26'),(1520,7492,203,40787,102499,3,484,1,3753.00,NULL,'2023-10-23 13:39:20','2023-11-05 10:36:26','2023-11-05 10:36:26'),(1521,7492,203,40787,102499,3,157,1,174464.62,NULL,'2023-10-23 13:39:20','2023-11-05 10:36:26','2023-11-05 10:36:26'),(1522,7492,203,40787,102499,3,166,2,11347205.28,NULL,'2023-10-23 13:39:20','2023-11-05 10:36:26','2023-11-05 10:36:26'),(1523,7492,204,40787,102494,3,506,1,2835.82,NULL,'2023-10-23 13:41:45','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1524,7492,204,40787,102494,3,506,1,6331.35,NULL,'2023-10-23 13:41:45','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1525,7492,204,40787,102494,3,491,1,40559.79,NULL,'2023-10-23 13:41:45','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1526,7492,204,40787,102494,3,1029,1,6405.42,NULL,'2023-10-23 13:41:45','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1527,7492,204,40787,102494,3,135,1,108402.15,NULL,'2023-10-23 13:41:45','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1528,7492,204,40787,102494,3,165,2,164534.53,NULL,'2023-10-23 13:41:45','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1529,7492,205,40787,102494,3,1031,1,105440.00,NULL,'2023-10-23 13:43:22','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1530,7492,205,40787,102494,3,485,1,67.50,NULL,'2023-10-23 13:43:22','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1531,7492,205,40787,102494,3,157,1,3245.85,NULL,'2023-10-23 13:43:22','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1532,7492,205,40787,102494,3,499,1,6.48,NULL,'2023-10-23 13:43:22','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1533,7492,205,40787,102494,3,484,1,135.00,NULL,'2023-10-23 13:43:22','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1534,7492,205,40787,102494,3,165,2,108894.83,NULL,'2023-10-23 13:43:22','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1535,7492,206,40787,102495,3,506,1,2924.63,NULL,'2023-10-23 13:46:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1536,7492,206,40787,102495,3,506,1,6403.48,NULL,'2023-10-23 13:46:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1537,7492,206,40787,102495,3,1029,1,6367.22,NULL,'2023-10-23 13:46:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1538,7492,206,40787,102495,3,491,1,43889.75,NULL,'2023-10-23 13:46:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1539,7492,206,40787,102495,3,135,1,753.26,NULL,'2023-10-23 13:46:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1540,7492,206,40787,102495,3,166,1,70000.00,NULL,'2023-10-23 13:46:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1541,7492,206,40787,102495,3,485,1,67.50,NULL,'2023-10-23 13:46:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1542,7492,206,40787,102495,3,484,1,135.00,NULL,'2023-10-23 13:46:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1543,7492,206,40787,102495,3,499,1,1242.05,NULL,'2023-10-23 13:46:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1544,7492,206,40787,102495,3,157,1,6701.93,NULL,'2023-10-23 13:46:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1545,7492,206,40787,102495,3,165,2,138484.82,NULL,'2023-10-23 13:46:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1546,7492,207,40787,102496,3,506,1,6597.93,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (1547,7492,207,40787,102496,3,506,1,3013.44,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1548,7492,208,40787,102496,3,506,1,6597.93,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1549,7492,207,40787,102496,3,491,1,47251.70,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1550,7492,208,40787,102496,3,506,1,3013.44,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1551,7492,207,40787,102496,3,506,1,6367.22,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1552,7492,208,40787,102496,3,491,1,47251.70,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1553,7492,207,40787,102496,3,135,1,141223.20,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1554,7492,208,40787,102496,3,506,1,6367.22,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1555,7492,207,40787,102496,3,485,1,67.50,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1556,7492,208,40787,102496,3,135,1,141223.20,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1557,7492,207,40787,102496,3,499,1,10900.94,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1558,7492,208,40787,102496,3,485,1,67.50,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1559,7492,207,40787,102496,3,484,1,135.00,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1560,7492,208,40787,102496,3,499,1,10900.94,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1561,7492,207,40787,102496,3,157,1,27386.98,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1562,7492,208,40787,102496,3,484,1,135.00,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1563,7492,207,40787,102496,3,165,2,242943.91,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1564,7492,208,40787,102496,3,157,1,27386.98,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1565,7492,208,40787,102496,3,165,2,242943.91,NULL,'2023-10-23 13:59:02','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1566,7492,209,40787,102497,3,506,1,3102.25,NULL,'2023-10-23 14:04:07','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1567,7492,209,40787,102497,3,506,1,6792.38,NULL,'2023-10-23 14:04:07','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1568,7492,209,40787,102497,3,1029,1,6367.22,NULL,'2023-10-23 14:04:07','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1569,7492,209,40787,102497,3,491,1,48366.84,NULL,'2023-10-23 14:04:07','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1570,7492,209,40787,102497,3,135,1,214148.88,NULL,'2023-10-23 14:04:07','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1571,7492,209,40787,102497,3,485,1,67.50,NULL,'2023-10-23 14:04:07','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1572,7492,209,40787,102497,3,157,1,3813.83,NULL,'2023-10-23 14:04:07','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1573,7492,209,40787,102497,3,499,1,108.00,NULL,'2023-10-23 14:04:07','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1574,7492,209,40787,102497,3,484,1,135.00,NULL,'2023-10-23 14:04:07','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1575,7492,209,40787,102497,3,165,2,354701.90,NULL,'2023-10-23 14:04:07','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1576,7492,209,40787,102497,3,1031,1,71800.00,NULL,'2023-10-23 14:04:07','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1577,7492,210,40787,102498,3,506,1,6986.83,NULL,'2023-10-23 14:07:33','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1578,7492,210,40787,102498,3,506,1,3191.06,NULL,'2023-10-23 14:07:33','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1579,7492,210,40787,102498,3,1029,1,6367.22,NULL,'2023-10-23 14:07:33','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1580,7492,210,40787,102498,3,491,1,50669.11,NULL,'2023-10-23 14:07:33','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (1581,7492,210,40787,102498,3,386,1,2500000.00,NULL,'2023-10-23 14:07:33','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1582,7492,210,40787,102498,3,135,1,43402.78,NULL,'2023-10-23 14:07:33','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1583,7492,210,40787,102498,3,485,1,67.50,NULL,'2023-10-23 14:07:33','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1584,7492,210,40787,102498,3,499,1,311.21,NULL,'2023-10-23 14:07:33','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1585,7492,210,40787,102498,3,484,1,135.00,NULL,'2023-10-23 14:07:33','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1586,7492,210,40787,102498,3,157,1,4974.65,NULL,'2023-10-23 14:07:33','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1587,7492,210,40787,102498,3,165,2,2616105.36,NULL,'2023-10-23 14:07:33','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1588,7492,211,40787,102499,3,506,1,3310.51,NULL,'2023-10-23 14:13:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1589,7492,211,40787,102499,3,506,1,7248.37,NULL,'2023-10-23 14:13:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1590,7492,211,40787,102499,3,1029,1,6367.22,NULL,'2023-10-23 14:13:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1591,7492,211,40787,102499,3,491,1,53450.84,NULL,'2023-10-23 14:13:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1592,7492,211,40787,102499,3,135,1,78856.00,NULL,'2023-10-23 14:13:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1593,7492,211,40787,102499,3,1031,1,15356.00,NULL,'2023-10-23 14:13:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1594,7492,211,40787,102499,3,166,1,2000000.00,NULL,'2023-10-23 14:13:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1595,7492,211,40787,102499,3,485,1,85.50,NULL,'2023-10-23 14:13:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1596,7492,211,40787,102499,3,484,1,171.00,NULL,'2023-10-23 14:13:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1597,7492,211,40787,102499,3,157,1,23690.16,NULL,'2023-10-23 14:13:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1598,7492,211,40787,102499,3,499,1,4566.93,NULL,'2023-10-23 14:13:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1599,7492,211,40787,102499,3,165,2,2193102.53,NULL,'2023-10-23 14:13:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1600,7492,212,40787,102487,3,521,1,100770.00,NULL,'2023-10-23 14:18:49','2023-11-05 10:48:58','2023-11-05 10:48:58'),(1601,7492,212,40787,102487,3,1028,1,288000.00,NULL,'2023-10-23 14:18:49','2023-11-05 10:48:58','2023-11-05 10:48:58'),(1602,7492,212,40787,102487,3,165,1,150000.00,NULL,'2023-10-23 14:18:49','2023-11-05 10:48:58','2023-11-05 10:48:58'),(1603,7492,212,40787,102487,3,359,1,930000.00,NULL,'2023-10-23 14:18:49','2023-11-05 10:48:58','2023-11-05 10:48:58'),(1604,7492,212,40787,102487,3,483,1,37500.00,NULL,'2023-10-23 14:18:49','2023-11-05 10:48:58','2023-11-05 10:48:58'),(1605,7492,212,40787,102487,3,166,2,1506270.00,NULL,'2023-10-23 14:18:49','2023-11-05 10:48:58','2023-11-05 10:48:58'),(1606,7492,213,40787,102487,3,1030,1,5745.30,NULL,'2023-10-23 14:25:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1607,7492,213,40787,102487,3,506,1,27194.50,NULL,'2023-10-23 14:25:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1608,7492,213,40787,102487,3,25,1,9007.74,NULL,'2023-10-23 14:25:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1609,7492,213,40787,102487,3,23,1,2573.64,NULL,'2023-10-23 14:25:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1610,7492,213,40787,102487,3,485,1,361.75,NULL,'2023-10-23 14:25:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1611,7492,213,40787,102487,3,499,1,7379.77,NULL,'2023-10-23 14:25:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1612,7492,213,40787,102487,3,157,1,17579.38,NULL,'2023-10-23 14:25:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1613,7492,213,40787,102487,3,484,1,700.50,NULL,'2023-10-23 14:25:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1614,7492,213,40787,102487,3,166,2,70542.58,NULL,'2023-10-23 14:25:55','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (1615,7492,214,40787,102488,3,135,1,200000.00,NULL,'2023-10-23 14:29:32','2023-11-05 10:48:36','2023-11-05 10:48:36'),(1616,7492,214,40787,102488,3,521,1,135623.00,NULL,'2023-10-23 14:29:32','2023-11-05 10:48:36','2023-11-05 10:48:36'),(1617,7492,214,40787,102488,3,492,1,40955.91,NULL,'2023-10-23 14:29:32','2023-11-05 10:48:36','2023-11-05 10:48:36'),(1618,7492,214,40787,102488,3,135,1,1499.00,NULL,'2023-10-23 14:29:32','2023-11-05 10:48:36','2023-11-05 10:48:36'),(1619,7492,214,40787,102488,3,165,1,150000.00,NULL,'2023-10-23 14:29:32','2023-11-05 10:48:36','2023-11-05 10:48:36'),(1620,7492,214,40787,102488,3,359,1,900000.00,NULL,'2023-10-23 14:29:32','2023-11-05 10:48:36','2023-11-05 10:48:36'),(1621,7492,214,40787,102488,3,20,1,17189.77,NULL,'2023-10-23 14:29:32','2023-11-05 10:48:36','2023-11-05 10:48:36'),(1622,7492,214,40787,102488,3,506,1,27625.36,NULL,'2023-10-23 14:29:32','2023-11-05 10:48:36','2023-11-05 10:48:36'),(1623,7492,214,40787,102488,3,25,1,15495.85,NULL,'2023-10-23 14:29:32','2023-11-05 10:48:36','2023-11-05 10:48:36'),(1624,7492,214,40787,102488,3,23,1,4427.38,NULL,'2023-10-23 14:29:32','2023-11-05 10:48:36','2023-11-05 10:48:36'),(1625,7492,214,40787,102488,3,485,1,260.25,NULL,'2023-10-23 14:29:32','2023-11-05 10:48:36','2023-11-05 10:48:36'),(1626,7492,214,40787,102488,3,157,1,38728.70,NULL,'2023-10-23 14:29:32','2023-11-05 10:48:36','2023-11-05 10:48:36'),(1627,7492,214,40787,102488,3,1028,1,110216.00,NULL,'2023-10-23 14:29:32','2023-11-05 10:48:36','2023-11-05 10:48:36'),(1628,7492,214,40787,102488,3,166,2,1642021.22,NULL,'2023-10-23 14:29:32','2023-11-05 10:48:36','2023-11-05 10:48:36'),(1629,7492,215,40787,102488,3,506,1,28056.23,NULL,'2023-10-23 14:34:59','2023-10-23 14:49:38','2023-10-23 14:49:38'),(1630,7492,215,40787,102488,3,495,1,3750.00,NULL,'2023-10-23 14:34:59','2023-10-23 14:49:38','2023-10-23 14:49:38'),(1631,7492,215,40787,102488,3,521,1,153562.00,NULL,'2023-10-23 14:34:59','2023-10-23 14:49:38','2023-10-23 14:49:38'),(1632,7492,215,40787,102488,3,483,1,30000.00,NULL,'2023-10-23 14:34:59','2023-10-23 14:49:38','2023-10-23 14:49:38'),(1633,7492,215,40787,102488,3,492,1,20487.69,NULL,'2023-10-23 14:34:59','2023-10-23 14:49:38','2023-10-23 14:49:38'),(1634,7492,215,40787,102488,3,1028,1,121200.00,NULL,'2023-10-23 14:34:59','2023-10-23 14:49:38','2023-10-23 14:49:38'),(1635,7492,215,40787,102488,3,165,1,140000.00,NULL,'2023-10-23 14:34:59','2023-10-23 14:49:38','2023-10-23 14:49:38'),(1636,7492,215,40787,102488,3,359,1,1806000.00,NULL,'2023-10-23 14:34:59','2023-10-23 14:49:38','2023-10-23 14:49:38'),(1637,7492,215,40787,102488,3,20,1,16766.54,NULL,'2023-10-23 14:34:59','2023-10-23 14:49:38','2023-10-23 14:49:38'),(1638,7492,215,40787,102488,3,74,1,1793189.08,NULL,'2023-10-23 14:34:59','2023-10-23 14:49:38','2023-10-23 14:49:38'),(1639,7492,215,40787,102488,3,506,1,28056.23,NULL,'2023-10-23 14:34:59','2023-10-23 14:49:38','2023-10-23 14:49:38'),(1640,7492,215,40787,102488,3,25,1,36956.56,NULL,'2023-10-23 14:34:59','2023-10-23 14:49:38','2023-10-23 14:49:38'),(1641,7492,215,40787,102488,3,467,1,160071.00,NULL,'2023-10-23 14:34:59','2023-10-23 14:49:38','2023-10-23 14:49:38'),(1642,7492,215,40787,102488,3,485,1,516.15,NULL,'2023-10-23 14:34:59','2023-10-23 14:49:38','2023-10-23 14:49:38'),(1643,7492,215,40787,102488,3,484,1,720.00,NULL,'2023-10-23 14:34:59','2023-10-23 14:49:38','2023-10-23 14:49:38'),(1644,7492,215,40787,102488,3,157,1,86110.30,NULL,'2023-10-23 14:34:59','2023-10-23 14:49:38','2023-10-23 14:49:38'),(1645,7492,215,40787,102488,3,166,2,4425441.78,NULL,'2023-10-23 14:34:59','2023-10-23 14:49:38','2023-10-23 14:49:38'),(1646,7492,216,40787,102489,3,506,1,28056.23,NULL,'2023-10-23 14:49:38','2023-11-05 10:48:12','2023-11-05 10:48:12'),(1647,7492,216,40787,102489,3,495,1,3750.00,NULL,'2023-10-23 14:49:38','2023-11-05 10:48:12','2023-11-05 10:48:12'),(1648,7492,216,40787,102489,3,521,1,153562.00,NULL,'2023-10-23 14:49:38','2023-11-05 10:48:12','2023-11-05 10:48:12');
INSERT INTO `balance_libro_details` VALUES (1649,7492,216,40787,102489,3,483,1,30000.00,NULL,'2023-10-23 14:49:38','2023-11-05 10:48:12','2023-11-05 10:48:12'),(1650,7492,216,40787,102489,3,492,1,20487.69,NULL,'2023-10-23 14:49:38','2023-11-05 10:48:12','2023-11-05 10:48:12'),(1651,7492,216,40787,102489,3,1028,1,121200.00,NULL,'2023-10-23 14:49:38','2023-11-05 10:48:12','2023-11-05 10:48:12'),(1652,7492,216,40787,102489,3,165,1,140000.00,NULL,'2023-10-23 14:49:38','2023-11-05 10:48:12','2023-11-05 10:48:12'),(1653,7492,216,40787,102489,3,359,1,1806000.00,NULL,'2023-10-23 14:49:38','2023-11-05 10:48:12','2023-11-05 10:48:12'),(1654,7492,216,40787,102489,3,20,1,16766.54,NULL,'2023-10-23 14:49:38','2023-11-05 10:48:12','2023-11-05 10:48:12'),(1655,7492,216,40787,102489,3,74,1,1793189.08,NULL,'2023-10-23 14:49:38','2023-11-05 10:48:12','2023-11-05 10:48:12'),(1656,7492,216,40787,102489,3,506,1,28056.23,NULL,'2023-10-23 14:49:38','2023-11-05 10:48:12','2023-11-05 10:48:12'),(1657,7492,216,40787,102489,3,25,1,36956.56,NULL,'2023-10-23 14:49:38','2023-11-05 10:48:12','2023-11-05 10:48:12'),(1658,7492,216,40787,102489,3,467,1,160071.00,NULL,'2023-10-23 14:49:38','2023-11-05 10:48:12','2023-11-05 10:48:12'),(1659,7492,216,40787,102489,3,485,1,516.15,NULL,'2023-10-23 14:49:38','2023-11-05 10:48:12','2023-11-05 10:48:12'),(1660,7492,216,40787,102489,3,484,1,720.00,NULL,'2023-10-23 14:49:38','2023-11-05 10:48:12','2023-11-05 10:48:12'),(1661,7492,216,40787,102489,3,157,1,86110.30,NULL,'2023-10-23 14:49:38','2023-11-05 10:48:12','2023-11-05 10:48:12'),(1662,7492,216,40787,102489,3,166,2,4425441.78,NULL,'2023-10-23 14:49:38','2023-11-05 10:48:12','2023-11-05 10:48:12'),(1663,7492,217,40787,102503,3,492,1,20184.17,NULL,'2023-10-23 15:30:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1664,7492,217,40787,102503,3,521,1,1595.13,NULL,'2023-10-23 15:30:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1665,7492,217,40787,102503,3,483,1,37500.00,NULL,'2023-10-23 15:30:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1666,7492,217,40787,102503,3,135,1,146070.00,NULL,'2023-10-23 15:30:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1667,7492,217,40787,102503,3,1028,1,223500.00,NULL,'2023-10-23 15:30:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1668,7492,217,40787,102503,3,165,1,230000.00,NULL,'2023-10-23 15:30:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1669,7492,217,40787,102503,3,359,1,3250000.00,NULL,'2023-10-23 15:30:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1670,7492,217,40787,102503,3,20,1,33950.23,NULL,'2023-10-23 15:30:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1671,7492,217,40787,102503,3,74,1,821847.22,NULL,'2023-10-23 15:30:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1672,7492,217,40787,102503,3,506,1,28487.10,NULL,'2023-10-23 15:30:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1673,7492,217,40787,102503,3,23,1,8136.72,NULL,'2023-10-23 15:30:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1674,7492,217,40787,102503,3,485,1,570.00,NULL,'2023-10-23 15:30:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1675,7492,217,40787,102503,3,499,1,16319.76,NULL,'2023-10-23 15:30:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1676,7492,217,40787,102503,3,484,1,1998.74,NULL,'2023-10-23 15:30:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1677,7492,217,40787,102503,3,157,1,87600.92,NULL,'2023-10-23 15:30:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1678,7492,217,40787,102503,3,166,2,4907759.99,NULL,'2023-10-23 15:30:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1679,7492,218,40787,102504,3,521,1,159126.00,NULL,'2023-10-23 15:36:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1680,7492,218,40787,102504,3,483,1,33500.00,NULL,'2023-10-23 15:36:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1681,7492,218,40787,102504,3,198,1,19553.17,NULL,'2023-10-23 15:36:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1682,7492,218,40787,102504,3,1028,1,182112.00,NULL,'2023-10-23 15:36:53','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (1683,7492,218,40787,102504,3,165,1,400000.00,NULL,'2023-10-23 15:36:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1684,7492,218,40787,102504,3,359,1,6330000.00,NULL,'2023-10-23 15:36:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1685,7492,218,40787,102504,3,74,1,1241298.43,NULL,'2023-10-23 15:36:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1686,7492,218,40787,102504,3,506,1,28917.37,NULL,'2023-10-23 15:36:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1687,7492,218,40787,102504,3,23,1,2678.73,NULL,'2023-10-23 15:36:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1688,7492,218,40787,102504,3,25,1,9375.55,NULL,'2023-10-23 15:36:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1689,7492,218,40787,102504,3,485,1,1606.50,NULL,'2023-10-23 15:36:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1690,7492,218,40787,102504,3,499,1,51384.97,NULL,'2023-10-23 15:36:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1691,7492,218,40787,102504,3,484,1,3213.00,NULL,'2023-10-23 15:36:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1692,7492,218,40787,102504,3,157,1,176663.29,NULL,'2023-10-23 15:36:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1693,7492,218,40787,102504,3,166,2,8639429.01,NULL,'2023-10-23 15:36:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1694,7492,219,40787,102505,3,521,1,174860.03,NULL,'2023-10-23 15:41:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1695,7492,219,40787,102505,3,135,1,93694.81,NULL,'2023-10-23 15:41:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1696,7492,219,40787,102505,3,492,1,19554.03,NULL,'2023-10-23 15:41:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1697,7492,219,40787,102505,3,1028,1,162000.00,NULL,'2023-10-23 15:41:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1698,7492,219,40787,102505,3,359,1,7600000.00,NULL,'2023-10-23 15:41:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1699,7492,219,40787,102505,3,165,1,200000.00,NULL,'2023-10-23 15:41:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1700,7492,219,40787,102505,3,20,1,9251.29,NULL,'2023-10-23 15:41:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1701,7492,219,40787,102505,3,74,1,1000000.00,NULL,'2023-10-23 15:41:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1702,7492,219,40787,102505,3,506,1,29403.54,NULL,'2023-10-23 15:41:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1703,7492,219,40787,102505,3,23,1,2693.70,NULL,'2023-10-23 15:41:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1704,7492,219,40787,102505,3,25,1,9427.95,NULL,'2023-10-23 15:41:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1705,7492,219,40787,102505,3,485,1,1687.50,NULL,'2023-10-23 15:41:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1706,7492,219,40787,102505,3,499,1,38194.36,NULL,'2023-10-23 15:41:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1707,7492,219,40787,102505,3,157,1,156261.05,NULL,'2023-10-23 15:41:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1708,7492,219,40787,102505,3,166,2,9500403.26,NULL,'2023-10-23 15:41:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1709,7492,219,40787,102505,3,484,1,3375.00,NULL,'2023-10-23 15:41:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1710,7492,220,40787,102487,3,506,1,5294.32,NULL,'2023-10-23 15:44:52','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1711,7492,220,40787,102487,3,1029,1,6367.22,NULL,'2023-10-23 15:44:52','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1712,7492,220,40787,102487,3,506,1,2418.05,NULL,'2023-10-23 15:44:52','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1713,7492,220,40787,102487,3,491,1,29603.39,NULL,'2023-10-23 15:44:52','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1714,7492,220,40787,102487,3,135,1,38790.00,NULL,'2023-10-23 15:44:52','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1715,7492,220,40787,102487,3,485,1,42.00,NULL,'2023-10-23 15:44:52','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1716,7492,220,40787,102487,3,157,1,1226.50,NULL,'2023-10-23 15:44:52','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (1717,7492,220,40787,102487,3,484,1,84.00,NULL,'2023-10-23 15:44:52','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1718,7492,220,40787,102487,3,165,2,83825.48,NULL,'2023-10-23 15:44:52','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1719,7492,221,40787,102488,3,506,1,5425.77,NULL,'2023-10-23 15:51:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1720,7492,221,40787,102488,3,506,1,2478.08,NULL,'2023-10-23 15:51:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1721,7492,221,40787,102488,3,491,1,32733.58,NULL,'2023-10-23 15:51:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1722,7492,221,40787,102488,3,135,1,19790.00,NULL,'2023-10-23 15:51:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1723,7492,221,40787,102488,3,485,1,42.00,NULL,'2023-10-23 15:51:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1724,7492,221,40787,102488,3,157,1,850.20,NULL,'2023-10-23 15:51:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1725,7492,221,40787,102488,3,484,1,84.00,NULL,'2023-10-23 15:51:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1726,7492,221,40787,102488,3,1029,1,6367.22,NULL,'2023-10-23 15:51:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1727,7492,221,40787,102488,3,165,2,67770.85,NULL,'2023-10-23 15:51:40','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1728,7492,222,40787,102489,3,506,1,5557.22,NULL,'2023-10-23 15:55:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1729,7492,222,40787,102489,3,506,1,2538.13,NULL,'2023-10-23 15:55:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1730,7492,222,40787,102489,3,1029,1,6367.22,NULL,'2023-10-23 15:55:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1731,7492,222,40787,102489,3,491,1,32801.76,NULL,'2023-10-23 15:55:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1732,7492,222,40787,102489,3,485,1,42.00,NULL,'2023-10-23 15:55:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1733,7492,222,40787,102489,3,157,1,951.37,NULL,'2023-10-23 15:55:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1734,7492,222,40787,102489,3,484,1,84.00,NULL,'2023-10-23 15:55:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1735,7492,222,40787,102489,3,165,2,48341.70,NULL,'2023-10-23 15:55:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1736,7492,223,40787,102490,3,1029,1,6367.22,NULL,'2023-10-23 15:57:38','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1737,7492,223,40787,102490,3,506,1,2598.16,NULL,'2023-10-23 15:57:38','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1738,7492,223,40787,102490,3,506,1,5688.67,NULL,'2023-10-23 15:57:38','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1739,7492,223,40787,102490,3,135,1,44399.85,NULL,'2023-10-23 15:57:38','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1740,7492,223,40787,102490,3,485,1,4200.00,NULL,'2023-10-23 15:57:38','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1741,7492,223,40787,102490,3,157,1,1219.85,NULL,'2023-10-23 15:57:38','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1742,7492,223,40787,102490,3,484,1,84.00,NULL,'2023-10-23 15:57:38','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1743,7492,223,40787,102490,3,165,2,64557.75,NULL,'2023-10-23 15:57:38','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1744,7492,224,40787,102491,3,506,1,5820.12,NULL,'2023-10-23 15:59:39','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1745,7492,224,40787,102491,3,506,1,2658.20,NULL,'2023-10-23 15:59:39','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1746,7492,224,40787,102491,3,1029,1,6367.22,NULL,'2023-10-23 15:59:39','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1747,7492,224,40787,102491,3,491,1,76618.81,NULL,'2023-10-23 15:59:39','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1748,7492,224,40787,102491,3,135,1,29650.00,NULL,'2023-10-23 15:59:39','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1749,7492,224,40787,102491,3,485,1,42.00,NULL,'2023-10-23 15:59:39','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1750,7492,224,40787,102491,3,484,1,84.00,NULL,'2023-10-23 15:59:39','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (1751,7492,224,40787,102491,3,157,1,2634.69,NULL,'2023-10-23 15:59:39','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1752,7492,224,40787,102491,3,165,2,123875.04,NULL,'2023-10-23 15:59:39','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1753,7492,225,40787,102492,3,506,1,2747.01,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1754,7492,225,40787,102492,3,506,1,6014.57,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1755,7492,225,40787,102492,3,1029,1,6367.22,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1756,7492,225,40787,102492,3,491,1,37349.43,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1757,7492,225,40787,102492,3,135,1,52465.00,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1758,7492,225,40787,102492,3,485,1,67.50,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1759,7492,225,40787,102492,3,484,1,135.00,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1760,7492,225,40787,102492,3,165,2,112917.26,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1761,7492,225,40787,102492,3,157,1,6370.78,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1762,7492,225,40787,102492,3,499,1,1400.75,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1763,7492,226,40787,102492,3,506,1,2747.01,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1764,7492,226,40787,102492,3,506,1,6014.57,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1765,7492,226,40787,102492,3,1029,1,6367.22,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1766,7492,226,40787,102492,3,491,1,37349.43,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1767,7492,226,40787,102492,3,135,1,52465.00,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1768,7492,226,40787,102492,3,485,1,67.50,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1769,7492,226,40787,102492,3,484,1,135.00,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1770,7492,226,40787,102492,3,165,2,112917.26,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1771,7492,226,40787,102492,3,157,1,6370.78,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1772,7492,226,40787,102492,3,499,1,1400.75,NULL,'2023-10-23 16:01:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1773,7492,227,40787,102499,19,166,1,3204497.27,NULL,'2023-10-24 12:39:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1774,7492,227,40787,102499,19,386,2,3000000.00,NULL,'2023-10-24 12:39:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1775,7492,227,40787,102499,19,102,2,204497.27,NULL,'2023-10-24 12:39:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1776,7492,228,40787,102490,5,1028,1,223500.00,NULL,'2023-10-24 12:55:34','2023-11-05 10:47:45','2023-11-05 10:47:45'),(1777,7492,228,40787,102490,5,165,2,223500.00,NULL,'2023-10-24 12:55:34','2023-11-05 10:47:45','2023-11-05 10:47:45'),(1778,7492,229,40787,102491,5,1028,1,182112.00,NULL,'2023-10-24 12:56:12','2023-11-05 10:47:27','2023-11-05 10:47:27'),(1779,7492,229,40787,102491,5,165,2,182112.00,NULL,'2023-10-24 12:56:12','2023-11-05 10:47:27','2023-11-05 10:47:27'),(1780,7492,230,40787,102492,5,1028,1,162000.00,NULL,'2023-10-24 12:57:11','2023-11-05 10:47:04','2023-11-05 10:47:04'),(1781,7492,230,40787,102492,5,165,2,162000.00,NULL,'2023-10-24 12:57:11','2023-11-05 10:47:04','2023-11-05 10:47:04'),(1782,7492,231,40787,102494,5,1028,1,285000.00,NULL,'2023-10-24 12:57:45','2023-11-05 10:46:48','2023-11-05 10:46:48'),(1783,7492,231,40787,102494,5,165,2,285000.00,NULL,'2023-10-24 12:57:45','2023-11-05 10:46:48','2023-11-05 10:46:48'),(1784,7492,232,40787,102496,19,1028,1,214000.00,NULL,'2023-10-24 13:00:05','2023-11-05 10:46:09','2023-11-05 10:46:09');
INSERT INTO `balance_libro_details` VALUES (1785,7492,232,40787,102496,19,165,2,214000.00,NULL,'2023-10-24 13:00:05','2023-11-05 10:46:09','2023-11-05 10:46:09'),(1786,7492,233,40787,102499,21,193,1,1090700.17,NULL,'2023-10-24 13:06:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1787,7492,233,40787,102499,21,57,2,1090700.17,NULL,'2023-10-24 13:06:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1788,7492,234,40787,102499,18,165,1,3024068.98,NULL,'2023-10-24 13:10:36','2023-10-25 12:57:05','2023-10-25 12:57:05'),(1789,7492,234,40787,102499,18,166,2,3024068.98,NULL,'2023-10-24 13:10:36','2023-10-25 12:57:05','2023-10-25 12:57:05'),(1790,7492,235,40787,102487,18,14,1,1568953.87,NULL,'2023-10-24 13:19:56','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1791,7492,235,40787,102487,18,13,2,1568953.87,NULL,'2023-10-24 13:19:56','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1792,7492,236,40787,102491,10,411,1,606017.30,NULL,'2023-10-25 12:50:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1793,7492,236,40787,102491,10,23,2,569083.29,NULL,'2023-10-25 12:50:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1794,7492,236,40787,102491,10,20,2,188657.19,NULL,'2023-10-25 12:50:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1795,7492,236,40787,102491,10,393,2,79594.84,NULL,'2023-10-25 12:50:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1796,7492,236,40787,102491,10,24,1,231318.02,NULL,'2023-10-25 12:50:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1797,7492,237,40787,102499,18,165,1,3523796.50,NULL,'2023-10-25 12:58:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1798,7492,237,40787,102499,18,166,2,3523796.50,NULL,'2023-10-25 12:58:26','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1799,7492,238,40787,102496,3,20,1,3076.60,NULL,'2023-10-25 13:09:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1800,7492,238,40787,102496,3,74,1,2123244.57,NULL,'2023-10-25 13:09:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1801,7492,238,40787,102496,3,327,1,126087.14,NULL,'2023-10-25 13:09:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1802,7492,238,40787,102496,3,506,1,31138.33,NULL,'2023-10-25 13:09:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1803,7492,238,40787,102496,3,515,1,24590.03,NULL,'2023-10-25 13:09:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1804,7492,238,40787,102496,3,166,2,2308148.79,NULL,'2023-10-25 13:09:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1805,7492,238,40787,102496,3,140,1,12.12,NULL,'2023-10-25 13:09:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1806,7492,239,40787,102499,10,20,1,38144.41,NULL,'2023-10-25 13:12:33','2023-10-25 13:14:14','2023-10-25 13:14:14'),(1807,7492,239,40787,102499,10,166,2,38144.41,NULL,'2023-10-25 13:12:33','2023-10-25 13:14:14','2023-10-25 13:14:14'),(1808,7492,240,40787,102499,10,20,1,38156.53,NULL,'2023-10-25 13:14:14','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1809,7492,240,40787,102499,10,166,2,38156.53,NULL,'2023-10-25 13:14:14','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1810,7492,241,40787,102499,18,359,2,1411725.04,NULL,'2023-10-25 13:19:11','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1811,7492,241,40787,102499,18,162,1,1411725.04,NULL,'2023-10-25 13:19:11','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1812,7492,242,40787,102499,15,74,1,585312.48,NULL,'2023-10-25 15:43:38','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1813,7492,242,40787,102499,15,68,1,331859.14,NULL,'2023-10-25 15:43:38','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1814,7492,242,40787,102499,15,25,2,61460.15,NULL,'2023-10-25 15:43:38','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1815,7492,242,40787,102499,15,509,1,456305.62,NULL,'2023-10-25 15:43:38','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1816,7492,242,40787,102499,15,353,2,251459.62,NULL,'2023-10-25 15:43:38','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1817,7492,242,40787,102499,15,354,1,2898.23,NULL,'2023-10-25 15:43:38','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (1818,7492,242,40787,102499,15,484,2,27798.59,NULL,'2023-10-25 15:43:38','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1819,7492,242,40787,102499,15,67,2,0.10,NULL,'2023-10-25 15:43:38','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1820,7492,242,40787,102499,15,73,2,207835.23,NULL,'2023-10-25 15:43:38','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1821,7492,242,40787,102499,15,166,2,827821.78,NULL,'2023-10-25 15:43:38','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1822,7492,243,40787,102499,19,1032,1,91852072.71,NULL,'2023-10-25 16:09:12','2023-11-05 11:10:41','2023-11-05 11:10:41'),(1823,7492,243,40787,102499,19,392,2,34731363.83,NULL,'2023-10-25 16:09:12','2023-11-05 11:10:41','2023-11-05 11:10:41'),(1824,7492,243,40787,102499,19,166,2,32700908.46,NULL,'2023-10-25 16:09:12','2023-11-05 11:10:41','2023-11-05 11:10:41'),(1825,7492,243,40787,102499,19,359,2,24419800.42,NULL,'2023-10-25 16:09:12','2023-11-05 11:10:41','2023-11-05 11:10:41'),(1826,7492,244,40787,102499,19,359,1,20309457.46,NULL,'2023-10-25 16:14:27','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1827,7492,244,40787,102499,19,14,2,20309457.46,NULL,'2023-10-25 16:14:27','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1828,7492,245,40787,102499,4,48,1,68779.25,NULL,'2023-10-25 16:20:21','2023-10-25 18:34:33','2023-10-25 18:34:33'),(1829,7492,245,40787,102499,4,420,1,520661.16,NULL,'2023-10-25 16:20:21','2023-10-25 18:34:33','2023-10-25 18:34:33'),(1830,7492,245,40787,102499,4,132,2,589440.41,NULL,'2023-10-25 16:20:21','2023-10-25 18:34:33','2023-10-25 18:34:33'),(1831,7492,246,40787,102499,18,359,1,117867.73,NULL,'2023-10-25 16:21:48','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1832,7492,246,40787,102499,18,24,2,117867.73,NULL,'2023-10-25 16:21:48','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1833,7492,247,40787,102499,9,359,1,19335.37,NULL,'2023-10-25 16:27:19','2023-10-25 16:59:57','2023-10-25 16:59:57'),(1834,7492,247,40787,102499,9,20,2,19335.37,NULL,'2023-10-25 16:27:19','2023-10-25 16:59:57','2023-10-25 16:59:57'),(1835,7492,248,40787,102494,4,48,1,81473.03,NULL,'2023-10-25 16:33:34','2023-10-25 18:38:55','2023-10-25 18:38:55'),(1836,7492,248,40787,102494,4,132,2,81473.03,NULL,'2023-10-25 16:33:34','2023-10-25 18:38:55','2023-10-25 18:38:55'),(1837,7492,249,40787,102487,18,504,1,285000.00,NULL,'2023-10-25 16:36:12','2023-11-05 10:50:00','2023-11-05 10:50:00'),(1838,7492,249,40787,102487,18,1028,2,285000.00,NULL,'2023-10-25 16:36:12','2023-11-05 10:50:00','2023-11-05 10:50:00'),(1839,7492,250,40787,102499,16,251,1,46936.21,NULL,'2023-10-25 16:56:06','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1840,7492,250,40787,102499,16,252,1,509097.31,NULL,'2023-10-25 16:56:06','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1841,7492,250,40787,102499,16,486,2,13504.56,NULL,'2023-10-25 16:56:06','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1842,7492,250,40787,102499,16,497,2,3879.99,NULL,'2023-10-25 16:56:06','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1843,7492,250,40787,102499,16,498,1,0.01,NULL,'2023-10-25 16:56:06','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1844,7492,250,40787,102499,16,485,2,12720.36,NULL,'2023-10-25 16:56:06','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1845,7492,250,40787,102499,16,75,1,89281.24,NULL,'2023-10-25 16:56:06','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1846,7492,250,40787,102499,16,326,2,191779.61,NULL,'2023-10-25 16:56:06','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1847,7492,250,40787,102499,16,327,1,779321.54,NULL,'2023-10-25 16:56:06','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1848,7492,250,40787,102499,16,359,2,1202751.79,NULL,'2023-10-25 16:56:06','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1849,7492,251,40787,102499,9,359,1,19335.37,NULL,'2023-10-25 16:59:57','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1850,7492,251,40787,102499,9,24,2,19335.37,NULL,'2023-10-25 16:59:57','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (1851,7492,252,40787,102499,18,499,1,82631.94,NULL,'2023-10-25 17:03:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1852,7492,252,40787,102499,18,500,1,327.35,NULL,'2023-10-25 17:03:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1853,7492,252,40787,102499,18,513,1,154.75,NULL,'2023-10-25 17:03:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1854,7492,252,40787,102499,18,277,1,12730.52,NULL,'2023-10-25 17:03:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1855,7492,252,40787,102499,18,359,2,95844.56,NULL,'2023-10-25 17:03:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1856,7492,253,40787,102499,18,508,2,92682.27,NULL,'2023-10-25 17:04:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1857,7492,253,40787,102499,18,359,1,92682.27,NULL,'2023-10-25 17:04:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1858,7492,254,40787,102499,4,48,1,68779.25,NULL,'2023-10-25 18:34:33','2023-10-25 18:38:35','2023-10-25 18:38:35'),(1859,7492,254,40787,102499,4,132,2,589440.41,NULL,'2023-10-25 18:34:33','2023-10-25 18:38:35','2023-10-25 18:38:35'),(1860,7492,254,40787,102499,4,420,1,520661.16,NULL,'2023-10-25 18:34:33','2023-10-25 18:38:35','2023-10-25 18:38:35'),(1861,7492,255,40787,102499,4,48,2,68779.25,NULL,'2023-10-25 18:38:35','2023-11-05 11:40:04','2023-11-05 11:40:04'),(1862,7492,255,40787,102499,4,132,1,589440.41,NULL,'2023-10-25 18:38:35','2023-11-05 11:40:04','2023-11-05 11:40:04'),(1863,7492,255,40787,102499,4,420,2,520661.16,NULL,'2023-10-25 18:38:35','2023-11-05 11:40:04','2023-11-05 11:40:04'),(1864,7492,256,40787,102494,4,48,2,81473.03,NULL,'2023-10-25 18:38:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1865,7492,256,40787,102494,4,132,1,81473.03,NULL,'2023-10-25 18:38:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1866,7492,257,40787,102487,18,217,2,101271.99,NULL,'2023-10-25 19:17:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1867,7492,257,40787,102487,18,359,1,101271.99,NULL,'2023-10-25 19:17:55','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1868,7492,258,40787,102499,18,226,2,5446.65,NULL,'2023-10-25 19:26:50','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1869,7492,258,40787,102499,18,225,1,15003.27,NULL,'2023-10-25 19:26:50','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1870,7492,258,40787,102499,18,359,2,9556.62,NULL,'2023-10-25 19:26:50','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1871,7492,259,40787,102487,18,23,1,50252.58,NULL,'2023-10-25 20:06:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1872,7492,259,40787,102487,18,359,2,50252.58,NULL,'2023-10-25 20:06:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1873,7492,260,40787,102488,18,23,1,56104.14,NULL,'2023-10-25 20:07:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1874,7492,260,40787,102488,18,359,2,56104.14,NULL,'2023-10-25 20:07:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1875,7492,261,40787,102499,18,23,1,2771245.19,NULL,'2023-10-25 20:08:17','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1876,7492,261,40787,102499,18,359,2,2771245.19,NULL,'2023-10-25 20:08:17','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1877,7492,262,40787,102494,3,521,1,40320.00,NULL,'2023-10-25 20:18:34','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1878,7492,262,40787,102494,3,504,2,285000.00,NULL,'2023-10-25 20:18:34','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1879,7492,262,40787,102494,3,165,1,500000.00,NULL,'2023-10-25 20:18:34','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1880,7492,262,40787,102494,3,193,1,100000.00,NULL,'2023-10-25 20:18:34','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1881,7492,262,40787,102494,3,166,2,3325320.00,NULL,'2023-10-25 20:18:34','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1882,7492,262,40787,102494,3,359,1,2970000.00,NULL,'2023-10-25 20:18:34','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1883,7492,263,40787,102499,18,157,1,396767.50,NULL,'2023-10-25 20:25:20','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1884,7492,263,40787,102499,18,359,2,396767.50,NULL,'2023-10-25 20:25:20','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (1885,7492,264,40787,102499,18,518,1,6554.03,NULL,'2023-10-25 20:37:45','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1886,7492,265,40787,102499,18,1027,1,1702.50,NULL,'2023-10-25 20:40:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1887,7492,265,40787,102499,18,359,2,1702.50,NULL,'2023-10-25 20:40:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1888,7492,266,40787,102487,1,62,1,603346.96,NULL,'2023-10-25 20:47:19','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1889,7492,266,40787,102487,1,359,2,603346.96,NULL,'2023-10-25 20:47:19','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1890,7492,267,40787,102488,1,62,1,776749.46,NULL,'2023-10-25 20:48:17','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1891,7492,267,40787,102488,1,359,2,776749.46,NULL,'2023-10-25 20:48:17','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1892,7492,268,40787,102489,1,62,1,917171.54,NULL,'2023-10-25 20:48:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1893,7492,268,40787,102489,1,359,2,917171.54,NULL,'2023-10-25 20:48:51','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1894,7492,269,40787,102490,1,62,1,937215.52,NULL,'2023-10-25 20:49:31','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1895,7492,269,40787,102490,1,359,2,937215.52,NULL,'2023-10-25 20:49:31','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1896,7492,270,40787,102491,1,62,1,1333000.89,NULL,'2023-10-25 20:50:06','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1897,7492,270,40787,102491,1,359,2,1333000.89,NULL,'2023-10-25 20:50:06','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1898,7492,271,40787,102492,1,62,1,1991738.51,NULL,'2023-10-25 20:50:50','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1899,7492,271,40787,102492,1,359,2,1991738.51,NULL,'2023-10-25 20:50:50','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1900,7492,272,40787,102494,1,62,1,1212124.05,NULL,'2023-10-25 20:51:20','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1901,7492,272,40787,102494,1,359,2,1212124.05,NULL,'2023-10-25 20:51:20','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1902,7492,273,40787,102495,1,62,1,1099566.76,NULL,'2023-10-25 20:51:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1903,7492,273,40787,102495,1,359,2,1099566.76,NULL,'2023-10-25 20:51:53','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1904,7492,274,40787,102496,1,62,1,1121118.71,NULL,'2023-10-25 20:52:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1905,7492,274,40787,102496,1,359,2,1121118.71,NULL,'2023-10-25 20:52:29','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1906,7492,275,40787,102497,1,62,1,1360657.48,NULL,'2023-10-25 20:52:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1907,7492,275,40787,102497,1,359,2,1360657.48,NULL,'2023-10-25 20:52:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1908,7492,276,40787,102498,1,62,1,1787041.28,NULL,'2023-10-25 20:53:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1909,7492,276,40787,102498,1,359,2,1787041.28,NULL,'2023-10-25 20:53:42','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1910,7492,277,40787,102487,1,62,1,874320.75,NULL,'2023-10-25 21:00:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1911,7492,277,40787,102487,1,359,2,874320.75,NULL,'2023-10-25 21:00:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1912,7492,278,40787,102495,1,488,1,55400.00,NULL,'2023-10-25 21:06:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1913,7492,278,40787,102495,1,359,2,55400.00,NULL,'2023-10-25 21:06:59','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1914,7492,279,40787,102499,18,467,1,12.12,NULL,'2023-11-04 19:12:41','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1915,7492,279,40787,102499,18,140,2,12.12,NULL,'2023-11-04 19:12:41','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1916,7492,280,40787,102499,3,1033,1,39825.34,NULL,'2023-11-04 19:56:01','2023-11-04 20:10:31','2023-11-04 20:10:31'),(1917,7492,280,40787,102499,3,82,2,39825.34,NULL,'2023-11-04 19:56:01','2023-11-04 20:10:31','2023-11-04 20:10:31'),(1918,7492,281,40787,102499,3,1033,1,33144.41,NULL,'2023-11-04 19:57:03','2023-11-04 20:10:57','2023-11-04 20:10:57');
INSERT INTO `balance_libro_details` VALUES (1919,7492,281,40787,102499,3,82,2,33144.41,NULL,'2023-11-04 19:57:03','2023-11-04 20:10:57','2023-11-04 20:10:57'),(1920,7492,282,40787,102499,3,1033,1,65750.24,NULL,'2023-11-04 19:57:59','2023-11-04 20:11:32','2023-11-04 20:11:32'),(1921,7492,282,40787,102499,3,82,2,65750.24,NULL,'2023-11-04 19:57:59','2023-11-04 20:11:32','2023-11-04 20:11:32'),(1922,7492,283,40787,102499,3,82,2,125764.60,NULL,'2023-11-04 19:58:49','2023-11-04 20:12:17','2023-11-04 20:12:17'),(1923,7492,283,40787,102499,3,1033,1,125764.60,NULL,'2023-11-04 19:58:49','2023-11-04 20:12:17','2023-11-04 20:12:17'),(1924,7492,284,40787,102499,3,1033,1,52301.50,NULL,'2023-11-04 20:00:52','2023-11-04 20:19:14','2023-11-04 20:19:14'),(1925,7492,284,40787,102499,3,82,2,52301.50,NULL,'2023-11-04 20:00:52','2023-11-04 20:19:14','2023-11-04 20:19:14'),(1926,7492,285,40787,102499,3,1033,1,50070.27,NULL,'2023-11-04 20:02:28','2023-11-04 20:12:46','2023-11-04 20:12:46'),(1927,7492,285,40787,102499,3,82,2,50070.27,NULL,'2023-11-04 20:02:28','2023-11-04 20:12:46','2023-11-04 20:12:46'),(1928,7492,286,40787,102499,3,82,2,491869.34,NULL,'2023-11-04 20:03:40','2023-11-04 20:13:14','2023-11-04 20:13:14'),(1929,7492,286,40787,102499,3,1033,1,491869.34,NULL,'2023-11-04 20:03:40','2023-11-04 20:13:14','2023-11-04 20:13:14'),(1930,7492,287,40787,102499,3,1033,1,39825.34,NULL,'2023-11-04 20:10:31','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1931,7492,287,40787,102499,3,506,2,39825.34,NULL,'2023-11-04 20:10:31','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1932,7492,288,40787,102499,3,1033,1,33144.41,NULL,'2023-11-04 20:10:57','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1933,7492,288,40787,102499,3,506,2,33144.41,NULL,'2023-11-04 20:10:57','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1934,7492,289,40787,102499,3,1033,1,65750.24,NULL,'2023-11-04 20:11:32','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1935,7492,289,40787,102499,3,506,2,65750.24,NULL,'2023-11-04 20:11:32','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1936,7492,290,40787,102499,3,1033,1,125764.60,NULL,'2023-11-04 20:12:17','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1937,7492,290,40787,102499,3,506,2,125764.60,NULL,'2023-11-04 20:12:17','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1938,7492,291,40787,102499,3,1033,1,50070.27,NULL,'2023-11-04 20:12:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1939,7492,291,40787,102499,3,506,2,50070.27,NULL,'2023-11-04 20:12:46','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1940,7492,292,40787,102499,3,1033,1,491869.34,NULL,'2023-11-04 20:13:14','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1941,7492,292,40787,102499,3,506,2,491869.34,NULL,'2023-11-04 20:13:14','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1942,7492,293,40787,102499,3,1033,1,52301.50,NULL,'2023-11-04 20:19:14','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1943,7492,293,40787,102499,3,506,2,52301.50,NULL,'2023-11-04 20:19:14','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1944,7492,294,40787,102499,21,57,1,1391784.47,NULL,'2023-11-04 20:42:34','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1945,7492,294,40787,102499,21,359,2,1391784.47,NULL,'2023-11-04 20:42:34','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1946,7492,295,40719,23,17,1034,1,4719688.92,NULL,'2023-11-05 09:30:34','2023-11-05 09:33:19','2023-11-05 09:33:19'),(1947,7492,295,40719,23,17,506,2,4719688.92,NULL,'2023-11-05 09:30:34','2023-11-05 09:33:19','2023-11-05 09:33:19'),(1948,7492,296,40719,23,17,1034,1,5578414.62,NULL,'2023-11-05 09:33:19','2023-11-05 09:33:47','2023-11-05 09:33:47'),(1949,7492,296,40719,23,17,506,2,5578414.62,NULL,'2023-11-05 09:33:19','2023-11-05 09:33:47','2023-11-05 09:33:47'),(1950,7492,297,40719,23,17,1034,1,4719688.92,NULL,'2023-11-05 09:33:47','2023-11-05 09:33:47',NULL),(1951,7492,297,40719,23,17,506,2,4719688.92,NULL,'2023-11-05 09:33:47','2023-11-05 09:33:47',NULL),(1952,7492,298,40787,102499,11,1034,1,4719688.92,NULL,'2023-11-05 09:36:26','2023-11-05 09:36:26',NULL);
INSERT INTO `balance_libro_details` VALUES (1953,7492,298,40787,102499,11,506,2,4719688.92,NULL,'2023-11-05 09:36:26','2023-11-05 09:36:26',NULL),(1954,7492,299,40787,102499,11,359,2,370254.51,NULL,'2023-11-05 09:38:21','2023-11-05 09:38:21',NULL),(1955,7492,299,40787,102499,11,506,1,370254.51,NULL,'2023-11-05 09:38:21','2023-11-05 09:38:21',NULL),(1956,7492,300,40787,102499,11,1036,1,9404.28,NULL,'2023-11-05 09:51:02','2023-11-05 09:51:02',NULL),(1957,7492,300,40787,102499,11,1029,2,9404.28,NULL,'2023-11-05 09:51:02','2023-11-05 09:51:02',NULL),(1958,7492,301,40787,102499,11,1035,1,18808.56,NULL,'2023-11-05 09:52:05','2023-11-09 06:14:35','2023-11-09 06:14:35'),(1959,7492,301,40787,102499,11,1029,2,18808.56,NULL,'2023-11-05 09:52:05','2023-11-09 06:14:35','2023-11-09 06:14:35'),(1960,7492,302,40787,102499,11,359,2,34541.88,NULL,'2023-11-05 09:53:59','2023-11-05 09:53:59',NULL),(1961,7492,302,40787,102499,11,1029,1,34541.88,NULL,'2023-11-05 09:53:59','2023-11-05 09:53:59',NULL),(1962,7492,303,40787,102499,3,135,1,4792.85,NULL,'2023-11-05 10:36:26','2023-11-05 10:45:08','2023-11-05 10:45:08'),(1963,7492,303,40787,102499,3,521,1,62174.03,NULL,'2023-11-05 10:36:26','2023-11-05 10:45:08','2023-11-05 10:45:08'),(1964,7492,303,40787,102499,3,165,1,250000.00,NULL,'2023-11-05 10:36:26','2023-11-05 10:45:08','2023-11-05 10:45:08'),(1965,7492,303,40787,102499,3,359,1,6500000.00,NULL,'2023-11-05 10:36:26','2023-11-05 10:45:08','2023-11-05 10:45:08'),(1966,7492,303,40787,102499,3,20,1,3076.60,NULL,'2023-11-05 10:36:26','2023-11-05 10:45:08','2023-11-05 10:45:08'),(1967,7492,303,40787,102499,3,74,1,3601623.59,NULL,'2023-11-05 10:36:26','2023-11-05 10:45:08','2023-11-05 10:45:08'),(1968,7492,303,40787,102499,3,327,1,115841.99,NULL,'2023-11-05 10:36:26','2023-11-05 10:45:08','2023-11-05 10:45:08'),(1969,7492,303,40787,102499,3,506,1,36489.58,NULL,'2023-11-05 10:36:26','2023-11-05 10:45:08','2023-11-05 10:45:08'),(1970,7492,303,40787,102499,3,485,1,1678.50,NULL,'2023-11-05 10:36:26','2023-11-05 10:45:08','2023-11-05 10:45:08'),(1971,7492,303,40787,102499,3,499,1,38310.52,NULL,'2023-11-05 10:36:26','2023-11-05 10:45:08','2023-11-05 10:45:08'),(1972,7492,303,40787,102499,3,484,1,3753.00,NULL,'2023-11-05 10:36:26','2023-11-05 10:45:08','2023-11-05 10:45:08'),(1973,7492,303,40787,102499,3,157,1,174464.62,NULL,'2023-11-05 10:36:26','2023-11-05 10:45:08','2023-11-05 10:45:08'),(1974,7492,303,40787,102499,3,166,2,11347205.28,NULL,'2023-11-05 10:36:26','2023-11-05 10:45:08','2023-11-05 10:45:08'),(1975,7492,303,40787,102499,3,1028,1,555000.00,NULL,'2023-11-05 10:36:26','2023-11-05 10:45:08','2023-11-05 10:45:08'),(1976,7492,304,40787,102499,3,135,1,4792.85,NULL,'2023-11-05 10:45:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1977,7492,304,40787,102499,3,521,1,62174.03,NULL,'2023-11-05 10:45:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1978,7492,304,40787,102499,3,165,1,250000.00,NULL,'2023-11-05 10:45:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1979,7492,304,40787,102499,3,359,1,6500000.00,NULL,'2023-11-05 10:45:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1980,7492,304,40787,102499,3,20,1,3076.60,NULL,'2023-11-05 10:45:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1981,7492,304,40787,102499,3,74,1,3601623.59,NULL,'2023-11-05 10:45:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1982,7492,304,40787,102499,3,327,1,115841.99,NULL,'2023-11-05 10:45:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1983,7492,304,40787,102499,3,506,1,36489.58,NULL,'2023-11-05 10:45:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1984,7492,304,40787,102499,3,485,1,1678.50,NULL,'2023-11-05 10:45:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1985,7492,304,40787,102499,3,499,1,38310.52,NULL,'2023-11-05 10:45:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1986,7492,304,40787,102499,3,484,1,3753.00,NULL,'2023-11-05 10:45:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1987,7492,304,40787,102499,3,157,1,174464.62,NULL,'2023-11-05 10:45:08','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (1988,7492,304,40787,102499,3,166,2,11347205.28,NULL,'2023-11-05 10:45:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1989,7492,304,40787,102499,3,110,1,555000.00,NULL,'2023-11-05 10:45:08','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1990,7492,305,40787,102498,3,521,1,47991.03,NULL,'2023-11-05 10:45:31','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1991,7492,305,40787,102498,3,386,1,3000000.00,NULL,'2023-11-05 10:45:31','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1992,7492,305,40787,102498,3,359,1,13200000.00,NULL,'2023-11-05 10:45:31','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1993,7492,305,40787,102498,3,166,2,16754991.03,NULL,'2023-11-05 10:45:31','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1994,7492,305,40787,102498,3,110,1,507000.00,NULL,'2023-11-05 10:45:31','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1995,7492,306,40787,102497,3,135,1,26128.93,NULL,'2023-11-05 10:45:49','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1996,7492,306,40787,102497,3,521,1,84341.03,NULL,'2023-11-05 10:45:49','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1997,7492,306,40787,102497,3,359,1,10100000.00,NULL,'2023-11-05 10:45:49','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1998,7492,306,40787,102497,3,166,2,10940469.96,NULL,'2023-11-05 10:45:49','2023-11-05 14:01:09','2023-11-05 14:01:09'),(1999,7492,306,40787,102497,3,110,1,730000.00,NULL,'2023-11-05 10:45:49','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2000,7492,307,40787,102496,19,165,2,214000.00,NULL,'2023-11-05 10:46:09','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2001,7492,307,40787,102496,19,110,1,214000.00,NULL,'2023-11-05 10:46:09','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2002,7492,308,40787,102495,3,135,1,2200.25,NULL,'2023-11-05 10:46:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2003,7492,308,40787,102495,3,165,1,400000.00,NULL,'2023-11-05 10:46:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2004,7492,308,40787,102495,3,521,1,50408.03,NULL,'2023-11-05 10:46:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2005,7492,308,40787,102495,3,359,1,3600000.00,NULL,'2023-11-05 10:46:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2006,7492,308,40787,102495,3,166,2,4184608.28,NULL,'2023-11-05 10:46:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2007,7492,308,40787,102495,3,110,1,132000.00,NULL,'2023-11-05 10:46:28','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2008,7492,309,40787,102494,5,165,2,285000.00,NULL,'2023-11-05 10:46:48','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2009,7492,309,40787,102494,5,110,1,285000.00,NULL,'2023-11-05 10:46:48','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2010,7492,310,40787,102492,5,165,2,162000.00,NULL,'2023-11-05 10:47:04','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2011,7492,310,40787,102492,5,110,1,162000.00,NULL,'2023-11-05 10:47:04','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2012,7492,311,40787,102491,5,165,2,182112.00,NULL,'2023-11-05 10:47:27','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2013,7492,311,40787,102491,5,110,1,182112.00,NULL,'2023-11-05 10:47:27','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2014,7492,312,40787,102490,5,165,2,223500.00,NULL,'2023-11-05 10:47:45','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2015,7492,312,40787,102490,5,110,1,223500.00,NULL,'2023-11-05 10:47:45','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2016,7492,313,40787,102489,3,506,1,28056.23,NULL,'2023-11-05 10:48:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2017,7492,313,40787,102489,3,495,1,3750.00,NULL,'2023-11-05 10:48:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2018,7492,313,40787,102489,3,521,1,153562.00,NULL,'2023-11-05 10:48:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2019,7492,313,40787,102489,3,483,1,30000.00,NULL,'2023-11-05 10:48:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2020,7492,313,40787,102489,3,492,1,20487.69,NULL,'2023-11-05 10:48:12','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (2021,7492,313,40787,102489,3,165,1,140000.00,NULL,'2023-11-05 10:48:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2022,7492,313,40787,102489,3,359,1,1806000.00,NULL,'2023-11-05 10:48:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2023,7492,313,40787,102489,3,20,1,16766.54,NULL,'2023-11-05 10:48:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2024,7492,313,40787,102489,3,74,1,1793189.08,NULL,'2023-11-05 10:48:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2025,7492,313,40787,102489,3,506,1,28056.23,NULL,'2023-11-05 10:48:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2026,7492,313,40787,102489,3,25,1,36956.56,NULL,'2023-11-05 10:48:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2027,7492,313,40787,102489,3,467,1,160071.00,NULL,'2023-11-05 10:48:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2028,7492,313,40787,102489,3,485,1,516.15,NULL,'2023-11-05 10:48:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2029,7492,313,40787,102489,3,484,1,720.00,NULL,'2023-11-05 10:48:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2030,7492,313,40787,102489,3,157,1,86110.30,NULL,'2023-11-05 10:48:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2031,7492,313,40787,102489,3,166,2,4425441.78,NULL,'2023-11-05 10:48:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2032,7492,313,40787,102489,3,110,1,121200.00,NULL,'2023-11-05 10:48:12','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2033,7492,314,40787,102488,3,135,1,200000.00,NULL,'2023-11-05 10:48:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2034,7492,314,40787,102488,3,521,1,135623.00,NULL,'2023-11-05 10:48:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2035,7492,314,40787,102488,3,492,1,40955.91,NULL,'2023-11-05 10:48:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2036,7492,314,40787,102488,3,135,1,1499.00,NULL,'2023-11-05 10:48:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2037,7492,314,40787,102488,3,165,1,150000.00,NULL,'2023-11-05 10:48:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2038,7492,314,40787,102488,3,359,1,900000.00,NULL,'2023-11-05 10:48:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2039,7492,314,40787,102488,3,20,1,17189.77,NULL,'2023-11-05 10:48:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2040,7492,314,40787,102488,3,506,1,27625.36,NULL,'2023-11-05 10:48:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2041,7492,314,40787,102488,3,25,1,15495.85,NULL,'2023-11-05 10:48:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2042,7492,314,40787,102488,3,23,1,4427.38,NULL,'2023-11-05 10:48:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2043,7492,314,40787,102488,3,485,1,260.25,NULL,'2023-11-05 10:48:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2044,7492,314,40787,102488,3,157,1,38728.70,NULL,'2023-11-05 10:48:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2045,7492,314,40787,102488,3,166,2,1642021.22,NULL,'2023-11-05 10:48:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2046,7492,314,40787,102488,3,110,1,110216.00,NULL,'2023-11-05 10:48:36','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2047,7492,315,40787,102487,3,521,1,100770.00,NULL,'2023-11-05 10:48:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2048,7492,315,40787,102487,3,165,1,150000.00,NULL,'2023-11-05 10:48:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2049,7492,315,40787,102487,3,359,1,930000.00,NULL,'2023-11-05 10:48:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2050,7492,315,40787,102487,3,483,1,37500.00,NULL,'2023-11-05 10:48:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2051,7492,315,40787,102487,3,166,2,1506270.00,NULL,'2023-11-05 10:48:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2052,7492,315,40787,102487,3,110,1,288000.00,NULL,'2023-11-05 10:48:58','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2053,7492,316,40787,102487,18,504,1,285000.00,NULL,'2023-11-05 10:50:00','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2054,7492,316,40787,102487,18,359,2,285000.00,NULL,'2023-11-05 10:50:00','2023-11-05 14:01:09','2023-11-05 14:01:09');
INSERT INTO `balance_libro_details` VALUES (2055,7492,317,40787,102499,19,1032,1,76543393.93,NULL,'2023-11-05 11:10:41','2023-11-05 13:38:03','2023-11-05 13:38:03'),(2056,7492,317,40787,102499,19,392,2,24555555.55,NULL,'2023-11-05 11:10:41','2023-11-05 13:38:03','2023-11-05 13:38:03'),(2057,7492,317,40787,102499,19,166,2,32700908.46,NULL,'2023-11-05 11:10:41','2023-11-05 13:38:03','2023-11-05 13:38:03'),(2058,7492,317,40787,102499,19,359,2,19286929.92,NULL,'2023-11-05 11:10:41','2023-11-05 13:38:03','2023-11-05 13:38:03'),(2059,7492,318,40787,102499,22,392,1,10000000.00,NULL,'2023-11-05 11:13:17','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2060,7492,318,40787,102499,22,359,2,10000000.00,NULL,'2023-11-05 11:13:17','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2061,7492,319,40787,102499,4,48,2,68779.25,NULL,'2023-11-05 11:40:04','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2062,7492,319,40787,102499,4,132,1,589440.41,NULL,'2023-11-05 11:40:04','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2063,7492,319,40787,102499,4,420,2,520661.16,NULL,'2023-11-05 11:40:04','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2064,7492,320,40787,102499,18,1037,1,1831066.25,NULL,'2023-11-05 13:33:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2065,7492,320,40787,102499,18,157,2,1831066.25,NULL,'2023-11-05 13:33:05','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2066,7492,321,40787,102499,19,1032,1,81135997.56,NULL,'2023-11-05 13:38:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2067,7492,321,40787,102499,19,392,2,24555555.55,NULL,'2023-11-05 13:38:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2068,7492,321,40787,102499,19,166,2,32700908.46,NULL,'2023-11-05 13:38:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2069,7492,321,40787,102499,19,359,2,23879533.55,NULL,'2023-11-05 13:38:03','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2070,7492,322,40787,102487,23,420,2,524383.53,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2071,7492,322,40787,102487,23,476,1,524383.53,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2072,7492,323,40787,102487,23,121,1,18835.02,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2073,7492,323,40787,102487,23,476,2,18835.02,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2074,7492,324,40787,102487,23,515,1,74162.46,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2075,7492,324,40787,102487,23,476,2,74162.46,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:09','2023-11-05 14:01:09'),(2076,7492,325,40787,102487,23,383,2,867005.31,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2077,7492,325,40787,102487,23,476,1,867005.31,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2078,7492,326,40787,102487,23,490,1,30008.55,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2079,7492,326,40787,102487,23,476,2,30008.55,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2080,7492,327,40787,102487,23,110,1,1043271.05,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2081,7492,327,40787,102487,23,476,2,1043271.05,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2082,7492,328,40787,102487,23,520,1,1714.94,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2083,7492,328,40787,102487,23,476,2,1714.94,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2084,7492,329,40787,102487,23,419,1,2621917.62,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2085,7492,329,40787,102487,23,476,2,2621917.62,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2086,7492,330,40787,102487,23,199,1,6735.07,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2087,7492,330,40787,102487,23,476,2,6735.07,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro_details` VALUES (2088,7492,331,40787,102487,23,392,1,5065473.66,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2089,7492,331,40787,102487,23,476,2,5065473.66,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2090,7492,332,40787,102487,23,488,1,1733.81,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2091,7492,332,40787,102487,23,476,2,1733.81,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2092,7492,333,40787,102487,23,208,1,44188.68,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2093,7492,333,40787,102487,23,476,2,44188.68,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2094,7492,334,40787,102487,23,157,1,18940.33,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2095,7492,334,40787,102487,23,476,2,18940.33,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2096,7492,335,40787,102487,23,521,1,101490.44,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2097,7492,335,40787,102487,23,476,2,101490.44,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2098,7492,336,40787,102487,23,507,1,29275.72,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2099,7492,336,40787,102487,23,476,2,29275.72,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2100,7492,337,40787,102487,23,381,2,64611.14,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2101,7492,337,40787,102487,23,476,1,64611.14,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2102,7492,338,40787,102487,23,193,1,85607.69,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2103,7492,338,40787,102487,23,476,2,85607.69,NULL,'2023-11-05 13:48:16','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2104,7492,339,40787,102487,23,88,2,100714.93,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2105,7492,339,40787,102487,23,476,1,100714.93,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2106,7492,340,40787,102487,23,180,1,42189.23,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2107,7492,340,40787,102487,23,476,2,42189.23,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2108,7492,341,40787,102487,23,191,1,201929.60,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2109,7492,341,40787,102487,23,476,2,201929.60,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2110,7492,342,40787,102487,23,48,2,59331.27,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2111,7492,342,40787,102487,23,476,1,59331.27,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2112,7492,343,40787,102487,23,489,1,19120.90,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2113,7492,343,40787,102487,23,476,2,19120.90,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2114,7492,344,40787,102487,23,514,1,524.66,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2115,7492,344,40787,102487,23,476,2,524.66,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2116,7492,345,40787,102487,23,363,1,593311.73,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2117,7492,345,40787,102487,23,476,2,593311.73,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2118,7492,346,40787,102487,23,492,1,13590.56,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2119,7492,346,40787,102487,23,476,2,13590.56,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2120,7492,347,40787,102487,23,491,1,46056.11,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro_details` VALUES (2121,7492,347,40787,102487,23,476,2,46056.11,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2122,7492,348,40787,102487,23,482,2,2658652.59,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2123,7492,348,40787,102487,23,476,1,2658652.59,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2124,7492,349,40787,102487,23,135,1,39067.32,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2125,7492,349,40787,102487,23,476,2,39067.32,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2126,7492,350,40787,102487,23,217,2,101996.01,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2127,7492,350,40787,102487,23,476,1,101996.01,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2128,7492,351,40787,102487,23,496,1,22277.64,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2129,7492,351,40787,102487,23,476,2,22277.64,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2130,7492,352,40787,102487,23,1030,1,5786.37,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2131,7492,352,40787,102487,23,476,2,5786.37,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2132,7492,353,40787,102487,23,92,2,1831049.70,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2133,7492,353,40787,102487,23,476,1,1831049.70,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2134,7492,354,40787,102487,23,503,1,1694.22,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2135,7492,354,40787,102487,23,476,2,1694.22,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2136,7492,355,40787,102487,23,88,2,55365.00,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2137,7492,355,40787,102487,23,476,1,55365.00,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2138,7492,356,40787,102487,23,483,1,75536.20,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2139,7492,356,40787,102487,23,476,2,75536.20,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2140,7492,357,40787,102488,23,121,1,34764.74,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2141,7492,357,40787,102488,23,476,2,34764.74,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2142,7492,358,40787,102488,23,110,1,950441.66,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2143,7492,358,40787,102488,23,476,2,950441.66,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2144,7492,359,40787,102488,23,483,1,26290.82,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2145,7492,359,40787,102488,23,476,2,26290.82,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2146,7492,360,40787,102488,23,489,1,12271.51,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2147,7492,360,40787,102488,23,476,2,12271.51,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2148,7492,361,40787,102488,23,493,1,6560.47,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2149,7492,361,40787,102488,23,476,2,6560.47,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2150,7492,362,40787,102488,23,392,1,846824.41,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2151,7492,362,40787,102488,23,476,2,846824.41,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2152,7492,363,40787,102488,23,135,1,193928.98,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2153,7492,363,40787,102488,23,476,2,193928.98,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro_details` VALUES (2154,7492,364,40787,102488,23,116,1,87636.07,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2155,7492,364,40787,102488,23,476,2,87636.07,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2156,7492,365,40787,102488,23,503,1,1455.41,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2157,7492,365,40787,102488,23,476,2,1455.41,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2158,7492,366,40787,102488,23,191,1,211263.69,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2159,7492,366,40787,102488,23,476,2,211263.69,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2160,7492,367,40787,102488,23,193,1,184035.74,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2161,7492,367,40787,102488,23,476,2,184035.74,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2162,7492,368,40787,102488,23,514,1,554.36,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2163,7492,368,40787,102488,23,476,2,554.36,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2164,7492,369,40787,102488,23,180,1,69399.57,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2165,7492,369,40787,102488,23,476,2,69399.57,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2166,7492,370,40787,102488,23,120,1,1709.25,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2167,7492,370,40787,102488,23,476,2,1709.25,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2168,7492,371,40787,102488,23,520,1,5951.13,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2169,7492,371,40787,102488,23,476,2,5951.13,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2170,7492,372,40787,102488,23,490,1,30377.66,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2171,7492,372,40787,102488,23,476,2,30377.66,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2172,7492,373,40787,102488,23,491,1,45049.38,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2173,7492,373,40787,102488,23,476,2,45049.38,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2174,7492,374,40787,102488,23,157,1,34685.39,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2175,7492,374,40787,102488,23,476,2,34685.39,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2176,7492,375,40787,102488,23,482,2,6192542.11,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2177,7492,375,40787,102488,23,476,1,6192542.11,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2178,7492,376,40787,102488,23,496,1,154813.56,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2179,7492,376,40787,102488,23,476,2,154813.56,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2180,7492,377,40787,102488,23,488,1,1440.54,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2181,7492,377,40787,102488,23,476,2,1440.54,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2182,7492,378,40787,102488,23,521,1,118854.66,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2183,7492,378,40787,102488,23,476,2,118854.66,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2184,7492,379,40787,102488,23,492,1,36977.82,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2185,7492,379,40787,102488,23,476,2,36977.82,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2186,7492,380,40787,102488,23,494,1,87636.07,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2187,7492,380,40787,102488,23,476,2,87636.07,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro_details` VALUES (2188,7492,381,40787,102488,23,515,1,82789.71,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2189,7492,381,40787,102488,23,476,2,82789.71,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2190,7492,382,40787,102489,23,121,1,30442.00,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2191,7492,382,40787,102489,23,476,2,30442.00,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2192,7492,383,40787,102489,23,520,1,6230.43,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2193,7492,383,40787,102489,23,476,2,6230.43,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2194,7492,384,40787,102489,23,490,1,28536.55,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2195,7492,384,40787,102489,23,476,2,28536.55,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2196,7492,385,40787,102489,23,493,1,6268.62,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2197,7492,385,40787,102489,23,476,2,6268.62,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2198,7492,386,40787,102489,23,157,1,66810.41,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2199,7492,386,40787,102489,23,476,2,66810.41,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2200,7492,387,40787,102489,23,116,1,331513.25,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2201,7492,387,40787,102489,23,476,2,331513.25,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2202,7492,388,40787,102489,23,396,1,16967.03,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2203,7492,388,40787,102489,23,476,2,16967.03,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2204,7492,389,40787,102489,23,482,2,11674729.51,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2205,7492,389,40787,102489,23,476,1,11674729.51,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2206,7492,390,40787,102489,23,191,1,253361.03,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2207,7492,390,40787,102489,23,476,2,253361.03,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2208,7492,391,40787,102489,23,514,1,513.98,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2209,7492,391,40787,102489,23,476,2,513.98,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2210,7492,392,40787,102489,23,510,1,9513.12,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2211,7492,392,40787,102489,23,476,2,9513.12,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2212,7492,393,40787,102489,23,488,1,1644.57,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2213,7492,393,40787,102489,23,476,2,1644.57,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2214,7492,394,40787,102489,23,467,1,122837.17,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2215,7492,394,40787,102489,23,476,2,122837.17,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2216,7492,395,40787,102489,23,120,1,1046.29,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2217,7492,395,40787,102489,23,476,2,1046.29,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2218,7492,396,40787,102489,23,495,1,2877.72,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2219,7492,396,40787,102489,23,476,2,2877.72,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2220,7492,397,40787,102489,23,193,1,671237.59,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2221,7492,397,40787,102489,23,476,2,671237.59,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro_details` VALUES (2222,7492,398,40787,102489,23,180,1,133018.54,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2223,7492,398,40787,102489,23,476,2,133018.54,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2224,7492,399,40787,102489,23,492,1,16672.76,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2225,7492,399,40787,102489,23,476,2,16672.76,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2226,7492,400,40787,102489,23,491,1,39500.15,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2227,7492,400,40787,102489,23,476,2,39500.15,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2228,7492,401,40787,102489,23,496,1,291868.24,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2229,7492,401,40787,102489,23,476,2,291868.24,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2230,7492,402,40787,102489,23,392,1,971763.31,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2231,7492,402,40787,102489,23,476,2,971763.31,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2232,7492,403,40787,102489,23,512,1,3132.98,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2233,7492,403,40787,102489,23,476,2,3132.98,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2234,7492,404,40787,102489,23,515,1,85205.38,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2235,7492,404,40787,102489,23,476,2,85205.38,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2236,7492,405,40787,102489,23,483,1,46043.51,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2237,7492,405,40787,102489,23,476,2,46043.51,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2238,7492,406,40787,102489,23,110,1,937088.54,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2239,7492,406,40787,102489,23,476,2,937088.54,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2240,7492,407,40787,102489,23,137,1,73115.62,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2241,7492,407,40787,102489,23,476,2,73115.62,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2242,7492,408,40787,102489,23,521,1,117842.22,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2243,7492,408,40787,102489,23,476,2,117842.22,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2244,7492,409,40787,102489,23,489,1,21738.19,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2245,7492,409,40787,102489,23,476,2,21738.19,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2246,7492,410,40787,102490,23,490,1,21632.17,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2247,7492,410,40787,102490,23,476,2,21632.17,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2248,7492,411,40787,102490,23,199,1,7192.17,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2249,7492,411,40787,102490,23,476,2,7192.17,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2250,7492,412,40787,102490,23,116,1,81745.25,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2251,7492,412,40787,102490,23,476,2,81745.25,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2252,7492,413,40787,102490,23,157,1,807.42,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2253,7492,413,40787,102490,23,476,2,807.42,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2254,7492,414,40787,102490,23,191,1,214905.53,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro_details` VALUES (2255,7492,414,40787,102490,23,476,2,214905.53,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2256,7492,415,40787,102490,23,482,2,2466562.19,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2257,7492,415,40787,102490,23,476,1,2466562.19,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2258,7492,416,40787,102490,23,507,1,54813.47,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2259,7492,416,40787,102490,23,476,2,54813.47,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2260,7492,417,40787,102490,23,514,1,344.81,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2261,7492,417,40787,102490,23,476,2,344.81,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2262,7492,418,40787,102490,23,226,1,8395.30,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2263,7492,418,40787,102490,23,476,2,8395.30,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2264,7492,419,40787,102490,23,503,1,2934.74,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2265,7492,419,40787,102490,23,476,2,2934.74,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2266,7492,420,40787,102490,23,483,1,24821.43,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2267,7492,420,40787,102490,23,476,2,24821.43,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2268,7492,421,40787,102490,23,137,1,86438.69,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2269,7492,421,40787,102490,23,476,2,86438.69,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2270,7492,422,40787,102490,23,180,1,41779.34,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2271,7492,422,40787,102490,23,476,2,41779.34,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2272,7492,423,40787,102490,23,492,1,1066.16,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2273,7492,423,40787,102490,23,476,2,1066.16,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2274,7492,424,40787,102490,23,520,1,5820.94,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2275,7492,424,40787,102490,23,476,2,5820.94,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2276,7492,425,40787,102490,23,491,1,13783.79,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2277,7492,425,40787,102490,23,476,2,13783.79,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2278,7492,426,40787,102490,23,392,1,1845563.75,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2279,7492,426,40787,102490,23,476,2,1845563.75,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2280,7492,427,40787,102490,23,135,1,29388.48,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2281,7492,427,40787,102490,23,476,2,29388.48,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2282,7492,428,40787,102490,23,496,1,33838.34,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2283,7492,428,40787,102490,23,476,2,33838.34,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2284,7492,429,40787,102490,23,515,1,74973.17,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2285,7492,429,40787,102490,23,476,2,74973.17,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2286,7492,430,40787,102490,23,396,1,54776.60,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2287,7492,430,40787,102490,23,476,2,54776.60,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2288,7492,431,40787,102490,23,110,1,922835.83,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro_details` VALUES (2289,7492,431,40787,102490,23,476,2,922835.83,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2290,7492,432,40787,102490,23,217,1,67032.42,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2291,7492,432,40787,102490,23,476,2,67032.42,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2292,7492,433,40787,102490,23,495,1,4923.26,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2293,7492,433,40787,102490,23,476,2,4923.26,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2294,7492,434,40787,102490,23,489,1,7899.85,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2295,7492,434,40787,102490,23,476,2,7899.85,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2296,7492,435,40787,102490,23,488,1,1565.62,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2297,7492,435,40787,102490,23,476,2,1565.62,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2298,7492,436,40787,102490,23,193,1,316592.87,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2299,7492,436,40787,102490,23,476,2,316592.87,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2300,7492,437,40787,102491,23,520,1,5643.86,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2301,7492,437,40787,102491,23,476,2,5643.86,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2302,7492,438,40787,102491,23,493,1,4480.85,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2303,7492,438,40787,102491,23,476,2,4480.85,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2304,7492,439,40787,102491,23,191,1,264825.71,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2305,7492,439,40787,102491,23,476,2,264825.71,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2306,7492,440,40787,102491,23,363,1,10183.38,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2307,7492,440,40787,102491,23,476,2,10183.38,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2308,7492,441,40787,102491,23,157,1,1538.74,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2309,7492,441,40787,102491,23,476,2,1538.74,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2310,7492,442,40787,102491,23,116,1,72127.90,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2311,7492,442,40787,102491,23,476,2,72127.90,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2312,7492,443,40787,102491,23,514,1,434.64,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2313,7492,443,40787,102491,23,476,2,434.64,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2314,7492,444,40787,102491,23,503,1,2332.44,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2315,7492,444,40787,102491,23,476,2,2332.44,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2316,7492,445,40787,102491,23,482,2,4006510.62,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2317,7492,445,40787,102491,23,476,1,4006510.62,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2318,7492,446,40787,102491,23,483,1,25113.36,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2319,7492,446,40787,102491,23,476,2,25113.36,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2320,7492,447,40787,102491,23,507,1,159727.75,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2321,7492,447,40787,102491,23,476,2,159727.75,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2322,7492,448,40787,102491,23,494,1,49642.68,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro_details` VALUES (2323,7492,448,40787,102491,23,476,2,49642.68,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2324,7492,449,40787,102491,23,193,1,116806.31,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2325,7492,449,40787,102491,23,476,2,116806.31,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2326,7492,450,40787,102491,23,180,1,23954.49,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2327,7492,450,40787,102491,23,476,2,23954.49,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2328,7492,451,40787,102491,23,488,1,1540.36,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2329,7492,451,40787,102491,23,476,2,1540.36,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2330,7492,452,40787,102491,23,492,1,9750.96,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2331,7492,452,40787,102491,23,476,2,9750.96,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2332,7492,453,40787,102491,23,496,1,100162.76,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2333,7492,453,40787,102491,23,476,2,100162.76,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2334,7492,454,40787,102491,23,491,1,56909.93,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2335,7492,454,40787,102491,23,476,2,56909.93,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2336,7492,455,40787,102491,23,515,1,93844.55,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2337,7492,455,40787,102491,23,476,2,93844.55,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2338,7492,456,40787,102491,23,226,2,938.25,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2339,7492,456,40787,102491,23,476,1,938.25,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2340,7492,457,40787,102491,23,135,1,17316.54,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2341,7492,457,40787,102491,23,476,2,17316.54,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2342,7492,458,40787,102491,23,392,1,478855.54,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2343,7492,458,40787,102491,23,476,2,478855.54,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2344,7492,459,40787,102491,23,110,1,1080258.22,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2345,7492,459,40787,102491,23,476,2,1080258.22,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2346,7492,460,40787,102491,23,120,1,3856.55,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2347,7492,460,40787,102491,23,476,2,3856.55,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2348,7492,461,40787,102491,23,495,1,2172.02,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2349,7492,461,40787,102491,23,476,2,2172.02,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2350,7492,462,40787,102491,23,137,1,1171764.20,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2351,7492,462,40787,102491,23,476,2,1171764.20,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2352,7492,463,40787,102491,23,489,1,23949.03,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2353,7492,463,40787,102491,23,476,2,23949.03,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2354,7492,464,40787,102491,23,121,1,27029.59,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2355,7492,464,40787,102491,23,476,2,27029.59,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2356,7492,465,40787,102491,23,490,1,36494.39,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro_details` VALUES (2357,7492,465,40787,102491,23,476,2,36494.39,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2358,7492,466,40787,102492,23,482,2,6199065.15,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2359,7492,466,40787,102492,23,476,1,6199065.15,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2360,7492,467,40787,102492,23,157,1,6457.59,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2361,7492,467,40787,102492,23,476,2,6457.59,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2362,7492,468,40787,102492,23,193,1,101362.65,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2363,7492,468,40787,102492,23,476,2,101362.65,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2364,7492,469,40787,102492,23,483,1,26607.70,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2365,7492,469,40787,102492,23,476,2,26607.70,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2366,7492,470,40787,102492,23,120,1,2613.64,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2367,7492,470,40787,102492,23,476,2,2613.64,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2368,7492,471,40787,102492,23,489,1,24678.63,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2369,7492,471,40787,102492,23,476,2,24678.63,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2370,7492,472,40787,102492,23,492,1,816.34,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2371,7492,472,40787,102492,23,476,2,816.34,NULL,'2023-11-05 13:48:17','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2372,7492,473,40787,102492,23,491,1,49140.82,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2373,7492,473,40787,102492,23,476,2,49140.82,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2374,7492,474,40787,102492,23,496,1,142816.37,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2375,7492,474,40787,102492,23,476,2,142816.37,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2376,7492,475,40787,102492,23,137,1,9833.96,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2377,7492,475,40787,102492,23,476,2,9833.96,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2378,7492,476,40787,102492,23,503,1,708.11,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2379,7492,476,40787,102492,23,476,2,708.11,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2380,7492,477,40787,102492,23,515,1,115366.63,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2381,7492,477,40787,102492,23,476,2,115366.63,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2382,7492,478,40787,102492,23,392,1,653257.83,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2383,7492,478,40787,102492,23,476,2,653257.83,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2384,7492,479,40787,102492,23,520,1,6056.31,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2385,7492,479,40787,102492,23,476,2,6056.31,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2386,7492,480,40787,102492,23,396,1,60716.23,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2387,7492,480,40787,102492,23,476,2,60716.23,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2388,7492,481,40787,102492,23,110,1,1284358.34,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2389,7492,481,40787,102492,23,476,2,1284358.34,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2390,7492,482,40787,102492,23,135,1,53179.92,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08');
INSERT INTO `balance_libro_details` VALUES (2391,7492,482,40787,102492,23,476,2,53179.92,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2392,7492,483,40787,102492,23,494,1,144441.78,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2393,7492,483,40787,102492,23,476,2,144441.78,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:08','2023-11-05 14:01:08'),(2394,7492,484,40787,102492,23,495,1,1884.84,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2395,7492,484,40787,102492,23,476,2,1884.84,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2396,7492,485,40787,102492,23,490,1,43653.22,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2397,7492,485,40787,102492,23,476,2,43653.22,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2398,7492,486,40787,102492,23,493,1,4397.23,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2399,7492,486,40787,102492,23,476,2,4397.23,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2400,7492,487,40787,102492,23,208,1,12160.26,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2401,7492,487,40787,102492,23,476,2,12160.26,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2402,7492,488,40787,102492,23,180,1,118777.34,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2403,7492,488,40787,102492,23,476,2,118777.34,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2404,7492,489,40787,102492,23,363,1,45177.48,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2405,7492,489,40787,102492,23,476,2,45177.48,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2406,7492,490,40787,102492,23,191,1,283476.43,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2407,7492,490,40787,102492,23,476,2,283476.43,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2408,7492,491,40787,102492,23,507,1,83734.80,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2409,7492,491,40787,102492,23,476,2,83734.80,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2410,7492,492,40787,102492,23,501,1,38199.48,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2411,7492,492,40787,102492,23,476,2,38199.48,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2412,7492,493,40787,102492,23,514,1,358.31,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2413,7492,493,40787,102492,23,476,2,358.31,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2414,7492,494,40787,102492,23,488,1,1915.64,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2415,7492,494,40787,102492,23,476,2,1915.64,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2416,7492,495,40787,102494,23,180,1,21646.14,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2417,7492,495,40787,102494,23,476,2,21646.14,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2418,7492,496,40787,102494,23,489,1,9720.91,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2419,7492,496,40787,102494,23,476,2,9720.91,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2420,7492,497,40787,102494,23,135,1,45653.38,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2421,7492,497,40787,102494,23,476,2,45653.38,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2422,7492,498,40787,102494,23,512,1,2199.71,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2423,7492,498,40787,102494,23,476,2,2199.71,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2424,7492,499,40787,102494,23,492,1,3828.62,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07');
INSERT INTO `balance_libro_details` VALUES (2425,7492,499,40787,102494,23,476,2,3828.62,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2426,7492,500,40787,102494,23,225,2,631.18,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2427,7492,500,40787,102494,23,476,1,631.18,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2428,7492,501,40787,102494,23,521,1,16980.70,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2429,7492,501,40787,102494,23,476,2,16980.70,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2430,7492,502,40787,102494,23,491,1,27103.87,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2431,7492,502,40787,102494,23,476,2,27103.87,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2432,7492,503,40787,102494,23,496,1,63757.28,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2433,7492,503,40787,102494,23,476,2,63757.28,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2434,7492,504,40787,102494,23,482,2,2550291.18,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2435,7492,504,40787,102494,23,476,1,2550291.18,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2436,7492,505,40787,102494,23,515,1,63635.05,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2437,7492,505,40787,102494,23,476,2,63635.05,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2438,7492,506,40787,102494,23,503,1,1151.74,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2439,7492,506,40787,102494,23,476,2,1151.74,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2440,7492,507,40787,102494,23,467,1,6637.30,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2441,7492,507,40787,102494,23,476,2,6637.30,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2442,7492,508,40787,102494,23,132,1,34312.22,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2443,7492,508,40787,102494,23,476,2,34312.22,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2444,7492,509,40787,102494,23,110,1,753816.34,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2445,7492,509,40787,102494,23,476,2,753816.34,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2446,7492,510,40787,102494,23,507,1,31391.31,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2447,7492,510,40787,102494,23,476,2,31391.31,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2448,7492,511,40787,102494,23,483,1,24005.45,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2449,7492,511,40787,102494,23,476,2,24005.45,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2450,7492,512,40787,102494,23,488,1,1443.47,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2451,7492,512,40787,102494,23,476,2,1443.47,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2452,7492,513,40787,102494,23,193,1,100536.09,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2453,7492,513,40787,102494,23,476,2,100536.09,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2454,7492,514,40787,102494,23,1031,1,44405.87,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2455,7492,514,40787,102494,23,476,2,44405.87,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2456,7492,515,40787,102494,23,120,1,981.52,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2457,7492,515,40787,102494,23,476,2,981.52,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2458,7492,516,40787,102494,23,490,1,29381.70,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07');
INSERT INTO `balance_libro_details` VALUES (2459,7492,516,40787,102494,23,476,2,29381.70,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2460,7492,517,40787,102494,23,493,1,2620.85,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2461,7492,517,40787,102494,23,476,2,2620.85,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2462,7492,518,40787,102494,23,226,2,1767.30,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2463,7492,518,40787,102494,23,476,1,1767.30,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2464,7492,519,40787,102494,23,392,1,1444912.93,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2465,7492,519,40787,102494,23,476,2,1444912.93,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2466,7492,520,40787,102494,23,191,1,167775.55,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2467,7492,520,40787,102494,23,476,2,167775.55,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2468,7492,521,40787,102494,23,396,1,20471.73,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2469,7492,521,40787,102494,23,476,2,20471.73,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2470,7492,522,40787,102494,23,157,1,60684.21,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2471,7492,522,40787,102494,23,476,2,60684.21,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2472,7492,523,40787,102494,23,514,1,282.08,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2473,7492,523,40787,102494,23,476,2,282.08,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2474,7492,524,40787,102494,23,137,1,48455.38,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2475,7492,524,40787,102494,23,476,2,48455.38,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2476,7492,525,40787,102494,23,48,2,34312.22,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2477,7492,525,40787,102494,23,476,1,34312.22,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2478,7492,526,40787,102494,23,116,1,52011.81,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2479,7492,526,40787,102494,23,476,2,52011.81,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2480,7492,527,40787,102494,23,520,1,4339.71,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2481,7492,527,40787,102494,23,476,2,4339.71,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2482,7492,528,40787,102495,23,521,1,16776.45,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2483,7492,528,40787,102495,23,476,2,16776.45,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2484,7492,529,40787,102495,23,490,1,27710.42,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2485,7492,529,40787,102495,23,476,2,27710.42,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2486,7492,530,40787,102495,23,488,1,19541.44,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2487,7492,530,40787,102495,23,476,2,19541.44,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2488,7492,531,40787,102495,23,135,1,982.97,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2489,7492,531,40787,102495,23,476,2,982.97,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2490,7492,532,40787,102495,23,493,1,1185.47,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2491,7492,532,40787,102495,23,476,2,1185.47,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2492,7492,533,40787,102495,23,392,1,454775.41,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07');
INSERT INTO `balance_libro_details` VALUES (2493,7492,533,40787,102495,23,476,2,454775.41,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2494,7492,534,40787,102495,23,496,1,49844.71,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2495,7492,534,40787,102495,23,476,2,49844.71,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2496,7492,535,40787,102495,23,515,1,44363.26,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2497,7492,535,40787,102495,23,476,2,44363.26,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2498,7492,536,40787,102495,23,494,1,31617.25,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2499,7492,536,40787,102495,23,476,2,31617.25,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2500,7492,537,40787,102495,23,110,1,501823.59,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2501,7492,537,40787,102495,23,476,2,501823.59,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2502,7492,538,40787,102495,23,157,1,25514.90,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2503,7492,538,40787,102495,23,476,2,25514.90,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2504,7492,539,40787,102495,23,396,1,21125.87,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2505,7492,539,40787,102495,23,476,2,21125.87,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2506,7492,540,40787,102495,23,180,1,115431.15,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2507,7492,540,40787,102495,23,476,2,115431.15,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2508,7492,541,40787,102495,23,520,1,3679.57,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2509,7492,541,40787,102495,23,476,2,3679.57,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2510,7492,542,40787,102495,23,120,1,1207.48,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2511,7492,542,40787,102495,23,476,2,1207.48,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2512,7492,543,40787,102495,23,489,1,28209.00,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2513,7492,543,40787,102495,23,476,2,28209.00,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2514,7492,544,40787,102495,23,492,1,646.10,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2515,7492,544,40787,102495,23,476,2,646.10,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2516,7492,545,40787,102495,23,491,1,23177.40,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2517,7492,545,40787,102495,23,476,2,23177.40,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2518,7492,546,40787,102495,23,277,2,4236.88,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2519,7492,546,40787,102495,23,476,1,4236.88,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2520,7492,547,40787,102495,23,191,1,119728.95,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2521,7492,547,40787,102495,23,476,2,119728.95,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2522,7492,548,40787,102495,23,482,2,1993788.25,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2523,7492,548,40787,102495,23,476,1,1993788.25,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2524,7492,549,40787,102495,23,514,1,210.53,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2525,7492,549,40787,102495,23,476,2,210.53,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2526,7492,550,40787,102495,23,137,1,796.55,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07');
INSERT INTO `balance_libro_details` VALUES (2527,7492,550,40787,102495,23,476,2,796.55,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2528,7492,551,40787,102495,23,193,1,27197.16,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2529,7492,551,40787,102495,23,476,2,27197.16,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2530,7492,552,40787,102495,23,483,1,15808.62,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2531,7492,552,40787,102495,23,476,2,15808.62,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2532,7492,553,40787,102495,23,116,1,41102.42,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2533,7492,553,40787,102495,23,476,2,41102.42,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2534,7492,554,40787,102496,23,489,1,21387.46,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2535,7492,554,40787,102496,23,476,2,21387.46,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2536,7492,555,40787,102496,23,492,1,461.59,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2537,7492,555,40787,102496,23,476,2,461.59,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2538,7492,556,40787,102496,23,515,1,45371.05,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2539,7492,556,40787,102496,23,476,2,45371.05,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2540,7492,557,40787,102496,23,491,1,29066.69,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2541,7492,557,40787,102496,23,476,2,29066.69,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2542,7492,558,40787,102496,23,110,1,378301.85,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2543,7492,558,40787,102496,23,476,2,378301.85,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2544,7492,559,40787,102496,23,225,2,3211.50,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2545,7492,559,40787,102496,23,476,1,3211.50,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2546,7492,560,40787,102496,23,157,1,70849.72,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2547,7492,560,40787,102496,23,476,2,70849.72,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2548,7492,561,40787,102496,23,503,1,1219.70,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2549,7492,561,40787,102496,23,476,2,1219.70,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2550,7492,562,40787,102496,23,226,2,341.02,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2551,7492,562,40787,102496,23,476,1,341.02,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2552,7492,563,40787,102496,23,137,1,30739.77,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2553,7492,563,40787,102496,23,476,2,30739.77,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2554,7492,564,40787,102496,23,482,2,4778098.79,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2555,7492,564,40787,102496,23,476,1,4778098.79,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2556,7492,565,40787,102496,23,193,1,1179.22,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2557,7492,565,40787,102496,23,476,2,1179.22,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2558,7492,566,40787,102496,23,483,1,9036.72,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2559,7492,566,40787,102496,23,476,2,9036.72,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2560,7492,567,40787,102496,23,116,1,29369.33,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07');
INSERT INTO `balance_libro_details` VALUES (2561,7492,567,40787,102496,23,476,2,29369.33,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2562,7492,568,40787,102496,23,135,1,67168.11,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2563,7492,568,40787,102496,23,476,2,67168.11,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2564,7492,569,40787,102496,23,490,1,20630.44,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2565,7492,569,40787,102496,23,476,2,20630.44,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2566,7492,570,40787,102496,23,488,1,1395.12,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2567,7492,570,40787,102496,23,476,2,1395.12,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2568,7492,571,40787,102496,23,191,1,78261.78,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2569,7492,571,40787,102496,23,476,2,78261.78,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2570,7492,572,40787,102496,23,493,1,710.39,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2571,7492,572,40787,102496,23,476,2,710.39,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2572,7492,573,40787,102496,23,198,1,335.42,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2573,7492,573,40787,102496,23,476,2,335.42,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2574,7492,574,40787,102496,23,392,1,573581.27,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2575,7492,574,40787,102496,23,476,2,573581.27,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2576,7492,575,40787,102496,23,97,1,1379.29,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2577,7492,575,40787,102496,23,476,2,1379.29,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2578,7492,576,40787,102496,23,208,1,8102.91,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2579,7492,576,40787,102496,23,476,2,8102.91,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2580,7492,577,40787,102496,23,521,1,11626.93,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2581,7492,577,40787,102496,23,476,2,11626.93,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2582,7492,578,40787,102496,23,507,1,19744.44,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2583,7492,578,40787,102496,23,476,2,19744.44,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2584,7492,579,40787,102496,23,496,1,111349.56,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2585,7492,579,40787,102496,23,476,2,111349.56,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2586,7492,580,40787,102496,23,396,1,23510.13,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2587,7492,580,40787,102496,23,476,2,23510.13,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2588,7492,581,40787,102496,23,520,1,3133.50,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2589,7492,581,40787,102496,23,476,2,3133.50,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2590,7492,582,40787,102496,23,180,1,15200.12,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2591,7492,582,40787,102496,23,476,2,15200.12,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2592,7492,583,40787,102496,23,140,1,2.88,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2593,7492,583,40787,102496,23,476,2,2.88,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2594,7492,584,40787,102496,23,120,1,6312.73,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07');
INSERT INTO `balance_libro_details` VALUES (2595,7492,584,40787,102496,23,476,2,6312.73,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2596,7492,585,40787,102497,23,489,1,9964.28,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2597,7492,585,40787,102497,23,476,2,9964.28,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2598,7492,586,40787,102497,23,1031,1,10185.64,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2599,7492,586,40787,102497,23,476,2,10185.64,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2600,7492,587,40787,102497,23,515,1,28924.32,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2601,7492,587,40787,102497,23,476,2,28924.32,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2602,7492,588,40787,102497,23,198,1,339.88,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2603,7492,588,40787,102497,23,476,2,339.88,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2604,7492,589,40787,102497,23,110,1,344385.86,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2605,7492,589,40787,102497,23,476,2,344385.86,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2606,7492,590,40787,102497,23,135,1,106265.36,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2607,7492,590,40787,102497,23,476,2,106265.36,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2608,7492,591,40787,102497,23,392,1,1165335.15,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2609,7492,591,40787,102497,23,476,2,1165335.15,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2610,7492,592,40787,102497,23,1030,1,3081.76,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2611,7492,592,40787,102497,23,476,2,3081.76,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2612,7492,593,40787,102497,23,396,1,15268.89,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2613,7492,593,40787,102497,23,476,2,15268.89,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2614,7492,594,40787,102497,23,495,1,703.44,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2615,7492,594,40787,102497,23,476,2,703.44,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2616,7492,595,40787,102497,23,483,1,2695.36,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2617,7492,595,40787,102497,23,476,2,2695.36,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2618,7492,596,40787,102497,23,488,1,526.26,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2619,7492,596,40787,102497,23,476,2,526.26,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2620,7492,597,40787,102497,23,121,1,17519.87,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2621,7492,597,40787,102497,23,476,2,17519.87,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2622,7492,598,40787,102497,23,191,1,64116.92,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2623,7492,598,40787,102497,23,476,2,64116.92,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2624,7492,599,40787,102497,23,490,1,10350.28,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2625,7492,599,40787,102497,23,476,2,10350.28,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2626,7492,600,40787,102497,23,521,1,11964.73,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2627,7492,600,40787,102497,23,476,2,11964.73,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2628,7492,601,40787,102497,23,514,1,188.98,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07');
INSERT INTO `balance_libro_details` VALUES (2629,7492,601,40787,102497,23,476,2,188.98,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2630,7492,602,40787,102497,23,493,1,616.69,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2631,7492,602,40787,102497,23,476,2,616.69,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2632,7492,603,40787,102497,23,491,1,10976.26,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2633,7492,603,40787,102497,23,476,2,10976.26,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2634,7492,604,40787,102497,23,157,1,38631.50,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2635,7492,604,40787,102497,23,476,2,38631.50,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2636,7492,605,40787,102497,23,503,1,1546.05,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2637,7492,605,40787,102497,23,476,2,1546.05,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2638,7492,606,40787,102497,23,482,2,5686111.51,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2639,7492,606,40787,102497,23,476,1,5686111.51,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2640,7492,607,40787,102497,23,494,1,14186.13,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2641,7492,607,40787,102497,23,476,2,14186.13,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2642,7492,608,40787,102497,23,496,1,142152.79,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2643,7492,608,40787,102497,23,476,2,142152.79,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2644,7492,609,40787,102497,23,180,1,12830.35,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2645,7492,609,40787,102497,23,476,2,12830.35,NULL,'2023-11-05 13:48:18','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2646,7492,610,40787,102497,23,120,1,280.21,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2647,7492,610,40787,102497,23,476,2,280.21,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2648,7492,611,40787,102497,23,520,1,526.26,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2649,7492,611,40787,102497,23,476,2,526.26,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2650,7492,612,40787,102498,23,180,1,9296.82,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2651,7492,612,40787,102498,23,476,2,9296.82,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2652,7492,613,40787,102498,23,521,1,2855.87,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2653,7492,613,40787,102498,23,476,2,2855.87,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2654,7492,614,40787,102498,23,120,1,2294.26,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2655,7492,614,40787,102498,23,476,2,2294.26,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2656,7492,615,40787,102498,23,493,1,297.54,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2657,7492,615,40787,102498,23,476,2,297.54,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2658,7492,616,40787,102498,23,392,1,512821.77,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2659,7492,616,40787,102498,23,476,2,512821.77,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2660,7492,617,40787,102498,23,482,2,573789.97,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2661,7492,617,40787,102498,23,476,1,573789.97,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2662,7492,618,40787,102498,23,496,1,14344.75,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07');
INSERT INTO `balance_libro_details` VALUES (2663,7492,618,40787,102498,23,476,2,14344.75,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2664,7492,619,40787,102498,23,191,1,35557.56,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2665,7492,619,40787,102498,23,476,2,35557.56,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2666,7492,620,40787,102498,23,514,1,83.94,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2667,7492,620,40787,102498,23,476,2,83.94,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2668,7492,621,40787,102498,23,198,1,1256.31,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2669,7492,621,40787,102498,23,476,2,1256.31,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2670,7492,622,40787,102498,23,495,1,295.08,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2671,7492,622,40787,102498,23,476,2,295.08,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2672,7492,623,40787,102498,23,135,1,2582.83,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2673,7492,623,40787,102498,23,476,2,2582.83,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2674,7492,624,40787,102498,23,116,1,8725.41,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2675,7492,624,40787,102498,23,476,2,8725.41,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2676,7492,625,40787,102498,23,483,1,2410.09,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2677,7492,625,40787,102498,23,476,2,2410.09,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2678,7492,626,40787,102498,23,490,1,3707.99,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2679,7492,626,40787,102498,23,476,2,3707.99,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2680,7492,627,40787,102498,23,157,1,16846.69,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2681,7492,627,40787,102498,23,476,2,16846.69,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2682,7492,628,40787,102498,23,491,1,4784.33,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2683,7492,628,40787,102498,23,476,2,4784.33,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2684,7492,629,40787,102498,23,515,1,15830.62,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2685,7492,629,40787,102498,23,476,2,15830.62,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2686,7492,630,40787,102498,23,396,1,18649.49,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2687,7492,630,40787,102498,23,476,2,18649.49,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2688,7492,631,40787,102498,23,110,1,162245.86,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2689,7492,631,40787,102498,23,476,2,162245.86,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2690,7492,632,40787,102498,23,503,1,449.66,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2691,7492,632,40787,102498,23,476,2,449.66,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2692,7492,633,40787,102498,23,489,1,1344.76,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2693,7492,633,40787,102498,23,476,2,1344.76,NULL,'2023-11-05 13:48:19','2023-11-05 14:01:07','2023-11-05 14:01:07'),(2694,7492,634,40787,102487,12,359,1,139313.91,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2695,7492,634,40787,102487,12,484,1,3227.09,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2696,7492,634,40787,102487,12,166,1,1150694.78,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36');
INSERT INTO `balance_libro_details` VALUES (2697,7492,634,40787,102487,12,165,1,27041.52,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2698,7492,634,40787,102487,12,13,1,1568953.87,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2699,7492,634,40787,102487,12,24,1,117867.73,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2700,7492,634,40787,102487,12,497,1,19410.03,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2701,7492,634,40787,102487,12,498,1,2222.19,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2702,7492,634,40787,102487,12,20,1,125777.75,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2703,7492,634,40787,102487,12,1037,1,79594.84,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2704,7492,634,40787,102487,12,252,1,594.72,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2705,7492,634,40787,102487,12,23,1,569083.29,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2706,7492,634,40787,102487,12,485,1,49529.27,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2707,7492,634,40787,102487,12,508,1,1532.58,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2708,7492,634,40787,102487,12,162,1,72131.14,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2709,7492,634,40787,102487,12,354,1,207835.23,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2710,7492,634,40787,102487,12,392,1,4311706.44,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2711,7492,634,40787,102487,12,419,1,4144760.05,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2712,7492,634,40787,102487,12,420,2,828952.01,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2713,7492,634,40787,102487,12,363,1,952513.61,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2714,7492,634,40787,102487,12,48,2,108815.72,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2715,7492,634,40787,102487,12,506,2,1140325.25,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2716,7492,634,40787,102487,12,1029,2,120977.18,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2717,7492,634,40787,102487,12,517,2,95714.44,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2718,7492,634,40787,102487,12,516,2,595.36,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2719,7492,634,40787,102487,12,1027,2,1702.50,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2720,7492,634,40787,102487,12,518,2,21740.64,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2721,7492,634,40787,102487,12,64,2,8528.66,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2722,7492,634,40787,102487,12,57,2,4842224.20,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2723,7492,634,40787,102487,12,62,2,874320.75,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2724,7492,634,40787,102487,12,63,2,334960.87,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2725,7492,634,40787,102487,12,411,2,820175.94,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2726,7492,634,40787,102487,12,369,2,100000.00,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2727,7492,634,40787,102487,12,88,2,716253.23,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2728,7492,634,40787,102487,12,381,2,175284.32,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2729,7492,634,40787,102487,12,383,2,892691.13,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36');
INSERT INTO `balance_libro_details` VALUES (2730,7492,634,40787,102487,12,92,2,2460527.84,NULL,'2023-11-06 19:24:39','2023-11-06 19:27:36','2023-11-06 19:27:36'),(2731,7492,635,40787,102487,12,91,1,2460527.83,NULL,'2023-11-06 19:26:20','2023-11-06 19:27:57','2023-11-06 19:27:57'),(2732,7492,635,40787,102487,12,92,2,2460527.83,NULL,'2023-11-06 19:26:20','2023-11-06 19:27:57','2023-11-06 19:27:57'),(2733,7492,636,40787,102487,12,359,1,139313.91,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2734,7492,636,40787,102487,12,484,1,3227.09,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2735,7492,636,40787,102487,12,166,1,1150694.78,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2736,7492,636,40787,102487,12,165,1,27041.52,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2737,7492,636,40787,102487,12,13,1,1568953.87,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2738,7492,636,40787,102487,12,24,1,117867.73,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2739,7492,636,40787,102487,12,497,1,19410.03,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2740,7492,636,40787,102487,12,498,1,2222.19,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2741,7492,636,40787,102487,12,20,1,125777.75,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2742,7492,636,40787,102487,12,1037,1,79594.84,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2743,7492,636,40787,102487,12,252,1,594.72,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2744,7492,636,40787,102487,12,23,1,569083.29,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2745,7492,636,40787,102487,12,485,1,49529.27,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2746,7492,636,40787,102487,12,508,1,1532.58,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2747,7492,636,40787,102487,12,162,1,72131.14,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2748,7492,636,40787,102487,12,354,1,207835.23,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2749,7492,636,40787,102487,12,392,1,4311706.44,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2750,7492,636,40787,102487,12,419,1,4144760.05,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2751,7492,636,40787,102487,12,420,2,828952.01,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2752,7492,636,40787,102487,12,363,1,952513.61,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2753,7492,636,40787,102487,12,48,2,108815.72,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2754,7492,636,40787,102487,12,506,2,1140325.25,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2755,7492,636,40787,102487,12,1029,2,120977.18,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2756,7492,636,40787,102487,12,517,2,95714.44,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2757,7492,636,40787,102487,12,516,2,595.36,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2758,7492,636,40787,102487,12,1027,2,1702.50,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2759,7492,636,40787,102487,12,518,2,21740.64,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2760,7492,636,40787,102487,12,64,2,8528.66,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2761,7492,636,40787,102487,12,57,2,4842224.20,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2762,7492,636,40787,102487,12,62,2,874320.75,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26');
INSERT INTO `balance_libro_details` VALUES (2763,7492,636,40787,102487,12,63,2,334960.87,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2764,7492,636,40787,102487,12,411,2,820175.94,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2765,7492,636,40787,102487,12,369,2,100000.00,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2766,7492,636,40787,102487,12,88,2,716253.23,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2767,7492,636,40787,102487,12,381,2,175284.32,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2768,7492,636,40787,102487,12,383,2,892691.13,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2769,7492,636,40787,102487,12,92,2,2460527.84,NULL,'2023-11-06 19:27:36','2023-11-08 08:48:26','2023-11-08 08:48:26'),(2770,7492,637,40787,102491,6,411,1,606017.30,NULL,'2023-11-06 19:34:12','2023-11-06 19:34:12',NULL),(2771,7492,637,40787,102491,6,20,2,188657.19,NULL,'2023-11-06 19:34:12','2023-11-06 19:34:12',NULL),(2772,7492,637,40787,102491,6,1037,2,79594.84,NULL,'2023-11-06 19:34:12','2023-11-06 19:34:12',NULL),(2773,7492,637,40787,102491,6,23,2,569083.29,NULL,'2023-11-06 19:34:12','2023-11-06 19:34:12',NULL),(2774,7492,637,40787,102491,6,24,1,231318.02,NULL,'2023-11-06 19:34:12','2023-11-06 19:34:12',NULL),(2775,7492,638,40787,102491,10,20,1,62879.44,NULL,'2023-11-06 19:34:58','2023-11-06 19:34:58',NULL),(2776,7492,638,40787,102491,10,166,2,62879.44,NULL,'2023-11-06 19:34:58','2023-11-06 19:34:58',NULL),(2777,7492,639,40787,102491,6,411,1,214158.65,NULL,'2023-11-06 19:36:20','2023-11-09 05:57:24','2023-11-09 05:57:24'),(2778,7492,639,40787,102491,6,155,2,214158.65,NULL,'2023-11-06 19:36:20','2023-11-09 05:57:24','2023-11-09 05:57:24'),(2779,7492,640,40787,102492,6,20,1,9233.50,NULL,'2023-11-06 19:38:35','2023-11-06 19:38:35',NULL),(2780,7492,640,40787,102492,6,166,2,9233.50,NULL,'2023-11-06 19:38:35','2023-11-06 19:38:35',NULL),(2781,7492,641,40787,102494,6,20,1,3076.60,NULL,'2023-11-06 19:38:58','2023-11-06 19:38:58',NULL),(2782,7492,641,40787,102494,6,166,2,3076.60,NULL,'2023-11-06 19:38:58','2023-11-06 19:38:58',NULL),(2783,7492,642,40787,102495,6,20,1,3076.60,NULL,'2023-11-06 19:39:15','2023-11-06 19:39:15',NULL),(2784,7492,642,40787,102495,6,166,2,3076.60,NULL,'2023-11-06 19:39:15','2023-11-06 19:39:15',NULL),(2785,7492,643,40787,102496,6,20,1,3076.60,NULL,'2023-11-06 19:39:31','2023-11-06 19:39:31',NULL),(2786,7492,643,40787,102496,6,166,2,3076.60,NULL,'2023-11-06 19:39:31','2023-11-06 19:39:31',NULL),(2787,7492,644,40787,102497,6,20,1,3076.60,NULL,'2023-11-06 19:39:47','2023-11-06 19:39:47',NULL),(2788,7492,644,40787,102497,6,166,2,3076.60,NULL,'2023-11-06 19:39:47','2023-11-06 19:39:47',NULL),(2789,7492,645,40787,102498,6,20,1,3076.60,NULL,'2023-11-06 19:40:03','2023-11-06 19:40:03',NULL),(2790,7492,645,40787,102498,6,166,2,3076.60,NULL,'2023-11-06 19:40:03','2023-11-06 19:40:03',NULL),(2791,7492,646,40787,102499,6,20,1,3076.60,NULL,'2023-11-06 19:40:23','2023-11-06 19:40:23',NULL),(2792,7492,646,40787,102499,6,166,2,3076.60,NULL,'2023-11-06 19:40:23','2023-11-06 19:40:23',NULL),(2793,7492,647,40787,102500,6,20,1,3076.60,NULL,'2023-11-06 19:40:42','2024-10-02 18:08:25','2024-10-02 18:08:25'),(2794,7492,647,40787,102500,6,166,2,3076.60,NULL,'2023-11-06 19:40:42','2024-10-02 18:08:25','2024-10-02 18:08:25'),(2795,7492,648,40787,102501,6,20,1,3076.60,NULL,'2023-11-06 19:40:57','2024-10-03 09:29:28','2024-10-03 09:29:28'),(2796,7492,648,40787,102501,6,166,2,3076.60,NULL,'2023-11-06 19:40:57','2024-10-03 09:29:28','2024-10-03 09:29:28'),(2797,7492,649,40787,102502,6,20,1,3076.60,NULL,'2023-11-06 19:41:30','2024-10-03 09:54:56','2024-10-03 09:54:56'),(2798,7492,649,40787,102502,6,166,2,3076.60,NULL,'2023-11-06 19:41:30','2024-10-03 09:54:56','2024-10-03 09:54:56'),(2799,7492,650,40787,102487,1,515,1,73636.01,NULL,'2023-11-06 19:45:53','2023-11-06 19:49:40','2023-11-06 19:49:40');
INSERT INTO `balance_libro_details` VALUES (2800,7492,650,40787,102487,1,111,1,200496.19,NULL,'2023-11-06 19:45:53','2023-11-06 19:49:40','2023-11-06 19:49:40'),(2801,7492,650,40787,102487,1,162,2,5798.88,NULL,'2023-11-06 19:45:53','2023-11-06 19:49:40','2023-11-06 19:49:40'),(2802,7492,650,40787,102487,1,516,2,520.94,NULL,'2023-11-06 19:45:53','2023-11-06 19:49:40','2023-11-06 19:49:40'),(2803,7492,650,40787,102487,1,517,2,73636.01,NULL,'2023-11-06 19:45:53','2023-11-06 19:49:40','2023-11-06 19:49:40'),(2804,7492,650,40787,102487,1,518,2,18502.12,NULL,'2023-11-06 19:45:53','2023-11-06 19:49:40','2023-11-06 19:49:40'),(2805,7492,650,40787,102487,1,62,2,603346.96,NULL,'2023-11-06 19:45:53','2023-11-06 19:49:40','2023-11-06 19:49:40'),(2806,7492,650,40787,102487,1,63,2,306987.22,NULL,'2023-11-06 19:45:53','2023-11-06 19:49:40','2023-11-06 19:49:40'),(2807,7492,650,40787,102487,1,64,2,13726.34,NULL,'2023-11-06 19:45:53','2023-11-06 19:49:40','2023-11-06 19:49:40'),(2808,7492,650,40787,102487,1,514,1,520.94,NULL,'2023-11-06 19:45:53','2023-11-06 19:49:40','2023-11-06 19:49:40'),(2809,7492,650,40787,102487,1,110,1,747865.33,NULL,'2023-11-06 19:45:53','2023-11-06 19:49:40','2023-11-06 19:49:40'),(2810,7492,651,40787,102487,1,515,1,73636.01,NULL,'2023-11-06 19:49:40','2023-11-06 19:49:40',NULL),(2811,7492,651,40787,102487,1,162,2,5798.88,NULL,'2023-11-06 19:49:40','2023-11-06 19:49:40',NULL),(2812,7492,651,40787,102487,1,516,2,520.94,NULL,'2023-11-06 19:49:40','2023-11-06 19:49:40',NULL),(2813,7492,651,40787,102487,1,517,2,73636.01,NULL,'2023-11-06 19:49:40','2023-11-06 19:49:40',NULL),(2814,7492,651,40787,102487,1,518,2,18502.12,NULL,'2023-11-06 19:49:40','2023-11-06 19:49:40',NULL),(2815,7492,651,40787,102487,1,62,2,603346.96,NULL,'2023-11-06 19:49:40','2023-11-06 19:49:40',NULL),(2816,7492,651,40787,102487,1,63,2,306987.22,NULL,'2023-11-06 19:49:40','2023-11-06 19:49:40',NULL),(2817,7492,651,40787,102487,1,64,2,13726.34,NULL,'2023-11-06 19:49:40','2023-11-06 19:49:40',NULL),(2818,7492,651,40787,102487,1,514,1,520.94,NULL,'2023-11-06 19:49:40','2023-11-06 19:49:40',NULL),(2819,7492,651,40787,102487,1,110,1,747865.33,NULL,'2023-11-06 19:49:40','2023-11-06 19:49:40',NULL),(2820,7492,651,40787,102487,1,191,1,200496.19,NULL,'2023-11-06 19:49:40','2023-11-06 19:49:40',NULL),(2821,7492,652,40787,102488,1,515,1,94469.91,NULL,'2023-11-06 19:52:45','2023-11-06 19:52:45',NULL),(2822,7492,652,40787,102488,1,162,2,25989.66,NULL,'2023-11-06 19:52:45','2023-11-06 19:52:45',NULL),(2823,7492,652,40787,102488,1,516,2,632.57,NULL,'2023-11-06 19:52:45','2023-11-06 19:52:45',NULL),(2824,7492,652,40787,102488,1,517,2,94469.91,NULL,'2023-11-06 19:52:45','2023-11-06 19:52:45',NULL),(2825,7492,652,40787,102488,1,518,2,23964.90,NULL,'2023-11-06 19:52:45','2023-11-06 19:52:45',NULL),(2826,7492,652,40787,102488,1,62,2,776749.46,NULL,'2023-11-06 19:52:45','2023-11-06 19:52:45',NULL),(2827,7492,652,40787,102488,1,63,2,371892.53,NULL,'2023-11-06 19:52:45','2023-11-06 19:52:45',NULL),(2828,7492,652,40787,102488,1,64,2,16789.32,NULL,'2023-11-06 19:52:45','2023-11-06 19:52:45',NULL),(2829,7492,652,40787,102488,1,191,1,241069.34,NULL,'2023-11-06 19:52:45','2023-11-06 19:52:45',NULL),(2830,7492,652,40787,102488,1,514,1,632.57,NULL,'2023-11-06 19:52:45','2023-11-06 19:52:45',NULL),(2831,7492,652,40787,102488,1,110,1,974316.53,NULL,'2023-11-06 19:52:45','2023-11-06 19:52:45',NULL),(2832,7492,653,40787,102489,1,515,1,111032.44,NULL,'2023-11-06 19:55:14','2023-11-06 19:55:14',NULL),(2833,7492,653,40787,102489,1,162,2,75444.71,NULL,'2023-11-06 19:55:14','2023-11-06 19:55:14',NULL),(2834,7492,653,40787,102489,1,516,2,669.78,NULL,'2023-11-06 19:55:14','2023-11-06 19:55:14',NULL),(2835,7492,653,40787,102489,1,517,2,111032.44,NULL,'2023-11-06 19:55:14','2023-11-06 19:55:14',NULL),(2836,7492,653,40787,102489,1,518,2,27951.48,NULL,'2023-11-06 19:55:14','2023-11-06 19:55:14',NULL),(2837,7492,653,40787,102489,1,62,2,917171.54,NULL,'2023-11-06 19:55:14','2023-11-06 19:55:14',NULL);
INSERT INTO `balance_libro_details` VALUES (2838,7492,653,40787,102489,1,63,2,390425.08,NULL,'2023-11-06 19:55:14','2023-11-06 19:55:14',NULL),(2839,7492,653,40787,102489,1,64,2,19100.30,NULL,'2023-11-06 19:55:14','2023-11-06 19:55:14',NULL),(2840,7492,653,40787,102489,1,110,1,1099934.45,NULL,'2023-11-06 19:55:14','2023-11-06 19:55:14',NULL),(2841,7492,653,40787,102489,1,514,1,669.78,NULL,'2023-11-06 19:55:14','2023-11-06 19:55:14',NULL),(2842,7492,653,40787,102489,1,191,1,330158.66,NULL,'2023-11-06 19:55:14','2023-11-06 19:55:14',NULL),(2843,7492,654,40787,102490,1,515,1,113268.80,NULL,'2023-11-06 19:58:20','2023-11-06 19:58:20',NULL),(2844,7492,654,40787,102490,1,162,2,56062.12,NULL,'2023-11-06 19:58:20','2023-11-06 19:58:20',NULL),(2845,7492,654,40787,102490,1,516,2,520.94,NULL,'2023-11-06 19:58:20','2023-11-06 19:58:20',NULL),(2846,7492,654,40787,102490,1,517,2,113268.80,NULL,'2023-11-06 19:58:20','2023-11-06 19:58:20',NULL),(2847,7492,654,40787,102490,1,518,2,28832.68,NULL,'2023-11-06 19:58:20','2023-11-06 19:58:20',NULL),(2848,7492,654,40787,102490,1,62,2,937215.52,NULL,'2023-11-06 19:58:20','2023-11-06 19:58:20',NULL),(2849,7492,654,40787,102490,1,63,2,453719.93,NULL,'2023-11-06 19:58:20','2023-11-06 19:58:20',NULL),(2850,7492,654,40787,102490,1,64,2,19559.33,NULL,'2023-11-06 19:58:20','2023-11-06 19:58:20',NULL),(2851,7492,654,40787,102490,1,110,1,1170712.20,NULL,'2023-11-06 19:58:20','2023-11-06 19:58:20',NULL),(2852,7492,654,40787,102490,1,514,1,520.94,NULL,'2023-11-06 19:58:20','2023-11-06 19:58:20',NULL),(2853,7492,654,40787,102490,1,191,1,324677.38,NULL,'2023-11-06 19:58:20','2023-11-06 19:58:20',NULL),(2854,7492,655,40787,102491,1,515,1,160684.05,NULL,'2023-11-06 20:01:01','2023-11-06 20:01:01',NULL),(2855,7492,655,40787,102491,1,162,2,116809.71,NULL,'2023-11-06 20:01:01','2023-11-06 20:01:01',NULL),(2856,7492,655,40787,102491,1,516,2,744.20,NULL,'2023-11-06 20:01:01','2023-11-06 20:01:01',NULL),(2857,7492,655,40787,102491,1,517,2,160684.05,NULL,'2023-11-06 20:01:01','2023-11-06 20:01:01',NULL),(2858,7492,655,40787,102491,1,518,2,36564.00,NULL,'2023-11-06 20:01:01','2023-11-06 20:01:01',NULL),(2859,7492,655,40787,102491,1,62,2,1333000.89,NULL,'2023-11-06 20:01:01','2023-11-06 20:01:01',NULL),(2860,7492,655,40787,102491,1,63,2,607483.59,NULL,'2023-11-06 20:01:01','2023-11-06 20:01:01',NULL),(2861,7492,655,40787,102491,1,64,2,27131.34,NULL,'2023-11-06 20:01:01','2023-11-06 20:01:01',NULL),(2862,7492,655,40787,102491,1,514,1,744.20,NULL,'2023-11-06 20:01:01','2023-11-06 20:01:01',NULL),(2863,7492,655,40787,102491,1,110,1,1667545.34,NULL,'2023-11-06 20:01:01','2023-11-06 20:01:01',NULL),(2864,7492,655,40787,102491,1,191,1,453444.19,NULL,'2023-11-06 20:01:01','2023-11-06 20:01:01',NULL),(2865,7492,656,40787,102492,1,515,1,227631.44,NULL,'2023-11-06 20:03:24','2023-11-06 20:03:24',NULL),(2866,7492,656,40787,102492,1,162,2,110522.63,NULL,'2023-11-06 20:03:24','2023-11-06 20:03:24',NULL),(2867,7492,656,40787,102492,1,516,2,706.99,NULL,'2023-11-06 20:03:24','2023-11-06 20:03:24',NULL),(2868,7492,656,40787,102492,1,517,2,227631.44,NULL,'2023-11-06 20:03:24','2023-11-06 20:03:24',NULL),(2869,7492,656,40787,102492,1,518,2,36409.70,NULL,'2023-11-06 20:03:24','2023-11-06 20:03:24',NULL),(2870,7492,656,40787,102492,1,62,2,1991738.51,NULL,'2023-11-06 20:03:24','2023-11-06 20:03:24',NULL),(2871,7492,656,40787,102492,1,63,2,760002.55,NULL,'2023-11-06 20:03:24','2023-11-06 20:03:24',NULL),(2872,7492,656,40787,102492,1,64,2,32842.25,NULL,'2023-11-06 20:03:24','2023-11-06 20:03:24',NULL),(2873,7492,656,40787,102492,1,110,1,2372184.51,NULL,'2023-11-06 20:03:24','2023-11-06 20:03:24',NULL),(2874,7492,656,40787,102492,1,514,1,706.99,NULL,'2023-11-06 20:03:24','2023-11-06 20:03:24',NULL),(2875,7492,656,40787,102492,1,191,1,559331.13,NULL,'2023-11-06 20:03:24','2023-11-06 20:03:24',NULL),(2876,7492,657,40787,102494,1,515,1,151098.92,NULL,'2023-11-06 20:08:03','2023-11-06 20:08:03',NULL),(2877,7492,657,40787,102494,1,162,2,77014.82,NULL,'2023-11-06 20:08:03','2023-11-06 20:08:03',NULL);
INSERT INTO `balance_libro_details` VALUES (2878,7492,657,40787,102494,1,516,2,669.78,NULL,'2023-11-06 20:08:03','2023-11-06 20:08:03',NULL),(2879,7492,657,40787,102494,1,517,2,151098.92,NULL,'2023-11-06 20:08:03','2023-11-06 20:08:03',NULL),(2880,7492,657,40787,102494,1,518,2,37070.64,NULL,'2023-11-06 20:08:03','2023-11-06 20:08:03',NULL),(2881,7492,657,40787,102494,1,62,2,1212124.05,NULL,'2023-11-06 20:08:03','2023-11-06 20:08:03',NULL),(2882,7492,657,40787,102494,1,63,2,571407.09,NULL,'2023-11-06 20:08:03','2023-11-06 20:08:03',NULL),(2883,7492,657,40787,102494,1,64,2,5667.20,NULL,'2023-11-06 20:08:03','2023-11-06 20:08:03',NULL),(2884,7492,657,40787,102494,1,191,1,398376.46,NULL,'2023-11-06 20:08:03','2023-11-06 20:08:03',NULL),(2885,7492,657,40787,102494,1,514,1,669.78,NULL,'2023-11-06 20:08:03','2023-11-06 20:08:03',NULL),(2886,7492,657,40787,102494,1,110,1,1504907.34,NULL,'2023-11-06 20:08:03','2023-11-06 20:08:03',NULL),(2887,7492,658,40787,102495,1,515,1,133297.81,NULL,'2023-11-06 20:09:48','2023-11-06 20:09:48',NULL),(2888,7492,658,40787,102495,1,162,2,20670.14,NULL,'2023-11-06 20:09:48','2023-11-06 20:09:48',NULL),(2889,7492,658,40787,102495,1,516,2,632.57,NULL,'2023-11-06 20:09:48','2023-11-06 20:09:48',NULL),(2890,7492,658,40787,102495,1,517,2,133297.81,NULL,'2023-11-06 20:09:48','2023-11-06 20:09:48',NULL),(2891,7492,658,40787,102495,1,518,2,37444.88,NULL,'2023-11-06 20:09:48','2023-11-06 20:09:48',NULL),(2892,7492,658,40787,102495,1,62,2,1099566.76,NULL,'2023-11-06 20:09:48','2023-11-06 20:09:48',NULL),(2893,7492,658,40787,102495,1,63,2,567117.53,NULL,'2023-11-06 20:09:48','2023-11-06 20:09:48',NULL),(2894,7492,658,40787,102495,1,64,2,10773.00,NULL,'2023-11-06 20:09:48','2023-11-06 20:09:48',NULL),(2895,7492,658,40787,102495,1,514,1,632.57,NULL,'2023-11-06 20:09:48','2023-11-06 20:09:48',NULL),(2896,7492,658,40787,102495,1,110,1,1375824.00,NULL,'2023-11-06 20:09:48','2023-11-06 20:09:48',NULL),(2897,7492,658,40787,102495,1,191,1,359748.31,NULL,'2023-11-06 20:09:48','2023-11-06 20:09:48',NULL),(2898,7492,659,40787,102496,1,515,1,166198.26,NULL,'2023-11-06 20:11:40','2023-11-06 20:11:40',NULL),(2899,7492,659,40787,102496,1,162,2,178441.75,NULL,'2023-11-06 20:11:40','2023-11-06 20:11:40',NULL),(2900,7492,659,40787,102496,1,516,2,1410.48,NULL,'2023-11-06 20:11:40','2023-11-06 20:11:40',NULL),(2901,7492,659,40787,102496,1,517,2,166198.26,NULL,'2023-11-06 20:11:40','2023-11-06 20:11:40',NULL),(2902,7492,659,40787,102496,1,518,2,40638.96,NULL,'2023-11-06 20:11:40','2023-11-06 20:11:40',NULL),(2903,7492,659,40787,102496,1,62,2,1121118.71,NULL,'2023-11-06 20:11:40','2023-11-06 20:11:40',NULL),(2904,7492,659,40787,102496,1,63,2,355731.97,NULL,'2023-11-06 20:11:40','2023-11-06 20:11:40',NULL),(2905,7492,659,40787,102496,1,64,2,9949.20,NULL,'2023-11-06 20:11:40','2023-11-06 20:11:40',NULL),(2906,7492,659,40787,102496,1,110,1,1376784.57,NULL,'2023-11-06 20:11:40','2023-11-06 20:11:40',NULL),(2907,7492,659,40787,102496,1,514,1,1410.48,NULL,'2023-11-06 20:11:40','2023-11-06 20:11:40',NULL),(2908,7492,659,40787,102496,1,191,1,329096.02,NULL,'2023-11-06 20:11:40','2023-11-06 20:11:40',NULL),(2909,7492,660,40787,102497,1,515,1,203891.58,NULL,'2023-11-06 20:13:22','2023-11-06 20:13:22',NULL),(2910,7492,660,40787,102497,1,162,2,309616.35,NULL,'2023-11-06 20:13:22','2023-11-06 20:13:22',NULL),(2911,7492,660,40787,102497,1,516,2,1332.12,NULL,'2023-11-06 20:13:22','2023-11-06 20:13:22',NULL),(2912,7492,660,40787,102497,1,517,2,203891.58,NULL,'2023-11-06 20:13:22','2023-11-06 20:13:22',NULL),(2913,7492,660,40787,102497,1,518,2,42219.16,NULL,'2023-11-06 20:13:22','2023-11-06 20:13:22',NULL),(2914,7492,660,40787,102497,1,62,2,1360657.48,NULL,'2023-11-06 20:13:22','2023-11-06 20:13:22',NULL),(2915,7492,660,40787,102497,1,63,2,424735.76,NULL,'2023-11-06 20:13:22','2023-11-06 20:13:22',NULL),(2916,7492,660,40787,102497,1,64,2,12364.40,NULL,'2023-11-06 20:13:22','2023-11-06 20:13:22',NULL),(2917,7492,660,40787,102497,1,110,1,1697624.00,NULL,'2023-11-06 20:13:22','2023-11-06 20:13:22',NULL);
INSERT INTO `balance_libro_details` VALUES (2918,7492,660,40787,102497,1,191,1,451969.15,NULL,'2023-11-06 20:13:22','2023-11-06 20:13:22',NULL),(2919,7492,660,40787,102497,1,514,1,1332.12,NULL,'2023-11-06 20:13:22','2023-11-06 20:13:22',NULL),(2920,7492,661,40787,102498,1,515,1,266023.72,NULL,'2023-11-06 20:15:27','2023-11-06 20:15:27',NULL),(2921,7492,661,40787,102498,1,162,2,78003.20,NULL,'2023-11-06 20:15:27','2023-11-06 20:15:27',NULL),(2922,7492,661,40787,102498,1,516,2,1410.48,NULL,'2023-11-06 20:15:27','2023-11-06 20:15:27',NULL),(2923,7492,661,40787,102498,1,517,2,266023.72,NULL,'2023-11-06 20:15:27','2023-11-06 20:15:27',NULL),(2924,7492,661,40787,102498,1,518,2,47953.80,NULL,'2023-11-06 20:15:27','2023-11-06 20:15:27',NULL),(2925,7492,661,40787,102498,1,62,2,1787041.28,NULL,'2023-11-06 20:15:27','2023-11-06 20:15:27',NULL),(2926,7492,661,40787,102498,1,63,2,889333.26,NULL,'2023-11-06 20:15:27','2023-11-06 20:15:27',NULL),(2927,7492,661,40787,102498,1,64,2,14631.00,NULL,'2023-11-06 20:15:27','2023-11-06 20:15:27',NULL),(2928,7492,661,40787,102498,1,110,1,2219440.00,NULL,'2023-11-06 20:15:27','2023-11-06 20:15:27',NULL),(2929,7492,661,40787,102498,1,514,1,1410.48,NULL,'2023-11-06 20:15:27','2023-11-06 20:15:27',NULL),(2930,7492,661,40787,102498,1,191,1,597522.54,NULL,'2023-11-06 20:15:27','2023-11-06 20:15:27',NULL),(2931,7492,662,40787,102499,1,515,1,422479.07,NULL,'2023-11-06 20:17:09','2023-11-06 20:17:09',NULL),(2932,7492,662,40787,102499,1,162,2,214741.11,NULL,'2023-11-06 20:17:09','2023-11-06 20:17:09',NULL),(2933,7492,662,40787,102499,1,516,2,1723.92,NULL,'2023-11-06 20:17:09','2023-11-06 20:17:09',NULL),(2934,7492,662,40787,102499,1,517,2,422479.07,NULL,'2023-11-06 20:17:09','2023-11-06 20:17:09',NULL),(2935,7492,662,40787,102499,1,518,2,60596.80,NULL,'2023-11-06 20:17:09','2023-11-06 20:17:09',NULL),(2936,7492,662,40787,102499,1,62,2,2858125.36,NULL,'2023-11-06 20:17:09','2023-11-06 20:17:09',NULL),(2937,7492,662,40787,102499,1,63,2,1336784.91,NULL,'2023-11-06 20:17:09','2023-11-06 20:17:09',NULL),(2938,7492,662,40787,102499,1,64,2,21473.77,NULL,'2023-11-06 20:17:09','2023-11-06 20:17:09',NULL),(2939,7492,662,40787,102499,1,191,1,963228.53,NULL,'2023-11-06 20:17:09','2023-11-06 20:17:09',NULL),(2940,7492,662,40787,102499,1,110,1,3528493.42,NULL,'2023-11-06 20:17:09','2023-11-06 20:17:09',NULL),(2941,7492,662,40787,102499,1,514,1,1723.92,NULL,'2023-11-06 20:17:09','2023-11-06 20:17:09',NULL),(2942,7492,663,40787,102487,3,1032,1,1504674.60,NULL,'2023-11-06 20:21:10','2023-11-08 08:55:09','2023-11-08 08:55:09'),(2943,7492,663,40787,102487,3,392,2,1504674.60,NULL,'2023-11-06 20:21:10','2023-11-08 08:55:09','2023-11-08 08:55:09'),(2944,7492,664,40787,102488,3,1032,1,4027735.52,NULL,'2023-11-06 20:21:56','2023-11-08 08:55:39','2023-11-08 08:55:39'),(2945,7492,664,40787,102488,3,392,2,4027735.52,NULL,'2023-11-06 20:21:56','2023-11-08 08:55:39','2023-11-08 08:55:39'),(2946,7492,665,40787,102489,3,1032,1,8671705.90,NULL,'2023-11-06 20:22:37','2023-11-08 08:56:04','2023-11-08 08:56:04'),(2947,7492,665,40787,102489,3,392,2,8671705.90,NULL,'2023-11-06 20:22:37','2023-11-08 08:56:04','2023-11-08 08:56:04'),(2948,7492,666,40787,102490,3,1032,1,2124082.39,NULL,'2023-11-06 20:23:15','2023-11-09 07:13:32','2023-11-09 07:13:32'),(2949,7492,666,40787,102490,3,392,2,2124082.39,NULL,'2023-11-06 20:23:15','2023-11-09 07:13:32','2023-11-09 07:13:32'),(2950,7492,667,40787,102491,3,1032,1,3910252.96,NULL,'2023-11-06 20:23:44','2023-11-06 20:23:44',NULL),(2951,7492,667,40787,102491,3,392,2,3910252.96,NULL,'2023-11-06 20:23:44','2023-11-06 20:23:44',NULL),(2952,7492,668,40787,102492,3,1032,1,6971930.99,NULL,'2023-11-06 20:24:09','2023-11-08 08:56:37','2023-11-08 08:56:37'),(2953,7492,668,40787,102492,3,392,2,6971930.99,NULL,'2023-11-06 20:24:09','2023-11-08 08:56:37','2023-11-08 08:56:37'),(2954,7492,669,40787,102494,3,1032,1,34516728.31,NULL,'2023-11-06 20:25:05','2023-11-08 08:58:31','2023-11-08 08:58:31');
INSERT INTO `balance_libro_details` VALUES (2955,7492,669,40787,102494,3,392,2,34516728.31,NULL,'2023-11-06 20:25:05','2023-11-08 08:58:31','2023-11-08 08:58:31'),(2956,7492,670,40787,102495,3,1032,1,3414707.17,NULL,'2023-11-06 20:25:22','2023-11-08 08:59:28','2023-11-08 08:59:28'),(2957,7492,670,40787,102495,3,392,2,3414707.17,NULL,'2023-11-06 20:25:22','2023-11-08 08:59:28','2023-11-08 08:59:28'),(2958,7492,671,40787,102496,3,1032,1,11452568.20,NULL,'2023-11-06 20:25:48','2023-11-08 08:57:19','2023-11-08 08:57:19'),(2959,7492,671,40787,102496,3,392,2,11452568.20,NULL,'2023-11-06 20:25:48','2023-11-08 08:57:19','2023-11-08 08:57:19'),(2960,7492,672,40787,102497,3,1032,1,22846850.58,NULL,'2023-11-06 20:26:10','2023-11-08 08:57:53','2023-11-08 08:57:53'),(2961,7492,672,40787,102497,3,392,2,22846850.58,NULL,'2023-11-06 20:26:10','2023-11-08 08:57:53','2023-11-08 08:57:53'),(2962,7492,673,40787,102498,3,1032,1,5496043.00,NULL,'2023-11-06 20:26:40','2023-11-08 08:59:57','2023-11-08 08:59:57'),(2963,7492,673,40787,102498,3,392,2,5496043.00,NULL,'2023-11-06 20:26:40','2023-11-08 08:59:57','2023-11-08 08:59:57'),(2964,7492,674,40787,102498,3,1032,1,5496043.00,NULL,'2023-11-06 20:26:40','2023-11-06 20:26:40',NULL),(2965,7492,674,40787,102498,3,392,2,5496043.00,NULL,'2023-11-06 20:26:40','2023-11-06 20:26:40',NULL),(2966,7492,675,40787,102499,3,1032,1,13387244.93,NULL,'2023-11-06 20:27:13','2023-11-08 08:42:53','2023-11-08 08:42:53'),(2967,7492,675,40787,102499,3,392,2,13387244.93,NULL,'2023-11-06 20:27:13','2023-11-08 08:42:53','2023-11-08 08:42:53'),(2968,7492,676,40787,102487,2,482,2,2639780.00,NULL,'2023-11-07 06:18:44','2023-11-07 06:18:44',NULL),(2969,7492,676,40787,102487,2,13,1,3194133.80,NULL,'2023-11-07 06:18:44','2023-11-07 06:18:44',NULL),(2970,7492,676,40787,102487,2,67,2,554353.80,NULL,'2023-11-07 06:18:44','2023-11-07 06:18:44',NULL),(2971,7492,677,40787,102488,2,482,2,7066202.67,NULL,'2023-11-07 06:19:24','2023-11-07 06:19:24',NULL),(2972,7492,677,40787,102488,2,13,1,8550105.23,NULL,'2023-11-07 06:19:24','2023-11-07 06:19:24',NULL),(2973,7492,677,40787,102488,2,67,2,1483902.56,NULL,'2023-11-07 06:19:24','2023-11-07 06:19:24',NULL),(2974,7492,678,40787,102489,2,482,2,15213519.13,NULL,'2023-11-07 06:19:57','2023-11-07 06:19:57',NULL),(2975,7492,678,40787,102489,2,13,1,18408358.15,NULL,'2023-11-07 06:19:57','2023-11-07 06:19:57',NULL),(2976,7492,678,40787,102489,2,67,2,3194839.02,NULL,'2023-11-07 06:19:57','2023-11-07 06:19:57',NULL),(2977,7492,679,40787,102490,2,482,2,3726460.32,NULL,'2023-11-07 06:21:15','2023-11-07 06:21:15',NULL),(2978,7492,679,40787,102490,2,13,1,4509016.99,NULL,'2023-11-07 06:21:15','2023-11-07 06:21:15',NULL),(2979,7492,679,40787,102490,2,67,2,782556.67,NULL,'2023-11-07 06:21:15','2023-11-07 06:21:15',NULL),(2980,7492,680,40787,102491,2,482,2,6860092.91,NULL,'2023-11-07 06:21:59','2023-11-07 06:21:59',NULL),(2981,7492,680,40787,102491,2,13,1,8300712.32,NULL,'2023-11-07 06:21:59','2023-11-07 06:21:59',NULL),(2982,7492,680,40787,102491,2,67,2,1440619.41,NULL,'2023-11-07 06:21:59','2023-11-07 06:21:59',NULL),(2983,7492,681,40787,102492,2,482,2,12231457.87,NULL,'2023-11-07 06:22:31','2023-11-07 06:22:31',NULL),(2984,7492,681,40787,102492,2,13,1,14800064.02,NULL,'2023-11-07 06:22:31','2023-11-07 06:22:31',NULL),(2985,7492,681,40787,102492,2,67,2,2568606.15,NULL,'2023-11-07 06:22:31','2023-11-07 06:22:31',NULL),(2986,7492,682,40787,102494,2,482,2,6055566.37,NULL,'2023-11-07 06:23:18','2023-11-07 06:23:18',NULL),(2987,7492,682,40787,102494,2,13,1,7327235.31,NULL,'2023-11-07 06:23:18','2023-11-07 06:23:18',NULL),(2988,7492,682,40787,102494,2,67,2,1271668.94,NULL,'2023-11-07 06:23:18','2023-11-07 06:23:18',NULL),(2989,7492,683,40787,102495,2,482,2,5990714.34,NULL,'2023-11-07 06:23:57','2023-11-07 06:23:57',NULL),(2990,7492,683,40787,102495,2,13,1,7248764.35,NULL,'2023-11-07 06:23:57','2023-11-07 06:23:57',NULL),(2991,7492,683,40787,102495,2,67,2,1258050.01,NULL,'2023-11-07 06:23:57','2023-11-07 06:23:57',NULL);
INSERT INTO `balance_libro_details` VALUES (2992,7492,684,40787,102496,2,482,2,20092224.92,NULL,'2023-11-07 06:24:34','2023-11-07 06:24:34',NULL),(2993,7492,684,40787,102496,2,13,1,24311592.15,NULL,'2023-11-07 06:24:34','2023-11-07 06:24:34',NULL),(2994,7492,684,40787,102496,2,67,2,4219367.23,NULL,'2023-11-07 06:24:34','2023-11-07 06:24:34',NULL),(2995,7492,685,40787,102497,2,482,2,40082194.00,NULL,'2023-11-07 06:25:11','2023-11-07 06:25:11',NULL),(2996,7492,685,40787,102497,2,13,1,48499454.74,NULL,'2023-11-07 06:25:11','2023-11-07 06:25:11',NULL),(2997,7492,685,40787,102497,2,67,2,8417260.74,NULL,'2023-11-07 06:25:11','2023-11-07 06:25:11',NULL),(2998,7492,686,40787,102498,2,482,2,9642180.71,NULL,'2023-11-07 06:25:43','2023-11-07 06:25:43',NULL),(2999,7492,686,40787,102498,2,13,1,11667038.66,NULL,'2023-11-07 06:25:43','2023-11-07 06:25:43',NULL),(3000,7492,686,40787,102498,2,67,2,2024857.95,NULL,'2023-11-07 06:25:43','2023-11-07 06:25:43',NULL),(3001,7492,687,40787,102499,2,482,2,23486394.61,NULL,'2023-11-07 06:26:16','2023-11-07 06:26:16',NULL),(3002,7492,687,40787,102499,2,13,1,28418537.48,NULL,'2023-11-07 06:26:16','2023-11-07 06:26:16',NULL),(3003,7492,687,40787,102499,2,67,2,4932142.87,NULL,'2023-11-07 06:26:16','2023-11-07 06:26:16',NULL),(3004,7492,688,40787,102487,3,160,1,16125.79,NULL,'2023-11-07 06:37:08','2023-11-07 06:37:08',NULL),(3005,7492,688,40787,102487,3,199,1,6687.26,NULL,'2023-11-07 06:37:08','2023-11-07 06:37:08',NULL),(3006,7492,688,40787,102487,3,198,1,13494.09,NULL,'2023-11-07 06:37:08','2023-11-07 06:37:08',NULL),(3007,7492,688,40787,102487,3,128,1,29795.53,NULL,'2023-11-07 06:37:08','2023-11-07 06:37:08',NULL),(3008,7492,688,40787,102487,3,212,1,18985.17,NULL,'2023-11-07 06:37:08','2023-11-07 06:37:08',NULL),(3009,7492,688,40787,102487,3,121,1,18701.32,NULL,'2023-11-07 06:37:08','2023-11-07 06:37:08',NULL),(3010,7492,688,40787,102487,3,180,1,41889.75,NULL,'2023-11-07 06:37:08','2023-11-07 06:37:08',NULL),(3011,7492,688,40787,102487,3,483,1,37500.00,NULL,'2023-11-07 06:37:08','2023-11-07 06:37:08',NULL),(3012,7492,688,40787,102487,3,193,1,85000.00,NULL,'2023-11-07 06:37:08','2023-11-07 06:37:08',NULL),(3013,7492,688,40787,102487,3,507,1,29067.90,NULL,'2023-11-07 06:37:08','2023-11-07 06:37:08',NULL),(3014,7492,688,40787,102487,3,68,1,208182.53,NULL,'2023-11-07 06:37:08','2023-11-07 06:37:08',NULL),(3015,7492,688,40787,102487,3,485,1,2053.08,NULL,'2023-11-07 06:37:08','2023-11-07 06:37:08',NULL),(3016,7492,688,40787,102487,3,486,1,14980.81,NULL,'2023-11-07 06:37:08','2023-11-07 06:37:08',NULL),(3017,7492,688,40787,102487,3,484,1,1223.94,NULL,'2023-11-07 06:37:08','2023-11-07 06:37:08',NULL),(3018,7492,688,40787,102487,3,503,1,1682.19,NULL,'2023-11-07 06:37:08','2023-11-07 06:37:08',NULL),(3019,7492,688,40787,102487,3,166,2,806554.73,NULL,'2023-11-07 06:37:08','2023-11-07 06:37:08',NULL),(3020,7492,688,40787,102487,3,359,2,550840.94,NULL,'2023-11-07 06:37:08','2023-11-07 06:37:08',NULL),(3021,7492,688,40787,102487,3,392,1,832026.31,NULL,'2023-11-07 06:37:08','2023-11-07 06:37:08',NULL),(3022,7492,689,40787,102488,3,160,1,18671.49,NULL,'2023-11-07 06:40:11','2023-11-07 06:40:11',NULL),(3023,7492,689,40787,102488,3,199,1,7486.04,NULL,'2023-11-07 06:40:11','2023-11-07 06:40:11',NULL),(3024,7492,689,40787,102488,3,198,1,1238.84,NULL,'2023-11-07 06:40:11','2023-11-07 06:40:11',NULL),(3025,7492,689,40787,102488,3,128,1,34663.42,NULL,'2023-11-07 06:40:11','2023-11-07 06:40:11',NULL),(3026,7492,689,40787,102488,3,212,1,14002.81,NULL,'2023-11-07 06:40:11','2023-11-07 06:40:11',NULL),(3027,7492,689,40787,102488,3,121,1,139669.44,NULL,'2023-11-07 06:40:11','2023-11-07 06:40:11',NULL),(3028,7492,689,40787,102488,3,483,1,30000.00,NULL,'2023-11-07 06:40:11','2023-11-07 06:40:11',NULL),(3029,7492,689,40787,102488,3,193,1,210000.00,NULL,'2023-11-07 06:40:11','2023-11-07 06:40:11',NULL),(3030,7492,689,40787,102488,3,68,1,241116.15,NULL,'2023-11-07 06:40:11','2023-11-07 06:40:11',NULL);
INSERT INTO `balance_libro_details` VALUES (3031,7492,689,40787,102488,3,485,1,1355.69,NULL,'2023-11-07 06:40:11','2023-11-07 06:40:11',NULL),(3032,7492,689,40787,102488,3,484,1,1487.98,NULL,'2023-11-07 06:40:11','2023-11-07 06:40:11',NULL),(3033,7492,689,40787,102488,3,503,1,1660.74,NULL,'2023-11-07 06:40:11','2023-11-07 06:40:11',NULL),(3034,7492,689,40787,102488,3,166,2,755847.12,NULL,'2023-11-07 06:40:11','2023-11-07 06:40:11',NULL),(3035,7492,689,40787,102488,3,359,2,1092943.21,NULL,'2023-11-07 06:40:11','2023-11-07 06:40:11',NULL),(3036,7492,689,40787,102488,3,392,1,966296.68,NULL,'2023-11-07 06:40:11','2023-11-07 06:40:11',NULL),(3037,7492,689,40787,102488,3,120,1,1950.40,NULL,'2023-11-07 06:40:11','2023-11-07 06:40:11',NULL),(3038,7492,689,40787,102488,3,180,1,79190.65,NULL,'2023-11-07 06:40:11','2023-11-07 06:40:11',NULL),(3039,7492,689,40787,102488,3,494,1,100000.00,NULL,'2023-11-07 06:40:11','2023-11-07 06:40:11',NULL),(3040,7492,690,40787,102489,3,160,1,18671.49,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3041,7492,690,40787,102489,3,199,1,8168.73,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3042,7492,690,40787,102489,3,198,1,1238.84,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3043,7492,690,40787,102489,3,128,1,37186.41,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3044,7492,690,40787,102489,3,212,1,28327.37,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3045,7492,690,40787,102489,3,121,1,39669.44,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3046,7492,690,40787,102489,3,180,1,173338.50,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3047,7492,690,40787,102489,3,483,1,30000.00,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3048,7492,690,40787,102489,3,193,1,874700.00,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3049,7492,690,40787,102489,3,68,1,463414.07,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3050,7492,690,40787,102489,3,485,1,1917.39,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3051,7492,690,40787,102489,3,484,1,1701.27,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3052,7492,690,40787,102489,3,166,2,2232055.07,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3053,7492,690,40787,102489,3,359,2,1279828.97,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3054,7492,690,40787,102489,3,392,1,1266319.68,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3055,7492,690,40787,102489,3,116,1,432000.00,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3056,7492,690,40787,102489,3,120,1,1363.44,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3057,7492,690,40787,102489,3,137,1,95278.09,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3058,7492,690,40787,102489,3,510,1,12396.69,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3059,7492,690,40787,102489,3,512,1,4082.63,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3060,7492,690,40787,102489,3,396,1,22110.00,NULL,'2023-11-07 06:44:02','2023-11-07 06:44:02',NULL),(3061,7492,691,40787,102490,3,160,1,20824.43,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(3062,7492,691,40787,102490,3,199,1,10865.87,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(3063,7492,691,40787,102490,3,198,1,1610.74,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(3064,7492,691,40787,102490,3,128,1,32681.69,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(3065,7492,691,40787,102490,3,180,1,63119.85,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(3066,7492,691,40787,102490,3,193,1,478305.70,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(3067,7492,691,40787,102490,3,507,1,82811.71,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(3068,7492,691,40787,102490,3,68,1,680890.03,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(3069,7492,691,40787,102490,3,485,1,6607.22,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(3070,7492,691,40787,102490,3,484,1,1998.74,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL);
INSERT INTO `balance_libro_details` VALUES (3071,7492,691,40787,102490,3,503,1,4433.78,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(3072,7492,691,40787,102490,3,166,2,3761620.95,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(3073,7492,691,40787,102490,3,359,2,763132.03,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(3074,7492,691,40787,102490,3,392,1,2788261.37,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(3075,7492,691,40787,102490,3,116,1,123500.00,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(3076,7492,691,40787,102490,3,137,1,130590.80,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(3077,7492,691,40787,102490,3,489,1,11935.03,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(3078,7492,691,40787,102490,3,483,1,37500.00,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(3079,7492,691,40787,102490,3,495,1,7438.02,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(3080,7492,691,40787,102490,3,396,1,41378.00,NULL,'2023-11-07 06:50:01','2023-11-07 06:50:01',NULL),(3081,7492,692,40787,102491,3,160,1,20824.43,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3082,7492,692,40787,102491,3,199,1,7672.27,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3083,7492,692,40787,102491,3,198,1,16695.94,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3084,7492,692,40787,102491,3,128,1,62487.02,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3085,7492,692,40787,102491,3,212,1,41006.39,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3086,7492,692,40787,102491,3,121,1,46281.04,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3087,7492,692,40787,102491,3,180,1,41015.75,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3088,7492,692,40787,102491,3,483,1,43000.00,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3089,7492,692,40787,102491,3,193,1,200000.00,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3090,7492,692,40787,102491,3,507,1,273491.65,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3091,7492,692,40787,102491,3,68,1,726772.02,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3092,7492,692,40787,102491,3,485,1,2521.54,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3093,7492,692,40787,102491,3,484,1,4878.27,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3094,7492,692,40787,102491,3,503,1,3993.69,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3095,7492,692,40787,102491,3,166,2,4553149.74,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3096,7492,692,40787,102491,3,392,1,819913.83,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3097,7492,692,40787,102491,3,116,1,123500.00,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3098,7492,692,40787,102491,3,137,1,2006337.20,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3099,7492,692,40787,102491,3,135,1,17436.36,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3100,7492,692,40787,102491,3,495,1,3719.01,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3101,7492,692,40787,102491,3,120,1,6603.33,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3102,7492,692,40787,102491,3,494,1,85000.00,NULL,'2023-11-07 06:55:38','2023-11-07 06:55:38',NULL),(3103,7492,693,40787,102492,3,160,1,22261.54,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3104,7492,693,40787,102492,3,199,1,8676.23,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3105,7492,693,40787,102492,3,198,1,1610.74,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3106,7492,693,40787,102492,3,128,1,86132.74,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3107,7492,693,40787,102492,3,212,1,48693.74,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3108,7492,693,40787,102492,3,180,1,234361.15,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3109,7492,693,40787,102492,3,483,1,52500.00,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3110,7492,693,40787,102492,3,193,1,200000.00,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL);
INSERT INTO `balance_libro_details` VALUES (3111,7492,693,40787,102492,3,507,1,165218.25,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3112,7492,693,40787,102492,3,68,1,439854.25,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3113,7492,693,40787,102492,3,485,1,3756.29,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3114,7492,693,40787,102492,3,484,1,5507.30,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3115,7492,693,40787,102492,3,503,1,1397.19,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3116,7492,693,40787,102492,3,166,2,2929487.63,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3117,7492,693,40787,102492,3,359,2,227025.23,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3118,7492,693,40787,102492,3,392,1,1288951.72,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3119,7492,693,40787,102492,3,137,1,19403.52,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3120,7492,693,40787,102492,3,363,1,89140.29,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3121,7492,693,40787,102492,3,495,1,3719.01,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3122,7492,693,40787,102492,3,120,1,5157.00,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3123,7492,693,40787,102492,3,494,1,285000.00,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3124,7492,693,40787,102492,3,396,1,119800.00,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3125,7492,693,40787,102492,3,501,1,75371.90,NULL,'2023-11-07 07:03:16','2023-11-07 07:03:16',NULL),(3126,7492,694,40787,102494,3,160,1,23797.29,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3127,7492,694,40787,102494,3,199,1,6223.11,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3128,7492,694,40787,102494,3,198,1,9090.90,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3129,7492,694,40787,102494,3,128,1,69765.69,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3130,7492,694,40787,102494,3,212,1,23081.92,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3131,7492,694,40787,102494,3,180,1,51397.90,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3132,7492,694,40787,102494,3,483,1,57000.00,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3133,7492,694,40787,102494,3,193,1,135000.00,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3134,7492,694,40787,102494,3,507,1,74537.44,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3135,7492,694,40787,102494,3,68,1,806461.39,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3136,7492,694,40787,102494,3,485,1,4196.39,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3137,7492,694,40787,102494,3,486,1,1498.71,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3138,7492,694,40787,102494,3,484,1,2830.28,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3139,7492,694,40787,102494,3,503,1,2734.75,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3140,7492,694,40787,102494,3,166,2,3849634.02,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3141,7492,694,40787,102494,3,359,2,878682.44,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3142,7492,694,40787,102494,3,392,1,3430889.08,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3143,7492,694,40787,102494,3,512,1,5223.13,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3144,7492,694,40787,102494,3,495,1,3719.01,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3145,7492,694,40787,102494,3,120,1,2330.57,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3146,7492,694,40787,102494,3,116,1,123500.00,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3147,7492,694,40787,102494,3,396,1,48609.38,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3148,7492,694,40787,102494,3,137,1,115055.40,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3149,7492,694,40787,102494,3,165,2,268625.88,NULL,'2023-11-07 07:07:40','2023-11-07 07:07:40',NULL),(3150,7492,695,40787,102495,3,160,1,25751.13,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL);
INSERT INTO `balance_libro_details` VALUES (3151,7492,695,40787,102495,3,199,1,3561.98,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3152,7492,695,40787,102495,3,198,1,1941.32,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3153,7492,695,40787,102495,3,128,1,83261.21,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3154,7492,695,40787,102495,3,212,1,84759.29,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3155,7492,695,40787,102495,3,180,1,346834.75,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3156,7492,695,40787,102495,3,483,1,47500.00,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3157,7492,695,40787,102495,3,193,1,78000.00,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3158,7492,695,40787,102495,3,68,1,397412.72,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3159,7492,695,40787,102495,3,485,1,3545.00,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3160,7492,695,40787,102495,3,484,1,4286.29,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3161,7492,695,40787,102495,3,166,2,1663697.26,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3162,7492,695,40787,102495,3,392,1,1366458.85,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3163,7492,695,40787,102495,3,116,1,123500.00,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3164,7492,695,40787,102495,3,120,1,3628.10,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3165,7492,695,40787,102495,3,396,1,63476.67,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3166,7492,695,40787,102495,3,165,2,630103.27,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3167,7492,695,40787,102495,3,57,2,441229.17,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3168,7492,695,40787,102495,3,494,1,95000.00,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3169,7492,695,40787,102495,3,137,1,2393.38,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3170,7492,695,40787,102495,3,495,1,3719.01,NULL,'2023-11-07 07:13:00','2023-11-07 07:13:00',NULL),(3171,7492,696,40787,102496,3,160,1,27723.98,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3172,7492,696,40787,102496,3,199,1,2987.24,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3173,7492,696,40787,102496,3,198,1,1941.00,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3174,7492,696,40787,102496,3,128,1,86752.36,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3175,7492,696,40787,102496,3,212,1,89935.72,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3176,7492,696,40787,102496,3,180,1,63917.50,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3177,7492,696,40787,102496,3,483,1,38000.00,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3178,7492,696,40787,102496,3,507,1,83026.67,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3179,7492,696,40787,102496,3,68,1,612166.23,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3180,7492,696,40787,102496,3,485,1,10445.08,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3181,7492,696,40787,102496,3,486,1,13504.56,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3182,7492,696,40787,102496,3,484,1,5577.41,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3183,7492,696,40787,102496,3,503,1,5128.94,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3184,7492,696,40787,102496,3,166,2,3397246.14,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3185,7492,696,40787,102496,3,392,1,2411947.60,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3186,7492,696,40787,102496,3,120,1,26545.45,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3187,7492,696,40787,102496,3,495,1,4958.68,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3188,7492,696,40787,102496,3,97,1,5800.00,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3189,7492,696,40787,102496,3,116,1,123500.00,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3190,7492,696,40787,102496,3,396,1,98861.66,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL);
INSERT INTO `balance_libro_details` VALUES (3191,7492,696,40787,102496,3,137,1,129262.80,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3192,7492,696,40787,102496,3,57,2,444736.74,NULL,'2023-11-07 07:18:38','2023-11-07 07:18:38',NULL),(3193,7492,697,40787,102497,3,160,1,29006.33,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3194,7492,697,40787,102497,3,199,1,4347.11,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3195,7492,697,40787,102497,3,198,1,2395.87,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3196,7492,697,40787,102497,3,128,1,72960.59,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3197,7492,697,40787,102497,3,212,1,70239.59,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3198,7492,697,40787,102497,3,180,1,90442.90,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3199,7492,697,40787,102497,3,483,1,19000.00,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3200,7492,697,40787,102497,3,68,1,1891648.92,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3201,7492,697,40787,102497,3,485,1,3623.33,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3202,7492,697,40787,102497,3,486,1,292.76,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3203,7492,697,40787,102497,3,484,1,5983.76,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3204,7492,697,40787,102497,3,503,1,10898.33,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3205,7492,697,40787,102497,3,166,2,9747380.82,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3206,7492,697,40787,102497,3,359,2,1329590.55,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3207,7492,697,40787,102497,3,392,1,8214610.19,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3208,7492,697,40787,102497,3,120,1,1975.24,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3209,7492,697,40787,102497,3,510,1,473265.18,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3210,7492,697,40787,102497,3,165,2,185346.28,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3211,7492,697,40787,102497,3,494,1,135536.35,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3212,7492,697,40787,102497,3,495,1,4958.68,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3213,7492,697,40787,102497,3,396,1,107632.52,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3214,7492,697,40787,102497,3,116,1,123500.00,NULL,'2023-11-07 08:58:30','2023-11-07 08:58:30',NULL),(3215,7492,698,40787,102498,3,160,1,29728.51,NULL,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL),(3216,7492,698,40787,102498,3,199,1,5000.00,NULL,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL),(3217,7492,698,40787,102498,3,198,1,21111.57,NULL,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL),(3218,7492,698,40787,102498,3,128,1,62310.47,NULL,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL),(3219,7492,698,40787,102498,3,212,1,22597.44,NULL,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL),(3220,7492,698,40787,102498,3,180,1,156227.25,NULL,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL),(3221,7492,698,40787,102498,3,483,1,40500.00,NULL,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL),(3222,7492,698,40787,102498,3,68,1,1908952.10,NULL,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL),(3223,7492,698,40787,102498,3,485,1,19103.00,NULL,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL),(3224,7492,698,40787,102498,3,484,1,10976.94,NULL,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL),(3225,7492,698,40787,102498,3,503,1,7556.24,NULL,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL),(3226,7492,698,40787,102498,3,166,2,5336455.20,NULL,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL),(3227,7492,698,40787,102498,3,359,2,1298908.00,NULL,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL),(3228,7492,698,40787,102498,3,120,1,38553.53,NULL,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL),(3229,7492,698,40787,102498,3,392,1,4260000.00,NULL,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL);
INSERT INTO `balance_libro_details` VALUES (3230,7492,698,40787,102498,3,116,1,146625.00,NULL,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL),(3231,7492,698,40787,102498,3,495,1,4958.68,NULL,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL),(3232,7492,698,40787,102498,3,396,1,313392.95,NULL,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL),(3233,7492,698,40787,102498,3,165,2,412230.48,NULL,'2023-11-07 09:21:07','2023-11-07 09:21:07',NULL),(3234,7492,699,40787,102499,3,160,1,31361.09,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3235,7492,699,40787,102499,3,199,1,5756.20,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3236,7492,699,40787,102499,3,198,1,2395.87,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3237,7492,699,40787,102499,3,128,1,52426.14,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3238,7492,699,40787,102499,3,212,1,45870.30,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3239,7492,699,40787,102499,3,180,1,185521.95,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3240,7492,699,40787,102499,3,483,1,40500.00,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3241,7492,699,40787,102499,3,193,1,200000.00,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3242,7492,699,40787,102499,3,68,1,1112551.84,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3243,7492,699,40787,102499,3,485,1,9671.37,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3244,7492,699,40787,102499,3,486,1,89281.24,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3245,7492,699,40787,102499,3,484,1,5297.30,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3246,7492,699,40787,102499,3,503,1,5754.36,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3247,7492,699,40787,102499,3,166,2,4114457.60,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3248,7492,699,40787,102499,3,495,1,43782.20,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3249,7492,699,40787,102499,3,392,1,4659614.59,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3250,7492,699,40787,102499,3,116,1,146625.00,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3251,7492,699,40787,102499,3,120,1,20264.48,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3252,7492,699,40787,102499,3,396,1,134850.00,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3253,7492,699,40787,102499,3,510,1,310820.00,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3254,7492,699,40787,102499,3,165,2,1855147.33,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3255,7492,699,40787,102499,3,57,2,1205239.00,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3256,7492,699,40787,102499,3,121,1,72500.00,NULL,'2023-11-07 09:30:21','2023-11-07 09:30:21',NULL),(3257,7492,700,40787,102487,15,68,2,208182.53,NULL,'2023-11-07 09:49:13','2023-11-07 09:49:13',NULL),(3258,7492,700,40787,102487,15,353,2,204846.00,NULL,'2023-11-07 09:49:13','2023-11-07 09:49:13',NULL),(3259,7492,700,40787,102487,15,484,2,1223.94,NULL,'2023-11-07 09:49:13','2023-11-07 09:49:13',NULL),(3260,7492,700,40787,102487,15,354,2,2898.23,NULL,'2023-11-07 09:49:13','2023-11-07 09:49:13',NULL),(3261,7492,700,40787,102487,15,67,1,554353.80,NULL,'2023-11-07 09:49:13','2023-11-07 09:49:13',NULL),(3262,7492,700,40787,102487,15,74,2,137203.10,NULL,'2023-11-07 09:49:13','2023-11-07 09:49:13',NULL),(3263,7492,701,40787,102488,15,68,2,241116.15,NULL,'2023-11-07 09:50:02','2023-11-07 09:50:02',NULL),(3264,7492,701,40787,102488,15,484,2,1487.98,NULL,'2023-11-07 09:50:02','2023-11-07 09:50:02',NULL),(3265,7492,701,40787,102488,15,67,1,1483902.56,NULL,'2023-11-07 09:50:02','2023-11-07 09:50:02',NULL),(3266,7492,701,40787,102488,15,74,2,1241298.43,NULL,'2023-11-07 09:50:02','2023-11-07 09:50:02',NULL),(3267,7492,702,40787,102489,15,68,2,463414.07,NULL,'2023-11-07 09:51:03','2023-11-07 09:51:03',NULL),(3268,7492,702,40787,102489,15,484,2,1701.27,NULL,'2023-11-07 09:51:03','2023-11-07 09:51:03',NULL);
INSERT INTO `balance_libro_details` VALUES (3269,7492,702,40787,102489,15,67,1,3194839.02,NULL,'2023-11-07 09:51:03','2023-11-07 09:51:03',NULL),(3270,7492,702,40787,102489,15,74,2,2729723.68,NULL,'2023-11-07 09:51:03','2023-11-07 09:51:03',NULL),(3271,7492,703,40787,102490,15,68,2,680890.03,NULL,'2023-11-07 09:52:36','2023-11-07 09:52:36',NULL),(3272,7492,703,40787,102490,15,353,1,251459.62,NULL,'2023-11-07 09:52:36','2023-11-07 09:52:36',NULL),(3273,7492,703,40787,102490,15,484,2,1998.74,NULL,'2023-11-07 09:52:36','2023-11-07 09:52:36',NULL),(3274,7492,703,40787,102490,15,354,1,1998.74,NULL,'2023-11-07 09:52:36','2023-11-07 09:52:36',NULL),(3275,7492,703,40787,102490,15,67,1,782556.67,NULL,'2023-11-07 09:52:36','2023-11-07 09:52:36',NULL),(3276,7492,703,40787,102490,15,74,2,353126.26,NULL,'2023-11-07 09:52:36','2023-11-07 09:52:36',NULL),(3277,7492,704,40787,102491,15,68,2,726772.02,NULL,'2023-11-07 09:53:36','2023-11-07 09:53:36',NULL),(3278,7492,704,40787,102491,15,353,2,251459.62,NULL,'2023-11-07 09:53:36','2023-11-07 09:53:36',NULL),(3279,7492,704,40787,102491,15,484,2,4878.27,NULL,'2023-11-07 09:53:36','2023-11-07 09:53:36',NULL),(3280,7492,704,40787,102491,15,354,2,1998.74,NULL,'2023-11-07 09:53:36','2023-11-07 09:53:36',NULL),(3281,7492,704,40787,102491,15,67,1,1440619.51,NULL,'2023-11-07 09:53:36','2023-11-07 09:53:36',NULL),(3282,7492,704,40787,102491,15,74,2,455510.86,NULL,'2023-11-07 09:53:36','2023-11-07 09:53:36',NULL),(3283,7492,705,40787,102492,15,68,2,439854.25,NULL,'2023-11-07 09:54:30','2023-11-07 09:54:30',NULL),(3284,7492,705,40787,102492,15,484,2,5507.30,NULL,'2023-11-07 09:54:30','2023-11-07 09:54:30',NULL),(3285,7492,705,40787,102492,15,67,1,2568606.15,NULL,'2023-11-07 09:54:30','2023-11-07 09:54:30',NULL),(3286,7492,705,40787,102492,15,74,2,2123244.60,NULL,'2023-11-07 09:54:30','2023-11-07 09:54:30',NULL),(3287,7492,706,40787,102494,15,68,2,806461.39,NULL,'2023-11-07 09:55:22','2023-11-07 09:55:22',NULL),(3288,7492,706,40787,102494,15,484,2,2830.28,NULL,'2023-11-07 09:55:22','2023-11-07 09:55:22',NULL),(3289,7492,706,40787,102494,15,67,1,1271668.94,NULL,'2023-11-07 09:55:23','2023-11-07 09:55:23',NULL),(3290,7492,706,40787,102494,15,74,2,462377.27,NULL,'2023-11-07 09:55:23','2023-11-07 09:55:23',NULL),(3291,7492,707,40787,102495,15,68,2,397412.72,NULL,'2023-11-07 09:56:26','2023-11-07 09:56:26',NULL),(3292,7492,707,40787,102495,15,484,2,4286.29,NULL,'2023-11-07 09:56:26','2023-11-07 09:56:26',NULL),(3293,7492,707,40787,102495,15,67,1,1258050.01,NULL,'2023-11-07 09:56:26','2023-11-07 09:56:26',NULL),(3294,7492,707,40787,102495,15,74,2,856351.00,NULL,'2023-11-07 09:56:26','2023-11-07 09:56:26',NULL),(3295,7492,708,40787,102496,15,68,2,612166.23,NULL,'2023-11-07 09:57:22','2023-11-07 09:57:22',NULL),(3296,7492,708,40787,102496,15,484,2,5577.41,NULL,'2023-11-07 09:57:22','2023-11-07 09:57:22',NULL),(3297,7492,708,40787,102496,15,67,1,4219367.23,NULL,'2023-11-07 09:57:22','2023-11-07 09:57:22',NULL),(3298,7492,708,40787,102496,15,74,2,3601623.59,NULL,'2023-11-07 09:57:22','2023-11-07 09:57:22',NULL),(3299,7492,709,40787,102497,15,68,2,1891648.92,NULL,'2023-11-07 09:58:05','2023-11-07 09:58:05',NULL),(3300,7492,709,40787,102497,15,484,2,5983.76,NULL,'2023-11-07 09:58:05','2023-11-07 09:58:05',NULL),(3301,7492,709,40787,102497,15,67,1,8417260.74,NULL,'2023-11-07 09:58:05','2023-11-07 09:58:05',NULL),(3302,7492,709,40787,102497,15,74,2,6519628.06,NULL,'2023-11-07 09:58:05','2023-11-07 09:58:05',NULL),(3303,7492,710,40787,102498,15,68,2,1908952.10,NULL,'2023-11-07 09:58:56','2023-11-07 09:58:56',NULL),(3304,7492,710,40787,102498,15,484,2,10976.94,NULL,'2023-11-07 09:58:56','2023-11-07 09:58:56',NULL),(3305,7492,710,40787,102498,15,67,1,2024857.95,NULL,'2023-11-07 09:58:56','2023-11-07 09:58:56',NULL),(3306,7492,710,40787,102498,15,74,2,104928.91,NULL,'2023-11-07 09:58:56','2023-11-07 09:58:56',NULL),(3307,7492,711,40787,102499,15,68,2,1112551.84,NULL,'2023-11-07 09:59:43','2023-11-07 09:59:43',NULL);
INSERT INTO `balance_libro_details` VALUES (3308,7492,711,40787,102499,15,484,2,5297.30,NULL,'2023-11-07 09:59:43','2023-11-07 09:59:43',NULL),(3309,7492,711,40787,102499,15,67,1,4932142.87,NULL,'2023-11-07 09:59:43','2023-11-07 09:59:43',NULL),(3310,7492,711,40787,102499,15,74,2,3814293.73,NULL,'2023-11-07 09:59:43','2023-11-07 09:59:43',NULL),(3311,7492,712,40787,102487,1,110,1,288000.00,NULL,'2023-11-07 10:03:25','2023-11-07 10:03:25',NULL),(3312,7492,712,40787,102487,1,166,2,288000.00,NULL,'2023-11-07 10:03:25','2023-11-07 10:03:25',NULL),(3313,7492,713,40787,102487,16,497,1,28380.05,NULL,'2023-11-07 10:05:03','2023-11-07 10:05:03',NULL),(3314,7492,713,40787,102487,16,499,2,7379.77,NULL,'2023-11-07 10:05:03','2023-11-07 10:05:03',NULL),(3315,7492,713,40787,102487,16,301,1,2783.17,NULL,'2023-11-07 10:05:03','2023-11-07 10:05:03',NULL),(3316,7492,713,40787,102487,16,496,1,22119.50,NULL,'2023-11-07 10:05:03','2023-11-07 10:05:03',NULL),(3317,7492,713,40787,102487,16,208,1,43875.00,NULL,'2023-11-07 10:05:03','2023-11-07 10:05:03',NULL),(3318,7492,713,40787,102487,16,508,2,14980.81,NULL,'2023-11-07 10:05:03','2023-11-07 10:05:03',NULL),(3319,7492,713,40787,102487,16,251,2,31677.39,NULL,'2023-11-07 10:05:03','2023-11-07 10:05:03',NULL),(3320,7492,713,40787,102487,16,252,2,41470.45,NULL,'2023-11-07 10:05:03','2023-11-07 10:05:03',NULL),(3321,7492,713,40787,102487,16,485,2,1649.30,NULL,'2023-11-07 10:05:03','2023-11-07 10:05:03',NULL),(3322,7492,714,40787,102488,1,110,1,110216.00,NULL,'2023-11-07 10:06:05','2023-11-07 10:06:05',NULL),(3323,7492,714,40787,102488,1,166,2,110216.00,NULL,'2023-11-07 10:06:05','2023-11-07 10:06:05',NULL),(3324,7492,715,40787,102489,1,110,1,121200.00,NULL,'2023-11-07 10:08:18','2023-11-07 10:08:18',NULL),(3325,7492,715,40787,102489,1,166,2,121200.00,NULL,'2023-11-07 10:08:18','2023-11-07 10:08:18',NULL),(3326,7492,716,40787,102488,16,252,2,11908.38,NULL,'2023-11-07 10:08:23','2023-11-07 10:08:23',NULL),(3327,7492,716,40787,102488,16,497,2,43910.09,NULL,'2023-11-07 10:08:23','2023-11-07 10:08:23',NULL),(3328,7492,716,40787,102488,16,499,2,2267.85,NULL,'2023-11-07 10:08:23','2023-11-07 10:08:23',NULL),(3329,7492,716,40787,102488,16,485,2,1355.69,NULL,'2023-11-07 10:08:23','2023-11-07 10:08:23',NULL),(3330,7492,716,40787,102488,16,327,2,117213.06,NULL,'2023-11-07 10:08:23','2023-11-07 10:08:23',NULL),(3331,7492,716,40787,102488,16,496,1,176655.07,NULL,'2023-11-07 10:08:23','2023-11-07 10:08:23',NULL),(3332,7492,717,40787,102489,16,252,2,10588.48,NULL,'2023-11-07 10:09:12','2023-11-07 10:09:12',NULL),(3333,7492,717,40787,102489,16,485,2,1917.39,NULL,'2023-11-07 10:09:12','2023-11-07 10:09:12',NULL),(3334,7492,717,40787,102489,16,327,2,367832.11,NULL,'2023-11-07 10:09:12','2023-11-07 10:09:12',NULL),(3335,7492,717,40787,102489,16,496,1,380337.98,NULL,'2023-11-07 10:09:12','2023-11-07 10:09:12',NULL),(3336,7492,718,40787,102490,1,110,1,223500.00,NULL,'2023-11-07 10:09:46','2023-11-07 10:09:46',NULL),(3337,7492,718,40787,102490,1,166,2,223500.00,NULL,'2023-11-07 10:09:46','2023-11-07 10:09:46',NULL),(3338,7492,719,40787,102490,16,499,2,19240.42,NULL,'2023-11-07 10:10:11','2023-11-07 10:10:11',NULL),(3339,7492,719,40787,102490,16,485,2,6607.22,NULL,'2023-11-07 10:10:11','2023-11-07 10:10:11',NULL),(3340,7492,719,40787,102490,16,327,2,25275.03,NULL,'2023-11-07 10:10:11','2023-11-07 10:10:11',NULL),(3341,7492,719,40787,102490,16,496,1,51122.67,NULL,'2023-11-07 10:10:11','2023-11-07 10:10:11',NULL),(3342,7492,720,40787,102491,1,110,1,182112.00,NULL,'2023-11-07 10:10:59','2023-11-07 10:10:59',NULL),(3343,7492,720,40787,102491,1,166,2,182112.00,NULL,'2023-11-07 10:10:59','2023-11-07 10:10:59',NULL),(3344,7492,721,40787,102491,16,252,2,41688.24,NULL,'2023-11-07 10:11:38','2023-11-07 10:11:38',NULL),(3345,7492,721,40787,102491,16,499,2,48464.31,NULL,'2023-11-07 10:11:38','2023-11-07 10:11:38',NULL),(3346,7492,721,40787,102491,16,485,2,4128.04,NULL,'2023-11-07 10:11:38','2023-11-07 10:11:38',NULL);
INSERT INTO `balance_libro_details` VALUES (3347,7492,721,40787,102491,16,327,2,77221.73,NULL,'2023-11-07 10:11:38','2023-11-07 10:11:38',NULL),(3348,7492,721,40787,102491,16,496,1,171502.32,NULL,'2023-11-07 10:11:38','2023-11-07 10:11:38',NULL),(3349,7492,722,40787,102492,16,252,2,43212.05,NULL,'2023-11-07 10:12:53','2023-11-07 10:12:53',NULL),(3350,7492,722,40787,102492,16,498,2,5005.36,NULL,'2023-11-07 10:12:53','2023-11-07 10:12:53',NULL),(3351,7492,722,40787,102492,16,499,2,39595.11,NULL,'2023-11-07 10:12:53','2023-11-07 10:12:53',NULL),(3352,7492,722,40787,102492,16,485,2,3756.29,NULL,'2023-11-07 10:12:53','2023-11-07 10:12:53',NULL),(3353,7492,722,40787,102492,16,326,2,18988.21,NULL,'2023-11-07 10:12:53','2023-11-07 10:12:53',NULL),(3354,7492,722,40787,102492,16,327,2,195229.43,NULL,'2023-11-07 10:12:53','2023-11-07 10:12:53',NULL),(3355,7492,722,40787,102492,16,208,1,23993.57,NULL,'2023-11-07 10:12:53','2023-11-07 10:12:53',NULL),(3356,7492,722,40787,102492,16,496,1,281792.88,NULL,'2023-11-07 10:12:53','2023-11-07 10:12:53',NULL),(3357,7492,723,40787,102492,1,110,1,162000.00,NULL,'2023-11-07 10:13:28','2023-11-07 10:13:28',NULL),(3358,7492,723,40787,102492,1,166,2,162000.00,NULL,'2023-11-07 10:13:28','2023-11-07 10:13:28',NULL),(3359,7492,724,40787,102494,16,252,2,54644.35,NULL,'2023-11-07 10:14:12','2023-11-07 10:14:12',NULL),(3360,7492,724,40787,102494,16,498,1,1498.71,NULL,'2023-11-07 10:14:12','2023-11-07 10:14:12',NULL),(3361,7492,724,40787,102494,16,499,2,41310.04,NULL,'2023-11-07 10:14:12','2023-11-07 10:14:12',NULL),(3362,7492,724,40787,102494,16,485,2,4196.39,NULL,'2023-11-07 10:14:12','2023-11-07 10:14:12',NULL),(3363,7492,724,40787,102494,16,486,2,1498.71,NULL,'2023-11-07 10:14:12','2023-11-07 10:14:12',NULL),(3364,7492,724,40787,102494,16,327,2,51238.38,NULL,'2023-11-07 10:14:12','2023-11-07 10:14:12',NULL),(3365,7492,724,40787,102494,16,496,1,151389.16,NULL,'2023-11-07 10:14:12','2023-11-07 10:14:12',NULL),(3366,7492,725,40787,102494,1,110,1,285000.00,NULL,'2023-11-07 10:14:18','2023-11-07 10:14:18',NULL),(3367,7492,725,40787,102494,1,166,2,285000.00,NULL,'2023-11-07 10:14:18','2023-11-07 10:14:18',NULL),(3368,7492,726,40787,102495,1,110,1,132000.00,NULL,'2023-11-07 10:15:33','2023-11-07 10:15:33',NULL),(3369,7492,726,40787,102495,1,166,2,132000.00,NULL,'2023-11-07 10:15:33','2023-11-07 10:15:33',NULL),(3370,7492,727,40787,102495,16,252,2,7405.20,NULL,'2023-11-07 10:15:41','2023-11-07 10:15:41',NULL),(3371,7492,727,40787,102495,16,498,1,361.36,NULL,'2023-11-07 10:15:41','2023-11-07 10:15:41',NULL),(3372,7492,727,40787,102495,16,499,2,12730.52,NULL,'2023-11-07 10:15:41','2023-11-07 10:15:41',NULL),(3373,7492,727,40787,102495,16,500,2,361.36,NULL,'2023-11-07 10:15:41','2023-11-07 10:15:41',NULL),(3374,7492,727,40787,102495,16,485,2,3545.00,NULL,'2023-11-07 10:15:41','2023-11-07 10:15:41',NULL),(3375,7492,727,40787,102495,16,327,2,126087.14,NULL,'2023-11-07 10:15:41','2023-11-07 10:15:41',NULL),(3376,7492,727,40787,102495,16,496,1,149767.86,NULL,'2023-11-07 10:15:41','2023-11-07 10:15:41',NULL),(3377,7492,728,40787,102496,16,252,2,64628.40,NULL,'2023-11-07 10:17:11','2023-11-07 10:17:11',NULL),(3378,7492,728,40787,102496,16,251,2,15258.82,NULL,'2023-11-07 10:17:11','2023-11-07 10:17:11',NULL),(3379,7492,728,40787,102496,16,498,2,1860.07,NULL,'2023-11-07 10:17:11','2023-11-07 10:17:11',NULL),(3380,7492,728,40787,102496,16,499,2,70323.12,NULL,'2023-11-07 10:17:11','2023-11-07 10:17:11',NULL),(3381,7492,728,40787,102496,16,485,2,10445.08,NULL,'2023-11-07 10:17:11','2023-11-07 10:17:11',NULL),(3382,7492,728,40787,102496,16,486,2,13504.56,NULL,'2023-11-07 10:17:11','2023-11-07 10:17:11',NULL),(3383,7492,728,40787,102496,16,326,2,3449.82,NULL,'2023-11-07 10:17:11','2023-11-07 10:17:11',NULL),(3384,7492,728,40787,102496,16,327,2,322835.75,NULL,'2023-11-07 10:17:11','2023-11-07 10:17:11',NULL),(3385,7492,728,40787,102496,16,208,1,34073.27,NULL,'2023-11-07 10:17:11','2023-11-07 10:17:11',NULL);
INSERT INTO `balance_libro_details` VALUES (3386,7492,728,40787,102496,16,496,1,468232.35,NULL,'2023-11-07 10:17:11','2023-11-07 10:17:11',NULL),(3387,7492,729,40787,102496,1,110,1,269000.00,NULL,'2023-11-07 10:17:28','2023-11-07 10:17:28',NULL),(3388,7492,729,40787,102496,1,165,2,269000.00,NULL,'2023-11-07 10:17:28','2023-11-07 10:17:28',NULL),(3389,7492,730,40787,102497,1,110,1,730000.00,NULL,'2023-11-07 10:18:15','2023-11-07 10:18:15',NULL),(3390,7492,730,40787,102497,1,166,2,730000.00,NULL,'2023-11-07 10:18:15','2023-11-07 10:18:15',NULL),(3391,7492,731,40787,102497,16,252,2,52584.05,NULL,'2023-11-07 10:18:33','2023-11-07 10:18:33',NULL),(3392,7492,731,40787,102497,16,498,1,292.75,NULL,'2023-11-07 10:18:33','2023-11-07 10:18:33',NULL),(3393,7492,731,40787,102497,16,499,2,86067.41,NULL,'2023-11-07 10:18:33','2023-11-07 10:18:33',NULL),(3394,7492,731,40787,102497,16,485,2,3623.33,NULL,'2023-11-07 10:18:33','2023-11-07 10:18:33',NULL),(3395,7492,731,40787,102497,16,486,2,292.76,NULL,'2023-11-07 10:18:33','2023-11-07 10:18:33',NULL),(3396,7492,731,40787,102497,16,327,2,859780.05,NULL,'2023-11-07 10:18:33','2023-11-07 10:18:33',NULL),(3397,7492,731,40787,102497,16,496,1,1002054.85,NULL,'2023-11-07 10:18:33','2023-11-07 10:18:33',NULL),(3398,7492,732,40787,102498,1,110,1,507000.00,NULL,'2023-11-07 10:19:00','2023-11-07 10:19:00',NULL),(3399,7492,732,40787,102498,1,166,2,507000.00,NULL,'2023-11-07 10:19:00','2023-11-07 10:19:00',NULL),(3400,7492,733,40787,102499,1,110,1,500000.00,NULL,'2023-11-07 10:19:57','2023-11-07 10:19:57',NULL),(3401,7492,733,40787,102499,1,166,2,500000.00,NULL,'2023-11-07 10:19:57','2023-11-07 10:19:57',NULL),(3402,7492,734,40787,102498,16,252,2,41795.24,NULL,'2023-11-07 10:20:03','2023-11-07 10:20:03',NULL),(3403,7492,734,40787,102498,16,498,1,154.75,NULL,'2023-11-07 10:20:03','2023-11-07 10:20:03',NULL),(3404,7492,734,40787,102498,16,499,2,64314.28,NULL,'2023-11-07 10:20:03','2023-11-07 10:20:03',NULL),(3405,7492,734,40787,102498,16,500,2,154.75,NULL,'2023-11-07 10:20:03','2023-11-07 10:20:03',NULL),(3406,7492,734,40787,102498,16,485,2,19103.01,NULL,'2023-11-07 10:20:03','2023-11-07 10:20:03',NULL),(3407,7492,734,40787,102498,16,327,2,115841.99,NULL,'2023-11-07 10:20:03','2023-11-07 10:20:03',NULL),(3408,7492,734,40787,102498,16,496,1,241054.52,NULL,'2023-11-07 10:20:03','2023-11-07 10:20:03',NULL),(3409,7492,735,40787,102499,16,252,2,192351.24,NULL,'2023-11-07 10:21:45','2023-11-07 10:21:45',NULL),(3410,7492,735,40787,102499,16,498,2,447.51,NULL,'2023-11-07 10:21:45','2023-11-07 10:21:45',NULL),(3411,7492,735,40787,102499,16,499,2,41282.76,NULL,'2023-11-07 10:21:45','2023-11-07 10:21:45',NULL),(3412,7492,735,40787,102499,16,485,2,9671.37,NULL,'2023-11-07 10:21:45','2023-11-07 10:21:45',NULL),(3413,7492,735,40787,102499,16,486,2,89281.24,NULL,'2023-11-07 10:21:45','2023-11-07 10:21:45',NULL),(3414,7492,735,40787,102499,16,326,2,9355.06,NULL,'2023-11-07 10:21:45','2023-11-07 10:21:45',NULL),(3415,7492,735,40787,102499,16,327,2,244770.68,NULL,'2023-11-07 10:21:45','2023-11-07 10:21:45',NULL),(3416,7492,735,40787,102499,16,208,1,99083.81,NULL,'2023-11-07 10:21:45','2023-11-07 10:21:45',NULL),(3417,7492,735,40787,102499,16,496,1,488076.05,NULL,'2023-11-07 10:21:45','2023-11-07 10:21:45',NULL),(3418,7492,736,40787,102487,1,63,1,334960.87,NULL,'2023-11-07 10:37:18','2023-11-07 10:37:18',NULL),(3419,7492,736,40787,102487,1,516,1,595.36,NULL,'2023-11-07 10:37:18','2023-11-07 10:37:18',NULL),(3420,7492,736,40787,102487,1,517,1,95714.44,NULL,'2023-11-07 10:37:18','2023-11-07 10:37:18',NULL),(3421,7492,736,40787,102487,1,64,1,8528.66,NULL,'2023-11-07 10:37:18','2023-11-07 10:37:18',NULL),(3422,7492,736,40787,102487,1,518,1,21145.28,NULL,'2023-11-07 10:37:18','2023-11-07 10:37:18',NULL),(3423,7492,736,40787,102487,1,519,1,1721.50,NULL,'2023-11-07 10:37:18','2023-11-07 10:37:18',NULL),(3424,7492,736,40787,102487,1,359,2,1721.50,NULL,'2023-11-07 10:37:18','2023-11-07 10:37:18',NULL);
INSERT INTO `balance_libro_details` VALUES (3425,7492,736,40787,102487,1,166,2,460944.61,NULL,'2023-11-07 10:37:18','2023-11-07 10:37:18',NULL),(3426,7492,737,40787,102488,1,63,1,306987.22,NULL,'2023-11-07 10:38:30','2023-11-07 10:38:30',NULL),(3427,7492,737,40787,102488,1,516,1,520.94,NULL,'2023-11-07 10:38:30','2023-11-07 10:38:30',NULL),(3428,7492,737,40787,102488,1,517,1,73636.01,NULL,'2023-11-07 10:38:30','2023-11-07 10:38:30',NULL),(3429,7492,737,40787,102488,1,64,1,13726.34,NULL,'2023-11-07 10:38:30','2023-11-07 10:38:30',NULL),(3430,7492,737,40787,102488,1,518,1,18502.12,NULL,'2023-11-07 10:38:30','2023-11-07 10:38:30',NULL),(3431,7492,737,40787,102488,1,519,1,1643.78,NULL,'2023-11-07 10:38:30','2023-11-07 10:38:30',NULL),(3432,7492,737,40787,102488,1,520,1,6790.73,NULL,'2023-11-07 10:38:30','2023-11-07 10:38:30',NULL),(3433,7492,737,40787,102488,1,359,2,1643.78,NULL,'2023-11-07 10:38:30','2023-11-07 10:38:30',NULL),(3434,7492,737,40787,102488,1,166,2,420163.36,NULL,'2023-11-07 10:38:30','2023-11-07 10:38:30',NULL),(3435,7492,738,40787,102489,1,63,1,371892.53,NULL,'2023-11-07 10:39:52','2023-11-07 10:39:52',NULL),(3436,7492,738,40787,102489,1,516,1,632.57,NULL,'2023-11-07 10:39:52','2023-11-07 10:39:52',NULL),(3437,7492,738,40787,102489,1,517,1,94469.91,NULL,'2023-11-07 10:39:52','2023-11-07 10:39:52',NULL),(3438,7492,738,40787,102489,1,64,1,16789.32,NULL,'2023-11-07 10:39:52','2023-11-07 10:39:52',NULL),(3439,7492,738,40787,102489,1,518,1,23964.90,NULL,'2023-11-07 10:39:52','2023-11-07 10:39:52',NULL),(3440,7492,738,40787,102489,1,519,1,2143.06,NULL,'2023-11-07 10:39:52','2023-11-07 10:39:52',NULL),(3441,7492,738,40787,102489,1,520,1,8118.97,NULL,'2023-11-07 10:39:52','2023-11-07 10:39:52',NULL),(3442,7492,738,40787,102489,1,359,2,2143.06,NULL,'2023-11-07 10:39:52','2023-11-07 10:39:52',NULL),(3443,7492,738,40787,102489,1,166,2,515868.20,NULL,'2023-11-07 10:39:52','2023-11-07 10:39:52',NULL),(3444,7492,739,40787,102490,1,63,1,390425.08,NULL,'2023-11-07 10:41:19','2023-11-07 10:41:19',NULL),(3445,7492,739,40787,102490,1,516,1,669.78,NULL,'2023-11-07 10:41:19','2023-11-07 10:41:19',NULL),(3446,7492,739,40787,102490,1,517,1,111032.44,NULL,'2023-11-07 10:41:19','2023-11-07 10:41:19',NULL),(3447,7492,739,40787,102490,1,64,1,19100.30,NULL,'2023-11-07 10:41:19','2023-11-07 10:41:19',NULL),(3448,7492,739,40787,102490,1,518,1,27951.48,NULL,'2023-11-07 10:41:19','2023-11-07 10:41:19',NULL),(3449,7492,739,40787,102490,1,519,1,2365.32,NULL,'2023-11-07 10:41:19','2023-11-07 10:41:19',NULL),(3450,7492,739,40787,102490,1,520,1,8794.22,NULL,'2023-11-07 10:41:19','2023-11-07 10:41:19',NULL),(3451,7492,739,40787,102490,1,359,2,2365.32,NULL,'2023-11-07 10:41:19','2023-11-07 10:41:19',NULL),(3452,7492,739,40787,102490,1,166,2,557973.30,NULL,'2023-11-07 10:41:19','2023-11-07 10:41:19',NULL),(3453,7492,740,40787,102491,1,63,1,453719.93,NULL,'2023-11-07 10:42:52','2023-11-07 10:42:52',NULL),(3454,7492,740,40787,102491,1,516,1,520.94,NULL,'2023-11-07 10:42:52','2023-11-07 10:42:52',NULL),(3455,7492,740,40787,102491,1,517,1,113268.80,NULL,'2023-11-07 10:42:52','2023-11-07 10:42:52',NULL),(3456,7492,740,40787,102491,1,64,1,19559.33,NULL,'2023-11-07 10:42:52','2023-11-07 10:42:52',NULL),(3457,7492,740,40787,102491,1,518,1,28832.68,NULL,'2023-11-07 10:42:52','2023-11-07 10:42:52',NULL),(3458,7492,740,40787,102491,1,519,1,2637.46,NULL,'2023-11-07 10:42:52','2023-11-07 10:42:52',NULL),(3459,7492,740,40787,102491,1,520,1,9663.61,NULL,'2023-11-07 10:42:52','2023-11-07 10:42:52',NULL),(3460,7492,740,40787,102491,1,359,2,2637.46,NULL,'2023-11-07 10:42:52','2023-11-07 10:42:52',NULL),(3461,7492,740,40787,102491,1,166,2,625565.29,NULL,'2023-11-07 10:42:52','2023-11-07 10:42:52',NULL),(3462,7492,741,40787,102492,1,63,1,607483.59,NULL,'2023-11-07 10:43:48','2023-11-07 10:43:48',NULL),(3463,7492,741,40787,102492,1,516,1,744.20,NULL,'2023-11-07 10:43:48','2023-11-07 10:43:48',NULL),(3464,7492,741,40787,102492,1,517,1,160684.05,NULL,'2023-11-07 10:43:48','2023-11-07 10:43:48',NULL);
INSERT INTO `balance_libro_details` VALUES (3465,7492,741,40787,102492,1,64,1,27131.34,NULL,'2023-11-07 10:43:48','2023-11-07 10:43:48',NULL),(3466,7492,741,40787,102492,1,518,1,36564.00,NULL,'2023-11-07 10:43:48','2023-11-07 10:43:48',NULL),(3467,7492,741,40787,102492,1,519,1,3779.78,NULL,'2023-11-07 10:43:48','2023-11-07 10:43:48',NULL),(3468,7492,741,40787,102492,1,520,1,11949.79,NULL,'2023-11-07 10:43:48','2023-11-07 10:43:48',NULL),(3469,7492,741,40787,102492,1,359,2,3779.78,NULL,'2023-11-07 10:43:48','2023-11-07 10:43:48',NULL),(3470,7492,741,40787,102492,1,166,2,844556.97,NULL,'2023-11-07 10:43:48','2023-11-07 10:43:48',NULL),(3471,7492,742,40787,102494,1,63,1,760002.55,NULL,'2023-11-07 10:44:50','2023-11-07 10:44:50',NULL),(3472,7492,742,40787,102494,1,516,1,706.99,NULL,'2023-11-07 10:44:50','2023-11-07 10:44:50',NULL),(3473,7492,742,40787,102494,1,517,1,227631.44,NULL,'2023-11-07 10:44:50','2023-11-07 10:44:50',NULL),(3474,7492,742,40787,102494,1,64,1,32842.25,NULL,'2023-11-07 10:44:50','2023-11-07 10:44:50',NULL),(3475,7492,742,40787,102494,1,518,1,36409.70,NULL,'2023-11-07 10:44:50','2023-11-07 10:44:50',NULL),(3476,7492,742,40787,102494,1,519,1,3427.47,NULL,'2023-11-07 10:44:50','2023-11-07 10:44:50',NULL),(3477,7492,742,40787,102494,1,520,1,10304.46,NULL,'2023-11-07 10:44:50','2023-11-07 10:44:50',NULL),(3478,7492,742,40787,102494,1,359,2,3427.47,NULL,'2023-11-07 10:44:50','2023-11-07 10:44:50',NULL),(3479,7492,742,40787,102494,1,166,2,1067897.39,NULL,'2023-11-07 10:44:50','2023-11-07 10:44:50',NULL),(3480,7492,743,40787,102495,1,63,1,571407.09,NULL,'2023-11-07 10:46:07','2023-11-07 10:46:07',NULL),(3481,7492,743,40787,102495,1,516,1,669.78,NULL,'2023-11-07 10:46:07','2023-11-07 10:46:07',NULL),(3482,7492,743,40787,102495,1,517,1,151098.92,NULL,'2023-11-07 10:46:07','2023-11-07 10:46:07',NULL),(3483,7492,743,40787,102495,1,64,1,5667.20,NULL,'2023-11-07 10:46:07','2023-11-07 10:46:07',NULL),(3484,7492,743,40787,102495,1,518,1,37070.64,NULL,'2023-11-07 10:46:07','2023-11-07 10:46:07',NULL),(3485,7492,743,40787,102495,1,519,1,3315.96,NULL,'2023-11-07 10:46:07','2023-11-07 10:46:07',NULL),(3486,7492,743,40787,102495,1,520,1,11055.96,NULL,'2023-11-07 10:46:07','2023-11-07 10:46:07',NULL),(3487,7492,743,40787,102495,1,359,2,3315.96,NULL,'2023-11-07 10:46:07','2023-11-07 10:46:07',NULL),(3488,7492,743,40787,102495,1,166,2,776969.59,NULL,'2023-11-07 10:46:07','2023-11-07 10:46:07',NULL),(3489,7492,744,40787,102496,1,63,1,567117.53,NULL,'2023-11-07 10:47:08','2023-11-07 10:47:08',NULL),(3490,7492,744,40787,102496,1,516,1,632.57,NULL,'2023-11-07 10:47:08','2023-11-07 10:47:08',NULL),(3491,7492,744,40787,102496,1,517,1,133297.81,NULL,'2023-11-07 10:47:08','2023-11-07 10:47:08',NULL),(3492,7492,744,40787,102496,1,64,1,10773.00,NULL,'2023-11-07 10:47:08','2023-11-07 10:47:08',NULL),(3493,7492,744,40787,102496,1,518,1,37444.88,NULL,'2023-11-07 10:47:08','2023-11-07 10:47:08',NULL),(3494,7492,744,40787,102496,1,519,1,2993.92,NULL,'2023-11-07 10:47:08','2023-11-07 10:47:08',NULL),(3495,7492,744,40787,102496,1,520,1,10303.93,NULL,'2023-11-07 10:47:08','2023-11-07 10:47:08',NULL),(3496,7492,744,40787,102496,1,359,2,2993.92,NULL,'2023-11-07 10:47:08','2023-11-07 10:47:08',NULL),(3497,7492,744,40787,102496,1,166,2,759569.72,NULL,'2023-11-07 10:47:08','2023-11-07 10:47:08',NULL),(3498,7492,745,40787,102497,1,63,1,355731.97,NULL,'2023-11-07 10:48:09','2023-11-07 10:48:09',NULL),(3499,7492,745,40787,102497,1,516,1,1410.48,NULL,'2023-11-07 10:48:09','2023-11-07 10:48:09',NULL),(3500,7492,745,40787,102497,1,517,1,166198.26,NULL,'2023-11-07 10:48:09','2023-11-07 10:48:09',NULL),(3501,7492,745,40787,102497,1,64,1,9949.20,NULL,'2023-11-07 10:48:09','2023-11-07 10:48:09',NULL),(3502,7492,745,40787,102497,1,518,1,40638.96,NULL,'2023-11-07 10:48:09','2023-11-07 10:48:09',NULL),(3503,7492,745,40787,102497,1,519,1,2872.64,NULL,'2023-11-07 10:48:09','2023-11-07 10:48:09',NULL),(3504,7492,745,40787,102497,1,520,1,2872.64,NULL,'2023-11-07 10:48:09','2023-11-07 10:48:09',NULL);
INSERT INTO `balance_libro_details` VALUES (3505,7492,745,40787,102497,1,359,2,2872.64,NULL,'2023-11-07 10:48:09','2023-11-07 10:48:09',NULL),(3506,7492,745,40787,102497,1,166,2,576801.51,NULL,'2023-11-07 10:48:09','2023-11-07 10:48:09',NULL),(3507,7492,746,40787,102498,1,63,1,424735.76,NULL,'2023-11-07 10:50:03','2023-11-07 10:50:03',NULL),(3508,7492,746,40787,102498,1,516,1,1332.12,NULL,'2023-11-07 10:50:03','2023-11-07 10:50:03',NULL),(3509,7492,746,40787,102498,1,517,1,203891.58,NULL,'2023-11-07 10:50:03','2023-11-07 10:50:03',NULL),(3510,7492,746,40787,102498,1,64,1,12364.40,NULL,'2023-11-07 10:50:03','2023-11-07 10:50:03',NULL),(3511,7492,746,40787,102498,1,518,1,42219.16,NULL,'2023-11-07 10:50:03','2023-11-07 10:50:03',NULL),(3512,7492,746,40787,102498,1,519,1,3709.70,NULL,'2023-11-07 10:50:03','2023-11-07 10:50:03',NULL),(3513,7492,746,40787,102498,1,520,1,3709.70,NULL,'2023-11-07 10:50:03','2023-11-07 10:50:03',NULL),(3514,7492,746,40787,102498,1,359,2,3709.70,NULL,'2023-11-07 10:50:03','2023-11-07 10:50:03',NULL),(3515,7492,746,40787,102498,1,166,2,688252.72,NULL,'2023-11-07 10:50:03','2023-11-07 10:50:03',NULL),(3516,7492,747,40787,102499,1,63,1,889333.26,NULL,'2023-11-07 10:51:22','2023-11-07 10:51:22',NULL),(3517,7492,747,40787,102499,1,516,1,1410.48,NULL,'2023-11-07 10:51:22','2023-11-07 10:51:22',NULL),(3518,7492,747,40787,102499,1,517,1,266023.72,NULL,'2023-11-07 10:51:22','2023-11-07 10:51:22',NULL),(3519,7492,747,40787,102499,1,64,1,14631.00,NULL,'2023-11-07 10:51:22','2023-11-07 10:51:22',NULL),(3520,7492,747,40787,102499,1,518,1,47953.80,NULL,'2023-11-07 10:51:22','2023-11-07 10:51:22',NULL),(3521,7492,747,40787,102499,1,519,1,4775.23,NULL,'2023-11-07 10:51:22','2023-11-07 10:51:22',NULL),(3522,7492,747,40787,102499,1,520,1,4775.23,NULL,'2023-11-07 10:51:22','2023-11-07 10:51:22',NULL),(3523,7492,747,40787,102499,1,359,2,4775.23,NULL,'2023-11-07 10:51:22','2023-11-07 10:51:22',NULL),(3524,7492,747,40787,102499,1,166,2,1224127.49,NULL,'2023-11-07 10:51:22','2023-11-07 10:51:22',NULL),(3525,7492,748,40787,102487,3,521,1,100770.00,NULL,'2023-11-07 11:15:04','2023-11-07 11:15:04',NULL),(3526,7492,748,40787,102487,3,57,1,361887.19,NULL,'2023-11-07 11:15:04','2023-11-07 11:15:04',NULL),(3527,7492,748,40787,102487,3,62,1,470722.23,NULL,'2023-11-07 11:15:04','2023-11-07 11:15:04',NULL),(3528,7492,748,40787,102487,3,359,1,930000.00,NULL,'2023-11-07 11:15:04','2023-11-07 11:15:04',NULL),(3529,7492,748,40787,102487,3,165,1,150000.00,NULL,'2023-11-07 11:15:04','2023-11-07 11:15:04',NULL),(3530,7492,748,40787,102487,3,166,2,2013379.42,NULL,'2023-11-07 11:15:04','2023-11-07 11:15:04',NULL),(3531,7492,749,40787,102487,3,505,1,5745.30,NULL,'2023-11-07 11:18:37','2023-11-07 11:18:37',NULL),(3532,7492,749,40787,102487,3,25,1,9007.74,NULL,'2023-11-07 11:18:37','2023-11-07 11:18:37',NULL),(3533,7492,749,40787,102487,3,23,1,2573.64,NULL,'2023-11-07 11:18:37','2023-11-07 11:18:37',NULL),(3534,7492,749,40787,102487,3,506,1,27194.50,NULL,'2023-11-07 11:18:37','2023-11-07 11:18:37',NULL),(3535,7492,749,40787,102487,3,166,2,44521.18,NULL,'2023-11-07 11:18:37','2023-11-07 11:18:37',NULL),(3536,7492,750,40787,102487,3,396,1,24018.21,NULL,'2023-11-07 11:20:03','2023-11-07 11:20:03',NULL),(3537,7492,750,40787,102487,3,485,1,361.75,NULL,'2023-11-07 11:20:03','2023-11-07 11:20:03',NULL),(3538,7492,750,40787,102487,3,499,1,7379.77,NULL,'2023-11-07 11:20:03','2023-11-07 11:20:03',NULL),(3539,7492,750,40787,102487,3,484,1,700.50,NULL,'2023-11-07 11:20:03','2023-11-07 11:20:03',NULL),(3540,7492,750,40787,102487,3,1037,1,17579.38,NULL,'2023-11-07 11:20:03','2023-11-07 11:20:03',NULL),(3541,7492,750,40787,102487,3,166,2,50039.61,NULL,'2023-11-07 11:20:03','2023-11-07 11:20:03',NULL),(3542,7492,751,40787,102488,3,62,1,468932.48,NULL,'2023-11-07 11:24:21','2023-11-07 11:24:21',NULL),(3543,7492,751,40787,102488,3,57,1,463801.69,NULL,'2023-11-07 11:24:21','2023-11-07 11:24:21',NULL),(3544,7492,751,40787,102488,3,166,2,932734.17,NULL,'2023-11-07 11:24:21','2023-11-07 11:24:21',NULL);
INSERT INTO `balance_libro_details` VALUES (3545,7492,752,40787,102488,3,506,1,27625.36,NULL,'2023-11-07 11:26:31','2023-11-07 11:26:31',NULL),(3546,7492,752,40787,102488,3,25,1,15495.85,NULL,'2023-11-07 11:26:31','2023-11-07 11:26:31',NULL),(3547,7492,752,40787,102488,3,23,1,4427.38,NULL,'2023-11-07 11:26:31','2023-11-07 11:26:31',NULL),(3548,7492,752,40787,102488,3,166,2,47548.59,NULL,'2023-11-07 11:26:31','2023-11-07 11:26:31',NULL),(3549,7492,753,40787,102488,3,1037,1,38728.70,NULL,'2023-11-07 11:27:46','2023-11-07 11:27:46',NULL),(3550,7492,753,40787,102488,3,485,1,260.25,NULL,'2023-11-07 11:27:46','2023-11-07 11:27:46',NULL),(3551,7492,753,40787,102488,3,166,2,38988.95,NULL,'2023-11-07 11:27:46','2023-11-07 11:27:46',NULL),(3552,7492,754,40787,102487,20,166,1,1922543.52,NULL,'2023-11-07 11:29:02','2023-11-07 11:29:02',NULL),(3553,7492,754,40787,102487,20,13,2,1922543.52,NULL,'2023-11-07 11:29:02','2023-11-07 11:29:02',NULL),(3554,7492,755,40787,102488,20,166,1,3904693.28,NULL,'2023-11-07 11:30:26','2023-11-07 11:30:26',NULL),(3555,7492,755,40787,102488,20,13,2,3904693.28,NULL,'2023-11-07 11:30:26','2023-11-07 11:30:26',NULL),(3556,7492,756,40787,102489,20,166,1,10927074.94,NULL,'2023-11-07 11:31:35','2023-11-07 11:31:35',NULL),(3557,7492,756,40787,102489,20,13,2,10927074.94,NULL,'2023-11-07 11:31:35','2023-11-07 11:31:35',NULL),(3558,7492,757,40787,102489,3,165,1,140000.00,NULL,'2023-11-07 11:32:24','2023-11-08 08:06:32','2023-11-08 08:06:32'),(3559,7492,757,40787,102489,3,359,1,1806000.00,NULL,'2023-11-07 11:32:24','2023-11-08 08:06:32','2023-11-08 08:06:32'),(3560,7492,757,40787,102489,3,62,1,590986.36,NULL,'2023-11-07 11:32:24','2023-11-08 08:06:32','2023-11-08 08:06:32'),(3561,7492,757,40787,102489,3,157,1,86110.30,NULL,'2023-11-07 11:32:24','2023-11-08 08:06:32','2023-11-08 08:06:32'),(3562,7492,757,40787,102489,3,57,1,1899303.86,NULL,'2023-11-07 11:32:24','2023-11-08 08:06:32','2023-11-08 08:06:32'),(3563,7492,757,40787,102489,3,467,1,160071.00,NULL,'2023-11-07 11:32:24','2023-11-08 08:06:32','2023-11-08 08:06:32'),(3564,7492,757,40787,102489,3,23,1,6204.42,NULL,'2023-11-07 11:32:24','2023-11-08 08:06:32','2023-11-08 08:06:32'),(3565,7492,757,40787,102489,3,25,1,36956.56,NULL,'2023-11-07 11:32:24','2023-11-08 08:06:32','2023-11-08 08:06:32'),(3566,7492,757,40787,102489,3,74,1,1793189.08,NULL,'2023-11-07 11:32:24','2023-11-08 08:06:32','2023-11-08 08:06:32'),(3567,7492,757,40787,102489,3,485,1,516.15,NULL,'2023-11-07 11:32:24','2023-11-08 08:06:32','2023-11-08 08:06:32'),(3568,7492,757,40787,102489,3,484,1,720.00,NULL,'2023-11-07 11:32:24','2023-11-08 08:06:32','2023-11-08 08:06:32'),(3569,7492,757,40787,102489,3,166,2,6520057.73,NULL,'2023-11-07 11:32:24','2023-11-08 08:06:32','2023-11-08 08:06:32'),(3570,7492,758,40787,102490,20,166,1,6413486.31,NULL,'2023-11-07 11:32:51','2023-11-07 11:32:51',NULL),(3571,7492,758,40787,102490,20,13,2,6413486.31,NULL,'2023-11-07 11:32:51','2023-11-07 11:32:51',NULL),(3572,7492,759,40787,102491,20,166,1,16154783.44,NULL,'2023-11-07 11:34:00','2023-11-07 11:34:00',NULL),(3573,7492,759,40787,102491,20,13,2,16154783.44,NULL,'2023-11-07 11:34:00','2023-11-07 11:34:00',NULL),(3574,7492,760,40787,102492,20,166,1,12731467.70,NULL,'2023-11-07 11:34:56','2023-11-07 11:34:56',NULL),(3575,7492,760,40787,102492,20,13,2,12731467.70,NULL,'2023-11-07 11:34:56','2023-11-07 11:34:56',NULL),(3576,7492,761,40787,102494,20,166,1,13767864.28,NULL,'2023-11-07 11:36:03','2023-11-07 11:36:03',NULL),(3577,7492,761,40787,102494,20,13,2,13767864.28,NULL,'2023-11-07 11:36:03','2023-11-07 11:36:03',NULL),(3578,7492,762,40787,102495,20,166,1,4019952.60,NULL,'2023-11-07 11:37:11','2023-11-07 11:37:11',NULL),(3579,7492,762,40787,102495,20,13,2,4019952.60,NULL,'2023-11-07 11:37:11','2023-11-07 11:37:11',NULL),(3580,7492,763,40787,102496,20,166,1,23436611.92,NULL,'2023-11-07 11:38:18','2023-11-07 11:38:18',NULL),(3581,7492,763,40787,102496,20,13,2,23436611.92,NULL,'2023-11-07 11:38:18','2023-11-07 11:38:18',NULL);
INSERT INTO `balance_libro_details` VALUES (3582,7492,764,40787,102497,20,166,1,25019501.20,NULL,'2023-11-07 11:39:13','2023-11-07 11:39:13',NULL),(3583,7492,764,40787,102497,20,13,2,25019501.20,NULL,'2023-11-07 11:39:13','2023-11-07 11:39:13',NULL),(3584,7492,765,40787,102498,20,166,1,21385950.97,NULL,'2023-11-07 11:40:13','2023-11-08 08:37:54','2023-11-08 08:37:54'),(3585,7492,765,40787,102498,20,364,2,21385950.97,NULL,'2023-11-07 11:40:13','2023-11-08 08:37:54','2023-11-08 08:37:54'),(3586,7492,766,40787,102499,20,166,1,17443107.34,NULL,'2023-11-07 11:42:21','2023-11-07 11:42:21',NULL),(3587,7492,766,40787,102499,20,13,2,17443107.34,NULL,'2023-11-07 11:42:21','2023-11-07 11:42:21',NULL),(3588,7492,767,40787,102490,3,521,1,159513.00,NULL,'2023-11-07 11:43:26','2023-11-07 11:43:26',NULL),(3589,7492,767,40787,102490,3,57,1,3211497.01,NULL,'2023-11-07 11:43:26','2023-11-07 11:43:26',NULL),(3590,7492,767,40787,102490,3,165,1,230000.00,NULL,'2023-11-07 11:43:26','2023-11-07 11:43:26',NULL),(3591,7492,767,40787,102490,3,62,1,412961.00,NULL,'2023-11-07 11:43:26','2023-11-07 11:43:26',NULL),(3592,7492,767,40787,102490,3,359,1,3250000.00,NULL,'2023-11-07 11:43:26','2023-11-07 11:43:26',NULL),(3593,7492,767,40787,102490,3,74,1,821847.22,NULL,'2023-11-07 11:43:26','2023-11-07 11:43:26',NULL),(3594,7492,767,40787,102490,3,506,1,28487.10,NULL,'2023-11-07 11:43:26','2023-11-07 11:43:26',NULL),(3595,7492,767,40787,102490,3,81,1,8136.72,NULL,'2023-11-07 11:43:26','2023-11-07 11:43:26',NULL),(3596,7492,767,40787,102490,3,485,1,570.00,NULL,'2023-11-07 11:43:26','2023-11-07 11:43:26',NULL),(3597,7492,767,40787,102490,3,396,1,51374.30,NULL,'2023-11-07 11:43:26','2023-11-07 11:43:26',NULL),(3598,7492,767,40787,102490,3,484,1,1998.74,NULL,'2023-11-07 11:43:26','2023-11-07 11:43:26',NULL),(3599,7492,767,40787,102490,3,1037,1,87600.92,NULL,'2023-11-07 11:43:26','2023-11-07 11:43:26',NULL),(3600,7492,767,40787,102490,3,499,1,16319.76,NULL,'2023-11-07 11:43:26','2023-11-07 11:43:26',NULL),(3601,7492,767,40787,102490,3,166,2,8280305.77,NULL,'2023-11-07 11:43:26','2023-11-07 11:43:26',NULL),(3602,7492,768,40787,102491,3,521,1,35626.00,NULL,'2023-11-08 06:23:04','2023-11-08 06:23:04',NULL),(3603,7492,768,40787,102491,3,57,1,4297377.14,NULL,'2023-11-08 06:23:04','2023-11-08 06:23:04',NULL),(3604,7492,768,40787,102491,3,165,1,400000.00,NULL,'2023-11-08 06:23:04','2023-11-08 06:23:04',NULL),(3605,7492,768,40787,102491,3,62,1,594466.00,NULL,'2023-11-08 06:23:04','2023-11-08 06:23:04',NULL),(3606,7492,768,40787,102491,3,359,1,6330000.00,NULL,'2023-11-08 06:23:04','2023-11-08 06:23:04',NULL),(3607,7492,768,40787,102491,3,74,1,1241298.43,NULL,'2023-11-08 06:23:04','2023-11-08 06:23:04',NULL),(3608,7492,768,40787,102491,3,506,1,28917.37,NULL,'2023-11-08 06:23:04','2023-11-08 06:23:04',NULL),(3609,7492,768,40787,102491,3,23,1,2678.73,NULL,'2023-11-08 06:23:04','2023-11-08 06:23:04',NULL),(3610,7492,768,40787,102491,3,25,1,9375.55,NULL,'2023-11-08 06:23:04','2023-11-08 06:23:04',NULL),(3611,7492,768,40787,102491,3,485,1,1606.50,NULL,'2023-11-08 06:23:04','2023-11-08 06:23:04',NULL),(3612,7492,768,40787,102491,3,396,1,135573.63,NULL,'2023-11-08 06:23:04','2023-11-08 06:23:04',NULL),(3613,7492,768,40787,102491,3,1037,1,176663.29,NULL,'2023-11-08 06:23:04','2023-11-08 06:23:04',NULL),(3614,7492,768,40787,102491,3,499,1,51384.97,NULL,'2023-11-08 06:23:04','2023-11-08 06:23:04',NULL),(3615,7492,768,40787,102491,3,484,1,3213.00,NULL,'2023-11-08 06:23:04','2023-11-08 06:23:04',NULL),(3616,7492,768,40787,102491,3,166,2,13308180.61,NULL,'2023-11-08 06:23:04','2023-11-08 06:23:04',NULL),(3617,7492,769,40787,102492,3,521,1,51360.00,NULL,'2023-11-08 06:28:57','2023-11-08 08:06:10','2023-11-08 08:06:10'),(3618,7492,769,40787,102492,3,128,1,93694.81,NULL,'2023-11-08 06:28:57','2023-11-08 08:06:10','2023-11-08 08:06:10'),(3619,7492,769,40787,102492,3,57,1,2425005.80,NULL,'2023-11-08 06:28:57','2023-11-08 08:06:10','2023-11-08 08:06:10');
INSERT INTO `balance_libro_details` VALUES (3620,7492,769,40787,102492,3,165,1,200000.00,NULL,'2023-11-08 06:28:57','2023-11-08 08:06:10','2023-11-08 08:06:10'),(3621,7492,769,40787,102492,3,359,1,7600000.00,NULL,'2023-11-08 06:28:57','2023-11-08 08:06:10','2023-11-08 08:06:10'),(3622,7492,769,40787,102492,3,74,1,1000000.00,NULL,'2023-11-08 06:28:57','2023-11-08 08:06:10','2023-11-08 08:06:10'),(3623,7492,769,40787,102492,3,506,1,29403.54,NULL,'2023-11-08 06:28:57','2023-11-08 08:06:10','2023-11-08 08:06:10'),(3624,7492,769,40787,102492,3,25,1,9427.95,NULL,'2023-11-08 06:28:57','2023-11-08 08:06:10','2023-11-08 08:06:10'),(3625,7492,769,40787,102492,3,23,1,2693.70,NULL,'2023-11-08 06:28:57','2023-11-08 08:06:10','2023-11-08 08:06:10'),(3626,7492,769,40787,102492,3,485,1,1687.50,NULL,'2023-11-08 06:28:57','2023-11-08 08:06:10','2023-11-08 08:06:10'),(3627,7492,769,40787,102492,3,396,1,139213.00,NULL,'2023-11-08 06:28:57','2023-11-08 08:06:10','2023-11-08 08:06:10'),(3628,7492,769,40787,102492,3,157,1,156261.05,NULL,'2023-11-08 06:28:57','2023-11-08 08:06:10','2023-11-08 08:06:10'),(3629,7492,769,40787,102492,3,499,1,38194.36,NULL,'2023-11-08 06:28:57','2023-11-08 08:06:10','2023-11-08 08:06:10'),(3630,7492,769,40787,102492,3,484,1,3375.00,NULL,'2023-11-08 06:28:57','2023-11-08 08:06:10','2023-11-08 08:06:10'),(3631,7492,769,40787,102492,3,166,2,11750316.71,NULL,'2023-11-08 06:28:57','2023-11-08 08:06:10','2023-11-08 08:06:10'),(3632,7492,770,40787,102487,3,506,1,7712.37,NULL,'2023-11-08 06:31:57','2023-11-08 06:31:57',NULL),(3633,7492,770,40787,102487,3,1029,1,6367.22,NULL,'2023-11-08 06:31:57','2023-11-08 06:31:57',NULL),(3634,7492,770,40787,102487,3,212,1,38790.00,NULL,'2023-11-08 06:31:57','2023-11-08 06:31:57',NULL),(3635,7492,770,40787,102487,3,165,2,54222.09,NULL,'2023-11-08 06:31:57','2023-11-08 06:31:57',NULL),(3636,7492,770,40787,102487,3,1037,1,1226.50,NULL,'2023-11-08 06:31:57','2023-11-08 06:31:57',NULL),(3637,7492,770,40787,102487,3,485,1,42.00,NULL,'2023-11-08 06:31:57','2023-11-08 06:31:57',NULL),(3638,7492,770,40787,102487,3,484,1,84.00,NULL,'2023-11-08 06:31:57','2023-11-08 06:31:57',NULL),(3639,7492,771,40787,102488,3,165,2,102765.27,NULL,'2023-11-08 06:34:04','2023-11-08 06:34:04',NULL),(3640,7492,771,40787,102488,3,1029,1,6367.22,NULL,'2023-11-08 06:34:04','2023-11-08 06:34:04',NULL),(3641,7492,771,40787,102488,3,506,1,7903.85,NULL,'2023-11-08 06:34:04','2023-11-08 06:34:04',NULL),(3642,7492,771,40787,102488,3,212,1,19790.00,NULL,'2023-11-08 06:34:04','2023-11-08 06:34:04',NULL),(3643,7492,771,40787,102488,3,485,1,67770.00,NULL,'2023-11-08 06:34:04','2023-11-08 06:34:04',NULL),(3644,7492,771,40787,102488,3,484,1,84.00,NULL,'2023-11-08 06:34:04','2023-11-08 06:34:04',NULL),(3645,7492,771,40787,102488,3,1037,1,850.20,NULL,'2023-11-08 06:34:04','2023-11-08 06:34:04',NULL),(3646,7492,772,40787,102489,3,165,2,38616.05,NULL,'2023-11-08 06:36:30','2023-11-08 06:36:30',NULL),(3647,7492,772,40787,102489,3,506,1,8095.35,NULL,'2023-11-08 06:36:30','2023-11-08 06:36:30',NULL),(3648,7492,772,40787,102489,3,1029,1,6367.22,NULL,'2023-11-08 06:36:30','2023-11-08 06:36:30',NULL),(3649,7492,772,40787,102489,3,1037,1,951.37,NULL,'2023-11-08 06:36:30','2023-11-08 06:36:30',NULL),(3650,7492,772,40787,102489,3,485,1,42.00,NULL,'2023-11-08 06:36:30','2023-11-08 06:36:30',NULL),(3651,7492,772,40787,102489,3,484,1,84.00,NULL,'2023-11-08 06:36:30','2023-11-08 06:36:30',NULL),(3652,7492,772,40787,102489,3,212,1,23076.11,NULL,'2023-11-08 06:36:30','2023-11-08 06:36:30',NULL),(3653,7492,773,40787,102490,3,506,1,8286.83,NULL,'2023-11-08 06:38:23','2023-11-08 06:38:23',NULL),(3654,7492,773,40787,102490,3,1029,1,6367.22,NULL,'2023-11-08 06:38:23','2023-11-08 06:38:23',NULL),(3655,7492,773,40787,102490,3,135,1,44399.85,NULL,'2023-11-08 06:38:23','2023-11-08 06:38:23',NULL),(3656,7492,773,40787,102490,3,1037,1,1219.85,NULL,'2023-11-08 06:38:23','2023-11-08 06:38:23',NULL),(3657,7492,773,40787,102490,3,484,1,84.00,NULL,'2023-11-08 06:38:23','2023-11-08 06:38:23',NULL);
INSERT INTO `balance_libro_details` VALUES (3658,7492,773,40787,102490,3,485,1,4200.00,NULL,'2023-11-08 06:38:23','2023-11-08 06:38:23',NULL),(3659,7492,773,40787,102490,3,165,2,64557.75,NULL,'2023-11-08 06:38:23','2023-11-08 06:38:23',NULL),(3660,7492,774,40787,102491,3,506,1,8478.32,NULL,'2023-11-08 06:40:13','2023-11-08 06:40:13',NULL),(3661,7492,774,40787,102491,3,1029,1,6367.22,NULL,'2023-11-08 06:40:13','2023-11-08 06:40:13',NULL),(3662,7492,774,40787,102491,3,135,1,29650.00,NULL,'2023-11-08 06:40:13','2023-11-08 06:40:13',NULL),(3663,7492,774,40787,102491,3,485,1,42.00,NULL,'2023-11-08 06:40:13','2023-11-08 06:40:13',NULL),(3664,7492,774,40787,102491,3,484,1,84.00,NULL,'2023-11-08 06:40:13','2023-11-08 06:40:13',NULL),(3665,7492,774,40787,102491,3,1037,1,2634.69,NULL,'2023-11-08 06:40:13','2023-11-08 06:40:13',NULL),(3666,7492,774,40787,102491,3,165,2,47256.23,NULL,'2023-11-08 06:40:13','2023-11-08 06:40:13',NULL),(3667,7492,775,40787,102492,3,165,2,75567.83,NULL,'2023-11-08 06:42:07','2023-11-08 06:42:07',NULL),(3668,7492,775,40787,102492,3,506,1,8761.58,NULL,'2023-11-08 06:42:07','2023-11-08 06:42:07',NULL),(3669,7492,775,40787,102492,3,1029,1,6367.22,NULL,'2023-11-08 06:42:07','2023-11-08 06:42:07',NULL),(3670,7492,775,40787,102492,3,485,1,67.50,NULL,'2023-11-08 06:42:07','2023-11-08 06:42:07',NULL),(3671,7492,775,40787,102492,3,484,1,135.00,NULL,'2023-11-08 06:42:07','2023-11-08 06:42:07',NULL),(3672,7492,775,40787,102492,3,1037,1,6370.78,NULL,'2023-11-08 06:42:07','2023-11-08 06:42:07',NULL),(3673,7492,775,40787,102492,3,135,1,52465.00,NULL,'2023-11-08 06:42:07','2023-11-08 06:42:07',NULL),(3674,7492,775,40787,102492,3,499,1,1400.75,NULL,'2023-11-08 06:42:07','2023-11-08 06:42:07',NULL),(3675,7492,776,40787,102494,3,521,1,40320.00,NULL,'2023-11-08 06:46:26','2023-11-09 06:08:06','2023-11-09 06:08:06'),(3676,7492,776,40787,102494,3,165,1,500000.00,NULL,'2023-11-08 06:46:26','2023-11-09 06:08:06','2023-11-09 06:08:06'),(3677,7492,776,40787,102494,3,193,1,100000.00,NULL,'2023-11-08 06:46:26','2023-11-09 06:08:06','2023-11-09 06:08:06'),(3678,7492,776,40787,102494,3,359,1,2400000.00,NULL,'2023-11-08 06:46:26','2023-11-09 06:08:06','2023-11-09 06:08:06'),(3679,7492,776,40787,102494,3,74,1,1729723.68,NULL,'2023-11-08 06:46:26','2023-11-09 06:08:06','2023-11-09 06:08:06'),(3680,7492,776,40787,102494,3,467,1,15760.00,NULL,'2023-11-08 06:46:26','2023-11-09 06:08:06','2023-11-09 06:08:06'),(3681,7492,776,40787,102494,3,327,1,214217.64,NULL,'2023-11-08 06:46:26','2023-11-09 06:08:06','2023-11-09 06:08:06'),(3682,7492,776,40787,102494,3,506,1,29884.13,NULL,'2023-11-08 06:46:26','2023-11-09 06:08:06','2023-11-09 06:08:06'),(3683,7492,776,40787,102494,3,485,1,726.30,NULL,'2023-11-08 06:46:26','2023-11-09 06:08:06','2023-11-09 06:08:06'),(3684,7492,776,40787,102494,3,499,1,41303.56,NULL,'2023-11-08 06:46:26','2023-11-09 06:08:06','2023-11-09 06:08:06'),(3685,7492,776,40787,102494,3,484,1,1296.00,NULL,'2023-11-08 06:46:26','2023-11-09 06:08:06','2023-11-09 06:08:06'),(3686,7492,776,40787,102494,3,1037,1,140846.43,NULL,'2023-11-08 06:46:27','2023-11-09 06:08:06','2023-11-09 06:08:06'),(3687,7492,776,40787,102494,3,166,2,5214077.74,NULL,'2023-11-08 06:46:27','2023-11-09 06:08:06','2023-11-09 06:08:06'),(3688,7492,777,40787,102495,3,135,1,2200.25,NULL,'2023-11-08 06:49:34','2023-11-08 06:49:34',NULL),(3689,7492,777,40787,102495,3,165,1,400000.00,NULL,'2023-11-08 06:49:34','2023-11-08 06:49:34',NULL),(3690,7492,777,40787,102495,3,521,1,50408.03,NULL,'2023-11-08 06:49:34','2023-11-08 06:49:34',NULL),(3691,7492,777,40787,102495,3,359,1,3600000.00,NULL,'2023-11-08 06:49:34','2023-11-08 06:49:34',NULL),(3692,7492,777,40787,102495,3,74,1,455510.86,NULL,'2023-11-08 06:49:34','2023-11-08 06:49:34',NULL),(3693,7492,777,40787,102495,3,327,1,51238.38,NULL,'2023-11-08 06:49:34','2023-11-08 06:49:34',NULL),(3694,7492,777,40787,102495,3,506,1,30513.72,NULL,'2023-11-08 06:49:34','2023-11-08 06:49:34',NULL);
INSERT INTO `balance_libro_details` VALUES (3695,7492,777,40787,102495,3,485,1,853.50,NULL,'2023-11-08 06:49:34','2023-11-08 06:49:34',NULL),(3696,7492,777,40787,102495,3,499,1,11849.83,NULL,'2023-11-08 06:49:34','2023-11-08 06:49:34',NULL),(3697,7492,777,40787,102495,3,484,1,1707.00,NULL,'2023-11-08 06:49:34','2023-11-08 06:49:34',NULL),(3698,7492,777,40787,102495,3,1037,1,69962.42,NULL,'2023-11-08 06:49:34','2023-11-08 06:49:34',NULL),(3699,7492,777,40787,102495,3,166,2,4674243.99,NULL,'2023-11-08 06:49:34','2023-11-08 06:49:34',NULL),(3700,7492,778,40787,102496,3,521,1,48892.03,NULL,'2023-11-08 06:52:18','2023-11-08 06:52:18',NULL),(3701,7492,778,40787,102496,3,165,1,800000.00,NULL,'2023-11-08 06:52:18','2023-11-08 06:52:18',NULL),(3702,7492,778,40787,102496,3,359,1,9700000.00,NULL,'2023-11-08 06:52:18','2023-11-08 06:52:18',NULL),(3703,7492,778,40787,102496,3,74,1,2123244.57,NULL,'2023-11-08 06:52:18','2023-11-08 06:52:18',NULL),(3704,7492,778,40787,102496,3,327,1,126087.14,NULL,'2023-11-08 06:52:18','2023-11-08 06:52:18',NULL),(3705,7492,778,40787,102496,3,506,1,31138.33,NULL,'2023-11-08 06:52:18','2023-11-08 06:52:18',NULL),(3706,7492,778,40787,102496,3,515,1,24590.03,NULL,'2023-11-08 06:52:18','2023-11-08 06:52:18',NULL),(3707,7492,778,40787,102496,3,485,1,1366.50,NULL,'2023-11-08 06:52:18','2023-11-08 06:52:18',NULL),(3708,7492,778,40787,102496,3,499,1,70309.79,NULL,'2023-11-08 06:52:18','2023-11-08 06:52:18',NULL),(3709,7492,778,40787,102496,3,484,1,2733.00,NULL,'2023-11-08 06:52:18','2023-11-08 06:52:18',NULL),(3710,7492,778,40787,102496,3,1037,1,243153.85,NULL,'2023-11-08 06:52:18','2023-11-08 06:52:18',NULL),(3711,7492,778,40787,102496,3,166,2,13171515.24,NULL,'2023-11-08 06:52:18','2023-11-08 06:52:18',NULL),(3712,7492,779,40787,102497,3,135,1,26128.93,NULL,'2023-11-08 06:54:55','2023-11-08 06:54:55',NULL),(3713,7492,779,40787,102497,3,521,1,84341.03,NULL,'2023-11-08 06:54:55','2023-11-08 06:54:55',NULL),(3714,7492,779,40787,102497,3,359,1,10100000.00,NULL,'2023-11-08 06:54:55','2023-11-08 06:54:55',NULL),(3715,7492,779,40787,102497,3,74,1,462377.27,NULL,'2023-11-08 06:54:55','2023-11-08 06:54:55',NULL),(3716,7492,779,40787,102497,3,327,1,326285.57,NULL,'2023-11-08 06:54:55','2023-11-08 06:54:55',NULL),(3717,7492,779,40787,102497,3,506,1,34562.05,NULL,'2023-11-08 06:54:55','2023-11-08 06:54:55',NULL),(3718,7492,779,40787,102497,3,485,1,1474.50,NULL,'2023-11-08 06:54:55','2023-11-08 06:54:55',NULL),(3719,7492,779,40787,102497,3,499,1,75058.48,NULL,'2023-11-08 06:54:55','2023-11-08 06:54:55',NULL),(3720,7492,779,40787,102497,3,484,1,2949.00,NULL,'2023-11-08 06:54:55','2023-11-08 06:54:55',NULL),(3721,7492,779,40787,102497,3,1037,1,268505.04,NULL,'2023-11-08 06:54:55','2023-11-08 06:54:55',NULL),(3722,7492,779,40787,102497,3,166,2,11381681.87,NULL,'2023-11-08 06:54:55','2023-11-08 06:54:55',NULL),(3723,7492,780,40787,102498,3,386,1,3000000.00,NULL,'2023-11-08 06:58:52','2023-11-08 06:58:52',NULL),(3724,7492,780,40787,102498,3,359,1,13200000.00,NULL,'2023-11-08 06:58:52','2023-11-08 06:58:52',NULL),(3725,7492,780,40787,102498,3,74,1,856351.00,NULL,'2023-11-08 06:58:52','2023-11-08 06:58:52',NULL),(3726,7492,780,40787,102498,3,327,1,859780.05,NULL,'2023-11-08 06:58:52','2023-11-08 06:58:52',NULL),(3727,7492,780,40787,102498,3,506,1,35996.66,NULL,'2023-11-08 06:58:52','2023-11-08 06:58:52',NULL),(3728,7492,780,40787,102498,3,505,1,21723.78,NULL,'2023-11-08 06:58:52','2023-11-08 06:58:52',NULL),(3729,7492,780,40787,102498,3,485,1,4521.00,NULL,'2023-11-08 06:58:52','2023-11-08 06:58:52',NULL),(3730,7492,780,40787,102498,3,499,1,62563.13,NULL,'2023-11-08 06:58:52','2023-11-08 06:58:52',NULL),(3731,7492,780,40787,102498,3,484,1,9042.00,NULL,'2023-11-08 06:58:52','2023-11-08 06:58:52',NULL),(3732,7492,780,40787,102498,3,1037,1,278123.46,NULL,'2023-11-08 06:58:52','2023-11-08 06:58:52',NULL),(3733,7492,780,40787,102498,3,166,2,18376092.11,NULL,'2023-11-08 06:58:52','2023-11-08 06:58:52',NULL);
INSERT INTO `balance_libro_details` VALUES (3734,7492,780,40787,102498,3,521,1,47991.03,NULL,'2023-11-08 06:58:52','2023-11-08 06:58:52',NULL),(3735,7492,781,40787,102499,3,135,1,4792.85,NULL,'2023-11-08 07:01:52','2023-11-08 07:01:52',NULL),(3736,7492,781,40787,102499,3,521,1,62174.03,NULL,'2023-11-08 07:01:52','2023-11-08 07:01:52',NULL),(3737,7492,781,40787,102499,3,165,1,250000.00,NULL,'2023-11-08 07:01:52','2023-11-08 07:01:52',NULL),(3738,7492,781,40787,102499,3,359,1,6500000.00,NULL,'2023-11-08 07:01:52','2023-11-08 07:01:52',NULL),(3739,7492,781,40787,102499,3,74,1,3601623.59,NULL,'2023-11-08 07:01:52','2023-11-08 07:01:52',NULL),(3740,7492,781,40787,102499,3,327,1,115841.99,NULL,'2023-11-08 07:01:52','2023-11-08 07:01:52',NULL),(3741,7492,781,40787,102499,3,506,1,36489.58,NULL,'2023-11-08 07:01:52','2023-11-08 07:01:52',NULL),(3742,7492,781,40787,102499,3,485,1,1678.50,NULL,'2023-11-08 07:01:52','2023-11-08 07:01:52',NULL),(3743,7492,781,40787,102499,3,499,1,38310.52,NULL,'2023-11-08 07:01:52','2023-11-08 07:01:52',NULL),(3744,7492,781,40787,102499,3,484,1,3753.00,NULL,'2023-11-08 07:01:52','2023-11-08 07:01:52',NULL),(3745,7492,781,40787,102499,3,1037,1,174464.62,NULL,'2023-11-08 07:01:52','2023-11-08 07:01:52',NULL),(3746,7492,781,40787,102499,3,166,2,10789128.68,NULL,'2023-11-08 07:01:52','2023-11-08 07:01:52',NULL),(3747,7492,782,40787,102494,3,506,1,9167.17,NULL,'2023-11-08 07:04:26','2023-11-08 07:04:26',NULL),(3748,7492,782,40787,102494,3,1031,1,105440.00,NULL,'2023-11-08 07:04:26','2023-11-08 07:04:26',NULL),(3749,7492,782,40787,102494,3,1029,1,6405.42,NULL,'2023-11-08 07:04:26','2023-11-08 07:04:26',NULL),(3750,7492,782,40787,102494,3,212,1,108402.15,NULL,'2023-11-08 07:04:26','2023-11-08 07:04:26',NULL),(3751,7492,782,40787,102494,3,485,1,67.50,NULL,'2023-11-08 07:04:26','2023-11-08 07:04:26',NULL),(3752,7492,782,40787,102494,3,1037,1,3245.85,NULL,'2023-11-08 07:04:26','2023-11-08 07:04:26',NULL),(3753,7492,782,40787,102494,3,499,1,6.48,NULL,'2023-11-08 07:04:26','2023-11-08 07:04:26',NULL),(3754,7492,782,40787,102494,3,484,1,135.00,NULL,'2023-11-08 07:04:26','2023-11-08 07:04:26',NULL),(3755,7492,782,40787,102494,3,165,2,232869.57,NULL,'2023-11-08 07:04:26','2023-11-08 07:04:26',NULL),(3756,7492,783,40787,102495,3,506,1,9328.11,NULL,'2023-11-08 07:06:23','2023-11-08 07:06:23',NULL),(3757,7492,783,40787,102495,3,1029,1,6367.22,NULL,'2023-11-08 07:06:23','2023-11-08 07:06:23',NULL),(3758,7492,783,40787,102495,3,212,1,7532.60,NULL,'2023-11-08 07:06:23','2023-11-08 07:06:23',NULL),(3759,7492,783,40787,102495,3,485,1,67.50,NULL,'2023-11-08 07:06:23','2023-11-08 07:06:23',NULL),(3760,7492,783,40787,102495,3,1037,1,6701.93,NULL,'2023-11-08 07:06:23','2023-11-08 07:06:23',NULL),(3761,7492,783,40787,102495,3,499,1,1242.05,NULL,'2023-11-08 07:06:23','2023-11-08 07:06:23',NULL),(3762,7492,783,40787,102495,3,484,1,135.00,NULL,'2023-11-08 07:06:23','2023-11-08 07:06:23',NULL),(3763,7492,783,40787,102495,3,165,2,31374.41,NULL,'2023-11-08 07:06:23','2023-11-08 07:06:23',NULL),(3764,7492,784,40787,102496,3,1029,1,6367.22,NULL,'2023-11-08 07:08:39','2023-11-08 07:08:39',NULL),(3765,7492,784,40787,102496,3,499,1,10900.94,NULL,'2023-11-08 07:08:39','2023-11-08 07:08:39',NULL),(3766,7492,784,40787,102496,3,212,1,141223.20,NULL,'2023-11-08 07:08:39','2023-11-08 07:08:39',NULL),(3767,7492,784,40787,102496,3,1037,1,27386.98,NULL,'2023-11-08 07:08:39','2023-11-08 07:08:39',NULL),(3768,7492,784,40787,102496,3,165,2,195558.56,NULL,'2023-11-08 07:08:39','2023-11-08 07:08:39',NULL),(3769,7492,784,40787,102496,3,506,1,9611.37,NULL,'2023-11-08 07:08:39','2023-11-08 07:08:39',NULL),(3770,7492,784,40787,102496,3,485,1,67.50,NULL,'2023-11-08 07:08:39','2023-11-08 07:08:39',NULL),(3771,7492,784,40787,102496,3,484,1,1.35,NULL,'2023-11-08 07:08:39','2023-11-08 07:08:39',NULL),(3772,7492,785,40787,102497,3,506,1,9894.63,NULL,'2023-11-08 07:10:54','2023-11-08 07:10:54',NULL),(3773,7492,785,40787,102497,3,1029,1,6367.22,NULL,'2023-11-08 07:10:54','2023-11-08 07:10:54',NULL);
INSERT INTO `balance_libro_details` VALUES (3774,7492,785,40787,102497,3,1037,1,3813.83,NULL,'2023-11-08 07:10:54','2023-11-08 07:10:54',NULL),(3775,7492,785,40787,102497,3,484,1,135.00,NULL,'2023-11-08 07:10:54','2023-11-08 07:10:54',NULL),(3776,7492,785,40787,102497,3,499,1,108.00,NULL,'2023-11-08 07:10:54','2023-11-08 07:10:54',NULL),(3777,7492,785,40787,102497,3,212,1,23700.00,NULL,'2023-11-08 07:10:54','2023-11-08 07:10:54',NULL),(3778,7492,785,40787,102497,3,128,1,190448.88,NULL,'2023-11-08 07:10:54','2023-11-08 07:10:54',NULL),(3779,7492,785,40787,102497,3,1031,1,71800.00,NULL,'2023-11-08 07:10:54','2023-11-08 07:10:54',NULL),(3780,7492,785,40787,102497,3,485,1,67.50,NULL,'2023-11-08 07:10:54','2023-11-08 07:10:54',NULL),(3781,7492,785,40787,102497,3,165,2,306335.06,NULL,'2023-11-08 07:10:54','2023-11-08 07:10:54',NULL),(3782,7492,786,40787,102498,3,506,1,10177.89,NULL,'2023-11-08 07:13:11','2023-11-08 07:13:11',NULL),(3783,7492,786,40787,102498,3,1029,1,6367.22,NULL,'2023-11-08 07:13:11','2023-11-08 07:13:11',NULL),(3784,7492,786,40787,102498,3,386,1,2500000.00,NULL,'2023-11-08 07:13:11','2023-11-08 07:13:11',NULL),(3785,7492,786,40787,102498,3,212,1,43402.78,NULL,'2023-11-08 07:13:11','2023-11-08 07:13:11',NULL),(3786,7492,786,40787,102498,3,485,1,67.50,NULL,'2023-11-08 07:13:11','2023-11-08 07:13:11',NULL),(3787,7492,786,40787,102498,3,484,1,135.00,NULL,'2023-11-08 07:13:11','2023-11-08 07:13:11',NULL),(3788,7492,786,40787,102498,3,1037,1,4794.65,NULL,'2023-11-08 07:13:11','2023-11-08 07:13:11',NULL),(3789,7492,786,40787,102498,3,499,1,311.21,NULL,'2023-11-08 07:13:11','2023-11-08 07:13:11',NULL),(3790,7492,786,40787,102498,3,484,1,135.00,NULL,'2023-11-08 07:13:11','2023-11-08 07:13:11',NULL),(3791,7492,786,40787,102498,3,165,2,2565391.25,NULL,'2023-11-08 07:13:11','2023-11-08 07:13:11',NULL),(3792,7492,787,40787,102499,3,506,1,10558.88,NULL,'2023-11-08 07:15:33','2023-11-08 07:15:33',NULL),(3793,7492,787,40787,102499,3,1029,1,6367.22,NULL,'2023-11-08 07:15:33','2023-11-08 07:15:33',NULL),(3794,7492,787,40787,102499,3,1031,1,15356.00,NULL,'2023-11-08 07:15:33','2023-11-08 07:15:33',NULL),(3795,7492,787,40787,102499,3,166,1,2000000.00,NULL,'2023-11-08 07:15:33','2023-11-08 07:15:33',NULL),(3796,7492,787,40787,102499,3,212,1,78856.00,NULL,'2023-11-08 07:15:33','2023-11-08 07:15:33',NULL),(3797,7492,787,40787,102499,3,485,1,85.50,NULL,'2023-11-08 07:15:33','2023-11-08 07:15:33',NULL),(3798,7492,787,40787,102499,3,484,1,171.00,NULL,'2023-11-08 07:15:33','2023-11-08 07:15:33',NULL),(3799,7492,787,40787,102499,3,1037,1,23690.16,NULL,'2023-11-08 07:15:33','2023-11-08 07:15:33',NULL),(3800,7492,787,40787,102499,3,499,1,4566.93,NULL,'2023-11-08 07:15:33','2023-11-08 07:15:33',NULL),(3801,7492,787,40787,102499,3,165,2,2139651.69,NULL,'2023-11-08 07:15:33','2023-11-08 07:15:33',NULL),(3802,7492,788,40787,102499,2,386,2,3000000.00,NULL,'2023-11-08 08:00:14','2023-11-08 08:00:14',NULL),(3803,7492,788,40787,102499,2,102,2,204497.27,NULL,'2023-11-08 08:00:14','2023-11-08 08:00:14',NULL),(3804,7492,788,40787,102499,2,166,1,3204497.27,NULL,'2023-11-08 08:00:14','2023-11-08 08:00:14',NULL),(3805,7492,789,40787,102499,2,165,1,2676094.87,NULL,'2023-11-08 08:01:19','2023-11-08 08:01:19',NULL),(3806,7492,789,40787,102499,2,386,2,2500000.00,NULL,'2023-11-08 08:01:19','2023-11-08 08:01:19',NULL),(3807,7492,789,40787,102499,2,102,2,176094.87,NULL,'2023-11-08 08:01:19','2023-11-08 08:01:19',NULL),(3808,7492,790,40787,102499,3,1037,1,252551.35,NULL,'2023-11-08 08:03:19','2023-11-08 08:07:42','2023-11-08 08:07:42'),(3809,7492,790,40787,102499,3,166,2,252551.35,NULL,'2023-11-08 08:03:19','2023-11-08 08:07:42','2023-11-08 08:07:42'),(3810,7492,791,40787,102492,3,521,1,51360.00,NULL,'2023-11-08 08:06:10','2023-11-08 08:06:10',NULL),(3811,7492,791,40787,102492,3,128,1,93694.81,NULL,'2023-11-08 08:06:10','2023-11-08 08:06:10',NULL),(3812,7492,791,40787,102492,3,57,1,2425005.80,NULL,'2023-11-08 08:06:10','2023-11-08 08:06:10',NULL);
INSERT INTO `balance_libro_details` VALUES (3813,7492,791,40787,102492,3,165,1,200000.00,NULL,'2023-11-08 08:06:10','2023-11-08 08:06:10',NULL),(3814,7492,791,40787,102492,3,359,1,7600000.00,NULL,'2023-11-08 08:06:10','2023-11-08 08:06:10',NULL),(3815,7492,791,40787,102492,3,74,1,1000000.00,NULL,'2023-11-08 08:06:10','2023-11-08 08:06:10',NULL),(3816,7492,791,40787,102492,3,506,1,29403.54,NULL,'2023-11-08 08:06:10','2023-11-08 08:06:10',NULL),(3817,7492,791,40787,102492,3,25,1,9427.95,NULL,'2023-11-08 08:06:10','2023-11-08 08:06:10',NULL),(3818,7492,791,40787,102492,3,23,1,2693.70,NULL,'2023-11-08 08:06:10','2023-11-08 08:06:10',NULL),(3819,7492,791,40787,102492,3,485,1,1687.50,NULL,'2023-11-08 08:06:10','2023-11-08 08:06:10',NULL),(3820,7492,791,40787,102492,3,396,1,139213.00,NULL,'2023-11-08 08:06:10','2023-11-08 08:06:10',NULL),(3821,7492,791,40787,102492,3,499,1,38194.36,NULL,'2023-11-08 08:06:10','2023-11-08 08:06:10',NULL),(3822,7492,791,40787,102492,3,484,1,3375.00,NULL,'2023-11-08 08:06:10','2023-11-08 08:06:10',NULL),(3823,7492,791,40787,102492,3,166,2,11750316.71,NULL,'2023-11-08 08:06:10','2023-11-08 08:06:10',NULL),(3824,7492,791,40787,102492,3,1037,1,156261.05,NULL,'2023-11-08 08:06:10','2023-11-08 08:06:10',NULL),(3825,7492,792,40787,102489,3,165,1,140000.00,NULL,'2023-11-08 08:06:32','2023-11-09 06:17:49','2023-11-09 06:17:49'),(3826,7492,792,40787,102489,3,359,1,1806000.00,NULL,'2023-11-08 08:06:32','2023-11-09 06:17:49','2023-11-09 06:17:49'),(3827,7492,792,40787,102489,3,62,1,590986.36,NULL,'2023-11-08 08:06:32','2023-11-09 06:17:49','2023-11-09 06:17:49'),(3828,7492,792,40787,102489,3,57,1,1899303.86,NULL,'2023-11-08 08:06:32','2023-11-09 06:17:49','2023-11-09 06:17:49'),(3829,7492,792,40787,102489,3,467,1,160071.00,NULL,'2023-11-08 08:06:32','2023-11-09 06:17:49','2023-11-09 06:17:49'),(3830,7492,792,40787,102489,3,23,1,6204.42,NULL,'2023-11-08 08:06:32','2023-11-09 06:17:49','2023-11-09 06:17:49'),(3831,7492,792,40787,102489,3,25,1,36956.56,NULL,'2023-11-08 08:06:32','2023-11-09 06:17:49','2023-11-09 06:17:49'),(3832,7492,792,40787,102489,3,74,1,1793189.08,NULL,'2023-11-08 08:06:32','2023-11-09 06:17:49','2023-11-09 06:17:49'),(3833,7492,792,40787,102489,3,485,1,516.15,NULL,'2023-11-08 08:06:32','2023-11-09 06:17:49','2023-11-09 06:17:49'),(3834,7492,792,40787,102489,3,484,1,720.00,NULL,'2023-11-08 08:06:32','2023-11-09 06:17:49','2023-11-09 06:17:49'),(3835,7492,792,40787,102489,3,166,2,6520057.73,NULL,'2023-11-08 08:06:32','2023-11-09 06:17:49','2023-11-09 06:17:49'),(3836,7492,792,40787,102489,3,1037,1,86110.30,NULL,'2023-11-08 08:06:32','2023-11-09 06:17:49','2023-11-09 06:17:49'),(3837,7492,793,40787,102499,3,1037,1,10180.00,NULL,'2023-11-08 08:09:44','2023-11-08 08:09:44',NULL),(3838,7492,793,40787,102499,3,166,2,10180.00,NULL,'2023-11-08 08:09:44','2023-11-08 08:09:44',NULL),(3839,7492,794,40787,102498,20,166,1,21385950.97,NULL,'2023-11-08 08:37:54','2023-11-08 08:42:11','2023-11-08 08:42:11'),(3840,7492,794,40787,102498,20,13,2,21385950.97,NULL,'2023-11-08 08:37:54','2023-11-08 08:42:11','2023-11-08 08:42:11'),(3841,7492,795,40787,102498,20,166,1,21385950.97,NULL,'2023-11-08 08:42:11','2023-11-08 08:42:11',NULL),(3842,7492,795,40787,102498,20,13,2,21385950.97,NULL,'2023-11-08 08:42:11','2023-11-08 08:42:11',NULL),(3843,7492,796,40787,102499,3,1032,1,13387244.93,NULL,'2023-11-08 08:42:53','2023-11-08 08:54:15','2023-11-08 08:54:15'),(3844,7492,796,40787,102499,3,392,2,13387244.93,NULL,'2023-11-08 08:42:53','2023-11-08 08:54:15','2023-11-08 08:54:15'),(3845,7492,797,40787,102499,4,1038,1,70815.36,NULL,'2023-11-08 08:45:56','2023-11-08 09:26:08','2023-11-08 09:26:08'),(3846,7492,797,40787,102499,4,132,2,650386.53,NULL,'2023-11-08 08:45:56','2023-11-08 09:26:08','2023-11-08 09:26:08'),(3847,7492,797,40787,102499,4,48,1,58910.01,NULL,'2023-11-08 08:45:56','2023-11-08 09:26:08','2023-11-08 09:26:08'),(3848,7492,797,40787,102499,4,420,1,520661.16,NULL,'2023-11-08 08:45:56','2023-11-08 09:26:08','2023-11-08 09:26:08');
INSERT INTO `balance_libro_details` VALUES (3849,7492,798,40787,102487,12,359,1,139313.91,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3850,7492,798,40787,102487,12,484,1,3227.09,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3851,7492,798,40787,102487,12,166,1,1150694.78,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3852,7492,798,40787,102487,12,165,1,27041.52,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3853,7492,798,40787,102487,12,13,1,1568953.87,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3854,7492,798,40787,102487,12,24,1,117867.73,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3855,7492,798,40787,102487,12,497,1,19410.03,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3856,7492,798,40787,102487,12,498,1,2222.19,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3857,7492,798,40787,102487,12,20,1,125777.75,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3858,7492,798,40787,102487,12,1037,1,79594.84,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3859,7492,798,40787,102487,12,252,1,594.72,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3860,7492,798,40787,102487,12,23,1,569083.29,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3861,7492,798,40787,102487,12,485,1,49529.27,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3862,7492,798,40787,102487,12,508,1,1532.58,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3863,7492,798,40787,102487,12,162,1,72131.14,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3864,7492,798,40787,102487,12,354,1,207835.23,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3865,7492,798,40787,102487,12,392,1,4197489.80,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3866,7492,798,40787,102487,12,419,1,2603305.79,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3867,7492,798,40787,102487,12,420,2,520661.16,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3868,7492,798,40787,102487,12,363,1,589100.07,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3869,7492,798,40787,102487,12,48,2,58910.01,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3870,7492,798,40787,102487,12,506,2,1140325.25,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3871,7492,798,40787,102487,12,1029,2,120977.18,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3872,7492,798,40787,102487,12,517,2,95714.44,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3873,7492,798,40787,102487,12,516,2,595.36,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3874,7492,798,40787,102487,12,1027,2,1702.50,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3875,7492,798,40787,102487,12,518,2,21740.64,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3876,7492,798,40787,102487,12,64,2,8528.66,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3877,7492,798,40787,102487,12,57,2,4842224.20,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3878,7492,798,40787,102487,12,62,2,874320.75,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3879,7492,798,40787,102487,12,63,2,334960.87,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3880,7492,798,40787,102487,12,411,2,606017.30,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3881,7492,798,40787,102487,12,369,2,100000.00,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30');
INSERT INTO `balance_libro_details` VALUES (3882,7492,798,40787,102487,12,88,2,54971.99,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3883,7492,798,40787,102487,12,381,2,64152.49,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3884,7492,798,40787,102487,12,383,2,860850.91,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3885,7492,798,40787,102487,12,92,2,1818051.89,NULL,'2023-11-08 08:48:26','2023-11-09 05:37:30','2023-11-09 05:37:30'),(3886,7492,799,40787,102499,3,1032,1,13387244.93,NULL,'2023-11-08 08:54:15','2023-11-08 09:00:20','2023-11-08 09:00:20'),(3887,7492,799,40787,102499,3,392,2,13387244.93,NULL,'2023-11-08 08:54:15','2023-11-08 09:00:20','2023-11-08 09:00:20'),(3888,7492,800,40787,102487,3,1032,1,1319890.00,NULL,'2023-11-08 08:55:09','2023-11-08 08:55:09',NULL),(3889,7492,800,40787,102487,3,392,2,1319890.00,NULL,'2023-11-08 08:55:09','2023-11-08 08:55:09',NULL),(3890,7492,801,40787,102488,3,1032,1,3533101.34,NULL,'2023-11-08 08:55:39','2023-11-08 08:55:39',NULL),(3891,7492,801,40787,102488,3,392,2,3533101.34,NULL,'2023-11-08 08:55:39','2023-11-08 08:55:39',NULL),(3892,7492,802,40787,102489,3,1032,1,7606759.57,NULL,'2023-11-08 08:56:04','2023-11-09 07:13:58','2023-11-09 07:13:58'),(3893,7492,802,40787,102489,3,392,2,7606759.57,NULL,'2023-11-08 08:56:04','2023-11-09 07:13:58','2023-11-09 07:13:58'),(3894,7492,803,40787,102492,3,1032,1,6115728.94,NULL,'2023-11-08 08:56:37','2023-11-08 08:56:37',NULL),(3895,7492,803,40787,102492,3,392,2,6115728.94,NULL,'2023-11-08 08:56:37','2023-11-08 08:56:37',NULL),(3896,7492,804,40787,102496,3,1032,1,10046112.46,NULL,'2023-11-08 08:57:19','2023-11-09 07:18:17','2023-11-09 07:18:17'),(3897,7492,804,40787,102496,3,392,2,10046112.46,NULL,'2023-11-08 08:57:19','2023-11-09 07:18:17','2023-11-09 07:18:17'),(3898,7492,805,40787,102497,3,1032,1,20041097.00,NULL,'2023-11-08 08:57:53','2023-11-08 09:00:53','2023-11-08 09:00:53'),(3899,7492,805,40787,102497,3,392,2,20041097.00,NULL,'2023-11-08 08:57:53','2023-11-08 09:00:53','2023-11-08 09:00:53'),(3900,7492,806,40787,102494,3,1032,1,3027783.19,NULL,'2023-11-08 08:58:31','2023-11-09 07:28:57','2023-11-09 07:28:57'),(3901,7492,806,40787,102494,3,392,2,3027783.19,NULL,'2023-11-08 08:58:31','2023-11-09 07:28:57','2023-11-09 07:28:57'),(3902,7492,807,40787,102495,3,1032,1,2995357.17,NULL,'2023-11-08 08:59:28','2023-11-08 08:59:28',NULL),(3903,7492,807,40787,102495,3,392,2,2995357.17,NULL,'2023-11-08 08:59:28','2023-11-08 08:59:28',NULL),(3904,7492,808,40787,102498,3,1032,1,4821090.36,NULL,'2023-11-08 08:59:57','2023-11-08 08:59:57',NULL),(3905,7492,808,40787,102498,3,392,2,4821090.36,NULL,'2023-11-08 08:59:57','2023-11-08 08:59:57',NULL),(3906,7492,809,40787,102499,3,1032,1,11273469.41,NULL,'2023-11-08 09:00:20','2023-11-09 07:14:28','2023-11-09 07:14:28'),(3907,7492,809,40787,102499,3,392,2,11273469.41,NULL,'2023-11-08 09:00:20','2023-11-09 07:14:28','2023-11-09 07:14:28'),(3908,7492,810,40787,102497,3,1032,1,16032877.60,NULL,'2023-11-08 09:00:53','2023-11-09 07:14:13','2023-11-09 07:14:13'),(3909,7492,810,40787,102497,3,392,2,16032877.60,NULL,'2023-11-08 09:00:53','2023-11-09 07:14:13','2023-11-09 07:14:13'),(4020,7492,816,40787,102499,18,165,1,3951346.37,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4021,7492,816,40787,102499,18,166,1,1407578.39,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4022,7492,816,40787,102499,18,13,2,69043890.83,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4023,7492,816,40787,102499,18,162,1,1411725.05,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4024,7492,816,40787,102499,18,23,1,2866025.06,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4025,7492,816,40787,102499,18,24,2,137203.10,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20');
INSERT INTO `balance_libro_details` VALUES (4026,7492,816,40787,102499,18,25,2,80263.65,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4027,7492,816,40787,102499,18,251,1,46936.21,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4028,7492,816,40787,102499,18,252,1,561681.36,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4029,7492,816,40787,102499,18,499,1,1765.06,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4030,7492,816,40787,102499,18,500,1,516.11,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4031,7492,816,40787,102499,18,497,2,3879.99,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4032,7492,816,40787,102499,18,498,1,2783.18,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4033,7492,816,40787,102499,18,485,2,136535.49,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4034,7492,816,40787,102499,18,486,2,14980.81,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4035,7492,816,40787,102499,18,301,2,2783.17,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4036,7492,816,40787,102499,18,353,1,204846.00,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4037,7492,816,40787,102499,18,354,2,204937.00,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4038,7492,816,40787,102499,18,484,2,36116.68,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4039,7492,816,40787,102499,18,508,1,13448.23,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4040,7492,816,40787,102499,18,62,2,11475983.85,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4041,7492,816,40787,102499,18,74,2,2124706.91,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4042,7492,816,40787,102499,18,57,2,11600437.91,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4043,7492,816,40787,102499,18,392,1,56831171.49,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4044,7492,816,40787,102499,18,518,1,595.36,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4045,7492,816,40787,102499,18,1027,1,1702.50,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4046,7492,816,40787,102499,18,519,2,41344.50,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4047,7492,816,40787,102499,18,67,2,0.10,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4048,7492,816,40787,102499,18,326,1,22438.03,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4049,7492,816,40787,102499,18,327,1,565103.90,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4050,7492,816,40787,102499,18,506,2,858313.86,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4051,7492,816,40787,102499,18,81,2,8136.72,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4052,7492,816,40787,102499,18,359,1,27879852.27,NULL,'2023-11-08 09:15:53','2023-11-09 06:23:20','2023-11-09 06:23:20'),(4053,7492,817,40787,102499,18,13,1,42771901.94,NULL,'2023-11-08 09:23:49','2023-11-08 09:23:49',NULL),(4054,7492,817,40787,102499,18,359,2,42771901.94,NULL,'2023-11-08 09:23:49','2023-11-08 09:23:49',NULL),(4055,7492,818,40787,102499,4,1038,2,70815.36,NULL,'2023-11-08 09:26:08','2023-11-09 06:37:06','2023-11-09 06:37:06'),(4056,7492,818,40787,102499,4,132,1,650386.53,NULL,'2023-11-08 09:26:08','2023-11-09 06:37:06','2023-11-09 06:37:06'),(4057,7492,818,40787,102499,4,48,2,58910.01,NULL,'2023-11-08 09:26:08','2023-11-09 06:37:06','2023-11-09 06:37:06'),(4058,7492,818,40787,102499,4,420,2,520661.16,NULL,'2023-11-08 09:26:08','2023-11-09 06:37:06','2023-11-09 06:37:06'),(4059,7492,819,40787,102499,1,62,1,22951967.70,NULL,'2023-11-08 09:28:41','2023-11-08 09:28:41',NULL);
INSERT INTO `balance_libro_details` VALUES (4060,7492,819,40787,102499,1,359,2,22951967.70,NULL,'2023-11-08 09:28:41','2023-11-08 09:28:41',NULL),(4061,7492,820,40787,102499,18,489,1,1459772.72,NULL,'2023-11-08 09:39:26','2023-11-09 05:56:30','2023-11-09 05:56:30'),(4062,7492,820,40787,102499,18,212,2,972272.58,NULL,'2023-11-08 09:39:26','2023-11-09 05:56:30','2023-11-09 05:56:30'),(4063,7492,820,40787,102499,18,521,1,42686.00,NULL,'2023-11-08 09:39:26','2023-11-09 05:56:30','2023-11-09 05:56:30'),(4064,7492,820,40787,102499,18,97,1,200000.00,NULL,'2023-11-08 09:39:26','2023-11-09 05:56:30','2023-11-09 05:56:30'),(4065,7492,820,40787,102499,18,483,1,67500.00,NULL,'2023-11-08 09:39:26','2023-11-09 05:56:30','2023-11-09 05:56:30'),(4066,7492,820,40787,102499,18,135,1,1842738.64,NULL,'2023-11-08 09:39:26','2023-11-09 05:56:30','2023-11-09 05:56:30'),(4067,7492,820,40787,102499,18,396,2,308801.19,NULL,'2023-11-08 09:39:26','2023-11-09 05:56:30','2023-11-09 05:56:30'),(4068,7492,820,40787,102499,18,155,2,214158.65,NULL,'2023-11-08 09:39:26','2023-11-09 05:56:30','2023-11-09 05:56:30'),(4069,7492,820,40787,102499,18,359,2,2117464.94,NULL,'2023-11-08 09:39:26','2023-11-09 05:56:30','2023-11-09 05:56:30'),(4070,7492,821,40787,102499,18,166,1,10180.00,NULL,'2023-11-08 09:49:59','2023-11-08 09:49:59',NULL),(4071,7492,821,40787,102499,18,359,2,10180.00,NULL,'2023-11-08 09:49:59','2023-11-08 09:49:59',NULL),(4072,7492,822,40787,102487,12,359,1,139313.91,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4073,7492,822,40787,102487,12,484,1,3227.09,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4074,7492,822,40787,102487,12,166,1,1150694.78,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4075,7492,822,40787,102487,12,165,1,27041.52,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4076,7492,822,40787,102487,12,13,1,1568953.87,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4077,7492,822,40787,102487,12,24,1,117867.73,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4078,7492,822,40787,102487,12,497,1,19410.03,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4079,7492,822,40787,102487,12,498,1,2222.19,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4080,7492,822,40787,102487,12,20,1,125777.75,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4081,7492,822,40787,102487,12,1037,1,79594.84,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4082,7492,822,40787,102487,12,252,1,594.72,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4083,7492,822,40787,102487,12,23,1,569083.29,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4084,7492,822,40787,102487,12,485,1,49529.27,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4085,7492,822,40787,102487,12,508,1,1532.58,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4086,7492,822,40787,102487,12,162,1,72131.14,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4087,7492,822,40787,102487,12,354,1,207835.23,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4088,7492,822,40787,102487,12,392,1,4311706.44,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4089,7492,822,40787,102487,12,419,1,4144760.05,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4090,7492,822,40787,102487,12,420,2,828952.01,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4091,7492,822,40787,102487,12,363,1,952513.61,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4092,7492,822,40787,102487,12,48,2,108815.72,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4093,7492,822,40787,102487,12,506,2,1140325.25,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38');
INSERT INTO `balance_libro_details` VALUES (4094,7492,822,40787,102487,12,1029,2,120977.18,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4095,7492,822,40787,102487,12,517,2,95714.45,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4096,7492,822,40787,102487,12,516,2,595.36,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4097,7492,822,40787,102487,12,1027,2,1702.50,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4098,7492,822,40787,102487,12,518,2,21740.64,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4099,7492,822,40787,102487,12,64,2,8528.66,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4100,7492,822,40787,102487,12,57,2,4842224.20,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4101,7492,822,40787,102487,12,62,2,874320.75,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4102,7492,822,40787,102487,12,63,2,334960.87,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4103,7492,822,40787,102487,12,411,2,820175.94,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4104,7492,822,40787,102487,12,369,2,100000.00,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4105,7492,822,40787,102487,12,88,2,716253.23,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4106,7492,822,40787,102487,12,381,2,175284.32,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4107,7492,822,40787,102487,12,383,2,3353218.96,NULL,'2023-11-09 05:37:30','2023-11-09 05:55:38','2023-11-09 05:55:38'),(4108,7492,823,40787,102499,18,364,1,1825113.18,NULL,'2023-11-09 05:44:44','2023-11-11 09:32:20','2023-11-11 09:32:20'),(4109,7492,823,40787,102499,18,359,2,1825113.18,NULL,'2023-11-09 05:44:44','2023-11-11 09:32:20','2023-11-11 09:32:20'),(4110,7492,824,40787,102487,12,359,1,139313.91,NULL,'2023-11-09 05:55:38','2023-11-09 05:55:38',NULL),(4111,7492,824,40787,102487,12,484,1,3227.09,NULL,'2023-11-09 05:55:38','2023-11-09 05:55:38',NULL),(4112,7492,824,40787,102487,12,166,1,1150694.78,NULL,'2023-11-09 05:55:38','2023-11-09 05:55:38',NULL),(4113,7492,824,40787,102487,12,165,1,27041.52,NULL,'2023-11-09 05:55:38','2023-11-09 05:55:38',NULL),(4114,7492,824,40787,102487,12,13,1,1568953.87,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4115,7492,824,40787,102487,12,24,1,117867.73,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4116,7492,824,40787,102487,12,497,1,19410.03,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4117,7492,824,40787,102487,12,498,1,2222.19,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4118,7492,824,40787,102487,12,20,1,125777.75,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4119,7492,824,40787,102487,12,1037,1,79594.84,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4120,7492,824,40787,102487,12,252,1,594.72,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4121,7492,824,40787,102487,12,23,1,569083.29,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4122,7492,824,40787,102487,12,485,1,49529.27,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4123,7492,824,40787,102487,12,508,1,1532.58,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4124,7492,824,40787,102487,12,162,1,72131.14,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4125,7492,824,40787,102487,12,354,1,207835.23,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4126,7492,824,40787,102487,12,392,1,4311706.44,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4127,7492,824,40787,102487,12,419,1,4144760.05,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4128,7492,824,40787,102487,12,420,2,828952.01,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4129,7492,824,40787,102487,12,363,1,952513.61,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL);
INSERT INTO `balance_libro_details` VALUES (4130,7492,824,40787,102487,12,48,2,108815.72,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4131,7492,824,40787,102487,12,506,2,1140325.25,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4132,7492,824,40787,102487,12,1029,2,120977.18,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4133,7492,824,40787,102487,12,517,2,95714.45,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4134,7492,824,40787,102487,12,516,2,595.36,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4135,7492,824,40787,102487,12,1027,2,1702.50,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4136,7492,824,40787,102487,12,518,2,21740.64,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4137,7492,824,40787,102487,12,64,2,8528.66,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4138,7492,824,40787,102487,12,57,2,4842224.20,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4139,7492,824,40787,102487,12,62,2,874320.75,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4140,7492,824,40787,102487,12,63,2,334960.87,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4141,7492,824,40787,102487,12,411,2,820175.94,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4142,7492,824,40787,102487,12,369,2,100000.00,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4143,7492,824,40787,102487,12,88,2,716253.23,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4144,7492,824,40787,102487,12,381,2,175284.32,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4145,7492,824,40787,102487,12,383,2,3353218.96,NULL,'2023-11-09 05:55:39','2023-11-09 05:55:39',NULL),(4146,7492,825,40787,102499,18,489,1,1459772.72,NULL,'2023-11-09 05:56:30','2023-11-09 05:56:30',NULL),(4147,7492,825,40787,102499,18,212,2,972272.58,NULL,'2023-11-09 05:56:30','2023-11-09 05:56:30',NULL),(4148,7492,825,40787,102499,18,521,1,42686.00,NULL,'2023-11-09 05:56:30','2023-11-09 05:56:30',NULL),(4149,7492,825,40787,102499,18,97,1,200000.00,NULL,'2023-11-09 05:56:30','2023-11-09 05:56:30',NULL),(4150,7492,825,40787,102499,18,483,1,67500.00,NULL,'2023-11-09 05:56:30','2023-11-09 05:56:30',NULL),(4151,7492,825,40787,102499,18,135,1,1842738.64,NULL,'2023-11-09 05:56:30','2023-11-09 05:56:30',NULL),(4152,7492,825,40787,102499,18,396,2,308801.19,NULL,'2023-11-09 05:56:30','2023-11-09 05:56:30',NULL),(4153,7492,825,40787,102499,18,359,2,2331623.59,NULL,'2023-11-09 05:56:30','2023-11-09 05:56:30',NULL),(4154,7492,826,40787,102491,6,411,1,214158.65,NULL,'2023-11-09 05:57:24','2023-11-09 05:57:24',NULL),(4155,7492,826,40787,102491,6,155,2,214158.65,NULL,'2023-11-09 05:57:24','2023-11-09 05:57:24',NULL),(4156,7492,827,40787,102494,3,521,1,40320.00,NULL,'2023-11-09 06:08:06','2023-11-09 06:08:06',NULL),(4157,7492,827,40787,102494,3,165,1,500000.00,NULL,'2023-11-09 06:08:06','2023-11-09 06:08:06',NULL),(4158,7492,827,40787,102494,3,193,1,100000.00,NULL,'2023-11-09 06:08:06','2023-11-09 06:08:06',NULL),(4159,7492,827,40787,102494,3,359,1,2400000.00,NULL,'2023-11-09 06:08:06','2023-11-09 06:08:06',NULL),(4160,7492,827,40787,102494,3,74,1,1729723.68,NULL,'2023-11-09 06:08:06','2023-11-09 06:08:06',NULL),(4161,7492,827,40787,102494,3,467,1,15760.00,NULL,'2023-11-09 06:08:06','2023-11-09 06:08:06',NULL),(4162,7492,827,40787,102494,3,327,1,214217.64,NULL,'2023-11-09 06:08:06','2023-11-09 06:08:06',NULL),(4163,7492,827,40787,102494,3,506,1,29884.13,NULL,'2023-11-09 06:08:06','2023-11-09 06:08:06',NULL),(4164,7492,827,40787,102494,3,485,1,726.30,NULL,'2023-11-09 06:08:06','2023-11-09 06:08:06',NULL),(4165,7492,827,40787,102494,3,499,1,41303.56,NULL,'2023-11-09 06:08:06','2023-11-09 06:08:06',NULL),(4166,7492,827,40787,102494,3,484,1,1296.00,NULL,'2023-11-09 06:08:06','2023-11-09 06:08:06',NULL),(4167,7492,827,40787,102494,3,1037,1,140846.43,NULL,'2023-11-09 06:08:06','2023-11-09 06:08:06',NULL),(4168,7492,827,40787,102494,3,166,2,5214077.74,NULL,'2023-11-09 06:08:06','2023-11-09 06:08:06',NULL);
INSERT INTO `balance_libro_details` VALUES (4169,7492,828,40787,102487,19,506,1,71560.47,NULL,'2023-11-09 06:13:01','2023-11-09 06:14:52','2023-11-09 06:14:52'),(4170,7492,828,40787,102487,19,1033,2,71560.47,NULL,'2023-11-09 06:13:01','2023-11-09 06:14:52','2023-11-09 06:14:52'),(4171,7492,829,40787,102488,19,506,1,71560.47,NULL,'2023-11-09 06:13:23','2023-11-09 06:18:08','2023-11-09 06:18:08'),(4172,7492,829,40787,102488,19,1033,2,71560.47,NULL,'2023-11-09 06:13:23','2023-11-09 06:18:08','2023-11-09 06:18:08'),(4173,7492,830,40787,102489,19,506,1,71560.47,NULL,'2023-11-09 06:13:52','2023-11-09 06:15:05','2023-11-09 06:15:05'),(4174,7492,830,40787,102489,19,1033,2,71560.47,NULL,'2023-11-09 06:13:52','2023-11-09 06:15:05','2023-11-09 06:15:05'),(4175,7492,831,40787,102499,11,1035,1,18808.56,NULL,'2023-11-09 06:14:35','2023-11-09 06:14:35',NULL),(4176,7492,831,40787,102499,11,1029,2,18808.56,NULL,'2023-11-09 06:14:35','2023-11-09 06:14:35',NULL),(4177,7492,832,40787,102487,19,506,2,71560.47,NULL,'2023-11-09 06:14:52','2023-11-09 06:14:52',NULL),(4178,7492,832,40787,102487,19,1033,1,71560.47,NULL,'2023-11-09 06:14:52','2023-11-09 06:14:52',NULL),(4179,7492,833,40787,102489,19,506,2,71560.47,NULL,'2023-11-09 06:15:05','2023-11-09 06:15:05',NULL),(4180,7492,833,40787,102489,19,1033,1,71560.47,NULL,'2023-11-09 06:15:05','2023-11-09 06:15:05',NULL),(4181,7492,834,40787,102489,3,165,1,140000.00,NULL,'2023-11-09 06:17:49','2023-11-09 06:17:49',NULL),(4182,7492,834,40787,102489,3,359,1,1806000.00,NULL,'2023-11-09 06:17:49','2023-11-09 06:17:49',NULL),(4183,7492,834,40787,102489,3,62,1,590986.36,NULL,'2023-11-09 06:17:49','2023-11-09 06:17:49',NULL),(4184,7492,834,40787,102489,3,57,1,1899303.86,NULL,'2023-11-09 06:17:49','2023-11-09 06:17:49',NULL),(4185,7492,834,40787,102489,3,467,1,160071.00,NULL,'2023-11-09 06:17:49','2023-11-09 06:17:49',NULL),(4186,7492,834,40787,102489,3,23,1,6204.42,NULL,'2023-11-09 06:17:49','2023-11-09 06:17:49',NULL),(4187,7492,834,40787,102489,3,25,1,36956.56,NULL,'2023-11-09 06:17:49','2023-11-09 06:17:49',NULL),(4188,7492,834,40787,102489,3,74,1,1793189.08,NULL,'2023-11-09 06:17:49','2023-11-09 06:17:49',NULL),(4189,7492,834,40787,102489,3,485,1,516.15,NULL,'2023-11-09 06:17:49','2023-11-09 06:17:49',NULL),(4190,7492,834,40787,102489,3,484,1,720.00,NULL,'2023-11-09 06:17:49','2023-11-09 06:17:49',NULL),(4191,7492,834,40787,102489,3,166,2,6520057.73,NULL,'2023-11-09 06:17:49','2023-11-09 06:17:49',NULL),(4192,7492,834,40787,102489,3,1037,1,86110.30,NULL,'2023-11-09 06:17:49','2023-11-09 06:17:49',NULL),(4193,7492,835,40787,102488,19,506,2,71560.47,NULL,'2023-11-09 06:18:09','2023-11-09 06:18:09',NULL),(4194,7492,835,40787,102488,19,1033,1,71560.47,NULL,'2023-11-09 06:18:09','2023-11-09 06:18:09',NULL),(4195,7492,836,40787,102490,19,506,2,71560.47,NULL,'2023-11-09 06:18:42','2023-11-09 06:18:42',NULL),(4196,7492,836,40787,102490,19,1033,1,71560.47,NULL,'2023-11-09 06:18:42','2023-11-09 06:18:42',NULL),(4197,7492,837,40787,102491,19,506,2,71560.47,NULL,'2023-11-09 06:18:59','2023-11-09 06:18:59',NULL),(4198,7492,837,40787,102491,19,1033,1,71560.47,NULL,'2023-11-09 06:18:59','2023-11-09 06:18:59',NULL),(4199,7492,838,40787,102492,19,506,2,71560.47,NULL,'2023-11-09 06:19:15','2023-11-09 06:19:15',NULL),(4200,7492,838,40787,102492,19,1033,1,71560.47,NULL,'2023-11-09 06:19:15','2023-11-09 06:19:15',NULL),(4201,7492,839,40787,102494,19,506,2,71560.47,NULL,'2023-11-09 06:19:29','2023-11-09 06:19:29',NULL),(4202,7492,839,40787,102494,19,1033,1,71560.47,NULL,'2023-11-09 06:19:29','2023-11-09 06:19:29',NULL),(4203,7492,840,40787,102495,19,506,2,71560.47,NULL,'2023-11-09 06:19:49','2023-11-09 06:19:49',NULL),(4204,7492,840,40787,102495,19,1033,1,71560.47,NULL,'2023-11-09 06:19:49','2023-11-09 06:19:49',NULL),(4205,7492,841,40787,102496,19,506,2,71560.47,NULL,'2023-11-09 06:20:03','2023-11-09 06:20:03',NULL),(4206,7492,841,40787,102496,19,1033,1,71560.47,NULL,'2023-11-09 06:20:03','2023-11-09 06:20:03',NULL);
INSERT INTO `balance_libro_details` VALUES (4207,7492,842,40787,102497,19,506,2,71560.47,NULL,'2023-11-09 06:20:18','2023-11-09 06:20:18',NULL),(4208,7492,842,40787,102497,19,1033,1,71560.47,NULL,'2023-11-09 06:20:18','2023-11-09 06:20:18',NULL),(4209,7492,843,40787,102498,19,506,2,71560.47,NULL,'2023-11-09 06:20:34','2023-11-09 06:20:34',NULL),(4210,7492,843,40787,102498,19,1033,1,71560.47,NULL,'2023-11-09 06:20:34','2023-11-09 06:20:34',NULL),(4211,7492,844,40787,102499,19,506,2,71560.47,NULL,'2023-11-09 06:20:52','2023-11-09 06:20:52',NULL),(4212,7492,844,40787,102499,19,1033,1,71560.47,NULL,'2023-11-09 06:20:52','2023-11-09 06:20:52',NULL),(4213,7492,845,40787,102499,18,165,1,3951346.37,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4214,7492,845,40787,102499,18,166,1,1407578.39,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4215,7492,845,40787,102499,18,13,2,69043890.83,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4216,7492,845,40787,102499,18,162,1,1411725.05,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4217,7492,845,40787,102499,18,23,1,2866025.06,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4218,7492,845,40787,102499,18,24,2,137203.10,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4219,7492,845,40787,102499,18,25,2,80263.65,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4220,7492,845,40787,102499,18,251,1,46936.21,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4221,7492,845,40787,102499,18,252,1,561681.36,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4222,7492,845,40787,102499,18,499,1,1765.06,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4223,7492,845,40787,102499,18,500,1,516.11,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4224,7492,845,40787,102499,18,497,2,3879.99,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4225,7492,845,40787,102499,18,498,1,2783.18,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4226,7492,845,40787,102499,18,485,2,136535.49,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4227,7492,845,40787,102499,18,486,2,14980.81,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4228,7492,845,40787,102499,18,301,2,2783.17,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4229,7492,845,40787,102499,18,353,1,204846.00,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4230,7492,845,40787,102499,18,354,2,204937.00,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4231,7492,845,40787,102499,18,484,2,36116.68,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4232,7492,845,40787,102499,18,508,1,13448.23,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4233,7492,845,40787,102499,18,62,2,11475983.85,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4234,7492,845,40787,102499,18,74,2,2124706.91,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4235,7492,845,40787,102499,18,57,2,11600437.91,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4236,7492,845,40787,102499,18,392,1,56831171.49,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4237,7492,845,40787,102499,18,518,1,595.36,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4238,7492,845,40787,102499,18,1027,1,1702.50,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4239,7492,845,40787,102499,18,519,2,41344.50,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4240,7492,845,40787,102499,18,67,2,0.10,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20');
INSERT INTO `balance_libro_details` VALUES (4241,7492,845,40787,102499,18,326,1,22438.03,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4242,7492,845,40787,102499,18,327,1,565103.90,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4243,7492,845,40787,102499,18,81,2,8136.72,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4244,7492,845,40787,102499,18,359,1,27021538.41,NULL,'2023-11-09 06:23:20','2023-11-09 06:27:20','2023-11-09 06:27:20'),(4245,7492,846,40787,102499,18,165,1,3951346.37,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4246,7492,846,40787,102499,18,166,1,1407578.39,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4247,7492,846,40787,102499,18,13,2,69043890.83,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4248,7492,846,40787,102499,18,162,1,1411725.05,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4249,7492,846,40787,102499,18,23,1,2866025.06,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4250,7492,846,40787,102499,18,24,2,137203.10,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4251,7492,846,40787,102499,18,25,2,80263.65,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4252,7492,846,40787,102499,18,251,1,46936.21,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4253,7492,846,40787,102499,18,252,1,561681.36,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4254,7492,846,40787,102499,18,499,1,1765.06,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4255,7492,846,40787,102499,18,500,1,516.11,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4256,7492,846,40787,102499,18,497,2,3879.99,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4257,7492,846,40787,102499,18,498,1,2783.18,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4258,7492,846,40787,102499,18,485,2,136535.49,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4259,7492,846,40787,102499,18,486,2,14980.81,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4260,7492,846,40787,102499,18,301,2,2783.17,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4261,7492,846,40787,102499,18,353,1,204846.00,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4262,7492,846,40787,102499,18,354,2,204937.00,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4263,7492,846,40787,102499,18,484,2,36116.68,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4264,7492,846,40787,102499,18,508,1,13448.23,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4265,7492,846,40787,102499,18,62,2,11475983.85,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4266,7492,846,40787,102499,18,74,2,2124706.91,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4267,7492,846,40787,102499,18,57,2,11600437.91,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4268,7492,846,40787,102499,18,392,1,56831171.49,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4269,7492,846,40787,102499,18,518,1,595.36,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4270,7492,846,40787,102499,18,1027,1,1702.50,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4271,7492,846,40787,102499,18,519,2,41344.50,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4272,7492,846,40787,102499,18,67,2,0.10,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4273,7492,846,40787,102499,18,326,1,22438.03,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40');
INSERT INTO `balance_libro_details` VALUES (4274,7492,846,40787,102499,18,327,1,565103.90,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4275,7492,846,40787,102499,18,81,2,8136.72,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4276,7492,846,40787,102499,18,359,1,27021126.63,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4277,7492,846,40787,102499,18,506,1,411.78,NULL,'2023-11-09 06:27:20','2023-11-09 06:35:40','2023-11-09 06:35:40'),(4278,7492,847,40787,102499,18,165,1,3951346.37,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4279,7492,847,40787,102499,18,166,1,1407578.39,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4280,7492,847,40787,102499,18,13,2,69043890.83,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4281,7492,847,40787,102499,18,162,1,1411725.05,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4282,7492,847,40787,102499,18,23,1,2866025.06,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4283,7492,847,40787,102499,18,24,2,137203.10,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4284,7492,847,40787,102499,18,25,2,80263.65,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4285,7492,847,40787,102499,18,251,1,46936.21,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4286,7492,847,40787,102499,18,252,1,561681.36,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4287,7492,847,40787,102499,18,499,1,1765.06,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4288,7492,847,40787,102499,18,500,1,516.11,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4289,7492,847,40787,102499,18,497,2,3879.99,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4290,7492,847,40787,102499,18,498,1,2783.18,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4291,7492,847,40787,102499,18,485,2,136535.49,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4292,7492,847,40787,102499,18,486,2,14980.81,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4293,7492,847,40787,102499,18,301,2,2783.17,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4294,7492,847,40787,102499,18,353,1,204846.00,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4295,7492,847,40787,102499,18,354,2,204937.00,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4296,7492,847,40787,102499,18,484,2,36116.68,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4297,7492,847,40787,102499,18,508,1,13448.23,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4298,7492,847,40787,102499,18,62,2,11475983.85,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4299,7492,847,40787,102499,18,74,2,2124706.91,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4300,7492,847,40787,102499,18,57,2,11600437.92,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4301,7492,847,40787,102499,18,392,1,66831171.49,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4302,7492,847,40787,102499,18,518,1,595.36,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4303,7492,847,40787,102499,18,1027,1,1702.50,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4304,7492,847,40787,102499,18,519,2,41344.50,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4305,7492,847,40787,102499,18,67,2,0.10,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4306,7492,847,40787,102499,18,326,1,22438.03,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25');
INSERT INTO `balance_libro_details` VALUES (4307,7492,847,40787,102499,18,327,1,565103.90,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4308,7492,847,40787,102499,18,81,2,8136.72,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4309,7492,847,40787,102499,18,359,1,16924382.13,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4310,7492,847,40787,102499,18,506,1,411.78,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4311,7492,847,40787,102499,18,411,1,0.01,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4312,7492,847,40787,102499,18,488,1,96744.50,NULL,'2023-11-09 06:35:40','2023-11-09 06:37:25','2023-11-09 06:37:25'),(4313,7492,848,40787,102499,4,1038,2,70815.36,NULL,'2023-11-09 06:37:06','2023-11-09 06:37:06',NULL),(4314,7492,848,40787,102499,4,132,1,650386.53,NULL,'2023-11-09 06:37:06','2023-11-09 06:37:06',NULL),(4315,7492,848,40787,102499,4,48,2,58910.01,NULL,'2023-11-09 06:37:06','2023-11-09 06:37:06',NULL),(4316,7492,848,40787,102499,4,420,2,520661.16,NULL,'2023-11-09 06:37:06','2023-11-09 06:37:06',NULL),(4317,7492,849,40787,102499,18,165,1,3951346.37,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4318,7492,849,40787,102499,18,166,1,1407578.39,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4319,7492,849,40787,102499,18,13,2,69043890.83,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4320,7492,849,40787,102499,18,162,1,1411725.05,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4321,7492,849,40787,102499,18,23,1,2866025.06,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4322,7492,849,40787,102499,18,24,2,137203.10,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4323,7492,849,40787,102499,18,25,2,80263.65,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4324,7492,849,40787,102499,18,251,1,46936.21,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4325,7492,849,40787,102499,18,252,1,561681.36,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4326,7492,849,40787,102499,18,499,1,1765.06,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4327,7492,849,40787,102499,18,500,1,516.11,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4328,7492,849,40787,102499,18,497,2,3879.99,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4329,7492,849,40787,102499,18,498,1,2783.18,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4330,7492,849,40787,102499,18,485,2,136535.49,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4331,7492,849,40787,102499,18,486,2,14980.81,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4332,7492,849,40787,102499,18,301,2,2783.17,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4333,7492,849,40787,102499,18,353,1,204846.00,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4334,7492,849,40787,102499,18,354,2,204937.00,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4335,7492,849,40787,102499,18,484,2,36116.68,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4336,7492,849,40787,102499,18,508,1,13448.23,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4337,7492,849,40787,102499,18,62,2,11475983.85,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4338,7492,849,40787,102499,18,74,2,2124706.91,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4339,7492,849,40787,102499,18,57,2,11600437.92,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4340,7492,849,40787,102499,18,392,1,66831171.49,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58');
INSERT INTO `balance_libro_details` VALUES (4341,7492,849,40787,102499,18,518,1,595.36,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4342,7492,849,40787,102499,18,1027,1,1702.50,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4343,7492,849,40787,102499,18,519,2,41344.50,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4344,7492,849,40787,102499,18,67,2,0.10,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4345,7492,849,40787,102499,18,326,1,22438.03,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4346,7492,849,40787,102499,18,327,1,565103.90,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4347,7492,849,40787,102499,18,81,2,8136.72,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4348,7492,849,40787,102499,18,359,1,16924382.15,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4349,7492,849,40787,102499,18,506,1,411.78,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4350,7492,849,40787,102499,18,411,2,0.01,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4351,7492,849,40787,102499,18,488,1,96744.50,NULL,'2023-11-09 06:37:25','2023-11-11 09:34:58','2023-11-11 09:34:58'),(4352,7492,850,40787,102490,3,1032,1,2424082.39,NULL,'2023-11-09 07:13:32','2023-11-09 07:13:32',NULL),(4353,7492,850,40787,102490,3,392,2,2424082.39,NULL,'2023-11-09 07:13:32','2023-11-09 07:13:32',NULL),(4354,7492,851,40787,102489,3,1032,1,7906759.57,NULL,'2023-11-09 07:13:58','2023-11-09 07:13:58',NULL),(4355,7492,851,40787,102489,3,392,2,7906759.57,NULL,'2023-11-09 07:13:58','2023-11-09 07:13:58',NULL),(4356,7492,852,40787,102497,3,1032,1,16332877.60,NULL,'2023-11-09 07:14:13','2023-11-09 07:14:13',NULL),(4357,7492,852,40787,102497,3,392,2,16332877.60,NULL,'2023-11-09 07:14:13','2023-11-09 07:14:13',NULL),(4358,7492,853,40787,102499,3,1032,1,11573469.41,NULL,'2023-11-09 07:14:28','2023-11-09 07:14:28',NULL),(4359,7492,853,40787,102499,3,392,2,11573469.41,NULL,'2023-11-09 07:14:28','2023-11-09 07:14:28',NULL),(4360,7492,854,40787,102496,3,1032,1,10346112.46,NULL,'2023-11-09 07:18:17','2023-11-09 07:18:17',NULL),(4361,7492,854,40787,102496,3,392,2,10346112.46,NULL,'2023-11-09 07:18:17','2023-11-09 07:18:17',NULL),(4362,7492,855,40787,102494,3,1032,1,3327783.19,NULL,'2023-11-09 07:28:57','2023-11-09 07:28:57',NULL),(4363,7492,855,40787,102494,3,392,2,3327783.19,NULL,'2023-11-09 07:28:57','2023-11-09 07:28:57',NULL),(4364,7492,856,40787,102499,18,364,1,1825113.18,NULL,'2023-11-11 09:32:20','2023-11-11 09:33:00','2023-11-11 09:33:00'),(4365,7492,856,40787,102499,18,359,2,1825113.18,NULL,'2023-11-11 09:32:20','2023-11-11 09:33:00','2023-11-11 09:33:00'),(4366,7492,857,40787,102499,18,165,1,3951346.37,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4367,7492,857,40787,102499,18,166,1,1407578.39,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4368,7492,857,40787,102499,18,13,2,69043890.83,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4369,7492,857,40787,102499,18,162,1,1411725.05,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4370,7492,857,40787,102499,18,23,1,2866025.06,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4371,7492,857,40787,102499,18,24,2,137203.10,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4372,7492,857,40787,102499,18,25,2,80263.65,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4373,7492,857,40787,102499,18,251,1,46936.21,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4374,7492,857,40787,102499,18,252,1,561681.36,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4375,7492,857,40787,102499,18,499,1,1765.06,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46');
INSERT INTO `balance_libro_details` VALUES (4376,7492,857,40787,102499,18,500,1,516.11,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4377,7492,857,40787,102499,18,497,2,3879.99,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4378,7492,857,40787,102499,18,498,1,2783.18,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4379,7492,857,40787,102499,18,485,2,136535.49,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4380,7492,857,40787,102499,18,486,2,14980.81,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4381,7492,857,40787,102499,18,301,2,2783.17,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4382,7492,857,40787,102499,18,353,1,204846.00,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4383,7492,857,40787,102499,18,354,2,204937.00,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4384,7492,857,40787,102499,18,484,2,36116.68,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4385,7492,857,40787,102499,18,508,1,13448.23,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4386,7492,857,40787,102499,18,62,2,11475983.85,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4387,7492,857,40787,102499,18,74,2,2124706.91,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4388,7492,857,40787,102499,18,57,2,11600437.92,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4389,7492,857,40787,102499,18,392,1,69831171.49,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4390,7492,857,40787,102499,18,518,1,595.36,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4391,7492,857,40787,102499,18,1027,1,1702.50,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4392,7492,857,40787,102499,18,519,2,41344.50,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4393,7492,857,40787,102499,18,67,2,0.10,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4394,7492,857,40787,102499,18,326,1,22438.03,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4395,7492,857,40787,102499,18,327,1,565103.90,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4396,7492,857,40787,102499,18,81,2,8136.72,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4397,7492,857,40787,102499,18,359,1,13924382.15,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4398,7492,857,40787,102499,18,506,1,411.78,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4399,7492,857,40787,102499,18,411,2,0.01,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4400,7492,857,40787,102499,18,488,1,96744.50,NULL,'2023-11-11 09:34:58','2023-11-11 09:35:46','2023-11-11 09:35:46'),(4401,7492,858,40787,102499,18,165,1,3951346.37,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4402,7492,858,40787,102499,18,166,1,1407578.39,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4403,7492,858,40787,102499,18,13,2,69043890.83,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4404,7492,858,40787,102499,18,162,1,1411725.05,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4405,7492,858,40787,102499,18,23,1,2866025.06,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4406,7492,858,40787,102499,18,24,2,137203.10,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4407,7492,858,40787,102499,18,25,2,80263.65,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4408,7492,858,40787,102499,18,251,1,46936.21,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4409,7492,858,40787,102499,18,252,1,561681.36,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4410,7492,858,40787,102499,18,499,1,1765.06,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL);
INSERT INTO `balance_libro_details` VALUES (4411,7492,858,40787,102499,18,500,1,516.11,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4412,7492,858,40787,102499,18,497,2,3879.99,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4413,7492,858,40787,102499,18,498,1,2783.18,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4414,7492,858,40787,102499,18,485,2,136535.49,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4415,7492,858,40787,102499,18,486,2,14980.81,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4416,7492,858,40787,102499,18,301,2,2783.17,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4417,7492,858,40787,102499,18,353,1,204846.00,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4418,7492,858,40787,102499,18,354,2,204937.00,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4419,7492,858,40787,102499,18,484,2,36116.68,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4420,7492,858,40787,102499,18,508,1,13448.23,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4421,7492,858,40787,102499,18,62,2,11475983.85,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4422,7492,858,40787,102499,18,74,2,2124706.91,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4423,7492,858,40787,102499,18,57,2,11600437.92,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4424,7492,858,40787,102499,18,392,1,71831171.49,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4425,7492,858,40787,102499,18,518,1,595.36,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4426,7492,858,40787,102499,18,1027,1,1702.50,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4427,7492,858,40787,102499,18,519,2,41344.50,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4428,7492,858,40787,102499,18,67,2,0.10,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4429,7492,858,40787,102499,18,326,1,22438.03,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4430,7492,858,40787,102499,18,327,1,565103.90,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4431,7492,858,40787,102499,18,81,2,8136.72,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4432,7492,858,40787,102499,18,359,1,11924382.15,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4433,7492,858,40787,102499,18,506,1,411.78,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4434,7492,858,40787,102499,18,411,2,0.01,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4435,7492,858,40787,102499,18,488,1,96744.50,NULL,'2023-11-11 09:35:46','2023-11-11 09:35:46',NULL),(4436,7492,859,40787,102499,23,199,1,41065.35,NULL,'2023-11-11 10:36:30','2023-11-11 10:36:30',NULL),(4437,7492,859,40787,102499,23,48,2,109593.68,NULL,'2023-11-11 10:36:30','2023-11-11 10:36:30',NULL),(4438,7492,859,40787,102499,23,482,2,48780141.87,NULL,'2023-11-11 10:36:30','2023-11-11 10:36:30',NULL),(4439,7492,859,40787,102499,23,419,1,4174392.21,NULL,'2023-11-11 10:36:31','2023-11-11 10:36:31',NULL),(4440,7492,859,40787,102499,23,110,1,8371906.60,NULL,'2023-11-11 10:36:31','2023-11-11 10:36:31',NULL),(4441,7492,859,40787,102499,23,521,1,314114.19,NULL,'2023-11-11 10:36:31','2023-11-11 10:36:31',NULL),(4442,7492,859,40787,102499,23,503,1,13492.07,NULL,'2023-11-11 10:36:31','2023-11-11 10:36:31',NULL),(4443,7492,859,40787,102499,23,515,1,724466.20,NULL,'2023-11-11 10:36:32','2023-11-11 10:36:32',NULL),(4444,7492,859,40787,102499,23,208,1,64451.85,NULL,'2023-11-11 10:36:32','2023-11-11 10:36:32',NULL),(4445,7492,859,40787,102499,23,193,1,1600572.11,NULL,'2023-11-11 10:36:32','2023-11-11 10:36:32',NULL),(4446,7492,859,40787,102499,23,180,1,603523.09,NULL,'2023-11-11 10:36:32','2023-11-11 10:36:32',NULL),(4447,7492,859,40787,102499,23,212,1,334192.89,NULL,'2023-11-11 10:36:33','2023-11-11 10:36:33',NULL),(4448,7492,859,40787,102499,23,381,2,176537.48,NULL,'2023-11-11 10:36:33','2023-11-11 10:36:33',NULL),(4449,7492,859,40787,102499,23,198,1,33792.87,NULL,'2023-11-11 10:36:33','2023-11-11 10:36:33',NULL);
INSERT INTO `balance_libro_details` VALUES (4450,7492,859,40787,102499,23,88,2,100714.93,NULL,'2023-11-11 10:36:33','2023-11-11 10:36:33',NULL),(4451,7492,859,40787,102499,23,160,1,115230.20,NULL,'2023-11-11 10:36:34','2023-11-11 10:36:34',NULL),(4452,7492,859,40787,102499,23,420,2,834878.44,NULL,'2023-11-11 10:36:34','2023-11-11 10:36:34',NULL),(4453,7492,859,40787,102499,23,191,1,1895202.78,NULL,'2023-11-11 10:36:34','2023-11-11 10:36:34',NULL),(4454,7492,859,40787,102499,23,505,1,7079.12,NULL,'2023-11-11 10:36:34','2023-11-11 10:36:34',NULL),(4455,7492,859,40787,102499,23,514,1,3831.71,NULL,'2023-11-11 10:36:35','2023-11-11 10:36:35',NULL),(4456,7492,859,40787,102499,23,507,1,378687.49,NULL,'2023-11-11 10:36:35','2023-11-11 10:36:35',NULL),(4457,7492,859,40787,102499,23,1033,1,400508.98,NULL,'2023-11-11 10:36:35','2023-11-11 10:36:35',NULL),(4458,7492,859,40787,102499,23,496,1,1127226.00,NULL,'2023-11-11 10:36:35','2023-11-11 10:36:35',NULL),(4459,7492,859,40787,102499,23,483,1,217579.40,NULL,'2023-11-11 10:36:36','2023-11-11 10:36:36',NULL),(4460,7492,859,40787,102499,23,121,1,198707.41,NULL,'2023-11-11 10:36:36','2023-11-11 10:36:36',NULL),(4461,7492,859,40787,102499,23,383,2,3377192.15,NULL,'2023-11-11 10:36:36','2023-11-11 10:36:36',NULL),(4462,7492,859,40787,102499,23,128,1,356986.47,NULL,'2023-11-11 10:36:37','2023-11-11 10:36:37',NULL),(4463,7492,859,40787,102499,23,88,2,721373.94,NULL,'2023-11-11 10:36:37','2023-11-11 10:36:37',NULL),(4464,7492,859,40787,102499,23,494,1,332565.14,NULL,'2023-11-11 10:36:37','2023-11-11 10:36:37',NULL),(4465,7492,859,40787,102499,23,120,1,20301.93,NULL,'2023-11-11 10:36:37','2023-11-11 10:36:37',NULL),(4466,7492,859,40787,102499,23,520,1,40800.58,NULL,'2023-11-11 10:36:37','2023-11-11 10:36:37',NULL),(4467,7492,859,40787,102499,23,512,1,5332.69,NULL,'2023-11-11 10:36:38','2023-11-11 10:36:38',NULL),(4468,7492,859,40787,102499,23,137,1,1421144.17,NULL,'2023-11-11 10:36:38','2023-11-11 10:36:38',NULL),(4469,7492,859,40787,102499,23,396,1,412026.80,NULL,'2023-11-11 10:36:38','2023-11-11 10:36:38',NULL),(4470,7492,859,40787,102499,23,510,1,76651.13,NULL,'2023-11-11 10:36:38','2023-11-11 10:36:38',NULL),(4471,7492,859,40787,102499,23,116,1,634115.24,NULL,'2023-11-11 10:36:39','2023-11-11 10:36:39',NULL),(4472,7492,859,40787,102499,23,495,1,13961.85,NULL,'2023-11-11 10:36:39','2023-11-11 10:36:39',NULL),(4473,7492,859,40787,102499,23,489,1,7899.85,NULL,'2023-11-11 10:36:39','2023-11-11 10:36:39',NULL),(4474,7492,859,40787,102499,23,1032,1,25270669.54,NULL,'2023-11-11 10:36:39','2023-11-11 10:36:39',NULL),(4475,7492,859,40787,102499,23,155,2,125075.41,NULL,'2023-11-11 10:36:40','2023-11-11 10:36:40',NULL),(4476,7492,859,40787,102499,23,392,2,11401787.62,NULL,'2023-11-11 10:36:40','2023-11-11 10:36:40',NULL),(4477,7492,859,40787,102499,23,135,1,87917.31,NULL,'2023-11-11 10:36:40','2023-11-11 10:36:40',NULL),(4478,7492,859,40787,102499,23,363,1,1004500.90,NULL,'2023-11-11 10:36:40','2023-11-11 10:36:40',NULL),(4479,7492,859,40787,102499,23,501,1,38199.48,NULL,'2023-11-11 10:36:41','2023-11-11 10:36:41',NULL),(4480,7492,859,40787,102499,23,1031,1,54591.51,NULL,'2023-11-11 10:36:41','2023-11-11 10:36:41',NULL),(4481,7492,859,40787,102499,23,467,1,129474.47,NULL,'2023-11-11 10:36:41','2023-11-11 10:36:41',NULL),(4482,7492,859,40787,102499,23,97,1,1379.29,NULL,'2023-11-11 10:36:42','2023-11-11 10:36:42',NULL),(4483,7492,859,40787,102499,23,476,1,15098754.65,NULL,'2023-11-11 10:36:43','2023-11-11 10:36:43',NULL),(4484,7492,860,40787,102499,6,411,2,5860955.98,NULL,'2023-11-11 11:24:47','2023-11-11 11:24:47',NULL),(4485,7492,860,40787,102499,6,155,1,5860955.98,NULL,'2023-11-11 11:24:47','2023-11-11 11:24:47',NULL),(4486,7492,861,40787,102500,2,13,1,16531425.34,NULL,'2023-11-29 13:34:07','2023-11-29 13:34:07',NULL),(4487,7492,861,40787,102500,2,67,2,2869090.35,NULL,'2023-11-29 13:34:07','2023-11-29 13:34:07',NULL),(4488,7492,861,40787,102500,2,482,2,13662334.99,NULL,'2023-11-29 13:34:07','2023-11-29 13:34:07',NULL);
INSERT INTO `balance_libro_details` VALUES (4489,7492,862,40787,102500,3,392,1,1194711.88,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4490,7492,862,40787,102500,3,160,1,34023.53,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4491,7492,862,40787,102500,3,199,1,6578.52,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4492,7492,862,40787,102500,3,198,1,26419.13,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4493,7492,862,40787,102500,3,128,1,26183.71,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4494,7492,862,40787,102500,3,512,1,2388.42,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4495,7492,862,40787,102500,3,494,1,7438.02,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4496,7492,862,40787,102500,3,120,1,2611.57,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4497,7492,862,40787,102500,3,489,1,22885.03,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4498,7492,862,40787,102500,3,180,1,719928.80,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4499,7492,862,40787,102500,3,483,1,40500.00,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4500,7492,862,40787,102500,3,396,1,194296.76,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4501,7492,862,40787,102500,3,116,1,146625.00,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4502,7492,862,40787,102500,3,68,1,427573.43,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4503,7492,862,40787,102500,3,485,1,10673.46,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4504,7492,862,40787,102500,3,486,1,4587.79,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4505,7492,862,40787,102500,3,484,1,7778.41,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4506,7492,862,40787,102500,3,503,1,3769.61,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4507,7492,862,40787,102500,3,165,2,668805.70,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4508,7492,862,40787,102500,3,57,2,2210167.37,NULL,'2023-11-29 13:54:11','2024-10-02 16:15:20','2024-10-02 16:15:20'),(4509,7492,863,40787,102500,16,496,1,255462.70,NULL,'2023-11-29 14:09:40','2024-09-19 17:27:39','2024-09-19 17:27:39'),(4510,7492,863,40787,102500,16,485,2,10673.46,NULL,'2023-11-29 14:09:40','2024-09-19 17:27:39','2024-09-19 17:27:39'),(4511,7492,863,40787,102500,16,252,2,33307.58,NULL,'2023-11-29 14:09:40','2024-09-19 17:27:39','2024-09-19 17:27:39'),(4512,7492,863,40787,102500,16,499,2,87694.20,NULL,'2023-11-29 14:09:40','2024-09-19 17:27:39','2024-09-19 17:27:39'),(4513,7492,863,40787,102500,16,327,2,123787.46,NULL,'2023-11-29 14:09:40','2024-09-19 17:27:39','2024-09-19 17:27:39'),(4514,7492,863,40787,102500,16,208,1,22230.00,NULL,'2023-11-29 14:09:40','2024-09-19 17:27:39','2024-09-19 17:27:39'),(4515,7492,863,40787,102500,16,508,2,4587.79,NULL,'2023-11-29 14:09:40','2024-09-19 17:27:39','2024-09-19 17:27:39'),(4516,7492,863,40787,102500,16,251,2,11856.00,NULL,'2023-11-29 14:09:40','2024-09-19 17:27:39','2024-09-19 17:27:39'),(4517,7492,863,40787,102500,16,326,2,5786.21,NULL,'2023-11-29 14:09:40','2024-09-19 17:27:39','2024-09-19 17:27:39'),(4518,7492,864,40787,102500,15,67,1,2869090.35,NULL,'2023-11-29 14:14:21','2024-09-19 17:11:08','2024-09-19 17:11:08'),(4519,7492,864,40787,102500,15,68,2,427573.43,NULL,'2023-11-29 14:14:21','2024-09-19 17:11:08','2024-09-19 17:11:08'),(4520,7492,864,40787,102500,15,74,2,2433738.51,NULL,'2023-11-29 14:14:21','2024-09-19 17:11:08','2024-09-19 17:11:08'),(4521,7492,864,40787,102500,15,484,2,7778.41,NULL,'2023-11-29 14:14:21','2024-09-19 17:11:08','2024-09-19 17:11:08'),(4522,7492,865,40787,102501,2,13,1,37100035.75,NULL,'2023-11-29 14:17:15','2023-11-29 14:17:15',NULL);
INSERT INTO `balance_libro_details` VALUES (4523,7492,865,40787,102501,2,67,2,7791007.50,NULL,'2023-11-29 14:17:15','2023-11-29 14:17:15',NULL),(4524,7492,865,40787,102501,2,482,2,29309028.25,NULL,'2023-11-29 14:17:15','2023-11-29 14:17:15',NULL),(4525,7492,866,40787,102501,3,392,1,12466872.41,NULL,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(4526,7492,866,40787,102501,3,160,1,36990.04,NULL,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(4527,7492,866,40787,102501,3,199,1,7305.49,NULL,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(4528,7492,866,40787,102501,3,198,1,2974.38,NULL,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(4529,7492,866,40787,102501,3,128,1,72239.05,NULL,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(4530,7492,866,40787,102501,3,494,1,357438.02,NULL,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(4531,7492,866,40787,102501,3,120,1,11892.54,NULL,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(4532,7492,866,40787,102501,3,212,1,106825.27,NULL,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(4533,7492,866,40787,102501,3,180,1,211195.50,NULL,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(4534,7492,866,40787,102501,3,483,1,67500.00,NULL,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(4535,7492,866,40787,102501,3,396,1,464055.47,NULL,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(4536,7492,866,40787,102501,3,116,1,146625.00,NULL,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(4537,7492,866,40787,102501,3,68,1,2803598.53,NULL,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(4538,7492,866,40787,102501,3,485,1,19391.99,NULL,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(4539,7492,866,40787,102501,3,225,1,249602.73,NULL,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(4540,7492,866,40787,102501,3,484,1,19985.41,NULL,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(4541,7492,866,40787,102501,3,503,1,4741.47,NULL,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(4542,7492,866,40787,102501,3,165,2,8032.98,NULL,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(4543,7492,866,40787,102501,3,359,2,17041200.32,NULL,'2023-11-29 14:38:21','2023-11-29 17:27:04','2023-11-29 17:27:04'),(4544,7492,867,40787,102501,16,496,1,452007.38,NULL,'2023-11-29 14:55:43','2023-11-29 17:30:53','2023-11-29 17:30:53'),(4545,7492,867,40787,102501,16,485,2,19391.99,NULL,'2023-11-29 14:55:43','2023-11-29 17:30:53','2023-11-29 17:30:53'),(4546,7492,867,40787,102501,16,252,2,252053.68,NULL,'2023-11-29 14:55:43','2023-11-29 17:30:53','2023-11-29 17:30:53'),(4547,7492,867,40787,102501,16,327,2,67098.57,NULL,'2023-11-29 14:55:43','2023-11-29 17:30:53','2023-11-29 17:30:53'),(4548,7492,867,40787,102501,16,359,1,362491.66,NULL,'2023-11-29 14:55:43','2023-11-29 17:30:53','2023-11-29 17:30:53'),(4549,7492,867,40787,102501,16,508,2,249602.73,NULL,'2023-11-29 14:55:43','2023-11-29 17:30:53','2023-11-29 17:30:53'),(4550,7492,867,40787,102501,16,251,2,8892.00,NULL,'2023-11-29 14:55:43','2023-11-29 17:30:53','2023-11-29 17:30:53'),(4551,7492,867,40787,102501,16,500,2,7680.53,NULL,'2023-11-29 14:55:43','2023-11-29 17:30:53','2023-11-29 17:30:53'),(4552,7492,867,40787,102501,16,499,2,113463.14,NULL,'2023-11-29 14:55:43','2023-11-29 17:30:53','2023-11-29 17:30:53'),(4553,7492,867,40787,102501,16,326,2,96316.40,NULL,'2023-11-29 14:55:43','2023-11-29 17:30:53','2023-11-29 17:30:53'),(4554,7492,868,40787,102501,15,67,1,7791007.50,NULL,'2023-11-29 14:58:08','2024-09-19 17:17:42','2024-09-19 17:17:42'),(4555,7492,868,40787,102501,15,68,2,2803598.53,NULL,'2023-11-29 14:58:08','2024-09-19 17:17:42','2024-09-19 17:17:42'),(4556,7492,868,40787,102501,15,74,2,4967423.56,NULL,'2023-11-29 14:58:08','2024-09-19 17:17:42','2024-09-19 17:17:42');
INSERT INTO `balance_libro_details` VALUES (4557,7492,868,40787,102501,15,484,2,19985.41,NULL,'2023-11-29 14:58:08','2024-09-19 17:17:42','2024-09-19 17:17:42'),(4558,7492,869,40787,102501,3,392,1,12466872.41,NULL,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(4559,7492,869,40787,102501,3,160,1,36990.04,NULL,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(4560,7492,869,40787,102501,3,199,1,7305.49,NULL,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(4561,7492,869,40787,102501,3,198,1,2974.38,NULL,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(4562,7492,869,40787,102501,3,128,1,72239.05,NULL,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(4563,7492,869,40787,102501,3,494,1,357438.02,NULL,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(4564,7492,869,40787,102501,3,120,1,11892.54,NULL,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(4565,7492,869,40787,102501,3,212,1,106825.27,NULL,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(4566,7492,869,40787,102501,3,180,1,211195.50,NULL,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(4567,7492,869,40787,102501,3,483,1,67500.00,NULL,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(4568,7492,869,40787,102501,3,396,1,464055.47,NULL,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(4569,7492,869,40787,102501,3,116,1,146625.00,NULL,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(4570,7492,869,40787,102501,3,68,1,2803598.53,NULL,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(4571,7492,869,40787,102501,3,485,1,19391.99,NULL,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(4572,7492,869,40787,102501,3,225,1,249602.73,NULL,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(4573,7492,869,40787,102501,3,484,1,19985.41,NULL,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(4574,7492,869,40787,102501,3,503,1,4741.47,NULL,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(4575,7492,869,40787,102501,3,165,2,8032.98,NULL,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(4576,7492,869,40787,102501,3,57,2,17041200.32,NULL,'2023-11-29 17:27:04','2024-09-19 17:12:03','2024-09-19 17:12:03'),(4577,7492,870,40787,102501,16,496,1,452007.38,NULL,'2023-11-29 17:30:53','2024-09-19 17:30:15','2024-09-19 17:30:15'),(4578,7492,870,40787,102501,16,485,2,19391.99,NULL,'2023-11-29 17:30:53','2024-09-19 17:30:15','2024-09-19 17:30:15'),(4579,7492,870,40787,102501,16,252,2,252053.68,NULL,'2023-11-29 17:30:53','2024-09-19 17:30:15','2024-09-19 17:30:15'),(4580,7492,870,40787,102501,16,327,2,67098.57,NULL,'2023-11-29 17:30:53','2024-09-19 17:30:15','2024-09-19 17:30:15'),(4581,7492,870,40787,102501,16,508,2,249602.73,NULL,'2023-11-29 17:30:53','2024-09-19 17:30:15','2024-09-19 17:30:15'),(4582,7492,870,40787,102501,16,251,2,8892.00,NULL,'2023-11-29 17:30:53','2024-09-19 17:30:15','2024-09-19 17:30:15'),(4583,7492,870,40787,102501,16,500,2,7680.53,NULL,'2023-11-29 17:30:53','2024-09-19 17:30:15','2024-09-19 17:30:15'),(4584,7492,870,40787,102501,16,499,2,113463.14,NULL,'2023-11-29 17:30:53','2024-09-19 17:30:15','2024-09-19 17:30:15'),(4585,7492,870,40787,102501,16,326,2,96316.40,NULL,'2023-11-29 17:30:53','2024-09-19 17:30:15','2024-09-19 17:30:15'),(4586,7492,870,40787,102501,16,208,1,362491.66,NULL,'2023-11-29 17:30:53','2024-09-19 17:30:15','2024-09-19 17:30:15'),(4587,7492,871,40789,104002,3,50,1,10578.51,NULL,'2023-12-19 11:41:29','2023-12-19 13:46:47','2023-12-19 13:46:47'),(4588,7492,871,40789,104002,3,507,1,313574.66,NULL,'2023-12-19 11:41:29','2023-12-19 13:46:47','2023-12-19 13:46:47'),(4589,7492,871,40789,104002,3,393,1,9309.50,NULL,'2023-12-19 11:41:29','2023-12-19 13:46:47','2023-12-19 13:46:47'),(4590,7492,871,40789,104002,3,359,2,13119.25,NULL,'2023-12-19 11:41:29','2023-12-19 13:46:47','2023-12-19 13:46:47');
INSERT INTO `balance_libro_details` VALUES (4591,7492,871,40789,104002,3,68,1,51022.00,NULL,'2023-12-19 11:41:29','2023-12-19 13:46:47','2023-12-19 13:46:47'),(4592,7492,871,40789,104002,3,472,1,340000.00,NULL,'2023-12-19 11:41:29','2023-12-19 13:46:47','2023-12-19 13:46:47'),(4593,7492,871,40789,104002,3,438,2,340000.00,NULL,'2023-12-19 11:41:29','2023-12-19 13:46:47','2023-12-19 13:46:47'),(4594,7492,871,40789,104002,3,57,2,371365.42,NULL,'2023-12-19 11:41:29','2023-12-19 13:46:47','2023-12-19 13:46:47'),(4595,7492,872,40789,104002,3,359,2,22687.00,NULL,'2023-12-19 13:55:46','2023-12-19 13:55:46',NULL),(4596,7492,872,40789,104002,3,68,1,3129.57,NULL,'2023-12-19 13:55:46','2023-12-19 13:55:46',NULL),(4597,7492,872,40789,104002,3,489,1,9309.50,NULL,'2023-12-19 13:55:46','2023-12-19 13:55:46',NULL),(4598,7492,872,40789,104002,3,120,1,10247.93,NULL,'2023-12-19 13:55:46','2023-12-19 13:55:46',NULL),(4599,7492,873,40789,104002,3,68,1,3304.54,NULL,'2023-12-19 14:00:12','2023-12-19 14:45:25','2023-12-19 14:45:25'),(4600,7492,873,40789,104002,3,120,1,15735.87,NULL,'2023-12-19 14:00:12','2023-12-19 14:45:25','2023-12-19 14:45:25'),(4601,7492,873,40789,104002,3,359,2,19040.41,NULL,'2023-12-19 14:00:12','2023-12-19 14:45:25','2023-12-19 14:45:25'),(4602,7492,873,40789,104002,3,438,2,180000.00,NULL,'2023-12-19 14:00:12','2023-12-19 14:45:25','2023-12-19 14:45:25'),(4603,7492,873,40789,104002,3,494,1,180000.00,NULL,'2023-12-19 14:00:12','2023-12-19 14:45:25','2023-12-19 14:45:25'),(4604,7492,874,40789,104002,3,68,1,3304.54,NULL,'2023-12-19 14:45:25','2023-12-19 14:45:25',NULL),(4605,7492,874,40789,104002,3,120,1,15735.87,NULL,'2023-12-19 14:45:25','2023-12-19 14:45:25',NULL),(4606,7492,874,40789,104002,3,359,2,19040.41,NULL,'2023-12-19 14:45:25','2023-12-19 14:45:25',NULL),(4607,7492,874,40789,104002,3,438,2,180000.00,NULL,'2023-12-19 14:45:25','2023-12-19 14:45:25',NULL),(4608,7492,874,40789,104002,3,494,1,180000.00,NULL,'2023-12-19 14:45:25','2023-12-19 14:45:25',NULL),(4609,7492,875,40789,104002,15,68,2,3304.54,NULL,'2023-12-19 14:46:44','2023-12-19 14:55:12','2023-12-19 14:55:12'),(4610,7492,875,40789,104002,15,509,1,3304.54,NULL,'2023-12-19 14:46:44','2023-12-19 14:55:12','2023-12-19 14:55:12'),(4611,7492,876,40789,104002,3,116,1,484000.00,NULL,'2023-12-19 14:52:16','2023-12-19 14:58:07','2023-12-19 14:58:07'),(4612,7492,876,40789,104002,3,46,1,313574.66,NULL,'2023-12-19 14:52:16','2023-12-19 14:58:07','2023-12-19 14:58:07'),(4613,7492,876,40789,104002,3,483,1,32500.00,NULL,'2023-12-19 14:52:16','2023-12-19 14:58:07','2023-12-19 14:58:07'),(4614,7492,876,40789,104002,3,494,1,160000.00,NULL,'2023-12-19 14:52:16','2023-12-19 14:58:07','2023-12-19 14:58:07'),(4615,7492,876,40789,104002,3,42,1,55535.54,NULL,'2023-12-19 14:52:16','2023-12-19 14:58:07','2023-12-19 14:58:07'),(4616,7492,876,40789,104002,3,68,1,44587.80,NULL,'2023-12-19 14:52:16','2023-12-19 14:58:07','2023-12-19 14:58:07'),(4617,7492,876,40789,104002,3,359,2,930198.00,NULL,'2023-12-19 14:52:16','2023-12-19 14:58:07','2023-12-19 14:58:07'),(4618,7492,876,40789,104002,3,438,2,160000.00,NULL,'2023-12-19 14:52:16','2023-12-19 14:58:07','2023-12-19 14:58:07'),(4619,7492,877,40789,104002,15,509,1,47892.34,NULL,'2023-12-19 14:53:40','2023-12-19 14:53:40',NULL),(4620,7492,877,40789,104002,15,509,2,3304.54,NULL,'2023-12-19 14:53:40','2023-12-19 14:53:40',NULL),(4621,7492,877,40789,104002,15,68,2,44587.80,NULL,'2023-12-19 14:53:40','2023-12-19 14:53:40',NULL),(4622,7492,878,40789,104002,2,359,1,165000.00,NULL,'2023-12-19 14:54:45','2023-12-19 14:54:45',NULL),(4623,7492,878,40789,104002,2,67,2,28636.36,NULL,'2023-12-19 14:54:45','2023-12-19 14:54:45',NULL),(4624,7492,878,40789,104002,2,482,2,136363.64,NULL,'2023-12-19 14:54:45','2023-12-19 14:54:45',NULL),(4625,7492,879,40789,104002,15,68,2,3304.54,NULL,'2023-12-19 14:55:12','2023-12-19 14:55:12',NULL),(4626,7492,879,40789,104002,15,509,1,3304.54,NULL,'2023-12-19 14:55:12','2023-12-19 14:55:12',NULL);
INSERT INTO `balance_libro_details` VALUES (4627,7492,880,40789,104002,15,509,1,19255.98,NULL,'2023-12-19 14:56:18','2023-12-19 14:56:18',NULL),(4628,7492,880,40789,104002,15,509,2,47892.34,NULL,'2023-12-19 14:56:18','2023-12-19 14:56:18',NULL),(4629,7492,880,40789,104002,15,67,1,28636.36,NULL,'2023-12-19 14:56:18','2023-12-19 14:56:18',NULL),(4630,7492,881,40789,104002,3,116,1,484000.00,NULL,'2023-12-19 14:58:07','2023-12-25 12:13:37','2023-12-25 12:13:37'),(4631,7492,881,40789,104002,3,46,1,313574.66,NULL,'2023-12-19 14:58:07','2023-12-25 12:13:37','2023-12-25 12:13:37'),(4632,7492,881,40789,104002,3,494,1,160000.00,NULL,'2023-12-19 14:58:07','2023-12-25 12:13:37','2023-12-25 12:13:37'),(4633,7492,881,40789,104002,3,42,1,55535.54,NULL,'2023-12-19 14:58:07','2023-12-25 12:13:37','2023-12-25 12:13:37'),(4634,7492,881,40789,104002,3,68,1,44587.80,NULL,'2023-12-19 14:58:07','2023-12-25 12:13:37','2023-12-25 12:13:37'),(4635,7492,881,40789,104002,3,359,2,897698.00,NULL,'2023-12-19 14:58:07','2023-12-25 12:13:37','2023-12-25 12:13:37'),(4636,7492,881,40789,104002,3,438,2,160000.00,NULL,'2023-12-19 14:58:07','2023-12-25 12:13:37','2023-12-25 12:13:37'),(4637,7492,882,40789,104002,3,483,1,32500.00,NULL,'2023-12-19 15:04:18','2023-12-19 15:04:18',NULL),(4638,7492,882,40789,104002,3,57,2,32500.00,NULL,'2023-12-19 15:04:18','2023-12-19 15:04:18',NULL),(4639,7492,883,40789,104002,2,359,1,109200.00,NULL,'2023-12-19 15:05:22','2023-12-26 09:57:25','2023-12-26 09:57:25'),(4640,7492,883,40789,104002,2,67,2,18952.07,NULL,'2023-12-19 15:05:22','2023-12-26 09:57:25','2023-12-26 09:57:25'),(4641,7492,883,40789,104002,2,482,2,90247.93,NULL,'2023-12-19 15:05:22','2023-12-26 09:57:25','2023-12-26 09:57:25'),(4642,7492,884,40789,104002,12,359,1,9600.00,NULL,'2023-12-19 15:32:31','2023-12-23 09:28:45','2023-12-23 09:28:45'),(4643,7492,884,40789,104002,12,369,2,192000.00,NULL,'2023-12-19 15:32:31','2023-12-23 09:28:45','2023-12-23 09:28:45'),(4644,7492,884,40789,104002,12,455,1,182400.00,NULL,'2023-12-19 15:32:31','2023-12-23 09:28:45','2023-12-23 09:28:45'),(4645,7492,885,40789,104002,12,91,1,47088.00,NULL,'2023-12-19 15:34:59','2023-12-23 09:28:39','2023-12-23 09:28:39'),(4646,7492,885,40789,104002,12,476,2,47088.00,NULL,'2023-12-19 15:34:59','2023-12-23 09:28:39','2023-12-23 09:28:39'),(4647,7492,886,40789,104002,4,461,1,62714.93,NULL,'2023-12-19 15:45:32','2023-12-27 13:39:52','2023-12-27 13:39:52'),(4648,7492,886,40789,104002,4,44,2,62714.93,NULL,'2023-12-19 15:45:32','2023-12-27 13:39:52','2023-12-27 13:39:52'),(4649,7492,887,40789,104002,4,412,1,11071.11,NULL,'2023-12-19 15:46:48','2023-12-27 13:40:21','2023-12-27 13:40:21'),(4650,7492,887,40789,104002,4,48,2,11071.11,NULL,'2023-12-19 15:46:48','2023-12-27 13:40:21','2023-12-27 13:40:21'),(4651,7492,888,40789,103991,12,359,1,9600.00,NULL,'2023-12-23 09:21:12','2023-12-23 09:21:30','2023-12-23 09:21:30'),(4652,7492,888,40789,103991,12,455,1,182400.00,NULL,'2023-12-23 09:21:12','2023-12-23 09:21:30','2023-12-23 09:21:30'),(4653,7492,888,40789,103991,12,369,2,239088.18,NULL,'2023-12-23 09:21:12','2023-12-23 09:21:30','2023-12-23 09:21:30'),(4654,7492,888,40789,103991,12,92,1,47088.18,NULL,'2023-12-23 09:21:12','2023-12-23 09:21:30','2023-12-23 09:21:30'),(4655,7492,889,40789,103991,12,359,1,9600.00,NULL,'2023-12-23 09:21:30','2023-12-23 09:26:38','2023-12-23 09:26:38'),(4656,7492,889,40789,103991,12,455,1,182400.00,NULL,'2023-12-23 09:21:30','2023-12-23 09:26:38','2023-12-23 09:26:38'),(4657,7492,889,40789,103991,12,369,2,239088.18,NULL,'2023-12-23 09:21:30','2023-12-23 09:26:38','2023-12-23 09:26:38'),(4658,7492,889,40789,103991,12,92,1,47088.18,NULL,'2023-12-23 09:21:30','2023-12-23 09:26:38','2023-12-23 09:26:38'),(4659,7492,890,40789,103991,12,359,1,9600.00,NULL,'2023-12-23 09:26:38','2023-12-23 09:28:58','2023-12-23 09:28:58'),(4660,7492,890,40789,103991,12,455,1,182400.00,NULL,'2023-12-23 09:26:38','2023-12-23 09:28:58','2023-12-23 09:28:58');
INSERT INTO `balance_libro_details` VALUES (4661,7492,890,40789,103991,12,369,2,239088.18,NULL,'2023-12-23 09:26:38','2023-12-23 09:28:58','2023-12-23 09:28:58'),(4662,7492,890,40789,103991,12,92,1,47088.18,NULL,'2023-12-23 09:26:38','2023-12-23 09:28:58','2023-12-23 09:28:58'),(4663,7492,891,40789,103991,12,359,1,9600.00,NULL,'2023-12-23 09:28:58','2023-12-23 09:28:58',NULL),(4664,7492,891,40789,103991,12,455,1,182400.00,NULL,'2023-12-23 09:28:58','2023-12-23 09:28:58',NULL),(4665,7492,891,40789,103991,12,369,2,239088.18,NULL,'2023-12-23 09:28:58','2023-12-23 09:28:58',NULL),(4666,7492,891,40789,103991,12,92,1,47088.18,NULL,'2023-12-23 09:28:58','2023-12-23 09:28:58',NULL),(4667,7492,892,40789,103995,18,359,1,182400.00,NULL,'2023-12-23 09:31:16','2023-12-23 09:31:16',NULL),(4668,7492,892,40789,103995,18,455,2,182400.00,NULL,'2023-12-23 09:31:16','2023-12-23 09:31:16',NULL),(4669,7492,893,40789,104002,3,116,1,484000.00,NULL,'2023-12-25 12:13:37','2023-12-25 12:13:37',NULL),(4670,7492,893,40789,104002,3,46,1,313574.66,NULL,'2023-12-25 12:13:37','2023-12-25 12:13:37',NULL),(4671,7492,893,40789,104002,3,494,1,160000.00,NULL,'2023-12-25 12:13:37','2023-12-25 12:13:37',NULL),(4672,7492,893,40789,104002,3,42,1,55535.54,NULL,'2023-12-25 12:13:37','2023-12-25 12:13:37',NULL),(4673,7492,893,40789,104002,3,68,1,44587.80,NULL,'2023-12-25 12:13:37','2023-12-25 12:13:37',NULL),(4674,7492,893,40789,104002,3,359,2,484000.00,NULL,'2023-12-25 12:13:37','2023-12-25 12:13:37',NULL),(4675,7492,893,40789,104002,3,438,2,160000.00,NULL,'2023-12-25 12:13:37','2023-12-25 12:13:37',NULL),(4676,7492,893,40789,104002,3,57,2,413698.00,NULL,'2023-12-25 12:13:37','2023-12-25 12:13:37',NULL),(4677,7492,894,40789,104002,2,359,1,725850.00,NULL,'2023-12-26 09:57:25','2023-12-26 09:57:25',NULL),(4678,7492,894,40789,104002,2,67,2,125973.98,NULL,'2023-12-26 09:57:25','2023-12-26 09:57:25',NULL),(4679,7492,894,40789,104002,2,482,2,599876.02,NULL,'2023-12-26 09:57:25','2023-12-26 09:57:25',NULL),(4680,7492,895,40789,104002,4,461,1,5553.55,NULL,'2023-12-27 13:39:52','2024-01-04 09:18:14','2024-01-04 09:18:14'),(4681,7492,895,40789,104002,4,44,2,5553.55,NULL,'2023-12-27 13:39:52','2024-01-04 09:18:14','2024-01-04 09:18:14'),(4682,7492,896,40789,104002,4,412,1,31357.47,NULL,'2023-12-27 13:40:21','2023-12-27 13:40:21',NULL),(4683,7492,896,40789,104002,4,48,2,31357.47,NULL,'2023-12-27 13:40:21','2023-12-27 13:40:21',NULL),(4684,7492,897,40789,104002,4,461,1,5553.55,NULL,'2024-01-04 09:18:14','2024-01-04 09:18:14',NULL),(4685,7492,897,40789,104002,4,44,2,5553.55,NULL,'2024-01-04 09:18:14','2024-01-04 09:18:14',NULL),(4686,7492,898,40789,104006,15,68,2,3129.57,NULL,'2024-01-04 09:22:44','2024-01-04 09:22:44',NULL),(4687,7492,898,40789,104006,15,67,1,125973.98,NULL,'2024-01-04 09:22:44','2024-01-04 09:22:44',NULL),(4688,7492,898,40789,104006,15,509,2,19255.98,NULL,'2024-01-04 09:22:44','2024-01-04 09:22:44',NULL),(4689,7492,898,40789,104006,15,74,2,103588.43,NULL,'2024-01-04 09:22:44','2024-01-04 09:22:44',NULL),(4690,7492,899,40789,104002,15,68,2,3129.57,NULL,'2024-01-24 12:30:06','2024-01-24 12:30:06',NULL),(4691,7492,899,40789,104002,15,67,1,125973.98,NULL,'2024-01-24 12:30:06','2024-01-24 12:30:06',NULL),(4692,7492,899,40789,104002,15,74,2,103588.43,NULL,'2024-01-24 12:30:06','2024-01-24 12:30:06',NULL),(4693,7492,899,40789,104002,15,509,2,19255.98,NULL,'2024-01-24 12:30:06','2024-01-24 12:30:06',NULL),(4694,7492,900,40789,104002,23,88,2,463122.33,NULL,'2024-01-24 12:54:43','2024-01-24 12:54:43',NULL),(4695,7492,900,40789,104002,23,92,1,91211.48,NULL,'2024-01-24 12:54:43','2024-01-24 12:54:43',NULL),(4696,7492,900,40789,104002,23,476,1,371910.85,NULL,'2024-01-24 12:54:43','2024-01-24 12:54:43',NULL),(4697,7492,901,40787,102500,2,482,2,13662334.99,NULL,'2024-06-19 12:15:22','2024-09-19 17:22:35','2024-09-19 17:22:35'),(4698,7492,901,40787,102500,2,14,1,16531425.34,NULL,'2024-06-19 12:15:22','2024-09-19 17:22:35','2024-09-19 17:22:35');
INSERT INTO `balance_libro_details` VALUES (4699,7492,901,40787,102500,2,67,2,2869090.35,NULL,'2024-06-19 12:15:22','2024-09-19 17:22:35','2024-09-19 17:22:35'),(4700,7492,902,40787,102500,16,496,1,255462.70,NULL,'2024-06-27 16:38:26','2024-09-19 17:39:19','2024-09-19 17:39:19'),(4701,7492,902,40787,102500,16,485,2,10673.46,NULL,'2024-06-27 16:38:26','2024-09-19 17:39:19','2024-09-19 17:39:19'),(4702,7492,902,40787,102500,16,252,2,33307.58,NULL,'2024-06-27 16:38:26','2024-09-19 17:39:19','2024-09-19 17:39:19'),(4703,7492,902,40787,102500,16,499,2,87694.20,NULL,'2024-06-27 16:38:26','2024-09-19 17:39:19','2024-09-19 17:39:19'),(4704,7492,902,40787,102500,16,327,2,123787.46,NULL,'2024-06-27 16:38:26','2024-09-19 17:39:19','2024-09-19 17:39:19'),(4705,7492,902,40787,102500,16,326,2,5786.21,NULL,'2024-06-27 16:38:26','2024-09-19 17:39:19','2024-09-19 17:39:19'),(4706,7492,902,40787,102500,16,508,2,4587.79,NULL,'2024-06-27 16:38:26','2024-09-19 17:39:19','2024-09-19 17:39:19'),(4707,7492,902,40787,102500,16,251,2,11856.00,NULL,'2024-06-27 16:38:26','2024-09-19 17:39:19','2024-09-19 17:39:19'),(4708,7492,902,40787,102500,16,208,1,22230.00,NULL,'2024-06-27 16:38:26','2024-09-19 17:39:19','2024-09-19 17:39:19'),(4709,7492,903,40787,102500,15,67,1,2869090.35,NULL,'2024-06-27 16:40:51','2024-06-27 16:40:51',NULL),(4710,7492,903,40787,102500,15,68,2,427573.43,NULL,'2024-06-27 16:40:51','2024-06-27 16:40:51',NULL),(4711,7492,903,40787,102500,15,74,2,2433738.51,NULL,'2024-06-27 16:40:51','2024-06-27 16:40:51',NULL),(4712,7492,903,40787,102500,15,484,2,7778.41,NULL,'2024-06-27 16:40:51','2024-06-27 16:40:51',NULL),(4713,7492,904,40787,102501,2,14,1,37100035.75,NULL,'2024-06-27 16:44:35','2024-09-19 17:23:37','2024-09-19 17:23:37'),(4714,7492,904,40787,102501,2,482,2,29309028.25,NULL,'2024-06-27 16:44:35','2024-09-19 17:23:37','2024-09-19 17:23:37'),(4715,7492,904,40787,102501,2,67,2,7791007.50,NULL,'2024-06-27 16:44:35','2024-09-19 17:23:37','2024-09-19 17:23:37'),(4716,7492,905,40787,102501,3,392,1,12466872.41,NULL,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15'),(4717,7492,905,40787,102501,3,491,1,36990.04,NULL,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15'),(4718,7492,905,40787,102501,3,493,1,7305.49,NULL,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15'),(4719,7492,905,40787,102501,3,492,1,2974.38,NULL,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15'),(4720,7492,905,40787,102501,3,490,1,72239.05,NULL,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15'),(4721,7492,905,40787,102501,3,495,1,7438.02,NULL,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15'),(4722,7492,905,40787,102501,3,120,1,11892.54,NULL,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15'),(4723,7492,905,40787,102501,3,489,1,106825.27,NULL,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15'),(4724,7492,905,40787,102501,3,494,1,350000.00,NULL,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15'),(4725,7492,905,40787,102501,3,180,1,211119.50,NULL,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15'),(4726,7492,905,40787,102501,3,198,1,67500.00,NULL,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15'),(4727,7492,905,40787,102501,3,396,1,464055.47,NULL,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15'),(4728,7492,905,40787,102501,3,116,1,146625.00,NULL,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15'),(4729,7492,905,40787,102501,3,68,1,2803598.53,NULL,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15'),(4730,7492,905,40787,102501,3,485,1,19391.99,NULL,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15'),(4731,7492,905,40787,102501,3,486,1,249602.73,NULL,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15'),(4732,7492,905,40787,102501,3,484,1,19985.41,NULL,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15');
INSERT INTO `balance_libro_details` VALUES (4733,7492,905,40787,102501,3,503,1,4817.47,NULL,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15'),(4734,7492,905,40787,102501,3,166,2,17049233.30,NULL,'2024-06-27 17:46:17','2024-10-03 09:20:15','2024-10-03 09:20:15'),(4735,7492,906,40787,102501,16,496,1,452007.38,NULL,'2024-06-27 17:59:48','2024-09-19 17:41:05','2024-09-19 17:41:05'),(4736,7492,906,40787,102501,16,499,2,113463.14,NULL,'2024-06-27 17:59:48','2024-09-19 17:41:05','2024-09-19 17:41:05'),(4737,7492,906,40787,102501,16,326,2,96316.40,NULL,'2024-06-27 17:59:48','2024-09-19 17:41:05','2024-09-19 17:41:05'),(4738,7492,906,40787,102501,16,327,2,67098.57,NULL,'2024-06-27 17:59:48','2024-09-19 17:41:05','2024-09-19 17:41:05'),(4739,7492,906,40787,102501,16,485,2,19391.99,NULL,'2024-06-27 17:59:48','2024-09-19 17:41:05','2024-09-19 17:41:05'),(4740,7492,906,40787,102501,16,252,2,252053.68,NULL,'2024-06-27 17:59:48','2024-09-19 17:41:05','2024-09-19 17:41:05'),(4741,7492,906,40787,102501,16,75,2,249602.73,NULL,'2024-06-27 17:59:48','2024-09-19 17:41:05','2024-09-19 17:41:05'),(4742,7492,906,40787,102501,16,208,1,362491.66,NULL,'2024-06-27 17:59:48','2024-09-19 17:41:05','2024-09-19 17:41:05'),(4743,7492,906,40787,102501,16,251,2,8892.00,NULL,'2024-06-27 17:59:48','2024-09-19 17:41:05','2024-09-19 17:41:05'),(4744,7492,906,40787,102501,16,513,2,7680.53,NULL,'2024-06-27 17:59:48','2024-09-19 17:41:05','2024-09-19 17:41:05'),(4745,7492,907,40787,102501,15,68,2,2803598.53,NULL,'2024-06-27 18:01:26','2024-06-27 18:01:26',NULL),(4746,7492,907,40787,102501,15,67,1,7791007.50,NULL,'2024-06-27 18:01:26','2024-06-27 18:01:26',NULL),(4747,7492,907,40787,102501,15,484,2,19985.41,NULL,'2024-06-27 18:01:26','2024-06-27 18:01:26',NULL),(4748,7492,907,40787,102501,15,74,2,4967423.56,NULL,'2024-06-27 18:01:26','2024-06-27 18:01:26',NULL),(4749,7492,908,40787,102502,2,14,1,13627391.00,NULL,'2024-06-28 14:29:11','2024-06-28 14:29:11',NULL),(4750,7492,908,40787,102502,2,67,2,2861752.11,NULL,'2024-06-28 14:29:11','2024-06-28 14:29:11',NULL),(4751,7492,908,40787,102502,2,482,2,10765638.89,NULL,'2024-06-28 14:29:11','2024-06-28 14:29:11',NULL),(4752,7492,909,40787,102502,3,392,1,9607613.95,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(4753,7492,909,40787,102502,3,491,1,39646.16,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(4754,7492,909,40787,102502,3,493,1,8669.43,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(4755,7492,909,40787,102502,3,492,1,33047.96,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(4756,7492,909,40787,102502,3,490,1,147828.52,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(4757,7492,909,40787,102502,3,512,1,12049.58,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(4758,7492,909,40787,102502,3,495,1,18479.34,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(4759,7492,909,40787,102502,3,120,1,2082.67,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(4760,7492,909,40787,102502,3,489,1,134179.67,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(4761,7492,909,40787,102502,3,180,1,163555.00,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(4762,7492,909,40787,102502,3,198,1,88500.00,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(4763,7492,909,40787,102502,3,396,1,22142.95,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(4764,7492,909,40787,102502,3,116,1,316358.03,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(4765,7492,909,40787,102502,3,68,1,2144251.71,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(4766,7492,909,40787,102502,3,485,1,33612.73,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(4767,7492,909,40787,102502,3,486,1,61162.53,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23');
INSERT INTO `balance_libro_details` VALUES (4768,7492,909,40787,102502,3,135,1,13000.00,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(4769,7492,909,40787,102502,3,484,1,2198.01,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(4770,7492,909,40787,102502,3,503,1,10512.39,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(4771,7492,909,40787,102502,3,166,2,12858890.63,NULL,'2024-06-28 14:42:05','2024-10-03 09:42:23','2024-10-03 09:42:23'),(4772,7492,910,40787,102502,16,496,1,190630.39,NULL,'2024-06-28 14:51:06','2024-06-28 14:51:06',NULL),(4773,7492,910,40787,102502,16,485,2,33612.73,NULL,'2024-06-28 14:51:06','2024-06-28 14:51:06',NULL),(4774,7492,910,40787,102502,16,252,2,61805.58,NULL,'2024-06-28 14:51:06','2024-06-28 14:51:06',NULL),(4775,7492,910,40787,102502,16,499,2,73389.91,NULL,'2024-06-28 14:51:06','2024-06-28 14:51:06',NULL),(4776,7492,910,40787,102502,16,327,2,21822.17,NULL,'2024-06-28 14:51:06','2024-06-28 14:51:06',NULL),(4777,7492,910,40787,102502,16,486,2,61162.53,NULL,'2024-06-28 14:51:06','2024-06-28 14:51:06',NULL),(4778,7492,910,40787,102502,16,251,2,24639.27,NULL,'2024-06-28 14:51:06','2024-06-28 14:51:06',NULL),(4779,7492,910,40787,102502,16,208,1,102396.78,NULL,'2024-06-28 14:51:06','2024-06-28 14:51:06',NULL),(4780,7492,910,40787,102502,16,513,2,1696.98,NULL,'2024-06-28 14:51:06','2024-06-28 14:51:06',NULL),(4781,7492,910,40787,102502,16,326,2,14898.00,NULL,'2024-06-28 14:51:06','2024-06-28 14:51:06',NULL),(4782,7492,911,40787,102502,15,67,1,2861752.11,NULL,'2024-06-28 14:54:52','2024-06-28 14:54:52',NULL),(4783,7492,911,40787,102502,15,68,2,2144251.71,NULL,'2024-06-28 14:54:52','2024-06-28 14:54:52',NULL),(4784,7492,911,40787,102502,15,484,2,2198.01,NULL,'2024-06-28 14:54:52','2024-06-28 14:54:52',NULL),(4785,7492,911,40787,102502,15,74,2,715302.39,NULL,'2024-06-28 14:54:52','2024-06-28 14:54:52',NULL),(4786,7492,912,40787,102503,2,14,1,26574056.24,NULL,'2024-06-28 15:07:09','2024-06-28 15:07:09',NULL),(4787,7492,912,40787,102503,2,482,2,21962029.95,NULL,'2024-06-28 15:07:09','2024-06-28 15:07:09',NULL),(4788,7492,912,40787,102503,2,67,2,4612026.29,NULL,'2024-06-28 15:07:09','2024-06-28 15:07:09',NULL),(4789,7492,913,40787,102503,3,392,1,3845739.70,NULL,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30'),(4790,7492,913,40787,102503,3,491,1,42409.05,NULL,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30'),(4791,7492,913,40787,102503,3,493,1,10570.25,NULL,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30'),(4792,7492,913,40787,102503,3,492,1,3304.96,NULL,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30'),(4793,7492,913,40787,102503,3,490,1,74147.18,NULL,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30'),(4794,7492,913,40787,102503,3,512,1,17876.03,NULL,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30'),(4795,7492,913,40787,102503,3,495,1,12809.92,NULL,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30'),(4796,7492,913,40787,102503,3,120,1,120991.94,NULL,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30'),(4797,7492,913,40787,102503,3,489,1,78850.14,NULL,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30'),(4798,7492,913,40787,102503,3,180,1,114400.00,NULL,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30'),(4799,7492,913,40787,102503,3,198,1,27500.00,NULL,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30'),(4800,7492,913,40787,102503,3,396,1,203800.00,NULL,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30'),(4801,7492,913,40787,102503,3,116,1,249500.00,NULL,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30'),(4802,7492,913,40787,102503,3,68,1,818284.47,NULL,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30'),(4803,7492,913,40787,102503,3,485,1,9624.94,NULL,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30');
INSERT INTO `balance_libro_details` VALUES (4804,7492,913,40787,102503,3,486,1,47975.41,NULL,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30'),(4805,7492,913,40787,102503,3,484,1,8369.20,NULL,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30'),(4806,7492,913,40787,102503,3,503,1,6276.61,NULL,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30'),(4807,7492,913,40787,102503,3,166,2,5692429.80,NULL,'2024-07-01 14:23:00','2024-10-03 10:07:30','2024-10-03 10:07:30'),(4808,7492,914,40787,102503,16,496,1,354576.94,NULL,'2024-07-01 14:28:21','2024-07-01 14:28:21',NULL),(4809,7492,914,40787,102503,16,485,2,9624.94,NULL,'2024-07-01 14:28:21','2024-07-01 14:28:21',NULL),(4810,7492,914,40787,102503,16,252,2,67368.89,NULL,'2024-07-01 14:28:21','2024-07-01 14:28:21',NULL),(4811,7492,914,40787,102503,16,499,2,36388.73,NULL,'2024-07-01 14:28:21','2024-07-01 14:28:21',NULL),(4812,7492,914,40787,102503,16,327,2,241194.38,NULL,'2024-07-01 14:28:21','2024-07-01 14:28:21',NULL),(4813,7492,914,40787,102503,16,208,1,105829.58,NULL,'2024-07-01 14:28:21','2024-07-01 14:28:21',NULL),(4814,7492,914,40787,102503,16,486,2,47975.41,NULL,'2024-07-01 14:28:21','2024-07-01 14:28:21',NULL),(4815,7492,914,40787,102503,16,251,2,45548.92,NULL,'2024-07-01 14:28:21','2024-07-01 14:28:21',NULL),(4816,7492,914,40787,102503,16,276,2,7783.09,NULL,'2024-07-01 14:28:21','2024-07-01 14:28:21',NULL),(4817,7492,914,40787,102503,16,326,2,4522.16,NULL,'2024-07-01 14:28:21','2024-07-01 14:28:21',NULL),(4818,7492,915,40787,102503,15,68,2,818284.47,NULL,'2024-07-01 14:32:15','2024-07-01 14:32:15',NULL),(4819,7492,915,40787,102503,15,67,1,4612026.29,NULL,'2024-07-01 14:32:15','2024-07-01 14:32:15',NULL),(4820,7492,915,40787,102503,15,74,2,3785372.62,NULL,'2024-07-01 14:32:15','2024-07-01 14:32:15',NULL),(4821,7492,915,40787,102503,15,484,2,8369.20,NULL,'2024-07-01 14:32:15','2024-07-01 14:32:15',NULL),(4822,7492,916,40787,102504,2,14,1,22552523.86,NULL,'2024-07-01 14:34:15','2024-07-01 14:34:15',NULL),(4823,7492,916,40787,102504,2,67,2,3914074.39,NULL,'2024-07-01 14:34:15','2024-07-01 14:34:15',NULL),(4824,7492,916,40787,102504,2,482,2,18638449.47,NULL,'2024-07-01 14:34:15','2024-07-01 14:34:15',NULL),(4825,7492,917,40787,102504,3,392,1,6900587.67,NULL,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44'),(4826,7492,917,40787,102504,3,491,1,47066.06,NULL,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44'),(4827,7492,917,40787,102504,3,493,1,13338.85,NULL,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44'),(4828,7492,917,40787,102504,3,492,1,265461.97,NULL,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44'),(4829,7492,917,40787,102504,3,490,1,36771.76,NULL,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44'),(4830,7492,917,40787,102504,3,494,1,780000.00,NULL,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44'),(4831,7492,917,40787,102504,3,193,1,518000.00,NULL,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44'),(4832,7492,917,40787,102504,3,512,1,11735.37,NULL,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44'),(4833,7492,917,40787,102504,3,495,1,12809.92,NULL,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44'),(4834,7492,917,40787,102504,3,120,1,7905.78,NULL,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44'),(4835,7492,917,40787,102504,3,489,1,125289.26,NULL,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44'),(4836,7492,917,40787,102504,3,396,1,266837.90,NULL,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44'),(4837,7492,917,40787,102504,3,116,1,275500.00,NULL,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44'),(4838,7492,917,40787,102504,3,68,1,1689203.87,NULL,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44'),(4839,7492,917,40787,102504,3,485,1,17208.84,NULL,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44');
INSERT INTO `balance_libro_details` VALUES (4840,7492,917,40787,102504,3,484,1,16389.06,NULL,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44'),(4841,7492,917,40787,102504,3,486,1,166138.54,NULL,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44'),(4842,7492,917,40787,102504,3,503,1,33335.06,NULL,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44'),(4843,7492,917,40787,102504,3,166,2,11183579.91,NULL,'2024-07-01 14:45:03','2024-09-19 17:56:44','2024-09-19 17:56:44'),(4844,7492,918,40787,102504,16,496,1,290881.28,NULL,'2024-07-01 14:49:17','2024-07-01 14:49:17',NULL),(4845,7492,918,40787,102504,16,485,2,17208.84,NULL,'2024-07-01 14:49:17','2024-07-01 14:49:17',NULL),(4846,7492,918,40787,102504,16,252,2,247972.24,NULL,'2024-07-01 14:49:17','2024-07-01 14:49:17',NULL),(4847,7492,918,40787,102504,16,499,2,59195.22,NULL,'2024-07-01 14:49:17','2024-07-01 14:49:17',NULL),(4848,7492,918,40787,102504,16,497,1,33495.02,NULL,'2024-07-01 14:49:17','2024-07-01 14:49:17',NULL),(4849,7492,919,40787,102504,16,208,1,102359.63,NULL,'2024-07-01 14:53:02','2024-07-01 14:53:02',NULL),(4850,7492,919,40787,102504,16,500,2,8479.67,NULL,'2024-07-01 14:53:02','2024-07-01 14:53:02',NULL),(4851,7492,919,40787,102504,16,498,1,72258.60,NULL,'2024-07-01 14:53:02','2024-07-01 14:53:02',NULL),(4852,7492,919,40787,102504,16,486,2,166138.56,NULL,'2024-07-01 14:53:02','2024-07-01 14:53:02',NULL),(4853,7492,920,40787,102504,15,68,2,1689203.87,NULL,'2024-07-01 14:54:11','2024-07-01 14:54:11',NULL),(4854,7492,920,40787,102504,15,67,1,3914074.39,NULL,'2024-07-01 14:54:11','2024-07-01 14:54:11',NULL),(4855,7492,920,40787,102504,15,484,2,16389.06,NULL,'2024-07-01 14:54:11','2024-07-01 14:54:11',NULL),(4856,7492,920,40787,102504,15,74,2,2208481.46,NULL,'2024-07-01 14:54:11','2024-07-01 14:54:11',NULL),(4857,7492,921,40787,102505,2,14,1,2698222.56,NULL,'2024-07-01 15:07:19','2024-07-01 15:07:19',NULL),(4858,7492,921,40787,102505,2,67,2,468286.56,NULL,'2024-07-01 15:07:19','2024-07-01 15:07:19',NULL),(4859,7492,921,40787,102505,2,482,2,2229936.00,NULL,'2024-07-01 15:07:19','2024-07-01 15:07:19',NULL),(4860,7492,922,40787,102505,3,392,1,329179.53,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40'),(4861,7492,922,40787,102505,3,493,1,16628.10,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40'),(4862,7492,922,40787,102505,3,492,1,65331.67,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40'),(4863,7492,922,40787,102505,3,490,1,131833.05,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40'),(4864,7492,922,40787,102505,3,363,1,22629.75,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40'),(4865,7492,922,40787,102505,3,193,1,35000.00,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40'),(4866,7492,922,40787,102505,3,512,1,4793.38,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40'),(4867,7492,922,40787,102505,3,495,1,12809.92,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40'),(4868,7492,922,40787,102505,3,120,1,2305.79,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40'),(4869,7492,922,40787,102505,3,489,1,150119.27,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40'),(4870,7492,922,40787,102505,3,180,1,14300.00,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40'),(4871,7492,922,40787,102505,3,396,1,49492.00,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40'),(4872,7492,922,40787,102505,3,116,1,320000.00,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40'),(4873,7492,922,40787,102505,3,68,1,175385.42,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40'),(4874,7492,922,40787,102505,3,485,1,7485.99,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40'),(4875,7492,922,40787,102505,3,486,1,5968.99,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40');
INSERT INTO `balance_libro_details` VALUES (4876,7492,922,40787,102505,3,484,1,7241.18,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40'),(4877,7492,922,40787,102505,3,503,1,10143.09,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40'),(4878,7492,922,40787,102505,3,57,2,1413130.39,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40'),(4879,7492,922,40787,102505,3,491,1,52483.26,NULL,'2024-07-01 15:17:18','2024-10-04 12:18:40','2024-10-04 12:18:40'),(4880,7492,923,40787,102505,16,496,1,44598.72,NULL,'2024-07-01 16:13:55','2024-09-19 18:34:55','2024-09-19 18:34:55'),(4881,7492,923,40787,102505,16,485,2,7485.99,NULL,'2024-07-01 16:13:55','2024-09-19 18:34:55','2024-09-19 18:34:55'),(4882,7492,923,40787,102505,16,252,2,29599.29,NULL,'2024-07-01 16:13:55','2024-09-19 18:34:55','2024-09-19 18:34:55'),(4883,7492,923,40787,102505,16,499,2,11938.91,NULL,'2024-07-01 16:13:55','2024-09-19 18:34:55','2024-09-19 18:34:55'),(4884,7492,923,40787,102505,16,497,1,37920.49,NULL,'2024-07-01 16:13:55','2024-09-19 18:34:55','2024-09-19 18:34:55'),(4885,7492,923,40787,102505,16,208,1,102856.98,NULL,'2024-07-01 16:13:55','2024-09-19 18:34:55','2024-09-19 18:34:55'),(4886,7492,923,40787,102505,16,497,2,33495.02,NULL,'2024-07-01 16:13:55','2024-09-19 18:34:55','2024-09-19 18:34:55'),(4887,7492,923,40787,102505,16,486,2,5968.99,NULL,'2024-07-01 16:13:55','2024-09-19 18:34:55','2024-09-19 18:34:55'),(4888,7492,923,40787,102505,16,251,2,23679.43,NULL,'2024-07-01 16:13:55','2024-09-19 18:34:55','2024-09-19 18:34:55'),(4889,7492,923,40787,102505,16,513,2,949.96,NULL,'2024-07-01 16:13:55','2024-09-19 18:34:55','2024-09-19 18:34:55'),(4890,7492,923,40787,102505,16,498,2,72258.60,NULL,'2024-07-01 16:13:55','2024-09-19 18:34:55','2024-09-19 18:34:55'),(4891,7492,924,40787,102505,15,68,2,175385.42,NULL,'2024-07-01 16:14:54','2024-07-01 16:14:54',NULL),(4892,7492,924,40787,102505,15,67,1,468286.56,NULL,'2024-07-01 16:14:54','2024-07-01 16:14:54',NULL),(4893,7492,924,40787,102505,15,484,2,7241.18,NULL,'2024-07-01 16:14:54','2024-07-01 16:14:54',NULL),(4894,7492,924,40787,102505,15,74,2,285659.96,NULL,'2024-07-01 16:14:54','2024-07-01 16:14:54',NULL),(4895,7492,925,40787,102500,1,110,1,2871125.09,NULL,'2024-09-13 11:37:57','2024-09-13 11:37:57',NULL),(4896,7492,925,40787,102500,1,514,1,1645.56,NULL,'2024-09-13 11:37:57','2024-09-13 11:37:57',NULL),(4897,7492,925,40787,102500,1,515,1,349007.75,NULL,'2024-09-13 11:37:57','2024-09-13 11:37:57',NULL),(4898,7492,925,40787,102500,1,191,1,779428.08,NULL,'2024-09-13 11:37:57','2024-09-13 11:37:57',NULL),(4899,7492,925,40787,102500,1,162,2,122543.36,NULL,'2024-09-13 11:37:57','2024-09-13 11:37:57',NULL),(4900,7492,925,40787,102500,1,516,2,1645.56,NULL,'2024-09-13 11:37:57','2024-09-13 11:37:57',NULL),(4901,7492,925,40787,102500,1,517,2,349007.50,NULL,'2024-09-13 11:37:57','2024-09-13 11:37:57',NULL),(4902,7492,925,40787,102500,1,64,2,49484.56,NULL,'2024-09-13 11:37:57','2024-09-13 11:37:57',NULL),(4903,7492,925,40787,102500,1,518,2,63627.06,NULL,'2024-09-13 11:37:57','2024-09-13 11:37:57',NULL),(4904,7492,925,40787,102500,1,63,2,1135983.67,NULL,'2024-09-13 11:37:57','2024-09-13 11:37:57',NULL),(4905,7492,925,40787,102500,1,62,2,2278914.77,NULL,'2024-09-13 11:37:57','2024-09-13 11:37:57',NULL),(4906,7492,926,40787,102500,3,63,1,1135983.67,NULL,'2024-09-13 11:41:58','2024-10-02 18:02:09','2024-10-02 18:02:09'),(4907,7492,926,40787,102500,3,516,1,1645.56,NULL,'2024-09-13 11:41:58','2024-10-02 18:02:09','2024-10-02 18:02:09'),(4908,7492,926,40787,102500,3,517,1,349007.50,NULL,'2024-09-13 11:41:58','2024-10-02 18:02:09','2024-10-02 18:02:09'),(4909,7492,926,40787,102500,3,166,2,1486636.73,NULL,'2024-09-13 11:41:58','2024-10-02 18:02:09','2024-10-02 18:02:09'),(4910,7492,927,40787,102515,3,64,1,49484.56,NULL,'2024-09-13 12:06:56','2025-10-21 10:04:03','2025-10-21 10:04:03'),(4911,7492,927,40787,102515,3,518,1,63627.06,NULL,'2024-09-13 12:06:56','2025-10-21 10:04:03','2025-10-21 10:04:03');
INSERT INTO `balance_libro_details` VALUES (4912,7492,927,40787,102515,3,520,1,21430.72,NULL,'2024-09-13 12:06:56','2025-10-21 10:04:03'