-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-23923659-1
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2021-03-18 00:34:59','Actividad Generica 1','000001',NULL),(2,NULL,'2021-03-18 00:34:59','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,'2021-05-12 01:11:22','2021-05-12 01:11:22',NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,'2021-05-12 01:13:07','2021-05-12 01:13:07',NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,'2021-05-12 04:13:20','2021-05-12 04:13:20',NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,'2021-05-12 01:13:45','2021-05-12 01:13:45',NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,'2021-05-12 04:14:42','2021-05-12 04:14:42',NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,'2021-05-12 01:15:15','2021-05-12 01:15:15',NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,'2021-05-12 01:16:06','2021-05-12 01:16:06',NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,'2021-12-30 13:24:03','2021-12-30 13:24:03',NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,'2021-12-30 13:25:20','2021-12-30 13:25:20',NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,'2021-12-30 13:25:41','2021-12-30 13:25:41',NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,'2021-12-30 13:25:55','2021-12-30 13:25:55',NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,'2021-12-30 13:26:11','2021-12-30 13:26:11',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,'2021-12-30 13:26:26','2021-12-30 13:26:26',NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL),('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,'cuit 20076578320','Miguel2020','',1,40734,'2021-05-05'),(12,'cuit 20076578320','Miguel2020','',1,40734,'2021-05-05');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=124 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(8,4,2,13,NULL,0.00,'2021-05-03 21:38:20','2021-05-03 21:38:20',NULL),(9,4,2,96,NULL,0.00,'2021-05-03 21:38:20','2021-05-03 21:38:20',NULL),(10,4,2,67,NULL,0.00,'2021-05-03 21:38:20','2021-05-03 21:38:20',NULL),(11,5,15,67,NULL,0.00,'2021-05-03 21:50:35','2021-05-03 21:50:35',NULL),(12,5,15,68,NULL,0.00,'2021-05-03 21:50:35','2021-05-03 21:50:35',NULL),(13,5,15,25,NULL,0.00,'2021-05-03 21:50:35','2021-05-03 21:50:35',NULL),(14,5,15,74,NULL,0.00,'2021-05-03 21:50:35','2021-05-03 21:50:35',NULL),(23,7,3,396,NULL,0.00,'2021-05-03 22:51:41','2021-05-03 22:51:41',NULL),(24,7,3,437,NULL,0.00,'2021-05-03 22:51:41','2021-05-03 22:51:41',NULL),(25,7,3,157,NULL,0.00,'2021-05-03 22:51:41','2021-05-03 22:51:41',NULL),(26,7,3,20,NULL,0.00,'2021-05-03 22:51:41','2021-05-03 22:51:41',NULL),(27,7,3,63,NULL,0.00,'2021-05-03 22:51:41','2021-05-03 22:51:41',NULL),(28,7,3,74,NULL,0.00,'2021-05-03 22:51:41','2021-05-03 22:51:41',NULL),(29,7,3,57,NULL,0.00,'2021-05-03 22:51:41','2021-05-03 22:51:41',NULL),(30,7,3,13,NULL,0.00,'2021-05-03 22:51:41','2021-05-03 22:51:41',NULL),(31,7,3,8,NULL,0.00,'2021-05-03 22:51:41','2021-05-03 22:51:41',NULL),(32,7,3,8,NULL,0.00,'2021-05-03 22:51:41','2021-05-03 22:51:41',NULL),(33,8,16,252,NULL,0.00,'2021-05-04 01:08:39','2021-05-04 01:08:39',NULL),(34,8,16,21,NULL,0.00,'2021-05-04 01:08:39','2021-05-04 01:08:39',NULL),(35,8,16,21,NULL,0.00,'2021-05-04 01:08:39','2021-05-04 01:08:39',NULL),(36,8,16,140,NULL,0.00,'2021-05-04 01:08:39','2021-05-04 01:08:39',NULL),(37,8,16,327,NULL,0.00,'2021-05-04 01:08:39','2021-05-04 01:08:39',NULL),(55,12,3,123,NULL,0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(56,12,3,508,NULL,0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(57,12,3,545,NULL,0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(58,12,3,546,NULL,0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(59,12,3,511,NULL,0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(60,12,3,192,NULL,0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(61,12,3,507,NULL,0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(62,12,3,506,NULL,0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(63,12,3,129,NULL,0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(64,12,3,126,NULL,0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(65,12,3,509,NULL,0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(66,12,3,535,NULL,0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(67,12,3,538,NULL,0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(68,12,3,198,NULL,0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(69,12,3,505,NULL,0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(70,12,3,513,NULL,0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(71,12,3,68,NULL,0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(72,12,3,363,NULL,0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(73,12,3,57,NULL,0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(74,13,16,156,NULL,0.00,'2021-12-26 19:49:16','2021-12-26 19:49:16',NULL),(75,13,16,21,NULL,0.00,'2021-12-26 19:49:16','2021-12-26 19:49:16',NULL),(76,13,16,512,NULL,0.00,'2021-12-26 19:49:16','2021-12-26 19:49:16',NULL),(77,13,16,351,NULL,0.00,'2021-12-26 19:49:16','2021-12-26 19:49:16',NULL),(78,13,16,156,NULL,0.00,'2021-12-26 19:49:16','2021-12-26 19:49:16',NULL),(81,15,5,13,NULL,0.00,'2021-12-26 22:26:34','2021-12-26 22:26:34',NULL),(82,15,5,492,NULL,0.00,'2021-12-26 22:26:34','2021-12-26 22:26:34',NULL),(83,15,5,351,NULL,0.00,'2021-12-26 22:26:34','2021-12-26 22:26:34',NULL),(84,15,5,512,NULL,0.00,'2021-12-26 22:26:34','2021-12-26 22:26:34',NULL),(85,15,5,62,NULL,0.00,'2021-12-26 22:26:34','2021-12-26 22:26:34',NULL),(86,15,5,396,NULL,0.00,'2021-12-26 22:26:34','2021-12-26 22:26:34',NULL),(87,15,5,140,NULL,0.00,'2021-12-26 22:26:34','2021-12-26 22:26:34',NULL);
INSERT INTO `balance_asiento_modelo_detail` VALUES (88,15,5,57,NULL,0.00,'2021-12-26 22:26:34','2021-12-26 22:26:34',NULL),(89,15,5,521,NULL,0.00,'2021-12-26 22:26:34','2021-12-26 22:26:34',NULL),(92,17,1,110,NULL,0.00,'2021-12-27 00:25:13','2021-12-27 00:25:13',NULL),(93,17,1,191,NULL,0.00,'2021-12-27 00:25:13','2021-12-27 00:25:13',NULL),(94,17,1,560,NULL,0.00,'2021-12-27 00:25:13','2021-12-27 00:25:13',NULL),(95,17,1,62,NULL,0.00,'2021-12-27 00:25:13','2021-12-27 00:25:13',NULL),(96,17,1,554,NULL,0.00,'2021-12-27 00:25:13','2021-12-27 00:25:13',NULL),(97,17,1,555,NULL,0.00,'2021-12-27 00:25:13','2021-12-27 00:25:13',NULL),(98,17,1,489,NULL,0.00,'2021-12-27 00:25:13','2021-12-27 00:25:13',NULL),(99,17,1,559,NULL,0.00,'2021-12-27 00:25:13','2021-12-27 00:25:13',NULL),(100,17,1,64,NULL,0.00,'2021-12-27 00:25:13','2021-12-27 00:25:13',NULL),(112,19,1,62,NULL,0.00,'2021-12-27 10:03:49','2021-12-27 10:03:49',NULL),(113,19,1,554,NULL,0.00,'2021-12-27 10:03:49','2021-12-27 10:03:49',NULL),(114,19,1,555,NULL,0.00,'2021-12-27 10:03:49','2021-12-27 10:03:49',NULL),(115,19,1,556,NULL,0.00,'2021-12-27 10:03:49','2021-12-27 10:03:49',NULL),(116,19,1,557,NULL,0.00,'2021-12-27 10:03:49','2021-12-27 10:03:49',NULL),(117,19,1,558,NULL,0.00,'2021-12-27 10:03:49','2021-12-27 10:03:49',NULL),(118,19,1,489,NULL,0.00,'2021-12-27 10:03:49','2021-12-27 10:03:49',NULL),(119,19,1,559,NULL,0.00,'2021-12-27 10:03:49','2021-12-27 10:03:49',NULL),(120,19,1,64,NULL,0.00,'2021-12-27 10:03:49','2021-12-27 10:03:49',NULL),(121,19,1,498,NULL,0.00,'2021-12-27 10:03:49','2021-12-27 10:03:49',NULL),(122,19,1,359,NULL,0.00,'2021-12-27 10:03:49','2021-12-27 10:03:49',NULL),(123,19,1,57,NULL,0.00,'2021-12-27 10:03:49','2021-12-27 10:03:49',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,3150,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2021-12-27 09:48:48','2021-12-27 09:48:48'),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,3150,2,2,'Ventas mensuales',0.00,'2021-05-03 21:35:26','2021-05-03 21:37:07','2021-05-03 21:37:07'),(4,3150,2,2,'Ventas mensuales',0.00,'2021-05-03 21:38:20','2021-05-03 21:38:20',NULL),(5,3150,15,2,'Liquidación Iva Mensual',0.00,'2021-05-03 21:50:35','2021-05-03 21:50:35',NULL),(6,3150,3,2,'Ingresos y Egresos Bancarios',0.00,'2021-05-03 22:35:48','2021-05-03 22:41:19','2021-05-03 22:41:19'),(7,3150,3,2,'Ingresos y Egresos Bancarios',0.00,'2021-05-03 22:51:41','2021-05-03 22:51:41',NULL),(8,3150,16,2,'Ingresos Brutos Mensuales',0.00,'2021-05-04 01:08:39','2021-05-04 01:08:39',NULL),(9,3150,3,2,'Compras y Gastos mensuales',0.00,'2021-05-19 17:49:27','2021-05-19 18:29:29','2021-05-19 18:29:29'),(10,3150,3,2,'COMPRAS MENSUALES',0.00,'2021-12-26 17:51:11','2021-12-26 17:54:17','2021-12-26 17:54:17'),(11,3150,3,2,'COMPRAS MENSUALES',0.00,'2021-12-26 18:05:33','2021-12-26 18:30:45','2021-12-26 18:30:45'),(12,3150,3,2,'COMPRAS MENSUALES',0.00,'2021-12-26 18:08:39','2021-12-26 18:08:39',NULL),(13,3150,16,2,'Devengamiento',0.00,'2021-12-26 19:49:16','2021-12-26 19:49:16',NULL),(14,3150,10,2,'PLANES',0.00,'2021-12-26 22:11:35','2021-12-26 22:17:26','2021-12-26 22:17:26'),(15,3150,5,2,NULL,0.00,'2021-12-26 22:26:34','2021-12-26 22:26:34',NULL),(16,3150,10,2,NULL,0.00,'2021-12-26 23:05:21','2021-12-26 23:10:33','2021-12-26 23:10:33'),(17,3150,1,2,'Devengamiento',0.00,'2021-12-27 00:25:13','2021-12-27 00:25:13',NULL),(18,3150,1,2,'PAGOS',0.00,'2021-12-27 09:56:13','2021-12-27 10:00:17','2021-12-27 10:00:17'),(19,3150,1,2,'PAGOS',0.00,'2021-12-27 10:03:49','2021-12-27 10:03:49',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3014 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,3150,40719,1518,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',1000.00,NULL,NULL,1,'2021-03-18 14:33:03','2021-03-18 14:33:03',NULL),(2,3150,40720,1537,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',3779309.80,'Asiento Apertura',NULL,1,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(3,3150,40720,1537,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',3779309.80,'Asiento Apertura',NULL,1,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(4,3150,40720,1537,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',1084894.12,'Ventas mensuales',NULL,1,'2021-05-03 21:38:55','2021-05-03 21:38:55',NULL),(5,3150,40720,1538,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',1197991.04,'Ventas mensuales',NULL,1,'2021-05-03 21:39:37','2021-05-03 21:39:37',NULL),(6,3150,40720,1539,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',1152271.88,'Ventas mensuales',NULL,1,'2021-05-03 21:40:14','2021-05-03 21:40:14',NULL),(7,3150,40720,1540,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',1360823.73,'Ventas mensuales',NULL,1,'2021-05-03 21:40:52','2021-05-03 21:40:52',NULL),(8,3150,40720,1541,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',1341856.93,'Ventas mensuales',NULL,1,'2021-05-03 21:41:30','2021-05-03 21:41:30',NULL),(9,3150,40720,1545,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',1425489.94,'Ventas mensuales',NULL,1,'2021-05-03 21:42:17','2021-05-03 21:42:17',NULL),(10,3150,40720,1546,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',1309581.27,'Ventas mensuales',NULL,1,'2021-05-03 21:42:46','2021-05-03 21:42:46',NULL),(11,3150,40720,1547,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',1397942.85,'Ventas mensuales',NULL,1,'2021-05-03 21:43:30','2021-05-03 21:43:30',NULL),(12,3150,40720,1548,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',1542747.81,'Ventas mensuales',NULL,1,'2021-05-03 21:44:06','2021-05-03 21:44:06',NULL),(13,3150,40720,1549,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',1400657.91,'Ventas mensuales',NULL,1,'2021-05-03 21:44:41','2021-05-03 21:44:41',NULL),(14,3150,40720,1550,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',1667013.02,'Ventas mensuales',NULL,1,'2021-05-03 21:45:13','2021-05-03 21:45:13',NULL),(15,3150,40720,1551,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',1733231.20,'Ventas mensuales',NULL,1,'2021-05-03 21:45:51','2021-05-03 21:45:51',NULL),(16,3150,40720,1537,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',188287.41,'Liquidación Iva Mensual',NULL,1,'2021-05-03 21:51:44','2021-05-03 21:51:44',NULL),(17,3150,40720,1538,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',207915.80,'Liquidación Iva Mensual',NULL,1,'2021-05-03 21:52:16','2021-05-03 21:52:16',NULL),(18,3150,40720,1539,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',199981.07,'Liquidación Iva Mensual',NULL,1,'2021-05-03 21:53:06','2021-05-03 21:53:06',NULL),(19,3150,40720,1540,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',236176.02,'Liquidación Iva Mensual',NULL,1,'2021-05-03 21:54:01','2021-05-03 21:54:01',NULL),(20,3150,40720,1540,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',232884.26,'Liquidación Iva Mensual',NULL,1,'2021-05-03 21:55:36','2021-05-04 01:26:01','2021-05-04 01:26:01'),(21,3150,40720,1545,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',247399.08,'Liquidación Iva Mensual',NULL,1,'2021-05-03 21:56:26','2021-05-03 21:56:26',NULL),(22,3150,40720,1546,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',227282.70,'Liquidación Iva Mensual',NULL,1,'2021-05-03 21:57:01','2021-05-03 21:57:01',NULL);
INSERT INTO `balance_libro` VALUES (23,3150,40720,1547,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',242618.18,'Liquidación Iva Mensual',NULL,1,'2021-05-03 21:57:47','2021-05-03 21:57:47',NULL),(24,3150,40720,1548,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',267749.62,'Liquidación Iva Mensual',NULL,1,'2021-05-03 21:58:36','2021-05-03 21:58:36',NULL),(25,3150,40720,1549,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',243089.39,'Liquidación Iva Mensual',NULL,1,'2021-05-03 22:23:26','2021-05-03 22:23:26',NULL),(26,3150,40720,1550,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',289316.31,'Liquidación Iva Mensual',NULL,1,'2021-05-03 22:24:09','2021-05-03 22:24:09',NULL),(27,3150,40720,1551,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',300808.72,'Liquidación Iva Mensual',NULL,1,'2021-05-03 22:24:44','2021-05-03 22:24:44',NULL),(28,3150,40720,1537,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',298174.19,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-03 22:54:21','2021-05-19 22:32:54','2021-05-19 22:32:54'),(29,3150,40720,1538,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',390028.35,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-03 23:00:18','2021-05-19 22:32:18','2021-05-19 22:32:18'),(30,3150,40720,1539,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',351434.00,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-03 23:05:33','2021-05-19 22:23:21','2021-05-19 22:23:21'),(31,3150,40720,1540,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',485839.26,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-03 23:19:22','2021-05-19 22:22:42','2021-05-19 22:22:42'),(32,3150,40720,2,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',359411.00,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-03 23:26:49','2021-05-04 01:25:21','2021-05-04 01:25:21'),(35,3150,40720,1545,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',341834.64,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-03 23:37:00','2021-05-19 22:22:02','2021-05-19 22:22:02'),(36,3150,40720,1546,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',385211.35,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-03 23:46:01','2021-05-19 22:21:12','2021-05-19 22:21:12'),(37,3150,40720,1547,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',412999.00,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-03 23:50:12','2021-05-19 22:20:33','2021-05-19 22:20:33'),(38,3150,40720,1548,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',426599.00,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-03 23:52:15','2021-05-19 22:19:59','2021-05-19 22:19:59'),(39,3150,40720,1549,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',465270.00,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-03 23:57:10','2021-05-19 22:19:25','2021-05-19 22:19:25'),(40,3150,40720,1550,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',398751.04,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-04 00:00:59','2021-05-19 22:18:44','2021-05-19 22:18:44'),(41,3150,40720,1551,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',617012.83,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-04 00:03:13','2021-05-19 22:18:06','2021-05-19 22:18:06'),(42,3150,40720,1541,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',311990.76,'Imp. a las Ganancias',NULL,1,'2021-05-04 00:08:04','2021-05-04 00:08:04',NULL),(43,3150,40720,1541,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',5219.13,'Participaciones Societarias',NULL,1,'2021-05-04 00:12:02','2021-05-04 00:12:02',NULL),(44,3150,40720,1537,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',27161.36,'Ingresos Brutos Mensuales',NULL,1,'2021-05-04 01:09:34','2021-05-04 01:15:29','2021-05-04 01:15:29');
INSERT INTO `balance_libro` VALUES (45,3150,40720,1538,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',29866.36,'Ingresos Brutos Mensuales',NULL,1,'2021-05-04 01:10:12','2021-05-04 01:16:05','2021-05-04 01:16:05'),(46,3150,40720,2,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',28870.75,'Ingresos Brutos Mensuales',NULL,1,'2021-05-04 01:10:54','2021-05-04 01:16:44','2021-05-04 01:16:44'),(47,3150,40720,2,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',34285.56,'Ingresos Brutos Mensuales',NULL,1,'2021-05-04 01:11:31','2021-05-04 01:17:40','2021-05-04 01:17:40'),(48,3150,40720,2,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',33559.05,'Ingresos Brutos Mensuales',NULL,1,'2021-05-04 01:12:12','2021-05-04 01:18:22','2021-05-04 01:18:22'),(49,3150,40720,1537,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',27161.36,'Ingresos Brutos Mensuales',NULL,1,'2021-05-04 01:15:29','2021-05-04 01:15:29',NULL),(50,3150,40720,1538,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',29866.36,'Ingresos Brutos Mensuales',NULL,1,'2021-05-04 01:16:05','2021-05-04 01:16:05',NULL),(51,3150,40720,1539,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',28870.75,'Ingresos Brutos Mensuales',NULL,1,'2021-05-04 01:16:44','2021-05-04 01:16:44',NULL),(52,3150,40720,1540,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',34285.56,'Ingresos Brutos Mensuales',NULL,1,'2021-05-04 01:17:40','2021-05-04 01:17:40',NULL),(53,3150,40720,1541,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',33559.05,'Ingresos Brutos Mensuales',NULL,1,'2021-05-04 01:18:22','2021-05-04 01:18:22',NULL),(54,3150,40720,1545,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',35583.74,'Ingresos Brutos Mensuales',NULL,1,'2021-05-04 01:19:28','2021-05-04 01:19:28',NULL),(55,3150,40720,1546,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',32690.59,'Ingresos Brutos Mensuales',NULL,1,'2021-05-04 01:20:34','2021-05-04 01:20:34',NULL),(56,3150,40720,1547,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',34970.14,'Ingresos Brutos Mensuales',NULL,1,'2021-05-04 01:21:31','2021-05-04 01:21:31',NULL),(57,3150,40720,1548,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',38604.71,'Ingresos Brutos Mensuales',NULL,1,'2021-05-04 01:22:22','2021-05-04 01:22:22',NULL),(58,3150,40720,1549,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',35118.73,'Ingresos Brutos Mensuales',NULL,1,'2021-05-04 01:23:14','2021-05-04 01:23:14',NULL),(59,3150,40720,1550,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',41607.21,'Ingresos Brutos Mensuales',NULL,1,'2021-05-04 01:23:58','2021-05-19 23:04:57','2021-05-19 23:04:57'),(60,3150,40720,1551,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',43456.50,'Ingresos Brutos Mensuales',NULL,1,'2021-05-04 01:24:49','2021-05-19 23:04:32','2021-05-19 23:04:32'),(61,3150,40720,2,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',359411.00,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-04 01:25:21','2021-05-19 22:24:17','2021-05-19 22:24:17'),(62,3150,40720,1540,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',232884.26,'Liquidación Iva Mensual',NULL,1,'2021-05-04 01:26:01','2021-05-04 01:26:01',NULL),(63,3150,40734,18552,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',40240.32,'Pago IVA',NULL,1,'2021-05-05 23:25:10','2021-05-05 23:28:11','2021-05-05 23:28:11'),(64,3150,40734,18552,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',40091.97,'Pago IVA',NULL,1,'2021-05-05 23:28:11','2021-05-05 23:28:27','2021-05-05 23:28:27'),(65,3150,40734,18552,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',40091.97,'Pago IVA',NULL,1,'2021-05-05 23:28:27','2021-05-06 00:25:38','2021-05-06 00:25:38');
INSERT INTO `balance_libro` VALUES (66,3150,40734,18552,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',148.35,'Devengamiento',NULL,1,'2021-05-05 23:31:23','2021-05-06 13:13:27','2021-05-06 13:13:27'),(67,3150,40734,18552,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',6280.15,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-05 23:48:11','2021-05-05 23:52:04','2021-05-05 23:52:04'),(68,3150,40734,18552,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',96425.74,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-05 23:52:04','2021-05-05 23:52:04',NULL),(69,3150,40734,18552,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',8498.89,'Pago',NULL,1,'2021-05-05 23:55:44','2021-05-06 00:26:35','2021-05-06 00:26:35'),(70,3150,40734,18552,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',3955.82,'Pago',NULL,1,'2021-05-05 23:58:04','2021-05-06 00:26:25','2021-05-06 00:26:25'),(71,3150,40734,18552,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',12251.61,'Ingresos Brutos',NULL,1,'2021-05-06 00:01:52','2021-05-06 00:01:52',NULL),(72,3150,40734,18552,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',139477.26,'Pago',NULL,1,'2021-05-06 00:11:52','2021-05-06 00:15:55','2021-05-06 00:15:55'),(73,3150,40734,18552,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',139477.26,'Pago',NULL,1,'2021-05-06 00:15:55','2021-05-06 00:26:16','2021-05-06 00:26:16'),(74,3150,40734,18552,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',69169.20,'Devengamiento',NULL,1,'2021-05-06 00:17:42','2021-05-10 12:01:33','2021-05-10 12:01:33'),(75,3150,40734,18552,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',19500.00,'Pagos',NULL,1,'2021-05-06 00:20:03','2021-05-06 13:01:29','2021-05-06 13:01:29'),(76,3150,40734,18552,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',1467.68,'Pagos',NULL,1,'2021-05-06 00:21:34','2021-05-06 00:21:34',NULL),(77,3150,40734,18552,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',13844.04,'pagos',NULL,1,'2021-05-06 00:22:48','2021-05-06 00:25:49','2021-05-06 00:25:49'),(78,3150,40734,18552,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',4200.00,'Honorarios',NULL,1,'2021-05-06 00:24:52','2021-05-06 00:24:52',NULL),(79,3150,40734,18552,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',40091.97,'pagos',NULL,1,'2021-05-06 00:25:38','2021-05-06 00:26:07','2021-05-06 00:26:07'),(80,3150,40734,18552,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',13844.04,'Pagos',NULL,1,'2021-05-06 00:25:49','2021-05-10 17:24:21','2021-05-10 17:24:21'),(81,3150,40734,18552,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',40091.97,'Pagos',NULL,1,'2021-05-06 00:26:07','2021-05-06 13:20:37','2021-05-06 13:20:37'),(82,3150,40734,18552,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',139477.26,'Pagos',NULL,1,'2021-05-06 00:26:16','2021-05-06 18:11:37','2021-05-06 18:11:37'),(83,3150,40734,18552,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',3955.82,'Pagos',NULL,1,'2021-05-06 00:26:25','2021-05-06 18:40:19','2021-05-06 18:40:19'),(84,3150,40734,18552,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',8498.89,'Pagos',NULL,1,'2021-05-06 00:26:35','2021-05-06 18:39:58','2021-05-06 18:39:58'),(85,3150,40734,18553,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',91043.17,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-06 12:54:02','2021-05-06 12:54:02',NULL),(86,3150,40734,18553,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',69169.20,'Devengamiento',NULL,1,'2021-05-06 12:56:07','2021-05-06 12:56:07',NULL),(87,3150,40734,18553,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',9169.20,'pagos',NULL,1,'2021-05-06 12:57:09','2021-05-06 13:03:48','2021-05-06 13:03:48');
INSERT INTO `balance_libro` VALUES (88,3150,40734,18553,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',9169.20,'Pagos',NULL,1,'2021-05-06 13:03:48','2021-05-10 17:30:51','2021-05-10 17:30:51'),(89,3150,40734,18553,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',4200.00,'Honorarios',NULL,1,'2021-05-06 13:06:48','2021-05-25 00:00:14','2021-05-25 00:00:14'),(90,3150,40734,18552,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',40091.97,'Pago IVA',NULL,1,'2021-05-06 13:20:37','2021-05-07 13:43:41','2021-05-07 13:43:41'),(91,3150,40734,18552,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',139477.26,'Pagos',NULL,1,'2021-05-06 18:11:37','2021-05-06 18:16:01','2021-05-06 18:16:01'),(92,3150,40734,18552,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',139477.26,'Pagos',NULL,1,'2021-05-06 18:16:01','2021-05-06 18:16:01',NULL),(93,3150,40734,18554,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',75686.65,'Devengamiento',NULL,1,'2021-05-06 18:24:40','2021-05-06 18:24:40',NULL),(94,3150,40734,18554,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',75686.65,'Pago IVA',NULL,1,'2021-05-06 18:27:28','2021-05-06 18:27:28',NULL),(95,3150,40734,18554,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',431298.80,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-06 18:35:21','2021-05-07 14:11:23','2021-05-07 14:11:23'),(96,3150,40734,18554,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',431298.80,NULL,NULL,1,'2021-05-06 18:37:08','2021-05-06 18:37:08',NULL),(97,3150,40734,18554,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',8498.89,'Pagos Ganancias',NULL,1,'2021-05-06 18:39:08','2021-05-06 18:39:08',NULL),(98,3150,40734,18552,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',8498.89,'Pagos Ganancias',NULL,1,'2021-05-06 18:39:58','2021-05-06 18:39:58',NULL),(99,3150,40734,18552,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',3955.82,'Pagos Ganancias',NULL,1,'2021-05-06 18:40:19','2021-05-06 18:40:19',NULL),(100,3150,40734,18554,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',8625.98,'Devengamiento',NULL,1,'2021-05-06 18:46:14','2021-05-06 19:00:02','2021-05-06 19:00:02'),(101,3150,40734,18554,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',25116.70,'Compras',NULL,1,'2021-05-06 18:51:13','2021-05-06 18:51:13',NULL),(102,3150,40734,18554,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',3.96,'Pagos Ganancias',NULL,1,'2021-05-06 18:52:57','2021-05-06 18:52:57',NULL),(103,3150,40734,18554,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',9169.20,'Pagos',NULL,1,'2021-05-06 18:54:18','2021-05-10 17:30:14','2021-05-10 17:30:14'),(104,3150,40734,18552,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',40240.32,'Pago IVA',NULL,1,'2021-05-07 13:43:41','2021-05-10 12:10:00','2021-05-10 12:10:00'),(105,3150,40734,18552,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',69169.20,'Devengamiento',NULL,1,'2021-05-07 13:46:52','2021-05-07 13:46:52',NULL),(106,3150,40734,18552,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',19500.00,'Socios',NULL,1,'2021-05-07 13:48:52','2021-05-07 13:48:52',NULL),(107,3150,40734,18552,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',90000.00,'Pagos',NULL,1,'2021-05-07 13:51:42','2021-05-11 22:11:48','2021-05-11 22:11:48'),(108,3150,40734,18553,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',69169.20,'Devengamiento',NULL,1,'2021-05-07 13:53:11','2021-05-10 12:31:13','2021-05-10 12:31:13'),(109,3150,40734,18553,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',55000.00,'Pagos',NULL,1,'2021-05-07 13:54:15','2021-05-10 12:29:54','2021-05-10 12:29:54');
INSERT INTO `balance_libro` VALUES (110,3150,40734,18553,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',60000.00,'Pagos',NULL,1,'2021-05-07 13:55:22','2021-05-07 13:55:22',NULL),(111,3150,40734,18554,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',69169.20,'Devengamiento',NULL,1,'2021-05-07 14:01:48','2021-05-07 14:01:48',NULL),(112,3150,40734,18554,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',60000.00,'Socios',NULL,1,'2021-05-07 14:02:54','2021-05-07 14:02:54',NULL),(113,3150,40734,18554,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',431298.80,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-07 14:11:23','2021-05-10 18:59:35','2021-05-10 18:59:35'),(114,3150,40734,18554,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',8625.98,'Ingresos Brutos',NULL,1,'2021-05-07 14:22:31','2021-05-10 12:27:04','2021-05-10 12:27:04'),(115,3150,40734,18554,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',5500.00,'Honorarios',NULL,1,'2021-05-07 14:25:21','2021-05-07 14:25:21',NULL),(116,3150,40734,18554,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',60000.00,'Pagos',NULL,1,'2021-05-07 14:26:34','2021-05-07 14:26:34',NULL),(117,3150,40734,18554,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',75841.60,'Devengamiento',NULL,1,'2021-05-07 15:04:18','2021-05-07 15:16:11','2021-05-07 15:16:11'),(118,3150,40734,18554,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',51233.24,'Iva',NULL,1,'2021-05-07 15:08:48','2021-05-07 15:16:01','2021-05-07 15:16:01'),(119,3150,40734,18554,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',107241.33,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-07 15:11:06','2021-05-07 15:15:51','2021-05-07 15:15:51'),(120,3150,40734,18554,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',68539.20,'Devengamiento',NULL,1,'2021-05-07 15:12:43','2021-05-07 15:15:41','2021-05-07 15:15:41'),(121,3150,40734,18554,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',70000.00,'Socios',NULL,1,'2021-05-07 15:13:43','2021-05-07 15:15:29','2021-05-07 15:15:29'),(122,3150,40734,18555,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',70000.00,'Socios',NULL,1,'2021-05-07 15:15:29','2021-05-07 15:15:29',NULL),(123,3150,40734,18555,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',68539.20,'Devengamiento',NULL,1,'2021-05-07 15:15:41','2021-05-07 15:15:41',NULL),(124,3150,40734,18554,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',107241.33,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-07 15:15:51','2021-05-10 12:04:14','2021-05-10 12:04:14'),(125,3150,40734,18554,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',51233.24,'Iva',NULL,1,'2021-05-07 15:16:01','2021-05-10 12:33:18','2021-05-10 12:33:18'),(126,3150,40734,18554,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',75841.60,'Devengamiento',NULL,1,'2021-05-07 15:16:11','2021-05-10 12:11:35','2021-05-10 12:11:35'),(127,3150,40734,18555,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',9169.20,'Pagos',NULL,1,'2021-05-07 15:17:13','2021-05-10 17:27:44','2021-05-10 17:27:44'),(128,3150,40734,18555,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',20273.85,'Pago IIBB',NULL,1,'2021-05-07 15:18:34','2021-05-11 23:28:21','2021-05-11 23:28:21'),(129,3150,40734,18555,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',5500.00,'Honorarios',NULL,1,'2021-05-07 15:19:19','2021-05-07 15:19:19',NULL),(130,3150,40734,18556,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',51277.57,'Devengamiento',NULL,1,'2021-05-07 20:01:50','2021-05-10 14:42:58','2021-05-10 14:42:58');
INSERT INTO `balance_libro` VALUES (131,3150,40734,18556,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',84112.19,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-07 20:03:57','2021-05-07 20:03:57',NULL),(132,3150,40734,18556,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',53400.00,'Socios',NULL,1,'2021-05-07 20:05:17','2021-05-07 20:05:17',NULL),(133,3150,40734,18556,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',51277.57,'Iva',NULL,1,'2021-05-07 20:08:32','2021-05-10 15:55:21','2021-05-10 15:55:21'),(134,3150,40734,18556,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',69169.20,'Devengamiento',NULL,1,'2021-05-08 19:06:02','2021-05-11 12:51:16','2021-05-11 12:51:16'),(135,3150,40734,18556,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',93487.79,'Pago IIBB',NULL,1,'2021-05-08 19:07:38','2021-05-10 12:25:48','2021-05-10 12:25:48'),(136,3150,40734,18556,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',8539.20,'Pagos',NULL,1,'2021-05-08 19:08:47','2021-05-08 19:08:47',NULL),(137,3150,40734,18556,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',5770.00,'Honorarios',NULL,1,'2021-05-08 22:25:11','2021-05-08 22:25:11',NULL),(138,3150,40734,18556,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',51438.22,'Devengamiento',NULL,1,'2021-05-08 22:29:24','2021-05-10 12:14:22','2021-05-10 12:14:22'),(139,3150,40734,18557,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',166862.04,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-08 22:31:46','2021-05-08 22:31:46',NULL),(140,3150,40734,18557,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',103753.00,'Pagos',NULL,1,'2021-05-08 22:34:02','2021-05-10 17:11:48','2021-05-10 17:11:48'),(141,3150,40734,18557,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',32694.98,'Pagos',NULL,1,'2021-05-08 22:41:26','2021-05-08 22:41:26',NULL),(142,3150,40734,18557,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',51438.22,'Iva',NULL,1,'2021-05-08 22:43:39','2021-05-10 13:36:02','2021-05-10 13:36:02'),(143,3150,40734,18557,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',117500.00,'Socios',NULL,1,'2021-05-08 22:44:48','2021-05-08 22:44:48',NULL),(144,3150,40734,18558,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',51601.93,'Devengamiento',NULL,1,'2021-05-08 22:51:48','2021-05-10 16:09:19','2021-05-10 16:09:19'),(145,3150,40734,18558,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',44776.15,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-08 22:53:53','2021-05-08 22:53:53',NULL),(146,3150,40734,18558,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',8498.89,'Pagos Ganancias',NULL,1,'2021-05-08 22:54:58','2021-05-08 22:54:58',NULL),(147,3150,40734,18558,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',47348.17,'Iva',NULL,1,'2021-05-08 22:57:33','2021-05-10 16:09:41','2021-05-10 16:09:41'),(148,3150,40734,18558,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',69169.20,'Devengamiento',NULL,1,'2021-05-08 22:58:56','2021-05-08 22:58:56',NULL),(149,3150,40734,18558,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',12355.87,'Socios',NULL,1,'2021-05-08 23:01:26','2021-05-08 23:01:26',NULL),(150,3150,40734,18558,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2417.77,'Socios',NULL,1,'2021-05-08 23:03:30','2021-05-08 23:03:30',NULL),(151,3150,40734,18558,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',5000.00,'Honorarios',NULL,1,'2021-05-08 23:04:22','2021-05-08 23:04:22',NULL),(152,3150,40734,18558,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',13753.20,'Pagos',NULL,1,'2021-05-08 23:05:26','2021-05-10 17:29:34','2021-05-10 17:29:34');
INSERT INTO `balance_libro` VALUES (153,3150,40734,18559,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',51768.22,'Devengamiento',NULL,1,'2021-05-08 23:07:22','2021-05-10 16:10:27','2021-05-10 16:10:27'),(154,3150,40734,18558,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',94286.42,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-08 23:09:28','2021-05-08 23:11:37','2021-05-08 23:11:37'),(155,3150,40734,18558,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',72000.00,'Socios',NULL,1,'2021-05-08 23:10:58','2021-05-08 23:11:51','2021-05-08 23:11:51'),(156,3150,40734,18559,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',94286.42,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-08 23:11:37','2021-05-08 23:11:37',NULL),(157,3150,40734,18559,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',72000.00,'Socios',NULL,1,'2021-05-08 23:11:51','2021-05-08 23:11:51',NULL),(158,3150,40734,18559,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',69169.20,'Devengamiento',NULL,1,'2021-05-08 23:13:16','2021-05-08 23:13:16',NULL),(159,3150,40734,18559,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',9169.20,'Pagos',NULL,1,'2021-05-08 23:14:10','2021-05-10 17:28:46','2021-05-10 17:28:46'),(160,3150,40734,18559,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',51601.93,'Iva',NULL,1,'2021-05-08 23:16:08','2021-05-10 16:11:39','2021-05-10 16:11:39'),(161,3150,40734,18559,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',5500.00,'Honorarios',NULL,1,'2021-05-08 23:18:18','2021-05-08 23:18:18',NULL),(162,3150,40734,18560,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',52250.50,'Devengamiento',NULL,1,'2021-05-08 23:21:37','2021-05-10 16:14:24','2021-05-10 16:14:24'),(163,3150,40734,18560,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',94875.17,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-08 23:23:29','2021-05-08 23:23:29',NULL),(164,3150,40734,18560,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',64000.00,'Socios',NULL,1,'2021-05-08 23:24:38','2021-05-08 23:24:38',NULL),(165,3150,40734,18560,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',69169.20,'Devengamiento',NULL,1,'2021-05-08 23:25:40','2021-05-08 23:25:40',NULL),(166,3150,40734,18560,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',8498.89,'Pagos Ganancias',NULL,1,'2021-05-08 23:26:58','2021-05-08 23:26:58',NULL),(167,3150,40734,18560,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',9169.20,'Pagos',NULL,1,'2021-05-08 23:27:52','2021-05-10 17:25:47','2021-05-10 17:25:47'),(168,3150,40734,18560,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',43751.61,'Iva',NULL,1,'2021-05-08 23:29:46','2021-05-10 16:15:30','2021-05-10 16:15:30'),(169,3150,40734,18560,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',5500.00,'Honorarios',NULL,1,'2021-05-08 23:30:37','2021-05-08 23:30:37',NULL),(170,3150,40734,18561,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',43925.22,'Devengamiento',NULL,1,'2021-05-08 23:32:36','2021-05-10 16:17:52','2021-05-10 16:17:52'),(171,3150,40734,18561,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',73809.00,'Socios',NULL,1,'2021-05-08 23:33:38','2021-05-08 23:33:38',NULL),(172,3150,40734,18561,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',95094.87,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-08 23:35:11','2021-05-08 23:35:11',NULL),(173,3150,40734,18561,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',69169.20,'Devengamiento',NULL,1,'2021-05-08 23:36:51','2021-05-08 23:36:51',NULL),(174,3150,40734,18561,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',9169.20,'Pagos',NULL,1,'2021-05-08 23:37:54','2021-05-10 17:27:23','2021-05-10 17:27:23');
INSERT INTO `balance_libro` VALUES (175,3150,40734,18561,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',5500.00,'Honorarios',NULL,1,'2021-05-08 23:38:58','2021-05-08 23:38:58',NULL),(176,3150,40734,18562,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',44101.71,'Devengamiento',NULL,1,'2021-05-08 23:44:25','2021-05-10 13:50:11','2021-05-10 13:50:11'),(177,3150,40734,18562,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',113333.43,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-08 23:46:22','2021-05-08 23:46:22',NULL),(178,3150,40734,18562,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',31349.06,'Iva',NULL,1,'2021-05-08 23:48:26','2021-05-10 16:22:23','2021-05-10 16:22:23'),(179,3150,40734,18562,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',8498.89,'Pagos Ganancias',NULL,1,'2021-05-08 23:49:20','2021-05-08 23:49:20',NULL),(180,3150,40734,18562,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',69169.20,'Devengamiento',NULL,1,'2021-05-08 23:50:23','2021-05-08 23:50:23',NULL),(181,3150,40734,18562,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',50000.00,'Socios',NULL,1,'2021-05-08 23:51:34','2021-05-08 23:51:34',NULL),(182,3150,40734,18562,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',5500.00,'Honorarios',NULL,1,'2021-05-08 23:52:48','2021-05-08 23:52:48',NULL),(183,3150,40734,18563,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',36139.25,'Devengamiento',NULL,1,'2021-05-08 23:56:09','2021-05-10 14:05:44','2021-05-10 14:05:44'),(184,3150,40734,18562,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',160000.00,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-09 00:02:34','2021-05-09 00:03:09','2021-05-09 00:03:09'),(185,3150,40734,18563,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',160000.00,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-09 00:03:09','2021-05-10 18:02:35','2021-05-10 18:02:35'),(186,3150,40734,18563,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2248.58,'Diferencia Cbio.',NULL,1,'2021-05-09 00:04:40','2021-05-10 17:50:25','2021-05-10 17:50:25'),(187,3150,40734,18563,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',103753.20,'Devengamiento',NULL,1,'2021-05-09 00:06:10','2021-05-09 00:06:10',NULL),(188,3150,40734,18563,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2560.00,'Ingresos Brutos',NULL,1,'2021-05-09 00:09:04','2021-05-24 22:25:48','2021-05-24 22:25:48'),(189,3150,40734,18563,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',55000.00,'Socios',NULL,1,'2021-05-09 00:10:29','2021-05-09 00:10:29',NULL),(190,3150,40734,18563,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',20.79,'Compras',NULL,1,'2021-05-09 00:11:52','2021-05-09 00:11:52',NULL),(191,3150,40734,18563,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',36135.64,'Iva',NULL,1,'2021-05-09 00:17:43','2021-05-10 13:43:42','2021-05-10 13:43:42'),(192,3150,40734,18563,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',9169.20,'Pagos',NULL,1,'2021-05-09 00:18:53','2021-05-10 17:27:02','2021-05-10 17:27:02'),(193,3150,40734,18561,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',60000.00,'Pagos',NULL,1,'2021-05-10 11:40:15','2021-05-10 11:40:15',NULL),(194,3150,40734,18562,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',60000.00,'Pagos',NULL,1,'2021-05-10 11:41:31','2021-05-10 11:41:31',NULL),(195,3150,40734,18563,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',60000.00,'Pagos',NULL,1,'2021-05-10 11:42:38','2021-05-10 11:42:38',NULL),(196,3150,40734,18554,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',107241.33,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-10 12:04:14','2021-05-10 12:04:51','2021-05-10 12:04:51');
INSERT INTO `balance_libro` VALUES (197,3150,40734,18555,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',107241.33,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-10 12:04:51','2021-05-10 12:04:51',NULL),(198,3150,40734,18552,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',40240.32,'Pago IVA-devengamiento',NULL,1,'2021-05-10 12:10:00','2021-05-10 12:10:00',NULL),(199,3150,40734,18555,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',75841.60,'Devengamiento',NULL,1,'2021-05-10 12:11:35','2021-05-10 12:22:37','2021-05-10 12:22:37'),(200,3150,40734,18557,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',51438.22,'Devengamiento',NULL,1,'2021-05-10 12:14:22','2021-05-10 16:07:33','2021-05-10 16:07:33'),(201,3150,40734,18555,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',75841.60,'Compensaciones-Devengamiento',NULL,1,'2021-05-10 12:22:37','2021-05-10 15:41:21','2021-05-10 15:41:21'),(202,3150,40734,18556,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',93487.79,'Pagos Ganancias',NULL,1,'2021-05-10 12:25:48','2021-05-10 12:25:48',NULL),(203,3150,40734,18554,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',8625.98,'Ingresos Brutos',NULL,1,'2021-05-10 12:27:04','2021-05-10 12:27:04',NULL),(204,3150,40734,18553,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',55000.00,'socios',NULL,1,'2021-05-10 12:29:54','2021-05-11 11:56:52','2021-05-11 11:56:52'),(205,3150,40734,18555,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',51233.24,'Iva',NULL,1,'2021-05-10 12:33:18','2021-05-10 12:33:50','2021-05-10 12:33:50'),(206,3150,40734,18555,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',51233.24,'Iva',NULL,1,'2021-05-10 12:33:50','2021-05-10 16:26:07','2021-05-10 16:26:07'),(207,3150,40734,18557,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',9169.20,'Pagos',NULL,1,'2021-05-10 12:41:08','2021-05-10 17:26:36','2021-05-10 17:26:36'),(208,3150,40734,18563,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',72866.40,'Compras',NULL,1,'2021-05-10 13:13:23','2021-05-10 13:13:23',NULL),(209,3150,40734,18557,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',51438.22,'Iva',NULL,1,'2021-05-10 13:36:02','2021-05-10 16:08:00','2021-05-10 16:08:00'),(210,3150,40734,18563,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',36139.25,'Iva',NULL,1,'2021-05-10 13:43:42','2021-05-10 14:06:06','2021-05-10 14:06:06'),(211,3150,40734,18562,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',48355.47,'Devengamiento',NULL,1,'2021-05-10 13:50:11','2021-05-10 16:21:36','2021-05-10 16:21:36'),(212,3150,40734,18563,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',36139.25,'Devengamiento',NULL,1,'2021-05-10 14:10:31','2021-05-10 15:49:06','2021-05-10 15:49:06'),(213,3150,40734,18563,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',36139.25,'Iva',NULL,1,'2021-05-10 14:12:59','2021-05-10 15:42:01','2021-05-10 15:42:01'),(214,3150,40734,18556,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',51277.57,'Devengamiento',NULL,1,'2021-05-10 14:42:58','2021-05-10 15:45:34','2021-05-10 15:45:34'),(215,3150,40734,18555,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',71587.84,'Compensaciones-Devengamiento',NULL,1,'2021-05-10 15:41:21','2021-05-10 15:41:21',NULL),(216,3150,40734,18563,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',46979.48,'Iva',NULL,1,'2021-05-10 15:42:01','2021-05-10 15:45:56','2021-05-10 15:45:56'),(217,3150,40734,18556,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',47023.81,'Devengamiento',NULL,1,'2021-05-10 15:45:34','2021-05-10 15:54:38','2021-05-10 15:54:38');
INSERT INTO `balance_libro` VALUES (218,3150,40734,18563,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',47023.81,'Iva',NULL,1,'2021-05-10 15:45:56','2021-05-10 15:48:28','2021-05-10 15:48:28'),(219,3150,40734,18563,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',31885.49,'Iva',NULL,1,'2021-05-10 15:48:28','2021-05-10 16:23:30','2021-05-10 16:23:30'),(220,3150,40734,18563,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',31885.49,'Devengamiento',NULL,1,'2021-05-10 15:49:06','2021-05-10 16:22:57','2021-05-10 16:22:57'),(221,3150,40734,18556,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',47023.81,'Devengamiento',NULL,1,'2021-05-10 15:54:38','2021-05-10 15:54:38',NULL),(222,3150,40734,18556,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',47023.81,'Iva',NULL,1,'2021-05-10 15:55:21','2021-05-10 15:55:21',NULL),(223,3150,40734,18557,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',47184.46,'Devengamiento',NULL,1,'2021-05-10 16:07:33','2021-05-10 16:07:33',NULL),(224,3150,40734,18557,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',47184.46,'Iva',NULL,1,'2021-05-10 16:08:00','2021-05-10 16:08:00',NULL),(225,3150,40734,18558,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',47348.17,'Devengamiento',NULL,1,'2021-05-10 16:09:19','2021-05-10 16:09:19',NULL),(226,3150,40734,18558,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',47348.17,'Iva',NULL,1,'2021-05-10 16:09:41','2021-05-10 16:09:41',NULL),(227,3150,40734,18559,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',47514.46,'Devengamiento',NULL,1,'2021-05-10 16:10:27','2021-05-10 16:10:27',NULL),(228,3150,40734,18559,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',47514.46,'Iva',NULL,1,'2021-05-10 16:11:39','2021-05-10 16:11:39',NULL),(229,3150,40734,18560,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',47996.74,'Devengamiento',NULL,1,'2021-05-10 16:14:24','2021-05-10 16:14:24',NULL),(230,3150,40734,18560,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',39497.85,'Iva',NULL,1,'2021-05-10 16:15:30','2021-05-10 16:15:30',NULL),(231,3150,40734,18561,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',39671.46,'Devengamiento',NULL,1,'2021-05-10 16:17:52','2021-05-10 16:17:52',NULL),(232,3150,40734,18561,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',39671.46,'Iva',NULL,1,'2021-05-10 16:20:03','2021-05-10 16:20:03',NULL),(233,3150,40734,18562,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',39847.95,'Devengamiento',NULL,1,'2021-05-10 16:21:36','2021-05-12 00:47:14','2021-05-12 00:47:14'),(234,3150,40734,18562,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',31349.06,'Iva',NULL,1,'2021-05-10 16:22:23','2021-05-10 16:22:23',NULL),(235,3150,40734,18563,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',31885.49,'Devengamiento',NULL,1,'2021-05-10 16:22:57','2021-05-10 16:22:57',NULL),(236,3150,40734,18563,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',31885.49,'Iva',NULL,1,'2021-05-10 16:23:30','2021-05-10 16:23:30',NULL),(237,3150,40734,18555,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',46979.48,'Iva',NULL,1,'2021-05-10 16:26:07','2021-05-10 16:26:07',NULL),(238,3150,40734,18552,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',148.35,'Iva',NULL,1,'2021-05-10 16:41:11','2021-05-10 16:41:11',NULL),(239,3150,40734,18554,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',60000.00,'Pagos',NULL,1,'2021-05-10 16:54:30','2021-05-10 17:02:09','2021-05-10 17:02:09'),(240,3150,40734,18554,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',60000.00,'Pagos',NULL,1,'2021-05-10 17:02:09','2021-05-10 17:09:19','2021-05-10 17:09:19');
INSERT INTO `balance_libro` VALUES (241,3150,40734,18555,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',60000.00,'Pagos',NULL,1,'2021-05-10 17:09:19','2021-05-10 17:09:19',NULL),(242,3150,40734,18556,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',60000.00,'Pagos',NULL,1,'2021-05-10 17:11:07','2021-05-10 17:11:07',NULL),(243,3150,40734,18557,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',103753.00,'Devengamiento',NULL,1,'2021-05-10 17:11:48','2021-05-10 17:11:48',NULL),(244,3150,40734,18557,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',60000.00,'Pagos',NULL,1,'2021-05-10 17:14:08','2021-05-10 17:14:08',NULL),(245,3150,40734,18558,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',60000.00,'Pagos',NULL,1,'2021-05-10 17:16:58','2021-05-11 12:42:31','2021-05-11 12:42:31'),(246,3150,40734,18560,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',60000.00,'Pagos',NULL,1,'2021-05-10 17:17:57','2021-05-10 17:17:57',NULL),(247,3150,40734,18552,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',13844.04,'Pago Cargas',NULL,1,'2021-05-10 17:24:21','2021-05-10 17:24:21',NULL),(248,3150,40734,18560,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',9169.20,'Pago Cargas',NULL,1,'2021-05-10 17:25:47','2021-05-10 17:25:47',NULL),(249,3150,40734,18557,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',9169.20,'Pago Cargas',NULL,1,'2021-05-10 17:26:36','2021-05-10 17:26:36',NULL),(250,3150,40734,18563,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',9169.20,'Pago Cargas',NULL,1,'2021-05-10 17:27:02','2021-05-10 17:27:02',NULL),(251,3150,40734,18561,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',9169.20,'Pago Cargas',NULL,1,'2021-05-10 17:27:23','2021-05-10 17:27:23',NULL),(252,3150,40734,18555,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',9169.20,'Pago Cargas',NULL,1,'2021-05-10 17:27:44','2021-05-10 17:27:44',NULL),(253,3150,40734,18559,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',9169.20,'Pago Cargas',NULL,1,'2021-05-10 17:28:46','2021-05-10 17:31:16','2021-05-10 17:31:16'),(254,3150,40734,18558,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',13753.20,'Pago Cargas',NULL,1,'2021-05-10 17:29:34','2021-05-10 17:29:34',NULL),(255,3150,40734,18554,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',9169.20,'Pago Cargas',NULL,1,'2021-05-10 17:30:14','2021-05-10 17:30:14',NULL),(256,3150,40734,18553,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',9169.20,'Pago Cargas',NULL,1,'2021-05-10 17:30:51','2021-05-10 17:30:51',NULL),(257,3150,40734,18559,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',9169.20,'Pago Cargas',NULL,1,'2021-05-10 17:31:16','2021-05-10 17:31:16',NULL),(258,3150,40734,18563,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',2248.58,'Diferencia Cbio.',NULL,1,'2021-05-10 17:50:25','2021-05-10 17:50:25',NULL),(259,3150,40734,18563,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',160000.00,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-10 18:02:35','2021-05-10 18:07:14','2021-05-10 18:07:14'),(260,3150,40734,18563,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',160000.00,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-10 18:07:14','2021-05-10 18:15:05','2021-05-10 18:15:05'),(261,3150,40734,18563,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',160000.00,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-10 18:15:05','2021-05-10 18:20:08','2021-05-10 18:20:08'),(262,3150,40734,18563,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',160000.00,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-10 18:20:08','2021-05-10 18:32:15','2021-05-10 18:32:15');
INSERT INTO `balance_libro` VALUES (263,3150,40734,18563,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',160000.00,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-10 18:32:15','2021-05-10 18:32:15',NULL),(264,3150,40734,18554,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',431298.80,'Ingresos y Gastos Bancarios',NULL,1,'2021-05-10 18:59:35','2021-05-10 18:59:35',NULL),(265,3150,40735,20094,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',136103.80,'Asiento Apertura',NULL,1,'2021-05-10 20:47:05','2021-05-11 17:27:02','2021-05-11 17:27:02'),(266,3150,40734,18553,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',55000.00,'socios',NULL,1,'2021-05-11 11:56:52','2021-05-11 11:56:52',NULL),(267,3150,40734,18552,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',60000.00,'Pagos',NULL,1,'2021-05-11 11:59:33','2021-05-11 12:01:56','2021-05-11 12:01:56'),(268,3150,40734,18553,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',60000.00,'Pagos',NULL,1,'2021-05-11 12:01:23','2021-05-11 12:33:48','2021-05-11 12:33:48'),(269,3150,40734,18552,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',90000.00,'Pagos',NULL,1,'2021-05-11 12:01:56','2021-05-11 12:31:39','2021-05-11 12:31:39'),(270,3150,40734,18554,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',60000.00,'Pagos',NULL,1,'2021-05-11 12:03:09','2021-05-11 12:34:19','2021-05-11 12:34:19'),(271,3150,40734,18555,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',60000.00,'Pagos',NULL,1,'2021-05-11 12:04:04','2021-05-11 12:34:45','2021-05-11 12:34:45'),(272,3150,40734,18556,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',60000.00,'Pagos',NULL,1,'2021-05-11 12:05:13','2021-05-11 12:35:12','2021-05-11 12:35:12'),(273,3150,40734,18557,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',60000.00,'Pagos',NULL,1,'2021-05-11 12:06:13','2021-05-11 12:35:27','2021-05-11 12:35:27'),(274,3150,40734,18558,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',90000.00,'Pagos',NULL,1,'2021-05-11 12:07:02','2021-05-11 12:46:04','2021-05-11 12:46:04'),(275,3150,40734,18559,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',60000.00,'Pagos',NULL,1,'2021-05-11 12:08:05','2021-05-11 12:08:05',NULL),(276,3150,40734,18560,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',60000.00,'Pagos',NULL,1,'2021-05-11 12:08:53','2021-05-11 12:45:27','2021-05-11 12:45:27'),(277,3150,40734,18561,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',60000.00,'Pagos',NULL,1,'2021-05-11 12:09:45','2021-05-11 12:46:57','2021-05-11 12:46:57'),(278,3150,40734,18562,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',60000.00,'Pagos',NULL,1,'2021-05-11 12:10:30','2021-05-11 12:49:32','2021-05-11 12:49:32'),(279,3150,40734,18558,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',90000.00,'Pagos',NULL,1,'2021-05-11 12:42:31','2021-05-24 23:52:34','2021-05-24 23:52:34'),(280,3150,40734,18556,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',69169.20,'Devengamiento',NULL,1,'2021-05-11 12:51:16','2021-05-11 12:51:16',NULL),(281,3150,40735,20094,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',136103.80,'Asiento Apertura',NULL,1,'2021-05-11 17:27:02','2021-05-11 17:27:02',NULL),(282,3150,40735,20094,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',3400.00,NULL,NULL,1,'2021-05-11 18:44:32','2021-05-11 18:45:16','2021-05-11 18:45:16'),(283,3150,40735,20094,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',3400.00,NULL,NULL,1,'2021-05-11 18:45:16','2021-05-11 18:46:52','2021-05-11 18:46:52'),(284,3150,40735,20094,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',3400.00,'Ingresos del Mes',NULL,1,'2021-05-11 18:46:52','2021-05-11 20:56:34','2021-05-11 20:56:34');
INSERT INTO `balance_libro` VALUES (292,3150,40735,20094,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',3400.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(293,3150,40735,20094,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',6000.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(294,3150,40735,20094,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',5000.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:23:11','2021-05-11 21:23:11'),(295,3150,40735,20094,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',26.63,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(296,3150,40735,20094,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',1038.25,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(297,3150,40735,20095,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',1000.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(298,3150,40735,20095,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',5000.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(299,3150,40735,20095,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',46.40,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(300,3150,40735,20095,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',1733.93,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(301,3150,40735,20096,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',6000.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(302,3150,40735,20096,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',5000.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(303,3150,40735,20096,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',76.16,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(304,3150,40735,20096,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',1694.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(305,3150,40735,20097,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',500.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(306,3150,40735,20097,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',4000.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(307,3150,40735,20097,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',60.77,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:37:30','2021-05-11 21:37:30'),(308,3150,40735,20097,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',2202.20,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(309,3150,40735,20097,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',4426.25,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(310,3150,40735,20097,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',1000.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(311,3150,40735,20098,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',5500.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(312,3150,40735,20098,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',5000.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(313,3150,40735,20098,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',60.77,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:42:33','2021-05-11 21:42:33'),(314,3150,40735,20098,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',2202.20,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(315,3150,40735,20098,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',800.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL);
INSERT INTO `balance_libro` VALUES (316,3150,40735,20099,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',17000.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(317,3150,40735,20099,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',5000.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(318,3150,40735,20099,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',145.21,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(319,3150,40735,20099,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',2202.20,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(320,3150,40735,20100,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1000.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(321,3150,40735,20100,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',19.21,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(322,3150,40735,20100,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2202.20,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(323,3150,40735,20101,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',1500.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(324,3150,40735,20101,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',2202.20,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(325,3150,40735,20101,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',36.69,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(326,3150,40735,20101,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',2413.59,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(327,3150,40735,20102,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',5500.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(328,3150,40735,20102,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2202.20,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(329,3150,40735,20102,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',19.26,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(330,3150,40735,20103,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1500.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(331,3150,40735,20103,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',3000.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(332,3150,40735,20103,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',2202.20,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(333,3150,40735,20103,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',9.26,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(334,3150,40735,20104,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',5500.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(335,3150,40735,20104,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',3000.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(336,3150,40735,20104,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',21.25,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(337,3150,40735,20105,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1500.00,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(338,3150,40735,20105,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',3.75,NULL,NULL,1,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(339,3150,40735,20094,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',5000.00,'Egresos',NULL,1,'2021-05-11 21:20:20','2021-05-11 21:47:47','2021-05-11 21:47:47');
INSERT INTO `balance_libro` VALUES (340,3150,40735,20097,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',13.65,NULL,NULL,1,'2021-05-11 21:37:30','2021-05-11 21:37:30',NULL),(341,3150,40735,20098,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',76.21,NULL,NULL,1,'2021-05-11 21:42:33','2021-05-11 21:42:33',NULL),(342,3150,40735,20094,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',5000.00,'Egresos',NULL,1,'2021-05-11 21:47:47','2021-05-11 21:47:47',NULL),(343,3150,40735,20094,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',200.00,NULL,NULL,1,'2021-05-11 22:02:36','2021-05-11 22:02:36',NULL),(344,3150,40735,20094,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',344.09,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(345,3150,40735,20094,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',5.91,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(346,3150,40735,20094,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',1657.05,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(347,3150,40735,20094,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',1126.80,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(348,3150,40735,20095,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',9.49,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(349,3150,40735,20095,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',305.13,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(350,3150,40735,20095,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',1525.65,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(351,3150,40735,20095,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',529.07,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(352,3150,40735,20096,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',1314.53,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(353,3150,40735,20096,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',445.36,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(354,3150,40735,20096,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',13.42,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(355,3150,40735,20096,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',1577.43,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(356,3150,40735,20097,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',2.23,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(357,3150,40735,20097,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',122.14,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(358,3150,40735,20097,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',1221.42,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(359,3150,40735,20097,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',543.30,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(360,3150,40735,20098,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',496.33,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL);
INSERT INTO `balance_libro` VALUES (361,3150,40735,20098,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',180.30,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(362,3150,40735,20098,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',16.16,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(363,3150,40735,20098,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',1239.59,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(364,3150,40735,20098,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',1126.90,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(365,3150,40735,20099,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',19.31,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(366,3150,40735,20099,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',3374.34,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(367,3150,40735,20099,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',992.45,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(368,3150,40735,20099,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',437.12,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(369,3150,40735,20100,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',387.04,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(370,3150,40735,20100,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2.26,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(371,3150,40735,20100,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',175.75,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(372,3150,40735,20101,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',217.26,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(373,3150,40735,20101,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',30.62,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(374,3150,40735,20101,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',3.56,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(375,3150,40735,20102,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2.18,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(376,3150,40735,20102,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',622.99,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(377,3150,40735,20102,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',249.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(378,3150,40735,20103,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',109.38,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(379,3150,40735,20103,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',160.58,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(380,3150,40735,20103,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',0.68,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL);
INSERT INTO `balance_libro` VALUES (381,3150,40735,20103,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',218.76,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(382,3150,40735,20104,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',0.85,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(383,3150,40735,20104,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',120.17,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(384,3150,40735,20104,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',220.31,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(385,3150,40734,18552,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',5839152.80,'Apertura',NULL,1,'2021-05-11 22:19:01','2021-05-11 23:22:06','2021-05-11 23:22:06'),(386,3150,40734,18552,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',5839152.80,'Apertura',NULL,1,'2021-05-11 22:19:01','2021-05-11 22:21:19','2021-05-11 22:21:19'),(387,3150,40735,20105,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',24858.70,'Ajuste por Inflacion Asiento Anual',NULL,1,'2021-05-11 22:19:50','2021-05-11 22:19:50',NULL),(388,3150,40734,18552,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',4882597.63,'Apertura',NULL,1,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(389,3150,40734,18555,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',20723.85,'Pago IIBB',NULL,1,'2021-05-11 23:28:21','2021-05-11 23:28:21',NULL),(390,3150,40734,18556,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',131311.44,'Devengamiento',NULL,1,'2021-05-11 23:51:09','2021-05-11 23:51:09',NULL),(391,3150,40734,18562,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',39847.95,'Devengamiento',NULL,1,'2021-05-12 00:47:14','2021-05-12 00:47:14',NULL),(398,3150,40720,1537,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',450637.72,'compras y gastos del mes',NULL,1,'2021-05-19 18:27:32','2021-05-19 18:27:32',NULL),(402,3150,40720,1538,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',505180.30,NULL,NULL,1,'2021-05-19 18:43:07','2021-05-19 18:43:07',NULL),(419,3150,40720,1539,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',483276.76,NULL,NULL,1,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(420,3150,40720,1540,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',674633.67,NULL,NULL,1,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(421,3150,40720,1541,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',554276.33,NULL,NULL,1,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(422,3150,40720,1545,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',686431.70,NULL,NULL,1,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(423,3150,40720,1546,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',559742.23,NULL,NULL,1,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(424,3150,40720,1547,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',664666.73,NULL,NULL,1,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(425,3150,40720,1548,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',668877.14,NULL,NULL,1,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(426,3150,40720,1549,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',524360.98,NULL,NULL,1,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(427,3150,40720,1550,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',684213.12,NULL,NULL,1,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(428,3150,40720,1551,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',776010.90,NULL,NULL,1,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL);
INSERT INTO `balance_libro` VALUES (429,3150,40720,1537,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',349871.13,NULL,NULL,1,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(430,3150,40720,1538,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',314888.32,NULL,NULL,1,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(431,3150,40720,1539,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',381884.68,NULL,NULL,1,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(432,3150,40720,1540,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',352172.58,NULL,NULL,1,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(433,3150,40720,1541,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',492559.44,NULL,NULL,1,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(434,3150,40720,1545,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',345329.06,NULL,NULL,1,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(435,3150,40720,1546,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',315650.02,NULL,NULL,1,'2021-05-19 21:51:03','2021-05-19 21:51:04',NULL),(436,3150,40720,1547,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',346250.03,NULL,NULL,1,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(437,3150,40720,1548,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',416316.62,NULL,NULL,1,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(438,3150,40720,1549,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',394681.61,NULL,NULL,1,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(439,3150,40720,1550,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',692703.98,NULL,NULL,1,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(440,3150,40720,1551,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',478565.23,NULL,NULL,1,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(441,3150,40720,1541,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',359411.00,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-19 22:11:17','2021-05-19 22:17:26','2021-05-19 22:17:26'),(442,3150,40720,1541,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',359411.00,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-19 22:17:26','2021-05-19 22:17:26',NULL),(443,3150,40720,1551,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',617012.83,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-19 22:18:06','2021-05-19 22:18:06',NULL),(444,3150,40720,1550,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',398751.04,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-19 22:18:44','2021-05-19 22:58:44','2021-05-19 22:58:44'),(445,3150,40720,1549,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',465270.00,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-19 22:19:25','2021-05-19 22:19:25',NULL),(446,3150,40720,1548,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',426599.00,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-19 22:19:59','2021-05-19 22:19:59',NULL),(447,3150,40720,1547,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',412999.00,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-19 22:20:33','2021-05-19 22:20:33',NULL),(448,3150,40720,1546,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',385211.35,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-19 22:21:12','2021-05-19 22:21:12',NULL),(449,3150,40720,1545,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',341834.64,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-19 22:22:02','2021-05-19 22:22:02',NULL),(450,3150,40720,1540,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',485839.26,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-19 22:22:42','2021-05-19 22:22:42',NULL);
INSERT INTO `balance_libro` VALUES (451,3150,40720,1539,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',351434.00,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-19 22:23:21','2021-05-19 22:23:21',NULL),(452,3150,40720,1537,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',359411.00,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-19 22:24:17','2021-05-19 22:31:18','2021-05-19 22:31:18'),(453,3150,40720,1538,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',390028.35,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-19 22:32:18','2021-05-19 22:32:18',NULL),(454,3150,40720,1537,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',298174.19,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-19 22:32:54','2021-05-19 22:32:54',NULL),(455,3150,40720,1550,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',993055.77,'Ingresos y Egresos Bancarios',NULL,1,'2021-05-19 22:58:44','2021-05-19 22:58:44',NULL),(456,3150,40720,1537,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',204862.99,'Ajuste cuentas bancarias',NULL,1,'2021-05-19 23:03:09','2021-05-19 23:03:09',NULL),(457,3150,40720,1551,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',43456.50,'Ingresos Brutos Mensuales',NULL,1,'2021-05-19 23:04:32','2021-05-19 23:04:32',NULL),(458,3150,40720,1550,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',41607.21,'Ingresos Brutos Mensuales',NULL,1,'2021-05-19 23:04:57','2021-05-19 23:04:57',NULL),(459,3150,40735,20105,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',21571.30,'Ajuste por inflación',NULL,1,'2021-05-24 21:54:10','2021-05-24 21:55:21','2021-05-24 21:55:21'),(460,3150,40735,20105,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',21571.30,'Ajuste por inflación',NULL,1,'2021-05-24 21:55:21','2021-05-24 21:55:21',NULL),(461,3150,40734,18563,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',2560.00,'Ingresos Brutos',NULL,1,'2021-05-24 22:25:48','2021-05-24 22:51:33','2021-05-24 22:51:33'),(462,3150,40734,18563,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',2560.00,'Saldo a favor IIBB',NULL,1,'2021-05-24 22:29:09','2021-05-24 22:51:43','2021-05-24 22:51:43'),(463,3150,40734,18563,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',2560.00,'Ingresos Brutos',NULL,1,'2021-05-24 22:51:33','2021-05-24 22:51:33',NULL),(464,3150,40734,18554,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',862597.60,'ajustes',NULL,1,'2021-05-24 23:02:19','2021-05-24 23:02:19',NULL),(469,3150,40734,18552,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',31501.11,NULL,NULL,1,'2021-05-24 23:22:01','2021-05-24 23:24:03','2021-05-24 23:24:03'),(470,3150,40734,18553,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',15800.00,NULL,NULL,1,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(471,3150,40734,18554,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',35880.45,NULL,NULL,1,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(472,3150,40734,18555,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',5500.00,NULL,NULL,1,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(473,3150,40734,18556,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',9230.00,NULL,NULL,1,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(474,3150,40734,18558,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',4730.00,NULL,NULL,1,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(475,3150,40734,18561,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1300.00,NULL,NULL,1,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36');
INSERT INTO `balance_libro` VALUES (476,3150,40734,18562,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',40088.96,NULL,NULL,1,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(477,3150,40734,18563,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',78345.61,NULL,NULL,1,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(479,3150,40734,18552,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',31501.11,NULL,NULL,1,'2021-05-24 23:25:17','2021-05-24 23:25:17',NULL),(480,3150,40734,18553,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',15800.00,NULL,NULL,1,'2021-05-24 23:25:17','2021-05-24 23:25:17',NULL),(481,3150,40734,18554,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',35880.45,NULL,NULL,1,'2021-05-24 23:25:17','2021-05-24 23:25:17',NULL),(482,3150,40734,18555,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',5500.00,NULL,NULL,1,'2021-05-24 23:25:17','2021-05-24 23:25:18',NULL),(483,3150,40734,18556,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',9230.00,NULL,NULL,1,'2021-05-24 23:25:18','2021-05-24 23:25:18',NULL),(484,3150,40734,18558,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',4730.00,NULL,NULL,1,'2021-05-24 23:25:18','2021-05-24 23:25:18',NULL),(485,3150,40734,18561,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1300.00,NULL,NULL,1,'2021-05-24 23:25:18','2021-05-24 23:25:18',NULL),(486,3150,40734,18562,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',40088.96,NULL,NULL,1,'2021-05-24 23:25:18','2021-05-24 23:25:18',NULL),(487,3150,40734,18563,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',78345.61,NULL,NULL,1,'2021-05-24 23:25:18','2021-05-24 23:25:18',NULL),(489,3150,40734,18563,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',184982.64,NULL,NULL,1,'2021-05-24 23:35:59','2021-05-24 23:35:59',NULL),(490,3150,40734,18563,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',281323.45,NULL,NULL,1,'2021-05-24 23:44:52','2021-05-24 23:44:52',NULL),(493,3150,40734,18563,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',70677.60,NULL,NULL,1,'2021-05-24 23:50:18','2021-05-24 23:50:18',NULL),(495,3150,40736,21632,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-30','2019-09-30',1500.30,NULL,NULL,1,'2021-05-24 23:52:26','2021-05-24 23:52:50','2021-05-24 23:52:50'),(496,3150,40736,21633,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-10-31','2019-10-31',1500.00,NULL,NULL,1,'2021-05-24 23:52:26','2021-05-24 23:52:50','2021-05-24 23:52:50'),(497,3150,40734,18558,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',90000.00,'Pagos',NULL,1,'2021-05-24 23:52:34','2021-05-24 23:52:34',NULL),(498,3150,40734,18553,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',4200.00,'Honorarios',NULL,1,'2021-05-25 00:00:14','2021-05-25 00:00:14',NULL),(499,3150,40734,18552,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',530.26,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(500,3150,40734,18552,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',19884.64,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(501,3150,40734,18552,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',2081.31,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(502,3150,40734,18552,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',3038.77,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(503,3150,40734,18552,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',1391.92,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL);
INSERT INTO `balance_libro` VALUES (504,3150,40734,18553,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',2797.80,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(505,3150,40734,18553,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',1281.55,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(506,3150,40734,18553,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',18307.81,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(507,3150,40734,18553,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',1931.76,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(508,3150,40734,18554,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',2410.63,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(509,3150,40734,18554,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',1.04,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(510,3150,40734,18554,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',5325.41,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(511,3150,40734,18554,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',15774.32,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(512,3150,40734,18554,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',1694.86,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(513,3150,40734,18555,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',14657.02,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(514,3150,40734,18555,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',8244.57,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(515,3150,40734,18555,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',1343.56,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(516,3150,40734,18555,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',2085.99,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(517,3150,40734,18555,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',1602.39,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(518,3150,40734,18556,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',2066.55,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(519,3150,40734,18556,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',1503.58,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(520,3150,40734,18556,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',7606.55,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(521,3150,40734,18556,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',50665.09,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(522,3150,40734,18556,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',1300.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(523,3150,40734,18556,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',13522.76,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL);
INSERT INTO `balance_libro` VALUES (524,3150,40734,18557,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',6699.06,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(525,3150,40734,18557,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',17864.16,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(526,3150,40734,18557,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',2729.84,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(527,3150,40734,18557,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',1349.91,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(528,3150,40734,18558,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1611.48,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(529,3150,40734,18558,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',878.75,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(530,3150,40734,18558,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1218.01,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(531,3150,40734,18558,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',10544.96,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(532,3150,40734,18558,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',5931.54,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(533,3150,40734,18559,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',8690.25,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(534,3150,40734,18559,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',1328.04,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(535,3150,40734,18559,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',796.61,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(536,3150,40734,18559,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',1019.60,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(537,3150,40734,18560,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',622.99,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(538,3150,40734,18560,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',808.89,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(539,3150,40734,18560,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',6796.23,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(540,3150,40734,18560,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',3822.88,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(541,3150,40734,18560,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1038.60,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(542,3150,40734,18561,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',668.60,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(543,3150,40734,18561,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',401.05,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL);
INSERT INTO `balance_libro` VALUES (544,3150,40734,18561,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',535.91,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(545,3150,40734,18561,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',4375.10,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(546,3150,40734,18562,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',220.31,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(547,3150,40734,18562,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',331.32,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(548,3150,40734,18562,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',2403.34,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(549,3150,40734,18562,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',367.28,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(550,3150,40734,18563,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',712313.23,'Ajuste por Inflacion Asiento Anual',NULL,1,'2021-05-25 00:02:50','2021-05-25 00:02:50',NULL),(551,3150,40734,18563,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',505000.00,'Diferencia de cabio moneda extranjera',NULL,1,'2021-05-25 00:17:16','2021-05-25 00:17:16',NULL),(552,3150,40734,18553,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',170162.60,'Cobranzas',NULL,1,'2021-05-25 00:29:55','2021-05-25 00:29:55',NULL),(553,3150,40734,18563,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',15200.00,'compras y gastos del mes',NULL,1,'2021-05-25 00:31:02','2021-05-25 00:31:02',NULL),(554,3150,40734,18563,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',936553.21,'Ajuste por inflación',NULL,1,'2021-05-25 00:44:48','2021-05-25 00:44:48',NULL),(555,3150,40736,21639,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',3410974.80,NULL,NULL,1,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(556,3150,40736,21639,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',785821.08,NULL,NULL,1,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(557,3150,40720,1551,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',21130.72,'Ajuste cuentas',NULL,1,'2021-05-28 21:21:49','2021-05-28 21:21:49',NULL),(558,3150,40720,1537,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',15634.36,'pagos',NULL,1,'2021-05-28 21:29:01','2021-05-28 21:29:01',NULL),(559,3150,40720,1551,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',4656.40,'mercaderia',NULL,1,'2021-05-28 21:32:35','2021-05-28 21:32:35',NULL),(560,3150,40720,1537,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',149000.00,'pagos',NULL,1,'2021-05-28 21:36:35','2021-05-28 21:36:35',NULL),(565,3150,40720,1537,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',58429.00,NULL,NULL,1,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(566,3150,40720,1538,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',215035.25,NULL,NULL,1,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(567,3150,40720,1539,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',194235.56,NULL,NULL,1,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(568,3150,40720,1540,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',234386.60,NULL,NULL,1,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(569,3150,40720,1541,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',223902.60,NULL,NULL,1,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL);
INSERT INTO `balance_libro` VALUES (570,3150,40720,1545,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',303241.49,NULL,NULL,1,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(571,3150,40720,1546,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',224451.83,NULL,NULL,1,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(572,3150,40720,1547,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',199266.46,NULL,NULL,1,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(573,3150,40720,1548,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',217861.57,NULL,NULL,1,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(574,3150,40720,1549,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',260601.31,NULL,NULL,1,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(575,3150,40720,1550,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',248395.84,NULL,NULL,1,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(576,3150,40720,1551,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',445604.98,NULL,NULL,1,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(577,3150,40720,1547,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',110271.09,'pagos',NULL,1,'2021-05-28 22:02:40','2021-05-28 22:02:40',NULL),(578,3150,40720,1537,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',6814.03,'pagos',NULL,1,'2021-05-28 22:04:36','2021-05-28 22:04:36',NULL),(579,3150,40720,1537,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',1000.00,NULL,NULL,1,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(580,3150,40720,1538,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',6596.17,NULL,NULL,1,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(581,3150,40720,1539,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',5958.15,NULL,NULL,1,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(582,3150,40720,1540,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',7189.77,NULL,NULL,1,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(583,3150,40720,1541,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',6177.99,NULL,NULL,1,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(584,3150,40720,1545,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',9301.89,NULL,NULL,1,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(585,3150,40720,1546,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',6189.32,NULL,NULL,1,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(586,3150,40720,1547,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',6112.47,NULL,NULL,1,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(587,3150,40720,1548,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',6682.87,NULL,NULL,1,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(588,3150,40720,1549,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',7993.91,NULL,NULL,1,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(589,3150,40720,1550,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',7619.50,NULL,NULL,1,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(590,3150,40720,1551,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',12564.57,NULL,NULL,1,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(591,3150,40720,1537,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',2706.00,'pagos',NULL,1,'2021-05-28 22:16:39','2021-05-28 22:16:39',NULL),(592,3150,40720,1537,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',815299.00,'provisiones',NULL,1,'2021-05-28 22:19:09','2021-05-28 23:13:23','2021-05-28 23:13:23'),(593,3150,40720,1537,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',259997.50,'pagos',NULL,1,'2021-05-28 22:40:06','2021-05-28 22:40:06',NULL);
INSERT INTO `balance_libro` VALUES (594,3150,40720,1538,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',25996.63,'pagos',NULL,1,'2021-05-28 22:40:50','2021-05-28 22:40:50',NULL),(595,3150,40720,1539,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',25996.63,'pagos',NULL,1,'2021-05-28 22:41:36','2021-05-28 22:41:36',NULL),(596,3150,40720,1540,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',25996.63,'pagos',NULL,1,'2021-05-28 22:42:18','2021-05-28 22:42:18',NULL),(597,3150,40720,1541,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',311990.76,'Imp. a las Ganancias',NULL,1,'2021-05-28 22:44:17','2021-05-28 23:14:31','2021-05-28 23:14:31'),(598,3150,40720,1536,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',89764.00,'pagos',NULL,1,'2021-05-28 23:10:52','2021-05-28 23:30:01','2021-05-28 23:30:01'),(599,3150,40720,1537,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',815299.00,'provisiones',NULL,1,'2021-05-28 23:13:23','2021-05-28 23:13:23',NULL),(600,3150,40720,1541,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',311990.76,'Imp. a las Ganancias',NULL,1,'2021-05-28 23:14:31','2021-05-28 23:23:25','2021-05-28 23:23:25'),(601,3150,40720,1541,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',337987.40,'Imp. a las Ganancias',NULL,1,'2021-05-28 23:20:50','2021-05-28 23:24:44','2021-05-28 23:24:44'),(602,3150,40720,1541,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',311990.76,'Imp. a las Ganancias',NULL,1,'2021-05-28 23:23:25','2021-05-28 23:23:25',NULL),(603,3150,40720,1541,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',25996.64,'Imp. a las Ganancias',NULL,1,'2021-05-28 23:24:44','2021-05-28 23:25:57','2021-05-28 23:25:57'),(604,3150,40720,1541,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',25996.63,'Imp. a las Ganancias',NULL,1,'2021-05-28 23:25:57','2021-05-28 23:25:57',NULL),(605,3150,40720,1541,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',212710.03,'Imp. a las Ganancias',NULL,1,'2021-05-28 23:28:33','2021-05-28 23:28:33',NULL),(606,3150,40720,1536,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',89764.00,'pagos',NULL,1,'2021-05-28 23:30:01','2021-05-28 23:30:20','2021-05-28 23:30:20'),(607,3150,40720,1537,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',89764.00,'pagos',NULL,1,'2021-05-28 23:30:20','2021-05-28 23:30:20',NULL),(608,3150,40720,1537,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',1836.86,'pagos',NULL,1,'2021-05-28 23:33:35','2021-05-28 23:33:35',NULL),(633,3150,40720,1537,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',300000.00,NULL,NULL,1,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(634,3150,40720,1538,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',200000.00,NULL,NULL,1,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(635,3150,40720,1539,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',200000.00,NULL,NULL,1,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(636,3150,40720,1540,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',280000.00,NULL,NULL,1,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(637,3150,40720,1541,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',200000.00,NULL,NULL,1,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(638,3150,40720,1545,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',300000.00,NULL,NULL,1,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(639,3150,40720,1546,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',450000.00,NULL,NULL,1,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(640,3150,40720,1547,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',100000.00,NULL,NULL,1,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL);
INSERT INTO `balance_libro` VALUES (641,3150,40720,1548,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',250000.00,NULL,NULL,1,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(642,3150,40720,1549,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',250000.00,NULL,NULL,1,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(643,3150,40720,1550,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',250000.00,NULL,NULL,1,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(644,3150,40720,1551,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',460000.00,NULL,NULL,1,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(645,3150,40720,1537,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',450000.00,NULL,NULL,1,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(646,3150,40720,1538,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',400000.00,NULL,NULL,1,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(647,3150,40720,1539,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',500000.00,NULL,NULL,1,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(648,3150,40720,1540,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',500000.00,NULL,NULL,1,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(649,3150,40720,1541,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',550000.00,NULL,NULL,1,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(650,3150,40720,1545,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',700000.00,NULL,NULL,1,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(651,3150,40720,1546,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',500000.00,NULL,NULL,1,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(652,3150,40720,1547,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',650000.00,NULL,NULL,1,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(653,3150,40720,1548,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',700000.00,NULL,NULL,1,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(654,3150,40720,1549,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',500000.00,NULL,NULL,1,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(655,3150,40720,1551,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',800000.00,NULL,NULL,1,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(672,3150,40736,21639,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',3410974.80,NULL,NULL,1,'2021-05-30 15:55:53','2022-05-04 15:04:19','2022-05-04 15:04:19'),(673,3150,40736,21639,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',785821.08,NULL,NULL,1,'2021-05-30 15:55:53','2021-06-01 13:21:22','2021-06-01 13:21:22'),(674,3150,40736,21639,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',354893.05,NULL,NULL,1,'2021-05-30 15:55:53','2021-06-01 15:53:01','2021-06-01 15:53:01'),(675,3150,40736,21639,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',313016.90,NULL,NULL,1,'2021-05-30 15:55:53','2021-05-30 22:58:17','2021-05-30 22:58:17'),(676,3150,40736,21639,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',20654.69,NULL,NULL,1,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(677,3150,40736,21639,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',316945.09,NULL,NULL,1,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(678,3150,40736,21639,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',1918.82,NULL,NULL,1,'2021-05-30 15:55:53','2021-06-01 18:32:50','2021-06-01 18:32:50'),(679,3150,40736,21639,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',353.98,NULL,NULL,1,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(680,3150,40736,21639,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',974.69,NULL,NULL,1,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL);
INSERT INTO `balance_libro` VALUES (681,3150,40736,21639,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',448.11,NULL,NULL,1,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(682,3150,40736,21639,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',3500.00,NULL,NULL,1,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(683,3150,40736,21639,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',333366.49,NULL,NULL,1,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(701,3150,40736,21640,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',963566.60,NULL,NULL,1,'2021-05-30 16:04:06','2021-06-01 13:25:49','2021-06-01 13:25:49'),(702,3150,40736,21640,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',339017.06,NULL,NULL,1,'2021-05-30 16:04:06','2021-05-30 16:04:07',NULL),(703,3150,40736,21640,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',165122.86,NULL,NULL,1,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(704,3150,40736,21640,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',20654.69,NULL,NULL,1,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(705,3150,40736,21640,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',312632.57,NULL,NULL,1,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(706,3150,40736,21640,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',5871.68,NULL,NULL,1,'2021-05-30 16:04:07','2021-06-01 19:35:50','2021-06-01 19:35:50'),(707,3150,40736,21640,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',23000.00,NULL,NULL,1,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(708,3150,40736,21640,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',3206.12,NULL,NULL,1,'2021-05-30 16:04:07','2021-06-01 19:12:23','2021-06-01 19:12:23'),(709,3150,40736,21640,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',376.42,NULL,NULL,1,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(710,3150,40736,21640,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',654.69,NULL,NULL,1,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(711,3150,40736,21640,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',20000.00,NULL,NULL,1,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(712,3150,40736,21640,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',3500.00,NULL,NULL,1,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(713,3150,40736,21640,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',332809.56,NULL,NULL,1,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(721,3150,40736,21641,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',847789.16,'VENTAS',NULL,1,'2021-05-30 17:06:56','2021-06-01 18:55:25','2021-06-01 18:55:25'),(722,3150,40736,21641,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',340695.24,'Iva',NULL,1,'2021-05-30 17:10:23','2021-05-30 17:10:23',NULL),(723,3150,40736,21641,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',20659.63,'Devengamiento',NULL,1,'2021-05-30 17:11:22','2021-05-30 17:11:22',NULL),(724,3150,40736,21641,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',175.63,'Iva',NULL,1,'2021-05-30 17:12:46','2021-05-31 14:45:49','2021-05-31 14:45:49'),(725,3150,40736,21641,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',681.02,'Iva',NULL,1,'2021-05-30 17:13:32','2021-06-01 17:05:56','2021-06-01 17:05:56'),(727,3150,40736,21641,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',71000.00,'OTROS',NULL,1,'2021-05-30 17:20:07','2021-05-30 17:20:07',NULL),(728,3150,40736,21641,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',20000.00,'Pagos',NULL,1,'2021-05-30 17:22:00','2021-05-30 17:23:27','2021-05-30 17:23:27');
INSERT INTO `balance_libro` VALUES (729,3150,40736,21641,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',20000.00,'Sueldos',NULL,1,'2021-05-30 17:23:27','2021-05-30 17:23:27',NULL),(730,3150,40736,21641,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',8668.00,'Pagos',NULL,1,'2021-05-30 17:25:33','2021-05-30 18:54:32','2021-05-30 18:54:32'),(731,3150,40736,21641,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',374047.15,'Iva',NULL,1,'2021-05-30 17:27:47','2021-05-30 17:27:47',NULL),(733,3150,40736,21642,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',35231.00,NULL,NULL,1,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(734,3150,40736,21642,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',166306.79,NULL,NULL,1,'2021-05-30 17:49:13','2021-05-31 14:24:50','2021-05-31 14:24:50'),(735,3150,40736,21642,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',20000.00,NULL,NULL,1,'2021-05-30 17:49:13','2021-05-31 14:51:43','2021-05-31 14:51:43'),(736,3150,40736,21642,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',1131.40,NULL,NULL,1,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(737,3150,40736,21642,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',20659.63,NULL,NULL,1,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(738,3150,40736,21642,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',315130.54,NULL,NULL,1,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(739,3150,40736,21642,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',31000.00,NULL,NULL,1,'2021-05-30 17:49:13','2021-05-31 14:13:33','2021-05-31 14:13:33'),(740,3150,40736,21641,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',5000.00,NULL,NULL,1,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(741,3150,40736,21642,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',34099.60,NULL,NULL,1,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(742,3150,40736,21647,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',10000.00,NULL,NULL,1,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(743,3150,40736,21643,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',34246.68,NULL,NULL,1,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(744,3150,40736,21643,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',65112.57,NULL,NULL,1,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(745,3150,40736,21643,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',20000.00,NULL,NULL,1,'2021-05-30 17:52:08','2021-05-31 14:51:24','2021-05-31 14:51:24'),(746,3150,40736,21643,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',30979.63,NULL,NULL,1,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(747,3150,40736,21643,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',147.08,NULL,NULL,1,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(748,3150,40736,21643,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',1000.00,NULL,NULL,1,'2021-05-30 17:52:08','2021-05-31 14:28:15','2021-05-31 14:28:15'),(749,3150,40736,21643,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',34246.68,NULL,NULL,1,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(750,3150,40736,21644,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',34404.11,NULL,NULL,1,'2021-05-30 17:53:01','2021-05-30 17:53:01',NULL),(751,3150,40736,21644,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',11204.11,NULL,NULL,1,'2021-05-30 17:53:01','2021-05-30 23:10:10','2021-05-30 23:10:10'),(752,3150,40736,21644,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',30000.00,NULL,NULL,1,'2021-05-30 17:53:02','2021-05-31 14:51:02','2021-05-31 14:51:02');
INSERT INTO `balance_libro` VALUES (753,3150,40736,21644,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',20659.63,NULL,NULL,1,'2021-05-30 17:53:02','2021-05-30 17:53:02',NULL),(754,3150,40736,21644,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',157.43,NULL,NULL,1,'2021-05-30 17:53:02','2021-05-30 17:53:02',NULL),(755,3150,40736,21644,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',34404.11,NULL,NULL,1,'2021-05-30 17:53:02','2021-05-30 17:53:02',NULL),(768,3150,40736,21645,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',34954.13,NULL,NULL,1,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(769,3150,40736,21645,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',20659.63,NULL,NULL,1,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(770,3150,40736,21645,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',550.02,NULL,NULL,1,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(771,3150,40736,21645,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',93.87,NULL,NULL,1,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(772,3150,40736,21645,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',34954.13,NULL,NULL,1,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(773,3150,40736,21645,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',20000.00,NULL,NULL,1,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(774,3150,40736,21646,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',35111.56,NULL,NULL,1,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(775,3150,40736,21646,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',2515.60,NULL,NULL,1,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(776,3150,40736,21646,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',20000.00,NULL,NULL,1,'2021-05-30 18:09:33','2021-05-31 14:50:41','2021-05-31 14:50:41'),(777,3150,40736,21646,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',20659.63,NULL,NULL,1,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(778,3150,40736,21646,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',157.43,NULL,NULL,1,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(779,3150,40736,21646,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',35111.56,NULL,NULL,1,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(780,3150,40736,21647,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',35293.03,NULL,NULL,1,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(781,3150,40736,21647,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',242348.00,NULL,NULL,1,'2021-05-30 18:09:33','2021-05-30 23:18:03','2021-05-30 23:18:03'),(782,3150,40736,21647,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',20000.00,NULL,NULL,1,'2021-05-30 18:09:33','2021-05-31 14:50:17','2021-05-31 14:50:17'),(783,3150,40736,21647,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',20659.63,NULL,NULL,1,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(784,3150,40736,21647,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',181.47,NULL,NULL,1,'2021-05-30 18:09:33','2021-06-01 19:42:57','2021-06-01 19:42:57'),(785,3150,40736,21647,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',35293.03,NULL,NULL,1,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(786,3150,40736,21645,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',156401.04,'BANCO',NULL,1,'2021-05-30 18:15:06','2021-05-30 18:15:06',NULL),(814,3150,40736,21648,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',748540.00,NULL,NULL,1,'2021-05-30 18:17:20','2021-05-31 19:17:06','2021-05-31 19:17:06'),(815,3150,40736,21648,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',35762.67,NULL,NULL,1,'2021-05-30 18:17:20','2021-05-30 18:17:20',NULL);
INSERT INTO `balance_libro` VALUES (816,3150,40736,21648,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',2251731.05,NULL,NULL,1,'2021-05-30 18:17:20','2021-05-30 18:17:21',NULL),(817,3150,40736,21648,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',20000.00,NULL,NULL,1,'2021-05-30 18:17:21','2021-05-31 14:49:51','2021-05-31 14:49:51'),(818,3150,40736,21648,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',10269.92,NULL,NULL,1,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(819,3150,40736,21648,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',20659.63,NULL,NULL,1,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(820,3150,40736,21648,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',315130.54,NULL,NULL,1,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(821,3150,40736,21648,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',469.64,NULL,NULL,1,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(822,3150,40736,21648,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',247233.00,NULL,NULL,1,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(823,3150,40736,21648,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',35762.67,NULL,NULL,1,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(824,3150,40736,21649,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',651104.70,NULL,NULL,1,'2021-05-30 18:17:21','2021-06-02 14:55:13','2021-06-02 14:55:13'),(825,3150,40736,21649,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',340120.81,NULL,NULL,1,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(826,3150,40736,21649,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',573457.25,NULL,NULL,1,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(827,3150,40736,21649,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',20000.00,NULL,NULL,1,'2021-05-30 18:17:21','2021-05-31 14:49:21','2021-05-31 14:49:21'),(828,3150,40736,21649,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',63613.80,NULL,NULL,1,'2021-05-30 18:17:21','2021-06-01 19:20:03','2021-06-01 19:20:03'),(829,3150,40736,21649,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',30979.66,NULL,NULL,1,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(830,3150,40736,21649,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',294234.94,NULL,NULL,1,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(831,3150,40736,21649,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',117741.45,NULL,NULL,1,'2021-05-30 18:17:21','2021-06-02 14:42:41','2021-06-02 14:42:41'),(832,3150,40736,21649,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',340120.81,NULL,NULL,1,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(833,3150,40736,21650,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',342394.38,NULL,NULL,1,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(834,3150,40736,21650,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',37532.95,NULL,NULL,1,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(835,3150,40736,21650,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',20659.63,NULL,NULL,1,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(836,3150,40736,21650,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',236942.11,NULL,NULL,1,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(837,3150,40736,21650,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',12059.52,NULL,NULL,1,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(838,3150,40736,21650,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',72205.70,NULL,NULL,1,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(839,3150,40736,21650,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',63821.50,NULL,NULL,1,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL);
INSERT INTO `balance_libro` VALUES (840,3150,40736,21650,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',342394.38,NULL,NULL,1,'2021-05-30 18:21:36','2021-05-30 18:31:27','2021-05-30 18:31:27'),(841,3150,40736,21650,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',30000.00,NULL,NULL,1,'2021-05-30 18:21:36','2021-05-31 14:48:28','2021-05-31 14:48:28'),(842,3150,40736,21650,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',342394.38,NULL,NULL,1,'2021-05-30 18:31:27','2021-05-30 23:50:45','2021-05-30 23:50:45'),(843,3150,40736,21641,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',197434.63,'BANCO',NULL,1,'2021-05-30 18:42:14','2021-05-30 22:38:53','2021-05-30 22:38:53'),(844,3150,40736,21642,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',166306.79,'BANCO',NULL,1,'2021-05-30 18:48:28','2021-05-30 22:41:35','2021-05-30 22:41:35'),(845,3150,40736,21641,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',8668.00,'Pagos',NULL,1,'2021-05-30 18:54:32','2021-05-30 18:54:32',NULL),(846,3150,40736,21641,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',197434.63,'BANCO',NULL,1,'2021-05-30 22:38:53','2021-05-30 22:38:53',NULL),(847,3150,40736,21642,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',166306.79,'BANCO',NULL,1,'2021-05-30 22:41:35','2021-05-30 22:41:35',NULL),(848,3150,40736,21639,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',483956.89,NULL,NULL,1,'2021-05-30 22:58:17','2021-05-30 22:58:17',NULL),(849,3150,40736,21644,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',3587.05,NULL,NULL,1,'2021-05-30 23:10:10','2021-05-30 23:10:10',NULL),(850,3150,40736,21647,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',242348.03,NULL,NULL,1,'2021-05-30 23:18:03','2021-05-30 23:18:03',NULL),(851,3150,40736,21641,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',314954.32,'Devengamiento',NULL,1,'2021-05-30 23:46:45','2021-05-30 23:46:45',NULL),(852,3150,40736,21650,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',342394.38,'Iva',NULL,1,'2021-05-31 00:26:07','2021-05-31 00:26:07',NULL),(853,3150,40736,21650,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',32312.83,'CAJA',NULL,1,'2021-05-31 00:39:14','2021-05-31 00:40:03','2021-05-31 00:40:03'),(858,3150,40720,1537,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',63825.00,NULL,NULL,1,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(859,3150,40720,1538,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',179570.00,NULL,NULL,1,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(860,3150,40720,1539,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',156706.00,NULL,NULL,1,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(861,3150,40720,1540,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',307058.00,NULL,NULL,1,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(862,3150,40720,1541,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',263850.98,NULL,NULL,1,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(863,3150,40720,1545,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',188494.00,NULL,NULL,1,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(864,3150,40720,1546,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',242257.98,NULL,NULL,1,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(865,3150,40720,1547,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',86977.98,NULL,NULL,1,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(866,3150,40720,1548,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',335000.00,NULL,NULL,1,'2021-05-31 13:14:21','2021-05-31 13:48:34','2021-05-31 13:48:34');
INSERT INTO `balance_libro` VALUES (867,3150,40720,1549,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',107314.00,NULL,NULL,1,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(868,3150,40720,1550,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',370126.50,NULL,NULL,1,'2021-05-31 13:14:21','2021-05-31 13:48:14','2021-05-31 13:48:14'),(869,3150,40720,1551,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',258848.50,NULL,NULL,1,'2021-05-31 13:14:21','2021-05-31 13:49:05','2021-05-31 13:49:05'),(870,3150,40720,1550,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',170126.50,NULL,NULL,1,'2021-05-31 13:48:14','2021-05-31 13:48:14',NULL),(871,3150,40720,1548,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',135000.00,NULL,NULL,1,'2021-05-31 13:48:34','2021-05-31 13:48:34',NULL),(872,3150,40720,1551,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',158848.50,NULL,NULL,1,'2021-05-31 13:49:05','2021-05-31 13:49:05',NULL),(873,3150,40736,21641,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',10929.05,'Ingresos Brutos',NULL,1,'2021-05-31 13:49:44','2021-05-31 13:49:44',NULL),(874,3150,40736,21642,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',31000.00,NULL,NULL,1,'2021-05-31 14:13:33','2021-05-31 14:13:33',NULL),(875,3150,40736,21643,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1000.00,NULL,NULL,1,'2021-05-31 14:28:15','2021-05-31 14:28:15',NULL),(876,3150,40736,21650,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',220821.46,'OTROS',NULL,1,'2021-05-31 14:36:00','2021-05-31 14:38:18','2021-05-31 14:38:18'),(877,3150,40720,1541,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1541870.49,'pagos',NULL,1,'2021-05-31 14:36:06','2021-05-31 14:36:06',NULL),(878,3150,40736,21650,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',220821.46,'OTROS',NULL,1,'2021-05-31 14:38:18','2021-05-31 14:39:03','2021-05-31 14:39:03'),(879,3150,40720,1551,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',130000.00,'cobros',NULL,1,'2021-05-31 14:41:36','2022-05-04 14:47:01','2022-05-04 14:47:01'),(880,3150,40736,21641,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',175.63,'Iva',NULL,1,'2021-05-31 14:45:49','2021-06-01 17:05:30','2021-06-01 17:05:30'),(881,3150,40736,21650,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',30000.00,NULL,NULL,1,'2021-05-31 14:48:28','2021-06-08 20:41:58','2021-06-08 20:41:58'),(882,3150,40736,21649,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',20000.00,NULL,NULL,1,'2021-05-31 14:49:22','2021-05-31 14:49:22',NULL),(883,3150,40736,21648,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',20000.00,NULL,NULL,1,'2021-05-31 14:49:51','2021-05-31 14:49:51',NULL),(884,3150,40736,21647,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',20000.00,NULL,NULL,1,'2021-05-31 14:50:17','2021-05-31 14:50:17',NULL),(885,3150,40736,21646,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',20000.00,NULL,NULL,1,'2021-05-31 14:50:41','2021-05-31 14:50:41',NULL),(886,3150,40736,21644,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',30000.00,NULL,NULL,1,'2021-05-31 14:51:02','2021-05-31 14:51:02',NULL),(887,3150,40736,21643,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',20000.00,NULL,NULL,1,'2021-05-31 14:51:24','2021-05-31 14:51:24',NULL),(888,3150,40736,21642,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',20000.00,NULL,NULL,1,'2021-05-31 14:51:43','2021-05-31 14:51:43',NULL),(889,3150,40736,21648,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1207687.00,NULL,NULL,1,'2021-05-31 19:17:06','2021-06-01 13:28:38','2021-06-01 13:28:38');
INSERT INTO `balance_libro` VALUES (890,3150,40736,21639,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',785821.08,NULL,NULL,1,'2021-06-01 13:21:22','2021-06-08 19:41:56','2021-06-08 19:41:56'),(891,3150,40736,21640,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',963566.60,NULL,NULL,1,'2021-06-01 13:25:49','2021-06-01 18:37:19','2021-06-01 18:37:19'),(892,3150,40736,21648,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1207687.00,NULL,NULL,1,'2021-06-01 13:28:38','2021-06-01 18:44:08','2021-06-01 18:44:08'),(893,3150,40736,21648,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',238325.54,'Cobranzas',NULL,1,'2021-06-01 13:37:32','2021-06-01 13:38:51','2021-06-01 13:38:51'),(894,3150,40736,21650,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',238325.54,'Cobranzas',NULL,1,'2021-06-01 13:38:51','2021-06-01 13:41:42','2021-06-01 13:41:42'),(895,3150,40736,21650,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',238327.57,'Cobranzas',NULL,1,'2021-06-01 13:41:42','2021-06-01 13:42:44','2021-06-01 13:42:44'),(900,3150,40736,21639,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',3203.91,'Ingresos Brutos',NULL,1,'2021-06-01 14:44:48','2021-06-01 15:12:29','2021-06-01 15:12:29'),(901,3150,40736,21641,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',3630.58,'Ingresos Brutos',NULL,1,'2021-06-01 14:46:33','2021-06-01 15:06:42','2021-06-01 15:06:42'),(902,3150,40736,21641,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',3630.58,'Ingresos Brutos',NULL,1,'2021-06-01 14:47:26','2021-06-01 14:47:26',NULL),(903,3150,40736,21641,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',3630.58,'Ingresos Brutos',NULL,1,'2021-06-01 14:47:26','2021-06-01 15:06:46','2021-06-01 15:06:46'),(904,3150,40736,21639,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',3203.91,'Ingresos Brutos',NULL,1,'2021-06-01 15:12:29','2021-06-01 18:18:21','2021-06-01 18:18:21'),(905,3150,40736,21639,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',4979.77,'Ingresos Brutos',NULL,1,'2021-06-01 15:19:01','2021-06-01 18:34:23','2021-06-01 18:34:23'),(906,3150,40736,21639,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',354893.05,NULL,NULL,1,'2021-06-01 15:53:01','2021-06-01 15:53:01',NULL),(907,3150,40736,21641,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',175.63,'Iva',NULL,1,'2021-06-01 17:05:30','2021-06-01 17:05:30',NULL),(908,3150,40736,21639,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',2611.27,'Ingresos Brutos',NULL,1,'2021-06-01 18:18:21','2021-06-01 18:38:42','2021-06-01 18:38:42'),(909,3150,40736,21639,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1918.82,NULL,NULL,1,'2021-06-01 18:32:50','2021-06-01 19:03:48','2021-06-01 19:03:48'),(910,3150,40736,21639,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',3849.06,'Ingresos Brutos',NULL,1,'2021-06-01 18:34:23','2021-06-01 18:35:08','2021-06-01 18:35:08'),(911,3150,40736,21639,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',3849.06,'Ingresos Brutos',NULL,1,'2021-06-01 18:35:08','2021-06-01 18:35:08',NULL),(912,3150,40736,21640,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',963566.60,NULL,NULL,1,'2021-06-01 18:37:19','2021-06-04 19:51:29','2021-06-04 19:51:29'),(913,3150,40736,21639,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',2611.27,'Ingresos Brutos',NULL,1,'2021-06-01 18:38:42','2021-06-01 18:39:02','2021-06-01 18:39:02'),(914,3150,40736,21639,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',2611.27,'Ingresos Brutos',NULL,1,'2021-06-01 18:39:02','2021-06-01 19:10:17','2021-06-01 19:10:17');
INSERT INTO `balance_libro` VALUES (915,3150,40736,21648,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1207687.00,NULL,NULL,1,'2021-06-01 18:44:08','2021-06-04 19:13:23','2021-06-04 19:13:23'),(917,3150,40736,21641,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',847789.16,'VENTAS',NULL,1,'2021-06-01 18:55:25','2021-06-08 19:44:37','2021-06-08 19:44:37'),(918,3150,40736,21639,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1918.82,NULL,NULL,1,'2021-06-01 19:03:48','2021-06-01 19:07:58','2021-06-01 19:07:58'),(919,3150,40736,21639,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1918.82,NULL,NULL,1,'2021-06-01 19:07:58','2021-06-01 19:12:42','2021-06-01 19:12:42'),(920,3150,40736,21639,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',2611.27,'Ingresos Brutos',NULL,1,'2021-06-01 19:10:17','2021-06-01 19:10:17',NULL),(921,3150,40736,21640,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',3206.12,'Ganancias',NULL,1,'2021-06-01 19:12:23','2021-06-01 19:12:23',NULL),(922,3150,40736,21639,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1918.82,'Iva',NULL,1,'2021-06-01 19:12:42','2021-06-01 19:12:42',NULL),(923,3150,40736,21649,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',63613.80,NULL,NULL,1,'2021-06-01 19:20:03','2021-06-01 19:20:03',NULL),(924,3150,40736,21640,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',2289.14,NULL,NULL,1,'2021-06-01 19:35:50','2021-06-01 19:35:50',NULL),(925,3150,40736,21647,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',181.47,NULL,NULL,1,'2021-06-01 19:42:57','2021-06-01 19:42:57',NULL),(926,3150,40736,21649,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',117068.71,NULL,NULL,1,'2021-06-02 14:42:41','2021-06-02 14:42:41',NULL),(927,3150,40736,21649,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',1483744.70,NULL,NULL,1,'2021-06-02 14:55:13','2021-06-02 14:55:13',NULL),(928,3150,40736,21648,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1207687.00,'VENTAS',NULL,1,'2021-06-04 19:12:25','2021-06-04 19:12:52','2021-06-04 19:12:52'),(929,3150,40736,21648,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1207687.00,NULL,NULL,1,'2021-06-04 19:13:23','2021-06-04 19:13:23',NULL),(930,3150,40736,21640,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',963566.60,NULL,NULL,1,'2021-06-04 19:51:29','2021-06-08 19:42:38','2021-06-08 19:42:38'),(931,3150,40736,21639,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',785821.08,NULL,NULL,1,'2021-06-08 19:41:56','2021-06-08 19:41:56',NULL),(932,3150,40736,21640,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',963566.60,NULL,NULL,1,'2021-06-08 19:42:38','2021-06-08 19:42:38',NULL),(933,3150,40736,21641,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',847789.16,'VENTAS',NULL,1,'2021-06-08 19:44:37','2021-06-08 19:44:37',NULL),(942,3150,40736,21639,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',309629.89,NULL,NULL,1,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(943,3150,40736,21640,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',94689.24,NULL,NULL,1,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(944,3150,40736,21641,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',73000.00,NULL,NULL,1,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(945,3150,40736,21642,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',94689.24,NULL,NULL,1,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(946,3150,40736,21645,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',139000.00,NULL,NULL,1,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL);
INSERT INTO `balance_libro` VALUES (947,3150,40736,21648,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1783676.50,NULL,NULL,1,'2021-06-08 20:05:44','2021-06-08 20:25:09','2021-06-08 20:25:09'),(948,3150,40736,21639,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',593104.16,NULL,NULL,1,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(950,3150,40736,21640,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',917552.70,'Compras',NULL,1,'2021-06-08 20:14:19','2021-06-08 20:14:19',NULL),(951,3150,40736,21641,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',871011.82,NULL,NULL,1,'2021-06-08 20:14:51','2021-06-08 20:14:51',NULL),(952,3150,40736,21650,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',1129902.84,'Cobranzas',NULL,1,'2021-06-08 20:22:24','2021-06-08 20:22:24',NULL),(953,3150,40736,21648,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',565921.44,NULL,NULL,1,'2021-06-08 20:27:16','2021-06-08 20:27:16',NULL),(954,3150,40736,21650,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',30000.00,NULL,NULL,1,'2021-06-08 20:41:58','2021-06-08 20:46:59','2021-06-08 20:46:59'),(955,3150,40736,21650,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',30000.00,NULL,NULL,1,'2021-06-08 20:46:59','2021-06-08 20:48:43','2021-06-08 20:48:43'),(956,3150,40736,21650,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',30000.00,'Sueldos',NULL,1,'2021-06-08 20:52:13','2021-06-08 20:52:13',NULL),(957,3150,40720,1551,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',53334.63,'Ajuste por inflación cuentas patrimoniales',NULL,1,'2021-06-10 14:42:11','2021-06-10 14:42:11',NULL),(958,3150,40720,1551,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',1135265.32,'Ajuste por inflación',NULL,1,'2021-06-10 14:46:08','2022-05-04 14:47:34','2022-05-04 14:47:34'),(959,3150,40720,1537,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',1088.63,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(960,3150,40720,1537,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',435810.68,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(961,3150,40720,1537,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',268042.50,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(962,3150,40720,1537,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',764.92,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(963,3150,40720,1537,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',4353.58,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(964,3150,40720,1537,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',1097.95,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(965,3150,40720,1537,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',595.20,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(966,3150,40720,1537,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',2162.54,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(967,3150,40720,1537,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',20900.87,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(968,3150,40720,1537,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',4546.94,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL);
INSERT INTO `balance_libro` VALUES (969,3150,40720,1537,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',2041.84,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(970,3150,40720,1537,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',41813.50,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(971,3150,40720,1537,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',13074.32,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(972,3150,40720,1537,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',2777.21,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(973,3150,40720,1537,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',494.69,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(974,3150,40720,1537,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',205412.16,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(975,3150,40720,1537,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',502.11,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(976,3150,40720,1537,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-31','2018-08-31',2134.19,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(977,3150,40720,1538,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',2535.26,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(978,3150,40720,1538,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',94119.34,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(979,3150,40720,1538,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',64.81,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(980,3150,40720,1538,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',1969.64,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(981,3150,40720,1538,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',332.91,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(982,3150,40720,1538,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',990.41,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(983,3150,40720,1538,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',3140.75,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(984,3150,40720,1538,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',241548.50,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(985,3150,40720,1538,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',390999.26,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(986,3150,40720,1538,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',30235.96,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(987,3150,40720,1538,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',11729.97,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(988,3150,40720,1538,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',7108.54,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL);
INSERT INTO `balance_libro` VALUES (989,3150,40720,1538,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',165.29,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(990,3150,40720,1538,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',1465.50,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(991,3150,40720,1538,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',337.89,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(992,3150,40720,1538,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-09-30','2018-09-30',1737.64,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(993,3150,40720,1539,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',308121.03,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(994,3150,40720,1539,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',93052.26,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(995,3150,40720,1539,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',97.72,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(996,3150,40720,1539,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',320.62,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(997,3150,40720,1539,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',2560.72,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(998,3150,40720,1539,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',6124.82,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(999,3150,40720,1539,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',793.57,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1000,3150,40720,1539,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',510.74,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1001,3150,40720,1539,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',30509.47,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1002,3150,40720,1539,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',9243.63,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1003,3150,40720,1539,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',180130.10,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1004,3150,40720,1539,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',990.73,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1005,3150,40720,1539,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',1933.72,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1006,3150,40720,1539,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',336.82,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1007,3150,40720,1539,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-10-31','2018-10-31',1668.84,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1008,3150,40720,1540,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',308.29,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL);
INSERT INTO `balance_libro` VALUES (1009,3150,40720,1540,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',596.13,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1010,3150,40720,1540,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',446.85,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1011,3150,40720,1540,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',778.52,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1012,3150,40720,1540,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',23370.46,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1013,3150,40720,1540,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',966.65,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1014,3150,40720,1540,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',9551.53,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1015,3150,40720,1540,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',318384.36,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1016,3150,40720,1540,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',1508.45,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1017,3150,40720,1540,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',11027.90,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1018,3150,40720,1540,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',219.93,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1019,3150,40720,1540,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',1127.75,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1020,3150,40720,1540,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',2368.11,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1021,3150,40720,1540,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',250465.04,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1022,3150,40720,1540,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',76328.53,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1023,3150,40720,1540,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',583.81,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1024,3150,40720,1540,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-11-30','2018-11-30',154.60,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1025,3150,40720,1541,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',4036.91,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1026,3150,40720,1541,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',793.56,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1027,3150,40720,1541,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',501.90,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1028,3150,40720,1541,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',5019.00,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL);
INSERT INTO `balance_libro` VALUES (1029,3150,40720,1541,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',1232.85,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1030,3150,40720,1541,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',30235.43,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1031,3150,40720,1541,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',8348.89,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1032,3150,40720,1541,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',291.60,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1033,3150,40720,1541,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',182010.68,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1034,3150,40720,1541,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',100719.26,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1035,3150,40720,1541,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',1882.08,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1036,3150,40720,1541,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',273.05,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1037,3150,40720,1541,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',2664.63,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1038,3150,40720,1541,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',651.56,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1039,3150,40720,1541,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',93372.25,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1040,3150,40720,1541,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',72.74,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1041,3150,40720,1541,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-12-31','2018-12-31',278296.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1042,3150,40720,1545,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',287.52,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1043,3150,40720,1545,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',372.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1044,3150,40720,1545,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',16188.01,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1045,3150,40720,1545,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',7620.63,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1046,3150,40720,1545,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',2035.49,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1047,3150,40720,1545,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',160782.10,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1048,3150,40720,1545,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',254021.01,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL);
INSERT INTO `balance_libro` VALUES (1049,3150,40720,1545,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',1088.89,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1050,3150,40720,1545,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',806.37,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1051,3150,40720,1545,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',4920.96,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1052,3150,40720,1545,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',593.56,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1053,3150,40720,1545,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',58272.15,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1054,3150,40720,1545,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',51.97,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1055,3150,40720,1545,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',102.29,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1056,3150,40720,1545,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',1412.31,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1057,3150,40720,1545,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',4312.42,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1058,3150,40720,1546,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',228.70,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1059,3150,40720,1546,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',1131.92,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1060,3150,40720,1546,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',127490.15,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1061,3150,40720,1546,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',12202.90,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1062,3150,40720,1546,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',5568.63,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1063,3150,40720,1546,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',3520.26,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1064,3150,40720,1546,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',399.58,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1065,3150,40720,1546,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',89.22,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1066,3150,40720,1546,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',547.92,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1067,3150,40720,1546,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',41933.09,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1068,3150,40720,1546,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',38.01,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL);
INSERT INTO `balance_libro` VALUES (1069,3150,40720,1546,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',34.05,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1070,3150,40720,1546,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',185621.12,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1071,3150,40720,1547,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',616.39,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1072,3150,40720,1547,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',356.42,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1073,3150,40720,1547,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',158.86,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1074,3150,40720,1547,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',9404.02,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1075,3150,40720,1547,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',4129.22,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1076,3150,40720,1547,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',137640.73,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1077,3150,40720,1547,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',249.61,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1078,3150,40720,1547,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',1845.75,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1079,3150,40720,1547,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',1540.33,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1080,3150,40720,1547,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',2862.84,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1081,3150,40720,1547,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',1273.20,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1082,3150,40720,1547,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',159.58,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1083,3150,40720,1547,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',31846.81,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1084,3150,40720,1547,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',36.98,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1085,3150,40720,1547,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',2274.90,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1086,3150,40720,1547,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',66671.88,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1087,3150,40720,1547,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',74.63,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1088,3150,40720,1548,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',186.07,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL);
INSERT INTO `balance_libro` VALUES (1089,3150,40720,1548,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',316.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1090,3150,40720,1548,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',7905.29,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1091,3150,40720,1548,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',3131.48,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1092,3150,40720,1548,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',654.95,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1093,3150,40720,1548,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',147.21,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1094,3150,40720,1548,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',442.09,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1095,3150,40720,1548,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',284.81,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1096,3150,40720,1548,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',932.85,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1097,3150,40720,1548,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',59293.27,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1098,3150,40720,1548,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',140.77,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1099,3150,40720,1548,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',26178.08,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1100,3150,40720,1548,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',29.04,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1101,3150,40720,1548,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',232.14,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1102,3150,40720,1548,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',322.02,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1103,3150,40720,1548,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',252.37,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1104,3150,40720,1548,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',104382.65,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1105,3150,40720,1549,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',4473.14,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1106,3150,40720,1549,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',1727.88,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1107,3150,40720,1549,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',650.86,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1108,3150,40720,1549,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',25552.68,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL);
INSERT INTO `balance_libro` VALUES (1109,3150,40720,1549,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',66.35,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1110,3150,40720,1549,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',57596.08,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1111,3150,40720,1549,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',659.73,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1112,3150,40720,1549,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',191.83,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1113,3150,40720,1549,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',104.04,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1114,3150,40720,1549,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',15164.67,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1115,3150,40720,1549,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',19.49,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1116,3150,40720,1549,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',26.03,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1117,3150,40720,1549,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',157.94,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1118,3150,40720,1549,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',639.03,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1119,3150,40720,1549,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',129.37,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1120,3150,40720,1549,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',33.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1121,3150,40720,1549,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',232.29,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1122,3150,40720,1550,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',3387.38,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1123,3150,40720,1550,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',16861.13,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1124,3150,40720,1550,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',908.40,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1125,3150,40720,1550,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',175.83,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1126,3150,40720,1550,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',45.96,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1127,3150,40720,1550,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',121.41,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1128,3150,40720,1550,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',20.78,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL);
INSERT INTO `balance_libro` VALUES (1129,3150,40720,1550,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',11837.33,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1130,3150,40720,1550,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',210.23,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1131,3150,40720,1550,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',6.07,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1132,3150,40720,1550,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',122.65,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1133,3150,40720,1550,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',47.21,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1134,3150,40720,1550,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',174.66,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1135,3150,40720,1550,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',30279.92,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1136,3150,40720,1550,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',270.38,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(1137,3150,40737,23176,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',11593246.28,'Ventas mensuales',NULL,1,'2021-06-22 17:23:03','2021-06-24 20:22:54','2021-06-24 20:22:54'),(1138,3150,40737,23176,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',7364113.37,'Apertura',NULL,1,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10'),(1139,3150,40737,23177,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',4974249.46,'Ventas mensuales',NULL,1,'2021-06-22 17:36:42','2021-06-22 17:36:42',NULL),(1140,3150,40737,23181,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',5705855.28,'Ventas mensuales',NULL,1,'2021-06-22 17:38:14','2021-06-22 17:38:14',NULL),(1141,3150,40737,23182,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',5896543.00,'Ventas mensuales',NULL,1,'2021-06-22 17:39:24','2021-06-22 17:39:24',NULL),(1142,3150,40737,23183,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',8696054.79,'Ventas mensuales',NULL,1,'2021-06-22 17:40:30','2021-06-22 17:40:30',NULL),(1143,3150,40737,23184,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',12458153.76,'Ventas mensuales',NULL,1,'2021-06-22 17:44:18','2021-06-22 17:44:18',NULL),(1144,3150,40737,23185,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',12979459.96,'Ventas mensuales',NULL,1,'2021-06-22 17:46:07','2021-06-22 17:46:07',NULL),(1145,3150,40737,23186,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',10368334.02,'Ventas mensuales',NULL,1,'2021-06-22 17:53:36','2021-06-22 17:53:36',NULL),(1146,3150,40737,23187,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',11273915.61,'Ventas mensuales',NULL,1,'2021-06-22 17:55:06','2021-06-22 17:55:06',NULL),(1147,3150,40737,23188,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',11200610.96,'Ventas mensuales',NULL,1,'2021-06-22 18:02:26','2021-06-22 18:02:26',NULL),(1148,3150,40737,23189,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',11593246.28,'Ventas mensuales',NULL,1,'2021-06-22 18:03:35','2021-06-22 18:03:35',NULL),(1149,3150,40737,23190,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',14049022.10,'Ventas mensuales',NULL,1,'2021-06-22 18:04:36','2021-06-22 18:04:36',NULL);
INSERT INTO `balance_libro` VALUES (1150,3150,40737,23176,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1194009.41,NULL,NULL,1,'2021-06-22 18:11:32','2021-06-22 18:11:32',NULL),(1151,3150,40737,23176,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',6952127.19,'Compras',NULL,1,'2021-06-22 18:24:40','2021-06-24 17:54:55','2021-06-24 17:54:55'),(1152,3150,40737,23177,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',3780393.91,'Compras',NULL,1,'2021-06-22 18:37:30','2021-06-24 17:58:10','2021-06-24 17:58:10'),(1153,3150,40737,23181,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',5278356.05,'Compras',NULL,1,'2021-06-22 18:43:28','2021-06-24 18:00:01','2021-06-24 18:00:01'),(1154,3150,40737,23182,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',5467817.24,'Compras',NULL,1,'2021-06-22 18:47:31','2021-06-24 18:01:56','2021-06-24 18:01:56'),(1155,3150,40737,23183,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',11529640.70,'Compras',NULL,1,'2021-06-22 18:52:20','2021-06-22 19:10:55','2021-06-22 19:10:55'),(1156,3150,40737,23185,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',11811157.19,'Compras',NULL,1,'2021-06-22 18:57:19','2021-06-24 18:12:11','2021-06-24 18:12:11'),(1157,3150,40737,23186,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',10076443.91,'Compras',NULL,1,'2021-06-22 19:03:01','2021-06-24 18:29:16','2021-06-24 18:29:16'),(1158,3150,40737,23187,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',12385521.16,'Compras',NULL,1,'2021-06-22 19:08:29','2021-06-24 18:33:16','2021-06-24 18:33:16'),(1159,3150,40737,23187,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',12385521.16,'Compras',NULL,1,'2021-06-22 19:08:29','2021-06-22 19:08:43','2021-06-22 19:08:43'),(1160,3150,40737,23184,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',11529640.70,'Compras',NULL,1,'2021-06-22 19:10:55','2021-06-24 18:06:20','2021-06-24 18:06:20'),(1161,3150,40737,23183,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',8198457.67,'Compras',NULL,1,'2021-06-22 19:13:44','2021-06-24 18:03:23','2021-06-24 18:03:23'),(1162,3150,40737,23188,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',10201770.32,'Compras',NULL,1,'2021-06-22 19:17:49','2021-06-24 18:35:56','2021-06-24 18:35:56'),(1163,3150,40737,23188,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',12113815.75,'Compras',NULL,1,'2021-06-22 19:21:34','2021-06-22 19:25:46','2021-06-22 19:25:46'),(1164,3150,40737,23190,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',15256415.60,'Compras',NULL,1,'2021-06-22 19:25:13','2021-06-24 18:40:20','2021-06-24 18:40:20'),(1165,3150,40737,23189,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',12113815.75,'Compras',NULL,1,'2021-06-22 19:25:46','2021-06-22 19:26:42','2021-06-22 19:26:42'),(1166,3150,40737,23189,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',12113815.75,'Compras',NULL,1,'2021-06-22 19:26:42','2021-06-24 18:38:02','2021-06-24 18:38:02'),(1167,3150,40737,23176,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',12687.53,'Ganancias',NULL,1,'2021-06-22 19:30:33','2021-06-22 19:37:42','2021-06-22 19:37:42'),(1168,3150,40737,23177,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',3981.27,'Ganancias',NULL,1,'2021-06-22 19:31:33','2021-06-22 19:37:36','2021-06-22 19:37:36'),(1169,3150,40737,23181,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',4870.10,'Ganancias',NULL,1,'2021-06-22 19:32:17','2021-06-22 19:37:27','2021-06-22 19:37:27'),(1170,3150,40737,23182,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',5481.28,'Ganancias',NULL,1,'2021-06-22 19:33:05','2021-06-22 19:37:14','2021-06-22 19:37:14');
INSERT INTO `balance_libro` VALUES (1171,3150,40737,23183,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',5434.35,'Ganancias',NULL,1,'2021-06-22 19:34:03','2021-06-22 19:37:05','2021-06-22 19:37:05'),(1172,3150,40737,23184,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',16362.12,'Ganancias',NULL,1,'2021-06-22 19:34:45','2021-06-22 19:35:13','2021-06-22 19:35:13'),(1173,3150,40737,23184,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',2549.76,'Ganancias',NULL,1,'2021-06-22 19:35:13','2021-06-22 19:36:55','2021-06-22 19:36:55'),(1174,3150,40737,23185,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',16362.12,'Ganancias',NULL,1,'2021-06-22 19:36:38','2021-06-22 19:36:38',NULL),(1175,3150,40737,23184,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',2549.76,'Ganancias',NULL,1,'2021-06-22 19:36:55','2021-06-22 19:36:55',NULL),(1176,3150,40737,23183,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',5434.35,'Ganancias',NULL,1,'2021-06-22 19:37:05','2021-06-22 19:37:05',NULL),(1177,3150,40737,23182,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',5481.28,'Ganancias',NULL,1,'2021-06-22 19:37:14','2021-06-22 19:37:14',NULL),(1178,3150,40737,23181,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',4870.10,'Ganancias',NULL,1,'2021-06-22 19:37:27','2021-06-22 19:37:27',NULL),(1179,3150,40737,23177,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',3981.27,'Ganancias',NULL,1,'2021-06-22 19:37:36','2021-06-22 19:37:36',NULL),(1180,3150,40737,23176,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',12687.53,'Ganancias',NULL,1,'2021-06-22 19:37:42','2021-06-22 19:37:42',NULL),(1181,3150,40737,23186,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',15308.59,'Ganancias',NULL,1,'2021-06-22 19:38:37','2021-06-22 19:38:37',NULL),(1182,3150,40737,23187,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',41291.82,'Ganancias',NULL,1,'2021-06-22 19:39:22','2021-06-22 19:39:22',NULL),(1183,3150,40737,23189,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',6419.12,'Ganancias',NULL,1,'2021-06-22 19:40:23','2021-06-22 19:40:23',NULL),(1184,3150,40737,23190,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',27218.35,'Ganancias',NULL,1,'2021-06-22 19:41:12','2021-06-22 19:41:12',NULL),(1185,3150,40737,23176,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',19342.23,'Pagos',NULL,1,'2021-06-22 19:43:54','2021-06-22 19:43:54',NULL),(1186,3150,40737,23176,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',84681.33,'Iva',NULL,1,'2021-06-22 19:45:09','2021-06-22 19:45:09',NULL),(1187,3150,40737,23177,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',574139.92,'Iva',NULL,1,'2021-06-22 19:46:18','2021-06-22 19:47:10','2021-06-22 19:47:10'),(1188,3150,40737,23177,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',574139.92,'Iva',NULL,1,'2021-06-22 19:47:10','2021-06-22 19:47:27','2021-06-22 19:47:27'),(1189,3150,40737,23176,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',574139.92,'Iva',NULL,1,'2021-06-22 19:47:27','2021-06-22 19:47:27',NULL),(1190,3150,40737,23177,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',134938.51,'Iva',NULL,1,'2021-06-22 19:48:25','2021-06-22 19:48:25',NULL),(1191,3150,40737,23177,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',22734.02,'Pagos',NULL,1,'2021-06-22 19:54:31','2021-06-22 19:54:31',NULL),(1192,3150,40737,23181,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',142347.04,'Iva',NULL,1,'2021-06-22 19:56:47','2021-06-22 19:56:47',NULL),(1193,3150,40737,23181,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',19342.23,'Pagos',NULL,1,'2021-06-22 19:57:50','2021-06-22 19:57:50',NULL);
INSERT INTO `balance_libro` VALUES (1194,3150,40737,23182,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',64175.83,'Iva',NULL,1,'2021-06-22 20:00:07','2021-06-22 20:00:07',NULL),(1195,3150,40737,23182,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',19342.23,'Pagos',NULL,1,'2021-06-22 20:01:48','2021-06-22 20:03:59','2021-06-22 20:03:59'),(1196,3150,40737,23183,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',74413.16,'Iva',NULL,1,'2021-06-22 20:02:39','2021-06-22 20:02:39',NULL),(1197,3150,40737,23184,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',19342.23,'Pagos',NULL,1,'2021-06-22 20:03:38','2021-06-22 20:03:38',NULL),(1198,3150,40737,23182,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',19342.23,'Pagos',NULL,1,'2021-06-22 20:03:59','2021-06-22 20:03:59',NULL),(1199,3150,40737,23184,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',36657.59,'Iva',NULL,1,'2021-06-22 20:05:10','2021-06-22 20:05:10',NULL),(1200,3150,40737,23185,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',203795.69,'Iva',NULL,1,'2021-06-22 20:09:34','2021-06-22 20:09:34',NULL),(1201,3150,40737,23186,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',181022.56,'Iva',NULL,1,'2021-06-22 20:10:19','2021-06-22 20:10:19',NULL),(1202,3150,40737,23187,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',42575.47,'Iva',NULL,1,'2021-06-22 20:11:00','2021-06-22 20:11:00',NULL),(1203,3150,40737,23188,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',92310.12,'Iva',NULL,1,'2021-06-22 20:11:55','2021-06-22 20:11:55',NULL),(1204,3150,40737,23189,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',94415.48,'Iva',NULL,1,'2021-06-22 20:13:36','2021-06-22 20:13:36',NULL),(1205,3150,40737,23190,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',92310.12,'Pagos',NULL,1,'2021-06-22 20:14:20','2021-06-22 20:14:20',NULL),(1206,3150,40737,23185,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',19276.71,'Ingresos Brutos',NULL,1,'2021-06-22 20:15:49','2021-06-22 20:15:49',NULL),(1207,3150,40737,23186,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',36726.42,'Ingresos Brutos',NULL,1,'2021-06-22 20:17:22','2021-06-22 20:17:22',NULL),(1208,3150,40737,23187,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',90455.76,'Ingresos Brutos',NULL,1,'2021-06-22 20:18:19','2021-06-22 20:18:19',NULL),(1209,3150,40737,23188,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',66547.49,'Ingresos Brutos',NULL,1,'2021-06-22 20:19:06','2021-06-22 20:19:06',NULL),(1210,3150,40737,23189,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',25456.49,'Ingresos Brutos',NULL,1,'2021-06-22 20:20:00','2021-06-22 20:20:00',NULL),(1211,3150,40737,23190,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',36405.65,'Ingresos Brutos',NULL,1,'2021-06-22 20:21:08','2021-06-22 20:21:08',NULL),(1212,3150,40737,23176,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',5914897.04,'BANCO',NULL,1,'2021-06-22 21:54:03','2021-06-27 23:21:38','2021-06-27 23:21:38'),(1213,3150,40737,23177,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',4709574.24,'BANCO',NULL,1,'2021-06-22 22:01:43','2021-06-27 18:18:48','2021-06-27 18:18:48'),(1214,3150,40737,23181,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',4761202.50,'BANCO',NULL,1,'2021-06-22 22:13:13','2021-06-27 23:23:47','2021-06-27 23:23:47'),(1215,3150,40737,23182,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',4040939.94,'BANCO',NULL,1,'2021-06-22 22:16:19','2021-06-27 23:25:37','2021-06-27 23:25:37'),(1216,3150,40737,23183,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',5375660.27,'BANCO',NULL,1,'2021-06-22 22:20:13','2021-06-27 18:18:16','2021-06-27 18:18:16');
INSERT INTO `balance_libro` VALUES (1217,3150,40737,23184,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',7992822.26,'BANCO',NULL,1,'2021-06-22 22:27:41','2021-06-27 23:27:20','2021-06-27 23:27:20'),(1218,3150,40737,23185,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',9556886.51,'BANCO',NULL,1,'2021-06-22 22:30:19','2021-06-27 23:28:18','2021-06-27 23:28:18'),(1219,3150,40737,23186,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',10283335.28,'BANCO',NULL,1,'2021-06-22 22:33:51','2021-06-27 18:17:41','2021-06-27 18:17:41'),(1220,3150,40737,23187,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',11424984.84,'BANCO',NULL,1,'2021-06-22 22:36:23','2021-06-27 18:17:00','2021-06-27 18:17:00'),(1221,3150,40737,23188,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',6855004.57,'BANCO',NULL,1,'2021-06-22 22:39:03','2021-06-25 13:28:12','2021-06-25 13:28:12'),(1222,3150,40737,23189,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',10306740.79,'BANCO',NULL,1,'2021-06-22 22:41:29','2021-06-27 18:15:38','2021-06-27 18:15:38'),(1223,3150,40737,23190,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',10806860.96,'BANCO',NULL,1,'2021-06-22 22:44:36','2021-06-24 19:11:43','2021-06-24 19:11:43'),(1224,3150,40737,23176,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1416974.38,'Iva',NULL,1,'2021-06-22 23:08:34','2021-06-22 23:09:28','2021-06-22 23:09:28'),(1225,3150,40737,23176,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1416974.38,'Iva',NULL,1,'2021-06-22 23:09:28','2021-06-22 23:09:28',NULL),(1226,3150,40737,23177,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',819214.02,'Iva',NULL,1,'2021-06-22 23:11:28','2021-06-24 20:28:40','2021-06-24 20:28:40'),(1227,3150,40737,23181,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',989884.86,'Iva',NULL,1,'2021-06-22 23:13:02','2021-06-24 20:34:32','2021-06-24 20:34:32'),(1228,3150,40737,23182,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1013496.27,'Iva',NULL,1,'2021-06-22 23:14:51','2021-06-22 23:14:51',NULL),(1229,3150,40737,23183,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1507566.53,'Iva',NULL,1,'2021-06-22 23:17:21','2021-06-22 23:17:21',NULL),(1230,3150,40737,23184,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',2143731.95,'Iva',NULL,1,'2021-06-22 23:19:02','2021-06-22 23:19:02',NULL),(1231,3150,40737,23185,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',2217177.43,'Iva',NULL,1,'2021-06-22 23:20:31','2021-06-22 23:20:31',NULL),(1232,3150,40737,23186,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1778453.21,'Iva',NULL,1,'2021-06-22 23:21:54','2021-06-24 20:37:53','2021-06-24 20:37:53'),(1233,3150,40737,23187,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',2034517.11,'Iva',NULL,1,'2021-06-22 23:25:42','2021-06-22 23:25:42',NULL),(1234,3150,40737,23188,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1943907.69,'Iva',NULL,1,'2021-06-22 23:42:13','2021-06-22 23:42:13',NULL),(1235,3150,40737,23189,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',2086616.55,'Iva',NULL,1,'2021-06-22 23:48:17','2021-06-22 23:48:17',NULL),(1236,3150,40737,23190,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',2641864.06,'Iva',NULL,1,'2021-06-23 00:09:12','2021-06-27 18:05:17','2021-06-27 18:05:17'),(1237,3150,40737,23176,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1333514.35,'Ingresos Brutos',NULL,1,'2021-06-23 02:22:55','2021-06-23 02:26:28','2021-06-23 02:26:28'),(1238,3150,40737,23176,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1333514.35,'Ingresos Brutos',NULL,1,'2021-06-23 02:26:28','2021-06-23 04:33:58','2021-06-23 04:33:58');
INSERT INTO `balance_libro` VALUES (1239,3150,40737,23181,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1374097.07,'Ingresos Brutos',NULL,1,'2021-06-23 04:05:51','2021-06-23 04:34:52','2021-06-23 04:34:52'),(1240,3150,40737,23182,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1513959.53,'Ingresos Brutos',NULL,1,'2021-06-23 04:12:54','2021-06-23 04:35:30','2021-06-23 04:35:30'),(1241,3150,40737,23184,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1968125.99,'Ingresos Brutos',NULL,1,'2021-06-23 04:16:54','2021-06-23 04:17:14','2021-06-23 04:17:14'),(1242,3150,40737,23185,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1968125.99,'Ingresos Brutos',NULL,1,'2021-06-23 04:17:14','2021-06-23 04:36:09','2021-06-23 04:36:09'),(1243,3150,40737,23186,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2385110.49,'Ingresos Brutos',NULL,1,'2021-06-23 04:20:32','2021-06-23 04:36:41','2021-06-23 04:36:41'),(1244,3150,40737,23189,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3143650.35,'Ingresos Brutos',NULL,1,'2021-06-23 04:24:55','2021-06-23 04:37:14','2021-06-23 04:37:14'),(1245,3150,40737,23190,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3053527.16,'Ingresos Brutos',NULL,1,'2021-06-23 04:29:50','2021-06-23 04:37:49','2021-06-23 04:37:49'),(1246,3150,40737,23176,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1333514.35,'Ingresos Brutos',NULL,1,'2021-06-23 04:33:58','2021-06-23 04:33:58',NULL),(1247,3150,40737,23181,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1374097.07,'Ingresos Brutos',NULL,1,'2021-06-23 04:34:52','2021-06-27 00:02:47','2021-06-27 00:02:47'),(1248,3150,40737,23182,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1513959.53,'Ingresos Brutos',NULL,1,'2021-06-23 04:35:30','2021-06-27 00:06:36','2021-06-27 00:06:36'),(1249,3150,40737,23185,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1968125.99,'Ingresos Brutos',NULL,1,'2021-06-23 04:36:09','2021-06-27 02:58:06','2021-06-27 02:58:06'),(1250,3150,40737,23186,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2385110.49,'Ingresos Brutos',NULL,1,'2021-06-23 04:36:41','2021-06-23 04:36:41',NULL),(1251,3150,40737,23189,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3143650.35,'Ingresos Brutos',NULL,1,'2021-06-23 04:37:14','2021-06-27 01:13:39','2021-06-27 01:13:39'),(1252,3150,40737,23190,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3053527.16,'Ingresos Brutos',NULL,1,'2021-06-23 04:37:49','2021-06-27 01:15:20','2021-06-27 01:15:20'),(1253,3150,40737,23176,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',7283493.19,'Compras',NULL,1,'2021-06-24 17:54:55','2021-06-25 15:28:06','2021-06-25 15:28:06'),(1254,3150,40737,23177,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',3780393.91,'Compras',NULL,1,'2021-06-24 17:58:10','2021-06-24 17:58:10',NULL),(1255,3150,40737,23181,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',5278356.05,'Compras',NULL,1,'2021-06-24 18:00:01','2021-06-25 15:22:27','2021-06-25 15:22:27'),(1256,3150,40737,23182,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',5467817.24,'Compras',NULL,1,'2021-06-24 18:01:56','2021-06-25 15:18:26','2021-06-25 15:18:26'),(1257,3150,40737,23183,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',8198457.67,'Compras',NULL,1,'2021-06-24 18:03:23','2021-06-24 18:03:23',NULL),(1258,3150,40737,23184,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',11529640.70,'Compras',NULL,1,'2021-06-24 18:06:20','2021-06-25 15:14:38','2021-06-25 15:14:38'),(1259,3150,40737,23185,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',11811157.19,'Compras',NULL,1,'2021-06-24 18:12:11','2021-06-25 15:05:23','2021-06-25 15:05:23');
INSERT INTO `balance_libro` VALUES (1260,3150,40737,23186,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',10591607.33,'Compras',NULL,1,'2021-06-24 18:29:16','2021-06-25 15:01:47','2021-06-25 15:01:47'),(1261,3150,40737,23187,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',12385521.16,'Compras',NULL,1,'2021-06-24 18:33:16','2021-06-25 14:57:02','2021-06-25 14:57:02'),(1262,3150,40737,23188,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',10201770.32,'Compras',NULL,1,'2021-06-24 18:35:56','2021-06-25 14:06:13','2021-06-25 14:06:13'),(1263,3150,40737,23189,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',12113815.75,'Compras',NULL,1,'2021-06-24 18:38:02','2021-06-25 14:00:59','2021-06-25 14:00:59'),(1264,3150,40737,23190,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',15256415.60,'Compras',NULL,1,'2021-06-24 18:40:20','2021-06-24 18:40:20',NULL),(1265,3150,40737,23176,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',7364113.37,'Apertura',NULL,1,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45'),(1266,3150,40737,23190,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',10806771.05,'BANCO',NULL,1,'2021-06-24 19:11:43','2021-06-24 19:14:59','2021-06-24 19:14:59'),(1267,3150,40737,23190,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',10806860.96,'BANCO',NULL,1,'2021-06-24 19:14:59','2021-06-24 19:16:51','2021-06-24 19:16:51'),(1268,3150,40737,23190,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',10806860.96,'BANCO',NULL,1,'2021-06-24 19:16:51','2021-06-24 19:21:49','2021-06-24 19:21:49'),(1269,3150,40737,23190,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',10806860.96,'BANCO',NULL,1,'2021-06-24 19:21:49','2021-06-24 19:23:45','2021-06-24 19:23:45'),(1270,3150,40737,23190,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',10806860.96,'BANCO',NULL,1,'2021-06-24 19:23:45','2021-06-27 18:28:51','2021-06-27 18:28:51'),(1271,3150,40737,23190,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',89.91,'ajuste',NULL,1,'2021-06-24 19:28:15','2021-06-24 19:28:15',NULL),(1272,3150,40737,23176,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',8184471.47,'Ventas mensuales',NULL,1,'2021-06-24 20:22:54','2021-06-24 20:22:54',NULL),(1273,3150,40737,23177,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',819214.17,'Iva',NULL,1,'2021-06-24 20:28:40','2021-06-24 20:30:57','2021-06-24 20:30:57'),(1274,3150,40737,23177,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',819214.17,'Iva',NULL,1,'2021-06-24 20:30:57','2021-06-24 20:30:57',NULL),(1275,3150,40737,23181,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',989884.87,'Iva',NULL,1,'2021-06-24 20:34:32','2021-06-24 20:34:32',NULL),(1276,3150,40737,23186,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',1778453.23,'Iva',NULL,1,'2021-06-24 20:37:53','2021-06-24 20:37:53',NULL),(1277,3150,40737,23190,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',37584320.89,'Cobranzas',NULL,1,'2021-06-24 22:42:32','2021-06-24 22:44:23','2021-06-24 22:44:23'),(1278,3150,40737,23190,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',37584320.88,'Cobranzas',NULL,1,'2021-06-24 22:44:23','2021-06-24 22:45:03','2021-06-24 22:45:03'),(1279,3150,40737,23190,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',37584320.90,'Cobranzas',NULL,1,'2021-06-24 22:45:03','2021-06-25 13:32:27','2021-06-25 13:32:27'),(1280,3150,40737,23190,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',35258200.30,'Pagos',NULL,1,'2021-06-24 22:55:45','2021-06-24 22:59:24','2021-06-24 22:59:24');
INSERT INTO `balance_libro` VALUES (1281,3150,40737,23190,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',37020279.20,'Pagos',NULL,1,'2021-06-24 22:59:24','2021-06-25 13:39:17','2021-06-25 13:39:17'),(1282,3150,40737,23188,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',6855004.57,'BANCO',NULL,1,'2021-06-25 13:28:12','2021-06-27 18:16:23','2021-06-27 18:16:23'),(1283,3150,40737,23190,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',0.01,'Cobranzas',NULL,1,'2021-06-25 13:32:27','2021-06-25 13:36:23','2021-06-25 13:36:23'),(1284,3150,40737,23190,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',353810.00,'Cobranzas',NULL,1,'2021-06-25 13:34:23','2021-06-25 13:34:23',NULL),(1285,3150,40737,23190,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',35798571.90,'Cobranzas',NULL,1,'2021-06-25 13:36:23','2021-06-27 23:48:12','2021-06-27 23:48:12'),(1286,3150,40737,23190,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',34739524.70,'Pagos',NULL,1,'2021-06-25 13:39:17','2021-06-25 13:41:08','2021-06-25 13:41:08'),(1287,3150,40737,23190,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',34739524.73,'Pagos',NULL,1,'2021-06-25 13:41:08','2021-06-25 13:41:47','2021-06-25 13:41:47'),(1288,3150,40737,23190,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',34739524.67,'Pagos',NULL,1,'2021-06-25 13:41:47','2021-06-25 13:41:47',NULL),(1289,3150,40737,23189,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',12113815.75,'Compras',NULL,1,'2021-06-25 14:00:59','2021-06-25 14:10:08','2021-06-25 14:10:08'),(1290,3150,40737,23188,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',10201770.32,'Compras',NULL,1,'2021-06-25 14:06:13','2021-06-25 14:08:19','2021-06-25 14:08:19'),(1291,3150,40737,23188,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',10201770.32,'Compras',NULL,1,'2021-06-25 14:08:19','2021-06-25 14:08:19',NULL),(1292,3150,40737,23189,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',12113815.75,'Compras',NULL,1,'2021-06-25 14:10:08','2021-06-25 14:10:08',NULL),(1293,3150,40737,23187,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',12385521.16,'Compras',NULL,1,'2021-06-25 14:57:02','2021-06-25 14:57:02',NULL),(1294,3150,40737,23186,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',10591607.33,'Compras',NULL,1,'2021-06-25 15:01:47','2021-06-25 16:51:11','2021-06-25 16:51:11'),(1295,3150,40737,23185,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',11811157.19,'Compras',NULL,1,'2021-06-25 15:05:23','2021-06-25 15:05:23',NULL),(1296,3150,40737,23184,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',11529640.70,'Compras',NULL,1,'2021-06-25 15:14:38','2021-06-25 15:14:38',NULL),(1297,3150,40737,23182,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',5467817.24,'Compras',NULL,1,'2021-06-25 15:18:26','2021-06-25 15:18:26',NULL),(1298,3150,40737,23181,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',5278356.05,'Compras',NULL,1,'2021-06-25 15:22:27','2021-06-25 15:22:27',NULL),(1299,3150,40737,23176,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',7283493.19,'Compras',NULL,1,'2021-06-25 15:28:06','2021-06-25 15:28:06',NULL),(1300,3150,40737,23186,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',10591607.33,'Compras',NULL,1,'2021-06-25 16:51:11','2021-06-25 16:51:11',NULL),(1301,3150,40737,23181,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1376649.56,'Ingresos Brutos',NULL,1,'2021-06-27 00:02:47','2021-06-27 00:02:47',NULL),(1302,3150,40737,23182,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1512769.14,'Ingresos Brutos',NULL,1,'2021-06-27 00:06:36','2021-06-27 03:08:15','2021-06-27 03:08:15');
INSERT INTO `balance_libro` VALUES (1303,3150,40737,23183,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1724242.44,'Ingresos Brutos',NULL,1,'2021-06-27 00:12:13','2021-06-27 00:12:13',NULL),(1304,3150,40737,23184,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1894300.19,'Ingresos Brutos',NULL,1,'2021-06-27 00:17:40','2021-06-27 00:17:40',NULL),(1305,3150,40737,23187,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',2903848.62,'Ingresos Brutos',NULL,1,'2021-06-27 00:25:07','2021-06-27 02:54:57','2021-06-27 02:54:57'),(1306,3150,40737,23188,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',2894397.16,'Ingresos Brutos',NULL,1,'2021-06-27 00:32:52','2021-06-27 02:53:32','2021-06-27 02:53:32'),(1307,3150,40737,23192,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1333514.35,'Ingresos Brutos',NULL,1,'2021-06-27 00:52:47','2021-06-27 00:55:36','2021-06-27 00:55:36'),(1308,3150,40737,23177,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1333514.35,'Ingresos Brutos',NULL,1,'2021-06-27 00:55:36','2021-06-27 01:01:51','2021-06-27 01:01:51'),(1309,3150,40737,23177,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1353069.68,'Ingresos Brutos',NULL,1,'2021-06-27 01:01:51','2021-06-27 03:03:46','2021-06-27 03:03:46'),(1310,3150,40737,23189,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',3143650.35,'Ingresos Brutos',NULL,1,'2021-06-27 01:13:39','2021-06-27 02:52:56','2021-06-27 02:52:56'),(1311,3150,40737,23190,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',3053527.16,'Ingresos Brutos',NULL,1,'2021-06-27 01:15:20','2021-06-27 02:52:14','2021-06-27 02:52:14'),(1312,3150,40737,23190,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',3053527.16,'Ingresos Brutos',NULL,1,'2021-06-27 02:52:14','2021-06-27 02:52:14',NULL),(1313,3150,40737,23189,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',3143650.35,'Ingresos Brutos',NULL,1,'2021-06-27 02:52:56','2021-06-27 02:52:56',NULL),(1314,3150,40737,23188,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',2894397.16,'Ingresos Brutos',NULL,1,'2021-06-27 02:53:32','2021-06-27 02:53:32',NULL),(1315,3150,40737,23187,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',2903848.62,'Ingresos Brutos',NULL,1,'2021-06-27 02:54:57','2021-06-27 02:54:57',NULL),(1316,3150,40737,23185,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1968125.99,'Ingresos Brutos',NULL,1,'2021-06-27 02:58:06','2021-06-27 02:58:06',NULL),(1317,3150,40737,23177,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',1353069.68,'Ingresos Brutos',NULL,1,'2021-06-27 03:03:46','2021-06-27 18:38:28','2021-06-27 18:38:28'),(1318,3150,40737,23182,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',1512769.14,'Ingresos Brutos',NULL,1,'2021-06-27 03:08:15','2021-07-02 13:52:32','2021-07-02 13:52:32'),(1319,3150,40737,23190,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',2642082.12,'Iva',NULL,1,'2021-06-27 18:05:17','2021-06-27 18:05:17',NULL),(1320,3150,40737,23189,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',10306740.79,'BANCO',NULL,1,'2021-06-27 18:15:38','2021-06-27 18:27:58','2021-06-27 18:27:58'),(1321,3150,40737,23188,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',6855004.57,'BANCO',NULL,1,'2021-06-27 18:16:23','2021-06-27 23:32:33','2021-06-27 23:32:33'),(1322,3150,40737,23187,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',11424984.84,'BANCO',NULL,1,'2021-06-27 18:17:00','2021-06-27 23:31:56','2021-06-27 23:31:56'),(1323,3150,40737,23186,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',10283335.28,'BANCO',NULL,1,'2021-06-27 18:17:41','2021-06-27 23:31:09','2021-06-27 23:31:09');
INSERT INTO `balance_libro` VALUES (1324,3150,40737,23183,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',5375660.27,'BANCO',NULL,1,'2021-06-27 18:18:16','2021-06-27 23:26:40','2021-06-27 23:26:40'),(1325,3150,40737,23177,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',4709574.24,'BANCO',NULL,1,'2021-06-27 18:18:48','2021-06-27 23:22:23','2021-06-27 23:22:23'),(1326,3150,40737,23189,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',10306740.79,'BANCO',NULL,1,'2021-06-27 18:27:58','2021-06-27 23:33:05','2021-06-27 23:33:05'),(1327,3150,40737,23190,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',10797504.52,'BANCO',NULL,1,'2021-06-27 18:28:51','2021-06-27 23:33:35','2021-06-27 23:33:35'),(1328,3150,40737,23177,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',1353069.68,'Ingresos Brutos',NULL,1,'2021-06-27 18:38:28','2021-06-27 18:38:28',NULL),(1329,3150,40737,23176,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',5908012.64,'BANCO',NULL,1,'2021-06-27 23:21:38','2021-06-27 23:21:38',NULL),(1330,3150,40737,23177,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',4704202.89,'BANCO',NULL,1,'2021-06-27 23:22:23','2021-06-27 23:22:23',NULL),(1331,3150,40737,23181,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',4761202.50,'BANCO',NULL,1,'2021-06-27 23:23:47','2021-06-27 23:23:47',NULL),(1332,3150,40737,23182,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',4030439.94,'BANCO',NULL,1,'2021-06-27 23:25:37','2021-06-27 23:25:37',NULL),(1333,3150,40737,23183,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',5363087.75,'BANCO',NULL,1,'2021-06-27 23:26:40','2021-06-27 23:26:40',NULL),(1334,3150,40737,23184,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',7992822.26,'BANCO',NULL,1,'2021-06-27 23:27:20','2021-06-27 23:27:20',NULL),(1335,3150,40737,23185,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',9545612.64,'BANCO',NULL,1,'2021-06-27 23:28:18','2021-06-27 23:28:18',NULL),(1336,3150,40737,23186,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',10283335.28,'BANCO',NULL,1,'2021-06-27 23:31:09','2021-06-27 23:31:09',NULL),(1337,3150,40737,23187,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',11408401.34,'BANCO',NULL,1,'2021-06-27 23:31:56','2021-06-27 23:31:56',NULL),(1338,3150,40737,23188,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',6855004.57,'BANCO',NULL,1,'2021-06-27 23:32:33','2021-06-27 23:32:33',NULL),(1339,3150,40737,23189,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',10306740.79,'BANCO',NULL,1,'2021-06-27 23:33:05','2021-06-27 23:33:05',NULL),(1340,3150,40737,23190,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',10797504.52,'BANCO',NULL,1,'2021-06-27 23:33:35','2021-06-27 23:33:35',NULL),(1341,3150,40737,23176,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',6917.08,'OTROS',NULL,1,'2021-06-27 23:39:48','2021-06-27 23:39:48',NULL),(1342,3150,40737,23177,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',9800.53,'OTROS',NULL,1,'2021-06-27 23:40:50','2021-06-27 23:40:50',NULL),(1343,3150,40737,23181,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',9403.48,'OTROS',NULL,1,'2021-06-27 23:41:48','2021-06-27 23:53:24','2021-06-27 23:53:24'),(1344,3150,40737,23189,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',1514.94,'OTROS',NULL,1,'2021-06-27 23:42:38','2021-06-27 23:42:38',NULL),(1345,3150,40737,23190,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',35770935.87,'Cobranzas',NULL,1,'2021-06-27 23:48:12','2021-06-27 23:48:12',NULL),(1346,3150,40737,23181,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',9403.48,'OTROS',NULL,1,'2021-06-27 23:53:24','2021-06-27 23:53:24',NULL);
INSERT INTO `balance_libro` VALUES (1347,3150,40737,23182,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1512769.14,'Ingresos Brutos',NULL,1,'2021-07-02 13:52:32','2021-07-02 13:52:32',NULL),(1348,3150,40737,23176,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-30','2019-11-30',958600.21,NULL,NULL,1,'2021-07-05 14:03:32','2021-07-05 14:03:32',NULL),(1349,3150,40737,23177,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-31','2019-12-31',1325960.67,NULL,NULL,1,'2021-07-05 14:03:32','2021-07-05 14:03:32',NULL),(1350,3150,40737,23181,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',158974.31,NULL,NULL,1,'2021-07-05 14:03:32','2021-07-05 14:03:32',NULL),(1351,3150,40737,23182,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',369440.98,NULL,NULL,1,'2021-07-05 14:03:32','2021-07-05 14:03:32',NULL),(1352,3150,40737,23183,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',1998776.66,NULL,NULL,1,'2021-07-05 14:03:32','2021-07-05 14:03:32',NULL),(1353,3150,40737,23184,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',2177460.60,NULL,NULL,1,'2021-07-05 14:03:32','2021-07-05 14:03:32',NULL),(1354,3150,40737,23185,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',665990.36,NULL,NULL,1,'2021-07-05 14:03:32','2021-07-05 14:03:32',NULL),(1355,3150,40737,23186,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',1386400.96,NULL,NULL,1,'2021-07-05 14:03:32','2021-07-05 14:03:32',NULL),(1356,3150,40737,23187,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',598773.66,NULL,NULL,1,'2021-07-05 14:03:32','2021-07-05 14:03:32',NULL),(1357,3150,40737,23188,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',789414.69,NULL,NULL,1,'2021-07-05 14:03:32','2021-07-05 14:03:32',NULL),(1358,3150,40737,23189,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',389774.36,NULL,NULL,1,'2021-07-05 14:03:32','2021-07-05 14:03:32',NULL),(1359,3150,40737,23190,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',348844.46,NULL,NULL,1,'2021-07-05 14:03:32','2021-07-05 14:03:32',NULL),(1360,3150,40737,23176,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-30','2019-11-30',1287930.74,NULL,NULL,1,'2021-07-05 14:20:52','2021-07-05 14:20:52',NULL),(1361,3150,40737,23177,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-31','2019-12-31',2987663.28,NULL,NULL,1,'2021-07-05 14:20:52','2021-07-05 14:20:52',NULL),(1362,3150,40737,23181,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',2189667.47,NULL,NULL,1,'2021-07-05 14:20:52','2021-07-05 14:20:52',NULL),(1363,3150,40737,23182,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',2798336.90,NULL,NULL,1,'2021-07-05 14:20:52','2021-07-05 14:20:52',NULL),(1364,3150,40737,23183,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',1987665.87,NULL,NULL,1,'2021-07-05 14:20:52','2021-07-05 14:20:52',NULL),(1365,3150,40737,23184,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',2579103.65,NULL,NULL,1,'2021-07-05 14:20:52','2021-07-05 14:20:52',NULL),(1366,3150,40737,23185,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',6374960.20,NULL,NULL,1,'2021-07-05 14:20:52','2021-07-05 14:20:52',NULL),(1367,3150,40737,23186,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',6796314.87,NULL,NULL,1,'2021-07-05 14:20:52','2021-07-05 14:20:52',NULL),(1368,3150,40737,23187,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',6396785.41,NULL,NULL,1,'2021-07-05 14:20:52','2021-07-05 14:20:52',NULL),(1369,3150,40737,23188,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',6294896.54,NULL,NULL,1,'2021-07-05 14:20:52','2021-07-05 14:20:52',NULL),(1370,3150,40737,23189,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',3512255.60,NULL,NULL,1,'2021-07-05 14:20:52','2021-07-05 14:20:52',NULL);
INSERT INTO `balance_libro` VALUES (1371,3150,40737,23190,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',6477369.40,NULL,NULL,1,'2021-07-05 14:20:52','2021-07-05 14:20:52',NULL),(1372,3150,40737,23190,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',533855.00,NULL,NULL,1,'2021-07-05 15:08:25','2021-07-05 15:08:25',NULL),(1373,3150,40737,23190,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',519600.50,NULL,NULL,1,'2021-07-08 15:31:23','2021-07-08 15:31:23',NULL),(1374,3150,40737,23190,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1380365.65,NULL,NULL,1,'2021-07-08 15:33:46','2021-07-08 15:33:46',NULL),(1375,3150,40737,23190,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',12780277.79,'Ajuste por Inflacion Asiento Anual',NULL,1,'2021-07-08 15:36:14','2021-07-08 15:36:17',NULL),(1376,3150,40737,23190,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',4175258.46,NULL,NULL,1,'2021-07-08 15:47:42','2021-07-08 15:47:42',NULL),(1377,3150,40737,23190,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',917204.22,NULL,NULL,1,'2021-07-08 16:08:42','2021-07-08 16:08:42',NULL),(1407,3150,40738,24723,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',670909.70,NULL,NULL,1,'2021-07-10 19:56:00','2021-07-10 19:56:00',NULL),(1408,3150,40738,24723,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',74132.98,NULL,NULL,1,'2021-07-10 19:56:00','2021-07-10 19:56:00',NULL),(1409,3150,40738,24723,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',8623.46,NULL,NULL,1,'2021-07-10 19:56:00','2021-07-10 19:56:00',NULL),(1410,3150,40738,24723,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',259738.96,NULL,NULL,1,'2021-07-10 19:56:00','2021-07-10 19:56:00',NULL),(1411,3150,40738,24723,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',841.52,NULL,NULL,1,'2021-07-10 19:56:00','2021-07-10 19:56:00',NULL),(1412,3150,40738,24723,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',24997.50,NULL,NULL,1,'2021-07-10 19:56:00','2021-07-10 19:56:00',NULL),(1413,3150,40738,24724,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',55660.00,NULL,NULL,1,'2021-07-10 19:56:00','2021-07-10 19:56:00',NULL),(1414,3150,40738,24724,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',24599.09,NULL,NULL,1,'2021-07-10 19:56:00','2021-07-10 19:56:00',NULL),(1415,3150,40738,24724,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',18502.44,NULL,NULL,1,'2021-07-10 19:56:00','2021-07-10 19:56:00',NULL),(1416,3150,40738,24724,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',91478.19,NULL,NULL,1,'2021-07-10 19:56:00','2021-07-10 19:56:00',NULL),(1417,3150,40738,24724,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',793.42,NULL,NULL,1,'2021-07-10 19:56:00','2021-07-10 19:56:00',NULL),(1418,3150,40738,24724,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',180740.00,NULL,NULL,1,'2021-07-10 19:56:00','2021-07-10 19:56:00',NULL),(1419,3150,40738,24725,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',74284.93,NULL,NULL,1,'2021-07-10 19:56:00','2021-07-10 19:56:00',NULL),(1420,3150,40738,24725,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',36796.90,NULL,NULL,1,'2021-07-10 19:56:00','2021-07-10 19:56:00',NULL),(1421,3150,40738,24725,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',23904.47,NULL,NULL,1,'2021-07-10 19:56:00','2021-07-10 19:56:00',NULL),(1422,3150,40738,24725,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',104798.96,NULL,NULL,1,'2021-07-10 19:56:00','2021-07-10 19:56:00',NULL),(1423,3150,40738,24725,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',764.56,NULL,NULL,1,'2021-07-10 19:56:00','2021-07-10 19:56:00',NULL);
INSERT INTO `balance_libro` VALUES (1424,3150,40738,24725,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',72167.56,NULL,NULL,1,'2021-07-10 19:56:00','2021-07-10 19:56:00',NULL),(1425,3150,40738,24726,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',129470.00,NULL,NULL,1,'2021-07-10 19:56:00','2021-07-10 19:56:01',NULL),(1426,3150,40738,24726,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',36113.29,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1427,3150,40738,24726,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',13643.29,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1428,3150,40738,24726,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',63322.73,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1429,3150,40738,24726,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',764.56,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1430,3150,40738,24726,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',128649.00,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1431,3150,40738,24726,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',1582.00,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1432,3150,40738,24727,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',10250.00,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-11 22:45:19','2021-07-11 22:45:19'),(1433,3150,40738,24727,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',24135.67,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1434,3150,40738,24727,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',2082.01,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-11 22:11:05','2021-07-11 22:11:05'),(1435,3150,40738,24727,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',778.77,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1436,3150,40738,24727,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',30476.40,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1437,3150,40738,24727,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',8657.40,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1438,3150,40738,24728,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',778.77,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-21 21:03:04','2021-07-21 21:03:04'),(1439,3150,40738,24728,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',22000.00,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1440,3150,40738,24728,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',40.47,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1441,3150,40738,24728,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',40.47,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1442,3150,40738,24729,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',145200.00,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1443,3150,40738,24729,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',3500.00,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-21 20:46:25','2021-07-21 20:46:25'),(1444,3150,40738,24729,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',325586.30,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1445,3150,40738,24729,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',140822.30,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1446,3150,40738,24729,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',43725.34,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1447,3150,40738,24729,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',18525.34,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL);
INSERT INTO `balance_libro` VALUES (1448,3150,40738,24730,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',497794.00,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1449,3150,40738,24730,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',771.97,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-21 21:05:52','2021-07-21 21:05:52'),(1450,3150,40738,24730,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',256265.35,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1451,3150,40738,24730,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',515284.07,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1452,3150,40738,24730,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',107817.77,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1453,3150,40738,24730,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',21423.77,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1454,3150,40738,24731,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2316484.50,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1455,3150,40738,24731,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',440449.53,NULL,NULL,1,'2021-07-10 19:56:01','2021-08-20 15:53:43','2021-08-20 15:53:43'),(1456,3150,40738,24731,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',38415.03,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1457,3150,40738,24731,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2414000.49,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1458,3150,40738,24731,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',771.97,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-21 21:13:16','2021-07-21 21:13:16'),(1459,3150,40738,24731,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',965541.55,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1460,3150,40738,24732,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',2002550.00,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-10 19:56:01',NULL),(1461,3150,40738,24732,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',770.45,NULL,NULL,1,'2021-07-10 19:56:01','2021-07-21 21:14:53','2021-07-21 21:14:53'),(1462,3150,40738,24732,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1307794.00,NULL,NULL,1,'2021-07-10 19:56:02','2021-07-10 19:56:02',NULL),(1463,3150,40738,24732,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',2166097.14,NULL,NULL,1,'2021-07-10 19:56:02','2021-07-10 19:56:02',NULL),(1464,3150,40738,24732,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',413276.27,NULL,NULL,1,'2021-07-10 19:56:02','2021-07-13 18:23:17','2021-07-13 18:23:17'),(1465,3150,40738,24732,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',65726.27,NULL,NULL,1,'2021-07-10 19:56:02','2021-07-10 19:56:02',NULL),(1466,3150,40738,24733,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1241460.00,NULL,NULL,1,'2021-07-10 19:56:02','2021-07-10 19:56:02',NULL),(1467,3150,40738,24733,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',841.62,NULL,NULL,1,'2021-07-10 19:56:02','2021-07-10 19:56:02',NULL),(1468,3150,40738,24733,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',2909884.92,NULL,NULL,1,'2021-07-10 19:56:02','2021-07-10 19:56:02',NULL),(1469,3150,40738,24733,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',690160.22,NULL,NULL,1,'2021-07-10 19:56:02','2021-07-10 19:56:02',NULL),(1470,3150,40738,24733,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',281624.83,NULL,NULL,1,'2021-07-10 19:56:02','2021-07-10 19:56:02',NULL);
INSERT INTO `balance_libro` VALUES (1471,3150,40738,24733,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',97957.55,NULL,NULL,1,'2021-07-10 19:56:02','2021-07-11 23:11:37','2021-07-11 23:11:37'),(1472,3150,40738,24733,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',10089.60,NULL,NULL,1,'2021-07-10 19:56:02','2021-07-10 19:56:02',NULL),(1473,3150,40738,24734,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2972728.00,NULL,NULL,1,'2021-07-10 19:56:02','2021-07-10 19:56:02',NULL),(1474,3150,40738,24734,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1339985.78,NULL,NULL,1,'2021-07-10 19:56:02','2021-07-10 19:56:02',NULL),(1475,3150,40738,24734,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1417388.85,NULL,NULL,1,'2021-07-10 19:56:02','2021-07-14 20:33:16','2021-07-14 20:33:16'),(1476,3150,40738,24734,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',503161.71,NULL,NULL,1,'2021-07-10 19:56:02','2021-07-10 19:56:02',NULL),(1477,3150,40738,24734,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',30307.80,NULL,NULL,1,'2021-07-10 19:56:02','2021-07-10 19:56:02',NULL),(1478,3150,40738,24727,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',120069.98,'Fondo de Coop.',NULL,1,'2021-07-10 20:53:15','2021-07-10 21:03:37','2021-07-10 21:03:37'),(1479,3150,40738,24727,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',120069.98,'Fondo de Coop.',NULL,1,'2021-07-10 21:03:37','2021-07-10 22:52:19','2021-07-10 22:52:19'),(1480,3150,40738,24727,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',120069.98,'Fondo de Coop.',NULL,1,'2021-07-10 22:52:19','2021-07-14 20:41:26','2021-07-14 20:41:26'),(1481,3150,40738,24734,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',50636.80,NULL,NULL,1,'2021-07-11 21:52:23','2021-07-14 20:35:06','2021-07-14 20:35:06'),(1482,3150,40738,24727,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',7958.44,NULL,NULL,1,'2021-07-11 21:52:23','2021-07-13 18:40:40','2021-07-13 18:40:40'),(1483,3150,40738,24734,14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',602642.16,NULL,NULL,1,'2021-07-11 21:52:23','2021-07-11 21:52:23',NULL),(1484,3150,40738,24727,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',2082.01,NULL,NULL,1,'2021-07-11 22:11:05','2021-07-11 22:48:28','2021-07-11 22:48:28'),(1485,3150,40738,24727,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',10285.00,NULL,NULL,1,'2021-07-11 22:45:19','2021-07-11 22:45:19',NULL),(1486,3150,40738,24727,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',19595.94,NULL,NULL,1,'2021-07-11 22:48:28','2021-07-11 22:48:28',NULL),(1487,3150,40738,24727,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',19195.94,'Iva',NULL,1,'2021-07-11 22:55:44','2021-07-11 22:55:44',NULL),(1488,3150,40738,24733,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',66164.83,NULL,NULL,1,'2021-07-11 23:11:37','2021-07-11 23:11:37',NULL),(1489,3150,40738,24723,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1714.16,'BANCO',NULL,1,'2021-07-13 12:36:21','2021-07-14 20:36:18','2021-07-14 20:36:18'),(1490,3150,40738,24734,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',5300.58,'Iva',NULL,1,'2021-07-13 18:05:16','2021-07-13 18:05:16',NULL),(1499,3150,40738,24732,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',347550.00,NULL,NULL,1,'2021-07-13 18:23:17','2021-07-13 18:25:11','2021-07-13 18:25:11'),(1501,3150,40738,24732,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',413276.28,'Iva',NULL,1,'2021-07-13 18:27:47','2021-08-20 15:56:17','2021-08-20 15:56:17'),(1503,3150,40738,24734,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',511790.85,NULL,NULL,1,'2021-07-14 20:33:16','2021-07-14 20:33:16',NULL);
INSERT INTO `balance_libro` VALUES (1504,3150,40738,24727,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',58665.60,'Fondo de Coop.',NULL,1,'2021-07-14 20:41:26','2021-07-14 20:41:26',NULL),(1506,3150,40738,24727,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',8657.57,'Ganancias',NULL,1,'2021-07-14 20:58:30','2021-07-14 20:59:15','2021-07-14 20:59:15'),(1507,3150,40738,24727,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',8385.57,'Ganancias',NULL,1,'2021-07-14 20:59:15','2021-07-14 20:59:15',NULL),(1508,3150,40738,24734,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',577779.40,'BANCO',NULL,1,'2021-07-21 15:01:44','2021-07-21 15:01:44',NULL),(1509,3150,40738,24729,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',861.84,NULL,NULL,1,'2021-07-21 20:46:25','2021-07-21 21:12:05','2021-07-21 21:12:05'),(1510,3150,40738,24728,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',813.71,NULL,NULL,1,'2021-07-21 21:03:04','2021-07-21 21:03:04',NULL),(1511,3150,40738,24730,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',770.45,NULL,NULL,1,'2021-07-21 21:05:52','2021-07-21 21:08:44','2021-07-21 21:08:44'),(1512,3150,40738,24730,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',771.97,NULL,NULL,1,'2021-07-21 21:08:44','2021-07-21 21:08:44',NULL),(1513,3150,40738,24729,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',861.84,NULL,NULL,1,'2021-07-21 21:12:05','2021-07-21 21:12:05',NULL),(1514,3150,40738,24731,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',770.45,NULL,NULL,1,'2021-07-21 21:13:16','2021-07-21 21:13:16',NULL),(1515,3150,40738,24732,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',804.95,NULL,NULL,1,'2021-07-21 21:14:53','2021-07-21 21:14:53',NULL),(1895,3150,40741,26280,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',94334564.62,NULL,NULL,1,'2021-08-10 17:42:55','2021-08-10 17:42:55',NULL),(1896,3150,40741,26280,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',275855.80,NULL,NULL,1,'2021-08-10 17:42:55','2021-08-10 17:42:56',NULL),(1897,3150,40741,26280,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',17933.40,NULL,NULL,1,'2021-08-10 17:42:56','2021-08-11 10:39:43','2021-08-11 10:39:43'),(1898,3150,40741,26280,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',148231.45,NULL,NULL,1,'2021-08-10 17:42:56','2021-08-11 11:00:07','2021-08-11 11:00:07'),(1899,3150,40741,26280,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',284432.20,NULL,NULL,1,'2021-08-10 17:42:56','2021-08-10 19:26:43','2021-08-10 19:26:43'),(1900,3150,40741,26280,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',389399.95,NULL,NULL,1,'2021-08-10 17:42:56','2021-08-10 17:42:56',NULL),(1901,3150,40741,26280,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',23.93,NULL,NULL,1,'2021-08-10 17:42:56','2021-08-17 19:44:46','2021-08-17 19:44:46'),(1902,3150,40741,26281,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',500729.46,NULL,NULL,1,'2021-08-10 17:42:56','2021-08-10 17:42:56',NULL),(1903,3150,40741,26281,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',90549.36,NULL,NULL,1,'2021-08-10 17:42:56','2021-08-10 17:42:56',NULL),(1904,3150,40741,26281,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',3645.90,NULL,NULL,1,'2021-08-10 17:42:56','2021-08-10 17:42:56',NULL),(1905,3150,40741,26281,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',248299.15,NULL,NULL,1,'2021-08-10 17:42:56','2021-08-11 10:15:08','2021-08-11 10:15:08'),(1906,3150,40741,26281,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',385920.20,NULL,NULL,1,'2021-08-10 17:42:56','2021-08-10 18:41:11','2021-08-10 18:41:11');
INSERT INTO `balance_libro` VALUES (1907,3150,40741,26281,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',0.00,NULL,NULL,1,'2021-08-10 17:42:56','2021-08-11 11:48:42','2021-08-11 11:48:42'),(1908,3150,40741,26281,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',14.76,NULL,NULL,1,'2021-08-10 17:42:56','2021-08-17 19:45:10','2021-08-17 19:45:10'),(1909,3150,40741,26282,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',1229482.82,NULL,NULL,1,'2021-08-10 17:42:56','2021-08-10 17:42:56',NULL),(1910,3150,40741,26282,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',226488.61,NULL,NULL,1,'2021-08-10 17:42:56','2021-08-10 17:42:56',NULL),(1911,3150,40741,26282,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',13107.29,NULL,NULL,1,'2021-08-10 17:42:56','2021-08-10 17:42:57',NULL),(1912,3150,40741,26282,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',128163.37,NULL,NULL,1,'2021-08-10 17:42:57','2021-08-10 17:42:57',NULL),(1913,3150,40741,26282,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',754310.00,NULL,NULL,1,'2021-08-10 17:42:57','2021-08-10 17:42:57',NULL),(1914,3150,40741,26282,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',171166.65,NULL,NULL,1,'2021-08-10 17:42:57','2021-08-10 17:42:57',NULL),(1915,3150,40741,26282,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',25.23,NULL,NULL,1,'2021-08-10 17:42:57','2021-08-17 19:45:30','2021-08-17 19:45:30'),(1916,3150,40741,26283,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',214845.91,NULL,NULL,1,'2021-08-10 17:42:57','2021-08-10 17:42:57',NULL),(1917,3150,40741,26283,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',53999.51,NULL,NULL,1,'2021-08-10 17:42:57','2021-08-10 17:42:57',NULL),(1918,3150,40741,26283,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',16004.72,NULL,NULL,1,'2021-08-10 17:42:57','2021-08-10 17:42:57',NULL),(1919,3150,40741,26283,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',228804.60,NULL,NULL,1,'2021-08-10 17:42:57','2021-08-10 17:42:57',NULL),(1920,3150,40741,26283,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',80046.48,NULL,NULL,1,'2021-08-10 17:42:57','2021-08-10 17:42:57',NULL),(1921,3150,40741,26283,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',434906.01,NULL,NULL,1,'2021-08-10 17:42:57','2021-08-10 17:42:57',NULL),(1922,3150,40741,26283,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',155393.55,NULL,NULL,1,'2021-08-10 17:42:57','2021-08-10 17:42:57',NULL),(1923,3150,40741,26283,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',492.60,NULL,NULL,1,'2021-08-10 17:42:57','2021-08-10 17:42:57',NULL),(1924,3150,40741,26283,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',36.92,NULL,NULL,1,'2021-08-10 17:42:57','2021-08-17 19:46:05','2021-08-17 19:46:05'),(1925,3150,40741,26284,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',125238.63,NULL,NULL,1,'2021-08-10 17:42:57','2021-08-10 17:42:57',NULL),(1926,3150,40741,26284,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',136582.97,NULL,NULL,1,'2021-08-10 17:42:57','2021-08-11 11:11:20','2021-08-11 11:11:20'),(1927,3150,40741,26284,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',41162.77,NULL,NULL,1,'2021-08-10 17:42:57','2021-08-10 17:42:57',NULL),(1928,3150,40741,26284,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',19427.14,NULL,NULL,1,'2021-08-10 17:42:57','2021-08-10 17:42:57',NULL),(1929,3150,40741,26284,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',219095.91,NULL,NULL,1,'2021-08-10 17:42:57','2021-08-10 17:42:57',NULL),(1930,3150,40741,26284,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',275500.60,NULL,NULL,1,'2021-08-10 17:42:57','2021-08-10 17:42:57',NULL);
INSERT INTO `balance_libro` VALUES (2186,3150,40741,26284,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',16.27,NULL,NULL,1,'2021-08-10 17:55:02','2021-08-17 19:48:02','2021-08-17 19:48:02'),(2187,3150,40741,26285,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',125923.34,NULL,NULL,1,'2021-08-10 17:55:02','2021-08-11 10:43:17','2021-08-11 10:43:17'),(2188,3150,40741,26285,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',58628.93,NULL,NULL,1,'2021-08-10 17:55:02','2021-08-10 17:55:02',NULL),(2189,3150,40741,26285,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',620562.50,NULL,NULL,1,'2021-08-10 17:55:02','2021-08-10 17:55:02',NULL),(2190,3150,40741,26285,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',102649.83,NULL,NULL,1,'2021-08-10 17:55:02','2021-08-11 10:17:50','2021-08-11 10:17:50'),(2191,3150,40741,26285,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',431920.58,NULL,NULL,1,'2021-08-10 17:55:02','2021-08-10 19:18:14','2021-08-10 19:18:14'),(2192,3150,40741,26285,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',132796.85,NULL,NULL,1,'2021-08-10 17:55:02','2021-08-10 17:55:02',NULL),(2193,3150,40741,26285,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',39.09,NULL,NULL,1,'2021-08-10 17:55:02','2021-08-17 19:48:35','2021-08-17 19:48:35'),(2194,3150,40741,26286,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',668476.60,NULL,NULL,1,'2021-08-10 17:55:02','2021-08-10 17:55:03',NULL),(2195,3150,40741,26286,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',102649.83,NULL,NULL,1,'2021-08-10 17:55:03','2021-08-10 18:57:34','2021-08-10 18:57:34'),(2196,3150,40741,26286,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',733623.76,NULL,NULL,1,'2021-08-10 17:55:03','2021-08-10 19:20:10','2021-08-10 19:20:10'),(2197,3150,40741,26286,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',83344.17,NULL,NULL,1,'2021-08-10 17:55:03','2021-08-11 11:59:22','2021-08-11 11:59:22'),(2198,3150,40741,26286,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',982.28,NULL,NULL,1,'2021-08-10 17:55:03','2021-08-10 17:55:03',NULL),(2199,3150,40741,26286,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',843748.60,NULL,NULL,1,'2021-08-10 17:55:03','2021-08-10 17:55:03',NULL),(2200,3150,40741,26286,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',252974.04,NULL,NULL,1,'2021-08-10 17:55:03','2021-08-11 11:34:53','2021-08-11 11:34:53'),(2201,3150,40741,26286,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',51697.44,NULL,NULL,1,'2021-08-10 17:55:03','2021-08-10 17:55:03',NULL),(2202,3150,40741,26286,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',28.50,NULL,NULL,1,'2021-08-10 17:55:03','2021-08-11 11:39:44','2021-08-11 11:39:44'),(2203,3150,40741,26287,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',2416122.78,NULL,NULL,1,'2021-08-10 17:55:03','2021-08-10 17:55:03',NULL),(2204,3150,40741,26287,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',75870.71,NULL,NULL,1,'2021-08-10 17:55:03','2021-08-10 17:55:03',NULL),(2205,3150,40741,26287,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',682857.17,NULL,NULL,1,'2021-08-10 17:55:03','2021-08-10 17:55:03',NULL),(2206,3150,40741,26287,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',1685423.75,NULL,NULL,1,'2021-08-10 17:55:03','2021-08-11 11:21:18','2021-08-11 11:21:18'),(2207,3150,40741,26287,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',425979.08,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-10 17:55:04',NULL),(2208,3150,40741,26287,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',76020.53,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-10 17:55:04',NULL);
INSERT INTO `balance_libro` VALUES (2209,3150,40741,26287,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',6651.99,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-10 17:55:04',NULL),(2210,3150,40741,26287,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',17.58,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-17 19:49:39','2021-08-17 19:49:39'),(2211,3150,40741,26288,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2703445.15,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-10 17:55:04',NULL),(2212,3150,40741,26288,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',426513.35,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-10 17:55:04',NULL),(2213,3150,40741,26288,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1562.61,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-10 17:55:04',NULL),(2214,3150,40741,26288,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1680110.49,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-11 11:29:18','2021-08-11 11:29:18'),(2215,3150,40741,26288,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',127890.00,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-10 17:55:04',NULL),(2216,3150,40741,26288,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',964215.76,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-10 17:55:04',NULL),(2217,3150,40741,26288,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1176430.94,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-10 17:55:04',NULL),(2218,3150,40741,26288,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',0.00,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-11 09:49:00','2021-08-11 09:49:00'),(2219,3150,40741,26288,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',11194.80,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-10 17:55:04',NULL),(2220,3150,40741,26288,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',52.74,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-10 17:55:04',NULL),(2221,3150,40741,26288,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',42.21,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-17 19:50:14','2021-08-17 19:50:14'),(2222,3150,40741,26289,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',3714851.00,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-10 17:55:04',NULL),(2223,3150,40741,26289,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',550068.22,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-11 10:25:01','2021-08-11 10:25:01'),(2224,3150,40741,26289,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1576904.33,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-10 19:21:50','2021-08-10 19:21:50'),(2225,3150,40741,26289,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',0.00,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-11 09:49:00','2021-08-11 09:49:00'),(2226,3150,40741,26289,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',81.37,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-10 17:55:04',NULL),(2227,3150,40741,26289,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',3571886.15,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-10 17:55:04',NULL),(2228,3150,40741,26289,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',50974.19,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-10 17:55:04',NULL),(2229,3150,40741,26289,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',18.60,NULL,NULL,1,'2021-08-10 17:55:04','2021-08-17 19:50:49','2021-08-17 19:50:49'),(2230,3150,40741,26290,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',5004360.30,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-10 17:55:05',NULL),(2231,3150,40741,26290,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1056959.06,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-11 09:47:43','2021-08-11 09:47:43');
INSERT INTO `balance_libro` VALUES (2232,3150,40741,26290,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',0.00,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-11 09:49:00','2021-08-11 09:49:00'),(2233,3150,40741,26290,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',29598.55,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-10 17:55:05',NULL),(2234,3150,40741,26290,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',139.70,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-10 17:55:05',NULL),(2235,3150,40741,26290,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',2286812.12,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-10 17:55:05',NULL),(2236,3150,40741,26290,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',730400.66,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-10 17:55:05',NULL),(2237,3150,40741,26290,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',84716.84,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-10 17:55:05',NULL),(2238,3150,40741,26290,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',282481.50,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-10 17:55:05',NULL),(2239,3150,40741,26290,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',31.93,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-17 19:51:49','2021-08-17 19:51:49'),(2240,3150,40741,26291,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2389224.23,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-10 17:55:05',NULL),(2241,3150,40741,26291,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',798038.47,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-11 09:53:26','2021-08-11 09:53:26'),(2242,3150,40741,26291,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1306491.11,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-10 17:55:05',NULL),(2243,3150,40741,26291,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',0.00,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-11 09:49:00','2021-08-11 09:49:00'),(2244,3150,40741,26291,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',8580.64,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-10 17:55:05',NULL),(2245,3150,40741,26291,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',203.36,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-10 17:55:05',NULL),(2246,3150,40741,26291,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1951346.83,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-11 11:29:47','2021-08-11 11:29:47'),(2247,3150,40741,26291,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',461866.66,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-10 17:55:05',NULL),(2248,3150,40741,26291,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',47207.91,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-10 17:55:05',NULL),(2249,3150,40741,26291,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',42826.47,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-10 17:55:05',NULL),(2250,3150,40741,26291,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',46.48,NULL,NULL,1,'2021-08-10 17:55:05','2021-08-17 19:52:23','2021-08-17 19:52:23'),(2282,3150,40741,26280,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',65809.20,NULL,NULL,1,'2021-08-10 18:33:00','2021-08-10 18:33:00',NULL),(2283,3150,40741,26280,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',131868.33,NULL,NULL,1,'2021-08-10 18:33:00','2021-08-10 18:33:00',NULL),(2284,3150,40741,26281,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',420724.10,NULL,NULL,1,'2021-08-10 18:33:00','2021-08-11 11:03:40','2021-08-11 11:03:40'),(2285,3150,40741,26284,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',86580.30,NULL,NULL,1,'2021-08-10 18:33:00','2021-08-10 18:33:00',NULL);
INSERT INTO `balance_libro` VALUES (2286,3150,40741,26287,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',95052.76,NULL,NULL,1,'2021-08-10 18:33:00','2021-08-10 18:33:00',NULL),(2287,3150,40741,26289,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',623156.51,NULL,NULL,1,'2021-08-10 18:33:00','2021-08-10 18:33:00',NULL),(2288,3150,40741,26290,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',4212442.30,NULL,NULL,1,'2021-08-10 18:33:00','2021-08-10 18:33:00',NULL),(2289,3150,40741,26281,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',385920.20,NULL,NULL,1,'2021-08-10 18:41:11','2021-08-10 19:15:32','2021-08-10 19:15:32'),(2290,3150,40741,26286,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',86882.37,NULL,NULL,1,'2021-08-10 18:57:34','2021-08-11 10:21:05','2021-08-11 10:21:05'),(2291,3150,40741,26281,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',385920.20,NULL,NULL,1,'2021-08-10 19:15:32','2021-08-11 10:13:55','2021-08-11 10:13:55'),(2292,3150,40741,26285,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',431920.58,NULL,NULL,1,'2021-08-10 19:18:14','2021-08-11 10:16:25','2021-08-11 10:16:25'),(2293,3150,40741,26286,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',733623.76,NULL,NULL,1,'2021-08-10 19:20:10','2021-08-11 10:19:33','2021-08-11 10:19:33'),(2294,3150,40741,26289,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',1576904.33,NULL,NULL,1,'2021-08-10 19:21:50','2021-08-11 10:24:04','2021-08-11 10:24:04'),(2295,3150,40741,26280,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',284435.20,NULL,NULL,1,'2021-08-10 19:26:43','2021-08-10 19:26:43',NULL),(2296,3150,40741,26290,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1056959.06,NULL,NULL,1,'2021-08-11 09:47:43','2021-08-11 09:47:43',NULL),(2297,3150,40741,26291,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',798038.47,NULL,NULL,1,'2021-08-11 09:53:26','2021-08-11 09:53:26',NULL),(2298,3150,40741,26281,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',385920.20,NULL,NULL,1,'2021-08-11 10:13:55','2021-08-11 10:13:55',NULL),(2299,3150,40741,26281,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',243299.15,NULL,NULL,1,'2021-08-11 10:15:08','2021-09-03 13:58:29','2021-09-03 13:58:29'),(2300,3150,40741,26285,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',431920.58,NULL,NULL,1,'2021-08-11 10:16:25','2021-08-11 10:16:25',NULL),(2301,3150,40741,26285,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',100149.83,NULL,NULL,1,'2021-08-11 10:17:50','2021-09-03 16:56:58','2021-09-03 16:56:58'),(2302,3150,40741,26286,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',733623.76,NULL,NULL,1,'2021-08-11 10:19:33','2021-08-11 10:19:33',NULL),(2303,3150,40741,26286,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',86882.37,NULL,NULL,1,'2021-08-11 10:21:05','2021-09-03 16:59:29','2021-09-03 16:59:29'),(2304,3150,40741,26289,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',1576904.33,NULL,NULL,1,'2021-08-11 10:24:04','2021-08-11 10:24:04',NULL),(2305,3150,40741,26289,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',547068.22,NULL,NULL,1,'2021-08-11 10:25:01','2021-08-11 10:25:01',NULL),(2306,3150,40741,26280,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',17933.40,NULL,NULL,1,'2021-08-11 10:39:44','2021-08-11 10:39:44',NULL),(2307,3150,40741,26285,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',125923.34,NULL,NULL,1,'2021-08-11 10:43:17','2021-08-11 10:43:17',NULL),(2308,3150,40741,26285,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-29','2020-06-29',610033.60,'VENTAS',NULL,1,'2021-08-11 10:55:11','2021-08-11 10:55:11',NULL);
INSERT INTO `balance_libro` VALUES (2309,3150,40741,26280,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',148231.41,NULL,NULL,1,'2021-08-11 11:00:07','2021-08-11 11:00:07',NULL),(2310,3150,40741,26281,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',420724.10,NULL,NULL,1,'2021-08-11 11:03:40','2021-08-11 11:03:40',NULL),(2311,3150,40741,26284,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',136582.97,NULL,NULL,1,'2021-08-11 11:11:20','2021-08-11 11:11:20',NULL),(2312,3150,40741,26287,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',1685423.78,NULL,NULL,1,'2021-08-11 11:21:18','2021-08-11 11:21:18',NULL),(2313,3150,40741,26288,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1680110.50,NULL,NULL,1,'2021-08-11 11:29:18','2021-08-11 11:29:18',NULL),(2314,3150,40741,26291,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1951346.84,NULL,NULL,1,'2021-08-11 11:29:47','2021-08-11 11:29:47',NULL),(2315,3150,40741,26286,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',206293.23,NULL,NULL,1,'2021-08-11 11:34:53','2021-08-11 11:34:53',NULL),(2316,3150,40741,26286,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',28.60,NULL,NULL,1,'2021-08-11 11:39:44','2021-08-17 19:49:12','2021-08-17 19:49:12'),(2317,3150,40741,26281,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',125773.08,NULL,NULL,1,'2021-08-11 11:48:42','2021-08-11 11:48:42',NULL),(2318,3150,40741,26286,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',84344.17,NULL,NULL,1,'2021-08-11 11:59:22','2021-08-11 11:59:22',NULL),(2327,3150,40741,26288,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',82504.26,NULL,NULL,1,'2021-08-11 12:07:34','2021-08-11 12:07:34',NULL),(2328,3150,40741,26289,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',138390.05,NULL,NULL,1,'2021-08-11 12:07:34','2021-08-11 12:07:34',NULL),(2329,3150,40741,26290,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',72399.27,NULL,NULL,1,'2021-08-11 12:07:34','2021-08-11 12:07:35',NULL),(2330,3150,40741,26291,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',172165.58,NULL,NULL,1,'2021-08-11 12:07:35','2021-08-11 12:07:35',NULL),(2331,3150,40741,26280,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',4905.00,NULL,NULL,1,'2021-08-11 16:42:08','2021-08-11 16:42:08',NULL),(2332,3150,40741,26281,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',4201.00,NULL,NULL,1,'2021-08-11 16:42:08','2021-08-11 16:42:08',NULL),(2333,3150,40741,26282,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',5500.00,NULL,NULL,1,'2021-08-11 16:42:08','2021-08-11 16:42:08',NULL),(2334,3150,40741,26284,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',5500.00,NULL,NULL,1,'2021-08-11 16:42:08','2021-08-11 16:42:08',NULL),(2335,3150,40741,26285,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',10500.00,NULL,NULL,1,'2021-08-11 16:42:08','2021-08-11 16:42:08',NULL),(2336,3150,40741,26286,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',8200.00,NULL,NULL,1,'2021-08-11 16:42:08','2021-08-11 16:42:08',NULL),(2337,3150,40741,26287,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',7300.00,NULL,NULL,1,'2021-08-11 16:42:08','2021-08-11 16:42:08',NULL),(2338,3150,40741,26288,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',5500.00,NULL,NULL,1,'2021-08-11 16:42:08','2021-08-11 16:42:08',NULL),(2339,3150,40741,26289,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',11130.00,NULL,NULL,1,'2021-08-11 16:42:08','2021-08-11 16:42:08',NULL),(2340,3150,40741,26290,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',5880.00,NULL,NULL,1,'2021-08-11 16:42:08','2021-08-11 16:42:08',NULL);
INSERT INTO `balance_libro` VALUES (2341,3150,40741,26291,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',5500.00,NULL,NULL,1,'2021-08-11 16:42:08','2021-08-11 16:42:08',NULL),(2342,3150,40741,26287,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',6776.60,'Ganancias',NULL,1,'2021-08-11 16:55:21','2021-08-11 16:55:21',NULL),(2343,3150,40741,26280,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',23.93,NULL,NULL,1,'2021-08-17 19:44:46','2021-08-17 19:44:46',NULL),(2344,3150,40741,26281,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',14.76,NULL,NULL,1,'2021-08-17 19:45:10','2021-08-17 19:45:10',NULL),(2345,3150,40741,26282,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',25.23,NULL,NULL,1,'2021-08-17 19:45:30','2021-08-17 19:45:30',NULL),(2346,3150,40741,26283,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',36.92,NULL,NULL,1,'2021-08-17 19:46:05','2021-08-17 19:46:05',NULL),(2347,3150,40741,26284,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',16.27,NULL,NULL,1,'2021-08-17 19:48:02','2021-08-17 19:48:02',NULL),(2348,3150,40741,26285,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',39.09,NULL,NULL,1,'2021-08-17 19:48:35','2021-08-17 19:48:35',NULL),(2349,3150,40741,26286,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',28.60,NULL,NULL,1,'2021-08-17 19:49:12','2021-08-17 19:49:12',NULL),(2350,3150,40741,26287,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',17.58,NULL,NULL,1,'2021-08-17 19:49:39','2021-08-17 19:49:39',NULL),(2351,3150,40741,26288,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',42.21,NULL,NULL,1,'2021-08-17 19:50:14','2021-08-17 19:50:14',NULL),(2352,3150,40741,26289,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',18.60,NULL,NULL,1,'2021-08-17 19:50:49','2021-08-17 19:50:49',NULL),(2353,3150,40741,26290,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',31.93,NULL,NULL,1,'2021-08-17 19:51:49','2021-08-17 19:51:49',NULL),(2354,3150,40741,26291,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',46.48,NULL,NULL,1,'2021-08-17 19:52:23','2021-08-17 19:52:23',NULL),(2355,3150,40741,26282,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-27','2020-03-27',4312.77,'BANCO',NULL,1,'2021-08-17 19:58:10','2021-08-20 20:27:39','2021-08-20 20:27:39'),(2356,3150,40741,26284,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-11','2020-05-11',26009.40,'Ganancias',NULL,1,'2021-08-17 20:00:42','2021-08-17 20:00:42',NULL),(2357,3150,40741,26284,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-11','2020-05-11',184905.51,'Liquidacion Impuestos',NULL,1,'2021-08-17 20:03:54','2021-08-17 20:03:54',NULL),(2358,3150,40741,26284,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-11','2020-05-11',97996.20,'Pagos',NULL,1,'2021-08-17 20:07:45','2021-08-17 20:08:31','2021-08-17 20:08:31'),(2359,3150,40741,26284,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-11','2020-05-11',97996.20,'Pagos',NULL,1,'2021-08-17 20:08:31','2021-08-17 20:08:47','2021-08-17 20:08:47'),(2360,3150,40741,26284,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-11','2020-05-11',97996.20,'Pagos',NULL,1,'2021-08-17 20:08:47','2021-08-17 20:08:47',NULL),(2361,3150,40738,24734,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',476525.70,'Cobranzas',NULL,1,'2021-08-20 13:47:12','2021-08-20 13:47:12',NULL),(2362,3150,40738,24723,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-01','2020-01-01',13907462.68,'Asiento Apertura',NULL,1,'2021-08-20 14:14:14','2021-08-20 14:14:14',NULL),(2363,3150,40738,24733,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',96037.20,'Cobranzas',NULL,1,'2021-08-20 15:49:42','2021-08-20 15:49:42',NULL);
INSERT INTO `balance_libro` VALUES (2364,3150,40738,24734,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',261677.00,'Cobranzas',NULL,1,'2021-08-20 15:50:45','2021-08-20 15:50:45',NULL),(2365,3150,40738,24731,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',440449.53,NULL,NULL,1,'2021-08-20 15:53:43','2021-08-20 15:53:43',NULL),(2366,3150,40738,24732,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-29','2020-10-29',413276.28,'Iva',NULL,1,'2021-08-20 15:56:17','2021-08-20 15:56:17',NULL),(2367,3150,40738,24734,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',4784261.00,NULL,NULL,1,'2021-08-20 17:03:15','2021-08-20 17:03:15',NULL),(2368,3150,40738,24734,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2103383.53,NULL,NULL,1,'2021-08-20 17:06:07','2021-08-20 17:06:07',NULL),(2369,3150,40738,24734,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',6369447.75,'ajuste',NULL,1,'2021-08-20 17:09:56','2021-08-20 17:09:56',NULL),(2370,3150,40738,24723,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',1064.42,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2371,3150,40738,24723,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',501.67,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2372,3150,40738,24723,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',59324.68,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2373,3150,40738,24723,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',25.36,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2374,3150,40738,24723,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',6792.55,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2375,3150,40738,24723,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',4489.10,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2376,3150,40738,24723,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',200636.03,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2377,3150,40738,24724,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',1047.95,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2378,3150,40738,24724,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',3141.67,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2379,3150,40738,24724,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',7523.22,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2380,3150,40738,24724,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',8.60,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2381,3150,40738,24724,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',430.03,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2382,3150,40738,24724,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',11943.18,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2383,3150,40738,24724,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',15123.27,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2384,3150,40738,24725,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',895.96,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL);
INSERT INTO `balance_libro` VALUES (2385,3150,40738,24725,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',16745.53,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2386,3150,40738,24725,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',16140.41,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2387,3150,40738,24725,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',1.32,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2388,3150,40738,24725,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',977.69,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2389,3150,40738,24725,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',5019.27,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2390,3150,40738,24726,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',11529.92,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2391,3150,40738,24726,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',26138.35,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2392,3150,40738,24726,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',836.93,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2393,3150,40738,24726,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',956.38,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2394,3150,40738,24726,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',2.90,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2395,3150,40738,24727,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',1915.72,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2396,3150,40738,24727,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',749.86,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2397,3150,40738,24727,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',13222.01,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2398,3150,40738,24727,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',3618.01,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2399,3150,40738,24727,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',90.15,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2400,3150,40738,24727,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',3.98,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2401,3150,40738,24727,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',882.36,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2402,3150,40738,24728,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',624.79,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2403,3150,40738,24728,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',24.91,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2404,3150,40738,24729,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',688.06,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL);
INSERT INTO `balance_libro` VALUES (2405,3150,40738,24729,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',17.94,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2406,3150,40738,24729,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',21089.93,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2407,3150,40738,24729,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',19757.46,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2408,3150,40738,24729,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',705.32,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2409,3150,40738,24730,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',500.97,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2410,3150,40738,24730,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',1.04,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2411,3150,40738,24730,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',258.87,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2412,3150,40738,24730,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',567.04,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2413,3150,40738,24730,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',60594.16,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2414,3150,40738,24730,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',59586.16,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2415,3150,40738,24730,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',183.89,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2416,3150,40738,24730,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',95.61,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2417,3150,40738,24731,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',9084.29,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2418,3150,40738,24731,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',167297.08,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2419,3150,40738,24731,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',400.72,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2420,3150,40738,24731,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',975.60,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2421,3150,40738,24731,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',0.65,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2422,3150,40738,24731,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',216850.71,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2423,3150,40738,24732,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',342.57,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2424,3150,40738,24732,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',7030.46,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL);
INSERT INTO `balance_libro` VALUES (2425,3150,40738,24732,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',3.13,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2426,3150,40738,24732,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',120679.89,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2427,3150,40738,24732,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',306.26,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2428,3150,40738,24732,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',4397.61,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2429,3150,40738,24732,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',118384.85,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2430,3150,40738,24732,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',334.31,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2431,3150,40738,24732,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',458.49,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2432,3150,40738,24733,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',188.18,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2433,3150,40738,24733,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',5631.34,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2434,3150,40738,24733,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',3.00,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2435,3150,40738,24733,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',41097.12,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2436,3150,40738,24733,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',2664.86,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2437,3150,40738,24733,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',14019.98,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2438,3150,40738,24733,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',339.35,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2439,3150,40738,24733,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',160.67,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-08-20 17:48:32','2021-08-20 17:48:32',NULL),(2440,3150,40741,26282,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-27','2020-03-27',4326.96,'BANCO',NULL,1,'2021-08-20 20:27:39','2021-08-20 20:27:39',NULL),(2441,3150,40741,26291,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1635417.88,NULL,NULL,1,'2021-08-20 21:08:02','2021-08-20 21:08:02',NULL),(2442,3150,40741,26282,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',1287020.02,'Ventas mensuales',NULL,1,'2021-08-30 11:56:33','2021-08-30 11:56:33',NULL),(2443,3150,40741,26291,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',213861.70,'FondoS',NULL,1,'2021-09-02 11:24:24','2021-09-03 17:08:48','2021-09-03 17:08:48'),(2444,3150,40741,26291,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',22923652.86,'Bs Uso',NULL,1,'2021-09-02 12:36:34','2021-09-02 12:36:34',NULL),(2445,3150,40741,26291,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',6131.37,'ajustes',NULL,1,'2021-09-02 12:38:59','2021-09-02 12:38:59',NULL);
INSERT INTO `balance_libro` VALUES (2446,3150,40741,26291,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',4650943.98,'ajuste',NULL,1,'2021-09-02 12:43:59','2021-09-02 12:43:59',NULL),(2447,3150,40741,26291,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',13713645.67,'ajuste',NULL,1,'2021-09-02 13:04:11','2021-09-02 13:04:11',NULL),(2448,3150,40741,26291,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',18150.00,'ingresos',NULL,1,'2021-09-02 14:12:43','2021-09-02 14:12:43',NULL),(2449,3150,40741,26291,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',21417.00,'ingresos',NULL,1,'2021-09-02 14:14:10','2021-09-02 14:14:10',NULL),(2450,3150,40741,26291,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',21417.00,'ingresos',NULL,1,'2021-09-02 14:15:48','2021-09-02 14:15:48',NULL),(2451,3150,40741,26291,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',60500.00,'ingresos',NULL,1,'2021-09-02 14:18:17','2021-09-02 14:18:17',NULL),(2452,3150,40741,26291,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-10','2020-12-10',35937.00,'ingresos',NULL,1,'2021-09-02 14:19:21','2021-09-02 14:19:21',NULL),(2453,3150,40741,26291,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-10','2020-12-10',18150.00,'ingresos',NULL,1,'2021-09-02 14:20:12','2021-09-02 14:20:12',NULL),(2454,3150,40741,26291,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',29040.00,'ingresos',NULL,1,'2021-09-02 14:21:29','2021-09-02 14:21:29',NULL),(2455,3150,40741,26291,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-21','2020-12-21',95009.20,'ingresos',NULL,1,'2021-09-02 14:22:43','2021-09-02 14:22:43',NULL),(2456,3150,40741,26291,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',39930.00,'ingresos',NULL,1,'2021-09-02 14:23:53','2021-09-02 14:23:53',NULL),(2457,3150,40741,26291,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',30250.00,'ingresos',NULL,1,'2021-09-02 14:24:55','2021-09-02 14:24:55',NULL),(2458,3150,40741,26291,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',726550.00,'ingresos',NULL,1,'2021-09-02 14:34:20','2021-09-02 14:34:45','2021-09-02 14:34:45'),(2459,3150,40741,26290,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',726550.00,'ingresos',NULL,1,'2021-09-02 14:34:45','2021-09-02 14:52:06','2021-09-02 14:52:06'),(2460,3150,40741,26289,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-21','2020-10-21',728300.00,'ingresos',NULL,1,'2021-09-02 14:36:11','2021-09-02 14:51:25','2021-09-02 14:51:25'),(2461,3150,40741,26288,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',725400.00,'ingresos',NULL,1,'2021-09-02 14:37:16','2021-09-02 14:37:16',NULL),(2462,3150,40741,26287,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-25','2020-08-25',723550.00,'ingresos',NULL,1,'2021-09-02 14:38:45','2021-09-02 14:54:52','2021-09-02 14:54:52'),(2463,3150,40741,26286,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',729800.00,'ingresos',NULL,1,'2021-09-02 14:40:08','2021-09-02 14:54:29','2021-09-02 14:54:29'),(2464,3150,40741,26285,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-26','2020-06-26',595800.00,'ingresos',NULL,1,'2021-09-02 14:41:36','2021-09-02 14:41:36',NULL),(2465,3150,40741,26284,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-26','2020-05-26',731000.00,'ingresos',NULL,1,'2021-09-02 14:43:11','2021-09-02 14:54:02','2021-09-02 14:54:02'),(2466,3150,40741,26283,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-27','2020-04-27',724500.00,'ingresos',NULL,1,'2021-09-02 14:44:10','2021-09-02 14:53:30','2021-09-02 14:53:30'),(2467,3150,40741,26282,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-23','2020-03-23',715800.00,'ingresos',NULL,1,'2021-09-02 14:45:08','2021-09-02 14:53:06','2021-09-02 14:53:06');
INSERT INTO `balance_libro` VALUES (2468,3150,40741,26281,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',780000.00,'ingresos',NULL,1,'2021-09-02 14:46:08','2021-09-02 14:52:34','2021-09-02 14:52:34'),(2469,3150,40741,26289,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-21','2020-10-21',528300.00,'ingresos',NULL,1,'2021-09-02 14:51:25','2021-09-02 14:51:25',NULL),(2470,3150,40741,26290,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',526550.00,'ingresos',NULL,1,'2021-09-02 14:52:06','2021-09-02 14:52:06',NULL),(2471,3150,40741,26281,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',580000.00,'ingresos',NULL,1,'2021-09-02 14:52:34','2021-09-02 14:52:34',NULL),(2472,3150,40741,26282,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-23','2020-03-23',515800.00,'ingresos',NULL,1,'2021-09-02 14:53:06','2021-09-02 14:53:06',NULL),(2473,3150,40741,26283,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-27','2020-04-27',524500.00,'ingresos',NULL,1,'2021-09-02 14:53:30','2021-09-02 14:53:30',NULL),(2474,3150,40741,26284,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-26','2020-05-26',531000.00,'ingresos',NULL,1,'2021-09-02 14:54:02','2021-09-02 14:54:02',NULL),(2475,3150,40741,26286,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',529800.00,'ingresos',NULL,1,'2021-09-02 14:54:29','2021-09-02 14:54:29',NULL),(2476,3150,40741,26287,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-25','2020-08-25',523550.00,'ingresos',NULL,1,'2021-09-02 14:54:52','2021-09-02 14:54:52',NULL),(2477,3150,40741,26280,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',209661.60,'FondoS',NULL,1,'2021-09-03 10:47:15','2021-09-03 15:55:01','2021-09-03 15:55:01'),(2478,3150,40741,26281,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',993299.15,NULL,NULL,1,'2021-09-03 13:58:29','2021-09-03 14:02:22','2021-09-03 14:02:22'),(2479,3150,40741,26281,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',993299.15,'fondos',NULL,1,'2021-09-03 14:02:05','2021-09-03 14:02:05',NULL),(2480,3150,40741,26281,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',998299.15,'FondoS',NULL,1,'2021-09-03 14:10:42','2021-09-03 14:12:36','2021-09-03 14:12:36'),(2481,3150,40741,26281,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',993299.15,'BANCO',NULL,1,'2021-09-03 14:12:36','2021-09-03 14:12:36',NULL),(2482,3150,40741,26282,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-30','2020-03-30',80046.48,'fondos',NULL,1,'2021-09-03 14:19:24','2021-09-03 15:56:21','2021-09-03 15:56:21'),(2483,3150,40741,26283,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-29','2020-04-29',205179.66,'fondos',NULL,1,'2021-09-03 14:22:27','2021-09-03 15:52:51','2021-09-03 15:52:51'),(2484,3150,40741,26283,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-29','2020-04-29',205179.66,'fondos',NULL,1,'2021-09-03 14:22:28','2021-09-03 15:52:03','2021-09-03 15:52:03'),(2485,3150,40741,26282,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-30','2020-03-30',120219.68,'fondos',NULL,1,'2021-09-03 15:52:03','2021-09-03 17:20:51','2021-09-03 17:20:51'),(2486,3150,40741,26283,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-29','2020-04-29',205179.66,'fondos',NULL,1,'2021-09-03 15:52:51','2021-09-03 15:54:09','2021-09-03 15:54:09'),(2487,3150,40741,26284,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-29','2020-05-29',205179.66,'fondos',NULL,1,'2021-09-03 15:54:09','2021-09-03 15:54:09',NULL),(2488,3150,40741,26280,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',209661.60,'FondoS',NULL,1,'2021-09-03 15:55:01','2021-09-03 15:55:01',NULL),(2489,3150,40741,26283,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-29','2020-04-29',80046.48,'fondos',NULL,1,'2021-09-03 15:56:21','2021-09-03 17:19:28','2021-09-03 17:19:28');
INSERT INTO `balance_libro` VALUES (2490,3150,40741,26285,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',50073.97,'FondoS',NULL,1,'2021-09-03 15:58:48','2021-09-03 15:58:48',NULL),(2491,3150,40741,26286,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',100126.69,'FondoS',NULL,1,'2021-09-03 16:00:03','2021-09-03 16:00:03',NULL),(2492,3150,40741,26287,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',49440.67,'FondoS',NULL,1,'2021-09-03 16:01:24','2021-09-03 16:01:24',NULL),(2493,3150,40741,26288,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',964215.76,'FondoS',NULL,1,'2021-09-03 16:02:52','2021-09-03 16:02:52',NULL),(2494,3150,40741,26289,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',547068.22,'FondoS',NULL,1,'2021-09-03 16:04:43','2021-09-03 16:04:43',NULL),(2495,3150,40741,26290,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1031959.06,'FondoS',NULL,1,'2021-09-03 16:06:26','2021-09-03 16:06:26',NULL),(2496,3150,40741,26291,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',306354.98,'FondoS',NULL,1,'2021-09-03 16:07:23','2021-09-03 16:07:23',NULL),(2497,3150,40741,26285,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',65775.81,NULL,NULL,1,'2021-09-03 16:56:58','2021-09-03 16:56:58',NULL),(2498,3150,40741,26286,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',100126.69,NULL,NULL,1,'2021-09-03 16:59:29','2021-09-03 16:59:29',NULL),(2499,3150,40741,26283,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-29','2020-04-29',80046.48,'fondos',NULL,1,'2021-09-03 17:19:28','2021-09-03 17:19:28',NULL),(2500,3150,40741,26282,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-30','2020-03-30',120219.67,'fondos',NULL,1,'2021-09-03 17:20:51','2021-09-03 17:20:51',NULL),(2501,3150,40741,26291,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',213861.70,'fondos',NULL,1,'2021-09-03 18:24:18','2021-09-03 18:24:18',NULL),(2502,3150,40735,20105,17,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',79213.26,'Refundiciones de cuentas de resultado',NULL,1,'2021-11-10 13:12:15','2021-11-10 13:12:15',NULL),(2503,3150,40735,20105,17,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',177123.31,NULL,NULL,1,'2021-11-10 13:16:38','2021-11-10 13:20:42','2021-11-10 13:20:42'),(2504,3150,40735,20105,17,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',177123.31,NULL,NULL,1,'2021-11-10 13:20:42','2021-11-10 13:20:42',NULL),(2505,3150,40737,23187,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1508826.44,'Ventas mensuales',NULL,1,'2021-12-26 15:54:30','2021-12-26 15:54:45','2021-12-26 15:54:45'),(2510,3150,40809,122948,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1508826.44,'Ventas mensuales',NULL,1,'2021-12-26 16:13:57','2021-12-26 16:13:57',NULL),(2511,3150,40809,122948,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',261862.44,'Liquidación Iva Mensual',NULL,1,'2021-12-26 16:15:49','2021-12-26 16:15:49',NULL),(2512,3150,40809,122949,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',5525563.60,'Ventas mensuales',NULL,1,'2021-12-26 16:19:51','2021-12-26 16:19:51',NULL),(2513,3150,40809,122950,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',162043.20,'Ventas mensuales',NULL,1,'2021-12-26 16:20:55','2021-12-26 16:20:55',NULL),(2514,3150,40809,122952,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',435537.09,'Ventas mensuales',NULL,1,'2021-12-26 16:22:02','2021-12-26 16:22:02',NULL),(2515,3150,40809,122953,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',11017011.59,'Ventas mensuales',NULL,1,'2021-12-26 16:23:06','2021-12-26 16:23:06',NULL);
INSERT INTO `balance_libro` VALUES (2516,3150,40809,122957,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1171179.28,'Ventas mensuales',NULL,1,'2021-12-26 16:24:33','2021-12-26 16:24:33',NULL),(2517,3150,40809,122958,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',254039.50,'Ventas mensuales',NULL,1,'2021-12-26 16:25:40','2021-12-26 16:25:40',NULL),(2518,3150,40809,122959,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1786267.32,'Ventas mensuales',NULL,1,'2021-12-26 16:26:30','2021-12-29 18:09:43','2021-12-29 18:09:43'),(2519,3150,40809,122960,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1745953.77,'Ventas mensuales',NULL,1,'2021-12-26 16:27:19','2021-12-26 16:27:19',NULL),(2520,3150,40809,122961,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',114889.50,'Ventas mensuales',NULL,1,'2021-12-26 16:28:03','2021-12-26 16:28:03',NULL),(2521,3150,40809,122962,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',233558.29,'Ventas mensuales',NULL,1,'2021-12-26 16:28:51','2021-12-29 18:12:43','2021-12-29 18:12:43'),(2522,3150,40809,122948,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',261862.44,'Liquidación Iva Mensual',NULL,1,'2021-12-26 16:31:26','2021-12-26 17:38:16','2021-12-26 17:38:16'),(2523,3150,40809,122949,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',958982.11,'Liquidación Iva Mensual',NULL,1,'2021-12-26 16:32:53','2021-12-26 16:32:53',NULL),(2524,3150,40809,122950,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',265292.55,'Liquidación Iva Mensual',NULL,1,'2021-12-26 16:35:06','2021-12-26 16:35:06',NULL),(2525,3150,40809,122951,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1526325.96,'Liquidación Iva Mensual',NULL,1,'2021-12-26 16:38:04','2021-12-26 16:38:04',NULL),(2526,3150,40809,122952,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',293888.19,'Liquidación Iva Mensual',NULL,1,'2021-12-26 16:42:59','2021-12-30 09:12:19','2021-12-30 09:12:19'),(2527,3150,40809,122953,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1964757.42,'Liquidación Iva Mensual',NULL,1,'2021-12-26 16:47:33','2021-12-26 16:49:58','2021-12-26 16:49:58'),(2528,3150,40809,122953,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1962576.68,'Liquidación Iva Mensual',NULL,1,'2021-12-26 16:49:58','2021-12-26 16:56:09','2021-12-26 16:56:09'),(2529,3150,40809,122953,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1964757.42,'Liquidación Iva Mensual',NULL,1,'2021-12-26 16:56:09','2021-12-26 17:12:46','2021-12-26 17:12:46'),(2530,3150,40809,122953,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1964757.42,'Liquidación Iva Mensual',NULL,1,'2021-12-26 17:12:46','2021-12-26 17:17:10','2021-12-26 17:17:10'),(2531,3150,40809,122953,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1964757.42,'Liquidación Iva Mensual',NULL,1,'2021-12-26 17:17:10','2021-12-27 19:49:31','2021-12-27 19:49:31'),(2532,3150,40809,122957,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1183744.74,'Liquidación Iva Mensual',NULL,1,'2021-12-26 17:20:40','2021-12-27 19:52:19','2021-12-27 19:52:19'),(2533,3150,40809,122958,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',491647.77,'Liquidación Iva Mensual',NULL,1,'2021-12-26 17:22:37','2021-12-27 19:55:40','2021-12-27 19:55:40'),(2534,3150,40809,122959,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',317325.81,'Liquidación Iva Mensual',NULL,1,'2021-12-26 17:26:54','2021-12-27 19:57:06','2021-12-27 19:57:06'),(2535,3150,40809,122960,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',305600.41,'Liquidación Iva Mensual',NULL,1,'2021-12-26 17:30:42','2021-12-27 19:59:50','2021-12-27 19:59:50');
INSERT INTO `balance_libro` VALUES (2536,3150,40809,122961,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',84927.84,'Liquidación Iva Mensual',NULL,1,'2021-12-26 17:32:30','2021-12-26 17:35:48','2021-12-26 17:35:48'),(2537,3150,40809,122962,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',148660.11,'Liquidación Iva Mensual',NULL,1,'2021-12-26 17:34:10','2021-12-27 20:07:50','2021-12-27 20:07:50'),(2538,3150,40809,122961,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',84762.66,'Liquidación Iva Mensual',NULL,1,'2021-12-26 17:35:48','2021-12-27 20:02:17','2021-12-27 20:02:17'),(2539,3150,40809,122951,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-13','2020-10-13',302120.00,'Iva',NULL,1,'2021-12-26 17:40:12','2021-12-26 17:40:12',NULL),(2540,3150,40809,122948,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1246337.62,'COMPRAS MENSUALES',NULL,1,'2021-12-26 18:12:22','2021-12-26 18:12:22',NULL),(2541,3150,40809,122949,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',3820452.46,'COMPRAS MENSUALES',NULL,1,'2021-12-26 18:24:05','2021-12-26 18:30:02','2021-12-26 18:30:02'),(2542,3150,40809,122949,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',3820452.46,'COMPRAS MENSUALES',NULL,1,'2021-12-26 18:30:02','2021-12-29 16:50:33','2021-12-29 16:50:33'),(2543,3150,40809,122950,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1535933.45,'COMPRAS MENSUALES',NULL,1,'2021-12-26 18:35:28','2021-12-26 18:35:28',NULL),(2544,3150,40809,122951,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',5209260.66,'COMPRAS MENSUALES',NULL,1,'2021-12-26 18:38:10','2021-12-26 18:38:10',NULL),(2545,3150,40809,122952,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1725960.84,'COMPRAS MENSUALES',NULL,1,'2021-12-26 18:41:06','2021-12-26 18:41:06',NULL),(2546,3150,40809,122953,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',400595.48,'COMPRAS MENSUALES',NULL,1,'2021-12-26 18:48:34','2021-12-27 20:42:26','2021-12-27 20:42:26'),(2547,3150,40809,122959,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1603547.58,'COMPRAS MENSUALES',NULL,1,'2021-12-26 18:52:27','2021-12-27 20:52:31','2021-12-27 20:52:31'),(2548,3150,40809,122960,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',2373366.33,'COMPRAS MENSUALES',NULL,1,'2021-12-26 19:10:19','2021-12-27 21:09:14','2021-12-27 21:09:14'),(2549,3150,40809,122961,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',494425.81,'COMPRAS MENSUALES',NULL,1,'2021-12-26 19:13:37','2021-12-26 19:13:37',NULL),(2550,3150,40809,122962,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',958450.81,'COMPRAS MENSUALES',NULL,1,'2021-12-26 19:17:53','2021-12-27 21:15:41','2021-12-27 21:15:41'),(2551,3150,40809,122949,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-05','2020-08-05',1596.16,NULL,NULL,1,'2021-12-26 19:22:04','2021-12-26 19:22:04',NULL),(2552,3150,40809,122951,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-13','2020-10-13',103285.24,NULL,NULL,1,'2021-12-26 19:23:15','2021-12-26 19:23:15',NULL),(2553,3150,40809,122952,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-09','2020-11-09',8219.80,NULL,NULL,1,'2021-12-26 19:24:51','2021-12-26 19:24:51',NULL),(2554,3150,40809,122957,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',155420.17,NULL,NULL,1,'2021-12-26 19:26:01','2021-12-26 19:26:01',NULL),(2555,3150,40809,122959,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',24402.16,NULL,NULL,1,'2021-12-26 19:27:26','2021-12-26 19:27:26',NULL),(2556,3150,40809,122960,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',15886.44,NULL,NULL,1,'2021-12-26 19:28:14','2021-12-26 19:28:14',NULL);
INSERT INTO `balance_libro` VALUES (2557,3150,40809,122962,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',991.70,NULL,NULL,1,'2021-12-26 19:29:30','2021-12-26 19:29:30',NULL),(2558,3150,40809,122952,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-09','2020-11-09',1878.81,'IMPUESTO PAIS',NULL,1,'2021-12-26 19:35:14','2021-12-26 19:35:14',NULL),(2559,3150,40809,122962,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',226.67,'IMPUESTO PAIS',NULL,1,'2021-12-26 19:36:14','2021-12-26 19:36:14',NULL),(2560,3150,40809,122948,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',44842.08,'Devengamiento',NULL,1,'2021-12-26 19:53:39','2021-12-26 19:53:39',NULL),(2561,3150,40809,122949,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',164218.84,'Devengamiento',NULL,1,'2021-12-26 19:56:20','2021-12-26 19:56:20',NULL),(2562,3150,40809,122950,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',33313.16,'Devengamiento',NULL,1,'2021-12-26 19:58:14','2021-12-26 19:58:14',NULL),(2563,3150,40809,122951,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',485660.35,'Devengamiento',NULL,1,'2021-12-26 20:00:13','2021-12-26 20:00:13',NULL),(2564,3150,40809,122952,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',96127.03,'Devengamiento',NULL,1,'2021-12-26 20:05:23','2021-12-26 20:29:42','2021-12-26 20:29:42'),(2565,3150,40809,122953,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',327423.77,'Devengamiento',NULL,1,'2021-12-26 20:11:21','2021-12-26 20:11:21',NULL),(2566,3150,40809,122957,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',46297.32,'Devengamiento',NULL,1,'2021-12-26 20:14:43','2021-12-26 20:14:43',NULL),(2567,3150,40809,122958,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',26538.75,'Devengamiento',NULL,1,'2021-12-26 20:16:28','2021-12-26 20:16:28',NULL),(2568,3150,40809,122959,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',53552.43,'Devengamiento',NULL,1,'2021-12-26 20:18:33','2021-12-26 20:32:31','2021-12-26 20:32:31'),(2569,3150,40809,122960,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',46303.97,'Devengamiento',NULL,1,'2021-12-26 20:20:01','2021-12-26 20:20:01',NULL),(2570,3150,40809,122961,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',5617.81,'Devengamiento',NULL,1,'2021-12-26 20:21:31','2021-12-26 20:21:31',NULL),(2571,3150,40809,122962,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',11059.58,'Devengamiento',NULL,1,'2021-12-26 20:23:09','2021-12-26 20:38:01','2021-12-26 20:38:01'),(2572,3150,40809,122952,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',96127.03,'Devengamiento',NULL,1,'2021-12-26 20:29:42','2021-12-26 20:29:42',NULL),(2573,3150,40809,122959,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',53552.43,'Devengamiento',NULL,1,'2021-12-26 20:32:31','2021-12-26 20:32:31',NULL),(2574,3150,40809,122962,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',11059.58,'Devengamiento',NULL,1,'2021-12-26 20:38:01','2021-12-26 20:38:01',NULL),(2575,3150,40809,122949,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',331.18,'Pagos',NULL,1,'2021-12-26 20:42:21','2021-12-26 20:42:21',NULL),(2576,3150,40809,122949,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',22759.19,'Pagos',NULL,1,'2021-12-26 20:43:53','2021-12-26 20:46:04','2021-12-26 20:46:04'),(2577,3150,40809,122949,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',22759.19,'Pagos',NULL,1,'2021-12-26 20:46:04','2021-12-26 20:46:04',NULL),(2578,3150,40809,122950,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',18364.94,'Pagos',NULL,1,'2021-12-26 20:47:46','2021-12-26 20:47:46',NULL);
INSERT INTO `balance_libro` VALUES (2579,3150,40809,122951,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-13','2020-10-13',173.96,'Pagos',NULL,1,'2021-12-26 20:50:44','2021-12-26 20:50:44',NULL),(2580,3150,40809,122951,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-14','2020-10-14',6177.36,'Pagos',NULL,1,'2021-12-26 20:53:05','2021-12-26 20:53:05',NULL),(2581,3150,40809,122958,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',231.67,'Pagos',NULL,1,'2021-12-26 20:54:27','2021-12-26 20:54:27',NULL),(2582,3150,40809,122962,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',1017.16,'Pagos',NULL,1,'2021-12-26 20:56:27','2021-12-26 20:56:27',NULL),(2583,3150,40809,122962,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',44638.09,'BP - PARTICIPACIONES',NULL,1,'2021-12-26 21:02:01','2021-12-26 21:02:01',NULL),(2584,3150,40809,122948,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',96796.87,'Pagos',NULL,1,'2021-12-26 21:04:52','2021-12-26 21:07:23','2021-12-26 21:07:23'),(2585,3150,40809,122949,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-17','2020-08-17',97700.85,'Pagos',NULL,1,'2021-12-26 21:06:56','2021-12-26 21:07:32','2021-12-26 21:07:32'),(2586,3150,40809,122948,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',96796.87,'PLANES',NULL,1,'2021-12-26 21:07:23','2021-12-26 21:15:16','2021-12-26 21:15:16'),(2587,3150,40809,122949,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-17','2020-08-17',97700.85,'PLANES',NULL,1,'2021-12-26 21:07:32','2021-12-26 21:18:28','2021-12-26 21:18:28'),(2588,3150,40809,122950,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',96890.11,'PLANES',NULL,1,'2021-12-26 21:09:17','2021-12-26 21:19:56','2021-12-26 21:19:56'),(2589,3150,40809,122948,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',96796.87,'PLANES',NULL,1,'2021-12-26 21:15:16','2021-12-26 21:15:16',NULL),(2590,3150,40809,122949,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-17','2020-08-17',97700.85,'PLANES',NULL,1,'2021-12-26 21:18:28','2021-12-26 21:18:28',NULL),(2591,3150,40809,122950,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',96890.11,'PLANES',NULL,1,'2021-12-26 21:19:56','2021-12-26 21:19:56',NULL),(2592,3150,40809,122951,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-16','2020-10-16',96934.44,'PLANES',NULL,1,'2021-12-26 21:21:39','2021-12-26 21:21:39',NULL),(2593,3150,40809,122952,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-16','2020-11-16',96981.82,'PLANES',NULL,1,'2021-12-26 21:23:19','2021-12-26 21:23:19',NULL),(2594,3150,40809,122953,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',97026.15,'PLANES',NULL,1,'2021-12-26 21:26:37','2021-12-26 21:26:37',NULL),(2595,3150,40809,122957,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',97073.53,'PLANES',NULL,1,'2021-12-26 21:28:37','2021-12-26 21:28:37',NULL),(2596,3150,40809,122958,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-16','2021-02-16',5671.04,'PLANES',NULL,1,'2021-12-26 21:30:02','2021-12-26 21:32:17','2021-12-26 21:32:17'),(2597,3150,40809,122959,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',5714.60,'PLANES',NULL,1,'2021-12-26 21:31:51','2021-12-26 21:31:51',NULL),(2598,3150,40809,122958,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-16','2021-02-16',5671.04,'PLANES',NULL,1,'2021-12-26 21:32:17','2021-12-26 21:32:17',NULL),(2599,3150,40809,122960,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',5758.16,'PLANES',NULL,1,'2021-12-26 21:33:52','2021-12-26 21:33:52',NULL),(2600,3150,40809,122961,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',5801.73,'PLANES',NULL,1,'2021-12-26 21:35:16','2021-12-26 21:35:16',NULL),(2601,3150,40809,122962,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',2110.19,'PLANES',NULL,1,'2021-12-26 21:36:26','2021-12-26 21:36:26',NULL);
INSERT INTO `balance_libro` VALUES (2602,3150,40741,26288,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',245422.16,'PLANES',NULL,1,'2021-12-26 22:06:51','2021-12-26 22:07:19','2021-12-26 22:07:19'),(2603,3150,40741,26287,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',245422.16,'PLANES',NULL,1,'2021-12-26 22:07:19','2021-12-26 23:01:16','2021-12-26 23:01:16'),(2604,3150,40741,26288,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',30677.77,'PLANES',NULL,1,'2021-12-26 22:08:23','2021-12-26 23:01:16','2021-12-26 23:01:16'),(2605,3150,40741,26289,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-16','2020-10-16',30677.77,'PLANES',NULL,1,'2021-12-26 22:09:19','2021-12-26 23:01:16','2021-12-26 23:01:16'),(2606,3150,40741,26290,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-16','2020-11-16',30677.77,'PLANES',NULL,1,'2021-12-26 22:12:27','2021-12-26 23:01:16','2021-12-26 23:01:16'),(2607,3150,40741,26291,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',30677.77,'PLANES',NULL,1,'2021-12-26 22:13:37','2021-12-26 23:01:16','2021-12-26 23:01:16'),(2608,3150,40741,26295,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',30677.77,'PLANES',NULL,1,'2021-12-26 22:14:20','2021-12-26 23:01:16','2021-12-26 23:01:16'),(2609,3150,40741,26296,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-16','2021-02-16',30677.77,'PLANES',NULL,1,'2021-12-26 22:15:15','2021-12-26 23:01:16','2021-12-26 23:01:16'),(2610,3150,40741,26297,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',30677.77,'PLANES',NULL,1,'2021-12-26 22:15:42','2021-12-26 23:01:16','2021-12-26 23:01:16'),(2611,3150,40741,26298,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',30677.77,'PLANES',NULL,1,'2021-12-26 22:16:32','2021-12-26 23:01:16','2021-12-26 23:01:16'),(2612,3150,40741,26286,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1213877.47,NULL,NULL,1,'2021-12-26 22:31:21','2021-12-26 23:01:16','2021-12-26 23:01:16'),(2613,3150,40741,26287,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',2135402.84,NULL,NULL,1,'2021-12-26 22:50:24','2021-12-26 23:01:16','2021-12-26 23:01:16'),(2614,3150,40809,122949,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',245422.16,'PLANES',NULL,1,'2021-12-26 23:04:33','2021-12-26 23:04:33',NULL),(2615,3150,40809,122950,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-16','2020-06-16',30677.77,'PLANES',NULL,1,'2021-12-26 23:06:30','2021-12-26 23:06:30',NULL),(2616,3150,40809,122951,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-16','2020-10-16',30677.77,'PLANES',NULL,1,'2021-12-26 23:07:02','2021-12-26 23:07:02',NULL),(2617,3150,40809,122952,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-16','2020-11-16',30677.77,'PLANES',NULL,1,'2021-12-26 23:07:49','2021-12-26 23:07:49',NULL),(2618,3150,40809,122953,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',30677.77,'PLANES',NULL,1,'2021-12-26 23:08:22','2021-12-26 23:08:22',NULL),(2619,3150,40809,122957,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',30677.77,'PLANES',NULL,1,'2021-12-26 23:08:52','2021-12-26 23:08:52',NULL),(2620,3150,40809,122958,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-16','2021-02-16',30677.77,'PLANES',NULL,1,'2021-12-26 23:09:22','2021-12-26 23:09:22',NULL),(2621,3150,40809,122959,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',30677.77,'PLANES',NULL,1,'2021-12-26 23:10:00','2021-12-26 23:10:00',NULL),(2622,3150,40809,122960,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',30677.77,'PLANES',NULL,1,'2021-12-26 23:10:28','2021-12-26 23:10:28',NULL),(2623,3150,40809,122948,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1213877.47,NULL,NULL,1,'2021-12-26 23:23:00','2021-12-26 23:23:00',NULL);
INSERT INTO `balance_libro` VALUES (2624,3150,40809,122949,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',2135402.84,NULL,NULL,1,'2021-12-26 23:29:13','2021-12-26 23:29:13',NULL),(2625,3150,40809,122950,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2378557.39,NULL,NULL,1,'2021-12-26 23:31:26','2021-12-26 23:31:26',NULL),(2626,3150,40809,122951,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',4944016.70,NULL,NULL,1,'2021-12-26 23:35:06','2021-12-26 23:35:06',NULL),(2627,3150,40809,122952,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',3500637.34,NULL,NULL,1,'2021-12-26 23:36:51','2021-12-26 23:36:51',NULL),(2628,3150,40809,122953,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',3896633.47,NULL,NULL,1,'2021-12-26 23:39:57','2021-12-26 23:47:10','2021-12-26 23:47:10'),(2629,3150,40809,122953,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',3904534.97,NULL,NULL,1,'2021-12-26 23:47:10','2021-12-26 23:47:10',NULL),(2630,3150,40809,122957,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',10614408.66,NULL,NULL,1,'2021-12-26 23:51:42','2021-12-26 23:51:42',NULL),(2631,3150,40809,122958,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',3653788.31,NULL,NULL,1,'2021-12-26 23:54:58','2021-12-26 23:54:58',NULL),(2632,3150,40809,122959,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3687407.79,NULL,NULL,1,'2021-12-26 23:57:14','2021-12-26 23:57:14',NULL),(2633,3150,40809,122960,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1876609.81,NULL,NULL,1,'2021-12-26 23:58:40','2021-12-26 23:58:40',NULL),(2634,3150,40809,122961,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1433123.35,NULL,NULL,1,'2021-12-27 00:00:02','2021-12-27 00:00:02',NULL),(2635,3150,40809,122962,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',2553371.18,NULL,NULL,1,'2021-12-27 00:01:56','2021-12-27 00:01:56',NULL),(2636,3150,40809,122948,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',88871.59,'Devengamiento',NULL,1,'2021-12-27 00:29:09','2021-12-27 00:29:09',NULL),(2637,3150,40809,122949,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',88871.59,'Devengamiento',NULL,1,'2021-12-27 00:31:56','2021-12-27 00:31:56',NULL),(2638,3150,40809,122950,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',94751.91,'Devengamiento',NULL,1,'2021-12-27 00:35:48','2021-12-27 00:35:48',NULL),(2639,3150,40809,122951,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',134075.27,'Devengamiento',NULL,1,'2021-12-27 00:38:25','2021-12-27 00:38:25',NULL),(2640,3150,40809,122952,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',86825.27,'Devengamiento',NULL,1,'2021-12-27 00:41:13','2021-12-27 00:41:13',NULL),(2641,3150,40809,122953,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',130916.52,'Devengamiento',NULL,1,'2021-12-27 00:43:17','2021-12-27 00:43:17',NULL),(2642,3150,40809,122957,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',117261.33,'Devengamiento',NULL,1,'2021-12-27 00:45:23','2021-12-27 00:45:23',NULL),(2643,3150,40809,122958,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',59768.92,'Devengamiento',NULL,1,'2021-12-27 00:47:30','2021-12-27 00:47:30',NULL),(2644,3150,40809,122959,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',87184.16,'Devengamiento',NULL,1,'2021-12-27 00:49:11','2021-12-27 00:49:11',NULL),(2645,3150,40809,122961,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',147068.49,'Devengamiento',NULL,1,'2021-12-27 00:52:52','2021-12-27 00:52:52',NULL),(2646,3150,40809,122962,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',233499.93,'Devengamiento',NULL,1,'2021-12-27 00:56:58','2021-12-27 00:56:58',NULL);
INSERT INTO `balance_libro` VALUES (2647,3150,40809,122948,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',73562.00,'PAGOS',NULL,1,'2021-12-27 10:07:54','2021-12-27 17:28:36','2021-12-27 17:28:36'),(2648,3150,40809,122953,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-10','2020-12-10',2751.37,'PAGOS',NULL,1,'2021-12-27 10:09:36','2021-12-27 10:17:31','2021-12-27 10:17:31'),(2649,3150,40809,122958,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',27413.50,'PAGOS',NULL,1,'2021-12-27 10:16:14','2021-12-27 10:16:14',NULL),(2650,3150,40809,122953,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-10','2020-12-10',2789.43,'PAGOS',NULL,1,'2021-12-27 10:17:31','2021-12-27 10:17:31',NULL),(2651,3150,40809,122949,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',13655.24,'Pagos',NULL,1,'2021-12-27 10:19:16','2021-12-27 10:19:52','2021-12-27 10:19:52'),(2652,3150,40809,122949,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',22759.19,'Pagos',NULL,1,'2021-12-27 10:19:52','2021-12-27 10:19:52',NULL),(2653,3150,40809,122962,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',29924.88,'Pagos',NULL,1,'2021-12-27 10:22:02','2021-12-27 10:22:02',NULL),(2654,3150,40809,122950,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',66375.00,'PAGOS',NULL,1,'2021-12-27 10:29:44','2021-12-27 10:30:53','2021-12-27 10:30:53'),(2655,3150,40809,122949,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',66375.00,'PAGOS',NULL,1,'2021-12-27 10:30:53','2021-12-27 17:26:00','2021-12-27 17:26:00'),(2656,3150,40809,122950,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-08','2020-09-08',86998.45,'PAGOS',NULL,1,'2021-12-27 10:33:44','2021-12-27 17:21:52','2021-12-27 17:21:52'),(2657,3150,40809,122951,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-08','2020-10-08',92762.58,'PAGOS',NULL,1,'2021-12-27 10:36:44','2021-12-27 17:20:54','2021-12-27 17:20:54'),(2658,3150,40809,122952,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-09','2020-11-09',132161.66,'PAGOS',NULL,1,'2021-12-27 10:39:23','2021-12-27 17:19:25','2021-12-27 17:19:25'),(2659,3150,40809,122957,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',103791.56,'PAGOS',NULL,1,'2021-12-27 10:42:15','2021-12-27 17:17:45','2021-12-27 17:17:45'),(2660,3150,40809,122958,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',114668.74,'PAGOS',NULL,1,'2021-12-27 10:44:12','2021-12-27 17:16:19','2021-12-27 17:16:19'),(2661,3150,40809,122959,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',58459.84,'PAGOS',NULL,1,'2021-12-27 10:46:15','2021-12-27 17:14:18','2021-12-27 17:14:18'),(2662,3150,40809,122960,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-10','2020-04-10',75739.16,'PAGOS',NULL,1,'2021-12-27 10:47:11','2021-12-27 17:13:46','2021-12-27 17:13:46'),(2663,3150,40809,122961,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-08','2020-05-08',103975.00,'PAGOS',NULL,1,'2021-12-27 10:48:26','2021-12-27 17:06:34','2021-12-27 17:06:34'),(2664,3150,40809,122962,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',144041.73,'PAGOS',NULL,1,'2021-12-27 10:50:46','2021-12-27 17:03:59','2021-12-27 17:03:59'),(2665,3150,40809,122962,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',43267.73,'Pago Cargas',NULL,1,'2021-12-27 17:03:59','2021-12-27 17:03:59',NULL),(2666,3150,40809,122961,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',63975.00,'Pagos',NULL,1,'2021-12-27 17:09:26','2021-12-27 17:09:26',NULL),(2667,3150,40809,122960,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-10','2020-04-10',6654.16,'Pago Cargas',NULL,1,'2021-12-27 17:13:46','2021-12-27 18:00:22','2021-12-27 18:00:22'),(2668,3150,40809,122959,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',8968.84,'Pago Cargas',NULL,1,'2021-12-27 17:14:18','2021-12-27 17:14:18',NULL);
INSERT INTO `balance_libro` VALUES (2669,3150,40809,122958,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',24057.74,'PAGOS',NULL,1,'2021-12-27 17:16:19','2021-12-27 17:16:33','2021-12-27 17:16:33'),(2670,3150,40809,122958,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',24057.74,'Pago Cargas',NULL,1,'2021-12-27 17:16:33','2021-12-27 17:16:33',NULL),(2671,3150,40809,122957,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',103791.56,'PAGOS',NULL,1,'2021-12-27 17:17:45','2021-12-27 17:17:45',NULL),(2672,3150,40809,122952,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-09','2020-11-09',102161.66,'PAGOS',NULL,1,'2021-12-27 17:19:25','2021-12-27 17:19:25',NULL),(2673,3150,40809,122951,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-08','2020-10-08',22930.58,'Pago Cargas',NULL,1,'2021-12-27 17:20:54','2021-12-27 17:20:54',NULL),(2674,3150,40809,122950,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-08','2020-09-08',20623.45,'PAGOS',NULL,1,'2021-12-27 17:21:52','2021-12-27 17:22:00','2021-12-27 17:22:00'),(2675,3150,40809,122950,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-08','2020-09-08',20623.45,'Pago Cargas',NULL,1,'2021-12-27 17:22:00','2021-12-27 17:22:00',NULL),(2676,3150,40809,122949,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',40463.00,'Pagos',NULL,1,'2021-12-27 17:26:00','2021-12-27 17:26:00',NULL),(2677,3150,40809,122948,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',47650.00,'PAGOS',NULL,1,'2021-12-27 17:28:36','2021-12-27 17:28:36',NULL),(2678,3150,40809,122950,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',40463.00,'Pagos',NULL,1,'2021-12-27 17:38:31','2021-12-27 17:38:31',NULL),(2679,3150,40809,122951,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-09','2020-10-09',44832.00,'Pagos',NULL,1,'2021-12-27 17:41:01','2021-12-27 17:41:01',NULL),(2680,3150,40809,122958,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',60611.00,'Pagos',NULL,1,'2021-12-27 17:43:16','2021-12-27 17:43:16',NULL),(2681,3150,40809,122960,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-10','2020-04-10',75739.16,'Pago Cargas',NULL,1,'2021-12-27 18:00:22','2021-12-27 18:02:24','2021-12-27 18:02:24'),(2682,3150,40809,122960,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-10','2020-04-10',75739.16,'Pago Cargas',NULL,1,'2021-12-27 18:02:24','2021-12-27 18:06:42','2021-12-27 18:06:42'),(2683,3150,40809,122960,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-10','2020-04-10',85262.77,'Pago Cargas',NULL,1,'2021-12-27 18:06:42','2021-12-27 18:06:58','2021-12-27 18:06:58'),(2684,3150,40809,122960,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-10','2020-04-10',85262.77,'Pago Cargas-sueldos',NULL,1,'2021-12-27 18:06:58','2021-12-27 18:06:58',NULL),(2685,3150,40809,122962,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',60774.00,'Pagos',NULL,1,'2021-12-27 18:11:57','2021-12-27 18:11:57',NULL),(2686,3150,40809,122953,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1922138.91,'Liquidación Iva Mensual',NULL,1,'2021-12-27 19:49:31','2021-12-27 19:49:31',NULL),(2687,3150,40809,122957,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1149304.17,'Liquidación Iva Mensual',NULL,1,'2021-12-27 19:52:19','2021-12-27 19:52:19',NULL),(2688,3150,40809,122958,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',471928.11,'Liquidación Iva Mensual',NULL,1,'2021-12-27 19:55:40','2021-12-27 19:55:40',NULL),(2689,3150,40809,122959,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',313247.84,'Liquidación Iva Mensual',NULL,1,'2021-12-27 19:57:06','2021-12-27 19:57:06',NULL),(2690,3150,40809,122960,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',304557.85,'Liquidación Iva Mensual',NULL,1,'2021-12-27 19:59:50','2021-12-27 19:59:50',NULL);
INSERT INTO `balance_libro` VALUES (2691,3150,40809,122961,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',62113.11,'Liquidación Iva Mensual',NULL,1,'2021-12-27 20:02:17','2021-12-27 20:02:17',NULL),(2692,3150,40809,122962,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',130007.73,'Liquidación Iva Mensual',NULL,1,'2021-12-27 20:07:50','2021-12-27 20:07:50',NULL),(2693,3150,40809,122953,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',299637.81,'COMPRAS MENSUALES',NULL,1,'2021-12-27 20:42:26','2021-12-27 20:42:26',NULL),(2694,3150,40809,122959,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1580050.70,'COMPRAS MENSUALES',NULL,1,'2021-12-27 20:52:31','2021-12-27 20:52:31',NULL),(2695,3150,40809,122960,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1287762.03,'COMPRAS MENSUALES',NULL,1,'2021-12-27 21:09:14','2021-12-29 17:51:28','2021-12-29 17:51:28'),(2696,3150,40809,122962,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',944009.55,'COMPRAS MENSUALES',NULL,1,'2021-12-27 21:15:41','2021-12-27 21:15:41',NULL),(2697,3150,40809,122949,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',3878012.01,'COMPRAS MENSUALES',NULL,1,'2021-12-29 16:50:33','2021-12-29 16:50:33',NULL),(2698,3150,40809,122957,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',1823500.16,'COMPRAS MENSUALES',NULL,1,'2021-12-29 17:02:50','2021-12-29 17:02:50',NULL),(2699,3150,40809,122958,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',3444753.67,'COMPRAS MENSUALES',NULL,1,'2021-12-29 17:15:23','2021-12-29 17:16:34','2021-12-29 17:16:34'),(2700,3150,40809,122958,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',3446436.12,'COMPRAS MENSUALES',NULL,1,'2021-12-29 17:47:38','2021-12-29 17:51:57','2021-12-29 17:51:57'),(2701,3150,40809,122960,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1287762.03,'COMPRAS MENSUALES',NULL,1,'2021-12-29 17:51:28','2021-12-29 17:51:28',NULL),(2702,3150,40809,122958,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',3446436.12,'COMPRAS MENSUALES',NULL,1,'2021-12-29 17:51:57','2021-12-29 17:51:57',NULL),(2703,3150,40809,122947,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-01','2020-06-01',14479786.20,NULL,NULL,1,'2021-12-29 18:03:54','2021-12-29 18:04:18','2021-12-29 18:04:18'),(2704,3150,40809,122947,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-01','2020-06-01',14479786.20,'Asiento Apertura',NULL,1,'2021-12-29 18:04:18','2021-12-30 09:00:54','2021-12-30 09:00:54'),(2705,3150,40809,122959,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1801909.01,'Ventas mensuales',NULL,1,'2021-12-29 18:09:43','2021-12-29 18:09:43',NULL),(2706,3150,40809,122962,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',196253.53,'Ventas mensuales',NULL,1,'2021-12-29 18:12:43','2021-12-29 18:12:43',NULL),(2707,3150,40809,122951,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',291445.05,'Imp. a las Ganancias',NULL,1,'2021-12-30 08:03:14','2021-12-30 08:03:14',NULL),(2708,3150,40809,122948,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',14479786.20,'Asiento Apertura',NULL,1,'2021-12-30 09:00:54','2022-05-04 14:59:42','2022-05-04 14:59:42'),(2709,3150,40809,122959,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1174855.16,'Cobranzas',NULL,1,'2021-12-30 09:07:09','2021-12-30 09:08:15','2021-12-30 09:08:15'),(2710,3150,40809,122959,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',2674855.16,'Cobranzas',NULL,1,'2021-12-30 09:08:15','2021-12-30 10:44:26','2021-12-30 10:44:26'),(2711,3150,40809,122952,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',293888.19,'Liquidación Iva Mensual',NULL,1,'2021-12-30 09:12:19','2021-12-30 09:12:19',NULL);
INSERT INTO `balance_libro` VALUES (2712,3150,40809,122961,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',2713110.91,'otros',NULL,1,'2021-12-30 09:32:38','2021-12-30 09:36:33','2021-12-30 09:36:33'),(2713,3150,40809,122961,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',2713110.91,'otros',NULL,1,'2021-12-30 09:36:33','2021-12-30 10:41:26','2021-12-30 10:41:26'),(2714,3150,40809,122962,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',6958.91,'pagos',NULL,1,'2021-12-30 09:37:40','2021-12-30 10:40:42','2021-12-30 10:40:42'),(2715,3150,40809,122962,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',840480.28,'Ajuste por inflación',NULL,1,'2021-12-30 09:48:11','2021-12-30 09:48:11',NULL),(2716,3150,40809,122962,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',5884848.41,'Ajuste por inflación',NULL,1,'2021-12-30 09:50:30','2021-12-30 09:50:30',NULL),(2717,3150,40809,122948,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',986.51,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2718,3150,40809,122948,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',15948.07,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2719,3150,40809,122948,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',4310.72,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2720,3150,40809,122948,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',34787.37,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2721,3150,40809,122948,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2904.01,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2722,3150,40809,122948,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',4752.33,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2723,3150,40809,122948,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',27062.31,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2724,3150,40809,122948,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2194.70,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2725,3150,40809,122948,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',109758.06,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2726,3150,40809,122948,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2982.65,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2727,3150,40809,122948,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',590437.97,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2728,3150,40809,122948,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',32547.87,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2729,3150,40809,122948,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',137315.12,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2730,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',2738.62,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2731,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',14673.16,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL);
INSERT INTO `balance_libro` VALUES (2732,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',10800.71,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2733,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',59834.30,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2734,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',328011.24,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2735,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',1985368.37,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2736,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',45916.82,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2737,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',402.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2738,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',20697.99,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2739,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',593677.91,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2740,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',3958.04,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2741,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',4030.28,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2742,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',31941.19,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2743,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',242764.74,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2744,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',2480.75,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2745,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',3159.62,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2746,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',23928.39,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2747,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',782.57,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2748,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',10651.63,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2749,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',1827.98,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2750,3150,40809,122949,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',60296.95,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2751,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2753.66,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL);
INSERT INTO `balance_libro` VALUES (2752,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',3809.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2753,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',5734.97,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2754,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',30742.25,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2755,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2396.23,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2756,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',21556.32,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2757,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',38729.52,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2758,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2205.78,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2759,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1903.24,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2760,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',215.78,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2761,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',69462.56,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2762,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',56118.28,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2763,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',375.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2764,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2894.19,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2765,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',11803.08,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2766,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',6046.55,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2767,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1831.77,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2768,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',8.77,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2769,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1112.08,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2770,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',52925.07,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2771,3150,40809,122950,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',284019.94,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL);
INSERT INTO `balance_libro` VALUES (2772,3150,40809,122951,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',2696.41,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2773,3150,40809,122951,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',99685.81,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2774,3150,40809,122951,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',18896.11,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2775,3150,40809,122951,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',146755.84,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2776,3150,40809,122951,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',609679.58,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2777,3150,40809,122951,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',3268.81,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2778,3150,40809,122951,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',26379.36,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2779,3150,40809,122951,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',163270.71,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2780,3150,40809,122951,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',68710.27,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2781,3150,40809,122951,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',67789.20,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2782,3150,40809,122951,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',6089.59,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2783,3150,40809,122951,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',295059.61,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2784,3150,40809,122951,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',2188.84,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2785,3150,40809,122951,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',16557.93,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2786,3150,40809,122952,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',11834.28,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2787,3150,40809,122952,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1456.53,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2788,3150,40809,122952,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',3927.80,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2789,3150,40809,122952,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',52819.06,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2790,3150,40809,122952,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',109223.75,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2791,3150,40809,122952,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',13894.91,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL);
INSERT INTO `balance_libro` VALUES (2792,3150,40809,122952,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',241.48,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2793,3150,40809,122952,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',570.11,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2794,3150,40809,122952,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',4956.90,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2795,3150,40809,122952,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',54120.01,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2796,3150,40809,122952,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',4381.53,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2797,3150,40809,122952,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',192828.88,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2798,3150,40809,122952,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',2336.24,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2799,3150,40809,122952,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',2487.72,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2800,3150,40809,122952,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',14337.69,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2801,3150,40809,122952,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',2878.17,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2802,3150,40809,122952,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',68964.35,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2803,3150,40809,122952,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',23226.88,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2804,3150,40809,122952,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',26829.74,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2805,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',714.10,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2806,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',46165.13,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2807,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2909.75,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2808,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',3622.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2809,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',0.12,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2810,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',29234.40,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2811,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1046.46,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL);
INSERT INTO `balance_libro` VALUES (2812,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',5507.22,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2813,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',5021.64,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2814,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',3013.60,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2815,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',8805.73,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2816,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1922.79,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2817,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',5256.58,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2818,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2305774.97,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2819,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',82917.98,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2820,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',296.93,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2821,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',30142.48,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2822,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',156.76,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2823,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',13938.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2824,3150,40809,122953,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1729.68,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2825,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',18177.75,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2826,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',2213.48,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2827,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',394.82,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2828,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',51877.14,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2829,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',144.70,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2830,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',197913.90,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2831,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',7117.18,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL);
INSERT INTO `balance_libro` VALUES (2832,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',8419.22,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2833,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',84975.04,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2834,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',531.46,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2835,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',592.97,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2836,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',76997.31,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2837,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1331.38,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2838,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1181.90,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2839,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',4108.38,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2840,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',40494.34,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2841,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',2627.51,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2842,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',0.02,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2843,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',21204.70,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2844,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',10314.62,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2845,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',12881.87,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2846,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1307.39,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2847,3150,40809,122957,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',10331.43,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2848,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',7608.95,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2849,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',344.36,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2850,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1057.09,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2851,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',45498.71,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL);
INSERT INTO `balance_libro` VALUES (2852,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',8530.22,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2853,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',24159.69,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2854,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',71879.92,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2855,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',76897.41,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2856,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',6841.99,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2857,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',37.74,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2858,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',17.19,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2859,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',37879.31,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2860,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',13727.84,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2861,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',149.31,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2862,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',21.81,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2863,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',932.59,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2864,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',34201.81,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2865,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',1229.93,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2866,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',135.46,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2867,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',145822.74,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2868,3150,40809,122958,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',60763.39,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2869,3150,40809,122959,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',88.16,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2870,3150,40809,122959,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',2543.48,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2871,3150,40809,122959,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',13919.80,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL);
INSERT INTO `balance_libro` VALUES (2872,3150,40809,122959,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',20089.82,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2873,3150,40809,122959,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',8001.63,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2874,3150,40809,122959,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',8214.55,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2875,3150,40809,122959,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',0.06,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2876,3150,40809,122959,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1043.10,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2877,3150,40809,122959,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',7415.88,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2878,3150,40809,122959,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',8417.79,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2879,3150,40809,122959,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',4777.47,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2880,3150,40809,122959,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',5865.45,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2881,3150,40809,122959,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',874.67,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2882,3150,40809,122959,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',153.07,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2883,3150,40809,122959,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',62313.32,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2884,3150,40809,122959,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',4344.89,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2885,3150,40809,122959,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',163106.00,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2886,3150,40809,122959,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1758.80,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2887,3150,40809,122959,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',15786.18,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2888,3150,40809,122960,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',9679.15,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2889,3150,40809,122960,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',43.77,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2890,3150,40809,122960,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',95277.35,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2891,3150,40809,122960,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',3057.46,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL);
INSERT INTO `balance_libro` VALUES (2892,3150,40809,122960,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',14177.76,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2893,3150,40809,122960,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',9344.85,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2894,3150,40809,122960,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',236.22,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2895,3150,40809,122960,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',783.09,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2896,3150,40809,122960,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1173.57,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2897,3150,40809,122960,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',244.96,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2898,3150,40809,122960,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',987.22,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2899,3150,40809,122960,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',821.28,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2900,3150,40809,122960,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',7436.01,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2901,3150,40809,122960,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',4622.11,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2902,3150,40809,122960,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',22191.26,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2903,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',20.29,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2904,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',105.91,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2905,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',109.96,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2906,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',507.93,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2907,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',31.63,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2908,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',58957.02,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2909,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',513.32,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2910,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',49.00,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2911,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',144.97,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL);
INSERT INTO `balance_libro` VALUES (2912,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1993.19,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2913,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',3014.23,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2914,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',104.30,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2915,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',214.01,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2916,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',20.99,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2917,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',4138.61,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2918,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',50.77,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2919,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',245.51,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2920,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',458.15,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2921,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',539.67,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2922,3150,40809,122961,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',3697.29,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2021-12-30 10:28:21','2021-12-30 10:28:21',NULL),(2923,3150,40809,122962,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',449415.20,'Amortización del Ejercicio',NULL,1,'2021-12-30 10:33:37','2021-12-30 10:33:37',NULL),(2924,3150,40809,122962,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',6958.90,'pagos',NULL,1,'2021-12-30 10:40:42','2021-12-30 10:40:42',NULL),(2925,3150,40809,122961,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',2713110.91,'otros',NULL,1,'2021-12-30 10:41:26','2021-12-30 10:41:26',NULL),(2926,3150,40809,122959,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3174855.16,'Cobranzas',NULL,1,'2021-12-30 10:44:26','2021-12-30 10:44:26',NULL),(2927,3150,40809,122962,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',2700000.00,'pagos',NULL,1,'2021-12-30 10:50:19','2021-12-30 10:50:19',NULL),(2928,3150,40736,21650,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',445122.75,'Amortizac. del ejecicio',NULL,1,'2022-02-18 10:35:47','2022-02-18 10:35:47',NULL),(2929,3150,40736,21650,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',373368.69,'Ajuste por inflacion',NULL,1,'2022-02-18 10:39:01','2022-02-18 10:39:01',NULL),(2930,3150,40736,21650,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',601077.04,'Ajuste por inflación',NULL,1,'2022-02-18 10:40:52','2022-02-18 10:40:52',NULL),(2931,3150,40736,21639,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',460.81,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2932,3150,40736,21639,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',2491.02,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL);
INSERT INTO `balance_libro` VALUES (2933,3150,40736,21639,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',6628.21,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2934,3150,40736,21639,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',253295.30,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2935,3150,40736,21639,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',12.56,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2936,3150,40736,21639,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',1159.94,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2937,3150,40736,21639,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',216.97,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2938,3150,40736,21639,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',293423.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2939,3150,40736,21640,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',532.31,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2940,3150,40736,21640,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',6102.60,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2941,3150,40736,21640,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',439.00,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2942,3150,40736,21640,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',307658.99,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2943,3150,40736,21640,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',1067.96,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2944,3150,40736,21640,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',199.77,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2945,3150,40736,21640,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',7.97,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2946,3150,40736,21640,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',292119.09,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2947,3150,40736,21641,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',5258.11,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2948,3150,40736,21641,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',364.55,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2949,3150,40736,21641,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',1082.64,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2950,3150,40736,21641,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',2873.30,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2951,3150,40736,21641,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',222394.22,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2952,3150,40736,21641,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',173.42,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL);
INSERT INTO `balance_libro` VALUES (2953,3150,40736,21641,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',10.96,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2954,3150,40736,21641,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',1196.22,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2955,3150,40736,21641,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',246158.67,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2956,3150,40736,21641,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',2987.85,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2957,3150,40736,21642,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',340.72,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2958,3150,40736,21642,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',23131.03,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2959,3150,40736,21642,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',161.14,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2960,3150,40736,21642,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',17.89,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2961,3150,40736,21642,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',4055.11,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2962,3150,40736,21642,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',43.05,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2963,3150,40736,21642,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',4885.67,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2964,3150,40736,21643,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',3741.30,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2965,3150,40736,21643,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',6761.38,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2966,3150,40736,21643,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',312.38,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2967,3150,40736,21643,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',220.79,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2968,3150,40736,21643,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',0.01,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2969,3150,40736,21644,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',276.95,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2970,3150,40736,21644,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',3969.81,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2971,3150,40736,21644,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',15.27,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2972,3150,40736,21644,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',130.93,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL);
INSERT INTO `balance_libro` VALUES (2973,3150,40736,21644,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',3294.95,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2974,3150,40736,21645,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',3514.99,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2975,3150,40736,21645,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',3.78,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2976,3150,40736,21645,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',115.93,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2977,3150,40736,21645,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',24429.17,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2978,3150,40736,21645,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',234.38,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2979,3150,40736,21646,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',2896.75,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2980,3150,40736,21646,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',194.02,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2981,3150,40736,21646,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',2404.30,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2982,3150,40736,21646,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',95.54,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2983,3150,40736,21646,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',10.28,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2984,3150,40736,21647,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',74.72,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2985,3150,40736,21647,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',9.29,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2986,3150,40736,21647,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1880.29,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2987,3150,40736,21647,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2265.41,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2988,3150,40736,21647,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',151.89,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2989,3150,40736,21648,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',54582.31,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2990,3150,40736,21648,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',41266.07,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2991,3150,40736,21648,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',48.10,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2992,3150,40736,21648,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',2.78,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL);
INSERT INTO `balance_libro` VALUES (2993,3150,40736,21648,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1210.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2994,3150,40736,21648,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',2132.48,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2995,3150,40736,21648,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1458.37,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2996,3150,40736,21648,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',102.77,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2997,3150,40736,21649,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',2321.96,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2998,3150,40736,21649,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',10.44,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(2999,3150,40736,21649,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1201.67,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(3000,3150,40736,21649,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',4548.84,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(3001,3150,40736,21649,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',55.52,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(3002,3150,40736,21649,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',59432.39,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(3003,3150,40736,21649,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',39.24,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(3004,3150,40736,21649,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',99.02,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(3005,3150,40736,21649,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',664.92,'Ajuste por Inflacion Asiento Mensual',NULL,1,'2022-02-18 10:42:24','2022-02-18 10:42:24',NULL),(3006,3150,40736,21643,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',26575.76,'Imp. a las Ganancias',NULL,1,'2022-02-18 11:34:52','2022-02-18 11:34:52',NULL),(3007,3150,40736,21650,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2611.27,NULL,NULL,1,'2022-02-18 12:06:01','2022-02-18 12:06:01',NULL),(3008,3150,40720,1537,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-08-01','2018-08-01',3779309.80,'Asiento Apertura',NULL,1,'2022-05-04 14:41:07','2022-05-04 14:41:07',NULL),(3009,3150,40720,1551,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',130000.00,'cobros',NULL,1,'2022-05-04 14:47:01','2022-05-04 14:47:01',NULL),(3010,3150,40720,1551,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',1135265.32,'Ajuste por inflación',NULL,1,'2022-05-04 14:47:34','2022-05-04 14:47:34',NULL),(3011,3150,40809,122948,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',14479786.20,'Asiento Apertura',NULL,1,'2022-05-04 14:59:42','2022-05-04 14:59:42',NULL),(3012,3150,40737,23176,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-01','2019-11-01',7364113.37,'Apertura',NULL,1,'2022-05-04 14:59:45','2022-05-04 14:59:45',NULL),(3013,3150,40736,21639,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-01','2020-01-01',3410974.80,NULL,NULL,1,'2022-05-04 15:04:19','2022-05-04 15:04:19',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13164 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,3150,1,40719,1518,10,359,1,1000.00,NULL,'2021-03-18 14:33:03','2021-03-18 14:33:03',NULL),(2,3150,1,40719,1518,10,14,2,1000.00,NULL,'2021-03-18 14:33:03','2021-03-18 14:33:03',NULL),(3,3150,2,40720,1537,19,359,1,22014.49,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(4,3150,2,40720,1537,19,482,1,13103.00,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(5,3150,2,40720,1537,19,425,1,447640.47,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(6,3150,2,40720,1537,19,410,1,191759.99,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(7,3150,2,40720,1537,19,13,1,1135518.00,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(8,3150,2,40720,1537,19,20,1,234000.87,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(9,3150,2,40720,1537,19,437,1,70273.74,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(10,3150,2,40720,1537,19,483,1,721616.17,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(11,3150,2,40720,1537,19,484,1,602088.01,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(12,3150,2,40720,1537,19,485,1,218166.31,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(13,3150,2,40720,1537,19,486,1,15634.36,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(14,3150,2,40720,1537,19,392,1,8315.00,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(15,3150,2,40720,1537,19,46,1,80738.47,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(16,3150,2,40720,1537,19,48,2,59274.27,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(17,3150,2,40720,1537,19,42,1,1101.73,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(18,3150,2,40720,1537,19,44,2,1101.73,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(19,3150,2,40720,1537,19,391,1,17339.19,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(20,3150,2,40720,1537,19,415,2,10644.58,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(21,3150,2,40720,1537,19,369,2,10000.00,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(22,3150,2,40720,1537,19,88,2,11949.23,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(23,3150,2,40720,1537,19,89,2,62500.00,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(24,3150,2,40720,1537,19,381,2,4389.85,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(25,3150,2,40720,1537,19,92,2,1998813.23,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(26,3150,2,40720,1537,19,57,2,22990.04,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(27,3150,2,40720,1537,19,487,2,12475.29,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(28,3150,2,40720,1537,19,62,2,58429.00,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(29,3150,2,40720,1537,19,63,2,132612.23,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(30,3150,2,40720,1537,19,489,2,2706.00,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(31,3150,2,40720,1537,19,64,2,6814.03,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(32,3150,2,40720,1537,19,488,2,1000.00,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(33,3150,2,40720,1537,19,74,2,104091.76,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(34,3150,2,40720,1537,19,411,2,212710.03,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(35,3150,2,40720,1537,19,435,2,1836.86,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(36,3150,2,40720,1537,19,78,2,40672.67,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31');
INSERT INTO `balance_libro_details` VALUES (37,3150,2,40720,1537,19,367,2,149000.00,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(38,3150,2,40720,1537,19,365,2,60000.00,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(39,3150,2,40720,1537,19,490,2,815299.00,NULL,'2021-05-03 21:33:21','2021-05-03 21:36:31','2021-05-03 21:36:31'),(40,3150,3,40720,1537,19,359,1,22014.49,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(41,3150,3,40720,1537,19,482,1,13103.00,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(42,3150,3,40720,1537,19,425,1,447640.47,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(43,3150,3,40720,1537,19,410,1,191759.99,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(44,3150,3,40720,1537,19,13,1,1135518.00,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(45,3150,3,40720,1537,19,20,1,234000.87,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(46,3150,3,40720,1537,19,437,1,70273.74,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(47,3150,3,40720,1537,19,483,1,721616.17,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(48,3150,3,40720,1537,19,484,1,602088.01,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(49,3150,3,40720,1537,19,485,1,218166.31,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(50,3150,3,40720,1537,19,486,1,15634.36,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(51,3150,3,40720,1537,19,392,1,8315.00,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(52,3150,3,40720,1537,19,46,1,80738.47,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(53,3150,3,40720,1537,19,48,2,59274.27,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(54,3150,3,40720,1537,19,42,1,1101.73,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(55,3150,3,40720,1537,19,44,2,1101.73,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(56,3150,3,40720,1537,19,391,1,17339.19,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(57,3150,3,40720,1537,19,415,2,10644.58,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(58,3150,3,40720,1537,19,369,2,10000.00,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(59,3150,3,40720,1537,19,88,2,11949.23,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(60,3150,3,40720,1537,19,89,2,62500.00,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(61,3150,3,40720,1537,19,381,2,4389.85,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(62,3150,3,40720,1537,19,92,2,1998813.23,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(63,3150,3,40720,1537,19,57,2,22990.04,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(64,3150,3,40720,1537,19,487,2,12475.29,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(65,3150,3,40720,1537,19,62,2,58429.00,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(66,3150,3,40720,1537,19,63,2,132612.23,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(67,3150,3,40720,1537,19,489,2,2706.00,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(68,3150,3,40720,1537,19,64,2,6814.03,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(69,3150,3,40720,1537,19,488,2,1000.00,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(70,3150,3,40720,1537,19,74,2,104091.76,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(71,3150,3,40720,1537,19,411,2,212710.03,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07');
INSERT INTO `balance_libro_details` VALUES (72,3150,3,40720,1537,19,435,2,1836.86,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(73,3150,3,40720,1537,19,78,2,40672.67,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(74,3150,3,40720,1537,19,367,2,149000.00,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(75,3150,3,40720,1537,19,365,2,60000.00,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(76,3150,3,40720,1537,19,490,2,815299.00,NULL,'2021-05-03 21:36:31','2022-05-04 14:41:07','2022-05-04 14:41:07'),(77,3150,4,40720,1537,2,13,1,1084894.12,NULL,'2021-05-03 21:38:55','2021-05-03 21:38:55',NULL),(78,3150,4,40720,1537,2,96,2,896606.71,NULL,'2021-05-03 21:38:55','2021-05-03 21:38:55',NULL),(79,3150,4,40720,1537,2,67,2,188287.41,NULL,'2021-05-03 21:38:55','2021-05-03 21:38:55',NULL),(80,3150,5,40720,1538,2,13,1,1197991.04,NULL,'2021-05-03 21:39:37','2021-05-03 21:39:37',NULL),(81,3150,5,40720,1538,2,96,2,990075.24,NULL,'2021-05-03 21:39:37','2021-05-03 21:39:37',NULL),(82,3150,5,40720,1538,2,67,2,207915.80,NULL,'2021-05-03 21:39:37','2021-05-03 21:39:37',NULL),(83,3150,6,40720,1539,2,13,1,1152271.88,NULL,'2021-05-03 21:40:14','2021-05-03 21:40:14',NULL),(84,3150,6,40720,1539,2,96,2,952290.81,NULL,'2021-05-03 21:40:14','2021-05-03 21:40:14',NULL),(85,3150,6,40720,1539,2,67,2,199981.07,NULL,'2021-05-03 21:40:14','2021-05-03 21:40:14',NULL),(86,3150,7,40720,1540,2,13,1,1360823.73,NULL,'2021-05-03 21:40:52','2021-05-03 21:40:52',NULL),(87,3150,7,40720,1540,2,96,2,1124647.71,NULL,'2021-05-03 21:40:52','2021-05-03 21:40:52',NULL),(88,3150,7,40720,1540,2,67,2,236176.02,NULL,'2021-05-03 21:40:52','2021-05-03 21:40:52',NULL),(89,3150,8,40720,1541,2,13,1,1341856.93,NULL,'2021-05-03 21:41:30','2021-05-03 21:41:30',NULL),(90,3150,8,40720,1541,2,96,2,1108972.67,NULL,'2021-05-03 21:41:30','2021-05-03 21:41:30',NULL),(91,3150,8,40720,1541,2,67,2,232884.26,NULL,'2021-05-03 21:41:30','2021-05-03 21:41:30',NULL),(92,3150,9,40720,1545,2,13,1,1425489.94,NULL,'2021-05-03 21:42:17','2021-05-03 21:42:17',NULL),(93,3150,9,40720,1545,2,96,2,1178090.86,NULL,'2021-05-03 21:42:17','2021-05-03 21:42:17',NULL),(94,3150,9,40720,1545,2,67,2,247399.08,NULL,'2021-05-03 21:42:17','2021-05-03 21:42:17',NULL),(95,3150,10,40720,1546,2,13,1,1309581.27,NULL,'2021-05-03 21:42:46','2021-05-03 21:42:46',NULL),(96,3150,10,40720,1546,2,96,2,1082298.57,NULL,'2021-05-03 21:42:46','2021-05-03 21:42:46',NULL),(97,3150,10,40720,1546,2,67,2,227282.70,NULL,'2021-05-03 21:42:46','2021-05-03 21:42:46',NULL),(98,3150,11,40720,1547,2,13,1,1397942.85,NULL,'2021-05-03 21:43:30','2021-05-03 21:43:30',NULL),(99,3150,11,40720,1547,2,96,2,1155324.67,NULL,'2021-05-03 21:43:30','2021-05-03 21:43:30',NULL),(100,3150,11,40720,1547,2,67,2,242618.18,NULL,'2021-05-03 21:43:30','2021-05-03 21:43:30',NULL),(101,3150,12,40720,1548,2,13,1,1542747.81,NULL,'2021-05-03 21:44:06','2021-05-03 21:44:06',NULL),(102,3150,12,40720,1548,2,96,2,1274998.19,NULL,'2021-05-03 21:44:06','2021-05-03 21:44:06',NULL),(103,3150,12,40720,1548,2,67,2,267749.62,NULL,'2021-05-03 21:44:06','2021-05-03 21:44:06',NULL),(104,3150,13,40720,1549,2,13,1,1400657.91,NULL,'2021-05-03 21:44:41','2021-05-03 21:44:41',NULL),(105,3150,13,40720,1549,2,96,2,1157568.52,NULL,'2021-05-03 21:44:41','2021-05-03 21:44:41',NULL),(106,3150,13,40720,1549,2,67,2,243089.39,NULL,'2021-05-03 21:44:41','2021-05-03 21:44:41',NULL),(107,3150,14,40720,1550,2,13,1,1667013.02,NULL,'2021-05-03 21:45:13','2021-05-03 21:45:13',NULL),(108,3150,14,40720,1550,2,96,2,1377696.71,NULL,'2021-05-03 21:45:13','2021-05-03 21:45:13',NULL),(109,3150,14,40720,1550,2,67,2,289316.31,NULL,'2021-05-03 21:45:13','2021-05-03 21:45:13',NULL),(110,3150,15,40720,1551,2,13,1,1733231.20,NULL,'2021-05-03 21:45:51','2021-05-03 21:45:51',NULL),(111,3150,15,40720,1551,2,96,2,1432422.48,NULL,'2021-05-03 21:45:51','2021-05-03 21:45:51',NULL),(112,3150,15,40720,1551,2,67,2,300808.72,NULL,'2021-05-03 21:45:51','2021-05-03 21:45:51',NULL);
INSERT INTO `balance_libro_details` VALUES (113,3150,16,40720,1537,15,67,1,188287.41,NULL,'2021-05-03 21:51:44','2021-05-03 21:51:44',NULL),(114,3150,16,40720,1537,15,68,2,32537.78,NULL,'2021-05-03 21:51:44','2021-05-03 21:51:44',NULL),(115,3150,16,40720,1537,15,25,2,286.47,NULL,'2021-05-03 21:51:44','2021-05-03 21:51:44',NULL),(116,3150,16,40720,1537,15,74,2,155463.16,NULL,'2021-05-03 21:51:44','2021-05-03 21:51:44',NULL),(117,3150,17,40720,1538,15,67,1,207915.80,NULL,'2021-05-03 21:52:16','2021-05-03 21:52:16',NULL),(118,3150,17,40720,1538,15,68,2,23005.31,NULL,'2021-05-03 21:52:16','2021-05-03 21:52:16',NULL),(119,3150,17,40720,1538,15,25,2,1077.44,NULL,'2021-05-03 21:52:16','2021-05-03 21:52:16',NULL),(120,3150,17,40720,1538,15,74,2,183833.05,NULL,'2021-05-03 21:52:16','2021-05-03 21:52:16',NULL),(121,3150,18,40720,1539,15,67,1,199981.07,NULL,'2021-05-03 21:53:06','2021-05-03 21:53:06',NULL),(122,3150,18,40720,1539,15,68,2,37926.43,NULL,'2021-05-03 21:53:06','2021-05-03 21:53:06',NULL),(123,3150,18,40720,1539,15,25,2,684.87,NULL,'2021-05-03 21:53:06','2021-05-03 21:53:06',NULL),(124,3150,18,40720,1539,15,74,2,161369.77,NULL,'2021-05-03 21:53:06','2021-05-03 21:53:06',NULL),(125,3150,19,40720,1540,15,67,1,236176.02,NULL,'2021-05-03 21:54:01','2021-05-03 21:54:01',NULL),(126,3150,19,40720,1540,15,68,2,30133.30,NULL,'2021-05-03 21:54:01','2021-05-03 21:54:01',NULL),(127,3150,19,40720,1540,15,25,2,347.25,NULL,'2021-05-03 21:54:01','2021-05-03 21:54:01',NULL),(128,3150,19,40720,1540,15,74,2,205695.47,NULL,'2021-05-03 21:54:01','2021-05-03 21:54:01',NULL),(129,3150,20,40720,1540,15,67,1,232884.26,NULL,'2021-05-03 21:55:36','2021-05-04 01:26:01','2021-05-04 01:26:01'),(130,3150,20,40720,1540,15,68,2,26059.93,NULL,'2021-05-03 21:55:36','2021-05-04 01:26:01','2021-05-04 01:26:01'),(131,3150,20,40720,1540,15,25,2,416.99,NULL,'2021-05-03 21:55:36','2021-05-04 01:26:01','2021-05-04 01:26:01'),(132,3150,20,40720,1540,15,74,2,206407.34,NULL,'2021-05-03 21:55:36','2021-05-04 01:26:01','2021-05-04 01:26:01'),(133,3150,21,40720,1545,15,67,1,247399.08,NULL,'2021-05-03 21:56:26','2021-05-03 21:56:26',NULL),(134,3150,21,40720,1545,15,68,2,58610.52,NULL,'2021-05-03 21:56:26','2021-05-03 21:56:26',NULL),(135,3150,21,40720,1545,15,25,2,915.38,NULL,'2021-05-03 21:56:26','2021-05-03 21:56:26',NULL),(136,3150,21,40720,1545,15,74,2,187873.18,NULL,'2021-05-03 21:56:26','2021-05-03 21:56:26',NULL),(137,3150,22,40720,1546,15,67,1,227282.70,NULL,'2021-05-03 21:57:01','2021-05-03 21:57:01',NULL),(138,3150,22,40720,1546,15,68,2,26738.52,NULL,'2021-05-03 21:57:01','2021-05-03 21:57:01',NULL),(139,3150,22,40720,1546,15,25,2,60.73,NULL,'2021-05-03 21:57:01','2021-05-03 21:57:01',NULL),(140,3150,22,40720,1546,15,74,2,200483.45,NULL,'2021-05-03 21:57:01','2021-05-03 21:57:01',NULL),(141,3150,23,40720,1547,15,67,1,242618.18,NULL,'2021-05-03 21:57:47','2021-05-03 21:57:47',NULL),(142,3150,23,40720,1547,15,68,2,94600.90,NULL,'2021-05-03 21:57:47','2021-05-03 21:57:47',NULL),(143,3150,23,40720,1547,15,25,2,741.41,NULL,'2021-05-03 21:57:47','2021-05-03 21:57:47',NULL),(144,3150,23,40720,1547,15,74,2,147275.87,NULL,'2021-05-03 21:57:47','2021-05-03 21:57:47',NULL),(145,3150,24,40720,1548,15,67,1,267749.62,NULL,'2021-05-03 21:58:36','2021-05-03 21:58:36',NULL),(146,3150,24,40720,1548,15,68,2,33200.06,NULL,'2021-05-03 21:58:36','2021-05-03 21:58:36',NULL),(147,3150,24,40720,1548,15,25,2,589.79,NULL,'2021-05-03 21:58:36','2021-05-03 21:58:36',NULL),(148,3150,24,40720,1548,15,74,2,233959.77,NULL,'2021-05-03 21:58:36','2021-05-03 21:58:36',NULL),(149,3150,25,40720,1549,15,67,1,243089.39,NULL,'2021-05-03 22:23:26','2021-05-03 22:23:26',NULL),(150,3150,25,40720,1549,15,68,2,61595.73,NULL,'2021-05-03 22:23:26','2021-05-03 22:23:26',NULL),(151,3150,25,40720,1549,15,25,2,919.04,NULL,'2021-05-03 22:23:26','2021-05-03 22:23:26',NULL),(152,3150,25,40720,1549,15,74,2,180574.62,NULL,'2021-05-03 22:23:26','2021-05-03 22:23:26',NULL),(153,3150,26,40720,1550,15,67,1,289316.31,NULL,'2021-05-03 22:24:09','2021-05-03 22:24:09',NULL);
INSERT INTO `balance_libro_details` VALUES (154,3150,26,40720,1550,15,68,2,44470.57,NULL,'2021-05-03 22:24:09','2021-05-03 22:24:09',NULL),(155,3150,26,40720,1550,15,25,2,371.87,NULL,'2021-05-03 22:24:09','2021-05-03 22:24:09',NULL),(156,3150,26,40720,1550,15,74,2,244473.87,NULL,'2021-05-03 22:24:09','2021-05-03 22:24:09',NULL),(157,3150,27,40720,1551,15,67,1,300808.72,NULL,'2021-05-03 22:24:44','2021-05-03 22:24:44',NULL),(158,3150,27,40720,1551,15,68,2,74770.82,NULL,'2021-05-03 22:24:44','2021-05-03 22:24:44',NULL),(159,3150,27,40720,1551,15,25,2,864.78,NULL,'2021-05-03 22:24:44','2021-05-03 22:24:44',NULL),(160,3150,27,40720,1551,15,74,2,225173.12,NULL,'2021-05-03 22:24:44','2021-05-03 22:24:44',NULL),(161,3150,28,40720,1537,3,396,1,1017.74,NULL,'2021-05-03 22:54:21','2021-05-19 22:32:54','2021-05-19 22:32:54'),(162,3150,28,40720,1537,3,437,1,1112.52,NULL,'2021-05-03 22:54:21','2021-05-19 22:32:54','2021-05-19 22:32:54'),(163,3150,28,40720,1537,3,157,1,2258.84,NULL,'2021-05-03 22:54:21','2021-05-19 22:32:54','2021-05-19 22:32:54'),(164,3150,28,40720,1537,3,20,1,25996.63,NULL,'2021-05-03 22:54:21','2021-05-19 22:32:54','2021-05-19 22:32:54'),(165,3150,28,40720,1537,3,63,1,132612.83,NULL,'2021-05-03 22:54:21','2021-05-19 22:32:54','2021-05-19 22:32:54'),(166,3150,28,40720,1537,3,74,1,104091.76,NULL,'2021-05-03 22:54:21','2021-05-19 22:32:54','2021-05-19 22:32:54'),(167,3150,28,40720,1537,3,13,2,298174.19,NULL,'2021-05-03 22:54:21','2021-05-19 22:32:54','2021-05-19 22:32:54'),(168,3150,28,40720,1537,3,8,1,31083.87,NULL,'2021-05-03 22:54:21','2021-05-19 22:32:54','2021-05-19 22:32:54'),(169,3150,29,40720,1538,3,396,1,855.60,NULL,'2021-05-03 23:00:18','2021-05-19 22:32:18','2021-05-19 22:32:18'),(170,3150,29,40720,1538,3,437,1,1235.23,NULL,'2021-05-03 23:00:18','2021-05-19 22:32:18','2021-05-19 22:32:18'),(171,3150,29,40720,1538,3,157,1,2507.88,NULL,'2021-05-03 23:00:18','2021-05-19 22:32:18','2021-05-19 22:32:18'),(172,3150,29,40720,1538,3,20,1,25996.63,NULL,'2021-05-03 23:00:18','2021-05-19 22:32:18','2021-05-19 22:32:18'),(173,3150,29,40720,1538,3,63,1,128239.71,NULL,'2021-05-03 23:00:18','2021-05-19 22:32:18','2021-05-19 22:32:18'),(174,3150,29,40720,1538,3,74,1,104614.81,NULL,'2021-05-03 23:00:18','2021-05-19 22:32:18','2021-05-19 22:32:18'),(175,3150,29,40720,1538,3,57,1,100000.00,NULL,'2021-05-03 23:00:18','2021-05-19 22:32:18','2021-05-19 22:32:18'),(176,3150,29,40720,1538,3,13,2,241467.36,NULL,'2021-05-03 23:00:18','2021-05-19 22:32:18','2021-05-19 22:32:18'),(177,3150,29,40720,1538,3,8,2,148560.99,NULL,'2021-05-03 23:00:18','2021-05-19 22:32:18','2021-05-19 22:32:18'),(178,3150,29,40720,1538,3,327,1,26578.49,NULL,'2021-05-03 23:00:18','2021-05-19 22:32:18','2021-05-19 22:32:18'),(179,3150,30,40720,1539,3,396,1,1041.00,NULL,'2021-05-03 23:05:33','2021-05-19 22:23:21','2021-05-19 22:23:21'),(180,3150,30,40720,1539,3,437,1,1208.02,NULL,'2021-05-03 23:05:33','2021-05-19 22:23:21','2021-05-19 22:23:21'),(181,3150,30,40720,1539,3,157,1,2452.64,NULL,'2021-05-03 23:05:33','2021-05-19 22:23:21','2021-05-19 22:23:21'),(182,3150,30,40720,1539,3,20,1,25996.63,NULL,'2021-05-03 23:05:33','2021-05-19 22:23:21','2021-05-19 22:23:21'),(183,3150,30,40720,1539,3,63,1,114694.61,NULL,'2021-05-03 23:05:33','2021-05-19 22:23:21','2021-05-19 22:23:21'),(184,3150,30,40720,1539,3,74,1,109726.15,NULL,'2021-05-03 23:05:33','2021-05-19 22:23:21','2021-05-19 22:23:21'),(185,3150,30,40720,1539,3,13,2,351434.00,NULL,'2021-05-03 23:05:33','2021-05-19 22:23:21','2021-05-19 22:23:21'),(186,3150,30,40720,1539,3,8,1,68797.67,NULL,'2021-05-03 23:05:33','2021-05-19 22:23:21','2021-05-19 22:23:21'),(187,3150,30,40720,1539,3,327,1,27517.28,NULL,'2021-05-03 23:05:33','2021-05-19 22:23:21','2021-05-19 22:23:21'),(188,3150,31,40720,1540,3,396,1,2062.24,NULL,'2021-05-03 23:19:22','2021-05-19 22:22:42','2021-05-19 22:22:42'),(189,3150,31,40720,1540,3,437,1,1681.81,NULL,'2021-05-03 23:19:22','2021-05-19 22:22:42','2021-05-19 22:22:42');
INSERT INTO `balance_libro_details` VALUES (190,3150,31,40720,1540,3,157,1,3414.57,NULL,'2021-05-03 23:19:22','2021-05-19 22:22:42','2021-05-19 22:22:42'),(191,3150,31,40720,1540,3,63,1,140308.31,NULL,'2021-05-03 23:19:22','2021-05-19 22:22:42','2021-05-19 22:22:42'),(192,3150,31,40720,1540,3,74,1,110003.56,NULL,'2021-05-03 23:19:22','2021-05-19 22:22:42','2021-05-19 22:22:42'),(193,3150,31,40720,1540,3,57,1,154000.00,NULL,'2021-05-03 23:19:22','2021-05-19 22:22:42','2021-05-19 22:22:42'),(194,3150,31,40720,1540,3,13,2,384484.00,NULL,'2021-05-03 23:19:22','2021-05-19 22:22:42','2021-05-19 22:22:42'),(195,3150,31,40720,1540,3,8,2,101355.26,NULL,'2021-05-03 23:19:22','2021-05-19 22:22:42','2021-05-19 22:22:42'),(196,3150,31,40720,1540,3,327,1,32052.25,NULL,'2021-05-03 23:19:22','2021-05-19 22:22:42','2021-05-19 22:22:42'),(197,3150,31,40720,1540,3,327,1,14557.83,NULL,'2021-05-03 23:19:22','2021-05-19 22:22:42','2021-05-19 22:22:42'),(198,3150,31,40720,1540,3,327,1,27758.69,NULL,'2021-05-03 23:19:22','2021-05-19 22:22:42','2021-05-19 22:22:42'),(199,3150,32,40720,2,3,396,1,1162.00,NULL,'2021-05-03 23:26:49','2021-05-04 01:25:21','2021-05-04 01:25:21'),(200,3150,32,40720,2,3,437,1,1278.80,NULL,'2021-05-03 23:26:49','2021-05-04 01:25:21','2021-05-04 01:25:21'),(201,3150,32,40720,2,3,157,1,2596.36,NULL,'2021-05-03 23:26:49','2021-05-04 01:25:21','2021-05-04 01:25:21'),(202,3150,32,40720,2,3,63,1,122091.99,NULL,'2021-05-03 23:26:49','2021-05-04 01:25:21','2021-05-04 01:25:21'),(203,3150,32,40720,2,3,74,1,110061.68,NULL,'2021-05-03 23:26:49','2021-05-04 01:25:21','2021-05-04 01:25:21'),(204,3150,32,40720,2,3,13,2,359411.00,NULL,'2021-05-03 23:26:49','2021-05-04 01:25:21','2021-05-04 01:25:21'),(205,3150,32,40720,2,3,8,1,59785.07,NULL,'2021-05-03 23:26:49','2021-05-04 01:25:21','2021-05-04 01:25:21'),(206,3150,32,40720,2,3,327,1,32671.10,NULL,'2021-05-03 23:26:49','2021-05-04 01:25:21','2021-05-04 01:25:21'),(207,3150,32,40720,2,3,81,1,29764.00,NULL,'2021-05-03 23:26:49','2021-05-04 01:25:21','2021-05-04 01:25:21'),(216,3150,35,40720,1545,3,396,1,1333.46,NULL,'2021-05-03 23:37:00','2021-05-19 22:22:02','2021-05-19 22:22:02'),(217,3150,35,40720,1545,3,437,1,1841.97,NULL,'2021-05-03 23:37:00','2021-05-19 22:22:02','2021-05-19 22:22:02'),(218,3150,35,40720,1545,3,157,1,3739.74,NULL,'2021-05-03 23:37:00','2021-05-19 22:22:02','2021-05-19 22:22:02'),(219,3150,35,40720,1545,3,63,1,180016.06,NULL,'2021-05-03 23:37:00','2021-05-19 22:22:02','2021-05-19 22:22:02'),(220,3150,35,40720,1545,3,74,1,122407.13,NULL,'2021-05-03 23:37:00','2021-05-19 22:22:02','2021-05-19 22:22:02'),(221,3150,35,40720,1545,3,13,2,220848.74,NULL,'2021-05-03 23:37:00','2021-05-19 22:22:02','2021-05-19 22:22:02'),(222,3150,35,40720,1545,3,8,2,120985.90,NULL,'2021-05-03 23:37:00','2021-05-19 22:22:02','2021-05-19 22:22:02'),(223,3150,35,40720,1545,3,327,1,32496.28,NULL,'2021-05-03 23:37:00','2021-05-19 22:22:02','2021-05-19 22:22:02'),(224,3150,36,40720,1546,3,396,1,1333.46,NULL,'2021-05-03 23:46:01','2021-05-19 22:21:12','2021-05-19 22:21:12'),(225,3150,36,40720,1546,3,437,1,1147.53,NULL,'2021-05-03 23:46:01','2021-05-19 22:21:12','2021-05-19 22:21:12'),(226,3150,36,40720,1546,3,157,1,2329.83,NULL,'2021-05-03 23:46:01','2021-05-19 22:21:12','2021-05-19 22:21:12'),(227,3150,36,40720,1546,3,74,1,121116.07,NULL,'2021-05-03 23:46:01','2021-05-19 22:21:12','2021-05-19 22:21:12'),(228,3150,36,40720,1546,3,57,1,50000.00,NULL,'2021-05-03 23:46:01','2021-05-19 22:21:12','2021-05-19 22:21:12'),(229,3150,36,40720,1546,3,13,2,385211.35,NULL,'2021-05-03 23:46:01','2021-05-19 22:21:12','2021-05-19 22:21:12'),(230,3150,36,40720,1546,3,8,1,174613.41,NULL,'2021-05-03 23:46:01','2021-05-19 22:21:12','2021-05-19 22:21:12'),(231,3150,36,40720,1546,3,302,1,34671.05,NULL,'2021-05-03 23:46:01','2021-05-19 22:21:12','2021-05-19 22:21:12'),(232,3150,37,40720,1547,3,396,1,1333.46,NULL,'2021-05-03 23:50:12','2021-05-19 22:20:33','2021-05-19 22:20:33');
INSERT INTO `balance_libro_details` VALUES (233,3150,37,40720,1547,3,437,1,2719.50,NULL,'2021-05-03 23:50:12','2021-05-19 22:20:33','2021-05-19 22:20:33'),(234,3150,37,40720,1547,3,157,1,1339.48,NULL,'2021-05-03 23:50:12','2021-05-19 22:20:33','2021-05-19 22:20:33'),(235,3150,37,40720,1547,3,63,1,110271.09,NULL,'2021-05-03 23:50:12','2021-05-19 22:20:33','2021-05-19 22:20:33'),(236,3150,37,40720,1547,3,74,1,120008.30,NULL,'2021-05-03 23:50:12','2021-05-19 22:20:33','2021-05-19 22:20:33'),(237,3150,37,40720,1547,3,13,2,412999.00,NULL,'2021-05-03 23:50:12','2021-05-19 22:20:33','2021-05-19 22:20:33'),(238,3150,37,40720,1547,3,8,1,145443.46,NULL,'2021-05-03 23:50:12','2021-05-19 22:20:33','2021-05-19 22:20:33'),(239,3150,37,40720,1547,3,327,1,31883.71,NULL,'2021-05-03 23:50:12','2021-05-19 22:20:33','2021-05-19 22:20:33'),(240,3150,38,40720,1548,3,396,1,1798.12,NULL,'2021-05-03 23:52:15','2021-05-19 22:19:59','2021-05-19 22:19:59'),(241,3150,38,40720,1548,3,437,1,1396.59,NULL,'2021-05-03 23:52:15','2021-05-19 22:19:59','2021-05-19 22:19:59'),(242,3150,38,40720,1548,3,157,1,2835.47,NULL,'2021-05-03 23:52:15','2021-05-19 22:19:59','2021-05-19 22:19:59'),(243,3150,38,40720,1548,3,63,1,121706.19,NULL,'2021-05-03 23:52:15','2021-05-19 22:19:59','2021-05-19 22:19:59'),(244,3150,38,40720,1548,3,74,1,129010.49,NULL,'2021-05-03 23:52:15','2021-05-19 22:19:59','2021-05-19 22:19:59'),(245,3150,38,40720,1548,3,13,2,426599.00,NULL,'2021-05-03 23:52:15','2021-05-19 22:19:59','2021-05-19 22:19:59'),(246,3150,38,40720,1548,3,8,1,138501.97,NULL,'2021-05-03 23:52:15','2021-05-19 22:19:59','2021-05-19 22:19:59'),(247,3150,38,40720,1548,3,327,1,31350.17,NULL,'2021-05-03 23:52:15','2021-05-19 22:19:59','2021-05-19 22:19:59'),(248,3150,39,40720,1549,3,396,1,1333.46,NULL,'2021-05-03 23:57:10','2021-05-19 22:19:25','2021-05-19 22:19:25'),(249,3150,39,40720,1549,3,437,1,1563.44,NULL,'2021-05-03 23:57:10','2021-05-19 22:19:25','2021-05-19 22:19:25'),(250,3150,39,40720,1549,3,157,1,3174.26,NULL,'2021-05-03 23:57:10','2021-05-19 22:19:25','2021-05-19 22:19:25'),(251,3150,39,40720,1549,3,63,1,147721.40,NULL,'2021-05-03 23:57:10','2021-05-19 22:19:25','2021-05-19 22:19:25'),(252,3150,39,40720,1549,3,74,1,139460.82,NULL,'2021-05-03 23:57:10','2021-05-19 22:19:25','2021-05-19 22:19:25'),(253,3150,39,40720,1549,3,13,2,465270.00,NULL,'2021-05-03 23:57:10','2021-05-19 22:19:25','2021-05-19 22:19:25'),(254,3150,39,40720,1549,3,8,1,136185.10,NULL,'2021-05-03 23:57:10','2021-05-19 22:19:25','2021-05-19 22:19:25'),(255,3150,39,40720,1549,3,327,1,35831.52,NULL,'2021-05-03 23:57:10','2021-05-19 22:19:25','2021-05-19 22:19:25'),(256,3150,40,40720,1550,3,396,1,7947.00,NULL,'2021-05-04 00:00:59','2021-05-19 22:18:44','2021-05-19 22:18:44'),(257,3150,40,40720,1550,3,437,1,2720.66,NULL,'2021-05-04 00:00:59','2021-05-19 22:18:44','2021-05-19 22:18:44'),(258,3150,40,40720,1550,3,157,1,5523.77,NULL,'2021-05-04 00:00:59','2021-05-19 22:18:44','2021-05-19 22:18:44'),(259,3150,40,40720,1550,3,63,1,138666.27,NULL,'2021-05-04 00:00:59','2021-05-19 22:18:44','2021-05-19 22:18:44'),(260,3150,40,40720,1550,3,74,1,149947.80,NULL,'2021-05-04 00:00:59','2021-05-19 22:18:44','2021-05-19 22:18:44'),(261,3150,40,40720,1550,3,13,2,398751.04,NULL,'2021-05-04 00:00:59','2021-05-19 22:18:44','2021-05-19 22:18:44'),(262,3150,40,40720,1550,3,8,1,55695.27,NULL,'2021-05-04 00:00:59','2021-05-19 22:18:44','2021-05-19 22:18:44'),(263,3150,40,40720,1550,3,327,1,33031.14,NULL,'2021-05-04 00:00:59','2021-05-19 22:18:44','2021-05-19 22:18:44'),(264,3150,40,40720,1550,3,76,1,5219.13,NULL,'2021-05-04 00:00:59','2021-05-19 22:18:44','2021-05-19 22:18:44'),(265,3150,41,40720,1551,3,396,1,1804.34,NULL,'2021-05-04 00:03:13','2021-05-19 22:18:06','2021-05-19 22:18:06'),(266,3150,41,40720,1551,3,437,1,2084.85,NULL,'2021-05-04 00:03:13','2021-05-19 22:18:06','2021-05-19 22:18:06'),(267,3150,41,40720,1551,3,157,1,4232.83,NULL,'2021-05-04 00:03:13','2021-05-19 22:18:06','2021-05-19 22:18:06');
INSERT INTO `balance_libro_details` VALUES (268,3150,41,40720,1551,3,63,1,234534.43,NULL,'2021-05-04 00:03:13','2021-05-19 22:18:06','2021-05-19 22:18:06'),(269,3150,41,40720,1551,3,74,1,159846.07,NULL,'2021-05-04 00:03:13','2021-05-19 22:18:06','2021-05-19 22:18:06'),(270,3150,41,40720,1551,3,8,1,174760.83,NULL,'2021-05-04 00:03:13','2021-05-19 22:18:06','2021-05-19 22:18:06'),(271,3150,41,40720,1551,3,13,2,617012.83,NULL,'2021-05-04 00:03:13','2021-05-19 22:18:06','2021-05-19 22:18:06'),(272,3150,41,40720,1551,3,327,1,39749.48,NULL,'2021-05-04 00:03:13','2021-05-19 22:18:06','2021-05-19 22:18:06'),(273,3150,42,40720,1541,6,155,1,307031.15,NULL,'2021-05-04 00:08:04','2021-05-04 00:08:04',NULL),(274,3150,42,40720,1541,6,20,2,311990.76,NULL,'2021-05-04 00:08:04','2021-05-04 00:08:04',NULL),(275,3150,42,40720,1541,6,24,1,4959.61,NULL,'2021-05-04 00:08:04','2021-05-04 00:08:04',NULL),(276,3150,43,40720,1541,3,491,1,5219.13,NULL,'2021-05-04 00:12:02','2021-05-04 00:12:02',NULL),(277,3150,43,40720,1541,3,76,2,5219.13,NULL,'2021-05-04 00:12:02','2021-05-04 00:12:02',NULL),(278,3150,44,40720,1537,16,252,1,26898.20,NULL,'2021-05-04 01:09:34','2021-05-04 01:15:29','2021-05-04 01:15:29'),(279,3150,44,40720,1537,16,21,2,107.85,NULL,'2021-05-04 01:09:34','2021-05-04 01:15:29','2021-05-04 01:15:29'),(280,3150,44,40720,1537,16,21,2,475.02,NULL,'2021-05-04 01:09:34','2021-05-04 01:15:29','2021-05-04 01:15:29'),(281,3150,44,40720,1537,16,140,1,263.16,NULL,'2021-05-04 01:09:34','2021-05-04 01:15:29','2021-05-04 01:15:29'),(282,3150,44,40720,1537,16,327,2,26578.49,NULL,'2021-05-04 01:09:34','2021-05-04 01:15:29','2021-05-04 01:15:29'),(283,3150,45,40720,1538,16,252,1,29702.25,NULL,'2021-05-04 01:10:12','2021-05-04 01:16:05','2021-05-04 01:16:05'),(284,3150,45,40720,1538,16,21,2,55.04,NULL,'2021-05-04 01:10:12','2021-05-04 01:16:05','2021-05-04 01:16:05'),(285,3150,45,40720,1538,16,21,2,2294.04,NULL,'2021-05-04 01:10:12','2021-05-04 01:16:05','2021-05-04 01:16:05'),(286,3150,45,40720,1538,16,140,1,164.11,NULL,'2021-05-04 01:10:12','2021-05-04 01:16:05','2021-05-04 01:16:05'),(287,3150,45,40720,1538,16,327,2,27517.28,NULL,'2021-05-04 01:10:12','2021-05-04 01:16:05','2021-05-04 01:16:05'),(288,3150,46,40720,2,16,252,1,28568.73,NULL,'2021-05-04 01:10:54','2021-05-04 01:16:44','2021-05-04 01:16:44'),(289,3150,46,40720,2,16,21,2,67.19,NULL,'2021-05-04 01:10:54','2021-05-04 01:16:44','2021-05-04 01:16:44'),(290,3150,46,40720,2,16,21,2,1044.87,NULL,'2021-05-04 01:10:54','2021-05-04 01:16:44','2021-05-04 01:16:44'),(291,3150,46,40720,2,16,140,1,302.02,NULL,'2021-05-04 01:10:54','2021-05-04 01:16:44','2021-05-04 01:16:44'),(292,3150,46,40720,2,16,327,2,27758.69,NULL,'2021-05-04 01:10:54','2021-05-04 01:16:44','2021-05-04 01:16:44'),(293,3150,47,40720,2,16,252,1,33739.44,NULL,'2021-05-04 01:11:31','2021-05-04 01:17:40','2021-05-04 01:17:40'),(294,3150,47,40720,2,16,21,2,67.19,NULL,'2021-05-04 01:11:31','2021-05-04 01:17:40','2021-05-04 01:17:40'),(295,3150,47,40720,2,16,21,2,1547.27,NULL,'2021-05-04 01:11:31','2021-05-04 01:17:40','2021-05-04 01:17:40'),(296,3150,47,40720,2,16,140,1,546.12,NULL,'2021-05-04 01:11:31','2021-05-04 01:17:40','2021-05-04 01:17:40'),(297,3150,47,40720,2,16,327,2,32671.10,NULL,'2021-05-04 01:11:31','2021-05-04 01:17:40','2021-05-04 01:17:40'),(298,3150,48,40720,2,16,252,1,33269.18,NULL,'2021-05-04 01:12:12','2021-05-04 01:18:22','2021-05-04 01:18:22'),(299,3150,48,40720,2,16,21,2,67.19,NULL,'2021-05-04 01:12:12','2021-05-04 01:18:22','2021-05-04 01:18:22'),(300,3150,48,40720,2,16,21,2,995.58,NULL,'2021-05-04 01:12:12','2021-05-04 01:18:22','2021-05-04 01:18:22'),(301,3150,48,40720,2,16,140,1,289.87,NULL,'2021-05-04 01:12:12','2021-05-04 01:18:22','2021-05-04 01:18:22'),(302,3150,48,40720,2,16,327,2,32496.28,NULL,'2021-05-04 01:12:12','2021-05-04 01:18:22','2021-05-04 01:18:22'),(303,3150,49,40720,1537,16,21,2,107.85,NULL,'2021-05-04 01:15:29','2021-05-04 01:15:29',NULL),(304,3150,49,40720,1537,16,21,2,475.02,NULL,'2021-05-04 01:15:29','2021-05-04 01:15:29',NULL);
INSERT INTO `balance_libro_details` VALUES (305,3150,49,40720,1537,16,140,1,263.16,NULL,'2021-05-04 01:15:29','2021-05-04 01:15:29',NULL),(306,3150,49,40720,1537,16,327,2,26578.49,NULL,'2021-05-04 01:15:29','2021-05-04 01:15:29',NULL),(307,3150,49,40720,1537,16,156,1,26898.20,NULL,'2021-05-04 01:15:29','2021-05-04 01:15:29',NULL),(308,3150,50,40720,1538,16,21,2,55.04,NULL,'2021-05-04 01:16:05','2021-05-04 01:16:05',NULL),(309,3150,50,40720,1538,16,21,2,2294.04,NULL,'2021-05-04 01:16:05','2021-05-04 01:16:05',NULL),(310,3150,50,40720,1538,16,140,1,164.11,NULL,'2021-05-04 01:16:05','2021-05-04 01:16:05',NULL),(311,3150,50,40720,1538,16,327,2,27517.28,NULL,'2021-05-04 01:16:05','2021-05-04 01:16:05',NULL),(312,3150,50,40720,1538,16,156,1,29702.25,NULL,'2021-05-04 01:16:05','2021-05-04 01:16:05',NULL),(313,3150,51,40720,1539,16,21,2,67.19,NULL,'2021-05-04 01:16:44','2021-05-04 01:16:44',NULL),(314,3150,51,40720,1539,16,21,2,1044.87,NULL,'2021-05-04 01:16:44','2021-05-04 01:16:44',NULL),(315,3150,51,40720,1539,16,140,1,302.02,NULL,'2021-05-04 01:16:44','2021-05-04 01:16:44',NULL),(316,3150,51,40720,1539,16,327,2,27758.69,NULL,'2021-05-04 01:16:44','2021-05-04 01:16:44',NULL),(317,3150,51,40720,1539,16,156,1,28568.73,NULL,'2021-05-04 01:16:44','2021-05-04 01:16:44',NULL),(318,3150,52,40720,1540,16,21,2,67.19,NULL,'2021-05-04 01:17:40','2021-05-04 01:17:40',NULL),(319,3150,52,40720,1540,16,21,2,1547.27,NULL,'2021-05-04 01:17:40','2021-05-04 01:17:40',NULL),(320,3150,52,40720,1540,16,140,1,546.12,NULL,'2021-05-04 01:17:41','2021-05-04 01:17:41',NULL),(321,3150,52,40720,1540,16,327,2,32671.10,NULL,'2021-05-04 01:17:41','2021-05-04 01:17:41',NULL),(322,3150,52,40720,1540,16,156,1,33739.44,NULL,'2021-05-04 01:17:41','2021-05-04 01:17:41',NULL),(323,3150,53,40720,1541,16,21,2,67.19,NULL,'2021-05-04 01:18:22','2021-05-04 01:18:22',NULL),(324,3150,53,40720,1541,16,21,2,995.58,NULL,'2021-05-04 01:18:22','2021-05-04 01:18:22',NULL),(325,3150,53,40720,1541,16,140,1,289.87,NULL,'2021-05-04 01:18:22','2021-05-04 01:18:22',NULL),(326,3150,53,40720,1541,16,327,2,32496.28,NULL,'2021-05-04 01:18:22','2021-05-04 01:18:22',NULL),(327,3150,53,40720,1541,16,156,1,33269.18,NULL,'2021-05-04 01:18:22','2021-05-04 01:18:22',NULL),(328,3150,54,40720,1545,16,21,2,912.69,NULL,'2021-05-04 01:19:28','2021-05-04 01:19:28',NULL),(329,3150,54,40720,1545,16,140,1,241.01,NULL,'2021-05-04 01:19:28','2021-05-04 01:19:28',NULL),(330,3150,54,40720,1545,16,327,2,34671.05,NULL,'2021-05-04 01:19:28','2021-05-04 01:19:28',NULL),(331,3150,54,40720,1545,16,156,1,35342.73,NULL,'2021-05-04 01:19:28','2021-05-04 01:19:28',NULL),(332,3150,55,40720,1546,16,21,2,806.88,NULL,'2021-05-04 01:20:34','2021-05-04 01:20:34',NULL),(333,3150,55,40720,1546,16,140,1,221.63,NULL,'2021-05-04 01:20:34','2021-05-04 01:20:34',NULL),(334,3150,55,40720,1546,16,327,2,31883.71,NULL,'2021-05-04 01:20:34','2021-05-04 01:20:34',NULL),(335,3150,55,40720,1546,16,156,1,32468.96,NULL,'2021-05-04 01:20:34','2021-05-04 01:20:34',NULL),(336,3150,56,40720,1547,16,21,2,67.19,NULL,'2021-05-04 01:21:31','2021-05-04 01:21:31',NULL),(337,3150,56,40720,1547,16,21,2,3552.78,NULL,'2021-05-04 01:21:31','2021-05-04 01:21:31',NULL),(338,3150,56,40720,1547,16,140,1,310.40,NULL,'2021-05-04 01:21:31','2021-05-04 01:21:31',NULL),(339,3150,56,40720,1547,16,327,2,31350.17,NULL,'2021-05-04 01:21:31','2021-05-04 01:21:31',NULL),(340,3150,56,40720,1547,16,156,1,34659.74,NULL,'2021-05-04 01:21:31','2021-05-04 01:21:31',NULL),(341,3150,57,40720,1548,16,21,2,79.59,NULL,'2021-05-04 01:22:22','2021-05-04 01:22:22',NULL),(342,3150,57,40720,1548,16,21,2,2693.60,NULL,'2021-05-04 01:22:22','2021-05-04 01:22:22',NULL),(343,3150,57,40720,1548,16,140,1,354.76,NULL,'2021-05-04 01:22:22','2021-05-04 01:22:22',NULL),(344,3150,57,40720,1548,16,327,2,35831.52,NULL,'2021-05-04 01:22:22','2021-05-04 01:22:22',NULL),(345,3150,57,40720,1548,16,156,1,38249.95,NULL,'2021-05-04 01:22:22','2021-05-04 01:22:22',NULL);
INSERT INTO `balance_libro_details` VALUES (346,3150,58,40720,1549,16,21,2,79.59,NULL,'2021-05-04 01:23:14','2021-05-04 01:23:14',NULL),(347,3150,58,40720,1549,16,21,2,2008.00,NULL,'2021-05-04 01:23:14','2021-05-04 01:23:14',NULL),(348,3150,58,40720,1549,16,140,1,391.67,NULL,'2021-05-04 01:23:14','2021-05-04 01:23:14',NULL),(349,3150,58,40720,1549,16,327,2,33031.14,NULL,'2021-05-04 01:23:14','2021-05-04 01:23:14',NULL),(350,3150,58,40720,1549,16,156,1,34727.06,NULL,'2021-05-04 01:23:14','2021-05-04 01:23:14',NULL),(351,3150,59,40720,1550,16,21,2,151.49,NULL,'2021-05-04 01:23:58','2021-05-19 23:04:57','2021-05-19 23:04:57'),(352,3150,59,40720,1550,16,21,2,1706.24,NULL,'2021-05-04 01:23:58','2021-05-19 23:04:57','2021-05-19 23:04:57'),(353,3150,59,40720,1550,16,140,1,276.31,NULL,'2021-05-04 01:23:58','2021-05-19 23:04:57','2021-05-19 23:04:57'),(354,3150,59,40720,1550,16,327,2,39749.48,NULL,'2021-05-04 01:23:58','2021-05-19 23:04:57','2021-05-19 23:04:57'),(355,3150,59,40720,1550,16,156,1,41330.90,NULL,'2021-05-04 01:23:58','2021-05-19 23:04:57','2021-05-19 23:04:57'),(356,3150,60,40720,1551,16,21,2,151.49,NULL,'2021-05-04 01:24:49','2021-05-19 23:04:32','2021-05-19 23:04:32'),(357,3150,60,40720,1551,16,21,2,2502.92,NULL,'2021-05-04 01:24:49','2021-05-19 23:04:32','2021-05-19 23:04:32'),(358,3150,60,40720,1551,16,140,1,483.82,NULL,'2021-05-04 01:24:49','2021-05-19 23:04:32','2021-05-19 23:04:32'),(359,3150,60,40720,1551,16,327,2,40802.09,NULL,'2021-05-04 01:24:49','2021-05-19 23:04:32','2021-05-19 23:04:32'),(360,3150,60,40720,1551,16,156,1,42972.68,NULL,'2021-05-04 01:24:49','2021-05-19 23:04:32','2021-05-19 23:04:32'),(361,3150,61,40720,2,3,396,1,1162.00,NULL,'2021-05-04 01:25:21','2021-05-19 22:24:17','2021-05-19 22:24:17'),(362,3150,61,40720,2,3,437,1,1278.80,NULL,'2021-05-04 01:25:21','2021-05-19 22:24:17','2021-05-19 22:24:17'),(363,3150,61,40720,2,3,157,1,2596.36,NULL,'2021-05-04 01:25:21','2021-05-19 22:24:17','2021-05-19 22:24:17'),(364,3150,61,40720,2,3,63,1,122091.99,NULL,'2021-05-04 01:25:21','2021-05-19 22:24:17','2021-05-19 22:24:17'),(365,3150,61,40720,2,3,74,1,110061.68,NULL,'2021-05-04 01:25:21','2021-05-19 22:24:17','2021-05-19 22:24:17'),(366,3150,61,40720,2,3,13,2,359411.00,NULL,'2021-05-04 01:25:21','2021-05-19 22:24:17','2021-05-19 22:24:17'),(367,3150,61,40720,2,3,8,1,59785.07,NULL,'2021-05-04 01:25:21','2021-05-19 22:24:17','2021-05-19 22:24:17'),(368,3150,61,40720,2,3,327,1,32671.10,NULL,'2021-05-04 01:25:21','2021-05-19 22:24:17','2021-05-19 22:24:17'),(369,3150,61,40720,2,3,81,1,29764.00,NULL,'2021-05-04 01:25:21','2021-05-19 22:24:17','2021-05-19 22:24:17'),(370,3150,62,40720,1540,15,67,1,232884.26,NULL,'2021-05-04 01:26:01','2021-05-04 01:26:01',NULL),(371,3150,62,40720,1540,15,68,2,26059.93,NULL,'2021-05-04 01:26:01','2021-05-04 01:26:01',NULL),(372,3150,62,40720,1540,15,25,2,416.99,NULL,'2021-05-04 01:26:01','2021-05-04 01:26:01',NULL),(373,3150,62,40720,1540,15,74,2,206407.34,NULL,'2021-05-04 01:26:01','2021-05-04 01:26:01',NULL),(374,3150,63,40734,18552,10,74,1,40091.97,NULL,'2021-05-05 23:25:10','2021-05-05 23:28:11','2021-05-05 23:28:11'),(375,3150,63,40734,18552,10,73,1,148.35,NULL,'2021-05-05 23:25:10','2021-05-05 23:28:11','2021-05-05 23:28:11'),(376,3150,63,40734,18552,10,72,2,148.35,NULL,'2021-05-05 23:25:10','2021-05-05 23:28:11','2021-05-05 23:28:11'),(377,3150,63,40734,18552,10,354,2,40091.97,NULL,'2021-05-05 23:25:10','2021-05-05 23:28:11','2021-05-05 23:28:11'),(378,3150,64,40734,18552,10,74,1,40091.97,NULL,'2021-05-05 23:28:11','2021-05-05 23:28:27','2021-05-05 23:28:27'),(379,3150,64,40734,18552,10,354,2,40091.97,NULL,'2021-05-05 23:28:11','2021-05-05 23:28:27','2021-05-05 23:28:27'),(380,3150,65,40734,18552,10,74,1,40091.97,NULL,'2021-05-05 23:28:27','2021-05-06 00:25:38','2021-05-06 00:25:38'),(381,3150,65,40734,18552,10,354,2,40091.97,NULL,'2021-05-05 23:28:27','2021-05-06 00:25:38','2021-05-06 00:25:38'),(382,3150,66,40734,18552,15,354,1,148.35,NULL,'2021-05-05 23:31:23','2021-05-06 13:13:27','2021-05-06 13:13:27');
INSERT INTO `balance_libro_details` VALUES (383,3150,66,40734,18552,15,72,2,148.35,NULL,'2021-05-05 23:31:23','2021-05-06 13:13:27','2021-05-06 13:13:27'),(384,3150,67,40734,18552,5,396,1,6280.15,NULL,'2021-05-05 23:48:11','2021-05-05 23:52:04','2021-05-05 23:52:04'),(385,3150,67,40734,18552,5,157,2,6280.15,NULL,'2021-05-05 23:48:11','2021-05-05 23:52:04','2021-05-05 23:52:04'),(386,3150,68,40734,18552,5,396,1,6280.15,NULL,'2021-05-05 23:52:04','2021-05-05 23:52:04',NULL),(387,3150,68,40734,18552,5,492,1,594.12,NULL,'2021-05-05 23:52:04','2021-05-05 23:52:04',NULL),(388,3150,68,40734,18552,5,57,1,89551.47,NULL,'2021-05-05 23:52:04','2021-05-05 23:52:04',NULL),(389,3150,68,40734,18552,5,164,2,96425.74,NULL,'2021-05-05 23:52:04','2021-05-05 23:52:04',NULL),(390,3150,69,40734,18552,6,20,1,8498.89,NULL,'2021-05-05 23:55:44','2021-05-06 00:26:35','2021-05-06 00:26:35'),(391,3150,69,40734,18552,6,57,2,8498.89,NULL,'2021-05-05 23:55:44','2021-05-06 00:26:35','2021-05-06 00:26:35'),(392,3150,70,40734,18552,6,79,1,661.64,NULL,'2021-05-05 23:58:04','2021-05-06 00:26:25','2021-05-06 00:26:25'),(393,3150,70,40734,18552,6,79,1,3294.18,NULL,'2021-05-05 23:58:04','2021-05-06 00:26:25','2021-05-06 00:26:25'),(394,3150,70,40734,18552,6,57,2,3955.82,NULL,'2021-05-05 23:58:04','2021-05-06 00:26:25','2021-05-06 00:26:25'),(395,3150,71,40734,18552,9,78,1,12251.61,NULL,'2021-05-06 00:01:52','2021-05-06 00:01:52',NULL),(396,3150,71,40734,18552,9,57,2,12251.61,NULL,'2021-05-06 00:01:52','2021-05-06 00:01:52',NULL),(397,3150,72,40734,18552,9,435,1,17186.95,NULL,'2021-05-06 00:11:52','2021-05-06 00:15:55','2021-05-06 00:15:55'),(398,3150,72,40734,18552,9,74,1,64227.70,NULL,'2021-05-06 00:11:52','2021-05-06 00:15:55','2021-05-06 00:15:55'),(399,3150,72,40734,18552,9,435,1,7456.94,NULL,'2021-05-06 00:11:52','2021-05-06 00:15:55','2021-05-06 00:15:55'),(400,3150,72,40734,18552,9,10,1,23059.26,NULL,'2021-05-06 00:11:52','2021-05-06 00:15:55','2021-05-06 00:15:55'),(401,3150,72,40734,18552,9,204,1,400.00,NULL,'2021-05-06 00:11:52','2021-05-06 00:15:55','2021-05-06 00:15:55'),(402,3150,72,40734,18552,9,204,1,400.00,NULL,'2021-05-06 00:11:52','2021-05-06 00:15:55','2021-05-06 00:15:55'),(403,3150,72,40734,18552,9,204,1,800.00,NULL,'2021-05-06 00:11:52','2021-05-06 00:15:55','2021-05-06 00:15:55'),(404,3150,72,40734,18552,9,79,1,25946.41,NULL,'2021-05-06 00:11:52','2021-05-06 00:15:55','2021-05-06 00:15:55'),(405,3150,72,40734,18552,9,24,2,139477.26,NULL,'2021-05-06 00:11:52','2021-05-06 00:15:55','2021-05-06 00:15:55'),(406,3150,73,40734,18552,9,435,1,17186.95,NULL,'2021-05-06 00:15:55','2021-05-06 00:26:16','2021-05-06 00:26:16'),(407,3150,73,40734,18552,9,74,1,64227.70,NULL,'2021-05-06 00:15:55','2021-05-06 00:26:16','2021-05-06 00:26:16'),(408,3150,73,40734,18552,9,435,1,7456.94,NULL,'2021-05-06 00:15:55','2021-05-06 00:26:16','2021-05-06 00:26:16'),(409,3150,73,40734,18552,9,204,1,400.00,NULL,'2021-05-06 00:15:55','2021-05-06 00:26:16','2021-05-06 00:26:16'),(410,3150,73,40734,18552,9,204,1,400.00,NULL,'2021-05-06 00:15:55','2021-05-06 00:26:16','2021-05-06 00:26:16'),(411,3150,73,40734,18552,9,204,1,800.00,NULL,'2021-05-06 00:15:55','2021-05-06 00:26:16','2021-05-06 00:26:16'),(412,3150,73,40734,18552,9,79,1,25946.41,NULL,'2021-05-06 00:15:55','2021-05-06 00:26:16','2021-05-06 00:26:16'),(413,3150,73,40734,18552,9,24,2,139477.26,NULL,'2021-05-06 00:15:55','2021-05-06 00:26:16','2021-05-06 00:26:16'),(414,3150,73,40734,18552,9,79,1,23059.26,NULL,'2021-05-06 00:15:55','2021-05-06 00:26:16','2021-05-06 00:26:16'),(415,3150,74,40734,18552,1,110,1,60000.00,NULL,'2021-05-06 00:17:42','2021-05-10 12:01:33','2021-05-10 12:01:33'),(416,3150,74,40734,18552,1,191,1,9169.20,NULL,'2021-05-06 00:17:42','2021-05-10 12:01:33','2021-05-10 12:01:33'),(417,3150,74,40734,18552,1,62,2,60000.00,NULL,'2021-05-06 00:17:42','2021-05-10 12:01:33','2021-05-10 12:01:33'),(418,3150,74,40734,18552,1,63,2,9169.20,NULL,'2021-05-06 00:17:42','2021-05-10 12:01:33','2021-05-10 12:01:33');
INSERT INTO `balance_libro_details` VALUES (419,3150,75,40734,18552,19,368,1,19500.00,NULL,'2021-05-06 00:20:03','2021-05-06 13:01:29','2021-05-06 13:01:29'),(420,3150,75,40734,18552,19,57,2,19500.00,NULL,'2021-05-06 00:20:03','2021-05-06 13:01:29','2021-05-06 13:01:29'),(421,3150,76,40734,18552,11,78,1,1467.68,NULL,'2021-05-06 00:21:34','2021-05-06 00:21:34',NULL),(422,3150,76,40734,18552,11,359,2,1467.68,NULL,'2021-05-06 00:21:34','2021-05-06 00:21:34',NULL),(423,3150,77,40734,18552,1,63,1,13753.20,NULL,'2021-05-06 00:22:48','2021-05-06 00:25:49','2021-05-06 00:25:49'),(424,3150,77,40734,18552,1,63,1,30.28,NULL,'2021-05-06 00:22:48','2021-05-06 00:25:49','2021-05-06 00:25:49'),(425,3150,77,40734,18552,1,63,1,60.56,NULL,'2021-05-06 00:22:48','2021-05-06 00:25:49','2021-05-06 00:25:49'),(426,3150,77,40734,18552,1,57,2,13844.04,NULL,'2021-05-06 00:22:48','2021-05-06 00:25:49','2021-05-06 00:25:49'),(427,3150,78,40734,18552,21,192,1,4200.00,NULL,'2021-05-06 00:24:52','2021-05-06 00:24:52',NULL),(428,3150,78,40734,18552,21,58,2,4200.00,NULL,'2021-05-06 00:24:52','2021-05-06 00:24:52',NULL),(429,3150,79,40734,18552,10,74,1,40091.97,NULL,'2021-05-06 00:25:38','2021-05-06 00:26:07','2021-05-06 00:26:07'),(430,3150,79,40734,18552,10,354,2,40091.97,NULL,'2021-05-06 00:25:38','2021-05-06 00:26:07','2021-05-06 00:26:07'),(431,3150,80,40734,18552,1,63,1,13753.20,NULL,'2021-05-06 00:25:49','2021-05-10 17:24:21','2021-05-10 17:24:21'),(432,3150,80,40734,18552,1,63,1,30.28,NULL,'2021-05-06 00:25:49','2021-05-10 17:24:21','2021-05-10 17:24:21'),(433,3150,80,40734,18552,1,63,1,60.56,NULL,'2021-05-06 00:25:49','2021-05-10 17:24:21','2021-05-10 17:24:21'),(434,3150,80,40734,18552,1,57,2,13844.04,NULL,'2021-05-06 00:25:49','2021-05-10 17:24:21','2021-05-10 17:24:21'),(435,3150,81,40734,18552,9,74,1,40091.97,NULL,'2021-05-06 00:26:07','2021-05-06 13:20:37','2021-05-06 13:20:37'),(436,3150,81,40734,18552,9,354,2,40091.97,NULL,'2021-05-06 00:26:07','2021-05-06 13:20:37','2021-05-06 13:20:37'),(437,3150,82,40734,18552,9,435,1,17186.95,NULL,'2021-05-06 00:26:16','2021-05-06 18:11:37','2021-05-06 18:11:37'),(438,3150,82,40734,18552,9,74,1,64227.70,NULL,'2021-05-06 00:26:16','2021-05-06 18:11:37','2021-05-06 18:11:37'),(439,3150,82,40734,18552,9,435,1,7456.94,NULL,'2021-05-06 00:26:16','2021-05-06 18:11:37','2021-05-06 18:11:37'),(440,3150,82,40734,18552,9,204,1,400.00,NULL,'2021-05-06 00:26:16','2021-05-06 18:11:37','2021-05-06 18:11:37'),(441,3150,82,40734,18552,9,204,1,400.00,NULL,'2021-05-06 00:26:16','2021-05-06 18:11:37','2021-05-06 18:11:37'),(442,3150,82,40734,18552,9,204,1,800.00,NULL,'2021-05-06 00:26:16','2021-05-06 18:11:37','2021-05-06 18:11:37'),(443,3150,82,40734,18552,9,79,1,25946.41,NULL,'2021-05-06 00:26:16','2021-05-06 18:11:37','2021-05-06 18:11:37'),(444,3150,82,40734,18552,9,24,2,139477.26,NULL,'2021-05-06 00:26:16','2021-05-06 18:11:37','2021-05-06 18:11:37'),(445,3150,82,40734,18552,9,79,1,23059.26,NULL,'2021-05-06 00:26:16','2021-05-06 18:11:37','2021-05-06 18:11:37'),(446,3150,83,40734,18552,6,79,1,661.64,NULL,'2021-05-06 00:26:25','2021-05-06 18:40:19','2021-05-06 18:40:19'),(447,3150,83,40734,18552,6,79,1,3294.18,NULL,'2021-05-06 00:26:25','2021-05-06 18:40:19','2021-05-06 18:40:19'),(448,3150,83,40734,18552,6,57,2,3955.82,NULL,'2021-05-06 00:26:25','2021-05-06 18:40:19','2021-05-06 18:40:19'),(449,3150,84,40734,18552,6,20,1,8498.89,NULL,'2021-05-06 00:26:35','2021-05-06 18:39:58','2021-05-06 18:39:58'),(450,3150,84,40734,18552,6,57,2,8498.89,NULL,'2021-05-06 00:26:35','2021-05-06 18:39:58','2021-05-06 18:39:58'),(451,3150,85,40734,18553,5,396,1,6330.95,NULL,'2021-05-06 12:54:02','2021-05-06 12:54:02',NULL),(452,3150,85,40734,18553,5,492,1,543.02,NULL,'2021-05-06 12:54:02','2021-05-06 12:54:02',NULL),(453,3150,85,40734,18553,5,57,1,84169.20,NULL,'2021-05-06 12:54:02','2021-05-06 12:54:02',NULL),(454,3150,85,40734,18553,5,164,2,91043.17,NULL,'2021-05-06 12:54:02','2021-05-06 12:54:02',NULL);
INSERT INTO `balance_libro_details` VALUES (455,3150,86,40734,18553,1,110,1,60000.00,NULL,'2021-05-06 12:56:07','2021-05-06 12:56:07',NULL),(456,3150,86,40734,18553,1,191,1,9169.20,NULL,'2021-05-06 12:56:07','2021-05-06 12:56:07',NULL),(457,3150,86,40734,18553,1,62,2,60000.00,NULL,'2021-05-06 12:56:07','2021-05-06 12:56:07',NULL),(458,3150,86,40734,18553,1,63,2,9169.20,NULL,'2021-05-06 12:56:07','2021-05-06 12:56:07',NULL),(459,3150,87,40734,18553,1,63,1,9169.20,NULL,'2021-05-06 12:57:09','2021-05-06 13:03:48','2021-05-06 13:03:48'),(460,3150,87,40734,18553,1,57,2,9169.20,NULL,'2021-05-06 12:57:09','2021-05-06 13:03:48','2021-05-06 13:03:48'),(461,3150,88,40734,18553,1,63,1,9169.20,NULL,'2021-05-06 13:03:48','2021-05-10 17:30:51','2021-05-10 17:30:51'),(462,3150,88,40734,18553,1,57,2,9169.20,NULL,'2021-05-06 13:03:48','2021-05-10 17:30:51','2021-05-10 17:30:51'),(463,3150,89,40734,18553,21,97,1,4200.00,NULL,'2021-05-06 13:06:48','2021-05-25 00:00:14','2021-05-25 00:00:14'),(464,3150,89,40734,18553,21,57,2,4200.00,NULL,'2021-05-06 13:06:48','2021-05-25 00:00:14','2021-05-25 00:00:14'),(465,3150,90,40734,18552,9,74,1,40091.97,NULL,'2021-05-06 13:20:37','2021-05-07 13:43:41','2021-05-07 13:43:41'),(466,3150,90,40734,18552,9,354,2,40091.97,NULL,'2021-05-06 13:20:37','2021-05-07 13:43:41','2021-05-07 13:43:41'),(467,3150,91,40734,18552,9,435,1,17186.95,NULL,'2021-05-06 18:11:37','2021-05-06 18:16:01','2021-05-06 18:16:01'),(468,3150,91,40734,18552,9,74,1,64227.70,NULL,'2021-05-06 18:11:37','2021-05-06 18:16:01','2021-05-06 18:16:01'),(469,3150,91,40734,18552,9,435,1,7456.94,NULL,'2021-05-06 18:11:37','2021-05-06 18:16:01','2021-05-06 18:16:01'),(470,3150,91,40734,18552,9,204,1,400.00,NULL,'2021-05-06 18:11:37','2021-05-06 18:16:01','2021-05-06 18:16:01'),(471,3150,91,40734,18552,9,204,1,400.00,NULL,'2021-05-06 18:11:37','2021-05-06 18:16:01','2021-05-06 18:16:01'),(472,3150,91,40734,18552,9,204,1,800.00,NULL,'2021-05-06 18:11:37','2021-05-06 18:16:01','2021-05-06 18:16:01'),(473,3150,91,40734,18552,9,79,1,25946.41,NULL,'2021-05-06 18:11:37','2021-05-06 18:16:01','2021-05-06 18:16:01'),(474,3150,91,40734,18552,9,493,1,23059.26,NULL,'2021-05-06 18:11:37','2021-05-06 18:16:01','2021-05-06 18:16:01'),(475,3150,91,40734,18552,9,24,2,139477.26,NULL,'2021-05-06 18:11:37','2021-05-06 18:16:01','2021-05-06 18:16:01'),(476,3150,92,40734,18552,9,435,1,17186.95,NULL,'2021-05-06 18:16:01','2021-05-06 18:16:01',NULL),(477,3150,92,40734,18552,9,74,1,64227.70,NULL,'2021-05-06 18:16:01','2021-05-06 18:16:01',NULL),(478,3150,92,40734,18552,9,435,1,7456.94,NULL,'2021-05-06 18:16:01','2021-05-06 18:16:01',NULL),(479,3150,92,40734,18552,9,204,1,400.00,NULL,'2021-05-06 18:16:01','2021-05-06 18:16:01',NULL),(480,3150,92,40734,18552,9,204,1,400.00,NULL,'2021-05-06 18:16:01','2021-05-06 18:16:01',NULL),(481,3150,92,40734,18552,9,204,1,800.00,NULL,'2021-05-06 18:16:01','2021-05-06 18:16:01',NULL),(482,3150,92,40734,18552,9,79,1,25946.41,NULL,'2021-05-06 18:16:01','2021-05-06 18:16:01',NULL),(483,3150,92,40734,18552,9,24,2,139477.26,NULL,'2021-05-06 18:16:01','2021-05-06 18:16:01',NULL),(484,3150,92,40734,18552,9,79,1,23059.26,NULL,'2021-05-06 18:16:01','2021-05-06 18:16:01',NULL),(485,3150,93,40734,18554,15,354,2,148.35,NULL,'2021-05-06 18:24:40','2021-05-06 18:24:40',NULL),(486,3150,93,40734,18554,15,68,2,4253.76,NULL,'2021-05-06 18:24:40','2021-05-06 18:24:40',NULL),(487,3150,93,40734,18554,15,72,2,606.94,NULL,'2021-05-06 18:24:40','2021-05-06 18:24:40',NULL),(488,3150,93,40734,18554,15,71,2,70677.60,NULL,'2021-05-06 18:24:40','2021-05-06 18:24:40',NULL),(489,3150,93,40734,18554,15,73,1,71432.89,NULL,'2021-05-06 18:24:40','2021-05-06 18:24:40',NULL),(490,3150,93,40734,18554,15,73,1,4253.76,NULL,'2021-05-06 18:24:40','2021-05-06 18:24:40',NULL),(491,3150,94,40734,18554,10,354,1,606.94,NULL,'2021-05-06 18:27:28','2021-05-06 18:27:28',NULL),(492,3150,94,40734,18554,10,354,1,70677.60,NULL,'2021-05-06 18:27:28','2021-05-06 18:27:28',NULL);
INSERT INTO `balance_libro_details` VALUES (493,3150,94,40734,18554,10,354,1,148.35,NULL,'2021-05-06 18:27:28','2021-05-06 18:27:28',NULL),(494,3150,94,40734,18554,10,353,1,4253.76,NULL,'2021-05-06 18:27:28','2021-05-06 18:27:28',NULL),(495,3150,94,40734,18554,10,73,2,75686.65,NULL,'2021-05-06 18:27:28','2021-05-06 18:27:28',NULL),(496,3150,95,40734,18554,5,396,1,6446.67,NULL,'2021-05-06 18:35:21','2021-05-07 14:11:23','2021-05-07 14:11:23'),(497,3150,95,40734,18554,5,492,1,3393.26,NULL,'2021-05-06 18:35:21','2021-05-07 14:11:23','2021-05-07 14:11:23'),(498,3150,95,40734,18554,5,209,1,8625.98,NULL,'2021-05-06 18:35:21','2021-05-07 14:11:23','2021-05-07 14:11:23'),(499,3150,95,40734,18554,5,436,1,144754.70,NULL,'2021-05-06 18:35:21','2021-05-07 14:11:23','2021-05-07 14:11:23'),(500,3150,95,40734,18554,5,164,1,268078.19,NULL,'2021-05-06 18:35:21','2021-05-07 14:11:23','2021-05-07 14:11:23'),(501,3150,95,40734,18554,5,455,2,431298.80,NULL,'2021-05-06 18:35:21','2021-05-07 14:11:23','2021-05-07 14:11:23'),(502,3150,96,40734,18554,18,27,1,431298.80,NULL,'2021-05-06 18:37:08','2021-05-06 18:37:08',NULL),(503,3150,96,40734,18554,18,455,2,431298.80,NULL,'2021-05-06 18:37:08','2021-05-06 18:37:08',NULL),(504,3150,97,40734,18554,10,20,1,8498.89,NULL,'2021-05-06 18:39:08','2021-05-06 18:39:08',NULL),(505,3150,97,40734,18554,10,57,2,8498.89,NULL,'2021-05-06 18:39:08','2021-05-06 18:39:08',NULL),(506,3150,98,40734,18552,10,20,1,8498.89,NULL,'2021-05-06 18:39:58','2021-05-06 18:39:58',NULL),(507,3150,98,40734,18552,10,57,2,8498.89,NULL,'2021-05-06 18:39:58','2021-05-06 18:39:58',NULL),(508,3150,99,40734,18552,10,79,1,661.64,NULL,'2021-05-06 18:40:19','2021-05-06 18:40:19',NULL),(509,3150,99,40734,18552,10,79,1,3294.18,NULL,'2021-05-06 18:40:19','2021-05-06 18:40:19',NULL),(510,3150,99,40734,18552,10,57,2,3955.82,NULL,'2021-05-06 18:40:19','2021-05-06 18:40:19',NULL),(511,3150,100,40734,18554,16,156,1,8625.98,NULL,'2021-05-06 18:46:14','2021-05-06 19:00:02','2021-05-06 19:00:02'),(512,3150,100,40734,18554,16,252,2,8155.86,NULL,'2021-05-06 18:46:14','2021-05-06 19:00:02','2021-05-06 19:00:02'),(513,3150,100,40734,18554,16,255,2,470.12,NULL,'2021-05-06 18:46:14','2021-05-06 19:00:02','2021-05-06 19:00:02'),(514,3150,101,40734,18554,3,126,1,20256.00,NULL,'2021-05-06 18:51:13','2021-05-06 18:51:13',NULL),(515,3150,101,40734,18554,3,68,1,4253.76,NULL,'2021-05-06 18:51:13','2021-05-06 18:51:13',NULL),(516,3150,101,40734,18554,3,57,2,25116.70,NULL,'2021-05-06 18:51:13','2021-05-06 18:51:13',NULL),(517,3150,101,40734,18554,3,72,1,606.94,NULL,'2021-05-06 18:51:13','2021-05-06 18:51:13',NULL),(518,3150,102,40734,18554,10,155,1,3.96,NULL,'2021-05-06 18:52:57','2021-05-06 18:52:57',NULL),(519,3150,102,40734,18554,10,57,2,3.96,NULL,'2021-05-06 18:52:57','2021-05-06 18:52:57',NULL),(520,3150,103,40734,18554,1,63,1,9169.20,NULL,'2021-05-06 18:54:18','2021-05-10 17:30:14','2021-05-10 17:30:14'),(521,3150,103,40734,18554,1,57,2,9169.20,NULL,'2021-05-06 18:54:18','2021-05-10 17:30:14','2021-05-10 17:30:14'),(522,3150,104,40734,18552,9,74,1,40091.97,NULL,'2021-05-07 13:43:41','2021-05-10 12:10:00','2021-05-10 12:10:00'),(523,3150,104,40734,18552,9,354,2,40091.97,NULL,'2021-05-07 13:43:41','2021-05-10 12:10:00','2021-05-10 12:10:00'),(524,3150,104,40734,18552,9,73,1,148.35,NULL,'2021-05-07 13:43:41','2021-05-10 12:10:00','2021-05-10 12:10:00'),(525,3150,104,40734,18552,9,72,2,148.35,NULL,'2021-05-07 13:43:41','2021-05-10 12:10:00','2021-05-10 12:10:00'),(526,3150,105,40734,18552,1,110,1,60000.00,NULL,'2021-05-07 13:46:52','2021-05-07 13:46:52',NULL),(527,3150,105,40734,18552,1,191,1,9169.20,NULL,'2021-05-07 13:46:52','2021-05-07 13:46:52',NULL),(528,3150,105,40734,18552,1,62,2,60000.00,NULL,'2021-05-07 13:46:52','2021-05-07 13:46:52',NULL),(529,3150,105,40734,18552,1,63,2,9169.20,NULL,'2021-05-07 13:46:52','2021-05-07 13:46:52',NULL),(530,3150,106,40734,18552,19,368,1,19500.00,NULL,'2021-05-07 13:48:52','2021-05-07 13:48:52',NULL);
INSERT INTO `balance_libro_details` VALUES (531,3150,106,40734,18552,19,57,2,19500.00,NULL,'2021-05-07 13:48:52','2021-05-07 13:48:52',NULL),(532,3150,107,40734,18552,1,62,1,90000.00,NULL,'2021-05-07 13:51:42','2021-05-11 22:11:48','2021-05-11 22:11:48'),(533,3150,107,40734,18552,1,368,2,45000.00,NULL,'2021-05-07 13:51:42','2021-05-11 22:11:48','2021-05-11 22:11:48'),(534,3150,107,40734,18552,1,395,2,45000.00,NULL,'2021-05-07 13:51:42','2021-05-11 22:11:48','2021-05-11 22:11:48'),(535,3150,108,40734,18553,1,110,1,60000.00,NULL,'2021-05-07 13:53:11','2021-05-10 12:31:13','2021-05-10 12:31:13'),(536,3150,108,40734,18553,1,191,1,9169.20,NULL,'2021-05-07 13:53:11','2021-05-10 12:31:13','2021-05-10 12:31:13'),(537,3150,108,40734,18553,1,62,2,60000.00,NULL,'2021-05-07 13:53:11','2021-05-10 12:31:13','2021-05-10 12:31:13'),(538,3150,108,40734,18553,1,63,2,9169.20,NULL,'2021-05-07 13:53:11','2021-05-10 12:31:13','2021-05-10 12:31:13'),(539,3150,109,40734,18553,1,368,1,55000.00,NULL,'2021-05-07 13:54:15','2021-05-10 12:29:54','2021-05-10 12:29:54'),(540,3150,109,40734,18553,1,57,2,55000.00,NULL,'2021-05-07 13:54:15','2021-05-10 12:29:54','2021-05-10 12:29:54'),(541,3150,110,40734,18553,1,62,1,60000.00,NULL,'2021-05-07 13:55:22','2021-05-07 13:55:22',NULL),(542,3150,110,40734,18553,1,368,2,30000.00,NULL,'2021-05-07 13:55:22','2021-05-07 13:55:22',NULL),(543,3150,110,40734,18553,1,395,2,30000.00,NULL,'2021-05-07 13:55:22','2021-05-07 13:55:22',NULL),(544,3150,111,40734,18554,1,110,1,60000.00,NULL,'2021-05-07 14:01:48','2021-05-07 14:01:48',NULL),(545,3150,111,40734,18554,1,191,1,9169.20,NULL,'2021-05-07 14:01:48','2021-05-07 14:01:48',NULL),(546,3150,111,40734,18554,1,62,2,60000.00,NULL,'2021-05-07 14:01:48','2021-05-07 14:01:48',NULL),(547,3150,111,40734,18554,1,63,2,9169.20,NULL,'2021-05-07 14:01:48','2021-05-07 14:01:48',NULL),(548,3150,112,40734,18554,19,368,1,30000.00,NULL,'2021-05-07 14:02:54','2021-05-07 14:02:54',NULL),(549,3150,112,40734,18554,19,395,1,30000.00,NULL,'2021-05-07 14:02:54','2021-05-07 14:02:54',NULL),(550,3150,112,40734,18554,19,57,2,60000.00,NULL,'2021-05-07 14:02:54','2021-05-07 14:02:54',NULL),(551,3150,113,40734,18554,5,396,1,6446.67,NULL,'2021-05-07 14:11:23','2021-05-10 18:59:35','2021-05-10 18:59:35'),(552,3150,113,40734,18554,5,492,1,3393.26,NULL,'2021-05-07 14:11:23','2021-05-10 18:59:35','2021-05-10 18:59:35'),(553,3150,113,40734,18554,5,436,1,144754.70,NULL,'2021-05-07 14:11:23','2021-05-10 18:59:35','2021-05-10 18:59:35'),(554,3150,113,40734,18554,5,164,1,268078.19,NULL,'2021-05-07 14:11:23','2021-05-10 18:59:35','2021-05-10 18:59:35'),(555,3150,113,40734,18554,5,455,2,431298.80,NULL,'2021-05-07 14:11:23','2021-05-10 18:59:35','2021-05-10 18:59:35'),(556,3150,113,40734,18554,5,251,1,8155.86,NULL,'2021-05-07 14:11:23','2021-05-10 18:59:35','2021-05-10 18:59:35'),(557,3150,113,40734,18554,5,255,1,470.12,NULL,'2021-05-07 14:11:23','2021-05-10 18:59:35','2021-05-10 18:59:35'),(558,3150,114,40734,18554,8,302,1,8155.86,NULL,'2021-05-07 14:22:31','2021-05-10 12:27:04','2021-05-10 12:27:04'),(559,3150,114,40734,18554,8,305,1,470.12,NULL,'2021-05-07 14:22:31','2021-05-10 12:27:04','2021-05-10 12:27:04'),(560,3150,114,40734,18554,8,251,2,8155.86,NULL,'2021-05-07 14:22:31','2021-05-10 12:27:04','2021-05-10 12:27:04'),(561,3150,114,40734,18554,8,255,2,470.12,NULL,'2021-05-07 14:22:31','2021-05-10 12:27:04','2021-05-10 12:27:04'),(562,3150,115,40734,18554,3,365,1,5500.00,NULL,'2021-05-07 14:25:21','2021-05-07 14:25:21',NULL),(563,3150,115,40734,18554,3,57,2,5500.00,NULL,'2021-05-07 14:25:21','2021-05-07 14:25:21',NULL),(564,3150,116,40734,18554,1,62,1,60000.00,NULL,'2021-05-07 14:26:34','2021-05-07 14:26:34',NULL),(565,3150,116,40734,18554,1,368,2,30000.00,NULL,'2021-05-07 14:26:34','2021-05-07 14:26:34',NULL),(566,3150,116,40734,18554,1,395,2,30000.00,NULL,'2021-05-07 14:26:34','2021-05-07 14:26:34',NULL),(567,3150,117,40734,18554,15,73,1,51233.24,NULL,'2021-05-07 15:04:18','2021-05-07 15:16:11','2021-05-07 15:16:11');
INSERT INTO `balance_libro_details` VALUES (568,3150,117,40734,18554,15,72,2,154.95,NULL,'2021-05-07 15:04:18','2021-05-07 15:16:11','2021-05-07 15:16:11'),(569,3150,117,40734,18554,15,354,2,46824.53,NULL,'2021-05-07 15:04:18','2021-05-07 15:16:11','2021-05-07 15:16:11'),(570,3150,117,40734,18554,15,354,2,24608.36,NULL,'2021-05-07 15:04:18','2021-05-07 15:16:11','2021-05-07 15:16:11'),(571,3150,117,40734,18554,15,353,2,4253.76,NULL,'2021-05-07 15:04:18','2021-05-07 15:16:11','2021-05-07 15:16:11'),(572,3150,117,40734,18554,15,79,1,24608.36,NULL,'2021-05-07 15:04:18','2021-05-07 15:16:11','2021-05-07 15:16:11'),(573,3150,118,40734,18554,18,354,1,46979.48,NULL,'2021-05-07 15:08:48','2021-05-07 15:16:01','2021-05-07 15:16:01'),(574,3150,118,40734,18554,18,353,1,4253.76,NULL,'2021-05-07 15:08:48','2021-05-07 15:16:01','2021-05-07 15:16:01'),(575,3150,118,40734,18554,18,73,2,51233.24,NULL,'2021-05-07 15:08:48','2021-05-07 15:16:01','2021-05-07 15:16:01'),(576,3150,119,40734,18554,5,396,1,6559.55,NULL,'2021-05-07 15:11:06','2021-05-07 15:15:51','2021-05-07 15:15:51'),(577,3150,119,40734,18554,5,492,1,788.73,NULL,'2021-05-07 15:11:06','2021-05-07 15:15:51','2021-05-07 15:15:51'),(578,3150,119,40734,18554,5,57,1,99893.05,NULL,'2021-05-07 15:11:06','2021-05-07 15:15:51','2021-05-07 15:15:51'),(579,3150,119,40734,18554,5,164,2,107241.33,NULL,'2021-05-07 15:11:06','2021-05-07 15:15:51','2021-05-07 15:15:51'),(580,3150,120,40734,18554,1,110,1,60000.00,NULL,'2021-05-07 15:12:43','2021-05-07 15:15:41','2021-05-07 15:15:41'),(581,3150,120,40734,18554,1,191,1,8539.20,NULL,'2021-05-07 15:12:43','2021-05-07 15:15:41','2021-05-07 15:15:41'),(582,3150,120,40734,18554,1,62,2,60000.00,NULL,'2021-05-07 15:12:43','2021-05-07 15:15:41','2021-05-07 15:15:41'),(583,3150,120,40734,18554,1,63,2,8539.20,NULL,'2021-05-07 15:12:43','2021-05-07 15:15:41','2021-05-07 15:15:41'),(584,3150,121,40734,18554,19,368,1,50000.00,NULL,'2021-05-07 15:13:43','2021-05-07 15:15:29','2021-05-07 15:15:29'),(585,3150,121,40734,18554,19,395,1,20000.00,NULL,'2021-05-07 15:13:43','2021-05-07 15:15:29','2021-05-07 15:15:29'),(586,3150,121,40734,18554,19,57,2,70000.00,NULL,'2021-05-07 15:13:43','2021-05-07 15:15:29','2021-05-07 15:15:29'),(587,3150,122,40734,18555,19,368,1,50000.00,NULL,'2021-05-07 15:15:29','2021-05-07 15:15:29',NULL),(588,3150,122,40734,18555,19,395,1,20000.00,NULL,'2021-05-07 15:15:29','2021-05-07 15:15:29',NULL),(589,3150,122,40734,18555,19,57,2,70000.00,NULL,'2021-05-07 15:15:29','2021-05-07 15:15:29',NULL),(590,3150,123,40734,18555,1,110,1,60000.00,NULL,'2021-05-07 15:15:41','2021-05-07 15:15:41',NULL),(591,3150,123,40734,18555,1,191,1,8539.20,NULL,'2021-05-07 15:15:41','2021-05-07 15:15:41',NULL),(592,3150,123,40734,18555,1,62,2,60000.00,NULL,'2021-05-07 15:15:41','2021-05-07 15:15:41',NULL),(593,3150,123,40734,18555,1,63,2,8539.20,NULL,'2021-05-07 15:15:41','2021-05-07 15:15:41',NULL),(594,3150,124,40734,18554,5,396,1,6559.55,NULL,'2021-05-07 15:15:51','2021-05-10 12:04:14','2021-05-10 12:04:14'),(595,3150,124,40734,18554,5,492,1,788.73,NULL,'2021-05-07 15:15:51','2021-05-10 12:04:14','2021-05-10 12:04:14'),(596,3150,124,40734,18554,5,57,1,99893.05,NULL,'2021-05-07 15:15:51','2021-05-10 12:04:14','2021-05-10 12:04:14'),(597,3150,124,40734,18554,5,164,2,107241.33,NULL,'2021-05-07 15:15:51','2021-05-10 12:04:14','2021-05-10 12:04:14'),(598,3150,125,40734,18554,18,354,1,46979.48,NULL,'2021-05-07 15:16:01','2021-05-10 12:33:18','2021-05-10 12:33:18'),(599,3150,125,40734,18554,18,353,1,4253.76,NULL,'2021-05-07 15:16:01','2021-05-10 12:33:18','2021-05-10 12:33:18'),(600,3150,125,40734,18554,18,73,2,51233.24,NULL,'2021-05-07 15:16:01','2021-05-10 12:33:18','2021-05-10 12:33:18'),(601,3150,126,40734,18554,15,73,1,51233.24,NULL,'2021-05-07 15:16:11','2021-05-10 12:11:35','2021-05-10 12:11:35'),(602,3150,126,40734,18554,15,72,2,154.95,NULL,'2021-05-07 15:16:11','2021-05-10 12:11:35','2021-05-10 12:11:35'),(603,3150,126,40734,18554,15,354,2,46824.53,NULL,'2021-05-07 15:16:11','2021-05-10 12:11:35','2021-05-10 12:11:35');
INSERT INTO `balance_libro_details` VALUES (604,3150,126,40734,18554,15,354,2,24608.36,NULL,'2021-05-07 15:16:11','2021-05-10 12:11:35','2021-05-10 12:11:35'),(605,3150,126,40734,18554,15,353,2,4253.76,NULL,'2021-05-07 15:16:11','2021-05-10 12:11:35','2021-05-10 12:11:35'),(606,3150,126,40734,18554,15,79,1,24608.36,NULL,'2021-05-07 15:16:11','2021-05-10 12:11:35','2021-05-10 12:11:35'),(607,3150,127,40734,18555,10,63,1,9169.20,NULL,'2021-05-07 15:17:13','2021-05-10 17:27:44','2021-05-10 17:27:44'),(608,3150,127,40734,18555,10,57,2,9169.20,NULL,'2021-05-07 15:17:13','2021-05-10 17:27:44','2021-05-10 17:27:44'),(609,3150,128,40734,18555,10,78,1,20273.85,NULL,'2021-05-07 15:18:34','2021-05-11 23:28:21','2021-05-11 23:28:21'),(610,3150,128,40734,18555,10,57,2,20273.85,NULL,'2021-05-07 15:18:34','2021-05-11 23:28:21','2021-05-11 23:28:21'),(611,3150,129,40734,18555,3,192,1,5500.00,NULL,'2021-05-07 15:19:19','2021-05-07 15:19:19',NULL),(612,3150,129,40734,18555,3,57,2,5500.00,NULL,'2021-05-07 15:19:19','2021-05-07 15:19:19',NULL),(613,3150,130,40734,18556,15,68,2,44.33,NULL,'2021-05-07 20:01:50','2021-05-10 14:42:58','2021-05-10 14:42:58'),(614,3150,130,40734,18556,15,73,1,51277.57,NULL,'2021-05-07 20:01:50','2021-05-10 14:42:58','2021-05-10 14:42:58'),(615,3150,130,40734,18556,15,354,2,46979.48,NULL,'2021-05-07 20:01:50','2021-05-10 14:42:58','2021-05-10 14:42:58'),(616,3150,130,40734,18556,15,353,2,4253.76,NULL,'2021-05-07 20:01:50','2021-05-10 14:42:58','2021-05-10 14:42:58'),(617,3150,131,40734,18556,5,396,1,6671.31,NULL,'2021-05-07 20:03:57','2021-05-07 20:03:57',NULL),(618,3150,131,40734,18556,5,492,1,501.68,NULL,'2021-05-07 20:03:57','2021-05-07 20:03:57',NULL),(619,3150,131,40734,18556,5,57,1,76939.20,NULL,'2021-05-07 20:03:57','2021-05-07 20:03:57',NULL),(620,3150,131,40734,18556,5,164,2,84112.19,NULL,'2021-05-07 20:03:57','2021-05-07 20:03:57',NULL),(621,3150,132,40734,18556,19,368,1,33400.00,NULL,'2021-05-07 20:05:17','2021-05-07 20:05:17',NULL),(622,3150,132,40734,18556,19,395,1,20000.00,NULL,'2021-05-07 20:05:17','2021-05-07 20:05:17',NULL),(623,3150,132,40734,18556,19,57,2,53400.00,NULL,'2021-05-07 20:05:17','2021-05-07 20:05:17',NULL),(624,3150,133,40734,18556,18,354,1,47023.81,NULL,'2021-05-07 20:08:32','2021-05-10 15:55:21','2021-05-10 15:55:21'),(625,3150,133,40734,18556,18,353,1,4253.76,NULL,'2021-05-07 20:08:32','2021-05-10 15:55:21','2021-05-10 15:55:21'),(626,3150,133,40734,18556,18,73,2,51277.57,NULL,'2021-05-07 20:08:32','2021-05-10 15:55:21','2021-05-10 15:55:21'),(627,3150,134,40734,18556,1,110,1,60000.00,NULL,'2021-05-08 19:06:02','2021-05-11 12:51:16','2021-05-11 12:51:16'),(628,3150,134,40734,18556,1,191,1,9169.20,NULL,'2021-05-08 19:06:02','2021-05-11 12:51:16','2021-05-11 12:51:16'),(629,3150,134,40734,18556,1,63,2,60000.00,NULL,'2021-05-08 19:06:02','2021-05-11 12:51:16','2021-05-11 12:51:16'),(630,3150,134,40734,18556,1,62,2,9169.20,NULL,'2021-05-08 19:06:02','2021-05-11 12:51:16','2021-05-11 12:51:16'),(631,3150,135,40734,18556,10,78,1,93487.79,NULL,'2021-05-08 19:07:38','2021-05-10 12:25:48','2021-05-10 12:25:48'),(632,3150,135,40734,18556,10,20,2,93487.79,NULL,'2021-05-08 19:07:38','2021-05-10 12:25:48','2021-05-10 12:25:48'),(633,3150,136,40734,18556,10,63,1,8539.20,NULL,'2021-05-08 19:08:47','2021-05-08 19:08:47',NULL),(634,3150,136,40734,18556,10,57,2,8539.20,NULL,'2021-05-08 19:08:47','2021-05-08 19:08:47',NULL),(635,3150,137,40734,18556,3,192,1,5770.00,NULL,'2021-05-08 22:25:11','2021-05-08 22:25:11',NULL),(636,3150,137,40734,18556,3,57,2,5770.00,NULL,'2021-05-08 22:25:11','2021-05-08 22:25:11',NULL),(637,3150,138,40734,18556,15,72,2,160.65,NULL,'2021-05-08 22:29:24','2021-05-10 12:14:22','2021-05-10 12:14:22'),(638,3150,138,40734,18556,15,73,1,51438.22,NULL,'2021-05-08 22:29:24','2021-05-10 12:14:22','2021-05-10 12:14:22'),(639,3150,138,40734,18556,15,354,2,47023.81,NULL,'2021-05-08 22:29:24','2021-05-10 12:14:22','2021-05-10 12:14:22');
INSERT INTO `balance_libro_details` VALUES (640,3150,138,40734,18556,15,353,2,4253.76,NULL,'2021-05-08 22:29:24','2021-05-10 12:14:22','2021-05-10 12:14:22'),(641,3150,139,40734,18557,5,396,1,6800.85,NULL,'2021-05-08 22:31:46','2021-05-08 22:31:46',NULL),(642,3150,139,40734,18557,5,492,1,697.01,NULL,'2021-05-08 22:31:46','2021-05-08 22:31:46',NULL),(643,3150,139,40734,18557,5,57,1,159364.18,NULL,'2021-05-08 22:31:46','2021-05-08 22:31:46',NULL),(644,3150,139,40734,18557,5,164,2,166862.04,NULL,'2021-05-08 22:31:46','2021-05-08 22:31:46',NULL),(645,3150,140,40734,18557,1,110,1,90000.00,NULL,'2021-05-08 22:34:02','2021-05-10 17:11:48','2021-05-10 17:11:48'),(646,3150,140,40734,18557,1,62,2,90000.00,NULL,'2021-05-08 22:34:02','2021-05-10 17:11:48','2021-05-10 17:11:48'),(647,3150,140,40734,18557,1,63,2,13753.00,NULL,'2021-05-08 22:34:02','2021-05-10 17:11:48','2021-05-10 17:11:48'),(648,3150,140,40734,18557,1,191,1,13753.00,NULL,'2021-05-08 22:34:02','2021-05-10 17:11:48','2021-05-10 17:11:48'),(649,3150,141,40734,18557,10,495,1,7188.12,NULL,'2021-05-08 22:41:26','2021-05-08 22:41:26',NULL),(650,3150,141,40734,18557,10,493,1,25506.86,NULL,'2021-05-08 22:41:26','2021-05-08 22:41:26',NULL),(651,3150,141,40734,18557,10,57,2,32694.98,NULL,'2021-05-08 22:41:26','2021-05-08 22:41:26',NULL),(652,3150,142,40734,18557,18,353,1,47184.46,NULL,'2021-05-08 22:43:39','2021-05-10 13:36:02','2021-05-10 13:36:02'),(653,3150,142,40734,18557,18,354,1,4253.76,NULL,'2021-05-08 22:43:39','2021-05-10 13:36:02','2021-05-10 13:36:02'),(654,3150,142,40734,18557,18,73,2,51438.22,NULL,'2021-05-08 22:43:39','2021-05-10 13:36:02','2021-05-10 13:36:02'),(655,3150,143,40734,18557,19,368,1,77500.00,NULL,'2021-05-08 22:44:48','2021-05-08 22:44:48',NULL),(656,3150,143,40734,18557,19,395,1,40000.00,NULL,'2021-05-08 22:44:48','2021-05-08 22:44:48',NULL),(657,3150,143,40734,18557,19,57,2,117500.00,NULL,'2021-05-08 22:44:48','2021-05-08 22:44:48',NULL),(658,3150,144,40734,18558,15,72,2,163.71,NULL,'2021-05-08 22:51:48','2021-05-10 16:09:19','2021-05-10 16:09:19'),(659,3150,144,40734,18558,15,73,1,51601.93,NULL,'2021-05-08 22:51:48','2021-05-10 16:09:19','2021-05-10 16:09:19'),(660,3150,144,40734,18558,15,354,2,47184.46,NULL,'2021-05-08 22:51:48','2021-05-10 16:09:19','2021-05-10 16:09:19'),(661,3150,144,40734,18558,15,353,2,4253.76,NULL,'2021-05-08 22:51:48','2021-05-10 16:09:19','2021-05-10 16:09:19'),(662,3150,145,40734,18558,5,396,1,6930.39,NULL,'2021-05-08 22:53:53','2021-05-08 22:53:53',NULL),(663,3150,145,40734,18558,5,492,1,550.03,NULL,'2021-05-08 22:53:53','2021-05-08 22:53:53',NULL),(664,3150,145,40734,18558,5,57,1,37295.73,NULL,'2021-05-08 22:53:53','2021-05-08 22:53:53',NULL),(665,3150,145,40734,18558,5,164,2,44776.15,NULL,'2021-05-08 22:53:53','2021-05-08 22:53:53',NULL),(666,3150,146,40734,18558,10,493,1,8498.89,NULL,'2021-05-08 22:54:58','2021-05-08 22:54:58',NULL),(667,3150,146,40734,18558,10,57,2,8498.89,NULL,'2021-05-08 22:54:58','2021-05-08 22:54:58',NULL),(668,3150,147,40734,18558,18,354,1,43094.41,NULL,'2021-05-08 22:57:33','2021-05-10 16:09:41','2021-05-10 16:09:41'),(669,3150,147,40734,18558,18,353,1,4253.76,NULL,'2021-05-08 22:57:33','2021-05-10 16:09:41','2021-05-10 16:09:41'),(670,3150,147,40734,18558,18,73,2,47348.17,NULL,'2021-05-08 22:57:33','2021-05-10 16:09:41','2021-05-10 16:09:41'),(671,3150,148,40734,18558,1,63,2,9169.20,NULL,'2021-05-08 22:58:56','2021-05-08 22:58:56',NULL),(672,3150,148,40734,18558,1,191,1,9169.20,NULL,'2021-05-08 22:58:56','2021-05-08 22:58:56',NULL),(673,3150,148,40734,18558,1,110,1,60000.00,NULL,'2021-05-08 22:58:56','2021-05-08 22:58:56',NULL),(674,3150,148,40734,18558,1,62,2,60000.00,NULL,'2021-05-08 22:58:56','2021-05-08 22:58:56',NULL),(675,3150,149,40734,18558,19,368,1,12355.87,NULL,'2021-05-08 23:01:26','2021-05-08 23:01:26',NULL),(676,3150,149,40734,18558,19,57,2,12355.87,NULL,'2021-05-08 23:01:26','2021-05-08 23:01:26',NULL),(677,3150,150,40734,18558,19,368,1,2417.77,NULL,'2021-05-08 23:03:30','2021-05-08 23:03:30',NULL);
INSERT INTO `balance_libro_details` VALUES (678,3150,150,40734,18558,19,57,2,2417.77,NULL,'2021-05-08 23:03:30','2021-05-08 23:03:30',NULL),(679,3150,151,40734,18558,3,192,1,5000.00,NULL,'2021-05-08 23:04:22','2021-05-08 23:04:22',NULL),(680,3150,151,40734,18558,3,57,2,5000.00,NULL,'2021-05-08 23:04:22','2021-05-08 23:04:22',NULL),(681,3150,152,40734,18558,1,63,1,13753.20,NULL,'2021-05-08 23:05:26','2021-05-10 17:29:34','2021-05-10 17:29:34'),(682,3150,152,40734,18558,1,57,2,13753.20,NULL,'2021-05-08 23:05:26','2021-05-10 17:29:34','2021-05-10 17:29:34'),(683,3150,153,40734,18559,15,73,1,51768.22,NULL,'2021-05-08 23:07:22','2021-05-10 16:10:27','2021-05-10 16:10:27'),(684,3150,153,40734,18559,15,72,2,166.29,NULL,'2021-05-08 23:07:22','2021-05-10 16:10:27','2021-05-10 16:10:27'),(685,3150,153,40734,18559,15,354,2,47348.17,NULL,'2021-05-08 23:07:22','2021-05-10 16:10:27','2021-05-10 16:10:27'),(686,3150,153,40734,18559,15,353,2,4253.76,NULL,'2021-05-08 23:07:22','2021-05-10 16:10:27','2021-05-10 16:10:27'),(687,3150,154,40734,18558,5,396,1,7039.61,NULL,'2021-05-08 23:09:28','2021-05-08 23:11:37','2021-05-08 23:11:37'),(688,3150,154,40734,18558,5,492,1,577.61,NULL,'2021-05-08 23:09:28','2021-05-08 23:11:37','2021-05-08 23:11:37'),(689,3150,154,40734,18558,5,57,1,86669.20,NULL,'2021-05-08 23:09:28','2021-05-08 23:11:37','2021-05-08 23:11:37'),(690,3150,154,40734,18558,5,164,2,94286.42,NULL,'2021-05-08 23:09:28','2021-05-08 23:11:37','2021-05-08 23:11:37'),(691,3150,155,40734,18558,19,368,1,52000.00,NULL,'2021-05-08 23:10:58','2021-05-08 23:11:51','2021-05-08 23:11:51'),(692,3150,155,40734,18558,19,395,1,20000.00,NULL,'2021-05-08 23:10:58','2021-05-08 23:11:51','2021-05-08 23:11:51'),(693,3150,155,40734,18558,19,57,2,72000.00,NULL,'2021-05-08 23:10:58','2021-05-08 23:11:51','2021-05-08 23:11:51'),(694,3150,156,40734,18559,5,396,1,7039.61,NULL,'2021-05-08 23:11:37','2021-05-08 23:11:37',NULL),(695,3150,156,40734,18559,5,492,1,577.61,NULL,'2021-05-08 23:11:37','2021-05-08 23:11:37',NULL),(696,3150,156,40734,18559,5,57,1,86669.20,NULL,'2021-05-08 23:11:37','2021-05-08 23:11:37',NULL),(697,3150,156,40734,18559,5,164,2,94286.42,NULL,'2021-05-08 23:11:37','2021-05-08 23:11:37',NULL),(698,3150,157,40734,18559,19,368,1,52000.00,NULL,'2021-05-08 23:11:51','2021-05-08 23:11:51',NULL),(699,3150,157,40734,18559,19,395,1,20000.00,NULL,'2021-05-08 23:11:51','2021-05-08 23:11:51',NULL),(700,3150,157,40734,18559,19,57,2,72000.00,NULL,'2021-05-08 23:11:51','2021-05-08 23:11:51',NULL),(701,3150,158,40734,18559,1,110,1,60000.00,NULL,'2021-05-08 23:13:16','2021-05-08 23:13:16',NULL),(702,3150,158,40734,18559,1,62,2,60000.00,NULL,'2021-05-08 23:13:16','2021-05-08 23:13:16',NULL),(703,3150,158,40734,18559,1,191,1,9169.20,NULL,'2021-05-08 23:13:16','2021-05-08 23:13:16',NULL),(704,3150,158,40734,18559,1,63,2,9169.20,NULL,'2021-05-08 23:13:16','2021-05-08 23:13:16',NULL),(705,3150,159,40734,18559,1,63,1,9169.20,NULL,'2021-05-08 23:14:10','2021-05-10 17:28:46','2021-05-10 17:28:46'),(706,3150,159,40734,18559,1,57,2,9169.20,NULL,'2021-05-08 23:14:10','2021-05-10 17:28:46','2021-05-10 17:28:46'),(707,3150,160,40734,18559,18,354,1,47348.17,NULL,'2021-05-08 23:16:08','2021-05-10 16:11:39','2021-05-10 16:11:39'),(708,3150,160,40734,18559,18,353,1,4253.76,NULL,'2021-05-08 23:16:08','2021-05-10 16:11:39','2021-05-10 16:11:39'),(709,3150,160,40734,18559,18,73,2,51601.93,NULL,'2021-05-08 23:16:08','2021-05-10 16:11:39','2021-05-10 16:11:39'),(710,3150,161,40734,18559,3,192,1,5500.00,NULL,'2021-05-08 23:18:18','2021-05-08 23:18:18',NULL),(711,3150,161,40734,18559,3,57,2,5500.00,NULL,'2021-05-08 23:18:18','2021-05-08 23:18:18',NULL),(712,3150,162,40734,18560,15,72,2,482.28,NULL,'2021-05-08 23:21:37','2021-05-10 16:14:24','2021-05-10 16:14:24'),(713,3150,162,40734,18560,15,493,1,8498.89,NULL,'2021-05-08 23:21:37','2021-05-10 16:14:24','2021-05-10 16:14:24'),(714,3150,162,40734,18560,15,73,1,43751.61,NULL,'2021-05-08 23:21:37','2021-05-10 16:14:24','2021-05-10 16:14:24');
INSERT INTO `balance_libro_details` VALUES (715,3150,162,40734,18560,15,354,2,47514.46,NULL,'2021-05-08 23:21:37','2021-05-10 16:14:24','2021-05-10 16:14:24'),(716,3150,162,40734,18560,15,353,2,4253.76,NULL,'2021-05-08 23:21:37','2021-05-10 16:14:24','2021-05-10 16:14:24'),(717,3150,163,40734,18560,5,396,1,7141.21,NULL,'2021-05-08 23:23:29','2021-05-08 23:23:29',NULL),(718,3150,163,40734,18560,5,492,1,565.87,NULL,'2021-05-08 23:23:29','2021-05-08 23:23:29',NULL),(719,3150,163,40734,18560,5,57,1,87168.09,NULL,'2021-05-08 23:23:29','2021-05-08 23:23:29',NULL),(720,3150,163,40734,18560,5,164,2,94875.17,NULL,'2021-05-08 23:23:29','2021-05-08 23:23:29',NULL),(721,3150,164,40734,18560,19,368,1,44000.00,NULL,'2021-05-08 23:24:38','2021-05-08 23:24:38',NULL),(722,3150,164,40734,18560,19,395,1,20000.00,NULL,'2021-05-08 23:24:38','2021-05-08 23:24:38',NULL),(723,3150,164,40734,18560,19,57,2,64000.00,NULL,'2021-05-08 23:24:38','2021-05-08 23:24:38',NULL),(724,3150,165,40734,18560,1,62,2,60000.00,NULL,'2021-05-08 23:25:40','2021-05-08 23:25:40',NULL),(725,3150,165,40734,18560,1,110,1,60000.00,NULL,'2021-05-08 23:25:40','2021-05-08 23:25:40',NULL),(726,3150,165,40734,18560,1,63,2,9169.20,NULL,'2021-05-08 23:25:40','2021-05-08 23:25:40',NULL),(727,3150,165,40734,18560,1,191,1,9169.20,NULL,'2021-05-08 23:25:40','2021-05-08 23:25:40',NULL),(728,3150,166,40734,18560,10,493,1,8498.89,NULL,'2021-05-08 23:26:58','2021-05-08 23:26:58',NULL),(729,3150,166,40734,18560,10,57,2,8498.89,NULL,'2021-05-08 23:26:58','2021-05-08 23:26:58',NULL),(730,3150,167,40734,18560,1,63,1,9169.20,NULL,'2021-05-08 23:27:52','2021-05-10 17:25:47','2021-05-10 17:25:47'),(731,3150,167,40734,18560,1,57,2,9169.20,NULL,'2021-05-08 23:27:52','2021-05-10 17:25:47','2021-05-10 17:25:47'),(732,3150,168,40734,18560,18,353,1,4253.76,NULL,'2021-05-08 23:29:46','2021-05-10 16:15:30','2021-05-10 16:15:30'),(733,3150,168,40734,18560,18,354,1,39497.85,NULL,'2021-05-08 23:29:46','2021-05-10 16:15:30','2021-05-10 16:15:30'),(734,3150,168,40734,18560,18,73,2,43751.61,NULL,'2021-05-08 23:29:46','2021-05-10 16:15:30','2021-05-10 16:15:30'),(735,3150,169,40734,18560,3,192,1,5500.00,NULL,'2021-05-08 23:30:37','2021-05-08 23:30:37',NULL),(736,3150,169,40734,18560,3,57,2,5500.00,NULL,'2021-05-08 23:30:37','2021-05-08 23:30:37',NULL),(737,3150,170,40734,18561,15,72,2,173.61,NULL,'2021-05-08 23:32:36','2021-05-10 16:17:52','2021-05-10 16:17:52'),(738,3150,170,40734,18561,15,73,1,43925.22,NULL,'2021-05-08 23:32:36','2021-05-10 16:17:52','2021-05-10 16:17:52'),(739,3150,170,40734,18561,15,354,2,39497.85,NULL,'2021-05-08 23:32:36','2021-05-10 16:17:52','2021-05-10 16:17:52'),(740,3150,170,40734,18561,15,353,2,4253.76,NULL,'2021-05-08 23:32:36','2021-05-10 16:17:52','2021-05-10 16:17:52'),(741,3150,171,40734,18561,19,368,1,53809.00,NULL,'2021-05-08 23:33:38','2021-05-08 23:33:38',NULL),(742,3150,171,40734,18561,19,395,1,20000.00,NULL,'2021-05-08 23:33:38','2021-05-08 23:33:38',NULL),(743,3150,171,40734,18561,19,57,2,73809.00,NULL,'2021-05-08 23:33:38','2021-05-08 23:33:38',NULL),(744,3150,172,40734,18561,5,396,1,7349.49,NULL,'2021-05-08 23:35:11','2021-05-08 23:35:11',NULL),(745,3150,172,40734,18561,5,492,1,567.18,NULL,'2021-05-08 23:35:11','2021-05-08 23:35:11',NULL),(746,3150,172,40734,18561,5,57,1,87178.20,NULL,'2021-05-08 23:35:11','2021-05-08 23:35:11',NULL),(747,3150,172,40734,18561,5,164,2,95094.87,NULL,'2021-05-08 23:35:11','2021-05-08 23:35:11',NULL),(748,3150,173,40734,18561,1,62,2,60000.00,NULL,'2021-05-08 23:36:51','2021-05-08 23:36:51',NULL),(749,3150,173,40734,18561,1,110,1,60000.00,NULL,'2021-05-08 23:36:51','2021-05-08 23:36:51',NULL),(750,3150,173,40734,18561,1,191,1,9169.20,NULL,'2021-05-08 23:36:51','2021-05-08 23:36:51',NULL),(751,3150,173,40734,18561,1,63,2,9169.20,NULL,'2021-05-08 23:36:51','2021-05-08 23:36:51',NULL),(752,3150,174,40734,18561,10,63,1,9169.20,NULL,'2021-05-08 23:37:54','2021-05-10 17:27:23','2021-05-10 17:27:23');
INSERT INTO `balance_libro_details` VALUES (753,3150,174,40734,18561,10,57,2,9169.20,NULL,'2021-05-08 23:37:54','2021-05-10 17:27:23','2021-05-10 17:27:23'),(754,3150,175,40734,18561,3,192,1,5500.00,NULL,'2021-05-08 23:38:58','2021-05-08 23:38:58',NULL),(755,3150,175,40734,18561,3,57,2,5500.00,NULL,'2021-05-08 23:38:58','2021-05-08 23:38:58',NULL),(756,3150,176,40734,18562,15,73,1,35602.82,NULL,'2021-05-08 23:44:25','2021-05-10 13:50:11','2021-05-10 13:50:11'),(757,3150,176,40734,18562,15,72,2,176.49,NULL,'2021-05-08 23:44:25','2021-05-10 13:50:11','2021-05-10 13:50:11'),(758,3150,176,40734,18562,15,354,2,39671.46,NULL,'2021-05-08 23:44:25','2021-05-10 13:50:11','2021-05-10 13:50:11'),(759,3150,176,40734,18562,15,353,2,4253.76,NULL,'2021-05-08 23:44:25','2021-05-10 13:50:11','2021-05-10 13:50:11'),(760,3150,176,40734,18562,15,79,1,8498.89,NULL,'2021-05-08 23:44:25','2021-05-10 13:50:11','2021-05-10 13:50:11'),(761,3150,177,40734,18562,5,396,1,8271.41,NULL,'2021-05-08 23:46:22','2021-05-08 23:46:22',NULL),(762,3150,177,40734,18562,5,492,1,974.17,NULL,'2021-05-08 23:46:22','2021-05-08 23:46:22',NULL),(763,3150,177,40734,18562,5,57,1,104087.85,NULL,'2021-05-08 23:46:22','2021-05-08 23:46:22',NULL),(764,3150,177,40734,18562,5,368,2,50000.00,NULL,'2021-05-08 23:46:22','2021-05-08 23:46:22',NULL),(765,3150,177,40734,18562,5,164,2,63333.43,NULL,'2021-05-08 23:46:22','2021-05-08 23:46:22',NULL),(766,3150,178,40734,18562,18,354,1,27095.30,NULL,'2021-05-08 23:48:26','2021-05-10 16:22:23','2021-05-10 16:22:23'),(767,3150,178,40734,18562,18,353,1,4253.76,NULL,'2021-05-08 23:48:26','2021-05-10 16:22:23','2021-05-10 16:22:23'),(768,3150,178,40734,18562,18,73,2,31349.06,NULL,'2021-05-08 23:48:26','2021-05-10 16:22:23','2021-05-10 16:22:23'),(769,3150,179,40734,18562,10,493,1,8498.89,NULL,'2021-05-08 23:49:20','2021-05-08 23:49:20',NULL),(770,3150,179,40734,18562,10,57,2,8498.89,NULL,'2021-05-08 23:49:20','2021-05-08 23:49:20',NULL),(771,3150,180,40734,18562,1,110,1,60000.00,NULL,'2021-05-08 23:50:23','2021-05-08 23:50:23',NULL),(772,3150,180,40734,18562,1,191,1,9169.20,NULL,'2021-05-08 23:50:23','2021-05-08 23:50:23',NULL),(773,3150,180,40734,18562,1,62,2,60000.00,NULL,'2021-05-08 23:50:23','2021-05-08 23:50:23',NULL),(774,3150,180,40734,18562,1,63,2,9169.20,NULL,'2021-05-08 23:50:23','2021-05-08 23:50:23',NULL),(775,3150,181,40734,18562,19,368,1,30000.00,NULL,'2021-05-08 23:51:34','2021-05-08 23:51:34',NULL),(776,3150,181,40734,18562,19,395,1,20000.00,NULL,'2021-05-08 23:51:34','2021-05-08 23:51:34',NULL),(777,3150,181,40734,18562,19,57,2,50000.00,NULL,'2021-05-08 23:51:34','2021-05-08 23:51:34',NULL),(778,3150,182,40734,18562,3,192,1,5500.00,NULL,'2021-05-08 23:52:48','2021-05-08 23:52:48',NULL),(779,3150,182,40734,18562,3,57,2,5500.00,NULL,'2021-05-08 23:52:48','2021-05-08 23:52:48',NULL),(780,3150,183,40734,18563,15,68,2,3.61,NULL,'2021-05-08 23:56:09','2021-05-10 14:05:44','2021-05-10 14:05:44'),(781,3150,183,40734,18563,15,72,2,532.82,NULL,'2021-05-08 23:56:09','2021-05-10 14:05:44','2021-05-10 14:05:44'),(782,3150,183,40734,18563,15,73,1,36139.25,NULL,'2021-05-08 23:56:09','2021-05-10 14:05:44','2021-05-10 14:05:44'),(783,3150,183,40734,18563,15,354,2,31349.06,NULL,'2021-05-08 23:56:09','2021-05-10 14:05:44','2021-05-10 14:05:44'),(784,3150,183,40734,18563,15,353,2,4253.76,NULL,'2021-05-08 23:56:09','2021-05-10 14:05:44','2021-05-10 14:05:44'),(785,3150,184,40734,18562,5,396,1,7270.79,NULL,'2021-05-09 00:02:34','2021-05-09 00:03:09','2021-05-09 00:03:09'),(786,3150,184,40734,18562,5,492,1,1544.22,NULL,'2021-05-09 00:02:34','2021-05-09 00:03:09','2021-05-09 00:03:09'),(787,3150,184,40734,18562,5,252,1,1600.00,NULL,'2021-05-09 00:02:34','2021-05-09 00:03:09','2021-05-09 00:03:09'),(788,3150,184,40734,18562,5,255,1,960.00,NULL,'2021-05-09 00:02:34','2021-05-09 00:03:09','2021-05-09 00:03:09'),(789,3150,184,40734,18562,5,57,1,142535.60,NULL,'2021-05-09 00:02:34','2021-05-09 00:03:09','2021-05-09 00:03:09');
INSERT INTO `balance_libro_details` VALUES (790,3150,184,40734,18562,5,368,2,80000.00,NULL,'2021-05-09 00:02:34','2021-05-09 00:03:09','2021-05-09 00:03:09'),(791,3150,184,40734,18562,5,395,2,80000.00,NULL,'2021-05-09 00:02:34','2021-05-09 00:03:09','2021-05-09 00:03:09'),(792,3150,184,40734,18562,5,164,1,6089.39,NULL,'2021-05-09 00:02:34','2021-05-09 00:03:09','2021-05-09 00:03:09'),(793,3150,185,40734,18563,5,396,1,7270.79,NULL,'2021-05-09 00:03:09','2021-05-10 18:02:35','2021-05-10 18:02:35'),(794,3150,185,40734,18563,5,492,1,1544.22,NULL,'2021-05-09 00:03:09','2021-05-10 18:02:35','2021-05-10 18:02:35'),(795,3150,185,40734,18563,5,252,1,1600.00,NULL,'2021-05-09 00:03:09','2021-05-10 18:02:35','2021-05-10 18:02:35'),(796,3150,185,40734,18563,5,255,1,960.00,NULL,'2021-05-09 00:03:09','2021-05-10 18:02:35','2021-05-10 18:02:35'),(797,3150,185,40734,18563,5,57,1,142535.60,NULL,'2021-05-09 00:03:09','2021-05-10 18:02:35','2021-05-10 18:02:35'),(798,3150,185,40734,18563,5,368,2,80000.00,NULL,'2021-05-09 00:03:09','2021-05-10 18:02:35','2021-05-10 18:02:35'),(799,3150,185,40734,18563,5,395,2,80000.00,NULL,'2021-05-09 00:03:09','2021-05-10 18:02:35','2021-05-10 18:02:35'),(800,3150,185,40734,18563,5,164,1,6089.39,NULL,'2021-05-09 00:03:09','2021-05-10 18:02:35','2021-05-10 18:02:35'),(801,3150,186,40734,18563,19,164,1,2248.58,NULL,'2021-05-09 00:04:40','2021-05-10 17:50:25','2021-05-10 17:50:25'),(802,3150,186,40734,18563,19,103,2,2248.58,NULL,'2021-05-09 00:04:40','2021-05-10 17:50:25','2021-05-10 17:50:25'),(803,3150,187,40734,18563,1,110,1,90000.00,NULL,'2021-05-09 00:06:10','2021-05-09 00:06:10',NULL),(804,3150,187,40734,18563,1,191,1,13753.20,NULL,'2021-05-09 00:06:10','2021-05-09 00:06:10',NULL),(805,3150,187,40734,18563,1,62,2,90000.00,NULL,'2021-05-09 00:06:10','2021-05-09 00:06:10',NULL),(806,3150,187,40734,18563,1,63,2,13753.20,NULL,'2021-05-09 00:06:10','2021-05-09 00:06:10',NULL),(807,3150,188,40734,18563,18,251,2,1600.00,NULL,'2021-05-09 00:09:04','2021-05-24 22:25:48','2021-05-24 22:25:48'),(808,3150,188,40734,18563,18,255,2,960.00,NULL,'2021-05-09 00:09:04','2021-05-24 22:25:48','2021-05-24 22:25:48'),(809,3150,188,40734,18563,18,494,1,2560.00,NULL,'2021-05-09 00:09:04','2021-05-24 22:25:48','2021-05-24 22:25:48'),(810,3150,189,40734,18563,19,368,1,35000.00,NULL,'2021-05-09 00:10:29','2021-05-09 00:10:29',NULL),(811,3150,189,40734,18563,19,395,1,20000.00,NULL,'2021-05-09 00:10:29','2021-05-09 00:10:29',NULL),(812,3150,189,40734,18563,19,57,2,55000.00,NULL,'2021-05-09 00:10:29','2021-05-09 00:10:29',NULL),(813,3150,190,40734,18563,3,135,1,17.18,NULL,'2021-05-09 00:11:52','2021-05-09 00:11:52',NULL),(814,3150,190,40734,18563,3,68,1,3.61,NULL,'2021-05-09 00:11:52','2021-05-09 00:11:52',NULL),(815,3150,190,40734,18563,3,57,2,20.79,NULL,'2021-05-09 00:11:52','2021-05-09 00:11:52',NULL),(816,3150,191,40734,18563,18,354,1,31878.27,NULL,'2021-05-09 00:17:43','2021-05-10 13:43:42','2021-05-10 13:43:42'),(817,3150,191,40734,18563,18,353,1,4257.37,NULL,'2021-05-09 00:17:43','2021-05-10 13:43:42','2021-05-10 13:43:42'),(818,3150,191,40734,18563,18,73,2,36135.64,NULL,'2021-05-09 00:17:43','2021-05-10 13:43:42','2021-05-10 13:43:42'),(819,3150,192,40734,18563,10,63,1,9169.20,NULL,'2021-05-09 00:18:53','2021-05-10 17:27:02','2021-05-10 17:27:02'),(820,3150,192,40734,18563,10,57,2,9169.20,NULL,'2021-05-09 00:18:53','2021-05-10 17:27:02','2021-05-10 17:27:02'),(821,3150,193,40734,18561,1,62,1,60000.00,NULL,'2021-05-10 11:40:15','2021-05-10 11:40:15',NULL),(822,3150,193,40734,18561,1,368,2,30000.00,NULL,'2021-05-10 11:40:15','2021-05-10 11:40:15',NULL),(823,3150,193,40734,18561,1,395,2,30000.00,NULL,'2021-05-10 11:40:15','2021-05-10 11:40:15',NULL),(824,3150,194,40734,18562,1,62,1,60000.00,NULL,'2021-05-10 11:41:31','2021-05-10 11:41:31',NULL),(825,3150,194,40734,18562,1,368,2,30000.00,NULL,'2021-05-10 11:41:31','2021-05-10 11:41:31',NULL),(826,3150,194,40734,18562,1,395,2,30000.00,NULL,'2021-05-10 11:41:31','2021-05-10 11:41:31',NULL);
INSERT INTO `balance_libro_details` VALUES (827,3150,195,40734,18563,1,62,1,60000.00,NULL,'2021-05-10 11:42:38','2021-05-10 11:42:38',NULL),(828,3150,195,40734,18563,1,368,2,30000.00,NULL,'2021-05-10 11:42:38','2021-05-10 11:42:38',NULL),(829,3150,195,40734,18563,1,395,2,30000.00,NULL,'2021-05-10 11:42:38','2021-05-10 11:42:38',NULL),(830,3150,196,40734,18554,5,396,1,6559.55,NULL,'2021-05-10 12:04:14','2021-05-10 12:04:51','2021-05-10 12:04:51'),(831,3150,196,40734,18554,5,492,1,788.73,NULL,'2021-05-10 12:04:14','2021-05-10 12:04:51','2021-05-10 12:04:51'),(832,3150,196,40734,18554,5,57,1,99893.05,NULL,'2021-05-10 12:04:14','2021-05-10 12:04:51','2021-05-10 12:04:51'),(833,3150,196,40734,18554,5,164,2,107241.33,NULL,'2021-05-10 12:04:14','2021-05-10 12:04:51','2021-05-10 12:04:51'),(834,3150,197,40734,18555,5,396,1,6559.55,NULL,'2021-05-10 12:04:51','2021-05-10 12:04:51',NULL),(835,3150,197,40734,18555,5,492,1,788.73,NULL,'2021-05-10 12:04:51','2021-05-10 12:04:51',NULL),(836,3150,197,40734,18555,5,57,1,99893.05,NULL,'2021-05-10 12:04:51','2021-05-10 12:04:51',NULL),(837,3150,197,40734,18555,5,164,2,107241.33,NULL,'2021-05-10 12:04:51','2021-05-10 12:04:51',NULL),(838,3150,198,40734,18552,9,74,1,40091.97,NULL,'2021-05-10 12:10:00','2021-05-10 12:10:00',NULL),(839,3150,198,40734,18552,9,354,2,40091.97,NULL,'2021-05-10 12:10:00','2021-05-10 12:10:00',NULL),(840,3150,198,40734,18552,9,73,1,148.35,NULL,'2021-05-10 12:10:00','2021-05-10 12:10:00',NULL),(841,3150,198,40734,18552,9,72,2,148.35,NULL,'2021-05-10 12:10:00','2021-05-10 12:10:00',NULL),(842,3150,199,40734,18555,15,73,1,51233.24,NULL,'2021-05-10 12:11:35','2021-05-10 12:22:37','2021-05-10 12:22:37'),(843,3150,199,40734,18555,15,72,2,154.95,NULL,'2021-05-10 12:11:35','2021-05-10 12:22:37','2021-05-10 12:22:37'),(844,3150,199,40734,18555,15,354,2,46824.53,NULL,'2021-05-10 12:11:35','2021-05-10 12:22:37','2021-05-10 12:22:37'),(845,3150,199,40734,18555,15,354,2,24608.36,NULL,'2021-05-10 12:11:35','2021-05-10 12:22:37','2021-05-10 12:22:37'),(846,3150,199,40734,18555,15,353,2,4253.76,NULL,'2021-05-10 12:11:35','2021-05-10 12:22:37','2021-05-10 12:22:37'),(847,3150,199,40734,18555,15,79,1,24608.36,NULL,'2021-05-10 12:11:35','2021-05-10 12:22:37','2021-05-10 12:22:37'),(848,3150,200,40734,18557,15,72,2,160.65,NULL,'2021-05-10 12:14:22','2021-05-10 16:07:33','2021-05-10 16:07:33'),(849,3150,200,40734,18557,15,73,1,51438.22,NULL,'2021-05-10 12:14:22','2021-05-10 16:07:33','2021-05-10 16:07:33'),(850,3150,200,40734,18557,15,354,2,47023.81,NULL,'2021-05-10 12:14:22','2021-05-10 16:07:33','2021-05-10 16:07:33'),(851,3150,200,40734,18557,15,353,2,4253.76,NULL,'2021-05-10 12:14:22','2021-05-10 16:07:33','2021-05-10 16:07:33'),(852,3150,201,40734,18555,9,73,1,51233.24,NULL,'2021-05-10 12:22:37','2021-05-10 15:41:21','2021-05-10 15:41:21'),(853,3150,201,40734,18555,9,72,2,154.95,NULL,'2021-05-10 12:22:37','2021-05-10 15:41:21','2021-05-10 15:41:21'),(854,3150,201,40734,18555,9,354,2,46824.53,NULL,'2021-05-10 12:22:37','2021-05-10 15:41:21','2021-05-10 15:41:21'),(855,3150,201,40734,18555,9,354,2,24608.36,NULL,'2021-05-10 12:22:37','2021-05-10 15:41:21','2021-05-10 15:41:21'),(856,3150,201,40734,18555,9,353,2,4253.76,NULL,'2021-05-10 12:22:37','2021-05-10 15:41:21','2021-05-10 15:41:21'),(857,3150,201,40734,18555,9,79,1,24608.36,NULL,'2021-05-10 12:22:37','2021-05-10 15:41:21','2021-05-10 15:41:21'),(858,3150,202,40734,18556,10,155,1,93487.79,NULL,'2021-05-10 12:25:48','2021-05-10 12:25:48',NULL),(859,3150,202,40734,18556,10,20,2,93487.79,NULL,'2021-05-10 12:25:48','2021-05-10 12:25:48',NULL),(860,3150,203,40734,18554,18,302,1,8155.86,NULL,'2021-05-10 12:27:04','2021-05-10 12:27:04',NULL),(861,3150,203,40734,18554,18,305,1,470.12,NULL,'2021-05-10 12:27:04','2021-05-10 12:27:04',NULL),(862,3150,203,40734,18554,18,251,2,8155.86,NULL,'2021-05-10 12:27:04','2021-05-10 12:27:04',NULL),(863,3150,203,40734,18554,18,255,2,470.12,NULL,'2021-05-10 12:27:04','2021-05-10 12:27:04',NULL);
INSERT INTO `balance_libro_details` VALUES (864,3150,204,40734,18553,1,368,1,55000.00,NULL,'2021-05-10 12:29:54','2021-05-11 11:56:52','2021-05-11 11:56:52'),(865,3150,204,40734,18553,1,57,2,55000.00,NULL,'2021-05-10 12:29:54','2021-05-11 11:56:52','2021-05-11 11:56:52'),(866,3150,205,40734,18555,18,354,1,46979.48,NULL,'2021-05-10 12:33:18','2021-05-10 12:33:50','2021-05-10 12:33:50'),(867,3150,205,40734,18555,18,353,1,4253.76,NULL,'2021-05-10 12:33:18','2021-05-10 12:33:50','2021-05-10 12:33:50'),(868,3150,205,40734,18555,18,73,2,51233.24,NULL,'2021-05-10 12:33:18','2021-05-10 12:33:50','2021-05-10 12:33:50'),(869,3150,206,40734,18555,18,354,1,46979.48,NULL,'2021-05-10 12:33:50','2021-05-10 16:26:07','2021-05-10 16:26:07'),(870,3150,206,40734,18555,18,353,1,4253.76,NULL,'2021-05-10 12:33:50','2021-05-10 16:26:07','2021-05-10 16:26:07'),(871,3150,206,40734,18555,18,73,2,51233.24,NULL,'2021-05-10 12:33:50','2021-05-10 16:26:07','2021-05-10 16:26:07'),(872,3150,207,40734,18557,10,63,1,9169.20,NULL,'2021-05-10 12:41:08','2021-05-10 17:26:36','2021-05-10 17:26:36'),(873,3150,207,40734,18557,10,57,2,9169.20,NULL,'2021-05-10 12:41:08','2021-05-10 17:26:36','2021-05-10 17:26:36'),(874,3150,208,40734,18563,19,497,1,72866.40,NULL,'2021-05-10 13:13:23','2021-05-10 13:13:23',NULL),(875,3150,208,40734,18563,19,27,2,72866.40,NULL,'2021-05-10 13:13:23','2021-05-10 13:13:23',NULL),(876,3150,209,40734,18557,18,353,1,4253.76,NULL,'2021-05-10 13:36:02','2021-05-10 16:08:00','2021-05-10 16:08:00'),(877,3150,209,40734,18557,18,354,1,47184.46,NULL,'2021-05-10 13:36:02','2021-05-10 16:08:00','2021-05-10 16:08:00'),(878,3150,209,40734,18557,18,73,2,51438.22,NULL,'2021-05-10 13:36:02','2021-05-10 16:08:00','2021-05-10 16:08:00'),(879,3150,210,40734,18563,18,354,1,31881.88,NULL,'2021-05-10 13:43:42','2021-05-10 14:06:06','2021-05-10 14:06:06'),(880,3150,210,40734,18563,18,353,1,4257.37,NULL,'2021-05-10 13:43:42','2021-05-10 14:06:06','2021-05-10 14:06:06'),(881,3150,210,40734,18563,18,73,2,36139.25,NULL,'2021-05-10 13:43:42','2021-05-10 14:06:06','2021-05-10 14:06:06'),(882,3150,211,40734,18562,15,73,1,39856.58,NULL,'2021-05-10 13:50:11','2021-05-10 16:21:36','2021-05-10 16:21:36'),(883,3150,211,40734,18562,15,72,2,176.49,NULL,'2021-05-10 13:50:11','2021-05-10 16:21:36','2021-05-10 16:21:36'),(884,3150,211,40734,18562,15,354,2,43925.22,NULL,'2021-05-10 13:50:11','2021-05-10 16:21:36','2021-05-10 16:21:36'),(885,3150,211,40734,18562,15,353,2,4253.76,NULL,'2021-05-10 13:50:11','2021-05-10 16:21:36','2021-05-10 16:21:36'),(886,3150,211,40734,18562,15,79,1,8498.89,NULL,'2021-05-10 13:50:11','2021-05-10 16:21:36','2021-05-10 16:21:36'),(887,3150,212,40734,18563,15,68,2,3.61,NULL,'2021-05-10 14:10:31','2021-05-10 15:49:06','2021-05-10 15:49:06'),(888,3150,212,40734,18563,15,72,2,532.82,NULL,'2021-05-10 14:10:31','2021-05-10 15:49:06','2021-05-10 15:49:06'),(889,3150,212,40734,18563,15,73,1,36139.25,NULL,'2021-05-10 14:10:31','2021-05-10 15:49:06','2021-05-10 15:49:06'),(890,3150,212,40734,18563,15,354,2,31349.06,NULL,'2021-05-10 14:10:31','2021-05-10 15:49:06','2021-05-10 15:49:06'),(891,3150,212,40734,18563,15,353,2,4253.76,NULL,'2021-05-10 14:10:31','2021-05-10 15:49:06','2021-05-10 15:49:06'),(892,3150,213,40734,18563,18,354,1,31881.88,NULL,'2021-05-10 14:12:59','2021-05-10 15:42:01','2021-05-10 15:42:01'),(893,3150,213,40734,18563,18,353,1,4257.37,NULL,'2021-05-10 14:12:59','2021-05-10 15:42:01','2021-05-10 15:42:01'),(894,3150,213,40734,18563,18,73,2,36139.25,NULL,'2021-05-10 14:12:59','2021-05-10 15:42:01','2021-05-10 15:42:01'),(895,3150,214,40734,18556,15,73,1,51277.57,NULL,'2021-05-10 14:42:58','2021-05-10 15:45:34','2021-05-10 15:45:34'),(896,3150,214,40734,18556,15,354,2,46979.48,NULL,'2021-05-10 14:42:58','2021-05-10 15:45:34','2021-05-10 15:45:34'),(897,3150,214,40734,18556,15,353,2,4253.76,NULL,'2021-05-10 14:42:58','2021-05-10 15:45:34','2021-05-10 15:45:34'),(898,3150,214,40734,18556,15,72,2,44.33,NULL,'2021-05-10 14:42:58','2021-05-10 15:45:34','2021-05-10 15:45:34');
INSERT INTO `balance_libro_details` VALUES (899,3150,215,40734,18555,9,73,1,46979.48,NULL,'2021-05-10 15:41:21','2021-05-10 15:41:21',NULL),(900,3150,215,40734,18555,9,72,2,154.95,NULL,'2021-05-10 15:41:21','2021-05-10 15:41:21',NULL),(901,3150,215,40734,18555,9,354,2,46824.53,NULL,'2021-05-10 15:41:21','2021-05-10 15:41:21',NULL),(902,3150,215,40734,18555,9,354,2,24608.36,NULL,'2021-05-10 15:41:21','2021-05-10 15:41:21',NULL),(903,3150,215,40734,18555,9,79,1,24608.36,NULL,'2021-05-10 15:41:21','2021-05-10 15:41:21',NULL),(904,3150,216,40734,18563,18,354,1,46979.48,NULL,'2021-05-10 15:42:01','2021-05-10 15:45:56','2021-05-10 15:45:56'),(905,3150,216,40734,18563,18,73,2,46979.48,NULL,'2021-05-10 15:42:01','2021-05-10 15:45:56','2021-05-10 15:45:56'),(906,3150,217,40734,18556,15,73,1,47023.81,NULL,'2021-05-10 15:45:34','2021-05-10 15:54:38','2021-05-10 15:54:38'),(907,3150,217,40734,18556,15,354,2,46979.48,NULL,'2021-05-10 15:45:34','2021-05-10 15:54:38','2021-05-10 15:54:38'),(908,3150,217,40734,18556,15,72,2,44.33,NULL,'2021-05-10 15:45:34','2021-05-10 15:54:38','2021-05-10 15:54:38'),(909,3150,218,40734,18563,18,354,1,47023.81,NULL,'2021-05-10 15:45:56','2021-05-10 15:48:28','2021-05-10 15:48:28'),(910,3150,218,40734,18563,18,73,2,47023.81,NULL,'2021-05-10 15:45:56','2021-05-10 15:48:28','2021-05-10 15:48:28'),(911,3150,219,40734,18563,18,354,1,31881.88,NULL,'2021-05-10 15:48:28','2021-05-10 16:23:30','2021-05-10 16:23:30'),(912,3150,219,40734,18563,18,73,2,31885.49,NULL,'2021-05-10 15:48:28','2021-05-10 16:23:30','2021-05-10 16:23:30'),(913,3150,219,40734,18563,18,353,1,3.61,NULL,'2021-05-10 15:48:28','2021-05-10 16:23:30','2021-05-10 16:23:30'),(914,3150,220,40734,18563,15,68,2,3.61,NULL,'2021-05-10 15:49:06','2021-05-10 16:22:57','2021-05-10 16:22:57'),(915,3150,220,40734,18563,15,72,2,532.82,NULL,'2021-05-10 15:49:06','2021-05-10 16:22:57','2021-05-10 16:22:57'),(916,3150,220,40734,18563,15,73,1,31885.49,NULL,'2021-05-10 15:49:06','2021-05-10 16:22:57','2021-05-10 16:22:57'),(917,3150,220,40734,18563,15,354,2,31349.06,NULL,'2021-05-10 15:49:06','2021-05-10 16:22:57','2021-05-10 16:22:57'),(918,3150,221,40734,18556,15,73,1,47023.81,NULL,'2021-05-10 15:54:38','2021-05-10 15:54:38',NULL),(919,3150,221,40734,18556,15,354,2,46979.48,NULL,'2021-05-10 15:54:38','2021-05-10 15:54:38',NULL),(920,3150,221,40734,18556,15,72,2,44.33,NULL,'2021-05-10 15:54:38','2021-05-10 15:54:38',NULL),(921,3150,222,40734,18556,18,354,1,47023.81,NULL,'2021-05-10 15:55:21','2021-05-10 15:55:21',NULL),(922,3150,222,40734,18556,18,73,2,47023.81,NULL,'2021-05-10 15:55:21','2021-05-10 15:55:21',NULL),(923,3150,223,40734,18557,15,72,2,160.65,NULL,'2021-05-10 16:07:33','2021-05-10 16:07:33',NULL),(924,3150,223,40734,18557,15,73,1,47184.46,NULL,'2021-05-10 16:07:33','2021-05-10 16:07:33',NULL),(925,3150,223,40734,18557,15,354,2,47023.81,NULL,'2021-05-10 16:07:33','2021-05-10 16:07:33',NULL),(926,3150,224,40734,18557,18,354,1,47184.46,NULL,'2021-05-10 16:08:00','2021-05-10 16:08:00',NULL),(927,3150,224,40734,18557,18,73,2,47184.46,NULL,'2021-05-10 16:08:00','2021-05-10 16:08:00',NULL),(928,3150,225,40734,18558,15,72,2,163.71,NULL,'2021-05-10 16:09:19','2021-05-10 16:09:19',NULL),(929,3150,225,40734,18558,15,73,1,47348.17,NULL,'2021-05-10 16:09:19','2021-05-10 16:09:19',NULL),(930,3150,225,40734,18558,15,354,2,47184.46,NULL,'2021-05-10 16:09:19','2021-05-10 16:09:19',NULL),(931,3150,226,40734,18558,18,354,1,47348.17,NULL,'2021-05-10 16:09:41','2021-05-10 16:09:41',NULL),(932,3150,226,40734,18558,18,73,2,47348.17,NULL,'2021-05-10 16:09:41','2021-05-10 16:09:41',NULL),(933,3150,227,40734,18559,15,73,1,47514.46,NULL,'2021-05-10 16:10:27','2021-05-10 16:10:27',NULL),(934,3150,227,40734,18559,15,72,2,166.29,NULL,'2021-05-10 16:10:27','2021-05-10 16:10:27',NULL),(935,3150,227,40734,18559,15,354,2,47348.17,NULL,'2021-05-10 16:10:27','2021-05-10 16:10:27',NULL),(936,3150,228,40734,18559,18,354,1,47514.46,NULL,'2021-05-10 16:11:39','2021-05-10 16:11:39',NULL);
INSERT INTO `balance_libro_details` VALUES (937,3150,228,40734,18559,18,73,2,47514.46,NULL,'2021-05-10 16:11:39','2021-05-10 16:11:39',NULL),(938,3150,229,40734,18560,15,72,2,482.28,NULL,'2021-05-10 16:14:24','2021-05-10 16:14:24',NULL),(939,3150,229,40734,18560,15,493,1,8498.89,NULL,'2021-05-10 16:14:24','2021-05-10 16:14:24',NULL),(940,3150,229,40734,18560,15,73,1,39497.85,NULL,'2021-05-10 16:14:24','2021-05-10 16:14:24',NULL),(941,3150,229,40734,18560,15,354,2,47514.46,NULL,'2021-05-10 16:14:24','2021-05-10 16:14:24',NULL),(942,3150,230,40734,18560,18,354,1,39497.85,NULL,'2021-05-10 16:15:30','2021-05-10 16:15:30',NULL),(943,3150,230,40734,18560,18,73,2,39497.85,NULL,'2021-05-10 16:15:30','2021-05-10 16:15:30',NULL),(944,3150,231,40734,18561,15,72,2,173.61,NULL,'2021-05-10 16:17:52','2021-05-10 16:17:52',NULL),(945,3150,231,40734,18561,15,73,1,39671.46,NULL,'2021-05-10 16:17:52','2021-05-10 16:17:52',NULL),(946,3150,231,40734,18561,15,354,2,39497.85,NULL,'2021-05-10 16:17:52','2021-05-10 16:17:52',NULL),(947,3150,232,40734,18561,18,354,1,39671.46,NULL,'2021-05-10 16:20:03','2021-05-10 16:20:03',NULL),(948,3150,232,40734,18561,18,73,2,39671.46,NULL,'2021-05-10 16:20:03','2021-05-10 16:20:03',NULL),(949,3150,233,40734,18562,15,73,1,31349.06,NULL,'2021-05-10 16:21:36','2021-05-12 00:47:14','2021-05-12 00:47:14'),(950,3150,233,40734,18562,15,72,2,176.49,NULL,'2021-05-10 16:21:36','2021-05-12 00:47:14','2021-05-12 00:47:14'),(951,3150,233,40734,18562,15,354,2,39671.46,NULL,'2021-05-10 16:21:36','2021-05-12 00:47:14','2021-05-12 00:47:14'),(952,3150,233,40734,18562,15,79,1,8498.89,NULL,'2021-05-10 16:21:36','2021-05-12 00:47:14','2021-05-12 00:47:14'),(953,3150,234,40734,18562,18,354,1,31349.06,NULL,'2021-05-10 16:22:23','2021-05-10 16:22:23',NULL),(954,3150,234,40734,18562,18,73,2,31349.06,NULL,'2021-05-10 16:22:23','2021-05-10 16:22:23',NULL),(955,3150,235,40734,18563,15,68,2,3.61,NULL,'2021-05-10 16:22:57','2021-05-10 16:22:57',NULL),(956,3150,235,40734,18563,15,72,2,532.82,NULL,'2021-05-10 16:22:57','2021-05-10 16:22:57',NULL),(957,3150,235,40734,18563,15,73,1,31885.49,NULL,'2021-05-10 16:22:57','2021-05-10 16:22:57',NULL),(958,3150,235,40734,18563,15,354,2,31349.06,NULL,'2021-05-10 16:22:57','2021-05-10 16:22:57',NULL),(959,3150,236,40734,18563,18,354,1,31881.88,NULL,'2021-05-10 16:23:30','2021-05-10 16:23:30',NULL),(960,3150,236,40734,18563,18,73,2,31885.49,NULL,'2021-05-10 16:23:30','2021-05-10 16:23:30',NULL),(961,3150,236,40734,18563,18,353,1,3.61,NULL,'2021-05-10 16:23:30','2021-05-10 16:23:30',NULL),(962,3150,237,40734,18555,18,354,1,46979.48,NULL,'2021-05-10 16:26:07','2021-05-10 16:26:07',NULL),(963,3150,237,40734,18555,18,73,2,46979.48,NULL,'2021-05-10 16:26:07','2021-05-10 16:26:07',NULL),(964,3150,238,40734,18552,18,354,1,148.35,NULL,'2021-05-10 16:41:11','2021-05-10 16:41:11',NULL),(965,3150,238,40734,18552,18,73,2,148.35,NULL,'2021-05-10 16:41:11','2021-05-10 16:41:11',NULL),(966,3150,239,40734,18554,1,62,1,60000.00,NULL,'2021-05-10 16:54:30','2021-05-10 17:02:09','2021-05-10 17:02:09'),(967,3150,239,40734,18554,1,498,2,33750.00,NULL,'2021-05-10 16:54:30','2021-05-10 17:02:09','2021-05-10 17:02:09'),(968,3150,239,40734,18554,1,359,2,26250.00,NULL,'2021-05-10 16:54:30','2021-05-10 17:02:09','2021-05-10 17:02:09'),(969,3150,240,40734,18554,1,62,1,60000.00,NULL,'2021-05-10 17:02:09','2021-05-10 17:09:19','2021-05-10 17:09:19'),(970,3150,240,40734,18554,1,498,2,33750.00,NULL,'2021-05-10 17:02:09','2021-05-10 17:09:19','2021-05-10 17:09:19'),(971,3150,240,40734,18554,1,359,2,26250.00,NULL,'2021-05-10 17:02:09','2021-05-10 17:09:19','2021-05-10 17:09:19'),(972,3150,241,40734,18555,1,62,1,60000.00,NULL,'2021-05-10 17:09:19','2021-05-10 17:09:19',NULL),(973,3150,241,40734,18555,1,498,2,33750.00,NULL,'2021-05-10 17:09:19','2021-05-10 17:09:19',NULL),(974,3150,241,40734,18555,1,359,2,26250.00,NULL,'2021-05-10 17:09:19','2021-05-10 17:09:19',NULL),(975,3150,242,40734,18556,1,62,1,60000.00,NULL,'2021-05-10 17:11:07','2021-05-10 17:11:07',NULL);
INSERT INTO `balance_libro_details` VALUES (976,3150,242,40734,18556,1,498,2,33750.00,NULL,'2021-05-10 17:11:07','2021-05-10 17:11:07',NULL),(977,3150,242,40734,18556,1,359,2,26250.00,NULL,'2021-05-10 17:11:07','2021-05-10 17:11:07',NULL),(978,3150,243,40734,18557,1,110,1,90000.00,NULL,'2021-05-10 17:11:48','2021-05-10 17:11:48',NULL),(979,3150,243,40734,18557,1,62,2,90000.00,NULL,'2021-05-10 17:11:48','2021-05-10 17:11:48',NULL),(980,3150,243,40734,18557,1,63,2,13753.00,NULL,'2021-05-10 17:11:48','2021-05-10 17:11:48',NULL),(981,3150,243,40734,18557,1,191,1,13753.00,NULL,'2021-05-10 17:11:48','2021-05-10 17:11:48',NULL),(982,3150,244,40734,18557,1,62,1,60000.00,NULL,'2021-05-10 17:14:08','2021-05-10 17:14:08',NULL),(983,3150,244,40734,18557,1,498,2,33750.00,NULL,'2021-05-10 17:14:08','2021-05-10 17:14:08',NULL),(984,3150,244,40734,18557,1,359,2,26250.00,NULL,'2021-05-10 17:14:08','2021-05-10 17:14:08',NULL),(985,3150,245,40734,18558,1,62,1,60000.00,NULL,'2021-05-10 17:16:58','2021-05-11 12:42:31','2021-05-11 12:42:31'),(986,3150,245,40734,18558,1,498,2,33750.00,NULL,'2021-05-10 17:16:58','2021-05-11 12:42:31','2021-05-11 12:42:31'),(987,3150,245,40734,18558,1,119,2,26250.00,NULL,'2021-05-10 17:16:58','2021-05-11 12:42:31','2021-05-11 12:42:31'),(988,3150,246,40734,18560,1,62,1,60000.00,NULL,'2021-05-10 17:17:57','2021-05-10 17:17:57',NULL),(989,3150,246,40734,18560,1,498,2,33750.00,NULL,'2021-05-10 17:17:57','2021-05-10 17:17:57',NULL),(990,3150,246,40734,18560,1,359,2,26250.00,NULL,'2021-05-10 17:17:57','2021-05-10 17:17:57',NULL),(991,3150,247,40734,18552,10,63,1,13753.20,NULL,'2021-05-10 17:24:21','2021-05-10 17:24:21',NULL),(992,3150,247,40734,18552,10,63,1,30.28,NULL,'2021-05-10 17:24:21','2021-05-10 17:24:21',NULL),(993,3150,247,40734,18552,10,63,1,60.56,NULL,'2021-05-10 17:24:21','2021-05-10 17:24:21',NULL),(994,3150,247,40734,18552,10,57,2,13844.04,NULL,'2021-05-10 17:24:21','2021-05-10 17:24:21',NULL),(995,3150,248,40734,18560,10,63,1,9169.20,NULL,'2021-05-10 17:25:47','2021-05-10 17:25:47',NULL),(996,3150,248,40734,18560,10,57,2,9169.20,NULL,'2021-05-10 17:25:47','2021-05-10 17:25:47',NULL),(997,3150,249,40734,18557,10,63,1,9169.20,NULL,'2021-05-10 17:26:36','2021-05-10 17:26:36',NULL),(998,3150,249,40734,18557,10,57,2,9169.20,NULL,'2021-05-10 17:26:36','2021-05-10 17:26:36',NULL),(999,3150,250,40734,18563,10,63,1,9169.20,NULL,'2021-05-10 17:27:02','2021-05-10 17:27:02',NULL),(1000,3150,250,40734,18563,10,57,2,9169.20,NULL,'2021-05-10 17:27:02','2021-05-10 17:27:02',NULL),(1001,3150,251,40734,18561,10,63,1,9169.20,NULL,'2021-05-10 17:27:23','2021-05-10 17:27:23',NULL),(1002,3150,251,40734,18561,10,57,2,9169.20,NULL,'2021-05-10 17:27:23','2021-05-10 17:27:23',NULL),(1003,3150,252,40734,18555,10,63,1,9169.20,NULL,'2021-05-10 17:27:44','2021-05-10 17:27:44',NULL),(1004,3150,252,40734,18555,10,57,2,9169.20,NULL,'2021-05-10 17:27:44','2021-05-10 17:27:44',NULL),(1005,3150,253,40734,18559,1,63,1,9169.20,NULL,'2021-05-10 17:28:46','2021-05-10 17:31:16','2021-05-10 17:31:16'),(1006,3150,253,40734,18559,1,57,2,9169.20,NULL,'2021-05-10 17:28:46','2021-05-10 17:31:16','2021-05-10 17:31:16'),(1007,3150,254,40734,18558,10,63,1,13753.20,NULL,'2021-05-10 17:29:34','2021-05-10 17:29:34',NULL),(1008,3150,254,40734,18558,10,57,2,13753.20,NULL,'2021-05-10 17:29:34','2021-05-10 17:29:34',NULL),(1009,3150,255,40734,18554,10,63,1,9169.20,NULL,'2021-05-10 17:30:14','2021-05-10 17:30:14',NULL),(1010,3150,255,40734,18554,10,57,2,9169.20,NULL,'2021-05-10 17:30:14','2021-05-10 17:30:14',NULL),(1011,3150,256,40734,18553,10,63,1,9169.20,NULL,'2021-05-10 17:30:51','2021-05-10 17:30:51',NULL),(1012,3150,256,40734,18553,10,57,2,9169.20,NULL,'2021-05-10 17:30:51','2021-05-10 17:30:51',NULL),(1013,3150,257,40734,18559,9,63,1,9169.20,NULL,'2021-05-10 17:31:16','2021-05-10 17:31:16',NULL),(1014,3150,257,40734,18559,9,57,2,9169.20,NULL,'2021-05-10 17:31:16','2021-05-10 17:31:16',NULL),(1015,3150,258,40734,18563,19,103,2,2248.58,NULL,'2021-05-10 17:50:25','2021-05-10 17:50:25',NULL);
INSERT INTO `balance_libro_details` VALUES (1016,3150,258,40734,18563,19,499,1,2248.58,NULL,'2021-05-10 17:50:25','2021-05-10 17:50:25',NULL),(1017,3150,259,40734,18563,5,396,1,7590.79,NULL,'2021-05-10 18:02:35','2021-05-10 18:07:14','2021-05-10 18:07:14'),(1018,3150,259,40734,18563,5,492,1,1544.22,NULL,'2021-05-10 18:02:35','2021-05-10 18:07:14','2021-05-10 18:07:14'),(1019,3150,259,40734,18563,5,252,1,1600.00,NULL,'2021-05-10 18:02:35','2021-05-10 18:07:14','2021-05-10 18:07:14'),(1020,3150,259,40734,18563,5,255,1,960.00,NULL,'2021-05-10 18:02:35','2021-05-10 18:07:14','2021-05-10 18:07:14'),(1021,3150,259,40734,18563,5,57,1,142535.60,NULL,'2021-05-10 18:02:35','2021-05-10 18:07:14','2021-05-10 18:07:14'),(1022,3150,259,40734,18563,5,368,2,80000.00,NULL,'2021-05-10 18:02:35','2021-05-10 18:07:14','2021-05-10 18:07:14'),(1023,3150,259,40734,18563,5,395,2,80000.00,NULL,'2021-05-10 18:02:35','2021-05-10 18:07:14','2021-05-10 18:07:14'),(1024,3150,259,40734,18563,5,164,1,5769.39,NULL,'2021-05-10 18:02:35','2021-05-10 18:07:14','2021-05-10 18:07:14'),(1025,3150,260,40734,18563,5,396,1,7590.79,NULL,'2021-05-10 18:07:14','2021-05-10 18:15:05','2021-05-10 18:15:05'),(1026,3150,260,40734,18563,5,492,1,1544.22,NULL,'2021-05-10 18:07:14','2021-05-10 18:15:05','2021-05-10 18:15:05'),(1027,3150,260,40734,18563,5,252,1,1600.00,NULL,'2021-05-10 18:07:14','2021-05-10 18:15:05','2021-05-10 18:15:05'),(1028,3150,260,40734,18563,5,255,1,960.00,NULL,'2021-05-10 18:07:14','2021-05-10 18:15:05','2021-05-10 18:15:05'),(1029,3150,260,40734,18563,5,57,1,142535.60,NULL,'2021-05-10 18:07:14','2021-05-10 18:15:05','2021-05-10 18:15:05'),(1030,3150,260,40734,18563,5,368,2,80000.00,NULL,'2021-05-10 18:07:14','2021-05-10 18:15:05','2021-05-10 18:15:05'),(1031,3150,260,40734,18563,5,395,2,80000.00,NULL,'2021-05-10 18:07:14','2021-05-10 18:15:05','2021-05-10 18:15:05'),(1032,3150,260,40734,18563,5,164,1,5769.39,NULL,'2021-05-10 18:07:14','2021-05-10 18:15:05','2021-05-10 18:15:05'),(1033,3150,261,40734,18563,5,396,1,7270.79,NULL,'2021-05-10 18:15:05','2021-05-10 18:20:08','2021-05-10 18:20:08'),(1034,3150,261,40734,18563,5,492,1,1544.22,NULL,'2021-05-10 18:15:05','2021-05-10 18:20:08','2021-05-10 18:20:08'),(1035,3150,261,40734,18563,5,252,1,1600.00,NULL,'2021-05-10 18:15:05','2021-05-10 18:20:08','2021-05-10 18:20:08'),(1036,3150,261,40734,18563,5,255,1,960.00,NULL,'2021-05-10 18:15:05','2021-05-10 18:20:08','2021-05-10 18:20:08'),(1037,3150,261,40734,18563,5,57,1,142535.60,NULL,'2021-05-10 18:15:05','2021-05-10 18:20:08','2021-05-10 18:20:08'),(1038,3150,261,40734,18563,5,368,2,80000.00,NULL,'2021-05-10 18:15:05','2021-05-10 18:20:08','2021-05-10 18:20:08'),(1039,3150,261,40734,18563,5,395,2,80000.00,NULL,'2021-05-10 18:15:05','2021-05-10 18:20:08','2021-05-10 18:20:08'),(1040,3150,261,40734,18563,5,164,1,6089.39,NULL,'2021-05-10 18:15:05','2021-05-10 18:20:08','2021-05-10 18:20:08'),(1041,3150,262,40734,18563,5,396,1,7270.79,NULL,'2021-05-10 18:20:08','2021-05-10 18:32:15','2021-05-10 18:32:15'),(1042,3150,262,40734,18563,5,492,1,1544.22,NULL,'2021-05-10 18:20:08','2021-05-10 18:32:15','2021-05-10 18:32:15'),(1043,3150,262,40734,18563,5,252,1,1600.00,NULL,'2021-05-10 18:20:08','2021-05-10 18:32:15','2021-05-10 18:32:15'),(1044,3150,262,40734,18563,5,255,1,960.00,NULL,'2021-05-10 18:20:08','2021-05-10 18:32:15','2021-05-10 18:32:15'),(1045,3150,262,40734,18563,5,57,1,142535.60,NULL,'2021-05-10 18:20:08','2021-05-10 18:32:15','2021-05-10 18:32:15'),(1046,3150,262,40734,18563,5,368,2,80000.00,NULL,'2021-05-10 18:20:08','2021-05-10 18:32:15','2021-05-10 18:32:15'),(1047,3150,262,40734,18563,5,395,2,80000.00,NULL,'2021-05-10 18:20:08','2021-05-10 18:32:15','2021-05-10 18:32:15'),(1048,3150,262,40734,18563,5,164,1,6089.39,NULL,'2021-05-10 18:20:08','2021-05-10 18:32:15','2021-05-10 18:32:15'),(1049,3150,263,40734,18563,5,396,1,7270.79,NULL,'2021-05-10 18:32:15','2021-05-10 18:32:15',NULL),(1050,3150,263,40734,18563,5,492,1,1544.22,NULL,'2021-05-10 18:32:15','2021-05-10 18:32:15',NULL);
INSERT INTO `balance_libro_details` VALUES (1051,3150,263,40734,18563,5,252,1,1600.00,NULL,'2021-05-10 18:32:15','2021-05-10 18:32:15',NULL),(1052,3150,263,40734,18563,5,255,1,960.00,NULL,'2021-05-10 18:32:15','2021-05-10 18:32:15',NULL),(1053,3150,263,40734,18563,5,57,1,142535.60,NULL,'2021-05-10 18:32:15','2021-05-10 18:32:15',NULL),(1054,3150,263,40734,18563,5,368,2,80000.00,NULL,'2021-05-10 18:32:15','2021-05-10 18:32:15',NULL),(1055,3150,263,40734,18563,5,395,2,80000.00,NULL,'2021-05-10 18:32:15','2021-05-10 18:32:15',NULL),(1056,3150,263,40734,18563,5,164,1,6089.39,NULL,'2021-05-10 18:32:15','2021-05-10 18:32:15',NULL),(1057,3150,264,40734,18554,5,396,1,6446.67,NULL,'2021-05-10 18:59:35','2021-05-10 18:59:35',NULL),(1058,3150,264,40734,18554,5,492,1,3393.26,NULL,'2021-05-10 18:59:35','2021-05-10 18:59:35',NULL),(1059,3150,264,40734,18554,5,164,1,268663.69,NULL,'2021-05-10 18:59:35','2021-05-10 18:59:35',NULL),(1060,3150,264,40734,18554,5,455,2,431298.80,NULL,'2021-05-10 18:59:35','2021-05-10 18:59:35',NULL),(1061,3150,264,40734,18554,5,251,1,8155.86,NULL,'2021-05-10 18:59:35','2021-05-10 18:59:35',NULL),(1062,3150,264,40734,18554,5,255,1,470.12,NULL,'2021-05-10 18:59:35','2021-05-10 18:59:35',NULL),(1063,3150,264,40734,18554,5,57,1,144169.20,NULL,'2021-05-10 18:59:35','2021-05-10 18:59:35',NULL),(1064,3150,265,40735,20094,19,359,1,49937.74,NULL,'2021-05-10 20:47:05','2021-05-11 17:27:02','2021-05-11 17:27:02'),(1065,3150,265,40735,20094,19,425,1,10887.00,NULL,'2021-05-10 20:47:05','2021-05-11 17:27:02','2021-05-11 17:27:02'),(1066,3150,265,40735,20094,19,27,1,200.00,NULL,'2021-05-10 20:47:05','2021-05-11 17:27:02','2021-05-11 17:27:02'),(1067,3150,265,40735,20094,19,492,1,70.29,NULL,'2021-05-10 20:47:05','2021-05-11 17:27:02','2021-05-11 17:27:02'),(1068,3150,265,40735,20094,19,369,2,70000.00,NULL,'2021-05-10 20:47:05','2021-05-11 17:27:02','2021-05-11 17:27:02'),(1069,3150,265,40735,20094,19,88,2,60103.80,NULL,'2021-05-10 20:47:05','2021-05-11 17:27:02','2021-05-11 17:27:02'),(1070,3150,265,40735,20094,19,500,2,6000.00,NULL,'2021-05-10 20:47:05','2021-05-11 17:27:02','2021-05-11 17:27:02'),(1071,3150,265,40735,20094,19,92,1,75008.77,NULL,'2021-05-10 20:47:05','2021-05-11 17:27:02','2021-05-11 17:27:02'),(1072,3150,266,40734,18553,19,368,1,55000.00,NULL,'2021-05-11 11:56:52','2021-05-11 11:56:52',NULL),(1073,3150,266,40734,18553,19,57,2,55000.00,NULL,'2021-05-11 11:56:52','2021-05-11 11:56:52',NULL),(1074,3150,267,40734,18552,1,62,1,60000.00,NULL,'2021-05-11 11:59:33','2021-05-11 12:01:56','2021-05-11 12:01:56'),(1075,3150,267,40734,18552,1,368,2,30000.00,NULL,'2021-05-11 11:59:33','2021-05-11 12:01:56','2021-05-11 12:01:56'),(1076,3150,267,40734,18552,1,395,2,30000.00,NULL,'2021-05-11 11:59:33','2021-05-11 12:01:56','2021-05-11 12:01:56'),(1077,3150,268,40734,18553,1,62,1,60000.00,NULL,'2021-05-11 12:01:23','2021-05-11 12:33:48','2021-05-11 12:33:48'),(1078,3150,268,40734,18553,1,368,2,30000.00,NULL,'2021-05-11 12:01:23','2021-05-11 12:33:48','2021-05-11 12:33:48'),(1079,3150,268,40734,18553,1,395,2,30000.00,NULL,'2021-05-11 12:01:23','2021-05-11 12:33:48','2021-05-11 12:33:48'),(1080,3150,269,40734,18552,1,62,1,90000.00,NULL,'2021-05-11 12:01:56','2021-05-11 12:31:39','2021-05-11 12:31:39'),(1081,3150,269,40734,18552,1,368,2,45000.00,NULL,'2021-05-11 12:01:56','2021-05-11 12:31:39','2021-05-11 12:31:39'),(1082,3150,269,40734,18552,1,395,2,45000.00,NULL,'2021-05-11 12:01:56','2021-05-11 12:31:39','2021-05-11 12:31:39'),(1083,3150,270,40734,18554,1,62,1,60000.00,NULL,'2021-05-11 12:03:09','2021-05-11 12:34:19','2021-05-11 12:34:19'),(1084,3150,270,40734,18554,1,368,2,30000.00,NULL,'2021-05-11 12:03:09','2021-05-11 12:34:19','2021-05-11 12:34:19'),(1085,3150,270,40734,18554,1,395,2,30000.00,NULL,'2021-05-11 12:03:09','2021-05-11 12:34:19','2021-05-11 12:34:19'),(1086,3150,271,40734,18555,1,62,1,60000.00,NULL,'2021-05-11 12:04:04','2021-05-11 12:34:45','2021-05-11 12:34:45');
INSERT INTO `balance_libro_details` VALUES (1087,3150,271,40734,18555,1,368,2,30000.00,NULL,'2021-05-11 12:04:04','2021-05-11 12:34:45','2021-05-11 12:34:45'),(1088,3150,271,40734,18555,1,395,2,30000.00,NULL,'2021-05-11 12:04:04','2021-05-11 12:34:45','2021-05-11 12:34:45'),(1089,3150,272,40734,18556,1,62,1,60000.00,NULL,'2021-05-11 12:05:13','2021-05-11 12:35:12','2021-05-11 12:35:12'),(1090,3150,272,40734,18556,1,368,2,30000.00,NULL,'2021-05-11 12:05:13','2021-05-11 12:35:12','2021-05-11 12:35:12'),(1091,3150,272,40734,18556,1,395,2,30000.00,NULL,'2021-05-11 12:05:13','2021-05-11 12:35:12','2021-05-11 12:35:12'),(1092,3150,273,40734,18557,1,62,1,60000.00,NULL,'2021-05-11 12:06:13','2021-05-11 12:35:27','2021-05-11 12:35:27'),(1093,3150,273,40734,18557,1,368,2,30000.00,NULL,'2021-05-11 12:06:13','2021-05-11 12:35:27','2021-05-11 12:35:27'),(1094,3150,273,40734,18557,1,395,2,30000.00,NULL,'2021-05-11 12:06:13','2021-05-11 12:35:27','2021-05-11 12:35:27'),(1095,3150,274,40734,18558,1,62,1,90000.00,NULL,'2021-05-11 12:07:02','2021-05-11 12:46:04','2021-05-11 12:46:04'),(1096,3150,274,40734,18558,1,368,2,45000.00,NULL,'2021-05-11 12:07:02','2021-05-11 12:46:04','2021-05-11 12:46:04'),(1097,3150,274,40734,18558,1,395,2,45000.00,NULL,'2021-05-11 12:07:02','2021-05-11 12:46:04','2021-05-11 12:46:04'),(1098,3150,275,40734,18559,1,62,1,60000.00,NULL,'2021-05-11 12:08:05','2021-05-11 12:08:05',NULL),(1099,3150,275,40734,18559,1,368,2,30000.00,NULL,'2021-05-11 12:08:05','2021-05-11 12:08:05',NULL),(1100,3150,275,40734,18559,1,395,2,30000.00,NULL,'2021-05-11 12:08:05','2021-05-11 12:08:05',NULL),(1101,3150,276,40734,18560,1,62,1,60000.00,NULL,'2021-05-11 12:08:53','2021-05-11 12:45:27','2021-05-11 12:45:27'),(1102,3150,276,40734,18560,1,368,2,30000.00,NULL,'2021-05-11 12:08:53','2021-05-11 12:45:27','2021-05-11 12:45:27'),(1103,3150,276,40734,18560,1,395,2,30000.00,NULL,'2021-05-11 12:08:53','2021-05-11 12:45:27','2021-05-11 12:45:27'),(1104,3150,277,40734,18561,1,62,1,60000.00,NULL,'2021-05-11 12:09:45','2021-05-11 12:46:57','2021-05-11 12:46:57'),(1105,3150,277,40734,18561,1,368,2,30000.00,NULL,'2021-05-11 12:09:45','2021-05-11 12:46:57','2021-05-11 12:46:57'),(1106,3150,277,40734,18561,1,395,2,30000.00,NULL,'2021-05-11 12:09:45','2021-05-11 12:46:57','2021-05-11 12:46:57'),(1107,3150,278,40734,18562,1,62,1,60000.00,NULL,'2021-05-11 12:10:30','2021-05-11 12:49:32','2021-05-11 12:49:32'),(1108,3150,278,40734,18562,1,368,2,30000.00,NULL,'2021-05-11 12:10:30','2021-05-11 12:49:32','2021-05-11 12:49:32'),(1109,3150,278,40734,18562,1,395,2,30000.00,NULL,'2021-05-11 12:10:30','2021-05-11 12:49:32','2021-05-11 12:49:32'),(1110,3150,279,40734,18558,1,62,1,90000.00,NULL,'2021-05-11 12:42:31','2021-05-24 23:52:34','2021-05-24 23:52:34'),(1111,3150,279,40734,18558,1,498,2,33750.00,NULL,'2021-05-11 12:42:31','2021-05-24 23:52:34','2021-05-24 23:52:34'),(1112,3150,279,40734,18558,1,119,2,56250.00,NULL,'2021-05-11 12:42:31','2021-05-24 23:52:34','2021-05-24 23:52:34'),(1113,3150,280,40734,18556,1,110,1,60000.00,NULL,'2021-05-11 12:51:16','2021-05-11 12:51:16',NULL),(1114,3150,280,40734,18556,1,191,1,9169.20,NULL,'2021-05-11 12:51:16','2021-05-11 12:51:16',NULL),(1115,3150,280,40734,18556,1,63,2,9169.20,NULL,'2021-05-11 12:51:16','2021-05-11 12:51:16',NULL),(1116,3150,280,40734,18556,1,62,2,60000.00,NULL,'2021-05-11 12:51:16','2021-05-11 12:51:16',NULL),(1117,3150,281,40735,20094,19,359,1,49937.74,NULL,'2021-05-11 17:27:02','2021-05-11 17:27:02',NULL),(1118,3150,281,40735,20094,19,425,1,10887.00,NULL,'2021-05-11 17:27:02','2021-05-11 17:27:02',NULL),(1119,3150,281,40735,20094,19,27,1,200.00,NULL,'2021-05-11 17:27:02','2021-05-11 17:27:02',NULL),(1120,3150,281,40735,20094,19,492,1,70.29,NULL,'2021-05-11 17:27:02','2021-05-11 17:27:02',NULL),(1121,3150,281,40735,20094,19,369,2,70000.00,NULL,'2021-05-11 17:27:02','2021-05-11 17:27:02',NULL),(1122,3150,281,40735,20094,19,88,2,60103.80,NULL,'2021-05-11 17:27:02','2021-05-11 17:27:02',NULL);
INSERT INTO `balance_libro_details` VALUES (1123,3150,281,40735,20094,19,500,2,6000.00,NULL,'2021-05-11 17:27:02','2021-05-11 17:27:02',NULL),(1124,3150,281,40735,20094,19,92,1,75008.77,NULL,'2021-05-11 17:27:02','2021-05-11 17:27:02',NULL),(1125,3150,282,40735,20094,2,425,1,3400.00,NULL,'2021-05-11 18:44:32','2021-05-11 18:45:16','2021-05-11 18:45:16'),(1126,3150,282,40735,20094,2,501,2,3400.00,NULL,'2021-05-11 18:44:32','2021-05-11 18:45:16','2021-05-11 18:45:16'),(1127,3150,283,40735,20094,2,425,1,3400.00,NULL,'2021-05-11 18:45:16','2021-05-11 18:46:52','2021-05-11 18:46:52'),(1128,3150,283,40735,20094,2,501,2,3400.00,NULL,'2021-05-11 18:45:16','2021-05-11 18:46:52','2021-05-11 18:46:52'),(1129,3150,284,40735,20094,2,425,1,3400.00,NULL,'2021-05-11 18:46:52','2021-05-11 20:56:34','2021-05-11 20:56:34'),(1130,3150,284,40735,20094,2,501,2,3400.00,NULL,'2021-05-11 18:46:52','2021-05-11 20:56:34','2021-05-11 20:56:34'),(1147,3150,292,40735,20094,2,425,1,3400.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1148,3150,292,40735,20094,2,501,2,3400.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1149,3150,293,40735,20094,21,500,1,6000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1150,3150,293,40735,20094,21,359,2,6000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1151,3150,294,40735,20094,3,502,1,5000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:23:11','2021-05-11 21:23:11'),(1152,3150,294,40735,20094,3,425,2,5000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:23:11','2021-05-11 21:23:11'),(1153,3150,295,40735,20094,5,157,1,17.84,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1154,3150,295,40735,20094,5,492,1,8.79,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1155,3150,295,40735,20094,5,425,2,26.63,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1156,3150,296,40735,20094,5,396,1,1038.25,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1157,3150,296,40735,20094,5,425,2,1038.25,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1158,3150,297,40735,20095,2,425,1,1000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1159,3150,297,40735,20095,2,501,2,1000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1160,3150,298,40735,20095,3,502,1,5000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1161,3150,298,40735,20095,3,425,2,5000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1162,3150,299,40735,20095,5,157,1,31.09,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1163,3150,299,40735,20095,5,492,1,15.31,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1164,3150,299,40735,20095,5,425,2,46.40,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1165,3150,300,40735,20095,5,396,1,1733.93,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1166,3150,300,40735,20095,5,425,2,1733.93,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1167,3150,301,40735,20096,2,425,1,6000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1168,3150,301,40735,20096,2,501,2,6000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1169,3150,302,40735,20096,3,502,1,5000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1170,3150,302,40735,20096,3,425,2,5000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1171,3150,303,40735,20096,5,157,1,51.03,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1172,3150,303,40735,20096,5,492,1,25.13,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1173,3150,303,40735,20096,5,425,2,76.16,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1174,3150,304,40735,20096,5,396,1,1694.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1175,3150,304,40735,20096,5,425,2,1694.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1176,3150,305,40735,20097,2,425,1,500.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1177,3150,305,40735,20097,2,501,2,500.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL);
INSERT INTO `balance_libro_details` VALUES (1178,3150,306,40735,20097,3,502,1,4000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1179,3150,306,40735,20097,3,425,2,4000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1180,3150,307,40735,20097,5,157,1,56.26,NULL,'2021-05-11 21:04:52','2021-05-11 21:37:30','2021-05-11 21:37:30'),(1181,3150,307,40735,20097,5,492,1,4.51,NULL,'2021-05-11 21:04:52','2021-05-11 21:37:30','2021-05-11 21:37:30'),(1182,3150,307,40735,20097,5,425,2,60.77,NULL,'2021-05-11 21:04:52','2021-05-11 21:37:30','2021-05-11 21:37:30'),(1183,3150,308,40735,20097,5,396,1,2202.20,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1184,3150,308,40735,20097,5,425,2,2202.20,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1185,3150,309,40735,20097,5,425,1,4426.25,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1186,3150,309,40735,20097,5,396,2,4426.25,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1187,3150,310,40735,20097,3,502,1,1000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1188,3150,310,40735,20097,3,359,2,1000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1189,3150,311,40735,20098,2,425,1,5500.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1190,3150,311,40735,20098,2,501,2,5500.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1191,3150,312,40735,20098,3,502,1,5000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1192,3150,312,40735,20098,3,425,2,5000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1193,3150,313,40735,20098,5,157,1,56.26,NULL,'2021-05-11 21:04:52','2021-05-11 21:42:33','2021-05-11 21:42:33'),(1194,3150,313,40735,20098,5,492,1,4.51,NULL,'2021-05-11 21:04:52','2021-05-11 21:42:33','2021-05-11 21:42:33'),(1195,3150,313,40735,20098,5,425,2,60.77,NULL,'2021-05-11 21:04:52','2021-05-11 21:42:33','2021-05-11 21:42:33'),(1196,3150,314,40735,20098,5,396,1,2202.20,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1197,3150,314,40735,20098,5,425,2,2202.20,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1198,3150,315,40735,20098,3,135,1,800.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1199,3150,315,40735,20098,3,359,2,800.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1200,3150,316,40735,20099,2,425,1,17000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1201,3150,316,40735,20099,2,501,2,17000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1202,3150,317,40735,20099,3,502,1,5000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1203,3150,317,40735,20099,3,425,2,5000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1204,3150,318,40735,20099,5,157,1,97.29,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1205,3150,318,40735,20099,5,492,1,47.92,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1206,3150,318,40735,20099,5,425,2,145.21,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1207,3150,319,40735,20099,5,396,1,2202.20,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1208,3150,319,40735,20099,5,425,2,2202.20,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1209,3150,320,40735,20100,2,425,1,1000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1210,3150,320,40735,20100,2,501,2,1000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1211,3150,321,40735,20100,5,157,1,12.87,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1212,3150,321,40735,20100,5,492,1,6.34,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1213,3150,321,40735,20100,5,425,2,19.21,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1214,3150,322,40735,20100,5,396,1,2202.20,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1215,3150,322,40735,20100,5,425,2,2202.20,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1216,3150,323,40735,20101,2,425,1,1500.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1217,3150,323,40735,20101,2,501,2,1500.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL);
INSERT INTO `balance_libro_details` VALUES (1218,3150,324,40735,20101,5,396,1,2202.20,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1219,3150,324,40735,20101,5,425,2,2202.20,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1220,3150,325,40735,20101,5,157,1,24.58,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1221,3150,325,40735,20101,5,492,1,12.11,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1222,3150,325,40735,20101,5,425,2,36.69,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1223,3150,326,40735,20101,5,425,1,2413.59,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1224,3150,326,40735,20101,5,396,2,2413.59,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1225,3150,327,40735,20102,2,425,1,5500.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1226,3150,327,40735,20102,2,501,2,5500.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1227,3150,328,40735,20102,5,396,1,2202.20,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1228,3150,328,40735,20102,5,425,2,2202.20,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1229,3150,329,40735,20102,5,157,1,19.26,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1230,3150,329,40735,20102,5,425,2,19.26,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1231,3150,330,40735,20103,2,425,1,1500.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1232,3150,330,40735,20103,2,501,2,1500.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1233,3150,331,40735,20103,3,502,1,3000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1234,3150,331,40735,20103,3,359,2,3000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1235,3150,332,40735,20103,5,396,1,2202.20,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1236,3150,332,40735,20103,5,425,2,2202.20,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1237,3150,333,40735,20103,5,157,1,9.26,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1238,3150,333,40735,20103,5,425,2,9.26,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1239,3150,334,40735,20104,2,425,1,5500.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1240,3150,334,40735,20104,2,501,2,5500.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1241,3150,335,40735,20104,3,502,1,3000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1242,3150,335,40735,20104,3,425,2,3000.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1243,3150,336,40735,20104,5,157,1,21.25,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1244,3150,336,40735,20104,5,425,2,21.25,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1245,3150,337,40735,20105,2,425,1,1500.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1246,3150,337,40735,20105,2,501,2,1500.00,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1247,3150,338,40735,20105,5,157,1,3.75,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1248,3150,338,40735,20105,5,425,2,3.75,NULL,'2021-05-11 21:04:52','2021-05-11 21:04:52',NULL),(1249,3150,339,40735,20094,3,128,1,5000.00,NULL,'2021-05-11 21:20:20','2021-05-11 21:47:47','2021-05-11 21:47:47'),(1250,3150,339,40735,20094,3,359,2,5000.00,NULL,'2021-05-11 21:20:20','2021-05-11 21:47:47','2021-05-11 21:47:47'),(1251,3150,340,40735,20097,5,157,1,9.14,NULL,'2021-05-11 21:37:30','2021-05-11 21:37:30',NULL),(1252,3150,340,40735,20097,5,492,1,4.51,NULL,'2021-05-11 21:37:30','2021-05-11 21:37:30',NULL),(1253,3150,340,40735,20097,5,425,2,13.65,NULL,'2021-05-11 21:37:30','2021-05-11 21:37:30',NULL),(1254,3150,341,40735,20098,5,157,1,71.70,NULL,'2021-05-11 21:42:33','2021-05-11 21:42:33',NULL),(1255,3150,341,40735,20098,5,492,1,4.51,NULL,'2021-05-11 21:42:33','2021-05-11 21:42:33',NULL),(1256,3150,341,40735,20098,5,425,2,76.21,NULL,'2021-05-11 21:42:33','2021-05-11 21:42:33',NULL),(1257,3150,342,40735,20094,3,359,2,5000.00,NULL,'2021-05-11 21:47:47','2021-05-11 21:47:47',NULL);
INSERT INTO `balance_libro_details` VALUES (1258,3150,342,40735,20094,3,502,1,5000.00,NULL,'2021-05-11 21:47:47','2021-05-11 21:47:47',NULL),(1259,3150,343,40735,20094,2,27,2,200.00,NULL,'2021-05-11 22:02:36','2021-05-11 22:02:36',NULL),(1260,3150,343,40735,20094,2,359,1,200.00,NULL,'2021-05-11 22:02:36','2021-05-11 22:02:36',NULL),(1261,3150,344,40735,20094,23,396,1,344.09,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1262,3150,344,40735,20094,23,476,2,344.09,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1263,3150,345,40735,20094,23,157,1,5.91,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1264,3150,345,40735,20094,23,476,2,5.91,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1265,3150,346,40735,20094,23,502,1,1657.05,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1266,3150,346,40735,20094,23,476,2,1657.05,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1267,3150,347,40735,20094,23,501,2,1126.80,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1268,3150,347,40735,20094,23,476,1,1126.80,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1269,3150,348,40735,20095,23,157,1,9.49,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1270,3150,348,40735,20095,23,476,2,9.49,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1271,3150,349,40735,20095,23,501,2,305.13,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1272,3150,349,40735,20095,23,476,1,305.13,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1273,3150,350,40735,20095,23,502,1,1525.65,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1274,3150,350,40735,20095,23,476,2,1525.65,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1275,3150,351,40735,20095,23,396,1,529.07,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1276,3150,351,40735,20095,23,476,2,529.07,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1277,3150,352,40735,20096,23,502,1,1314.53,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1278,3150,352,40735,20096,23,476,2,1314.53,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1279,3150,353,40735,20096,23,396,1,445.36,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1280,3150,353,40735,20096,23,476,2,445.36,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1281,3150,354,40735,20096,23,157,1,13.42,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1282,3150,354,40735,20096,23,476,2,13.42,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1283,3150,355,40735,20096,23,501,2,1577.43,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1284,3150,355,40735,20096,23,476,1,1577.43,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1285,3150,356,40735,20097,23,157,1,2.23,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1286,3150,356,40735,20097,23,476,2,2.23,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1287,3150,357,40735,20097,23,501,2,122.14,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1288,3150,357,40735,20097,23,476,1,122.14,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1289,3150,358,40735,20097,23,502,1,1221.42,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1290,3150,358,40735,20097,23,476,2,1221.42,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1291,3150,359,40735,20097,23,396,2,543.30,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1292,3150,359,40735,20097,23,476,1,543.30,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1293,3150,360,40735,20098,23,396,1,496.33,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1294,3150,360,40735,20098,23,476,2,496.33,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1295,3150,361,40735,20098,23,135,1,180.30,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1296,3150,361,40735,20098,23,476,2,180.30,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1297,3150,362,40735,20098,23,157,1,16.16,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL);
INSERT INTO `balance_libro_details` VALUES (1298,3150,362,40735,20098,23,476,2,16.16,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1299,3150,363,40735,20098,23,501,2,1239.59,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1300,3150,363,40735,20098,23,476,1,1239.59,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1301,3150,364,40735,20098,23,502,1,1126.90,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1302,3150,364,40735,20098,23,476,2,1126.90,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1303,3150,365,40735,20099,23,157,1,19.31,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1304,3150,365,40735,20099,23,476,2,19.31,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1305,3150,366,40735,20099,23,501,2,3374.34,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1306,3150,366,40735,20099,23,476,1,3374.34,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1307,3150,367,40735,20099,23,502,1,992.45,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1308,3150,367,40735,20099,23,476,2,992.45,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1309,3150,368,40735,20099,23,396,1,437.12,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1310,3150,368,40735,20099,23,476,2,437.12,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1311,3150,369,40735,20100,23,396,1,387.04,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1312,3150,369,40735,20100,23,476,2,387.04,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1313,3150,370,40735,20100,23,157,1,2.26,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1314,3150,370,40735,20100,23,476,2,2.26,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1315,3150,371,40735,20100,23,501,2,175.75,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1316,3150,371,40735,20100,23,476,1,175.75,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1317,3150,372,40735,20101,23,501,2,217.26,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1318,3150,372,40735,20101,23,476,1,217.26,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1319,3150,373,40735,20101,23,396,2,30.62,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1320,3150,373,40735,20101,23,476,1,30.62,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1321,3150,374,40735,20101,23,157,1,3.56,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1322,3150,374,40735,20101,23,476,2,3.56,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1323,3150,375,40735,20102,23,157,1,2.18,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1324,3150,375,40735,20102,23,476,2,2.18,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1325,3150,376,40735,20102,23,501,2,622.99,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1326,3150,376,40735,20102,23,476,1,622.99,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1327,3150,377,40735,20102,23,396,1,249.44,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1328,3150,377,40735,20102,23,476,2,249.44,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1329,3150,378,40735,20103,23,501,2,109.38,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1330,3150,378,40735,20103,23,476,1,109.38,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1331,3150,379,40735,20103,23,396,1,160.58,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1332,3150,379,40735,20103,23,476,2,160.58,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1333,3150,380,40735,20103,23,157,1,0.68,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1334,3150,380,40735,20103,23,476,2,0.68,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1335,3150,381,40735,20103,23,502,1,218.76,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1336,3150,381,40735,20103,23,476,2,218.76,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1337,3150,382,40735,20104,23,157,1,0.85,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1338,3150,382,40735,20104,23,476,2,0.85,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL);
INSERT INTO `balance_libro_details` VALUES (1339,3150,383,40735,20104,23,502,1,120.17,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1340,3150,383,40735,20104,23,476,2,120.17,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1341,3150,384,40735,20104,23,501,2,220.31,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1342,3150,384,40735,20104,23,476,1,220.31,NULL,'2021-05-11 22:17:24','2021-05-11 22:17:24',NULL),(1343,3150,385,40734,18552,12,91,1,2875246.27,NULL,'2021-05-11 22:19:01','2021-05-11 23:22:06','2021-05-11 23:22:06'),(1344,3150,385,40734,18552,12,359,1,752412.45,NULL,'2021-05-11 22:19:01','2021-05-11 23:22:06','2021-05-11 23:22:06'),(1345,3150,385,40734,18552,12,384,1,1160000.00,NULL,'2021-05-11 22:19:01','2021-05-11 23:22:06','2021-05-11 23:22:06'),(1346,3150,385,40734,18552,12,164,1,671246.45,NULL,'2021-05-11 22:19:01','2021-05-11 23:22:06','2021-05-11 23:22:06'),(1347,3150,385,40734,18552,12,499,1,5396.57,NULL,'2021-05-11 22:19:01','2021-05-11 23:22:06','2021-05-11 23:22:06'),(1348,3150,385,40734,18552,12,13,1,170162.60,NULL,'2021-05-11 22:19:01','2021-05-11 23:22:06','2021-05-11 23:22:06'),(1349,3150,385,40734,18552,12,354,1,40091.97,NULL,'2021-05-11 22:19:01','2021-05-11 23:22:06','2021-05-11 23:22:06'),(1350,3150,385,40734,18552,12,23,1,16474.86,NULL,'2021-05-11 22:19:01','2021-05-11 23:22:06','2021-05-11 23:22:06'),(1351,3150,385,40734,18552,12,24,1,139477.26,NULL,'2021-05-11 22:19:01','2021-05-11 23:22:06','2021-05-11 23:22:06'),(1352,3150,385,40734,18552,12,492,1,8644.37,NULL,'2021-05-11 22:19:01','2021-05-11 23:22:06','2021-05-11 23:22:06'),(1353,3150,385,40734,18552,12,425,2,5839152.80,NULL,'2021-05-11 22:19:01','2021-05-11 23:22:06','2021-05-11 23:22:06'),(1354,3150,386,40734,18552,12,91,1,2875246.27,NULL,'2021-05-11 22:19:01','2021-05-11 22:21:19','2021-05-11 22:21:19'),(1355,3150,386,40734,18552,12,359,1,752412.45,NULL,'2021-05-11 22:19:01','2021-05-11 22:21:19','2021-05-11 22:21:19'),(1356,3150,386,40734,18552,12,384,1,1160000.00,NULL,'2021-05-11 22:19:01','2021-05-11 22:21:19','2021-05-11 22:21:19'),(1357,3150,386,40734,18552,12,164,1,671246.45,NULL,'2021-05-11 22:19:01','2021-05-11 22:21:19','2021-05-11 22:21:19'),(1358,3150,386,40734,18552,12,499,1,5396.57,NULL,'2021-05-11 22:19:01','2021-05-11 22:21:19','2021-05-11 22:21:19'),(1359,3150,386,40734,18552,12,13,1,170162.60,NULL,'2021-05-11 22:19:01','2021-05-11 22:21:19','2021-05-11 22:21:19'),(1360,3150,386,40734,18552,12,354,1,40091.97,NULL,'2021-05-11 22:19:01','2021-05-11 22:21:19','2021-05-11 22:21:19'),(1361,3150,386,40734,18552,12,23,1,16474.86,NULL,'2021-05-11 22:19:01','2021-05-11 22:21:19','2021-05-11 22:21:19'),(1362,3150,386,40734,18552,12,24,1,139477.26,NULL,'2021-05-11 22:19:01','2021-05-11 22:21:19','2021-05-11 22:21:19'),(1363,3150,386,40734,18552,12,492,1,8644.37,NULL,'2021-05-11 22:19:01','2021-05-11 22:21:19','2021-05-11 22:21:19'),(1364,3150,386,40734,18552,12,425,2,5839152.80,NULL,'2021-05-11 22:19:01','2021-05-11 22:21:19','2021-05-11 22:21:19'),(1365,3150,387,40735,20105,23,92,1,24858.70,NULL,'2021-05-11 22:19:50','2021-05-11 22:19:50',NULL),(1366,3150,387,40735,20105,23,88,2,23198.74,NULL,'2021-05-11 22:19:50','2021-05-11 22:19:50',NULL),(1367,3150,387,40735,20105,23,476,2,1659.96,NULL,'2021-05-11 22:19:50','2021-05-11 22:19:50',NULL),(1368,3150,388,40734,18552,12,359,1,752412.45,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(1369,3150,388,40734,18552,12,384,1,1160000.00,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(1370,3150,388,40734,18552,12,164,1,671246.45,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(1371,3150,388,40734,18552,12,499,1,5396.57,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(1372,3150,388,40734,18552,12,13,1,170162.60,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(1373,3150,388,40734,18552,12,354,1,40091.97,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(1374,3150,388,40734,18552,12,23,1,29284.00,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL);
INSERT INTO `balance_libro_details` VALUES (1375,3150,388,40734,18552,12,20,1,16474.86,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(1376,3150,388,40734,18552,12,24,1,139477.26,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(1377,3150,388,40734,18552,12,492,1,8644.37,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(1378,3150,388,40734,18552,12,503,1,33861.39,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(1379,3150,388,40734,18552,12,73,2,108275.21,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(1380,3150,388,40734,18552,12,63,2,9087.32,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(1381,3150,388,40734,18552,12,78,2,34443.14,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(1382,3150,388,40734,18552,12,369,2,12000.00,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(1383,3150,388,40734,18552,12,88,2,2581454.45,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(1384,3150,388,40734,18552,12,381,2,46350.27,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(1385,3150,388,40734,18552,12,426,2,1901541.93,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(1386,3150,388,40734,18552,12,91,2,189445.31,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(1387,3150,388,40734,18552,12,92,1,1855545.71,NULL,'2021-05-11 23:22:06','2021-05-11 23:22:06',NULL),(1388,3150,389,40734,18555,10,78,1,20723.85,NULL,'2021-05-11 23:28:21','2021-05-11 23:28:21',NULL),(1389,3150,389,40734,18555,10,57,2,20723.85,NULL,'2021-05-11 23:28:21','2021-05-11 23:28:21',NULL),(1390,3150,390,40734,18556,6,155,1,131311.44,NULL,'2021-05-11 23:51:09','2021-05-11 23:51:09',NULL),(1391,3150,390,40734,18556,6,492,2,8644.37,NULL,'2021-05-11 23:51:09','2021-05-11 23:51:09',NULL),(1392,3150,390,40734,18556,6,23,2,29284.00,NULL,'2021-05-11 23:51:09','2021-05-11 23:51:09',NULL),(1393,3150,390,40734,18556,6,20,2,42828.30,NULL,'2021-05-11 23:51:09','2021-05-11 23:51:09',NULL),(1394,3150,390,40734,18556,6,79,2,50554.77,NULL,'2021-05-11 23:51:09','2021-05-11 23:51:09',NULL),(1395,3150,391,40734,18562,15,73,1,31349.06,NULL,'2021-05-12 00:47:14','2021-05-12 00:47:14',NULL),(1396,3150,391,40734,18562,15,72,2,176.49,NULL,'2021-05-12 00:47:14','2021-05-12 00:47:14',NULL),(1397,3150,391,40734,18562,15,354,2,39671.46,NULL,'2021-05-12 00:47:14','2021-05-12 00:47:14',NULL),(1398,3150,391,40734,18562,15,493,1,8498.89,NULL,'2021-05-12 00:47:14','2021-05-12 00:47:14',NULL),(1411,3150,398,40720,1537,3,511,1,4200.75,NULL,'2021-05-19 18:27:32','2021-05-19 18:27:32',NULL),(1412,3150,398,40720,1537,3,504,1,2239.68,NULL,'2021-05-19 18:27:32','2021-05-19 18:27:32',NULL),(1413,3150,398,40720,1537,3,505,1,9354.55,NULL,'2021-05-19 18:27:32','2021-05-19 18:27:32',NULL),(1414,3150,398,40720,1537,3,129,1,4390.74,NULL,'2021-05-19 18:27:32','2021-05-19 18:27:32',NULL),(1415,3150,398,40720,1537,3,192,1,17000.00,NULL,'2021-05-19 18:27:32','2021-05-19 18:27:32',NULL),(1416,3150,398,40720,1537,3,506,1,1033.00,NULL,'2021-05-19 18:27:32','2021-05-19 18:27:32',NULL),(1417,3150,398,40720,1537,3,507,1,4449.07,NULL,'2021-05-19 18:27:32','2021-05-19 18:27:32',NULL),(1418,3150,398,40720,1537,3,508,1,358775.75,NULL,'2021-05-19 18:27:32','2021-05-19 18:27:32',NULL),(1419,3150,398,40720,1537,3,509,1,1224.53,NULL,'2021-05-19 18:27:32','2021-05-19 18:27:32',NULL),(1420,3150,398,40720,1537,3,510,1,5713.63,NULL,'2021-05-19 18:27:32','2021-05-19 18:27:32',NULL),(1421,3150,398,40720,1537,3,128,1,8956.75,NULL,'2021-05-19 18:27:32','2021-05-19 18:27:32',NULL),(1422,3150,398,40720,1537,3,68,1,32537.78,NULL,'2021-05-19 18:27:32','2021-05-19 18:27:32',NULL),(1423,3150,398,40720,1537,3,25,1,286.47,NULL,'2021-05-19 18:27:32','2021-05-19 18:27:32',NULL),(1424,3150,398,40720,1537,3,252,1,475.02,NULL,'2021-05-19 18:27:32','2021-05-19 18:27:32',NULL),(1425,3150,398,40720,1537,3,57,2,450637.72,NULL,'2021-05-19 18:27:32','2021-05-19 18:27:32',NULL),(1455,3150,402,40720,1538,2,511,1,3710.89,NULL,'2021-05-19 18:43:07','2021-05-19 18:43:07',NULL);
INSERT INTO `balance_libro_details` VALUES (1456,3150,402,40720,1538,2,504,1,842.98,NULL,'2021-05-19 18:43:07','2021-05-19 18:43:07',NULL),(1457,3150,402,40720,1538,2,505,1,418.54,NULL,'2021-05-19 18:43:07','2021-05-19 18:43:07',NULL),(1458,3150,402,40720,1538,2,129,1,4987.45,NULL,'2021-05-19 18:43:07','2021-05-19 18:43:07',NULL),(1459,3150,402,40720,1538,2,192,1,18000.00,NULL,'2021-05-19 18:43:07','2021-05-19 18:43:07',NULL),(1460,3150,402,40720,1538,2,507,1,6419.71,NULL,'2021-05-19 18:43:07','2021-05-19 18:43:07',NULL),(1461,3150,402,40720,1538,2,508,1,432071.04,NULL,'2021-05-19 18:43:07','2021-05-19 18:43:07',NULL),(1462,3150,402,40720,1538,2,509,1,4400.00,NULL,'2021-05-19 18:43:07','2021-05-19 18:43:07',NULL),(1463,3150,402,40720,1538,2,502,1,7952.90,NULL,'2021-05-19 18:43:07','2021-05-19 18:43:07',NULL),(1464,3150,402,40720,1538,2,68,1,23005.31,NULL,'2021-05-19 18:43:07','2021-05-19 18:43:07',NULL),(1465,3150,402,40720,1538,2,25,1,1077.44,NULL,'2021-05-19 18:43:07','2021-05-19 18:43:07',NULL),(1466,3150,402,40720,1538,2,252,1,2294.04,NULL,'2021-05-19 18:43:07','2021-05-19 18:43:07',NULL),(1467,3150,402,40720,1538,2,57,2,505180.30,NULL,'2021-05-19 18:43:07','2021-05-19 18:43:07',NULL),(1676,3150,419,40720,1539,3,511,1,5157.78,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1677,3150,419,40720,1539,3,504,1,1578.52,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1678,3150,419,40720,1539,3,129,1,5976.42,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1679,3150,419,40720,1539,3,192,1,18929.60,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1680,3150,419,40720,1539,3,506,1,3062.00,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1681,3150,419,40720,1539,3,507,1,7914.26,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1682,3150,419,40720,1539,3,508,1,400011.10,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1683,3150,419,40720,1539,3,509,1,990.91,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1684,3150,419,40720,1539,3,68,1,37926.43,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1685,3150,419,40720,1539,3,25,1,684.87,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1686,3150,419,40720,1539,3,252,1,1044.87,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1687,3150,419,40720,1539,3,57,2,483276.76,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1688,3150,420,40720,1540,3,511,1,3983.61,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1689,3150,420,40720,1540,3,504,1,1578.42,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1690,3150,420,40720,1540,3,505,1,776.86,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1691,3150,420,40720,1540,3,129,1,2105.73,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1692,3150,420,40720,1540,3,192,1,38954.50,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1693,3150,420,40720,1540,3,506,1,1089.00,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1694,3150,420,40720,1540,3,507,1,5328.39,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1695,3150,420,40720,1540,3,508,1,577674.34,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1696,3150,420,40720,1540,3,509,1,2750.00,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1697,3150,420,40720,1540,3,502,1,8365.00,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1698,3150,420,40720,1540,3,68,1,30133.30,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1699,3150,420,40720,1540,3,25,1,347.25,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1700,3150,420,40720,1540,3,252,1,1547.27,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1701,3150,420,40720,1540,3,57,2,674633.67,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1702,3150,421,40720,1541,3,511,1,4912.75,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1703,3150,421,40720,1541,3,504,1,10618.18,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1704,3150,421,40720,1541,3,505,1,20000.00,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL);
INSERT INTO `balance_libro_details` VALUES (1705,3150,421,40720,1541,3,129,1,1088.05,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1706,3150,421,40720,1541,3,192,1,2000.00,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1707,3150,421,40720,1541,3,506,1,7499.81,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1708,3150,421,40720,1541,3,507,1,3162.22,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1709,3150,421,40720,1541,3,508,1,461436.30,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1710,3150,421,40720,1541,3,509,1,16086.52,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1711,3150,421,40720,1541,3,68,1,26059.93,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1712,3150,421,40720,1541,3,25,1,416.99,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1713,3150,421,40720,1541,3,252,1,995.58,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1714,3150,421,40720,1541,3,57,2,554276.33,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1715,3150,422,40720,1545,3,511,1,2752.78,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1716,3150,422,40720,1545,3,504,1,1727.28,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1717,3150,422,40720,1545,3,129,1,22822.29,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1718,3150,422,40720,1545,3,192,1,20000.00,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1719,3150,422,40720,1545,3,506,1,5050.00,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1720,3150,422,40720,1545,3,507,1,6549.97,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1721,3150,422,40720,1545,3,508,1,557176.29,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1722,3150,422,40720,1545,3,509,1,474.38,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1723,3150,422,40720,1545,3,502,1,9440.12,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1724,3150,422,40720,1545,3,68,1,58610.52,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1725,3150,422,40720,1545,3,25,1,915.38,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1726,3150,422,40720,1545,3,252,1,912.69,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1727,3150,422,40720,1545,3,57,2,686431.70,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1728,3150,423,40720,1546,3,129,1,198.56,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1729,3150,423,40720,1546,3,192,1,20525.53,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1730,3150,423,40720,1546,3,507,1,3194.76,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1731,3150,423,40720,1546,3,508,1,501097.13,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1732,3150,423,40720,1546,3,509,1,520.24,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1733,3150,423,40720,1546,3,502,1,6599.88,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1734,3150,423,40720,1546,3,68,1,26738.52,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1735,3150,423,40720,1546,3,25,1,60.73,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1736,3150,423,40720,1546,3,252,1,806.88,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1737,3150,423,40720,1546,3,57,2,559742.23,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1738,3150,424,40720,1547,3,511,1,10686.92,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1739,3150,424,40720,1547,3,504,1,2991.74,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1740,3150,424,40720,1547,3,126,1,24030.00,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1741,3150,424,40720,1547,3,129,1,5173.86,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1742,3150,424,40720,1547,3,192,1,12929.20,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1743,3150,424,40720,1547,3,506,1,626.45,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1744,3150,424,40720,1547,3,507,1,15492.83,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1745,3150,424,40720,1547,3,508,1,472650.50,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL);
INSERT INTO `balance_libro_details` VALUES (1746,3150,424,40720,1547,3,509,1,2095.14,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1747,3150,424,40720,1547,3,502,1,19095.00,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1748,3150,424,40720,1547,3,68,1,94600.90,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1749,3150,424,40720,1547,3,25,1,741.41,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1750,3150,424,40720,1547,3,252,1,3552.78,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1751,3150,424,40720,1547,3,57,2,664666.73,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1752,3150,425,40720,1548,3,511,1,3478.89,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1753,3150,425,40720,1548,3,504,1,3082.65,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1754,3150,425,40720,1548,3,510,1,5400.00,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1755,3150,425,40720,1548,3,129,1,3933.32,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1756,3150,425,40720,1548,3,192,1,8000.00,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1757,3150,425,40720,1548,3,506,1,1719.50,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1758,3150,425,40720,1548,3,507,1,3865.22,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1759,3150,425,40720,1548,3,508,1,589246.87,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1760,3150,425,40720,1548,3,509,1,2272.74,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1761,3150,425,40720,1548,3,502,1,11394.50,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1762,3150,425,40720,1548,3,68,1,33200.06,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1763,3150,425,40720,1548,3,25,1,589.79,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1764,3150,425,40720,1548,3,252,1,2693.60,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1765,3150,425,40720,1548,3,57,2,668877.14,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1766,3150,426,40720,1549,3,511,1,4668.60,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1767,3150,426,40720,1549,3,504,1,2090.91,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1768,3150,426,40720,1549,3,505,1,672.00,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1769,3150,426,40720,1549,3,129,1,3855.37,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1770,3150,426,40720,1549,3,192,1,2600.00,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1771,3150,426,40720,1549,3,506,1,13259.20,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1772,3150,426,40720,1549,3,507,1,12843.17,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1773,3150,426,40720,1549,3,508,1,406244.89,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1774,3150,426,40720,1549,3,509,1,523.07,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1775,3150,426,40720,1549,3,502,1,13081.00,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1776,3150,426,40720,1549,3,68,1,61595.73,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1777,3150,426,40720,1549,3,25,1,919.04,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1778,3150,426,40720,1549,3,252,1,2008.00,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1779,3150,426,40720,1549,3,57,2,524360.98,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1780,3150,427,40720,1550,3,511,1,2147.96,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1781,3150,427,40720,1550,3,504,1,2090.91,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1782,3150,427,40720,1550,3,129,1,5580.32,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1783,3150,427,40720,1550,3,192,1,8000.00,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1784,3150,427,40720,1550,3,507,1,9565.10,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1785,3150,427,40720,1550,3,508,1,597032.79,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1786,3150,427,40720,1550,3,509,1,945.36,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL);
INSERT INTO `balance_libro_details` VALUES (1787,3150,427,40720,1550,3,502,1,12302.00,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1788,3150,427,40720,1550,3,68,1,44470.57,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1789,3150,427,40720,1550,3,25,1,371.87,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1790,3150,427,40720,1550,3,252,1,1706.24,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1791,3150,427,40720,1550,3,57,2,684213.12,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1792,3150,428,40720,1551,3,511,1,3232.79,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1793,3150,428,40720,1551,3,504,1,2090.91,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1794,3150,428,40720,1551,3,129,1,3020.88,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1795,3150,428,40720,1551,3,192,1,16000.00,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1796,3150,428,40720,1551,3,507,1,8916.72,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1797,3150,428,40720,1551,3,508,1,645506.54,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1798,3150,428,40720,1551,3,509,1,5716.04,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1799,3150,428,40720,1551,3,502,1,13388.50,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1800,3150,428,40720,1551,3,68,1,74770.82,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1801,3150,428,40720,1551,3,25,1,864.78,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1802,3150,428,40720,1551,3,252,1,2502.92,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1803,3150,428,40720,1551,3,57,2,776010.90,NULL,'2021-05-19 19:44:28','2021-05-19 19:44:28',NULL),(1804,3150,429,40720,1537,1,110,1,263846.93,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1805,3150,429,40720,1537,1,191,1,86024.20,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1806,3150,429,40720,1537,1,62,2,215035.25,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1807,3150,429,40720,1537,1,63,2,128239.71,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1808,3150,429,40720,1537,1,488,2,6596.17,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1809,3150,430,40720,1538,1,110,1,238325.84,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1810,3150,430,40720,1538,1,191,1,76562.48,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1811,3150,430,40720,1538,1,62,2,194235.56,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1812,3150,430,40720,1538,1,63,2,114694.61,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1813,3150,430,40720,1538,1,488,2,5958.15,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1814,3150,431,40720,1539,1,110,1,287590.92,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1815,3150,431,40720,1539,1,191,1,94293.76,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1816,3150,431,40720,1539,1,62,2,234386.60,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1817,3150,431,40720,1539,1,63,2,140308.31,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1818,3150,431,40720,1539,1,488,2,7189.77,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1819,3150,432,40720,1540,1,110,1,269619.75,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1820,3150,432,40720,1540,1,191,1,82552.83,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1821,3150,432,40720,1540,1,62,2,223902.60,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1822,3150,432,40720,1540,1,63,2,122091.99,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1823,3150,432,40720,1540,1,488,2,6177.99,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1824,3150,433,40720,1541,1,110,1,372075.45,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1825,3150,433,40720,1541,1,191,1,120483.99,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1826,3150,433,40720,1541,1,62,2,303241.49,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1827,3150,433,40720,1541,1,63,2,180016.06,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL);
INSERT INTO `balance_libro_details` VALUES (1828,3150,433,40720,1541,1,488,2,9301.89,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1829,3150,434,40720,1545,1,110,1,270252.80,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1830,3150,434,40720,1545,1,191,1,75076.26,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1831,3150,434,40720,1545,1,62,2,224451.83,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1832,3150,434,40720,1545,1,63,2,114687.91,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1833,3150,434,40720,1545,1,488,2,6189.32,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1834,3150,435,40720,1546,1,110,1,244498.72,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1835,3150,435,40720,1546,1,191,1,71151.30,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1836,3150,435,40720,1546,1,62,2,199266.46,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1837,3150,435,40720,1546,1,63,2,110271.09,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1838,3150,435,40720,1546,1,488,2,6112.47,NULL,'2021-05-19 21:51:03','2021-05-19 21:51:03',NULL),(1839,3150,436,40720,1547,1,110,1,267314.81,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1840,3150,436,40720,1547,1,191,1,78935.22,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1841,3150,436,40720,1547,1,62,2,217861.57,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1842,3150,436,40720,1547,1,63,2,121705.59,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1843,3150,436,40720,1547,1,488,2,6682.87,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1844,3150,437,40720,1548,1,110,1,319756.21,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1845,3150,437,40720,1548,1,191,1,96560.41,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1846,3150,437,40720,1548,1,62,2,260601.31,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1847,3150,437,40720,1548,1,63,2,147721.40,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1848,3150,437,40720,1548,1,488,2,7993.91,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1849,3150,438,40720,1549,1,110,1,304780.17,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1850,3150,438,40720,1549,1,191,1,89901.44,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1851,3150,438,40720,1549,1,62,2,248395.84,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1852,3150,438,40720,1549,1,63,2,138666.27,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1853,3150,438,40720,1549,1,488,2,7619.50,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1854,3150,439,40720,1550,1,110,1,538582.80,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1855,3150,439,40720,1550,1,191,1,154121.18,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1856,3150,439,40720,1550,1,62,2,445604.98,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1857,3150,439,40720,1550,1,63,2,234534.43,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1858,3150,439,40720,1550,1,488,2,12564.57,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1859,3150,440,40720,1551,1,110,1,366884.16,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1860,3150,440,40720,1551,1,191,1,111681.07,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1861,3150,440,40720,1551,1,62,2,299010.59,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1862,3150,440,40720,1551,1,63,2,170382.54,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1863,3150,440,40720,1551,1,488,2,9172.10,NULL,'2021-05-19 21:51:04','2021-05-19 21:51:04',NULL),(1864,3150,441,40720,1541,3,396,1,1162.00,NULL,'2021-05-19 22:11:17','2021-05-19 22:17:26','2021-05-19 22:17:26'),(1865,3150,441,40720,1541,3,437,1,1278.80,NULL,'2021-05-19 22:11:17','2021-05-19 22:17:26','2021-05-19 22:17:26'),(1866,3150,441,40720,1541,3,157,1,2596.36,NULL,'2021-05-19 22:11:17','2021-05-19 22:17:26','2021-05-19 22:17:26'),(1867,3150,441,40720,1541,3,63,1,122091.99,NULL,'2021-05-19 22:11:17','2021-05-19 22:17:26','2021-05-19 22:17:26');
INSERT INTO `balance_libro_details` VALUES (1868,3150,441,40720,1541,3,74,1,110061.68,NULL,'2021-05-19 22:11:17','2021-05-19 22:17:26','2021-05-19 22:17:26'),(1869,3150,441,40720,1541,3,13,2,359411.00,NULL,'2021-05-19 22:11:17','2021-05-19 22:17:26','2021-05-19 22:17:26'),(1870,3150,441,40720,1541,3,8,1,59785.07,NULL,'2021-05-19 22:11:17','2021-05-19 22:17:26','2021-05-19 22:17:26'),(1871,3150,441,40720,1541,3,473,1,29764.00,NULL,'2021-05-19 22:11:17','2021-05-19 22:17:26','2021-05-19 22:17:26'),(1872,3150,441,40720,1541,3,78,1,32671.10,NULL,'2021-05-19 22:11:17','2021-05-19 22:17:26','2021-05-19 22:17:26'),(1873,3150,442,40720,1541,3,396,1,1162.00,NULL,'2021-05-19 22:17:26','2021-05-19 22:17:26',NULL),(1874,3150,442,40720,1541,3,437,1,1278.80,NULL,'2021-05-19 22:17:26','2021-05-19 22:17:26',NULL),(1875,3150,442,40720,1541,3,157,1,2596.36,NULL,'2021-05-19 22:17:26','2021-05-19 22:17:26',NULL),(1876,3150,442,40720,1541,3,63,1,122091.99,NULL,'2021-05-19 22:17:26','2021-05-19 22:17:26',NULL),(1877,3150,442,40720,1541,3,74,1,110061.68,NULL,'2021-05-19 22:17:26','2021-05-19 22:17:26',NULL),(1878,3150,442,40720,1541,3,13,2,359411.00,NULL,'2021-05-19 22:17:26','2021-05-19 22:17:26',NULL),(1879,3150,442,40720,1541,3,473,1,29764.00,NULL,'2021-05-19 22:17:26','2021-05-19 22:17:26',NULL),(1880,3150,442,40720,1541,3,78,1,32671.10,NULL,'2021-05-19 22:17:26','2021-05-19 22:17:26',NULL),(1881,3150,442,40720,1541,3,425,1,59785.07,NULL,'2021-05-19 22:17:26','2021-05-19 22:17:26',NULL),(1882,3150,443,40720,1551,3,396,1,1804.34,NULL,'2021-05-19 22:18:06','2021-05-19 22:18:06',NULL),(1883,3150,443,40720,1551,3,437,1,2084.85,NULL,'2021-05-19 22:18:06','2021-05-19 22:18:06',NULL),(1884,3150,443,40720,1551,3,157,1,4232.83,NULL,'2021-05-19 22:18:06','2021-05-19 22:18:06',NULL),(1885,3150,443,40720,1551,3,63,1,234534.43,NULL,'2021-05-19 22:18:06','2021-05-19 22:18:06',NULL),(1886,3150,443,40720,1551,3,74,1,159846.07,NULL,'2021-05-19 22:18:06','2021-05-19 22:18:06',NULL),(1887,3150,443,40720,1551,3,13,2,617012.83,NULL,'2021-05-19 22:18:06','2021-05-19 22:18:06',NULL),(1888,3150,443,40720,1551,3,327,1,39749.48,NULL,'2021-05-19 22:18:06','2021-05-19 22:18:06',NULL),(1889,3150,443,40720,1551,3,425,1,174760.83,NULL,'2021-05-19 22:18:06','2021-05-19 22:18:06',NULL),(1890,3150,444,40720,1550,3,396,1,7947.00,NULL,'2021-05-19 22:18:44','2021-05-19 22:58:44','2021-05-19 22:58:44'),(1891,3150,444,40720,1550,3,437,1,2720.66,NULL,'2021-05-19 22:18:44','2021-05-19 22:58:44','2021-05-19 22:58:44'),(1892,3150,444,40720,1550,3,157,1,5523.77,NULL,'2021-05-19 22:18:44','2021-05-19 22:58:44','2021-05-19 22:58:44'),(1893,3150,444,40720,1550,3,63,1,138666.27,NULL,'2021-05-19 22:18:44','2021-05-19 22:58:44','2021-05-19 22:58:44'),(1894,3150,444,40720,1550,3,74,1,149947.80,NULL,'2021-05-19 22:18:44','2021-05-19 22:58:44','2021-05-19 22:58:44'),(1895,3150,444,40720,1550,3,13,2,398751.04,NULL,'2021-05-19 22:18:44','2021-05-19 22:58:44','2021-05-19 22:58:44'),(1896,3150,444,40720,1550,3,327,1,33031.14,NULL,'2021-05-19 22:18:44','2021-05-19 22:58:44','2021-05-19 22:58:44'),(1897,3150,444,40720,1550,3,76,1,5219.13,NULL,'2021-05-19 22:18:44','2021-05-19 22:58:44','2021-05-19 22:58:44'),(1898,3150,444,40720,1550,3,425,1,55695.27,NULL,'2021-05-19 22:18:44','2021-05-19 22:58:44','2021-05-19 22:58:44'),(1899,3150,445,40720,1549,3,396,1,1333.46,NULL,'2021-05-19 22:19:25','2021-05-19 22:19:25',NULL),(1900,3150,445,40720,1549,3,437,1,1563.44,NULL,'2021-05-19 22:19:25','2021-05-19 22:19:25',NULL),(1901,3150,445,40720,1549,3,157,1,3174.26,NULL,'2021-05-19 22:19:25','2021-05-19 22:19:25',NULL),(1902,3150,445,40720,1549,3,63,1,147721.40,NULL,'2021-05-19 22:19:25','2021-05-19 22:19:25',NULL),(1903,3150,445,40720,1549,3,74,1,139460.82,NULL,'2021-05-19 22:19:25','2021-05-19 22:19:25',NULL),(1904,3150,445,40720,1549,3,13,2,465270.00,NULL,'2021-05-19 22:19:25','2021-05-19 22:19:25',NULL),(1905,3150,445,40720,1549,3,327,1,35831.52,NULL,'2021-05-19 22:19:25','2021-05-19 22:19:25',NULL);
INSERT INTO `balance_libro_details` VALUES (1906,3150,445,40720,1549,3,425,1,136185.10,NULL,'2021-05-19 22:19:25','2021-05-19 22:19:25',NULL),(1907,3150,446,40720,1548,3,396,1,1798.12,NULL,'2021-05-19 22:19:59','2021-05-19 22:19:59',NULL),(1908,3150,446,40720,1548,3,437,1,1396.59,NULL,'2021-05-19 22:19:59','2021-05-19 22:19:59',NULL),(1909,3150,446,40720,1548,3,157,1,2835.47,NULL,'2021-05-19 22:19:59','2021-05-19 22:19:59',NULL),(1910,3150,446,40720,1548,3,63,1,121706.19,NULL,'2021-05-19 22:19:59','2021-05-19 22:19:59',NULL),(1911,3150,446,40720,1548,3,74,1,129010.49,NULL,'2021-05-19 22:19:59','2021-05-19 22:19:59',NULL),(1912,3150,446,40720,1548,3,13,2,426599.00,NULL,'2021-05-19 22:19:59','2021-05-19 22:19:59',NULL),(1913,3150,446,40720,1548,3,327,1,31350.17,NULL,'2021-05-19 22:19:59','2021-05-19 22:19:59',NULL),(1914,3150,446,40720,1548,3,425,1,138501.97,NULL,'2021-05-19 22:19:59','2021-05-19 22:19:59',NULL),(1915,3150,447,40720,1547,3,396,1,1333.46,NULL,'2021-05-19 22:20:33','2021-05-19 22:20:33',NULL),(1916,3150,447,40720,1547,3,437,1,2719.50,NULL,'2021-05-19 22:20:33','2021-05-19 22:20:33',NULL),(1917,3150,447,40720,1547,3,157,1,1339.48,NULL,'2021-05-19 22:20:33','2021-05-19 22:20:33',NULL),(1918,3150,447,40720,1547,3,63,1,110271.09,NULL,'2021-05-19 22:20:33','2021-05-19 22:20:33',NULL),(1919,3150,447,40720,1547,3,74,1,120008.30,NULL,'2021-05-19 22:20:33','2021-05-19 22:20:33',NULL),(1920,3150,447,40720,1547,3,13,2,412999.00,NULL,'2021-05-19 22:20:33','2021-05-19 22:20:33',NULL),(1921,3150,447,40720,1547,3,327,1,31883.71,NULL,'2021-05-19 22:20:33','2021-05-19 22:20:33',NULL),(1922,3150,447,40720,1547,3,425,1,145443.46,NULL,'2021-05-19 22:20:33','2021-05-19 22:20:33',NULL),(1923,3150,448,40720,1546,3,396,1,1333.46,NULL,'2021-05-19 22:21:12','2021-05-19 22:21:12',NULL),(1924,3150,448,40720,1546,3,437,1,1147.53,NULL,'2021-05-19 22:21:12','2021-05-19 22:21:12',NULL),(1925,3150,448,40720,1546,3,157,1,2329.83,NULL,'2021-05-19 22:21:12','2021-05-19 22:21:12',NULL),(1926,3150,448,40720,1546,3,74,1,121116.07,NULL,'2021-05-19 22:21:12','2021-05-19 22:21:12',NULL),(1927,3150,448,40720,1546,3,57,1,50000.00,NULL,'2021-05-19 22:21:12','2021-05-19 22:21:12',NULL),(1928,3150,448,40720,1546,3,13,2,385211.35,NULL,'2021-05-19 22:21:12','2021-05-19 22:21:12',NULL),(1929,3150,448,40720,1546,3,302,1,34671.05,NULL,'2021-05-19 22:21:12','2021-05-19 22:21:12',NULL),(1930,3150,448,40720,1546,3,425,1,174613.41,NULL,'2021-05-19 22:21:12','2021-05-19 22:21:12',NULL),(1931,3150,449,40720,1545,3,396,1,1333.46,NULL,'2021-05-19 22:22:02','2021-05-19 22:22:02',NULL),(1932,3150,449,40720,1545,3,437,1,1841.97,NULL,'2021-05-19 22:22:02','2021-05-19 22:22:02',NULL),(1933,3150,449,40720,1545,3,157,1,3739.74,NULL,'2021-05-19 22:22:02','2021-05-19 22:22:02',NULL),(1934,3150,449,40720,1545,3,63,1,180016.06,NULL,'2021-05-19 22:22:02','2021-05-19 22:22:02',NULL),(1935,3150,449,40720,1545,3,74,1,122407.13,NULL,'2021-05-19 22:22:02','2021-05-19 22:22:02',NULL),(1936,3150,449,40720,1545,3,13,2,220848.74,NULL,'2021-05-19 22:22:02','2021-05-19 22:22:02',NULL),(1937,3150,449,40720,1545,3,327,1,32496.28,NULL,'2021-05-19 22:22:02','2021-05-19 22:22:02',NULL),(1938,3150,449,40720,1545,3,425,2,120985.90,NULL,'2021-05-19 22:22:02','2021-05-19 22:22:02',NULL),(1939,3150,450,40720,1540,3,396,1,2062.24,NULL,'2021-05-19 22:22:42','2021-05-19 22:22:42',NULL),(1940,3150,450,40720,1540,3,437,1,1681.81,NULL,'2021-05-19 22:22:42','2021-05-19 22:22:42',NULL),(1941,3150,450,40720,1540,3,157,1,3414.57,NULL,'2021-05-19 22:22:42','2021-05-19 22:22:42',NULL),(1942,3150,450,40720,1540,3,63,1,140308.31,NULL,'2021-05-19 22:22:42','2021-05-19 22:22:42',NULL),(1943,3150,450,40720,1540,3,74,1,110003.56,NULL,'2021-05-19 22:22:42','2021-05-19 22:22:42',NULL),(1944,3150,450,40720,1540,3,57,1,154000.00,NULL,'2021-05-19 22:22:42','2021-05-19 22:22:42',NULL),(1945,3150,450,40720,1540,3,13,2,384484.00,NULL,'2021-05-19 22:22:42','2021-05-19 22:22:42',NULL),(1946,3150,450,40720,1540,3,327,1,32052.25,NULL,'2021-05-19 22:22:42','2021-05-19 22:22:42',NULL);
INSERT INTO `balance_libro_details` VALUES (1947,3150,450,40720,1540,3,327,1,14557.83,NULL,'2021-05-19 22:22:42','2021-05-19 22:22:42',NULL),(1948,3150,450,40720,1540,3,327,1,27758.69,NULL,'2021-05-19 22:22:42','2021-05-19 22:22:42',NULL),(1949,3150,450,40720,1540,3,425,2,101355.26,NULL,'2021-05-19 22:22:42','2021-05-19 22:22:42',NULL),(1950,3150,451,40720,1539,3,396,1,1041.00,NULL,'2021-05-19 22:23:21','2021-05-19 22:23:21',NULL),(1951,3150,451,40720,1539,3,437,1,1208.02,NULL,'2021-05-19 22:23:21','2021-05-19 22:23:21',NULL),(1952,3150,451,40720,1539,3,157,1,2452.64,NULL,'2021-05-19 22:23:21','2021-05-19 22:23:21',NULL),(1953,3150,451,40720,1539,3,20,1,25996.63,NULL,'2021-05-19 22:23:21','2021-05-19 22:23:21',NULL),(1954,3150,451,40720,1539,3,63,1,114694.61,NULL,'2021-05-19 22:23:21','2021-05-19 22:23:21',NULL),(1955,3150,451,40720,1539,3,74,1,109726.15,NULL,'2021-05-19 22:23:21','2021-05-19 22:23:21',NULL),(1956,3150,451,40720,1539,3,13,2,351434.00,NULL,'2021-05-19 22:23:21','2021-05-19 22:23:21',NULL),(1957,3150,451,40720,1539,3,327,1,27517.28,NULL,'2021-05-19 22:23:21','2021-05-19 22:23:21',NULL),(1958,3150,451,40720,1539,3,425,1,68797.67,NULL,'2021-05-19 22:23:21','2021-05-19 22:23:21',NULL),(1959,3150,452,40720,1537,3,396,1,1162.00,NULL,'2021-05-19 22:24:17','2021-05-19 22:31:18','2021-05-19 22:31:18'),(1960,3150,452,40720,1537,3,437,1,1278.80,NULL,'2021-05-19 22:24:17','2021-05-19 22:31:18','2021-05-19 22:31:18'),(1961,3150,452,40720,1537,3,157,1,2596.36,NULL,'2021-05-19 22:24:17','2021-05-19 22:31:18','2021-05-19 22:31:18'),(1962,3150,452,40720,1537,3,63,1,122091.99,NULL,'2021-05-19 22:24:17','2021-05-19 22:31:18','2021-05-19 22:31:18'),(1963,3150,452,40720,1537,3,74,1,110061.68,NULL,'2021-05-19 22:24:17','2021-05-19 22:31:18','2021-05-19 22:31:18'),(1964,3150,452,40720,1537,3,13,2,359411.00,NULL,'2021-05-19 22:24:17','2021-05-19 22:31:18','2021-05-19 22:31:18'),(1965,3150,452,40720,1537,3,327,1,32671.10,NULL,'2021-05-19 22:24:17','2021-05-19 22:31:18','2021-05-19 22:31:18'),(1966,3150,452,40720,1537,3,81,1,29764.00,NULL,'2021-05-19 22:24:17','2021-05-19 22:31:18','2021-05-19 22:31:18'),(1967,3150,452,40720,1537,3,425,1,59785.07,NULL,'2021-05-19 22:24:17','2021-05-19 22:31:18','2021-05-19 22:31:18'),(1968,3150,453,40720,1538,3,396,1,855.60,NULL,'2021-05-19 22:32:18','2021-05-19 22:32:18',NULL),(1969,3150,453,40720,1538,3,437,1,1235.23,NULL,'2021-05-19 22:32:18','2021-05-19 22:32:18',NULL),(1970,3150,453,40720,1538,3,157,1,2507.88,NULL,'2021-05-19 22:32:18','2021-05-19 22:32:18',NULL),(1971,3150,453,40720,1538,3,20,1,25996.63,NULL,'2021-05-19 22:32:18','2021-05-19 22:32:18',NULL),(1972,3150,453,40720,1538,3,63,1,128239.71,NULL,'2021-05-19 22:32:18','2021-05-19 22:32:18',NULL),(1973,3150,453,40720,1538,3,74,1,104614.81,NULL,'2021-05-19 22:32:18','2021-05-19 22:32:18',NULL),(1974,3150,453,40720,1538,3,57,1,100000.00,NULL,'2021-05-19 22:32:18','2021-05-19 22:32:18',NULL),(1975,3150,453,40720,1538,3,13,2,241467.36,NULL,'2021-05-19 22:32:18','2021-05-19 22:32:18',NULL),(1976,3150,453,40720,1538,3,327,1,26578.49,NULL,'2021-05-19 22:32:18','2021-05-19 22:32:18',NULL),(1977,3150,453,40720,1538,3,425,2,148560.99,NULL,'2021-05-19 22:32:18','2021-05-19 22:32:18',NULL),(1978,3150,454,40720,1537,3,396,1,1017.74,NULL,'2021-05-19 22:32:54','2021-05-19 22:32:54',NULL),(1979,3150,454,40720,1537,3,437,1,1112.52,NULL,'2021-05-19 22:32:54','2021-05-19 22:32:54',NULL),(1980,3150,454,40720,1537,3,157,1,2258.84,NULL,'2021-05-19 22:32:54','2021-05-19 22:32:54',NULL),(1981,3150,454,40720,1537,3,20,1,25996.63,NULL,'2021-05-19 22:32:54','2021-05-19 22:32:54',NULL),(1982,3150,454,40720,1537,3,63,1,132612.83,NULL,'2021-05-19 22:32:54','2021-05-19 22:32:54',NULL),(1983,3150,454,40720,1537,3,74,1,104091.76,NULL,'2021-05-19 22:32:54','2021-05-19 22:32:54',NULL),(1984,3150,454,40720,1537,3,13,2,298174.19,NULL,'2021-05-19 22:32:54','2021-05-19 22:32:54',NULL),(1985,3150,454,40720,1537,3,425,1,31083.87,NULL,'2021-05-19 22:32:54','2021-05-19 22:32:54',NULL);
INSERT INTO `balance_libro_details` VALUES (1986,3150,455,40720,1550,3,396,1,7947.00,NULL,'2021-05-19 22:58:44','2021-05-19 22:58:44',NULL),(1987,3150,455,40720,1550,3,437,1,2720.66,NULL,'2021-05-19 22:58:44','2021-05-19 22:58:44',NULL),(1988,3150,455,40720,1550,3,157,1,5523.77,NULL,'2021-05-19 22:58:44','2021-05-19 22:58:44',NULL),(1989,3150,455,40720,1550,3,63,1,138666.27,NULL,'2021-05-19 22:58:44','2021-05-19 22:58:44',NULL),(1990,3150,455,40720,1550,3,74,1,149947.80,NULL,'2021-05-19 22:58:44','2021-05-19 22:58:44',NULL),(1991,3150,455,40720,1550,3,13,2,398751.04,NULL,'2021-05-19 22:58:44','2021-05-19 22:58:44',NULL),(1992,3150,455,40720,1550,3,327,1,33031.14,NULL,'2021-05-19 22:58:44','2021-05-19 22:58:44',NULL),(1993,3150,455,40720,1550,3,76,1,5219.13,NULL,'2021-05-19 22:58:44','2021-05-19 22:58:44',NULL),(1994,3150,455,40720,1550,3,425,2,594304.73,NULL,'2021-05-19 22:58:44','2021-05-19 22:58:44',NULL),(1995,3150,455,40720,1550,3,57,1,650000.00,NULL,'2021-05-19 22:58:44','2021-05-19 22:58:44',NULL),(1996,3150,456,40720,1537,19,359,1,204862.99,NULL,'2021-05-19 23:03:09','2021-05-19 23:03:09',NULL),(1997,3150,456,40720,1537,19,482,2,13103.00,NULL,'2021-05-19 23:03:09','2021-05-19 23:03:09',NULL),(1998,3150,456,40720,1537,19,410,2,191759.99,NULL,'2021-05-19 23:03:09','2021-05-19 23:03:09',NULL),(1999,3150,457,40720,1551,16,21,2,2502.92,NULL,'2021-05-19 23:04:32','2021-05-19 23:04:32',NULL),(2000,3150,457,40720,1551,16,140,1,483.82,NULL,'2021-05-19 23:04:32','2021-05-19 23:04:32',NULL),(2001,3150,457,40720,1551,16,327,2,40802.09,NULL,'2021-05-19 23:04:32','2021-05-19 23:04:32',NULL),(2002,3150,457,40720,1551,16,156,1,42972.68,NULL,'2021-05-19 23:04:32','2021-05-19 23:04:32',NULL),(2003,3150,457,40720,1551,16,252,2,151.49,NULL,'2021-05-19 23:04:32','2021-05-19 23:04:32',NULL),(2004,3150,458,40720,1550,16,21,2,1706.24,NULL,'2021-05-19 23:04:57','2021-05-19 23:04:57',NULL),(2005,3150,458,40720,1550,16,140,1,276.31,NULL,'2021-05-19 23:04:57','2021-05-19 23:04:57',NULL),(2006,3150,458,40720,1550,16,327,2,39749.48,NULL,'2021-05-19 23:04:57','2021-05-19 23:04:57',NULL),(2007,3150,458,40720,1550,16,156,1,41330.90,NULL,'2021-05-19 23:04:57','2021-05-19 23:04:57',NULL),(2008,3150,458,40720,1550,16,252,2,151.49,NULL,'2021-05-19 23:04:57','2021-05-19 23:04:57',NULL),(2009,3150,459,40735,20105,19,149,1,21571.30,NULL,'2021-05-24 21:54:10','2021-05-24 21:55:21','2021-05-24 21:55:21'),(2010,3150,459,40735,20105,19,92,2,21571.30,NULL,'2021-05-24 21:54:10','2021-05-24 21:55:21','2021-05-24 21:55:21'),(2011,3150,460,40735,20105,19,92,2,21571.30,NULL,'2021-05-24 21:55:21','2021-05-24 21:55:21',NULL),(2012,3150,460,40735,20105,19,476,1,21571.30,NULL,'2021-05-24 21:55:21','2021-05-24 21:55:21',NULL),(2013,3150,461,40734,18563,18,255,2,960.00,NULL,'2021-05-24 22:25:48','2021-05-24 22:51:33','2021-05-24 22:51:33'),(2014,3150,461,40734,18563,18,494,1,2560.00,NULL,'2021-05-24 22:25:48','2021-05-24 22:51:33','2021-05-24 22:51:33'),(2015,3150,461,40734,18563,18,252,2,1600.00,NULL,'2021-05-24 22:25:48','2021-05-24 22:51:33','2021-05-24 22:51:33'),(2016,3150,462,40734,18563,19,252,1,1600.00,NULL,'2021-05-24 22:29:09','2021-05-24 22:51:43','2021-05-24 22:51:43'),(2017,3150,462,40734,18563,19,305,1,960.00,NULL,'2021-05-24 22:29:09','2021-05-24 22:51:43','2021-05-24 22:51:43'),(2018,3150,462,40734,18563,19,359,2,2560.00,NULL,'2021-05-24 22:29:09','2021-05-24 22:51:43','2021-05-24 22:51:43'),(2019,3150,463,40734,18563,18,255,2,960.00,NULL,'2021-05-24 22:51:33','2021-05-24 22:51:33',NULL),(2020,3150,463,40734,18563,18,252,2,1600.00,NULL,'2021-05-24 22:51:33','2021-05-24 22:51:33',NULL),(2021,3150,463,40734,18563,18,302,1,960.00,NULL,'2021-05-24 22:51:33','2021-05-24 22:51:33',NULL),(2022,3150,463,40734,18563,18,305,1,1600.00,NULL,'2021-05-24 22:51:33','2021-05-24 22:51:33',NULL),(2023,3150,464,40734,18554,19,455,1,431298.80,NULL,'2021-05-24 23:02:19','2021-05-24 23:02:19',NULL),(2024,3150,464,40734,18554,19,455,1,431298.80,NULL,'2021-05-24 23:02:19','2021-05-24 23:02:19',NULL);
INSERT INTO `balance_libro_details` VALUES (2025,3150,464,40734,18554,19,27,2,358432.40,NULL,'2021-05-24 23:02:19','2021-05-24 23:02:19',NULL),(2026,3150,464,40734,18554,19,359,2,504165.20,NULL,'2021-05-24 23:02:19','2021-05-24 23:02:19',NULL),(2099,3150,469,40734,18552,21,57,1,31501.11,NULL,'2021-05-24 23:22:01','2021-05-24 23:24:03','2021-05-24 23:24:03'),(2100,3150,469,40734,18552,21,359,2,31501.11,NULL,'2021-05-24 23:22:01','2021-05-24 23:24:03','2021-05-24 23:24:03'),(2101,3150,470,40734,18553,21,57,1,15800.00,NULL,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(2102,3150,470,40734,18553,21,359,2,15800.00,NULL,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(2103,3150,471,40734,18554,21,57,1,35880.45,NULL,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(2104,3150,471,40734,18554,21,359,2,35880.45,NULL,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(2105,3150,472,40734,18555,21,57,1,5500.00,NULL,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(2106,3150,472,40734,18555,21,365,2,5500.00,NULL,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(2107,3150,473,40734,18556,21,57,1,9230.00,NULL,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(2108,3150,473,40734,18556,21,359,2,9230.00,NULL,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(2109,3150,474,40734,18558,21,57,2,4730.00,NULL,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(2110,3150,474,40734,18558,21,359,1,4730.00,NULL,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(2111,3150,475,40734,18561,21,57,2,1300.00,NULL,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(2112,3150,475,40734,18561,21,359,1,1300.00,NULL,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(2113,3150,476,40734,18562,21,57,1,40088.96,NULL,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(2114,3150,476,40734,18562,21,359,2,40088.96,NULL,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(2115,3150,477,40734,18563,21,57,1,78345.61,NULL,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(2116,3150,477,40734,18563,21,359,2,78345.61,NULL,'2021-05-24 23:22:01','2021-05-24 23:24:36','2021-05-24 23:24:36'),(2135,3150,479,40734,18552,21,57,2,31501.11,NULL,'2021-05-24 23:25:17','2021-05-24 23:25:17',NULL),(2136,3150,479,40734,18552,21,359,1,31501.11,NULL,'2021-05-24 23:25:17','2021-05-24 23:25:17',NULL),(2137,3150,480,40734,18553,21,57,2,15800.00,NULL,'2021-05-24 23:25:17','2021-05-24 23:25:17',NULL),(2138,3150,480,40734,18553,21,359,1,15800.00,NULL,'2021-05-24 23:25:17','2021-05-24 23:25:17',NULL),(2139,3150,481,40734,18554,21,57,2,35880.45,NULL,'2021-05-24 23:25:17','2021-05-24 23:25:17',NULL),(2140,3150,481,40734,18554,21,359,1,35880.45,NULL,'2021-05-24 23:25:17','2021-05-24 23:25:17',NULL),(2141,3150,482,40734,18555,21,57,2,5500.00,NULL,'2021-05-24 23:25:17','2021-05-24 23:25:17',NULL),(2142,3150,482,40734,18555,21,365,1,5500.00,NULL,'2021-05-24 23:25:17','2021-05-24 23:25:17',NULL),(2143,3150,483,40734,18556,21,57,2,9230.00,NULL,'2021-05-24 23:25:18','2021-05-24 23:25:18',NULL),(2144,3150,483,40734,18556,21,359,1,9230.00,NULL,'2021-05-24 23:25:18','2021-05-24 23:25:18',NULL),(2145,3150,484,40734,18558,21,57,1,4730.00,NULL,'2021-05-24 23:25:18','2021-05-24 23:25:18',NULL),(2146,3150,484,40734,18558,21,359,2,4730.00,NULL,'2021-05-24 23:25:18','2021-05-24 23:25:18',NULL),(2147,3150,485,40734,18561,21,57,1,1300.00,NULL,'2021-05-24 23:25:18','2021-05-24 23:25:18',NULL),(2148,3150,485,40734,18561,21,359,2,1300.00,NULL,'2021-05-24 23:25:18','2021-05-24 23:25:18',NULL),(2149,3150,486,40734,18562,21,57,2,40088.96,NULL,'2021-05-24 23:25:18','2021-05-24 23:25:18',NULL),(2150,3150,486,40734,18562,21,359,1,40088.96,NULL,'2021-05-24 23:25:18','2021-05-24 23:25:18',NULL),(2151,3150,487,40734,18563,21,57,2,78345.61,NULL,'2021-05-24 23:25:18','2021-05-24 23:25:18',NULL);
INSERT INTO `balance_libro_details` VALUES (2152,3150,487,40734,18563,21,359,1,78345.61,NULL,'2021-05-24 23:25:18','2021-05-24 23:25:18',NULL),(2171,3150,489,40734,18563,19,368,2,184982.64,NULL,'2021-05-24 23:35:59','2021-05-24 23:35:59',NULL),(2172,3150,489,40734,18563,19,395,1,50000.00,NULL,'2021-05-24 23:35:59','2021-05-24 23:35:59',NULL),(2173,3150,489,40734,18563,19,359,1,134982.64,NULL,'2021-05-24 23:35:59','2021-05-24 23:35:59',NULL),(2174,3150,490,40734,18563,18,72,1,2203.48,NULL,'2021-05-24 23:44:52','2021-05-24 23:44:52',NULL),(2175,3150,490,40734,18563,18,73,1,108275.21,NULL,'2021-05-24 23:44:52','2021-05-24 23:44:52',NULL),(2176,3150,490,40734,18563,18,74,2,104319.67,NULL,'2021-05-24 23:44:52','2021-05-24 23:44:52',NULL),(2177,3150,490,40734,18563,18,493,2,68001.31,NULL,'2021-05-24 23:44:52','2021-05-24 23:44:52',NULL),(2178,3150,490,40734,18563,18,20,1,68001.31,NULL,'2021-05-24 23:44:52','2021-05-24 23:44:52',NULL),(2179,3150,490,40734,18563,18,20,1,102843.45,NULL,'2021-05-24 23:44:52','2021-05-24 23:44:52',NULL),(2180,3150,490,40734,18563,18,359,2,109002.47,NULL,'2021-05-24 23:44:52','2021-05-24 23:44:52',NULL),(2185,3150,493,40734,18563,18,435,2,24643.89,NULL,'2021-05-24 23:50:18','2021-05-24 23:50:18',NULL),(2186,3150,493,40734,18563,18,495,2,7188.12,NULL,'2021-05-24 23:50:18','2021-05-24 23:50:18',NULL),(2187,3150,493,40734,18563,18,79,2,27015.08,NULL,'2021-05-24 23:50:18','2021-05-24 23:50:18',NULL),(2188,3150,493,40734,18563,18,365,2,11000.00,NULL,'2021-05-24 23:50:18','2021-05-24 23:50:18',NULL),(2189,3150,493,40734,18563,18,71,1,70677.60,NULL,'2021-05-24 23:50:18','2021-05-24 23:50:18',NULL),(2190,3150,493,40734,18563,18,359,2,830.51,NULL,'2021-05-24 23:50:18','2021-05-24 23:50:18',NULL),(2194,3150,495,40736,21632,1,359,1,1500.30,NULL,'2021-05-24 23:52:26','2021-05-24 23:52:50','2021-05-24 23:52:50'),(2195,3150,495,40736,21632,1,384,2,1500.30,NULL,'2021-05-24 23:52:26','2021-05-24 23:52:50','2021-05-24 23:52:50'),(2196,3150,496,40736,21633,2,10,1,1000.00,NULL,'2021-05-24 23:52:26','2021-05-24 23:52:50','2021-05-24 23:52:50'),(2197,3150,496,40736,21633,2,359,1,500.00,NULL,'2021-05-24 23:52:26','2021-05-24 23:52:50','2021-05-24 23:52:50'),(2198,3150,496,40736,21633,2,13,2,1500.00,NULL,'2021-05-24 23:52:26','2021-05-24 23:52:50','2021-05-24 23:52:50'),(2199,3150,497,40734,18558,1,62,1,90000.00,NULL,'2021-05-24 23:52:34','2021-05-24 23:52:34',NULL),(2200,3150,497,40734,18558,1,498,2,33750.00,NULL,'2021-05-24 23:52:34','2021-05-24 23:52:34',NULL),(2201,3150,497,40734,18558,1,359,2,56250.00,NULL,'2021-05-24 23:52:34','2021-05-24 23:52:34',NULL),(2202,3150,498,40734,18553,21,57,2,4200.00,NULL,'2021-05-25 00:00:14','2021-05-25 00:00:14',NULL),(2203,3150,498,40734,18553,21,192,1,4200.00,NULL,'2021-05-25 00:00:14','2021-05-25 00:00:14',NULL),(2204,3150,499,40734,18552,23,204,1,530.26,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2205,3150,499,40734,18552,23,476,2,530.26,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2206,3150,500,40734,18552,23,110,1,19884.64,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2207,3150,500,40734,18552,23,476,2,19884.64,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2208,3150,501,40734,18552,23,396,1,2081.31,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2209,3150,501,40734,18552,23,476,2,2081.31,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2210,3150,502,40734,18552,23,191,1,3038.77,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2211,3150,502,40734,18552,23,476,2,3038.77,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2212,3150,503,40734,18552,23,192,1,1391.92,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2213,3150,503,40734,18552,23,476,2,1391.92,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2214,3150,504,40734,18553,23,191,1,2797.80,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2215,3150,504,40734,18553,23,476,2,2797.80,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL);
INSERT INTO `balance_libro_details` VALUES (2216,3150,505,40734,18553,23,192,1,1281.55,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2217,3150,505,40734,18553,23,476,2,1281.55,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2218,3150,506,40734,18553,23,110,1,18307.81,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2219,3150,506,40734,18553,23,476,2,18307.81,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2220,3150,507,40734,18553,23,396,1,1931.76,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2221,3150,507,40734,18553,23,476,2,1931.76,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2222,3150,508,40734,18554,23,191,1,2410.63,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2223,3150,508,40734,18554,23,476,2,2410.63,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2224,3150,509,40734,18554,23,155,1,1.04,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2225,3150,509,40734,18554,23,476,2,1.04,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2226,3150,510,40734,18554,23,126,1,5325.41,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2227,3150,510,40734,18554,23,476,2,5325.41,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2228,3150,511,40734,18554,23,110,1,15774.32,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2229,3150,511,40734,18554,23,476,2,15774.32,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2230,3150,512,40734,18554,23,396,1,1694.86,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2231,3150,512,40734,18554,23,476,2,1694.86,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2232,3150,513,40734,18555,23,110,1,14657.02,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2233,3150,513,40734,18555,23,476,2,14657.02,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2234,3150,514,40734,18555,23,498,2,8244.57,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2235,3150,514,40734,18555,23,476,1,8244.57,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2236,3150,515,40734,18555,23,192,1,1343.56,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2237,3150,515,40734,18555,23,476,2,1343.56,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2238,3150,516,40734,18555,23,191,1,2085.99,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2239,3150,516,40734,18555,23,476,2,2085.99,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2240,3150,517,40734,18555,23,396,1,1602.39,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2241,3150,517,40734,18555,23,476,2,1602.39,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2242,3150,518,40734,18556,23,191,1,2066.55,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2243,3150,518,40734,18556,23,476,2,2066.55,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2244,3150,519,40734,18556,23,396,1,1503.58,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2245,3150,519,40734,18556,23,476,2,1503.58,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2246,3150,520,40734,18556,23,498,2,7606.55,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2247,3150,520,40734,18556,23,476,1,7606.55,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2248,3150,521,40734,18556,23,155,1,50665.09,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2249,3150,521,40734,18556,23,476,2,50665.09,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2250,3150,522,40734,18556,23,192,1,1300.44,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2251,3150,522,40734,18556,23,476,2,1300.44,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2252,3150,523,40734,18556,23,110,1,13522.76,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2253,3150,523,40734,18556,23,476,2,13522.76,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2254,3150,524,40734,18557,23,498,2,6699.06,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2255,3150,524,40734,18557,23,476,1,6699.06,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL);
INSERT INTO `balance_libro_details` VALUES (2256,3150,525,40734,18557,23,110,1,17864.16,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2257,3150,525,40734,18557,23,476,2,17864.16,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2258,3150,526,40734,18557,23,191,1,2729.84,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2259,3150,526,40734,18557,23,476,2,2729.84,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2260,3150,527,40734,18557,23,396,1,1349.91,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2261,3150,527,40734,18557,23,476,2,1349.91,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2262,3150,528,40734,18558,23,191,1,1611.48,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2263,3150,528,40734,18558,23,476,2,1611.48,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2264,3150,529,40734,18558,23,192,1,878.75,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2265,3150,529,40734,18558,23,476,2,878.75,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2266,3150,530,40734,18558,23,396,1,1218.01,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2267,3150,530,40734,18558,23,476,2,1218.01,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2268,3150,531,40734,18558,23,110,1,10544.96,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2269,3150,531,40734,18558,23,476,2,10544.96,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2270,3150,532,40734,18558,23,498,2,5931.54,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2271,3150,532,40734,18558,23,476,1,5931.54,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2272,3150,533,40734,18559,23,110,1,8690.25,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2273,3150,533,40734,18559,23,476,2,8690.25,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2274,3150,534,40734,18559,23,191,1,1328.04,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2275,3150,534,40734,18559,23,476,2,1328.04,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2276,3150,535,40734,18559,23,192,1,796.61,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2277,3150,535,40734,18559,23,476,2,796.61,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2278,3150,536,40734,18559,23,396,1,1019.60,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2279,3150,536,40734,18559,23,476,2,1019.60,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2280,3150,537,40734,18560,23,192,1,622.99,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2281,3150,537,40734,18560,23,476,2,622.99,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2282,3150,538,40734,18560,23,396,1,808.89,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2283,3150,538,40734,18560,23,476,2,808.89,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2284,3150,539,40734,18560,23,110,1,6796.23,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2285,3150,539,40734,18560,23,476,2,6796.23,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2286,3150,540,40734,18560,23,498,2,3822.88,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2287,3150,540,40734,18560,23,476,1,3822.88,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2288,3150,541,40734,18560,23,191,1,1038.60,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2289,3150,541,40734,18560,23,476,2,1038.60,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2290,3150,542,40734,18561,23,191,1,668.60,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2291,3150,542,40734,18561,23,476,2,668.60,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2292,3150,543,40734,18561,23,192,1,401.05,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2293,3150,543,40734,18561,23,476,2,401.05,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2294,3150,544,40734,18561,23,396,1,535.91,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2295,3150,544,40734,18561,23,476,2,535.91,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL);
INSERT INTO `balance_libro_details` VALUES (2296,3150,545,40734,18561,23,110,1,4375.10,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2297,3150,545,40734,18561,23,476,2,4375.10,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2298,3150,546,40734,18562,23,192,1,220.31,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2299,3150,546,40734,18562,23,476,2,220.31,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2300,3150,547,40734,18562,23,396,1,331.32,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2301,3150,547,40734,18562,23,476,2,331.32,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2302,3150,548,40734,18562,23,110,1,2403.34,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2303,3150,548,40734,18562,23,476,2,2403.34,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2304,3150,549,40734,18562,23,191,1,367.28,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2305,3150,549,40734,18562,23,476,2,367.28,NULL,'2021-05-25 00:01:25','2021-05-25 00:01:25',NULL),(2306,3150,550,40734,18563,23,426,2,630191.15,NULL,'2021-05-25 00:02:50','2021-05-25 00:02:50',NULL),(2307,3150,550,40734,18563,23,88,2,3976.93,NULL,'2021-05-25 00:02:50','2021-05-25 00:02:50',NULL),(2308,3150,550,40734,18563,23,91,2,62784.18,NULL,'2021-05-25 00:02:50','2021-05-25 00:02:50',NULL),(2309,3150,550,40734,18563,23,381,2,15360.97,NULL,'2021-05-25 00:02:50','2021-05-25 00:02:50',NULL),(2310,3150,550,40734,18563,23,92,1,614947.51,NULL,'2021-05-25 00:02:50','2021-05-25 00:02:50',NULL),(2311,3150,550,40734,18563,23,476,1,97365.72,NULL,'2021-05-25 00:02:50','2021-05-25 00:02:50',NULL),(2312,3150,551,40734,18563,19,384,1,505000.00,NULL,'2021-05-25 00:17:16','2021-05-25 00:17:16',NULL),(2313,3150,551,40734,18563,19,103,2,505000.00,NULL,'2021-05-25 00:17:16','2021-05-25 00:17:16',NULL),(2314,3150,552,40734,18553,2,359,1,170162.60,NULL,'2021-05-25 00:29:55','2021-05-25 00:29:55',NULL),(2315,3150,552,40734,18553,2,13,2,170162.60,NULL,'2021-05-25 00:29:55','2021-05-25 00:29:55',NULL),(2316,3150,553,40734,18563,21,57,1,11000.00,NULL,'2021-05-25 00:31:02','2021-05-25 00:31:02',NULL),(2317,3150,553,40734,18563,21,58,1,4200.00,NULL,'2021-05-25 00:31:02','2021-05-25 00:31:02',NULL),(2318,3150,553,40734,18563,21,359,2,15200.00,NULL,'2021-05-25 00:31:02','2021-05-25 00:31:02',NULL),(2319,3150,554,40734,18563,23,476,1,936553.21,NULL,'2021-05-25 00:44:48','2021-05-25 00:44:48',NULL),(2320,3150,554,40734,18563,23,92,2,936553.21,NULL,'2021-05-25 00:44:48','2021-05-25 00:44:48',NULL),(2321,3150,555,40736,21639,12,92,2,2400737.07,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2322,3150,555,40736,21639,12,359,1,415385.50,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2323,3150,555,40736,21639,12,10,1,177663.19,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2324,3150,555,40736,21639,12,353,1,306581.87,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2325,3150,555,40736,21639,12,354,1,30166.39,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2326,3150,555,40736,21639,12,492,1,23908.27,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2327,3150,555,40736,21639,12,494,1,311965.32,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2328,3150,555,40736,21639,12,503,1,7316.37,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2329,3150,555,40736,21639,12,455,1,156627.76,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2330,3150,555,40736,21639,12,368,1,140440.66,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2331,3150,555,40736,21639,12,78,2,74613.59,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2332,3150,555,40736,21639,12,495,2,13353.48,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2333,3150,555,40736,21639,12,63,2,1422.80,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47');
INSERT INTO `balance_libro_details` VALUES (2334,3150,555,40736,21639,12,369,2,20000.00,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2335,3150,555,40736,21639,12,88,2,107576.12,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2336,3150,555,40736,21639,12,381,2,9085.07,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2337,3150,555,40736,21639,12,426,2,784186.67,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2338,3150,555,40736,21639,12,91,1,1840919.47,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2339,3150,556,40736,21639,2,13,1,785821.08,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2340,3150,556,40736,21639,2,96,2,764294.52,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2341,3150,556,40736,21639,2,67,2,21526.56,NULL,'2021-05-26 11:41:25','2021-05-26 11:41:47','2021-05-26 11:41:47'),(2342,3150,557,40720,1551,18,21,1,21130.72,NULL,'2021-05-28 21:21:49','2021-05-28 21:21:49',NULL),(2343,3150,557,40720,1551,18,252,2,20236.91,NULL,'2021-05-28 21:21:49','2021-05-28 21:21:49',NULL),(2344,3150,557,40720,1551,18,156,2,893.81,NULL,'2021-05-28 21:21:49','2021-05-28 21:21:49',NULL),(2345,3150,558,40720,1537,19,487,1,12475.29,NULL,'2021-05-28 21:29:01','2021-05-28 21:29:01',NULL),(2346,3150,558,40720,1537,19,486,2,15634.36,NULL,'2021-05-28 21:29:01','2021-05-28 21:29:01',NULL),(2347,3150,558,40720,1537,19,359,1,3159.07,NULL,'2021-05-28 21:29:01','2021-05-28 21:29:01',NULL),(2348,3150,559,40720,1551,19,392,1,4656.40,NULL,'2021-05-28 21:32:35','2021-05-28 21:32:35',NULL),(2349,3150,559,40720,1551,19,508,2,4656.40,NULL,'2021-05-28 21:32:35','2021-05-28 21:32:35',NULL),(2350,3150,560,40720,1537,19,367,1,149000.00,NULL,'2021-05-28 21:36:35','2021-05-28 21:36:35',NULL),(2351,3150,560,40720,1537,19,359,2,149000.00,NULL,'2021-05-28 21:36:35','2021-05-28 21:36:35',NULL),(2360,3150,565,40720,1537,1,62,1,58429.00,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2361,3150,565,40720,1537,1,359,2,58429.00,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2362,3150,566,40720,1538,1,62,1,215035.25,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2363,3150,566,40720,1538,1,359,2,215035.25,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2364,3150,567,40720,1539,1,62,1,194235.56,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2365,3150,567,40720,1539,1,359,2,194235.56,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2366,3150,568,40720,1540,1,62,1,234386.60,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2367,3150,568,40720,1540,1,359,2,234386.60,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2368,3150,569,40720,1541,1,62,1,223902.60,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2369,3150,569,40720,1541,1,359,2,223902.60,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2370,3150,570,40720,1545,1,62,1,303241.49,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2371,3150,570,40720,1545,1,359,2,303241.49,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2372,3150,571,40720,1546,1,62,1,224451.83,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2373,3150,571,40720,1546,1,359,2,224451.83,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2374,3150,572,40720,1547,1,62,1,199266.46,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2375,3150,572,40720,1547,1,359,2,199266.46,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2376,3150,573,40720,1548,1,62,1,217861.57,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2377,3150,573,40720,1548,1,359,2,217861.57,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2378,3150,574,40720,1549,1,62,1,260601.31,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2379,3150,574,40720,1549,1,359,2,260601.31,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2380,3150,575,40720,1550,1,62,1,248395.84,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL);
INSERT INTO `balance_libro_details` VALUES (2381,3150,575,40720,1550,1,359,2,248395.84,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2382,3150,576,40720,1551,1,62,1,445604.98,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2383,3150,576,40720,1551,1,359,2,445604.98,NULL,'2021-05-28 21:58:20','2021-05-28 21:58:20',NULL),(2384,3150,577,40720,1547,21,63,1,110271.09,NULL,'2021-05-28 22:02:40','2021-05-28 22:02:40',NULL),(2385,3150,577,40720,1547,21,359,2,110271.09,NULL,'2021-05-28 22:02:40','2021-05-28 22:02:40',NULL),(2386,3150,578,40720,1537,1,64,1,6814.03,NULL,'2021-05-28 22:04:36','2021-05-28 22:04:36',NULL),(2387,3150,578,40720,1537,1,359,2,6814.03,NULL,'2021-05-28 22:04:36','2021-05-28 22:04:36',NULL),(2388,3150,579,40720,1537,1,488,1,1000.00,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2389,3150,579,40720,1537,1,359,2,1000.00,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2390,3150,580,40720,1538,1,488,1,6596.17,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2391,3150,580,40720,1538,1,359,2,6596.17,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2392,3150,581,40720,1539,1,488,1,5958.15,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2393,3150,581,40720,1539,1,359,2,5958.15,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2394,3150,582,40720,1540,1,488,1,7189.77,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2395,3150,582,40720,1540,1,359,2,7189.77,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2396,3150,583,40720,1541,1,488,1,6177.99,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2397,3150,583,40720,1541,1,359,2,6177.99,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2398,3150,584,40720,1545,1,488,1,9301.89,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2399,3150,584,40720,1545,1,359,2,9301.89,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2400,3150,585,40720,1546,1,488,1,6189.32,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2401,3150,585,40720,1546,1,359,2,6189.32,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2402,3150,586,40720,1547,1,488,1,6112.47,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2403,3150,586,40720,1547,1,359,2,6112.47,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2404,3150,587,40720,1548,1,488,1,6682.87,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2405,3150,587,40720,1548,1,359,2,6682.87,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2406,3150,588,40720,1549,1,488,1,7993.91,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2407,3150,588,40720,1549,1,359,2,7993.91,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2408,3150,589,40720,1550,1,488,1,7619.50,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2409,3150,589,40720,1550,1,359,2,7619.50,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2410,3150,590,40720,1551,1,488,1,12564.57,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2411,3150,590,40720,1551,1,359,2,12564.57,NULL,'2021-05-28 22:09:55','2021-05-28 22:09:55',NULL),(2412,3150,591,40720,1537,1,489,1,2706.00,NULL,'2021-05-28 22:16:39','2021-05-28 22:16:39',NULL),(2413,3150,591,40720,1537,1,359,2,2706.00,NULL,'2021-05-28 22:16:39','2021-05-28 22:16:39',NULL),(2414,3150,592,40720,1537,19,490,1,815299.00,NULL,'2021-05-28 22:19:09','2021-05-28 23:13:23','2021-05-28 23:13:23'),(2415,3150,592,40720,1537,19,110,2,815299.00,NULL,'2021-05-28 22:19:09','2021-05-28 23:13:23','2021-05-28 23:13:23'),(2416,3150,593,40720,1537,6,20,1,259997.50,NULL,'2021-05-28 22:40:06','2021-05-28 22:40:06',NULL),(2417,3150,593,40720,1537,6,359,2,259997.50,NULL,'2021-05-28 22:40:06','2021-05-28 22:40:06',NULL),(2418,3150,594,40720,1538,6,20,1,25996.63,NULL,'2021-05-28 22:40:50','2021-05-28 22:40:50',NULL),(2419,3150,594,40720,1538,6,359,2,25996.63,NULL,'2021-05-28 22:40:50','2021-05-28 22:40:50',NULL),(2420,3150,595,40720,1539,6,20,1,25996.63,NULL,'2021-05-28 22:41:36','2021-05-28 22:41:36',NULL);
INSERT INTO `balance_libro_details` VALUES (2421,3150,595,40720,1539,6,359,2,25996.63,NULL,'2021-05-28 22:41:36','2021-05-28 22:41:36',NULL),(2422,3150,596,40720,1540,6,20,1,25996.63,NULL,'2021-05-28 22:42:18','2021-05-28 22:42:18',NULL),(2423,3150,596,40720,1540,6,359,2,25996.63,NULL,'2021-05-28 22:42:18','2021-05-28 22:42:18',NULL),(2424,3150,597,40720,1541,6,155,1,307031.15,NULL,'2021-05-28 22:44:17','2021-05-28 23:14:31','2021-05-28 23:14:31'),(2425,3150,597,40720,1541,6,493,2,311990.76,NULL,'2021-05-28 22:44:17','2021-05-28 23:14:31','2021-05-28 23:14:31'),(2426,3150,597,40720,1541,6,24,1,4959.61,NULL,'2021-05-28 22:44:17','2021-05-28 23:14:31','2021-05-28 23:14:31'),(2427,3150,598,40720,1536,19,473,2,29764.00,NULL,'2021-05-28 23:10:52','2021-05-28 23:30:01','2021-05-28 23:30:01'),(2428,3150,598,40720,1536,19,78,1,8001.57,NULL,'2021-05-28 23:10:52','2021-05-28 23:30:01','2021-05-28 23:30:01'),(2429,3150,598,40720,1536,19,365,1,60000.00,NULL,'2021-05-28 23:10:52','2021-05-28 23:30:01','2021-05-28 23:30:01'),(2430,3150,598,40720,1536,19,192,2,60000.00,NULL,'2021-05-28 23:10:52','2021-05-28 23:30:01','2021-05-28 23:30:01'),(2431,3150,598,40720,1536,19,359,1,21762.43,NULL,'2021-05-28 23:10:52','2021-05-28 23:30:01','2021-05-28 23:30:01'),(2432,3150,599,40720,1537,19,490,1,815299.00,NULL,'2021-05-28 23:13:23','2021-05-28 23:13:23',NULL),(2433,3150,599,40720,1537,19,110,2,815299.00,NULL,'2021-05-28 23:13:23','2021-05-28 23:13:23',NULL),(2434,3150,600,40720,1541,6,155,1,307031.15,NULL,'2021-05-28 23:14:31','2021-05-28 23:23:25','2021-05-28 23:23:25'),(2435,3150,600,40720,1541,6,493,2,311990.76,NULL,'2021-05-28 23:14:31','2021-05-28 23:23:25','2021-05-28 23:23:25'),(2436,3150,600,40720,1541,6,24,1,4959.61,NULL,'2021-05-28 23:14:31','2021-05-28 23:23:25','2021-05-28 23:23:25'),(2437,3150,601,40720,1541,18,359,1,337987.40,NULL,'2021-05-28 23:20:50','2021-05-28 23:24:44','2021-05-28 23:24:44'),(2438,3150,601,40720,1541,18,20,2,337987.40,NULL,'2021-05-28 23:20:50','2021-05-28 23:24:44','2021-05-28 23:24:44'),(2439,3150,602,40720,1541,6,155,1,307031.15,NULL,'2021-05-28 23:23:25','2021-05-28 23:23:25',NULL),(2440,3150,602,40720,1541,6,24,1,4959.61,NULL,'2021-05-28 23:23:25','2021-05-28 23:23:25',NULL),(2441,3150,602,40720,1541,6,20,2,311990.76,NULL,'2021-05-28 23:23:25','2021-05-28 23:23:25',NULL),(2442,3150,603,40720,1541,18,359,1,25996.64,NULL,'2021-05-28 23:24:44','2021-05-28 23:25:57','2021-05-28 23:25:57'),(2443,3150,603,40720,1541,18,20,2,25996.64,NULL,'2021-05-28 23:24:44','2021-05-28 23:25:57','2021-05-28 23:25:57'),(2444,3150,604,40720,1541,18,359,1,25996.63,NULL,'2021-05-28 23:25:57','2021-05-28 23:25:57',NULL),(2445,3150,604,40720,1541,18,20,2,25996.63,NULL,'2021-05-28 23:25:57','2021-05-28 23:25:57',NULL),(2446,3150,605,40720,1541,6,411,1,212710.03,NULL,'2021-05-28 23:28:33','2021-05-28 23:28:33',NULL),(2447,3150,605,40720,1541,6,155,2,212710.03,NULL,'2021-05-28 23:28:33','2021-05-28 23:28:33',NULL),(2448,3150,606,40720,1536,19,473,2,29764.00,NULL,'2021-05-28 23:30:01','2021-05-28 23:30:20','2021-05-28 23:30:20'),(2449,3150,606,40720,1536,19,78,1,8001.57,NULL,'2021-05-28 23:30:01','2021-05-28 23:30:20','2021-05-28 23:30:20'),(2450,3150,606,40720,1536,19,365,1,60000.00,NULL,'2021-05-28 23:30:01','2021-05-28 23:30:20','2021-05-28 23:30:20'),(2451,3150,606,40720,1536,19,192,2,60000.00,NULL,'2021-05-28 23:30:01','2021-05-28 23:30:20','2021-05-28 23:30:20'),(2452,3150,606,40720,1536,19,359,1,21762.43,NULL,'2021-05-28 23:30:01','2021-05-28 23:30:20','2021-05-28 23:30:20'),(2453,3150,607,40720,1537,19,473,2,29764.00,NULL,'2021-05-28 23:30:20','2021-05-28 23:30:20',NULL),(2454,3150,607,40720,1537,19,78,1,8001.57,NULL,'2021-05-28 23:30:20','2021-05-28 23:30:20',NULL),(2455,3150,607,40720,1537,19,365,1,60000.00,NULL,'2021-05-28 23:30:20','2021-05-28 23:30:20',NULL),(2456,3150,607,40720,1537,19,192,2,60000.00,NULL,'2021-05-28 23:30:20','2021-05-28 23:30:20',NULL),(2457,3150,607,40720,1537,19,359,1,21762.43,NULL,'2021-05-28 23:30:20','2021-05-28 23:30:20',NULL);
INSERT INTO `balance_libro_details` VALUES (2458,3150,608,40720,1537,19,435,1,1836.86,NULL,'2021-05-28 23:33:35','2021-05-28 23:33:35',NULL),(2459,3150,608,40720,1537,19,140,2,1836.86,NULL,'2021-05-28 23:33:35','2021-05-28 23:33:35',NULL),(2508,3150,633,40720,1537,20,359,1,300000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2509,3150,633,40720,1537,20,13,2,300000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2510,3150,634,40720,1538,20,359,1,200000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2511,3150,634,40720,1538,20,13,2,200000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2512,3150,635,40720,1539,20,359,1,200000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2513,3150,635,40720,1539,20,13,2,200000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2514,3150,636,40720,1540,20,359,1,280000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2515,3150,636,40720,1540,20,13,2,280000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2516,3150,637,40720,1541,20,359,1,200000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2517,3150,637,40720,1541,20,13,2,200000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2518,3150,638,40720,1545,20,359,1,300000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2519,3150,638,40720,1545,20,13,2,300000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2520,3150,639,40720,1546,20,359,1,450000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2521,3150,639,40720,1546,20,13,2,450000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2522,3150,640,40720,1547,20,359,1,100000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2523,3150,640,40720,1547,20,13,2,100000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2524,3150,641,40720,1548,20,359,1,250000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2525,3150,641,40720,1548,20,13,2,250000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2526,3150,642,40720,1549,20,359,1,250000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2527,3150,642,40720,1549,20,13,2,250000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2528,3150,643,40720,1550,20,359,1,250000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2529,3150,643,40720,1550,20,13,2,250000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2530,3150,644,40720,1551,20,359,1,460000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2531,3150,644,40720,1551,20,13,2,460000.00,NULL,'2021-05-28 23:47:23','2021-05-28 23:47:23',NULL),(2532,3150,645,40720,1537,21,57,1,450000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2533,3150,645,40720,1537,21,13,2,450000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2534,3150,646,40720,1538,21,57,1,400000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2535,3150,646,40720,1538,21,13,2,400000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2536,3150,647,40720,1539,21,57,1,500000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2537,3150,647,40720,1539,21,13,2,500000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2538,3150,648,40720,1540,21,57,1,500000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2539,3150,648,40720,1540,21,13,2,500000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2540,3150,649,40720,1541,21,57,1,550000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2541,3150,649,40720,1541,21,13,2,550000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2542,3150,650,40720,1545,21,57,1,700000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2543,3150,650,40720,1545,21,13,2,700000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2544,3150,651,40720,1546,21,57,1,500000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2545,3150,651,40720,1546,21,13,2,500000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL);
INSERT INTO `balance_libro_details` VALUES (2546,3150,652,40720,1547,21,57,1,650000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2547,3150,652,40720,1547,21,13,2,650000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2548,3150,653,40720,1548,21,57,1,700000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2549,3150,653,40720,1548,21,13,2,700000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2550,3150,654,40720,1549,21,57,1,500000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2551,3150,654,40720,1549,21,13,2,500000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2552,3150,655,40720,1551,21,57,1,800000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2553,3150,655,40720,1551,21,13,2,800000.00,NULL,'2021-05-29 00:03:38','2021-05-29 00:03:38',NULL),(2631,3150,672,40736,21639,12,92,2,2400737.07,NULL,'2021-05-30 15:55:53','2022-05-04 15:04:19','2022-05-04 15:04:19'),(2632,3150,672,40736,21639,12,359,1,415385.50,NULL,'2021-05-30 15:55:53','2022-05-04 15:04:19','2022-05-04 15:04:19'),(2633,3150,672,40736,21639,12,10,1,177663.19,NULL,'2021-05-30 15:55:53','2022-05-04 15:04:19','2022-05-04 15:04:19'),(2634,3150,672,40736,21639,12,353,1,306581.87,NULL,'2021-05-30 15:55:53','2022-05-04 15:04:19','2022-05-04 15:04:19'),(2635,3150,672,40736,21639,12,354,1,30166.39,NULL,'2021-05-30 15:55:53','2022-05-04 15:04:19','2022-05-04 15:04:19'),(2636,3150,672,40736,21639,12,492,1,23908.27,NULL,'2021-05-30 15:55:53','2022-05-04 15:04:19','2022-05-04 15:04:19'),(2637,3150,672,40736,21639,12,494,1,311965.32,NULL,'2021-05-30 15:55:53','2022-05-04 15:04:19','2022-05-04 15:04:19'),(2638,3150,672,40736,21639,12,503,1,7316.37,NULL,'2021-05-30 15:55:53','2022-05-04 15:04:19','2022-05-04 15:04:19'),(2639,3150,672,40736,21639,12,455,1,156627.76,NULL,'2021-05-30 15:55:53','2022-05-04 15:04:19','2022-05-04 15:04:19'),(2640,3150,672,40736,21639,12,368,1,140440.66,NULL,'2021-05-30 15:55:53','2022-05-04 15:04:19','2022-05-04 15:04:19'),(2641,3150,672,40736,21639,12,78,2,74613.59,NULL,'2021-05-30 15:55:53','2022-05-04 15:04:19','2022-05-04 15:04:19'),(2642,3150,672,40736,21639,12,495,2,13353.48,NULL,'2021-05-30 15:55:53','2022-05-04 15:04:19','2022-05-04 15:04:19'),(2643,3150,672,40736,21639,12,63,2,1422.80,NULL,'2021-05-30 15:55:53','2022-05-04 15:04:19','2022-05-04 15:04:19'),(2644,3150,672,40736,21639,12,369,2,20000.00,NULL,'2021-05-30 15:55:53','2022-05-04 15:04:19','2022-05-04 15:04:19'),(2645,3150,672,40736,21639,12,88,2,107576.12,NULL,'2021-05-30 15:55:53','2022-05-04 15:04:19','2022-05-04 15:04:19'),(2646,3150,672,40736,21639,12,381,2,9085.07,NULL,'2021-05-30 15:55:53','2022-05-04 15:04:19','2022-05-04 15:04:19'),(2647,3150,672,40736,21639,12,426,2,784186.67,NULL,'2021-05-30 15:55:53','2022-05-04 15:04:19','2022-05-04 15:04:19'),(2648,3150,672,40736,21639,12,91,1,1840919.47,NULL,'2021-05-30 15:55:53','2022-05-04 15:04:19','2022-05-04 15:04:19'),(2649,3150,673,40736,21639,2,13,1,785821.08,NULL,'2021-05-30 15:55:53','2021-06-01 13:21:22','2021-06-01 13:21:22'),(2650,3150,673,40736,21639,2,96,2,764294.52,NULL,'2021-05-30 15:55:53','2021-06-01 13:21:22','2021-06-01 13:21:22'),(2651,3150,673,40736,21639,2,67,2,21526.56,NULL,'2021-05-30 15:55:53','2021-06-01 13:21:22','2021-06-01 13:21:22'),(2652,3150,674,40736,21639,15,67,1,21526.56,NULL,'2021-05-30 15:55:53','2021-06-01 15:53:01','2021-06-01 15:53:01'),(2653,3150,674,40736,21639,15,68,2,16225.97,NULL,'2021-05-30 15:55:53','2021-06-01 15:53:01','2021-06-01 15:53:01'),(2654,3150,674,40736,21639,15,353,2,306581.87,NULL,'2021-05-30 15:55:53','2021-06-01 15:53:01','2021-06-01 15:53:01'),(2655,3150,674,40736,21639,15,354,2,30166.39,NULL,'2021-05-30 15:55:53','2021-06-01 15:53:01','2021-06-01 15:53:01'),(2656,3150,674,40736,21639,15,513,2,1918.82,NULL,'2021-05-30 15:55:53','2021-06-01 15:53:01','2021-06-01 15:53:01'),(2657,3150,674,40736,21639,15,73,1,301281.28,NULL,'2021-05-30 15:55:53','2021-06-01 15:53:01','2021-06-01 15:53:01');
INSERT INTO `balance_libro_details` VALUES (2658,3150,674,40736,21639,15,73,1,32085.21,NULL,'2021-05-30 15:55:53','2021-06-01 15:53:01','2021-06-01 15:53:01'),(2659,3150,675,40736,21639,5,396,1,1390.46,NULL,'2021-05-30 15:55:53','2021-05-30 22:58:17','2021-05-30 22:58:17'),(2660,3150,675,40736,21639,5,492,1,4716.77,NULL,'2021-05-30 15:55:53','2021-05-30 22:58:17','2021-05-30 22:58:17'),(2661,3150,675,40736,21639,5,140,1,37.90,NULL,'2021-05-30 15:55:53','2021-05-30 22:58:17','2021-05-30 22:58:17'),(2662,3150,675,40736,21639,5,57,1,306871.77,NULL,'2021-05-30 15:55:53','2021-05-30 22:58:17','2021-05-30 22:58:17'),(2663,3150,675,40736,21639,5,13,2,306871.77,NULL,'2021-05-30 15:55:53','2021-05-30 22:58:17','2021-05-30 22:58:17'),(2664,3150,675,40736,21639,5,10,2,6145.13,NULL,'2021-05-30 15:55:53','2021-05-30 22:58:17','2021-05-30 22:58:17'),(2665,3150,676,40736,21639,1,110,1,20000.00,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2666,3150,676,40736,21639,1,191,1,654.69,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2667,3150,676,40736,21639,1,62,2,20000.00,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2668,3150,676,40736,21639,1,63,2,654.69,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2669,3150,677,40736,21639,16,156,1,7516.43,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2670,3150,677,40736,21639,16,21,2,489.34,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2671,3150,677,40736,21639,16,512,2,4490.43,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2672,3150,677,40736,21639,16,494,2,311965.32,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2673,3150,677,40736,21639,16,494,1,309428.66,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2674,3150,678,40736,21639,18,25,1,1061.97,NULL,'2021-05-30 15:55:53','2021-06-01 18:32:50','2021-06-01 18:32:50'),(2675,3150,678,40736,21639,18,513,1,856.85,NULL,'2021-05-30 15:55:53','2021-06-01 18:32:50','2021-06-01 18:32:50'),(2676,3150,678,40736,21639,18,57,2,1918.82,NULL,'2021-05-30 15:55:53','2021-06-01 18:32:50','2021-06-01 18:32:50'),(2677,3150,679,40736,21639,18,23,1,353.98,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2678,3150,679,40736,21639,18,13,2,353.98,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2679,3150,680,40736,21639,10,63,1,974.69,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2680,3150,680,40736,21639,10,57,2,974.69,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2681,3150,681,40736,21639,18,63,1,448.11,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2682,3150,681,40736,21639,18,359,2,448.11,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2683,3150,682,40736,21639,3,192,1,3500.00,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2684,3150,682,40736,21639,3,359,2,3500.00,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2685,3150,683,40736,21639,18,353,1,301281.28,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2686,3150,683,40736,21639,18,354,1,32085.21,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2687,3150,683,40736,21639,18,73,2,333366.49,NULL,'2021-05-30 15:55:53','2021-05-30 15:55:53',NULL),(2762,3150,701,40736,21640,2,13,1,963566.60,NULL,'2021-05-30 16:04:06','2021-06-01 13:25:49','2021-06-01 13:25:49'),(2763,3150,701,40736,21640,2,96,2,957359.10,NULL,'2021-05-30 16:04:06','2021-06-01 13:25:49','2021-06-01 13:25:49'),(2764,3150,701,40736,21640,2,67,2,6207.50,NULL,'2021-05-30 16:04:06','2021-06-01 13:25:49','2021-06-01 13:25:49'),(2765,3150,702,40736,21640,15,67,1,6207.50,NULL,'2021-05-30 16:04:06','2021-05-30 16:04:06',NULL),(2766,3150,702,40736,21640,15,68,2,3361.43,NULL,'2021-05-30 16:04:06','2021-05-30 16:04:06',NULL),(2767,3150,702,40736,21640,15,353,2,301281.28,NULL,'2021-05-30 16:04:06','2021-05-30 16:04:06',NULL),(2768,3150,702,40736,21640,15,354,2,32085.21,NULL,'2021-05-30 16:04:06','2021-05-30 16:04:06',NULL),(2769,3150,702,40736,21640,15,513,2,2289.14,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL);
INSERT INTO `balance_libro_details` VALUES (2770,3150,702,40736,21640,15,73,1,298435.21,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2771,3150,702,40736,21640,15,73,1,34374.35,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2772,3150,703,40736,21640,5,396,1,1438.74,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2773,3150,703,40736,21640,5,492,1,2083.19,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2774,3150,703,40736,21640,5,140,1,26.11,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2775,3150,703,40736,21640,5,57,1,161574.82,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2776,3150,703,40736,21640,5,13,2,161157.51,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2777,3150,703,40736,21640,5,10,2,3965.35,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2778,3150,704,40736,21640,1,110,1,20000.00,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2779,3150,704,40736,21640,1,191,1,654.69,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2780,3150,704,40736,21640,1,62,2,20000.00,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2781,3150,704,40736,21640,1,63,2,654.69,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2782,3150,705,40736,21640,16,156,1,1744.52,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2783,3150,705,40736,21640,16,21,2,592.64,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2784,3150,705,40736,21640,16,512,2,2611.27,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2785,3150,705,40736,21640,16,494,2,309428.66,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2786,3150,705,40736,21640,16,494,1,310888.05,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2787,3150,706,40736,21640,18,25,1,1284.51,NULL,'2021-05-30 16:04:07','2021-06-01 19:35:50','2021-06-01 19:35:50'),(2788,3150,706,40736,21640,18,513,1,4587.17,NULL,'2021-05-30 16:04:07','2021-06-01 19:35:50','2021-06-01 19:35:50'),(2789,3150,706,40736,21640,18,57,2,5871.68,NULL,'2021-05-30 16:04:07','2021-06-01 19:35:50','2021-06-01 19:35:50'),(2790,3150,707,40736,21640,22,359,1,23000.00,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2791,3150,707,40736,21640,22,57,2,23000.00,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2792,3150,708,40736,21640,18,514,1,3206.12,NULL,'2021-05-30 16:04:07','2021-06-01 19:12:23','2021-06-01 19:12:23'),(2793,3150,708,40736,21640,18,57,2,3206.12,NULL,'2021-05-30 16:04:07','2021-06-01 19:12:23','2021-06-01 19:12:23'),(2794,3150,709,40736,21640,18,23,1,376.42,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2795,3150,709,40736,21640,18,13,2,376.42,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2796,3150,710,40736,21640,10,63,1,654.69,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2797,3150,710,40736,21640,10,57,2,654.69,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2798,3150,711,40736,21640,1,62,1,20000.00,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2799,3150,711,40736,21640,1,359,2,20000.00,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2800,3150,712,40736,21640,3,192,1,3500.00,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2801,3150,712,40736,21640,3,359,2,3500.00,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2802,3150,713,40736,21640,18,353,1,298435.21,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2803,3150,713,40736,21640,18,354,1,34374.35,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2804,3150,713,40736,21640,18,73,2,332809.56,NULL,'2021-05-30 16:04:07','2021-05-30 16:04:07',NULL),(2824,3150,721,40736,21641,2,13,1,847789.16,NULL,'2021-05-30 17:06:56','2021-06-01 18:55:25','2021-06-01 18:55:25'),(2825,3150,721,40736,21641,2,96,2,845910.07,NULL,'2021-05-30 17:06:56','2021-06-01 18:55:25','2021-06-01 18:55:25'),(2826,3150,721,40736,21641,2,67,2,1879.09,NULL,'2021-05-30 17:06:56','2021-06-01 18:55:25','2021-06-01 18:55:25'),(2827,3150,722,40736,21641,15,67,1,1879.09,NULL,'2021-05-30 17:10:23','2021-05-30 17:10:23',NULL);
INSERT INTO `balance_libro_details` VALUES (2828,3150,722,40736,21641,15,68,2,7029.03,NULL,'2021-05-30 17:10:23','2021-05-30 17:10:23',NULL),(2829,3150,722,40736,21641,15,353,2,298435.21,NULL,'2021-05-30 17:10:23','2021-05-30 17:10:23',NULL),(2830,3150,722,40736,21641,15,354,2,34374.35,NULL,'2021-05-30 17:10:23','2021-05-30 17:10:23',NULL),(2831,3150,722,40736,21641,15,25,2,175.63,NULL,'2021-05-30 17:10:23','2021-05-30 17:10:23',NULL),(2832,3150,722,40736,21641,15,513,2,681.02,NULL,'2021-05-30 17:10:23','2021-05-30 17:10:23',NULL),(2833,3150,722,40736,21641,15,73,1,303585.15,NULL,'2021-05-30 17:10:23','2021-05-30 17:10:23',NULL),(2834,3150,722,40736,21641,15,73,1,35231.00,NULL,'2021-05-30 17:10:23','2021-05-30 17:10:23',NULL),(2835,3150,723,40736,21641,1,110,1,20000.00,NULL,'2021-05-30 17:11:22','2021-05-30 17:11:22',NULL),(2836,3150,723,40736,21641,1,191,1,659.63,NULL,'2021-05-30 17:11:22','2021-05-30 17:11:22',NULL),(2837,3150,723,40736,21641,1,62,2,20000.00,NULL,'2021-05-30 17:11:22','2021-05-30 17:11:22',NULL),(2838,3150,723,40736,21641,1,63,2,659.63,NULL,'2021-05-30 17:11:22','2021-05-30 17:11:22',NULL),(2839,3150,724,40736,21641,18,25,1,175.63,NULL,'2021-05-30 17:12:46','2021-05-31 14:45:49','2021-05-31 14:45:49'),(2840,3150,724,40736,21641,18,58,2,175.63,NULL,'2021-05-30 17:12:46','2021-05-31 14:45:49','2021-05-31 14:45:49'),(2841,3150,725,40736,21641,18,513,1,681.02,NULL,'2021-05-30 17:13:32','2021-06-01 17:05:56','2021-06-01 17:05:56'),(2842,3150,725,40736,21641,18,13,2,681.02,NULL,'2021-05-30 17:13:32','2021-06-01 17:05:56','2021-06-01 17:05:56'),(2844,3150,727,40736,21641,18,359,1,71000.00,NULL,'2021-05-30 17:20:07','2021-05-30 17:20:07',NULL),(2845,3150,727,40736,21641,18,13,2,71000.00,NULL,'2021-05-30 17:20:07','2021-05-30 17:20:07',NULL),(2846,3150,728,40736,21641,1,62,1,20000.00,NULL,'2021-05-30 17:22:00','2021-05-30 17:23:27','2021-05-30 17:23:27'),(2847,3150,728,40736,21641,1,359,2,20000.00,NULL,'2021-05-30 17:22:00','2021-05-30 17:23:27','2021-05-30 17:23:27'),(2848,3150,729,40736,21641,21,62,1,20000.00,NULL,'2021-05-30 17:23:27','2021-05-30 17:23:27',NULL),(2849,3150,729,40736,21641,21,359,2,20000.00,NULL,'2021-05-30 17:23:27','2021-05-30 17:23:27',NULL),(2850,3150,730,40736,21641,3,135,1,4118.00,NULL,'2021-05-30 17:25:33','2021-05-30 18:54:32','2021-05-30 18:54:32'),(2851,3150,730,40736,21641,3,192,1,4550.00,NULL,'2021-05-30 17:25:33','2021-05-30 18:54:32','2021-05-30 18:54:32'),(2852,3150,730,40736,21641,3,477,2,8668.00,NULL,'2021-05-30 17:25:33','2021-05-30 18:54:32','2021-05-30 18:54:32'),(2853,3150,731,40736,21641,18,353,1,338816.15,NULL,'2021-05-30 17:27:47','2021-05-30 17:27:47',NULL),(2854,3150,731,40736,21641,18,354,1,35231.00,NULL,'2021-05-30 17:27:47','2021-05-30 17:27:47',NULL),(2855,3150,731,40736,21641,18,73,2,374047.15,NULL,'2021-05-30 17:27:47','2021-05-30 17:27:47',NULL),(2858,3150,733,40736,21642,15,353,2,35231.00,NULL,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(2859,3150,733,40736,21642,15,513,1,1131.40,NULL,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(2860,3150,733,40736,21642,15,73,1,34099.60,NULL,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(2861,3150,734,40736,21642,5,396,1,1394.78,NULL,'2021-05-30 17:49:13','2021-05-31 14:24:50','2021-05-31 14:24:50'),(2862,3150,734,40736,21642,5,492,1,1883.43,NULL,'2021-05-30 17:49:13','2021-05-31 14:24:50','2021-05-31 14:24:50'),(2863,3150,734,40736,21642,5,140,1,73.23,NULL,'2021-05-30 17:49:13','2021-05-31 14:24:50','2021-05-31 14:24:50'),(2864,3150,734,40736,21642,5,57,1,162128.40,NULL,'2021-05-30 17:49:13','2021-05-31 14:24:50','2021-05-31 14:24:50'),(2865,3150,734,40736,21642,5,13,2,166306.79,NULL,'2021-05-30 17:49:13','2021-05-31 14:24:50','2021-05-31 14:24:50'),(2866,3150,734,40736,21642,5,1,1,826.95,NULL,'2021-05-30 17:49:13','2021-05-31 14:24:50','2021-05-31 14:24:50'),(2867,3150,735,40736,21642,1,62,1,20000.00,NULL,'2021-05-30 17:49:13','2021-05-31 14:51:43','2021-05-31 14:51:43');
INSERT INTO `balance_libro_details` VALUES (2868,3150,735,40736,21642,1,489,2,16600.00,NULL,'2021-05-30 17:49:13','2021-05-31 14:51:43','2021-05-31 14:51:43'),(2869,3150,735,40736,21642,1,359,2,3400.00,NULL,'2021-05-30 17:49:13','2021-05-31 14:51:43','2021-05-31 14:51:43'),(2870,3150,736,40736,21642,18,513,2,1131.40,NULL,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(2871,3150,736,40736,21642,18,57,1,1131.40,NULL,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(2872,3150,737,40736,21642,1,110,1,20000.00,NULL,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(2873,3150,737,40736,21642,1,191,1,659.63,NULL,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(2874,3150,737,40736,21642,1,62,2,20000.00,NULL,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(2875,3150,737,40736,21642,1,63,2,659.63,NULL,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(2876,3150,738,40736,21642,16,156,2,176.22,NULL,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(2877,3150,738,40736,21642,16,494,2,314954.32,NULL,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(2878,3150,738,40736,21642,16,494,1,315130.54,NULL,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(2879,3150,739,40736,21642,19,13,1,31000.00,NULL,'2021-05-30 17:49:13','2021-05-31 14:13:33','2021-05-31 14:13:33'),(2880,3150,739,40736,21642,19,368,2,31000.00,NULL,'2021-05-30 17:49:13','2021-05-31 14:13:33','2021-05-31 14:13:33'),(2881,3150,740,40736,21641,22,359,1,5000.00,NULL,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(2882,3150,740,40736,21641,22,57,2,5000.00,NULL,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(2883,3150,741,40736,21642,18,354,1,34099.60,NULL,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(2884,3150,741,40736,21642,18,73,2,34099.60,NULL,'2021-05-30 17:49:13','2021-05-30 17:49:13',NULL),(2885,3150,742,40736,21647,22,359,1,10000.00,NULL,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(2886,3150,742,40736,21647,22,57,2,10000.00,NULL,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(2887,3150,743,40736,21643,15,513,2,147.08,NULL,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(2888,3150,743,40736,21643,15,354,2,34099.60,NULL,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(2889,3150,743,40736,21643,15,73,1,34246.68,NULL,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(2890,3150,744,40736,21643,5,396,1,1386.00,NULL,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(2891,3150,744,40736,21643,5,492,1,773.34,NULL,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(2892,3150,744,40736,21643,5,140,1,0.03,NULL,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(2893,3150,744,40736,21643,5,57,1,62953.20,NULL,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(2894,3150,744,40736,21643,5,13,2,64550.44,NULL,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(2895,3150,744,40736,21643,5,10,2,562.13,NULL,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(2896,3150,745,40736,21643,1,62,1,20000.00,NULL,'2021-05-30 17:52:08','2021-05-31 14:51:24','2021-05-31 14:51:24'),(2897,3150,745,40736,21643,1,489,2,16600.00,NULL,'2021-05-30 17:52:08','2021-05-31 14:51:24','2021-05-31 14:51:24'),(2898,3150,745,40736,21643,1,359,2,3400.00,NULL,'2021-05-30 17:52:08','2021-05-31 14:51:24','2021-05-31 14:51:24'),(2899,3150,746,40736,21643,1,110,1,30000.00,NULL,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(2900,3150,746,40736,21643,1,191,1,979.63,NULL,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(2901,3150,746,40736,21643,1,62,2,30000.00,NULL,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(2902,3150,746,40736,21643,1,63,2,979.63,NULL,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(2903,3150,747,40736,21643,21,513,1,147.08,NULL,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(2904,3150,747,40736,21643,21,57,2,147.08,NULL,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(2905,3150,748,40736,21643,19,13,1,1000.00,NULL,'2021-05-30 17:52:08','2021-05-31 14:28:15','2021-05-31 14:28:15'),(2906,3150,748,40736,21643,19,368,2,1000.00,NULL,'2021-05-30 17:52:08','2021-05-31 14:28:15','2021-05-31 14:28:15');
INSERT INTO `balance_libro_details` VALUES (2907,3150,749,40736,21643,18,354,1,34246.68,NULL,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(2908,3150,749,40736,21643,18,73,2,34246.68,NULL,'2021-05-30 17:52:08','2021-05-30 17:52:08',NULL),(2909,3150,750,40736,21644,15,513,2,157.43,NULL,'2021-05-30 17:53:01','2021-05-30 17:53:01',NULL),(2910,3150,750,40736,21644,15,354,2,34246.68,NULL,'2021-05-30 17:53:01','2021-05-30 17:53:01',NULL),(2911,3150,750,40736,21644,15,73,1,34404.11,NULL,'2021-05-30 17:53:01','2021-05-30 17:53:01',NULL),(2912,3150,751,40736,21644,5,396,1,1395.30,NULL,'2021-05-30 17:53:01','2021-05-30 23:10:10','2021-05-30 23:10:10'),(2913,3150,751,40736,21644,5,492,1,29.46,NULL,'2021-05-30 17:53:01','2021-05-30 23:10:10','2021-05-30 23:10:10'),(2914,3150,751,40736,21644,5,140,1,7694.00,NULL,'2021-05-30 17:53:01','2021-05-30 23:10:10','2021-05-30 23:10:10'),(2915,3150,751,40736,21644,5,57,1,2085.35,NULL,'2021-05-30 17:53:01','2021-05-30 23:10:10','2021-05-30 23:10:10'),(2916,3150,751,40736,21644,5,13,2,1350.00,NULL,'2021-05-30 17:53:01','2021-05-30 23:10:10','2021-05-30 23:10:10'),(2917,3150,751,40736,21644,5,10,2,9854.11,NULL,'2021-05-30 17:53:02','2021-05-30 23:10:10','2021-05-30 23:10:10'),(2918,3150,752,40736,21644,1,62,1,30000.00,NULL,'2021-05-30 17:53:02','2021-05-31 14:51:02','2021-05-31 14:51:02'),(2919,3150,752,40736,21644,1,489,2,16600.00,NULL,'2021-05-30 17:53:02','2021-05-31 14:51:02','2021-05-31 14:51:02'),(2920,3150,752,40736,21644,1,359,2,13400.00,NULL,'2021-05-30 17:53:02','2021-05-31 14:51:02','2021-05-31 14:51:02'),(2921,3150,753,40736,21644,1,110,1,20000.00,NULL,'2021-05-30 17:53:02','2021-05-30 17:53:02',NULL),(2922,3150,753,40736,21644,1,191,1,659.63,NULL,'2021-05-30 17:53:02','2021-05-30 17:53:02',NULL),(2923,3150,753,40736,21644,1,62,2,20000.00,NULL,'2021-05-30 17:53:02','2021-05-30 17:53:02',NULL),(2924,3150,753,40736,21644,1,63,2,659.63,NULL,'2021-05-30 17:53:02','2021-05-30 17:53:02',NULL),(2925,3150,754,40736,21644,18,513,1,157.43,NULL,'2021-05-30 17:53:02','2021-05-30 17:53:02',NULL),(2926,3150,754,40736,21644,18,57,2,157.43,NULL,'2021-05-30 17:53:02','2021-05-30 17:53:02',NULL),(2927,3150,755,40736,21644,18,354,1,34404.11,NULL,'2021-05-30 17:53:02','2021-05-30 17:53:02',NULL),(2928,3150,755,40736,21644,18,73,2,34404.11,NULL,'2021-05-30 17:53:02','2021-05-30 17:53:02',NULL),(2983,3150,768,40736,21645,15,513,2,550.02,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(2984,3150,768,40736,21645,15,354,2,34404.11,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(2985,3150,768,40736,21645,15,73,1,34954.13,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(2986,3150,769,40736,21645,1,110,1,20000.00,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(2987,3150,769,40736,21645,1,191,1,659.63,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(2988,3150,769,40736,21645,1,62,2,20000.00,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(2989,3150,769,40736,21645,1,63,2,659.63,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(2990,3150,770,40736,21645,18,513,1,550.02,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(2991,3150,770,40736,21645,18,57,2,550.02,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(2992,3150,771,40736,21645,18,23,1,93.87,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(2993,3150,771,40736,21645,18,13,2,93.87,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(2994,3150,772,40736,21645,18,354,1,34954.13,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(2995,3150,772,40736,21645,18,73,2,34954.13,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(2996,3150,773,40736,21645,1,62,1,20000.00,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(2997,3150,773,40736,21645,1,359,2,20000.00,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(2998,3150,774,40736,21646,15,513,2,157.43,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(2999,3150,774,40736,21646,15,354,2,34954.13,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL);
INSERT INTO `balance_libro_details` VALUES (3000,3150,774,40736,21646,15,73,1,35111.56,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3001,3150,775,40736,21646,5,396,1,1339.60,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3002,3150,775,40736,21646,5,492,1,15.00,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3003,3150,775,40736,21646,5,140,1,71.00,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3004,3150,775,40736,21646,5,57,1,1090.00,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3005,3150,775,40736,21646,5,10,2,2515.60,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3006,3150,776,40736,21646,1,62,1,20000.00,NULL,'2021-05-30 18:09:33','2021-05-31 14:50:41','2021-05-31 14:50:41'),(3007,3150,776,40736,21646,1,489,2,16600.00,NULL,'2021-05-30 18:09:33','2021-05-31 14:50:41','2021-05-31 14:50:41'),(3008,3150,776,40736,21646,1,359,2,3400.00,NULL,'2021-05-30 18:09:33','2021-05-31 14:50:41','2021-05-31 14:50:41'),(3009,3150,777,40736,21646,1,110,1,20000.00,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3010,3150,777,40736,21646,1,191,1,659.63,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3011,3150,777,40736,21646,1,62,2,20000.00,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3012,3150,777,40736,21646,1,63,2,659.63,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3013,3150,778,40736,21646,18,513,1,157.43,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3014,3150,778,40736,21646,18,57,2,157.43,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3015,3150,779,40736,21646,18,354,1,35111.56,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3016,3150,779,40736,21646,18,73,2,35111.56,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3017,3150,780,40736,21647,15,513,2,181.47,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3018,3150,780,40736,21647,15,354,2,35111.56,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3019,3150,780,40736,21647,15,73,1,35293.03,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3020,3150,781,40736,21647,5,396,1,1340.92,NULL,'2021-05-30 18:09:33','2021-05-30 23:18:03','2021-05-30 23:18:03'),(3021,3150,781,40736,21647,5,492,1,2523.85,NULL,'2021-05-30 18:09:33','2021-05-30 23:18:03','2021-05-30 23:18:03'),(3022,3150,781,40736,21647,5,140,1,82.00,NULL,'2021-05-30 18:09:33','2021-05-30 23:18:03','2021-05-30 23:18:03'),(3023,3150,781,40736,21647,5,57,1,176869.73,NULL,'2021-05-30 18:09:33','2021-05-30 23:18:03','2021-05-30 23:18:03'),(3024,3150,781,40736,21647,5,13,2,242348.00,NULL,'2021-05-30 18:09:33','2021-05-30 23:18:03','2021-05-30 23:18:03'),(3025,3150,781,40736,21647,5,10,1,61531.50,NULL,'2021-05-30 18:09:33','2021-05-30 23:18:03','2021-05-30 23:18:03'),(3026,3150,782,40736,21647,1,62,1,20000.00,NULL,'2021-05-30 18:09:33','2021-05-31 14:50:17','2021-05-31 14:50:17'),(3027,3150,782,40736,21647,1,489,2,16600.00,NULL,'2021-05-30 18:09:33','2021-05-31 14:50:17','2021-05-31 14:50:17'),(3028,3150,782,40736,21647,1,359,2,3400.00,NULL,'2021-05-30 18:09:33','2021-05-31 14:50:17','2021-05-31 14:50:17'),(3029,3150,783,40736,21647,1,110,1,20000.00,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3030,3150,783,40736,21647,1,191,1,659.63,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3031,3150,783,40736,21647,1,62,2,20000.00,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3032,3150,783,40736,21647,1,63,2,659.63,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3033,3150,784,40736,21647,18,25,1,181.47,NULL,'2021-05-30 18:09:33','2021-06-01 19:42:57','2021-06-01 19:42:57'),(3034,3150,784,40736,21647,18,57,2,181.47,NULL,'2021-05-30 18:09:33','2021-06-01 19:42:57','2021-06-01 19:42:57'),(3035,3150,785,40736,21647,18,354,1,35293.03,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3036,3150,785,40736,21647,18,73,2,35293.03,NULL,'2021-05-30 18:09:33','2021-05-30 18:09:33',NULL),(3037,3150,786,40736,21645,5,396,1,1333.60,NULL,'2021-05-30 18:15:06','2021-05-30 18:15:06',NULL);
INSERT INTO `balance_libro_details` VALUES (3038,3150,786,40736,21645,5,492,1,1854.69,NULL,'2021-05-30 18:15:06','2021-05-30 18:15:06',NULL),(3039,3150,786,40736,21645,5,140,1,21.51,NULL,'2021-05-30 18:15:06','2021-05-30 18:15:06',NULL),(3040,3150,786,40736,21645,5,13,2,156401.04,NULL,'2021-05-30 18:15:06','2021-05-30 18:15:06',NULL),(3041,3150,786,40736,21645,5,10,1,1831.59,NULL,'2021-05-30 18:15:06','2021-05-30 18:15:06',NULL),(3042,3150,786,40736,21645,5,57,1,151359.65,NULL,'2021-05-30 18:15:06','2021-05-30 18:15:06',NULL),(3139,3150,814,40736,21648,2,13,1,748540.00,NULL,'2021-05-30 18:17:20','2021-05-31 19:17:06','2021-05-31 19:17:06'),(3140,3150,814,40736,21648,2,96,2,748540.00,NULL,'2021-05-30 18:17:20','2021-05-31 19:17:06','2021-05-31 19:17:06'),(3141,3150,815,40736,21648,15,513,2,469.64,NULL,'2021-05-30 18:17:20','2021-05-30 18:17:20',NULL),(3142,3150,815,40736,21648,15,354,2,35293.03,NULL,'2021-05-30 18:17:20','2021-05-30 18:17:20',NULL),(3143,3150,815,40736,21648,15,73,1,35762.67,NULL,'2021-05-30 18:17:20','2021-05-30 18:17:20',NULL),(3144,3150,816,40736,21648,5,396,1,1409.40,NULL,'2021-05-30 18:17:20','2021-05-30 18:17:20',NULL),(3145,3150,816,40736,21648,5,492,1,25660.76,NULL,'2021-05-30 18:17:20','2021-05-30 18:17:20',NULL),(3146,3150,816,40736,21648,5,140,1,38.06,NULL,'2021-05-30 18:17:20','2021-05-30 18:17:20',NULL),(3147,3150,816,40736,21648,5,57,1,2023616.04,NULL,'2021-05-30 18:17:20','2021-05-30 18:17:20',NULL),(3148,3150,816,40736,21648,5,13,2,2251731.05,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3149,3150,816,40736,21648,5,10,1,201006.79,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3150,3150,817,40736,21648,1,62,1,20000.00,NULL,'2021-05-30 18:17:21','2021-05-31 14:49:51','2021-05-31 14:49:51'),(3151,3150,817,40736,21648,1,489,2,16600.00,NULL,'2021-05-30 18:17:21','2021-05-31 14:49:51','2021-05-31 14:49:51'),(3152,3150,817,40736,21648,1,359,2,3400.00,NULL,'2021-05-30 18:17:21','2021-05-31 14:49:51','2021-05-31 14:49:51'),(3153,3150,818,40736,21648,22,359,1,10269.92,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3154,3150,818,40736,21648,22,57,2,10269.92,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3155,3150,819,40736,21648,1,110,1,20000.00,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3156,3150,819,40736,21648,1,191,1,659.63,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3157,3150,819,40736,21648,1,62,2,20000.00,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3158,3150,819,40736,21648,1,63,2,659.63,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3159,3150,820,40736,21648,16,156,1,29244.71,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3160,3150,820,40736,21648,16,494,2,315130.54,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3161,3150,820,40736,21648,16,494,1,285885.83,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3162,3150,821,40736,21648,18,513,1,469.64,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3163,3150,821,40736,21648,18,57,2,469.64,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3164,3150,822,40736,21648,18,23,1,247233.00,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3165,3150,822,40736,21648,18,515,2,247233.00,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3166,3150,823,40736,21648,18,354,1,35762.67,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3167,3150,823,40736,21648,18,73,2,35762.67,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3168,3150,824,40736,21649,2,13,1,651104.70,NULL,'2021-05-30 18:17:21','2021-06-02 14:55:13','2021-06-02 14:55:13'),(3169,3150,824,40736,21649,2,96,2,651104.70,NULL,'2021-05-30 18:17:21','2021-06-02 14:55:13','2021-06-02 14:55:13'),(3170,3150,825,40736,21649,15,68,2,591.52,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3171,3150,825,40736,21649,15,513,2,181.47,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3172,3150,825,40736,21649,15,354,2,35762.67,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL);
INSERT INTO `balance_libro_details` VALUES (3173,3150,825,40736,21649,15,353,2,303585.15,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3174,3150,825,40736,21649,15,73,1,340120.81,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3175,3150,826,40736,21649,5,396,1,1386.00,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3176,3150,826,40736,21649,5,492,1,6186.65,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3177,3150,826,40736,21649,5,351,1,8349.11,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3178,3150,826,40736,21649,5,57,1,557535.49,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3179,3150,826,40736,21649,5,13,2,463839.70,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3180,3150,826,40736,21649,5,10,2,109617.55,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3181,3150,827,40736,21649,1,62,1,20000.00,NULL,'2021-05-30 18:17:21','2021-05-31 14:49:21','2021-05-31 14:49:21'),(3182,3150,827,40736,21649,1,489,2,16600.00,NULL,'2021-05-30 18:17:21','2021-05-31 14:49:21','2021-05-31 14:49:21'),(3183,3150,827,40736,21649,1,359,2,3400.00,NULL,'2021-05-30 18:17:21','2021-05-31 14:49:21','2021-05-31 14:49:21'),(3184,3150,828,40736,21649,18,514,1,63613.80,NULL,'2021-05-30 18:17:21','2021-06-01 19:20:03','2021-06-01 19:20:03'),(3185,3150,828,40736,21649,18,13,2,63613.80,NULL,'2021-05-30 18:17:21','2021-06-01 19:20:03','2021-06-01 19:20:03'),(3186,3150,829,40736,21649,1,110,1,30000.00,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3187,3150,829,40736,21649,1,191,1,979.66,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3188,3150,829,40736,21649,1,62,2,30000.00,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3189,3150,829,40736,21649,1,63,2,979.66,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3190,3150,830,40736,21649,16,156,1,57968.42,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3191,3150,830,40736,21649,16,351,2,8349.11,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3192,3150,830,40736,21649,16,494,2,285885.83,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3193,3150,830,40736,21649,16,494,1,236266.52,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3194,3150,831,40736,21649,3,516,1,114235.70,NULL,'2021-05-30 18:17:21','2021-06-02 14:42:41','2021-06-02 14:42:41'),(3195,3150,831,40736,21649,3,507,1,2472.00,NULL,'2021-05-30 18:17:21','2021-06-02 14:42:41','2021-06-02 14:42:41'),(3196,3150,831,40736,21649,3,509,1,260.76,NULL,'2021-05-30 18:17:21','2021-06-02 14:42:41','2021-06-02 14:42:41'),(3197,3150,831,40736,21649,3,68,1,591.52,NULL,'2021-05-30 18:17:21','2021-06-02 14:42:41','2021-06-02 14:42:41'),(3198,3150,831,40736,21649,3,513,1,181.47,NULL,'2021-05-30 18:17:21','2021-06-02 14:42:41','2021-06-02 14:42:41'),(3199,3150,831,40736,21649,3,57,2,117741.45,NULL,'2021-05-30 18:17:21','2021-06-02 14:42:41','2021-06-02 14:42:41'),(3200,3150,832,40736,21649,18,353,1,304176.67,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3201,3150,832,40736,21649,18,354,1,35944.14,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3202,3150,832,40736,21649,18,73,2,340120.81,NULL,'2021-05-30 18:17:21','2021-05-30 18:17:21',NULL),(3203,3150,833,40736,21650,15,68,2,2069.79,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3204,3150,833,40736,21650,15,513,2,203.78,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3205,3150,833,40736,21650,15,354,2,35944.14,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3206,3150,833,40736,21650,15,353,2,304176.67,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3207,3150,833,40736,21650,15,73,1,342394.38,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3208,3150,834,40736,21650,5,396,1,1827.00,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3209,3150,834,40736,21650,5,492,1,399.01,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3210,3150,834,40736,21650,5,351,1,675.59,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL);
INSERT INTO `balance_libro_details` VALUES (3211,3150,834,40736,21650,5,57,1,26466.37,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3212,3150,834,40736,21650,5,13,2,37532.95,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3213,3150,834,40736,21650,5,10,1,8164.98,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3214,3150,835,40736,21650,1,110,1,20000.00,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3215,3150,835,40736,21650,1,191,1,659.63,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3216,3150,835,40736,21650,1,62,2,20000.00,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3217,3150,835,40736,21650,1,63,2,659.63,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3218,3150,836,40736,21650,16,351,2,675.59,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3219,3150,836,40736,21650,16,494,2,236266.52,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3220,3150,836,40736,21650,16,494,1,236942.11,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3221,3150,837,40736,21650,3,516,1,7176.00,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3222,3150,837,40736,21650,3,507,1,2474.03,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3223,3150,837,40736,21650,3,509,1,135.92,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3224,3150,837,40736,21650,3,68,1,2069.79,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3225,3150,837,40736,21650,3,513,1,203.78,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3226,3150,837,40736,21650,3,57,2,12059.52,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3227,3150,838,40736,21650,18,514,1,72205.70,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3228,3150,838,40736,21650,18,57,2,72205.70,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3229,3150,839,40736,21650,18,192,1,44010.50,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3230,3150,839,40736,21650,18,192,1,19811.00,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3231,3150,839,40736,21650,18,365,2,63821.50,NULL,'2021-05-30 18:21:36','2021-05-30 18:21:36',NULL),(3232,3150,840,40736,21650,18,353,1,306246.46,NULL,'2021-05-30 18:21:36','2021-05-30 18:31:27','2021-05-30 18:31:27'),(3233,3150,840,40736,21650,18,354,1,36147.92,NULL,'2021-05-30 18:21:36','2021-05-30 18:31:27','2021-05-30 18:31:27'),(3234,3150,840,40736,21650,18,73,2,342394.38,NULL,'2021-05-30 18:21:36','2021-05-30 18:31:27','2021-05-30 18:31:27'),(3235,3150,841,40736,21650,1,62,1,30000.00,NULL,'2021-05-30 18:21:36','2021-05-31 14:48:28','2021-05-31 14:48:28'),(3236,3150,841,40736,21650,1,489,2,16600.00,NULL,'2021-05-30 18:21:36','2021-05-31 14:48:28','2021-05-31 14:48:28'),(3237,3150,841,40736,21650,1,359,2,3400.00,NULL,'2021-05-30 18:21:36','2021-05-31 14:48:28','2021-05-31 14:48:28'),(3238,3150,841,40736,21650,1,57,2,10000.00,NULL,'2021-05-30 18:21:36','2021-05-31 14:48:28','2021-05-31 14:48:28'),(3239,3150,842,40736,21650,18,353,1,306246.46,NULL,'2021-05-30 18:31:27','2021-05-30 23:50:45','2021-05-30 23:50:45'),(3240,3150,842,40736,21650,18,354,1,36147.92,NULL,'2021-05-30 18:31:27','2021-05-30 23:50:45','2021-05-30 23:50:45'),(3241,3150,842,40736,21650,18,73,2,342394.38,NULL,'2021-05-30 18:31:27','2021-05-30 23:50:45','2021-05-30 23:50:45'),(3242,3150,843,40736,21641,5,13,1,197434.63,NULL,'2021-05-30 18:42:14','2021-05-30 22:38:53','2021-05-30 22:38:53'),(3243,3150,843,40736,21641,5,396,2,1386.62,NULL,'2021-05-30 18:42:14','2021-05-30 22:38:53','2021-05-30 22:38:53'),(3244,3150,843,40736,21641,5,492,2,2433.57,NULL,'2021-05-30 18:42:14','2021-05-30 22:38:53','2021-05-30 22:38:53'),(3245,3150,843,40736,21641,5,140,2,41.70,NULL,'2021-05-30 18:42:14','2021-05-30 22:38:53','2021-05-30 22:38:53'),(3246,3150,843,40736,21641,5,57,2,190198.21,NULL,'2021-05-30 18:42:14','2021-05-30 22:38:53','2021-05-30 22:38:53'),(3247,3150,843,40736,21641,5,10,2,3374.53,NULL,'2021-05-30 18:42:14','2021-05-30 22:38:53','2021-05-30 22:38:53');
INSERT INTO `balance_libro_details` VALUES (3248,3150,844,40736,21642,5,13,1,166306.79,NULL,'2021-05-30 18:48:28','2021-05-30 22:41:35','2021-05-30 22:41:35'),(3249,3150,844,40736,21642,5,396,2,1394.78,NULL,'2021-05-30 18:48:28','2021-05-30 22:41:35','2021-05-30 22:41:35'),(3250,3150,844,40736,21642,5,140,2,73.23,NULL,'2021-05-30 18:48:28','2021-05-30 22:41:35','2021-05-30 22:41:35'),(3251,3150,844,40736,21642,5,57,2,162128.40,NULL,'2021-05-30 18:48:28','2021-05-30 22:41:35','2021-05-30 22:41:35'),(3252,3150,844,40736,21642,5,10,2,826.95,NULL,'2021-05-30 18:48:28','2021-05-30 22:41:35','2021-05-30 22:41:35'),(3253,3150,844,40736,21642,5,492,2,1883.43,NULL,'2021-05-30 18:48:28','2021-05-30 22:41:35','2021-05-30 22:41:35'),(3254,3150,845,40736,21641,3,135,1,4118.00,NULL,'2021-05-30 18:54:32','2021-05-30 18:54:32',NULL),(3255,3150,845,40736,21641,3,192,1,4550.00,NULL,'2021-05-30 18:54:32','2021-05-30 18:54:32',NULL),(3256,3150,845,40736,21641,3,359,2,8668.00,NULL,'2021-05-30 18:54:32','2021-05-30 18:54:32',NULL),(3257,3150,846,40736,21641,5,13,2,197434.63,NULL,'2021-05-30 22:38:53','2021-05-30 22:38:53',NULL),(3258,3150,846,40736,21641,5,396,1,1386.62,NULL,'2021-05-30 22:38:53','2021-05-30 22:38:53',NULL),(3259,3150,846,40736,21641,5,492,1,2433.57,NULL,'2021-05-30 22:38:53','2021-05-30 22:38:53',NULL),(3260,3150,846,40736,21641,5,140,1,41.70,NULL,'2021-05-30 22:38:53','2021-05-30 22:38:53',NULL),(3261,3150,846,40736,21641,5,57,1,190198.21,NULL,'2021-05-30 22:38:53','2021-05-30 22:38:53',NULL),(3262,3150,846,40736,21641,5,10,1,3374.53,NULL,'2021-05-30 22:38:53','2021-05-30 22:38:53',NULL),(3263,3150,847,40736,21642,5,13,2,166306.79,NULL,'2021-05-30 22:41:35','2021-05-30 22:41:35',NULL),(3264,3150,847,40736,21642,5,396,1,1394.78,NULL,'2021-05-30 22:41:35','2021-05-30 22:41:35',NULL),(3265,3150,847,40736,21642,5,140,1,73.23,NULL,'2021-05-30 22:41:35','2021-05-30 22:41:35',NULL),(3266,3150,847,40736,21642,5,57,1,162128.40,NULL,'2021-05-30 22:41:35','2021-05-30 22:41:35',NULL),(3267,3150,847,40736,21642,5,10,1,826.95,NULL,'2021-05-30 22:41:35','2021-05-30 22:41:35',NULL),(3268,3150,847,40736,21642,5,492,1,1883.43,NULL,'2021-05-30 22:41:35','2021-05-30 22:41:35',NULL),(3269,3150,848,40736,21639,5,396,1,1390.46,NULL,'2021-05-30 22:58:17','2021-05-30 22:58:17',NULL),(3270,3150,848,40736,21639,5,492,1,4716.77,NULL,'2021-05-30 22:58:17','2021-05-30 22:58:17',NULL),(3271,3150,848,40736,21639,5,140,1,37.90,NULL,'2021-05-30 22:58:17','2021-05-30 22:58:17',NULL),(3272,3150,848,40736,21639,5,57,1,477811.76,NULL,'2021-05-30 22:58:17','2021-05-30 22:58:17',NULL),(3273,3150,848,40736,21639,5,13,2,306871.77,NULL,'2021-05-30 22:58:17','2021-05-30 22:58:17',NULL),(3274,3150,848,40736,21639,5,10,2,177085.12,NULL,'2021-05-30 22:58:17','2021-05-30 22:58:17',NULL),(3275,3150,849,40736,21644,5,396,1,1395.30,NULL,'2021-05-30 23:10:10','2021-05-30 23:10:10',NULL),(3276,3150,849,40736,21644,5,492,1,29.46,NULL,'2021-05-30 23:10:10','2021-05-30 23:10:10',NULL),(3277,3150,849,40736,21644,5,140,1,76.94,NULL,'2021-05-30 23:10:10','2021-05-30 23:10:10',NULL),(3278,3150,849,40736,21644,5,57,1,2085.35,NULL,'2021-05-30 23:10:10','2021-05-30 23:10:10',NULL),(3279,3150,849,40736,21644,5,13,2,1350.00,NULL,'2021-05-30 23:10:10','2021-05-30 23:10:10',NULL),(3280,3150,849,40736,21644,5,10,2,2237.05,NULL,'2021-05-30 23:10:10','2021-05-30 23:10:10',NULL),(3281,3150,850,40736,21647,5,396,1,1340.92,NULL,'2021-05-30 23:18:03','2021-05-30 23:18:03',NULL),(3282,3150,850,40736,21647,5,492,1,2523.85,NULL,'2021-05-30 23:18:03','2021-05-30 23:18:03',NULL),(3283,3150,850,40736,21647,5,140,1,82.00,NULL,'2021-05-30 23:18:03','2021-05-30 23:18:03',NULL),(3284,3150,850,40736,21647,5,57,1,176869.73,NULL,'2021-05-30 23:18:03','2021-05-30 23:18:03',NULL),(3285,3150,850,40736,21647,5,13,2,242348.03,NULL,'2021-05-30 23:18:03','2021-05-30 23:18:03',NULL),(3286,3150,850,40736,21647,5,10,1,61531.53,NULL,'2021-05-30 23:18:03','2021-05-30 23:18:03',NULL);
INSERT INTO `balance_libro_details` VALUES (3287,3150,851,40736,21641,16,156,2,435.69,NULL,'2021-05-30 23:46:45','2021-05-30 23:46:45',NULL),(3288,3150,851,40736,21641,16,512,2,3630.58,NULL,'2021-05-30 23:46:45','2021-05-30 23:46:45',NULL),(3289,3150,851,40736,21641,16,494,2,310888.05,NULL,'2021-05-30 23:46:45','2021-05-30 23:46:45',NULL),(3290,3150,851,40736,21641,16,494,1,314954.32,NULL,'2021-05-30 23:46:45','2021-05-30 23:46:45',NULL),(3291,3150,852,40736,21650,18,354,1,306246.46,NULL,'2021-05-31 00:26:07','2021-05-31 00:26:07',NULL),(3292,3150,852,40736,21650,18,353,1,36147.92,NULL,'2021-05-31 00:26:07','2021-05-31 00:26:07',NULL),(3293,3150,852,40736,21650,18,73,2,342394.38,NULL,'2021-05-31 00:26:07','2021-05-31 00:26:07',NULL),(3294,3150,853,40736,21650,19,13,1,32312.83,NULL,'2021-05-31 00:39:14','2021-05-31 00:40:03','2021-05-31 00:40:03'),(3295,3150,853,40736,21650,19,359,2,32312.83,NULL,'2021-05-31 00:39:14','2021-05-31 00:40:03','2021-05-31 00:40:03'),(3304,3150,858,40720,1537,20,508,1,63825.00,NULL,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(3305,3150,858,40720,1537,20,13,2,63825.00,NULL,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(3306,3150,859,40720,1538,20,508,1,179570.00,NULL,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(3307,3150,859,40720,1538,20,13,2,179570.00,NULL,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(3308,3150,860,40720,1539,20,508,1,156706.00,NULL,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(3309,3150,860,40720,1539,20,13,2,156706.00,NULL,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(3310,3150,861,40720,1540,20,508,1,307058.00,NULL,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(3311,3150,861,40720,1540,20,13,2,307058.00,NULL,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(3312,3150,862,40720,1541,20,508,1,263850.98,NULL,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(3313,3150,862,40720,1541,20,13,2,263850.98,NULL,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(3314,3150,863,40720,1545,20,508,1,188494.00,NULL,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(3315,3150,863,40720,1545,20,13,2,188494.00,NULL,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(3316,3150,864,40720,1546,20,508,1,242257.98,NULL,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(3317,3150,864,40720,1546,20,13,2,242257.98,NULL,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(3318,3150,865,40720,1547,20,508,1,86977.98,NULL,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(3319,3150,865,40720,1547,20,13,2,86977.98,NULL,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(3320,3150,866,40720,1548,20,508,1,335000.00,NULL,'2021-05-31 13:14:21','2021-05-31 13:48:34','2021-05-31 13:48:34'),(3321,3150,866,40720,1548,20,13,2,335000.00,NULL,'2021-05-31 13:14:21','2021-05-31 13:48:34','2021-05-31 13:48:34'),(3322,3150,867,40720,1549,20,508,1,107314.00,NULL,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(3323,3150,867,40720,1549,20,13,2,107314.00,NULL,'2021-05-31 13:14:21','2021-05-31 13:14:21',NULL),(3324,3150,868,40720,1550,20,508,1,370126.50,NULL,'2021-05-31 13:14:21','2021-05-31 13:48:14','2021-05-31 13:48:14'),(3325,3150,868,40720,1550,20,13,2,370126.50,NULL,'2021-05-31 13:14:21','2021-05-31 13:48:14','2021-05-31 13:48:14'),(3326,3150,869,40720,1551,20,508,1,258848.50,NULL,'2021-05-31 13:14:21','2021-05-31 13:49:05','2021-05-31 13:49:05'),(3327,3150,869,40720,1551,20,13,2,258848.50,NULL,'2021-05-31 13:14:21','2021-05-31 13:49:05','2021-05-31 13:49:05'),(3328,3150,870,40720,1550,20,508,1,170126.50,NULL,'2021-05-31 13:48:14','2021-05-31 13:48:14',NULL),(3329,3150,870,40720,1550,20,13,2,170126.50,NULL,'2021-05-31 13:48:14','2021-05-31 13:48:14',NULL),(3330,3150,871,40720,1548,20,508,1,135000.00,NULL,'2021-05-31 13:48:34','2021-05-31 13:48:34',NULL),(3331,3150,871,40720,1548,20,13,2,135000.00,NULL,'2021-05-31 13:48:34','2021-05-31 13:48:34',NULL),(3332,3150,872,40720,1551,20,508,1,158848.50,NULL,'2021-05-31 13:49:05','2021-05-31 13:49:05',NULL);
INSERT INTO `balance_libro_details` VALUES (3333,3150,872,40720,1551,20,13,2,158848.50,NULL,'2021-05-31 13:49:05','2021-05-31 13:49:05',NULL),(3334,3150,873,40736,21641,19,517,1,10929.05,NULL,'2021-05-31 13:49:44','2021-05-31 13:49:44',NULL),(3335,3150,873,40736,21641,19,156,2,10929.05,NULL,'2021-05-31 13:49:44','2021-05-31 13:49:44',NULL),(3336,3150,874,40736,21642,19,13,2,31000.00,NULL,'2021-05-31 14:13:33','2021-05-31 14:13:33',NULL),(3337,3150,874,40736,21642,19,368,1,31000.00,NULL,'2021-05-31 14:13:33','2021-05-31 14:13:33',NULL),(3338,3150,875,40736,21643,19,13,2,1000.00,NULL,'2021-05-31 14:28:15','2021-05-31 14:28:15',NULL),(3339,3150,875,40736,21643,19,368,1,1000.00,NULL,'2021-05-31 14:28:15','2021-05-31 14:28:15',NULL),(3340,3150,876,40736,21650,11,13,1,220821.46,NULL,'2021-05-31 14:36:00','2021-05-31 14:38:18','2021-05-31 14:38:18'),(3341,3150,876,40736,21650,11,359,2,220821.46,NULL,'2021-05-31 14:36:00','2021-05-31 14:38:18','2021-05-31 14:38:18'),(3342,3150,877,40720,1541,21,92,1,1541870.49,NULL,'2021-05-31 14:36:06','2021-05-31 14:36:06',NULL),(3343,3150,877,40720,1541,21,483,2,721616.17,NULL,'2021-05-31 14:36:06','2021-05-31 14:36:06',NULL),(3344,3150,877,40720,1541,21,484,2,602088.01,NULL,'2021-05-31 14:36:06','2021-05-31 14:36:06',NULL),(3345,3150,877,40720,1541,21,485,2,218166.31,NULL,'2021-05-31 14:36:06','2021-05-31 14:36:06',NULL),(3346,3150,878,40736,21650,18,13,1,220821.46,NULL,'2021-05-31 14:38:18','2021-05-31 14:39:03','2021-05-31 14:39:03'),(3347,3150,878,40736,21650,18,359,2,220821.46,NULL,'2021-05-31 14:38:18','2021-05-31 14:39:03','2021-05-31 14:39:03'),(3348,3150,879,40720,1551,20,359,1,130000.00,NULL,'2021-05-31 14:41:36','2022-05-04 14:47:01','2022-05-04 14:47:01'),(3349,3150,879,40720,1551,20,13,2,130000.00,NULL,'2021-05-31 14:41:36','2022-05-04 14:47:01','2022-05-04 14:47:01'),(3350,3150,880,40736,21641,18,25,1,175.63,NULL,'2021-05-31 14:45:49','2021-06-01 17:05:30','2021-06-01 17:05:30'),(3351,3150,880,40736,21641,18,57,2,175.63,NULL,'2021-05-31 14:45:49','2021-06-01 17:05:30','2021-06-01 17:05:30'),(3352,3150,881,40736,21650,1,62,1,30000.00,NULL,'2021-05-31 14:48:28','2021-06-08 20:41:58','2021-06-08 20:41:58'),(3353,3150,881,40736,21650,1,359,2,3400.00,NULL,'2021-05-31 14:48:28','2021-06-08 20:41:58','2021-06-08 20:41:58'),(3354,3150,881,40736,21650,1,57,2,10000.00,NULL,'2021-05-31 14:48:28','2021-06-08 20:41:58','2021-06-08 20:41:58'),(3355,3150,881,40736,21650,1,498,2,16600.00,NULL,'2021-05-31 14:48:28','2021-06-08 20:41:58','2021-06-08 20:41:58'),(3356,3150,882,40736,21649,1,62,1,20000.00,NULL,'2021-05-31 14:49:22','2021-05-31 14:49:22',NULL),(3357,3150,882,40736,21649,1,359,2,3400.00,NULL,'2021-05-31 14:49:22','2021-05-31 14:49:22',NULL),(3358,3150,882,40736,21649,1,498,2,16600.00,NULL,'2021-05-31 14:49:22','2021-05-31 14:49:22',NULL),(3359,3150,883,40736,21648,1,62,1,20000.00,NULL,'2021-05-31 14:49:51','2021-05-31 14:49:51',NULL),(3360,3150,883,40736,21648,1,359,2,3400.00,NULL,'2021-05-31 14:49:51','2021-05-31 14:49:51',NULL),(3361,3150,883,40736,21648,1,498,2,16600.00,NULL,'2021-05-31 14:49:51','2021-05-31 14:49:51',NULL),(3362,3150,884,40736,21647,1,62,1,20000.00,NULL,'2021-05-31 14:50:17','2021-05-31 14:50:17',NULL),(3363,3150,884,40736,21647,1,359,2,3400.00,NULL,'2021-05-31 14:50:17','2021-05-31 14:50:17',NULL),(3364,3150,884,40736,21647,1,498,2,16600.00,NULL,'2021-05-31 14:50:17','2021-05-31 14:50:17',NULL),(3365,3150,885,40736,21646,1,62,1,20000.00,NULL,'2021-05-31 14:50:41','2021-05-31 14:50:41',NULL),(3366,3150,885,40736,21646,1,359,2,3400.00,NULL,'2021-05-31 14:50:41','2021-05-31 14:50:41',NULL),(3367,3150,885,40736,21646,1,498,2,16600.00,NULL,'2021-05-31 14:50:41','2021-05-31 14:50:41',NULL),(3368,3150,886,40736,21644,1,62,1,30000.00,NULL,'2021-05-31 14:51:02','2021-05-31 14:51:02',NULL),(3369,3150,886,40736,21644,1,359,2,13400.00,NULL,'2021-05-31 14:51:02','2021-05-31 14:51:02',NULL),(3370,3150,886,40736,21644,1,498,2,16600.00,NULL,'2021-05-31 14:51:02','2021-05-31 14:51:02',NULL);
INSERT INTO `balance_libro_details` VALUES (3371,3150,887,40736,21643,1,62,1,20000.00,NULL,'2021-05-31 14:51:24','2021-05-31 14:51:24',NULL),(3372,3150,887,40736,21643,1,359,2,3400.00,NULL,'2021-05-31 14:51:24','2021-05-31 14:51:24',NULL),(3373,3150,887,40736,21643,1,498,2,16600.00,NULL,'2021-05-31 14:51:24','2021-05-31 14:51:24',NULL),(3374,3150,888,40736,21642,1,62,1,20000.00,NULL,'2021-05-31 14:51:43','2021-05-31 14:51:43',NULL),(3375,3150,888,40736,21642,1,359,2,3400.00,NULL,'2021-05-31 14:51:43','2021-05-31 14:51:43',NULL),(3376,3150,888,40736,21642,1,498,2,16600.00,NULL,'2021-05-31 14:51:43','2021-05-31 14:51:43',NULL),(3377,3150,889,40736,21648,2,13,1,1207687.00,NULL,'2021-05-31 19:17:06','2021-06-01 13:28:38','2021-06-01 13:28:38'),(3378,3150,889,40736,21648,2,96,2,748540.00,NULL,'2021-05-31 19:17:06','2021-06-01 13:28:38','2021-06-01 13:28:38'),(3379,3150,889,40736,21648,2,515,2,247233.00,NULL,'2021-05-31 19:17:06','2021-06-01 13:28:38','2021-06-01 13:28:38'),(3380,3150,890,40736,21639,2,13,1,785821.08,NULL,'2021-06-01 13:21:22','2021-06-08 19:41:56','2021-06-08 19:41:56'),(3381,3150,890,40736,21639,2,96,2,196657.44,NULL,'2021-06-01 13:21:22','2021-06-08 19:41:56','2021-06-08 19:41:56'),(3382,3150,890,40736,21639,2,67,2,21526.56,NULL,'2021-06-01 13:21:22','2021-06-08 19:41:56','2021-06-08 19:41:56'),(3383,3150,891,40736,21640,2,13,1,963566.60,NULL,'2021-06-01 13:25:49','2021-06-01 18:37:19','2021-06-01 18:37:19'),(3384,3150,891,40736,21640,2,96,2,43760.74,NULL,'2021-06-01 13:25:49','2021-06-01 18:37:19','2021-06-01 18:37:19'),(3385,3150,891,40736,21640,2,67,2,6207.50,NULL,'2021-06-01 13:25:49','2021-06-01 18:37:19','2021-06-01 18:37:19'),(3386,3150,892,40736,21648,2,13,1,1207687.00,NULL,'2021-06-01 13:28:38','2021-06-01 18:44:08','2021-06-01 18:44:08'),(3387,3150,892,40736,21648,2,96,2,748540.00,NULL,'2021-06-01 13:28:38','2021-06-01 18:44:08','2021-06-01 18:44:08'),(3388,3150,892,40736,21648,2,515,2,247233.00,NULL,'2021-06-01 13:28:38','2021-06-01 18:44:08','2021-06-01 18:44:08'),(3389,3150,893,40736,21648,2,359,1,238325.54,NULL,'2021-06-01 13:37:32','2021-06-01 13:38:51','2021-06-01 13:38:51'),(3390,3150,893,40736,21648,2,13,2,238325.54,NULL,'2021-06-01 13:37:32','2021-06-01 13:38:51','2021-06-01 13:38:51'),(3391,3150,894,40736,21650,2,359,1,238325.54,NULL,'2021-06-01 13:38:51','2021-06-01 13:41:42','2021-06-01 13:41:42'),(3392,3150,894,40736,21650,2,13,2,238325.54,NULL,'2021-06-01 13:38:51','2021-06-01 13:41:42','2021-06-01 13:41:42'),(3393,3150,895,40736,21650,2,359,1,238327.57,NULL,'2021-06-01 13:41:42','2021-06-01 13:42:44','2021-06-01 13:42:44'),(3394,3150,895,40736,21650,2,13,2,238327.57,NULL,'2021-06-01 13:41:42','2021-06-01 13:42:44','2021-06-01 13:42:44'),(3411,3150,900,40736,21639,18,21,1,592.64,NULL,'2021-06-01 14:44:48','2021-06-01 15:12:29','2021-06-01 15:12:29'),(3412,3150,900,40736,21639,18,512,1,2611.27,NULL,'2021-06-01 14:44:48','2021-06-01 15:12:29','2021-06-01 15:12:29'),(3413,3150,900,40736,21639,18,13,2,592.64,NULL,'2021-06-01 14:44:48','2021-06-01 15:12:29','2021-06-01 15:12:29'),(3414,3150,900,40736,21639,18,57,2,2611.27,NULL,'2021-06-01 14:44:48','2021-06-01 15:12:29','2021-06-01 15:12:29'),(3415,3150,901,40736,21641,18,512,1,3630.58,NULL,'2021-06-01 14:46:33','2021-06-01 15:06:42','2021-06-01 15:06:42'),(3416,3150,901,40736,21641,18,13,2,3630.58,NULL,'2021-06-01 14:46:33','2021-06-01 15:06:42','2021-06-01 15:06:42'),(3417,3150,902,40736,21641,18,512,1,3630.58,NULL,'2021-06-01 14:47:26','2021-06-01 14:47:26',NULL),(3418,3150,902,40736,21641,18,13,2,3630.58,NULL,'2021-06-01 14:47:26','2021-06-01 14:47:26',NULL),(3419,3150,903,40736,21641,18,512,1,3630.58,NULL,'2021-06-01 14:47:26','2021-06-01 15:06:46','2021-06-01 15:06:46'),(3420,3150,903,40736,21641,18,13,2,3630.58,NULL,'2021-06-01 14:47:26','2021-06-01 15:06:46','2021-06-01 15:06:46'),(3421,3150,904,40736,21639,18,21,1,592.64,NULL,'2021-06-01 15:12:29','2021-06-01 18:18:21','2021-06-01 18:18:21');
INSERT INTO `balance_libro_details` VALUES (3422,3150,904,40736,21639,18,512,1,2611.27,NULL,'2021-06-01 15:12:29','2021-06-01 18:18:21','2021-06-01 18:18:21'),(3423,3150,904,40736,21639,18,13,2,592.64,NULL,'2021-06-01 15:12:29','2021-06-01 18:18:21','2021-06-01 18:18:21'),(3424,3150,904,40736,21639,18,57,2,2611.27,NULL,'2021-06-01 15:12:29','2021-06-01 18:18:21','2021-06-01 18:18:21'),(3425,3150,905,40736,21639,18,512,1,4490.43,NULL,'2021-06-01 15:19:01','2021-06-01 18:34:23','2021-06-01 18:34:23'),(3426,3150,905,40736,21639,18,21,1,489.34,NULL,'2021-06-01 15:19:01','2021-06-01 18:34:23','2021-06-01 18:34:23'),(3427,3150,905,40736,21639,18,13,2,4490.43,NULL,'2021-06-01 15:19:01','2021-06-01 18:34:23','2021-06-01 18:34:23'),(3428,3150,905,40736,21639,18,57,2,489.34,NULL,'2021-06-01 15:19:01','2021-06-01 18:34:23','2021-06-01 18:34:23'),(3429,3150,906,40736,21639,15,67,1,21526.56,NULL,'2021-06-01 15:53:01','2021-06-01 15:53:01',NULL),(3430,3150,906,40736,21639,15,68,2,16225.97,NULL,'2021-06-01 15:53:01','2021-06-01 15:53:01',NULL),(3431,3150,906,40736,21639,15,353,2,306581.87,NULL,'2021-06-01 15:53:01','2021-06-01 15:53:01',NULL),(3432,3150,906,40736,21639,15,354,2,30166.39,NULL,'2021-06-01 15:53:01','2021-06-01 15:53:01',NULL),(3433,3150,906,40736,21639,15,513,2,856.85,NULL,'2021-06-01 15:53:01','2021-06-01 15:53:01',NULL),(3434,3150,906,40736,21639,15,73,1,301281.28,NULL,'2021-06-01 15:53:01','2021-06-01 15:53:01',NULL),(3435,3150,906,40736,21639,15,73,1,32085.21,NULL,'2021-06-01 15:53:01','2021-06-01 15:53:01',NULL),(3436,3150,906,40736,21639,15,25,2,1061.97,NULL,'2021-06-01 15:53:01','2021-06-01 15:53:01',NULL),(3437,3150,907,40736,21641,18,25,1,175.63,NULL,'2021-06-01 17:05:30','2021-06-01 17:05:30',NULL),(3438,3150,907,40736,21641,18,13,2,175.63,NULL,'2021-06-01 17:05:30','2021-06-01 17:05:30',NULL),(3439,3150,908,40736,21639,18,512,1,2611.27,NULL,'2021-06-01 18:18:21','2021-06-01 18:38:42','2021-06-01 18:38:42'),(3440,3150,908,40736,21639,18,57,2,2611.27,NULL,'2021-06-01 18:18:21','2021-06-01 18:38:42','2021-06-01 18:38:42'),(3441,3150,909,40736,21639,18,25,1,1061.97,NULL,'2021-06-01 18:32:50','2021-06-01 19:03:48','2021-06-01 19:03:48'),(3442,3150,909,40736,21639,18,513,1,856.85,NULL,'2021-06-01 18:32:50','2021-06-01 19:03:48','2021-06-01 19:03:48'),(3443,3150,909,40736,21639,18,57,2,1061.97,NULL,'2021-06-01 18:32:50','2021-06-01 19:03:48','2021-06-01 19:03:48'),(3444,3150,909,40736,21639,18,13,2,856.85,NULL,'2021-06-01 18:32:50','2021-06-01 19:03:48','2021-06-01 19:03:48'),(3445,3150,910,40736,21639,18,512,1,3359.72,NULL,'2021-06-01 18:34:23','2021-06-01 18:35:08','2021-06-01 18:35:08'),(3446,3150,910,40736,21639,18,21,1,489.34,NULL,'2021-06-01 18:34:23','2021-06-01 18:35:08','2021-06-01 18:35:08'),(3447,3150,910,40736,21639,18,13,2,489.34,NULL,'2021-06-01 18:34:23','2021-06-01 18:35:08','2021-06-01 18:35:08'),(3448,3150,910,40736,21639,18,57,2,3359.72,NULL,'2021-06-01 18:34:23','2021-06-01 18:35:08','2021-06-01 18:35:08'),(3449,3150,911,40736,21639,18,512,1,3359.72,NULL,'2021-06-01 18:35:08','2021-06-01 18:35:08',NULL),(3450,3150,911,40736,21639,18,21,1,489.34,NULL,'2021-06-01 18:35:08','2021-06-01 18:35:08',NULL),(3451,3150,911,40736,21639,18,13,2,489.34,NULL,'2021-06-01 18:35:08','2021-06-01 18:35:08',NULL),(3452,3150,911,40736,21639,18,57,2,3359.72,NULL,'2021-06-01 18:35:08','2021-06-01 18:35:08',NULL),(3453,3150,912,40736,21640,2,13,1,963566.60,NULL,'2021-06-01 18:37:19','2021-06-04 19:51:29','2021-06-04 19:51:29'),(3454,3150,912,40736,21640,2,96,2,43760.74,NULL,'2021-06-01 18:37:19','2021-06-04 19:51:29','2021-06-04 19:51:29'),(3455,3150,912,40736,21640,2,67,2,6207.50,NULL,'2021-06-01 18:37:19','2021-06-04 19:51:29','2021-06-04 19:51:29'),(3456,3150,913,40736,21639,18,512,1,2611.27,NULL,'2021-06-01 18:38:42','2021-06-01 18:39:02','2021-06-01 18:39:02'),(3457,3150,913,40736,21639,18,13,2,2611.27,NULL,'2021-06-01 18:38:42','2021-06-01 18:39:02','2021-06-01 18:39:02');
INSERT INTO `balance_libro_details` VALUES (3458,3150,914,40736,21639,18,512,1,2611.27,NULL,'2021-06-01 18:39:02','2021-06-01 19:10:17','2021-06-01 19:10:17'),(3459,3150,914,40736,21639,18,13,2,2611.27,NULL,'2021-06-01 18:39:02','2021-06-01 19:10:17','2021-06-01 19:10:17'),(3460,3150,915,40736,21648,2,13,1,1207687.00,NULL,'2021-06-01 18:44:08','2021-06-04 19:13:23','2021-06-04 19:13:23'),(3461,3150,915,40736,21648,2,96,2,748540.00,NULL,'2021-06-01 18:44:08','2021-06-04 19:13:23','2021-06-04 19:13:23'),(3462,3150,915,40736,21648,2,515,2,247233.00,NULL,'2021-06-01 18:44:08','2021-06-04 19:13:23','2021-06-04 19:13:23'),(3468,3150,917,40736,21641,2,13,1,847789.16,NULL,'2021-06-01 18:55:25','2021-06-08 19:44:37','2021-06-08 19:44:37'),(3469,3150,917,40736,21641,2,96,2,14948.07,NULL,'2021-06-01 18:55:25','2021-06-08 19:44:37','2021-06-08 19:44:37'),(3470,3150,917,40736,21641,2,67,2,1879.09,NULL,'2021-06-01 18:55:25','2021-06-08 19:44:37','2021-06-08 19:44:37'),(3471,3150,918,40736,21639,18,25,1,1061.97,NULL,'2021-06-01 19:03:48','2021-06-01 19:07:58','2021-06-01 19:07:58'),(3472,3150,918,40736,21639,18,513,1,856.85,NULL,'2021-06-01 19:03:48','2021-06-01 19:07:58','2021-06-01 19:07:58'),(3473,3150,918,40736,21639,18,57,2,1061.97,NULL,'2021-06-01 19:03:48','2021-06-01 19:07:58','2021-06-01 19:07:58'),(3474,3150,918,40736,21639,18,13,2,856.85,NULL,'2021-06-01 19:03:48','2021-06-01 19:07:58','2021-06-01 19:07:58'),(3475,3150,919,40736,21639,18,25,1,1061.97,NULL,'2021-06-01 19:07:58','2021-06-01 19:12:42','2021-06-01 19:12:42'),(3476,3150,919,40736,21639,18,513,1,856.85,NULL,'2021-06-01 19:07:58','2021-06-01 19:12:42','2021-06-01 19:12:42'),(3477,3150,919,40736,21639,18,57,2,856.85,NULL,'2021-06-01 19:07:58','2021-06-01 19:12:42','2021-06-01 19:12:42'),(3478,3150,919,40736,21639,18,13,2,1061.97,NULL,'2021-06-01 19:07:58','2021-06-01 19:12:42','2021-06-01 19:12:42'),(3479,3150,920,40736,21639,18,512,1,2611.27,NULL,'2021-06-01 19:10:17','2021-06-01 19:10:17',NULL),(3480,3150,920,40736,21639,18,27,2,2611.27,NULL,'2021-06-01 19:10:17','2021-06-01 19:10:17',NULL),(3481,3150,921,40736,21640,18,514,1,3206.12,NULL,'2021-06-01 19:12:23','2021-06-01 19:12:23',NULL),(3482,3150,921,40736,21640,18,57,2,3206.12,NULL,'2021-06-01 19:12:23','2021-06-01 19:12:23',NULL),(3483,3150,922,40736,21639,18,25,1,1061.97,NULL,'2021-06-01 19:12:42','2021-06-01 19:12:42',NULL),(3484,3150,922,40736,21639,18,513,1,856.85,NULL,'2021-06-01 19:12:42','2021-06-01 19:12:42',NULL),(3485,3150,922,40736,21639,18,57,2,856.85,NULL,'2021-06-01 19:12:42','2021-06-01 19:12:42',NULL),(3486,3150,922,40736,21639,18,13,2,1061.97,NULL,'2021-06-01 19:12:42','2021-06-01 19:12:42',NULL),(3487,3150,923,40736,21649,18,514,1,63613.80,NULL,'2021-06-01 19:20:03','2021-06-01 19:20:03',NULL),(3488,3150,923,40736,21649,18,57,2,63613.80,NULL,'2021-06-01 19:20:03','2021-06-01 19:20:03',NULL),(3489,3150,924,40736,21640,18,513,1,2289.14,NULL,'2021-06-01 19:35:50','2021-06-01 19:35:50',NULL),(3490,3150,924,40736,21640,18,57,2,2289.14,NULL,'2021-06-01 19:35:50','2021-06-01 19:35:50',NULL),(3491,3150,925,40736,21647,18,57,2,181.47,NULL,'2021-06-01 19:42:57','2021-06-01 19:42:57',NULL),(3492,3150,925,40736,21647,18,513,1,181.47,NULL,'2021-06-01 19:42:57','2021-06-01 19:42:57',NULL),(3493,3150,926,40736,21649,3,516,1,113562.96,NULL,'2021-06-02 14:42:41','2021-06-02 14:42:41',NULL),(3494,3150,926,40736,21649,3,507,1,2472.00,NULL,'2021-06-02 14:42:41','2021-06-02 14:42:41',NULL),(3495,3150,926,40736,21649,3,509,1,260.76,NULL,'2021-06-02 14:42:41','2021-06-02 14:42:41',NULL),(3496,3150,926,40736,21649,3,68,1,591.52,NULL,'2021-06-02 14:42:41','2021-06-02 14:42:41',NULL),(3497,3150,926,40736,21649,3,513,1,181.47,NULL,'2021-06-02 14:42:41','2021-06-02 14:42:41',NULL),(3498,3150,926,40736,21649,3,57,2,117068.71,NULL,'2021-06-02 14:42:41','2021-06-02 14:42:41',NULL),(3499,3150,927,40736,21649,2,13,1,1483744.70,NULL,'2021-06-02 14:55:13','2021-06-02 14:55:13',NULL),(3500,3150,927,40736,21649,2,96,2,1483744.70,NULL,'2021-06-02 14:55:13','2021-06-02 14:55:13',NULL);
INSERT INTO `balance_libro_details` VALUES (3501,3150,928,40736,21648,2,13,1,1207687.00,NULL,'2021-06-04 19:12:25','2021-06-04 19:12:52','2021-06-04 19:12:52'),(3502,3150,928,40736,21648,2,14,2,748540.00,NULL,'2021-06-04 19:12:25','2021-06-04 19:12:52','2021-06-04 19:12:52'),(3503,3150,928,40736,21648,2,518,2,211914.00,NULL,'2021-06-04 19:12:25','2021-06-04 19:12:52','2021-06-04 19:12:52'),(3504,3150,928,40736,21648,2,515,2,247233.00,NULL,'2021-06-04 19:12:25','2021-06-04 19:12:52','2021-06-04 19:12:52'),(3505,3150,929,40736,21648,2,13,1,1207687.00,NULL,'2021-06-04 19:13:23','2021-06-04 19:13:23',NULL),(3506,3150,929,40736,21648,2,96,2,748540.00,NULL,'2021-06-04 19:13:23','2021-06-04 19:13:23',NULL),(3507,3150,929,40736,21648,2,515,2,247233.00,NULL,'2021-06-04 19:13:23','2021-06-04 19:13:23',NULL),(3508,3150,929,40736,21648,2,515,2,211914.00,NULL,'2021-06-04 19:13:23','2021-06-04 19:13:23',NULL),(3509,3150,930,40736,21640,2,13,1,963566.60,NULL,'2021-06-04 19:51:29','2021-06-08 19:42:38','2021-06-08 19:42:38'),(3510,3150,930,40736,21640,2,96,2,29559.50,NULL,'2021-06-04 19:51:29','2021-06-08 19:42:38','2021-06-08 19:42:38'),(3511,3150,930,40736,21640,2,67,2,6207.50,NULL,'2021-06-04 19:51:29','2021-06-08 19:42:38','2021-06-08 19:42:38'),(3512,3150,931,40736,21639,2,13,1,785821.08,NULL,'2021-06-08 19:41:56','2021-06-08 19:41:56',NULL),(3513,3150,931,40736,21639,2,96,2,764294.52,NULL,'2021-06-08 19:41:56','2021-06-08 19:41:56',NULL),(3514,3150,931,40736,21639,2,67,2,21526.56,NULL,'2021-06-08 19:41:56','2021-06-08 19:41:56',NULL),(3515,3150,932,40736,21640,2,13,1,963566.60,NULL,'2021-06-08 19:42:38','2021-06-08 19:42:38',NULL),(3516,3150,932,40736,21640,2,96,2,957359.10,NULL,'2021-06-08 19:42:38','2021-06-08 19:42:38',NULL),(3517,3150,932,40736,21640,2,67,2,6207.50,NULL,'2021-06-08 19:42:38','2021-06-08 19:42:38',NULL),(3518,3150,933,40736,21641,2,13,1,847789.16,NULL,'2021-06-08 19:44:37','2021-06-08 19:44:37',NULL),(3519,3150,933,40736,21641,2,96,2,845910.07,NULL,'2021-06-08 19:44:37','2021-06-08 19:44:37',NULL),(3520,3150,933,40736,21641,2,67,2,1879.09,NULL,'2021-06-08 19:44:37','2021-06-08 19:44:37',NULL),(3543,3150,942,40736,21639,19,520,1,309629.89,NULL,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(3544,3150,942,40736,21639,19,57,2,309629.89,NULL,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(3545,3150,943,40736,21640,19,520,1,94689.24,NULL,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(3546,3150,943,40736,21640,19,57,2,94689.24,NULL,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(3547,3150,944,40736,21641,19,520,1,73000.00,NULL,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(3548,3150,944,40736,21641,19,57,2,73000.00,NULL,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(3549,3150,945,40736,21642,19,520,1,94689.24,NULL,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(3550,3150,945,40736,21642,19,57,2,94689.24,NULL,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(3551,3150,946,40736,21645,19,520,1,139000.00,NULL,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(3552,3150,946,40736,21645,19,57,2,139000.00,NULL,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(3553,3150,947,40736,21648,19,520,1,1783676.50,NULL,'2021-06-08 20:05:44','2021-06-08 20:25:09','2021-06-08 20:25:09'),(3554,3150,947,40736,21648,19,57,2,1783676.50,NULL,'2021-06-08 20:05:44','2021-06-08 20:25:09','2021-06-08 20:25:09'),(3555,3150,948,40736,21639,3,512,1,1130.71,NULL,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(3556,3150,948,40736,21639,3,520,1,466036.75,NULL,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(3557,3150,948,40736,21639,3,520,1,109710.73,NULL,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(3558,3150,948,40736,21639,3,68,1,16225.97,NULL,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(3559,3150,948,40736,21639,3,57,2,593104.16,NULL,'2021-06-08 20:05:44','2021-06-08 20:05:44',NULL),(3565,3150,950,40736,21640,3,512,1,592.64,NULL,'2021-06-08 20:14:19','2021-06-08 20:14:19',NULL);
INSERT INTO `balance_libro_details` VALUES (3566,3150,950,40736,21640,3,520,1,881584.78,NULL,'2021-06-08 20:14:19','2021-06-08 20:14:19',NULL),(3567,3150,950,40736,21640,3,520,1,32013.85,NULL,'2021-06-08 20:14:19','2021-06-08 20:14:19',NULL),(3568,3150,950,40736,21640,3,68,1,3361.43,NULL,'2021-06-08 20:14:19','2021-06-08 20:14:19',NULL),(3569,3150,950,40736,21640,3,57,2,917552.70,NULL,'2021-06-08 20:14:19','2021-06-08 20:14:19',NULL),(3570,3150,951,40736,21641,3,520,1,896.25,NULL,'2021-06-08 20:14:51','2021-06-08 20:14:51',NULL),(3571,3150,951,40736,21641,3,513,1,681.02,NULL,'2021-06-08 20:14:51','2021-06-08 20:14:51',NULL),(3572,3150,951,40736,21641,3,520,1,823155.09,NULL,'2021-06-08 20:14:51','2021-06-08 20:14:51',NULL),(3573,3150,951,40736,21641,3,520,1,39250.43,NULL,'2021-06-08 20:14:51','2021-06-08 20:14:51',NULL),(3574,3150,951,40736,21641,3,68,1,7029.03,NULL,'2021-06-08 20:14:51','2021-06-08 20:14:51',NULL),(3575,3150,951,40736,21641,3,57,2,871011.82,NULL,'2021-06-08 20:14:51','2021-06-08 20:14:51',NULL),(3576,3150,952,40736,21650,2,359,1,1129902.84,NULL,'2021-06-08 20:22:24','2021-06-08 20:22:24',NULL),(3577,3150,952,40736,21650,2,13,2,1129902.84,NULL,'2021-06-08 20:22:24','2021-06-08 20:22:24',NULL),(3578,3150,953,40736,21648,3,520,1,565921.44,NULL,'2021-06-08 20:27:16','2021-06-08 20:27:16',NULL),(3579,3150,953,40736,21648,3,57,2,565921.44,NULL,'2021-06-08 20:27:16','2021-06-08 20:27:16',NULL),(3580,3150,954,40736,21650,1,62,1,30000.00,NULL,'2021-06-08 20:41:58','2021-06-08 20:46:59','2021-06-08 20:46:59'),(3581,3150,954,40736,21650,1,359,2,3400.00,NULL,'2021-06-08 20:41:58','2021-06-08 20:46:59','2021-06-08 20:46:59'),(3582,3150,954,40736,21650,1,57,2,10000.00,NULL,'2021-06-08 20:41:58','2021-06-08 20:46:59','2021-06-08 20:46:59'),(3583,3150,954,40736,21650,1,498,2,16600.00,NULL,'2021-06-08 20:41:58','2021-06-08 20:46:59','2021-06-08 20:46:59'),(3584,3150,955,40736,21650,1,62,1,30000.00,NULL,'2021-06-08 20:46:59','2021-06-08 20:48:43','2021-06-08 20:48:43'),(3585,3150,955,40736,21650,1,359,2,3400.00,NULL,'2021-06-08 20:46:59','2021-06-08 20:48:43','2021-06-08 20:48:43'),(3586,3150,955,40736,21650,1,498,2,16600.00,NULL,'2021-06-08 20:46:59','2021-06-08 20:48:43','2021-06-08 20:48:43'),(3587,3150,955,40736,21650,1,57,2,10000.00,NULL,'2021-06-08 20:46:59','2021-06-08 20:48:43','2021-06-08 20:48:43'),(3588,3150,956,40736,21650,21,62,1,30000.00,NULL,'2021-06-08 20:52:13','2021-06-08 20:52:13',NULL),(3589,3150,956,40736,21650,21,359,2,3400.00,NULL,'2021-06-08 20:52:13','2021-06-08 20:52:13',NULL),(3590,3150,956,40736,21650,21,57,2,10000.00,NULL,'2021-06-08 20:52:13','2021-06-08 20:52:13',NULL),(3591,3150,956,40736,21650,21,498,2,16600.00,NULL,'2021-06-08 20:52:13','2021-06-08 20:52:13',NULL),(3592,3150,957,40720,1551,23,46,1,43905.58,NULL,'2021-06-10 14:42:11','2021-06-10 14:42:11',NULL),(3593,3150,957,40720,1551,23,391,1,9429.05,NULL,'2021-06-10 14:42:11','2021-06-10 14:42:11',NULL),(3594,3150,957,40720,1551,23,48,2,32233.35,NULL,'2021-06-10 14:42:11','2021-06-10 14:42:11',NULL),(3595,3150,957,40720,1551,23,415,2,5788.52,NULL,'2021-06-10 14:42:11','2021-06-10 14:42:11',NULL),(3596,3150,957,40720,1551,23,476,2,15312.76,NULL,'2021-06-10 14:42:11','2021-06-10 14:42:11',NULL),(3597,3150,958,40720,1551,23,88,2,21935.99,NULL,'2021-06-10 14:46:08','2022-05-04 14:47:34','2022-05-04 14:47:34'),(3598,3150,958,40720,1551,23,89,2,33987.50,NULL,'2021-06-10 14:46:08','2022-05-04 14:47:34','2022-05-04 14:47:34'),(3599,3150,958,40720,1551,23,381,2,2387.20,NULL,'2021-06-10 14:46:08','2022-05-04 14:47:34','2022-05-04 14:47:34'),(3600,3150,958,40720,1551,23,383,2,1076954.63,NULL,'2021-06-10 14:46:08','2022-05-04 14:47:34','2022-05-04 14:47:34'),(3601,3150,958,40720,1551,23,476,1,1135265.32,NULL,'2021-06-10 14:46:08','2022-05-04 14:47:34','2022-05-04 14:47:34'),(3602,3150,959,40720,1537,23,504,1,1088.63,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3603,3150,959,40720,1537,23,476,2,1088.63,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL);
INSERT INTO `balance_libro_details` VALUES (3604,3150,960,40720,1537,23,96,2,435810.68,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3605,3150,960,40720,1537,23,476,1,435810.68,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3606,3150,961,40720,1537,23,110,2,268042.50,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3607,3150,961,40720,1537,23,476,1,268042.50,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3608,3150,962,40720,1537,23,140,2,764.92,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3609,3150,962,40720,1537,23,476,1,764.92,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3610,3150,963,40720,1537,23,128,1,4353.58,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3611,3150,963,40720,1537,23,476,2,4353.58,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3612,3150,964,40720,1537,23,157,1,1097.95,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3613,3150,964,40720,1537,23,476,2,1097.95,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3614,3150,965,40720,1537,23,509,1,595.20,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3615,3150,965,40720,1537,23,476,2,595.20,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3616,3150,966,40720,1537,23,507,1,2162.54,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3617,3150,966,40720,1537,23,476,2,2162.54,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3618,3150,967,40720,1537,23,192,2,20900.87,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3619,3150,967,40720,1537,23,476,1,20900.87,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3620,3150,968,40720,1537,23,505,1,4546.94,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3621,3150,968,40720,1537,23,476,2,4546.94,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3622,3150,969,40720,1537,23,511,1,2041.84,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3623,3150,969,40720,1537,23,476,2,2041.84,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3624,3150,970,40720,1537,23,191,1,41813.50,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3625,3150,970,40720,1537,23,476,2,41813.50,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3626,3150,971,40720,1537,23,156,1,13074.32,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3627,3150,971,40720,1537,23,476,2,13074.32,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3628,3150,972,40720,1537,23,510,1,2777.21,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3629,3150,972,40720,1537,23,476,2,2777.21,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3630,3150,973,40720,1537,23,396,1,494.69,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3631,3150,973,40720,1537,23,476,2,494.69,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3632,3150,974,40720,1537,23,508,1,205412.16,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3633,3150,974,40720,1537,23,476,2,205412.16,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3634,3150,975,40720,1537,23,506,1,502.11,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3635,3150,975,40720,1537,23,476,2,502.11,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3636,3150,976,40720,1537,23,129,1,2134.19,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3637,3150,976,40720,1537,23,476,2,2134.19,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3638,3150,977,40720,1538,23,507,1,2535.26,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3639,3150,977,40720,1538,23,476,2,2535.26,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3640,3150,978,40720,1538,23,110,1,94119.34,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3641,3150,978,40720,1538,23,476,2,94119.34,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3642,3150,979,40720,1538,23,140,1,64.81,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3643,3150,979,40720,1538,23,476,2,64.81,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL);
INSERT INTO `balance_libro_details` VALUES (3644,3150,980,40720,1538,23,129,1,1969.64,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3645,3150,980,40720,1538,23,476,2,1969.64,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3646,3150,981,40720,1538,23,504,1,332.91,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3647,3150,981,40720,1538,23,476,2,332.91,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3648,3150,982,40720,1538,23,157,1,990.41,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3649,3150,982,40720,1538,23,476,2,990.41,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3650,3150,983,40720,1538,23,502,1,3140.75,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3651,3150,983,40720,1538,23,476,2,3140.75,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3652,3150,984,40720,1538,23,508,1,241548.50,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3653,3150,984,40720,1538,23,476,2,241548.50,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3654,3150,985,40720,1538,23,96,2,390999.26,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3655,3150,985,40720,1538,23,476,1,390999.26,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3656,3150,986,40720,1538,23,191,1,30235.96,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3657,3150,986,40720,1538,23,476,2,30235.96,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3658,3150,987,40720,1538,23,156,1,11729.97,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3659,3150,987,40720,1538,23,476,2,11729.97,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3660,3150,988,40720,1538,23,192,1,7108.54,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3661,3150,988,40720,1538,23,476,2,7108.54,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3662,3150,989,40720,1538,23,505,1,165.29,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3663,3150,989,40720,1538,23,476,2,165.29,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3664,3150,990,40720,1538,23,511,1,1465.50,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3665,3150,990,40720,1538,23,476,2,1465.50,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3666,3150,991,40720,1538,23,396,1,337.89,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3667,3150,991,40720,1538,23,476,2,337.89,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3668,3150,992,40720,1538,23,509,1,1737.64,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3669,3150,992,40720,1538,23,476,2,1737.64,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3670,3150,993,40720,1539,23,96,2,308121.03,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3671,3150,993,40720,1539,23,476,1,308121.03,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3672,3150,994,40720,1539,23,110,1,93052.26,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3673,3150,994,40720,1539,23,476,2,93052.26,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3674,3150,995,40720,1539,23,140,1,97.72,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3675,3150,995,40720,1539,23,476,2,97.72,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3676,3150,996,40720,1539,23,509,1,320.62,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3677,3150,996,40720,1539,23,476,2,320.62,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3678,3150,997,40720,1539,23,507,1,2560.72,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3679,3150,997,40720,1539,23,476,2,2560.72,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3680,3150,998,40720,1539,23,192,1,6124.82,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3681,3150,998,40720,1539,23,476,2,6124.82,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3682,3150,999,40720,1539,23,157,1,793.57,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3683,3150,999,40720,1539,23,476,2,793.57,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL);
INSERT INTO `balance_libro_details` VALUES (3684,3150,1000,40720,1539,23,504,1,510.74,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3685,3150,1000,40720,1539,23,476,2,510.74,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3686,3150,1001,40720,1539,23,191,1,30509.47,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3687,3150,1001,40720,1539,23,476,2,30509.47,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3688,3150,1002,40720,1539,23,156,1,9243.63,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3689,3150,1002,40720,1539,23,476,2,9243.63,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3690,3150,1003,40720,1539,23,508,1,180130.10,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3691,3150,1003,40720,1539,23,476,2,180130.10,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3692,3150,1004,40720,1539,23,506,1,990.73,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3693,3150,1004,40720,1539,23,476,2,990.73,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3694,3150,1005,40720,1539,23,129,1,1933.72,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3695,3150,1005,40720,1539,23,476,2,1933.72,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3696,3150,1006,40720,1539,23,396,1,336.82,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3697,3150,1006,40720,1539,23,476,2,336.82,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3698,3150,1007,40720,1539,23,511,1,1668.84,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3699,3150,1007,40720,1539,23,476,2,1668.84,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3700,3150,1008,40720,1540,23,506,1,308.29,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3701,3150,1008,40720,1540,23,476,2,308.29,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3702,3150,1009,40720,1540,23,129,1,596.13,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3703,3150,1009,40720,1540,23,476,2,596.13,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3704,3150,1010,40720,1540,23,504,1,446.85,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3705,3150,1010,40720,1540,23,476,2,446.85,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3706,3150,1011,40720,1540,23,509,1,778.52,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3707,3150,1011,40720,1540,23,476,2,778.52,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3708,3150,1012,40720,1540,23,191,1,23370.46,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3709,3150,1012,40720,1540,23,476,2,23370.46,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3710,3150,1013,40720,1540,23,157,1,966.65,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3711,3150,1013,40720,1540,23,476,2,966.65,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3712,3150,1014,40720,1540,23,156,1,9551.53,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3713,3150,1014,40720,1540,23,476,2,9551.53,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3714,3150,1015,40720,1540,23,96,2,318384.36,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3715,3150,1015,40720,1540,23,476,1,318384.36,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3716,3150,1016,40720,1540,23,507,1,1508.45,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3717,3150,1016,40720,1540,23,476,2,1508.45,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3718,3150,1017,40720,1540,23,192,1,11027.90,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3719,3150,1017,40720,1540,23,476,2,11027.90,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3720,3150,1018,40720,1540,23,505,1,219.93,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3721,3150,1018,40720,1540,23,476,2,219.93,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3722,3150,1019,40720,1540,23,511,1,1127.75,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3723,3150,1019,40720,1540,23,476,2,1127.75,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL);
INSERT INTO `balance_libro_details` VALUES (3724,3150,1020,40720,1540,23,502,1,2368.11,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3725,3150,1020,40720,1540,23,476,2,2368.11,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3726,3150,1021,40720,1540,23,508,1,250465.04,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3727,3150,1021,40720,1540,23,476,2,250465.04,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3728,3150,1022,40720,1540,23,110,1,76328.53,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3729,3150,1022,40720,1540,23,476,2,76328.53,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3730,3150,1023,40720,1540,23,396,1,583.81,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3731,3150,1023,40720,1540,23,476,2,583.81,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3732,3150,1024,40720,1540,23,140,1,154.60,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3733,3150,1024,40720,1540,23,476,2,154.60,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3734,3150,1025,40720,1541,23,509,1,4036.91,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3735,3150,1025,40720,1541,23,476,2,4036.91,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3736,3150,1026,40720,1541,23,507,1,793.56,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3737,3150,1026,40720,1541,23,476,2,793.56,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3738,3150,1027,40720,1541,23,192,1,501.90,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3739,3150,1027,40720,1541,23,476,2,501.90,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3740,3150,1028,40720,1541,23,505,1,5019.00,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3741,3150,1028,40720,1541,23,476,2,5019.00,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3742,3150,1029,40720,1541,23,511,1,1232.85,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3743,3150,1029,40720,1541,23,476,2,1232.85,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3744,3150,1030,40720,1541,23,191,1,30235.43,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3745,3150,1030,40720,1541,23,476,2,30235.43,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3746,3150,1031,40720,1541,23,156,1,8348.89,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3747,3150,1031,40720,1541,23,476,2,8348.89,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3748,3150,1032,40720,1541,23,396,1,291.60,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3749,3150,1032,40720,1541,23,476,2,291.60,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3750,3150,1033,40720,1541,23,508,1,182010.68,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3751,3150,1033,40720,1541,23,476,2,182010.68,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3752,3150,1034,40720,1541,23,155,1,100719.26,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3753,3150,1034,40720,1541,23,476,2,100719.26,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3754,3150,1035,40720,1541,23,506,1,1882.08,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3755,3150,1035,40720,1541,23,476,2,1882.08,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3756,3150,1036,40720,1541,23,129,1,273.05,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3757,3150,1036,40720,1541,23,476,2,273.05,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3758,3150,1037,40720,1541,23,504,1,2664.63,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3759,3150,1037,40720,1541,23,476,2,2664.63,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3760,3150,1038,40720,1541,23,157,1,651.56,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3761,3150,1038,40720,1541,23,476,2,651.56,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3762,3150,1039,40720,1541,23,110,1,93372.25,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3763,3150,1039,40720,1541,23,476,2,93372.25,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL);
INSERT INTO `balance_libro_details` VALUES (3764,3150,1040,40720,1541,23,140,1,72.74,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3765,3150,1040,40720,1541,23,476,2,72.74,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3766,3150,1041,40720,1541,23,96,2,278296.44,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3767,3150,1041,40720,1541,23,476,1,278296.44,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3768,3150,1042,40720,1545,23,396,1,287.52,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3769,3150,1042,40720,1545,23,476,2,287.52,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3770,3150,1043,40720,1545,23,504,1,372.44,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3771,3150,1043,40720,1545,23,476,2,372.44,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3772,3150,1044,40720,1545,23,191,1,16188.01,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3773,3150,1044,40720,1545,23,476,2,16188.01,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3774,3150,1045,40720,1545,23,156,1,7620.63,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3775,3150,1045,40720,1545,23,476,2,7620.63,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3776,3150,1046,40720,1545,23,502,1,2035.49,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3777,3150,1046,40720,1545,23,476,2,2035.49,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3778,3150,1047,40720,1545,23,508,1,160782.10,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3779,3150,1047,40720,1545,23,476,2,160782.10,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3780,3150,1048,40720,1545,23,96,2,254021.01,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3781,3150,1048,40720,1545,23,476,1,254021.01,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3782,3150,1049,40720,1545,23,506,1,1088.89,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3783,3150,1049,40720,1545,23,476,2,1088.89,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3784,3150,1050,40720,1545,23,157,1,806.37,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3785,3150,1050,40720,1545,23,476,2,806.37,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3786,3150,1051,40720,1545,23,129,1,4920.96,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3787,3150,1051,40720,1545,23,476,2,4920.96,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3788,3150,1052,40720,1545,23,511,1,593.56,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3789,3150,1052,40720,1545,23,476,2,593.56,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3790,3150,1053,40720,1545,23,110,1,58272.15,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3791,3150,1053,40720,1545,23,476,2,58272.15,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3792,3150,1054,40720,1545,23,140,1,51.97,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3793,3150,1054,40720,1545,23,476,2,51.97,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3794,3150,1055,40720,1545,23,509,1,102.29,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3795,3150,1055,40720,1545,23,476,2,102.29,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3796,3150,1056,40720,1545,23,507,1,1412.31,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3797,3150,1056,40720,1545,23,476,2,1412.31,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3798,3150,1057,40720,1545,23,192,1,4312.42,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3799,3150,1057,40720,1545,23,476,2,4312.42,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3800,3150,1058,40720,1546,23,396,1,228.70,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3801,3150,1058,40720,1546,23,476,2,228.70,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3802,3150,1059,40720,1546,23,502,1,1131.92,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3803,3150,1059,40720,1546,23,476,2,1131.92,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL);
INSERT INTO `balance_libro_details` VALUES (3804,3150,1060,40720,1546,23,508,1,127490.15,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3805,3150,1060,40720,1546,23,476,2,127490.15,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3806,3150,1061,40720,1546,23,191,1,12202.90,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3807,3150,1061,40720,1546,23,476,2,12202.90,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3808,3150,1062,40720,1546,23,156,1,5568.63,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3809,3150,1062,40720,1546,23,476,2,5568.63,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3810,3150,1063,40720,1546,23,192,1,3520.26,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3811,3150,1063,40720,1546,23,476,2,3520.26,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3812,3150,1064,40720,1546,23,157,1,399.58,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3813,3150,1064,40720,1546,23,476,2,399.58,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3814,3150,1065,40720,1546,23,509,1,89.22,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3815,3150,1065,40720,1546,23,476,2,89.22,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3816,3150,1066,40720,1546,23,507,1,547.92,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3817,3150,1066,40720,1546,23,476,2,547.92,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3818,3150,1067,40720,1546,23,110,1,41933.09,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3819,3150,1067,40720,1546,23,476,2,41933.09,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3820,3150,1068,40720,1546,23,140,1,38.01,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3821,3150,1068,40720,1546,23,476,2,38.01,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3822,3150,1069,40720,1546,23,129,1,34.05,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3823,3150,1069,40720,1546,23,476,2,34.05,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3824,3150,1070,40720,1546,23,96,2,185621.12,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3825,3150,1070,40720,1546,23,476,1,185621.12,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3826,3150,1071,40720,1547,23,129,1,616.39,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3827,3150,1071,40720,1547,23,476,2,616.39,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3828,3150,1072,40720,1547,23,504,1,356.42,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3829,3150,1072,40720,1547,23,476,2,356.42,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3830,3150,1073,40720,1547,23,396,1,158.86,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3831,3150,1073,40720,1547,23,476,2,158.86,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3832,3150,1074,40720,1547,23,191,1,9404.02,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3833,3150,1074,40720,1547,23,476,2,9404.02,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3834,3150,1075,40720,1547,23,156,1,4129.22,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3835,3150,1075,40720,1547,23,476,2,4129.22,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3836,3150,1076,40720,1547,23,96,2,137640.73,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3837,3150,1076,40720,1547,23,476,1,137640.73,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3838,3150,1077,40720,1547,23,509,1,249.61,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3839,3150,1077,40720,1547,23,476,2,249.61,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3840,3150,1078,40720,1547,23,507,1,1845.75,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3841,3150,1078,40720,1547,23,476,2,1845.75,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3842,3150,1079,40720,1547,23,192,1,1540.33,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3843,3150,1079,40720,1547,23,476,2,1540.33,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL);
INSERT INTO `balance_libro_details` VALUES (3844,3150,1080,40720,1547,23,126,1,2862.84,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3845,3150,1080,40720,1547,23,476,2,2862.84,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3846,3150,1081,40720,1547,23,511,1,1273.20,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3847,3150,1081,40720,1547,23,476,2,1273.20,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3848,3150,1082,40720,1547,23,157,1,159.58,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3849,3150,1082,40720,1547,23,476,2,159.58,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3850,3150,1083,40720,1547,23,110,1,31846.81,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3851,3150,1083,40720,1547,23,476,2,31846.81,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3852,3150,1084,40720,1547,23,140,1,36.98,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3853,3150,1084,40720,1547,23,476,2,36.98,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3854,3150,1085,40720,1547,23,502,1,2274.90,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3855,3150,1085,40720,1547,23,476,2,2274.90,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3856,3150,1086,40720,1547,23,508,1,66671.88,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3857,3150,1086,40720,1547,23,476,2,66671.88,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3858,3150,1087,40720,1547,23,506,1,74.63,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3859,3150,1087,40720,1547,23,476,2,74.63,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3860,3150,1088,40720,1548,23,509,1,186.07,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3861,3150,1088,40720,1548,23,476,2,186.07,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3862,3150,1089,40720,1548,23,507,1,316.44,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3863,3150,1089,40720,1548,23,476,2,316.44,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3864,3150,1090,40720,1548,23,191,1,7905.29,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3865,3150,1090,40720,1548,23,476,2,7905.29,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3866,3150,1091,40720,1548,23,156,1,3131.48,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3867,3150,1091,40720,1548,23,476,2,3131.48,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3868,3150,1092,40720,1548,23,192,1,654.95,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3869,3150,1092,40720,1548,23,476,2,654.95,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3870,3150,1093,40720,1548,23,396,1,147.21,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3871,3150,1093,40720,1548,23,476,2,147.21,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3872,3150,1094,40720,1548,23,510,1,442.09,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3873,3150,1094,40720,1548,23,476,2,442.09,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3874,3150,1095,40720,1548,23,511,1,284.81,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3875,3150,1095,40720,1548,23,476,2,284.81,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3876,3150,1096,40720,1548,23,502,1,932.85,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3877,3150,1096,40720,1548,23,476,2,932.85,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3878,3150,1097,40720,1548,23,508,1,59293.27,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3879,3150,1097,40720,1548,23,476,2,59293.27,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3880,3150,1098,40720,1548,23,506,1,140.77,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3881,3150,1098,40720,1548,23,476,2,140.77,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3882,3150,1099,40720,1548,23,110,1,26178.08,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3883,3150,1099,40720,1548,23,476,2,26178.08,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL);
INSERT INTO `balance_libro_details` VALUES (3884,3150,1100,40720,1548,23,140,1,29.04,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3885,3150,1100,40720,1548,23,476,2,29.04,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3886,3150,1101,40720,1548,23,157,1,232.14,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3887,3150,1101,40720,1548,23,476,2,232.14,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3888,3150,1102,40720,1548,23,129,1,322.02,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3889,3150,1102,40720,1548,23,476,2,322.02,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3890,3150,1103,40720,1548,23,504,1,252.37,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3891,3150,1103,40720,1548,23,476,2,252.37,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3892,3150,1104,40720,1548,23,96,2,104382.65,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3893,3150,1104,40720,1548,23,476,1,104382.65,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3894,3150,1105,40720,1549,23,191,1,4473.14,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3895,3150,1105,40720,1549,23,476,2,4473.14,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3896,3150,1106,40720,1549,23,156,1,1727.88,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3897,3150,1106,40720,1549,23,476,2,1727.88,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3898,3150,1107,40720,1549,23,502,1,650.86,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3899,3150,1107,40720,1549,23,476,2,650.86,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3900,3150,1108,40720,1549,23,508,1,25552.68,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3901,3150,1108,40720,1549,23,476,2,25552.68,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3902,3150,1109,40720,1549,23,396,1,66.35,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3903,3150,1109,40720,1549,23,476,2,66.35,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3904,3150,1110,40720,1549,23,96,2,57596.08,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3905,3150,1110,40720,1549,23,476,1,57596.08,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3906,3150,1111,40720,1549,23,506,1,659.73,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3907,3150,1111,40720,1549,23,476,2,659.73,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3908,3150,1112,40720,1549,23,129,1,191.83,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3909,3150,1112,40720,1549,23,476,2,191.83,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3910,3150,1113,40720,1549,23,504,1,104.04,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3911,3150,1113,40720,1549,23,476,2,104.04,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3912,3150,1114,40720,1549,23,110,1,15164.67,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3913,3150,1114,40720,1549,23,476,2,15164.67,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3914,3150,1115,40720,1549,23,140,1,19.49,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3915,3150,1115,40720,1549,23,476,2,19.49,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3916,3150,1116,40720,1549,23,509,1,26.03,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3917,3150,1116,40720,1549,23,476,2,26.03,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3918,3150,1117,40720,1549,23,157,1,157.94,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3919,3150,1117,40720,1549,23,476,2,157.94,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3920,3150,1118,40720,1549,23,507,1,639.03,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3921,3150,1118,40720,1549,23,476,2,639.03,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3922,3150,1119,40720,1549,23,192,1,129.37,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3923,3150,1119,40720,1549,23,476,2,129.37,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL);
INSERT INTO `balance_libro_details` VALUES (3924,3150,1120,40720,1549,23,505,1,33.44,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3925,3150,1120,40720,1549,23,476,2,33.44,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3926,3150,1121,40720,1549,23,511,1,232.29,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3927,3150,1121,40720,1549,23,476,2,232.29,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3928,3150,1122,40720,1550,23,191,1,3387.38,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3929,3150,1122,40720,1550,23,476,2,3387.38,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3930,3150,1123,40720,1550,23,508,1,16861.13,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3931,3150,1123,40720,1550,23,476,2,16861.13,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3932,3150,1124,40720,1550,23,156,1,908.40,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3933,3150,1124,40720,1550,23,476,2,908.40,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3934,3150,1125,40720,1550,23,192,1,175.83,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3935,3150,1125,40720,1550,23,476,2,175.83,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3936,3150,1126,40720,1550,23,504,1,45.96,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3937,3150,1126,40720,1550,23,476,2,45.96,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3938,3150,1127,40720,1550,23,157,1,121.41,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3939,3150,1127,40720,1550,23,476,2,121.41,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3940,3150,1128,40720,1550,23,509,1,20.78,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3941,3150,1128,40720,1550,23,476,2,20.78,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3942,3150,1129,40720,1550,23,110,1,11837.33,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3943,3150,1129,40720,1550,23,476,2,11837.33,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3944,3150,1130,40720,1550,23,507,1,210.23,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3945,3150,1130,40720,1550,23,476,2,210.23,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3946,3150,1131,40720,1550,23,140,1,6.07,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3947,3150,1131,40720,1550,23,476,2,6.07,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3948,3150,1132,40720,1550,23,129,1,122.65,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3949,3150,1132,40720,1550,23,476,2,122.65,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3950,3150,1133,40720,1550,23,511,1,47.21,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3951,3150,1133,40720,1550,23,476,2,47.21,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3952,3150,1134,40720,1550,23,396,1,174.66,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3953,3150,1134,40720,1550,23,476,2,174.66,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3954,3150,1135,40720,1550,23,96,2,30279.92,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3955,3150,1135,40720,1550,23,476,1,30279.92,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3956,3150,1136,40720,1550,23,502,1,270.38,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3957,3150,1136,40720,1550,23,476,2,270.38,NULL,'2021-06-10 14:48:21','2021-06-10 14:48:21',NULL),(3958,3150,1137,40737,23176,2,13,1,11593246.28,NULL,'2021-06-22 17:23:03','2021-06-24 20:22:54','2021-06-24 20:22:54'),(3959,3150,1137,40737,23176,2,96,2,9581195.27,NULL,'2021-06-22 17:23:03','2021-06-24 20:22:54','2021-06-24 20:22:54'),(3960,3150,1137,40737,23176,2,67,2,2012051.01,NULL,'2021-06-22 17:23:03','2021-06-24 20:22:54','2021-06-24 20:22:54'),(3961,3150,1138,40737,23176,12,92,2,926444.31,NULL,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10'),(3962,3150,1138,40737,23176,12,359,1,103266.50,NULL,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10');
INSERT INTO `balance_libro_details` VALUES (3963,3150,1138,40737,23176,12,521,1,127435.28,NULL,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10'),(3964,3150,1138,40737,23176,12,23,1,85844.66,NULL,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10'),(3965,3150,1138,40737,23176,12,20,1,58026.69,NULL,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10'),(3966,3150,1138,40737,23176,12,492,1,63548.45,NULL,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10'),(3967,3150,1138,40737,23176,12,494,1,1001340.81,NULL,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10'),(3968,3150,1138,40737,23176,12,503,1,2106.60,NULL,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10'),(3969,3150,1138,40737,23176,12,13,1,2282036.92,NULL,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10'),(3970,3150,1138,40737,23176,12,434,1,1231353.33,NULL,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10'),(3971,3150,1138,40737,23176,12,497,1,1015692.47,NULL,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10'),(3972,3150,1138,40737,23176,12,416,1,1393461.66,NULL,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10'),(3973,3150,1138,40737,23176,12,57,2,2399758.54,NULL,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10'),(3974,3150,1138,40737,23176,12,78,2,1004156.88,NULL,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10'),(3975,3150,1138,40737,23176,12,74,2,253427.73,NULL,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10'),(3976,3150,1138,40737,23176,12,369,2,100000.00,NULL,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10'),(3977,3150,1138,40737,23176,12,88,2,208176.50,NULL,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10'),(3978,3150,1138,40737,23176,12,381,2,60635.30,NULL,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10'),(3979,3150,1138,40737,23176,12,91,2,2411514.11,NULL,'2021-06-22 17:34:53','2021-06-24 18:44:10','2021-06-24 18:44:10'),(3980,3150,1139,40737,23177,2,13,1,4974249.46,NULL,'2021-06-22 17:36:42','2021-06-22 17:36:42',NULL),(3981,3150,1139,40737,23177,2,67,2,819214.17,NULL,'2021-06-22 17:36:42','2021-06-22 17:36:42',NULL),(3982,3150,1139,40737,23177,2,96,2,4155035.29,NULL,'2021-06-22 17:36:42','2021-06-22 17:36:42',NULL),(3983,3150,1140,40737,23181,2,13,1,5705855.28,NULL,'2021-06-22 17:38:14','2021-06-22 17:38:14',NULL),(3984,3150,1140,40737,23181,2,96,2,4715970.41,NULL,'2021-06-22 17:38:14','2021-06-22 17:38:14',NULL),(3985,3150,1140,40737,23181,2,67,2,989884.87,NULL,'2021-06-22 17:38:14','2021-06-22 17:38:14',NULL),(3986,3150,1141,40737,23182,2,13,1,5896543.00,NULL,'2021-06-22 17:39:24','2021-06-22 17:39:24',NULL),(3987,3150,1141,40737,23182,2,96,2,4883046.73,NULL,'2021-06-22 17:39:24','2021-06-22 17:39:24',NULL),(3988,3150,1141,40737,23182,2,67,2,1013496.27,NULL,'2021-06-22 17:39:24','2021-06-22 17:39:24',NULL),(3989,3150,1142,40737,23183,2,13,1,8696054.79,NULL,'2021-06-22 17:40:30','2021-06-22 17:40:30',NULL),(3990,3150,1142,40737,23183,2,96,2,7188488.26,NULL,'2021-06-22 17:40:30','2021-06-22 17:40:30',NULL),(3991,3150,1142,40737,23183,2,67,2,1507566.53,NULL,'2021-06-22 17:40:30','2021-06-22 17:40:30',NULL),(3992,3150,1143,40737,23184,2,13,1,12458153.76,NULL,'2021-06-22 17:44:18','2021-06-22 17:44:18',NULL),(3993,3150,1143,40737,23184,2,96,2,10314421.81,NULL,'2021-06-22 17:44:18','2021-06-22 17:44:18',NULL),(3994,3150,1143,40737,23184,2,67,2,2143731.95,NULL,'2021-06-22 17:44:18','2021-06-22 17:44:18',NULL),(3995,3150,1144,40737,23185,2,13,1,12979459.96,NULL,'2021-06-22 17:46:07','2021-06-22 17:46:07',NULL),(3996,3150,1144,40737,23185,2,96,2,10762282.53,NULL,'2021-06-22 17:46:07','2021-06-22 17:46:07',NULL),(3997,3150,1144,40737,23185,2,67,2,2217177.43,NULL,'2021-06-22 17:46:07','2021-06-22 17:46:07',NULL),(3998,3150,1145,40737,23186,2,13,1,10368334.02,NULL,'2021-06-22 17:53:36','2021-06-22 17:53:36',NULL);
INSERT INTO `balance_libro_details` VALUES (3999,3150,1145,40737,23186,2,96,2,8589880.81,NULL,'2021-06-22 17:53:36','2021-06-22 17:53:36',NULL),(4000,3150,1145,40737,23186,2,67,2,1778453.21,NULL,'2021-06-22 17:53:36','2021-06-22 17:53:36',NULL),(4001,3150,1146,40737,23187,2,13,1,11273915.61,NULL,'2021-06-22 17:55:06','2021-06-22 17:55:06',NULL),(4002,3150,1146,40737,23187,2,96,2,9318500.50,NULL,'2021-06-22 17:55:06','2021-06-22 17:55:06',NULL),(4003,3150,1146,40737,23187,2,67,2,1955415.11,NULL,'2021-06-22 17:55:06','2021-06-22 17:55:06',NULL),(4004,3150,1147,40737,23188,2,13,1,11200610.96,NULL,'2021-06-22 18:02:26','2021-06-22 18:02:26',NULL),(4005,3150,1147,40737,23188,2,96,2,9256703.27,NULL,'2021-06-22 18:02:26','2021-06-22 18:02:26',NULL),(4006,3150,1147,40737,23188,2,67,2,1943907.69,NULL,'2021-06-22 18:02:26','2021-06-22 18:02:26',NULL),(4007,3150,1148,40737,23189,2,13,1,11593246.28,NULL,'2021-06-22 18:03:35','2021-06-22 18:03:35',NULL),(4008,3150,1148,40737,23189,2,96,2,9581195.27,NULL,'2021-06-22 18:03:35','2021-06-22 18:03:35',NULL),(4009,3150,1148,40737,23189,2,67,2,2012051.01,NULL,'2021-06-22 18:03:35','2021-06-22 18:03:35',NULL),(4010,3150,1149,40737,23190,2,13,1,14049022.10,NULL,'2021-06-22 18:04:36','2021-06-22 18:04:36',NULL),(4011,3150,1149,40737,23190,2,96,2,11610762.07,NULL,'2021-06-22 18:04:36','2021-06-22 18:04:36',NULL),(4012,3150,1149,40737,23190,2,67,2,2438260.03,NULL,'2021-06-22 18:04:36','2021-06-22 18:04:36',NULL),(4013,3150,1150,40737,23176,6,155,1,1194009.41,NULL,'2021-06-22 18:11:32','2021-06-22 18:11:32',NULL),(4014,3150,1150,40737,23176,6,492,2,63548.45,NULL,'2021-06-22 18:11:32','2021-06-22 18:11:32',NULL),(4015,3150,1150,40737,23176,6,23,2,85844.66,NULL,'2021-06-22 18:11:32','2021-06-22 18:11:32',NULL),(4016,3150,1150,40737,23176,6,20,2,58026.69,NULL,'2021-06-22 18:11:32','2021-06-22 18:11:32',NULL),(4017,3150,1150,40737,23176,6,20,2,154761.05,NULL,'2021-06-22 18:11:32','2021-06-22 18:11:32',NULL),(4018,3150,1150,40737,23176,6,79,2,831828.56,NULL,'2021-06-22 18:11:32','2021-06-22 18:11:32',NULL),(4019,3150,1151,40737,23176,3,522,1,1552966.80,NULL,'2021-06-22 18:24:40','2021-06-24 17:54:55','2021-06-24 17:54:55'),(4020,3150,1151,40737,23176,3,416,1,4019704.59,NULL,'2021-06-22 18:24:40','2021-06-24 17:54:55','2021-06-24 17:54:55'),(4021,3150,1151,40737,23176,3,506,1,12880.36,NULL,'2021-06-22 18:24:40','2021-06-24 17:54:55','2021-06-24 17:54:55'),(4022,3150,1151,40737,23176,3,199,1,1626.02,NULL,'2021-06-22 18:24:40','2021-06-24 17:54:55','2021-06-24 17:54:55'),(4023,3150,1151,40737,23176,3,513,1,70521.47,NULL,'2021-06-22 18:24:40','2021-06-24 17:54:55','2021-06-24 17:54:55'),(4024,3150,1151,40737,23176,3,512,1,82913.55,NULL,'2021-06-22 18:24:40','2021-06-24 17:54:55','2021-06-24 17:54:55'),(4025,3150,1151,40737,23176,3,68,1,1211514.40,NULL,'2021-06-22 18:24:40','2021-06-24 17:54:55','2021-06-24 17:54:55'),(4026,3150,1151,40737,23176,3,57,2,6952127.19,NULL,'2021-06-22 18:24:40','2021-06-24 17:54:55','2021-06-24 17:54:55'),(4027,3150,1152,40737,23177,3,192,1,13000.00,NULL,'2021-06-22 18:37:30','2021-06-24 17:58:10','2021-06-24 17:58:10'),(4028,3150,1152,40737,23177,3,192,1,3000.00,NULL,'2021-06-22 18:37:30','2021-06-24 17:58:10','2021-06-24 17:58:10'),(4029,3150,1152,40737,23177,3,126,1,49459.40,NULL,'2021-06-22 18:37:30','2021-06-24 17:58:10','2021-06-24 17:58:10'),(4030,3150,1152,40737,23177,3,522,1,120061.83,NULL,'2021-06-22 18:37:30','2021-06-24 17:58:10','2021-06-24 17:58:10'),(4031,3150,1152,40737,23177,3,416,1,2858521.43,NULL,'2021-06-22 18:37:30','2021-06-24 17:58:10','2021-06-24 17:58:10'),(4032,3150,1152,40737,23177,3,509,1,24072.00,NULL,'2021-06-22 18:37:30','2021-06-24 17:58:10','2021-06-24 17:58:10'),(4033,3150,1152,40737,23177,3,68,1,643674.08,NULL,'2021-06-22 18:37:30','2021-06-24 17:58:10','2021-06-24 17:58:10'),(4034,3150,1152,40737,23177,3,513,1,33192.90,NULL,'2021-06-22 18:37:30','2021-06-24 17:58:10','2021-06-24 17:58:10');
INSERT INTO `balance_libro_details` VALUES (4035,3150,1152,40737,23177,3,512,1,35412.27,NULL,'2021-06-22 18:37:30','2021-06-24 17:58:10','2021-06-24 17:58:10'),(4036,3150,1152,40737,23177,3,57,2,3780393.91,NULL,'2021-06-22 18:37:30','2021-06-24 17:58:10','2021-06-24 17:58:10'),(4037,3150,1153,40737,23181,3,192,1,12000.00,NULL,'2021-06-22 18:43:28','2021-06-24 18:00:01','2021-06-24 18:00:01'),(4038,3150,1153,40737,23181,3,126,1,283776.00,NULL,'2021-06-22 18:43:28','2021-06-24 18:00:01','2021-06-24 18:00:01'),(4039,3150,1153,40737,23181,3,522,1,477675.00,NULL,'2021-06-22 18:43:28','2021-06-24 18:00:01','2021-06-24 18:00:01'),(4040,3150,1153,40737,23181,3,416,1,3491398.00,NULL,'2021-06-22 18:43:28','2021-06-24 18:00:01','2021-06-24 18:00:01'),(4041,3150,1153,40737,23181,3,135,1,10268.60,NULL,'2021-06-22 18:43:28','2021-06-24 18:00:01','2021-06-24 18:00:01'),(4042,3150,1153,40737,23181,3,506,1,5005.96,NULL,'2021-06-22 18:43:28','2021-06-24 18:00:01','2021-06-24 18:00:01'),(4043,3150,1153,40737,23181,3,509,1,2479.34,NULL,'2021-06-22 18:43:28','2021-06-24 18:00:01','2021-06-24 18:00:01'),(4044,3150,1153,40737,23181,3,513,1,65413.60,NULL,'2021-06-22 18:43:28','2021-06-24 18:00:01','2021-06-24 18:00:01'),(4045,3150,1153,40737,23181,3,512,1,70044.12,NULL,'2021-06-22 18:43:28','2021-06-24 18:00:01','2021-06-24 18:00:01'),(4046,3150,1153,40737,23181,3,68,1,860295.43,NULL,'2021-06-22 18:43:28','2021-06-24 18:00:01','2021-06-24 18:00:01'),(4047,3150,1153,40737,23181,3,57,2,5278356.05,NULL,'2021-06-22 18:43:28','2021-06-24 18:00:01','2021-06-24 18:00:01'),(4048,3150,1154,40737,23182,3,192,1,48000.00,NULL,'2021-06-22 18:47:31','2021-06-24 18:01:56','2021-06-24 18:01:56'),(4049,3150,1154,40737,23182,3,192,1,12000.00,NULL,'2021-06-22 18:47:31','2021-06-24 18:01:56','2021-06-24 18:01:56'),(4050,3150,1154,40737,23182,3,126,1,325890.03,NULL,'2021-06-22 18:47:31','2021-06-24 18:01:56','2021-06-24 18:01:56'),(4051,3150,1154,40737,23182,3,522,1,2311864.27,NULL,'2021-06-22 18:47:31','2021-06-24 18:01:56','2021-06-24 18:01:56'),(4052,3150,1154,40737,23182,3,416,1,1744952.00,NULL,'2021-06-22 18:47:31','2021-06-24 18:01:56','2021-06-24 18:01:56'),(4053,3150,1154,40737,23182,3,135,1,20893.00,NULL,'2021-06-22 18:47:31','2021-06-24 18:01:56','2021-06-24 18:01:56'),(4054,3150,1154,40737,23182,3,513,1,40935.78,NULL,'2021-06-22 18:47:31','2021-06-24 18:01:56','2021-06-24 18:01:56'),(4055,3150,1154,40737,23182,3,512,1,65134.83,NULL,'2021-06-22 18:47:31','2021-06-24 18:01:56','2021-06-24 18:01:56'),(4056,3150,1154,40737,23182,3,68,1,898147.33,NULL,'2021-06-22 18:47:31','2021-06-24 18:01:56','2021-06-24 18:01:56'),(4057,3150,1154,40737,23182,3,57,2,5467817.24,NULL,'2021-06-22 18:47:31','2021-06-24 18:01:56','2021-06-24 18:01:56'),(4058,3150,1155,40737,23183,3,192,1,16000.00,NULL,'2021-06-22 18:52:20','2021-06-22 19:10:55','2021-06-22 19:10:55'),(4059,3150,1155,40737,23183,3,192,1,38000.00,NULL,'2021-06-22 18:52:20','2021-06-22 19:10:55','2021-06-22 19:10:55'),(4060,3150,1155,40737,23183,3,126,1,702869.15,NULL,'2021-06-22 18:52:20','2021-06-22 19:10:55','2021-06-22 19:10:55'),(4061,3150,1155,40737,23183,3,522,1,796453.11,NULL,'2021-06-22 18:52:20','2021-06-22 19:10:55','2021-06-22 19:10:55'),(4062,3150,1155,40737,23183,3,416,1,7800759.40,NULL,'2021-06-22 18:52:20','2021-06-22 19:10:55','2021-06-22 19:10:55'),(4063,3150,1155,40737,23183,3,199,1,1652.89,NULL,'2021-06-22 18:52:20','2021-06-22 19:10:55','2021-06-22 19:10:55'),(4064,3150,1155,40737,23183,3,513,1,48102.00,NULL,'2021-06-22 18:52:20','2021-06-22 19:10:55','2021-06-22 19:10:55'),(4065,3150,1155,40737,23183,3,512,1,233969.89,NULL,'2021-06-22 18:52:20','2021-06-22 19:10:55','2021-06-22 19:10:55'),(4066,3150,1155,40737,23183,3,68,1,1891834.26,NULL,'2021-06-22 18:52:20','2021-06-22 19:10:55','2021-06-22 19:10:55'),(4067,3150,1155,40737,23183,3,57,2,11529640.70,NULL,'2021-06-22 18:52:20','2021-06-22 19:10:55','2021-06-22 19:10:55'),(4068,3150,1156,40737,23185,3,192,1,42000.00,NULL,'2021-06-22 18:57:19','2021-06-24 18:12:11','2021-06-24 18:12:11');
INSERT INTO `balance_libro_details` VALUES (4069,3150,1156,40737,23185,3,126,1,338814.38,NULL,'2021-06-22 18:57:19','2021-06-24 18:12:11','2021-06-24 18:12:11'),(4070,3150,1156,40737,23185,3,522,1,1455211.16,NULL,'2021-06-22 18:57:19','2021-06-24 18:12:11','2021-06-24 18:12:11'),(4071,3150,1156,40737,23185,3,416,1,7792284.35,NULL,'2021-06-22 18:57:19','2021-06-24 18:12:11','2021-06-24 18:12:11'),(4072,3150,1156,40737,23185,3,135,1,60000.00,NULL,'2021-06-22 18:57:19','2021-06-24 18:12:11','2021-06-24 18:12:11'),(4073,3150,1156,40737,23185,3,513,1,50512.28,NULL,'2021-06-22 18:57:19','2021-06-24 18:12:11','2021-06-24 18:12:11'),(4074,3150,1156,40737,23185,3,512,1,86692.43,NULL,'2021-06-22 18:57:19','2021-06-24 18:12:11','2021-06-24 18:12:11'),(4075,3150,1156,40737,23185,3,68,1,1985642.59,NULL,'2021-06-22 18:57:19','2021-06-24 18:12:11','2021-06-24 18:12:11'),(4076,3150,1156,40737,23185,3,57,2,11811157.19,NULL,'2021-06-22 18:57:19','2021-06-24 18:12:11','2021-06-24 18:12:11'),(4077,3150,1157,40737,23186,3,192,1,16000.00,NULL,'2021-06-22 19:03:01','2021-06-24 18:29:16','2021-06-24 18:29:16'),(4078,3150,1157,40737,23186,3,192,1,38000.00,NULL,'2021-06-22 19:03:01','2021-06-24 18:29:16','2021-06-24 18:29:16'),(4079,3150,1157,40737,23186,3,126,1,406645.33,NULL,'2021-06-22 19:03:01','2021-06-24 18:29:16','2021-06-24 18:29:16'),(4080,3150,1157,40737,23186,3,416,1,7465992.71,NULL,'2021-06-22 19:03:01','2021-06-24 18:29:16','2021-06-24 18:29:16'),(4081,3150,1157,40737,23186,3,135,1,60000.00,NULL,'2021-06-22 19:03:01','2021-06-24 18:29:16','2021-06-24 18:29:16'),(4082,3150,1157,40737,23186,3,506,1,13005.11,NULL,'2021-06-22 19:03:01','2021-06-24 18:29:16','2021-06-24 18:29:16'),(4083,3150,1157,40737,23186,3,199,1,1239.67,NULL,'2021-06-22 19:03:01','2021-06-24 18:29:16','2021-06-24 18:29:16'),(4084,3150,1157,40737,23186,3,513,1,37291.08,NULL,'2021-06-22 19:03:01','2021-06-24 18:29:16','2021-06-24 18:29:16'),(4085,3150,1157,40737,23186,3,512,1,339683.33,NULL,'2021-06-22 19:03:01','2021-06-24 18:29:16','2021-06-24 18:29:16'),(4086,3150,1157,40737,23186,3,57,2,10076443.91,NULL,'2021-06-22 19:03:01','2021-06-24 18:29:16','2021-06-24 18:29:16'),(4087,3150,1157,40737,23186,3,68,1,1698586.68,NULL,'2021-06-22 19:03:01','2021-06-24 18:29:16','2021-06-24 18:29:16'),(4088,3150,1158,40737,23187,3,192,1,38000.00,NULL,'2021-06-22 19:08:29','2021-06-24 18:33:16','2021-06-24 18:33:16'),(4089,3150,1158,40737,23187,3,126,1,545551.83,NULL,'2021-06-22 19:08:29','2021-06-24 18:33:16','2021-06-24 18:33:16'),(4090,3150,1158,40737,23187,3,522,1,1070198.51,NULL,'2021-06-22 19:08:29','2021-06-24 18:33:16','2021-06-24 18:33:16'),(4091,3150,1158,40737,23187,3,416,1,8276994.66,NULL,'2021-06-22 19:08:29','2021-06-24 18:33:16','2021-06-24 18:33:16'),(4092,3150,1158,40737,23187,3,135,1,60000.00,NULL,'2021-06-22 19:08:29','2021-06-24 18:33:16','2021-06-24 18:33:16'),(4093,3150,1158,40737,23187,3,513,1,26036.08,NULL,'2021-06-22 19:08:29','2021-06-24 18:33:16','2021-06-24 18:33:16'),(4094,3150,1158,40737,23187,3,512,1,360259.05,NULL,'2021-06-22 19:08:29','2021-06-24 18:33:16','2021-06-24 18:33:16'),(4095,3150,1158,40737,23187,3,68,1,2008481.03,NULL,'2021-06-22 19:08:29','2021-06-24 18:33:16','2021-06-24 18:33:16'),(4096,3150,1158,40737,23187,3,57,2,12385521.16,NULL,'2021-06-22 19:08:29','2021-06-24 18:33:16','2021-06-24 18:33:16'),(4097,3150,1159,40737,23187,3,192,1,38000.00,NULL,'2021-06-22 19:08:29','2021-06-22 19:08:43','2021-06-22 19:08:43'),(4098,3150,1159,40737,23187,3,126,1,545551.83,NULL,'2021-06-22 19:08:29','2021-06-22 19:08:43','2021-06-22 19:08:43'),(4099,3150,1159,40737,23187,3,522,1,1070198.51,NULL,'2021-06-22 19:08:29','2021-06-22 19:08:43','2021-06-22 19:08:43'),(4100,3150,1159,40737,23187,3,416,1,8276994.66,NULL,'2021-06-22 19:08:29','2021-06-22 19:08:43','2021-06-22 19:08:43'),(4101,3150,1159,40737,23187,3,135,1,60000.00,NULL,'2021-06-22 19:08:29','2021-06-22 19:08:43','2021-06-22 19:08:43'),(4102,3150,1159,40737,23187,3,513,1,26036.08,NULL,'2021-06-22 19:08:29','2021-06-22 19:08:43','2021-06-22 19:08:43');
INSERT INTO `balance_libro_details` VALUES (4103,3150,1159,40737,23187,3,512,1,360259.05,NULL,'2021-06-22 19:08:29','2021-06-22 19:08:43','2021-06-22 19:08:43'),(4104,3150,1159,40737,23187,3,68,1,2008481.03,NULL,'2021-06-22 19:08:29','2021-06-22 19:08:43','2021-06-22 19:08:43'),(4105,3150,1159,40737,23187,3,57,2,12385521.16,NULL,'2021-06-22 19:08:29','2021-06-22 19:08:43','2021-06-22 19:08:43'),(4106,3150,1160,40737,23184,3,192,1,16000.00,NULL,'2021-06-22 19:10:55','2021-06-24 18:06:20','2021-06-24 18:06:20'),(4107,3150,1160,40737,23184,3,192,1,38000.00,NULL,'2021-06-22 19:10:55','2021-06-24 18:06:20','2021-06-24 18:06:20'),(4108,3150,1160,40737,23184,3,126,1,702869.15,NULL,'2021-06-22 19:10:55','2021-06-24 18:06:20','2021-06-24 18:06:20'),(4109,3150,1160,40737,23184,3,522,1,796453.11,NULL,'2021-06-22 19:10:55','2021-06-24 18:06:20','2021-06-24 18:06:20'),(4110,3150,1160,40737,23184,3,416,1,7800759.40,NULL,'2021-06-22 19:10:55','2021-06-24 18:06:20','2021-06-24 18:06:20'),(4111,3150,1160,40737,23184,3,199,1,1652.89,NULL,'2021-06-22 19:10:55','2021-06-24 18:06:20','2021-06-24 18:06:20'),(4112,3150,1160,40737,23184,3,513,1,48102.00,NULL,'2021-06-22 19:10:55','2021-06-24 18:06:20','2021-06-24 18:06:20'),(4113,3150,1160,40737,23184,3,512,1,233969.89,NULL,'2021-06-22 19:10:55','2021-06-24 18:06:20','2021-06-24 18:06:20'),(4114,3150,1160,40737,23184,3,68,1,1891834.26,NULL,'2021-06-22 19:10:55','2021-06-24 18:06:20','2021-06-24 18:06:20'),(4115,3150,1160,40737,23184,3,57,2,11529640.70,NULL,'2021-06-22 19:10:55','2021-06-24 18:06:20','2021-06-24 18:06:20'),(4116,3150,1161,40737,23183,3,192,1,3000.00,NULL,'2021-06-22 19:13:44','2021-06-24 18:03:23','2021-06-24 18:03:23'),(4117,3150,1161,40737,23183,3,126,1,323718.75,NULL,'2021-06-22 19:13:44','2021-06-24 18:03:23','2021-06-24 18:03:23'),(4118,3150,1161,40737,23183,3,522,1,2398655.62,NULL,'2021-06-22 19:13:44','2021-06-24 18:03:23','2021-06-24 18:03:23'),(4119,3150,1161,40737,23183,3,416,1,3903960.50,NULL,'2021-06-22 19:13:44','2021-06-24 18:03:23','2021-06-24 18:03:23'),(4120,3150,1161,40737,23183,3,506,1,3394.84,NULL,'2021-06-22 19:13:44','2021-06-24 18:03:23','2021-06-24 18:03:23'),(4121,3150,1161,40737,23183,3,68,1,1367324.64,NULL,'2021-06-22 19:13:44','2021-06-24 18:03:23','2021-06-24 18:03:23'),(4122,3150,1161,40737,23183,3,513,1,103584.30,NULL,'2021-06-22 19:13:44','2021-06-24 18:03:23','2021-06-24 18:03:23'),(4123,3150,1161,40737,23183,3,512,1,94819.02,NULL,'2021-06-22 19:13:44','2021-06-24 18:03:23','2021-06-24 18:03:23'),(4124,3150,1161,40737,23183,3,57,2,8198457.67,NULL,'2021-06-22 19:13:44','2021-06-24 18:03:23','2021-06-24 18:03:23'),(4125,3150,1162,40737,23188,3,192,1,16000.00,NULL,'2021-06-22 19:17:49','2021-06-24 18:35:56','2021-06-24 18:35:56'),(4126,3150,1162,40737,23188,3,192,1,43250.00,NULL,'2021-06-22 19:17:49','2021-06-24 18:35:56','2021-06-24 18:35:56'),(4127,3150,1162,40737,23188,3,126,1,400875.00,NULL,'2021-06-22 19:17:49','2021-06-24 18:35:56','2021-06-24 18:35:56'),(4128,3150,1162,40737,23188,3,522,1,1952624.28,NULL,'2021-06-22 19:17:49','2021-06-24 18:35:56','2021-06-24 18:35:56'),(4129,3150,1162,40737,23188,3,416,1,5824628.80,NULL,'2021-06-22 19:17:49','2021-06-24 18:35:56','2021-06-24 18:35:56'),(4130,3150,1162,40737,23188,3,135,1,60000.00,NULL,'2021-06-22 19:17:49','2021-06-24 18:35:56','2021-06-24 18:35:56'),(4131,3150,1162,40737,23188,3,199,1,2479.34,NULL,'2021-06-22 19:17:49','2021-06-24 18:35:56','2021-06-24 18:35:56'),(4132,3150,1162,40737,23188,3,68,1,1685337.66,NULL,'2021-06-22 19:17:49','2021-06-24 18:35:56','2021-06-24 18:35:56'),(4133,3150,1162,40737,23188,3,513,1,85052.55,NULL,'2021-06-22 19:17:49','2021-06-24 18:35:56','2021-06-24 18:35:56'),(4134,3150,1162,40737,23188,3,512,1,131522.69,NULL,'2021-06-22 19:17:49','2021-06-24 18:35:56','2021-06-24 18:35:56'),(4135,3150,1162,40737,23188,3,57,2,10201770.32,NULL,'2021-06-22 19:17:49','2021-06-24 18:35:56','2021-06-24 18:35:56'),(4136,3150,1163,40737,23188,2,192,1,43250.00,NULL,'2021-06-22 19:21:34','2021-06-22 19:25:46','2021-06-22 19:25:46');
INSERT INTO `balance_libro_details` VALUES (4137,3150,1163,40737,23188,2,126,1,300352.00,NULL,'2021-06-22 19:21:34','2021-06-22 19:25:46','2021-06-22 19:25:46'),(4138,3150,1163,40737,23188,2,522,1,2657006.80,NULL,'2021-06-22 19:21:34','2021-06-22 19:25:46','2021-06-22 19:25:46'),(4139,3150,1163,40737,23188,2,416,1,6561847.27,NULL,'2021-06-22 19:21:34','2021-06-22 19:25:46','2021-06-22 19:25:46'),(4140,3150,1163,40737,23188,2,135,1,70032.00,NULL,'2021-06-22 19:21:34','2021-06-22 19:25:46','2021-06-22 19:25:46'),(4141,3150,1163,40737,23188,2,506,1,1437.99,NULL,'2021-06-22 19:21:34','2021-06-22 19:25:46','2021-06-22 19:25:46'),(4142,3150,1163,40737,23188,2,68,1,1968939.85,NULL,'2021-06-22 19:21:34','2021-06-22 19:25:46','2021-06-22 19:25:46'),(4143,3150,1163,40737,23188,2,513,1,117676.70,NULL,'2021-06-22 19:21:34','2021-06-22 19:25:46','2021-06-22 19:25:46'),(4144,3150,1163,40737,23188,2,512,1,393273.14,NULL,'2021-06-22 19:21:34','2021-06-22 19:25:46','2021-06-22 19:25:46'),(4145,3150,1163,40737,23188,2,57,2,12113815.75,NULL,'2021-06-22 19:21:34','2021-06-22 19:25:46','2021-06-22 19:25:46'),(4146,3150,1164,40737,23190,3,192,1,16000.00,NULL,'2021-06-22 19:25:13','2021-06-24 18:40:20','2021-06-24 18:40:20'),(4147,3150,1164,40737,23190,3,192,1,1263413.75,NULL,'2021-06-22 19:25:13','2021-06-24 18:40:20','2021-06-24 18:40:20'),(4148,3150,1164,40737,23190,3,126,1,472465.60,NULL,'2021-06-22 19:25:13','2021-06-24 18:40:20','2021-06-24 18:40:20'),(4149,3150,1164,40737,23190,3,522,1,1976179.40,NULL,'2021-06-22 19:25:13','2021-06-24 18:40:20','2021-06-24 18:40:20'),(4150,3150,1164,40737,23190,3,416,1,8771421.79,NULL,'2021-06-22 19:25:13','2021-06-24 18:40:20','2021-06-24 18:40:20'),(4151,3150,1164,40737,23190,3,135,1,60000.00,NULL,'2021-06-22 19:25:13','2021-06-24 18:40:20','2021-06-24 18:40:20'),(4152,3150,1164,40737,23190,3,506,1,3583.72,NULL,'2021-06-22 19:25:13','2021-06-24 18:40:20','2021-06-24 18:40:20'),(4153,3150,1164,40737,23190,3,68,1,2592399.32,NULL,'2021-06-22 19:25:13','2021-06-24 18:40:20','2021-06-24 18:40:20'),(4154,3150,1164,40737,23190,3,513,1,49682.80,NULL,'2021-06-22 19:25:13','2021-06-24 18:40:20','2021-06-24 18:40:20'),(4155,3150,1164,40737,23190,3,512,1,51269.22,NULL,'2021-06-22 19:25:13','2021-06-24 18:40:20','2021-06-24 18:40:20'),(4156,3150,1164,40737,23190,3,57,2,15256415.60,NULL,'2021-06-22 19:25:13','2021-06-24 18:40:20','2021-06-24 18:40:20'),(4157,3150,1165,40737,23189,2,192,1,43250.00,NULL,'2021-06-22 19:25:46','2021-06-22 19:26:42','2021-06-22 19:26:42'),(4158,3150,1165,40737,23189,2,126,1,300352.00,NULL,'2021-06-22 19:25:46','2021-06-22 19:26:42','2021-06-22 19:26:42'),(4159,3150,1165,40737,23189,2,522,1,2657006.80,NULL,'2021-06-22 19:25:46','2021-06-22 19:26:42','2021-06-22 19:26:42'),(4160,3150,1165,40737,23189,2,416,1,6561847.27,NULL,'2021-06-22 19:25:46','2021-06-22 19:26:42','2021-06-22 19:26:42'),(4161,3150,1165,40737,23189,2,135,1,70032.00,NULL,'2021-06-22 19:25:46','2021-06-22 19:26:42','2021-06-22 19:26:42'),(4162,3150,1165,40737,23189,2,506,1,1437.99,NULL,'2021-06-22 19:25:46','2021-06-22 19:26:42','2021-06-22 19:26:42'),(4163,3150,1165,40737,23189,2,68,1,1968939.85,NULL,'2021-06-22 19:25:46','2021-06-22 19:26:42','2021-06-22 19:26:42'),(4164,3150,1165,40737,23189,2,513,1,117676.70,NULL,'2021-06-22 19:25:46','2021-06-22 19:26:42','2021-06-22 19:26:42'),(4165,3150,1165,40737,23189,2,512,1,393273.14,NULL,'2021-06-22 19:25:46','2021-06-22 19:26:42','2021-06-22 19:26:42'),(4166,3150,1165,40737,23189,2,57,2,12113815.75,NULL,'2021-06-22 19:25:46','2021-06-22 19:26:42','2021-06-22 19:26:42'),(4167,3150,1166,40737,23189,3,192,1,43250.00,NULL,'2021-06-22 19:26:42','2021-06-24 18:38:02','2021-06-24 18:38:02'),(4168,3150,1166,40737,23189,3,126,1,300352.00,NULL,'2021-06-22 19:26:42','2021-06-24 18:38:02','2021-06-24 18:38:02'),(4169,3150,1166,40737,23189,3,522,1,2657006.80,NULL,'2021-06-22 19:26:42','2021-06-24 18:38:02','2021-06-24 18:38:02'),(4170,3150,1166,40737,23189,3,416,1,6561847.27,NULL,'2021-06-22 19:26:42','2021-06-24 18:38:02','2021-06-24 18:38:02');
INSERT INTO `balance_libro_details` VALUES (4171,3150,1166,40737,23189,3,135,1,70032.00,NULL,'2021-06-22 19:26:42','2021-06-24 18:38:02','2021-06-24 18:38:02'),(4172,3150,1166,40737,23189,3,506,1,1437.99,NULL,'2021-06-22 19:26:42','2021-06-24 18:38:02','2021-06-24 18:38:02'),(4173,3150,1166,40737,23189,3,68,1,1968939.85,NULL,'2021-06-22 19:26:42','2021-06-24 18:38:02','2021-06-24 18:38:02'),(4174,3150,1166,40737,23189,3,513,1,117676.70,NULL,'2021-06-22 19:26:42','2021-06-24 18:38:02','2021-06-24 18:38:02'),(4175,3150,1166,40737,23189,3,512,1,393273.14,NULL,'2021-06-22 19:26:42','2021-06-24 18:38:02','2021-06-24 18:38:02'),(4176,3150,1166,40737,23189,3,57,2,12113815.75,NULL,'2021-06-22 19:26:42','2021-06-24 18:38:02','2021-06-24 18:38:02'),(4177,3150,1167,40737,23176,18,23,1,12687.53,NULL,'2021-06-22 19:30:33','2021-06-22 19:37:42','2021-06-22 19:37:42'),(4178,3150,1167,40737,23176,18,13,2,12687.53,NULL,'2021-06-22 19:30:33','2021-06-22 19:37:42','2021-06-22 19:37:42'),(4179,3150,1168,40737,23177,18,23,1,3981.27,NULL,'2021-06-22 19:31:33','2021-06-22 19:37:36','2021-06-22 19:37:36'),(4180,3150,1168,40737,23177,18,13,2,3981.27,NULL,'2021-06-22 19:31:33','2021-06-22 19:37:36','2021-06-22 19:37:36'),(4181,3150,1169,40737,23181,18,23,1,4870.10,NULL,'2021-06-22 19:32:17','2021-06-22 19:37:27','2021-06-22 19:37:27'),(4182,3150,1169,40737,23181,18,13,2,4870.10,NULL,'2021-06-22 19:32:17','2021-06-22 19:37:27','2021-06-22 19:37:27'),(4183,3150,1170,40737,23182,18,23,1,5481.28,NULL,'2021-06-22 19:33:05','2021-06-22 19:37:14','2021-06-22 19:37:14'),(4184,3150,1170,40737,23182,18,13,2,5481.28,NULL,'2021-06-22 19:33:05','2021-06-22 19:37:14','2021-06-22 19:37:14'),(4185,3150,1171,40737,23183,18,23,1,5434.35,NULL,'2021-06-22 19:34:03','2021-06-22 19:37:05','2021-06-22 19:37:05'),(4186,3150,1171,40737,23183,18,13,2,5434.35,NULL,'2021-06-22 19:34:03','2021-06-22 19:37:05','2021-06-22 19:37:05'),(4187,3150,1172,40737,23184,18,23,1,16362.12,NULL,'2021-06-22 19:34:45','2021-06-22 19:35:13','2021-06-22 19:35:13'),(4188,3150,1172,40737,23184,18,13,2,16362.12,NULL,'2021-06-22 19:34:45','2021-06-22 19:35:13','2021-06-22 19:35:13'),(4189,3150,1173,40737,23184,18,23,1,2549.76,NULL,'2021-06-22 19:35:13','2021-06-22 19:36:55','2021-06-22 19:36:55'),(4190,3150,1173,40737,23184,18,13,2,2549.76,NULL,'2021-06-22 19:35:13','2021-06-22 19:36:55','2021-06-22 19:36:55'),(4191,3150,1174,40737,23185,7,23,1,16362.12,NULL,'2021-06-22 19:36:38','2021-06-22 19:36:38',NULL),(4192,3150,1174,40737,23185,7,13,2,16362.12,NULL,'2021-06-22 19:36:38','2021-06-22 19:36:38',NULL),(4193,3150,1175,40737,23184,7,23,1,2549.76,NULL,'2021-06-22 19:36:55','2021-06-22 19:36:55',NULL),(4194,3150,1175,40737,23184,7,13,2,2549.76,NULL,'2021-06-22 19:36:55','2021-06-22 19:36:55',NULL),(4195,3150,1176,40737,23183,7,23,1,5434.35,NULL,'2021-06-22 19:37:05','2021-06-22 19:37:05',NULL),(4196,3150,1176,40737,23183,7,13,2,5434.35,NULL,'2021-06-22 19:37:05','2021-06-22 19:37:05',NULL),(4197,3150,1177,40737,23182,7,23,1,5481.28,NULL,'2021-06-22 19:37:14','2021-06-22 19:37:14',NULL),(4198,3150,1177,40737,23182,7,13,2,5481.28,NULL,'2021-06-22 19:37:14','2021-06-22 19:37:14',NULL),(4199,3150,1178,40737,23181,7,23,1,4870.10,NULL,'2021-06-22 19:37:27','2021-06-22 19:37:27',NULL),(4200,3150,1178,40737,23181,7,13,2,4870.10,NULL,'2021-06-22 19:37:27','2021-06-22 19:37:27',NULL),(4201,3150,1179,40737,23177,7,23,1,3981.27,NULL,'2021-06-22 19:37:36','2021-06-22 19:37:36',NULL),(4202,3150,1179,40737,23177,7,13,2,3981.27,NULL,'2021-06-22 19:37:36','2021-06-22 19:37:36',NULL),(4203,3150,1180,40737,23176,7,23,1,12687.53,NULL,'2021-06-22 19:37:42','2021-06-22 19:37:42',NULL),(4204,3150,1180,40737,23176,7,13,2,12687.53,NULL,'2021-06-22 19:37:42','2021-06-22 19:37:42',NULL),(4205,3150,1181,40737,23186,7,23,1,15308.59,NULL,'2021-06-22 19:38:37','2021-06-22 19:38:37',NULL),(4206,3150,1181,40737,23186,7,13,2,15308.59,NULL,'2021-06-22 19:38:37','2021-06-22 19:38:37',NULL),(4207,3150,1182,40737,23187,7,23,1,41291.82,NULL,'2021-06-22 19:39:22','2021-06-22 19:39:22',NULL);
INSERT INTO `balance_libro_details` VALUES (4208,3150,1182,40737,23187,7,13,2,41291.82,NULL,'2021-06-22 19:39:22','2021-06-22 19:39:22',NULL),(4209,3150,1183,40737,23189,7,23,1,6419.12,NULL,'2021-06-22 19:40:23','2021-06-22 19:40:23',NULL),(4210,3150,1183,40737,23189,7,13,2,6419.12,NULL,'2021-06-22 19:40:23','2021-06-22 19:40:23',NULL),(4211,3150,1184,40737,23190,7,23,1,27218.35,NULL,'2021-06-22 19:41:12','2021-06-22 19:41:12',NULL),(4212,3150,1184,40737,23190,7,13,2,27218.35,NULL,'2021-06-22 19:41:12','2021-06-22 19:41:12',NULL),(4213,3150,1185,40737,23176,6,20,1,19342.23,NULL,'2021-06-22 19:43:54','2021-06-22 19:43:54',NULL),(4214,3150,1185,40737,23176,6,57,2,19342.23,NULL,'2021-06-22 19:43:54','2021-06-22 19:43:54',NULL),(4215,3150,1186,40737,23176,10,74,1,84681.33,NULL,'2021-06-22 19:45:09','2021-06-22 19:45:09',NULL),(4216,3150,1186,40737,23176,10,57,2,84681.33,NULL,'2021-06-22 19:45:09','2021-06-22 19:45:09',NULL),(4217,3150,1187,40737,23177,10,74,1,574139.92,NULL,'2021-06-22 19:46:18','2021-06-22 19:47:10','2021-06-22 19:47:10'),(4218,3150,1187,40737,23177,10,57,2,574139.92,NULL,'2021-06-22 19:46:18','2021-06-22 19:47:10','2021-06-22 19:47:10'),(4219,3150,1188,40737,23177,10,74,1,574139.92,NULL,'2021-06-22 19:47:10','2021-06-22 19:47:27','2021-06-22 19:47:27'),(4220,3150,1188,40737,23177,10,57,2,574139.92,NULL,'2021-06-22 19:47:10','2021-06-22 19:47:27','2021-06-22 19:47:27'),(4221,3150,1189,40737,23176,10,74,1,574139.92,NULL,'2021-06-22 19:47:27','2021-06-22 19:47:27',NULL),(4222,3150,1189,40737,23176,10,57,2,574139.92,NULL,'2021-06-22 19:47:27','2021-06-22 19:47:27',NULL),(4223,3150,1190,40737,23177,10,74,1,134938.51,NULL,'2021-06-22 19:48:25','2021-06-22 19:48:25',NULL),(4224,3150,1190,40737,23177,10,57,2,134938.51,NULL,'2021-06-22 19:48:25','2021-06-22 19:48:25',NULL),(4225,3150,1191,40737,23177,6,20,1,19342.23,NULL,'2021-06-22 19:54:31','2021-06-22 19:54:31',NULL),(4226,3150,1191,40737,23177,6,467,1,3391.79,NULL,'2021-06-22 19:54:31','2021-06-22 19:54:31',NULL),(4227,3150,1191,40737,23177,6,57,2,22734.02,NULL,'2021-06-22 19:54:31','2021-06-22 19:54:31',NULL),(4228,3150,1192,40737,23181,10,74,1,142347.04,NULL,'2021-06-22 19:56:47','2021-06-22 19:56:47',NULL),(4229,3150,1192,40737,23181,10,57,2,142347.04,NULL,'2021-06-22 19:56:47','2021-06-22 19:56:47',NULL),(4230,3150,1193,40737,23181,6,20,1,19342.23,NULL,'2021-06-22 19:57:50','2021-06-22 19:57:50',NULL),(4231,3150,1193,40737,23181,6,57,2,19342.23,NULL,'2021-06-22 19:57:50','2021-06-22 19:57:50',NULL),(4232,3150,1194,40737,23182,10,74,1,64175.83,NULL,'2021-06-22 20:00:07','2021-06-22 20:00:07',NULL),(4233,3150,1194,40737,23182,10,57,2,64175.83,NULL,'2021-06-22 20:00:07','2021-06-22 20:00:07',NULL),(4234,3150,1195,40737,23182,6,493,1,19342.23,NULL,'2021-06-22 20:01:48','2021-06-22 20:03:59','2021-06-22 20:03:59'),(4235,3150,1195,40737,23182,6,57,2,19342.23,NULL,'2021-06-22 20:01:48','2021-06-22 20:03:59','2021-06-22 20:03:59'),(4236,3150,1196,40737,23183,10,74,1,74413.16,NULL,'2021-06-22 20:02:39','2021-06-22 20:02:39',NULL),(4237,3150,1196,40737,23183,10,57,2,74413.16,NULL,'2021-06-22 20:02:39','2021-06-22 20:02:39',NULL),(4238,3150,1197,40737,23184,6,20,1,19342.23,NULL,'2021-06-22 20:03:38','2021-06-22 20:03:38',NULL),(4239,3150,1197,40737,23184,6,57,2,19342.23,NULL,'2021-06-22 20:03:38','2021-06-22 20:03:38',NULL),(4240,3150,1198,40737,23182,6,57,2,19342.23,NULL,'2021-06-22 20:03:59','2021-06-22 20:03:59',NULL),(4241,3150,1198,40737,23182,6,20,1,19342.23,NULL,'2021-06-22 20:03:59','2021-06-22 20:03:59',NULL),(4242,3150,1199,40737,23184,10,74,1,36657.59,NULL,'2021-06-22 20:05:10','2021-06-22 20:05:10',NULL),(4243,3150,1199,40737,23184,10,57,2,36657.59,NULL,'2021-06-22 20:05:10','2021-06-22 20:05:10',NULL),(4244,3150,1200,40737,23185,10,74,1,203795.69,NULL,'2021-06-22 20:09:34','2021-06-22 20:09:34',NULL),(4245,3150,1200,40737,23185,10,57,2,203795.69,NULL,'2021-06-22 20:09:34','2021-06-22 20:09:34',NULL),(4246,3150,1201,40737,23186,10,74,1,181022.56,NULL,'2021-06-22 20:10:19','2021-06-22 20:10:19',NULL);
INSERT INTO `balance_libro_details` VALUES (4247,3150,1201,40737,23186,10,57,2,181022.56,NULL,'2021-06-22 20:10:19','2021-06-22 20:10:19',NULL),(4248,3150,1202,40737,23187,10,74,1,42575.47,NULL,'2021-06-22 20:11:00','2021-06-22 20:11:00',NULL),(4249,3150,1202,40737,23187,10,57,2,42575.47,NULL,'2021-06-22 20:11:00','2021-06-22 20:11:00',NULL),(4250,3150,1203,40737,23188,10,57,1,92310.12,NULL,'2021-06-22 20:11:55','2021-06-22 20:11:55',NULL),(4251,3150,1203,40737,23188,10,20,2,92310.12,NULL,'2021-06-22 20:11:55','2021-06-22 20:11:55',NULL),(4252,3150,1204,40737,23189,10,74,1,94415.48,NULL,'2021-06-22 20:13:36','2021-06-22 20:13:36',NULL),(4253,3150,1204,40737,23189,10,57,2,94415.48,NULL,'2021-06-22 20:13:36','2021-06-22 20:13:36',NULL),(4254,3150,1205,40737,23190,6,20,1,92310.12,NULL,'2021-06-22 20:14:20','2021-06-22 20:14:20',NULL),(4255,3150,1205,40737,23190,6,57,2,92310.12,NULL,'2021-06-22 20:14:20','2021-06-22 20:14:20',NULL),(4256,3150,1206,40737,23185,10,78,1,19276.71,NULL,'2021-06-22 20:15:49','2021-06-22 20:15:49',NULL),(4257,3150,1206,40737,23185,10,57,2,19276.71,NULL,'2021-06-22 20:15:49','2021-06-22 20:15:49',NULL),(4258,3150,1207,40737,23186,10,78,1,36726.42,NULL,'2021-06-22 20:17:22','2021-06-22 20:17:22',NULL),(4259,3150,1207,40737,23186,10,57,2,36726.42,NULL,'2021-06-22 20:17:22','2021-06-22 20:17:22',NULL),(4260,3150,1208,40737,23187,10,78,1,90455.76,NULL,'2021-06-22 20:18:19','2021-06-22 20:18:19',NULL),(4261,3150,1208,40737,23187,10,57,2,90455.76,NULL,'2021-06-22 20:18:19','2021-06-22 20:18:19',NULL),(4262,3150,1209,40737,23188,10,78,1,66547.49,NULL,'2021-06-22 20:19:06','2021-06-22 20:19:06',NULL),(4263,3150,1209,40737,23188,10,57,2,66547.49,NULL,'2021-06-22 20:19:06','2021-06-22 20:19:06',NULL),(4264,3150,1210,40737,23189,10,78,1,25456.49,NULL,'2021-06-22 20:20:00','2021-06-22 20:20:00',NULL),(4265,3150,1210,40737,23189,10,57,2,25456.49,NULL,'2021-06-22 20:20:00','2021-06-22 20:20:00',NULL),(4266,3150,1211,40737,23190,10,78,1,36405.65,NULL,'2021-06-22 20:21:08','2021-06-22 20:21:08',NULL),(4267,3150,1211,40737,23190,10,57,2,36405.65,NULL,'2021-06-22 20:21:08','2021-06-22 20:21:08',NULL),(4268,3150,1212,40737,23176,19,13,2,5908012.64,NULL,'2021-06-22 21:54:03','2021-06-27 23:21:38','2021-06-27 23:21:38'),(4269,3150,1212,40737,23176,19,517,2,6884.40,NULL,'2021-06-22 21:54:03','2021-06-27 23:21:38','2021-06-27 23:21:38'),(4270,3150,1212,40737,23176,19,396,1,21996.66,NULL,'2021-06-22 21:54:03','2021-06-27 23:21:38','2021-06-27 23:21:38'),(4271,3150,1212,40737,23176,19,492,1,12828.62,NULL,'2021-06-22 21:54:03','2021-06-27 23:21:38','2021-06-27 23:21:38'),(4272,3150,1212,40737,23176,19,157,1,58973.74,NULL,'2021-06-22 21:54:03','2021-06-27 23:21:38','2021-06-27 23:21:38'),(4273,3150,1212,40737,23176,19,351,1,177240.33,NULL,'2021-06-22 21:54:03','2021-06-27 23:21:38','2021-06-27 23:21:38'),(4274,3150,1212,40737,23176,19,512,1,859.69,NULL,'2021-06-22 21:54:03','2021-06-27 23:21:38','2021-06-27 23:21:38'),(4275,3150,1212,40737,23176,19,512,1,5110.58,NULL,'2021-06-22 21:54:03','2021-06-27 23:21:38','2021-06-27 23:21:38'),(4276,3150,1212,40737,23176,19,472,1,80000.00,NULL,'2021-06-22 21:54:03','2021-06-27 23:21:38','2021-06-27 23:21:38'),(4277,3150,1212,40737,23176,19,57,1,3691437.68,NULL,'2021-06-22 21:54:03','2021-06-27 23:21:38','2021-06-27 23:21:38'),(4278,3150,1212,40737,23176,19,521,1,1866449.74,NULL,'2021-06-22 21:54:03','2021-06-27 23:21:38','2021-06-27 23:21:38'),(4279,3150,1213,40737,23177,19,13,2,4704202.89,NULL,'2021-06-22 22:01:43','2021-06-27 18:18:48','2021-06-27 18:18:48'),(4280,3150,1213,40737,23177,19,517,2,5371.35,NULL,'2021-06-22 22:01:43','2021-06-27 18:18:48','2021-06-27 18:18:48'),(4281,3150,1213,40737,23177,19,140,1,22937.49,NULL,'2021-06-22 22:01:43','2021-06-27 18:18:48','2021-06-27 18:18:48'),(4282,3150,1213,40737,23177,19,492,1,9231.30,NULL,'2021-06-22 22:01:43','2021-06-27 18:18:48','2021-06-27 18:18:48'),(4283,3150,1213,40737,23177,19,157,1,41344.75,NULL,'2021-06-22 22:01:43','2021-06-27 18:18:48','2021-06-27 18:18:48');
INSERT INTO `balance_libro_details` VALUES (4284,3150,1213,40737,23177,19,351,1,141126.04,NULL,'2021-06-22 22:01:43','2021-06-27 18:18:48','2021-06-27 18:18:48'),(4285,3150,1213,40737,23177,19,512,1,930.09,NULL,'2021-06-22 22:01:43','2021-06-27 18:18:48','2021-06-27 18:18:48'),(4286,3150,1213,40737,23177,19,512,1,4072.57,NULL,'2021-06-22 22:01:43','2021-06-27 18:18:48','2021-06-27 18:18:48'),(4287,3150,1213,40737,23177,19,472,1,220000.00,NULL,'2021-06-22 22:01:43','2021-06-27 18:18:48','2021-06-27 18:18:48'),(4288,3150,1213,40737,23177,19,57,1,4238755.59,NULL,'2021-06-22 22:01:43','2021-06-27 18:18:48','2021-06-27 18:18:48'),(4289,3150,1213,40737,23177,19,521,1,31176.41,NULL,'2021-06-22 22:01:43','2021-06-27 18:18:48','2021-06-27 18:18:48'),(4290,3150,1214,40737,23181,19,13,2,4761202.50,NULL,'2021-06-22 22:13:13','2021-06-27 23:23:47','2021-06-27 23:23:47'),(4291,3150,1214,40737,23181,19,517,1,17419.35,NULL,'2021-06-22 22:13:13','2021-06-27 23:23:47','2021-06-27 23:23:47'),(4292,3150,1214,40737,23181,19,396,1,32218.93,NULL,'2021-06-22 22:13:13','2021-06-27 23:23:47','2021-06-27 23:23:47'),(4293,3150,1214,40737,23181,19,351,1,166642.00,NULL,'2021-06-22 22:13:13','2021-06-27 23:23:47','2021-06-27 23:23:47'),(4294,3150,1214,40737,23181,19,512,1,946.70,NULL,'2021-06-22 22:13:13','2021-06-27 23:23:47','2021-06-27 23:23:47'),(4295,3150,1214,40737,23181,19,512,1,4807.52,NULL,'2021-06-22 22:13:13','2021-06-27 23:23:47','2021-06-27 23:23:47'),(4296,3150,1214,40737,23181,19,472,1,40000.00,NULL,'2021-06-22 22:13:13','2021-06-27 23:23:47','2021-06-27 23:23:47'),(4297,3150,1214,40737,23181,19,57,1,3734861.64,NULL,'2021-06-22 22:13:13','2021-06-27 23:23:47','2021-06-27 23:23:47'),(4298,3150,1214,40737,23181,19,521,1,720136.59,NULL,'2021-06-22 22:13:13','2021-06-27 23:23:47','2021-06-27 23:23:47'),(4299,3150,1214,40737,23181,19,492,1,44169.77,NULL,'2021-06-22 22:13:13','2021-06-27 23:23:47','2021-06-27 23:23:47'),(4300,3150,1215,40737,23182,19,13,2,4030439.94,NULL,'2021-06-22 22:16:19','2021-06-27 23:25:37','2021-06-27 23:25:37'),(4301,3150,1215,40737,23182,19,517,2,10500.00,NULL,'2021-06-22 22:16:19','2021-06-27 23:25:37','2021-06-27 23:25:37'),(4302,3150,1215,40737,23182,19,396,1,11540.17,NULL,'2021-06-22 22:16:19','2021-06-27 23:25:37','2021-06-27 23:25:37'),(4303,3150,1215,40737,23182,19,492,1,45080.67,NULL,'2021-06-22 22:16:19','2021-06-27 23:25:37','2021-06-27 23:25:37'),(4304,3150,1215,40737,23182,19,351,1,141065.37,NULL,'2021-06-22 22:16:19','2021-06-27 23:25:37','2021-06-27 23:25:37'),(4305,3150,1215,40737,23182,19,512,1,334.20,NULL,'2021-06-22 22:16:19','2021-06-27 23:25:37','2021-06-27 23:25:37'),(4306,3150,1215,40737,23182,19,512,1,3357.34,NULL,'2021-06-22 22:16:19','2021-06-27 23:25:37','2021-06-27 23:25:37'),(4307,3150,1215,40737,23182,19,472,1,110000.00,NULL,'2021-06-22 22:16:19','2021-06-27 23:25:37','2021-06-27 23:25:37'),(4308,3150,1215,40737,23182,19,57,1,832290.97,NULL,'2021-06-22 22:16:19','2021-06-27 23:25:37','2021-06-27 23:25:37'),(4309,3150,1215,40737,23182,19,521,1,2897271.22,NULL,'2021-06-22 22:16:19','2021-06-27 23:25:37','2021-06-27 23:25:37'),(4310,3150,1216,40737,23183,19,13,2,5363087.75,NULL,'2021-06-22 22:20:13','2021-06-27 18:18:16','2021-06-27 18:18:16'),(4311,3150,1216,40737,23183,19,517,2,12572.52,NULL,'2021-06-22 22:20:13','2021-06-27 18:18:16','2021-06-27 18:18:16'),(4312,3150,1216,40737,23183,19,140,1,30463.35,NULL,'2021-06-22 22:20:13','2021-06-27 18:18:16','2021-06-27 18:18:16'),(4313,3150,1216,40737,23183,19,492,1,47389.46,NULL,'2021-06-22 22:20:13','2021-06-27 18:18:16','2021-06-27 18:18:16'),(4314,3150,1216,40737,23183,19,472,1,110000.00,NULL,'2021-06-22 22:20:13','2021-06-27 18:18:16','2021-06-27 18:18:16'),(4315,3150,1216,40737,23183,19,21,1,1092.79,NULL,'2021-06-22 22:20:13','2021-06-27 18:18:16','2021-06-27 18:18:16'),(4316,3150,1216,40737,23183,19,351,1,182843.03,NULL,'2021-06-22 22:20:13','2021-06-27 18:18:16','2021-06-27 18:18:16');
INSERT INTO `balance_libro_details` VALUES (4317,3150,1216,40737,23183,19,512,1,1206.21,NULL,'2021-06-22 22:20:13','2021-06-27 18:18:16','2021-06-27 18:18:16'),(4318,3150,1216,40737,23183,19,512,1,3285.56,NULL,'2021-06-22 22:20:13','2021-06-27 18:18:16','2021-06-27 18:18:16'),(4319,3150,1216,40737,23183,19,57,1,4571857.94,NULL,'2021-06-22 22:20:13','2021-06-27 18:18:16','2021-06-27 18:18:16'),(4320,3150,1216,40737,23183,19,521,1,427521.93,NULL,'2021-06-22 22:20:13','2021-06-27 18:18:16','2021-06-27 18:18:16'),(4321,3150,1217,40737,23184,19,13,2,7992822.26,NULL,'2021-06-22 22:27:41','2021-06-27 23:27:20','2021-06-27 23:27:20'),(4322,3150,1217,40737,23184,19,517,1,22633.14,NULL,'2021-06-22 22:27:41','2021-06-27 23:27:20','2021-06-27 23:27:20'),(4323,3150,1217,40737,23184,19,396,1,15635.98,NULL,'2021-06-22 22:27:41','2021-06-27 23:27:20','2021-06-27 23:27:20'),(4324,3150,1217,40737,23184,19,21,1,1023.93,NULL,'2021-06-22 22:27:41','2021-06-27 23:27:20','2021-06-27 23:27:20'),(4325,3150,1217,40737,23184,19,351,1,15985.58,NULL,'2021-06-22 22:27:41','2021-06-27 23:27:20','2021-06-27 23:27:20'),(4326,3150,1217,40737,23184,19,512,1,620.90,NULL,'2021-06-22 22:27:41','2021-06-27 23:27:20','2021-06-27 23:27:20'),(4327,3150,1217,40737,23184,19,512,1,6565.10,NULL,'2021-06-22 22:27:41','2021-06-27 23:27:20','2021-06-27 23:27:20'),(4328,3150,1217,40737,23184,19,472,1,110000.00,NULL,'2021-06-22 22:27:41','2021-06-27 23:27:20','2021-06-27 23:27:20'),(4329,3150,1217,40737,23184,19,57,1,5142804.80,NULL,'2021-06-22 22:27:41','2021-06-27 23:27:20','2021-06-27 23:27:20'),(4330,3150,1217,40737,23184,19,521,1,2589634.09,NULL,'2021-06-22 22:27:41','2021-06-27 23:27:20','2021-06-27 23:27:20'),(4331,3150,1217,40737,23184,19,492,1,87918.74,NULL,'2021-06-22 22:27:41','2021-06-27 23:27:20','2021-06-27 23:27:20'),(4332,3150,1218,40737,23185,19,13,2,4827817.65,NULL,'2021-06-22 22:30:19','2021-06-27 23:28:18','2021-06-27 23:28:18'),(4333,3150,1218,40737,23185,19,517,2,11273.87,NULL,'2021-06-22 22:30:19','2021-06-27 23:28:18','2021-06-27 23:28:18'),(4334,3150,1218,40737,23185,19,396,1,32758.07,NULL,'2021-06-22 22:30:19','2021-06-27 23:28:18','2021-06-27 23:28:18'),(4335,3150,1218,40737,23185,19,492,1,88871.25,NULL,'2021-06-22 22:30:19','2021-06-27 23:28:18','2021-06-27 23:28:18'),(4336,3150,1218,40737,23185,19,351,1,120695.39,NULL,'2021-06-22 22:30:19','2021-06-27 23:28:18','2021-06-27 23:28:18'),(4337,3150,1218,40737,23185,19,512,1,1288.55,NULL,'2021-06-22 22:30:19','2021-06-27 23:28:18','2021-06-27 23:28:18'),(4338,3150,1218,40737,23185,19,512,1,4121.01,NULL,'2021-06-22 22:30:19','2021-06-27 23:28:18','2021-06-27 23:28:18'),(4339,3150,1218,40737,23185,19,472,1,110000.00,NULL,'2021-06-22 22:30:19','2021-06-27 23:28:18','2021-06-27 23:28:18'),(4340,3150,1218,40737,23185,19,57,1,9199152.24,NULL,'2021-06-22 22:30:19','2021-06-27 23:28:18','2021-06-27 23:28:18'),(4341,3150,1218,40737,23185,19,521,2,4717794.99,NULL,'2021-06-22 22:30:19','2021-06-27 23:28:18','2021-06-27 23:28:18'),(4342,3150,1219,40737,23186,19,13,2,9728882.16,NULL,'2021-06-22 22:33:51','2021-06-27 18:17:41','2021-06-27 18:17:41'),(4343,3150,1219,40737,23186,19,517,1,11713.25,NULL,'2021-06-22 22:33:51','2021-06-27 18:17:41','2021-06-27 18:17:41'),(4344,3150,1219,40737,23186,19,140,1,41325.44,NULL,'2021-06-22 22:33:51','2021-06-27 18:17:41','2021-06-27 18:17:41'),(4345,3150,1219,40737,23186,19,492,1,120267.31,NULL,'2021-06-22 22:33:51','2021-06-27 18:17:41','2021-06-27 18:17:41'),(4346,3150,1219,40737,23186,19,21,1,590.85,NULL,'2021-06-22 22:33:51','2021-06-27 18:17:41','2021-06-27 18:17:41'),(4347,3150,1219,40737,23186,19,351,1,243222.00,NULL,'2021-06-22 22:33:51','2021-06-27 18:17:41','2021-06-27 18:17:41'),(4348,3150,1219,40737,23186,19,512,1,1696.70,NULL,'2021-06-22 22:33:51','2021-06-27 18:17:41','2021-06-27 18:17:41'),(4349,3150,1219,40737,23186,19,512,1,8586.75,NULL,'2021-06-22 22:33:51','2021-06-27 18:17:41','2021-06-27 18:17:41');
INSERT INTO `balance_libro_details` VALUES (4350,3150,1219,40737,23186,19,472,1,110000.00,NULL,'2021-06-22 22:33:51','2021-06-27 18:17:41','2021-06-27 18:17:41'),(4351,3150,1219,40737,23186,19,57,1,9745932.98,NULL,'2021-06-22 22:33:51','2021-06-27 18:17:41','2021-06-27 18:17:41'),(4352,3150,1219,40737,23186,19,521,2,554453.12,NULL,'2021-06-22 22:33:51','2021-06-27 18:17:41','2021-06-27 18:17:41'),(4353,3150,1220,40737,23187,19,13,2,11408401.34,NULL,'2021-06-22 22:36:23','2021-06-27 18:17:00','2021-06-27 18:17:00'),(4354,3150,1220,40737,23187,19,517,2,16583.50,NULL,'2021-06-22 22:36:23','2021-06-27 18:17:00','2021-06-27 18:17:00'),(4355,3150,1220,40737,23187,19,140,1,41006.96,NULL,'2021-06-22 22:36:23','2021-06-27 18:17:00','2021-06-27 18:17:00'),(4356,3150,1220,40737,23187,19,492,1,125263.70,NULL,'2021-06-22 22:36:23','2021-06-27 18:17:00','2021-06-27 18:17:00'),(4357,3150,1220,40737,23187,19,351,1,285209.99,NULL,'2021-06-22 22:36:23','2021-06-27 18:17:00','2021-06-27 18:17:00'),(4358,3150,1220,40737,23187,19,512,1,1664.01,NULL,'2021-06-22 22:36:23','2021-06-27 18:17:00','2021-06-27 18:17:00'),(4359,3150,1220,40737,23187,19,512,1,9670.50,NULL,'2021-06-22 22:36:23','2021-06-27 18:17:00','2021-06-27 18:17:00'),(4360,3150,1220,40737,23187,19,472,1,150000.00,NULL,'2021-06-22 22:36:23','2021-06-27 18:17:00','2021-06-27 18:17:00'),(4361,3150,1220,40737,23187,19,57,1,9218020.59,NULL,'2021-06-22 22:36:23','2021-06-27 18:17:00','2021-06-27 18:17:00'),(4362,3150,1220,40737,23187,19,521,1,1594149.09,NULL,'2021-06-22 22:36:23','2021-06-27 18:17:00','2021-06-27 18:17:00'),(4363,3150,1221,40737,23188,19,13,2,5463422.32,NULL,'2021-06-22 22:39:03','2021-06-25 13:28:12','2021-06-25 13:28:12'),(4364,3150,1221,40737,23188,19,517,1,15778.30,NULL,'2021-06-22 22:39:03','2021-06-25 13:28:12','2021-06-25 13:28:12'),(4365,3150,1221,40737,23188,19,140,1,11943.56,NULL,'2021-06-22 22:39:03','2021-06-25 13:28:12','2021-06-25 13:28:12'),(4366,3150,1221,40737,23188,19,492,1,64990.32,NULL,'2021-06-22 22:39:03','2021-06-25 13:28:12','2021-06-25 13:28:12'),(4367,3150,1221,40737,23188,19,351,1,10926.82,NULL,'2021-06-22 22:39:03','2021-06-25 13:28:12','2021-06-25 13:28:12'),(4368,3150,1221,40737,23188,19,512,1,410.52,NULL,'2021-06-22 22:39:03','2021-06-25 13:28:12','2021-06-25 13:28:12'),(4369,3150,1221,40737,23188,19,512,1,5151.70,NULL,'2021-06-22 22:39:03','2021-06-25 13:28:12','2021-06-25 13:28:12'),(4370,3150,1221,40737,23188,19,27,1,140000.00,NULL,'2021-06-22 22:39:03','2021-06-25 13:28:12','2021-06-25 13:28:12'),(4371,3150,1221,40737,23188,19,57,1,6605803.35,NULL,'2021-06-22 22:39:03','2021-06-25 13:28:12','2021-06-25 13:28:12'),(4372,3150,1221,40737,23188,19,521,2,1391582.25,NULL,'2021-06-22 22:39:03','2021-06-25 13:28:12','2021-06-25 13:28:12'),(4373,3150,1222,40737,23189,19,13,2,8801017.49,NULL,'2021-06-22 22:41:29','2021-06-27 18:15:38','2021-06-27 18:15:38'),(4374,3150,1222,40737,23189,19,517,1,405.79,NULL,'2021-06-22 22:41:29','2021-06-27 18:15:38','2021-06-27 18:15:38'),(4375,3150,1222,40737,23189,19,140,1,22923.39,NULL,'2021-06-22 22:41:29','2021-06-27 18:15:38','2021-06-27 18:15:38'),(4376,3150,1222,40737,23189,19,492,1,122497.67,NULL,'2021-06-22 22:41:29','2021-06-27 18:15:38','2021-06-27 18:15:38'),(4377,3150,1222,40737,23189,19,351,1,8946.70,NULL,'2021-06-22 22:41:29','2021-06-27 18:15:38','2021-06-27 18:15:38'),(4378,3150,1222,40737,23189,19,512,1,810.34,NULL,'2021-06-22 22:41:29','2021-06-27 18:15:38','2021-06-27 18:15:38'),(4379,3150,1222,40737,23189,19,512,1,8054.87,NULL,'2021-06-22 22:41:29','2021-06-27 18:15:38','2021-06-27 18:15:38'),(4380,3150,1222,40737,23189,19,472,1,80000.00,NULL,'2021-06-22 22:41:29','2021-06-27 18:15:38','2021-06-27 18:15:38'),(4381,3150,1222,40737,23189,19,57,1,10063102.03,NULL,'2021-06-22 22:41:29','2021-06-27 18:15:38','2021-06-27 18:15:38'),(4382,3150,1222,40737,23189,19,521,2,1505723.30,NULL,'2021-06-22 22:41:29','2021-06-27 18:15:38','2021-06-27 18:15:38');
INSERT INTO `balance_libro_details` VALUES (4383,3150,1223,40737,23190,19,13,2,8946719.48,NULL,'2021-06-22 22:44:36','2021-06-24 19:11:43','2021-06-24 19:11:43'),(4384,3150,1223,40737,23190,19,517,2,9356.44,NULL,'2021-06-22 22:44:36','2021-06-24 19:11:43','2021-06-24 19:11:43'),(4385,3150,1223,40737,23190,19,396,1,26256.95,NULL,'2021-06-22 22:44:36','2021-06-24 19:11:43','2021-06-24 19:11:43'),(4386,3150,1223,40737,23190,19,492,1,114246.54,NULL,'2021-06-22 22:44:36','2021-06-24 19:11:43','2021-06-24 19:11:43'),(4387,3150,1223,40737,23190,19,351,1,18556.82,NULL,'2021-06-22 22:44:36','2021-06-24 19:11:43','2021-06-24 19:11:43'),(4388,3150,1223,40737,23190,19,512,1,1076.14,NULL,'2021-06-22 22:44:36','2021-06-24 19:11:43','2021-06-24 19:11:43'),(4389,3150,1223,40737,23190,19,512,1,8280.30,NULL,'2021-06-22 22:44:36','2021-06-24 19:11:43','2021-06-24 19:11:43'),(4390,3150,1223,40737,23190,19,472,1,110000.00,NULL,'2021-06-22 22:44:36','2021-06-24 19:11:43','2021-06-24 19:11:43'),(4391,3150,1223,40737,23190,19,57,1,10528444.21,NULL,'2021-06-22 22:44:36','2021-06-24 19:11:43','2021-06-24 19:11:43'),(4392,3150,1223,40737,23190,19,521,2,1850785.04,NULL,'2021-06-22 22:44:36','2021-06-24 19:11:43','2021-06-24 19:11:43'),(4393,3150,1224,40737,23176,15,67,1,1416974.38,NULL,'2021-06-22 23:08:34','2021-06-22 23:09:28','2021-06-22 23:09:28'),(4394,3150,1224,40737,23176,15,68,2,1211514.40,NULL,'2021-06-22 23:08:34','2021-06-22 23:09:28','2021-06-22 23:09:28'),(4395,3150,1224,40737,23176,15,513,2,70521.47,NULL,'2021-06-22 23:08:34','2021-06-22 23:09:28','2021-06-22 23:09:28'),(4396,3150,1224,40737,23176,15,73,2,134938.51,NULL,'2021-06-22 23:08:34','2021-06-22 23:09:28','2021-06-22 23:09:28'),(4397,3150,1225,40737,23176,15,67,1,1416974.38,NULL,'2021-06-22 23:09:28','2021-06-22 23:09:28',NULL),(4398,3150,1225,40737,23176,15,68,2,1211514.40,NULL,'2021-06-22 23:09:28','2021-06-22 23:09:28',NULL),(4399,3150,1225,40737,23176,15,513,2,70521.47,NULL,'2021-06-22 23:09:28','2021-06-22 23:09:28',NULL),(4400,3150,1225,40737,23176,15,74,2,134938.51,NULL,'2021-06-22 23:09:28','2021-06-22 23:09:28',NULL),(4401,3150,1226,40737,23177,15,67,1,819214.02,NULL,'2021-06-22 23:11:28','2021-06-24 20:28:40','2021-06-24 20:28:40'),(4402,3150,1226,40737,23177,15,68,2,643674.08,NULL,'2021-06-22 23:11:28','2021-06-24 20:28:40','2021-06-24 20:28:40'),(4403,3150,1226,40737,23177,15,513,2,33192.90,NULL,'2021-06-22 23:11:28','2021-06-24 20:28:40','2021-06-24 20:28:40'),(4404,3150,1226,40737,23177,15,74,2,142347.04,NULL,'2021-06-22 23:11:28','2021-06-24 20:28:40','2021-06-24 20:28:40'),(4405,3150,1227,40737,23181,15,67,1,989884.86,NULL,'2021-06-22 23:13:02','2021-06-24 20:34:32','2021-06-24 20:34:32'),(4406,3150,1227,40737,23181,15,68,2,860295.43,NULL,'2021-06-22 23:13:02','2021-06-24 20:34:32','2021-06-24 20:34:32'),(4407,3150,1227,40737,23181,15,513,2,65413.60,NULL,'2021-06-22 23:13:02','2021-06-24 20:34:32','2021-06-24 20:34:32'),(4408,3150,1227,40737,23181,15,74,2,64175.83,NULL,'2021-06-22 23:13:02','2021-06-24 20:34:32','2021-06-24 20:34:32'),(4409,3150,1228,40737,23182,15,67,1,1013496.27,NULL,'2021-06-22 23:14:51','2021-06-22 23:14:51',NULL),(4410,3150,1228,40737,23182,15,68,2,898147.33,NULL,'2021-06-22 23:14:51','2021-06-22 23:14:51',NULL),(4411,3150,1228,40737,23182,15,513,2,40935.78,NULL,'2021-06-22 23:14:51','2021-06-22 23:14:51',NULL),(4412,3150,1228,40737,23182,15,74,2,74413.16,NULL,'2021-06-22 23:14:51','2021-06-22 23:14:51',NULL),(4413,3150,1229,40737,23183,15,67,1,1507566.53,NULL,'2021-06-22 23:17:21','2021-06-22 23:17:21',NULL),(4414,3150,1229,40737,23183,15,68,2,1367324.64,NULL,'2021-06-22 23:17:21','2021-06-22 23:17:21',NULL),(4415,3150,1229,40737,23183,15,513,2,103584.30,NULL,'2021-06-22 23:17:21','2021-06-22 23:17:21',NULL),(4416,3150,1229,40737,23183,15,74,2,36657.59,NULL,'2021-06-22 23:17:21','2021-06-22 23:17:21',NULL),(4417,3150,1230,40737,23184,15,67,1,2143731.95,NULL,'2021-06-22 23:19:02','2021-06-22 23:19:02',NULL);
INSERT INTO `balance_libro_details` VALUES (4418,3150,1230,40737,23184,15,68,2,1891834.26,NULL,'2021-06-22 23:19:02','2021-06-22 23:19:02',NULL),(4419,3150,1230,40737,23184,15,513,2,48102.00,NULL,'2021-06-22 23:19:02','2021-06-22 23:19:02',NULL),(4420,3150,1230,40737,23184,15,74,2,203795.69,NULL,'2021-06-22 23:19:02','2021-06-22 23:19:02',NULL),(4421,3150,1231,40737,23185,15,67,1,2217177.43,NULL,'2021-06-22 23:20:31','2021-06-22 23:20:31',NULL),(4422,3150,1231,40737,23185,15,68,2,1985642.59,NULL,'2021-06-22 23:20:31','2021-06-22 23:20:31',NULL),(4423,3150,1231,40737,23185,15,513,2,50512.28,NULL,'2021-06-22 23:20:31','2021-06-22 23:20:31',NULL),(4424,3150,1231,40737,23185,15,74,2,181022.56,NULL,'2021-06-22 23:20:31','2021-06-22 23:20:31',NULL),(4425,3150,1232,40737,23186,15,67,1,1778453.21,NULL,'2021-06-22 23:21:54','2021-06-24 20:37:53','2021-06-24 20:37:53'),(4426,3150,1232,40737,23186,15,68,2,1698586.66,NULL,'2021-06-22 23:21:54','2021-06-24 20:37:53','2021-06-24 20:37:53'),(4427,3150,1232,40737,23186,15,513,2,37291.08,NULL,'2021-06-22 23:21:54','2021-06-24 20:37:53','2021-06-24 20:37:53'),(4428,3150,1232,40737,23186,15,74,2,42575.47,NULL,'2021-06-22 23:21:54','2021-06-24 20:37:53','2021-06-24 20:37:53'),(4429,3150,1233,40737,23187,15,67,1,1955415.11,NULL,'2021-06-22 23:25:42','2021-06-22 23:25:42',NULL),(4430,3150,1233,40737,23187,15,68,2,2008481.03,NULL,'2021-06-22 23:25:42','2021-06-22 23:25:42',NULL),(4431,3150,1233,40737,23187,15,513,2,26036.08,NULL,'2021-06-22 23:25:42','2021-06-22 23:25:42',NULL),(4432,3150,1233,40737,23187,15,354,1,26036.08,NULL,'2021-06-22 23:25:42','2021-06-22 23:25:42',NULL),(4433,3150,1233,40737,23187,15,353,1,53065.92,NULL,'2021-06-22 23:25:42','2021-06-22 23:25:42',NULL),(4434,3150,1234,40737,23188,15,67,1,1943907.69,NULL,'2021-06-22 23:42:13','2021-06-22 23:42:13',NULL),(4435,3150,1234,40737,23188,15,68,2,1685337.66,NULL,'2021-06-22 23:42:13','2021-06-22 23:42:13',NULL),(4436,3150,1234,40737,23188,15,513,2,85052.55,NULL,'2021-06-22 23:42:13','2021-06-22 23:42:13',NULL),(4437,3150,1234,40737,23188,15,354,2,26036.08,NULL,'2021-06-22 23:42:13','2021-06-22 23:42:13',NULL),(4438,3150,1234,40737,23188,15,353,2,53065.92,NULL,'2021-06-22 23:42:13','2021-06-22 23:42:13',NULL),(4439,3150,1234,40737,23188,15,74,2,94415.48,NULL,'2021-06-22 23:42:13','2021-06-22 23:42:13',NULL),(4440,3150,1235,40737,23189,15,67,1,2012051.01,NULL,'2021-06-22 23:48:17','2021-06-22 23:48:17',NULL),(4441,3150,1235,40737,23189,15,68,2,1968939.85,NULL,'2021-06-22 23:48:17','2021-06-22 23:48:17',NULL),(4442,3150,1235,40737,23189,15,513,2,117676.70,NULL,'2021-06-22 23:48:17','2021-06-22 23:48:17',NULL),(4443,3150,1235,40737,23189,15,354,1,74565.54,NULL,'2021-06-22 23:48:17','2021-06-22 23:48:17',NULL),(4444,3150,1236,40737,23190,15,67,1,2438260.03,NULL,'2021-06-23 00:09:12','2021-06-27 18:05:17','2021-06-27 18:05:17'),(4445,3150,1236,40737,23190,15,68,2,2592399.32,NULL,'2021-06-23 00:09:12','2021-06-27 18:05:17','2021-06-27 18:05:17'),(4446,3150,1236,40737,23190,15,513,2,49464.74,NULL,'2021-06-23 00:09:12','2021-06-27 18:05:17','2021-06-27 18:05:17'),(4447,3150,1236,40737,23190,15,354,1,49464.74,NULL,'2021-06-23 00:09:12','2021-06-27 18:05:17','2021-06-27 18:05:17'),(4448,3150,1236,40737,23190,15,353,1,154139.29,NULL,'2021-06-23 00:09:12','2021-06-27 18:05:17','2021-06-27 18:05:17'),(4449,3150,1237,40737,23176,16,156,1,173026.87,NULL,'2021-06-23 02:22:55','2021-06-23 02:26:28','2021-06-23 02:26:28'),(4450,3150,1237,40737,23176,16,21,2,6917.08,NULL,'2021-06-23 02:22:55','2021-06-23 02:26:28','2021-06-23 02:26:28'),(4451,3150,1237,40737,23176,16,512,2,82913.55,NULL,'2021-06-23 02:22:55','2021-06-23 02:26:28','2021-06-23 02:26:28'),(4452,3150,1237,40737,23176,16,351,2,177240.33,NULL,'2021-06-23 02:22:55','2021-06-23 02:26:28','2021-06-23 02:26:28'),(4453,3150,1237,40737,23176,16,78,2,65102.58,NULL,'2021-06-23 02:22:55','2021-06-23 02:26:28','2021-06-23 02:26:28'),(4454,3150,1237,40737,23176,16,494,2,1001340.81,NULL,'2021-06-23 02:22:55','2021-06-23 02:26:28','2021-06-23 02:26:28');
INSERT INTO `balance_libro_details` VALUES (4455,3150,1237,40737,23176,16,156,1,2018.00,NULL,'2021-06-23 02:22:55','2021-06-23 02:26:28','2021-06-23 02:26:28'),(4456,3150,1237,40737,23176,16,494,1,1158468.58,NULL,'2021-06-23 02:22:55','2021-06-23 02:26:28','2021-06-23 02:26:28'),(4457,3150,1237,40737,23176,16,136,1,0.90,NULL,'2021-06-23 02:22:55','2021-06-23 02:26:28','2021-06-23 02:26:28'),(4458,3150,1238,40737,23176,16,156,1,173026.87,NULL,'2021-06-23 02:26:28','2021-06-23 04:33:58','2021-06-23 04:33:58'),(4459,3150,1238,40737,23176,16,21,2,6917.08,NULL,'2021-06-23 02:26:28','2021-06-23 04:33:58','2021-06-23 04:33:58'),(4460,3150,1238,40737,23176,16,512,2,82913.55,NULL,'2021-06-23 02:26:28','2021-06-23 04:33:58','2021-06-23 04:33:58'),(4461,3150,1238,40737,23176,16,351,2,177240.33,NULL,'2021-06-23 02:26:28','2021-06-23 04:33:58','2021-06-23 04:33:58'),(4462,3150,1238,40737,23176,16,78,2,65102.58,NULL,'2021-06-23 02:26:28','2021-06-23 04:33:58','2021-06-23 04:33:58'),(4463,3150,1238,40737,23176,16,156,1,2018.00,NULL,'2021-06-23 02:26:28','2021-06-23 04:33:58','2021-06-23 04:33:58'),(4464,3150,1238,40737,23176,16,494,1,1158468.58,NULL,'2021-06-23 02:26:28','2021-06-23 04:33:58','2021-06-23 04:33:58'),(4465,3150,1238,40737,23176,16,136,1,0.90,NULL,'2021-06-23 02:26:28','2021-06-23 04:33:58','2021-06-23 04:33:58'),(4466,3150,1238,40737,23176,16,523,2,1001340.81,NULL,'2021-06-23 02:26:28','2021-06-23 04:33:58','2021-06-23 04:33:58'),(4467,3150,1239,40737,23181,16,523,2,1123207.35,NULL,'2021-06-23 04:05:51','2021-06-23 04:34:52','2021-06-23 04:34:52'),(4468,3150,1239,40737,23181,16,156,1,154.14,NULL,'2021-06-23 04:05:51','2021-06-23 04:34:52','2021-06-23 04:34:52'),(4469,3150,1239,40737,23181,16,156,1,66183.60,NULL,'2021-06-23 04:05:51','2021-06-23 04:34:52','2021-06-23 04:34:52'),(4470,3150,1239,40737,23181,16,21,2,9403.48,NULL,'2021-06-23 04:05:51','2021-06-23 04:34:52','2021-06-23 04:34:52'),(4471,3150,1239,40737,23181,16,512,2,70044.12,NULL,'2021-06-23 04:05:51','2021-06-23 04:34:52','2021-06-23 04:34:52'),(4472,3150,1239,40737,23181,16,351,2,166642.00,NULL,'2021-06-23 04:05:51','2021-06-23 04:34:52','2021-06-23 04:34:52'),(4473,3150,1239,40737,23181,16,494,1,1307759.33,NULL,'2021-06-23 04:05:51','2021-06-23 04:34:52','2021-06-23 04:34:52'),(4474,3150,1239,40737,23181,16,78,2,4800.12,NULL,'2021-06-23 04:05:51','2021-06-23 04:34:52','2021-06-23 04:34:52'),(4475,3150,1240,40737,23182,16,523,2,1307759.33,NULL,'2021-06-23 04:12:54','2021-06-23 04:35:30','2021-06-23 04:35:30'),(4476,3150,1240,40737,23182,16,156,1,157.82,NULL,'2021-06-23 04:12:54','2021-06-23 04:35:30','2021-06-23 04:35:30'),(4477,3150,1240,40737,23182,16,156,1,77581.11,NULL,'2021-06-23 04:12:54','2021-06-23 04:35:30','2021-06-23 04:35:30'),(4478,3150,1240,40737,23182,16,512,2,65134.83,NULL,'2021-06-23 04:12:54','2021-06-23 04:35:30','2021-06-23 04:35:30'),(4479,3150,1240,40737,23182,16,351,2,141065.37,NULL,'2021-06-23 04:12:54','2021-06-23 04:35:30','2021-06-23 04:35:30'),(4480,3150,1240,40737,23182,16,523,1,1435030.21,NULL,'2021-06-23 04:12:54','2021-06-23 04:35:30','2021-06-23 04:35:30'),(4481,3150,1240,40737,23182,16,136,1,1190.39,NULL,'2021-06-23 04:12:54','2021-06-23 04:35:30','2021-06-23 04:35:30'),(4482,3150,1241,40737,23184,16,523,2,1729867.99,NULL,'2021-06-23 04:16:54','2021-06-23 04:17:14','2021-06-23 04:17:14'),(4483,3150,1241,40737,23184,16,156,1,345.25,NULL,'2021-06-23 04:16:54','2021-06-23 04:17:14','2021-06-23 04:17:14'),(4484,3150,1241,40737,23184,16,156,1,169720.48,NULL,'2021-06-23 04:16:54','2021-06-23 04:17:14','2021-06-23 04:17:14'),(4485,3150,1241,40737,23184,16,512,2,86692.43,NULL,'2021-06-23 04:16:54','2021-06-23 04:17:14','2021-06-23 04:17:14'),(4486,3150,1241,40737,23184,16,351,2,120695.39,NULL,'2021-06-23 04:16:54','2021-06-23 04:17:14','2021-06-23 04:17:14'),(4487,3150,1241,40737,23184,16,78,2,30870.18,NULL,'2021-06-23 04:16:54','2021-06-23 04:17:14','2021-06-23 04:17:14'),(4488,3150,1241,40737,23184,16,494,1,1792532.49,NULL,'2021-06-23 04:16:54','2021-06-23 04:17:14','2021-06-23 04:17:14');
INSERT INTO `balance_libro_details` VALUES (4489,3150,1241,40737,23184,16,136,1,5527.77,NULL,'2021-06-23 04:16:54','2021-06-23 04:17:14','2021-06-23 04:17:14'),(4490,3150,1242,40737,23185,16,523,2,1729867.99,NULL,'2021-06-23 04:17:14','2021-06-23 04:36:09','2021-06-23 04:36:09'),(4491,3150,1242,40737,23185,16,156,1,345.25,NULL,'2021-06-23 04:17:14','2021-06-23 04:36:09','2021-06-23 04:36:09'),(4492,3150,1242,40737,23185,16,156,1,169720.48,NULL,'2021-06-23 04:17:14','2021-06-23 04:36:09','2021-06-23 04:36:09'),(4493,3150,1242,40737,23185,16,512,2,86692.43,NULL,'2021-06-23 04:17:14','2021-06-23 04:36:09','2021-06-23 04:36:09'),(4494,3150,1242,40737,23185,16,351,2,120695.39,NULL,'2021-06-23 04:17:14','2021-06-23 04:36:09','2021-06-23 04:36:09'),(4495,3150,1242,40737,23185,16,78,2,30870.18,NULL,'2021-06-23 04:17:14','2021-06-23 04:36:09','2021-06-23 04:36:09'),(4496,3150,1242,40737,23185,16,494,1,1792532.49,NULL,'2021-06-23 04:17:14','2021-06-23 04:36:09','2021-06-23 04:36:09'),(4497,3150,1242,40737,23185,16,136,1,5527.77,NULL,'2021-06-23 04:17:14','2021-06-23 04:36:09','2021-06-23 04:36:09'),(4498,3150,1243,40737,23186,16,523,2,1792532.49,NULL,'2021-06-23 04:20:32','2021-06-23 04:36:41','2021-06-23 04:36:41'),(4499,3150,1243,40737,23186,16,156,1,276.93,NULL,'2021-06-23 04:20:32','2021-06-23 04:36:41','2021-06-23 04:36:41'),(4500,3150,1243,40737,23186,16,156,1,136124.48,NULL,'2021-06-23 04:20:32','2021-06-23 04:36:41','2021-06-23 04:36:41'),(4501,3150,1243,40737,23186,16,512,2,339683.33,NULL,'2021-06-23 04:20:32','2021-06-23 04:36:41','2021-06-23 04:36:41'),(4502,3150,1243,40737,23186,16,351,2,243222.00,NULL,'2021-06-23 04:20:32','2021-06-23 04:36:41','2021-06-23 04:36:41'),(4503,3150,1243,40737,23186,16,78,2,9672.67,NULL,'2021-06-23 04:20:32','2021-06-23 04:36:41','2021-06-23 04:36:41'),(4504,3150,1243,40737,23186,16,494,1,2248709.08,NULL,'2021-06-23 04:20:32','2021-06-23 04:36:41','2021-06-23 04:36:41'),(4505,3150,1244,40737,23189,16,523,2,2709424.30,NULL,'2021-06-23 04:24:55','2021-06-23 04:37:14','2021-06-23 04:37:14'),(4506,3150,1244,40737,23189,16,156,1,313.31,NULL,'2021-06-23 04:24:55','2021-06-23 04:37:14','2021-06-23 04:37:14'),(4507,3150,1244,40737,23189,16,156,1,148974.19,NULL,'2021-06-23 04:24:55','2021-06-23 04:37:14','2021-06-23 04:37:14'),(4508,3150,1244,40737,23189,16,21,2,1514.94,NULL,'2021-06-23 04:24:55','2021-06-23 04:37:14','2021-06-23 04:37:14'),(4509,3150,1244,40737,23189,16,512,2,393273.14,NULL,'2021-06-23 04:24:55','2021-06-23 04:37:14','2021-06-23 04:37:14'),(4510,3150,1244,40737,23189,16,351,2,8800.97,NULL,'2021-06-23 04:24:55','2021-06-23 04:37:14','2021-06-23 04:37:14'),(4511,3150,1244,40737,23189,16,78,2,30637.00,NULL,'2021-06-23 04:24:55','2021-06-23 04:37:14','2021-06-23 04:37:14'),(4512,3150,1244,40737,23189,16,136,1,4138.26,NULL,'2021-06-23 04:24:55','2021-06-23 04:37:14','2021-06-23 04:37:14'),(4513,3150,1244,40737,23189,16,494,1,2990224.59,NULL,'2021-06-23 04:24:55','2021-06-23 04:37:14','2021-06-23 04:37:14'),(4514,3150,1245,40737,23190,16,523,2,2990224.59,NULL,'2021-06-23 04:29:50','2021-06-23 04:37:49','2021-06-23 04:37:49'),(4515,3150,1245,40737,23190,16,156,1,79.73,NULL,'2021-06-23 04:29:50','2021-06-23 04:37:49','2021-06-23 04:37:49'),(4516,3150,1245,40737,23190,16,156,1,39776.80,NULL,'2021-06-23 04:29:50','2021-06-23 04:37:49','2021-06-23 04:37:49'),(4517,3150,1245,40737,23190,16,512,2,51269.22,NULL,'2021-06-23 04:29:50','2021-06-23 04:37:49','2021-06-23 04:37:49'),(4518,3150,1245,40737,23190,16,351,2,8946.70,NULL,'2021-06-23 04:29:50','2021-06-23 04:37:49','2021-06-23 04:37:49'),(4519,3150,1245,40737,23190,16,78,2,3086.65,NULL,'2021-06-23 04:29:50','2021-06-23 04:37:49','2021-06-23 04:37:49'),(4520,3150,1245,40737,23190,16,494,1,3012589.58,NULL,'2021-06-23 04:29:50','2021-06-23 04:37:49','2021-06-23 04:37:49'),(4521,3150,1245,40737,23190,16,136,1,1081.05,NULL,'2021-06-23 04:29:50','2021-06-23 04:37:49','2021-06-23 04:37:49'),(4522,3150,1246,40737,23176,16,156,1,173026.87,NULL,'2021-06-23 04:33:58','2021-06-23 04:33:58',NULL);
INSERT INTO `balance_libro_details` VALUES (4523,3150,1246,40737,23176,16,21,2,6917.08,NULL,'2021-06-23 04:33:58','2021-06-23 04:33:58',NULL),(4524,3150,1246,40737,23176,16,512,2,82913.55,NULL,'2021-06-23 04:33:58','2021-06-23 04:33:58',NULL),(4525,3150,1246,40737,23176,16,351,2,177240.33,NULL,'2021-06-23 04:33:58','2021-06-23 04:33:58',NULL),(4526,3150,1246,40737,23176,16,78,2,65102.58,NULL,'2021-06-23 04:33:58','2021-06-23 04:33:58',NULL),(4527,3150,1246,40737,23176,16,156,1,2018.00,NULL,'2021-06-23 04:33:58','2021-06-23 04:33:58',NULL),(4528,3150,1246,40737,23176,16,494,1,1158468.58,NULL,'2021-06-23 04:33:58','2021-06-23 04:33:58',NULL),(4529,3150,1246,40737,23176,16,136,1,0.90,NULL,'2021-06-23 04:33:58','2021-06-23 04:33:58',NULL),(4530,3150,1246,40737,23176,16,494,2,1001340.81,NULL,'2021-06-23 04:33:58','2021-06-23 04:33:58',NULL),(4531,3150,1247,40737,23181,16,156,1,154.14,NULL,'2021-06-23 04:34:52','2021-06-27 00:02:47','2021-06-27 00:02:47'),(4532,3150,1247,40737,23181,16,156,1,66183.60,NULL,'2021-06-23 04:34:52','2021-06-27 00:02:47','2021-06-27 00:02:47'),(4533,3150,1247,40737,23181,16,21,2,9403.48,NULL,'2021-06-23 04:34:52','2021-06-27 00:02:47','2021-06-27 00:02:47'),(4534,3150,1247,40737,23181,16,512,2,70044.12,NULL,'2021-06-23 04:34:52','2021-06-27 00:02:47','2021-06-27 00:02:47'),(4535,3150,1247,40737,23181,16,351,2,166642.00,NULL,'2021-06-23 04:34:52','2021-06-27 00:02:47','2021-06-27 00:02:47'),(4536,3150,1247,40737,23181,16,494,1,1307759.33,NULL,'2021-06-23 04:34:52','2021-06-27 00:02:47','2021-06-27 00:02:47'),(4537,3150,1247,40737,23181,16,78,2,4800.12,NULL,'2021-06-23 04:34:52','2021-06-27 00:02:47','2021-06-27 00:02:47'),(4538,3150,1247,40737,23181,16,494,2,1123207.35,NULL,'2021-06-23 04:34:52','2021-06-27 00:02:47','2021-06-27 00:02:47'),(4539,3150,1248,40737,23182,16,523,2,1307759.33,NULL,'2021-06-23 04:35:30','2021-06-27 00:06:36','2021-06-27 00:06:36'),(4540,3150,1248,40737,23182,16,156,1,157.82,NULL,'2021-06-23 04:35:30','2021-06-27 00:06:36','2021-06-27 00:06:36'),(4541,3150,1248,40737,23182,16,156,1,77581.11,NULL,'2021-06-23 04:35:30','2021-06-27 00:06:36','2021-06-27 00:06:36'),(4542,3150,1248,40737,23182,16,512,2,65134.83,NULL,'2021-06-23 04:35:30','2021-06-27 00:06:36','2021-06-27 00:06:36'),(4543,3150,1248,40737,23182,16,351,2,141065.37,NULL,'2021-06-23 04:35:30','2021-06-27 00:06:36','2021-06-27 00:06:36'),(4544,3150,1248,40737,23182,16,136,1,1190.39,NULL,'2021-06-23 04:35:30','2021-06-27 00:06:36','2021-06-27 00:06:36'),(4545,3150,1248,40737,23182,16,494,1,1435030.21,NULL,'2021-06-23 04:35:30','2021-06-27 00:06:36','2021-06-27 00:06:36'),(4546,3150,1249,40737,23185,16,156,1,345.25,NULL,'2021-06-23 04:36:09','2021-06-27 02:58:06','2021-06-27 02:58:06'),(4547,3150,1249,40737,23185,16,156,1,169720.48,NULL,'2021-06-23 04:36:09','2021-06-27 02:58:06','2021-06-27 02:58:06'),(4548,3150,1249,40737,23185,16,512,2,86692.43,NULL,'2021-06-23 04:36:09','2021-06-27 02:58:06','2021-06-27 02:58:06'),(4549,3150,1249,40737,23185,16,351,2,120695.39,NULL,'2021-06-23 04:36:09','2021-06-27 02:58:06','2021-06-27 02:58:06'),(4550,3150,1249,40737,23185,16,78,2,30870.18,NULL,'2021-06-23 04:36:09','2021-06-27 02:58:06','2021-06-27 02:58:06'),(4551,3150,1249,40737,23185,16,494,1,1792532.49,NULL,'2021-06-23 04:36:09','2021-06-27 02:58:06','2021-06-27 02:58:06'),(4552,3150,1249,40737,23185,16,136,1,5527.77,NULL,'2021-06-23 04:36:09','2021-06-27 02:58:06','2021-06-27 02:58:06'),(4553,3150,1249,40737,23185,16,494,2,1729867.99,NULL,'2021-06-23 04:36:09','2021-06-27 02:58:06','2021-06-27 02:58:06'),(4554,3150,1250,40737,23186,16,156,1,276.93,NULL,'2021-06-23 04:36:41','2021-06-23 04:36:41',NULL),(4555,3150,1250,40737,23186,16,156,1,136124.48,NULL,'2021-06-23 04:36:41','2021-06-23 04:36:41',NULL),(4556,3150,1250,40737,23186,16,512,2,339683.33,NULL,'2021-06-23 04:36:41','2021-06-23 04:36:41',NULL),(4557,3150,1250,40737,23186,16,351,2,243222.00,NULL,'2021-06-23 04:36:41','2021-06-23 04:36:41',NULL);
INSERT INTO `balance_libro_details` VALUES (4558,3150,1250,40737,23186,16,78,2,9672.67,NULL,'2021-06-23 04:36:41','2021-06-23 04:36:41',NULL),(4559,3150,1250,40737,23186,16,494,1,2248709.08,NULL,'2021-06-23 04:36:41','2021-06-23 04:36:41',NULL),(4560,3150,1250,40737,23186,16,494,2,1792532.49,NULL,'2021-06-23 04:36:41','2021-06-23 04:36:41',NULL),(4561,3150,1251,40737,23189,16,156,1,313.31,NULL,'2021-06-23 04:37:14','2021-06-27 01:13:39','2021-06-27 01:13:39'),(4562,3150,1251,40737,23189,16,156,1,148974.19,NULL,'2021-06-23 04:37:14','2021-06-27 01:13:39','2021-06-27 01:13:39'),(4563,3150,1251,40737,23189,16,21,2,1514.94,NULL,'2021-06-23 04:37:14','2021-06-27 01:13:39','2021-06-27 01:13:39'),(4564,3150,1251,40737,23189,16,512,2,393273.14,NULL,'2021-06-23 04:37:14','2021-06-27 01:13:39','2021-06-27 01:13:39'),(4565,3150,1251,40737,23189,16,351,2,8800.97,NULL,'2021-06-23 04:37:14','2021-06-27 01:13:39','2021-06-27 01:13:39'),(4566,3150,1251,40737,23189,16,78,2,30637.00,NULL,'2021-06-23 04:37:14','2021-06-27 01:13:39','2021-06-27 01:13:39'),(4567,3150,1251,40737,23189,16,136,1,4138.26,NULL,'2021-06-23 04:37:14','2021-06-27 01:13:39','2021-06-27 01:13:39'),(4568,3150,1251,40737,23189,16,494,1,2990224.59,NULL,'2021-06-23 04:37:14','2021-06-27 01:13:39','2021-06-27 01:13:39'),(4569,3150,1251,40737,23189,16,494,2,2709424.30,NULL,'2021-06-23 04:37:14','2021-06-27 01:13:39','2021-06-27 01:13:39'),(4570,3150,1252,40737,23190,16,156,1,79.73,NULL,'2021-06-23 04:37:49','2021-06-27 01:15:20','2021-06-27 01:15:20'),(4571,3150,1252,40737,23190,16,156,1,39776.80,NULL,'2021-06-23 04:37:49','2021-06-27 01:15:20','2021-06-27 01:15:20'),(4572,3150,1252,40737,23190,16,512,2,51269.22,NULL,'2021-06-23 04:37:49','2021-06-27 01:15:20','2021-06-27 01:15:20'),(4573,3150,1252,40737,23190,16,351,2,8946.70,NULL,'2021-06-23 04:37:49','2021-06-27 01:15:20','2021-06-27 01:15:20'),(4574,3150,1252,40737,23190,16,78,2,3086.65,NULL,'2021-06-23 04:37:49','2021-06-27 01:15:20','2021-06-27 01:15:20'),(4575,3150,1252,40737,23190,16,494,1,3012589.58,NULL,'2021-06-23 04:37:49','2021-06-27 01:15:20','2021-06-27 01:15:20'),(4576,3150,1252,40737,23190,16,136,1,1081.05,NULL,'2021-06-23 04:37:49','2021-06-27 01:15:20','2021-06-27 01:15:20'),(4577,3150,1252,40737,23190,16,494,2,2990224.59,NULL,'2021-06-23 04:37:49','2021-06-27 01:15:20','2021-06-27 01:15:20'),(4578,3150,1253,40737,23176,3,522,1,1552966.80,NULL,'2021-06-24 17:54:55','2021-06-25 15:28:06','2021-06-25 15:28:06'),(4579,3150,1253,40737,23176,3,416,1,3195104.59,NULL,'2021-06-24 17:54:55','2021-06-25 15:28:06','2021-06-25 15:28:06'),(4580,3150,1253,40737,23176,3,506,1,12880.36,NULL,'2021-06-24 17:54:55','2021-06-25 15:28:06','2021-06-25 15:28:06'),(4581,3150,1253,40737,23176,3,199,1,1626.02,NULL,'2021-06-24 17:54:55','2021-06-25 15:28:06','2021-06-25 15:28:06'),(4582,3150,1253,40737,23176,3,513,1,70521.47,NULL,'2021-06-24 17:54:55','2021-06-25 15:28:06','2021-06-25 15:28:06'),(4583,3150,1253,40737,23176,3,512,1,82913.55,NULL,'2021-06-24 17:54:55','2021-06-25 15:28:06','2021-06-25 15:28:06'),(4584,3150,1253,40737,23176,3,68,1,1211514.40,NULL,'2021-06-24 17:54:55','2021-06-25 15:28:06','2021-06-25 15:28:06'),(4585,3150,1253,40737,23176,3,57,2,7283493.19,NULL,'2021-06-24 17:54:55','2021-06-25 15:28:06','2021-06-25 15:28:06'),(4586,3150,1253,40737,23176,3,126,1,25024.00,NULL,'2021-06-24 17:54:55','2021-06-25 15:28:06','2021-06-25 15:28:06'),(4587,3150,1253,40737,23176,3,524,1,14942.00,NULL,'2021-06-24 17:54:55','2021-06-25 15:28:06','2021-06-25 15:28:06'),(4588,3150,1253,40737,23176,3,516,1,1116000.00,NULL,'2021-06-24 17:54:55','2021-06-25 15:28:06','2021-06-25 15:28:06'),(4589,3150,1254,40737,23177,3,192,1,13000.00,NULL,'2021-06-24 17:58:10','2021-06-24 17:58:10',NULL),(4590,3150,1254,40737,23177,3,192,1,3000.00,NULL,'2021-06-24 17:58:10','2021-06-24 17:58:10',NULL),(4591,3150,1254,40737,23177,3,126,1,31855.20,NULL,'2021-06-24 17:58:10','2021-06-24 17:58:10',NULL),(4592,3150,1254,40737,23177,3,522,1,120061.83,NULL,'2021-06-24 17:58:10','2021-06-24 17:58:10',NULL);
INSERT INTO `balance_libro_details` VALUES (4593,3150,1254,40737,23177,3,416,1,2335821.43,NULL,'2021-06-24 17:58:10','2021-06-24 17:58:10',NULL),(4594,3150,1254,40737,23177,3,509,1,24072.00,NULL,'2021-06-24 17:58:10','2021-06-24 17:58:10',NULL),(4595,3150,1254,40737,23177,3,68,1,643674.08,NULL,'2021-06-24 17:58:10','2021-06-24 17:58:10',NULL),(4596,3150,1254,40737,23177,3,513,1,33192.90,NULL,'2021-06-24 17:58:10','2021-06-24 17:58:10',NULL),(4597,3150,1254,40737,23177,3,512,1,35412.27,NULL,'2021-06-24 17:58:10','2021-06-24 17:58:10',NULL),(4598,3150,1254,40737,23177,3,57,2,3780393.91,NULL,'2021-06-24 17:58:10','2021-06-24 17:58:10',NULL),(4599,3150,1254,40737,23177,3,524,1,17604.20,NULL,'2021-06-24 17:58:10','2021-06-24 17:58:10',NULL),(4600,3150,1254,40737,23177,3,516,1,522700.00,NULL,'2021-06-24 17:58:10','2021-06-24 17:58:10',NULL),(4601,3150,1255,40737,23181,3,192,1,12000.00,NULL,'2021-06-24 18:00:01','2021-06-25 15:22:27','2021-06-25 15:22:27'),(4602,3150,1255,40737,23181,3,126,1,283776.00,NULL,'2021-06-24 18:00:01','2021-06-25 15:22:27','2021-06-25 15:22:27'),(4603,3150,1255,40737,23181,3,522,1,477675.00,NULL,'2021-06-24 18:00:01','2021-06-25 15:22:27','2021-06-25 15:22:27'),(4604,3150,1255,40737,23181,3,416,1,2094498.00,NULL,'2021-06-24 18:00:01','2021-06-25 15:22:27','2021-06-25 15:22:27'),(4605,3150,1255,40737,23181,3,135,1,10268.60,NULL,'2021-06-24 18:00:01','2021-06-25 15:22:27','2021-06-25 15:22:27'),(4606,3150,1255,40737,23181,3,506,1,5005.96,NULL,'2021-06-24 18:00:01','2021-06-25 15:22:27','2021-06-25 15:22:27'),(4607,3150,1255,40737,23181,3,509,1,2479.34,NULL,'2021-06-24 18:00:01','2021-06-25 15:22:27','2021-06-25 15:22:27'),(4608,3150,1255,40737,23181,3,513,1,65413.60,NULL,'2021-06-24 18:00:01','2021-06-25 15:22:27','2021-06-25 15:22:27'),(4609,3150,1255,40737,23181,3,512,1,70044.12,NULL,'2021-06-24 18:00:01','2021-06-25 15:22:27','2021-06-25 15:22:27'),(4610,3150,1255,40737,23181,3,68,1,860295.43,NULL,'2021-06-24 18:00:01','2021-06-25 15:22:27','2021-06-25 15:22:27'),(4611,3150,1255,40737,23181,3,57,2,5278356.05,NULL,'2021-06-24 18:00:01','2021-06-25 15:22:27','2021-06-25 15:22:27'),(4612,3150,1255,40737,23181,3,516,1,1396900.00,NULL,'2021-06-24 18:00:01','2021-06-25 15:22:27','2021-06-25 15:22:27'),(4613,3150,1256,40737,23182,3,192,1,13000.00,NULL,'2021-06-24 18:01:56','2021-06-25 15:18:26','2021-06-25 15:18:26'),(4614,3150,1256,40737,23182,3,192,1,12000.00,NULL,'2021-06-24 18:01:56','2021-06-25 15:18:26','2021-06-25 15:18:26'),(4615,3150,1256,40737,23182,3,126,1,325890.03,NULL,'2021-06-24 18:01:56','2021-06-25 15:18:26','2021-06-25 15:18:26'),(4616,3150,1256,40737,23182,3,522,1,2311864.27,NULL,'2021-06-24 18:01:56','2021-06-25 15:18:26','2021-06-25 15:18:26'),(4617,3150,1256,40737,23182,3,416,1,1744952.00,NULL,'2021-06-24 18:01:56','2021-06-25 15:18:26','2021-06-25 15:18:26'),(4618,3150,1256,40737,23182,3,135,1,20893.00,NULL,'2021-06-24 18:01:56','2021-06-25 15:18:26','2021-06-25 15:18:26'),(4619,3150,1256,40737,23182,3,513,1,40935.78,NULL,'2021-06-24 18:01:56','2021-06-25 15:18:26','2021-06-25 15:18:26'),(4620,3150,1256,40737,23182,3,512,1,65134.83,NULL,'2021-06-24 18:01:56','2021-06-25 15:18:26','2021-06-25 15:18:26'),(4621,3150,1256,40737,23182,3,68,1,898147.33,NULL,'2021-06-24 18:01:56','2021-06-25 15:18:26','2021-06-25 15:18:26'),(4622,3150,1256,40737,23182,3,57,2,5467817.24,NULL,'2021-06-24 18:01:56','2021-06-25 15:18:26','2021-06-25 15:18:26'),(4623,3150,1256,40737,23182,3,116,1,35000.00,NULL,'2021-06-24 18:01:56','2021-06-25 15:18:26','2021-06-25 15:18:26'),(4624,3150,1257,40737,23183,3,192,1,3000.00,NULL,'2021-06-24 18:03:23','2021-06-24 18:03:23',NULL),(4625,3150,1257,40737,23183,3,126,1,159355.65,NULL,'2021-06-24 18:03:23','2021-06-24 18:03:23',NULL),(4626,3150,1257,40737,23183,3,522,1,2398655.62,NULL,'2021-06-24 18:03:23','2021-06-24 18:03:23',NULL),(4627,3150,1257,40737,23183,3,416,1,2613960.50,NULL,'2021-06-24 18:03:23','2021-06-24 18:03:23',NULL),(4628,3150,1257,40737,23183,3,506,1,3394.84,NULL,'2021-06-24 18:03:23','2021-06-24 18:03:23',NULL);
INSERT INTO `balance_libro_details` VALUES (4629,3150,1257,40737,23183,3,68,1,1367324.64,NULL,'2021-06-24 18:03:23','2021-06-24 18:03:23',NULL),(4630,3150,1257,40737,23183,3,513,1,103584.30,NULL,'2021-06-24 18:03:23','2021-06-24 18:03:23',NULL),(4631,3150,1257,40737,23183,3,512,1,94819.02,NULL,'2021-06-24 18:03:23','2021-06-24 18:03:23',NULL),(4632,3150,1257,40737,23183,3,57,2,8198457.67,NULL,'2021-06-24 18:03:23','2021-06-24 18:03:23',NULL),(4633,3150,1257,40737,23183,3,516,1,1445400.00,NULL,'2021-06-24 18:03:23','2021-06-24 18:03:23',NULL),(4634,3150,1257,40737,23183,3,524,1,8963.10,NULL,'2021-06-24 18:03:23','2021-06-24 18:03:23',NULL),(4635,3150,1258,40737,23184,3,192,1,16000.00,NULL,'2021-06-24 18:06:20','2021-06-25 15:14:38','2021-06-25 15:14:38'),(4636,3150,1258,40737,23184,3,192,1,3000.00,NULL,'2021-06-24 18:06:20','2021-06-25 15:14:38','2021-06-25 15:14:38'),(4637,3150,1258,40737,23184,3,126,1,614224.00,NULL,'2021-06-24 18:06:20','2021-06-25 15:14:38','2021-06-25 15:14:38'),(4638,3150,1258,40737,23184,3,522,1,796453.11,NULL,'2021-06-24 18:06:20','2021-06-25 15:14:38','2021-06-25 15:14:38'),(4639,3150,1258,40737,23184,3,416,1,5996189.40,NULL,'2021-06-24 18:06:20','2021-06-25 15:14:38','2021-06-25 15:14:38'),(4640,3150,1258,40737,23184,3,199,1,1652.89,NULL,'2021-06-24 18:06:20','2021-06-25 15:14:38','2021-06-25 15:14:38'),(4641,3150,1258,40737,23184,3,513,1,48102.00,NULL,'2021-06-24 18:06:20','2021-06-25 15:14:38','2021-06-25 15:14:38'),(4642,3150,1258,40737,23184,3,512,1,233969.89,NULL,'2021-06-24 18:06:20','2021-06-25 15:14:38','2021-06-25 15:14:38'),(4643,3150,1258,40737,23184,3,68,1,1891834.26,NULL,'2021-06-24 18:06:20','2021-06-25 15:14:38','2021-06-25 15:14:38'),(4644,3150,1258,40737,23184,3,57,2,11529640.70,NULL,'2021-06-24 18:06:20','2021-06-25 15:14:38','2021-06-25 15:14:38'),(4645,3150,1258,40737,23184,3,524,1,88645.15,NULL,'2021-06-24 18:06:20','2021-06-25 15:14:38','2021-06-25 15:14:38'),(4646,3150,1258,40737,23184,3,116,1,35000.00,NULL,'2021-06-24 18:06:20','2021-06-25 15:14:38','2021-06-25 15:14:38'),(4647,3150,1258,40737,23184,3,516,1,1804570.00,NULL,'2021-06-24 18:06:20','2021-06-25 15:14:38','2021-06-25 15:14:38'),(4648,3150,1259,40737,23185,3,192,1,67000.00,NULL,'2021-06-24 18:12:11','2021-06-25 15:05:23','2021-06-25 15:05:23'),(4649,3150,1259,40737,23185,3,126,1,329105.62,NULL,'2021-06-24 18:12:11','2021-06-25 15:05:23','2021-06-25 15:05:23'),(4650,3150,1259,40737,23185,3,522,1,1455211.16,NULL,'2021-06-24 18:12:11','2021-06-25 15:05:23','2021-06-25 15:05:23'),(4651,3150,1259,40737,23185,3,416,1,6629884.35,NULL,'2021-06-24 18:12:11','2021-06-25 15:05:23','2021-06-25 15:05:23'),(4652,3150,1259,40737,23185,3,513,1,50512.28,NULL,'2021-06-24 18:12:11','2021-06-25 15:05:23','2021-06-25 15:05:23'),(4653,3150,1259,40737,23185,3,512,1,86692.43,NULL,'2021-06-24 18:12:11','2021-06-25 15:05:23','2021-06-25 15:05:23'),(4654,3150,1259,40737,23185,3,68,1,1985642.59,NULL,'2021-06-24 18:12:11','2021-06-25 15:05:23','2021-06-25 15:05:23'),(4655,3150,1259,40737,23185,3,57,2,11811157.19,NULL,'2021-06-24 18:12:11','2021-06-25 15:05:23','2021-06-25 15:05:23'),(4656,3150,1259,40737,23185,3,524,1,9708.76,NULL,'2021-06-24 18:12:11','2021-06-25 15:05:23','2021-06-25 15:05:23'),(4657,3150,1259,40737,23185,3,116,1,35000.00,NULL,'2021-06-24 18:12:11','2021-06-25 15:05:23','2021-06-25 15:05:23'),(4658,3150,1259,40737,23185,3,516,1,1162400.00,NULL,'2021-06-24 18:12:11','2021-06-25 15:05:23','2021-06-25 15:05:23'),(4659,3150,1260,40737,23186,3,192,1,16000.00,NULL,'2021-06-24 18:29:16','2021-06-25 15:01:47','2021-06-25 15:01:47'),(4660,3150,1260,40737,23186,3,192,1,63000.00,NULL,'2021-06-24 18:29:16','2021-06-25 15:01:47','2021-06-25 15:01:47'),(4661,3150,1260,40737,23186,3,126,1,399124.19,NULL,'2021-06-24 18:29:16','2021-06-25 15:01:47','2021-06-25 15:01:47'),(4662,3150,1260,40737,23186,3,416,1,5992474.00,NULL,'2021-06-24 18:29:16','2021-06-25 15:01:47','2021-06-25 15:01:47');
INSERT INTO `balance_libro_details` VALUES (4663,3150,1260,40737,23186,3,506,1,50737.24,NULL,'2021-06-24 18:29:16','2021-06-25 15:01:47','2021-06-25 15:01:47'),(4664,3150,1260,40737,23186,3,199,1,1239.67,NULL,'2021-06-24 18:29:16','2021-06-25 15:01:47','2021-06-25 15:01:47'),(4665,3150,1260,40737,23186,3,513,1,37291.08,NULL,'2021-06-24 18:29:16','2021-06-25 15:01:47','2021-06-25 15:01:47'),(4666,3150,1260,40737,23186,3,512,1,339683.33,NULL,'2021-06-24 18:29:16','2021-06-25 15:01:47','2021-06-25 15:01:47'),(4667,3150,1260,40737,23186,3,57,2,10591607.33,NULL,'2021-06-24 18:29:16','2021-06-25 15:01:47','2021-06-25 15:01:47'),(4668,3150,1260,40737,23186,3,68,1,1698586.68,NULL,'2021-06-24 18:29:16','2021-06-25 15:01:47','2021-06-25 15:01:47'),(4669,3150,1260,40737,23186,3,516,1,1673750.00,NULL,'2021-06-24 18:29:16','2021-06-25 15:01:47','2021-06-25 15:01:47'),(4670,3150,1260,40737,23186,3,524,1,284721.14,NULL,'2021-06-24 18:29:16','2021-06-25 15:01:47','2021-06-25 15:01:47'),(4671,3150,1260,40737,23186,3,116,1,35000.00,NULL,'2021-06-24 18:29:16','2021-06-25 15:01:47','2021-06-25 15:01:47'),(4672,3150,1261,40737,23187,3,192,1,63000.00,NULL,'2021-06-24 18:33:16','2021-06-25 14:57:02','2021-06-25 14:57:02'),(4673,3150,1261,40737,23187,3,126,1,51796.79,NULL,'2021-06-24 18:33:16','2021-06-25 14:57:02','2021-06-25 14:57:02'),(4674,3150,1261,40737,23187,3,522,1,1070198.51,NULL,'2021-06-24 18:33:16','2021-06-25 14:57:02','2021-06-25 14:57:02'),(4675,3150,1261,40737,23187,3,416,1,6097194.66,NULL,'2021-06-24 18:33:16','2021-06-25 14:57:02','2021-06-25 14:57:02'),(4676,3150,1261,40737,23187,3,513,1,26036.08,NULL,'2021-06-24 18:33:16','2021-06-25 14:57:02','2021-06-25 14:57:02'),(4677,3150,1261,40737,23187,3,512,1,360259.05,NULL,'2021-06-24 18:33:16','2021-06-25 14:57:02','2021-06-25 14:57:02'),(4678,3150,1261,40737,23187,3,68,1,2008481.03,NULL,'2021-06-24 18:33:16','2021-06-25 14:57:02','2021-06-25 14:57:02'),(4679,3150,1261,40737,23187,3,57,2,12385521.16,NULL,'2021-06-24 18:33:16','2021-06-25 14:57:02','2021-06-25 14:57:02'),(4680,3150,1261,40737,23187,3,116,1,35000.00,NULL,'2021-06-24 18:33:16','2021-06-25 14:57:02','2021-06-25 14:57:02'),(4681,3150,1261,40737,23187,3,524,1,195555.04,NULL,'2021-06-24 18:33:16','2021-06-25 14:57:02','2021-06-25 14:57:02'),(4682,3150,1261,40737,23187,3,516,1,2478000.00,NULL,'2021-06-24 18:33:16','2021-06-25 14:57:02','2021-06-25 14:57:02'),(4683,3150,1262,40737,23188,3,192,1,16000.00,NULL,'2021-06-24 18:35:56','2021-06-25 14:06:13','2021-06-25 14:06:13'),(4684,3150,1262,40737,23188,3,192,1,63000.00,NULL,'2021-06-24 18:35:56','2021-06-25 14:06:13','2021-06-25 14:06:13'),(4685,3150,1262,40737,23188,3,126,1,106275.00,NULL,'2021-06-24 18:35:56','2021-06-25 14:06:13','2021-06-25 14:06:13'),(4686,3150,1262,40737,23188,3,522,1,1952624.28,NULL,'2021-06-24 18:35:56','2021-06-25 14:06:13','2021-06-25 14:06:13'),(4687,3150,1262,40737,23188,3,416,1,3709248.80,NULL,'2021-06-24 18:35:56','2021-06-25 14:06:13','2021-06-25 14:06:13'),(4688,3150,1262,40737,23188,3,199,1,2479.34,NULL,'2021-06-24 18:35:56','2021-06-25 14:06:13','2021-06-25 14:06:13'),(4689,3150,1262,40737,23188,3,68,1,1685337.66,NULL,'2021-06-24 18:35:56','2021-06-25 14:06:13','2021-06-25 14:06:13'),(4690,3150,1262,40737,23188,3,513,1,85052.55,NULL,'2021-06-24 18:35:56','2021-06-25 14:06:13','2021-06-25 14:06:13'),(4691,3150,1262,40737,23188,3,512,1,131522.69,NULL,'2021-06-24 18:35:56','2021-06-25 14:06:13','2021-06-25 14:06:13'),(4692,3150,1262,40737,23188,3,57,2,10201770.32,NULL,'2021-06-24 18:35:56','2021-06-25 14:06:13','2021-06-25 14:06:13'),(4693,3150,1262,40737,23188,3,516,1,2409980.00,NULL,'2021-06-24 18:35:56','2021-06-25 14:06:13','2021-06-25 14:06:13'),(4694,3150,1262,40737,23188,3,116,1,40250.00,NULL,'2021-06-24 18:35:56','2021-06-25 14:06:13','2021-06-25 14:06:13'),(4695,3150,1263,40737,23189,3,192,1,63000.00,NULL,'2021-06-24 18:38:02','2021-06-25 14:00:59','2021-06-25 14:00:59'),(4696,3150,1263,40737,23189,3,126,1,294400.00,NULL,'2021-06-24 18:38:02','2021-06-25 14:00:59','2021-06-25 14:00:59');
INSERT INTO `balance_libro_details` VALUES (4697,3150,1263,40737,23189,3,522,1,2657006.80,NULL,'2021-06-24 18:38:02','2021-06-25 14:00:59','2021-06-25 14:00:59'),(4698,3150,1263,40737,23189,3,416,1,6561847.27,NULL,'2021-06-24 18:38:02','2021-06-25 14:00:59','2021-06-25 14:00:59'),(4699,3150,1263,40737,23189,3,135,1,10032.00,NULL,'2021-06-24 18:38:02','2021-06-25 14:00:59','2021-06-25 14:00:59'),(4700,3150,1263,40737,23189,3,506,1,1437.99,NULL,'2021-06-24 18:38:02','2021-06-25 14:00:59','2021-06-25 14:00:59'),(4701,3150,1263,40737,23189,3,68,1,1968939.85,NULL,'2021-06-24 18:38:02','2021-06-25 14:00:59','2021-06-25 14:00:59'),(4702,3150,1263,40737,23189,3,513,1,117676.70,NULL,'2021-06-24 18:38:02','2021-06-25 14:00:59','2021-06-25 14:00:59'),(4703,3150,1263,40737,23189,3,512,1,393273.14,NULL,'2021-06-24 18:38:02','2021-06-25 14:00:59','2021-06-25 14:00:59'),(4704,3150,1263,40737,23189,3,57,2,12113815.75,NULL,'2021-06-24 18:38:02','2021-06-25 14:00:59','2021-06-25 14:00:59'),(4705,3150,1263,40737,23189,3,524,1,5952.00,NULL,'2021-06-24 18:38:02','2021-06-25 14:00:59','2021-06-25 14:00:59'),(4706,3150,1263,40737,23189,3,116,1,40250.00,NULL,'2021-06-24 18:38:02','2021-06-25 14:00:59','2021-06-25 14:00:59'),(4707,3150,1264,40737,23190,3,192,1,16000.00,NULL,'2021-06-24 18:40:20','2021-06-24 18:40:20',NULL),(4708,3150,1264,40737,23190,3,192,1,63123.75,NULL,'2021-06-24 18:40:20','2021-06-24 18:40:20',NULL),(4709,3150,1264,40737,23190,3,126,1,162465.60,NULL,'2021-06-24 18:40:20','2021-06-24 18:40:20',NULL),(4710,3150,1264,40737,23190,3,522,1,1976179.40,NULL,'2021-06-24 18:40:20','2021-06-24 18:40:20',NULL),(4711,3150,1264,40737,23190,3,416,1,5101421.79,NULL,'2021-06-24 18:40:20','2021-06-24 18:40:20',NULL),(4712,3150,1264,40737,23190,3,506,1,3583.72,NULL,'2021-06-24 18:40:20','2021-06-24 18:40:20',NULL),(4713,3150,1264,40737,23190,3,68,1,2592399.32,NULL,'2021-06-24 18:40:20','2021-06-24 18:40:20',NULL),(4714,3150,1264,40737,23190,3,513,1,49682.80,NULL,'2021-06-24 18:40:20','2021-06-24 18:40:20',NULL),(4715,3150,1264,40737,23190,3,512,1,51269.22,NULL,'2021-06-24 18:40:20','2021-06-24 18:40:20',NULL),(4716,3150,1264,40737,23190,3,57,2,15256415.60,NULL,'2021-06-24 18:40:20','2021-06-24 18:40:20',NULL),(4717,3150,1264,40737,23190,3,441,1,1220040.00,NULL,'2021-06-24 18:40:20','2021-06-24 18:40:20',NULL),(4718,3150,1264,40737,23190,3,516,1,3980000.00,NULL,'2021-06-24 18:40:20','2021-06-24 18:40:20',NULL),(4719,3150,1264,40737,23190,3,116,1,40250.00,NULL,'2021-06-24 18:40:20','2021-06-24 18:40:20',NULL),(4720,3150,1265,40737,23176,12,92,2,926444.31,NULL,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45'),(4721,3150,1265,40737,23176,12,359,1,103266.50,NULL,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45'),(4722,3150,1265,40737,23176,12,521,1,127435.28,NULL,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45'),(4723,3150,1265,40737,23176,12,23,1,85844.66,NULL,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45'),(4724,3150,1265,40737,23176,12,20,1,58026.69,NULL,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45'),(4725,3150,1265,40737,23176,12,492,1,63548.45,NULL,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45'),(4726,3150,1265,40737,23176,12,494,1,1001340.81,NULL,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45'),(4727,3150,1265,40737,23176,12,503,1,2106.60,NULL,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45'),(4728,3150,1265,40737,23176,12,13,1,2282036.92,NULL,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45'),(4729,3150,1265,40737,23176,12,434,1,1231353.33,NULL,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45'),(4730,3150,1265,40737,23176,12,416,1,1393461.66,NULL,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45'),(4731,3150,1265,40737,23176,12,57,2,2399758.54,NULL,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45');
INSERT INTO `balance_libro_details` VALUES (4732,3150,1265,40737,23176,12,78,2,1004156.88,NULL,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45'),(4733,3150,1265,40737,23176,12,74,2,253427.73,NULL,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45'),(4734,3150,1265,40737,23176,12,369,2,100000.00,NULL,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45'),(4735,3150,1265,40737,23176,12,88,2,208176.50,NULL,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45'),(4736,3150,1265,40737,23176,12,381,2,60635.30,NULL,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45'),(4737,3150,1265,40737,23176,12,91,2,2411514.11,NULL,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45'),(4738,3150,1265,40737,23176,12,522,1,1015692.47,NULL,'2021-06-24 18:44:10','2022-05-04 14:59:45','2022-05-04 14:59:45'),(4739,3150,1266,40737,23190,19,13,2,8946719.48,NULL,'2021-06-24 19:11:43','2021-06-24 19:14:59','2021-06-24 19:14:59'),(4740,3150,1266,40737,23190,19,517,2,9356.44,NULL,'2021-06-24 19:11:43','2021-06-24 19:14:59','2021-06-24 19:14:59'),(4741,3150,1266,40737,23190,19,396,1,26167.04,NULL,'2021-06-24 19:11:43','2021-06-24 19:14:59','2021-06-24 19:14:59'),(4742,3150,1266,40737,23190,19,492,1,114246.54,NULL,'2021-06-24 19:11:43','2021-06-24 19:14:59','2021-06-24 19:14:59'),(4743,3150,1266,40737,23190,19,351,1,18556.82,NULL,'2021-06-24 19:11:43','2021-06-24 19:14:59','2021-06-24 19:14:59'),(4744,3150,1266,40737,23190,19,512,1,1076.14,NULL,'2021-06-24 19:11:43','2021-06-24 19:14:59','2021-06-24 19:14:59'),(4745,3150,1266,40737,23190,19,512,1,8280.30,NULL,'2021-06-24 19:11:43','2021-06-24 19:14:59','2021-06-24 19:14:59'),(4746,3150,1266,40737,23190,19,472,1,110000.00,NULL,'2021-06-24 19:11:43','2021-06-24 19:14:59','2021-06-24 19:14:59'),(4747,3150,1266,40737,23190,19,57,1,10528444.21,NULL,'2021-06-24 19:11:43','2021-06-24 19:14:59','2021-06-24 19:14:59'),(4748,3150,1266,40737,23190,19,521,2,1850695.13,NULL,'2021-06-24 19:11:43','2021-06-24 19:14:59','2021-06-24 19:14:59'),(4749,3150,1267,40737,23190,19,13,2,8946719.48,NULL,'2021-06-24 19:14:59','2021-06-24 19:16:51','2021-06-24 19:16:51'),(4750,3150,1267,40737,23190,19,517,2,9438.35,NULL,'2021-06-24 19:14:59','2021-06-24 19:16:51','2021-06-24 19:16:51'),(4751,3150,1267,40737,23190,19,396,1,26256.95,NULL,'2021-06-24 19:14:59','2021-06-24 19:16:51','2021-06-24 19:16:51'),(4752,3150,1267,40737,23190,19,492,1,114246.54,NULL,'2021-06-24 19:14:59','2021-06-24 19:16:51','2021-06-24 19:16:51'),(4753,3150,1267,40737,23190,19,351,1,18556.82,NULL,'2021-06-24 19:14:59','2021-06-24 19:16:51','2021-06-24 19:16:51'),(4754,3150,1267,40737,23190,19,512,1,1076.14,NULL,'2021-06-24 19:14:59','2021-06-24 19:16:51','2021-06-24 19:16:51'),(4755,3150,1267,40737,23190,19,512,1,8280.30,NULL,'2021-06-24 19:14:59','2021-06-24 19:16:51','2021-06-24 19:16:51'),(4756,3150,1267,40737,23190,19,472,1,110000.00,NULL,'2021-06-24 19:14:59','2021-06-24 19:16:51','2021-06-24 19:16:51'),(4757,3150,1267,40737,23190,19,57,1,10528444.21,NULL,'2021-06-24 19:14:59','2021-06-24 19:16:51','2021-06-24 19:16:51'),(4758,3150,1267,40737,23190,19,521,2,1850703.13,NULL,'2021-06-24 19:14:59','2021-06-24 19:16:51','2021-06-24 19:16:51'),(4759,3150,1268,40737,23190,19,13,2,8946719.48,NULL,'2021-06-24 19:16:51','2021-06-24 19:21:49','2021-06-24 19:21:49'),(4760,3150,1268,40737,23190,19,517,2,9356.44,NULL,'2021-06-24 19:16:51','2021-06-24 19:21:49','2021-06-24 19:21:49'),(4761,3150,1268,40737,23190,19,396,1,26256.95,NULL,'2021-06-24 19:16:51','2021-06-24 19:21:49','2021-06-24 19:21:49'),(4762,3150,1268,40737,23190,19,492,1,114246.54,NULL,'2021-06-24 19:16:51','2021-06-24 19:21:49','2021-06-24 19:21:49'),(4763,3150,1268,40737,23190,19,351,1,18556.82,NULL,'2021-06-24 19:16:51','2021-06-24 19:21:49','2021-06-24 19:21:49'),(4764,3150,1268,40737,23190,19,512,1,1076.14,NULL,'2021-06-24 19:16:51','2021-06-24 19:21:49','2021-06-24 19:21:49');
INSERT INTO `balance_libro_details` VALUES (4765,3150,1268,40737,23190,19,512,1,8280.30,NULL,'2021-06-24 19:16:51','2021-06-24 19:21:49','2021-06-24 19:21:49'),(4766,3150,1268,40737,23190,19,472,1,110000.00,NULL,'2021-06-24 19:16:51','2021-06-24 19:21:49','2021-06-24 19:21:49'),(4767,3150,1268,40737,23190,19,57,1,10528444.21,NULL,'2021-06-24 19:16:51','2021-06-24 19:21:49','2021-06-24 19:21:49'),(4768,3150,1268,40737,23190,19,521,2,1850785.04,NULL,'2021-06-24 19:16:51','2021-06-24 19:21:49','2021-06-24 19:21:49'),(4769,3150,1269,40737,23190,19,13,2,8946719.48,NULL,'2021-06-24 19:21:49','2021-06-24 19:23:45','2021-06-24 19:23:45'),(4770,3150,1269,40737,23190,19,517,2,9176.62,NULL,'2021-06-24 19:21:49','2021-06-24 19:23:45','2021-06-24 19:23:45'),(4771,3150,1269,40737,23190,19,396,1,26256.95,NULL,'2021-06-24 19:21:49','2021-06-24 19:23:45','2021-06-24 19:23:45'),(4772,3150,1269,40737,23190,19,492,1,114246.54,NULL,'2021-06-24 19:21:49','2021-06-24 19:23:45','2021-06-24 19:23:45'),(4773,3150,1269,40737,23190,19,351,1,18556.82,NULL,'2021-06-24 19:21:49','2021-06-24 19:23:45','2021-06-24 19:23:45'),(4774,3150,1269,40737,23190,19,512,1,1076.14,NULL,'2021-06-24 19:21:49','2021-06-24 19:23:45','2021-06-24 19:23:45'),(4775,3150,1269,40737,23190,19,512,1,8280.30,NULL,'2021-06-24 19:21:49','2021-06-24 19:23:45','2021-06-24 19:23:45'),(4776,3150,1269,40737,23190,19,472,1,110000.00,NULL,'2021-06-24 19:21:49','2021-06-24 19:23:45','2021-06-24 19:23:45'),(4777,3150,1269,40737,23190,19,57,1,10528444.21,NULL,'2021-06-24 19:21:49','2021-06-24 19:23:45','2021-06-24 19:23:45'),(4778,3150,1269,40737,23190,19,521,2,1850964.86,NULL,'2021-06-24 19:21:49','2021-06-24 19:23:45','2021-06-24 19:23:45'),(4779,3150,1270,40737,23190,19,13,2,8946719.48,NULL,'2021-06-24 19:23:45','2021-06-27 18:28:51','2021-06-27 18:28:51'),(4780,3150,1270,40737,23190,19,517,2,9356.44,NULL,'2021-06-24 19:23:45','2021-06-27 18:28:51','2021-06-27 18:28:51'),(4781,3150,1270,40737,23190,19,396,1,26256.95,NULL,'2021-06-24 19:23:45','2021-06-27 18:28:51','2021-06-27 18:28:51'),(4782,3150,1270,40737,23190,19,492,1,114246.54,NULL,'2021-06-24 19:23:45','2021-06-27 18:28:51','2021-06-27 18:28:51'),(4783,3150,1270,40737,23190,19,351,1,18556.82,NULL,'2021-06-24 19:23:45','2021-06-27 18:28:51','2021-06-27 18:28:51'),(4784,3150,1270,40737,23190,19,512,1,1076.14,NULL,'2021-06-24 19:23:45','2021-06-27 18:28:51','2021-06-27 18:28:51'),(4785,3150,1270,40737,23190,19,512,1,8280.30,NULL,'2021-06-24 19:23:45','2021-06-27 18:28:51','2021-06-27 18:28:51'),(4786,3150,1270,40737,23190,19,472,1,110000.00,NULL,'2021-06-24 19:23:45','2021-06-27 18:28:51','2021-06-27 18:28:51'),(4787,3150,1270,40737,23190,19,57,1,10528444.21,NULL,'2021-06-24 19:23:45','2021-06-27 18:28:51','2021-06-27 18:28:51'),(4788,3150,1270,40737,23190,19,521,2,1850785.04,NULL,'2021-06-24 19:23:45','2021-06-27 18:28:51','2021-06-27 18:28:51'),(4789,3150,1271,40737,23190,18,521,2,89.91,NULL,'2021-06-24 19:28:15','2021-06-24 19:28:15',NULL),(4790,3150,1271,40737,23190,18,136,1,89.91,NULL,'2021-06-24 19:28:15','2021-06-24 19:28:15',NULL),(4791,3150,1272,40737,23176,2,13,1,8184471.47,NULL,'2021-06-24 20:22:54','2021-06-24 20:22:54',NULL),(4792,3150,1272,40737,23176,2,96,2,6767497.09,NULL,'2021-06-24 20:22:54','2021-06-24 20:22:54',NULL),(4793,3150,1272,40737,23176,2,67,2,1416974.38,NULL,'2021-06-24 20:22:54','2021-06-24 20:22:54',NULL),(4794,3150,1273,40737,23177,15,67,1,819214.17,NULL,'2021-06-24 20:28:40','2021-06-24 20:30:57','2021-06-24 20:30:57'),(4795,3150,1273,40737,23177,15,68,2,643674.08,NULL,'2021-06-24 20:28:40','2021-06-24 20:30:57','2021-06-24 20:30:57'),(4796,3150,1273,40737,23177,15,513,2,33192.90,NULL,'2021-06-24 20:28:40','2021-06-24 20:30:57','2021-06-24 20:30:57'),(4797,3150,1273,40737,23177,15,74,2,142347.19,NULL,'2021-06-24 20:28:40','2021-06-24 20:30:57','2021-06-24 20:30:57'),(4798,3150,1274,40737,23177,15,67,1,819214.17,NULL,'2021-06-24 20:30:57','2021-06-24 20:30:57',NULL);
INSERT INTO `balance_libro_details` VALUES (4799,3150,1274,40737,23177,15,68,2,643674.08,NULL,'2021-06-24 20:30:57','2021-06-24 20:30:57',NULL),(4800,3150,1274,40737,23177,15,513,2,33192.90,NULL,'2021-06-24 20:30:57','2021-06-24 20:30:57',NULL),(4801,3150,1274,40737,23177,15,74,2,142347.04,NULL,'2021-06-24 20:30:57','2021-06-24 20:30:57',NULL),(4802,3150,1274,40737,23177,15,136,2,0.15,NULL,'2021-06-24 20:30:57','2021-06-24 20:30:57',NULL),(4803,3150,1275,40737,23181,15,67,1,989884.87,NULL,'2021-06-24 20:34:32','2021-06-24 20:34:32',NULL),(4804,3150,1275,40737,23181,15,68,2,860295.43,NULL,'2021-06-24 20:34:32','2021-06-24 20:34:32',NULL),(4805,3150,1275,40737,23181,15,513,2,65413.60,NULL,'2021-06-24 20:34:32','2021-06-24 20:34:32',NULL),(4806,3150,1275,40737,23181,15,74,2,64175.83,NULL,'2021-06-24 20:34:32','2021-06-24 20:34:32',NULL),(4807,3150,1275,40737,23181,15,136,2,0.01,NULL,'2021-06-24 20:34:32','2021-06-24 20:34:32',NULL),(4808,3150,1276,40737,23186,15,67,1,1778453.21,NULL,'2021-06-24 20:37:53','2021-06-24 20:37:53',NULL),(4809,3150,1276,40737,23186,15,68,2,1698586.68,NULL,'2021-06-24 20:37:53','2021-06-24 20:37:53',NULL),(4810,3150,1276,40737,23186,15,513,2,37291.08,NULL,'2021-06-24 20:37:53','2021-06-24 20:37:53',NULL),(4811,3150,1276,40737,23186,15,74,2,42575.47,NULL,'2021-06-24 20:37:53','2021-06-24 20:37:53',NULL),(4812,3150,1276,40737,23186,15,136,1,0.02,NULL,'2021-06-24 20:37:53','2021-06-24 20:37:53',NULL),(4813,3150,1277,40737,23190,2,359,1,37584320.89,NULL,'2021-06-24 22:42:32','2021-06-24 22:44:23','2021-06-24 22:44:23'),(4814,3150,1277,40737,23190,2,13,2,37584320.89,NULL,'2021-06-24 22:42:32','2021-06-24 22:44:23','2021-06-24 22:44:23'),(4815,3150,1278,40737,23190,2,359,1,37584320.88,NULL,'2021-06-24 22:44:23','2021-06-24 22:45:03','2021-06-24 22:45:03'),(4816,3150,1278,40737,23190,2,13,2,37584320.88,NULL,'2021-06-24 22:44:23','2021-06-24 22:45:03','2021-06-24 22:45:03'),(4817,3150,1279,40737,23190,2,359,1,37584320.90,NULL,'2021-06-24 22:45:03','2021-06-25 13:32:27','2021-06-25 13:32:27'),(4818,3150,1279,40737,23190,2,13,2,37584320.90,NULL,'2021-06-24 22:45:03','2021-06-25 13:32:27','2021-06-25 13:32:27'),(4819,3150,1280,40737,23190,18,57,1,35258200.30,NULL,'2021-06-24 22:55:45','2021-06-24 22:59:24','2021-06-24 22:59:24'),(4820,3150,1280,40737,23190,18,359,2,35258200.30,NULL,'2021-06-24 22:55:45','2021-06-24 22:59:24','2021-06-24 22:59:24'),(4821,3150,1281,40737,23190,18,57,1,37020279.20,NULL,'2021-06-24 22:59:24','2021-06-25 13:39:17','2021-06-25 13:39:17'),(4822,3150,1281,40737,23190,18,359,2,37020279.20,NULL,'2021-06-24 22:59:24','2021-06-25 13:39:17','2021-06-25 13:39:17'),(4823,3150,1282,40737,23188,19,13,2,5463422.32,NULL,'2021-06-25 13:28:12','2021-06-27 18:16:23','2021-06-27 18:16:23'),(4824,3150,1282,40737,23188,19,517,1,15778.30,NULL,'2021-06-25 13:28:12','2021-06-27 18:16:23','2021-06-27 18:16:23'),(4825,3150,1282,40737,23188,19,140,1,11943.56,NULL,'2021-06-25 13:28:12','2021-06-27 18:16:23','2021-06-27 18:16:23'),(4826,3150,1282,40737,23188,19,492,1,64990.32,NULL,'2021-06-25 13:28:12','2021-06-27 18:16:23','2021-06-27 18:16:23'),(4827,3150,1282,40737,23188,19,351,1,10926.82,NULL,'2021-06-25 13:28:12','2021-06-27 18:16:23','2021-06-27 18:16:23'),(4828,3150,1282,40737,23188,19,512,1,410.52,NULL,'2021-06-25 13:28:12','2021-06-27 18:16:23','2021-06-27 18:16:23'),(4829,3150,1282,40737,23188,19,512,1,5151.70,NULL,'2021-06-25 13:28:12','2021-06-27 18:16:23','2021-06-27 18:16:23'),(4830,3150,1282,40737,23188,19,57,1,6605803.35,NULL,'2021-06-25 13:28:12','2021-06-27 18:16:23','2021-06-27 18:16:23'),(4831,3150,1282,40737,23188,19,521,2,1391582.25,NULL,'2021-06-25 13:28:12','2021-06-27 18:16:23','2021-06-27 18:16:23'),(4832,3150,1282,40737,23188,19,472,1,140000.00,NULL,'2021-06-25 13:28:12','2021-06-27 18:16:23','2021-06-27 18:16:23'),(4833,3150,1283,40737,23190,2,359,1,0.01,NULL,'2021-06-25 13:32:27','2021-06-25 13:36:23','2021-06-25 13:36:23'),(4834,3150,1283,40737,23190,2,13,2,0.01,NULL,'2021-06-25 13:32:27','2021-06-25 13:36:23','2021-06-25 13:36:23');
INSERT INTO `balance_libro_details` VALUES (4835,3150,1284,40737,23190,2,482,1,353810.00,NULL,'2021-06-25 13:34:23','2021-06-25 13:34:23',NULL),(4836,3150,1284,40737,23190,2,13,2,353810.00,NULL,'2021-06-25 13:34:23','2021-06-25 13:34:23',NULL),(4837,3150,1285,40737,23190,2,359,1,35798571.90,NULL,'2021-06-25 13:36:23','2021-06-27 23:48:12','2021-06-27 23:48:12'),(4838,3150,1285,40737,23190,2,13,2,35798571.90,NULL,'2021-06-25 13:36:23','2021-06-27 23:48:12','2021-06-27 23:48:12'),(4839,3150,1286,40737,23190,18,57,1,34739524.70,NULL,'2021-06-25 13:39:17','2021-06-25 13:41:08','2021-06-25 13:41:08'),(4840,3150,1286,40737,23190,18,359,2,34739524.70,NULL,'2021-06-25 13:39:17','2021-06-25 13:41:08','2021-06-25 13:41:08'),(4841,3150,1287,40737,23190,18,57,1,34739524.73,NULL,'2021-06-25 13:41:08','2021-06-25 13:41:47','2021-06-25 13:41:47'),(4842,3150,1287,40737,23190,18,359,2,34739524.73,NULL,'2021-06-25 13:41:08','2021-06-25 13:41:47','2021-06-25 13:41:47'),(4843,3150,1288,40737,23190,18,57,1,34739524.67,NULL,'2021-06-25 13:41:47','2021-06-25 13:41:47',NULL),(4844,3150,1288,40737,23190,18,359,2,34739524.67,NULL,'2021-06-25 13:41:47','2021-06-25 13:41:47',NULL),(4845,3150,1289,40737,23189,3,192,1,63000.00,NULL,'2021-06-25 14:00:59','2021-06-25 14:10:08','2021-06-25 14:10:08'),(4846,3150,1289,40737,23189,3,522,1,2657006.80,NULL,'2021-06-25 14:00:59','2021-06-25 14:10:08','2021-06-25 14:10:08'),(4847,3150,1289,40737,23189,3,416,1,6561847.27,NULL,'2021-06-25 14:00:59','2021-06-25 14:10:08','2021-06-25 14:10:08'),(4848,3150,1289,40737,23189,3,135,1,10032.00,NULL,'2021-06-25 14:00:59','2021-06-25 14:10:08','2021-06-25 14:10:08'),(4849,3150,1289,40737,23189,3,506,1,1437.99,NULL,'2021-06-25 14:00:59','2021-06-25 14:10:08','2021-06-25 14:10:08'),(4850,3150,1289,40737,23189,3,68,1,1968939.85,NULL,'2021-06-25 14:00:59','2021-06-25 14:10:08','2021-06-25 14:10:08'),(4851,3150,1289,40737,23189,3,513,1,117676.70,NULL,'2021-06-25 14:00:59','2021-06-25 14:10:08','2021-06-25 14:10:08'),(4852,3150,1289,40737,23189,3,512,1,393273.14,NULL,'2021-06-25 14:00:59','2021-06-25 14:10:08','2021-06-25 14:10:08'),(4853,3150,1289,40737,23189,3,57,2,12113815.75,NULL,'2021-06-25 14:00:59','2021-06-25 14:10:08','2021-06-25 14:10:08'),(4854,3150,1289,40737,23189,3,524,1,300352.00,NULL,'2021-06-25 14:00:59','2021-06-25 14:10:08','2021-06-25 14:10:08'),(4855,3150,1289,40737,23189,3,116,1,40250.00,NULL,'2021-06-25 14:00:59','2021-06-25 14:10:08','2021-06-25 14:10:08'),(4856,3150,1290,40737,23188,3,192,1,16000.00,NULL,'2021-06-25 14:06:13','2021-06-25 14:08:19','2021-06-25 14:08:19'),(4857,3150,1290,40737,23188,3,192,1,63000.00,NULL,'2021-06-25 14:06:13','2021-06-25 14:08:19','2021-06-25 14:08:19'),(4858,3150,1290,40737,23188,3,126,1,106275.00,NULL,'2021-06-25 14:06:13','2021-06-25 14:08:19','2021-06-25 14:08:19'),(4859,3150,1290,40737,23188,3,522,1,1952624.28,NULL,'2021-06-25 14:06:13','2021-06-25 14:08:19','2021-06-25 14:08:19'),(4860,3150,1290,40737,23188,3,416,1,3414648.80,NULL,'2021-06-25 14:06:13','2021-06-25 14:08:19','2021-06-25 14:08:19'),(4861,3150,1290,40737,23188,3,199,1,2479.34,NULL,'2021-06-25 14:06:13','2021-06-25 14:08:19','2021-06-25 14:08:19'),(4862,3150,1290,40737,23188,3,68,1,1685337.66,NULL,'2021-06-25 14:06:13','2021-06-25 14:08:19','2021-06-25 14:08:19'),(4863,3150,1290,40737,23188,3,513,1,85052.55,NULL,'2021-06-25 14:06:13','2021-06-25 14:08:19','2021-06-25 14:08:19'),(4864,3150,1290,40737,23188,3,512,1,131522.69,NULL,'2021-06-25 14:06:13','2021-06-25 14:08:19','2021-06-25 14:08:19'),(4865,3150,1290,40737,23188,3,57,2,10201770.32,NULL,'2021-06-25 14:06:13','2021-06-25 14:08:19','2021-06-25 14:08:19'),(4866,3150,1290,40737,23188,3,516,1,2409980.00,NULL,'2021-06-25 14:06:13','2021-06-25 14:08:19','2021-06-25 14:08:19'),(4867,3150,1290,40737,23188,3,116,1,40250.00,NULL,'2021-06-25 14:06:13','2021-06-25 14:08:19','2021-06-25 14:08:19'),(4868,3150,1290,40737,23188,3,524,1,294600.00,NULL,'2021-06-25 14:06:13','2021-06-25 14:08:19','2021-06-25 14:08:19');
INSERT INTO `balance_libro_details` VALUES (4869,3150,1291,40737,23188,3,192,1,16000.00,NULL,'2021-06-25 14:08:19','2021-06-25 14:08:19',NULL),(4870,3150,1291,40737,23188,3,192,1,63000.00,NULL,'2021-06-25 14:08:19','2021-06-25 14:08:19',NULL),(4871,3150,1291,40737,23188,3,126,1,106275.00,NULL,'2021-06-25 14:08:19','2021-06-25 14:08:19',NULL),(4872,3150,1291,40737,23188,3,522,1,1952624.28,NULL,'2021-06-25 14:08:19','2021-06-25 14:08:19',NULL),(4873,3150,1291,40737,23188,3,416,1,3709248.80,NULL,'2021-06-25 14:08:19','2021-06-25 14:08:19',NULL),(4874,3150,1291,40737,23188,3,199,1,2479.34,NULL,'2021-06-25 14:08:19','2021-06-25 14:08:19',NULL),(4875,3150,1291,40737,23188,3,68,1,1685337.66,NULL,'2021-06-25 14:08:19','2021-06-25 14:08:19',NULL),(4876,3150,1291,40737,23188,3,513,1,85052.55,NULL,'2021-06-25 14:08:19','2021-06-25 14:08:19',NULL),(4877,3150,1291,40737,23188,3,512,1,131522.69,NULL,'2021-06-25 14:08:19','2021-06-25 14:08:19',NULL),(4878,3150,1291,40737,23188,3,57,2,10201770.32,NULL,'2021-06-25 14:08:19','2021-06-25 14:08:19',NULL),(4879,3150,1291,40737,23188,3,516,1,2409980.00,NULL,'2021-06-25 14:08:19','2021-06-25 14:08:19',NULL),(4880,3150,1291,40737,23188,3,116,1,40250.00,NULL,'2021-06-25 14:08:19','2021-06-25 14:08:19',NULL),(4881,3150,1292,40737,23189,3,192,1,63000.00,NULL,'2021-06-25 14:10:08','2021-06-25 14:10:08',NULL),(4882,3150,1292,40737,23189,3,522,1,2657006.80,NULL,'2021-06-25 14:10:08','2021-06-25 14:10:08',NULL),(4883,3150,1292,40737,23189,3,416,1,6856247.27,NULL,'2021-06-25 14:10:08','2021-06-25 14:10:08',NULL),(4884,3150,1292,40737,23189,3,135,1,10032.00,NULL,'2021-06-25 14:10:08','2021-06-25 14:10:08',NULL),(4885,3150,1292,40737,23189,3,506,1,1437.99,NULL,'2021-06-25 14:10:08','2021-06-25 14:10:08',NULL),(4886,3150,1292,40737,23189,3,68,1,1968939.85,NULL,'2021-06-25 14:10:08','2021-06-25 14:10:08',NULL),(4887,3150,1292,40737,23189,3,513,1,117676.70,NULL,'2021-06-25 14:10:08','2021-06-25 14:10:08',NULL),(4888,3150,1292,40737,23189,3,512,1,393273.14,NULL,'2021-06-25 14:10:08','2021-06-25 14:10:08',NULL),(4889,3150,1292,40737,23189,3,57,2,12113815.75,NULL,'2021-06-25 14:10:08','2021-06-25 14:10:08',NULL),(4890,3150,1292,40737,23189,3,524,1,5952.00,NULL,'2021-06-25 14:10:08','2021-06-25 14:10:08',NULL),(4891,3150,1292,40737,23189,3,116,1,40250.00,NULL,'2021-06-25 14:10:08','2021-06-25 14:10:08',NULL),(4892,3150,1293,40737,23187,3,192,1,63000.00,NULL,'2021-06-25 14:57:02','2021-06-25 14:57:02',NULL),(4893,3150,1293,40737,23187,3,126,1,51796.79,NULL,'2021-06-25 14:57:02','2021-06-25 14:57:02',NULL),(4894,3150,1293,40737,23187,3,522,1,855694.18,NULL,'2021-06-25 14:57:02','2021-06-25 14:57:02',NULL),(4895,3150,1293,40737,23187,3,416,1,6311698.99,NULL,'2021-06-25 14:57:02','2021-06-25 14:57:02',NULL),(4896,3150,1293,40737,23187,3,513,1,26036.08,NULL,'2021-06-25 14:57:02','2021-06-25 14:57:02',NULL),(4897,3150,1293,40737,23187,3,512,1,360259.05,NULL,'2021-06-25 14:57:02','2021-06-25 14:57:02',NULL),(4898,3150,1293,40737,23187,3,68,1,2008481.03,NULL,'2021-06-25 14:57:02','2021-06-25 14:57:02',NULL),(4899,3150,1293,40737,23187,3,57,2,12385521.16,NULL,'2021-06-25 14:57:02','2021-06-25 14:57:02',NULL),(4900,3150,1293,40737,23187,3,116,1,35000.00,NULL,'2021-06-25 14:57:02','2021-06-25 14:57:02',NULL),(4901,3150,1293,40737,23187,3,524,1,195555.04,NULL,'2021-06-25 14:57:02','2021-06-25 14:57:02',NULL),(4902,3150,1293,40737,23187,3,516,1,2478000.00,NULL,'2021-06-25 14:57:02','2021-06-25 14:57:02',NULL),(4903,3150,1294,40737,23186,3,192,1,16000.00,NULL,'2021-06-25 15:01:47','2021-06-25 16:51:11','2021-06-25 16:51:11'),(4904,3150,1294,40737,23186,3,192,1,63000.00,NULL,'2021-06-25 15:01:47','2021-06-25 16:51:11','2021-06-25 16:51:11'),(4905,3150,1294,40737,23186,3,126,1,399124.19,NULL,'2021-06-25 15:01:47','2021-06-25 16:51:11','2021-06-25 16:51:11'),(4906,3150,1294,40737,23186,3,416,1,6269674.00,NULL,'2021-06-25 15:01:47','2021-06-25 16:51:11','2021-06-25 16:51:11');
INSERT INTO `balance_libro_details` VALUES (4907,3150,1294,40737,23186,3,506,1,50737.24,NULL,'2021-06-25 15:01:47','2021-06-25 16:51:11','2021-06-25 16:51:11'),(4908,3150,1294,40737,23186,3,199,1,1239.67,NULL,'2021-06-25 15:01:47','2021-06-25 16:51:11','2021-06-25 16:51:11'),(4909,3150,1294,40737,23186,3,513,1,37291.08,NULL,'2021-06-25 15:01:47','2021-06-25 16:51:11','2021-06-25 16:51:11'),(4910,3150,1294,40737,23186,3,512,1,339683.33,NULL,'2021-06-25 15:01:47','2021-06-25 16:51:11','2021-06-25 16:51:11'),(4911,3150,1294,40737,23186,3,57,2,10591607.33,NULL,'2021-06-25 15:01:47','2021-06-25 16:51:11','2021-06-25 16:51:11'),(4912,3150,1294,40737,23186,3,68,1,1698586.68,NULL,'2021-06-25 15:01:47','2021-06-25 16:51:11','2021-06-25 16:51:11'),(4913,3150,1294,40737,23186,3,516,1,1673750.00,NULL,'2021-06-25 15:01:47','2021-06-25 16:51:11','2021-06-25 16:51:11'),(4914,3150,1294,40737,23186,3,524,1,7521.14,NULL,'2021-06-25 15:01:47','2021-06-25 16:51:11','2021-06-25 16:51:11'),(4915,3150,1294,40737,23186,3,116,1,35000.00,NULL,'2021-06-25 15:01:47','2021-06-25 16:51:11','2021-06-25 16:51:11'),(4916,3150,1295,40737,23185,3,192,1,67000.00,NULL,'2021-06-25 15:05:23','2021-06-25 15:05:23',NULL),(4917,3150,1295,40737,23185,3,126,1,46255.62,NULL,'2021-06-25 15:05:23','2021-06-25 15:05:23',NULL),(4918,3150,1295,40737,23185,3,522,1,1455211.16,NULL,'2021-06-25 15:05:23','2021-06-25 15:05:23',NULL),(4919,3150,1295,40737,23185,3,416,1,6912734.35,NULL,'2021-06-25 15:05:23','2021-06-25 15:05:23',NULL),(4920,3150,1295,40737,23185,3,513,1,50512.28,NULL,'2021-06-25 15:05:23','2021-06-25 15:05:23',NULL),(4921,3150,1295,40737,23185,3,512,1,86692.43,NULL,'2021-06-25 15:05:23','2021-06-25 15:05:23',NULL),(4922,3150,1295,40737,23185,3,68,1,1985642.59,NULL,'2021-06-25 15:05:23','2021-06-25 15:05:23',NULL),(4923,3150,1295,40737,23185,3,57,2,11811157.19,NULL,'2021-06-25 15:05:23','2021-06-25 15:05:23',NULL),(4924,3150,1295,40737,23185,3,524,1,9708.76,NULL,'2021-06-25 15:05:23','2021-06-25 15:05:23',NULL),(4925,3150,1295,40737,23185,3,116,1,35000.00,NULL,'2021-06-25 15:05:23','2021-06-25 15:05:23',NULL),(4926,3150,1295,40737,23185,3,516,1,1162400.00,NULL,'2021-06-25 15:05:23','2021-06-25 15:05:23',NULL),(4927,3150,1296,40737,23184,3,192,1,16000.00,NULL,'2021-06-25 15:14:38','2021-06-25 15:14:38',NULL),(4928,3150,1296,40737,23184,3,192,1,3000.00,NULL,'2021-06-25 15:14:38','2021-06-25 15:14:38',NULL),(4929,3150,1296,40737,23184,3,126,1,26224.00,NULL,'2021-06-25 15:14:38','2021-06-25 15:14:38',NULL),(4930,3150,1296,40737,23184,3,522,1,796453.11,NULL,'2021-06-25 15:14:38','2021-06-25 15:14:38',NULL),(4931,3150,1296,40737,23184,3,416,1,6584189.40,NULL,'2021-06-25 15:14:38','2021-06-25 15:14:38',NULL),(4932,3150,1296,40737,23184,3,199,1,1652.89,NULL,'2021-06-25 15:14:38','2021-06-25 15:14:38',NULL),(4933,3150,1296,40737,23184,3,513,1,48102.00,NULL,'2021-06-25 15:14:38','2021-06-25 15:14:38',NULL),(4934,3150,1296,40737,23184,3,512,1,233969.89,NULL,'2021-06-25 15:14:38','2021-06-25 15:14:38',NULL),(4935,3150,1296,40737,23184,3,68,1,1891834.26,NULL,'2021-06-25 15:14:38','2021-06-25 15:14:38',NULL),(4936,3150,1296,40737,23184,3,57,2,11529640.70,NULL,'2021-06-25 15:14:38','2021-06-25 15:14:38',NULL),(4937,3150,1296,40737,23184,3,524,1,88645.15,NULL,'2021-06-25 15:14:38','2021-06-25 15:14:38',NULL),(4938,3150,1296,40737,23184,3,116,1,35000.00,NULL,'2021-06-25 15:14:38','2021-06-25 15:14:38',NULL),(4939,3150,1296,40737,23184,3,516,1,1804570.00,NULL,'2021-06-25 15:14:38','2021-06-25 15:14:38',NULL),(4940,3150,1297,40737,23182,3,192,1,13000.00,NULL,'2021-06-25 15:18:26','2021-06-25 15:18:26',NULL),(4941,3150,1297,40737,23182,3,192,1,12000.00,NULL,'2021-06-25 15:18:26','2021-06-25 15:18:26',NULL),(4942,3150,1297,40737,23182,3,126,1,46490.03,NULL,'2021-06-25 15:18:26','2021-06-25 15:18:26',NULL),(4943,3150,1297,40737,23182,3,522,1,2311864.27,NULL,'2021-06-25 15:18:26','2021-06-25 15:18:26',NULL),(4944,3150,1297,40737,23182,3,416,1,2024352.00,NULL,'2021-06-25 15:18:26','2021-06-25 15:18:26',NULL);
INSERT INTO `balance_libro_details` VALUES (4945,3150,1297,40737,23182,3,135,1,20893.00,NULL,'2021-06-25 15:18:26','2021-06-25 15:18:26',NULL),(4946,3150,1297,40737,23182,3,513,1,40935.78,NULL,'2021-06-25 15:18:26','2021-06-25 15:18:26',NULL),(4947,3150,1297,40737,23182,3,512,1,65134.83,NULL,'2021-06-25 15:18:26','2021-06-25 15:18:26',NULL),(4948,3150,1297,40737,23182,3,68,1,898147.33,NULL,'2021-06-25 15:18:26','2021-06-25 15:18:26',NULL),(4949,3150,1297,40737,23182,3,57,2,5467817.24,NULL,'2021-06-25 15:18:26','2021-06-25 15:18:26',NULL),(4950,3150,1297,40737,23182,3,116,1,35000.00,NULL,'2021-06-25 15:18:26','2021-06-25 15:18:26',NULL),(4951,3150,1298,40737,23181,3,192,1,12000.00,NULL,'2021-06-25 15:22:27','2021-06-25 15:22:27',NULL),(4952,3150,1298,40737,23181,3,126,1,8776.00,NULL,'2021-06-25 15:22:27','2021-06-25 15:22:27',NULL),(4953,3150,1298,40737,23181,3,522,1,477675.00,NULL,'2021-06-25 15:22:27','2021-06-25 15:22:27',NULL),(4954,3150,1298,40737,23181,3,416,1,2369498.00,NULL,'2021-06-25 15:22:27','2021-06-25 15:22:27',NULL),(4955,3150,1298,40737,23181,3,135,1,10268.60,NULL,'2021-06-25 15:22:27','2021-06-25 15:22:27',NULL),(4956,3150,1298,40737,23181,3,506,1,5005.96,NULL,'2021-06-25 15:22:27','2021-06-25 15:22:27',NULL),(4957,3150,1298,40737,23181,3,509,1,2479.34,NULL,'2021-06-25 15:22:27','2021-06-25 15:22:27',NULL),(4958,3150,1298,40737,23181,3,513,1,65413.60,NULL,'2021-06-25 15:22:27','2021-06-25 15:22:27',NULL),(4959,3150,1298,40737,23181,3,512,1,70044.12,NULL,'2021-06-25 15:22:27','2021-06-25 15:22:27',NULL),(4960,3150,1298,40737,23181,3,68,1,860295.43,NULL,'2021-06-25 15:22:27','2021-06-25 15:22:27',NULL),(4961,3150,1298,40737,23181,3,57,2,5278356.05,NULL,'2021-06-25 15:22:27','2021-06-25 15:22:27',NULL),(4962,3150,1298,40737,23181,3,516,1,1396900.00,NULL,'2021-06-25 15:22:27','2021-06-25 15:22:27',NULL),(4963,3150,1299,40737,23176,3,522,1,1552966.80,NULL,'2021-06-25 15:28:06','2021-06-25 15:28:06',NULL),(4964,3150,1299,40737,23176,3,416,1,3195104.59,NULL,'2021-06-25 15:28:06','2021-06-25 15:28:06',NULL),(4965,3150,1299,40737,23176,3,506,1,12880.36,NULL,'2021-06-25 15:28:06','2021-06-25 15:28:06',NULL),(4966,3150,1299,40737,23176,3,199,1,1626.02,NULL,'2021-06-25 15:28:06','2021-06-25 15:28:06',NULL),(4967,3150,1299,40737,23176,3,513,1,70521.47,NULL,'2021-06-25 15:28:06','2021-06-25 15:28:06',NULL),(4968,3150,1299,40737,23176,3,512,1,82913.55,NULL,'2021-06-25 15:28:06','2021-06-25 15:28:06',NULL),(4969,3150,1299,40737,23176,3,68,1,1211514.40,NULL,'2021-06-25 15:28:06','2021-06-25 15:28:06',NULL),(4970,3150,1299,40737,23176,3,57,2,7283493.19,NULL,'2021-06-25 15:28:06','2021-06-25 15:28:06',NULL),(4971,3150,1299,40737,23176,3,126,1,25024.00,NULL,'2021-06-25 15:28:06','2021-06-25 15:28:06',NULL),(4972,3150,1299,40737,23176,3,524,1,14942.00,NULL,'2021-06-25 15:28:06','2021-06-25 15:28:06',NULL),(4973,3150,1299,40737,23176,3,516,1,1116000.00,NULL,'2021-06-25 15:28:06','2021-06-25 15:28:06',NULL),(4974,3150,1300,40737,23186,3,192,1,16000.00,NULL,'2021-06-25 16:51:11','2021-06-25 16:51:11',NULL),(4975,3150,1300,40737,23186,3,192,1,63000.00,NULL,'2021-06-25 16:51:11','2021-06-25 16:51:11',NULL),(4976,3150,1300,40737,23186,3,126,1,201211.58,NULL,'2021-06-25 16:51:11','2021-06-25 16:51:11',NULL),(4977,3150,1300,40737,23186,3,416,1,6467586.61,NULL,'2021-06-25 16:51:11','2021-06-25 16:51:11',NULL),(4978,3150,1300,40737,23186,3,506,1,50737.24,NULL,'2021-06-25 16:51:11','2021-06-25 16:51:11',NULL),(4979,3150,1300,40737,23186,3,199,1,1239.67,NULL,'2021-06-25 16:51:11','2021-06-25 16:51:11',NULL),(4980,3150,1300,40737,23186,3,513,1,37291.08,NULL,'2021-06-25 16:51:11','2021-06-25 16:51:11',NULL),(4981,3150,1300,40737,23186,3,512,1,339683.33,NULL,'2021-06-25 16:51:11','2021-06-25 16:51:11',NULL),(4982,3150,1300,40737,23186,3,57,2,10591607.33,NULL,'2021-06-25 16:51:11','2021-06-25 16:51:11',NULL),(4983,3150,1300,40737,23186,3,68,1,1698586.68,NULL,'2021-06-25 16:51:11','2021-06-25 16:51:11',NULL);
INSERT INTO `balance_libro_details` VALUES (4984,3150,1300,40737,23186,3,516,1,1673750.00,NULL,'2021-06-25 16:51:11','2021-06-25 16:51:11',NULL),(4985,3150,1300,40737,23186,3,524,1,7521.14,NULL,'2021-06-25 16:51:11','2021-06-25 16:51:11',NULL),(4986,3150,1300,40737,23186,3,116,1,35000.00,NULL,'2021-06-25 16:51:11','2021-06-25 16:51:11',NULL),(4987,3150,1301,40737,23181,16,156,1,154.14,NULL,'2021-06-27 00:02:47','2021-06-27 00:02:47',NULL),(4988,3150,1301,40737,23181,16,156,1,75773.70,NULL,'2021-06-27 00:02:47','2021-06-27 00:02:47',NULL),(4989,3150,1301,40737,23181,16,21,2,9403.48,NULL,'2021-06-27 00:02:47','2021-06-27 00:02:47',NULL),(4990,3150,1301,40737,23181,16,512,2,70044.12,NULL,'2021-06-27 00:02:47','2021-06-27 00:02:47',NULL),(4991,3150,1301,40737,23181,16,351,2,166642.00,NULL,'2021-06-27 00:02:47','2021-06-27 00:02:47',NULL),(4992,3150,1301,40737,23181,16,494,1,1300721.72,NULL,'2021-06-27 00:02:47','2021-06-27 00:02:47',NULL),(4993,3150,1301,40737,23181,16,494,2,1123207.35,NULL,'2021-06-27 00:02:47','2021-06-27 00:02:47',NULL),(4994,3150,1301,40737,23181,16,156,2,7352.61,NULL,'2021-06-27 00:02:47','2021-06-27 00:02:47',NULL),(4995,3150,1302,40737,23182,16,523,2,1300721.72,NULL,'2021-06-27 00:06:36','2021-06-27 03:08:15','2021-06-27 03:08:15'),(4996,3150,1302,40737,23182,16,156,1,157.82,NULL,'2021-06-27 00:06:36','2021-06-27 03:08:15','2021-06-27 03:08:15'),(4997,3150,1302,40737,23182,16,156,1,77581.11,NULL,'2021-06-27 00:06:36','2021-06-27 03:08:15','2021-06-27 03:08:15'),(4998,3150,1302,40737,23182,16,512,2,65134.83,NULL,'2021-06-27 00:06:36','2021-06-27 03:08:15','2021-06-27 03:08:15'),(4999,3150,1302,40737,23182,16,351,2,141065.37,NULL,'2021-06-27 00:06:36','2021-06-27 03:08:15','2021-06-27 03:08:15'),(5000,3150,1302,40737,23182,16,136,2,5847.22,NULL,'2021-06-27 00:06:36','2021-06-27 03:08:15','2021-06-27 03:08:15'),(5001,3150,1302,40737,23182,16,494,1,1435030.21,NULL,'2021-06-27 00:06:36','2021-06-27 03:08:15','2021-06-27 03:08:15'),(5002,3150,1303,40737,23183,16,494,2,1435030.21,NULL,'2021-06-27 00:12:13','2021-06-27 00:12:13',NULL),(5003,3150,1303,40737,23183,16,156,1,234.75,NULL,'2021-06-27 00:12:13','2021-06-27 00:12:13',NULL),(5004,3150,1303,40737,23183,16,156,1,115401.20,NULL,'2021-06-27 00:12:13','2021-06-27 00:12:13',NULL),(5005,3150,1303,40737,23183,16,512,2,94819.02,NULL,'2021-06-27 00:12:13','2021-06-27 00:12:13',NULL),(5006,3150,1303,40737,23183,16,351,2,182843.03,NULL,'2021-06-27 00:12:13','2021-06-27 00:12:13',NULL),(5007,3150,1303,40737,23183,16,494,1,1608606.49,NULL,'2021-06-27 00:12:13','2021-06-27 00:12:13',NULL),(5008,3150,1303,40737,23183,16,156,2,11550.18,NULL,'2021-06-27 00:12:13','2021-06-27 00:12:13',NULL),(5009,3150,1304,40737,23184,16,494,2,1608606.49,NULL,'2021-06-27 00:17:40','2021-06-27 00:17:40',NULL),(5010,3150,1304,40737,23184,16,156,1,333.81,NULL,'2021-06-27 00:17:40','2021-06-27 00:17:40',NULL),(5011,3150,1304,40737,23184,16,156,1,164098.39,NULL,'2021-06-27 00:17:40','2021-06-27 00:17:40',NULL),(5012,3150,1304,40737,23184,16,512,2,233969.89,NULL,'2021-06-27 00:17:40','2021-06-27 00:17:40',NULL),(5013,3150,1304,40737,23184,16,351,2,15985.58,NULL,'2021-06-27 00:17:40','2021-06-27 00:17:40',NULL),(5014,3150,1304,40737,23184,16,494,1,1729867.99,NULL,'2021-06-27 00:17:40','2021-06-27 00:17:40',NULL),(5015,3150,1304,40737,23184,16,156,2,35738.23,NULL,'2021-06-27 00:17:40','2021-06-27 00:17:40',NULL),(5016,3150,1305,40737,23187,16,494,2,2248709.08,NULL,'2021-06-27 00:25:07','2021-06-27 02:54:57','2021-06-27 02:54:57'),(5017,3150,1305,40737,23187,16,156,1,304.49,NULL,'2021-06-27 00:25:07','2021-06-27 02:54:57','2021-06-27 02:54:57'),(5018,3150,1305,40737,23187,16,156,1,149669.34,NULL,'2021-06-27 00:25:07','2021-06-27 02:54:57','2021-06-27 02:54:57'),(5019,3150,1305,40737,23187,16,512,2,360259.05,NULL,'2021-06-27 00:25:07','2021-06-27 02:54:57','2021-06-27 02:54:57'),(5020,3150,1305,40737,23187,16,351,2,285209.99,NULL,'2021-06-27 00:25:07','2021-06-27 02:54:57','2021-06-27 02:54:57');
INSERT INTO `balance_libro_details` VALUES (5021,3150,1305,40737,23187,16,78,2,9670.50,NULL,'2021-06-27 00:25:07','2021-06-27 02:54:57','2021-06-27 02:54:57'),(5022,3150,1305,40737,23187,16,494,1,2731503.66,NULL,'2021-06-27 00:25:07','2021-06-27 02:54:57','2021-06-27 02:54:57'),(5023,3150,1305,40737,23187,16,494,1,22371.13,NULL,'2021-06-27 00:25:07','2021-06-27 02:54:57','2021-06-27 02:54:57'),(5024,3150,1306,40737,23188,16,494,2,2731503.66,NULL,'2021-06-27 00:32:52','2021-06-27 02:53:32','2021-06-27 02:53:32'),(5025,3150,1306,40737,23188,16,156,1,302.69,NULL,'2021-06-27 00:32:52','2021-06-27 02:53:32','2021-06-27 02:53:32'),(5026,3150,1306,40737,23188,16,156,1,148788.55,NULL,'2021-06-27 00:32:52','2021-06-27 02:53:32','2021-06-27 02:53:32'),(5027,3150,1306,40737,23188,16,512,2,131522.69,NULL,'2021-06-27 00:32:52','2021-06-27 02:53:32','2021-06-27 02:53:32'),(5028,3150,1306,40737,23188,16,351,2,10926.82,NULL,'2021-06-27 00:32:52','2021-06-27 02:53:32','2021-06-27 02:53:32'),(5029,3150,1306,40737,23188,16,78,2,20443.99,NULL,'2021-06-27 00:32:52','2021-06-27 02:53:32','2021-06-27 02:53:32'),(5030,3150,1306,40737,23188,16,494,1,2709424.30,NULL,'2021-06-27 00:32:52','2021-06-27 02:53:32','2021-06-27 02:53:32'),(5031,3150,1306,40737,23188,16,494,1,35881.62,NULL,'2021-06-27 00:32:52','2021-06-27 02:53:32','2021-06-27 02:53:32'),(5032,3150,1307,40737,23192,16,494,2,1001340.81,NULL,'2021-06-27 00:52:47','2021-06-27 00:55:36','2021-06-27 00:55:36'),(5033,3150,1307,40737,23192,16,156,1,2018.00,NULL,'2021-06-27 00:52:47','2021-06-27 00:55:36','2021-06-27 00:55:36'),(5034,3150,1307,40737,23192,16,156,1,173026.87,NULL,'2021-06-27 00:52:47','2021-06-27 00:55:36','2021-06-27 00:55:36'),(5035,3150,1307,40737,23192,16,21,2,6917.08,NULL,'2021-06-27 00:52:47','2021-06-27 00:55:36','2021-06-27 00:55:36'),(5036,3150,1307,40737,23192,16,512,2,82913.55,NULL,'2021-06-27 00:52:47','2021-06-27 00:55:36','2021-06-27 00:55:36'),(5037,3150,1307,40737,23192,16,351,2,177240.33,NULL,'2021-06-27 00:52:47','2021-06-27 00:55:36','2021-06-27 00:55:36'),(5038,3150,1307,40737,23192,16,78,2,65102.58,NULL,'2021-06-27 00:52:47','2021-06-27 00:55:36','2021-06-27 00:55:36'),(5039,3150,1307,40737,23192,16,494,1,1158468.58,NULL,'2021-06-27 00:52:47','2021-06-27 00:55:36','2021-06-27 00:55:36'),(5040,3150,1307,40737,23192,16,136,1,0.90,NULL,'2021-06-27 00:52:47','2021-06-27 00:55:36','2021-06-27 00:55:36'),(5041,3150,1308,40737,23177,16,494,2,1001340.81,NULL,'2021-06-27 00:55:36','2021-06-27 01:01:51','2021-06-27 01:01:51'),(5042,3150,1308,40737,23177,16,156,1,2018.00,NULL,'2021-06-27 00:55:36','2021-06-27 01:01:51','2021-06-27 01:01:51'),(5043,3150,1308,40737,23177,16,156,1,173026.87,NULL,'2021-06-27 00:55:36','2021-06-27 01:01:51','2021-06-27 01:01:51'),(5044,3150,1308,40737,23177,16,21,2,6917.08,NULL,'2021-06-27 00:55:36','2021-06-27 01:01:51','2021-06-27 01:01:51'),(5045,3150,1308,40737,23177,16,512,2,82913.55,NULL,'2021-06-27 00:55:36','2021-06-27 01:01:51','2021-06-27 01:01:51'),(5046,3150,1308,40737,23177,16,351,2,177240.33,NULL,'2021-06-27 00:55:36','2021-06-27 01:01:51','2021-06-27 01:01:51'),(5047,3150,1308,40737,23177,16,78,2,65102.58,NULL,'2021-06-27 00:55:36','2021-06-27 01:01:51','2021-06-27 01:01:51'),(5048,3150,1308,40737,23177,16,494,1,1158468.58,NULL,'2021-06-27 00:55:36','2021-06-27 01:01:51','2021-06-27 01:01:51'),(5049,3150,1308,40737,23177,16,136,1,0.90,NULL,'2021-06-27 00:55:36','2021-06-27 01:01:51','2021-06-27 01:01:51'),(5050,3150,1309,40737,23177,16,494,1,128661.33,NULL,'2021-06-27 01:01:51','2021-06-27 03:03:46','2021-06-27 03:03:46'),(5051,3150,1309,40737,23177,16,156,1,1166.70,NULL,'2021-06-27 01:01:51','2021-06-27 03:03:46','2021-06-27 03:03:46'),(5052,3150,1309,40737,23177,16,156,1,100034.30,NULL,'2021-06-27 01:01:51','2021-06-27 03:03:46','2021-06-27 03:03:46'),(5053,3150,1309,40737,23177,16,21,2,9800.53,NULL,'2021-06-27 01:01:51','2021-06-27 03:03:46','2021-06-27 03:03:46'),(5054,3150,1309,40737,23177,16,512,2,141126.04,NULL,'2021-06-27 01:01:51','2021-06-27 03:03:46','2021-06-27 03:03:46');
INSERT INTO `balance_libro_details` VALUES (5055,3150,1309,40737,23177,16,351,2,35412.27,NULL,'2021-06-27 01:01:51','2021-06-27 03:03:46','2021-06-27 03:03:46'),(5056,3150,1309,40737,23177,16,78,2,8262.26,NULL,'2021-06-27 01:01:51','2021-06-27 03:03:46','2021-06-27 03:03:46'),(5057,3150,1309,40737,23177,16,494,1,1123207.35,NULL,'2021-06-27 01:01:51','2021-06-27 03:03:46','2021-06-27 03:03:46'),(5058,3150,1309,40737,23177,16,494,2,1158468.58,NULL,'2021-06-27 01:01:51','2021-06-27 03:03:46','2021-06-27 03:03:46'),(5059,3150,1310,40737,23189,16,156,1,313.31,NULL,'2021-06-27 01:13:39','2021-06-27 02:52:56','2021-06-27 02:52:56'),(5060,3150,1310,40737,23189,16,156,1,148974.19,NULL,'2021-06-27 01:13:39','2021-06-27 02:52:56','2021-06-27 02:52:56'),(5061,3150,1310,40737,23189,16,21,2,1514.94,NULL,'2021-06-27 01:13:39','2021-06-27 02:52:56','2021-06-27 02:52:56'),(5062,3150,1310,40737,23189,16,512,2,393273.14,NULL,'2021-06-27 01:13:39','2021-06-27 02:52:56','2021-06-27 02:52:56'),(5063,3150,1310,40737,23189,16,351,2,8800.97,NULL,'2021-06-27 01:13:39','2021-06-27 02:52:56','2021-06-27 02:52:56'),(5064,3150,1310,40737,23189,16,78,2,30637.00,NULL,'2021-06-27 01:13:39','2021-06-27 02:52:56','2021-06-27 02:52:56'),(5065,3150,1310,40737,23189,16,494,1,2990224.59,NULL,'2021-06-27 01:13:39','2021-06-27 02:52:56','2021-06-27 02:52:56'),(5066,3150,1310,40737,23189,16,494,2,2709424.30,NULL,'2021-06-27 01:13:39','2021-06-27 02:52:56','2021-06-27 02:52:56'),(5067,3150,1310,40737,23189,16,494,1,4138.26,NULL,'2021-06-27 01:13:39','2021-06-27 02:52:56','2021-06-27 02:52:56'),(5068,3150,1311,40737,23190,16,156,1,79.73,NULL,'2021-06-27 01:15:20','2021-06-27 02:52:14','2021-06-27 02:52:14'),(5069,3150,1311,40737,23190,16,156,1,39776.80,NULL,'2021-06-27 01:15:20','2021-06-27 02:52:14','2021-06-27 02:52:14'),(5070,3150,1311,40737,23190,16,512,2,51269.22,NULL,'2021-06-27 01:15:20','2021-06-27 02:52:14','2021-06-27 02:52:14'),(5071,3150,1311,40737,23190,16,351,2,8946.70,NULL,'2021-06-27 01:15:20','2021-06-27 02:52:14','2021-06-27 02:52:14'),(5072,3150,1311,40737,23190,16,78,2,3086.65,NULL,'2021-06-27 01:15:20','2021-06-27 02:52:14','2021-06-27 02:52:14'),(5073,3150,1311,40737,23190,16,494,1,3012589.58,NULL,'2021-06-27 01:15:20','2021-06-27 02:52:14','2021-06-27 02:52:14'),(5074,3150,1311,40737,23190,16,494,2,2990224.59,NULL,'2021-06-27 01:15:20','2021-06-27 02:52:14','2021-06-27 02:52:14'),(5075,3150,1311,40737,23190,16,494,1,1081.05,NULL,'2021-06-27 01:15:20','2021-06-27 02:52:14','2021-06-27 02:52:14'),(5076,3150,1312,40737,23190,16,156,1,79.73,NULL,'2021-06-27 02:52:14','2021-06-27 02:52:14',NULL),(5077,3150,1312,40737,23190,16,156,1,39776.80,NULL,'2021-06-27 02:52:14','2021-06-27 02:52:14',NULL),(5078,3150,1312,40737,23190,16,512,2,51269.22,NULL,'2021-06-27 02:52:14','2021-06-27 02:52:14',NULL),(5079,3150,1312,40737,23190,16,351,2,8946.70,NULL,'2021-06-27 02:52:14','2021-06-27 02:52:14',NULL),(5080,3150,1312,40737,23190,16,78,2,3086.65,NULL,'2021-06-27 02:52:14','2021-06-27 02:52:14',NULL),(5081,3150,1312,40737,23190,16,494,1,3012589.58,NULL,'2021-06-27 02:52:14','2021-06-27 02:52:14',NULL),(5082,3150,1312,40737,23190,16,494,2,2990224.59,NULL,'2021-06-27 02:52:14','2021-06-27 02:52:14',NULL),(5083,3150,1312,40737,23190,16,517,1,1081.05,NULL,'2021-06-27 02:52:14','2021-06-27 02:52:14',NULL),(5084,3150,1313,40737,23189,16,156,1,313.31,NULL,'2021-06-27 02:52:56','2021-06-27 02:52:56',NULL),(5085,3150,1313,40737,23189,16,156,1,148974.19,NULL,'2021-06-27 02:52:56','2021-06-27 02:52:56',NULL),(5086,3150,1313,40737,23189,16,21,2,1514.94,NULL,'2021-06-27 02:52:56','2021-06-27 02:52:56',NULL),(5087,3150,1313,40737,23189,16,512,2,393273.14,NULL,'2021-06-27 02:52:56','2021-06-27 02:52:56',NULL),(5088,3150,1313,40737,23189,16,351,2,8800.97,NULL,'2021-06-27 02:52:56','2021-06-27 02:52:56',NULL),(5089,3150,1313,40737,23189,16,78,2,30637.00,NULL,'2021-06-27 02:52:56','2021-06-27 02:52:56',NULL),(5090,3150,1313,40737,23189,16,494,1,2990224.59,NULL,'2021-06-27 02:52:56','2021-06-27 02:52:56',NULL);
INSERT INTO `balance_libro_details` VALUES (5091,3150,1313,40737,23189,16,494,2,2709424.30,NULL,'2021-06-27 02:52:56','2021-06-27 02:52:56',NULL),(5092,3150,1313,40737,23189,16,517,1,4138.26,NULL,'2021-06-27 02:52:56','2021-06-27 02:52:56',NULL),(5093,3150,1314,40737,23188,16,494,2,2731503.66,NULL,'2021-06-27 02:53:32','2021-06-27 02:53:32',NULL),(5094,3150,1314,40737,23188,16,156,1,302.69,NULL,'2021-06-27 02:53:32','2021-06-27 02:53:32',NULL),(5095,3150,1314,40737,23188,16,156,1,148788.55,NULL,'2021-06-27 02:53:32','2021-06-27 02:53:32',NULL),(5096,3150,1314,40737,23188,16,512,2,131522.69,NULL,'2021-06-27 02:53:32','2021-06-27 02:53:32',NULL),(5097,3150,1314,40737,23188,16,351,2,10926.82,NULL,'2021-06-27 02:53:32','2021-06-27 02:53:32',NULL),(5098,3150,1314,40737,23188,16,78,2,20443.99,NULL,'2021-06-27 02:53:32','2021-06-27 02:53:32',NULL),(5099,3150,1314,40737,23188,16,494,1,2709424.30,NULL,'2021-06-27 02:53:32','2021-06-27 02:53:32',NULL),(5100,3150,1314,40737,23188,16,517,1,35881.62,NULL,'2021-06-27 02:53:32','2021-06-27 02:53:32',NULL),(5101,3150,1315,40737,23187,16,494,2,2248709.08,NULL,'2021-06-27 02:54:57','2021-06-27 02:54:57',NULL),(5102,3150,1315,40737,23187,16,156,1,304.49,NULL,'2021-06-27 02:54:57','2021-06-27 02:54:57',NULL),(5103,3150,1315,40737,23187,16,156,1,149669.34,NULL,'2021-06-27 02:54:57','2021-06-27 02:54:57',NULL),(5104,3150,1315,40737,23187,16,512,2,360259.05,NULL,'2021-06-27 02:54:57','2021-06-27 02:54:57',NULL),(5105,3150,1315,40737,23187,16,351,2,285209.99,NULL,'2021-06-27 02:54:57','2021-06-27 02:54:57',NULL),(5106,3150,1315,40737,23187,16,78,2,9670.50,NULL,'2021-06-27 02:54:57','2021-06-27 02:54:57',NULL),(5107,3150,1315,40737,23187,16,494,1,2731503.66,NULL,'2021-06-27 02:54:57','2021-06-27 02:54:57',NULL),(5108,3150,1315,40737,23187,16,517,1,22371.13,NULL,'2021-06-27 02:54:57','2021-06-27 02:54:57',NULL),(5109,3150,1316,40737,23185,16,156,1,345.25,NULL,'2021-06-27 02:58:06','2021-06-27 02:58:06',NULL),(5110,3150,1316,40737,23185,16,156,1,169720.48,NULL,'2021-06-27 02:58:06','2021-06-27 02:58:06',NULL),(5111,3150,1316,40737,23185,16,512,2,86692.43,NULL,'2021-06-27 02:58:06','2021-06-27 02:58:06',NULL),(5112,3150,1316,40737,23185,16,351,2,120695.39,NULL,'2021-06-27 02:58:06','2021-06-27 02:58:06',NULL),(5113,3150,1316,40737,23185,16,78,2,30870.18,NULL,'2021-06-27 02:58:06','2021-06-27 02:58:06',NULL),(5114,3150,1316,40737,23185,16,494,1,1792532.49,NULL,'2021-06-27 02:58:06','2021-06-27 02:58:06',NULL),(5115,3150,1316,40737,23185,16,494,2,1729867.99,NULL,'2021-06-27 02:58:06','2021-06-27 02:58:06',NULL),(5116,3150,1316,40737,23185,16,517,1,5527.77,NULL,'2021-06-27 02:58:06','2021-06-27 02:58:06',NULL),(5117,3150,1317,40737,23177,16,156,1,1166.70,NULL,'2021-06-27 03:03:46','2021-06-27 18:38:28','2021-06-27 18:38:28'),(5118,3150,1317,40737,23177,16,156,1,100034.30,NULL,'2021-06-27 03:03:46','2021-06-27 18:38:28','2021-06-27 18:38:28'),(5119,3150,1317,40737,23177,16,21,2,9800.53,NULL,'2021-06-27 03:03:46','2021-06-27 18:38:28','2021-06-27 18:38:28'),(5120,3150,1317,40737,23177,16,512,2,141126.04,NULL,'2021-06-27 03:03:46','2021-06-27 18:38:28','2021-06-27 18:38:28'),(5121,3150,1317,40737,23177,16,351,2,35412.27,NULL,'2021-06-27 03:03:46','2021-06-27