-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-24394222-0
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-11-09 14:46:52','Actividad Generica 1','000001',NULL),(2,NULL,'2022-11-09 14:46:52','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=446 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,8087,40720,1614,1,1,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-10-31',NULL,152292.21,'Sueldos y cargas sociales octubre 2022',NULL,1,'2022-11-11 10:40:55','2022-11-11 10:55:21','2022-11-11 10:55:21'),(2,8087,40720,1614,1,2,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-10-31',NULL,152292.21,NULL,NULL,1,'2022-11-11 11:08:20','2022-11-11 11:40:23','2022-11-11 11:40:23'),(3,8087,40720,1614,1,3,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-10-31',NULL,152292.21,NULL,NULL,1,'2022-11-11 12:09:34','2022-11-11 12:28:42','2022-11-11 12:28:42'),(4,8087,40720,1614,1,4,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-10-31',NULL,152292.21,NULL,NULL,1,'2022-11-11 12:31:55','2022-11-11 12:31:55',NULL),(5,8087,40720,1605,12,5,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-01','2019-01-01',2983071.87,NULL,NULL,1,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(6,8087,40720,1560,19,6,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-03','2019-01-03',34000.00,'Por retiro de socios',NULL,1,'2022-11-12 19:45:27','2022-11-12 19:45:27',NULL),(7,8087,40720,1560,10,7,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-07','2019-01-07',31019.73,'Pago Cgs soc y sindicales 12/2018',NULL,1,'2022-11-12 19:49:22','2022-11-12 19:49:22',NULL),(8,8087,40720,1560,12,8,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-01','2019-01-01',2983071.87,NULL,NULL,1,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(9,8087,40720,1560,10,9,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-08','2019-01-08',5702.31,'Pago anticipo 8 ganancias',NULL,1,'2022-11-12 20:22:05','2022-11-14 17:13:10','2022-11-14 17:13:10'),(10,8087,40720,1560,10,10,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-25','2019-01-25',45000.50,'Pago ddjj IVA 12/2018',NULL,1,'2022-11-12 20:23:40','2022-11-12 20:23:40',NULL),(11,8087,40720,1560,10,11,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-25','2019-01-25',9940.72,'Pago Ing brutos 12/2018',NULL,1,'2022-11-12 20:26:19','2022-11-12 20:26:19',NULL),(12,8087,40720,1560,2,12,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',819953.11,'S/IVA ventas enero/19',NULL,1,'2022-11-12 20:31:18','2022-11-14 16:58:44','2022-11-14 16:58:44'),(13,8087,40720,1560,3,13,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',446191.95,'S/libro IVA compras enero/19',NULL,1,'2022-11-12 20:37:23','2022-11-12 20:37:23',NULL),(14,8087,40720,1560,1,14,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',73336.25,'Para devengar sueldos y cgs soc del mes',NULL,1,'2022-11-12 20:44:39','2022-11-12 20:44:39',NULL),(15,8087,40720,1560,5,15,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',682800.05,'S/movimientos bancarios del mes',NULL,1,'2022-11-13 09:55:28','2022-11-13 09:55:28',NULL),(16,8087,40720,1561,10,16,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-06','2019-02-06',24582.25,'Pago Cgs soc y sindicales 01/2019',NULL,1,'2022-11-13 09:59:56','2022-11-13 09:59:56',NULL),(17,8087,40720,1561,19,17,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-08','2019-02-08',34000.00,'Por retiro de socios',NULL,1,'2022-11-13 10:02:33','2022-11-13 10:02:33',NULL),(18,8087,40720,1561,10,18,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-08','2019-02-08',5696.62,'Pago anticipo 9 ganancias',NULL,1,'2022-11-13 10:04:05','2022-11-13 10:04:05',NULL);
INSERT INTO `balance_libro` VALUES (19,8087,40720,1561,15,19,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-21','2019-02-21',142305.91,'P/contabilizar IVA ddjj del mes de enero/19',NULL,1,'2022-11-13 10:17:01','2022-11-14 17:25:54','2022-11-14 17:25:54'),(20,8087,40720,1561,10,20,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-22','2019-02-22',21297.18,'S/Pago de IIBB de enero/19',NULL,1,'2022-11-13 11:11:02','2022-11-13 11:11:02',NULL),(21,8087,40720,1561,10,21,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-22','2019-02-22',65237.38,'S/Pago de IVA de enero/19',NULL,1,'2022-11-13 11:33:12','2022-11-13 11:33:12',NULL),(22,8087,40720,1561,21,22,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',200000.00,'Por pagos parciales a proveedores',NULL,1,'2022-11-13 11:34:59','2022-11-13 11:34:59',NULL),(23,8087,40720,1561,3,23,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',506516.68,'S/libro IVA compras febrero/19',NULL,1,'2022-11-13 11:46:54','2022-11-13 11:46:54',NULL),(24,8087,40720,1561,2,24,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',707739.56,'S/IVA ventas febrero/19',NULL,1,'2022-11-13 11:49:15','2022-11-13 11:49:15',NULL),(25,8087,40720,1561,1,25,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',73913.93,'P/devengar sueldos y cgs. soc. del mes',NULL,1,'2022-11-13 11:58:50','2022-11-13 11:58:50',NULL),(26,8087,40720,1561,5,26,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',362845.07,'S/movimientos bancarios del mes',NULL,1,'2022-11-13 12:05:45','2022-11-13 12:05:45',NULL),(27,8087,40720,1562,19,27,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-08','2019-03-08',12000.00,'Por retiro de socios',NULL,1,'2022-11-13 12:10:37','2022-11-13 12:10:37',NULL),(28,8087,40720,1562,10,28,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-12','2019-03-12',5696.62,'Pago anticipo 10 ganancias',NULL,1,'2022-11-13 12:13:40','2022-11-13 12:13:40',NULL),(29,8087,40720,1562,10,29,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-12','2019-03-12',26157.93,'Pago Cgs soc y sindicales 02/2019',NULL,1,'2022-11-13 12:16:58','2022-11-13 12:16:58',NULL),(30,8087,40720,1562,19,30,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-20','2019-03-20',30000.00,'Por retiro de socios',NULL,1,'2022-11-13 12:18:07','2022-11-13 12:18:07',NULL),(31,8087,40720,1562,15,31,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-22','2019-03-22',122830.83,'P/contabilizar IVA ddjj del mes de febrero/19',NULL,1,'2022-11-13 12:22:15','2022-11-13 12:26:55','2022-11-13 12:26:55'),(32,8087,40720,1562,15,32,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-22','2019-03-22',122830.83,'P/contabilizar pago IVA ddjj del mes de febrero/19',NULL,1,'2022-11-13 12:26:55','2022-11-14 17:27:45','2022-11-14 17:27:45'),(33,8087,40720,1562,10,33,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-22','2019-03-22',18991.31,'S/Pago de IIBB de febrero/19',NULL,1,'2022-11-13 12:32:31','2022-11-13 12:32:31',NULL),(34,8087,40720,1562,3,34,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',491405.32,'S/libro IVA compras marzo/19',NULL,1,'2022-11-13 15:23:50','2022-11-13 15:23:50',NULL),(35,8087,40720,1562,2,35,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',790274.11,'S/IVA ventas marzo/19',NULL,1,'2022-11-13 15:28:40','2022-11-13 15:28:40',NULL);
INSERT INTO `balance_libro` VALUES (36,8087,40720,1562,1,36,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',88116.56,'P/devengar sueldos y Cgs Soc marzo/19',NULL,1,'2022-11-13 15:32:41','2022-11-13 15:32:41',NULL),(37,8087,40720,1562,5,37,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',1030002.99,'S/movimientos bancarios del mes',NULL,1,'2022-11-13 15:45:32','2022-11-13 15:45:32',NULL),(38,8087,40720,1563,10,38,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-04','2019-04-04',24362.56,'Pago Cgs soc y sindicales 03/2019',NULL,1,'2022-11-13 15:48:04','2022-11-13 15:48:04',NULL),(39,8087,40720,1563,21,39,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-09','2019-04-09',31895.16,'Pago gastos varios',NULL,1,'2022-11-13 15:54:23','2022-11-13 15:54:23',NULL),(40,8087,40720,1563,19,40,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-12','2019-04-12',44000.00,'Por retiro de socios',NULL,1,'2022-11-13 15:57:30','2022-11-13 15:57:30',NULL),(41,8087,40720,1563,15,41,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-23','2019-04-23',137155.01,'P/contabilizar IVA ddjj del mes de marzo/19',NULL,1,'2022-11-13 16:03:24','2022-11-13 16:03:24',NULL),(42,8087,40720,1563,10,42,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-24','2019-04-24',51491.12,'P/pago ddjj IVA marzo/19',NULL,1,'2022-11-13 16:15:20','2022-11-13 16:15:20',NULL),(43,8087,40720,1563,10,43,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-24','2019-04-24',21816.47,'S/Pago de IIBB de marzo/19',NULL,1,'2022-11-13 16:21:32','2022-11-13 16:21:32',NULL),(44,8087,40720,1563,21,44,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',100000.00,'Por pagos parciales a proveedores',NULL,1,'2022-11-13 16:31:19','2022-11-13 16:31:19',NULL),(45,8087,40720,1563,3,45,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',390782.08,'S/libro IVA compras abril/19',NULL,1,'2022-11-13 16:39:36','2022-11-13 16:39:36',NULL),(46,8087,40720,1563,2,46,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',769295.21,'S/IVA ventas abril/19',NULL,1,'2022-11-13 16:42:15','2022-11-13 16:42:15',NULL),(47,8087,40720,1563,1,47,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',98256.56,'P/devengar sueldos y Cgs Soc abril/19',NULL,1,'2022-11-13 16:44:45','2022-11-13 16:44:45',NULL),(48,8087,40720,1563,5,48,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',817111.37,'S/movimientos bancarios del mes',NULL,1,'2022-11-13 16:50:48','2022-11-13 16:50:48',NULL),(49,8087,40720,1564,21,49,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-03','2019-05-03',73754.00,'Pago sueldos abril/19',NULL,1,'2022-11-13 16:54:17','2022-11-13 16:54:17',NULL),(50,8087,40720,1564,10,50,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-03','2019-05-03',24502.56,'Pago Cgs soc y sindicales 04/2019',NULL,1,'2022-11-13 16:57:04','2022-11-13 16:57:04',NULL),(51,8087,40720,1564,19,51,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-14','2019-05-14',44000.00,'Por retiro de socios',NULL,1,'2022-11-13 17:00:32','2022-11-13 17:00:32',NULL),(52,8087,40720,1564,15,52,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-22','2019-05-22',133514.05,'P/contabilizar IVA ddjj del mes de abril/19',NULL,1,'2022-11-13 17:02:54','2022-11-13 17:02:54',NULL),(53,8087,40720,1564,10,53,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-23','2019-05-23',65840.16,'Pago ddjj IVA 04/2019',NULL,1,'2022-11-13 17:04:30','2022-11-13 17:04:30',NULL);
INSERT INTO `balance_libro` VALUES (54,8087,40720,1564,10,54,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-23','2019-05-23',20301.59,'S/Pago de IIBB de abril/19',NULL,1,'2022-11-13 17:10:47','2022-11-13 17:10:47',NULL),(55,8087,40720,1564,3,55,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',715662.02,'S/libro IVA compras mayo/19',NULL,1,'2022-11-13 17:17:57','2022-11-13 17:17:57',NULL),(56,8087,40720,1564,2,56,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',859981.57,'S/IVA ventas mayo/19',NULL,1,'2022-11-13 17:21:42','2022-11-13 17:21:42',NULL),(57,8087,40720,1564,1,57,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',104255.80,'P/devengar sueldos y Cgs Soc mayo/19',NULL,1,'2022-11-13 17:23:59','2022-11-13 17:23:59',NULL),(58,8087,40720,1564,5,58,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',1006347.32,'S/movimientos bancarios del mes',NULL,1,'2022-11-13 17:27:32','2022-11-13 17:27:32',NULL),(59,8087,40720,1565,21,59,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-04','2019-06-04',77692.00,'Pago sueldos mayo/19',NULL,1,'2022-11-13 18:36:13','2022-11-13 18:36:13',NULL),(60,8087,40720,1565,19,60,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-06','2019-06-06',44000.00,'Por retiro de socios',NULL,1,'2022-11-13 18:39:20','2022-11-13 18:39:20',NULL),(61,8087,40720,1565,10,61,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-11','2019-06-11',26563.80,'Pago Cgs soc y sindicales 05/2019',NULL,1,'2022-11-13 18:42:10','2022-11-13 18:42:10',NULL),(62,8087,40720,1565,15,62,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-25','2019-06-25',149253.00,'P/contabilizar IVA ddjj del mes de mayo/19',NULL,1,'2022-11-13 18:44:32','2022-11-13 18:44:32',NULL),(63,8087,40720,1565,10,63,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-26','2019-06-26',24691.95,'P/pago ddjj IVA mayo/19',NULL,1,'2022-11-13 18:47:36','2022-11-13 18:47:36',NULL),(64,8087,40720,1565,10,64,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-26','2019-06-26',23343.26,'S/Pago de IIBB de mayo/19',NULL,1,'2022-11-13 18:51:09','2022-11-13 18:51:09',NULL),(65,8087,40720,1565,1,65,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',150946.09,'P/devengar sueldos y Cgs Soc junio/19',NULL,1,'2022-11-13 18:56:02','2022-11-13 18:56:02',NULL),(66,8087,40720,1565,3,66,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',466236.78,'S/libro IVA compras junio/19',NULL,1,'2022-11-13 18:59:58','2022-11-13 18:59:58',NULL),(67,8087,40720,1565,2,67,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',729268.05,'S/IVA ventas junio/19',NULL,1,'2022-11-13 19:01:37','2022-11-13 19:01:37',NULL),(68,8087,40720,1565,5,68,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',800074.55,'S/movimientos bancarios del mes',NULL,1,'2022-11-13 19:04:55','2022-11-13 19:04:55',NULL),(69,8087,40720,1566,21,69,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-04','2019-07-04',78158.00,'Pago sueldos junio/19',NULL,1,'2022-11-13 20:43:26','2022-11-13 20:43:26',NULL),(70,8087,40720,1566,19,70,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-10','2019-07-10',43000.00,'Por retiro de socios',NULL,1,'2022-11-13 20:45:10','2022-11-13 20:45:10',NULL),(71,8087,40720,1566,10,71,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-15','2019-07-15',39541.10,'Pago Cgs soc y sindicales 06/2019',NULL,1,'2022-11-13 20:47:08','2022-11-13 20:47:08',NULL);
INSERT INTO `balance_libro` VALUES (72,8087,40720,1566,15,72,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-17','2019-07-17',126567.18,'P/contabilizar IVA ddjj del mes de junio/19',NULL,1,'2022-11-14 06:32:20','2022-11-14 06:32:20',NULL),(73,8087,40720,1566,10,73,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-18','2019-07-18',19976.89,'S/Pago de IIBB de junio/19',NULL,1,'2022-11-14 06:35:50','2022-11-14 06:35:50',NULL),(74,8087,40720,1566,10,74,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-23','2019-07-23',45149.02,'P/pago ddjj IVA junio/19',NULL,1,'2022-11-14 06:37:07','2022-11-14 06:37:07',NULL),(75,8087,40720,1566,10,75,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-24','2019-07-24',1642.08,'Pago int iva,multa bs pers y gcias/18',NULL,1,'2022-11-14 06:39:04','2022-11-14 06:39:04',NULL),(76,8087,40720,1566,21,76,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',100000.00,'Por pagos parciales a proveedores',NULL,1,'2022-11-14 06:40:23','2022-11-14 06:40:23',NULL),(77,8087,40720,1566,5,77,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',1063323.16,'S/movimientos bancarios del mes',NULL,1,'2022-11-14 08:29:48','2022-11-14 08:29:48',NULL),(78,8087,40720,1566,1,78,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',104966.55,'P/devengar sueldos y Cgs Soc junio/19',NULL,1,'2022-11-14 09:09:18','2022-11-14 09:09:18',NULL),(79,8087,40720,1566,3,79,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',598372.44,'S/libro IVA compras julio/19',NULL,1,'2022-11-14 09:26:45','2022-11-14 09:26:45',NULL),(80,8087,40720,1566,2,80,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',909560.01,'S/IVA ventas julio/19',NULL,1,'2022-11-14 09:31:43','2022-11-14 09:31:43',NULL),(81,8087,40720,1567,21,81,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-05','2019-08-05',78158.00,'Pago sueldos julio/19',NULL,1,'2022-11-14 09:33:03','2022-11-14 09:33:03',NULL),(82,8087,40720,1567,10,82,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-06','2019-08-06',26808.55,'Pago Cgs soc y sindicales 07/2019',NULL,1,'2022-11-14 09:34:50','2022-11-14 09:34:50',NULL),(83,8087,40720,1567,19,83,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-09','2019-08-09',44000.00,'Por retiro de socios',NULL,1,'2022-11-14 09:37:48','2022-11-14 09:37:48',NULL),(84,8087,40720,1567,15,84,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-26','2019-08-26',157857.52,'P/contabilizar IVA ddjj del mes de julio/19',NULL,1,'2022-11-14 09:40:31','2022-11-14 09:40:31',NULL),(85,8087,40720,1567,10,85,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-29','2019-08-29',66386.84,'P/pago ddjj IVA julio/19',NULL,1,'2022-11-14 09:48:31','2022-11-14 09:48:31',NULL),(86,8087,40720,1567,10,86,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-29','2019-08-29',24392.23,'S/Pago de IIBB de julio/19',NULL,1,'2022-11-14 09:56:07','2022-11-14 09:56:07',NULL),(87,8087,40720,1567,1,87,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-30','2019-08-30',109368.69,'P/devengar sueldos y Cgs Soc agosto/19',NULL,1,'2022-11-14 10:00:01','2022-11-14 10:00:01',NULL),(88,8087,40720,1567,3,88,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-30','2019-08-30',732246.64,'S/libro IVA compras agosto/19',NULL,1,'2022-11-14 10:05:06','2022-11-14 10:05:06',NULL),(89,8087,40720,1567,2,89,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-30','2019-08-30',954780.70,'S/IVA ventas agosto/19',NULL,1,'2022-11-14 10:06:43','2022-11-14 10:06:43',NULL);
INSERT INTO `balance_libro` VALUES (90,8087,40720,1567,5,90,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-30','2019-08-30',783229.06,'S/movimientos bancarios del mes',NULL,1,'2022-11-14 10:11:00','2022-11-14 10:11:00',NULL),(91,8087,40720,1567,21,91,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-30','2019-08-30',100000.00,'Por pagos parciales a proveedores',NULL,1,'2022-11-14 10:12:46','2022-11-14 10:12:46',NULL),(92,8087,40720,1568,21,92,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-03','2019-09-03',30000.00,'Pago sueldos agosto/19',NULL,1,'2022-11-14 10:16:48','2022-11-14 10:16:48',NULL),(93,8087,40720,1568,10,93,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-04','2019-09-04',23232.69,'Pago Cgs soc y sindicales 08/2019',NULL,1,'2022-11-14 10:18:34','2022-11-14 10:18:34',NULL),(94,8087,40720,1568,19,94,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-06','2019-09-06',44000.00,'Por retiro de socios',NULL,1,'2022-11-14 10:26:36','2022-11-14 10:26:36',NULL),(95,8087,40720,1568,15,95,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-17','2019-09-17',165705.75,'P/contabilizar IVA ddjj del mes de agosto19',NULL,1,'2022-11-14 10:30:37','2022-11-14 10:30:37',NULL),(96,8087,40720,1568,10,96,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-19','2019-09-19',25696.13,'S/Pago de IIBB de agosto/19',NULL,1,'2022-11-14 10:37:52','2022-11-14 10:37:52',NULL),(97,8087,40720,1568,10,97,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-23','2019-09-23',39563.27,'P/pago ddjj IVA agosto/19',NULL,1,'2022-11-14 10:39:19','2022-11-14 10:39:19',NULL),(98,8087,40720,1568,1,98,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-30','2019-09-30',111594.71,'P/devengar sueldos y Cgs Soc septiembre/19',NULL,1,'2022-11-14 10:40:47','2022-11-14 10:40:47',NULL),(99,8087,40720,1568,3,99,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-30','2019-09-30',464937.34,'S/libro IVA compras septiembre/19',NULL,1,'2022-11-14 10:44:57','2022-11-14 10:44:57',NULL),(100,8087,40720,1568,2,100,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-30','2019-09-30',866984.76,'S/IVA ventas septiembre/19',NULL,1,'2022-11-14 10:46:45','2022-11-14 16:15:32','2022-11-14 16:15:32'),(101,8087,40720,1568,5,101,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-30','2019-09-30',866766.53,'S/movimientos bancarios del mes',NULL,1,'2022-11-14 10:51:44','2022-11-14 10:51:44',NULL),(102,8087,40720,1569,21,102,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-10-02','2019-10-02',88034.02,'Pago sueldos septiembre/19',NULL,1,'2022-11-14 10:54:25','2022-11-14 10:54:25',NULL),(103,8087,40720,1569,19,103,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-10-03','2019-10-03',43600.00,'Por retiro de socios',NULL,1,'2022-11-14 10:55:23','2022-11-14 10:55:23',NULL),(104,8087,40720,1569,10,104,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-10-03','2019-10-03',5772.35,'Pago ajuste de ART',NULL,1,'2022-11-14 10:57:24','2022-11-14 10:57:24',NULL),(105,8087,40720,1569,10,105,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-10-10','2019-10-10',23560.69,'Pago Cgs soc y sindicales 09/2019',NULL,1,'2022-11-14 10:59:31','2022-11-14 10:59:31',NULL),(106,8087,40720,1569,15,106,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-10-22','2019-10-22',150468.43,'P/contabilizar IVA ddjj del mes de septiembre/19',NULL,1,'2022-11-14 11:02:49','2022-11-14 11:02:49',NULL),(107,8087,40720,1569,10,107,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-10-23','2019-10-23',70309.21,'P/pago ddjj IVA septiembre/19',NULL,1,'2022-11-14 11:04:20','2022-11-14 11:04:20',NULL);
INSERT INTO `balance_libro` VALUES (108,8087,40720,1569,10,108,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-10-23','2019-10-23',23262.76,'S/Pago de IIBB de septiembre/19',NULL,1,'2022-11-14 11:06:19','2022-11-14 11:06:19',NULL),(109,8087,40720,1569,21,109,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-10-31','2019-10-31',200000.00,'Por pagos parciales a proveedores',NULL,1,'2022-11-14 11:14:37','2022-11-14 16:13:59','2022-11-14 16:13:59'),(110,8087,40720,1569,21,110,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-10-31','2019-10-31',200000.00,'Por pagos parciales a proveedores',NULL,1,'2022-11-14 11:14:46','2022-11-14 11:14:46',NULL),(111,8087,40720,1569,1,111,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-10-31','2019-10-31',111594.71,'P/devengar sueldos y Cgs Soc octubre/19',NULL,1,'2022-11-14 11:20:46','2022-11-14 11:20:46',NULL),(112,8087,40720,1569,3,112,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-10-31','2019-10-31',802648.64,'S/libro IVA compras octubre/19',NULL,1,'2022-11-14 11:24:55','2022-11-14 11:24:55',NULL),(113,8087,40720,1569,2,113,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-10-31','2019-10-31',1064242.79,'S/IVA ventas octubre/19',NULL,1,'2022-11-14 11:26:48','2022-11-14 11:26:48',NULL),(114,8087,40720,1569,5,114,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-10-31','2019-10-31',1121128.74,'S/movimientos bancarios del mes',NULL,1,'2022-11-14 12:07:27','2022-11-14 12:07:27',NULL),(115,8087,40720,1570,21,115,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-05','2019-11-05',84034.02,'Pago sueldos octubre/19',NULL,1,'2022-11-14 12:09:41','2022-11-14 12:09:41',NULL),(116,8087,40720,1570,19,116,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-11','2019-11-11',30000.00,'Por retiro de socios',NULL,1,'2022-11-14 12:10:45','2022-11-14 12:10:45',NULL),(117,8087,40720,1570,10,117,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-05','2019-11-05',27560.69,'Pago Cgs soc y sindicales 10/2019',NULL,1,'2022-11-14 12:12:28','2022-11-14 12:12:28',NULL),(118,8087,40720,1570,15,118,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-26','2019-11-26',184703.29,'P/contabilizar IVA ddjj del mes de octubre/19',NULL,1,'2022-11-14 12:15:12','2022-11-14 12:15:12',NULL),(119,8087,40720,1570,10,119,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-26','2019-11-26',46495.57,'P/pago ddjj IVA octubre/19',NULL,1,'2022-11-14 12:17:26','2022-11-14 12:17:26',NULL),(120,8087,40720,1570,10,120,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-26','2019-11-26',28816.68,'S/Pago de IIBB de octubre/19',NULL,1,'2022-11-14 12:20:15','2022-11-14 12:20:15',NULL),(121,8087,40720,1570,1,121,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-30','2019-11-30',123510.13,'P/devengar sueldos y Cgs Soc noviembre/19',NULL,1,'2022-11-14 12:21:53','2022-11-14 12:21:53',NULL),(122,8087,40720,1570,3,122,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-30','2019-11-30',504702.12,'S/libro IVA compras noviembre/19',NULL,1,'2022-11-14 13:11:22','2022-11-14 13:11:22',NULL),(123,8087,40720,1570,2,123,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-30','2019-11-30',890536.94,'S/IVA ventas noviembre/19',NULL,1,'2022-11-14 13:21:24','2022-11-14 13:21:24',NULL),(124,8087,40720,1570,5,124,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-30','2019-11-30',1007898.32,'S/movimientos bancarios del mes',NULL,1,'2022-11-14 13:24:28','2022-11-14 13:24:28',NULL);
INSERT INTO `balance_libro` VALUES (125,8087,40720,1570,21,125,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-30','2019-11-30',200000.00,'Por pagos parciales a proveedores',NULL,1,'2022-11-14 13:25:33','2022-11-14 13:25:33',NULL),(126,8087,40720,1571,10,126,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-05','2019-12-05',31654.13,'Pago Cgs soc y sindicales 11/2019',NULL,1,'2022-11-14 13:29:56','2022-11-14 13:29:56',NULL),(127,8087,40720,1571,19,127,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-10','2019-12-10',30000.00,'Por retiro de socios',NULL,1,'2022-11-14 13:30:45','2022-11-14 13:30:45',NULL),(128,8087,40720,1571,21,128,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-10','2019-12-10',91856.00,'Pago sueldos noviembre/19',NULL,1,'2022-11-14 13:32:19','2022-11-14 13:32:19',NULL),(129,8087,40720,1571,21,129,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-12','2019-12-12',9691.44,'Pago gastos varios',NULL,1,'2022-11-14 13:34:43','2022-11-14 13:34:43',NULL),(130,8087,40720,1571,15,130,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-23','2019-12-23',154556.00,'P/contabilizar IVA ddjj del mes de noviembre/19',NULL,1,'2022-11-14 13:37:12','2022-11-14 13:37:12',NULL),(131,8087,40720,1571,19,131,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-23','2019-12-23',114430.71,'Contabiliza Imp Gcias e Imp Bs Pers/18',NULL,1,'2022-11-14 14:09:28','2022-11-14 14:09:28',NULL),(132,8087,40720,1571,10,132,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-23','2019-12-23',58691.48,'Pago ddjj gcias/18 y anticipo 1/19',NULL,1,'2022-11-14 14:14:13','2022-11-14 14:14:13',NULL),(133,8087,40720,1571,10,133,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-23','2019-12-23',3038.98,'Pago ddjj  Imp Bs Pers/18',NULL,1,'2022-11-14 14:16:00','2022-11-14 17:15:39','2022-11-14 17:15:39'),(134,8087,40720,1571,10,134,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-27','2019-12-27',20393.15,'Pago anticipo 2 y 3 ganancias/19',NULL,1,'2022-11-14 14:19:35','2022-11-14 17:16:29','2022-11-14 17:16:29'),(135,8087,40720,1571,10,135,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-27','2019-12-27',24295.30,'S/Pago de IIBB de noviembre/19',NULL,1,'2022-11-14 14:21:39','2022-11-14 14:21:39',NULL),(136,8087,40720,1571,10,136,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-27','2019-12-27',67344.02,'P/pago ddjj IVA noviembre/19',NULL,1,'2022-11-14 14:23:55','2022-11-14 14:23:55',NULL),(137,8087,40720,1571,21,137,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-27','2019-12-27',100000.00,'Por pagos parciales a proveedores',NULL,1,'2022-11-14 14:25:20','2022-11-14 14:25:20',NULL),(138,8087,40720,1571,15,138,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-31','2019-12-31',144822.80,'P/contabilizar IVA ddjj del mes de diciembre/19',NULL,1,'2022-11-14 14:27:02','2022-11-14 14:27:02',NULL),(139,8087,40720,1571,16,139,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-27','2019-12-27',22930.77,'P/contabilizar IIBB ddjj del mes de diciembre/19',NULL,1,'2022-11-14 14:38:25','2022-11-14 14:38:25',NULL),(140,8087,40720,1571,21,140,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-27','2019-12-27',106834.00,'Pago sueldos y sac diciembre/19',NULL,1,'2022-11-14 14:40:19','2022-11-14 14:40:19',NULL),(141,8087,40720,1571,1,141,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-27','2019-12-27',183129.18,'P/devengar sueldos y Cgs Soc diciembre19',NULL,1,'2022-11-14 14:43:08','2022-11-14 14:43:08',NULL);
INSERT INTO `balance_libro` VALUES (142,8087,40720,1571,3,142,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-31','2019-12-31',457492.24,'S/libro IVA compras diciembre/19',NULL,1,'2022-11-14 14:50:46','2022-11-14 14:50:46',NULL),(143,8087,40720,1571,2,143,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-31','2019-12-31',834455.22,'S/IVA ventas diciembre/19',NULL,1,'2022-11-14 14:52:49','2022-11-14 14:52:49',NULL),(144,8087,40720,1571,5,144,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-31','2019-12-31',1095807.57,'S/movimientos bancarios del mes',NULL,1,'2022-11-14 14:56:40','2022-11-14 14:56:40',NULL),(145,8087,40720,1571,19,145,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-31','2019-12-31',57025.71,'P/devengar anticipos 4 a 10 de gcias/19',NULL,1,'2022-11-14 15:00:31','2022-11-14 15:00:31',NULL),(146,8087,40720,1571,4,146,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-31','2019-12-31',10132.65,'Contabiliza amort. del ejercicio',NULL,1,'2022-11-14 15:07:47','2022-11-14 15:07:47',NULL),(147,8087,40720,1571,19,147,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-31','2019-12-31',3161.32,'Por ajuste de saldos de cuentas por redondeo',NULL,1,'2022-11-14 15:11:52','2022-11-21 09:16:37','2022-11-21 09:16:37'),(148,8087,40720,1571,19,148,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-31','2019-12-31',4111075.77,'P/contabilizar el costo de las ventas del ejercicio',NULL,1,'2022-11-14 15:39:39','2023-01-02 16:27:17','2023-01-02 16:27:17'),(149,8087,40720,1568,2,149,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-30','2019-09-30',866984.76,'S/IVA ventas septiembre/19',NULL,1,'2022-11-14 16:15:32','2022-11-14 16:15:32',NULL),(150,8087,40720,1560,2,150,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',819953.11,'S/IVA ventas enero/19',NULL,1,'2022-11-14 16:58:44','2022-11-14 16:58:44',NULL),(151,8087,40720,1560,10,151,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-08','2019-01-08',5702.31,'Pago anticipo 8 ganancias',NULL,1,'2022-11-14 17:13:10','2022-11-14 17:13:10',NULL),(152,8087,40720,1571,10,152,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-23','2019-12-23',3038.98,'Pago ddjj  Imp Bs Pers/18',NULL,1,'2022-11-14 17:15:39','2022-11-14 17:15:39',NULL),(153,8087,40720,1571,10,153,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-27','2019-12-27',20393.15,'Pago anticipo 2 y 3 ganancias/19',NULL,1,'2022-11-14 17:16:29','2022-11-14 17:16:29',NULL),(154,8087,40720,1561,15,154,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-21','2019-02-21',142305.91,'P/contabilizar IVA ddjj del mes de enero/19',NULL,1,'2022-11-14 17:25:54','2022-11-14 17:25:54',NULL),(155,8087,40720,1562,15,155,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-22','2019-03-22',122830.83,'P/contabilizar pago IVA ddjj del mes de febrero/19',NULL,1,'2022-11-14 17:27:45','2022-11-14 17:27:45',NULL),(156,8087,40720,1571,19,156,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-31','2019-12-31',16007.38,'Por ajuste de saldos de cuentas por redondeo',NULL,1,'2022-11-21 09:16:37','2022-11-21 09:16:37',NULL),(157,8087,40720,1571,23,157,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-31','2019-12-31',2390710.60,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-11-21 11:29:44','2022-11-21 12:19:52','2022-11-21 12:19:52'),(158,8087,40720,1571,23,158,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-31','2019-12-31',2390325.32,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-11-21 12:22:08','2023-01-02 15:30:17','2023-01-02 15:30:17');
INSERT INTO `balance_libro` VALUES (159,8087,40720,1575,12,159,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-01','2020-01-01',3896281.47,'P/saldos iniciales',NULL,1,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(160,8087,40720,1575,10,160,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-08','2020-01-08',46295.18,'Pago Cgs soc y sindicales 12/2019',NULL,1,'2022-11-22 18:49:54','2022-11-22 18:49:54',NULL),(161,8087,40720,1575,10,161,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-08','2020-01-08',17913.40,'Pago anticipo 4 y 5 ganancias',NULL,1,'2022-11-22 18:53:16','2022-11-22 18:53:16',NULL),(162,8087,40720,1575,21,162,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-17','2020-01-17',30000.00,'Pago sueldos diciembre/19',NULL,1,'2022-11-22 18:59:21','2022-11-22 18:59:21',NULL),(163,8087,40720,1575,10,163,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-17','2020-01-17',64178.02,'S/Pago de IVA de diciembre/19',NULL,1,'2022-11-22 19:01:27','2022-11-22 19:01:27',NULL),(164,8087,40720,1575,10,164,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-17','2020-01-17',11316.13,'Pago Ing brutos 12/2019',NULL,1,'2022-11-22 19:06:08','2022-11-22 19:06:08',NULL),(165,8087,40720,1575,10,165,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-27','2020-01-27',17720.67,'Pago anticipo 6 y 7 ganancias',NULL,1,'2022-11-22 19:07:27','2022-11-22 19:07:27',NULL),(166,8087,40720,1575,19,166,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-30','2020-01-30',45000.00,'Por retiro de socios',NULL,1,'2022-11-22 19:08:44','2022-11-22 19:08:44',NULL),(167,8087,40720,1575,2,167,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',1084369.93,'S/IVA ventas enero/20',NULL,1,'2022-11-22 19:11:24','2022-11-22 19:11:24',NULL),(168,8087,40720,1575,3,168,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',1055932.55,'S/libro IVA compras enero/20',NULL,1,'2022-11-22 19:27:24','2022-11-22 19:27:24',NULL),(169,8087,40720,1575,1,169,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',141433.94,'P/devengar sueldos y Cgs Soc enero/20',NULL,1,'2022-11-22 19:33:01','2022-11-22 19:33:01',NULL),(170,8087,40720,1575,5,170,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',934183.46,'S/movimientos bancarios del mes',NULL,1,'2022-11-22 19:37:25','2022-11-24 08:47:09','2022-11-24 08:47:09'),(171,8087,40720,1576,21,171,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-07','2020-02-07',103613.00,'Pago sueldos enero/20',NULL,1,'2022-11-23 08:07:19','2022-11-23 08:07:19',NULL),(172,8087,40720,1576,10,172,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-07','2020-02-07',37820.94,'Pago Cgs soc y sindicales 01/2020',NULL,1,'2022-11-23 08:12:20','2022-11-23 08:12:20',NULL),(173,8087,40720,1576,19,173,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-12','2020-02-12',30000.00,'Por retiro de socios',NULL,1,'2022-11-23 08:14:20','2022-11-23 08:14:20',NULL),(174,8087,40720,1576,10,174,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-12','2020-02-12',17811.08,'Pago anticipo 8 y 9 ganancias',NULL,1,'2022-11-23 08:21:04','2022-11-24 08:49:28','2022-11-24 08:49:28'),(175,8087,40720,1576,15,175,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-25','2020-02-25',188196.43,'P/contabilizar IVA ddjj del mes de enero/20',NULL,1,'2022-11-23 08:27:58','2022-11-23 08:27:58',NULL);
INSERT INTO `balance_libro` VALUES (176,8087,40720,1576,10,176,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',29895.86,'S/Pago de IIBB de enero/20',NULL,1,'2022-11-23 08:49:56','2022-11-23 11:10:44','2022-11-23 11:10:44'),(177,8087,40720,1576,10,177,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',6225.06,'S/Pago de IVA de enero/20',NULL,1,'2022-11-23 08:51:26','2022-11-23 08:51:26',NULL),(178,8087,40720,1576,10,178,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',8202.43,'Pago anticipo 10 ganancias',NULL,1,'2022-11-23 08:58:17','2022-11-24 08:57:48','2022-11-24 08:57:48'),(179,8087,40720,1576,3,179,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',443459.14,'S/libro IVA compras febrero/20',NULL,1,'2022-11-23 09:08:10','2022-11-23 11:15:25','2022-11-23 11:15:25'),(180,8087,40720,1576,2,180,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',695604.41,'S/IVA ventas febrero/20',NULL,1,'2022-11-23 09:09:32','2022-11-23 09:09:32',NULL),(181,8087,40720,1576,1,181,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',130442.12,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-11-23 09:43:58','2022-11-23 09:43:58',NULL),(182,8087,40720,1576,5,182,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',811761.93,'S/movimientos bancarios del mes',NULL,1,'2022-11-23 09:50:08','2022-11-23 09:50:08',NULL),(183,8087,40720,1577,21,183,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-05','2020-03-05',97150.00,'Pago sueldos febrero/20',NULL,1,'2022-11-23 09:51:23','2022-11-23 09:51:23',NULL),(184,8087,40720,1577,19,184,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-06','2020-03-06',30000.00,'Por retiro de socios',NULL,1,'2022-11-23 10:01:32','2022-11-23 10:01:32',NULL),(185,8087,40720,1577,10,185,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-06','2020-03-06',33292.12,'Pago Cgs soc y sindicales 02/2020',NULL,1,'2022-11-23 10:03:26','2022-11-23 10:03:26',NULL),(186,8087,40720,1577,15,186,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-17','2020-03-17',120724.73,'P/contabilizar IVA ddjj del mes de febrero/20',NULL,1,'2022-11-23 10:05:34','2022-11-23 10:05:34',NULL),(187,8087,40720,1577,10,187,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-18','2020-03-18',17788.38,'S/Pago de IIBB de febrero/20',NULL,1,'2022-11-23 10:08:59','2022-11-23 11:00:56','2022-11-23 11:00:56'),(188,8087,40720,1577,10,188,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-18','2020-03-18',46209.39,'P/pago ddjj IVA febrero/20',NULL,1,'2022-11-23 10:12:43','2022-11-23 10:12:43',NULL),(189,8087,40720,1577,21,189,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-20','2020-03-20',15000.00,'Pago sueldos marzo/20',NULL,1,'2022-11-23 10:14:27','2022-11-23 10:14:27',NULL),(190,8087,40720,1577,3,190,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',414173.90,'S/libro IVA compras marzo/20',NULL,1,'2022-11-23 10:17:49','2022-11-23 11:17:16','2022-11-23 11:17:16'),(191,8087,40720,1577,2,191,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',512159.70,'S/IVA ventas marzo/20',NULL,1,'2022-11-23 10:21:04','2022-11-23 10:21:04',NULL),(192,8087,40720,1577,1,192,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',221102.17,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-11-23 10:23:11','2022-11-23 10:23:11',NULL);
INSERT INTO `balance_libro` VALUES (193,8087,40720,1577,5,193,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',630062.04,'S/movimientos bancarios del mes',NULL,1,'2022-11-23 10:26:37','2022-11-23 10:26:37',NULL),(194,8087,40720,1578,21,194,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-08','2020-04-08',176264.71,'Pago sueldos marzo/20',NULL,1,'2022-11-23 10:28:06','2022-11-23 10:28:06',NULL),(195,8087,40720,1578,19,195,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-13','2020-04-13',30000.00,'Por retiro de socios',NULL,1,'2022-11-23 10:30:42','2022-11-23 10:30:42',NULL),(196,8087,40720,1578,10,196,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-20','2020-04-20',24159.02,'Pago Cgs soc y sindicales 03/2020',NULL,1,'2022-11-23 10:32:07','2022-11-23 10:32:07',NULL),(197,8087,40720,1578,15,197,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-24','2020-04-24',88887.22,'P/contabilizar IVA ddjj del mes de marzo/20',NULL,1,'2022-11-23 10:36:01','2022-11-23 10:36:01',NULL),(198,8087,40720,1578,10,198,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-28','2020-04-28',19001.63,'P/pago ddjj IVA marzo/20',NULL,1,'2022-11-23 10:37:10','2022-11-23 10:37:10',NULL),(199,8087,40720,1578,10,199,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-28','2020-04-28',17470.72,'S/Pago de IIBB de marzo/20',NULL,1,'2022-11-23 10:58:23','2022-11-23 10:58:23',NULL),(200,8087,40720,1577,10,200,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-18','2020-03-18',17788.38,'S/Pago de IIBB de febrero/20',NULL,1,'2022-11-23 11:00:56','2022-11-23 11:00:56',NULL),(201,8087,40720,1576,10,201,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',29895.86,'S/Pago de IIBB de enero/20',NULL,1,'2022-11-23 11:10:44','2022-11-23 11:10:44',NULL),(202,8087,40720,1576,3,202,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',443459.14,'S/libro IVA compras febrero/20',NULL,1,'2022-11-23 11:15:25','2022-11-23 11:15:25',NULL),(203,8087,40720,1577,3,203,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',414173.90,'S/libro IVA compras marzo/20',NULL,1,'2022-11-23 11:17:16','2022-11-23 11:17:16',NULL),(204,8087,40720,1578,3,204,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',103045.19,'S/libro IVA compras abril/20',NULL,1,'2022-11-23 11:22:50','2022-11-23 11:22:50',NULL),(205,8087,40720,1578,2,205,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',217807.06,'S/IVA ventas abril/20',NULL,1,'2022-11-23 11:24:20','2022-11-23 11:24:20',NULL),(206,8087,40720,1578,1,206,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',80547.60,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-11-23 11:25:57','2022-11-23 11:25:57',NULL),(207,8087,40720,1578,5,207,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',422096.64,'S/movimientos bancarios del mes',NULL,1,'2022-11-23 11:29:40','2022-11-23 11:29:40',NULL),(208,8087,40720,1579,21,208,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-08','2020-05-08',63574.31,'Pago sueldos abril/20 con Subsidio\"decreto 332/20ATP\"',NULL,1,'2022-11-23 11:40:44','2022-11-23 11:40:44',NULL),(209,8087,40720,1579,10,209,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-14','2020-05-14',14340.45,'Pago Cgs soc y sindicales 04/2020',NULL,1,'2022-11-23 11:42:39','2022-11-23 11:42:39',NULL),(210,8087,40720,1579,15,210,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-22','2020-05-22',37801.23,'P/contabilizar IVA ddjj del mes de abril/20',NULL,1,'2022-11-23 11:45:27','2022-11-23 11:45:27',NULL);
INSERT INTO `balance_libro` VALUES (211,8087,40720,1579,10,211,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-26','2020-05-26',21289.98,'P/pago ddjj IVA abril/20',NULL,1,'2022-11-23 11:47:49','2022-11-23 11:47:49',NULL),(212,8087,40720,1579,10,212,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-26','2020-05-26',9132.22,'S/Pago de IIBB de abril/20',NULL,1,'2022-11-23 11:50:48','2022-11-23 11:50:48',NULL),(213,8087,40720,1579,21,213,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-29','2020-05-29',60000.00,'Por pagos parciales a proveedores',NULL,1,'2022-11-23 11:52:07','2022-11-23 11:52:07',NULL),(214,8087,40720,1579,3,214,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',284141.03,'S/libro IVA compras mayo/20',NULL,1,'2022-11-23 11:56:26','2022-11-23 11:56:26',NULL),(215,8087,40720,1579,2,215,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',511270.64,'S/IVA ventas mayo/20',NULL,1,'2022-11-23 11:58:11','2022-11-23 11:58:11',NULL),(216,8087,40720,1579,1,216,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',80547.60,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-11-23 12:00:21','2022-11-23 12:00:21',NULL),(217,8087,40720,1579,5,217,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',491496.11,'S/movimientos bancarios del mes',NULL,1,'2022-11-23 12:03:47','2022-11-23 12:03:47',NULL),(218,8087,40720,1580,21,218,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-08','2020-06-08',63574.31,'Pago sueldos mayo/20 con Subsidio\"decreto 332/20ATP\"',NULL,1,'2022-11-23 12:05:54','2022-11-23 12:05:54',NULL),(219,8087,40720,1580,10,219,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-10','2020-06-10',22651.73,'Pago Cgs soc y sindicales 05/2020',NULL,1,'2022-11-23 12:07:27','2022-11-23 12:07:27',NULL),(220,8087,40720,1580,15,220,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-22','2020-06-22',88732.92,'P/contabilizar IVA ddjj del mes de mayo/20',NULL,1,'2022-11-23 12:10:21','2022-11-23 12:10:21',NULL),(221,8087,40720,1580,10,221,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',42001.41,'P/pago ddjj IVA mayo/20',NULL,1,'2022-11-23 12:11:44','2022-11-23 12:11:44',NULL),(222,8087,40720,1580,10,222,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',16482.03,'S/Pago de IIBB de mayo/20',NULL,1,'2022-11-23 12:14:44','2022-11-23 12:14:44',NULL),(223,8087,40720,1580,21,223,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',80000.00,'Por pagos parciales a proveedores',NULL,1,'2022-11-23 12:15:42','2022-11-23 12:15:42',NULL),(224,8087,40720,1580,1,224,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',122491.09,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-11-23 12:17:48','2022-11-23 12:17:48',NULL),(225,8087,40720,1580,3,225,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',332536.56,'S/libro IVA compras junio/20',NULL,1,'2022-11-23 12:20:50','2022-11-23 12:20:50',NULL),(226,8087,40720,1580,2,226,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',593693.94,'S/IVA ventas junio/20',NULL,1,'2022-11-23 12:22:53','2022-11-23 12:22:53',NULL),(227,8087,40720,1580,5,227,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',471805.11,'S/movimientos bancarios del mes',NULL,1,'2022-11-23 12:26:52','2022-11-23 12:26:52',NULL),(228,8087,40720,1581,21,228,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',96122.31,'Pago sueldos junio/20',NULL,1,'2022-11-23 12:29:02','2022-11-23 12:29:02',NULL);
INSERT INTO `balance_libro` VALUES (229,8087,40720,1581,19,229,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',15000.00,'Por retiro de socios',NULL,1,'2022-11-23 12:30:10','2022-11-23 12:30:10',NULL),(230,8087,40720,1581,10,230,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',24035.58,'Pago Cgs soc y sindicales 06/2020',NULL,1,'2022-11-23 12:33:15','2022-11-23 12:33:15',NULL),(231,8087,40720,1581,15,231,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',103037.80,'P/contabilizar IVA ddjj del mes de junio/20',NULL,1,'2022-11-23 12:37:10','2022-11-23 12:37:10',NULL),(232,8087,40720,1581,10,232,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-24','2020-07-24',17489.19,'S/Pago de IIBB de junio/20',NULL,1,'2022-11-23 14:34:18','2022-11-23 14:34:18',NULL),(233,8087,40720,1581,10,233,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-24','2020-07-24',48630.40,'P/pago ddjj IVA junio/20',NULL,1,'2022-11-23 14:37:35','2022-11-23 14:37:35',NULL),(234,8087,40720,1581,5,234,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',281757.22,'S/movimientos bancarios del mes',NULL,1,'2022-11-23 14:41:48','2022-11-23 14:41:48',NULL),(235,8087,40720,1581,1,235,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',80547.60,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-11-23 14:49:59','2022-11-23 14:49:59',NULL),(236,8087,40720,1581,3,236,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',386585.23,'S/libro IVA compras julio/20',NULL,1,'2022-11-23 15:12:28','2022-11-23 15:12:28',NULL),(237,8087,40720,1581,2,237,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',414090.73,'S/IVA ventas julio/20',NULL,1,'2022-11-23 15:25:29','2022-11-23 15:25:29',NULL),(238,8087,40720,1582,21,238,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-06','2020-08-06',63574.31,'Pago sueldos julio/20 con Subsidio\"decreto 332/20ATP\"',NULL,1,'2022-11-23 15:32:31','2022-11-23 15:32:31',NULL),(239,8087,40720,1582,10,239,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-06','2020-08-06',16973.29,'Pago Cgs soc y sindicales 07/2020',NULL,1,'2022-11-23 15:35:14','2022-11-23 15:35:14',NULL),(240,8087,40720,1582,19,240,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',20000.00,'Por retiro de socios',NULL,1,'2022-11-23 15:49:54','2022-11-23 15:49:54',NULL),(241,8087,40720,1582,15,241,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-21','2020-08-21',71866.98,'P/contabilizar IVA ddjj del mes de julio/20',NULL,1,'2022-11-23 15:51:46','2022-11-23 15:51:46',NULL),(242,8087,40720,1582,10,242,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',8194.06,'P/pago ddjj IVA julio/20',NULL,1,'2022-11-23 15:52:56','2022-11-23 15:52:56',NULL),(243,8087,40720,1582,10,243,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',12864.57,'S/Pago de IIBB de julio20',NULL,1,'2022-11-23 15:55:37','2022-11-23 15:55:37',NULL),(244,8087,40720,1582,1,244,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',110967.60,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-11-23 16:15:20','2022-11-23 16:15:20',NULL),(245,8087,40720,1582,3,245,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',318568.55,'S/libro IVA compras agosto/20',NULL,1,'2022-11-23 16:18:39','2022-11-23 16:18:39',NULL),(246,8087,40720,1582,2,246,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',591140.49,'S/IVA ventas agosto/20',NULL,1,'2022-11-23 16:19:49','2022-11-23 16:19:49',NULL);
INSERT INTO `balance_libro` VALUES (247,8087,40720,1582,5,247,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',385827.20,'S/movimientos bancarios del mes',NULL,1,'2022-11-23 16:23:27','2022-11-23 16:23:27',NULL),(248,8087,40720,1582,21,248,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',50000.00,'Por pagos parciales a proveedores',NULL,1,'2022-11-23 16:25:15','2022-11-23 16:25:15',NULL),(249,8087,40720,1583,21,249,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-08','2020-09-08',93574.31,'Pago sueldos agosto/20',NULL,1,'2022-11-23 16:26:35','2022-11-23 16:26:35',NULL),(250,8087,40720,1583,10,250,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-02','2020-09-02',17393.29,'Pago Cgs soc y sindicales 08/2020',NULL,1,'2022-11-23 16:28:59','2022-11-23 16:28:59',NULL),(251,8087,40720,1583,15,251,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-21','2020-09-21',102594.63,'P/contabilizar IVA ddjj del mes de agosto/20',NULL,1,'2022-11-23 16:31:07','2022-11-23 16:31:07',NULL),(252,8087,40720,1583,10,252,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-21','2020-09-21',17991.17,'S/Pago de IIBB de agosto/20',NULL,1,'2022-11-23 16:33:30','2022-11-23 16:33:30',NULL),(253,8087,40720,1583,10,253,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',50739.46,'P/pago ddjj IVA agosto/20',NULL,1,'2022-11-23 16:34:29','2022-11-23 16:34:29',NULL),(254,8087,40720,1583,19,254,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',20000.00,'Por retiro de socios',NULL,1,'2022-11-23 16:35:11','2022-11-23 16:35:11',NULL),(255,8087,40720,1583,1,255,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',101324.19,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-11-23 16:36:41','2022-11-23 16:36:41',NULL),(256,8087,40720,1583,3,256,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',449604.64,'S/libro IVA compras septiembre/20',NULL,1,'2022-11-23 16:39:47','2022-11-23 16:39:47',NULL),(257,8087,40720,1583,2,257,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',606470.35,'S/IVA ventas septiembre/20',NULL,1,'2022-11-23 16:41:34','2022-11-23 16:41:34',NULL),(258,8087,40720,1583,5,258,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',435492.14,'S/movimientos bancarios del mes',NULL,1,'2022-11-23 16:55:52','2022-11-23 16:55:52',NULL),(259,8087,40720,1584,21,259,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',83900.27,'Pago sueldos septiembre/20 con Subsidio\"decreto 332/20ATP\"',NULL,1,'2022-11-23 16:57:35','2022-11-23 16:57:35',NULL),(260,8087,40720,1584,10,260,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-08','2020-10-08',22519.34,'Pago Cgs soc y sindicales 09/2020',NULL,1,'2022-11-23 16:59:46','2022-11-23 16:59:46',NULL),(261,8087,40720,1584,15,261,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-23','2020-10-23',105255.19,'P/contabilizar IVA ddjj del mes de septiembre/20',NULL,1,'2022-11-23 17:01:42','2022-11-23 17:01:42',NULL),(262,8087,40720,1584,10,262,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-26','2020-10-26',31477.45,'P/pago ddjj IVA septiembre/20',NULL,1,'2022-11-23 17:02:44','2022-11-23 17:02:44',NULL),(263,8087,40720,1584,10,263,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-23','2020-10-23',18765.05,'S/Pago de IIBB de septiembre/20',NULL,1,'2022-11-23 17:05:34','2022-11-23 17:05:34',NULL);
INSERT INTO `balance_libro` VALUES (264,8087,40720,1584,1,264,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',111653.32,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-11-23 17:07:00','2022-11-23 17:07:00',NULL),(265,8087,40720,1584,3,265,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1362765.91,'S/libro IVA compras octubre/20',NULL,1,'2022-11-23 17:10:42','2022-11-23 17:10:42',NULL),(266,8087,40720,1584,2,266,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',744606.11,'S/IVA ventas octubre/20',NULL,1,'2022-11-23 17:12:17','2022-11-23 17:12:17',NULL),(267,8087,40720,1584,5,267,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',434230.87,'S/movimientos bancarios del mes',NULL,1,'2022-11-23 17:15:24','2022-11-23 17:15:24',NULL),(268,8087,40720,1585,10,268,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-05','2020-11-05',20972.99,'Pago Cgs soc y sindicales 10/2020',NULL,1,'2022-11-23 19:34:04','2022-11-23 19:34:04',NULL),(269,8087,40720,1585,21,269,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-12','2020-11-12',90680.33,'Pago sueldos octubre/20 con Subsidio\"decreto 332/20ATP\"',NULL,1,'2022-11-23 19:36:00','2022-11-23 19:36:00',NULL),(270,8087,40720,1585,15,270,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-24','2020-11-24',190060.80,'P/contabilizar IVA ddjj del mes de octubre/20',NULL,1,'2022-11-23 19:38:43','2022-11-23 19:38:43',NULL),(271,8087,40720,1585,10,271,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-24','2020-11-24',30731.44,'S/Pago de IIBB de octubre/20',NULL,1,'2022-11-23 19:42:14','2022-11-23 19:42:14',NULL),(272,8087,40720,1585,1,272,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',111653.99,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-11-23 19:44:00','2022-11-23 19:44:00',NULL),(273,8087,40720,1585,3,273,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',652094.78,'S/libro IVA compras noviembre/20',NULL,1,'2022-11-23 19:49:32','2022-11-23 19:49:32',NULL),(274,8087,40720,1585,2,274,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',565210.96,'S/IVA ventas noviembre/20',NULL,1,'2022-11-23 19:50:54','2022-11-23 19:50:54',NULL),(275,8087,40720,1585,5,275,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',516718.77,'S/movimientos bancarios del mes',NULL,1,'2022-11-23 19:53:57','2022-11-23 19:53:57',NULL),(276,8087,40720,1586,15,276,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',106288.06,'P/contabilizar IVA ddjj del mes de noviembre/20',NULL,1,'2022-11-23 20:00:28','2022-11-23 20:00:28',NULL),(277,8087,40720,1586,16,277,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',22372.12,'P/contabilizar IIBB ddjj del mes de diciembre/20',NULL,1,'2022-11-23 20:03:49','2022-11-23 20:03:49',NULL),(278,8087,40720,1586,21,278,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',70341.00,'Pago sueldo Rios/Rosa sac diciembre/20',NULL,1,'2022-11-23 20:06:59','2022-11-23 20:06:59',NULL),(279,8087,40720,1586,19,279,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',30000.00,'Por retiro de socios',NULL,1,'2022-11-23 20:08:25','2022-11-23 20:08:25',NULL),(280,8087,40720,1586,21,280,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',60000.00,'Por pagos parciales a proveedores',NULL,1,'2022-11-23 20:09:52','2022-11-23 20:09:52',NULL);
INSERT INTO `balance_libro` VALUES (281,8087,40720,1586,15,281,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',124416.09,'P/contabilizar IVA ddjj del mes de diciembre/20',NULL,1,'2022-11-23 20:12:02','2022-11-23 20:12:02',NULL),(282,8087,40720,1586,16,282,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',30011.33,'P/contabilizar IIBB ddjj del mes de diciembre/20',NULL,1,'2022-11-23 20:15:12','2022-11-23 20:15:12',NULL),(283,8087,40720,1586,21,283,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-29','2020-12-29',90681.00,'Pago sueldos noviembre/20',NULL,1,'2022-11-23 20:16:30','2022-11-23 20:16:30',NULL),(284,8087,40720,1586,1,284,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',167992.19,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-11-23 20:18:47','2022-11-23 20:18:47',NULL),(285,8087,40720,1586,3,285,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',675375.91,'S/libro IVA compras diciembre/20',NULL,1,'2022-11-23 20:23:01','2022-11-23 20:23:01',NULL),(286,8087,40720,1586,2,286,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',716873.66,'S/IVA ventas diciembre/20',NULL,1,'2022-11-23 20:24:25','2022-11-23 20:24:25',NULL),(287,8087,40720,1586,5,287,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',675681.29,'S/movimientos bancarios del mes',NULL,1,'2022-11-23 20:28:15','2022-11-23 20:28:15',NULL),(288,8087,40720,1586,4,288,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',15533.64,'Contabiliza amort. del ejercicio',NULL,1,'2022-11-23 20:34:32','2023-01-06 15:54:29','2023-01-06 15:54:29'),(289,8087,40720,1586,19,289,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2015.14,'Por ajuste de saldos de cuentas por redondeo',NULL,1,'2022-11-23 20:36:19','2022-11-23 20:36:19',NULL),(290,8087,40720,1586,19,290,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',4002107.80,'P/contabilizar el costo de las ventas del ejercicio',NULL,1,'2022-11-23 20:38:46','2023-03-01 14:49:10','2023-03-01 14:49:10'),(291,8087,40720,1575,5,291,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',934183.46,'S/movimientos bancarios del mes',NULL,1,'2022-11-24 08:47:09','2022-11-24 08:47:09',NULL),(292,8087,40720,1576,10,292,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-12','2020-02-12',17811.08,'Pago anticipo 8 y 9 ganancias',NULL,1,'2022-11-24 08:49:28','2022-11-24 08:49:28',NULL),(293,8087,40720,1576,10,293,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',8202.43,'Pago anticipo 10 ganancias',NULL,1,'2022-11-24 08:57:48','2022-11-24 08:57:48',NULL),(294,8087,40720,1586,23,294,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1665594.89,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-11-24 11:17:31','2023-01-06 16:05:30','2023-01-06 16:05:30'),(295,8087,40720,1590,12,295,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',4754688.90,'Saldos iniciales',NULL,1,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(296,8087,40720,1590,10,296,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',31970.19,'Pago Cgs soc y sindicales 12/2020',NULL,1,'2022-12-06 12:33:08','2022-12-06 12:33:08',NULL),(297,8087,40720,1590,10,297,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',20972.99,'Pago Cgs soc y sindicales 11/2020',NULL,1,'2022-12-06 12:35:59','2022-12-06 12:35:59',NULL);
INSERT INTO `balance_libro` VALUES (298,8087,40720,1590,1,298,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',65681.00,'Pago sueldos diciembre/20',NULL,1,'2022-12-06 12:39:53','2022-12-06 12:39:53',NULL),(299,8087,40720,1590,10,299,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',9989.14,'S/Pago de IIBB de nov y dic/20',NULL,1,'2022-12-06 12:43:26','2022-12-06 12:43:26',NULL),(300,8087,40720,1590,19,300,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',50000.00,'Por retiro de socios',NULL,1,'2022-12-06 12:45:40','2022-12-06 12:45:40',NULL),(301,8087,40720,1590,19,301,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',50000.00,'Por retiro de socios',NULL,1,'2022-12-06 12:45:51','2022-12-06 12:46:11','2022-12-06 12:46:11'),(302,8087,40720,1590,19,302,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',50000.00,'Por retiro de socios',NULL,1,'2022-12-06 12:45:51','2022-12-06 12:45:58','2022-12-06 12:45:58'),(303,8087,40720,1590,2,303,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',820551.24,'S/IVA ventas enero/21',NULL,1,'2022-12-06 12:50:08','2022-12-06 12:50:08',NULL),(304,8087,40720,1590,3,304,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',967801.94,'S/libro IVA compras enero/21',NULL,1,'2022-12-06 12:56:34','2022-12-06 12:56:34',NULL),(305,8087,40720,1590,1,305,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',120950.14,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-12-06 12:59:49','2022-12-06 12:59:49',NULL),(306,8087,40720,1590,5,306,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',493636.23,'S/movimientos bancarios del mes',NULL,1,'2022-12-06 13:04:56','2022-12-06 13:04:56',NULL),(307,8087,40720,1590,21,307,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',96783.00,'Pago sueldos enero/21',NULL,1,'2022-12-06 14:36:22','2022-12-06 14:36:22',NULL),(308,8087,40720,1591,10,308,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',24167.14,'Pago Cgs soc y sindicales 01/2021',NULL,1,'2022-12-06 14:41:20','2022-12-06 14:41:20',NULL),(309,8087,40720,1591,15,309,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',164349.86,'P/contabilizar IVA ddjj del mes de enero/21',NULL,1,'2022-12-06 14:50:13','2022-12-06 14:50:13',NULL),(310,8087,40720,1591,10,310,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',33746.05,'S/Pago de IIBB de enero/21',NULL,1,'2022-12-06 15:02:35','2022-12-06 15:02:35',NULL),(311,8087,40720,1591,3,311,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',503481.17,'S/libro IVA compras febrero/21',NULL,1,'2022-12-06 15:17:10','2022-12-06 15:17:10',NULL),(312,8087,40720,1591,2,312,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',328536.65,'S/IVA ventas febrero/21',NULL,1,'2022-12-06 15:28:24','2022-12-06 15:28:24',NULL),(313,8087,40720,1591,1,313,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',132078.17,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-12-06 15:30:17','2022-12-06 15:30:17',NULL),(314,8087,40720,1591,5,314,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',227933.37,'S/movimientos bancarios del mes',NULL,1,'2022-12-06 15:34:35','2022-12-06 15:34:35',NULL),(315,8087,40720,1592,21,315,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',105648.00,'Pago sueldos febrero/21',NULL,1,'2022-12-06 15:37:58','2022-12-06 15:37:58',NULL);
INSERT INTO `balance_libro` VALUES (316,8087,40720,1592,19,316,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',30000.00,'Por retiro de socios',NULL,1,'2022-12-06 15:38:45','2022-12-06 15:38:45',NULL),(317,8087,40720,1592,10,317,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',26430.17,'Pago Cgs soc y sindicales 02/2021',NULL,1,'2022-12-06 15:41:19','2022-12-06 15:41:19',NULL),(318,8087,40720,1592,15,318,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',82327.88,'P/contabilizar IVA ddjj del mes de febrero/21',NULL,1,'2022-12-06 15:42:58','2022-12-06 15:42:58',NULL),(319,8087,40720,1592,10,319,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',15728.56,'S/Pago de IIBB de febrero/21',NULL,1,'2022-12-06 15:45:49','2022-12-06 15:45:49',NULL),(320,8087,40720,1592,3,320,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1006883.09,'S/libro IVA compras marzo/21',NULL,1,'2022-12-06 15:50:29','2022-12-06 15:50:29',NULL),(321,8087,40720,1592,2,321,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',795729.21,'S/IVA ventas marzo/21',NULL,1,'2022-12-06 15:51:53','2022-12-06 15:51:53',NULL),(322,8087,40720,1592,1,322,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',121039.58,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-12-06 15:54:39','2022-12-06 15:54:39',NULL),(323,8087,40720,1592,5,323,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',572933.31,'S/movimientos bancarios del mes',NULL,1,'2022-12-06 15:57:00','2022-12-06 15:57:00',NULL),(324,8087,40720,1593,21,324,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',96783.00,'Pago sueldos marzo/21',NULL,1,'2022-12-06 16:03:57','2022-12-06 16:03:57',NULL),(325,8087,40720,1593,10,325,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',24256.58,'Pago Cgs soc y sindicales 03/2021',NULL,1,'2022-12-06 16:05:22','2022-12-06 16:05:22',NULL),(326,8087,40720,1593,15,326,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',159639.21,'P/contabilizar IVA ddjj del mes de marzo/21',NULL,1,'2022-12-06 16:07:06','2022-12-06 16:07:06',NULL),(327,8087,40720,1593,10,327,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',32745.30,'S/Pago de IIBB de marzo/21',NULL,1,'2022-12-06 16:09:41','2022-12-06 16:09:41',NULL),(328,8087,40720,1593,3,328,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',856686.33,'S/libro IVA compras abril/21',NULL,1,'2022-12-06 16:12:47','2022-12-06 16:12:47',NULL),(329,8087,40720,1593,2,329,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',649545.50,'S/IVA ventas abril/21',NULL,1,'2022-12-06 16:21:07','2022-12-06 16:21:07',NULL),(330,8087,40720,1593,1,330,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',131743.08,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-12-06 16:22:48','2022-12-06 16:22:48',NULL),(331,8087,40720,1593,5,331,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',354095.71,'S/movimientos bancarios del mes',NULL,1,'2022-12-06 16:26:17','2022-12-06 16:26:17',NULL),(332,8087,40720,1594,21,332,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',103800.00,'Pago sueldos abril/21',NULL,1,'2022-12-06 16:27:44','2022-12-06 16:27:44',NULL),(333,8087,40720,1594,10,333,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',27943.08,'Pago Cgs soc y sindicales 04/2021',NULL,1,'2022-12-06 16:29:12','2022-12-06 16:29:12',NULL);
INSERT INTO `balance_libro` VALUES (334,8087,40720,1594,15,334,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',143157.28,'P/contabilizar IVA ddjj del mes de abril/21',NULL,1,'2022-12-06 16:31:58','2022-12-06 16:31:58',NULL),(335,8087,40720,1594,10,335,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',29171.73,'S/Pago de IIBB de abril/21',NULL,1,'2022-12-06 16:34:57','2022-12-06 16:34:57',NULL),(336,8087,40720,1594,3,336,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',714188.19,'S/libro IVA compras mayo/21',NULL,1,'2022-12-06 16:38:52','2022-12-06 16:38:52',NULL),(337,8087,40720,1594,2,337,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',624948.91,'S/IVA ventas mayo/21',NULL,1,'2022-12-06 16:40:26','2022-12-06 16:40:26',NULL),(338,8087,40720,1594,1,338,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',131731.08,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-12-06 16:41:51','2022-12-06 16:41:51',NULL),(339,8087,40720,1594,5,339,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',370545.55,'S/movimientos bancarios del mes',NULL,1,'2022-12-06 16:43:56','2022-12-06 16:43:56',NULL),(340,8087,40720,1595,21,340,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',103800.00,'Pago sueldos mayo/21',NULL,1,'2022-12-06 16:46:34','2022-12-06 16:46:34',NULL),(341,8087,40720,1595,10,341,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',27931.08,'Pago Cgs soc y sindicales 05/2021',NULL,1,'2022-12-06 16:48:04','2022-12-06 16:48:04',NULL),(342,8087,40720,1595,19,342,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',40000.00,'Por retiro de socios',NULL,1,'2022-12-06 16:48:52','2022-12-06 16:48:52',NULL),(343,8087,40720,1595,15,343,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',119461.57,'P/contabilizar IVA ddjj del mes de mayo/21',NULL,1,'2022-12-06 16:50:53','2022-12-06 16:50:53',NULL),(344,8087,40720,1595,10,344,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',25457.18,'S/Pago de IIBB de mayo/21',NULL,1,'2022-12-06 16:59:52','2022-12-06 16:59:52',NULL),(345,8087,40720,1595,1,345,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',198061.99,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-12-06 17:02:40','2022-12-06 17:02:40',NULL),(346,8087,40720,1595,3,346,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1075060.77,'S/libro IVA compras junio/21',NULL,1,'2022-12-06 17:05:38','2022-12-06 17:05:38',NULL),(347,8087,40720,1595,2,347,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',839723.71,'S/IVA ventas junio/21',NULL,1,'2022-12-06 17:06:53','2022-12-06 17:06:53',NULL),(348,8087,40720,1595,5,348,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',800419.97,'S/movimientos bancarios del mes',NULL,1,'2022-12-06 17:09:23','2022-12-06 17:09:23',NULL),(349,8087,40720,1596,21,349,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',155700.00,'Pago sueldos y sac junio/21',NULL,1,'2022-12-07 08:20:11','2022-12-07 08:20:11',NULL),(350,8087,40720,1596,15,350,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',177192.40,'P/contabilizar IVA ddjj del mes de junio/21',NULL,1,'2022-12-07 08:23:00','2022-12-07 08:23:00',NULL),(351,8087,40720,1596,10,351,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',42361.99,'Pago Cgs soc y sindicales 06/2021',NULL,1,'2022-12-07 08:24:26','2022-12-07 08:24:26',NULL);
INSERT INTO `balance_libro` VALUES (352,8087,40720,1596,10,352,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',35199.15,'S/Pago de IIBB de junio/21',NULL,1,'2022-12-07 08:26:52','2022-12-07 08:26:52',NULL),(353,8087,40720,1596,19,353,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',20000.00,'Por retiro de socios',NULL,1,'2022-12-07 08:32:26','2022-12-07 08:32:26',NULL),(354,8087,40720,1596,5,354,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',763617.77,'S/movimientos bancarios del mes',NULL,1,'2022-12-07 08:53:22','2022-12-07 08:53:22',NULL),(355,8087,40720,1596,1,355,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',132519.85,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-12-07 08:58:31','2022-12-07 08:58:31',NULL),(356,8087,40720,1596,3,356,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',845345.53,'S/libro IVA compras julio/21',NULL,1,'2022-12-07 09:04:35','2022-12-07 09:04:35',NULL),(357,8087,40720,1596,2,357,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',874138.04,'S/IVA ventas junio/21',NULL,1,'2022-12-07 09:07:00','2022-12-07 09:07:00',NULL),(358,8087,40720,1597,21,358,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',28201.85,'Pago sueldos julio/21',NULL,1,'2022-12-07 09:08:46','2022-12-07 09:10:09','2022-12-07 09:10:09'),(359,8087,40720,1597,21,359,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',104318.00,'Pago sueldos julio/21',NULL,1,'2022-12-07 09:10:09','2022-12-07 09:10:09',NULL),(360,8087,40720,1597,10,360,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',28201.85,'Pago Cgs soc y sindicales 07/2021',NULL,1,'2022-12-07 09:12:07','2022-12-07 09:12:07',NULL),(361,8087,40720,1597,19,361,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',20000.00,'Por retiro de socios',NULL,1,'2022-12-07 09:13:14','2022-12-07 09:13:14',NULL),(362,8087,40720,1597,15,362,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',151709.91,'P/contabilizar IVA ddjj del mes de julio/21',NULL,1,'2022-12-07 09:16:15','2022-12-07 09:16:15',NULL),(363,8087,40720,1597,10,363,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',32255.82,'S/Pago de IIBB de julio/21',NULL,1,'2022-12-07 09:19:38','2022-12-07 09:19:38',NULL),(364,8087,40720,1597,1,364,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',144931.77,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-12-07 09:24:45','2022-12-07 09:24:45',NULL),(365,8087,40720,1597,3,365,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',805712.20,'S/libro IVA compras agosto/21',NULL,1,'2022-12-07 09:28:33','2022-12-07 09:28:33',NULL),(366,8087,40720,1597,2,366,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1044375.41,'S/IVA ventas agosto/21',NULL,1,'2022-12-07 09:29:51','2022-12-07 09:29:51',NULL),(367,8087,40720,1597,5,367,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',503894.26,'S/movimientos bancarios del mes',NULL,1,'2022-12-07 09:32:03','2022-12-07 09:32:03',NULL),(368,8087,40720,1597,21,368,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',250000.00,'Por pagos parciales a proveedores',NULL,1,'2022-12-07 09:34:11','2022-12-07 09:34:11',NULL),(369,8087,40720,1597,21,369,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',250000.00,'Por pagos parciales a proveedores',NULL,1,'2022-12-07 09:34:49','2022-12-07 09:34:49',NULL);
INSERT INTO `balance_libro` VALUES (370,8087,40720,1598,21,370,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',112465.00,'Pago sueldos agosto/21',NULL,1,'2022-12-07 09:43:42','2022-12-07 09:43:42',NULL),(371,8087,40720,1598,10,371,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',32466.77,'Pago Cgs soc y sindicales 08/2021',NULL,1,'2022-12-07 09:45:35','2022-12-07 09:45:35',NULL),(372,8087,40720,1598,15,372,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',181255.24,'P/contabilizar IVA ddjj del mes de agosto/21',NULL,1,'2022-12-07 09:47:29','2022-12-07 09:47:29',NULL),(373,8087,40720,1598,10,373,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',36796.62,'S/Pago de IIBB de agosto/21',NULL,1,'2022-12-07 09:49:34','2022-12-07 09:49:34',NULL),(374,8087,40720,1598,21,374,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',250000.00,'Por pagos parciales a proveedores',NULL,1,'2022-12-07 09:51:42','2022-12-07 09:51:42',NULL),(375,8087,40720,1598,21,375,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',250000.00,'Por pagos parciales a proveedores',NULL,1,'2022-12-07 09:52:28','2022-12-07 09:52:28',NULL),(376,8087,40720,1598,1,376,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',144940.71,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-12-07 09:54:11','2022-12-07 09:54:11',NULL),(377,8087,40720,1598,3,377,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',972864.47,'S/libro IVA compras septiembre/21',NULL,1,'2022-12-07 09:57:43','2022-12-07 09:57:43',NULL),(378,8087,40720,1598,2,378,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',695322.20,'S/IVA ventas septiembre/21',NULL,1,'2022-12-07 09:59:08','2022-12-07 09:59:08',NULL),(379,8087,40720,1598,5,379,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',355267.14,'S/movimientos bancarios del mes',NULL,1,'2022-12-07 10:01:33','2022-12-07 10:01:33',NULL),(380,8087,40720,1599,21,380,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',112465.00,'Pago sueldos septiembre/21',NULL,1,'2022-12-07 10:08:05','2022-12-07 10:08:05',NULL),(381,8087,40720,1599,10,381,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',32475.71,'Pago Cgs soc y sindicales 09/2021',NULL,1,'2022-12-07 10:19:10','2022-12-07 10:19:10',NULL),(382,8087,40720,1599,19,382,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',20000.00,'Por retiro de socios',NULL,1,'2022-12-07 10:20:55','2022-12-07 10:20:55',NULL),(383,8087,40720,1599,15,383,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',156608.69,'P/contabilizar IVA ddjj del mes de sept/21',NULL,1,'2022-12-08 08:05:34','2022-12-08 08:05:34',NULL),(384,8087,40720,1599,10,384,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',28729.67,'S/Pago de IIBB de sept/21',NULL,1,'2022-12-08 08:09:58','2022-12-08 08:09:58',NULL),(385,8087,40720,1599,21,385,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',250000.00,'Por pagos parciales a proveedores',NULL,1,'2022-12-08 08:11:57','2022-12-08 08:11:57',NULL),(386,8087,40720,1599,1,386,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',144940.71,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-12-08 08:14:09','2022-12-08 08:14:09',NULL);
INSERT INTO `balance_libro` VALUES (387,8087,40720,1599,21,387,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',250000.00,'Por pagos parciales a proveedores',NULL,1,'2022-12-08 08:15:06','2022-12-08 08:15:06',NULL),(388,8087,40720,1599,3,388,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1063332.74,'S/libro IVA compras octubre/21',NULL,1,'2022-12-08 08:18:26','2022-12-08 08:18:26',NULL),(389,8087,40720,1599,2,389,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',959263.09,'S/IVA ventas octubre/21',NULL,1,'2022-12-08 08:19:58','2022-12-08 08:19:58',NULL),(390,8087,40720,1599,5,390,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',356683.60,'S/movimientos bancarios del mes',NULL,1,'2022-12-08 08:30:00','2022-12-08 08:30:00',NULL),(391,8087,40720,1600,10,391,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',32475.71,'Pago Cgs soc y sindicales 10/2021',NULL,1,'2022-12-08 08:36:34','2022-12-08 08:36:34',NULL),(392,8087,40720,1600,21,392,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',112465.00,'Pago sueldos octubre/21',NULL,1,'2022-12-08 08:47:41','2022-12-08 08:47:41',NULL),(393,8087,40720,1600,19,393,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',30000.00,'Por retiro de socios',NULL,1,'2022-12-08 08:49:08','2022-12-08 08:49:08',NULL),(394,8087,40720,1600,21,394,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',180000.00,'Por pagos parciales a proveedores',NULL,1,'2022-12-08 08:51:53','2022-12-08 08:51:53',NULL),(395,8087,40720,1600,15,395,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',177597.45,'P/contabilizar IVA ddjj del mes de octubre/21',NULL,1,'2022-12-08 09:01:10','2022-12-08 09:01:10',NULL),(396,8087,40720,1600,10,396,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',40567.56,'S/Pago de IIBB de octubre/21',NULL,1,'2022-12-08 09:09:49','2022-12-08 09:09:49',NULL),(397,8087,40720,1600,1,397,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',155080.71,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-12-08 09:15:24','2022-12-08 09:15:24',NULL),(398,8087,40720,1600,3,398,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1702989.16,'S/libro IVA compras noviembre/21',NULL,1,'2022-12-08 09:19:26','2022-12-08 09:19:26',NULL),(399,8087,40720,1600,2,399,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',976887.10,'S/IVA ventas noviembre/21',NULL,1,'2022-12-08 09:20:38','2022-12-08 09:20:38',NULL),(400,8087,40720,1600,5,400,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',664815.12,'S/movimientos bancarios del mes',NULL,1,'2022-12-08 10:16:57','2022-12-08 10:16:57',NULL),(401,8087,40720,1600,21,401,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',190000.00,'Por pagos parciales a proveedores',NULL,1,'2022-12-08 10:18:04','2022-12-08 10:18:04',NULL),(402,8087,40720,1601,21,402,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',122465.00,'Pago sueldos noviembre/21',NULL,1,'2022-12-08 11:03:00','2022-12-08 11:03:00',NULL),(403,8087,40720,1601,10,403,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',32615.71,'Pago Cgs soc y sindicales 11/2021',NULL,1,'2022-12-08 12:10:01','2022-12-08 12:10:01',NULL);
INSERT INTO `balance_libro` VALUES (404,8087,40720,1601,21,404,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',143145.00,'Pago sueldo Rosa 01/22/sac Rosa Rios dic/21',NULL,1,'2022-12-08 12:25:15','2022-12-08 12:25:15',NULL),(405,8087,40720,1601,15,405,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',282426.58,'P/contabilizar IVA ddjj del mes de noviembre/21',NULL,1,'2022-12-08 12:57:36','2022-12-08 12:57:36',NULL),(406,8087,40720,1601,21,406,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',192000.00,'Por pagos parciales a proveedores',NULL,1,'2022-12-08 14:31:49','2022-12-08 14:31:49',NULL),(407,8087,40720,1601,21,407,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',190000.00,'Por pagos parciales a proveedores',NULL,1,'2022-12-08 14:34:03','2022-12-08 14:34:03',NULL),(408,8087,40720,1601,16,408,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',54821.71,'P/contabilizar IIBB ddjj del mes de noviembre/21',NULL,1,'2022-12-08 14:38:07','2022-12-08 14:38:07',NULL),(409,8087,40720,1601,15,409,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',196106.44,'P/contabilizar IVA ddjj del mes de diciembre/21',NULL,1,'2022-12-08 14:48:32','2022-12-08 14:48:32',NULL),(410,8087,40720,1601,16,410,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',55941.29,'P/contabilizar IIBB ddjj del mes de diciembre/21',NULL,1,'2022-12-08 14:52:22','2022-12-08 14:52:22',NULL),(411,8087,40720,1601,1,411,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',245786.77,'P/devengar sueldos y Cgs Soc del mes',NULL,1,'2022-12-08 14:54:04','2022-12-08 14:54:04',NULL),(412,8087,40720,1601,3,412,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1073694.83,'S/libro IVA compras diciembre/21',NULL,1,'2022-12-08 15:13:17','2022-12-08 15:13:17',NULL),(413,8087,40720,1601,2,413,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1129946.61,'S/IVA ventas diciembre/21',NULL,1,'2022-12-08 15:16:15','2022-12-08 15:16:15',NULL),(414,8087,40720,1601,5,414,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',656679.44,'S/movimientos bancarios del mes',NULL,1,'2022-12-08 15:18:23','2022-12-08 15:18:23',NULL),(415,8087,40720,1601,4,415,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',15533.64,'Contabiliza amort. del ejercicio',NULL,1,'2022-12-08 15:20:55','2023-03-06 14:14:31','2023-03-06 14:14:31'),(416,8087,40720,1601,19,416,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',410.40,'Por ajuste de saldos de cuentas por redondeo',NULL,1,'2022-12-08 15:21:59','2022-12-09 08:57:06','2022-12-09 08:57:06'),(417,8087,40720,1601,19,417,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',5110634.71,'P/contabilizar el costo de las ventas del ejercicio',NULL,1,'2022-12-08 15:23:35','2023-03-10 19:05:54','2023-03-10 19:05:54'),(418,8087,40720,1601,23,418,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',3195563.99,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-12-08 17:07:14','2022-12-09 08:48:43','2022-12-09 08:48:43'),(419,8087,40720,1601,19,419,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',410.40,'Por ajuste de saldos de cuentas por redondeo',NULL,1,'2022-12-09 08:57:06','2022-12-09 08:57:06',NULL),(420,8087,40720,1601,23,420,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',3194859.75,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-12-09 09:13:10','2023-03-06 14:55:37','2023-03-06 14:55:37');
INSERT INTO `balance_libro` VALUES (421,8087,40720,1560,12,421,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-01','2019-01-01',3156040.06,NULL,NULL,1,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(422,8087,40720,1571,23,422,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-31','2019-12-31',2475923.69,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-01-02 15:49:35','2023-01-02 16:33:04','2023-01-02 16:33:04'),(423,8087,40720,1571,19,423,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-31','2019-12-31',4299713.85,'P/contabilizar el costo de las ventas del ejercicio',NULL,1,'2023-01-02 16:27:17','2023-01-02 17:16:19','2023-01-02 17:16:19'),(424,8087,40720,1571,19,424,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-31','2019-12-31',4076352.09,'P/contabilizar el costo de las ventas del ejercicio',NULL,1,'2023-01-02 17:16:19','2023-01-02 17:16:19',NULL),(425,8087,40720,1571,23,425,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-31','2019-12-31',2475923.69,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-01-02 17:27:11','2023-01-31 16:16:53','2023-01-31 16:16:53'),(426,8087,40720,1575,12,426,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-01','2020-01-01',5585883.56,'P/saldos iniciales',NULL,1,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(427,8087,40720,1586,4,427,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',22049.16,'Contabiliza amort. del ejercicio',NULL,1,'2023-01-06 15:54:29','2023-03-01 14:50:58','2023-03-01 14:50:58'),(428,8087,40720,1586,23,428,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2224046.21,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-01-06 16:13:37','2023-03-01 15:03:42','2023-03-01 15:03:42'),(429,8087,40720,1571,23,429,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-31','2019-12-31',2475923.69,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(430,8087,40720,1586,19,430,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',4591089.66,'P/contabilizar el costo de las ventas del ejercicio',NULL,1,'2023-03-01 14:49:10','2023-03-01 14:49:10',NULL),(431,8087,40720,1586,4,431,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',23062.42,'Contabiliza amort. del ejercicio',NULL,1,'2023-03-01 14:50:58','2023-03-01 14:50:58',NULL),(432,8087,40720,1586,23,432,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2224046.21,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(433,8087,40720,1590,12,433,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',7694518.15,'Saldos iniciales',NULL,1,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(434,8087,40720,1601,4,434,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',30705.55,'Contabiliza amort. del ejercicio',NULL,1,'2023-03-06 14:14:31','2023-03-06 14:14:31',NULL),(435,8087,40720,1601,23,435,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',4519775.99,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-03-06 15:20:24','2023-03-10 19:36:24','2023-03-10 19:36:24'),(436,8087,40720,1601,19,436,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',7331212.55,'P/contabilizar el costo de las ventas del ejercicio',NULL,1,'2023-03-10 19:05:54','2023-03-10 19:05:54',NULL),(437,8087,40720,1601,23,437,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',4519775.99,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL);
INSERT INTO `balance_libro` VALUES (438,8087,40720,1623,1,438,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-04-30',NULL,190000.00,NULL,NULL,1,'2023-08-16 08:18:48','2023-08-16 08:18:48',NULL),(439,8087,40720,1624,1,439,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-05-31',NULL,192976.36,NULL,NULL,1,'2023-08-16 08:19:03','2023-08-16 08:19:03',NULL),(440,8087,40720,1625,1,440,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-06-30',NULL,289331.37,NULL,NULL,1,'2023-08-16 08:19:12','2023-08-16 08:19:12',NULL),(441,8087,40720,1626,1,441,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-07-31',NULL,253856.36,NULL,NULL,1,'2023-10-31 12:17:40','2023-10-31 12:17:40',NULL),(442,8087,40720,1627,1,442,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-08-31',NULL,283879.36,NULL,NULL,1,'2023-10-31 12:17:49','2023-10-31 12:17:49',NULL),(443,8087,40720,1628,1,443,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-09-30',NULL,283901.36,NULL,NULL,1,'2023-10-31 12:17:57','2023-10-31 12:17:57',NULL),(444,8087,40720,1629,1,444,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-10-31',NULL,304620.36,NULL,NULL,1,'2023-11-29 13:16:32','2023-11-29 13:16:32',NULL),(445,8087,40720,1630,1,445,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-11-30',NULL,355352.36,NULL,NULL,1,'2024-01-04 14:36:35','2024-01-04 14:36:35',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2578 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,8087,1,40720,1614,1,110,1,150000.00,NULL,'2022-11-11 10:40:55','2022-11-11 10:55:21','2022-11-11 10:55:21'),(2,8087,1,40720,1614,1,111,1,2292.21,NULL,'2022-11-11 10:40:55','2022-11-11 10:55:21','2022-11-11 10:55:21'),(3,8087,1,40720,1614,1,112,1,0.00,NULL,'2022-11-11 10:40:55','2022-11-11 10:55:21','2022-11-11 10:55:21'),(4,8087,1,40720,1614,1,62,2,150000.00,NULL,'2022-11-11 10:40:55','2022-11-11 10:55:21','2022-11-11 10:55:21'),(5,8087,1,40720,1614,1,63,2,2292.21,NULL,'2022-11-11 10:40:55','2022-11-11 10:55:21','2022-11-11 10:55:21'),(6,8087,1,40720,1614,1,64,2,0.00,NULL,'2022-11-11 10:40:55','2022-11-11 10:55:21','2022-11-11 10:55:21'),(7,8087,1,40720,1614,1,63,1,0.00,NULL,'2022-11-11 10:40:56','2022-11-11 10:55:21','2022-11-11 10:55:21'),(8,8087,1,40720,1614,1,162,2,0.00,NULL,'2022-11-11 10:40:56','2022-11-11 10:55:21','2022-11-11 10:55:21'),(9,8087,2,40720,1614,1,110,1,150000.00,NULL,'2022-11-11 11:08:20','2022-11-11 11:40:23','2022-11-11 11:40:23'),(10,8087,2,40720,1614,1,111,1,2292.21,NULL,'2022-11-11 11:08:20','2022-11-11 11:40:23','2022-11-11 11:40:23'),(11,8087,2,40720,1614,1,112,1,0.00,NULL,'2022-11-11 11:08:20','2022-11-11 11:40:23','2022-11-11 11:40:23'),(12,8087,2,40720,1614,1,62,2,150000.00,NULL,'2022-11-11 11:08:20','2022-11-11 11:40:23','2022-11-11 11:40:23'),(13,8087,2,40720,1614,1,63,2,2292.21,NULL,'2022-11-11 11:08:20','2022-11-11 11:40:23','2022-11-11 11:40:23'),(14,8087,2,40720,1614,1,64,2,0.00,NULL,'2022-11-11 11:08:20','2022-11-11 11:40:23','2022-11-11 11:40:23'),(15,8087,2,40720,1614,1,63,1,0.00,NULL,'2022-11-11 11:08:20','2022-11-11 11:40:23','2022-11-11 11:40:23'),(16,8087,2,40720,1614,1,162,2,0.00,NULL,'2022-11-11 11:08:20','2022-11-11 11:40:23','2022-11-11 11:40:23'),(17,8087,3,40720,1614,1,110,1,150000.00,NULL,'2022-11-11 12:09:34','2022-11-11 12:28:42','2022-11-11 12:28:42'),(18,8087,3,40720,1614,1,111,1,2292.21,NULL,'2022-11-11 12:09:34','2022-11-11 12:28:42','2022-11-11 12:28:42'),(19,8087,3,40720,1614,1,112,1,0.00,NULL,'2022-11-11 12:09:34','2022-11-11 12:28:42','2022-11-11 12:28:42'),(20,8087,3,40720,1614,1,62,2,150000.00,NULL,'2022-11-11 12:09:34','2022-11-11 12:28:42','2022-11-11 12:28:42'),(21,8087,3,40720,1614,1,63,2,2292.21,NULL,'2022-11-11 12:09:34','2022-11-11 12:28:42','2022-11-11 12:28:42'),(22,8087,3,40720,1614,1,64,2,0.00,NULL,'2022-11-11 12:09:34','2022-11-11 12:28:42','2022-11-11 12:28:42'),(23,8087,3,40720,1614,1,63,1,0.00,NULL,'2022-11-11 12:09:34','2022-11-11 12:28:42','2022-11-11 12:28:42'),(24,8087,3,40720,1614,1,162,2,0.00,NULL,'2022-11-11 12:09:34','2022-11-11 12:28:42','2022-11-11 12:28:42'),(25,8087,4,40720,1614,1,110,1,150000.00,NULL,'2022-11-11 12:31:55','2022-11-11 12:31:55',NULL),(26,8087,4,40720,1614,1,111,1,2292.21,NULL,'2022-11-11 12:31:55','2022-11-11 12:31:55',NULL),(27,8087,4,40720,1614,1,112,1,0.00,NULL,'2022-11-11 12:31:55','2022-11-11 12:31:55',NULL),(28,8087,4,40720,1614,1,62,2,150000.00,NULL,'2022-11-11 12:31:55','2022-11-11 12:31:55',NULL),(29,8087,4,40720,1614,1,63,2,2292.21,NULL,'2022-11-11 12:31:55','2022-11-11 12:31:55',NULL),(30,8087,4,40720,1614,1,64,2,0.00,NULL,'2022-11-11 12:31:55','2022-11-11 12:31:55',NULL),(31,8087,4,40720,1614,1,63,1,0.00,NULL,'2022-11-11 12:31:55','2022-11-11 12:31:55',NULL),(32,8087,4,40720,1614,1,162,2,0.00,NULL,'2022-11-11 12:31:55','2022-11-11 12:31:55',NULL),(33,8087,5,40720,1605,12,359,1,1333050.14,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(34,8087,5,40720,1605,12,474,1,229862.76,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(35,8087,5,40720,1605,12,68,1,3161.32,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(36,8087,5,40720,1605,12,20,1,68366.29,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(37,8087,5,40720,1605,12,23,1,14301.15,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(38,8087,5,40720,1605,12,251,1,10869.32,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04');
INSERT INTO `balance_libro_details` VALUES (39,8087,5,40720,1605,12,252,1,1134.39,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(40,8087,5,40720,1605,12,482,1,636000.00,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(41,8087,5,40720,1605,12,483,1,225000.00,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(42,8087,5,40720,1605,12,392,1,360000.00,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(43,8087,5,40720,1605,12,363,1,101326.50,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(44,8087,5,40720,1605,12,57,2,1195050.63,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(45,8087,5,40720,1605,12,74,2,45000.50,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(46,8087,5,40720,1605,12,327,2,9275.72,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(47,8087,5,40720,1605,12,326,2,665.00,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(48,8087,5,40720,1605,12,63,2,29019.73,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(49,8087,5,40720,1605,12,64,2,2000.00,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(50,8087,5,40720,1605,12,486,2,925000.00,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(51,8087,5,40720,1605,12,487,2,17089.86,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(52,8087,5,40720,1605,12,72,2,91.02,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(53,8087,5,40720,1605,12,383,2,689348.55,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(54,8087,5,40720,1605,12,381,2,10530.86,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(55,8087,5,40720,1605,12,369,2,60000.00,NULL,'2022-11-12 19:38:31','2022-11-12 19:50:04','2022-11-12 19:50:04'),(56,8087,6,40720,1560,19,482,1,14000.00,NULL,'2022-11-12 19:45:27','2022-11-12 19:45:27',NULL),(57,8087,6,40720,1560,19,483,1,20000.00,NULL,'2022-11-12 19:45:27','2022-11-12 19:45:27',NULL),(58,8087,6,40720,1560,19,474,2,34000.00,NULL,'2022-11-12 19:45:27','2022-11-12 19:45:27',NULL),(59,8087,7,40720,1560,10,63,1,29019.73,NULL,'2022-11-12 19:49:22','2022-11-12 19:49:22',NULL),(60,8087,7,40720,1560,10,64,1,2000.00,NULL,'2022-11-12 19:49:22','2022-11-12 19:49:22',NULL),(61,8087,7,40720,1560,10,474,2,29019.73,NULL,'2022-11-12 19:49:22','2022-11-12 19:49:22',NULL),(62,8087,7,40720,1560,10,359,2,2000.00,NULL,'2022-11-12 19:49:22','2022-11-12 19:49:22',NULL),(63,8087,8,40720,1560,12,359,1,1333050.14,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(64,8087,8,40720,1560,12,474,1,229862.76,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(65,8087,8,40720,1560,12,68,1,3161.32,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(66,8087,8,40720,1560,12,20,1,68366.29,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(67,8087,8,40720,1560,12,23,1,14301.15,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(68,8087,8,40720,1560,12,251,1,10869.32,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(69,8087,8,40720,1560,12,252,1,1134.39,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(70,8087,8,40720,1560,12,482,1,636000.00,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(71,8087,8,40720,1560,12,483,1,225000.00,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(72,8087,8,40720,1560,12,392,1,360000.00,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(73,8087,8,40720,1560,12,363,1,101326.50,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(74,8087,8,40720,1560,12,57,2,1195050.63,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20');
INSERT INTO `balance_libro_details` VALUES (75,8087,8,40720,1560,12,74,2,45000.50,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(76,8087,8,40720,1560,12,327,2,9275.72,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(77,8087,8,40720,1560,12,326,2,665.00,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(78,8087,8,40720,1560,12,63,2,29019.73,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(79,8087,8,40720,1560,12,64,2,2000.00,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(80,8087,8,40720,1560,12,486,2,925000.00,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(81,8087,8,40720,1560,12,487,2,17089.86,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(82,8087,8,40720,1560,12,72,2,91.02,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(83,8087,8,40720,1560,12,383,2,689348.55,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(84,8087,8,40720,1560,12,381,2,10530.86,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(85,8087,8,40720,1560,12,369,2,60000.00,NULL,'2022-11-12 19:50:04','2023-01-02 11:10:20','2023-01-02 11:10:20'),(86,8087,9,40720,1560,10,487,1,5696.62,NULL,'2022-11-12 20:22:05','2022-11-14 17:13:10','2022-11-14 17:13:10'),(87,8087,9,40720,1560,10,467,1,5.69,NULL,'2022-11-12 20:22:05','2022-11-14 17:13:10','2022-11-14 17:13:10'),(88,8087,9,40720,1560,10,474,2,5702.31,NULL,'2022-11-12 20:22:05','2022-11-14 17:13:10','2022-11-14 17:13:10'),(89,8087,10,40720,1560,10,74,1,45000.50,NULL,'2022-11-12 20:23:40','2022-11-12 20:23:40',NULL),(90,8087,10,40720,1560,10,474,2,45000.50,NULL,'2022-11-12 20:23:40','2022-11-12 20:23:40',NULL),(91,8087,11,40720,1560,10,327,1,9275.72,NULL,'2022-11-12 20:26:19','2022-11-12 20:26:19',NULL),(92,8087,11,40720,1560,10,326,1,665.00,NULL,'2022-11-12 20:26:19','2022-11-12 20:26:19',NULL),(93,8087,11,40720,1560,10,474,2,9940.72,NULL,'2022-11-12 20:26:19','2022-11-12 20:26:19',NULL),(94,8087,12,40720,1560,2,359,1,813526.59,NULL,'2022-11-12 20:31:18','2022-11-14 16:58:44','2022-11-14 16:58:44'),(95,8087,12,40720,1560,2,252,1,5564.73,NULL,'2022-11-12 20:31:18','2022-11-14 16:58:44','2022-11-14 16:58:44'),(96,8087,12,40720,1560,2,23,1,861.79,NULL,'2022-11-12 20:31:18','2022-11-14 16:58:44','2022-11-14 16:58:44'),(97,8087,12,40720,1560,2,67,2,142305.91,NULL,'2022-11-12 20:31:18','2022-11-14 16:58:44','2022-11-14 16:58:44'),(98,8087,12,40720,1560,2,96,2,677647.20,NULL,'2022-11-12 20:31:18','2022-11-14 16:58:44','2022-11-14 16:58:44'),(99,8087,13,40720,1560,3,392,1,327397.01,NULL,'2022-11-12 20:37:23','2022-11-12 20:37:23',NULL),(100,8087,13,40720,1560,3,68,1,75013.56,NULL,'2022-11-12 20:37:23','2022-11-12 20:37:23',NULL),(101,8087,13,40720,1560,3,25,1,2054.97,NULL,'2022-11-12 20:37:23','2022-11-12 20:37:23',NULL),(102,8087,13,40720,1560,3,23,1,104.70,NULL,'2022-11-12 20:37:23','2022-11-12 20:37:23',NULL),(103,8087,13,40720,1560,3,251,1,580.27,NULL,'2022-11-12 20:37:23','2022-11-12 20:37:23',NULL),(104,8087,13,40720,1560,3,252,1,2134.77,NULL,'2022-11-12 20:37:23','2022-11-12 20:37:23',NULL),(105,8087,13,40720,1560,3,193,1,1490.96,NULL,'2022-11-12 20:37:23','2022-11-12 20:37:23',NULL),(106,8087,13,40720,1560,3,484,1,1429.47,NULL,'2022-11-12 20:37:23','2022-11-12 20:37:23',NULL),(107,8087,13,40720,1560,3,135,1,3552.50,NULL,'2022-11-12 20:37:23','2022-11-12 20:37:23',NULL),(108,8087,13,40720,1560,3,128,1,6653.94,NULL,'2022-11-12 20:37:23','2022-11-12 20:37:23',NULL),(109,8087,13,40720,1560,3,485,1,986.41,NULL,'2022-11-12 20:37:23','2022-11-12 20:37:23',NULL),(110,8087,13,40720,1560,3,363,1,24793.39,NULL,'2022-11-12 20:37:23','2022-11-12 20:37:23',NULL),(111,8087,13,40720,1560,3,359,2,446191.95,NULL,'2022-11-12 20:37:23','2022-11-12 20:37:23',NULL),(112,8087,14,40720,1560,1,110,1,59015.34,NULL,'2022-11-12 20:44:39','2022-11-12 20:44:39',NULL);
INSERT INTO `balance_libro_details` VALUES (113,8087,14,40720,1560,1,191,1,14320.91,NULL,'2022-11-12 20:44:39','2022-11-12 20:44:39',NULL),(114,8087,14,40720,1560,1,63,2,22582.25,NULL,'2022-11-12 20:44:39','2022-11-12 20:44:39',NULL),(115,8087,14,40720,1560,1,359,2,48754.00,NULL,'2022-11-12 20:44:39','2022-11-12 20:44:39',NULL),(116,8087,14,40720,1560,1,64,2,2000.00,NULL,'2022-11-12 20:44:39','2022-11-12 20:44:39',NULL),(117,8087,15,40720,1560,5,157,1,4146.79,NULL,'2022-11-13 09:55:28','2022-11-13 09:55:28',NULL),(118,8087,15,40720,1560,5,396,1,141936.46,NULL,'2022-11-13 09:55:28','2022-11-13 09:55:28',NULL),(119,8087,15,40720,1560,5,252,1,24.90,NULL,'2022-11-13 09:55:28','2022-11-13 09:55:28',NULL),(120,8087,15,40720,1560,5,214,1,7025.97,NULL,'2022-11-13 09:55:28','2022-11-13 09:55:28',NULL),(121,8087,15,40720,1560,5,474,1,395838.83,NULL,'2022-11-13 09:55:28','2022-11-13 09:55:28',NULL),(122,8087,15,40720,1560,5,359,1,133827.10,NULL,'2022-11-13 09:55:28','2022-11-13 09:55:28',NULL),(123,8087,15,40720,1560,5,474,2,286961.22,NULL,'2022-11-13 09:55:28','2022-11-13 09:55:28',NULL),(124,8087,15,40720,1560,5,359,2,395838.83,NULL,'2022-11-13 09:55:28','2022-11-13 09:55:28',NULL),(125,8087,16,40720,1561,10,63,1,22582.25,NULL,'2022-11-13 09:59:56','2022-11-13 09:59:56',NULL),(126,8087,16,40720,1561,10,64,1,2000.00,NULL,'2022-11-13 09:59:56','2022-11-13 09:59:56',NULL),(127,8087,16,40720,1561,10,474,2,22582.25,NULL,'2022-11-13 09:59:56','2022-11-13 09:59:56',NULL),(128,8087,16,40720,1561,10,359,2,2000.00,NULL,'2022-11-13 09:59:56','2022-11-13 09:59:56',NULL),(129,8087,17,40720,1561,19,482,1,14000.00,NULL,'2022-11-13 10:02:33','2022-11-13 10:02:33',NULL),(130,8087,17,40720,1561,19,483,1,20000.00,NULL,'2022-11-13 10:02:33','2022-11-13 10:02:33',NULL),(131,8087,17,40720,1561,19,474,2,34000.00,NULL,'2022-11-13 10:02:33','2022-11-13 10:02:33',NULL),(132,8087,18,40720,1561,10,487,1,5696.62,NULL,'2022-11-13 10:04:05','2022-11-13 10:04:05',NULL),(133,8087,18,40720,1561,10,474,2,5696.62,NULL,'2022-11-13 10:04:05','2022-11-13 10:04:05',NULL),(134,8087,19,40720,1561,15,67,1,142305.91,NULL,'2022-11-13 10:17:01','2022-11-14 17:25:54','2022-11-14 17:25:54'),(135,8087,19,40720,1561,15,71,2,2054.97,NULL,'2022-11-13 10:17:01','2022-11-14 17:25:54','2022-11-14 17:25:54'),(136,8087,19,40720,1561,15,68,2,75013.56,NULL,'2022-11-13 10:17:01','2022-11-14 17:25:54','2022-11-14 17:25:54'),(137,8087,19,40720,1561,15,74,2,65237.38,NULL,'2022-11-13 10:17:01','2022-11-14 17:25:54','2022-11-14 17:25:54'),(138,8087,20,40720,1561,10,156,1,21297.18,NULL,'2022-11-13 11:11:02','2022-11-13 11:11:02',NULL),(139,8087,20,40720,1561,10,251,2,471.10,NULL,'2022-11-13 11:11:02','2022-11-13 11:11:02',NULL),(140,8087,20,40720,1561,10,252,2,2111.22,NULL,'2022-11-13 11:11:02','2022-11-13 11:11:02',NULL),(141,8087,20,40720,1561,10,489,2,5564.73,NULL,'2022-11-13 11:11:02','2022-11-13 11:11:02',NULL),(142,8087,20,40720,1561,10,474,2,13150.13,NULL,'2022-11-13 11:11:02','2022-11-13 11:11:02',NULL),(143,8087,21,40720,1561,10,74,1,65237.38,NULL,'2022-11-13 11:33:12','2022-11-13 11:33:12',NULL),(144,8087,21,40720,1561,10,474,2,65237.38,NULL,'2022-11-13 11:33:12','2022-11-13 11:33:12',NULL),(145,8087,22,40720,1561,21,57,1,200000.00,NULL,'2022-11-13 11:34:59','2022-11-13 11:34:59',NULL),(146,8087,22,40720,1561,21,359,2,200000.00,NULL,'2022-11-13 11:34:59','2022-11-13 11:34:59',NULL),(147,8087,23,40720,1561,3,392,1,378272.33,NULL,'2022-11-13 11:46:54','2022-11-13 11:46:54',NULL),(148,8087,23,40720,1561,3,68,1,85070.02,NULL,'2022-11-13 11:46:54','2022-11-13 11:46:54',NULL),(149,8087,23,40720,1561,3,72,1,54.80,NULL,'2022-11-13 11:46:54','2022-11-13 11:46:54',NULL),(150,8087,23,40720,1561,3,25,1,1741.70,NULL,'2022-11-13 11:46:54','2022-11-13 11:46:54',NULL),(151,8087,23,40720,1561,3,252,1,1389.25,NULL,'2022-11-13 11:46:54','2022-11-13 11:46:54',NULL),(152,8087,23,40720,1561,3,484,1,2724.67,NULL,'2022-11-13 11:46:54','2022-11-13 11:46:54',NULL),(153,8087,23,40720,1561,3,193,1,1266.05,NULL,'2022-11-13 11:46:54','2022-11-13 11:46:54',NULL);
INSERT INTO `balance_libro_details` VALUES (154,8087,23,40720,1561,3,135,1,1613.72,NULL,'2022-11-13 11:46:54','2022-11-13 11:46:54',NULL),(155,8087,23,40720,1561,3,128,1,5160.82,NULL,'2022-11-13 11:46:54','2022-11-13 11:46:54',NULL),(156,8087,23,40720,1561,3,363,1,29216.53,NULL,'2022-11-13 11:46:54','2022-11-13 11:46:54',NULL),(157,8087,23,40720,1561,3,251,1,6.79,NULL,'2022-11-13 11:46:54','2022-11-13 11:46:54',NULL),(158,8087,23,40720,1561,3,359,2,506516.68,NULL,'2022-11-13 11:46:54','2022-11-13 11:46:54',NULL),(159,8087,24,40720,1561,2,359,1,707739.56,NULL,'2022-11-13 11:49:15','2022-11-13 11:49:15',NULL),(160,8087,24,40720,1561,2,67,2,122830.83,NULL,'2022-11-13 11:49:15','2022-11-13 11:49:15',NULL),(161,8087,24,40720,1561,2,96,2,584908.73,NULL,'2022-11-13 11:49:15','2022-11-13 11:49:15',NULL),(162,8087,25,40720,1561,1,110,1,58957.92,NULL,'2022-11-13 11:58:50','2022-11-13 11:58:50',NULL),(163,8087,25,40720,1561,1,191,1,14956.01,NULL,'2022-11-13 11:58:50','2022-11-13 11:58:50',NULL),(164,8087,25,40720,1561,1,63,2,24157.93,NULL,'2022-11-13 11:58:50','2022-11-13 11:58:50',NULL),(165,8087,25,40720,1561,1,359,2,47756.00,NULL,'2022-11-13 11:58:50','2022-11-13 11:58:50',NULL),(166,8087,25,40720,1561,1,64,2,2000.00,NULL,'2022-11-13 11:58:50','2022-11-13 11:58:50',NULL),(167,8087,26,40720,1561,5,157,1,2559.05,NULL,'2022-11-13 12:05:45','2022-11-13 12:05:45',NULL),(168,8087,26,40720,1561,5,396,1,123244.55,NULL,'2022-11-13 12:05:45','2022-11-13 12:05:45',NULL),(169,8087,26,40720,1561,5,252,1,24.90,NULL,'2022-11-13 12:05:45','2022-11-13 12:05:45',NULL),(170,8087,26,40720,1561,5,214,1,4686.12,NULL,'2022-11-13 12:05:45','2022-11-13 12:05:45',NULL),(171,8087,26,40720,1561,5,474,1,192392.25,NULL,'2022-11-13 12:05:45','2022-11-13 12:05:45',NULL),(172,8087,26,40720,1561,5,359,1,39938.20,NULL,'2022-11-13 12:05:45','2022-11-13 12:05:45',NULL),(173,8087,26,40720,1561,5,474,2,170452.82,NULL,'2022-11-13 12:05:45','2022-11-13 12:05:45',NULL),(174,8087,26,40720,1561,5,359,2,192392.25,NULL,'2022-11-13 12:05:45','2022-11-13 12:05:45',NULL),(175,8087,27,40720,1562,19,482,1,12000.00,NULL,'2022-11-13 12:10:37','2022-11-13 12:10:37',NULL),(176,8087,27,40720,1562,19,474,2,12000.00,NULL,'2022-11-13 12:10:37','2022-11-13 12:10:37',NULL),(177,8087,28,40720,1562,10,487,1,5696.62,NULL,'2022-11-13 12:13:40','2022-11-13 12:13:40',NULL),(178,8087,28,40720,1562,10,474,2,5696.62,NULL,'2022-11-13 12:13:40','2022-11-13 12:13:40',NULL),(179,8087,29,40720,1562,10,63,1,24157.93,NULL,'2022-11-13 12:16:58','2022-11-13 12:16:58',NULL),(180,8087,29,40720,1562,10,64,1,2000.00,NULL,'2022-11-13 12:16:58','2022-11-13 12:16:58',NULL),(181,8087,29,40720,1562,10,474,2,24157.93,NULL,'2022-11-13 12:16:58','2022-11-13 12:16:58',NULL),(182,8087,29,40720,1562,10,359,2,2000.00,NULL,'2022-11-13 12:16:58','2022-11-13 12:16:58',NULL),(183,8087,30,40720,1562,19,483,1,30000.00,NULL,'2022-11-13 12:18:07','2022-11-13 12:18:07',NULL),(184,8087,30,40720,1562,19,474,2,30000.00,NULL,'2022-11-13 12:18:07','2022-11-13 12:18:07',NULL),(185,8087,31,40720,1562,15,67,1,122830.83,NULL,'2022-11-13 12:22:15','2022-11-13 12:26:55','2022-11-13 12:26:55'),(186,8087,31,40720,1562,15,71,2,1741.70,NULL,'2022-11-13 12:22:15','2022-11-13 12:26:55','2022-11-13 12:26:55'),(187,8087,31,40720,1562,15,72,2,54.80,NULL,'2022-11-13 12:22:15','2022-11-13 12:26:55','2022-11-13 12:26:55'),(188,8087,31,40720,1562,15,68,2,85070.02,NULL,'2022-11-13 12:22:15','2022-11-13 12:26:55','2022-11-13 12:26:55'),(189,8087,31,40720,1562,15,474,2,35964.31,NULL,'2022-11-13 12:22:15','2022-11-13 12:26:55','2022-11-13 12:26:55'),(190,8087,32,40720,1562,15,67,1,122830.83,NULL,'2022-11-13 12:26:55','2022-11-14 17:27:45','2022-11-14 17:27:45'),(191,8087,32,40720,1562,15,71,2,1741.70,NULL,'2022-11-13 12:26:55','2022-11-14 17:27:45','2022-11-14 17:27:45'),(192,8087,32,40720,1562,15,72,2,54.80,NULL,'2022-11-13 12:26:55','2022-11-14 17:27:45','2022-11-14 17:27:45'),(193,8087,32,40720,1562,15,68,2,85070.02,NULL,'2022-11-13 12:26:55','2022-11-14 17:27:45','2022-11-14 17:27:45');
INSERT INTO `balance_libro_details` VALUES (194,8087,32,40720,1562,15,474,2,35964.31,NULL,'2022-11-13 12:26:55','2022-11-14 17:27:45','2022-11-14 17:27:45'),(195,8087,33,40720,1562,10,156,1,18991.31,NULL,'2022-11-13 12:32:31','2022-11-13 12:32:31',NULL),(196,8087,33,40720,1562,10,251,2,6.79,NULL,'2022-11-13 12:32:31','2022-11-13 12:32:31',NULL),(197,8087,33,40720,1562,10,252,2,1389.25,NULL,'2022-11-13 12:32:31','2022-11-13 12:32:31',NULL),(198,8087,33,40720,1562,10,474,2,17595.27,NULL,'2022-11-13 12:32:31','2022-11-13 12:32:31',NULL),(199,8087,34,40720,1562,3,392,1,388874.35,NULL,'2022-11-13 15:23:50','2022-11-13 15:23:50',NULL),(200,8087,34,40720,1562,3,68,1,82319.36,NULL,'2022-11-13 15:23:50','2022-11-13 15:23:50',NULL),(201,8087,34,40720,1562,3,72,1,892.54,NULL,'2022-11-13 15:23:50','2022-11-13 15:23:50',NULL),(202,8087,34,40720,1562,3,251,1,5.75,NULL,'2022-11-13 15:23:50','2022-11-13 15:23:50',NULL),(203,8087,34,40720,1562,3,252,1,1484.30,NULL,'2022-11-13 15:23:50','2022-11-13 15:23:50',NULL),(204,8087,34,40720,1562,3,193,1,1789.25,NULL,'2022-11-13 15:23:50','2022-11-13 15:23:50',NULL),(205,8087,34,40720,1562,3,484,1,1638.08,NULL,'2022-11-13 15:23:50','2022-11-13 15:23:50',NULL),(206,8087,34,40720,1562,3,135,1,2290.92,NULL,'2022-11-13 15:23:50','2022-11-13 15:23:50',NULL),(207,8087,34,40720,1562,3,128,1,9658.78,NULL,'2022-11-13 15:23:50','2022-11-13 15:23:50',NULL),(208,8087,34,40720,1562,3,25,1,2451.99,NULL,'2022-11-13 15:23:50','2022-11-13 15:23:50',NULL),(209,8087,34,40720,1562,3,359,2,491405.32,NULL,'2022-11-13 15:23:50','2022-11-13 15:23:50',NULL),(210,8087,35,40720,1562,2,359,1,780614.19,NULL,'2022-11-13 15:28:40','2022-11-13 15:28:40',NULL),(211,8087,35,40720,1562,2,489,1,7512.10,NULL,'2022-11-13 15:28:40','2022-11-13 15:28:40',NULL),(212,8087,35,40720,1562,2,23,1,2147.82,NULL,'2022-11-13 15:28:40','2022-11-13 15:28:40',NULL),(213,8087,35,40720,1562,2,67,2,137155.01,NULL,'2022-11-13 15:28:40','2022-11-13 15:28:40',NULL),(214,8087,35,40720,1562,2,96,2,653119.10,NULL,'2022-11-13 15:28:40','2022-11-13 15:28:40',NULL),(215,8087,36,40720,1562,1,110,1,74015.34,NULL,'2022-11-13 15:32:41','2022-11-13 15:32:41',NULL),(216,8087,36,40720,1562,1,191,1,14101.22,NULL,'2022-11-13 15:32:41','2022-11-13 15:32:41',NULL),(217,8087,36,40720,1562,1,63,2,22362.56,NULL,'2022-11-13 15:32:41','2022-11-13 15:32:41',NULL),(218,8087,36,40720,1562,1,359,2,63754.00,NULL,'2022-11-13 15:32:41','2022-11-13 15:32:41',NULL),(219,8087,36,40720,1562,1,64,2,2000.00,NULL,'2022-11-13 15:32:41','2022-11-13 15:32:41',NULL),(220,8087,37,40720,1562,5,157,1,6146.02,NULL,'2022-11-13 15:45:32','2022-11-13 15:45:32',NULL),(221,8087,37,40720,1562,5,396,1,275670.17,NULL,'2022-11-13 15:45:32','2022-11-13 15:45:32',NULL),(222,8087,37,40720,1562,5,276,1,1262.42,NULL,'2022-11-13 15:45:32','2022-11-13 15:45:32',NULL),(223,8087,37,40720,1562,5,252,1,24.90,NULL,'2022-11-13 15:45:32','2022-11-13 15:45:32',NULL),(224,8087,37,40720,1562,5,214,1,9415.94,NULL,'2022-11-13 15:45:32','2022-11-13 15:45:32',NULL),(225,8087,37,40720,1562,5,474,1,631205.42,NULL,'2022-11-13 15:45:32','2022-11-13 15:45:32',NULL),(226,8087,37,40720,1562,5,359,1,106278.12,NULL,'2022-11-13 15:45:32','2022-11-13 15:45:32',NULL),(227,8087,37,40720,1562,5,474,2,398797.57,NULL,'2022-11-13 15:45:32','2022-11-13 15:45:32',NULL),(228,8087,37,40720,1562,5,359,2,631205.42,NULL,'2022-11-13 15:45:32','2022-11-13 15:45:32',NULL),(229,8087,38,40720,1563,10,63,1,22362.56,NULL,'2022-11-13 15:48:04','2022-11-13 15:48:04',NULL),(230,8087,38,40720,1563,10,64,1,2000.00,NULL,'2022-11-13 15:48:04','2022-11-13 15:48:04',NULL),(231,8087,38,40720,1563,10,474,2,22362.56,NULL,'2022-11-13 15:48:04','2022-11-13 15:48:04',NULL),(232,8087,38,40720,1563,10,359,2,2000.00,NULL,'2022-11-13 15:48:04','2022-11-13 15:48:04',NULL),(233,8087,39,40720,1563,21,135,1,31895.16,NULL,'2022-11-13 15:54:23','2022-11-13 15:54:23',NULL),(234,8087,39,40720,1563,21,474,2,31895.16,NULL,'2022-11-13 15:54:23','2022-11-13 15:54:23',NULL);
INSERT INTO `balance_libro_details` VALUES (235,8087,40,40720,1563,19,482,1,14000.00,NULL,'2022-11-13 15:57:30','2022-11-13 15:57:30',NULL),(236,8087,40,40720,1563,19,483,1,30000.00,NULL,'2022-11-13 15:57:30','2022-11-13 15:57:30',NULL),(237,8087,40,40720,1563,19,474,2,44000.00,NULL,'2022-11-13 15:57:30','2022-11-13 15:57:30',NULL),(238,8087,41,40720,1563,15,67,1,137155.01,NULL,'2022-11-13 16:03:24','2022-11-13 16:03:24',NULL),(239,8087,41,40720,1563,15,68,2,82319.36,NULL,'2022-11-13 16:03:24','2022-11-13 16:03:24',NULL),(240,8087,41,40720,1563,15,25,2,2451.99,NULL,'2022-11-13 16:03:24','2022-11-13 16:03:24',NULL),(241,8087,41,40720,1563,15,72,2,892.54,NULL,'2022-11-13 16:03:24','2022-11-13 16:03:24',NULL),(242,8087,41,40720,1563,15,74,2,51491.12,NULL,'2022-11-13 16:03:24','2022-11-13 16:03:24',NULL),(243,8087,42,40720,1563,10,74,1,51491.12,NULL,'2022-11-13 16:15:20','2022-11-13 16:15:20',NULL),(244,8087,42,40720,1563,10,474,2,51491.12,NULL,'2022-11-13 16:15:20','2022-11-13 16:15:20',NULL),(245,8087,43,40720,1563,10,156,1,21816.47,NULL,'2022-11-13 16:21:32','2022-11-13 16:21:32',NULL),(246,8087,43,40720,1563,10,251,2,5.75,NULL,'2022-11-13 16:21:32','2022-11-13 16:21:32',NULL),(247,8087,43,40720,1563,10,252,2,1484.30,NULL,'2022-11-13 16:21:32','2022-11-13 16:21:32',NULL),(248,8087,43,40720,1563,10,276,2,1262.42,NULL,'2022-11-13 16:21:32','2022-11-13 16:21:32',NULL),(249,8087,43,40720,1563,10,489,2,7512.10,NULL,'2022-11-13 16:21:32','2022-11-13 16:21:32',NULL),(250,8087,43,40720,1563,10,474,2,11551.90,NULL,'2022-11-13 16:21:32','2022-11-13 16:21:32',NULL),(251,8087,44,40720,1563,21,57,1,100000.00,NULL,'2022-11-13 16:31:19','2022-11-13 16:31:19',NULL),(252,8087,44,40720,1563,21,359,2,100000.00,NULL,'2022-11-13 16:31:19','2022-11-13 16:31:19',NULL),(253,8087,45,40720,1563,3,392,1,302982.30,NULL,'2022-11-13 16:39:36','2022-11-13 16:39:36',NULL),(254,8087,45,40720,1563,3,68,1,66027.93,NULL,'2022-11-13 16:39:36','2022-11-13 16:39:36',NULL),(255,8087,45,40720,1563,3,25,1,1645.96,NULL,'2022-11-13 16:39:36','2022-11-13 16:39:36',NULL),(256,8087,45,40720,1563,3,23,1,92.05,NULL,'2022-11-13 16:39:36','2022-11-13 16:39:36',NULL),(257,8087,45,40720,1563,3,251,1,2.55,NULL,'2022-11-13 16:39:36','2022-11-13 16:39:36',NULL),(258,8087,45,40720,1563,3,252,1,1004.40,NULL,'2022-11-13 16:39:36','2022-11-13 16:39:36',NULL),(259,8087,45,40720,1563,3,116,1,6000.00,NULL,'2022-11-13 16:39:36','2022-11-13 16:39:36',NULL),(260,8087,45,40720,1563,3,193,1,1970.73,NULL,'2022-11-13 16:39:36','2022-11-13 16:39:36',NULL),(261,8087,45,40720,1563,3,484,1,2090.39,NULL,'2022-11-13 16:39:36','2022-11-13 16:39:36',NULL),(262,8087,45,40720,1563,3,135,1,2312.19,NULL,'2022-11-13 16:39:36','2022-11-13 16:39:36',NULL),(263,8087,45,40720,1563,3,128,1,6653.58,NULL,'2022-11-13 16:39:36','2022-11-13 16:39:36',NULL),(264,8087,45,40720,1563,3,359,2,390782.08,NULL,'2022-11-13 16:39:36','2022-11-13 16:39:36',NULL),(265,8087,46,40720,1563,2,359,1,759079.89,NULL,'2022-11-13 16:42:15','2022-11-13 16:42:15',NULL),(266,8087,46,40720,1563,2,489,1,7866.56,NULL,'2022-11-13 16:42:15','2022-11-13 16:42:15',NULL),(267,8087,46,40720,1563,2,23,1,2348.76,NULL,'2022-11-13 16:42:15','2022-11-13 16:42:15',NULL),(268,8087,46,40720,1563,2,67,2,133514.05,NULL,'2022-11-13 16:42:15','2022-11-13 16:42:15',NULL),(269,8087,46,40720,1563,2,96,2,635781.16,NULL,'2022-11-13 16:42:15','2022-11-13 16:42:15',NULL),(270,8087,47,40720,1563,1,110,1,84015.34,NULL,'2022-11-13 16:44:45','2022-11-13 16:44:45',NULL),(271,8087,47,40720,1563,1,191,1,14241.22,NULL,'2022-11-13 16:44:45','2022-11-13 16:44:45',NULL),(272,8087,47,40720,1563,1,63,2,22502.56,NULL,'2022-11-13 16:44:45','2022-11-13 16:44:45',NULL),(273,8087,47,40720,1563,1,62,2,73754.00,NULL,'2022-11-13 16:44:45','2022-11-13 16:44:45',NULL),(274,8087,47,40720,1563,1,64,2,2000.00,NULL,'2022-11-13 16:44:45','2022-11-13 16:44:45',NULL),(275,8087,48,40720,1563,5,157,1,5379.20,NULL,'2022-11-13 16:50:48','2022-11-13 16:50:48',NULL);
INSERT INTO `balance_libro_details` VALUES (276,8087,48,40720,1563,5,396,1,282481.71,NULL,'2022-11-13 16:50:48','2022-11-13 16:50:48',NULL),(277,8087,48,40720,1563,5,276,1,483.92,NULL,'2022-11-13 16:50:48','2022-11-13 16:50:48',NULL),(278,8087,48,40720,1563,5,252,1,24.90,NULL,'2022-11-13 16:50:48','2022-11-13 16:50:48',NULL),(279,8087,48,40720,1563,5,214,1,6785.63,NULL,'2022-11-13 16:50:48','2022-11-13 16:50:48',NULL),(280,8087,48,40720,1563,5,474,1,483902.04,NULL,'2022-11-13 16:50:48','2022-11-13 16:50:48',NULL),(281,8087,48,40720,1563,5,359,1,38053.97,NULL,'2022-11-13 16:50:48','2022-11-13 16:50:48',NULL),(282,8087,48,40720,1563,5,474,2,333209.33,NULL,'2022-11-13 16:50:48','2022-11-13 16:50:48',NULL),(283,8087,48,40720,1563,5,359,2,483902.04,NULL,'2022-11-13 16:50:48','2022-11-13 16:50:48',NULL),(284,8087,49,40720,1564,21,62,1,73754.00,NULL,'2022-11-13 16:54:17','2022-11-13 16:54:17',NULL),(285,8087,49,40720,1564,21,474,2,73754.00,NULL,'2022-11-13 16:54:17','2022-11-13 16:54:17',NULL),(286,8087,50,40720,1564,10,63,1,22502.56,NULL,'2022-11-13 16:57:04','2022-11-13 16:57:04',NULL),(287,8087,50,40720,1564,10,64,1,2000.00,NULL,'2022-11-13 16:57:04','2022-11-13 16:57:04',NULL),(288,8087,50,40720,1564,10,474,2,22502.56,NULL,'2022-11-13 16:57:04','2022-11-13 16:57:04',NULL),(289,8087,50,40720,1564,10,359,2,2000.00,NULL,'2022-11-13 16:57:04','2022-11-13 16:57:04',NULL),(290,8087,51,40720,1564,19,482,1,14000.00,NULL,'2022-11-13 17:00:32','2022-11-13 17:00:32',NULL),(291,8087,51,40720,1564,19,483,1,30000.00,NULL,'2022-11-13 17:00:32','2022-11-13 17:00:32',NULL),(292,8087,51,40720,1564,19,474,2,44000.00,NULL,'2022-11-13 17:00:32','2022-11-13 17:00:32',NULL),(293,8087,52,40720,1564,15,67,1,133514.05,NULL,'2022-11-13 17:02:54','2022-11-13 17:02:54',NULL),(294,8087,52,40720,1564,15,25,2,1645.96,NULL,'2022-11-13 17:02:54','2022-11-13 17:02:54',NULL),(295,8087,52,40720,1564,15,68,2,66027.93,NULL,'2022-11-13 17:02:54','2022-11-13 17:02:54',NULL),(296,8087,52,40720,1564,15,74,2,65840.16,NULL,'2022-11-13 17:02:54','2022-11-13 17:02:54',NULL),(297,8087,53,40720,1564,10,74,1,65840.16,NULL,'2022-11-13 17:04:30','2022-11-13 17:04:30',NULL),(298,8087,53,40720,1564,10,474,2,65840.16,NULL,'2022-11-13 17:04:30','2022-11-13 17:04:30',NULL),(299,8087,54,40720,1564,10,156,1,20301.59,NULL,'2022-11-13 17:10:47','2022-11-13 17:10:47',NULL),(300,8087,54,40720,1564,10,251,2,2.55,NULL,'2022-11-13 17:10:47','2022-11-13 17:10:47',NULL),(301,8087,54,40720,1564,10,252,2,963.79,NULL,'2022-11-13 17:10:47','2022-11-13 17:10:47',NULL),(302,8087,54,40720,1564,10,276,2,483.92,NULL,'2022-11-13 17:10:47','2022-11-13 17:10:47',NULL),(303,8087,54,40720,1564,10,489,2,7866.56,NULL,'2022-11-13 17:10:47','2022-11-13 17:10:47',NULL),(304,8087,54,40720,1564,10,474,2,10984.77,NULL,'2022-11-13 17:10:47','2022-11-13 17:10:47',NULL),(305,8087,55,40720,1564,3,392,1,570771.38,NULL,'2022-11-13 17:17:57','2022-11-13 17:17:57',NULL),(306,8087,55,40720,1564,3,68,1,121966.46,NULL,'2022-11-13 17:17:57','2022-11-13 17:17:57',NULL),(307,8087,55,40720,1564,3,72,1,242.41,NULL,'2022-11-13 17:17:57','2022-11-13 17:17:57',NULL),(308,8087,55,40720,1564,3,25,1,2352.18,NULL,'2022-11-13 17:17:57','2022-11-13 17:17:57',NULL),(309,8087,55,40720,1564,3,251,1,33.93,NULL,'2022-11-13 17:17:57','2022-11-13 17:17:57',NULL),(310,8087,55,40720,1564,3,252,1,2413.88,NULL,'2022-11-13 17:17:57','2022-11-13 17:17:57',NULL),(311,8087,55,40720,1564,3,116,1,3000.00,NULL,'2022-11-13 17:17:57','2022-11-13 17:17:57',NULL),(312,8087,55,40720,1564,3,193,1,2745.50,NULL,'2022-11-13 17:17:57','2022-11-13 17:17:57',NULL),(313,8087,55,40720,1564,3,484,1,4951.82,NULL,'2022-11-13 17:17:57','2022-11-13 17:17:57',NULL),(314,8087,55,40720,1564,3,135,1,2258.74,NULL,'2022-11-13 17:17:57','2022-11-13 17:17:57',NULL),(315,8087,55,40720,1564,3,128,1,4925.72,NULL,'2022-11-13 17:17:57','2022-11-13 17:17:57',NULL),(316,8087,55,40720,1564,3,359,2,715662.02,NULL,'2022-11-13 17:17:57','2022-11-13 17:17:57',NULL);
INSERT INTO `balance_libro_details` VALUES (317,8087,56,40720,1564,2,359,1,845769.02,NULL,'2022-11-13 17:21:42','2022-11-13 17:21:42',NULL),(318,8087,56,40720,1564,2,489,1,10236.33,NULL,'2022-11-13 17:21:42','2022-11-13 17:21:42',NULL),(319,8087,56,40720,1564,2,23,1,3976.22,NULL,'2022-11-13 17:21:42','2022-11-13 17:21:42',NULL),(320,8087,56,40720,1564,2,67,2,149253.00,NULL,'2022-11-13 17:21:42','2022-11-13 17:21:42',NULL),(321,8087,56,40720,1564,2,96,2,710728.57,NULL,'2022-11-13 17:21:42','2022-11-13 17:21:42',NULL),(322,8087,57,40720,1564,1,110,1,88876.72,NULL,'2022-11-13 17:24:00','2022-11-13 17:24:00',NULL),(323,8087,57,40720,1564,1,191,1,15379.08,NULL,'2022-11-13 17:24:00','2022-11-13 17:24:00',NULL),(324,8087,57,40720,1564,1,63,2,24563.80,NULL,'2022-11-13 17:24:00','2022-11-13 17:24:00',NULL),(325,8087,57,40720,1564,1,62,2,77692.00,NULL,'2022-11-13 17:24:00','2022-11-13 17:24:00',NULL),(326,8087,57,40720,1564,1,64,2,2000.00,NULL,'2022-11-13 17:24:00','2022-11-13 17:24:00',NULL),(327,8087,58,40720,1564,5,157,1,5681.67,NULL,'2022-11-13 17:27:32','2022-11-13 17:27:32',NULL),(328,8087,58,40720,1564,5,396,1,197305.05,NULL,'2022-11-13 17:27:32','2022-11-13 17:27:32',NULL),(329,8087,58,40720,1564,5,276,1,1282.18,NULL,'2022-11-13 17:27:32','2022-11-13 17:27:32',NULL),(330,8087,58,40720,1564,5,252,1,27.00,NULL,'2022-11-13 17:27:32','2022-11-13 17:27:32',NULL),(331,8087,58,40720,1564,5,214,1,2025.07,NULL,'2022-11-13 17:27:32','2022-11-13 17:27:32',NULL),(332,8087,58,40720,1564,5,474,1,711099.19,NULL,'2022-11-13 17:27:32','2022-11-13 17:27:32',NULL),(333,8087,58,40720,1564,5,359,1,88927.16,NULL,'2022-11-13 17:27:32','2022-11-13 17:27:32',NULL),(334,8087,58,40720,1564,5,474,2,295248.13,NULL,'2022-11-13 17:27:32','2022-11-13 17:27:32',NULL),(335,8087,58,40720,1564,5,359,2,711099.19,NULL,'2022-11-13 17:27:32','2022-11-13 17:27:32',NULL),(336,8087,59,40720,1565,21,62,1,77692.00,NULL,'2022-11-13 18:36:13','2022-11-13 18:36:13',NULL),(337,8087,59,40720,1565,21,474,2,77692.00,NULL,'2022-11-13 18:36:13','2022-11-13 18:36:13',NULL),(338,8087,60,40720,1565,19,482,1,14000.00,NULL,'2022-11-13 18:39:20','2022-11-13 18:39:20',NULL),(339,8087,60,40720,1565,19,483,1,30000.00,NULL,'2022-11-13 18:39:20','2022-11-13 18:39:20',NULL),(340,8087,60,40720,1565,19,474,2,44000.00,NULL,'2022-11-13 18:39:20','2022-11-13 18:39:20',NULL),(341,8087,61,40720,1565,10,63,1,24563.80,NULL,'2022-11-13 18:42:10','2022-11-13 18:42:10',NULL),(342,8087,61,40720,1565,10,64,1,2000.00,NULL,'2022-11-13 18:42:10','2022-11-13 18:42:10',NULL),(343,8087,61,40720,1565,10,474,2,24563.80,NULL,'2022-11-13 18:42:10','2022-11-13 18:42:10',NULL),(344,8087,61,40720,1565,10,359,2,2000.00,NULL,'2022-11-13 18:42:10','2022-11-13 18:42:10',NULL),(345,8087,62,40720,1565,15,67,1,149253.00,NULL,'2022-11-13 18:44:32','2022-11-13 18:44:32',NULL),(346,8087,62,40720,1565,15,74,2,24691.95,NULL,'2022-11-13 18:44:32','2022-11-13 18:44:32',NULL),(347,8087,62,40720,1565,15,68,2,121966.46,NULL,'2022-11-13 18:44:32','2022-11-13 18:44:32',NULL),(348,8087,62,40720,1565,15,25,2,2352.18,NULL,'2022-11-13 18:44:32','2022-11-13 18:44:32',NULL),(349,8087,62,40720,1565,15,72,2,242.41,NULL,'2022-11-13 18:44:32','2022-11-13 18:44:32',NULL),(350,8087,63,40720,1565,10,74,1,24691.95,NULL,'2022-11-13 18:47:36','2022-11-13 18:47:36',NULL),(351,8087,63,40720,1565,10,474,2,24691.95,NULL,'2022-11-13 18:47:36','2022-11-13 18:47:36',NULL),(352,8087,64,40720,1565,10,156,1,23343.26,NULL,'2022-11-13 18:51:09','2022-11-13 18:51:09',NULL),(353,8087,64,40720,1565,10,251,2,33.93,NULL,'2022-11-13 18:51:09','2022-11-13 18:51:09',NULL),(354,8087,64,40720,1565,10,252,2,2413.88,NULL,'2022-11-13 18:51:09','2022-11-13 18:51:09',NULL),(355,8087,64,40720,1565,10,276,2,1282.18,NULL,'2022-11-13 18:51:09','2022-11-13 18:51:09',NULL),(356,8087,64,40720,1565,10,489,2,10236.33,NULL,'2022-11-13 18:51:09','2022-11-13 18:51:09',NULL),(357,8087,64,40720,1565,10,474,2,9376.94,NULL,'2022-11-13 18:51:09','2022-11-13 18:51:09',NULL);
INSERT INTO `balance_libro_details` VALUES (358,8087,65,40720,1565,1,110,1,128347.59,NULL,'2022-11-13 18:56:02','2022-11-13 18:56:02',NULL),(359,8087,65,40720,1565,1,191,1,22598.50,NULL,'2022-11-13 18:56:02','2022-11-13 18:56:02',NULL),(360,8087,65,40720,1565,1,63,2,37541.10,NULL,'2022-11-13 18:56:02','2022-11-13 18:56:02',NULL),(361,8087,65,40720,1565,1,359,2,33246.99,NULL,'2022-11-13 18:56:02','2022-11-13 18:56:02',NULL),(362,8087,65,40720,1565,1,62,2,78158.00,NULL,'2022-11-13 18:56:02','2022-11-13 18:56:02',NULL),(363,8087,65,40720,1565,1,64,2,2000.00,NULL,'2022-11-13 18:56:02','2022-11-13 18:56:02',NULL),(364,8087,66,40720,1565,3,392,1,360915.13,NULL,'2022-11-13 18:59:58','2022-11-13 18:59:58',NULL),(365,8087,66,40720,1565,3,68,1,78373.79,NULL,'2022-11-13 18:59:58','2022-11-13 18:59:58',NULL),(366,8087,66,40720,1565,3,25,1,2336.18,NULL,'2022-11-13 18:59:58','2022-11-13 18:59:58',NULL),(367,8087,66,40720,1565,3,72,1,708.19,NULL,'2022-11-13 18:59:58','2022-11-13 18:59:58',NULL),(368,8087,66,40720,1565,3,251,1,125.19,NULL,'2022-11-13 18:59:58','2022-11-13 18:59:58',NULL),(369,8087,66,40720,1565,3,252,1,3140.07,NULL,'2022-11-13 18:59:58','2022-11-13 18:59:58',NULL),(370,8087,66,40720,1565,3,116,1,3000.00,NULL,'2022-11-13 18:59:58','2022-11-13 18:59:58',NULL),(371,8087,66,40720,1565,3,193,1,3759.93,NULL,'2022-11-13 18:59:58','2022-11-13 18:59:58',NULL),(372,8087,66,40720,1565,3,484,1,3800.84,NULL,'2022-11-13 18:59:58','2022-11-13 18:59:58',NULL),(373,8087,66,40720,1565,3,135,1,1947.16,NULL,'2022-11-13 18:59:58','2022-11-13 18:59:58',NULL),(374,8087,66,40720,1565,3,128,1,8130.30,NULL,'2022-11-13 18:59:58','2022-11-13 18:59:58',NULL),(375,8087,66,40720,1565,3,359,2,466236.78,NULL,'2022-11-13 18:59:58','2022-11-13 18:59:58',NULL),(376,8087,67,40720,1565,2,359,1,726143.16,NULL,'2022-11-13 19:01:37','2022-11-13 19:01:37',NULL),(377,8087,67,40720,1565,2,489,1,3124.89,NULL,'2022-11-13 19:01:37','2022-11-13 19:01:37',NULL),(378,8087,67,40720,1565,2,67,2,126567.18,NULL,'2022-11-13 19:01:37','2022-11-13 19:01:37',NULL),(379,8087,67,40720,1565,2,96,2,602700.87,NULL,'2022-11-13 19:01:37','2022-11-13 19:01:37',NULL),(380,8087,68,40720,1565,5,157,1,3859.27,NULL,'2022-11-13 19:04:55','2022-11-13 19:04:55',NULL),(381,8087,68,40720,1565,5,396,1,186676.52,NULL,'2022-11-13 19:04:55','2022-11-13 19:04:55',NULL),(382,8087,68,40720,1565,5,276,1,1053.80,NULL,'2022-11-13 19:04:55','2022-11-13 19:04:55',NULL),(383,8087,68,40720,1565,5,252,1,27.00,NULL,'2022-11-13 19:04:55','2022-11-13 19:04:55',NULL),(384,8087,68,40720,1565,5,214,1,9067.44,NULL,'2022-11-13 19:04:55','2022-11-13 19:04:55',NULL),(385,8087,68,40720,1565,5,474,1,421262.22,NULL,'2022-11-13 19:04:55','2022-11-13 19:04:55',NULL),(386,8087,68,40720,1565,5,359,1,178128.30,NULL,'2022-11-13 19:04:55','2022-11-13 19:04:55',NULL),(387,8087,68,40720,1565,5,474,2,378812.33,NULL,'2022-11-13 19:04:55','2022-11-13 19:04:55',NULL),(388,8087,68,40720,1565,5,359,2,421262.22,NULL,'2022-11-13 19:04:55','2022-11-13 19:04:55',NULL),(389,8087,69,40720,1566,21,62,1,78158.00,NULL,'2022-11-13 20:43:26','2022-11-13 20:43:26',NULL),(390,8087,69,40720,1566,21,474,2,78158.00,NULL,'2022-11-13 20:43:26','2022-11-13 20:43:26',NULL),(391,8087,70,40720,1566,19,482,1,13000.00,NULL,'2022-11-13 20:45:10','2022-11-13 20:45:10',NULL),(392,8087,70,40720,1566,19,483,1,30000.00,NULL,'2022-11-13 20:45:10','2022-11-13 20:45:10',NULL),(393,8087,70,40720,1566,19,474,2,43000.00,NULL,'2022-11-13 20:45:10','2022-11-13 20:45:10',NULL),(394,8087,71,40720,1566,10,63,1,37541.10,NULL,'2022-11-13 20:47:08','2022-11-13 20:47:08',NULL),(395,8087,71,40720,1566,10,64,1,2000.00,NULL,'2022-11-13 20:47:08','2022-11-13 20:47:08',NULL),(396,8087,71,40720,1566,10,474,2,37541.10,NULL,'2022-11-13 20:47:08','2022-11-13 20:47:08',NULL),(397,8087,71,40720,1566,10,359,2,2000.00,NULL,'2022-11-13 20:47:08','2022-11-13 20:47:08',NULL),(398,8087,72,40720,1566,15,67,1,126567.18,NULL,'2022-11-14 06:32:20','2022-11-14 06:32:20',NULL);
INSERT INTO `balance_libro_details` VALUES (399,8087,72,40720,1566,15,74,2,45149.02,NULL,'2022-11-14 06:32:20','2022-11-14 06:32:20',NULL),(400,8087,72,40720,1566,15,68,2,78373.79,NULL,'2022-11-14 06:32:20','2022-11-14 06:32:20',NULL),(401,8087,72,40720,1566,15,25,2,2336.18,NULL,'2022-11-14 06:32:20','2022-11-14 06:32:20',NULL),(402,8087,72,40720,1566,15,72,2,708.19,NULL,'2022-11-14 06:32:20','2022-11-14 06:32:20',NULL),(403,8087,73,40720,1566,10,156,1,19976.89,NULL,'2022-11-14 06:35:50','2022-11-14 06:35:50',NULL),(404,8087,73,40720,1566,10,251,2,125.19,NULL,'2022-11-14 06:35:50','2022-11-14 06:35:50',NULL),(405,8087,73,40720,1566,10,252,2,3140.07,NULL,'2022-11-14 06:35:50','2022-11-14 06:35:50',NULL),(406,8087,73,40720,1566,10,276,2,1053.80,NULL,'2022-11-14 06:35:50','2022-11-14 06:35:50',NULL),(407,8087,73,40720,1566,10,489,2,3124.89,NULL,'2022-11-14 06:35:50','2022-11-14 06:35:50',NULL),(408,8087,73,40720,1566,10,474,2,12532.94,NULL,'2022-11-14 06:35:50','2022-11-14 06:35:50',NULL),(409,8087,74,40720,1566,10,74,1,45149.02,NULL,'2022-11-14 06:37:07','2022-11-14 06:37:07',NULL),(410,8087,74,40720,1566,10,474,2,45149.02,NULL,'2022-11-14 06:37:07','2022-11-14 06:37:07',NULL),(411,8087,75,40720,1566,10,488,1,1642.08,NULL,'2022-11-14 06:39:04','2022-11-14 06:39:04',NULL),(412,8087,75,40720,1566,10,474,2,1642.08,NULL,'2022-11-14 06:39:04','2022-11-14 06:39:04',NULL),(413,8087,76,40720,1566,21,57,1,100000.00,NULL,'2022-11-14 06:40:23','2022-11-14 06:40:23',NULL),(414,8087,76,40720,1566,21,359,2,100000.00,NULL,'2022-11-14 06:40:23','2022-11-14 06:40:23',NULL),(415,8087,77,40720,1566,5,157,1,6765.06,NULL,'2022-11-14 08:29:48','2022-11-14 08:29:48',NULL),(416,8087,77,40720,1566,5,396,1,274908.44,NULL,'2022-11-14 08:29:48','2022-11-14 08:29:48',NULL),(417,8087,77,40720,1566,5,276,1,649.53,NULL,'2022-11-14 08:29:48','2022-11-14 08:29:48',NULL),(418,8087,77,40720,1566,5,252,1,27.00,NULL,'2022-11-14 08:29:48','2022-11-14 08:29:48',NULL),(419,8087,77,40720,1566,5,214,1,1671.59,NULL,'2022-11-14 08:29:48','2022-11-14 08:29:48',NULL),(420,8087,77,40720,1566,5,474,1,649557.44,NULL,'2022-11-14 08:29:48','2022-11-14 08:29:48',NULL),(421,8087,77,40720,1566,5,359,1,129744.10,NULL,'2022-11-14 08:29:48','2022-11-14 08:29:48',NULL),(422,8087,77,40720,1566,5,474,2,413765.72,NULL,'2022-11-14 08:29:48','2022-11-14 08:29:48',NULL),(423,8087,77,40720,1566,5,359,2,649557.44,NULL,'2022-11-14 08:29:48','2022-11-14 08:29:48',NULL),(424,8087,78,40720,1566,1,110,1,89453.94,NULL,'2022-11-14 09:09:18','2022-11-14 09:09:18',NULL),(425,8087,78,40720,1566,1,191,1,15512.61,NULL,'2022-11-14 09:09:18','2022-11-14 09:09:18',NULL),(426,8087,78,40720,1566,1,63,2,24808.55,NULL,'2022-11-14 09:09:18','2022-11-14 09:09:18',NULL),(427,8087,78,40720,1566,1,62,2,78158.00,NULL,'2022-11-14 09:09:18','2022-11-14 09:09:18',NULL),(428,8087,78,40720,1566,1,64,2,2000.00,NULL,'2022-11-14 09:09:18','2022-11-14 09:09:18',NULL),(429,8087,79,40720,1566,3,392,1,415039.52,NULL,'2022-11-14 09:26:45','2022-11-14 09:26:45',NULL),(430,8087,79,40720,1566,3,68,1,88989.46,NULL,'2022-11-14 09:26:45','2022-11-14 09:26:45',NULL),(431,8087,79,40720,1566,3,25,1,2242.99,NULL,'2022-11-14 09:26:45','2022-11-14 09:26:45',NULL),(432,8087,79,40720,1566,3,72,1,238.23,NULL,'2022-11-14 09:26:45','2022-11-14 09:26:45',NULL),(433,8087,79,40720,1566,3,251,1,1467.38,NULL,'2022-11-14 09:26:45','2022-11-14 09:26:45',NULL),(434,8087,79,40720,1566,3,252,1,2843.64,NULL,'2022-11-14 09:26:45','2022-11-14 09:26:45',NULL),(435,8087,79,40720,1566,3,116,1,3000.00,NULL,'2022-11-14 09:26:45','2022-11-14 09:26:45',NULL),(436,8087,79,40720,1566,3,193,1,431.18,NULL,'2022-11-14 09:26:45','2022-11-14 09:26:45',NULL),(437,8087,79,40720,1566,3,484,1,7344.07,NULL,'2022-11-14 09:26:45','2022-11-14 09:26:45',NULL),(438,8087,79,40720,1566,3,135,1,70830.48,NULL,'2022-11-14 09:26:45','2022-11-14 09:26:45',NULL),(439,8087,79,40720,1566,3,128,1,5945.49,NULL,'2022-11-14 09:26:45','2022-11-14 09:26:45',NULL);
INSERT INTO `balance_libro_details` VALUES (440,8087,79,40720,1566,3,359,2,262121.16,NULL,'2022-11-14 09:26:45','2022-11-14 09:26:45',NULL),(441,8087,79,40720,1566,3,57,2,336251.28,NULL,'2022-11-14 09:26:45','2022-11-14 09:26:45',NULL),(442,8087,80,40720,1566,2,359,1,892256.86,NULL,'2022-11-14 09:31:43','2022-11-14 09:31:43',NULL),(443,8087,80,40720,1566,2,489,1,12164.93,NULL,'2022-11-14 09:31:43','2022-11-14 09:31:43',NULL),(444,8087,80,40720,1566,2,23,1,5138.22,NULL,'2022-11-14 09:31:43','2022-11-14 09:31:43',NULL),(445,8087,80,40720,1566,2,67,2,157857.52,NULL,'2022-11-14 09:31:43','2022-11-14 09:31:43',NULL),(446,8087,80,40720,1566,2,96,2,751702.49,NULL,'2022-11-14 09:31:43','2022-11-14 09:31:43',NULL),(447,8087,81,40720,1567,21,62,1,78158.00,NULL,'2022-11-14 09:33:03','2022-11-14 09:33:03',NULL),(448,8087,81,40720,1567,21,474,2,78158.00,NULL,'2022-11-14 09:33:03','2022-11-14 09:33:03',NULL),(449,8087,82,40720,1567,10,63,1,24808.55,NULL,'2022-11-14 09:34:50','2022-11-14 09:34:50',NULL),(450,8087,82,40720,1567,10,64,1,2000.00,NULL,'2022-11-14 09:34:50','2022-11-14 09:34:50',NULL),(451,8087,82,40720,1567,10,474,2,24808.55,NULL,'2022-11-14 09:34:50','2022-11-14 09:34:50',NULL),(452,8087,82,40720,1567,10,359,2,2000.00,NULL,'2022-11-14 09:34:50','2022-11-14 09:34:50',NULL),(453,8087,83,40720,1567,19,482,1,14000.00,NULL,'2022-11-14 09:37:48','2022-11-14 09:37:48',NULL),(454,8087,83,40720,1567,19,483,1,30000.00,NULL,'2022-11-14 09:37:48','2022-11-14 09:37:48',NULL),(455,8087,83,40720,1567,19,474,2,44000.00,NULL,'2022-11-14 09:37:48','2022-11-14 09:37:48',NULL),(456,8087,84,40720,1567,15,67,1,157857.52,NULL,'2022-11-14 09:40:31','2022-11-14 09:40:31',NULL),(457,8087,84,40720,1567,15,25,2,2242.99,NULL,'2022-11-14 09:40:31','2022-11-14 09:40:31',NULL),(458,8087,84,40720,1567,15,72,2,238.23,NULL,'2022-11-14 09:40:31','2022-11-14 09:40:31',NULL),(459,8087,84,40720,1567,15,68,2,88989.46,NULL,'2022-11-14 09:40:31','2022-11-14 09:40:31',NULL),(460,8087,84,40720,1567,15,74,2,66386.84,NULL,'2022-11-14 09:40:31','2022-11-14 09:40:31',NULL),(461,8087,85,40720,1567,10,74,1,66386.84,NULL,'2022-11-14 09:48:31','2022-11-14 09:48:31',NULL),(462,8087,85,40720,1567,10,474,2,66386.84,NULL,'2022-11-14 09:48:31','2022-11-14 09:48:31',NULL),(463,8087,86,40720,1567,10,156,1,24392.23,NULL,'2022-11-14 09:56:07','2022-11-14 09:56:07',NULL),(464,8087,86,40720,1567,10,251,2,1467.38,NULL,'2022-11-14 09:56:07','2022-11-14 09:56:07',NULL),(465,8087,86,40720,1567,10,252,2,2843.64,NULL,'2022-11-14 09:56:07','2022-11-14 09:56:07',NULL),(466,8087,86,40720,1567,10,276,2,649.53,NULL,'2022-11-14 09:56:07','2022-11-14 09:56:07',NULL),(467,8087,86,40720,1567,10,489,2,12164.93,NULL,'2022-11-14 09:56:07','2022-11-14 09:56:07',NULL),(468,8087,86,40720,1567,10,474,2,7266.75,NULL,'2022-11-14 09:56:07','2022-11-14 09:56:07',NULL),(469,8087,87,40720,1567,1,110,1,94363.00,NULL,'2022-11-14 10:00:01','2022-11-14 10:00:01',NULL),(470,8087,87,40720,1567,1,191,1,15005.69,NULL,'2022-11-14 10:00:01','2022-11-14 10:00:01',NULL),(471,8087,87,40720,1567,1,63,2,21232.69,NULL,'2022-11-14 10:00:01','2022-11-14 10:00:01',NULL),(472,8087,87,40720,1567,1,359,2,56136.00,NULL,'2022-11-14 10:00:01','2022-11-14 10:00:01',NULL),(473,8087,87,40720,1567,1,62,2,30000.00,NULL,'2022-11-14 10:00:01','2022-11-14 10:00:01',NULL),(474,8087,87,40720,1567,1,64,2,2000.00,NULL,'2022-11-14 10:00:01','2022-11-14 10:00:01',NULL),(475,8087,88,40720,1567,3,392,1,574862.30,NULL,'2022-11-14 10:05:06','2022-11-14 10:05:06',NULL),(476,8087,88,40720,1567,3,68,1,124342.76,NULL,'2022-11-14 10:05:06','2022-11-14 10:05:06',NULL),(477,8087,88,40720,1567,3,25,1,1631.19,NULL,'2022-11-14 10:05:06','2022-11-14 10:05:06',NULL),(478,8087,88,40720,1567,3,72,1,168.53,NULL,'2022-11-14 10:05:06','2022-11-14 10:05:06',NULL),(479,8087,88,40720,1567,3,251,1,24.34,NULL,'2022-11-14 10:05:06','2022-11-14 10:05:06',NULL),(480,8087,88,40720,1567,3,252,1,5037.05,NULL,'2022-11-14 10:05:06','2022-11-14 10:05:06',NULL);
INSERT INTO `balance_libro_details` VALUES (481,8087,88,40720,1567,3,116,1,3000.00,NULL,'2022-11-14 10:05:06','2022-11-14 10:05:06',NULL),(482,8087,88,40720,1567,3,193,1,6061.09,NULL,'2022-11-14 10:05:06','2022-11-14 10:05:06',NULL),(483,8087,88,40720,1567,3,484,1,3609.08,NULL,'2022-11-14 10:05:06','2022-11-14 10:05:06',NULL),(484,8087,88,40720,1567,3,135,1,3741.52,NULL,'2022-11-14 10:05:06','2022-11-14 10:05:06',NULL),(485,8087,88,40720,1567,3,128,1,9768.78,NULL,'2022-11-14 10:05:06','2022-11-14 10:05:06',NULL),(486,8087,88,40720,1567,3,359,2,383520.50,NULL,'2022-11-14 10:05:06','2022-11-14 10:05:06',NULL),(487,8087,88,40720,1567,3,57,2,348726.14,NULL,'2022-11-14 10:05:06','2022-11-14 10:05:06',NULL),(488,8087,89,40720,1567,2,359,1,951527.30,NULL,'2022-11-14 10:06:43','2022-11-14 10:06:43',NULL),(489,8087,89,40720,1567,2,489,1,3253.40,NULL,'2022-11-14 10:06:43','2022-11-14 10:06:43',NULL),(490,8087,89,40720,1567,2,67,2,165705.74,NULL,'2022-11-14 10:06:43','2022-11-14 10:06:43',NULL),(491,8087,89,40720,1567,2,96,2,789074.96,NULL,'2022-11-14 10:06:43','2022-11-14 10:06:43',NULL),(492,8087,90,40720,1567,5,157,1,4889.20,NULL,'2022-11-14 10:11:00','2022-11-14 10:11:00',NULL),(493,8087,90,40720,1567,5,396,1,152474.45,NULL,'2022-11-14 10:11:00','2022-11-14 10:11:00',NULL),(494,8087,90,40720,1567,5,276,1,944.76,NULL,'2022-11-14 10:11:00','2022-11-14 10:11:00',NULL),(495,8087,90,40720,1567,5,252,1,27.00,NULL,'2022-11-14 10:11:00','2022-11-14 10:11:00',NULL),(496,8087,90,40720,1567,5,214,1,5863.61,NULL,'2022-11-14 10:11:00','2022-11-14 10:11:00',NULL),(497,8087,90,40720,1567,5,474,1,472366.68,NULL,'2022-11-14 10:11:00','2022-11-14 10:11:00',NULL),(498,8087,90,40720,1567,5,359,1,146663.36,NULL,'2022-11-14 10:11:00','2022-11-14 10:11:00',NULL),(499,8087,90,40720,1567,5,474,2,310862.38,NULL,'2022-11-14 10:11:00','2022-11-14 10:11:00',NULL),(500,8087,90,40720,1567,5,359,2,472366.68,NULL,'2022-11-14 10:11:00','2022-11-14 10:11:00',NULL),(501,8087,91,40720,1567,21,57,1,100000.00,NULL,'2022-11-14 10:12:46','2022-11-14 10:12:46',NULL),(502,8087,91,40720,1567,21,359,2,100000.00,NULL,'2022-11-14 10:12:46','2022-11-14 10:12:46',NULL),(503,8087,92,40720,1568,21,62,1,30000.00,NULL,'2022-11-14 10:16:48','2022-11-14 10:16:48',NULL),(504,8087,92,40720,1568,21,474,2,30000.00,NULL,'2022-11-14 10:16:48','2022-11-14 10:16:48',NULL),(505,8087,93,40720,1568,10,63,1,21232.69,NULL,'2022-11-14 10:18:34','2022-11-14 10:18:34',NULL),(506,8087,93,40720,1568,10,64,1,2000.00,NULL,'2022-11-14 10:18:34','2022-11-14 10:18:34',NULL),(507,8087,93,40720,1568,10,474,2,21232.69,NULL,'2022-11-14 10:18:34','2022-11-14 10:18:34',NULL),(508,8087,93,40720,1568,10,359,2,2000.00,NULL,'2022-11-14 10:18:34','2022-11-14 10:18:34',NULL),(509,8087,94,40720,1568,19,482,1,14000.00,NULL,'2022-11-14 10:26:36','2022-11-14 10:26:36',NULL),(510,8087,94,40720,1568,19,483,1,30000.00,NULL,'2022-11-14 10:26:36','2022-11-14 10:26:36',NULL),(511,8087,94,40720,1568,19,474,2,44000.00,NULL,'2022-11-14 10:26:36','2022-11-14 10:26:36',NULL),(512,8087,95,40720,1568,15,67,1,165705.75,NULL,'2022-11-14 10:30:37','2022-11-14 10:30:37',NULL),(513,8087,95,40720,1568,15,68,2,124342.76,NULL,'2022-11-14 10:30:37','2022-11-14 10:30:37',NULL),(514,8087,95,40720,1568,15,25,2,1631.19,NULL,'2022-11-14 10:30:37','2022-11-14 10:30:37',NULL),(515,8087,95,40720,1568,15,72,2,168.53,NULL,'2022-11-14 10:30:37','2022-11-14 10:30:37',NULL),(516,8087,95,40720,1568,15,74,2,39563.27,NULL,'2022-11-14 10:30:37','2022-11-14 10:30:37',NULL),(517,8087,96,40720,1568,10,156,1,25696.13,NULL,'2022-11-14 10:37:52','2022-11-14 10:37:52',NULL),(518,8087,96,40720,1568,10,251,2,24.34,NULL,'2022-11-14 10:37:52','2022-11-14 10:37:52',NULL),(519,8087,96,40720,1568,10,252,2,4962.48,NULL,'2022-11-14 10:37:52','2022-11-14 10:37:52',NULL),(520,8087,96,40720,1568,10,276,2,944.76,NULL,'2022-11-14 10:37:52','2022-11-14 10:37:52',NULL),(521,8087,96,40720,1568,10,489,2,3253.40,NULL,'2022-11-14 10:37:52','2022-11-14 10:37:52',NULL);
INSERT INTO `balance_libro_details` VALUES (522,8087,96,40720,1568,10,474,2,16511.15,NULL,'2022-11-14 10:37:52','2022-11-14 10:37:52',NULL),(523,8087,97,40720,1568,10,74,1,39563.27,NULL,'2022-11-14 10:39:19','2022-11-14 10:39:19',NULL),(524,8087,97,40720,1568,10,474,2,39563.27,NULL,'2022-11-14 10:39:19','2022-11-14 10:39:19',NULL),(525,8087,98,40720,1568,1,110,1,96363.00,NULL,'2022-11-14 10:40:47','2022-11-14 10:40:47',NULL),(526,8087,98,40720,1568,1,191,1,15231.71,NULL,'2022-11-14 10:40:47','2022-11-14 10:40:47',NULL),(527,8087,98,40720,1568,1,63,2,21560.69,NULL,'2022-11-14 10:40:47','2022-11-14 10:40:47',NULL),(528,8087,98,40720,1568,1,62,2,88034.02,NULL,'2022-11-14 10:40:47','2022-11-14 10:40:47',NULL),(529,8087,98,40720,1568,1,64,2,2000.00,NULL,'2022-11-14 10:40:47','2022-11-14 10:40:47',NULL),(530,8087,99,40720,1568,3,392,1,365883.85,NULL,'2022-11-14 10:44:57','2022-11-14 10:44:57',NULL),(531,8087,99,40720,1568,3,68,1,78050.89,NULL,'2022-11-14 10:44:57','2022-11-14 10:44:57',NULL),(532,8087,99,40720,1568,3,25,1,2023.61,NULL,'2022-11-14 10:44:57','2022-11-14 10:44:57',NULL),(533,8087,99,40720,1568,3,72,1,84.72,NULL,'2022-11-14 10:44:57','2022-11-14 10:44:57',NULL),(534,8087,99,40720,1568,3,251,1,16.13,NULL,'2022-11-14 10:44:57','2022-11-14 10:44:57',NULL),(535,8087,99,40720,1568,3,252,1,1773.13,NULL,'2022-11-14 10:44:57','2022-11-14 10:44:57',NULL),(536,8087,99,40720,1568,3,193,1,2417.52,NULL,'2022-11-14 10:44:57','2022-11-14 10:44:57',NULL),(537,8087,99,40720,1568,3,484,1,3868.24,NULL,'2022-11-14 10:44:57','2022-11-14 10:44:57',NULL),(538,8087,99,40720,1568,3,128,1,6485.07,NULL,'2022-11-14 10:44:57','2022-11-14 10:44:57',NULL),(539,8087,99,40720,1568,3,135,1,4334.18,NULL,'2022-11-14 10:44:57','2022-11-14 10:44:57',NULL),(540,8087,99,40720,1568,3,359,2,147798.26,NULL,'2022-11-14 10:44:57','2022-11-14 10:44:57',NULL),(541,8087,99,40720,1568,3,57,2,317139.08,NULL,'2022-11-14 10:44:57','2022-11-14 10:44:57',NULL),(542,8087,100,40720,1568,2,359,1,857689.08,NULL,'2022-11-14 10:46:45','2022-11-14 16:15:32','2022-11-14 16:15:32'),(543,8087,100,40720,1568,2,489,1,8265.41,NULL,'2022-11-14 10:46:45','2022-11-14 16:15:32','2022-11-14 16:15:32'),(544,8087,100,40720,1568,2,23,1,1030.27,NULL,'2022-11-14 10:46:45','2022-11-14 16:15:32','2022-11-14 16:15:32'),(545,8087,100,40720,1568,2,67,2,150468.43,NULL,'2022-11-14 10:46:45','2022-11-14 16:15:32','2022-11-14 16:15:32'),(546,8087,100,40720,1568,2,359,2,716516.33,NULL,'2022-11-14 10:46:45','2022-11-14 16:15:32','2022-11-14 16:15:32'),(547,8087,101,40720,1568,5,157,1,4897.93,NULL,'2022-11-14 10:51:44','2022-11-14 10:51:44',NULL),(548,8087,101,40720,1568,5,396,1,102686.30,NULL,'2022-11-14 10:51:44','2022-11-14 10:51:44',NULL),(549,8087,101,40720,1568,5,276,1,1144.41,NULL,'2022-11-14 10:51:44','2022-11-14 10:51:44',NULL),(550,8087,101,40720,1568,5,252,1,29.10,NULL,'2022-11-14 10:51:44','2022-11-14 10:51:44',NULL),(551,8087,101,40720,1568,5,214,1,5729.96,NULL,'2022-11-14 10:51:44','2022-11-14 10:51:44',NULL),(552,8087,101,40720,1568,5,474,1,572208.03,NULL,'2022-11-14 10:51:44','2022-11-14 10:51:44',NULL),(553,8087,101,40720,1568,5,359,1,180070.80,NULL,'2022-11-14 10:51:44','2022-11-14 10:51:44',NULL),(554,8087,101,40720,1568,5,474,2,294558.50,NULL,'2022-11-14 10:51:44','2022-11-14 10:51:44',NULL),(555,8087,101,40720,1568,5,359,2,572208.03,NULL,'2022-11-14 10:51:44','2022-11-14 10:51:44',NULL),(556,8087,102,40720,1569,21,62,1,88034.02,NULL,'2022-11-14 10:54:25','2022-11-14 10:54:25',NULL),(557,8087,102,40720,1569,21,474,2,88034.02,NULL,'2022-11-14 10:54:25','2022-11-14 10:54:25',NULL),(558,8087,103,40720,1569,19,482,1,13600.00,NULL,'2022-11-14 10:55:23','2022-11-14 10:55:23',NULL),(559,8087,103,40720,1569,19,483,1,30000.00,NULL,'2022-11-14 10:55:23','2022-11-14 10:55:23',NULL),(560,8087,103,40720,1569,19,474,2,43600.00,NULL,'2022-11-14 10:55:23','2022-11-14 10:55:23',NULL),(561,8087,104,40720,1569,10,191,1,5772.35,NULL,'2022-11-14 10:57:24','2022-11-14 10:57:24',NULL);
INSERT INTO `balance_libro_details` VALUES (562,8087,104,40720,1569,10,474,2,5772.35,NULL,'2022-11-14 10:57:24','2022-11-14 10:57:24',NULL),(563,8087,105,40720,1569,10,63,1,21560.69,NULL,'2022-11-14 10:59:31','2022-11-14 10:59:31',NULL),(564,8087,105,40720,1569,10,64,1,2000.00,NULL,'2022-11-14 10:59:31','2022-11-14 10:59:31',NULL),(565,8087,105,40720,1569,10,474,2,21560.69,NULL,'2022-11-14 10:59:31','2022-11-14 10:59:31',NULL),(566,8087,105,40720,1569,10,359,2,2000.00,NULL,'2022-11-14 10:59:31','2022-11-14 10:59:31',NULL),(567,8087,106,40720,1569,15,67,1,150468.43,NULL,'2022-11-14 11:02:49','2022-11-14 11:02:49',NULL),(568,8087,106,40720,1569,15,68,2,78050.89,NULL,'2022-11-14 11:02:49','2022-11-14 11:02:49',NULL),(569,8087,106,40720,1569,15,25,2,2023.61,NULL,'2022-11-14 11:02:49','2022-11-14 11:02:49',NULL),(570,8087,106,40720,1569,15,72,2,84.72,NULL,'2022-11-14 11:02:49','2022-11-14 11:02:49',NULL),(571,8087,106,40720,1569,15,74,2,70309.21,NULL,'2022-11-14 11:02:49','2022-11-14 11:02:49',NULL),(572,8087,107,40720,1569,10,74,1,70309.21,NULL,'2022-11-14 11:04:20','2022-11-14 11:04:20',NULL),(573,8087,107,40720,1569,10,474,2,70309.21,NULL,'2022-11-14 11:04:20','2022-11-14 11:04:20',NULL),(574,8087,108,40720,1569,10,156,1,23262.76,NULL,'2022-11-14 11:06:19','2022-11-14 11:06:19',NULL),(575,8087,108,40720,1569,10,251,2,16.13,NULL,'2022-11-14 11:06:19','2022-11-14 11:06:19',NULL),(576,8087,108,40720,1569,10,252,2,1773.13,NULL,'2022-11-14 11:06:19','2022-11-14 11:06:19',NULL),(577,8087,108,40720,1569,10,276,2,1144.41,NULL,'2022-11-14 11:06:19','2022-11-14 11:06:19',NULL),(578,8087,108,40720,1569,10,489,2,8265.41,NULL,'2022-11-14 11:06:19','2022-11-14 11:06:19',NULL),(579,8087,108,40720,1569,10,474,2,12063.68,NULL,'2022-11-14 11:06:19','2022-11-14 11:06:19',NULL),(580,8087,109,40720,1569,21,57,1,200000.00,NULL,'2022-11-14 11:14:37','2022-11-14 16:13:59','2022-11-14 16:13:59'),(581,8087,109,40720,1569,21,359,2,200000.00,NULL,'2022-11-14 11:14:37','2022-11-14 16:13:59','2022-11-14 16:13:59'),(582,8087,110,40720,1569,21,57,1,200000.00,NULL,'2022-11-14 11:14:46','2022-11-14 11:14:46',NULL),(583,8087,110,40720,1569,21,359,2,200000.00,NULL,'2022-11-14 11:14:46','2022-11-14 11:14:46',NULL),(584,8087,111,40720,1569,1,110,1,96363.00,NULL,'2022-11-14 11:20:46','2022-11-14 11:20:46',NULL),(585,8087,111,40720,1569,1,191,1,15231.71,NULL,'2022-11-14 11:20:46','2022-11-14 11:20:46',NULL),(586,8087,111,40720,1569,1,63,2,25560.69,NULL,'2022-11-14 11:20:46','2022-11-14 11:20:46',NULL),(587,8087,111,40720,1569,1,62,2,84034.02,NULL,'2022-11-14 11:20:46','2022-11-14 11:20:46',NULL),(588,8087,111,40720,1569,1,64,2,2000.00,NULL,'2022-11-14 11:20:46','2022-11-14 11:20:46',NULL),(589,8087,112,40720,1569,3,392,1,626443.25,NULL,'2022-11-14 11:24:55','2022-11-14 11:24:55',NULL),(590,8087,112,40720,1569,3,68,1,135080.69,NULL,'2022-11-14 11:24:55','2022-11-14 11:24:55',NULL),(591,8087,112,40720,1569,3,25,1,2973.60,NULL,'2022-11-14 11:24:55','2022-11-14 11:24:55',NULL),(592,8087,112,40720,1569,3,72,1,712.74,NULL,'2022-11-14 11:24:55','2022-11-14 11:24:55',NULL),(593,8087,112,40720,1569,3,251,1,54.06,NULL,'2022-11-14 11:24:55','2022-11-14 11:24:55',NULL),(594,8087,112,40720,1569,3,252,1,5765.60,NULL,'2022-11-14 11:24:55','2022-11-14 11:24:55',NULL),(595,8087,112,40720,1569,3,116,1,6000.00,NULL,'2022-11-14 11:24:55','2022-11-14 11:24:55',NULL),(596,8087,112,40720,1569,3,193,1,4223.90,NULL,'2022-11-14 11:24:55','2022-11-14 11:24:55',NULL),(597,8087,112,40720,1569,3,484,1,5756.32,NULL,'2022-11-14 11:24:55','2022-11-14 11:24:55',NULL),(598,8087,112,40720,1569,3,135,1,4658.35,NULL,'2022-11-14 11:24:55','2022-11-14 11:24:55',NULL),(599,8087,112,40720,1569,3,128,1,10980.13,NULL,'2022-11-14 11:24:55','2022-11-14 11:24:55',NULL),(600,8087,112,40720,1569,3,359,2,460146.80,NULL,'2022-11-14 11:24:55','2022-11-14 11:24:55',NULL),(601,8087,112,40720,1569,3,57,2,342501.84,NULL,'2022-11-14 11:24:55','2022-11-14 11:24:55',NULL),(602,8087,113,40720,1569,2,359,1,1054175.05,NULL,'2022-11-14 11:26:48','2022-11-14 11:26:48',NULL);
INSERT INTO `balance_libro_details` VALUES (603,8087,113,40720,1569,2,489,1,8728.64,NULL,'2022-11-14 11:26:48','2022-11-14 11:26:48',NULL),(604,8087,113,40720,1569,2,23,1,1339.10,NULL,'2022-11-14 11:26:48','2022-11-14 11:26:48',NULL),(605,8087,113,40720,1569,2,67,2,184703.29,NULL,'2022-11-14 11:26:48','2022-11-14 11:26:48',NULL),(606,8087,113,40720,1569,2,96,2,879539.50,NULL,'2022-11-14 11:26:48','2022-11-14 11:26:48',NULL),(607,8087,114,40720,1569,5,157,1,7300.46,NULL,'2022-11-14 12:07:27','2022-11-14 12:07:27',NULL),(608,8087,114,40720,1569,5,396,1,322966.92,NULL,'2022-11-14 12:07:27','2022-11-14 12:07:27',NULL),(609,8087,114,40720,1569,5,252,1,29.10,NULL,'2022-11-14 12:07:27','2022-11-14 12:07:27',NULL),(610,8087,114,40720,1569,5,276,1,1312.30,NULL,'2022-11-14 12:07:27','2022-11-14 12:07:27',NULL),(611,8087,114,40720,1569,5,214,1,6650.44,NULL,'2022-11-14 12:07:27','2022-11-14 12:07:27',NULL),(612,8087,114,40720,1569,5,474,1,656168.84,NULL,'2022-11-14 12:07:27','2022-11-14 12:07:27',NULL),(613,8087,114,40720,1569,5,359,1,126700.68,NULL,'2022-11-14 12:07:27','2022-11-14 12:07:27',NULL),(614,8087,114,40720,1569,5,474,2,464959.90,NULL,'2022-11-14 12:07:27','2022-11-14 12:07:27',NULL),(615,8087,114,40720,1569,5,359,2,656168.84,NULL,'2022-11-14 12:07:27','2022-11-14 12:07:27',NULL),(616,8087,115,40720,1570,21,62,1,84034.02,NULL,'2022-11-14 12:09:41','2022-11-14 12:09:41',NULL),(617,8087,115,40720,1570,21,474,2,84034.02,NULL,'2022-11-14 12:09:41','2022-11-14 12:09:41',NULL),(618,8087,116,40720,1570,19,483,1,30000.00,NULL,'2022-11-14 12:10:45','2022-11-14 12:10:45',NULL),(619,8087,116,40720,1570,19,474,2,30000.00,NULL,'2022-11-14 12:10:45','2022-11-14 12:10:45',NULL),(620,8087,117,40720,1570,10,63,1,25560.69,NULL,'2022-11-14 12:12:28','2022-11-14 12:12:28',NULL),(621,8087,117,40720,1570,10,64,1,2000.00,NULL,'2022-11-14 12:12:28','2022-11-14 12:12:28',NULL),(622,8087,117,40720,1570,10,474,2,25560.69,NULL,'2022-11-14 12:12:28','2022-11-14 12:12:28',NULL),(623,8087,117,40720,1570,10,359,2,2000.00,NULL,'2022-11-14 12:12:28','2022-11-14 12:12:28',NULL),(624,8087,118,40720,1570,15,67,1,184703.29,NULL,'2022-11-14 12:15:12','2022-11-14 12:15:12',NULL),(625,8087,118,40720,1570,15,68,2,135080.69,NULL,'2022-11-14 12:15:12','2022-11-14 12:15:12',NULL),(626,8087,118,40720,1570,15,25,2,2973.60,NULL,'2022-11-14 12:15:12','2022-11-14 12:15:12',NULL),(627,8087,118,40720,1570,15,72,2,712.74,NULL,'2022-11-14 12:15:12','2022-11-14 12:15:12',NULL),(628,8087,118,40720,1570,15,74,2,45936.26,NULL,'2022-11-14 12:15:12','2022-11-14 12:15:12',NULL),(629,8087,119,40720,1570,10,74,1,45936.26,NULL,'2022-11-14 12:17:26','2022-11-14 12:17:26',NULL),(630,8087,119,40720,1570,10,488,1,559.31,NULL,'2022-11-14 12:17:26','2022-11-14 12:17:26',NULL),(631,8087,119,40720,1570,10,474,2,46495.57,NULL,'2022-11-14 12:17:26','2022-11-14 12:17:26',NULL),(632,8087,120,40720,1570,10,156,1,28816.68,NULL,'2022-11-14 12:20:15','2022-11-14 12:20:15',NULL),(633,8087,120,40720,1570,10,251,2,54.06,NULL,'2022-11-14 12:20:15','2022-11-14 12:20:15',NULL),(634,8087,120,40720,1570,10,252,2,5495.15,NULL,'2022-11-14 12:20:15','2022-11-14 12:20:15',NULL),(635,8087,120,40720,1570,10,276,2,1312.30,NULL,'2022-11-14 12:20:15','2022-11-14 12:20:15',NULL),(636,8087,120,40720,1570,10,489,2,8728.64,NULL,'2022-11-14 12:20:15','2022-11-14 12:20:15',NULL),(637,8087,120,40720,1570,10,474,2,13226.53,NULL,'2022-11-14 12:20:15','2022-11-14 12:20:15',NULL),(638,8087,121,40720,1570,1,110,1,106017.44,NULL,'2022-11-14 12:21:53','2022-11-14 12:21:53',NULL),(639,8087,121,40720,1570,1,191,1,17492.69,NULL,'2022-11-14 12:21:53','2022-11-14 12:21:53',NULL),(640,8087,121,40720,1570,1,63,2,29654.13,NULL,'2022-11-14 12:21:53','2022-11-14 12:21:53',NULL),(641,8087,121,40720,1570,1,62,2,91856.00,NULL,'2022-11-14 12:21:53','2022-11-14 12:21:53',NULL),(642,8087,121,40720,1570,1,64,2,2000.00,NULL,'2022-11-14 12:21:53','2022-11-14 12:21:53',NULL),(643,8087,122,40720,1570,3,392,1,388565.27,NULL,'2022-11-14 13:11:22','2022-11-14 13:11:22',NULL);
INSERT INTO `balance_libro_details` VALUES (644,8087,122,40720,1570,3,68,1,84536.38,NULL,'2022-11-14 13:11:22','2022-11-14 13:11:22',NULL),(645,8087,122,40720,1570,3,25,1,2362.14,NULL,'2022-11-14 13:11:22','2022-11-14 13:11:22',NULL),(646,8087,122,40720,1570,3,72,1,313.46,NULL,'2022-11-14 13:11:22','2022-11-14 13:11:22',NULL),(647,8087,122,40720,1570,3,251,1,34.16,NULL,'2022-11-14 13:11:22','2022-11-14 13:11:22',NULL),(648,8087,122,40720,1570,3,252,1,3109.17,NULL,'2022-11-14 13:11:22','2022-11-14 13:11:22',NULL),(649,8087,122,40720,1570,3,116,1,3000.00,NULL,'2022-11-14 13:11:22','2022-11-14 13:11:22',NULL),(650,8087,122,40720,1570,3,193,1,6121.23,NULL,'2022-11-14 13:11:22','2022-11-14 13:11:22',NULL),(651,8087,122,40720,1570,3,484,1,3307.07,NULL,'2022-11-14 13:11:22','2022-11-14 13:11:22',NULL),(652,8087,122,40720,1570,3,135,1,2245.00,NULL,'2022-11-14 13:11:22','2022-11-14 13:11:22',NULL),(653,8087,122,40720,1570,3,128,1,9764.35,NULL,'2022-11-14 13:11:22','2022-11-14 13:11:22',NULL),(654,8087,122,40720,1570,3,485,1,1343.89,NULL,'2022-11-14 13:11:22','2022-11-14 13:11:22',NULL),(655,8087,122,40720,1570,3,359,2,206258.40,NULL,'2022-11-14 13:11:22','2022-11-14 13:11:22',NULL),(656,8087,122,40720,1570,3,57,2,298443.72,NULL,'2022-11-14 13:11:22','2022-11-14 13:11:22',NULL),(657,8087,123,40720,1570,2,359,1,880799.30,NULL,'2022-11-14 13:21:24','2022-11-14 13:21:24',NULL),(658,8087,123,40720,1570,2,489,1,8652.50,NULL,'2022-11-14 13:21:24','2022-11-14 13:21:24',NULL),(659,8087,123,40720,1570,2,23,1,1085.14,NULL,'2022-11-14 13:21:24','2022-11-14 13:21:24',NULL),(660,8087,123,40720,1570,2,67,2,154556.00,NULL,'2022-11-14 13:21:24','2022-11-14 13:21:24',NULL),(661,8087,123,40720,1570,2,96,2,735980.94,NULL,'2022-11-14 13:21:24','2022-11-14 13:21:24',NULL),(662,8087,124,40720,1570,5,157,1,5657.40,NULL,'2022-11-14 13:24:28','2022-11-14 13:24:28',NULL),(663,8087,124,40720,1570,5,396,1,148522.54,NULL,'2022-11-14 13:24:28','2022-11-14 13:24:28',NULL),(664,8087,124,40720,1570,5,276,1,1197.95,NULL,'2022-11-14 13:24:28','2022-11-14 13:24:28',NULL),(665,8087,124,40720,1570,5,252,1,29.10,NULL,'2022-11-14 13:24:28','2022-11-14 13:24:28',NULL),(666,8087,124,40720,1570,5,214,1,3068.33,NULL,'2022-11-14 13:24:28','2022-11-14 13:24:28',NULL),(667,8087,124,40720,1570,5,474,1,599522.00,NULL,'2022-11-14 13:24:28','2022-11-14 13:24:28',NULL),(668,8087,124,40720,1570,5,359,1,249901.00,NULL,'2022-11-14 13:24:28','2022-11-14 13:24:28',NULL),(669,8087,124,40720,1570,5,474,2,408376.32,NULL,'2022-11-14 13:24:28','2022-11-14 13:24:28',NULL),(670,8087,124,40720,1570,5,359,2,599522.00,NULL,'2022-11-14 13:24:28','2022-11-14 13:24:28',NULL),(671,8087,125,40720,1570,21,57,1,200000.00,NULL,'2022-11-14 13:25:33','2022-11-14 13:25:33',NULL),(672,8087,125,40720,1570,21,359,2,200000.00,NULL,'2022-11-14 13:25:33','2022-11-14 13:25:33',NULL),(673,8087,126,40720,1571,10,63,1,29654.13,NULL,'2022-11-14 13:29:56','2022-11-14 13:29:56',NULL),(674,8087,126,40720,1571,10,64,1,2000.00,NULL,'2022-11-14 13:29:56','2022-11-14 13:29:56',NULL),(675,8087,126,40720,1571,10,474,2,29654.13,NULL,'2022-11-14 13:29:56','2022-11-14 13:29:56',NULL),(676,8087,126,40720,1571,10,359,2,2000.00,NULL,'2022-11-14 13:29:56','2022-11-14 13:29:56',NULL),(677,8087,127,40720,1571,19,483,1,30000.00,NULL,'2022-11-14 13:30:45','2022-11-14 13:30:45',NULL),(678,8087,127,40720,1571,19,474,2,30000.00,NULL,'2022-11-14 13:30:45','2022-11-14 13:30:45',NULL),(679,8087,128,40720,1571,21,62,1,91856.00,NULL,'2022-11-14 13:32:19','2022-11-14 13:32:19',NULL),(680,8087,128,40720,1571,21,474,2,91856.00,NULL,'2022-11-14 13:32:19','2022-11-14 13:32:19',NULL),(681,8087,129,40720,1571,21,135,1,9691.44,NULL,'2022-11-14 13:34:43','2022-11-14 13:34:43',NULL),(682,8087,129,40720,1571,21,474,2,9691.44,NULL,'2022-11-14 13:34:43','2022-11-14 13:34:43',NULL),(683,8087,130,40720,1571,15,67,1,154556.00,NULL,'2022-11-14 13:37:12','2022-11-14 13:37:12',NULL),(684,8087,130,40720,1571,15,68,2,84536.38,NULL,'2022-11-14 13:37:12','2022-11-14 13:37:12',NULL);
INSERT INTO `balance_libro_details` VALUES (685,8087,130,40720,1571,15,25,2,2362.14,NULL,'2022-11-14 13:37:12','2022-11-14 13:37:12',NULL),(686,8087,130,40720,1571,15,72,2,313.46,NULL,'2022-11-14 13:37:12','2022-11-14 13:37:12',NULL),(687,8087,130,40720,1571,15,74,2,67344.02,NULL,'2022-11-14 13:37:12','2022-11-14 13:37:12',NULL),(688,8087,131,40720,1571,19,155,1,112098.59,NULL,'2022-11-14 14:09:28','2022-11-14 14:09:28',NULL),(689,8087,131,40720,1571,19,490,1,2332.12,NULL,'2022-11-14 14:09:28','2022-11-14 14:09:28',NULL),(690,8087,131,40720,1571,19,23,2,14301.15,NULL,'2022-11-14 14:09:28','2022-11-14 14:09:28',NULL),(691,8087,131,40720,1571,19,20,2,68366.29,NULL,'2022-11-14 14:09:28','2022-11-14 14:09:28',NULL),(692,8087,131,40720,1571,19,157,2,9289.00,NULL,'2022-11-14 14:09:28','2022-11-14 14:09:28',NULL),(693,8087,131,40720,1571,19,79,2,20142.15,NULL,'2022-11-14 14:09:28','2022-11-14 14:09:28',NULL),(694,8087,131,40720,1571,19,491,2,2332.12,NULL,'2022-11-14 14:09:28','2022-11-14 14:09:28',NULL),(695,8087,132,40720,1571,10,79,1,20142.15,NULL,'2022-11-14 14:14:13','2022-11-14 14:14:13',NULL),(696,8087,132,40720,1571,10,488,1,14099.97,NULL,'2022-11-14 14:14:13','2022-11-14 14:14:13',NULL),(697,8087,132,40720,1571,10,20,1,24449.36,NULL,'2022-11-14 14:14:13','2022-11-14 14:14:13',NULL),(698,8087,132,40720,1571,10,474,2,58691.48,NULL,'2022-11-14 14:14:13','2022-11-14 14:14:13',NULL),(699,8087,133,40720,1571,10,491,1,2332.12,NULL,'2022-11-14 14:16:00','2022-11-14 17:15:39','2022-11-14 17:15:39'),(700,8087,133,40720,1571,10,467,1,706.86,NULL,'2022-11-14 14:16:00','2022-11-14 17:15:39','2022-11-14 17:15:39'),(701,8087,133,40720,1571,10,474,2,3038.98,NULL,'2022-11-14 14:16:00','2022-11-14 17:15:39','2022-11-14 17:15:39'),(702,8087,134,40720,1571,10,20,1,16293.06,NULL,'2022-11-14 14:19:35','2022-11-14 17:16:29','2022-11-14 17:16:29'),(703,8087,134,40720,1571,10,467,1,4100.09,NULL,'2022-11-14 14:19:35','2022-11-14 17:16:29','2022-11-14 17:16:29'),(704,8087,134,40720,1571,10,474,2,20393.15,NULL,'2022-11-14 14:19:35','2022-11-14 17:16:29','2022-11-14 17:16:29'),(705,8087,135,40720,1571,10,156,1,24295.30,NULL,'2022-11-14 14:21:39','2022-11-14 14:21:39',NULL),(706,8087,135,40720,1571,10,489,2,8652.50,NULL,'2022-11-14 14:21:39','2022-11-14 14:21:39',NULL),(707,8087,135,40720,1571,10,276,2,1197.95,NULL,'2022-11-14 14:21:39','2022-11-14 14:21:39',NULL),(708,8087,135,40720,1571,10,251,2,34.16,NULL,'2022-11-14 14:21:39','2022-11-14 14:21:39',NULL),(709,8087,135,40720,1571,10,252,2,3109.17,NULL,'2022-11-14 14:21:39','2022-11-14 14:21:39',NULL),(710,8087,135,40720,1571,10,474,2,11301.52,NULL,'2022-11-14 14:21:39','2022-11-14 14:21:39',NULL),(711,8087,136,40720,1571,10,74,1,67344.02,NULL,'2022-11-14 14:23:55','2022-11-14 14:23:55',NULL),(712,8087,136,40720,1571,10,474,2,67344.02,NULL,'2022-11-14 14:23:55','2022-11-14 14:23:55',NULL),(713,8087,137,40720,1571,21,57,1,100000.00,NULL,'2022-11-14 14:25:20','2022-11-14 14:25:20',NULL),(714,8087,137,40720,1571,21,359,2,100000.00,NULL,'2022-11-14 14:25:20','2022-11-14 14:25:20',NULL),(715,8087,138,40720,1571,15,67,1,144822.80,NULL,'2022-11-14 14:27:02','2022-11-14 14:27:02',NULL),(716,8087,138,40720,1571,15,68,2,76654.89,NULL,'2022-11-14 14:27:02','2022-11-14 14:27:02',NULL),(717,8087,138,40720,1571,15,25,2,3500.38,NULL,'2022-11-14 14:27:02','2022-11-14 14:27:02',NULL),(718,8087,138,40720,1571,15,72,2,489.51,NULL,'2022-11-14 14:27:02','2022-11-14 14:27:02',NULL),(719,8087,138,40720,1571,15,74,2,64178.02,NULL,'2022-11-14 14:27:02','2022-11-14 14:27:02',NULL),(720,8087,139,40720,1571,16,156,1,22930.77,NULL,'2022-11-14 14:38:25','2022-11-14 14:38:25',NULL),(721,8087,139,40720,1571,16,489,2,8723.40,NULL,'2022-11-14 14:38:25','2022-11-14 14:38:25',NULL),(722,8087,139,40720,1571,16,251,2,76.38,NULL,'2022-11-14 14:38:25','2022-11-14 14:38:25',NULL),(723,8087,139,40720,1571,16,252,2,1514.59,NULL,'2022-11-14 14:38:25','2022-11-14 14:38:25',NULL),(724,8087,139,40720,1571,16,276,2,1300.27,NULL,'2022-11-14 14:38:25','2022-11-14 14:38:25',NULL);
INSERT INTO `balance_libro_details` VALUES (725,8087,139,40720,1571,16,78,2,7088.28,NULL,'2022-11-14 14:38:25','2022-11-14 14:38:25',NULL),(726,8087,139,40720,1571,16,492,2,4227.85,NULL,'2022-11-14 14:38:25','2022-11-14 14:38:25',NULL),(727,8087,140,40720,1571,21,62,1,106834.00,NULL,'2022-11-14 14:40:19','2022-11-14 14:40:19',NULL),(728,8087,140,40720,1571,21,474,2,106834.00,NULL,'2022-11-14 14:40:19','2022-11-14 14:40:19',NULL),(729,8087,141,40720,1571,1,110,1,158026.16,NULL,'2022-11-14 14:43:08','2022-11-14 14:43:08',NULL),(730,8087,141,40720,1571,1,191,1,25103.02,NULL,'2022-11-14 14:43:08','2022-11-14 14:43:08',NULL),(731,8087,141,40720,1571,1,63,2,44295.18,NULL,'2022-11-14 14:43:08','2022-11-14 14:43:08',NULL),(732,8087,141,40720,1571,1,62,2,136834.00,NULL,'2022-11-14 14:43:08','2022-11-14 14:43:08',NULL),(733,8087,141,40720,1571,1,64,2,2000.00,NULL,'2022-11-14 14:43:08','2022-11-14 14:43:08',NULL),(734,8087,142,40720,1571,3,392,1,351069.08,NULL,'2022-11-14 14:50:46','2022-11-14 14:50:46',NULL),(735,8087,142,40720,1571,3,68,1,76654.89,NULL,'2022-11-14 14:50:46','2022-11-14 14:50:46',NULL),(736,8087,142,40720,1571,3,25,1,3500.38,NULL,'2022-11-14 14:50:46','2022-11-14 14:50:46',NULL),(737,8087,142,40720,1571,3,72,1,489.51,NULL,'2022-11-14 14:50:46','2022-11-14 14:50:46',NULL),(738,8087,142,40720,1571,3,251,1,76.38,NULL,'2022-11-14 14:50:46','2022-11-14 14:50:46',NULL),(739,8087,142,40720,1571,3,252,1,1514.59,NULL,'2022-11-14 14:50:46','2022-11-14 14:50:46',NULL),(740,8087,142,40720,1571,3,193,1,6212.11,NULL,'2022-11-14 14:50:46','2022-11-14 14:50:46',NULL),(741,8087,142,40720,1571,3,484,1,6194.35,NULL,'2022-11-14 14:50:46','2022-11-14 14:50:46',NULL),(742,8087,142,40720,1571,3,135,1,1536.77,NULL,'2022-11-14 14:50:46','2022-11-14 14:50:46',NULL),(743,8087,142,40720,1571,3,128,1,8756.58,NULL,'2022-11-14 14:50:46','2022-11-14 14:50:46',NULL),(744,8087,142,40720,1571,3,485,1,1487.60,NULL,'2022-11-14 14:50:46','2022-11-14 14:50:46',NULL),(745,8087,142,40720,1571,3,57,2,302550.58,NULL,'2022-11-14 14:50:46','2022-11-14 14:50:46',NULL),(746,8087,142,40720,1571,3,359,2,154941.66,NULL,'2022-11-14 14:50:46','2022-11-14 14:50:46',NULL),(747,8087,143,40720,1571,2,359,1,824396.21,NULL,'2022-11-14 14:52:49','2022-11-14 14:52:49',NULL),(748,8087,143,40720,1571,2,489,1,8723.40,NULL,'2022-11-14 14:52:49','2022-11-14 14:52:49',NULL),(749,8087,143,40720,1571,2,23,1,1335.61,NULL,'2022-11-14 14:52:49','2022-11-14 14:52:49',NULL),(750,8087,143,40720,1571,2,67,2,144822.81,NULL,'2022-11-14 14:52:49','2022-11-14 14:52:49',NULL),(751,8087,143,40720,1571,2,96,2,689632.41,NULL,'2022-11-14 14:52:49','2022-11-14 14:52:49',NULL),(752,8087,144,40720,1571,5,157,1,8306.44,NULL,'2022-11-14 14:56:40','2022-11-14 14:56:40',NULL),(753,8087,144,40720,1571,5,396,1,2791.47,NULL,'2022-11-14 14:56:40','2022-11-14 14:56:40',NULL),(754,8087,144,40720,1571,5,252,1,29.10,NULL,'2022-11-14 14:56:40','2022-11-14 14:56:40',NULL),(755,8087,144,40720,1571,5,276,1,1300.27,NULL,'2022-11-14 14:56:40','2022-11-14 14:56:40',NULL),(756,8087,144,40720,1571,5,214,1,7222.00,NULL,'2022-11-14 14:56:40','2022-11-14 14:56:40',NULL),(757,8087,144,40720,1571,5,474,1,650137.48,NULL,'2022-11-14 14:56:40','2022-11-14 14:56:40',NULL),(758,8087,144,40720,1571,5,359,1,426020.81,NULL,'2022-11-14 14:56:40','2022-11-14 14:56:40',NULL),(759,8087,144,40720,1571,5,474,2,445670.09,NULL,'2022-11-14 14:56:40','2022-11-14 14:56:40',NULL),(760,8087,144,40720,1571,5,359,2,650137.48,NULL,'2022-11-14 14:56:40','2022-11-14 14:56:40',NULL),(761,8087,145,40720,1571,19,20,1,57025.71,NULL,'2022-11-14 15:00:31','2022-11-14 15:00:31',NULL),(762,8087,145,40720,1571,19,487,2,57025.71,NULL,'2022-11-14 15:00:31','2022-11-14 15:00:31',NULL),(763,8087,146,40720,1571,4,132,1,10132.65,NULL,'2022-11-14 15:07:47','2022-11-14 15:07:47',NULL),(764,8087,146,40720,1571,4,48,2,10132.65,NULL,'2022-11-14 15:07:47','2022-11-14 15:07:47',NULL),(765,8087,147,40720,1571,19,135,1,3161.32,NULL,'2022-11-14 15:11:52','2022-11-21 09:16:37','2022-11-21 09:16:37');
INSERT INTO `balance_libro_details` VALUES (766,8087,147,40720,1571,19,68,2,3161.32,NULL,'2022-11-14 15:11:52','2022-11-21 09:16:37','2022-11-21 09:16:37'),(767,8087,148,40720,1571,19,493,1,4111075.77,NULL,'2022-11-14 15:39:39','2023-01-02 16:27:17','2023-01-02 16:27:17'),(768,8087,148,40720,1571,19,392,2,4111075.77,NULL,'2022-11-14 15:39:39','2023-01-02 16:27:17','2023-01-02 16:27:17'),(769,8087,149,40720,1568,2,359,1,857689.08,NULL,'2022-11-14 16:15:32','2022-11-14 16:15:32',NULL),(770,8087,149,40720,1568,2,489,1,8265.41,NULL,'2022-11-14 16:15:32','2022-11-14 16:15:32',NULL),(771,8087,149,40720,1568,2,23,1,1030.27,NULL,'2022-11-14 16:15:32','2022-11-14 16:15:32',NULL),(772,8087,149,40720,1568,2,67,2,150468.43,NULL,'2022-11-14 16:15:32','2022-11-14 16:15:32',NULL),(773,8087,149,40720,1568,2,96,2,716516.33,NULL,'2022-11-14 16:15:32','2022-11-14 16:15:32',NULL),(774,8087,150,40720,1560,2,359,1,813526.59,NULL,'2022-11-14 16:58:44','2022-11-14 16:58:44',NULL),(775,8087,150,40720,1560,2,23,1,861.79,NULL,'2022-11-14 16:58:44','2022-11-14 16:58:44',NULL),(776,8087,150,40720,1560,2,67,2,142305.91,NULL,'2022-11-14 16:58:44','2022-11-14 16:58:44',NULL),(777,8087,150,40720,1560,2,96,2,677647.20,NULL,'2022-11-14 16:58:44','2022-11-14 16:58:44',NULL),(778,8087,150,40720,1560,2,489,1,5564.73,NULL,'2022-11-14 16:58:44','2022-11-14 16:58:44',NULL),(779,8087,151,40720,1560,10,487,1,5696.62,NULL,'2022-11-14 17:13:10','2022-11-14 17:13:10',NULL),(780,8087,151,40720,1560,10,488,1,5.69,NULL,'2022-11-14 17:13:10','2022-11-14 17:13:10',NULL),(781,8087,151,40720,1560,10,474,2,5702.31,NULL,'2022-11-14 17:13:10','2022-11-14 17:13:10',NULL),(782,8087,152,40720,1571,10,491,1,2332.12,NULL,'2022-11-14 17:15:39','2022-11-14 17:15:39',NULL),(783,8087,152,40720,1571,10,488,1,706.86,NULL,'2022-11-14 17:15:39','2022-11-14 17:15:39',NULL),(784,8087,152,40720,1571,10,474,2,3038.98,NULL,'2022-11-14 17:15:39','2022-11-14 17:15:39',NULL),(785,8087,153,40720,1571,10,20,1,16293.06,NULL,'2022-11-14 17:16:29','2022-11-14 17:16:29',NULL),(786,8087,153,40720,1571,10,488,1,4100.09,NULL,'2022-11-14 17:16:29','2022-11-14 17:16:29',NULL),(787,8087,153,40720,1571,10,474,2,20393.15,NULL,'2022-11-14 17:16:29','2022-11-14 17:16:29',NULL),(788,8087,154,40720,1561,15,67,1,142305.91,NULL,'2022-11-14 17:25:54','2022-11-14 17:25:54',NULL),(789,8087,154,40720,1561,15,68,2,75013.56,NULL,'2022-11-14 17:25:54','2022-11-14 17:25:54',NULL),(790,8087,154,40720,1561,15,74,2,65237.38,NULL,'2022-11-14 17:25:54','2022-11-14 17:25:54',NULL),(791,8087,154,40720,1561,15,25,2,2054.97,NULL,'2022-11-14 17:25:54','2022-11-14 17:25:54',NULL),(792,8087,155,40720,1562,15,67,1,122830.83,NULL,'2022-11-14 17:27:45','2022-11-14 17:27:45',NULL),(793,8087,155,40720,1562,15,72,2,54.80,NULL,'2022-11-14 17:27:45','2022-11-14 17:27:45',NULL),(794,8087,155,40720,1562,15,68,2,85070.02,NULL,'2022-11-14 17:27:45','2022-11-14 17:27:45',NULL),(795,8087,155,40720,1562,15,474,2,35964.31,NULL,'2022-11-14 17:27:45','2022-11-14 17:27:45',NULL),(796,8087,155,40720,1562,15,25,2,1741.70,NULL,'2022-11-14 17:27:45','2022-11-14 17:27:45',NULL),(797,8087,156,40720,1571,19,135,1,16007.38,NULL,'2022-11-21 09:16:37','2022-11-21 09:16:37',NULL),(798,8087,156,40720,1571,19,68,2,3161.32,NULL,'2022-11-21 09:16:37','2022-11-21 09:16:37',NULL),(799,8087,156,40720,1571,19,251,2,10978.49,NULL,'2022-11-21 09:16:37','2022-11-21 09:16:37',NULL),(800,8087,156,40720,1571,19,252,2,1867.57,NULL,'2022-11-21 09:16:37','2022-11-21 09:16:37',NULL),(801,8087,157,40720,1571,23,383,2,341144.28,NULL,'2022-11-21 11:29:44','2022-11-21 12:19:52','2022-11-21 12:19:52'),(802,8087,157,40720,1571,23,392,1,1321024.05,NULL,'2022-11-21 11:29:44','2022-11-21 12:19:52','2022-11-21 12:19:52'),(803,8087,157,40720,1571,23,396,1,561911.60,NULL,'2022-11-21 11:29:44','2022-11-21 12:19:52','2022-11-21 12:19:52'),(804,8087,157,40720,1571,23,191,1,44426.30,NULL,'2022-11-21 11:29:44','2022-11-21 12:19:52','2022-11-21 12:19:52');
INSERT INTO `balance_libro_details` VALUES (805,8087,157,40720,1571,23,485,1,538.46,NULL,'2022-11-21 11:29:45','2022-11-21 12:19:52','2022-11-21 12:19:52'),(806,8087,157,40720,1571,23,135,1,33718.24,NULL,'2022-11-21 11:29:45','2022-11-21 12:19:52','2022-11-21 12:19:52'),(807,8087,157,40720,1571,23,193,1,6449.07,NULL,'2022-11-21 11:29:45','2022-11-21 12:19:52','2022-11-21 12:19:52'),(808,8087,157,40720,1571,23,381,2,5211.50,NULL,'2022-11-21 11:29:45','2022-11-21 12:19:52','2022-11-21 12:19:52'),(809,8087,157,40720,1571,23,363,1,75287.80,NULL,'2022-11-21 11:29:45','2022-11-21 12:19:52','2022-11-21 12:19:52'),(810,8087,157,40720,1571,23,214,1,17029.27,NULL,'2022-11-21 11:29:45','2022-11-21 12:19:52','2022-11-21 12:19:52'),(811,8087,157,40720,1571,23,157,1,13743.04,NULL,'2022-11-21 11:29:45','2022-11-21 12:19:52','2022-11-21 12:19:52'),(812,8087,157,40720,1571,23,110,1,230535.27,NULL,'2022-11-21 11:29:46','2022-11-21 12:19:52','2022-11-21 12:19:52'),(813,8087,157,40720,1571,23,128,1,20093.94,NULL,'2022-11-21 11:29:46','2022-11-21 12:19:52','2022-11-21 12:19:52'),(814,8087,157,40720,1571,23,484,1,9025.50,NULL,'2022-11-21 11:29:46','2022-11-21 12:19:52','2022-11-21 12:19:52'),(815,8087,157,40720,1571,23,88,2,29692.75,NULL,'2022-11-21 11:29:46','2022-11-21 12:19:52','2022-11-21 12:19:52'),(816,8087,157,40720,1571,23,156,1,50676.61,NULL,'2022-11-21 11:29:46','2022-11-21 12:19:52','2022-11-21 12:19:52'),(817,8087,157,40720,1571,23,96,2,1910693.18,NULL,'2022-11-21 11:29:46','2022-11-21 12:19:52','2022-11-21 12:19:52'),(818,8087,157,40720,1571,23,276,1,385.28,NULL,'2022-11-21 11:29:46','2022-11-21 12:19:52','2022-11-21 12:19:52'),(819,8087,157,40720,1571,23,116,1,5465.18,NULL,'2022-11-21 11:29:46','2022-11-21 12:19:52','2022-11-21 12:19:52'),(820,8087,157,40720,1571,23,488,1,400.99,NULL,'2022-11-21 11:29:47','2022-11-21 12:19:52','2022-11-21 12:19:52'),(821,8087,157,40720,1571,23,476,2,103968.89,NULL,'2022-11-21 11:29:47','2022-11-21 12:19:52','2022-11-21 12:19:52'),(822,8087,158,40720,1571,23,392,1,1321024.05,NULL,'2022-11-21 12:22:08','2023-01-02 15:30:17','2023-01-02 15:30:17'),(823,8087,158,40720,1571,23,396,1,561911.60,NULL,'2022-11-21 12:22:08','2023-01-02 15:30:17','2023-01-02 15:30:17'),(824,8087,158,40720,1571,23,191,1,44426.30,NULL,'2022-11-21 12:22:08','2023-01-02 15:30:17','2023-01-02 15:30:17'),(825,8087,158,40720,1571,23,485,1,538.46,NULL,'2022-11-21 12:22:08','2023-01-02 15:30:17','2023-01-02 15:30:17'),(826,8087,158,40720,1571,23,135,1,33718.24,NULL,'2022-11-21 12:22:08','2023-01-02 15:30:17','2023-01-02 15:30:17'),(827,8087,158,40720,1571,23,193,1,6449.07,NULL,'2022-11-21 12:22:08','2023-01-02 15:30:17','2023-01-02 15:30:17'),(828,8087,158,40720,1571,23,381,2,5211.50,NULL,'2022-11-21 12:22:08','2023-01-02 15:30:17','2023-01-02 15:30:17'),(829,8087,158,40720,1571,23,363,1,75287.80,NULL,'2022-11-21 12:22:08','2023-01-02 15:30:17','2023-01-02 15:30:17'),(830,8087,158,40720,1571,23,214,1,17029.27,NULL,'2022-11-21 12:22:08','2023-01-02 15:30:17','2023-01-02 15:30:17'),(831,8087,158,40720,1571,23,157,1,13743.04,NULL,'2022-11-21 12:22:09','2023-01-02 15:30:17','2023-01-02 15:30:17'),(832,8087,158,40720,1571,23,110,1,230535.27,NULL,'2022-11-21 12:22:09','2023-01-02 15:30:17','2023-01-02 15:30:17'),(833,8087,158,40720,1571,23,128,1,20093.94,NULL,'2022-11-21 12:22:09','2023-01-02 15:30:17','2023-01-02 15:30:17'),(834,8087,158,40720,1571,23,484,1,9025.50,NULL,'2022-11-21 12:22:09','2023-01-02 15:30:17','2023-01-02 15:30:17'),(835,8087,158,40720,1571,23,88,2,29692.75,NULL,'2022-11-21 12:22:09','2023-01-02 15:30:17','2023-01-02 15:30:17'),(836,8087,158,40720,1571,23,383,2,341144.28,NULL,'2022-11-21 12:22:09','2023-01-02 15:30:17','2023-01-02 15:30:17'),(837,8087,158,40720,1571,23,156,1,50676.61,NULL,'2022-11-21 12:22:09','2023-01-02 15:30:17','2023-01-02 15:30:17'),(838,8087,158,40720,1571,23,96,2,1910693.18,NULL,'2022-11-21 12:22:09','2023-01-02 15:30:17','2023-01-02 15:30:17');
INSERT INTO `balance_libro_details` VALUES (839,8087,158,40720,1571,23,116,1,5465.18,NULL,'2022-11-21 12:22:09','2023-01-02 15:30:17','2023-01-02 15:30:17'),(840,8087,158,40720,1571,23,488,1,400.99,NULL,'2022-11-21 12:22:09','2023-01-02 15:30:17','2023-01-02 15:30:17'),(841,8087,158,40720,1571,23,476,2,103583.61,NULL,'2022-11-21 12:22:10','2023-01-02 15:30:17','2023-01-02 15:30:17'),(842,8087,159,40720,1575,12,359,1,930130.93,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(843,8087,159,40720,1575,12,474,1,55986.31,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(844,8087,159,40720,1575,12,20,1,97768.13,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(845,8087,159,40720,1575,12,23,1,19459.68,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(846,8087,159,40720,1575,12,482,1,772600.00,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(847,8087,159,40720,1575,12,483,1,565000.00,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(848,8087,159,40720,1575,12,392,1,1300000.00,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(849,8087,159,40720,1575,12,363,1,155336.42,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(850,8087,159,40720,1575,12,48,2,10132.65,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(851,8087,159,40720,1575,12,57,2,2140663.27,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(852,8087,159,40720,1575,12,74,2,64178.02,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(853,8087,159,40720,1575,12,78,2,7088.28,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(854,8087,159,40720,1575,12,492,2,4227.85,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(855,8087,159,40720,1575,12,63,2,44295.18,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(856,8087,159,40720,1575,12,64,2,2000.00,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(857,8087,159,40720,1575,12,62,2,30000.00,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(858,8087,159,40720,1575,12,486,2,925000.00,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(859,8087,159,40720,1575,12,487,2,57025.71,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(860,8087,159,40720,1575,12,369,2,60000.00,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(861,8087,159,40720,1575,12,381,2,10530.86,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(862,8087,159,40720,1575,12,494,2,91.02,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(863,8087,159,40720,1575,12,383,2,541048.63,NULL,'2022-11-22 18:45:35','2023-01-06 12:48:43','2023-01-06 12:48:43'),(864,8087,160,40720,1575,10,63,1,44295.18,NULL,'2022-11-22 18:49:54','2022-11-22 18:49:54',NULL),(865,8087,160,40720,1575,10,64,1,2000.00,NULL,'2022-11-22 18:49:54','2022-11-22 18:49:54',NULL),(866,8087,160,40720,1575,10,474,2,44295.18,NULL,'2022-11-22 18:49:54','2022-11-22 18:49:54',NULL),(867,8087,160,40720,1575,10,359,2,2000.00,NULL,'2022-11-22 18:49:54','2022-11-22 18:49:54',NULL),(868,8087,161,40720,1575,10,487,1,16293.06,NULL,'2022-11-22 18:53:16','2022-11-22 18:53:16',NULL),(869,8087,161,40720,1575,10,488,1,1620.34,NULL,'2022-11-22 18:53:16','2022-11-22 18:53:16',NULL),(870,8087,161,40720,1575,10,474,2,17913.40,NULL,'2022-11-22 18:53:16','2022-11-22 18:53:16',NULL),(871,8087,162,40720,1575,21,62,1,30000.00,NULL,'2022-11-22 18:59:21','2022-11-22 18:59:21',NULL),(872,8087,162,40720,1575,21,474,2,30000.00,NULL,'2022-11-22 18:59:21','2022-11-22 18:59:21',NULL),(873,8087,163,40720,1575,10,74,1,64178.02,NULL,'2022-11-22 19:01:27','2022-11-22 19:01:27',NULL),(874,8087,163,40720,1575,10,474,2,64178.02,NULL,'2022-11-22 19:01:27','2022-11-22 19:01:27',NULL);
INSERT INTO `balance_libro_details` VALUES (875,8087,164,40720,1575,10,78,1,7088.28,NULL,'2022-11-22 19:06:08','2022-11-22 19:06:08',NULL),(876,8087,164,40720,1575,10,492,1,4227.85,NULL,'2022-11-22 19:06:08','2022-11-22 19:06:08',NULL),(877,8087,164,40720,1575,10,474,2,11316.13,NULL,'2022-11-22 19:06:08','2022-11-22 19:06:08',NULL),(878,8087,165,40720,1575,10,487,1,16293.06,NULL,'2022-11-22 19:07:27','2022-11-22 19:07:27',NULL),(879,8087,165,40720,1575,10,488,1,1427.61,NULL,'2022-11-22 19:07:27','2022-11-22 19:07:27',NULL),(880,8087,165,40720,1575,10,474,2,17720.67,NULL,'2022-11-22 19:07:27','2022-11-22 19:07:27',NULL),(881,8087,166,40720,1575,19,483,1,45000.00,NULL,'2022-11-22 19:08:44','2022-11-22 19:08:44',NULL),(882,8087,166,40720,1575,19,474,2,45000.00,NULL,'2022-11-22 19:08:44','2022-11-22 19:08:44',NULL),(883,8087,167,40720,1575,2,359,1,1081664.51,NULL,'2022-11-22 19:11:24','2022-11-22 19:11:24',NULL),(884,8087,167,40720,1575,2,489,1,2705.42,NULL,'2022-11-22 19:11:24','2022-11-22 19:11:24',NULL),(885,8087,167,40720,1575,2,67,2,188196.43,NULL,'2022-11-22 19:11:24','2022-11-22 19:11:24',NULL),(886,8087,167,40720,1575,2,96,2,896173.50,NULL,'2022-11-22 19:11:24','2022-11-22 19:11:24',NULL),(887,8087,168,40720,1575,3,392,1,839685.94,NULL,'2022-11-22 19:27:24','2022-11-22 19:27:24',NULL),(888,8087,168,40720,1575,3,68,1,178788.27,NULL,'2022-11-22 19:27:24','2022-11-22 19:27:24',NULL),(889,8087,168,40720,1575,3,494,1,781.00,NULL,'2022-11-22 19:27:24','2022-11-22 19:27:24',NULL),(890,8087,168,40720,1575,3,25,1,2402.10,NULL,'2022-11-22 19:27:24','2022-11-22 19:27:24',NULL),(891,8087,168,40720,1575,3,496,1,76.41,NULL,'2022-11-22 19:27:24','2022-11-22 19:27:24',NULL),(892,8087,168,40720,1575,3,495,1,5180.12,NULL,'2022-11-22 19:27:24','2022-11-22 19:27:24',NULL),(893,8087,168,40720,1575,3,116,1,16225.00,NULL,'2022-11-22 19:27:24','2022-11-22 19:27:24',NULL),(894,8087,168,40720,1575,3,484,1,6733.83,NULL,'2022-11-22 19:27:24','2022-11-22 19:27:24',NULL),(895,8087,168,40720,1575,3,135,1,457.21,NULL,'2022-11-22 19:27:24','2022-11-22 19:27:24',NULL),(896,8087,168,40720,1575,3,128,1,5087.87,NULL,'2022-11-22 19:27:24','2022-11-22 19:27:24',NULL),(897,8087,168,40720,1575,3,485,1,514.80,NULL,'2022-11-22 19:27:24','2022-11-22 19:27:24',NULL),(898,8087,168,40720,1575,3,359,2,1055932.55,NULL,'2022-11-22 19:27:24','2022-11-22 19:27:24',NULL),(899,8087,169,40720,1575,1,110,1,120533.48,NULL,'2022-11-22 19:33:01','2022-11-22 19:33:01',NULL),(900,8087,169,40720,1575,1,191,1,20900.46,NULL,'2022-11-22 19:33:01','2022-11-22 19:33:01',NULL),(901,8087,169,40720,1575,1,63,2,35820.94,NULL,'2022-11-22 19:33:01','2022-11-22 19:33:01',NULL),(902,8087,169,40720,1575,1,62,2,103613.00,NULL,'2022-11-22 19:33:01','2022-11-22 19:33:01',NULL),(903,8087,169,40720,1575,1,64,2,2000.00,NULL,'2022-11-22 19:33:01','2022-11-22 19:33:01',NULL),(904,8087,170,40720,1575,5,157,1,6133.15,NULL,'2022-11-22 19:37:25','2022-11-24 08:47:09','2022-11-24 08:47:09'),(905,8087,170,40720,1575,5,396,1,3385.28,NULL,'2022-11-22 19:37:25','2022-11-24 08:47:09','2022-11-24 08:47:09'),(906,8087,170,40720,1575,5,209,1,12990.23,NULL,'2022-11-22 19:37:25','2022-11-24 08:47:09','2022-11-24 08:47:09'),(907,8087,170,40720,1575,5,214,1,3703.30,NULL,'2022-11-22 19:37:25','2022-11-24 08:47:09','2022-11-24 08:47:09'),(908,8087,170,40720,1575,5,474,1,721679.31,NULL,'2022-11-22 19:37:25','2022-11-24 08:47:09','2022-11-24 08:47:09'),(909,8087,170,40720,1575,5,359,1,186292.19,NULL,'2022-11-22 19:37:25','2022-11-24 08:47:09','2022-11-24 08:47:09'),(910,8087,170,40720,1575,5,474,2,212504.15,NULL,'2022-11-22 19:37:25','2022-11-24 08:47:09','2022-11-24 08:47:09'),(911,8087,170,40720,1575,5,359,2,721679.31,NULL,'2022-11-22 19:37:25','2022-11-24 08:47:09','2022-11-24 08:47:09'),(912,8087,171,40720,1576,21,62,1,103613.00,NULL,'2022-11-23 08:07:19','2022-11-23 08:07:19',NULL),(913,8087,171,40720,1576,21,474,2,103613.00,NULL,'2022-11-23 08:07:19','2022-11-23 08:07:19',NULL);
INSERT INTO `balance_libro_details` VALUES (914,8087,172,40720,1576,10,63,1,35820.94,NULL,'2022-11-23 08:12:20','2022-11-23 08:12:20',NULL),(915,8087,172,40720,1576,10,64,1,2000.00,NULL,'2022-11-23 08:12:20','2022-11-23 08:12:20',NULL),(916,8087,172,40720,1576,10,474,2,35820.94,NULL,'2022-11-23 08:12:20','2022-11-23 08:12:20',NULL),(917,8087,172,40720,1576,10,359,2,2000.00,NULL,'2022-11-23 08:12:20','2022-11-23 08:12:20',NULL),(918,8087,173,40720,1576,19,483,1,30000.00,NULL,'2022-11-23 08:14:20','2022-11-23 08:14:20',NULL),(919,8087,173,40720,1576,19,474,2,30000.00,NULL,'2022-11-23 08:14:20','2022-11-23 08:14:20',NULL),(920,8087,174,40720,1576,10,487,1,16293.06,NULL,'2022-11-23 08:21:04','2022-11-24 08:49:28','2022-11-24 08:49:28'),(921,8087,174,40720,1576,10,467,1,1518.02,NULL,'2022-11-23 08:21:04','2022-11-24 08:49:28','2022-11-24 08:49:28'),(922,8087,174,40720,1576,10,474,2,17811.08,NULL,'2022-11-23 08:21:04','2022-11-24 08:49:28','2022-11-24 08:49:28'),(923,8087,175,40720,1576,15,67,1,188196.43,NULL,'2022-11-23 08:27:58','2022-11-23 08:27:58',NULL),(924,8087,175,40720,1576,15,25,2,2402.10,NULL,'2022-11-23 08:27:58','2022-11-23 08:27:58',NULL),(925,8087,175,40720,1576,15,494,2,781.00,NULL,'2022-11-23 08:27:58','2022-11-23 08:27:58',NULL),(926,8087,175,40720,1576,15,68,2,178788.27,NULL,'2022-11-23 08:27:58','2022-11-23 08:27:58',NULL),(927,8087,175,40720,1576,15,74,2,6225.06,NULL,'2022-11-23 08:27:58','2022-11-23 08:27:58',NULL),(928,8087,176,40720,1576,10,156,1,29895.86,NULL,'2022-11-23 08:49:56','2022-11-23 11:10:44','2022-11-23 11:10:44'),(929,8087,176,40720,1576,10,251,2,76.41,NULL,'2022-11-23 08:49:56','2022-11-23 11:10:44','2022-11-23 11:10:44'),(930,8087,176,40720,1576,10,252,2,5180.12,NULL,'2022-11-23 08:49:56','2022-11-23 11:10:44','2022-11-23 11:10:44'),(931,8087,176,40720,1576,10,276,2,1530.26,NULL,'2022-11-23 08:49:56','2022-11-23 11:10:44','2022-11-23 11:10:44'),(932,8087,176,40720,1576,10,277,2,11459.97,NULL,'2022-11-23 08:49:56','2022-11-23 11:10:44','2022-11-23 11:10:44'),(933,8087,176,40720,1576,10,489,2,2705.42,NULL,'2022-11-23 08:49:56','2022-11-23 11:10:44','2022-11-23 11:10:44'),(934,8087,176,40720,1576,10,474,2,8943.68,NULL,'2022-11-23 08:49:56','2022-11-23 11:10:44','2022-11-23 11:10:44'),(935,8087,177,40720,1576,10,74,1,6225.06,NULL,'2022-11-23 08:51:26','2022-11-23 08:51:26',NULL),(936,8087,177,40720,1576,10,474,2,6225.06,NULL,'2022-11-23 08:51:26','2022-11-23 08:51:26',NULL),(937,8087,178,40720,1576,10,20,1,8146.53,NULL,'2022-11-23 08:58:17','2022-11-24 08:57:48','2022-11-24 08:57:48'),(938,8087,178,40720,1576,10,488,1,55.90,NULL,'2022-11-23 08:58:17','2022-11-24 08:57:48','2022-11-24 08:57:48'),(939,8087,178,40720,1576,10,474,2,8202.43,NULL,'2022-11-23 08:58:17','2022-11-24 08:57:48','2022-11-24 08:57:48'),(940,8087,179,40720,1576,3,392,1,329231.11,NULL,'2022-11-23 09:08:10','2022-11-23 11:15:25','2022-11-23 11:15:25'),(941,8087,179,40720,1576,3,68,1,72385.49,NULL,'2022-11-23 09:08:10','2022-11-23 11:15:25','2022-11-23 11:15:25'),(942,8087,179,40720,1576,3,494,1,378.25,NULL,'2022-11-23 09:08:10','2022-11-23 11:15:25','2022-11-23 11:15:25'),(943,8087,179,40720,1576,3,25,1,1751.60,NULL,'2022-11-23 09:08:10','2022-11-23 11:15:25','2022-11-23 11:15:25'),(944,8087,179,40720,1576,3,23,1,138.86,NULL,'2022-11-23 09:08:10','2022-11-23 11:15:25','2022-11-23 11:15:25'),(945,8087,179,40720,1576,3,251,1,22.23,NULL,'2022-11-23 09:08:10','2022-11-23 11:15:25','2022-11-23 11:15:25'),(946,8087,179,40720,1576,3,252,1,1052.14,NULL,'2022-11-23 09:08:10','2022-11-23 11:15:25','2022-11-23 11:15:25'),(947,8087,179,40720,1576,3,484,1,3915.73,NULL,'2022-11-23 09:08:10','2022-11-23 11:15:25','2022-11-23 11:15:25'),(948,8087,179,40720,1576,3,116,1,16225.00,NULL,'2022-11-23 09:08:10','2022-11-23 11:15:25','2022-11-23 11:15:25'),(949,8087,179,40720,1576,3,193,1,6847.60,NULL,'2022-11-23 09:08:10','2022-11-23 11:15:25','2022-11-23 11:15:25'),(950,8087,179,40720,1576,3,135,1,946.76,NULL,'2022-11-23 09:08:10','2022-11-23 11:15:25','2022-11-23 11:15:25');
INSERT INTO `balance_libro_details` VALUES (951,8087,179,40720,1576,3,128,1,10076.77,NULL,'2022-11-23 09:08:10','2022-11-23 11:15:25','2022-11-23 11:15:25'),(952,8087,179,40720,1576,3,485,1,487.60,NULL,'2022-11-23 09:08:10','2022-11-23 11:15:25','2022-11-23 11:15:25'),(953,8087,179,40720,1576,3,359,2,443459.14,NULL,'2022-11-23 09:08:10','2022-11-23 11:15:25','2022-11-23 11:15:25'),(954,8087,180,40720,1576,2,359,1,688968.21,NULL,'2022-11-23 09:09:32','2022-11-23 09:09:32',NULL),(955,8087,180,40720,1576,2,489,1,6636.20,NULL,'2022-11-23 09:09:32','2022-11-23 09:09:32',NULL),(956,8087,180,40720,1576,2,67,2,120724.73,NULL,'2022-11-23 09:09:32','2022-11-23 09:09:32',NULL),(957,8087,180,40720,1576,2,96,2,574879.68,NULL,'2022-11-23 09:09:32','2022-11-23 09:09:32',NULL),(958,8087,181,40720,1576,1,110,1,112899.52,NULL,'2022-11-23 09:43:58','2022-11-23 09:43:58',NULL),(959,8087,181,40720,1576,1,191,1,17542.60,NULL,'2022-11-23 09:43:58','2022-11-23 09:43:58',NULL),(960,8087,181,40720,1576,1,63,2,31292.12,NULL,'2022-11-23 09:43:58','2022-11-23 09:43:58',NULL),(961,8087,181,40720,1576,1,62,2,97150.00,NULL,'2022-11-23 09:43:58','2022-11-23 09:43:58',NULL),(962,8087,181,40720,1576,1,64,2,2000.00,NULL,'2022-11-23 09:43:58','2022-11-23 09:43:58',NULL),(963,8087,182,40720,1576,5,157,1,4978.51,NULL,'2022-11-23 09:50:08','2022-11-23 09:50:08',NULL),(964,8087,182,40720,1576,5,396,1,3373.18,NULL,'2022-11-23 09:50:08','2022-11-23 09:50:08',NULL),(965,8087,182,40720,1576,5,277,1,7537.37,NULL,'2022-11-23 09:50:08','2022-11-23 09:50:08',NULL),(966,8087,182,40720,1576,5,276,1,1218.88,NULL,'2022-11-23 09:50:08','2022-11-23 09:50:08',NULL),(967,8087,182,40720,1576,5,214,1,5831.43,NULL,'2022-11-23 09:50:08','2022-11-23 09:50:08',NULL),(968,8087,182,40720,1576,5,474,1,486458.20,NULL,'2022-11-23 09:50:08','2022-11-23 09:50:08',NULL),(969,8087,182,40720,1576,5,359,1,302364.36,NULL,'2022-11-23 09:50:08','2022-11-23 09:50:08',NULL),(970,8087,182,40720,1576,5,474,2,325303.73,NULL,'2022-11-23 09:50:08','2022-11-23 09:50:08',NULL),(971,8087,182,40720,1576,5,359,2,486458.20,NULL,'2022-11-23 09:50:08','2022-11-23 09:50:08',NULL),(972,8087,183,40720,1577,21,62,1,97150.00,NULL,'2022-11-23 09:51:23','2022-11-23 09:51:23',NULL),(973,8087,183,40720,1577,21,474,2,97150.00,NULL,'2022-11-23 09:51:23','2022-11-23 09:51:23',NULL),(974,8087,184,40720,1577,19,483,1,30000.00,NULL,'2022-11-23 10:01:32','2022-11-23 10:01:32',NULL),(975,8087,184,40720,1577,19,474,2,30000.00,NULL,'2022-11-23 10:01:32','2022-11-23 10:01:32',NULL),(976,8087,185,40720,1577,10,63,1,31292.12,NULL,'2022-11-23 10:03:26','2022-11-23 10:03:26',NULL),(977,8087,185,40720,1577,10,64,1,2000.00,NULL,'2022-11-23 10:03:26','2022-11-23 10:03:26',NULL),(978,8087,185,40720,1577,10,474,2,31292.12,NULL,'2022-11-23 10:03:26','2022-11-23 10:03:26',NULL),(979,8087,185,40720,1577,10,359,2,2000.00,NULL,'2022-11-23 10:03:26','2022-11-23 10:03:26',NULL),(980,8087,186,40720,1577,15,67,1,120724.73,NULL,'2022-11-23 10:05:34','2022-11-23 10:05:34',NULL),(981,8087,186,40720,1577,15,25,2,1751.60,NULL,'2022-11-23 10:05:34','2022-11-23 10:05:34',NULL),(982,8087,186,40720,1577,15,494,2,378.25,NULL,'2022-11-23 10:05:34','2022-11-23 10:05:34',NULL),(983,8087,186,40720,1577,15,68,2,72385.49,NULL,'2022-11-23 10:05:34','2022-11-23 10:05:34',NULL),(984,8087,186,40720,1577,15,74,2,46209.39,NULL,'2022-11-23 10:05:34','2022-11-23 10:05:34',NULL),(985,8087,187,40720,1577,10,156,1,17788.38,NULL,'2022-11-23 10:08:59','2022-11-23 11:00:56','2022-11-23 11:00:56'),(986,8087,187,40720,1577,10,251,2,22.23,NULL,'2022-11-23 10:08:59','2022-11-23 11:00:56','2022-11-23 11:00:56'),(987,8087,187,40720,1577,10,252,2,1052.14,NULL,'2022-11-23 10:08:59','2022-11-23 11:00:56','2022-11-23 11:00:56'),(988,8087,187,40720,1577,10,277,2,7537.37,NULL,'2022-11-23 10:08:59','2022-11-23 11:00:56','2022-11-23 11:00:56'),(989,8087,187,40720,1577,10,276,2,1218.88,NULL,'2022-11-23 10:08:59','2022-11-23 11:00:56','2022-11-23 11:00:56');
INSERT INTO `balance_libro_details` VALUES (990,8087,187,40720,1577,10,489,2,6636.20,NULL,'2022-11-23 10:08:59','2022-11-23 11:00:56','2022-11-23 11:00:56'),(991,8087,187,40720,1577,10,474,2,1321.56,NULL,'2022-11-23 10:08:59','2022-11-23 11:00:56','2022-11-23 11:00:56'),(992,8087,188,40720,1577,10,74,1,46209.39,NULL,'2022-11-23 10:12:43','2022-11-23 10:12:43',NULL),(993,8087,188,40720,1577,10,474,2,46209.39,NULL,'2022-11-23 10:12:43','2022-11-23 10:12:43',NULL),(994,8087,189,40720,1577,21,62,1,15000.00,NULL,'2022-11-23 10:14:27','2022-11-23 10:14:27',NULL),(995,8087,189,40720,1577,21,474,2,15000.00,NULL,'2022-11-23 10:14:27','2022-11-23 10:14:27',NULL),(996,8087,190,40720,1577,3,392,1,318565.30,NULL,'2022-11-23 10:17:49','2022-11-23 11:17:16','2022-11-23 11:17:16'),(997,8087,190,40720,1577,3,68,1,67929.78,NULL,'2022-11-23 10:17:49','2022-11-23 11:17:16','2022-11-23 11:17:16'),(998,8087,190,40720,1577,3,494,1,227.94,NULL,'2022-11-23 10:17:49','2022-11-23 11:17:16','2022-11-23 11:17:16'),(999,8087,190,40720,1577,3,25,1,1727.87,NULL,'2022-11-23 10:17:49','2022-11-23 11:17:16','2022-11-23 11:17:16'),(1000,8087,190,40720,1577,3,251,1,19.50,NULL,'2022-11-23 10:17:49','2022-11-23 11:17:16','2022-11-23 11:17:16'),(1001,8087,190,40720,1577,3,252,1,2600.11,NULL,'2022-11-23 10:17:49','2022-11-23 11:17:16','2022-11-23 11:17:16'),(1002,8087,190,40720,1577,3,116,1,16225.00,NULL,'2022-11-23 10:17:49','2022-11-23 11:17:16','2022-11-23 11:17:16'),(1003,8087,190,40720,1577,3,484,1,3214.13,NULL,'2022-11-23 10:17:49','2022-11-23 11:17:16','2022-11-23 11:17:16'),(1004,8087,190,40720,1577,3,135,1,669.03,NULL,'2022-11-23 10:17:49','2022-11-23 11:17:16','2022-11-23 11:17:16'),(1005,8087,190,40720,1577,3,128,1,2028.04,NULL,'2022-11-23 10:17:49','2022-11-23 11:17:16','2022-11-23 11:17:16'),(1006,8087,190,40720,1577,3,485,1,967.20,NULL,'2022-11-23 10:17:49','2022-11-23 11:17:16','2022-11-23 11:17:16'),(1007,8087,190,40720,1577,3,359,2,414173.90,NULL,'2022-11-23 10:17:49','2022-11-23 11:17:16','2022-11-23 11:17:16'),(1008,8087,191,40720,1577,2,359,1,506942.89,NULL,'2022-11-23 10:21:04','2022-11-23 10:21:04',NULL),(1009,8087,191,40720,1577,2,489,1,5216.81,NULL,'2022-11-23 10:21:04','2022-11-23 10:21:04',NULL),(1010,8087,191,40720,1577,2,67,2,88887.22,NULL,'2022-11-23 10:21:04','2022-11-23 10:21:04',NULL),(1011,8087,191,40720,1577,2,96,2,423272.48,NULL,'2022-11-23 10:21:04','2022-11-23 10:21:04',NULL),(1012,8087,192,40720,1577,1,110,1,103230.15,NULL,'2022-11-23 10:23:11','2022-11-23 10:23:11',NULL),(1013,8087,192,40720,1577,1,191,1,117872.02,NULL,'2022-11-23 10:23:11','2022-11-23 10:23:11',NULL),(1014,8087,192,40720,1577,1,63,2,27837.46,NULL,'2022-11-23 10:23:11','2022-11-23 10:23:11',NULL),(1015,8087,192,40720,1577,1,62,2,191264.71,NULL,'2022-11-23 10:23:11','2022-11-23 10:23:11',NULL),(1016,8087,192,40720,1577,1,64,2,2000.00,NULL,'2022-11-23 10:23:11','2022-11-23 10:23:11',NULL),(1017,8087,193,40720,1577,5,157,1,4449.78,NULL,'2022-11-23 10:26:37','2022-11-23 10:26:37',NULL),(1018,8087,193,40720,1577,5,396,1,3028.33,NULL,'2022-11-23 10:26:37','2022-11-23 10:26:37',NULL),(1019,8087,193,40720,1577,5,277,1,6653.80,NULL,'2022-11-23 10:26:37','2022-11-23 10:26:37',NULL),(1020,8087,193,40720,1577,5,276,1,1076.00,NULL,'2022-11-23 10:26:37','2022-11-23 10:26:37',NULL),(1021,8087,193,40720,1577,5,214,1,7298.49,NULL,'2022-11-23 10:26:37','2022-11-23 10:26:37',NULL),(1022,8087,193,40720,1577,5,474,1,429432.65,NULL,'2022-11-23 10:26:37','2022-11-23 10:26:37',NULL),(1023,8087,193,40720,1577,5,359,1,178122.99,NULL,'2022-11-23 10:26:37','2022-11-23 10:26:37',NULL),(1024,8087,193,40720,1577,5,474,2,200629.39,NULL,'2022-11-23 10:26:37','2022-11-23 10:26:37',NULL),(1025,8087,193,40720,1577,5,359,2,429432.65,NULL,'2022-11-23 10:26:37','2022-11-23 10:26:37',NULL),(1026,8087,194,40720,1578,21,62,1,176264.71,NULL,'2022-11-23 10:28:06','2022-11-23 10:28:06',NULL),(1027,8087,194,40720,1578,21,474,2,50452.71,NULL,'2022-11-23 10:28:06','2022-11-23 10:28:06',NULL);
INSERT INTO `balance_libro_details` VALUES (1028,8087,194,40720,1578,21,359,2,125812.00,NULL,'2022-11-23 10:28:06','2022-11-23 10:28:06',NULL),(1029,8087,195,40720,1578,19,483,1,30000.00,NULL,'2022-11-23 10:30:42','2022-11-23 10:30:42',NULL),(1030,8087,195,40720,1578,19,474,2,30000.00,NULL,'2022-11-23 10:30:42','2022-11-23 10:30:42',NULL),(1031,8087,196,40720,1578,10,63,1,22159.02,NULL,'2022-11-23 10:32:07','2022-11-23 10:32:07',NULL),(1032,8087,196,40720,1578,10,64,1,2000.00,NULL,'2022-11-23 10:32:07','2022-11-23 10:32:07',NULL),(1033,8087,196,40720,1578,10,474,2,22159.02,NULL,'2022-11-23 10:32:07','2022-11-23 10:32:07',NULL),(1034,8087,196,40720,1578,10,359,2,2000.00,NULL,'2022-11-23 10:32:07','2022-11-23 10:32:07',NULL),(1035,8087,197,40720,1578,15,67,1,88887.22,NULL,'2022-11-23 10:36:01','2022-11-23 10:36:01',NULL),(1036,8087,197,40720,1578,15,68,2,67929.78,NULL,'2022-11-23 10:36:01','2022-11-23 10:36:01',NULL),(1037,8087,197,40720,1578,15,25,2,1727.87,NULL,'2022-11-23 10:36:01','2022-11-23 10:36:01',NULL),(1038,8087,197,40720,1578,15,494,2,227.94,NULL,'2022-11-23 10:36:01','2022-11-23 10:36:01',NULL),(1039,8087,197,40720,1578,15,74,2,19001.63,NULL,'2022-11-23 10:36:01','2022-11-23 10:36:01',NULL),(1040,8087,198,40720,1578,10,74,1,19001.63,NULL,'2022-11-23 10:37:10','2022-11-23 10:37:10',NULL),(1041,8087,198,40720,1578,10,474,2,19001.63,NULL,'2022-11-23 10:37:10','2022-11-23 10:37:10',NULL),(1042,8087,199,40720,1578,10,156,1,13898.17,NULL,'2022-11-23 10:58:23','2022-11-23 10:58:23',NULL),(1043,8087,199,40720,1578,10,497,1,3572.55,NULL,'2022-11-23 10:58:23','2022-11-23 10:58:23',NULL),(1044,8087,199,40720,1578,10,496,2,19.50,NULL,'2022-11-23 10:58:23','2022-11-23 10:58:23',NULL),(1045,8087,199,40720,1578,10,495,2,2600.11,NULL,'2022-11-23 10:58:23','2022-11-23 10:58:23',NULL),(1046,8087,199,40720,1578,10,277,2,6653.80,NULL,'2022-11-23 10:58:23','2022-11-23 10:58:23',NULL),(1047,8087,199,40720,1578,10,276,2,1076.00,NULL,'2022-11-23 10:58:23','2022-11-23 10:58:23',NULL),(1048,8087,199,40720,1578,10,489,2,5216.81,NULL,'2022-11-23 10:58:23','2022-11-23 10:58:23',NULL),(1049,8087,199,40720,1578,10,474,2,1904.50,NULL,'2022-11-23 10:58:23','2022-11-23 10:58:23',NULL),(1050,8087,200,40720,1577,10,156,1,17788.38,NULL,'2022-11-23 11:00:56','2022-11-23 11:00:56',NULL),(1051,8087,200,40720,1577,10,277,2,7537.37,NULL,'2022-11-23 11:00:56','2022-11-23 11:00:56',NULL),(1052,8087,200,40720,1577,10,276,2,1218.88,NULL,'2022-11-23 11:00:56','2022-11-23 11:00:56',NULL),(1053,8087,200,40720,1577,10,489,2,6636.20,NULL,'2022-11-23 11:00:56','2022-11-23 11:00:56',NULL),(1054,8087,200,40720,1577,10,474,2,1321.56,NULL,'2022-11-23 11:00:56','2022-11-23 11:00:56',NULL),(1055,8087,200,40720,1577,10,495,2,1052.14,NULL,'2022-11-23 11:00:56','2022-11-23 11:00:56',NULL),(1056,8087,200,40720,1577,10,496,2,22.23,NULL,'2022-11-23 11:00:56','2022-11-23 11:00:56',NULL),(1057,8087,201,40720,1576,10,156,1,29895.86,NULL,'2022-11-23 11:10:44','2022-11-23 11:10:44',NULL),(1058,8087,201,40720,1576,10,276,2,1530.26,NULL,'2022-11-23 11:10:44','2022-11-23 11:10:44',NULL),(1059,8087,201,40720,1576,10,277,2,11459.97,NULL,'2022-11-23 11:10:44','2022-11-23 11:10:44',NULL),(1060,8087,201,40720,1576,10,489,2,2705.42,NULL,'2022-11-23 11:10:44','2022-11-23 11:10:44',NULL),(1061,8087,201,40720,1576,10,474,2,8943.68,NULL,'2022-11-23 11:10:44','2022-11-23 11:10:44',NULL),(1062,8087,201,40720,1576,10,496,2,76.41,NULL,'2022-11-23 11:10:44','2022-11-23 11:10:44',NULL),(1063,8087,201,40720,1576,10,495,2,5180.12,NULL,'2022-11-23 11:10:44','2022-11-23 11:10:44',NULL),(1064,8087,202,40720,1576,3,392,1,329231.11,NULL,'2022-11-23 11:15:25','2022-11-23 11:15:25',NULL),(1065,8087,202,40720,1576,3,68,1,72385.49,NULL,'2022-11-23 11:15:25','2022-11-23 11:15:25',NULL),(1066,8087,202,40720,1576,3,494,1,378.25,NULL,'2022-11-23 11:15:25','2022-11-23 11:15:25',NULL),(1067,8087,202,40720,1576,3,25,1,1751.60,NULL,'2022-11-23 11:15:25','2022-11-23 11:15:25',NULL);
INSERT INTO `balance_libro_details` VALUES (1068,8087,202,40720,1576,3,23,1,138.86,NULL,'2022-11-23 11:15:25','2022-11-23 11:15:25',NULL),(1069,8087,202,40720,1576,3,484,1,3915.73,NULL,'2022-11-23 11:15:25','2022-11-23 11:15:25',NULL),(1070,8087,202,40720,1576,3,116,1,16225.00,NULL,'2022-11-23 11:15:25','2022-11-23 11:15:25',NULL),(1071,8087,202,40720,1576,3,193,1,6847.60,NULL,'2022-11-23 11:15:25','2022-11-23 11:15:25',NULL),(1072,8087,202,40720,1576,3,135,1,946.76,NULL,'2022-11-23 11:15:25','2022-11-23 11:15:25',NULL),(1073,8087,202,40720,1576,3,128,1,10076.77,NULL,'2022-11-23 11:15:25','2022-11-23 11:15:25',NULL),(1074,8087,202,40720,1576,3,485,1,487.60,NULL,'2022-11-23 11:15:25','2022-11-23 11:15:25',NULL),(1075,8087,202,40720,1576,3,359,2,443459.14,NULL,'2022-11-23 11:15:25','2022-11-23 11:15:25',NULL),(1076,8087,202,40720,1576,3,495,1,1052.14,NULL,'2022-11-23 11:15:25','2022-11-23 11:15:25',NULL),(1077,8087,202,40720,1576,3,496,1,22.23,NULL,'2022-11-23 11:15:25','2022-11-23 11:15:25',NULL),(1078,8087,203,40720,1577,3,392,1,318565.30,NULL,'2022-11-23 11:17:16','2022-11-23 11:17:16',NULL),(1079,8087,203,40720,1577,3,68,1,67929.78,NULL,'2022-11-23 11:17:16','2022-11-23 11:17:16',NULL),(1080,8087,203,40720,1577,3,494,1,227.94,NULL,'2022-11-23 11:17:16','2022-11-23 11:17:16',NULL),(1081,8087,203,40720,1577,3,25,1,1727.87,NULL,'2022-11-23 11:17:16','2022-11-23 11:17:16',NULL),(1082,8087,203,40720,1577,3,116,1,16225.00,NULL,'2022-11-23 11:17:16','2022-11-23 11:17:16',NULL),(1083,8087,203,40720,1577,3,484,1,3214.13,NULL,'2022-11-23 11:17:16','2022-11-23 11:17:16',NULL),(1084,8087,203,40720,1577,3,135,1,669.03,NULL,'2022-11-23 11:17:16','2022-11-23 11:17:16',NULL),(1085,8087,203,40720,1577,3,128,1,2028.04,NULL,'2022-11-23 11:17:16','2022-11-23 11:17:16',NULL),(1086,8087,203,40720,1577,3,485,1,967.20,NULL,'2022-11-23 11:17:16','2022-11-23 11:17:16',NULL),(1087,8087,203,40720,1577,3,359,2,414173.90,NULL,'2022-11-23 11:17:16','2022-11-23 11:17:16',NULL),(1088,8087,203,40720,1577,3,496,1,19.50,NULL,'2022-11-23 11:17:16','2022-11-23 11:17:16',NULL),(1089,8087,203,40720,1577,3,495,1,2600.11,NULL,'2022-11-23 11:17:16','2022-11-23 11:17:16',NULL),(1090,8087,204,40720,1578,3,392,1,67874.84,NULL,'2022-11-23 11:22:50','2022-11-23 11:22:50',NULL),(1091,8087,204,40720,1578,3,68,1,14985.10,NULL,'2022-11-23 11:22:50','2022-11-23 11:22:50',NULL),(1092,8087,204,40720,1578,3,494,1,517.45,NULL,'2022-11-23 11:22:50','2022-11-23 11:22:50',NULL),(1093,8087,204,40720,1578,3,25,1,1008.70,NULL,'2022-11-23 11:22:50','2022-11-23 11:22:50',NULL),(1094,8087,204,40720,1578,3,496,1,40.73,NULL,'2022-11-23 11:22:50','2022-11-23 11:22:50',NULL),(1095,8087,204,40720,1578,3,495,1,547.51,NULL,'2022-11-23 11:22:50','2022-11-23 11:22:50',NULL),(1096,8087,204,40720,1578,3,116,1,13225.00,NULL,'2022-11-23 11:22:50','2022-11-23 11:22:50',NULL),(1097,8087,204,40720,1578,3,193,1,2908.10,NULL,'2022-11-23 11:22:50','2022-11-23 11:22:50',NULL),(1098,8087,204,40720,1578,3,484,1,1296.78,NULL,'2022-11-23 11:22:50','2022-11-23 11:22:50',NULL),(1099,8087,204,40720,1578,3,135,1,291.02,NULL,'2022-11-23 11:22:50','2022-11-23 11:22:50',NULL),(1100,8087,204,40720,1578,3,128,1,349.96,NULL,'2022-11-23 11:22:50','2022-11-23 11:22:50',NULL),(1101,8087,204,40720,1578,3,359,2,103045.19,NULL,'2022-11-23 11:22:50','2022-11-23 11:22:50',NULL),(1102,8087,205,40720,1578,2,359,1,214964.47,NULL,'2022-11-23 11:24:20','2022-11-23 11:24:20',NULL),(1103,8087,205,40720,1578,2,489,1,2842.59,NULL,'2022-11-23 11:24:20','2022-11-23 11:24:20',NULL),(1104,8087,205,40720,1578,2,67,2,37801.23,NULL,'2022-11-23 11:24:20','2022-11-23 11:24:20',NULL),(1105,8087,205,40720,1578,2,96,2,180005.83,NULL,'2022-11-23 11:24:20','2022-11-23 11:24:20',NULL),(1106,8087,206,40720,1578,1,110,1,71449.76,NULL,'2022-11-23 11:25:57','2022-11-23 11:25:57',NULL),(1107,8087,206,40720,1578,1,191,1,9097.84,NULL,'2022-11-23 11:25:57','2022-11-23 11:25:57',NULL),(1108,8087,206,40720,1578,1,63,2,14973.29,NULL,'2022-11-23 11:25:57','2022-11-23 11:25:57',NULL);
INSERT INTO `balance_libro_details` VALUES (1109,8087,206,40720,1578,1,62,2,63574.31,NULL,'2022-11-23 11:25:57','2022-11-23 11:25:57',NULL),(1110,8087,206,40720,1578,1,64,2,2000.00,NULL,'2022-11-23 11:25:57','2022-11-23 11:25:57',NULL),(1111,8087,207,40720,1578,5,157,1,2744.50,NULL,'2022-11-23 11:29:40','2022-11-23 11:29:40',NULL),(1112,8087,207,40720,1578,5,396,1,2019.19,NULL,'2022-11-23 11:29:40','2022-11-23 11:29:40',NULL),(1113,8087,207,40720,1578,5,277,1,3695.14,NULL,'2022-11-23 11:29:40','2022-11-23 11:29:40',NULL),(1114,8087,207,40720,1578,5,276,1,152.38,NULL,'2022-11-23 11:29:40','2022-11-23 11:29:40',NULL),(1115,8087,207,40720,1578,5,214,1,5538.65,NULL,'2022-11-23 11:29:40','2022-11-23 11:29:40',NULL),(1116,8087,207,40720,1578,5,474,1,216751.56,NULL,'2022-11-23 11:29:40','2022-11-23 11:29:40',NULL),(1117,8087,207,40720,1578,5,359,1,191195.22,NULL,'2022-11-23 11:29:40','2022-11-23 11:29:40',NULL),(1118,8087,207,40720,1578,5,474,2,205345.08,NULL,'2022-11-23 11:29:40','2022-11-23 11:29:40',NULL),(1119,8087,207,40720,1578,5,359,2,216751.56,NULL,'2022-11-23 11:29:40','2022-11-23 11:29:40',NULL),(1120,8087,208,40720,1579,21,62,1,29498.00,NULL,'2022-11-23 11:40:44','2022-11-23 11:40:44',NULL),(1121,8087,208,40720,1579,21,62,1,34076.31,NULL,'2022-11-23 11:40:44','2022-11-23 11:40:44',NULL),(1122,8087,208,40720,1579,21,474,2,29498.00,NULL,'2022-11-23 11:40:44','2022-11-23 11:40:44',NULL),(1123,8087,208,40720,1579,21,498,2,34076.31,NULL,'2022-11-23 11:40:44','2022-11-23 11:40:44',NULL),(1124,8087,209,40720,1579,10,63,1,12340.45,NULL,'2022-11-23 11:42:39','2022-11-23 11:42:39',NULL),(1125,8087,209,40720,1579,10,64,1,2000.00,NULL,'2022-11-23 11:42:39','2022-11-23 11:42:39',NULL),(1126,8087,209,40720,1579,10,474,2,12340.45,NULL,'2022-11-23 11:42:39','2022-11-23 11:42:39',NULL),(1127,8087,209,40720,1579,10,359,2,2000.00,NULL,'2022-11-23 11:42:39','2022-11-23 11:42:39',NULL),(1128,8087,210,40720,1579,15,67,1,37801.23,NULL,'2022-11-23 11:45:27','2022-11-23 11:45:27',NULL),(1129,8087,210,40720,1579,15,25,2,1008.70,NULL,'2022-11-23 11:45:27','2022-11-23 11:45:27',NULL),(1130,8087,210,40720,1579,15,494,2,517.45,NULL,'2022-11-23 11:45:27','2022-11-23 11:45:27',NULL),(1131,8087,210,40720,1579,15,68,2,14985.10,NULL,'2022-11-23 11:45:27','2022-11-23 11:45:27',NULL),(1132,8087,210,40720,1579,15,74,2,21289.98,NULL,'2022-11-23 11:45:27','2022-11-23 11:45:27',NULL),(1133,8087,211,40720,1579,10,74,1,21289.98,NULL,'2022-11-23 11:47:49','2022-11-23 11:47:49',NULL),(1134,8087,211,40720,1579,10,474,2,21289.98,NULL,'2022-11-23 11:47:49','2022-11-23 11:47:49',NULL),(1135,8087,212,40720,1579,10,156,1,6294.39,NULL,'2022-11-23 11:50:48','2022-11-23 11:50:48',NULL),(1136,8087,212,40720,1579,10,497,1,2837.83,NULL,'2022-11-23 11:50:48','2022-11-23 11:50:48',NULL),(1137,8087,212,40720,1579,10,496,2,27.71,NULL,'2022-11-23 11:50:48','2022-11-23 11:50:48',NULL),(1138,8087,212,40720,1579,10,495,2,358.95,NULL,'2022-11-23 11:50:48','2022-11-23 11:50:48',NULL),(1139,8087,212,40720,1579,10,277,2,3695.14,NULL,'2022-11-23 11:50:48','2022-11-23 11:50:48',NULL),(1140,8087,212,40720,1579,10,276,2,152.38,NULL,'2022-11-23 11:50:48','2022-11-23 11:50:48',NULL),(1141,8087,212,40720,1579,10,489,2,2842.59,NULL,'2022-11-23 11:50:48','2022-11-23 11:50:48',NULL),(1142,8087,212,40720,1579,10,474,2,2055.45,NULL,'2022-11-23 11:50:48','2022-11-23 11:50:48',NULL),(1143,8087,213,40720,1579,21,57,1,60000.00,NULL,'2022-11-23 11:52:07','2022-11-23 11:52:07',NULL),(1144,8087,213,40720,1579,21,359,2,60000.00,NULL,'2022-11-23 11:52:07','2022-11-23 11:52:07',NULL),(1145,8087,214,40720,1579,3,392,1,209373.26,NULL,'2022-11-23 11:56:26','2022-11-23 11:56:26',NULL),(1146,8087,214,40720,1579,3,68,1,46136.78,NULL,'2022-11-23 11:56:26','2022-11-23 11:56:26',NULL),(1147,8087,214,40720,1579,3,494,1,515.35,NULL,'2022-11-23 11:56:26','2022-11-23 11:56:26',NULL),(1148,8087,214,40720,1579,3,25,1,79.38,NULL,'2022-11-23 11:56:26','2022-11-23 11:56:26',NULL),(1149,8087,214,40720,1579,3,496,1,34.58,NULL,'2022-11-23 11:56:26','2022-11-23 11:56:26',NULL);
INSERT INTO `balance_libro_details` VALUES (1150,8087,214,40720,1579,3,495,1,2468.13,NULL,'2022-11-23 11:56:26','2022-11-23 11:56:26',NULL),(1151,8087,214,40720,1579,3,116,1,13225.00,NULL,'2022-11-23 11:56:26','2022-11-23 11:56:26',NULL),(1152,8087,214,40720,1579,3,193,1,2909.24,NULL,'2022-11-23 11:56:26','2022-11-23 11:56:26',NULL),(1153,8087,214,40720,1579,3,484,1,6855.76,NULL,'2022-11-23 11:56:26','2022-11-23 11:56:26',NULL),(1154,8087,214,40720,1579,3,135,1,618.61,NULL,'2022-11-23 11:56:26','2022-11-23 11:56:26',NULL),(1155,8087,214,40720,1579,3,128,1,957.74,NULL,'2022-11-23 11:56:26','2022-11-23 11:56:26',NULL),(1156,8087,214,40720,1579,3,485,1,967.20,NULL,'2022-11-23 11:56:26','2022-11-23 11:56:26',NULL),(1157,8087,214,40720,1579,3,359,2,284141.03,NULL,'2022-11-23 11:56:26','2022-11-23 11:56:26',NULL),(1158,8087,215,40720,1579,2,359,1,509695.64,NULL,'2022-11-23 11:58:11','2022-11-23 11:58:11',NULL),(1159,8087,215,40720,1579,2,489,1,1575.00,NULL,'2022-11-23 11:58:11','2022-11-23 11:58:11',NULL),(1160,8087,215,40720,1579,2,67,2,88732.92,NULL,'2022-11-23 11:58:11','2022-11-23 11:58:11',NULL),(1161,8087,215,40720,1579,2,96,2,422537.72,NULL,'2022-11-23 11:58:11','2022-11-23 11:58:11',NULL),(1162,8087,216,40720,1579,1,110,1,71449.76,NULL,'2022-11-23 12:00:21','2022-11-23 12:00:21',NULL),(1163,8087,216,40720,1579,1,191,1,9097.84,NULL,'2022-11-23 12:00:21','2022-11-23 12:00:21',NULL),(1164,8087,216,40720,1579,1,63,2,14973.29,NULL,'2022-11-23 12:00:21','2022-11-23 12:00:21',NULL),(1165,8087,216,40720,1579,1,62,2,63574.31,NULL,'2022-11-23 12:00:21','2022-11-23 12:00:21',NULL),(1166,8087,216,40720,1579,1,64,2,2000.00,NULL,'2022-11-23 12:00:21','2022-11-23 12:00:21',NULL),(1167,8087,217,40720,1579,5,157,1,3033.53,NULL,'2022-11-23 12:03:47','2022-11-23 12:03:47',NULL),(1168,8087,217,40720,1579,5,396,1,1507.36,NULL,'2022-11-23 12:03:47','2022-11-23 12:03:47',NULL),(1169,8087,217,40720,1579,5,277,1,4993.87,NULL,'2022-11-23 12:03:47','2022-11-23 12:03:47',NULL),(1170,8087,217,40720,1579,5,276,1,205.93,NULL,'2022-11-23 12:03:47','2022-11-23 12:03:47',NULL),(1171,8087,217,40720,1579,5,214,1,8017.85,NULL,'2022-11-23 12:03:47','2022-11-23 12:03:47',NULL),(1172,8087,217,40720,1579,5,474,1,289272.25,NULL,'2022-11-23 12:03:47','2022-11-23 12:03:47',NULL),(1173,8087,217,40720,1579,5,359,1,184465.32,NULL,'2022-11-23 12:03:47','2022-11-23 12:03:47',NULL),(1174,8087,217,40720,1579,5,474,2,202223.86,NULL,'2022-11-23 12:03:47','2022-11-23 12:03:47',NULL),(1175,8087,217,40720,1579,5,359,2,289272.25,NULL,'2022-11-23 12:03:47','2022-11-23 12:03:47',NULL),(1176,8087,218,40720,1580,21,62,1,29498.00,NULL,'2022-11-23 12:05:54','2022-11-23 12:05:54',NULL),(1177,8087,218,40720,1580,21,62,1,34076.31,NULL,'2022-11-23 12:05:54','2022-11-23 12:05:54',NULL),(1178,8087,218,40720,1580,21,474,2,29498.00,NULL,'2022-11-23 12:05:54','2022-11-23 12:05:54',NULL),(1179,8087,218,40720,1580,21,498,2,34076.31,NULL,'2022-11-23 12:05:54','2022-11-23 12:05:54',NULL),(1180,8087,219,40720,1580,10,63,1,20651.73,NULL,'2022-11-23 12:07:27','2022-11-23 12:07:27',NULL),(1181,8087,219,40720,1580,10,64,1,2000.00,NULL,'2022-11-23 12:07:27','2022-11-23 12:07:27',NULL),(1182,8087,219,40720,1580,10,474,2,20651.73,NULL,'2022-11-23 12:07:27','2022-11-23 12:07:27',NULL),(1183,8087,219,40720,1580,10,359,2,2000.00,NULL,'2022-11-23 12:07:27','2022-11-23 12:07:27',NULL),(1184,8087,220,40720,1580,15,67,1,88732.92,NULL,'2022-11-23 12:10:21','2022-11-23 12:10:21',NULL),(1185,8087,220,40720,1580,15,74,2,42001.41,NULL,'2022-11-23 12:10:21','2022-11-23 12:10:21',NULL),(1186,8087,220,40720,1580,15,68,2,46136.78,NULL,'2022-11-23 12:10:21','2022-11-23 12:10:21',NULL),(1187,8087,220,40720,1580,15,25,2,79.38,NULL,'2022-11-23 12:10:21','2022-11-23 12:10:21',NULL),(1188,8087,220,40720,1580,15,494,2,515.35,NULL,'2022-11-23 12:10:21','2022-11-23 12:10:21',NULL),(1189,8087,221,40720,1580,10,74,1,42001.41,NULL,'2022-11-23 12:11:44','2022-11-23 12:11:44',NULL),(1190,8087,221,40720,1580,10,474,2,42001.41,NULL,'2022-11-23 12:11:44','2022-11-23 12:11:44',NULL);
INSERT INTO `balance_libro_details` VALUES (1191,8087,222,40720,1580,10,156,1,15871.50,NULL,'2022-11-23 12:14:44','2022-11-23 12:14:44',NULL),(1192,8087,222,40720,1580,10,497,1,610.53,NULL,'2022-11-23 12:14:44','2022-11-23 12:14:44',NULL),(1193,8087,222,40720,1580,10,496,2,34.58,NULL,'2022-11-23 12:14:44','2022-11-23 12:14:44',NULL),(1194,8087,222,40720,1580,10,495,2,1924.73,NULL,'2022-11-23 12:14:44','2022-11-23 12:14:44',NULL),(1195,8087,222,40720,1580,10,277,2,4993.87,NULL,'2022-11-23 12:14:44','2022-11-23 12:14:44',NULL),(1196,8087,222,40720,1580,10,276,2,205.93,NULL,'2022-11-23 12:14:44','2022-11-23 12:14:44',NULL),(1197,8087,222,40720,1580,10,489,2,1575.00,NULL,'2022-11-23 12:14:44','2022-11-23 12:14:44',NULL),(1198,8087,222,40720,1580,10,474,2,7747.92,NULL,'2022-11-23 12:14:44','2022-11-23 12:14:44',NULL),(1199,8087,223,40720,1580,21,57,1,80000.00,NULL,'2022-11-23 12:15:42','2022-11-23 12:15:42',NULL),(1200,8087,223,40720,1580,21,359,2,80000.00,NULL,'2022-11-23 12:15:42','2022-11-23 12:15:42',NULL),(1201,8087,224,40720,1580,1,110,1,108113.64,NULL,'2022-11-23 12:17:48','2022-11-23 12:17:48',NULL),(1202,8087,224,40720,1580,1,191,1,14377.45,NULL,'2022-11-23 12:17:48','2022-11-23 12:17:48',NULL),(1203,8087,224,40720,1580,1,63,2,24368.78,NULL,'2022-11-23 12:17:48','2022-11-23 12:17:48',NULL),(1204,8087,224,40720,1580,1,62,2,96122.31,NULL,'2022-11-23 12:17:48','2022-11-23 12:17:48',NULL),(1205,8087,224,40720,1580,1,64,2,2000.00,NULL,'2022-11-23 12:17:48','2022-11-23 12:17:48',NULL),(1206,8087,225,40720,1580,3,392,1,249168.90,NULL,'2022-11-23 12:20:50','2022-11-23 12:20:50',NULL),(1207,8087,225,40720,1580,3,68,1,53959.05,NULL,'2022-11-23 12:20:50','2022-11-23 12:20:50',NULL),(1208,8087,225,40720,1580,3,494,1,448.35,NULL,'2022-11-23 12:20:50','2022-11-23 12:20:50',NULL),(1209,8087,225,40720,1580,3,496,1,15.07,NULL,'2022-11-23 12:20:50','2022-11-23 12:20:50',NULL),(1210,8087,225,40720,1580,3,495,1,4425.73,NULL,'2022-11-23 12:20:50','2022-11-23 12:20:50',NULL),(1211,8087,225,40720,1580,3,116,1,15209.00,NULL,'2022-11-23 12:20:50','2022-11-23 12:20:50',NULL),(1212,8087,225,40720,1580,3,484,1,4482.41,NULL,'2022-11-23 12:20:50','2022-11-23 12:20:50',NULL),(1213,8087,225,40720,1580,3,135,1,725.92,NULL,'2022-11-23 12:20:50','2022-11-23 12:20:50',NULL),(1214,8087,225,40720,1580,3,128,1,3134.93,NULL,'2022-11-23 12:20:50','2022-11-23 12:20:50',NULL),(1215,8087,225,40720,1580,3,485,1,967.20,NULL,'2022-11-23 12:20:50','2022-11-23 12:20:50',NULL),(1216,8087,225,40720,1580,3,359,2,332536.56,NULL,'2022-11-23 12:20:50','2022-11-23 12:20:50',NULL),(1217,8087,226,40720,1580,2,359,1,593693.94,NULL,'2022-11-23 12:22:53','2022-11-23 12:22:53',NULL),(1218,8087,226,40720,1580,2,67,2,103037.80,NULL,'2022-11-23 12:22:53','2022-11-23 12:22:53',NULL),(1219,8087,226,40720,1580,2,96,2,490656.14,NULL,'2022-11-23 12:22:53','2022-11-23 12:22:53',NULL),(1220,8087,227,40720,1580,5,157,1,2429.78,NULL,'2022-11-23 12:26:52','2022-11-23 12:26:52',NULL),(1221,8087,227,40720,1580,5,396,1,4545.67,NULL,'2022-11-23 12:26:52','2022-11-23 12:26:52',NULL),(1222,8087,227,40720,1580,5,277,1,723.59,NULL,'2022-11-23 12:26:52','2022-11-23 12:26:52',NULL),(1223,8087,227,40720,1580,5,276,1,597.33,NULL,'2022-11-23 12:26:52','2022-11-23 12:26:52',NULL),(1224,8087,227,40720,1580,5,214,1,692.21,NULL,'2022-11-23 12:26:52','2022-11-23 12:26:52',NULL),(1225,8087,227,40720,1580,5,474,1,264177.99,NULL,'2022-11-23 12:26:52','2022-11-23 12:26:52',NULL),(1226,8087,227,40720,1580,5,359,1,198638.54,NULL,'2022-11-23 12:26:52','2022-11-23 12:26:52',NULL),(1227,8087,227,40720,1580,5,474,2,207627.12,NULL,'2022-11-23 12:26:52','2022-11-23 12:26:52',NULL),(1228,8087,227,40720,1580,5,359,2,264177.99,NULL,'2022-11-23 12:26:52','2022-11-23 12:26:52',NULL),(1229,8087,228,40720,1581,21,62,1,96122.31,NULL,'2022-11-23 12:29:02','2022-11-23 12:29:02',NULL),(1230,8087,228,40720,1581,21,474,2,30000.00,NULL,'2022-11-23 12:29:02','2022-11-23 12:29:02',NULL),(1231,8087,228,40720,1581,21,359,2,66122.31,NULL,'2022-11-23 12:29:02','2022-11-23 12:29:02',NULL);
INSERT INTO `balance_libro_details` VALUES (1232,8087,229,40720,1581,19,483,1,15000.00,NULL,'2022-11-23 12:30:10','2022-11-23 12:30:10',NULL),(1233,8087,229,40720,1581,19,474,2,15000.00,NULL,'2022-11-23 12:30:10','2022-11-23 12:30:10',NULL),(1234,8087,230,40720,1581,10,63,1,22035.58,NULL,'2022-11-23 12:33:15','2022-11-23 12:33:15',NULL),(1235,8087,230,40720,1581,10,64,1,2000.00,NULL,'2022-11-23 12:33:15','2022-11-23 12:33:15',NULL),(1236,8087,230,40720,1581,10,474,2,22035.58,NULL,'2022-11-23 12:33:15','2022-11-23 12:33:15',NULL),(1237,8087,230,40720,1581,10,359,2,2000.00,NULL,'2022-11-23 12:33:15','2022-11-23 12:33:15',NULL),(1238,8087,231,40720,1581,15,67,1,103037.80,NULL,'2022-11-23 12:37:10','2022-11-23 12:37:10',NULL),(1239,8087,231,40720,1581,15,74,2,48630.40,NULL,'2022-11-23 12:37:10','2022-11-23 12:37:10',NULL),(1240,8087,231,40720,1581,15,68,2,53959.05,NULL,'2022-11-23 12:37:10','2022-11-23 12:37:10',NULL),(1241,8087,231,40720,1581,15,494,2,448.35,NULL,'2022-11-23 12:37:10','2022-11-23 12:37:10',NULL),(1242,8087,232,40720,1581,10,156,1,17489.19,NULL,'2022-11-23 14:34:18','2022-11-23 14:34:18',NULL),(1243,8087,232,40720,1581,10,497,2,5416.11,NULL,'2022-11-23 14:34:18','2022-11-23 14:34:18',NULL),(1244,8087,232,40720,1581,10,496,2,15.07,NULL,'2022-11-23 14:34:18','2022-11-23 14:34:18',NULL),(1245,8087,232,40720,1581,10,495,2,4425.73,NULL,'2022-11-23 14:34:18','2022-11-23 14:34:18',NULL),(1246,8087,232,40720,1581,10,277,2,723.59,NULL,'2022-11-23 14:34:18','2022-11-23 14:34:18',NULL),(1247,8087,232,40720,1581,10,276,2,597.33,NULL,'2022-11-23 14:34:18','2022-11-23 14:34:18',NULL),(1248,8087,232,40720,1581,10,474,2,6311.36,NULL,'2022-11-23 14:34:18','2022-11-23 14:34:18',NULL),(1249,8087,233,40720,1581,10,74,1,48630.40,NULL,'2022-11-23 14:37:35','2022-11-23 14:37:35',NULL),(1250,8087,233,40720,1581,10,474,2,48630.40,NULL,'2022-11-23 14:37:35','2022-11-23 14:37:35',NULL),(1251,8087,234,40720,1581,5,157,1,1660.63,NULL,'2022-11-23 14:41:48','2022-11-23 14:41:48',NULL),(1252,8087,234,40720,1581,5,396,1,4557.77,NULL,'2022-11-23 14:41:48','2022-11-23 14:41:48',NULL),(1253,8087,234,40720,1581,5,277,1,103.29,NULL,'2022-11-23 14:41:48','2022-11-23 14:41:48',NULL),(1254,8087,234,40720,1581,5,276,1,512.00,NULL,'2022-11-23 14:41:48','2022-11-23 14:41:48',NULL),(1255,8087,234,40720,1581,5,214,1,8922.89,NULL,'2022-11-23 14:41:48','2022-11-23 14:41:48',NULL),(1256,8087,234,40720,1581,5,474,1,153823.59,NULL,'2022-11-23 14:41:48','2022-11-23 14:41:48',NULL),(1257,8087,234,40720,1581,5,359,1,112177.05,NULL,'2022-11-23 14:41:48','2022-11-23 14:41:48',NULL),(1258,8087,234,40720,1581,5,474,2,127933.63,NULL,'2022-11-23 14:41:48','2022-11-23 14:41:48',NULL),(1259,8087,234,40720,1581,5,359,2,153823.59,NULL,'2022-11-23 14:41:48','2022-11-23 14:41:48',NULL),(1260,8087,235,40720,1581,1,110,1,71449.76,NULL,'2022-11-23 14:49:59','2022-11-23 14:49:59',NULL),(1261,8087,235,40720,1581,1,191,1,9097.84,NULL,'2022-11-23 14:49:59','2022-11-23 14:49:59',NULL),(1262,8087,235,40720,1581,1,63,2,14973.29,NULL,'2022-11-23 14:49:59','2022-11-23 14:49:59',NULL),(1263,8087,235,40720,1581,1,62,2,63574.31,NULL,'2022-11-23 14:49:59','2022-11-23 14:49:59',NULL),(1264,8087,235,40720,1581,1,64,2,2000.00,NULL,'2022-11-23 14:49:59','2022-11-23 14:49:59',NULL),(1265,8087,236,40720,1581,3,392,1,289750.57,NULL,'2022-11-23 15:12:28','2022-11-23 15:12:28',NULL),(1266,8087,236,40720,1581,3,68,1,62883.96,NULL,'2022-11-23 15:12:28','2022-11-23 15:12:28',NULL),(1267,8087,236,40720,1581,3,25,1,352.90,NULL,'2022-11-23 15:12:28','2022-11-23 15:12:28',NULL),(1268,8087,236,40720,1581,3,494,1,436.06,NULL,'2022-11-23 15:12:28','2022-11-23 15:12:28',NULL),(1269,8087,236,40720,1581,3,496,1,9.31,NULL,'2022-11-23 15:12:28','2022-11-23 15:12:28',NULL),(1270,8087,236,40720,1581,3,495,1,5416.48,NULL,'2022-11-23 15:12:28','2022-11-23 15:12:28',NULL),(1271,8087,236,40720,1581,3,116,1,15209.00,NULL,'2022-11-23 15:12:28','2022-11-23 15:12:28',NULL),(1272,8087,236,40720,1581,3,193,1,2976.93,NULL,'2022-11-23 15:12:28','2022-11-23 15:12:28',NULL);
INSERT INTO `balance_libro_details` VALUES (1273,8087,236,40720,1581,3,484,1,5694.98,NULL,'2022-11-23 15:12:28','2022-11-23 15:12:28',NULL),(1274,8087,236,40720,1581,3,135,1,1222.37,NULL,'2022-11-23 15:12:28','2022-11-23 15:12:28',NULL),(1275,8087,236,40720,1581,3,128,1,1665.47,NULL,'2022-11-23 15:12:28','2022-11-23 15:12:28',NULL),(1276,8087,236,40720,1581,3,485,1,967.20,NULL,'2022-11-23 15:12:28','2022-11-23 15:12:28',NULL),(1277,8087,236,40720,1581,3,359,2,386585.23,NULL,'2022-11-23 15:12:28','2022-11-23 15:12:28',NULL),(1278,8087,237,40720,1581,2,359,1,414090.73,NULL,'2022-11-23 15:25:29','2022-11-23 15:25:29',NULL),(1279,8087,237,40720,1581,2,67,2,71866.98,NULL,'2022-11-23 15:25:29','2022-11-23 15:25:29',NULL),(1280,8087,237,40720,1581,2,96,2,342223.75,NULL,'2022-11-23 15:25:29','2022-11-23 15:25:29',NULL),(1281,8087,238,40720,1582,21,62,1,63574.31,NULL,'2022-11-23 15:32:31','2022-11-23 15:32:31',NULL),(1282,8087,238,40720,1582,21,474,2,13125.00,NULL,'2022-11-23 15:32:31','2022-11-23 15:32:31',NULL),(1283,8087,238,40720,1582,21,498,2,34076.31,NULL,'2022-11-23 15:32:31','2022-11-23 15:32:31',NULL),(1284,8087,238,40720,1582,21,359,2,16373.00,NULL,'2022-11-23 15:32:31','2022-11-23 15:32:31',NULL),(1285,8087,239,40720,1582,10,63,1,14973.29,NULL,'2022-11-23 15:35:14','2022-11-23 15:35:14',NULL),(1286,8087,239,40720,1582,10,64,1,2000.00,NULL,'2022-11-23 15:35:14','2022-11-23 15:35:14',NULL),(1287,8087,239,40720,1582,10,474,2,14973.29,NULL,'2022-11-23 15:35:14','2022-11-23 15:35:14',NULL),(1288,8087,239,40720,1582,10,359,2,2000.00,NULL,'2022-11-23 15:35:14','2022-11-23 15:35:14',NULL),(1289,8087,240,40720,1582,19,483,1,20000.00,NULL,'2022-11-23 15:49:54','2022-11-23 15:49:54',NULL),(1290,8087,240,40720,1582,19,474,2,20000.00,NULL,'2022-11-23 15:49:54','2022-11-23 15:49:54',NULL),(1291,8087,241,40720,1582,15,67,1,71866.98,NULL,'2022-11-23 15:51:46','2022-11-23 15:51:46',NULL),(1292,8087,241,40720,1582,15,25,2,352.90,NULL,'2022-11-23 15:51:46','2022-11-23 15:51:46',NULL),(1293,8087,241,40720,1582,15,494,2,436.06,NULL,'2022-11-23 15:51:46','2022-11-23 15:51:46',NULL),(1294,8087,241,40720,1582,15,68,2,62883.96,NULL,'2022-11-23 15:51:46','2022-11-23 15:51:46',NULL),(1295,8087,241,40720,1582,15,74,2,8194.06,NULL,'2022-11-23 15:51:46','2022-11-23 15:51:46',NULL),(1296,8087,242,40720,1582,10,74,1,8194.06,NULL,'2022-11-23 15:52:56','2022-11-23 15:52:56',NULL),(1297,8087,242,40720,1582,10,474,2,8194.06,NULL,'2022-11-23 15:52:56','2022-11-23 15:52:56',NULL),(1298,8087,243,40720,1582,10,156,1,12864.57,NULL,'2022-11-23 15:55:37','2022-11-23 15:55:37',NULL),(1299,8087,243,40720,1582,10,497,2,1025.73,NULL,'2022-11-23 15:55:37','2022-11-23 15:55:37',NULL),(1300,8087,243,40720,1582,10,496,2,9.31,NULL,'2022-11-23 15:55:37','2022-11-23 15:55:37',NULL),(1301,8087,243,40720,1582,10,495,2,5240.92,NULL,'2022-11-23 15:55:37','2022-11-23 15:55:37',NULL),(1302,8087,243,40720,1582,10,277,2,103.29,NULL,'2022-11-23 15:55:37','2022-11-23 15:55:37',NULL),(1303,8087,243,40720,1582,10,276,2,512.00,NULL,'2022-11-23 15:55:37','2022-11-23 15:55:37',NULL),(1304,8087,243,40720,1582,10,474,2,5973.32,NULL,'2022-11-23 15:55:37','2022-11-23 15:55:37',NULL),(1305,8087,244,40720,1582,1,110,1,101449.76,NULL,'2022-11-23 16:15:20','2022-11-23 16:15:20',NULL),(1306,8087,244,40720,1582,1,191,1,9517.84,NULL,'2022-11-23 16:15:20','2022-11-23 16:15:20',NULL),(1307,8087,244,40720,1582,1,63,2,15393.29,NULL,'2022-11-23 16:15:20','2022-11-23 16:15:20',NULL),(1308,8087,244,40720,1582,1,62,2,93574.31,NULL,'2022-11-23 16:15:20','2022-11-23 16:15:20',NULL),(1309,8087,244,40720,1582,1,64,2,2000.00,NULL,'2022-11-23 16:15:20','2022-11-23 16:15:20',NULL),(1310,8087,245,40720,1582,3,392,1,226297.62,NULL,'2022-11-23 16:18:39','2022-11-23 16:18:39',NULL),(1311,8087,245,40720,1582,3,68,1,50669.55,NULL,'2022-11-23 16:18:39','2022-11-23 16:18:39',NULL),(1312,8087,245,40720,1582,3,25,1,468.99,NULL,'2022-11-23 16:18:39','2022-11-23 16:18:39',NULL),(1313,8087,245,40720,1582,3,494,1,716.63,NULL,'2022-11-23 16:18:39','2022-11-23 16:18:39',NULL);
INSERT INTO `balance_libro_details` VALUES (1314,8087,245,40720,1582,3,496,1,1061.26,NULL,'2022-11-23 16:18:39','2022-11-23 16:18:39',NULL),(1315,8087,245,40720,1582,3,495,1,6873.40,NULL,'2022-11-23 16:18:39','2022-11-23 16:18:39',NULL),(1316,8087,245,40720,1582,3,116,1,15209.00,NULL,'2022-11-23 16:18:39','2022-11-23 16:18:39',NULL),(1317,8087,245,40720,1582,3,193,1,6319.64,NULL,'2022-11-23 16:18:39','2022-11-23 16:18:39',NULL),(1318,8087,245,40720,1582,3,484,1,6656.38,NULL,'2022-11-23 16:18:39','2022-11-23 16:18:39',NULL),(1319,8087,245,40720,1582,3,135,1,1429.94,NULL,'2022-11-23 16:18:39','2022-11-23 16:18:39',NULL),(1320,8087,245,40720,1582,3,128,1,1898.94,NULL,'2022-11-23 16:18:39','2022-11-23 16:18:39',NULL),(1321,8087,245,40720,1582,3,485,1,967.20,NULL,'2022-11-23 16:18:39','2022-11-23 16:18:39',NULL),(1322,8087,245,40720,1582,3,359,2,318568.55,NULL,'2022-11-23 16:18:39','2022-11-23 16:18:39',NULL),(1323,8087,246,40720,1582,2,359,1,591140.49,NULL,'2022-11-23 16:19:49','2022-11-23 16:19:49',NULL),(1324,8087,246,40720,1582,2,67,2,102594.63,NULL,'2022-11-23 16:19:49','2022-11-23 16:19:49',NULL),(1325,8087,246,40720,1582,2,96,2,488545.86,NULL,'2022-11-23 16:19:49','2022-11-23 16:19:49',NULL),(1326,8087,247,40720,1582,5,157,1,2199.78,NULL,'2022-11-23 16:23:27','2022-11-23 16:23:27',NULL),(1327,8087,247,40720,1582,5,396,1,4577.13,NULL,'2022-11-23 16:23:27','2022-11-23 16:23:27',NULL),(1328,8087,247,40720,1582,5,277,1,327.66,NULL,'2022-11-23 16:23:27','2022-11-23 16:23:27',NULL),(1329,8087,247,40720,1582,5,276,1,1493.81,NULL,'2022-11-23 16:23:27','2022-11-23 16:23:27',NULL),(1330,8087,247,40720,1582,5,214,1,10329.72,NULL,'2022-11-23 16:23:27','2022-11-23 16:23:27',NULL),(1331,8087,247,40720,1582,5,474,1,260209.20,NULL,'2022-11-23 16:23:27','2022-11-23 16:23:27',NULL),(1332,8087,247,40720,1582,5,359,1,106689.90,NULL,'2022-11-23 16:23:27','2022-11-23 16:23:27',NULL),(1333,8087,247,40720,1582,5,474,2,125618.00,NULL,'2022-11-23 16:23:27','2022-11-23 16:23:27',NULL),(1334,8087,247,40720,1582,5,359,2,260209.20,NULL,'2022-11-23 16:23:27','2022-11-23 16:23:27',NULL),(1335,8087,248,40720,1582,21,57,1,50000.00,NULL,'2022-11-23 16:25:15','2022-11-23 16:25:15',NULL),(1336,8087,248,40720,1582,21,359,2,50000.00,NULL,'2022-11-23 16:25:15','2022-11-23 16:25:15',NULL),(1337,8087,249,40720,1583,21,62,1,93574.31,NULL,'2022-11-23 16:26:35','2022-11-23 16:26:35',NULL),(1338,8087,249,40720,1583,21,474,2,30000.00,NULL,'2022-11-23 16:26:35','2022-11-23 16:26:35',NULL),(1339,8087,249,40720,1583,21,359,2,63574.31,NULL,'2022-11-23 16:26:35','2022-11-23 16:26:35',NULL),(1340,8087,250,40720,1583,10,63,1,15393.29,NULL,'2022-11-23 16:28:59','2022-11-23 16:28:59',NULL),(1341,8087,250,40720,1583,10,64,1,2000.00,NULL,'2022-11-23 16:28:59','2022-11-23 16:28:59',NULL),(1342,8087,250,40720,1583,10,474,2,15393.29,NULL,'2022-11-23 16:28:59','2022-11-23 16:28:59',NULL),(1343,8087,250,40720,1583,10,359,2,2000.00,NULL,'2022-11-23 16:28:59','2022-11-23 16:28:59',NULL),(1344,8087,251,40720,1583,15,67,1,102594.63,NULL,'2022-11-23 16:31:07','2022-11-23 16:31:07',NULL),(1345,8087,251,40720,1583,15,68,2,50669.55,NULL,'2022-11-23 16:31:07','2022-11-23 16:31:07',NULL),(1346,8087,251,40720,1583,15,25,2,468.99,NULL,'2022-11-23 16:31:07','2022-11-23 16:31:07',NULL),(1347,8087,251,40720,1583,15,494,2,716.63,NULL,'2022-11-23 16:31:07','2022-11-23 16:31:07',NULL),(1348,8087,251,40720,1583,15,74,2,50739.46,NULL,'2022-11-23 16:31:07','2022-11-23 16:31:07',NULL),(1349,8087,252,40720,1583,10,156,1,17991.17,NULL,'2022-11-23 16:33:30','2022-11-23 16:33:30',NULL),(1350,8087,252,40720,1583,10,497,2,579.07,NULL,'2022-11-23 16:33:30','2022-11-23 16:33:30',NULL),(1351,8087,252,40720,1583,10,496,2,962.93,NULL,'2022-11-23 16:33:30','2022-11-23 16:33:30',NULL),(1352,8087,252,40720,1583,10,495,2,6867.89,NULL,'2022-11-23 16:33:30','2022-11-23 16:33:30',NULL),(1353,8087,252,40720,1583,10,277,2,327.66,NULL,'2022-11-23 16:33:30','2022-11-23 16:33:30',NULL);
INSERT INTO `balance_libro_details` VALUES (1354,8087,252,40720,1583,10,276,2,1493.81,NULL,'2022-11-23 16:33:30','2022-11-23 16:33:30',NULL),(1355,8087,252,40720,1583,10,474,2,7759.81,NULL,'2022-11-23 16:33:30','2022-11-23 16:33:30',NULL),(1356,8087,253,40720,1583,10,74,1,50739.46,NULL,'2022-11-23 16:34:29','2022-11-23 16:34:29',NULL),(1357,8087,253,40720,1583,10,474,2,50739.46,NULL,'2022-11-23 16:34:29','2022-11-23 16:34:29',NULL),(1358,8087,254,40720,1583,19,483,1,20000.00,NULL,'2022-11-23 16:35:11','2022-11-23 16:35:11',NULL),(1359,8087,254,40720,1583,19,474,2,20000.00,NULL,'2022-11-23 16:35:11','2022-11-23 16:35:11',NULL),(1360,8087,255,40720,1583,1,110,1,91852.19,NULL,'2022-11-23 16:36:41','2022-11-23 16:36:41',NULL),(1361,8087,255,40720,1583,1,191,1,9472.00,NULL,'2022-11-23 16:36:41','2022-11-23 16:36:41',NULL),(1362,8087,255,40720,1583,1,63,2,15423.92,NULL,'2022-11-23 16:36:41','2022-11-23 16:36:41',NULL),(1363,8087,255,40720,1583,1,62,2,83900.27,NULL,'2022-11-23 16:36:41','2022-11-23 16:36:41',NULL),(1364,8087,255,40720,1583,1,64,2,2000.00,NULL,'2022-11-23 16:36:41','2022-11-23 16:36:41',NULL),(1365,8087,256,40720,1583,3,392,1,327384.82,NULL,'2022-11-23 16:39:47','2022-11-23 16:39:47',NULL),(1366,8087,256,40720,1583,3,68,1,73093.51,NULL,'2022-11-23 16:39:47','2022-11-23 16:39:47',NULL),(1367,8087,256,40720,1583,3,494,1,546.81,NULL,'2022-11-23 16:39:47','2022-11-23 16:39:47',NULL),(1368,8087,256,40720,1583,3,496,1,1897.84,NULL,'2022-11-23 16:39:47','2022-11-23 16:39:47',NULL),(1369,8087,256,40720,1583,3,495,1,7493.30,NULL,'2022-11-23 16:39:47','2022-11-23 16:39:47',NULL),(1370,8087,256,40720,1583,3,116,1,15209.00,NULL,'2022-11-23 16:39:47','2022-11-23 16:39:47',NULL),(1371,8087,256,40720,1583,3,193,1,3202.72,NULL,'2022-11-23 16:39:47','2022-11-23 16:39:47',NULL),(1372,8087,256,40720,1583,3,484,1,6216.62,NULL,'2022-11-23 16:39:47','2022-11-23 16:39:47',NULL),(1373,8087,256,40720,1583,3,135,1,1466.04,NULL,'2022-11-23 16:39:47','2022-11-23 16:39:47',NULL),(1374,8087,256,40720,1583,3,128,1,2911.88,NULL,'2022-11-23 16:39:47','2022-11-23 16:39:47',NULL),(1375,8087,256,40720,1583,3,485,1,10182.10,NULL,'2022-11-23 16:39:47','2022-11-23 16:39:47',NULL),(1376,8087,256,40720,1583,3,359,2,449604.64,NULL,'2022-11-23 16:39:47','2022-11-23 16:39:47',NULL),(1377,8087,257,40720,1583,2,359,1,606470.35,NULL,'2022-11-23 16:41:34','2022-11-23 16:41:34',NULL),(1378,8087,257,40720,1583,2,67,2,105255.19,NULL,'2022-11-23 16:41:34','2022-11-23 16:41:34',NULL),(1379,8087,257,40720,1583,2,96,2,501215.16,NULL,'2022-11-23 16:41:34','2022-11-23 16:41:34',NULL),(1380,8087,258,40720,1583,5,157,1,2804.61,NULL,'2022-11-23 16:55:52','2022-11-23 16:55:52',NULL),(1381,8087,258,40720,1583,5,396,1,22174.66,NULL,'2022-11-23 16:55:52','2022-11-23 16:55:52',NULL),(1382,8087,258,40720,1583,5,277,1,594.30,NULL,'2022-11-23 16:55:52','2022-11-23 16:55:52',NULL),(1383,8087,258,40720,1583,5,276,1,1817.68,NULL,'2022-11-23 16:55:52','2022-11-23 16:55:52',NULL),(1384,8087,258,40720,1583,5,214,1,11148.42,NULL,'2022-11-23 16:55:52','2022-11-23 16:55:52',NULL),(1385,8087,258,40720,1583,5,474,1,301496.66,NULL,'2022-11-23 16:55:52','2022-11-23 16:55:52',NULL),(1386,8087,258,40720,1583,5,359,1,95455.81,NULL,'2022-11-23 16:55:52','2022-11-23 16:55:52',NULL),(1387,8087,258,40720,1583,5,474,2,133995.48,NULL,'2022-11-23 16:55:52','2022-11-23 16:55:52',NULL),(1388,8087,258,40720,1583,5,359,2,301496.66,NULL,'2022-11-23 16:55:52','2022-11-23 16:55:52',NULL),(1389,8087,259,40720,1584,21,62,1,83900.27,NULL,'2022-11-23 16:57:35','2022-11-23 16:57:35',NULL),(1390,8087,259,40720,1584,21,474,2,41799.00,NULL,'2022-11-23 16:57:35','2022-11-23 16:57:35',NULL),(1391,8087,259,40720,1584,21,498,2,42101.27,NULL,'2022-11-23 16:57:35','2022-11-23 16:57:35',NULL),(1392,8087,260,40720,1584,10,63,1,20389.96,NULL,'2022-11-23 16:59:46','2022-11-23 16:59:46',NULL),(1393,8087,260,40720,1584,10,488,1,129.38,NULL,'2022-11-23 16:59:46','2022-11-23 16:59:46',NULL);
INSERT INTO `balance_libro_details` VALUES (1394,8087,260,40720,1584,10,64,1,2000.00,NULL,'2022-11-23 16:59:46','2022-11-23 16:59:46',NULL),(1395,8087,260,40720,1584,10,474,2,20519.34,NULL,'2022-11-23 16:59:46','2022-11-23 16:59:46',NULL),(1396,8087,260,40720,1584,10,359,2,2000.00,NULL,'2022-11-23 16:59:46','2022-11-23 16:59:46',NULL),(1397,8087,261,40720,1584,15,67,1,105255.19,NULL,'2022-11-23 17:01:42','2022-11-23 17:01:42',NULL),(1398,8087,261,40720,1584,15,68,2,73093.51,NULL,'2022-11-23 17:01:42','2022-11-23 17:01:42',NULL),(1399,8087,261,40720,1584,15,494,2,684.23,NULL,'2022-11-23 17:01:42','2022-11-23 17:01:42',NULL),(1400,8087,261,40720,1584,15,74,2,31477.45,NULL,'2022-11-23 17:01:42','2022-11-23 17:01:42',NULL),(1401,8087,262,40720,1584,10,74,1,31477.45,NULL,'2022-11-23 17:02:44','2022-11-23 17:02:44',NULL),(1402,8087,262,40720,1584,10,474,2,31477.45,NULL,'2022-11-23 17:02:44','2022-11-23 17:02:44',NULL),(1403,8087,263,40720,1584,10,156,1,18765.05,NULL,'2022-11-23 17:05:34','2022-11-23 17:05:34',NULL),(1404,8087,263,40720,1584,10,496,2,1897.84,NULL,'2022-11-23 17:05:34','2022-11-23 17:05:34',NULL),(1405,8087,263,40720,1584,10,495,2,7493.30,NULL,'2022-11-23 17:05:34','2022-11-23 17:05:34',NULL),(1406,8087,263,40720,1584,10,277,2,594.30,NULL,'2022-11-23 17:05:34','2022-11-23 17:05:34',NULL),(1407,8087,263,40720,1584,10,276,2,1817.68,NULL,'2022-11-23 17:05:34','2022-11-23 17:05:34',NULL),(1408,8087,263,40720,1584,10,474,2,6961.93,NULL,'2022-11-23 17:05:34','2022-11-23 17:05:34',NULL),(1409,8087,264,40720,1584,1,110,1,100222.63,NULL,'2022-11-23 17:07:00','2022-11-23 17:07:00',NULL),(1410,8087,264,40720,1584,1,191,1,11430.69,NULL,'2022-11-23 17:07:00','2022-11-23 17:07:00',NULL),(1411,8087,264,40720,1584,1,63,2,18972.99,NULL,'2022-11-23 17:07:00','2022-11-23 17:07:00',NULL),(1412,8087,264,40720,1584,1,62,2,90680.33,NULL,'2022-11-23 17:07:00','2022-11-23 17:07:00',NULL),(1413,8087,264,40720,1584,1,64,2,2000.00,NULL,'2022-11-23 17:07:00','2022-11-23 17:07:00',NULL),(1414,8087,265,40720,1584,3,392,1,1110527.49,NULL,'2022-11-23 17:10:42','2022-11-23 17:10:42',NULL),(1415,8087,265,40720,1584,3,68,1,187590.19,NULL,'2022-11-23 17:10:42','2022-11-23 17:10:42',NULL),(1416,8087,265,40720,1584,3,25,1,537.30,NULL,'2022-11-23 17:10:42','2022-11-23 17:10:42',NULL),(1417,8087,265,40720,1584,3,494,1,2183.06,NULL,'2022-11-23 17:10:42','2022-11-23 17:10:42',NULL),(1418,8087,265,40720,1584,3,496,1,12042.04,NULL,'2022-11-23 17:10:42','2022-11-23 17:10:42',NULL),(1419,8087,265,40720,1584,3,495,1,17216.64,NULL,'2022-11-23 17:10:42','2022-11-23 17:10:42',NULL),(1420,8087,265,40720,1584,3,116,1,15209.00,NULL,'2022-11-23 17:10:42','2022-11-23 17:10:42',NULL),(1421,8087,265,40720,1584,3,193,1,3203.62,NULL,'2022-11-23 17:10:42','2022-11-23 17:10:42',NULL),(1422,8087,265,40720,1584,3,484,1,5492.64,NULL,'2022-11-23 17:10:42','2022-11-23 17:10:42',NULL),(1423,8087,265,40720,1584,3,135,1,4375.91,NULL,'2022-11-23 17:10:42','2022-11-23 17:10:42',NULL),(1424,8087,265,40720,1584,3,128,1,3420.82,NULL,'2022-11-23 17:10:42','2022-11-23 17:10:42',NULL),(1425,8087,265,40720,1584,3,485,1,967.20,NULL,'2022-11-23 17:10:42','2022-11-23 17:10:42',NULL),(1426,8087,265,40720,1584,3,359,2,558542.62,NULL,'2022-11-23 17:10:42','2022-11-23 17:10:42',NULL),(1427,8087,265,40720,1584,3,57,2,804223.29,NULL,'2022-11-23 17:10:42','2022-11-23 17:10:42',NULL),(1428,8087,266,40720,1584,2,359,1,744606.11,NULL,'2022-11-23 17:12:17','2022-11-23 17:12:17',NULL),(1429,8087,266,40720,1584,2,67,2,129229.16,NULL,'2022-11-23 17:12:17','2022-11-23 17:12:17',NULL),(1430,8087,266,40720,1584,2,96,2,615376.95,NULL,'2022-11-23 17:12:17','2022-11-23 17:12:17',NULL),(1431,8087,267,40720,1584,5,157,1,2457.47,NULL,'2022-11-23 17:15:24','2022-11-23 17:15:24',NULL),(1432,8087,267,40720,1584,5,396,1,1507.36,NULL,'2022-11-23 17:15:24','2022-11-23 17:15:24',NULL),(1433,8087,267,40720,1584,5,277,1,497.88,NULL,'2022-11-23 17:15:24','2022-11-23 17:15:24',NULL),(1434,8087,267,40720,1584,5,276,1,1522.78,NULL,'2022-11-23 17:15:24','2022-11-23 17:15:24',NULL);
INSERT INTO `balance_libro_details` VALUES (1435,8087,267,40720,1584,5,214,1,10933.42,NULL,'2022-11-23 17:15:24','2022-11-23 17:15:24',NULL),(1436,8087,267,40720,1584,5,474,1,252580.54,NULL,'2022-11-23 17:15:24','2022-11-23 17:15:24',NULL),(1437,8087,267,40720,1584,5,359,1,164731.42,NULL,'2022-11-23 17:15:24','2022-11-23 17:15:24',NULL),(1438,8087,267,40720,1584,5,474,2,181650.33,NULL,'2022-11-23 17:15:24','2022-11-23 17:15:24',NULL),(1439,8087,267,40720,1584,5,359,2,252580.54,NULL,'2022-11-23 17:15:24','2022-11-23 17:15:24',NULL),(1440,8087,268,40720,1585,10,63,1,18972.99,NULL,'2022-11-23 19:34:04','2022-11-23 19:34:04',NULL),(1441,8087,268,40720,1585,10,64,1,2000.00,NULL,'2022-11-23 19:34:04','2022-11-23 19:34:04',NULL),(1442,8087,268,40720,1585,10,474,2,18972.99,NULL,'2022-11-23 19:34:04','2022-11-23 19:34:04',NULL),(1443,8087,268,40720,1585,10,359,2,2000.00,NULL,'2022-11-23 19:34:04','2022-11-23 19:34:04',NULL),(1444,8087,269,40720,1585,21,62,1,90680.33,NULL,'2022-11-23 19:36:00','2022-11-23 19:36:00',NULL),(1445,8087,269,40720,1585,21,474,2,24250.00,NULL,'2022-11-23 19:36:00','2022-11-23 19:36:00',NULL),(1446,8087,269,40720,1585,21,498,2,42101.33,NULL,'2022-11-23 19:36:00','2022-11-23 19:36:00',NULL),(1447,8087,269,40720,1585,21,359,2,24329.00,NULL,'2022-11-23 19:36:00','2022-11-23 19:36:00',NULL),(1448,8087,270,40720,1585,15,67,1,129229.16,NULL,'2022-11-23 19:38:43','2022-11-23 19:38:43',NULL),(1449,8087,270,40720,1585,15,73,1,60831.64,NULL,'2022-11-23 19:38:43','2022-11-23 19:38:43',NULL),(1450,8087,270,40720,1585,15,68,2,187590.19,NULL,'2022-11-23 19:38:43','2022-11-23 19:38:43',NULL),(1451,8087,270,40720,1585,15,25,2,537.30,NULL,'2022-11-23 19:38:43','2022-11-23 19:38:43',NULL),(1452,8087,270,40720,1585,15,494,2,1933.31,NULL,'2022-11-23 19:38:43','2022-11-23 19:38:43',NULL),(1453,8087,271,40720,1585,10,156,1,23783.54,NULL,'2022-11-23 19:42:14','2022-11-23 19:42:14',NULL),(1454,8087,271,40720,1585,10,497,1,6947.90,NULL,'2022-11-23 19:42:14','2022-11-23 19:42:14',NULL),(1455,8087,271,40720,1585,10,496,2,11858.80,NULL,'2022-11-23 19:42:14','2022-11-23 19:42:14',NULL),(1456,8087,271,40720,1585,10,495,2,16851.98,NULL,'2022-11-23 19:42:14','2022-11-23 19:42:14',NULL),(1457,8087,271,40720,1585,10,277,2,497.88,NULL,'2022-11-23 19:42:14','2022-11-23 19:42:14',NULL),(1458,8087,271,40720,1585,10,276,2,1522.78,NULL,'2022-11-23 19:42:14','2022-11-23 19:42:14',NULL),(1459,8087,272,40720,1585,1,110,1,100222.63,NULL,'2022-11-23 19:44:00','2022-11-23 19:44:00',NULL),(1460,8087,272,40720,1585,1,191,1,11431.36,NULL,'2022-11-23 19:44:00','2022-11-23 19:44:00',NULL),(1461,8087,272,40720,1585,1,63,2,18972.99,NULL,'2022-11-23 19:44:00','2022-11-23 19:44:00',NULL),(1462,8087,272,40720,1585,1,62,2,90681.00,NULL,'2022-11-23 19:44:00','2022-11-23 19:44:00',NULL),(1463,8087,272,40720,1585,1,64,2,2000.00,NULL,'2022-11-23 19:44:00','2022-11-23 19:44:00',NULL),(1464,8087,273,40720,1585,3,392,1,485919.80,NULL,'2022-11-23 19:49:32','2022-11-23 19:49:32',NULL),(1465,8087,273,40720,1585,3,68,1,104827.11,NULL,'2022-11-23 19:49:32','2022-11-23 19:49:32',NULL),(1466,8087,273,40720,1585,3,25,1,460.79,NULL,'2022-11-23 19:49:32','2022-11-23 19:49:32',NULL),(1467,8087,273,40720,1585,3,494,1,1000.16,NULL,'2022-11-23 19:49:32','2022-11-23 19:49:32',NULL),(1468,8087,273,40720,1585,3,496,1,4511.05,NULL,'2022-11-23 19:49:32','2022-11-23 19:49:32',NULL),(1469,8087,273,40720,1585,3,495,1,11463.87,NULL,'2022-11-23 19:49:32','2022-11-23 19:49:32',NULL),(1470,8087,273,40720,1585,3,116,1,15209.00,NULL,'2022-11-23 19:49:32','2022-11-23 19:49:32',NULL),(1471,8087,273,40720,1585,3,193,1,13429.78,NULL,'2022-11-23 19:49:32','2022-11-23 19:49:32',NULL),(1472,8087,273,40720,1585,3,484,1,5595.44,NULL,'2022-11-23 19:49:32','2022-11-23 19:49:32',NULL),(1473,8087,273,40720,1585,3,135,1,4857.70,NULL,'2022-11-23 19:49:32','2022-11-23 19:49:32',NULL),(1474,8087,273,40720,1585,3,128,1,3720.08,NULL,'2022-11-23 19:49:32','2022-11-23 19:49:32',NULL);
INSERT INTO `balance_libro_details` VALUES (1475,8087,273,40720,1585,3,485,1,1100.00,NULL,'2022-11-23 19:49:32','2022-11-23 19:49:32',NULL),(1476,8087,273,40720,1585,3,359,2,502102.57,NULL,'2022-11-23 19:49:32','2022-11-23 19:49:32',NULL),(1477,8087,273,40720,1585,3,57,2,149992.21,NULL,'2022-11-23 19:49:32','2022-11-23 19:49:32',NULL),(1478,8087,274,40720,1585,2,359,1,565210.96,NULL,'2022-11-23 19:50:54','2022-11-23 19:50:54',NULL),(1479,8087,274,40720,1585,2,67,2,98094.46,NULL,'2022-11-23 19:50:54','2022-11-23 19:50:54',NULL),(1480,8087,274,40720,1585,2,96,2,467116.50,NULL,'2022-11-23 19:50:54','2022-11-23 19:50:54',NULL),(1481,8087,275,40720,1585,5,157,1,1920.09,NULL,'2022-11-23 19:53:57','2022-11-23 19:53:57',NULL),(1482,8087,275,40720,1585,5,396,1,1488.00,NULL,'2022-11-23 19:53:57','2022-11-23 19:53:57',NULL),(1483,8087,275,40720,1585,5,277,1,2839.09,NULL,'2022-11-23 19:53:57','2022-11-23 19:53:57',NULL),(1484,8087,275,40720,1585,5,276,1,1225.47,NULL,'2022-11-23 19:53:57','2022-11-23 19:53:57',NULL),(1485,8087,275,40720,1585,5,214,1,11519.53,NULL,'2022-11-23 19:53:57','2022-11-23 19:53:57',NULL),(1486,8087,275,40720,1585,5,474,1,254037.21,NULL,'2022-11-23 19:53:57','2022-11-23 19:53:57',NULL),(1487,8087,275,40720,1585,5,359,1,243689.38,NULL,'2022-11-23 19:53:57','2022-11-23 19:53:57',NULL),(1488,8087,275,40720,1585,5,474,2,262681.56,NULL,'2022-11-23 19:53:57','2022-11-23 19:53:57',NULL),(1489,8087,275,40720,1585,5,359,2,254037.21,NULL,'2022-11-23 19:53:57','2022-11-23 19:53:57',NULL),(1490,8087,276,40720,1586,15,67,1,98094.46,NULL,'2022-11-23 20:00:28','2022-11-23 20:00:28',NULL),(1491,8087,276,40720,1586,15,73,1,8193.60,NULL,'2022-11-23 20:00:28','2022-11-23 20:00:28',NULL),(1492,8087,276,40720,1586,15,68,2,104827.11,NULL,'2022-11-23 20:00:28','2022-11-23 20:00:28',NULL),(1493,8087,276,40720,1586,15,25,2,460.79,NULL,'2022-11-23 20:00:28','2022-11-23 20:00:28',NULL),(1494,8087,276,40720,1586,15,494,2,1000.16,NULL,'2022-11-23 20:00:28','2022-11-23 20:00:28',NULL),(1495,8087,277,40720,1586,16,156,1,17360.44,NULL,'2022-11-23 20:03:49','2022-11-23 20:03:49',NULL),(1496,8087,277,40720,1586,16,497,1,5011.68,NULL,'2022-11-23 20:03:49','2022-11-23 20:03:49',NULL),(1497,8087,277,40720,1586,16,277,2,2839.09,NULL,'2022-11-23 20:03:49','2022-11-23 20:03:49',NULL),(1498,8087,277,40720,1586,16,276,2,1225.47,NULL,'2022-11-23 20:03:49','2022-11-23 20:03:49',NULL),(1499,8087,277,40720,1586,16,496,2,4402.72,NULL,'2022-11-23 20:03:49','2022-11-23 20:03:49',NULL),(1500,8087,277,40720,1586,16,495,2,11241.67,NULL,'2022-11-23 20:03:49','2022-11-23 20:03:49',NULL),(1501,8087,277,40720,1586,16,492,2,2663.17,NULL,'2022-11-23 20:03:49','2022-11-23 20:03:49',NULL),(1502,8087,278,40720,1586,21,62,1,70341.00,NULL,'2022-11-23 20:06:59','2022-11-23 20:06:59',NULL),(1503,8087,278,40720,1586,21,474,2,70341.00,NULL,'2022-11-23 20:06:59','2022-11-23 20:06:59',NULL),(1504,8087,279,40720,1586,19,483,1,30000.00,NULL,'2022-11-23 20:08:25','2022-11-23 20:08:25',NULL),(1505,8087,279,40720,1586,19,474,2,30000.00,NULL,'2022-11-23 20:08:25','2022-11-23 20:08:25',NULL),(1506,8087,280,40720,1586,21,57,1,60000.00,NULL,'2022-11-23 20:09:52','2022-11-23 20:09:52',NULL),(1507,8087,280,40720,1586,21,359,2,60000.00,NULL,'2022-11-23 20:09:52','2022-11-23 20:09:52',NULL),(1508,8087,281,40720,1586,15,67,1,124416.09,NULL,'2022-11-23 20:12:03','2022-11-23 20:12:03',NULL),(1509,8087,281,40720,1586,15,73,2,15663.36,NULL,'2022-11-23 20:12:03','2022-11-23 20:12:03',NULL),(1510,8087,281,40720,1586,15,68,2,106146.20,NULL,'2022-11-23 20:12:03','2022-11-23 20:12:03',NULL),(1511,8087,281,40720,1586,15,25,2,812.86,NULL,'2022-11-23 20:12:03','2022-11-23 20:12:03',NULL),(1512,8087,281,40720,1586,15,494,2,1793.67,NULL,'2022-11-23 20:12:03','2022-11-23 20:12:03',NULL),(1513,8087,282,40720,1586,16,156,1,22758.68,NULL,'2022-11-23 20:15:12','2022-11-23 20:15:12',NULL),(1514,8087,282,40720,1586,16,497,1,7252.65,NULL,'2022-11-23 20:15:12','2022-11-23 20:15:12',NULL);
INSERT INTO `balance_libro_details` VALUES (1515,8087,282,40720,1586,16,496,2,3224.32,NULL,'2022-11-23 20:15:12','2022-11-23 20:15:12',NULL),(1516,8087,282,40720,1586,16,495,2,13673.84,NULL,'2022-11-23 20:15:12','2022-11-23 20:15:12',NULL),(1517,8087,282,40720,1586,16,277,2,3875.09,NULL,'2022-11-23 20:15:12','2022-11-23 20:15:12',NULL),(1518,8087,282,40720,1586,16,276,2,1912.11,NULL,'2022-11-23 20:15:12','2022-11-23 20:15:12',NULL),(1519,8087,282,40720,1586,16,492,2,7325.97,NULL,'2022-11-23 20:15:12','2022-11-23 20:15:12',NULL),(1520,8087,283,40720,1586,21,62,1,90681.00,NULL,'2022-11-23 20:16:30','2022-11-23 20:16:30',NULL),(1521,8087,283,40720,1586,21,474,2,90681.00,NULL,'2022-11-23 20:16:30','2022-11-23 20:16:30',NULL),(1522,8087,284,40720,1586,1,110,1,150333.95,NULL,'2022-11-23 20:18:47','2022-11-23 20:18:47',NULL),(1523,8087,284,40720,1586,1,191,1,17658.24,NULL,'2022-11-23 20:18:47','2022-11-23 20:18:47',NULL),(1524,8087,284,40720,1586,1,63,2,29970.19,NULL,'2022-11-23 20:18:47','2022-11-23 20:18:47',NULL),(1525,8087,284,40720,1586,1,62,2,136022.00,NULL,'2022-11-23 20:18:47','2022-11-23 20:18:47',NULL),(1526,8087,284,40720,1586,1,64,2,2000.00,NULL,'2022-11-23 20:18:47','2022-11-23 20:18:47',NULL),(1527,8087,285,40720,1586,3,392,1,488328.15,NULL,'2022-11-23 20:23:01','2022-11-23 20:23:01',NULL),(1528,8087,285,40720,1586,3,68,1,106146.20,NULL,'2022-11-23 20:23:01','2022-11-23 20:23:01',NULL),(1529,8087,285,40720,1586,3,25,1,812.86,NULL,'2022-11-23 20:23:01','2022-11-23 20:23:01',NULL),(1530,8087,285,40720,1586,3,494,1,1793.67,NULL,'2022-11-23 20:23:01','2022-11-23 20:23:01',NULL),(1531,8087,285,40720,1586,3,496,1,3224.32,NULL,'2022-11-23 20:23:01','2022-11-23 20:23:01',NULL),(1532,8087,285,40720,1586,3,495,1,13673.84,NULL,'2022-11-23 20:23:01','2022-11-23 20:23:01',NULL),(1533,8087,285,40720,1586,3,116,1,15209.00,NULL,'2022-11-23 20:23:01','2022-11-23 20:23:01',NULL),(1534,8087,285,40720,1586,3,193,1,7696.42,NULL,'2022-11-23 20:23:01','2022-11-23 20:23:01',NULL),(1535,8087,285,40720,1586,3,484,1,6714.38,NULL,'2022-11-23 20:23:01','2022-11-23 20:23:01',NULL),(1536,8087,285,40720,1586,3,135,1,27342.04,NULL,'2022-11-23 20:23:01','2022-11-23 20:23:01',NULL),(1537,8087,285,40720,1586,3,128,1,3335.03,NULL,'2022-11-23 20:23:01','2022-11-23 20:23:01',NULL),(1538,8087,285,40720,1586,3,485,1,1100.00,NULL,'2022-11-23 20:23:01','2022-11-23 20:23:01',NULL),(1539,8087,285,40720,1586,3,57,2,314900.40,NULL,'2022-11-23 20:23:01','2022-11-23 20:23:01',NULL),(1540,8087,285,40720,1586,3,359,2,360475.51,NULL,'2022-11-23 20:23:01','2022-11-23 20:23:01',NULL),(1541,8087,286,40720,1586,2,359,1,716873.66,NULL,'2022-11-23 20:24:25','2022-11-23 20:24:25',NULL),(1542,8087,286,40720,1586,2,67,2,124416.09,NULL,'2022-11-23 20:24:25','2022-11-23 20:24:25',NULL),(1543,8087,286,40720,1586,2,96,2,592457.57,NULL,'2022-11-23 20:24:25','2022-11-23 20:24:25',NULL),(1544,8087,287,40720,1586,5,157,1,3336.38,NULL,'2022-11-23 20:28:15','2022-11-23 20:28:15',NULL),(1545,8087,287,40720,1586,5,396,1,1488.00,NULL,'2022-11-23 20:28:15','2022-11-23 20:28:15',NULL),(1546,8087,287,40720,1586,5,277,1,3875.09,NULL,'2022-11-23 20:28:15','2022-11-23 20:28:15',NULL),(1547,8087,287,40720,1586,5,276,1,1912.11,NULL,'2022-11-23 20:28:15','2022-11-23 20:28:15',NULL),(1548,8087,287,40720,1586,5,214,1,5195.92,NULL,'2022-11-23 20:28:15','2022-11-23 20:28:15',NULL),(1549,8087,287,40720,1586,5,474,1,418893.16,NULL,'2022-11-23 20:28:15','2022-11-23 20:28:15',NULL),(1550,8087,287,40720,1586,5,359,1,240980.63,NULL,'2022-11-23 20:28:15','2022-11-23 20:28:15',NULL),(1551,8087,287,40720,1586,5,474,2,256788.13,NULL,'2022-11-23 20:28:15','2022-11-23 20:28:15',NULL),(1552,8087,287,40720,1586,5,359,2,418893.16,NULL,'2022-11-23 20:28:15','2022-11-23 20:28:15',NULL),(1553,8087,288,40720,1586,4,132,1,15533.64,NULL,'2022-11-23 20:34:32','2023-01-06 15:54:29','2023-01-06 15:54:29'),(1554,8087,288,40720,1586,4,48,2,15533.64,NULL,'2022-11-23 20:34:32','2023-01-06 15:54:29','2023-01-06 15:54:29');
INSERT INTO `balance_libro_details` VALUES (1555,8087,289,40720,1586,19,135,1,2015.14,NULL,'2022-11-23 20:36:19','2022-11-23 20:36:19',NULL),(1556,8087,289,40720,1586,19,494,2,112.33,NULL,'2022-11-23 20:36:19','2022-11-23 20:36:19',NULL),(1557,8087,289,40720,1586,19,496,2,402.92,NULL,'2022-11-23 20:36:19','2022-11-23 20:36:19',NULL),(1558,8087,289,40720,1586,19,495,2,1499.89,NULL,'2022-11-23 20:36:19','2022-11-23 20:36:19',NULL),(1559,8087,290,40720,1586,19,493,1,4002107.80,NULL,'2022-11-23 20:38:46','2023-03-01 14:49:10','2023-03-01 14:49:10'),(1560,8087,290,40720,1586,19,392,2,4002107.80,NULL,'2022-11-23 20:38:46','2023-03-01 14:49:10','2023-03-01 14:49:10'),(1561,8087,291,40720,1575,5,157,1,6133.15,NULL,'2022-11-24 08:47:09','2022-11-24 08:47:09',NULL),(1562,8087,291,40720,1575,5,396,1,3385.28,NULL,'2022-11-24 08:47:09','2022-11-24 08:47:09',NULL),(1563,8087,291,40720,1575,5,214,1,3703.30,NULL,'2022-11-24 08:47:09','2022-11-24 08:47:09',NULL),(1564,8087,291,40720,1575,5,474,1,721679.31,NULL,'2022-11-24 08:47:09','2022-11-24 08:47:09',NULL),(1565,8087,291,40720,1575,5,359,1,186292.19,NULL,'2022-11-24 08:47:09','2022-11-24 08:47:09',NULL),(1566,8087,291,40720,1575,5,474,2,212504.15,NULL,'2022-11-24 08:47:09','2022-11-24 08:47:09',NULL),(1567,8087,291,40720,1575,5,359,2,721679.31,NULL,'2022-11-24 08:47:09','2022-11-24 08:47:09',NULL),(1568,8087,291,40720,1575,5,277,1,11459.97,NULL,'2022-11-24 08:47:09','2022-11-24 08:47:09',NULL),(1569,8087,291,40720,1575,5,276,1,1530.26,NULL,'2022-11-24 08:47:09','2022-11-24 08:47:09',NULL),(1570,8087,292,40720,1576,10,487,1,16293.06,NULL,'2022-11-24 08:49:28','2022-11-24 08:49:28',NULL),(1571,8087,292,40720,1576,10,474,2,17811.08,NULL,'2022-11-24 08:49:28','2022-11-24 08:49:28',NULL),(1572,8087,292,40720,1576,10,488,1,1518.02,NULL,'2022-11-24 08:49:28','2022-11-24 08:49:28',NULL),(1573,8087,293,40720,1576,10,488,1,55.90,NULL,'2022-11-24 08:57:48','2022-11-24 08:57:48',NULL),(1574,8087,293,40720,1576,10,474,2,8202.43,NULL,'2022-11-24 08:57:48','2022-11-24 08:57:48',NULL),(1575,8087,293,40720,1576,10,487,1,8146.53,NULL,'2022-11-24 08:57:48','2022-11-24 08:57:48',NULL),(1576,8087,294,40720,1586,23,191,1,55737.07,NULL,'2022-11-24 11:17:32','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1577,8087,294,40720,1586,23,485,1,2561.63,NULL,'2022-11-24 11:17:32','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1578,8087,294,40720,1586,23,135,1,2072.55,NULL,'2022-11-24 11:17:33','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1579,8087,294,40720,1586,23,116,1,32140.41,NULL,'2022-11-24 11:17:33','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1580,8087,294,40720,1586,23,488,1,1499.80,NULL,'2022-11-24 11:17:33','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1581,8087,294,40720,1586,23,381,2,3490.04,NULL,'2022-11-24 11:17:34','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1582,8087,294,40720,1586,23,48,2,3358.07,NULL,'2022-11-24 11:17:34','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1583,8087,294,40720,1586,23,392,1,1227776.85,NULL,'2022-11-24 11:17:34','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1584,8087,294,40720,1586,23,110,1,205529.39,NULL,'2022-11-24 11:17:35','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1585,8087,294,40720,1586,23,128,1,7513.70,NULL,'2022-11-24 11:17:35','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1586,8087,294,40720,1586,23,484,1,10316.91,NULL,'2022-11-24 11:17:35','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1587,8087,294,40720,1586,23,96,2,1071550.69,NULL,'2022-11-24 11:17:36','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1588,8087,294,40720,1586,23,383,2,179309.25,NULL,'2022-11-24 11:17:36','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1589,8087,294,40720,1586,23,88,2,19884.64,NULL,'2022-11-24 11:17:37','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1590,8087,294,40720,1586,23,363,1,51480.14,NULL,'2022-11-24 11:17:38','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1591,8087,294,40720,1586,23,193,1,6028.31,NULL,'2022-11-24 11:17:38','2023-01-06 16:05:30','2023-01-06 16:05:30');
INSERT INTO `balance_libro_details` VALUES (1592,8087,294,40720,1586,23,214,1,13808.70,NULL,'2022-11-24 11:17:39','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1593,8087,294,40720,1586,23,277,1,1131.54,NULL,'2022-11-24 11:17:40','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1594,8087,294,40720,1586,23,157,1,7742.21,NULL,'2022-11-24 11:17:40','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1595,8087,294,40720,1586,23,276,1,369.17,NULL,'2022-11-24 11:17:41','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1596,8087,294,40720,1586,23,396,1,8827.81,NULL,'2022-11-24 11:17:41','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1597,8087,294,40720,1586,23,156,1,31058.70,NULL,'2022-11-24 11:17:42','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1598,8087,294,40720,1586,23,498,2,24135.81,NULL,'2022-11-24 11:17:42','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1599,8087,294,40720,1586,23,476,2,363866.39,NULL,'2022-11-24 11:17:43','2023-01-06 16:05:30','2023-01-06 16:05:30'),(1600,8087,295,40720,1590,12,359,1,543065.27,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1601,8087,295,40720,1590,12,474,1,68746.43,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1602,8087,295,40720,1590,12,497,1,19212.23,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1603,8087,295,40720,1590,12,499,1,53361.88,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1604,8087,295,40720,1590,12,20,1,97768.13,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1605,8087,295,40720,1590,12,23,1,19598.54,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1606,8087,295,40720,1590,12,482,1,772600.00,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1607,8087,295,40720,1590,12,483,1,785000.00,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1608,8087,295,40720,1590,12,392,1,2240000.00,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1609,8087,295,40720,1590,12,363,1,155336.42,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1610,8087,295,40720,1590,12,48,2,25666.30,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1611,8087,295,40720,1590,12,57,2,3159779.17,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1612,8087,295,40720,1590,12,492,2,9989.14,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1613,8087,295,40720,1590,12,63,2,48943.18,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1614,8087,295,40720,1590,12,64,2,4000.00,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1615,8087,295,40720,1590,12,62,2,65681.00,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1616,8087,295,40720,1590,12,486,2,925000.00,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1617,8087,295,40720,1590,12,369,2,60000.00,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1618,8087,295,40720,1590,12,381,2,10530.86,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1619,8087,295,40720,1590,12,494,2,91.02,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1620,8087,295,40720,1590,12,383,2,445008.23,NULL,'2022-12-06 12:27:20','2023-03-06 12:16:43','2023-03-06 12:16:43'),(1621,8087,296,40720,1590,10,63,1,29970.19,NULL,'2022-12-06 12:33:08','2022-12-06 12:33:08',NULL),(1622,8087,296,40720,1590,10,64,1,2000.00,NULL,'2022-12-06 12:33:08','2022-12-06 12:33:08',NULL),(1623,8087,296,40720,1590,10,474,2,29970.19,NULL,'2022-12-06 12:33:08','2022-12-06 12:33:08',NULL),(1624,8087,296,40720,1590,10,359,2,2000.00,NULL,'2022-12-06 12:33:08','2022-12-06 12:33:08',NULL),(1625,8087,297,40720,1590,10,63,1,18972.99,NULL,'2022-12-06 12:35:59','2022-12-06 12:35:59',NULL),(1626,8087,297,40720,1590,10,64,1,2000.00,NULL,'2022-12-06 12:35:59','2022-12-06 12:35:59',NULL);
INSERT INTO `balance_libro_details` VALUES (1627,8087,297,40720,1590,10,474,2,18972.99,NULL,'2022-12-06 12:35:59','2022-12-06 12:35:59',NULL),(1628,8087,297,40720,1590,10,359,2,2000.00,NULL,'2022-12-06 12:35:59','2022-12-06 12:35:59',NULL),(1629,8087,298,40720,1590,1,62,1,65681.00,NULL,'2022-12-06 12:39:53','2022-12-06 12:39:53',NULL),(1630,8087,298,40720,1590,1,359,2,65681.00,NULL,'2022-12-06 12:39:53','2022-12-06 12:39:53',NULL),(1631,8087,299,40720,1590,10,492,1,9989.14,NULL,'2022-12-06 12:43:26','2022-12-06 12:43:26',NULL),(1632,8087,299,40720,1590,10,474,2,9989.14,NULL,'2022-12-06 12:43:26','2022-12-06 12:43:26',NULL),(1633,8087,300,40720,1590,19,483,1,50000.00,NULL,'2022-12-06 12:45:40','2022-12-06 12:45:40',NULL),(1634,8087,300,40720,1590,19,474,2,50000.00,NULL,'2022-12-06 12:45:40','2022-12-06 12:45:40',NULL),(1635,8087,301,40720,1590,19,483,1,50000.00,NULL,'2022-12-06 12:45:51','2022-12-06 12:46:11','2022-12-06 12:46:11'),(1636,8087,301,40720,1590,19,474,2,50000.00,NULL,'2022-12-06 12:45:51','2022-12-06 12:46:11','2022-12-06 12:46:11'),(1637,8087,302,40720,1590,19,483,1,50000.00,NULL,'2022-12-06 12:45:51','2022-12-06 12:45:58','2022-12-06 12:45:58'),(1638,8087,302,40720,1590,19,474,2,50000.00,NULL,'2022-12-06 12:45:52','2022-12-06 12:45:58','2022-12-06 12:45:58'),(1639,8087,303,40720,1590,2,359,1,820551.24,NULL,'2022-12-06 12:50:08','2022-12-06 12:50:08',NULL),(1640,8087,303,40720,1590,2,67,2,142409.72,NULL,'2022-12-06 12:50:08','2022-12-06 12:50:08',NULL),(1641,8087,303,40720,1590,2,96,2,678141.52,NULL,'2022-12-06 12:50:08','2022-12-06 12:50:08',NULL),(1642,8087,304,40720,1590,3,392,1,754841.25,NULL,'2022-12-06 12:56:34','2022-12-06 12:56:34',NULL),(1643,8087,304,40720,1590,3,68,1,160111.56,NULL,'2022-12-06 12:56:34','2022-12-06 12:56:34',NULL),(1644,8087,304,40720,1590,3,494,1,4238.30,NULL,'2022-12-06 12:56:34','2022-12-06 12:56:34',NULL),(1645,8087,304,40720,1590,3,496,1,6719.08,NULL,'2022-12-06 12:56:34','2022-12-06 12:56:34',NULL),(1646,8087,304,40720,1590,3,495,1,14979.49,NULL,'2022-12-06 12:56:34','2022-12-06 12:56:34',NULL),(1647,8087,304,40720,1590,3,193,1,4301.82,NULL,'2022-12-06 12:56:34','2022-12-06 12:56:34',NULL),(1648,8087,304,40720,1590,3,484,1,2408.97,NULL,'2022-12-06 12:56:34','2022-12-06 12:56:34',NULL),(1649,8087,304,40720,1590,3,135,1,17906.30,NULL,'2022-12-06 12:56:34','2022-12-06 12:56:34',NULL),(1650,8087,304,40720,1590,3,128,1,2295.17,NULL,'2022-12-06 12:56:34','2022-12-06 12:56:34',NULL),(1651,8087,304,40720,1590,3,359,2,967801.94,NULL,'2022-12-06 12:56:34','2022-12-06 12:56:34',NULL),(1652,8087,305,40720,1590,1,110,1,107756.02,NULL,'2022-12-06 12:59:49','2022-12-06 12:59:49',NULL),(1653,8087,305,40720,1590,1,191,1,13194.12,NULL,'2022-12-06 12:59:49','2022-12-06 12:59:49',NULL),(1654,8087,305,40720,1590,1,63,2,22167.14,NULL,'2022-12-06 12:59:49','2022-12-06 12:59:49',NULL),(1655,8087,305,40720,1590,1,64,2,2000.00,NULL,'2022-12-06 12:59:49','2022-12-06 12:59:49',NULL),(1656,8087,305,40720,1590,1,62,2,96783.00,NULL,'2022-12-06 12:59:49','2022-12-06 12:59:49',NULL),(1657,8087,306,40720,1590,5,157,1,3029.29,NULL,'2022-12-06 13:04:56','2022-12-06 13:04:56',NULL),(1658,8087,306,40720,1590,5,396,1,1488.00,NULL,'2022-12-06 13:04:56','2022-12-06 13:04:56',NULL),(1659,8087,306,40720,1590,5,276,1,337.81,NULL,'2022-12-06 13:04:56','2022-12-06 13:04:56',NULL),(1660,8087,306,40720,1590,5,277,1,295.60,NULL,'2022-12-06 13:04:56','2022-12-06 13:04:56',NULL),(1661,8087,306,40720,1590,5,57,1,46802.59,NULL,'2022-12-06 13:04:56','2022-12-06 13:04:56',NULL),(1662,8087,306,40720,1590,5,495,1,3197.41,NULL,'2022-12-06 13:04:56','2022-12-06 13:04:56',NULL),(1663,8087,306,40720,1590,5,214,1,8893.29,NULL,'2022-12-06 13:04:56','2022-12-06 13:04:56',NULL),(1664,8087,306,40720,1590,5,474,1,349791.80,NULL,'2022-12-06 13:04:56','2022-12-06 13:04:56',NULL),(1665,8087,306,40720,1590,5,359,1,79800.44,NULL,'2022-12-06 13:04:56','2022-12-06 13:04:56',NULL),(1666,8087,306,40720,1590,5,474,2,143844.43,NULL,'2022-12-06 13:04:56','2022-12-06 13:04:56',NULL);
INSERT INTO `balance_libro_details` VALUES (1667,8087,306,40720,1590,5,359,2,349791.80,NULL,'2022-12-06 13:04:56','2022-12-06 13:04:56',NULL),(1668,8087,307,40720,1590,21,62,1,96783.00,NULL,'2022-12-06 14:36:22','2022-12-06 14:36:22',NULL),(1669,8087,307,40720,1590,21,474,2,96783.00,NULL,'2022-12-06 14:36:22','2022-12-06 14:36:22',NULL),(1670,8087,308,40720,1591,10,63,1,22167.14,NULL,'2022-12-06 14:41:20','2022-12-06 14:41:20',NULL),(1671,8087,308,40720,1591,10,64,1,2000.00,NULL,'2022-12-06 14:41:20','2022-12-06 14:41:20',NULL),(1672,8087,308,40720,1591,10,474,2,22167.14,NULL,'2022-12-06 14:41:20','2022-12-06 14:41:20',NULL),(1673,8087,308,40720,1591,10,359,2,2000.00,NULL,'2022-12-06 14:41:20','2022-12-06 14:41:20',NULL),(1674,8087,309,40720,1591,15,67,1,142409.72,NULL,'2022-12-06 14:50:13','2022-12-06 14:50:13',NULL),(1675,8087,309,40720,1591,15,499,1,21940.14,NULL,'2022-12-06 14:50:13','2022-12-06 14:50:13',NULL),(1676,8087,309,40720,1591,15,494,2,4238.30,NULL,'2022-12-06 14:50:13','2022-12-06 14:50:13',NULL),(1677,8087,309,40720,1591,15,68,2,160111.56,NULL,'2022-12-06 14:50:13','2022-12-06 14:50:13',NULL),(1678,8087,310,40720,1591,10,156,1,26453.66,NULL,'2022-12-06 15:02:35','2022-12-06 15:02:35',NULL),(1679,8087,310,40720,1591,10,497,1,7292.39,NULL,'2022-12-06 15:02:35','2022-12-06 15:02:35',NULL),(1680,8087,310,40720,1591,10,496,2,6577.37,NULL,'2022-12-06 15:02:35','2022-12-06 15:02:35',NULL),(1681,8087,310,40720,1591,10,495,2,18176.90,NULL,'2022-12-06 15:02:35','2022-12-06 15:02:35',NULL),(1682,8087,310,40720,1591,10,276,2,337.81,NULL,'2022-12-06 15:02:35','2022-12-06 15:02:35',NULL),(1683,8087,310,40720,1591,10,277,2,295.60,NULL,'2022-12-06 15:02:35','2022-12-06 15:02:35',NULL),(1684,8087,310,40720,1591,10,474,2,8358.37,NULL,'2022-12-06 15:02:35','2022-12-06 15:02:35',NULL),(1685,8087,311,40720,1591,3,392,1,364198.48,NULL,'2022-12-06 15:17:10','2022-12-06 15:17:10',NULL),(1686,8087,311,40720,1591,3,68,1,79312.50,NULL,'2022-12-06 15:17:10','2022-12-06 15:17:10',NULL),(1687,8087,311,40720,1591,3,494,1,3015.38,NULL,'2022-12-06 15:17:10','2022-12-06 15:17:10',NULL),(1688,8087,311,40720,1591,3,496,1,4064.28,NULL,'2022-12-06 15:17:10','2022-12-06 15:17:10',NULL),(1689,8087,311,40720,1591,3,495,1,9796.51,NULL,'2022-12-06 15:17:10','2022-12-06 15:17:10',NULL),(1690,8087,311,40720,1591,3,484,1,3393.91,NULL,'2022-12-06 15:17:10','2022-12-06 15:17:10',NULL),(1691,8087,311,40720,1591,3,116,1,17490.00,NULL,'2022-12-06 15:17:10','2022-12-06 15:17:10',NULL),(1692,8087,311,40720,1591,3,193,1,5511.93,NULL,'2022-12-06 15:17:10','2022-12-06 15:17:10',NULL),(1693,8087,311,40720,1591,3,135,1,11101.55,NULL,'2022-12-06 15:17:10','2022-12-06 15:17:10',NULL),(1694,8087,311,40720,1591,3,128,1,4496.63,NULL,'2022-12-06 15:17:10','2022-12-06 15:17:10',NULL),(1695,8087,311,40720,1591,3,485,1,1100.00,NULL,'2022-12-06 15:17:11','2022-12-06 15:17:11',NULL),(1696,8087,311,40720,1591,3,359,2,183481.17,NULL,'2022-12-06 15:17:11','2022-12-06 15:17:11',NULL),(1697,8087,311,40720,1591,3,57,2,320000.00,NULL,'2022-12-06 15:17:11','2022-12-06 15:17:11',NULL),(1698,8087,312,40720,1591,2,359,1,328536.65,NULL,'2022-12-06 15:28:24','2022-12-06 15:28:24',NULL),(1699,8087,312,40720,1591,2,67,2,57018.76,NULL,'2022-12-06 15:28:24','2022-12-06 15:28:24',NULL),(1700,8087,312,40720,1591,2,96,2,271517.89,NULL,'2022-12-06 15:28:24','2022-12-06 15:28:24',NULL),(1701,8087,313,40720,1591,1,110,1,117605.93,NULL,'2022-12-06 15:30:17','2022-12-06 15:30:17',NULL),(1702,8087,313,40720,1591,1,191,1,14472.24,NULL,'2022-12-06 15:30:17','2022-12-06 15:30:17',NULL),(1703,8087,313,40720,1591,1,63,2,24430.17,NULL,'2022-12-06 15:30:17','2022-12-06 15:30:17',NULL),(1704,8087,313,40720,1591,1,62,2,105648.00,NULL,'2022-12-06 15:30:17','2022-12-06 15:30:17',NULL),(1705,8087,313,40720,1591,1,64,2,2000.00,NULL,'2022-12-06 15:30:17','2022-12-06 15:30:17',NULL),(1706,8087,314,40720,1591,5,157,1,1414.35,NULL,'2022-12-06 15:34:35','2022-12-06 15:34:35',NULL);
INSERT INTO `balance_libro_details` VALUES (1707,8087,314,40720,1591,5,396,1,1798.00,NULL,'2022-12-06 15:34:35','2022-12-06 15:34:35',NULL),(1708,8087,314,40720,1591,5,277,1,125.28,NULL,'2022-12-06 15:34:35','2022-12-06 15:34:35',NULL),(1709,8087,314,40720,1591,5,276,1,1048.97,NULL,'2022-12-06 15:34:35','2022-12-06 15:34:35',NULL),(1710,8087,314,40720,1591,5,214,1,5079.56,NULL,'2022-12-06 15:34:35','2022-12-06 15:34:35',NULL),(1711,8087,314,40720,1591,5,474,1,207951.21,NULL,'2022-12-06 15:34:35','2022-12-06 15:34:35',NULL),(1712,8087,314,40720,1591,5,359,1,10516.00,NULL,'2022-12-06 15:34:35','2022-12-06 15:34:35',NULL),(1713,8087,314,40720,1591,5,474,2,19982.16,NULL,'2022-12-06 15:34:35','2022-12-06 15:34:35',NULL),(1714,8087,314,40720,1591,5,359,2,207951.21,NULL,'2022-12-06 15:34:35','2022-12-06 15:34:35',NULL),(1715,8087,315,40720,1592,21,62,1,105648.00,NULL,'2022-12-06 15:37:58','2022-12-06 15:37:58',NULL),(1716,8087,315,40720,1592,21,474,2,105648.00,NULL,'2022-12-06 15:37:58','2022-12-06 15:37:58',NULL),(1717,8087,316,40720,1592,19,483,1,30000.00,NULL,'2022-12-06 15:38:45','2022-12-06 15:38:45',NULL),(1718,8087,316,40720,1592,19,474,2,30000.00,NULL,'2022-12-06 15:38:45','2022-12-06 15:38:45',NULL),(1719,8087,317,40720,1592,10,63,1,24430.17,NULL,'2022-12-06 15:41:19','2022-12-06 15:41:19',NULL),(1720,8087,317,40720,1592,10,64,1,2000.00,NULL,'2022-12-06 15:41:19','2022-12-06 15:41:19',NULL),(1721,8087,317,40720,1592,10,474,2,24430.17,NULL,'2022-12-06 15:41:19','2022-12-06 15:41:19',NULL),(1722,8087,317,40720,1592,10,359,2,2000.00,NULL,'2022-12-06 15:41:19','2022-12-06 15:41:19',NULL),(1723,8087,318,40720,1592,15,67,1,57018.76,NULL,'2022-12-06 15:42:58','2022-12-06 15:42:58',NULL),(1724,8087,318,40720,1592,15,499,1,25309.12,NULL,'2022-12-06 15:42:58','2022-12-06 15:42:58',NULL),(1725,8087,318,40720,1592,15,494,2,3015.38,NULL,'2022-12-06 15:42:58','2022-12-06 15:42:58',NULL),(1726,8087,318,40720,1592,15,68,2,79312.50,NULL,'2022-12-06 15:42:58','2022-12-06 15:42:58',NULL),(1727,8087,319,40720,1592,10,156,1,10511.99,NULL,'2022-12-06 15:45:49','2022-12-06 15:45:49',NULL),(1728,8087,319,40720,1592,10,497,1,5216.57,NULL,'2022-12-06 15:45:49','2022-12-06 15:45:49',NULL),(1729,8087,319,40720,1592,10,496,2,3904.94,NULL,'2022-12-06 15:45:49','2022-12-06 15:45:49',NULL),(1730,8087,319,40720,1592,10,495,2,9687.16,NULL,'2022-12-06 15:45:49','2022-12-06 15:45:49',NULL),(1731,8087,319,40720,1592,10,277,2,125.28,NULL,'2022-12-06 15:45:49','2022-12-06 15:45:49',NULL),(1732,8087,319,40720,1592,10,276,2,1048.97,NULL,'2022-12-06 15:45:49','2022-12-06 15:45:49',NULL),(1733,8087,319,40720,1592,10,474,2,962.21,NULL,'2022-12-06 15:45:49','2022-12-06 15:45:49',NULL),(1734,8087,320,40720,1592,3,392,1,782767.34,NULL,'2022-12-06 15:50:29','2022-12-06 15:50:29',NULL),(1735,8087,320,40720,1592,3,68,1,157918.33,NULL,'2022-12-06 15:50:29','2022-12-06 15:50:29',NULL),(1736,8087,320,40720,1592,3,494,1,1720.88,NULL,'2022-12-06 15:50:29','2022-12-06 15:50:29',NULL),(1737,8087,320,40720,1592,3,23,1,104.78,NULL,'2022-12-06 15:50:29','2022-12-06 15:50:29',NULL),(1738,8087,320,40720,1592,3,496,1,7671.76,NULL,'2022-12-06 15:50:29','2022-12-06 15:50:29',NULL),(1739,8087,320,40720,1592,3,495,1,17174.46,NULL,'2022-12-06 15:50:29','2022-12-06 15:50:29',NULL),(1740,8087,320,40720,1592,3,116,1,17490.00,NULL,'2022-12-06 15:50:29','2022-12-06 15:50:29',NULL),(1741,8087,320,40720,1592,3,193,1,6025.06,NULL,'2022-12-06 15:50:29','2022-12-06 15:50:29',NULL),(1742,8087,320,40720,1592,3,484,1,5863.92,NULL,'2022-12-06 15:50:29','2022-12-06 15:50:29',NULL),(1743,8087,320,40720,1592,3,135,1,2934.78,NULL,'2022-12-06 15:50:29','2022-12-06 15:50:29',NULL),(1744,8087,320,40720,1592,3,128,1,4296.73,NULL,'2022-12-06 15:50:29','2022-12-06 15:50:29',NULL),(1745,8087,320,40720,1592,3,485,1,2915.05,NULL,'2022-12-06 15:50:29','2022-12-06 15:50:29',NULL),(1746,8087,320,40720,1592,3,359,2,703883.09,NULL,'2022-12-06 15:50:29','2022-12-06 15:50:29',NULL);
INSERT INTO `balance_libro_details` VALUES (1747,8087,320,40720,1592,3,57,2,303000.00,NULL,'2022-12-06 15:50:29','2022-12-06 15:50:29',NULL),(1748,8087,321,40720,1592,2,359,1,795729.21,NULL,'2022-12-06 15:51:53','2022-12-06 15:51:53',NULL),(1749,8087,321,40720,1592,2,67,2,138101.76,NULL,'2022-12-06 15:51:53','2022-12-06 15:51:53',NULL),(1750,8087,321,40720,1592,2,96,2,657627.45,NULL,'2022-12-06 15:51:53','2022-12-06 15:51:53',NULL),(1751,8087,322,40720,1592,1,110,1,107756.02,NULL,'2022-12-06 15:54:39','2022-12-06 15:54:39',NULL),(1752,8087,322,40720,1592,1,191,1,13283.56,NULL,'2022-12-06 15:54:39','2022-12-06 15:54:39',NULL),(1753,8087,322,40720,1592,1,63,2,22256.58,NULL,'2022-12-06 15:54:39','2022-12-06 15:54:39',NULL),(1754,8087,322,40720,1592,1,62,2,96783.00,NULL,'2022-12-06 15:54:39','2022-12-06 15:54:39',NULL),(1755,8087,322,40720,1592,1,64,2,2000.00,NULL,'2022-12-06 15:54:39','2022-12-06 15:54:39',NULL),(1756,8087,323,40720,1592,5,157,1,3483.69,NULL,'2022-12-06 15:57:00','2022-12-06 15:57:00',NULL),(1757,8087,323,40720,1592,5,396,1,1817.36,NULL,'2022-12-06 15:57:00','2022-12-06 15:57:00',NULL),(1758,8087,323,40720,1592,5,276,1,1941.61,NULL,'2022-12-06 15:57:00','2022-12-06 15:57:00',NULL),(1759,8087,323,40720,1592,5,277,1,178.27,NULL,'2022-12-06 15:57:00','2022-12-06 15:57:00',NULL),(1760,8087,323,40720,1592,5,214,1,10820.14,NULL,'2022-12-06 15:57:00','2022-12-06 15:57:00',NULL),(1761,8087,323,40720,1592,5,474,1,322540.72,NULL,'2022-12-06 15:57:00','2022-12-06 15:57:00',NULL),(1762,8087,323,40720,1592,5,359,1,232151.52,NULL,'2022-12-06 15:57:00','2022-12-06 15:57:00',NULL),(1763,8087,323,40720,1592,5,474,2,250392.59,NULL,'2022-12-06 15:57:00','2022-12-06 15:57:00',NULL),(1764,8087,323,40720,1592,5,359,2,322540.72,NULL,'2022-12-06 15:57:00','2022-12-06 15:57:00',NULL),(1765,8087,324,40720,1593,21,62,1,96783.00,NULL,'2022-12-06 16:03:57','2022-12-06 16:03:57',NULL),(1766,8087,324,40720,1593,21,359,2,96783.00,NULL,'2022-12-06 16:03:57','2022-12-06 16:03:57',NULL),(1767,8087,325,40720,1593,10,63,1,22256.58,NULL,'2022-12-06 16:05:22','2022-12-06 16:05:22',NULL),(1768,8087,325,40720,1593,10,64,1,2000.00,NULL,'2022-12-06 16:05:22','2022-12-06 16:05:22',NULL),(1769,8087,325,40720,1593,10,474,2,22256.58,NULL,'2022-12-06 16:05:22','2022-12-06 16:05:22',NULL),(1770,8087,325,40720,1593,10,359,2,2000.00,NULL,'2022-12-06 16:05:22','2022-12-06 16:05:22',NULL),(1771,8087,326,40720,1593,15,67,1,138101.76,NULL,'2022-12-06 16:07:06','2022-12-06 16:07:06',NULL),(1772,8087,326,40720,1593,15,499,1,21537.45,NULL,'2022-12-06 16:07:06','2022-12-06 16:07:06',NULL),(1773,8087,326,40720,1593,15,68,2,157918.33,NULL,'2022-12-06 16:07:06','2022-12-06 16:07:06',NULL),(1774,8087,326,40720,1593,15,494,2,1720.88,NULL,'2022-12-06 16:07:06','2022-12-06 16:07:06',NULL),(1775,8087,327,40720,1593,10,156,1,25885.85,NULL,'2022-12-06 16:09:41','2022-12-06 16:09:41',NULL),(1776,8087,327,40720,1593,10,497,1,6859.45,NULL,'2022-12-06 16:09:41','2022-12-06 16:09:41',NULL),(1777,8087,327,40720,1593,10,496,2,7671.76,NULL,'2022-12-06 16:09:41','2022-12-06 16:09:41',NULL),(1778,8087,327,40720,1593,10,495,2,17174.46,NULL,'2022-12-06 16:09:41','2022-12-06 16:09:41',NULL),(1779,8087,327,40720,1593,10,277,2,178.27,NULL,'2022-12-06 16:09:41','2022-12-06 16:09:41',NULL),(1780,8087,327,40720,1593,10,276,2,1941.61,NULL,'2022-12-06 16:09:41','2022-12-06 16:09:41',NULL),(1781,8087,327,40720,1593,10,474,2,5779.20,NULL,'2022-12-06 16:09:41','2022-12-06 16:09:41',NULL),(1782,8087,328,40720,1593,3,392,1,655975.38,NULL,'2022-12-06 16:12:47','2022-12-06 16:12:47',NULL),(1783,8087,328,40720,1593,3,68,1,140528.00,NULL,'2022-12-06 16:12:47','2022-12-06 16:12:47',NULL),(1784,8087,328,40720,1593,3,494,1,2602.05,NULL,'2022-12-06 16:12:47','2022-12-06 16:12:47',NULL),(1785,8087,328,40720,1593,3,496,1,8967.62,NULL,'2022-12-06 16:12:47','2022-12-06 16:12:47',NULL),(1786,8087,328,40720,1593,3,495,1,15353.45,NULL,'2022-12-06 16:12:47','2022-12-06 16:12:47',NULL);
INSERT INTO `balance_libro_details` VALUES (1787,8087,328,40720,1593,3,116,1,17490.00,NULL,'2022-12-06 16:12:47','2022-12-06 16:12:47',NULL),(1788,8087,328,40720,1593,3,193,1,5851.52,NULL,'2022-12-06 16:12:48','2022-12-06 16:12:48',NULL),(1789,8087,328,40720,1593,3,484,1,1932.67,NULL,'2022-12-06 16:12:48','2022-12-06 16:12:48',NULL),(1790,8087,328,40720,1593,3,135,1,1894.93,NULL,'2022-12-06 16:12:48','2022-12-06 16:12:48',NULL),(1791,8087,328,40720,1593,3,128,1,6090.71,NULL,'2022-12-06 16:12:48','2022-12-06 16:12:48',NULL),(1792,8087,328,40720,1593,3,359,2,581686.33,NULL,'2022-12-06 16:12:48','2022-12-06 16:12:48',NULL),(1793,8087,328,40720,1593,3,57,2,275000.00,NULL,'2022-12-06 16:12:48','2022-12-06 16:12:48',NULL),(1794,8087,329,40720,1593,2,359,1,649545.50,NULL,'2022-12-06 16:21:07','2022-12-06 16:21:07',NULL),(1795,8087,329,40720,1593,2,67,2,112731.04,NULL,'2022-12-06 16:21:07','2022-12-06 16:21:07',NULL),(1796,8087,329,40720,1593,2,96,2,536814.46,NULL,'2022-12-06 16:21:07','2022-12-06 16:21:07',NULL),(1797,8087,330,40720,1593,1,110,1,116419.43,NULL,'2022-12-06 16:22:48','2022-12-06 16:22:48',NULL),(1798,8087,330,40720,1593,1,191,1,15323.65,NULL,'2022-12-06 16:22:48','2022-12-06 16:22:48',NULL),(1799,8087,330,40720,1593,1,63,2,25943.08,NULL,'2022-12-06 16:22:48','2022-12-06 16:22:48',NULL),(1800,8087,330,40720,1593,1,62,2,103800.00,NULL,'2022-12-06 16:22:48','2022-12-06 16:22:48',NULL),(1801,8087,330,40720,1593,1,64,2,2000.00,NULL,'2022-12-06 16:22:48','2022-12-06 16:22:48',NULL),(1802,8087,331,40720,1593,5,157,1,1810.01,NULL,'2022-12-06 16:26:17','2022-12-06 16:26:17',NULL),(1803,8087,331,40720,1593,5,396,1,1790.13,NULL,'2022-12-06 16:26:17','2022-12-06 16:26:17',NULL),(1804,8087,331,40720,1593,5,25,1,27.23,NULL,'2022-12-06 16:26:17','2022-12-06 16:26:17',NULL),(1805,8087,331,40720,1593,5,277,1,40.18,NULL,'2022-12-06 16:26:17','2022-12-06 16:26:17',NULL),(1806,8087,331,40720,1593,5,276,1,987.96,NULL,'2022-12-06 16:26:17','2022-12-06 16:26:17',NULL),(1807,8087,331,40720,1593,5,214,1,11469.67,NULL,'2022-12-06 16:26:17','2022-12-06 16:26:17',NULL),(1808,8087,331,40720,1593,5,474,1,153596.33,NULL,'2022-12-06 16:26:17','2022-12-06 16:26:17',NULL),(1809,8087,331,40720,1593,5,359,1,184374.20,NULL,'2022-12-06 16:26:17','2022-12-06 16:26:17',NULL),(1810,8087,331,40720,1593,5,474,2,200499.38,NULL,'2022-12-06 16:26:17','2022-12-06 16:26:17',NULL),(1811,8087,331,40720,1593,5,359,2,153596.33,NULL,'2022-12-06 16:26:17','2022-12-06 16:26:17',NULL),(1812,8087,332,40720,1594,21,62,1,103800.00,NULL,'2022-12-06 16:27:44','2022-12-06 16:27:44',NULL),(1813,8087,332,40720,1594,21,474,2,53800.00,NULL,'2022-12-06 16:27:44','2022-12-06 16:27:44',NULL),(1814,8087,332,40720,1594,21,359,2,50000.00,NULL,'2022-12-06 16:27:44','2022-12-06 16:27:44',NULL),(1815,8087,333,40720,1594,10,63,1,25943.08,NULL,'2022-12-06 16:29:12','2022-12-06 16:29:12',NULL),(1816,8087,333,40720,1594,10,64,1,2000.00,NULL,'2022-12-06 16:29:12','2022-12-06 16:29:12',NULL),(1817,8087,333,40720,1594,10,474,2,25943.08,NULL,'2022-12-06 16:29:12','2022-12-06 16:29:12',NULL),(1818,8087,333,40720,1594,10,359,2,2000.00,NULL,'2022-12-06 16:29:12','2022-12-06 16:29:12',NULL),(1819,8087,334,40720,1594,15,67,1,112731.04,NULL,'2022-12-06 16:31:58','2022-12-06 16:31:58',NULL),(1820,8087,334,40720,1594,15,499,1,30426.24,NULL,'2022-12-06 16:31:58','2022-12-06 16:31:58',NULL),(1821,8087,334,40720,1594,15,25,2,27.23,NULL,'2022-12-06 16:31:58','2022-12-06 16:31:58',NULL),(1822,8087,334,40720,1594,15,494,2,2602.05,NULL,'2022-12-06 16:31:58','2022-12-06 16:31:58',NULL),(1823,8087,334,40720,1594,15,68,2,140528.00,NULL,'2022-12-06 16:31:58','2022-12-06 16:31:58',NULL),(1824,8087,335,40720,1594,10,156,1,21615.67,NULL,'2022-12-06 16:34:57','2022-12-06 16:34:57',NULL),(1825,8087,335,40720,1594,10,497,1,7556.06,NULL,'2022-12-06 16:34:57','2022-12-06 16:34:57',NULL),(1826,8087,335,40720,1594,10,496,2,8967.62,NULL,'2022-12-06 16:34:57','2022-12-06 16:34:57',NULL);
INSERT INTO `balance_libro_details` VALUES (1827,8087,335,40720,1594,10,495,2,15353.45,NULL,'2022-12-06 16:34:57','2022-12-06 16:34:57',NULL),(1828,8087,335,40720,1594,10,277,2,40.18,NULL,'2022-12-06 16:34:57','2022-12-06 16:34:57',NULL),(1829,8087,335,40720,1594,10,276,2,987.96,NULL,'2022-12-06 16:34:57','2022-12-06 16:34:57',NULL),(1830,8087,335,40720,1594,10,474,2,3822.52,NULL,'2022-12-06 16:34:57','2022-12-06 16:34:57',NULL),(1831,8087,336,40720,1594,3,392,1,543423.65,NULL,'2022-12-06 16:38:52','2022-12-06 16:38:52',NULL),(1832,8087,336,40720,1594,3,68,1,116888.30,NULL,'2022-12-06 16:38:52','2022-12-06 16:38:52',NULL),(1833,8087,336,40720,1594,3,494,1,2573.27,NULL,'2022-12-06 16:38:52','2022-12-06 16:38:52',NULL),(1834,8087,336,40720,1594,3,23,1,139.20,NULL,'2022-12-06 16:38:52','2022-12-06 16:38:52',NULL),(1835,8087,336,40720,1594,3,496,1,2924.16,NULL,'2022-12-06 16:38:52','2022-12-06 16:38:52',NULL),(1836,8087,336,40720,1594,3,495,1,11726.19,NULL,'2022-12-06 16:38:52','2022-12-06 16:38:52',NULL),(1837,8087,336,40720,1594,3,116,1,17490.00,NULL,'2022-12-06 16:38:52','2022-12-06 16:38:52',NULL),(1838,8087,336,40720,1594,3,193,1,4688.00,NULL,'2022-12-06 16:38:52','2022-12-06 16:38:52',NULL),(1839,8087,336,40720,1594,3,484,1,1314.06,NULL,'2022-12-06 16:38:52','2022-12-06 16:38:52',NULL),(1840,8087,336,40720,1594,3,135,1,3304.09,NULL,'2022-12-06 16:38:52','2022-12-06 16:38:52',NULL),(1841,8087,336,40720,1594,3,128,1,8397.27,NULL,'2022-12-06 16:38:52','2022-12-06 16:38:52',NULL),(1842,8087,336,40720,1594,3,485,1,1320.00,NULL,'2022-12-06 16:38:52','2022-12-06 16:38:52',NULL),(1843,8087,336,40720,1594,3,359,2,432188.19,NULL,'2022-12-06 16:38:52','2022-12-06 16:38:52',NULL),(1844,8087,336,40720,1594,3,57,2,282000.00,NULL,'2022-12-06 16:38:52','2022-12-06 16:38:52',NULL),(1845,8087,337,40720,1594,2,359,1,624948.91,NULL,'2022-12-06 16:40:26','2022-12-06 16:40:26',NULL),(1846,8087,337,40720,1594,2,67,2,108462.21,NULL,'2022-12-06 16:40:26','2022-12-06 16:40:26',NULL),(1847,8087,337,40720,1594,2,96,2,516486.70,NULL,'2022-12-06 16:40:26','2022-12-06 16:40:26',NULL),(1848,8087,338,40720,1594,1,110,1,116419.43,NULL,'2022-12-06 16:41:51','2022-12-06 16:41:51',NULL),(1849,8087,338,40720,1594,1,191,1,15311.65,NULL,'2022-12-06 16:41:51','2022-12-06 16:41:51',NULL),(1850,8087,338,40720,1594,1,63,2,25931.08,NULL,'2022-12-06 16:41:51','2022-12-06 16:41:51',NULL),(1851,8087,338,40720,1594,1,62,2,103800.00,NULL,'2022-12-06 16:41:51','2022-12-06 16:41:51',NULL),(1852,8087,338,40720,1594,1,64,2,2000.00,NULL,'2022-12-06 16:41:51','2022-12-06 16:41:51',NULL),(1853,8087,339,40720,1594,5,157,1,2356.49,NULL,'2022-12-06 16:43:56','2022-12-06 16:43:56',NULL),(1854,8087,339,40720,1594,5,396,1,1817.36,NULL,'2022-12-06 16:43:56','2022-12-06 16:43:56',NULL),(1855,8087,339,40720,1594,5,276,1,1755.03,NULL,'2022-12-06 16:43:56','2022-12-06 16:43:56',NULL),(1856,8087,339,40720,1594,5,214,1,4520.73,NULL,'2022-12-06 16:43:56','2022-12-06 16:43:56',NULL),(1857,8087,339,40720,1594,5,474,1,250716.18,NULL,'2022-12-06 16:43:56','2022-12-06 16:43:56',NULL),(1858,8087,339,40720,1594,5,359,1,109379.76,NULL,'2022-12-06 16:43:56','2022-12-06 16:43:56',NULL),(1859,8087,339,40720,1594,5,474,2,119829.37,NULL,'2022-12-06 16:43:56','2022-12-06 16:43:56',NULL),(1860,8087,339,40720,1594,5,359,2,250716.18,NULL,'2022-12-06 16:43:56','2022-12-06 16:43:56',NULL),(1861,8087,340,40720,1595,21,62,1,103800.00,NULL,'2022-12-06 16:46:34','2022-12-06 16:46:34',NULL),(1862,8087,340,40720,1595,21,474,2,83800.00,NULL,'2022-12-06 16:46:34','2022-12-06 16:46:34',NULL),(1863,8087,340,40720,1595,21,359,2,20000.00,NULL,'2022-12-06 16:46:34','2022-12-06 16:46:34',NULL),(1864,8087,341,40720,1595,10,63,1,25931.08,NULL,'2022-12-06 16:48:04','2022-12-06 16:48:04',NULL),(1865,8087,341,40720,1595,10,64,1,2000.00,NULL,'2022-12-06 16:48:04','2022-12-06 16:48:04',NULL),(1866,8087,341,40720,1595,10,474,2,25931.08,NULL,'2022-12-06 16:48:04','2022-12-06 16:48:04',NULL);
INSERT INTO `balance_libro_details` VALUES (1867,8087,341,40720,1595,10,359,2,2000.00,NULL,'2022-12-06 16:48:04','2022-12-06 16:48:04',NULL),(1868,8087,342,40720,1595,19,483,1,40000.00,NULL,'2022-12-06 16:48:52','2022-12-06 16:48:52',NULL),(1869,8087,342,40720,1595,19,474,2,40000.00,NULL,'2022-12-06 16:48:52','2022-12-06 16:48:52',NULL),(1870,8087,343,40720,1595,15,67,1,108462.21,NULL,'2022-12-06 16:50:53','2022-12-06 16:50:53',NULL),(1871,8087,343,40720,1595,15,499,1,10999.36,NULL,'2022-12-06 16:50:53','2022-12-06 16:50:53',NULL),(1872,8087,343,40720,1595,15,68,2,116888.30,NULL,'2022-12-06 16:50:53','2022-12-06 16:50:53',NULL),(1873,8087,343,40720,1595,15,494,2,2573.27,NULL,'2022-12-06 16:50:53','2022-12-06 16:50:53',NULL),(1874,8087,344,40720,1595,10,156,1,20986.99,NULL,'2022-12-06 16:59:52','2022-12-06 16:59:52',NULL),(1875,8087,344,40720,1595,10,497,1,4470.19,NULL,'2022-12-06 16:59:52','2022-12-06 16:59:52',NULL),(1876,8087,344,40720,1595,10,496,2,2924.16,NULL,'2022-12-06 16:59:52','2022-12-06 16:59:52',NULL),(1877,8087,344,40720,1595,10,495,2,11726.19,NULL,'2022-12-06 16:59:52','2022-12-06 16:59:52',NULL),(1878,8087,344,40720,1595,10,276,2,1755.03,NULL,'2022-12-06 16:59:52','2022-12-06 16:59:52',NULL),(1879,8087,344,40720,1595,10,474,2,9051.80,NULL,'2022-12-06 16:59:52','2022-12-06 16:59:52',NULL),(1880,8087,345,40720,1595,1,110,1,174629.15,NULL,'2022-12-06 17:02:40','2022-12-06 17:02:40',NULL),(1881,8087,345,40720,1595,1,191,1,23432.84,NULL,'2022-12-06 17:02:40','2022-12-06 17:02:40',NULL),(1882,8087,345,40720,1595,1,63,2,40361.99,NULL,'2022-12-06 17:02:40','2022-12-06 17:02:40',NULL),(1883,8087,345,40720,1595,1,62,2,155700.00,NULL,'2022-12-06 17:02:40','2022-12-06 17:02:40',NULL),(1884,8087,345,40720,1595,1,64,2,2000.00,NULL,'2022-12-06 17:02:40','2022-12-06 17:02:40',NULL),(1885,8087,346,40720,1595,3,392,1,820016.35,NULL,'2022-12-06 17:05:38','2022-12-06 17:05:38',NULL),(1886,8087,346,40720,1595,3,68,1,174748.75,NULL,'2022-12-06 17:05:38','2022-12-06 17:05:38',NULL),(1887,8087,346,40720,1595,3,494,1,2367.54,NULL,'2022-12-06 17:05:38','2022-12-06 17:05:38',NULL),(1888,8087,346,40720,1595,3,496,1,7310.33,NULL,'2022-12-06 17:05:38','2022-12-06 17:05:38',NULL),(1889,8087,346,40720,1595,3,495,1,17036.34,NULL,'2022-12-06 17:05:38','2022-12-06 17:05:38',NULL),(1890,8087,346,40720,1595,3,116,1,20113.00,NULL,'2022-12-06 17:05:38','2022-12-06 17:05:38',NULL),(1891,8087,346,40720,1595,3,193,1,4790.07,NULL,'2022-12-06 17:05:38','2022-12-06 17:05:38',NULL),(1892,8087,346,40720,1595,3,484,1,5082.90,NULL,'2022-12-06 17:05:38','2022-12-06 17:05:38',NULL),(1893,8087,346,40720,1595,3,135,1,7918.58,NULL,'2022-12-06 17:05:38','2022-12-06 17:05:38',NULL),(1894,8087,346,40720,1595,3,128,1,9520.79,NULL,'2022-12-06 17:05:38','2022-12-06 17:05:38',NULL),(1895,8087,346,40720,1595,3,485,1,6156.12,NULL,'2022-12-06 17:05:38','2022-12-06 17:05:38',NULL),(1896,8087,346,40720,1595,3,359,2,640060.77,NULL,'2022-12-06 17:05:38','2022-12-06 17:05:38',NULL),(1897,8087,346,40720,1595,3,57,2,435000.00,NULL,'2022-12-06 17:05:38','2022-12-06 17:05:38',NULL),(1898,8087,347,40720,1595,2,359,1,839723.71,NULL,'2022-12-06 17:06:53','2022-12-06 17:06:53',NULL),(1899,8087,347,40720,1595,2,67,2,145737.17,NULL,'2022-12-06 17:06:53','2022-12-06 17:06:53',NULL),(1900,8087,347,40720,1595,2,96,2,693986.54,NULL,'2022-12-06 17:06:53','2022-12-06 17:06:53',NULL),(1901,8087,348,40720,1595,5,157,1,3980.69,NULL,'2022-12-06 17:09:23','2022-12-06 17:09:23',NULL),(1902,8087,348,40720,1595,5,396,1,2299.25,NULL,'2022-12-06 17:09:23','2022-12-06 17:09:23',NULL),(1903,8087,348,40720,1595,5,25,1,76.11,NULL,'2022-12-06 17:09:23','2022-12-06 17:09:23',NULL),(1904,8087,348,40720,1595,5,276,1,3324.74,NULL,'2022-12-06 17:09:23','2022-12-06 17:09:23',NULL),(1905,8087,348,40720,1595,5,214,1,11179.92,NULL,'2022-12-06 17:09:23','2022-12-06 17:09:23',NULL),(1906,8087,348,40720,1595,5,474,1,478423.76,NULL,'2022-12-06 17:09:23','2022-12-06 17:09:23',NULL);
INSERT INTO `balance_libro_details` VALUES (1907,8087,348,40720,1595,5,359,1,301135.50,NULL,'2022-12-06 17:09:23','2022-12-06 17:09:23',NULL),(1908,8087,348,40720,1595,5,474,2,321996.21,NULL,'2022-12-06 17:09:23','2022-12-06 17:09:23',NULL),(1909,8087,348,40720,1595,5,359,2,478423.76,NULL,'2022-12-06 17:09:23','2022-12-06 17:09:23',NULL),(1910,8087,349,40720,1596,21,62,1,155700.00,NULL,'2022-12-07 08:20:11','2022-12-07 08:20:11',NULL),(1911,8087,349,40720,1596,21,474,2,53800.00,NULL,'2022-12-07 08:20:11','2022-12-07 08:20:11',NULL),(1912,8087,349,40720,1596,21,359,2,101900.00,NULL,'2022-12-07 08:20:11','2022-12-07 08:20:11',NULL),(1913,8087,350,40720,1596,15,67,1,145737.17,NULL,'2022-12-07 08:23:00','2022-12-07 08:23:00',NULL),(1914,8087,350,40720,1596,15,499,1,31455.23,NULL,'2022-12-07 08:23:00','2022-12-07 08:23:00',NULL),(1915,8087,350,40720,1596,15,68,2,174748.75,NULL,'2022-12-07 08:23:00','2022-12-07 08:23:00',NULL),(1916,8087,350,40720,1596,15,25,2,76.11,NULL,'2022-12-07 08:23:00','2022-12-07 08:23:00',NULL),(1917,8087,350,40720,1596,15,494,2,2367.54,NULL,'2022-12-07 08:23:00','2022-12-07 08:23:00',NULL),(1918,8087,351,40720,1596,10,63,1,40361.99,NULL,'2022-12-07 08:24:26','2022-12-07 08:24:26',NULL),(1919,8087,351,40720,1596,10,64,1,2000.00,NULL,'2022-12-07 08:24:26','2022-12-07 08:24:26',NULL),(1920,8087,351,40720,1596,10,474,2,40361.99,NULL,'2022-12-07 08:24:26','2022-12-07 08:24:26',NULL),(1921,8087,351,40720,1596,10,359,2,2000.00,NULL,'2022-12-07 08:24:26','2022-12-07 08:24:26',NULL),(1922,8087,352,40720,1596,10,156,1,28084.72,NULL,'2022-12-07 08:26:52','2022-12-07 08:26:52',NULL),(1923,8087,352,40720,1596,10,497,1,7114.43,NULL,'2022-12-07 08:26:52','2022-12-07 08:26:52',NULL),(1924,8087,352,40720,1596,10,496,2,7310.33,NULL,'2022-12-07 08:26:52','2022-12-07 08:26:52',NULL),(1925,8087,352,40720,1596,10,495,2,17036.34,NULL,'2022-12-07 08:26:52','2022-12-07 08:26:52',NULL),(1926,8087,352,40720,1596,10,276,2,3324.74,NULL,'2022-12-07 08:26:52','2022-12-07 08:26:52',NULL),(1927,8087,352,40720,1596,10,474,2,7527.74,NULL,'2022-12-07 08:26:52','2022-12-07 08:26:52',NULL),(1928,8087,353,40720,1596,19,483,1,20000.00,NULL,'2022-12-07 08:32:26','2022-12-07 08:32:26',NULL),(1929,8087,353,40720,1596,19,474,2,20000.00,NULL,'2022-12-07 08:32:26','2022-12-07 08:32:26',NULL),(1930,8087,354,40720,1596,5,157,1,4250.03,NULL,'2022-12-07 08:53:22','2022-12-07 08:53:22',NULL),(1931,8087,354,40720,1596,5,396,1,2355.53,NULL,'2022-12-07 08:53:22','2022-12-07 08:53:22',NULL),(1932,8087,354,40720,1596,5,25,1,58.55,NULL,'2022-12-07 08:53:22','2022-12-07 08:53:22',NULL),(1933,8087,354,40720,1596,5,276,1,3913.89,NULL,'2022-12-07 08:53:22','2022-12-07 08:53:22',NULL),(1934,8087,354,40720,1596,5,214,1,10159.21,NULL,'2022-12-07 08:53:22','2022-12-07 08:53:22',NULL),(1935,8087,354,40720,1596,5,474,1,492131.70,NULL,'2022-12-07 08:53:22','2022-12-07 08:53:22',NULL),(1936,8087,354,40720,1596,5,359,1,250748.86,NULL,'2022-12-07 08:53:22','2022-12-07 08:53:22',NULL),(1937,8087,354,40720,1596,5,474,2,271486.07,NULL,'2022-12-07 08:53:22','2022-12-07 08:53:22',NULL),(1938,8087,354,40720,1596,5,359,2,492131.70,NULL,'2022-12-07 08:53:22','2022-12-07 08:53:22',NULL),(1939,8087,355,40720,1596,1,110,1,117058.08,NULL,'2022-12-07 08:58:31','2022-12-07 08:58:31',NULL),(1940,8087,355,40720,1596,1,191,1,15461.77,NULL,'2022-12-07 08:58:31','2022-12-07 08:58:31',NULL),(1941,8087,355,40720,1596,1,63,2,26201.85,NULL,'2022-12-07 08:58:31','2022-12-07 08:58:31',NULL),(1942,8087,355,40720,1596,1,62,2,104318.00,NULL,'2022-12-07 08:58:31','2022-12-07 08:58:31',NULL),(1943,8087,355,40720,1596,1,64,2,2000.00,NULL,'2022-12-07 08:58:31','2022-12-07 08:58:31',NULL),(1944,8087,356,40720,1596,3,392,1,637281.22,NULL,'2022-12-07 09:04:35','2022-12-07 09:04:35',NULL),(1945,8087,356,40720,1596,3,68,1,137694.47,NULL,'2022-12-07 09:04:35','2022-12-07 09:04:35',NULL),(1946,8087,356,40720,1596,3,494,1,1891.31,NULL,'2022-12-07 09:04:35','2022-12-07 09:04:35',NULL);
INSERT INTO `balance_libro_details` VALUES (1947,8087,356,40720,1596,3,496,1,5436.71,NULL,'2022-12-07 09:04:35','2022-12-07 09:04:35',NULL),(1948,8087,356,40720,1596,3,495,1,14213.67,NULL,'2022-12-07 09:04:35','2022-12-07 09:04:35',NULL),(1949,8087,356,40720,1596,3,116,1,24137.00,NULL,'2022-12-07 09:04:35','2022-12-07 09:04:35',NULL),(1950,8087,356,40720,1596,3,193,1,5187.57,NULL,'2022-12-07 09:04:35','2022-12-07 09:04:35',NULL),(1951,8087,356,40720,1596,3,484,1,7886.63,NULL,'2022-12-07 09:04:35','2022-12-07 09:04:35',NULL),(1952,8087,356,40720,1596,3,135,1,1967.36,NULL,'2022-12-07 09:04:35','2022-12-07 09:04:35',NULL),(1953,8087,356,40720,1596,3,128,1,9649.59,NULL,'2022-12-07 09:04:35','2022-12-07 09:04:35',NULL),(1954,8087,356,40720,1596,3,359,2,528345.53,NULL,'2022-12-07 09:04:35','2022-12-07 09:04:35',NULL),(1955,8087,356,40720,1596,3,57,2,317000.00,NULL,'2022-12-07 09:04:35','2022-12-07 09:04:35',NULL),(1956,8087,357,40720,1596,2,359,1,874138.04,NULL,'2022-12-07 09:07:00','2022-12-07 09:07:00',NULL),(1957,8087,357,40720,1596,2,67,2,151709.91,NULL,'2022-12-07 09:07:00','2022-12-07 09:07:00',NULL),(1958,8087,357,40720,1596,2,96,2,722428.13,NULL,'2022-12-07 09:07:00','2022-12-07 09:07:00',NULL),(1959,8087,358,40720,1597,21,63,1,26201.85,NULL,'2022-12-07 09:08:46','2022-12-07 09:10:09','2022-12-07 09:10:09'),(1960,8087,358,40720,1597,21,64,1,2000.00,NULL,'2022-12-07 09:08:46','2022-12-07 09:10:09','2022-12-07 09:10:09'),(1961,8087,358,40720,1597,21,474,2,26201.85,NULL,'2022-12-07 09:08:46','2022-12-07 09:10:09','2022-12-07 09:10:09'),(1962,8087,358,40720,1597,21,359,2,2000.00,NULL,'2022-12-07 09:08:46','2022-12-07 09:10:09','2022-12-07 09:10:09'),(1963,8087,359,40720,1597,21,62,1,104318.00,NULL,'2022-12-07 09:10:09','2022-12-07 09:10:09',NULL),(1964,8087,359,40720,1597,21,474,2,84318.00,NULL,'2022-12-07 09:10:09','2022-12-07 09:10:09',NULL),(1965,8087,359,40720,1597,21,359,2,20000.00,NULL,'2022-12-07 09:10:09','2022-12-07 09:10:09',NULL),(1966,8087,360,40720,1597,10,63,1,26201.85,NULL,'2022-12-07 09:12:07','2022-12-07 09:12:07',NULL),(1967,8087,360,40720,1597,10,64,1,2000.00,NULL,'2022-12-07 09:12:07','2022-12-07 09:12:07',NULL),(1968,8087,360,40720,1597,10,474,2,26201.85,NULL,'2022-12-07 09:12:07','2022-12-07 09:12:07',NULL),(1969,8087,360,40720,1597,10,359,2,2000.00,NULL,'2022-12-07 09:12:07','2022-12-07 09:12:07',NULL),(1970,8087,361,40720,1597,19,483,1,20000.00,NULL,'2022-12-07 09:13:14','2022-12-07 09:13:14',NULL),(1971,8087,361,40720,1597,19,474,2,20000.00,NULL,'2022-12-07 09:13:14','2022-12-07 09:13:14',NULL),(1972,8087,362,40720,1597,15,67,1,151709.91,NULL,'2022-12-07 09:16:15','2022-12-07 09:16:15',NULL),(1973,8087,362,40720,1597,15,499,2,12065.58,NULL,'2022-12-07 09:16:15','2022-12-07 09:16:15',NULL),(1974,8087,362,40720,1597,15,25,2,58.55,NULL,'2022-12-07 09:16:15','2022-12-07 09:16:15',NULL),(1975,8087,362,40720,1597,15,494,2,1891.31,NULL,'2022-12-07 09:16:15','2022-12-07 09:16:15',NULL),(1976,8087,362,40720,1597,15,68,2,137694.47,NULL,'2022-12-07 09:16:15','2022-12-07 09:16:15',NULL),(1977,8087,363,40720,1597,10,156,1,28889.70,NULL,'2022-12-07 09:19:38','2022-12-07 09:19:38',NULL),(1978,8087,363,40720,1597,10,497,1,3366.12,NULL,'2022-12-07 09:19:38','2022-12-07 09:19:38',NULL),(1979,8087,363,40720,1597,10,496,2,5436.71,NULL,'2022-12-07 09:19:38','2022-12-07 09:19:38',NULL),(1980,8087,363,40720,1597,10,495,2,14213.67,NULL,'2022-12-07 09:19:38','2022-12-07 09:19:38',NULL),(1981,8087,363,40720,1597,10,276,2,3913.89,NULL,'2022-12-07 09:19:38','2022-12-07 09:19:38',NULL),(1982,8087,363,40720,1597,10,474,2,8691.55,NULL,'2022-12-07 09:19:38','2022-12-07 09:19:38',NULL),(1983,8087,364,40720,1597,1,110,1,127116.79,NULL,'2022-12-07 09:24:45','2022-12-07 09:24:45',NULL),(1984,8087,364,40720,1597,1,191,1,17814.98,NULL,'2022-12-07 09:24:45','2022-12-07 09:24:45',NULL),(1985,8087,364,40720,1597,1,63,2,30466.77,NULL,'2022-12-07 09:24:45','2022-12-07 09:24:45',NULL),(1986,8087,364,40720,1597,1,62,2,112465.00,NULL,'2022-12-07 09:24:45','2022-12-07 09:24:45',NULL);
INSERT INTO `balance_libro_details` VALUES (1987,8087,364,40720,1597,1,64,2,2000.00,NULL,'2022-12-07 09:24:45','2022-12-07 09:24:45',NULL),(1988,8087,365,40720,1597,3,392,1,612643.28,NULL,'2022-12-07 09:28:33','2022-12-07 09:28:33',NULL),(1989,8087,365,40720,1597,3,68,1,127477.33,NULL,'2022-12-07 09:28:33','2022-12-07 09:28:33',NULL),(1990,8087,365,40720,1597,3,494,1,2702.10,NULL,'2022-12-07 09:28:33','2022-12-07 09:28:33',NULL),(1991,8087,365,40720,1597,3,496,1,4571.54,NULL,'2022-12-07 09:28:33','2022-12-07 09:28:33',NULL),(1992,8087,365,40720,1597,3,495,1,12917.07,NULL,'2022-12-07 09:28:33','2022-12-07 09:28:33',NULL),(1993,8087,365,40720,1597,3,116,1,24137.00,NULL,'2022-12-07 09:28:33','2022-12-07 09:28:33',NULL),(1994,8087,365,40720,1597,3,193,1,4325.23,NULL,'2022-12-07 09:28:33','2022-12-07 09:28:33',NULL),(1995,8087,365,40720,1597,3,484,1,2402.92,NULL,'2022-12-07 09:28:33','2022-12-07 09:28:33',NULL),(1996,8087,365,40720,1597,3,135,1,8332.48,NULL,'2022-12-07 09:28:33','2022-12-07 09:28:33',NULL),(1997,8087,365,40720,1597,3,128,1,6203.25,NULL,'2022-12-07 09:28:33','2022-12-07 09:28:33',NULL),(1998,8087,365,40720,1597,3,359,2,304792.10,NULL,'2022-12-07 09:28:33','2022-12-07 09:28:33',NULL),(1999,8087,365,40720,1597,3,57,2,500920.10,NULL,'2022-12-07 09:28:33','2022-12-07 09:28:33',NULL),(2000,8087,366,40720,1597,2,359,1,1044375.41,NULL,'2022-12-07 09:29:51','2022-12-07 09:29:51',NULL),(2001,8087,366,40720,1597,2,67,2,181255.24,NULL,'2022-12-07 09:29:51','2022-12-07 09:29:51',NULL),(2002,8087,366,40720,1597,2,96,2,863120.17,NULL,'2022-12-07 09:29:51','2022-12-07 09:29:51',NULL),(2003,8087,367,40720,1597,5,157,1,3151.20,NULL,'2022-12-07 09:32:03','2022-12-07 09:32:03',NULL),(2004,8087,367,40720,1597,5,396,1,2394.72,NULL,'2022-12-07 09:32:03','2022-12-07 09:32:03',NULL),(2005,8087,367,40720,1597,5,214,1,9787.90,NULL,'2022-12-07 09:32:03','2022-12-07 09:32:03',NULL),(2006,8087,367,40720,1597,5,474,1,317410.37,NULL,'2022-12-07 09:32:03','2022-12-07 09:32:03',NULL),(2007,8087,367,40720,1597,5,359,1,171150.07,NULL,'2022-12-07 09:32:03','2022-12-07 09:32:03',NULL),(2008,8087,367,40720,1597,5,474,2,186483.89,NULL,'2022-12-07 09:32:03','2022-12-07 09:32:03',NULL),(2009,8087,367,40720,1597,5,359,2,317410.37,NULL,'2022-12-07 09:32:03','2022-12-07 09:32:03',NULL),(2010,8087,368,40720,1597,21,57,1,250000.00,NULL,'2022-12-07 09:34:11','2022-12-07 09:34:11',NULL),(2011,8087,368,40720,1597,21,359,2,250000.00,NULL,'2022-12-07 09:34:11','2022-12-07 09:34:11',NULL),(2012,8087,369,40720,1597,21,57,1,250000.00,NULL,'2022-12-07 09:34:49','2022-12-07 09:34:49',NULL),(2013,8087,369,40720,1597,21,359,2,250000.00,NULL,'2022-12-07 09:34:49','2022-12-07 09:34:49',NULL),(2014,8087,370,40720,1598,21,62,1,112465.00,NULL,'2022-12-07 09:43:42','2022-12-07 09:43:42',NULL),(2015,8087,370,40720,1598,21,474,2,62465.00,NULL,'2022-12-07 09:43:42','2022-12-07 09:43:42',NULL),(2016,8087,370,40720,1598,21,359,2,50000.00,NULL,'2022-12-07 09:43:42','2022-12-07 09:43:42',NULL),(2017,8087,371,40720,1598,10,63,1,30466.77,NULL,'2022-12-07 09:45:35','2022-12-07 09:45:35',NULL),(2018,8087,371,40720,1598,10,64,1,2000.00,NULL,'2022-12-07 09:45:35','2022-12-07 09:45:35',NULL),(2019,8087,371,40720,1598,10,474,2,30466.77,NULL,'2022-12-07 09:45:35','2022-12-07 09:45:35',NULL),(2020,8087,371,40720,1598,10,359,2,2000.00,NULL,'2022-12-07 09:45:35','2022-12-07 09:45:35',NULL),(2021,8087,372,40720,1598,15,67,1,181255.24,NULL,'2022-12-07 09:47:29','2022-12-07 09:47:29',NULL),(2022,8087,372,40720,1598,15,68,2,127477.33,NULL,'2022-12-07 09:47:29','2022-12-07 09:47:29',NULL),(2023,8087,372,40720,1598,15,25,2,540.62,NULL,'2022-12-07 09:47:29','2022-12-07 09:47:29',NULL),(2024,8087,372,40720,1598,15,494,2,2702.10,NULL,'2022-12-07 09:47:29','2022-12-07 09:47:29',NULL),(2025,8087,372,40720,1598,15,499,2,50535.19,NULL,'2022-12-07 09:47:29','2022-12-07 09:47:29',NULL),(2026,8087,373,40720,1598,10,156,1,35445.42,NULL,'2022-12-07 09:49:34','2022-12-07 09:49:34',NULL);
INSERT INTO `balance_libro_details` VALUES (2027,8087,373,40720,1598,10,497,1,1351.20,NULL,'2022-12-07 09:49:34','2022-12-07 09:49:34',NULL),(2028,8087,373,40720,1598,10,496,2,4571.54,NULL,'2022-12-07 09:49:34','2022-12-07 09:49:34',NULL),(2029,8087,373,40720,1598,10,495,2,12917.07,NULL,'2022-12-07 09:49:34','2022-12-07 09:49:34',NULL),(2030,8087,373,40720,1598,10,474,2,19308.01,NULL,'2022-12-07 09:49:34','2022-12-07 09:49:34',NULL),(2031,8087,374,40720,1598,21,57,1,250000.00,NULL,'2022-12-07 09:51:42','2022-12-07 09:51:42',NULL),(2032,8087,374,40720,1598,21,359,2,250000.00,NULL,'2022-12-07 09:51:42','2022-12-07 09:51:42',NULL),(2033,8087,375,40720,1598,21,57,1,250000.00,NULL,'2022-12-07 09:52:28','2022-12-07 09:52:28',NULL),(2034,8087,375,40720,1598,21,359,2,250000.00,NULL,'2022-12-07 09:52:28','2022-12-07 09:52:28',NULL),(2035,8087,376,40720,1598,1,110,1,127116.79,NULL,'2022-12-07 09:54:11','2022-12-07 09:54:11',NULL),(2036,8087,376,40720,1598,1,191,1,17823.92,NULL,'2022-12-07 09:54:11','2022-12-07 09:54:11',NULL),(2037,8087,376,40720,1598,1,63,2,30475.71,NULL,'2022-12-07 09:54:11','2022-12-07 09:54:11',NULL),(2038,8087,376,40720,1598,1,62,2,112465.00,NULL,'2022-12-07 09:54:11','2022-12-07 09:54:11',NULL),(2039,8087,376,40720,1598,1,64,2,2000.00,NULL,'2022-12-07 09:54:11','2022-12-07 09:54:11',NULL),(2040,8087,377,40720,1598,3,392,1,750086.89,NULL,'2022-12-07 09:57:43','2022-12-07 09:57:43',NULL),(2041,8087,377,40720,1598,3,68,1,154727.96,NULL,'2022-12-07 09:57:43','2022-12-07 09:57:43',NULL),(2042,8087,377,40720,1598,3,494,1,1735.82,NULL,'2022-12-07 09:57:43','2022-12-07 09:57:43',NULL),(2043,8087,377,40720,1598,3,496,1,3085.01,NULL,'2022-12-07 09:57:43','2022-12-07 09:57:43',NULL),(2044,8087,377,40720,1598,3,495,1,15135.45,NULL,'2022-12-07 09:57:43','2022-12-07 09:57:43',NULL),(2045,8087,377,40720,1598,3,116,1,24137.00,NULL,'2022-12-07 09:57:43','2022-12-07 09:57:43',NULL),(2046,8087,377,40720,1598,3,193,1,4677.11,NULL,'2022-12-07 09:57:43','2022-12-07 09:57:43',NULL),(2047,8087,377,40720,1598,3,484,1,6607.95,NULL,'2022-12-07 09:57:43','2022-12-07 09:57:43',NULL),(2048,8087,377,40720,1598,3,135,1,2339.63,NULL,'2022-12-07 09:57:43','2022-12-07 09:57:43',NULL),(2049,8087,377,40720,1598,3,128,1,9011.65,NULL,'2022-12-07 09:57:43','2022-12-07 09:57:43',NULL),(2050,8087,377,40720,1598,3,485,1,1320.00,NULL,'2022-12-07 09:57:43','2022-12-07 09:57:43',NULL),(2051,8087,377,40720,1598,3,359,2,247863.84,NULL,'2022-12-07 09:57:43','2022-12-07 09:57:43',NULL),(2052,8087,377,40720,1598,3,57,2,725000.63,NULL,'2022-12-07 09:57:43','2022-12-07 09:57:43',NULL),(2053,8087,378,40720,1598,2,359,1,695322.20,NULL,'2022-12-07 09:59:08','2022-12-07 09:59:08',NULL),(2054,8087,378,40720,1598,2,67,2,120675.75,NULL,'2022-12-07 09:59:08','2022-12-07 09:59:08',NULL),(2055,8087,378,40720,1598,2,96,2,574646.45,NULL,'2022-12-07 09:59:08','2022-12-07 09:59:08',NULL),(2056,8087,379,40720,1598,5,157,1,2435.22,NULL,'2022-12-07 10:01:33','2022-12-07 10:01:33',NULL),(2057,8087,379,40720,1598,5,396,1,1989.00,NULL,'2022-12-07 10:01:33','2022-12-07 10:01:33',NULL),(2058,8087,379,40720,1598,5,25,1,405.72,NULL,'2022-12-07 10:01:33','2022-12-07 10:01:33',NULL),(2059,8087,379,40720,1598,5,214,1,6308.63,NULL,'2022-12-07 10:01:33','2022-12-07 10:01:33',NULL),(2060,8087,379,40720,1598,5,474,1,143823.59,NULL,'2022-12-07 10:01:33','2022-12-07 10:01:33',NULL),(2061,8087,379,40720,1598,5,359,1,200304.98,NULL,'2022-12-07 10:01:33','2022-12-07 10:01:33',NULL),(2062,8087,379,40720,1598,5,474,2,211443.55,NULL,'2022-12-07 10:01:33','2022-12-07 10:01:33',NULL),(2063,8087,379,40720,1598,5,359,2,143823.59,NULL,'2022-12-07 10:01:33','2022-12-07 10:01:33',NULL),(2064,8087,380,40720,1599,21,62,1,112465.00,NULL,'2022-12-07 10:08:05','2022-12-07 10:08:05',NULL),(2065,8087,380,40720,1599,21,474,2,82465.00,NULL,'2022-12-07 10:08:05','2022-12-07 10:08:05',NULL),(2066,8087,380,40720,1599,21,359,2,30000.00,NULL,'2022-12-07 10:08:05','2022-12-07 10:08:05',NULL);
INSERT INTO `balance_libro_details` VALUES (2067,8087,381,40720,1599,10,63,1,30475.71,NULL,'2022-12-07 10:19:10','2022-12-07 10:19:10',NULL),(2068,8087,381,40720,1599,10,64,1,2000.00,NULL,'2022-12-07 10:19:10','2022-12-07 10:19:10',NULL),(2069,8087,381,40720,1599,10,474,2,30475.71,NULL,'2022-12-07 10:19:10','2022-12-07 10:19:10',NULL),(2070,8087,381,40720,1599,10,359,2,2000.00,NULL,'2022-12-07 10:19:10','2022-12-07 10:19:10',NULL),(2071,8087,382,40720,1599,19,483,1,20000.00,NULL,'2022-12-07 10:20:55','2022-12-07 10:20:55',NULL),(2072,8087,382,40720,1599,19,474,2,20000.00,NULL,'2022-12-07 10:20:55','2022-12-07 10:20:55',NULL),(2073,8087,383,40720,1599,15,67,1,120675.75,NULL,'2022-12-08 08:05:34','2022-12-08 08:05:34',NULL),(2074,8087,383,40720,1599,15,499,1,35932.94,NULL,'2022-12-08 08:05:34','2022-12-08 08:05:34',NULL),(2075,8087,383,40720,1599,15,68,2,154727.96,NULL,'2022-12-08 08:05:34','2022-12-08 08:05:34',NULL),(2076,8087,383,40720,1599,15,25,2,144.91,NULL,'2022-12-08 08:05:34','2022-12-08 08:05:34',NULL),(2077,8087,383,40720,1599,15,494,2,1735.82,NULL,'2022-12-08 08:05:34','2022-12-08 08:05:34',NULL),(2078,8087,384,40720,1599,10,156,1,22677.08,NULL,'2022-12-08 08:09:58','2022-12-08 08:09:58',NULL),(2079,8087,384,40720,1599,10,497,1,6052.59,NULL,'2022-12-08 08:09:58','2022-12-08 08:09:58',NULL),(2080,8087,384,40720,1599,10,496,2,3085.01,NULL,'2022-12-08 08:09:58','2022-12-08 08:09:58',NULL),(2081,8087,384,40720,1599,10,495,2,15135.45,NULL,'2022-12-08 08:09:58','2022-12-08 08:09:58',NULL),(2082,8087,384,40720,1599,10,474,2,10509.21,NULL,'2022-12-08 08:09:58','2022-12-08 08:09:58',NULL),(2083,8087,385,40720,1599,21,57,1,250000.00,NULL,'2022-12-08 08:11:57','2022-12-08 08:11:57',NULL),(2084,8087,385,40720,1599,21,359,2,250000.00,NULL,'2022-12-08 08:11:57','2022-12-08 08:11:57',NULL),(2085,8087,386,40720,1599,1,110,1,127116.79,NULL,'2022-12-08 08:14:09','2022-12-08 08:14:09',NULL),(2086,8087,386,40720,1599,1,191,1,17823.92,NULL,'2022-12-08 08:14:09','2022-12-08 08:14:09',NULL),(2087,8087,386,40720,1599,1,63,2,30475.71,NULL,'2022-12-08 08:14:09','2022-12-08 08:14:09',NULL),(2088,8087,386,40720,1599,1,62,2,112465.00,NULL,'2022-12-08 08:14:09','2022-12-08 08:14:09',NULL),(2089,8087,386,40720,1599,1,64,2,2000.00,NULL,'2022-12-08 08:14:09','2022-12-08 08:14:09',NULL),(2090,8087,387,40720,1599,21,57,1,250000.00,NULL,'2022-12-08 08:15:06','2022-12-08 08:15:06',NULL),(2091,8087,387,40720,1599,21,359,2,250000.00,NULL,'2022-12-08 08:15:06','2022-12-08 08:15:06',NULL),(2092,8087,388,40720,1599,3,392,1,814039.81,NULL,'2022-12-08 08:18:26','2022-12-08 08:18:26',NULL),(2093,8087,388,40720,1599,3,68,1,174696.24,NULL,'2022-12-08 08:18:26','2022-12-08 08:18:26',NULL),(2094,8087,388,40720,1599,3,494,1,2901.21,NULL,'2022-12-08 08:18:26','2022-12-08 08:18:26',NULL),(2095,8087,388,40720,1599,3,496,1,3763.27,NULL,'2022-12-08 08:18:26','2022-12-08 08:18:26',NULL),(2096,8087,388,40720,1599,3,495,1,18319.83,NULL,'2022-12-08 08:18:26','2022-12-08 08:18:26',NULL),(2097,8087,388,40720,1599,3,116,1,24137.00,NULL,'2022-12-08 08:18:26','2022-12-08 08:18:26',NULL),(2098,8087,388,40720,1599,3,193,1,3248.48,NULL,'2022-12-08 08:18:26','2022-12-08 08:18:26',NULL),(2099,8087,388,40720,1599,3,484,1,6670.43,NULL,'2022-12-08 08:18:26','2022-12-08 08:18:26',NULL),(2100,8087,388,40720,1599,3,135,1,3254.81,NULL,'2022-12-08 08:18:26','2022-12-08 08:18:26',NULL),(2101,8087,388,40720,1599,3,128,1,10721.66,NULL,'2022-12-08 08:18:26','2022-12-08 08:18:26',NULL),(2102,8087,388,40720,1599,3,485,1,1580.00,NULL,'2022-12-08 08:18:26','2022-12-08 08:18:26',NULL),(2103,8087,388,40720,1599,3,359,2,134485.09,NULL,'2022-12-08 08:18:26','2022-12-08 08:18:26',NULL),(2104,8087,388,40720,1599,3,57,2,928847.65,NULL,'2022-12-08 08:18:26','2022-12-08 08:18:26',NULL),(2105,8087,389,40720,1599,2,359,1,959263.09,NULL,'2022-12-08 08:19:58','2022-12-08 08:19:58',NULL),(2106,8087,389,40720,1599,2,67,2,166483.68,NULL,'2022-12-08 08:19:58','2022-12-08 08:19:58',NULL);
INSERT INTO `balance_libro_details` VALUES (2107,8087,389,40720,1599,2,96,2,792779.41,NULL,'2022-12-08 08:19:58','2022-12-08 08:19:58',NULL),(2108,8087,390,40720,1599,5,157,1,2769.59,NULL,'2022-12-08 08:30:00','2022-12-08 08:30:00',NULL),(2109,8087,390,40720,1599,5,396,1,2076.19,NULL,'2022-12-08 08:30:00','2022-12-08 08:30:00',NULL),(2110,8087,390,40720,1599,5,25,1,279.81,NULL,'2022-12-08 08:30:00','2022-12-08 08:30:00',NULL),(2111,8087,390,40720,1599,5,214,1,6612.72,NULL,'2022-12-08 08:30:00','2022-12-08 08:30:00',NULL),(2112,8087,390,40720,1599,5,474,1,287112.19,NULL,'2022-12-08 08:30:00','2022-12-08 08:30:00',NULL),(2113,8087,390,40720,1599,5,359,1,57833.10,NULL,'2022-12-08 08:30:00','2022-12-08 08:30:00',NULL),(2114,8087,390,40720,1599,5,474,2,69571.41,NULL,'2022-12-08 08:30:00','2022-12-08 08:30:00',NULL),(2115,8087,390,40720,1599,5,359,2,287112.19,NULL,'2022-12-08 08:30:00','2022-12-08 08:30:00',NULL),(2116,8087,391,40720,1600,10,63,1,30475.71,NULL,'2022-12-08 08:36:34','2022-12-08 08:36:34',NULL),(2117,8087,391,40720,1600,10,64,1,2000.00,NULL,'2022-12-08 08:36:34','2022-12-08 08:36:34',NULL),(2118,8087,391,40720,1600,10,474,2,30475.71,NULL,'2022-12-08 08:36:34','2022-12-08 08:36:34',NULL),(2119,8087,391,40720,1600,10,359,2,2000.00,NULL,'2022-12-08 08:36:34','2022-12-08 08:36:34',NULL),(2120,8087,392,40720,1600,21,62,1,112465.00,NULL,'2022-12-08 08:47:41','2022-12-08 08:47:41',NULL),(2121,8087,392,40720,1600,21,474,2,80000.00,NULL,'2022-12-08 08:47:41','2022-12-08 08:47:41',NULL),(2122,8087,392,40720,1600,21,359,2,32465.00,NULL,'2022-12-08 08:47:41','2022-12-08 08:47:41',NULL),(2123,8087,393,40720,1600,19,483,1,30000.00,NULL,'2022-12-08 08:49:08','2022-12-08 08:49:08',NULL),(2124,8087,393,40720,1600,19,474,2,30000.00,NULL,'2022-12-08 08:49:08','2022-12-08 08:49:08',NULL),(2125,8087,394,40720,1600,21,57,1,180000.00,NULL,'2022-12-08 08:51:53','2022-12-08 08:51:53',NULL),(2126,8087,394,40720,1600,21,359,2,180000.00,NULL,'2022-12-08 08:51:53','2022-12-08 08:51:53',NULL),(2127,8087,395,40720,1600,15,67,1,166483.68,NULL,'2022-12-08 09:01:10','2022-12-08 09:01:10',NULL),(2128,8087,395,40720,1600,15,499,1,11113.77,NULL,'2022-12-08 09:01:10','2022-12-08 09:01:10',NULL),(2129,8087,395,40720,1600,15,68,2,174696.24,NULL,'2022-12-08 09:01:10','2022-12-08 09:01:10',NULL),(2130,8087,395,40720,1600,15,494,2,2901.21,NULL,'2022-12-08 09:01:10','2022-12-08 09:01:10',NULL),(2131,8087,396,40720,1600,10,156,1,32682.47,NULL,'2022-12-08 09:09:49','2022-12-08 09:09:49',NULL),(2132,8087,396,40720,1600,10,497,1,7885.09,NULL,'2022-12-08 09:09:49','2022-12-08 09:09:49',NULL),(2133,8087,396,40720,1600,10,496,2,3763.27,NULL,'2022-12-08 09:09:49','2022-12-08 09:09:49',NULL),(2134,8087,396,40720,1600,10,495,2,18319.83,NULL,'2022-12-08 09:09:49','2022-12-08 09:09:49',NULL),(2135,8087,396,40720,1600,10,474,2,18484.46,NULL,'2022-12-08 09:09:49','2022-12-08 09:09:49',NULL),(2136,8087,397,40720,1600,1,110,1,137116.79,NULL,'2022-12-08 09:15:24','2022-12-08 09:15:24',NULL),(2137,8087,397,40720,1600,1,191,1,17963.92,NULL,'2022-12-08 09:15:24','2022-12-08 09:15:24',NULL),(2138,8087,397,40720,1600,1,63,2,30615.71,NULL,'2022-12-08 09:15:24','2022-12-08 09:15:24',NULL),(2139,8087,397,40720,1600,1,62,2,122465.00,NULL,'2022-12-08 09:15:24','2022-12-08 09:15:24',NULL),(2140,8087,397,40720,1600,1,64,2,2000.00,NULL,'2022-12-08 09:15:24','2022-12-08 09:15:24',NULL),(2141,8087,398,40720,1600,3,392,1,1281940.35,NULL,'2022-12-08 09:19:26','2022-12-08 09:19:26',NULL),(2142,8087,398,40720,1600,3,68,1,271453.32,NULL,'2022-12-08 09:19:26','2022-12-08 09:19:26',NULL),(2143,8087,398,40720,1600,3,494,1,10973.26,NULL,'2022-12-08 09:19:26','2022-12-08 09:19:26',NULL),(2144,8087,398,40720,1600,3,496,1,18433.16,NULL,'2022-12-08 09:19:26','2022-12-08 09:19:26',NULL),(2145,8087,398,40720,1600,3,495,1,32491.32,NULL,'2022-12-08 09:19:26','2022-12-08 09:19:26',NULL),(2146,8087,398,40720,1600,3,116,1,24137.00,NULL,'2022-12-08 09:19:26','2022-12-08 09:19:26',NULL);
INSERT INTO `balance_libro_details` VALUES (2147,8087,398,40720,1600,3,193,1,6129.78,NULL,'2022-12-08 09:19:26','2022-12-08 09:19:26',NULL),(2148,8087,398,40720,1600,3,135,1,50581.68,NULL,'2022-12-08 09:19:26','2022-12-08 09:19:26',NULL),(2149,8087,398,40720,1600,3,128,1,5269.29,NULL,'2022-12-08 09:19:26','2022-12-08 09:19:26',NULL),(2150,8087,398,40720,1600,3,485,1,1580.00,NULL,'2022-12-08 09:19:26','2022-12-08 09:19:26',NULL),(2151,8087,398,40720,1600,3,359,2,324810.92,NULL,'2022-12-08 09:19:26','2022-12-08 09:19:26',NULL),(2152,8087,398,40720,1600,3,57,2,1378178.24,NULL,'2022-12-08 09:19:26','2022-12-08 09:19:26',NULL),(2153,8087,399,40720,1600,2,359,1,976887.10,NULL,'2022-12-08 09:20:38','2022-12-08 09:20:38',NULL),(2154,8087,399,40720,1600,2,67,2,169542.39,NULL,'2022-12-08 09:20:38','2022-12-08 09:20:38',NULL),(2155,8087,399,40720,1600,2,96,2,807344.71,NULL,'2022-12-08 09:20:38','2022-12-08 09:20:38',NULL),(2156,8087,400,40720,1600,5,157,1,4371.20,NULL,'2022-12-08 10:16:57','2022-12-08 10:16:57',NULL),(2157,8087,400,40720,1600,5,396,1,2375.36,NULL,'2022-12-08 10:16:57','2022-12-08 10:16:57',NULL),(2158,8087,400,40720,1600,5,276,1,3897.23,NULL,'2022-12-08 10:16:57','2022-12-08 10:16:57',NULL),(2159,8087,400,40720,1600,5,214,1,5230.40,NULL,'2022-12-08 10:16:57','2022-12-08 10:16:57',NULL),(2160,8087,400,40720,1600,5,474,1,490995.03,NULL,'2022-12-08 10:16:57','2022-12-08 10:16:57',NULL),(2161,8087,400,40720,1600,5,359,1,157945.90,NULL,'2022-12-08 10:16:57','2022-12-08 10:16:57',NULL),(2162,8087,400,40720,1600,5,474,2,173820.09,NULL,'2022-12-08 10:16:57','2022-12-08 10:16:57',NULL),(2163,8087,400,40720,1600,5,359,2,490995.03,NULL,'2022-12-08 10:16:57','2022-12-08 10:16:57',NULL),(2164,8087,401,40720,1600,21,57,1,190000.00,NULL,'2022-12-08 10:18:04','2022-12-08 10:18:04',NULL),(2165,8087,401,40720,1600,21,359,2,190000.00,NULL,'2022-12-08 10:18:04','2022-12-08 10:18:04',NULL),(2166,8087,402,40720,1601,21,62,1,122465.00,NULL,'2022-12-08 11:03:00','2022-12-08 11:03:00',NULL),(2167,8087,402,40720,1601,21,474,2,62465.00,NULL,'2022-12-08 11:03:00','2022-12-08 11:03:00',NULL),(2168,8087,402,40720,1601,21,359,2,60000.00,NULL,'2022-12-08 11:03:00','2022-12-08 11:03:00',NULL),(2169,8087,403,40720,1601,10,63,1,30615.71,NULL,'2022-12-08 12:10:02','2022-12-08 12:10:02',NULL),(2170,8087,403,40720,1601,10,64,1,2000.00,NULL,'2022-12-08 12:10:02','2022-12-08 12:10:02',NULL),(2171,8087,403,40720,1601,10,474,2,30615.71,NULL,'2022-12-08 12:10:02','2022-12-08 12:10:02',NULL),(2172,8087,403,40720,1601,10,359,2,2000.00,NULL,'2022-12-08 12:10:02','2022-12-08 12:10:02',NULL),(2173,8087,404,40720,1601,21,62,1,61233.00,NULL,'2022-12-08 12:25:15','2022-12-08 12:25:15',NULL),(2174,8087,404,40720,1601,21,500,1,81912.00,NULL,'2022-12-08 12:25:15','2022-12-08 12:25:15',NULL),(2175,8087,404,40720,1601,21,474,2,113145.00,NULL,'2022-12-08 12:25:15','2022-12-08 12:25:15',NULL),(2176,8087,404,40720,1601,21,359,2,30000.00,NULL,'2022-12-08 12:25:15','2022-12-08 12:25:15',NULL),(2177,8087,405,40720,1601,15,67,1,169542.39,NULL,'2022-12-08 12:57:36','2022-12-08 12:57:36',NULL),(2178,8087,405,40720,1601,15,499,1,112884.19,NULL,'2022-12-08 12:57:36','2022-12-08 12:57:36',NULL),(2179,8087,405,40720,1601,15,68,2,271453.32,NULL,'2022-12-08 12:57:36','2022-12-08 12:57:36',NULL),(2180,8087,405,40720,1601,15,494,2,10973.26,NULL,'2022-12-08 12:57:36','2022-12-08 12:57:36',NULL),(2181,8087,406,40720,1601,21,57,1,192000.00,NULL,'2022-12-08 14:31:49','2022-12-08 14:31:49',NULL),(2182,8087,406,40720,1601,21,359,2,192000.00,NULL,'2022-12-08 14:31:49','2022-12-08 14:31:49',NULL),(2183,8087,407,40720,1601,21,57,1,190000.00,NULL,'2022-12-08 14:34:03','2022-12-08 14:34:03',NULL),(2184,8087,407,40720,1601,21,359,2,190000.00,NULL,'2022-12-08 14:34:03','2022-12-08 14:34:03',NULL),(2185,8087,408,40720,1601,16,156,1,33141.67,NULL,'2022-12-08 14:38:07','2022-12-08 14:38:07',NULL),(2186,8087,408,40720,1601,16,497,1,21680.04,NULL,'2022-12-08 14:38:07','2022-12-08 14:38:07',NULL);
INSERT INTO `balance_libro_details` VALUES (2187,8087,408,40720,1601,16,276,2,3897.23,NULL,'2022-12-08 14:38:07','2022-12-08 14:38:07',NULL),(2188,8087,408,40720,1601,16,496,2,18433.16,NULL,'2022-12-08 14:38:07','2022-12-08 14:38:07',NULL),(2189,8087,408,40720,1601,16,495,2,32491.32,NULL,'2022-12-08 14:38:07','2022-12-08 14:38:07',NULL),(2190,8087,409,40720,1601,15,67,1,196106.44,NULL,'2022-12-08 14:48:32','2022-12-08 14:48:32',NULL),(2191,8087,409,40720,1601,15,499,2,25131.65,NULL,'2022-12-08 14:48:32','2022-12-08 14:48:32',NULL),(2192,8087,409,40720,1601,15,68,2,167577.58,NULL,'2022-12-08 14:48:32','2022-12-08 14:48:32',NULL),(2193,8087,409,40720,1601,15,25,2,68.33,NULL,'2022-12-08 14:48:32','2022-12-08 14:48:32',NULL),(2194,8087,409,40720,1601,15,494,2,3328.88,NULL,'2022-12-08 14:48:32','2022-12-08 14:48:32',NULL),(2195,8087,410,40720,1601,16,156,1,41296.85,NULL,'2022-12-08 14:52:22','2022-12-08 14:52:22',NULL),(2196,8087,410,40720,1601,16,497,1,14644.44,NULL,'2022-12-08 14:52:22','2022-12-08 14:52:22',NULL),(2197,8087,410,40720,1601,16,496,2,3402.56,NULL,'2022-12-08 14:52:22','2022-12-08 14:52:22',NULL),(2198,8087,410,40720,1601,16,495,2,22764.23,NULL,'2022-12-08 14:52:22','2022-12-08 14:52:22',NULL),(2199,8087,410,40720,1601,16,492,2,29774.50,NULL,'2022-12-08 14:52:22','2022-12-08 14:52:22',NULL),(2200,8087,411,40720,1601,1,110,1,216471.55,NULL,'2022-12-08 14:54:04','2022-12-08 14:54:04',NULL),(2201,8087,411,40720,1601,1,191,1,29315.22,NULL,'2022-12-08 14:54:04','2022-12-08 14:54:04',NULL),(2202,8087,411,40720,1601,1,63,2,51343.77,NULL,'2022-12-08 14:54:04','2022-12-08 14:54:04',NULL),(2203,8087,411,40720,1601,1,62,2,192443.00,NULL,'2022-12-08 14:54:04','2022-12-08 14:54:04',NULL),(2204,8087,411,40720,1601,1,64,2,2000.00,NULL,'2022-12-08 14:54:04','2022-12-08 14:54:04',NULL),(2205,8087,412,40720,1601,3,392,1,783420.71,NULL,'2022-12-08 15:13:17','2022-12-08 15:13:17',NULL),(2206,8087,412,40720,1601,3,68,1,167577.58,NULL,'2022-12-08 15:13:17','2022-12-08 15:13:17',NULL),(2207,8087,412,40720,1601,3,494,1,3328.88,NULL,'2022-12-08 15:13:17','2022-12-08 15:13:17',NULL),(2208,8087,412,40720,1601,3,23,1,280.53,NULL,'2022-12-08 15:13:17','2022-12-08 15:13:17',NULL),(2209,8087,412,40720,1601,3,496,1,3402.56,NULL,'2022-12-08 15:13:17','2022-12-08 15:13:17',NULL),(2210,8087,412,40720,1601,3,495,1,22764.23,NULL,'2022-12-08 15:13:17','2022-12-08 15:13:17',NULL),(2211,8087,412,40720,1601,3,116,1,30000.00,NULL,'2022-12-08 15:13:17','2022-12-08 15:13:17',NULL),(2212,8087,412,40720,1601,3,193,1,6728.86,NULL,'2022-12-08 15:13:17','2022-12-08 15:13:17',NULL),(2213,8087,412,40720,1601,3,484,1,2813.77,NULL,'2022-12-08 15:13:17','2022-12-08 15:13:17',NULL),(2214,8087,412,40720,1601,3,135,1,41181.51,NULL,'2022-12-08 15:13:17','2022-12-08 15:13:17',NULL),(2215,8087,412,40720,1601,3,128,1,10616.20,NULL,'2022-12-08 15:13:17','2022-12-08 15:13:17',NULL),(2216,8087,412,40720,1601,3,485,1,1580.00,NULL,'2022-12-08 15:13:17','2022-12-08 15:13:17',NULL),(2217,8087,412,40720,1601,3,57,2,851880.97,NULL,'2022-12-08 15:13:17','2022-12-08 15:13:17',NULL),(2218,8087,412,40720,1601,3,359,2,221813.86,NULL,'2022-12-08 15:13:17','2022-12-08 15:13:17',NULL),(2219,8087,413,40720,1601,2,359,1,1129946.61,NULL,'2022-12-08 15:16:15','2022-12-08 15:16:15',NULL),(2220,8087,413,40720,1601,2,67,2,196106.44,NULL,'2022-12-08 15:16:15','2022-12-08 15:16:15',NULL),(2221,8087,413,40720,1601,2,96,2,933840.17,NULL,'2022-12-08 15:16:15','2022-12-08 15:16:15',NULL),(2222,8087,414,40720,1601,5,157,1,4024.18,NULL,'2022-12-08 15:18:23','2022-12-08 15:18:23',NULL),(2223,8087,414,40720,1601,5,396,1,2307.03,NULL,'2022-12-08 15:18:23','2022-12-08 15:18:23',NULL),(2224,8087,414,40720,1601,5,25,1,68.33,NULL,'2022-12-08 15:18:23','2022-12-08 15:18:23',NULL),(2225,8087,414,40720,1601,5,214,1,12698.08,NULL,'2022-12-08 15:18:23','2022-12-08 15:18:23',NULL),(2226,8087,414,40720,1601,5,474,1,312329.83,NULL,'2022-12-08 15:18:23','2022-12-08 15:18:23',NULL);
INSERT INTO `balance_libro_details` VALUES (2227,8087,414,40720,1601,5,359,1,325251.99,NULL,'2022-12-08 15:18:23','2022-12-08 15:18:23',NULL),(2228,8087,414,40720,1601,5,474,2,344349.61,NULL,'2022-12-08 15:18:23','2022-12-08 15:18:23',NULL),(2229,8087,414,40720,1601,5,359,2,312329.83,NULL,'2022-12-08 15:18:23','2022-12-08 15:18:23',NULL),(2230,8087,415,40720,1601,4,132,1,15533.64,NULL,'2022-12-08 15:20:55','2023-03-06 14:14:31','2023-03-06 14:14:31'),(2231,8087,415,40720,1601,4,48,2,15533.64,NULL,'2022-12-08 15:20:55','2023-03-06 14:14:31','2023-03-06 14:14:31'),(2232,8087,416,40720,1601,19,135,1,410.40,NULL,'2022-12-08 15:21:59','2022-12-09 08:57:06','2022-12-09 08:57:06'),(2233,8087,416,40720,1601,19,496,2,301.05,NULL,'2022-12-08 15:21:59','2022-12-09 08:57:06','2022-12-09 08:57:06'),(2234,8087,416,40720,1601,19,495,2,109.35,NULL,'2022-12-08 15:21:59','2022-12-09 08:57:06','2022-12-09 08:57:06'),(2235,8087,417,40720,1601,19,493,1,5110634.71,NULL,'2022-12-08 15:23:35','2023-03-10 19:05:54','2023-03-10 19:05:54'),(2236,8087,417,40720,1601,19,392,2,5110634.71,NULL,'2022-12-08 15:23:35','2023-03-10 19:05:54','2023-03-10 19:05:54'),(2237,8087,418,40720,1601,23,48,2,11567.24,NULL,'2022-12-08 17:07:15','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2238,8087,418,40720,1601,23,214,1,20695.98,NULL,'2022-12-08 17:07:15','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2239,8087,418,40720,1601,23,392,1,2617486.56,NULL,'2022-12-08 17:07:16','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2240,8087,418,40720,1601,23,276,1,670.39,NULL,'2022-12-08 17:07:16','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2241,8087,418,40720,1601,23,157,1,6763.17,NULL,'2022-12-08 17:07:17','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2242,8087,418,40720,1601,23,110,1,293154.96,NULL,'2022-12-08 17:07:17','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2243,8087,418,40720,1601,23,135,1,20364.12,NULL,'2022-12-08 17:07:17','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2244,8087,418,40720,1601,23,193,1,12363.60,NULL,'2022-12-08 17:07:17','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2245,8087,418,40720,1601,23,383,2,200555.40,NULL,'2022-12-08 17:07:17','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2246,8087,418,40720,1601,23,88,2,27040.68,NULL,'2022-12-08 17:07:18','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2247,8087,418,40720,1601,23,363,1,70006.70,NULL,'2022-12-08 17:07:18','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2248,8087,418,40720,1601,23,277,1,33.85,NULL,'2022-12-08 17:07:18','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2249,8087,418,40720,1601,23,396,1,4586.96,NULL,'2022-12-08 17:07:18','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2250,8087,418,40720,1601,23,191,1,37863.85,NULL,'2022-12-08 17:07:18','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2251,8087,418,40720,1601,23,128,1,14319.78,NULL,'2022-12-08 17:07:18','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2252,8087,418,40720,1601,23,484,1,9105.06,NULL,'2022-12-08 17:07:18','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2253,8087,418,40720,1601,23,96,2,1440327.05,NULL,'2022-12-08 17:07:19','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2254,8087,418,40720,1601,23,381,2,4746.03,NULL,'2022-12-08 17:07:19','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2255,8087,418,40720,1601,23,485,1,3297.33,NULL,'2022-12-08 17:07:19','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2256,8087,418,40720,1601,23,156,1,46193.68,NULL,'2022-12-08 17:07:19','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2257,8087,418,40720,1601,23,116,1,38658.00,NULL,'2022-12-08 17:07:19','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2258,8087,418,40720,1601,23,476,2,1511327.59,NULL,'2022-12-08 17:07:19','2022-12-09 08:48:43','2022-12-09 08:48:43'),(2259,8087,419,40720,1601,19,135,1,319.38,NULL,'2022-12-09 08:57:06','2022-12-09 08:57:06',NULL),(2260,8087,419,40720,1601,19,494,1,91.02,NULL,'2022-12-09 08:57:06','2022-12-09 08:57:06',NULL),(2261,8087,419,40720,1601,19,496,2,301.05,NULL,'2022-12-09 08:57:06','2022-12-09 08:57:06',NULL);
INSERT INTO `balance_libro_details` VALUES (2262,8087,419,40720,1601,19,495,2,109.35,NULL,'2022-12-09 08:57:06','2022-12-09 08:57:06',NULL),(2263,8087,420,40720,1601,23,110,1,293154.96,NULL,'2022-12-09 09:13:10','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2264,8087,420,40720,1601,23,135,1,20364.12,NULL,'2022-12-09 09:13:11','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2265,8087,420,40720,1601,23,193,1,12363.60,NULL,'2022-12-09 09:13:11','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2266,8087,420,40720,1601,23,383,2,200555.40,NULL,'2022-12-09 09:13:11','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2267,8087,420,40720,1601,23,88,2,27040.68,NULL,'2022-12-09 09:13:11','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2268,8087,420,40720,1601,23,363,1,70006.70,NULL,'2022-12-09 09:13:11','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2269,8087,420,40720,1601,23,396,1,4586.96,NULL,'2022-12-09 09:13:11','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2270,8087,420,40720,1601,23,191,1,37863.85,NULL,'2022-12-09 09:13:11','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2271,8087,420,40720,1601,23,128,1,14319.78,NULL,'2022-12-09 09:13:11','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2272,8087,420,40720,1601,23,484,1,9105.06,NULL,'2022-12-09 09:13:11','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2273,8087,420,40720,1601,23,96,2,1440327.05,NULL,'2022-12-09 09:13:11','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2274,8087,420,40720,1601,23,381,2,4746.03,NULL,'2022-12-09 09:13:11','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2275,8087,420,40720,1601,23,48,2,11567.24,NULL,'2022-12-09 09:13:11','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2276,8087,420,40720,1601,23,392,1,2617486.56,NULL,'2022-12-09 09:13:11','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2277,8087,420,40720,1601,23,214,1,20695.98,NULL,'2022-12-09 09:13:12','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2278,8087,420,40720,1601,23,157,1,6763.17,NULL,'2022-12-09 09:13:12','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2279,8087,420,40720,1601,23,485,1,3297.33,NULL,'2022-12-09 09:13:12','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2280,8087,420,40720,1601,23,156,1,46193.68,NULL,'2022-12-09 09:13:12','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2281,8087,420,40720,1601,23,116,1,38658.00,NULL,'2022-12-09 09:13:12','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2282,8087,420,40720,1601,23,476,2,1510623.35,NULL,'2022-12-09 09:13:12','2023-03-06 14:55:37','2023-03-06 14:55:37'),(2283,8087,421,40720,1560,12,359,1,1333050.14,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2284,8087,421,40720,1560,12,474,1,229862.76,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2285,8087,421,40720,1560,12,68,1,3161.32,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2286,8087,421,40720,1560,12,20,1,68366.29,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2287,8087,421,40720,1560,12,23,1,14301.15,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2288,8087,421,40720,1560,12,251,1,10869.32,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2289,8087,421,40720,1560,12,252,1,1134.39,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2290,8087,421,40720,1560,12,482,1,636000.00,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2291,8087,421,40720,1560,12,483,1,225000.00,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2292,8087,421,40720,1560,12,392,1,532968.19,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2293,8087,421,40720,1560,12,363,1,101326.50,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2294,8087,421,40720,1560,12,57,2,1195050.63,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2295,8087,421,40720,1560,12,74,2,45000.50,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2296,8087,421,40720,1560,12,327,2,9275.72,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2297,8087,421,40720,1560,12,326,2,665.00,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2298,8087,421,40720,1560,12,63,2,29019.73,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL);
INSERT INTO `balance_libro_details` VALUES (2299,8087,421,40720,1560,12,64,2,2000.00,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2300,8087,421,40720,1560,12,486,2,925000.00,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2301,8087,421,40720,1560,12,487,2,17089.86,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2302,8087,421,40720,1560,12,72,2,91.02,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2303,8087,421,40720,1560,12,383,2,833688.41,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2304,8087,421,40720,1560,12,381,2,10530.86,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2305,8087,421,40720,1560,12,369,2,60000.00,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2306,8087,421,40720,1560,12,88,2,28628.33,NULL,'2023-01-02 11:10:20','2023-01-02 11:10:20',NULL),(2307,8087,422,40720,1571,23,392,1,1406622.42,NULL,'2023-01-02 15:49:35','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2308,8087,422,40720,1571,23,214,1,17029.27,NULL,'2023-01-02 15:49:35','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2309,8087,422,40720,1571,23,157,1,13743.04,NULL,'2023-01-02 15:49:35','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2310,8087,422,40720,1571,23,110,1,230535.27,NULL,'2023-01-02 15:49:35','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2311,8087,422,40720,1571,23,381,2,5211.50,NULL,'2023-01-02 15:49:35','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2312,8087,422,40720,1571,23,485,1,538.46,NULL,'2023-01-02 15:49:35','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2313,8087,422,40720,1571,23,135,1,33718.24,NULL,'2023-01-02 15:49:35','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2314,8087,422,40720,1571,23,193,1,6449.07,NULL,'2023-01-02 15:49:35','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2315,8087,422,40720,1571,23,396,1,561911.60,NULL,'2023-01-02 15:49:36','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2316,8087,422,40720,1571,23,191,1,44426.30,NULL,'2023-01-02 15:49:36','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2317,8087,422,40720,1571,23,88,2,29692.75,NULL,'2023-01-02 15:49:36','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2318,8087,422,40720,1571,23,363,1,75287.80,NULL,'2023-01-02 15:49:36','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2319,8087,422,40720,1571,23,383,2,412575.08,NULL,'2023-01-02 15:49:36','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2320,8087,422,40720,1571,23,128,1,20093.94,NULL,'2023-01-02 15:49:36','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2321,8087,422,40720,1571,23,484,1,9025.50,NULL,'2023-01-02 15:49:36','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2322,8087,422,40720,1571,23,96,2,1910693.18,NULL,'2023-01-02 15:49:36','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2323,8087,422,40720,1571,23,156,1,50676.61,NULL,'2023-01-02 15:49:37','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2324,8087,422,40720,1571,23,116,1,5465.18,NULL,'2023-01-02 15:49:37','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2325,8087,422,40720,1571,23,488,1,400.99,NULL,'2023-01-02 15:49:37','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2326,8087,422,40720,1571,23,476,2,117751.18,NULL,'2023-01-02 15:49:37','2023-01-02 16:33:04','2023-01-02 16:33:04'),(2327,8087,423,40720,1571,19,493,1,4299713.85,NULL,'2023-01-02 16:27:17','2023-01-02 17:16:19','2023-01-02 17:16:19'),(2328,8087,423,40720,1571,19,392,2,4299713.85,NULL,'2023-01-02 16:27:17','2023-01-02 17:16:19','2023-01-02 17:16:19'),(2329,8087,424,40720,1571,19,493,1,4076352.09,NULL,'2023-01-02 17:16:19','2023-01-02 17:16:19',NULL),(2330,8087,424,40720,1571,19,392,2,4076352.09,NULL,'2023-01-02 17:16:19','2023-01-02 17:16:19',NULL),(2331,8087,425,40720,1571,23,396,1,561911.60,NULL,'2023-01-02 17:27:11','2023-01-31 16:16:53','2023-01-31 16:16:53'),(2332,8087,425,40720,1571,23,191,1,44426.30,NULL,'2023-01-02 17:27:11','2023-01-31 16:16:53','2023-01-31 16:16:53'),(2333,8087,425,40720,1571,23,363,1,75287.80,NULL,'2023-01-02 17:27:11','2023-01-31 16:16:53','2023-01-31 16:16:53'),(2334,8087,425,40720,1571,23,381,2,5211.50,NULL,'2023-01-02 17:27:11','2023-01-31 16:16:53','2023-01-31 16:16:53');
INSERT INTO `balance_libro_details` VALUES (2335,8087,425,40720,1571,23,128,1,20093.94,NULL,'2023-01-02 17:27:11','2023-01-31 16:16:53','2023-01-31 16:16:53'),(2336,8087,425,40720,1571,23,484,1,9025.50,NULL,'2023-01-02 17:27:11','2023-01-31 16:16:53','2023-01-31 16:16:53'),(2337,8087,425,40720,1571,23,392,1,1406622.42,NULL,'2023-01-02 17:27:11','2023-01-31 16:16:53','2023-01-31 16:16:53'),(2338,8087,425,40720,1571,23,214,1,17029.27,NULL,'2023-01-02 17:27:11','2023-01-31 16:16:53','2023-01-31 16:16:53'),(2339,8087,425,40720,1571,23,157,1,13743.04,NULL,'2023-01-02 17:27:11','2023-01-31 16:16:53','2023-01-31 16:16:53'),(2340,8087,425,40720,1571,23,110,1,230535.27,NULL,'2023-01-02 17:27:11','2023-01-31 16:16:53','2023-01-31 16:16:53'),(2341,8087,425,40720,1571,23,88,2,29692.75,NULL,'2023-01-02 17:27:11','2023-01-31 16:16:53','2023-01-31 16:16:53'),(2342,8087,425,40720,1571,23,485,1,538.46,NULL,'2023-01-02 17:27:12','2023-01-31 16:16:53','2023-01-31 16:16:53'),(2343,8087,425,40720,1571,23,383,2,412575.08,NULL,'2023-01-02 17:27:12','2023-01-31 16:16:53','2023-01-31 16:16:53'),(2344,8087,425,40720,1571,23,135,1,33718.24,NULL,'2023-01-02 17:27:12','2023-01-31 16:16:53','2023-01-31 16:16:53'),(2345,8087,425,40720,1571,23,193,1,6449.07,NULL,'2023-01-02 17:27:12','2023-01-31 16:16:53','2023-01-31 16:16:53'),(2346,8087,425,40720,1571,23,96,2,1910693.18,NULL,'2023-01-02 17:27:12','2023-01-31 16:16:53','2023-01-31 16:16:53'),(2347,8087,425,40720,1571,23,156,1,50676.61,NULL,'2023-01-02 17:27:12','2023-01-31 16:16:53','2023-01-31 16:16:53'),(2348,8087,425,40720,1571,23,116,1,5465.18,NULL,'2023-01-02 17:27:12','2023-01-31 16:16:53','2023-01-31 16:16:53'),(2349,8087,425,40720,1571,23,488,1,400.99,NULL,'2023-01-02 17:27:12','2023-01-31 16:16:53','2023-01-31 16:16:53'),(2350,8087,425,40720,1571,23,476,2,117751.18,NULL,'2023-01-02 17:27:12','2023-01-31 16:16:53','2023-01-31 16:16:53'),(2351,8087,426,40720,1575,12,359,1,930130.93,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2352,8087,426,40720,1575,12,474,1,55986.31,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2353,8087,426,40720,1575,12,20,1,97768.13,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2354,8087,426,40720,1575,12,23,1,19459.68,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2355,8087,426,40720,1575,12,482,1,772600.00,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2356,8087,426,40720,1575,12,483,1,565000.00,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2357,8087,426,40720,1575,12,392,1,2914314.29,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2358,8087,426,40720,1575,12,363,1,230624.22,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2359,8087,426,40720,1575,12,48,2,10132.65,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2360,8087,426,40720,1575,12,57,2,2140663.27,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2361,8087,426,40720,1575,12,74,2,64178.02,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2362,8087,426,40720,1575,12,78,2,7088.28,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2363,8087,426,40720,1575,12,492,2,4227.85,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2364,8087,426,40720,1575,12,63,2,44295.18,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2365,8087,426,40720,1575,12,64,2,2000.00,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2366,8087,426,40720,1575,12,62,2,30000.00,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2367,8087,426,40720,1575,12,486,2,925000.00,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2368,8087,426,40720,1575,12,487,2,57025.71,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2369,8087,426,40720,1575,12,369,2,60000.00,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2370,8087,426,40720,1575,12,381,2,15742.36,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2371,8087,426,40720,1575,12,494,2,91.02,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL);
INSERT INTO `balance_libro_details` VALUES (2372,8087,426,40720,1575,12,383,2,2112423.20,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2373,8087,426,40720,1575,12,88,2,113016.02,NULL,'2023-01-06 12:48:43','2023-01-06 12:48:43',NULL),(2374,8087,427,40720,1586,4,132,1,22049.16,NULL,'2023-01-06 15:54:29','2023-03-01 14:50:58','2023-03-01 14:50:58'),(2375,8087,427,40720,1586,4,48,2,22049.16,NULL,'2023-01-06 15:54:29','2023-03-01 14:50:58','2023-03-01 14:50:58'),(2376,8087,428,40720,1586,23,191,1,55737.07,NULL,'2023-01-06 16:13:37','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2377,8087,428,40720,1586,23,485,1,2561.63,NULL,'2023-01-06 16:13:37','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2378,8087,428,40720,1586,23,88,2,37454.71,NULL,'2023-01-06 16:13:38','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2379,8087,428,40720,1586,23,135,1,2072.55,NULL,'2023-01-06 16:13:38','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2380,8087,428,40720,1586,23,381,2,5217.18,NULL,'2023-01-06 16:13:38','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2381,8087,428,40720,1586,23,116,1,32140.41,NULL,'2023-01-06 16:13:38','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2382,8087,428,40720,1586,23,48,2,3358.07,NULL,'2023-01-06 16:13:38','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2383,8087,428,40720,1586,23,96,2,1071550.69,NULL,'2023-01-06 16:13:38','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2384,8087,428,40720,1586,23,110,1,205529.39,NULL,'2023-01-06 16:13:38','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2385,8087,428,40720,1586,23,128,1,7513.70,NULL,'2023-01-06 16:13:38','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2386,8087,428,40720,1586,23,383,2,700079.43,NULL,'2023-01-06 16:13:39','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2387,8087,428,40720,1586,23,484,1,10316.91,NULL,'2023-01-06 16:13:39','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2388,8087,428,40720,1586,23,88,2,19884.64,NULL,'2023-01-06 16:13:39','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2389,8087,428,40720,1586,23,392,1,1762777.71,NULL,'2023-01-06 16:13:39','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2390,8087,428,40720,1586,23,363,1,76431.31,NULL,'2023-01-06 16:13:39','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2391,8087,428,40720,1586,23,488,1,1499.80,NULL,'2023-01-06 16:13:39','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2392,8087,428,40720,1586,23,193,1,6028.31,NULL,'2023-01-06 16:13:39','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2393,8087,428,40720,1586,23,214,1,13808.70,NULL,'2023-01-06 16:13:39','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2394,8087,428,40720,1586,23,157,1,7742.21,NULL,'2023-01-06 16:13:39','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2395,8087,428,40720,1586,23,396,1,8827.81,NULL,'2023-01-06 16:13:39','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2396,8087,428,40720,1586,23,156,1,31058.70,NULL,'2023-01-06 16:13:39','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2397,8087,428,40720,1586,23,498,2,24135.81,NULL,'2023-01-06 16:13:40','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2398,8087,428,40720,1586,23,476,2,362365.68,NULL,'2023-01-06 16:13:40','2023-03-01 15:03:42','2023-03-01 15:03:42'),(2399,8087,429,40720,1571,23,396,1,561911.60,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(2400,8087,429,40720,1571,23,191,1,44426.30,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(2401,8087,429,40720,1571,23,363,1,75287.80,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(2402,8087,429,40720,1571,23,381,2,5211.50,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(2403,8087,429,40720,1571,23,128,1,20093.94,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(2404,8087,429,40720,1571,23,484,1,9025.50,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(2405,8087,429,40720,1571,23,392,1,1406622.42,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(2406,8087,429,40720,1571,23,214,1,17029.27,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(2407,8087,429,40720,1571,23,157,1,13743.04,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL);
INSERT INTO `balance_libro_details` VALUES (2408,8087,429,40720,1571,23,110,1,230535.27,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(2409,8087,429,40720,1571,23,485,1,538.46,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(2410,8087,429,40720,1571,23,383,2,412575.08,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(2411,8087,429,40720,1571,23,135,1,33718.24,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(2412,8087,429,40720,1571,23,193,1,6449.07,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(2413,8087,429,40720,1571,23,96,2,1910693.18,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(2414,8087,429,40720,1571,23,156,1,50676.61,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(2415,8087,429,40720,1571,23,116,1,5465.18,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(2416,8087,429,40720,1571,23,488,1,400.99,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(2417,8087,429,40720,1571,23,476,2,63056.24,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(2418,8087,429,40720,1571,23,88,2,84387.69,NULL,'2023-01-31 16:16:53','2023-01-31 16:16:53',NULL),(2419,8087,430,40720,1586,19,493,1,4591089.66,NULL,'2023-03-01 14:49:10','2023-03-01 14:49:10',NULL),(2420,8087,430,40720,1586,19,392,2,4591089.66,NULL,'2023-03-01 14:49:10','2023-03-01 14:49:10',NULL),(2421,8087,431,40720,1586,4,132,1,23062.42,NULL,'2023-03-01 14:50:58','2023-03-01 14:50:58',NULL),(2422,8087,431,40720,1586,4,48,2,23062.42,NULL,'2023-03-01 14:50:58','2023-03-01 14:50:58',NULL),(2423,8087,432,40720,1586,23,191,1,55737.07,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2424,8087,432,40720,1586,23,485,1,2561.63,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2425,8087,432,40720,1586,23,88,2,106479.30,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2426,8087,432,40720,1586,23,135,1,2072.55,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2427,8087,432,40720,1586,23,381,2,5217.18,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2428,8087,432,40720,1586,23,116,1,32140.41,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2429,8087,432,40720,1586,23,48,2,3358.07,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2430,8087,432,40720,1586,23,96,2,1071550.69,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2431,8087,432,40720,1586,23,110,1,205529.39,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2432,8087,432,40720,1586,23,128,1,7513.70,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2433,8087,432,40720,1586,23,383,2,700079.43,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2434,8087,432,40720,1586,23,484,1,10316.91,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2435,8087,432,40720,1586,23,88,2,19884.64,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2436,8087,432,40720,1586,23,392,1,1762777.71,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2437,8087,432,40720,1586,23,363,1,76431.31,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2438,8087,432,40720,1586,23,488,1,1499.80,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2439,8087,432,40720,1586,23,193,1,6028.31,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2440,8087,432,40720,1586,23,214,1,13808.70,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2441,8087,432,40720,1586,23,157,1,7742.21,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2442,8087,432,40720,1586,23,396,1,8827.81,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2443,8087,432,40720,1586,23,156,1,31058.70,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2444,8087,432,40720,1586,23,498,2,24135.81,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2445,8087,432,40720,1586,23,476,2,293341.09,NULL,'2023-03-01 15:03:42','2023-03-01 15:03:42',NULL),(2446,8087,433,40720,1590,12,359,1,543065.27,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2447,8087,433,40720,1590,12,474,1,68746.43,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL);
INSERT INTO `balance_libro_details` VALUES (2448,8087,433,40720,1590,12,497,1,19212.23,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2449,8087,433,40720,1590,12,499,1,53361.88,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2450,8087,433,40720,1590,12,20,1,97768.13,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2451,8087,433,40720,1590,12,23,1,19598.54,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2452,8087,433,40720,1590,12,482,1,772600.00,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2453,8087,433,40720,1590,12,483,1,785000.00,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2454,8087,433,40720,1590,12,392,1,5028110.14,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2455,8087,433,40720,1590,12,363,1,307055.53,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2456,8087,433,40720,1590,12,48,2,36553.14,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2457,8087,433,40720,1590,12,57,2,3159779.17,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2458,8087,433,40720,1590,12,492,2,9989.14,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2459,8087,433,40720,1590,12,63,2,48943.18,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2460,8087,433,40720,1590,12,64,2,4000.00,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2461,8087,433,40720,1590,12,62,2,65681.00,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2462,8087,433,40720,1590,12,486,2,925000.00,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2463,8087,433,40720,1590,12,369,2,60000.00,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2464,8087,433,40720,1590,12,381,2,20959.54,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2465,8087,433,40720,1590,12,494,2,91.02,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2466,8087,433,40720,1590,12,383,2,3124142.00,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2467,8087,433,40720,1590,12,88,2,239379.96,NULL,'2023-03-06 12:16:43','2023-03-06 12:16:43',NULL),(2468,8087,434,40720,1601,4,132,1,30705.55,NULL,'2023-03-06 14:14:31','2023-03-06 14:14:31',NULL),(2469,8087,434,40720,1601,4,48,2,30705.55,NULL,'2023-03-06 14:14:31','2023-03-06 14:14:31',NULL),(2470,8087,435,40720,1601,23,214,1,20695.98,NULL,'2023-03-06 15:20:24','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2471,8087,435,40720,1601,23,157,1,6763.17,NULL,'2023-03-06 15:20:25','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2472,8087,435,40720,1601,23,110,1,293154.96,NULL,'2023-03-06 15:20:25','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2473,8087,435,40720,1601,23,135,1,20364.12,NULL,'2023-03-06 15:20:25','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2474,8087,435,40720,1601,23,383,2,1407981.94,NULL,'2023-03-06 15:20:25','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2475,8087,435,40720,1601,23,193,1,12363.60,NULL,'2023-03-06 15:20:26','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2476,8087,435,40720,1601,23,88,2,27040.68,NULL,'2023-03-06 15:20:26','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2477,8087,435,40720,1601,23,96,2,1440327.05,NULL,'2023-03-06 15:20:27','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2478,8087,435,40720,1601,23,363,1,138383.16,NULL,'2023-03-06 15:20:27','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2479,8087,435,40720,1601,23,396,1,4586.96,NULL,'2023-03-06 15:20:28','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2480,8087,435,40720,1601,23,191,1,37863.85,NULL,'2023-03-06 15:20:28','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2481,8087,435,40720,1601,23,128,1,14319.78,NULL,'2023-03-06 15:20:28','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2482,8087,435,40720,1601,23,88,2,107883.27,NULL,'2023-03-06 15:20:29','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2483,8087,435,40720,1601,23,484,1,9105.06,NULL,'2023-03-06 15:20:29','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2484,8087,435,40720,1601,23,381,2,9446.00,NULL,'2023-03-06 15:20:29','2023-03-10 19:36:24','2023-03-10 19:36:24');
INSERT INTO `balance_libro_details` VALUES (2485,8087,435,40720,1601,23,392,1,3874026.34,NULL,'2023-03-06 15:20:29','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2486,8087,435,40720,1601,23,48,2,16473.69,NULL,'2023-03-06 15:20:30','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2487,8087,435,40720,1601,23,485,1,3297.33,NULL,'2023-03-06 15:20:30','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2488,8087,435,40720,1601,23,156,1,46193.68,NULL,'2023-03-06 15:20:30','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2489,8087,435,40720,1601,23,116,1,38658.00,NULL,'2023-03-06 15:20:30','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2490,8087,435,40720,1601,23,476,2,1510623.36,NULL,'2023-03-06 15:20:31','2023-03-10 19:36:24','2023-03-10 19:36:24'),(2491,8087,436,40720,1601,19,493,1,7331212.55,NULL,'2023-03-10 19:05:54','2023-03-10 19:05:54',NULL),(2492,8087,436,40720,1601,19,392,2,7331212.55,NULL,'2023-03-10 19:05:54','2023-03-10 19:05:54',NULL),(2493,8087,437,40720,1601,23,214,1,20695.98,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2494,8087,437,40720,1601,23,157,1,6763.17,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2495,8087,437,40720,1601,23,110,1,293154.96,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2496,8087,437,40720,1601,23,135,1,20364.12,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2497,8087,437,40720,1601,23,383,2,1591437.93,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2498,8087,437,40720,1601,23,193,1,12363.60,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2499,8087,437,40720,1601,23,88,2,27040.68,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2500,8087,437,40720,1601,23,96,2,1440327.05,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2501,8087,437,40720,1601,23,363,1,138383.16,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2502,8087,437,40720,1601,23,396,1,4586.96,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2503,8087,437,40720,1601,23,191,1,37863.85,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2504,8087,437,40720,1601,23,128,1,14319.78,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2505,8087,437,40720,1601,23,88,2,125463.47,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2506,8087,437,40720,1601,23,484,1,9105.06,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2507,8087,437,40720,1601,23,381,2,10676.79,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2508,8087,437,40720,1601,23,392,1,3874026.34,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2509,8087,437,40720,1601,23,48,2,16473.69,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2510,8087,437,40720,1601,23,485,1,3297.33,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2511,8087,437,40720,1601,23,156,1,46193.68,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2512,8087,437,40720,1601,23,116,1,38658.00,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2513,8087,437,40720,1601,23,476,2,1308356.38,NULL,'2023-03-10 19:36:24','2023-03-10 19:36:24',NULL),(2514,8087,438,40720,1623,1,110,1,190000.00,NULL,'2023-08-16 08:18:48','2023-08-16 08:18:48',NULL),(2515,8087,438,40720,1623,1,111,1,0.00,NULL,'2023-08-16 08:18:48','2023-08-16 08:18:48',NULL),(2516,8087,438,40720,1623,1,112,1,0.00,NULL,'2023-08-16 08:18:48','2023-08-16 08:18:48',NULL),(2517,8087,438,40720,1623,1,62,2,190000.00,NULL,'2023-08-16 08:18:48','2023-08-16 08:18:48',NULL),(2518,8087,438,40720,1623,1,63,2,0.00,NULL,'2023-08-16 08:18:48','2023-08-16 08:18:48',NULL),(2519,8087,438,40720,1623,1,64,2,0.00,NULL,'2023-08-16 08:18:48','2023-08-16 08:18:48',NULL),(2520,8087,438,40720,1623,1,63,1,0.00,NULL,'2023-08-16 08:18:48','2023-08-16 08:18:48',NULL),(2521,8087,438,40720,1623,1,162,2,0.00,NULL,'2023-08-16 08:18:48','2023-08-16 08:18:48',NULL),(2522,8087,439,40720,1624,1,110,1,190000.00,NULL,'2023-08-16 08:19:03','2023-08-16 08:19:03',NULL),(2523,8087,439,40720,1624,1,111,1,2976.36,NULL,'2023-08-16 08:19:03','2023-08-16 08:19:03',NULL);
INSERT INTO `balance_libro_details` VALUES (2524,8087,439,40720,1624,1,112,1,0.00,NULL,'2023-08-16 08:19:03','2023-08-16 08:19:03',NULL),(2525,8087,439,40720,1624,1,62,2,190000.00,NULL,'2023-08-16 08:19:03','2023-08-16 08:19:03',NULL),(2526,8087,439,40720,1624,1,63,2,2976.36,NULL,'2023-08-16 08:19:03','2023-08-16 08:19:03',NULL),(2527,8087,439,40720,1624,1,64,2,0.00,NULL,'2023-08-16 08:19:03','2023-08-16 08:19:03',NULL),(2528,8087,439,40720,1624,1,63,1,0.00,NULL,'2023-08-16 08:19:03','2023-08-16 08:19:03',NULL),(2529,8087,439,40720,1624,1,162,2,0.00,NULL,'2023-08-16 08:19:03','2023-08-16 08:19:03',NULL),(2530,8087,440,40720,1625,1,110,1,285001.00,NULL,'2023-08-16 08:19:12','2023-08-16 08:19:12',NULL),(2531,8087,440,40720,1625,1,111,1,4330.37,NULL,'2023-08-16 08:19:12','2023-08-16 08:19:12',NULL),(2532,8087,440,40720,1625,1,112,1,0.00,NULL,'2023-08-16 08:19:12','2023-08-16 08:19:12',NULL),(2533,8087,440,40720,1625,1,62,2,285001.00,NULL,'2023-08-16 08:19:12','2023-08-16 08:19:12',NULL),(2534,8087,440,40720,1625,1,63,2,4330.37,NULL,'2023-08-16 08:19:12','2023-08-16 08:19:12',NULL),(2535,8087,440,40720,1625,1,64,2,0.00,NULL,'2023-08-16 08:19:12','2023-08-16 08:19:12',NULL),(2536,8087,440,40720,1625,1,63,1,0.00,NULL,'2023-08-16 08:19:12','2023-08-16 08:19:12',NULL),(2537,8087,440,40720,1625,1,162,2,0.00,NULL,'2023-08-16 08:19:12','2023-08-16 08:19:12',NULL),(2538,8087,441,40720,1626,1,110,1,250000.00,NULL,'2023-10-31 12:17:40','2023-10-31 12:17:40',NULL),(2539,8087,441,40720,1626,1,111,1,3856.36,NULL,'2023-10-31 12:17:40','2023-10-31 12:17:40',NULL),(2540,8087,441,40720,1626,1,112,1,0.00,NULL,'2023-10-31 12:17:40','2023-10-31 12:17:40',NULL),(2541,8087,441,40720,1626,1,62,2,250000.00,NULL,'2023-10-31 12:17:40','2023-10-31 12:17:40',NULL),(2542,8087,441,40720,1626,1,63,2,3856.36,NULL,'2023-10-31 12:17:40','2023-10-31 12:17:40',NULL),(2543,8087,441,40720,1626,1,64,2,0.00,NULL,'2023-10-31 12:17:40','2023-10-31 12:17:40',NULL),(2544,8087,441,40720,1626,1,63,1,0.00,NULL,'2023-10-31 12:17:40','2023-10-31 12:17:40',NULL),(2545,8087,441,40720,1626,1,162,2,0.00,NULL,'2023-10-31 12:17:40','2023-10-31 12:17:40',NULL),(2546,8087,442,40720,1627,1,110,1,280000.00,NULL,'2023-10-31 12:17:49','2023-10-31 12:17:49',NULL),(2547,8087,442,40720,1627,1,111,1,3879.36,NULL,'2023-10-31 12:17:49','2023-10-31 12:17:49',NULL),(2548,8087,442,40720,1627,1,112,1,0.00,NULL,'2023-10-31 12:17:49','2023-10-31 12:17:49',NULL),(2549,8087,442,40720,1627,1,62,2,280000.00,NULL,'2023-10-31 12:17:49','2023-10-31 12:17:49',NULL),(2550,8087,442,40720,1627,1,63,2,3879.36,NULL,'2023-10-31 12:17:49','2023-10-31 12:17:49',NULL),(2551,8087,442,40720,1627,1,64,2,0.00,NULL,'2023-10-31 12:17:49','2023-10-31 12:17:49',NULL),(2552,8087,442,40720,1627,1,63,1,0.00,NULL,'2023-10-31 12:17:49','2023-10-31 12:17:49',NULL),(2553,8087,442,40720,1627,1,162,2,0.00,NULL,'2023-10-31 12:17:49','2023-10-31 12:17:49',NULL),(2554,8087,443,40720,1628,1,110,1,280000.00,NULL,'2023-10-31 12:17:57','2023-10-31 12:17:57',NULL),(2555,8087,443,40720,1628,1,111,1,3901.36,NULL,'2023-10-31 12:17:57','2023-10-31 12:17:57',NULL),(2556,8087,443,40720,1628,1,112,1,0.00,NULL,'2023-10-31 12:17:57','2023-10-31 12:17:57',NULL),(2557,8087,443,40720,1628,1,62,2,280000.00,NULL,'2023-10-31 12:17:57','2023-10-31 12:17:57',NULL),(2558,8087,443,40720,1628,1,63,2,3901.36,NULL,'2023-10-31 12:17:57','2023-10-31 12:17:57',NULL),(2559,8087,443,40720,1628,1,64,2,0.00,NULL,'2023-10-31 12:17:57','2023-10-31 12:17:57',NULL),(2560,8087,443,40720,1628,1,63,1,0.00,NULL,'2023-10-31 12:17:57','2023-10-31 12:17:57',NULL),(2561,8087,443,40720,1628,1,162,2,0.00,NULL,'2023-10-31 12:17:57','2023-10-31 12:17:57',NULL),(2562,8087,444,40720,1629,1,110,1,300000.00,NULL,'2023-11-29 13:16:32','2023-11-29 13:16:32',NULL),(2563,8087,444,40720,1629,1,111,1,4620.36,NULL,'2023-11-29 13:16:32','2023-11-29 13:16:32',NULL),(2564,8087,444,40720,1629,1,112,1,0.00,NULL,'2023-11-29 13:16:32','2023-11-29 13:16:32',NULL);
INSERT INTO `balance_libro_details` VALUES (2565,8087,444,40720,1629,1,62,2,300000.00,NULL,'2023-11-29 13:16:32','2023-11-29 13:16:32',NULL),(2566,8087,444,40720,1629,1,63,2,4620.36,NULL,'2023-11-29 13:16:32','2023-11-29 13:16:32',NULL),(2567,8087,444,40720,1629,1,64,2,0.00,NULL,'2023-11-29 13:16:32','2023-11-29 13:16:32',NULL),(2568,8087,444,40720,1629,1,63,1,0.00,NULL,'2023-11-29 13:16:32','2023-11-29 13:16:32',NULL),(2569,8087,444,40720,1629,1,162,2,0.00,NULL,'2023-11-29 13:16:32','2023-11-29 13:16:32',NULL),(2570,8087,445,40720,1630,1,110,1,350000.00,NULL,'2024-01-04 14:36:35','2024-01-04 14:36:35',NULL),(2571,8087,445,40720,1630,1,111,1,5352.36,NULL,'2024-01-04 14:36:35','2024-01-04 14:36:35',NULL),(2572,8087,445,40720,1630,1,112,1,0.00,NULL,'2024-01-04 14:36:35','2024-01-04 14:36:35',NULL),(2573,8087,445,40720,1630,1,62,2,350000.00,NULL,'2024-01-04 14:36:35','2024-01-04 14:36:35',NULL),(2574,8087,445,40720,1630,1,63,2,5352.36,NULL,'2024-01-04 14:36:35','2024-01-04 14:36:35',NULL),(2575,8087,445,40720,1630,1,64,2,0.00,NULL,'2024-01-04 14:36:35','2024-01-04 14:36:35',NULL),(2576,8087,445,40720,1630,1,63,1,0.00,NULL,'2024-01-04 14:36:35','2024-01-04 14:36:35',NULL),(2577,8087,445,40720,1630,1,162,2,0.00,NULL,'2024-01-04 14:36:35','2024-01-04 14:36:35',NULL);
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bind_apibank_credentials`
--

DROP TABLE IF EXISTS `bind_apibank_credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bind_apibank_credentials` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'Usuario que configuró las credenciales',
  `person_id` int(10) unsigned NOT NULL COMMENT 'Empresa',
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL COMMENT 'Cuenta de tesorería vinculada',
  `env` enum('sandbox','prod') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Ambiente: sandbox o producción',
  `username` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Usuario de Bind APIBank',
  `password` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Password encriptado con Laravel Crypt',
  `cert_path` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Path absoluto al certificado SSL del cliente (.crt)',
  `key_path` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Path absoluto a la llave privada SSL (.key)',
  `key_password` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Password de la llave privada (si está protegida con password)',
  `jwt_token` text COLLATE utf8mb4_unicode_ci COMMENT 'Token JWT actual',
  `jwt_expires_at` datetime DEFAULT NULL COMMENT 'Fecha de expiración del token JWT',
  `bind_account_id` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'ID de cuenta en Bind (obtenido al hacer login)',
  `active` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Credencial activa?',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_bind_apibank_cred_person` (`person_id`),
  KEY `idx_bind_apibank_cred_cuenta` (`cta_cte_tesoreria_cuenta_id`),
  KEY `idx_bind_apibank_cred_active` (`active`),
  KEY `idx_bind_apibank_cred_bind_acc` (`bind_account_id`),
  KEY `idx_bind_apibank_cred_person_active` (`person_id`,`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bind_apibank_credentials`
--

LOCK TABLES `bind_apibank_credentials` WRITE;
/*!40000 ALTER TABLE `bind_apibank_credentials` DISABLE KEYS */;
/*!40000 ALTER TABLE `bind_apibank_credentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bind_apibank_movements`
--

DROP TABLE IF EXISTS `bind_apibank_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bind_apibank_movements` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'Usuario que ejecutó la sincronización',
  `person_id` int(10) unsigned NOT NULL COMMENT 'Empresa',
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL COMMENT 'Cuenta de tesorería',
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL COMMENT 'Movimiento en tesorería (vinculación bidireccional)',
  `bind_movement_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'ID único del movimiento en Bind',
  `type` enum('in','out','fee') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Tipo: in=transferencia entrante, out=transferencia saliente, fee=comisión',
  `status` enum('settled','pending','failed') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Estado del movimiento',
  `amount` decimal(15,2) NOT NULL COMMENT 'Monto del movimiento',
  `currency` char(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ARS' COMMENT 'Moneda (ARS, USD)',
  `from_cbu_cvu` varchar(22) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'CBU/CVU origen',
  `from_titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Titular de la cuenta origen',
  `from_cuit` varchar(13) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'CUIT del titular origen',
  `to_cbu_cvu` varchar(22) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'CBU/CVU destino',
  `to_titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Titular de la cuenta destino',
  `to_cuit` varchar(13) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'CUIT del titular destino',
  `concept` text COLLATE utf8mb4_unicode_ci COMMENT 'Concepto/descripción del movimiento',
  `reference` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Referencia del movimiento',
  `executed_at` datetime DEFAULT NULL COMMENT 'Fecha de ejecución del movimiento en Bind',
  `raw_response` json DEFAULT NULL COMMENT 'Respuesta completa de la API de Bind (para auditoría)',
  `is_synced_to_treasury` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ya sincronizado a tesorería?',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_bind_apibank_mov_bind_id` (`bind_movement_id`),
  KEY `idx_bind_apibank_mov_person` (`person_id`),
  KEY `idx_bind_apibank_mov_cuenta` (`cta_cte_tesoreria_cuenta_id`),
  KEY `idx_bind_apibank_mov_tesoreria` (`cta_cte_tesoreria_id`),
  KEY `idx_bind_apibank_mov_synced` (`is_synced_to_treasury`),
  KEY `idx_bind_apibank_mov_executed` (`executed_at`),
  KEY `idx_bind_apibank_mov_type_status` (`type`,`status`),
  KEY `idx_bind_apibank_mov_person_synced` (`person_id`,`is_synced_to_treasury`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bind_apibank_movements`
--

LOCK TABLES `bind_apibank_movements` WRITE;
/*!40000 ALTER TABLE `bind_apibank_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `bind_apibank_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bind_apibank_sync_logs`
--

DROP TABLE IF EXISTS `bind_apibank_sync_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bind_apibank_sync_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'Usuario que ejecutó la sincronización',
  `person_id` int(10) unsigned NOT NULL COMMENT 'Empresa',
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL COMMENT 'Cuenta sincronizada',
  `sync_type` enum('movements','balance','transfers','webhook') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Tipo de sincronización: movements=movimientos, balance=saldo, transfers=transferencias, webhook=desde webhook',
  `last_sync_at` datetime NOT NULL COMMENT 'Fecha/hora de la sincronización',
  `records_synced` int(11) NOT NULL DEFAULT '0' COMMENT 'Cantidad de registros sincronizados',
  `status` enum('success','error') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Estado de la sincronización',
  `error_message` text COLLATE utf8mb4_unicode_ci COMMENT 'Mensaje de error (si status=error)',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_bind_apibank_sync_person` (`person_id`),
  KEY `idx_bind_apibank_sync_cuenta` (`cta_cte_tesoreria_cuenta_id`),
  KEY `idx_bind_apibank_sync_type` (`sync_type`),
  KEY `idx_bind_apibank_sync_last` (`last_sync_at`),
  KEY `idx_bind_apibank_sync_type_status` (`sync_type`,`status`),
  KEY `idx_bind_apibank_sync_person_type` (`person_id`,`sync_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bind_apibank_sync_logs`
--

LOCK TABLES `bind_apibank_sync_logs` WRITE;
/*!40000 ALTER TABLE `bind_apibank_sync_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bind_apibank_sync_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bind_apibank_transfers`
--

DROP TABLE IF EXISTS `bind_apibank_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bind_apibank_transfers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'Usuario que ejecutó la transferencia',
  `person_id` int(10) unsigned NOT NULL COMMENT 'Empresa',
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL COMMENT 'Cuenta origen de la transferencia',
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL COMMENT 'Movimiento en tesorería resultante (vinculación)',
  `bind_transfer_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'ID de transferencia en Bind',
  `numero_operacion` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Número de operación bancaria',
  `cbu_origin` varchar(22) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'CBU origen (nuestra cuenta)',
  `cbu_destination` varchar(22) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'CBU destino',
  `alias_destination` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Alias destino (alternativo a CBU)',
  `amount` decimal(15,2) NOT NULL COMMENT 'Monto de la transferencia',
  `currency` char(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ARS' COMMENT 'Moneda (ARS, USD)',
  `concept` text COLLATE utf8mb4_unicode_ci COMMENT 'Concepto de la transferencia',
  `reference` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Referencia interna (ej: FAC-001-1234)',
  `type` enum('INMEDIATA','PROGRAMADA') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'INMEDIATA' COMMENT 'Tipo de transferencia',
  `status` enum('PENDIENTE','APROBADA','RECHAZADA','CANCELADA') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'PENDIENTE' COMMENT 'Estado de la transferencia',
  `scheduled_at` datetime DEFAULT NULL COMMENT 'Fecha programada (si type=PROGRAMADA)',
  `executed_at` datetime DEFAULT NULL COMMENT 'Fecha de ejecución real',
  `comision` decimal(15,2) DEFAULT '0.00' COMMENT 'Comisión cobrada por Bind',
  `iva_comision` decimal(15,2) DEFAULT '0.00' COMMENT 'IVA de la comisión',
  `total_debitado` decimal(15,2) DEFAULT NULL COMMENT 'Total debitado (monto + comisión + IVA)',
  `raw_response` json DEFAULT NULL COMMENT 'Respuesta completa de la API de Bind',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_bind_apibank_trf_person` (`person_id`),
  KEY `idx_bind_apibank_trf_cuenta` (`cta_cte_tesoreria_cuenta_id`),
  KEY `idx_bind_apibank_trf_tesoreria` (`cta_cte_tesoreria_id`),
  KEY `idx_bind_apibank_trf_status` (`status`),
  KEY `idx_bind_apibank_trf_bind_id` (`bind_transfer_id`),
  KEY `idx_bind_apibank_trf_executed` (`executed_at`),
  KEY `idx_bind_apibank_trf_type_status` (`type`,`status`),
  KEY `idx_bind_apibank_trf_person_status` (`person_id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bind_apibank_transfers`
--

LOCK TABLES `bind_apibank_transfers` WRITE;
/*!40000 ALTER TABLE `bind_apibank_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `bind_apibank_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2022-11-09 14:46:51',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2022-11-09 14:46:51',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2022-11-09 14:46:51',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-11-09 14:46:51','2022-11-09 14:46:51',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-11-09 14:46:57','2022-11-09 14:46:57',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-11-09 14:46:57','2022-11-09 14:46:57',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-11-09 14:46:57','2022-11-09 14:46:57',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-11-09 14:46:57','2022-11-09 14:46:57',NULL),(11,2021,6000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-11-09 14:47:05','2022-11-09 14:47:05',NULL),(12,2021,6000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-11-09 14:47:05','2022-11-09 14:47:05',NULL),(13,2021,6000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-11-09 14:47:05','2022-11-09 14:47:05',NULL),(14,2021,6000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-11-09 14:47:05','2022-11-09 14:47:05',NULL),(15,2022,11282141.08,0.00,5641070.54,0.00,0.0050,0.00,'2023-05-30 15:05:37','2023-05-30 15:05:37',NULL),(16,2022,11282141.08,5641070.54,12222319.51,28205.35,0.0075,5641070.54,'2023-05-30 15:05:37','2023-05-30 15:05:37',NULL),(17,2022,11282141.08,12222319.51,33846423.25,77564.72,0.0100,12222319.51,'2023-05-30 15:05:37','2023-05-30 15:05:37',NULL),(18,2022,11282141.08,33846423.25,188035684.71,293802.76,0.0125,33846423.25,'2023-05-30 15:05:37','2023-05-30 15:05:37',NULL),(19,2022,11282141.08,188035684.71,564107054.14,2221171.53,0.0150,188035684.71,'2023-05-30 15:05:37','2023-05-30 15:05:37',NULL),(20,2022,11282141.08,564107054.14,999999999999.00,7682242.07,0.0175,564107054.14,'2023-05-30 15:05:37','2023-05-30 15:05:37',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar`
--

DROP TABLE IF EXISTS `calendar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `ws_telefono_id` bigint(20) unsigned DEFAULT NULL,
  `inv_ot_id` bigint(20) unsigned DEFAULT NULL,
  `calendar_tur_dispo_dato_id` bigint(20) unsigned DEFAULT NULL,
  `title` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion_text` longtext COLLATE utf8mb4_unicode_ci,
  `url` text COLLATE utf8mb4_unicode_ci,
  `start` datetime DEFAULT NULL,
  `startEditable` tinyint(1) NOT NULL DEFAULT '1',
  `startStr` text COLLATE utf8mb4_unicode_ci,
  `end` datetime DEFAULT NULL,
  `endStr` text COLLATE utf8mb4_unicode_ci,
  `allDay` tinyint(1) NOT NULL DEFAULT '1',
  `allow` tinyint(1) DEFAULT NULL,
  `backgroundColor` text COLLATE utf8mb4_unicode_ci,
  `borderColor` text COLLATE utf8mb4_unicode_ci,
  `classNames` longtext COLLATE utf8mb4_unicode_ci,
  `constraint` text COLLATE utf8mb4_unicode_ci,
  `display` text COLLATE utf8mb4_unicode_ci,
  `durationEditable` tinyint(1) NOT NULL DEFAULT '1',
  `extendedProps` longtext COLLATE utf8mb4_unicode_ci,
  `groupId` text COLLATE utf8mb4_unicode_ci,
  `overlap` text COLLATE utf8mb4_unicode_ci,
  `source` longtext COLLATE utf8mb4_unicode_ci,
  `textColor` text COLLATE utf8mb4_unicode_ci,
  `is_impuesto_from_taxes` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_person_id_foreign` (`person_id`),
  KEY `calendar_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `calendar_ws_telefono_id_foreign` (`ws_telefono_id`),
  KEY `calendar_calendar_tur_dispo_dato_id_foreign` (`calendar_tur_dispo_dato_id`),
  KEY `calendar_inv_ot_id_foreign` (`inv_ot_id`),
  CONSTRAINT `calendar_calendar_tur_dispo_dato_id_foreign` FOREIGN KEY (`calendar_tur_dispo_dato_id`) REFERENCES `calendar_tur_dispo_datos` (`id`),
  CONSTRAINT `calendar_inv_ot_id_foreign` FOREIGN KEY (`inv_ot_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `calendar_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_ws_telefono_id_foreign` FOREIGN KEY (`ws_telefono_id`) REFERENCES `ws_telefonos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar`
--

LOCK TABLES `calendar` WRITE;
/*!40000 ALTER TABLE `calendar` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_emails_telefonos`
--

DROP TABLE IF EXISTS `calendar_emails_telefonos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_emails_telefonos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci,
  `celular` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_emails_telefonos_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_emails_telefonos_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_emails_telefonos`
--

LOCK TABLES `calendar_emails_telefonos` WRITE;
/*!40000 ALTER TABLE `calendar_emails_telefonos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_emails_telefonos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_files`
--

DROP TABLE IF EXISTS `calendar_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_files_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_files_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_files`
--

LOCK TABLES `calendar_files` WRITE;
/*!40000 ALTER TABLE `calendar_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1`
--

DROP TABLE IF EXISTS `calendar_niv_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_1_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1`
--

LOCK TABLES `calendar_niv_1` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1_2`
--

DROP TABLE IF EXISTS `calendar_niv_1_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_2_person_id_foreign` (`person_id`),
  KEY `calendar_niv_1_2_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_niv_1_2_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_niv_1_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1_2`
--

LOCK TABLES `calendar_niv_1_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_2`
--

DROP TABLE IF EXISTS `calendar_niv_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_2_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_2`
--

LOCK TABLES `calendar_niv_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_notificaciones`
--

DROP TABLE IF EXISTS `calendar_notificaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_notificaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `start` datetime DEFAULT NULL,
  `tipo_de_notificacion_id` int(10) unsigned NOT NULL,
  `cantidad` int(10) unsigned NOT NULL,
  `unidad_de_tiempo_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_notificaciones_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_notificaciones_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_notificaciones`
--

LOCK TABLES `calendar_notificaciones` WRITE;
/*!40000 ALTER TABLE `calendar_notificaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_notificaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo`
--

DROP TABLE IF EXISTS `calendar_tur_dispo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `dia_hora` datetime(5) DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00:30',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_tur_dispo_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_tur_dispo_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo`
--

LOCK TABLES `calendar_tur_dispo` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo_datos`
--

DROP TABLE IF EXISTS `calendar_tur_dispo_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_tur_dispo_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre_ape` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_datos_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` (`calendar_tur_dispo_id`),
  CONSTRAINT `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` FOREIGN KEY (`calendar_tur_dispo_id`) REFERENCES `calendar_tur_dispo` (`id`),
  CONSTRAINT `calendar_tur_dispo_datos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo_datos`
--

LOCK TABLES `calendar_tur_dispo_datos` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1850.00,11100.00,370000.00,30,3300,NULL,'1',NULL,'2022-11-09 14:47:07',NULL),(2,'B',2750.00,16500.00,550000.00,45,5000,NULL,'1',NULL,'2022-11-09 14:47:07',NULL),(3,'C',3850.00,23100.00,770000.00,60,6700,NULL,'1',NULL,'2022-11-09 14:47:07',NULL),(4,'D',5300.00,31800.00,1060000.00,85,10000,NULL,'1',NULL,'2022-11-09 14:47:07',NULL),(5,'E',7000.00,42000.00,1400000.00,110,13000,NULL,'1',NULL,'2022-11-09 14:47:07',NULL),(6,'F',8750.00,52500.00,1750000.00,150,16500,NULL,'1',NULL,'2022-11-09 14:47:07',NULL),(7,'G',10500.00,63000.00,2100000.00,200,20000,NULL,'1',NULL,'2022-11-09 14:47:07',NULL),(8,'H',13000.00,78000.00,2600000.00,200,20000,NULL,'1',NULL,'2022-11-09 14:47:07',NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',8992597.87,749383.16,'No Excluida','0',30,3330,2091301.83,4182.60,4182.60,13663.17,19239.97,37085.74,37085.74,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',13175201.52,1097933.46,'No Excluida','0',45,5000,2091301.83,7946.95,7946.95,15029.49,19239.97,42216.41,42216.41,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',18473166.15,1539430.51,'No Excluida','0',60,6700,2858112.50,13663.17,12547.81,16532.44,19239.97,49435.58,48320.22,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',22934610.05,1911217.50,'No Excluida','0',85,10000,2858112.50,22307.22,20773.60,18185.68,22864.90,63357.80,61824.18,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',26977793.60,2248149.47,'No Excluida','0',110,13000,3624923.17,41826.04,33181.99,20004.25,27884.02,89714.31,81070.26,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',33809379.57,2817448.30,'No Excluida','0',150,16500,3624923.17,58835.29,43220.24,22004.67,32066.63,112906.59,97291.54,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',40431835.35,3369319.61,'No Excluida','0',200,20000,4322023.77,107074.65,53537.32,30806.54,34576.19,172457.38,118920.05,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',61344853.64,5112071.14,'No Excluida','0',200,20000,6273905.49,306724.27,153362.13,43129.16,41547.19,391400.62,238038.48,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',68664410.05,5722034.17,'Venta de Bs Muebles','0',200,20000,6273905.49,609963.03,243985.21,60380.82,51306.61,721650.46,355672.64,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',78632948.76,6552745.73,'Venta de Bs Muebles','0',200,20000,6273905.49,731955.63,292782.26,84533.15,57580.51,874069.29,434895.92,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',94805682.90,7900473.58,'Venta de Bs Muebles','0',200,20000,6273905.49,1024737.89,341579.30,118346.41,65806.30,1208890.60,525732.01,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',1414762.00,117896.00,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL),(13,'A Exento',1414762.00,117896.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2192.15,3061.75,5253.90,5253.90,'',NULL,NULL,'0',NULL,NULL,NULL),(14,'B Exento',2103025.00,175252.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2411.36,3061.75,5473.11,5473.11,'',NULL,NULL,'0',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `chequeras_tipos`
--

DROP TABLE IF EXISTS `chequeras_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chequeras_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chequeras_tipos`
--

LOCK TABLES `chequeras_tipos` WRITE;
/*!40000 ALTER TABLE `chequeras_tipos` DISABLE KEYS */;
INSERT INTO `chequeras_tipos` VALUES (1,NULL,'Fisica',1,NULL,NULL,NULL),(2,NULL,'Electronica',1,NULL,NULL,NULL),(3,NULL,'Transferencias',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `chequeras_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cheques_transfer_emitidas`
--

DROP TABLE IF EXISTS `cheques_transfer_emitidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cheques_transfer_emitidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_cheq_id` int(10) unsigned NOT NULL,
  `fecha_emision` date NOT NULL,
  `fecha_cobro` date NOT NULL,
  `numero_cheque` int(11) NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cheques_transfer_emitidas_person_id_foreign` (`person_id`),
  KEY `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cte_tes_ban_che_id_foreign` (`cta_cte_tesoreria_banco_cheq_id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cte_tes_ban_che_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_cheq_id`) REFERENCES `cta_cte_tesoreria_banco_cheq` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cheques_transfer_emitidas`
--

LOCK TABLES `cheques_transfer_emitidas` WRITE;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,NULL,'Clave Fiscal',NULL,NULL,NULL),(2,NULL,'Clave Ciudad',NULL,NULL,NULL),(3,NULL,'Clave ARBA',NULL,NULL,NULL),(4,NULL,'Clave ANSES',NULL,NULL,NULL),(5,NULL,'Catedral',NULL,NULL,NULL),(6,NULL,'CEMIBA',NULL,NULL,NULL),(7,NULL,'COMPRA ARG',NULL,NULL,NULL),(8,NULL,'Consejo Ciencias Economicas',NULL,NULL,NULL),(9,NULL,'Correo',NULL,NULL,NULL),(10,NULL,'CUR',NULL,NULL,NULL),(11,NULL,'Firma Digital',NULL,NULL,NULL),(12,NULL,'Interbanking',NULL,NULL,NULL),(13,NULL,'Banco Citibank',NULL,NULL,NULL),(14,NULL,'Banco Ciudad',NULL,NULL,NULL),(15,NULL,'Banco Frances',NULL,NULL,NULL),(16,NULL,'Banco Galicia',NULL,NULL,NULL),(17,NULL,'Banco HSBC',NULL,NULL,NULL),(18,NULL,'Banco Itau',NULL,NULL,NULL),(19,NULL,'Banco Nacion',NULL,NULL,NULL),(20,NULL,'Banco Macro',NULL,NULL,NULL),(21,NULL,'Banco Patagonia',NULL,NULL,NULL),(22,NULL,'Banco Provincia',NULL,NULL,NULL),(23,NULL,'Banco Santander',NULL,NULL,NULL),(24,NULL,'Banco Supervielle',NULL,NULL,NULL),(25,NULL,'Seguridad e Higiene',NULL,NULL,NULL),(26,NULL,'Sindicato - ANSES',NULL,NULL,NULL),(27,NULL,'Sindicato - AOT',NULL,NULL,NULL),(28,NULL,'Sindicato - ATSA',NULL,NULL,NULL),(29,NULL,'Sindicato - Camioneros',NULL,NULL,NULL),(30,NULL,'Sindicato - Guinchero',NULL,NULL,NULL),(31,NULL,'Sindicato - IERIC',NULL,NULL,NULL),(32,NULL,'Sindicato - La Estrella',NULL,NULL,NULL),(33,NULL,'Sindicato - Nemesis',NULL,NULL,NULL),(34,NULL,'Sindicato - Pasta',NULL,NULL,NULL),(35,NULL,'Sindicato - SEC',NULL,NULL,NULL),(36,NULL,'Sindicato - SICOP',NULL,NULL,NULL),(37,NULL,'Sindicato - SOCAYA',NULL,NULL,NULL),(38,NULL,'Sindicato - UTHGRA',NULL,NULL,NULL),(39,NULL,'Sindicato - INACAP',NULL,NULL,NULL),(40,NULL,'Sindicato - Otro',NULL,NULL,NULL),(41,NULL,'Otra',NULL,NULL,NULL),(42,NULL,'Prisma - Firma Digital',NULL,NULL,NULL),(43,NULL,'Sindicato - FATSA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2022-11-09 14:46:57','2022-11-09 14:46:57',NULL),(2,NULL,'Articulo 6',6,0,'2022-11-09 14:46:57','2022-11-09 14:46:57',NULL),(3,NULL,'Articulo 7',7,0,'2022-11-09 14:46:57','2022-11-09 14:46:57',NULL),(4,NULL,'Articulo 8',8,0,'2022-11-09 14:46:57','2022-11-09 14:46:57',NULL),(5,NULL,'Articulo 9',9,0,'2022-11-09 14:46:57','2022-11-09 14:46:57',NULL),(6,NULL,'Articulo 10',10,0,'2022-11-09 14:46:57','2022-11-09 14:46:57',NULL),(7,NULL,'Articulo 11',11,0,'2022-11-09 14:46:57','2022-11-09 14:46:57',NULL),(8,NULL,'Articulo 12',12,0,'2022-11-09 14:46:57','2022-11-09 14:46:57',NULL),(9,NULL,'Articulo 13',13,0,'2022-11-09 14:46:57','2022-11-09 14:46:57',NULL),(10,NULL,'Articulo 14',14,1,'2022-11-09 14:46:57','2022-11-09 14:46:57',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores`
--

DROP TABLE IF EXISTS `cobradores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores`
--

LOCK TABLES `cobradores` WRITE;
/*!40000 ALTER TABLE `cobradores` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_datos`
--

DROP TABLE IF EXISTS `cobradores_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `url_panel` longtext COLLATE utf8mb4_unicode_ci,
  `usuario` text COLLATE utf8mb4_unicode_ci,
  `clave` text COLLATE utf8mb4_unicode_ci,
  `numero_de_soporte` text COLLATE utf8mb4_unicode_ci,
  `inicial_create_user` text COLLATE utf8mb4_unicode_ci,
  `imp_min_p_retirar` int(11) DEFAULT NULL,
  `secret_recarga` text COLLATE utf8mb4_unicode_ci,
  `secret_on_off` text COLLATE utf8mb4_unicode_ci,
  `clave_new_user` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_datos_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_datos_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_datos`
--

LOCK TABLES `cobradores_datos` WRITE;
/*!40000 ALTER TABLE `cobradores_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_metodos`
--

DROP TABLE IF EXISTS `cobradores_metodos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_metodos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cobradores_metodos_descripcion_unique` (`descripcion`),
  KEY `cobradores_metodos_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_metodos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_metodos`
--

LOCK TABLES `cobradores_metodos` WRITE;
/*!40000 ALTER TABLE `cobradores_metodos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_metodos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_on_off`
--

DROP TABLE IF EXISTS `cobradores_on_off`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_on_off` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `on_off` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_on_off_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_on_off_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_on_off`
--

LOCK TABLES `cobradores_on_off` WRITE;
/*!40000 ALTER TABLE `cobradores_on_off` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_on_off` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conciliaciones`
--

DROP TABLE IF EXISTS `conciliaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conciliaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `fecha` datetime NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_conciliado` decimal(13,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conciliaciones_person_id_foreign` (`person_id`),
  CONSTRAINT `conciliaciones_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conciliaciones`
--

LOCK TABLES `conciliaciones` WRITE;
/*!40000 ALTER TABLE `conciliaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `conciliaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conciliaciones_details`
--

DROP TABLE IF EXISTS `conciliaciones_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conciliaciones_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conciliacion_id` bigint(20) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conciliaciones_details_person_id_foreign` (`person_id`),
  KEY `conciliaciones_details_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  CONSTRAINT `conciliaciones_details_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `conciliaciones_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conciliaciones_details`
--

LOCK TABLES `conciliaciones_details` WRITE;
/*!40000 ALTER TABLE `conciliaciones_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `conciliaciones_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condicion_frente_al_iva`
--

DROP TABLE IF EXISTS `condicion_frente_al_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condicion_frente_al_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo_afip` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_comprobantes_a` tinyint(1) NOT NULL DEFAULT '0',
  `show_comprobantes_b` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condicion_frente_al_iva`
--

LOCK TABLES `condicion_frente_al_iva` WRITE;
/*!40000 ALTER TABLE `condicion_frente_al_iva` DISABLE KEYS */;
INSERT INTO `condicion_frente_al_iva` VALUES (1,NULL,1,'IVA Responsable Inscripto',1,0,1,NULL,NULL,NULL),(2,NULL,2,'IVA Responsable no Inscripto',0,0,1,NULL,'2025-02-11 16:41:11','2025-02-11 16:41:11'),(3,NULL,3,'IVA no Responsable',0,0,1,NULL,'2025-02-11 16:41:11','2025-02-11 16:41:11'),(4,NULL,4,'IVA Sujeto Exento',0,1,1,NULL,NULL,NULL),(5,NULL,5,'Consumidor Final',0,1,1,NULL,NULL,NULL),(6,NULL,6,'Responsable Monotributo',1,0,1,NULL,NULL,NULL),(7,NULL,7,'Sujeto no Categorizado',0,1,1,NULL,NULL,NULL),(8,NULL,8,'Proveedor del Exterior',0,1,1,NULL,NULL,NULL),(9,NULL,9,'Cliente del Exterior',0,1,1,NULL,NULL,NULL),(10,NULL,10,'IVA Liberado – Ley Nº 19.640',0,1,1,NULL,NULL,NULL),(11,NULL,11,'IVA Responsable Inscripto – Agente de Percepción',0,0,1,NULL,'2025-02-11 16:41:11','2025-02-11 16:41:11'),(12,NULL,12,'Pequeño Contribuyente Eventual',0,0,1,NULL,'2025-02-11 16:41:11','2025-02-11 16:41:11'),(13,NULL,13,'Monotributista Social',1,0,1,NULL,NULL,NULL),(14,NULL,14,'Pequeño Contribuyente Eventual Social',0,0,1,NULL,'2025-02-11 16:41:11','2025-02-11 16:41:11'),(15,NULL,15,'IVA No Alcanzado',0,1,1,NULL,'2025-02-11 19:41:11',NULL),(16,NULL,NULL,'Monotributista Trabajador Independiente Promovido',1,0,1,NULL,'2025-02-11 16:41:11','2025-02-11 16:41:11');
/*!40000 ALTER TABLE `condicion_frente_al_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones_venta`
--

LOCK TABLES `condiciones_venta` WRITE;
/*!40000 ALTER TABLE `condiciones_venta` DISABLE KEYS */;
INSERT INTO `condiciones_venta` VALUES (1,'Contado',NULL,NULL),(2,'Tarjeta de Debito',NULL,NULL),(3,'Tarjeta de Credito',NULL,NULL),(4,'Cuenta Corriente',NULL,NULL),(5,'Cheque',NULL,NULL),(6,'Ticket',NULL,NULL),(7,'Transferencia',NULL,NULL),(8,'Otra',NULL,NULL);
/*!40000 ALTER TABLE `condiciones_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas`
--

DROP TABLE IF EXISTS `consultas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas`
--

LOCK TABLES `consultas` WRITE;
/*!40000 ALTER TABLE `consultas` DISABLE KEYS */;
INSERT INTO `consultas` VALUES (1,NULL,'Estado Liquidaciones',1,NULL,NULL,NULL),(2,NULL,'Consumo',1,NULL,NULL,NULL),(3,NULL,'Resultado Liquidacion Hijas',1,'2023-03-12 23:45:03','2023-03-12 23:45:03',NULL),(4,NULL,'Tablero Control',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `consultas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas_aux`
--

DROP TABLE IF EXISTS `consultas_aux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas_aux` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `consulta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `estado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consultas_aux_consulta_id_foreign` (`consulta_id`),
  KEY `consultas_aux_person_id_foreign` (`person_id`),
  CONSTRAINT `consultas_aux_consulta_id_foreign` FOREIGN KEY (`consulta_id`) REFERENCES `consultas` (`id`),
  CONSTRAINT `consultas_aux_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas_aux`
--

LOCK TABLES `consultas_aux` WRITE;
/*!40000 ALTER TABLE `consultas_aux` DISABLE KEYS */;
/*!40000 ALTER TABLE `consultas_aux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos`
--

DROP TABLE IF EXISTS `conta_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `debe_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `haber_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `ctactecheque_id` int(10) unsigned DEFAULT NULL,
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `adjunto` text COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `radioChecked` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `CuentaTipo_id` int(10) unsigned DEFAULT NULL,
  `CentroCosto_id` int(10) unsigned DEFAULT NULL,
  `pagado` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_person_id_foreign` (`person_id`),
  KEY `conta_asientos_period_id_foreign` (`period_id`),
  KEY `conta_asientos_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `conta_asientos_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `conta_asientos_ctactecheque_id_foreign` (`ctactecheque_id`),
  KEY `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` (`haber_cta_cte_tesoreria_cuenta_id`),
  KEY `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` (`debe_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `conta_asientos_ctactecheque_id_foreign` FOREIGN KEY (`ctactecheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `conta_asientos_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`debe_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`haber_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos`
--

LOCK TABLES `conta_asientos` WRITE;
/*!40000 ALTER TABLE `conta_asientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos_details`
--

DROP TABLE IF EXISTS `conta_asientos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_details_conta_asiento_id_foreign` (`conta_asiento_id`),
  KEY `conta_asientos_details_person_id_foreign` (`person_id`),
  KEY `conta_asientos_details_period_id_foreign` (`period_id`),
  KEY `conta_asientos_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_details_saldo_id_foreign` (`saldo_id`),
  KEY `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_details_conta_asiento_id_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_asientos_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos_details`
--

LOCK TABLES `conta_asientos_details` WRITE;
/*!40000 ALTER TABLE `conta_asientos_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costo_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_centro_costo_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costo_plan_cuenta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_centro_costo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` (`conta_centro_costo_id`),
  KEY `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` (`conta_plan_cuenta_id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` FOREIGN KEY (`conta_centro_costo_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` FOREIGN KEY (`conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costo_plan_cuenta`
--

LOCK TABLES `conta_centro_costo_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costos`
--

DROP TABLE IF EXISTS `conta_centro_costos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costos_person_id_foreign` (`person_id`),
  CONSTRAINT `conta_centro_costos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costos`
--

LOCK TABLES `conta_centro_costos` WRITE;
/*!40000 ALTER TABLE `conta_centro_costos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_plan_cuenta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo` int(11) NOT NULL,
  `tipo_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `padre` int(11) NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rubro` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cpcuenta_type_tc_id` bigint(20) unsigned DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `no_editable` int(11) NOT NULL DEFAULT '1',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_plan_cuenta_tipo_cuenta_id_foreign` (`tipo_cuenta_id`),
  KEY `conta_plan_cuenta_saldo_id_foreign` (`saldo_id`),
  KEY `conta_plan_cuenta_cpcuenta_type_tc_id_foreign` (`cpcuenta_type_tc_id`),
  CONSTRAINT `conta_plan_cuenta_cpcuenta_type_tc_id_foreign` FOREIGN KEY (`cpcuenta_type_tc_id`) REFERENCES `cpcuenta_types_tc` (`id`),
  CONSTRAINT `conta_plan_cuenta_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_plan_cuenta_tipo_cuenta_id_foreign` FOREIGN KEY (`tipo_cuenta_id`) REFERENCES `conta_tipo_cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1433 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_plan_cuenta`
--

LOCK TABLES `conta_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_plan_cuenta` VALUES (1,NULL,1000000,1,1,0,'ACTIVO','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(2,NULL,1100000,2,1,1000000,'ACTIVO CORRIENTE','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(3,NULL,1110000,3,1,1100000,'CAJA Y BANCOS','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(4,NULL,1110100,4,1,1110000,'CAJAS','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(5,NULL,1110101,5,1,1110100,'Caja Oficina','Activo',NULL,NULL,0,1,0,0,0,0,NULL),(6,NULL,1110102,5,1,1110100,'Caja Casa','Activo',NULL,NULL,0,1,0,0,0,0,NULL),(7,NULL,1110103,5,1,1110100,'Caja Dolares Casa','Activo',NULL,NULL,0,1,0,0,0,0,NULL),(8,NULL,1110104,5,1,1110100,'Banco Santander 015-372795/5','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(9,NULL,1110200,4,1,1110000,'BANCOS','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(10,NULL,1110201,5,1,1110200,'Banco Santander Rio Cta Corriente','Activo',NULL,NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(11,NULL,1110202,5,1,1110200,'Banco Santander Rio Cta Corriente DOLARES','Activo',NULL,NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(12,NULL,1130000,3,1,1100000,'CREDITOS POR VENTAS','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(13,NULL,1130101,5,1,1130100,'Clientes - Deudores','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(14,NULL,1130102,5,1,1130100,'Deudores por ventas comunes','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(15,NULL,1130103,5,1,1130100,'Deudores por ventas morosos','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(16,NULL,1130104,5,1,1130100,'Deudores en gestión judicial','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(17,NULL,1130105,5,1,1130100,'Previsión deudores incobrables','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(18,NULL,1140000,3,1,1100000,'OTROS CREDITOS','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(19,NULL,1140100,4,1,1140000,'Retenciones Sufridas','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(20,NULL,1140301,5,1,1140300,'Anticipos Impuesto a las Ganancias','Activo',4,NULL,1,2,0,0,1,1,NULL),(21,NULL,1140102,5,1,1140100,'Retenciones Ingr. Brutos','Activo',NULL,NULL,0,1,0,0,0,0,NULL),(22,NULL,1140329,5,1,1140300,'Anticipo Impto.Ganancia Mínima Presunta','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(23,NULL,1140105,5,1,1140100,'Retenciones Impuesto a las Ganancias','Activo',3,NULL,1,2,1,0,0,1,NULL),(24,NULL,1140106,5,1,1140100,'Impuesto a las Ganancias (Saldo a favor)','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(25,NULL,1140107,5,1,1140100,'Retenciones de IVA','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(26,NULL,1140200,4,1,1140000,'CREDITOS DIVERSOS','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(27,NULL,1140201,5,1,1140200,'Anticipos de proveedores','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(28,NULL,1140205,5,1,1140200,'Depósito en garantía alquileres','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(29,NULL,1140206,5,1,1140200,'Derechos adquiridos a devengar','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(30,NULL,1140207,5,1,1140200,'Intereses a devengar','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(31,NULL,1140208,5,1,1140200,'Cuentas a rendir - Directores','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(32,NULL,1140210,5,1,1140200,'Alquileres no devengados','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(33,NULL,1150000,3,1,1100000,'BIENES DE CAMBIO','Activo',5,NULL,1,1,0,0,0,0,NULL),(34,NULL,1150400,4,1,1150000,'MERCADERIA DE REVENTA','Activo',5,NULL,1,1,0,0,0,0,NULL),(35,NULL,1200000,2,1,1000000,'ACTIVO NO CORRIENTE','Activo',5,NULL,1,1,0,0,0,0,NULL),(36,NULL,1220000,3,1,1200000,'BIENES DE USO','Activo',5,NULL,1,1,0,0,0,0,NULL),(37,NULL,1220100,4,1,1220000,'EQUIPOS DE COMPUTACION','Activo',5,NULL,1,1,0,0,0,0,NULL),(38,NULL,1220101,5,1,1220100,'Equipos de computación valores históricos','Activo',5,NULL,1,1,0,0,0,1,NULL),(39,NULL,1220102,5,1,1220100,'Equipos de computación ajuste','Activo',5,NULL,1,1,0,0,0,1,NULL),(40,NULL,1220108,5,1,1220100,'Amortización Acumulada Equipos de comput.','Activo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(41,NULL,1220200,4,1,1220000,'INSTALACIONES','Activo',5,NULL,1,1,0,0,0,0,NULL),(42,NULL,1220201,5,1,1220200,'Instalaciones valores históricos','Activo',5,NULL,1,1,0,0,0,1,NULL),(43,NULL,1220202,5,1,1220200,'Instalaciones ajuste','Activo',5,NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (44,NULL,1220206,5,1,1220200,'Amortización Acumulada Instalaciones','Activo',5,NULL,1,1,0,0,0,1,NULL),(45,NULL,1220300,4,1,1220000,'MUEBLES Y UTILES','Activo',5,NULL,1,1,0,0,0,0,NULL),(46,NULL,1220301,5,1,1220300,'Muebles y utiles valores históricos','Activo',5,NULL,1,1,0,0,0,1,NULL),(47,NULL,1220302,5,1,1220300,'Muebles y utiles ajuste','Activo',5,NULL,1,1,0,0,0,1,NULL),(48,NULL,1220306,5,1,1220300,'Amortización Acumulada Muebles y Útiles','Activo',5,NULL,1,1,0,0,0,1,NULL),(49,NULL,1230000,3,1,1200000,'ACTIVOS INTANGIBLES','Activo',5,NULL,1,1,0,0,0,0,NULL),(50,NULL,1230101,5,1,1230100,'Gastos de organización valores historicos','Activo',5,NULL,1,1,0,0,0,1,NULL),(51,NULL,1230102,5,1,1230100,'Gastos de organización ajuste','Activo',5,NULL,1,1,0,0,0,1,NULL),(52,NULL,1230103,5,1,1230100,'Amortización acumulada gs. de organización','Activo',5,NULL,1,1,0,0,0,1,NULL),(53,NULL,2000000,1,2,0,'PASIVO','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(54,NULL,2100000,2,2,2000000,'PASIVO CORRIENTE','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(55,NULL,2110000,3,2,2100000,'Deudas','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(56,NULL,2110100,4,2,2110000,'Comerciales','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(57,NULL,2110101,5,2,2110100,'Proveedores en Cta. Cte. locales','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(58,NULL,2110102,5,2,2110100,'Proveedores en cta. cte. exterior','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(59,NULL,2110103,5,2,2110100,'Derechos de exhibición a devengar','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(60,NULL,2110104,5,2,2110100,'Cheques emitidos ','Pasivo',NULL,NULL,1,2,1,1,1,1,NULL),(61,NULL,2110200,4,2,2110000,'REMUNERACIONES Y CARGAS SOCIALES','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(62,NULL,2110201,5,2,2110200,'Sueldos y Jornales a pagar','Pasivo',NULL,NULL,1,2,0,0,1,1,NULL),(63,NULL,2110202,5,2,2110200,'Cargas sociales a pagar','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(64,NULL,2110203,5,2,2110200,'Sindicatos a Pagar','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(65,NULL,2110300,4,2,2110000,'CARGAS FISCALES','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(67,NULL,2110301,5,2,2110300,'IVA Debito Fiscal','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(68,NULL,1140222,5,1,1140200,'IVA Credito Fiscal','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(69,NULL,2110303,5,2,2110300,'Impuestos Internos','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(70,NULL,2110304,5,2,2110300,'Impuestos al Combustible','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(71,NULL,2110601,5,2,2110600,'IVA Retenciones de terceros','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(72,NULL,2110306,5,2,2110300,'IVA Percepciones realiz.por terceros','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(73,NULL,2110307,5,2,2110300,'IVA Saldo a favor','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(74,NULL,2110308,5,2,2110300,'IVA a pagar','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(75,NULL,2110309,5,2,2110300,'Percepciones Ingresos Brutos','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(76,NULL,2110310,5,2,2110300,'Otros Pagos AFIP','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(78,8087,2110354,5,2,2110300,'Impuesto a los Ingresos Brutos a pagar CF','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(79,8087,2110352,5,2,2110300,'Impuesto a las Ganancias a pagar','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(80,NULL,2110314,5,2,2110300,'Impuesto a la Ganancia Mínima Presunta','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(81,NULL,2110602,5,2,2110600,'AFIP - Retenciones Impuesto a las Ganancias','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(82,NULL,2110316,5,2,2110300,'AFIP - Plan de Facilidades Decreto 338/02','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(83,NULL,2200000,2,2,2000000,'PASIVO NO CORRIENTE','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(84,NULL,3000000,1,2,0,'PATRIMONIO NETO','Patrimonio Neto',NULL,NULL,1,1,0,0,0,0,NULL),(85,NULL,3100000,2,2,3000000,'APORTE DE LOS PROPIETARIOS','Patrimonio Neto',NULL,NULL,1,1,0,0,0,0,NULL),(86,NULL,3110100,4,2,3110000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,NULL,1,1,0,0,0,0,NULL),(87,NULL,3110101,5,2,3110100,'Acciones en circulación','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (88,NULL,3110102,5,2,3110100,'Ajuste del Capital','Patrimonio Neto',NULL,NULL,1,2,0,0,0,1,NULL),(89,NULL,3110103,5,2,3110100,'Aportes Irrevocables Futuras Suscripciones','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(90,NULL,3400000,2,2,3000000,'RESULTADOS','Patrimonio Neto',NULL,NULL,1,1,0,0,0,0,NULL),(91,NULL,3410101,5,2,3410100,'Resultado del ejercicio','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(92,NULL,3410102,5,2,3410100,'Resultado ejercicios anteriores','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(93,NULL,3410103,5,2,3410100,'A.R.E.A.','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(94,NULL,4000000,1,2,0,'INGRESOS','Result. Positivo',NULL,NULL,1,1,0,0,0,0,NULL),(95,NULL,4100000,2,2,4000000,'INGRESOS ORDINARIOS','Result. Positivo',NULL,NULL,1,1,0,0,0,0,NULL),(96,NULL,4110101,5,2,4110100,'VENTAS','Result. Positivo',NULL,NULL,1,2,0,0,0,1,NULL),(97,NULL,4110102,5,2,4110100,'Honorarios','Result. Positivo',NULL,NULL,1,1,0,0,0,1,NULL),(98,NULL,4110103,5,2,4110100,'Sueldo Vane','Result. Positivo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(99,NULL,4110104,5,2,4110100,'Descuentos obtenidos','Result. Positivo',NULL,NULL,1,1,0,0,0,1,NULL),(100,NULL,4110105,5,2,4110100,'Reintegros por exportaciones','Result. Positivo',NULL,NULL,1,1,0,0,0,1,NULL),(101,NULL,4120000,3,2,4100000,'OTROS INGRESOS','Result. Positivo',NULL,NULL,1,1,0,0,0,0,NULL),(102,NULL,4120101,5,2,4120100,'Intereses Cobrados','Result. Positivo',NULL,NULL,1,1,0,0,0,1,NULL),(103,NULL,4120102,5,2,4120100,'Diferencias de cambio','Result. Positivo',NULL,NULL,1,1,0,0,0,1,NULL),(104,NULL,4120103,5,2,4120100,'Descuentos obtenidos','Result. Positivo',NULL,NULL,1,1,0,0,0,1,NULL),(107,NULL,5000000,1,1,0,'GASTOS','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(108,NULL,5100000,2,1,5000000,'GASTOS ORDINARIOS','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(109,NULL,5110100,4,1,5110000,'ASIENTO DE SUELDO','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(110,NULL,5110101,5,1,5110100,'Sueldos','Result. Negativo',2,NULL,1,2,0,0,0,1,NULL),(111,NULL,5110102,5,1,5110100,'Contribuciones','Result. Negativo',2,NULL,1,2,0,0,0,1,NULL),(112,NULL,5110103,5,1,5110100,'Sindicato','Result. Negativo',2,NULL,1,2,0,0,0,1,NULL),(113,NULL,5120100,4,1,5120000,'GASTOS DE OPERACION','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(114,NULL,5120101,5,1,5120100,'ACA','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(115,NULL,5120102,5,1,5120100,'Aereos','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(116,NULL,5120103,5,1,5120100,'Alquiler','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(117,NULL,5120104,5,1,5120100,'AGUA AYSA','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(118,NULL,5120105,5,1,5120100,'TV Cablevision','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(119,NULL,5120106,5,1,5120100,'Caja Jubilacion Consejo','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(120,NULL,5120107,5,1,5120100,'Celulares','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(121,NULL,5120108,5,1,5120100,'Cheques','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(122,NULL,5120109,5,1,5120100,'Club la Nacion','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(123,NULL,5120110,5,1,5120100,'Comida','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(124,NULL,5120111,5,1,5120100,'Diario Clarin','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(125,NULL,5120112,5,1,5120100,'Digital Ocean','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(126,NULL,5120113,5,1,5120100,'Fletes y acarreos','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(127,NULL,5120114,5,1,5120100,'Luz Edesur','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(128,NULL,5120115,5,1,5120100,'Movilidad y Viáticos','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(129,NULL,5120116,5,1,5120100,'Mantenimiento','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (130,NULL,5120117,5,1,5120100,'IVA No Computable','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(131,NULL,5120118,5,1,5120100,'Entretenimiento','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(132,NULL,5120119,5,1,5120100,'Amortización Bienes de Uso','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(133,NULL,5120120,5,1,5120100,'Errepar','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(134,NULL,5120121,5,1,5120100,'Hosting Página Web To Webs','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(135,NULL,5120122,5,1,5120100,'Gastos varios','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(136,NULL,5120123,5,1,5120100,'Ajuste por redondeo','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(137,NULL,5120124,5,1,5120100,'Deudores Incobrables','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(138,NULL,5120125,5,1,5120100,'Faby Goncalves','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(139,NULL,5130100,4,1,5130000,'GASTOS FINANCIEROS','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(140,NULL,5130101,5,1,5130100,'Intereses y Gastos bancarios','Result. Negativo',NULL,NULL,1,2,0,0,1,1,NULL),(141,NULL,5130102,5,1,5130100,'Intereses Proveedores','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(142,NULL,5130103,5,1,5130100,'Damian Financiera','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(143,NULL,5130104,5,1,5130100,'Diferencias de cambio','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(144,NULL,5130105,5,1,5130100,'Diferencia de Cambio Bces. en M.Extranjera','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(145,NULL,5130106,5,1,5130100,'Diferencia tipo cambio Vendedor/Comprador','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(146,NULL,5130107,5,1,5130100,'Diferencia por conversion en Bce. en Mon. Extranj.','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(147,NULL,5130108,5,1,5130100,'Diferencia de cambio CMV','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(148,NULL,5130109,5,1,5130100,'Diferencia de cambio PT','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(149,NULL,5130110,5,1,5130100,'Resultado por Exposición a la Inflación','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(150,NULL,5130111,5,1,5130100,'Diferencia de cambio PE','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(151,NULL,5130112,5,1,5130100,'Diferencia de cambio Ds.Vtas.','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(152,NULL,5130113,5,1,5130100,'Diferencia de cambio ME','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(153,NULL,5130114,5,1,5130100,'Descuentos otorgados','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(154,NULL,5140100,4,1,5140000,'IMPUESTOS','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(155,NULL,5140101,5,1,5140100,'Impuesto a las Ganancias','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(156,NULL,5140164,5,1,5140100,'Impuesto a los Ingresos Brutos','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(157,NULL,5140102,5,1,5140100,'Impuesto al Debito y Credito Bancario','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(158,NULL,5200000,2,1,5000000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(159,NULL,5210101,5,1,5210100,'Pérdida por venta bienes de uso','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(160,NULL,5210102,5,1,5210100,'Inversiones','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(161,NULL,5210103,5,1,5210100,'Amortizaciones extraordinarias','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(162,NULL,1140103,5,1,1140100,'Retenciones SUSS','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(163,NULL,1110122,5,1,1110100,'Banco Patagonia Cta. Cte.','Activo',NULL,NULL,0,1,0,0,0,0,NULL),(164,NULL,1110106,5,1,1110100,'Banco HSBC','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(165,NULL,1110123,5,1,1110100,'Banco Ciudad Cta. Cte.','Activo',NULL,NULL,0,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (166,NULL,1110124,5,1,1110100,'Banco Nacion Cta. Cte.','Activo',NULL,NULL,0,1,0,0,0,0,NULL),(167,NULL,1110109,5,1,1110100,'Banco Galicia Vane','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(168,NULL,1110110,5,1,1110100,'Banco Frances Vane','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(169,NULL,1110111,5,1,1110100,'Banco Patagonia In Time SRL','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(170,NULL,1110112,5,1,1110100,'Banco Ciudad In Time SRL','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(171,NULL,1110113,5,1,1110100,'Banco Provincia In Time SRL','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(172,NULL,1110114,5,1,1110100,'Banco Macro PedimeOnline','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(173,NULL,1110115,5,1,1110100,'Banco Patagonia Problema Resuelto','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(174,NULL,1110116,5,1,1110100,'Banco Patagonia Graciela','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(175,NULL,1110117,5,1,1110100,'Banco Patagonia Omar','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(176,NULL,1110118,5,1,1110100,'Cheques','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(177,NULL,5120126,5,1,5120100,'Gisela Larzabal','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(178,NULL,5120127,5,1,5120100,'Google','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(179,NULL,5120128,5,1,5120100,'Seguro Moto','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(180,NULL,5120129,5,1,5120100,'Sueldo Agustina','Result. Negativo',NULL,NULL,0,1,0,0,0,0,NULL),(181,NULL,5120130,5,1,5120100,'Sueldo Betty','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(182,NULL,5120131,5,1,5120100,'Sueldo Elizabet','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(183,NULL,5120132,5,1,5120100,'Sueldo Florencia','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(184,NULL,5120133,5,1,5120100,'Sueldo Graciela','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(185,NULL,5120134,5,1,5120100,'Sueldo Franco Sanchez','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(186,NULL,5120135,5,1,5120100,'Sueldo Santiago Sanchez','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(187,NULL,5120136,5,1,5120100,'Sueldo Jose Luis','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(188,NULL,5120137,5,1,5120100,'Publicidad','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(189,NULL,5120138,5,1,5120100,'Las Nieves','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(190,NULL,5120139,5,1,5120100,'Sueldo Lidia','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(191,NULL,5120140,5,1,5120100,'Cargas Sociales','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(192,NULL,5120141,5,1,5120100,'Honorarios','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(193,8087,5120108,5,2,5120100,'Telefono Fijo,Luz,Gas','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(194,NULL,5120143,5,1,5120100,'ONE DRIVE','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(195,NULL,5120144,5,1,5120100,'OSDE','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(196,NULL,5120145,5,1,5120100,'SAS Constitucion','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(197,NULL,5120146,5,1,5120100,'Seguro de Vida Zurich','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(198,NULL,5120147,5,1,5120100,'Seguros','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(199,NULL,5120148,5,1,5120100,'Internet','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(200,NULL,5120149,5,1,5120100,'Seguro de Retiro Zurich','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(201,NULL,5140165,5,1,5140100,'Monotributo','Result. Negativo',NULL,NULL,1,2,0,0,1,1,NULL),(202,NULL,5140104,5,1,5140100,'IVA In Time SRL','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(203,NULL,5140105,5,1,5140100,'Autonomos','Result. Negativo',NULL,NULL,1,2,0,0,1,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (204,NULL,5140106,5,1,5140100,'Multas Impositivas','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(207,NULL,5120150,5,1,5120100,'Vanesa Gastos','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(208,NULL,5140166,5,1,5140100,'Impuesto a los Ingresos Brutos - BS AS','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(209,NULL,5140107,5,1,5140100,'SIRCREB','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(210,NULL,5140108,5,1,5140100,'Consejo Ciencias Economicas','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(211,NULL,5120152,5,1,5120100,'Albano Andres','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(212,NULL,5120153,5,1,5120100,'Tarjeta Visa','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(213,NULL,5120154,5,1,5120100,'Tarjeta American Express','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(214,8087,5120108,5,2,5120100,'Tarjeta empresa','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(215,NULL,5120156,5,1,5120100,'Imp. Municipales Sufrida','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(216,NULL,5120157,5,1,5120100,'Perc/Ret. Imp. Ganancias Sufrida','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(217,NULL,5120158,5,1,5120100,'Compras','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(218,NULL,4110106,5,2,4110100,'Ventas No Gravadas','Result. Positivo',1,NULL,1,2,0,0,0,1,NULL),(219,NULL,6110103,5,1,6110100,'Pagos AFIP','Movimiento',NULL,NULL,1,2,0,0,1,1,NULL),(220,NULL,5140167,5,1,5140100,'Perc IVA -RG3337 Sufrida','Result. Negativo',6,NULL,1,2,0,0,0,1,NULL),(221,NULL,5140109,5,1,5140100,'Imps. Internos Sufrida','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(222,NULL,5140110,5,1,5140100,'Imp. Gasoil Sufrida','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(223,NULL,5140111,5,1,5140100,'Imp. Hídricos Sufrida','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(224,NULL,5140112,5,1,5140100,'ITC Sufrida','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(225,NULL,5140113,5,1,5140100,'Perc IIBB  Buenos Aires Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(226,NULL,5140114,5,1,5140100,'Perc IIBB  Capital Federal Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(227,NULL,5140115,5,1,5140100,'Perc IIBB  Catamarca Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(228,NULL,5140116,5,1,5140100,'Perc IIBB  Chaco Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(229,NULL,5140117,5,1,5140100,'Perc IIBB  Chubut Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(230,NULL,5140118,5,1,5140100,'Perc IIBB  Córdoba Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(231,NULL,5140119,5,1,5140100,'Perc IIBB  Corrientes Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(232,NULL,5140120,5,1,5140100,'Perc IIBB  Entre Ríos Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(233,NULL,5140121,5,1,5140100,'Perc IIBB  Formosa Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(234,NULL,5140122,5,1,5140100,'Perc IIBB  Jujuy Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(235,NULL,5140123,5,1,5140100,'Perc IIBB  La Pampa Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(236,NULL,5140124,5,1,5140100,'Perc IIBB  La Rioja Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(237,NULL,5140125,5,1,5140100,'Perc IIBB  Mendoza Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(238,NULL,5140126,5,1,5140100,'Perc IIBB  Misiones Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(239,NULL,5140127,5,1,5140100,'Perc IIBB  Neuquén Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(240,NULL,5140128,5,1,5140100,'Perc IIBB  Pascua Lama Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(241,NULL,5140129,5,1,5140100,'Perc IIBB  Río Negro Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(242,NULL,5140130,5,1,5140100,'Perc IIBB  Salta Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(243,NULL,5140131,5,1,5140100,'Perc IIBB  San Juan Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(244,NULL,5140132,5,1,5140100,'Perc IIBB  San Luis Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (245,NULL,5140133,5,1,5140100,'Perc IIBB  Santa Cruz Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(246,NULL,5140134,5,1,5140100,'Perc IIBB  Santa Fe Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(247,NULL,5140135,5,1,5140100,'Perc IIBB  Santiago del Estero Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(248,NULL,5140136,5,1,5140100,'Perc IIBB  Tierra del Fuego Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(249,NULL,5140137,5,1,5140100,'Perc IIBB  Tucuman Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(250,NULL,5140138,5,1,5140100,'Compras No Gravadas','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(251,NULL,1140108,5,1,1140100,'Retenciones de IIBB Buenos Aires','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(252,NULL,1140109,5,1,1140100,'Retenciones de IIBB Capital Federal','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(253,NULL,1140110,5,1,1140100,'Retenciones de IIBB Catamarca','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(254,NULL,1140111,5,1,1140100,'Retenciones de IIBB Chaco','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(255,NULL,1140112,5,1,1140100,'Retenciones de IIBB Chubut','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(256,NULL,1140113,5,1,1140100,'Retenciones de IIBB Córdoba','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(257,NULL,1140114,5,1,1140100,'Retenciones de IIBB Corrientes','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(258,NULL,1140115,5,1,1140100,'Retenciones de IIBB Entre Ríos','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(259,NULL,1140116,5,1,1140100,'Retenciones de IIBB Formosa','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(260,NULL,1140117,5,1,1140100,'Retenciones de IIBB Jujuy','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(261,NULL,1140118,5,1,1140100,'Retenciones de IIBB La Pampa','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(262,NULL,1140119,5,1,1140100,'Retenciones de IIBB La Rioja','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(263,NULL,1140120,5,1,1140100,'Retenciones de IIBB Mendoza','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(264,NULL,1140121,5,1,1140100,'Retenciones de IIBB Misiones','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(265,NULL,1140122,5,1,1140100,'Retenciones de IIBB Neuquén','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(266,NULL,1140123,5,1,1140100,'Retenciones de IIBB Pascua Lama','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(267,NULL,1140124,5,1,1140100,'Retenciones de IIBB Río Negro','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(268,NULL,1140125,5,1,1140100,'Retenciones de IIBB Salta','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(269,NULL,1140126,5,1,1140100,'Retenciones de IIBB San Juan','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(270,NULL,1140127,5,1,1140100,'Retenciones de IIBB San Luis','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(271,NULL,1140128,5,1,1140100,'Retenciones de IIBB Santa Cruz','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(272,NULL,1140129,5,1,1140100,'Retenciones de IIBB Santa Fe','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(273,NULL,1140130,5,1,1140100,'Retenciones de IIBB Santiago del Estero','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(274,NULL,1140131,5,1,1140100,'Retenciones de IIBB Tierra del Fuego','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(275,NULL,1140132,5,1,1140100,'Retenciones de IIBB Tucuman','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(276,NULL,5140168,5,1,5140100,'SIRCREB Buenos Aires','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(277,NULL,5140139,5,1,5140100,'SIRCREB Capital Federal','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(278,NULL,5140140,5,1,5140100,'SIRCREB Catamarca','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(279,NULL,5140141,5,1,5140100,'SIRCREB Chaco','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(280,NULL,5140142,5,1,5140100,'SIRCREB Chubut','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(281,NULL,5140143,5,1,5140100,'SIRCREB Córdoba','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(282,NULL,5140144,5,1,5140100,'SIRCREB Corrientes','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(283,NULL,5140145,5,1,5140100,'SIRCREB Entre Ríos','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(284,NULL,5140146,5,1,5140100,'SIRCREB Formosa','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (285,NULL,5140147,5,1,5140100,'SIRCREB Jujuy','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(286,NULL,5140148,5,1,5140100,'SIRCREB La Pampa','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(287,NULL,5140149,5,1,5140100,'SIRCREB La Rioja','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(288,NULL,5140150,5,1,5140100,'SIRCREB Mendoza','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(289,NULL,5140151,5,1,5140100,'SIRCREB Misiones','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(290,NULL,5140152,5,1,5140100,'SIRCREB Neuquén','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(291,NULL,5140153,5,1,5140100,'SIRCREB Pascua Lama','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(292,NULL,5140154,5,1,5140100,'SIRCREB Río Negro','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(293,NULL,5140155,5,1,5140100,'SIRCREB Salta','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(294,NULL,5140156,5,1,5140100,'SIRCREB San Juan','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(295,NULL,5140157,5,1,5140100,'SIRCREB San Luis','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(296,NULL,5140158,5,1,5140100,'SIRCREB Santa Cruz','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(297,NULL,5140159,5,1,5140100,'SIRCREB Santa Fe','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(298,NULL,5140160,5,1,5140100,'SIRCREB Santiago del Estero','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(299,NULL,5140161,5,1,5140100,'SIRCREB Tierra del Fuego','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(300,NULL,5140162,5,1,5140100,'SIRCREB Tucuman','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(301,NULL,1140326,5,1,1140300,'IIBB a Favor Buenos Aires','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(302,NULL,1140302,5,1,1140300,'IIBB a Favor Capital Federal','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(303,NULL,1140303,5,1,1140300,'IIBB a Favor Catamarca','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(304,NULL,1140304,5,1,1140300,'IIBB a Favor Chaco','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(305,NULL,1140305,5,1,1140300,'IIBB a Favor Chubut','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(306,NULL,1140306,5,1,1140300,'IIBB a Favor Córdoba','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(307,NULL,1140307,5,1,1140300,'IIBB a Favor Corrientes','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(308,NULL,1140308,5,1,1140300,'IIBB a Favor Entre Ríos','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(309,NULL,1140309,5,1,1140300,'IIBB a Favor Formosa','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(310,NULL,1140310,5,1,1140300,'IIBB a Favor Jujuy','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(311,NULL,1140311,5,1,1140300,'IIBB a Favor La Pampa','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(312,NULL,1140312,5,1,1140300,'IIBB a Favor La Rioja','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(313,NULL,1140313,5,1,1140300,'IIBB a Favor Mendoza','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(314,NULL,1140314,5,1,1140300,'IIBB a Favor Misiones','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(315,NULL,1140315,5,1,1140300,'IIBB a Favor Neuquén','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(316,NULL,1140316,5,1,1140300,'IIBB a Favor Pascua Lama','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(317,NULL,1140317,5,1,1140300,'IIBB a Favor Río Negro','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(318,NULL,1140318,5,1,1140300,'IIBB a Favor Salta','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(319,NULL,1140319,5,1,1140300,'IIBB a Favor San Juan','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(320,NULL,1140320,5,1,1140300,'IIBB a Favor San Luis','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(321,NULL,1140321,5,1,1140300,'IIBB a Favor Santa Cruz','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(322,NULL,1140322,5,1,1140300,'IIBB a Favor Santa Fe','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(323,NULL,1140323,5,1,1140300,'IIBB a Favor Santiago del Estero','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(324,NULL,1140324,5,1,1140300,'IIBB a Favor Tierra del Fuego','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(325,NULL,1140325,5,1,1140300,'IIBB a Favor Tucuman','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(326,NULL,2110317,5,2,2110300,'IIBB a Pagar Buenos Aires','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (327,NULL,2110318,5,2,2110300,'IIBB a Pagar Capital Federal','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(328,NULL,2110319,5,2,2110300,'IIBB a Pagar Catamarca','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(329,NULL,2110320,5,2,2110300,'IIBB a Pagar Chaco','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(330,NULL,2110321,5,2,2110300,'IIBB a Pagar Chubut','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(331,NULL,2110322,5,2,2110300,'IIBB a Pagar Córdoba','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(332,NULL,2110323,5,2,2110300,'IIBB a Pagar Corrientes','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(333,NULL,2110324,5,2,2110300,'IIBB a Pagar Entre Ríos','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(334,NULL,2110325,5,2,2110300,'IIBB a Pagar Formosa','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(335,NULL,2110326,5,2,2110300,'IIBB a Pagar Jujuy','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(336,NULL,2110327,5,2,2110300,'IIBB a Pagar La Pampa','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(337,NULL,2110328,5,2,2110300,'IIBB a Pagar La Rioja','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(338,NULL,2110329,5,2,2110300,'IIBB a Pagar Mendoza','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(339,NULL,2110330,5,2,2110300,'IIBB a Pagar Misiones','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(340,NULL,2110331,5,2,2110300,'IIBB a Pagar Neuquén','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(341,NULL,2110332,5,2,2110300,'IIBB a Pagar Pascua Lama','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(342,NULL,2110333,5,2,2110300,'IIBB a Pagar Río Negro','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(343,NULL,2110334,5,2,2110300,'IIBB a Pagar Salta','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(344,NULL,2110335,5,2,2110300,'IIBB a Pagar San Juan','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(345,NULL,2110336,5,2,2110300,'IIBB a Pagar San Luis','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(346,NULL,2110337,5,2,2110300,'IIBB a Pagar Santa Cruz','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(347,NULL,2110338,5,2,2110300,'IIBB a Pagar Santa Fe','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(348,NULL,2110339,5,2,2110300,'IIBB a Pagar Santiago del Estero','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(349,NULL,2110340,5,2,2110300,'IIBB a Pagar Tierra del Fuego','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(350,NULL,2110341,5,2,2110300,'IIBB a Pagar Tucuman','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(351,NULL,6110101,5,1,6110100,'BANCO SIRCREB','Movimiento',NULL,NULL,1,2,0,0,1,1,NULL),(352,NULL,6110102,5,1,6110100,'Compensacion','Movimiento',NULL,NULL,1,2,0,0,0,1,NULL),(353,NULL,1140327,5,1,1140300,'IVA Saldo Tecnico','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(354,NULL,1140328,5,1,1140300,'IVA Saldo Libre Disponibilidad','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(355,NULL,6000000,1,1,0,'Movimiento','Movimiento',NULL,NULL,1,1,0,0,0,0,NULL),(356,NULL,6100000,2,1,6000000,'Movimiento','Movimiento',NULL,NULL,1,1,0,0,0,0,NULL),(357,NULL,6110000,3,1,6100000,'Movimiento','Movimiento',NULL,NULL,1,1,0,0,0,0,NULL),(358,NULL,4110000,3,2,4100000,'Ingresos Operativos','Result. Positivo',NULL,NULL,1,1,0,0,0,0,NULL),(359,NULL,1110120,5,1,1110100,'Caja en Pesos','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(360,NULL,1140211,5,1,1140200,'Retenciones Bancarias de Ganancias a Favor','Activo',3,NULL,1,2,0,0,1,1,NULL),(361,NULL,1220104,5,1,1220100,'Equipos de Computación','Activo',5,NULL,1,1,0,0,0,1,NULL),(362,NULL,1220105,5,1,1220100,'Computadoras','Activo',5,NULL,1,1,0,0,0,1,NULL),(363,NULL,1220304,5,1,1220300,'Muebles y Utiles','Activo',5,NULL,1,1,0,0,0,1,NULL),(364,NULL,2110105,5,2,2110100,'Anticipo de Clientes','Pasivo',NULL,NULL,1,2,0,0,1,1,NULL),(365,NULL,2110401,5,2,2110400,'Provision Honorarios','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(366,NULL,2110106,5,2,2110100,'Cta. Cte Directores','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(367,NULL,2110107,5,2,2110100,'Provisión Honorarios Directores','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(368,NULL,2110110,5,2,2110100,'Cuenta Particular Socio 1','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(369,NULL,3110104,5,2,3110100,'Capital','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(370,NULL,1120000,3,1,1100000,'INVERSIONES','Activo',NULL,NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (371,NULL,1160000,3,1,1100000,'OTROS ACTIVOS','Activo',5,NULL,1,1,0,0,0,0,NULL),(372,NULL,1160100,4,1,1160000,'OTROS','Activo',5,NULL,1,1,0,0,0,0,NULL),(373,NULL,2110400,4,2,2110000,'Provision de Honorarios','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(374,NULL,3410100,4,1,3410000,'RESULTADOS ACUMULADOS','Patrimonio Neto',NULL,NULL,1,1,0,0,0,0,NULL),(375,NULL,3420000,3,1,3400000,'GANACIAS RESERVADAS','Patrimonio Neto',NULL,NULL,1,1,0,0,0,0,NULL),(376,NULL,3420100,4,1,3420000,'Rerva Legal','Patrimonio Neto',NULL,NULL,1,1,0,0,0,0,NULL),(377,NULL,1220400,4,1,1220000,'INMUEBLES','Activo',5,NULL,1,1,0,0,0,0,NULL),(378,NULL,1220500,4,1,1220000,'RODADOS','Activo',5,NULL,1,1,0,0,0,0,NULL),(379,NULL,1220600,4,1,1220000,'MAQUINARIAS','Activo',5,NULL,1,1,0,0,0,0,NULL),(380,NULL,1220204,5,1,1220200,'Instalaciones','Activo',5,NULL,1,1,0,0,0,1,NULL),(381,NULL,3420101,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(382,NULL,3420102,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(383,NULL,3410105,5,2,3410100,'Resultado no asignado','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(384,NULL,1110121,5,1,1110100,'Caja en Dolares','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(385,NULL,1120100,4,1,1120000,'TEMPORARIAS','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(386,NULL,1120101,5,1,1120100,'PLAZO FIJO','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(387,NULL,1120200,4,1,1120000,'PERMANENTES','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(388,NULL,1120201,5,1,1120200,'ACCIONES','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(389,NULL,1220401,5,1,1220400,'Inmuebles','Activo',5,NULL,1,1,0,0,0,1,NULL),(390,NULL,1220501,5,1,1220500,'Vehiculos','Activo',5,NULL,1,1,0,0,0,1,NULL),(391,NULL,1220601,5,1,1220600,'Maquinarias','Activo',5,NULL,1,1,0,0,0,1,NULL),(392,NULL,1150401,5,1,1150400,'MERCADERIAS','Activo',5,NULL,1,1,0,0,0,1,NULL),(393,NULL,1160101,5,1,1160100,'OTROS','Activo',5,NULL,1,1,0,0,0,1,NULL),(394,NULL,1230100,4,1,1230000,'INTANGIBLES','Activo',5,NULL,1,1,0,0,0,0,NULL),(395,NULL,2110119,5,2,2110100,'Cuenta Particular Socio 2','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(396,NULL,5120160,5,1,5120100,'Comisiones Y gastos Bancarios','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(397,NULL,4110100,4,2,4110000,'Ingresos Operativos','Result. Positivo',NULL,NULL,1,1,0,0,0,0,NULL),(398,NULL,4120100,4,2,4120000,'OTROS INGRESOS','Result. Positivo',NULL,NULL,1,1,0,0,0,0,NULL),(399,NULL,5110000,3,1,5100000,'GASTOS ORDINARIOS','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(400,NULL,5120000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(401,NULL,5130000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(402,NULL,5140000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(403,NULL,5210000,3,1,5200000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(404,NULL,5210100,4,1,5210000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(405,NULL,6110100,4,1,6110000,'Movimiento','Movimiento',NULL,NULL,1,1,0,0,0,0,NULL),(406,NULL,1130100,4,1,1130000,'Operaciones Ordinarias','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(407,NULL,3110000,3,2,3100000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,NULL,1,1,0,0,0,0,NULL),(408,NULL,3410000,3,2,3400000,'RESULTADOS ANTERIORES','Patrimonio Neto',NULL,NULL,1,1,0,0,0,0,NULL),(409,NULL,5110101,5,2,5110000,'IVA Crédito Fiscal No computable','Result. Negativo',NULL,NULL,1,2,0,0,1,1,NULL),(410,NULL,1110203,5,1,1110200,'Banco ICBC Cta. Cte.','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(411,NULL,2110342,5,2,2110300,'Provisión Impuesto a las Ganancias','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(412,NULL,5120107,5,2,5120000,'Amortización Muebles y Útiles','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(413,NULL,5120102,5,2,5120000,'Amortización Equipos','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(414,NULL,1220109,5,1,1220100,'Amortizacion Acumulada Equipos','Activo',5,NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (415,NULL,1220602,5,1,1220600,'Amortización Acumulada Maquinarias','Activo',5,NULL,1,1,0,0,0,1,NULL),(416,NULL,1160102,5,1,1160100,'Materias Primas','Activo',5,NULL,1,1,0,0,0,1,NULL),(417,NULL,1110204,5,1,1110200,'Banco Itaú Cta. Cte.','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(418,NULL,2110113,5,2,2110100,'Deudas Bancarias','Pasivo',NULL,NULL,1,2,0,1,1,1,NULL),(419,NULL,1220502,5,1,1220500,'Rodados','Activo',5,NULL,1,1,0,0,0,1,NULL),(420,NULL,1220503,5,1,1220500,'Amortización Acumulada Rodados','Activo',5,NULL,1,1,0,0,0,1,NULL),(421,NULL,5120105,5,2,5120000,'Amortización Rodados','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(422,NULL,5120109,5,2,5120000,'Amortización Maquinarias','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(423,NULL,1220504,5,1,1220500,'Accesorios','Activo',5,NULL,1,1,0,0,0,1,NULL),(424,NULL,1220505,5,1,1220500,'Amortización Acumulada Accesorios','Activo',5,NULL,1,1,0,0,0,1,NULL),(425,NULL,1110205,5,1,1110200,'Banco Galicia Cta. Cte.','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(426,NULL,3420101,5,2,3420000,'Reserva Facultativa','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(427,NULL,1140212,5,1,1140200,'Créditos por Impuestos Diferidos','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(428,NULL,1160103,5,1,1160100,'Fondo de Comercio','Activo',5,NULL,1,1,0,0,0,1,NULL),(429,NULL,1160104,5,1,1160100,'Amortizacion Acumulada Fondo de Comercio','Activo',5,NULL,1,1,0,0,0,1,NULL),(430,NULL,1140213,5,1,1140200,'Intereses a devengar AGIP','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(431,NULL,2110343,5,2,2110300,'PFP IIBB','Pasivo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(432,NULL,1140330,5,1,1140300,'Pago a Cuenta ITC','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(433,NULL,2110114,5,2,2110100,'Préstamo','Pasivo',NULL,NULL,1,2,0,1,1,1,NULL),(434,NULL,1160106,5,1,1160100,'Productos','Activo',5,NULL,1,1,0,0,0,1,NULL),(435,NULL,2110345,5,2,2110300,'Intereses a devengar PFP','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(436,NULL,1110206,5,1,1110200,'Banco Provincia Cta. Cte.','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(437,NULL,1140215,5,1,1140200,'Imp. Ley 25413 Cred 0.6%','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(438,NULL,2110402,5,2,2110400,'Honorarios Directorio a Pagar','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(439,NULL,3110101,5,2,3110100,'Reserva para Futuras Inversiones','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(440,NULL,1130106,5,1,1130100,'TEAC - Trabajos Ejecutados a Certificar','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(441,NULL,2110115,5,2,2110100,'Leasing','Pasivo',NULL,NULL,1,2,0,1,1,1,NULL),(442,NULL,1110207,5,1,1110200,'Banco Comafi Cta. Cte','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(443,NULL,2110500,4,2,2110000,'Deudas Financieras','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(444,NULL,2110501,5,2,2110500,'Banco Santander Rio Cta Cte','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(446,NULL,2210000,3,2,2200000,'Deudas','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(447,NULL,2210100,4,2,2210000,'Otras Deudas','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(448,NULL,2210101,5,2,2210100,'Planes de Pagos AFIP','Pasivo',NULL,NULL,1,2,0,1,1,1,NULL),(449,NULL,2110502,5,2,2110500,'Leasing','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(450,NULL,6110101,5,1,6110000,'Cheques Rechazados','Movimiento',NULL,NULL,1,2,0,0,1,1,NULL),(451,NULL,1110208,5,1,1110200,'Banco Patagonia Taxes Software','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(452,NULL,1110209,5,1,1110200,'Banco Macro Cta. Cte.','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(453,NULL,1120202,5,1,1120200,'Inversión Central Caribe','Activo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(454,NULL,1120102,5,1,1120100,'Otras Inversiones','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(455,NULL,1140216,5,1,1140200,'Otros Créditos','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(456,NULL,2110403,5,2,2110400,'Provisión Honorarios Socio Gerente','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(457,NULL,1110210,5,1,1110200,'Cheque Diferido Banco Santander Rio','Activo',NULL,NULL,1,2,1,1,1,0,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (458,NULL,1110211,5,1,1110200,'Cheque Diferido Banco Macro','Activo',NULL,NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(459,NULL,2110204,5,2,2110200,'Moratoria SUSS a pagar','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(460,NULL,2110344,5,2,2110300,'Impuestos Municipales a Pagar','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(461,NULL,5110103,5,2,5110000,'Amortización Instalaciones','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(462,NULL,5120110,5,2,5120000,'Amortización Equipos de comput.','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(463,NULL,2110118,5,2,2110100,'Cuenta Particular Socio 3','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(464,NULL,2110120,5,2,2110100,'Cuenta Particular Socio 4','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(465,NULL,3110102,5,2,3110100,'Otras Reservas','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(466,NULL,1140331,5,1,1140300,'IGMP (Saldo a Favor)','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(467,NULL,5110104,5,2,5110000,'Interés','Result. Negativo',NULL,NULL,1,2,0,0,1,1,NULL),(468,NULL,1150402,5,1,1150400,'Productos en Proceso','Activo',5,NULL,1,1,0,0,0,1,NULL),(469,NULL,2110205,5,2,2110200,'Depósitos en Garantía Socio Gerente','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(470,NULL,2110346,5,2,2110300,'Fondos Embargados','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(471,NULL,2110347,5,2,2110300,'Cuota Solid.','Pasivo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(472,NULL,1140332,5,1,1140300,'Anticipo Honorarios Directores','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(473,NULL,2110348,5,2,2110300,'SICORE a Pagar','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(474,NULL,1110212,5,1,1110200,'Banco Credicoop Cta. Cte.','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(475,NULL,1110213,5,1,1110200,'Banco Superville Cta. Cte.','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(476,NULL,5110105,5,2,5110000,'RECPAM','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(477,NULL,1110125,5,1,1110100,'Caja Reales','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(478,NULL,5140169,5,1,5140100,'CO2 - Imp. Al Carbono Sufrida','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(479,NULL,1140300,4,1,1140000,'Anticipo de Impuestos','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(480,NULL,2110600,4,2,2110000,'Retenciones Efectuadas','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(481,NULL,4200000,2,2,4000000,'INGRESOS EXTRAORDINARIOS','Result. Positivo',NULL,NULL,1,1,0,0,0,0,NULL),(482,8087,1230104,5,1,1230100,'Socio Cta Particular Rios A.D.','Activo',5,NULL,1,1,1,1,1,0,NULL),(483,8087,1230105,5,1,1230100,'Socio Cta Particular Rios D.','Activo',5,NULL,1,1,1,1,1,0,NULL),(484,8087,5120108,5,2,5120100,'Comidas','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(485,8087,5120108,5,2,5120100,'Papeleria y Libreria','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(486,8087,2110121,5,2,2110100,'Honorarios a pagar','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(487,8087,2110351,5,2,2110300,'Anticipo Ganancias a pagar','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(488,8087,5130101,5,2,5130100,'Intereses','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(489,8087,1140133,5,1,1140100,'Retencion IIBB Amepba','Activo',NULL,NULL,1,1,1,0,0,1,NULL),(490,8087,5140101,5,2,5140100,'Impuesto Bs. Personales','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(491,8087,2110353,5,2,2110300,'Impuesto Bs. Personales a pagar','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(492,8087,2110355,5,2,2110300,'Impuesto a los Ingresos Brutos a pagar PBA','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(493,8087,5120108,5,2,5120100,'Costo mercadería vendida','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(494,8087,1140134,5,1,1140100,'Percepcion IVA','Activo',NULL,NULL,1,1,1,0,0,1,NULL),(495,8087,1140135,5,1,1140100,'Percepcion Ingr. Brutos CF','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(496,8087,1140136,5,1,1140100,'Percepcion Ing. Brutos Ba As','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(497,8087,1140333,5,1,1140300,'Imp Ing Brutos Saldo a favor','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(498,8087,4120101,5,1,4120100,'Otros Ingresos','Result. Positivo',NULL,NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (499,8087,1140334,5,1,1140300,'IVA Saldo a favor','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(500,8087,1140223,5,1,1140200,'Anticipo sueldo','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(1001,NULL,5140170,5,1,5140100,'SIRTAC Córdoba','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1002,NULL,5140171,5,1,5140100,'SIRTAC Corrientes','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1003,NULL,5140172,5,1,5140100,'SIRTAC Chaco','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1004,NULL,5140173,5,1,5140100,'SIRTAC Chubut','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1005,NULL,5140174,5,1,5140100,'SIRTAC Entre Ríos','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1006,NULL,5140175,5,1,5140100,'SIRTAC Formosa','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1007,NULL,5140176,5,1,5140100,'SIRTAC Jujuy','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1008,NULL,5140177,5,1,5140100,'SIRTAC La Pampa','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1009,NULL,5140178,5,1,5140100,'SIRTAC La Rioja','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1010,NULL,5140179,5,1,5140100,'SIRTAC Mendoza','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1011,NULL,5140180,5,1,5140100,'SIRTAC Misiones','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1012,NULL,5140181,5,1,5140100,'SIRTAC Neuquén','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1013,NULL,5140182,5,1,5140100,'SIRTAC Río Negro','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1014,NULL,5140183,5,1,5140100,'SIRTAC Salta','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1015,NULL,5140184,5,1,5140100,'SIRTAC San Juan','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1016,NULL,5140185,5,1,5140100,'SIRTAC San Luis','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1017,NULL,5140186,5,1,5140100,'SIRTAC Santa Cruz','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1018,NULL,5140187,5,1,5140100,'SIRTAC Santa Fe','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1019,NULL,5140188,5,1,5140100,'SIRTAC Santiago del Estero','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1020,NULL,5140189,5,1,5140100,'SIRTAC Tierra del Fuego','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1021,NULL,5140190,5,1,5140100,'SIRTAC Tucuman','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1022,NULL,5140191,5,1,5140100,'SIRTAC Capital Federal','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1023,NULL,5140192,5,1,5140100,'SIRTAC Buenos Aires','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1024,NULL,5140193,5,1,5140100,'SIRTAC Catamarca','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1025,NULL,5140194,5,1,5140100,'SIRTAC Pascua Lama','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1026,NULL,6110104,5,1,6110100,'BANCO SIRTAC','Movimiento',NULL,NULL,1,2,0,0,1,1,NULL),(1400,NULL,5140267,5,1,5140100,'Perc IVA -RG3337 Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1401,NULL,5140209,5,1,5140100,'Imps. Internos Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1402,NULL,5140210,5,1,5140100,'Imp. Gasoil Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1403,NULL,5140211,5,1,5140100,'Imp. Hídricos Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1404,NULL,5140212,5,1,5140100,'ITC Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1405,NULL,5140213,5,1,5140100,'Perc IIBB  Buenos Aires Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1406,NULL,5140214,5,1,5140100,'Perc IIBB  Capital Federal Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1407,NULL,5140215,5,1,5140100,'Perc IIBB  Catamarca Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1408,NULL,5140216,5,1,5140100,'Perc IIBB  Chaco Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1409,NULL,5140217,5,1,5140100,'Perc IIBB  Chubut Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1410,NULL,5140218,5,1,5140100,'Perc IIBB  Córdoba Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1411,NULL,5140219,5,1,5140100,'Perc IIBB  Corrientes Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (1412,NULL,5140220,5,1,5140100,'Perc IIBB  Entre Ríos Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1413,NULL,5140221,5,1,5140100,'Perc IIBB  Formosa Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1414,NULL,5140222,5,1,5140100,'Perc IIBB  Jujuy Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1415,NULL,5140223,5,1,5140100,'Perc IIBB  La Pampa Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1416,NULL,5140224,5,1,5140100,'Perc IIBB  La Rioja Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1417,NULL,5140225,5,1,5140100,'Perc IIBB  Mendoza Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1418,NULL,5140226,5,1,5140100,'Perc IIBB  Misiones Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1419,NULL,5140227,5,1,5140100,'Perc IIBB  Neuquén Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1420,NULL,5140228,5,1,5140100,'Perc IIBB  Pascua Lama Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1421,NULL,5140229,5,1,5140100,'Perc IIBB  Río Negro Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1422,NULL,5140230,5,1,5140100,'Perc IIBB  Salta Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1423,NULL,5140231,5,1,5140100,'Perc IIBB  San Juan Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1424,NULL,5140232,5,1,5140100,'Perc IIBB  San Luis Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1425,NULL,5140233,5,1,5140100,'Perc IIBB  Santa Cruz Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1426,NULL,5140234,5,1,5140100,'Perc IIBB  Santa Fe Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1427,NULL,5140235,5,1,5140100,'Perc IIBB  Santiago del Estero Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1428,NULL,5140236,5,1,5140100,'Perc IIBB  Tierra del Fuego Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1429,NULL,5140237,5,1,5140100,'Perc IIBB  Tucuman Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1430,NULL,5140269,5,1,5140100,'CO2 - Imp. Al Carbono Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1431,NULL,5120256,5,1,5120100,'Imp. Municipales Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1432,NULL,5120257,5,1,5120100,'Perc/Ret. Imp. Ganancias Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL);
/*!40000 ALTER TABLE `conta_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_asientos`
--

DROP TABLE IF EXISTS `conta_tipo_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_asientos`
--

LOCK TABLES `conta_tipo_asientos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_asientos` DISABLE KEYS */;
INSERT INTO `conta_tipo_asientos` VALUES (1,'Sueldos',NULL,NULL,NULL,11),(2,'Ingresos',NULL,NULL,NULL,9),(3,'Egresos',NULL,NULL,NULL,10),(4,'Amortizaciones',NULL,NULL,NULL,4),(5,'Banco',NULL,NULL,NULL,15),(6,'Ganancias',NULL,NULL,NULL,12),(7,'Retenciones',NULL,NULL,NULL,13),(8,'SIRCREB',NULL,NULL,NULL,14),(9,'Compensaciones',NULL,NULL,NULL,16),(10,'Pagos AFIP',NULL,NULL,NULL,17),(11,'Ajustes',NULL,NULL,NULL,3),(12,'Saldos Iniciales',NULL,NULL,NULL,1),(13,'Cancelacion de Iniciales',NULL,NULL,NULL,2),(14,'Patrimonio Neto',NULL,NULL,NULL,8),(15,'Liquidaciones IVA',NULL,NULL,NULL,18),(16,'Liquidacion IIBB',NULL,NULL,NULL,19),(17,'Asientos de Cierre',NULL,NULL,NULL,5),(18,'Reclasificacion',NULL,NULL,NULL,6),(19,'Otros',NULL,NULL,NULL,7),(20,'Cobranzas','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(21,'Pagos','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(22,'Tesoreria','2019-10-19 02:10:24','2019-10-19 02:10:24',NULL,NULL),(23,'Ajuste por Inflacion','2020-03-01 06:39:20','2020-03-01 06:39:20',NULL,NULL),(24,'SIRTAC','2023-10-16 21:16:10','2023-10-16 21:16:10',NULL,20),(25,'Compensaciones Compras',NULL,NULL,NULL,NULL),(26,'Compensaciones Ventas',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_cuentas`
--

DROP TABLE IF EXISTS `conta_tipo_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_cuentas`
--

LOCK TABLES `conta_tipo_cuentas` WRITE;
/*!40000 ALTER TABLE `conta_tipo_cuentas` DISABLE KEYS */;
INSERT INTO `conta_tipo_cuentas` VALUES (1,'Rubro',NULL,NULL,NULL),(2,'SubRubro',NULL,NULL,NULL),(3,'Grupo',NULL,NULL,NULL),(4,'SubGrupo',NULL,NULL,NULL),(5,'Cuenta',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_saldos`
--

DROP TABLE IF EXISTS `conta_tipo_saldos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_saldos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `saldo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_saldos`
--

LOCK TABLES `conta_tipo_saldos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_saldos` DISABLE KEYS */;
INSERT INTO `conta_tipo_saldos` VALUES (1,'Deudor',NULL,NULL,NULL),(2,'Acreedor',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_saldos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_cuits_afip`
--

DROP TABLE IF EXISTS `control_cuits_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_cuits_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `control_cuits_afip_person_id_foreign` (`person_id`),
  CONSTRAINT `control_cuits_afip_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_cuits_afip`
--

LOCK TABLES `control_cuits_afip` WRITE;
/*!40000 ALTER TABLE `control_cuits_afip` DISABLE KEYS */;
/*!40000 ALTER TABLE `control_cuits_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_general`
--

DROP TABLE IF EXISTS `control_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_general` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `control_general_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_general`
--

LOCK TABLES `control_general` WRITE;
/*!40000 ALTER TABLE `control_general` DISABLE KEYS */;
INSERT INTO `control_general` VALUES (1,'Ingresos - Egresos - Resultado',1,'Proyeccion Ganancias','control_general/proyecGanancias',NULL,NULL),(2,'IVA',2,'IVA','control_general/iva',NULL,NULL),(3,'IIBB',3,'IIBB','control_general/iibb',NULL,NULL),(4,'Por Mes',4,'Vto. Impuestos','control_general/vto',NULL,NULL),(5,'Por Impuesto',4,'Vto. Impuestos','control_general/vtoPorImpuestos',NULL,NULL);
/*!40000 ALTER TABLE `control_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpc_nivel_1`
--

DROP TABLE IF EXISTS `cpc_nivel_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpc_nivel_1` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cpc_nivel_1_person_id_foreign` (`person_id`),
  CONSTRAINT `cpc_nivel_1_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpc_nivel_1`
--

LOCK TABLES `cpc_nivel_1` WRITE;
/*!40000 ALTER TABLE `cpc_nivel_1` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpc_nivel_1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpc_nivel_2`
--

DROP TABLE IF EXISTS `cpc_nivel_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpc_nivel_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cpc_nivel_1_id` bigint(20) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cpc_nivel_2_person_id_foreign` (`person_id`),
  KEY `cpc_nivel_2_cpc_nivel_1_id_foreign` (`cpc_nivel_1_id`),
  CONSTRAINT `cpc_nivel_2_cpc_nivel_1_id_foreign` FOREIGN KEY (`cpc_nivel_1_id`) REFERENCES `cpc_nivel_1` (`id`),
  CONSTRAINT `cpc_nivel_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpc_nivel_2`
--

LOCK TABLES `cpc_nivel_2` WRITE;
/*!40000 ALTER TABLE `cpc_nivel_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpc_nivel_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpc_nivel_2_details`
--

DROP TABLE IF EXISTS `cpc_nivel_2_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpc_nivel_2_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cpc_nivel_2_id` bigint(20) unsigned NOT NULL,
  `cuenta_contable_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cpc_nivel_2_details_person_id_foreign` (`person_id`),
  KEY `cpc_nivel_2_details_cpc_nivel_2_id_foreign` (`cpc_nivel_2_id`),
  KEY `cpc_nivel_2_details_cuenta_contable_id_foreign` (`cuenta_contable_id`),
  CONSTRAINT `cpc_nivel_2_details_cpc_nivel_2_id_foreign` FOREIGN KEY (`cpc_nivel_2_id`) REFERENCES `cpc_nivel_2` (`id`),
  CONSTRAINT `cpc_nivel_2_details_cuenta_contable_id_foreign` FOREIGN KEY (`cuenta_contable_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cpc_nivel_2_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpc_nivel_2_details`
--

LOCK TABLES `cpc_nivel_2_details` WRITE;
/*!40000 ALTER TABLE `cpc_nivel_2_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpc_nivel_2_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpcuenta_types_tc`
--

DROP TABLE IF EXISTS `cpcuenta_types_tc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpcuenta_types_tc` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpcuenta_types_tc`
--

LOCK TABLES `cpcuenta_types_tc` WRITE;
/*!40000 ALTER TABLE `cpcuenta_types_tc` DISABLE KEYS */;
INSERT INTO `cpcuenta_types_tc` VALUES (1,NULL,'Ingresos No Gravados',1,NULL,NULL,NULL),(2,NULL,'Sueldos',1,NULL,NULL,NULL),(3,NULL,'Retenciones de Ganancias',1,NULL,NULL,NULL),(4,NULL,'Anticipos de Ganancias',1,NULL,NULL,NULL),(5,NULL,'Bienes Activados',1,NULL,NULL,NULL),(6,NULL,'Percepciones de IVA',1,NULL,NULL,NULL),(7,NULL,'Percepciones de IIBB',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cpcuenta_types_tc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente`
--

DROP TABLE IF EXISTS `cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `is_no_fiscal` tinyint(1) DEFAULT '0',
  `user_id_que_firma` int(10) unsigned DEFAULT NULL,
  `numero` bigint(20) DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `compensado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_cliente_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_cliente_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente`
--

LOCK TABLES `cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_details`
--

DROP TABLE IF EXISTS `cta_cte_cliente_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_details_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_cliente_details_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_details_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_details_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_details_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_details`
--

LOCK TABLES `cta_cte_cliente_details` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_pivot_receipt`
--

DROP TABLE IF EXISTS `cta_cte_cliente_pivot_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_pivot_receipt` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `receipt_id` int(11) DEFAULT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `is_a_cuenta` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `cccpr_a_cuenta_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_cccpr_a_cuenta_id` (`cccpr_a_cuenta_id`),
  CONSTRAINT `fk_cccpr_a_cuenta_id` FOREIGN KEY (`cccpr_a_cuenta_id`) REFERENCES `cta_cte_cliente_pivot_receipt` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_pivot_receipt`
--

LOCK TABLES `cta_cte_cliente_pivot_receipt` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bind_apibank_movement_id` bigint(20) unsigned DEFAULT NULL COMMENT 'FK soft a bind_apibank_movements (movimiento que originó este registro)',
  `bind_apibank_transfer_id` bigint(20) unsigned DEFAULT NULL COMMENT 'FK soft a bind_apibank_transfers (transferencia que originó este registro)',
  `bind_sync_status` enum('pending','synced','error') COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Estado de sincronización: pending=pendiente, synced=sincronizado, error=error al sincronizar',
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `ticket_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `cta_cte_tesoreria_moneda_id_foreign` (`moneda_id`),
  KEY `cta_cte_tesoreria_ticket_id_foreign` (`ticket_id`),
  KEY `idx_cct_bind_apibank_mov` (`bind_apibank_movement_id`),
  KEY `idx_cct_bind_apibank_trf` (`bind_apibank_transfer_id`),
  KEY `idx_cct_bind_sync_status` (`bind_sync_status`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `cta_cte_tesoreria_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_ticket_id_foreign` FOREIGN KEY (`ticket_id`) REFERENCES `tickets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria`
--

LOCK TABLES `cta_cte_tesoreria` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_cheq`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_cheq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_cheq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `chequera_tipo_id` int(10) unsigned NOT NULL,
  `serie` text COLLATE utf8mb4_unicode_ci,
  `numero_cheque` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_cheq_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` (`cta_cte_tesoreria_banco_id`),
  KEY `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` (`chequera_tipo_id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` FOREIGN KEY (`chequera_tipo_id`) REFERENCES `chequeras_tipos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_cheq`
--

LOCK TABLES `cta_cte_tesoreria_banco_cheq` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_claves`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `descripcion_name` text COLLATE utf8mb4_unicode_ci,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_claves_person_id_foreign` (`person_id`),
  KEY `ct_cuenta_id` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ct_banco_id` (`cta_cte_tesoreria_banco_id`),
  CONSTRAINT `ct_banco_id` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `ct_cuenta_id` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_claves_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_claves`
--

LOCK TABLES `cta_cte_tesoreria_banco_claves` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_claves` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_comentarios`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_comentarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_comentarios` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `fecha` datetime NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_comentarios_person_id_foreign` (`person_id`),
  KEY `ct_cuentas_id` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ct_bancos_id` (`cta_cte_tesoreria_banco_id`),
  CONSTRAINT `ct_bancos_id` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `ct_cuentas_id` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_comentarios_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_comentarios`
--

LOCK TABLES `cta_cte_tesoreria_banco_comentarios` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_comentarios` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_comentarios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_estados`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_estados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_estados` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_estados`
--

LOCK TABLES `cta_cte_tesoreria_banco_estados` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_estados` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_banco_estados` VALUES (1,NULL,'Habilitado',0,NULL,NULL,NULL),(2,NULL,'En Proceso',0,NULL,NULL,NULL),(3,NULL,'Bloqueado',0,NULL,NULL,NULL),(4,NULL,'Reconocimiento',0,NULL,NULL,NULL),(5,NULL,'Inhabilitado',0,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_estados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_bancos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `ctacte_banco_id` int(10) unsigned NOT NULL,
  `persona_empresa` int(11) NOT NULL DEFAULT '1',
  `zone_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id_diferido` int(10) unsigned DEFAULT NULL,
  `cuenta_contable_id_pend_acred` int(10) unsigned DEFAULT NULL,
  `numero_cuenta` text COLLATE utf8mb4_unicode_ci,
  `cbu` text COLLATE utf8mb4_unicode_ci,
  `alias` text COLLATE utf8mb4_unicode_ci,
  `cta_cte_tesoreria_banco_estado_id` int(10) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_bancos_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` (`ctacte_banco_id`),
  KEY `cta_cte_tesoreria_bancos_zone_id_foreign` (`zone_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` (`cuenta_contable_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` (`cuenta_contable_id_diferido`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` (`cuenta_contable_id_pend_acred`),
  KEY `cta_cte_tesoreria_bancos_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `ct_banco_estado_id` (`cta_cte_tesoreria_banco_estado_id`),
  CONSTRAINT `ct_banco_estado_id` FOREIGN KEY (`cta_cte_tesoreria_banco_estado_id`) REFERENCES `cta_cte_tesoreria_banco_estados` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` FOREIGN KEY (`ctacte_banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` FOREIGN KEY (`cuenta_contable_id_diferido`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` FOREIGN KEY (`cuenta_contable_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` FOREIGN KEY (`cuenta_contable_id_pend_acred`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_bancos`
--

LOCK TABLES `cta_cte_tesoreria_bancos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuenta_tipos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuenta_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuenta_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuenta_tipos`
--

LOCK TABLES `cta_cte_tesoreria_cuenta_tipos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuenta_tipos` VALUES (1,NULL,'CAJA',1,NULL,NULL,NULL),(2,NULL,'BANCOS',1,NULL,NULL,NULL),(3,NULL,'CHEQUES',1,NULL,NULL,NULL),(4,NULL,'RETENCIONES EFECTUADAS',1,NULL,'2024-05-26 20:59:32',NULL),(5,NULL,'PERCEPCIONES EFECTUADAS',1,NULL,'2024-05-26 20:59:32',NULL),(6,NULL,'RESULTADO NEGATIVO',1,NULL,NULL,NULL),(7,NULL,'RESULTADO POSITIVO',1,NULL,NULL,NULL),(8,NULL,'MOVIMIENTO',1,NULL,NULL,NULL),(9,NULL,'RETENCIONES SUFRIDAS',1,NULL,NULL,NULL),(10,NULL,'PERCEPCIONES SUFRIDAS',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuentas`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bind_apibank_enabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Tiene Bind APIBank habilitado?',
  `bind_account_id` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'ID de cuenta en Bind APIBank (obtenido al configurar)',
  `user_id` int(10) unsigned DEFAULT NULL,
  `is_no_fiscal` tinyint(1) DEFAULT '0',
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_tipo_id` int(10) unsigned NOT NULL DEFAULT '8',
  `retention_type_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cuit` text COLLATE utf8mb4_unicode_ci,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_cuentas_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `cta_tes_tipo_id_foreign` (`cta_cte_tesoreria_cuenta_tipo_id`),
  KEY `cta_cte_tesoreria_cuentas_moneda_id_foreign` (`moneda_id`),
  KEY `cta_cte_tesoreria_cuentas_retention_type_id_foreign` (`retention_type_id`),
  KEY `idx_cctc_bind_apibank_enabled` (`bind_apibank_enabled`),
  KEY `idx_cctc_bind_account_id` (`bind_account_id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_retention_type_id_foreign` FOREIGN KEY (`retention_type_id`) REFERENCES `retention_types` (`id`),
  CONSTRAINT `cta_tes_tipo_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_tipo_id`) REFERENCES `cta_cte_tesoreria_cuenta_tipos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=757 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuentas`
--

LOCK TABLES `cta_cte_tesoreria_cuentas` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (13,0,NULL,NULL,0,1,13,NULL,8,NULL,'Clientes - Deudores',NULL,0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(20,0,NULL,NULL,0,1,20,NULL,8,NULL,'Anticipos Impuesto a las Ganancias',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(23,0,NULL,NULL,0,1,23,NULL,4,NULL,'Retenciones Impuesto a las Ganancias',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(25,0,NULL,NULL,0,1,25,NULL,4,NULL,'Retenciones de IVA',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(57,0,NULL,NULL,0,1,57,NULL,8,NULL,'Proveedores en Cta. Cte. locales',NULL,0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(60,0,NULL,NULL,0,1,60,NULL,3,NULL,'Cheques emitidos ',NULL,0,1,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(62,0,NULL,NULL,0,1,62,NULL,8,NULL,'Sueldos y Jornales a pagar',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(140,0,NULL,NULL,0,1,140,NULL,6,NULL,'Intereses y Gastos bancarios',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(162,0,NULL,NULL,0,1,162,NULL,4,NULL,'Retenciones SUSS',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(176,0,NULL,NULL,0,1,176,NULL,3,NULL,'Cheques en Cartera',NULL,1,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(201,0,NULL,NULL,0,1,201,NULL,6,NULL,'Monotributo',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(203,0,NULL,NULL,0,1,203,NULL,6,NULL,'Autonomos',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(219,0,NULL,NULL,0,1,219,NULL,8,NULL,'Pagos AFIP',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(251,0,NULL,NULL,0,1,251,NULL,4,NULL,'Retenciones de IIBB Buenos Aires',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(252,0,NULL,NULL,0,1,252,NULL,4,NULL,'Retenciones de IIBB Capital Federal',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(253,0,NULL,NULL,0,1,253,NULL,4,NULL,'Retenciones de IIBB Catamarca',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(254,0,NULL,NULL,0,1,254,NULL,4,NULL,'Retenciones de IIBB Chaco',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(255,0,NULL,NULL,0,1,255,NULL,4,NULL,'Retenciones de IIBB Chubut',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(256,0,NULL,NULL,0,1,256,NULL,4,NULL,'Retenciones de IIBB Córdoba',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(257,0,NULL,NULL,0,1,257,NULL,4,NULL,'Retenciones de IIBB Corrientes',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(258,0,NULL,NULL,0,1,258,NULL,4,NULL,'Retenciones de IIBB Entre Ríos',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(259,0,NULL,NULL,0,1,259,NULL,4,NULL,'Retenciones de IIBB Formosa',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(260,0,NULL,NULL,0,1,260,NULL,4,NULL,'Retenciones de IIBB Jujuy',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(261,0,NULL,NULL,0,1,261,NULL,4,NULL,'Retenciones de IIBB La Pampa',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(262,0,NULL,NULL,0,1,262,NULL,4,NULL,'Retenciones de IIBB La Rioja',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(263,0,NULL,NULL,0,1,263,NULL,4,NULL,'Retenciones de IIBB Mendoza',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(264,0,NULL,NULL,0,1,264,NULL,4,NULL,'Retenciones de IIBB Misiones',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(265,0,NULL,NULL,0,1,265,NULL,4,NULL,'Retenciones de IIBB Neuquén',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(266,0,NULL,NULL,0,1,266,NULL,4,NULL,'Retenciones de IIBB Pascua Lama',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (267,0,NULL,NULL,0,1,267,NULL,4,NULL,'Retenciones de IIBB Río Negro',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(268,0,NULL,NULL,0,1,268,NULL,4,NULL,'Retenciones de IIBB Salta',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(269,0,NULL,NULL,0,1,269,NULL,4,NULL,'Retenciones de IIBB San Juan',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(270,0,NULL,NULL,0,1,270,NULL,4,NULL,'Retenciones de IIBB San Luis',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(271,0,NULL,NULL,0,1,271,NULL,4,NULL,'Retenciones de IIBB Santa Cruz',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(272,0,NULL,NULL,0,1,272,NULL,4,NULL,'Retenciones de IIBB Santa Fe',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(273,0,NULL,NULL,0,1,273,NULL,4,NULL,'Retenciones de IIBB Santiago del Estero',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(274,0,NULL,NULL,0,1,274,NULL,4,NULL,'Retenciones de IIBB Tierra del Fuego',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(275,0,NULL,NULL,0,1,275,NULL,4,NULL,'Retenciones de IIBB Tucuman',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(351,0,NULL,NULL,0,1,351,NULL,8,NULL,'BANCO SIRCREB',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(359,0,NULL,NULL,0,1,359,NULL,8,NULL,'Caja en Pesos',NULL,0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:16:03','2023-03-20 23:16:03'),(360,0,NULL,NULL,0,1,360,NULL,8,NULL,'Retenciones Bancarias de Ganancias a Favor',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(364,0,NULL,NULL,0,1,364,NULL,8,NULL,'Anticipo de Clientes',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(384,0,NULL,NULL,0,1,384,NULL,8,NULL,'Caja en Dolares',NULL,0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:16:03','2023-03-20 23:16:03'),(409,0,NULL,NULL,0,1,409,NULL,6,NULL,'IVA Crédito Fiscal No computable',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(418,0,NULL,NULL,0,1,418,NULL,8,NULL,'Deudas Bancarias',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(433,0,NULL,NULL,0,1,433,NULL,8,NULL,'Préstamo',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(441,0,NULL,NULL,0,1,441,NULL,8,NULL,'Leasing',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(448,0,NULL,NULL,0,1,448,NULL,8,NULL,'Planes de Pagos AFIP',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(450,0,NULL,NULL,0,1,450,NULL,3,NULL,'Cheques Rechazados',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(467,0,NULL,NULL,0,1,467,NULL,6,NULL,'Interés',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:19:29',NULL),(468,0,NULL,NULL,0,1,14,NULL,8,NULL,'Deudores por ventas comunes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(469,0,NULL,NULL,0,1,15,NULL,8,NULL,'Deudores por ventas morosos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(470,0,NULL,NULL,0,1,16,NULL,8,NULL,'Deudores en gestión judicial',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(471,0,NULL,NULL,0,1,17,NULL,8,NULL,'Previsión deudores incobrables',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(472,0,NULL,NULL,0,1,22,NULL,8,NULL,'Anticipo Impto.Ganancia Mínima Presunta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(473,0,NULL,NULL,0,1,24,NULL,4,NULL,'Impuesto a las Ganancias (Saldo a favor)',NULL,0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:56:05',NULL),(474,0,NULL,NULL,0,1,27,NULL,8,NULL,'Anticipos de proveedores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(475,0,NULL,NULL,0,1,28,NULL,8,NULL,'Depósito en garantía alquileres',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (476,0,NULL,NULL,0,1,29,NULL,8,NULL,'Derechos adquiridos a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(477,0,NULL,NULL,0,1,30,NULL,8,NULL,'Intereses a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(478,0,NULL,NULL,0,1,31,NULL,8,NULL,'Cuentas a rendir - Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(479,0,NULL,NULL,0,1,32,NULL,8,NULL,'Alquileres no devengados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(480,0,NULL,NULL,0,1,38,NULL,8,NULL,'Equipos de computación valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(481,0,NULL,NULL,0,1,39,NULL,8,NULL,'Equipos de computación ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(482,0,NULL,NULL,0,1,40,NULL,8,NULL,'Amortización Acumulada Equipos de comput.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(483,0,NULL,NULL,0,1,42,NULL,8,NULL,'Instalaciones valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(484,0,NULL,NULL,0,1,43,NULL,8,NULL,'Instalaciones ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(485,0,NULL,NULL,0,1,44,NULL,8,NULL,'Amortización Acumulada Instalaciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(486,0,NULL,NULL,0,1,46,NULL,8,NULL,'Muebles y utiles valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(487,0,NULL,NULL,0,1,47,NULL,8,NULL,'Muebles y utiles ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(488,0,NULL,NULL,0,1,48,NULL,8,NULL,'Amortización Acumulada Muebles y Útiles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(489,0,NULL,NULL,0,1,50,NULL,8,NULL,'Gastos de organización valores historicos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(490,0,NULL,NULL,0,1,51,NULL,8,NULL,'Gastos de organización ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(491,0,NULL,NULL,0,1,52,NULL,8,NULL,'Amortización acumulada gs. de organización',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(492,0,NULL,NULL,0,1,58,NULL,8,NULL,'Proveedores en cta. cte. exterior',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(493,0,NULL,NULL,0,1,59,NULL,8,NULL,'Derechos de exhibición a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(494,0,NULL,NULL,0,1,63,NULL,8,NULL,'Cargas sociales a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(495,0,NULL,NULL,0,1,64,NULL,8,NULL,'Sindicatos a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(496,0,NULL,NULL,0,1,67,NULL,8,NULL,'IVA Debito Fiscal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(497,0,NULL,NULL,0,1,68,NULL,8,NULL,'IVA Credito Fiscal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(498,0,NULL,NULL,0,1,69,NULL,8,NULL,'Impuestos Internos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(499,0,NULL,NULL,0,1,70,NULL,8,NULL,'Impuestos al Combustible',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(500,0,NULL,NULL,0,1,71,NULL,8,NULL,'IVA Retenciones de terceros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(501,0,NULL,NULL,0,1,72,NULL,5,NULL,'IVA Percepciones realiz.por terceros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(502,0,NULL,NULL,0,1,73,NULL,8,NULL,'IVA Saldo a favor',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(503,0,NULL,NULL,0,1,74,NULL,8,NULL,'IVA a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(504,0,NULL,NULL,0,1,75,NULL,5,NULL,'Percepciones Ingresos Brutos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (505,0,NULL,NULL,0,1,76,NULL,8,NULL,'Otros Pagos AFIP',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(506,0,NULL,NULL,0,1,78,NULL,8,NULL,'Impuesto a los Ingresos Brutos Pasivo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(507,0,NULL,NULL,0,1,79,NULL,8,NULL,'Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(508,0,NULL,NULL,0,1,80,NULL,8,NULL,'Impuesto a la Ganancia Mínima Presunta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(509,0,NULL,NULL,0,1,81,NULL,8,NULL,'AFIP - Retenciones Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(510,0,NULL,NULL,0,1,82,NULL,8,NULL,'AFIP - Plan de Facilidades Decreto 338/02',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(511,0,NULL,NULL,0,1,87,NULL,8,NULL,'Acciones en circulación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(512,0,NULL,NULL,0,1,88,NULL,8,NULL,'Ajuste del Capital',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(513,0,NULL,NULL,0,1,89,NULL,8,NULL,'Aportes Irrevocables Futuras Suscripciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(514,0,NULL,NULL,0,1,91,NULL,8,NULL,'Resultado del ejercicio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(515,0,NULL,NULL,0,1,92,NULL,8,NULL,'Resultado ejercicios anteriores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(516,0,NULL,NULL,0,1,93,NULL,8,NULL,'A.R.E.A.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(517,0,NULL,NULL,0,1,96,NULL,7,NULL,'VENTAS',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:29',NULL),(518,0,NULL,NULL,0,1,97,NULL,7,NULL,'Honorarios',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(519,0,NULL,NULL,0,1,99,NULL,7,NULL,'Descuentos obtenidos',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(520,0,NULL,NULL,0,1,100,NULL,7,NULL,'Reintegros por exportaciones',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(521,0,NULL,NULL,0,1,102,NULL,7,NULL,'Intereses Cobrados',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(522,0,NULL,NULL,0,1,103,NULL,7,NULL,'Diferencias de cambio',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(523,0,NULL,NULL,0,1,104,NULL,7,NULL,'Descuentos obtenidos',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(524,0,NULL,NULL,0,1,110,NULL,6,NULL,'Sueldos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(525,0,NULL,NULL,0,1,111,NULL,6,NULL,'Contribuciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(526,0,NULL,NULL,0,1,112,NULL,6,NULL,'Sindicato',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(527,0,NULL,NULL,0,1,114,NULL,8,NULL,'ACA',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(528,0,NULL,NULL,0,1,115,NULL,6,NULL,'Aereos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(529,0,NULL,NULL,0,1,116,NULL,6,NULL,'Alquiler',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(530,0,NULL,NULL,0,1,117,NULL,8,NULL,'AGUA AYSA',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(531,0,NULL,NULL,0,1,118,NULL,8,NULL,'TV Cablevision',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(532,0,NULL,NULL,0,1,119,NULL,1,NULL,'Caja Jubilacion Consejo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(533,0,NULL,NULL,0,1,120,NULL,6,NULL,'Celulares',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(534,0,NULL,NULL,0,1,121,NULL,3,NULL,'Cheques',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(535,0,NULL,NULL,0,1,123,NULL,8,NULL,'Comida',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (536,0,NULL,NULL,0,1,126,NULL,6,NULL,'Fletes y acarreos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(537,0,NULL,NULL,0,1,127,NULL,8,NULL,'Luz Edesur',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(538,0,NULL,NULL,0,1,128,NULL,6,NULL,'Movilidad y Viáticos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(539,0,NULL,NULL,0,1,129,NULL,8,NULL,'Mantenimiento',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(540,0,NULL,NULL,0,1,130,NULL,8,NULL,'IVA No Computable',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(541,0,NULL,NULL,0,1,131,NULL,8,NULL,'Entretenimiento',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(542,0,NULL,NULL,0,1,132,NULL,6,NULL,'Amortización Bienes de Uso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(543,0,NULL,NULL,0,1,135,NULL,6,NULL,'Gastos varios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(544,0,NULL,NULL,0,1,136,NULL,6,NULL,'Ajuste por redondeo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(545,0,NULL,NULL,0,1,137,NULL,6,NULL,'Deudores Incobrables',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(546,0,NULL,NULL,0,1,141,NULL,6,NULL,'Intereses Proveedores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(547,0,NULL,NULL,0,1,143,NULL,6,NULL,'Diferencias de cambio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(548,0,NULL,NULL,0,1,144,NULL,8,NULL,'Diferencia de Cambio Bces. en M.Extranjera',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(549,0,NULL,NULL,0,1,145,NULL,6,NULL,'Diferencia tipo cambio Vendedor/Comprador',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(550,0,NULL,NULL,0,1,146,NULL,8,NULL,'Diferencia por conversion en Bce. en Mon. Extranj.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(551,0,NULL,NULL,0,1,147,NULL,8,NULL,'Diferencia de cambio CMV',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(552,0,NULL,NULL,0,1,148,NULL,8,NULL,'Diferencia de cambio PT',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(553,0,NULL,NULL,0,1,149,NULL,8,NULL,'Resultado por Exposición a la Inflación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(554,0,NULL,NULL,0,1,150,NULL,8,NULL,'Diferencia de cambio PE',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(555,0,NULL,NULL,0,1,151,NULL,8,NULL,'Diferencia de cambio Ds.Vtas.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(556,0,NULL,NULL,0,1,152,NULL,6,NULL,'Diferencia de cambio ME',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(557,0,NULL,NULL,0,1,153,NULL,6,NULL,'Descuentos otorgados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(558,0,NULL,NULL,0,1,155,NULL,6,NULL,'Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(559,0,NULL,NULL,0,1,156,NULL,6,NULL,'Impuesto a los Ingresos Brutos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(560,0,NULL,NULL,0,1,157,NULL,6,NULL,'Impuesto al Debito y Credito Bancario',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(561,0,NULL,NULL,0,1,159,NULL,6,NULL,'Pérdida por venta bienes de uso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(562,0,NULL,NULL,0,1,160,NULL,6,NULL,'Inversiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(563,0,NULL,NULL,0,1,161,NULL,6,NULL,'Amortizaciones extraordinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(564,0,NULL,NULL,0,1,178,NULL,8,NULL,'Google',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(565,0,NULL,NULL,0,1,188,NULL,6,NULL,'Publicidad',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (566,0,NULL,NULL,0,1,191,NULL,6,NULL,'Cargas Sociales',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(567,0,NULL,NULL,0,1,192,NULL,6,NULL,'Honorarios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(568,0,NULL,NULL,0,1,193,NULL,6,NULL,'Telefono Fijo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(569,0,NULL,NULL,0,1,198,NULL,6,NULL,'Seguros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(570,0,NULL,NULL,0,1,199,NULL,6,NULL,'Internet',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(571,0,NULL,NULL,0,1,204,NULL,6,NULL,'Multas Impositivas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(572,0,NULL,NULL,0,1,208,NULL,6,NULL,'Impuesto a los Ingresos Brutos - BS AS',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(573,0,NULL,NULL,0,1,209,NULL,6,NULL,'SIRCREB',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(574,0,NULL,NULL,0,1,212,NULL,6,NULL,'Tarjeta Visa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(575,0,NULL,NULL,0,1,213,NULL,6,NULL,'Tarjeta American Express',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(576,0,NULL,NULL,0,1,214,NULL,6,NULL,'Tarjeta Mastercard',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(577,0,NULL,NULL,0,1,215,NULL,8,NULL,'Tarjeta Shopping',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(578,0,NULL,NULL,0,1,216,NULL,6,NULL,'Tarjeta Cencosud',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(579,0,NULL,NULL,0,1,217,NULL,6,NULL,'Compras',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(580,0,NULL,NULL,0,1,218,NULL,7,NULL,'Ventas No Gravadas',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(581,0,NULL,NULL,0,1,220,NULL,5,NULL,'Perc IVA -RG3337',NULL,0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:56:05',NULL),(582,0,NULL,NULL,0,1,221,NULL,6,NULL,'Imps. Internos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(583,0,NULL,NULL,0,1,222,NULL,6,NULL,'Imp. Gasoil',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(584,0,NULL,NULL,0,1,223,NULL,6,NULL,'Imp. Hídricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(585,0,NULL,NULL,0,1,224,NULL,6,NULL,'ITC',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(586,0,NULL,NULL,0,1,225,NULL,5,NULL,'Perc IIBB  Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(587,0,NULL,NULL,0,1,226,NULL,5,NULL,'Perc IIBB  Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(588,0,NULL,NULL,0,1,227,NULL,5,NULL,'Perc IIBB  Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(589,0,NULL,NULL,0,1,228,NULL,5,NULL,'Perc IIBB  Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(590,0,NULL,NULL,0,1,229,NULL,5,NULL,'Perc IIBB  Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(591,0,NULL,NULL,0,1,230,NULL,5,NULL,'Perc IIBB  Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(592,0,NULL,NULL,0,1,231,NULL,5,NULL,'Perc IIBB  Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(593,0,NULL,NULL,0,1,232,NULL,5,NULL,'Perc IIBB  Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(594,0,NULL,NULL,0,1,233,NULL,5,NULL,'Perc IIBB  Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(595,0,NULL,NULL,0,1,234,NULL,5,NULL,'Perc IIBB  Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(596,0,NULL,NULL,0,1,235,NULL,5,NULL,'Perc IIBB  La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(597,0,NULL,NULL,0,1,236,NULL,5,NULL,'Perc IIBB  La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (598,0,NULL,NULL,0,1,237,NULL,5,NULL,'Perc IIBB  Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(599,0,NULL,NULL,0,1,238,NULL,5,NULL,'Perc IIBB  Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(600,0,NULL,NULL,0,1,239,NULL,5,NULL,'Perc IIBB  Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(601,0,NULL,NULL,0,1,240,NULL,5,NULL,'Perc IIBB  Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(602,0,NULL,NULL,0,1,241,NULL,5,NULL,'Perc IIBB  Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(603,0,NULL,NULL,0,1,242,NULL,5,NULL,'Perc IIBB  Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(604,0,NULL,NULL,0,1,243,NULL,5,NULL,'Perc IIBB  San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(605,0,NULL,NULL,0,1,244,NULL,5,NULL,'Perc IIBB  San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(606,0,NULL,NULL,0,1,245,NULL,5,NULL,'Perc IIBB  Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(607,0,NULL,NULL,0,1,246,NULL,5,NULL,'Perc IIBB  Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(608,0,NULL,NULL,0,1,247,NULL,5,NULL,'Perc IIBB  Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(609,0,NULL,NULL,0,1,248,NULL,5,NULL,'Perc IIBB  Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(610,0,NULL,NULL,0,1,249,NULL,5,NULL,'Perc IIBB  Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(611,0,NULL,NULL,0,1,250,NULL,6,NULL,'Compras No Gravadas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(612,0,NULL,NULL,0,1,276,NULL,6,NULL,'SIRCREB Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(613,0,NULL,NULL,0,1,277,NULL,6,NULL,'SIRCREB Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(614,0,NULL,NULL,0,1,278,NULL,6,NULL,'SIRCREB Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(615,0,NULL,NULL,0,1,279,NULL,6,NULL,'SIRCREB Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(616,0,NULL,NULL,0,1,280,NULL,6,NULL,'SIRCREB Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(617,0,NULL,NULL,0,1,281,NULL,6,NULL,'SIRCREB Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(618,0,NULL,NULL,0,1,282,NULL,6,NULL,'SIRCREB Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(619,0,NULL,NULL,0,1,283,NULL,6,NULL,'SIRCREB Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(620,0,NULL,NULL,0,1,284,NULL,6,NULL,'SIRCREB Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(621,0,NULL,NULL,0,1,285,NULL,6,NULL,'SIRCREB Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(622,0,NULL,NULL,0,1,286,NULL,6,NULL,'SIRCREB La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(623,0,NULL,NULL,0,1,287,NULL,6,NULL,'SIRCREB La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(624,0,NULL,NULL,0,1,288,NULL,6,NULL,'SIRCREB Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(625,0,NULL,NULL,0,1,289,NULL,6,NULL,'SIRCREB Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(626,0,NULL,NULL,0,1,290,NULL,6,NULL,'SIRCREB Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(627,0,NULL,NULL,0,1,291,NULL,6,NULL,'SIRCREB Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(628,0,NULL,NULL,0,1,292,NULL,6,NULL,'SIRCREB Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (629,0,NULL,NULL,0,1,293,NULL,6,NULL,'SIRCREB Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(630,0,NULL,NULL,0,1,294,NULL,6,NULL,'SIRCREB San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(631,0,NULL,NULL,0,1,295,NULL,6,NULL,'SIRCREB San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(632,0,NULL,NULL,0,1,296,NULL,6,NULL,'SIRCREB Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(633,0,NULL,NULL,0,1,297,NULL,6,NULL,'SIRCREB Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(634,0,NULL,NULL,0,1,298,NULL,6,NULL,'SIRCREB Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(635,0,NULL,NULL,0,1,299,NULL,6,NULL,'SIRCREB Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(636,0,NULL,NULL,0,1,300,NULL,6,NULL,'SIRCREB Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(637,0,NULL,NULL,0,1,301,NULL,8,NULL,'IIBB a Favor Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(638,0,NULL,NULL,0,1,302,NULL,8,NULL,'IIBB a Favor Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(639,0,NULL,NULL,0,1,303,NULL,8,NULL,'IIBB a Favor Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(640,0,NULL,NULL,0,1,304,NULL,8,NULL,'IIBB a Favor Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(641,0,NULL,NULL,0,1,305,NULL,8,NULL,'IIBB a Favor Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(642,0,NULL,NULL,0,1,306,NULL,8,NULL,'IIBB a Favor Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(643,0,NULL,NULL,0,1,307,NULL,8,NULL,'IIBB a Favor Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(644,0,NULL,NULL,0,1,308,NULL,8,NULL,'IIBB a Favor Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(645,0,NULL,NULL,0,1,309,NULL,8,NULL,'IIBB a Favor Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(646,0,NULL,NULL,0,1,310,NULL,8,NULL,'IIBB a Favor Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(647,0,NULL,NULL,0,1,311,NULL,8,NULL,'IIBB a Favor La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(648,0,NULL,NULL,0,1,312,NULL,8,NULL,'IIBB a Favor La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(649,0,NULL,NULL,0,1,313,NULL,8,NULL,'IIBB a Favor Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:19:30',NULL),(650,0,NULL,NULL,0,1,314,NULL,8,NULL,'IIBB a Favor Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(651,0,NULL,NULL,0,1,315,NULL,8,NULL,'IIBB a Favor Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(652,0,NULL,NULL,0,1,316,NULL,8,NULL,'IIBB a Favor Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(653,0,NULL,NULL,0,1,317,NULL,8,NULL,'IIBB a Favor Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(654,0,NULL,NULL,0,1,318,NULL,8,NULL,'IIBB a Favor Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(655,0,NULL,NULL,0,1,319,NULL,8,NULL,'IIBB a Favor San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(656,0,NULL,NULL,0,1,320,NULL,8,NULL,'IIBB a Favor San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(657,0,NULL,NULL,0,1,321,NULL,8,NULL,'IIBB a Favor Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(658,0,NULL,NULL,0,1,322,NULL,8,NULL,'IIBB a Favor Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (659,0,NULL,NULL,0,1,323,NULL,8,NULL,'IIBB a Favor Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(660,0,NULL,NULL,0,1,324,NULL,8,NULL,'IIBB a Favor Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(661,0,NULL,NULL,0,1,325,NULL,8,NULL,'IIBB a Favor Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(662,0,NULL,NULL,0,1,326,NULL,8,NULL,'IIBB a Pagar Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(663,0,NULL,NULL,0,1,327,NULL,8,NULL,'IIBB a Pagar Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(664,0,NULL,NULL,0,1,328,NULL,8,NULL,'IIBB a Pagar Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(665,0,NULL,NULL,0,1,329,NULL,8,NULL,'IIBB a Pagar Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(666,0,NULL,NULL,0,1,330,NULL,8,NULL,'IIBB a Pagar Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(667,0,NULL,NULL,0,1,331,NULL,8,NULL,'IIBB a Pagar Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(668,0,NULL,NULL,0,1,332,NULL,8,NULL,'IIBB a Pagar Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(669,0,NULL,NULL,0,1,333,NULL,8,NULL,'IIBB a Pagar Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(670,0,NULL,NULL,0,1,334,NULL,8,NULL,'IIBB a Pagar Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(671,0,NULL,NULL,0,1,335,NULL,8,NULL,'IIBB a Pagar Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(672,0,NULL,NULL,0,1,336,NULL,8,NULL,'IIBB a Pagar La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(673,0,NULL,NULL,0,1,337,NULL,8,NULL,'IIBB a Pagar La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(674,0,NULL,NULL,0,1,338,NULL,8,NULL,'IIBB a Pagar Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(675,0,NULL,NULL,0,1,339,NULL,8,NULL,'IIBB a Pagar Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(676,0,NULL,NULL,0,1,340,NULL,8,NULL,'IIBB a Pagar Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(677,0,NULL,NULL,0,1,341,NULL,8,NULL,'IIBB a Pagar Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(678,0,NULL,NULL,0,1,342,NULL,8,NULL,'IIBB a Pagar Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(679,0,NULL,NULL,0,1,343,NULL,8,NULL,'IIBB a Pagar Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(680,0,NULL,NULL,0,1,344,NULL,8,NULL,'IIBB a Pagar San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(681,0,NULL,NULL,0,1,345,NULL,8,NULL,'IIBB a Pagar San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(682,0,NULL,NULL,0,1,346,NULL,8,NULL,'IIBB a Pagar Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(683,0,NULL,NULL,0,1,347,NULL,8,NULL,'IIBB a Pagar Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(684,0,NULL,NULL,0,1,348,NULL,8,NULL,'IIBB a Pagar Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(685,0,NULL,NULL,0,1,349,NULL,8,NULL,'IIBB a Pagar Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(686,0,NULL,NULL,0,1,350,NULL,8,NULL,'IIBB a Pagar Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(687,0,NULL,NULL,0,1,352,NULL,8,NULL,'Compensacion',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(688,0,NULL,NULL,0,1,353,NULL,8,NULL,'IVA Saldo Tecnico',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (689,0,NULL,NULL,0,1,354,NULL,8,NULL,'IVA Saldo Libre Disponibilidad',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(690,0,NULL,NULL,0,1,361,NULL,8,NULL,'Equipos de Computación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(691,0,NULL,NULL,0,1,362,NULL,8,NULL,'Computadoras',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(692,0,NULL,NULL,0,1,363,NULL,8,NULL,'Muebles y Utiles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(693,0,NULL,NULL,0,1,365,NULL,8,NULL,'Provision Honorarios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(694,0,NULL,NULL,0,1,366,NULL,8,NULL,'Cta. Cte Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(695,0,NULL,NULL,0,1,367,NULL,8,NULL,'Provisión Honorarios Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(696,0,NULL,NULL,0,1,368,NULL,8,NULL,'Cuenta Particular Socio 1',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(697,0,NULL,NULL,0,1,369,NULL,8,NULL,'Capital',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(698,0,NULL,NULL,0,1,380,NULL,8,NULL,'Instalaciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(699,0,NULL,NULL,0,1,381,NULL,8,NULL,'Reserva Legal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(700,0,NULL,NULL,0,1,382,NULL,8,NULL,'Reserva Legal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(701,0,NULL,NULL,0,1,383,NULL,8,NULL,'Resultado no asignado',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(702,0,NULL,NULL,0,1,386,NULL,8,NULL,'PLAZO FIJO',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(703,0,NULL,NULL,0,1,388,NULL,8,NULL,'ACCIONES',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(704,0,NULL,NULL,0,1,389,NULL,8,NULL,'Inmuebles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(705,0,NULL,NULL,0,1,390,NULL,8,NULL,'Vehiculos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(706,0,NULL,NULL,0,1,391,NULL,8,NULL,'Maquinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(707,0,NULL,NULL,0,1,392,NULL,8,NULL,'MERCADERIAS',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(708,0,NULL,NULL,0,1,393,NULL,8,NULL,'OTROS',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(709,0,NULL,NULL,0,1,395,NULL,8,NULL,'Cuenta Particular Socio 2',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(710,0,NULL,NULL,0,1,396,NULL,6,NULL,'Comisiones Y gastos Bancarios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(711,0,NULL,NULL,0,1,411,NULL,8,NULL,'Provisión Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(712,0,NULL,NULL,0,1,412,NULL,6,NULL,'Amortización Muebles y Útiles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(713,0,NULL,NULL,0,1,413,NULL,6,NULL,'Amortización Equipos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(714,0,NULL,NULL,0,1,414,NULL,8,NULL,'Amortizacion Acumulada Equipos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(715,0,NULL,NULL,0,1,415,NULL,8,NULL,'Amortización Acumulada Maquinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(716,0,NULL,NULL,0,1,416,NULL,8,NULL,'Materias Primas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(717,0,NULL,NULL,0,1,419,NULL,8,NULL,'Rodados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(718,0,NULL,NULL,0,1,420,NULL,8,NULL,'Amortización Acumulada Rodados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(719,0,NULL,NULL,0,1,421,NULL,8,NULL,'Amortización Rodados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (720,0,NULL,NULL,0,1,422,NULL,8,NULL,'Amortización Maquinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(721,0,NULL,NULL,0,1,423,NULL,8,NULL,'Accesorios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(722,0,NULL,NULL,0,1,424,NULL,8,NULL,'Amortización Acumulada Accesorios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(723,0,NULL,NULL,0,1,426,NULL,8,NULL,'Reserva Facultativa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(724,0,NULL,NULL,0,1,427,NULL,8,NULL,'Créditos por Impuestos Diferidos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(725,0,NULL,NULL,0,1,428,NULL,8,NULL,'Fondo de Comercio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(726,0,NULL,NULL,0,1,429,NULL,8,NULL,'Amortizacion Acumulada Fondo de Comercio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(727,0,NULL,NULL,0,1,430,NULL,8,NULL,'Intereses a devengar AGIP',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(728,0,NULL,NULL,0,1,431,NULL,8,NULL,'PFP IIBB',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(729,0,NULL,NULL,0,1,434,NULL,8,NULL,'Productos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(730,0,NULL,NULL,0,1,435,NULL,8,NULL,'Intereses a devengar PFP',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(731,0,NULL,NULL,0,1,437,NULL,8,NULL,'Imp. Ley 25413 Cred 0.6%',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(732,0,NULL,NULL,0,1,438,NULL,8,NULL,'Honorarios Directorio a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(733,0,NULL,NULL,0,1,439,NULL,8,NULL,'Reserva para Futuras Inversiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(734,0,NULL,NULL,0,1,440,NULL,8,NULL,'TEAC - Trabajos Ejecutados a Certificar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(735,0,NULL,NULL,0,1,444,NULL,8,NULL,'Banco Santander Rio Cta Cte',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(736,0,NULL,NULL,0,1,449,NULL,8,NULL,'Leasing',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(737,0,NULL,NULL,0,1,453,NULL,8,NULL,'Inversión Central Caribe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(738,0,NULL,NULL,0,1,454,NULL,8,NULL,'Otras Inversiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(739,0,NULL,NULL,0,1,455,NULL,8,NULL,'Otros Créditos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(740,0,NULL,NULL,0,1,456,NULL,8,NULL,'Provisión Honorarios Socio Gerente',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(741,0,NULL,NULL,0,1,459,NULL,8,NULL,'Moratoria SUSS a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(742,0,NULL,NULL,0,1,460,NULL,8,NULL,'Impuestos Municipales a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(743,0,NULL,NULL,0,1,461,NULL,6,NULL,'Amortización Instalaciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(744,0,NULL,NULL,0,1,462,NULL,8,NULL,'Amortización Equipos de comput.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(745,0,NULL,NULL,0,1,463,NULL,8,NULL,'Cuenta Particular Socio 3',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(746,0,NULL,NULL,0,1,464,NULL,8,NULL,'Cuenta Particular Socio 4',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(747,0,NULL,NULL,0,1,465,NULL,8,NULL,'Otras Reservas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(748,0,NULL,NULL,0,1,466,NULL,8,NULL,'IGMP (Saldo a Favor)',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(749,0,NULL,NULL,0,1,468,NULL,8,NULL,'Productos en Proceso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (750,0,NULL,NULL,0,1,469,NULL,8,NULL,'Depósitos en Garantía Socio Gerente',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(751,0,NULL,NULL,0,1,470,NULL,8,NULL,'Fondos Embargados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(752,0,NULL,NULL,0,1,471,NULL,8,NULL,'Cuota Solid.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(753,0,NULL,NULL,0,1,472,NULL,8,NULL,'Anticipo Honorarios Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(754,0,NULL,NULL,0,1,473,NULL,8,NULL,'SICORE a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:30',NULL),(755,0,NULL,NULL,0,1,476,NULL,6,NULL,'RECPAM',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:31',NULL),(756,0,NULL,NULL,0,1,478,NULL,6,NULL,'CO2 - Imp. Al Carbono',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:19:31',NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_detail`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `is_conciliado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_detail_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_detail_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_detail`
--

LOCK TABLES `cta_cte_tesoreria_detail` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos`
--

DROP TABLE IF EXISTS `ctacte_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigoBCRA` int(11) DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos`
--

LOCK TABLES `ctacte_bancos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos` DISABLE KEYS */;
INSERT INTO `ctacte_bancos` VALUES (1,NULL,'BANCO DE GALICIA Y BUENOS AIRES S.A.',7,'30-50000173-5',NULL,NULL,NULL),(2,NULL,'BANCO DE LA NACION ARGENTINA',11,'30-50001091-2',NULL,NULL,NULL),(3,NULL,'BANCO DE LA PROVINCIA DE BUENOS AIRES',14,'33-99924210-9',NULL,NULL,NULL),(4,NULL,'INDUSTRIAL AND COMMERCIAL BANK OF CHINA',15,'30-70944784-6',NULL,NULL,NULL),(5,NULL,'CITIBANK N.A.',16,'30-50000562-5',NULL,NULL,NULL),(6,NULL,'BBVA BANCO FRANCES S.A.',17,'30-50000319-3',NULL,NULL,NULL),(7,NULL,'THE BANK OF TOKYO-MITSUBISHI UFJ, LTD.',18,'30-50001183-8',NULL,NULL,NULL),(8,NULL,'BANCO DE LA PROVINCIA DE CORDOBA S.A.',20,'30-99922856-5',NULL,NULL,NULL),(9,NULL,'BANCO SUPERVIELLE S.A.',27,'33-50000517-9',NULL,NULL,NULL),(10,NULL,'BANCO DE LA CIUDAD DE BUENOS AIRES',29,'30-99903208-3',NULL,NULL,NULL),(11,NULL,'BANCO PATAGONIA S.A.',34,'30-50000661-3',NULL,NULL,NULL),(12,NULL,'BANCO HIPOTECARIO S.A.',44,'30-50001107-2',NULL,NULL,NULL),(13,NULL,'BANCO DE SAN JUAN S.A.',45,'30-50000944-2',NULL,NULL,NULL),(14,NULL,'BANCO DEL TUCUMAN S.A.',60,'30-51794820-5',NULL,NULL,NULL),(15,NULL,'BANCO MUNICIPAL DE ROSARIO',65,'33-99918181-9',NULL,NULL,NULL),(16,NULL,'BANCO SANTANDER RIO S.A.',72,'30-50000845-4',NULL,NULL,NULL),(17,NULL,'BANCO DEL CHUBUT S.A.',83,'30-50001299-0',NULL,NULL,NULL),(18,NULL,'BANCO DE SANTA CRUZ S.A.',86,'30-50009880-1',NULL,NULL,NULL),(19,NULL,'BANCO DE LA PAMPA SOCIEDAD DE ECONOMÍA M',93,'30-50001251-6',NULL,NULL,NULL),(20,NULL,'BANCO DE CORRIENTES S.A.',94,'30-50001060-2',NULL,NULL,NULL),(21,NULL,'BANCO PROVINCIA DEL NEUQUÉN SOCIEDAD ANÓ',97,'30-50001404-7',NULL,NULL,NULL),(22,NULL,'BANCO INTERFINANZAS S.A.',147,'30-52271441-7',NULL,NULL,NULL),(23,NULL,'HSBC BANK ARGENTINA S.A.',150,'33-53718600-9',NULL,NULL,NULL),(24,NULL,'JPMORGAN CHASE BANK, NATIONAL ASSOCIATIO',165,'30-58313794-3',NULL,NULL,NULL),(25,NULL,'BANCO CREDICOOP COOPERATIVO LIMITADO',191,'30-57142135-2',NULL,NULL,NULL),(26,NULL,'BANCO DE VALORES S.A.',198,'30-57612427-5',NULL,NULL,NULL),(27,NULL,'BANCO ROELA S.A.',247,'30-53561044-0',NULL,NULL,NULL),(28,NULL,'BANCO MARIVA S.A.',254,'30-51642044-4',NULL,NULL,NULL),(29,NULL,'BANCO ITAU ARGENTINA S.A.',259,'30-58018941-1',NULL,NULL,NULL),(30,NULL,'BANK OF AMERICA, NATIONAL ASSOCIATION',262,'30-50005055-8',NULL,NULL,NULL),(31,NULL,'BNP PARIBAS',266,'30-58472756-6',NULL,NULL,NULL),(32,NULL,'BANCO PROVINCIA DE TIERRA DEL FUEGO',268,'30-57565578-1',NULL,NULL,NULL),(33,NULL,'BANCO DE LA REPUBLICA ORIENTAL DEL URUGU',269,'30-58833784-3',NULL,NULL,NULL),(34,NULL,'BANCO SAENZ S.A.',277,'30-53467243-4',NULL,NULL,NULL),(35,NULL,'BANCO MERIDIAN S.A.',281,'30-53448749-1',NULL,NULL,NULL),(36,NULL,'BANCO MACRO S.A.',285,'30-50001008-4',NULL,NULL,NULL),(37,NULL,'BANCO COMAFI SOCIEDAD ANONIMA',299,'30-60473101-8',NULL,NULL,NULL),(38,NULL,'BANCO DE INVERSION Y COMERCIO EXTERIOR S',300,'30-65112908-3',NULL,NULL,NULL),(39,NULL,'BANCO PIANO S.A.',301,'30-56915176-3',NULL,NULL,NULL),(40,NULL,'BANCO JULIO SOCIEDAD ANONIMA',305,'30-65744121-6',NULL,NULL,NULL),(41,NULL,'BANCO RIOJA SOCIEDAD ANONIMA UNIPERSONAL',309,'30-67185933-9',NULL,NULL,NULL),(42,NULL,'BANCO DEL SOL S.A.',310,'30-67793756-0',NULL,NULL,NULL),(43,NULL,'NUEVO BANCO DEL CHACO S. A.',311,'30-67015779-9',NULL,NULL,NULL),(44,NULL,'BANCO VOII S.A.',312,'30-54674163-6',NULL,NULL,NULL),(45,NULL,'BANCO DE FORMOSA S.A.',315,'30-67137590-0',NULL,NULL,NULL),(46,NULL,'BANCO CMF S.A.',319,'30-57661429-9',NULL,NULL,NULL),(47,NULL,'BANCO DE SANTIAGO DEL ESTERO S.A.',321,'33-68666464-9',NULL,NULL,NULL),(48,NULL,'BANCO INDUSTRIAL S.A.',322,'30-68502995-9',NULL,NULL,NULL),(49,NULL,'NUEVO BANCO DE SANTA FE SOCIEDAD ANONIMA',330,'30-69243266-1',NULL,NULL,NULL),(50,NULL,'BANCO CETELEM ARGENTINA S.A.',331,'30-69730636-2',NULL,NULL,NULL),(51,NULL,'BANCO DE SERVICIOS FINANCIEROS S.A.',332,'30-69726589-5',NULL,NULL,NULL),(52,NULL,'BANCO BRADESCO ARGENTINA S.A.U.',336,'30-70125555-7',NULL,NULL,NULL),(53,NULL,'BANCO DE SERVICIOS Y TRANSACCIONES S.A.',338,'30-70496099-5',NULL,NULL,NULL);
INSERT INTO `ctacte_bancos` VALUES (54,NULL,'RCI BANQUE S.A.',339,'30-70710834-3',NULL,NULL,NULL),(55,NULL,'BACS BANCO DE CREDITO Y SECURITIZACION S',340,'30-70722741-5',NULL,NULL,NULL),(56,NULL,'BANCO MASVENTAS S.A.',341,'30-54061826-3',NULL,NULL,NULL),(57,NULL,'BANCO WANAP S.A.',384,'30-71565463-2',NULL,NULL,NULL),(58,NULL,'NUEVO BANCO DE ENTRE RÍOS S.A.',386,'33-70799551-9',NULL,NULL,NULL),(59,NULL,'BANCO COLUMBIA S.A.',389,'30-51763749-8',NULL,NULL,NULL),(60,NULL,'BANCO BICA S.A.',426,'30-71233123-9',NULL,NULL,NULL),(61,NULL,'BANCO COINAG S.A.',431,'30-71419596-0',NULL,NULL,NULL),(62,NULL,'BANCO DE COMERCIO S.A.',432,'30-54203363-7',NULL,NULL,NULL),(63,NULL,'FORD CREDIT COMPAÑIA FINANCIERA S.A.',44059,'30-51654454-2',NULL,NULL,NULL),(64,NULL,'COMPAÑIA FINANCIERA ARGENTINA S.A.',44077,'30-53800640-4',NULL,NULL,NULL),(65,NULL,'VOLKWAGEN FINANCIAL SERVICES CIA.FIN.S.A',44088,'30-68241957-8',NULL,NULL,NULL),(66,NULL,'CORDIAL COMPAÑÍA FINANCIERA S.A.',44090,'30-70181085-2',NULL,NULL,NULL),(67,NULL,'FCA COMPAÑIA FINANCIERA S.A.',44092,'30-69230488-4',NULL,NULL,NULL),(68,NULL,'GPAT COMPAÑIA FINANCIERA S.A.',44093,'30-67856482-2',NULL,NULL,NULL),(69,NULL,'MERCEDES-BENZ COMPAÑÍA FINANCIERA ARGENT',44094,'30-70700229-4',NULL,NULL,NULL),(70,NULL,'ROMBO COMPAÑÍA FINANCIERA S.A.',44095,'33-70712490-9',NULL,NULL,NULL),(71,NULL,'JOHN DEERE CREDIT COMPAÑÍA FINANCIERA S.',44096,'30-70702485-9',NULL,NULL,NULL),(72,NULL,'PSA FINANCE ARGENTINA COMPAÑÍA FINANCIER',44098,'30-70784736-7',NULL,NULL,NULL),(73,NULL,'TOYOTA COMPAÑÍA FINANCIERA DE ARGENTINA',44099,'30-70900042-6',NULL,NULL,NULL),(74,NULL,'FINANDINO COMPAÑIA FINANCIERA S.A.',44100,'30-71259240-7',NULL,NULL,NULL),(75,NULL,'MONTEMAR COMPAÑIA FINANCIERA S.A.',45056,'30-58138551-6',NULL,NULL,NULL),(76,NULL,'MULTIFINANZAS COMPAÑIA FINANCIERA S.A.',45072,'30-62828435-7',NULL,NULL,NULL),(77,NULL,'CAJA DE CREDITO \"CUENCA\" COOPERATIVA LIM',65203,'30-71622694-4',NULL,NULL,NULL),(78,NULL,'MERCADO PAGO',NULL,NULL,NULL,NULL,NULL),(79,NULL,'UALA',NULL,NULL,NULL,NULL,NULL),(80,NULL,'ICBC',NULL,NULL,NULL,NULL,NULL),(81,NULL,'BMA SAU',NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctacte_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos_datos`
--

DROP TABLE IF EXISTS `ctacte_bancos_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos_datos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `num_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cbu` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_bancos_datos_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  CONSTRAINT `ctacte_bancos_datos_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos_datos`
--

LOCK TABLES `ctacte_bancos_datos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_bancos_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_cheques`
--

DROP TABLE IF EXISTS `ctacte_cheques`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_cheques` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `asiento_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id2` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) DEFAULT NULL,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_cobro` date DEFAULT NULL,
  `banco_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `cuit` text COLLATE utf8mb4_unicode_ci,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abierto_cruzado` int(11) NOT NULL DEFAULT '1',
  `is_no_a_la_orden` tinyint(1) NOT NULL DEFAULT '0',
  `numero` int(10) unsigned DEFAULT NULL,
  `foto` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_cheques_asiento_id_foreign` (`asiento_id`),
  KEY `ctacte_cheques_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  KEY `ctacte_cheques_banco_id_foreign` (`banco_id`),
  KEY `ctacte_cheques_person_id_foreign` (`person_id`),
  KEY `ctacte_cheques_cta_cte_cliente_id2_foreign` (`cta_cte_cliente_id2`),
  KEY `ctacte_cheques_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesorer_id` (`cta_cte_tesoreria_id`),
  KEY `ctacte_cheques_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `ctacte_cheques_nf_cta_cte_id2_foreign` (`nf_cta_cte_id2`),
  KEY `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ctacte_cheques_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `ctacte_cheques_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  CONSTRAINT `cta_cte_tesorer_id` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `ctacte_cheques_banco_id_foreign` FOREIGN KEY (`banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id2_foreign` FOREIGN KEY (`cta_cte_cliente_id2`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `ctacte_cheques_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id2_foreign` FOREIGN KEY (`nf_cta_cte_id2`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_cheques`
--

LOCK TABLES `ctacte_cheques` WRITE;
/*!40000 ALTER TABLE `ctacte_cheques` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_cheques` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_centrocosto`
--

DROP TABLE IF EXISTS `ctactegastos_centrocosto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_centrocosto` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_centrocosto`
--

LOCK TABLES `ctactegastos_centrocosto` WRITE;
/*!40000 ALTER TABLE `ctactegastos_centrocosto` DISABLE KEYS */;
INSERT INTO `ctactegastos_centrocosto` VALUES (1,NULL,'OFICINA',NULL,NULL,NULL),(2,NULL,'FIJO',NULL,NULL,NULL),(3,NULL,'VARIABLE',NULL,NULL,NULL),(4,NULL,'GISELA',NULL,NULL,NULL),(5,NULL,'LIA',NULL,NULL,NULL),(6,NULL,'PADRES',NULL,NULL,NULL),(7,NULL,'CASA',NULL,NULL,NULL),(8,NULL,'VANESA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_centrocosto` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_cuenta_tipo`
--

DROP TABLE IF EXISTS `ctactegastos_cuenta_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_cuenta_tipo` (
  `idCuentaTipo` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `idTipo` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`idCuentaTipo`),
  KEY `ctactegastos_cuenta_tipo_idtipo_foreign` (`idTipo`),
  KEY `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_idtipo_foreign` FOREIGN KEY (`idTipo`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_cuenta_tipo`
--

LOCK TABLES `ctactegastos_cuenta_tipo` WRITE;
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` DISABLE KEYS */;
INSERT INTO `ctactegastos_cuenta_tipo` VALUES (1,NULL,NULL,3,NULL,NULL,NULL),(2,NULL,NULL,6,NULL,NULL,NULL),(3,NULL,NULL,3,NULL,NULL,NULL),(4,NULL,NULL,4,NULL,NULL,NULL),(5,NULL,NULL,5,NULL,NULL,NULL),(6,NULL,NULL,3,NULL,NULL,NULL),(7,NULL,NULL,4,NULL,NULL,NULL),(8,NULL,NULL,3,NULL,NULL,NULL),(9,NULL,NULL,4,NULL,NULL,NULL),(10,NULL,NULL,7,NULL,NULL,NULL),(11,NULL,NULL,8,NULL,NULL,NULL),(12,NULL,NULL,3,NULL,NULL,NULL),(13,NULL,NULL,3,NULL,NULL,NULL),(14,NULL,NULL,4,NULL,NULL,NULL),(15,NULL,NULL,1,NULL,NULL,NULL),(16,NULL,NULL,2,NULL,NULL,NULL),(17,NULL,NULL,5,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_mensuales`
--

DROP TABLE IF EXISTS `ctactegastos_mensuales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_mensuales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `CuentaTipo_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `TipoDeGasto_id` int(10) unsigned NOT NULL,
  `CentroCosto_id` int(10) unsigned NOT NULL,
  `gasto_cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `monto` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctactegastos_mensuales_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `ctactegastos_mensuales_tipodegasto_id_foreign` (`TipoDeGasto_id`),
  KEY `ctactegastos_mensuales_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` (`gasto_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_mensuales_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`gasto_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_tipodegasto_id_foreign` FOREIGN KEY (`TipoDeGasto_id`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_mensuales`
--

LOCK TABLES `ctactegastos_mensuales` WRITE;
/*!40000 ALTER TABLE `ctactegastos_mensuales` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctactegastos_mensuales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_tiposdegastos`
--

DROP TABLE IF EXISTS `ctactegastos_tiposdegastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_tiposdegastos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_tiposdegastos`
--

LOCK TABLES `ctactegastos_tiposdegastos` WRITE;
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` DISABLE KEYS */;
INSERT INTO `ctactegastos_tiposdegastos` VALUES (1,NULL,'Oficina',NULL,NULL,NULL),(2,NULL,'Personales',NULL,NULL,NULL),(3,NULL,'Tarjeta VISA',NULL,NULL,NULL),(4,NULL,'Tarjeta Mastercard',NULL,NULL,NULL),(5,NULL,'Debito Automatico',NULL,NULL,NULL),(6,NULL,'American Express',NULL,NULL,NULL),(7,NULL,'Tarjeta Shopping',NULL,NULL,NULL),(8,NULL,'Tarjeta Cencosud',NULL,NULL,NULL),(9,NULL,'Tarjeta Coto',NULL,NULL,NULL),(10,NULL,'Tarjeta Nativa',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos`
--

DROP TABLE IF EXISTS `cursos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fecha` date DEFAULT NULL,
  `hora` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profesor` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cant_clases` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjuntos` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_zoom` longtext COLLATE utf8mb4_unicode_ci,
  `cod_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contraseña_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_youtube` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `materiales` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos`
--

LOCK TABLES `cursos` WRITE;
/*!40000 ALTER TABLE `cursos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos_detail`
--

DROP TABLE IF EXISTS `cursos_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `curso_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cursos_detail_curso_id_foreign` (`curso_id`),
  CONSTRAINT `cursos_detail_curso_id_foreign` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos_detail`
--

LOCK TABLES `cursos_detail` WRITE;
/*!40000 ALTER TABLE `cursos_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `data_types`
--

DROP TABLE IF EXISTS `data_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `data_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `data_types_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `data_types`
--

LOCK TABLES `data_types` WRITE;
/*!40000 ALTER TABLE `data_types` DISABLE KEYS */;
INSERT INTO `data_types` VALUES (1,'Comprobantes XLS',1,'Importación','XLS','data/imports/receipts/xls',NULL,NULL),(2,'CITI-Ventas',1,'Importación','TXT','data/imports/receipts/CitiVentas',NULL,NULL),(3,'CITI Compras',2,'Exportación','TXT','data/exports/receipts/citi',NULL,NULL),(4,'CITI Ventas',2,'Exportación','TXT','data/exports/receipts/CitiVentasExport',NULL,NULL),(5,'Convenio Multilateral',2,'Exportación','TXT','data/exports/receipts/convenio',NULL,NULL),(6,'Libro IVA Digital',2,'Exportación','TXT','data/exports/receipts/libro_iva_digital',NULL,'2019-11-20 21:43:44'),(7,'Mis Comprobantes',1,'Importacion','','data/imports/receipts/mis_comprobantes',NULL,NULL),(8,'Consulta AFIP',3,'AFIP','','data/afip/index','2019-12-06 14:49:55','2019-12-06 14:49:55');
/*!40000 ALTER TABLE `data_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_estados`
--

DROP TABLE IF EXISTS `dc_estados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_estados` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_estados`
--

LOCK TABLES `dc_estados` WRITE;
/*!40000 ALTER TABLE `dc_estados` DISABLE KEYS */;
INSERT INTO `dc_estados` VALUES (1,NULL,'BORRADOR',1,NULL,'2023-08-07 00:01:23',NULL),(2,NULL,'TERMINADO',1,NULL,'2023-08-07 00:01:23',NULL),(3,NULL,'ELIMINADO',1,NULL,'2023-08-13 09:18:42',NULL),(4,NULL,'PAGADO',1,NULL,'2023-08-07 00:01:23','2023-08-07 00:01:23'),(5,NULL,'CONCILIADO',1,NULL,'2023-08-07 00:01:23','2023-08-07 00:01:23');
/*!40000 ALTER TABLE `dc_estados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_estados_decisiones`
--

DROP TABLE IF EXISTS `dc_estados_decisiones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_estados_decisiones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_tipo_id` bigint(20) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_estados_decisiones_dc_orden_tipo_id_foreign` (`dc_orden_tipo_id`),
  CONSTRAINT `dc_estados_decisiones_dc_orden_tipo_id_foreign` FOREIGN KEY (`dc_orden_tipo_id`) REFERENCES `dc_ordenes_tipos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_estados_decisiones`
--

LOCK TABLES `dc_estados_decisiones` WRITE;
/*!40000 ALTER TABLE `dc_estados_decisiones` DISABLE KEYS */;
INSERT INTO `dc_estados_decisiones` VALUES (1,NULL,3,'Pendiente',1,NULL,NULL,NULL),(2,NULL,3,'Aprobado',1,NULL,NULL,NULL),(3,NULL,3,'Rechazado',1,NULL,NULL,NULL),(4,NULL,3,'Cancelado',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_estados_decisiones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas`
--

DROP TABLE IF EXISTS `dc_firmas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_firmante_dc` tinyint(1) NOT NULL DEFAULT '0',
  `show_create_dc` tinyint(1) NOT NULL DEFAULT '0',
  `faltan_firmas` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas`
--

LOCK TABLES `dc_firmas` WRITE;
/*!40000 ALTER TABLE `dc_firmas` DISABLE KEYS */;
INSERT INTO `dc_firmas` VALUES (1,NULL,'NO',1,1,0,1,NULL,'2023-08-07 00:01:24',NULL),(2,NULL,'RECHAZADO',1,1,0,1,NULL,'2023-08-07 00:01:24',NULL),(3,NULL,'ACEPTADO',1,0,0,1,NULL,'2023-08-07 00:01:24',NULL),(4,NULL,'FALTAN FIRMAS',0,0,1,1,'2023-08-07 00:01:24','2023-08-07 00:01:24',NULL),(5,NULL,'EMITIDO',1,0,0,1,'2023-10-12 08:08:42','2023-10-12 08:08:42',NULL);
/*!40000 ALTER TABLE `dc_firmas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas_ordenes`
--

DROP TABLE IF EXISTS `dc_firmas_ordenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas_ordenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `user_id_que_firma` int(10) unsigned NOT NULL,
  `dc_firma_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_firmas_ordenes_person_id_foreign` (`person_id`),
  KEY `dc_firmas_ordenes_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_firmas_ordenes_dc_firma_id_foreign` (`dc_firma_id`),
  CONSTRAINT `dc_firmas_ordenes_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_firmas_ordenes_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_firmas_ordenes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas_ordenes`
--

LOCK TABLES `dc_firmas_ordenes` WRITE;
/*!40000 ALTER TABLE `dc_firmas_ordenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_firmas_ordenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas_reglas`
--

DROP TABLE IF EXISTS `dc_firmas_reglas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas_reglas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL,
  `grupos_users_ids` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_firmas_reglas_person_id_foreign` (`person_id`),
  KEY `dc_firmas_reglas_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_firmas_reglas_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_firmas_reglas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas_reglas`
--

LOCK TABLES `dc_firmas_reglas` WRITE;
/*!40000 ALTER TABLE `dc_firmas_reglas` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_firmas_reglas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_de_pago`
--

DROP TABLE IF EXISTS `dc_orden_de_pago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_de_pago` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-09-28 16:32:14',
  `dc_orden_id` bigint(20) unsigned NOT NULL DEFAULT '10',
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dc_estado_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `dc_firma_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_de_pago_person_id_foreign` (`person_id`),
  KEY `dc_orden_de_pago_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `dc_orden_de_pago_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_orden_de_pago_dc_firma_id_foreign` (`dc_firma_id`),
  KEY `dc_orden_de_pago_dc_estado_id_foreign` (`dc_estado_id`),
  CONSTRAINT `dc_orden_de_pago_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `dc_orden_de_pago_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_orden_de_pago_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_orden_de_pago_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_orden_de_pago_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_de_pago`
--

LOCK TABLES `dc_orden_de_pago` WRITE;
/*!40000 ALTER TABLE `dc_orden_de_pago` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_de_pago` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_de_pago_cheques`
--

DROP TABLE IF EXISTS `dc_orden_de_pago_cheques`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_de_pago_cheques` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_de_pago_id` bigint(20) unsigned NOT NULL,
  `ctacte_cheque_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_de_pago_cheques_dc_orden_de_pago_id_foreign` (`dc_orden_de_pago_id`),
  KEY `dc_orden_de_pago_cheques_ctacte_cheque_id_foreign` (`ctacte_cheque_id`),
  CONSTRAINT `dc_orden_de_pago_cheques_ctacte_cheque_id_foreign` FOREIGN KEY (`ctacte_cheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `dc_orden_de_pago_cheques_dc_orden_de_pago_id_foreign` FOREIGN KEY (`dc_orden_de_pago_id`) REFERENCES `dc_orden_de_pago` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_de_pago_cheques`
--

LOCK TABLES `dc_orden_de_pago_cheques` WRITE;
/*!40000 ALTER TABLE `dc_orden_de_pago_cheques` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_de_pago_cheques` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_de_pago_receipts`
--

DROP TABLE IF EXISTS `dc_orden_de_pago_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_de_pago_receipts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_de_pago_id` bigint(20) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_de_pago_receipts_dc_orden_de_pago_id_foreign` (`dc_orden_de_pago_id`),
  KEY `dc_orden_de_pago_receipts_receipt_id_foreign` (`receipt_id`),
  CONSTRAINT `dc_orden_de_pago_receipts_dc_orden_de_pago_id_foreign` FOREIGN KEY (`dc_orden_de_pago_id`) REFERENCES `dc_orden_de_pago` (`id`),
  CONSTRAINT `dc_orden_de_pago_receipts_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_de_pago_receipts`
--

LOCK TABLES `dc_orden_de_pago_receipts` WRITE;
/*!40000 ALTER TABLE `dc_orden_de_pago_receipts` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_de_pago_receipts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_files`
--

DROP TABLE IF EXISTS `dc_orden_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `file` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_files_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_orden_files_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_files`
--

LOCK TABLES `dc_orden_files` WRITE;
/*!40000 ALTER TABLE `dc_orden_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes`
--

DROP TABLE IF EXISTS `dc_ordenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_tipo_id` bigint(20) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `titulo` text COLLATE utf8mb4_unicode_ci,
  `sucursal` int(11) NOT NULL DEFAULT '1',
  `numero` int(11) NOT NULL,
  `numero_text` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sector` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `solicitante` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `syj_empleado_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `fecha_entrega` date DEFAULT NULL,
  `fecha_asignacion` datetime DEFAULT NULL,
  `fecha_cumplido` datetime DEFAULT NULL,
  `condicion_venta_id` int(10) unsigned DEFAULT NULL,
  `is_pago_adelantado` tinyint(1) DEFAULT NULL,
  `is_garantia` tinyint(1) NOT NULL DEFAULT '0',
  `forma_de_entrega_id` int(10) unsigned DEFAULT NULL,
  `plazo_de_pago_id` int(10) unsigned DEFAULT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(16,2) NOT NULL DEFAULT '1.00',
  `neto` decimal(16,2) NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `total` decimal(16,2) NOT NULL,
  `facturada` decimal(16,2) NOT NULL DEFAULT '0.00',
  `is_pagada` tinyint(1) NOT NULL,
  `garantia` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mant_oferta` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comen_para_cliente` text COLLATE utf8mb4_unicode_ci,
  `comentario` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dc_ov_origen_id` bigint(20) unsigned DEFAULT NULL,
  `dc_ov_status_cobranza_id` bigint(20) unsigned DEFAULT NULL,
  `dc_ov_status_factura_id` bigint(20) unsigned DEFAULT NULL,
  `dc_ov_status_entrega_id` bigint(20) unsigned DEFAULT NULL,
  `dc_ov_status_venta_id` bigint(20) unsigned DEFAULT NULL,
  `dc_estado_id` bigint(20) unsigned NOT NULL,
  `dc_estado_decision_id` bigint(20) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_cc_id` bigint(20) unsigned DEFAULT NULL,
  `origendestinoable_type` text COLLATE utf8mb4_unicode_ci,
  `origendestinoable_id` int(10) unsigned DEFAULT NULL,
  `is_multiples_ot` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `dc_orden_origen_destino_id` bigint(20) unsigned DEFAULT NULL,
  `is_completado` tinyint(1) NOT NULL DEFAULT '0',
  `is_credit` tinyint(1) DEFAULT NULL,
  `dc_firma_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_dc_orden_tipo_id_foreign` (`dc_orden_tipo_id`),
  KEY `dc_ordenes_person_id_foreign` (`person_id`),
  KEY `dc_ordenes_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `dc_ordenes_dc_estado_id_foreign` (`dc_estado_id`),
  KEY `dc_ordenes_conta_cc_id_foreign` (`conta_cc_id`),
  KEY `dc_ordenes_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `dc_ordenes_dc_orden_origen_destino_id_foreign` (`dc_orden_origen_destino_id`),
  KEY `dc_ordenes_moneda_id_foreign` (`moneda_id`),
  KEY `dc_ordenes_dc_firma_id_foreign` (`dc_firma_id`),
  KEY `dc_ordenes_syj_empleado_id_foreign` (`syj_empleado_id`),
  KEY `dc_ordenes_dc_estado_decision_id_foreign` (`dc_estado_decision_id`),
  KEY `dc_ordenes_dc_ov_origen_id_foreign` (`dc_ov_origen_id`),
  KEY `dc_ordenes_dc_ov_status_venta_id_foreign` (`dc_ov_status_venta_id`),
  KEY `dc_ordenes_dc_ov_status_entrega_id_foreign` (`dc_ov_status_entrega_id`),
  KEY `dc_ordenes_dc_ov_status_factura_id_foreign` (`dc_ov_status_factura_id`),
  KEY `dc_ordenes_dc_ov_status_cobranza_id_foreign` (`dc_ov_status_cobranza_id`),
  CONSTRAINT `dc_ordenes_conta_cc_id_foreign` FOREIGN KEY (`conta_cc_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `dc_ordenes_dc_estado_decision_id_foreign` FOREIGN KEY (`dc_estado_decision_id`) REFERENCES `dc_estados_decisiones` (`id`),
  CONSTRAINT `dc_ordenes_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `dc_ordenes_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_ordenes_dc_orden_origen_destino_id_foreign` FOREIGN KEY (`dc_orden_origen_destino_id`) REFERENCES `dc_ordenes_origen_destino` (`id`),
  CONSTRAINT `dc_ordenes_dc_orden_tipo_id_foreign` FOREIGN KEY (`dc_orden_tipo_id`) REFERENCES `dc_ordenes_tipos` (`id`),
  CONSTRAINT `dc_ordenes_dc_ov_origen_id_foreign` FOREIGN KEY (`dc_ov_origen_id`) REFERENCES `dc_ov_origenes` (`id`),
  CONSTRAINT `dc_ordenes_dc_ov_status_cobranza_id_foreign` FOREIGN KEY (`dc_ov_status_cobranza_id`) REFERENCES `dc_ov_status_cobranza` (`id`),
  CONSTRAINT `dc_ordenes_dc_ov_status_entrega_id_foreign` FOREIGN KEY (`dc_ov_status_entrega_id`) REFERENCES `dc_ov_status_entrega` (`id`),
  CONSTRAINT `dc_ordenes_dc_ov_status_factura_id_foreign` FOREIGN KEY (`dc_ov_status_factura_id`) REFERENCES `dc_ov_status_factura` (`id`),
  CONSTRAINT `dc_ordenes_dc_ov_status_venta_id_foreign` FOREIGN KEY (`dc_ov_status_venta_id`) REFERENCES `dc_ov_status_venta` (`id`),
  CONSTRAINT `dc_ordenes_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `dc_ordenes_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `dc_ordenes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_ordenes_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_ordenes_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes`
--

LOCK TABLES `dc_ordenes` WRITE;
/*!40000 ALTER TABLE `dc_ordenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_compra_coti`
--

DROP TABLE IF EXISTS `dc_ordenes_compra_coti`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_compra_coti` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_coti_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_compra_coti_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_compra_coti_dc_orden_coti_id_foreign` (`dc_orden_coti_id`),
  CONSTRAINT `dc_ordenes_compra_coti_dc_orden_coti_id_foreign` FOREIGN KEY (`dc_orden_coti_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_compra_coti_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_compra_coti`
--

LOCK TABLES `dc_ordenes_compra_coti` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_compra_coti` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_compra_coti` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_compra_req`
--

DROP TABLE IF EXISTS `dc_ordenes_compra_req`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_compra_req` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_compra_req_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_compra_req_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_compra_req_dc_orden_req_id_foreign` (`dc_orden_req_id`),
  KEY `dc_ordenes_compra_req_dc_orden_req_detail_id_foreign` (`dc_orden_req_detail_id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_req_detail_id_foreign` FOREIGN KEY (`dc_orden_req_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_req_id_foreign` FOREIGN KEY (`dc_orden_req_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_compra_req`
--

LOCK TABLES `dc_ordenes_compra_req` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_compra_req` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_compra_req` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_cotizacion_req`
--

DROP TABLE IF EXISTS `dc_ordenes_cotizacion_req`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_cotizacion_req` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_cotizacion_req_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_cotizacion_req_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_cotizacion_req_dc_orden_req_id_foreign` (`dc_orden_req_id`),
  KEY `dc_ordenes_cotizacion_req_dc_orden_req_detail_id_foreign` (`dc_orden_req_detail_id`),
  CONSTRAINT `dc_ordenes_cotizacion_req_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_cotizacion_req_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_cotizacion_req_dc_orden_req_detail_id_foreign` FOREIGN KEY (`dc_orden_req_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_cotizacion_req_dc_orden_req_id_foreign` FOREIGN KEY (`dc_orden_req_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_cotizacion_req`
--

LOCK TABLES `dc_ordenes_cotizacion_req` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_cotizacion_req` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_cotizacion_req` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_details`
--

DROP TABLE IF EXISTS `dc_ordenes_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_origen_destino_id` bigint(20) unsigned DEFAULT NULL,
  `origendestinoable_id` int(10) unsigned DEFAULT NULL,
  `origendestinoable_type` text COLLATE utf8mb4_unicode_ci,
  `cantidades` decimal(16,2) NOT NULL,
  `inv_deposito_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id_destino` bigint(20) unsigned DEFAULT NULL,
  `prod_variant_id` bigint(20) unsigned DEFAULT NULL,
  `inv_deposito_id_destino` bigint(20) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `neto` decimal(16,2) NOT NULL,
  `desc_porc` decimal(16,2) DEFAULT NULL,
  `descuento` decimal(16,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `subtotal` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_details_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_details_inv_producto_id_foreign` (`inv_producto_id`),
  KEY `dc_ordenes_details_system_tax_id_foreign` (`system_tax_id`),
  KEY `dc_ordenes_details_inv_producto_id_destino_foreign` (`inv_producto_id_destino`),
  KEY `dc_ordenes_details_dc_orden_origen_destino_id_foreign` (`dc_orden_origen_destino_id`),
  KEY `dc_ordenes_details_inv_deposito_id_foreign` (`inv_deposito_id`),
  KEY `dc_ordenes_details_inv_deposito_id_destino_foreign` (`inv_deposito_id_destino`),
  KEY `dc_ordenes_details_prod_variant_id_foreign` (`prod_variant_id`),
  CONSTRAINT `dc_ordenes_details_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_details_dc_orden_origen_destino_id_foreign` FOREIGN KEY (`dc_orden_origen_destino_id`) REFERENCES `dc_ordenes_origen_destino` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_deposito_id_destino_foreign` FOREIGN KEY (`inv_deposito_id_destino`) REFERENCES `inv_depositos` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_deposito_id_foreign` FOREIGN KEY (`inv_deposito_id`) REFERENCES `inv_depositos` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_producto_id_destino_foreign` FOREIGN KEY (`inv_producto_id_destino`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `dc_ordenes_details_prod_variant_id_foreign` FOREIGN KEY (`prod_variant_id`) REFERENCES `prod_variants` (`id`) ON DELETE SET NULL,
  CONSTRAINT `dc_ordenes_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_details`
--

LOCK TABLES `dc_ordenes_details` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_facturada`
--

DROP TABLE IF EXISTS `dc_ordenes_facturada`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_facturada` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(11) DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_facturada_person_id_foreign` (`person_id`),
  KEY `dc_ordenes_facturada_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_facturada_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `dc_ordenes_facturada_receipt_id_foreign` (`receipt_id`),
  CONSTRAINT `dc_ordenes_facturada_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_facturada_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_ordenes_facturada_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_facturada`
--

LOCK TABLES `dc_ordenes_facturada` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_facturada` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_facturada` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_ingreso_compra`
--

DROP TABLE IF EXISTS `dc_ordenes_ingreso_compra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_ingreso_compra` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_compra_id_foreign` (`dc_orden_compra_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_compra_detail_id_foreign` (`dc_orden_compra_detail_id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_compra_detail_id_foreign` FOREIGN KEY (`dc_orden_compra_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_compra_id_foreign` FOREIGN KEY (`dc_orden_compra_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_ingreso_compra`
--

LOCK TABLES `dc_ordenes_ingreso_compra` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_ingreso_compra` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_ingreso_compra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_ingxdev_rem_egr`
--

DROP TABLE IF EXISTS `dc_ordenes_ingxdev_rem_egr`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_ingxdev_rem_egr` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_rem_egr_id` bigint(20) unsigned NOT NULL,
  `dc_orden_rem_egr_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_ingxdev_rem_egr_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_ingxdev_rem_egr_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_ingxdev_rem_egr_dc_orden_rem_egr_id_foreign` (`dc_orden_rem_egr_id`),
  KEY `dc_ordenes_ingxdev_rem_egr_dc_orden_rem_egr_detail_id_foreign` (`dc_orden_rem_egr_detail_id`),
  CONSTRAINT `dc_ordenes_ingxdev_rem_egr_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_ingxdev_rem_egr_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_ingxdev_rem_egr_dc_orden_rem_egr_detail_id_foreign` FOREIGN KEY (`dc_orden_rem_egr_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_ingxdev_rem_egr_dc_orden_rem_egr_id_foreign` FOREIGN KEY (`dc_orden_rem_egr_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_ingxdev_rem_egr`
--

LOCK TABLES `dc_ordenes_ingxdev_rem_egr` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_ingxdev_rem_egr` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_ingxdev_rem_egr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_logs`
--

DROP TABLE IF EXISTS `dc_ordenes_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `loggable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `loggable_id` bigint(20) unsigned NOT NULL,
  `related_id` bigint(20) unsigned DEFAULT NULL,
  `related_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_logs_loggable_type_loggable_id_index` (`loggable_type`,`loggable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_logs`
--

LOCK TABLES `dc_ordenes_logs` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_origen_destino`
--

DROP TABLE IF EXISTS `dc_ordenes_origen_destino`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_origen_destino` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `modelo` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_deposito` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_origen_destino`
--

LOCK TABLES `dc_ordenes_origen_destino` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_origen_destino` DISABLE KEYS */;
INSERT INTO `dc_ordenes_origen_destino` VALUES (1,NULL,'Orden de Trabajo','App\\Models\\Inventario\\InvOrdenTrabajo',0,1,NULL,NULL,NULL),(2,NULL,'Centro de Costos','App\\Models\\Inventario\\InvOrdenTrabajoHorasTipo',0,1,NULL,'2023-09-12 22:21:35',NULL),(3,NULL,'Deposito','App\\Models\\Inventario\\InvDeposito',1,1,NULL,'2024-05-07 20:14:15',NULL),(4,NULL,'Empleado','App\\Models\\SyJEmpleado',0,0,NULL,'2023-07-03 22:11:08',NULL);
/*!40000 ALTER TABLE `dc_ordenes_origen_destino` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_pdf_templates`
--

DROP TABLE IF EXISTS `dc_ordenes_pdf_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_pdf_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_tipo_id` bigint(20) unsigned NOT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `vista_blade` text COLLATE utf8mb4_unicode_ci,
  `pdf_base_path` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tipo_plantilla` enum('blade','pdf_base') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'blade',
  `configuracion` json DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_person_tipo_template` (`person_id`,`dc_orden_tipo_id`),
  KEY `dc_ordenes_pdf_templates_dc_orden_tipo_id_foreign` (`dc_orden_tipo_id`),
  CONSTRAINT `dc_ordenes_pdf_templates_dc_orden_tipo_id_foreign` FOREIGN KEY (`dc_orden_tipo_id`) REFERENCES `dc_ordenes_tipos` (`id`),
  CONSTRAINT `dc_ordenes_pdf_templates_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_pdf_templates`
--

LOCK TABLES `dc_ordenes_pdf_templates` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_pdf_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_pdf_templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_revocadas`
--

DROP TABLE IF EXISTS `dc_ordenes_revocadas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_revocadas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `comentario` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_revocadas_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_ordenes_revocadas_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_revocadas`
--

LOCK TABLES `dc_ordenes_revocadas` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_revocadas` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_revocadas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_servicio_compra`
--

DROP TABLE IF EXISTS `dc_ordenes_servicio_compra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_servicio_compra` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_compra_id_foreign` (`dc_orden_compra_id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_compra_detail_id_foreign` (`dc_orden_compra_detail_id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_compra_detail_id_foreign` FOREIGN KEY (`dc_orden_compra_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_compra_id_foreign` FOREIGN KEY (`dc_orden_compra_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_servicio_compra`
--

LOCK TABLES `dc_ordenes_servicio_compra` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_servicio_compra` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_servicio_compra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_tipos`
--

DROP TABLE IF EXISTS `dc_ordenes_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `usabilidad` longtext COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_tipos`
--

LOCK TABLES `dc_ordenes_tipos` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_tipos` DISABLE KEYS */;
INSERT INTO `dc_ordenes_tipos` VALUES (1,NULL,'ORDEN DE COMPRAS',NULL,1,NULL,'2022-11-09 14:47:07',NULL),(2,NULL,'ORDEN DE VENTAS',NULL,1,NULL,'2022-11-09 14:47:07',NULL),(3,NULL,'PRESUPUESTO',NULL,1,NULL,NULL,NULL),(4,NULL,'REQUERIMIENTO',NULL,1,NULL,NULL,NULL),(5,NULL,'REMITO DE INGRESO',NULL,1,NULL,'2023-06-12 23:29:56',NULL),(6,NULL,'REMITO DE EGRESO',NULL,1,NULL,NULL,NULL),(7,NULL,'REMITO INTERNO',NULL,1,NULL,NULL,NULL),(8,NULL,'REMITO DE INGRESO','Es lo mismo que un remito de ingreso, \n        pero los productosa ingresar provienen de una Orden de Compra',1,NULL,NULL,NULL),(9,NULL,'REMITO DE SERVICIO','Es un remito de Ingreso de un servicio que se\n        asigna directo a una OT',1,NULL,NULL,NULL),(10,NULL,'ORDEN DE PAGO',NULL,1,'2023-09-28 16:32:14','2023-09-28 16:32:14',NULL),(11,NULL,'ANULACION REQUERIMIENTOS',NULL,1,'2024-04-02 23:13:17','2024-04-02 23:13:17',NULL),(12,NULL,'ANULACION COMPRAS PRODUCTOS',NULL,1,'2024-04-02 23:13:17','2024-04-02 23:13:17',NULL),(13,NULL,'ANULACION COMPRAS SERVICIOS',NULL,1,'2024-04-02 23:13:17','2024-04-02 23:13:17',NULL),(14,NULL,'REMITO DE GASTO',NULL,1,'2024-05-07 20:14:15','2024-05-07 20:14:15',NULL),(15,NULL,'COTIZACIONES',NULL,1,'2024-06-26 07:54:35','2024-06-26 07:54:35',NULL),(16,NULL,'REMITO INGRESO-DEVOLUCION',NULL,1,'2024-09-02 13:18:26','2024-09-02 13:18:26',NULL),(17,NULL,'REMITO EGRESO-DEVOLUCION',NULL,1,'2024-10-17 08:51:34','2024-10-17 08:51:34',NULL),(18,NULL,'REMITO','Es un remito de servicio, que no tiene ni ingreso ni egreso',1,'2024-12-03 21:47:44','2024-12-03 21:47:44',NULL),(19,NULL,'Remito de Cliente','Se usa en las Ordenes de Venta para demostrar que se entrego mercaderia al cliente',1,NULL,NULL,NULL),(20,NULL,'Orden de Compra de Cliente','Es la OC que envia el cliente para que se le haga el pedido',1,NULL,NULL,NULL),(21,NULL,'Solicitud de Facturacion','Es un documento que se usa para que se pueda facturar',1,NULL,NULL,NULL),(22,NULL,'Ordenes de Compra','Es una OC para Empresas',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_ordenes_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_cta_cte_cliente`
--

DROP TABLE IF EXISTS `dc_ov_cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_cta_cte_cliente` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_cta_cte_cliente_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ov_cta_cte_cliente_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  CONSTRAINT `dc_ov_cta_cte_cliente_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `dc_ov_cta_cte_cliente_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_cta_cte_cliente`
--

LOCK TABLES `dc_ov_cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `dc_ov_cta_cte_cliente` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_cta_cte_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_fact_electronicas`
--

DROP TABLE IF EXISTS `dc_ov_fact_electronicas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_fact_electronicas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `fact_elec_receipt_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_fact_electronicas_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ov_fact_electronicas_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  CONSTRAINT `dc_ov_fact_electronicas_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ov_fact_electronicas_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_fact_electronicas`
--

LOCK TABLES `dc_ov_fact_electronicas` WRITE;
/*!40000 ALTER TABLE `dc_ov_fact_electronicas` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_fact_electronicas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_oc_presupuestos`
--

DROP TABLE IF EXISTS `dc_ov_oc_presupuestos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_oc_presupuestos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_presupuesto_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_oc_presupuestos_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ov_oc_presupuestos_dc_orden_presupuesto_id_foreign` (`dc_orden_presupuesto_id`),
  CONSTRAINT `dc_ov_oc_presupuestos_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ov_oc_presupuestos_dc_orden_presupuesto_id_foreign` FOREIGN KEY (`dc_orden_presupuesto_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_oc_presupuestos`
--

LOCK TABLES `dc_ov_oc_presupuestos` WRITE;
/*!40000 ALTER TABLE `dc_ov_oc_presupuestos` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_oc_presupuestos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_ocs`
--

DROP TABLE IF EXISTS `dc_ov_ocs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_ocs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_ocs_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ov_ocs_dc_orden_compra_id_foreign` (`dc_orden_compra_id`),
  CONSTRAINT `dc_ov_ocs_dc_orden_compra_id_foreign` FOREIGN KEY (`dc_orden_compra_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ov_ocs_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_ocs`
--

LOCK TABLES `dc_ov_ocs` WRITE;
/*!40000 ALTER TABLE `dc_ov_ocs` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_ocs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_origenes`
--

DROP TABLE IF EXISTS `dc_ov_origenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_origenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_origenes`
--

LOCK TABLES `dc_ov_origenes` WRITE;
/*!40000 ALTER TABLE `dc_ov_origenes` DISABLE KEYS */;
INSERT INTO `dc_ov_origenes` VALUES (1,NULL,'Taller',1,NULL,NULL,NULL),(2,NULL,'Comercial',1,NULL,NULL,NULL),(3,NULL,'Repuestos',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_ov_origenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_origenes_users`
--

DROP TABLE IF EXISTS `dc_ov_origenes_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_origenes_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dc_ov_origen_id` bigint(20) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_origenes_users_dc_ov_origen_id_foreign` (`dc_ov_origen_id`),
  CONSTRAINT `dc_ov_origenes_users_dc_ov_origen_id_foreign` FOREIGN KEY (`dc_ov_origen_id`) REFERENCES `dc_ov_origenes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_origenes_users`
--

LOCK TABLES `dc_ov_origenes_users` WRITE;
/*!40000 ALTER TABLE `dc_ov_origenes_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_origenes_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_ots`
--

DROP TABLE IF EXISTS `dc_ov_ots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_ots` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `ot_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_ots_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ov_ots_ot_id_foreign` (`ot_id`),
  CONSTRAINT `dc_ov_ots_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ov_ots_ot_id_foreign` FOREIGN KEY (`ot_id`) REFERENCES `inv_orden_trabajos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_ots`
--

LOCK TABLES `dc_ov_ots` WRITE;
/*!40000 ALTER TABLE `dc_ov_ots` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_ots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_pres_clientes`
--

DROP TABLE IF EXISTS `dc_ov_pres_clientes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_pres_clientes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_pres_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_pres_clientes_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ov_pres_clientes_dc_orden_pres_id_foreign` (`dc_orden_pres_id`),
  CONSTRAINT `dc_ov_pres_clientes_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ov_pres_clientes_dc_orden_pres_id_foreign` FOREIGN KEY (`dc_orden_pres_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_pres_clientes`
--

LOCK TABLES `dc_ov_pres_clientes` WRITE;
/*!40000 ALTER TABLE `dc_ov_pres_clientes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_pres_clientes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_rem_clientes`
--

DROP TABLE IF EXISTS `dc_ov_rem_clientes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_rem_clientes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_rem_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_rem_clientes_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ov_rem_clientes_dc_orden_rem_id_foreign` (`dc_orden_rem_id`),
  CONSTRAINT `dc_ov_rem_clientes_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ov_rem_clientes_dc_orden_rem_id_foreign` FOREIGN KEY (`dc_orden_rem_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_rem_clientes`
--

LOCK TABLES `dc_ov_rem_clientes` WRITE;
/*!40000 ALTER TABLE `dc_ov_rem_clientes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_rem_clientes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_remc_occ`
--

DROP TABLE IF EXISTS `dc_ov_remc_occ`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_remc_occ` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `dc_orden_id` bigint(20) unsigned DEFAULT NULL,
  `dc_orden_detail_id` bigint(20) unsigned DEFAULT NULL,
  `dc_occ_id` bigint(20) unsigned DEFAULT NULL,
  `dc_occ_detail_id` bigint(20) unsigned DEFAULT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_remc_occ_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ov_remc_occ_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ov_remc_occ_dc_occ_id_foreign` (`dc_occ_id`),
  KEY `dc_ov_remc_occ_dc_occ_detail_id_foreign` (`dc_occ_detail_id`),
  CONSTRAINT `dc_ov_remc_occ_dc_occ_detail_id_foreign` FOREIGN KEY (`dc_occ_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ov_remc_occ_dc_occ_id_foreign` FOREIGN KEY (`dc_occ_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ov_remc_occ_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ov_remc_occ_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_remc_occ`
--

LOCK TABLES `dc_ov_remc_occ` WRITE;
/*!40000 ALTER TABLE `dc_ov_remc_occ` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_remc_occ` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_sol_facturacion`
--

DROP TABLE IF EXISTS `dc_ov_sol_facturacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_sol_facturacion` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_sol_facturacion_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_sol_facturacion_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ov_sol_facturacion_dc_sol_facturacion_id_foreign` (`dc_sol_facturacion_id`),
  CONSTRAINT `dc_ov_sol_facturacion_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ov_sol_facturacion_dc_sol_facturacion_id_foreign` FOREIGN KEY (`dc_sol_facturacion_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_sol_facturacion`
--

LOCK TABLES `dc_ov_sol_facturacion` WRITE;
/*!40000 ALTER TABLE `dc_ov_sol_facturacion` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_sol_facturacion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_status_cobranza`
--

DROP TABLE IF EXISTS `dc_ov_status_cobranza`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_status_cobranza` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_status_cobranza`
--

LOCK TABLES `dc_ov_status_cobranza` WRITE;
/*!40000 ALTER TABLE `dc_ov_status_cobranza` DISABLE KEYS */;
INSERT INTO `dc_ov_status_cobranza` VALUES (1,NULL,'Pendiente',1,NULL,NULL,NULL),(2,NULL,'Parcial',1,NULL,NULL,NULL),(3,NULL,'Completa',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_ov_status_cobranza` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_status_entrega`
--

DROP TABLE IF EXISTS `dc_ov_status_entrega`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_status_entrega` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_status_entrega`
--

LOCK TABLES `dc_ov_status_entrega` WRITE;
/*!40000 ALTER TABLE `dc_ov_status_entrega` DISABLE KEYS */;
INSERT INTO `dc_ov_status_entrega` VALUES (1,NULL,'Pendiente',1,NULL,NULL,NULL),(2,NULL,'Parcial',1,NULL,NULL,NULL),(3,NULL,'Completa',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_ov_status_entrega` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_status_factura`
--

DROP TABLE IF EXISTS `dc_ov_status_factura`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_status_factura` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_status_factura`
--

LOCK TABLES `dc_ov_status_factura` WRITE;
/*!40000 ALTER TABLE `dc_ov_status_factura` DISABLE KEYS */;
INSERT INTO `dc_ov_status_factura` VALUES (1,NULL,'Pendiente',1,NULL,NULL,NULL),(2,NULL,'Facturable',1,NULL,NULL,NULL),(3,NULL,'Facturado Parcialmente',1,NULL,NULL,NULL),(4,NULL,'Facturado Totalmente',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_ov_status_factura` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_status_venta`
--

DROP TABLE IF EXISTS `dc_ov_status_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_status_venta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_status_venta`
--

LOCK TABLES `dc_ov_status_venta` WRITE;
/*!40000 ALTER TABLE `dc_ov_status_venta` DISABLE KEYS */;
INSERT INTO `dc_ov_status_venta` VALUES (1,NULL,'Pendiente',1,NULL,NULL,NULL),(2,NULL,'Presupuesto',1,NULL,NULL,NULL),(3,NULL,'Venta',1,NULL,NULL,NULL),(4,NULL,'Rechazada',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_ov_status_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_sol_fac_occ`
--

DROP TABLE IF EXISTS `dc_sol_fac_occ`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_sol_fac_occ` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL COMMENT 'Solicitud Facturación (tipo 21)',
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL COMMENT 'Detalle de SF',
  `dc_occ_id` bigint(20) unsigned NOT NULL COMMENT 'OC Cliente (tipo 20)',
  `dc_occ_detail_id` bigint(20) unsigned NOT NULL COMMENT 'Detalle de OCC',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_sf` (`dc_orden_id`),
  KEY `idx_occ` (`dc_occ_id`),
  KEY `dc_sol_fac_occ_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_sol_fac_occ_dc_occ_detail_id_foreign` (`dc_occ_detail_id`),
  CONSTRAINT `dc_sol_fac_occ_dc_occ_detail_id_foreign` FOREIGN KEY (`dc_occ_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_sol_fac_occ_dc_occ_id_foreign` FOREIGN KEY (`dc_occ_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_sol_fac_occ_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_sol_fac_occ_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_sol_fac_occ`
--

LOCK TABLES `dc_sol_fac_occ` WRITE;
/*!40000 ALTER TABLE `dc_sol_fac_occ` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_sol_fac_occ` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `despachos`
--

DROP TABLE IF EXISTS `despachos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `despachos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL,
  `fecha` datetime NOT NULL DEFAULT '2025-04-28 16:15:00',
  `is_ponderacion_autom` tinyint(1) NOT NULL DEFAULT '1',
  `is_garantia` tinyint(1) NOT NULL DEFAULT '0',
  `numero` int(10) unsigned DEFAULT NULL,
  `comentario` longtext COLLATE utf8mb4_unicode_ci,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_parte_1` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_parte_2` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_parte_3` decimal(16,2) NOT NULL DEFAULT '0.00',
  `cotizacion` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `despachos_person_id_foreign` (`person_id`),
  KEY `despachos_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `despachos_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `despachos_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `despachos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `despachos_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `despachos`
--

LOCK TABLES `despachos` WRITE;
/*!40000 ALTER TABLE `despachos` DISABLE KEYS */;
/*!40000 ALTER TABLE `despachos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `despachos_cierres`
--

DROP TABLE IF EXISTS `despachos_cierres`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `despachos_cierres` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `despacho_id` bigint(20) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `costo_antes` decimal(16,2) NOT NULL DEFAULT '0.00',
  `cantidades` decimal(16,2) DEFAULT '0.00',
  `precio_x_cantidad` decimal(16,2) DEFAULT '0.00',
  `ratio` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `incremento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `incremento_x_cantidad` decimal(16,2) DEFAULT '0.00',
  `costo_despues` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `despachos_cierres_despacho_id_foreign` (`despacho_id`),
  KEY `despachos_cierres_receipt_id_foreign` (`receipt_id`),
  KEY `despachos_cierres_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `despachos_cierres_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `despachos_cierres_inv_producto_id_foreign` (`inv_producto_id`),
  CONSTRAINT `despachos_cierres_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `despachos_cierres_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `despachos_cierres_despacho_id_foreign` FOREIGN KEY (`despacho_id`) REFERENCES `despachos` (`id`),
  CONSTRAINT `despachos_cierres_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `despachos_cierres_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `despachos_cierres`
--

LOCK TABLES `despachos_cierres` WRITE;
/*!40000 ALTER TABLE `despachos_cierres` DISABLE KEYS */;
/*!40000 ALTER TABLE `despachos_cierres` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `despachos_details`
--

DROP TABLE IF EXISTS `despachos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `despachos_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `despacho_id` bigint(20) unsigned NOT NULL,
  `despacho_parte_id` bigint(20) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `porcentaje_ponderacion` decimal(8,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `despachos_details_despacho_id_foreign` (`despacho_id`),
  KEY `despachos_details_despacho_parte_id_foreign` (`despacho_parte_id`),
  KEY `despachos_details_receipt_id_foreign` (`receipt_id`),
  CONSTRAINT `despachos_details_despacho_id_foreign` FOREIGN KEY (`despacho_id`) REFERENCES `despachos` (`id`),
  CONSTRAINT `despachos_details_despacho_parte_id_foreign` FOREIGN KEY (`despacho_parte_id`) REFERENCES `despachos_partes` (`id`),
  CONSTRAINT `despachos_details_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `despachos_details`
--

LOCK TABLES `despachos_details` WRITE;
/*!40000 ALTER TABLE `despachos_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `despachos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `despachos_files`
--

DROP TABLE IF EXISTS `despachos_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `despachos_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `despacho_id` bigint(20) unsigned NOT NULL,
  `descripcion` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name_original` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `despachos_files_despacho_id_foreign` (`despacho_id`),
  CONSTRAINT `despachos_files_despacho_id_foreign` FOREIGN KEY (`despacho_id`) REFERENCES `despachos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `despachos_files`
--

LOCK TABLES `despachos_files` WRITE;
/*!40000 ALTER TABLE `despachos_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `despachos_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `despachos_partes`
--

DROP TABLE IF EXISTS `despachos_partes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `despachos_partes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `despachos_partes`
--

LOCK TABLES `despachos_partes` WRITE;
/*!40000 ALTER TABLE `despachos_partes` DISABLE KEYS */;
INSERT INTO `despachos_partes` VALUES (1,NULL,'Facturas del Proveedor',1,NULL,NULL,NULL),(2,NULL,'Despachos de Importacion',1,NULL,NULL,NULL),(3,NULL,'Facturas de Logistica',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `despachos_partes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `deudas_impositivas`
--

DROP TABLE IF EXISTS `deudas_impositivas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `deudas_impositivas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `vto_impuesto_id` int(10) unsigned NOT NULL,
  `periodo_deuda` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `deudas_impositivas_vto_impuesto_id_foreign` (`vto_impuesto_id`),
  KEY `deudas_impositivas_person_id_foreign` (`person_id`),
  CONSTRAINT `deudas_impositivas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `deudas_impositivas_vto_impuesto_id_foreign` FOREIGN KEY (`vto_impuesto_id`) REFERENCES `vto_impuestos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `deudas_impositivas`
--

LOCK TABLES `deudas_impositivas` WRITE;
/*!40000 ALTER TABLE `deudas_impositivas` DISABLE KEYS */;
/*!40000 ALTER TABLE `deudas_impositivas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ejer_anteriores`
--

DROP TABLE IF EXISTS `ejer_anteriores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ejer_anteriores` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `anio` int(11) NOT NULL,
  `ventas` decimal(16,2) DEFAULT NULL,
  `compras` decimal(16,2) DEFAULT NULL,
  `sueldos` decimal(16,2) DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `apagar` decimal(16,2) DEFAULT NULL,
  `afavor` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ejer_anteriores_person_id_foreign` (`person_id`),
  CONSTRAINT `ejer_anteriores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ejer_anteriores`
--

LOCK TABLES `ejer_anteriores` WRITE;
/*!40000 ALTER TABLE `ejer_anteriores` DISABLE KEYS */;
/*!40000 ALTER TABLE `ejer_anteriores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estado_civil`
--

DROP TABLE IF EXISTS `estado_civil`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estado_civil` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `estado_civil_descripcion_unique` (`descripcion`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estado_civil`
--

LOCK TABLES `estado_civil` WRITE;
/*!40000 ALTER TABLE `estado_civil` DISABLE KEYS */;
INSERT INTO `estado_civil` VALUES (1,NULL,'Separado Legal',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(2,NULL,'Separado de Hecho',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(3,NULL,'Divorciado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(4,NULL,'Convivencia',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(5,NULL,'Soltero',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(6,NULL,'Casado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(7,NULL,'Viudo',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `estado_civil` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva`
--

DROP TABLE IF EXISTS `fa_masiva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva`
--

LOCK TABLES `fa_masiva` WRITE;
/*!40000 ALTER TABLE `fa_masiva` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_detalle`
--

DROP TABLE IF EXISTS `fa_masiva_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_detalle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fa_masiva_id` int(11) NOT NULL,
  `cliente_id` int(11) NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL DEFAULT '1',
  `zone_id` int(10) unsigned NOT NULL DEFAULT '22',
  `activity_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `concepto_id` int(10) unsigned NOT NULL DEFAULT '1',
  `taxable_iibb` int(10) unsigned NOT NULL DEFAULT '2',
  `renglon1` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe1` decimal(20,2) DEFAULT NULL,
  `renglon2` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe2` decimal(20,2) DEFAULT NULL,
  `renglon3` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe3` decimal(20,2) DEFAULT NULL,
  `punto_venta_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date DEFAULT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_detalle_concepto_id_foreign` (`concepto_id`),
  KEY `fa_masiva_detalle_system_tax_id_foreign` (`system_tax_id`),
  KEY `fa_masiva_detalle_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  KEY `fa_masiva_detalle_zone_id_foreign` (`zone_id`),
  KEY `fa_masiva_detalle_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fa_masiva_detalle_activity_id_foreign` (`activity_id`),
  CONSTRAINT `fa_masiva_detalle_activity_id_foreign` FOREIGN KEY (`activity_id`) REFERENCES `activities` (`id`),
  CONSTRAINT `fa_masiva_detalle_concepto_id_foreign` FOREIGN KEY (`concepto_id`) REFERENCES `fact_elec_conceptos_afip` (`id`),
  CONSTRAINT `fa_masiva_detalle_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `fac_elec_cond_frente_iva` (`id`),
  CONSTRAINT `fa_masiva_detalle_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`),
  CONSTRAINT `fa_masiva_detalle_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`),
  CONSTRAINT `fa_masiva_detalle_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_detalle`
--

LOCK TABLES `fa_masiva_detalle` WRITE;
/*!40000 ALTER TABLE `fa_masiva_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_stock`
--

DROP TABLE IF EXISTS `fa_masiva_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_stock_person_id_foreign` (`person_id`),
  KEY `fa_masiva_stock_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `fa_masiva_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fa_masiva_stock_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_stock`
--

LOCK TABLES `fa_masiva_stock` WRITE;
/*!40000 ALTER TABLE `fa_masiva_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_cond_frente_iva`
--

DROP TABLE IF EXISTS `fac_elec_cond_frente_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_cond_frente_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_cond_frente_iva_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_cond_frente_iva`
--

LOCK TABLES `fac_elec_cond_frente_iva` WRITE;
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` DISABLE KEYS */;
INSERT INTO `fac_elec_cond_frente_iva` VALUES (1,'IVA Responsable Inscripto','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'IVA Sujeto Exento','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Consumidor Final','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Responsable Monotributo','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Proveedor del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Cliente del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'IVA Liberado - Ley Nº 19.640','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'IVA Responsable Inscripto - Agente de Percepción','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Monotributista Social','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'IVA No Alcanzado','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_unidad_medidas`
--

DROP TABLE IF EXISTS `fac_elec_unidad_medidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_unidad_medidas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_unidad_medidas_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_unidad_medidas`
--

LOCK TABLES `fac_elec_unidad_medidas` WRITE;
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` DISABLE KEYS */;
INSERT INTO `fac_elec_unidad_medidas` VALUES (1,'Grs','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'Kg','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Mts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Mts2','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Mts3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Lts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'1000 Kwh','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'Unidades','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Pares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'Doc','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(11,'Quilates','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(12,'Millares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(13,'Milimetros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(14,'Mm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(15,'Km','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(16,'Hectolitros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(17,'Cm','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(18,'Cm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_conceptos_afip`
--

DROP TABLE IF EXISTS `fact_elec_conceptos_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_conceptos_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_comprobante_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_conceptos_afip`
--

LOCK TABLES `fact_elec_conceptos_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_conceptos_afip` VALUES (1,1,'Producto','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'Productos y Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_perc_ret`
--

DROP TABLE IF EXISTS `fact_elec_perc_ret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_perc_ret` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` int(10) unsigned NOT NULL,
  `other_tax_id` int(10) unsigned NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_perc_ret_other_tax_id_foreign` (`other_tax_id`),
  CONSTRAINT `fact_elec_perc_ret_other_tax_id_foreign` FOREIGN KEY (`other_tax_id`) REFERENCES `other_taxes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_perc_ret`
--

LOCK TABLES `fact_elec_perc_ret` WRITE;
/*!40000 ALTER TABLE `fact_elec_perc_ret` DISABLE KEYS */;
INSERT INTO `fact_elec_perc_ret` VALUES (1,NULL,'Per./Ret de Imp. a las Ganancias',1,1032,1,NULL,NULL,NULL),(2,NULL,'Per./Ret de IVA',1,1000,1,NULL,NULL,NULL),(3,NULL,'Per./Ret de IIBB',2,1006,1,NULL,NULL,NULL),(4,NULL,'Impuestos Internos',4,1001,1,NULL,NULL,NULL),(5,NULL,'Impuestos Municipales',3,1031,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `fact_elec_perc_ret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_perc_ret_details`
--

DROP TABLE IF EXISTS `fact_elec_perc_ret_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_perc_ret_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fact_elec_perc_ret_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `detalle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zone_id` int(10) unsigned DEFAULT NULL,
  `base_imponible` decimal(16,2) DEFAULT NULL,
  `alicuota` decimal(16,2) DEFAULT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_perc_ret_details_fact_elec_perc_ret_id_foreign` (`fact_elec_perc_ret_id`),
  KEY `fact_elec_perc_ret_details_person_id_foreign` (`person_id`),
  KEY `fact_elec_perc_ret_details_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `fact_elec_perc_ret_details_zone_id_foreign` (`zone_id`),
  CONSTRAINT `fact_elec_perc_ret_details_fact_elec_perc_ret_id_foreign` FOREIGN KEY (`fact_elec_perc_ret_id`) REFERENCES `fact_elec_perc_ret` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_perc_ret_details`
--

LOCK TABLES `fact_elec_perc_ret_details` WRITE;
/*!40000 ALTER TABLE `fact_elec_perc_ret_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_perc_ret_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_puntos_venta`
--

DROP TABLE IF EXISTS `fact_elec_puntos_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_puntos_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `direccion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `codigo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '0000',
  `codigo_postal` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_puntos_venta_person_id_foreign` (`person_id`),
  CONSTRAINT `fact_elec_puntos_venta_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_puntos_venta`
--

LOCK TABLES `fact_elec_puntos_venta` WRITE;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipt_details`
--

DROP TABLE IF EXISTS `fact_elec_receipt_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipt_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cantidad` decimal(20,2) NOT NULL,
  `unidad_medida` text COLLATE utf8mb4_unicode_ci,
  `precio_unitario` decimal(20,2) NOT NULL,
  `neto_gravado` decimal(20,2) NOT NULL,
  `bonificacion_porcentaje` decimal(20,2) DEFAULT NULL,
  `bonificacion_monto` decimal(20,2) DEFAULT NULL,
  `bonificacion_subtotal` decimal(20,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `iva_monto` decimal(20,2) DEFAULT NULL,
  `iva_subtotal` decimal(20,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `codigo` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipt_details_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `fact_elec_receipt_details_system_tax_id_foreign` (`system_tax_id`),
  CONSTRAINT `fact_elec_receipt_details_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `fact_elec_receipt_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipt_details`
--

LOCK TABLES `fact_elec_receipt_details` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipt_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_receipt_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipts`
--

DROP TABLE IF EXISTS `fact_elec_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date NOT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `concepto_id` int(10) unsigned NOT NULL,
  `punto_venta_id` int(10) unsigned NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL,
  `condiciones_venta` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comprobante_asoc` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `cae` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cae_vencimiento` date DEFAULT NULL,
  `nro_comprobante_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_proceso_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_receptor` int(10) unsigned NOT NULL,
  `condicion_venta_id` int(11) DEFAULT NULL,
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `opcion_transferencia` longtext COLLATE utf8mb4_unicode_ci,
  `referencia` text COLLATE utf8mb4_unicode_ci,
  `alias_cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_otros_tributos` decimal(16,2) DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipts_user_id_foreign` (`user_id`),
  KEY `fact_elec_receipts_punto_venta_id_foreign` (`punto_venta_id`),
  KEY `fact_elec_receipts_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fact_elec_receipts_person_id_foreign` (`person_id`),
  KEY `fact_elec_receipts_person_id_receptor_foreign` (`person_id_receptor`),
  KEY `fact_elec_receipts_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  KEY `fact_elec_receipts_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `fact_elec_receipts_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `condicion_frente_al_iva` (`id`),
  CONSTRAINT `fact_elec_receipts_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_receptor_foreign` FOREIGN KEY (`person_id_receptor`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_punto_venta_id_foreign` FOREIGN KEY (`punto_venta_id`) REFERENCES `fact_elec_puntos_venta` (`id`),
  CONSTRAINT `fact_elec_receipts_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipts`
--

LOCK TABLES `fact_elec_receipts` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipts` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_receipts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_tipos_docs_afip`
--

DROP TABLE IF EXISTS `fact_elec_tipos_docs_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_tipos_docs_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_tipo_doc_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_tipos_docs_afip`
--

LOCK TABLES `fact_elec_tipos_docs_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_tipos_docs_afip` VALUES (1,1,'CI Buenos Aires','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'CI Catamarca','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'CI Córdoba','2019-03-13 13:29:34','2019-03-13 13:29:34'),(4,4,'CI Corrientes','2019-03-13 13:29:34','2019-03-13 13:29:34'),(5,5,'CI Entre Ríos','2019-03-13 13:29:34','2019-03-13 13:29:34'),(6,6,'CI Jujuy','2019-03-13 13:29:34','2019-03-13 13:29:34'),(7,7,'CI Mendoza','2019-03-13 13:29:34','2019-03-13 13:29:34'),(8,8,'CI La Rioja','2019-03-13 13:29:34','2019-03-13 13:29:34'),(9,9,'CI Salta','2019-03-13 13:29:34','2019-03-13 13:29:34'),(10,10,'CI San Juan','2019-03-13 13:29:34','2019-03-13 13:29:34'),(11,11,'CI San Luis','2019-03-13 13:29:34','2019-03-13 13:29:34'),(12,12,'CI Santa Fe','2019-03-13 13:29:34','2019-03-13 13:29:34'),(13,13,'CI Santiago del Estero','2019-03-13 13:29:34','2019-03-13 13:29:34'),(14,14,'CI Tucumán','2019-03-13 13:29:34','2019-03-13 13:29:34'),(16,16,'CI Chaco','2019-03-13 13:29:34','2019-03-13 13:29:34'),(17,17,'CI Chubut','2019-03-13 13:29:34','2019-03-13 13:29:34'),(18,18,'CI Formosa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(19,19,'CI Misiones','2019-03-13 13:29:34','2019-03-13 13:29:34'),(20,20,'CI Neuquén','2019-03-13 13:29:34','2019-03-13 13:29:34'),(21,21,'CI La Pampa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(22,22,'CI Río Negro','2019-03-13 13:29:34','2019-03-13 13:29:34'),(23,23,'CI Santa Cruz','2019-03-13 13:29:34','2019-03-13 13:29:34'),(24,24,'CI Tierra del Fuego','2019-03-13 13:29:34','2019-03-13 13:29:34'),(80,80,'CUIT','2019-03-13 13:29:34','2019-03-13 13:29:34'),(86,86,'CUIL','2019-03-13 13:29:34','2019-03-13 13:29:34'),(87,87,'CDI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(89,89,'LE','2019-03-13 13:29:34','2019-03-13 13:29:34'),(90,90,'LC','2019-03-13 13:29:34','2019-03-13 13:29:34'),(91,91,'CI Extranjera','2019-03-13 13:29:34','2019-03-13 13:29:34'),(92,92,'en trámite','2019-03-13 13:29:34','2019-03-13 13:29:34'),(93,93,'Acta Nacimiento','2019-03-13 13:29:34','2019-03-13 13:29:34'),(94,94,'Pasaporte','2019-03-13 13:29:34','2019-03-13 13:29:34'),(95,95,'CI Bs. As. RNP','2019-03-13 13:29:34','2019-03-13 13:29:34'),(96,96,'DNI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(97,0,'CI Policía Federal','2019-03-13 13:29:34','2019-03-13 13:29:34'),(99,99,'Doc. (Otro)','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq`
--

DROP TABLE IF EXISTS `faq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `faq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pregunta` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `respuesta` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq`
--

LOCK TABLES `faq` WRITE;
/*!40000 ALTER TABLE `faq` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_upload_details`
--

DROP TABLE IF EXISTS `file_upload_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_upload_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `file_upload_id` int(10) unsigned NOT NULL,
  `detail` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_upload_details_file_upload_id_foreign` (`file_upload_id`),
  CONSTRAINT `file_upload_details_file_upload_id_foreign` FOREIGN KEY (`file_upload_id`) REFERENCES `file_uploads` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_upload_details`
--

LOCK TABLES `file_upload_details` WRITE;
/*!40000 ALTER TABLE `file_upload_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_upload_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_uploads`
--

DROP TABLE IF EXISTS `file_uploads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_uploads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `data_type_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_uploads_data_type_id_foreign` (`data_type_id`),
  KEY `file_uploads_user_id_foreign` (`user_id`),
  KEY `file_uploads_person_id_foreign` (`person_id`),
  KEY `file_uploads_period_id_foreign` (`period_id`),
  CONSTRAINT `file_uploads_data_type_id_foreign` FOREIGN KEY (`data_type_id`) REFERENCES `data_types` (`id`),
  CONSTRAINT `file_uploads_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `file_uploads_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `file_uploads_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `tusers` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_uploads`
--

LOCK TABLES `file_uploads` WRITE;
/*!40000 ALTER TABLE `file_uploads` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_uploads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `forma_de_entrega`
--

DROP TABLE IF EXISTS `forma_de_entrega`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `forma_de_entrega` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `forma_de_entrega_person_id_foreign` (`person_id`),
  CONSTRAINT `forma_de_entrega_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `forma_de_entrega`
--

LOCK TABLES `forma_de_entrega` WRITE;
/*!40000 ALTER TABLE `forma_de_entrega` DISABLE KEYS */;
/*!40000 ALTER TABLE `forma_de_entrega` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_art_90`
--

DROP TABLE IF EXISTS `ganan_art_90`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_art_90` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,2) NOT NULL DEFAULT '0.00',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_art_90`
--

LOCK TABLES `ganan_art_90` WRITE;
/*!40000 ALTER TABLE `ganan_art_90` DISABLE KEYS */;
INSERT INTO `ganan_art_90` VALUES (1,2017,0.00,20000.00,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,2017,20000.00,40000.00,1000.00,0.09,20000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,2017,40000.00,60000.00,2800.00,0.12,40000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(4,2017,60000.00,80000.00,5200.00,0.15,60000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(5,2017,80000.00,120000.00,8200.00,0.19,80000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(6,2017,120000.00,160000.00,15800.00,0.23,120000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(7,2017,160000.00,240000.00,25000.00,0.27,160000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(8,2017,240000.00,320000.00,46600.00,0.31,240000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(9,2017,320000.00,999999999.99,71400.00,0.35,320000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(10,2018,0.00,25754.00,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(11,2018,25754.00,51508.00,1287.70,0.09,25754.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(12,2018,51508.00,77262.00,3605.56,0.12,51508.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(13,2018,77262.00,103016.00,6696.04,0.15,77262.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(14,2018,103016.00,154524.00,10559.14,0.19,103016.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(15,2018,154524.00,206032.00,20345.66,0.23,154524.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(16,2018,206032.00,309048.00,32192.50,0.27,206032.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(17,2018,309048.00,412064.00,60006.82,0.31,309048.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(18,2018,412064.00,999999999.99,91941.78,0.35,412064.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(19,2019,0.00,33039.81,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(20,2019,33039.81,66079.61,1651.99,0.09,33039.81,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(21,2019,66079.61,99119.42,4625.57,0.12,66079.61,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(22,2019,99119.42,132159.23,8590.35,0.15,99119.42,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(23,2019,132159.23,198238.84,13546.32,0.19,132159.23,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(24,2019,198238.84,264318.45,26101.45,0.23,198238.84,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(25,2019,264318.45,396477.68,41299.76,0.27,264318.45,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(26,2019,396477.68,528636.91,76982.75,0.31,396477.68,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(27,2019,528636.91,999999999.99,117952.11,0.35,528636.91,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(28,2016,0.00,10000.00,0.00,0.09,0.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(29,2016,10000.00,20000.00,900.00,0.14,10000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(30,2016,20000.00,30000.00,2300.00,0.19,20000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(31,2016,30000.00,60000.00,4200.00,0.23,30000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(32,2016,60000.00,90000.00,11100.00,0.27,60000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(33,2016,90000.00,120000.00,19200.00,0.31,90000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(34,2016,120000.00,999999999.00,28500.00,0.35,120000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(37,2020,0.00,47669.16,0.00,0.05,0.00,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(38,2020,47669.16,95338.32,2383.46,0.09,47669.16,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(39,2020,95338.32,143007.48,6673.68,0.12,95338.32,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(40,2020,143007.48,190676.65,12393.98,0.15,143007.48,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(41,2020,190676.65,286014.96,19544.36,0.19,190676.65,'2020-01-28 14:17:39','2022-11-09 14:46:54',NULL),(42,2020,286014.96,381353.28,37658.64,0.23,286014.96,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL);
INSERT INTO `ganan_art_90` VALUES (43,2020,381353.28,572029.92,59586.45,0.27,381353.28,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(44,2020,572029.92,762706.57,111069.14,0.31,572029.92,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(45,2020,762706.57,999999999.99,170178.90,0.35,762706.57,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(46,2021,0.00,64532.64,0.00,0.05,0.00,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(47,2021,64532.64,129065.29,3226.63,0.09,64532.64,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(48,2021,129065.29,193597.93,9034.57,0.12,129065.29,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(49,2021,193597.93,258130.58,16778.49,0.15,193597.93,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(50,2021,258130.58,387195.86,26458.39,0.19,258130.58,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(51,2021,387195.86,516261.14,50980.79,0.23,387195.86,'2022-11-09 14:46:55','2022-11-09 14:47:06',NULL),(52,2021,516261.14,774391.71,80665.80,0.27,516261.14,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(53,2021,774391.71,1032522.30,150361.06,0.31,774391.71,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(54,2021,1032522.30,999999999.99,230381.54,0.35,1032522.30,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(55,2022,0.00,97201.99,0.00,0.05,0.00,'2022-11-09 14:46:59','2022-11-09 14:47:00',NULL),(56,2022,97201.99,194404.01,4860.10,0.09,97201.99,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(57,2022,194404.01,291606.01,13608.29,0.12,194404.01,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(58,2022,291606.01,388808.02,25272.52,0.15,291606.01,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(59,2022,388808.02,583212.02,39852.82,0.19,388808.02,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(60,2022,583212.02,777616.02,76789.59,0.23,583212.02,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(61,2022,777616.02,1166424.03,121502.49,0.27,777616.02,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(62,2022,1166424.03,1555232.07,226480.67,0.31,1166424.03,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(63,2022,1555232.07,999999999.99,347011.15,0.35,1555232.07,'2022-11-09 14:46:59','2023-06-27 10:55:58',NULL),(64,2023,0.00,1400000.00,0.00,0.00,0.00,'2022-12-28 17:50:41','2023-09-25 21:58:23',NULL),(65,2023,1400000.00,1526000.00,0.00,0.09,1400000.00,'2022-12-28 17:50:41','2023-09-25 21:58:23',NULL),(66,2023,1526000.00,1648080.00,11340.00,0.12,1526000.00,'2022-12-28 17:50:41','2023-09-25 21:58:23',NULL),(67,2023,1648080.00,1763445.60,25989.60,0.15,1648080.00,'2022-12-28 17:50:41','2023-09-25 21:58:23',NULL),(68,2023,1763445.60,1869252.34,43294.44,0.19,1763445.60,'2022-12-28 17:50:41','2023-09-25 21:58:23',NULL),(69,2023,1869252.34,1962714.95,63397.72,0.23,1869252.34,'2022-12-28 17:50:41','2023-09-25 21:58:23',NULL),(70,2023,1962714.95,2041223.55,84894.12,0.27,1962714.95,'2022-12-28 17:50:41','2023-09-25 21:58:23',NULL),(71,2023,2041223.55,2102460.26,106091.44,0.31,2041223.55,'2022-12-28 17:50:41','2023-09-25 21:58:23',NULL),(72,2023,2102460.26,999999999.00,125074.82,0.35,2102460.26,'2022-12-28 17:50:41','2023-09-25 21:58:23',NULL),(73,2024,0.00,1360200.00,0.00,0.05,0.00,NULL,NULL,NULL),(74,2024,1360200.00,2720400.00,68010.00,0.09,1360200.00,NULL,NULL,NULL),(75,2024,2720400.00,4080600.00,190428.00,0.12,2720400.00,NULL,NULL,NULL),(76,2024,4080600.00,6120900.00,353652.00,0.15,4080600.00,NULL,NULL,NULL),(77,2024,6120900.00,12241800.00,659697.00,0.19,6120900.00,NULL,NULL,NULL),(78,2024,12241800.00,18362700.00,1822668.00,0.23,12241800.00,NULL,NULL,NULL),(79,2024,18362700.00,27544050.00,3230475.00,0.27,18362700.00,NULL,NULL,NULL),(80,2024,27544050.00,41316075.00,5709439.50,0.31,27544050.00,NULL,NULL,NULL),(81,2024,41316075.00,9999999999.00,9978767.25,0.35,41316075.00,NULL,NULL,NULL),(82,2025,0.00,1520371.67,0.00,0.05,0.00,NULL,NULL,NULL),(83,2025,1520371.67,3040743.34,76018.58,0.09,1520371.67,NULL,NULL,NULL),(84,2025,3040743.34,4561115.01,212852.03,0.12,3040743.34,NULL,NULL,NULL);
INSERT INTO `ganan_art_90` VALUES (85,2025,4561115.01,6841672.52,395296.63,0.15,4561115.01,NULL,NULL,NULL),(86,2025,6841672.52,13683345.04,737380.26,0.19,6841672.52,NULL,NULL,NULL),(87,2025,13683345.04,20525017.56,2037298.04,0.23,13683345.04,NULL,NULL,NULL),(88,2025,20525017.56,30787526.34,3610882.72,0.27,20525017.56,NULL,NULL,NULL),(89,2025,30787526.34,46181289.52,6381760.09,0.31,30787526.34,NULL,NULL,NULL),(90,2025,46181289.52,999999999999.00,11153826.67,0.35,46181289.52,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ganan_art_90` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_categorias`
--

DROP TABLE IF EXISTS `ganan_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_categorias`
--

LOCK TABLES `ganan_categorias` WRITE;
/*!40000 ALTER TABLE `ganan_categorias` DISABLE KEYS */;
INSERT INTO `ganan_categorias` VALUES (1,'Primera',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(2,'Segunda',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(3,'Tercera',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(4,'Cuarta',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
/*!40000 ALTER TABLE `ganan_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_conceptos_anticipos`
--

DROP TABLE IF EXISTS `ganan_conceptos_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_conceptos_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ganan_conceptos_anticipos_nombre_unique` (`nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_conceptos_anticipos`
--

LOCK TABLES `ganan_conceptos_anticipos` WRITE;
/*!40000 ALTER TABLE `ganan_conceptos_anticipos` DISABLE KEYS */;
INSERT INTO `ganan_conceptos_anticipos` VALUES (1,NULL,'Anticipos',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,NULL,'Retenciones y Percepciones',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,NULL,'Saldo a Favor Anterior',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL);
/*!40000 ALTER TABLE `ganan_conceptos_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_anticipos`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_anticipos_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_anticipos`
--

LOCK TABLES `ganan_ddjj_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_deducciones`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_deducciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_deducciones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_deduccion_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_deducciones_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_deducciones_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_deducciones_ganan_deduccion_id_foreign` (`ganan_deduccion_id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_ganan_deduccion_id_foreign` FOREIGN KEY (`ganan_deduccion_id`) REFERENCES `ganan_deducciones` (`id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_deducciones`
--

LOCK TABLES `ganan_ddjj_detail_deducciones` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_deducciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_deducciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_ing_egr`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_ing_egr`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_ing_egr` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `ganan_categoria_id` int(10) unsigned NOT NULL,
  `ganan_tipo_op_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_ing_egr_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_ing_egr_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_categoria_id_foreign` (`ganan_categoria_id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_tipo_op_id_foreign` (`ganan_tipo_op_id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_categoria_id_foreign` FOREIGN KEY (`ganan_categoria_id`) REFERENCES `ganan_categorias` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_tipo_op_id_foreign` FOREIGN KEY (`ganan_tipo_op_id`) REFERENCES `ganan_tipos_op` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_ing_egr`
--

LOCK TABLES `ganan_ddjj_detail_ing_egr` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_ing_egr` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_ing_egr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjjs`
--

DROP TABLE IF EXISTS `ganan_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ingresos_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `ingresos_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `egresos_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `egresos_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `deducciones_total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `ganan_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjjs`
--

LOCK TABLES `ganan_ddjjs` WRITE;
/*!40000 ALTER TABLE `ganan_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_deducciones`
--

DROP TABLE IF EXISTS `ganan_deducciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_deducciones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `generales` tinyint(1) NOT NULL DEFAULT '0',
  `particulares` tinyint(1) NOT NULL DEFAULT '0',
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=225 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_deducciones`
--

LOCK TABLES `ganan_deducciones` WRITE;
/*!40000 ALTER TABLE `ganan_deducciones` DISABLE KEYS */;
INSERT INTO `ganan_deducciones` VALUES (1,NULL,2017,1,0,'Primas de seguro para el caso de muerte',999.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,NULL,2017,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,NULL,2017,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(4,NULL,2017,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(5,NULL,2017,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(6,NULL,2017,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(7,NULL,2017,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(8,NULL,2017,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(9,NULL,2017,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(10,NULL,2017,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(11,NULL,2017,1,0,'Servicio Doméstico',51967.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(12,NULL,2017,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(13,NULL,2017,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(14,NULL,2017,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(15,NULL,2017,0,1,'Conyuge',48447.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(16,NULL,2017,0,1,'Hijo Incapacitado',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(17,NULL,2017,0,1,'Hijo Menor 18 años',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(18,NULL,2017,0,1,'Hijastro Incapacitado',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(19,NULL,2017,0,1,'Hijastro Menor 18 Años',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(20,NULL,2017,0,1,'Ganancia No Imponible',51967.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(21,NULL,2017,0,1,'Deduccion Especial',51967.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(22,NULL,2018,1,0,'Primas de seguro para el caso de muerte',12000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(23,NULL,2018,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(24,NULL,2018,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(25,NULL,2018,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(26,NULL,2018,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(27,NULL,2018,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(28,NULL,2018,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(29,NULL,2018,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(30,NULL,2018,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
INSERT INTO `ganan_deducciones` VALUES (31,NULL,2018,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(32,NULL,2018,1,0,'Servicio Doméstico',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(33,NULL,2018,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(34,NULL,2018,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(35,NULL,2018,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(36,NULL,2018,0,1,'Conyuge',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(37,NULL,2018,0,1,'Hijo Incapacitado',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(38,NULL,2018,0,1,'Hijo Menor 18 años',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(39,NULL,2018,0,1,'Hijastro Incapacitado',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(40,NULL,2018,0,1,'Hijastro Menor 18 Años',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(41,NULL,2018,0,1,'Ganancia No Imponible',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(42,NULL,2018,0,1,'Deduccion Especial',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(43,NULL,2019,1,0,'Primas de seguro para el caso de muerte',18000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(44,NULL,2019,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(45,NULL,2019,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(46,NULL,2019,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(47,NULL,2019,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(48,NULL,2019,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(49,NULL,2019,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(50,NULL,2019,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(51,NULL,2019,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(52,NULL,2019,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(53,NULL,2019,1,0,'Servicio Doméstico',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(54,NULL,2019,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(55,NULL,2019,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(56,NULL,2019,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(57,NULL,2019,0,1,'Conyuge',80033.97,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(58,NULL,2019,0,1,'Hijo Incapacitado',40361.43,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(59,NULL,2019,0,1,'Hijo Menor 18 años',206037.56,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(60,NULL,2019,0,1,'Hijastro Incapacitado',206037.56,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(61,NULL,2019,0,1,'Hijastro Menor 18 Años',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(62,NULL,2019,0,1,'Ganancia No Imponible',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(63,NULL,2019,0,1,'Deduccion Especial',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
INSERT INTO `ganan_deducciones` VALUES (64,NULL,2016,1,0,'Primas de seguro para el caso de muerte',999.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(65,NULL,2016,1,0,'Gastos de Sepelio',999.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(66,NULL,2016,1,0,'Aportes a Obras Sociales',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(67,NULL,2016,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(68,NULL,2016,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(69,NULL,2016,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(70,NULL,2016,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(71,NULL,2016,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(72,NULL,2016,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(73,NULL,2016,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(74,NULL,2016,1,0,'Servicio Doméstico',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(75,NULL,2016,1,0,'Donaciones',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(76,NULL,2016,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(77,NULL,2016,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y \n            Paramédica',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(78,NULL,2016,0,1,'Conyuge',39778.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(79,NULL,2016,0,1,'Hijo Incapacitado',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(80,NULL,2016,0,1,'Hijo Menor 18 años',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(81,NULL,2016,0,1,'Hijastro Incapacitado',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(82,NULL,2016,0,1,'Hijastro Menor 18 Años',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(83,NULL,2016,0,1,'Ganancia No Imponible',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(84,NULL,2016,0,1,'Deduccion Especial',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(85,NULL,2019,1,0,'Alquileres',103018.97,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(86,NULL,2020,1,0,'Alquileres',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(87,NULL,2020,1,0,'Primas de seguro para el caso de muerte',18000.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(88,NULL,2020,1,0,'Gastos de Sepelio',999.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(89,NULL,2020,1,0,'Aportes a Obras Sociales',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(90,NULL,2020,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(91,NULL,2020,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(92,NULL,2020,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(93,NULL,2020,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL);
INSERT INTO `ganan_deducciones` VALUES (94,NULL,2020,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(95,NULL,2020,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(96,NULL,2020,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(97,NULL,2020,1,0,'Servicio Doméstico',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(98,NULL,2020,1,0,'Donaciones',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(99,NULL,2020,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(100,NULL,2020,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(101,NULL,2020,0,1,'Conyuge',115471.38,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(102,NULL,2020,0,1,'Hijo Incapacitado',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(103,NULL,2020,0,1,'Hijo Menor 18 años',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(104,NULL,2020,0,1,'Hijastro Incapacitado',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(105,NULL,2020,0,1,'Hijastro Menor 18 Años',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(106,NULL,2020,0,1,'Ganancia No Imponible',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(107,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 1',103018.79,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(108,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 1 \"Nuevos Profesionales / Emprendedores',309652.93,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(109,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 2',594533.62,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(110,NULL,2021,1,0,'Primas de seguro para el caso de muerte',24000.00,1,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(111,NULL,2021,1,0,'Gastos de Sepelio',996.23,1,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(112,NULL,2021,1,0,'Aportes a Obras Sociales',0.00,1,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(113,NULL,2021,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(114,NULL,2021,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(115,NULL,2021,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(116,NULL,2021,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(117,NULL,2021,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(118,NULL,2021,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(119,NULL,2021,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(120,NULL,2021,1,0,'Servicio Doméstico',167678.40,1,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(121,NULL,2021,1,0,'Donaciones',0.00,1,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(122,NULL,2021,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(123,NULL,2021,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(124,NULL,2021,0,1,'Conyuge',156320.63,1,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(125,NULL,2021,0,1,'Hijo Menor 18 años',78833.08,1,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL);
INSERT INTO `ganan_deducciones` VALUES (126,NULL,2021,0,1,'Ganancia No Imponible',167678.40,1,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(127,NULL,2021,0,1,'Deduccion Especial',804856.34,1,'2022-11-09 14:46:55','2022-11-09 14:46:55',NULL),(128,NULL,2022,1,0,'Primas de seguro para el caso de muerte',24000.00,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(129,NULL,2022,1,0,'Gastos de Sepelio',996.23,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(130,NULL,2022,1,0,'Aportes a Obras Sociales',0.00,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(131,NULL,2022,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(132,NULL,2022,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(133,NULL,2022,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(134,NULL,2022,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(135,NULL,2022,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(136,NULL,2022,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(137,NULL,2022,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(138,NULL,2022,1,0,'Servicio Doméstico',252564.84,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(139,NULL,2022,1,0,'Donaciones',0.00,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(140,NULL,2022,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(141,NULL,2022,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(142,NULL,2022,1,0,'Alquileres',252564.84,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(143,NULL,2022,0,1,'Conyuge',235457.25,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(144,NULL,2022,0,1,'Hijo Menor 18 años',118741.97,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(145,NULL,2022,0,1,'Ganancia No Imponible',252564.84,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(146,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 2]',1212311.24,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(147,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1]',505129.68,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(148,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1 “nuevos profesionales/emprendedores”]',631412.10,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(149,NULL,2022,0,1,'Hijo Incapacitado',237483.94,1,'2022-11-09 14:46:59','2022-11-09 14:46:59',NULL),(150,NULL,2021,1,0,'Alquileres',167678.40,1,NULL,NULL,NULL),(151,NULL,2023,1,0,'Primas de seguro para el caso de muerte',24000.00,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(152,NULL,2023,1,0,'Aportes a Obras Sociales',0.00,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(153,NULL,2023,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(154,NULL,2023,1,0,'Gastos de Sepelio',996.23,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(155,NULL,2023,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL);
INSERT INTO `ganan_deducciones` VALUES (156,NULL,2023,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(157,NULL,2023,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(158,NULL,2023,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(159,NULL,2023,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(160,NULL,2023,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(161,NULL,2023,1,0,'Servicio Doméstico',451686.96,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(162,NULL,2023,1,0,'Donaciones',0.00,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(163,NULL,2023,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(164,NULL,2023,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(165,NULL,2023,1,0,'Alquileres',451686.96,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(166,NULL,2023,0,1,'Ganancia No Imponible',451686.96,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(167,NULL,2023,0,1,'Conyuge',421091.75,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(168,NULL,2023,0,1,'Hijo Menor 18 años',212358.14,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(169,NULL,2023,0,1,'Hijo Incapacitado',424716.28,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(170,NULL,2023,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1]',1580904.36,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(171,NULL,2023,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1 “nuevos profesionales/emprendedores”]',1806747.84,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(172,NULL,2023,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 2]',2168097.42,1,'2022-12-28 17:50:41','2022-12-28 17:50:41',NULL),(173,NULL,2024,1,0,'Primas de seguro para el caso de muerte',195845.39,1,NULL,NULL,NULL),(174,NULL,2024,1,0,'Aportes a Obras Sociales',0.00,1,NULL,NULL,NULL),(175,NULL,2024,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,NULL,NULL,NULL),(176,NULL,2024,1,0,'Gastos de Sepelio',996.23,1,NULL,NULL,NULL),(177,NULL,2024,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,NULL,NULL,NULL),(178,NULL,2024,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,NULL,NULL,NULL),(179,NULL,2024,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,NULL,NULL,NULL),(180,NULL,2024,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,NULL,NULL,NULL),(181,NULL,2024,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,NULL,NULL,NULL),(182,NULL,2024,1,0,'Intereses Crédito Hipotecario',20000.00,1,NULL,NULL,NULL),(183,NULL,2024,1,0,'Servicio Doméstico',3503688.17,1,NULL,NULL,NULL),(184,NULL,2024,1,0,'Donaciones',0.00,1,NULL,NULL,NULL),(185,NULL,2024,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,NULL,NULL,NULL),(186,NULL,2024,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,NULL,NULL,NULL),(187,NULL,2024,1,0,'Alquileres',3503688.17,1,NULL,NULL,NULL),(188,NULL,2024,1,0,'Servicios o Herramientas con Fines Educativos',1401475.27,1,NULL,NULL,NULL),(189,NULL,2024,1,0,'Primas Riesgo de Muertes y Ahorros',195845.39,1,NULL,NULL,NULL),(190,NULL,2024,1,0,'Aportes Planes Seguro Retiro Privado',195845.39,1,NULL,NULL,NULL),(191,NULL,2024,1,0,'Aportes a Sociedades de Garantias Reciprocas',0.00,1,NULL,NULL,NULL);
INSERT INTO `ganan_deducciones` VALUES (192,NULL,2024,0,1,'Ganancia No Imponible',3503688.17,1,NULL,NULL,NULL),(193,NULL,2024,0,1,'Conyuge',3299771.52,1,NULL,NULL,NULL),(194,NULL,2024,0,1,'Hijo Menor 18 años',1664086.82,1,NULL,NULL,NULL),(195,NULL,2024,0,1,'Hijo Incapacitado',3328173.63,1,NULL,NULL,NULL),(196,NULL,2024,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1]',12262908.60,1,NULL,NULL,NULL),(197,NULL,2024,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1 “nuevos profesionales/emprendedores”]',14014752.69,1,NULL,NULL,NULL),(198,NULL,2024,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 2]',16817703.23,1,NULL,NULL,NULL),(199,NULL,2025,1,0,'Primas de seguro para el caso de muerte',195845.39,1,NULL,NULL,NULL),(200,NULL,2025,1,0,'Aportes a Obras Sociales',0.00,1,NULL,NULL,NULL),(201,NULL,2025,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,NULL,NULL,NULL),(202,NULL,2025,1,0,'Gastos de Sepelio',996.23,1,NULL,NULL,NULL),(203,NULL,2025,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,NULL,NULL,NULL),(204,NULL,2025,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,NULL,NULL,NULL),(205,NULL,2025,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,NULL,NULL,NULL),(206,NULL,2025,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,NULL,NULL,NULL),(207,NULL,2025,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,NULL,NULL,NULL),(208,NULL,2025,1,0,'Intereses Crédito Hipotecario',20000.00,1,NULL,NULL,NULL),(209,NULL,2025,1,0,'Servicio Doméstico',3916268.37,1,NULL,NULL,NULL),(210,NULL,2025,1,0,'Donaciones',0.00,1,NULL,NULL,NULL),(211,NULL,2025,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,NULL,NULL,NULL),(212,NULL,2025,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,NULL,NULL,NULL),(213,NULL,2025,1,0,'Alquileres',3916268.37,1,NULL,NULL,NULL),(214,NULL,2025,1,0,'Servicios o Herramientas con Fines Educativos',1566507.35,1,NULL,NULL,NULL),(215,NULL,2025,1,0,'Primas Riesgo de Muertes y Ahorros',195845.39,1,NULL,NULL,NULL),(216,NULL,2025,1,0,'Aportes Planes Seguro Retiro Privado',195845.39,1,NULL,NULL,NULL),(217,NULL,2025,1,0,'Aportes a Sociedades de Garantias Reciprocas',0.00,1,NULL,NULL,NULL),(218,NULL,2025,0,1,'Ganancia No Imponible',3916268.37,1,NULL,NULL,NULL),(219,NULL,2025,0,1,'Conyuge',3688339.32,1,NULL,NULL,NULL),(220,NULL,2025,0,1,'Hijo Menor 18 años',1860042.98,1,NULL,NULL,NULL),(221,NULL,2025,0,1,'Hijo Incapacitado',3720085.95,1,NULL,NULL,NULL),(222,NULL,2025,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1]',13706939.31,1,NULL,NULL,NULL),(223,NULL,2025,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1 “nuevos profesionales/emprendedores”]',15665073.50,1,NULL,NULL,NULL),(224,NULL,2025,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 2]',18798088.20,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ganan_deducciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_tipos_op`
--

DROP TABLE IF EXISTS `ganan_tipos_op`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_tipos_op` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_tipos_op`
--

LOCK TABLES `ganan_tipos_op` WRITE;
/*!40000 ALTER TABLE `ganan_tipos_op` DISABLE KEYS */;
INSERT INTO `ganan_tipos_op` VALUES (1,NULL,'Gravado',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(2,NULL,'Exento',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
/*!40000 ALTER TABLE `ganan_tipos_op` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `horas_calculadas`
--

DROP TABLE IF EXISTS `horas_calculadas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `horas_calculadas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `syj_empleado_id` int(10) unsigned NOT NULL,
  `fecha` date NOT NULL,
  `horas_fichaje` decimal(8,2) NOT NULL DEFAULT '0.00',
  `horas_normales` decimal(8,2) NOT NULL DEFAULT '0.00',
  `horas_50` decimal(8,2) NOT NULL DEFAULT '0.00',
  `horas_100` decimal(8,2) NOT NULL DEFAULT '0.00',
  `horas_prod` decimal(8,2) NOT NULL DEFAULT '0.00',
  `horas_improd` decimal(8,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `horas_calculadas_syj_empleado_id_foreign` (`syj_empleado_id`),
  CONSTRAINT `horas_calculadas_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `horas_calculadas`
--

LOCK TABLES `horas_calculadas` WRITE;
/*!40000 ALTER TABLE `horas_calculadas` DISABLE KEYS */;
/*!40000 ALTER TABLE `horas_calculadas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `horas_calculadas_details`
--

DROP TABLE IF EXISTS `horas_calculadas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `horas_calculadas_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `horas_calculada_id` bigint(20) unsigned NOT NULL,
  `inv_orden_trabajo_hora_id` bigint(20) unsigned DEFAULT NULL,
  `horas_productiva_id` bigint(20) unsigned NOT NULL,
  `horas_prod` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `horas_calculadas_details_horas_calculada_id_foreign` (`horas_calculada_id`),
  KEY `horas_calculadas_details_horas_productiva_id_foreign` (`horas_productiva_id`),
  KEY `horas_calculadas_details_inv_orden_trabajo_hora_id_foreign` (`inv_orden_trabajo_hora_id`),
  CONSTRAINT `horas_calculadas_details_horas_calculada_id_foreign` FOREIGN KEY (`horas_calculada_id`) REFERENCES `horas_calculadas` (`id`),
  CONSTRAINT `horas_calculadas_details_horas_productiva_id_foreign` FOREIGN KEY (`horas_productiva_id`) REFERENCES `horas_productivas` (`id`),
  CONSTRAINT `horas_calculadas_details_inv_orden_trabajo_hora_id_foreign` FOREIGN KEY (`inv_orden_trabajo_hora_id`) REFERENCES `inv_orden_trabajo_horas` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `horas_calculadas_details`
--

LOCK TABLES `horas_calculadas_details` WRITE;
/*!40000 ALTER TABLE `horas_calculadas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `horas_calculadas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `horas_definicion`
--

DROP TABLE IF EXISTS `horas_definicion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `horas_definicion` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `fecha` date NOT NULL,
  `horas_normales_inicio` time DEFAULT NULL,
  `horas_normales_fin` time DEFAULT NULL,
  `horas_50_inicio` time DEFAULT NULL,
  `horas_50_fin` time DEFAULT NULL,
  `horas_100_inicio` time DEFAULT NULL,
  `horas_100_fin` time DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `horas_definicion_person_id_foreign` (`person_id`),
  CONSTRAINT `horas_definicion_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `horas_definicion`
--

LOCK TABLES `horas_definicion` WRITE;
/*!40000 ALTER TABLE `horas_definicion` DISABLE KEYS */;
/*!40000 ALTER TABLE `horas_definicion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `horas_fichajes`
--

DROP TABLE IF EXISTS `horas_fichajes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `horas_fichajes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `syj_empleado_id` int(10) unsigned NOT NULL,
  `fecha` date NOT NULL,
  `fecha_y_hora` datetime DEFAULT NULL,
  `terminal` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `jornada` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `retraso` time DEFAULT NULL,
  `hs_50` time DEFAULT NULL,
  `hs_100` time DEFAULT NULL,
  `feriados` time DEFAULT NULL,
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `horas_fichajes_person_id_foreign` (`person_id`),
  KEY `horas_fichajes_syj_empleado_id_foreign` (`syj_empleado_id`),
  CONSTRAINT `horas_fichajes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `horas_fichajes_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `horas_fichajes`
--

LOCK TABLES `horas_fichajes` WRITE;
/*!40000 ALTER TABLE `horas_fichajes` DISABLE KEYS */;
/*!40000 ALTER TABLE `horas_fichajes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `horas_productivas`
--

DROP TABLE IF EXISTS `horas_productivas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `horas_productivas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ot_id` bigint(20) unsigned NOT NULL,
  `syj_empleado_id` int(10) unsigned NOT NULL,
  `fecha_y_hora` datetime NOT NULL,
  `fecha_hora_start` datetime NOT NULL,
  `fecha_hora_end` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `horas_productivas_syj_empleado_id_foreign` (`syj_empleado_id`),
  KEY `horas_productivas_ot_id_foreign` (`ot_id`),
  CONSTRAINT `horas_productivas_ot_id_foreign` FOREIGN KEY (`ot_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `horas_productivas_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `horas_productivas`
--

LOCK TABLES `horas_productivas` WRITE;
/*!40000 ALTER TABLE `horas_productivas` DISABLE KEYS */;
/*!40000 ALTER TABLE `horas_productivas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iibb_perceptions`
--

DROP TABLE IF EXISTS `iibb_perceptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iibb_perceptions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iibb_perceptions`
--

LOCK TABLES `iibb_perceptions` WRITE;
/*!40000 ALTER TABLE `iibb_perceptions` DISABLE KEYS */;
INSERT INTO `iibb_perceptions` VALUES (1,NULL,NULL,NULL,'IIBB CABA','IIBBCABA'),(2,NULL,NULL,NULL,'IIBB Bs. As.','IIBBBSAS'),(3,NULL,NULL,NULL,'Percepcion IIBB Tucuman','IIBBTucuman'),(4,NULL,NULL,NULL,'Perc IIBB Misiones','IIBBMisiones'),(5,NULL,NULL,NULL,'Perc IIBB Cordoba','IIBBCba'),(6,NULL,NULL,NULL,'Pec IIBB La Pampa','IIBB La Pampa'),(7,NULL,NULL,NULL,'Perc IIBB Rio Negro','IIBB Rio Negro'),(8,NULL,NULL,NULL,'Perc IIBB Corrientes','IIIBB Corrientes'),(9,NULL,NULL,NULL,'Perc IIBB Santiago del Estero','IIBBSantiago');
/*!40000 ALTER TABLE `iibb_perceptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_combos`
--

DROP TABLE IF EXISTS `inv_combos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_combos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `inv_product_combo_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `cantidades` int(11) NOT NULL,
  `codigo_interno` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_combos_inv_product_combo_id_foreign` (`inv_product_combo_id`),
  KEY `inv_combos_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_combos_inv_product_combo_id_foreign` FOREIGN KEY (`inv_product_combo_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_combos_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_combos`
--

LOCK TABLES `inv_combos` WRITE;
/*!40000 ALTER TABLE `inv_combos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_combos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_control_stock`
--

DROP TABLE IF EXISTS `inv_control_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_control_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_control_stock_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_control_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_control_stock`
--

LOCK TABLES `inv_control_stock` WRITE;
/*!40000 ALTER TABLE `inv_control_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_control_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_control_stock_detail`
--

DROP TABLE IF EXISTS `inv_control_stock_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_control_stock_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_control_stock_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `inv_deposito_id` bigint(20) unsigned DEFAULT NULL,
  `stock_actual` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_real` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_diferencia` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_diferencia` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_control_stock_detail_person_id_foreign` (`person_id`),
  KEY `inv_control_stock_detail_inv_control_stock_id_foreign` (`inv_control_stock_id`),
  KEY `inv_control_stock_detail_inv_product_id_foreign` (`inv_product_id`),
  KEY `inv_control_stock_detail_inv_deposito_id_foreign` (`inv_deposito_id`),
  CONSTRAINT `inv_control_stock_detail_inv_control_stock_id_foreign` FOREIGN KEY (`inv_control_stock_id`) REFERENCES `inv_control_stock` (`id`),
  CONSTRAINT `inv_control_stock_detail_inv_deposito_id_foreign` FOREIGN KEY (`inv_deposito_id`) REFERENCES `inv_depositos` (`id`),
  CONSTRAINT `inv_control_stock_detail_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_control_stock_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_control_stock_detail`
--

LOCK TABLES `inv_control_stock_detail` WRITE;
/*!40000 ALTER TABLE `inv_control_stock_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_control_stock_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_depositos`
--

DROP TABLE IF EXISTS `inv_depositos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_depositos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_depositos_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_depositos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_depositos`
--

LOCK TABLES `inv_depositos` WRITE;
/*!40000 ALTER TABLE `inv_depositos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_depositos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_descarga_details`
--

DROP TABLE IF EXISTS `inv_descarga_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_descarga_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_descarga_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `inv_deposito_id` bigint(20) unsigned DEFAULT NULL,
  `cantidades` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_descarga_details_person_id_foreign` (`person_id`),
  KEY `inv_descarga_details_inv_producto_id_foreign` (`inv_producto_id`),
  KEY `inv_descarga_details_inv_descarga_id_foreign` (`inv_descarga_id`),
  KEY `inv_descarga_details_inv_deposito_id_foreign` (`inv_deposito_id`),
  CONSTRAINT `inv_descarga_details_inv_deposito_id_foreign` FOREIGN KEY (`inv_deposito_id`) REFERENCES `inv_depositos` (`id`),
  CONSTRAINT `inv_descarga_details_inv_descarga_id_foreign` FOREIGN KEY (`inv_descarga_id`) REFERENCES `inv_descargas` (`id`),
  CONSTRAINT `inv_descarga_details_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_descarga_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_descarga_details`
--

LOCK TABLES `inv_descarga_details` WRITE;
/*!40000 ALTER TABLE `inv_descarga_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_descarga_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_descargas`
--

DROP TABLE IF EXISTS `inv_descargas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_descargas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_gastos_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_empleado_id` int(10) unsigned DEFAULT NULL,
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `fecha` datetime NOT NULL DEFAULT '2023-03-15 23:50:03',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_descargas_person_id_foreign` (`person_id`),
  KEY `inv_descargas_inv_orden_trabajo_gastos_tipo_id_foreign` (`inv_orden_trabajo_gastos_tipo_id`),
  KEY `inv_descargas_syj_empleado_id_foreign` (`syj_empleado_id`),
  CONSTRAINT `inv_descargas_inv_orden_trabajo_gastos_tipo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_gastos_tipo_id`) REFERENCES `inv_orden_trabajo_gastos_tipos` (`id`),
  CONSTRAINT `inv_descargas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_descargas_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_descargas`
--

LOCK TABLES `inv_descargas` WRITE;
/*!40000 ALTER TABLE `inv_descargas` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_descargas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_indicadores`
--

DROP TABLE IF EXISTS `inv_indicadores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_indicadores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metodo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `orden` int(10) unsigned NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_indicadores`
--

LOCK TABLES `inv_indicadores` WRITE;
/*!40000 ALTER TABLE `inv_indicadores` DISABLE KEYS */;
INSERT INTO `inv_indicadores` VALUES (1,NULL,'Datos Grales','datos_grales','card_info',5,1,NULL,'2022-11-09 14:47:05',NULL),(2,NULL,'Impuestos Asociados','impuestos_asociados','card_info',6,1,NULL,'2022-11-09 14:47:05',NULL),(3,NULL,'Informacion de Liquidacion','informacion_de_liquidacion','card_info',7,1,NULL,'2022-11-09 14:47:05',NULL),(4,NULL,'Cantidad Ventas del Mes','cantidad_ventas_del_mes','card',1,1,NULL,'2022-11-09 14:47:05',NULL),(5,NULL,'Total Facturado En El Mes','total_facturado_en_el_mes','card',2,1,NULL,'2022-11-09 14:47:05',NULL),(6,NULL,'Total Facturado En El Dia','total_facturado_en_el_dia','card',3,1,NULL,'2022-11-09 14:47:05',NULL),(7,NULL,'Total Facturado En El Año','total_facturado_en_el_anio','card',4,1,NULL,'2022-11-09 14:47:05',NULL),(8,NULL,'Facturacion Mensual','facturacion_mensual','grafico',8,1,NULL,'2022-11-09 14:47:05',NULL),(9,NULL,'Proyeccion de Ganancias','proyeccion_de_ganancias','tabla',9,1,NULL,'2022-11-09 14:47:05',NULL),(10,NULL,'Posicion IVA','posicion_de_iva','tabla',10,1,NULL,'2022-11-09 14:47:05',NULL);
/*!40000 ALTER TABLE `inv_indicadores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_indicadores_persons`
--

DROP TABLE IF EXISTS `inv_indicadores_persons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_indicadores_persons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_indicador_id` bigint(20) unsigned NOT NULL,
  `objetivo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_indicadores_persons_person_id_foreign` (`person_id`),
  KEY `inv_indicadores_persons_inv_indicador_id_foreign` (`inv_indicador_id`),
  CONSTRAINT `inv_indicadores_persons_inv_indicador_id_foreign` FOREIGN KEY (`inv_indicador_id`) REFERENCES `inv_indicadores` (`id`),
  CONSTRAINT `inv_indicadores_persons_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_indicadores_persons`
--

LOCK TABLES `inv_indicadores_persons` WRITE;
/*!40000 ALTER TABLE `inv_indicadores_persons` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_indicadores_persons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ing_egr_stock`
--

DROP TABLE IF EXISTS `inv_ing_egr_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ing_egr_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ing_egr_stock_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_ing_egr_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ing_egr_stock`
--

LOCK TABLES `inv_ing_egr_stock` WRITE;
/*!40000 ALTER TABLE `inv_ing_egr_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ing_egr_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ing_egr_stock_detail`
--

DROP TABLE IF EXISTS `inv_ing_egr_stock_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ing_egr_stock_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_ing_egr_stock_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `prod_variant_id` bigint(20) unsigned DEFAULT NULL,
  `inv_deposito_id` bigint(20) unsigned DEFAULT NULL,
  `sumar1_restar0` tinyint(1) NOT NULL DEFAULT '1',
  `cantidades` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ing_egr_stock_detail_person_id_foreign` (`person_id`),
  KEY `inv_ing_egr_stock_detail_inv_ing_egr_stock_id_foreign` (`inv_ing_egr_stock_id`),
  KEY `inv_ing_egr_stock_detail_inv_product_id_foreign` (`inv_product_id`),
  KEY `inv_ing_egr_stock_detail_inv_deposito_id_foreign` (`inv_deposito_id`),
  KEY `inv_ing_egr_stock_detail_prod_variant_id_foreign` (`prod_variant_id`),
  CONSTRAINT `inv_ing_egr_stock_detail_inv_deposito_id_foreign` FOREIGN KEY (`inv_deposito_id`) REFERENCES `inv_depositos` (`id`),
  CONSTRAINT `inv_ing_egr_stock_detail_inv_ing_egr_stock_id_foreign` FOREIGN KEY (`inv_ing_egr_stock_id`) REFERENCES `inv_ing_egr_stock` (`id`),
  CONSTRAINT `inv_ing_egr_stock_detail_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_ing_egr_stock_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_ing_egr_stock_detail_prod_variant_id_foreign` FOREIGN KEY (`prod_variant_id`) REFERENCES `prod_variants` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ing_egr_stock_detail`
--

LOCK TABLES `inv_ing_egr_stock_detail` WRITE;
/*!40000 ALTER TABLE `inv_ing_egr_stock_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ing_egr_stock_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_lista_de_precios`
--

DROP TABLE IF EXISTS `inv_lista_de_precios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_lista_de_precios` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cliente_id` int(10) unsigned DEFAULT NULL COMMENT 'Cliente específico al que aplica la lista (opcional)',
  `descuento_general` decimal(10,2) DEFAULT NULL COMMENT 'Porcentaje de descuento general para todos los productos',
  `incremento_general` decimal(10,2) DEFAULT NULL COMMENT 'Porcentaje de incremento general para todos los productos',
  `aplicar_redondeo` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Si se debe aplicar redondeo al precio calculado',
  `redondeo_a` decimal(10,2) DEFAULT NULL COMMENT 'Múltiplo al cual redondear el precio (ej: 10, 50, 100)',
  `fecha_desde` date DEFAULT NULL COMMENT 'Fecha de inicio de vigencia',
  `fecha_hasta` date DEFAULT NULL COMMENT 'Fecha de fin de vigencia',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_lista_de_precios_person_id_foreign` (`person_id`),
  KEY `inv_lista_de_precios_cliente_id_index` (`cliente_id`),
  KEY `inv_lista_de_precios_fecha_desde_index` (`fecha_desde`),
  KEY `inv_lista_de_precios_fecha_hasta_index` (`fecha_hasta`),
  CONSTRAINT `inv_lista_de_precios_cliente_id_foreign` FOREIGN KEY (`cliente_id`) REFERENCES `persons` (`id`) ON DELETE CASCADE,
  CONSTRAINT `inv_lista_de_precios_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_lista_de_precios`
--

LOCK TABLES `inv_lista_de_precios` WRITE;
/*!40000 ALTER TABLE `inv_lista_de_precios` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_lista_de_precios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_lista_de_precios_productos`
--

DROP TABLE IF EXISTS `inv_lista_de_precios_productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_lista_de_precios_productos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `inv_lista_de_precio_id` bigint(20) unsigned NOT NULL,
  `inv_producto_id` bigint(20) unsigned NOT NULL,
  `precio_sin_iva` decimal(15,2) DEFAULT NULL COMMENT 'Override del precio sin IVA (si es null, se calcula desde precio base)',
  `precio_final` decimal(15,2) DEFAULT NULL COMMENT 'Override del precio final (si es null, se calcula desde precio base)',
  `descuento_porcentaje` decimal(10,2) DEFAULT NULL COMMENT 'Porcentaje de descuento sobre precio base del producto',
  `incremento_porcentaje` decimal(10,2) DEFAULT NULL COMMENT 'Porcentaje de incremento sobre precio base del producto',
  `margen` decimal(10,2) DEFAULT NULL COMMENT 'Override del margen para recalcular precio',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_lista_producto` (`inv_lista_de_precio_id`,`inv_producto_id`),
  KEY `inv_lista_de_precios_productos_habilitado_index` (`habilitado`),
  KEY `inv_lista_de_precios_productos_inv_producto_id_habilitado_index` (`inv_producto_id`,`habilitado`),
  CONSTRAINT `inv_lista_de_precios_productos_inv_lista_de_precio_id_foreign` FOREIGN KEY (`inv_lista_de_precio_id`) REFERENCES `inv_lista_de_precios` (`id`) ON DELETE CASCADE,
  CONSTRAINT `inv_lista_de_precios_productos_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_lista_de_precios_productos`
--

LOCK TABLES `inv_lista_de_precios_productos` WRITE;
/*!40000 ALTER TABLE `inv_lista_de_precios_productos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_lista_de_precios_productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_clasificacion`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_clasificacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_clasificacion` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_clasificacion_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_orden_trabajo_clasificacion_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_clasificacion`
--

LOCK TABLES `inv_orden_trabajo_clasificacion` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_clasificacion` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_clasificacion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_config_cc`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_config_cc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_config_cc` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `horas_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `horas_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `gastos_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `gastos_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `productos_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `productos_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `asiento_horas_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_horas_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_gastos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_gastos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_productos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_productos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_config_cc_person_id_foreign` (`person_id`),
  KEY `hcc_id_foreign` (`horas_conta_plan_cuenta_id`),
  KEY `gcc_id_foreign` (`gastos_conta_plan_cuenta_id`),
  KEY `pcc_id_foreign` (`productos_conta_plan_cuenta_id`),
  KEY `h_contra_cc_id_foreign` (`horas_contra_conta_plan_cuenta_id`),
  KEY `g_contra_cc_id_foreign` (`gastos_contra_conta_plan_cuenta_id`),
  KEY `p_contra_cc_id_foreign` (`productos_contra_conta_plan_cuenta_id`),
  KEY `ahcc_id_foreign` (`asiento_horas_cpc_id`),
  KEY `agcc_id_foreign` (`asiento_gastos_cpc_id`),
  KEY `apcc_id_foreign` (`asiento_productos_cpc_id`),
  KEY `ah_contra_cc_id_foreign` (`asiento_contra_horas_cpc_id`),
  KEY `ag_contra_cc_id_foreign` (`asiento_contra_gastos_cpc_id`),
  KEY `ap_contra_cc_id_foreign` (`asiento_contra_productos_cpc_id`),
  CONSTRAINT `ag_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_gastos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `agcc_id_foreign` FOREIGN KEY (`asiento_gastos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ah_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_horas_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ahcc_id_foreign` FOREIGN KEY (`asiento_horas_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ap_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_productos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `apcc_id_foreign` FOREIGN KEY (`asiento_productos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `g_contra_cc_id_foreign` FOREIGN KEY (`gastos_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `gcc_id_foreign` FOREIGN KEY (`gastos_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `h_contra_cc_id_foreign` FOREIGN KEY (`horas_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `hcc_id_foreign` FOREIGN KEY (`horas_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `inv_orden_trabajo_config_cc_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `p_contra_cc_id_foreign` FOREIGN KEY (`productos_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `pcc_id_foreign` FOREIGN KEY (`productos_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_config_cc`
--

LOCK TABLES `inv_orden_trabajo_config_cc` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_config_cc` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_config_cc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_files`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_files_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `inv_orden_trabajo_files_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_files`
--

LOCK TABLES `inv_orden_trabajo_files` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_gastos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_gastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_gastos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_orden_trabajo_gastos_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-11-09 14:47:02',
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_gastos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_gastos_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `inv_orden_trabajo_gastos_receipt_id_foreign` (`receipt_id`),
  KEY `i_o_t_g_t_id_foreign` (`inv_orden_trabajo_gastos_tipo_id`),
  KEY `inv_orden_trabajo_gastos_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `i_o_t_g_t_id_foreign` FOREIGN KEY (`inv_orden_trabajo_gastos_tipo_id`) REFERENCES `inv_orden_trabajo_gastos_tipos` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_gastos`
--

LOCK TABLES `inv_orden_trabajo_gastos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_gastos_tipos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_gastos_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_gastos_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_gastos_tipos_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_orden_trabajo_gastos_tipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_gastos_tipos`
--

LOCK TABLES `inv_orden_trabajo_gastos_tipos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos_tipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-08-15 23:36:45',
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_orden_trabajo_horas_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_ot_hora_disponible_id` bigint(20) unsigned NOT NULL,
  `cantidad` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_horas_inv_orden_trabajo_horas_tipo_id_foreign` (`inv_orden_trabajo_horas_tipo_id`),
  KEY `inv_orden_trabajo_horas_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_horas_inv_ot_hora_disponible_id_foreign` (`inv_ot_hora_disponible_id`),
  CONSTRAINT `inv_orden_trabajo_horas_inv_orden_trabajo_horas_tipo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_horas_tipo_id`) REFERENCES `inv_orden_trabajo_horas_tipos` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_inv_ot_hora_disponible_id_foreign` FOREIGN KEY (`inv_ot_hora_disponible_id`) REFERENCES `inv_orden_trabajo_horas_disponibles` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas`
--

LOCK TABLES `inv_orden_trabajo_horas` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas_dispo`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas_dispo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas_dispo` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cargar_asignar` int(10) unsigned NOT NULL DEFAULT '1',
  `person_id` int(10) unsigned NOT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-08-22 21:47:08',
  `dc_estado_id` bigint(20) unsigned NOT NULL,
  `dc_firma_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_dispo_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_horas_dispo_dc_estado_id_foreign` (`dc_estado_id`),
  KEY `inv_orden_trabajo_horas_dispo_dc_firma_id_foreign` (`dc_firma_id`),
  CONSTRAINT `inv_orden_trabajo_horas_dispo_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_dispo_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_dispo_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas_dispo`
--

LOCK TABLES `inv_orden_trabajo_horas_dispo` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_dispo` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_dispo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas_disponibles`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas_disponibles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas_disponibles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_horas_dispo_id` bigint(20) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-08-15 23:36:45',
  `inv_orden_trabajo_horas_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `cantidad` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_disponibles_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_horas_disponibles_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_ot_hs_tipo_dis` (`inv_orden_trabajo_horas_tipo_id`),
  KEY `inv_ot_horas_dispo_id` (`inv_orden_trabajo_horas_dispo_id`),
  CONSTRAINT `inv_orden_trabajo_horas_disponibles_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_disponibles_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_ot_horas_dispo_id` FOREIGN KEY (`inv_orden_trabajo_horas_dispo_id`) REFERENCES `inv_orden_trabajo_horas_dispo` (`id`),
  CONSTRAINT `inv_ot_hs_tipo_dis` FOREIGN KEY (`inv_orden_trabajo_horas_tipo_id`) REFERENCES `inv_orden_trabajo_horas_tipos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas_disponibles`
--

LOCK TABLES `inv_orden_trabajo_horas_disponibles` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_disponibles` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_disponibles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas_tipos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `syj_centros_costo_id` int(10) unsigned NOT NULL,
  `valor` decimal(16,2) NOT NULL DEFAULT '1.00',
  `cantidad_disponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_disponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `show_para_produccion` tinyint(1) NOT NULL DEFAULT '1',
  `show_para_horas` tinyint(1) NOT NULL DEFAULT '1',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_tipos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_horas_tipos_syj_centros_costo_id_foreign` (`syj_centros_costo_id`),
  CONSTRAINT `inv_orden_trabajo_horas_tipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_tipos_syj_centros_costo_id_foreign` FOREIGN KEY (`syj_centros_costo_id`) REFERENCES `syj_centros_costos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas_tipos`
--

LOCK TABLES `inv_orden_trabajo_horas_tipos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_tipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_productos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_productos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(16,2) NOT NULL DEFAULT '0.00',
  `dc_orden_id` bigint(20) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-11-09 14:47:02',
  `cantidades` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe` decimal(16,2) NOT NULL DEFAULT '1.00',
  `total` decimal(16,2) NOT NULL DEFAULT '1.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_productos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_productos_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_productos_inv_producto_id_foreign` (`inv_producto_id`),
  KEY `inv_orden_trabajo_productos_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `inv_orden_trabajo_productos_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `inv_orden_trabajo_productos_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `inv_orden_trabajo_productos_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_productos_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_orden_trabajo_productos_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `inv_orden_trabajo_productos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_productos`
--

LOCK TABLES `inv_orden_trabajo_productos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_productos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_servicios`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_servicios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_servicios` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-08-14 22:27:37',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_servicios_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_servicios_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_servicios_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `inv_orden_trabajo_servicios_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  CONSTRAINT `inv_orden_trabajo_servicios_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `inv_orden_trabajo_servicios_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `inv_orden_trabajo_servicios_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_servicios_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_servicios`
--

LOCK TABLES `inv_orden_trabajo_servicios` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_servicios` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_servicios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_tareas`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_tareas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_tareas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-09-14 21:51:49',
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned NOT NULL,
  `syj_centro_costo_id` int(10) unsigned NOT NULL,
  `syj_empleado_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `horas_estimadas` decimal(16,2) DEFAULT NULL,
  `is_terminada` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_tareas_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_tareas_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_tareas_syj_centro_costo_id_foreign` (`syj_centro_costo_id`),
  KEY `inv_orden_trabajo_tareas_syj_empleado_id_foreign` (`syj_empleado_id`),
  CONSTRAINT `inv_orden_trabajo_tareas_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_tareas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_tareas_syj_centro_costo_id_foreign` FOREIGN KEY (`syj_centro_costo_id`) REFERENCES `syj_centros_costos` (`id`),
  CONSTRAINT `inv_orden_trabajo_tareas_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_tareas`
--

LOCK TABLES `inv_orden_trabajo_tareas` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_tareas` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_tareas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajos`
--

DROP TABLE IF EXISTS `inv_orden_trabajos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `inv_ot_clasificacion_id` int(10) unsigned DEFAULT NULL,
  `direccion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `latitud` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `longitud` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `patente` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rodado_id` bigint(20) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-11-09 14:47:01',
  `fecha_estimada` datetime DEFAULT NULL,
  `fecha_cierre` datetime DEFAULT NULL,
  `numero` int(10) unsigned NOT NULL,
  `responsable` text COLLATE utf8mb4_unicode_ci,
  `syj_empleado_id` int(10) unsigned DEFAULT NULL,
  `responsable_emp_id` int(10) unsigned DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `titulo` text COLLATE utf8mb4_unicode_ci,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `cerrada` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajos_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `inv_orden_trabajos_inv_ot_clasificacion_id_foreign` (`inv_ot_clasificacion_id`),
  KEY `inv_orden_trabajos_rodado_id_foreign` (`rodado_id`),
  KEY `inv_orden_trabajos_syj_empleado_id_foreign` (`syj_empleado_id`),
  KEY `inv_orden_trabajos_responsable_emp_id_foreign` (`responsable_emp_id`),
  CONSTRAINT `inv_orden_trabajos_inv_ot_clasificacion_id_foreign` FOREIGN KEY (`inv_ot_clasificacion_id`) REFERENCES `inv_orden_trabajo_clasificacion` (`id`),
  CONSTRAINT `inv_orden_trabajos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajos_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajos_responsable_emp_id_foreign` FOREIGN KEY (`responsable_emp_id`) REFERENCES `syj_empleados` (`id`),
  CONSTRAINT `inv_orden_trabajos_rodado_id_foreign` FOREIGN KEY (`rodado_id`) REFERENCES `rodados` (`id`),
  CONSTRAINT `inv_orden_trabajos_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajos`
--

LOCK TABLES `inv_orden_trabajos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ot_devoluciones`
--

DROP TABLE IF EXISTS `inv_ot_devoluciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ot_devoluciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_ot_id` bigint(20) unsigned NOT NULL,
  `fecha` datetime NOT NULL DEFAULT '2025-03-17 01:19:36',
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `estado` tinyint(1) NOT NULL DEFAULT '0',
  `firma` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ot_devoluciones_person_id_foreign` (`person_id`),
  KEY `inv_ot_devoluciones_inv_ot_id_foreign` (`inv_ot_id`),
  CONSTRAINT `inv_ot_devoluciones_inv_ot_id_foreign` FOREIGN KEY (`inv_ot_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_ot_devoluciones_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ot_devoluciones`
--

LOCK TABLES `inv_ot_devoluciones` WRITE;
/*!40000 ALTER TABLE `inv_ot_devoluciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ot_devoluciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ot_horas_importe_dispo`
--

DROP TABLE IF EXISTS `inv_ot_horas_importe_dispo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ot_horas_importe_dispo` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-09-12 22:21:36',
  `dc_estado_id` bigint(20) unsigned NOT NULL,
  `dc_firma_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ot_horas_importe_dispo_person_id_foreign` (`person_id`),
  KEY `inv_ot_horas_importe_dispo_dc_estado_id_foreign` (`dc_estado_id`),
  KEY `inv_ot_horas_importe_dispo_dc_firma_id_foreign` (`dc_firma_id`),
  CONSTRAINT `inv_ot_horas_importe_dispo_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `inv_ot_horas_importe_dispo_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `inv_ot_horas_importe_dispo_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ot_horas_importe_dispo`
--

LOCK TABLES `inv_ot_horas_importe_dispo` WRITE;
/*!40000 ALTER TABLE `inv_ot_horas_importe_dispo` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ot_horas_importe_dispo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ot_horas_importe_disponible`
--

DROP TABLE IF EXISTS `inv_ot_horas_importe_disponible`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ot_horas_importe_disponible` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `inv_ot_horas_importe_dispo_id` bigint(20) unsigned NOT NULL,
  `inv_orden_trabajo_horas_tipo_id` bigint(20) unsigned NOT NULL,
  `transactionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transactionable_id` int(10) unsigned DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ot_h_imp_dispo_id` (`inv_ot_horas_importe_dispo_id`),
  KEY `inv_ot_h_tipo_id` (`inv_orden_trabajo_horas_tipo_id`),
  CONSTRAINT `inv_ot_h_imp_dispo_id` FOREIGN KEY (`inv_ot_horas_importe_dispo_id`) REFERENCES `inv_ot_horas_importe_dispo` (`id`),
  CONSTRAINT `inv_ot_h_tipo_id` FOREIGN KEY (`inv_orden_trabajo_horas_tipo_id`) REFERENCES `inv_orden_trabajo_horas_tipos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ot_horas_importe_disponible`
--

LOCK TABLES `inv_ot_horas_importe_disponible` WRITE;
/*!40000 ALTER TABLE `inv_ot_horas_importe_disponible` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ot_horas_importe_disponible` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ot_link`
--

DROP TABLE IF EXISTS `inv_ot_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ot_link` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `fecha` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ot_link_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_ot_link_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ot_link`
--

LOCK TABLES `inv_ot_link` WRITE;
/*!40000 ALTER TABLE `inv_ot_link` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ot_link` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ot_link_facts`
--

DROP TABLE IF EXISTS `inv_ot_link_facts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ot_link_facts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `inv_ot_link_id` bigint(20) unsigned NOT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ot_link_facts_inv_ot_link_id_foreign` (`inv_ot_link_id`),
  KEY `inv_ot_link_facts_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  CONSTRAINT `inv_ot_link_facts_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `inv_ot_link_facts_inv_ot_link_id_foreign` FOREIGN KEY (`inv_ot_link_id`) REFERENCES `inv_ot_link` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ot_link_facts`
--

LOCK TABLES `inv_ot_link_facts` WRITE;
/*!40000 ALTER TABLE `inv_ot_link_facts` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ot_link_facts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ot_link_ots`
--

DROP TABLE IF EXISTS `inv_ot_link_ots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ot_link_ots` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `inv_ot_link_id` bigint(20) unsigned NOT NULL,
  `inv_ot_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ot_link_ots_inv_ot_link_id_foreign` (`inv_ot_link_id`),
  KEY `inv_ot_link_ots_inv_ot_id_foreign` (`inv_ot_id`),
  CONSTRAINT `inv_ot_link_ots_inv_ot_id_foreign` FOREIGN KEY (`inv_ot_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_ot_link_ots_inv_ot_link_id_foreign` FOREIGN KEY (`inv_ot_link_id`) REFERENCES `inv_ot_link` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ot_link_ots`
--

LOCK TABLES `inv_ot_link_ots` WRITE;
/*!40000 ALTER TABLE `inv_ot_link_ots` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ot_link_ots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ots_facturadas`
--

DROP TABLE IF EXISTS `inv_ots_facturadas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ots_facturadas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `inv_ot_id` bigint(20) unsigned NOT NULL,
  `fact_elec_receipt_id` int(11) DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ots_facturadas_inv_ot_id_foreign` (`inv_ot_id`),
  KEY `inv_ots_facturadas_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `inv_ots_facturadas_receipt_id_foreign` (`receipt_id`),
  CONSTRAINT `inv_ots_facturadas_inv_ot_id_foreign` FOREIGN KEY (`inv_ot_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_ots_facturadas_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ots_facturadas`
--

LOCK TABLES `inv_ots_facturadas` WRITE;
/*!40000 ALTER TABLE `inv_ots_facturadas` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ots_facturadas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ots_presupuestos`
--

DROP TABLE IF EXISTS `inv_ots_presupuestos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ots_presupuestos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `inv_ot_id` bigint(20) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ots_presupuestos_inv_ot_id_foreign` (`inv_ot_id`),
  KEY `inv_ots_presupuestos_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `inv_ots_presupuestos_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `inv_ots_presupuestos_inv_ot_id_foreign` FOREIGN KEY (`inv_ot_id`) REFERENCES `inv_orden_trabajos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ots_presupuestos`
--

LOCK TABLES `inv_ots_presupuestos` WRITE;
/*!40000 ALTER TABLE `inv_ots_presupuestos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ots_presupuestos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_product_receipt`
--

DROP TABLE IF EXISTS `inv_product_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_product_receipt` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `type_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `prod_variant_id` bigint(20) unsigned DEFAULT NULL,
  `inv_deposito_id` bigint(20) unsigned DEFAULT NULL,
  `receiptable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `receiptable_id` int(10) unsigned NOT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_sin_iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `descuento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `descuento_por1_imp0` tinyint(1) NOT NULL DEFAULT '1',
  `descuento_porcentaje` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_con_descuento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_final` decimal(16,2) NOT NULL DEFAULT '0.00',
  `iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_product_receipt_type_id_foreign` (`type_id`),
  KEY `inv_product_receipt_person_id_foreign` (`person_id`),
  KEY `inv_product_receipt_inv_product_id_foreign` (`inv_product_id`),
  KEY `inv_product_receipt_inv_deposito_id_foreign` (`inv_deposito_id`),
  KEY `inv_product_receipt_prod_variant_id_foreign` (`prod_variant_id`),
  CONSTRAINT `inv_product_receipt_inv_deposito_id_foreign` FOREIGN KEY (`inv_deposito_id`) REFERENCES `inv_depositos` (`id`),
  CONSTRAINT `inv_product_receipt_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_product_receipt_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_product_receipt_prod_variant_id_foreign` FOREIGN KEY (`prod_variant_id`) REFERENCES `prod_variants` (`id`) ON DELETE CASCADE,
  CONSTRAINT `inv_product_receipt_type_id_foreign` FOREIGN KEY (`type_id`) REFERENCES `types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_product_receipt`
--

LOCK TABLES `inv_product_receipt` WRITE;
/*!40000 ALTER TABLE `inv_product_receipt` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_product_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_producto_fotos`
--

DROP TABLE IF EXISTS `inv_producto_fotos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_producto_fotos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `inv_producto_id` bigint(20) unsigned NOT NULL,
  `foto` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_producto_fotos_inv_producto_id_foreign` (`inv_producto_id`),
  CONSTRAINT `inv_producto_fotos_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_producto_fotos`
--

LOCK TABLES `inv_producto_fotos` WRITE;
/*!40000 ALTER TABLE `inv_producto_fotos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_producto_fotos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_producto_prioridad`
--

DROP TABLE IF EXISTS `inv_producto_prioridad`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_producto_prioridad` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_producto_prioridad`
--

LOCK TABLES `inv_producto_prioridad` WRITE;
/*!40000 ALTER TABLE `inv_producto_prioridad` DISABLE KEYS */;
INSERT INTO `inv_producto_prioridad` VALUES (1,'Alta',1,NULL,NULL,NULL),(2,'Media',1,NULL,NULL,NULL),(3,'Baja',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `inv_producto_prioridad` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_productos`
--

DROP TABLE IF EXISTS `inv_productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_productos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `is_old` tinyint(1) NOT NULL DEFAULT '0',
  `inv_producto_tipo_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `person_id` int(10) unsigned NOT NULL,
  `person_prov_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigo_externo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigo_interno` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fac_ele_unidad_medida_id` int(10) unsigned NOT NULL DEFAULT '8',
  `inv_rubro_sub_id` bigint(20) unsigned NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `margen` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_sin_iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `system_tax_id` int(10) unsigned DEFAULT NULL,
  `iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_final` decimal(16,2) NOT NULL DEFAULT '0.00',
  `inv_lista_de_precio_id` bigint(20) unsigned DEFAULT NULL,
  `inv_prioridad_id` bigint(20) unsigned NOT NULL DEFAULT '3',
  `foto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stock` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_minimo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `fecha_vto` datetime DEFAULT NULL,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `texto_corto` text COLLATE utf8mb4_unicode_ci,
  `texto_largo` text COLLATE utf8mb4_unicode_ci,
  `show_in_catalogo` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_productos_person_id_foreign` (`person_id`),
  KEY `inv_productos_person_prov_id_foreign` (`person_prov_id`),
  KEY `inv_productos_fac_ele_unidad_medida_id_foreign` (`fac_ele_unidad_medida_id`),
  KEY `inv_productos_inv_rubro_sub_id_foreign` (`inv_rubro_sub_id`),
  KEY `inv_productos_system_tax_id_foreign` (`system_tax_id`),
  KEY `inv_productos_inv_lista_de_precio_id_foreign` (`inv_lista_de_precio_id`),
  KEY `inv_productos_inv_producto_tipo_id_foreign` (`inv_producto_tipo_id`),
  KEY `inv_productos_moneda_id_foreign` (`moneda_id`),
  KEY `inv_productos_inv_prioridad_id_foreign` (`inv_prioridad_id`),
  CONSTRAINT `inv_productos_fac_ele_unidad_medida_id_foreign` FOREIGN KEY (`fac_ele_unidad_medida_id`) REFERENCES `fac_elec_unidad_medidas` (`id`),
  CONSTRAINT `inv_productos_inv_lista_de_precio_id_foreign` FOREIGN KEY (`inv_lista_de_precio_id`) REFERENCES `inv_lista_de_precios` (`id`),
  CONSTRAINT `inv_productos_inv_prioridad_id_foreign` FOREIGN KEY (`inv_prioridad_id`) REFERENCES `inv_producto_prioridad` (`id`),
  CONSTRAINT `inv_productos_inv_producto_tipo_id_foreign` FOREIGN KEY (`inv_producto_tipo_id`) REFERENCES `inv_productos_tipos` (`id`),
  CONSTRAINT `inv_productos_inv_rubro_sub_id_foreign` FOREIGN KEY (`inv_rubro_sub_id`) REFERENCES `inv_rubros_sub` (`id`),
  CONSTRAINT `inv_productos_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `inv_productos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_productos_person_prov_id_foreign` FOREIGN KEY (`person_prov_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_productos_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_productos`
--

LOCK TABLES `inv_productos` WRITE;
/*!40000 ALTER TABLE `inv_productos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_productos_tipos`
--

DROP TABLE IF EXISTS `inv_productos_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_productos_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_productos_tipos`
--

LOCK TABLES `inv_productos_tipos` WRITE;
/*!40000 ALTER TABLE `inv_productos_tipos` DISABLE KEYS */;
INSERT INTO `inv_productos_tipos` VALUES (1,NULL,'Unitario',1,NULL,NULL,NULL),(2,NULL,'Combo',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `inv_productos_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_productos_ubicaciones`
--

DROP TABLE IF EXISTS `inv_productos_ubicaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_productos_ubicaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `inv_ubicacion_id` bigint(20) unsigned NOT NULL,
  `comentario` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_productos_ubicaciones_inv_product_id_foreign` (`inv_product_id`),
  KEY `inv_productos_ubicaciones_inv_ubicacion_id_foreign` (`inv_ubicacion_id`),
  KEY `inv_productos_ubicaciones_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_productos_ubicaciones_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_productos_ubicaciones_inv_ubicacion_id_foreign` FOREIGN KEY (`inv_ubicacion_id`) REFERENCES `inv_ubicaciones` (`id`),
  CONSTRAINT `inv_productos_ubicaciones_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_productos_ubicaciones`
--

LOCK TABLES `inv_productos_ubicaciones` WRITE;
/*!40000 ALTER TABLE `inv_productos_ubicaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_productos_ubicaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_rubros`
--

DROP TABLE IF EXISTS `inv_rubros`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_rubros` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_rubros_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_rubros_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_rubros`
--

LOCK TABLES `inv_rubros` WRITE;
/*!40000 ALTER TABLE `inv_rubros` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_rubros` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_rubros_sub`
--

DROP TABLE IF EXISTS `inv_rubros_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_rubros_sub` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_rubro_id` bigint(20) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_rubros_sub_person_id_foreign` (`person_id`),
  KEY `inv_rubros_sub_inv_rubro_id_foreign` (`inv_rubro_id`),
  CONSTRAINT `inv_rubros_sub_inv_rubro_id_foreign` FOREIGN KEY (`inv_rubro_id`) REFERENCES `inv_rubros` (`id`),
  CONSTRAINT `inv_rubros_sub_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_rubros_sub`
--

LOCK TABLES `inv_rubros_sub` WRITE;
/*!40000 ALTER TABLE `inv_rubros_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_rubros_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_stock_movimientos`
--

DROP TABLE IF EXISTS `inv_stock_movimientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_stock_movimientos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `fecha` date DEFAULT '2025-03-18',
  `person_id` int(10) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `prod_variant_id` bigint(20) unsigned DEFAULT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `inv_deposito_id` bigint(20) unsigned DEFAULT NULL,
  `movimiento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock` decimal(16,2) NOT NULL DEFAULT '0.00',
  `costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_sin_iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_final` decimal(16,2) NOT NULL DEFAULT '0.00',
  `transactionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transactionable_id` bigint(20) unsigned NOT NULL,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_morph` (`transactionable_type`,`transactionable_id`),
  KEY `inv_stock_movimientos_person_id_foreign` (`person_id`),
  KEY `inv_stock_movimientos_inv_product_id_foreign` (`inv_product_id`),
  KEY `inv_stock_movimientos_inv_deposito_id_foreign` (`inv_deposito_id`),
  KEY `inv_stock_movimientos_moneda_id_foreign` (`moneda_id`),
  KEY `inv_stock_movimientos_prod_variant_id_foreign` (`prod_variant_id`),
  CONSTRAINT `inv_stock_movimientos_inv_deposito_id_foreign` FOREIGN KEY (`inv_deposito_id`) REFERENCES `inv_depositos` (`id`),
  CONSTRAINT `inv_stock_movimientos_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_stock_movimientos_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `inv_stock_movimientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_stock_movimientos_prod_variant_id_foreign` FOREIGN KEY (`prod_variant_id`) REFERENCES `prod_variants` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_stock_movimientos`
--

LOCK TABLES `inv_stock_movimientos` WRITE;
/*!40000 ALTER TABLE `inv_stock_movimientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_stock_movimientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ubicaciones`
--

DROP TABLE IF EXISTS `inv_ubicaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ubicaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_deposito_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ubicaciones_person_id_foreign` (`person_id`),
  KEY `inv_ubicaciones_inv_deposito_id_foreign` (`inv_deposito_id`),
  CONSTRAINT `inv_ubicaciones_inv_deposito_id_foreign` FOREIGN KEY (`inv_deposito_id`) REFERENCES `inv_depositos` (`id`),
  CONSTRAINT `inv_ubicaciones_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ubicaciones`
--

LOCK TABLES `inv_ubicaciones` WRITE;
/*!40000 ALTER TABLE `inv_ubicaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ubicaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iva_agrupacion`
--

DROP TABLE IF EXISTS `iva_agrupacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iva_agrupacion` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL,
  `ordr` int(11) NOT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iva_agrupacion`
--

LOCK TABLES `iva_agrupacion` WRITE;
/*!40000 ALTER TABLE `iva_agrupacion` DISABLE KEYS */;
INSERT INTO `iva_agrupacion` VALUES (1,1,1,0.00,'Operaciones con Responsables Inscriptos',1,NULL,NULL,NULL),(2,1,2,0.00,'Operaciones con Consumidores finales, Exentos y No alcanzados',1,NULL,NULL,NULL),(3,1,3,0.00,'Operaciones no gravadas y exentas',1,NULL,NULL,NULL),(4,1,4,0.00,'Credito fiscal a restituir',1,NULL,NULL,NULL),(5,2,5,0.00,'Debito fiscal a restituir',1,NULL,NULL,NULL),(6,2,6,0.00,'Total Credito Fiscal',1,NULL,NULL,NULL),(7,2,7,0.00,'Total Operaciones que no Generan Credito Fiscal',1,NULL,NULL,NULL),(8,1,8,0.00,'Operaciones con Monotributistas - Regimen Simmplificado',1,'2022-11-09 14:47:01','2022-11-09 14:47:01',NULL);
/*!40000 ALTER TABLE `iva_agrupacion` ENABLE KEYS */;
UNLO