-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-26132512-3
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-08-24 20:30:46','Actividad Generica 1','000001',NULL),(2,NULL,'2022-08-24 20:30:46','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3436 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7705,40720,1515,3,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',1500.00,NULL,NULL,1,'2022-10-15 17:37:02','2022-10-17 21:27:12','2022-10-17 21:27:12'),(2,7705,40720,1515,3,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',3870.95,NULL,NULL,1,'2022-10-17 21:14:36','2022-10-17 21:14:36',NULL),(3,7705,40720,1515,3,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',5099.22,NULL,NULL,1,'2022-10-17 21:22:03','2022-10-17 21:27:38','2022-10-17 21:27:38'),(4,7705,40720,1515,3,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',1500.47,NULL,NULL,1,'2022-10-17 21:23:06','2022-10-17 21:28:21','2022-10-17 21:28:21'),(5,7705,40720,1515,3,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',1600.37,NULL,NULL,1,'2022-10-17 21:24:22','2022-10-17 21:28:42','2022-10-17 21:28:42'),(6,7705,40720,1515,3,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',3000.18,NULL,NULL,1,'2022-10-17 21:26:09','2022-10-17 21:29:02','2022-10-17 21:29:02'),(7,7705,40720,1515,3,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',1500.00,NULL,NULL,1,'2022-10-17 21:27:12','2022-10-17 21:27:12',NULL),(8,7705,40720,1515,3,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',5099.22,NULL,NULL,1,'2022-10-17 21:27:38','2022-10-17 21:27:38',NULL),(9,7705,40720,1515,3,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',1500.47,NULL,NULL,1,'2022-10-17 21:28:21','2022-10-17 21:28:21',NULL),(10,7705,40720,1515,3,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',1600.37,NULL,NULL,1,'2022-10-17 21:28:42','2022-10-17 21:28:42',NULL),(11,7705,40720,1515,3,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',3000.18,NULL,NULL,1,'2022-10-17 21:29:02','2022-10-17 21:29:02',NULL),(12,7705,40720,1515,3,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',9171.51,NULL,NULL,1,'2022-10-18 19:36:35','2022-10-18 19:36:35',NULL),(13,7705,40720,1515,3,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',1499.98,NULL,NULL,1,'2022-10-18 19:44:33','2022-10-18 19:44:33',NULL),(14,7705,40720,1515,3,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',4690.54,NULL,NULL,1,'2022-10-18 19:46:20','2022-10-18 19:47:17','2022-10-18 19:47:17'),(15,7705,40720,1515,3,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',8002.25,NULL,NULL,1,'2022-10-18 19:48:30','2022-10-18 19:48:30',NULL),(16,7705,40720,1515,3,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',3000.18,NULL,NULL,1,'2022-10-18 19:49:31','2022-10-18 19:49:31',NULL),(17,7705,40720,1515,3,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',5000.94,NULL,NULL,1,'2022-10-18 19:50:41','2022-10-18 19:50:41',NULL),(18,7705,40720,1515,3,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',8500.00,NULL,NULL,1,'2022-10-18 19:51:50','2022-10-18 19:51:50',NULL),(19,7705,40720,1515,3,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',1700.00,NULL,NULL,1,'2022-10-18 19:53:35','2022-10-18 19:53:35',NULL),(20,7705,40720,1515,3,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',2700.01,NULL,NULL,1,'2022-10-18 19:55:05','2022-10-18 19:55:05',NULL),(21,7705,40720,1515,3,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',4000.00,NULL,NULL,1,'2022-10-18 19:57:17','2022-10-18 19:57:17',NULL);
INSERT INTO `balance_libro` VALUES (22,7705,40720,1515,3,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',5000.77,NULL,NULL,1,'2022-11-08 20:01:21','2022-11-08 20:01:21',NULL),(23,7705,40720,1515,3,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',7000.30,NULL,NULL,1,'2022-11-08 20:05:02','2022-11-08 20:05:02',NULL),(24,7705,40720,1515,3,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',8000.58,NULL,NULL,1,'2022-11-08 20:06:27','2022-11-08 20:06:27',NULL),(25,7705,40720,1515,3,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',13200.01,NULL,NULL,1,'2022-11-08 20:07:35','2022-11-08 20:07:35',NULL),(26,7705,40720,1515,3,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',6102.13,NULL,NULL,1,'2022-11-08 20:08:20','2022-11-08 20:08:20',NULL),(27,7705,40720,1515,3,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',3000.01,NULL,NULL,1,'2022-11-08 20:20:12','2022-11-08 20:20:12',NULL),(28,7705,40720,1515,3,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',1700.00,NULL,NULL,1,'2022-11-08 20:22:14','2022-11-08 20:22:14',NULL),(29,7705,40720,1515,3,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',9999.98,NULL,NULL,1,'2022-11-08 20:22:56','2022-11-08 20:22:56',NULL),(30,7705,40720,1515,3,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',7000.54,NULL,NULL,1,'2022-11-08 20:23:38','2022-11-08 20:23:38',NULL),(31,7705,40720,1515,3,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',10500.82,NULL,NULL,1,'2022-11-08 20:24:15','2022-11-08 20:24:15',NULL),(32,7705,40720,1515,3,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',1499.98,NULL,NULL,1,'2022-11-15 19:02:53','2022-11-15 19:02:53',NULL),(33,7705,40720,1515,3,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',8000.00,NULL,NULL,1,'2022-11-15 19:05:00','2022-11-15 19:05:00',NULL),(34,7705,40720,1515,3,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',13301.81,NULL,NULL,1,'2022-11-15 19:05:58','2022-11-15 19:05:58',NULL),(35,7705,40720,1515,3,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',3460.30,NULL,NULL,1,'2022-11-15 19:07:10','2022-11-15 19:07:10',NULL),(36,7705,40720,1515,3,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',3999.63,NULL,NULL,1,'2022-11-15 19:08:10','2022-11-15 19:08:10',NULL),(37,7705,40720,1515,3,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',9800.00,NULL,NULL,1,'2022-11-15 19:08:45','2022-11-15 19:08:45',NULL),(38,7705,40720,1515,2,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',9800.00,NULL,NULL,1,'2022-11-16 18:48:10','2022-11-29 19:36:00','2022-11-29 19:36:00'),(39,7705,40720,1515,2,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',7000.26,NULL,NULL,1,'2022-11-16 18:48:57','2022-11-29 19:35:54','2022-11-29 19:35:54'),(40,7705,40720,1515,2,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',4000.22,NULL,NULL,1,'2022-11-16 18:49:37','2022-11-29 19:35:48','2022-11-29 19:35:48'),(41,7705,40720,1515,2,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',4600.01,NULL,NULL,1,'2022-11-16 18:50:27','2022-11-29 19:35:42','2022-11-29 19:35:42'),(42,7705,40720,1515,2,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-11','2022-09-11',2000.20,NULL,NULL,1,'2022-11-16 18:51:04','2022-11-29 19:35:36','2022-11-29 19:35:36');
INSERT INTO `balance_libro` VALUES (43,7705,40720,1515,2,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',13602.32,NULL,NULL,1,'2022-11-16 18:52:43','2022-11-29 19:35:31','2022-11-29 19:35:31'),(44,7705,40720,1515,2,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',1000.11,NULL,NULL,1,'2022-11-16 18:53:37','2022-11-29 19:35:20','2022-11-29 19:35:20'),(45,7705,40720,1515,2,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',5000.94,NULL,NULL,1,'2022-11-16 18:54:11','2022-11-29 19:35:15','2022-11-29 19:35:15'),(46,7705,40720,1515,2,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',2000.20,NULL,NULL,1,'2022-11-16 18:54:55','2022-11-29 19:35:07','2022-11-29 19:35:07'),(47,7705,40720,1515,2,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',1000.00,NULL,NULL,1,'2022-11-16 18:55:54','2022-11-29 19:34:58','2022-11-29 19:34:58'),(48,7705,40720,1515,2,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',9800.00,NULL,NULL,1,'2022-11-16 18:56:36','2022-11-29 19:34:50','2022-11-29 19:34:50'),(49,7705,40720,1515,2,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',4000.48,NULL,NULL,1,'2022-11-16 18:57:13','2022-11-29 19:34:40','2022-11-29 19:34:40'),(50,7705,40720,1515,2,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',1000.11,NULL,NULL,1,'2022-11-16 18:57:47','2022-11-29 19:34:34','2022-11-29 19:34:34'),(51,7705,40720,1515,2,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',6001.00,NULL,NULL,1,'2022-11-16 18:58:29','2022-11-29 19:34:28','2022-11-29 19:34:28'),(52,7705,40720,1515,2,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',5499.40,NULL,NULL,1,'2022-11-16 18:59:14','2022-11-29 19:34:23','2022-11-29 19:34:23'),(53,7705,40720,1515,2,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',4000.32,NULL,NULL,1,'2022-11-16 19:00:09','2022-11-29 19:34:17','2022-11-29 19:34:17'),(54,7705,40720,1515,2,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',2000.20,NULL,NULL,1,'2022-11-16 19:02:04','2022-11-29 19:34:11','2022-11-29 19:34:11'),(55,7705,40720,1515,2,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',7488.48,NULL,NULL,1,'2022-11-16 19:02:49','2022-11-29 19:34:05','2022-11-29 19:34:05'),(56,7705,40720,1515,2,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',6000.74,NULL,NULL,1,'2022-11-16 19:03:45','2022-11-29 19:33:58','2022-11-29 19:33:58'),(57,7705,40720,1515,2,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',6000.00,NULL,NULL,1,'2022-11-16 19:06:12','2022-11-29 19:33:40','2022-11-29 19:33:40'),(58,7705,40720,1515,2,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',1499.76,NULL,NULL,1,'2022-11-16 19:06:50','2022-11-29 19:33:47','2022-11-29 19:33:47'),(59,7705,40720,1515,2,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',10240.75,NULL,NULL,1,'2022-11-16 19:07:57','2022-11-29 19:33:28','2022-11-29 19:33:28'),(60,7705,40720,1515,2,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',13400.07,NULL,NULL,1,'2022-11-16 20:56:09','2022-11-29 19:33:21','2022-11-29 19:33:21'),(61,7705,40720,1515,2,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',3000.30,NULL,NULL,1,'2022-11-16 20:56:51','2022-11-29 19:33:15','2022-11-29 19:33:15'),(62,7705,40720,1515,2,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',1599.86,NULL,NULL,1,'2022-11-16 20:57:33','2022-11-29 19:33:08','2022-11-29 19:33:08');
INSERT INTO `balance_libro` VALUES (63,7705,40720,1515,2,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',13001.29,NULL,NULL,1,'2022-11-16 20:58:13','2022-11-29 19:33:01','2022-11-29 19:33:01'),(64,7705,40720,1515,2,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',3999.66,NULL,NULL,1,'2022-11-16 20:58:55','2022-11-29 19:32:55','2022-11-29 19:32:55'),(65,7705,40720,1515,2,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',3199.95,NULL,NULL,1,'2022-11-16 20:59:41','2022-11-29 19:32:48','2022-11-29 19:32:48'),(66,7705,40720,1515,2,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',1500.30,NULL,NULL,1,'2022-11-16 21:01:55','2022-11-29 19:32:42','2022-11-29 19:32:42'),(67,7705,40720,1515,2,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',1999.99,NULL,NULL,1,'2022-11-16 21:02:49','2022-11-29 19:32:36','2022-11-29 19:32:36'),(68,7705,40720,1515,2,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',8500.00,NULL,NULL,1,'2022-11-16 21:03:50','2022-11-29 19:32:30','2022-11-29 19:32:30'),(69,7705,40720,1515,2,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',19903.56,NULL,NULL,1,'2022-11-16 21:04:49','2022-11-29 19:32:25','2022-11-29 19:32:25'),(70,7705,40720,1515,2,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',10000.46,NULL,NULL,1,'2022-11-16 21:05:46','2022-11-29 19:32:18','2022-11-29 19:32:18'),(71,7705,40720,1515,2,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',4000.00,NULL,NULL,1,'2022-11-16 21:06:26','2022-11-29 19:32:07','2022-11-29 19:32:07'),(72,7705,40720,1515,2,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',8500.01,NULL,NULL,1,'2022-11-16 21:08:04','2022-11-29 19:32:02','2022-11-29 19:32:02'),(73,7705,40720,1515,2,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',2499.99,NULL,NULL,1,'2022-11-16 21:08:53','2022-11-29 19:31:56','2022-11-29 19:31:56'),(74,7705,40720,1515,2,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',1600.03,NULL,NULL,1,'2022-11-16 21:09:52','2022-11-29 19:31:51','2022-11-29 19:31:51'),(75,7705,40720,1515,2,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',8000.22,NULL,NULL,1,'2022-11-16 21:10:41','2022-11-29 19:31:45','2022-11-29 19:31:45'),(76,7705,40720,1515,2,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',8500.01,NULL,NULL,1,'2022-11-16 21:11:10','2022-11-29 19:31:38','2022-11-29 19:31:38'),(77,7705,40720,1515,2,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',10502.72,NULL,NULL,1,'2022-11-16 21:11:54','2022-11-29 19:31:10','2022-11-29 19:31:10'),(78,7705,40720,1515,2,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',8500.01,NULL,NULL,1,'2022-11-16 21:22:43','2022-11-29 19:31:04','2022-11-29 19:31:04'),(79,7705,40720,1515,2,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',3050.34,NULL,NULL,1,'2022-11-16 21:26:38','2022-11-29 19:30:58','2022-11-29 19:30:58'),(80,7705,40720,1515,2,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',8000.36,NULL,NULL,1,'2022-11-16 21:27:29','2022-11-29 19:30:52','2022-11-29 19:30:52'),(81,7705,40720,1515,2,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',10500.49,NULL,NULL,1,'2022-11-16 21:28:27','2022-11-29 19:30:41','2022-11-29 19:30:41'),(82,7705,40720,1515,2,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',7999.42,NULL,NULL,1,'2022-11-16 21:29:26','2022-11-29 19:30:34','2022-11-29 19:30:34');
INSERT INTO `balance_libro` VALUES (83,7705,40720,1515,2,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',11200.12,NULL,NULL,1,'2022-11-16 21:30:12','2022-11-29 19:30:29','2022-11-29 19:30:29'),(84,7705,40720,1515,2,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',3999.71,NULL,NULL,1,'2022-11-16 21:30:53','2022-11-29 19:30:23','2022-11-29 19:30:23'),(85,7705,40720,1515,2,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',14481.32,NULL,NULL,1,'2022-11-16 21:31:44','2022-11-29 19:30:18','2022-11-29 19:30:18'),(86,7705,40720,1515,2,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',3999.71,NULL,NULL,1,'2022-11-16 21:32:20','2022-11-29 19:30:10','2022-11-29 19:30:10'),(87,7705,40720,1515,2,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',7100.73,NULL,NULL,1,'2022-11-16 21:33:10','2022-11-29 19:30:03','2022-11-29 19:30:03'),(88,7705,40720,1515,2,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',4000.73,NULL,NULL,1,'2022-11-16 21:33:53','2022-11-29 19:29:57','2022-11-29 19:29:57'),(89,7705,40720,1515,2,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',15289.06,NULL,NULL,1,'2022-11-16 21:35:52','2022-11-29 19:29:43','2022-11-29 19:29:43'),(90,7705,40720,1515,2,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',1999.99,NULL,NULL,1,'2022-11-16 21:36:50','2022-11-29 19:29:36','2022-11-29 19:29:36'),(91,7705,40720,1515,2,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',10200.80,NULL,NULL,1,'2022-11-16 21:37:47','2022-11-29 19:29:30','2022-11-29 19:29:30'),(92,7705,40720,1515,2,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',13559.95,NULL,NULL,1,'2022-11-16 21:38:49','2022-11-29 19:29:24','2022-11-29 19:29:24'),(93,7705,40720,1515,2,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',3000.37,NULL,NULL,1,'2022-11-16 21:39:47','2022-11-29 19:29:18','2022-11-29 19:29:18'),(94,7705,40720,1515,2,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',10856.38,NULL,NULL,1,'2022-11-16 21:40:27','2022-11-29 19:29:10','2022-11-29 19:29:10'),(95,7705,40720,1515,2,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',1219.99,NULL,NULL,1,'2022-11-16 23:06:40','2022-11-29 19:28:00','2022-11-29 19:28:00'),(96,7705,40720,1515,2,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1401.62,NULL,NULL,1,'2022-11-16 23:07:28','2022-11-29 19:27:51','2022-11-29 19:27:51'),(97,7705,40720,1515,2,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1300.01,NULL,NULL,1,'2022-11-16 23:08:19','2022-11-29 19:27:46','2022-11-29 19:27:46'),(98,7705,40720,1515,2,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',15400.88,NULL,NULL,1,'2022-11-16 23:09:27','2022-11-29 19:27:40','2022-11-29 19:27:40'),(99,7705,40720,1515,2,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',11903.21,NULL,NULL,1,'2022-11-16 23:11:44','2022-11-29 19:27:32','2022-11-29 19:27:32'),(100,7705,40720,1515,2,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',8000.00,NULL,NULL,1,'2022-11-16 23:12:34','2022-11-29 19:26:18','2022-11-29 19:26:18'),(101,7705,40720,1515,2,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',11999.99,NULL,NULL,1,'2022-11-16 23:13:42','2022-11-29 19:27:26','2022-11-29 19:27:26'),(102,7705,40720,1515,2,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',15099.89,NULL,NULL,1,'2022-11-16 23:14:18','2022-11-29 19:27:18','2022-11-29 19:27:18');
INSERT INTO `balance_libro` VALUES (103,7705,40720,1515,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',7499.98,NULL,NULL,1,'2022-11-16 23:14:52','2022-11-29 19:26:49','2022-11-29 19:26:49'),(104,7705,40720,1515,2,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',6000.46,NULL,NULL,1,'2022-11-16 23:15:20','2022-11-29 19:26:38','2022-11-29 19:26:38'),(105,7705,40720,1515,2,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',3000.14,NULL,NULL,1,'2022-11-16 23:15:58','2022-11-29 19:26:31','2022-11-29 19:26:31'),(106,7705,40720,1515,2,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',100330.01,NULL,NULL,1,'2022-11-16 23:19:17','2022-11-29 19:27:12','2022-11-29 19:27:12'),(107,7705,40720,1515,2,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',4464.17,NULL,NULL,1,'2022-11-16 23:24:01','2022-11-29 19:27:06','2022-11-29 19:27:06'),(108,7705,40720,1515,2,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',3870.95,NULL,NULL,1,'2022-11-16 23:32:51','2022-11-29 19:27:00','2022-11-29 19:27:00'),(109,7705,40720,1515,2,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',4000.00,NULL,NULL,1,'2022-11-16 23:34:50','2022-11-29 19:26:54','2022-11-29 19:26:54'),(110,7705,40720,1515,2,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',2700.01,NULL,NULL,1,'2022-11-16 23:35:29','2022-11-29 19:26:01','2022-11-29 19:26:01'),(111,7705,40720,1515,2,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',1700.00,NULL,NULL,1,'2022-11-16 23:36:06','2022-11-29 19:25:54','2022-11-29 19:25:54'),(112,7705,40720,1515,2,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',3460.31,NULL,NULL,1,'2022-11-16 23:37:20','2022-11-29 19:25:46','2022-11-29 19:25:46'),(113,7705,40720,1515,3,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',9800.00,NULL,NULL,1,'2022-11-29 20:42:41','2022-11-29 20:42:41',NULL),(114,7705,40720,1515,3,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',7000.26,NULL,NULL,1,'2022-11-29 20:44:06','2022-11-29 20:44:06',NULL),(115,7705,40720,1515,3,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',4000.22,NULL,NULL,1,'2022-11-29 20:50:14','2022-11-29 20:50:14',NULL),(116,7705,40720,1515,3,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',4600.01,NULL,NULL,1,'2022-11-29 21:07:54','2022-11-29 21:07:54',NULL),(117,7705,40720,1515,3,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-11','2022-09-11',2000.20,NULL,NULL,1,'2022-11-29 21:10:05','2022-11-29 21:10:05',NULL),(118,7705,40720,1515,3,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',4464.17,NULL,NULL,1,'2022-11-29 21:22:56','2022-11-29 21:22:56',NULL),(119,7705,40720,1515,3,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',13602.32,NULL,NULL,1,'2022-11-29 21:24:11','2022-11-29 21:24:11',NULL),(120,7705,40720,1515,3,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',1000.11,NULL,NULL,1,'2022-11-29 22:03:34','2022-11-29 22:03:34',NULL),(121,7705,40720,1515,3,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',5000.94,NULL,NULL,1,'2022-11-29 22:04:28','2022-11-29 22:04:28',NULL),(122,7705,40720,1515,3,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',2000.20,NULL,NULL,1,'2022-11-29 22:05:09','2022-11-29 22:05:09',NULL);
INSERT INTO `balance_libro` VALUES (123,7705,40720,1515,3,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',1000.00,NULL,NULL,1,'2022-11-29 22:05:54','2022-11-29 22:05:54',NULL),(124,7705,40720,1515,3,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',9800.00,NULL,NULL,1,'2022-11-29 22:07:12','2022-11-29 22:07:12',NULL),(125,7705,40720,1515,3,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',4000.48,NULL,NULL,1,'2022-11-29 22:07:46','2022-11-29 22:07:46',NULL),(126,7705,40720,1515,3,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',1000.11,NULL,NULL,1,'2022-11-29 22:08:18','2022-11-29 22:08:18',NULL),(127,7705,40720,1515,3,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',6001.00,NULL,NULL,1,'2022-11-29 22:09:09','2022-11-29 22:09:09',NULL),(128,7705,40720,1515,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',5499.40,NULL,NULL,1,'2022-11-29 22:09:59','2022-11-29 22:09:59',NULL),(129,7705,40720,1515,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',4000.32,NULL,NULL,1,'2022-11-29 22:10:54','2022-11-29 22:10:54',NULL),(130,7705,40720,1515,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',2000.20,NULL,NULL,1,'2022-11-29 22:11:36','2022-11-29 22:11:36',NULL),(131,7705,40720,1515,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',7488.48,NULL,NULL,1,'2022-11-29 22:12:12','2022-11-29 22:12:12',NULL),(132,7705,40720,1515,3,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',6000.74,NULL,NULL,1,'2022-11-29 22:14:04','2022-11-29 22:14:04',NULL),(133,7705,40720,1515,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',6000.00,NULL,NULL,1,'2022-11-29 22:16:18','2022-11-29 22:16:18',NULL),(134,7705,40720,1515,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',1499.76,NULL,NULL,1,'2022-11-29 22:17:06','2022-11-29 22:17:06',NULL),(135,7705,40720,1515,3,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',10240.75,NULL,NULL,1,'2022-11-29 22:18:10','2022-11-29 22:18:10',NULL),(136,7705,40720,1515,3,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',13400.07,NULL,NULL,1,'2022-11-29 22:19:34','2022-11-29 22:19:34',NULL),(137,7705,40720,1515,3,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',3000.30,NULL,NULL,1,'2022-11-29 22:20:22','2022-11-29 22:20:22',NULL),(138,7705,40720,1515,3,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',1599.86,NULL,NULL,1,'2022-11-29 22:21:11','2022-11-29 22:21:11',NULL),(139,7705,40720,1515,3,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',13001.29,NULL,NULL,1,'2022-11-29 22:22:08','2022-11-29 22:22:08',NULL),(140,7705,40720,1515,3,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',3999.66,NULL,NULL,1,'2022-11-29 22:22:54','2022-11-29 22:22:54',NULL),(141,7705,40720,1515,3,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',3199.95,NULL,NULL,1,'2022-11-29 22:23:38','2022-11-29 22:23:38',NULL),(142,7705,40720,1515,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',1000.00,NULL,NULL,1,'2022-11-29 22:25:31','2022-11-29 22:25:31',NULL),(143,7705,40720,1515,3,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',1500.30,NULL,NULL,1,'2022-11-29 22:26:42','2022-11-29 22:26:42',NULL);
INSERT INTO `balance_libro` VALUES (144,7705,40720,1515,3,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',100330.01,NULL,NULL,1,'2022-11-29 22:28:28','2022-11-29 22:28:28',NULL),(145,7705,40720,1515,3,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',1999.99,NULL,NULL,1,'2022-11-29 22:29:43','2022-11-29 22:29:43',NULL),(146,7705,40720,1515,3,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',8500.00,NULL,NULL,1,'2022-11-29 22:30:25','2022-11-29 22:30:25',NULL),(147,7705,40720,1515,3,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',19903.56,NULL,NULL,1,'2022-11-29 22:31:15','2022-11-29 22:31:15',NULL),(148,7705,40720,1515,3,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',10000.46,NULL,NULL,1,'2022-11-29 22:32:08','2022-11-29 22:32:08',NULL),(149,7705,40720,1515,3,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',4000.00,NULL,NULL,1,'2022-11-29 22:32:47','2022-11-29 22:32:47',NULL),(150,7705,40720,1515,3,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',8500.01,NULL,NULL,1,'2022-11-29 22:33:26','2022-11-29 22:33:26',NULL),(151,7705,40720,1515,3,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',2499.99,NULL,NULL,1,'2022-11-29 22:34:16','2022-11-29 22:34:16',NULL),(152,7705,40720,1515,3,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',1600.03,NULL,NULL,1,'2022-11-29 22:35:18','2022-11-29 22:35:18',NULL),(153,7705,40720,1515,3,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',8000.22,NULL,NULL,1,'2022-11-29 22:35:58','2022-11-29 22:35:58',NULL),(154,7705,40720,1515,3,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',8500.01,NULL,NULL,1,'2022-11-29 22:36:26','2022-11-29 22:36:26',NULL),(155,7705,40720,1515,3,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',10502.72,NULL,NULL,1,'2022-11-30 19:10:39','2022-11-30 19:10:39',NULL),(156,7705,40720,1515,3,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',8500.01,NULL,NULL,1,'2022-11-30 19:16:27','2022-11-30 19:16:27',NULL),(157,7705,40720,1515,3,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',3050.34,NULL,NULL,1,'2022-11-30 19:17:37','2022-11-30 19:17:37',NULL),(158,7705,40720,1515,3,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',8000.36,NULL,NULL,1,'2022-11-30 19:18:22','2022-11-30 19:18:22',NULL),(159,7705,40720,1515,3,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',10500.49,NULL,NULL,1,'2022-11-30 19:19:54','2022-11-30 19:19:54',NULL),(160,7705,40720,1515,3,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',7999.42,NULL,NULL,1,'2022-11-30 19:20:31','2022-11-30 19:20:31',NULL),(161,7705,40720,1515,3,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',11200.12,NULL,NULL,1,'2022-11-30 19:21:23','2022-11-30 19:21:23',NULL),(162,7705,40720,1515,3,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',3999.71,NULL,NULL,1,'2022-11-30 19:22:02','2022-11-30 19:22:02',NULL),(163,7705,40720,1515,3,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',14481.32,NULL,NULL,1,'2022-11-30 19:22:49','2022-11-30 19:22:49',NULL),(164,7705,40720,1515,3,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',3999.71,NULL,NULL,1,'2022-11-30 19:23:21','2022-11-30 19:23:21',NULL);
INSERT INTO `balance_libro` VALUES (165,7705,40720,1515,3,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',7100.73,NULL,NULL,1,'2022-11-30 19:24:53','2022-11-30 19:24:53',NULL),(166,7705,40720,1515,3,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',4000.73,NULL,NULL,1,'2022-11-30 19:25:45','2022-11-30 19:25:45',NULL),(167,7705,40720,1515,3,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',1999.99,NULL,NULL,1,'2022-11-30 19:27:23','2022-11-30 19:27:23',NULL),(168,7705,40720,1515,3,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',15289.06,NULL,NULL,1,'2022-11-30 19:28:31','2022-11-30 19:28:31',NULL),(169,7705,40720,1515,3,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',2679.99,NULL,NULL,1,'2022-11-30 19:31:29','2022-11-30 19:31:29',NULL),(170,7705,40720,1515,3,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',10200.80,NULL,NULL,1,'2022-11-30 19:33:52','2022-11-30 19:33:52',NULL),(171,7705,40720,1515,3,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',13559.95,NULL,NULL,1,'2022-11-30 19:34:51','2022-11-30 19:34:51',NULL),(172,7705,40720,1515,3,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',10856.38,NULL,NULL,1,'2022-11-30 19:35:27','2022-11-30 19:35:27',NULL),(173,7705,40720,1515,3,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',3000.37,NULL,NULL,1,'2022-11-30 19:36:09','2022-11-30 19:36:09',NULL),(174,7705,40720,1515,3,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',1219.99,NULL,NULL,1,'2022-11-30 19:37:05','2022-11-30 19:37:05',NULL),(175,7705,40720,1515,3,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',1401.62,NULL,NULL,1,'2022-11-30 19:37:55','2022-11-30 19:38:32','2022-11-30 19:38:32'),(176,7705,40720,1515,3,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1401.62,NULL,NULL,1,'2022-11-30 19:38:32','2022-11-30 19:38:32',NULL),(177,7705,40720,1515,3,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1300.01,NULL,NULL,1,'2022-11-30 19:39:29','2022-11-30 19:39:29',NULL),(178,7705,40720,1515,3,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',15400.88,NULL,NULL,1,'2022-11-30 19:40:22','2022-11-30 19:40:22',NULL),(179,7705,40720,1515,3,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',11903.21,NULL,NULL,1,'2022-11-30 19:41:40','2022-11-30 19:41:40',NULL),(180,7705,40720,1515,3,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',8000.00,NULL,NULL,1,'2022-11-30 19:42:23','2022-11-30 19:42:23',NULL),(181,7705,40720,1515,3,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',11999.99,NULL,NULL,1,'2022-11-30 19:43:06','2022-11-30 19:43:06',NULL),(182,7705,40720,1515,3,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',15099.89,NULL,NULL,1,'2022-11-30 19:46:57','2022-11-30 19:46:57',NULL),(183,7705,40720,1515,3,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',7499.98,NULL,NULL,1,'2022-11-30 19:47:45','2022-11-30 19:47:45',NULL),(184,7705,40720,1515,3,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',6000.46,NULL,NULL,1,'2022-11-30 19:48:16','2022-11-30 19:48:16',NULL),(185,7705,40720,1515,3,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',3000.14,NULL,NULL,1,'2022-11-30 19:49:07','2022-11-30 19:49:07',NULL);
INSERT INTO `balance_libro` VALUES (186,7705,40720,1515,2,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',176304.26,NULL,NULL,1,'2022-12-01 19:52:06','2022-12-01 19:52:06',NULL),(187,7705,40720,1515,2,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',268611.53,NULL,NULL,1,'2022-12-01 19:52:56','2022-12-01 19:52:56',NULL),(188,7705,40720,1515,2,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',284485.52,NULL,NULL,1,'2022-12-01 19:53:30','2022-12-01 19:53:30',NULL),(189,7705,40720,1515,2,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',118371.88,NULL,NULL,1,'2022-12-01 19:54:09','2022-12-01 19:54:09',NULL),(190,7705,40720,1515,2,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',12309.67,NULL,NULL,1,'2022-12-01 19:55:17','2022-12-01 19:55:17',NULL),(191,7705,40720,1515,15,531,'App\\Models\\PeriodLiquidation',NULL,531,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',147134.19,NULL,NULL,1,'2022-12-01 22:19:40','2022-12-01 22:19:40',NULL),(192,7705,40720,1515,16,532,'App\\Models\\PeriodLiquidation',NULL,532,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',102.18,NULL,NULL,1,'2022-12-01 22:20:46','2022-12-01 22:20:46',NULL),(193,7705,40720,1516,3,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',8804.49,NULL,NULL,1,'2022-12-09 10:43:03','2022-12-09 10:43:03',NULL),(194,7705,40720,1516,3,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',7134.80,NULL,NULL,1,'2022-12-09 10:43:37','2022-12-09 10:43:37',NULL),(195,7705,40720,1516,3,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',9201.87,NULL,NULL,1,'2022-12-09 10:44:21','2022-12-09 10:44:21',NULL),(196,7705,40720,1516,3,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1499.97,NULL,NULL,1,'2022-12-09 10:45:04','2022-12-09 10:45:04',NULL),(197,7705,40720,1516,3,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',9500.01,NULL,NULL,1,'2022-12-09 10:45:45','2022-12-09 10:45:45',NULL),(198,7705,40720,1516,3,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',7400.16,NULL,NULL,1,'2022-12-09 12:07:41','2022-12-09 12:07:41',NULL),(199,7705,40720,1516,3,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',13500.16,NULL,NULL,1,'2022-12-09 12:09:53','2022-12-09 12:09:53',NULL),(200,7705,40720,1516,3,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2999.65,NULL,NULL,1,'2022-12-09 12:10:33','2022-12-09 12:10:33',NULL),(201,7705,40720,1516,3,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2000.57,NULL,NULL,1,'2022-12-09 12:11:24','2022-12-09 12:11:24',NULL),(202,7705,40720,1516,3,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',8000.45,NULL,NULL,1,'2022-12-09 12:12:32','2022-12-09 12:12:32',NULL),(203,7705,40720,1516,3,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',12200.75,NULL,NULL,1,'2022-12-09 12:13:55','2022-12-09 12:13:55',NULL),(204,7705,40720,1516,3,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',8500.01,NULL,NULL,1,'2022-12-09 12:14:32','2022-12-09 12:14:32',NULL),(205,7705,40720,1516,3,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',9951.46,NULL,NULL,1,'2022-12-09 12:15:17','2022-12-09 12:15:17',NULL),(206,7705,40720,1516,3,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',15050.16,NULL,NULL,1,'2022-12-09 12:16:16','2022-12-09 12:16:16',NULL);
INSERT INTO `balance_libro` VALUES (207,7705,40720,1516,3,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',9999.63,NULL,NULL,1,'2022-12-09 12:17:08','2022-12-09 12:17:08',NULL),(208,7705,40720,1516,3,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-09','2022-10-09',4150.08,NULL,NULL,1,'2022-12-09 12:18:33','2022-12-09 12:18:33',NULL),(209,7705,40720,1516,3,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-09','2022-10-09',8500.00,NULL,NULL,1,'2022-12-09 12:19:21','2022-12-09 12:19:21',NULL),(210,7705,40720,1516,3,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',11201.78,NULL,NULL,1,'2022-12-09 12:20:04','2022-12-09 12:20:04',NULL),(211,7705,40720,1516,3,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',7000.23,NULL,NULL,1,'2022-12-09 12:20:46','2022-12-09 12:20:46',NULL),(212,7705,40720,1516,3,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',11106.00,NULL,NULL,1,'2022-12-09 12:21:19','2022-12-09 12:21:19',NULL),(213,7705,40720,1516,3,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',7000.06,NULL,NULL,1,'2022-12-09 12:22:05','2022-12-09 12:22:05',NULL),(214,7705,40720,1516,3,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',2999.65,NULL,NULL,1,'2022-12-20 19:10:05','2022-12-20 19:10:05',NULL),(215,7705,40720,1516,3,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',4999.32,NULL,NULL,1,'2022-12-20 19:11:20','2022-12-20 19:11:20',NULL),(216,7705,40720,1516,3,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',7000.23,NULL,NULL,1,'2022-12-20 19:12:31','2022-12-20 19:12:31',NULL),(217,7705,40720,1516,3,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',12000.39,NULL,NULL,1,'2022-12-20 19:13:30','2022-12-20 19:13:30',NULL),(218,7705,40720,1516,3,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',14000.54,NULL,NULL,1,'2022-12-20 19:14:19','2022-12-20 19:14:19',NULL),(219,7705,40720,1516,3,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',9999.49,NULL,NULL,1,'2022-12-20 19:16:04','2022-12-20 19:16:04',NULL),(220,7705,40720,1516,3,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',9999.79,NULL,NULL,1,'2022-12-20 19:17:03','2022-12-20 19:17:03',NULL),(221,7705,40720,1516,3,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',11900.14,NULL,NULL,1,'2022-12-22 20:23:28','2022-12-22 20:23:28',NULL),(222,7705,40720,1516,3,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',15600.35,NULL,NULL,1,'2022-12-22 20:24:24','2022-12-22 20:24:24',NULL),(223,7705,40720,1516,3,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',9454.37,NULL,NULL,1,'2022-12-22 20:25:05','2022-12-22 20:25:05',NULL),(224,7705,40720,1516,3,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',13750.00,NULL,NULL,1,'2022-12-22 20:25:56','2022-12-22 20:25:56',NULL),(225,7705,40720,1516,3,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',2999.60,NULL,NULL,1,'2022-12-22 20:26:25','2022-12-22 20:26:25',NULL),(226,7705,40720,1516,3,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1999.74,NULL,NULL,1,'2022-12-22 20:26:55','2022-12-22 20:26:55',NULL),(227,7705,40720,1516,3,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',14200.67,NULL,NULL,1,'2022-12-22 20:27:28','2022-12-22 20:27:28',NULL);
INSERT INTO `balance_libro` VALUES (228,7705,40720,1516,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',8800.61,NULL,NULL,1,'2022-12-22 20:28:04','2022-12-22 20:28:04',NULL),(229,7705,40720,1516,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1500.22,NULL,NULL,1,'2022-12-22 20:28:59','2022-12-22 20:28:59',NULL),(230,7705,40720,1516,3,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',9299.37,NULL,NULL,1,'2022-12-22 20:30:05','2022-12-22 20:30:05',NULL),(231,7705,40720,1516,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',13000.15,NULL,NULL,1,'2022-12-22 20:30:43','2022-12-22 20:30:43',NULL),(232,7705,40720,1516,3,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',12000.47,NULL,NULL,1,'2022-12-22 20:31:21','2022-12-22 20:31:21',NULL),(233,7705,40720,1516,3,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',13102.21,NULL,NULL,1,'2022-12-22 20:31:51','2022-12-22 20:31:51',NULL),(234,7705,40720,1516,3,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',10000.50,NULL,NULL,1,'2022-12-22 20:32:43','2022-12-22 20:32:43',NULL),(235,7705,40720,1516,3,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',11751.35,NULL,NULL,1,'2022-12-22 20:33:30','2022-12-22 20:33:30',NULL),(236,7705,40720,1516,3,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',11144.57,NULL,NULL,1,'2022-12-22 20:34:28','2022-12-22 20:34:28',NULL),(237,7705,40720,1516,3,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',10649.52,NULL,NULL,1,'2022-12-22 20:37:39','2022-12-22 20:37:39',NULL),(238,7705,40720,1516,3,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',4999.22,NULL,NULL,1,'2022-12-22 20:48:53','2022-12-22 20:48:53',NULL),(239,7705,40720,1516,3,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',3000.60,NULL,NULL,1,'2022-12-22 20:50:11','2022-12-22 20:50:11',NULL),(240,7705,40720,1516,3,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',8301.15,NULL,NULL,1,'2022-12-22 20:51:04','2022-12-22 20:51:04',NULL),(241,7705,40720,1516,3,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',10000.50,NULL,NULL,1,'2022-12-22 20:51:50','2022-12-22 20:51:50',NULL),(242,7705,40720,1516,3,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',13300.24,NULL,NULL,1,'2022-12-22 20:52:35','2022-12-22 20:52:35',NULL),(243,7705,40720,1516,3,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',10499.92,NULL,NULL,1,'2022-12-22 20:53:14','2022-12-22 20:53:14',NULL),(244,7705,40720,1516,3,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',10000.50,NULL,NULL,1,'2022-12-22 20:54:01','2022-12-22 20:54:01',NULL),(245,7705,40720,1516,3,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',11901.94,NULL,NULL,1,'2022-12-22 20:54:46','2022-12-22 20:54:46',NULL),(246,7705,40720,1516,3,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2000.10,NULL,NULL,1,'2022-12-26 21:27:27','2022-12-26 21:27:27',NULL),(247,7705,40720,1516,3,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2001.93,NULL,NULL,1,'2022-12-26 21:28:20','2022-12-26 21:28:20',NULL),(248,7705,40720,1516,3,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',8000.25,NULL,NULL,1,'2022-12-26 21:29:08','2022-12-26 21:29:08',NULL);
INSERT INTO `balance_libro` VALUES (249,7705,40720,1516,3,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',4199.80,NULL,NULL,1,'2022-12-26 21:29:42','2022-12-26 21:29:42',NULL),(250,7705,40720,1516,3,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1591.04,NULL,NULL,1,'2022-12-26 21:30:42','2022-12-26 21:30:42',NULL),(251,7705,40720,1516,3,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',10341.68,NULL,NULL,1,'2022-12-26 21:31:25','2022-12-26 21:31:25',NULL),(252,7705,40720,1516,3,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',3000.15,NULL,NULL,1,'2022-12-26 21:32:11','2022-12-26 21:32:11',NULL),(253,7705,40720,1516,3,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',5000.27,NULL,NULL,1,'2022-12-26 21:32:38','2022-12-26 21:32:38',NULL),(254,7705,40720,1516,3,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',7000.38,NULL,NULL,1,'2022-12-26 21:33:25','2022-12-26 21:33:25',NULL),(255,7705,40720,1516,3,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',4200.02,NULL,NULL,1,'2022-12-26 21:34:29','2022-12-26 21:34:29',NULL),(256,7705,40720,1516,3,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',10101.21,NULL,NULL,1,'2022-12-26 21:35:14','2022-12-26 21:35:14',NULL),(257,7705,40720,1516,3,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',11646.80,NULL,NULL,1,'2022-12-26 21:35:47','2022-12-26 21:35:47',NULL),(258,7705,40720,1516,3,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',3001.19,NULL,NULL,1,'2022-12-26 21:36:33','2022-12-26 21:36:33',NULL),(259,7705,40720,1516,3,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',10000.50,NULL,NULL,1,'2022-12-26 21:37:16','2022-12-26 21:37:16',NULL),(260,7705,40720,1516,3,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',8950.40,NULL,NULL,1,'2022-12-26 21:37:49','2022-12-26 21:37:49',NULL),(261,7705,40720,1516,3,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',18800.96,NULL,NULL,1,'2022-12-26 21:38:35','2022-12-26 21:38:35',NULL),(262,7705,40720,1516,3,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2000.10,NULL,NULL,1,'2022-12-26 21:39:05','2022-12-26 21:39:05',NULL),(263,7705,40720,1516,3,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',13402.14,NULL,NULL,1,'2022-12-26 21:39:37','2022-12-26 21:39:37',NULL),(264,7705,40720,1516,3,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',3000.15,NULL,NULL,1,'2022-12-26 21:40:10','2022-12-26 21:40:10',NULL),(265,7705,40720,1516,3,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',12213.32,NULL,NULL,1,'2022-12-26 21:40:38','2022-12-26 21:40:38',NULL),(266,7705,40720,1516,3,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',8999.42,NULL,NULL,1,'2022-12-26 21:41:17','2022-12-26 21:41:17',NULL),(267,7705,40720,1516,3,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',12000.64,NULL,NULL,1,'2022-12-26 21:41:56','2022-12-26 21:41:56',NULL),(268,7705,40720,1516,3,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',13500.00,NULL,NULL,1,'2022-12-26 21:42:23','2022-12-26 21:42:23',NULL),(269,7705,40720,1516,3,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',3000.15,NULL,NULL,1,'2022-12-26 21:42:52','2022-12-26 21:42:52',NULL);
INSERT INTO `balance_libro` VALUES (270,7705,40720,1516,3,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',14874.32,NULL,NULL,1,'2022-12-26 21:43:19','2022-12-26 21:43:19',NULL),(271,7705,40720,1516,3,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2000.10,NULL,NULL,1,'2022-12-26 21:43:46','2022-12-26 21:43:46',NULL),(272,7705,40720,1516,3,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1700.00,NULL,NULL,1,'2022-12-26 21:44:27','2022-12-26 21:44:27',NULL),(273,7705,40720,1516,3,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2000.10,NULL,NULL,1,'2022-12-26 21:45:01','2022-12-26 21:45:01',NULL),(274,7705,40720,1516,3,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',4499.83,NULL,NULL,1,'2022-12-26 21:45:27','2022-12-26 21:45:27',NULL),(275,7705,40720,1516,3,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',11000.57,NULL,NULL,1,'2022-12-26 21:45:59','2022-12-26 21:45:59',NULL),(276,7705,40720,1516,3,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1700.47,NULL,NULL,1,'2022-12-26 21:47:13','2022-12-26 21:47:13',NULL),(277,7705,40720,1516,3,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',9799.99,NULL,NULL,1,'2022-12-26 21:47:56','2022-12-26 21:47:56',NULL),(278,7705,40720,1516,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',499.92,NULL,NULL,1,'2022-12-26 21:49:18','2022-12-26 21:49:18',NULL),(279,7705,40720,1516,3,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',10000.50,NULL,NULL,1,'2022-12-26 21:49:58','2022-12-26 21:49:58',NULL),(280,7705,40720,1516,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',8750.17,NULL,NULL,1,'2022-12-26 21:50:28','2022-12-26 21:50:28',NULL),(281,7705,40720,1516,3,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',9999.70,NULL,NULL,1,'2022-12-26 21:51:07','2022-12-26 21:51:07',NULL),(282,7705,40720,1516,3,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',9799.99,NULL,NULL,1,'2022-12-26 21:51:37','2022-12-26 21:51:37',NULL),(283,7705,40720,1516,3,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',5000.27,NULL,NULL,1,'2022-12-26 21:52:04','2022-12-26 21:52:04',NULL),(284,7705,40720,1516,3,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',5000.01,NULL,NULL,1,'2022-12-26 21:52:30','2022-12-26 21:52:30',NULL),(285,7705,40720,1516,3,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',4690.54,NULL,NULL,1,'2022-12-26 21:53:42','2022-12-26 21:53:42',NULL),(286,7705,40720,1516,3,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2347.64,NULL,NULL,1,'2022-12-26 21:54:05','2022-12-26 21:54:05',NULL),(287,7705,40720,1516,3,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',12342.00,NULL,NULL,1,'2022-12-26 21:56:04','2022-12-26 21:56:04',NULL),(288,7705,40720,1516,3,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',930.01,NULL,NULL,1,'2022-12-26 21:57:20','2022-12-26 21:57:20',NULL),(289,7705,40720,1516,3,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1899.70,NULL,NULL,1,'2022-12-26 21:58:42','2022-12-26 21:58:42',NULL),(290,7705,40720,1516,3,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1230.00,NULL,NULL,1,'2022-12-26 22:09:09','2022-12-26 22:09:09',NULL);
INSERT INTO `balance_libro` VALUES (291,7705,40720,1516,3,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1499.87,NULL,NULL,1,'2022-12-26 22:12:36','2022-12-26 22:12:36',NULL),(292,7705,40720,1516,3,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',308550.00,NULL,NULL,1,'2022-12-26 22:14:42','2022-12-26 22:14:42',NULL),(293,7705,40720,1516,2,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',152262.77,NULL,NULL,1,'2022-12-26 22:23:28','2022-12-26 22:23:28',NULL),(294,7705,40720,1516,2,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',233052.05,NULL,NULL,1,'2022-12-26 22:24:02','2022-12-26 22:24:02',NULL),(295,7705,40720,1516,2,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',235313.54,NULL,NULL,1,'2022-12-26 22:24:34','2022-12-26 22:24:34',NULL),(296,7705,40720,1516,2,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',169748.48,NULL,NULL,1,'2022-12-26 22:25:03','2022-12-26 22:25:03',NULL),(297,7705,40720,1516,2,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',11476.27,NULL,NULL,1,'2022-12-26 22:25:52','2022-12-26 22:25:52',NULL),(298,7705,40745,3030,3,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',6000.30,NULL,NULL,1,'2023-01-02 22:21:07','2023-01-02 22:21:07',NULL),(299,7705,40745,3030,3,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',1999.86,NULL,NULL,1,'2023-01-02 22:21:49','2023-01-02 22:21:49',NULL),(300,7705,40745,3030,3,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',5001.40,NULL,NULL,1,'2023-01-02 22:22:52','2023-01-02 22:22:52',NULL),(301,7705,40745,3030,3,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',80002.36,NULL,NULL,1,'2023-01-02 22:24:21','2023-01-02 22:24:21',NULL),(302,7705,40745,3030,3,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',6000.49,NULL,NULL,1,'2023-01-02 22:25:07','2023-01-02 22:25:07',NULL),(303,7705,40745,3030,3,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',5090.01,NULL,NULL,1,'2023-01-02 22:28:17','2023-01-02 22:28:17',NULL),(304,7705,40745,3030,3,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',5400.02,NULL,NULL,1,'2023-01-02 22:29:42','2023-01-02 22:29:42',NULL),(305,7705,40720,1516,15,741,'App\\Models\\PeriodLiquidation',NULL,741,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',179741.98,NULL,NULL,1,'2023-01-04 20:12:38','2023-01-04 20:12:38',NULL),(306,7705,40720,1517,3,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',10000.32,NULL,NULL,1,'2023-01-16 10:25:27','2023-01-16 10:25:27',NULL),(307,7705,40720,1517,3,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4269.99,NULL,NULL,1,'2023-01-16 11:05:37','2023-01-16 11:05:37',NULL),(308,7705,40720,1517,3,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',11500.44,NULL,NULL,1,'2023-01-16 11:06:58','2023-01-16 11:06:58',NULL),(309,7705,40720,1517,3,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',12000.37,NULL,NULL,1,'2023-01-16 11:09:34','2023-01-16 11:09:34',NULL),(310,7705,40720,1517,3,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',10500.15,NULL,NULL,1,'2023-01-16 11:10:33','2023-01-16 11:10:33',NULL),(311,7705,40720,1517,3,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',10000.01,NULL,NULL,1,'2023-01-16 11:11:36','2023-01-16 11:11:36',NULL);
INSERT INTO `balance_libro` VALUES (312,7705,40720,1517,3,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',6999.97,NULL,NULL,1,'2023-01-16 11:12:32','2023-01-16 11:12:32',NULL),(313,7705,40720,1517,3,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',15802.09,NULL,NULL,1,'2023-01-16 11:13:52','2023-01-16 11:13:52',NULL),(314,7705,40720,1517,3,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',12000.00,NULL,NULL,1,'2023-01-16 11:14:30','2023-01-16 11:14:30',NULL),(315,7705,40720,1517,3,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',18738.06,NULL,NULL,1,'2023-01-16 11:15:30','2023-01-16 11:15:30',NULL),(316,7705,40720,1517,3,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',55705.00,NULL,NULL,1,'2023-01-16 11:28:50','2023-01-16 11:28:50',NULL),(317,7705,40720,1517,3,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2999.99,NULL,NULL,1,'2023-01-16 11:30:46','2023-01-16 11:30:46',NULL),(318,7705,40720,1517,3,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',1137.40,NULL,NULL,1,'2023-01-16 11:32:31','2023-01-16 11:32:31',NULL),(319,7705,40720,1517,3,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',3500.00,NULL,NULL,1,'2023-01-16 11:34:06','2023-01-16 11:34:06',NULL),(320,7705,40720,1517,3,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',2899.99,NULL,NULL,1,'2023-01-16 11:36:57','2023-01-16 11:36:57',NULL),(321,7705,40720,1517,3,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',3630.00,NULL,NULL,1,'2023-01-16 11:40:42','2023-01-17 09:02:01','2023-01-17 09:02:01'),(322,7705,40720,1517,3,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',18000.33,NULL,NULL,1,'2023-01-16 12:07:55','2023-01-16 12:07:55',NULL),(323,7705,40720,1517,3,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',19303.51,NULL,NULL,1,'2023-01-16 12:08:42','2023-01-16 12:08:42',NULL),(324,7705,40720,1517,3,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',15000.76,NULL,NULL,1,'2023-01-16 12:09:52','2023-01-16 12:09:52',NULL),(325,7705,40720,1517,3,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',12500.51,NULL,NULL,1,'2023-01-16 12:10:26','2023-01-16 12:10:26',NULL),(326,7705,40720,1517,3,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',9800.00,NULL,NULL,1,'2023-01-16 12:10:52','2023-01-16 12:10:52',NULL),(327,7705,40720,1517,3,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',9999.99,NULL,NULL,1,'2023-01-16 12:11:23','2023-01-16 12:11:23',NULL),(328,7705,40720,1517,3,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',10999.11,NULL,NULL,1,'2023-01-16 12:15:06','2023-01-16 12:15:06',NULL),(329,7705,40720,1517,3,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',8999.32,NULL,NULL,1,'2023-01-16 12:15:36','2023-01-16 12:15:36',NULL),(330,7705,40720,1517,3,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-13','2022-11-13',3802.12,NULL,NULL,1,'2023-01-16 12:17:11','2023-01-16 12:17:11',NULL),(331,7705,40720,1517,3,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-13','2022-11-13',4500.11,NULL,NULL,1,'2023-01-16 12:17:46','2023-01-16 12:17:46',NULL),(332,7705,40720,1517,3,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-13','2022-11-13',1999.84,NULL,NULL,1,'2023-01-16 12:18:16','2023-01-16 12:18:16',NULL);
INSERT INTO `balance_libro` VALUES (333,7705,40720,1517,3,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',11999.78,NULL,NULL,1,'2023-01-16 12:18:47','2023-01-16 12:18:47',NULL),(334,7705,40720,1517,3,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',2000.18,NULL,NULL,1,'2023-01-16 12:19:41','2023-01-16 12:19:41',NULL),(335,7705,40720,1517,3,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',1999.94,NULL,NULL,1,'2023-01-16 12:20:56','2023-01-16 12:20:56',NULL),(336,7705,40720,1517,3,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',3999.67,NULL,NULL,1,'2023-01-16 12:21:36','2023-01-16 12:21:36',NULL),(337,7705,40720,1517,3,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',3400.11,NULL,NULL,1,'2023-01-16 12:22:09','2023-01-16 12:22:09',NULL),(338,7705,40720,1517,3,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',6999.82,NULL,NULL,1,'2023-01-16 12:22:37','2023-01-16 12:22:37',NULL),(339,7705,40720,1517,3,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',2000.00,NULL,NULL,1,'2023-01-16 12:23:16','2023-01-16 12:23:16',NULL),(340,7705,40720,1517,3,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',12148.93,NULL,NULL,1,'2023-01-16 12:24:07','2023-01-16 12:24:07',NULL),(341,7705,40720,1517,3,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',10500.00,NULL,NULL,1,'2023-01-16 12:24:49','2023-01-16 12:24:49',NULL),(342,7705,40720,1517,3,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',2000.18,NULL,NULL,1,'2023-01-16 12:25:37','2023-01-16 12:25:37',NULL),(343,7705,40720,1517,3,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',11699.98,NULL,NULL,1,'2023-01-16 12:27:35','2023-01-16 12:27:35',NULL),(344,7705,40720,1517,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',13290.36,NULL,NULL,1,'2023-01-16 12:28:04','2023-01-16 12:28:04',NULL),(345,7705,40720,1517,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',4999.59,NULL,NULL,1,'2023-01-16 12:28:40','2023-01-16 12:28:40',NULL),(346,7705,40720,1517,2,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',4999.59,NULL,NULL,1,'2023-01-16 16:28:57','2023-01-16 17:59:19','2023-01-16 17:59:19'),(347,7705,40720,1517,2,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',2000.18,NULL,NULL,1,'2023-01-16 16:29:42','2023-01-16 17:59:19','2023-01-16 17:59:19'),(348,7705,40720,1517,2,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',3999.67,NULL,NULL,1,'2023-01-16 16:30:45','2023-01-16 17:59:19','2023-01-16 17:59:19'),(349,7705,40720,1517,2,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',11999.57,NULL,NULL,1,'2023-01-16 16:31:27','2023-01-16 17:59:19','2023-01-16 17:59:19'),(350,7705,40720,1517,2,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',12301.09,NULL,NULL,1,'2023-01-16 16:32:03','2023-01-16 17:59:19','2023-01-16 17:59:19'),(351,7705,40720,1517,2,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',17799.58,NULL,NULL,1,'2023-01-16 16:32:39','2023-01-16 17:59:19','2023-01-16 17:59:19'),(352,7705,40720,1517,2,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',12500.00,NULL,NULL,1,'2023-01-16 16:33:15','2023-01-16 17:59:19','2023-01-16 17:59:19');
INSERT INTO `balance_libro` VALUES (353,7705,40720,1517,2,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',15499.99,NULL,NULL,1,'2023-01-16 16:33:54','2023-01-16 17:59:19','2023-01-16 17:59:19'),(354,7705,40720,1517,2,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',13201.24,NULL,NULL,1,'2023-01-16 16:34:37','2023-01-16 17:59:19','2023-01-16 17:59:19'),(355,7705,40720,1517,2,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',18999.39,NULL,NULL,1,'2023-01-16 16:35:18','2023-01-16 17:59:19','2023-01-16 17:59:19'),(356,7705,40720,1517,2,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',16003.92,NULL,NULL,1,'2023-01-16 16:35:58','2023-01-16 17:59:19','2023-01-16 17:59:19'),(357,7705,40720,1517,2,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',1999.84,NULL,NULL,1,'2023-01-16 16:36:40','2023-01-16 17:59:19','2023-01-16 17:59:19'),(358,7705,40720,1517,2,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',19300.58,NULL,NULL,1,'2023-01-16 16:37:35','2023-01-16 17:59:19','2023-01-16 17:59:19'),(359,7705,40720,1517,2,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',15999.62,NULL,NULL,1,'2023-01-16 16:43:56','2023-01-16 17:59:19','2023-01-16 17:59:19'),(360,7705,40720,1517,2,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',12299.99,NULL,NULL,1,'2023-01-16 16:44:48','2023-01-16 17:59:19','2023-01-16 17:59:19'),(361,7705,40720,1517,2,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',5000.00,NULL,NULL,1,'2023-01-16 16:45:19','2023-01-16 17:59:19','2023-01-16 17:59:19'),(362,7705,40720,1517,2,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',7803.06,NULL,NULL,1,'2023-01-16 16:45:50','2023-01-16 17:59:19','2023-01-16 17:59:19'),(363,7705,40720,1517,2,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',2000.18,NULL,NULL,1,'2023-01-16 16:46:35','2023-01-16 17:59:19','2023-01-16 17:59:19'),(364,7705,40720,1517,2,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',3999.67,NULL,NULL,1,'2023-01-16 16:47:17','2023-01-16 17:59:20','2023-01-16 17:59:20'),(365,7705,40720,1517,2,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',8000.23,NULL,NULL,1,'2023-01-16 16:48:02','2023-01-16 17:59:20','2023-01-16 17:59:20'),(366,7705,40720,1517,2,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',999.92,NULL,NULL,1,'2023-01-16 16:52:45','2023-01-16 17:59:20','2023-01-16 17:59:20'),(367,7705,40720,1517,2,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',2999.99,NULL,NULL,1,'2023-01-16 16:53:42','2023-01-16 17:59:20','2023-01-16 17:59:20'),(368,7705,40720,1517,2,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',3900.00,NULL,NULL,1,'2023-01-16 16:55:27','2023-01-16 17:59:20','2023-01-16 17:59:20'),(369,7705,40720,1517,2,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',5200.00,NULL,NULL,1,'2023-01-16 16:56:18','2023-01-16 17:59:20','2023-01-16 17:59:20'),(370,7705,40720,1517,2,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',1000.08,NULL,NULL,1,'2023-01-16 16:57:29','2023-01-16 17:59:20','2023-01-16 17:59:20'),(371,7705,40720,1517,2,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',25001.24,NULL,NULL,1,'2023-01-16 16:58:26','2023-01-16 17:59:20','2023-01-16 17:59:20');
INSERT INTO `balance_libro` VALUES (372,7705,40720,1517,2,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',19499.72,NULL,NULL,1,'2023-01-16 16:59:15','2023-01-16 17:59:20','2023-01-16 17:59:20'),(373,7705,40720,1517,2,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',9801.48,NULL,NULL,1,'2023-01-16 17:00:02','2023-01-16 17:59:20','2023-01-16 17:59:20'),(374,7705,40720,1517,2,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',16251.34,NULL,NULL,1,'2023-01-16 17:00:44','2023-01-16 17:59:20','2023-01-16 17:59:20'),(375,7705,40720,1517,2,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',1999.84,NULL,NULL,1,'2023-01-16 17:02:45','2023-01-16 17:59:20','2023-01-16 17:59:20'),(376,7705,40720,1517,2,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',18400.90,NULL,NULL,1,'2023-01-16 17:03:39','2023-01-16 17:58:59','2023-01-16 17:58:59'),(377,7705,40720,1517,2,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',20699.92,NULL,NULL,1,'2023-01-16 17:04:23','2023-01-16 17:58:54','2023-01-16 17:58:54'),(378,7705,40720,1517,2,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',5700.77,NULL,NULL,1,'2023-01-16 17:05:24','2023-01-16 17:58:49','2023-01-16 17:58:49'),(379,7705,40720,1517,2,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',18700.01,NULL,NULL,1,'2023-01-16 17:09:55','2023-01-16 17:58:43','2023-01-16 17:58:43'),(380,7705,40720,1517,2,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',13500.01,NULL,NULL,1,'2023-01-16 17:10:42','2023-01-16 17:58:37','2023-01-16 17:58:37'),(381,7705,40720,1517,2,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',12500.00,NULL,NULL,1,'2023-01-16 17:11:27','2023-01-16 17:58:32','2023-01-16 17:58:32'),(382,7705,40720,1517,2,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',3999.67,NULL,NULL,1,'2023-01-16 17:43:30','2023-01-16 17:58:27','2023-01-16 17:58:27'),(383,7705,40720,1517,2,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',12500.00,NULL,NULL,1,'2023-01-16 17:47:36','2023-01-16 17:58:14','2023-01-16 17:58:14'),(384,7705,40720,1517,2,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1999.84,NULL,NULL,1,'2023-01-16 17:48:10','2023-01-16 17:58:08','2023-01-16 17:58:08'),(385,7705,40720,1517,2,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',14100.70,NULL,NULL,1,'2023-01-16 17:49:17','2023-01-16 17:58:03','2023-01-16 17:58:03'),(386,7705,40720,1517,2,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',2000.00,NULL,NULL,1,'2023-01-16 17:50:01','2023-01-16 17:57:58','2023-01-16 17:57:58'),(387,7705,40720,1517,2,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',22424.91,NULL,NULL,1,'2023-01-16 17:51:27','2023-01-16 17:57:52','2023-01-16 17:57:52'),(388,7705,40720,1517,2,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2999.75,NULL,NULL,1,'2023-01-16 17:51:58','2023-01-16 17:57:46','2023-01-16 17:57:46'),(389,7705,40720,1517,2,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',18300.77,NULL,NULL,1,'2023-01-16 17:53:06','2023-01-16 17:57:40','2023-01-16 17:57:40'),(390,7705,40720,1517,2,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1899.70,NULL,NULL,1,'2023-01-16 17:55:24','2023-01-16 17:57:34','2023-01-16 17:57:34');
INSERT INTO `balance_libro` VALUES (391,7705,40720,1517,3,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',2000.18,NULL,NULL,1,'2023-01-16 18:20:30','2023-01-16 18:20:30',NULL),(392,7705,40720,1517,3,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',3999.67,NULL,NULL,1,'2023-01-16 18:21:46','2023-01-16 18:21:46',NULL),(393,7705,40720,1517,3,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',11999.57,NULL,NULL,1,'2023-01-16 18:25:54','2023-01-16 18:25:54',NULL),(394,7705,40720,1517,3,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',12301.09,NULL,NULL,1,'2023-01-16 18:26:33','2023-01-16 18:26:33',NULL),(395,7705,40720,1517,3,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',17799.58,NULL,NULL,1,'2023-01-16 18:27:12','2023-01-16 18:27:12',NULL),(396,7705,40720,1517,3,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',12500.00,NULL,NULL,1,'2023-01-16 18:38:14','2023-01-16 18:38:14',NULL),(397,7705,40720,1517,3,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',15499.99,NULL,NULL,1,'2023-01-16 18:38:49','2023-01-16 18:38:49',NULL),(398,7705,40720,1517,3,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',13201.24,NULL,NULL,1,'2023-01-16 18:39:38','2023-01-16 18:39:38',NULL),(399,7705,40720,1517,3,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',18999.39,NULL,NULL,1,'2023-01-16 18:40:23','2023-01-16 18:40:23',NULL),(400,7705,40720,1517,3,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',16003.92,NULL,NULL,1,'2023-01-16 18:40:55','2023-01-16 18:40:55',NULL),(401,7705,40720,1517,3,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',1999.84,NULL,NULL,1,'2023-01-16 18:41:27','2023-01-16 18:41:27',NULL),(402,7705,40720,1517,3,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',19300.58,NULL,NULL,1,'2023-01-16 18:44:56','2023-01-16 18:44:56',NULL),(403,7705,40720,1517,3,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',15999.62,NULL,NULL,1,'2023-01-16 18:50:48','2023-01-16 18:50:48',NULL),(404,7705,40720,1517,3,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',12299.99,NULL,NULL,1,'2023-01-16 18:51:37','2023-01-16 18:51:37',NULL),(405,7705,40720,1517,3,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',5000.00,NULL,NULL,1,'2023-01-16 18:52:07','2023-01-16 18:52:07',NULL),(406,7705,40720,1517,3,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',7803.06,NULL,NULL,1,'2023-01-16 18:52:33','2023-01-16 18:52:33',NULL),(407,7705,40720,1517,3,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',2000.18,NULL,NULL,1,'2023-01-16 18:53:47','2023-01-16 18:53:47',NULL),(408,7705,40720,1517,3,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',3999.67,NULL,NULL,1,'2023-01-16 18:55:11','2023-01-16 18:55:11',NULL),(409,7705,40720,1517,3,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',8000.23,NULL,NULL,1,'2023-01-16 18:55:38','2023-01-16 18:55:38',NULL),(410,7705,40720,1517,3,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',999.92,NULL,NULL,1,'2023-01-16 19:01:51','2023-01-16 19:01:51',NULL),(411,7705,40720,1517,3,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',2999.99,NULL,NULL,1,'2023-01-16 19:02:30','2023-01-16 19:02:30',NULL);
INSERT INTO `balance_libro` VALUES (412,7705,40720,1517,3,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',1000.08,NULL,NULL,1,'2023-01-16 19:03:12','2023-01-16 19:03:12',NULL),(413,7705,40720,1517,3,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',3900.00,NULL,NULL,1,'2023-01-16 19:05:17','2023-01-16 19:05:17',NULL),(414,7705,40720,1517,3,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',5200.00,NULL,NULL,1,'2023-01-16 19:06:10','2023-01-16 19:06:10',NULL),(415,7705,40720,1517,3,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',25001.24,NULL,NULL,1,'2023-01-16 19:09:18','2023-01-16 19:09:18',NULL),(416,7705,40720,1517,3,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',19499.72,NULL,NULL,1,'2023-01-16 19:10:20','2023-01-16 19:10:20',NULL),(417,7705,40720,1517,3,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',9801.48,NULL,NULL,1,'2023-01-16 19:11:40','2023-01-16 19:11:40',NULL),(418,7705,40720,1517,3,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',16251.34,NULL,NULL,1,'2023-01-16 19:13:14','2023-01-16 19:13:14',NULL),(419,7705,40720,1517,3,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',1999.84,NULL,NULL,1,'2023-01-16 19:13:41','2023-01-16 19:13:41',NULL),(420,7705,40720,1517,3,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',18400.90,NULL,NULL,1,'2023-01-16 19:14:10','2023-01-16 19:14:10',NULL),(421,7705,40720,1517,3,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',20699.92,NULL,NULL,1,'2023-01-16 19:14:36','2023-01-16 19:14:36',NULL),(422,7705,40720,1517,3,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',5700.77,NULL,NULL,1,'2023-01-16 19:17:33','2023-01-16 19:17:33',NULL),(423,7705,40720,1517,3,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',18700.01,NULL,NULL,1,'2023-01-16 19:19:28','2023-01-16 19:19:28',NULL),(424,7705,40720,1517,3,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',13500.01,NULL,NULL,1,'2023-01-16 19:20:13','2023-01-16 19:20:13',NULL),(425,7705,40720,1517,3,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',12500.00,NULL,NULL,1,'2023-01-16 19:20:46','2023-01-16 19:20:46',NULL),(426,7705,40720,1517,3,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',3999.67,NULL,NULL,1,'2023-01-16 19:21:11','2023-01-16 19:21:11',NULL),(427,7705,40720,1517,3,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',12500.00,NULL,NULL,1,'2023-01-16 19:21:48','2023-01-16 19:21:48',NULL),(428,7705,40720,1517,3,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1999.84,NULL,NULL,1,'2023-01-16 19:22:27','2023-01-16 19:22:27',NULL),(429,7705,40720,1517,3,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',14100.70,NULL,NULL,1,'2023-01-16 19:23:33','2023-01-16 19:23:33',NULL),(430,7705,40720,1517,3,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',2000.00,NULL,NULL,1,'2023-01-16 19:24:42','2023-01-16 19:24:42',NULL),(431,7705,40720,1517,3,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',22424.91,NULL,NULL,1,'2023-01-16 19:25:18','2023-01-16 19:25:18',NULL),(432,7705,40720,1517,3,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2999.75,NULL,NULL,1,'2023-01-16 19:31:18','2023-01-16 19:31:18',NULL);
INSERT INTO `balance_libro` VALUES (433,7705,40720,1517,3,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',18300.77,NULL,NULL,1,'2023-01-16 19:31:51','2023-01-16 19:31:51',NULL),(434,7705,40720,1517,3,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1899.70,NULL,NULL,1,'2023-01-16 19:32:53','2023-01-16 19:32:53',NULL),(435,7705,40720,1517,15,1045,'App\\Models\\PeriodLiquidation',NULL,1045,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',170227.75,NULL,NULL,1,'2023-01-17 08:55:33','2023-01-17 09:01:33','2023-01-17 09:01:33'),(436,7705,40720,1517,15,1047,'App\\Models\\PeriodLiquidation',NULL,1047,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',169694.94,NULL,NULL,1,'2023-01-17 09:02:57','2023-01-17 09:02:57',NULL),(437,7705,40745,3030,2,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',120000.00,NULL,NULL,1,'2023-01-18 10:51:15','2023-01-18 10:51:15',NULL),(438,7705,40745,3030,16,1050,'App\\Models\\PeriodLiquidation',NULL,1050,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',0.00,NULL,NULL,1,'2023-01-18 10:51:48','2023-01-18 10:51:48',NULL),(439,7705,40745,3030,15,1049,'App\\Models\\PeriodLiquidation',NULL,1049,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',20826.45,NULL,NULL,1,'2023-01-18 10:52:27','2023-01-18 10:52:27',NULL),(440,7705,40720,1518,3,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',104076.95,NULL,NULL,1,'2023-01-19 07:42:44','2023-01-19 07:42:44',NULL),(441,7705,40720,1518,3,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',44992.37,NULL,NULL,1,'2023-01-19 07:43:20','2023-01-19 07:43:20',NULL),(442,7705,40720,1518,3,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',16501.32,NULL,NULL,1,'2023-01-19 07:47:08','2023-01-19 07:47:08',NULL),(443,7705,40720,1518,3,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',14701.45,NULL,NULL,1,'2023-01-19 07:49:01','2023-01-19 07:49:01',NULL),(444,7705,40720,1518,3,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',13301.99,NULL,NULL,1,'2023-01-19 07:49:56','2023-01-19 07:49:56',NULL),(445,7705,40720,1518,3,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',8001.64,NULL,NULL,1,'2023-01-19 07:53:10','2023-01-19 07:53:10',NULL),(446,7705,40720,1518,3,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',9500.18,NULL,NULL,1,'2023-01-19 07:56:35','2023-01-19 07:56:35',NULL),(447,7705,40720,1518,3,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',10703.00,NULL,NULL,1,'2023-01-19 07:58:09','2023-01-19 07:58:09',NULL),(448,7705,40720,1518,3,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',12001.33,NULL,NULL,1,'2023-01-19 07:58:47','2023-01-19 07:58:47',NULL),(449,7705,40720,1518,3,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',4200.14,NULL,NULL,1,'2023-01-19 07:59:25','2023-01-19 07:59:25',NULL),(450,7705,40720,1518,3,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',9999.25,NULL,NULL,1,'2023-01-19 08:00:06','2023-01-19 08:00:06',NULL),(451,7705,40720,1518,3,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-13','2022-11-13',15397.53,NULL,NULL,1,'2023-01-19 08:00:45','2023-01-19 08:00:45',NULL),(452,7705,40720,1518,3,439,'App\\Models\\Receipt',439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',15700.40,NULL,NULL,1,'2023-01-19 08:01:49','2023-01-19 08:01:49',NULL),(453,7705,40720,1518,3,440,'App\\Models\\Receipt',440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',11001.40,NULL,NULL,1,'2023-01-19 08:02:27','2023-01-19 08:02:27',NULL);
INSERT INTO `balance_libro` VALUES (454,7705,40720,1518,3,441,'App\\Models\\Receipt',441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',16101.25,NULL,NULL,1,'2023-01-19 08:03:05','2023-01-19 08:03:05',NULL),(455,7705,40720,1518,3,442,'App\\Models\\Receipt',442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',7700.77,NULL,NULL,1,'2023-01-19 08:03:37','2023-01-19 08:03:37',NULL),(456,7705,40720,1518,3,443,'App\\Models\\Receipt',443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',17000.96,NULL,NULL,1,'2023-01-19 08:04:08','2023-01-19 08:04:08',NULL),(457,7705,40720,1518,3,444,'App\\Models\\Receipt',444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',5500.70,NULL,NULL,1,'2023-01-19 08:05:36','2023-01-19 08:05:36',NULL),(458,7705,40720,1518,3,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-27','2022-11-27',6540.72,NULL,NULL,1,'2023-01-19 08:06:07','2023-01-19 08:06:07',NULL),(459,7705,40720,1518,3,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-27','2022-11-27',12152.77,NULL,NULL,1,'2023-01-19 08:06:46','2023-01-19 08:06:46',NULL),(460,7705,40720,1518,3,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',10856.65,NULL,NULL,1,'2023-01-19 08:07:23','2023-01-19 08:07:23',NULL),(461,7705,40720,1518,3,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',16201.47,NULL,NULL,1,'2023-01-19 08:08:00','2023-01-19 08:08:00',NULL),(462,7705,40720,1518,3,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',8202.06,NULL,NULL,1,'2023-01-19 08:08:34','2023-01-19 08:08:34',NULL),(463,7705,40720,1518,3,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',12304.21,NULL,NULL,1,'2023-01-19 08:09:06','2023-01-19 08:09:06',NULL),(464,7705,40720,1518,3,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',12602.63,NULL,NULL,1,'2023-01-19 08:09:42','2023-01-19 08:09:42',NULL),(465,7705,40720,1518,3,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',3999.71,NULL,NULL,1,'2023-01-19 08:10:23','2023-01-19 08:10:23',NULL),(466,7705,40720,1518,3,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',3499.74,NULL,NULL,1,'2023-01-19 08:12:23','2023-01-19 08:12:23',NULL),(467,7705,40720,1518,3,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',999.92,NULL,NULL,1,'2023-01-19 08:13:16','2023-01-19 08:13:16',NULL),(468,7705,40720,1518,3,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',12499.99,NULL,NULL,1,'2023-01-19 08:13:51','2023-01-19 08:13:51',NULL),(469,7705,40720,1518,3,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',3999.87,NULL,NULL,1,'2023-01-19 08:14:22','2023-01-19 08:14:22',NULL),(470,7705,40720,1518,3,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',2999.78,NULL,NULL,1,'2023-01-19 08:15:51','2023-01-19 08:15:51',NULL),(471,7705,40720,1518,3,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',12000.07,NULL,NULL,1,'2023-01-19 08:16:24','2023-01-19 08:16:24',NULL),(472,7705,40720,1518,3,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',5999.55,NULL,NULL,1,'2023-01-19 08:16:52','2023-01-19 08:16:52',NULL),(473,7705,40720,1518,3,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',2999.78,NULL,NULL,1,'2023-01-19 08:17:18','2023-01-19 08:17:18',NULL),(474,7705,40720,1518,3,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',3999.70,NULL,NULL,1,'2023-01-19 08:17:47','2023-01-19 08:17:47',NULL);
INSERT INTO `balance_libro` VALUES (475,7705,40720,1518,3,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',13007.02,NULL,NULL,1,'2023-01-19 08:18:24','2023-01-19 08:18:24',NULL),(476,7705,40720,1518,3,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',14000.92,NULL,NULL,1,'2023-01-19 08:19:04','2023-01-19 08:19:04',NULL),(477,7705,40720,1518,3,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',13500.00,NULL,NULL,1,'2023-01-19 08:19:37','2023-01-19 08:19:37',NULL),(478,7705,40720,1518,3,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',10000.21,NULL,NULL,1,'2023-01-19 08:20:08','2023-01-19 08:20:08',NULL),(479,7705,40720,1518,3,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',19999.47,NULL,NULL,1,'2023-01-19 08:21:34','2023-01-19 08:21:34',NULL),(480,7705,40720,1518,3,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',2999.78,NULL,NULL,1,'2023-01-19 08:22:08','2023-01-19 08:22:08',NULL),(481,7705,40720,1518,3,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',3999.70,NULL,NULL,1,'2023-01-19 08:22:45','2023-01-19 08:22:45',NULL),(482,7705,40720,1518,3,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',10699.80,NULL,NULL,1,'2023-01-19 08:23:14','2023-01-19 08:23:14',NULL),(483,7705,40720,1518,3,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',14175.92,NULL,NULL,1,'2023-01-19 08:23:45','2023-01-19 08:23:45',NULL),(484,7705,40720,1518,3,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',15100.69,NULL,NULL,1,'2023-01-19 08:24:14','2023-01-19 08:24:14',NULL),(485,7705,40720,1518,3,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',15251.00,NULL,NULL,1,'2023-01-19 08:24:39','2023-01-19 08:24:39',NULL),(486,7705,40720,1518,3,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',2999.99,NULL,NULL,1,'2023-01-19 08:25:07','2023-01-19 08:25:07',NULL),(487,7705,40720,1518,3,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',4000.00,NULL,NULL,1,'2023-01-19 08:25:34','2023-01-19 08:25:34',NULL),(488,7705,40720,1518,3,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',9999.99,NULL,NULL,1,'2023-01-19 08:25:59','2023-01-19 08:25:59',NULL),(489,7705,40720,1518,3,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1899.70,NULL,NULL,1,'2023-01-19 08:27:24','2023-01-19 08:27:24',NULL),(490,7705,40720,1518,3,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1899.70,NULL,NULL,1,'2023-01-19 08:27:59','2023-01-19 08:27:59',NULL),(491,7705,40720,1518,3,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',4741.54,NULL,NULL,1,'2023-01-19 08:29:10','2023-01-19 08:29:10',NULL),(492,7705,40720,1518,3,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',3489.99,NULL,NULL,1,'2023-01-19 08:30:42','2023-01-19 08:30:42',NULL),(493,7705,40720,1518,3,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',4000.00,NULL,NULL,1,'2023-01-19 08:32:45','2023-01-19 08:32:45',NULL),(494,7705,40720,1518,3,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',4000.00,NULL,NULL,1,'2023-01-19 08:33:19','2023-01-19 08:33:19',NULL),(495,7705,40720,1518,3,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',14999.99,NULL,NULL,1,'2023-01-19 08:33:50','2023-01-19 08:33:50',NULL);
INSERT INTO `balance_libro` VALUES (496,7705,40720,1518,3,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',4000.00,NULL,NULL,1,'2023-01-19 08:34:22','2023-01-19 08:34:22',NULL),(497,7705,40720,1518,3,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',4000.00,NULL,NULL,1,'2023-01-19 08:34:44','2023-01-19 08:34:44',NULL),(498,7705,40720,1518,3,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',4859.23,NULL,NULL,1,'2023-01-19 08:36:04','2023-01-19 08:36:04',NULL),(499,7705,40720,1518,3,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',11000.00,NULL,NULL,1,'2023-01-19 08:36:50','2023-01-19 08:36:50',NULL),(500,7705,40720,1518,3,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',8000.02,NULL,NULL,1,'2023-01-19 08:37:23','2023-01-19 08:37:23',NULL),(501,7705,40720,1518,3,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',14999.99,NULL,NULL,1,'2023-01-19 08:38:10','2023-01-19 08:38:10',NULL),(502,7705,40720,1518,3,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',5000.00,NULL,NULL,1,'2023-01-19 08:38:36','2023-01-19 08:38:36',NULL),(503,7705,40720,1518,3,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',10200.00,NULL,NULL,1,'2023-01-19 08:39:02','2023-01-19 08:39:02',NULL),(504,7705,40720,1518,3,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',10700.41,NULL,NULL,1,'2023-01-19 08:40:55','2023-01-19 08:40:55',NULL),(505,7705,40720,1518,3,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',9000.00,NULL,NULL,1,'2023-01-19 08:41:29','2023-01-19 08:41:29',NULL),(506,7705,40720,1518,3,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',23451.09,NULL,NULL,1,'2023-01-19 08:42:13','2023-01-19 08:42:13',NULL),(507,7705,40720,1518,3,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',4000.00,NULL,NULL,1,'2023-01-19 08:43:54','2023-01-19 08:43:54',NULL),(508,7705,40720,1518,3,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',7999.41,NULL,NULL,1,'2023-01-19 08:44:36','2023-01-19 08:44:36',NULL),(509,7705,40720,1518,3,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',8999.85,NULL,NULL,1,'2023-01-19 08:45:02','2023-01-19 08:45:02',NULL),(510,7705,40720,1518,3,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',2000.01,NULL,NULL,1,'2023-01-19 08:45:26','2023-01-19 08:45:26',NULL),(511,7705,40720,1518,3,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',8000.11,NULL,NULL,1,'2023-01-19 08:45:59','2023-01-19 08:45:59',NULL),(512,7705,40720,1518,3,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',21401.30,NULL,NULL,1,'2023-01-19 08:46:30','2023-01-19 08:46:30',NULL),(513,7705,40720,1518,3,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',4999.66,NULL,NULL,1,'2023-01-19 08:46:53','2023-01-19 08:46:53',NULL),(514,7705,40720,1518,3,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',10001.23,NULL,NULL,1,'2023-01-19 08:47:40','2023-01-19 08:47:40',NULL),(515,7705,40720,1518,3,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',12401.30,NULL,NULL,1,'2023-01-19 08:48:26','2023-01-19 08:48:26',NULL),(516,7705,40720,1518,3,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2000.07,NULL,NULL,1,'2023-01-19 08:49:04','2023-01-19 08:49:04',NULL);
INSERT INTO `balance_libro` VALUES (517,7705,40720,1518,3,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',9000.24,NULL,NULL,1,'2023-01-19 08:49:46','2023-01-19 08:49:46',NULL),(518,7705,40720,1518,3,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',4999.80,NULL,NULL,1,'2023-01-19 08:50:25','2023-01-19 08:50:25',NULL),(519,7705,40720,1518,3,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',10099.96,NULL,NULL,1,'2023-01-19 08:50:57','2023-01-19 08:50:57',NULL),(520,7705,40720,1518,3,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',15000.96,NULL,NULL,1,'2023-01-19 08:52:00','2023-01-19 08:52:00',NULL),(521,7705,40720,1518,3,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',10000.42,NULL,NULL,1,'2023-01-19 08:52:32','2023-01-19 08:52:32',NULL),(522,7705,40720,1518,3,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',8999.62,NULL,NULL,1,'2023-01-19 08:53:09','2023-01-19 08:53:09',NULL),(523,7705,40720,1518,3,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',27265.17,NULL,NULL,1,'2023-01-19 08:54:11','2023-01-19 08:54:11',NULL),(524,7705,40720,1518,3,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',87627.14,NULL,NULL,1,'2023-01-19 08:55:53','2023-01-19 08:55:53',NULL),(525,7705,40720,1518,3,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',5999.59,NULL,NULL,1,'2023-01-19 08:57:06','2023-01-19 08:57:06',NULL),(526,7705,40720,1518,3,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',14400.79,NULL,NULL,1,'2023-01-19 08:57:36','2023-01-19 08:57:36',NULL),(527,7705,40720,1518,3,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',6999.99,NULL,NULL,1,'2023-01-19 08:58:28','2023-01-19 08:58:28',NULL),(528,7705,40720,1518,3,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',13500.00,NULL,NULL,1,'2023-01-19 08:59:14','2023-01-19 08:59:14',NULL),(529,7705,40720,1518,3,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',12500.00,NULL,NULL,1,'2023-01-19 08:59:42','2023-01-19 08:59:42',NULL),(530,7705,40720,1518,3,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',12500.00,NULL,NULL,1,'2023-01-19 09:00:15','2023-01-19 09:00:15',NULL),(531,7705,40720,1518,3,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',4200.55,NULL,NULL,1,'2023-01-19 09:01:04','2023-01-19 09:01:04',NULL),(532,7705,40720,1518,3,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',8000.40,NULL,NULL,1,'2023-01-19 09:01:43','2023-01-19 09:01:43',NULL),(533,7705,40720,1518,3,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',3999.71,NULL,NULL,1,'2023-01-19 09:02:09','2023-01-19 09:02:09',NULL),(534,7705,40720,1518,3,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',13400.35,NULL,NULL,1,'2023-01-19 09:02:49','2023-01-19 09:02:49',NULL),(535,7705,40720,1518,3,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',3999.92,NULL,NULL,1,'2023-01-19 09:03:26','2023-01-19 09:03:26',NULL),(536,7705,40720,1518,3,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',94700.00,NULL,NULL,1,'2023-01-19 09:05:37','2023-01-19 09:05:37',NULL),(537,7705,40720,1518,3,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',3340.00,NULL,NULL,1,'2023-01-19 09:06:24','2023-01-19 09:06:24',NULL);
INSERT INTO `balance_libro` VALUES (538,7705,40720,1518,3,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',3267.00,NULL,NULL,1,'2023-01-19 09:10:14','2023-01-19 09:10:14',NULL),(539,7705,40720,1518,3,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',999.92,NULL,NULL,1,'2023-01-19 09:11:33','2023-01-19 09:11:33',NULL),(540,7705,40720,1518,3,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',8000.40,NULL,NULL,1,'2023-01-19 09:12:01','2023-01-19 09:12:01',NULL),(541,7705,40720,1518,3,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',8001.49,NULL,NULL,1,'2023-01-19 09:12:42','2023-01-19 09:12:42',NULL),(542,7705,40720,1518,3,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',10800.57,NULL,NULL,1,'2023-01-19 09:13:25','2023-01-19 09:13:25',NULL),(543,7705,40720,1518,3,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',9262.72,NULL,NULL,1,'2023-01-19 09:13:58','2023-01-19 09:13:58',NULL),(544,7705,40720,1518,3,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',8000.40,NULL,NULL,1,'2023-01-19 09:14:37','2023-01-19 09:14:37',NULL),(545,7705,40720,1518,3,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',4999.66,NULL,NULL,1,'2023-01-19 09:15:26','2023-01-19 09:15:26',NULL),(546,7705,40720,1518,3,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',4999.66,NULL,NULL,1,'2023-01-19 09:16:29','2023-01-19 09:16:29',NULL),(547,7705,40720,1518,3,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',7499.46,NULL,NULL,1,'2023-01-19 09:17:03','2023-01-19 09:17:03',NULL),(548,7705,40720,1518,3,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',7000.01,NULL,NULL,1,'2023-01-19 09:17:32','2023-01-19 09:17:32',NULL),(549,7705,40720,1518,3,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',999.25,NULL,NULL,1,'2023-01-19 09:18:08','2023-01-19 09:18:08',NULL),(550,7705,40720,1518,3,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',7999.98,NULL,NULL,1,'2023-01-19 09:19:02','2023-01-19 09:19:02',NULL),(551,7705,40720,1518,3,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',5000.00,NULL,NULL,1,'2023-01-19 09:19:29','2023-01-19 09:19:29',NULL),(552,7705,40720,1518,3,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',12500.00,NULL,NULL,1,'2023-01-19 09:19:57','2023-01-19 09:19:57',NULL),(553,7705,40720,1518,3,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2000.01,NULL,NULL,1,'2023-01-19 09:20:23','2023-01-19 09:20:23',NULL),(554,7705,40720,1518,3,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',999.97,NULL,NULL,1,'2023-01-19 09:21:05','2023-01-19 09:21:05',NULL),(555,7705,40720,1518,3,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',12500.00,NULL,NULL,1,'2023-01-19 09:21:41','2023-01-19 09:21:41',NULL),(556,7705,40720,1518,3,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2000.01,NULL,NULL,1,'2023-01-19 09:22:06','2023-01-19 09:22:06',NULL),(557,7705,40720,1518,3,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',28950.00,NULL,NULL,1,'2023-01-19 09:24:12','2023-01-19 09:24:12',NULL),(558,7705,40720,1518,3,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',7999.98,NULL,NULL,1,'2023-01-19 09:26:03','2023-01-19 09:26:03',NULL);
INSERT INTO `balance_libro` VALUES (559,7705,40720,1518,3,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',4999.56,NULL,NULL,1,'2023-01-19 09:26:33','2023-01-19 09:26:33',NULL),(560,7705,40720,1518,3,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',24501.06,NULL,NULL,1,'2023-01-19 09:27:04','2023-01-19 09:27:04',NULL),(561,7705,40720,1518,3,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',2999.99,NULL,NULL,1,'2023-01-19 09:27:35','2023-01-19 09:27:35',NULL),(562,7705,40720,1518,3,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',1000.00,NULL,NULL,1,'2023-01-19 09:28:19','2023-01-19 09:28:19',NULL),(563,7705,40720,1518,3,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',8003.11,NULL,NULL,1,'2023-01-19 09:29:20','2023-01-19 09:29:20',NULL),(564,7705,40720,1518,3,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',2999.79,NULL,NULL,1,'2023-01-19 09:29:59','2023-01-19 09:29:59',NULL),(565,7705,40720,1518,3,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',14700.38,NULL,NULL,1,'2023-01-19 09:30:26','2023-01-19 09:30:26',NULL),(566,7705,40720,1518,3,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',16301.20,NULL,NULL,1,'2023-01-19 09:30:51','2023-01-19 09:30:51',NULL),(567,7705,40720,1518,3,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2999.50,NULL,NULL,1,'2023-01-19 09:31:41','2023-01-19 09:31:41',NULL),(568,7705,40720,1518,3,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2999.79,NULL,NULL,1,'2023-01-19 09:32:13','2023-01-19 09:32:13',NULL),(569,7705,40720,1518,3,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',12761.84,NULL,NULL,1,'2023-01-19 09:32:42','2023-01-19 09:32:42',NULL),(570,7705,40720,1518,3,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',10000.42,NULL,NULL,1,'2023-01-19 09:33:09','2023-01-19 09:33:09',NULL),(571,7705,40720,1518,3,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3999.71,NULL,NULL,1,'2023-01-19 09:33:35','2023-01-19 09:33:35',NULL),(572,7705,40720,1518,3,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',163350.00,NULL,NULL,1,'2023-01-19 09:34:39','2023-01-19 09:34:39',NULL),(573,7705,40720,1518,3,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',4400.00,NULL,NULL,1,'2023-01-19 09:35:39','2023-01-19 09:35:39',NULL),(574,7705,40720,1518,3,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2240.00,NULL,NULL,1,'2023-01-19 09:36:44','2023-01-19 09:36:44',NULL),(575,7705,40720,1518,3,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',120000.00,NULL,NULL,1,'2023-01-19 09:37:26','2023-01-19 09:37:26',NULL),(576,7705,40720,1518,3,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2201.36,NULL,NULL,1,'2023-01-19 09:38:23','2023-01-19 09:38:23',NULL),(577,7705,40720,1518,3,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',14999.85,NULL,NULL,1,'2023-01-19 09:38:53','2023-01-19 09:38:53',NULL),(578,7705,40720,1518,3,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',10000.24,NULL,NULL,1,'2023-01-19 09:39:22','2023-01-19 09:39:22',NULL),(579,7705,40720,1518,3,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',10700.71,NULL,NULL,1,'2023-01-19 09:39:46','2023-01-19 09:39:46',NULL);
INSERT INTO `balance_libro` VALUES (580,7705,40720,1518,3,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',8000.40,NULL,NULL,1,'2023-01-19 09:40:53','2023-01-19 09:40:53',NULL),(581,7705,40720,1518,3,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',8000.32,NULL,NULL,1,'2023-01-19 09:41:27','2023-01-19 09:41:27',NULL),(582,7705,40720,1518,3,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3250.73,NULL,NULL,1,'2023-01-19 09:42:26','2023-01-19 09:42:26',NULL),(583,7705,40720,1518,3,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',10780.00,NULL,NULL,1,'2023-01-19 09:43:55','2023-01-19 09:43:55',NULL),(584,7705,40720,1518,3,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',4660.92,NULL,NULL,1,'2023-01-19 09:45:20','2023-01-19 09:45:20',NULL),(585,7705,40720,1518,3,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',5617.45,NULL,NULL,1,'2023-01-23 20:02:57','2023-03-15 07:43:40','2023-03-15 07:43:40'),(586,7705,40720,1518,15,1341,'App\\Models\\PeriodLiquidation',NULL,1341,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',472580.69,NULL,NULL,1,'2023-01-23 20:06:19','2023-03-13 19:44:32','2023-03-13 19:44:32'),(587,7705,40720,1518,3,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',9999.69,NULL,NULL,1,'2023-03-13 19:51:59','2023-03-13 19:53:37','2023-03-13 19:53:37'),(588,7705,40720,1518,3,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',9999.69,NULL,NULL,1,'2023-03-13 19:53:19','2023-03-13 19:53:19',NULL),(589,7705,40720,1518,3,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',9999.69,NULL,NULL,1,'2023-03-13 19:53:37','2023-03-13 19:53:57','2023-03-13 19:53:57'),(590,7705,40720,1518,3,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',9999.69,NULL,NULL,1,'2023-03-13 19:55:13','2023-03-13 19:55:13',NULL),(591,7705,40720,1518,3,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',7000.01,NULL,NULL,1,'2023-03-13 19:55:56','2023-03-13 19:55:56',NULL),(592,7705,40720,1518,3,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',8000.69,NULL,NULL,1,'2023-03-13 19:56:40','2023-03-13 19:56:40',NULL),(593,7705,40720,1518,3,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',11052.05,NULL,NULL,1,'2023-03-13 19:57:23','2023-03-13 19:57:23',NULL),(594,7705,40720,1518,3,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',11350.36,NULL,NULL,1,'2023-03-13 19:58:14','2023-03-13 19:58:14',NULL),(595,7705,40720,1518,3,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',9999.69,NULL,NULL,1,'2023-03-13 19:58:59','2023-03-13 19:58:59',NULL),(596,7705,40720,1518,3,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',14000.04,NULL,NULL,1,'2023-03-13 19:59:50','2023-03-13 19:59:50',NULL),(597,7705,40720,1518,3,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',14000.52,NULL,NULL,1,'2023-03-13 20:01:21','2023-03-13 20:01:21',NULL),(598,7705,40720,1518,3,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',11601.70,NULL,NULL,1,'2023-03-13 20:04:00','2023-03-13 20:04:00',NULL),(599,7705,40720,1518,3,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-25','2022-12-25',8501.03,NULL,NULL,1,'2023-03-13 20:05:11','2023-03-13 20:05:50','2023-03-13 20:05:50'),(600,7705,40720,1518,3,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',8501.03,NULL,NULL,1,'2023-03-13 20:05:50','2023-03-13 20:05:50',NULL);
INSERT INTO `balance_libro` VALUES (601,7705,40720,1518,3,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-25','2022-12-25',9999.69,NULL,NULL,1,'2023-03-13 20:07:38','2023-03-13 20:07:38',NULL),(602,7705,40720,1518,3,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',6652.36,NULL,NULL,1,'2023-03-13 20:09:15','2023-03-13 20:09:15',NULL),(603,7705,40720,1518,3,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',3999.97,NULL,NULL,1,'2023-03-13 20:10:09','2023-03-13 20:10:09',NULL),(604,7705,40720,1518,3,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',9999.69,NULL,NULL,1,'2023-03-13 20:11:02','2023-03-13 20:11:02',NULL),(605,7705,40720,1518,3,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',10000.80,NULL,NULL,1,'2023-03-13 20:11:57','2023-03-13 20:11:57',NULL),(606,7705,40720,1518,15,1381,'App\\Models\\PeriodLiquidation',NULL,1381,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',498014.20,NULL,NULL,1,'2023-03-15 07:31:16','2023-03-15 07:43:06','2023-03-15 07:43:06'),(607,7705,40720,1518,3,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',5617.45,NULL,NULL,1,'2023-03-15 07:43:40','2023-03-16 07:14:17','2023-03-16 07:14:17'),(608,7705,40720,1518,15,1383,'App\\Models\\PeriodLiquidation',NULL,1383,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',498014.20,NULL,NULL,1,'2023-03-15 07:44:01','2023-03-16 07:12:51','2023-03-16 07:12:51'),(609,7705,40720,1518,3,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',5617.45,NULL,NULL,1,'2023-03-16 07:14:17','2023-03-16 07:21:04','2023-03-16 07:21:04'),(610,7705,40720,1518,15,1385,'App\\Models\\PeriodLiquidation',NULL,1385,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',498014.20,NULL,NULL,1,'2023-03-16 07:14:42','2023-03-16 07:19:53','2023-03-16 07:19:53'),(611,7705,40720,1518,3,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',5617.45,NULL,NULL,1,'2023-03-16 07:21:04','2023-03-16 07:21:16','2023-03-16 07:21:16'),(612,7705,40720,1518,15,1389,'App\\Models\\PeriodLiquidation',NULL,1389,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',496903.48,NULL,NULL,1,'2023-03-16 07:21:40','2023-03-16 07:21:40',NULL),(613,7705,40720,1522,3,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',12200.69,NULL,NULL,1,'2023-04-18 23:24:29','2023-04-18 23:24:29',NULL),(614,7705,40720,1522,3,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',14000.55,NULL,NULL,1,'2023-04-18 23:25:14','2023-04-18 23:25:14',NULL),(615,7705,40720,1522,3,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',11800.52,NULL,NULL,1,'2023-04-18 23:25:52','2023-04-18 23:25:52',NULL),(616,7705,40720,1522,3,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',12500.00,NULL,NULL,1,'2023-04-18 23:26:32','2023-04-18 23:26:32',NULL),(617,7705,40720,1522,3,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5000.00,NULL,NULL,1,'2023-04-18 23:27:12','2023-04-18 23:27:12',NULL),(618,7705,40720,1522,3,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',4999.66,NULL,NULL,1,'2023-04-18 23:29:31','2023-04-18 23:29:31',NULL),(619,7705,40720,1522,3,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',21401.45,NULL,NULL,1,'2023-04-18 23:30:03','2023-04-18 23:30:03',NULL),(620,7705,40720,1522,3,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',12500.00,NULL,NULL,1,'2023-04-18 23:30:28','2023-04-18 23:30:28',NULL);
INSERT INTO `balance_libro` VALUES (621,7705,40720,1522,3,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3999.71,NULL,NULL,1,'2023-04-18 23:30:53','2023-04-18 23:30:53',NULL),(622,7705,40720,1522,3,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4199.99,NULL,NULL,1,'2023-04-18 23:31:31','2023-04-18 23:31:31',NULL),(623,7705,40720,1522,3,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',16001.64,NULL,NULL,1,'2023-04-18 23:32:38','2023-04-18 23:32:38',NULL),(624,7705,40720,1522,3,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',21101.10,NULL,NULL,1,'2023-04-18 23:33:10','2023-04-18 23:33:10',NULL),(625,7705,40720,1522,3,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',13000.02,NULL,NULL,1,'2023-04-18 23:33:34','2023-04-18 23:33:34',NULL),(626,7705,40720,1522,3,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3999.71,NULL,NULL,1,'2023-04-18 23:34:00','2023-04-18 23:34:00',NULL),(627,7705,40720,1522,3,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',15850.74,NULL,NULL,1,'2023-04-18 23:34:29','2023-04-18 23:34:29',NULL),(628,7705,40720,1522,3,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',14999.90,NULL,NULL,1,'2023-04-18 23:35:07','2023-04-18 23:35:07',NULL),(629,7705,40720,1522,3,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',4999.66,NULL,NULL,1,'2023-04-18 23:36:15','2023-04-18 23:36:15',NULL),(630,7705,40720,1522,3,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',6500.06,NULL,NULL,1,'2023-04-18 23:36:44','2023-04-18 23:36:44',NULL),(631,7705,40720,1522,3,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',999.92,NULL,NULL,1,'2023-04-18 23:37:11','2023-04-18 23:37:11',NULL),(632,7705,40720,1522,3,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',15000.71,NULL,NULL,1,'2023-04-18 23:38:16','2023-04-18 23:38:16',NULL),(633,7705,40720,1522,3,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',10000.42,NULL,NULL,1,'2023-04-18 23:39:03','2023-04-18 23:39:03',NULL),(634,7705,40720,1522,3,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',12500.00,NULL,NULL,1,'2023-04-18 23:39:31','2023-04-18 23:39:31',NULL),(635,7705,40720,1522,3,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5000.01,NULL,NULL,1,'2023-04-18 23:40:23','2023-04-18 23:40:23',NULL),(636,7705,40720,1522,3,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',8000.40,NULL,NULL,1,'2023-04-18 23:41:07','2023-04-18 23:41:07',NULL),(637,7705,40720,1522,3,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4000.00,NULL,NULL,1,'2023-04-18 23:41:41','2023-04-18 23:41:41',NULL),(638,7705,40720,1522,3,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',6499.54,NULL,NULL,1,'2023-04-18 23:42:05','2023-04-18 23:42:05',NULL),(639,7705,40720,1522,3,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',5999.59,NULL,NULL,1,'2023-04-18 23:42:32','2023-04-18 23:42:32',NULL),(640,7705,40720,1522,3,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2000.01,NULL,NULL,1,'2023-04-18 23:42:58','2023-04-18 23:42:58',NULL),(641,7705,40720,1522,3,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5500.04,NULL,NULL,1,'2023-04-19 06:17:10','2023-04-19 06:17:10',NULL);
INSERT INTO `balance_libro` VALUES (642,7705,40720,1522,3,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1999.85,NULL,NULL,1,'2023-04-19 06:17:53','2023-04-19 06:17:53',NULL),(643,7705,40720,1522,3,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1999.85,NULL,NULL,1,'2023-04-19 06:18:23','2023-04-19 06:18:23',NULL),(644,7705,40720,1522,3,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',5000.00,NULL,NULL,1,'2023-04-19 06:18:57','2023-04-19 06:18:57',NULL),(645,7705,40720,1522,3,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',5999.59,NULL,NULL,1,'2023-04-19 06:26:15','2023-04-19 06:26:15',NULL),(646,7705,40720,1522,3,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',12500.00,NULL,NULL,1,'2023-04-19 06:26:41','2023-04-19 06:26:41',NULL),(647,7705,40720,1522,3,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1999.85,NULL,NULL,1,'2023-04-19 06:27:05','2023-04-19 06:27:05',NULL),(648,7705,40720,1522,3,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2000.01,NULL,NULL,1,'2023-04-19 06:27:29','2023-04-19 06:27:29',NULL),(649,7705,40720,1522,3,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2999.79,NULL,NULL,1,'2023-04-19 06:27:57','2023-04-19 06:27:57',NULL),(650,7705,40720,1522,3,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',14999.89,NULL,NULL,1,'2023-04-19 06:28:29','2023-04-19 06:28:29',NULL),(651,7705,40720,1522,3,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',7200.86,NULL,NULL,1,'2023-04-19 06:29:36','2023-04-19 06:29:36',NULL),(652,7705,40720,1522,3,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1999.85,NULL,NULL,1,'2023-04-19 06:30:10','2023-04-19 06:30:10',NULL),(653,7705,40720,1522,3,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',14201.50,NULL,NULL,1,'2023-04-19 06:30:39','2023-04-19 06:30:39',NULL),(654,7705,40720,1522,3,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',4999.66,NULL,NULL,1,'2023-04-19 06:31:05','2023-04-19 06:31:05',NULL),(655,7705,40720,1522,3,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',11999.74,NULL,NULL,1,'2023-04-19 06:31:31','2023-04-19 06:31:31',NULL),(656,7705,40720,1522,3,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',12500.00,NULL,NULL,1,'2023-04-19 06:32:04','2023-04-19 06:32:04',NULL),(657,7705,40720,1522,3,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',7000.44,NULL,NULL,1,'2023-04-19 06:33:27','2023-04-19 06:33:27',NULL),(658,7705,40720,1522,3,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',19041.34,NULL,NULL,1,'2023-04-19 06:34:17','2023-04-19 06:34:17',NULL),(659,7705,40720,1522,3,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3999.71,NULL,NULL,1,'2023-04-19 06:34:47','2023-04-19 06:34:47',NULL),(660,7705,40720,1522,3,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',15995.84,NULL,NULL,1,'2023-04-19 06:35:14','2023-04-19 06:35:14',NULL),(661,7705,40720,1522,3,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2999.96,NULL,NULL,1,'2023-04-19 06:36:12','2023-04-19 06:36:12',NULL),(662,7705,40720,1522,3,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',7000.01,NULL,NULL,1,'2023-04-19 06:36:46','2023-04-19 06:36:46',NULL);
INSERT INTO `balance_libro` VALUES (663,7705,40720,1522,3,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',4999.00,NULL,NULL,1,'2023-04-19 06:37:28','2023-04-19 06:37:28',NULL),(664,7705,40720,1522,3,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1999.96,NULL,NULL,1,'2023-04-19 06:38:02','2023-04-19 06:38:02',NULL),(665,7705,40720,1522,3,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2000.01,NULL,NULL,1,'2023-04-19 06:38:29','2023-04-19 06:38:29',NULL),(666,7705,40720,1522,3,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',15000.00,NULL,NULL,1,'2023-04-19 06:38:59','2023-04-19 06:38:59',NULL),(667,7705,40720,1522,3,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1835.50,NULL,NULL,1,'2023-04-19 06:39:25','2023-04-19 06:39:25',NULL),(668,7705,40720,1522,3,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',15895.48,NULL,NULL,1,'2023-04-19 06:39:58','2023-04-19 06:39:58',NULL),(669,7705,40720,1522,3,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',17897.34,NULL,NULL,1,'2023-04-19 06:40:33','2023-04-19 06:40:33',NULL),(670,7705,40720,1522,3,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2999.95,NULL,NULL,1,'2023-04-19 06:41:03','2023-04-19 06:41:03',NULL),(671,7705,40720,1522,3,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',8500.00,NULL,NULL,1,'2023-04-19 06:41:34','2023-04-19 06:41:34',NULL),(672,7705,40720,1522,3,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',4000.00,NULL,NULL,1,'2023-04-19 06:41:58','2023-04-19 06:41:58',NULL),(673,7705,40720,1522,3,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',5998.74,NULL,NULL,1,'2023-04-19 06:42:26','2023-04-19 06:42:26',NULL),(674,7705,40720,1522,3,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',9999.65,NULL,NULL,1,'2023-04-19 06:43:05','2023-04-19 06:43:05',NULL),(675,7705,40720,1522,3,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',13399.55,NULL,NULL,1,'2023-04-19 06:43:40','2023-04-19 06:43:40',NULL),(676,7705,40720,1522,3,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',11631.67,NULL,NULL,1,'2023-04-19 06:44:10','2023-04-19 06:44:10',NULL),(677,7705,40720,1522,3,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3999.93,NULL,NULL,1,'2023-04-19 06:44:40','2023-04-19 06:44:40',NULL),(678,7705,40720,1522,3,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',18443.08,NULL,NULL,1,'2023-04-19 06:45:25','2023-04-19 06:45:25',NULL),(679,7705,40720,1522,3,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',10981.28,NULL,NULL,1,'2023-04-19 06:45:59','2023-04-19 06:45:59',NULL),(680,7705,40720,1522,3,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',19397.29,NULL,NULL,1,'2023-04-19 06:46:42','2023-04-19 06:46:42',NULL),(681,7705,40720,1522,3,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2999.92,NULL,NULL,1,'2023-04-19 06:47:17','2023-04-19 06:47:17',NULL),(682,7705,40720,1522,3,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',15999.20,NULL,NULL,1,'2023-04-19 06:48:03','2023-04-19 06:48:03',NULL),(683,7705,40720,1522,3,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',15234.36,NULL,NULL,1,'2023-04-19 06:48:31','2023-04-19 06:48:31',NULL);
INSERT INTO `balance_libro` VALUES (684,7705,40720,1522,3,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',7000.01,NULL,NULL,1,'2023-04-19 06:49:02','2023-04-19 06:49:02',NULL),(685,7705,40720,1522,3,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',10000.50,NULL,NULL,1,'2023-04-19 06:50:20','2023-04-19 06:50:20',NULL),(686,7705,40720,1522,3,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',6301.13,NULL,NULL,1,'2023-04-19 06:51:01','2023-04-19 06:51:01',NULL),(687,7705,40720,1522,3,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',11002.76,NULL,NULL,1,'2023-04-19 06:51:31','2023-04-19 06:51:31',NULL),(688,7705,40720,1522,3,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',14198.66,NULL,NULL,1,'2023-04-19 06:52:15','2023-04-19 06:52:15',NULL),(689,7705,40720,1522,3,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',16998.99,NULL,NULL,1,'2023-04-19 06:52:50','2023-04-19 06:52:50',NULL),(690,7705,40720,1522,3,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',22501.30,NULL,NULL,1,'2023-04-19 06:53:24','2023-04-19 06:53:24',NULL),(691,7705,40720,1522,3,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',17504.01,NULL,NULL,1,'2023-04-19 06:54:06','2023-04-19 06:54:06',NULL),(692,7705,40720,1522,3,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',3999.93,NULL,NULL,1,'2023-04-19 06:54:52','2023-04-19 06:54:52',NULL),(693,7705,40720,1522,3,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',2999.92,NULL,NULL,1,'2023-04-19 06:55:30','2023-04-19 06:55:30',NULL),(694,7705,40720,1522,3,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',5000.00,NULL,NULL,1,'2023-04-19 06:55:58','2023-04-19 06:55:58',NULL),(695,7705,40720,1522,3,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',3999.93,NULL,NULL,1,'2023-04-19 06:56:22','2023-04-19 06:56:22',NULL),(696,7705,40720,1522,3,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1999.96,NULL,NULL,1,'2023-04-19 06:56:53','2023-04-19 06:56:53',NULL),(697,7705,40720,1522,3,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1999.96,NULL,NULL,1,'2023-04-19 06:57:19','2023-04-19 06:57:19',NULL),(698,7705,40720,1522,3,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',18402.23,NULL,NULL,1,'2023-04-19 06:58:33','2023-04-19 06:58:33',NULL),(699,7705,40720,1522,3,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2999.95,NULL,NULL,1,'2023-04-19 06:59:08','2023-04-19 06:59:08',NULL),(700,7705,40720,1522,3,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',8999.81,NULL,NULL,1,'2023-04-19 06:59:33','2023-04-19 06:59:33',NULL),(701,7705,40720,1522,3,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1999.96,NULL,NULL,1,'2023-04-19 07:00:45','2023-04-19 07:00:45',NULL),(702,7705,40720,1522,3,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',5999.51,NULL,NULL,1,'2023-04-19 07:01:25','2023-04-19 07:01:25',NULL),(703,7705,40720,1522,3,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',6999.86,NULL,NULL,1,'2023-04-19 07:02:01','2023-04-19 07:02:01',NULL),(704,7705,40720,1522,3,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',14997.79,NULL,NULL,1,'2023-04-19 07:02:28','2023-04-19 07:02:28',NULL);
INSERT INTO `balance_libro` VALUES (705,7705,40720,1522,3,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',14702.65,NULL,NULL,1,'2023-04-19 07:03:10','2023-04-19 07:03:10',NULL),(706,7705,40720,1522,3,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',20000.01,NULL,NULL,1,'2023-04-19 07:04:02','2023-04-19 07:04:02',NULL),(707,7705,40720,1522,3,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',23263.31,NULL,NULL,1,'2023-04-19 07:05:09','2023-04-19 07:05:09',NULL),(708,7705,40720,1522,3,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',20378.75,NULL,NULL,1,'2023-04-19 07:05:36','2023-04-19 07:05:36',NULL),(709,7705,40720,1522,3,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3999.90,NULL,NULL,1,'2023-04-19 07:06:02','2023-04-19 07:06:02',NULL),(710,7705,40720,1522,3,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',12500.00,NULL,NULL,1,'2023-04-19 07:06:29','2023-04-19 07:06:29',NULL),(711,7705,40720,1522,3,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',20000.01,NULL,NULL,1,'2023-04-20 18:57:14','2023-04-20 18:57:14',NULL),(712,7705,40720,1522,3,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2999.92,NULL,NULL,1,'2023-04-20 18:58:16','2023-04-20 18:58:16',NULL),(713,7705,40720,1522,3,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',12999.88,NULL,NULL,1,'2023-04-20 18:59:05','2023-04-20 18:59:05',NULL),(714,7705,40720,1522,3,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',9999.78,NULL,NULL,1,'2023-04-20 18:59:47','2023-04-20 18:59:47',NULL),(715,7705,40720,1522,3,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',9999.78,NULL,NULL,1,'2023-04-20 19:00:25','2023-04-20 19:00:25',NULL),(716,7705,40720,1522,3,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',5999.87,NULL,NULL,1,'2023-04-20 19:01:01','2023-04-20 19:01:01',NULL),(717,7705,40720,1522,3,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',12999.72,NULL,NULL,1,'2023-04-20 19:01:28','2023-04-20 19:01:28',NULL),(718,7705,40720,1522,3,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',19000.09,NULL,NULL,1,'2023-04-20 19:02:11','2023-04-20 19:02:11',NULL),(719,7705,40720,1522,3,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',17472.58,NULL,NULL,1,'2023-04-20 19:02:51','2023-04-20 19:02:51',NULL),(720,7705,40720,1522,3,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',12900.00,NULL,NULL,1,'2023-04-20 19:04:46','2023-04-20 19:04:46',NULL),(721,7705,40720,1522,3,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',7551.04,NULL,NULL,1,'2023-04-20 19:05:49','2023-04-20 19:05:49',NULL),(722,7705,40720,1522,3,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',3999.93,NULL,NULL,1,'2023-04-20 19:06:57','2023-04-20 19:06:57',NULL),(723,7705,40720,1522,3,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',3902.55,NULL,NULL,1,'2023-04-20 19:08:02','2023-04-20 19:08:02',NULL),(724,7705,40720,1522,3,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',11999.64,NULL,NULL,1,'2023-04-20 19:08:59','2023-04-20 19:08:59',NULL),(725,7705,40720,1522,3,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',20395.29,NULL,NULL,1,'2023-04-20 19:11:07','2023-04-20 19:11:07',NULL);
INSERT INTO `balance_libro` VALUES (726,7705,40720,1522,3,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',22200.52,NULL,NULL,1,'2023-04-20 23:30:40','2023-04-20 23:30:40',NULL),(727,7705,40720,1522,3,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',26501.91,NULL,NULL,1,'2023-04-20 23:31:10','2023-04-20 23:31:10',NULL),(728,7705,40720,1522,3,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15299.52,NULL,NULL,1,'2023-04-20 23:31:51','2023-04-20 23:31:51',NULL),(729,7705,40720,1522,3,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',140000.00,NULL,NULL,1,'2023-04-20 23:35:05','2023-04-20 23:57:41','2023-04-20 23:57:41'),(730,7705,40720,1522,3,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',26400.39,NULL,NULL,1,'2023-04-20 23:37:54','2023-04-20 23:37:54',NULL),(731,7705,40720,1522,3,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',5404.72,NULL,NULL,1,'2023-04-20 23:40:58','2023-04-23 10:37:18','2023-04-23 10:37:18'),(732,7705,40720,1522,3,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',16521.00,NULL,NULL,1,'2023-04-20 23:44:46','2023-04-23 10:39:01','2023-04-23 10:39:01'),(733,7705,40720,1522,3,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',87900.00,NULL,NULL,1,'2023-04-20 23:45:27','2023-04-20 23:45:27',NULL),(734,7705,40720,1522,3,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1200.01,NULL,NULL,1,'2023-04-20 23:46:13','2023-04-20 23:46:13',NULL),(735,7705,40720,1522,3,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',38000.00,NULL,NULL,1,'2023-04-20 23:49:09','2023-04-20 23:49:09',NULL),(736,7705,40720,1522,3,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1800.00,NULL,NULL,1,'2023-04-20 23:50:40','2023-04-20 23:50:40',NULL),(737,7705,40720,1522,3,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',54988.82,NULL,NULL,1,'2023-04-20 23:53:51','2023-04-20 23:53:51',NULL),(738,7705,40720,1522,3,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',39929.99,NULL,NULL,1,'2023-04-20 23:55:00','2023-04-20 23:55:00',NULL),(739,7705,40720,1522,3,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',35700.02,NULL,NULL,1,'2023-04-20 23:55:59','2023-04-20 23:55:59',NULL),(740,7705,40720,1522,3,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',140000.00,NULL,NULL,1,'2023-04-20 23:58:33','2023-04-20 23:58:33',NULL),(741,7705,40720,1522,3,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',19309.00,NULL,NULL,1,'2023-04-23 09:36:34','2023-04-23 09:36:34',NULL),(742,7705,40720,1522,3,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2899.99,NULL,NULL,1,'2023-04-23 09:41:05','2023-04-23 09:41:05',NULL),(743,7705,40720,1522,3,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',7400.00,NULL,NULL,1,'2023-04-23 09:41:40','2023-04-23 09:41:40',NULL),(744,7705,40720,1522,3,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',3639.99,NULL,NULL,1,'2023-04-23 09:49:05','2023-04-23 09:49:05',NULL),(745,7705,40720,1522,3,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',52259.00,NULL,NULL,1,'2023-04-23 09:49:55','2023-04-23 09:49:55',NULL),(746,7705,40720,1522,3,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',18299.65,NULL,NULL,1,'2023-04-23 10:14:08','2023-04-23 10:14:08',NULL);
INSERT INTO `balance_libro` VALUES (747,7705,40720,1522,3,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',16403.14,NULL,NULL,1,'2023-04-23 10:14:54','2023-04-23 10:14:54',NULL),(748,7705,40720,1522,3,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',13000.41,NULL,NULL,1,'2023-04-23 10:15:30','2023-04-23 10:15:30',NULL),(749,7705,40720,1523,3,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',5999.89,NULL,NULL,1,'2023-05-17 20:08:19','2023-05-17 20:08:19',NULL),(750,7705,40720,1523,3,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2999.95,NULL,NULL,1,'2023-05-17 20:09:19','2023-05-17 20:09:19',NULL),(751,7705,40720,1523,3,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1999.96,NULL,NULL,1,'2023-05-17 20:10:51','2023-05-17 20:10:51',NULL),(752,7705,40720,1523,3,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',5499.90,NULL,NULL,1,'2023-05-17 20:12:53','2023-05-17 20:12:53',NULL),(753,7705,40720,1523,3,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',18700.11,NULL,NULL,1,'2023-05-17 20:15:44','2023-05-17 20:15:44',NULL),(754,7705,40720,1523,3,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',18399.69,NULL,NULL,1,'2023-05-17 20:17:52','2023-05-17 20:17:52',NULL),(755,7705,40720,1523,3,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',34503.69,NULL,NULL,1,'2023-05-17 20:19:13','2023-05-17 20:19:13',NULL),(756,7705,40720,1523,3,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',9999.99,NULL,NULL,1,'2023-05-17 20:20:15','2023-05-17 20:20:15',NULL),(757,7705,40720,1523,3,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',22001.12,NULL,NULL,1,'2023-05-17 20:21:04','2023-05-17 20:21:04',NULL),(758,7705,40720,1523,3,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',25753.98,NULL,NULL,1,'2023-05-17 20:23:25','2023-05-17 20:23:25',NULL),(759,7705,40720,1523,3,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',11000.12,NULL,NULL,1,'2023-05-17 20:25:54','2023-05-17 20:25:54',NULL),(760,7705,40720,1523,3,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',31980.00,NULL,NULL,1,'2023-05-17 20:29:25','2023-05-17 20:29:25',NULL),(761,7705,40720,1523,3,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',17000.46,NULL,NULL,1,'2023-05-17 20:30:41','2023-05-17 20:30:41',NULL),(762,7705,40720,1523,3,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',7001.37,NULL,NULL,1,'2023-05-17 20:31:26','2023-05-17 20:31:26',NULL),(763,7705,40720,1523,3,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',3999.93,NULL,NULL,1,'2023-05-17 20:32:06','2023-05-17 20:32:06',NULL),(764,7705,40720,1523,3,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',12500.00,NULL,NULL,1,'2023-05-17 20:34:59','2023-05-17 20:34:59',NULL),(765,7705,40720,1523,3,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',21400.00,NULL,NULL,1,'2023-05-17 20:37:16','2023-05-17 20:37:16',NULL),(766,7705,40720,1523,3,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',15000.64,NULL,NULL,1,'2023-05-17 22:19:45','2023-05-17 22:19:45',NULL),(767,7705,40720,1523,3,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',22153.23,NULL,NULL,1,'2023-05-17 22:34:05','2023-05-17 22:34:05',NULL);
INSERT INTO `balance_libro` VALUES (768,7705,40720,1523,3,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',22437.77,NULL,NULL,1,'2023-05-17 22:35:07','2023-05-17 22:35:07',NULL),(769,7705,40720,1523,3,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',4999.88,NULL,NULL,1,'2023-05-17 22:37:36','2023-05-17 22:37:36',NULL),(770,7705,40720,1523,3,747,'App\\Models\\Receipt',747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',10000.43,NULL,NULL,1,'2023-05-17 22:40:27','2023-05-17 22:40:27',NULL),(771,7705,40720,1523,3,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',14000.10,NULL,NULL,1,'2023-05-17 22:41:26','2023-05-17 22:41:26',NULL),(772,7705,40720,1523,3,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',4999.88,NULL,NULL,1,'2023-05-17 22:42:05','2023-05-17 22:42:05',NULL),(773,7705,40720,1523,3,750,'App\\Models\\Receipt',750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',18402.36,NULL,NULL,1,'2023-05-17 22:44:43','2023-05-17 22:44:43',NULL),(774,7705,40720,1523,3,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',26002.41,NULL,NULL,1,'2023-05-22 19:43:20','2023-05-22 19:43:20',NULL),(775,7705,40720,1523,3,752,'App\\Models\\Receipt',752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',20529.93,NULL,NULL,1,'2023-05-22 19:44:13','2023-05-22 19:44:13',NULL),(776,7705,40720,1523,3,753,'App\\Models\\Receipt',753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',13999.70,NULL,NULL,1,'2023-05-22 19:45:51','2023-05-22 19:45:51',NULL),(777,7705,40720,1523,3,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',21802.69,NULL,NULL,1,'2023-05-22 19:48:43','2023-05-22 19:48:43',NULL),(778,7705,40720,1523,3,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',8400.21,NULL,NULL,1,'2023-05-22 19:51:07','2023-05-22 19:51:07',NULL),(779,7705,40720,1523,3,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',23702.42,NULL,NULL,1,'2023-05-22 19:52:32','2023-05-22 19:52:32',NULL),(780,7705,40720,1523,3,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',6999.86,NULL,NULL,1,'2023-05-22 19:53:26','2023-05-22 19:53:26',NULL),(781,7705,40720,1523,3,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',22850.05,NULL,NULL,1,'2023-05-22 19:55:01','2023-05-22 19:55:01',NULL),(782,7705,40720,1523,3,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',23999.88,NULL,NULL,1,'2023-05-22 19:55:46','2023-05-22 19:55:46',NULL),(783,7705,40720,1523,3,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',16800.95,NULL,NULL,1,'2023-05-22 19:56:55','2023-05-22 19:56:55',NULL),(784,7705,40720,1523,3,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',5999.87,NULL,NULL,1,'2023-05-22 19:58:27','2023-05-22 19:58:27',NULL),(785,7705,40720,1523,3,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',14999.51,NULL,NULL,1,'2023-05-22 19:59:43','2023-05-22 19:59:43',NULL),(786,7705,40720,1523,3,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',3000.00,NULL,NULL,1,'2023-05-22 20:00:38','2023-05-22 20:00:38',NULL),(787,7705,40720,1523,3,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',3000.00,NULL,NULL,1,'2023-05-22 20:01:19','2023-05-22 20:01:19',NULL),(788,7705,40720,1523,3,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1912.70,NULL,NULL,1,'2023-05-22 20:02:24','2023-05-22 20:02:24',NULL);
INSERT INTO `balance_libro` VALUES (789,7705,40720,1523,3,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',4000.01,NULL,NULL,1,'2023-05-22 20:03:14','2023-05-22 20:03:14',NULL),(790,7705,40720,1523,3,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',13998.97,NULL,NULL,1,'2023-05-22 20:04:01','2023-05-22 20:04:01',NULL),(791,7705,40720,1523,3,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',5000.08,NULL,NULL,1,'2023-05-22 20:05:07','2023-05-22 20:05:07',NULL),(792,7705,40720,1523,3,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',15601.18,NULL,NULL,1,'2023-05-22 20:06:15','2023-05-22 20:06:15',NULL),(793,7705,40720,1523,3,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',13998.97,NULL,NULL,1,'2023-05-22 20:07:50','2023-05-22 20:07:50',NULL),(794,7705,40720,1523,3,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',18462.29,NULL,NULL,1,'2023-05-22 20:08:44','2023-05-22 20:08:44',NULL),(795,7705,40720,1523,3,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',17503.24,NULL,NULL,1,'2023-05-22 20:09:31','2023-05-22 20:09:31',NULL),(796,7705,40720,1523,3,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',20400.81,NULL,NULL,1,'2023-05-22 20:13:01','2023-05-22 20:13:01',NULL),(797,7705,40720,1523,3,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',10001.91,NULL,NULL,1,'2023-05-22 20:14:42','2023-05-22 20:14:42',NULL),(798,7705,40720,1523,3,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',3999.71,NULL,NULL,1,'2023-05-22 20:16:23','2023-05-22 20:16:23',NULL),(799,7705,40720,1523,3,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',8900.00,NULL,NULL,1,'2023-05-22 20:17:20','2023-05-22 20:17:20',NULL),(800,7705,40720,1523,3,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',4999.48,NULL,NULL,1,'2023-05-22 20:18:09','2023-05-22 20:18:09',NULL),(801,7705,40720,1523,3,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',31652.89,NULL,NULL,1,'2023-05-22 20:19:38','2023-05-22 20:19:38',NULL),(802,7705,40720,1523,3,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',10000.31,NULL,NULL,1,'2023-05-22 20:21:43','2023-05-22 20:21:43',NULL),(803,7705,40720,1523,3,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',5999.18,NULL,NULL,1,'2023-05-22 20:22:26','2023-05-22 20:22:26',NULL),(804,7705,40720,1523,3,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',5999.55,NULL,NULL,1,'2023-05-22 20:23:04','2023-05-22 20:23:04',NULL),(805,7705,40720,1523,3,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',16201.49,NULL,NULL,1,'2023-05-22 20:25:21','2023-05-22 20:25:21',NULL),(806,7705,40720,1523,3,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',7923.15,NULL,NULL,1,'2023-05-22 20:26:53','2023-05-22 20:26:53',NULL),(807,7705,40720,1523,3,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',9999.25,NULL,NULL,1,'2023-05-22 20:27:49','2023-05-22 20:27:49',NULL),(808,7705,40720,1523,3,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',14999.94,NULL,NULL,1,'2023-05-22 20:28:47','2023-05-22 20:28:47',NULL),(809,7705,40720,1523,3,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',16201.49,NULL,NULL,1,'2023-05-22 20:43:14','2023-05-22 20:43:14',NULL);
INSERT INTO `balance_libro` VALUES (810,7705,40720,1523,3,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',7999.88,NULL,NULL,1,'2023-05-22 20:44:05','2023-05-22 20:44:05',NULL),(811,7705,40720,1523,3,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',10000.25,NULL,NULL,1,'2023-05-22 21:20:52','2023-05-22 21:20:52',NULL),(812,7705,40720,1523,3,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',6499.72,NULL,NULL,1,'2023-05-22 21:21:44','2023-05-22 21:21:44',NULL),(813,7705,40720,1523,3,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',10000.31,NULL,NULL,1,'2023-05-22 21:22:19','2023-05-22 21:22:19',NULL),(814,7705,40720,1523,3,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',24900.03,NULL,NULL,1,'2023-05-22 21:23:08','2023-05-22 21:23:08',NULL),(815,7705,40720,1523,3,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',16100.94,NULL,NULL,1,'2023-05-22 21:24:14','2023-05-22 21:24:14',NULL),(816,7705,40720,1523,3,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',9700.26,NULL,NULL,1,'2023-05-22 21:25:06','2023-05-22 21:25:06',NULL),(817,7705,40720,1523,3,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',8999.41,NULL,NULL,1,'2023-05-22 21:26:04','2023-05-22 21:26:04',NULL),(818,7705,40720,1523,3,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1999.86,NULL,NULL,1,'2023-05-22 21:26:54','2023-05-22 21:26:54',NULL),(819,7705,40720,1523,3,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',18000.48,NULL,NULL,1,'2023-05-22 21:27:32','2023-05-22 21:27:32',NULL),(820,7705,40720,1523,3,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',19702.16,NULL,NULL,1,'2023-05-22 21:29:24','2023-05-22 21:29:24',NULL),(821,7705,40720,1523,3,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',9999.25,NULL,NULL,1,'2023-05-22 21:30:11','2023-05-22 21:30:11',NULL),(822,7705,40720,1523,3,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',8000.51,NULL,NULL,1,'2023-05-22 21:31:04','2023-05-22 21:31:04',NULL),(823,7705,40720,1523,3,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3999.72,NULL,NULL,1,'2023-05-22 21:31:44','2023-05-22 21:31:44',NULL),(824,7705,40720,1523,3,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',18363.28,NULL,NULL,1,'2023-05-22 21:32:43','2023-05-22 21:32:43',NULL),(825,7705,40720,1523,3,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',2000.00,NULL,NULL,1,'2023-05-22 21:33:36','2023-05-22 21:33:36',NULL),(826,7705,40720,1523,3,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',3000.31,NULL,NULL,1,'2023-05-22 21:34:24','2023-05-22 21:34:24',NULL),(827,7705,40720,1523,3,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',21461.74,NULL,NULL,1,'2023-05-22 21:35:25','2023-05-22 21:35:25',NULL),(828,7705,40720,1523,3,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',8260.43,NULL,NULL,1,'2023-05-22 21:36:10','2023-05-22 21:36:10',NULL),(829,7705,40720,1523,3,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',3000.31,NULL,NULL,1,'2023-05-22 21:36:51','2023-05-22 21:36:51',NULL),(830,7705,40720,1523,3,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',5499.84,NULL,NULL,1,'2023-05-22 21:38:00','2023-05-22 21:38:00',NULL);
INSERT INTO `balance_libro` VALUES (831,7705,40720,1523,3,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',24602.43,NULL,NULL,1,'2023-05-22 21:38:43','2023-05-22 21:38:43',NULL),(832,7705,40720,1523,3,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',23999.38,NULL,NULL,1,'2023-05-22 21:39:19','2023-05-22 21:39:19',NULL),(833,7705,40720,1523,3,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',15000.20,NULL,NULL,1,'2023-05-22 21:40:08','2023-05-22 21:40:08',NULL),(834,7705,40720,1523,3,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',18151.59,NULL,NULL,1,'2023-05-22 21:41:20','2023-05-22 21:41:20',NULL),(835,7705,40720,1523,3,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7000.04,NULL,NULL,1,'2023-05-22 21:42:01','2023-05-22 21:42:01',NULL),(836,7705,40720,1523,3,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5000.00,NULL,NULL,1,'2023-05-22 21:42:35','2023-05-22 21:42:35',NULL),(837,7705,40720,1523,3,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',12500.00,NULL,NULL,1,'2023-05-22 21:43:41','2023-05-22 21:43:41',NULL),(838,7705,40720,1523,3,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3900.00,NULL,NULL,1,'2023-05-22 21:45:12','2023-05-22 21:45:12',NULL),(839,7705,40720,1523,3,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',58000.01,NULL,NULL,1,'2023-05-22 21:47:39','2023-05-22 21:47:39',NULL),(840,7705,40720,1523,3,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3400.10,NULL,NULL,1,'2023-05-22 21:49:19','2023-05-22 21:49:19',NULL),(841,7705,40720,1523,3,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',6000.00,NULL,NULL,1,'2023-05-22 21:50:16','2023-05-22 21:50:16',NULL),(842,7705,40720,1523,3,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',2400.01,NULL,NULL,1,'2023-05-22 21:51:13','2023-05-22 21:51:13',NULL),(843,7705,40720,1523,3,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',3222.76,NULL,NULL,1,'2023-05-22 21:53:52','2023-05-23 21:35:44','2023-05-23 21:35:44'),(844,7705,40720,1523,3,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',278989.24,NULL,NULL,1,'2023-05-22 21:55:54','2023-05-22 21:55:54',NULL),(845,7705,40720,1523,3,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',3698.00,NULL,NULL,1,'2023-05-22 21:56:28','2023-05-22 21:56:28',NULL),(846,7705,40720,1523,3,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',22363.64,NULL,NULL,1,'2023-05-22 21:58:32','2023-05-22 21:58:32',NULL),(847,7705,40720,1523,3,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',7500.00,NULL,NULL,1,'2023-05-22 22:02:10','2023-05-22 22:02:10',NULL),(848,7705,40720,1523,3,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',33400.01,NULL,NULL,1,'2023-05-22 22:03:03','2023-05-22 22:03:03',NULL),(849,7705,40720,1523,3,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',151233.59,NULL,NULL,1,'2023-05-22 22:05:15','2023-05-22 22:05:15',NULL),(850,7705,40720,1523,3,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',5567.35,NULL,NULL,1,'2023-05-22 22:07:24','2023-05-22 22:07:24',NULL),(851,7705,40720,1523,3,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1649.99,NULL,NULL,1,'2023-05-22 22:43:03','2023-05-22 22:43:03',NULL);
INSERT INTO `balance_libro` VALUES (852,7705,40720,1523,3,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',35884.56,NULL,NULL,1,'2023-05-22 22:44:16','2023-05-22 22:44:16',NULL),(853,7705,40720,1523,3,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',21699.50,NULL,NULL,1,'2023-05-22 22:45:27','2023-05-22 22:45:27',NULL),(854,7705,40720,1523,3,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',18150.00,NULL,NULL,1,'2023-05-22 22:46:44','2023-05-22 22:46:44',NULL),(855,7705,40720,1523,3,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',45800.00,NULL,NULL,1,'2023-05-22 22:48:05','2023-05-22 22:48:05',NULL),(856,7705,40720,1523,15,1881,'App\\Models\\PeriodLiquidation',NULL,1881,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1085503.92,NULL,NULL,1,'2023-05-23 21:17:52','2023-05-23 21:26:53','2023-05-23 21:26:53'),(857,7705,40720,1523,15,1883,'App\\Models\\PeriodLiquidation',NULL,1883,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1084953.69,NULL,NULL,1,'2023-05-23 21:36:08','2023-05-23 21:57:14','2023-05-23 21:57:14'),(858,7705,40720,1523,3,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',3222.76,NULL,NULL,1,'2023-05-23 21:59:38','2023-05-23 21:59:38',NULL),(859,7705,40720,1524,3,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',18800.37,NULL,NULL,1,'2023-05-27 17:05:23','2023-05-27 17:05:23',NULL),(860,7705,40720,1524,3,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',5399.35,NULL,NULL,1,'2023-05-27 17:06:11','2023-05-27 17:06:11',NULL),(861,7705,40720,1524,3,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',23701.36,NULL,NULL,1,'2023-05-27 17:07:16','2023-05-27 17:07:16',NULL),(862,7705,40720,1524,3,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',27001.07,NULL,NULL,1,'2023-05-27 17:08:24','2023-05-27 17:08:24',NULL),(863,7705,40720,1524,3,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',3000.31,NULL,NULL,1,'2023-05-27 17:09:15','2023-05-28 19:40:03','2023-05-28 19:40:03'),(864,7705,40720,1524,3,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',3999.72,NULL,NULL,1,'2023-05-27 17:10:07','2023-05-27 17:10:07',NULL),(865,7705,40720,1524,3,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',7999.88,NULL,NULL,1,'2023-05-27 17:12:19','2023-05-27 17:12:19',NULL),(866,7705,40720,1524,3,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',5000.19,NULL,NULL,1,'2023-05-27 17:14:07','2023-05-27 17:14:07',NULL),(867,7705,40720,1524,3,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',11000.76,NULL,NULL,1,'2023-05-27 17:15:24','2023-05-27 17:15:24',NULL),(868,7705,40720,1524,3,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',5000.19,NULL,NULL,1,'2023-05-27 17:16:12','2023-05-27 17:16:12',NULL),(869,7705,40720,1524,3,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',12999.62,NULL,NULL,1,'2023-05-27 17:17:01','2023-05-27 17:17:01',NULL),(870,7705,40720,1524,3,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',7801.10,NULL,NULL,1,'2023-05-27 17:18:16','2023-05-27 17:18:16',NULL),(871,7705,40720,1524,3,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',14010.60,NULL,NULL,1,'2023-05-27 17:19:02','2023-05-27 17:19:02',NULL),(872,7705,40720,1524,3,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',6200.29,NULL,NULL,1,'2023-05-27 17:20:08','2023-05-27 17:20:08',NULL);
INSERT INTO `balance_libro` VALUES (873,7705,40720,1524,3,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',5000.19,NULL,NULL,1,'2023-05-27 17:20:47','2023-05-27 17:20:47',NULL),(874,7705,40720,1524,3,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',6000.54,NULL,NULL,1,'2023-05-28 13:06:38','2023-05-28 13:06:38',NULL),(875,7705,40720,1524,3,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',15499.99,NULL,NULL,1,'2023-05-28 13:07:52','2023-05-28 13:07:52',NULL),(876,7705,40720,1524,3,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',9721.45,NULL,NULL,1,'2023-05-28 13:10:59','2023-05-28 13:10:59',NULL),(877,7705,40720,1524,3,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',12300.55,NULL,NULL,1,'2023-05-28 13:13:15','2023-05-28 13:13:15',NULL),(878,7705,40720,1524,3,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',3000.31,NULL,NULL,1,'2023-05-28 19:40:03','2023-05-28 19:40:03',NULL),(879,7705,40720,1524,3,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',7960.34,NULL,NULL,1,'2023-05-28 19:43:24','2023-05-28 19:43:24',NULL),(880,7705,40720,1524,3,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',5000.19,NULL,NULL,1,'2023-05-28 19:44:18','2023-05-28 19:44:18',NULL),(881,7705,40720,1524,3,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',11406.93,NULL,NULL,1,'2023-05-28 19:45:22','2023-05-28 19:45:22',NULL),(882,7705,40720,1524,3,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',9999.25,NULL,NULL,1,'2023-05-28 19:46:18','2023-05-28 19:46:18',NULL),(883,7705,40720,1524,3,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',5999.59,NULL,NULL,1,'2023-05-28 19:47:06','2023-05-28 19:47:06',NULL),(884,7705,40720,1524,3,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',5000.19,NULL,NULL,1,'2023-05-28 19:58:14','2023-05-28 19:58:14',NULL),(885,7705,40720,1524,3,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',12999.37,NULL,NULL,1,'2023-05-28 19:59:02','2023-05-28 19:59:02',NULL),(886,7705,40720,1524,3,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',9999.25,NULL,NULL,1,'2023-05-28 20:00:16','2023-05-28 20:00:16',NULL),(887,7705,40720,1524,3,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3000.31,NULL,NULL,1,'2023-05-28 20:01:07','2023-05-28 20:01:07',NULL),(888,7705,40720,1524,3,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',5000.19,NULL,NULL,1,'2023-05-28 20:02:40','2023-05-28 20:02:40',NULL),(889,7705,40720,1524,3,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',8000.51,NULL,NULL,1,'2023-05-28 20:03:18','2023-05-28 20:03:18',NULL),(890,7705,40720,1524,3,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',510.11,NULL,NULL,1,'2023-05-28 20:04:46','2023-05-28 20:04:46',NULL),(891,7705,40720,1524,3,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',24000.44,NULL,NULL,1,'2023-05-28 20:05:35','2023-05-28 20:05:35',NULL),(892,7705,40720,1524,3,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',18000.34,NULL,NULL,1,'2023-05-28 20:06:19','2023-05-28 20:06:19',NULL),(893,7705,40720,1524,3,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',10300.60,NULL,NULL,1,'2023-05-28 20:07:01','2023-05-28 20:07:01',NULL);
INSERT INTO `balance_libro` VALUES (894,7705,40720,1524,3,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',24000.44,NULL,NULL,1,'2023-05-28 20:08:22','2023-05-28 20:08:22',NULL),(895,7705,40720,1524,3,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',3999.72,NULL,NULL,1,'2023-05-28 20:16:34','2023-05-28 20:16:34',NULL),(896,7705,40720,1524,3,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',8700.08,NULL,NULL,1,'2023-05-28 20:17:12','2023-05-28 20:17:12',NULL),(897,7705,40720,1524,3,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',10000.35,NULL,NULL,1,'2023-05-28 20:17:49','2023-05-28 20:17:49',NULL),(898,7705,40720,1524,3,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',11500.17,NULL,NULL,1,'2023-05-28 20:18:44','2023-05-28 20:18:44',NULL),(899,7705,40720,1524,3,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',16960.90,NULL,NULL,1,'2023-05-28 20:19:39','2023-05-28 20:19:39',NULL),(900,7705,40720,1524,3,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',3999.72,NULL,NULL,1,'2023-05-28 20:21:27','2023-05-28 20:21:27',NULL),(901,7705,40720,1524,3,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',10000.00,NULL,NULL,1,'2023-05-28 20:41:35','2023-05-28 20:41:35',NULL),(902,7705,40720,1524,3,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',3999.72,NULL,NULL,1,'2023-05-28 20:42:59','2023-05-28 20:42:59',NULL),(903,7705,40720,1524,3,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',3000.31,NULL,NULL,1,'2023-05-29 19:29:33','2023-05-29 19:29:33',NULL),(904,7705,40720,1524,3,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',3999.46,NULL,NULL,1,'2023-05-29 19:30:10','2023-05-29 19:30:10',NULL),(905,7705,40720,1524,3,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',10000.35,NULL,NULL,1,'2023-05-29 19:31:08','2023-05-29 19:31:08',NULL),(906,7705,40720,1524,3,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',20005.84,NULL,NULL,1,'2023-05-29 19:35:53','2023-05-29 19:35:53',NULL),(907,7705,40720,1524,3,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',10000.26,NULL,NULL,1,'2023-05-29 19:36:42','2023-05-29 19:36:42',NULL),(908,7705,40720,1524,3,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',14332.94,NULL,NULL,1,'2023-05-29 19:37:25','2023-05-29 19:37:25',NULL),(909,7705,40720,1524,3,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',2999.75,NULL,NULL,1,'2023-05-29 19:38:07','2023-05-29 19:38:07',NULL),(910,7705,40720,1524,3,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',16000.00,NULL,NULL,1,'2023-05-29 19:39:14','2023-05-29 19:39:14',NULL),(911,7705,40720,1524,3,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',30000.00,NULL,NULL,1,'2023-05-29 19:41:07','2023-05-29 19:41:07',NULL),(912,7705,40720,1524,3,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',18487.29,NULL,NULL,1,'2023-05-29 20:01:47','2023-05-29 20:01:47',NULL),(913,7705,40720,1524,3,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',11901.66,NULL,NULL,1,'2023-05-29 20:04:42','2023-05-29 20:04:42',NULL),(914,7705,40720,1524,3,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',10000.12,NULL,NULL,1,'2023-05-29 20:05:26','2023-05-29 20:05:26',NULL);
INSERT INTO `balance_libro` VALUES (915,7705,40720,1524,3,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',25091.59,NULL,NULL,1,'2023-05-29 20:06:17','2023-05-29 20:06:17',NULL),(916,7705,40720,1524,3,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',2000.24,NULL,NULL,1,'2023-05-29 20:09:10','2023-05-29 20:09:10',NULL),(917,7705,40720,1524,3,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',9998.79,NULL,NULL,1,'2023-05-29 20:10:20','2023-05-29 20:10:20',NULL),(918,7705,40720,1524,3,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',3499.88,NULL,NULL,1,'2023-05-29 20:12:24','2023-05-29 20:12:24',NULL),(919,7705,40720,1524,3,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',3000.37,NULL,NULL,1,'2023-05-29 20:13:10','2023-05-29 20:13:10',NULL),(920,7705,40720,1524,3,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',24400.99,NULL,NULL,1,'2023-05-29 20:14:02','2023-05-29 20:14:02',NULL),(921,7705,40720,1524,3,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',5999.63,NULL,NULL,1,'2023-05-29 20:15:23','2023-05-29 20:15:23',NULL),(922,7705,40720,1524,3,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',23300.40,NULL,NULL,1,'2023-05-29 20:16:24','2023-05-29 20:16:24',NULL),(923,7705,40720,1524,3,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',20999.28,NULL,NULL,1,'2023-05-29 20:17:25','2023-05-29 20:17:25',NULL),(924,7705,40720,1524,3,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',17500.64,NULL,NULL,1,'2023-05-29 20:18:23','2023-05-29 20:18:23',NULL),(925,7705,40720,1524,3,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',21602.22,NULL,NULL,1,'2023-05-29 20:19:31','2023-05-29 20:19:31',NULL),(926,7705,40720,1524,3,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',4000.50,NULL,NULL,1,'2023-05-29 20:20:07','2023-05-29 20:20:07',NULL),(927,7705,40720,1524,3,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',3000.37,NULL,NULL,1,'2023-05-29 20:20:48','2023-05-30 20:46:18','2023-05-30 20:46:18'),(928,7705,40720,1524,3,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',13003.24,NULL,NULL,1,'2023-05-30 20:50:28','2023-05-30 20:50:28',NULL),(929,7705,40720,1524,3,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',17500.66,NULL,NULL,1,'2023-05-30 20:51:13','2023-05-30 20:51:13',NULL),(930,7705,40720,1524,3,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',10000.00,NULL,NULL,1,'2023-05-30 20:51:57','2023-05-30 20:51:57',NULL),(931,7705,40720,1524,3,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',4999.51,NULL,NULL,1,'2023-05-30 20:52:38','2023-05-30 20:52:38',NULL),(932,7705,40720,1524,3,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',27401.18,NULL,NULL,1,'2023-05-30 20:53:23','2023-05-30 20:53:23',NULL),(933,7705,40720,1524,3,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',30016.21,NULL,NULL,1,'2023-05-30 20:54:45','2023-05-30 20:54:45',NULL),(934,7705,40720,1524,3,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',10000.16,NULL,NULL,1,'2023-05-30 20:55:24','2023-05-30 20:55:24',NULL),(935,7705,40720,1524,3,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',9237.94,NULL,NULL,1,'2023-05-30 20:56:03','2023-05-30 20:56:03',NULL);
INSERT INTO `balance_libro` VALUES (936,7705,40720,1524,3,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',9803.28,NULL,NULL,1,'2023-05-30 20:56:40','2023-05-30 20:56:40',NULL),(937,7705,40720,1524,3,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',10000.16,NULL,NULL,1,'2023-05-30 20:57:13','2023-05-30 20:57:13',NULL),(938,7705,40720,1524,3,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',37398.00,NULL,NULL,1,'2023-05-30 21:05:18','2023-05-30 21:05:18',NULL),(939,7705,40720,1524,3,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',10000.16,NULL,NULL,1,'2023-05-30 21:07:17','2023-05-30 21:07:17',NULL),(940,7705,40720,1524,3,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',14999.68,NULL,NULL,1,'2023-05-30 21:19:16','2023-05-30 21:19:16',NULL),(941,7705,40720,1524,3,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',650.01,NULL,NULL,1,'2023-05-30 21:20:40','2023-05-30 21:20:40',NULL),(942,7705,40720,1524,3,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',11668.21,NULL,NULL,1,'2023-05-30 21:27:59','2023-05-30 21:27:59',NULL),(943,7705,40720,1524,3,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',14999.68,NULL,NULL,1,'2023-05-30 21:29:37','2023-05-30 21:29:37',NULL),(944,7705,40720,1524,3,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',3000.37,NULL,NULL,1,'2023-05-30 21:30:26','2023-05-30 21:30:26',NULL),(945,7705,40720,1524,3,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',14999.68,NULL,NULL,1,'2023-05-30 21:31:07','2023-05-30 21:31:07',NULL),(946,7705,40720,1524,3,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',15079.54,NULL,NULL,1,'2023-05-30 21:32:04','2023-05-30 21:32:04',NULL),(947,7705,40720,1524,3,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5000.01,NULL,NULL,1,'2023-05-30 21:32:41','2023-05-30 21:32:41',NULL),(948,7705,40720,1524,3,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',35000.00,NULL,NULL,1,'2023-05-30 21:33:21','2023-05-30 21:33:21',NULL),(949,7705,40720,1524,3,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',4000.00,NULL,NULL,1,'2023-05-30 21:33:56','2023-05-30 21:33:56',NULL),(950,7705,40720,1524,3,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',3400.10,NULL,NULL,1,'2023-06-04 09:00:13','2023-06-04 09:00:13',NULL),(951,7705,40720,1524,3,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',6800.20,NULL,NULL,1,'2023-06-04 09:00:48','2023-06-04 09:00:48',NULL),(952,7705,40720,1524,3,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',10500.02,NULL,NULL,1,'2023-06-04 09:02:03','2023-06-04 09:02:03',NULL),(953,7705,40720,1524,3,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',133200.01,NULL,NULL,1,'2023-06-04 09:03:45','2023-06-04 09:03:45',NULL),(954,7705,40720,1524,3,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',20745.45,NULL,NULL,1,'2023-06-04 09:05:36','2023-06-04 09:05:36',NULL),(955,7705,40720,1524,3,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',10000.65,NULL,NULL,1,'2023-06-04 09:08:00','2023-06-04 09:08:00',NULL),(956,7705,40720,1524,3,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',20000.09,NULL,NULL,1,'2023-06-04 09:10:09','2023-06-04 09:10:09',NULL);
INSERT INTO `balance_libro` VALUES (957,7705,40720,1524,3,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',16750.03,NULL,NULL,1,'2023-06-04 09:11:03','2023-06-04 09:11:03',NULL),(958,7705,40720,1524,3,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',4345.12,NULL,NULL,1,'2023-06-04 09:11:52','2023-06-04 09:11:52',NULL),(959,7705,40720,1524,3,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',20000.01,NULL,NULL,1,'2023-06-04 09:16:12','2023-06-04 09:16:12',NULL),(960,7705,40720,1524,3,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',9800.00,NULL,NULL,1,'2023-06-04 09:18:17','2023-06-04 09:18:17',NULL),(961,7705,40720,1524,3,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',3500.00,NULL,NULL,1,'2023-06-04 09:19:52','2023-06-04 09:19:52',NULL),(962,7705,40720,1524,3,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',10301.20,NULL,NULL,1,'2023-06-04 09:20:59','2023-06-04 09:20:59',NULL),(963,7705,40720,1524,3,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',15425.43,NULL,NULL,1,'2023-06-04 09:23:35','2023-06-04 09:23:35',NULL),(964,7705,40720,1524,3,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',1763.31,NULL,NULL,1,'2023-06-04 09:25:02','2023-06-04 09:25:02',NULL),(965,7705,40720,1524,3,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',37576.00,NULL,NULL,1,'2023-06-04 09:35:27','2023-06-04 09:35:27',NULL),(966,7705,40720,1524,15,2101,'App\\Models\\PeriodLiquidation',NULL,2101,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1307514.79,NULL,NULL,1,'2023-06-05 19:47:51','2023-06-05 19:47:51',NULL),(967,7705,40720,1525,3,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',7600.51,NULL,NULL,1,'2023-06-18 09:14:17','2023-06-18 09:14:17',NULL),(968,7705,40720,1525,3,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',12020.00,NULL,NULL,1,'2023-06-18 09:17:59','2023-06-18 09:17:59',NULL),(969,7705,40720,1525,3,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',16000.82,NULL,NULL,1,'2023-06-18 09:21:23','2023-06-18 09:21:23',NULL),(970,7705,40720,1525,3,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',7800.75,NULL,NULL,1,'2023-06-18 09:32:54','2023-06-18 09:32:54',NULL),(971,7705,40720,1525,3,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',6999.76,NULL,NULL,1,'2023-06-20 10:58:45','2023-06-20 10:58:45',NULL),(972,7705,40720,1525,3,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',19400.01,NULL,NULL,1,'2023-06-20 11:01:10','2023-06-20 11:01:10',NULL),(973,7705,40720,1525,3,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',21000.36,NULL,NULL,1,'2023-06-20 11:02:10','2023-06-20 11:02:10',NULL),(974,7705,40720,1525,3,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',3999.31,NULL,NULL,1,'2023-06-20 11:03:35','2023-06-20 11:03:35',NULL),(975,7705,40720,1525,3,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',6754.68,NULL,NULL,1,'2023-06-20 11:04:43','2023-06-20 11:04:43',NULL),(976,7705,40720,1525,3,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',12000.42,NULL,NULL,1,'2023-06-20 11:05:41','2023-06-20 11:05:41',NULL),(977,7705,40720,1525,3,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',21000.41,NULL,NULL,1,'2023-06-20 11:06:25','2023-06-20 11:06:25',NULL);
INSERT INTO `balance_libro` VALUES (978,7705,40720,1525,3,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',5999.83,NULL,NULL,1,'2023-06-20 11:07:29','2023-06-20 11:07:29',NULL),(979,7705,40720,1525,3,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',18999.91,NULL,NULL,1,'2023-06-20 11:08:30','2023-06-20 11:08:30',NULL),(980,7705,40720,1525,3,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',24201.60,NULL,NULL,1,'2023-06-20 11:09:29','2023-06-20 11:09:29',NULL),(981,7705,40720,1525,3,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',30702.45,NULL,NULL,1,'2023-06-20 11:10:11','2023-06-20 11:10:11',NULL),(982,7705,40720,1525,3,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',27300.92,NULL,NULL,1,'2023-06-20 11:10:51','2023-06-20 11:10:51',NULL),(983,7705,40720,1525,3,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',31400.10,NULL,NULL,1,'2023-06-20 11:12:38','2023-06-20 11:12:38',NULL),(984,7705,40720,1525,3,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',7000.03,NULL,NULL,1,'2023-06-20 11:16:00','2023-06-20 11:16:00',NULL),(985,7705,40720,1525,3,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',11999.34,NULL,NULL,1,'2023-06-20 11:20:41','2023-06-20 11:20:41',NULL),(986,7705,40720,1525,3,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',10000.32,NULL,NULL,1,'2023-06-20 11:26:16','2023-06-20 11:26:16',NULL),(987,7705,40720,1525,3,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',33772.16,NULL,NULL,1,'2023-06-20 11:27:11','2023-06-20 11:27:11',NULL),(988,7705,40720,1525,3,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',10000.16,NULL,NULL,1,'2023-06-20 11:27:59','2023-06-20 11:27:59',NULL),(989,7705,40720,1525,3,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',4999.51,NULL,NULL,1,'2023-06-20 11:28:46','2023-06-20 11:28:46',NULL),(990,7705,40720,1525,3,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',19700.00,NULL,NULL,1,'2023-06-20 11:30:21','2023-06-20 11:30:21',NULL),(991,7705,40720,1525,3,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',9822.01,NULL,NULL,1,'2023-06-20 11:43:01','2023-06-20 11:43:01',NULL),(992,7705,40720,1525,3,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',46337.46,NULL,NULL,1,'2023-06-20 11:44:32','2023-06-20 11:44:32',NULL),(993,7705,40720,1525,3,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',175701.00,NULL,NULL,1,'2023-06-20 12:09:34','2023-06-20 12:09:34',NULL),(994,7705,40720,1525,3,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',11335.46,NULL,NULL,1,'2023-06-20 12:11:35','2023-06-20 12:11:35',NULL),(995,7705,40720,1525,3,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',10000.16,NULL,NULL,1,'2023-06-20 12:13:07','2023-06-20 12:13:07',NULL),(996,7705,40720,1525,3,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',4000.00,NULL,NULL,1,'2023-06-20 12:13:44','2023-06-20 12:13:44',NULL),(997,7705,40720,1525,3,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',10000.16,NULL,NULL,1,'2023-06-20 12:14:20','2023-06-20 12:14:20',NULL),(998,7705,40720,1525,3,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',16500.11,NULL,NULL,1,'2023-06-20 12:15:08','2023-06-20 12:15:08',NULL);
INSERT INTO `balance_libro` VALUES (999,7705,40720,1525,3,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',17001.80,NULL,NULL,1,'2023-06-20 12:16:44','2023-06-20 12:16:44',NULL),(1000,7705,40720,1525,3,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',2999.90,NULL,NULL,1,'2023-06-20 12:17:24','2023-06-20 12:18:08','2023-06-20 12:18:08'),(1001,7705,40720,1525,3,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',15000.01,NULL,NULL,1,'2023-06-20 12:19:58','2023-06-20 12:19:58',NULL),(1002,7705,40720,1525,3,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',29665.69,NULL,NULL,1,'2023-06-20 12:20:41','2023-06-20 12:20:41',NULL),(1003,7705,40720,1525,3,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',19000.20,NULL,NULL,1,'2023-06-20 12:21:28','2023-06-20 12:21:28',NULL),(1004,7705,40720,1525,3,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',11001.98,NULL,NULL,1,'2023-06-20 12:23:23','2023-06-20 12:23:23',NULL),(1005,7705,40720,1525,3,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',9000.01,NULL,NULL,1,'2023-06-20 12:24:25','2023-06-20 12:24:25',NULL),(1006,7705,40720,1525,3,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',9500.48,NULL,NULL,1,'2023-06-20 12:25:34','2023-06-20 12:25:34',NULL),(1007,7705,40720,1525,3,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',4999.51,NULL,NULL,1,'2023-06-20 12:26:49','2023-06-20 12:26:49',NULL),(1008,7705,40720,1525,3,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',3400.10,NULL,NULL,1,'2023-06-20 12:28:51','2023-06-20 12:28:51',NULL),(1009,7705,40720,1525,3,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',15400.86,NULL,NULL,1,'2023-06-20 12:31:52','2023-06-20 12:31:52',NULL),(1010,7705,40720,1525,3,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',12514.04,NULL,NULL,1,'2023-06-20 12:33:03','2023-06-20 12:33:03',NULL),(1011,7705,40720,1525,3,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',21000.00,NULL,NULL,1,'2023-06-20 12:34:30','2023-06-20 12:34:30',NULL),(1012,7705,40720,1525,3,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',3000.00,NULL,NULL,1,'2023-06-20 12:36:44','2023-06-20 12:36:44',NULL),(1013,7705,40720,1525,3,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',15100.48,NULL,NULL,1,'2023-06-20 12:38:45','2023-06-20 12:38:45',NULL),(1014,7705,40720,1525,3,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',23602.36,NULL,NULL,1,'2023-06-20 14:55:34','2023-06-20 14:55:34',NULL),(1015,7705,40720,1525,3,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',5000.11,NULL,NULL,1,'2023-06-20 14:56:24','2023-06-20 14:56:24',NULL),(1016,7705,40720,1525,3,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',10000.22,NULL,NULL,1,'2023-06-20 14:57:05','2023-06-20 14:57:05',NULL),(1017,7705,40720,1525,3,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',5000.11,NULL,NULL,1,'2023-06-20 14:57:57','2023-06-20 14:57:57',NULL),(1018,7705,40720,1525,3,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',22901.30,NULL,NULL,1,'2023-06-20 14:58:44','2023-06-20 14:58:44',NULL),(1019,7705,40720,1525,3,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',5000.11,NULL,NULL,1,'2023-06-20 14:59:49','2023-06-20 14:59:49',NULL);
INSERT INTO `balance_libro` VALUES (1020,7705,40720,1525,3,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',11449.00,NULL,NULL,1,'2023-06-20 15:06:58','2023-06-20 15:06:58',NULL),(1021,7705,40720,1525,3,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',7000.38,NULL,NULL,1,'2023-06-20 15:08:11','2023-06-20 15:08:11',NULL),(1022,7705,40720,1525,3,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',5000.11,NULL,NULL,1,'2023-06-20 15:11:09','2023-06-20 15:11:09',NULL),(1023,7705,40720,1525,3,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',19001.70,NULL,NULL,1,'2023-06-20 15:12:03','2023-06-20 15:12:03',NULL),(1024,7705,40720,1525,3,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',14372.43,NULL,NULL,1,'2023-06-20 15:29:43','2023-06-20 15:29:43',NULL),(1025,7705,40720,1525,3,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',12446.67,NULL,NULL,1,'2023-06-21 19:09:46','2023-06-21 19:09:46',NULL),(1026,7705,40720,1525,3,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',22001.86,NULL,NULL,1,'2023-06-21 19:14:29','2023-06-21 19:14:29',NULL),(1027,7705,40720,1525,3,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',18100.80,NULL,NULL,1,'2023-06-21 19:15:29','2023-06-21 19:15:29',NULL),(1028,7705,40720,1525,3,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',6999.97,NULL,NULL,1,'2023-06-21 19:16:08','2023-06-21 19:16:08',NULL),(1029,7705,40720,1525,3,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',19999.99,NULL,NULL,1,'2023-06-21 19:17:25','2023-06-21 19:17:25',NULL),(1030,7705,40720,1525,3,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',19999.36,NULL,NULL,1,'2023-06-21 19:18:06','2023-06-21 19:18:06',NULL),(1031,7705,40720,1525,3,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',9801.36,NULL,NULL,1,'2023-06-21 19:18:55','2023-06-21 19:18:55',NULL),(1032,7705,40720,1525,3,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',24201.95,NULL,NULL,1,'2023-06-21 19:19:42','2023-06-21 19:19:42',NULL),(1033,7705,40720,1525,3,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',15001.14,NULL,NULL,1,'2023-06-21 19:20:42','2023-06-21 19:20:42',NULL),(1034,7705,40720,1525,3,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',22800.01,NULL,NULL,1,'2023-06-21 19:22:35','2023-06-21 19:22:35',NULL),(1035,7705,40720,1525,3,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',31201.35,NULL,NULL,1,'2023-06-21 19:25:44','2023-06-21 19:25:44',NULL),(1036,7705,40720,1525,3,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',5400.46,NULL,NULL,1,'2023-06-21 19:27:22','2023-06-21 19:27:22',NULL),(1037,7705,40720,1525,3,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',34602.61,NULL,NULL,1,'2023-06-21 19:29:10','2023-06-21 19:29:10',NULL),(1038,7705,40720,1525,3,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',9999.68,NULL,NULL,1,'2023-06-21 19:29:56','2023-06-21 19:29:56',NULL),(1039,7705,40720,1525,3,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',8000.41,NULL,NULL,1,'2023-06-21 19:30:41','2023-06-21 19:30:41',NULL),(1040,7705,40720,1525,3,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',15001.14,NULL,NULL,1,'2023-06-21 19:31:29','2023-06-21 19:31:29',NULL);
INSERT INTO `balance_libro` VALUES (1041,7705,40720,1525,3,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',24699.86,NULL,NULL,1,'2023-06-21 19:32:18','2023-06-21 19:32:18',NULL),(1042,7705,40720,1525,3,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',4999.85,NULL,NULL,1,'2023-06-21 19:32:57','2023-06-21 19:32:57',NULL),(1043,7705,40720,1525,3,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',1800.00,NULL,NULL,1,'2023-06-21 19:35:58','2023-06-21 19:35:58',NULL),(1044,7705,40720,1525,3,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',21499.99,NULL,NULL,1,'2023-06-21 19:39:50','2023-06-21 19:39:50',NULL),(1045,7705,40720,1525,3,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',11000.37,NULL,NULL,1,'2023-06-21 19:40:48','2023-06-21 19:40:48',NULL),(1046,7705,40720,1525,3,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',10000.00,NULL,NULL,1,'2023-06-21 19:41:33','2023-06-21 19:41:33',NULL),(1047,7705,40720,1525,3,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',10000.00,NULL,NULL,1,'2023-06-21 19:42:08','2023-06-21 19:42:08',NULL),(1048,7705,40720,1525,3,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',2999.67,NULL,NULL,1,'2023-06-21 19:42:48','2023-06-21 19:42:48',NULL),(1049,7705,40720,1525,3,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',23900.83,NULL,NULL,1,'2023-06-21 19:43:22','2023-06-21 19:43:22',NULL),(1050,7705,40720,1525,3,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',35000.00,NULL,NULL,1,'2023-06-21 19:44:04','2023-06-21 19:44:04',NULL),(1051,7705,40720,1525,3,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',9999.68,NULL,NULL,1,'2023-06-21 19:45:20','2023-06-21 19:45:20',NULL),(1052,7705,40720,1525,3,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',4999.85,NULL,NULL,1,'2023-06-21 19:45:54','2023-06-21 19:45:54',NULL),(1053,7705,40720,1525,3,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',44252.98,NULL,NULL,1,'2023-06-21 19:46:36','2023-06-21 19:46:36',NULL),(1054,7705,40720,1525,3,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',18000.23,NULL,NULL,1,'2023-06-21 19:47:31','2023-06-21 19:47:31',NULL),(1055,7705,40720,1525,3,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',35817.69,NULL,NULL,1,'2023-06-21 19:48:40','2023-06-21 19:48:40',NULL),(1056,7705,40720,1525,3,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',37802.09,NULL,NULL,1,'2023-06-21 19:49:37','2023-06-21 19:49:37',NULL),(1057,7705,40720,1525,3,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',39500.45,NULL,NULL,1,'2023-06-21 19:53:57','2023-06-21 19:53:57',NULL),(1058,7705,40720,1525,3,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',12546.26,NULL,NULL,1,'2023-06-21 19:55:26','2023-06-21 19:55:26',NULL),(1059,7705,40720,1526,3,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',5000.19,NULL,NULL,1,'2023-07-30 08:57:36','2023-07-30 08:57:36',NULL),(1060,7705,40720,1526,3,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',5000.00,NULL,NULL,1,'2023-07-30 08:58:41','2023-07-30 08:58:41',NULL),(1061,7705,40720,1526,3,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',5000.19,NULL,NULL,1,'2023-07-30 09:00:31','2023-07-30 09:00:31',NULL);
INSERT INTO `balance_libro` VALUES (1062,7705,40720,1526,3,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',4000.14,NULL,NULL,1,'2023-07-30 09:04:10','2023-07-30 09:04:10',NULL),(1063,7705,40720,1526,3,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',21770.47,NULL,NULL,1,'2023-07-30 09:06:57','2023-07-30 09:06:57',NULL),(1064,7705,40720,1526,3,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',4000.01,NULL,NULL,1,'2023-07-30 12:33:44','2023-07-30 12:33:44',NULL),(1065,7705,40720,1526,3,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',2650.01,NULL,NULL,1,'2023-07-30 12:35:16','2023-07-30 12:35:16',NULL),(1066,7705,40720,1526,3,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',8999.85,NULL,NULL,1,'2023-07-30 12:36:35','2023-07-30 12:36:35',NULL),(1067,7705,40720,1526,3,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',10000.09,NULL,NULL,1,'2023-07-30 12:37:31','2023-07-30 12:37:31',NULL),(1068,7705,40720,1526,3,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',6000.52,NULL,NULL,1,'2023-07-30 12:38:37','2023-07-30 12:38:37',NULL),(1069,7705,40720,1526,3,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',20000.57,NULL,NULL,1,'2023-07-30 12:39:18','2023-07-30 12:39:18',NULL),(1070,7705,40720,1526,3,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',5299.99,NULL,NULL,1,'2023-07-30 12:41:58','2023-07-30 12:41:58',NULL),(1071,7705,40720,1526,3,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',40901.69,NULL,NULL,1,'2023-07-30 12:43:23','2023-07-30 12:43:23',NULL),(1072,7705,40720,1526,3,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',33998.96,NULL,NULL,1,'2023-07-30 12:44:52','2023-07-30 12:44:52',NULL),(1073,7705,40720,1526,3,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',10000.65,NULL,NULL,1,'2023-07-30 12:46:16','2023-07-30 12:46:16',NULL),(1074,7705,40720,1526,3,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',36407.16,NULL,NULL,1,'2023-07-30 12:46:50','2023-07-30 12:46:50',NULL),(1075,7705,40720,1526,3,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',14805.95,NULL,NULL,1,'2023-07-30 12:47:29','2023-07-30 12:47:29',NULL),(1076,7705,40720,1526,3,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',4999.99,NULL,NULL,1,'2023-07-30 12:48:01','2023-07-30 12:48:01',NULL),(1077,7705,40720,1526,3,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',6000.00,NULL,NULL,1,'2023-07-30 12:49:21','2023-07-30 12:49:21',NULL),(1078,7705,40720,1526,3,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',3999.99,NULL,NULL,1,'2023-07-30 12:50:34','2023-07-30 12:50:34',NULL),(1079,7705,40720,1526,3,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',31080.00,NULL,NULL,1,'2023-07-30 12:52:59','2023-07-30 12:52:59',NULL),(1080,7705,40720,1526,3,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',8807.30,NULL,NULL,1,'2023-07-30 20:52:53','2023-07-30 20:52:53',NULL),(1081,7705,40720,1526,3,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',9999.68,NULL,NULL,1,'2023-07-30 20:55:55','2023-07-30 20:55:55',NULL),(1082,7705,40720,1526,3,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',17369.57,NULL,NULL,1,'2023-07-30 20:58:03','2023-07-30 20:58:03',NULL);
INSERT INTO `balance_libro` VALUES (1083,7705,40720,1526,3,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',4999.85,NULL,NULL,1,'2023-07-30 21:01:46','2023-07-30 21:01:46',NULL),(1084,7705,40720,1526,3,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',9000.20,NULL,NULL,1,'2023-07-30 21:04:17','2023-07-30 21:04:17',NULL),(1085,7705,40720,1526,3,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',237350.41,NULL,NULL,1,'2023-07-30 21:17:36','2023-08-05 09:10:12','2023-08-05 09:10:12'),(1086,7705,40720,1526,3,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',2204.52,NULL,NULL,1,'2023-07-30 21:36:36','2023-07-30 21:36:36',NULL),(1087,7705,40720,1526,3,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',3000.16,NULL,NULL,1,'2023-07-30 21:39:04','2023-07-30 21:39:04',NULL),(1088,7705,40720,1526,3,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',732.97,NULL,NULL,1,'2023-07-30 21:40:29','2023-07-30 21:40:29',NULL),(1089,7705,40720,1526,3,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',4999.85,NULL,NULL,1,'2023-07-30 21:56:17','2023-07-30 21:56:17',NULL),(1090,7705,40720,1526,3,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',9999.68,NULL,NULL,1,'2023-07-30 21:59:06','2023-07-30 21:59:06',NULL),(1091,7705,40720,1526,3,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',14000.03,NULL,NULL,1,'2023-07-30 21:59:51','2023-07-30 21:59:51',NULL),(1092,7705,40720,1526,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',212575.99,NULL,NULL,1,'2023-07-30 22:01:49','2023-08-05 09:10:44','2023-08-05 09:10:44'),(1093,7705,40720,1526,3,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',3999.99,NULL,NULL,1,'2023-07-30 22:02:51','2023-07-30 22:02:51',NULL),(1094,7705,40720,1526,3,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',10000.08,NULL,NULL,1,'2023-07-30 22:04:48','2023-07-30 22:04:48',NULL),(1095,7705,40720,1526,3,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',7000.02,NULL,NULL,1,'2023-07-30 22:05:38','2023-07-30 22:05:38',NULL),(1096,7705,40720,1526,3,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',24999.41,NULL,NULL,1,'2023-07-30 22:06:41','2023-07-30 22:06:41',NULL),(1097,7705,40720,1526,3,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',9999.68,NULL,NULL,1,'2023-07-30 22:08:29','2023-07-30 22:08:29',NULL),(1098,7705,40720,1526,3,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',15999.02,NULL,NULL,1,'2023-07-30 22:10:03','2023-07-30 22:10:03',NULL),(1099,7705,40720,1526,3,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',26000.37,NULL,NULL,1,'2023-07-30 22:11:14','2023-07-30 22:11:14',NULL),(1100,7705,40720,1526,3,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',28500.51,NULL,NULL,1,'2023-07-30 22:12:11','2023-07-30 22:12:11',NULL),(1101,7705,40720,1526,3,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',14999.72,NULL,NULL,1,'2023-07-30 22:13:05','2023-07-30 22:13:05',NULL),(1102,7705,40720,1526,3,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',7999.51,NULL,NULL,1,'2023-07-30 22:14:04','2023-07-30 22:14:04',NULL),(1103,7705,40720,1526,3,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',30318.66,NULL,NULL,1,'2023-07-30 22:14:57','2023-07-30 22:14:57',NULL);
INSERT INTO `balance_libro` VALUES (1104,7705,40720,1526,3,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',31604.27,NULL,NULL,1,'2023-07-30 22:16:11','2023-07-30 22:16:11',NULL),(1105,7705,40720,1526,3,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',4999.85,NULL,NULL,1,'2023-07-30 22:17:03','2023-07-30 22:17:03',NULL),(1106,7705,40720,1526,3,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',28401.46,NULL,NULL,1,'2023-07-30 22:19:03','2023-07-30 22:19:03',NULL),(1107,7705,40720,1526,3,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',8291.21,NULL,NULL,1,'2023-07-30 22:21:39','2023-07-30 22:21:39',NULL),(1108,7705,40720,1526,3,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',228049.91,NULL,NULL,1,'2023-07-30 22:23:58','2023-08-05 09:11:16','2023-08-05 09:11:16'),(1109,7705,40720,1526,3,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',23812.82,NULL,NULL,1,'2023-07-30 22:26:18','2023-07-30 22:26:18',NULL),(1110,7705,40720,1526,3,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',22999.71,NULL,NULL,1,'2023-07-30 22:28:00','2023-07-30 22:28:00',NULL),(1111,7705,40720,1526,3,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',19000.00,NULL,NULL,1,'2023-07-31 07:29:05','2023-07-31 07:29:05',NULL),(1112,7705,40720,1526,3,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',27000.00,NULL,NULL,1,'2023-07-31 07:29:45','2023-07-31 07:29:45',NULL),(1113,7705,40720,1526,3,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',2202.34,NULL,NULL,1,'2023-07-31 07:31:36','2023-07-31 07:31:36',NULL),(1114,7705,40720,1526,3,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',25157.87,NULL,NULL,1,'2023-07-31 07:32:37','2023-07-31 07:32:37',NULL),(1115,7705,40720,1526,3,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',25409.90,NULL,NULL,1,'2023-07-31 07:33:19','2023-07-31 07:33:19',NULL),(1116,7705,40720,1526,3,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',13999.47,NULL,NULL,1,'2023-07-31 07:34:35','2023-07-31 07:34:35',NULL),(1117,7705,40720,1526,3,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',7000.35,NULL,NULL,1,'2023-07-31 07:35:08','2023-07-31 07:35:08',NULL),(1118,7705,40720,1526,3,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',9999.97,NULL,NULL,1,'2023-07-31 07:35:41','2023-07-31 07:35:41',NULL),(1119,7705,40720,1526,3,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-21','2023-05-21',1484.25,NULL,NULL,1,'2023-07-31 07:36:46','2023-07-31 07:36:46',NULL),(1120,7705,40720,1526,3,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-21','2023-05-21',7000.35,NULL,NULL,1,'2023-07-31 07:37:23','2023-07-31 07:37:23',NULL),(1121,7705,40720,1526,3,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',14501.31,NULL,NULL,1,'2023-07-31 07:38:12','2023-07-31 07:38:12',NULL),(1122,7705,40720,1526,3,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',5000.61,NULL,NULL,1,'2023-07-31 07:38:54','2023-07-31 07:38:54',NULL),(1123,7705,40720,1526,3,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',33100.66,NULL,NULL,1,'2023-07-31 07:39:40','2023-07-31 07:39:40',NULL),(1124,7705,40720,1526,3,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',25820.09,NULL,NULL,1,'2023-07-31 07:40:45','2023-07-31 07:40:45',NULL);
INSERT INTO `balance_libro` VALUES (1125,7705,40720,1526,3,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',1692000.00,NULL,NULL,1,'2023-07-31 07:43:22','2023-07-31 07:43:22',NULL),(1126,7705,40720,1526,3,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',94380.00,NULL,NULL,1,'2023-07-31 07:45:19','2023-07-31 07:45:19',NULL),(1127,7705,40720,1526,3,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',8000.26,NULL,NULL,1,'2023-07-31 08:07:56','2023-07-31 08:07:56',NULL),(1128,7705,40720,1526,3,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',4999.76,NULL,NULL,1,'2023-07-31 08:08:50','2023-07-31 08:08:50',NULL),(1129,7705,40720,1526,3,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',10000.02,NULL,NULL,1,'2023-07-31 08:09:19','2023-07-31 08:09:19',NULL),(1130,7705,40720,1526,3,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',23001.38,NULL,NULL,1,'2023-07-31 08:10:08','2023-07-31 08:10:08',NULL),(1131,7705,40720,1526,2,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',31670.82,NULL,NULL,1,'2023-08-05 08:29:56','2023-08-05 08:29:56',NULL),(1132,7705,40720,1526,2,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',7800.63,NULL,NULL,1,'2023-08-05 08:35:02','2023-08-05 08:35:02',NULL),(1133,7705,40720,1526,2,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',10000.02,NULL,NULL,1,'2023-08-05 08:36:15','2023-08-05 08:36:15',NULL),(1134,7705,40720,1526,2,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',8000.26,NULL,NULL,1,'2023-08-05 08:37:08','2023-08-05 08:37:08',NULL),(1135,7705,40720,1526,2,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-28','2023-05-28',19999.11,NULL,NULL,1,'2023-08-05 08:37:59','2023-08-05 08:37:59',NULL),(1136,7705,40720,1526,2,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-28','2023-05-28',2999.99,NULL,NULL,1,'2023-08-05 08:38:43','2023-08-05 08:38:43',NULL),(1137,7705,40720,1526,2,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',10000.25,NULL,NULL,1,'2023-08-05 08:39:30','2023-08-05 08:39:30',NULL),(1138,7705,40720,1526,2,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',14000.00,NULL,NULL,1,'2023-08-05 08:40:16','2023-08-05 08:40:16',NULL),(1139,7705,40720,1526,2,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',13899.24,NULL,NULL,1,'2023-08-05 08:41:20','2023-08-05 08:41:20',NULL),(1140,7705,40720,1526,2,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',95580.04,NULL,NULL,1,'2023-08-05 08:44:34','2023-08-05 08:44:34',NULL),(1141,7705,40720,1526,2,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',36109.99,NULL,NULL,1,'2023-08-05 08:45:07','2023-08-05 08:45:07',NULL),(1142,7705,40720,1526,2,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',3400.10,NULL,NULL,1,'2023-08-05 08:46:08','2023-08-05 08:46:08',NULL),(1143,7705,40720,1526,2,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',3400.10,NULL,NULL,1,'2023-08-05 08:46:39','2023-08-05 08:46:39',NULL),(1144,7705,40720,1526,2,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',24500.00,NULL,NULL,1,'2023-08-05 08:48:03','2023-08-05 08:48:03',NULL),(1145,7705,40720,1526,2,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',29002.59,NULL,NULL,1,'2023-08-05 08:49:23','2023-08-05 08:49:23',NULL);
INSERT INTO `balance_libro` VALUES (1146,7705,40720,1526,2,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',10000.01,NULL,NULL,1,'2023-08-05 08:50:30','2023-08-05 08:50:30',NULL),(1147,7705,40720,1526,2,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',20005.24,NULL,NULL,1,'2023-08-05 08:51:17','2023-08-05 08:51:17',NULL),(1148,7705,40720,1526,2,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',115500.01,NULL,NULL,1,'2023-08-05 08:52:38','2023-08-05 08:52:38',NULL),(1149,7705,40720,1526,3,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',237350.41,NULL,NULL,1,'2023-08-05 09:10:12','2023-08-05 09:10:12',NULL),(1150,7705,40720,1526,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',212575.99,NULL,NULL,1,'2023-08-05 09:10:44','2023-08-05 09:10:44',NULL),(1151,7705,40720,1526,3,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',228049.91,NULL,NULL,1,'2023-08-05 09:11:16','2023-08-05 09:11:16',NULL),(1152,7705,40720,1527,3,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',3999.99,NULL,NULL,1,'2023-08-13 09:09:14','2023-08-13 09:09:14',NULL),(1153,7705,40720,1527,3,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',9250.00,NULL,NULL,1,'2023-08-13 09:13:08','2023-08-13 09:13:08',NULL),(1154,7705,40720,1527,3,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',22998.29,NULL,NULL,1,'2023-08-13 09:17:18','2023-08-13 09:17:18',NULL),(1155,7705,40720,1527,3,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',34001.97,NULL,NULL,1,'2023-08-13 09:30:20','2023-08-13 09:30:20',NULL),(1156,7705,40720,1527,3,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',34731.12,NULL,NULL,1,'2023-08-13 09:40:04','2023-08-13 09:40:04',NULL),(1157,7705,40720,1527,3,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',3900.00,NULL,NULL,1,'2023-08-13 09:42:04','2023-08-13 09:42:04',NULL),(1158,7705,40720,1527,3,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',4000.10,NULL,NULL,1,'2023-08-13 09:43:42','2023-08-13 09:43:42',NULL),(1159,7705,40720,1527,3,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',4800.24,NULL,NULL,1,'2023-08-13 09:44:55','2023-08-13 09:44:55',NULL),(1160,7705,40720,1527,3,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',10000.02,NULL,NULL,1,'2023-08-13 09:46:57','2023-08-13 09:46:57',NULL),(1161,7705,40720,1527,3,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',41834.24,NULL,NULL,1,'2023-08-13 09:48:09','2023-08-13 09:48:09',NULL),(1162,7705,40720,1527,3,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',28000.67,NULL,NULL,1,'2023-08-13 09:50:03','2023-08-13 09:50:03',NULL),(1163,7705,40720,1527,3,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',22499.68,NULL,NULL,1,'2023-08-13 18:49:08','2023-08-13 18:49:08',NULL),(1164,7705,40720,1527,3,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',17500.52,NULL,NULL,1,'2023-08-13 18:50:24','2023-08-13 18:50:24',NULL),(1165,7705,40720,1527,3,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',1509.78,NULL,NULL,1,'2023-08-13 18:52:06','2023-08-13 18:52:06',NULL),(1166,7705,40720,1527,3,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',5000.61,NULL,NULL,1,'2023-08-13 18:54:22','2023-08-13 18:54:22',NULL);
INSERT INTO `balance_libro` VALUES (1167,7705,40720,1527,3,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',2032.80,NULL,NULL,1,'2023-08-13 19:55:05','2023-08-13 19:55:05',NULL),(1168,7705,40720,1527,3,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',4400.00,NULL,NULL,1,'2023-08-13 20:33:24','2023-08-13 20:33:24',NULL),(1169,7705,40720,1527,3,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',21900.00,NULL,NULL,1,'2023-08-13 20:48:21','2023-08-13 20:48:21',NULL),(1170,7705,40720,1527,3,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',252777.28,NULL,NULL,1,'2023-08-22 19:41:26','2023-08-22 19:41:26',NULL),(1171,7705,40720,1527,3,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',6000.51,NULL,NULL,1,'2023-08-22 19:43:35','2023-08-22 19:45:04','2023-08-22 19:45:04'),(1172,7705,40720,1527,3,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',18503.79,NULL,NULL,1,'2023-08-22 19:44:38','2023-08-22 19:44:38',NULL),(1173,7705,40720,1527,3,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',6000.51,NULL,NULL,1,'2023-08-22 19:45:04','2023-08-22 19:45:04',NULL),(1174,7705,40720,1527,3,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',6000.51,NULL,NULL,1,'2023-08-22 19:47:07','2023-08-22 19:47:07',NULL),(1175,7705,40720,1527,3,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',6000.51,NULL,NULL,1,'2023-08-22 19:48:20','2023-08-22 19:48:20',NULL),(1176,7705,40720,1527,3,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',24978.33,NULL,NULL,1,'2023-08-22 19:49:25','2023-08-22 19:49:25',NULL),(1177,7705,40720,1527,3,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',22999.64,NULL,NULL,1,'2023-08-22 19:50:13','2023-08-22 19:50:13',NULL),(1178,7705,40720,1527,3,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',100000.45,NULL,NULL,1,'2023-08-22 19:51:36','2023-08-22 19:51:36',NULL),(1179,7705,40720,1527,3,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',6050.00,NULL,NULL,1,'2023-08-22 19:52:32','2023-08-22 19:52:32',NULL),(1180,7705,40720,1527,3,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',10000.02,NULL,NULL,1,'2023-08-22 19:56:12','2023-08-22 19:56:12',NULL),(1181,7705,40720,1527,3,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-11','2023-06-11',7999.99,NULL,NULL,1,'2023-08-22 20:05:11','2023-08-22 20:05:11',NULL),(1182,7705,40720,1527,3,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',14600.92,NULL,NULL,1,'2023-08-22 20:09:07','2023-08-22 20:09:07',NULL),(1183,7705,40720,1527,3,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',4500.00,NULL,NULL,1,'2023-08-22 20:10:45','2023-08-22 20:10:45',NULL),(1184,7705,40720,1527,3,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',3400.10,NULL,NULL,1,'2023-08-22 20:11:55','2023-08-22 20:11:55',NULL),(1185,7705,40720,1527,3,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',5000.02,NULL,NULL,1,'2023-08-22 20:13:20','2023-08-22 20:13:20',NULL),(1186,7705,40720,1527,3,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',41501.73,NULL,NULL,1,'2023-08-22 20:14:16','2023-08-22 20:14:16',NULL),(1187,7705,40720,1527,3,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',5000.61,NULL,NULL,1,'2023-08-22 20:15:15','2023-08-22 20:15:15',NULL);
INSERT INTO `balance_libro` VALUES (1188,7705,40720,1527,3,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',28864.90,NULL,NULL,1,'2023-08-22 20:16:03','2023-08-22 20:16:03',NULL),(1189,7705,40720,1527,3,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',24000.10,NULL,NULL,1,'2023-08-22 20:16:55','2023-08-22 20:16:55',NULL),(1190,7705,40720,1527,3,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',36101.34,NULL,NULL,1,'2023-08-22 20:23:42','2023-08-22 20:23:42',NULL),(1191,7705,40720,1527,3,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',7000.37,NULL,NULL,1,'2023-08-22 20:25:16','2023-08-22 20:25:16',NULL),(1192,7705,40720,1527,3,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',9000.12,NULL,NULL,1,'2023-08-22 20:25:59','2023-08-22 20:25:59',NULL),(1193,7705,40720,1527,3,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',8638.70,NULL,NULL,1,'2023-08-22 20:27:15','2023-08-22 20:27:15',NULL),(1194,7705,40720,1527,3,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',8000.41,NULL,NULL,1,'2023-08-22 20:33:56','2023-08-22 20:33:56',NULL),(1195,7705,40720,1527,3,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',31080.00,NULL,NULL,1,'2023-08-22 21:12:01','2023-08-22 22:05:46','2023-08-22 22:05:46'),(1196,7705,40720,1527,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',7990.01,NULL,NULL,1,'2023-08-22 21:21:28','2023-08-22 21:21:28',NULL),(1197,7705,40720,1527,3,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-18','2023-06-18',31787.25,NULL,NULL,1,'2023-08-22 21:23:39','2023-08-22 21:23:39',NULL),(1198,7705,40720,1527,3,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-18','2023-06-18',12000.02,NULL,NULL,1,'2023-08-22 21:24:33','2023-08-22 21:24:33',NULL),(1199,7705,40720,1527,3,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-18','2023-06-18',18101.18,NULL,NULL,1,'2023-08-22 21:25:37','2023-08-22 21:25:37',NULL),(1200,7705,40720,1527,3,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',30001.27,NULL,NULL,1,'2023-08-22 21:27:09','2023-08-22 21:27:09',NULL),(1201,7705,40720,1527,3,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',9999.60,NULL,NULL,1,'2023-08-22 21:28:00','2023-08-22 21:28:00',NULL),(1202,7705,40720,1527,3,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-20','2023-06-20',14000.21,NULL,NULL,1,'2023-08-22 21:30:03','2023-08-22 21:30:03',NULL),(1203,7705,40720,1527,3,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-20','2023-06-20',30500.50,NULL,NULL,1,'2023-08-22 21:31:15','2023-08-22 21:31:15',NULL),(1204,7705,40720,1527,3,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',30063.21,NULL,NULL,1,'2023-08-22 21:33:16','2023-08-22 21:33:16',NULL),(1205,7705,40720,1527,3,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',4999.80,NULL,NULL,1,'2023-08-22 21:34:03','2023-08-22 21:34:03',NULL),(1206,7705,40720,1527,3,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',50899.41,NULL,NULL,1,'2023-08-22 21:35:06','2023-08-22 21:35:06',NULL),(1207,7705,40720,1527,3,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',39592.02,NULL,NULL,1,'2023-08-22 21:40:13','2023-08-22 21:40:13',NULL),(1208,7705,40720,1527,3,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',8900.00,NULL,NULL,1,'2023-08-22 21:41:50','2023-08-22 21:41:50',NULL);
INSERT INTO `balance_libro` VALUES (1209,7705,40720,1527,3,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',9314.31,NULL,NULL,1,'2023-08-22 21:44:02','2023-08-22 21:44:02',NULL),(1210,7705,40720,1527,3,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',19999.60,NULL,NULL,1,'2023-08-22 21:47:41','2023-08-22 21:47:41',NULL),(1211,7705,40720,1527,3,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',11650.00,NULL,NULL,1,'2023-08-22 21:52:49','2023-08-22 21:52:49',NULL),(1212,7705,40720,1527,3,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',23440.33,NULL,NULL,1,'2023-08-22 21:55:34','2023-08-22 21:55:34',NULL),(1213,7705,40720,1527,3,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',15701.88,NULL,NULL,1,'2023-08-22 21:56:28','2023-08-22 21:56:28',NULL),(1214,7705,40720,1527,3,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',4999.99,NULL,NULL,1,'2023-08-22 21:57:13','2023-08-22 21:57:13',NULL),(1215,7705,40720,1527,3,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',33218.30,NULL,NULL,1,'2023-08-22 21:58:06','2023-08-22 21:58:06',NULL),(1216,7705,40720,1527,3,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',4999.80,NULL,NULL,1,'2023-08-22 21:59:14','2023-08-22 21:59:14',NULL),(1217,7705,40720,1527,3,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',30999.89,NULL,NULL,1,'2023-08-22 22:00:03','2023-08-22 22:00:03',NULL),(1218,7705,40720,1527,3,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',22999.52,NULL,NULL,1,'2023-08-22 22:00:47','2023-08-22 22:00:47',NULL),(1219,7705,40720,1527,3,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',7000.49,NULL,NULL,1,'2023-08-22 22:01:28','2023-08-22 22:01:28',NULL),(1220,7705,40720,1527,3,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',49415.97,NULL,NULL,1,'2023-08-22 22:02:31','2023-08-22 22:02:31',NULL),(1221,7705,40720,1527,3,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',24999.56,NULL,NULL,1,'2023-08-22 22:03:14','2023-08-22 22:03:14',NULL),(1222,7705,40720,1527,3,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',15999.46,NULL,NULL,1,'2023-08-22 22:04:22','2023-08-22 22:04:22',NULL),(1223,7705,40720,1527,3,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',100000.00,NULL,NULL,1,'2023-08-22 22:16:14','2023-08-22 22:16:14',NULL),(1224,7705,40720,1527,3,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',10064.50,NULL,NULL,1,'2023-08-22 22:17:54','2023-08-22 22:17:54',NULL),(1225,7705,40720,1527,3,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',38900.62,NULL,NULL,1,'2023-08-22 22:25:59','2023-08-22 22:25:59',NULL),(1226,7705,40720,1528,3,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-02','2023-07-02',6601.45,NULL,NULL,1,'2023-09-09 16:18:39','2023-09-09 16:18:39',NULL),(1227,7705,40720,1528,3,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-02','2023-07-02',10000.37,NULL,NULL,1,'2023-09-09 17:35:52','2023-09-09 17:35:52',NULL),(1228,7705,40720,1528,3,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',7998.88,NULL,NULL,1,'2023-09-09 17:36:52','2023-09-09 17:36:52',NULL),(1229,7705,40720,1528,3,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',9999.55,NULL,NULL,1,'2023-09-09 17:39:55','2023-09-09 17:39:55',NULL);
INSERT INTO `balance_libro` VALUES (1230,7705,40720,1528,3,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',4999.80,NULL,NULL,1,'2023-09-09 17:41:19','2023-09-09 17:41:19',NULL),(1231,7705,40720,1528,3,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',25000.48,NULL,NULL,1,'2023-09-09 17:42:06','2023-09-09 17:42:06',NULL),(1232,7705,40720,1528,3,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',15000.56,NULL,NULL,1,'2023-09-09 17:43:09','2023-09-09 17:43:09',NULL),(1233,7705,40720,1528,3,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',41304.03,NULL,NULL,1,'2023-09-09 17:44:44','2023-09-09 17:44:44',NULL),(1234,7705,40720,1528,3,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',25969.12,NULL,NULL,1,'2023-09-09 17:45:42','2023-09-09 17:45:42',NULL),(1235,7705,40720,1528,3,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',52645.28,NULL,NULL,1,'2023-09-09 18:11:24','2023-09-09 18:11:24',NULL),(1236,7705,40720,1528,3,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',25002.38,NULL,NULL,1,'2023-09-09 18:12:10','2023-09-09 18:12:10',NULL),(1237,7705,40720,1528,3,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',25199.82,NULL,NULL,1,'2023-09-09 18:13:04','2023-09-09 18:13:04',NULL),(1238,7705,40720,1528,3,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',21000.82,NULL,NULL,1,'2023-09-09 18:13:48','2023-09-09 18:13:48',NULL),(1239,7705,40720,1528,3,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',3500.01,NULL,NULL,1,'2023-09-09 18:14:42','2023-09-09 18:14:42',NULL),(1240,7705,40720,1528,3,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',10000.78,NULL,NULL,1,'2023-09-09 18:15:54','2023-09-09 18:15:54',NULL),(1241,7705,40720,1528,3,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',21200.78,NULL,NULL,1,'2023-09-09 18:17:20','2023-09-09 18:17:20',NULL),(1242,7705,40720,1528,3,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',40001.97,NULL,NULL,1,'2023-09-09 18:18:35','2023-09-09 18:18:35',NULL),(1243,7705,40720,1528,3,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',15000.58,NULL,NULL,1,'2023-09-09 18:19:25','2023-09-09 18:19:25',NULL),(1244,7705,40720,1528,3,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',27915.06,NULL,NULL,1,'2023-09-09 18:20:04','2023-09-09 18:20:04',NULL),(1245,7705,40720,1528,3,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',15000.00,NULL,NULL,1,'2023-09-09 18:20:42','2023-09-09 18:20:42',NULL),(1246,7705,40720,1528,3,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',15497.68,NULL,NULL,1,'2023-09-09 18:23:22','2023-09-09 18:23:22',NULL),(1247,7705,40720,1528,3,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',10000.00,NULL,NULL,1,'2023-09-09 18:24:31','2023-09-09 18:24:31',NULL),(1248,7705,40720,1528,3,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',7671.17,NULL,NULL,1,'2023-09-09 18:26:29','2023-09-09 18:26:29',NULL),(1249,7705,40720,1528,3,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',9957.50,NULL,NULL,1,'2023-09-09 18:27:20','2023-09-09 18:27:20',NULL),(1250,7705,40720,1528,3,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',4500.00,NULL,NULL,1,'2023-09-09 18:28:53','2023-09-09 18:28:53',NULL);
INSERT INTO `balance_libro` VALUES (1251,7705,40720,1528,3,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',55006.07,NULL,NULL,1,'2023-09-09 18:30:07','2023-09-09 18:30:07',NULL),(1252,7705,40720,1528,3,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-23','2023-07-23',30001.00,NULL,NULL,1,'2023-09-09 18:30:51','2023-09-09 18:30:51',NULL),(1253,7705,40720,1528,3,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-23','2023-07-23',12052.62,NULL,NULL,1,'2023-09-09 18:31:29','2023-09-09 18:31:29',NULL),(1254,7705,40720,1528,3,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-23','2023-07-23',13100.78,NULL,NULL,1,'2023-09-09 18:32:12','2023-09-09 18:32:12',NULL),(1255,7705,40720,1528,3,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',7999.31,NULL,NULL,1,'2023-09-09 18:33:01','2023-09-09 18:33:01',NULL),(1256,7705,40720,1528,3,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',4000.10,NULL,NULL,1,'2023-09-09 18:34:23','2023-09-09 18:34:23',NULL),(1257,7705,40720,1528,3,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',13000.04,NULL,NULL,1,'2023-09-09 18:36:17','2023-09-09 18:36:17',NULL),(1258,7705,40720,1528,3,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',12900.00,NULL,NULL,1,'2023-09-09 18:37:28','2023-09-09 18:37:28',NULL),(1259,7705,40720,1528,3,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',44329.07,NULL,NULL,1,'2023-09-09 18:38:22','2023-09-09 18:38:22',NULL),(1260,7705,40720,1528,3,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',34829.35,NULL,NULL,1,'2023-09-09 18:39:04','2023-09-09 18:39:04',NULL),(1261,7705,40720,1528,3,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',15500.56,NULL,NULL,1,'2023-09-09 18:39:41','2023-09-09 18:39:41',NULL),(1262,7705,40720,1528,3,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',3400.10,NULL,NULL,1,'2023-09-09 18:41:09','2023-09-09 18:41:09',NULL),(1263,7705,40720,1528,3,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',4000.02,NULL,NULL,1,'2023-09-09 18:42:19','2023-09-09 18:42:19',NULL),(1264,7705,40720,1528,3,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',59302.84,NULL,NULL,1,'2023-09-09 18:43:35','2023-09-09 18:43:35',NULL),(1265,7705,40720,1528,3,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',12900.00,NULL,NULL,1,'2023-09-09 18:56:03','2023-09-09 18:57:24','2023-09-09 18:57:24'),(1266,7705,40720,1528,3,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',3674.96,NULL,NULL,1,'2023-09-18 20:28:41','2023-09-18 20:28:41',NULL),(1267,7705,40720,1528,3,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',4350.55,NULL,NULL,1,'2023-09-18 21:09:13','2023-09-18 21:09:13',NULL),(1268,7705,40720,1528,3,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',2255.13,NULL,NULL,1,'2023-09-18 21:11:39','2023-09-18 21:11:39',NULL),(1269,7705,40720,1528,3,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',2141.48,NULL,NULL,1,'2023-09-18 21:12:48','2023-09-18 21:12:48',NULL),(1270,7705,40720,1528,3,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',3243.22,NULL,NULL,1,'2023-09-18 21:18:44','2023-09-18 21:18:44',NULL),(1271,7705,40720,1528,3,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',4970.90,NULL,NULL,1,'2023-09-18 21:19:49','2023-09-18 21:19:49',NULL);
INSERT INTO `balance_libro` VALUES (1272,7705,40720,1528,3,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',27830.00,NULL,NULL,1,'2023-09-24 10:14:40','2023-09-25 17:04:48','2023-09-25 17:04:48'),(1273,7705,40720,1528,3,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',57222.00,NULL,NULL,1,'2023-09-24 10:17:04','2023-09-24 10:17:04',NULL),(1274,7705,40720,1528,3,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',46974.00,NULL,NULL,1,'2023-09-25 16:30:38','2023-09-25 17:00:24','2023-09-25 17:00:24'),(1275,7705,40720,1528,3,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',23174.00,NULL,NULL,1,'2023-09-25 16:32:36','2023-09-25 17:04:22','2023-09-25 17:04:22'),(1276,7705,40720,1528,3,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',46974.00,NULL,NULL,1,'2023-09-25 17:00:24','2023-09-25 17:04:34','2023-09-25 17:04:34'),(1277,7705,40720,1528,3,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',23174.00,NULL,NULL,1,'2023-09-25 17:04:22','2023-09-25 17:04:22',NULL),(1278,7705,40720,1528,3,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',46974.00,NULL,NULL,1,'2023-09-25 17:04:34','2023-09-25 17:04:34',NULL),(1279,7705,40720,1528,3,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',27830.00,NULL,NULL,1,'2023-09-25 17:04:48','2023-09-25 17:04:48',NULL),(1280,7705,40720,1529,3,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-30','2023-07-30',4000.10,NULL,NULL,1,'2023-09-25 21:04:13','2023-10-14 14:16:56','2023-10-14 14:16:56'),(1281,7705,40720,1529,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',31309.39,NULL,NULL,1,'2023-10-14 13:09:27','2023-10-14 14:17:27','2023-10-14 14:17:27'),(1282,7705,40720,1529,3,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',45102.67,NULL,NULL,1,'2023-10-14 13:10:15','2023-10-14 14:19:13','2023-10-14 14:19:13'),(1283,7705,40720,1529,3,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',18999.68,NULL,NULL,1,'2023-10-14 13:11:14','2023-10-14 14:20:27','2023-10-14 14:20:27'),(1284,7705,40720,1529,3,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-06','2023-08-06',10999.29,NULL,NULL,1,'2023-10-14 13:12:14','2023-10-14 14:22:07','2023-10-14 14:22:07'),(1285,7705,40720,1529,3,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-06','2023-08-06',64010.17,NULL,NULL,1,'2023-10-14 13:13:57','2023-10-14 14:22:26','2023-10-14 14:22:26'),(1286,7705,40720,1529,3,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-06','2023-08-06',16000.65,NULL,NULL,1,'2023-10-14 13:14:41','2023-10-14 14:23:32','2023-10-14 14:23:32'),(1287,7705,40720,1529,3,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-06','2023-08-06',5000.12,NULL,NULL,1,'2023-10-14 13:40:08','2023-10-14 14:23:48','2023-10-14 14:23:48'),(1288,7705,40720,1529,3,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',34999.82,NULL,NULL,1,'2023-10-14 13:41:20','2023-10-14 13:43:03','2023-10-14 13:43:03'),(1289,7705,40720,1529,3,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',34999.82,NULL,NULL,1,'2023-10-14 13:43:03','2023-10-14 14:45:04','2023-10-14 14:45:04'),(1290,7705,40720,1529,3,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',15000.27,NULL,NULL,1,'2023-10-14 13:45:56','2023-10-14 14:44:31','2023-10-14 14:44:31');
INSERT INTO `balance_libro` VALUES (1291,7705,40720,1529,3,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',12001.39,NULL,NULL,1,'2023-10-14 13:48:34','2023-10-14 14:37:48','2023-10-14 14:37:48'),(1292,7705,40720,1529,3,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',15999.44,NULL,NULL,1,'2023-10-14 13:49:19','2023-10-14 14:37:28','2023-10-14 14:37:28'),(1293,7705,40720,1529,3,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',28724.30,NULL,NULL,1,'2023-10-14 13:50:11','2023-10-14 14:43:39','2023-10-14 14:43:39'),(1294,7705,40720,1529,3,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',38112.23,NULL,NULL,1,'2023-10-14 14:03:55','2023-10-14 14:42:49','2023-10-14 14:42:49'),(1295,7705,40720,1529,3,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',21015.35,NULL,NULL,1,'2023-10-14 14:05:08','2023-10-14 14:41:37','2023-10-14 14:41:37'),(1296,7705,40720,1529,3,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-13','2023-08-13',3999.90,NULL,NULL,1,'2023-10-14 14:07:57','2023-10-14 14:41:13','2023-10-14 14:41:13'),(1297,7705,40720,1529,3,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',5000.55,NULL,NULL,1,'2023-10-14 14:10:15','2023-10-14 14:39:55','2023-10-14 14:39:55'),(1298,7705,40720,1529,3,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',12000.00,NULL,NULL,1,'2023-10-14 14:15:19','2023-10-14 14:39:27','2023-10-14 14:39:27'),(1299,7705,40720,1529,3,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-30','2023-07-30',4000.10,NULL,NULL,1,'2023-10-14 14:16:56','2023-10-14 14:16:56',NULL),(1300,7705,40720,1529,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',31309.39,NULL,NULL,1,'2023-10-14 14:17:27','2023-10-14 14:17:27',NULL),(1301,7705,40720,1529,3,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',45102.67,NULL,NULL,1,'2023-10-14 14:19:13','2023-10-14 14:19:13',NULL),(1302,7705,40720,1529,3,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',18999.68,NULL,NULL,1,'2023-10-14 14:20:27','2023-10-14 14:20:27',NULL),(1303,7705,40720,1529,3,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-06','2023-08-06',10999.29,NULL,NULL,1,'2023-10-14 14:22:07','2023-10-14 14:22:07',NULL),(1304,7705,40720,1529,3,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-06','2023-08-06',64010.17,NULL,NULL,1,'2023-10-14 14:22:26','2023-10-14 14:22:26',NULL),(1305,7705,40720,1529,3,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-06','2023-08-06',16000.65,NULL,NULL,1,'2023-10-14 14:23:32','2023-10-14 14:23:32',NULL),(1306,7705,40720,1529,3,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-06','2023-08-06',5000.12,NULL,NULL,1,'2023-10-14 14:23:48','2023-10-14 14:23:48',NULL),(1307,7705,40720,1529,3,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',15999.44,NULL,NULL,1,'2023-10-14 14:37:28','2023-10-14 14:37:28',NULL),(1308,7705,40720,1529,3,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',12001.39,NULL,NULL,1,'2023-10-14 14:37:48','2023-10-14 14:37:48',NULL),(1309,7705,40720,1529,3,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',12000.00,NULL,NULL,1,'2023-10-14 14:39:27','2023-10-14 14:39:27',NULL),(1310,7705,40720,1529,3,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',5000.55,NULL,NULL,1,'2023-10-14 14:39:55','2023-10-14 14:39:55',NULL);
INSERT INTO `balance_libro` VALUES (1311,7705,40720,1529,3,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-13','2023-08-13',3999.90,NULL,NULL,1,'2023-10-14 14:41:13','2023-10-14 14:41:13',NULL),(1312,7705,40720,1529,3,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',21015.35,NULL,NULL,1,'2023-10-14 14:41:37','2023-10-14 14:41:37',NULL),(1313,7705,40720,1529,3,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',38112.23,NULL,NULL,1,'2023-10-14 14:42:49','2023-10-14 14:42:49',NULL),(1314,7705,40720,1529,3,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',28724.30,NULL,NULL,1,'2023-10-14 14:43:39','2023-10-14 14:43:39',NULL),(1315,7705,40720,1529,3,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',15000.27,NULL,NULL,1,'2023-10-14 14:44:31','2023-10-14 14:44:31',NULL),(1316,7705,40720,1529,3,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',34999.82,NULL,NULL,1,'2023-10-14 14:45:04','2023-10-14 14:45:04',NULL),(1317,7705,40720,1529,3,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',18000.53,NULL,NULL,1,'2023-10-14 14:48:23','2023-10-14 14:48:23',NULL),(1318,7705,40720,1529,3,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',7997.34,NULL,NULL,1,'2023-10-14 14:49:48','2023-10-14 14:49:48',NULL),(1319,7705,40720,1529,3,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',12999.58,NULL,NULL,1,'2023-10-14 14:51:00','2023-10-14 14:51:00',NULL),(1320,7705,40720,1529,3,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',10000.42,NULL,NULL,1,'2023-10-14 14:54:00','2023-10-14 14:54:00',NULL),(1321,7705,40720,1529,3,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',17677.82,NULL,NULL,1,'2023-10-14 14:55:31','2023-10-14 14:55:31',NULL),(1322,7705,40720,1529,3,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',5999.92,NULL,NULL,1,'2023-10-14 14:57:06','2023-10-14 14:57:06',NULL),(1323,7705,40720,1529,3,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',5999.93,NULL,NULL,1,'2023-10-14 14:58:19','2023-10-14 14:58:19',NULL),(1324,7705,40720,1529,3,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-21','2023-08-21',23300.41,NULL,NULL,1,'2023-10-14 14:59:30','2023-10-14 14:59:30',NULL),(1325,7705,40720,1529,3,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',17999.77,NULL,NULL,1,'2023-10-14 15:03:48','2023-10-14 15:03:48',NULL),(1326,7705,40720,1529,3,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',27501.79,NULL,NULL,1,'2023-10-14 15:05:22','2023-10-14 15:05:22',NULL),(1327,7705,40720,1529,3,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',48004.15,NULL,NULL,1,'2023-10-14 15:06:27','2023-10-14 15:06:27',NULL),(1328,7705,40720,1529,3,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',20001.58,NULL,NULL,1,'2023-10-14 15:07:37','2023-10-14 15:07:37',NULL),(1329,7705,40720,1529,3,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',15000.76,NULL,NULL,1,'2023-10-14 15:08:43','2023-10-14 15:08:43',NULL),(1330,7705,40720,1529,3,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-26','2023-08-26',4999.95,NULL,NULL,1,'2023-10-14 15:09:45','2023-10-14 15:09:45',NULL),(1331,7705,40720,1529,3,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',41305.19,NULL,NULL,1,'2023-10-14 15:11:04','2023-10-14 15:11:04',NULL);
INSERT INTO `balance_libro` VALUES (1332,7705,40720,1529,3,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',49301.86,NULL,NULL,1,'2023-10-14 15:11:54','2023-10-14 15:11:54',NULL),(1333,7705,40720,1529,3,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',5000.80,NULL,NULL,1,'2023-10-14 15:14:29','2023-10-14 15:15:38','2023-10-14 15:15:38'),(1334,7705,40720,1529,3,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',5000.80,NULL,NULL,1,'2023-10-14 15:15:38','2023-10-14 15:15:38',NULL),(1335,7705,40720,1529,3,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',7800.00,NULL,NULL,1,'2023-10-14 15:17:48','2023-10-14 15:17:48',NULL),(1336,7705,40720,1529,3,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',5000.01,NULL,NULL,1,'2023-10-14 15:18:48','2023-10-14 15:18:48',NULL),(1337,7705,40720,1529,3,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',22799.99,NULL,NULL,1,'2023-10-14 15:20:23','2023-10-14 15:20:23',NULL),(1338,7705,40720,1529,3,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',68300.26,NULL,NULL,1,'2023-10-14 15:22:12','2023-10-14 15:22:12',NULL),(1339,7705,40720,1529,3,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',3400.10,NULL,NULL,1,'2023-10-14 15:23:49','2023-10-14 15:23:49',NULL),(1340,7705,40720,1529,3,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',2032.80,NULL,NULL,1,'2023-10-14 15:24:19','2023-10-14 15:24:19',NULL),(1341,7705,40720,1529,3,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',11087.23,NULL,NULL,1,'2023-10-14 15:25:25','2023-10-14 15:25:25',NULL),(1342,7705,40720,1529,3,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',5900.01,NULL,NULL,1,'2023-10-14 15:26:49','2023-10-14 15:26:49',NULL),(1343,7705,40720,1529,3,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',7100.00,NULL,NULL,1,'2023-10-14 15:27:39','2023-10-14 15:27:39',NULL),(1344,7705,40720,1529,3,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',7500.02,NULL,NULL,1,'2023-10-14 15:28:20','2023-10-14 15:28:20',NULL),(1345,7705,40720,1529,3,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',3400.10,NULL,NULL,1,'2023-10-14 15:29:18','2023-10-14 15:29:18',NULL),(1346,7705,40720,1529,3,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',7000.00,NULL,NULL,1,'2023-10-14 15:31:00','2023-10-14 15:31:00',NULL),(1347,7705,40720,1529,3,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',88758.00,NULL,NULL,1,'2023-10-16 09:53:25','2023-10-16 09:57:17','2023-10-16 09:57:17'),(1348,7705,40720,1529,3,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',88758.00,NULL,NULL,1,'2023-10-16 09:57:17','2023-10-16 09:57:17',NULL),(1349,7705,40720,1529,3,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',1891.57,NULL,NULL,1,'2023-10-16 10:30:49','2023-10-16 10:30:49',NULL),(1350,7705,40720,1530,3,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',19999.42,NULL,NULL,1,'2023-11-15 06:59:47','2023-11-15 08:08:36','2023-11-15 08:08:36'),(1351,7705,40720,1530,3,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',50805.63,NULL,NULL,1,'2023-11-15 07:01:38','2023-11-15 08:08:09','2023-11-15 08:08:09');
INSERT INTO `balance_libro` VALUES (1352,7705,40720,1530,3,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',26100.46,NULL,NULL,1,'2023-11-15 07:03:46','2023-11-15 08:07:30','2023-11-15 08:07:30'),(1353,7705,40720,1530,3,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',9999.94,NULL,NULL,1,'2023-11-15 07:04:36','2023-11-15 08:07:06','2023-11-15 08:07:06'),(1354,7705,40720,1530,3,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',4999.95,NULL,NULL,1,'2023-11-15 07:06:23','2023-11-15 07:07:30','2023-11-15 07:07:30'),(1355,7705,40720,1530,3,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',4999.95,NULL,NULL,1,'2023-11-15 07:07:30','2023-11-15 08:06:40','2023-11-15 08:06:40'),(1356,7705,40720,1530,3,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',13000.08,NULL,NULL,1,'2023-11-15 07:09:55','2023-11-18 06:55:00','2023-11-18 06:55:00'),(1357,7705,40720,1530,3,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',5999.95,NULL,NULL,1,'2023-11-15 07:11:47','2023-11-18 06:52:40','2023-11-18 06:52:40'),(1358,7705,40720,1530,3,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',5000.49,NULL,NULL,1,'2023-11-15 07:13:05','2023-11-18 06:51:50','2023-11-18 06:51:50'),(1359,7705,40720,1530,3,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',14999.49,NULL,NULL,1,'2023-11-15 07:13:50','2023-11-18 06:51:08','2023-11-18 06:51:08'),(1360,7705,40720,1530,3,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',6000.06,NULL,NULL,1,'2023-11-15 07:15:55','2023-11-18 06:50:35','2023-11-18 06:50:35'),(1361,7705,40720,1530,3,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',9999.49,NULL,NULL,1,'2023-11-15 07:18:03','2023-11-15 21:06:38','2023-11-15 21:06:38'),(1362,7705,40720,1530,3,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',30000.11,NULL,NULL,1,'2023-11-15 07:19:56','2023-11-15 21:12:22','2023-11-15 21:12:22'),(1363,7705,40720,1530,3,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',10000.09,NULL,NULL,1,'2023-11-15 07:21:02','2023-11-15 21:06:16','2023-11-15 21:06:16'),(1364,7705,40720,1530,3,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',21708.73,NULL,NULL,1,'2023-11-15 07:22:03','2023-11-15 21:05:52','2023-11-15 21:05:52'),(1365,7705,40720,1530,3,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',4999.96,NULL,NULL,1,'2023-11-15 07:35:08','2023-11-15 21:05:31','2023-11-15 21:05:31'),(1366,7705,40720,1530,3,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',40803.49,NULL,NULL,1,'2023-11-15 07:36:43','2023-11-15 21:11:45','2023-11-15 21:11:45'),(1367,7705,40720,1530,3,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',17499.86,NULL,NULL,1,'2023-11-15 07:37:31','2023-11-15 21:10:11','2023-11-15 21:10:11'),(1368,7705,40720,1530,3,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',33400.61,NULL,NULL,1,'2023-11-15 07:38:16','2023-11-15 21:11:24','2023-11-15 21:11:24'),(1369,7705,40720,1530,3,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',18999.64,NULL,NULL,1,'2023-11-15 07:39:00','2023-11-15 21:09:54','2023-11-15 21:09:54'),(1370,7705,40720,1530,3,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',21092.14,NULL,NULL,1,'2023-11-15 07:40:06','2023-11-15 21:09:30','2023-11-15 21:09:30');
INSERT INTO `balance_libro` VALUES (1371,7705,40720,1530,3,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',24702.81,NULL,NULL,1,'2023-11-15 07:40:52','2023-11-15 21:05:05','2023-11-15 21:05:05'),(1372,7705,40720,1530,3,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-10','2023-09-10',4999.95,NULL,NULL,1,'2023-11-15 07:43:36','2023-11-15 21:09:09','2023-11-15 21:09:09'),(1373,7705,40720,1530,3,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-10','2023-09-10',6000.30,NULL,NULL,1,'2023-11-15 07:44:33','2023-11-15 21:04:39','2023-11-15 21:04:39'),(1374,7705,40720,1530,3,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-10','2023-09-10',4999.95,NULL,NULL,1,'2023-11-15 07:46:15','2023-11-15 21:04:16','2023-11-15 21:04:16'),(1375,7705,40720,1530,3,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-10','2023-09-10',28103.34,NULL,NULL,1,'2023-11-15 07:47:40','2023-11-15 21:03:55','2023-11-15 21:03:55'),(1376,7705,40720,1530,3,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',9999.94,NULL,NULL,1,'2023-11-15 07:48:31','2023-11-15 21:08:19','2023-11-15 21:08:19'),(1377,7705,40720,1530,3,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',1999.98,NULL,NULL,1,'2023-11-15 07:51:33','2023-11-15 21:07:56','2023-11-15 21:07:56'),(1378,7705,40720,1530,3,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',40503.48,NULL,NULL,1,'2023-11-15 07:52:54','2023-11-15 21:07:31','2023-11-15 21:07:31'),(1379,7705,40720,1530,3,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',22000.53,NULL,NULL,1,'2023-11-15 07:55:41','2023-11-15 21:02:57','2023-11-15 21:02:57'),(1380,7705,40720,1530,3,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',40703.47,NULL,NULL,1,'2023-11-15 07:58:06','2023-11-15 21:02:24','2023-11-15 21:02:24'),(1381,7705,40720,1530,3,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',9999.94,NULL,NULL,1,'2023-11-15 07:58:44','2023-11-15 21:01:16','2023-11-15 21:01:16'),(1382,7705,40720,1530,3,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',7000.71,NULL,NULL,1,'2023-11-15 08:01:05','2023-11-15 08:11:34','2023-11-15 08:11:34'),(1383,7705,40720,1530,3,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',41504.39,NULL,NULL,1,'2023-11-15 08:02:10','2023-11-15 08:11:11','2023-11-15 08:11:11'),(1384,7705,40720,1530,3,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',20000.19,NULL,NULL,1,'2023-11-15 08:03:37','2023-11-15 08:10:27','2023-11-15 08:10:27'),(1385,7705,40720,1530,3,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',25999.48,NULL,NULL,1,'2023-11-15 08:04:43','2023-11-15 08:09:28','2023-11-15 08:09:28'),(1386,7705,40720,1530,3,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',4999.95,NULL,NULL,1,'2023-11-15 08:06:40','2023-11-15 08:06:40',NULL),(1387,7705,40720,1530,3,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',9999.94,NULL,NULL,1,'2023-11-15 08:07:06','2023-11-15 08:07:06',NULL),(1388,7705,40720,1530,3,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',26100.46,NULL,NULL,1,'2023-11-15 08:07:30','2023-11-15 08:07:30',NULL),(1389,7705,40720,1530,3,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',50805.63,NULL,NULL,1,'2023-11-15 08:08:09','2023-11-15 08:08:09',NULL);
INSERT INTO `balance_libro` VALUES (1390,7705,40720,1530,3,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',19999.42,NULL,NULL,1,'2023-11-15 08:08:36','2023-11-15 08:08:36',NULL),(1391,7705,40720,1530,3,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',25999.48,NULL,NULL,1,'2023-11-15 08:09:28','2023-11-15 08:09:28',NULL),(1392,7705,40720,1530,3,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',20000.19,NULL,NULL,1,'2023-11-15 08:10:27','2023-11-15 08:10:27',NULL),(1393,7705,40720,1530,3,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',41504.39,NULL,NULL,1,'2023-11-15 08:11:11','2023-11-15 08:11:11',NULL),(1394,7705,40720,1530,3,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',7000.71,NULL,NULL,1,'2023-11-15 08:11:34','2023-11-15 08:11:34',NULL),(1395,7705,40720,1530,3,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',9999.94,NULL,NULL,1,'2023-11-15 21:01:16','2023-11-15 21:01:16',NULL),(1396,7705,40720,1530,3,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',40703.47,NULL,NULL,1,'2023-11-15 21:02:24','2023-11-15 21:02:24',NULL),(1397,7705,40720,1530,3,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',22000.53,NULL,NULL,1,'2023-11-15 21:02:57','2023-11-15 21:02:57',NULL),(1398,7705,40720,1530,3,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-10','2023-09-10',28103.34,NULL,NULL,1,'2023-11-15 21:03:55','2023-11-15 21:03:55',NULL),(1399,7705,40720,1530,3,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-10','2023-09-10',4999.95,NULL,NULL,1,'2023-11-15 21:04:16','2023-11-15 21:04:16',NULL),(1400,7705,40720,1530,3,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-10','2023-09-10',6000.30,NULL,NULL,1,'2023-11-15 21:04:39','2023-11-15 21:04:39',NULL),(1401,7705,40720,1530,3,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',24702.81,NULL,NULL,1,'2023-11-15 21:05:05','2023-11-15 21:05:05',NULL),(1402,7705,40720,1530,3,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',4999.96,NULL,NULL,1,'2023-11-15 21:05:31','2023-11-15 21:05:31',NULL),(1403,7705,40720,1530,3,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',21708.73,NULL,NULL,1,'2023-11-15 21:05:52','2023-11-15 21:05:52',NULL),(1404,7705,40720,1530,3,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',10000.09,NULL,NULL,1,'2023-11-15 21:06:16','2023-11-15 21:06:16',NULL),(1405,7705,40720,1530,3,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',9999.49,NULL,NULL,1,'2023-11-15 21:06:38','2023-11-15 21:06:38',NULL),(1406,7705,40720,1530,3,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',40503.48,NULL,NULL,1,'2023-11-15 21:07:31','2023-11-15 21:07:31',NULL),(1407,7705,40720,1530,3,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',1999.98,NULL,NULL,1,'2023-11-15 21:07:56','2023-11-15 21:07:56',NULL),(1408,7705,40720,1530,3,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',9999.94,NULL,NULL,1,'2023-11-15 21:08:19','2023-11-15 21:08:19',NULL),(1409,7705,40720,1530,3,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-10','2023-09-10',4999.95,NULL,NULL,1,'2023-11-15 21:09:09','2023-11-15 21:09:09',NULL),(1410,7705,40720,1530,3,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',21092.14,NULL,NULL,1,'2023-11-15 21:09:30','2023-11-15 21:09:30',NULL);
INSERT INTO `balance_libro` VALUES (1411,7705,40720,1530,3,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',18999.64,NULL,NULL,1,'2023-11-15 21:09:54','2023-11-15 21:09:54',NULL),(1412,7705,40720,1530,3,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',17499.86,NULL,NULL,1,'2023-11-15 21:10:11','2023-11-15 21:10:11',NULL),(1413,7705,40720,1530,3,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',33400.61,NULL,NULL,1,'2023-11-15 21:11:24','2023-11-15 21:11:24',NULL),(1414,7705,40720,1530,3,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-07','2023-09-07',40803.49,NULL,NULL,1,'2023-11-15 21:11:45','2023-11-15 21:11:45',NULL),(1415,7705,40720,1530,3,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',30000.11,NULL,NULL,1,'2023-11-15 21:12:22','2023-11-15 21:12:22',NULL),(1416,7705,40720,1530,3,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',6000.06,NULL,NULL,1,'2023-11-18 06:50:35','2023-11-18 06:50:35',NULL),(1417,7705,40720,1530,3,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',14999.49,NULL,NULL,1,'2023-11-18 06:51:08','2023-11-18 06:51:08',NULL),(1418,7705,40720,1530,3,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',5000.49,NULL,NULL,1,'2023-11-18 06:51:50','2023-11-18 06:51:50',NULL),(1419,7705,40720,1530,3,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',5999.95,NULL,NULL,1,'2023-11-18 06:52:40','2023-11-18 06:52:40',NULL),(1420,7705,40720,1530,3,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',13000.08,NULL,NULL,1,'2023-11-18 06:55:00','2023-11-18 06:55:00',NULL),(1421,7705,40720,1530,3,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',10001.01,NULL,NULL,1,'2023-11-18 07:26:41','2023-11-18 07:26:41',NULL),(1422,7705,40720,1530,3,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-17','2023-09-17',9001.74,NULL,NULL,1,'2023-11-18 07:27:31','2023-11-18 07:27:31',NULL),(1423,7705,40720,1530,3,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',3000.30,NULL,NULL,1,'2023-11-18 07:28:34','2023-11-18 07:28:34',NULL),(1424,7705,40720,1530,3,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',2499.52,NULL,NULL,1,'2023-11-18 07:29:34','2023-11-18 07:29:34',NULL),(1425,7705,40720,1530,3,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',3000.14,NULL,NULL,1,'2023-11-18 07:30:13','2023-11-18 07:30:13',NULL),(1426,7705,40720,1530,3,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',47205.05,NULL,NULL,1,'2023-11-18 07:32:11','2023-11-18 07:32:11',NULL),(1427,7705,40720,1530,3,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',15000.72,NULL,NULL,1,'2023-11-18 07:33:24','2023-11-18 07:33:24',NULL),(1428,7705,40720,1530,3,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',2000.49,NULL,NULL,1,'2023-11-18 07:34:57','2023-11-18 07:34:57',NULL),(1429,7705,40720,1530,3,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',25000.01,NULL,NULL,1,'2023-11-18 07:36:07','2023-11-18 07:36:07',NULL),(1430,7705,40720,1530,3,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',4000.41,NULL,NULL,1,'2023-11-18 07:40:02','2023-11-18 07:40:02',NULL),(1431,7705,40720,1530,3,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',3000.18,NULL,NULL,1,'2023-11-18 07:41:34','2023-11-18 07:41:34',NULL);
INSERT INTO `balance_libro` VALUES (1432,7705,40720,1530,3,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',23102.00,NULL,NULL,1,'2023-11-18 07:48:20','2023-11-18 07:48:20',NULL),(1433,7705,40720,1530,3,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',2000.06,NULL,NULL,1,'2023-11-18 07:50:45','2023-11-18 07:50:45',NULL),(1434,7705,40720,1530,3,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',20000.51,NULL,NULL,1,'2023-11-18 07:51:59','2023-11-18 07:51:59',NULL),(1435,7705,40720,1530,3,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',9999.99,NULL,NULL,1,'2023-11-18 07:52:38','2023-11-18 07:52:38',NULL),(1436,7705,40720,1530,3,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',19600.71,NULL,NULL,1,'2023-11-18 07:53:27','2023-11-18 07:53:27',NULL),(1437,7705,40720,1530,3,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',56801.36,NULL,NULL,1,'2023-11-18 07:56:55','2023-11-18 07:56:55',NULL),(1438,7705,40720,1530,3,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',3000.30,NULL,NULL,1,'2023-11-18 08:04:40','2023-11-18 08:04:40',NULL),(1439,7705,40720,1530,3,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',22000.58,NULL,NULL,1,'2023-11-18 08:05:40','2023-11-18 08:05:40',NULL),(1440,7705,40720,1530,3,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-24','2023-09-24',35099.97,NULL,NULL,1,'2023-11-18 08:07:22','2023-11-18 08:07:22',NULL),(1441,7705,40720,1530,3,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-24','2023-09-24',10000.09,NULL,NULL,1,'2023-11-18 08:08:21','2023-11-18 08:08:21',NULL),(1442,7705,40720,1530,3,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-24','2023-09-24',10000.09,NULL,NULL,1,'2023-11-18 08:09:13','2023-11-18 08:09:13',NULL),(1443,7705,40720,1530,3,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',42592.00,NULL,NULL,1,'2023-11-18 10:33:18','2023-11-18 10:33:18',NULL),(1444,7705,40720,1530,3,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',4999.96,NULL,NULL,1,'2023-11-18 10:34:41','2023-11-18 10:34:41',NULL),(1445,7705,40720,1530,3,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',10000.19,NULL,NULL,1,'2023-11-18 10:36:11','2023-11-18 10:36:11',NULL),(1446,7705,40720,1530,3,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',15000.74,NULL,NULL,1,'2023-11-18 10:37:27','2023-11-18 10:37:27',NULL),(1447,7705,40720,1530,3,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',15000.74,NULL,NULL,1,'2023-11-18 10:38:20','2023-11-18 10:38:20',NULL),(1448,7705,40720,1530,3,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',31400.76,NULL,NULL,1,'2023-11-18 10:39:44','2023-11-18 10:39:44',NULL),(1449,7705,40720,1530,3,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',27607.13,NULL,NULL,1,'2023-11-18 10:41:44','2023-11-18 10:41:44',NULL),(1450,7705,40720,1530,3,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',2999.87,NULL,NULL,1,'2023-11-18 10:43:05','2023-11-18 10:43:05',NULL),(1451,7705,40720,1530,3,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',4999.95,NULL,NULL,1,'2023-11-18 10:44:18','2023-11-18 10:44:18',NULL),(1452,7705,40720,1530,3,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',33703.12,NULL,NULL,1,'2023-11-18 10:47:34','2023-11-18 10:47:34',NULL);
INSERT INTO `balance_libro` VALUES (1453,7705,40720,1530,3,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',48203.21,NULL,NULL,1,'2023-11-18 10:51:36','2023-11-18 10:51:36',NULL),(1454,7705,40720,1530,3,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-28','2023-09-28',51566.03,NULL,NULL,1,'2023-11-18 10:52:24','2023-11-18 10:52:24',NULL),(1455,7705,40720,1530,3,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',42002.74,NULL,NULL,1,'2023-11-18 10:53:22','2023-11-18 10:53:22',NULL),(1456,7705,40720,1530,3,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',21619.01,NULL,NULL,1,'2023-11-18 10:54:15','2023-11-18 10:54:15',NULL),(1457,7705,40720,1530,3,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',86000.00,NULL,NULL,1,'2023-11-18 10:55:53','2023-11-18 10:55:53',NULL),(1458,7705,40720,1530,3,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',9500.26,NULL,NULL,1,'2023-11-18 10:56:51','2023-11-18 10:56:51',NULL),(1459,7705,40720,1530,3,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',3400.10,NULL,NULL,1,'2023-11-18 10:58:05','2023-11-18 10:58:05',NULL),(1460,7705,40720,1530,3,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',7000.00,NULL,NULL,1,'2023-11-18 10:59:08','2023-11-18 10:59:08',NULL),(1461,7705,40720,1530,3,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',2500.01,NULL,NULL,1,'2023-11-18 11:00:10','2023-11-18 11:00:10',NULL),(1462,7705,40720,1530,3,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',59588.53,NULL,NULL,1,'2023-11-18 11:04:47','2023-11-18 11:04:47',NULL),(1463,7705,40720,1530,3,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',7000.00,NULL,NULL,1,'2023-11-18 11:05:44','2023-11-18 11:05:44',NULL),(1464,7705,40720,1530,3,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',13300.01,NULL,NULL,1,'2023-11-18 11:07:56','2023-11-18 11:07:56',NULL),(1465,7705,40720,1530,3,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',48070.00,NULL,NULL,1,'2023-11-18 11:09:08','2023-11-18 11:09:08',NULL),(1466,7705,40720,1530,3,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',13000.00,NULL,NULL,1,'2023-11-18 11:10:44','2023-11-18 11:10:44',NULL),(1467,7705,40720,1530,3,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',10568.88,NULL,NULL,1,'2023-11-18 11:12:38','2023-11-18 11:12:38',NULL),(1468,7705,40720,1530,3,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',8165.01,NULL,NULL,1,'2023-11-18 11:13:39','2023-11-18 11:13:39',NULL),(1469,7705,40720,1530,3,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',3400.10,NULL,NULL,1,'2023-11-18 11:20:54','2023-11-18 11:20:54',NULL),(1470,7705,40720,1530,3,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-18','2023-09-18',7271.10,NULL,NULL,1,'2023-11-18 16:54:39','2023-11-18 16:54:39',NULL),(1471,7705,40720,1530,3,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',32917.29,NULL,NULL,1,'2023-11-18 16:58:20','2023-11-18 16:58:20',NULL),(1472,7705,40720,1530,3,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',8000.00,NULL,NULL,1,'2023-11-18 17:04:45','2023-11-18 17:04:45',NULL),(1473,7705,40720,1530,3,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',3200.00,NULL,NULL,1,'2023-11-18 17:07:28','2023-11-18 17:07:28',NULL);
INSERT INTO `balance_libro` VALUES (1474,7705,40720,1531,3,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',9999.90,NULL,NULL,1,'2023-12-19 20:21:12','2023-12-19 20:21:12',NULL),(1475,7705,40720,1531,3,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',7999.35,NULL,NULL,1,'2023-12-19 20:22:19','2023-12-19 20:22:19',NULL),(1476,7705,40720,1531,3,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',13999.53,NULL,NULL,1,'2023-12-19 20:25:14','2023-12-19 20:25:14',NULL),(1477,7705,40720,1531,3,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',2000.04,NULL,NULL,1,'2023-12-19 20:26:16','2023-12-19 20:26:16',NULL),(1478,7705,40720,1531,3,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',7691.87,NULL,NULL,1,'2023-12-19 20:28:58','2023-12-19 20:28:58',NULL),(1479,7705,40720,1531,3,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',4000.00,NULL,NULL,1,'2023-12-19 20:40:06','2023-12-19 20:40:06',NULL),(1480,7705,40720,1531,3,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',41544.35,NULL,NULL,1,'2023-12-19 20:41:48','2023-12-19 20:41:48',NULL),(1481,7705,40720,1531,3,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',5999.99,NULL,NULL,1,'2023-12-20 19:49:14','2023-12-20 19:49:14',NULL),(1482,7705,40720,1531,3,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',5000.51,NULL,NULL,1,'2023-12-20 20:15:14','2023-12-20 20:15:14',NULL),(1483,7705,40720,1531,3,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',4000.00,NULL,NULL,1,'2023-12-20 21:02:16','2023-12-20 21:02:16',NULL),(1484,7705,40720,1531,3,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',13000.00,NULL,NULL,1,'2023-12-20 21:04:02','2023-12-20 21:04:02',NULL),(1485,7705,40720,1531,3,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',379904.21,NULL,NULL,1,'2023-12-20 21:05:16','2023-12-20 21:05:16',NULL),(1486,7705,40720,1531,3,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',9999.99,NULL,NULL,1,'2023-12-20 21:07:01','2023-12-20 21:07:01',NULL),(1487,7705,40720,1531,3,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',50317.57,NULL,NULL,1,'2023-12-20 21:07:59','2023-12-20 21:07:59',NULL),(1488,7705,40720,1531,3,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',61119.60,NULL,NULL,1,'2023-12-20 21:08:42','2023-12-20 21:08:42',NULL),(1489,7705,40720,1531,3,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',63502.96,NULL,NULL,1,'2023-12-20 21:09:35','2023-12-20 21:09:35',NULL),(1490,7705,40720,1531,3,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-07','2023-10-07',51402.39,NULL,NULL,1,'2023-12-20 21:10:34','2023-12-20 21:10:34',NULL),(1491,7705,40720,1531,3,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-07','2023-10-07',47806.86,NULL,NULL,1,'2023-12-27 07:46:09','2023-12-27 07:46:09',NULL),(1492,7705,40720,1531,3,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-08','2023-10-08',17016.93,NULL,NULL,1,'2024-01-03 07:11:40','2024-01-03 07:11:40',NULL),(1493,7705,40720,1531,3,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',57903.02,NULL,NULL,1,'2024-01-03 07:12:57','2024-01-03 07:12:57',NULL),(1494,7705,40720,1531,3,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',8000.01,NULL,NULL,1,'2024-01-03 07:14:19','2024-01-03 07:14:19',NULL);
INSERT INTO `balance_libro` VALUES (1495,7705,40720,1531,3,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',27002.98,NULL,NULL,1,'2024-01-03 07:15:38','2024-01-03 07:15:38',NULL),(1496,7705,40720,1531,3,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',2000.02,NULL,NULL,1,'2024-01-03 07:16:44','2024-01-03 07:16:44',NULL),(1497,7705,40720,1531,3,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',9999.59,NULL,NULL,1,'2024-01-03 07:21:39','2024-01-03 07:21:39',NULL),(1498,7705,40720,1531,3,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',9999.89,NULL,NULL,1,'2024-01-03 07:22:21','2024-01-03 07:22:21',NULL),(1499,7705,40720,1531,3,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',21800.00,NULL,NULL,1,'2024-01-03 07:23:23','2024-01-03 07:23:23',NULL),(1500,7705,40720,1531,3,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',48352.76,NULL,NULL,1,'2024-01-03 07:24:17','2024-01-03 07:24:17',NULL),(1501,7705,40720,1531,3,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',5000.00,NULL,NULL,1,'2024-01-03 07:25:55','2024-01-03 07:25:55',NULL),(1502,7705,40720,1531,3,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',3400.10,NULL,NULL,1,'2024-01-03 07:27:00','2024-01-03 07:28:54','2024-01-03 07:28:54'),(1503,7705,40720,1531,3,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',3400.10,NULL,NULL,1,'2024-01-03 07:28:54','2024-01-03 07:28:54',NULL),(1504,7705,40720,1531,3,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',28802.96,NULL,NULL,1,'2024-01-03 07:30:41','2024-01-03 07:30:41',NULL),(1505,7705,40720,1531,3,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',7999.35,NULL,NULL,1,'2024-01-03 07:31:20','2024-01-03 07:31:20',NULL),(1506,7705,40720,1531,3,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',35554.60,NULL,NULL,1,'2024-01-03 07:32:11','2024-01-03 07:32:11',NULL),(1507,7705,40720,1531,3,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',1999.92,NULL,NULL,1,'2024-01-05 06:58:31','2024-01-05 06:58:31',NULL),(1508,7705,40720,1531,3,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-15','2023-10-15',1499.43,NULL,NULL,1,'2024-01-05 07:00:33','2024-01-05 07:00:33',NULL),(1509,7705,40720,1531,3,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-15','2023-10-15',17002.40,NULL,NULL,1,'2024-01-05 07:02:14','2024-01-05 07:02:14',NULL),(1510,7705,40720,1531,3,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-16','2023-10-16',38177.06,NULL,NULL,1,'2024-01-05 07:03:38','2024-01-05 07:03:38',NULL),(1511,7705,40720,1531,3,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-16','2023-10-16',16007.49,NULL,NULL,1,'2024-01-05 07:07:33','2024-01-05 07:07:33',NULL),(1512,7705,40720,1531,3,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-16','2023-10-16',6000.61,NULL,NULL,1,'2024-01-05 07:08:14','2024-01-05 07:08:14',NULL),(1513,7705,40720,1531,3,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',25907.65,NULL,NULL,1,'2024-01-05 07:09:31','2024-01-05 07:09:31',NULL),(1514,7705,40720,1531,3,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',25001.40,NULL,NULL,1,'2024-01-05 07:11:03','2024-01-05 07:11:03',NULL),(1515,7705,40720,1531,3,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',35503.30,NULL,NULL,1,'2024-01-05 07:12:10','2024-01-05 07:12:10',NULL);
INSERT INTO `balance_libro` VALUES (1516,7705,40720,1531,3,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',24000.15,NULL,NULL,1,'2024-01-05 07:13:39','2024-01-05 07:13:39',NULL),(1517,7705,40720,1531,3,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',17998.77,NULL,NULL,1,'2024-01-05 07:14:49','2024-01-05 07:14:49',NULL),(1518,7705,40720,1531,3,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',15000.72,NULL,NULL,1,'2024-01-05 07:15:54','2024-01-05 07:15:54',NULL),(1519,7705,40720,1531,3,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',33000.82,NULL,NULL,1,'2024-01-05 07:16:41','2024-01-05 07:16:41',NULL),(1520,7705,40720,1531,3,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',24001.83,NULL,NULL,1,'2024-01-05 07:19:08','2024-01-05 07:19:08',NULL),(1521,7705,40720,1531,3,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',48800.16,NULL,NULL,1,'2024-01-05 07:20:49','2024-01-05 07:20:49',NULL),(1522,7705,40720,1531,3,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',18400.80,NULL,NULL,1,'2024-01-05 07:22:58','2024-01-05 07:22:58',NULL),(1523,7705,40720,1531,3,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',30203.73,NULL,NULL,1,'2024-01-05 07:24:37','2024-01-05 07:24:37',NULL),(1524,7705,40720,1531,3,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',26250.88,NULL,NULL,1,'2024-01-05 07:25:32','2024-01-05 07:25:32',NULL),(1525,7705,40720,1531,3,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',9999.90,NULL,NULL,1,'2024-01-06 12:46:23','2024-01-06 12:46:23',NULL),(1526,7705,40720,1531,3,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',25001.11,NULL,NULL,1,'2024-01-06 13:21:25','2024-01-06 13:21:25',NULL),(1527,7705,40720,1531,3,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',17000.06,NULL,NULL,1,'2024-01-07 10:36:42','2024-01-07 10:36:42',NULL),(1528,7705,40720,1531,3,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',29259.48,NULL,NULL,1,'2024-01-07 10:37:53','2024-01-07 10:37:53',NULL),(1529,7705,40720,1531,3,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',7149.22,NULL,NULL,1,'2024-01-07 10:45:20','2024-01-07 10:45:20',NULL),(1530,7705,40720,1531,3,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',25702.14,NULL,NULL,1,'2024-01-07 10:46:36','2024-01-07 10:46:36',NULL),(1531,7705,40720,1531,3,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',48205.05,NULL,NULL,1,'2024-01-07 10:48:45','2024-01-07 10:48:45',NULL),(1532,7705,40720,1531,3,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',33000.10,NULL,NULL,1,'2024-01-07 10:49:43','2024-01-07 10:49:43',NULL),(1533,7705,40720,1531,3,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',50000.00,NULL,NULL,1,'2024-01-07 10:51:13','2024-01-07 10:51:13',NULL),(1534,7705,40720,1531,3,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',19998.44,NULL,NULL,1,'2024-01-07 10:52:31','2024-01-07 10:52:31',NULL),(1535,7705,40720,1531,3,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',8501.16,NULL,NULL,1,'2024-01-07 10:53:27','2024-01-07 10:53:27',NULL),(1536,7705,40720,1531,3,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',3101.64,NULL,NULL,1,'2024-01-07 10:55:39','2024-01-07 10:55:39',NULL);
INSERT INTO `balance_libro` VALUES (1537,7705,40720,1531,3,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-28','2023-10-28',23101.47,NULL,NULL,1,'2024-01-07 10:57:07','2024-01-07 10:57:07',NULL),(1538,7705,40720,1531,3,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-30','2023-10-30',6002.49,NULL,NULL,1,'2024-01-07 10:58:07','2024-01-07 10:58:07',NULL),(1539,7705,40720,1531,3,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',34999.76,NULL,NULL,1,'2024-01-07 10:59:11','2024-01-07 10:59:11',NULL),(1540,7705,40720,1531,3,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',12000.00,NULL,NULL,1,'2024-01-07 11:00:10','2024-01-07 11:00:10',NULL),(1541,7705,40720,1531,3,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',7000.00,NULL,NULL,1,'2024-01-07 11:02:35','2024-01-07 11:02:35',NULL),(1542,7705,40720,1531,3,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',10350.00,NULL,NULL,1,'2024-01-07 11:04:03','2024-01-07 11:04:03',NULL),(1543,7705,40720,1531,3,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-28','2023-10-28',22000.00,NULL,NULL,1,'2024-01-07 11:05:53','2024-01-07 11:05:53',NULL),(1544,7705,40720,1531,3,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',10548.56,NULL,NULL,1,'2024-01-07 11:07:53','2024-01-07 11:07:53',NULL),(1545,7705,40720,1532,3,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',10900.72,NULL,NULL,1,'2024-01-17 19:31:43','2024-01-17 19:31:43',NULL),(1546,7705,40720,1532,3,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',69380.78,NULL,NULL,1,'2024-01-17 21:25:12','2024-01-17 21:25:12',NULL),(1547,7705,40720,1532,3,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',24200.41,NULL,NULL,1,'2024-01-17 21:31:44','2024-01-17 21:31:44',NULL),(1548,7705,40720,1532,3,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',24998.53,NULL,NULL,1,'2024-01-17 21:34:38','2024-01-17 21:34:38',NULL),(1549,7705,40745,3045,3,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',7999.94,NULL,NULL,1,'2024-01-20 11:11:33','2024-01-20 11:11:33',NULL),(1550,7705,40745,3045,3,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',120000.99,NULL,NULL,1,'2024-01-20 11:16:36','2024-01-20 11:16:36',NULL),(1551,7705,40745,3045,3,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',30000.33,NULL,NULL,1,'2024-01-20 11:19:10','2024-01-20 11:19:10',NULL),(1552,7705,40745,3045,3,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',8000.17,NULL,NULL,1,'2024-01-20 11:20:40','2024-01-20 11:20:40',NULL),(1553,7705,40745,3045,3,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',7997.55,NULL,NULL,1,'2024-01-20 11:22:08','2024-01-20 11:22:08',NULL),(1554,7705,40745,3045,3,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',25509.99,NULL,NULL,1,'2024-01-20 11:29:04','2024-01-20 11:29:04',NULL),(1555,7705,40745,3045,3,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',7859.99,NULL,NULL,1,'2024-01-20 11:30:10','2024-01-20 11:30:10',NULL),(1556,7705,40720,1532,3,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',4000.06,NULL,NULL,1,'2024-02-13 10:35:43','2024-02-13 10:35:43',NULL),(1557,7705,40720,1532,3,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',14400.36,NULL,NULL,1,'2024-02-13 10:48:01','2024-02-13 10:48:01',NULL);
INSERT INTO `balance_libro` VALUES (1558,7705,40720,1532,3,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',13000.39,NULL,NULL,1,'2024-02-13 11:01:37','2024-02-13 11:01:37',NULL),(1559,7705,40720,1532,3,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',9002.45,NULL,NULL,1,'2024-02-13 11:02:39','2024-02-13 11:02:39',NULL),(1560,7705,40720,1532,3,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',11131.12,NULL,NULL,1,'2024-02-13 11:03:53','2024-02-13 11:03:53',NULL),(1561,7705,40720,1532,3,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',38463.39,NULL,NULL,1,'2024-02-13 11:04:57','2024-02-13 11:04:57',NULL),(1562,7705,40720,1532,3,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',10000.08,NULL,NULL,1,'2024-02-13 11:27:20','2024-02-13 11:27:20',NULL),(1563,7705,40720,1532,3,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',32000.12,NULL,NULL,1,'2024-02-13 11:30:08','2024-02-13 11:30:08',NULL),(1564,7705,40720,1532,3,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',5001.41,NULL,NULL,1,'2024-02-13 11:31:24','2024-02-13 11:31:24',NULL),(1565,7705,40720,1532,3,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',15000.14,NULL,NULL,1,'2024-02-13 11:32:48','2024-02-13 11:32:48',NULL),(1566,7705,40720,1532,3,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-10','2023-11-10',17998.87,NULL,NULL,1,'2024-02-13 11:33:46','2024-02-13 11:33:46',NULL),(1567,7705,40720,1532,3,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',17999.61,NULL,NULL,1,'2024-02-13 11:34:46','2024-02-13 11:34:46',NULL),(1568,7705,40720,1532,3,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',29201.14,NULL,NULL,1,'2024-02-13 11:35:25','2024-02-13 11:35:25',NULL),(1569,7705,40720,1532,3,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',64002.46,NULL,NULL,1,'2024-02-13 11:36:11','2024-02-13 11:36:11',NULL),(1570,7705,40720,1532,3,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',4000.47,NULL,NULL,1,'2024-02-13 11:37:03','2024-02-13 11:37:03',NULL),(1571,7705,40720,1532,3,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',9303.02,NULL,NULL,1,'2024-02-13 11:37:56','2024-02-13 11:37:56',NULL),(1572,7705,40720,1532,3,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',26508.28,NULL,NULL,1,'2024-02-13 11:38:56','2024-02-13 11:38:56',NULL),(1573,7705,40720,1532,3,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',19999.11,NULL,NULL,1,'2024-02-13 11:39:38','2024-02-13 11:39:38',NULL),(1574,7705,40720,1532,3,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',9998.56,NULL,NULL,1,'2024-02-13 11:40:15','2024-02-13 11:40:15',NULL),(1575,7705,40720,1532,3,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',10000.82,NULL,NULL,1,'2024-02-13 11:41:23','2024-02-13 11:41:23',NULL),(1576,7705,40720,1532,3,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',33039.86,NULL,NULL,1,'2024-02-13 11:42:13','2024-02-13 11:42:13',NULL),(1577,7705,40720,1532,3,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',17000.08,NULL,NULL,1,'2024-02-13 11:42:51','2024-02-13 11:42:51',NULL),(1578,7705,40720,1532,3,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',12206.69,NULL,NULL,1,'2024-02-13 11:43:36','2024-02-13 11:43:36',NULL);
INSERT INTO `balance_libro` VALUES (1579,7705,40720,1532,3,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',4999.77,NULL,NULL,1,'2024-02-13 11:44:29','2024-02-13 11:44:29',NULL),(1580,7705,40720,1532,3,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',51205.98,NULL,NULL,1,'2024-02-13 11:45:11','2024-02-13 11:45:11',NULL),(1581,7705,40720,1532,3,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',45100.97,NULL,NULL,1,'2024-02-13 11:45:59','2024-02-13 11:45:59',NULL),(1582,7705,40720,1532,3,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',29998.72,NULL,NULL,1,'2024-02-13 11:46:45','2024-02-13 11:46:45',NULL),(1583,7705,40720,1532,3,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',23600.49,NULL,NULL,1,'2024-02-13 11:47:34','2024-02-13 11:47:34',NULL),(1584,7705,40720,1532,3,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',14250.14,NULL,NULL,1,'2024-02-13 11:48:22','2024-02-13 11:48:22',NULL),(1585,7705,40720,1532,3,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',59417.39,NULL,NULL,1,'2024-02-13 11:49:03','2024-02-13 11:49:03',NULL),(1586,7705,40720,1532,3,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',5004.71,NULL,NULL,1,'2024-02-13 11:50:28','2024-02-13 11:50:28',NULL),(1587,7705,40720,1532,3,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',19999.14,NULL,NULL,1,'2024-02-13 11:51:40','2024-02-13 11:51:40',NULL),(1588,7705,40720,1532,3,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',19999.14,NULL,NULL,1,'2024-02-13 11:53:07','2024-02-13 11:53:07',NULL),(1589,7705,40720,1532,3,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',6000.07,NULL,NULL,1,'2024-02-13 11:54:36','2024-02-13 11:54:36',NULL),(1590,7705,40720,1532,3,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',4000.47,NULL,NULL,1,'2024-02-13 11:55:28','2024-02-13 11:55:28',NULL),(1591,7705,40720,1532,3,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',5500.00,NULL,NULL,1,'2024-02-13 11:56:20','2024-02-13 11:56:20',NULL),(1592,7705,40720,1532,3,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',24000.99,NULL,NULL,1,'2024-02-13 11:57:30','2024-02-13 11:57:30',NULL),(1593,7705,40720,1532,3,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',4999.77,NULL,NULL,1,'2024-02-13 11:58:10','2024-02-13 11:58:10',NULL),(1594,7705,40720,1532,3,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',6308.19,NULL,NULL,1,'2024-02-13 11:59:06','2024-02-13 11:59:06',NULL),(1595,7705,40720,1532,3,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-19','2023-11-19',8000.01,NULL,NULL,1,'2024-02-13 12:00:00','2024-02-13 12:00:00',NULL),(1596,7705,40720,1532,3,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',4000.47,NULL,NULL,1,'2024-02-13 12:01:40','2024-02-13 12:01:40',NULL),(1597,7705,40720,1532,3,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-20','2023-11-20',42501.90,NULL,NULL,1,'2024-02-13 12:02:28','2024-02-13 12:02:28',NULL),(1598,7705,40720,1532,3,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',24420.46,NULL,NULL,1,'2024-02-13 12:03:46','2024-02-13 12:03:46',NULL),(1599,7705,40720,1532,3,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',4999.77,NULL,NULL,1,'2024-02-13 12:05:53','2024-02-13 12:05:53',NULL);
INSERT INTO `balance_libro` VALUES (1600,7705,40720,1532,3,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',42408.68,NULL,NULL,1,'2024-02-13 12:06:33','2024-02-13 12:06:33',NULL),(1601,7705,40720,1532,3,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',44800.85,NULL,NULL,1,'2024-02-13 12:07:19','2024-02-13 12:07:19',NULL),(1602,7705,40720,1532,3,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',4000.47,NULL,NULL,1,'2024-02-13 12:07:52','2024-02-13 12:07:52',NULL),(1603,7705,40720,1532,3,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',24000.07,NULL,NULL,1,'2024-02-13 12:08:42','2024-02-13 12:08:42',NULL),(1604,7705,40720,1532,3,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',4000.47,NULL,NULL,1,'2024-02-13 12:09:29','2024-02-13 12:09:29',NULL),(1605,7705,40720,1532,3,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',22001.58,NULL,NULL,1,'2024-02-13 12:10:24','2024-02-13 12:10:24',NULL),(1606,7705,40720,1532,3,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',3999.98,NULL,NULL,1,'2024-02-13 12:12:09','2024-02-13 12:12:09',NULL),(1607,7705,40720,1532,3,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',52402.64,NULL,NULL,1,'2024-02-13 12:13:56','2024-02-13 12:13:56',NULL),(1608,7705,40720,1532,3,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',43501.76,NULL,NULL,1,'2024-02-13 12:14:42','2024-02-13 12:14:42',NULL),(1609,7705,40720,1532,3,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',1999.98,NULL,NULL,1,'2024-02-13 12:16:00','2024-02-13 12:16:00',NULL),(1610,7705,40720,1532,3,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',4000.13,NULL,NULL,1,'2024-02-13 12:19:03','2024-02-13 12:19:03',NULL),(1611,7705,40720,1532,3,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',7000.63,NULL,NULL,1,'2024-02-13 12:20:10','2024-02-13 12:20:10',NULL),(1612,7705,40720,1532,3,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',37624.12,NULL,NULL,1,'2024-02-13 12:20:55','2024-02-13 12:20:55',NULL),(1613,7705,40720,1532,3,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',22001.68,NULL,NULL,1,'2024-02-13 12:24:02','2024-02-13 12:24:02',NULL),(1614,7705,40720,1532,3,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',3000.18,NULL,NULL,1,'2024-02-13 12:25:03','2024-02-13 12:25:03',NULL),(1615,7705,40720,1532,3,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',6000.24,NULL,NULL,1,'2024-02-13 12:26:05','2024-02-13 12:26:05',NULL),(1616,7705,40720,1532,3,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',28061.36,NULL,NULL,1,'2024-02-13 12:26:46','2024-02-13 12:26:46',NULL),(1617,7705,40720,1532,3,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',24999.23,NULL,NULL,1,'2024-02-13 12:27:29','2024-02-13 12:27:29',NULL),(1618,7705,40720,1532,3,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',5000.90,NULL,NULL,1,'2024-02-13 12:28:09','2024-02-13 12:28:09',NULL),(1619,7705,40720,1532,3,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',7000.63,NULL,NULL,1,'2024-02-13 12:29:03','2024-02-13 12:29:03',NULL),(1620,7705,40720,1532,3,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',4000.01,NULL,NULL,1,'2024-02-13 12:31:45','2024-02-13 12:31:45',NULL);
INSERT INTO `balance_libro` VALUES (1621,7705,40720,1532,3,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',3000.02,NULL,NULL,1,'2024-02-13 12:33:26','2024-02-13 12:33:26',NULL),(1622,7705,40720,1532,3,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',45400.75,NULL,NULL,1,'2024-02-13 12:36:05','2024-02-13 12:36:05',NULL),(1623,7705,40720,1532,3,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',56002.04,NULL,NULL,1,'2024-02-13 12:36:53','2024-02-13 12:36:53',NULL),(1624,7705,40720,1532,3,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',3999.45,NULL,NULL,1,'2024-02-13 12:40:08','2024-02-13 12:40:08',NULL),(1625,7705,40720,1532,3,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',4000.15,NULL,NULL,1,'2024-02-13 12:40:57','2024-02-13 12:40:57',NULL),(1626,7705,40720,1532,3,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',15186.92,NULL,NULL,1,'2024-02-13 12:41:52','2024-02-13 12:41:52',NULL),(1627,7705,40720,1532,3,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',4000.01,NULL,NULL,1,'2024-02-13 12:42:53','2024-02-13 12:42:53',NULL),(1628,7705,40720,1532,3,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',10000.00,NULL,NULL,1,'2024-02-13 12:44:53','2024-02-13 12:44:53',NULL),(1629,7705,40720,1532,3,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',7000.00,NULL,NULL,1,'2024-02-13 12:45:39','2024-02-13 12:45:39',NULL),(1630,7705,40720,1532,3,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',6100.00,NULL,NULL,1,'2024-02-13 12:46:17','2024-02-13 12:46:17',NULL),(1631,7705,40720,1532,3,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',10000.00,NULL,NULL,1,'2024-02-13 12:47:07','2024-02-13 12:47:07',NULL),(1632,7705,40720,1532,3,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-15','2023-11-15',20800.09,NULL,NULL,1,'2024-02-13 12:47:52','2024-02-13 12:47:52',NULL),(1633,7705,40720,1532,3,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',406231.19,NULL,NULL,1,'2024-02-13 12:49:22','2024-02-13 12:49:22',NULL),(1634,7705,40720,1532,3,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',3500.01,NULL,NULL,1,'2024-02-13 12:50:34','2024-02-13 12:50:34',NULL),(1635,7705,40720,1532,3,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',5961.07,NULL,NULL,1,'2024-02-13 12:51:21','2024-02-13 12:51:21',NULL),(1636,7705,40720,1532,3,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',6100.02,NULL,NULL,1,'2024-02-13 12:52:06','2024-02-13 12:52:06',NULL),(1637,7705,40720,1532,3,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',66109.00,NULL,NULL,1,'2024-02-13 14:07:31','2024-02-13 14:07:31',NULL),(1638,7705,40720,1533,3,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',66425.66,NULL,NULL,1,'2024-02-13 16:35:50','2024-02-13 16:35:50',NULL),(1639,7705,40720,1533,3,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',31503.65,NULL,NULL,1,'2024-02-13 16:38:41','2024-02-13 16:38:41',NULL),(1640,7705,40720,1533,3,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',47502.23,NULL,NULL,1,'2024-02-13 16:39:27','2024-02-13 16:39:27',NULL),(1641,7705,40720,1533,3,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',3999.98,NULL,NULL,1,'2024-02-13 16:40:19','2024-02-13 16:40:19',NULL);
INSERT INTO `balance_libro` VALUES (1642,7705,40720,1533,3,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',40000.02,NULL,NULL,1,'2024-02-13 16:41:21','2024-02-13 16:41:21',NULL),(1643,7705,40720,1533,3,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',3999.88,NULL,NULL,1,'2024-02-13 16:43:58','2024-02-13 16:43:58',NULL),(1644,7705,40720,1533,3,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',3999.98,NULL,NULL,1,'2024-02-13 16:45:00','2024-02-13 16:45:00',NULL),(1645,7705,40720,1533,3,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',34552.15,NULL,NULL,1,'2024-02-13 16:52:44','2024-02-13 16:52:44',NULL),(1646,7705,40720,1533,3,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-03','2023-12-03',4000.16,NULL,NULL,1,'2024-02-13 16:54:55','2024-02-13 16:54:55',NULL),(1647,7705,40720,1533,3,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-03','2023-12-03',3999.45,NULL,NULL,1,'2024-02-13 16:56:37','2024-02-13 16:56:37',NULL),(1648,7705,40720,1533,3,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-03','2023-12-03',4000.00,NULL,NULL,1,'2024-02-13 16:57:43','2024-02-13 16:57:43',NULL),(1649,7705,40720,1533,3,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-03','2023-12-03',4000.15,NULL,NULL,1,'2024-02-13 16:58:57','2024-02-13 16:58:57',NULL),(1650,7705,40720,1533,3,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-03','2023-12-03',10003.04,NULL,NULL,1,'2024-02-13 17:00:48','2024-02-13 17:00:48',NULL),(1651,7705,40720,1533,3,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',3999.98,NULL,NULL,1,'2024-02-13 17:02:51','2024-02-13 17:02:51',NULL),(1652,7705,40720,1533,3,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',40000.02,NULL,NULL,1,'2024-02-13 17:12:55','2024-02-13 17:12:55',NULL),(1653,7705,40720,1533,3,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',34600.02,NULL,NULL,1,'2024-02-13 17:40:28','2024-02-13 17:40:28',NULL),(1654,7705,40720,1533,3,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',20001.58,NULL,NULL,1,'2024-02-13 17:41:22','2024-02-13 17:41:22',NULL),(1655,7705,40720,1533,3,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',4000.16,NULL,NULL,1,'2024-02-13 17:43:15','2024-02-13 17:43:15',NULL),(1656,7705,40720,1533,3,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',66105.07,NULL,NULL,1,'2024-02-13 17:45:31','2024-02-13 17:45:31',NULL),(1657,7705,40720,1533,3,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',7999.95,NULL,NULL,1,'2024-02-13 17:46:50','2024-02-13 17:46:50',NULL),(1658,7705,40720,1533,3,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',35002.07,NULL,NULL,1,'2024-02-13 17:49:07','2024-02-13 17:49:07',NULL),(1659,7705,40720,1533,3,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',59100.96,NULL,NULL,1,'2024-02-13 18:00:47','2024-02-13 18:00:47',NULL),(1660,7705,40720,1533,3,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',89105.38,NULL,NULL,1,'2024-02-13 18:02:25','2024-02-13 18:02:25',NULL),(1661,7705,40720,1533,3,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',35000.09,NULL,NULL,1,'2024-02-13 18:03:43','2024-02-13 18:03:43',NULL),(1662,7705,40720,1533,3,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',63066.84,NULL,NULL,1,'2024-02-13 18:04:31','2024-02-13 18:04:31',NULL);
INSERT INTO `balance_libro` VALUES (1663,7705,40720,1533,3,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',7999.95,NULL,NULL,1,'2024-02-13 18:46:18','2024-02-13 18:46:18',NULL),(1664,7705,40720,1533,3,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-08','2023-12-08',66606.55,NULL,NULL,1,'2024-02-13 19:23:29','2024-02-13 19:23:29',NULL),(1665,7705,40720,1533,3,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',59953.86,NULL,NULL,1,'2024-02-13 19:48:01','2024-02-13 19:48:01',NULL),(1666,7705,40720,1533,3,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-10','2023-12-10',44007.47,NULL,NULL,1,'2024-02-13 19:50:02','2024-02-13 19:50:02',NULL),(1667,7705,40720,1533,3,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',4999.59,NULL,NULL,1,'2024-02-13 19:51:11','2024-02-13 19:51:11',NULL),(1668,7705,40720,1533,3,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',4004.31,NULL,NULL,1,'2024-02-13 19:51:58','2024-02-13 19:51:58',NULL),(1669,7705,40720,1533,3,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',59800.98,NULL,NULL,1,'2024-02-13 19:52:50','2024-02-13 19:52:50',NULL),(1670,7705,40720,1533,3,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',6000.06,NULL,NULL,1,'2024-02-13 19:54:13','2024-02-13 19:54:13',NULL),(1671,7705,40720,1533,3,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',4999.54,NULL,NULL,1,'2024-02-13 19:55:03','2024-02-13 19:55:03',NULL),(1672,7705,40720,1533,3,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',20002.00,NULL,NULL,1,'2024-02-13 19:56:23','2024-02-13 19:56:23',NULL),(1673,7705,40720,1533,3,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',50002.19,NULL,NULL,1,'2024-02-13 19:57:08','2024-02-13 19:57:08',NULL),(1674,7705,40720,1533,3,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',51001.33,NULL,NULL,1,'2024-02-13 19:58:16','2024-02-13 19:58:16',NULL),(1675,7705,40720,1533,3,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',38011.09,NULL,NULL,1,'2024-02-13 19:59:17','2024-02-13 19:59:17',NULL),(1676,7705,40720,1533,3,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',4000.44,NULL,NULL,1,'2024-02-13 20:00:39','2024-02-13 20:00:39',NULL),(1677,7705,40720,1533,3,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',4998.95,NULL,NULL,1,'2024-02-13 20:01:27','2024-02-13 20:01:27',NULL),(1678,7705,40720,1533,3,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',44999.08,NULL,NULL,1,'2024-02-13 20:02:10','2024-02-13 20:02:10',NULL),(1679,7705,40720,1533,3,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',5000.17,NULL,NULL,1,'2024-02-13 20:03:20','2024-02-13 20:03:20',NULL),(1680,7705,40720,1533,3,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-17','2023-12-17',52693.84,NULL,NULL,1,'2024-02-13 20:04:31','2024-02-13 20:04:31',NULL),(1681,7705,40720,1533,3,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-17','2023-12-17',4000.01,NULL,NULL,1,'2024-02-13 20:06:04','2024-02-13 20:06:04',NULL),(1682,7705,40720,1533,3,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-17','2023-12-17',25801.18,NULL,NULL,1,'2024-02-13 20:06:57','2024-02-13 20:06:57',NULL),(1683,7705,40720,1533,3,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',4000.44,NULL,NULL,1,'2024-02-13 20:08:13','2024-02-13 20:08:13',NULL);
INSERT INTO `balance_libro` VALUES (1684,7705,40720,1533,3,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',31705.38,NULL,NULL,1,'2024-02-13 20:09:05','2024-02-13 20:09:05',NULL),(1685,7705,40720,1533,3,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',8000.88,NULL,NULL,1,'2024-02-13 20:09:59','2024-02-13 20:09:59',NULL),(1686,7705,40720,1533,3,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',13000.04,NULL,NULL,1,'2024-02-13 20:10:51','2024-02-13 20:10:51',NULL),(1687,7705,40720,1533,3,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',28999.75,NULL,NULL,1,'2024-02-13 20:11:41','2024-02-13 20:11:41',NULL),(1688,7705,40720,1533,3,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',99003.93,NULL,NULL,1,'2024-02-13 20:12:29','2024-02-13 20:12:29',NULL),(1689,7705,40720,1533,3,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',70002.80,NULL,NULL,1,'2024-02-13 20:13:11','2024-02-13 20:13:11',NULL),(1690,7705,40720,1533,3,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',10001.01,NULL,NULL,1,'2024-02-13 20:14:42','2024-02-13 20:14:42',NULL),(1691,7705,40720,1533,3,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',92409.74,NULL,NULL,1,'2024-02-13 20:15:29','2024-02-13 20:15:29',NULL),(1692,7705,40720,1533,3,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',4000.12,NULL,NULL,1,'2024-02-13 20:16:53','2024-02-13 20:16:53',NULL),(1693,7705,40720,1533,3,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',19002.26,NULL,NULL,1,'2024-02-13 20:17:43','2024-02-13 20:17:43',NULL),(1694,7705,40720,1533,3,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',10000.72,NULL,NULL,1,'2024-02-13 20:18:31','2024-02-13 20:18:31',NULL),(1695,7705,40720,1533,3,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',4000.44,NULL,NULL,1,'2024-02-13 20:19:43','2024-02-13 20:19:43',NULL),(1696,7705,40720,1533,3,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',57307.24,NULL,NULL,1,'2024-02-13 20:20:26','2024-02-13 20:20:26',NULL),(1697,7705,40720,1533,3,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',33001.10,NULL,NULL,1,'2024-02-13 20:21:11','2024-02-13 20:21:11',NULL),(1698,7705,40720,1533,3,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',69999.56,NULL,NULL,1,'2024-02-13 20:22:18','2024-02-13 20:22:18',NULL),(1699,7705,40720,1533,3,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',34507.25,NULL,NULL,1,'2024-02-13 20:23:11','2024-02-13 20:23:11',NULL),(1700,7705,40720,1533,3,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-23','2023-12-23',4998.95,NULL,NULL,1,'2024-02-13 20:24:06','2024-02-13 20:24:06',NULL),(1701,7705,40720,1533,3,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-23','2023-12-23',30003.76,NULL,NULL,1,'2024-02-13 20:24:53','2024-02-13 20:24:53',NULL),(1702,7705,40720,1533,3,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-23','2023-12-23',40503.02,NULL,NULL,1,'2024-02-13 20:26:13','2024-02-13 20:26:13',NULL),(1703,7705,40720,1533,3,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',30000.70,NULL,NULL,1,'2024-02-13 20:28:15','2024-02-13 20:28:15',NULL),(1704,7705,40720,1533,3,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',6999.17,NULL,NULL,1,'2024-02-13 20:29:37','2024-02-13 20:29:37',NULL);
INSERT INTO `balance_libro` VALUES (1705,7705,40720,1533,3,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',26503.33,NULL,NULL,1,'2024-02-13 20:30:18','2024-02-13 20:30:18',NULL),(1706,7705,40720,1533,3,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',19998.88,NULL,NULL,1,'2024-02-13 21:13:08','2024-02-13 21:13:08',NULL),(1707,7705,40720,1533,3,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',12001.32,NULL,NULL,1,'2024-02-13 21:14:07','2024-02-13 21:14:07',NULL),(1708,7705,40720,1533,3,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',34103.75,NULL,NULL,1,'2024-02-13 21:14:47','2024-02-13 21:14:47',NULL),(1709,7705,40720,1533,3,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',19999.14,NULL,NULL,1,'2024-02-13 21:15:34','2024-02-13 21:15:34',NULL),(1710,7705,40720,1533,3,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',49509.41,NULL,NULL,1,'2024-02-13 21:17:07','2024-02-13 21:17:07',NULL),(1711,7705,40720,1533,3,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',5900.00,NULL,NULL,1,'2024-02-13 21:18:30','2024-02-13 21:18:30',NULL),(1712,7705,40720,1533,3,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',9999.57,NULL,NULL,1,'2024-02-13 21:19:21','2024-02-13 21:19:21',NULL),(1713,7705,40720,1533,3,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',42997.86,NULL,NULL,1,'2024-02-13 21:19:57','2024-02-13 21:19:57',NULL),(1714,7705,40720,1533,3,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',24991.85,NULL,NULL,1,'2024-02-13 21:20:47','2024-02-13 21:20:47',NULL),(1715,7705,40720,1533,3,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',9999.57,NULL,NULL,1,'2024-02-13 21:21:24','2024-02-13 21:21:24',NULL),(1716,7705,40720,1533,3,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',29998.72,NULL,NULL,1,'2024-02-13 21:21:56','2024-02-13 21:21:56',NULL),(1717,7705,40720,1533,3,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',37301.25,NULL,NULL,1,'2024-02-13 21:23:05','2024-02-13 21:23:05',NULL),(1718,7705,40720,1533,3,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',9998.56,NULL,NULL,1,'2024-02-13 21:23:56','2024-02-13 21:23:56',NULL),(1719,7705,40720,1533,3,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',5961.07,NULL,NULL,1,'2024-02-13 21:25:27','2024-02-13 21:25:27',NULL),(1720,7705,40720,1533,3,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',2600.01,NULL,NULL,1,'2024-02-13 21:26:13','2024-02-13 21:26:13',NULL),(1721,7705,40720,1533,3,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',193140.50,NULL,NULL,1,'2024-02-13 21:28:17','2024-02-13 21:28:17',NULL),(1722,7705,40720,1533,3,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',6300.01,NULL,NULL,1,'2024-02-13 21:29:42','2024-02-13 21:29:42',NULL),(1723,7705,40720,1533,3,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',5961.07,NULL,NULL,1,'2024-02-13 21:30:43','2024-02-13 21:30:43',NULL),(1724,7705,40720,1533,3,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',12950.01,NULL,NULL,1,'2024-02-13 21:31:48','2024-02-13 21:31:48',NULL),(1725,7705,40720,1533,3,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',5961.07,NULL,NULL,1,'2024-02-13 21:32:40','2024-02-13 21:32:40',NULL);
INSERT INTO `balance_libro` VALUES (1726,7705,40720,1533,3,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',9801.01,NULL,NULL,1,'2024-02-13 21:36:22','2024-02-13 21:36:22',NULL),(1727,7705,40720,1533,3,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',78821.82,NULL,NULL,1,'2024-02-13 21:37:32','2024-02-13 21:37:32',NULL),(1728,7705,40720,1533,3,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',70000.00,NULL,NULL,1,'2024-02-13 21:39:07','2024-02-13 21:39:07',NULL),(1729,7705,40720,1533,3,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',310300.00,NULL,NULL,1,'2024-02-13 21:40:12','2024-02-13 21:40:12',NULL),(1730,7705,40745,3049,3,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',10002.87,NULL,NULL,1,'2024-02-19 19:58:50','2024-02-19 19:58:50',NULL),(1731,7705,40745,3049,3,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',9000.06,NULL,NULL,1,'2024-02-19 19:59:52','2024-02-19 19:59:52',NULL),(1732,7705,40745,3049,3,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',7000.05,NULL,NULL,1,'2024-02-19 20:01:36','2024-02-19 20:01:36',NULL),(1733,7705,40745,3049,3,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',10002.87,NULL,NULL,1,'2024-02-19 20:02:54','2024-02-19 20:02:54',NULL),(1734,7705,40745,3049,3,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',8003.94,NULL,NULL,1,'2024-02-19 20:03:39','2024-02-19 20:03:39',NULL),(1735,7705,40745,3049,3,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',10002.87,NULL,NULL,1,'2024-02-19 20:05:09','2024-02-19 20:05:09',NULL),(1736,7705,40745,3049,3,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',10000.38,NULL,NULL,1,'2024-02-19 20:05:56','2024-02-19 20:05:56',NULL),(1737,7705,40745,3050,3,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',19997.27,NULL,NULL,1,'2024-03-17 10:23:35','2024-03-17 10:23:35',NULL),(1738,7705,40745,3050,3,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',18001.93,NULL,NULL,1,'2024-03-17 10:24:28','2024-03-17 10:24:28',NULL),(1739,7705,40745,3050,3,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-13','2024-02-13',19997.27,NULL,NULL,1,'2024-03-17 10:26:12','2024-03-17 10:26:12',NULL),(1740,7705,40745,3050,3,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',29999.99,NULL,NULL,1,'2024-03-17 10:27:22','2024-03-17 10:27:22',NULL),(1741,7705,40745,3050,3,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',19999.87,NULL,NULL,1,'2024-03-17 10:28:32','2024-03-17 10:28:32',NULL),(1742,7705,40745,3050,3,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-17','2024-02-17',19999.87,NULL,NULL,1,'2024-03-17 10:30:21','2024-03-17 10:30:21',NULL),(1743,7705,40745,3050,3,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',10860.00,NULL,NULL,1,'2024-03-17 10:57:32','2024-03-17 10:57:32',NULL),(1744,7705,40720,1537,3,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',31605.67,NULL,NULL,1,'2024-03-18 19:35:03','2024-03-18 19:38:17','2024-03-18 19:38:17'),(1745,7705,40720,1537,3,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',24804.58,NULL,NULL,1,'2024-03-18 19:35:53','2024-03-18 19:37:55','2024-03-18 19:37:55');
INSERT INTO `balance_libro` VALUES (1746,7705,40720,1537,3,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',22505.92,NULL,NULL,1,'2024-03-18 19:36:40','2024-03-18 19:37:37','2024-03-18 19:37:37'),(1747,7705,40720,1537,3,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',22505.92,NULL,NULL,1,'2024-03-18 19:37:37','2024-03-18 19:37:37',NULL),(1748,7705,40720,1537,3,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',24804.58,NULL,NULL,1,'2024-03-18 19:37:55','2024-03-18 19:37:55',NULL),(1749,7705,40720,1537,3,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',31605.67,NULL,NULL,1,'2024-03-18 19:38:17','2024-03-18 19:38:17',NULL),(1750,7705,40720,1538,3,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',39999.98,NULL,NULL,1,'2024-03-18 19:57:04','2024-03-18 19:58:14','2024-03-18 19:58:14'),(1751,7705,40720,1537,3,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',39999.98,NULL,NULL,1,'2024-03-18 19:58:14','2024-03-18 19:58:14',NULL),(1752,7705,40720,1537,3,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',84130.94,NULL,NULL,1,'2024-03-18 20:01:12','2024-03-18 20:01:12',NULL),(1753,7705,40720,1537,3,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-04','2024-01-04',19998.26,NULL,NULL,1,'2024-03-18 20:02:09','2024-03-18 20:02:09',NULL),(1754,7705,40720,1537,3,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',19700.00,NULL,NULL,1,'2024-03-18 20:04:06','2024-03-24 10:45:53','2024-03-24 10:45:53'),(1755,7705,40720,1537,3,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',27001.94,NULL,NULL,1,'2024-03-18 20:05:17','2024-03-18 20:05:17',NULL),(1756,7705,40720,1537,3,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',50568.78,NULL,NULL,1,'2024-03-18 20:08:19','2024-03-18 20:08:19',NULL),(1757,7705,40720,1537,3,1660,'App\\Models\\Receipt',1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',20098.12,NULL,NULL,1,'2024-03-18 20:09:32','2024-03-18 20:09:32',NULL),(1758,7705,40720,1537,3,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',40998.38,NULL,NULL,1,'2024-03-18 20:10:30','2024-03-18 20:10:30',NULL),(1759,7705,40720,1537,3,1662,'App\\Models\\Receipt',1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-06','2024-01-06',5001.87,NULL,NULL,1,'2024-03-18 20:11:26','2024-03-18 20:11:26',NULL),(1760,7705,40720,1537,3,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-06','2024-01-06',25000.00,NULL,NULL,1,'2024-03-18 20:12:08','2024-03-18 20:12:08',NULL),(1761,7705,40720,1537,3,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-06','2024-01-06',4999.99,NULL,NULL,1,'2024-03-18 20:14:10','2024-03-18 20:14:10',NULL),(1762,7705,40720,1537,3,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-06','2024-01-06',9999.97,NULL,NULL,1,'2024-03-18 20:15:07','2024-03-18 20:15:07',NULL),(1763,7705,40720,1537,3,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-07','2024-01-07',16999.39,NULL,NULL,1,'2024-03-18 20:15:59','2024-03-18 20:15:59',NULL),(1764,7705,40720,1537,3,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-07','2024-01-07',9999.97,NULL,NULL,1,'2024-03-18 20:16:39','2024-03-18 20:16:39',NULL),(1765,7705,40720,1537,3,1668,'App\\Models\\Receipt',1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-07','2024-01-07',13002.05,NULL,NULL,1,'2024-03-18 20:29:39','2024-03-18 20:29:39',NULL);
INSERT INTO `balance_libro` VALUES (1766,7705,40720,1537,3,1669,'App\\Models\\Receipt',1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-07','2024-01-07',58001.58,NULL,NULL,1,'2024-03-18 20:31:29','2024-03-18 20:31:29',NULL),(1767,7705,40720,1537,3,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',5001.15,NULL,NULL,1,'2024-03-18 20:33:42','2024-03-18 20:33:42',NULL),(1768,7705,40720,1537,3,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',9001.30,NULL,NULL,1,'2024-03-18 20:34:32','2024-03-18 20:34:32',NULL),(1769,7705,40720,1537,3,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',38103.04,NULL,NULL,1,'2024-03-18 20:57:40','2024-03-18 20:57:40',NULL),(1770,7705,40720,1537,3,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',5001.15,NULL,NULL,1,'2024-03-18 21:29:53','2024-03-18 21:29:53',NULL),(1771,7705,40720,1537,3,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',9998.45,NULL,NULL,1,'2024-03-18 21:31:08','2024-03-18 21:31:08',NULL),(1772,7705,40720,1537,3,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',28708.75,NULL,NULL,1,'2024-03-18 21:51:26','2024-03-18 21:51:26',NULL),(1773,7705,40720,1537,3,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',9998.45,NULL,NULL,1,'2024-03-18 21:55:48','2024-03-18 21:55:48',NULL),(1774,7705,40720,1537,3,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',79323.10,NULL,NULL,1,'2024-03-18 21:57:08','2024-03-18 21:57:08',NULL),(1775,7705,40720,1537,3,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',17998.05,NULL,NULL,1,'2024-03-18 21:59:19','2024-03-18 21:59:19',NULL),(1776,7705,40720,1537,3,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',6002.36,NULL,NULL,1,'2024-03-18 22:01:48','2024-03-18 22:01:48',NULL),(1777,7705,40720,1537,3,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',20000.51,NULL,NULL,1,'2024-03-18 22:02:41','2024-03-18 22:02:41',NULL),(1778,7705,40720,1537,3,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',4000.10,NULL,NULL,1,'2024-03-18 22:04:46','2024-03-18 22:04:46',NULL),(1779,7705,40720,1537,3,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',9998.45,NULL,NULL,1,'2024-03-18 22:05:32','2024-03-18 22:05:32',NULL),(1780,7705,40720,1537,3,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',5000.38,NULL,NULL,1,'2024-03-18 22:06:35','2024-03-18 22:06:35',NULL),(1781,7705,40720,1537,3,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',20000.51,NULL,NULL,1,'2024-03-18 22:10:36','2024-03-18 22:10:36',NULL),(1782,7705,40720,1537,3,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',29998.55,NULL,NULL,1,'2024-03-18 22:12:33','2024-03-18 22:12:33',NULL),(1783,7705,40720,1537,3,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',9001.30,NULL,NULL,1,'2024-03-18 22:13:31','2024-03-18 22:13:31',NULL),(1784,7705,40720,1537,3,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',20000.74,NULL,NULL,1,'2024-03-18 22:14:08','2024-03-18 22:14:08',NULL),(1785,7705,40720,1537,3,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',32995.62,NULL,NULL,1,'2024-03-18 22:16:52','2024-03-18 22:16:52',NULL),(1786,7705,40720,1537,3,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-14','2024-01-14',78004.34,NULL,NULL,1,'2024-03-18 22:23:25','2024-03-18 22:23:25',NULL);
INSERT INTO `balance_libro` VALUES (1787,7705,40720,1537,3,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',16000.02,NULL,NULL,1,'2024-03-18 22:25:37','2024-03-18 22:25:37',NULL),(1788,7705,40720,1537,3,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',7001.35,NULL,NULL,1,'2024-03-18 22:26:48','2024-03-18 22:26:48',NULL),(1789,7705,40720,1537,3,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',7001.35,NULL,NULL,1,'2024-03-18 22:27:28','2024-03-18 22:27:28',NULL),(1790,7705,40720,1537,3,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',70002.69,NULL,NULL,1,'2024-03-18 22:36:47','2024-03-18 22:36:47',NULL),(1791,7705,40720,1537,3,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',50003.45,NULL,NULL,1,'2024-03-18 22:43:29','2024-03-18 22:43:29',NULL),(1792,7705,40720,1537,3,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',7001.35,NULL,NULL,1,'2024-03-18 22:45:01','2024-03-18 22:45:01',NULL),(1793,7705,40720,1537,3,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',7000.02,NULL,NULL,1,'2024-03-23 11:35:21','2024-03-23 11:35:21',NULL),(1794,7705,40720,1537,3,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',54994.35,NULL,NULL,1,'2024-03-23 11:36:49','2024-03-23 11:36:49',NULL),(1795,7705,40720,1537,3,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',9998.14,NULL,NULL,1,'2024-03-23 11:39:35','2024-03-23 11:39:35',NULL),(1796,7705,40720,1537,3,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',9998.14,NULL,NULL,1,'2024-03-23 11:40:34','2024-03-23 11:40:34',NULL),(1797,7705,40720,1537,3,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',7000.02,NULL,NULL,1,'2024-03-23 11:41:18','2024-03-23 11:41:18',NULL),(1798,7705,40720,1537,3,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',122376.17,NULL,NULL,1,'2024-03-23 11:42:16','2024-03-23 11:42:16',NULL),(1799,7705,40720,1537,3,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',68607.56,NULL,NULL,1,'2024-03-23 11:43:35','2024-03-23 11:43:35',NULL),(1800,7705,40720,1537,3,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',9998.14,NULL,NULL,1,'2024-03-23 11:44:31','2024-03-23 11:44:31',NULL),(1801,7705,40720,1537,3,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',40000.01,NULL,NULL,1,'2024-03-23 11:45:21','2024-03-23 11:45:21',NULL),(1802,7705,40720,1537,3,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',16000.02,NULL,NULL,1,'2024-03-23 11:46:32','2024-03-23 11:46:32',NULL),(1803,7705,40720,1537,3,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',117199.70,NULL,NULL,1,'2024-03-23 11:47:17','2024-03-23 11:47:17',NULL),(1804,7705,40720,1537,3,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-20','2024-01-20',9998.14,NULL,NULL,1,'2024-03-23 11:48:19','2024-03-23 11:48:19',NULL),(1805,7705,40720,1537,3,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-20','2024-01-20',8000.01,NULL,NULL,1,'2024-03-23 11:49:54','2024-03-23 11:49:54',NULL),(1806,7705,40720,1537,3,1709,'App\\Models\\Receipt',1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-20','2024-01-20',55407.42,NULL,NULL,1,'2024-03-23 12:03:24','2024-03-23 12:03:24',NULL),(1807,7705,40720,1538,3,1710,'App\\Models\\Receipt',1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-20','2024-01-20',5000.37,NULL,NULL,1,'2024-03-23 13:11:57','2024-03-23 13:11:57',NULL);
INSERT INTO `balance_libro` VALUES (1808,7705,40720,1538,3,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-20','2024-01-20',49998.12,NULL,NULL,1,'2024-03-23 13:13:31','2024-03-23 13:13:31',NULL),(1809,7705,40720,1538,3,1712,'App\\Models\\Receipt',1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-21','2024-01-21',16000.55,NULL,NULL,1,'2024-03-23 13:16:55','2024-03-23 13:16:55',NULL),(1810,7705,40720,1538,3,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-21','2024-01-21',40004.82,NULL,NULL,1,'2024-03-23 13:17:54','2024-03-23 13:17:54',NULL),(1811,7705,40720,1538,3,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',5997.99,NULL,NULL,1,'2024-03-23 13:19:01','2024-03-23 13:19:01',NULL),(1812,7705,40720,1538,3,1715,'App\\Models\\Receipt',1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',6999.29,NULL,NULL,1,'2024-03-23 13:20:26','2024-03-23 13:20:26',NULL),(1813,7705,40720,1538,3,1716,'App\\Models\\Receipt',1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',6999.29,NULL,NULL,1,'2024-03-23 13:21:11','2024-03-23 13:21:11',NULL),(1814,7705,40720,1538,3,1717,'App\\Models\\Receipt',1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',9998.14,NULL,NULL,1,'2024-03-23 13:21:54','2024-03-23 13:21:54',NULL),(1815,7705,40720,1538,3,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',5997.99,NULL,NULL,1,'2024-03-23 13:22:44','2024-03-23 13:22:44',NULL),(1816,7705,40720,1538,3,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-22','2024-01-22',4999.06,NULL,NULL,1,'2024-03-23 13:23:37','2024-03-23 13:23:37',NULL),(1817,7705,40720,1537,3,1720,'App\\Models\\Receipt',1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',6000.00,NULL,NULL,1,'2024-03-23 21:40:47','2024-03-23 21:40:47',NULL),(1818,7705,40720,1537,3,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',9998.14,NULL,NULL,1,'2024-03-23 21:41:40','2024-03-23 21:41:40',NULL),(1819,7705,40720,1537,3,1722,'App\\Models\\Receipt',1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',26999.47,NULL,NULL,1,'2024-03-23 21:42:25','2024-03-23 21:42:25',NULL),(1820,7705,40720,1537,3,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',9998.14,NULL,NULL,1,'2024-03-23 21:43:12','2024-03-23 21:43:12',NULL),(1821,7705,40720,1537,3,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',9998.14,NULL,NULL,1,'2024-03-23 21:43:55','2024-03-23 21:43:55',NULL),(1822,7705,40720,1537,3,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',25001.90,NULL,NULL,1,'2024-03-23 21:44:34','2024-03-23 21:44:34',NULL),(1823,7705,40720,1537,3,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',9998.14,NULL,NULL,1,'2024-03-23 21:45:15','2024-03-23 21:45:15',NULL),(1824,7705,40720,1537,3,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',10000.09,NULL,NULL,1,'2024-03-23 21:46:43','2024-03-23 21:46:43',NULL),(1825,7705,40720,1537,3,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',8000.01,NULL,NULL,1,'2024-03-23 21:47:42','2024-03-23 21:47:42',NULL),(1826,7705,40720,1537,3,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',20000.70,NULL,NULL,1,'2024-03-23 21:48:22','2024-03-23 21:48:22',NULL),(1827,7705,40720,1537,3,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',5001.15,NULL,NULL,1,'2024-03-23 21:49:05','2024-03-23 21:49:05',NULL),(1828,7705,40720,1537,3,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',19003.05,NULL,NULL,1,'2024-03-23 21:49:58','2024-03-23 21:49:58',NULL);
INSERT INTO `balance_libro` VALUES (1829,7705,40720,1537,3,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',62396.68,NULL,NULL,1,'2024-03-23 21:50:55','2024-03-23 21:50:55',NULL),(1830,7705,40720,1537,3,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',17001.61,NULL,NULL,1,'2024-03-24 09:39:47','2024-03-24 09:39:47',NULL),(1831,7705,40720,1537,3,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',49996.67,NULL,NULL,1,'2024-03-24 09:41:34','2024-03-24 09:41:34',NULL),(1832,7705,40720,1537,3,1735,'App\\Models\\Receipt',1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',8000.29,NULL,NULL,1,'2024-03-24 09:42:40','2024-03-24 09:42:40',NULL),(1833,7705,40720,1537,3,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',5001.15,NULL,NULL,1,'2024-03-24 10:02:38','2024-03-24 10:02:38',NULL),(1834,7705,40720,1537,3,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',9998.14,NULL,NULL,1,'2024-03-24 10:03:20','2024-03-24 10:03:20',NULL),(1835,7705,40720,1537,3,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',13998.60,NULL,NULL,1,'2024-03-24 10:04:17','2024-03-24 10:04:17',NULL),(1836,7705,40720,1537,3,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-27','2024-01-27',17000.09,NULL,NULL,1,'2024-03-24 10:05:03','2024-03-24 10:05:03',NULL),(1837,7705,40720,1537,3,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-28','2024-01-28',9998.14,NULL,NULL,1,'2024-03-24 10:06:11','2024-03-24 10:06:11',NULL),(1838,7705,40720,1537,3,1741,'App\\Models\\Receipt',1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-28','2024-01-28',19996.27,NULL,NULL,1,'2024-03-24 10:07:00','2024-03-24 10:07:00',NULL),(1839,7705,40720,1537,3,1742,'App\\Models\\Receipt',1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',90410.59,NULL,NULL,1,'2024-03-24 10:08:02','2024-03-24 10:08:02',NULL),(1840,7705,40720,1537,3,1743,'App\\Models\\Receipt',1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',5001.15,NULL,NULL,1,'2024-03-24 10:08:53','2024-03-24 10:08:53',NULL),(1841,7705,40720,1537,3,1744,'App\\Models\\Receipt',1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',102094.82,NULL,NULL,1,'2024-03-24 10:10:18','2024-03-24 10:10:18',NULL),(1842,7705,40720,1537,3,1745,'App\\Models\\Receipt',1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',18500.02,NULL,NULL,1,'2024-03-24 10:11:18','2024-03-24 10:11:18',NULL),(1843,7705,40720,1537,3,1746,'App\\Models\\Receipt',1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',62997.70,NULL,NULL,1,'2024-03-24 10:12:09','2024-03-24 10:12:09',NULL),(1844,7705,40720,1537,3,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-30','2024-01-30',18593.65,NULL,NULL,1,'2024-03-24 10:13:23','2024-03-24 10:13:23',NULL),(1845,7705,40720,1537,3,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-30','2024-01-30',89929.89,NULL,NULL,1,'2024-03-24 10:14:48','2024-03-24 10:14:48',NULL),(1846,7705,40720,1537,3,1749,'App\\Models\\Receipt',1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',24997.86,NULL,NULL,1,'2024-03-24 10:15:43','2024-03-24 10:15:43',NULL),(1847,7705,40720,1537,3,1750,'App\\Models\\Receipt',1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',25007.36,NULL,NULL,1,'2024-03-24 10:16:24','2024-03-24 10:16:24',NULL),(1848,7705,40720,1537,3,1751,'App\\Models\\Receipt',1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',643675.98,NULL,NULL,1,'2024-03-24 10:25:07','2024-03-24 10:25:07',NULL),(1849,7705,40720,1537,3,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',44800.01,NULL,NULL,1,'2024-03-24 10:26:41','2024-03-24 10:26:41',NULL);
INSERT INTO `balance_libro` VALUES (1850,7705,40720,1537,3,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-06','2024-01-06',7800.00,NULL,NULL,1,'2024-03-24 10:28:21','2024-03-24 10:28:21',NULL),(1851,7705,40720,1537,3,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-06','2024-01-06',3800.00,NULL,NULL,1,'2024-03-24 10:29:08','2024-03-24 10:29:08',NULL),(1852,7705,40720,1537,3,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',19000.00,NULL,NULL,1,'2024-03-24 10:32:40','2024-03-24 10:32:40',NULL),(1853,7705,40720,1537,3,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',7680.00,NULL,NULL,1,'2024-03-24 10:33:57','2024-03-24 10:33:57',NULL),(1854,7705,40720,1537,3,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-24','2024-01-24',14700.00,NULL,NULL,1,'2024-03-24 10:35:08','2024-03-24 10:35:08',NULL),(1855,7705,40720,1537,3,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',21600.00,NULL,NULL,1,'2024-03-24 10:36:16','2024-03-24 10:36:16',NULL),(1856,7705,40720,1537,3,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-28','2024-01-28',43999.00,NULL,NULL,1,'2024-03-24 10:39:01','2024-03-24 10:39:01',NULL),(1857,7705,40720,1537,3,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',8034.40,NULL,NULL,1,'2024-03-24 10:40:28','2024-03-24 10:40:28',NULL),(1858,7705,40720,1537,3,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',24000.00,NULL,NULL,1,'2024-03-24 10:44:00','2024-03-24 10:44:00',NULL),(1859,7705,40720,1537,3,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',19700.00,NULL,NULL,1,'2024-03-24 10:45:53','2024-03-24 10:45:53',NULL),(1860,7705,40720,1538,3,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-30','2024-01-30',46007.29,NULL,NULL,1,'2024-04-21 19:53:12','2024-04-21 19:53:12',NULL),(1861,7705,40720,1538,3,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',89002.02,NULL,NULL,1,'2024-04-21 19:58:10','2024-04-21 19:58:10',NULL),(1862,7705,40720,1538,3,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',6999.24,NULL,NULL,1,'2024-04-21 20:00:48','2024-04-21 20:00:48',NULL),(1863,7705,40720,1538,3,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',106303.90,NULL,NULL,1,'2024-04-21 20:02:43','2024-04-21 20:02:43',NULL),(1864,7705,40720,1538,3,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',10000.35,NULL,NULL,1,'2024-04-21 20:07:55','2024-04-21 20:07:55',NULL),(1865,7705,40720,1538,3,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',8000.04,NULL,NULL,1,'2024-04-21 20:26:03','2024-04-21 20:26:03',NULL),(1866,7705,40720,1538,3,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-04','2024-02-04',6000.03,NULL,NULL,1,'2024-04-21 20:27:16','2024-04-21 20:27:16',NULL),(1867,7705,40720,1538,3,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-04','2024-02-04',4001.65,NULL,NULL,1,'2024-04-21 20:28:03','2024-04-21 20:28:03',NULL),(1868,7705,40720,1538,3,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-04','2024-02-04',10000.04,NULL,NULL,1,'2024-04-21 20:28:45','2024-04-21 20:28:45',NULL),(1869,7705,40720,1538,3,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',5000.00,NULL,NULL,1,'2024-04-21 20:29:46','2024-04-21 20:29:46',NULL),(1870,7705,40720,1538,3,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',11998.36,NULL,NULL,1,'2024-04-21 20:30:47','2024-04-21 20:30:47',NULL);
INSERT INTO `balance_libro` VALUES (1871,7705,40720,1538,3,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',10000.05,NULL,NULL,1,'2024-04-21 20:31:43','2024-04-21 20:31:43',NULL),(1872,7705,40720,1538,3,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',5000.13,NULL,NULL,1,'2024-04-21 20:32:50','2024-04-21 20:32:50',NULL),(1873,7705,40720,1538,3,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',5998.39,NULL,NULL,1,'2024-04-21 20:33:57','2024-04-21 20:33:57',NULL),(1874,7705,40720,1538,3,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',10000.05,NULL,NULL,1,'2024-04-21 20:34:54','2024-04-21 20:34:54',NULL),(1875,7705,40720,1538,3,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',5998.39,NULL,NULL,1,'2024-04-21 20:35:52','2024-04-21 20:35:52',NULL),(1876,7705,40720,1538,3,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',4000.25,NULL,NULL,1,'2024-04-21 20:36:45','2024-04-21 20:36:45',NULL),(1877,7705,40720,1538,3,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',90004.27,NULL,NULL,1,'2024-04-21 20:37:57','2024-04-21 20:37:57',NULL),(1878,7705,40720,1538,3,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',10003.02,NULL,NULL,1,'2024-04-21 20:39:53','2024-04-21 20:39:53',NULL),(1879,7705,40720,1538,3,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',19999.99,NULL,NULL,1,'2024-04-21 20:40:52','2024-04-21 20:40:52',NULL),(1880,7705,40720,1538,3,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',10000.37,NULL,NULL,1,'2024-04-21 20:41:50','2024-04-21 20:41:50',NULL),(1881,7705,40720,1538,3,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',6002.09,NULL,NULL,1,'2024-04-21 20:42:48','2024-04-21 20:42:48',NULL),(1882,7705,40720,1538,3,1784,'App\\Models\\Receipt',1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',5000.15,NULL,NULL,1,'2024-04-21 20:43:58','2024-04-21 20:43:58',NULL),(1883,7705,40720,1538,3,1785,'App\\Models\\Receipt',1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',5999.69,NULL,NULL,1,'2024-04-21 20:46:16','2024-04-21 20:46:16',NULL),(1884,7705,40720,1538,3,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',52010.20,NULL,NULL,1,'2024-05-19 22:23:17','2024-05-19 22:23:17',NULL),(1885,7705,40720,1538,3,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',89002.83,NULL,NULL,1,'2024-05-19 22:23:55','2024-05-19 22:23:55',NULL),(1886,7705,40720,1538,3,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',10003.02,NULL,NULL,1,'2024-05-19 22:24:55','2024-05-19 22:24:55',NULL),(1887,7705,40720,1538,3,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',75000.33,NULL,NULL,1,'2024-05-19 22:26:07','2024-05-19 22:26:07',NULL),(1888,7705,40720,1538,3,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',103001.59,NULL,NULL,1,'2024-05-19 22:26:45','2024-05-19 22:26:45',NULL),(1889,7705,40720,1538,3,1791,'App\\Models\\Receipt',1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',64405.27,NULL,NULL,1,'2024-05-19 22:27:25','2024-05-19 22:27:25',NULL),(1890,7705,40720,1538,3,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',20000.73,NULL,NULL,1,'2024-05-19 22:28:09','2024-05-19 22:28:09',NULL),(1891,7705,40720,1538,3,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',35000.68,NULL,NULL,1,'2024-05-19 22:29:15','2024-05-19 22:29:15',NULL);
INSERT INTO `balance_libro` VALUES (1892,7705,40720,1538,3,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',35401.99,NULL,NULL,1,'2024-05-19 22:30:13','2024-05-19 22:30:13',NULL),(1893,7705,40720,1538,3,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',22600.00,NULL,NULL,1,'2024-05-19 22:31:38','2024-05-19 22:31:38',NULL),(1894,7705,40720,1538,3,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',6000.39,NULL,NULL,1,'2024-05-19 22:32:59','2024-05-19 22:32:59',NULL),(1895,7705,40720,1538,3,1797,'App\\Models\\Receipt',1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',18000.06,NULL,NULL,1,'2024-05-19 22:33:46','2024-05-19 22:33:46',NULL),(1896,7705,40720,1538,3,1798,'App\\Models\\Receipt',1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',19999.98,NULL,NULL,1,'2024-05-19 22:34:20','2024-05-19 22:34:20',NULL),(1897,7705,40720,1538,3,1799,'App\\Models\\Receipt',1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',10999.87,NULL,NULL,1,'2024-05-19 22:35:15','2024-05-19 22:35:15',NULL),(1898,7705,40720,1538,3,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-10','2024-02-10',5000.00,NULL,NULL,1,'2024-05-19 22:36:17','2024-05-19 22:36:17',NULL),(1899,7705,40720,1538,3,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-10','2024-02-10',14997.26,NULL,NULL,1,'2024-05-19 22:37:02','2024-05-19 22:37:02',NULL),(1900,7705,40720,1538,3,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-10','2024-02-10',5000.02,NULL,NULL,1,'2024-05-19 23:00:28','2024-05-19 23:00:28',NULL),(1901,7705,40720,1538,3,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-10','2024-02-10',6000.01,NULL,NULL,1,'2024-05-19 23:01:17','2024-05-19 23:01:17',NULL),(1902,7705,40720,1538,3,1804,'App\\Models\\Receipt',1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-10','2024-02-10',10000.05,NULL,NULL,1,'2024-05-19 23:02:07','2024-05-19 23:02:07',NULL),(1903,7705,40720,1538,3,1805,'App\\Models\\Receipt',1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-11','2024-02-11',18010.91,NULL,NULL,1,'2024-05-19 23:16:23','2024-05-19 23:16:23',NULL),(1904,7705,40720,1538,3,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-11','2024-02-11',20000.73,NULL,NULL,1,'2024-05-19 23:19:27','2024-05-19 23:19:27',NULL),(1905,7705,40720,1538,3,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-11','2024-02-11',5998.39,NULL,NULL,1,'2024-05-19 23:20:08','2024-05-19 23:20:08',NULL),(1906,7705,40720,1538,3,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-11','2024-02-11',10000.05,NULL,NULL,1,'2024-05-19 23:20:45','2024-05-19 23:20:45',NULL),(1907,7705,40720,1538,3,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-12','2024-02-12',12000.87,NULL,NULL,1,'2024-05-19 23:22:22','2024-05-19 23:22:22',NULL),(1908,7705,40720,1538,3,1810,'App\\Models\\Receipt',1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-12','2024-02-12',4999.78,NULL,NULL,1,'2024-05-19 23:23:58','2024-05-19 23:23:58',NULL),(1909,7705,40720,1538,3,1811,'App\\Models\\Receipt',1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-12','2024-02-12',74503.63,NULL,NULL,1,'2024-05-19 23:26:37','2024-05-19 23:26:37',NULL),(1910,7705,40720,1538,3,1812,'App\\Models\\Receipt',1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-13','2024-02-13',20000.09,NULL,NULL,1,'2024-05-19 23:29:13','2024-05-19 23:29:13',NULL),(1911,7705,40720,1538,3,1813,'App\\Models\\Receipt',1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-13','2024-02-13',5998.39,NULL,NULL,1,'2024-05-19 23:30:28','2024-05-19 23:30:28',NULL),(1912,7705,40720,1538,3,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-13','2024-02-13',5998.39,NULL,NULL,1,'2024-05-19 23:31:07','2024-05-19 23:31:07',NULL);
INSERT INTO `balance_libro` VALUES (1913,7705,40720,1538,3,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-13','2024-02-13',44999.84,NULL,NULL,1,'2024-05-19 23:32:23','2024-05-19 23:32:23',NULL),(1914,7705,40720,1538,3,1816,'App\\Models\\Receipt',1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-13','2024-02-13',20000.73,NULL,NULL,1,'2024-05-19 23:32:59','2024-05-19 23:32:59',NULL),(1915,7705,40720,1538,3,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-13','2024-02-13',9999.96,NULL,NULL,1,'2024-05-19 23:35:06','2024-05-19 23:35:06',NULL),(1916,7705,40720,1538,3,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',20000.73,NULL,NULL,1,'2024-05-19 23:36:48','2024-05-19 23:36:48',NULL),(1917,7705,40720,1538,3,1819,'App\\Models\\Receipt',1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',87004.06,NULL,NULL,1,'2024-05-19 23:37:34','2024-05-19 23:37:34',NULL),(1918,7705,40720,1538,3,1820,'App\\Models\\Receipt',1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',6999.32,NULL,NULL,1,'2024-05-19 23:38:07','2024-05-19 23:38:07',NULL),(1919,7705,40720,1538,3,1821,'App\\Models\\Receipt',1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',5998.39,NULL,NULL,1,'2024-05-19 23:38:39','2024-05-19 23:38:39',NULL),(1920,7705,40720,1538,3,1822,'App\\Models\\Receipt',1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',5998.39,NULL,NULL,1,'2024-05-19 23:39:16','2024-05-19 23:39:16',NULL),(1921,7705,40720,1538,3,1823,'App\\Models\\Receipt',1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',15000.06,NULL,NULL,1,'2024-05-19 23:39:46','2024-05-19 23:39:46',NULL),(1922,7705,40720,1538,3,1824,'App\\Models\\Receipt',1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-17','2024-02-17',61998.67,NULL,NULL,1,'2024-05-19 23:40:31','2024-05-19 23:40:31',NULL),(1923,7705,40720,1538,3,1825,'App\\Models\\Receipt',1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-17','2024-02-17',63000.10,NULL,NULL,1,'2024-05-19 23:41:02','2024-05-19 23:41:02',NULL),(1924,7705,40720,1538,3,1826,'App\\Models\\Receipt',1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-17','2024-02-17',10000.05,NULL,NULL,1,'2024-05-19 23:41:33','2024-05-19 23:41:33',NULL),(1925,7705,40720,1538,3,1827,'App\\Models\\Receipt',1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-17','2024-02-17',10000.39,NULL,NULL,1,'2024-05-19 23:42:24','2024-05-19 23:42:24',NULL),(1926,7705,40720,1538,3,1828,'App\\Models\\Receipt',1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-18','2024-02-18',10000.05,NULL,NULL,1,'2024-05-19 23:43:13','2024-05-19 23:43:13',NULL),(1927,7705,40720,1538,3,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-18','2024-02-18',7999.21,NULL,NULL,1,'2024-05-19 23:43:46','2024-05-19 23:43:46',NULL),(1928,7705,40720,1538,3,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-18','2024-02-18',111909.22,NULL,NULL,1,'2024-05-19 23:44:22','2024-05-19 23:44:22',NULL),(1929,7705,40720,1538,3,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-18','2024-02-18',6999.32,NULL,NULL,1,'2024-05-19 23:45:17','2024-05-19 23:45:17',NULL),(1930,7705,40720,1538,3,1832,'App\\Models\\Receipt',1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',20998.47,NULL,NULL,1,'2024-05-19 23:45:56','2024-05-19 23:45:56',NULL),(1931,7705,40720,1538,3,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',15000.54,NULL,NULL,1,'2024-05-19 23:46:29','2024-05-19 23:46:29',NULL),(1932,7705,40720,1538,3,1834,'App\\Models\\Receipt',1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',5998.39,NULL,NULL,1,'2024-05-19 23:47:06','2024-05-19 23:47:06',NULL),(1933,7705,40720,1538,3,1835,'App\\Models\\Receipt',1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',10000.05,NULL,NULL,1,'2024-05-19 23:48:22','2024-05-19 23:48:22',NULL);
INSERT INTO `balance_libro` VALUES (1934,7705,40720,1538,3,1836,'App\\Models\\Receipt',1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',10000.37,NULL,NULL,1,'2024-05-19 23:49:03','2024-05-19 23:49:03',NULL),(1935,7705,40720,1538,3,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',13000.01,NULL,NULL,1,'2024-05-19 23:49:35','2024-05-19 23:49:35',NULL),(1936,7705,40720,1538,3,1838,'App\\Models\\Receipt',1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',15000.06,NULL,NULL,1,'2024-05-19 23:50:10','2024-05-19 23:50:10',NULL),(1937,7705,40720,1538,3,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',5006.38,NULL,NULL,1,'2024-05-19 23:51:28','2024-05-19 23:51:28',NULL),(1938,7705,40720,1538,3,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',50004.77,NULL,NULL,1,'2024-05-19 23:52:31','2024-05-19 23:52:31',NULL),(1939,7705,40720,1538,3,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',7999.21,NULL,NULL,1,'2024-05-19 23:53:10','2024-05-19 23:53:10',NULL),(1940,7705,40720,1538,3,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',15000.54,NULL,NULL,1,'2024-05-19 23:53:40','2024-05-19 23:53:40',NULL),(1941,7705,40720,1538,3,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',20000.73,NULL,NULL,1,'2024-05-19 23:54:23','2024-05-19 23:54:23',NULL),(1942,7705,40720,1538,3,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',33000.55,NULL,NULL,1,'2024-05-19 23:55:03','2024-05-19 23:55:03',NULL),(1943,7705,40720,1538,3,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-22','2024-02-22',113013.63,NULL,NULL,1,'2024-05-19 23:55:44','2024-05-19 23:55:44',NULL),(1944,7705,40720,1538,3,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-22','2024-02-22',15998.44,NULL,NULL,1,'2024-05-19 23:56:17','2024-05-19 23:56:17',NULL),(1945,7705,40720,1538,3,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-23','2024-02-23',87691.33,NULL,NULL,1,'2024-05-19 23:57:08','2024-05-19 23:57:08',NULL),(1946,7705,40720,1538,3,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-23','2024-02-23',39001.63,NULL,NULL,1,'2024-05-19 23:57:39','2024-05-19 23:57:39',NULL),(1947,7705,40720,1538,3,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-23','2024-02-23',10000.37,NULL,NULL,1,'2024-05-19 23:58:12','2024-05-19 23:58:12',NULL),(1948,7705,40720,1538,3,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-23','2024-02-23',122143.12,NULL,NULL,1,'2024-05-19 23:58:56','2024-05-19 23:58:56',NULL),(1949,7705,40720,1538,3,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-23','2024-02-23',7999.21,NULL,NULL,1,'2024-05-19 23:59:42','2024-05-19 23:59:42',NULL),(1950,7705,40720,1538,3,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-24','2024-02-24',6999.98,NULL,NULL,1,'2024-05-20 00:01:14','2024-05-20 00:01:14',NULL),(1951,7705,40720,1538,3,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-24','2024-02-24',142433.56,NULL,NULL,1,'2024-05-20 00:02:07','2024-05-20 00:02:07',NULL),(1952,7705,40720,1538,3,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-24','2024-02-24',20000.73,NULL,NULL,1,'2024-05-20 00:03:09','2024-05-20 00:03:09',NULL),(1953,7705,40720,1538,3,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-24','2024-02-24',7000.04,NULL,NULL,1,'2024-05-20 00:03:59','2024-05-20 00:03:59',NULL),(1954,7705,40720,1538,3,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-24','2024-02-24',10000.05,NULL,NULL,1,'2024-05-20 00:04:36','2024-05-20 00:04:36',NULL);
INSERT INTO `balance_libro` VALUES (1955,7705,40720,1538,3,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-24','2024-02-24',19999.98,NULL,NULL,1,'2024-05-20 00:05:09','2024-05-20 00:05:09',NULL),(1956,7705,40720,1538,3,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-25','2024-02-25',10000.05,NULL,NULL,1,'2024-05-20 00:05:48','2024-05-20 00:05:48',NULL),(1957,7705,40720,1538,3,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-25','2024-02-25',7999.21,NULL,NULL,1,'2024-05-20 00:06:24','2024-05-20 00:06:24',NULL),(1958,7705,40720,1538,3,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-25','2024-02-25',5998.39,NULL,NULL,1,'2024-05-20 00:07:02','2024-05-20 00:07:02',NULL),(1959,7705,40720,1538,3,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-26','2024-02-26',105765.75,NULL,NULL,1,'2024-05-20 00:07:42','2024-05-20 00:07:42',NULL),(1960,7705,40720,1538,3,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-26','2024-02-26',136611.15,NULL,NULL,1,'2024-05-20 00:08:42','2024-05-20 00:08:42',NULL),(1961,7705,40720,1538,3,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-26','2024-02-26',10000.05,NULL,NULL,1,'2024-05-20 00:09:20','2024-05-20 00:09:20',NULL),(1962,7705,40720,1538,3,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',70921.24,NULL,NULL,1,'2024-05-20 00:11:06','2024-05-20 00:11:06',NULL),(1963,7705,40720,1538,3,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',136021.74,NULL,NULL,1,'2024-05-20 00:12:27','2024-05-20 00:12:27',NULL),(1964,7705,40720,1538,3,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',30000.13,NULL,NULL,1,'2024-05-20 00:12:58','2024-05-20 00:12:58',NULL),(1965,7705,40720,1538,3,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',5600.00,NULL,NULL,1,'2024-05-20 00:13:53','2024-05-20 00:30:52','2024-05-20 00:30:52'),(1966,7705,40720,1538,3,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',6900.53,NULL,NULL,1,'2024-05-20 00:16:02','2024-05-20 00:16:02',NULL),(1967,7705,40720,1538,3,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',106587.71,NULL,NULL,1,'2024-05-20 00:16:55','2024-05-20 00:30:33','2024-05-20 00:30:33'),(1968,7705,40720,1538,3,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',5600.00,NULL,NULL,1,'2024-05-20 00:17:42','2024-05-20 00:30:17','2024-05-20 00:30:17'),(1969,7705,40720,1538,3,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',14750.00,NULL,NULL,1,'2024-05-20 00:25:46','2024-05-20 00:25:46',NULL),(1970,7705,40720,1538,3,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',8034.40,NULL,NULL,1,'2024-05-20 00:28:08','2024-05-20 00:28:08',NULL),(1971,7705,40720,1538,3,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',4803.70,NULL,NULL,1,'2024-05-20 00:28:58','2024-05-20 00:28:58',NULL),(1972,7705,40720,1538,3,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',5600.00,NULL,NULL,1,'2024-05-20 00:30:17','2024-05-20 00:30:17',NULL),(1973,7705,40720,1538,3,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',106587.71,NULL,NULL,1,'2024-05-20 00:30:33','2024-05-20 00:30:33',NULL),(1974,7705,40720,1538,3,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',5600.00,NULL,NULL,1,'2024-05-20 00:30:52','2024-05-20 00:30:52',NULL);
INSERT INTO `balance_libro` VALUES (1975,7705,40720,1538,3,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',11000.02,NULL,NULL,1,'2024-05-21 21:36:18','2024-05-21 21:36:18',NULL),(1976,7705,40720,1538,3,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',10000.37,NULL,NULL,1,'2024-05-21 21:37:10','2024-05-21 21:37:10',NULL),(1977,7705,40720,1538,3,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',15000.43,NULL,NULL,1,'2024-05-21 21:38:10','2024-05-21 21:38:10',NULL),(1978,7705,40720,1538,3,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',10000.05,NULL,NULL,1,'2024-05-21 21:38:48','2024-05-21 21:38:48',NULL),(1979,7705,40720,1538,3,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',23003.45,NULL,NULL,1,'2024-05-21 21:39:41','2024-05-21 21:39:41',NULL),(1980,7705,40720,1538,3,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',9997.86,NULL,NULL,1,'2024-05-21 21:40:27','2024-05-21 21:40:27',NULL),(1981,7705,40720,1538,3,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',8000.01,NULL,NULL,1,'2024-05-21 21:43:33','2024-05-21 21:43:33',NULL),(1982,7705,40720,1539,3,1881,'App\\Models\\Receipt',1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',59998.50,NULL,NULL,1,'2024-06-22 12:35:17','2024-06-22 12:35:17',NULL),(1983,7705,40720,1539,3,1882,'App\\Models\\Receipt',1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',9997.86,NULL,NULL,1,'2024-06-22 12:36:28','2024-06-22 12:36:28',NULL),(1984,7705,40720,1539,3,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',19998.24,NULL,NULL,1,'2024-06-22 12:37:30','2024-06-22 12:37:30',NULL),(1985,7705,40720,1539,3,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-02','2024-03-02',7999.99,NULL,NULL,1,'2024-06-22 12:38:55','2024-06-22 12:38:55',NULL),(1986,7705,40720,1539,3,1885,'App\\Models\\Receipt',1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-02','2024-03-02',9998.88,NULL,NULL,1,'2024-06-22 12:41:17','2024-06-22 12:41:17',NULL),(1987,7705,40720,1539,3,1886,'App\\Models\\Receipt',1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-02','2024-03-02',50000.00,NULL,NULL,1,'2024-06-22 12:42:04','2024-06-22 12:42:04',NULL),(1988,7705,40720,1539,3,1887,'App\\Models\\Receipt',1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-03','2024-03-03',19999.68,NULL,NULL,1,'2024-06-22 12:44:25','2024-06-22 12:44:25',NULL),(1989,7705,40720,1539,3,1888,'App\\Models\\Receipt',1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-03','2024-03-03',9999.76,NULL,NULL,1,'2024-06-22 13:05:11','2024-06-22 13:05:11',NULL),(1990,7705,40720,1539,3,1889,'App\\Models\\Receipt',1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-03','2024-03-03',30000.69,NULL,NULL,1,'2024-06-22 13:06:09','2024-06-22 13:06:09',NULL),(1991,7705,40720,1539,3,1890,'App\\Models\\Receipt',1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',114001.78,NULL,NULL,1,'2024-06-22 13:07:12','2024-06-22 13:07:12',NULL),(1992,7705,40720,1539,3,1891,'App\\Models\\Receipt',1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',14999.95,NULL,NULL,1,'2024-06-22 13:07:53','2024-06-22 13:07:53',NULL),(1993,7705,40720,1539,3,1892,'App\\Models\\Receipt',1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',29999.54,NULL,NULL,1,'2024-06-22 13:09:41','2024-06-22 13:09:41',NULL),(1994,7705,40720,1539,3,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',20002.21,NULL,NULL,1,'2024-06-22 13:10:38','2024-06-22 13:10:38',NULL),(1995,7705,40720,1539,3,1894,'App\\Models\\Receipt',1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',9999.85,NULL,NULL,1,'2024-06-22 13:11:48','2024-06-22 13:11:48',NULL);
INSERT INTO `balance_libro` VALUES (1996,7705,40720,1539,3,1895,'App\\Models\\Receipt',1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',40002.06,NULL,NULL,1,'2024-06-22 13:13:05','2024-06-22 13:13:05',NULL),(1997,7705,40720,1539,3,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',4999.44,NULL,NULL,1,'2024-06-22 17:19:19','2024-06-22 17:19:19',NULL),(1998,7705,40720,1539,3,1897,'App\\Models\\Receipt',1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',39999.37,NULL,NULL,1,'2024-06-22 17:21:04','2024-06-22 17:21:04',NULL),(1999,7705,40720,1539,3,1898,'App\\Models\\Receipt',1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',9998.88,NULL,NULL,1,'2024-06-22 17:22:42','2024-06-22 17:22:42',NULL),(2000,7705,40720,1539,3,1899,'App\\Models\\Receipt',1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',14999.76,NULL,NULL,1,'2024-06-22 17:23:32','2024-06-22 17:23:32',NULL),(2001,7705,40720,1539,3,1900,'App\\Models\\Receipt',1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',22001.43,NULL,NULL,1,'2024-06-22 17:28:39','2024-06-22 17:28:39',NULL),(2002,7705,40720,1539,3,1901,'App\\Models\\Receipt',1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',126834.35,NULL,NULL,1,'2024-06-22 17:31:22','2024-06-22 17:31:22',NULL),(2003,7705,40720,1539,3,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',20002.21,NULL,NULL,1,'2024-06-22 17:32:24','2024-06-22 17:32:24',NULL),(2004,7705,40720,1539,3,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',9998.88,NULL,NULL,1,'2024-06-22 17:33:33','2024-06-22 17:33:33',NULL),(2005,7705,40720,1539,3,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-09','2024-03-09',9998.88,NULL,NULL,1,'2024-06-22 17:34:18','2024-06-22 17:34:18',NULL),(2006,7705,40720,1539,3,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-09','2024-03-09',5998.44,NULL,NULL,1,'2024-06-22 17:35:03','2024-06-22 17:35:03',NULL),(2007,7705,40720,1539,3,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-09','2024-03-09',5998.44,NULL,NULL,1,'2024-06-22 17:35:43','2024-06-22 17:35:43',NULL),(2008,7705,40720,1539,3,1907,'App\\Models\\Receipt',1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-09','2024-03-09',9999.85,NULL,NULL,1,'2024-06-22 17:36:40','2024-06-22 17:36:40',NULL),(2009,7705,40720,1539,3,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-10','2024-03-10',15000.01,NULL,NULL,1,'2024-06-22 17:37:27','2024-06-22 17:37:27',NULL),(2010,7705,40720,1539,3,1909,'App\\Models\\Receipt',1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-10','2024-03-10',8000.89,NULL,NULL,1,'2024-06-22 17:38:05','2024-06-22 17:38:05',NULL),(2011,7705,40720,1539,3,1910,'App\\Models\\Receipt',1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-10','2024-03-10',9999.85,NULL,NULL,1,'2024-06-22 17:38:50','2024-06-22 17:38:50',NULL),(2012,7705,40720,1539,3,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-10','2024-03-10',9999.85,NULL,NULL,1,'2024-06-22 17:39:25','2024-06-22 17:39:25',NULL),(2013,7705,40720,1539,3,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-10','2024-03-10',66700.98,NULL,NULL,1,'2024-06-22 17:41:35','2024-06-22 17:41:35',NULL),(2014,7705,40720,1539,3,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',9999.85,NULL,NULL,1,'2024-06-22 17:43:30','2024-06-22 17:43:30',NULL),(2015,7705,40720,1539,3,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',19996.21,NULL,NULL,1,'2024-06-22 17:44:18','2024-06-22 17:44:18',NULL),(2016,7705,40720,1539,3,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',9998.88,NULL,NULL,1,'2024-06-22 17:45:59','2024-06-22 17:45:59',NULL);
INSERT INTO `balance_libro` VALUES (2017,7705,40720,1539,3,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',89998.31,NULL,NULL,1,'2024-06-22 17:48:00','2024-06-22 17:48:00',NULL),(2018,7705,40720,1539,3,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',9998.88,NULL,NULL,1,'2024-06-22 17:49:00','2024-06-22 17:49:00',NULL),(2019,7705,40720,1539,3,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',9998.88,NULL,NULL,1,'2024-06-22 17:49:53','2024-06-22 17:49:53',NULL),(2020,7705,40720,1539,3,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-13','2024-03-13',9999.85,NULL,NULL,1,'2024-06-22 18:02:44','2024-06-22 18:02:44',NULL),(2021,7705,40720,1539,3,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-13','2024-03-13',59998.84,NULL,NULL,1,'2024-06-22 18:03:33','2024-06-22 18:03:33',NULL),(2022,7705,40720,1539,3,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-13','2024-03-13',9998.88,NULL,NULL,1,'2024-06-22 18:04:19','2024-06-22 18:04:19',NULL),(2023,7705,40720,1539,3,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-13','2024-03-13',13999.33,NULL,NULL,1,'2024-06-22 18:04:57','2024-06-22 18:04:57',NULL),(2024,7705,40720,1539,3,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',111237.96,NULL,NULL,1,'2024-06-22 18:05:56','2024-06-22 18:05:56',NULL),(2025,7705,40720,1539,3,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',4999.44,NULL,NULL,1,'2024-06-22 18:07:16','2024-06-22 18:07:16',NULL),(2026,7705,40720,1539,3,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',4999.44,NULL,NULL,1,'2024-06-22 18:08:16','2024-06-22 18:08:16',NULL),(2027,7705,40720,1539,3,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',12000.02,NULL,NULL,1,'2024-06-22 18:08:56','2024-06-22 18:08:56',NULL),(2028,7705,40720,1539,3,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',10007.77,NULL,NULL,1,'2024-06-22 18:09:41','2024-06-22 18:09:41',NULL),(2029,7705,40720,1539,3,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',16997.73,NULL,NULL,1,'2024-06-22 18:10:22','2024-06-22 18:10:22',NULL),(2030,7705,40720,1539,3,1929,'App\\Models\\Receipt',1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',9998.88,NULL,NULL,1,'2024-06-22 18:11:01','2024-06-22 18:11:01',NULL),(2031,7705,40720,1539,3,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',13000.00,NULL,NULL,1,'2024-06-22 18:11:40','2024-06-22 18:11:40',NULL),(2032,7705,40720,1539,3,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',9998.88,NULL,NULL,1,'2024-06-22 18:12:22','2024-06-22 18:12:22',NULL),(2033,7705,40720,1539,3,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',23001.64,NULL,NULL,1,'2024-06-22 18:12:59','2024-06-22 18:12:59',NULL),(2034,7705,40720,1539,3,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',10000.43,NULL,NULL,1,'2024-06-22 18:13:53','2024-06-22 18:13:53',NULL),(2035,7705,40720,1539,3,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',8000.89,NULL,NULL,1,'2024-06-22 18:14:43','2024-06-22 18:14:43',NULL),(2036,7705,40720,1539,3,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-17','2024-03-17',10000.05,NULL,NULL,1,'2024-06-22 18:15:24','2024-06-22 18:15:24',NULL),(2037,7705,40720,1539,3,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-17','2024-03-17',7999.65,NULL,NULL,1,'2024-06-22 18:20:37','2024-06-22 18:20:37',NULL);
INSERT INTO `balance_libro` VALUES (2038,7705,40720,1539,3,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-17','2024-03-17',39998.92,NULL,NULL,1,'2024-06-22 18:26:16','2024-06-22 18:26:16',NULL),(2039,7705,40720,1539,3,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',19999.69,NULL,NULL,1,'2024-06-22 18:27:22','2024-06-22 18:27:22',NULL),(2040,7705,40720,1539,3,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',9999.85,NULL,NULL,1,'2024-06-22 18:28:10','2024-06-22 18:28:10',NULL),(2041,7705,40720,1539,3,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',6000.01,NULL,NULL,1,'2024-06-22 18:29:52','2024-06-22 18:29:52',NULL),(2042,7705,40720,1539,3,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',104999.32,NULL,NULL,1,'2024-06-22 18:31:00','2024-06-22 18:31:00',NULL),(2043,7705,40720,1539,3,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',59999.97,NULL,NULL,1,'2024-06-22 18:33:36','2024-06-22 18:33:36',NULL),(2044,7705,40720,1539,3,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',4999.91,NULL,NULL,1,'2024-06-22 18:34:13','2024-06-22 18:34:13',NULL),(2045,7705,40720,1539,3,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',4999.44,NULL,NULL,1,'2024-06-22 18:35:13','2024-06-22 18:35:13',NULL),(2046,7705,40720,1539,3,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',9998.88,NULL,NULL,1,'2024-06-22 18:37:30','2024-06-22 18:37:30',NULL),(2047,7705,40720,1539,3,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',7000.12,NULL,NULL,1,'2024-06-22 18:38:47','2024-06-22 18:38:47',NULL),(2048,7705,40720,1539,3,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',9998.28,NULL,NULL,1,'2024-06-22 18:56:31','2024-06-22 18:56:31',NULL),(2049,7705,40720,1539,3,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',19999.69,NULL,NULL,1,'2024-06-22 18:57:08','2024-06-22 18:57:08',NULL),(2050,7705,40720,1539,3,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-21','2024-03-21',30001.55,NULL,NULL,1,'2024-06-22 18:58:06','2024-06-22 18:58:06',NULL),(2051,7705,40720,1539,3,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-21','2024-03-21',10000.43,NULL,NULL,1,'2024-06-22 19:00:05','2024-06-22 19:00:05',NULL),(2052,7705,40720,1539,3,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-21','2024-03-21',17000.04,NULL,NULL,1,'2024-06-22 19:00:57','2024-06-22 19:00:57',NULL),(2053,7705,40720,1539,3,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',29999.54,NULL,NULL,1,'2024-06-22 19:03:02','2024-06-22 19:03:02',NULL),(2054,7705,40720,1539,3,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',14998.33,NULL,NULL,1,'2024-06-22 19:05:17','2024-06-22 19:05:17',NULL),(2055,7705,40720,1539,3,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',5998.44,NULL,NULL,1,'2024-06-22 19:05:57','2024-06-22 19:05:57',NULL),(2056,7705,40720,1539,3,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',83000.58,NULL,NULL,1,'2024-06-22 19:06:53','2024-06-22 19:06:53',NULL),(2057,7705,40720,1539,3,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',4999.44,NULL,NULL,1,'2024-06-22 19:07:40','2024-06-22 19:07:40',NULL),(2058,7705,40720,1539,3,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-23','2024-03-23',8000.89,NULL,NULL,1,'2024-06-22 19:08:19','2024-06-22 19:08:19',NULL);
INSERT INTO `balance_libro` VALUES (2059,7705,40720,1539,3,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-23','2024-03-23',5000.24,NULL,NULL,1,'2024-06-22 19:10:02','2024-06-22 19:10:02',NULL),(2060,7705,40720,1539,3,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-24','2024-03-24',8001.88,NULL,NULL,1,'2024-06-22 19:11:02','2024-06-22 19:11:02',NULL),(2061,7705,40720,1539,3,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-24','2024-03-24',14996.60,NULL,NULL,1,'2024-06-22 19:12:26','2024-06-22 19:12:26',NULL),(2062,7705,40720,1539,3,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-24','2024-03-24',5998.44,NULL,NULL,1,'2024-06-22 19:13:15','2024-06-22 19:13:15',NULL),(2063,7705,40720,1539,3,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',71002.99,NULL,NULL,1,'2024-06-22 19:13:57','2024-06-22 19:13:57',NULL),(2064,7705,40720,1539,3,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',5999.73,NULL,NULL,1,'2024-06-22 19:14:46','2024-06-22 19:14:46',NULL),(2065,7705,40720,1539,3,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',10000.43,NULL,NULL,1,'2024-06-22 19:16:27','2024-06-22 19:16:27',NULL),(2066,7705,40720,1539,3,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',5998.44,NULL,NULL,1,'2024-06-22 19:17:58','2024-06-22 19:17:58',NULL),(2067,7705,40720,1539,3,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',64999.98,NULL,NULL,1,'2024-06-22 19:19:42','2024-06-22 19:19:42',NULL),(2068,7705,40720,1539,3,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',9999.85,NULL,NULL,1,'2024-06-22 19:20:41','2024-06-22 19:20:41',NULL),(2069,7705,40720,1539,3,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',10000.43,NULL,NULL,1,'2024-06-22 19:21:51','2024-06-22 19:21:51',NULL),(2070,7705,40720,1539,3,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',76001.68,NULL,NULL,1,'2024-06-22 19:22:42','2024-06-22 19:22:42',NULL),(2071,7705,40720,1539,3,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',6997.88,NULL,NULL,1,'2024-06-22 19:23:19','2024-06-22 19:23:19',NULL),(2072,7705,40720,1539,3,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',9999.85,NULL,NULL,1,'2024-06-22 19:24:01','2024-06-22 19:24:01',NULL),(2073,7705,40720,1539,3,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',14999.29,NULL,NULL,1,'2024-06-22 19:26:02','2024-06-22 19:26:02',NULL),(2074,7705,40720,1539,3,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',14999.76,NULL,NULL,1,'2024-06-22 23:09:40','2024-06-22 23:09:40',NULL),(2075,7705,40720,1539,3,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',85510.11,NULL,NULL,1,'2024-06-22 23:10:36','2024-06-22 23:10:36',NULL),(2076,7705,40720,1539,3,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',39998.92,NULL,NULL,1,'2024-06-22 23:11:17','2024-06-22 23:11:17',NULL),(2077,7705,40720,1539,3,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',133010.37,NULL,NULL,1,'2024-06-22 23:12:05','2024-06-22 23:12:05',NULL),(2078,7705,40720,1539,3,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',72611.27,NULL,NULL,1,'2024-06-22 23:13:03','2024-06-22 23:13:03',NULL),(2079,7705,40720,1539,3,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',125080.63,NULL,NULL,1,'2024-06-22 23:14:04','2024-06-22 23:14:04',NULL);
INSERT INTO `balance_libro` VALUES (2080,7705,40720,1539,3,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',15200.01,NULL,NULL,1,'2024-06-22 23:15:11','2024-06-22 23:15:11',NULL),(2081,7705,40720,1539,3,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',19000.00,NULL,NULL,1,'2024-06-22 23:16:22','2024-06-22 23:16:22',NULL),(2082,7705,40720,1539,3,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',5600.00,NULL,NULL,1,'2024-06-22 23:18:10','2024-06-22 23:18:10',NULL),(2083,7705,40720,1539,3,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',10400.00,NULL,NULL,1,'2024-06-22 23:18:45','2024-06-22 23:18:45',NULL),(2084,7705,40720,1539,3,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',19000.00,NULL,NULL,1,'2024-06-22 23:19:36','2024-06-22 23:19:36',NULL),(2085,7705,40720,1539,3,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',4803.70,NULL,NULL,1,'2024-06-22 23:31:09','2024-06-22 23:31:09',NULL),(2086,7705,40720,1539,3,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',8034.40,NULL,NULL,1,'2024-06-22 23:32:21','2024-06-22 23:32:21',NULL),(2087,7705,40720,1539,3,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',7101.82,NULL,NULL,1,'2024-06-22 23:35:03','2024-06-22 23:35:03',NULL),(2088,7705,40720,1539,3,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',5163.97,NULL,NULL,1,'2024-07-05 13:42:29','2024-07-05 13:42:29',NULL),(2089,7705,40720,1539,3,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',8000.36,NULL,NULL,1,'2024-07-05 13:44:05','2024-07-05 13:44:05',NULL),(2090,7705,40720,1539,3,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',9998.88,NULL,NULL,1,'2024-07-05 13:45:18','2024-07-05 13:45:18',NULL),(2091,7705,40720,1539,3,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',10000.40,NULL,NULL,1,'2024-07-05 13:46:26','2024-07-05 13:46:26',NULL),(2092,7705,40720,1539,3,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',5000.20,NULL,NULL,1,'2024-07-05 13:47:38','2024-07-05 13:47:38',NULL),(2093,7705,40720,1539,3,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',10000.40,NULL,NULL,1,'2024-07-05 13:48:29','2024-07-05 13:48:29',NULL),(2094,7705,40720,1539,3,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',10001.32,NULL,NULL,1,'2024-07-05 13:49:25','2024-07-05 13:49:25',NULL),(2095,7705,40720,1539,3,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',10000.40,NULL,NULL,1,'2024-07-05 13:50:21','2024-07-05 13:50:21',NULL),(2096,7705,40720,1539,3,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-29','2024-03-29',5000.19,NULL,NULL,1,'2024-07-05 13:51:31','2024-07-05 13:51:31',NULL),(2097,7705,40720,1540,3,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',131504.47,NULL,NULL,1,'2024-07-24 19:59:16','2024-07-24 19:59:16',NULL),(2098,7705,40720,1540,3,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-02','2024-04-02',7001.21,NULL,NULL,1,'2024-07-24 20:01:51','2024-07-24 20:01:51',NULL),(2099,7705,40720,1540,3,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-02','2024-04-02',45319.00,NULL,NULL,1,'2024-07-24 20:04:15','2024-07-24 20:04:15',NULL),(2100,7705,40720,1540,3,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',91499.96,NULL,NULL,1,'2024-07-24 20:05:26','2024-07-24 20:05:26',NULL);
INSERT INTO `balance_libro` VALUES (2101,7705,40720,1540,3,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',86998.98,NULL,NULL,1,'2024-07-24 20:07:29','2024-07-24 20:07:29',NULL),(2102,7705,40720,1540,3,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',7001.21,NULL,NULL,1,'2024-07-24 20:08:40','2024-07-24 20:08:40',NULL),(2103,7705,40720,1540,3,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',10000.40,NULL,NULL,1,'2024-07-24 20:09:30','2024-07-24 20:09:30',NULL),(2104,7705,40720,1540,3,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',13998.38,NULL,NULL,1,'2024-07-24 20:10:32','2024-07-24 20:10:32',NULL),(2105,7705,40720,1540,3,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',8000.39,NULL,NULL,1,'2024-07-24 20:12:03','2024-07-24 20:12:03',NULL),(2106,7705,40720,1540,3,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',19997.71,NULL,NULL,1,'2024-07-24 20:14:10','2024-07-24 20:14:10',NULL),(2107,7705,40720,1540,3,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',13998.38,NULL,NULL,1,'2024-07-24 20:14:53','2024-07-24 20:14:53',NULL),(2108,7705,40720,1540,3,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',40002.31,NULL,NULL,1,'2024-07-24 20:16:09','2024-07-24 20:16:09',NULL),(2109,7705,40720,1540,3,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',10000.06,NULL,NULL,1,'2024-07-24 20:17:09','2024-07-24 20:17:09',NULL),(2110,7705,40720,1540,3,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-06','2024-04-06',5998.40,NULL,NULL,1,'2024-07-24 20:19:03','2024-07-24 20:19:03',NULL),(2111,7705,40720,1540,3,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-06','2024-04-06',111222.34,NULL,NULL,1,'2024-07-24 20:30:56','2024-07-24 20:30:56',NULL),(2112,7705,40720,1540,3,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-06','2024-04-06',5998.40,NULL,NULL,1,'2024-07-24 20:32:01','2024-07-24 20:32:01',NULL),(2113,7705,40720,1540,3,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-06','2024-04-06',131807.42,NULL,NULL,1,'2024-07-24 20:33:03','2024-07-24 20:33:03',NULL),(2114,7705,40720,1540,3,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-07','2024-04-07',30000.02,NULL,NULL,1,'2024-07-24 20:34:40','2024-07-24 20:34:40',NULL),(2115,7705,40720,1540,3,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-07','2024-04-07',10000.40,NULL,NULL,1,'2024-07-24 20:35:30','2024-07-24 20:35:30',NULL),(2116,7705,40720,1540,3,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',9998.85,NULL,NULL,1,'2024-07-24 20:42:12','2024-07-24 20:42:12',NULL),(2117,7705,40720,1540,3,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',10000.40,NULL,NULL,1,'2024-07-24 20:43:08','2024-07-24 20:43:08',NULL),(2118,7705,40720,1540,3,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',17997.95,NULL,NULL,1,'2024-07-24 20:44:51','2024-07-24 20:44:51',NULL),(2119,7705,40720,1540,3,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',15998.80,NULL,NULL,1,'2024-07-25 09:22:59','2024-07-25 09:22:59',NULL),(2120,7705,40720,1540,3,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',21998.54,NULL,NULL,1,'2024-07-25 09:24:20','2024-07-25 09:24:20',NULL),(2121,7705,40720,1540,3,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',10000.01,NULL,NULL,1,'2024-07-25 09:25:16','2024-07-25 09:25:16',NULL);
INSERT INTO `balance_libro` VALUES (2122,7705,40720,1540,3,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',61998.69,NULL,NULL,1,'2024-07-25 09:26:01','2024-07-25 09:26:01',NULL),(2123,7705,40720,1540,3,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',122011.73,NULL,NULL,1,'2024-07-25 09:26:46','2024-07-25 09:26:46',NULL),(2124,7705,40720,1540,3,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',10000.40,NULL,NULL,1,'2024-07-25 09:27:43','2024-07-25 09:27:43',NULL),(2125,7705,40720,1540,3,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',10000.40,NULL,NULL,1,'2024-07-25 09:28:24','2024-07-25 09:28:24',NULL),(2126,7705,40720,1540,3,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',59399.78,NULL,NULL,1,'2024-07-25 09:30:22','2024-07-25 09:30:22',NULL),(2127,7705,40720,1540,3,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-11','2024-04-11',10000.01,NULL,NULL,1,'2024-07-25 09:31:11','2024-07-25 09:31:11',NULL),(2128,7705,40720,1540,3,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-11','2024-04-11',34996.21,NULL,NULL,1,'2024-07-25 09:32:39','2024-07-25 09:32:39',NULL),(2129,7705,40720,1540,3,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-11','2024-04-11',10000.40,NULL,NULL,1,'2024-07-25 09:35:07','2024-07-25 09:35:07',NULL),(2130,7705,40720,1540,3,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-11','2024-04-11',40002.81,NULL,NULL,1,'2024-07-25 09:36:21','2024-07-25 09:36:21',NULL),(2131,7705,40720,1540,3,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',10000.40,NULL,NULL,1,'2024-07-25 09:37:17','2024-07-25 09:37:17',NULL),(2132,7705,40720,1540,3,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',19997.71,NULL,NULL,1,'2024-07-25 09:38:08','2024-07-25 09:38:08',NULL),(2133,7705,40720,1540,3,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',75997.52,NULL,NULL,1,'2024-07-25 09:39:35','2024-07-25 09:39:35',NULL),(2134,7705,40720,1540,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',9998.85,NULL,NULL,1,'2024-07-25 09:41:31','2024-07-25 09:41:31',NULL),(2135,7705,40720,1540,3,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',10000.01,NULL,NULL,1,'2024-07-25 10:03:29','2024-07-25 10:03:29',NULL),(2136,7705,40720,1540,3,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',24999.97,NULL,NULL,1,'2024-07-25 10:05:04','2024-07-25 10:05:04',NULL),(2137,7705,40720,1540,3,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',14998.29,NULL,NULL,1,'2024-07-25 10:06:22','2024-07-25 10:06:22',NULL),(2138,7705,40720,1540,3,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',150016.85,NULL,NULL,1,'2024-07-25 10:07:54','2024-07-25 10:07:54',NULL),(2139,7705,40720,1540,3,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-14','2024-04-14',34997.71,NULL,NULL,1,'2024-07-25 10:09:27','2024-07-25 10:09:27',NULL),(2140,7705,40720,1540,3,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-14','2024-04-14',20000.01,NULL,NULL,1,'2024-07-25 10:10:54','2024-07-25 10:10:54',NULL),(2141,7705,40720,1540,3,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-14','2024-04-14',10000.40,NULL,NULL,1,'2024-07-25 10:15:03','2024-07-25 10:15:03',NULL),(2142,7705,40720,1540,3,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',140511.62,NULL,NULL,1,'2024-07-25 10:17:06','2024-07-25 10:17:06',NULL);
INSERT INTO `balance_libro` VALUES (2143,7705,40720,1540,3,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',5000.19,NULL,NULL,1,'2024-07-25 10:19:29','2024-07-25 10:19:29',NULL),(2144,7705,40720,1540,3,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',10001.60,NULL,NULL,1,'2024-07-25 10:21:36','2024-07-25 10:21:36',NULL),(2145,7705,40720,1540,3,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',20000.01,NULL,NULL,1,'2024-07-25 10:28:51','2024-07-25 10:28:51',NULL),(2146,7705,40720,1540,3,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',9998.85,NULL,NULL,1,'2024-07-25 10:30:13','2024-07-25 10:30:13',NULL),(2147,7705,40720,1540,3,2046,'App\\Models\\Receipt',2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',70003.39,NULL,NULL,1,'2024-07-25 10:31:21','2024-07-25 10:31:21',NULL),(2148,7705,40720,1540,3,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',41000.54,NULL,NULL,1,'2024-07-25 10:37:52','2024-07-25 10:37:52',NULL),(2149,7705,40720,1540,3,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',102879.54,NULL,NULL,1,'2024-07-25 10:38:59','2024-07-25 10:38:59',NULL),(2150,7705,40720,1540,3,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',29999.62,NULL,NULL,1,'2024-07-25 10:40:08','2024-07-25 10:40:08',NULL),(2151,7705,40720,1540,3,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',8000.03,NULL,NULL,1,'2024-07-25 10:42:28','2024-07-25 10:42:28',NULL),(2152,7705,40720,1540,3,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',7999.40,NULL,NULL,1,'2024-07-25 10:43:18','2024-07-25 10:43:18',NULL),(2153,7705,40720,1540,3,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',126007.31,NULL,NULL,1,'2024-07-25 10:44:06','2024-07-25 10:44:06',NULL),(2154,7705,40720,1540,3,2053,'App\\Models\\Receipt',2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-19','2024-04-19',45000.09,NULL,NULL,1,'2024-07-25 10:44:49','2024-07-25 10:44:49',NULL),(2155,7705,40720,1540,3,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-19','2024-04-19',9998.85,NULL,NULL,1,'2024-07-25 10:45:34','2024-07-25 10:45:34',NULL),(2156,7705,40720,1540,3,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-19','2024-04-19',9998.85,NULL,NULL,1,'2024-07-25 10:46:15','2024-07-25 10:46:15',NULL),(2157,7705,40720,1540,3,2056,'App\\Models\\Receipt',2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-19','2024-04-19',19997.71,NULL,NULL,1,'2024-07-25 10:46:55','2024-07-25 10:46:55',NULL),(2158,7705,40720,1540,3,2057,'App\\Models\\Receipt',2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-20','2024-04-20',54435.65,NULL,NULL,1,'2024-07-25 10:48:16','2024-07-25 10:48:16',NULL),(2159,7705,40720,1540,3,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-20','2024-04-20',5000.19,NULL,NULL,1,'2024-07-25 10:48:58','2024-07-25 10:48:58',NULL),(2160,7705,40720,1540,3,2059,'App\\Models\\Receipt',2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-21','2024-04-21',12998.51,NULL,NULL,1,'2024-07-25 10:51:02','2024-07-25 10:51:02',NULL),(2161,7705,40720,1540,3,2060,'App\\Models\\Receipt',2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-21','2024-04-21',30000.07,NULL,NULL,1,'2024-07-25 10:51:45','2024-07-25 10:51:45',NULL),(2162,7705,40720,1540,3,2061,'App\\Models\\Receipt',2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-21','2024-04-21',68868.61,NULL,NULL,1,'2024-07-25 10:52:34','2024-07-25 10:52:34',NULL),(2163,7705,40720,1540,3,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-21','2024-04-21',10000.02,NULL,NULL,1,'2024-07-25 10:53:52','2024-07-25 10:53:52',NULL);
INSERT INTO `balance_libro` VALUES (2164,7705,40720,1540,3,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',43994.96,NULL,NULL,1,'2024-07-25 10:55:09','2024-07-25 10:55:09',NULL),(2165,7705,40720,1540,3,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',34997.57,NULL,NULL,1,'2024-07-25 10:57:22','2024-07-25 10:57:22',NULL),(2166,7705,40720,1540,3,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',15000.60,NULL,NULL,1,'2024-07-25 17:40:03','2024-07-25 17:40:03',NULL),(2167,7705,40720,1540,3,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',88139.28,NULL,NULL,1,'2024-07-25 17:40:53','2024-07-25 17:40:53',NULL),(2168,7705,40720,1540,3,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',69871.38,NULL,NULL,1,'2024-07-25 17:42:06','2024-07-25 17:42:06',NULL),(2169,7705,40720,1540,3,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',35001.39,NULL,NULL,1,'2024-07-25 17:42:59','2024-07-25 17:42:59',NULL),(2170,7705,40720,1540,3,2069,'App\\Models\\Receipt',2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',10000.40,NULL,NULL,1,'2024-07-25 17:44:00','2024-07-25 17:44:00',NULL),(2171,7705,40720,1540,3,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',5998.40,NULL,NULL,1,'2024-07-25 17:44:42','2024-07-25 17:44:42',NULL),(2172,7705,40720,1540,3,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',29996.56,NULL,NULL,1,'2024-07-25 17:45:33','2024-07-25 17:45:33',NULL),(2173,7705,40720,1540,3,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-25','2024-04-25',9998.85,NULL,NULL,1,'2024-07-25 17:47:57','2024-07-25 17:47:57',NULL),(2174,7705,40720,1540,3,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-25','2024-04-25',69004.67,NULL,NULL,1,'2024-07-25 17:48:52','2024-07-25 17:48:52',NULL),(2175,7705,40720,1540,3,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-25','2024-04-25',14998.29,NULL,NULL,1,'2024-07-25 17:49:43','2024-07-25 17:49:43',NULL),(2176,7705,40720,1540,3,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',9998.85,NULL,NULL,1,'2024-07-25 17:50:50','2024-07-25 17:50:50',NULL),(2177,7705,40720,1540,3,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-27','2024-04-27',132021.20,NULL,NULL,1,'2024-07-25 17:52:00','2024-07-25 17:52:00',NULL),(2178,7705,40720,1540,3,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-28','2024-04-28',37027.39,NULL,NULL,1,'2024-07-25 17:53:17','2024-07-25 17:53:17',NULL),(2179,7705,40720,1540,3,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-28','2024-04-28',9998.85,NULL,NULL,1,'2024-07-25 17:54:07','2024-07-25 17:54:07',NULL),(2180,7705,40720,1540,3,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',9998.85,NULL,NULL,1,'2024-07-25 17:55:08','2024-07-25 17:55:08',NULL),(2181,7705,40720,1540,3,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',96001.59,NULL,NULL,1,'2024-07-25 17:56:56','2024-07-25 17:56:56',NULL),(2182,7705,40720,1540,3,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',14998.29,NULL,NULL,1,'2024-07-25 17:58:08','2024-07-25 17:58:08',NULL),(2183,7705,40720,1540,3,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',30001.18,NULL,NULL,1,'2024-07-25 17:59:08','2024-07-25 17:59:08',NULL),(2184,7705,40720,1540,3,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',11200.00,NULL,NULL,1,'2024-07-25 18:01:44','2024-07-25 18:01:44',NULL);
INSERT INTO `balance_libro` VALUES (2185,7705,40720,1540,3,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',3000.00,NULL,NULL,1,'2024-07-25 18:10:56','2024-07-25 18:10:56',NULL),(2186,7705,40720,1540,3,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-11','2024-04-11',24600.00,NULL,NULL,1,'2024-07-25 18:11:53','2024-07-25 18:11:53',NULL),(2187,7705,40720,1540,3,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',1680000.01,NULL,NULL,1,'2024-07-25 18:13:45','2024-07-25 18:13:45',NULL),(2188,7705,40720,1540,3,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',9600.02,NULL,NULL,1,'2024-07-25 18:14:47','2024-07-25 18:14:47',NULL),(2189,7705,40720,1540,3,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',11300.01,NULL,NULL,1,'2024-07-25 18:15:31','2024-07-25 18:15:31',NULL),(2190,7705,40720,1540,3,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',11300.01,NULL,NULL,1,'2024-07-25 18:16:18','2024-07-25 18:16:18',NULL),(2191,7705,40720,1541,3,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',130005.27,NULL,NULL,1,'2024-07-26 20:47:55','2024-07-26 20:47:55',NULL),(2192,7705,40720,1541,3,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',20001.60,NULL,NULL,1,'2024-07-26 20:48:54','2024-07-26 20:48:54',NULL),(2193,7705,40720,1541,3,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',30001.92,NULL,NULL,1,'2024-07-26 20:49:43','2024-07-26 20:49:43',NULL),(2194,7705,40720,1541,3,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',72806.55,NULL,NULL,1,'2024-07-26 20:50:35','2024-07-26 20:50:35',NULL),(2195,7705,40720,1541,3,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',20001.60,NULL,NULL,1,'2024-07-26 20:51:19','2024-07-26 20:51:19',NULL),(2196,7705,40720,1541,3,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',48000.07,NULL,NULL,1,'2024-07-26 20:52:07','2024-07-26 20:52:07',NULL),(2197,7705,40720,1541,3,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-05','2024-05-05',24999.98,NULL,NULL,1,'2024-07-26 20:53:01','2024-07-26 20:53:01',NULL),(2198,7705,40720,1541,3,2097,'App\\Models\\Receipt',2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',70000.40,NULL,NULL,1,'2024-07-26 20:53:50','2024-07-26 20:53:50',NULL),(2199,7705,40720,1541,3,2098,'App\\Models\\Receipt',2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',15006.62,NULL,NULL,1,'2024-07-26 20:54:32','2024-07-26 20:54:32',NULL),(2200,7705,40720,1541,3,2099,'App\\Models\\Receipt',2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',45020.85,NULL,NULL,1,'2024-07-26 20:55:14','2024-07-26 20:55:14',NULL),(2201,7705,40720,1541,3,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',85000.00,NULL,NULL,1,'2024-07-26 20:56:05','2024-07-26 20:56:05',NULL),(2202,7705,40720,1541,3,2101,'App\\Models\\Receipt',2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',94999.98,NULL,NULL,1,'2024-07-26 20:56:47','2024-07-26 20:56:47',NULL),(2203,7705,40720,1541,3,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',94999.95,NULL,NULL,1,'2024-07-26 20:57:33','2024-07-26 20:57:33',NULL),(2204,7705,40720,1541,3,2103,'App\\Models\\Receipt',2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',30001.70,NULL,NULL,1,'2024-07-26 20:58:19','2024-07-26 20:58:19',NULL),(2205,7705,40720,1541,3,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',15001.22,NULL,NULL,1,'2024-07-26 20:59:11','2024-07-26 20:59:11',NULL);
INSERT INTO `balance_libro` VALUES (2206,7705,40720,1541,3,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',56001.17,NULL,NULL,1,'2024-07-26 21:00:31','2024-07-26 21:00:31',NULL),(2207,7705,40720,1541,3,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',10004.49,NULL,NULL,1,'2024-07-26 21:01:52','2024-07-26 21:01:52',NULL),(2208,7705,40720,1541,3,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',10000.32,NULL,NULL,1,'2024-07-26 21:03:02','2024-07-26 21:03:02',NULL),(2209,7705,40720,1541,3,2108,'App\\Models\\Receipt',2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-09','2024-05-09',71008.00,NULL,NULL,1,'2024-07-26 21:05:00','2024-07-26 21:05:00',NULL),(2210,7705,40720,1541,3,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',96008.54,NULL,NULL,1,'2024-07-26 21:06:08','2024-07-26 21:06:08',NULL),(2211,7705,40720,1541,3,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',20003.77,NULL,NULL,1,'2024-07-26 21:07:07','2024-07-26 21:07:07',NULL),(2212,7705,40720,1541,3,2111,'App\\Models\\Receipt',2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-11','2024-05-11',15001.22,NULL,NULL,1,'2024-07-26 21:08:02','2024-07-26 21:08:02',NULL),(2213,7705,40720,1541,3,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-12','2024-05-12',15001.22,NULL,NULL,1,'2024-07-26 21:09:34','2024-07-26 21:09:34',NULL),(2214,7705,40720,1541,3,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-12','2024-05-12',6998.42,NULL,NULL,1,'2024-07-26 21:10:09','2024-07-26 21:10:09',NULL),(2215,7705,40720,1541,3,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',97003.30,NULL,NULL,1,'2024-07-26 21:10:53','2024-07-26 21:10:53',NULL),(2216,7705,40720,1541,3,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',81606.20,NULL,NULL,1,'2024-07-26 21:11:32','2024-07-26 21:11:32',NULL),(2217,7705,40720,1541,3,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',108212.49,NULL,NULL,1,'2024-07-26 21:12:21','2024-07-26 21:12:21',NULL),(2218,7705,40720,1541,3,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',10000.32,NULL,NULL,1,'2024-07-26 21:13:04','2024-07-26 21:13:04',NULL),(2219,7705,40720,1541,3,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',24999.98,NULL,NULL,1,'2024-07-26 21:13:58','2024-07-26 21:13:58',NULL),(2220,7705,40720,1541,3,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',30001.95,NULL,NULL,1,'2024-07-26 21:14:47','2024-07-26 21:14:47',NULL),(2221,7705,40720,1541,3,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',20001.63,NULL,NULL,1,'2024-07-27 20:18:44','2024-07-27 20:18:44',NULL),(2222,7705,40720,1541,3,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',40001.76,NULL,NULL,1,'2024-07-27 20:19:42','2024-07-27 20:19:42',NULL),(2223,7705,40720,1541,3,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-18','2024-05-18',16999.23,NULL,NULL,1,'2024-07-27 20:20:29','2024-07-27 20:20:29',NULL),(2224,7705,40720,1541,3,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-19','2024-05-19',83000.21,NULL,NULL,1,'2024-07-27 20:22:18','2024-07-27 20:22:18',NULL),(2225,7705,40720,1541,3,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-19','2024-05-19',40007.65,NULL,NULL,1,'2024-07-27 20:23:29','2024-07-27 20:23:29',NULL),(2226,7705,40720,1541,3,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-19','2024-05-19',42478.71,NULL,NULL,1,'2024-07-27 20:24:23','2024-07-27 20:24:23',NULL);
INSERT INTO `balance_libro` VALUES (2227,7705,40720,1541,3,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-19','2024-05-19',66420.99,NULL,NULL,1,'2024-07-27 20:27:15','2024-07-27 20:27:15',NULL),(2228,7705,40720,1541,3,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',57000.79,NULL,NULL,1,'2024-07-27 20:28:25','2024-07-27 20:28:25',NULL),(2229,7705,40720,1541,3,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',72013.10,NULL,NULL,1,'2024-07-27 20:29:18','2024-07-27 20:29:18',NULL),(2230,7705,40720,1541,3,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',64001.48,NULL,NULL,1,'2024-07-27 20:30:38','2024-07-27 20:30:38',NULL),(2231,7705,40720,1541,3,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',23490.82,NULL,NULL,1,'2024-07-27 20:40:54','2024-07-27 20:40:54',NULL),(2232,7705,40720,1541,3,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',97502.89,NULL,NULL,1,'2024-07-27 20:42:15','2024-07-27 20:42:15',NULL),(2233,7705,40720,1541,3,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',95007.83,NULL,NULL,1,'2024-07-27 20:46:16','2024-07-27 20:46:16',NULL),(2234,7705,40720,1541,3,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-25','2024-05-25',107508.07,NULL,NULL,1,'2024-07-27 20:47:15','2024-07-27 20:47:15',NULL),(2235,7705,40720,1541,3,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-26','2024-05-26',29201.22,NULL,NULL,1,'2024-07-27 20:48:21','2024-07-27 20:48:21',NULL),(2236,7705,40720,1541,3,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-26','2024-05-26',61370.20,NULL,NULL,1,'2024-07-27 20:49:13','2024-07-27 20:49:13',NULL),(2237,7705,40720,1541,3,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',29999.96,NULL,NULL,1,'2024-07-27 20:51:03','2024-07-27 20:51:03',NULL),(2238,7705,40720,1541,3,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',30000.02,NULL,NULL,1,'2024-07-27 20:51:53','2024-07-27 20:51:53',NULL),(2239,7705,40720,1541,3,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',46007.56,NULL,NULL,1,'2024-07-27 20:52:41','2024-07-27 20:52:41',NULL),(2240,7705,40720,1541,3,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',100517.91,NULL,NULL,1,'2024-07-27 20:53:44','2024-07-27 20:53:44',NULL),(2241,7705,40720,1541,3,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',25001.90,NULL,NULL,1,'2024-07-27 20:54:48','2024-07-27 20:54:48',NULL),(2242,7705,40720,1541,3,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',25999.87,NULL,NULL,1,'2024-07-27 20:56:06','2024-07-27 20:56:06',NULL),(2243,7705,40720,1541,3,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',10000.81,NULL,NULL,1,'2024-07-27 21:01:55','2024-07-27 21:01:55',NULL),(2244,7705,40720,1541,3,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',6998.42,NULL,NULL,1,'2024-07-27 21:02:46','2024-07-27 21:02:46',NULL),(2245,7705,40720,1541,3,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',126006.00,NULL,NULL,1,'2024-07-27 21:03:35','2024-07-27 21:03:35',NULL),(2246,7705,40720,1541,3,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',10000.81,NULL,NULL,1,'2024-07-27 21:04:30','2024-07-27 21:04:30',NULL),(2247,7705,40720,1541,3,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',5600.00,NULL,NULL,1,'2024-07-27 21:05:52','2024-07-27 21:16:02','2024-07-27 21:16:02');
INSERT INTO `balance_libro` VALUES (2248,7705,40720,1541,3,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',223327.68,NULL,NULL,1,'2024-07-27 21:10:34','2024-07-27 21:15:45','2024-07-27 21:15:45'),(2249,7705,40720,1541,3,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',4800.00,NULL,NULL,1,'2024-07-27 21:11:42','2024-07-27 21:15:27','2024-07-27 21:15:27'),(2250,7705,40720,1541,3,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',312500.00,NULL,NULL,1,'2024-07-27 21:12:47','2024-07-27 21:15:07','2024-07-27 21:15:07'),(2251,7705,40720,1541,3,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',40000.08,NULL,NULL,1,'2024-07-27 21:13:51','2024-07-27 21:13:51',NULL),(2252,7705,40720,1541,3,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',312500.00,NULL,NULL,1,'2024-07-27 21:15:07','2024-07-27 21:15:07',NULL),(2253,7705,40720,1541,3,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',4800.00,NULL,NULL,1,'2024-07-27 21:15:27','2024-07-27 21:15:27',NULL),(2254,7705,40720,1541,3,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',223327.68,NULL,NULL,1,'2024-07-27 21:15:45','2024-07-27 21:15:45',NULL),(2255,7705,40720,1541,3,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',5600.00,NULL,NULL,1,'2024-07-27 21:16:02','2024-07-27 21:16:02',NULL),(2256,7705,40720,1541,3,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-26','2024-05-26',9900.00,NULL,NULL,1,'2024-07-28 07:44:06','2024-07-28 07:44:06',NULL),(2257,7705,40720,1541,3,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',13158.75,NULL,NULL,1,'2024-07-28 07:45:18','2024-07-28 07:45:18',NULL),(2258,7705,40720,1542,3,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',19997.70,NULL,NULL,1,'2024-08-31 13:01:04','2024-08-31 13:01:04',NULL),(2259,7705,40720,1542,3,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',19999.32,NULL,NULL,1,'2024-08-31 13:02:21','2024-08-31 13:02:21',NULL),(2260,7705,40720,1542,3,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',30001.77,NULL,NULL,1,'2024-08-31 13:15:31','2024-08-31 13:15:31',NULL),(2261,7705,40720,1542,3,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-06','2024-06-06',81451.91,NULL,NULL,1,'2024-08-31 13:17:47','2024-08-31 13:17:47',NULL),(2262,7705,40720,1542,3,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',10002.45,NULL,NULL,1,'2024-08-31 13:18:54','2024-08-31 13:18:54',NULL),(2263,7705,40720,1542,3,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',30001.76,NULL,NULL,1,'2024-08-31 13:19:31','2024-08-31 13:19:31',NULL),(2264,7705,40720,1542,3,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',19648.42,NULL,NULL,1,'2024-08-31 13:20:19','2024-08-31 13:20:19',NULL),(2265,7705,40720,1542,3,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',29999.32,NULL,NULL,1,'2024-08-31 13:21:14','2024-08-31 13:21:14',NULL),(2266,7705,40720,1542,3,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',9999.65,NULL,NULL,1,'2024-08-31 13:22:05','2024-08-31 13:22:05',NULL),(2267,7705,40720,1542,3,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',40001.76,NULL,NULL,1,'2024-08-31 13:23:13','2024-08-31 13:23:13',NULL);
INSERT INTO `balance_libro` VALUES (2268,7705,40720,1542,3,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',19999.32,NULL,NULL,1,'2024-08-31 13:24:01','2024-08-31 13:24:01',NULL),(2269,7705,40720,1542,3,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',143255.66,NULL,NULL,1,'2024-08-31 13:25:03','2024-08-31 13:25:03',NULL),(2270,7705,40720,1542,3,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',115984.11,NULL,NULL,1,'2024-08-31 13:25:53','2024-08-31 13:25:53',NULL),(2271,7705,40720,1542,3,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',7000.05,NULL,NULL,1,'2024-08-31 13:26:47','2024-08-31 13:26:47',NULL),(2272,7705,40720,1542,3,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',9999.65,NULL,NULL,1,'2024-08-31 13:27:32','2024-08-31 13:27:32',NULL),(2273,7705,40720,1542,3,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',20000.00,NULL,NULL,1,'2024-08-31 13:28:45','2024-08-31 13:28:45',NULL),(2274,7705,40720,1542,3,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',24997.76,NULL,NULL,1,'2024-08-31 13:29:51','2024-08-31 13:29:51',NULL),(2275,7705,40720,1542,3,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-06','2024-06-06',30002.71,NULL,NULL,1,'2024-09-23 10:16:37','2024-09-23 10:16:37',NULL),(2276,7705,40720,1542,3,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',10002.45,NULL,NULL,1,'2024-09-23 10:17:49','2024-09-23 10:17:49',NULL),(2277,7705,40720,1542,3,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',10004.66,NULL,NULL,1,'2024-09-23 10:18:40','2024-09-23 10:18:40',NULL),(2278,7705,40720,1542,3,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',73004.64,NULL,NULL,1,'2024-09-23 10:19:22','2024-09-23 10:19:22',NULL),(2279,7705,40720,1542,3,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',10002.45,NULL,NULL,1,'2024-09-23 10:20:07','2024-09-23 10:20:07',NULL),(2280,7705,40720,1542,3,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',10001.89,NULL,NULL,1,'2024-09-23 10:39:37','2024-09-23 10:39:37',NULL),(2281,7705,40720,1542,3,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-15','2024-06-15',80002.45,NULL,NULL,1,'2024-09-23 10:40:24','2024-09-23 10:40:24',NULL),(2282,7705,40720,1542,3,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-15','2024-06-15',74003.01,NULL,NULL,1,'2024-09-23 10:41:12','2024-09-23 10:41:12',NULL),(2283,7705,40720,1542,3,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-15','2024-06-15',77003.60,NULL,NULL,1,'2024-09-23 10:42:40','2024-09-23 10:42:40',NULL),(2284,7705,40720,1542,3,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-16','2024-06-16',59997.88,NULL,NULL,1,'2024-09-23 10:43:51','2024-09-23 10:43:51',NULL),(2285,7705,40720,1542,3,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-17','2024-06-17',18782.25,NULL,NULL,1,'2024-09-23 10:44:52','2024-09-23 10:44:52',NULL),(2286,7705,40720,1542,3,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-17','2024-06-17',23001.72,NULL,NULL,1,'2024-09-23 10:45:47','2024-09-23 10:45:47',NULL),(2287,7705,40720,1542,3,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',24997.76,NULL,NULL,1,'2024-09-23 10:46:28','2024-09-23 10:46:28',NULL),(2288,7705,40720,1542,3,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',40004.22,NULL,NULL,1,'2024-09-23 10:47:12','2024-09-23 10:47:12',NULL);
INSERT INTO `balance_libro` VALUES (2289,7705,40720,1542,2,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-20','2024-06-20',14999.99,NULL,NULL,1,'2024-09-23 11:48:14','2024-09-23 11:48:14',NULL),(2290,7705,40720,1542,2,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-20','2024-06-20',10001.40,NULL,NULL,1,'2024-09-23 11:50:16','2024-09-23 11:50:16',NULL),(2291,7705,40720,1542,2,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-21','2024-06-21',10002.45,NULL,NULL,1,'2024-09-23 11:55:32','2024-09-23 11:55:32',NULL),(2292,7705,40720,1542,2,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-22','2024-06-22',40001.38,NULL,NULL,1,'2024-09-23 11:56:34','2024-09-23 11:56:34',NULL),(2293,7705,40720,1542,2,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-23','2024-06-23',103592.49,NULL,NULL,1,'2024-09-23 11:57:24','2024-09-23 11:57:24',NULL),(2294,7705,40720,1542,2,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-25','2024-06-25',131722.68,NULL,NULL,1,'2024-09-23 12:00:35','2024-09-23 12:00:35',NULL),(2295,7705,40720,1542,2,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',25499.82,NULL,NULL,1,'2024-09-23 12:02:28','2024-09-23 12:02:28',NULL),(2296,7705,40720,1542,2,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',6002.95,NULL,NULL,1,'2024-09-23 12:04:04','2024-09-23 12:04:04',NULL),(2297,7705,40720,1542,2,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',15000.89,NULL,NULL,1,'2024-09-23 12:05:48','2024-09-23 12:05:48',NULL),(2298,7705,40720,1542,2,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',87997.52,NULL,NULL,1,'2024-09-23 12:06:55','2024-09-23 12:06:55',NULL),(2299,7705,40720,1542,2,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-30','2024-06-30',25000.54,NULL,NULL,1,'2024-09-23 12:07:51','2024-09-23 12:07:51',NULL),(2300,7705,40720,1542,2,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',5600.00,NULL,NULL,1,'2024-09-23 12:16:35','2024-09-23 12:16:35',NULL),(2301,7705,40720,1542,2,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',13600.00,NULL,NULL,1,'2024-09-23 12:20:16','2024-09-23 12:20:16',NULL),(2302,7705,40720,1542,2,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',11300.00,NULL,NULL,1,'2024-09-23 12:21:47','2024-09-23 12:21:47',NULL),(2303,7705,40720,1542,2,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',16300.01,NULL,NULL,1,'2024-09-23 12:22:37','2024-09-23 12:22:37',NULL),(2304,7705,40720,1542,3,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',1600.01,NULL,NULL,1,'2024-09-23 15:00:38','2024-09-23 15:02:30','2024-09-23 15:02:30'),(2305,7705,40720,1542,3,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',160000.72,NULL,NULL,1,'2024-09-23 15:02:30','2024-09-23 15:02:30',NULL),(2306,7705,40720,1542,3,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',7187.40,NULL,NULL,1,'2024-09-23 15:07:26','2024-09-23 15:07:26',NULL),(2307,7705,40720,1542,3,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',1745.00,NULL,NULL,1,'2024-09-23 15:08:39','2024-09-23 15:08:39',NULL),(2308,7705,40720,1542,3,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',13158.75,NULL,NULL,1,'2024-09-23 15:11:17','2024-09-23 15:11:17',NULL),(2309,7705,40720,1542,3,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',9900.00,NULL,NULL,1,'2024-09-23 15:14:09','2024-09-23 15:14:09',NULL);
INSERT INTO `balance_libro` VALUES (2310,7705,40720,1543,3,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',49999.98,NULL,NULL,1,'2024-09-23 17:56:08','2024-09-23 17:56:08',NULL),(2311,7705,40720,1543,3,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',10002.45,NULL,NULL,1,'2024-09-23 17:57:09','2024-09-23 17:57:09',NULL),(2312,7705,40720,1543,3,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',107601.72,NULL,NULL,1,'2024-09-23 17:58:02','2024-09-23 17:58:02',NULL),(2313,7705,40720,1543,3,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',43501.76,NULL,NULL,1,'2024-09-23 17:59:33','2024-09-23 17:59:33',NULL),(2314,7705,40720,1543,3,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',75003.92,NULL,NULL,1,'2024-09-23 18:00:26','2024-09-23 18:00:26',NULL),(2315,7705,40720,1543,3,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',10001.58,NULL,NULL,1,'2024-09-23 18:01:22','2024-09-23 18:01:22',NULL),(2316,7705,40720,1543,3,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',40003.78,NULL,NULL,1,'2024-09-23 18:02:29','2024-09-23 18:02:29',NULL),(2317,7705,40720,1543,3,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',14999.51,NULL,NULL,1,'2024-09-23 18:03:12','2024-09-23 18:03:12',NULL),(2318,7705,40720,1543,3,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',20000.94,NULL,NULL,1,'2024-09-23 18:04:07','2024-09-23 18:04:07',NULL),(2319,7705,40720,1543,3,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',15024.13,NULL,NULL,1,'2024-09-23 18:06:09','2024-09-23 18:06:09',NULL),(2320,7705,40720,1543,3,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',20003.15,NULL,NULL,1,'2024-09-23 18:06:55','2024-09-23 18:06:55',NULL),(2321,7705,40720,1543,3,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',9996.01,NULL,NULL,1,'2024-09-23 18:07:44','2024-09-23 18:07:44',NULL),(2322,7705,40720,1543,3,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-06','2024-07-06',29997.45,NULL,NULL,1,'2024-09-23 18:08:40','2024-09-23 18:08:40',NULL),(2323,7705,40720,1543,3,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-07','2024-07-07',4998.88,NULL,NULL,1,'2024-09-23 18:09:22','2024-09-23 18:09:22',NULL),(2324,7705,40720,1543,3,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-07','2024-07-07',9997.75,NULL,NULL,1,'2024-09-23 18:10:04','2024-09-23 18:10:04',NULL),(2325,7705,40720,1543,3,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-07','2024-07-07',20001.79,NULL,NULL,1,'2024-09-23 18:11:05','2024-09-23 18:11:05',NULL),(2326,7705,40720,1543,3,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-07','2024-07-07',88556.00,NULL,NULL,1,'2024-09-23 18:12:19','2024-09-23 18:12:19',NULL),(2327,7705,40720,1543,3,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',10001.58,NULL,NULL,1,'2024-09-23 18:13:23','2024-09-23 18:13:23',NULL),(2328,7705,40720,1543,3,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',20001.79,NULL,NULL,1,'2024-09-23 18:14:03','2024-09-23 18:14:03',NULL),(2329,7705,40720,1543,3,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-09','2024-07-09',90534.54,NULL,NULL,1,'2024-09-23 18:16:05','2024-09-23 18:16:05',NULL),(2330,7705,40720,1543,3,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-09','2024-07-09',9999.36,NULL,NULL,1,'2024-09-23 18:17:05','2024-09-23 18:17:05',NULL);
INSERT INTO `balance_libro` VALUES (2331,7705,40720,1543,3,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',14994.00,NULL,NULL,1,'2024-09-23 18:18:06','2024-09-23 18:18:06',NULL),(2332,7705,40720,1543,3,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',100001.59,NULL,NULL,1,'2024-09-23 18:19:17','2024-09-23 18:19:17',NULL),(2333,7705,40720,1543,3,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-11','2024-07-11',19997.43,NULL,NULL,1,'2024-09-23 18:20:18','2024-09-23 18:20:18',NULL),(2334,7705,40720,1543,3,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-11','2024-07-11',19999.94,NULL,NULL,1,'2024-09-23 18:21:00','2024-09-23 18:21:00',NULL),(2335,7705,40720,1543,3,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-11','2024-07-11',135003.99,NULL,NULL,1,'2024-09-23 18:21:53','2024-09-23 18:21:53',NULL),(2336,7705,40720,1543,3,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',122006.02,NULL,NULL,1,'2024-09-23 18:26:21','2024-09-23 18:26:21',NULL),(2337,7705,40720,1543,3,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',19998.72,NULL,NULL,1,'2024-09-23 18:27:05','2024-09-23 18:27:05',NULL),(2338,7705,40720,1543,3,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',55000.70,NULL,NULL,1,'2024-09-23 18:27:50','2024-09-23 18:27:50',NULL),(2339,7705,40720,1543,3,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-13','2024-07-13',12999.68,NULL,NULL,1,'2024-09-23 18:28:32','2024-09-23 18:28:32',NULL),(2340,7705,40720,1543,3,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',9999.36,NULL,NULL,1,'2024-09-23 18:29:12','2024-09-23 18:29:12',NULL),(2341,7705,40720,1543,3,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',9999.36,NULL,NULL,1,'2024-09-23 18:29:49','2024-09-23 18:29:49',NULL),(2342,7705,40720,1543,3,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',10001.58,NULL,NULL,1,'2024-09-23 18:30:28','2024-09-23 18:30:28',NULL),(2343,7705,40720,1543,3,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',53002.13,NULL,NULL,1,'2024-09-23 18:31:26','2024-09-23 18:31:26',NULL),(2344,7705,40720,1543,3,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',36207.79,NULL,NULL,1,'2024-09-23 18:33:55','2024-09-23 18:33:55',NULL),(2345,7705,40720,1543,3,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',10001.58,NULL,NULL,1,'2024-09-23 18:34:36','2024-09-23 18:34:36',NULL),(2346,7705,40720,1543,3,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',19998.72,NULL,NULL,1,'2024-09-23 18:35:15','2024-09-23 18:35:15',NULL),(2347,7705,40720,1543,3,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',10000.40,NULL,NULL,1,'2024-09-23 18:36:10','2024-09-23 18:36:10',NULL),(2348,7705,40720,1543,3,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',14994.00,NULL,NULL,1,'2024-09-23 18:37:10','2024-09-23 18:37:10',NULL),(2349,7705,40720,1543,3,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',19998.72,NULL,NULL,1,'2024-09-23 18:38:00','2024-09-23 18:38:00',NULL),(2350,7705,40720,1543,3,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',155004.37,NULL,NULL,1,'2024-09-23 18:38:40','2024-09-23 18:38:40',NULL),(2351,7705,40720,1543,3,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',64997.10,NULL,NULL,1,'2024-09-23 18:39:30','2024-09-23 18:39:30',NULL);
INSERT INTO `balance_libro` VALUES (2352,7705,40720,1543,3,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',19998.72,NULL,NULL,1,'2024-09-23 18:40:10','2024-09-23 18:40:10',NULL),(2353,7705,40720,1543,3,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',36997.32,NULL,NULL,1,'2024-09-23 18:41:08','2024-09-23 18:41:08',NULL),(2354,7705,40720,1543,3,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',10001.58,NULL,NULL,1,'2024-09-23 18:42:29','2024-09-23 18:42:29',NULL),(2355,7705,40720,1543,3,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',14999.50,NULL,NULL,1,'2024-09-23 18:43:15','2024-09-23 18:43:15',NULL),(2356,7705,40720,1543,3,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',10001.58,NULL,NULL,1,'2024-09-23 18:43:55','2024-09-23 18:43:55',NULL),(2357,7705,40720,1543,3,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',13001.48,NULL,NULL,1,'2024-09-23 18:44:32','2024-09-23 18:44:32',NULL),(2358,7705,40720,1543,3,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',19997.42,NULL,NULL,1,'2024-09-23 18:45:16','2024-09-23 18:45:16',NULL),(2359,7705,40720,1543,3,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',25001.08,NULL,NULL,1,'2024-09-23 18:45:51','2024-09-23 18:45:51',NULL),(2360,7705,40720,1543,3,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',19998.72,NULL,NULL,1,'2024-09-23 18:46:38','2024-09-23 18:46:38',NULL),(2361,7705,40720,1543,3,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',9999.98,NULL,NULL,1,'2024-09-23 18:47:23','2024-09-23 18:47:23',NULL),(2362,7705,40720,1543,3,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-21','2024-07-21',9999.36,NULL,NULL,1,'2024-09-23 18:48:10','2024-09-23 18:48:10',NULL),(2363,7705,40720,1543,3,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-21','2024-07-21',10001.58,NULL,NULL,1,'2024-09-23 18:48:51','2024-09-23 18:48:51',NULL),(2364,7705,40720,1543,3,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',65999.28,NULL,NULL,1,'2024-09-23 18:49:44','2024-09-23 18:49:44',NULL),(2365,7705,40720,1543,3,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',9997.76,NULL,NULL,1,'2024-09-23 18:50:25','2024-09-23 18:50:25',NULL),(2366,7705,40720,1543,3,2260,'App\\Models\\Receipt',2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',9997.76,NULL,NULL,1,'2024-09-23 18:51:12','2024-09-23 18:51:12',NULL),(2367,7705,40720,1543,3,2261,'App\\Models\\Receipt',2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',12001.07,NULL,NULL,1,'2024-09-23 18:51:56','2024-09-23 18:51:56',NULL),(2368,7705,40720,1543,3,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',113767.85,NULL,NULL,1,'2024-09-23 18:52:56','2024-09-23 18:52:56',NULL),(2369,7705,40720,1543,3,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',82001.86,NULL,NULL,1,'2024-09-23 18:54:27','2024-09-23 18:54:27',NULL),(2370,7705,40720,1543,3,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',9997.76,NULL,NULL,1,'2024-09-23 18:55:28','2024-09-23 18:55:28',NULL),(2371,7705,40720,1543,3,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',13997.63,NULL,NULL,1,'2024-09-23 18:56:08','2024-09-23 18:56:08',NULL),(2372,7705,40720,1543,3,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',8000.03,NULL,NULL,1,'2024-09-23 18:56:58','2024-09-23 18:56:58',NULL);
INSERT INTO `balance_libro` VALUES (2373,7705,40720,1543,3,2267,'App\\Models\\Receipt',2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',10000.49,NULL,NULL,1,'2024-09-23 18:58:23','2024-09-23 18:58:23',NULL),(2374,7705,40720,1543,3,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',5000.05,NULL,NULL,1,'2024-09-23 18:59:09','2024-09-23 18:59:09',NULL),(2375,7705,40720,1543,3,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',13997.63,NULL,NULL,1,'2024-09-23 19:00:01','2024-09-23 19:00:01',NULL),(2376,7705,40720,1543,3,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',12999.95,NULL,NULL,1,'2024-09-23 19:03:05','2024-09-23 19:03:05',NULL),(2377,7705,40720,1543,3,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',4998.88,NULL,NULL,1,'2024-09-23 19:03:57','2024-09-23 19:03:57',NULL),(2378,7705,40720,1543,3,2272,'App\\Models\\Receipt',2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-28','2024-07-28',14999.50,NULL,NULL,1,'2024-09-23 19:05:06','2024-09-23 19:05:06',NULL),(2379,7705,40720,1543,3,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-28','2024-07-28',59000.02,NULL,NULL,1,'2024-09-23 19:05:46','2024-09-23 19:05:46',NULL),(2380,7705,40720,1543,3,2274,'App\\Models\\Receipt',2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',30003.37,NULL,NULL,1,'2024-09-23 19:06:24','2024-09-23 19:06:24',NULL),(2381,7705,40720,1543,3,2275,'App\\Models\\Receipt',2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',85964.24,NULL,NULL,1,'2024-09-23 19:07:01','2024-09-23 19:07:01',NULL),(2382,7705,40720,1543,3,2276,'App\\Models\\Receipt',2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',9997.76,NULL,NULL,1,'2024-09-23 20:44:21','2024-09-23 20:44:21',NULL),(2383,7705,40720,1543,3,2277,'App\\Models\\Receipt',2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',24999.50,NULL,NULL,1,'2024-09-23 20:45:15','2024-09-23 20:45:15',NULL),(2384,7705,40720,1543,3,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',4999.63,NULL,NULL,1,'2024-09-23 20:46:07','2024-09-23 20:46:07',NULL),(2385,7705,40720,1543,3,2279,'App\\Models\\Receipt',2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',13998.12,NULL,NULL,1,'2024-09-23 20:46:55','2024-09-23 20:46:55',NULL),(2386,7705,40720,1543,3,2280,'App\\Models\\Receipt',2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',7002.80,NULL,NULL,1,'2024-09-23 20:47:45','2024-09-23 20:47:45',NULL),(2387,7705,40720,1543,3,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',10000.34,NULL,NULL,1,'2024-09-23 20:49:31','2024-09-23 20:49:31',NULL),(2388,7705,40720,1543,3,2282,'App\\Models\\Receipt',2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',94887.71,NULL,NULL,1,'2024-09-23 20:50:44','2024-09-23 20:50:44',NULL),(2389,7705,40720,1543,3,2283,'App\\Models\\Receipt',2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',38000.00,NULL,NULL,1,'2024-09-23 20:52:39','2024-09-23 20:52:39',NULL),(2390,7705,40720,1543,3,2284,'App\\Models\\Receipt',2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',9999.36,NULL,NULL,1,'2024-09-23 20:53:47','2024-09-23 20:53:47',NULL),(2391,7705,40720,1543,3,2285,'App\\Models\\Receipt',2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-31','2024-07-31',14999.50,NULL,NULL,1,'2024-09-23 20:54:32','2024-09-23 20:54:32',NULL),(2392,7705,40720,1543,3,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',11450.00,NULL,NULL,1,'2024-09-23 20:56:18','2024-09-23 20:56:18',NULL),(2393,7705,40720,1543,3,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',5000.00,NULL,NULL,1,'2024-09-23 20:56:56','2024-09-23 20:56:56',NULL);
INSERT INTO `balance_libro` VALUES (2394,7705,40720,1543,3,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-11','2024-07-11',15600.00,NULL,NULL,1,'2024-09-23 20:57:29','2024-09-23 20:57:29',NULL),(2395,7705,40720,1543,3,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',629999.98,NULL,NULL,1,'2024-09-23 20:59:15','2024-09-23 20:59:15',NULL),(2396,7705,40720,1543,3,2290,'App\\Models\\Receipt',2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',15600.00,NULL,NULL,1,'2024-09-23 21:00:11','2024-09-23 21:00:11',NULL),(2397,7705,40720,1543,3,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',8000.00,NULL,NULL,1,'2024-09-23 21:01:28','2024-09-23 21:01:28',NULL),(2398,7705,40720,1543,3,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',75283.47,NULL,NULL,1,'2024-09-23 21:02:32','2024-09-23 21:02:32',NULL),(2399,7705,40720,1543,3,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',9900.00,NULL,NULL,1,'2024-09-23 21:12:20','2024-09-23 21:12:20',NULL),(2400,7705,40720,1543,3,2294,'App\\Models\\Receipt',2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',9900.00,NULL,NULL,1,'2024-09-23 21:13:11','2024-09-23 21:13:11',NULL),(2401,7705,40720,1543,3,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',50999.94,NULL,NULL,1,'2024-09-23 21:14:12','2024-09-23 21:14:12',NULL),(2402,7705,40720,1544,3,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',8998.00,NULL,NULL,1,'2024-11-30 08:19:30','2024-11-30 08:19:30',NULL),(2403,7705,40720,1544,3,2297,'App\\Models\\Receipt',2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',15000.64,NULL,NULL,1,'2024-11-30 08:21:19','2024-11-30 08:21:19',NULL),(2404,7705,40720,1544,3,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',8997.89,NULL,NULL,1,'2024-11-30 08:22:13','2024-11-30 08:22:13',NULL),(2405,7705,40720,1544,3,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',10000.00,NULL,NULL,1,'2024-11-30 08:28:25','2024-11-30 08:28:25',NULL),(2406,7705,40720,1544,3,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',21500.01,NULL,NULL,1,'2024-11-30 08:30:04','2024-11-30 08:30:04',NULL),(2407,7705,40720,1544,3,2301,'App\\Models\\Receipt',2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-02','2024-08-02',18000.04,NULL,NULL,1,'2024-11-30 08:31:52','2024-11-30 08:31:52',NULL),(2408,7705,40720,1544,3,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-02','2024-08-02',57022.83,NULL,NULL,1,'2024-11-30 08:36:18','2024-11-30 08:36:18',NULL),(2409,7705,40720,1544,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-02','2024-08-02',13999.64,NULL,NULL,1,'2024-11-30 08:37:08','2024-11-30 08:37:08',NULL),(2410,7705,40720,1544,3,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-03','2024-08-03',120440.68,NULL,NULL,1,'2024-11-30 08:42:37','2024-11-30 08:42:37',NULL),(2411,7705,40720,1544,3,2305,'App\\Models\\Receipt',2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-03','2024-08-03',6649.99,NULL,NULL,1,'2024-11-30 08:49:16','2024-11-30 08:49:16',NULL),(2412,7705,40720,1544,3,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-03','2024-08-03',24999.08,NULL,NULL,1,'2024-11-30 08:50:01','2024-11-30 08:50:01',NULL),(2413,7705,40720,1544,3,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-03','2024-08-03',12999.76,NULL,NULL,1,'2024-11-30 08:50:43','2024-11-30 08:50:43',NULL),(2414,7705,40720,1544,3,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-03','2024-08-03',9998.24,NULL,NULL,1,'2024-11-30 08:51:48','2024-11-30 08:51:48',NULL);
INSERT INTO `balance_libro` VALUES (2415,7705,40720,1544,3,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-03','2024-08-03',10000.50,NULL,NULL,1,'2024-11-30 08:53:07','2024-11-30 08:53:07',NULL),(2416,7705,40720,1544,3,2310,'App\\Models\\Receipt',2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-04','2024-08-04',65014.45,NULL,NULL,1,'2024-11-30 08:55:08','2024-11-30 08:55:08',NULL),(2417,7705,40720,1544,3,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-04','2024-08-04',20002.84,NULL,NULL,1,'2024-11-30 08:56:26','2024-11-30 08:56:26',NULL),(2418,7705,40720,1544,3,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-04','2024-08-04',9998.24,NULL,NULL,1,'2024-11-30 08:57:17','2024-11-30 08:57:17',NULL),(2419,7705,40720,1544,3,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-05','2024-08-05',9998.24,NULL,NULL,1,'2024-11-30 08:58:04','2024-11-30 08:58:04',NULL),(2420,7705,40720,1544,3,2314,'App\\Models\\Receipt',2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-05','2024-08-05',12999.76,NULL,NULL,1,'2024-11-30 09:01:13','2024-11-30 09:01:13',NULL),(2421,7705,40720,1544,3,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-15','2024-08-15',5001.75,NULL,NULL,1,'2024-11-30 17:17:06','2024-11-30 17:18:08','2024-11-30 17:18:08'),(2422,7705,40720,1544,3,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-05','2024-08-05',5001.75,NULL,NULL,1,'2024-11-30 17:18:08','2024-11-30 17:18:08',NULL),(2423,7705,40720,1544,3,2316,'App\\Models\\Receipt',2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-05','2024-08-05',8997.89,NULL,NULL,1,'2024-11-30 17:20:01','2024-11-30 17:20:01',NULL),(2424,7705,40720,1544,3,2317,'App\\Models\\Receipt',2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-06','2024-08-06',9998.24,NULL,NULL,1,'2024-11-30 17:21:16','2024-11-30 17:21:16',NULL),(2425,7705,40720,1544,3,2318,'App\\Models\\Receipt',2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-06','2024-08-06',5000.00,NULL,NULL,1,'2024-12-01 11:54:58','2024-12-01 11:54:58',NULL),(2426,7705,40720,1544,3,2319,'App\\Models\\Receipt',2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',10000.03,NULL,NULL,1,'2024-12-01 11:56:35','2024-12-01 11:56:35',NULL),(2427,7705,40720,1544,3,2320,'App\\Models\\Receipt',2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',6002.10,NULL,NULL,1,'2024-12-01 11:57:22','2024-12-01 11:57:22',NULL),(2428,7705,40720,1544,3,2321,'App\\Models\\Receipt',2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',5007.13,NULL,NULL,1,'2024-12-01 11:58:43','2024-12-01 11:58:43',NULL),(2429,7705,40720,1544,3,2322,'App\\Models\\Receipt',2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',6002.65,NULL,NULL,1,'2024-12-01 11:59:30','2024-12-01 11:59:30',NULL),(2430,7705,40720,1544,3,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',10000.00,NULL,NULL,1,'2024-12-01 12:01:11','2024-12-01 12:01:11',NULL),(2431,7705,40720,1544,3,2324,'App\\Models\\Receipt',2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',79999.82,NULL,NULL,1,'2024-12-01 12:01:55','2024-12-01 12:01:55',NULL),(2432,7705,40720,1544,3,2325,'App\\Models\\Receipt',2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',9998.24,NULL,NULL,1,'2024-12-01 12:02:38','2024-12-01 12:02:38',NULL),(2433,7705,40720,1544,3,2326,'App\\Models\\Receipt',2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',20002.86,NULL,NULL,1,'2024-12-01 12:06:33','2024-12-01 12:06:33',NULL),(2434,7705,40720,1544,3,2327,'App\\Models\\Receipt',2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',50162.69,NULL,NULL,1,'2024-12-01 12:07:21','2024-12-01 12:07:21',NULL),(2435,7705,40720,1544,3,2328,'App\\Models\\Receipt',2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-08','2024-08-08',29995.36,NULL,NULL,1,'2024-12-01 12:09:09','2024-12-01 12:09:09',NULL);
INSERT INTO `balance_libro` VALUES (2436,7705,40720,1544,3,2329,'App\\Models\\Receipt',2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-08','2024-08-08',10000.03,NULL,NULL,1,'2024-12-01 12:09:56','2024-12-01 12:09:56',NULL),(2437,7705,40720,1544,3,2330,'App\\Models\\Receipt',2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-08','2024-08-08',15000.37,NULL,NULL,1,'2024-12-01 12:11:06','2024-12-01 12:11:06',NULL),(2438,7705,40720,1544,3,2331,'App\\Models\\Receipt',2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-08','2024-08-08',9998.45,NULL,NULL,1,'2024-12-01 12:12:38','2024-12-01 12:12:38',NULL),(2439,7705,40720,1544,3,2332,'App\\Models\\Receipt',2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-09','2024-08-09',9998.45,NULL,NULL,1,'2024-12-01 12:13:35','2024-12-01 12:13:35',NULL),(2440,7705,40720,1544,3,2333,'App\\Models\\Receipt',2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-09','2024-08-09',12999.77,NULL,NULL,1,'2024-12-01 12:14:34','2024-12-01 12:14:34',NULL),(2441,7705,40720,1544,3,2334,'App\\Models\\Receipt',2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-09','2024-08-09',9998.24,NULL,NULL,1,'2024-12-01 12:16:09','2024-12-01 12:16:09',NULL),(2442,7705,40720,1544,3,2335,'App\\Models\\Receipt',2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-09','2024-08-09',9999.89,NULL,NULL,1,'2024-12-01 12:17:04','2024-12-01 12:17:04',NULL),(2443,7705,40720,1544,3,2336,'App\\Models\\Receipt',2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-09','2024-08-09',3799.97,NULL,NULL,1,'2024-12-01 12:18:05','2024-12-01 12:18:05',NULL),(2444,7705,40720,1544,3,2337,'App\\Models\\Receipt',2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-09','2024-08-09',18001.97,NULL,NULL,1,'2024-12-01 12:18:48','2024-12-01 12:18:48',NULL),(2445,7705,40720,1544,3,2338,'App\\Models\\Receipt',2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-09','2024-08-09',18200.02,NULL,NULL,1,'2024-12-01 12:19:37','2024-12-01 12:19:37',NULL),(2446,7705,40720,1544,3,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-10','2024-08-10',15000.66,NULL,NULL,1,'2024-12-01 12:20:26','2024-12-01 12:20:26',NULL),(2447,7705,40720,1544,3,2340,'App\\Models\\Receipt',2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-10','2024-08-10',9998.24,NULL,NULL,1,'2024-12-01 12:21:02','2024-12-01 12:21:02',NULL),(2448,7705,40720,1544,3,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-10','2024-08-10',30001.31,NULL,NULL,1,'2024-12-01 12:21:43','2024-12-01 12:21:43',NULL),(2449,7705,40720,1544,3,2342,'App\\Models\\Receipt',2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-11','2024-08-11',7997.58,NULL,NULL,1,'2024-12-01 12:22:30','2024-12-01 12:22:30',NULL),(2450,7705,40720,1544,3,2343,'App\\Models\\Receipt',2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-12','2024-08-12',6002.10,NULL,NULL,1,'2024-12-01 12:23:11','2024-12-01 12:23:11',NULL),(2451,7705,40720,1544,3,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-12','2024-08-12',11999.33,NULL,NULL,1,'2024-12-01 12:23:48','2024-12-01 12:23:48',NULL),(2452,7705,40720,1544,3,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-12','2024-08-12',17995.99,NULL,NULL,1,'2024-12-01 12:24:58','2024-12-01 12:24:58',NULL),(2453,7705,40720,1544,3,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-12','2024-08-12',6997.13,NULL,NULL,1,'2024-12-01 12:25:38','2024-12-01 12:25:38',NULL),(2454,7705,40720,1544,3,2347,'App\\Models\\Receipt',2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-13','2024-08-13',79999.98,NULL,NULL,1,'2024-12-01 12:26:29','2024-12-01 12:26:29',NULL),(2455,7705,40720,1544,3,2348,'App\\Models\\Receipt',2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-13','2024-08-13',7002.45,NULL,NULL,1,'2024-12-01 12:27:11','2024-12-01 12:27:11',NULL),(2456,7705,40720,1544,3,2349,'App\\Models\\Receipt',2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-14','2024-08-14',9999.89,NULL,NULL,1,'2024-12-01 12:28:07','2024-12-01 12:28:07',NULL);
INSERT INTO `balance_libro` VALUES (2457,7705,40720,1544,3,2350,'App\\Models\\Receipt',2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-14','2024-08-14',6997.13,NULL,NULL,1,'2024-12-01 12:29:09','2024-12-01 12:29:09',NULL),(2458,7705,40720,1544,3,2351,'App\\Models\\Receipt',2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-14','2024-08-14',15000.66,NULL,NULL,1,'2024-12-01 13:23:51','2024-12-01 13:23:51',NULL),(2459,7705,40720,1544,3,2352,'App\\Models\\Receipt',2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-14','2024-08-14',15000.66,NULL,NULL,1,'2024-12-01 13:24:31','2024-12-01 13:24:31',NULL),(2460,7705,40720,1544,3,2353,'App\\Models\\Receipt',2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-14','2024-08-14',8000.52,NULL,NULL,1,'2024-12-01 13:25:42','2024-12-01 13:25:42',NULL),(2461,7705,40720,1544,3,2354,'App\\Models\\Receipt',2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-15','2024-08-15',93998.84,NULL,NULL,1,'2024-12-01 13:26:39','2024-12-01 13:26:39',NULL),(2462,7705,40720,1544,3,2355,'App\\Models\\Receipt',2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-15','2024-08-15',7997.58,NULL,NULL,1,'2024-12-01 13:27:14','2024-12-01 13:27:14',NULL),(2463,7705,40720,1544,3,2356,'App\\Models\\Receipt',2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-15','2024-08-15',12379.45,NULL,NULL,1,'2024-12-01 13:27:56','2024-12-01 13:27:56',NULL),(2464,7705,40720,1544,3,2357,'App\\Models\\Receipt',2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-15','2024-08-15',6002.10,NULL,NULL,1,'2024-12-06 06:29:54','2024-12-06 06:29:54',NULL),(2465,7705,40720,1544,3,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-15','2024-08-15',9999.89,NULL,NULL,1,'2024-12-06 06:30:55','2024-12-06 06:30:55',NULL),(2466,7705,40720,1544,3,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-15','2024-08-15',24999.10,NULL,NULL,1,'2024-12-06 06:32:37','2024-12-06 06:32:37',NULL),(2467,7705,40720,1544,3,2360,'App\\Models\\Receipt',2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-15','2024-08-15',7999.95,NULL,NULL,1,'2024-12-06 06:33:37','2024-12-06 06:33:37',NULL),(2468,7705,40720,1544,3,2361,'App\\Models\\Receipt',2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-15','2024-08-15',8000.00,NULL,NULL,1,'2024-12-06 06:34:35','2024-12-06 06:34:35',NULL),(2469,7705,40720,1544,3,2362,'App\\Models\\Receipt',2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-16','2024-08-16',9998.45,NULL,NULL,1,'2024-12-06 06:35:37','2024-12-06 06:35:37',NULL),(2470,7705,40720,1544,3,2363,'App\\Models\\Receipt',2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-16','2024-08-16',7997.58,NULL,NULL,1,'2024-12-06 06:36:23','2024-12-06 06:36:23',NULL),(2471,7705,40720,1544,3,2364,'App\\Models\\Receipt',2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-16','2024-08-16',14999.49,NULL,NULL,1,'2024-12-06 06:37:50','2024-12-06 06:37:50',NULL),(2472,7705,40720,1544,3,2365,'App\\Models\\Receipt',2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-16','2024-08-16',20002.86,NULL,NULL,1,'2024-12-06 06:38:42','2024-12-06 06:38:42',NULL),(2473,7705,40720,1544,3,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-16','2024-08-16',22998.21,NULL,NULL,1,'2024-12-06 06:39:25','2024-12-06 06:39:25',NULL),(2474,7705,40720,1544,3,2367,'App\\Models\\Receipt',2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-16','2024-08-16',180006.68,NULL,NULL,1,'2024-12-06 06:40:10','2024-12-06 06:40:10',NULL),(2475,7705,40720,1544,3,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-16','2024-08-16',9999.89,NULL,NULL,1,'2024-12-06 06:41:16','2024-12-06 06:41:16',NULL),(2476,7705,40720,1544,3,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-17','2024-08-17',9998.24,NULL,NULL,1,'2024-12-06 06:42:23','2024-12-06 06:42:23',NULL),(2477,7705,40720,1544,3,2370,'App\\Models\\Receipt',2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-17','2024-08-17',9999.89,NULL,NULL,1,'2024-12-06 06:43:31','2024-12-06 06:43:31',NULL);
INSERT INTO `balance_libro` VALUES (2478,7705,40720,1544,3,2371,'App\\Models\\Receipt',2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-17','2024-08-17',9998.45,NULL,NULL,1,'2024-12-06 06:44:17','2024-12-06 06:44:17',NULL),(2479,7705,40720,1544,3,2372,'App\\Models\\Receipt',2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-17','2024-08-17',9999.89,NULL,NULL,1,'2024-12-06 06:45:04','2024-12-06 06:45:04',NULL),(2480,7705,40720,1544,3,2373,'App\\Models\\Receipt',2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-18','2024-08-18',9998.45,NULL,NULL,1,'2024-12-06 06:45:56','2024-12-06 06:45:56',NULL),(2481,7705,40720,1544,3,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-18','2024-08-18',6002.65,NULL,NULL,1,'2024-12-06 06:46:49','2024-12-06 06:46:49',NULL),(2482,7705,40720,1544,3,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-18','2024-08-18',49503.91,NULL,NULL,1,'2024-12-06 06:47:33','2024-12-06 06:47:33',NULL),(2483,7705,40720,1544,3,2376,'App\\Models\\Receipt',2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-18','2024-08-18',6002.10,NULL,NULL,1,'2024-12-06 06:48:13','2024-12-06 06:48:13',NULL),(2484,7705,40720,1544,3,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-18','2024-08-18',9999.89,NULL,NULL,1,'2024-12-06 06:50:00','2024-12-06 06:50:00',NULL),(2485,7705,40720,1544,3,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-18','2024-08-18',10000.01,NULL,NULL,1,'2024-12-06 06:51:00','2024-12-06 06:51:00',NULL),(2486,7705,40720,1544,3,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-18','2024-08-18',5999.97,NULL,NULL,1,'2024-12-06 06:52:22','2024-12-06 06:52:22',NULL),(2487,7705,40720,1544,3,2380,'App\\Models\\Receipt',2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-19','2024-08-19',15000.37,NULL,NULL,1,'2024-12-06 06:53:33','2024-12-06 06:53:33',NULL),(2488,7705,40720,1544,3,2381,'App\\Models\\Receipt',2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-19','2024-08-19',9998.24,NULL,NULL,1,'2024-12-06 06:54:43','2024-12-06 06:54:43',NULL),(2489,7705,40720,1544,3,2382,'App\\Models\\Receipt',2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-20','2024-08-20',9998.24,NULL,NULL,1,'2024-12-06 06:55:24','2024-12-06 06:55:24',NULL),(2490,7705,40720,1544,3,2383,'App\\Models\\Receipt',2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-20','2024-08-20',6000.01,NULL,NULL,1,'2024-12-06 06:56:22','2024-12-06 06:56:22',NULL),(2491,7705,40720,1544,3,2384,'App\\Models\\Receipt',2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-20','2024-08-20',8550.01,NULL,NULL,1,'2024-12-06 06:57:29','2024-12-06 06:57:29',NULL),(2492,7705,40720,1544,3,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-20','2024-08-20',15000.05,NULL,NULL,1,'2024-12-06 06:59:52','2024-12-06 06:59:52',NULL),(2493,7705,40720,1544,3,2386,'App\\Models\\Receipt',2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-21','2024-08-21',9998.24,NULL,NULL,1,'2024-12-06 07:00:52','2024-12-06 07:00:52',NULL),(2494,7705,40720,1544,3,2387,'App\\Models\\Receipt',2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-21','2024-08-21',9499.99,NULL,NULL,1,'2024-12-06 07:02:30','2024-12-06 07:02:30',NULL),(2495,7705,40720,1544,3,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-21','2024-08-21',9999.89,NULL,NULL,1,'2024-12-06 07:04:05','2024-12-06 07:04:05',NULL),(2496,7705,40720,1544,3,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-21','2024-08-21',45000.04,NULL,NULL,1,'2024-12-06 07:04:55','2024-12-06 07:04:55',NULL),(2497,7705,40720,1544,3,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-22','2024-08-22',9999.89,NULL,NULL,1,'2024-12-06 07:06:06','2024-12-06 07:06:06',NULL),(2498,7705,40720,1544,3,2391,'App\\Models\\Receipt',2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-22','2024-08-22',9998.24,NULL,NULL,1,'2024-12-06 07:07:18','2024-12-06 07:07:18',NULL);
INSERT INTO `balance_libro` VALUES (2499,7705,40720,1544,3,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-22','2024-08-22',6997.13,NULL,NULL,1,'2024-12-06 07:07:59','2024-12-06 07:07:59',NULL),(2500,7705,40720,1544,3,2393,'App\\Models\\Receipt',2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-22','2024-08-22',104997.58,NULL,NULL,1,'2024-12-06 07:09:08','2024-12-06 07:09:08',NULL),(2501,7705,40720,1544,3,2394,'App\\Models\\Receipt',2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-23','2024-08-23',6002.10,NULL,NULL,1,'2024-12-06 07:10:03','2024-12-06 07:10:03',NULL),(2502,7705,40720,1544,3,2395,'App\\Models\\Receipt',2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-23','2024-08-23',15000.00,NULL,NULL,1,'2024-12-06 07:10:48','2024-12-06 07:10:48',NULL),(2503,7705,40720,1544,3,2396,'App\\Models\\Receipt',2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-23','2024-08-23',9999.89,NULL,NULL,1,'2024-12-06 07:11:38','2024-12-06 07:11:38',NULL),(2504,7705,40720,1544,3,2397,'App\\Models\\Receipt',2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-23','2024-08-23',19999.99,NULL,NULL,1,'2024-12-06 07:12:35','2024-12-06 07:12:35',NULL),(2505,7705,40720,1544,3,2398,'App\\Models\\Receipt',2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-23','2024-08-23',9998.45,NULL,NULL,1,'2024-12-06 07:13:15','2024-12-06 07:13:15',NULL),(2506,7705,40720,1544,3,2399,'App\\Models\\Receipt',2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-25','2024-08-25',9998.45,NULL,NULL,1,'2024-12-06 07:13:54','2024-12-06 07:13:54',NULL),(2507,7705,40720,1544,3,2400,'App\\Models\\Receipt',2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-25','2024-08-25',37660.72,NULL,NULL,1,'2024-12-06 07:14:36','2024-12-06 07:14:36',NULL),(2508,7705,40720,1544,3,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-26','2024-08-26',9998.24,NULL,NULL,1,'2024-12-06 07:15:30','2024-12-06 07:15:30',NULL),(2509,7705,40720,1544,3,2402,'App\\Models\\Receipt',2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-26','2024-08-26',10001.75,NULL,NULL,1,'2024-12-06 07:16:30','2024-12-06 07:16:30',NULL),(2510,7705,40720,1544,3,2403,'App\\Models\\Receipt',2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-26','2024-08-26',9998.45,NULL,NULL,1,'2024-12-06 07:17:16','2024-12-06 07:17:16',NULL),(2511,7705,40720,1544,3,2404,'App\\Models\\Receipt',2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-26','2024-08-26',107844.05,NULL,NULL,1,'2024-12-06 07:18:23','2024-12-06 07:18:23',NULL),(2512,7705,40720,1544,3,2405,'App\\Models\\Receipt',2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-26','2024-08-26',30001.31,NULL,NULL,1,'2024-12-07 18:20:47','2024-12-07 18:20:47',NULL),(2513,7705,40720,1544,3,2406,'App\\Models\\Receipt',2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-27','2024-08-27',7997.54,NULL,NULL,1,'2024-12-07 18:21:37','2024-12-07 18:21:37',NULL),(2514,7705,40720,1544,3,2407,'App\\Models\\Receipt',2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-27','2024-08-27',8997.89,NULL,NULL,1,'2024-12-07 18:22:43','2024-12-07 18:22:43',NULL),(2515,7705,40720,1544,3,2408,'App\\Models\\Receipt',2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-27','2024-08-27',5000.48,NULL,NULL,1,'2024-12-07 18:23:41','2024-12-07 18:23:41',NULL),(2516,7705,40720,1544,3,2409,'App\\Models\\Receipt',2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-28','2024-08-28',9499.99,NULL,NULL,1,'2024-12-07 18:25:47','2024-12-07 18:25:47',NULL),(2517,7705,40720,1544,3,2410,'App\\Models\\Receipt',2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-28','2024-08-28',7999.65,NULL,NULL,1,'2024-12-07 18:26:50','2024-12-07 18:26:50',NULL),(2518,7705,40720,1544,3,2411,'App\\Models\\Receipt',2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-28','2024-08-28',20000.06,NULL,NULL,1,'2024-12-07 18:28:35','2024-12-07 18:28:35',NULL),(2519,7705,40720,1544,3,2412,'App\\Models\\Receipt',2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-28','2024-08-28',15000.05,NULL,NULL,1,'2024-12-07 18:29:27','2024-12-07 18:29:27',NULL);
INSERT INTO `balance_libro` VALUES (2520,7705,40720,1544,3,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-28','2024-08-28',19998.83,NULL,NULL,1,'2024-12-07 18:30:31','2024-12-07 18:30:31',NULL),(2521,7705,40720,1544,3,2414,'App\\Models\\Receipt',2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-28','2024-08-28',8998.01,NULL,NULL,1,'2024-12-07 18:31:11','2024-12-07 18:31:11',NULL),(2522,7705,40720,1544,3,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-28','2024-08-28',10003.72,NULL,NULL,1,'2024-12-07 18:32:51','2024-12-07 18:32:51',NULL),(2523,7705,40720,1544,3,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-29','2024-08-29',5000.47,NULL,NULL,1,'2024-12-07 18:34:09','2024-12-07 18:34:09',NULL),(2524,7705,40720,1544,3,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-29','2024-08-29',9998.24,NULL,NULL,1,'2024-12-07 18:35:26','2024-12-07 18:35:26',NULL),(2525,7705,40720,1544,3,2418,'App\\Models\\Receipt',2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-29','2024-08-29',7002.45,NULL,NULL,1,'2024-12-07 18:36:03','2024-12-07 18:36:03',NULL),(2526,7705,40720,1544,3,2419,'App\\Models\\Receipt',2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-29','2024-08-29',79999.98,NULL,NULL,1,'2024-12-07 18:37:23','2024-12-07 18:37:23',NULL),(2527,7705,40720,1544,3,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-29','2024-08-29',15000.66,NULL,NULL,1,'2024-12-07 18:38:32','2024-12-07 18:38:32',NULL),(2528,7705,40720,1544,3,2421,'App\\Models\\Receipt',2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-29','2024-08-29',15005.59,NULL,NULL,1,'2024-12-07 18:39:52','2024-12-07 18:39:52',NULL),(2529,7705,40720,1544,3,2422,'App\\Models\\Receipt',2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',5000.01,NULL,NULL,1,'2024-12-07 18:41:29','2024-12-07 18:41:29',NULL),(2530,7705,40720,1544,3,2423,'App\\Models\\Receipt',2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',9995.49,NULL,NULL,1,'2024-12-07 18:42:35','2024-12-07 18:42:35',NULL),(2531,7705,40720,1544,3,2424,'App\\Models\\Receipt',2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',10000.00,NULL,NULL,1,'2024-12-07 18:43:41','2024-12-07 18:43:41',NULL),(2532,7705,40720,1544,3,2425,'App\\Models\\Receipt',2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',6000.01,NULL,NULL,1,'2024-12-07 18:44:33','2024-12-07 18:44:33',NULL),(2533,7705,40720,1544,3,2426,'App\\Models\\Receipt',2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',6002.10,NULL,NULL,1,'2024-12-07 18:45:25','2024-12-07 18:45:25',NULL),(2534,7705,40720,1544,3,2427,'App\\Models\\Receipt',2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',7993.90,NULL,NULL,1,'2024-12-07 18:46:29','2024-12-07 18:46:29',NULL),(2535,7705,40720,1544,3,2428,'App\\Models\\Receipt',2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',9999.89,NULL,NULL,1,'2024-12-07 18:47:41','2024-12-07 18:47:41',NULL),(2536,7705,40720,1544,3,2429,'App\\Models\\Receipt',2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-31','2024-08-31',19997.09,NULL,NULL,1,'2024-12-07 18:48:35','2024-12-07 18:48:35',NULL),(2537,7705,40720,1544,3,2430,'App\\Models\\Receipt',2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-06','2024-08-06',9460.99,NULL,NULL,1,'2024-12-07 18:49:52','2024-12-07 18:49:52',NULL),(2538,7705,40720,1544,3,2431,'App\\Models\\Receipt',2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-12','2024-08-12',5600.00,NULL,NULL,1,'2024-12-07 18:50:57','2024-12-07 18:50:57',NULL),(2539,7705,40720,1544,3,2432,'App\\Models\\Receipt',2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-19','2024-08-19',10600.01,NULL,NULL,1,'2024-12-07 18:51:31','2024-12-07 18:51:31',NULL),(2540,7705,40720,1544,3,2433,'App\\Models\\Receipt',2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-20','2024-08-20',15000.01,NULL,NULL,1,'2024-12-07 18:52:57','2024-12-07 18:52:57',NULL);
INSERT INTO `balance_libro` VALUES (2541,7705,40720,1544,3,2434,'App\\Models\\Receipt',2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-23','2024-08-23',5600.00,NULL,NULL,1,'2024-12-07 18:53:42','2024-12-07 18:53:42',NULL),(2542,7705,40720,1544,3,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-09','2024-08-09',10000.02,NULL,NULL,1,'2024-12-08 09:25:30','2024-12-08 09:25:30',NULL),(2543,7705,40720,1544,3,2436,'App\\Models\\Receipt',2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-05','2024-08-05',13158.75,NULL,NULL,1,'2024-12-08 09:28:12','2024-12-08 09:28:12',NULL),(2544,7705,40720,1544,3,2437,'App\\Models\\Receipt',2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-08','2024-08-08',11088.26,NULL,NULL,1,'2024-12-08 09:31:21','2024-12-08 09:31:21',NULL),(2545,7705,40720,1544,3,2438,'App\\Models\\Receipt',2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-09','2024-08-09',9460.99,NULL,NULL,1,'2024-12-08 09:35:00','2024-12-08 09:35:00',NULL),(2546,7705,40720,1544,3,2439,'App\\Models\\Receipt',2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-13','2024-08-13',18000.00,NULL,NULL,1,'2024-12-09 06:37:40','2024-12-09 06:37:40',NULL),(2547,7705,40720,1544,3,2440,'App\\Models\\Receipt',2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',9460.99,NULL,NULL,1,'2024-12-09 06:41:29','2024-12-09 06:41:29',NULL),(2548,7705,40720,1545,3,2441,'App\\Models\\Receipt',2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-01','2024-09-01',20002.86,NULL,NULL,1,'2024-12-15 09:35:53','2024-12-15 09:35:53',NULL),(2549,7705,40720,1545,3,2442,'App\\Models\\Receipt',2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',22999.72,NULL,NULL,1,'2024-12-15 09:38:30','2024-12-15 09:38:30',NULL),(2550,7705,40720,1545,3,2443,'App\\Models\\Receipt',2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',4999.95,NULL,NULL,1,'2024-12-15 09:40:13','2024-12-15 09:40:13',NULL),(2551,7705,40720,1545,3,2444,'App\\Models\\Receipt',2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',9999.98,NULL,NULL,1,'2024-12-15 09:40:52','2024-12-15 09:40:52',NULL),(2552,7705,40720,1545,3,2445,'App\\Models\\Receipt',2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',8995.14,NULL,NULL,1,'2024-12-15 09:42:36','2024-12-15 09:42:36',NULL),(2553,7705,40720,1545,3,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-03','2024-09-03',4999.94,NULL,NULL,1,'2024-12-15 09:43:34','2024-12-15 09:43:34',NULL),(2554,7705,40720,1545,3,2447,'App\\Models\\Receipt',2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-03','2024-09-03',9999.99,NULL,NULL,1,'2024-12-15 09:44:49','2024-12-15 09:44:49',NULL),(2555,7705,40720,1545,3,2448,'App\\Models\\Receipt',2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-04','2024-09-04',24999.16,NULL,NULL,1,'2024-12-15 09:45:50','2024-12-15 09:45:50',NULL),(2556,7705,40720,1545,3,2449,'App\\Models\\Receipt',2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-04','2024-09-04',5000.03,NULL,NULL,1,'2024-12-15 09:47:07','2024-12-15 09:47:07',NULL),(2557,7705,40720,1545,3,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-04','2024-09-04',6000.15,NULL,NULL,1,'2024-12-15 09:48:12','2024-12-15 09:48:12',NULL),(2558,7705,40720,1545,3,2451,'App\\Models\\Receipt',2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-05','2024-09-05',17000.01,NULL,NULL,1,'2024-12-15 09:48:57','2024-12-15 09:48:57',NULL),(2559,7705,40720,1545,3,2452,'App\\Models\\Receipt',2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-05','2024-09-05',9500.01,NULL,NULL,1,'2024-12-15 09:51:35','2024-12-15 09:51:35',NULL),(2560,7705,40720,1545,3,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-05','2024-09-05',8997.51,NULL,NULL,1,'2024-12-15 09:52:36','2024-12-15 09:52:36',NULL),(2561,7705,40720,1545,3,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-06','2024-09-06',24998.60,NULL,NULL,1,'2024-12-15 09:53:16','2024-12-15 09:53:16',NULL);
INSERT INTO `balance_libro` VALUES (2562,7705,40720,1545,3,2455,'App\\Models\\Receipt',2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-06','2024-09-06',44999.83,NULL,NULL,1,'2024-12-15 09:54:02','2024-12-15 09:54:02',NULL),(2563,7705,40720,1545,3,2456,'App\\Models\\Receipt',2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-06','2024-09-06',9999.99,NULL,NULL,1,'2024-12-15 09:54:44','2024-12-15 09:54:44',NULL),(2564,7705,40720,1545,3,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-06','2024-09-06',4999.90,NULL,NULL,1,'2024-12-15 09:56:15','2024-12-15 09:56:15',NULL),(2565,7705,40720,1545,3,2458,'App\\Models\\Receipt',2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-06','2024-09-06',10000.40,NULL,NULL,1,'2024-12-15 09:57:05','2024-12-15 09:57:05',NULL),(2566,7705,40720,1545,3,2459,'App\\Models\\Receipt',2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-06','2024-09-06',5003.05,NULL,NULL,1,'2024-12-15 09:58:00','2024-12-15 09:58:00',NULL),(2567,7705,40720,1545,3,2460,'App\\Models\\Receipt',2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-06','2024-09-06',5003.96,NULL,NULL,1,'2024-12-15 09:58:48','2024-12-15 09:58:48',NULL),(2568,7705,40720,1545,3,2461,'App\\Models\\Receipt',2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-07','2024-09-07',20001.29,NULL,NULL,1,'2024-12-15 09:59:45','2024-12-15 09:59:45',NULL),(2569,7705,40720,1545,3,2462,'App\\Models\\Receipt',2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-07','2024-09-07',30000.11,NULL,NULL,1,'2024-12-15 10:00:40','2024-12-15 10:00:40',NULL),(2570,7705,40720,1545,3,2463,'App\\Models\\Receipt',2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-07','2024-09-07',30001.95,NULL,NULL,1,'2024-12-15 10:01:40','2024-12-15 10:01:40',NULL),(2571,7705,40720,1545,3,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-09','2024-09-09',4997.31,NULL,NULL,1,'2024-12-15 10:03:23','2024-12-15 10:03:23',NULL),(2572,7705,40720,1545,3,2465,'App\\Models\\Receipt',2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-09','2024-09-09',10002.07,NULL,NULL,1,'2024-12-15 10:05:51','2024-12-15 10:05:51',NULL),(2573,7705,40720,1545,3,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-09','2024-09-09',9999.99,NULL,NULL,1,'2024-12-15 20:19:23','2024-12-15 20:19:23',NULL),(2574,7705,40720,1545,3,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-09','2024-09-09',56997.65,NULL,NULL,1,'2024-12-15 20:20:24','2024-12-15 20:20:24',NULL),(2575,7705,40720,1545,3,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-10','2024-09-10',10000.03,NULL,NULL,1,'2024-12-15 20:21:20','2024-12-15 20:21:20',NULL),(2576,7705,40720,1545,3,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-10','2024-09-10',6000.65,NULL,NULL,1,'2024-12-15 20:23:12','2024-12-15 20:23:12',NULL),(2577,7705,40720,1545,3,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-10','2024-09-10',9500.05,NULL,NULL,1,'2024-12-15 20:23:56','2024-12-15 20:23:56',NULL),(2578,7705,40720,1545,3,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-11','2024-09-11',10002.07,NULL,NULL,1,'2024-12-15 20:24:39','2024-12-15 20:24:39',NULL),(2579,7705,40720,1545,3,2472,'App\\Models\\Receipt',2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-11','2024-09-11',9999.89,NULL,NULL,1,'2024-12-15 20:28:36','2024-12-15 20:28:36',NULL),(2580,7705,40720,1545,3,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-11','2024-09-11',10002.07,NULL,NULL,1,'2024-12-18 07:19:25','2024-12-18 07:19:25',NULL),(2581,7705,40720,1545,3,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-12','2024-09-12',5001.03,NULL,NULL,1,'2024-12-18 07:20:21','2024-12-18 07:20:21',NULL),(2582,7705,40720,1545,3,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-12','2024-09-12',10000.65,NULL,NULL,1,'2024-12-18 07:31:55','2024-12-18 07:31:55',NULL);
INSERT INTO `balance_libro` VALUES (2583,7705,40720,1545,3,2476,'App\\Models\\Receipt',2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-13','2024-09-13',10002.07,NULL,NULL,1,'2024-12-18 07:33:31','2024-12-18 07:33:31',NULL),(2584,7705,40720,1545,3,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-13','2024-09-13',7000.00,NULL,NULL,1,'2024-12-18 07:35:50','2024-12-18 07:35:50',NULL),(2585,7705,40720,1545,3,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-13','2024-09-13',135005.69,NULL,NULL,1,'2024-12-18 07:36:57','2024-12-18 07:36:57',NULL),(2586,7705,40720,1545,3,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-14','2024-09-14',10000.65,NULL,NULL,1,'2024-12-18 07:37:40','2024-12-18 07:37:40',NULL),(2587,7705,40720,1545,3,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-14','2024-09-14',5000.20,NULL,NULL,1,'2024-12-18 07:39:19','2024-12-18 07:39:19',NULL),(2588,7705,40720,1545,3,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-14','2024-09-14',10000.40,NULL,NULL,1,'2024-12-18 07:39:58','2024-12-18 07:39:58',NULL),(2589,7705,40720,1545,3,2482,'App\\Models\\Receipt',2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-14','2024-09-14',9999.79,NULL,NULL,1,'2024-12-18 07:42:44','2024-12-18 07:42:44',NULL),(2590,7705,40720,1545,3,2483,'App\\Models\\Receipt',2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-14','2024-09-14',10000.00,NULL,NULL,1,'2024-12-18 07:43:40','2024-12-18 07:43:40',NULL),(2591,7705,40720,1545,3,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-15','2024-09-15',10002.07,NULL,NULL,1,'2024-12-18 07:44:28','2024-12-18 07:44:28',NULL),(2592,7705,40720,1545,3,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-15','2024-09-15',10999.99,NULL,NULL,1,'2024-12-18 07:47:18','2024-12-18 07:47:18',NULL),(2593,7705,40720,1545,3,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-15','2024-09-15',7000.28,NULL,NULL,1,'2024-12-18 07:49:03','2024-12-18 07:49:03',NULL),(2594,7705,40720,1545,3,2487,'App\\Models\\Receipt',2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-15','2024-09-15',3007.46,NULL,NULL,1,'2024-12-18 07:50:10','2024-12-18 07:50:10',NULL),(2595,7705,40720,1545,3,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-15','2024-09-15',14997.96,NULL,NULL,1,'2024-12-18 07:51:33','2024-12-18 07:51:33',NULL),(2596,7705,40720,1545,3,2489,'App\\Models\\Receipt',2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-16','2024-09-16',11300.01,NULL,NULL,1,'2024-12-18 07:52:33','2024-12-18 07:52:33',NULL),(2597,7705,40720,1545,3,2490,'App\\Models\\Receipt',2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-16','2024-09-16',10002.07,NULL,NULL,1,'2024-12-18 07:53:28','2024-12-18 07:53:28',NULL),(2598,7705,40720,1545,3,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-16','2024-09-16',5000.04,NULL,NULL,1,'2024-12-18 07:54:25','2024-12-18 07:54:25',NULL),(2599,7705,40720,1545,3,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-16','2024-09-16',80000.00,NULL,NULL,1,'2024-12-18 07:55:21','2024-12-18 07:55:21',NULL),(2600,7705,40720,1545,3,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-16','2024-09-16',24100.20,NULL,NULL,1,'2024-12-18 07:56:31','2024-12-18 07:56:31',NULL),(2601,7705,40720,1545,3,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-17','2024-09-17',5000.20,NULL,NULL,1,'2024-12-18 07:58:20','2024-12-18 07:58:20',NULL),(2602,7705,40720,1545,3,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-17','2024-09-17',14999.95,NULL,NULL,1,'2024-12-18 07:59:51','2024-12-18 07:59:51',NULL),(2603,7705,40720,1545,3,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-17','2024-09-17',10000.40,NULL,NULL,1,'2024-12-18 08:00:51','2024-12-18 08:00:51',NULL);
INSERT INTO `balance_libro` VALUES (2604,7705,40720,1545,3,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-17','2024-09-17',6999.27,NULL,NULL,1,'2024-12-18 08:01:38','2024-12-18 08:01:38',NULL),(2605,7705,40720,1545,3,2498,'App\\Models\\Receipt',2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',7998.39,NULL,NULL,1,'2024-12-18 08:02:21','2024-12-18 08:02:21',NULL),(2606,7705,40745,3058,3,2499,'App\\Models\\Receipt',2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',20002.79,NULL,NULL,1,'2024-12-19 06:06:12','2024-12-19 06:06:12',NULL),(2607,7705,40745,3058,3,2500,'App\\Models\\Receipt',2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',52300.00,NULL,NULL,1,'2024-12-19 06:08:17','2024-12-19 06:08:17',NULL),(2608,7705,40745,3058,3,2501,'App\\Models\\Receipt',2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-13','2024-07-13',20000.81,NULL,NULL,1,'2024-12-19 06:10:02','2024-12-19 06:10:02',NULL),(2609,7705,40745,3058,3,2502,'App\\Models\\Receipt',2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-21','2024-07-21',29999.78,NULL,NULL,1,'2024-12-19 06:10:58','2024-12-19 06:10:58',NULL),(2610,7705,40745,3058,3,2503,'App\\Models\\Receipt',2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-03','2024-09-03',19999.84,NULL,NULL,1,'2024-12-19 06:12:31','2024-12-19 06:12:31',NULL),(2611,7705,40745,3058,3,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-06','2024-09-06',19999.84,NULL,NULL,1,'2024-12-19 06:14:05','2024-12-19 06:14:05',NULL),(2612,7705,40745,3058,3,2505,'App\\Models\\Receipt',2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-11','2024-09-11',20002.18,NULL,NULL,1,'2024-12-19 06:14:55','2024-12-19 06:14:55',NULL),(2613,7705,40745,3058,3,2506,'App\\Models\\Receipt',2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-13','2024-09-13',19999.84,NULL,NULL,1,'2024-12-19 06:16:08','2024-12-19 06:16:08',NULL),(2614,7705,40745,3058,3,2507,'App\\Models\\Receipt',2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',20010.00,NULL,NULL,1,'2024-12-19 06:17:12','2024-12-19 06:17:12',NULL),(2615,7705,40745,3058,3,2508,'App\\Models\\Receipt',2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',13006.50,NULL,NULL,1,'2024-12-19 06:17:59','2024-12-19 06:17:59',NULL),(2616,7705,40745,3058,3,2509,'App\\Models\\Receipt',2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-21','2024-09-21',547598.53,NULL,NULL,1,'2024-12-19 06:19:13','2024-12-19 06:19:13',NULL),(2617,7705,40745,3058,3,2510,'App\\Models\\Receipt',2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-25','2024-09-25',54100.65,NULL,NULL,1,'2024-12-19 06:20:30','2024-12-19 06:20:30',NULL),(2618,7705,40745,3058,3,2511,'App\\Models\\Receipt',2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-15','2024-10-15',19999.64,NULL,NULL,1,'2024-12-19 06:22:34','2024-12-19 06:22:34',NULL),(2619,7705,40745,3058,3,2512,'App\\Models\\Receipt',2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-29','2024-10-29',61037.50,NULL,NULL,1,'2024-12-19 06:23:26','2024-12-19 06:23:26',NULL),(2620,7705,40720,1545,3,2513,'App\\Models\\Receipt',2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-05','2024-09-05',49998.97,NULL,NULL,1,'2024-12-20 07:02:07','2024-12-20 07:02:07',NULL),(2621,7705,40720,1545,3,2514,'App\\Models\\Receipt',2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',5000.04,NULL,NULL,1,'2024-12-20 07:03:30','2024-12-20 07:03:30',NULL),(2622,7705,40720,1545,3,2515,'App\\Models\\Receipt',2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',9400.01,NULL,NULL,1,'2024-12-22 07:58:13','2024-12-22 07:58:13',NULL),(2623,7705,40720,1545,3,2516,'App\\Models\\Receipt',2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',117005.67,NULL,NULL,1,'2024-12-22 08:08:20','2024-12-22 08:08:20',NULL),(2624,7705,40720,1545,3,2517,'App\\Models\\Receipt',2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',115000.14,NULL,NULL,1,'2024-12-22 08:11:18','2024-12-22 08:11:18',NULL);
INSERT INTO `balance_libro` VALUES (2625,7705,40720,1545,3,2518,'App\\Models\\Receipt',2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-19','2024-09-19',83003.42,NULL,NULL,1,'2024-12-22 08:12:13','2024-12-22 08:12:13',NULL),(2626,7705,40720,1545,3,2519,'App\\Models\\Receipt',2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-19','2024-09-19',70007.35,NULL,NULL,1,'2024-12-22 08:13:34','2024-12-22 08:13:34',NULL),(2627,7705,40720,1545,3,2520,'App\\Models\\Receipt',2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-19','2024-09-19',10002.07,NULL,NULL,1,'2024-12-22 08:14:32','2024-12-22 08:14:32',NULL),(2628,7705,40720,1545,3,2521,'App\\Models\\Receipt',2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-19','2024-09-19',5000.20,NULL,NULL,1,'2024-12-22 08:15:24','2024-12-22 08:15:24',NULL),(2629,7705,40720,1545,3,2522,'App\\Models\\Receipt',2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-20','2024-09-20',10002.07,NULL,NULL,1,'2024-12-22 08:17:04','2024-12-22 08:17:04',NULL),(2630,7705,40720,1545,3,2523,'App\\Models\\Receipt',2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-20','2024-09-20',5000.20,NULL,NULL,1,'2024-12-22 08:17:51','2024-12-22 08:17:51',NULL),(2631,7705,40720,1545,3,2524,'App\\Models\\Receipt',2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-20','2024-09-20',10000.40,NULL,NULL,1,'2024-12-22 08:18:53','2024-12-22 08:18:53',NULL),(2632,7705,40720,1545,3,2525,'App\\Models\\Receipt',2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-21','2024-09-21',10000.65,NULL,NULL,1,'2024-12-22 08:19:46','2024-12-22 08:19:46',NULL),(2633,7705,40720,1545,3,2526,'App\\Models\\Receipt',2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-22','2024-09-22',10000.65,NULL,NULL,1,'2024-12-22 08:20:35','2024-12-22 08:20:35',NULL),(2634,7705,40720,1545,3,2527,'App\\Models\\Receipt',2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-24','2024-09-24',104008.42,NULL,NULL,1,'2024-12-22 08:21:22','2024-12-22 08:21:22',NULL),(2635,7705,40720,1545,3,2528,'App\\Models\\Receipt',2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-24','2024-09-24',130349.77,NULL,NULL,1,'2024-12-22 08:22:05','2024-12-22 08:22:05',NULL),(2636,7705,40720,1545,3,2529,'App\\Models\\Receipt',2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-23','2024-09-23',88809.74,NULL,NULL,1,'2024-12-22 08:23:07','2024-12-22 08:23:07',NULL),(2637,7705,40720,1545,3,2530,'App\\Models\\Receipt',2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-23','2024-09-23',5000.20,NULL,NULL,1,'2024-12-22 08:24:02','2024-12-22 08:24:02',NULL),(2638,7705,40720,1545,3,2531,'App\\Models\\Receipt',2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-23','2024-09-23',10002.07,NULL,NULL,1,'2024-12-22 08:24:53','2024-12-22 08:24:53',NULL),(2639,7705,40720,1545,3,2532,'App\\Models\\Receipt',2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-24','2024-09-24',10000.40,NULL,NULL,1,'2024-12-22 08:31:35','2024-12-22 08:31:35',NULL),(2640,7705,40720,1545,3,2533,'App\\Models\\Receipt',2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-24','2024-09-24',10002.07,NULL,NULL,1,'2024-12-22 08:32:23','2024-12-22 08:32:23',NULL),(2641,7705,40720,1545,3,2534,'App\\Models\\Receipt',2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-25','2024-09-25',111336.77,NULL,NULL,1,'2024-12-22 08:36:47','2024-12-22 08:36:47',NULL),(2642,7705,40720,1545,3,2535,'App\\Models\\Receipt',2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-25','2024-09-25',5000.01,NULL,NULL,1,'2024-12-22 08:38:15','2024-12-22 08:38:15',NULL),(2643,7705,40720,1545,3,2536,'App\\Models\\Receipt',2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-25','2024-09-25',10002.07,NULL,NULL,1,'2024-12-22 08:39:03','2024-12-22 08:39:03',NULL),(2644,7705,40720,1545,3,2537,'App\\Models\\Receipt',2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-25','2024-09-25',9400.01,NULL,NULL,1,'2024-12-22 08:40:10','2024-12-22 08:40:10',NULL),(2645,7705,40720,1545,3,2538,'App\\Models\\Receipt',2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-25','2024-09-25',13001.45,NULL,NULL,1,'2024-12-22 08:41:35','2024-12-22 08:41:35',NULL);
INSERT INTO `balance_libro` VALUES (2646,7705,40720,1545,3,2539,'App\\Models\\Receipt',2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-26','2024-09-26',10000.03,NULL,NULL,1,'2024-12-22 08:42:26','2024-12-22 08:42:26',NULL),(2647,7705,40720,1545,3,2540,'App\\Models\\Receipt',2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-26','2024-09-26',5000.20,NULL,NULL,1,'2024-12-22 08:43:21','2024-12-22 08:43:21',NULL),(2648,7705,40720,1545,3,2541,'App\\Models\\Receipt',2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-26','2024-09-26',9400.01,NULL,NULL,1,'2024-12-22 08:43:57','2024-12-22 08:43:57',NULL),(2649,7705,40720,1545,3,2542,'App\\Models\\Receipt',2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-26','2024-09-26',7003.49,NULL,NULL,1,'2024-12-22 08:44:46','2024-12-22 08:44:46',NULL),(2650,7705,40720,1545,3,2543,'App\\Models\\Receipt',2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-26','2024-09-26',16995.16,NULL,NULL,1,'2024-12-22 08:45:27','2024-12-22 08:45:27',NULL),(2651,7705,40720,1545,3,2544,'App\\Models\\Receipt',2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-26','2024-09-26',20001.29,NULL,NULL,1,'2024-12-22 08:46:10','2024-12-22 08:46:10',NULL),(2652,7705,40720,1545,3,2545,'App\\Models\\Receipt',2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-27','2024-09-27',105003.73,NULL,NULL,1,'2024-12-22 08:47:42','2024-12-22 08:47:42',NULL),(2653,7705,40720,1545,3,2546,'App\\Models\\Receipt',2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-27','2024-09-27',7998.39,NULL,NULL,1,'2024-12-22 08:48:30','2024-12-22 08:48:30',NULL),(2654,7705,40720,1545,3,2547,'App\\Models\\Receipt',2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-27','2024-09-27',9999.99,NULL,NULL,1,'2024-12-22 08:49:22','2024-12-22 08:49:22',NULL),(2655,7705,40720,1545,3,2548,'App\\Models\\Receipt',2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-27','2024-09-27',5000.02,NULL,NULL,1,'2024-12-22 08:50:02','2024-12-22 08:50:02',NULL),(2656,7705,40720,1545,3,2549,'App\\Models\\Receipt',2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-27','2024-09-27',68313.94,NULL,NULL,1,'2024-12-22 08:50:58','2024-12-22 08:50:58',NULL),(2657,7705,40720,1545,3,2550,'App\\Models\\Receipt',2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-27','2024-09-27',12000.01,NULL,NULL,1,'2024-12-22 08:52:16','2024-12-22 08:53:03','2024-12-22 08:53:03'),(2658,7705,40720,1545,3,2550,'App\\Models\\Receipt',2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-27','2024-09-27',12000.01,NULL,NULL,1,'2024-12-22 08:53:03','2024-12-22 08:53:03',NULL),(2659,7705,40720,1545,3,2551,'App\\Models\\Receipt',2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-28','2024-09-28',9400.01,NULL,NULL,1,'2024-12-22 08:54:32','2024-12-22 08:54:32',NULL),(2660,7705,40720,1545,3,2552,'App\\Models\\Receipt',2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-28','2024-09-28',9999.99,NULL,NULL,1,'2024-12-22 08:55:53','2024-12-22 08:55:53',NULL),(2661,7705,40720,1545,3,2553,'App\\Models\\Receipt',2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-28','2024-09-28',10000.40,NULL,NULL,1,'2024-12-22 08:56:45','2024-12-22 08:56:45',NULL),(2662,7705,40720,1545,3,2554,'App\\Models\\Receipt',2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-28','2024-09-28',24998.60,NULL,NULL,1,'2024-12-22 08:57:38','2024-12-22 08:57:38',NULL),(2663,7705,40720,1545,3,2555,'App\\Models\\Receipt',2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-29','2024-09-29',20000.06,NULL,NULL,1,'2024-12-22 08:58:31','2024-12-22 08:58:31',NULL),(2664,7705,40720,1545,3,2556,'App\\Models\\Receipt',2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-29','2024-09-29',24998.60,NULL,NULL,1,'2024-12-22 08:59:18','2024-12-22 08:59:18',NULL),(2665,7705,40720,1545,3,2557,'App\\Models\\Receipt',2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-29','2024-09-29',9400.01,NULL,NULL,1,'2024-12-22 08:59:57','2024-12-22 08:59:57',NULL),(2666,7705,40720,1545,3,2558,'App\\Models\\Receipt',2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-29','2024-09-29',10002.07,NULL,NULL,1,'2024-12-22 09:00:45','2024-12-22 09:00:45',NULL);
INSERT INTO `balance_libro` VALUES (2667,7705,40720,1545,3,2559,'App\\Models\\Receipt',2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-29','2024-09-29',10000.40,NULL,NULL,1,'2024-12-22 09:01:29','2024-12-22 09:01:29',NULL),(2668,7705,40720,1545,3,2560,'App\\Models\\Receipt',2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-29','2024-09-29',5000.04,NULL,NULL,1,'2024-12-22 09:02:37','2024-12-22 09:02:37',NULL),(2669,7705,40720,1545,3,2561,'App\\Models\\Receipt',2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',70030.46,NULL,NULL,1,'2024-12-22 09:04:39','2024-12-22 09:04:39',NULL),(2670,7705,40720,1545,3,2562,'App\\Models\\Receipt',2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',7998.10,NULL,NULL,1,'2024-12-22 09:05:38','2024-12-22 09:05:38',NULL),(2671,7705,40720,1545,3,2563,'App\\Models\\Receipt',2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-12','2024-09-12',19998.70,NULL,NULL,1,'2024-12-22 09:06:28','2024-12-22 09:06:28',NULL),(2672,7705,40720,1545,3,2564,'App\\Models\\Receipt',2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-11','2024-09-11',9680.00,NULL,NULL,1,'2024-12-22 09:07:55','2024-12-22 09:07:55',NULL),(2673,7705,40720,1545,3,2565,'App\\Models\\Receipt',2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-24','2024-09-24',10600.01,NULL,NULL,1,'2024-12-22 09:09:22','2024-12-22 09:09:22',NULL),(2674,7705,40720,1545,3,2566,'App\\Models\\Receipt',2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',17319.94,NULL,NULL,1,'2024-12-22 09:19:31','2024-12-22 09:19:31',NULL),(2675,7705,40720,1545,3,2567,'App\\Models\\Receipt',2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-19','2024-09-19',75000.00,NULL,NULL,1,'2024-12-22 09:20:55','2024-12-22 09:20:55',NULL),(2676,7705,40720,1545,3,2568,'App\\Models\\Receipt',2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',95300.00,NULL,NULL,1,'2024-12-22 09:22:34','2024-12-22 09:22:34',NULL),(2677,7705,40720,1546,3,2569,'App\\Models\\Receipt',2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',158010.26,NULL,NULL,1,'2024-12-22 17:57:19','2024-12-22 17:57:19',NULL),(2678,7705,40720,1546,3,2570,'App\\Models\\Receipt',2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',97999.82,NULL,NULL,1,'2024-12-22 17:58:07','2024-12-22 17:58:07',NULL),(2679,7705,40720,1546,3,2571,'App\\Models\\Receipt',2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',6000.16,NULL,NULL,1,'2024-12-22 17:59:10','2024-12-22 17:59:10',NULL),(2680,7705,40720,1546,3,2572,'App\\Models\\Receipt',2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',9999.85,NULL,NULL,1,'2024-12-22 18:00:30','2024-12-22 18:00:30',NULL),(2681,7705,40720,1546,3,2573,'App\\Models\\Receipt',2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',10000.00,NULL,NULL,1,'2024-12-22 18:01:52','2024-12-22 18:01:52',NULL),(2682,7705,40720,1546,3,2574,'App\\Models\\Receipt',2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-03','2024-10-03',20001.29,NULL,NULL,1,'2024-12-22 18:03:06','2024-12-22 18:03:06',NULL),(2683,7705,40720,1546,3,2575,'App\\Models\\Receipt',2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-03','2024-10-03',10002.07,NULL,NULL,1,'2024-12-22 18:04:05','2024-12-22 18:04:05',NULL),(2684,7705,40720,1546,3,2576,'App\\Models\\Receipt',2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-03','2024-10-03',5000.01,NULL,NULL,1,'2024-12-22 18:05:17','2024-12-22 18:05:17',NULL),(2685,7705,40720,1546,3,2577,'App\\Models\\Receipt',2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-03','2024-10-03',10000.03,NULL,NULL,1,'2024-12-22 18:06:09','2024-12-22 18:06:09',NULL),(2686,7705,40720,1546,3,2578,'App\\Models\\Receipt',2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-04','2024-10-04',9400.00,NULL,NULL,1,'2024-12-22 18:07:20','2024-12-22 18:07:20',NULL),(2687,7705,40720,1546,3,2579,'App\\Models\\Receipt',2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-04','2024-10-04',9999.99,NULL,NULL,1,'2024-12-22 18:08:14','2024-12-22 18:08:14',NULL);
INSERT INTO `balance_libro` VALUES (2688,7705,40720,1546,3,2580,'App\\Models\\Receipt',2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-04','2024-10-04',13999.70,NULL,NULL,1,'2024-12-22 18:10:44','2024-12-22 18:10:44',NULL),(2689,7705,40720,1546,3,2581,'App\\Models\\Receipt',2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-05','2024-10-05',9999.84,NULL,NULL,1,'2024-12-22 18:11:45','2024-12-22 18:11:45',NULL),(2690,7705,40720,1546,3,2582,'App\\Models\\Receipt',2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-05','2024-10-05',14997.66,NULL,NULL,1,'2024-12-22 18:13:00','2024-12-22 18:13:00',NULL),(2691,7705,40720,1546,3,2583,'App\\Models\\Receipt',2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-05','2024-10-05',24998.59,NULL,NULL,1,'2024-12-22 18:13:51','2024-12-22 18:13:51',NULL),(2692,7705,40720,1546,3,2584,'App\\Models\\Receipt',2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-05','2024-10-05',41498.69,NULL,NULL,1,'2024-12-22 18:14:38','2024-12-22 18:14:38',NULL),(2693,7705,40720,1546,3,2585,'App\\Models\\Receipt',2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-06','2024-10-06',9999.84,NULL,NULL,1,'2024-12-22 18:15:46','2024-12-22 18:15:46',NULL),(2694,7705,40720,1546,3,2586,'App\\Models\\Receipt',2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-06','2024-10-06',9999.90,NULL,NULL,1,'2024-12-22 18:17:03','2024-12-22 18:17:03',NULL),(2695,7705,40720,1546,3,2587,'App\\Models\\Receipt',2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-06','2024-10-06',9999.84,NULL,NULL,1,'2024-12-22 18:18:05','2024-12-22 18:18:05',NULL),(2696,7705,40720,1546,3,2588,'App\\Models\\Receipt',2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',4999.92,NULL,NULL,1,'2024-12-22 18:19:05','2024-12-22 18:19:05',NULL),(2697,7705,40720,1546,3,2589,'App\\Models\\Receipt',2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',155502.93,NULL,NULL,1,'2024-12-22 18:20:00','2024-12-22 18:20:00',NULL),(2698,7705,40720,1546,3,2590,'App\\Models\\Receipt',2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',10000.00,NULL,NULL,1,'2024-12-22 18:21:58','2024-12-22 18:21:58',NULL),(2699,7705,40720,1546,3,2591,'App\\Models\\Receipt',2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',9999.84,NULL,NULL,1,'2024-12-22 18:22:48','2024-12-22 18:22:48',NULL),(2700,7705,40720,1546,3,2592,'App\\Models\\Receipt',2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',72001.95,NULL,NULL,1,'2024-12-22 18:23:50','2024-12-22 18:23:50',NULL),(2701,7705,40720,1546,3,2593,'App\\Models\\Receipt',2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-08','2024-10-08',133000.01,NULL,NULL,1,'2024-12-22 18:24:42','2024-12-22 18:24:42',NULL),(2702,7705,40720,1546,3,2594,'App\\Models\\Receipt',2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-08','2024-10-08',24998.59,NULL,NULL,1,'2024-12-22 18:25:40','2024-12-22 18:25:40',NULL),(2703,7705,40720,1546,3,2595,'App\\Models\\Receipt',2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-08','2024-10-08',10000.66,NULL,NULL,1,'2024-12-22 18:26:19','2024-12-22 18:26:19',NULL),(2704,7705,40720,1546,3,2596,'App\\Models\\Receipt',2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-08','2024-10-08',9400.04,NULL,NULL,1,'2024-12-22 18:27:27','2024-12-22 18:27:27',NULL),(2705,7705,40720,1546,3,2597,'App\\Models\\Receipt',2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-08','2024-10-08',5001.03,NULL,NULL,1,'2024-12-22 18:28:21','2024-12-22 18:28:21',NULL),(2706,7705,40720,1546,3,2598,'App\\Models\\Receipt',2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-08','2024-10-08',10002.06,NULL,NULL,1,'2024-12-22 18:29:17','2024-12-22 18:29:17',NULL),(2707,7705,40720,1546,3,2599,'App\\Models\\Receipt',2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-09','2024-10-09',10000.04,NULL,NULL,1,'2024-12-22 18:30:12','2024-12-22 18:30:12',NULL),(2708,7705,40720,1546,3,2600,'App\\Models\\Receipt',2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-09','2024-10-09',9999.84,NULL,NULL,1,'2024-12-22 18:31:11','2024-12-22 18:31:11',NULL);
INSERT INTO `balance_libro` VALUES (2709,7705,40720,1546,3,2601,'App\\Models\\Receipt',2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-09','2024-10-09',212407.60,NULL,NULL,1,'2024-12-22 18:32:26','2024-12-22 18:32:26',NULL),(2710,7705,40720,1546,3,2602,'App\\Models\\Receipt',2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-09','2024-10-09',38304.99,NULL,NULL,1,'2024-12-22 18:34:52','2024-12-22 18:34:52',NULL),(2711,7705,40720,1546,3,2603,'App\\Models\\Receipt',2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-09','2024-10-09',10002.06,NULL,NULL,1,'2024-12-22 18:36:05','2024-12-22 18:36:05',NULL),(2712,7705,40720,1546,3,2604,'App\\Models\\Receipt',2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-10','2024-10-10',10350.81,NULL,NULL,1,'2024-12-22 18:40:20','2024-12-22 18:40:20',NULL),(2713,7705,40720,1546,3,2605,'App\\Models\\Receipt',2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-10','2024-10-10',164715.44,NULL,NULL,1,'2024-12-22 18:41:22','2024-12-22 18:41:22',NULL),(2714,7705,40720,1546,3,2606,'App\\Models\\Receipt',2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-11','2024-10-11',9999.84,NULL,NULL,1,'2024-12-22 18:42:53','2024-12-22 18:42:53',NULL),(2715,7705,40720,1546,3,2607,'App\\Models\\Receipt',2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-11','2024-10-11',9999.84,NULL,NULL,1,'2024-12-22 18:43:56','2024-12-22 18:43:56',NULL),(2716,7705,40720,1546,3,2608,'App\\Models\\Receipt',2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-11','2024-10-11',20001.31,NULL,NULL,1,'2024-12-22 18:45:47','2024-12-22 18:45:47',NULL),(2717,7705,40720,1546,3,2609,'App\\Models\\Receipt',2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-11','2024-10-11',10000.00,NULL,NULL,1,'2024-12-22 18:48:38','2024-12-22 18:48:38',NULL),(2718,7705,40720,1546,3,2610,'App\\Models\\Receipt',2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-11','2024-10-11',10002.06,NULL,NULL,1,'2024-12-22 18:49:48','2024-12-22 18:49:48',NULL),(2719,7705,40720,1546,3,2611,'App\\Models\\Receipt',2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-13','2024-10-13',10000.66,NULL,NULL,1,'2024-12-22 18:50:49','2024-12-22 18:50:49',NULL),(2720,7705,40720,1546,3,2612,'App\\Models\\Receipt',2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-13','2024-10-13',30001.95,NULL,NULL,1,'2024-12-22 18:51:30','2024-12-22 18:51:30',NULL),(2721,7705,40720,1546,3,2613,'App\\Models\\Receipt',2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-13','2024-10-13',10002.06,NULL,NULL,1,'2024-12-22 18:52:38','2024-12-22 18:52:38',NULL),(2722,7705,40720,1546,3,2614,'App\\Models\\Receipt',2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-14','2024-10-14',9999.90,NULL,NULL,1,'2024-12-22 18:54:11','2024-12-22 18:54:11',NULL),(2723,7705,40720,1546,3,2615,'App\\Models\\Receipt',2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-14','2024-10-14',10002.06,NULL,NULL,1,'2024-12-22 18:55:39','2024-12-22 18:55:39',NULL),(2724,7705,40720,1546,3,2616,'App\\Models\\Receipt',2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-14','2024-10-14',20001.31,NULL,NULL,1,'2024-12-22 18:56:29','2024-12-22 18:56:29',NULL),(2725,7705,40720,1546,3,2617,'App\\Models\\Receipt',2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-14','2024-10-14',70001.29,NULL,NULL,1,'2024-12-22 18:57:26','2024-12-22 18:57:26',NULL),(2726,7705,40720,1546,3,2618,'App\\Models\\Receipt',2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-15','2024-10-15',160000.05,NULL,NULL,1,'2024-12-22 18:58:49','2024-12-22 18:58:49',NULL),(2727,7705,40720,1546,3,2619,'App\\Models\\Receipt',2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-15','2024-10-15',14997.66,NULL,NULL,1,'2024-12-22 19:00:12','2024-12-22 19:00:12',NULL),(2728,7705,40720,1546,3,2620,'App\\Models\\Receipt',2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-15','2024-10-15',9400.02,NULL,NULL,1,'2024-12-22 19:02:23','2024-12-22 19:02:23',NULL),(2729,7705,40720,1546,3,2621,'App\\Models\\Receipt',2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-15','2024-10-15',5001.03,NULL,NULL,1,'2024-12-22 19:03:40','2024-12-22 19:03:40',NULL);
INSERT INTO `balance_libro` VALUES (2730,7705,40720,1546,3,2622,'App\\Models\\Receipt',2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-16','2024-10-16',14997.66,NULL,NULL,1,'2024-12-22 19:04:45','2024-12-22 19:04:45',NULL),(2731,7705,40720,1546,3,2623,'App\\Models\\Receipt',2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-16','2024-10-16',20001.31,NULL,NULL,1,'2024-12-22 19:05:32','2024-12-22 19:05:32',NULL),(2732,7705,40720,1546,3,2624,'App\\Models\\Receipt',2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-16','2024-10-16',30001.95,NULL,NULL,1,'2024-12-22 19:06:18','2024-12-22 19:06:18',NULL),(2733,7705,40720,1546,3,2625,'App\\Models\\Receipt',2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-16','2024-10-16',10000.04,NULL,NULL,1,'2024-12-22 19:07:25','2024-12-22 19:07:25',NULL),(2734,7705,40720,1546,3,2626,'App\\Models\\Receipt',2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-17','2024-10-17',10000.66,NULL,NULL,1,'2024-12-22 19:08:43','2024-12-22 19:08:43',NULL),(2735,7705,40720,1546,3,2627,'App\\Models\\Receipt',2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-17','2024-10-17',4999.93,NULL,NULL,1,'2024-12-22 19:10:53','2024-12-22 19:10:53',NULL),(2736,7705,40720,1546,3,2628,'App\\Models\\Receipt',2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-17','2024-10-17',9999.84,NULL,NULL,1,'2024-12-22 19:11:43','2024-12-22 19:11:43',NULL),(2737,7705,40720,1546,3,2629,'App\\Models\\Receipt',2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-17','2024-10-17',10002.06,NULL,NULL,1,'2024-12-22 19:12:33','2024-12-22 19:12:33',NULL),(2738,7705,40720,1546,3,2630,'App\\Models\\Receipt',2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-18','2024-10-18',9000.01,NULL,NULL,1,'2024-12-22 19:13:24','2024-12-22 19:13:24',NULL),(2739,7705,40720,1546,3,2631,'App\\Models\\Receipt',2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-18','2024-10-18',9999.84,NULL,NULL,1,'2024-12-22 19:14:27','2024-12-22 19:14:27',NULL),(2740,7705,40720,1546,3,2632,'App\\Models\\Receipt',2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-18','2024-10-18',45977.00,NULL,NULL,1,'2024-12-22 19:16:09','2024-12-22 19:16:09',NULL),(2741,7705,40720,1546,3,2633,'App\\Models\\Receipt',2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-18','2024-10-18',20001.31,NULL,NULL,1,'2024-12-22 19:16:51','2024-12-22 19:16:51',NULL),(2742,7705,40720,1546,3,2634,'App\\Models\\Receipt',2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-18','2024-10-18',9998.55,NULL,NULL,1,'2024-12-22 19:17:50','2024-12-22 19:17:50',NULL),(2743,7705,40720,1546,3,2635,'App\\Models\\Receipt',2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-18','2024-10-18',10003.72,NULL,NULL,1,'2024-12-22 19:19:02','2024-12-22 19:19:02',NULL),(2744,7705,40720,1546,3,2636,'App\\Models\\Receipt',2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-18','2024-10-18',9999.99,NULL,NULL,1,'2024-12-22 19:20:48','2024-12-22 19:20:48',NULL),(2745,7705,40720,1546,3,2637,'App\\Models\\Receipt',2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-19','2024-10-19',9400.05,NULL,NULL,1,'2024-12-22 19:22:31','2024-12-22 19:22:31',NULL),(2746,7705,40720,1546,3,2638,'App\\Models\\Receipt',2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-19','2024-10-19',143102.30,NULL,NULL,1,'2024-12-22 19:23:36','2024-12-22 19:23:36',NULL),(2747,7705,40720,1546,3,2639,'App\\Models\\Receipt',2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-19','2024-10-19',20001.31,NULL,NULL,1,'2024-12-22 19:24:35','2024-12-22 19:24:35',NULL),(2748,7705,40720,1546,3,2640,'App\\Models\\Receipt',2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-19','2024-10-19',10002.06,NULL,NULL,1,'2025-01-08 09:48:21','2025-01-08 09:48:21',NULL),(2749,7705,40720,1546,3,2641,'App\\Models\\Receipt',2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-19','2024-10-19',4999.93,NULL,NULL,1,'2025-01-08 09:49:45','2025-01-08 09:49:45',NULL),(2750,7705,40720,1546,3,2642,'App\\Models\\Receipt',2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-19','2024-10-19',24998.59,NULL,NULL,1,'2025-01-08 09:52:17','2025-01-08 09:52:17',NULL);
INSERT INTO `balance_libro` VALUES (2751,7705,40720,1546,3,2643,'App\\Models\\Receipt',2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-19','2024-10-19',4999.93,NULL,NULL,1,'2025-01-08 09:56:55','2025-01-08 09:56:55',NULL),(2752,7705,40720,1546,3,2644,'App\\Models\\Receipt',2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-20','2024-10-20',4999.94,NULL,NULL,1,'2025-01-08 10:00:12','2025-01-08 10:00:12',NULL),(2753,7705,40720,1546,3,2645,'App\\Models\\Receipt',2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-20','2024-10-20',10000.04,NULL,NULL,1,'2025-01-08 10:01:56','2025-01-08 10:01:56',NULL),(2754,7705,40720,1546,3,2646,'App\\Models\\Receipt',2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-20','2024-10-20',15000.06,NULL,NULL,1,'2025-01-08 10:04:56','2025-01-08 11:08:06','2025-01-08 11:08:06'),(2755,7705,40720,1546,3,2647,'App\\Models\\Receipt',2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-20','2024-10-20',4999.93,NULL,NULL,1,'2025-01-08 10:06:55','2025-01-08 10:06:55',NULL),(2756,7705,40720,1546,3,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-21','2024-10-21',35000.04,NULL,NULL,1,'2025-01-08 10:08:32','2025-01-08 10:08:32',NULL),(2757,7705,40720,1546,3,2649,'App\\Models\\Receipt',2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-21','2024-10-21',10002.06,NULL,NULL,1,'2025-01-08 10:10:18','2025-01-08 10:10:18',NULL),(2758,7705,40720,1546,3,2650,'App\\Models\\Receipt',2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-21','2024-10-21',4999.94,NULL,NULL,1,'2025-01-08 10:12:57','2025-01-08 10:12:57',NULL),(2759,7705,40720,1546,3,2651,'App\\Models\\Receipt',2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-21','2024-10-21',55000.16,NULL,NULL,1,'2025-01-08 10:13:57','2025-01-08 10:13:57',NULL),(2760,7705,40720,1546,3,2652,'App\\Models\\Receipt',2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-21','2024-10-21',10002.06,NULL,NULL,1,'2025-01-08 10:14:53','2025-01-08 10:14:53',NULL),(2761,7705,40720,1546,3,2653,'App\\Models\\Receipt',2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-22','2024-10-22',10002.06,NULL,NULL,1,'2025-01-08 10:15:59','2025-01-08 10:15:59',NULL),(2762,7705,40720,1546,3,2654,'App\\Models\\Receipt',2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-22','2024-10-22',14997.96,NULL,NULL,1,'2025-01-08 10:16:47','2025-01-08 10:16:47',NULL),(2763,7705,40720,1546,3,2655,'App\\Models\\Receipt',2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-22','2024-10-22',30001.95,NULL,NULL,1,'2025-01-08 10:18:31','2025-01-08 10:18:31',NULL),(2764,7705,40720,1546,3,2656,'App\\Models\\Receipt',2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-22','2024-10-22',10002.06,NULL,NULL,1,'2025-01-08 10:19:24','2025-01-08 10:19:24',NULL),(2765,7705,40720,1546,3,2657,'App\\Models\\Receipt',2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-22','2024-10-22',5000.01,NULL,NULL,1,'2025-01-08 10:20:27','2025-01-08 10:20:27',NULL),(2766,7705,40720,1546,3,2658,'App\\Models\\Receipt',2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-23','2024-10-23',9400.00,NULL,NULL,1,'2025-01-08 10:22:08','2025-01-08 10:22:08',NULL),(2767,7705,40720,1546,3,2659,'App\\Models\\Receipt',2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-23','2024-10-23',10000.01,NULL,NULL,1,'2025-01-08 10:23:14','2025-01-08 10:23:14',NULL),(2768,7705,40720,1546,3,2660,'App\\Models\\Receipt',2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-23','2024-10-23',20001.31,NULL,NULL,1,'2025-01-08 10:25:02','2025-01-08 10:25:02',NULL),(2769,7705,40720,1546,3,2661,'App\\Models\\Receipt',2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-24','2024-10-24',15000.02,NULL,NULL,1,'2025-01-08 10:26:49','2025-01-08 10:26:49',NULL),(2770,7705,40720,1546,3,2662,'App\\Models\\Receipt',2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-24','2024-10-24',5001.03,NULL,NULL,1,'2025-01-08 10:27:24','2025-01-08 10:27:24',NULL),(2771,7705,40720,1546,3,2663,'App\\Models\\Receipt',2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-24','2024-10-24',10002.06,NULL,NULL,1,'2025-01-08 10:28:03','2025-01-08 10:28:03',NULL);
INSERT INTO `balance_libro` VALUES (2772,7705,40720,1546,3,2664,'App\\Models\\Receipt',2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-25','2024-10-25',24996.76,NULL,NULL,1,'2025-01-08 10:28:56','2025-01-08 10:28:56',NULL),(2773,7705,40720,1546,3,2665,'App\\Models\\Receipt',2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-25','2024-10-25',14997.66,NULL,NULL,1,'2025-01-08 10:29:44','2025-01-08 10:29:44',NULL),(2774,7705,40720,1546,3,2666,'App\\Models\\Receipt',2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-25','2024-10-25',37000.49,NULL,NULL,1,'2025-01-08 10:30:23','2025-01-08 10:30:23',NULL),(2775,7705,40720,1546,3,2667,'App\\Models\\Receipt',2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-26','2024-10-26',49007.93,NULL,NULL,1,'2025-01-08 10:31:09','2025-01-08 10:31:09',NULL),(2776,7705,40720,1546,3,2668,'App\\Models\\Receipt',2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-27','2024-10-27',10000.66,NULL,NULL,1,'2025-01-08 10:31:54','2025-01-08 10:31:54',NULL),(2777,7705,40720,1546,3,2669,'App\\Models\\Receipt',2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-27','2024-10-27',10002.06,NULL,NULL,1,'2025-01-08 10:32:35','2025-01-08 10:32:35',NULL),(2778,7705,40720,1546,3,2670,'App\\Models\\Receipt',2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-27','2024-10-27',5008.08,NULL,NULL,1,'2025-01-08 10:33:26','2025-01-08 10:33:26',NULL),(2779,7705,40720,1546,3,2671,'App\\Models\\Receipt',2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-27','2024-10-27',11350.86,NULL,NULL,1,'2025-01-08 10:34:23','2025-01-08 10:34:23',NULL),(2780,7705,40720,1546,3,2672,'App\\Models\\Receipt',2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-28','2024-10-28',14997.96,NULL,NULL,1,'2025-01-08 10:35:56','2025-01-08 10:35:56',NULL),(2781,7705,40720,1546,3,2673,'App\\Models\\Receipt',2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-28','2024-10-28',10002.06,NULL,NULL,1,'2025-01-08 10:37:21','2025-01-08 10:37:21',NULL),(2782,7705,40720,1546,3,2674,'App\\Models\\Receipt',2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-28','2024-10-28',4999.93,NULL,NULL,1,'2025-01-08 10:45:05','2025-01-08 10:45:05',NULL),(2783,7705,40720,1546,3,2675,'App\\Models\\Receipt',2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-29','2024-10-29',31004.22,NULL,NULL,1,'2025-01-08 10:46:36','2025-01-08 10:46:36',NULL),(2784,7705,40720,1546,3,2676,'App\\Models\\Receipt',2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-29','2024-10-29',14997.96,NULL,NULL,1,'2025-01-08 10:47:28','2025-01-08 10:47:28',NULL),(2785,7705,40720,1546,3,2677,'App\\Models\\Receipt',2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-29','2024-10-29',4999.93,NULL,NULL,1,'2025-01-08 10:48:21','2025-01-08 10:48:21',NULL),(2786,7705,40720,1546,3,2678,'App\\Models\\Receipt',2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-30','2024-10-30',41835.76,NULL,NULL,1,'2025-01-08 10:49:23','2025-01-08 10:49:23',NULL),(2787,7705,40720,1546,3,2679,'App\\Models\\Receipt',2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-30','2024-10-30',10000.00,NULL,NULL,1,'2025-01-08 10:51:28','2025-01-08 10:51:28',NULL),(2788,7705,40720,1546,3,2680,'App\\Models\\Receipt',2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-30','2024-10-30',10002.06,NULL,NULL,1,'2025-01-08 10:52:21','2025-01-08 10:52:21',NULL),(2789,7705,40720,1546,3,2681,'App\\Models\\Receipt',2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',20001.31,NULL,NULL,1,'2025-01-08 10:53:11','2025-01-08 10:53:11',NULL),(2790,7705,40720,1546,3,2682,'App\\Models\\Receipt',2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',14997.66,NULL,NULL,1,'2025-01-08 10:53:56','2025-01-08 10:53:56',NULL),(2791,7705,40720,1546,3,2683,'App\\Models\\Receipt',2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',77563.07,NULL,NULL,1,'2025-01-08 10:54:38','2025-01-08 10:54:38',NULL),(2792,7705,40720,1546,3,2684,'App\\Models\\Receipt',2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-03','2024-10-03',28000.01,NULL,NULL,1,'2025-01-08 10:57:30','2025-01-08 10:57:30',NULL);
INSERT INTO `balance_libro` VALUES (2793,7705,40720,1546,3,2685,'App\\Models\\Receipt',2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-16','2024-10-16',13000.00,NULL,NULL,1,'2025-01-08 10:58:55','2025-01-08 10:58:55',NULL),(2794,7705,40720,1546,3,2686,'App\\Models\\Receipt',2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-23','2024-10-23',420000.00,NULL,NULL,1,'2025-01-08 10:59:59','2025-01-08 10:59:59',NULL),(2795,7705,40720,1546,3,2687,'App\\Models\\Receipt',2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-29','2024-10-29',31000.00,NULL,NULL,1,'2025-01-08 11:02:57','2025-01-08 11:02:57',NULL),(2796,7705,40720,1546,3,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',10000.40,NULL,NULL,1,'2025-01-08 11:05:15','2025-01-08 11:05:15',NULL),(2797,7705,40720,1546,3,2689,'App\\Models\\Receipt',2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',10000.40,NULL,NULL,1,'2025-01-08 11:05:50','2025-01-08 11:05:50',NULL),(2798,7705,40720,1546,3,2646,'App\\Models\\Receipt',2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-20','2024-10-20',15000.06,NULL,NULL,1,'2025-01-08 11:08:06','2025-01-08 11:08:06',NULL),(2799,7705,40720,1547,3,2690,'App\\Models\\Receipt',2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',10001.60,NULL,NULL,1,'2025-01-11 12:06:35','2025-01-11 12:06:35',NULL),(2800,7705,40720,1547,3,2691,'App\\Models\\Receipt',2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',9300.00,NULL,NULL,1,'2025-01-11 12:14:34','2025-01-11 12:14:34',NULL),(2801,7705,40720,1547,3,2692,'App\\Models\\Receipt',2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',24998.11,NULL,NULL,1,'2025-01-11 12:15:33','2025-01-11 12:15:33',NULL),(2802,7705,40720,1547,3,2693,'App\\Models\\Receipt',2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-02','2024-11-02',141005.62,NULL,NULL,1,'2025-01-11 12:16:32','2025-01-11 12:16:32',NULL),(2803,7705,40720,1547,3,2694,'App\\Models\\Receipt',2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-03','2024-11-03',5000.80,NULL,NULL,1,'2025-01-11 12:18:17','2025-01-11 12:18:17',NULL),(2804,7705,40720,1547,3,2695,'App\\Models\\Receipt',2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',10001.60,NULL,NULL,1,'2025-01-11 12:21:06','2025-01-11 12:21:06',NULL),(2805,7705,40720,1547,3,2696,'App\\Models\\Receipt',2696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',30000.19,NULL,NULL,1,'2025-01-11 12:21:48','2025-01-11 12:21:48',NULL),(2806,7705,40720,1547,3,2697,'App\\Models\\Receipt',2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',9998.03,NULL,NULL,1,'2025-01-11 12:22:32','2025-01-11 12:22:32',NULL),(2807,7705,40720,1547,3,2698,'App\\Models\\Receipt',2698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',34999.97,NULL,NULL,1,'2025-01-11 12:24:10','2025-01-11 12:24:10',NULL),(2808,7705,40720,1547,3,2699,'App\\Models\\Receipt',2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',5000.41,NULL,NULL,1,'2025-01-11 12:25:31','2025-01-11 12:25:31',NULL),(2809,7705,40720,1547,3,2700,'App\\Models\\Receipt',2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',7000.00,NULL,NULL,1,'2025-01-11 12:26:32','2025-01-11 12:26:32',NULL),(2810,7705,40720,1547,3,2701,'App\\Models\\Receipt',2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',10001.59,NULL,NULL,1,'2025-01-11 12:27:22','2025-01-11 12:27:22',NULL),(2811,7705,40720,1547,3,2702,'App\\Models\\Receipt',2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',20002.18,NULL,NULL,1,'2025-01-11 12:28:02','2025-01-11 12:28:02',NULL),(2812,7705,40720,1547,3,2703,'App\\Models\\Receipt',2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',9299.96,NULL,NULL,1,'2025-01-11 12:28:43','2025-01-11 12:28:43',NULL),(2813,7705,40720,1547,3,2704,'App\\Models\\Receipt',2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',41753.41,NULL,NULL,1,'2025-01-11 12:30:05','2025-01-11 12:30:05',NULL);
INSERT INTO `balance_libro` VALUES (2814,7705,40720,1547,3,2705,'App\\Models\\Receipt',2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-06','2024-11-06',10001.59,NULL,NULL,1,'2025-01-11 12:30:56','2025-01-11 12:30:56',NULL),(2815,7705,40720,1547,3,2706,'App\\Models\\Receipt',2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-06','2024-11-06',125002.44,NULL,NULL,1,'2025-01-11 12:31:49','2025-01-11 12:31:49',NULL),(2816,7705,40720,1547,3,2707,'App\\Models\\Receipt',2707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-06','2024-11-06',15000.10,NULL,NULL,1,'2025-01-11 12:32:33','2025-01-11 12:32:33',NULL),(2817,7705,40720,1547,3,2708,'App\\Models\\Receipt',2708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-07','2024-11-07',73004.19,NULL,NULL,1,'2025-01-11 12:33:28','2025-01-11 12:33:28',NULL),(2818,7705,40720,1547,3,2709,'App\\Models\\Receipt',2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-07','2024-11-07',9998.03,NULL,NULL,1,'2025-01-11 12:34:06','2025-01-11 12:34:06',NULL),(2819,7705,40720,1547,3,2710,'App\\Models\\Receipt',2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-08','2024-11-08',20002.18,NULL,NULL,1,'2025-01-11 12:35:11','2025-01-11 12:35:11',NULL),(2820,7705,40720,1547,3,2711,'App\\Models\\Receipt',2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-08','2024-11-08',18000.02,NULL,NULL,1,'2025-01-11 12:36:24','2025-01-11 12:36:24',NULL),(2821,7705,40720,1547,3,2712,'App\\Models\\Receipt',2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-08','2024-11-08',28287.76,NULL,NULL,1,'2025-01-11 12:37:14','2025-01-11 12:37:14',NULL),(2822,7705,40720,1547,3,2713,'App\\Models\\Receipt',2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-08','2024-11-08',5000.81,NULL,NULL,1,'2025-01-11 12:38:08','2025-01-11 12:38:08',NULL),(2823,7705,40720,1547,3,2714,'App\\Models\\Receipt',2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-09','2024-11-09',24998.13,NULL,NULL,1,'2025-01-11 12:39:00','2025-01-11 12:39:00',NULL),(2824,7705,40720,1547,3,2715,'App\\Models\\Receipt',2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-11','2024-11-11',67415.33,NULL,NULL,1,'2025-01-11 12:39:54','2025-01-11 12:39:54',NULL),(2825,7705,40720,1547,3,2716,'App\\Models\\Receipt',2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-11','2024-11-11',20002.18,NULL,NULL,1,'2025-01-11 12:40:37','2025-01-11 12:40:37',NULL),(2826,7705,40720,1547,3,2717,'App\\Models\\Receipt',2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-11','2024-11-11',35002.28,NULL,NULL,1,'2025-01-11 12:41:26','2025-01-11 12:41:26',NULL),(2827,7705,40720,1547,3,2718,'App\\Models\\Receipt',2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-11','2024-11-11',58006.45,NULL,NULL,1,'2025-01-11 12:42:23','2025-01-11 12:42:23',NULL),(2828,7705,40720,1547,3,2719,'App\\Models\\Receipt',2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-12','2024-11-12',8999.20,NULL,NULL,1,'2025-01-11 12:44:19','2025-01-11 12:44:19',NULL),(2829,7705,40720,1547,3,2720,'App\\Models\\Receipt',2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-12','2024-11-12',19001.76,NULL,NULL,1,'2025-01-11 12:45:00','2025-01-11 12:45:00',NULL),(2830,7705,40720,1547,3,2721,'App\\Models\\Receipt',2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-13','2024-11-13',5000.41,NULL,NULL,1,'2025-01-11 12:47:10','2025-01-11 12:47:10',NULL),(2831,7705,40720,1547,3,2722,'App\\Models\\Receipt',2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-13','2024-11-13',8002.97,NULL,NULL,1,'2025-01-11 12:48:22','2025-01-11 12:48:22',NULL),(2832,7705,40720,1547,3,2723,'App\\Models\\Receipt',2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-13','2024-11-13',8002.40,NULL,NULL,1,'2025-01-11 15:19:54','2025-01-11 15:19:54',NULL),(2833,7705,40720,1547,3,2724,'App\\Models\\Receipt',2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-13','2024-11-13',9998.03,NULL,NULL,1,'2025-01-11 15:35:28','2025-01-11 15:35:28',NULL),(2834,7705,40720,1547,3,2725,'App\\Models\\Receipt',2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-14','2024-11-14',24999.99,NULL,NULL,1,'2025-01-11 15:36:13','2025-01-11 15:36:13',NULL);
INSERT INTO `balance_libro` VALUES (2835,7705,40720,1547,3,2726,'App\\Models\\Receipt',2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-14','2024-11-14',122501.84,NULL,NULL,1,'2025-01-11 15:37:57','2025-01-11 15:37:57',NULL),(2836,7705,40720,1547,3,2727,'App\\Models\\Receipt',2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-15','2024-11-15',77823.47,NULL,NULL,1,'2025-01-11 15:38:46','2025-01-11 15:38:46',NULL),(2837,7705,40720,1547,3,2728,'App\\Models\\Receipt',2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-15','2024-11-15',50002.37,NULL,NULL,1,'2025-01-11 15:39:49','2025-01-11 15:39:49',NULL),(2838,7705,40720,1547,3,2729,'App\\Models\\Receipt',2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-18','2024-11-18',87016.00,NULL,NULL,1,'2025-01-11 15:42:46','2025-01-11 15:42:46',NULL),(2839,7705,40720,1546,3,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-26','2024-10-26',30000.03,NULL,NULL,1,'2025-01-12 09:03:48','2025-01-12 09:03:48',NULL),(2840,7705,40720,1546,3,2731,'App\\Models\\Receipt',2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-28','2024-10-28',55000.04,NULL,NULL,1,'2025-01-12 09:05:26','2025-01-12 09:05:26',NULL),(2841,7705,40720,1546,3,2732,'App\\Models\\Receipt',2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',10002.06,NULL,NULL,1,'2025-01-12 09:09:15','2025-01-12 09:09:15',NULL),(2842,7705,40720,1546,3,2733,'App\\Models\\Receipt',2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-15','2024-10-15',180000.00,NULL,NULL,1,'2025-01-12 09:27:41','2025-01-12 09:27:41',NULL),(2843,7705,40720,1546,3,2734,'App\\Models\\Receipt',2734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-03','2024-10-03',17500.00,NULL,NULL,1,'2025-01-12 09:42:52','2025-01-12 09:42:52',NULL),(2844,7705,40720,1546,3,2735,'App\\Models\\Receipt',2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-06','2024-10-06',59190.01,NULL,NULL,1,'2025-01-12 09:47:23','2025-01-12 09:47:23',NULL),(2845,7705,40720,1546,3,2736,'App\\Models\\Receipt',2736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-11','2024-10-11',10000.03,NULL,NULL,1,'2025-01-12 09:51:28','2025-01-12 09:51:28',NULL),(2846,7705,40720,1546,3,2737,'App\\Models\\Receipt',2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-11','2024-10-11',16599.00,NULL,NULL,1,'2025-01-12 09:56:07','2025-01-12 09:56:07',NULL),(2847,7705,40720,1546,3,2738,'App\\Models\\Receipt',2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-20','2024-10-20',105000.00,NULL,NULL,1,'2025-01-12 09:57:46','2025-01-12 09:57:46',NULL),(2848,7705,40720,1547,3,2739,'App\\Models\\Receipt',2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-20','2024-11-20',36500.11,NULL,NULL,1,'2025-01-12 10:15:30','2025-01-12 10:15:30',NULL),(2849,7705,40720,1547,3,2740,'App\\Models\\Receipt',2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-20','2024-11-20',120035.70,NULL,NULL,1,'2025-01-12 10:24:48','2025-01-12 10:24:48',NULL),(2850,7705,40720,1547,3,2741,'App\\Models\\Receipt',2741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-25','2024-11-25',24998.13,NULL,NULL,1,'2025-01-12 10:35:10','2025-01-12 10:35:10',NULL),(2851,7705,40720,1547,3,2742,'App\\Models\\Receipt',2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-25','2024-11-25',90000.02,NULL,NULL,1,'2025-01-12 10:36:06','2025-01-12 10:36:06',NULL),(2852,7705,40720,1547,3,2743,'App\\Models\\Receipt',2743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-25','2024-11-25',15000.10,NULL,NULL,1,'2025-01-12 10:36:53','2025-01-12 10:36:53',NULL),(2853,7705,40720,1547,3,2744,'App\\Models\\Receipt',2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-26','2024-11-26',30000.21,NULL,NULL,1,'2025-01-12 10:38:04','2025-01-12 10:38:04',NULL),(2854,7705,40720,1547,3,2745,'App\\Models\\Receipt',2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-26','2024-11-26',15000.10,NULL,NULL,1,'2025-01-12 10:38:47','2025-01-12 10:38:47',NULL),(2855,7705,40720,1547,3,2746,'App\\Models\\Receipt',2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-26','2024-11-26',44998.24,NULL,NULL,1,'2025-01-12 10:39:39','2025-01-12 10:39:39',NULL);
INSERT INTO `balance_libro` VALUES (2856,7705,40720,1547,3,2747,'App\\Models\\Receipt',2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-27','2024-11-27',79994.15,NULL,NULL,1,'2025-01-12 10:40:35','2025-01-12 10:40:35',NULL),(2857,7705,40720,1547,3,2748,'App\\Models\\Receipt',2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-28','2024-11-28',18002.56,NULL,NULL,1,'2025-01-12 10:42:12','2025-01-12 10:42:12',NULL),(2858,7705,40720,1547,3,2749,'App\\Models\\Receipt',2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-28','2024-11-28',31998.13,NULL,NULL,1,'2025-01-12 10:43:07','2025-01-12 10:43:07',NULL),(2859,7705,40720,1547,3,2750,'App\\Models\\Receipt',2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',9998.03,NULL,NULL,1,'2025-01-12 10:44:15','2025-01-12 10:44:15',NULL),(2860,7705,40720,1547,3,2751,'App\\Models\\Receipt',2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',29000.91,NULL,NULL,1,'2025-01-12 10:45:33','2025-01-12 10:45:33',NULL),(2861,7705,40720,1547,3,2752,'App\\Models\\Receipt',2752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',145002.98,NULL,NULL,1,'2025-01-12 10:46:26','2025-01-12 10:46:26',NULL),(2862,7705,40720,1547,3,2753,'App\\Models\\Receipt',2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',3800.01,NULL,NULL,1,'2025-01-12 10:47:52','2025-01-12 11:01:54','2025-01-12 11:01:54'),(2863,7705,40720,1547,3,2754,'App\\Models\\Receipt',2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',200000.00,NULL,NULL,1,'2025-01-12 10:49:05','2025-01-12 11:00:55','2025-01-12 11:00:55'),(2864,7705,40720,1547,3,2755,'App\\Models\\Receipt',2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',26780.93,NULL,NULL,1,'2025-01-12 10:50:19','2025-01-12 11:00:37','2025-01-12 11:00:37'),(2865,7705,40720,1547,3,2756,'App\\Models\\Receipt',2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',2500.01,NULL,NULL,1,'2025-01-12 10:51:22','2025-01-12 11:00:22','2025-01-12 11:00:22'),(2866,7705,40720,1547,3,2757,'App\\Models\\Receipt',2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-07','2024-11-07',17300.01,NULL,NULL,1,'2025-01-12 10:52:19','2025-01-12 11:01:18','2025-01-12 11:01:18'),(2867,7705,40720,1547,3,2758,'App\\Models\\Receipt',2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-09','2024-11-09',15000.01,NULL,NULL,1,'2025-01-12 10:53:55','2025-01-12 10:53:55',NULL),(2868,7705,40720,1547,3,2759,'App\\Models\\Receipt',2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-19','2024-11-19',15000.01,NULL,NULL,1,'2025-01-12 10:55:00','2025-01-12 10:55:00',NULL),(2869,7705,40720,1547,3,2760,'App\\Models\\Receipt',2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-21','2024-11-21',25000.00,NULL,NULL,1,'2025-01-12 10:55:50','2025-01-12 10:55:50',NULL),(2870,7705,40720,1547,3,2761,'App\\Models\\Receipt',2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',11200.00,NULL,NULL,1,'2025-01-12 10:56:52','2025-01-12 10:56:52',NULL),(2871,7705,40720,1547,3,2762,'App\\Models\\Receipt',2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',11776.93,NULL,NULL,1,'2025-01-12 10:57:47','2025-01-12 10:57:47',NULL),(2872,7705,40720,1547,3,2763,'App\\Models\\Receipt',2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',82700.00,NULL,NULL,1,'2025-01-12 10:59:29','2025-01-12 10:59:29',NULL),(2873,7705,40720,1547,3,2756,'App\\Models\\Receipt',2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',2500.01,NULL,NULL,1,'2025-01-12 11:00:22','2025-01-12 11:00:22',NULL),(2874,7705,40720,1547,3,2755,'App\\Models\\Receipt',2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',26780.93,NULL,NULL,1,'2025-01-12 11:00:37','2025-01-12 11:00:37',NULL),(2875,7705,40720,1547,3,2754,'App\\Models\\Receipt',2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',200000.00,NULL,NULL,1,'2025-01-12 11:00:55','2025-01-12 11:00:55',NULL);
INSERT INTO `balance_libro` VALUES (2876,7705,40720,1547,3,2757,'App\\Models\\Receipt',2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-07','2024-11-07',17300.01,NULL,NULL,1,'2025-01-12 11:01:18','2025-01-12 11:01:18',NULL),(2877,7705,40720,1547,3,2753,'App\\Models\\Receipt',2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',3800.00,NULL,NULL,1,'2025-01-12 11:01:54','2025-01-12 11:01:54',NULL),(2878,7705,40720,1548,3,2764,'App\\Models\\Receipt',2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-02','2024-12-02',19999.21,NULL,NULL,1,'2025-01-28 06:26:09','2025-01-28 06:26:09',NULL),(2879,7705,40720,1548,3,2765,'App\\Models\\Receipt',2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',19999.22,NULL,NULL,1,'2025-01-28 06:27:28','2025-01-28 06:27:28',NULL),(2880,7705,40720,1548,3,2766,'App\\Models\\Receipt',2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',100002.36,NULL,NULL,1,'2025-01-28 06:28:15','2025-01-28 06:28:15',NULL),(2881,7705,40720,1548,3,2767,'App\\Models\\Receipt',2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-04','2024-12-04',5003.64,NULL,NULL,1,'2025-01-28 06:29:43','2025-01-28 06:29:43',NULL),(2882,7705,40720,1548,3,2768,'App\\Models\\Receipt',2768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-04','2024-12-04',6001.66,NULL,NULL,1,'2025-01-28 06:30:49','2025-01-28 06:30:49',NULL),(2883,7705,40720,1548,3,2769,'App\\Models\\Receipt',2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-05','2024-12-05',10004.81,NULL,NULL,1,'2025-01-28 06:31:48','2025-01-28 06:31:48',NULL),(2884,7705,40720,1548,3,2770,'App\\Models\\Receipt',2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-05','2024-12-05',50001.18,NULL,NULL,1,'2025-01-28 06:32:45','2025-01-28 06:32:45',NULL),(2885,7705,40720,1548,3,2771,'App\\Models\\Receipt',2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-06','2024-12-06',76891.99,NULL,NULL,1,'2025-01-28 06:33:36','2025-01-28 06:33:36',NULL),(2886,7705,40720,1548,3,2772,'App\\Models\\Receipt',2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-06','2024-12-06',129016.96,NULL,NULL,1,'2025-01-28 06:34:36','2025-01-28 06:34:36',NULL),(2887,7705,40720,1548,3,2773,'App\\Models\\Receipt',2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-07','2024-12-07',14999.96,NULL,NULL,1,'2025-01-28 06:39:37','2025-01-28 06:39:37',NULL),(2888,7705,40720,1548,3,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-08','2024-12-08',70002.60,NULL,NULL,1,'2025-01-28 06:41:00','2025-01-28 06:41:00',NULL),(2889,7705,40720,1548,3,2775,'App\\Models\\Receipt',2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-08','2024-12-08',227029.25,NULL,NULL,1,'2025-01-28 06:41:59','2025-01-28 06:41:59',NULL),(2890,7705,40720,1548,3,2776,'App\\Models\\Receipt',2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-08','2024-12-08',30002.58,NULL,NULL,1,'2025-01-28 06:42:45','2025-01-28 06:42:45',NULL),(2891,7705,40720,1548,3,2777,'App\\Models\\Receipt',2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-09','2024-12-09',30001.98,NULL,NULL,1,'2025-01-28 06:43:28','2025-01-28 06:43:28',NULL),(2892,7705,40720,1548,3,2778,'App\\Models\\Receipt',2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-09','2024-12-09',32999.67,NULL,NULL,1,'2025-01-28 06:44:59','2025-01-28 06:44:59',NULL),(2893,7705,40720,1548,3,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-10','2024-12-10',20003.63,NULL,NULL,1,'2025-01-28 06:50:32','2025-01-28 06:50:32',NULL),(2894,7705,40720,1548,3,2780,'App\\Models\\Receipt',2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-10','2024-12-10',19999.70,NULL,NULL,1,'2025-01-28 06:51:40','2025-01-28 06:51:40',NULL),(2895,7705,40720,1548,3,2781,'App\\Models\\Receipt',2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-10','2024-12-10',4998.23,NULL,NULL,1,'2025-01-28 06:52:35','2025-01-28 06:52:35',NULL),(2896,7705,40720,1548,3,2782,'App\\Models\\Receipt',2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-11','2024-12-11',14999.86,NULL,NULL,1,'2025-01-28 06:54:00','2025-01-28 06:54:00',NULL);
INSERT INTO `balance_libro` VALUES (2897,7705,40720,1548,3,2783,'App\\Models\\Receipt',2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-11','2024-12-11',14999.49,NULL,NULL,1,'2025-01-28 06:55:07','2025-01-28 06:55:07',NULL),(2898,7705,40720,1548,3,2784,'App\\Models\\Receipt',2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-11','2024-12-11',30001.98,NULL,NULL,1,'2025-01-28 06:55:57','2025-01-28 06:55:57',NULL),(2899,7705,40720,1548,3,2785,'App\\Models\\Receipt',2785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-12','2024-12-12',30001.98,NULL,NULL,1,'2025-01-28 06:56:42','2025-01-28 06:56:42',NULL),(2900,7705,40720,1548,3,2786,'App\\Models\\Receipt',2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-12','2024-12-12',6996.84,NULL,NULL,1,'2025-01-28 06:57:45','2025-01-28 06:57:45',NULL),(2901,7705,40720,1548,3,2787,'App\\Models\\Receipt',2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',10002.76,NULL,NULL,1,'2025-01-28 06:58:41','2025-01-28 06:58:41',NULL),(2902,7705,40720,1548,3,2788,'App\\Models\\Receipt',2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-14','2024-12-14',80001.29,NULL,NULL,1,'2025-01-28 07:00:07','2025-01-28 07:00:07',NULL),(2903,7705,40720,1548,3,2789,'App\\Models\\Receipt',2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-14','2024-12-14',39997.76,NULL,NULL,1,'2025-01-28 07:00:47','2025-01-28 07:00:47',NULL),(2904,7705,40720,1548,3,2790,'App\\Models\\Receipt',2790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-15','2024-12-15',29997.23,NULL,NULL,1,'2025-01-28 07:01:37','2025-01-28 07:01:37',NULL),(2905,7705,40720,1548,3,2791,'App\\Models\\Receipt',2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-16','2024-12-16',19999.22,NULL,NULL,1,'2025-01-28 07:02:35','2025-01-28 07:02:35',NULL),(2906,7705,40720,1548,3,2792,'App\\Models\\Receipt',2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-17','2024-12-17',10002.76,NULL,NULL,1,'2025-01-28 07:03:27','2025-01-28 07:03:27',NULL),(2907,7705,40720,1548,3,2793,'App\\Models\\Receipt',2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-17','2024-12-17',10013.76,NULL,NULL,1,'2025-01-28 07:06:53','2025-01-28 07:06:53',NULL),(2908,7705,40720,1548,3,2794,'App\\Models\\Receipt',2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-17','2024-12-17',20001.72,NULL,NULL,1,'2025-01-28 07:15:51','2025-01-28 07:15:51',NULL),(2909,7705,40720,1548,3,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-18','2024-12-18',29999.71,NULL,NULL,1,'2025-01-28 07:17:02','2025-01-28 07:17:02',NULL),(2910,7705,40720,1548,3,2796,'App\\Models\\Receipt',2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-18','2024-12-18',20000.15,NULL,NULL,1,'2025-01-28 07:18:11','2025-01-28 07:18:11',NULL),(2911,7705,40720,1548,3,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-18','2024-12-18',44801.36,NULL,NULL,1,'2025-01-28 07:19:15','2025-01-28 07:19:15',NULL),(2912,7705,40720,1548,3,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-19','2024-12-19',14993.28,NULL,NULL,1,'2025-01-28 07:20:42','2025-01-28 07:20:42',NULL),(2913,7705,40720,1548,3,2799,'App\\Models\\Receipt',2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-19','2024-12-19',14998.45,NULL,NULL,1,'2025-01-28 07:21:49','2025-01-28 07:21:49',NULL),(2914,7705,40720,1548,3,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-19','2024-12-19',10000.87,NULL,NULL,1,'2025-01-28 07:22:41','2025-01-28 07:22:41',NULL),(2915,7705,40720,1548,3,2801,'App\\Models\\Receipt',2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-19','2024-12-19',15000.99,NULL,NULL,1,'2025-01-28 07:24:12','2025-01-28 07:24:12',NULL),(2916,7705,40720,1548,3,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',10000.87,NULL,NULL,1,'2025-01-28 07:25:23','2025-01-28 07:25:23',NULL),(2917,7705,40720,1548,3,2803,'App\\Models\\Receipt',2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',69999.30,NULL,NULL,1,'2025-01-28 07:26:17','2025-01-28 07:26:17',NULL);
INSERT INTO `balance_libro` VALUES (2918,7705,40720,1548,3,2804,'App\\Models\\Receipt',2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',92500.08,NULL,NULL,1,'2025-01-28 07:27:08','2025-01-28 07:27:08',NULL),(2919,7705,40720,1548,3,2805,'App\\Models\\Receipt',2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',20000.16,NULL,NULL,1,'2025-01-28 07:28:45','2025-02-02 09:24:44','2025-02-02 09:24:44'),(2920,7705,40720,1548,3,2806,'App\\Models\\Receipt',2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',80000.04,NULL,NULL,1,'2025-01-28 07:29:46','2025-01-28 07:29:46',NULL),(2921,7705,40720,1548,3,2807,'App\\Models\\Receipt',2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-21','2024-12-21',330606.49,NULL,NULL,1,'2025-01-28 07:30:41','2025-01-28 07:30:41',NULL),(2922,7705,40720,1548,3,2808,'App\\Models\\Receipt',2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-21','2024-12-21',15000.99,NULL,NULL,1,'2025-01-28 07:31:21','2025-01-28 07:31:21',NULL),(2923,7705,40720,1548,3,2809,'App\\Models\\Receipt',2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-21','2024-12-21',20001.72,NULL,NULL,1,'2025-01-28 07:32:04','2025-01-28 07:32:04',NULL),(2924,7705,40720,1548,3,2810,'App\\Models\\Receipt',2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-21','2024-12-21',24999.31,NULL,NULL,1,'2025-01-28 07:32:56','2025-01-28 07:32:56',NULL),(2925,7705,40720,1548,3,2811,'App\\Models\\Receipt',2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-21','2024-12-21',83503.21,NULL,NULL,1,'2025-01-28 07:33:37','2025-01-28 07:33:37',NULL),(2926,7705,40720,1548,3,2812,'App\\Models\\Receipt',2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-22','2024-12-22',43936.47,NULL,NULL,1,'2025-01-28 07:34:58','2025-01-28 07:34:58',NULL),(2927,7705,40720,1548,3,2813,'App\\Models\\Receipt',2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-22','2024-12-22',90024.44,NULL,NULL,1,'2025-01-28 07:35:52','2025-01-28 07:35:52',NULL),(2928,7705,40720,1548,3,2814,'App\\Models\\Receipt',2814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-23','2024-12-23',20000.16,NULL,NULL,1,'2025-02-01 09:13:37','2025-02-01 09:13:37',NULL),(2929,7705,40720,1548,3,2815,'App\\Models\\Receipt',2815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-23','2024-12-23',24999.31,NULL,NULL,1,'2025-02-01 09:16:09','2025-02-01 09:16:09',NULL),(2930,7705,40720,1548,3,2816,'App\\Models\\Receipt',2816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-23','2024-12-23',10002.76,NULL,NULL,1,'2025-02-01 09:17:20','2025-02-01 09:17:20',NULL),(2931,7705,40720,1548,3,2817,'App\\Models\\Receipt',2817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-24','2024-12-24',50004.31,NULL,NULL,1,'2025-02-01 09:18:11','2025-02-01 09:18:11',NULL),(2932,7705,40720,1548,3,2818,'App\\Models\\Receipt',2818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-24','2024-12-24',24999.31,NULL,NULL,1,'2025-02-01 09:20:27','2025-02-01 09:20:27',NULL),(2933,7705,40720,1548,3,2819,'App\\Models\\Receipt',2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-24','2024-12-24',20000.16,NULL,NULL,1,'2025-02-01 09:22:03','2025-02-01 09:22:03',NULL),(2934,7705,40720,1548,3,2820,'App\\Models\\Receipt',2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-24','2024-12-24',44402.20,NULL,NULL,1,'2025-02-01 09:36:28','2025-02-01 09:36:28',NULL),(2935,7705,40720,1548,3,2821,'App\\Models\\Receipt',2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-24','2024-12-24',15000.99,NULL,NULL,1,'2025-02-01 09:37:15','2025-02-01 09:37:15',NULL),(2936,7705,40720,1548,3,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',18002.89,NULL,NULL,1,'2025-02-01 09:38:25','2025-02-01 09:38:25',NULL),(2937,7705,40720,1548,3,2823,'App\\Models\\Receipt',2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',10002.76,NULL,NULL,1,'2025-02-01 09:41:03','2025-02-01 09:41:03',NULL),(2938,7705,40720,1548,3,2824,'App\\Models\\Receipt',2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',39998.45,NULL,NULL,1,'2025-02-01 09:41:50','2025-02-01 09:41:50',NULL);
INSERT INTO `balance_libro` VALUES (2939,7705,40720,1548,3,2825,'App\\Models\\Receipt',2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',30000.26,NULL,NULL,1,'2025-02-01 09:43:05','2025-02-01 09:43:05',NULL),(2940,7705,40720,1548,3,2826,'App\\Models\\Receipt',2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-27','2024-12-27',10000.87,NULL,NULL,1,'2025-02-01 09:44:04','2025-02-01 09:44:04',NULL),(2941,7705,40720,1548,3,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-28','2024-12-28',20001.72,NULL,NULL,1,'2025-02-01 09:44:53','2025-02-01 09:44:53',NULL),(2942,7705,40720,1548,3,2828,'App\\Models\\Receipt',2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-28','2024-12-28',10000.87,NULL,NULL,1,'2025-02-01 09:45:33','2025-02-01 09:45:33',NULL),(2943,7705,40720,1548,3,2829,'App\\Models\\Receipt',2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-29','2024-12-29',30000.26,NULL,NULL,1,'2025-02-01 09:46:55','2025-02-01 09:46:55',NULL),(2944,7705,40720,1548,3,2830,'App\\Models\\Receipt',2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-29','2024-12-29',10000.87,NULL,NULL,1,'2025-02-01 09:48:03','2025-02-01 09:48:03',NULL),(2945,7705,40720,1548,3,2831,'App\\Models\\Receipt',2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-29','2024-12-29',10000.87,NULL,NULL,1,'2025-02-01 09:48:47','2025-02-01 09:48:47',NULL),(2946,7705,40720,1548,3,2832,'App\\Models\\Receipt',2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',20000.16,NULL,NULL,1,'2025-02-01 09:49:45','2025-02-01 09:49:45',NULL),(2947,7705,40720,1548,3,2833,'App\\Models\\Receipt',2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',40000.34,NULL,NULL,1,'2025-02-01 09:50:31','2025-02-01 09:50:31',NULL),(2948,7705,40720,1548,3,2834,'App\\Models\\Receipt',2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',10000.87,NULL,NULL,1,'2025-02-01 09:51:26','2025-02-01 09:51:26',NULL),(2949,7705,40720,1548,3,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',40000.61,NULL,NULL,1,'2025-02-01 09:52:07','2025-02-01 09:52:07',NULL),(2950,7705,40720,1548,3,2836,'App\\Models\\Receipt',2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',10000.87,NULL,NULL,1,'2025-02-01 09:52:46','2025-02-01 09:52:46',NULL),(2951,7705,40720,1548,3,2837,'App\\Models\\Receipt',2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-31','2024-12-31',20000.16,NULL,NULL,1,'2025-02-01 09:53:48','2025-02-01 09:53:48',NULL),(2952,7705,40720,1548,3,2838,'App\\Models\\Receipt',2838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-06','2024-12-06',15000.01,NULL,NULL,1,'2025-02-01 09:55:21','2025-02-01 09:55:21',NULL),(2953,7705,40720,1548,3,2839,'App\\Models\\Receipt',2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-06','2024-12-06',11200.00,NULL,NULL,1,'2025-02-01 09:56:04','2025-02-01 09:56:04',NULL),(2954,7705,40720,1548,3,2840,'App\\Models\\Receipt',2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-11','2024-12-11',5000.01,NULL,NULL,1,'2025-02-01 09:56:47','2025-02-01 09:56:47',NULL),(2955,7705,40720,1548,3,2841,'App\\Models\\Receipt',2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-17','2024-12-17',31000.00,NULL,NULL,1,'2025-02-01 09:58:52','2025-02-01 09:58:52',NULL),(2956,7705,40720,1548,3,2842,'App\\Models\\Receipt',2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-17','2024-12-17',15000.01,NULL,NULL,1,'2025-02-02 09:20:55','2025-02-02 09:20:55',NULL),(2957,7705,40720,1548,3,2843,'App\\Models\\Receipt',2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-26','2024-12-26',25100.01,NULL,NULL,1,'2025-02-02 09:22:03','2025-02-02 09:22:03',NULL),(2958,7705,40720,1548,3,2844,'App\\Models\\Receipt',2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-26','2024-12-26',15000.01,NULL,NULL,1,'2025-02-02 09:22:58','2025-02-02 09:22:58',NULL),(2959,7705,40720,1548,3,2805,'App\\Models\\Receipt',2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',20000.16,NULL,NULL,1,'2025-02-02 09:24:44','2025-02-02 09:24:44',NULL);
INSERT INTO `balance_libro` VALUES (2960,7705,40720,1548,3,2845,'App\\Models\\Receipt',2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-02','2024-12-02',148754.98,NULL,NULL,1,'2025-02-02 09:31:12','2025-02-02 09:31:12',NULL),(2961,7705,40720,1548,3,2846,'App\\Models\\Receipt',2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-08','2024-12-08',19962.45,NULL,NULL,1,'2025-02-02 09:34:11','2025-02-02 09:34:11',NULL),(2962,7705,40720,1548,3,2847,'App\\Models\\Receipt',2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-23','2024-12-23',93000.00,NULL,NULL,1,'2025-02-02 09:37:23','2025-02-02 09:37:23',NULL),(2963,7705,40720,1552,3,2848,'App\\Models\\Receipt',2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-01','2025-01-01',30000.26,NULL,NULL,1,'2025-04-06 18:27:08','2025-04-06 18:27:08',NULL),(2964,7705,40720,1552,3,2849,'App\\Models\\Receipt',2849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-01','2025-01-01',9997.17,NULL,NULL,1,'2025-04-06 18:27:48','2025-04-06 18:27:48',NULL),(2965,7705,40720,1552,3,2850,'App\\Models\\Receipt',2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-02','2025-01-02',15000.43,NULL,NULL,1,'2025-04-06 18:28:47','2025-04-06 18:28:47',NULL),(2966,7705,40720,1552,3,2851,'App\\Models\\Receipt',2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-02','2025-01-02',14998.45,NULL,NULL,1,'2025-04-06 18:29:32','2025-04-06 18:29:32',NULL),(2967,7705,40720,1552,3,2852,'App\\Models\\Receipt',2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-03','2025-01-03',9999.24,NULL,NULL,1,'2025-04-06 18:30:13','2025-04-06 18:30:13',NULL),(2968,7705,40720,1552,3,2853,'App\\Models\\Receipt',2853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-03','2025-01-03',40006.07,NULL,NULL,1,'2025-04-06 18:31:28','2025-04-06 18:31:28',NULL),(2969,7705,40720,1552,3,2854,'App\\Models\\Receipt',2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-03','2025-01-03',9997.34,NULL,NULL,1,'2025-04-06 18:32:02','2025-04-06 18:32:02',NULL),(2970,7705,40720,1552,3,2855,'App\\Models\\Receipt',2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-03','2025-01-03',9999.71,NULL,NULL,1,'2025-04-06 18:32:47','2025-04-06 18:32:47',NULL),(2971,7705,40720,1552,3,2856,'App\\Models\\Receipt',2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-03','2025-01-03',15001.74,NULL,NULL,1,'2025-04-06 18:33:20','2025-04-06 18:33:20',NULL),(2972,7705,40720,1552,3,2857,'App\\Models\\Receipt',2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',10000.99,NULL,NULL,1,'2025-04-06 18:33:56','2025-04-06 18:33:56',NULL),(2973,7705,40720,1552,3,2858,'App\\Models\\Receipt',2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',12000.21,NULL,NULL,1,'2025-04-06 18:34:26','2025-04-06 18:34:26',NULL),(2974,7705,40720,1552,3,2859,'App\\Models\\Receipt',2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-05','2025-01-05',59999.52,NULL,NULL,1,'2025-04-06 18:35:12','2025-04-06 18:35:12',NULL),(2975,7705,40720,1552,3,2860,'App\\Models\\Receipt',2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-05','2025-01-05',11998.72,NULL,NULL,1,'2025-04-06 18:36:18','2025-04-06 18:36:18',NULL),(2976,7705,40720,1552,3,2861,'App\\Models\\Receipt',2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',19999.75,NULL,NULL,1,'2025-04-06 18:37:02','2025-04-06 18:37:02',NULL),(2977,7705,40720,1552,3,2862,'App\\Models\\Receipt',2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-07','2025-01-07',20000.08,NULL,NULL,1,'2025-04-06 18:38:07','2025-04-06 18:38:07',NULL),(2978,7705,40720,1552,3,2863,'App\\Models\\Receipt',2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-07','2025-01-07',24998.00,NULL,NULL,1,'2025-04-06 18:38:47','2025-04-06 18:38:47',NULL),(2979,7705,40720,1552,3,2864,'App\\Models\\Receipt',2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-08','2025-01-08',13997.53,NULL,NULL,1,'2025-04-06 18:39:28','2025-04-06 18:39:28',NULL),(2980,7705,40720,1552,3,2865,'App\\Models\\Receipt',2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-08','2025-01-08',12002.46,NULL,NULL,1,'2025-04-06 18:40:08','2025-04-06 18:40:08',NULL);
INSERT INTO `balance_libro` VALUES (2981,7705,40720,1552,3,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-08','2025-01-08',24998.00,NULL,NULL,1,'2025-04-06 18:40:45','2025-04-06 18:40:45',NULL),(2982,7705,40720,1552,3,2867,'App\\Models\\Receipt',2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-09','2025-01-09',24998.00,NULL,NULL,1,'2025-04-06 18:41:22','2025-04-06 18:41:22',NULL),(2983,7705,40720,1552,3,2868,'App\\Models\\Receipt',2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-09','2025-01-09',20001.97,NULL,NULL,1,'2025-04-06 18:42:01','2025-04-06 18:42:01',NULL),(2984,7705,40720,1552,3,2869,'App\\Models\\Receipt',2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-10','2025-01-10',9994.56,NULL,NULL,1,'2025-04-06 18:42:47','2025-04-06 18:42:47',NULL),(2985,7705,40720,1552,3,2870,'App\\Models\\Receipt',2870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-10','2025-01-10',54798.86,NULL,NULL,1,'2025-04-06 18:43:32','2025-04-06 18:43:32',NULL),(2986,7705,40720,1552,3,2871,'App\\Models\\Receipt',2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-10','2025-01-10',188502.25,NULL,NULL,1,'2025-04-06 18:44:11','2025-04-06 18:44:11',NULL),(2987,7705,40720,1552,3,2872,'App\\Models\\Receipt',2872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-11','2025-01-11',14998.79,NULL,NULL,1,'2025-04-06 18:44:53','2025-04-06 18:44:53',NULL),(2988,7705,40720,1552,3,2873,'App\\Models\\Receipt',2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-11','2025-01-11',40002.59,NULL,NULL,1,'2025-04-06 18:45:30','2025-04-06 18:45:30',NULL),(2989,7705,40720,1552,3,2874,'App\\Models\\Receipt',2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-11','2025-01-11',20001.97,NULL,NULL,1,'2025-04-06 18:46:10','2025-04-06 18:46:10',NULL),(2990,7705,40720,1552,3,2875,'App\\Models\\Receipt',2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-12','2025-01-12',19998.40,NULL,NULL,1,'2025-04-06 18:46:48','2025-04-06 18:46:48',NULL),(2991,7705,40720,1552,3,2876,'App\\Models\\Receipt',2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-12','2025-01-12',10001.00,NULL,NULL,1,'2025-04-06 18:47:33','2025-04-06 18:47:33',NULL),(2992,7705,40720,1552,3,2877,'App\\Models\\Receipt',2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-13','2025-01-13',19294.66,NULL,NULL,1,'2025-04-06 18:48:27','2025-04-06 18:48:27',NULL),(2993,7705,40720,1552,3,2878,'App\\Models\\Receipt',2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-13','2025-01-13',69998.31,NULL,NULL,1,'2025-04-06 19:14:03','2025-04-06 19:14:03',NULL),(2994,7705,40720,1552,3,2879,'App\\Models\\Receipt',2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-13','2025-01-13',59998.75,NULL,NULL,1,'2025-04-06 19:14:41','2025-04-06 19:14:41',NULL),(2995,7705,40720,1552,3,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-13','2025-01-13',20000.02,NULL,NULL,1,'2025-04-06 19:15:18','2025-04-06 19:15:18',NULL),(2996,7705,40720,1552,3,2881,'App\\Models\\Receipt',2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-14','2025-01-14',9006.66,NULL,NULL,1,'2025-04-06 19:16:05','2025-04-06 19:16:05',NULL),(2997,7705,40720,1552,3,2882,'App\\Models\\Receipt',2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-14','2025-01-14',19998.40,NULL,NULL,1,'2025-04-06 19:16:46','2025-04-06 19:16:46',NULL),(2998,7705,40720,1552,3,2883,'App\\Models\\Receipt',2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-14','2025-01-14',84697.27,NULL,NULL,1,'2025-04-06 19:17:22','2025-04-06 19:17:22',NULL),(2999,7705,40720,1552,3,2884,'App\\Models\\Receipt',2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-15','2025-01-15',74306.46,NULL,NULL,1,'2025-04-06 19:18:05','2025-04-06 19:18:05',NULL),(3000,7705,40720,1552,3,2885,'App\\Models\\Receipt',2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-15','2025-01-15',10001.00,NULL,NULL,1,'2025-04-06 19:18:40','2025-04-06 19:18:40',NULL),(3001,7705,40720,1552,3,2886,'App\\Models\\Receipt',2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-15','2025-01-15',33307.85,NULL,NULL,1,'2025-04-06 19:19:14','2025-04-06 19:19:14',NULL);
INSERT INTO `balance_libro` VALUES (3002,7705,40720,1552,3,2887,'App\\Models\\Receipt',2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-15','2025-01-15',19998.40,NULL,NULL,1,'2025-04-06 19:19:50','2025-04-06 19:19:50',NULL),(3003,7705,40720,1552,3,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-16','2025-01-16',30997.28,NULL,NULL,1,'2025-04-06 19:20:26','2025-04-06 19:20:26',NULL),(3004,7705,40720,1552,3,2889,'App\\Models\\Receipt',2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-16','2025-01-16',60004.56,NULL,NULL,1,'2025-04-06 19:20:56','2025-04-06 19:20:56',NULL),(3005,7705,40720,1552,3,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-16','2025-01-16',30002.96,NULL,NULL,1,'2025-04-06 19:21:30','2025-04-06 19:21:30',NULL),(3006,7705,40720,1552,3,2891,'App\\Models\\Receipt',2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-16','2025-01-16',19998.40,NULL,NULL,1,'2025-04-06 19:21:59','2025-04-06 19:21:59',NULL),(3007,7705,40720,1552,3,2892,'App\\Models\\Receipt',2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-17','2025-01-17',70000.50,NULL,NULL,1,'2025-04-06 19:22:33','2025-04-06 19:22:33',NULL),(3008,7705,40720,1552,3,2893,'App\\Models\\Receipt',2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-17','2025-01-17',14998.27,NULL,NULL,1,'2025-04-06 19:23:09','2025-04-06 19:23:09',NULL),(3009,7705,40720,1552,3,2894,'App\\Models\\Receipt',2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-17','2025-01-17',14998.79,NULL,NULL,1,'2025-04-06 19:23:41','2025-04-06 19:23:41',NULL),(3010,7705,40720,1552,3,2895,'App\\Models\\Receipt',2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-18','2025-01-18',35004.23,NULL,NULL,1,'2025-04-06 19:25:05','2025-04-06 19:25:05',NULL),(3011,7705,40720,1552,3,2896,'App\\Models\\Receipt',2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-18','2025-01-18',9999.19,NULL,NULL,1,'2025-04-06 19:25:41','2025-04-06 19:25:41',NULL),(3012,7705,40720,1552,3,2897,'App\\Models\\Receipt',2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-18','2025-01-18',9999.19,NULL,NULL,1,'2025-04-06 19:26:10','2025-04-06 19:26:10',NULL),(3013,7705,40720,1552,3,2898,'App\\Models\\Receipt',2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-19','2025-01-19',10003.52,NULL,NULL,1,'2025-04-06 19:26:54','2025-04-06 19:26:54',NULL),(3014,7705,40720,1552,3,2899,'App\\Models\\Receipt',2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-19','2025-01-19',70000.50,NULL,NULL,1,'2025-04-06 19:27:48','2025-04-06 19:27:48',NULL),(3015,7705,40720,1552,3,2900,'App\\Models\\Receipt',2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-20','2025-01-20',166997.98,NULL,NULL,1,'2025-04-06 19:30:39','2025-04-06 19:30:39',NULL),(3016,7705,40720,1552,3,2901,'App\\Models\\Receipt',2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-20','2025-01-20',133906.03,NULL,NULL,1,'2025-04-06 19:31:37','2025-04-06 19:31:37',NULL),(3017,7705,40720,1552,3,2902,'App\\Models\\Receipt',2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-20','2025-01-20',20001.97,NULL,NULL,1,'2025-04-06 19:32:07','2025-04-06 19:32:07',NULL),(3018,7705,40720,1552,3,2903,'App\\Models\\Receipt',2903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-20','2025-01-20',14998.79,NULL,NULL,1,'2025-04-06 19:32:45','2025-04-06 19:32:45',NULL),(3019,7705,40720,1552,3,2904,'App\\Models\\Receipt',2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-20','2025-01-20',19998.40,NULL,NULL,1,'2025-04-06 19:33:21','2025-04-06 19:33:21',NULL),(3020,7705,40720,1552,3,2905,'App\\Models\\Receipt',2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-21','2025-01-21',30002.96,NULL,NULL,1,'2025-04-06 19:33:54','2025-04-06 19:33:54',NULL),(3021,7705,40720,1552,3,2906,'App\\Models\\Receipt',2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-22','2025-01-22',193002.12,NULL,NULL,1,'2025-04-06 19:34:34','2025-04-06 19:34:34',NULL),(3022,7705,40720,1552,3,2907,'App\\Models\\Receipt',2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-22','2025-01-22',85998.82,NULL,NULL,1,'2025-04-06 19:35:17','2025-04-06 19:35:17',NULL);
INSERT INTO `balance_libro` VALUES (3023,7705,40720,1552,3,2908,'App\\Models\\Receipt',2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-22','2025-01-22',29999.91,NULL,NULL,1,'2025-04-06 19:35:48','2025-04-06 19:35:48',NULL),(3024,7705,40720,1552,3,2909,'App\\Models\\Receipt',2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-22','2025-01-22',30000.98,NULL,NULL,1,'2025-04-06 19:36:19','2025-04-06 19:36:19',NULL),(3025,7705,40720,1552,3,2910,'App\\Models\\Receipt',2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-22','2025-01-22',19998.40,NULL,NULL,1,'2025-04-06 19:36:53','2025-04-06 19:36:53',NULL),(3026,7705,40720,1552,3,2911,'App\\Models\\Receipt',2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-22','2025-01-22',9999.19,NULL,NULL,1,'2025-04-06 19:37:26','2025-04-06 19:37:26',NULL),(3027,7705,40720,1552,3,2912,'App\\Models\\Receipt',2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-24','2025-01-24',30002.96,NULL,NULL,1,'2025-04-06 19:38:06','2025-04-06 19:38:06',NULL),(3028,7705,40720,1552,3,2913,'App\\Models\\Receipt',2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-24','2025-01-24',11686.47,NULL,NULL,1,'2025-04-06 19:38:51','2025-04-06 19:38:51',NULL),(3029,7705,40720,1552,3,2914,'App\\Models\\Receipt',2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-24','2025-01-24',210998.18,NULL,NULL,1,'2025-04-06 19:39:42','2025-04-06 19:39:42',NULL),(3030,7705,40720,1552,3,2915,'App\\Models\\Receipt',2915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-25','2025-01-25',96005.22,NULL,NULL,1,'2025-04-06 19:41:01','2025-04-06 19:41:01',NULL),(3031,7705,40720,1552,3,2916,'App\\Models\\Receipt',2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-25','2025-01-25',14999.96,NULL,NULL,1,'2025-04-06 19:41:30','2025-04-06 19:41:30',NULL),(3032,7705,40720,1552,3,2917,'App\\Models\\Receipt',2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-26','2025-01-26',14998.79,NULL,NULL,1,'2025-04-06 19:42:14','2025-04-06 19:42:14',NULL),(3033,7705,40720,1552,3,2918,'App\\Models\\Receipt',2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-26','2025-01-26',19998.40,NULL,NULL,1,'2025-04-06 19:42:51','2025-04-06 19:42:51',NULL),(3034,7705,40720,1552,3,2919,'App\\Models\\Receipt',2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-26','2025-01-26',9999.19,NULL,NULL,1,'2025-04-06 19:43:25','2025-04-06 19:43:25',NULL),(3035,7705,40720,1552,3,2920,'App\\Models\\Receipt',2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-27','2025-01-27',14998.27,NULL,NULL,1,'2025-04-06 19:44:01','2025-04-06 19:44:01',NULL),(3036,7705,40720,1552,3,2921,'App\\Models\\Receipt',2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-27','2025-01-27',70514.23,NULL,NULL,1,'2025-04-06 19:44:34','2025-04-06 19:44:34',NULL),(3037,7705,40720,1552,3,2922,'App\\Models\\Receipt',2922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-27','2025-01-27',19998.40,NULL,NULL,1,'2025-04-06 19:45:02','2025-04-06 19:45:02',NULL),(3038,7705,40720,1552,3,2923,'App\\Models\\Receipt',2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-27','2025-01-27',10001.00,NULL,NULL,1,'2025-04-06 19:45:33','2025-04-06 19:45:33',NULL),(3039,7705,40720,1552,3,2924,'App\\Models\\Receipt',2924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-28','2025-01-28',13997.53,NULL,NULL,1,'2025-04-06 19:46:18','2025-04-06 19:46:18',NULL),(3040,7705,40720,1552,3,2925,'App\\Models\\Receipt',2925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-28','2025-01-28',19998.40,NULL,NULL,1,'2025-04-06 19:46:54','2025-04-06 19:46:54',NULL),(3041,7705,40720,1552,3,2926,'App\\Models\\Receipt',2926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-29','2025-01-29',7999.51,NULL,NULL,1,'2025-04-06 19:47:29','2025-04-06 19:47:29',NULL),(3042,7705,40720,1552,3,2927,'App\\Models\\Receipt',2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-29','2025-01-29',9999.19,NULL,NULL,1,'2025-04-06 19:48:05','2025-04-06 19:48:05',NULL),(3043,7705,40720,1552,3,2928,'App\\Models\\Receipt',2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-29','2025-01-29',14998.79,NULL,NULL,1,'2025-04-06 19:48:37','2025-04-06 19:48:37',NULL);
INSERT INTO `balance_libro` VALUES (3044,7705,40720,1552,3,2929,'App\\Models\\Receipt',2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-30','2025-01-30',14998.79,NULL,NULL,1,'2025-04-06 19:49:08','2025-04-06 19:49:08',NULL),(3045,7705,40720,1552,3,2930,'App\\Models\\Receipt',2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-30','2025-01-30',9999.19,NULL,NULL,1,'2025-04-06 19:49:37','2025-04-06 19:49:37',NULL),(3046,7705,40720,1552,3,2931,'App\\Models\\Receipt',2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-30','2025-01-30',123001.25,NULL,NULL,1,'2025-04-06 19:50:13','2025-04-06 19:50:13',NULL),(3047,7705,40720,1552,3,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',20001.97,NULL,NULL,1,'2025-04-06 19:50:54','2025-04-06 19:50:54',NULL),(3048,7705,40720,1552,3,2933,'App\\Models\\Receipt',2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',20001.97,NULL,NULL,1,'2025-04-06 19:51:31','2025-04-06 19:51:31',NULL),(3049,7705,40720,1552,3,2934,'App\\Models\\Receipt',2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',10001.00,NULL,NULL,1,'2025-04-06 19:51:59','2025-04-06 19:51:59',NULL),(3050,7705,40720,1552,3,2935,'App\\Models\\Receipt',2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',19998.40,NULL,NULL,1,'2025-04-06 19:52:27','2025-04-06 19:52:27',NULL),(3051,7705,40720,1552,3,2936,'App\\Models\\Receipt',2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',16700.01,NULL,NULL,1,'2025-04-06 19:53:31','2025-04-06 19:53:31',NULL),(3052,7705,40720,1552,3,2937,'App\\Models\\Receipt',2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-10','2025-01-10',15000.01,NULL,NULL,1,'2025-04-06 19:54:24','2025-04-06 19:54:24',NULL),(3053,7705,40720,1552,3,2938,'App\\Models\\Receipt',2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-16','2025-01-16',6200.00,NULL,NULL,1,'2025-04-06 19:55:08','2025-04-06 19:55:08',NULL),(3054,7705,40720,1552,3,2939,'App\\Models\\Receipt',2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-21','2025-01-21',50000.03,NULL,NULL,1,'2025-04-06 19:56:12','2025-04-06 19:56:12',NULL),(3055,7705,40720,1552,3,2940,'App\\Models\\Receipt',2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-22','2025-01-22',28694.23,NULL,NULL,1,'2025-04-06 19:57:58','2025-04-06 19:57:58',NULL),(3056,7705,40720,1552,3,2941,'App\\Models\\Receipt',2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-27','2025-01-27',2950.00,NULL,NULL,1,'2025-04-06 19:58:38','2025-04-06 19:58:38',NULL),(3057,7705,40720,1552,3,2942,'App\\Models\\Receipt',2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-28','2025-01-28',11776.93,NULL,NULL,1,'2025-04-06 19:59:24','2025-04-06 19:59:24',NULL),(3058,7705,40720,1552,3,2943,'App\\Models\\Receipt',2943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-29','2025-01-29',40595.00,NULL,NULL,1,'2025-04-06 20:09:57','2025-04-06 20:09:57',NULL),(3059,7705,40720,1553,3,2944,'App\\Models\\Receipt',2944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-02','2025-02-02',15001.28,NULL,NULL,1,'2025-04-12 16:57:10','2025-04-12 16:57:10',NULL),(3060,7705,40720,1553,3,2945,'App\\Models\\Receipt',2945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-02','2025-02-02',99998.19,NULL,NULL,1,'2025-04-12 16:58:02','2025-04-12 16:58:02',NULL),(3061,7705,40720,1553,3,2946,'App\\Models\\Receipt',2946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-02','2025-02-02',9999.66,NULL,NULL,1,'2025-04-12 16:58:48','2025-04-12 16:58:48',NULL),(3062,7705,40720,1553,3,2947,'App\\Models\\Receipt',2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-03','2025-02-03',19999.32,NULL,NULL,1,'2025-04-12 16:59:36','2025-04-12 16:59:36',NULL),(3063,7705,40720,1553,3,2948,'App\\Models\\Receipt',2948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-04','2025-02-04',39998.64,NULL,NULL,1,'2025-04-12 17:00:20','2025-04-12 17:00:20',NULL),(3064,7705,40720,1553,3,2949,'App\\Models\\Receipt',2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-04','2025-02-04',25005.23,NULL,NULL,1,'2025-04-12 17:01:46','2025-04-12 17:01:46',NULL);
INSERT INTO `balance_libro` VALUES (3065,7705,40720,1553,3,2950,'App\\Models\\Receipt',2950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-04','2025-02-04',9998.88,NULL,NULL,1,'2025-04-12 17:03:06','2025-04-12 17:03:06',NULL),(3066,7705,40720,1553,3,2951,'App\\Models\\Receipt',2951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-05','2025-02-05',19997.77,NULL,NULL,1,'2025-04-12 17:03:48','2025-04-12 17:03:48',NULL),(3067,7705,40720,1553,3,2952,'App\\Models\\Receipt',2952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-05','2025-02-05',112023.36,NULL,NULL,1,'2025-04-12 17:04:30','2025-04-12 17:04:30',NULL),(3068,7705,40720,1553,3,2953,'App\\Models\\Receipt',2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-05','2025-02-05',39998.63,NULL,NULL,1,'2025-04-12 17:05:13','2025-04-12 17:05:13',NULL),(3069,7705,40720,1553,3,2954,'App\\Models\\Receipt',2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-06','2025-02-06',57002.63,NULL,NULL,1,'2025-04-12 17:05:52','2025-04-12 17:05:52',NULL),(3070,7705,40720,1553,3,2955,'App\\Models\\Receipt',2955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-06','2025-02-06',248141.25,NULL,NULL,1,'2025-04-12 17:06:30','2025-04-12 17:06:30',NULL),(3071,7705,40720,1553,3,2956,'App\\Models\\Receipt',2956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-06','2025-02-06',15001.28,NULL,NULL,1,'2025-04-12 17:07:08','2025-04-12 17:07:08',NULL),(3072,7705,40720,1553,3,2957,'App\\Models\\Receipt',2957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-06','2025-02-06',58000.61,NULL,NULL,1,'2025-04-12 17:07:45','2025-04-12 17:07:45',NULL),(3073,7705,40720,1553,3,2958,'App\\Models\\Receipt',2958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-01','2025-02-01',14996.01,NULL,NULL,1,'2025-04-12 17:09:02','2025-04-12 17:09:02',NULL),(3074,7705,40720,1553,3,2959,'App\\Models\\Receipt',2959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-08','2025-02-08',30002.57,NULL,NULL,1,'2025-04-12 17:10:04','2025-04-12 17:10:04',NULL),(3075,7705,40720,1553,3,2960,'App\\Models\\Receipt',2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-09','2025-02-09',19997.77,NULL,NULL,1,'2025-04-12 17:10:44','2025-04-12 17:10:44',NULL),(3076,7705,40720,1553,3,2961,'App\\Models\\Receipt',2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-09','2025-02-09',49998.31,NULL,NULL,1,'2025-04-12 17:11:22','2025-04-12 17:11:22',NULL),(3077,7705,40720,1553,3,2962,'App\\Models\\Receipt',2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-11','2025-02-11',30002.57,NULL,NULL,1,'2025-04-12 17:12:02','2025-04-12 17:12:02',NULL),(3078,7705,40720,1553,3,2963,'App\\Models\\Receipt',2963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-11','2025-02-11',80000.05,NULL,NULL,1,'2025-04-12 17:12:39','2025-04-12 17:12:39',NULL),(3079,7705,40720,1553,3,2964,'App\\Models\\Receipt',2964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-12','2025-02-12',19997.77,NULL,NULL,1,'2025-04-12 17:13:22','2025-04-12 17:13:22',NULL),(3080,7705,40720,1553,3,2965,'App\\Models\\Receipt',2965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-12','2025-02-12',29998.98,NULL,NULL,1,'2025-04-12 17:14:08','2025-04-12 17:14:08',NULL),(3081,7705,40720,1553,3,2966,'App\\Models\\Receipt',2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-13','2025-02-13',19999.32,NULL,NULL,1,'2025-04-12 17:15:08','2025-04-12 17:15:08',NULL),(3082,7705,40720,1553,3,2967,'App\\Models\\Receipt',2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-13','2025-02-13',38998.03,NULL,NULL,1,'2025-04-12 17:15:48','2025-04-12 17:15:48',NULL),(3083,7705,40720,1553,3,2968,'App\\Models\\Receipt',2968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-13','2025-02-13',19997.77,NULL,NULL,1,'2025-04-12 17:16:23','2025-04-12 17:16:23',NULL),(3084,7705,40720,1553,3,2969,'App\\Models\\Receipt',2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-14','2025-02-14',19997.77,NULL,NULL,1,'2025-04-12 17:16:58','2025-04-12 17:16:58',NULL),(3085,7705,40720,1553,3,2970,'App\\Models\\Receipt',2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-15','2025-02-15',29998.98,NULL,NULL,1,'2025-04-12 17:17:40','2025-04-12 17:17:40',NULL);
INSERT INTO `balance_libro` VALUES (3086,7705,40720,1553,3,2971,'App\\Models\\Receipt',2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-15','2025-02-15',19999.32,NULL,NULL,1,'2025-04-12 17:18:28','2025-04-12 17:18:28',NULL),(3087,7705,40720,1553,3,2972,'App\\Models\\Receipt',2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-15','2025-02-15',55500.00,NULL,NULL,1,'2025-04-12 17:19:47','2025-04-12 18:24:30','2025-04-12 18:24:30'),(3088,7705,40720,1553,3,2973,'App\\Models\\Receipt',2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-15','2025-02-15',19999.98,NULL,NULL,1,'2025-04-12 17:21:23','2025-04-12 17:21:23',NULL),(3089,7705,40720,1553,3,2974,'App\\Models\\Receipt',2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-16','2025-02-16',74591.74,NULL,NULL,1,'2025-04-12 17:22:37','2025-04-12 17:22:37',NULL),(3090,7705,40720,1553,3,2975,'App\\Models\\Receipt',2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-17','2025-02-17',19997.77,NULL,NULL,1,'2025-04-12 17:23:37','2025-04-12 17:23:37',NULL),(3091,7705,40720,1553,3,2976,'App\\Models\\Receipt',2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-18','2025-02-18',40001.38,NULL,NULL,1,'2025-04-12 17:24:36','2025-04-12 17:24:36',NULL),(3092,7705,40720,1553,3,2977,'App\\Models\\Receipt',2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-18','2025-02-18',15002.76,NULL,NULL,1,'2025-04-12 17:25:24','2025-04-12 17:25:24',NULL),(3093,7705,40720,1553,3,2978,'App\\Models\\Receipt',2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-18','2025-02-18',19999.32,NULL,NULL,1,'2025-04-12 17:26:03','2025-04-12 17:26:03',NULL),(3094,7705,40720,1553,3,2979,'App\\Models\\Receipt',2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-18','2025-02-18',19997.77,NULL,NULL,1,'2025-04-12 17:26:41','2025-04-12 17:26:41',NULL),(3095,7705,40720,1553,3,2980,'App\\Models\\Receipt',2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-18','2025-02-18',19997.77,NULL,NULL,1,'2025-04-12 17:27:33','2025-04-12 17:27:33',NULL),(3096,7705,40720,1553,3,2981,'App\\Models\\Receipt',2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-19','2025-02-19',9996.80,NULL,NULL,1,'2025-04-12 17:28:51','2025-04-12 17:28:51',NULL),(3097,7705,40720,1553,3,2982,'App\\Models\\Receipt',2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-20','2025-02-20',19999.32,NULL,NULL,1,'2025-04-12 17:29:40','2025-04-12 17:29:40',NULL),(3098,7705,40720,1553,3,2983,'App\\Models\\Receipt',2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-20','2025-02-20',63005.00,NULL,NULL,1,'2025-04-12 17:30:17','2025-04-12 17:30:17',NULL),(3099,7705,40720,1553,3,2984,'App\\Models\\Receipt',2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-20','2025-02-20',30002.57,NULL,NULL,1,'2025-04-12 17:30:57','2025-04-12 17:30:57',NULL),(3100,7705,40720,1553,3,2985,'App\\Models\\Receipt',2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-20','2025-02-20',9999.66,NULL,NULL,1,'2025-04-12 17:31:37','2025-04-12 17:31:37',NULL),(3101,7705,40720,1553,3,2986,'App\\Models\\Receipt',2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-21','2025-02-21',143505.30,NULL,NULL,1,'2025-04-12 17:32:41','2025-04-12 17:32:41',NULL),(3102,7705,40720,1553,3,2987,'App\\Models\\Receipt',2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-21','2025-02-21',67406.27,NULL,NULL,1,'2025-04-12 17:33:24','2025-04-12 17:33:24',NULL),(3103,7705,40720,1553,3,2988,'App\\Models\\Receipt',2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-21','2025-02-21',19997.77,NULL,NULL,1,'2025-04-12 17:34:10','2025-04-12 17:34:10',NULL),(3104,7705,40720,1553,3,2989,'App\\Models\\Receipt',2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-22','2025-02-22',44998.48,NULL,NULL,1,'2025-04-12 17:34:54','2025-04-12 17:34:54',NULL),(3105,7705,40720,1553,3,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-22','2025-02-22',19997.77,NULL,NULL,1,'2025-04-12 17:35:37','2025-04-12 17:35:37',NULL),(3106,7705,40720,1553,3,2991,'App\\Models\\Receipt',2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-22','2025-02-22',9998.88,NULL,NULL,1,'2025-04-12 17:36:09','2025-04-12 17:36:09',NULL);
INSERT INTO `balance_libro` VALUES (3107,7705,40720,1553,3,2992,'App\\Models\\Receipt',2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-23','2025-02-23',19995.32,NULL,NULL,1,'2025-04-12 17:37:00','2025-04-12 17:37:00',NULL),(3108,7705,40720,1553,3,2993,'App\\Models\\Receipt',2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-23','2025-02-23',15001.28,NULL,NULL,1,'2025-04-12 17:37:43','2025-04-12 17:37:43',NULL),(3109,7705,40720,1553,3,2994,'App\\Models\\Receipt',2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-24','2025-02-24',109504.79,NULL,NULL,1,'2025-04-12 17:38:37','2025-04-12 17:38:37',NULL),(3110,7705,40720,1553,3,2995,'App\\Models\\Receipt',2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-24','2025-02-24',19999.32,NULL,NULL,1,'2025-04-12 17:39:15','2025-04-12 17:39:15',NULL),(3111,7705,40720,1553,3,2996,'App\\Models\\Receipt',2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-24','2025-02-24',9999.66,NULL,NULL,1,'2025-04-12 17:39:55','2025-04-12 17:39:55',NULL),(3112,7705,40720,1553,3,2997,'App\\Models\\Receipt',2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-24','2025-02-24',29998.98,NULL,NULL,1,'2025-04-12 17:40:29','2025-04-12 17:40:29',NULL),(3113,7705,40720,1553,3,2998,'App\\Models\\Receipt',2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-24','2025-02-24',9998.88,NULL,NULL,1,'2025-04-12 17:41:04','2025-04-12 17:41:04',NULL),(3114,7705,40720,1553,3,2999,'App\\Models\\Receipt',2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-24','2025-02-24',30002.57,NULL,NULL,1,'2025-04-12 17:41:39','2025-04-12 17:41:39',NULL),(3115,7705,40720,1553,3,3000,'App\\Models\\Receipt',3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-25','2025-02-25',6997.44,NULL,NULL,1,'2025-04-12 17:42:13','2025-04-12 17:42:13',NULL),(3116,7705,40720,1553,3,3001,'App\\Models\\Receipt',3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-25','2025-02-25',40001.45,NULL,NULL,1,'2025-04-12 17:42:45','2025-04-12 17:42:45',NULL),(3117,7705,40720,1553,3,3002,'App\\Models\\Receipt',3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-25','2025-02-25',25002.82,NULL,NULL,1,'2025-04-12 17:43:19','2025-04-12 17:43:19',NULL),(3118,7705,40720,1553,3,3003,'App\\Models\\Receipt',3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-26','2025-02-26',30004.60,NULL,NULL,1,'2025-04-12 17:44:15','2025-04-12 17:44:15',NULL),(3119,7705,40720,1553,3,3004,'App\\Models\\Receipt',3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-26','2025-02-26',67009.19,NULL,NULL,1,'2025-04-12 17:45:00','2025-04-12 17:45:00',NULL),(3120,7705,40720,1553,3,3005,'App\\Models\\Receipt',3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-26','2025-02-26',19999.32,NULL,NULL,1,'2025-04-12 17:45:40','2025-04-12 17:45:40',NULL),(3121,7705,40720,1553,3,3006,'App\\Models\\Receipt',3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-26','2025-02-26',9998.88,NULL,NULL,1,'2025-04-12 17:46:18','2025-04-12 17:46:18',NULL),(3122,7705,40720,1553,3,3007,'App\\Models\\Receipt',3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-26','2025-02-26',9998.88,NULL,NULL,1,'2025-04-12 17:46:56','2025-04-12 17:46:56',NULL),(3123,7705,40720,1553,3,3008,'App\\Models\\Receipt',3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-26','2025-02-26',52004.08,NULL,NULL,1,'2025-04-12 17:47:32','2025-04-12 17:47:32',NULL),(3124,7705,40720,1553,3,3009,'App\\Models\\Receipt',3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-26','2025-02-26',9999.66,NULL,NULL,1,'2025-04-12 17:48:13','2025-04-12 17:48:13',NULL),(3125,7705,40720,1553,3,3010,'App\\Models\\Receipt',3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-27','2025-02-27',9999.66,NULL,NULL,1,'2025-04-12 17:48:57','2025-04-12 17:48:57',NULL),(3126,7705,40720,1553,3,3011,'App\\Models\\Receipt',3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-27','2025-02-27',100001.22,NULL,NULL,1,'2025-04-12 17:49:39','2025-04-12 17:49:39',NULL),(3127,7705,40720,1553,3,3012,'App\\Models\\Receipt',3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-27','2025-02-27',30000.00,NULL,NULL,1,'2025-04-12 17:50:40','2025-04-12 17:50:40',NULL);
INSERT INTO `balance_libro` VALUES (3128,7705,40720,1553,3,3013,'App\\Models\\Receipt',3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',87009.08,NULL,NULL,1,'2025-04-12 17:51:54','2025-04-12 17:51:54',NULL),(3129,7705,40720,1553,3,3014,'App\\Models\\Receipt',3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-03','2025-02-03',21559.78,NULL,NULL,1,'2025-04-12 17:53:04','2025-04-12 17:53:04',NULL),(3130,7705,40720,1553,3,3015,'App\\Models\\Receipt',3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-03','2025-02-03',43400.05,NULL,NULL,1,'2025-04-12 17:53:50','2025-04-12 17:53:50',NULL),(3131,7705,40720,1553,3,3016,'App\\Models\\Receipt',3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-04','2025-02-04',18700.02,NULL,NULL,1,'2025-04-12 17:54:41','2025-04-12 17:54:41',NULL),(3132,7705,40720,1553,3,3017,'App\\Models\\Receipt',3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-04','2025-02-04',4600.01,NULL,NULL,1,'2025-04-12 17:55:10','2025-04-12 17:55:10',NULL),(3133,7705,40720,1553,3,3018,'App\\Models\\Receipt',3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-06','2025-02-06',10000.00,NULL,NULL,1,'2025-04-12 17:56:23','2025-04-12 17:56:23',NULL),(3134,7705,40720,1553,3,3019,'App\\Models\\Receipt',3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-18','2025-02-18',17000.00,NULL,NULL,1,'2025-04-12 17:57:24','2025-04-12 17:57:24',NULL),(3135,7705,40720,1553,3,3020,'App\\Models\\Receipt',3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-25','2025-02-25',6200.00,NULL,NULL,1,'2025-04-12 17:58:04','2025-04-12 17:58:04',NULL),(3136,7705,40720,1553,3,3021,'App\\Models\\Receipt',3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-27','2025-02-27',1313092.00,NULL,NULL,1,'2025-04-12 18:08:35','2025-04-12 18:08:35',NULL),(3137,7705,40720,1553,3,2972,'App\\Models\\Receipt',2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-15','2025-02-15',55500.00,NULL,NULL,1,'2025-04-12 18:24:30','2025-04-12 18:24:30',NULL),(3138,7705,40720,1554,3,3022,'App\\Models\\Receipt',3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-01','2025-03-01',82150.03,NULL,NULL,1,'2025-04-21 06:51:31','2025-04-21 06:51:31',NULL),(3139,7705,40720,1554,3,3023,'App\\Models\\Receipt',3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-01','2025-03-01',49998.29,NULL,NULL,1,'2025-04-21 06:54:09','2025-04-21 06:54:09',NULL),(3140,7705,40720,1554,3,3024,'App\\Models\\Receipt',3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-02','2025-03-02',9998.33,NULL,NULL,1,'2025-04-21 06:54:53','2025-04-21 06:54:53',NULL),(3141,7705,40720,1554,3,3025,'App\\Models\\Receipt',3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-03','2025-03-03',51410.77,NULL,NULL,1,'2025-04-21 06:55:39','2025-04-21 06:55:39',NULL),(3142,7705,40720,1554,3,3026,'App\\Models\\Receipt',3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-03','2025-03-03',14997.32,NULL,NULL,1,'2025-04-21 06:56:19','2025-04-21 06:56:19',NULL),(3143,7705,40720,1554,3,3027,'App\\Models\\Receipt',3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-03','2025-03-03',10002.23,NULL,NULL,1,'2025-04-21 06:57:00','2025-04-21 06:57:00',NULL),(3144,7705,40720,1554,3,3028,'App\\Models\\Receipt',3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-04','2025-03-04',20003.34,NULL,NULL,1,'2025-04-21 06:57:44','2025-04-21 06:57:44',NULL),(3145,7705,40720,1554,3,3029,'App\\Models\\Receipt',3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-04','2025-03-04',20003.34,NULL,NULL,1,'2025-04-21 06:58:29','2025-04-21 06:58:29',NULL),(3146,7705,40720,1554,3,3030,'App\\Models\\Receipt',3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-04','2025-03-04',19998.43,NULL,NULL,1,'2025-04-21 06:59:12','2025-04-21 06:59:12',NULL),(3147,7705,40720,1554,3,3031,'App\\Models\\Receipt',3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-04','2025-03-04',14997.32,NULL,NULL,1,'2025-04-21 06:59:47','2025-04-21 06:59:47',NULL),(3148,7705,40720,1554,3,3032,'App\\Models\\Receipt',3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-04','2025-03-04',10002.23,NULL,NULL,1,'2025-04-21 07:00:34','2025-04-21 07:00:34',NULL);
INSERT INTO `balance_libro` VALUES (3149,7705,40720,1554,3,3033,'App\\Models\\Receipt',3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-05','2025-03-05',69510.99,NULL,NULL,1,'2025-04-21 07:01:24','2025-04-21 07:01:24',NULL),(3150,7705,40720,1554,3,3034,'App\\Models\\Receipt',3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-06','2025-03-06',20003.34,NULL,NULL,1,'2025-04-21 07:02:08','2025-04-21 07:02:08',NULL),(3151,7705,40720,1554,3,3035,'App\\Models\\Receipt',3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-06','2025-03-06',9998.33,NULL,NULL,1,'2025-04-21 20:54:26','2025-04-21 20:54:26',NULL),(3152,7705,40720,1554,3,3036,'App\\Models\\Receipt',3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-06','2025-03-06',10002.23,NULL,NULL,1,'2025-04-21 20:55:09','2025-04-21 20:55:09',NULL),(3153,7705,40720,1554,3,3037,'App\\Models\\Receipt',3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-06','2025-03-06',7999.97,NULL,NULL,1,'2025-04-21 20:55:50','2025-04-21 20:55:50',NULL),(3154,7705,40720,1554,3,3038,'App\\Models\\Receipt',3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-06','2025-03-06',120773.69,NULL,NULL,1,'2025-04-21 21:47:19','2025-04-21 21:47:19',NULL),(3155,7705,40720,1554,3,3039,'App\\Models\\Receipt',3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',30001.66,NULL,NULL,1,'2025-04-21 21:48:01','2025-04-21 21:48:01',NULL),(3156,7705,40720,1554,3,3040,'App\\Models\\Receipt',3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',14997.32,NULL,NULL,1,'2025-04-21 21:48:49','2025-04-21 21:48:49',NULL),(3157,7705,40720,1554,3,3041,'App\\Models\\Receipt',3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',10002.23,NULL,NULL,1,'2025-04-21 21:49:26','2025-04-21 21:49:26',NULL),(3158,7705,40720,1554,3,3042,'App\\Models\\Receipt',3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',60000.83,NULL,NULL,1,'2025-04-21 21:50:24','2025-04-21 21:50:24',NULL),(3159,7705,40720,1554,3,3043,'App\\Models\\Receipt',3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-08','2025-03-08',49998.49,NULL,NULL,1,'2025-04-21 21:51:06','2025-04-21 21:51:06',NULL),(3160,7705,40720,1554,3,3044,'App\\Models\\Receipt',3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-08','2025-03-08',83007.16,NULL,NULL,1,'2025-04-21 21:51:43','2025-04-21 21:51:43',NULL),(3161,7705,40720,1554,3,3045,'App\\Models\\Receipt',3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-09','2025-03-09',20003.34,NULL,NULL,1,'2025-04-21 21:52:19','2025-04-21 21:52:19',NULL),(3162,7705,40720,1554,3,3046,'App\\Models\\Receipt',3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-09','2025-03-09',20003.34,NULL,NULL,1,'2025-04-21 21:52:51','2025-04-21 21:52:51',NULL),(3163,7705,40720,1554,3,3047,'App\\Models\\Receipt',3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-10','2025-03-10',106996.85,NULL,NULL,1,'2025-04-21 21:55:47','2025-04-21 21:55:47',NULL),(3164,7705,40720,1554,3,3048,'App\\Models\\Receipt',3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-10','2025-03-10',125506.06,NULL,NULL,1,'2025-04-21 21:56:37','2025-04-21 21:56:37',NULL),(3165,7705,40720,1554,3,3049,'App\\Models\\Receipt',3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',42007.66,NULL,NULL,1,'2025-04-21 21:57:18','2025-04-21 21:57:18',NULL),(3166,7705,40720,1554,3,3050,'App\\Models\\Receipt',3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',9998.33,NULL,NULL,1,'2025-04-21 21:59:11','2025-04-21 21:59:11',NULL),(3167,7705,40720,1554,3,3051,'App\\Models\\Receipt',3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',49999.86,NULL,NULL,1,'2025-04-21 21:59:41','2025-04-21 21:59:41',NULL),(3168,7705,40720,1554,3,3052,'App\\Models\\Receipt',3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',65002.46,NULL,NULL,1,'2025-04-21 22:00:17','2025-04-21 22:00:17',NULL),(3169,7705,40720,1554,3,3053,'App\\Models\\Receipt',3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',79004.87,NULL,NULL,1,'2025-04-21 22:01:16','2025-04-21 22:01:16',NULL);
INSERT INTO `balance_libro` VALUES (3170,7705,40720,1554,3,3054,'App\\Models\\Receipt',3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',10002.23,NULL,NULL,1,'2025-04-21 22:01:46','2025-04-21 22:01:46',NULL),(3171,7705,40720,1554,3,3055,'App\\Models\\Receipt',3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-12','2025-03-12',10002.23,NULL,NULL,1,'2025-04-21 22:02:29','2025-04-21 22:02:29',NULL),(3172,7705,40720,1554,3,3056,'App\\Models\\Receipt',3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-12','2025-03-12',40000.31,NULL,NULL,1,'2025-04-21 22:03:06','2025-04-21 22:03:06',NULL),(3173,7705,40720,1554,3,3057,'App\\Models\\Receipt',3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-12','2025-03-12',75004.16,NULL,NULL,1,'2025-04-21 22:03:45','2025-04-21 22:03:45',NULL),(3174,7705,40720,1554,3,3058,'App\\Models\\Receipt',3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-13','2025-03-13',112001.63,NULL,NULL,1,'2025-04-21 22:04:32','2025-04-21 22:04:32',NULL),(3175,7705,40720,1554,3,3059,'App\\Models\\Receipt',3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-13','2025-03-13',298008.63,NULL,NULL,1,'2025-04-21 22:05:17','2025-04-21 22:05:17',NULL),(3176,7705,40720,1554,3,3060,'App\\Models\\Receipt',3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-13','2025-03-13',120003.02,NULL,NULL,1,'2025-04-21 22:06:04','2025-04-21 22:06:04',NULL),(3177,7705,40720,1554,3,3061,'App\\Models\\Receipt',3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-13','2025-03-13',67003.06,NULL,NULL,1,'2025-04-21 22:06:42','2025-04-21 22:06:42',NULL),(3178,7705,40720,1554,3,3062,'App\\Models\\Receipt',3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-14','2025-03-14',5001.12,NULL,NULL,1,'2025-04-21 22:07:20','2025-04-21 22:07:20',NULL),(3179,7705,40720,1554,3,3063,'App\\Models\\Receipt',3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-14','2025-03-14',47999.10,NULL,NULL,1,'2025-04-21 22:07:53','2025-04-21 22:07:53',NULL),(3180,7705,40720,1554,3,3064,'App\\Models\\Receipt',3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-17','2025-03-17',7219.92,NULL,NULL,1,'2025-04-21 22:09:06','2025-04-21 22:09:06',NULL),(3181,7705,40720,1554,3,3065,'App\\Models\\Receipt',3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-17','2025-03-17',20000.56,NULL,NULL,1,'2025-04-21 22:09:49','2025-04-21 22:09:49',NULL),(3182,7705,40720,1554,3,3066,'App\\Models\\Receipt',3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-17','2025-03-17',166268.65,NULL,NULL,1,'2025-04-21 22:10:38','2025-04-21 22:10:38',NULL),(3183,7705,40720,1554,3,3067,'App\\Models\\Receipt',3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-18','2025-03-18',10002.23,NULL,NULL,1,'2025-04-21 22:11:17','2025-04-21 22:11:17',NULL),(3184,7705,40720,1554,3,3068,'App\\Models\\Receipt',3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-18','2025-03-18',70001.65,NULL,NULL,1,'2025-04-21 22:12:00','2025-04-21 22:12:00',NULL),(3185,7705,40720,1554,3,3069,'App\\Models\\Receipt',3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-19','2025-03-19',5001.12,NULL,NULL,1,'2025-04-21 22:12:39','2025-04-21 22:12:39',NULL),(3186,7705,40720,1554,3,3070,'App\\Models\\Receipt',3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-19','2025-03-19',10002.23,NULL,NULL,1,'2025-04-21 22:13:09','2025-04-21 22:13:09',NULL),(3187,7705,40720,1554,3,3071,'App\\Models\\Receipt',3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-19','2025-03-19',14997.32,NULL,NULL,1,'2025-04-21 22:13:46','2025-04-21 22:13:46',NULL),(3188,7705,40720,1554,3,3072,'App\\Models\\Receipt',3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-20','2025-03-20',15000.83,NULL,NULL,1,'2025-04-21 22:14:19','2025-04-21 22:14:19',NULL),(3189,7705,40720,1554,3,3073,'App\\Models\\Receipt',3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-20','2025-03-20',39999.99,NULL,NULL,1,'2025-04-21 22:14:53','2025-04-21 22:14:53',NULL),(3190,7705,40720,1554,3,3074,'App\\Models\\Receipt',3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-20','2025-03-20',14997.32,NULL,NULL,1,'2025-04-21 22:15:39','2025-04-21 22:15:39',NULL);
INSERT INTO `balance_libro` VALUES (3191,7705,40720,1554,3,3075,'App\\Models\\Receipt',3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-21','2025-03-21',27000.16,NULL,NULL,1,'2025-04-21 22:16:23','2025-04-21 22:16:23',NULL),(3192,7705,40720,1554,3,3076,'App\\Models\\Receipt',3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-21','2025-03-21',98075.24,NULL,NULL,1,'2025-04-21 22:17:03','2025-04-21 22:17:03',NULL),(3193,7705,40720,1554,3,3077,'App\\Models\\Receipt',3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-21','2025-03-21',14997.32,NULL,NULL,1,'2025-04-21 22:17:54','2025-04-21 22:17:54',NULL),(3194,7705,40720,1554,3,3078,'App\\Models\\Receipt',3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-22','2025-03-22',70006.26,NULL,NULL,1,'2025-04-21 22:18:40','2025-04-21 22:18:40',NULL),(3195,7705,40720,1554,3,3079,'App\\Models\\Receipt',3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-22','2025-03-22',55003.02,NULL,NULL,1,'2025-04-21 22:19:09','2025-04-21 22:19:09',NULL),(3196,7705,40720,1554,3,3080,'App\\Models\\Receipt',3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-22','2025-03-22',107241.07,NULL,NULL,1,'2025-04-21 22:19:42','2025-04-21 22:19:42',NULL),(3197,7705,40720,1554,3,3081,'App\\Models\\Receipt',3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-22','2025-03-22',10002.23,NULL,NULL,1,'2025-04-21 22:20:22','2025-04-21 22:20:22',NULL),(3198,7705,40720,1554,3,3082,'App\\Models\\Receipt',3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',85022.50,NULL,NULL,1,'2025-04-21 22:20:55','2025-04-21 22:20:55',NULL),(3199,7705,40720,1554,3,3083,'App\\Models\\Receipt',3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',10002.23,NULL,NULL,1,'2025-04-21 22:21:24','2025-04-21 22:21:24',NULL),(3200,7705,40720,1554,3,3084,'App\\Models\\Receipt',3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-24','2025-03-24',116393.90,NULL,NULL,1,'2025-04-21 22:22:06','2025-04-21 22:22:06',NULL),(3201,7705,40720,1554,3,3085,'App\\Models\\Receipt',3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-24','2025-03-24',10002.23,NULL,NULL,1,'2025-04-21 22:22:42','2025-04-21 22:22:42',NULL),(3202,7705,40720,1554,3,3086,'App\\Models\\Receipt',3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-25','2025-03-25',9998.33,NULL,NULL,1,'2025-04-21 22:23:20','2025-04-21 22:23:20',NULL),(3203,7705,40720,1554,3,3087,'App\\Models\\Receipt',3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-26','2025-03-26',10002.23,NULL,NULL,1,'2025-04-21 22:24:00','2025-04-21 22:24:00',NULL),(3204,7705,40720,1554,3,3088,'App\\Models\\Receipt',3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-26','2025-03-26',27597.99,NULL,NULL,1,'2025-04-21 22:24:43','2025-04-21 22:24:43',NULL),(3205,7705,40720,1554,3,3089,'App\\Models\\Receipt',3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-26','2025-03-26',10046.93,NULL,NULL,1,'2025-04-21 22:25:57','2025-04-21 22:25:57',NULL),(3206,7705,40720,1554,3,3090,'App\\Models\\Receipt',3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-27','2025-03-27',20000.56,NULL,NULL,1,'2025-04-21 22:26:43','2025-04-21 22:26:43',NULL),(3207,7705,40720,1554,3,3091,'App\\Models\\Receipt',3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-27','2025-03-27',9994.41,NULL,NULL,1,'2025-04-21 22:27:32','2025-04-21 22:27:32',NULL),(3208,7705,40720,1554,3,3092,'App\\Models\\Receipt',3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-27','2025-03-27',43501.60,NULL,NULL,1,'2025-04-21 22:28:20','2025-04-21 22:28:20',NULL),(3209,7705,40720,1554,3,3093,'App\\Models\\Receipt',3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-27','2025-03-27',39999.99,NULL,NULL,1,'2025-04-21 22:28:58','2025-04-21 22:28:58',NULL),(3210,7705,40720,1554,3,3094,'App\\Models\\Receipt',3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-27','2025-03-27',30000.67,NULL,NULL,1,'2025-04-21 22:29:27','2025-04-21 22:29:27',NULL),(3211,7705,40720,1554,3,3095,'App\\Models\\Receipt',3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-27','2025-03-27',9998.33,NULL,NULL,1,'2025-04-21 22:29:59','2025-04-21 22:29:59',NULL);
INSERT INTO `balance_libro` VALUES (3212,7705,40720,1554,3,3096,'App\\Models\\Receipt',3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',5002.40,NULL,NULL,1,'2025-04-21 22:30:37','2025-04-21 22:30:37',NULL),(3213,7705,40720,1554,3,3097,'App\\Models\\Receipt',3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',8000.00,NULL,NULL,1,'2025-04-21 22:31:14','2025-04-21 22:31:14',NULL),(3214,7705,40720,1554,3,3098,'App\\Models\\Receipt',3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',48536.64,NULL,NULL,1,'2025-04-21 22:31:49','2025-04-21 22:31:49',NULL),(3215,7705,40720,1554,3,3099,'App\\Models\\Receipt',3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',54115.48,NULL,NULL,1,'2025-04-21 22:32:22','2025-04-21 22:32:22',NULL),(3216,7705,40720,1554,3,3100,'App\\Models\\Receipt',3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',10002.23,NULL,NULL,1,'2025-04-21 22:32:49','2025-04-21 22:32:49',NULL),(3217,7705,40720,1554,3,3101,'App\\Models\\Receipt',3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',5001.12,NULL,NULL,1,'2025-04-21 22:33:24','2025-04-21 22:33:24',NULL),(3218,7705,40720,1554,3,3102,'App\\Models\\Receipt',3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-29','2025-03-29',7997.33,NULL,NULL,1,'2025-04-21 22:33:56','2025-04-21 22:33:56',NULL),(3219,7705,40720,1554,3,3103,'App\\Models\\Receipt',3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-30','2025-03-30',73160.93,NULL,NULL,1,'2025-04-21 22:34:32','2025-04-21 22:34:32',NULL),(3220,7705,40720,1554,3,3104,'App\\Models\\Receipt',3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-30','2025-03-30',72886.09,NULL,NULL,1,'2025-04-21 22:35:13','2025-04-21 22:35:13',NULL),(3221,7705,40720,1554,3,3105,'App\\Models\\Receipt',3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-05','2025-03-05',11776.93,NULL,NULL,1,'2025-04-21 22:36:29','2025-04-21 22:36:29',NULL),(3222,7705,40720,1554,3,3106,'App\\Models\\Receipt',3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-08','2025-03-08',13000.00,NULL,NULL,1,'2025-04-21 22:37:18','2025-04-21 22:37:18',NULL),(3223,7705,40720,1554,3,3107,'App\\Models\\Receipt',3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-17','2025-03-17',80700.03,NULL,NULL,1,'2025-04-21 22:38:02','2025-04-21 22:38:02',NULL),(3224,7705,40720,1554,3,3108,'App\\Models\\Receipt',3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-27','2025-03-27',12400.01,NULL,NULL,1,'2025-04-21 22:38:43','2025-04-21 22:38:43',NULL),(3225,7705,40720,1554,3,3109,'App\\Models\\Receipt',3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-19','2025-03-19',29400.00,NULL,NULL,1,'2025-04-21 22:49:32','2025-04-21 22:49:32',NULL),(3226,7705,40720,1555,3,3110,'App\\Models\\Receipt',3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-15','2025-03-15',176516.62,NULL,NULL,1,'2025-06-01 10:54:57','2025-06-01 10:54:57',NULL),(3227,7705,40720,1555,3,3111,'App\\Models\\Receipt',3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-01','2025-04-01',9997.34,NULL,NULL,1,'2025-06-01 10:56:22','2025-06-01 10:56:22',NULL),(3228,7705,40720,1555,3,3112,'App\\Models\\Receipt',3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-02','2025-04-02',20001.01,NULL,NULL,1,'2025-06-02 20:40:10','2025-06-02 20:40:10',NULL),(3229,7705,40720,1555,3,3113,'App\\Models\\Receipt',3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-02','2025-04-02',44998.86,NULL,NULL,1,'2025-06-02 20:41:27','2025-06-02 20:41:27',NULL),(3230,7705,40720,1555,3,3114,'App\\Models\\Receipt',3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-03','2025-04-03',19997.98,NULL,NULL,1,'2025-06-03 08:14:27','2025-06-03 08:14:27',NULL),(3231,7705,40720,1555,3,3115,'App\\Models\\Receipt',3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-03','2025-04-03',14997.37,NULL,NULL,1,'2025-06-03 08:15:07','2025-06-03 08:15:07',NULL),(3232,7705,40720,1555,3,3116,'App\\Models\\Receipt',3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-03','2025-04-03',85501.57,NULL,NULL,1,'2025-06-03 08:15:51','2025-06-03 08:15:51',NULL);
INSERT INTO `balance_libro` VALUES (3233,7705,40720,1555,3,3117,'App\\Models\\Receipt',3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-04','2025-04-04',10002.71,NULL,NULL,1,'2025-06-03 08:16:43','2025-06-03 08:16:43',NULL),(3234,7705,40720,1555,3,3118,'App\\Models\\Receipt',3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-04','2025-04-04',20001.01,NULL,NULL,1,'2025-06-03 08:17:39','2025-06-03 08:17:39',NULL),(3235,7705,40720,1555,3,3119,'App\\Models\\Receipt',3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-04','2025-04-04',20001.01,NULL,NULL,1,'2025-06-03 08:18:17','2025-06-03 08:18:17',NULL),(3236,7705,40720,1555,3,3120,'App\\Models\\Receipt',3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-04','2025-04-04',22002.66,NULL,NULL,1,'2025-06-03 08:18:57','2025-06-03 08:18:57',NULL),(3237,7705,40720,1555,3,3121,'App\\Models\\Receipt',3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-05','2025-04-05',30001.49,NULL,NULL,1,'2025-06-03 08:19:54','2025-06-03 08:19:54',NULL),(3238,7705,40720,1555,3,3122,'App\\Models\\Receipt',3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-06','2025-04-06',126999.65,NULL,NULL,1,'2025-06-03 08:20:42','2025-06-03 08:20:42',NULL),(3239,7705,40720,1555,3,3123,'App\\Models\\Receipt',3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-06','2025-04-06',123014.82,NULL,NULL,1,'2025-06-03 08:22:11','2025-06-03 08:22:11',NULL),(3240,7705,40720,1555,3,3124,'App\\Models\\Receipt',3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-07','2025-04-07',30001.49,NULL,NULL,1,'2025-06-03 08:23:06','2025-06-03 08:23:06',NULL),(3241,7705,40720,1555,3,3125,'App\\Models\\Receipt',3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-07','2025-04-07',10000.50,NULL,NULL,1,'2025-06-03 08:24:07','2025-06-03 08:24:07',NULL),(3242,7705,40720,1555,3,3126,'App\\Models\\Receipt',3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-08','2025-04-08',80004.13,NULL,NULL,1,'2025-06-03 08:24:48','2025-06-03 08:24:48',NULL),(3243,7705,40720,1555,3,3127,'App\\Models\\Receipt',3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-08','2025-04-08',184356.07,NULL,NULL,1,'2025-06-03 08:25:30','2025-06-03 08:25:30',NULL),(3244,7705,40720,1555,3,3128,'App\\Models\\Receipt',3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-09','2025-04-09',170015.34,NULL,NULL,1,'2025-06-03 08:26:27','2025-06-03 08:26:27',NULL),(3245,7705,40720,1555,3,3129,'App\\Models\\Receipt',3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-09','2025-04-09',129884.63,NULL,NULL,1,'2025-06-03 08:27:06','2025-06-03 08:27:06',NULL),(3246,7705,40720,1555,3,3130,'App\\Models\\Receipt',3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-04','2025-03-04',95357.73,NULL,NULL,1,'2025-06-16 08:50:32','2025-06-16 08:50:32',NULL),(3247,7705,40720,1555,3,3131,'App\\Models\\Receipt',3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',10002.06,NULL,NULL,1,'2025-06-16 08:52:07','2025-06-16 08:52:07',NULL),(3248,7705,40720,1555,3,3132,'App\\Models\\Receipt',3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',14999.94,NULL,NULL,1,'2025-06-16 08:54:27','2025-06-16 08:54:27',NULL),(3249,7705,40720,1555,3,3133,'App\\Models\\Receipt',3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-11','2025-04-11',124599.43,NULL,NULL,1,'2025-06-16 08:55:20','2025-06-16 08:55:20',NULL),(3250,7705,40720,1555,3,3134,'App\\Models\\Receipt',3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-11','2025-04-11',19997.98,NULL,NULL,1,'2025-06-16 08:56:03','2025-06-16 08:56:03',NULL),(3251,7705,40720,1555,3,3135,'App\\Models\\Receipt',3135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-13','2025-04-13',19997.98,NULL,NULL,1,'2025-06-16 08:56:56','2025-06-16 08:56:56',NULL),(3252,7705,40720,1555,3,3136,'App\\Models\\Receipt',3136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-13','2025-04-13',84009.10,NULL,NULL,1,'2025-06-16 08:58:08','2025-06-16 08:58:08',NULL),(3253,7705,40720,1555,3,3137,'App\\Models\\Receipt',3137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-14','2025-04-14',87999.68,NULL,NULL,1,'2025-06-16 08:58:58','2025-06-16 08:58:58',NULL);
INSERT INTO `balance_libro` VALUES (3254,7705,40720,1555,3,3138,'App\\Models\\Receipt',3138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-14','2025-04-14',19997.98,NULL,NULL,1,'2025-06-16 08:59:41','2025-06-16 08:59:41',NULL),(3255,7705,40720,1555,3,3139,'App\\Models\\Receipt',3139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-14','2025-04-14',10000.50,NULL,NULL,1,'2025-06-16 09:00:22','2025-06-16 09:00:22',NULL),(3256,7705,40720,1555,3,3140,'App\\Models\\Receipt',3140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-14','2025-04-14',72748.17,NULL,NULL,1,'2025-06-16 09:01:27','2025-06-16 09:01:27',NULL),(3257,7705,40720,1555,3,3141,'App\\Models\\Receipt',3141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-15','2025-04-15',142005.96,NULL,NULL,1,'2025-06-16 09:02:21','2025-06-16 09:02:21',NULL),(3258,7705,40720,1555,3,3142,'App\\Models\\Receipt',3142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-15','2025-04-15',19999.95,NULL,NULL,1,'2025-06-16 09:03:04','2025-06-16 09:03:04',NULL),(3259,7705,40720,1555,3,3143,'App\\Models\\Receipt',3143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-16','2025-04-16',9999.97,NULL,NULL,1,'2025-06-16 09:03:58','2025-06-16 09:03:58',NULL),(3260,7705,40720,1555,3,3144,'App\\Models\\Receipt',3144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-16','2025-04-16',30002.07,NULL,NULL,1,'2025-06-16 09:12:15','2025-06-16 09:12:15',NULL),(3261,7705,40720,1555,3,3145,'App\\Models\\Receipt',3145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-16','2025-04-16',40002.01,NULL,NULL,1,'2025-06-16 09:13:28','2025-06-16 09:13:28',NULL),(3262,7705,40720,1555,3,3146,'App\\Models\\Receipt',3146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-17','2025-04-17',14997.37,NULL,NULL,1,'2025-06-16 09:15:44','2025-06-16 09:15:44',NULL),(3263,7705,40720,1555,3,3147,'App\\Models\\Receipt',3147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-17','2025-04-17',19997.98,NULL,NULL,1,'2025-06-16 09:16:25','2025-06-16 09:16:25',NULL),(3264,7705,40720,1555,3,3148,'App\\Models\\Receipt',3148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-17','2025-04-17',154505.93,NULL,NULL,1,'2025-06-16 09:17:17','2025-06-16 09:17:17',NULL),(3265,7705,40720,1555,3,3149,'App\\Models\\Receipt',3149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-17','2025-04-17',10000.50,NULL,NULL,1,'2025-06-16 09:18:03','2025-06-16 09:18:03',NULL),(3266,7705,40720,1555,3,3150,'App\\Models\\Receipt',3150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-18','2025-04-18',30001.51,NULL,NULL,1,'2025-06-16 09:18:52','2025-06-16 09:18:52',NULL),(3267,7705,40720,1555,3,3151,'App\\Models\\Receipt',3151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-19','2025-04-19',20001.01,NULL,NULL,1,'2025-06-16 09:19:33','2025-06-16 09:19:33',NULL),(3268,7705,40720,1555,3,3152,'App\\Models\\Receipt',3152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-20','2025-04-20',20001.01,NULL,NULL,1,'2025-06-16 09:20:15','2025-06-16 09:20:15',NULL),(3269,7705,40720,1555,3,3153,'App\\Models\\Receipt',3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-20','2025-04-20',57998.45,NULL,NULL,1,'2025-06-16 09:20:57','2025-06-16 09:20:57',NULL),(3270,7705,40720,1555,3,3154,'App\\Models\\Receipt',3154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-21','2025-04-21',100010.72,NULL,NULL,1,'2025-06-16 09:21:53','2025-06-16 09:21:53',NULL),(3271,7705,40720,1555,3,3155,'App\\Models\\Receipt',3155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-21','2025-04-21',20001.01,NULL,NULL,1,'2025-06-16 09:23:07','2025-06-16 09:23:07',NULL),(3272,7705,40720,1555,3,3156,'App\\Models\\Receipt',3156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-21','2025-04-21',79003.72,NULL,NULL,1,'2025-06-16 09:23:47','2025-06-16 09:23:47',NULL),(3273,7705,40720,1555,3,3157,'App\\Models\\Receipt',3157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-21','2025-04-21',19997.98,NULL,NULL,1,'2025-06-16 09:24:30','2025-06-16 09:24:30',NULL),(3274,7705,40720,1555,3,3158,'App\\Models\\Receipt',3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-22','2025-04-22',40002.01,NULL,NULL,1,'2025-06-16 09:25:20','2025-06-16 09:25:20',NULL);
INSERT INTO `balance_libro` VALUES (3275,7705,40720,1555,3,3159,'App\\Models\\Receipt',3159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-22','2025-04-22',29999.94,NULL,NULL,1,'2025-06-16 09:26:13','2025-06-16 09:26:13',NULL),(3276,7705,40720,1555,3,3160,'App\\Models\\Receipt',3160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-23','2025-04-23',50000.95,NULL,NULL,1,'2025-06-16 09:26:59','2025-06-16 09:26:59',NULL),(3277,7705,40720,1555,3,3161,'App\\Models\\Receipt',3161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-24','2025-04-24',154520.61,NULL,NULL,1,'2025-06-16 09:27:55','2025-06-16 09:27:55',NULL),(3278,7705,40720,1555,3,3162,'App\\Models\\Receipt',3162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-25','2025-04-25',142018.26,NULL,NULL,1,'2025-06-16 09:28:42','2025-06-16 09:28:42',NULL),(3279,7705,40720,1555,3,3163,'App\\Models\\Receipt',3163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-25','2025-04-25',112492.98,NULL,NULL,1,'2025-06-16 09:29:24','2025-06-16 09:29:24',NULL),(3280,7705,40720,1555,3,3164,'App\\Models\\Receipt',3164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-26','2025-04-26',79496.17,NULL,NULL,1,'2025-06-16 09:30:10','2025-06-16 09:30:10',NULL),(3281,7705,40720,1555,3,3165,'App\\Models\\Receipt',3165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-26','2025-04-26',19997.98,NULL,NULL,1,'2025-06-16 09:30:52','2025-06-16 09:30:52',NULL),(3282,7705,40720,1555,3,3166,'App\\Models\\Receipt',3166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-26','2025-04-26',30000.03,NULL,NULL,1,'2025-06-16 09:31:30','2025-06-16 09:31:30',NULL),(3283,7705,40720,1555,3,3167,'App\\Models\\Receipt',3167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-27','2025-04-27',50002.51,NULL,NULL,1,'2025-06-16 09:32:15','2025-06-16 09:32:15',NULL),(3284,7705,40720,1555,3,3168,'App\\Models\\Receipt',3168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-27','2025-04-27',47998.86,NULL,NULL,1,'2025-06-16 09:32:52','2025-06-16 09:32:52',NULL),(3285,7705,40720,1555,3,3169,'App\\Models\\Receipt',3169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-27','2025-04-27',5998.79,NULL,NULL,1,'2025-06-16 09:33:41','2025-06-16 09:33:41',NULL),(3286,7705,40720,1555,3,3170,'App\\Models\\Receipt',3170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-27','2025-04-27',18997.17,NULL,NULL,1,'2025-06-16 09:34:15','2025-06-16 09:34:15',NULL),(3287,7705,40720,1555,3,3171,'App\\Models\\Receipt',3171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-29','2025-04-29',151113.02,NULL,NULL,1,'2025-06-16 09:35:08','2025-06-16 09:35:08',NULL),(3288,7705,40720,1555,3,3172,'App\\Models\\Receipt',3172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-01','2025-04-01',17000.00,NULL,NULL,1,'2025-06-16 10:22:46','2025-06-16 10:22:46',NULL),(3289,7705,40720,1555,3,3173,'App\\Models\\Receipt',3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-09','2025-04-09',12000.01,NULL,NULL,1,'2025-06-16 10:27:45','2025-06-16 10:27:45',NULL),(3290,7705,40720,1555,3,3174,'App\\Models\\Receipt',3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-15','2025-04-15',5800.00,NULL,NULL,1,'2025-06-16 10:42:12','2025-06-16 10:42:12',NULL),(3291,7705,40720,1555,3,3175,'App\\Models\\Receipt',3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-16','2025-04-16',38400.02,NULL,NULL,1,'2025-06-16 10:43:28','2025-06-16 10:43:28',NULL),(3292,7705,40720,1555,3,3176,'App\\Models\\Receipt',3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-21','2025-04-21',12000.01,NULL,NULL,1,'2025-06-16 10:44:12','2025-06-16 10:44:12',NULL),(3293,7705,40720,1555,3,3177,'App\\Models\\Receipt',3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-24','2025-04-24',11776.93,NULL,NULL,1,'2025-06-16 10:46:27','2025-06-16 10:46:27',NULL),(3294,7705,40720,1555,3,3178,'App\\Models\\Receipt',3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',11776.93,NULL,NULL,1,'2025-06-16 10:47:09','2025-06-16 10:47:09',NULL),(3295,7705,40720,1555,3,3179,'App\\Models\\Receipt',3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',9300.00,NULL,NULL,1,'2025-06-16 10:48:57','2025-06-16 10:48:57',NULL);
INSERT INTO `balance_libro` VALUES (3296,7705,40720,1555,3,3180,'App\\Models\\Receipt',3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-02','2025-04-02',27999.99,NULL,NULL,1,'2025-06-16 11:06:53','2025-06-16 11:06:53',NULL),(3297,7705,40720,1555,3,3181,'App\\Models\\Receipt',3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-14','2025-04-14',356950.00,NULL,NULL,1,'2025-06-16 11:08:29','2025-06-16 11:08:29',NULL),(3298,7705,40720,1555,3,3182,'App\\Models\\Receipt',3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-24','2025-04-24',57234.03,NULL,NULL,1,'2025-06-16 11:12:30','2025-06-16 11:12:30',NULL),(3299,7705,40720,1556,3,3183,'App\\Models\\Receipt',3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-01','2025-05-01',166317.40,NULL,NULL,1,'2025-06-16 15:07:23','2025-06-16 15:07:23',NULL),(3300,7705,40720,1556,3,3184,'App\\Models\\Receipt',3184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-02','2025-05-02',10006.05,NULL,NULL,1,'2025-06-16 15:08:53','2025-06-16 15:08:53',NULL),(3301,7705,40720,1556,3,3185,'App\\Models\\Receipt',3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-03','2025-05-03',69998.43,NULL,NULL,1,'2025-06-16 15:09:53','2025-06-16 15:09:53',NULL),(3302,7705,40720,1556,3,3186,'App\\Models\\Receipt',3186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-03','2025-05-03',20001.46,NULL,NULL,1,'2025-06-16 15:10:43','2025-06-16 15:10:43',NULL),(3303,7705,40720,1556,3,3187,'App\\Models\\Receipt',3187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-03','2025-05-03',20001.46,NULL,NULL,1,'2025-06-16 15:11:24','2025-06-16 15:11:24',NULL),(3304,7705,40720,1556,3,3188,'App\\Models\\Receipt',3188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-03','2025-05-03',95006.59,NULL,NULL,1,'2025-06-16 15:12:24','2025-06-16 15:12:24',NULL),(3305,7705,40720,1556,3,3189,'App\\Models\\Receipt',3189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-04','2025-05-04',5024.94,NULL,NULL,1,'2025-06-16 15:13:09','2025-06-16 15:13:09',NULL),(3306,7705,40720,1556,3,3190,'App\\Models\\Receipt',3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-03','2025-05-03',49996.97,NULL,NULL,1,'2025-06-16 15:14:10','2025-06-16 15:14:10',NULL),(3307,7705,40720,1556,3,3191,'App\\Models\\Receipt',3191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-05','2025-05-05',98302.52,NULL,NULL,1,'2025-06-16 15:15:36','2025-06-16 15:15:36',NULL),(3308,7705,40720,1556,3,3192,'App\\Models\\Receipt',3192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-06','2025-05-06',6008.99,NULL,NULL,1,'2025-06-16 15:16:21','2025-06-16 15:16:21',NULL),(3309,7705,40720,1556,3,3193,'App\\Models\\Receipt',3193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-07','2025-05-07',156503.44,NULL,NULL,1,'2025-06-16 15:17:23','2025-06-16 15:17:23',NULL),(3310,7705,40720,1556,3,3194,'App\\Models\\Receipt',3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-07','2025-05-07',44998.22,NULL,NULL,1,'2025-06-16 15:18:04','2025-06-16 15:18:04',NULL),(3311,7705,40720,1556,3,3195,'App\\Models\\Receipt',3195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-07','2025-05-07',166622.88,NULL,NULL,1,'2025-06-16 15:19:04','2025-06-16 15:19:04',NULL),(3312,7705,40720,1556,3,3196,'App\\Models\\Receipt',3196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-09','2025-05-09',10002.94,NULL,NULL,1,'2025-06-16 15:20:11','2025-06-16 15:20:11',NULL),(3313,7705,40720,1556,3,3197,'App\\Models\\Receipt',3197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-11','2025-05-11',5996.96,NULL,NULL,1,'2025-06-16 15:21:04','2025-06-16 15:21:04',NULL),(3314,7705,40720,1556,3,3198,'App\\Models\\Receipt',3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-12','2025-05-12',100000.60,NULL,NULL,1,'2025-06-16 15:21:56','2025-06-16 15:21:56',NULL),(3315,7705,40720,1556,3,3199,'App\\Models\\Receipt',3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-13','2025-05-13',106008.42,NULL,NULL,1,'2025-06-16 15:22:41','2025-06-16 15:22:41',NULL),(3316,7705,40720,1556,3,3200,'App\\Models\\Receipt',3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-14','2025-05-14',10000.73,NULL,NULL,1,'2025-06-16 15:23:25','2025-06-16 15:23:25',NULL);
INSERT INTO `balance_libro` VALUES (3317,7705,40720,1556,3,3201,'App\\Models\\Receipt',3201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-14','2025-05-14',241498.16,NULL,NULL,1,'2025-06-16 15:24:04','2025-06-16 15:24:04',NULL),(3318,7705,40720,1556,3,3202,'App\\Models\\Receipt',3202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-16','2025-05-16',9996.00,NULL,NULL,1,'2025-06-16 17:39:44','2025-06-16 17:39:44',NULL),(3319,7705,40720,1556,3,3203,'App\\Models\\Receipt',3203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-18','2025-05-18',114928.30,NULL,NULL,1,'2025-06-16 17:40:44','2025-06-16 17:40:44',NULL),(3320,7705,40720,1556,3,3204,'App\\Models\\Receipt',3204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-19','2025-05-19',50000.05,NULL,NULL,1,'2025-06-16 17:41:28','2025-06-16 17:41:28',NULL),(3321,7705,40720,1556,3,3205,'App\\Models\\Receipt',3205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-19','2025-05-19',19999.89,NULL,NULL,1,'2025-06-16 17:42:06','2025-06-16 17:42:06',NULL),(3322,7705,40720,1556,3,3206,'App\\Models\\Receipt',3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-20','2025-05-20',10000.73,NULL,NULL,1,'2025-06-16 17:42:53','2025-06-16 17:42:53',NULL),(3323,7705,40720,1556,3,3207,'App\\Models\\Receipt',3207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-20','2025-05-20',200217.16,NULL,NULL,1,'2025-06-16 17:43:34','2025-06-16 17:43:34',NULL),(3324,7705,40720,1556,3,3208,'App\\Models\\Receipt',3208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',108406.58,NULL,NULL,1,'2025-06-16 17:44:16','2025-06-16 17:44:16',NULL),(3325,7705,40720,1556,3,3209,'App\\Models\\Receipt',3209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-22','2025-05-22',113040.80,NULL,NULL,1,'2025-06-16 17:45:00','2025-06-16 17:45:00',NULL),(3326,7705,40720,1556,3,3210,'App\\Models\\Receipt',3210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-22','2025-05-22',24998.35,NULL,NULL,1,'2025-06-16 17:45:40','2025-06-16 17:45:40',NULL),(3327,7705,40720,1556,3,3211,'App\\Models\\Receipt',3211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-22','2025-05-22',10000.73,NULL,NULL,1,'2025-06-16 17:46:14','2025-06-16 17:46:14',NULL),(3328,7705,40720,1556,3,3212,'App\\Models\\Receipt',3212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-23','2025-05-23',133022.32,NULL,NULL,1,'2025-06-16 17:46:59','2025-06-16 17:46:59',NULL),(3329,7705,40720,1556,3,3213,'App\\Models\\Receipt',3213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-23','2025-05-23',20001.46,NULL,NULL,1,'2025-06-16 17:47:39','2025-06-16 17:47:39',NULL),(3330,7705,40720,1556,3,3214,'App\\Models\\Receipt',3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-24','2025-05-24',9998.67,NULL,NULL,1,'2025-06-16 18:21:04','2025-06-16 18:21:04',NULL),(3331,7705,40720,1556,3,3215,'App\\Models\\Receipt',3215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-24','2025-05-24',40501.31,NULL,NULL,1,'2025-06-16 18:21:49','2025-06-16 18:21:49',NULL),(3332,7705,40720,1556,3,3216,'App\\Models\\Receipt',3216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-24','2025-05-24',93999.65,NULL,NULL,1,'2025-06-16 18:22:29','2025-06-16 18:22:29',NULL),(3333,7705,40720,1556,3,3217,'App\\Models\\Receipt',3217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-25','2025-05-25',19999.89,NULL,NULL,1,'2025-06-16 18:23:09','2025-06-16 18:23:09',NULL),(3334,7705,40720,1556,3,3218,'App\\Models\\Receipt',3218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-26','2025-05-26',20001.46,NULL,NULL,1,'2025-06-16 18:23:51','2025-06-16 18:23:51',NULL),(3335,7705,40720,1556,3,3219,'App\\Models\\Receipt',3219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-26','2025-05-26',34999.23,NULL,NULL,1,'2025-06-16 18:24:29','2025-06-16 18:24:29',NULL),(3336,7705,40720,1556,3,3220,'App\\Models\\Receipt',3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-27','2025-05-27',136371.80,NULL,NULL,1,'2025-06-16 18:25:11','2025-06-16 18:25:11',NULL),(3337,7705,40720,1556,3,3221,'App\\Models\\Receipt',3221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-28','2025-05-28',56997.69,NULL,NULL,1,'2025-06-16 18:26:33','2025-06-16 18:26:33',NULL);
INSERT INTO `balance_libro` VALUES (3338,7705,40720,1556,3,3222,'App\\Models\\Receipt',3222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',15001.42,NULL,NULL,1,'2025-06-16 18:27:12','2025-06-16 18:27:12',NULL),(3339,7705,40720,1556,3,3223,'App\\Models\\Receipt',3223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-29','2025-05-29',72005.22,NULL,NULL,1,'2025-06-16 18:27:57','2025-06-16 18:27:57',NULL),(3340,7705,40720,1556,3,3224,'App\\Models\\Receipt',3224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',12000.88,NULL,NULL,1,'2025-06-16 18:29:21','2025-06-16 18:29:21',NULL),(3341,7705,40720,1556,3,3225,'App\\Models\\Receipt',3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-30','2025-05-30',10014.98,NULL,NULL,1,'2025-06-16 18:29:58','2025-06-16 18:29:58',NULL),(3342,7705,40720,1556,3,3226,'App\\Models\\Receipt',3226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-31','2025-05-31',10002.94,NULL,NULL,1,'2025-06-16 18:30:47','2025-06-16 18:30:47',NULL),(3343,7705,40720,1556,3,3227,'App\\Models\\Receipt',3227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-08','2025-05-08',12960.02,NULL,NULL,1,'2025-06-16 18:32:16','2025-06-16 18:32:16',NULL),(3344,7705,40720,1556,3,3228,'App\\Models\\Receipt',3228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-10','2025-05-10',15000.01,NULL,NULL,1,'2025-06-16 18:33:22','2025-06-16 18:33:22',NULL),(3345,7705,40720,1556,3,3229,'App\\Models\\Receipt',3229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-12','2025-05-12',12900.02,NULL,NULL,1,'2025-06-16 18:34:11','2025-06-16 18:34:11',NULL),(3346,7705,40720,1556,3,3230,'App\\Models\\Receipt',3230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-15','2025-05-15',19500.02,NULL,NULL,1,'2025-06-16 18:34:45','2025-06-16 18:34:45',NULL),(3347,7705,40720,1556,3,3231,'App\\Models\\Receipt',3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-20','2025-05-20',12960.01,NULL,NULL,1,'2025-06-16 18:35:18','2025-06-16 18:35:18',NULL),(3348,7705,40720,1556,3,3232,'App\\Models\\Receipt',3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-27','2025-05-27',6760.00,NULL,NULL,1,'2025-06-16 18:35:57','2025-06-16 18:35:57',NULL),(3349,7705,40720,1556,3,3233,'App\\Models\\Receipt',3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-28','2025-05-28',6300.00,NULL,NULL,1,'2025-06-16 18:36:42','2025-06-16 18:36:42',NULL),(3350,7705,40720,1556,3,3234,'App\\Models\\Receipt',3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-04','2025-05-04',14500.00,NULL,NULL,1,'2025-06-16 18:51:42','2025-06-16 18:51:42',NULL),(3351,7705,40720,1556,3,3235,'App\\Models\\Receipt',3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-23','2025-05-23',14500.00,NULL,NULL,1,'2025-06-16 18:52:41','2025-06-16 18:52:41',NULL),(3352,7705,40720,1556,3,3236,'App\\Models\\Receipt',3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-26','2025-05-26',14500.00,NULL,NULL,1,'2025-06-16 18:53:30','2025-06-16 18:53:30',NULL),(3353,7705,40745,3069,3,3237,'App\\Models\\Receipt',3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-11','2025-06-11',501270.01,NULL,NULL,1,'2025-07-15 07:16:21','2025-07-15 07:16:21',NULL),(3354,7705,40745,3069,3,3238,'App\\Models\\Receipt',3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-01','2025-06-01',29994.68,NULL,NULL,1,'2025-07-15 07:23:21','2025-07-15 07:23:21',NULL),(3355,7705,40745,3069,3,3239,'App\\Models\\Receipt',3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-04','2025-06-04',15000.04,NULL,NULL,1,'2025-07-15 07:24:49','2025-07-15 07:24:49',NULL),(3356,7705,40745,3069,3,3240,'App\\Models\\Receipt',3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-12','2025-06-12',20001.07,NULL,NULL,1,'2025-07-15 07:25:51','2025-07-15 07:25:51',NULL),(3357,7705,40745,3069,3,3241,'App\\Models\\Receipt',3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-18','2025-06-18',15000.04,NULL,NULL,1,'2025-07-15 07:26:45','2025-07-15 07:26:45',NULL),(3358,7705,40745,3069,3,3242,'App\\Models\\Receipt',3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-22','2025-06-22',19999.97,NULL,NULL,1,'2025-07-15 07:27:52','2025-07-15 07:27:52',NULL);
INSERT INTO `balance_libro` VALUES (3359,7705,40745,3069,3,3243,'App\\Models\\Receipt',3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-23','2025-06-23',20000.03,NULL,NULL,1,'2025-07-15 07:28:48','2025-07-15 07:28:48',NULL),(3360,7705,40745,3069,3,3244,'App\\Models\\Receipt',3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-24','2025-06-24',10000.06,NULL,NULL,1,'2025-07-15 07:29:54','2025-07-15 07:29:54',NULL),(3361,7705,40745,3069,3,3245,'App\\Models\\Receipt',3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-25','2025-06-25',20000.03,NULL,NULL,1,'2025-07-15 07:31:27','2025-07-15 07:31:27',NULL),(3362,7705,40745,3069,3,3246,'App\\Models\\Receipt',3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-26','2025-06-26',19999.70,NULL,NULL,1,'2025-07-15 07:39:05','2025-07-15 07:39:05',NULL),(3363,7705,40745,3069,3,3247,'App\\Models\\Receipt',3247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',39999.38,NULL,NULL,1,'2025-07-15 07:40:01','2025-07-15 07:40:01',NULL),(3364,7705,40745,3069,3,3248,'App\\Models\\Receipt',3248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-29','2025-06-29',19999.97,NULL,NULL,1,'2025-07-15 07:41:07','2025-07-15 07:41:07',NULL),(3365,7705,40720,1557,3,3249,'App\\Models\\Receipt',3249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-01','2025-06-01',270000.96,NULL,NULL,1,'2025-07-16 19:14:53','2025-07-16 19:14:53',NULL),(3366,7705,40720,1557,3,3250,'App\\Models\\Receipt',3250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-02','2025-06-02',139501.05,NULL,NULL,1,'2025-07-16 19:32:16','2025-07-16 19:32:16',NULL),(3367,7705,40720,1557,3,3251,'App\\Models\\Receipt',3251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-03','2025-06-03',41995.74,NULL,NULL,1,'2025-07-16 19:33:28','2025-07-16 19:33:28',NULL),(3368,7705,40720,1557,3,3252,'App\\Models\\Receipt',3252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-04','2025-06-04',19996.97,NULL,NULL,1,'2025-07-16 19:34:23','2025-07-16 19:34:23',NULL),(3369,7705,40720,1557,3,3253,'App\\Models\\Receipt',3253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-04','2025-06-04',9996.66,NULL,NULL,1,'2025-07-16 19:46:41','2025-07-16 19:46:41',NULL),(3370,7705,40720,1557,3,3254,'App\\Models\\Receipt',3254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-04','2025-06-04',10000.01,NULL,NULL,1,'2025-07-16 19:50:06','2025-07-16 19:50:06',NULL),(3371,7705,40720,1557,3,3255,'App\\Models\\Receipt',3255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-05','2025-06-05',13001.46,NULL,NULL,1,'2025-07-17 07:13:14','2025-07-17 07:13:14',NULL),(3372,7705,40720,1557,3,3256,'App\\Models\\Receipt',3256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-05','2025-06-05',29999.74,NULL,NULL,1,'2025-07-17 07:14:34','2025-07-17 07:14:34',NULL),(3373,7705,40720,1557,3,3257,'App\\Models\\Receipt',3257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-06','2025-06-06',14997.49,NULL,NULL,1,'2025-07-17 07:16:11','2025-07-17 07:16:11',NULL),(3374,7705,40720,1557,3,3258,'App\\Models\\Receipt',3258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-06','2025-06-06',5997.52,NULL,NULL,1,'2025-07-17 07:17:37','2025-07-17 07:17:37',NULL),(3375,7705,40720,1557,3,3259,'App\\Models\\Receipt',3259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-06','2025-06-06',19997.59,NULL,NULL,1,'2025-07-17 07:18:48','2025-07-17 07:18:48',NULL),(3376,7705,40720,1557,3,3260,'App\\Models\\Receipt',3260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-07','2025-06-07',19998.95,NULL,NULL,1,'2025-07-17 07:20:32','2025-07-17 07:20:32',NULL),(3377,7705,40720,1557,3,3261,'App\\Models\\Receipt',3261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-08','2025-06-08',10001.41,NULL,NULL,1,'2025-07-17 07:39:26','2025-07-17 07:39:26',NULL),(3378,7705,40720,1557,3,3262,'App\\Models\\Receipt',3262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-08','2025-06-08',169998.38,NULL,NULL,1,'2025-07-17 07:41:33','2025-07-17 07:41:33',NULL),(3379,7705,40720,1557,3,3263,'App\\Models\\Receipt',3263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-08','2025-06-08',63027.68,NULL,NULL,1,'2025-07-17 07:42:46','2025-07-17 07:42:46',NULL);
INSERT INTO `balance_libro` VALUES (3380,7705,40720,1557,3,3264,'App\\Models\\Receipt',3264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-09','2025-06-09',5997.52,NULL,NULL,1,'2025-07-17 07:43:48','2025-07-17 07:43:48',NULL),(3381,7705,40720,1557,3,3265,'App\\Models\\Receipt',3265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-09','2025-06-09',29999.89,NULL,NULL,1,'2025-07-17 07:44:42','2025-07-17 07:44:42',NULL),(3382,7705,40720,1557,3,3266,'App\\Models\\Receipt',3266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-10','2025-06-10',120004.62,NULL,NULL,1,'2025-07-17 07:45:39','2025-07-17 07:45:39',NULL),(3383,7705,40720,1557,3,3267,'App\\Models\\Receipt',3267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-10','2025-06-10',99999.32,NULL,NULL,1,'2025-07-17 07:46:29','2025-07-17 07:46:29',NULL),(3384,7705,40720,1557,3,3268,'App\\Models\\Receipt',3268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-11','2025-06-11',139997.12,NULL,NULL,1,'2025-07-17 07:47:59','2025-07-17 07:47:59',NULL),(3385,7705,40720,1557,3,3269,'App\\Models\\Receipt',3269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-12','2025-06-12',64997.25,NULL,NULL,1,'2025-07-17 07:48:52','2025-07-17 07:48:52',NULL),(3386,7705,40720,1557,3,3270,'App\\Models\\Receipt',3270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-12','2025-06-12',8000.79,NULL,NULL,1,'2025-07-17 07:49:30','2025-07-17 07:49:30',NULL),(3387,7705,40720,1557,3,3271,'App\\Models\\Receipt',3271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-13','2025-06-13',179999.00,NULL,NULL,1,'2025-07-17 07:51:26','2025-07-17 07:51:26',NULL),(3388,7705,40720,1557,3,3272,'App\\Models\\Receipt',3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-14','2025-06-14',40001.90,NULL,NULL,1,'2025-07-17 07:52:36','2025-07-17 07:52:36',NULL),(3389,7705,40720,1557,3,3273,'App\\Models\\Receipt',3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-14','2025-06-14',107325.51,NULL,NULL,1,'2025-07-17 07:53:30','2025-07-17 07:53:30',NULL),(3390,7705,40720,1557,3,3274,'App\\Models\\Receipt',3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-14','2025-06-14',120000.00,NULL,NULL,1,'2025-07-17 07:55:15','2025-07-17 07:55:15',NULL),(3391,7705,40720,1557,3,3275,'App\\Models\\Receipt',3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-16','2025-06-16',230111.16,NULL,NULL,1,'2025-07-17 07:56:18','2025-07-17 07:56:18',NULL),(3392,7705,40720,1557,3,3276,'App\\Models\\Receipt',3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-17','2025-06-17',96503.34,NULL,NULL,1,'2025-07-17 07:57:12','2025-07-17 07:57:12',NULL),(3393,7705,40720,1557,3,3277,'App\\Models\\Receipt',3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-17','2025-06-17',8000.79,NULL,NULL,1,'2025-07-17 07:57:57','2025-07-17 07:57:57',NULL),(3394,7705,40720,1557,3,3278,'App\\Models\\Receipt',3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-17','2025-06-17',95003.28,NULL,NULL,1,'2025-07-17 07:58:50','2025-07-17 07:58:50',NULL),(3395,7705,40720,1557,3,3279,'App\\Models\\Receipt',3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-18','2025-06-18',227529.70,NULL,NULL,1,'2025-07-17 07:59:39','2025-07-17 07:59:39',NULL),(3396,7705,40720,1557,3,3280,'App\\Models\\Receipt',3280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-18','2025-06-18',14999.94,NULL,NULL,1,'2025-07-17 19:28:46','2025-07-17 19:28:46',NULL),(3397,7705,40720,1557,3,3281,'App\\Models\\Receipt',3281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-19','2025-06-19',116024.88,NULL,NULL,1,'2025-07-17 19:30:18','2025-07-17 19:30:18',NULL),(3398,7705,40720,1557,3,3282,'App\\Models\\Receipt',3282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-19','2025-06-19',8000.39,NULL,NULL,1,'2025-07-17 19:31:15','2025-07-17 19:31:15',NULL),(3399,7705,40720,1557,3,3283,'App\\Models\\Receipt',3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-20','2025-06-20',77799.37,NULL,NULL,1,'2025-07-17 19:33:48','2025-07-17 19:33:48',NULL),(3400,7705,40720,1557,3,3284,'App\\Models\\Receipt',3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-21','2025-06-21',156021.21,NULL,NULL,1,'2025-07-17 19:35:08','2025-07-17 19:35:08',NULL);
INSERT INTO `balance_libro` VALUES (3401,7705,40720,1557,3,3285,'App\\Models\\Receipt',3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-21','2025-06-21',20001.98,NULL,NULL,1,'2025-07-17 19:36:14','2025-07-17 19:36:14',NULL),(3402,7705,40720,1557,3,3286,'App\\Models\\Receipt',3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-21','2025-06-21',10002.16,NULL,NULL,1,'2025-07-17 19:37:04','2025-07-17 19:37:04',NULL),(3403,7705,40720,1557,3,3287,'App\\Models\\Receipt',3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-22','2025-06-22',9997.49,NULL,NULL,1,'2025-07-17 19:37:47','2025-07-17 19:37:47',NULL),(3404,7705,40720,1557,3,3288,'App\\Models\\Receipt',3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-22','2025-06-22',15002.69,NULL,NULL,1,'2025-07-17 19:38:25','2025-07-17 19:38:25',NULL),(3405,7705,40720,1557,3,3289,'App\\Models\\Receipt',3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-22','2025-06-22',79997.92,NULL,NULL,1,'2025-07-17 19:39:11','2025-07-17 19:39:11',NULL),(3406,7705,40720,1557,3,3290,'App\\Models\\Receipt',3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-23','2025-06-23',20000.95,NULL,NULL,1,'2025-07-17 19:39:58','2025-07-17 19:39:58',NULL),(3407,7705,40720,1557,3,3291,'App\\Models\\Receipt',3291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-23','2025-06-23',20000.95,NULL,NULL,1,'2025-07-17 19:40:39','2025-07-17 19:40:39',NULL),(3408,7705,40720,1557,3,3292,'App\\Models\\Receipt',3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-23','2025-06-23',20001.46,NULL,NULL,1,'2025-07-17 19:41:23','2025-07-17 19:41:23',NULL),(3409,7705,40720,1557,3,3293,'App\\Models\\Receipt',3293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-24','2025-06-24',34999.90,NULL,NULL,1,'2025-07-17 19:42:17','2025-07-17 19:42:17',NULL),(3410,7705,40720,1557,3,3294,'App\\Models\\Receipt',3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-24','2025-06-24',15001.24,NULL,NULL,1,'2025-07-17 19:43:24','2025-07-17 19:43:24',NULL),(3411,7705,40720,1557,3,3295,'App\\Models\\Receipt',3295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-25','2025-06-25',20000.95,NULL,NULL,1,'2025-07-17 19:44:18','2025-07-17 19:44:18',NULL),(3412,7705,40720,1557,3,3296,'App\\Models\\Receipt',3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-25','2025-06-25',40001.91,NULL,NULL,1,'2025-07-17 19:44:57','2025-07-17 19:44:57',NULL),(3413,7705,40720,1557,3,3297,'App\\Models\\Receipt',3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-26','2025-06-26',9993.60,NULL,NULL,1,'2025-07-17 19:46:01','2025-07-17 19:46:01',NULL),(3414,7705,40720,1557,3,3298,'App\\Models\\Receipt',3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-26','2025-06-26',64053.53,NULL,NULL,1,'2025-07-17 19:46:55','2025-07-17 19:46:55',NULL),(3415,7705,40720,1557,3,3299,'App\\Models\\Receipt',3299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-26','2025-06-26',20000.95,NULL,NULL,1,'2025-07-17 19:47:33','2025-07-17 19:47:33',NULL),(3416,7705,40720,1557,3,3300,'App\\Models\\Receipt',3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',129998.25,NULL,NULL,1,'2025-07-17 19:48:31','2025-07-17 19:48:31',NULL),(3417,7705,40720,1557,3,3301,'App\\Models\\Receipt',3301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',20001.46,NULL,NULL,1,'2025-07-17 19:49:09','2025-07-17 19:49:09',NULL),(3418,7705,40720,1557,3,3302,'App\\Models\\Receipt',3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',69136.25,NULL,NULL,1,'2025-07-17 19:50:14','2025-07-17 19:50:14',NULL),(3419,7705,40720,1557,3,3303,'App\\Models\\Receipt',3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-27','2025-06-27',4998.75,NULL,NULL,1,'2025-07-17 19:56:00','2025-07-17 19:56:00',NULL),(3420,7705,40720,1557,3,3304,'App\\Models\\Receipt',3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-28','2025-06-28',175014.09,NULL,NULL,1,'2025-07-17 19:56:59','2025-07-17 19:56:59',NULL),(3421,7705,40720,1557,3,3305,'App\\Models\\Receipt',3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',110002.26,NULL,NULL,1,'2025-07-17 19:57:46','2025-07-17 19:57:46',NULL);
INSERT INTO `balance_libro` VALUES (3422,7705,40720,1557,3,3306,'App\\Models\\Receipt',3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',46003.97,NULL,NULL,1,'2025-07-17 19:58:24','2025-07-17 19:58:24',NULL),(3423,7705,40720,1557,3,3307,'App\\Models\\Receipt',3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',20001.46,NULL,NULL,1,'2025-07-17 19:59:08','2025-07-17 19:59:08',NULL),(3424,7705,40720,1557,3,3308,'App\\Models\\Receipt',3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-04','2025-06-04',28500.01,NULL,NULL,1,'2025-07-17 20:01:05','2025-07-17 20:01:05',NULL),(3425,7705,40720,1557,3,3309,'App\\Models\\Receipt',3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-05','2025-06-05',21560.00,NULL,NULL,1,'2025-07-17 20:03:03','2025-07-17 20:03:03',NULL),(3426,7705,40720,1557,3,3310,'App\\Models\\Receipt',3310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-12','2025-06-12',138998.91,NULL,NULL,1,'2025-07-17 20:04:12','2025-07-17 20:04:12',NULL),(3427,7705,40720,1557,3,3311,'App\\Models\\Receipt',3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-13','2025-06-13',52583.13,NULL,NULL,1,'2025-07-17 20:05:26','2025-07-17 20:05:26',NULL),(3428,7705,40720,1557,3,3312,'App\\Models\\Receipt',3312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-17','2025-06-17',109800.12,NULL,NULL,1,'2025-07-17 20:06:50','2025-07-17 20:06:50',NULL),(3429,7705,40720,1557,3,3313,'App\\Models\\Receipt',3313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-17','2025-06-17',69700.04,NULL,NULL,1,'2025-07-17 20:07:43','2025-07-17 20:07:43',NULL),(3430,7705,40720,1557,3,3314,'App\\Models\\Receipt',3314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-18','2025-06-18',56400.04,NULL,NULL,1,'2025-07-17 20:08:34','2025-07-17 20:08:34',NULL),(3431,7705,40720,1557,3,3315,'App\\Models\\Receipt',3315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-19','2025-06-19',114962.14,NULL,NULL,1,'2025-07-17 20:09:35','2025-07-17 20:09:35',NULL),(3432,7705,40720,1557,3,3316,'App\\Models\\Receipt',3316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-21','2025-06-21',15000.01,NULL,NULL,1,'2025-07-17 20:10:37','2025-07-17 20:10:37',NULL),(3433,7705,40720,1557,3,3317,'App\\Models\\Receipt',3317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-24','2025-06-24',17800.01,NULL,NULL,1,'2025-07-17 20:11:39','2025-07-17 20:11:39',NULL),(3434,7705,40720,1557,3,3318,'App\\Models\\Receipt',3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-15','2025-06-15',51999.99,NULL,NULL,1,'2025-07-17 20:23:51','2025-07-17 20:23:51',NULL),(3435,7705,40720,1557,3,3319,'App\\Models\\Receipt',3319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-06-30','2025-06-30',372400.02,NULL,NULL,1,'2025-07-17 20:27:58','2025-07-17 20:27:58',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13328 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7705,1,40720,1515,3,217,1,1125.05,NULL,'2022-10-15 17:37:02','2022-10-17 21:27:12','2022-10-17 21:27:12'),(2,7705,1,40720,1515,3,68,1,236.26,NULL,'2022-10-15 17:37:02','2022-10-17 21:27:12','2022-10-17 21:27:12'),(3,7705,1,40720,1515,3,221,1,138.69,NULL,'2022-10-15 17:37:02','2022-10-17 21:27:12','2022-10-17 21:27:12'),(4,7705,1,40720,1515,3,57,2,1500.00,NULL,'2022-10-15 17:37:02','2022-10-17 21:27:12','2022-10-17 21:27:12'),(5,7705,2,40720,1515,3,217,1,3199.13,NULL,'2022-10-17 21:14:36','2022-10-17 21:14:36',NULL),(6,7705,2,40720,1515,3,68,1,671.82,NULL,'2022-10-17 21:14:36','2022-10-17 21:14:36',NULL),(7,7705,2,40720,1515,3,57,2,3870.95,NULL,'2022-10-17 21:14:36','2022-10-17 21:14:36',NULL),(8,7705,3,40720,1515,3,217,1,3901.12,NULL,'2022-10-17 21:22:03','2022-10-17 21:27:38','2022-10-17 21:27:38'),(9,7705,3,40720,1515,3,68,1,819.24,NULL,'2022-10-17 21:22:03','2022-10-17 21:27:38','2022-10-17 21:27:38'),(10,7705,3,40720,1515,3,221,1,378.86,NULL,'2022-10-17 21:22:03','2022-10-17 21:27:38','2022-10-17 21:27:38'),(11,7705,3,40720,1515,3,57,2,5099.22,NULL,'2022-10-17 21:22:03','2022-10-17 21:27:38','2022-10-17 21:27:38'),(12,7705,4,40720,1515,3,217,1,1154.25,NULL,'2022-10-17 21:23:06','2022-10-17 21:28:21','2022-10-17 21:28:21'),(13,7705,4,40720,1515,3,68,1,242.39,NULL,'2022-10-17 21:23:06','2022-10-17 21:28:21','2022-10-17 21:28:21'),(14,7705,4,40720,1515,3,221,1,103.83,NULL,'2022-10-17 21:23:06','2022-10-17 21:28:21','2022-10-17 21:28:21'),(15,7705,4,40720,1515,3,57,2,1500.47,NULL,'2022-10-17 21:23:06','2022-10-17 21:28:21','2022-10-17 21:28:21'),(16,7705,5,40720,1515,3,217,1,1206.80,NULL,'2022-10-17 21:24:22','2022-10-17 21:28:42','2022-10-17 21:28:42'),(17,7705,5,40720,1515,3,68,1,253.43,NULL,'2022-10-17 21:24:22','2022-10-17 21:28:42','2022-10-17 21:28:42'),(18,7705,5,40720,1515,3,221,1,140.14,NULL,'2022-10-17 21:24:22','2022-10-17 21:28:42','2022-10-17 21:28:42'),(19,7705,5,40720,1515,3,57,2,1600.37,NULL,'2022-10-17 21:24:22','2022-10-17 21:28:42','2022-10-17 21:28:42'),(20,7705,6,40720,1515,3,217,1,2262.36,NULL,'2022-10-17 21:26:09','2022-10-17 21:29:02','2022-10-17 21:29:02'),(21,7705,6,40720,1515,3,68,1,475.10,NULL,'2022-10-17 21:26:09','2022-10-17 21:29:02','2022-10-17 21:29:02'),(22,7705,6,40720,1515,3,224,1,262.72,NULL,'2022-10-17 21:26:09','2022-10-17 21:29:02','2022-10-17 21:29:02'),(23,7705,6,40720,1515,3,57,2,3000.18,NULL,'2022-10-17 21:26:09','2022-10-17 21:29:02','2022-10-17 21:29:02'),(24,7705,7,40720,1515,3,217,1,1125.05,NULL,'2022-10-17 21:27:12','2022-10-17 21:27:12',NULL),(25,7705,7,40720,1515,3,68,1,236.26,NULL,'2022-10-17 21:27:12','2022-10-17 21:27:12',NULL),(26,7705,7,40720,1515,3,224,1,138.69,NULL,'2022-10-17 21:27:12','2022-10-17 21:27:12',NULL),(27,7705,7,40720,1515,3,57,2,1500.00,NULL,'2022-10-17 21:27:12','2022-10-17 21:27:12',NULL),(28,7705,8,40720,1515,3,217,1,3901.12,NULL,'2022-10-17 21:27:38','2022-10-17 21:27:38',NULL),(29,7705,8,40720,1515,3,68,1,819.24,NULL,'2022-10-17 21:27:38','2022-10-17 21:27:38',NULL),(30,7705,8,40720,1515,3,224,1,378.86,NULL,'2022-10-17 21:27:38','2022-10-17 21:27:38',NULL),(31,7705,8,40720,1515,3,57,2,5099.22,NULL,'2022-10-17 21:27:38','2022-10-17 21:27:38',NULL),(32,7705,9,40720,1515,3,217,1,1154.25,NULL,'2022-10-17 21:28:21','2022-10-17 21:28:21',NULL),(33,7705,9,40720,1515,3,68,1,242.39,NULL,'2022-10-17 21:28:21','2022-10-17 21:28:21',NULL),(34,7705,9,40720,1515,3,224,1,103.83,NULL,'2022-10-17 21:28:21','2022-10-17 21:28:21',NULL),(35,7705,9,40720,1515,3,57,2,1500.47,NULL,'2022-10-17 21:28:21','2022-10-17 21:28:21',NULL),(36,7705,10,40720,1515,3,217,1,1206.80,NULL,'2022-10-17 21:28:42','2022-10-17 21:28:42',NULL),(37,7705,10,40720,1515,3,68,1,253.43,NULL,'2022-10-17 21:28:42','2022-10-17 21:28:42',NULL),(38,7705,10,40720,1515,3,224,1,140.14,NULL,'2022-10-17 21:28:42','2022-10-17 21:28:42',NULL),(39,7705,10,40720,1515,3,57,2,1600.37,NULL,'2022-10-17 21:28:42','2022-10-17 21:28:42',NULL);
INSERT INTO `balance_libro_details` VALUES (40,7705,11,40720,1515,3,217,1,2262.36,NULL,'2022-10-17 21:29:02','2022-10-17 21:29:02',NULL),(41,7705,11,40720,1515,3,68,1,475.10,NULL,'2022-10-17 21:29:02','2022-10-17 21:29:02',NULL),(42,7705,11,40720,1515,3,224,1,262.72,NULL,'2022-10-17 21:29:02','2022-10-17 21:29:02',NULL),(43,7705,11,40720,1515,3,57,2,3000.18,NULL,'2022-10-17 21:29:02','2022-10-17 21:29:02',NULL),(44,7705,12,40720,1515,3,217,1,6995.18,NULL,'2022-10-18 19:36:35','2022-10-18 19:36:35',NULL),(45,7705,12,40720,1515,3,68,1,1468.99,NULL,'2022-10-18 19:36:35','2022-10-18 19:36:35',NULL),(46,7705,12,40720,1515,3,224,1,707.34,NULL,'2022-10-18 19:36:35','2022-10-18 19:36:35',NULL),(47,7705,12,40720,1515,3,57,2,9171.51,NULL,'2022-10-18 19:36:35','2022-10-18 19:36:35',NULL),(48,7705,13,40720,1515,3,217,1,1095.73,NULL,'2022-10-18 19:44:33','2022-10-18 19:44:33',NULL),(49,7705,13,40720,1515,3,68,1,230.10,NULL,'2022-10-18 19:44:33','2022-10-18 19:44:33',NULL),(50,7705,13,40720,1515,3,224,1,174.15,NULL,'2022-10-18 19:44:33','2022-10-18 19:44:33',NULL),(51,7705,13,40720,1515,3,57,2,1499.98,NULL,'2022-10-18 19:44:33','2022-10-18 19:44:33',NULL),(52,7705,14,40720,1515,3,217,1,3876.48,NULL,'2022-10-18 19:46:20','2022-10-18 19:47:17','2022-10-18 19:47:17'),(53,7705,14,40720,1515,3,68,1,814.06,NULL,'2022-10-18 19:46:20','2022-10-18 19:47:17','2022-10-18 19:47:17'),(54,7705,14,40720,1515,3,57,2,4690.54,NULL,'2022-10-18 19:46:20','2022-10-18 19:47:17','2022-10-18 19:47:17'),(55,7705,15,40720,1515,3,217,1,6122.07,NULL,'2022-10-18 19:48:30','2022-10-18 19:48:30',NULL),(56,7705,15,40720,1515,3,68,1,1285.63,NULL,'2022-10-18 19:48:30','2022-10-18 19:48:30',NULL),(57,7705,15,40720,1515,3,224,1,594.55,NULL,'2022-10-18 19:48:30','2022-10-18 19:48:30',NULL),(58,7705,15,40720,1515,3,57,2,8002.25,NULL,'2022-10-18 19:48:30','2022-10-18 19:48:30',NULL),(59,7705,16,40720,1515,3,217,1,2262.36,NULL,'2022-10-18 19:49:31','2022-10-18 19:49:31',NULL),(60,7705,16,40720,1515,3,68,1,475.10,NULL,'2022-10-18 19:49:31','2022-10-18 19:49:31',NULL),(61,7705,16,40720,1515,3,224,1,262.72,NULL,'2022-10-18 19:49:31','2022-10-18 19:49:31',NULL),(62,7705,16,40720,1515,3,57,2,3000.18,NULL,'2022-10-18 19:49:31','2022-10-18 19:49:31',NULL),(63,7705,17,40720,1515,3,217,1,3825.93,NULL,'2022-10-18 19:50:41','2022-10-18 19:50:41',NULL),(64,7705,17,40720,1515,3,68,1,803.45,NULL,'2022-10-18 19:50:41','2022-10-18 19:50:41',NULL),(65,7705,17,40720,1515,3,224,1,371.56,NULL,'2022-10-18 19:50:41','2022-10-18 19:50:41',NULL),(66,7705,17,40720,1515,3,57,2,5000.94,NULL,'2022-10-18 19:50:41','2022-10-18 19:50:41',NULL),(67,7705,18,40720,1515,3,217,1,6538.69,NULL,'2022-10-18 19:51:50','2022-10-18 19:51:50',NULL),(68,7705,18,40720,1515,3,68,1,1373.12,NULL,'2022-10-18 19:51:50','2022-10-18 19:51:50',NULL),(69,7705,18,40720,1515,3,224,1,588.19,NULL,'2022-10-18 19:51:50','2022-10-18 19:51:50',NULL),(70,7705,18,40720,1515,3,57,2,8500.00,NULL,'2022-10-18 19:51:50','2022-10-18 19:51:50',NULL),(71,7705,19,40720,1515,3,217,1,1404.96,NULL,'2022-10-18 19:53:35','2022-10-18 19:53:35',NULL),(72,7705,19,40720,1515,3,68,1,295.04,NULL,'2022-10-18 19:53:35','2022-10-18 19:53:35',NULL),(73,7705,19,40720,1515,3,57,2,1700.00,NULL,'2022-10-18 19:53:35','2022-10-18 19:53:35',NULL),(74,7705,20,40720,1515,3,217,1,2231.41,NULL,'2022-10-18 19:55:05','2022-10-18 19:55:05',NULL),(75,7705,20,40720,1515,3,68,1,468.60,NULL,'2022-10-18 19:55:05','2022-10-18 19:55:05',NULL),(76,7705,20,40720,1515,3,57,2,2700.01,NULL,'2022-10-18 19:55:05','2022-10-18 19:55:05',NULL),(77,7705,21,40720,1515,3,217,1,3080.85,NULL,'2022-10-18 19:57:17','2022-10-18 19:57:17',NULL),(78,7705,21,40720,1515,3,68,1,646.98,NULL,'2022-10-18 19:57:17','2022-10-18 19:57:17',NULL),(79,7705,21,40720,1515,3,224,1,272.17,NULL,'2022-10-18 19:57:17','2022-10-18 19:57:17',NULL),(80,7705,21,40720,1515,3,57,2,4000.00,NULL,'2022-10-18 19:57:17','2022-10-18 19:57:17',NULL),(81,7705,22,40720,1515,3,217,1,3770.96,NULL,'2022-11-08 20:01:21','2022-11-08 20:01:21',NULL);
INSERT INTO `balance_libro_details` VALUES (82,7705,22,40720,1515,3,68,1,791.90,NULL,'2022-11-08 20:01:21','2022-11-08 20:01:21',NULL),(83,7705,22,40720,1515,3,224,1,437.91,NULL,'2022-11-08 20:01:21','2022-11-08 20:01:21',NULL),(84,7705,22,40720,1515,3,57,2,5000.77,NULL,'2022-11-08 20:01:21','2022-11-08 20:01:21',NULL),(85,7705,23,40720,1515,3,217,1,5292.94,NULL,'2022-11-08 20:05:02','2022-11-08 20:05:02',NULL),(86,7705,23,40720,1515,3,68,1,1111.52,NULL,'2022-11-08 20:05:02','2022-11-08 20:05:02',NULL),(87,7705,23,40720,1515,3,224,1,595.84,NULL,'2022-11-08 20:05:02','2022-11-08 20:05:02',NULL),(88,7705,23,40720,1515,3,57,2,7000.30,NULL,'2022-11-08 20:05:02','2022-11-08 20:05:02',NULL),(89,7705,24,40720,1515,3,217,1,6101.88,NULL,'2022-11-08 20:06:27','2022-11-08 20:06:27',NULL),(90,7705,24,40720,1515,3,68,1,1281.39,NULL,'2022-11-08 20:06:27','2022-11-08 20:06:27',NULL),(91,7705,24,40720,1515,3,224,1,617.31,NULL,'2022-11-08 20:06:28','2022-11-08 20:06:28',NULL),(92,7705,24,40720,1515,3,57,2,8000.58,NULL,'2022-11-08 20:06:28','2022-11-08 20:06:28',NULL),(93,7705,25,40720,1515,3,217,1,10074.12,NULL,'2022-11-08 20:07:35','2022-11-08 20:07:35',NULL),(94,7705,25,40720,1515,3,68,1,2115.57,NULL,'2022-11-08 20:07:35','2022-11-08 20:07:35',NULL),(95,7705,25,40720,1515,3,224,1,1010.32,NULL,'2022-11-08 20:07:35','2022-11-08 20:07:35',NULL),(96,7705,25,40720,1515,3,57,2,13200.01,NULL,'2022-11-08 20:07:35','2022-11-08 20:07:35',NULL),(97,7705,26,40720,1515,3,217,1,4454.39,NULL,'2022-11-08 20:08:20','2022-11-08 20:08:20',NULL),(98,7705,26,40720,1515,3,68,1,935.42,NULL,'2022-11-08 20:08:20','2022-11-08 20:08:20',NULL),(99,7705,26,40720,1515,3,224,1,712.32,NULL,'2022-11-08 20:08:20','2022-11-08 20:08:20',NULL),(100,7705,26,40720,1515,3,57,2,6102.13,NULL,'2022-11-08 20:08:20','2022-11-08 20:08:20',NULL),(101,7705,27,40720,1515,3,217,1,2307.78,NULL,'2022-11-08 20:20:12','2022-11-08 20:20:12',NULL),(102,7705,27,40720,1515,3,68,1,484.63,NULL,'2022-11-08 20:20:12','2022-11-08 20:20:12',NULL),(103,7705,27,40720,1515,3,224,1,207.60,NULL,'2022-11-08 20:20:12','2022-11-08 20:20:12',NULL),(104,7705,27,40720,1515,3,57,2,3000.01,NULL,'2022-11-08 20:20:12','2022-11-08 20:20:12',NULL),(105,7705,28,40720,1515,3,217,1,1275.06,NULL,'2022-11-08 20:22:14','2022-11-08 20:22:14',NULL),(106,7705,28,40720,1515,3,68,1,267.76,NULL,'2022-11-08 20:22:14','2022-11-08 20:22:14',NULL),(107,7705,28,40720,1515,3,224,1,157.18,NULL,'2022-11-08 20:22:14','2022-11-08 20:22:14',NULL),(108,7705,28,40720,1515,3,57,2,1700.00,NULL,'2022-11-08 20:22:14','2022-11-08 20:22:14',NULL),(109,7705,29,40720,1515,3,217,1,7650.42,NULL,'2022-11-08 20:22:56','2022-11-08 20:22:56',NULL),(110,7705,29,40720,1515,3,68,1,1606.59,NULL,'2022-11-08 20:22:56','2022-11-08 20:22:56',NULL),(111,7705,29,40720,1515,3,224,1,742.97,NULL,'2022-11-08 20:22:56','2022-11-08 20:22:56',NULL),(112,7705,29,40720,1515,3,57,2,9999.98,NULL,'2022-11-08 20:22:56','2022-11-08 20:22:56',NULL),(113,7705,30,40720,1515,3,217,1,5355.72,NULL,'2022-11-08 20:23:38','2022-11-08 20:23:38',NULL),(114,7705,30,40720,1515,3,68,1,1124.70,NULL,'2022-11-08 20:23:38','2022-11-08 20:23:38',NULL),(115,7705,30,40720,1515,3,224,1,520.12,NULL,'2022-11-08 20:23:38','2022-11-08 20:23:38',NULL),(116,7705,30,40720,1515,3,57,2,7000.54,NULL,'2022-11-08 20:23:38','2022-11-08 20:23:38',NULL),(117,7705,31,40720,1515,3,217,1,8033.59,NULL,'2022-11-08 20:24:15','2022-11-08 20:24:15',NULL),(118,7705,31,40720,1515,3,68,1,1687.05,NULL,'2022-11-08 20:24:15','2022-11-08 20:24:15',NULL),(119,7705,31,40720,1515,3,224,1,780.18,NULL,'2022-11-08 20:24:15','2022-11-08 20:24:15',NULL),(120,7705,31,40720,1515,3,57,2,10500.82,NULL,'2022-11-08 20:24:15','2022-11-08 20:24:15',NULL),(121,7705,32,40720,1515,3,217,1,1095.73,NULL,'2022-11-15 19:02:53','2022-11-15 19:02:53',NULL),(122,7705,32,40720,1515,3,68,1,230.10,NULL,'2022-11-15 19:02:53','2022-11-15 19:02:53',NULL),(123,7705,32,40720,1515,3,224,1,174.15,NULL,'2022-11-15 19:02:53','2022-11-15 19:02:53',NULL);
INSERT INTO `balance_libro_details` VALUES (124,7705,32,40720,1515,3,57,2,1499.98,NULL,'2022-11-15 19:02:53','2022-11-15 19:02:53',NULL),(125,7705,33,40720,1515,3,217,1,6611.57,NULL,'2022-11-15 19:05:00','2022-11-15 19:05:00',NULL),(126,7705,33,40720,1515,3,68,1,1388.43,NULL,'2022-11-15 19:05:00','2022-11-15 19:05:00',NULL),(127,7705,33,40720,1515,3,57,2,8000.00,NULL,'2022-11-15 19:05:00','2022-11-15 19:05:00',NULL),(128,7705,34,40720,1515,3,217,1,10176.46,NULL,'2022-11-15 19:05:58','2022-11-15 19:05:58',NULL),(129,7705,34,40720,1515,3,68,1,2137.06,NULL,'2022-11-15 19:05:58','2022-11-15 19:05:58',NULL),(130,7705,34,40720,1515,3,224,1,988.29,NULL,'2022-11-15 19:05:58','2022-11-15 19:05:58',NULL),(131,7705,34,40720,1515,3,57,2,13301.81,NULL,'2022-11-15 19:05:58','2022-11-15 19:05:58',NULL),(132,7705,35,40720,1515,3,217,1,2450.73,NULL,'2022-11-15 19:07:10','2022-11-15 19:07:10',NULL),(133,7705,35,40720,1515,3,68,1,514.65,NULL,'2022-11-15 19:07:10','2022-11-15 19:07:10',NULL),(134,7705,35,40720,1515,3,224,1,494.92,NULL,'2022-11-15 19:07:10','2022-11-15 19:07:10',NULL),(135,7705,35,40720,1515,3,57,2,3460.30,NULL,'2022-11-15 19:07:10','2022-11-15 19:07:10',NULL),(136,7705,36,40720,1515,3,217,1,3025.40,NULL,'2022-11-15 19:08:10','2022-11-15 19:08:10',NULL),(137,7705,36,40720,1515,3,68,1,635.33,NULL,'2022-11-15 19:08:10','2022-11-15 19:08:10',NULL),(138,7705,36,40720,1515,3,224,1,338.90,NULL,'2022-11-15 19:08:10','2022-11-15 19:08:10',NULL),(139,7705,36,40720,1515,3,57,2,3999.63,NULL,'2022-11-15 19:08:10','2022-11-15 19:08:10',NULL),(140,7705,37,40720,1515,3,217,1,7412.90,NULL,'2022-11-15 19:08:45','2022-11-15 19:08:45',NULL),(141,7705,37,40720,1515,3,68,1,1556.71,NULL,'2022-11-15 19:08:45','2022-11-15 19:08:45',NULL),(142,7705,37,40720,1515,3,224,1,830.39,NULL,'2022-11-15 19:08:45','2022-11-15 19:08:45',NULL),(143,7705,37,40720,1515,3,57,2,9800.00,NULL,'2022-11-15 19:08:45','2022-11-15 19:08:45',NULL),(144,7705,38,40720,1515,2,96,2,7412.90,NULL,'2022-11-16 18:48:10','2022-11-29 19:36:00','2022-11-29 19:36:00'),(145,7705,38,40720,1515,2,67,2,1556.71,NULL,'2022-11-16 18:48:10','2022-11-29 19:36:00','2022-11-29 19:36:00'),(146,7705,38,40720,1515,2,224,2,830.39,NULL,'2022-11-16 18:48:10','2022-11-29 19:36:00','2022-11-29 19:36:00'),(147,7705,38,40720,1515,2,13,1,9800.00,NULL,'2022-11-16 18:48:10','2022-11-29 19:36:00','2022-11-29 19:36:00'),(148,7705,39,40720,1515,2,96,2,5278.73,NULL,'2022-11-16 18:48:57','2022-11-29 19:35:54','2022-11-29 19:35:54'),(149,7705,39,40720,1515,2,67,2,1108.53,NULL,'2022-11-16 18:48:57','2022-11-29 19:35:54','2022-11-29 19:35:54'),(150,7705,39,40720,1515,2,224,2,613.00,NULL,'2022-11-16 18:48:57','2022-11-29 19:35:54','2022-11-29 19:35:54'),(151,7705,39,40720,1515,2,13,1,7000.26,NULL,'2022-11-16 18:48:57','2022-11-29 19:35:54','2022-11-29 19:35:54'),(152,7705,40,40720,1515,2,96,2,2924.95,NULL,'2022-11-16 18:49:37','2022-11-29 19:35:48','2022-11-29 19:35:48'),(153,7705,40,40720,1515,2,67,2,614.24,NULL,'2022-11-16 18:49:37','2022-11-29 19:35:48','2022-11-29 19:35:48'),(154,7705,40,40720,1515,2,224,2,461.03,NULL,'2022-11-16 18:49:37','2022-11-29 19:35:48','2022-11-29 19:35:48'),(155,7705,40,40720,1515,2,13,1,4000.22,NULL,'2022-11-16 18:49:37','2022-11-29 19:35:48','2022-11-29 19:35:48'),(156,7705,41,40720,1515,2,96,2,3801.66,NULL,'2022-11-16 18:50:27','2022-11-29 19:35:42','2022-11-29 19:35:42'),(157,7705,41,40720,1515,2,67,2,798.35,NULL,'2022-11-16 18:50:27','2022-11-29 19:35:42','2022-11-29 19:35:42'),(158,7705,41,40720,1515,2,13,1,4600.01,NULL,'2022-11-16 18:50:27','2022-11-29 19:35:42','2022-11-29 19:35:42'),(159,7705,42,40720,1515,2,96,2,1512.99,NULL,'2022-11-16 18:51:04','2022-11-29 19:35:36','2022-11-29 19:35:36'),(160,7705,42,40720,1515,2,67,2,317.73,NULL,'2022-11-16 18:51:04','2022-11-29 19:35:36','2022-11-29 19:35:36'),(161,7705,42,40720,1515,2,224,2,169.48,NULL,'2022-11-16 18:51:04','2022-11-29 19:35:36','2022-11-29 19:35:36'),(162,7705,42,40720,1515,2,13,1,2000.20,NULL,'2022-11-16 18:51:04','2022-11-29 19:35:36','2022-11-29 19:35:36');
INSERT INTO `balance_libro_details` VALUES (163,7705,43,40720,1515,2,96,2,10406.36,NULL,'2022-11-16 18:52:43','2022-11-29 19:35:31','2022-11-29 19:35:31'),(164,7705,43,40720,1515,2,67,2,2185.34,NULL,'2022-11-16 18:52:43','2022-11-29 19:35:31','2022-11-29 19:35:31'),(165,7705,43,40720,1515,2,224,2,1010.62,NULL,'2022-11-16 18:52:43','2022-11-29 19:35:31','2022-11-29 19:35:31'),(166,7705,43,40720,1515,2,13,1,13602.32,NULL,'2022-11-16 18:52:43','2022-11-29 19:35:31','2022-11-29 19:35:31'),(167,7705,44,40720,1515,2,96,2,756.50,NULL,'2022-11-16 18:53:37','2022-11-29 19:35:20','2022-11-29 19:35:20'),(168,7705,44,40720,1515,2,67,2,158.87,NULL,'2022-11-16 18:53:37','2022-11-29 19:35:20','2022-11-29 19:35:20'),(169,7705,44,40720,1515,2,224,2,84.74,NULL,'2022-11-16 18:53:37','2022-11-29 19:35:20','2022-11-29 19:35:20'),(170,7705,44,40720,1515,2,13,1,1000.11,NULL,'2022-11-16 18:53:37','2022-11-29 19:35:20','2022-11-29 19:35:20'),(171,7705,45,40720,1515,2,96,2,3825.93,NULL,'2022-11-16 18:54:11','2022-11-29 19:35:15','2022-11-29 19:35:15'),(172,7705,45,40720,1515,2,67,2,803.45,NULL,'2022-11-16 18:54:11','2022-11-29 19:35:15','2022-11-29 19:35:15'),(173,7705,45,40720,1515,2,224,2,371.56,NULL,'2022-11-16 18:54:11','2022-11-29 19:35:15','2022-11-29 19:35:15'),(174,7705,45,40720,1515,2,13,1,5000.94,NULL,'2022-11-16 18:54:11','2022-11-29 19:35:15','2022-11-29 19:35:15'),(175,7705,46,40720,1515,2,96,2,1512.99,NULL,'2022-11-16 18:54:55','2022-11-29 19:35:07','2022-11-29 19:35:07'),(176,7705,46,40720,1515,2,67,2,317.73,NULL,'2022-11-16 18:54:55','2022-11-29 19:35:07','2022-11-29 19:35:07'),(177,7705,46,40720,1515,2,224,2,169.48,NULL,'2022-11-16 18:54:55','2022-11-29 19:35:07','2022-11-29 19:35:07'),(178,7705,46,40720,1515,2,13,1,2000.20,NULL,'2022-11-16 18:54:55','2022-11-29 19:35:07','2022-11-29 19:35:07'),(179,7705,47,40720,1515,2,96,2,750.03,NULL,'2022-11-16 18:55:54','2022-11-29 19:34:58','2022-11-29 19:34:58'),(180,7705,47,40720,1515,2,67,2,157.51,NULL,'2022-11-16 18:55:54','2022-11-29 19:34:58','2022-11-29 19:34:58'),(181,7705,47,40720,1515,2,224,2,92.46,NULL,'2022-11-16 18:55:54','2022-11-29 19:34:58','2022-11-29 19:34:58'),(182,7705,47,40720,1515,2,13,1,1000.00,NULL,'2022-11-16 18:55:54','2022-11-29 19:34:58','2022-11-29 19:34:58'),(183,7705,48,40720,1515,2,96,2,7412.90,NULL,'2022-11-16 18:56:36','2022-11-29 19:34:50','2022-11-29 19:34:50'),(184,7705,48,40720,1515,2,67,2,1556.71,NULL,'2022-11-16 18:56:36','2022-11-29 19:34:50','2022-11-29 19:34:50'),(185,7705,48,40720,1515,2,224,2,830.39,NULL,'2022-11-16 18:56:36','2022-11-29 19:34:50','2022-11-29 19:34:50'),(186,7705,48,40720,1515,2,13,1,9800.00,NULL,'2022-11-16 18:56:36','2022-11-29 19:34:50','2022-11-29 19:34:50'),(187,7705,49,40720,1515,2,96,2,2980.76,NULL,'2022-11-16 18:57:13','2022-11-29 19:34:40','2022-11-29 19:34:40'),(188,7705,49,40720,1515,2,67,2,625.96,NULL,'2022-11-16 18:57:13','2022-11-29 19:34:40','2022-11-29 19:34:40'),(189,7705,49,40720,1515,2,224,2,393.76,NULL,'2022-11-16 18:57:13','2022-11-29 19:34:40','2022-11-29 19:34:40'),(190,7705,49,40720,1515,2,13,1,4000.48,NULL,'2022-11-16 18:57:13','2022-11-29 19:34:40','2022-11-29 19:34:40'),(191,7705,50,40720,1515,2,96,2,756.50,NULL,'2022-11-16 18:57:47','2022-11-29 19:34:34','2022-11-29 19:34:34'),(192,7705,50,40720,1515,2,67,2,158.87,NULL,'2022-11-16 18:57:47','2022-11-29 19:34:34','2022-11-29 19:34:34'),(193,7705,50,40720,1515,2,224,2,84.74,NULL,'2022-11-16 18:57:47','2022-11-29 19:34:34','2022-11-29 19:34:34'),(194,7705,50,40720,1515,2,13,1,1000.11,NULL,'2022-11-16 18:57:47','2022-11-29 19:34:34','2022-11-29 19:34:34'),(195,7705,51,40720,1515,2,96,2,4250.15,NULL,'2022-11-16 18:58:29','2022-11-29 19:34:28','2022-11-29 19:34:28'),(196,7705,51,40720,1515,2,67,2,892.53,NULL,'2022-11-16 18:58:29','2022-11-29 19:34:28','2022-11-29 19:34:28'),(197,7705,51,40720,1515,2,224,2,858.32,NULL,'2022-11-16 18:58:29','2022-11-29 19:34:28','2022-11-29 19:34:28'),(198,7705,51,40720,1515,2,13,1,6001.00,NULL,'2022-11-16 18:58:29','2022-11-29 19:34:28','2022-11-29 19:34:28');
INSERT INTO `balance_libro_details` VALUES (199,7705,52,40720,1515,2,96,2,4159.85,NULL,'2022-11-16 18:59:14','2022-11-29 19:34:23','2022-11-29 19:34:23'),(200,7705,52,40720,1515,2,67,2,873.57,NULL,'2022-11-16 18:59:14','2022-11-29 19:34:23','2022-11-29 19:34:23'),(201,7705,52,40720,1515,2,224,2,465.98,NULL,'2022-11-16 18:59:14','2022-11-29 19:34:23','2022-11-29 19:34:23'),(202,7705,52,40720,1515,2,13,1,5499.40,NULL,'2022-11-16 18:59:14','2022-11-29 19:34:23','2022-11-29 19:34:23'),(203,7705,53,40720,1515,2,96,2,3020.05,NULL,'2022-11-16 19:00:09','2022-11-29 19:34:17','2022-11-29 19:34:17'),(204,7705,53,40720,1515,2,67,2,634.21,NULL,'2022-11-16 19:00:09','2022-11-29 19:34:17','2022-11-29 19:34:17'),(205,7705,53,40720,1515,2,224,2,346.06,NULL,'2022-11-16 19:00:09','2022-11-29 19:34:17','2022-11-29 19:34:17'),(206,7705,53,40720,1515,2,13,1,4000.32,NULL,'2022-11-16 19:00:09','2022-11-29 19:34:17','2022-11-29 19:34:17'),(207,7705,54,40720,1515,2,96,2,1512.99,NULL,'2022-11-16 19:02:04','2022-11-29 19:34:11','2022-11-29 19:34:11'),(208,7705,54,40720,1515,2,67,2,317.73,NULL,'2022-11-16 19:02:04','2022-11-29 19:34:11','2022-11-29 19:34:11'),(209,7705,54,40720,1515,2,224,2,169.48,NULL,'2022-11-16 19:02:04','2022-11-29 19:34:11','2022-11-29 19:34:11'),(210,7705,54,40720,1515,2,13,1,2000.20,NULL,'2022-11-16 19:02:04','2022-11-29 19:34:11','2022-11-29 19:34:11'),(211,7705,55,40720,1515,2,96,2,5551.77,NULL,'2022-11-16 19:02:49','2022-11-29 19:34:05','2022-11-29 19:34:05'),(212,7705,55,40720,1515,2,67,2,1165.87,NULL,'2022-11-16 19:02:49','2022-11-29 19:34:05','2022-11-29 19:34:05'),(213,7705,55,40720,1515,2,224,2,770.84,NULL,'2022-11-16 19:02:49','2022-11-29 19:34:05','2022-11-29 19:34:05'),(214,7705,55,40720,1515,2,13,1,7488.48,NULL,'2022-11-16 19:02:49','2022-11-29 19:34:05','2022-11-29 19:34:05'),(215,7705,56,40720,1515,2,96,2,4590.83,NULL,'2022-11-16 19:03:45','2022-11-29 19:33:58','2022-11-29 19:33:58'),(216,7705,56,40720,1515,2,67,2,964.07,NULL,'2022-11-16 19:03:45','2022-11-29 19:33:58','2022-11-29 19:33:58'),(217,7705,56,40720,1515,2,224,2,445.84,NULL,'2022-11-16 19:03:45','2022-11-29 19:33:58','2022-11-29 19:33:58'),(218,7705,56,40720,1515,2,13,1,6000.74,NULL,'2022-11-16 19:03:45','2022-11-29 19:33:58','2022-11-29 19:33:58'),(219,7705,57,40720,1515,2,96,2,4538.51,NULL,'2022-11-16 19:06:12','2022-11-29 19:33:40','2022-11-29 19:33:40'),(220,7705,57,40720,1515,2,67,2,953.09,NULL,'2022-11-16 19:06:12','2022-11-29 19:33:40','2022-11-29 19:33:40'),(221,7705,57,40720,1515,2,224,2,508.40,NULL,'2022-11-16 19:06:12','2022-11-29 19:33:40','2022-11-29 19:33:40'),(222,7705,57,40720,1515,2,13,1,6000.00,NULL,'2022-11-16 19:06:12','2022-11-29 19:33:40','2022-11-29 19:33:40'),(223,7705,58,40720,1515,2,96,2,1134.45,NULL,'2022-11-16 19:06:50','2022-11-29 19:33:47','2022-11-29 19:33:47'),(224,7705,58,40720,1515,2,67,2,238.23,NULL,'2022-11-16 19:06:50','2022-11-29 19:33:47','2022-11-29 19:33:47'),(225,7705,58,40720,1515,2,224,2,127.08,NULL,'2022-11-16 19:06:50','2022-11-29 19:33:47','2022-11-29 19:33:47'),(226,7705,58,40720,1515,2,13,1,1499.76,NULL,'2022-11-16 19:06:50','2022-11-29 19:33:47','2022-11-29 19:33:47'),(227,7705,59,40720,1515,2,96,2,7831.63,NULL,'2022-11-16 19:07:57','2022-11-29 19:33:28','2022-11-29 19:33:28'),(228,7705,59,40720,1515,2,67,2,1644.64,NULL,'2022-11-16 19:07:57','2022-11-29 19:33:28','2022-11-29 19:33:28'),(229,7705,59,40720,1515,2,224,2,764.48,NULL,'2022-11-16 19:07:57','2022-11-29 19:33:28','2022-11-29 19:33:28'),(230,7705,59,40720,1515,2,13,1,10240.75,NULL,'2022-11-16 19:07:57','2022-11-29 19:33:28','2022-11-29 19:33:28'),(231,7705,60,40720,1515,2,96,2,10251.64,NULL,'2022-11-16 20:56:09','2022-11-29 19:33:21','2022-11-29 19:33:21'),(232,7705,60,40720,1515,2,67,2,2152.84,NULL,'2022-11-16 20:56:09','2022-11-29 19:33:21','2022-11-29 19:33:21'),(233,7705,60,40720,1515,2,224,2,995.59,NULL,'2022-11-16 20:56:09','2022-11-29 19:33:21','2022-11-29 19:33:21'),(234,7705,60,40720,1515,2,13,1,13400.07,NULL,'2022-11-16 20:56:09','2022-11-29 19:33:21','2022-11-29 19:33:21');
INSERT INTO `balance_libro_details` VALUES (235,7705,61,40720,1515,2,96,2,2269.49,NULL,'2022-11-16 20:56:51','2022-11-29 19:33:15','2022-11-29 19:33:15'),(236,7705,61,40720,1515,2,67,2,476.59,NULL,'2022-11-16 20:56:51','2022-11-29 19:33:15','2022-11-29 19:33:15'),(237,7705,61,40720,1515,2,224,2,254.22,NULL,'2022-11-16 20:56:51','2022-11-29 19:33:15','2022-11-29 19:33:15'),(238,7705,61,40720,1515,2,13,1,3000.30,NULL,'2022-11-16 20:56:51','2022-11-29 19:33:15','2022-11-29 19:33:15'),(239,7705,62,40720,1515,2,96,2,1192.44,NULL,'2022-11-16 20:57:33','2022-11-29 19:33:08','2022-11-29 19:33:08'),(240,7705,62,40720,1515,2,67,2,250.41,NULL,'2022-11-16 20:57:33','2022-11-29 19:33:08','2022-11-29 19:33:08'),(241,7705,62,40720,1515,2,224,2,157.01,NULL,'2022-11-16 20:57:33','2022-11-29 19:33:08','2022-11-29 19:33:08'),(242,7705,62,40720,1515,2,13,1,1599.86,NULL,'2022-11-16 20:57:33','2022-11-29 19:33:08','2022-11-29 19:33:08'),(243,7705,63,40720,1515,2,96,2,9946.55,NULL,'2022-11-16 20:58:13','2022-11-29 19:33:01','2022-11-29 19:33:01'),(244,7705,63,40720,1515,2,67,2,2088.78,NULL,'2022-11-16 20:58:13','2022-11-29 19:33:01','2022-11-29 19:33:01'),(245,7705,63,40720,1515,2,224,2,965.96,NULL,'2022-11-16 20:58:13','2022-11-29 19:33:01','2022-11-29 19:33:01'),(246,7705,63,40720,1515,2,13,1,13001.29,NULL,'2022-11-16 20:58:13','2022-11-29 19:33:01','2022-11-29 19:33:01'),(247,7705,64,40720,1515,2,96,2,2981.09,NULL,'2022-11-16 20:58:55','2022-11-29 19:32:55','2022-11-29 19:32:55'),(248,7705,64,40720,1515,2,67,2,626.03,NULL,'2022-11-16 20:58:55','2022-11-29 19:32:55','2022-11-29 19:32:55'),(249,7705,64,40720,1515,2,224,2,392.54,NULL,'2022-11-16 20:58:55','2022-11-29 19:32:55','2022-11-29 19:32:55'),(250,7705,64,40720,1515,2,13,1,3999.66,NULL,'2022-11-16 20:58:55','2022-11-29 19:32:55','2022-11-29 19:32:55'),(251,7705,65,40720,1515,2,96,2,2448.10,NULL,'2022-11-16 20:59:41','2022-11-29 19:32:48','2022-11-29 19:32:48'),(252,7705,65,40720,1515,2,67,2,514.10,NULL,'2022-11-16 20:59:41','2022-11-29 19:32:48','2022-11-29 19:32:48'),(253,7705,65,40720,1515,2,224,2,237.75,NULL,'2022-11-16 20:59:41','2022-11-29 19:32:48','2022-11-29 19:32:48'),(254,7705,65,40720,1515,2,13,1,3199.95,NULL,'2022-11-16 20:59:41','2022-11-29 19:32:48','2022-11-29 19:32:48'),(255,7705,66,40720,1515,2,96,2,1150.86,NULL,'2022-11-16 21:01:55','2022-11-29 19:32:42','2022-11-29 19:32:42'),(256,7705,66,40720,1515,2,67,2,241.68,NULL,'2022-11-16 21:01:55','2022-11-29 19:32:42','2022-11-29 19:32:42'),(257,7705,66,40720,1515,2,224,2,107.76,NULL,'2022-11-16 21:01:55','2022-11-29 19:32:42','2022-11-29 19:32:42'),(258,7705,66,40720,1515,2,13,1,1500.30,NULL,'2022-11-16 21:01:55','2022-11-29 19:32:42','2022-11-29 19:32:42'),(259,7705,67,40720,1515,2,96,2,1500.06,NULL,'2022-11-16 21:02:49','2022-11-29 19:32:36','2022-11-29 19:32:36'),(260,7705,67,40720,1515,2,67,2,315.01,NULL,'2022-11-16 21:02:49','2022-11-29 19:32:36','2022-11-29 19:32:36'),(261,7705,67,40720,1515,2,224,2,184.92,NULL,'2022-11-16 21:02:49','2022-11-29 19:32:36','2022-11-29 19:32:36'),(262,7705,67,40720,1515,2,13,1,1999.99,NULL,'2022-11-16 21:02:49','2022-11-29 19:32:36','2022-11-29 19:32:36'),(263,7705,68,40720,1515,2,96,2,6540.97,NULL,'2022-11-16 21:03:50','2022-11-29 19:32:30','2022-11-29 19:32:30'),(264,7705,68,40720,1515,2,67,2,1373.60,NULL,'2022-11-16 21:03:50','2022-11-29 19:32:30','2022-11-29 19:32:30'),(265,7705,68,40720,1515,2,224,2,585.43,NULL,'2022-11-16 21:03:50','2022-11-29 19:32:30','2022-11-29 19:32:30'),(266,7705,68,40720,1515,2,13,1,8500.00,NULL,'2022-11-16 21:03:50','2022-11-29 19:32:30','2022-11-29 19:32:30'),(267,7705,69,40720,1515,2,96,2,15227.08,NULL,'2022-11-16 21:04:49','2022-11-29 19:32:25','2022-11-29 19:32:25'),(268,7705,69,40720,1515,2,67,2,3197.69,NULL,'2022-11-16 21:04:49','2022-11-29 19:32:25','2022-11-29 19:32:25'),(269,7705,69,40720,1515,2,224,2,1478.79,NULL,'2022-11-16 21:04:49','2022-11-29 19:32:25','2022-11-29 19:32:25'),(270,7705,69,40720,1515,2,13,1,19903.56,NULL,'2022-11-16 21:04:49','2022-11-29 19:32:25','2022-11-29 19:32:25');
INSERT INTO `balance_libro_details` VALUES (271,7705,70,40720,1515,2,96,2,7602.18,NULL,'2022-11-16 21:05:46','2022-11-29 19:32:18','2022-11-29 19:32:18'),(272,7705,70,40720,1515,2,67,2,1596.46,NULL,'2022-11-16 21:05:46','2022-11-29 19:32:18','2022-11-29 19:32:18'),(273,7705,70,40720,1515,2,224,2,801.82,NULL,'2022-11-16 21:05:46','2022-11-29 19:32:18','2022-11-29 19:32:18'),(274,7705,70,40720,1515,2,13,1,10000.46,NULL,'2022-11-16 21:05:46','2022-11-29 19:32:18','2022-11-29 19:32:18'),(275,7705,71,40720,1515,2,96,2,3060.17,NULL,'2022-11-16 21:06:26','2022-11-29 19:32:07','2022-11-29 19:32:07'),(276,7705,71,40720,1515,2,67,2,642.64,NULL,'2022-11-16 21:06:26','2022-11-29 19:32:07','2022-11-29 19:32:07'),(277,7705,71,40720,1515,2,224,2,297.19,NULL,'2022-11-16 21:06:26','2022-11-29 19:32:07','2022-11-29 19:32:07'),(278,7705,71,40720,1515,2,13,1,4000.00,NULL,'2022-11-16 21:06:26','2022-11-29 19:32:07','2022-11-29 19:32:07'),(279,7705,72,40720,1515,2,96,2,6461.56,NULL,'2022-11-16 21:08:04','2022-11-29 19:32:02','2022-11-29 19:32:02'),(280,7705,72,40720,1515,2,67,2,1356.93,NULL,'2022-11-16 21:08:04','2022-11-29 19:32:02','2022-11-29 19:32:02'),(281,7705,72,40720,1515,2,224,2,681.52,NULL,'2022-11-16 21:08:04','2022-11-29 19:32:02','2022-11-29 19:32:02'),(282,7705,72,40720,1515,2,13,1,8500.01,NULL,'2022-11-16 21:08:04','2022-11-29 19:32:02','2022-11-29 19:32:02'),(283,7705,73,40720,1515,2,96,2,1826.24,NULL,'2022-11-16 21:08:53','2022-11-29 19:31:56','2022-11-29 19:31:56'),(284,7705,73,40720,1515,2,67,2,383.51,NULL,'2022-11-16 21:08:53','2022-11-29 19:31:56','2022-11-29 19:31:56'),(285,7705,73,40720,1515,2,224,2,290.24,NULL,'2022-11-16 21:08:53','2022-11-29 19:31:56','2022-11-29 19:31:56'),(286,7705,73,40720,1515,2,13,1,2499.99,NULL,'2022-11-16 21:08:53','2022-11-29 19:31:56','2022-11-29 19:31:56'),(287,7705,74,40720,1515,2,96,2,1192.47,NULL,'2022-11-16 21:09:52','2022-11-29 19:31:51','2022-11-29 19:31:51'),(288,7705,74,40720,1515,2,67,2,250.42,NULL,'2022-11-16 21:09:52','2022-11-29 19:31:51','2022-11-29 19:31:51'),(289,7705,74,40720,1515,2,224,2,157.14,NULL,'2022-11-16 21:09:52','2022-11-29 19:31:51','2022-11-29 19:31:51'),(290,7705,74,40720,1515,2,13,1,1600.03,NULL,'2022-11-16 21:09:52','2022-11-29 19:31:51','2022-11-29 19:31:51'),(291,7705,75,40720,1515,2,96,2,6081.63,NULL,'2022-11-16 21:10:41','2022-11-29 19:31:45','2022-11-29 19:31:45'),(292,7705,75,40720,1515,2,67,2,1277.14,NULL,'2022-11-16 21:10:41','2022-11-29 19:31:45','2022-11-29 19:31:45'),(293,7705,75,40720,1515,2,224,2,641.45,NULL,'2022-11-16 21:10:41','2022-11-29 19:31:45','2022-11-29 19:31:45'),(294,7705,75,40720,1515,2,13,1,8000.22,NULL,'2022-11-16 21:10:41','2022-11-29 19:31:45','2022-11-29 19:31:45'),(295,7705,76,40720,1515,2,96,2,6461.56,NULL,'2022-11-16 21:11:10','2022-11-29 19:31:38','2022-11-29 19:31:38'),(296,7705,76,40720,1515,2,67,2,1356.93,NULL,'2022-11-16 21:11:10','2022-11-29 19:31:38','2022-11-29 19:31:38'),(297,7705,76,40720,1515,2,224,2,681.52,NULL,'2022-11-16 21:11:10','2022-11-29 19:31:38','2022-11-29 19:31:38'),(298,7705,76,40720,1515,2,13,1,8500.01,NULL,'2022-11-16 21:11:10','2022-11-29 19:31:38','2022-11-29 19:31:38'),(299,7705,77,40720,1515,2,96,2,8035.03,NULL,'2022-11-16 21:11:54','2022-11-29 19:31:10','2022-11-29 19:31:10'),(300,7705,77,40720,1515,2,67,2,1687.36,NULL,'2022-11-16 21:11:54','2022-11-29 19:31:10','2022-11-29 19:31:10'),(301,7705,77,40720,1515,2,224,2,780.33,NULL,'2022-11-16 21:11:54','2022-11-29 19:31:10','2022-11-29 19:31:10'),(302,7705,77,40720,1515,2,13,1,10502.72,NULL,'2022-11-16 21:11:54','2022-11-29 19:31:10','2022-11-29 19:31:10'),(303,7705,78,40720,1515,2,96,2,6461.56,NULL,'2022-11-16 21:22:43','2022-11-29 19:31:04','2022-11-29 19:31:04'),(304,7705,78,40720,1515,2,67,2,1356.93,NULL,'2022-11-16 21:22:43','2022-11-29 19:31:04','2022-11-29 19:31:04'),(305,7705,78,40720,1515,2,224,2,681.52,NULL,'2022-11-16 21:22:43','2022-11-29 19:31:04','2022-11-29 19:31:04'),(306,7705,78,40720,1515,2,13,1,8500.01,NULL,'2022-11-16 21:22:43','2022-11-29 19:31:04','2022-11-29 19:31:04');
INSERT INTO `balance_libro_details` VALUES (307,7705,79,40720,1515,2,96,2,2271.38,NULL,'2022-11-16 21:26:38','2022-11-29 19:30:58','2022-11-29 19:30:58'),(308,7705,79,40720,1515,2,67,2,476.99,NULL,'2022-11-16 21:26:38','2022-11-29 19:30:58','2022-11-29 19:30:58'),(309,7705,79,40720,1515,2,224,2,301.97,NULL,'2022-11-16 21:26:38','2022-11-29 19:30:58','2022-11-29 19:30:58'),(310,7705,79,40720,1515,2,13,1,3050.34,NULL,'2022-11-16 21:26:38','2022-11-29 19:30:58','2022-11-29 19:30:58'),(311,7705,80,40720,1515,2,96,2,6120.62,NULL,'2022-11-16 21:27:29','2022-11-29 19:30:52','2022-11-29 19:30:52'),(312,7705,80,40720,1515,2,67,2,1285.33,NULL,'2022-11-16 21:27:29','2022-11-29 19:30:52','2022-11-29 19:30:52'),(313,7705,80,40720,1515,2,224,2,594.41,NULL,'2022-11-16 21:27:29','2022-11-29 19:30:52','2022-11-29 19:30:52'),(314,7705,80,40720,1515,2,13,1,8000.36,NULL,'2022-11-16 21:27:29','2022-11-29 19:30:52','2022-11-29 19:30:52'),(315,7705,81,40720,1515,2,96,2,7825.80,NULL,'2022-11-16 21:28:27','2022-11-29 19:30:41','2022-11-29 19:30:41'),(316,7705,81,40720,1515,2,67,2,1643.42,NULL,'2022-11-16 21:28:27','2022-11-29 19:30:41','2022-11-29 19:30:41'),(317,7705,81,40720,1515,2,224,2,1031.27,NULL,'2022-11-16 21:28:27','2022-11-29 19:30:41','2022-11-29 19:30:41'),(318,7705,81,40720,1515,2,13,1,10500.49,NULL,'2022-11-16 21:28:27','2022-11-29 19:30:41','2022-11-29 19:30:41'),(319,7705,82,40720,1515,2,96,2,5961.81,NULL,'2022-11-16 21:29:26','2022-11-29 19:30:34','2022-11-29 19:30:34'),(320,7705,82,40720,1515,2,67,2,1251.98,NULL,'2022-11-16 21:29:26','2022-11-29 19:30:34','2022-11-29 19:30:34'),(321,7705,82,40720,1515,2,224,2,785.63,NULL,'2022-11-16 21:29:26','2022-11-29 19:30:34','2022-11-29 19:30:34'),(322,7705,82,40720,1515,2,13,1,7999.42,NULL,'2022-11-16 21:29:26','2022-11-29 19:30:34','2022-11-29 19:30:34'),(323,7705,83,40720,1515,2,96,2,8568.58,NULL,'2022-11-16 21:30:12','2022-11-29 19:30:29','2022-11-29 19:30:29'),(324,7705,83,40720,1515,2,67,2,1799.40,NULL,'2022-11-16 21:30:12','2022-11-29 19:30:29','2022-11-29 19:30:29'),(325,7705,83,40720,1515,2,224,2,832.14,NULL,'2022-11-16 21:30:12','2022-11-29 19:30:29','2022-11-29 19:30:29'),(326,7705,83,40720,1515,2,13,1,11200.12,NULL,'2022-11-16 21:30:12','2022-11-29 19:30:29','2022-11-29 19:30:29'),(327,7705,84,40720,1515,2,96,2,2980.90,NULL,'2022-11-16 21:30:53','2022-11-29 19:30:23','2022-11-29 19:30:23'),(328,7705,84,40720,1515,2,67,2,625.99,NULL,'2022-11-16 21:30:53','2022-11-29 19:30:23','2022-11-29 19:30:23'),(329,7705,84,40720,1515,2,224,2,392.82,NULL,'2022-11-16 21:30:53','2022-11-29 19:30:23','2022-11-29 19:30:23'),(330,7705,84,40720,1515,2,13,1,3999.71,NULL,'2022-11-16 21:30:53','2022-11-29 19:30:23','2022-11-29 19:30:23'),(331,7705,85,40720,1515,2,96,2,11188.05,NULL,'2022-11-16 21:31:44','2022-11-29 19:30:18','2022-11-29 19:30:18'),(332,7705,85,40720,1515,2,67,2,2349.49,NULL,'2022-11-16 21:31:44','2022-11-29 19:30:18','2022-11-29 19:30:18'),(333,7705,85,40720,1515,2,224,2,943.78,NULL,'2022-11-16 21:31:44','2022-11-29 19:30:18','2022-11-29 19:30:18'),(334,7705,85,40720,1515,2,13,1,14481.32,NULL,'2022-11-16 21:31:44','2022-11-29 19:30:18','2022-11-29 19:30:18'),(335,7705,86,40720,1515,2,96,2,3040.51,NULL,'2022-11-16 21:32:20','2022-11-29 19:30:10','2022-11-29 19:30:10'),(336,7705,86,40720,1515,2,67,2,638.51,NULL,'2022-11-16 21:32:20','2022-11-29 19:30:10','2022-11-29 19:30:10'),(337,7705,86,40720,1515,2,224,2,320.69,NULL,'2022-11-16 21:32:20','2022-11-29 19:30:10','2022-11-29 19:30:10'),(338,7705,86,40720,1515,2,13,1,3999.71,NULL,'2022-11-16 21:32:20','2022-11-29 19:30:10','2022-11-29 19:30:10'),(339,7705,87,40720,1515,2,96,2,5432.36,NULL,'2022-11-16 21:33:10','2022-11-29 19:30:03','2022-11-29 19:30:03'),(340,7705,87,40720,1515,2,67,2,1140.80,NULL,'2022-11-16 21:33:10','2022-11-29 19:30:03','2022-11-29 19:30:03'),(341,7705,87,40720,1515,2,224,2,527.57,NULL,'2022-11-16 21:33:10','2022-11-29 19:30:03','2022-11-29 19:30:03'),(342,7705,87,40720,1515,2,13,1,7100.73,NULL,'2022-11-16 21:33:10','2022-11-29 19:30:03','2022-11-29 19:30:03');
INSERT INTO `balance_libro_details` VALUES (343,7705,88,40720,1515,2,96,2,3066.09,NULL,'2022-11-16 21:33:53','2022-11-29 19:29:57','2022-11-29 19:29:57'),(344,7705,88,40720,1515,2,67,2,643.88,NULL,'2022-11-16 21:33:53','2022-11-29 19:29:57','2022-11-29 19:29:57'),(345,7705,88,40720,1515,2,224,2,290.76,NULL,'2022-11-16 21:33:53','2022-11-29 19:29:57','2022-11-29 19:29:57'),(346,7705,88,40720,1515,2,13,1,4000.73,NULL,'2022-11-16 21:33:53','2022-11-29 19:29:57','2022-11-29 19:29:57'),(347,7705,89,40720,1515,2,96,2,12635.59,NULL,'2022-11-16 21:35:52','2022-11-29 19:29:43','2022-11-29 19:29:43'),(348,7705,89,40720,1515,2,67,2,2653.47,NULL,'2022-11-16 21:35:52','2022-11-29 19:29:43','2022-11-29 19:29:43'),(349,7705,89,40720,1515,2,13,1,15289.06,NULL,'2022-11-16 21:35:52','2022-11-29 19:29:43','2022-11-29 19:29:43'),(350,7705,90,40720,1515,2,96,2,1420.91,NULL,'2022-11-16 21:36:50','2022-11-29 19:29:36','2022-11-29 19:29:36'),(351,7705,90,40720,1515,2,67,2,298.39,NULL,'2022-11-16 21:36:50','2022-11-29 19:29:36','2022-11-29 19:29:36'),(352,7705,90,40720,1515,2,224,2,280.69,NULL,'2022-11-16 21:36:50','2022-11-29 19:29:36','2022-11-29 19:29:36'),(353,7705,90,40720,1515,2,13,1,1999.99,NULL,'2022-11-16 21:36:50','2022-11-29 19:29:36','2022-11-29 19:29:36'),(354,7705,91,40720,1515,2,96,2,7754.47,NULL,'2022-11-16 21:37:47','2022-11-29 19:29:30','2022-11-29 19:29:30'),(355,7705,91,40720,1515,2,67,2,1628.44,NULL,'2022-11-16 21:37:47','2022-11-29 19:29:30','2022-11-29 19:29:30'),(356,7705,91,40720,1515,2,224,2,817.89,NULL,'2022-11-16 21:37:47','2022-11-29 19:29:30','2022-11-29 19:29:30'),(357,7705,91,40720,1515,2,13,1,10200.80,NULL,'2022-11-16 21:37:47','2022-11-29 19:29:30','2022-11-29 19:29:30'),(358,7705,92,40720,1515,2,96,2,10383.54,NULL,'2022-11-16 21:38:49','2022-11-29 19:29:24','2022-11-29 19:29:24'),(359,7705,92,40720,1515,2,67,2,2180.54,NULL,'2022-11-16 21:38:49','2022-11-29 19:29:24','2022-11-29 19:29:24'),(360,7705,92,40720,1515,2,224,2,995.87,NULL,'2022-11-16 21:38:49','2022-11-29 19:29:24','2022-11-29 19:29:24'),(361,7705,92,40720,1515,2,13,1,13559.95,NULL,'2022-11-16 21:38:49','2022-11-29 19:29:24','2022-11-29 19:29:24'),(362,7705,93,40720,1515,2,96,2,2280.83,NULL,'2022-11-16 21:39:47','2022-11-29 19:29:18','2022-11-29 19:29:18'),(363,7705,93,40720,1515,2,67,2,478.97,NULL,'2022-11-16 21:39:47','2022-11-29 19:29:18','2022-11-29 19:29:18'),(364,7705,93,40720,1515,2,224,2,240.57,NULL,'2022-11-16 21:39:47','2022-11-29 19:29:18','2022-11-29 19:29:18'),(365,7705,93,40720,1515,2,13,1,3000.37,NULL,'2022-11-16 21:39:47','2022-11-29 19:29:18','2022-11-29 19:29:18'),(366,7705,94,40720,1515,2,96,2,8313.27,NULL,'2022-11-16 21:40:27','2022-11-29 19:29:10','2022-11-29 19:29:10'),(367,7705,94,40720,1515,2,67,2,1745.79,NULL,'2022-11-16 21:40:27','2022-11-29 19:29:10','2022-11-29 19:29:10'),(368,7705,94,40720,1515,2,224,2,797.32,NULL,'2022-11-16 21:40:27','2022-11-29 19:29:10','2022-11-29 19:29:10'),(369,7705,94,40720,1515,2,13,1,10856.38,NULL,'2022-11-16 21:40:27','2022-11-29 19:29:10','2022-11-29 19:29:10'),(370,7705,95,40720,1515,2,96,2,1008.26,NULL,'2022-11-16 23:06:40','2022-11-29 19:28:00','2022-11-29 19:28:00'),(371,7705,95,40720,1515,2,67,2,211.73,NULL,'2022-11-16 23:06:40','2022-11-29 19:28:00','2022-11-29 19:28:00'),(372,7705,95,40720,1515,2,13,1,1219.99,NULL,'2022-11-16 23:06:40','2022-11-29 19:28:00','2022-11-29 19:28:00'),(373,7705,96,40720,1515,2,96,2,1158.36,NULL,'2022-11-16 23:07:28','2022-11-29 19:27:51','2022-11-29 19:27:51'),(374,7705,96,40720,1515,2,67,2,243.26,NULL,'2022-11-16 23:07:28','2022-11-29 19:27:51','2022-11-29 19:27:51'),(375,7705,96,40720,1515,2,13,1,1401.62,NULL,'2022-11-16 23:07:28','2022-11-29 19:27:51','2022-11-29 19:27:51'),(376,7705,97,40720,1515,2,96,2,1074.39,NULL,'2022-11-16 23:08:19','2022-11-29 19:27:46','2022-11-29 19:27:46'),(377,7705,97,40720,1515,2,67,2,225.62,NULL,'2022-11-16 23:08:19','2022-11-29 19:27:46','2022-11-29 19:27:46'),(378,7705,97,40720,1515,2,13,1,1300.01,NULL,'2022-11-16 23:08:19','2022-11-29 19:27:46','2022-11-29 19:27:46');
INSERT INTO `balance_libro_details` VALUES (379,7705,98,40720,1515,2,96,2,12728.00,NULL,'2022-11-16 23:09:27','2022-11-29 19:27:40','2022-11-29 19:27:40'),(380,7705,98,40720,1515,2,67,2,2672.88,NULL,'2022-11-16 23:09:27','2022-11-29 19:27:40','2022-11-29 19:27:40'),(381,7705,98,40720,1515,2,13,1,15400.88,NULL,'2022-11-16 23:09:27','2022-11-29 19:27:40','2022-11-29 19:27:40'),(382,7705,99,40720,1515,2,96,2,9106.47,NULL,'2022-11-16 23:11:44','2022-11-29 19:27:32','2022-11-29 19:27:32'),(383,7705,99,40720,1515,2,67,2,1912.36,NULL,'2022-11-16 23:11:44','2022-11-29 19:27:32','2022-11-29 19:27:32'),(384,7705,99,40720,1515,2,224,2,884.38,NULL,'2022-11-16 23:11:44','2022-11-29 19:27:32','2022-11-29 19:27:32'),(385,7705,99,40720,1515,2,13,1,11903.21,NULL,'2022-11-16 23:11:44','2022-11-29 19:27:32','2022-11-29 19:27:32'),(386,7705,100,40720,1515,2,96,2,6081.46,NULL,'2022-11-16 23:12:34','2022-11-29 19:26:18','2022-11-29 19:26:18'),(387,7705,100,40720,1515,2,67,2,1277.11,NULL,'2022-11-16 23:12:34','2022-11-29 19:26:18','2022-11-29 19:26:18'),(388,7705,100,40720,1515,2,224,2,641.43,NULL,'2022-11-16 23:12:34','2022-11-29 19:26:18','2022-11-29 19:26:18'),(389,7705,100,40720,1515,2,13,1,8000.00,NULL,'2022-11-16 23:12:34','2022-11-29 19:26:18','2022-11-29 19:26:18'),(390,7705,101,40720,1515,2,96,2,9271.02,NULL,'2022-11-16 23:13:42','2022-11-29 19:27:26','2022-11-29 19:27:26'),(391,7705,101,40720,1515,2,67,2,1946.91,NULL,'2022-11-16 23:13:42','2022-11-29 19:27:26','2022-11-29 19:27:26'),(392,7705,101,40720,1515,2,224,2,782.06,NULL,'2022-11-16 23:13:42','2022-11-29 19:27:26','2022-11-29 19:27:26'),(393,7705,101,40720,1515,2,13,1,11999.99,NULL,'2022-11-16 23:13:42','2022-11-29 19:27:26','2022-11-29 19:27:26'),(394,7705,102,40720,1515,2,96,2,11665.95,NULL,'2022-11-16 23:14:18','2022-11-29 19:27:18','2022-11-29 19:27:18'),(395,7705,102,40720,1515,2,67,2,2449.85,NULL,'2022-11-16 23:14:18','2022-11-29 19:27:18','2022-11-29 19:27:18'),(396,7705,102,40720,1515,2,224,2,984.09,NULL,'2022-11-16 23:14:18','2022-11-29 19:27:18','2022-11-29 19:27:18'),(397,7705,102,40720,1515,2,13,1,15099.89,NULL,'2022-11-16 23:14:18','2022-11-29 19:27:18','2022-11-29 19:27:18'),(398,7705,103,40720,1515,2,96,2,5483.96,NULL,'2022-11-16 23:14:52','2022-11-29 19:26:49','2022-11-29 19:26:49'),(399,7705,103,40720,1515,2,67,2,1151.63,NULL,'2022-11-16 23:14:52','2022-11-29 19:26:49','2022-11-29 19:26:49'),(400,7705,103,40720,1515,2,224,2,864.39,NULL,'2022-11-16 23:14:52','2022-11-29 19:26:49','2022-11-29 19:26:49'),(401,7705,103,40720,1515,2,13,1,7499.98,NULL,'2022-11-16 23:14:52','2022-11-29 19:26:49','2022-11-29 19:26:49'),(402,7705,104,40720,1515,2,96,2,4635.87,NULL,'2022-11-16 23:15:20','2022-11-29 19:26:38','2022-11-29 19:26:38'),(403,7705,104,40720,1515,2,67,2,973.53,NULL,'2022-11-16 23:15:20','2022-11-29 19:26:38','2022-11-29 19:26:38'),(404,7705,104,40720,1515,2,224,2,391.06,NULL,'2022-11-16 23:15:20','2022-11-29 19:26:38','2022-11-29 19:26:38'),(405,7705,104,40720,1515,2,13,1,6000.46,NULL,'2022-11-16 23:15:20','2022-11-29 19:26:38','2022-11-29 19:26:38'),(406,7705,105,40720,1515,2,96,2,2235.94,NULL,'2022-11-16 23:15:58','2022-11-29 19:26:31','2022-11-29 19:26:31'),(407,7705,105,40720,1515,2,67,2,469.55,NULL,'2022-11-16 23:15:58','2022-11-29 19:26:31','2022-11-29 19:26:31'),(408,7705,105,40720,1515,2,224,2,294.65,NULL,'2022-11-16 23:15:58','2022-11-29 19:26:31','2022-11-29 19:26:31'),(409,7705,105,40720,1515,2,13,1,3000.14,NULL,'2022-11-16 23:15:58','2022-11-29 19:26:31','2022-11-29 19:26:31'),(410,7705,106,40720,1515,2,96,2,82917.36,NULL,'2022-11-16 23:19:17','2022-11-29 19:27:12','2022-11-29 19:27:12'),(411,7705,106,40720,1515,2,67,2,17412.65,NULL,'2022-11-16 23:19:17','2022-11-29 19:27:12','2022-11-29 19:27:12'),(412,7705,106,40720,1515,2,13,1,100330.01,NULL,'2022-11-16 23:19:17','2022-11-29 19:27:12','2022-11-29 19:27:12'),(413,7705,107,40720,1515,2,96,2,1292.61,NULL,'2022-11-16 23:24:01','2022-11-29 19:27:06','2022-11-29 19:27:06');
INSERT INTO `balance_libro_details` VALUES (414,7705,107,40720,1515,2,67,2,349.00,NULL,'2022-11-16 23:24:01','2022-11-29 19:27:06','2022-11-29 19:27:06'),(415,7705,107,40720,1515,2,96,2,2113.53,NULL,'2022-11-16 23:24:01','2022-11-29 19:27:06','2022-11-29 19:27:06'),(416,7705,107,40720,1515,2,67,2,443.84,NULL,'2022-11-16 23:24:01','2022-11-29 19:27:06','2022-11-29 19:27:06'),(417,7705,107,40720,1515,2,220,2,102.18,NULL,'2022-11-16 23:24:01','2022-11-29 19:27:06','2022-11-29 19:27:06'),(418,7705,107,40720,1515,2,221,2,60.82,NULL,'2022-11-16 23:24:01','2022-11-29 19:27:06','2022-11-29 19:27:06'),(419,7705,107,40720,1515,2,237,2,102.18,NULL,'2022-11-16 23:24:01','2022-11-29 19:27:06','2022-11-29 19:27:06'),(420,7705,107,40720,1515,2,13,1,4464.17,NULL,'2022-11-16 23:24:01','2022-11-29 19:27:06','2022-11-29 19:27:06'),(421,7705,107,40720,1515,2,136,2,0.01,NULL,'2022-11-16 23:24:01','2022-11-29 19:27:06','2022-11-29 19:27:06'),(422,7705,108,40720,1515,2,96,2,3199.13,NULL,'2022-11-16 23:32:51','2022-11-29 19:27:00','2022-11-29 19:27:00'),(423,7705,108,40720,1515,2,67,2,671.82,NULL,'2022-11-16 23:32:51','2022-11-29 19:27:00','2022-11-29 19:27:00'),(424,7705,108,40720,1515,2,13,1,3870.95,NULL,'2022-11-16 23:32:51','2022-11-29 19:27:00','2022-11-29 19:27:00'),(425,7705,109,40720,1515,2,96,2,3080.85,NULL,'2022-11-16 23:34:50','2022-11-29 19:26:54','2022-11-29 19:26:54'),(426,7705,109,40720,1515,2,67,2,646.98,NULL,'2022-11-16 23:34:50','2022-11-29 19:26:54','2022-11-29 19:26:54'),(427,7705,109,40720,1515,2,224,2,272.17,NULL,'2022-11-16 23:34:50','2022-11-29 19:26:54','2022-11-29 19:26:54'),(428,7705,109,40720,1515,2,13,1,4000.00,NULL,'2022-11-16 23:34:50','2022-11-29 19:26:54','2022-11-29 19:26:54'),(429,7705,110,40720,1515,2,96,2,2231.41,NULL,'2022-11-16 23:35:29','2022-11-29 19:26:01','2022-11-29 19:26:01'),(430,7705,110,40720,1515,2,67,2,468.60,NULL,'2022-11-16 23:35:29','2022-11-29 19:26:01','2022-11-29 19:26:01'),(431,7705,110,40720,1515,2,13,1,2700.01,NULL,'2022-11-16 23:35:29','2022-11-29 19:26:01','2022-11-29 19:26:01'),(432,7705,111,40720,1515,2,96,2,1404.96,NULL,'2022-11-16 23:36:06','2022-11-29 19:25:54','2022-11-29 19:25:54'),(433,7705,111,40720,1515,2,67,2,295.04,NULL,'2022-11-16 23:36:06','2022-11-29 19:25:54','2022-11-29 19:25:54'),(434,7705,111,40720,1515,2,13,1,1700.00,NULL,'2022-11-16 23:36:06','2022-11-29 19:25:54','2022-11-29 19:25:54'),(435,7705,112,40720,1515,2,96,2,2450.73,NULL,'2022-11-16 23:37:20','2022-11-29 19:25:46','2022-11-29 19:25:46'),(436,7705,112,40720,1515,2,67,2,514.65,NULL,'2022-11-16 23:37:20','2022-11-29 19:25:46','2022-11-29 19:25:46'),(437,7705,112,40720,1515,2,224,2,494.93,NULL,'2022-11-16 23:37:20','2022-11-29 19:25:46','2022-11-29 19:25:46'),(438,7705,112,40720,1515,2,13,1,3460.31,NULL,'2022-11-16 23:37:20','2022-11-29 19:25:46','2022-11-29 19:25:46'),(439,7705,113,40720,1515,3,217,1,7412.90,NULL,'2022-11-29 20:42:41','2022-11-29 20:42:41',NULL),(440,7705,113,40720,1515,3,68,1,1556.71,NULL,'2022-11-29 20:42:41','2022-11-29 20:42:41',NULL),(441,7705,113,40720,1515,3,224,1,830.39,NULL,'2022-11-29 20:42:41','2022-11-29 20:42:41',NULL),(442,7705,113,40720,1515,3,57,2,9800.00,NULL,'2022-11-29 20:42:41','2022-11-29 20:42:41',NULL),(443,7705,114,40720,1515,3,217,1,5278.73,NULL,'2022-11-29 20:44:06','2022-11-29 20:44:06',NULL),(444,7705,114,40720,1515,3,68,1,1108.53,NULL,'2022-11-29 20:44:06','2022-11-29 20:44:06',NULL),(445,7705,114,40720,1515,3,224,1,613.00,NULL,'2022-11-29 20:44:06','2022-11-29 20:44:06',NULL),(446,7705,114,40720,1515,3,57,2,7000.26,NULL,'2022-11-29 20:44:06','2022-11-29 20:44:06',NULL),(447,7705,115,40720,1515,3,217,1,2924.95,NULL,'2022-11-29 20:50:14','2022-11-29 20:50:14',NULL),(448,7705,115,40720,1515,3,68,1,614.24,NULL,'2022-11-29 20:50:14','2022-11-29 20:50:14',NULL),(449,7705,115,40720,1515,3,224,1,461.03,NULL,'2022-11-29 20:50:14','2022-11-29 20:50:14',NULL),(450,7705,115,40720,1515,3,57,2,4000.22,NULL,'2022-11-29 20:50:14','2022-11-29 20:50:14',NULL);
INSERT INTO `balance_libro_details` VALUES (451,7705,116,40720,1515,3,217,1,3801.66,NULL,'2022-11-29 21:07:54','2022-11-29 21:07:54',NULL),(452,7705,116,40720,1515,3,68,1,798.35,NULL,'2022-11-29 21:07:54','2022-11-29 21:07:54',NULL),(453,7705,116,40720,1515,3,57,2,4600.01,NULL,'2022-11-29 21:07:54','2022-11-29 21:07:54',NULL),(454,7705,117,40720,1515,3,217,1,1512.99,NULL,'2022-11-29 21:10:05','2022-11-29 21:10:05',NULL),(455,7705,117,40720,1515,3,68,1,317.73,NULL,'2022-11-29 21:10:05','2022-11-29 21:10:05',NULL),(456,7705,117,40720,1515,3,224,1,169.48,NULL,'2022-11-29 21:10:05','2022-11-29 21:10:05',NULL),(457,7705,117,40720,1515,3,57,2,2000.20,NULL,'2022-11-29 21:10:05','2022-11-29 21:10:05',NULL),(458,7705,118,40720,1515,3,217,1,1292.61,NULL,'2022-11-29 21:22:56','2022-11-29 21:22:56',NULL),(459,7705,118,40720,1515,3,68,1,349.00,NULL,'2022-11-29 21:22:56','2022-11-29 21:22:56',NULL),(460,7705,118,40720,1515,3,217,1,2113.53,NULL,'2022-11-29 21:22:56','2022-11-29 21:22:56',NULL),(461,7705,118,40720,1515,3,68,1,443.84,NULL,'2022-11-29 21:22:56','2022-11-29 21:22:56',NULL),(462,7705,118,40720,1515,3,217,1,60.82,NULL,'2022-11-29 21:22:56','2022-11-29 21:22:56',NULL),(463,7705,118,40720,1515,3,220,1,102.18,NULL,'2022-11-29 21:22:56','2022-11-29 21:22:56',NULL),(464,7705,118,40720,1515,3,237,1,102.18,NULL,'2022-11-29 21:22:56','2022-11-29 21:22:56',NULL),(465,7705,118,40720,1515,3,57,2,4464.17,NULL,'2022-11-29 21:22:56','2022-11-29 21:22:56',NULL),(466,7705,118,40720,1515,3,136,1,0.01,NULL,'2022-11-29 21:22:56','2022-11-29 21:22:56',NULL),(467,7705,119,40720,1515,3,217,1,10406.36,NULL,'2022-11-29 21:24:11','2022-11-29 21:24:11',NULL),(468,7705,119,40720,1515,3,68,1,2185.34,NULL,'2022-11-29 21:24:11','2022-11-29 21:24:11',NULL),(469,7705,119,40720,1515,3,224,1,1010.62,NULL,'2022-11-29 21:24:11','2022-11-29 21:24:11',NULL),(470,7705,119,40720,1515,3,57,2,13602.32,NULL,'2022-11-29 21:24:11','2022-11-29 21:24:11',NULL),(471,7705,120,40720,1515,3,217,1,756.50,NULL,'2022-11-29 22:03:34','2022-11-29 22:03:34',NULL),(472,7705,120,40720,1515,3,68,1,158.87,NULL,'2022-11-29 22:03:34','2022-11-29 22:03:34',NULL),(473,7705,120,40720,1515,3,224,1,84.74,NULL,'2022-11-29 22:03:34','2022-11-29 22:03:34',NULL),(474,7705,120,40720,1515,3,57,2,1000.11,NULL,'2022-11-29 22:03:34','2022-11-29 22:03:34',NULL),(475,7705,121,40720,1515,3,217,1,3825.93,NULL,'2022-11-29 22:04:28','2022-11-29 22:04:28',NULL),(476,7705,121,40720,1515,3,68,1,803.45,NULL,'2022-11-29 22:04:28','2022-11-29 22:04:28',NULL),(477,7705,121,40720,1515,3,224,1,371.56,NULL,'2022-11-29 22:04:28','2022-11-29 22:04:28',NULL),(478,7705,121,40720,1515,3,57,2,5000.94,NULL,'2022-11-29 22:04:28','2022-11-29 22:04:28',NULL),(479,7705,122,40720,1515,3,217,1,1512.99,NULL,'2022-11-29 22:05:09','2022-11-29 22:05:09',NULL),(480,7705,122,40720,1515,3,68,1,317.73,NULL,'2022-11-29 22:05:09','2022-11-29 22:05:09',NULL),(481,7705,122,40720,1515,3,224,1,169.48,NULL,'2022-11-29 22:05:09','2022-11-29 22:05:09',NULL),(482,7705,122,40720,1515,3,57,2,2000.20,NULL,'2022-11-29 22:05:09','2022-11-29 22:05:09',NULL),(483,7705,123,40720,1515,3,217,1,750.03,NULL,'2022-11-29 22:05:54','2022-11-29 22:05:54',NULL),(484,7705,123,40720,1515,3,68,1,157.51,NULL,'2022-11-29 22:05:54','2022-11-29 22:05:54',NULL),(485,7705,123,40720,1515,3,224,1,92.46,NULL,'2022-11-29 22:05:54','2022-11-29 22:05:54',NULL),(486,7705,123,40720,1515,3,57,2,1000.00,NULL,'2022-11-29 22:05:54','2022-11-29 22:05:54',NULL),(487,7705,124,40720,1515,3,217,1,7412.90,NULL,'2022-11-29 22:07:12','2022-11-29 22:07:12',NULL),(488,7705,124,40720,1515,3,68,1,1556.71,NULL,'2022-11-29 22:07:12','2022-11-29 22:07:12',NULL),(489,7705,124,40720,1515,3,224,1,830.39,NULL,'2022-11-29 22:07:12','2022-11-29 22:07:12',NULL),(490,7705,124,40720,1515,3,57,2,9800.00,NULL,'2022-11-29 22:07:12','2022-11-29 22:07:12',NULL),(491,7705,125,40720,1515,3,217,1,2980.76,NULL,'2022-11-29 22:07:46','2022-11-29 22:07:46',NULL),(492,7705,125,40720,1515,3,68,1,625.96,NULL,'2022-11-29 22:07:46','2022-11-29 22:07:46',NULL);
INSERT INTO `balance_libro_details` VALUES (493,7705,125,40720,1515,3,224,1,393.76,NULL,'2022-11-29 22:07:46','2022-11-29 22:07:46',NULL),(494,7705,125,40720,1515,3,57,2,4000.48,NULL,'2022-11-29 22:07:46','2022-11-29 22:07:46',NULL),(495,7705,126,40720,1515,3,217,1,756.50,NULL,'2022-11-29 22:08:18','2022-11-29 22:08:18',NULL),(496,7705,126,40720,1515,3,68,1,158.87,NULL,'2022-11-29 22:08:18','2022-11-29 22:08:18',NULL),(497,7705,126,40720,1515,3,224,1,84.74,NULL,'2022-11-29 22:08:18','2022-11-29 22:08:18',NULL),(498,7705,126,40720,1515,3,57,2,1000.11,NULL,'2022-11-29 22:08:18','2022-11-29 22:08:18',NULL),(499,7705,127,40720,1515,3,217,1,4250.15,NULL,'2022-11-29 22:09:09','2022-11-29 22:09:09',NULL),(500,7705,127,40720,1515,3,68,1,892.53,NULL,'2022-11-29 22:09:09','2022-11-29 22:09:09',NULL),(501,7705,127,40720,1515,3,224,1,858.32,NULL,'2022-11-29 22:09:09','2022-11-29 22:09:09',NULL),(502,7705,127,40720,1515,3,57,2,6001.00,NULL,'2022-11-29 22:09:09','2022-11-29 22:09:09',NULL),(503,7705,128,40720,1515,3,217,1,4159.85,NULL,'2022-11-29 22:09:59','2022-11-29 22:09:59',NULL),(504,7705,128,40720,1515,3,68,1,873.57,NULL,'2022-11-29 22:09:59','2022-11-29 22:09:59',NULL),(505,7705,128,40720,1515,3,224,1,465.98,NULL,'2022-11-29 22:09:59','2022-11-29 22:09:59',NULL),(506,7705,128,40720,1515,3,57,2,5499.40,NULL,'2022-11-29 22:09:59','2022-11-29 22:09:59',NULL),(507,7705,129,40720,1515,3,217,1,3020.05,NULL,'2022-11-29 22:10:54','2022-11-29 22:10:54',NULL),(508,7705,129,40720,1515,3,68,1,634.21,NULL,'2022-11-29 22:10:54','2022-11-29 22:10:54',NULL),(509,7705,129,40720,1515,3,224,1,346.06,NULL,'2022-11-29 22:10:54','2022-11-29 22:10:54',NULL),(510,7705,129,40720,1515,3,57,2,4000.32,NULL,'2022-11-29 22:10:54','2022-11-29 22:10:54',NULL),(511,7705,130,40720,1515,3,217,1,1512.99,NULL,'2022-11-29 22:11:36','2022-11-29 22:11:36',NULL),(512,7705,130,40720,1515,3,68,1,317.73,NULL,'2022-11-29 22:11:36','2022-11-29 22:11:36',NULL),(513,7705,130,40720,1515,3,224,1,169.48,NULL,'2022-11-29 22:11:36','2022-11-29 22:11:36',NULL),(514,7705,130,40720,1515,3,57,2,2000.20,NULL,'2022-11-29 22:11:36','2022-11-29 22:11:36',NULL),(515,7705,131,40720,1515,3,217,1,5551.77,NULL,'2022-11-29 22:12:12','2022-11-29 22:12:12',NULL),(516,7705,131,40720,1515,3,68,1,1165.87,NULL,'2022-11-29 22:12:12','2022-11-29 22:12:12',NULL),(517,7705,131,40720,1515,3,224,1,770.84,NULL,'2022-11-29 22:12:12','2022-11-29 22:12:12',NULL),(518,7705,131,40720,1515,3,57,2,7488.48,NULL,'2022-11-29 22:12:12','2022-11-29 22:12:12',NULL),(519,7705,132,40720,1515,3,217,1,4590.83,NULL,'2022-11-29 22:14:04','2022-11-29 22:14:04',NULL),(520,7705,132,40720,1515,3,68,1,964.07,NULL,'2022-11-29 22:14:04','2022-11-29 22:14:04',NULL),(521,7705,132,40720,1515,3,224,1,445.84,NULL,'2022-11-29 22:14:04','2022-11-29 22:14:04',NULL),(522,7705,132,40720,1515,3,57,2,6000.74,NULL,'2022-11-29 22:14:04','2022-11-29 22:14:04',NULL),(523,7705,133,40720,1515,3,217,1,4538.51,NULL,'2022-11-29 22:16:18','2022-11-29 22:16:18',NULL),(524,7705,133,40720,1515,3,68,1,953.09,NULL,'2022-11-29 22:16:18','2022-11-29 22:16:18',NULL),(525,7705,133,40720,1515,3,224,1,508.40,NULL,'2022-11-29 22:16:18','2022-11-29 22:16:18',NULL),(526,7705,133,40720,1515,3,57,2,6000.00,NULL,'2022-11-29 22:16:18','2022-11-29 22:16:18',NULL),(527,7705,134,40720,1515,3,217,1,1134.45,NULL,'2022-11-29 22:17:06','2022-11-29 22:17:06',NULL),(528,7705,134,40720,1515,3,68,1,238.23,NULL,'2022-11-29 22:17:06','2022-11-29 22:17:06',NULL),(529,7705,134,40720,1515,3,224,1,127.08,NULL,'2022-11-29 22:17:06','2022-11-29 22:17:06',NULL),(530,7705,134,40720,1515,3,57,2,1499.76,NULL,'2022-11-29 22:17:06','2022-11-29 22:17:06',NULL),(531,7705,135,40720,1515,3,217,1,7831.63,NULL,'2022-11-29 22:18:10','2022-11-29 22:18:10',NULL),(532,7705,135,40720,1515,3,68,1,1644.64,NULL,'2022-11-29 22:18:10','2022-11-29 22:18:10',NULL),(533,7705,135,40720,1515,3,224,1,764.48,NULL,'2022-11-29 22:18:10','2022-11-29 22:18:10',NULL),(534,7705,135,40720,1515,3,57,2,10240.75,NULL,'2022-11-29 22:18:10','2022-11-29 22:18:10',NULL);
INSERT INTO `balance_libro_details` VALUES (535,7705,136,40720,1515,3,217,1,10251.64,NULL,'2022-11-29 22:19:34','2022-11-29 22:19:34',NULL),(536,7705,136,40720,1515,3,68,1,2152.84,NULL,'2022-11-29 22:19:34','2022-11-29 22:19:34',NULL),(537,7705,136,40720,1515,3,224,1,995.59,NULL,'2022-11-29 22:19:34','2022-11-29 22:19:34',NULL),(538,7705,136,40720,1515,3,57,2,13400.07,NULL,'2022-11-29 22:19:34','2022-11-29 22:19:34',NULL),(539,7705,137,40720,1515,3,217,1,2269.49,NULL,'2022-11-29 22:20:22','2022-11-29 22:20:22',NULL),(540,7705,137,40720,1515,3,68,1,476.59,NULL,'2022-11-29 22:20:22','2022-11-29 22:20:22',NULL),(541,7705,137,40720,1515,3,224,1,254.22,NULL,'2022-11-29 22:20:22','2022-11-29 22:20:22',NULL),(542,7705,137,40720,1515,3,57,2,3000.30,NULL,'2022-11-29 22:20:22','2022-11-29 22:20:22',NULL),(543,7705,138,40720,1515,3,217,1,1192.44,NULL,'2022-11-29 22:21:11','2022-11-29 22:21:11',NULL),(544,7705,138,40720,1515,3,68,1,250.41,NULL,'2022-11-29 22:21:11','2022-11-29 22:21:11',NULL),(545,7705,138,40720,1515,3,224,1,157.01,NULL,'2022-11-29 22:21:11','2022-11-29 22:21:11',NULL),(546,7705,138,40720,1515,3,57,2,1599.86,NULL,'2022-11-29 22:21:11','2022-11-29 22:21:11',NULL),(547,7705,139,40720,1515,3,217,1,9946.55,NULL,'2022-11-29 22:22:08','2022-11-29 22:22:08',NULL),(548,7705,139,40720,1515,3,68,1,2088.78,NULL,'2022-11-29 22:22:08','2022-11-29 22:22:08',NULL),(549,7705,139,40720,1515,3,224,1,965.96,NULL,'2022-11-29 22:22:08','2022-11-29 22:22:08',NULL),(550,7705,139,40720,1515,3,57,2,13001.29,NULL,'2022-11-29 22:22:08','2022-11-29 22:22:08',NULL),(551,7705,140,40720,1515,3,217,1,2981.09,NULL,'2022-11-29 22:22:54','2022-11-29 22:22:54',NULL),(552,7705,140,40720,1515,3,68,1,626.03,NULL,'2022-11-29 22:22:54','2022-11-29 22:22:54',NULL),(553,7705,140,40720,1515,3,224,1,392.54,NULL,'2022-11-29 22:22:54','2022-11-29 22:22:54',NULL),(554,7705,140,40720,1515,3,57,2,3999.66,NULL,'2022-11-29 22:22:54','2022-11-29 22:22:54',NULL),(555,7705,141,40720,1515,3,217,1,2448.10,NULL,'2022-11-29 22:23:38','2022-11-29 22:23:38',NULL),(556,7705,141,40720,1515,3,68,1,514.10,NULL,'2022-11-29 22:23:38','2022-11-29 22:23:38',NULL),(557,7705,141,40720,1515,3,224,1,237.75,NULL,'2022-11-29 22:23:38','2022-11-29 22:23:38',NULL),(558,7705,141,40720,1515,3,57,2,3199.95,NULL,'2022-11-29 22:23:38','2022-11-29 22:23:38',NULL),(559,7705,142,40720,1515,3,217,1,826.45,NULL,'2022-11-29 22:25:31','2022-11-29 22:25:31',NULL),(560,7705,142,40720,1515,3,68,1,173.55,NULL,'2022-11-29 22:25:31','2022-11-29 22:25:31',NULL),(561,7705,142,40720,1515,3,57,2,1000.00,NULL,'2022-11-29 22:25:31','2022-11-29 22:25:31',NULL),(562,7705,143,40720,1515,3,217,1,1150.86,NULL,'2022-11-29 22:26:42','2022-11-29 22:26:42',NULL),(563,7705,143,40720,1515,3,68,1,241.68,NULL,'2022-11-29 22:26:42','2022-11-29 22:26:42',NULL),(564,7705,143,40720,1515,3,224,1,107.76,NULL,'2022-11-29 22:26:42','2022-11-29 22:26:42',NULL),(565,7705,143,40720,1515,3,57,2,1500.30,NULL,'2022-11-29 22:26:42','2022-11-29 22:26:42',NULL),(566,7705,144,40720,1515,3,217,1,82917.36,NULL,'2022-11-29 22:28:28','2022-11-29 22:28:28',NULL),(567,7705,144,40720,1515,3,68,1,17412.65,NULL,'2022-11-29 22:28:28','2022-11-29 22:28:28',NULL),(568,7705,144,40720,1515,3,57,2,100330.01,NULL,'2022-11-29 22:28:28','2022-11-29 22:28:28',NULL),(569,7705,145,40720,1515,3,217,1,1500.06,NULL,'2022-11-29 22:29:43','2022-11-29 22:29:43',NULL),(570,7705,145,40720,1515,3,68,1,315.01,NULL,'2022-11-29 22:29:43','2022-11-29 22:29:43',NULL),(571,7705,145,40720,1515,3,224,1,184.92,NULL,'2022-11-29 22:29:43','2022-11-29 22:29:43',NULL),(572,7705,145,40720,1515,3,57,2,1999.99,NULL,'2022-11-29 22:29:43','2022-11-29 22:29:43',NULL),(573,7705,146,40720,1515,3,217,1,6540.97,NULL,'2022-11-29 22:30:25','2022-11-29 22:30:25',NULL),(574,7705,146,40720,1515,3,68,1,1373.60,NULL,'2022-11-29 22:30:25','2022-11-29 22:30:25',NULL),(575,7705,146,40720,1515,3,224,1,585.43,NULL,'2022-11-29 22:30:25','2022-11-29 22:30:25',NULL),(576,7705,146,40720,1515,3,57,2,8500.00,NULL,'2022-11-29 22:30:25','2022-11-29 22:30:25',NULL);
INSERT INTO `balance_libro_details` VALUES (577,7705,147,40720,1515,3,217,1,15227.08,NULL,'2022-11-29 22:31:15','2022-11-29 22:31:15',NULL),(578,7705,147,40720,1515,3,68,1,3197.69,NULL,'2022-11-29 22:31:15','2022-11-29 22:31:15',NULL),(579,7705,147,40720,1515,3,224,1,1478.79,NULL,'2022-11-29 22:31:15','2022-11-29 22:31:15',NULL),(580,7705,147,40720,1515,3,57,2,19903.56,NULL,'2022-11-29 22:31:15','2022-11-29 22:31:15',NULL),(581,7705,148,40720,1515,3,217,1,7602.18,NULL,'2022-11-29 22:32:08','2022-11-29 22:32:08',NULL),(582,7705,148,40720,1515,3,68,1,1596.46,NULL,'2022-11-29 22:32:08','2022-11-29 22:32:08',NULL),(583,7705,148,40720,1515,3,224,1,801.82,NULL,'2022-11-29 22:32:08','2022-11-29 22:32:08',NULL),(584,7705,148,40720,1515,3,57,2,10000.46,NULL,'2022-11-29 22:32:08','2022-11-29 22:32:08',NULL),(585,7705,149,40720,1515,3,217,1,3060.17,NULL,'2022-11-29 22:32:47','2022-11-29 22:32:47',NULL),(586,7705,149,40720,1515,3,68,1,642.64,NULL,'2022-11-29 22:32:47','2022-11-29 22:32:47',NULL),(587,7705,149,40720,1515,3,224,1,297.19,NULL,'2022-11-29 22:32:47','2022-11-29 22:32:47',NULL),(588,7705,149,40720,1515,3,57,2,4000.00,NULL,'2022-11-29 22:32:47','2022-11-29 22:32:47',NULL),(589,7705,150,40720,1515,3,217,1,6461.56,NULL,'2022-11-29 22:33:26','2022-11-29 22:33:26',NULL),(590,7705,150,40720,1515,3,68,1,1356.93,NULL,'2022-11-29 22:33:26','2022-11-29 22:33:26',NULL),(591,7705,150,40720,1515,3,224,1,681.52,NULL,'2022-11-29 22:33:26','2022-11-29 22:33:26',NULL),(592,7705,150,40720,1515,3,57,2,8500.01,NULL,'2022-11-29 22:33:26','2022-11-29 22:33:26',NULL),(593,7705,151,40720,1515,3,217,1,1826.24,NULL,'2022-11-29 22:34:16','2022-11-29 22:34:16',NULL),(594,7705,151,40720,1515,3,68,1,383.51,NULL,'2022-11-29 22:34:16','2022-11-29 22:34:16',NULL),(595,7705,151,40720,1515,3,224,1,290.24,NULL,'2022-11-29 22:34:16','2022-11-29 22:34:16',NULL),(596,7705,151,40720,1515,3,57,2,2499.99,NULL,'2022-11-29 22:34:16','2022-11-29 22:34:16',NULL),(597,7705,152,40720,1515,3,217,1,1192.47,NULL,'2022-11-29 22:35:18','2022-11-29 22:35:18',NULL),(598,7705,152,40720,1515,3,68,1,250.42,NULL,'2022-11-29 22:35:18','2022-11-29 22:35:18',NULL),(599,7705,152,40720,1515,3,224,1,157.14,NULL,'2022-11-29 22:35:18','2022-11-29 22:35:18',NULL),(600,7705,152,40720,1515,3,57,2,1600.03,NULL,'2022-11-29 22:35:18','2022-11-29 22:35:18',NULL),(601,7705,153,40720,1515,3,217,1,6081.63,NULL,'2022-11-29 22:35:58','2022-11-29 22:35:58',NULL),(602,7705,153,40720,1515,3,68,1,1277.14,NULL,'2022-11-29 22:35:58','2022-11-29 22:35:58',NULL),(603,7705,153,40720,1515,3,224,1,641.45,NULL,'2022-11-29 22:35:58','2022-11-29 22:35:58',NULL),(604,7705,153,40720,1515,3,57,2,8000.22,NULL,'2022-11-29 22:35:58','2022-11-29 22:35:58',NULL),(605,7705,154,40720,1515,3,217,1,6461.56,NULL,'2022-11-29 22:36:26','2022-11-29 22:36:26',NULL),(606,7705,154,40720,1515,3,68,1,1356.93,NULL,'2022-11-29 22:36:26','2022-11-29 22:36:26',NULL),(607,7705,154,40720,1515,3,224,1,681.52,NULL,'2022-11-29 22:36:26','2022-11-29 22:36:26',NULL),(608,7705,154,40720,1515,3,57,2,8500.01,NULL,'2022-11-29 22:36:26','2022-11-29 22:36:26',NULL),(609,7705,155,40720,1515,3,217,1,8035.03,NULL,'2022-11-30 19:10:39','2022-11-30 19:10:39',NULL),(610,7705,155,40720,1515,3,68,1,1687.36,NULL,'2022-11-30 19:10:39','2022-11-30 19:10:39',NULL),(611,7705,155,40720,1515,3,224,1,780.33,NULL,'2022-11-30 19:10:39','2022-11-30 19:10:39',NULL),(612,7705,155,40720,1515,3,57,2,10502.72,NULL,'2022-11-30 19:10:39','2022-11-30 19:10:39',NULL),(613,7705,156,40720,1515,3,217,1,6461.56,NULL,'2022-11-30 19:16:27','2022-11-30 19:16:27',NULL),(614,7705,156,40720,1515,3,68,1,1356.93,NULL,'2022-11-30 19:16:27','2022-11-30 19:16:27',NULL),(615,7705,156,40720,1515,3,224,1,681.52,NULL,'2022-11-30 19:16:27','2022-11-30 19:16:27',NULL),(616,7705,156,40720,1515,3,57,2,8500.01,NULL,'2022-11-30 19:16:27','2022-11-30 19:16:27',NULL),(617,7705,157,40720,1515,3,217,1,2271.38,NULL,'2022-11-30 19:17:37','2022-11-30 19:17:37',NULL),(618,7705,157,40720,1515,3,68,1,476.99,NULL,'2022-11-30 19:17:37','2022-11-30 19:17:37',NULL);
INSERT INTO `balance_libro_details` VALUES (619,7705,157,40720,1515,3,224,1,301.97,NULL,'2022-11-30 19:17:37','2022-11-30 19:17:37',NULL),(620,7705,157,40720,1515,3,57,2,3050.34,NULL,'2022-11-30 19:17:37','2022-11-30 19:17:37',NULL),(621,7705,158,40720,1515,3,217,1,6120.62,NULL,'2022-11-30 19:18:22','2022-11-30 19:18:22',NULL),(622,7705,158,40720,1515,3,68,1,1285.33,NULL,'2022-11-30 19:18:23','2022-11-30 19:18:23',NULL),(623,7705,158,40720,1515,3,224,1,594.41,NULL,'2022-11-30 19:18:23','2022-11-30 19:18:23',NULL),(624,7705,158,40720,1515,3,57,2,8000.36,NULL,'2022-11-30 19:18:23','2022-11-30 19:18:23',NULL),(625,7705,159,40720,1515,3,217,1,7825.80,NULL,'2022-11-30 19:19:54','2022-11-30 19:19:54',NULL),(626,7705,159,40720,1515,3,68,1,1643.42,NULL,'2022-11-30 19:19:54','2022-11-30 19:19:54',NULL),(627,7705,159,40720,1515,3,224,1,1031.27,NULL,'2022-11-30 19:19:54','2022-11-30 19:19:54',NULL),(628,7705,159,40720,1515,3,57,2,10500.49,NULL,'2022-11-30 19:19:54','2022-11-30 19:19:54',NULL),(629,7705,160,40720,1515,3,217,1,5961.81,NULL,'2022-11-30 19:20:31','2022-11-30 19:20:31',NULL),(630,7705,160,40720,1515,3,68,1,1251.98,NULL,'2022-11-30 19:20:31','2022-11-30 19:20:31',NULL),(631,7705,160,40720,1515,3,224,1,785.63,NULL,'2022-11-30 19:20:31','2022-11-30 19:20:31',NULL),(632,7705,160,40720,1515,3,57,2,7999.42,NULL,'2022-11-30 19:20:31','2022-11-30 19:20:31',NULL),(633,7705,161,40720,1515,3,217,1,8568.58,NULL,'2022-11-30 19:21:23','2022-11-30 19:21:23',NULL),(634,7705,161,40720,1515,3,68,1,1799.40,NULL,'2022-11-30 19:21:23','2022-11-30 19:21:23',NULL),(635,7705,161,40720,1515,3,224,1,832.14,NULL,'2022-11-30 19:21:23','2022-11-30 19:21:23',NULL),(636,7705,161,40720,1515,3,57,2,11200.12,NULL,'2022-11-30 19:21:23','2022-11-30 19:21:23',NULL),(637,7705,162,40720,1515,3,217,1,2980.90,NULL,'2022-11-30 19:22:02','2022-11-30 19:22:02',NULL),(638,7705,162,40720,1515,3,68,1,625.99,NULL,'2022-11-30 19:22:02','2022-11-30 19:22:02',NULL),(639,7705,162,40720,1515,3,224,1,392.82,NULL,'2022-11-30 19:22:03','2022-11-30 19:22:03',NULL),(640,7705,162,40720,1515,3,57,2,3999.71,NULL,'2022-11-30 19:22:03','2022-11-30 19:22:03',NULL),(641,7705,163,40720,1515,3,217,1,11188.05,NULL,'2022-11-30 19:22:49','2022-11-30 19:22:49',NULL),(642,7705,163,40720,1515,3,68,1,2349.49,NULL,'2022-11-30 19:22:49','2022-11-30 19:22:49',NULL),(643,7705,163,40720,1515,3,224,1,943.78,NULL,'2022-11-30 19:22:49','2022-11-30 19:22:49',NULL),(644,7705,163,40720,1515,3,57,2,14481.32,NULL,'2022-11-30 19:22:49','2022-11-30 19:22:49',NULL),(645,7705,164,40720,1515,3,217,1,3040.51,NULL,'2022-11-30 19:23:21','2022-11-30 19:23:21',NULL),(646,7705,164,40720,1515,3,68,1,638.51,NULL,'2022-11-30 19:23:21','2022-11-30 19:23:21',NULL),(647,7705,164,40720,1515,3,224,1,320.69,NULL,'2022-11-30 19:23:21','2022-11-30 19:23:21',NULL),(648,7705,164,40720,1515,3,57,2,3999.71,NULL,'2022-11-30 19:23:21','2022-11-30 19:23:21',NULL),(649,7705,165,40720,1515,3,217,1,5432.36,NULL,'2022-11-30 19:24:53','2022-11-30 19:24:53',NULL),(650,7705,165,40720,1515,3,68,1,1140.80,NULL,'2022-11-30 19:24:53','2022-11-30 19:24:53',NULL),(651,7705,165,40720,1515,3,224,1,527.57,NULL,'2022-11-30 19:24:53','2022-11-30 19:24:53',NULL),(652,7705,165,40720,1515,3,57,2,7100.73,NULL,'2022-11-30 19:24:53','2022-11-30 19:24:53',NULL),(653,7705,166,40720,1515,3,217,1,3066.09,NULL,'2022-11-30 19:25:45','2022-11-30 19:25:45',NULL),(654,7705,166,40720,1515,3,68,1,643.88,NULL,'2022-11-30 19:25:45','2022-11-30 19:25:45',NULL),(655,7705,166,40720,1515,3,224,1,290.76,NULL,'2022-11-30 19:25:45','2022-11-30 19:25:45',NULL),(656,7705,166,40720,1515,3,57,2,4000.73,NULL,'2022-11-30 19:25:45','2022-11-30 19:25:45',NULL),(657,7705,167,40720,1515,3,217,1,1420.91,NULL,'2022-11-30 19:27:23','2022-11-30 19:27:23',NULL),(658,7705,167,40720,1515,3,68,1,298.39,NULL,'2022-11-30 19:27:23','2022-11-30 19:27:23',NULL),(659,7705,167,40720,1515,3,224,1,280.69,NULL,'2022-11-30 19:27:23','2022-11-30 19:27:23',NULL),(660,7705,167,40720,1515,3,57,2,1999.99,NULL,'2022-11-30 19:27:23','2022-11-30 19:27:23',NULL);
INSERT INTO `balance_libro_details` VALUES (661,7705,168,40720,1515,3,217,1,12635.59,NULL,'2022-11-30 19:28:31','2022-11-30 19:28:31',NULL),(662,7705,168,40720,1515,3,68,1,2653.47,NULL,'2022-11-30 19:28:31','2022-11-30 19:28:31',NULL),(663,7705,168,40720,1515,3,57,2,15289.06,NULL,'2022-11-30 19:28:31','2022-11-30 19:28:31',NULL),(664,7705,169,40720,1515,3,217,1,2214.87,NULL,'2022-11-30 19:31:29','2022-11-30 19:31:29',NULL),(665,7705,169,40720,1515,3,68,1,465.12,NULL,'2022-11-30 19:31:29','2022-11-30 19:31:29',NULL),(666,7705,169,40720,1515,3,57,2,2679.99,NULL,'2022-11-30 19:31:29','2022-11-30 19:31:29',NULL),(667,7705,170,40720,1515,3,217,1,7754.47,NULL,'2022-11-30 19:33:52','2022-11-30 19:33:52',NULL),(668,7705,170,40720,1515,3,68,1,1628.44,NULL,'2022-11-30 19:33:52','2022-11-30 19:33:52',NULL),(669,7705,170,40720,1515,3,224,1,817.89,NULL,'2022-11-30 19:33:52','2022-11-30 19:33:52',NULL),(670,7705,170,40720,1515,3,57,2,10200.80,NULL,'2022-11-30 19:33:52','2022-11-30 19:33:52',NULL),(671,7705,171,40720,1515,3,217,1,10383.54,NULL,'2022-11-30 19:34:51','2022-11-30 19:34:51',NULL),(672,7705,171,40720,1515,3,68,1,2180.54,NULL,'2022-11-30 19:34:51','2022-11-30 19:34:51',NULL),(673,7705,171,40720,1515,3,224,1,995.87,NULL,'2022-11-30 19:34:51','2022-11-30 19:34:51',NULL),(674,7705,171,40720,1515,3,57,2,13559.95,NULL,'2022-11-30 19:34:51','2022-11-30 19:34:51',NULL),(675,7705,172,40720,1515,3,217,1,8313.27,NULL,'2022-11-30 19:35:27','2022-11-30 19:35:27',NULL),(676,7705,172,40720,1515,3,68,1,1745.79,NULL,'2022-11-30 19:35:27','2022-11-30 19:35:27',NULL),(677,7705,172,40720,1515,3,224,1,797.32,NULL,'2022-11-30 19:35:27','2022-11-30 19:35:27',NULL),(678,7705,172,40720,1515,3,57,2,10856.38,NULL,'2022-11-30 19:35:27','2022-11-30 19:35:27',NULL),(679,7705,173,40720,1515,3,217,1,2280.83,NULL,'2022-11-30 19:36:09','2022-11-30 19:36:09',NULL),(680,7705,173,40720,1515,3,68,1,478.97,NULL,'2022-11-30 19:36:09','2022-11-30 19:36:09',NULL),(681,7705,173,40720,1515,3,224,1,240.57,NULL,'2022-11-30 19:36:09','2022-11-30 19:36:09',NULL),(682,7705,173,40720,1515,3,57,2,3000.37,NULL,'2022-11-30 19:36:09','2022-11-30 19:36:09',NULL),(683,7705,174,40720,1515,3,217,1,1008.26,NULL,'2022-11-30 19:37:05','2022-11-30 19:37:05',NULL),(684,7705,174,40720,1515,3,68,1,211.73,NULL,'2022-11-30 19:37:05','2022-11-30 19:37:05',NULL),(685,7705,174,40720,1515,3,57,2,1219.99,NULL,'2022-11-30 19:37:05','2022-11-30 19:37:05',NULL),(686,7705,175,40720,1515,3,217,1,1158.36,NULL,'2022-11-30 19:37:55','2022-11-30 19:38:32','2022-11-30 19:38:32'),(687,7705,175,40720,1515,3,68,1,243.26,NULL,'2022-11-30 19:37:55','2022-11-30 19:38:32','2022-11-30 19:38:32'),(688,7705,175,40720,1515,3,57,2,1401.62,NULL,'2022-11-30 19:37:55','2022-11-30 19:38:32','2022-11-30 19:38:32'),(689,7705,176,40720,1515,3,217,1,1158.36,NULL,'2022-11-30 19:38:32','2022-11-30 19:38:32',NULL),(690,7705,176,40720,1515,3,68,1,243.26,NULL,'2022-11-30 19:38:32','2022-11-30 19:38:32',NULL),(691,7705,176,40720,1515,3,57,2,1401.62,NULL,'2022-11-30 19:38:32','2022-11-30 19:38:32',NULL),(692,7705,177,40720,1515,3,217,1,1074.39,NULL,'2022-11-30 19:39:29','2022-11-30 19:39:29',NULL),(693,7705,177,40720,1515,3,68,1,225.62,NULL,'2022-11-30 19:39:29','2022-11-30 19:39:29',NULL),(694,7705,177,40720,1515,3,57,2,1300.01,NULL,'2022-11-30 19:39:29','2022-11-30 19:39:29',NULL),(695,7705,178,40720,1515,3,217,1,12728.00,NULL,'2022-11-30 19:40:22','2022-11-30 19:40:22',NULL),(696,7705,178,40720,1515,3,68,1,2672.88,NULL,'2022-11-30 19:40:22','2022-11-30 19:40:22',NULL),(697,7705,178,40720,1515,3,57,2,15400.88,NULL,'2022-11-30 19:40:22','2022-11-30 19:40:22',NULL),(698,7705,179,40720,1515,3,217,1,9106.47,NULL,'2022-11-30 19:41:40','2022-11-30 19:41:40',NULL),(699,7705,179,40720,1515,3,68,1,1912.36,NULL,'2022-11-30 19:41:40','2022-11-30 19:41:40',NULL),(700,7705,179,40720,1515,3,224,1,884.38,NULL,'2022-11-30 19:41:40','2022-11-30 19:41:40',NULL),(701,7705,179,40720,1515,3,57,2,11903.21,NULL,'2022-11-30 19:41:40','2022-11-30 19:41:40',NULL);
INSERT INTO `balance_libro_details` VALUES (702,7705,180,40720,1515,3,217,1,6081.46,NULL,'2022-11-30 19:42:23','2022-11-30 19:42:23',NULL),(703,7705,180,40720,1515,3,68,1,1277.11,NULL,'2022-11-30 19:42:23','2022-11-30 19:42:23',NULL),(704,7705,180,40720,1515,3,224,1,641.43,NULL,'2022-11-30 19:42:23','2022-11-30 19:42:23',NULL),(705,7705,180,40720,1515,3,57,2,8000.00,NULL,'2022-11-30 19:42:23','2022-11-30 19:42:23',NULL),(706,7705,181,40720,1515,3,217,1,9271.02,NULL,'2022-11-30 19:43:06','2022-11-30 19:43:06',NULL),(707,7705,181,40720,1515,3,68,1,1946.91,NULL,'2022-11-30 19:43:06','2022-11-30 19:43:06',NULL),(708,7705,181,40720,1515,3,224,1,782.06,NULL,'2022-11-30 19:43:06','2022-11-30 19:43:06',NULL),(709,7705,181,40720,1515,3,57,2,11999.99,NULL,'2022-11-30 19:43:06','2022-11-30 19:43:06',NULL),(710,7705,182,40720,1515,3,217,1,11665.95,NULL,'2022-11-30 19:46:57','2022-11-30 19:46:57',NULL),(711,7705,182,40720,1515,3,68,1,2449.85,NULL,'2022-11-30 19:46:57','2022-11-30 19:46:57',NULL),(712,7705,182,40720,1515,3,224,1,984.09,NULL,'2022-11-30 19:46:57','2022-11-30 19:46:57',NULL),(713,7705,182,40720,1515,3,57,2,15099.89,NULL,'2022-11-30 19:46:57','2022-11-30 19:46:57',NULL),(714,7705,183,40720,1515,3,217,1,5483.96,NULL,'2022-11-30 19:47:45','2022-11-30 19:47:45',NULL),(715,7705,183,40720,1515,3,68,1,1151.63,NULL,'2022-11-30 19:47:45','2022-11-30 19:47:45',NULL),(716,7705,183,40720,1515,3,224,1,864.39,NULL,'2022-11-30 19:47:45','2022-11-30 19:47:45',NULL),(717,7705,183,40720,1515,3,57,2,7499.98,NULL,'2022-11-30 19:47:45','2022-11-30 19:47:45',NULL),(718,7705,184,40720,1515,3,217,1,4635.87,NULL,'2022-11-30 19:48:16','2022-11-30 19:48:16',NULL),(719,7705,184,40720,1515,3,68,1,973.53,NULL,'2022-11-30 19:48:16','2022-11-30 19:48:16',NULL),(720,7705,184,40720,1515,3,224,1,391.06,NULL,'2022-11-30 19:48:16','2022-11-30 19:48:16',NULL),(721,7705,184,40720,1515,3,57,2,6000.46,NULL,'2022-11-30 19:48:16','2022-11-30 19:48:16',NULL),(722,7705,185,40720,1515,3,217,1,2235.94,NULL,'2022-11-30 19:49:07','2022-11-30 19:49:07',NULL),(723,7705,185,40720,1515,3,68,1,469.55,NULL,'2022-11-30 19:49:07','2022-11-30 19:49:07',NULL),(724,7705,185,40720,1515,3,224,1,294.65,NULL,'2022-11-30 19:49:07','2022-11-30 19:49:07',NULL),(725,7705,185,40720,1515,3,57,2,3000.14,NULL,'2022-11-30 19:49:07','2022-11-30 19:49:07',NULL),(726,7705,186,40720,1515,2,96,2,145706.00,NULL,'2022-12-01 19:52:06','2022-12-01 19:52:06',NULL),(727,7705,186,40720,1515,2,67,2,30598.26,NULL,'2022-12-01 19:52:06','2022-12-01 19:52:06',NULL),(728,7705,186,40720,1515,2,13,1,176304.26,NULL,'2022-12-01 19:52:06','2022-12-01 19:52:06',NULL),(729,7705,187,40720,1515,2,96,2,221993.00,NULL,'2022-12-01 19:52:56','2022-12-01 19:52:56',NULL),(730,7705,187,40720,1515,2,67,2,46618.53,NULL,'2022-12-01 19:52:56','2022-12-01 19:52:56',NULL),(731,7705,187,40720,1515,2,13,1,268611.53,NULL,'2022-12-01 19:52:56','2022-12-01 19:52:56',NULL),(732,7705,188,40720,1515,2,96,2,235112.00,NULL,'2022-12-01 19:53:30','2022-12-01 19:53:30',NULL),(733,7705,188,40720,1515,2,67,2,49373.52,NULL,'2022-12-01 19:53:30','2022-12-01 19:53:30',NULL),(734,7705,188,40720,1515,2,13,1,284485.52,NULL,'2022-12-01 19:53:30','2022-12-01 19:53:30',NULL),(735,7705,189,40720,1515,2,96,2,97828.00,NULL,'2022-12-01 19:54:09','2022-12-01 19:54:09',NULL),(736,7705,189,40720,1515,2,67,2,20543.88,NULL,'2022-12-01 19:54:09','2022-12-01 19:54:09',NULL),(737,7705,189,40720,1515,2,13,1,118371.88,NULL,'2022-12-01 19:54:09','2022-12-01 19:54:09',NULL),(738,7705,190,40720,1515,2,96,1,10173.28,NULL,'2022-12-01 19:55:17','2022-12-01 19:55:17',NULL),(739,7705,190,40720,1515,2,68,1,2136.39,NULL,'2022-12-01 19:55:17','2022-12-01 19:55:17',NULL),(740,7705,190,40720,1515,2,13,2,12309.67,NULL,'2022-12-01 19:55:17','2022-12-01 19:55:17',NULL),(741,7705,191,40720,1515,15,67,1,147134.19,NULL,'2022-12-01 22:19:40','2022-12-01 22:19:40',NULL),(742,7705,191,40720,1515,15,68,2,122159.41,NULL,'2022-12-01 22:19:40','2022-12-01 22:19:40',NULL);
INSERT INTO `balance_libro_details` VALUES (743,7705,191,40720,1515,15,220,2,102.18,NULL,'2022-12-01 22:19:40','2022-12-01 22:19:40',NULL),(744,7705,191,40720,1515,15,74,2,24872.60,NULL,'2022-12-01 22:19:40','2022-12-01 22:19:40',NULL),(745,7705,192,40720,1515,16,237,2,102.18,NULL,'2022-12-01 22:20:46','2022-12-01 22:20:46',NULL),(746,7705,192,40720,1515,16,313,1,102.18,NULL,'2022-12-01 22:20:46','2022-12-01 22:20:46',NULL),(747,7705,193,40720,1516,3,217,1,6615.43,NULL,'2022-12-09 10:43:03','2022-12-09 10:43:03',NULL),(748,7705,193,40720,1516,3,68,1,1389.24,NULL,'2022-12-09 10:43:03','2022-12-09 10:43:03',NULL),(749,7705,193,40720,1516,3,224,1,799.82,NULL,'2022-12-09 10:43:03','2022-12-09 10:43:03',NULL),(750,7705,193,40720,1516,3,57,2,8804.49,NULL,'2022-12-09 10:43:03','2022-12-09 10:43:03',NULL),(751,7705,194,40720,1516,3,217,1,5360.88,NULL,'2022-12-09 10:43:37','2022-12-09 10:43:37',NULL),(752,7705,194,40720,1516,3,68,1,1125.78,NULL,'2022-12-09 10:43:37','2022-12-09 10:43:37',NULL),(753,7705,194,40720,1516,3,224,1,648.14,NULL,'2022-12-09 10:43:37','2022-12-09 10:43:37',NULL),(754,7705,194,40720,1516,3,57,2,7134.80,NULL,'2022-12-09 10:43:37','2022-12-09 10:43:37',NULL),(755,7705,195,40720,1516,3,217,1,6790.26,NULL,'2022-12-09 10:44:21','2022-12-09 10:44:21',NULL),(756,7705,195,40720,1516,3,68,1,1425.95,NULL,'2022-12-09 10:44:21','2022-12-09 10:44:21',NULL),(757,7705,195,40720,1516,3,224,1,985.66,NULL,'2022-12-09 10:44:21','2022-12-09 10:44:21',NULL),(758,7705,195,40720,1516,3,57,2,9201.87,NULL,'2022-12-09 10:44:21','2022-12-09 10:44:21',NULL),(759,7705,196,40720,1516,3,217,1,1154.44,NULL,'2022-12-09 10:45:04','2022-12-09 10:45:04',NULL),(760,7705,196,40720,1516,3,68,1,242.43,NULL,'2022-12-09 10:45:04','2022-12-09 10:45:04',NULL),(761,7705,196,40720,1516,3,224,1,103.10,NULL,'2022-12-09 10:45:04','2022-12-09 10:45:04',NULL),(762,7705,196,40720,1516,3,57,2,1499.97,NULL,'2022-12-09 10:45:04','2022-12-09 10:45:04',NULL),(763,7705,197,40720,1516,3,217,1,7378.05,NULL,'2022-12-09 10:45:45','2022-12-09 10:45:45',NULL),(764,7705,197,40720,1516,3,68,1,1549.39,NULL,'2022-12-09 10:45:45','2022-12-09 10:45:45',NULL),(765,7705,197,40720,1516,3,224,1,572.57,NULL,'2022-12-09 10:45:45','2022-12-09 10:45:45',NULL),(766,7705,197,40720,1516,3,57,2,9500.01,NULL,'2022-12-09 10:45:45','2022-12-09 10:45:45',NULL),(767,7705,198,40720,1516,3,217,1,5367.07,NULL,'2022-12-09 12:07:41','2022-12-09 12:07:41',NULL),(768,7705,198,40720,1516,3,68,1,1127.08,NULL,'2022-12-09 12:07:41','2022-12-09 12:07:41',NULL),(769,7705,198,40720,1516,3,224,1,906.01,NULL,'2022-12-09 12:07:41','2022-12-09 12:07:41',NULL),(770,7705,198,40720,1516,3,57,2,7400.16,NULL,'2022-12-09 12:07:41','2022-12-09 12:07:41',NULL),(771,7705,199,40720,1516,3,217,1,10390.29,NULL,'2022-12-09 12:09:53','2022-12-09 12:09:53',NULL),(772,7705,199,40720,1516,3,68,1,2181.96,NULL,'2022-12-09 12:09:53','2022-12-09 12:09:53',NULL),(773,7705,199,40720,1516,3,224,1,927.91,NULL,'2022-12-09 12:09:53','2022-12-09 12:09:53',NULL),(774,7705,199,40720,1516,3,57,2,13500.16,NULL,'2022-12-09 12:09:53','2022-12-09 12:09:53',NULL),(775,7705,200,40720,1516,3,217,1,2253.99,NULL,'2022-12-09 12:10:33','2022-12-09 12:10:33',NULL),(776,7705,200,40720,1516,3,68,1,473.34,NULL,'2022-12-09 12:10:33','2022-12-09 12:10:33',NULL),(777,7705,200,40720,1516,3,224,1,272.32,NULL,'2022-12-09 12:10:33','2022-12-09 12:10:33',NULL),(778,7705,200,40720,1516,3,57,2,2999.65,NULL,'2022-12-09 12:10:33','2022-12-09 12:10:33',NULL),(779,7705,201,40720,1516,3,217,1,1521.28,NULL,'2022-12-09 12:11:24','2022-12-09 12:11:24',NULL),(780,7705,201,40720,1516,3,68,1,319.47,NULL,'2022-12-09 12:11:24','2022-12-09 12:11:24',NULL),(781,7705,201,40720,1516,3,224,1,159.82,NULL,'2022-12-09 12:11:24','2022-12-09 12:11:24',NULL),(782,7705,201,40720,1516,3,57,2,2000.57,NULL,'2022-12-09 12:11:24','2022-12-09 12:11:24',NULL),(783,7705,202,40720,1516,3,217,1,6213.44,NULL,'2022-12-09 12:12:32','2022-12-09 12:12:32',NULL),(784,7705,202,40720,1516,3,68,1,1304.82,NULL,'2022-12-09 12:12:32','2022-12-09 12:12:32',NULL);
INSERT INTO `balance_libro_details` VALUES (785,7705,202,40720,1516,3,224,1,482.19,NULL,'2022-12-09 12:12:32','2022-12-09 12:12:32',NULL),(786,7705,202,40720,1516,3,57,2,8000.45,NULL,'2022-12-09 12:12:32','2022-12-09 12:12:32',NULL),(787,7705,203,40720,1516,3,217,1,9196.78,NULL,'2022-12-09 12:13:55','2022-12-09 12:13:55',NULL),(788,7705,203,40720,1516,3,68,1,1931.32,NULL,'2022-12-09 12:13:55','2022-12-09 12:13:55',NULL),(789,7705,203,40720,1516,3,224,1,1072.65,NULL,'2022-12-09 12:13:55','2022-12-09 12:13:55',NULL),(790,7705,203,40720,1516,3,57,2,12200.75,NULL,'2022-12-09 12:13:55','2022-12-09 12:13:55',NULL),(791,7705,204,40720,1516,3,217,1,6601.41,NULL,'2022-12-09 12:14:32','2022-12-09 12:14:32',NULL),(792,7705,204,40720,1516,3,68,1,1386.30,NULL,'2022-12-09 12:14:32','2022-12-09 12:14:32',NULL),(793,7705,204,40720,1516,3,224,1,512.30,NULL,'2022-12-09 12:14:32','2022-12-09 12:14:32',NULL),(794,7705,204,40720,1516,3,57,2,8500.01,NULL,'2022-12-09 12:14:32','2022-12-09 12:14:32',NULL),(795,7705,205,40720,1516,3,217,1,7659.06,NULL,'2022-12-09 12:15:17','2022-12-09 12:15:17',NULL),(796,7705,205,40720,1516,3,68,1,1608.40,NULL,'2022-12-09 12:15:17','2022-12-09 12:15:17',NULL),(797,7705,205,40720,1516,3,224,1,684.00,NULL,'2022-12-09 12:15:17','2022-12-09 12:15:17',NULL),(798,7705,205,40720,1516,3,57,2,9951.46,NULL,'2022-12-09 12:15:17','2022-12-09 12:15:17',NULL),(799,7705,206,40720,1516,3,217,1,11563.49,NULL,'2022-12-09 12:16:16','2022-12-09 12:16:16',NULL),(800,7705,206,40720,1516,3,68,1,2428.33,NULL,'2022-12-09 12:16:16','2022-12-09 12:16:16',NULL),(801,7705,206,40720,1516,3,224,1,1058.34,NULL,'2022-12-09 12:16:16','2022-12-09 12:16:16',NULL),(802,7705,206,40720,1516,3,57,2,15050.16,NULL,'2022-12-09 12:16:16','2022-12-09 12:16:16',NULL),(803,7705,207,40720,1516,3,217,1,7651.09,NULL,'2022-12-09 12:17:08','2022-12-09 12:17:08',NULL),(804,7705,207,40720,1516,3,68,1,1606.73,NULL,'2022-12-09 12:17:08','2022-12-09 12:17:08',NULL),(805,7705,207,40720,1516,3,224,1,741.81,NULL,'2022-12-09 12:17:08','2022-12-09 12:17:08',NULL),(806,7705,207,40720,1516,3,57,2,9999.63,NULL,'2022-12-09 12:17:08','2022-12-09 12:17:08',NULL),(807,7705,208,40720,1516,3,217,1,2849.64,NULL,'2022-12-09 12:18:33','2022-12-09 12:18:33',NULL),(808,7705,208,40720,1516,3,68,1,598.42,NULL,'2022-12-09 12:18:33','2022-12-09 12:18:33',NULL),(809,7705,208,40720,1516,3,224,1,702.02,NULL,'2022-12-09 12:18:33','2022-12-09 12:18:33',NULL),(810,7705,208,40720,1516,3,57,2,4150.08,NULL,'2022-12-09 12:18:33','2022-12-09 12:18:33',NULL),(811,7705,209,40720,1516,3,217,1,6371.92,NULL,'2022-12-09 12:19:21','2022-12-09 12:19:21',NULL),(812,7705,209,40720,1516,3,68,1,1338.10,NULL,'2022-12-09 12:19:21','2022-12-09 12:19:21',NULL),(813,7705,209,40720,1516,3,224,1,789.98,NULL,'2022-12-09 12:19:21','2022-12-09 12:19:21',NULL),(814,7705,209,40720,1516,3,57,2,8500.00,NULL,'2022-12-09 12:19:21','2022-12-09 12:19:21',NULL),(815,7705,210,40720,1516,3,217,1,8621.36,NULL,'2022-12-09 12:20:04','2022-12-09 12:20:04',NULL),(816,7705,210,40720,1516,3,68,1,1810.49,NULL,'2022-12-09 12:20:04','2022-12-09 12:20:04',NULL),(817,7705,210,40720,1516,3,224,1,769.93,NULL,'2022-12-09 12:20:04','2022-12-09 12:20:04',NULL),(818,7705,210,40720,1516,3,57,2,11201.78,NULL,'2022-12-09 12:20:04','2022-12-09 12:20:04',NULL),(819,7705,211,40720,1516,3,217,1,5247.64,NULL,'2022-12-09 12:20:46','2022-12-09 12:20:46',NULL),(820,7705,211,40720,1516,3,68,1,1102.00,NULL,'2022-12-09 12:20:46','2022-12-09 12:20:46',NULL),(821,7705,211,40720,1516,3,224,1,650.59,NULL,'2022-12-09 12:20:46','2022-12-09 12:20:46',NULL),(822,7705,211,40720,1516,3,57,2,7000.23,NULL,'2022-12-09 12:20:46','2022-12-09 12:20:46',NULL),(823,7705,212,40720,1516,3,217,1,8325.48,NULL,'2022-12-09 12:21:19','2022-12-09 12:21:19',NULL),(824,7705,212,40720,1516,3,68,1,1748.35,NULL,'2022-12-09 12:21:19','2022-12-09 12:21:19',NULL),(825,7705,212,40720,1516,3,224,1,1032.17,NULL,'2022-12-09 12:21:19','2022-12-09 12:21:19',NULL);
INSERT INTO `balance_libro_details` VALUES (826,7705,212,40720,1516,3,57,2,11106.00,NULL,'2022-12-09 12:21:19','2022-12-09 12:21:19',NULL),(827,7705,213,40720,1516,3,217,1,5247.51,NULL,'2022-12-09 12:22:05','2022-12-09 12:22:05',NULL),(828,7705,213,40720,1516,3,68,1,1101.98,NULL,'2022-12-09 12:22:05','2022-12-09 12:22:05',NULL),(829,7705,213,40720,1516,3,224,1,650.57,NULL,'2022-12-09 12:22:05','2022-12-09 12:22:05',NULL),(830,7705,213,40720,1516,3,57,2,7000.06,NULL,'2022-12-09 12:22:05','2022-12-09 12:22:05',NULL),(831,7705,214,40720,1516,3,217,1,2253.99,NULL,'2022-12-20 19:10:05','2022-12-20 19:10:05',NULL),(832,7705,214,40720,1516,3,68,1,473.34,NULL,'2022-12-20 19:10:06','2022-12-20 19:10:06',NULL),(833,7705,214,40720,1516,3,224,1,272.32,NULL,'2022-12-20 19:10:06','2022-12-20 19:10:06',NULL),(834,7705,214,40720,1516,3,57,2,2999.65,NULL,'2022-12-20 19:10:06','2022-12-20 19:10:06',NULL),(835,7705,215,40720,1516,3,217,1,3747.68,NULL,'2022-12-20 19:11:20','2022-12-20 19:11:20',NULL),(836,7705,215,40720,1516,3,68,1,787.01,NULL,'2022-12-20 19:11:20','2022-12-20 19:11:20',NULL),(837,7705,215,40720,1516,3,224,1,464.63,NULL,'2022-12-20 19:11:20','2022-12-20 19:11:20',NULL),(838,7705,215,40720,1516,3,57,2,4999.32,NULL,'2022-12-20 19:11:20','2022-12-20 19:11:20',NULL),(839,7705,216,40720,1516,3,217,1,5247.64,NULL,'2022-12-20 19:12:31','2022-12-20 19:12:31',NULL),(840,7705,216,40720,1516,3,68,1,1102.00,NULL,'2022-12-20 19:12:31','2022-12-20 19:12:31',NULL),(841,7705,216,40720,1516,3,224,1,650.59,NULL,'2022-12-20 19:12:31','2022-12-20 19:12:31',NULL),(842,7705,216,40720,1516,3,57,2,7000.23,NULL,'2022-12-20 19:12:31','2022-12-20 19:12:31',NULL),(843,7705,217,40720,1516,3,217,1,8995.94,NULL,'2022-12-20 19:13:30','2022-12-20 19:13:30',NULL),(844,7705,217,40720,1516,3,68,1,1889.15,NULL,'2022-12-20 19:13:30','2022-12-20 19:13:30',NULL),(845,7705,217,40720,1516,3,224,1,1115.30,NULL,'2022-12-20 19:13:30','2022-12-20 19:13:30',NULL),(846,7705,217,40720,1516,3,57,2,12000.39,NULL,'2022-12-20 19:13:30','2022-12-20 19:13:30',NULL),(847,7705,218,40720,1516,3,217,1,10873.33,NULL,'2022-12-20 19:14:19','2022-12-20 19:14:19',NULL),(848,7705,218,40720,1516,3,68,1,2283.40,NULL,'2022-12-20 19:14:19','2022-12-20 19:14:19',NULL),(849,7705,218,40720,1516,3,224,1,843.81,NULL,'2022-12-20 19:14:19','2022-12-20 19:14:19',NULL),(850,7705,218,40720,1516,3,57,2,14000.54,NULL,'2022-12-20 19:14:19','2022-12-20 19:14:19',NULL),(851,7705,219,40720,1516,3,217,1,7495.99,NULL,'2022-12-20 19:16:04','2022-12-20 19:16:04',NULL),(852,7705,219,40720,1516,3,68,1,1574.16,NULL,'2022-12-20 19:16:04','2022-12-20 19:16:04',NULL),(853,7705,219,40720,1516,3,224,1,929.34,NULL,'2022-12-20 19:16:04','2022-12-20 19:16:04',NULL),(854,7705,219,40720,1516,3,57,2,9999.49,NULL,'2022-12-20 19:16:04','2022-12-20 19:16:04',NULL),(855,7705,220,40720,1516,3,217,1,7766.20,NULL,'2022-12-20 19:17:03','2022-12-20 19:17:03',NULL),(856,7705,220,40720,1516,3,68,1,1630.90,NULL,'2022-12-20 19:17:03','2022-12-20 19:17:03',NULL),(857,7705,220,40720,1516,3,224,1,602.69,NULL,'2022-12-20 19:17:03','2022-12-20 19:17:03',NULL),(858,7705,220,40720,1516,3,57,2,9999.79,NULL,'2022-12-20 19:17:03','2022-12-20 19:17:03',NULL),(859,7705,221,40720,1516,3,217,1,8920.79,NULL,'2022-12-22 20:23:28','2022-12-22 20:23:28',NULL),(860,7705,221,40720,1516,3,68,1,1873.37,NULL,'2022-12-22 20:23:28','2022-12-22 20:23:28',NULL),(861,7705,221,40720,1516,3,224,1,1105.98,NULL,'2022-12-22 20:23:28','2022-12-22 20:23:28',NULL),(862,7705,221,40720,1516,3,57,2,11900.14,NULL,'2022-12-22 20:23:28','2022-12-22 20:23:28',NULL),(863,7705,222,40720,1516,3,217,1,12006.69,NULL,'2022-12-22 20:24:24','2022-12-22 20:24:24',NULL),(864,7705,222,40720,1516,3,68,1,2521.40,NULL,'2022-12-22 20:24:24','2022-12-22 20:24:24',NULL),(865,7705,222,40720,1516,3,224,1,1072.26,NULL,'2022-12-22 20:24:24','2022-12-22 20:24:24',NULL),(866,7705,222,40720,1516,3,57,2,15600.35,NULL,'2022-12-22 20:24:24','2022-12-22 20:24:24',NULL);
INSERT INTO `balance_libro_details` VALUES (867,7705,223,40720,1516,3,217,1,7256.69,NULL,'2022-12-22 20:25:05','2022-12-22 20:25:05',NULL),(868,7705,223,40720,1516,3,68,1,1523.90,NULL,'2022-12-22 20:25:05','2022-12-22 20:25:05',NULL),(869,7705,223,40720,1516,3,224,1,673.78,NULL,'2022-12-22 20:25:05','2022-12-22 20:25:05',NULL),(870,7705,223,40720,1516,3,57,2,9454.37,NULL,'2022-12-22 20:25:05','2022-12-22 20:25:05',NULL),(871,7705,224,40720,1516,3,217,1,10678.75,NULL,'2022-12-22 20:25:56','2022-12-22 20:25:56',NULL),(872,7705,224,40720,1516,3,68,1,2242.54,NULL,'2022-12-22 20:25:56','2022-12-22 20:25:56',NULL),(873,7705,224,40720,1516,3,224,1,828.71,NULL,'2022-12-22 20:25:56','2022-12-22 20:25:56',NULL),(874,7705,224,40720,1516,3,57,2,13750.00,NULL,'2022-12-22 20:25:56','2022-12-22 20:25:56',NULL),(875,7705,225,40720,1516,3,217,1,2213.47,NULL,'2022-12-22 20:26:25','2022-12-22 20:26:25',NULL),(876,7705,225,40720,1516,3,68,1,464.83,NULL,'2022-12-22 20:26:25','2022-12-22 20:26:25',NULL),(877,7705,225,40720,1516,3,224,1,321.30,NULL,'2022-12-22 20:26:25','2022-12-22 20:26:25',NULL),(878,7705,225,40720,1516,3,57,2,2999.60,NULL,'2022-12-22 20:26:25','2022-12-22 20:26:25',NULL),(879,7705,226,40720,1516,3,217,1,1475.65,NULL,'2022-12-22 20:26:55','2022-12-22 20:26:55',NULL),(880,7705,226,40720,1516,3,68,1,309.89,NULL,'2022-12-22 20:26:55','2022-12-22 20:26:55',NULL),(881,7705,226,40720,1516,3,224,1,214.20,NULL,'2022-12-22 20:26:55','2022-12-22 20:26:55',NULL),(882,7705,226,40720,1516,3,57,2,1999.74,NULL,'2022-12-22 20:26:55','2022-12-22 20:26:55',NULL),(883,7705,227,40720,1516,3,217,1,11028.76,NULL,'2022-12-22 20:27:28','2022-12-22 20:27:28',NULL),(884,7705,227,40720,1516,3,68,1,2316.04,NULL,'2022-12-22 20:27:28','2022-12-22 20:27:28',NULL),(885,7705,227,40720,1516,3,224,1,855.87,NULL,'2022-12-22 20:27:28','2022-12-22 20:27:28',NULL),(886,7705,227,40720,1516,3,57,2,14200.67,NULL,'2022-12-22 20:27:28','2022-12-22 20:27:28',NULL),(887,7705,228,40720,1516,3,217,1,6597.27,NULL,'2022-12-22 20:28:04','2022-12-22 20:28:04',NULL),(888,7705,228,40720,1516,3,68,1,1385.43,NULL,'2022-12-22 20:28:04','2022-12-22 20:28:04',NULL),(889,7705,228,40720,1516,3,224,1,817.91,NULL,'2022-12-22 20:28:04','2022-12-22 20:28:04',NULL),(890,7705,228,40720,1516,3,57,2,8800.61,NULL,'2022-12-22 20:28:04','2022-12-22 20:28:04',NULL),(891,7705,229,40720,1516,3,217,1,1140.80,NULL,'2022-12-22 20:28:59','2022-12-22 20:28:59',NULL),(892,7705,229,40720,1516,3,68,1,239.57,NULL,'2022-12-22 20:28:59','2022-12-22 20:28:59',NULL),(893,7705,229,40720,1516,3,224,1,119.85,NULL,'2022-12-22 20:28:59','2022-12-22 20:28:59',NULL),(894,7705,229,40720,1516,3,57,2,1500.22,NULL,'2022-12-22 20:28:59','2022-12-22 20:28:59',NULL),(895,7705,230,40720,1516,3,217,1,6971.16,NULL,'2022-12-22 20:30:05','2022-12-22 20:30:05',NULL),(896,7705,230,40720,1516,3,68,1,1463.94,NULL,'2022-12-22 20:30:05','2022-12-22 20:30:05',NULL),(897,7705,230,40720,1516,3,224,1,864.27,NULL,'2022-12-22 20:30:05','2022-12-22 20:30:05',NULL),(898,7705,230,40720,1516,3,57,2,9299.37,NULL,'2022-12-22 20:30:05','2022-12-22 20:30:05',NULL),(899,7705,231,40720,1516,3,217,1,9889.48,NULL,'2022-12-22 20:30:43','2022-12-22 20:30:43',NULL),(900,7705,231,40720,1516,3,68,1,2076.79,NULL,'2022-12-22 20:30:43','2022-12-22 20:30:43',NULL),(901,7705,231,40720,1516,3,224,1,1033.88,NULL,'2022-12-22 20:30:43','2022-12-22 20:30:43',NULL),(902,7705,231,40720,1516,3,57,2,13000.15,NULL,'2022-12-22 20:30:43','2022-12-22 20:30:43',NULL),(903,7705,232,40720,1516,3,217,1,9168.90,NULL,'2022-12-22 20:31:21','2022-12-22 20:31:21',NULL),(904,7705,232,40720,1516,3,68,1,1925.47,NULL,'2022-12-22 20:31:21','2022-12-22 20:31:21',NULL),(905,7705,232,40720,1516,3,224,1,906.10,NULL,'2022-12-22 20:31:21','2022-12-22 20:31:21',NULL),(906,7705,232,40720,1516,3,57,2,12000.47,NULL,'2022-12-22 20:31:21','2022-12-22 20:31:21',NULL),(907,7705,233,40720,1516,3,217,1,10010.68,NULL,'2022-12-22 20:31:51','2022-12-22 20:31:51',NULL),(908,7705,233,40720,1516,3,68,1,2102.24,NULL,'2022-12-22 20:31:51','2022-12-22 20:31:51',NULL);
INSERT INTO `balance_libro_details` VALUES (909,7705,233,40720,1516,3,224,1,989.29,NULL,'2022-12-22 20:31:51','2022-12-22 20:31:51',NULL),(910,7705,233,40720,1516,3,57,2,13102.21,NULL,'2022-12-22 20:31:51','2022-12-22 20:31:51',NULL),(911,7705,234,40720,1516,3,217,1,7696.80,NULL,'2022-12-22 20:32:43','2022-12-22 20:32:43',NULL),(912,7705,234,40720,1516,3,68,1,1616.33,NULL,'2022-12-22 20:32:43','2022-12-22 20:32:43',NULL),(913,7705,234,40720,1516,3,224,1,687.37,NULL,'2022-12-22 20:32:43','2022-12-22 20:32:43',NULL),(914,7705,234,40720,1516,3,57,2,10000.50,NULL,'2022-12-22 20:32:43','2022-12-22 20:32:43',NULL),(915,7705,235,40720,1516,3,217,1,9044.33,NULL,'2022-12-22 20:33:30','2022-12-22 20:33:30',NULL),(916,7705,235,40720,1516,3,68,1,1899.31,NULL,'2022-12-22 20:33:30','2022-12-22 20:33:30',NULL),(917,7705,235,40720,1516,3,224,1,807.71,NULL,'2022-12-22 20:33:30','2022-12-22 20:33:30',NULL),(918,7705,235,40720,1516,3,57,2,11751.35,NULL,'2022-12-22 20:33:30','2022-12-22 20:33:30',NULL),(919,7705,236,40720,1516,3,217,1,8577.33,NULL,'2022-12-22 20:34:28','2022-12-22 20:34:28',NULL),(920,7705,236,40720,1516,3,68,1,1801.24,NULL,'2022-12-22 20:34:28','2022-12-22 20:34:28',NULL),(921,7705,236,40720,1516,3,224,1,766.00,NULL,'2022-12-22 20:34:28','2022-12-22 20:34:28',NULL),(922,7705,236,40720,1516,3,57,2,11144.57,NULL,'2022-12-22 20:34:28','2022-12-22 20:34:28',NULL),(923,7705,237,40720,1516,3,217,1,8176.54,NULL,'2022-12-22 20:37:39','2022-12-22 20:37:39',NULL),(924,7705,237,40720,1516,3,68,1,1717.07,NULL,'2022-12-22 20:37:39','2022-12-22 20:37:39',NULL),(925,7705,237,40720,1516,3,224,1,755.91,NULL,'2022-12-22 20:37:39','2022-12-22 20:37:39',NULL),(926,7705,237,40720,1516,3,57,2,10649.52,NULL,'2022-12-22 20:37:39','2022-12-22 20:37:39',NULL),(927,7705,238,40720,1516,3,217,1,3847.61,NULL,'2022-12-22 20:48:53','2022-12-22 20:48:53',NULL),(928,7705,238,40720,1516,3,68,1,808.00,NULL,'2022-12-22 20:48:53','2022-12-22 20:48:53',NULL),(929,7705,238,40720,1516,3,224,1,343.61,NULL,'2022-12-22 20:48:53','2022-12-22 20:48:53',NULL),(930,7705,238,40720,1516,3,57,2,4999.22,NULL,'2022-12-22 20:48:53','2022-12-22 20:48:53',NULL),(931,7705,239,40720,1516,3,217,1,2281.73,NULL,'2022-12-22 20:50:11','2022-12-22 20:50:11',NULL),(932,7705,239,40720,1516,3,68,1,479.16,NULL,'2022-12-22 20:50:11','2022-12-22 20:50:11',NULL),(933,7705,239,40720,1516,3,224,1,239.71,NULL,'2022-12-22 20:50:11','2022-12-22 20:50:11',NULL),(934,7705,239,40720,1516,3,57,2,3000.60,NULL,'2022-12-22 20:50:11','2022-12-22 20:50:11',NULL),(935,7705,240,40720,1516,3,217,1,6366.27,NULL,'2022-12-22 20:51:04','2022-12-22 20:51:04',NULL),(936,7705,240,40720,1516,3,68,1,1336.92,NULL,'2022-12-22 20:51:04','2022-12-22 20:51:04',NULL),(937,7705,240,40720,1516,3,224,1,597.96,NULL,'2022-12-22 20:51:04','2022-12-22 20:51:04',NULL),(938,7705,240,40720,1516,3,57,2,8301.15,NULL,'2022-12-22 20:51:04','2022-12-22 20:51:04',NULL),(939,7705,241,40720,1516,3,217,1,7696.80,NULL,'2022-12-22 20:51:50','2022-12-22 20:51:50',NULL),(940,7705,241,40720,1516,3,68,1,1616.33,NULL,'2022-12-22 20:51:50','2022-12-22 20:51:50',NULL),(941,7705,241,40720,1516,3,224,1,687.37,NULL,'2022-12-22 20:51:50','2022-12-22 20:51:50',NULL),(942,7705,241,40720,1516,3,57,2,10000.50,NULL,'2022-12-22 20:51:50','2022-12-22 20:51:50',NULL),(943,7705,242,40720,1516,3,217,1,9970.36,NULL,'2022-12-22 20:52:35','2022-12-22 20:52:35',NULL),(944,7705,242,40720,1516,3,68,1,2093.78,NULL,'2022-12-22 20:52:35','2022-12-22 20:52:35',NULL),(945,7705,242,40720,1516,3,224,1,1236.10,NULL,'2022-12-22 20:52:35','2022-12-22 20:52:35',NULL),(946,7705,242,40720,1516,3,57,2,13300.24,NULL,'2022-12-22 20:52:35','2022-12-22 20:52:35',NULL),(947,7705,243,40720,1516,3,217,1,7871.13,NULL,'2022-12-22 20:53:14','2022-12-22 20:53:14',NULL),(948,7705,243,40720,1516,3,68,1,1652.94,NULL,'2022-12-22 20:53:14','2022-12-22 20:53:14',NULL),(949,7705,243,40720,1516,3,224,1,975.85,NULL,'2022-12-22 20:53:14','2022-12-22 20:53:14',NULL);
INSERT INTO `balance_libro_details` VALUES (950,7705,243,40720,1516,3,57,2,10499.92,NULL,'2022-12-22 20:53:14','2022-12-22 20:53:14',NULL),(951,7705,244,40720,1516,3,217,1,7696.80,NULL,'2022-12-22 20:54:01','2022-12-22 20:54:01',NULL),(952,7705,244,40720,1516,3,68,1,1616.33,NULL,'2022-12-22 20:54:01','2022-12-22 20:54:01',NULL),(953,7705,244,40720,1516,3,224,1,687.37,NULL,'2022-12-22 20:54:01','2022-12-22 20:54:01',NULL),(954,7705,244,40720,1516,3,57,2,10000.50,NULL,'2022-12-22 20:54:01','2022-12-22 20:54:01',NULL),(955,7705,245,40720,1516,3,217,1,9093.62,NULL,'2022-12-22 20:54:46','2022-12-22 20:54:46',NULL),(956,7705,245,40720,1516,3,68,1,1909.66,NULL,'2022-12-22 20:54:46','2022-12-22 20:54:46',NULL),(957,7705,245,40720,1516,3,224,1,898.66,NULL,'2022-12-22 20:54:46','2022-12-22 20:54:46',NULL),(958,7705,245,40720,1516,3,57,2,11901.94,NULL,'2022-12-22 20:54:46','2022-12-22 20:54:46',NULL),(959,7705,246,40720,1516,3,217,1,1490.62,NULL,'2022-12-26 21:27:27','2022-12-26 21:27:27',NULL),(960,7705,246,40720,1516,3,68,1,313.03,NULL,'2022-12-26 21:27:27','2022-12-26 21:27:27',NULL),(961,7705,246,40720,1516,3,224,1,196.45,NULL,'2022-12-26 21:27:27','2022-12-26 21:27:27',NULL),(962,7705,246,40720,1516,3,57,2,2000.10,NULL,'2022-12-26 21:27:27','2022-12-26 21:27:27',NULL),(963,7705,247,40720,1516,3,217,1,1493.20,NULL,'2022-12-26 21:28:20','2022-12-26 21:28:20',NULL),(964,7705,247,40720,1516,3,68,1,313.57,NULL,'2022-12-26 21:28:20','2022-12-26 21:28:20',NULL),(965,7705,247,40720,1516,3,224,1,195.16,NULL,'2022-12-26 21:28:20','2022-12-26 21:28:20',NULL),(966,7705,247,40720,1516,3,57,2,2001.93,NULL,'2022-12-26 21:28:20','2022-12-26 21:28:20',NULL),(967,7705,248,40720,1516,3,217,1,5997.29,NULL,'2022-12-26 21:29:08','2022-12-26 21:29:08',NULL),(968,7705,248,40720,1516,3,68,1,1259.43,NULL,'2022-12-26 21:29:08','2022-12-26 21:29:08',NULL),(969,7705,248,40720,1516,3,224,1,743.53,NULL,'2022-12-26 21:29:08','2022-12-26 21:29:08',NULL),(970,7705,248,40720,1516,3,57,2,8000.25,NULL,'2022-12-26 21:29:08','2022-12-26 21:29:08',NULL),(971,7705,249,40720,1516,3,217,1,3148.33,NULL,'2022-12-26 21:29:42','2022-12-26 21:29:42',NULL),(972,7705,249,40720,1516,3,68,1,661.15,NULL,'2022-12-26 21:29:42','2022-12-26 21:29:42',NULL),(973,7705,249,40720,1516,3,224,1,390.32,NULL,'2022-12-26 21:29:42','2022-12-26 21:29:42',NULL),(974,7705,249,40720,1516,3,57,2,4199.80,NULL,'2022-12-26 21:29:42','2022-12-26 21:29:42',NULL),(975,7705,250,40720,1516,3,217,1,1170.14,NULL,'2022-12-26 21:30:42','2022-12-26 21:30:42',NULL),(976,7705,250,40720,1516,3,68,1,245.73,NULL,'2022-12-26 21:30:42','2022-12-26 21:30:42',NULL),(977,7705,250,40720,1516,3,224,1,175.17,NULL,'2022-12-26 21:30:42','2022-12-26 21:30:42',NULL),(978,7705,250,40720,1516,3,57,2,1591.04,NULL,'2022-12-26 21:30:42','2022-12-26 21:30:42',NULL),(979,7705,251,40720,1516,3,217,1,7959.39,NULL,'2022-12-26 21:31:25','2022-12-26 21:31:25',NULL),(980,7705,251,40720,1516,3,68,1,1671.47,NULL,'2022-12-26 21:31:25','2022-12-26 21:31:25',NULL),(981,7705,251,40720,1516,3,224,1,710.82,NULL,'2022-12-26 21:31:25','2022-12-26 21:31:25',NULL),(982,7705,251,40720,1516,3,57,2,10341.68,NULL,'2022-12-26 21:31:25','2022-12-26 21:31:25',NULL),(983,7705,252,40720,1516,3,217,1,2235.93,NULL,'2022-12-26 21:32:11','2022-12-26 21:32:11',NULL),(984,7705,252,40720,1516,3,68,1,469.55,NULL,'2022-12-26 21:32:11','2022-12-26 21:32:11',NULL),(985,7705,252,40720,1516,3,224,1,294.67,NULL,'2022-12-26 21:32:11','2022-12-26 21:32:11',NULL),(986,7705,252,40720,1516,3,57,2,3000.15,NULL,'2022-12-26 21:32:11','2022-12-26 21:32:11',NULL),(987,7705,253,40720,1516,3,217,1,3726.57,NULL,'2022-12-26 21:32:38','2022-12-26 21:32:38',NULL),(988,7705,253,40720,1516,3,68,1,782.58,NULL,'2022-12-26 21:32:38','2022-12-26 21:32:38',NULL),(989,7705,253,40720,1516,3,224,1,491.12,NULL,'2022-12-26 21:32:38','2022-12-26 21:32:38',NULL),(990,7705,253,40720,1516,3,57,2,5000.27,NULL,'2022-12-26 21:32:38','2022-12-26 21:32:38',NULL),(991,7705,254,40720,1516,3,217,1,5217.20,NULL,'2022-12-26 21:33:25','2022-12-26 21:33:25',NULL);
INSERT INTO `balance_libro_details` VALUES (992,7705,254,40720,1516,3,68,1,1095.61,NULL,'2022-12-26 21:33:25','2022-12-26 21:33:25',NULL),(993,7705,254,40720,1516,3,224,1,687.57,NULL,'2022-12-26 21:33:25','2022-12-26 21:33:25',NULL),(994,7705,254,40720,1516,3,57,2,7000.38,NULL,'2022-12-26 21:33:25','2022-12-26 21:33:25',NULL),(995,7705,255,40720,1516,3,217,1,2883.93,NULL,'2022-12-26 21:34:29','2022-12-26 21:34:29',NULL),(996,7705,255,40720,1516,3,68,1,605.63,NULL,'2022-12-26 21:34:29','2022-12-26 21:34:29',NULL),(997,7705,255,40720,1516,3,224,1,710.46,NULL,'2022-12-26 21:34:29','2022-12-26 21:34:29',NULL),(998,7705,255,40720,1516,3,57,2,4200.02,NULL,'2022-12-26 21:34:29','2022-12-26 21:34:29',NULL),(999,7705,256,40720,1516,3,217,1,7681.98,NULL,'2022-12-26 21:35:14','2022-12-26 21:35:14',NULL),(1000,7705,256,40720,1516,3,68,1,1613.22,NULL,'2022-12-26 21:35:14','2022-12-26 21:35:14',NULL),(1001,7705,256,40720,1516,3,224,1,806.01,NULL,'2022-12-26 21:35:14','2022-12-26 21:35:14',NULL),(1002,7705,256,40720,1516,3,57,2,10101.21,NULL,'2022-12-26 21:35:14','2022-12-26 21:35:14',NULL),(1003,7705,257,40720,1516,3,217,1,8680.05,NULL,'2022-12-26 21:35:47','2022-12-26 21:35:47',NULL),(1004,7705,257,40720,1516,3,68,1,1822.81,NULL,'2022-12-26 21:35:47','2022-12-26 21:35:47',NULL),(1005,7705,257,40720,1516,3,224,1,1143.94,NULL,'2022-12-26 21:35:47','2022-12-26 21:35:47',NULL),(1006,7705,257,40720,1516,3,57,2,11646.80,NULL,'2022-12-26 21:35:47','2022-12-26 21:35:47',NULL),(1007,7705,258,40720,1516,3,217,1,2255.15,NULL,'2022-12-26 21:36:33','2022-12-26 21:36:33',NULL),(1008,7705,258,40720,1516,3,68,1,473.58,NULL,'2022-12-26 21:36:33','2022-12-26 21:36:33',NULL),(1009,7705,258,40720,1516,3,224,1,272.46,NULL,'2022-12-26 21:36:33','2022-12-26 21:36:33',NULL),(1010,7705,258,40720,1516,3,57,2,3001.19,NULL,'2022-12-26 21:36:33','2022-12-26 21:36:33',NULL),(1011,7705,259,40720,1516,3,217,1,7696.80,NULL,'2022-12-26 21:37:16','2022-12-26 21:37:16',NULL),(1012,7705,259,40720,1516,3,68,1,1616.33,NULL,'2022-12-26 21:37:16','2022-12-26 21:37:16',NULL),(1013,7705,259,40720,1516,3,224,1,687.37,NULL,'2022-12-26 21:37:16','2022-12-26 21:37:16',NULL),(1014,7705,259,40720,1516,3,57,2,10000.50,NULL,'2022-12-26 21:37:16','2022-12-26 21:37:16',NULL),(1015,7705,260,40720,1516,3,217,1,6888.60,NULL,'2022-12-26 21:37:49','2022-12-26 21:37:49',NULL),(1016,7705,260,40720,1516,3,68,1,1446.61,NULL,'2022-12-26 21:37:49','2022-12-26 21:37:49',NULL),(1017,7705,260,40720,1516,3,224,1,615.19,NULL,'2022-12-26 21:37:49','2022-12-26 21:37:49',NULL),(1018,7705,260,40720,1516,3,57,2,8950.40,NULL,'2022-12-26 21:37:49','2022-12-26 21:37:49',NULL),(1019,7705,261,40720,1516,3,217,1,14206.78,NULL,'2022-12-26 21:38:35','2022-12-26 21:38:35',NULL),(1020,7705,261,40720,1516,3,68,1,2983.42,NULL,'2022-12-26 21:38:35','2022-12-26 21:38:35',NULL),(1021,7705,261,40720,1516,3,224,1,1610.76,NULL,'2022-12-26 21:38:35','2022-12-26 21:38:35',NULL),(1022,7705,261,40720,1516,3,57,2,18800.96,NULL,'2022-12-26 21:38:35','2022-12-26 21:38:35',NULL),(1023,7705,262,40720,1516,3,217,1,1490.62,NULL,'2022-12-26 21:39:05','2022-12-26 21:39:05',NULL),(1024,7705,262,40720,1516,3,68,1,313.03,NULL,'2022-12-26 21:39:05','2022-12-26 21:39:05',NULL),(1025,7705,262,40720,1516,3,224,1,196.45,NULL,'2022-12-26 21:39:05','2022-12-26 21:39:05',NULL),(1026,7705,262,40720,1516,3,57,2,2000.10,NULL,'2022-12-26 21:39:05','2022-12-26 21:39:05',NULL),(1027,7705,263,40720,1516,3,217,1,10192.34,NULL,'2022-12-26 21:39:37','2022-12-26 21:39:37',NULL),(1028,7705,263,40720,1516,3,68,1,2140.39,NULL,'2022-12-26 21:39:37','2022-12-26 21:39:37',NULL),(1029,7705,263,40720,1516,3,224,1,1069.41,NULL,'2022-12-26 21:39:37','2022-12-26 21:39:37',NULL),(1030,7705,263,40720,1516,3,57,2,13402.14,NULL,'2022-12-26 21:39:37','2022-12-26 21:39:37',NULL),(1031,7705,264,40720,1516,3,217,1,2235.93,NULL,'2022-12-26 21:40:10','2022-12-26 21:40:10',NULL),(1032,7705,264,40720,1516,3,68,1,469.55,NULL,'2022-12-26 21:40:10','2022-12-26 21:40:10',NULL);
INSERT INTO `balance_libro_details` VALUES (1033,7705,264,40720,1516,3,224,1,294.67,NULL,'2022-12-26 21:40:10','2022-12-26 21:40:10',NULL),(1034,7705,264,40720,1516,3,57,2,3000.15,NULL,'2022-12-26 21:40:10','2022-12-26 21:40:10',NULL),(1035,7705,265,40720,1516,3,217,1,9224.10,NULL,'2022-12-26 21:40:38','2022-12-26 21:40:38',NULL),(1036,7705,265,40720,1516,3,68,1,1937.06,NULL,'2022-12-26 21:40:38','2022-12-26 21:40:38',NULL),(1037,7705,265,40720,1516,3,224,1,1052.16,NULL,'2022-12-26 21:40:38','2022-12-26 21:40:38',NULL),(1038,7705,265,40720,1516,3,57,2,12213.32,NULL,'2022-12-26 21:40:38','2022-12-26 21:40:38',NULL),(1039,7705,266,40720,1516,3,217,1,6926.33,NULL,'2022-12-26 21:41:17','2022-12-26 21:41:17',NULL),(1040,7705,266,40720,1516,3,68,1,1454.53,NULL,'2022-12-26 21:41:17','2022-12-26 21:41:17',NULL),(1041,7705,266,40720,1516,3,224,1,618.56,NULL,'2022-12-26 21:41:17','2022-12-26 21:41:17',NULL),(1042,7705,266,40720,1516,3,57,2,8999.42,NULL,'2022-12-26 21:41:17','2022-12-26 21:41:17',NULL),(1043,7705,267,40720,1516,3,217,1,8943.76,NULL,'2022-12-26 21:41:56','2022-12-26 21:41:56',NULL),(1044,7705,267,40720,1516,3,68,1,1878.19,NULL,'2022-12-26 21:41:56','2022-12-26 21:41:56',NULL),(1045,7705,267,40720,1516,3,224,1,1178.69,NULL,'2022-12-26 21:41:56','2022-12-26 21:41:56',NULL),(1046,7705,267,40720,1516,3,57,2,12000.64,NULL,'2022-12-26 21:41:56','2022-12-26 21:41:56',NULL),(1047,7705,268,40720,1516,3,217,1,10061.19,NULL,'2022-12-26 21:42:23','2022-12-26 21:42:23',NULL),(1048,7705,268,40720,1516,3,68,1,2112.85,NULL,'2022-12-26 21:42:23','2022-12-26 21:42:23',NULL),(1049,7705,268,40720,1516,3,224,1,1325.96,NULL,'2022-12-26 21:42:23','2022-12-26 21:42:23',NULL),(1050,7705,268,40720,1516,3,57,2,13500.00,NULL,'2022-12-26 21:42:23','2022-12-26 21:42:23',NULL),(1051,7705,269,40720,1516,3,217,1,2235.93,NULL,'2022-12-26 21:42:52','2022-12-26 21:42:52',NULL),(1052,7705,269,40720,1516,3,68,1,469.55,NULL,'2022-12-26 21:42:52','2022-12-26 21:42:52',NULL),(1053,7705,269,40720,1516,3,224,1,294.67,NULL,'2022-12-26 21:42:52','2022-12-26 21:42:52',NULL),(1054,7705,269,40720,1516,3,57,2,3000.15,NULL,'2022-12-26 21:42:52','2022-12-26 21:42:52',NULL),(1055,7705,270,40720,1516,3,217,1,11311.93,NULL,'2022-12-26 21:43:19','2022-12-26 21:43:19',NULL),(1056,7705,270,40720,1516,3,68,1,2375.51,NULL,'2022-12-26 21:43:19','2022-12-26 21:43:19',NULL),(1057,7705,270,40720,1516,3,224,1,1186.88,NULL,'2022-12-26 21:43:19','2022-12-26 21:43:19',NULL),(1058,7705,270,40720,1516,3,57,2,14874.32,NULL,'2022-12-26 21:43:19','2022-12-26 21:43:19',NULL),(1059,7705,271,40720,1516,3,217,1,1490.62,NULL,'2022-12-26 21:43:46','2022-12-26 21:43:46',NULL),(1060,7705,271,40720,1516,3,68,1,313.03,NULL,'2022-12-26 21:43:46','2022-12-26 21:43:46',NULL),(1061,7705,271,40720,1516,3,224,1,196.45,NULL,'2022-12-26 21:43:46','2022-12-26 21:43:46',NULL),(1062,7705,271,40720,1516,3,57,2,2000.10,NULL,'2022-12-26 21:43:46','2022-12-26 21:43:46',NULL),(1063,7705,272,40720,1516,3,217,1,1290.06,NULL,'2022-12-26 21:44:27','2022-12-26 21:44:27',NULL),(1064,7705,272,40720,1516,3,68,1,270.91,NULL,'2022-12-26 21:44:27','2022-12-26 21:44:27',NULL),(1065,7705,272,40720,1516,3,224,1,139.03,NULL,'2022-12-26 21:44:27','2022-12-26 21:44:27',NULL),(1066,7705,272,40720,1516,3,57,2,1700.00,NULL,'2022-12-26 21:44:27','2022-12-26 21:44:27',NULL),(1067,7705,273,40720,1516,3,217,1,1490.62,NULL,'2022-12-26 21:45:01','2022-12-26 21:45:01',NULL),(1068,7705,273,40720,1516,3,68,1,313.03,NULL,'2022-12-26 21:45:01','2022-12-26 21:45:01',NULL),(1069,7705,273,40720,1516,3,224,1,196.45,NULL,'2022-12-26 21:45:01','2022-12-26 21:45:01',NULL),(1070,7705,273,40720,1516,3,57,2,2000.10,NULL,'2022-12-26 21:45:01','2022-12-26 21:45:01',NULL),(1071,7705,274,40720,1516,3,217,1,3353.60,NULL,'2022-12-26 21:45:27','2022-12-26 21:45:27',NULL),(1072,7705,274,40720,1516,3,68,1,704.26,NULL,'2022-12-26 21:45:27','2022-12-26 21:45:27',NULL),(1073,7705,274,40720,1516,3,224,1,441.97,NULL,'2022-12-26 21:45:27','2022-12-26 21:45:27',NULL);
INSERT INTO `balance_libro_details` VALUES (1074,7705,274,40720,1516,3,57,2,4499.83,NULL,'2022-12-26 21:45:27','2022-12-26 21:45:27',NULL),(1075,7705,275,40720,1516,3,217,1,8198.43,NULL,'2022-12-26 21:45:59','2022-12-26 21:45:59',NULL),(1076,7705,275,40720,1516,3,68,1,1721.67,NULL,'2022-12-26 21:45:59','2022-12-26 21:45:59',NULL),(1077,7705,275,40720,1516,3,224,1,1080.47,NULL,'2022-12-26 21:45:59','2022-12-26 21:45:59',NULL),(1078,7705,275,40720,1516,3,57,2,11000.57,NULL,'2022-12-26 21:45:59','2022-12-26 21:45:59',NULL),(1079,7705,276,40720,1516,3,217,1,1167.62,NULL,'2022-12-26 21:47:13','2022-12-26 21:47:13',NULL),(1080,7705,276,40720,1516,3,68,1,245.20,NULL,'2022-12-26 21:47:13','2022-12-26 21:47:13',NULL),(1081,7705,276,40720,1516,3,224,1,287.65,NULL,'2022-12-26 21:47:13','2022-12-26 21:47:13',NULL),(1082,7705,276,40720,1516,3,57,2,1700.47,NULL,'2022-12-26 21:47:13','2022-12-26 21:47:13',NULL),(1083,7705,277,40720,1516,3,217,1,7303.67,NULL,'2022-12-26 21:47:56','2022-12-26 21:47:56',NULL),(1084,7705,277,40720,1516,3,68,1,1533.77,NULL,'2022-12-26 21:47:56','2022-12-26 21:47:56',NULL),(1085,7705,277,40720,1516,3,224,1,962.55,NULL,'2022-12-26 21:47:56','2022-12-26 21:47:56',NULL),(1086,7705,277,40720,1516,3,57,2,9799.99,NULL,'2022-12-26 21:47:56','2022-12-26 21:47:56',NULL),(1087,7705,278,40720,1516,3,217,1,378.75,NULL,'2022-12-26 21:49:18','2022-12-26 21:49:18',NULL),(1088,7705,278,40720,1516,3,68,1,79.54,NULL,'2022-12-26 21:49:18','2022-12-26 21:49:18',NULL),(1089,7705,278,40720,1516,3,224,1,41.63,NULL,'2022-12-26 21:49:18','2022-12-26 21:49:18',NULL),(1090,7705,278,40720,1516,3,57,2,499.92,NULL,'2022-12-26 21:49:18','2022-12-26 21:49:18',NULL),(1091,7705,279,40720,1516,3,217,1,7696.80,NULL,'2022-12-26 21:49:58','2022-12-26 21:49:58',NULL),(1092,7705,279,40720,1516,3,68,1,1616.33,NULL,'2022-12-26 21:49:58','2022-12-26 21:49:58',NULL),(1093,7705,279,40720,1516,3,224,1,687.37,NULL,'2022-12-26 21:49:58','2022-12-26 21:49:58',NULL),(1094,7705,279,40720,1516,3,57,2,10000.50,NULL,'2022-12-26 21:49:58','2022-12-26 21:49:58',NULL),(1095,7705,280,40720,1516,3,217,1,6734.50,NULL,'2022-12-26 21:50:28','2022-12-26 21:50:28',NULL),(1096,7705,280,40720,1516,3,68,1,1414.25,NULL,'2022-12-26 21:50:28','2022-12-26 21:50:28',NULL),(1097,7705,280,40720,1516,3,224,1,601.43,NULL,'2022-12-26 21:50:28','2022-12-26 21:50:28',NULL),(1098,7705,280,40720,1516,3,57,2,8750.17,NULL,'2022-12-26 21:50:28','2022-12-26 21:50:28',NULL),(1099,7705,280,40720,1516,3,136,2,0.01,NULL,'2022-12-26 21:50:28','2022-12-26 21:50:28',NULL),(1100,7705,281,40720,1516,3,217,1,7452.51,NULL,'2022-12-26 21:51:07','2022-12-26 21:51:07',NULL),(1101,7705,281,40720,1516,3,68,1,1565.03,NULL,'2022-12-26 21:51:07','2022-12-26 21:51:07',NULL),(1102,7705,281,40720,1516,3,224,1,982.16,NULL,'2022-12-26 21:51:07','2022-12-26 21:51:07',NULL),(1103,7705,281,40720,1516,3,57,2,9999.70,NULL,'2022-12-26 21:51:07','2022-12-26 21:51:07',NULL),(1104,7705,282,40720,1516,3,217,1,7303.67,NULL,'2022-12-26 21:51:37','2022-12-26 21:51:37',NULL),(1105,7705,282,40720,1516,3,68,1,1533.77,NULL,'2022-12-26 21:51:37','2022-12-26 21:51:37',NULL),(1106,7705,282,40720,1516,3,224,1,962.55,NULL,'2022-12-26 21:51:37','2022-12-26 21:51:37',NULL),(1107,7705,282,40720,1516,3,57,2,9799.99,NULL,'2022-12-26 21:51:37','2022-12-26 21:51:37',NULL),(1108,7705,283,40720,1516,3,217,1,3726.57,NULL,'2022-12-26 21:52:04','2022-12-26 21:52:04',NULL),(1109,7705,283,40720,1516,3,68,1,782.58,NULL,'2022-12-26 21:52:04','2022-12-26 21:52:04',NULL),(1110,7705,283,40720,1516,3,224,1,491.12,NULL,'2022-12-26 21:52:04','2022-12-26 21:52:04',NULL),(1111,7705,283,40720,1516,3,57,2,5000.27,NULL,'2022-12-26 21:52:04','2022-12-26 21:52:04',NULL),(1112,7705,284,40720,1516,3,217,1,3726.37,NULL,'2022-12-26 21:52:30','2022-12-26 21:52:30',NULL),(1113,7705,284,40720,1516,3,68,1,782.54,NULL,'2022-12-26 21:52:30','2022-12-26 21:52:30',NULL),(1114,7705,284,40720,1516,3,224,1,491.10,NULL,'2022-12-26 21:52:30','2022-12-26 21:52:30',NULL);
INSERT INTO `balance_libro_details` VALUES (1115,7705,284,40720,1516,3,57,2,5000.01,NULL,'2022-12-26 21:52:30','2022-12-26 21:52:30',NULL),(1116,7705,285,40720,1516,3,217,1,3876.48,NULL,'2022-12-26 21:53:42','2022-12-26 21:53:42',NULL),(1117,7705,285,40720,1516,3,68,1,814.06,NULL,'2022-12-26 21:53:42','2022-12-26 21:53:42',NULL),(1118,7705,285,40720,1516,3,57,2,4690.54,NULL,'2022-12-26 21:53:42','2022-12-26 21:53:42',NULL),(1119,7705,286,40720,1516,3,217,1,1940.20,NULL,'2022-12-26 21:54:05','2022-12-26 21:54:05',NULL),(1120,7705,286,40720,1516,3,68,1,407.44,NULL,'2022-12-26 21:54:05','2022-12-26 21:54:05',NULL),(1121,7705,286,40720,1516,3,57,2,2347.64,NULL,'2022-12-26 21:54:05','2022-12-26 21:54:05',NULL),(1122,7705,287,40720,1516,3,217,1,10200.00,NULL,'2022-12-26 21:56:04','2022-12-26 21:56:04',NULL),(1123,7705,287,40720,1516,3,68,1,2142.00,NULL,'2022-12-26 21:56:04','2022-12-26 21:56:04',NULL),(1124,7705,287,40720,1516,3,57,2,12342.00,NULL,'2022-12-26 21:56:04','2022-12-26 21:56:04',NULL),(1125,7705,288,40720,1516,3,217,1,768.60,NULL,'2022-12-26 21:57:20','2022-12-26 21:57:20',NULL),(1126,7705,288,40720,1516,3,68,1,161.41,NULL,'2022-12-26 21:57:20','2022-12-26 21:57:20',NULL),(1127,7705,288,40720,1516,3,57,2,930.01,NULL,'2022-12-26 21:57:20','2022-12-26 21:57:20',NULL),(1128,7705,289,40720,1516,3,217,1,1570.00,NULL,'2022-12-26 21:58:42','2022-12-26 21:58:42',NULL),(1129,7705,289,40720,1516,3,68,1,329.70,NULL,'2022-12-26 21:58:42','2022-12-26 21:58:42',NULL),(1130,7705,289,40720,1516,3,57,2,1899.70,NULL,'2022-12-26 21:58:42','2022-12-26 21:58:42',NULL),(1131,7705,290,40720,1516,3,217,1,727.27,NULL,'2022-12-26 22:09:09','2022-12-26 22:09:09',NULL),(1132,7705,290,40720,1516,3,68,1,152.73,NULL,'2022-12-26 22:09:09','2022-12-26 22:09:09',NULL),(1133,7705,290,40720,1516,3,217,1,350.00,NULL,'2022-12-26 22:09:09','2022-12-26 22:09:09',NULL),(1134,7705,290,40720,1516,3,57,2,1230.00,NULL,'2022-12-26 22:09:09','2022-12-26 22:09:09',NULL),(1135,7705,291,40720,1516,3,217,1,1239.56,NULL,'2022-12-26 22:12:36','2022-12-26 22:12:36',NULL),(1136,7705,291,40720,1516,3,68,1,260.31,NULL,'2022-12-26 22:12:36','2022-12-26 22:12:36',NULL),(1137,7705,291,40720,1516,3,57,2,1499.87,NULL,'2022-12-26 22:12:36','2022-12-26 22:12:36',NULL),(1138,7705,292,40720,1516,3,217,1,255000.00,NULL,'2022-12-26 22:14:42','2022-12-26 22:14:42',NULL),(1139,7705,292,40720,1516,3,68,1,53550.00,NULL,'2022-12-26 22:14:42','2022-12-26 22:14:42',NULL),(1140,7705,292,40720,1516,3,57,2,308550.00,NULL,'2022-12-26 22:14:42','2022-12-26 22:14:42',NULL),(1141,7705,293,40720,1516,2,96,2,125837.00,NULL,'2022-12-26 22:23:28','2022-12-26 22:23:28',NULL),(1142,7705,293,40720,1516,2,67,2,26425.77,NULL,'2022-12-26 22:23:28','2022-12-26 22:23:28',NULL),(1143,7705,293,40720,1516,2,13,1,152262.77,NULL,'2022-12-26 22:23:28','2022-12-26 22:23:28',NULL),(1144,7705,294,40720,1516,2,96,2,192605.00,NULL,'2022-12-26 22:24:02','2022-12-26 22:24:02',NULL),(1145,7705,294,40720,1516,2,67,2,40447.05,NULL,'2022-12-26 22:24:02','2022-12-26 22:24:02',NULL),(1146,7705,294,40720,1516,2,13,1,233052.05,NULL,'2022-12-26 22:24:02','2022-12-26 22:24:02',NULL),(1147,7705,295,40720,1516,2,96,2,194474.00,NULL,'2022-12-26 22:24:34','2022-12-26 22:24:34',NULL),(1148,7705,295,40720,1516,2,67,2,40839.54,NULL,'2022-12-26 22:24:34','2022-12-26 22:24:34',NULL),(1149,7705,295,40720,1516,2,13,1,235313.54,NULL,'2022-12-26 22:24:34','2022-12-26 22:24:34',NULL),(1150,7705,296,40720,1516,2,96,2,140288.00,NULL,'2022-12-26 22:25:03','2022-12-26 22:25:03',NULL),(1151,7705,296,40720,1516,2,67,2,29460.48,NULL,'2022-12-26 22:25:03','2022-12-26 22:25:03',NULL),(1152,7705,296,40720,1516,2,13,1,169748.48,NULL,'2022-12-26 22:25:03','2022-12-26 22:25:03',NULL),(1153,7705,297,40720,1516,2,96,1,9484.52,NULL,'2022-12-26 22:25:52','2022-12-26 22:25:52',NULL),(1154,7705,297,40720,1516,2,68,1,1991.75,NULL,'2022-12-26 22:25:52','2022-12-26 22:25:52',NULL),(1155,7705,297,40720,1516,2,13,2,11476.27,NULL,'2022-12-26 22:25:52','2022-12-26 22:25:52',NULL);
INSERT INTO `balance_libro_details` VALUES (1156,7705,298,40745,3030,3,217,1,4618.08,NULL,'2023-01-02 22:21:07','2023-01-02 22:21:07',NULL),(1157,7705,298,40745,3030,3,68,1,969.80,NULL,'2023-01-02 22:21:07','2023-01-02 22:21:07',NULL),(1158,7705,298,40745,3030,3,224,1,412.42,NULL,'2023-01-02 22:21:07','2023-01-02 22:21:07',NULL),(1159,7705,298,40745,3030,3,57,2,6000.30,NULL,'2023-01-02 22:21:07','2023-01-02 22:21:07',NULL),(1160,7705,299,40745,3030,3,217,1,1548.56,NULL,'2023-01-02 22:21:49','2023-01-02 22:21:49',NULL),(1161,7705,299,40745,3030,3,68,1,325.20,NULL,'2023-01-02 22:21:49','2023-01-02 22:21:49',NULL),(1162,7705,299,40745,3030,3,224,1,126.10,NULL,'2023-01-02 22:21:49','2023-01-02 22:21:49',NULL),(1163,7705,299,40745,3030,3,57,2,1999.86,NULL,'2023-01-02 22:21:49','2023-01-02 22:21:49',NULL),(1164,7705,300,40745,3030,3,217,1,3642.36,NULL,'2023-01-02 22:22:52','2023-01-02 22:22:52',NULL),(1165,7705,300,40745,3030,3,68,1,764.90,NULL,'2023-01-02 22:22:52','2023-01-02 22:22:52',NULL),(1166,7705,300,40745,3030,3,224,1,594.14,NULL,'2023-01-02 22:22:52','2023-01-02 22:22:52',NULL),(1167,7705,300,40745,3030,3,57,2,5001.40,NULL,'2023-01-02 22:22:52','2023-01-02 22:22:52',NULL),(1168,7705,301,40745,3030,3,217,1,59849.95,NULL,'2023-01-02 22:24:21','2023-01-02 22:24:21',NULL),(1169,7705,301,40745,3030,3,68,1,12568.49,NULL,'2023-01-02 22:24:21','2023-01-02 22:24:21',NULL),(1170,7705,301,40745,3030,3,224,1,7583.92,NULL,'2023-01-02 22:24:21','2023-01-02 22:24:21',NULL),(1171,7705,301,40745,3030,3,57,2,80002.36,NULL,'2023-01-02 22:24:21','2023-01-02 22:24:21',NULL),(1172,7705,302,40745,3030,3,217,1,4369.97,NULL,'2023-01-02 22:25:07','2023-01-02 22:25:07',NULL),(1173,7705,302,40745,3030,3,68,1,917.69,NULL,'2023-01-02 22:25:07','2023-01-02 22:25:07',NULL),(1174,7705,302,40745,3030,3,224,1,712.83,NULL,'2023-01-02 22:25:07','2023-01-02 22:25:07',NULL),(1175,7705,302,40745,3030,3,57,2,6000.49,NULL,'2023-01-02 22:25:07','2023-01-02 22:25:07',NULL),(1176,7705,303,40745,3030,3,217,1,4206.62,NULL,'2023-01-02 22:28:17','2023-01-02 22:28:17',NULL),(1177,7705,303,40745,3030,3,68,1,883.39,NULL,'2023-01-02 22:28:17','2023-01-02 22:28:17',NULL),(1178,7705,303,40745,3030,3,57,2,5090.01,NULL,'2023-01-02 22:28:17','2023-01-02 22:28:17',NULL),(1179,7705,304,40745,3030,3,217,1,4462.83,NULL,'2023-01-02 22:29:42','2023-01-02 22:29:42',NULL),(1180,7705,304,40745,3030,3,68,1,937.19,NULL,'2023-01-02 22:29:42','2023-01-02 22:29:42',NULL),(1181,7705,304,40745,3030,3,57,2,5400.02,NULL,'2023-01-02 22:29:42','2023-01-02 22:29:42',NULL),(1182,7705,305,40720,1516,15,67,1,137172.84,NULL,'2023-01-04 20:12:38','2023-01-04 20:12:38',NULL),(1183,7705,305,40720,1516,15,68,2,179741.98,NULL,'2023-01-04 20:12:38','2023-01-04 20:12:38',NULL),(1184,7705,305,40720,1516,15,353,1,42569.14,NULL,'2023-01-04 20:12:38','2023-01-04 20:12:38',NULL),(1185,7705,306,40720,1517,3,217,1,7343.85,NULL,'2023-01-16 10:25:27','2023-01-16 10:25:27',NULL),(1186,7705,306,40720,1517,3,68,1,1542.21,NULL,'2023-01-16 10:25:27','2023-01-16 10:25:27',NULL),(1187,7705,306,40720,1517,3,224,1,1114.26,NULL,'2023-01-16 10:25:27','2023-01-16 10:25:27',NULL),(1188,7705,306,40720,1517,3,57,2,10000.32,NULL,'2023-01-16 10:25:27','2023-01-16 10:25:27',NULL),(1189,7705,307,40720,1517,3,217,1,3528.92,NULL,'2023-01-16 11:05:37','2023-01-16 11:05:37',NULL),(1190,7705,307,40720,1517,3,68,1,741.07,NULL,'2023-01-16 11:05:37','2023-01-16 11:05:37',NULL),(1191,7705,307,40720,1517,3,57,2,4269.99,NULL,'2023-01-16 11:05:37','2023-01-16 11:05:37',NULL),(1192,7705,308,40720,1517,3,217,1,8268.56,NULL,'2023-01-16 11:06:58','2023-01-16 11:06:58',NULL),(1193,7705,308,40720,1517,3,68,1,1736.40,NULL,'2023-01-16 11:06:58','2023-01-16 11:06:58',NULL),(1194,7705,308,40720,1517,3,224,1,1495.48,NULL,'2023-01-16 11:06:58','2023-01-16 11:06:58',NULL),(1195,7705,308,40720,1517,3,57,2,11500.44,NULL,'2023-01-16 11:06:58','2023-01-16 11:06:58',NULL),(1196,7705,309,40720,1517,3,217,1,9111.07,NULL,'2023-01-16 11:09:34','2023-01-16 11:09:34',NULL);
INSERT INTO `balance_libro_details` VALUES (1197,7705,309,40720,1517,3,68,1,1913.32,NULL,'2023-01-16 11:09:34','2023-01-16 11:09:34',NULL),(1198,7705,309,40720,1517,3,224,1,975.98,NULL,'2023-01-16 11:09:34','2023-01-16 11:09:34',NULL),(1199,7705,309,40720,1517,3,57,2,12000.37,NULL,'2023-01-16 11:09:34','2023-01-16 11:09:34',NULL),(1200,7705,310,40720,1517,3,217,1,7825.48,NULL,'2023-01-16 11:10:33','2023-01-16 11:10:33',NULL),(1201,7705,310,40720,1517,3,68,1,1643.35,NULL,'2023-01-16 11:10:33','2023-01-16 11:10:33',NULL),(1202,7705,310,40720,1517,3,224,1,1031.32,NULL,'2023-01-16 11:10:33','2023-01-16 11:10:33',NULL),(1203,7705,310,40720,1517,3,57,2,10500.15,NULL,'2023-01-16 11:10:33','2023-01-16 11:10:33',NULL),(1204,7705,311,40720,1517,3,217,1,7452.74,NULL,'2023-01-16 11:11:36','2023-01-16 11:11:36',NULL),(1205,7705,311,40720,1517,3,68,1,1565.08,NULL,'2023-01-16 11:11:36','2023-01-16 11:11:36',NULL),(1206,7705,311,40720,1517,3,224,1,982.19,NULL,'2023-01-16 11:11:36','2023-01-16 11:11:36',NULL),(1207,7705,311,40720,1517,3,57,2,10000.01,NULL,'2023-01-16 11:11:36','2023-01-16 11:11:36',NULL),(1208,7705,312,40720,1517,3,217,1,5240.98,NULL,'2023-01-16 11:12:32','2023-01-16 11:12:32',NULL),(1209,7705,312,40720,1517,3,68,1,1100.61,NULL,'2023-01-16 11:12:32','2023-01-16 11:12:32',NULL),(1210,7705,312,40720,1517,3,224,1,658.38,NULL,'2023-01-16 11:12:32','2023-01-16 11:12:32',NULL),(1211,7705,312,40720,1517,3,57,2,6999.97,NULL,'2023-01-16 11:12:32','2023-01-16 11:12:32',NULL),(1212,7705,313,40720,1517,3,217,1,11187.50,NULL,'2023-01-16 11:13:52','2023-01-16 11:13:52',NULL),(1213,7705,313,40720,1517,3,68,1,2349.38,NULL,'2023-01-16 11:13:52','2023-01-16 11:13:52',NULL),(1214,7705,313,40720,1517,3,224,1,2265.22,NULL,'2023-01-16 11:13:52','2023-01-16 11:13:52',NULL),(1215,7705,313,40720,1517,3,57,2,15802.09,NULL,'2023-01-16 11:13:52','2023-01-16 11:13:52',NULL),(1216,7705,313,40720,1517,3,136,2,0.01,NULL,'2023-01-16 11:13:52','2023-01-16 11:13:52',NULL),(1217,7705,314,40720,1517,3,217,1,8288.52,NULL,'2023-01-16 11:14:30','2023-01-16 11:14:30',NULL),(1218,7705,314,40720,1517,3,68,1,1740.59,NULL,'2023-01-16 11:14:30','2023-01-16 11:14:30',NULL),(1219,7705,314,40720,1517,3,224,1,1970.89,NULL,'2023-01-16 11:14:30','2023-01-16 11:14:30',NULL),(1220,7705,314,40720,1517,3,57,2,12000.00,NULL,'2023-01-16 11:14:30','2023-01-16 11:14:30',NULL),(1221,7705,315,40720,1517,3,217,1,15486.00,NULL,'2023-01-16 11:15:30','2023-01-16 11:15:30',NULL),(1222,7705,315,40720,1517,3,68,1,3252.06,NULL,'2023-01-16 11:15:30','2023-01-16 11:15:30',NULL),(1223,7705,315,40720,1517,3,57,2,18738.06,NULL,'2023-01-16 11:15:30','2023-01-16 11:15:30',NULL),(1224,7705,316,40720,1517,3,217,1,18402.71,NULL,'2023-01-16 11:28:50','2023-01-16 11:28:50',NULL),(1225,7705,316,40720,1517,3,68,1,3864.57,NULL,'2023-01-16 11:28:50','2023-01-16 11:28:50',NULL),(1226,7705,316,40720,1517,3,217,1,33437.72,NULL,'2023-01-16 11:28:50','2023-01-16 11:28:50',NULL),(1227,7705,316,40720,1517,3,57,2,55705.00,NULL,'2023-01-16 11:28:50','2023-01-16 11:28:50',NULL),(1228,7705,317,40720,1517,3,217,1,2328.21,NULL,'2023-01-16 11:30:46','2023-01-16 11:30:46',NULL),(1229,7705,317,40720,1517,3,68,1,488.92,NULL,'2023-01-16 11:30:46','2023-01-16 11:30:46',NULL),(1230,7705,317,40720,1517,3,224,1,182.86,NULL,'2023-01-16 11:30:46','2023-01-16 11:30:46',NULL),(1231,7705,317,40720,1517,3,57,2,2999.99,NULL,'2023-01-16 11:30:46','2023-01-16 11:30:46',NULL),(1232,7705,318,40720,1517,3,217,1,940.00,NULL,'2023-01-16 11:32:31','2023-01-16 11:32:31',NULL),(1233,7705,318,40720,1517,3,68,1,197.40,NULL,'2023-01-16 11:32:31','2023-01-16 11:32:31',NULL),(1234,7705,318,40720,1517,3,57,2,1137.40,NULL,'2023-01-16 11:32:31','2023-01-16 11:32:31',NULL),(1235,7705,319,40720,1517,3,217,1,2892.56,NULL,'2023-01-16 11:34:06','2023-01-16 11:34:06',NULL),(1236,7705,319,40720,1517,3,68,1,607.44,NULL,'2023-01-16 11:34:06','2023-01-16 11:34:06',NULL),(1237,7705,319,40720,1517,3,57,2,3500.00,NULL,'2023-01-16 11:34:06','2023-01-16 11:34:06',NULL);
INSERT INTO `balance_libro_details` VALUES (1238,7705,320,40720,1517,3,217,1,2396.69,NULL,'2023-01-16 11:36:57','2023-01-16 11:36:57',NULL),(1239,7705,320,40720,1517,3,68,1,503.30,NULL,'2023-01-16 11:36:57','2023-01-16 11:36:57',NULL),(1240,7705,320,40720,1517,3,57,2,2899.99,NULL,'2023-01-16 11:36:57','2023-01-16 11:36:57',NULL),(1241,7705,321,40720,1517,3,217,1,2537.19,NULL,'2023-01-16 11:40:42','2023-01-17 09:02:01','2023-01-17 09:02:01'),(1242,7705,321,40720,1517,3,68,1,532.81,NULL,'2023-01-16 11:40:42','2023-01-17 09:02:01','2023-01-17 09:02:01'),(1243,7705,321,40720,1517,3,217,1,560.00,NULL,'2023-01-16 11:40:42','2023-01-17 09:02:01','2023-01-17 09:02:01'),(1244,7705,321,40720,1517,3,57,2,3630.00,NULL,'2023-01-16 11:40:42','2023-01-17 09:02:01','2023-01-17 09:02:01'),(1245,7705,322,40720,1517,3,217,1,13529.46,NULL,'2023-01-16 12:07:55','2023-01-16 12:07:55',NULL),(1246,7705,322,40720,1517,3,68,1,2841.19,NULL,'2023-01-16 12:07:55','2023-01-16 12:07:55',NULL),(1247,7705,322,40720,1517,3,224,1,1629.68,NULL,'2023-01-16 12:07:55','2023-01-16 12:07:55',NULL),(1248,7705,322,40720,1517,3,57,2,18000.33,NULL,'2023-01-16 12:07:55','2023-01-16 12:07:55',NULL),(1249,7705,323,40720,1517,3,217,1,14452.91,NULL,'2023-01-16 12:08:42','2023-01-16 12:08:42',NULL),(1250,7705,323,40720,1517,3,68,1,3035.11,NULL,'2023-01-16 12:08:42','2023-01-16 12:08:42',NULL),(1251,7705,323,40720,1517,3,224,1,1815.49,NULL,'2023-01-16 12:08:42','2023-01-16 12:08:42',NULL),(1252,7705,323,40720,1517,3,57,2,19303.51,NULL,'2023-01-16 12:08:42','2023-01-16 12:08:42',NULL),(1253,7705,324,40720,1517,3,217,1,11489.46,NULL,'2023-01-16 12:09:52','2023-01-16 12:09:52',NULL),(1254,7705,324,40720,1517,3,68,1,2412.79,NULL,'2023-01-16 12:09:52','2023-01-16 12:09:52',NULL),(1255,7705,324,40720,1517,3,224,1,1098.51,NULL,'2023-01-16 12:09:52','2023-01-16 12:09:52',NULL),(1256,7705,324,40720,1517,3,57,2,15000.76,NULL,'2023-01-16 12:09:52','2023-01-16 12:09:52',NULL),(1257,7705,325,40720,1517,3,217,1,9574.46,NULL,'2023-01-16 12:10:26','2023-01-16 12:10:26',NULL),(1258,7705,325,40720,1517,3,68,1,2010.64,NULL,'2023-01-16 12:10:26','2023-01-16 12:10:26',NULL),(1259,7705,325,40720,1517,3,224,1,915.41,NULL,'2023-01-16 12:10:26','2023-01-16 12:10:26',NULL),(1260,7705,325,40720,1517,3,57,2,12500.51,NULL,'2023-01-16 12:10:26','2023-01-16 12:10:26',NULL),(1261,7705,326,40720,1517,3,217,1,7365.91,NULL,'2023-01-16 12:10:52','2023-01-16 12:10:52',NULL),(1262,7705,326,40720,1517,3,68,1,1546.84,NULL,'2023-01-16 12:10:52','2023-01-16 12:10:52',NULL),(1263,7705,326,40720,1517,3,224,1,887.25,NULL,'2023-01-16 12:10:52','2023-01-16 12:10:52',NULL),(1264,7705,326,40720,1517,3,57,2,9800.00,NULL,'2023-01-16 12:10:52','2023-01-16 12:10:52',NULL),(1265,7705,327,40720,1517,3,217,1,6984.02,NULL,'2023-01-16 12:11:23','2023-01-16 12:11:23',NULL),(1266,7705,327,40720,1517,3,68,1,1466.64,NULL,'2023-01-16 12:11:23','2023-01-16 12:11:23',NULL),(1267,7705,327,40720,1517,3,224,1,1549.33,NULL,'2023-01-16 12:11:23','2023-01-16 12:11:23',NULL),(1268,7705,327,40720,1517,3,57,2,9999.99,NULL,'2023-01-16 12:11:23','2023-01-16 12:11:23',NULL),(1269,7705,328,40720,1517,3,217,1,8267.18,NULL,'2023-01-16 12:15:06','2023-01-16 12:15:06',NULL),(1270,7705,328,40720,1517,3,68,1,1736.11,NULL,'2023-01-16 12:15:06','2023-01-16 12:15:06',NULL),(1271,7705,328,40720,1517,3,224,1,995.82,NULL,'2023-01-16 12:15:06','2023-01-16 12:15:06',NULL),(1272,7705,328,40720,1517,3,57,2,10999.11,NULL,'2023-01-16 12:15:06','2023-01-16 12:15:06',NULL),(1273,7705,329,40720,1517,3,217,1,6604.44,NULL,'2023-01-16 12:15:36','2023-01-16 12:15:36',NULL),(1274,7705,329,40720,1517,3,68,1,1386.93,NULL,'2023-01-16 12:15:36','2023-01-16 12:15:36',NULL),(1275,7705,329,40720,1517,3,224,1,1007.95,NULL,'2023-01-16 12:15:36','2023-01-16 12:15:36',NULL),(1276,7705,329,40720,1517,3,57,2,8999.32,NULL,'2023-01-16 12:15:36','2023-01-16 12:15:36',NULL),(1277,7705,330,40720,1517,3,217,1,2640.69,NULL,'2023-01-16 12:17:11','2023-01-16 12:17:11',NULL);
INSERT INTO `balance_libro_details` VALUES (1278,7705,330,40720,1517,3,68,1,554.54,NULL,'2023-01-16 12:17:11','2023-01-16 12:17:11',NULL),(1279,7705,330,40720,1517,3,224,1,606.89,NULL,'2023-01-16 12:17:11','2023-01-16 12:17:11',NULL),(1280,7705,330,40720,1517,3,57,2,3802.12,NULL,'2023-01-16 12:17:11','2023-01-16 12:17:11',NULL),(1281,7705,331,40720,1517,3,217,1,3446.75,NULL,'2023-01-16 12:17:46','2023-01-16 12:17:46',NULL),(1282,7705,331,40720,1517,3,68,1,723.82,NULL,'2023-01-16 12:17:46','2023-01-16 12:17:46',NULL),(1283,7705,331,40720,1517,3,224,1,329.54,NULL,'2023-01-16 12:17:46','2023-01-16 12:17:46',NULL),(1284,7705,331,40720,1517,3,57,2,4500.11,NULL,'2023-01-16 12:17:46','2023-01-16 12:17:46',NULL),(1285,7705,332,40720,1517,3,217,1,1503.12,NULL,'2023-01-16 12:18:16','2023-01-16 12:18:16',NULL),(1286,7705,332,40720,1517,3,68,1,315.66,NULL,'2023-01-16 12:18:16','2023-01-16 12:18:16',NULL),(1287,7705,332,40720,1517,3,224,1,181.06,NULL,'2023-01-16 12:18:16','2023-01-16 12:18:16',NULL),(1288,7705,332,40720,1517,3,57,2,1999.84,NULL,'2023-01-16 12:18:16','2023-01-16 12:18:16',NULL),(1289,7705,333,40720,1517,3,217,1,8877.95,NULL,'2023-01-16 12:18:47','2023-01-16 12:18:47',NULL),(1290,7705,333,40720,1517,3,68,1,1864.37,NULL,'2023-01-16 12:18:47','2023-01-16 12:18:47',NULL),(1291,7705,333,40720,1517,3,224,1,1257.46,NULL,'2023-01-16 12:18:47','2023-01-16 12:18:47',NULL),(1292,7705,333,40720,1517,3,57,2,11999.78,NULL,'2023-01-16 12:18:47','2023-01-16 12:18:47',NULL),(1293,7705,334,40720,1517,3,217,1,1514.69,NULL,'2023-01-16 12:19:41','2023-01-16 12:19:41',NULL),(1294,7705,334,40720,1517,3,68,1,318.08,NULL,'2023-01-16 12:19:41','2023-01-16 12:19:41',NULL),(1295,7705,334,40720,1517,3,224,1,167.41,NULL,'2023-01-16 12:19:41','2023-01-16 12:19:41',NULL),(1296,7705,334,40720,1517,3,57,2,2000.18,NULL,'2023-01-16 12:19:41','2023-01-16 12:19:41',NULL),(1297,7705,335,40720,1517,3,217,1,1481.53,NULL,'2023-01-16 12:20:56','2023-01-16 12:20:56',NULL),(1298,7705,335,40720,1517,3,68,1,311.12,NULL,'2023-01-16 12:20:56','2023-01-16 12:20:56',NULL),(1299,7705,335,40720,1517,3,224,1,207.29,NULL,'2023-01-16 12:20:56','2023-01-16 12:20:56',NULL),(1300,7705,335,40720,1517,3,57,2,1999.94,NULL,'2023-01-16 12:20:56','2023-01-16 12:20:56',NULL),(1301,7705,336,40720,1517,3,217,1,3006.25,NULL,'2023-01-16 12:21:36','2023-01-16 12:21:36',NULL),(1302,7705,336,40720,1517,3,68,1,631.31,NULL,'2023-01-16 12:21:36','2023-01-16 12:21:36',NULL),(1303,7705,336,40720,1517,3,224,1,362.11,NULL,'2023-01-16 12:21:36','2023-01-16 12:21:36',NULL),(1304,7705,336,40720,1517,3,57,2,3999.67,NULL,'2023-01-16 12:21:36','2023-01-16 12:21:36',NULL),(1305,7705,337,40720,1517,3,217,1,2555.60,NULL,'2023-01-16 12:22:09','2023-01-16 12:22:09',NULL),(1306,7705,337,40720,1517,3,68,1,536.68,NULL,'2023-01-16 12:22:09','2023-01-16 12:22:09',NULL),(1307,7705,337,40720,1517,3,224,1,307.83,NULL,'2023-01-16 12:22:09','2023-01-16 12:22:09',NULL),(1308,7705,337,40720,1517,3,57,2,3400.11,NULL,'2023-01-16 12:22:09','2023-01-16 12:22:09',NULL),(1309,7705,338,40720,1517,3,217,1,5304.14,NULL,'2023-01-16 12:22:37','2023-01-16 12:22:37',NULL),(1310,7705,338,40720,1517,3,68,1,1113.87,NULL,'2023-01-16 12:22:37','2023-01-16 12:22:37',NULL),(1311,7705,338,40720,1517,3,224,1,581.81,NULL,'2023-01-16 12:22:37','2023-01-16 12:22:37',NULL),(1312,7705,338,40720,1517,3,57,2,6999.82,NULL,'2023-01-16 12:22:37','2023-01-16 12:22:37',NULL),(1313,7705,339,40720,1517,3,217,1,1503.21,NULL,'2023-01-16 12:23:16','2023-01-16 12:23:16',NULL),(1314,7705,339,40720,1517,3,68,1,315.67,NULL,'2023-01-16 12:23:16','2023-01-16 12:23:16',NULL),(1315,7705,339,40720,1517,3,224,1,181.12,NULL,'2023-01-16 12:23:16','2023-01-16 12:23:16',NULL),(1316,7705,339,40720,1517,3,57,2,2000.00,NULL,'2023-01-16 12:23:16','2023-01-16 12:23:16',NULL),(1317,7705,340,40720,1517,3,217,1,9131.42,NULL,'2023-01-16 12:24:07','2023-01-16 12:24:07',NULL),(1318,7705,340,40720,1517,3,68,1,1917.60,NULL,'2023-01-16 12:24:07','2023-01-16 12:24:07',NULL);
INSERT INTO `balance_libro_details` VALUES (1319,7705,340,40720,1517,3,224,1,1099.91,NULL,'2023-01-16 12:24:07','2023-01-16 12:24:07',NULL),(1320,7705,340,40720,1517,3,57,2,12148.93,NULL,'2023-01-16 12:24:07','2023-01-16 12:24:07',NULL),(1321,7705,341,40720,1517,3,217,1,7892.04,NULL,'2023-01-16 12:24:49','2023-01-16 12:24:49',NULL),(1322,7705,341,40720,1517,3,68,1,1657.33,NULL,'2023-01-16 12:24:49','2023-01-16 12:24:49',NULL),(1323,7705,341,40720,1517,3,224,1,950.63,NULL,'2023-01-16 12:24:49','2023-01-16 12:24:49',NULL),(1324,7705,341,40720,1517,3,57,2,10500.00,NULL,'2023-01-16 12:24:49','2023-01-16 12:24:49',NULL),(1325,7705,342,40720,1517,3,217,1,1514.69,NULL,'2023-01-16 12:25:37','2023-01-16 12:25:37',NULL),(1326,7705,342,40720,1517,3,68,1,318.08,NULL,'2023-01-16 12:25:37','2023-01-16 12:25:37',NULL),(1327,7705,342,40720,1517,3,224,1,167.41,NULL,'2023-01-16 12:25:37','2023-01-16 12:25:37',NULL),(1328,7705,342,40720,1517,3,57,2,2000.18,NULL,'2023-01-16 12:25:37','2023-01-16 12:25:37',NULL),(1329,7705,343,40720,1517,3,217,1,8277.72,NULL,'2023-01-16 12:27:35','2023-01-16 12:27:35',NULL),(1330,7705,343,40720,1517,3,68,1,1738.32,NULL,'2023-01-16 12:27:35','2023-01-16 12:27:35',NULL),(1331,7705,343,40720,1517,3,224,1,1683.94,NULL,'2023-01-16 12:27:35','2023-01-16 12:27:35',NULL),(1332,7705,343,40720,1517,3,57,2,11699.98,NULL,'2023-01-16 12:27:35','2023-01-16 12:27:35',NULL),(1333,7705,344,40720,1517,3,217,1,10179.42,NULL,'2023-01-16 12:28:04','2023-01-16 12:28:04',NULL),(1334,7705,344,40720,1517,3,68,1,2137.68,NULL,'2023-01-16 12:28:04','2023-01-16 12:28:04',NULL),(1335,7705,344,40720,1517,3,224,1,973.26,NULL,'2023-01-16 12:28:04','2023-01-16 12:28:04',NULL),(1336,7705,344,40720,1517,3,57,2,13290.36,NULL,'2023-01-16 12:28:04','2023-01-16 12:28:04',NULL),(1337,7705,345,40720,1517,3,217,1,3757.80,NULL,'2023-01-16 12:28:40','2023-01-16 12:28:40',NULL),(1338,7705,345,40720,1517,3,68,1,789.14,NULL,'2023-01-16 12:28:40','2023-01-16 12:28:40',NULL),(1339,7705,345,40720,1517,3,224,1,452.65,NULL,'2023-01-16 12:28:40','2023-01-16 12:28:40',NULL),(1340,7705,345,40720,1517,3,57,2,4999.59,NULL,'2023-01-16 12:28:40','2023-01-16 12:28:40',NULL),(1341,7705,346,40720,1517,2,96,2,3757.80,NULL,'2023-01-16 16:28:57','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1342,7705,346,40720,1517,2,67,2,789.14,NULL,'2023-01-16 16:28:57','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1343,7705,346,40720,1517,2,224,2,452.65,NULL,'2023-01-16 16:28:57','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1344,7705,346,40720,1517,2,13,1,4999.59,NULL,'2023-01-16 16:28:57','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1345,7705,347,40720,1517,2,96,2,1514.69,NULL,'2023-01-16 16:29:42','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1346,7705,347,40720,1517,2,67,2,318.08,NULL,'2023-01-16 16:29:42','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1347,7705,347,40720,1517,2,224,2,167.41,NULL,'2023-01-16 16:29:42','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1348,7705,347,40720,1517,2,13,1,2000.18,NULL,'2023-01-16 16:29:42','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1349,7705,348,40720,1517,2,96,2,3006.25,NULL,'2023-01-16 16:30:45','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1350,7705,348,40720,1517,2,67,2,631.31,NULL,'2023-01-16 16:30:45','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1351,7705,348,40720,1517,2,224,2,362.11,NULL,'2023-01-16 16:30:45','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1352,7705,348,40720,1517,2,13,1,3999.67,NULL,'2023-01-16 16:30:45','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1353,7705,349,40720,1517,2,96,2,8666.59,NULL,'2023-01-16 16:31:27','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1354,7705,349,40720,1517,2,67,2,1819.98,NULL,'2023-01-16 16:31:27','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1355,7705,349,40720,1517,2,224,2,1513.00,NULL,'2023-01-16 16:31:27','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1356,7705,349,40720,1517,2,13,1,11999.57,NULL,'2023-01-16 16:31:27','2023-01-16 17:59:19','2023-01-16 17:59:19');
INSERT INTO `balance_libro_details` VALUES (1357,7705,350,40720,1517,2,96,2,8963.63,NULL,'2023-01-16 16:32:03','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1358,7705,350,40720,1517,2,67,2,1882.36,NULL,'2023-01-16 16:32:03','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1359,7705,350,40720,1517,2,224,2,1455.10,NULL,'2023-01-16 16:32:03','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1360,7705,350,40720,1517,2,13,1,12301.09,NULL,'2023-01-16 16:32:03','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1361,7705,351,40720,1517,2,96,2,13490.15,NULL,'2023-01-16 16:32:39','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1362,7705,351,40720,1517,2,67,2,2832.93,NULL,'2023-01-16 16:32:39','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1363,7705,351,40720,1517,2,224,2,1476.50,NULL,'2023-01-16 16:32:39','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1364,7705,351,40720,1517,2,13,1,17799.58,NULL,'2023-01-16 16:32:39','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1365,7705,352,40720,1517,2,96,2,9395.29,NULL,'2023-01-16 16:33:15','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1366,7705,352,40720,1517,2,67,2,1973.01,NULL,'2023-01-16 16:33:15','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1367,7705,352,40720,1517,2,224,2,1131.70,NULL,'2023-01-16 16:33:15','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1368,7705,352,40720,1517,2,13,1,12500.00,NULL,'2023-01-16 16:33:15','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1369,7705,353,40720,1517,2,96,2,11650.15,NULL,'2023-01-16 16:33:54','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1370,7705,353,40720,1517,2,67,2,2446.53,NULL,'2023-01-16 16:33:54','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1371,7705,353,40720,1517,2,224,2,1403.31,NULL,'2023-01-16 16:33:54','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1372,7705,353,40720,1517,2,13,1,15499.99,NULL,'2023-01-16 16:33:54','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1373,7705,354,40720,1517,2,96,2,9399.44,NULL,'2023-01-16 16:34:37','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1374,7705,354,40720,1517,2,67,2,1973.88,NULL,'2023-01-16 16:34:37','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1375,7705,354,40720,1517,2,224,2,1827.92,NULL,'2023-01-16 16:34:37','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1376,7705,354,40720,1517,2,13,1,13201.24,NULL,'2023-01-16 16:34:37','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1377,7705,355,40720,1517,2,96,2,14280.39,NULL,'2023-01-16 16:35:18','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1378,7705,355,40720,1517,2,67,2,2998.88,NULL,'2023-01-16 16:35:18','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1379,7705,355,40720,1517,2,224,2,1720.12,NULL,'2023-01-16 16:35:18','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1380,7705,355,40720,1517,2,13,1,18999.39,NULL,'2023-01-16 16:35:18','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1381,7705,356,40720,1517,2,96,2,11299.17,NULL,'2023-01-16 16:35:58','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1382,7705,356,40720,1517,2,67,2,2372.83,NULL,'2023-01-16 16:35:58','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1383,7705,356,40720,1517,2,224,2,2331.92,NULL,'2023-01-16 16:35:58','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1384,7705,356,40720,1517,2,13,1,16003.92,NULL,'2023-01-16 16:35:58','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1385,7705,357,40720,1517,2,96,2,1503.12,NULL,'2023-01-16 16:36:40','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1386,7705,357,40720,1517,2,67,2,315.66,NULL,'2023-01-16 16:36:40','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1387,7705,357,40720,1517,2,224,2,181.06,NULL,'2023-01-16 16:36:40','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1388,7705,357,40720,1517,2,13,1,1999.84,NULL,'2023-01-16 16:36:40','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1389,7705,358,40720,1517,2,96,2,14240.68,NULL,'2023-01-16 16:37:35','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1390,7705,358,40720,1517,2,67,2,2990.54,NULL,'2023-01-16 16:37:35','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1391,7705,358,40720,1517,2,224,2,2069.36,NULL,'2023-01-16 16:37:35','2023-01-16 17:59:19','2023-01-16 17:59:19');
INSERT INTO `balance_libro_details` VALUES (1392,7705,358,40720,1517,2,13,1,19300.58,NULL,'2023-01-16 16:37:35','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1393,7705,359,40720,1517,2,96,2,12025.68,NULL,'2023-01-16 16:43:56','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1394,7705,359,40720,1517,2,67,2,2525.39,NULL,'2023-01-16 16:43:56','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1395,7705,359,40720,1517,2,224,2,1448.55,NULL,'2023-01-16 16:43:56','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1396,7705,359,40720,1517,2,13,1,15999.62,NULL,'2023-01-16 16:43:56','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1397,7705,360,40720,1517,2,96,2,9244.96,NULL,'2023-01-16 16:44:48','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1398,7705,360,40720,1517,2,67,2,1941.44,NULL,'2023-01-16 16:44:48','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1399,7705,360,40720,1517,2,224,2,1113.59,NULL,'2023-01-16 16:44:48','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1400,7705,360,40720,1517,2,13,1,12299.99,NULL,'2023-01-16 16:44:48','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1401,7705,361,40720,1517,2,96,2,3614.00,NULL,'2023-01-16 16:45:19','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1402,7705,361,40720,1517,2,67,2,758.94,NULL,'2023-01-16 16:45:19','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1403,7705,361,40720,1517,2,224,2,627.06,NULL,'2023-01-16 16:45:19','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1404,7705,361,40720,1517,2,13,1,5000.00,NULL,'2023-01-16 16:45:19','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1405,7705,362,40720,1517,2,96,2,5640.05,NULL,'2023-01-16 16:45:50','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1406,7705,362,40720,1517,2,67,2,1184.41,NULL,'2023-01-16 16:45:50','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1407,7705,362,40720,1517,2,224,2,978.60,NULL,'2023-01-16 16:45:50','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1408,7705,362,40720,1517,2,13,1,7803.06,NULL,'2023-01-16 16:45:50','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1409,7705,363,40720,1517,2,96,2,1514.69,NULL,'2023-01-16 16:46:35','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1410,7705,363,40720,1517,2,67,2,318.08,NULL,'2023-01-16 16:46:35','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1411,7705,363,40720,1517,2,224,2,167.41,NULL,'2023-01-16 16:46:35','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1412,7705,363,40720,1517,2,13,1,2000.18,NULL,'2023-01-16 16:46:35','2023-01-16 17:59:19','2023-01-16 17:59:19'),(1413,7705,364,40720,1517,2,96,2,3006.25,NULL,'2023-01-16 16:47:17','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1414,7705,364,40720,1517,2,67,2,631.31,NULL,'2023-01-16 16:47:17','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1415,7705,364,40720,1517,2,224,2,362.11,NULL,'2023-01-16 16:47:17','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1416,7705,364,40720,1517,2,13,1,3999.67,NULL,'2023-01-16 16:47:17','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1417,7705,365,40720,1517,2,96,2,5853.46,NULL,'2023-01-16 16:48:02','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1418,7705,365,40720,1517,2,67,2,1229.23,NULL,'2023-01-16 16:48:02','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1419,7705,365,40720,1517,2,224,2,917.54,NULL,'2023-01-16 16:48:02','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1420,7705,365,40720,1517,2,13,1,8000.23,NULL,'2023-01-16 16:48:02','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1421,7705,366,40720,1517,2,96,2,751.56,NULL,'2023-01-16 16:52:45','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1422,7705,366,40720,1517,2,67,2,157.83,NULL,'2023-01-16 16:52:45','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1423,7705,366,40720,1517,2,224,2,90.53,NULL,'2023-01-16 16:52:45','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1424,7705,366,40720,1517,2,13,1,999.92,NULL,'2023-01-16 16:52:45','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1425,7705,367,40720,1517,2,96,2,2254.86,NULL,'2023-01-16 16:53:42','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1426,7705,367,40720,1517,2,67,2,473.52,NULL,'2023-01-16 16:53:42','2023-01-16 17:59:20','2023-01-16 17:59:20');
INSERT INTO `balance_libro_details` VALUES (1427,7705,367,40720,1517,2,224,2,271.61,NULL,'2023-01-16 16:53:42','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1428,7705,367,40720,1517,2,13,1,2999.99,NULL,'2023-01-16 16:53:42','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1429,7705,368,40720,1517,2,96,2,3223.14,NULL,'2023-01-16 16:55:27','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1430,7705,368,40720,1517,2,67,2,676.86,NULL,'2023-01-16 16:55:27','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1431,7705,368,40720,1517,2,13,1,3900.00,NULL,'2023-01-16 16:55:27','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1432,7705,369,40720,1517,2,96,2,4297.52,NULL,'2023-01-16 16:56:18','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1433,7705,369,40720,1517,2,67,2,902.48,NULL,'2023-01-16 16:56:18','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1434,7705,369,40720,1517,2,13,1,5200.00,NULL,'2023-01-16 16:56:18','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1435,7705,370,40720,1517,2,96,2,757.34,NULL,'2023-01-16 16:57:29','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1436,7705,370,40720,1517,2,67,2,159.04,NULL,'2023-01-16 16:57:29','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1437,7705,370,40720,1517,2,224,2,83.70,NULL,'2023-01-16 16:57:30','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1438,7705,370,40720,1517,2,13,1,1000.08,NULL,'2023-01-16 16:57:30','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1439,7705,371,40720,1517,2,96,2,19149.08,NULL,'2023-01-16 16:58:26','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1440,7705,371,40720,1517,2,67,2,4021.31,NULL,'2023-01-16 16:58:26','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1441,7705,371,40720,1517,2,224,2,1830.85,NULL,'2023-01-16 16:58:26','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1442,7705,371,40720,1517,2,13,1,25001.24,NULL,'2023-01-16 16:58:26','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1443,7705,372,40720,1517,2,96,2,14656.44,NULL,'2023-01-16 16:59:15','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1444,7705,372,40720,1517,2,67,2,3077.85,NULL,'2023-01-16 16:59:15','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1445,7705,372,40720,1517,2,224,2,1765.43,NULL,'2023-01-16 16:59:15','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1446,7705,372,40720,1517,2,13,1,19499.72,NULL,'2023-01-16 16:59:15','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1447,7705,373,40720,1517,2,96,2,7271.53,NULL,'2023-01-16 17:00:02','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1448,7705,373,40720,1517,2,67,2,1527.02,NULL,'2023-01-16 17:00:02','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1449,7705,373,40720,1517,2,224,2,1002.93,NULL,'2023-01-16 17:00:02','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1450,7705,373,40720,1517,2,13,1,9801.48,NULL,'2023-01-16 17:00:02','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1451,7705,374,40720,1517,2,96,2,12272.09,NULL,'2023-01-16 17:00:44','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1452,7705,374,40720,1517,2,67,2,2577.14,NULL,'2023-01-16 17:00:44','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1453,7705,374,40720,1517,2,224,2,1402.11,NULL,'2023-01-16 17:00:44','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1454,7705,374,40720,1517,2,13,1,16251.34,NULL,'2023-01-16 17:00:44','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1455,7705,375,40720,1517,2,96,2,1503.12,NULL,'2023-01-16 17:02:45','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1456,7705,375,40720,1517,2,67,2,315.66,NULL,'2023-01-16 17:02:45','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1457,7705,375,40720,1517,2,224,2,181.06,NULL,'2023-01-16 17:02:45','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1458,7705,375,40720,1517,2,13,1,1999.84,NULL,'2023-01-16 17:02:45','2023-01-16 17:59:20','2023-01-16 17:59:20'),(1459,7705,376,40720,1517,2,96,2,14093.72,NULL,'2023-01-16 17:03:39','2023-01-16 17:58:59','2023-01-16 17:58:59'),(1460,7705,376,40720,1517,2,67,2,2959.68,NULL,'2023-01-16 17:03:39','2023-01-16 17:58:59','2023-01-16 17:58:59'),(1461,7705,376,40720,1517,2,224,2,1347.50,NULL,'2023-01-16 17:03:39','2023-01-16 17:58:59','2023-01-16 17:58:59');
INSERT INTO `balance_libro_details` VALUES (1462,7705,376,40720,1517,2,13,1,18400.90,NULL,'2023-01-16 17:03:39','2023-01-16 17:58:59','2023-01-16 17:58:59'),(1463,7705,377,40720,1517,2,96,2,15517.00,NULL,'2023-01-16 17:04:23','2023-01-16 17:58:54','2023-01-16 17:58:54'),(1464,7705,377,40720,1517,2,67,2,3258.57,NULL,'2023-01-16 17:04:23','2023-01-16 17:58:54','2023-01-16 17:58:54'),(1465,7705,377,40720,1517,2,224,2,1924.35,NULL,'2023-01-16 17:04:23','2023-01-16 17:58:54','2023-01-16 17:58:54'),(1466,7705,377,40720,1517,2,13,1,20699.92,NULL,'2023-01-16 17:04:23','2023-01-16 17:58:54','2023-01-16 17:58:54'),(1467,7705,378,40720,1517,2,96,2,3959.36,NULL,'2023-01-16 17:05:24','2023-01-16 17:58:49','2023-01-16 17:58:49'),(1468,7705,378,40720,1517,2,67,2,831.47,NULL,'2023-01-16 17:05:24','2023-01-16 17:58:49','2023-01-16 17:58:49'),(1469,7705,378,40720,1517,2,224,2,909.94,NULL,'2023-01-16 17:05:24','2023-01-16 17:58:49','2023-01-16 17:58:49'),(1470,7705,378,40720,1517,2,13,1,5700.77,NULL,'2023-01-16 17:05:24','2023-01-16 17:58:49','2023-01-16 17:58:49'),(1471,7705,379,40720,1517,2,96,2,15454.55,NULL,'2023-01-16 17:09:55','2023-01-16 17:58:43','2023-01-16 17:58:43'),(1472,7705,379,40720,1517,2,67,2,3245.46,NULL,'2023-01-16 17:09:55','2023-01-16 17:58:43','2023-01-16 17:58:43'),(1473,7705,379,40720,1517,2,13,1,18700.01,NULL,'2023-01-16 17:09:55','2023-01-16 17:58:43','2023-01-16 17:58:43'),(1474,7705,380,40720,1517,2,96,2,10340.00,NULL,'2023-01-16 17:10:42','2023-01-16 17:58:37','2023-01-16 17:58:37'),(1475,7705,380,40720,1517,2,67,2,2171.40,NULL,'2023-01-16 17:10:42','2023-01-16 17:58:37','2023-01-16 17:58:37'),(1476,7705,380,40720,1517,2,224,2,988.61,NULL,'2023-01-16 17:10:42','2023-01-16 17:58:37','2023-01-16 17:58:37'),(1477,7705,380,40720,1517,2,13,1,13500.01,NULL,'2023-01-16 17:10:42','2023-01-16 17:58:37','2023-01-16 17:58:37'),(1478,7705,381,40720,1517,2,96,2,9395.29,NULL,'2023-01-16 17:11:27','2023-01-16 17:58:32','2023-01-16 17:58:32'),(1479,7705,381,40720,1517,2,67,2,1973.01,NULL,'2023-01-16 17:11:27','2023-01-16 17:58:32','2023-01-16 17:58:32'),(1480,7705,381,40720,1517,2,224,2,1131.70,NULL,'2023-01-16 17:11:27','2023-01-16 17:58:32','2023-01-16 17:58:32'),(1481,7705,381,40720,1517,2,13,1,12500.00,NULL,'2023-01-16 17:11:27','2023-01-16 17:58:32','2023-01-16 17:58:32'),(1482,7705,382,40720,1517,2,96,2,3006.25,NULL,'2023-01-16 17:43:30','2023-01-16 17:58:27','2023-01-16 17:58:27'),(1483,7705,382,40720,1517,2,67,2,631.31,NULL,'2023-01-16 17:43:30','2023-01-16 17:58:27','2023-01-16 17:58:27'),(1484,7705,382,40720,1517,2,224,2,362.11,NULL,'2023-01-16 17:43:30','2023-01-16 17:58:27','2023-01-16 17:58:27'),(1485,7705,382,40720,1517,2,13,1,3999.67,NULL,'2023-01-16 17:43:30','2023-01-16 17:58:27','2023-01-16 17:58:27'),(1486,7705,383,40720,1517,2,96,2,9395.29,NULL,'2023-01-16 17:47:36','2023-01-16 17:58:14','2023-01-16 17:58:14'),(1487,7705,383,40720,1517,2,67,2,1973.01,NULL,'2023-01-16 17:47:36','2023-01-16 17:58:14','2023-01-16 17:58:14'),(1488,7705,383,40720,1517,2,224,2,1131.70,NULL,'2023-01-16 17:47:36','2023-01-16 17:58:14','2023-01-16 17:58:14'),(1489,7705,383,40720,1517,2,13,1,12500.00,NULL,'2023-01-16 17:47:36','2023-01-16 17:58:14','2023-01-16 17:58:14'),(1490,7705,384,40720,1517,2,96,2,1503.12,NULL,'2023-01-16 17:48:10','2023-01-16 17:58:08','2023-01-16 17:58:08'),(1491,7705,384,40720,1517,2,67,2,315.66,NULL,'2023-01-16 17:48:10','2023-01-16 17:58:08','2023-01-16 17:58:08'),(1492,7705,384,40720,1517,2,224,2,181.06,NULL,'2023-01-16 17:48:10','2023-01-16 17:58:08','2023-01-16 17:58:08'),(1493,7705,384,40720,1517,2,13,1,1999.84,NULL,'2023-01-16 17:48:10','2023-01-16 17:58:08','2023-01-16 17:58:08'),(1494,7705,385,40720,1517,2,96,2,10661.15,NULL,'2023-01-16 17:49:17','2023-01-16 17:58:03','2023-01-16 17:58:03'),(1495,7705,385,40720,1517,2,67,2,2238.84,NULL,'2023-01-16 17:49:17','2023-01-16 17:58:03','2023-01-16 17:58:03'),(1496,7705,385,40720,1517,2,224,2,1200.71,NULL,'2023-01-16 17:49:17','2023-01-16 17:58:03','2023-01-16 17:58:03');
INSERT INTO `balance_libro_details` VALUES (1497,7705,385,40720,1517,2,13,1,14100.70,NULL,'2023-01-16 17:49:17','2023-01-16 17:58:03','2023-01-16 17:58:03'),(1498,7705,386,40720,1517,2,96,2,1503.25,NULL,'2023-01-16 17:50:01','2023-01-16 17:57:58','2023-01-16 17:57:58'),(1499,7705,386,40720,1517,2,67,2,315.68,NULL,'2023-01-16 17:50:01','2023-01-16 17:57:58','2023-01-16 17:57:58'),(1500,7705,386,40720,1517,2,224,2,181.07,NULL,'2023-01-16 17:50:01','2023-01-16 17:57:58','2023-01-16 17:57:58'),(1501,7705,386,40720,1517,2,13,1,2000.00,NULL,'2023-01-16 17:50:01','2023-01-16 17:57:58','2023-01-16 17:57:58'),(1502,7705,387,40720,1517,2,96,2,16998.11,NULL,'2023-01-16 17:51:27','2023-01-16 17:57:52','2023-01-16 17:57:52'),(1503,7705,387,40720,1517,2,67,2,3569.60,NULL,'2023-01-16 17:51:27','2023-01-16 17:57:52','2023-01-16 17:57:52'),(1504,7705,387,40720,1517,2,224,2,1857.20,NULL,'2023-01-16 17:51:27','2023-01-16 17:57:52','2023-01-16 17:57:52'),(1505,7705,387,40720,1517,2,13,1,22424.91,NULL,'2023-01-16 17:51:27','2023-01-16 17:57:52','2023-01-16 17:57:52'),(1506,7705,388,40720,1517,2,96,2,2254.68,NULL,'2023-01-16 17:51:58','2023-01-16 17:57:46','2023-01-16 17:57:46'),(1507,7705,388,40720,1517,2,67,2,473.48,NULL,'2023-01-16 17:51:58','2023-01-16 17:57:46','2023-01-16 17:57:46'),(1508,7705,388,40720,1517,2,224,2,271.59,NULL,'2023-01-16 17:51:58','2023-01-16 17:57:46','2023-01-16 17:57:46'),(1509,7705,388,40720,1517,2,13,1,2999.75,NULL,'2023-01-16 17:51:58','2023-01-16 17:57:46','2023-01-16 17:57:46'),(1510,7705,389,40720,1517,2,96,2,13715.22,NULL,'2023-01-16 17:53:06','2023-01-16 17:57:40','2023-01-16 17:57:40'),(1511,7705,389,40720,1517,2,67,2,2880.20,NULL,'2023-01-16 17:53:06','2023-01-16 17:57:40','2023-01-16 17:57:40'),(1512,7705,389,40720,1517,2,224,2,1705.35,NULL,'2023-01-16 17:53:06','2023-01-16 17:57:40','2023-01-16 17:57:40'),(1513,7705,389,40720,1517,2,13,1,18300.77,NULL,'2023-01-16 17:53:06','2023-01-16 17:57:40','2023-01-16 17:57:40'),(1514,7705,390,40720,1517,2,96,2,1570.00,NULL,'2023-01-16 17:55:24','2023-01-16 17:57:34','2023-01-16 17:57:34'),(1515,7705,390,40720,1517,2,67,2,329.70,NULL,'2023-01-16 17:55:24','2023-01-16 17:57:34','2023-01-16 17:57:34'),(1516,7705,390,40720,1517,2,13,1,1899.70,NULL,'2023-01-16 17:55:24','2023-01-16 17:57:34','2023-01-16 17:57:34'),(1517,7705,391,40720,1517,3,217,1,1514.69,NULL,'2023-01-16 18:20:30','2023-01-16 18:20:30',NULL),(1518,7705,391,40720,1517,3,68,1,318.08,NULL,'2023-01-16 18:20:30','2023-01-16 18:20:30',NULL),(1519,7705,391,40720,1517,3,224,1,167.41,NULL,'2023-01-16 18:20:30','2023-01-16 18:20:30',NULL),(1520,7705,391,40720,1517,3,57,2,2000.18,NULL,'2023-01-16 18:20:30','2023-01-16 18:20:30',NULL),(1521,7705,392,40720,1517,3,217,1,3006.25,NULL,'2023-01-16 18:21:46','2023-01-16 18:21:46',NULL),(1522,7705,392,40720,1517,3,68,1,631.31,NULL,'2023-01-16 18:21:46','2023-01-16 18:21:46',NULL),(1523,7705,392,40720,1517,3,224,1,362.11,NULL,'2023-01-16 18:21:46','2023-01-16 18:21:46',NULL),(1524,7705,392,40720,1517,3,57,2,3999.67,NULL,'2023-01-16 18:21:46','2023-01-16 18:21:46',NULL),(1525,7705,393,40720,1517,3,217,1,8666.59,NULL,'2023-01-16 18:25:54','2023-01-16 18:25:54',NULL),(1526,7705,393,40720,1517,3,68,1,1819.98,NULL,'2023-01-16 18:25:54','2023-01-16 18:25:54',NULL),(1527,7705,393,40720,1517,3,224,1,1513.00,NULL,'2023-01-16 18:25:54','2023-01-16 18:25:54',NULL),(1528,7705,393,40720,1517,3,57,2,11999.57,NULL,'2023-01-16 18:25:54','2023-01-16 18:25:54',NULL),(1529,7705,394,40720,1517,3,217,1,8963.63,NULL,'2023-01-16 18:26:33','2023-01-16 18:26:33',NULL),(1530,7705,394,40720,1517,3,68,1,1882.36,NULL,'2023-01-16 18:26:33','2023-01-16 18:26:33',NULL),(1531,7705,394,40720,1517,3,224,1,1455.10,NULL,'2023-01-16 18:26:33','2023-01-16 18:26:33',NULL),(1532,7705,394,40720,1517,3,57,2,12301.09,NULL,'2023-01-16 18:26:33','2023-01-16 18:26:33',NULL),(1533,7705,395,40720,1517,3,217,1,13490.15,NULL,'2023-01-16 18:27:12','2023-01-16 18:27:12',NULL),(1534,7705,395,40720,1517,3,68,1,2832.93,NULL,'2023-01-16 18:27:12','2023-01-16 18:27:12',NULL);
INSERT INTO `balance_libro_details` VALUES (1535,7705,395,40720,1517,3,224,1,1476.50,NULL,'2023-01-16 18:27:12','2023-01-16 18:27:12',NULL),(1536,7705,395,40720,1517,3,57,2,17799.58,NULL,'2023-01-16 18:27:12','2023-01-16 18:27:12',NULL),(1537,7705,396,40720,1517,3,217,1,9395.29,NULL,'2023-01-16 18:38:14','2023-01-16 18:38:14',NULL),(1538,7705,396,40720,1517,3,68,1,1973.01,NULL,'2023-01-16 18:38:14','2023-01-16 18:38:14',NULL),(1539,7705,396,40720,1517,3,224,1,1131.70,NULL,'2023-01-16 18:38:14','2023-01-16 18:38:14',NULL),(1540,7705,396,40720,1517,3,57,2,12500.00,NULL,'2023-01-16 18:38:14','2023-01-16 18:38:14',NULL),(1541,7705,397,40720,1517,3,217,1,11650.15,NULL,'2023-01-16 18:38:49','2023-01-16 18:38:49',NULL),(1542,7705,397,40720,1517,3,68,1,2446.53,NULL,'2023-01-16 18:38:49','2023-01-16 18:38:49',NULL),(1543,7705,397,40720,1517,3,224,1,1403.31,NULL,'2023-01-16 18:38:49','2023-01-16 18:38:49',NULL),(1544,7705,397,40720,1517,3,57,2,15499.99,NULL,'2023-01-16 18:38:49','2023-01-16 18:38:49',NULL),(1545,7705,398,40720,1517,3,217,1,9399.44,NULL,'2023-01-16 18:39:38','2023-01-16 18:39:38',NULL),(1546,7705,398,40720,1517,3,68,1,1973.88,NULL,'2023-01-16 18:39:38','2023-01-16 18:39:38',NULL),(1547,7705,398,40720,1517,3,224,1,1827.92,NULL,'2023-01-16 18:39:38','2023-01-16 18:39:38',NULL),(1548,7705,398,40720,1517,3,57,2,13201.24,NULL,'2023-01-16 18:39:38','2023-01-16 18:39:38',NULL),(1549,7705,399,40720,1517,3,217,1,14280.39,NULL,'2023-01-16 18:40:23','2023-01-16 18:40:23',NULL),(1550,7705,399,40720,1517,3,68,1,2998.88,NULL,'2023-01-16 18:40:23','2023-01-16 18:40:23',NULL),(1551,7705,399,40720,1517,3,224,1,1720.12,NULL,'2023-01-16 18:40:23','2023-01-16 18:40:23',NULL),(1552,7705,399,40720,1517,3,57,2,18999.39,NULL,'2023-01-16 18:40:23','2023-01-16 18:40:23',NULL),(1553,7705,400,40720,1517,3,217,1,11299.17,NULL,'2023-01-16 18:40:55','2023-01-16 18:40:55',NULL),(1554,7705,400,40720,1517,3,68,1,2372.83,NULL,'2023-01-16 18:40:55','2023-01-16 18:40:55',NULL),(1555,7705,400,40720,1517,3,224,1,2331.92,NULL,'2023-01-16 18:40:55','2023-01-16 18:40:55',NULL),(1556,7705,400,40720,1517,3,57,2,16003.92,NULL,'2023-01-16 18:40:55','2023-01-16 18:40:55',NULL),(1557,7705,401,40720,1517,3,217,1,1503.12,NULL,'2023-01-16 18:41:27','2023-01-16 18:41:27',NULL),(1558,7705,401,40720,1517,3,68,1,315.66,NULL,'2023-01-16 18:41:27','2023-01-16 18:41:27',NULL),(1559,7705,401,40720,1517,3,224,1,181.06,NULL,'2023-01-16 18:41:27','2023-01-16 18:41:27',NULL),(1560,7705,401,40720,1517,3,57,2,1999.84,NULL,'2023-01-16 18:41:27','2023-01-16 18:41:27',NULL),(1561,7705,402,40720,1517,3,217,1,14240.68,NULL,'2023-01-16 18:44:56','2023-01-16 18:44:56',NULL),(1562,7705,402,40720,1517,3,68,1,2990.54,NULL,'2023-01-16 18:44:56','2023-01-16 18:44:56',NULL),(1563,7705,402,40720,1517,3,224,1,2069.36,NULL,'2023-01-16 18:44:56','2023-01-16 18:44:56',NULL),(1564,7705,402,40720,1517,3,57,2,19300.58,NULL,'2023-01-16 18:44:56','2023-01-16 18:44:56',NULL),(1565,7705,403,40720,1517,3,217,1,12025.68,NULL,'2023-01-16 18:50:48','2023-01-16 18:50:48',NULL),(1566,7705,403,40720,1517,3,68,1,2525.39,NULL,'2023-01-16 18:50:48','2023-01-16 18:50:48',NULL),(1567,7705,403,40720,1517,3,224,1,1448.55,NULL,'2023-01-16 18:50:48','2023-01-16 18:50:48',NULL),(1568,7705,403,40720,1517,3,57,2,15999.62,NULL,'2023-01-16 18:50:48','2023-01-16 18:50:48',NULL),(1569,7705,404,40720,1517,3,217,1,9244.96,NULL,'2023-01-16 18:51:37','2023-01-16 18:51:37',NULL),(1570,7705,404,40720,1517,3,68,1,1941.44,NULL,'2023-01-16 18:51:37','2023-01-16 18:51:37',NULL),(1571,7705,404,40720,1517,3,224,1,1113.59,NULL,'2023-01-16 18:51:37','2023-01-16 18:51:37',NULL),(1572,7705,404,40720,1517,3,57,2,12299.99,NULL,'2023-01-16 18:51:37','2023-01-16 18:51:37',NULL),(1573,7705,405,40720,1517,3,217,1,3614.00,NULL,'2023-01-16 18:52:07','2023-01-16 18:52:07',NULL),(1574,7705,405,40720,1517,3,68,1,758.94,NULL,'2023-01-16 18:52:07','2023-01-16 18:52:07',NULL),(1575,7705,405,40720,1517,3,224,1,627.06,NULL,'2023-01-16 18:52:07','2023-01-16 18:52:07',NULL);
INSERT INTO `balance_libro_details` VALUES (1576,7705,405,40720,1517,3,57,2,5000.00,NULL,'2023-01-16 18:52:07','2023-01-16 18:52:07',NULL),(1577,7705,406,40720,1517,3,217,1,5640.05,NULL,'2023-01-16 18:52:33','2023-01-16 18:52:33',NULL),(1578,7705,406,40720,1517,3,68,1,1184.41,NULL,'2023-01-16 18:52:33','2023-01-16 18:52:33',NULL),(1579,7705,406,40720,1517,3,224,1,978.60,NULL,'2023-01-16 18:52:33','2023-01-16 18:52:33',NULL),(1580,7705,406,40720,1517,3,57,2,7803.06,NULL,'2023-01-16 18:52:33','2023-01-16 18:52:33',NULL),(1581,7705,407,40720,1517,3,217,1,1514.69,NULL,'2023-01-16 18:53:47','2023-01-16 18:53:47',NULL),(1582,7705,407,40720,1517,3,68,1,318.08,NULL,'2023-01-16 18:53:47','2023-01-16 18:53:47',NULL),(1583,7705,407,40720,1517,3,224,1,167.41,NULL,'2023-01-16 18:53:47','2023-01-16 18:53:47',NULL),(1584,7705,407,40720,1517,3,57,2,2000.18,NULL,'2023-01-16 18:53:47','2023-01-16 18:53:47',NULL),(1585,7705,408,40720,1517,3,217,1,3006.25,NULL,'2023-01-16 18:55:11','2023-01-16 18:55:11',NULL),(1586,7705,408,40720,1517,3,68,1,631.31,NULL,'2023-01-16 18:55:11','2023-01-16 18:55:11',NULL),(1587,7705,408,40720,1517,3,224,1,362.11,NULL,'2023-01-16 18:55:11','2023-01-16 18:55:11',NULL),(1588,7705,408,40720,1517,3,57,2,3999.67,NULL,'2023-01-16 18:55:11','2023-01-16 18:55:11',NULL),(1589,7705,409,40720,1517,3,217,1,5853.46,NULL,'2023-01-16 18:55:38','2023-01-16 18:55:38',NULL),(1590,7705,409,40720,1517,3,68,1,1229.23,NULL,'2023-01-16 18:55:38','2023-01-16 18:55:38',NULL),(1591,7705,409,40720,1517,3,224,1,917.54,NULL,'2023-01-16 18:55:38','2023-01-16 18:55:38',NULL),(1592,7705,409,40720,1517,3,57,2,8000.23,NULL,'2023-01-16 18:55:38','2023-01-16 18:55:38',NULL),(1593,7705,410,40720,1517,3,217,1,751.56,NULL,'2023-01-16 19:01:51','2023-01-16 19:01:51',NULL),(1594,7705,410,40720,1517,3,68,1,157.83,NULL,'2023-01-16 19:01:51','2023-01-16 19:01:51',NULL),(1595,7705,410,40720,1517,3,224,1,90.53,NULL,'2023-01-16 19:01:51','2023-01-16 19:01:51',NULL),(1596,7705,410,40720,1517,3,57,2,999.92,NULL,'2023-01-16 19:01:51','2023-01-16 19:01:51',NULL),(1597,7705,411,40720,1517,3,217,1,2254.86,NULL,'2023-01-16 19:02:30','2023-01-16 19:02:30',NULL),(1598,7705,411,40720,1517,3,68,1,473.52,NULL,'2023-01-16 19:02:30','2023-01-16 19:02:30',NULL),(1599,7705,411,40720,1517,3,224,1,271.61,NULL,'2023-01-16 19:02:30','2023-01-16 19:02:30',NULL),(1600,7705,411,40720,1517,3,57,2,2999.99,NULL,'2023-01-16 19:02:30','2023-01-16 19:02:30',NULL),(1601,7705,412,40720,1517,3,217,1,757.34,NULL,'2023-01-16 19:03:12','2023-01-16 19:03:12',NULL),(1602,7705,412,40720,1517,3,68,1,159.04,NULL,'2023-01-16 19:03:12','2023-01-16 19:03:12',NULL),(1603,7705,412,40720,1517,3,224,1,83.70,NULL,'2023-01-16 19:03:12','2023-01-16 19:03:12',NULL),(1604,7705,412,40720,1517,3,57,2,1000.08,NULL,'2023-01-16 19:03:12','2023-01-16 19:03:12',NULL),(1605,7705,413,40720,1517,3,217,1,3223.14,NULL,'2023-01-16 19:05:17','2023-01-16 19:05:17',NULL),(1606,7705,413,40720,1517,3,68,1,676.86,NULL,'2023-01-16 19:05:17','2023-01-16 19:05:17',NULL),(1607,7705,413,40720,1517,3,57,2,3900.00,NULL,'2023-01-16 19:05:17','2023-01-16 19:05:17',NULL),(1608,7705,414,40720,1517,3,217,1,4297.52,NULL,'2023-01-16 19:06:10','2023-01-16 19:06:10',NULL),(1609,7705,414,40720,1517,3,68,1,902.48,NULL,'2023-01-16 19:06:10','2023-01-16 19:06:10',NULL),(1610,7705,414,40720,1517,3,57,2,5200.00,NULL,'2023-01-16 19:06:10','2023-01-16 19:06:10',NULL),(1611,7705,415,40720,1517,3,217,1,19149.08,NULL,'2023-01-16 19:09:18','2023-01-16 19:09:18',NULL),(1612,7705,415,40720,1517,3,68,1,4021.31,NULL,'2023-01-16 19:09:18','2023-01-16 19:09:18',NULL),(1613,7705,415,40720,1517,3,224,1,1830.85,NULL,'2023-01-16 19:09:18','2023-01-16 19:09:18',NULL),(1614,7705,415,40720,1517,3,57,2,25001.24,NULL,'2023-01-16 19:09:18','2023-01-16 19:09:18',NULL),(1615,7705,416,40720,1517,3,217,1,14656.44,NULL,'2023-01-16 19:10:20','2023-01-16 19:10:20',NULL),(1616,7705,416,40720,1517,3,68,1,3077.85,NULL,'2023-01-16 19:10:20','2023-01-16 19:10:20',NULL);
INSERT INTO `balance_libro_details` VALUES (1617,7705,416,40720,1517,3,224,1,1765.43,NULL,'2023-01-16 19:10:20','2023-01-16 19:10:20',NULL),(1618,7705,416,40720,1517,3,57,2,19499.72,NULL,'2023-01-16 19:10:20','2023-01-16 19:10:20',NULL),(1619,7705,417,40720,1517,3,217,1,7271.53,NULL,'2023-01-16 19:11:40','2023-01-16 19:11:40',NULL),(1620,7705,417,40720,1517,3,68,1,1527.02,NULL,'2023-01-16 19:11:40','2023-01-16 19:11:40',NULL),(1621,7705,417,40720,1517,3,224,1,1002.93,NULL,'2023-01-16 19:11:40','2023-01-16 19:11:40',NULL),(1622,7705,417,40720,1517,3,57,2,9801.48,NULL,'2023-01-16 19:11:40','2023-01-16 19:11:40',NULL),(1623,7705,418,40720,1517,3,217,1,12272.09,NULL,'2023-01-16 19:13:14','2023-01-16 19:13:14',NULL),(1624,7705,418,40720,1517,3,68,1,2577.14,NULL,'2023-01-16 19:13:14','2023-01-16 19:13:14',NULL),(1625,7705,418,40720,1517,3,224,1,1402.11,NULL,'2023-01-16 19:13:14','2023-01-16 19:13:14',NULL),(1626,7705,418,40720,1517,3,57,2,16251.34,NULL,'2023-01-16 19:13:14','2023-01-16 19:13:14',NULL),(1627,7705,419,40720,1517,3,217,1,1503.12,NULL,'2023-01-16 19:13:41','2023-01-16 19:13:41',NULL),(1628,7705,419,40720,1517,3,68,1,315.66,NULL,'2023-01-16 19:13:41','2023-01-16 19:13:41',NULL),(1629,7705,419,40720,1517,3,224,1,181.06,NULL,'2023-01-16 19:13:41','2023-01-16 19:13:41',NULL),(1630,7705,419,40720,1517,3,57,2,1999.84,NULL,'2023-01-16 19:13:41','2023-01-16 19:13:41',NULL),(1631,7705,420,40720,1517,3,217,1,14093.72,NULL,'2023-01-16 19:14:10','2023-01-16 19:14:10',NULL),(1632,7705,420,40720,1517,3,68,1,2959.68,NULL,'2023-01-16 19:14:10','2023-01-16 19:14:10',NULL),(1633,7705,420,40720,1517,3,224,1,1347.50,NULL,'2023-01-16 19:14:10','2023-01-16 19:14:10',NULL),(1634,7705,420,40720,1517,3,57,2,18400.90,NULL,'2023-01-16 19:14:10','2023-01-16 19:14:10',NULL),(1635,7705,421,40720,1517,3,217,1,15517.00,NULL,'2023-01-16 19:14:36','2023-01-16 19:14:36',NULL),(1636,7705,421,40720,1517,3,68,1,3258.57,NULL,'2023-01-16 19:14:36','2023-01-16 19:14:36',NULL),(1637,7705,421,40720,1517,3,224,1,1924.35,NULL,'2023-01-16 19:14:36','2023-01-16 19:14:36',NULL),(1638,7705,421,40720,1517,3,57,2,20699.92,NULL,'2023-01-16 19:14:36','2023-01-16 19:14:36',NULL),(1639,7705,422,40720,1517,3,217,1,3959.36,NULL,'2023-01-16 19:17:33','2023-01-16 19:17:33',NULL),(1640,7705,422,40720,1517,3,68,1,831.47,NULL,'2023-01-16 19:17:33','2023-01-16 19:17:33',NULL),(1641,7705,422,40720,1517,3,224,1,909.94,NULL,'2023-01-16 19:17:33','2023-01-16 19:17:33',NULL),(1642,7705,422,40720,1517,3,57,2,5700.77,NULL,'2023-01-16 19:17:33','2023-01-16 19:17:33',NULL),(1643,7705,423,40720,1517,3,217,1,15454.55,NULL,'2023-01-16 19:19:28','2023-01-16 19:19:28',NULL),(1644,7705,423,40720,1517,3,68,1,3245.46,NULL,'2023-01-16 19:19:28','2023-01-16 19:19:28',NULL),(1645,7705,423,40720,1517,3,57,2,18700.01,NULL,'2023-01-16 19:19:28','2023-01-16 19:19:28',NULL),(1646,7705,424,40720,1517,3,217,1,10340.00,NULL,'2023-01-16 19:20:13','2023-01-16 19:20:13',NULL),(1647,7705,424,40720,1517,3,68,1,2171.40,NULL,'2023-01-16 19:20:13','2023-01-16 19:20:13',NULL),(1648,7705,424,40720,1517,3,224,1,988.61,NULL,'2023-01-16 19:20:13','2023-01-16 19:20:13',NULL),(1649,7705,424,40720,1517,3,57,2,13500.01,NULL,'2023-01-16 19:20:13','2023-01-16 19:20:13',NULL),(1650,7705,425,40720,1517,3,217,1,9395.29,NULL,'2023-01-16 19:20:46','2023-01-16 19:20:46',NULL),(1651,7705,425,40720,1517,3,68,1,1973.01,NULL,'2023-01-16 19:20:46','2023-01-16 19:20:46',NULL),(1652,7705,425,40720,1517,3,224,1,1131.70,NULL,'2023-01-16 19:20:46','2023-01-16 19:20:46',NULL),(1653,7705,425,40720,1517,3,57,2,12500.00,NULL,'2023-01-16 19:20:46','2023-01-16 19:20:46',NULL),(1654,7705,426,40720,1517,3,217,1,3006.25,NULL,'2023-01-16 19:21:11','2023-01-16 19:21:11',NULL),(1655,7705,426,40720,1517,3,68,1,631.31,NULL,'2023-01-16 19:21:11','2023-01-16 19:21:11',NULL),(1656,7705,426,40720,1517,3,224,1,362.11,NULL,'2023-01-16 19:21:11','2023-01-16 19:21:11',NULL),(1657,7705,426,40720,1517,3,57,2,3999.67,NULL,'2023-01-16 19:21:11','2023-01-16 19:21:11',NULL);
INSERT INTO `balance_libro_details` VALUES (1658,7705,427,40720,1517,3,217,1,9395.29,NULL,'2023-01-16 19:21:48','2023-01-16 19:21:48',NULL),(1659,7705,427,40720,1517,3,68,1,1973.01,NULL,'2023-01-16 19:21:48','2023-01-16 19:21:48',NULL),(1660,7705,427,40720,1517,3,224,1,1131.70,NULL,'2023-01-16 19:21:48','2023-01-16 19:21:48',NULL),(1661,7705,427,40720,1517,3,57,2,12500.00,NULL,'2023-01-16 19:21:48','2023-01-16 19:21:48',NULL),(1662,7705,428,40720,1517,3,217,1,1503.12,NULL,'2023-01-16 19:22:27','2023-01-16 19:22:27',NULL),(1663,7705,428,40720,1517,3,68,1,315.66,NULL,'2023-01-16 19:22:27','2023-01-16 19:22:27',NULL),(1664,7705,428,40720,1517,3,224,1,181.06,NULL,'2023-01-16 19:22:27','2023-01-16 19:22:27',NULL),(1665,7705,428,40720,1517,3,57,2,1999.84,NULL,'2023-01-16 19:22:27','2023-01-16 19:22:27',NULL),(1666,7705,429,40720,1517,3,217,1,10661.15,NULL,'2023-01-16 19:23:33','2023-01-16 19:23:33',NULL),(1667,7705,429,40720,1517,3,68,1,2238.84,NULL,'2023-01-16 19:23:33','2023-01-16 19:23:33',NULL),(1668,7705,429,40720,1517,3,224,1,1200.71,NULL,'2023-01-16 19:23:33','2023-01-16 19:23:33',NULL),(1669,7705,429,40720,1517,3,57,2,14100.70,NULL,'2023-01-16 19:23:33','2023-01-16 19:23:33',NULL),(1670,7705,430,40720,1517,3,217,1,1503.25,NULL,'2023-01-16 19:24:42','2023-01-16 19:24:42',NULL),(1671,7705,430,40720,1517,3,68,1,315.68,NULL,'2023-01-16 19:24:42','2023-01-16 19:24:42',NULL),(1672,7705,430,40720,1517,3,224,1,181.07,NULL,'2023-01-16 19:24:42','2023-01-16 19:24:42',NULL),(1673,7705,430,40720,1517,3,57,2,2000.00,NULL,'2023-01-16 19:24:42','2023-01-16 19:24:42',NULL),(1674,7705,431,40720,1517,3,217,1,16998.11,NULL,'2023-01-16 19:25:18','2023-01-16 19:25:18',NULL),(1675,7705,431,40720,1517,3,68,1,3569.60,NULL,'2023-01-16 19:25:18','2023-01-16 19:25:18',NULL),(1676,7705,431,40720,1517,3,224,1,1857.20,NULL,'2023-01-16 19:25:18','2023-01-16 19:25:18',NULL),(1677,7705,431,40720,1517,3,57,2,22424.91,NULL,'2023-01-16 19:25:18','2023-01-16 19:25:18',NULL),(1678,7705,432,40720,1517,3,217,1,2254.68,NULL,'2023-01-16 19:31:18','2023-01-16 19:31:18',NULL),(1679,7705,432,40720,1517,3,68,1,473.48,NULL,'2023-01-16 19:31:18','2023-01-16 19:31:18',NULL),(1680,7705,432,40720,1517,3,224,1,271.59,NULL,'2023-01-16 19:31:18','2023-01-16 19:31:18',NULL),(1681,7705,432,40720,1517,3,57,2,2999.75,NULL,'2023-01-16 19:31:18','2023-01-16 19:31:18',NULL),(1682,7705,433,40720,1517,3,217,1,13715.22,NULL,'2023-01-16 19:31:51','2023-01-16 19:31:51',NULL),(1683,7705,433,40720,1517,3,68,1,2880.20,NULL,'2023-01-16 19:31:51','2023-01-16 19:31:51',NULL),(1684,7705,433,40720,1517,3,224,1,1705.35,NULL,'2023-01-16 19:31:51','2023-01-16 19:31:51',NULL),(1685,7705,433,40720,1517,3,57,2,18300.77,NULL,'2023-01-16 19:31:51','2023-01-16 19:31:51',NULL),(1686,7705,434,40720,1517,3,217,1,1570.00,NULL,'2023-01-16 19:32:53','2023-01-16 19:32:53',NULL),(1687,7705,434,40720,1517,3,68,1,329.70,NULL,'2023-01-16 19:32:53','2023-01-16 19:32:53',NULL),(1688,7705,434,40720,1517,3,57,2,1899.70,NULL,'2023-01-16 19:32:53','2023-01-16 19:32:53',NULL),(1689,7705,435,40720,1517,15,68,2,127658.61,NULL,'2023-01-17 08:55:33','2023-01-17 09:01:33','2023-01-17 09:01:33'),(1690,7705,435,40720,1517,15,353,2,42569.14,NULL,'2023-01-17 08:55:33','2023-01-17 09:01:33','2023-01-17 09:01:33'),(1691,7705,435,40720,1517,15,353,1,170227.75,NULL,'2023-01-17 08:55:33','2023-01-17 09:01:33','2023-01-17 09:01:33'),(1692,7705,436,40720,1517,15,68,2,127125.80,NULL,'2023-01-17 09:02:57','2023-01-17 09:02:57',NULL),(1693,7705,436,40720,1517,15,353,2,42569.14,NULL,'2023-01-17 09:02:57','2023-01-17 09:02:57',NULL),(1694,7705,436,40720,1517,15,353,1,169694.94,NULL,'2023-01-17 09:02:57','2023-01-17 09:02:57',NULL),(1695,7705,437,40745,3030,2,96,2,99173.55,NULL,'2023-01-18 10:51:15','2023-01-18 10:51:15',NULL),(1696,7705,437,40745,3030,2,67,2,20826.45,NULL,'2023-01-18 10:51:15','2023-01-18 10:51:15',NULL),(1697,7705,437,40745,3030,2,13,1,120000.00,NULL,'2023-01-18 10:51:15','2023-01-18 10:51:15',NULL);
INSERT INTO `balance_libro_details` VALUES (1698,7705,439,40745,3030,15,67,1,20826.45,NULL,'2023-01-18 10:52:27','2023-01-18 10:52:27',NULL),(1699,7705,439,40745,3030,15,68,2,17366.66,NULL,'2023-01-18 10:52:27','2023-01-18 10:52:27',NULL),(1700,7705,439,40745,3030,15,74,2,3459.79,NULL,'2023-01-18 10:52:27','2023-01-18 10:52:27',NULL),(1701,7705,440,40720,1518,3,217,1,86014.01,NULL,'2023-01-19 07:42:44','2023-01-19 07:42:44',NULL),(1702,7705,440,40720,1518,3,68,1,18062.94,NULL,'2023-01-19 07:42:44','2023-01-19 07:42:44',NULL),(1703,7705,440,40720,1518,3,57,2,104076.95,NULL,'2023-01-19 07:42:44','2023-01-19 07:42:44',NULL),(1704,7705,441,40720,1518,3,217,1,37183.78,NULL,'2023-01-19 07:43:20','2023-01-19 07:43:20',NULL),(1705,7705,441,40720,1518,3,68,1,7808.59,NULL,'2023-01-19 07:43:20','2023-01-19 07:43:20',NULL),(1706,7705,441,40720,1518,3,57,2,44992.37,NULL,'2023-01-19 07:43:20','2023-01-19 07:43:20',NULL),(1707,7705,442,40720,1518,3,217,1,12700.11,NULL,'2023-01-19 07:47:08','2023-01-19 07:47:08',NULL),(1708,7705,442,40720,1518,3,68,1,2667.02,NULL,'2023-01-19 07:47:08','2023-01-19 07:47:08',NULL),(1709,7705,442,40720,1518,3,224,1,1134.19,NULL,'2023-01-19 07:47:08','2023-01-19 07:47:08',NULL),(1710,7705,442,40720,1518,3,57,2,16501.32,NULL,'2023-01-19 07:47:08','2023-01-19 07:47:08',NULL),(1711,7705,443,40720,1518,3,217,1,11314.85,NULL,'2023-01-19 07:49:01','2023-01-19 07:49:01',NULL),(1712,7705,443,40720,1518,3,68,1,2376.12,NULL,'2023-01-19 07:49:01','2023-01-19 07:49:01',NULL),(1713,7705,443,40720,1518,3,224,1,1010.48,NULL,'2023-01-19 07:49:01','2023-01-19 07:49:01',NULL),(1714,7705,443,40720,1518,3,57,2,14701.45,NULL,'2023-01-19 07:49:01','2023-01-19 07:49:01',NULL),(1715,7705,444,40720,1518,3,217,1,10237.77,NULL,'2023-01-19 07:49:56','2023-01-19 07:49:56',NULL),(1716,7705,444,40720,1518,3,68,1,2149.93,NULL,'2023-01-19 07:49:56','2023-01-19 07:49:56',NULL),(1717,7705,444,40720,1518,3,224,1,914.29,NULL,'2023-01-19 07:49:56','2023-01-19 07:49:56',NULL),(1718,7705,444,40720,1518,3,57,2,13301.99,NULL,'2023-01-19 07:49:56','2023-01-19 07:49:56',NULL),(1719,7705,445,40720,1518,3,217,1,6195.95,NULL,'2023-01-19 07:53:10','2023-01-19 07:53:10',NULL),(1720,7705,445,40720,1518,3,68,1,1301.15,NULL,'2023-01-19 07:53:10','2023-01-19 07:53:10',NULL),(1721,7705,445,40720,1518,3,224,1,504.54,NULL,'2023-01-19 07:53:10','2023-01-19 07:53:10',NULL),(1722,7705,445,40720,1518,3,57,2,8001.64,NULL,'2023-01-19 07:53:10','2023-01-19 07:53:10',NULL),(1723,7705,446,40720,1518,3,217,1,7193.87,NULL,'2023-01-19 07:56:35','2023-01-19 07:56:35',NULL),(1724,7705,446,40720,1518,3,68,1,1510.71,NULL,'2023-01-19 07:56:35','2023-01-19 07:56:35',NULL),(1725,7705,446,40720,1518,3,224,1,795.60,NULL,'2023-01-19 07:56:35','2023-01-19 07:56:35',NULL),(1726,7705,446,40720,1518,3,57,2,9500.18,NULL,'2023-01-19 07:56:35','2023-01-19 07:56:35',NULL),(1727,7705,447,40720,1518,3,217,1,8287.71,NULL,'2023-01-19 07:58:09','2023-01-19 07:58:09',NULL),(1728,7705,447,40720,1518,3,68,1,1740.42,NULL,'2023-01-19 07:58:09','2023-01-19 07:58:09',NULL),(1729,7705,447,40720,1518,3,224,1,674.87,NULL,'2023-01-19 07:58:09','2023-01-19 07:58:09',NULL),(1730,7705,447,40720,1518,3,57,2,10703.00,NULL,'2023-01-19 07:58:09','2023-01-19 07:58:09',NULL),(1731,7705,448,40720,1518,3,217,1,9293.06,NULL,'2023-01-19 07:58:47','2023-01-19 07:58:47',NULL),(1732,7705,448,40720,1518,3,68,1,1951.54,NULL,'2023-01-19 07:58:47','2023-01-19 07:58:47',NULL),(1733,7705,448,40720,1518,3,224,1,756.73,NULL,'2023-01-19 07:58:47','2023-01-19 07:58:47',NULL),(1734,7705,448,40720,1518,3,57,2,12001.33,NULL,'2023-01-19 07:58:47','2023-01-19 07:58:47',NULL),(1735,7705,449,40720,1518,3,217,1,3252.31,NULL,'2023-01-19 07:59:25','2023-01-19 07:59:25',NULL),(1736,7705,449,40720,1518,3,68,1,682.99,NULL,'2023-01-19 07:59:25','2023-01-19 07:59:25',NULL),(1737,7705,449,40720,1518,3,224,1,264.84,NULL,'2023-01-19 07:59:25','2023-01-19 07:59:25',NULL),(1738,7705,449,40720,1518,3,57,2,4200.14,NULL,'2023-01-19 07:59:25','2023-01-19 07:59:25',NULL);
INSERT INTO `balance_libro_details` VALUES (1739,7705,450,40720,1518,3,217,1,7742.78,NULL,'2023-01-19 08:00:06','2023-01-19 08:00:06',NULL),(1740,7705,450,40720,1518,3,68,1,1625.98,NULL,'2023-01-19 08:00:06','2023-01-19 08:00:06',NULL),(1741,7705,450,40720,1518,3,224,1,630.49,NULL,'2023-01-19 08:00:06','2023-01-19 08:00:06',NULL),(1742,7705,450,40720,1518,3,57,2,9999.25,NULL,'2023-01-19 08:00:06','2023-01-19 08:00:06',NULL),(1743,7705,451,40720,1518,3,217,1,11922.85,NULL,'2023-01-19 08:00:45','2023-01-19 08:00:45',NULL),(1744,7705,451,40720,1518,3,68,1,2503.80,NULL,'2023-01-19 08:00:45','2023-01-19 08:00:45',NULL),(1745,7705,451,40720,1518,3,224,1,970.88,NULL,'2023-01-19 08:00:45','2023-01-19 08:00:45',NULL),(1746,7705,451,40720,1518,3,57,2,15397.53,NULL,'2023-01-19 08:00:45','2023-01-19 08:00:45',NULL),(1747,7705,452,40720,1518,3,217,1,12157.37,NULL,'2023-01-19 08:01:49','2023-01-19 08:01:49',NULL),(1748,7705,452,40720,1518,3,68,1,2553.05,NULL,'2023-01-19 08:01:49','2023-01-19 08:01:49',NULL),(1749,7705,452,40720,1518,3,224,1,989.98,NULL,'2023-01-19 08:01:49','2023-01-19 08:01:49',NULL),(1750,7705,452,40720,1518,3,57,2,15700.40,NULL,'2023-01-19 08:01:49','2023-01-19 08:01:49',NULL),(1751,7705,453,40720,1518,3,217,1,8518.78,NULL,'2023-01-19 08:02:27','2023-01-19 08:02:27',NULL),(1752,7705,453,40720,1518,3,68,1,1788.94,NULL,'2023-01-19 08:02:27','2023-01-19 08:02:27',NULL),(1753,7705,453,40720,1518,3,224,1,693.68,NULL,'2023-01-19 08:02:27','2023-01-19 08:02:27',NULL),(1754,7705,453,40720,1518,3,57,2,11001.40,NULL,'2023-01-19 08:02:27','2023-01-19 08:02:27',NULL),(1755,7705,454,40720,1518,3,217,1,12467.77,NULL,'2023-01-19 08:03:05','2023-01-19 08:03:05',NULL),(1756,7705,454,40720,1518,3,68,1,2618.23,NULL,'2023-01-19 08:03:05','2023-01-19 08:03:05',NULL),(1757,7705,454,40720,1518,3,224,1,1015.25,NULL,'2023-01-19 08:03:05','2023-01-19 08:03:05',NULL),(1758,7705,454,40720,1518,3,57,2,16101.25,NULL,'2023-01-19 08:03:05','2023-01-19 08:03:05',NULL),(1759,7705,455,40720,1518,3,217,1,5831.29,NULL,'2023-01-19 08:03:37','2023-01-19 08:03:37',NULL),(1760,7705,455,40720,1518,3,68,1,1224.57,NULL,'2023-01-19 08:03:37','2023-01-19 08:03:37',NULL),(1761,7705,455,40720,1518,3,224,1,644.91,NULL,'2023-01-19 08:03:37','2023-01-19 08:03:37',NULL),(1762,7705,455,40720,1518,3,57,2,7700.77,NULL,'2023-01-19 08:03:37','2023-01-19 08:03:37',NULL),(1763,7705,456,40720,1518,3,217,1,13164.45,NULL,'2023-01-19 08:04:08','2023-01-19 08:04:08',NULL),(1764,7705,456,40720,1518,3,68,1,2764.53,NULL,'2023-01-19 08:04:08','2023-01-19 08:04:08',NULL),(1765,7705,456,40720,1518,3,224,1,1071.98,NULL,'2023-01-19 08:04:08','2023-01-19 08:04:08',NULL),(1766,7705,456,40720,1518,3,57,2,17000.96,NULL,'2023-01-19 08:04:08','2023-01-19 08:04:08',NULL),(1767,7705,457,40720,1518,3,217,1,4259.39,NULL,'2023-01-19 08:05:36','2023-01-19 08:05:36',NULL),(1768,7705,457,40720,1518,3,68,1,894.47,NULL,'2023-01-19 08:05:36','2023-01-19 08:05:36',NULL),(1769,7705,457,40720,1518,3,224,1,346.84,NULL,'2023-01-19 08:05:36','2023-01-19 08:05:36',NULL),(1770,7705,457,40720,1518,3,57,2,5500.70,NULL,'2023-01-19 08:05:36','2023-01-19 08:05:36',NULL),(1771,7705,458,40720,1518,3,217,1,5064.71,NULL,'2023-01-19 08:06:07','2023-01-19 08:06:07',NULL),(1772,7705,458,40720,1518,3,68,1,1063.59,NULL,'2023-01-19 08:06:07','2023-01-19 08:06:07',NULL),(1773,7705,458,40720,1518,3,224,1,412.42,NULL,'2023-01-19 08:06:07','2023-01-19 08:06:07',NULL),(1774,7705,458,40720,1518,3,57,2,6540.72,NULL,'2023-01-19 08:06:07','2023-01-19 08:06:07',NULL),(1775,7705,459,40720,1518,3,217,1,9410.32,NULL,'2023-01-19 08:06:46','2023-01-19 08:06:46',NULL),(1776,7705,459,40720,1518,3,68,1,1976.17,NULL,'2023-01-19 08:06:46','2023-01-19 08:06:46',NULL),(1777,7705,459,40720,1518,3,224,1,766.28,NULL,'2023-01-19 08:06:46','2023-01-19 08:06:46',NULL),(1778,7705,459,40720,1518,3,57,2,12152.77,NULL,'2023-01-19 08:06:46','2023-01-19 08:06:46',NULL),(1779,7705,460,40720,1518,3,217,1,8406.69,NULL,'2023-01-19 08:07:23','2023-01-19 08:07:23',NULL);
INSERT INTO `balance_libro_details` VALUES (1780,7705,460,40720,1518,3,68,1,1765.40,NULL,'2023-01-19 08:07:23','2023-01-19 08:07:23',NULL),(1781,7705,460,40720,1518,3,224,1,684.56,NULL,'2023-01-19 08:07:23','2023-01-19 08:07:23',NULL),(1782,7705,460,40720,1518,3,57,2,10856.65,NULL,'2023-01-19 08:07:23','2023-01-19 08:07:23',NULL),(1783,7705,461,40720,1518,3,217,1,12545.37,NULL,'2023-01-19 08:08:00','2023-01-19 08:08:00',NULL),(1784,7705,461,40720,1518,3,68,1,2634.53,NULL,'2023-01-19 08:08:00','2023-01-19 08:08:00',NULL),(1785,7705,461,40720,1518,3,224,1,1021.57,NULL,'2023-01-19 08:08:00','2023-01-19 08:08:00',NULL),(1786,7705,461,40720,1518,3,57,2,16201.47,NULL,'2023-01-19 08:08:00','2023-01-19 08:08:00',NULL),(1787,7705,462,40720,1518,3,217,1,6351.15,NULL,'2023-01-19 08:08:34','2023-01-19 08:08:34',NULL),(1788,7705,462,40720,1518,3,68,1,1333.74,NULL,'2023-01-19 08:08:34','2023-01-19 08:08:34',NULL),(1789,7705,462,40720,1518,3,224,1,517.17,NULL,'2023-01-19 08:08:34','2023-01-19 08:08:34',NULL),(1790,7705,462,40720,1518,3,57,2,8202.06,NULL,'2023-01-19 08:08:34','2023-01-19 08:08:34',NULL),(1791,7705,463,40720,1518,3,217,1,9527.59,NULL,'2023-01-19 08:09:06','2023-01-19 08:09:06',NULL),(1792,7705,463,40720,1518,3,68,1,2000.79,NULL,'2023-01-19 08:09:06','2023-01-19 08:09:06',NULL),(1793,7705,463,40720,1518,3,224,1,775.83,NULL,'2023-01-19 08:09:06','2023-01-19 08:09:06',NULL),(1794,7705,463,40720,1518,3,57,2,12304.21,NULL,'2023-01-19 08:09:06','2023-01-19 08:09:06',NULL),(1795,7705,464,40720,1518,3,217,1,9758.66,NULL,'2023-01-19 08:09:42','2023-01-19 08:09:42',NULL),(1796,7705,464,40720,1518,3,68,1,2049.32,NULL,'2023-01-19 08:09:42','2023-01-19 08:09:42',NULL),(1797,7705,464,40720,1518,3,224,1,794.65,NULL,'2023-01-19 08:09:42','2023-01-19 08:09:42',NULL),(1798,7705,464,40720,1518,3,57,2,12602.63,NULL,'2023-01-19 08:09:42','2023-01-19 08:09:42',NULL),(1799,7705,465,40720,1518,3,217,1,3017.76,NULL,'2023-01-19 08:10:23','2023-01-19 08:10:23',NULL),(1800,7705,465,40720,1518,3,68,1,633.73,NULL,'2023-01-19 08:10:23','2023-01-19 08:10:23',NULL),(1801,7705,465,40720,1518,3,224,1,348.22,NULL,'2023-01-19 08:10:23','2023-01-19 08:10:23',NULL),(1802,7705,465,40720,1518,3,57,2,3999.71,NULL,'2023-01-19 08:10:23','2023-01-19 08:10:23',NULL),(1803,7705,466,40720,1518,3,217,1,2668.03,NULL,'2023-01-19 08:12:23','2023-01-19 08:12:23',NULL),(1804,7705,466,40720,1518,3,68,1,560.29,NULL,'2023-01-19 08:12:23','2023-01-19 08:12:23',NULL),(1805,7705,466,40720,1518,3,224,1,271.42,NULL,'2023-01-19 08:12:23','2023-01-19 08:12:23',NULL),(1806,7705,466,40720,1518,3,57,2,3499.74,NULL,'2023-01-19 08:12:23','2023-01-19 08:12:23',NULL),(1807,7705,467,40720,1518,3,217,1,754.44,NULL,'2023-01-19 08:13:16','2023-01-19 08:13:16',NULL),(1808,7705,467,40720,1518,3,68,1,158.43,NULL,'2023-01-19 08:13:16','2023-01-19 08:13:16',NULL),(1809,7705,467,40720,1518,3,224,1,87.05,NULL,'2023-01-19 08:13:16','2023-01-19 08:13:16',NULL),(1810,7705,467,40720,1518,3,57,2,999.92,NULL,'2023-01-19 08:13:16','2023-01-19 08:13:16',NULL),(1811,7705,468,40720,1518,3,217,1,9431.20,NULL,'2023-01-19 08:13:51','2023-01-19 08:13:51',NULL),(1812,7705,468,40720,1518,3,68,1,1980.55,NULL,'2023-01-19 08:13:51','2023-01-19 08:13:51',NULL),(1813,7705,468,40720,1518,3,224,1,1088.24,NULL,'2023-01-19 08:13:51','2023-01-19 08:13:51',NULL),(1814,7705,468,40720,1518,3,57,2,12499.99,NULL,'2023-01-19 08:13:51','2023-01-19 08:13:51',NULL),(1815,7705,469,40720,1518,3,217,1,2915.57,NULL,'2023-01-19 08:14:22','2023-01-19 08:14:22',NULL),(1816,7705,469,40720,1518,3,68,1,612.27,NULL,'2023-01-19 08:14:22','2023-01-19 08:14:22',NULL),(1817,7705,469,40720,1518,3,224,1,472.03,NULL,'2023-01-19 08:14:22','2023-01-19 08:14:22',NULL),(1818,7705,469,40720,1518,3,57,2,3999.87,NULL,'2023-01-19 08:14:22','2023-01-19 08:14:22',NULL),(1819,7705,470,40720,1518,3,217,1,2263.32,NULL,'2023-01-19 08:15:51','2023-01-19 08:15:51',NULL),(1820,7705,470,40720,1518,3,68,1,475.30,NULL,'2023-01-19 08:15:51','2023-01-19 08:15:51',NULL);
INSERT INTO `balance_libro_details` VALUES (1821,7705,470,40720,1518,3,224,1,261.16,NULL,'2023-01-19 08:15:51','2023-01-19 08:15:51',NULL),(1822,7705,470,40720,1518,3,57,2,2999.78,NULL,'2023-01-19 08:15:51','2023-01-19 08:15:51',NULL),(1823,7705,471,40720,1518,3,217,1,9054.01,NULL,'2023-01-19 08:16:24','2023-01-19 08:16:24',NULL),(1824,7705,471,40720,1518,3,68,1,1901.34,NULL,'2023-01-19 08:16:24','2023-01-19 08:16:24',NULL),(1825,7705,471,40720,1518,3,224,1,1044.72,NULL,'2023-01-19 08:16:24','2023-01-19 08:16:24',NULL),(1826,7705,471,40720,1518,3,57,2,12000.07,NULL,'2023-01-19 08:16:24','2023-01-19 08:16:24',NULL),(1827,7705,472,40720,1518,3,217,1,4526.64,NULL,'2023-01-19 08:16:52','2023-01-19 08:16:52',NULL),(1828,7705,472,40720,1518,3,68,1,950.59,NULL,'2023-01-19 08:16:52','2023-01-19 08:16:52',NULL),(1829,7705,472,40720,1518,3,224,1,522.32,NULL,'2023-01-19 08:16:52','2023-01-19 08:16:52',NULL),(1830,7705,472,40720,1518,3,57,2,5999.55,NULL,'2023-01-19 08:16:52','2023-01-19 08:16:52',NULL),(1831,7705,473,40720,1518,3,217,1,2263.32,NULL,'2023-01-19 08:17:18','2023-01-19 08:17:18',NULL),(1832,7705,473,40720,1518,3,68,1,475.30,NULL,'2023-01-19 08:17:18','2023-01-19 08:17:18',NULL),(1833,7705,473,40720,1518,3,224,1,261.16,NULL,'2023-01-19 08:17:18','2023-01-19 08:17:18',NULL),(1834,7705,473,40720,1518,3,57,2,2999.78,NULL,'2023-01-19 08:17:18','2023-01-19 08:17:18',NULL),(1835,7705,474,40720,1518,3,217,1,3017.76,NULL,'2023-01-19 08:17:47','2023-01-19 08:17:47',NULL),(1836,7705,474,40720,1518,3,68,1,633.73,NULL,'2023-01-19 08:17:47','2023-01-19 08:17:47',NULL),(1837,7705,474,40720,1518,3,224,1,348.21,NULL,'2023-01-19 08:17:47','2023-01-19 08:17:47',NULL),(1838,7705,474,40720,1518,3,57,2,3999.70,NULL,'2023-01-19 08:17:47','2023-01-19 08:17:47',NULL),(1839,7705,475,40720,1518,3,217,1,9813.75,NULL,'2023-01-19 08:18:24','2023-01-19 08:18:24',NULL),(1840,7705,475,40720,1518,3,68,1,2060.89,NULL,'2023-01-19 08:18:24','2023-01-19 08:18:24',NULL),(1841,7705,475,40720,1518,3,224,1,1132.38,NULL,'2023-01-19 08:18:24','2023-01-19 08:18:24',NULL),(1842,7705,475,40720,1518,3,57,2,13007.02,NULL,'2023-01-19 08:18:24','2023-01-19 08:18:24',NULL),(1843,7705,476,40720,1518,3,217,1,9847.40,NULL,'2023-01-19 08:19:04','2023-01-19 08:19:04',NULL),(1844,7705,476,40720,1518,3,68,1,2067.95,NULL,'2023-01-19 08:19:04','2023-01-19 08:19:04',NULL),(1845,7705,476,40720,1518,3,224,1,2085.57,NULL,'2023-01-19 08:19:04','2023-01-19 08:19:04',NULL),(1846,7705,476,40720,1518,3,57,2,14000.92,NULL,'2023-01-19 08:19:04','2023-01-19 08:19:04',NULL),(1847,7705,477,40720,1518,3,217,1,10185.70,NULL,'2023-01-19 08:19:37','2023-01-19 08:19:37',NULL),(1848,7705,477,40720,1518,3,68,1,2139.00,NULL,'2023-01-19 08:19:37','2023-01-19 08:19:37',NULL),(1849,7705,477,40720,1518,3,224,1,1175.30,NULL,'2023-01-19 08:19:37','2023-01-19 08:19:37',NULL),(1850,7705,477,40720,1518,3,57,2,13500.00,NULL,'2023-01-19 08:19:37','2023-01-19 08:19:37',NULL),(1851,7705,478,40720,1518,3,217,1,7545.12,NULL,'2023-01-19 08:20:08','2023-01-19 08:20:08',NULL),(1852,7705,478,40720,1518,3,68,1,1584.48,NULL,'2023-01-19 08:20:08','2023-01-19 08:20:08',NULL),(1853,7705,478,40720,1518,3,224,1,870.61,NULL,'2023-01-19 08:20:08','2023-01-19 08:20:08',NULL),(1854,7705,478,40720,1518,3,57,2,10000.21,NULL,'2023-01-19 08:20:08','2023-01-19 08:20:08',NULL),(1855,7705,479,40720,1518,3,217,1,15089.52,NULL,'2023-01-19 08:21:34','2023-01-19 08:21:34',NULL),(1856,7705,479,40720,1518,3,68,1,3168.80,NULL,'2023-01-19 08:21:34','2023-01-19 08:21:34',NULL),(1857,7705,479,40720,1518,3,224,1,1741.15,NULL,'2023-01-19 08:21:34','2023-01-19 08:21:34',NULL),(1858,7705,479,40720,1518,3,57,2,19999.47,NULL,'2023-01-19 08:21:34','2023-01-19 08:21:34',NULL),(1859,7705,480,40720,1518,3,217,1,2263.32,NULL,'2023-01-19 08:22:08','2023-01-19 08:22:08',NULL),(1860,7705,480,40720,1518,3,68,1,475.30,NULL,'2023-01-19 08:22:08','2023-01-19 08:22:08',NULL),(1861,7705,480,40720,1518,3,224,1,261.16,NULL,'2023-01-19 08:22:08','2023-01-19 08:22:08',NULL);
INSERT INTO `balance_libro_details` VALUES (1862,7705,480,40720,1518,3,57,2,2999.78,NULL,'2023-01-19 08:22:08','2023-01-19 08:22:08',NULL),(1863,7705,481,40720,1518,3,217,1,3017.76,NULL,'2023-01-19 08:22:45','2023-01-19 08:22:45',NULL),(1864,7705,481,40720,1518,3,68,1,633.73,NULL,'2023-01-19 08:22:45','2023-01-19 08:22:45',NULL),(1865,7705,481,40720,1518,3,224,1,348.21,NULL,'2023-01-19 08:22:45','2023-01-19 08:22:45',NULL),(1866,7705,481,40720,1518,3,57,2,3999.70,NULL,'2023-01-19 08:22:45','2023-01-19 08:22:45',NULL),(1867,7705,482,40720,1518,3,217,1,8060.17,NULL,'2023-01-19 08:23:14','2023-01-19 08:23:14',NULL),(1868,7705,482,40720,1518,3,68,1,1692.64,NULL,'2023-01-19 08:23:14','2023-01-19 08:23:14',NULL),(1869,7705,482,40720,1518,3,224,1,946.99,NULL,'2023-01-19 08:23:14','2023-01-19 08:23:14',NULL),(1870,7705,482,40720,1518,3,57,2,10699.80,NULL,'2023-01-19 08:23:14','2023-01-19 08:23:14',NULL),(1871,7705,483,40720,1518,3,217,1,10695.84,NULL,'2023-01-19 08:23:45','2023-01-19 08:23:45',NULL),(1872,7705,483,40720,1518,3,68,1,2246.13,NULL,'2023-01-19 08:23:45','2023-01-19 08:23:45',NULL),(1873,7705,483,40720,1518,3,224,1,1233.95,NULL,'2023-01-19 08:23:45','2023-01-19 08:23:45',NULL),(1874,7705,483,40720,1518,3,57,2,14175.92,NULL,'2023-01-19 08:23:45','2023-01-19 08:23:45',NULL),(1875,7705,484,40720,1518,3,217,1,10811.01,NULL,'2023-01-19 08:24:14','2023-01-19 08:24:14',NULL),(1876,7705,484,40720,1518,3,68,1,2270.31,NULL,'2023-01-19 08:24:14','2023-01-19 08:24:14',NULL),(1877,7705,484,40720,1518,3,224,1,2019.37,NULL,'2023-01-19 08:24:14','2023-01-19 08:24:14',NULL),(1878,7705,484,40720,1518,3,57,2,15100.69,NULL,'2023-01-19 08:24:14','2023-01-19 08:24:14',NULL),(1879,7705,485,40720,1518,3,217,1,11561.83,NULL,'2023-01-19 08:24:39','2023-01-19 08:24:39',NULL),(1880,7705,485,40720,1518,3,68,1,2427.98,NULL,'2023-01-19 08:24:39','2023-01-19 08:24:39',NULL),(1881,7705,485,40720,1518,3,224,1,1261.19,NULL,'2023-01-19 08:24:39','2023-01-19 08:24:39',NULL),(1882,7705,485,40720,1518,3,57,2,15251.00,NULL,'2023-01-19 08:24:39','2023-01-19 08:24:39',NULL),(1883,7705,486,40720,1518,3,217,1,2263.48,NULL,'2023-01-19 08:25:07','2023-01-19 08:25:07',NULL),(1884,7705,486,40720,1518,3,68,1,475.33,NULL,'2023-01-19 08:25:07','2023-01-19 08:25:07',NULL),(1885,7705,486,40720,1518,3,224,1,261.18,NULL,'2023-01-19 08:25:07','2023-01-19 08:25:07',NULL),(1886,7705,486,40720,1518,3,57,2,2999.99,NULL,'2023-01-19 08:25:07','2023-01-19 08:25:07',NULL),(1887,7705,487,40720,1518,3,217,1,3017.98,NULL,'2023-01-19 08:25:34','2023-01-19 08:25:34',NULL),(1888,7705,487,40720,1518,3,68,1,633.78,NULL,'2023-01-19 08:25:34','2023-01-19 08:25:34',NULL),(1889,7705,487,40720,1518,3,224,1,348.24,NULL,'2023-01-19 08:25:34','2023-01-19 08:25:34',NULL),(1890,7705,487,40720,1518,3,57,2,4000.00,NULL,'2023-01-19 08:25:34','2023-01-19 08:25:34',NULL),(1891,7705,488,40720,1518,3,217,1,7641.18,NULL,'2023-01-19 08:25:59','2023-01-19 08:25:59',NULL),(1892,7705,488,40720,1518,3,68,1,1604.65,NULL,'2023-01-19 08:25:59','2023-01-19 08:25:59',NULL),(1893,7705,488,40720,1518,3,224,1,754.16,NULL,'2023-01-19 08:25:59','2023-01-19 08:25:59',NULL),(1894,7705,488,40720,1518,3,57,2,9999.99,NULL,'2023-01-19 08:25:59','2023-01-19 08:25:59',NULL),(1895,7705,489,40720,1518,3,217,1,1570.00,NULL,'2023-01-19 08:27:24','2023-01-19 08:27:24',NULL),(1896,7705,489,40720,1518,3,68,1,329.70,NULL,'2023-01-19 08:27:24','2023-01-19 08:27:24',NULL),(1897,7705,489,40720,1518,3,57,2,1899.70,NULL,'2023-01-19 08:27:24','2023-01-19 08:27:24',NULL),(1898,7705,490,40720,1518,3,217,1,1570.00,NULL,'2023-01-19 08:27:59','2023-01-19 08:27:59',NULL),(1899,7705,490,40720,1518,3,68,1,329.70,NULL,'2023-01-19 08:27:59','2023-01-19 08:27:59',NULL),(1900,7705,490,40720,1518,3,57,2,1899.70,NULL,'2023-01-19 08:27:59','2023-01-19 08:27:59',NULL),(1901,7705,491,40720,1518,3,217,1,3918.63,NULL,'2023-01-19 08:29:10','2023-01-19 08:29:10',NULL),(1902,7705,491,40720,1518,3,68,1,822.91,NULL,'2023-01-19 08:29:10','2023-01-19 08:29:10',NULL);
INSERT INTO `balance_libro_details` VALUES (1903,7705,491,40720,1518,3,57,2,4741.54,NULL,'2023-01-19 08:29:10','2023-01-19 08:29:10',NULL),(1904,7705,492,40720,1518,3,217,1,2884.29,NULL,'2023-01-19 08:30:42','2023-01-19 08:30:42',NULL),(1905,7705,492,40720,1518,3,68,1,605.70,NULL,'2023-01-19 08:30:42','2023-01-19 08:30:42',NULL),(1906,7705,492,40720,1518,3,57,2,3489.99,NULL,'2023-01-19 08:30:42','2023-01-19 08:30:42',NULL),(1907,7705,493,40720,1518,3,217,1,3017.98,NULL,'2023-01-19 08:32:45','2023-01-19 08:32:45',NULL),(1908,7705,493,40720,1518,3,68,1,633.78,NULL,'2023-01-19 08:32:45','2023-01-19 08:32:45',NULL),(1909,7705,493,40720,1518,3,224,1,348.24,NULL,'2023-01-19 08:32:45','2023-01-19 08:32:45',NULL),(1910,7705,493,40720,1518,3,57,2,4000.00,NULL,'2023-01-19 08:32:45','2023-01-19 08:32:45',NULL),(1911,7705,494,40720,1518,3,217,1,3017.98,NULL,'2023-01-19 08:33:19','2023-01-19 08:33:19',NULL),(1912,7705,494,40720,1518,3,68,1,633.78,NULL,'2023-01-19 08:33:19','2023-01-19 08:33:19',NULL),(1913,7705,494,40720,1518,3,224,1,348.24,NULL,'2023-01-19 08:33:19','2023-01-19 08:33:19',NULL),(1914,7705,494,40720,1518,3,57,2,4000.00,NULL,'2023-01-19 08:33:19','2023-01-19 08:33:19',NULL),(1915,7705,495,40720,1518,3,217,1,11317.44,NULL,'2023-01-19 08:33:50','2023-01-19 08:33:50',NULL),(1916,7705,495,40720,1518,3,68,1,2376.66,NULL,'2023-01-19 08:33:50','2023-01-19 08:33:50',NULL),(1917,7705,495,40720,1518,3,224,1,1305.89,NULL,'2023-01-19 08:33:50','2023-01-19 08:33:50',NULL),(1918,7705,495,40720,1518,3,57,2,14999.99,NULL,'2023-01-19 08:33:50','2023-01-19 08:33:50',NULL),(1919,7705,496,40720,1518,3,217,1,3017.98,NULL,'2023-01-19 08:34:22','2023-01-19 08:34:22',NULL),(1920,7705,496,40720,1518,3,68,1,633.78,NULL,'2023-01-19 08:34:22',