-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-27178730-3
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=964 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-07-29 18:55:15','Actividad Generica 1','000001',NULL),(2,NULL,'2022-07-29 18:55:15','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,'2022-07-30 16:24:12','Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200','432200'),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,'2022-07-30 13:27:08','Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900','821900'),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,'2022-07-29 20:12:16','Servicios generales de la Administración Pública','841100','841100'),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,'2022-07-30 19:12:44','Servicios personales n.c.p.','960990','960990'),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL),(963,'2022-07-29 20:33:22','2022-07-29 20:33:22','Servicios BA','841100','841100');
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'Flor056544',NULL,1,40722,'2022-07-29'),(2,NULL,'Flor056544',NULL,1,40722,'2022-07-29'),(3,NULL,'Flor056544',NULL,1,40722,'2022-07-29'),(4,NULL,'Flor056544',NULL,1,40722,'2022-07-29'),(5,NULL,'Flor056544',NULL,1,40722,'2022-07-29'),(6,NULL,'Flor056544',NULL,1,40722,'2022-07-29'),(7,NULL,'Flor056544',NULL,1,40722,'2022-07-29'),(8,NULL,'Flor056544',NULL,1,40722,'2022-07-29'),(9,NULL,'Flor056544',NULL,1,40722,'2022-07-29'),(10,NULL,'Flor056544',NULL,1,40722,'2022-07-29'),(11,NULL,'Flor056544',NULL,1,40722,'2022-07-30'),(12,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(13,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(14,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(15,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(16,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(17,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(18,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(19,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(20,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(21,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(22,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(23,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(24,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(25,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(26,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(27,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(28,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(29,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(30,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(31,NULL,'Lasheras1790*',NULL,1,40719,'2022-07-30'),(32,NULL,'Impuestos2022',NULL,1,40748,'2022-07-30'),(33,NULL,'Impuestos2022',NULL,1,40748,'2022-07-30'),(34,NULL,'Impuestos2022',NULL,1,40727,'2022-08-01'),(35,NULL,'Impuestos2022',NULL,1,40727,'2022-08-01'),(36,NULL,'Impuestos2022',NULL,1,40727,'2022-08-01'),(37,NULL,'Impuestos2022',NULL,1,40727,'2022-08-02'),(38,NULL,'Lasheras1790*',NULL,1,40719,'2022-08-02'),(39,NULL,'Impuestos2022',NULL,1,40748,'2022-08-02'),(40,NULL,'Impuestos2022',NULL,1,40748,'2022-08-11'),(41,NULL,'Impuestos2022',NULL,1,40748,'2022-08-11'),(42,NULL,'Lasheras1790*',NULL,1,40719,'2023-06-30');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'vag730@gmail.com','1166554433',NULL,1,40719,'2022-07-30'),(2,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(3,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(4,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(5,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(6,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(7,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(8,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(9,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(10,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(11,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(12,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(13,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(14,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(15,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(16,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(17,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(18,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(19,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(20,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(21,'vag730@gmail.com','1166554433','',1,40719,'2022-07-30'),(22,'vag730@gmail.com','1166554433','',1,40719,'2022-08-02'),(23,'vag730@gmail.com','1166554433','',1,40719,'2023-06-30');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=375 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7479,40722,4532,2,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',114134.00,NULL,NULL,1,'2022-07-29 19:26:36','2022-07-29 20:20:19','2022-07-29 20:20:19'),(2,7479,40722,4532,2,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',107000.00,NULL,NULL,1,'2022-07-29 19:26:36','2022-07-29 20:20:06','2022-07-29 20:20:06'),(3,7479,40722,4532,2,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',114134.00,NULL,NULL,1,'2022-07-29 19:26:36','2022-07-29 20:19:55','2022-07-29 20:19:55'),(4,7479,40722,4532,2,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',107000.00,NULL,NULL,1,'2022-07-29 19:26:36','2022-07-29 20:19:36','2022-07-29 20:19:36'),(5,7479,40722,4532,3,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',1910.34,NULL,NULL,1,'2022-07-29 19:28:35','2022-08-02 18:57:56','2022-08-02 18:57:56'),(6,7479,40722,4532,3,6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',7710.00,NULL,NULL,1,'2022-07-29 19:28:35','2022-08-02 18:57:56','2022-08-02 18:57:56'),(7,7479,40722,4532,2,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',107000.00,NULL,NULL,1,'2022-07-29 20:19:36','2022-08-02 18:57:51','2022-08-02 18:57:51'),(8,7479,40722,4532,2,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',114134.00,NULL,NULL,1,'2022-07-29 20:19:55','2022-08-02 18:57:51','2022-08-02 18:57:51'),(9,7479,40722,4532,2,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',107000.00,NULL,NULL,1,'2022-07-29 20:20:06','2022-08-02 18:57:51','2022-08-02 18:57:51'),(10,7479,40722,4532,2,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',114134.00,NULL,NULL,1,'2022-07-29 20:20:19','2022-08-02 18:57:51','2022-08-02 18:57:51'),(11,7479,40719,8,2,7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',1000.00,NULL,NULL,1,'2022-07-29 22:54:43','2022-07-29 23:20:05','2022-07-29 23:20:05'),(12,7479,40719,8,2,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',1000.00,NULL,NULL,1,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(13,7479,40719,8,2,9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',1000.00,NULL,NULL,1,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(14,7479,40719,8,2,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(15,7479,40719,8,2,11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',700.00,NULL,NULL,1,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(16,7479,40719,8,2,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-29 22:54:43','2022-07-29 22:55:57','2022-07-29 22:55:57'),(17,7479,40719,8,2,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',2000.00,NULL,NULL,1,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(18,7479,40719,8,2,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(19,7479,40719,8,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',1800.00,NULL,NULL,1,'2022-07-29 22:54:43','2022-07-29 23:19:50','2022-07-29 23:19:50'),(20,7479,40719,8,2,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',2000.00,NULL,NULL,1,'2022-07-29 22:54:43','2022-07-29 23:19:46','2022-07-29 23:19:46'),(21,7479,40719,8,2,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',1400.00,NULL,NULL,1,'2022-07-29 22:54:43','2022-07-29 23:19:42','2022-07-29 23:19:42'),(22,7479,40719,8,2,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',700.00,NULL,NULL,1,'2022-07-29 22:54:43','2022-07-29 23:19:38','2022-07-29 23:19:38'),(23,7479,40719,8,2,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',1000.00,NULL,NULL,1,'2022-07-29 22:54:43','2022-07-29 23:19:34','2022-07-29 23:19:34');
INSERT INTO `balance_libro` VALUES (24,7479,40719,8,2,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-29 22:55:57','2022-07-29 23:20:06','2022-07-29 23:20:06'),(25,7479,40719,8,8,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',19.36,NULL,NULL,1,'2022-07-30 11:22:22','2022-07-30 16:07:17','2022-07-30 16:07:17'),(26,7479,40719,8,8,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',23.64,NULL,NULL,1,'2022-07-30 11:22:22','2022-07-30 16:07:17','2022-07-30 16:07:17'),(27,7479,40719,8,2,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',1000.00,NULL,NULL,1,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(28,7479,40719,8,2,23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',1000.00,NULL,NULL,1,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(29,7479,40719,8,2,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',1000.00,NULL,NULL,1,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(30,7479,40719,8,2,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-30 11:23:29','2022-07-30 11:26:42','2022-07-30 11:26:42'),(31,7479,40719,8,2,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',700.00,NULL,NULL,1,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(32,7479,40719,8,2,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-30 11:23:29','2022-07-30 11:26:16','2022-07-30 11:26:16'),(33,7479,40719,8,2,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',2000.00,NULL,NULL,1,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(34,7479,40719,8,2,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(35,7479,40719,8,2,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',1800.00,NULL,NULL,1,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(36,7479,40719,8,2,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',2000.00,NULL,NULL,1,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(37,7479,40719,8,2,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',1400.00,NULL,NULL,1,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(38,7479,40719,8,2,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',700.00,NULL,NULL,1,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(39,7479,40719,8,2,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',1000.00,NULL,NULL,1,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(40,7479,40719,8,3,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',520.00,NULL,NULL,1,'2022-07-30 11:23:49','2022-07-30 13:18:42','2022-07-30 13:18:42'),(41,7479,40719,8,2,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-30 11:26:16','2022-07-30 12:30:19','2022-07-30 12:30:19'),(42,7479,40719,8,2,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-30 11:26:42','2022-07-30 12:30:19','2022-07-30 12:30:19'),(43,7479,40719,9,2,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-07-30 12:20:39','2022-07-30 12:30:29','2022-07-30 12:30:29'),(44,7479,40719,9,2,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 12:20:39','2022-07-30 12:30:30','2022-07-30 12:30:30'),(45,7479,40719,9,2,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',700.00,NULL,NULL,1,'2022-07-30 12:20:39','2022-07-30 12:30:30','2022-07-30 12:30:30'),(46,7479,40719,9,2,39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30');
INSERT INTO `balance_libro` VALUES (47,7479,40719,9,2,40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(48,7479,40719,9,2,41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6000.00,NULL,NULL,1,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(49,7479,40719,9,2,42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(50,7479,40719,9,2,43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(51,7479,40719,9,2,44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',800.00,NULL,NULL,1,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(52,7479,40719,9,2,45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(53,7479,40719,9,2,46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',3000.00,NULL,NULL,1,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(54,7479,40719,9,2,47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',1000.00,NULL,NULL,1,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(55,7479,40719,9,2,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1000.00,NULL,NULL,1,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(56,7479,40719,9,2,49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3000.00,NULL,NULL,1,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(57,7479,40719,9,2,50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(58,7479,40719,9,2,51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',800.00,NULL,NULL,1,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(59,7479,40719,9,2,52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(60,7479,40719,9,2,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(61,7479,40719,9,2,54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(62,7479,40719,9,2,55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',700.00,NULL,NULL,1,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(63,7479,40719,9,2,56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(64,7479,40719,9,2,57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(65,7479,40719,9,2,58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6000.00,NULL,NULL,1,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(66,7479,40719,9,2,59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(67,7479,40719,9,2,60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(68,7479,40719,9,2,61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',800.00,NULL,NULL,1,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(69,7479,40719,9,2,62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03');
INSERT INTO `balance_libro` VALUES (70,7479,40719,9,2,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',3000.00,NULL,NULL,1,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(71,7479,40719,9,2,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',1000.00,NULL,NULL,1,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(72,7479,40719,9,2,65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1000.00,NULL,NULL,1,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(73,7479,40719,9,2,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3000.00,NULL,NULL,1,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(74,7479,40719,9,2,67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(75,7479,40719,9,2,68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',800.00,NULL,NULL,1,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(76,7479,40719,9,2,69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(77,7479,40719,8,2,70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',1000.00,NULL,NULL,1,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(78,7479,40719,8,2,71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',1000.00,NULL,NULL,1,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(79,7479,40719,8,2,72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',1000.00,NULL,NULL,1,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(80,7479,40719,8,2,73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(81,7479,40719,8,2,74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',700.00,NULL,NULL,1,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(82,7479,40719,8,2,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(83,7479,40719,8,2,76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',2000.00,NULL,NULL,1,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(84,7479,40719,8,2,77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(85,7479,40719,8,2,78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',1800.00,NULL,NULL,1,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(86,7479,40719,8,2,79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',2000.00,NULL,NULL,1,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(87,7479,40719,8,2,80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',1400.00,NULL,NULL,1,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(88,7479,40719,8,2,81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',700.00,NULL,NULL,1,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(89,7479,40719,8,2,82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',1000.00,NULL,NULL,1,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(90,7479,40719,8,2,83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',1000.00,NULL,NULL,1,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(91,7479,40719,8,2,84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',1000.00,NULL,NULL,1,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(92,7479,40719,8,2,85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',1000.00,NULL,NULL,1,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17');
INSERT INTO `balance_libro` VALUES (93,7479,40719,8,2,86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(94,7479,40719,8,2,87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',700.00,NULL,NULL,1,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(95,7479,40719,8,2,88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(96,7479,40719,8,2,89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',2000.00,NULL,NULL,1,'2022-07-30 13:30:31','2022-07-30 13:35:18','2022-07-30 13:35:18'),(97,7479,40719,8,2,90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-30 13:30:31','2022-07-30 13:35:18','2022-07-30 13:35:18'),(98,7479,40719,8,2,91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',1800.00,NULL,NULL,1,'2022-07-30 13:30:31','2022-07-30 13:35:18','2022-07-30 13:35:18'),(99,7479,40719,8,2,92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',2000.00,NULL,NULL,1,'2022-07-30 13:30:32','2022-07-30 13:35:18','2022-07-30 13:35:18'),(100,7479,40719,8,2,93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',1400.00,NULL,NULL,1,'2022-07-30 13:30:32','2022-07-30 13:35:18','2022-07-30 13:35:18'),(101,7479,40719,8,2,94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',700.00,NULL,NULL,1,'2022-07-30 13:30:32','2022-07-30 13:35:18','2022-07-30 13:35:18'),(102,7479,40719,8,2,95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',1000.00,NULL,NULL,1,'2022-07-30 13:30:32','2022-07-30 13:35:18','2022-07-30 13:35:18'),(103,7479,40719,8,3,96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',520.00,NULL,NULL,1,'2022-07-30 13:30:46','2022-07-30 14:16:08','2022-07-30 14:16:08'),(104,7479,40719,8,2,97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',1000.00,NULL,NULL,1,'2022-07-30 13:35:51','2022-07-30 13:40:56','2022-07-30 13:40:56'),(105,7479,40719,8,2,98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',1000.00,NULL,NULL,1,'2022-07-30 13:35:51','2022-07-30 13:40:53','2022-07-30 13:40:53'),(106,7479,40719,8,2,99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',1000.00,NULL,NULL,1,'2022-07-30 13:35:51','2022-07-30 13:40:49','2022-07-30 13:40:49'),(107,7479,40719,8,2,100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-30 13:35:51','2022-07-30 13:40:37','2022-07-30 13:40:37'),(108,7479,40719,8,2,101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',700.00,NULL,NULL,1,'2022-07-30 13:35:51','2022-07-30 13:40:45','2022-07-30 13:40:45'),(109,7479,40719,8,2,102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-30 13:35:51','2022-07-30 13:40:41','2022-07-30 13:40:41'),(110,7479,40719,8,2,103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',2000.00,NULL,NULL,1,'2022-07-30 13:35:51','2022-07-30 13:41:00','2022-07-30 13:41:00'),(111,7479,40719,8,2,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-30 13:35:51','2022-07-30 13:41:04','2022-07-30 13:41:04'),(112,7479,40719,8,2,105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',1800.00,NULL,NULL,1,'2022-07-30 13:35:51','2022-07-30 13:41:08','2022-07-30 13:41:08'),(113,7479,40719,8,2,106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',2000.00,NULL,NULL,1,'2022-07-30 13:35:51','2022-07-30 13:41:12','2022-07-30 13:41:12'),(114,7479,40719,8,2,107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',1400.00,NULL,NULL,1,'2022-07-30 13:35:51','2022-07-30 13:41:15','2022-07-30 13:41:15'),(115,7479,40719,8,2,108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',700.00,NULL,NULL,1,'2022-07-30 13:35:51','2022-07-30 13:41:19','2022-07-30 13:41:19');
INSERT INTO `balance_libro` VALUES (116,7479,40719,8,2,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',1000.00,NULL,NULL,1,'2022-07-30 13:35:51','2022-07-30 13:42:12','2022-07-30 13:42:12'),(117,7479,40719,8,2,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',1000.00,NULL,NULL,1,'2022-07-30 13:42:12','2022-07-30 13:47:34','2022-07-30 13:47:34'),(118,7479,40719,8,2,110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',1000.00,NULL,NULL,1,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(119,7479,40719,8,2,111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',1000.00,NULL,NULL,1,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(120,7479,40719,8,2,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',1000.00,NULL,NULL,1,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(121,7479,40719,8,2,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-30 13:48:32','2022-07-30 14:03:39','2022-07-30 14:03:39'),(122,7479,40719,8,2,114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',700.00,NULL,NULL,1,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(123,7479,40719,8,2,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-30 13:48:32','2022-07-30 14:03:18','2022-07-30 14:03:18'),(124,7479,40719,8,2,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',2000.00,NULL,NULL,1,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(125,7479,40719,8,2,117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(126,7479,40719,8,2,118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',1800.00,NULL,NULL,1,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(127,7479,40719,8,2,119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',2000.00,NULL,NULL,1,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(128,7479,40719,8,2,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',1400.00,NULL,NULL,1,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(129,7479,40719,8,2,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',700.00,NULL,NULL,1,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(130,7479,40719,8,2,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',1000.00,NULL,NULL,1,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(131,7479,40719,8,2,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-30 14:03:18','2022-07-30 14:15:59','2022-07-30 14:15:59'),(132,7479,40719,8,2,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',1000.00,NULL,NULL,1,'2022-07-30 14:03:39','2022-07-30 14:15:59','2022-07-30 14:15:59'),(133,7479,40719,9,2,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(134,7479,40719,9,2,124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(135,7479,40719,9,2,125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',700.00,NULL,NULL,1,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(136,7479,40719,9,2,126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(137,7479,40719,9,2,127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(138,7479,40719,9,2,128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6000.00,NULL,NULL,1,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28');
INSERT INTO `balance_libro` VALUES (139,7479,40719,9,2,129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(140,7479,40719,9,2,130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(141,7479,40719,9,2,131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',800.00,NULL,NULL,1,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(142,7479,40719,9,2,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(143,7479,40719,9,2,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',3000.00,NULL,NULL,1,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(144,7479,40719,9,2,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',1000.00,NULL,NULL,1,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(145,7479,40719,9,2,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1000.00,NULL,NULL,1,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(146,7479,40719,9,2,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3000.00,NULL,NULL,1,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(147,7479,40719,9,2,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(148,7479,40719,9,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',800.00,NULL,NULL,1,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(149,7479,40719,9,2,139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(150,7479,40719,9,2,140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(151,7479,40719,9,2,141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(152,7479,40719,9,2,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',700.00,NULL,NULL,1,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(153,7479,40719,9,2,143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(154,7479,40719,9,2,144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(155,7479,40719,9,2,145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6000.00,NULL,NULL,1,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(156,7479,40719,9,2,146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(157,7479,40719,9,2,147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(158,7479,40719,9,2,148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',800.00,NULL,NULL,1,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(159,7479,40719,9,2,149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(160,7479,40719,9,2,150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',3000.00,NULL,NULL,1,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(161,7479,40719,9,2,151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',1000.00,NULL,NULL,1,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44');
INSERT INTO `balance_libro` VALUES (162,7479,40719,9,2,152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1000.00,NULL,NULL,1,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44'),(163,7479,40719,9,2,153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3000.00,NULL,NULL,1,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44'),(164,7479,40719,9,2,154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44'),(165,7479,40719,9,2,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',800.00,NULL,NULL,1,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44'),(166,7479,40719,9,2,156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44'),(167,7479,40719,9,2,157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-07-30 14:28:08','2022-07-30 15:46:07','2022-07-30 15:46:07'),(168,7479,40719,9,2,158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 14:28:08','2022-07-30 15:46:07','2022-07-30 15:46:07'),(169,7479,40719,9,2,159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',700.00,NULL,NULL,1,'2022-07-30 14:28:08','2022-07-30 15:46:07','2022-07-30 15:46:07'),(170,7479,40719,9,2,160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(171,7479,40719,9,2,161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(172,7479,40719,9,2,162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6000.00,NULL,NULL,1,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(173,7479,40719,9,2,163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(174,7479,40719,9,2,164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(175,7479,40719,9,2,165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',800.00,NULL,NULL,1,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(176,7479,40719,9,2,166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(177,7479,40719,9,2,167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',3000.00,NULL,NULL,1,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(178,7479,40719,9,2,168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',1000.00,NULL,NULL,1,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(179,7479,40719,9,2,169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1000.00,NULL,NULL,1,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(180,7479,40719,9,2,170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3000.00,NULL,NULL,1,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(181,7479,40719,9,2,171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(182,7479,40719,9,2,172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',800.00,NULL,NULL,1,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(183,7479,40719,9,2,173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(184,7479,40719,9,2,174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34');
INSERT INTO `balance_libro` VALUES (185,7479,40719,9,2,175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 15:51:22','2022-07-30 15:53:14','2022-07-30 15:53:14'),(186,7479,40719,9,2,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',700.00,NULL,NULL,1,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(187,7479,40719,9,2,177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(188,7479,40719,9,2,178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(189,7479,40719,9,2,179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6000.00,NULL,NULL,1,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(190,7479,40719,9,2,180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(191,7479,40719,9,2,181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(192,7479,40719,9,2,182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',800.00,NULL,NULL,1,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(193,7479,40719,9,2,183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(194,7479,40719,9,2,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',3000.00,NULL,NULL,1,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(195,7479,40719,9,2,185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',1000.00,NULL,NULL,1,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(196,7479,40719,9,2,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1000.00,NULL,NULL,1,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(197,7479,40719,9,2,187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3000.00,NULL,NULL,1,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(198,7479,40719,9,2,188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(199,7479,40719,9,2,189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',800.00,NULL,NULL,1,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(200,7479,40719,9,2,190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(201,7479,40719,9,2,175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 15:53:14','2022-07-30 15:57:34','2022-07-30 15:57:34'),(202,7479,40719,9,2,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(203,7479,40719,9,2,192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(204,7479,40719,9,2,193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',700.00,NULL,NULL,1,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(205,7479,40719,9,2,194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(206,7479,40719,9,2,195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(207,7479,40719,9,2,196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6000.00,NULL,NULL,1,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09');
INSERT INTO `balance_libro` VALUES (208,7479,40719,9,2,197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(209,7479,40719,9,2,198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(210,7479,40719,9,2,199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',800.00,NULL,NULL,1,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(211,7479,40719,9,2,200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(212,7479,40719,9,2,201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',3000.00,NULL,NULL,1,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(213,7479,40719,9,2,202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',1000.00,NULL,NULL,1,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(214,7479,40719,9,2,203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1000.00,NULL,NULL,1,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(215,7479,40719,9,2,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3000.00,NULL,NULL,1,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(216,7479,40719,9,2,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-07-30 16:00:50','2022-07-30 16:07:09','2022-07-30 16:07:09'),(217,7479,40719,9,2,206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',800.00,NULL,NULL,1,'2022-07-30 16:00:50','2022-07-30 16:07:09','2022-07-30 16:07:09'),(218,7479,40719,9,2,207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-07-30 16:00:50','2022-07-30 16:07:09','2022-07-30 16:07:09'),(219,7479,40719,9,2,208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(220,7479,40719,9,2,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(221,7479,40719,9,2,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',700.00,NULL,NULL,1,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(222,7479,40719,9,2,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(223,7479,40719,9,2,212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(224,7479,40719,9,2,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6000.00,NULL,NULL,1,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(225,7479,40719,9,2,214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(226,7479,40719,9,2,215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(227,7479,40719,9,2,216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',800.00,NULL,NULL,1,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(228,7479,40719,9,2,217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(229,7479,40719,9,2,218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',3000.00,NULL,NULL,1,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(230,7479,40719,9,2,219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',1000.00,NULL,NULL,1,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03');
INSERT INTO `balance_libro` VALUES (231,7479,40719,9,2,220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1000.00,NULL,NULL,1,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(232,7479,40719,9,2,221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3000.00,NULL,NULL,1,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(233,7479,40719,9,2,222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(234,7479,40719,9,2,223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',800.00,NULL,NULL,1,'2022-07-30 16:09:43','2022-07-30 16:19:03','2022-07-30 16:19:03'),(235,7479,40719,9,2,224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-07-30 16:09:43','2022-07-30 16:19:03','2022-07-30 16:19:03'),(236,7479,40748,6121,2,225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',56000.00,NULL,NULL,1,'2022-07-30 16:29:21','2022-07-30 18:55:49','2022-07-30 18:55:49'),(237,7479,40748,6121,2,226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',15000.00,NULL,NULL,1,'2022-07-30 16:29:21','2022-07-30 18:55:49','2022-07-30 18:55:49'),(238,7479,40748,6121,2,227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',20000.00,NULL,NULL,1,'2022-07-30 16:29:21','2022-07-30 18:55:49','2022-07-30 18:55:49'),(239,7479,40748,6121,2,228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',15000.00,NULL,NULL,1,'2022-07-30 16:29:21','2022-07-30 18:55:49','2022-07-30 18:55:49'),(240,7479,40748,7707,2,229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',27000.00,NULL,NULL,1,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18'),(241,7479,40748,7707,2,230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',25000.00,NULL,NULL,1,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18'),(242,7479,40748,7707,2,231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',36000.00,NULL,NULL,1,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18'),(243,7479,40748,7707,2,232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',75000.00,NULL,NULL,1,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18'),(244,7479,40748,7707,2,233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',6000.00,NULL,NULL,1,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18'),(245,7479,40748,7707,2,234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',0.00,NULL,NULL,1,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(246,7479,40748,7707,2,235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',0.00,NULL,NULL,1,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(247,7479,40748,7707,2,236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',0.00,NULL,NULL,1,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(248,7479,40748,7707,2,237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',0.00,NULL,NULL,1,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(249,7479,40748,7707,2,238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',0.00,NULL,NULL,1,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(250,7479,40748,7707,2,239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',27000.00,NULL,NULL,1,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49'),(251,7479,40748,7707,2,240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',25000.00,NULL,NULL,1,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49'),(252,7479,40748,7707,2,241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',36000.00,NULL,NULL,1,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49');
INSERT INTO `balance_libro` VALUES (253,7479,40748,7707,2,242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',75000.00,NULL,NULL,1,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49'),(254,7479,40748,7707,2,243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',6000.00,NULL,NULL,1,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49'),(255,7479,40748,7707,2,244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',27000.00,NULL,NULL,1,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(256,7479,40748,7707,2,245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',25000.00,NULL,NULL,1,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(257,7479,40748,7707,2,246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',36000.00,NULL,NULL,1,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(258,7479,40748,7707,2,247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',75000.00,NULL,NULL,1,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(259,7479,40748,7707,2,248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',6000.00,NULL,NULL,1,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(260,7479,40727,7710,2,249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',176600.00,NULL,NULL,1,'2022-07-30 19:15:16','2022-08-01 18:59:34','2022-08-01 18:59:34'),(261,7479,40727,7710,3,250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',43.59,NULL,NULL,1,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(262,7479,40727,7710,3,251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-12','2022-06-12',1000.00,NULL,NULL,1,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(263,7479,40727,7710,3,252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',500.00,NULL,NULL,1,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(264,7479,40727,7710,3,253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',41998.00,NULL,NULL,1,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(265,7479,40727,7710,3,254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',4999.00,NULL,NULL,1,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(266,7479,40727,7710,3,255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',12499.00,NULL,NULL,1,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(267,7479,40727,7710,2,249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',176600.00,NULL,NULL,1,'2022-08-01 18:59:34','2022-08-01 19:56:34','2022-08-01 19:56:34'),(268,7479,40727,7710,2,256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',176600.00,NULL,NULL,1,'2022-08-01 19:57:38','2022-08-01 20:01:30','2022-08-01 20:01:30'),(269,7479,40727,7710,2,257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',176600.00,NULL,NULL,1,'2022-08-01 20:03:12','2022-08-01 20:11:56','2022-08-01 20:11:56'),(270,7479,40727,7710,2,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',176600.00,NULL,NULL,1,'2022-08-01 20:25:12','2022-08-01 20:25:52','2022-08-01 20:25:52'),(271,7479,40727,7710,2,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',176600.00,NULL,NULL,1,'2022-08-01 20:25:52','2022-08-01 20:26:48','2022-08-01 20:26:48'),(272,7479,40727,7710,2,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',176600.00,NULL,NULL,1,'2022-08-01 20:26:48','2022-08-01 20:26:56','2022-08-01 20:26:56'),(273,7479,40727,7710,2,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',176600.00,NULL,NULL,1,'2022-08-01 20:26:56','2022-08-01 20:27:34','2022-08-01 20:27:34'),(274,7479,40727,7710,2,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',176600.00,NULL,NULL,1,'2022-08-01 20:27:34','2022-08-02 18:38:32','2022-08-02 18:38:32'),(275,7479,40727,7711,2,259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',176600.00,NULL,NULL,1,'2022-08-02 18:31:06','2022-08-02 18:38:28','2022-08-02 18:38:28');
INSERT INTO `balance_libro` VALUES (276,7479,40727,7711,2,261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',176600.00,NULL,NULL,1,'2022-08-02 18:46:50','2022-08-04 21:51:28','2022-08-04 21:51:28'),(277,7479,40722,4533,2,262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',17120.00,NULL,NULL,1,'2022-08-02 18:56:19','2022-08-02 18:57:51','2022-08-02 18:57:51'),(278,7479,40722,4533,2,263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-03','2022-07-03',124120.00,NULL,NULL,1,'2022-08-02 18:56:19','2022-08-02 18:57:51','2022-08-02 18:57:51'),(279,7479,40719,9,2,264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(280,7479,40719,9,2,265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(281,7479,40719,9,2,266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',700.00,NULL,NULL,1,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(282,7479,40719,9,2,267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(283,7479,40719,9,2,268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(284,7479,40719,9,2,269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6000.00,NULL,NULL,1,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(285,7479,40719,9,2,270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(286,7479,40719,9,2,271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(287,7479,40719,9,2,272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',800.00,NULL,NULL,1,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(288,7479,40719,9,2,273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(289,7479,40719,9,2,274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',3000.00,NULL,NULL,1,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(290,7479,40719,9,2,275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',1000.00,NULL,NULL,1,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(291,7479,40719,9,2,276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1000.00,NULL,NULL,1,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(292,7479,40719,9,2,277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3000.00,NULL,NULL,1,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(293,7479,40719,9,2,278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(294,7479,40719,9,2,279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',800.00,NULL,NULL,1,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(295,7479,40719,9,2,280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(296,7479,40748,6121,2,281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',56000.00,NULL,NULL,1,'2022-08-02 20:20:13','2022-08-02 20:22:12','2022-08-02 20:22:12'),(297,7479,40748,6121,2,282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',15000.00,NULL,NULL,1,'2022-08-02 20:20:13','2022-08-02 20:22:12','2022-08-02 20:22:12'),(298,7479,40748,6121,2,283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',20000.00,NULL,NULL,1,'2022-08-02 20:20:13','2022-08-02 20:22:12','2022-08-02 20:22:12');
INSERT INTO `balance_libro` VALUES (299,7479,40748,6121,2,284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',15000.00,NULL,NULL,1,'2022-08-02 20:20:13','2022-08-02 20:22:12','2022-08-02 20:22:12'),(300,7479,40727,7711,2,289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',176600.00,NULL,NULL,1,'2022-08-04 21:54:19','2022-08-04 22:00:22','2022-08-04 22:00:22'),(301,7479,40727,7711,2,290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',176600.00,NULL,NULL,1,'2022-08-04 22:01:23','2022-08-04 22:04:12','2022-08-04 22:04:12'),(302,7479,40727,7711,2,292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',176600.00,NULL,NULL,1,'2022-08-06 11:10:13','2022-08-06 11:17:48','2022-08-06 11:17:48'),(303,7479,40727,7711,2,293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',176600.00,NULL,NULL,1,'2022-08-06 11:26:42','2022-08-11 18:41:16','2022-08-11 18:41:16'),(304,7479,40719,9,2,294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(305,7479,40719,9,2,295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(306,7479,40719,9,2,296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',700.00,NULL,NULL,1,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(307,7479,40719,9,2,297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(308,7479,40719,9,2,298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(309,7479,40719,9,2,299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6000.00,NULL,NULL,1,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(310,7479,40719,9,2,300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(311,7479,40719,9,2,301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(312,7479,40719,9,2,302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',800.00,NULL,NULL,1,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(313,7479,40719,9,2,303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(314,7479,40719,9,2,304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',3000.00,NULL,NULL,1,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(315,7479,40719,9,2,305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',1000.00,NULL,NULL,1,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(316,7479,40719,9,2,306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1000.00,NULL,NULL,1,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(317,7479,40719,9,2,307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3000.00,NULL,NULL,1,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(318,7479,40719,9,2,308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-08-11 18:14:45','2022-08-11 18:27:44','2022-08-11 18:27:44'),(319,7479,40719,9,2,309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',800.00,NULL,NULL,1,'2022-08-11 18:14:45','2022-08-11 18:27:36','2022-08-11 18:27:36'),(320,7479,40719,9,2,310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-08-11 18:14:45','2022-08-11 18:27:18','2022-08-11 18:27:18'),(321,7479,40719,9,2,310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-08-11 18:27:18','2022-08-11 18:27:52','2022-08-11 18:27:52');
INSERT INTO `balance_libro` VALUES (322,7479,40719,9,2,309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',800.00,NULL,NULL,1,'2022-08-11 18:27:36','2022-08-11 18:27:52','2022-08-11 18:27:52'),(323,7479,40719,9,2,308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-08-11 18:27:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(324,7479,40719,9,2,311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-08-11 18:29:38','2023-06-29 21:42:51','2023-06-29 21:42:51'),(325,7479,40719,9,2,312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-08-11 18:29:38','2023-06-29 21:42:48','2023-06-29 21:42:48'),(326,7479,40719,9,2,313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',700.00,NULL,NULL,1,'2022-08-11 18:29:38','2023-06-29 21:42:44','2023-06-29 21:42:44'),(327,7479,40719,9,2,314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-08-11 18:29:38','2023-06-29 21:42:41','2023-06-29 21:42:41'),(328,7479,40719,9,2,315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-08-11 18:29:38','2023-06-29 21:42:37','2023-06-29 21:42:37'),(329,7479,40719,9,2,316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6000.00,NULL,NULL,1,'2022-08-11 18:29:38','2023-06-29 21:42:32','2023-06-29 21:42:32'),(330,7479,40719,9,2,317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2000.00,NULL,NULL,1,'2022-08-11 18:29:38','2023-06-29 21:42:21','2023-06-29 21:42:21'),(331,7479,40719,9,2,318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-08-11 18:29:38','2023-06-29 21:42:17','2023-06-29 21:42:17'),(332,7479,40719,9,2,319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',800.00,NULL,NULL,1,'2022-08-11 18:29:38','2023-06-29 21:42:14','2023-06-29 21:42:14'),(333,7479,40719,9,2,320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1000.00,NULL,NULL,1,'2022-08-11 18:29:38','2023-06-29 21:42:11','2023-06-29 21:42:11'),(334,7479,40719,9,2,321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',3000.00,NULL,NULL,1,'2022-08-11 18:29:38','2023-06-29 21:42:07','2023-06-29 21:42:07'),(335,7479,40719,9,2,322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',1000.00,NULL,NULL,1,'2022-08-11 18:29:38','2023-06-29 21:42:04','2023-06-29 21:42:04'),(336,7479,40719,9,2,323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1000.00,NULL,NULL,1,'2022-08-11 18:29:38','2023-06-29 21:42:00','2023-06-29 21:42:00'),(337,7479,40719,9,2,324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',3000.00,NULL,NULL,1,'2022-08-11 18:29:38','2023-06-29 21:41:56','2023-06-29 21:41:56'),(338,7479,40719,9,2,325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-08-11 18:29:38','2023-06-29 21:14:24','2023-06-29 21:14:24'),(339,7479,40719,9,2,326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',800.00,NULL,NULL,1,'2022-08-11 18:29:39','2023-06-29 21:14:21','2023-06-29 21:14:21'),(340,7479,40719,9,2,327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1000.00,NULL,NULL,1,'2022-08-11 18:29:39','2023-06-29 21:14:17','2023-06-29 21:14:17'),(341,7479,40727,7711,2,328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',176600.00,NULL,NULL,1,'2022-08-11 18:41:57','2022-08-23 18:32:46','2022-08-23 18:32:46'),(342,7479,40748,6121,2,329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',56000.00,NULL,NULL,1,'2022-08-11 19:03:30','2022-08-12 18:44:46','2022-08-12 18:44:46'),(343,7479,40748,6121,2,330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',15000.00,NULL,NULL,1,'2022-08-11 19:03:30','2022-08-12 18:44:37','2022-08-12 18:44:37'),(344,7479,40748,6121,2,331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',20000.00,NULL,NULL,1,'2022-08-11 19:03:30','2022-08-12 18:44:29','2022-08-12 18:44:29');
INSERT INTO `balance_libro` VALUES (345,7479,40748,6121,2,332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',15000.00,NULL,NULL,1,'2022-08-11 19:03:30','2022-08-12 18:44:21','2022-08-12 18:44:21'),(346,7479,40748,6121,2,332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',15000.00,NULL,NULL,1,'2022-08-12 18:44:21','2022-08-12 18:45:40','2022-08-12 18:45:40'),(347,7479,40748,6121,2,331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',20000.00,NULL,NULL,1,'2022-08-12 18:44:29','2022-08-12 18:45:40','2022-08-12 18:45:40'),(348,7479,40748,6121,2,330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',15000.00,NULL,NULL,1,'2022-08-12 18:44:37','2022-08-12 18:45:40','2022-08-12 18:45:40'),(349,7479,40748,6121,2,329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',56000.00,NULL,NULL,1,'2022-08-12 18:44:46','2022-08-12 18:45:40','2022-08-12 18:45:40'),(350,7479,40748,6121,2,333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',56000.00,NULL,NULL,1,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(351,7479,40748,6121,2,334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',15000.00,NULL,NULL,1,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(352,7479,40748,6121,2,335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',20000.00,NULL,NULL,1,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(353,7479,40748,6121,2,336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',15000.00,NULL,NULL,1,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(354,7479,40719,9,16,NULL,197,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1067.54,NULL,NULL,1,'2022-08-12 19:44:50','2023-06-29 20:54:09','2023-06-29 20:54:09'),(355,7479,40727,7712,2,337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',176600.00,NULL,NULL,1,'2022-08-23 18:35:45','2022-08-23 18:36:27','2022-08-23 18:36:27'),(356,7479,40727,7712,2,337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',176600.00,NULL,NULL,1,'2022-08-23 18:36:27','2022-08-23 18:47:09','2022-08-23 18:47:09'),(357,7479,40727,7712,2,337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',176000.00,NULL,NULL,1,'2022-08-23 18:47:09','2022-08-23 18:47:09',NULL),(358,7479,40719,23,2,338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',3500.00,NULL,NULL,1,'2023-06-29 21:50:05','2023-06-29 21:50:05',NULL),(359,7479,40719,23,2,339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',3500.00,NULL,NULL,1,'2023-06-29 21:50:05','2023-06-29 22:16:53','2023-06-29 22:16:53'),(360,7479,40719,23,2,340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',3500.00,NULL,NULL,1,'2023-06-29 21:50:05','2023-06-29 22:16:49','2023-06-29 22:16:49'),(361,7479,40719,23,2,341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',4000.00,NULL,NULL,1,'2023-06-29 21:50:05','2023-06-29 22:16:46','2023-06-29 22:16:46'),(362,7479,40719,23,2,342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',3500.00,NULL,NULL,1,'2023-06-29 21:50:05','2023-06-29 22:16:42','2023-06-29 22:16:42'),(363,7479,40719,23,2,343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',9500.00,NULL,NULL,1,'2023-06-29 21:50:05','2023-06-29 22:16:39','2023-06-29 22:16:39'),(364,7479,40719,23,2,344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',3500.00,NULL,NULL,1,'2023-06-29 21:50:05','2023-06-29 22:16:34','2023-06-29 22:16:34'),(365,7479,40719,23,2,345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-18','2023-06-18',10000.00,NULL,NULL,1,'2023-06-29 21:50:06','2023-06-29 22:00:49','2023-06-29 22:00:49'),(366,7479,40719,23,2,346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-20','2023-06-20',3500.00,NULL,NULL,1,'2023-06-29 21:50:06','2023-06-29 22:16:28','2023-06-29 22:16:28'),(367,7479,40719,23,2,347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',3500.00,NULL,NULL,1,'2023-06-29 21:50:06','2023-06-29 22:16:24','2023-06-29 22:16:24');
INSERT INTO `balance_libro` VALUES (368,7479,40719,23,2,348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',3500.00,NULL,NULL,1,'2023-06-29 21:50:06','2023-06-29 22:16:20','2023-06-29 22:16:20'),(369,7479,40719,23,2,349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',48000.00,NULL,NULL,1,'2023-06-29 21:50:06','2023-06-29 22:16:13','2023-06-29 22:16:13'),(370,7479,40719,23,2,350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',3500.00,NULL,NULL,1,'2023-06-29 21:50:06','2023-06-29 22:16:09','2023-06-29 22:16:09'),(371,7479,40719,23,2,351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',35000.00,NULL,NULL,1,'2023-06-29 21:50:06','2023-06-29 22:16:06','2023-06-29 22:16:06'),(372,7479,40719,23,2,352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',3500.00,NULL,NULL,1,'2023-06-29 21:50:06','2023-06-29 22:16:02','2023-06-29 22:16:02'),(373,7479,40719,23,2,353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',4000.00,NULL,NULL,1,'2023-06-29 21:50:06','2023-06-29 22:16:17','2023-06-29 22:16:17'),(374,7479,40719,23,2,345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-18','2023-06-18',10000.00,NULL,NULL,1,'2023-06-29 22:00:49','2023-06-29 22:16:31','2023-06-29 22:16:31');
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=759 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7479,1,40722,4532,2,218,2,114134.00,NULL,'2022-07-29 19:26:36','2022-07-29 20:20:19','2022-07-29 20:20:19'),(2,7479,1,40722,4532,2,13,1,114134.00,NULL,'2022-07-29 19:26:36','2022-07-29 20:20:19','2022-07-29 20:20:19'),(3,7479,2,40722,4532,2,218,2,107000.00,NULL,'2022-07-29 19:26:36','2022-07-29 20:20:06','2022-07-29 20:20:06'),(4,7479,2,40722,4532,2,13,1,107000.00,NULL,'2022-07-29 19:26:36','2022-07-29 20:20:06','2022-07-29 20:20:06'),(5,7479,3,40722,4532,2,218,2,114134.00,NULL,'2022-07-29 19:26:36','2022-07-29 20:19:55','2022-07-29 20:19:55'),(6,7479,3,40722,4532,2,13,1,114134.00,NULL,'2022-07-29 19:26:36','2022-07-29 20:19:55','2022-07-29 20:19:55'),(7,7479,4,40722,4532,2,218,2,107000.00,NULL,'2022-07-29 19:26:36','2022-07-29 20:19:36','2022-07-29 20:19:36'),(8,7479,4,40722,4532,2,13,1,107000.00,NULL,'2022-07-29 19:26:36','2022-07-29 20:19:36','2022-07-29 20:19:36'),(9,7479,5,40722,4532,3,250,1,1910.34,NULL,'2022-07-29 19:28:35','2022-08-02 18:57:56','2022-08-02 18:57:56'),(10,7479,5,40722,4532,3,57,2,1910.34,NULL,'2022-07-29 19:28:35','2022-08-02 18:57:56','2022-08-02 18:57:56'),(11,7479,6,40722,4532,3,217,1,6371.90,NULL,'2022-07-29 19:28:35','2022-08-02 18:57:56','2022-08-02 18:57:56'),(12,7479,6,40722,4532,3,68,1,1338.10,NULL,'2022-07-29 19:28:35','2022-08-02 18:57:56','2022-08-02 18:57:56'),(13,7479,6,40722,4532,3,57,2,7710.00,NULL,'2022-07-29 19:28:35','2022-08-02 18:57:56','2022-08-02 18:57:56'),(14,7479,7,40722,4532,2,218,2,107000.00,NULL,'2022-07-29 20:19:36','2022-08-02 18:57:51','2022-08-02 18:57:51'),(15,7479,7,40722,4532,2,13,1,107000.00,NULL,'2022-07-29 20:19:36','2022-08-02 18:57:51','2022-08-02 18:57:51'),(16,7479,8,40722,4532,2,218,2,114134.00,NULL,'2022-07-29 20:19:55','2022-08-02 18:57:51','2022-08-02 18:57:51'),(17,7479,8,40722,4532,2,13,1,114134.00,NULL,'2022-07-29 20:19:55','2022-08-02 18:57:51','2022-08-02 18:57:51'),(18,7479,9,40722,4532,2,218,2,107000.00,NULL,'2022-07-29 20:20:06','2022-08-02 18:57:51','2022-08-02 18:57:51'),(19,7479,9,40722,4532,2,13,1,107000.00,NULL,'2022-07-29 20:20:06','2022-08-02 18:57:51','2022-08-02 18:57:51'),(20,7479,10,40722,4532,2,218,2,114134.00,NULL,'2022-07-29 20:20:19','2022-08-02 18:57:51','2022-08-02 18:57:51'),(21,7479,10,40722,4532,2,13,1,114134.00,NULL,'2022-07-29 20:20:19','2022-08-02 18:57:51','2022-08-02 18:57:51'),(22,7479,11,40719,8,2,218,2,1000.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:20:05','2022-07-29 23:20:05'),(23,7479,11,40719,8,2,13,1,1000.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:20:05','2022-07-29 23:20:05'),(24,7479,12,40719,8,2,218,2,1000.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(25,7479,12,40719,8,2,13,1,1000.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(26,7479,13,40719,8,2,218,2,1000.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(27,7479,13,40719,8,2,13,1,1000.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(28,7479,14,40719,8,2,218,2,1000.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(29,7479,14,40719,8,2,13,1,1000.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(30,7479,15,40719,8,2,218,2,700.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(31,7479,15,40719,8,2,13,1,700.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(32,7479,16,40719,8,2,218,2,1000.00,NULL,'2022-07-29 22:54:43','2022-07-29 22:55:57','2022-07-29 22:55:57'),(33,7479,16,40719,8,2,13,1,1000.00,NULL,'2022-07-29 22:54:43','2022-07-29 22:55:57','2022-07-29 22:55:57'),(34,7479,17,40719,8,2,218,2,2000.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(35,7479,17,40719,8,2,13,1,2000.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(36,7479,18,40719,8,2,218,2,1000.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06');
INSERT INTO `balance_libro_details` VALUES (37,7479,18,40719,8,2,13,1,1000.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(38,7479,19,40719,8,2,218,2,1800.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:19:50','2022-07-29 23:19:50'),(39,7479,19,40719,8,2,13,1,1800.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:19:50','2022-07-29 23:19:50'),(40,7479,20,40719,8,2,218,2,2000.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:19:46','2022-07-29 23:19:46'),(41,7479,20,40719,8,2,13,1,2000.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:19:46','2022-07-29 23:19:46'),(42,7479,21,40719,8,2,218,2,1400.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:19:42','2022-07-29 23:19:42'),(43,7479,21,40719,8,2,13,1,1400.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:19:42','2022-07-29 23:19:42'),(44,7479,22,40719,8,2,218,2,700.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:19:38','2022-07-29 23:19:38'),(45,7479,22,40719,8,2,13,1,700.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:19:38','2022-07-29 23:19:38'),(46,7479,23,40719,8,2,218,2,1000.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:19:34','2022-07-29 23:19:34'),(47,7479,23,40719,8,2,13,1,1000.00,NULL,'2022-07-29 22:54:43','2022-07-29 23:19:34','2022-07-29 23:19:34'),(48,7479,24,40719,8,2,218,2,1000.00,NULL,'2022-07-29 22:55:57','2022-07-29 23:20:06','2022-07-29 23:20:06'),(49,7479,24,40719,8,2,13,1,1000.00,NULL,'2022-07-29 22:55:57','2022-07-29 23:20:06','2022-07-29 23:20:06'),(50,7479,25,40719,8,8,277,1,19.36,NULL,'2022-07-30 11:22:22','2022-07-30 16:07:17','2022-07-30 16:07:17'),(51,7479,25,40719,8,8,351,2,19.36,NULL,'2022-07-30 11:22:22','2022-07-30 16:07:17','2022-07-30 16:07:17'),(52,7479,26,40719,8,8,276,1,23.64,NULL,'2022-07-30 11:22:22','2022-07-30 16:07:17','2022-07-30 16:07:17'),(53,7479,26,40719,8,8,351,2,23.64,NULL,'2022-07-30 11:22:22','2022-07-30 16:07:17','2022-07-30 16:07:17'),(54,7479,27,40719,8,2,218,2,1000.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(55,7479,27,40719,8,2,13,1,1000.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(56,7479,28,40719,8,2,218,2,1000.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(57,7479,28,40719,8,2,13,1,1000.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(58,7479,29,40719,8,2,218,2,1000.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(59,7479,29,40719,8,2,13,1,1000.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(60,7479,30,40719,8,2,218,2,1000.00,NULL,'2022-07-30 11:23:29','2022-07-30 11:26:42','2022-07-30 11:26:42'),(61,7479,30,40719,8,2,13,1,1000.00,NULL,'2022-07-30 11:23:29','2022-07-30 11:26:42','2022-07-30 11:26:42'),(62,7479,31,40719,8,2,218,2,700.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(63,7479,31,40719,8,2,13,1,700.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(64,7479,32,40719,8,2,218,2,1000.00,NULL,'2022-07-30 11:23:29','2022-07-30 11:26:16','2022-07-30 11:26:16'),(65,7479,32,40719,8,2,13,1,1000.00,NULL,'2022-07-30 11:23:29','2022-07-30 11:26:16','2022-07-30 11:26:16'),(66,7479,33,40719,8,2,218,2,2000.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(67,7479,33,40719,8,2,13,1,2000.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(68,7479,34,40719,8,2,218,2,1000.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(69,7479,34,40719,8,2,13,1,1000.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(70,7479,35,40719,8,2,218,2,1800.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(71,7479,35,40719,8,2,13,1,1800.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(72,7479,36,40719,8,2,218,2,2000.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(73,7479,36,40719,8,2,13,1,2000.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19');
INSERT INTO `balance_libro_details` VALUES (74,7479,37,40719,8,2,218,2,1400.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(75,7479,37,40719,8,2,13,1,1400.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(76,7479,38,40719,8,2,218,2,700.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(77,7479,38,40719,8,2,13,1,700.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(78,7479,39,40719,8,2,218,2,1000.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(79,7479,39,40719,8,2,13,1,1000.00,NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(80,7479,40,40719,8,3,250,1,520.00,NULL,'2022-07-30 11:23:49','2022-07-30 13:18:42','2022-07-30 13:18:42'),(81,7479,40,40719,8,3,57,2,520.00,NULL,'2022-07-30 11:23:49','2022-07-30 13:18:42','2022-07-30 13:18:42'),(82,7479,41,40719,8,2,218,2,1000.00,NULL,'2022-07-30 11:26:16','2022-07-30 12:30:19','2022-07-30 12:30:19'),(83,7479,41,40719,8,2,13,1,1000.00,NULL,'2022-07-30 11:26:16','2022-07-30 12:30:19','2022-07-30 12:30:19'),(84,7479,42,40719,8,2,218,2,1000.00,NULL,'2022-07-30 11:26:42','2022-07-30 12:30:19','2022-07-30 12:30:19'),(85,7479,42,40719,8,2,13,1,1000.00,NULL,'2022-07-30 11:26:42','2022-07-30 12:30:19','2022-07-30 12:30:19'),(86,7479,43,40719,9,2,218,2,2000.00,NULL,'2022-07-30 12:20:39','2022-07-30 12:30:29','2022-07-30 12:30:29'),(87,7479,43,40719,9,2,13,1,2000.00,NULL,'2022-07-30 12:20:39','2022-07-30 12:30:29','2022-07-30 12:30:29'),(88,7479,44,40719,9,2,218,2,1000.00,NULL,'2022-07-30 12:20:39','2022-07-30 12:30:30','2022-07-30 12:30:29'),(89,7479,44,40719,9,2,13,1,1000.00,NULL,'2022-07-30 12:20:39','2022-07-30 12:30:30','2022-07-30 12:30:29'),(90,7479,45,40719,9,2,218,2,700.00,NULL,'2022-07-30 12:20:39','2022-07-30 12:30:30','2022-07-30 12:30:30'),(91,7479,45,40719,9,2,13,1,700.00,NULL,'2022-07-30 12:20:39','2022-07-30 12:30:30','2022-07-30 12:30:30'),(92,7479,46,40719,9,2,218,2,1000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(93,7479,46,40719,9,2,13,1,1000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(94,7479,47,40719,9,2,218,2,1000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(95,7479,47,40719,9,2,13,1,1000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(96,7479,48,40719,9,2,218,2,6000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(97,7479,48,40719,9,2,13,1,6000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(98,7479,49,40719,9,2,218,2,2000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(99,7479,49,40719,9,2,13,1,2000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(100,7479,50,40719,9,2,218,2,1000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(101,7479,50,40719,9,2,13,1,1000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(102,7479,51,40719,9,2,218,2,800.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(103,7479,51,40719,9,2,13,1,800.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(104,7479,52,40719,9,2,218,2,1000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(105,7479,52,40719,9,2,13,1,1000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(106,7479,53,40719,9,2,218,2,3000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(107,7479,53,40719,9,2,13,1,3000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(108,7479,54,40719,9,2,218,2,1000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(109,7479,54,40719,9,2,13,1,1000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(110,7479,55,40719,9,2,218,2,1000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30');
INSERT INTO `balance_libro_details` VALUES (111,7479,55,40719,9,2,13,1,1000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(112,7479,56,40719,9,2,218,2,3000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(113,7479,56,40719,9,2,13,1,3000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(114,7479,57,40719,9,2,218,2,1000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(115,7479,57,40719,9,2,13,1,1000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(116,7479,58,40719,9,2,218,2,800.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(117,7479,58,40719,9,2,13,1,800.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(118,7479,59,40719,9,2,218,2,1000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(119,7479,59,40719,9,2,13,1,1000.00,NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(120,7479,60,40719,9,2,218,2,2000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(121,7479,60,40719,9,2,13,1,2000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(122,7479,61,40719,9,2,218,2,1000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(123,7479,61,40719,9,2,13,1,1000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(124,7479,62,40719,9,2,218,2,700.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(125,7479,62,40719,9,2,13,1,700.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(126,7479,63,40719,9,2,218,2,1000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(127,7479,63,40719,9,2,13,1,1000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(128,7479,64,40719,9,2,218,2,1000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(129,7479,64,40719,9,2,13,1,1000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(130,7479,65,40719,9,2,218,2,6000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(131,7479,65,40719,9,2,13,1,6000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(132,7479,66,40719,9,2,218,2,2000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(133,7479,66,40719,9,2,13,1,2000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(134,7479,67,40719,9,2,218,2,1000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(135,7479,67,40719,9,2,13,1,1000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(136,7479,68,40719,9,2,218,2,800.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(137,7479,68,40719,9,2,13,1,800.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(138,7479,69,40719,9,2,218,2,1000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(139,7479,69,40719,9,2,13,1,1000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(140,7479,70,40719,9,2,218,2,3000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(141,7479,70,40719,9,2,13,1,3000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(142,7479,71,40719,9,2,218,2,1000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(143,7479,71,40719,9,2,13,1,1000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(144,7479,72,40719,9,2,218,2,1000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(145,7479,72,40719,9,2,13,1,1000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(146,7479,73,40719,9,2,218,2,3000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(147,7479,73,40719,9,2,13,1,3000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03');
INSERT INTO `balance_libro_details` VALUES (148,7479,74,40719,9,2,218,2,1000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(149,7479,74,40719,9,2,13,1,1000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(150,7479,75,40719,9,2,218,2,800.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(151,7479,75,40719,9,2,13,1,800.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(152,7479,76,40719,9,2,218,2,1000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(153,7479,76,40719,9,2,13,1,1000.00,NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(154,7479,77,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(155,7479,77,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(156,7479,78,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(157,7479,78,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(158,7479,79,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(159,7479,79,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(160,7479,80,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(161,7479,80,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(162,7479,81,40719,8,2,218,2,700.00,NULL,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(163,7479,81,40719,8,2,13,1,700.00,NULL,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(164,7479,82,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(165,7479,82,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(166,7479,83,40719,8,2,218,2,2000.00,NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(167,7479,83,40719,8,2,13,1,2000.00,NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(168,7479,84,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(169,7479,84,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(170,7479,85,40719,8,2,218,2,1800.00,NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(171,7479,85,40719,8,2,13,1,1800.00,NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(172,7479,86,40719,8,2,218,2,2000.00,NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(173,7479,86,40719,8,2,13,1,2000.00,NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(174,7479,87,40719,8,2,218,2,1400.00,NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(175,7479,87,40719,8,2,13,1,1400.00,NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(176,7479,88,40719,8,2,218,2,700.00,NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(177,7479,88,40719,8,2,13,1,700.00,NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(178,7479,89,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(179,7479,89,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(180,7479,90,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(181,7479,90,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(182,7479,91,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(183,7479,91,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(184,7479,92,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17');
INSERT INTO `balance_libro_details` VALUES (185,7479,92,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(186,7479,93,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(187,7479,93,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(188,7479,94,40719,8,2,218,2,700.00,NULL,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(189,7479,94,40719,8,2,13,1,700.00,NULL,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(190,7479,95,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(191,7479,95,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(192,7479,96,40719,8,2,218,2,2000.00,NULL,'2022-07-30 13:30:31','2022-07-30 13:35:18','2022-07-30 13:35:18'),(193,7479,96,40719,8,2,13,1,2000.00,NULL,'2022-07-30 13:30:31','2022-07-30 13:35:18','2022-07-30 13:35:18'),(194,7479,97,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:30:31','2022-07-30 13:35:18','2022-07-30 13:35:18'),(195,7479,97,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:30:31','2022-07-30 13:35:18','2022-07-30 13:35:18'),(196,7479,98,40719,8,2,218,2,1800.00,NULL,'2022-07-30 13:30:31','2022-07-30 13:35:18','2022-07-30 13:35:18'),(197,7479,98,40719,8,2,13,1,1800.00,NULL,'2022-07-30 13:30:31','2022-07-30 13:35:18','2022-07-30 13:35:18'),(198,7479,99,40719,8,2,218,2,2000.00,NULL,'2022-07-30 13:30:32','2022-07-30 13:35:18','2022-07-30 13:35:18'),(199,7479,99,40719,8,2,13,1,2000.00,NULL,'2022-07-30 13:30:32','2022-07-30 13:35:18','2022-07-30 13:35:18'),(200,7479,100,40719,8,2,218,2,1400.00,NULL,'2022-07-30 13:30:32','2022-07-30 13:35:18','2022-07-30 13:35:18'),(201,7479,100,40719,8,2,13,1,1400.00,NULL,'2022-07-30 13:30:32','2022-07-30 13:35:18','2022-07-30 13:35:18'),(202,7479,101,40719,8,2,218,2,700.00,NULL,'2022-07-30 13:30:32','2022-07-30 13:35:18','2022-07-30 13:35:18'),(203,7479,101,40719,8,2,13,1,700.00,NULL,'2022-07-30 13:30:32','2022-07-30 13:35:18','2022-07-30 13:35:18'),(204,7479,102,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:30:32','2022-07-30 13:35:18','2022-07-30 13:35:18'),(205,7479,102,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:30:32','2022-07-30 13:35:18','2022-07-30 13:35:18'),(206,7479,103,40719,8,3,250,1,520.00,NULL,'2022-07-30 13:30:46','2022-07-30 14:16:08','2022-07-30 14:16:08'),(207,7479,103,40719,8,3,57,2,520.00,NULL,'2022-07-30 13:30:46','2022-07-30 14:16:08','2022-07-30 14:16:08'),(208,7479,104,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:40:56','2022-07-30 13:40:56'),(209,7479,104,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:40:56','2022-07-30 13:40:56'),(210,7479,105,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:40:53','2022-07-30 13:40:53'),(211,7479,105,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:40:53','2022-07-30 13:40:53'),(212,7479,106,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:40:49','2022-07-30 13:40:49'),(213,7479,106,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:40:49','2022-07-30 13:40:49'),(214,7479,107,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:40:37','2022-07-30 13:40:37'),(215,7479,107,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:40:37','2022-07-30 13:40:37'),(216,7479,108,40719,8,2,218,2,700.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:40:45','2022-07-30 13:40:45'),(217,7479,108,40719,8,2,13,1,700.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:40:45','2022-07-30 13:40:45'),(218,7479,109,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:40:41','2022-07-30 13:40:41'),(219,7479,109,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:40:41','2022-07-30 13:40:41'),(220,7479,110,40719,8,2,218,2,2000.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:41:00','2022-07-30 13:41:00');
INSERT INTO `balance_libro_details` VALUES (221,7479,110,40719,8,2,13,1,2000.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:41:00','2022-07-30 13:41:00'),(222,7479,111,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:41:04','2022-07-30 13:41:04'),(223,7479,111,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:41:04','2022-07-30 13:41:04'),(224,7479,112,40719,8,2,218,2,1800.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:41:08','2022-07-30 13:41:08'),(225,7479,112,40719,8,2,13,1,1800.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:41:08','2022-07-30 13:41:08'),(226,7479,113,40719,8,2,218,2,2000.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:41:12','2022-07-30 13:41:12'),(227,7479,113,40719,8,2,13,1,2000.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:41:12','2022-07-30 13:41:12'),(228,7479,114,40719,8,2,218,2,1400.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:41:15','2022-07-30 13:41:15'),(229,7479,114,40719,8,2,13,1,1400.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:41:15','2022-07-30 13:41:15'),(230,7479,115,40719,8,2,218,2,700.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:41:19','2022-07-30 13:41:19'),(231,7479,115,40719,8,2,13,1,700.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:41:19','2022-07-30 13:41:19'),(232,7479,116,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:42:12','2022-07-30 13:42:12'),(233,7479,116,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:35:51','2022-07-30 13:42:12','2022-07-30 13:42:12'),(234,7479,117,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:42:12','2022-07-30 13:47:34','2022-07-30 13:47:34'),(235,7479,117,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:42:12','2022-07-30 13:47:34','2022-07-30 13:47:34'),(236,7479,118,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(237,7479,118,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(238,7479,119,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(239,7479,119,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(240,7479,120,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(241,7479,120,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(242,7479,121,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:03:39','2022-07-30 14:03:39'),(243,7479,121,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:03:39','2022-07-30 14:03:39'),(244,7479,122,40719,8,2,218,2,700.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(245,7479,122,40719,8,2,13,1,700.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(246,7479,123,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:03:18','2022-07-30 14:03:18'),(247,7479,123,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:03:18','2022-07-30 14:03:18'),(248,7479,124,40719,8,2,218,2,2000.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(249,7479,124,40719,8,2,13,1,2000.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(250,7479,125,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(251,7479,125,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(252,7479,126,40719,8,2,218,2,1800.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(253,7479,126,40719,8,2,13,1,1800.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(254,7479,127,40719,8,2,218,2,2000.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(255,7479,127,40719,8,2,13,1,2000.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(256,7479,128,40719,8,2,218,2,1400.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59');
INSERT INTO `balance_libro_details` VALUES (257,7479,128,40719,8,2,13,1,1400.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(258,7479,129,40719,8,2,218,2,700.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(259,7479,129,40719,8,2,13,1,700.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(260,7479,130,40719,8,2,218,2,1000.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(261,7479,130,40719,8,2,13,1,1000.00,NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(262,7479,131,40719,8,2,218,2,1000.00,NULL,'2022-07-30 14:03:18','2022-07-30 14:15:59','2022-07-30 14:15:59'),(263,7479,131,40719,8,2,13,1,1000.00,NULL,'2022-07-30 14:03:18','2022-07-30 14:15:59','2022-07-30 14:15:59'),(264,7479,132,40719,8,2,218,2,1000.00,NULL,'2022-07-30 14:03:39','2022-07-30 14:15:59','2022-07-30 14:15:59'),(265,7479,132,40719,8,2,13,1,1000.00,NULL,'2022-07-30 14:03:39','2022-07-30 14:15:59','2022-07-30 14:15:59'),(266,7479,133,40719,9,2,218,2,2000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(267,7479,133,40719,9,2,13,1,2000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(268,7479,134,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(269,7479,134,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(270,7479,135,40719,9,2,218,2,700.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(271,7479,135,40719,9,2,13,1,700.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(272,7479,136,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(273,7479,136,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(274,7479,137,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(275,7479,137,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(276,7479,138,40719,9,2,218,2,6000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(277,7479,138,40719,9,2,13,1,6000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(278,7479,139,40719,9,2,218,2,2000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(279,7479,139,40719,9,2,13,1,2000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(280,7479,140,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(281,7479,140,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(282,7479,141,40719,9,2,218,2,800.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(283,7479,141,40719,9,2,13,1,800.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(284,7479,142,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(285,7479,142,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(286,7479,143,40719,9,2,218,2,3000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(287,7479,143,40719,9,2,13,1,3000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(288,7479,144,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(289,7479,144,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(290,7479,145,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(291,7479,145,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(292,7479,146,40719,9,2,218,2,3000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28');
INSERT INTO `balance_libro_details` VALUES (293,7479,146,40719,9,2,13,1,3000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(294,7479,147,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(295,7479,147,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(296,7479,148,40719,9,2,218,2,800.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(297,7479,148,40719,9,2,13,1,800.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(298,7479,149,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(299,7479,149,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(300,7479,150,40719,9,2,218,2,2000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(301,7479,150,40719,9,2,13,1,2000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(302,7479,151,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(303,7479,151,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(304,7479,152,40719,9,2,218,2,700.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(305,7479,152,40719,9,2,13,1,700.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(306,7479,153,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(307,7479,153,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(308,7479,154,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(309,7479,154,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(310,7479,155,40719,9,2,218,2,6000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(311,7479,155,40719,9,2,13,1,6000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(312,7479,156,40719,9,2,218,2,2000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(313,7479,156,40719,9,2,13,1,2000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(314,7479,157,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(315,7479,157,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(316,7479,158,40719,9,2,218,2,800.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(317,7479,158,40719,9,2,13,1,800.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(318,7479,159,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(319,7479,159,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(320,7479,160,40719,9,2,218,2,3000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(321,7479,160,40719,9,2,13,1,3000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(322,7479,161,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(323,7479,161,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(324,7479,162,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44'),(325,7479,162,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44'),(326,7479,163,40719,9,2,218,2,3000.00,NULL,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44'),(327,7479,163,40719,9,2,13,1,3000.00,NULL,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44'),(328,7479,164,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44');
INSERT INTO `balance_libro_details` VALUES (329,7479,164,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44'),(330,7479,165,40719,9,2,218,2,800.00,NULL,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44'),(331,7479,165,40719,9,2,13,1,800.00,NULL,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44'),(332,7479,166,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44'),(333,7479,166,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44'),(334,7479,167,40719,9,2,218,2,2000.00,NULL,'2022-07-30 14:28:08','2022-07-30 15:46:07','2022-07-30 15:46:07'),(335,7479,167,40719,9,2,13,1,2000.00,NULL,'2022-07-30 14:28:08','2022-07-30 15:46:07','2022-07-30 15:46:07'),(336,7479,168,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:28:08','2022-07-30 15:46:07','2022-07-30 15:46:07'),(337,7479,168,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:28:08','2022-07-30 15:46:07','2022-07-30 15:46:07'),(338,7479,169,40719,9,2,218,2,700.00,NULL,'2022-07-30 14:28:08','2022-07-30 15:46:07','2022-07-30 15:46:07'),(339,7479,169,40719,9,2,13,1,700.00,NULL,'2022-07-30 14:28:08','2022-07-30 15:46:07','2022-07-30 15:46:07'),(340,7479,170,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(341,7479,170,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(342,7479,171,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(343,7479,171,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(344,7479,172,40719,9,2,218,2,6000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(345,7479,172,40719,9,2,13,1,6000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(346,7479,173,40719,9,2,218,2,2000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(347,7479,173,40719,9,2,13,1,2000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(348,7479,174,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(349,7479,174,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(350,7479,175,40719,9,2,218,2,800.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(351,7479,175,40719,9,2,13,1,800.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(352,7479,176,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(353,7479,176,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(354,7479,177,40719,9,2,218,2,3000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(355,7479,177,40719,9,2,13,1,3000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(356,7479,178,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(357,7479,178,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(358,7479,179,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(359,7479,179,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(360,7479,180,40719,9,2,218,2,3000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(361,7479,180,40719,9,2,13,1,3000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(362,7479,181,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(363,7479,181,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(364,7479,182,40719,9,2,218,2,800.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07');
INSERT INTO `balance_libro_details` VALUES (365,7479,182,40719,9,2,13,1,800.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(366,7479,183,40719,9,2,218,2,1000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(367,7479,183,40719,9,2,13,1,1000.00,NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(368,7479,184,40719,9,2,218,2,2000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(369,7479,184,40719,9,2,13,1,2000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(370,7479,185,40719,9,2,218,2,1000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:53:14','2022-07-30 15:53:14'),(371,7479,185,40719,9,2,13,1,1000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:53:14','2022-07-30 15:53:14'),(372,7479,186,40719,9,2,218,2,700.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(373,7479,186,40719,9,2,13,1,700.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(374,7479,187,40719,9,2,218,2,1000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(375,7479,187,40719,9,2,13,1,1000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(376,7479,188,40719,9,2,218,2,1000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(377,7479,188,40719,9,2,13,1,1000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(378,7479,189,40719,9,2,218,2,6000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(379,7479,189,40719,9,2,13,1,6000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(380,7479,190,40719,9,2,218,2,2000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(381,7479,190,40719,9,2,13,1,2000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(382,7479,191,40719,9,2,218,2,1000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(383,7479,191,40719,9,2,13,1,1000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(384,7479,192,40719,9,2,218,2,800.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(385,7479,192,40719,9,2,13,1,800.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(386,7479,193,40719,9,2,218,2,1000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(387,7479,193,40719,9,2,13,1,1000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(388,7479,194,40719,9,2,218,2,3000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(389,7479,194,40719,9,2,13,1,3000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(390,7479,195,40719,9,2,218,2,1000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(391,7479,195,40719,9,2,13,1,1000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(392,7479,196,40719,9,2,218,2,1000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(393,7479,196,40719,9,2,13,1,1000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(394,7479,197,40719,9,2,218,2,3000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(395,7479,197,40719,9,2,13,1,3000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(396,7479,198,40719,9,2,218,2,1000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(397,7479,198,40719,9,2,13,1,1000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(398,7479,199,40719,9,2,218,2,800.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(399,7479,199,40719,9,2,13,1,800.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(400,7479,200,40719,9,2,218,2,1000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34');
INSERT INTO `balance_libro_details` VALUES (401,7479,200,40719,9,2,13,1,1000.00,NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(402,7479,201,40719,9,2,218,2,1000.00,NULL,'2022-07-30 15:53:14','2022-07-30 15:57:34','2022-07-30 15:57:34'),(403,7479,201,40719,9,2,13,1,1000.00,NULL,'2022-07-30 15:53:14','2022-07-30 15:57:34','2022-07-30 15:57:34'),(404,7479,202,40719,9,2,218,2,2000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(405,7479,202,40719,9,2,13,1,2000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(406,7479,203,40719,9,2,218,2,1000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(407,7479,203,40719,9,2,13,1,1000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(408,7479,204,40719,9,2,218,2,700.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(409,7479,204,40719,9,2,13,1,700.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(410,7479,205,40719,9,2,218,2,1000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(411,7479,205,40719,9,2,13,1,1000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(412,7479,206,40719,9,2,218,2,1000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(413,7479,206,40719,9,2,13,1,1000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(414,7479,207,40719,9,2,218,2,6000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(415,7479,207,40719,9,2,13,1,6000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(416,7479,208,40719,9,2,218,2,2000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(417,7479,208,40719,9,2,13,1,2000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(418,7479,209,40719,9,2,218,2,1000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(419,7479,209,40719,9,2,13,1,1000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(420,7479,210,40719,9,2,218,2,800.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(421,7479,210,40719,9,2,13,1,800.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(422,7479,211,40719,9,2,218,2,1000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(423,7479,211,40719,9,2,13,1,1000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(424,7479,212,40719,9,2,218,2,3000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(425,7479,212,40719,9,2,13,1,3000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(426,7479,213,40719,9,2,218,2,1000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(427,7479,213,40719,9,2,13,1,1000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(428,7479,214,40719,9,2,218,2,1000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(429,7479,214,40719,9,2,13,1,1000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(430,7479,215,40719,9,2,218,2,3000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(431,7479,215,40719,9,2,13,1,3000.00,NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(432,7479,216,40719,9,2,218,2,1000.00,NULL,'2022-07-30 16:00:50','2022-07-30 16:07:09','2022-07-30 16:07:09'),(433,7479,216,40719,9,2,13,1,1000.00,NULL,'2022-07-30 16:00:50','2022-07-30 16:07:09','2022-07-30 16:07:09'),(434,7479,217,40719,9,2,218,2,800.00,NULL,'2022-07-30 16:00:50','2022-07-30 16:07:09','2022-07-30 16:07:09'),(435,7479,217,40719,9,2,13,1,800.00,NULL,'2022-07-30 16:00:50','2022-07-30 16:07:09','2022-07-30 16:07:09'),(436,7479,218,40719,9,2,218,2,1000.00,NULL,'2022-07-30 16:00:50','2022-07-30 16:07:09','2022-07-30 16:07:09');
INSERT INTO `balance_libro_details` VALUES (437,7479,218,40719,9,2,13,1,1000.00,NULL,'2022-07-30 16:00:50','2022-07-30 16:07:09','2022-07-30 16:07:09'),(438,7479,219,40719,9,2,218,2,2000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(439,7479,219,40719,9,2,13,1,2000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(440,7479,220,40719,9,2,218,2,1000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(441,7479,220,40719,9,2,13,1,1000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(442,7479,221,40719,9,2,218,2,700.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(443,7479,221,40719,9,2,13,1,700.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(444,7479,222,40719,9,2,218,2,1000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(445,7479,222,40719,9,2,13,1,1000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(446,7479,223,40719,9,2,218,2,1000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(447,7479,223,40719,9,2,13,1,1000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(448,7479,224,40719,9,2,218,2,6000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(449,7479,224,40719,9,2,13,1,6000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(450,7479,225,40719,9,2,218,2,2000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(451,7479,225,40719,9,2,13,1,2000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(452,7479,226,40719,9,2,218,2,1000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(453,7479,226,40719,9,2,13,1,1000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(454,7479,227,40719,9,2,218,2,800.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(455,7479,227,40719,9,2,13,1,800.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(456,7479,228,40719,9,2,218,2,1000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(457,7479,228,40719,9,2,13,1,1000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(458,7479,229,40719,9,2,218,2,3000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(459,7479,229,40719,9,2,13,1,3000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(460,7479,230,40719,9,2,218,2,1000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(461,7479,230,40719,9,2,13,1,1000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(462,7479,231,40719,9,2,218,2,1000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(463,7479,231,40719,9,2,13,1,1000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(464,7479,232,40719,9,2,218,2,3000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(465,7479,232,40719,9,2,13,1,3000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(466,7479,233,40719,9,2,218,2,1000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(467,7479,233,40719,9,2,13,1,1000.00,NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(468,7479,234,40719,9,2,218,2,800.00,NULL,'2022-07-30 16:09:43','2022-07-30 16:19:03','2022-07-30 16:19:03'),(469,7479,234,40719,9,2,13,1,800.00,NULL,'2022-07-30 16:09:43','2022-07-30 16:19:03','2022-07-30 16:19:03'),(470,7479,235,40719,9,2,218,2,1000.00,NULL,'2022-07-30 16:09:43','2022-07-30 16:19:03','2022-07-30 16:19:03'),(471,7479,235,40719,9,2,13,1,1000.00,NULL,'2022-07-30 16:09:43','2022-07-30 16:19:03','2022-07-30 16:19:03'),(472,7479,236,40748,6121,2,218,2,56000.00,NULL,'2022-07-30 16:29:21','2022-07-30 18:55:49','2022-07-30 18:55:49');
INSERT INTO `balance_libro_details` VALUES (473,7479,236,40748,6121,2,13,1,56000.00,NULL,'2022-07-30 16:29:21','2022-07-30 18:55:49','2022-07-30 18:55:49'),(474,7479,237,40748,6121,2,218,2,15000.00,NULL,'2022-07-30 16:29:21','2022-07-30 18:55:49','2022-07-30 18:55:49'),(475,7479,237,40748,6121,2,13,1,15000.00,NULL,'2022-07-30 16:29:21','2022-07-30 18:55:49','2022-07-30 18:55:49'),(476,7479,238,40748,6121,2,218,2,20000.00,NULL,'2022-07-30 16:29:21','2022-07-30 18:55:49','2022-07-30 18:55:49'),(477,7479,238,40748,6121,2,13,1,20000.00,NULL,'2022-07-30 16:29:21','2022-07-30 18:55:49','2022-07-30 18:55:49'),(478,7479,239,40748,6121,2,218,2,15000.00,NULL,'2022-07-30 16:29:21','2022-07-30 18:55:49','2022-07-30 18:55:49'),(479,7479,239,40748,6121,2,13,1,15000.00,NULL,'2022-07-30 16:29:21','2022-07-30 18:55:49','2022-07-30 18:55:49'),(480,7479,240,40748,7707,2,218,2,27000.00,NULL,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18'),(481,7479,240,40748,7707,2,13,1,27000.00,NULL,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18'),(482,7479,241,40748,7707,2,218,2,25000.00,NULL,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18'),(483,7479,241,40748,7707,2,13,1,25000.00,NULL,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18'),(484,7479,242,40748,7707,2,218,2,36000.00,NULL,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18'),(485,7479,242,40748,7707,2,13,1,36000.00,NULL,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18'),(486,7479,243,40748,7707,2,218,2,75000.00,NULL,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18'),(487,7479,243,40748,7707,2,13,1,75000.00,NULL,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18'),(488,7479,244,40748,7707,2,218,2,6000.00,NULL,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18'),(489,7479,244,40748,7707,2,13,1,6000.00,NULL,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18'),(490,7479,245,40748,7707,2,218,2,0.00,NULL,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(491,7479,245,40748,7707,2,13,1,0.00,NULL,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(492,7479,246,40748,7707,2,218,2,0.00,NULL,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(493,7479,246,40748,7707,2,13,1,0.00,NULL,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(494,7479,247,40748,7707,2,218,2,0.00,NULL,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(495,7479,247,40748,7707,2,13,1,0.00,NULL,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(496,7479,248,40748,7707,2,218,2,0.00,NULL,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(497,7479,248,40748,7707,2,13,1,0.00,NULL,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(498,7479,249,40748,7707,2,218,2,0.00,NULL,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(499,7479,249,40748,7707,2,13,1,0.00,NULL,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(500,7479,250,40748,7707,2,218,2,27000.00,NULL,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49'),(501,7479,250,40748,7707,2,13,1,27000.00,NULL,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49'),(502,7479,251,40748,7707,2,218,2,25000.00,NULL,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49'),(503,7479,251,40748,7707,2,13,1,25000.00,NULL,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49'),(504,7479,252,40748,7707,2,218,2,36000.00,NULL,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49'),(505,7479,252,40748,7707,2,13,1,36000.00,NULL,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49'),(506,7479,253,40748,7707,2,218,2,75000.00,NULL,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49'),(507,7479,253,40748,7707,2,13,1,75000.00,NULL,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49');
INSERT INTO `balance_libro_details` VALUES (508,7479,254,40748,7707,2,218,2,6000.00,NULL,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49'),(509,7479,254,40748,7707,2,13,1,6000.00,NULL,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49'),(510,7479,255,40748,7707,2,218,2,27000.00,NULL,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(511,7479,255,40748,7707,2,13,1,27000.00,NULL,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(512,7479,256,40748,7707,2,218,2,25000.00,NULL,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(513,7479,256,40748,7707,2,13,1,25000.00,NULL,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(514,7479,257,40748,7707,2,218,2,36000.00,NULL,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(515,7479,257,40748,7707,2,13,1,36000.00,NULL,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(516,7479,258,40748,7707,2,218,2,75000.00,NULL,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(517,7479,258,40748,7707,2,13,1,75000.00,NULL,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(518,7479,259,40748,7707,2,218,2,6000.00,NULL,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(519,7479,259,40748,7707,2,13,1,6000.00,NULL,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(520,7479,260,40727,7710,2,218,2,176600.00,NULL,'2022-07-30 19:15:16','2022-08-01 18:59:34','2022-08-01 18:59:34'),(521,7479,260,40727,7710,2,13,1,176600.00,NULL,'2022-07-30 19:15:16','2022-08-01 18:59:34','2022-08-01 18:59:34'),(522,7479,261,40727,7710,3,217,1,33.28,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(523,7479,261,40727,7710,3,68,1,6.99,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(524,7479,261,40727,7710,3,217,1,3.32,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(525,7479,261,40727,7710,3,57,2,43.59,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(526,7479,262,40727,7710,3,250,1,1000.00,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(527,7479,262,40727,7710,3,57,2,1000.00,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(528,7479,263,40727,7710,3,217,1,396.00,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(529,7479,263,40727,7710,3,68,1,83.16,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(530,7479,263,40727,7710,3,217,1,20.84,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(531,7479,263,40727,7710,3,57,2,500.00,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(532,7479,264,40727,7710,3,217,1,34709.09,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(533,7479,264,40727,7710,3,68,1,7288.91,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(534,7479,264,40727,7710,3,57,2,41998.00,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(535,7479,265,40727,7710,3,217,1,4131.40,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(536,7479,265,40727,7710,3,68,1,867.60,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(537,7479,265,40727,7710,3,57,2,4999.00,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(538,7479,266,40727,7710,3,217,1,11311.31,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(539,7479,266,40727,7710,3,68,1,1187.69,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(540,7479,266,40727,7710,3,57,2,12499.00,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(541,7479,267,40727,7710,2,218,2,176600.00,NULL,'2022-08-01 18:59:34','2022-08-01 19:56:34','2022-08-01 19:56:34'),(542,7479,267,40727,7710,2,13,1,176600.00,NULL,'2022-08-01 18:59:34','2022-08-01 19:56:34','2022-08-01 19:56:34'),(543,7479,268,40727,7710,2,218,2,176600.00,NULL,'2022-08-01 19:57:38','2022-08-01 20:01:30','2022-08-01 20:01:30'),(544,7479,268,40727,7710,2,13,1,176600.00,NULL,'2022-08-01 19:57:38','2022-08-01 20:01:30','2022-08-01 20:01:30'),(545,7479,269,40727,7710,2,218,2,176600.00,NULL,'2022-08-01 20:03:12','2022-08-01 20:11:56','2022-08-01 20:11:56');
INSERT INTO `balance_libro_details` VALUES (546,7479,269,40727,7710,2,13,1,176600.00,NULL,'2022-08-01 20:03:12','2022-08-01 20:11:56','2022-08-01 20:11:56'),(547,7479,270,40727,7710,2,218,2,176600.00,NULL,'2022-08-01 20:25:12','2022-08-01 20:25:52','2022-08-01 20:25:52'),(548,7479,270,40727,7710,2,13,1,176600.00,NULL,'2022-08-01 20:25:12','2022-08-01 20:25:52','2022-08-01 20:25:52'),(549,7479,271,40727,7710,2,218,2,176600.00,NULL,'2022-08-01 20:25:52','2022-08-01 20:26:48','2022-08-01 20:26:48'),(550,7479,271,40727,7710,2,13,1,176600.00,NULL,'2022-08-01 20:25:52','2022-08-01 20:26:48','2022-08-01 20:26:48'),(551,7479,272,40727,7710,2,218,2,176600.00,NULL,'2022-08-01 20:26:48','2022-08-01 20:26:56','2022-08-01 20:26:56'),(552,7479,272,40727,7710,2,13,1,176600.00,NULL,'2022-08-01 20:26:48','2022-08-01 20:26:56','2022-08-01 20:26:56'),(553,7479,273,40727,7710,2,218,2,176600.00,NULL,'2022-08-01 20:26:56','2022-08-01 20:27:34','2022-08-01 20:27:34'),(554,7479,273,40727,7710,2,13,1,176600.00,NULL,'2022-08-01 20:26:56','2022-08-01 20:27:34','2022-08-01 20:27:34'),(555,7479,274,40727,7710,2,218,2,176600.00,NULL,'2022-08-01 20:27:34','2022-08-02 18:38:32','2022-08-02 18:38:32'),(556,7479,274,40727,7710,2,13,1,176600.00,NULL,'2022-08-01 20:27:34','2022-08-02 18:38:32','2022-08-02 18:38:32'),(557,7479,275,40727,7711,2,218,2,176600.00,NULL,'2022-08-02 18:31:06','2022-08-02 18:38:28','2022-08-02 18:38:28'),(558,7479,275,40727,7711,2,13,1,176600.00,NULL,'2022-08-02 18:31:06','2022-08-02 18:38:28','2022-08-02 18:38:28'),(559,7479,276,40727,7711,2,218,2,176600.00,NULL,'2022-08-02 18:46:50','2022-08-04 21:51:28','2022-08-04 21:51:28'),(560,7479,276,40727,7711,2,13,1,176600.00,NULL,'2022-08-02 18:46:50','2022-08-04 21:51:28','2022-08-04 21:51:28'),(561,7479,277,40722,4533,2,218,2,17120.00,NULL,'2022-08-02 18:56:19','2022-08-02 18:57:51','2022-08-02 18:57:51'),(562,7479,277,40722,4533,2,13,1,17120.00,NULL,'2022-08-02 18:56:19','2022-08-02 18:57:51','2022-08-02 18:57:51'),(563,7479,278,40722,4533,2,218,2,124120.00,NULL,'2022-08-02 18:56:19','2022-08-02 18:57:51','2022-08-02 18:57:51'),(564,7479,278,40722,4533,2,13,1,124120.00,NULL,'2022-08-02 18:56:19','2022-08-02 18:57:51','2022-08-02 18:57:51'),(565,7479,279,40719,9,2,218,2,2000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(566,7479,279,40719,9,2,13,1,2000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(567,7479,280,40719,9,2,218,2,1000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(568,7479,280,40719,9,2,13,1,1000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(569,7479,281,40719,9,2,218,2,700.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(570,7479,281,40719,9,2,13,1,700.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(571,7479,282,40719,9,2,218,2,1000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(572,7479,282,40719,9,2,13,1,1000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(573,7479,283,40719,9,2,218,2,1000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(574,7479,283,40719,9,2,13,1,1000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(575,7479,284,40719,9,2,218,2,6000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(576,7479,284,40719,9,2,13,1,6000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(577,7479,285,40719,9,2,218,2,2000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(578,7479,285,40719,9,2,13,1,2000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(579,7479,286,40719,9,2,218,2,1000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(580,7479,286,40719,9,2,13,1,1000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24');
INSERT INTO `balance_libro_details` VALUES (581,7479,287,40719,9,2,218,2,800.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(582,7479,287,40719,9,2,13,1,800.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(583,7479,288,40719,9,2,218,2,1000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(584,7479,288,40719,9,2,13,1,1000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(585,7479,289,40719,9,2,218,2,3000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(586,7479,289,40719,9,2,13,1,3000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(587,7479,290,40719,9,2,218,2,1000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(588,7479,290,40719,9,2,13,1,1000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(589,7479,291,40719,9,2,218,2,1000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(590,7479,291,40719,9,2,13,1,1000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(591,7479,292,40719,9,2,218,2,3000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(592,7479,292,40719,9,2,13,1,3000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(593,7479,293,40719,9,2,218,2,1000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(594,7479,293,40719,9,2,13,1,1000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(595,7479,294,40719,9,2,218,2,800.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(596,7479,294,40719,9,2,13,1,800.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(597,7479,295,40719,9,2,218,2,1000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(598,7479,295,40719,9,2,13,1,1000.00,NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(599,7479,296,40748,6121,2,218,2,56000.00,NULL,'2022-08-02 20:20:13','2022-08-02 20:22:12','2022-08-02 20:22:12'),(600,7479,296,40748,6121,2,13,1,56000.00,NULL,'2022-08-02 20:20:13','2022-08-02 20:22:12','2022-08-02 20:22:12'),(601,7479,297,40748,6121,2,218,2,15000.00,NULL,'2022-08-02 20:20:13','2022-08-02 20:22:12','2022-08-02 20:22:12'),(602,7479,297,40748,6121,2,13,1,15000.00,NULL,'2022-08-02 20:20:13','2022-08-02 20:22:12','2022-08-02 20:22:12'),(603,7479,298,40748,6121,2,218,2,20000.00,NULL,'2022-08-02 20:20:13','2022-08-02 20:22:12','2022-08-02 20:22:12'),(604,7479,298,40748,6121,2,13,1,20000.00,NULL,'2022-08-02 20:20:13','2022-08-02 20:22:12','2022-08-02 20:22:12'),(605,7479,299,40748,6121,2,218,2,15000.00,NULL,'2022-08-02 20:20:13','2022-08-02 20:22:12','2022-08-02 20:22:12'),(606,7479,299,40748,6121,2,13,1,15000.00,NULL,'2022-08-02 20:20:13','2022-08-02 20:22:12','2022-08-02 20:22:12'),(607,7479,300,40727,7711,2,218,2,176600.00,NULL,'2022-08-04 21:54:19','2022-08-04 22:00:22','2022-08-04 22:00:22'),(608,7479,300,40727,7711,2,13,1,176600.00,NULL,'2022-08-04 21:54:19','2022-08-04 22:00:22','2022-08-04 22:00:22'),(609,7479,301,40727,7711,2,218,2,176600.00,NULL,'2022-08-04 22:01:23','2022-08-04 22:04:12','2022-08-04 22:04:12'),(610,7479,301,40727,7711,2,13,1,176600.00,NULL,'2022-08-04 22:01:23','2022-08-04 22:04:12','2022-08-04 22:04:12'),(611,7479,302,40727,7711,2,218,2,176600.00,NULL,'2022-08-06 11:10:13','2022-08-06 11:17:48','2022-08-06 11:17:48'),(612,7479,302,40727,7711,2,13,1,176600.00,NULL,'2022-08-06 11:10:13','2022-08-06 11:17:48','2022-08-06 11:17:48'),(613,7479,303,40727,7711,2,218,2,176600.00,NULL,'2022-08-06 11:26:42','2022-08-11 18:41:16','2022-08-11 18:41:16'),(614,7479,303,40727,7711,2,13,1,176600.00,NULL,'2022-08-06 11:26:42','2022-08-11 18:41:16','2022-08-11 18:41:16'),(615,7479,304,40719,9,2,218,2,2000.00,NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(616,7479,304,40719,9,2,13,1,2000.00,NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52');
INSERT INTO `balance_libro_details` VALUES (617,7479,305,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(618,7479,305,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(619,7479,306,40719,9,2,218,2,700.00,NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(620,7479,306,40719,9,2,13,1,700.00,NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(621,7479,307,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(622,7479,307,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(623,7479,308,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(624,7479,308,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(625,7479,309,40719,9,2,218,2,6000.00,NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(626,7479,309,40719,9,2,13,1,6000.00,NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(627,7479,310,40719,9,2,218,2,2000.00,NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(628,7479,310,40719,9,2,13,1,2000.00,NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(629,7479,311,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(630,7479,311,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(631,7479,312,40719,9,2,218,2,800.00,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(632,7479,312,40719,9,2,13,1,800.00,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(633,7479,313,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(634,7479,313,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(635,7479,314,40719,9,2,218,2,3000.00,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(636,7479,314,40719,9,2,13,1,3000.00,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(637,7479,315,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(638,7479,315,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(639,7479,316,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(640,7479,316,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(641,7479,317,40719,9,2,218,2,3000.00,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(642,7479,317,40719,9,2,13,1,3000.00,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(643,7479,318,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:44','2022-08-11 18:27:44'),(644,7479,318,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:44','2022-08-11 18:27:44'),(645,7479,319,40719,9,2,218,2,800.00,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:36','2022-08-11 18:27:36'),(646,7479,319,40719,9,2,13,1,800.00,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:36','2022-08-11 18:27:36'),(647,7479,320,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:18','2022-08-11 18:27:18'),(648,7479,320,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:18','2022-08-11 18:27:18'),(649,7479,321,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:27:18','2022-08-11 18:27:52','2022-08-11 18:27:52'),(650,7479,321,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:27:18','2022-08-11 18:27:52','2022-08-11 18:27:52'),(651,7479,322,40719,9,2,218,2,800.00,NULL,'2022-08-11 18:27:36','2022-08-11 18:27:52','2022-08-11 18:27:52'),(652,7479,322,40719,9,2,13,1,800.00,NULL,'2022-08-11 18:27:36','2022-08-11 18:27:52','2022-08-11 18:27:52');
INSERT INTO `balance_libro_details` VALUES (653,7479,323,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:27:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(654,7479,323,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:27:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(655,7479,324,40719,9,2,218,2,2000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:51','2023-06-29 21:42:51'),(656,7479,324,40719,9,2,13,1,2000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:51','2023-06-29 21:42:51'),(657,7479,325,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:48','2023-06-29 21:42:48'),(658,7479,325,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:48','2023-06-29 21:42:48'),(659,7479,326,40719,9,2,218,2,700.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:44','2023-06-29 21:42:44'),(660,7479,326,40719,9,2,13,1,700.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:44','2023-06-29 21:42:44'),(661,7479,327,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:41','2023-06-29 21:42:41'),(662,7479,327,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:41','2023-06-29 21:42:41'),(663,7479,328,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:37','2023-06-29 21:42:37'),(664,7479,328,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:37','2023-06-29 21:42:37'),(665,7479,329,40719,9,2,218,2,6000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:32','2023-06-29 21:42:32'),(666,7479,329,40719,9,2,13,1,6000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:32','2023-06-29 21:42:32'),(667,7479,330,40719,9,2,218,2,2000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:21','2023-06-29 21:42:21'),(668,7479,330,40719,9,2,13,1,2000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:21','2023-06-29 21:42:21'),(669,7479,331,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:17','2023-06-29 21:42:17'),(670,7479,331,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:17','2023-06-29 21:42:17'),(671,7479,332,40719,9,2,218,2,800.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:14','2023-06-29 21:42:14'),(672,7479,332,40719,9,2,13,1,800.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:14','2023-06-29 21:42:14'),(673,7479,333,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:11','2023-06-29 21:42:11'),(674,7479,333,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:11','2023-06-29 21:42:11'),(675,7479,334,40719,9,2,218,2,3000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:07','2023-06-29 21:42:07'),(676,7479,334,40719,9,2,13,1,3000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:07','2023-06-29 21:42:07'),(677,7479,335,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:04','2023-06-29 21:42:04'),(678,7479,335,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:04','2023-06-29 21:42:04'),(679,7479,336,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:00','2023-06-29 21:42:00'),(680,7479,336,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:42:00','2023-06-29 21:42:00'),(681,7479,337,40719,9,2,218,2,3000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:41:56','2023-06-29 21:41:56'),(682,7479,337,40719,9,2,13,1,3000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:41:56','2023-06-29 21:41:56'),(683,7479,338,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:14:24','2023-06-29 21:14:24'),(684,7479,338,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:29:38','2023-06-29 21:14:24','2023-06-29 21:14:24'),(685,7479,339,40719,9,2,218,2,800.00,NULL,'2022-08-11 18:29:39','2023-06-29 21:14:21','2023-06-29 21:14:21'),(686,7479,339,40719,9,2,13,1,800.00,NULL,'2022-08-11 18:29:39','2023-06-29 21:14:21','2023-06-29 21:14:21'),(687,7479,340,40719,9,2,218,2,1000.00,NULL,'2022-08-11 18:29:39','2023-06-29 21:14:17','2023-06-29 21:14:17'),(688,7479,340,40719,9,2,13,1,1000.00,NULL,'2022-08-11 18:29:39','2023-06-29 21:14:17','2023-06-29 21:14:17');
INSERT INTO `balance_libro_details` VALUES (689,7479,341,40727,7711,2,218,2,176600.00,NULL,'2022-08-11 18:41:57','2022-08-23 18:32:46','2022-08-23 18:32:46'),(690,7479,341,40727,7711,2,13,1,176600.00,NULL,'2022-08-11 18:41:57','2022-08-23 18:32:46','2022-08-23 18:32:46'),(691,7479,342,40748,6121,2,218,2,56000.00,NULL,'2022-08-11 19:03:30','2022-08-12 18:44:46','2022-08-12 18:44:46'),(692,7479,342,40748,6121,2,13,1,56000.00,NULL,'2022-08-11 19:03:30','2022-08-12 18:44:46','2022-08-12 18:44:46'),(693,7479,343,40748,6121,2,218,2,15000.00,NULL,'2022-08-11 19:03:30','2022-08-12 18:44:37','2022-08-12 18:44:37'),(694,7479,343,40748,6121,2,13,1,15000.00,NULL,'2022-08-11 19:03:30','2022-08-12 18:44:37','2022-08-12 18:44:37'),(695,7479,344,40748,6121,2,218,2,20000.00,NULL,'2022-08-11 19:03:30','2022-08-12 18:44:29','2022-08-12 18:44:29'),(696,7479,344,40748,6121,2,13,1,20000.00,NULL,'2022-08-11 19:03:30','2022-08-12 18:44:29','2022-08-12 18:44:29'),(697,7479,345,40748,6121,2,218,2,15000.00,NULL,'2022-08-11 19:03:30','2022-08-12 18:44:21','2022-08-12 18:44:21'),(698,7479,345,40748,6121,2,13,1,15000.00,NULL,'2022-08-11 19:03:30','2022-08-12 18:44:21','2022-08-12 18:44:21'),(699,7479,346,40748,6121,2,218,2,15000.00,NULL,'2022-08-12 18:44:21','2022-08-12 18:45:40','2022-08-12 18:45:40'),(700,7479,346,40748,6121,2,13,1,15000.00,NULL,'2022-08-12 18:44:21','2022-08-12 18:45:40','2022-08-12 18:45:40'),(701,7479,347,40748,6121,2,218,2,20000.00,NULL,'2022-08-12 18:44:29','2022-08-12 18:45:40','2022-08-12 18:45:40'),(702,7479,347,40748,6121,2,13,1,20000.00,NULL,'2022-08-12 18:44:29','2022-08-12 18:45:40','2022-08-12 18:45:40'),(703,7479,348,40748,6121,2,218,2,15000.00,NULL,'2022-08-12 18:44:37','2022-08-12 18:45:40','2022-08-12 18:45:40'),(704,7479,348,40748,6121,2,13,1,15000.00,NULL,'2022-08-12 18:44:37','2022-08-12 18:45:40','2022-08-12 18:45:40'),(705,7479,349,40748,6121,2,218,2,56000.00,NULL,'2022-08-12 18:44:46','2022-08-12 18:45:40','2022-08-12 18:45:40'),(706,7479,349,40748,6121,2,13,1,56000.00,NULL,'2022-08-12 18:44:46','2022-08-12 18:45:40','2022-08-12 18:45:40'),(707,7479,350,40748,6121,2,218,2,56000.00,NULL,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(708,7479,350,40748,6121,2,13,1,56000.00,NULL,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(709,7479,351,40748,6121,2,218,2,15000.00,NULL,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(710,7479,351,40748,6121,2,13,1,15000.00,NULL,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(711,7479,352,40748,6121,2,218,2,20000.00,NULL,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(712,7479,352,40748,6121,2,13,1,20000.00,NULL,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(713,7479,353,40748,6121,2,218,2,15000.00,NULL,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(714,7479,353,40748,6121,2,13,1,15000.00,NULL,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(715,7479,354,40719,9,16,156,1,73.38,NULL,'2022-08-12 19:44:50','2023-06-29 20:54:09','2023-06-29 20:54:09'),(716,7479,354,40719,9,16,327,2,73.38,NULL,'2022-08-12 19:44:50','2023-06-29 20:54:09','2023-06-29 20:54:09'),(717,7479,354,40719,9,16,156,1,994.16,NULL,'2022-08-12 19:44:50','2023-06-29 20:54:09','2023-06-29 20:54:09'),(718,7479,354,40719,9,16,326,2,994.16,NULL,'2022-08-12 19:44:50','2023-06-29 20:54:09','2023-06-29 20:54:09'),(719,7479,355,40727,7712,2,218,2,176600.00,NULL,'2022-08-23 18:35:45','2022-08-23 18:36:27','2022-08-23 18:36:27'),(720,7479,355,40727,7712,2,13,1,176600.00,NULL,'2022-08-23 18:35:45','2022-08-23 18:36:27','2022-08-23 18:36:27'),(721,7479,356,40727,7712,2,218,2,176600.00,NULL,'2022-08-23 18:36:27','2022-08-23 18:47:09','2022-08-23 18:47:09'),(722,7479,356,40727,7712,2,13,1,176600.00,NULL,'2022-08-23 18:36:27','2022-08-23 18:47:09','2022-08-23 18:47:09'),(723,7479,357,40727,7712,2,218,2,176000.00,NULL,'2022-08-23 18:47:09','2022-08-23 18:47:09',NULL),(724,7479,357,40727,7712,2,13,1,176000.00,NULL,'2022-08-23 18:47:09','2022-08-23 18:47:09',NULL),(725,7479,358,40719,23,2,218,2,3500.00,NULL,'2023-06-29 21:50:05','2023-06-29 21:50:05',NULL);
INSERT INTO `balance_libro_details` VALUES (726,7479,358,40719,23,2,13,1,3500.00,NULL,'2023-06-29 21:50:05','2023-06-29 21:50:05',NULL),(727,7479,359,40719,23,2,218,2,3500.00,NULL,'2023-06-29 21:50:05','2023-06-29 22:16:53','2023-06-29 22:16:53'),(728,7479,359,40719,23,2,13,1,3500.00,NULL,'2023-06-29 21:50:05','2023-06-29 22:16:53','2023-06-29 22:16:53'),(729,7479,360,40719,23,2,218,2,3500.00,NULL,'2023-06-29 21:50:05','2023-06-29 22:16:49','2023-06-29 22:16:49'),(730,7479,360,40719,23,2,13,1,3500.00,NULL,'2023-06-29 21:50:05','2023-06-29 22:16:49','2023-06-29 22:16:49'),(731,7479,361,40719,23,2,218,2,4000.00,NULL,'2023-06-29 21:50:05','2023-06-29 22:16:46','2023-06-29 22:16:46'),(732,7479,361,40719,23,2,13,1,4000.00,NULL,'2023-06-29 21:50:05','2023-06-29 22:16:46','2023-06-29 22:16:46'),(733,7479,362,40719,23,2,218,2,3500.00,NULL,'2023-06-29 21:50:05','2023-06-29 22:16:42','2023-06-29 22:16:42'),(734,7479,362,40719,23,2,13,1,3500.00,NULL,'2023-06-29 21:50:05','2023-06-29 22:16:42','2023-06-29 22:16:42'),(735,7479,363,40719,23,2,218,2,9500.00,NULL,'2023-06-29 21:50:05','2023-06-29 22:16:39','2023-06-29 22:16:39'),(736,7479,363,40719,23,2,13,1,9500.00,NULL,'2023-06-29 21:50:05','2023-06-29 22:16:39','2023-06-29 22:16:39'),(737,7479,364,40719,23,2,218,2,3500.00,NULL,'2023-06-29 21:50:05','2023-06-29 22:16:34','2023-06-29 22:16:34'),(738,7479,364,40719,23,2,13,1,3500.00,NULL,'2023-06-29 21:50:05','2023-06-29 22:16:34','2023-06-29 22:16:34'),(739,7479,365,40719,23,2,218,2,10000.00,NULL,'2023-06-29 21:50:06','2023-06-29 22:00:49','2023-06-29 22:00:49'),(740,7479,365,40719,23,2,13,1,10000.00,NULL,'2023-06-29 21:50:06','2023-06-29 22:00:49','2023-06-29 22:00:49'),(741,7479,366,40719,23,2,218,2,3500.00,NULL,'2023-06-29 21:50:06','2023-06-29 22:16:28','2023-06-29 22:16:28'),(742,7479,366,40719,23,2,13,1,3500.00,NULL,'2023-06-29 21:50:06','2023-06-29 22:16:28','2023-06-29 22:16:28'),(743,7479,367,40719,23,2,218,2,3500.00,NULL,'2023-06-29 21:50:06','2023-06-29 22:16:24','2023-06-29 22:16:24'),(744,7479,367,40719,23,2,13,1,3500.00,NULL,'2023-06-29 21:50:06','2023-06-29 22:16:24','2023-06-29 22:16:24'),(745,7479,368,40719,23,2,218,2,3500.00,NULL,'2023-06-29 21:50:06','2023-06-29 22:16:20','2023-06-29 22:16:20'),(746,7479,368,40719,23,2,13,1,3500.00,NULL,'2023-06-29 21:50:06','2023-06-29 22:16:20','2023-06-29 22:16:20'),(747,7479,369,40719,23,2,218,2,48000.00,NULL,'2023-06-29 21:50:06','2023-06-29 22:16:13','2023-06-29 22:16:13'),(748,7479,369,40719,23,2,13,1,48000.00,NULL,'2023-06-29 21:50:06','2023-06-29 22:16:13','2023-06-29 22:16:13'),(749,7479,370,40719,23,2,218,2,3500.00,NULL,'2023-06-29 21:50:06','2023-06-29 22:16:09','2023-06-29 22:16:09'),(750,7479,370,40719,23,2,13,1,3500.00,NULL,'2023-06-29 21:50:06','2023-06-29 22:16:09','2023-06-29 22:16:09'),(751,7479,371,40719,23,2,218,2,35000.00,NULL,'2023-06-29 21:50:06','2023-06-29 22:16:06','2023-06-29 22:16:06'),(752,7479,371,40719,23,2,13,1,35000.00,NULL,'2023-06-29 21:50:06','2023-06-29 22:16:06','2023-06-29 22:16:06'),(753,7479,372,40719,23,2,218,2,3500.00,NULL,'2023-06-29 21:50:06','2023-06-29 22:16:02','2023-06-29 22:16:02'),(754,7479,372,40719,23,2,13,1,3500.00,NULL,'2023-06-29 21:50:06','2023-06-29 22:16:02','2023-06-29 22:16:02'),(755,7479,373,40719,23,2,218,2,4000.00,NULL,'2023-06-29 21:50:06','2023-06-29 22:16:17','2023-06-29 22:16:17'),(756,7479,373,40719,23,2,13,1,4000.00,NULL,'2023-06-29 21:50:06','2023-06-29 22:16:17','2023-06-29 22:16:17'),(757,7479,374,40719,23,2,218,2,10000.00,NULL,'2023-06-29 22:00:49','2023-06-29 22:16:31','2023-06-29 22:16:31'),(758,7479,374,40719,23,2,13,1,10000.00,NULL,'2023-06-29 22:00:49','2023-06-29 22:16:31','2023-06-29 22:16:31');
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2022-07-29 18:55:14',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2022-07-29 18:55:14',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2022-07-29 18:55:14',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-07-29 18:55:14','2022-07-29 18:55:14',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-07-29 18:55:21','2022-07-29 18:55:21',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-07-29 18:55:21','2022-07-29 18:55:21',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-07-29 18:55:21','2022-07-29 18:55:21',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-07-29 18:55:21','2022-07-29 18:55:21',NULL),(11,2021,6000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-07-29 18:55:29','2022-07-29 18:55:29',NULL),(12,2021,6000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-07-29 18:55:29','2022-07-29 18:55:29',NULL),(13,2021,6000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-07-29 18:55:29','2022-07-29 18:55:29',NULL),(14,2021,6000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-07-29 18:55:29','2022-07-29 18:55:29',NULL),(15,2022,11282141.08,0.00,5641070.54,0.00,0.0050,0.00,'2023-05-30 15:03:13','2023-05-30 15:03:13',NULL),(16,2022,11282141.08,5641070.54,12222319.51,28205.35,0.0075,5641070.54,'2023-05-30 15:03:13','2023-05-30 15:03:13',NULL),(17,2022,11282141.08,12222319.51,33846423.25,77564.72,0.0100,12222319.51,'2023-05-30 15:03:13','2023-05-30 15:03:13',NULL),(18,2022,11282141.08,33846423.25,188035684.71,293802.76,0.0125,33846423.25,'2023-05-30 15:03:13','2023-05-30 15:03:13',NULL),(19,2022,11282141.08,188035684.71,564107054.14,2221171.53,0.0150,188035684.71,'2023-05-30 15:03:13','2023-05-30 15:03:13',NULL),(20,2022,11282141.08,564107054.14,999999999999.00,7682242.07,0.0175,564107054.14,'2023-05-30 15:03:13','2023-05-30 15:03:13',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar`
--

DROP TABLE IF EXISTS `calendar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `ws_telefono_id` bigint(20) unsigned DEFAULT NULL,
  `title` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion_text` longtext COLLATE utf8mb4_unicode_ci,
  `url` text COLLATE utf8mb4_unicode_ci,
  `start` datetime DEFAULT NULL,
  `startEditable` tinyint(1) NOT NULL DEFAULT '1',
  `startStr` text COLLATE utf8mb4_unicode_ci,
  `end` datetime DEFAULT NULL,
  `endStr` text COLLATE utf8mb4_unicode_ci,
  `allDay` tinyint(1) NOT NULL DEFAULT '1',
  `allow` tinyint(1) DEFAULT NULL,
  `backgroundColor` text COLLATE utf8mb4_unicode_ci,
  `borderColor` text COLLATE utf8mb4_unicode_ci,
  `classNames` longtext COLLATE utf8mb4_unicode_ci,
  `constraint` text COLLATE utf8mb4_unicode_ci,
  `display` text COLLATE utf8mb4_unicode_ci,
  `durationEditable` tinyint(1) NOT NULL DEFAULT '1',
  `extendedProps` longtext COLLATE utf8mb4_unicode_ci,
  `groupId` text COLLATE utf8mb4_unicode_ci,
  `overlap` text COLLATE utf8mb4_unicode_ci,
  `source` longtext COLLATE utf8mb4_unicode_ci,
  `textColor` text COLLATE utf8mb4_unicode_ci,
  `is_impuesto_from_taxes` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_person_id_foreign` (`person_id`),
  KEY `calendar_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `calendar_ws_telefono_id_foreign` (`ws_telefono_id`),
  CONSTRAINT `calendar_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_ws_telefono_id_foreign` FOREIGN KEY (`ws_telefono_id`) REFERENCES `ws_telefonos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar`
--

LOCK TABLES `calendar` WRITE;
/*!40000 ALTER TABLE `calendar` DISABLE KEYS */;
INSERT INTO `calendar` VALUES (1,NULL,40722,NULL,NULL,'Convenio Multilateral - Anual',NULL,NULL,'','2023-05-15 10:00:00',1,NULL,'2023-05-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(2,NULL,40722,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-01-18 10:00:00',1,NULL,'2023-01-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(3,NULL,40722,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-02-17 10:00:00',1,NULL,'2023-02-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(4,NULL,40722,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-03-17 10:00:00',1,NULL,'2023-03-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(5,NULL,40722,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-04-19 10:00:00',1,NULL,'2023-04-19 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(6,NULL,40722,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-05-17 10:00:00',1,NULL,'2023-05-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(7,NULL,40722,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-06-21 10:00:00',1,NULL,'2023-06-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(8,NULL,40722,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-07-19 10:00:00',1,NULL,'2023-07-19 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(9,NULL,40722,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-08-17 10:00:00',1,NULL,'2023-08-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(10,NULL,40722,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-09-19 10:00:00',1,NULL,'2023-09-19 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(11,NULL,40722,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-10-19 10:00:00',1,NULL,'2023-10-19 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(12,NULL,40722,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-11-17 10:00:00',1,NULL,'2023-11-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(13,NULL,40722,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-12-19 10:00:00',1,NULL,'2023-12-19 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(14,NULL,40722,NULL,NULL,'Monotributo - Recategorizacion',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(15,NULL,40722,NULL,NULL,'Monotributo - Recategorizacion',NULL,NULL,'','2022-07-20 10:00:00',1,NULL,'2022-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(16,NULL,40722,NULL,NULL,'Monotributo',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(17,NULL,40722,NULL,NULL,'Monotributo',NULL,NULL,'','2023-02-22 10:00:00',1,NULL,'2023-02-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(18,NULL,40722,NULL,NULL,'Monotributo',NULL,NULL,'','2023-03-20 10:00:00',1,NULL,'2023-03-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(19,NULL,40722,NULL,NULL,'Monotributo',NULL,NULL,'','2023-04-20 10:00:00',1,NULL,'2023-04-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (20,NULL,40722,NULL,NULL,'Monotributo',NULL,NULL,'','2023-05-22 10:00:00',1,NULL,'2023-05-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(21,NULL,40722,NULL,NULL,'Monotributo',NULL,NULL,'','2023-06-21 10:00:00',1,NULL,'2023-06-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(22,NULL,40722,NULL,NULL,'Monotributo',NULL,NULL,'','2023-07-20 10:00:00',1,NULL,'2023-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(23,NULL,40722,NULL,NULL,'Monotributo',NULL,NULL,'','2023-08-22 10:00:00',1,NULL,'2023-08-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(24,NULL,40722,NULL,NULL,'Monotributo',NULL,NULL,'','2023-09-20 10:00:00',1,NULL,'2023-09-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(25,NULL,40722,NULL,NULL,'Monotributo',NULL,NULL,'','2023-10-20 10:00:00',1,NULL,'2023-10-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(26,NULL,40722,NULL,NULL,'Monotributo',NULL,NULL,'','2023-11-21 10:00:00',1,NULL,'2023-11-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(27,NULL,40722,NULL,NULL,'Monotributo',NULL,NULL,'','2023-12-20 10:00:00',1,NULL,'2023-12-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(28,NULL,40719,NULL,NULL,'Convenio Multilateral - Anual',NULL,NULL,'','2023-05-15 10:00:00',1,NULL,'2023-05-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(29,NULL,40719,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-01-17 10:00:00',1,NULL,'2023-01-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(30,NULL,40719,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-02-16 10:00:00',1,NULL,'2023-02-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(31,NULL,40719,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-03-16 10:00:00',1,NULL,'2023-03-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(32,NULL,40719,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-04-18 10:00:00',1,NULL,'2023-04-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(33,NULL,40719,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-05-16 10:00:00',1,NULL,'2023-05-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(34,NULL,40719,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-06-16 10:00:00',1,NULL,'2023-06-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(35,NULL,40719,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-07-18 10:00:00',1,NULL,'2023-07-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(36,NULL,40719,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-08-16 10:00:00',1,NULL,'2023-08-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(37,NULL,40719,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-09-18 10:00:00',1,NULL,'2023-09-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(38,NULL,40719,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-10-18 10:00:00',1,NULL,'2023-10-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (39,NULL,40719,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-11-16 10:00:00',1,NULL,'2023-11-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(40,NULL,40719,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-12-18 10:00:00',1,NULL,'2023-12-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(41,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(42,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-02-22 10:00:00',1,NULL,'2023-02-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(43,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-03-20 10:00:00',1,NULL,'2023-03-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(44,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-04-20 10:00:00',1,NULL,'2023-04-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(45,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-05-22 10:00:00',1,NULL,'2023-05-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(46,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-06-21 10:00:00',1,NULL,'2023-06-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(47,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-07-20 10:00:00',1,NULL,'2023-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(48,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-08-22 10:00:00',1,NULL,'2023-08-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(49,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-09-20 10:00:00',1,NULL,'2023-09-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(50,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-10-20 10:00:00',1,NULL,'2023-10-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(51,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-11-21 10:00:00',1,NULL,'2023-11-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(52,NULL,40719,NULL,NULL,'Monotributo',NULL,NULL,'','2023-12-20 10:00:00',1,NULL,'2023-12-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(53,NULL,40719,NULL,NULL,'Monotributo - Recategorizacion',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(54,NULL,40719,NULL,NULL,'Monotributo - Recategorizacion',NULL,NULL,'','2022-07-20 10:00:00',1,NULL,'2022-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(55,NULL,40727,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-01-17 10:00:00',1,NULL,'2023-01-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(56,NULL,40727,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-02-16 10:00:00',1,NULL,'2023-02-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(57,NULL,40727,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-03-16 10:00:00',1,NULL,'2023-03-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (58,NULL,40727,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-04-18 10:00:00',1,NULL,'2023-04-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(59,NULL,40727,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-05-16 10:00:00',1,NULL,'2023-05-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(60,NULL,40727,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-06-16 10:00:00',1,NULL,'2023-06-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(61,NULL,40727,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-07-18 10:00:00',1,NULL,'2023-07-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(62,NULL,40727,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-08-16 10:00:00',1,NULL,'2023-08-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(63,NULL,40727,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-09-18 10:00:00',1,NULL,'2023-09-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(64,NULL,40727,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-10-18 10:00:00',1,NULL,'2023-10-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(65,NULL,40727,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-11-16 10:00:00',1,NULL,'2023-11-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(66,NULL,40727,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-12-18 10:00:00',1,NULL,'2023-12-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(67,NULL,40727,NULL,NULL,'Convenio Multilateral - Anual',NULL,NULL,'','2023-05-15 10:00:00',1,NULL,'2023-05-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(68,NULL,40727,NULL,NULL,'Monotributo',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(69,NULL,40727,NULL,NULL,'Monotributo',NULL,NULL,'','2023-02-22 10:00:00',1,NULL,'2023-02-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(70,NULL,40727,NULL,NULL,'Monotributo',NULL,NULL,'','2023-03-20 10:00:00',1,NULL,'2023-03-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(71,NULL,40727,NULL,NULL,'Monotributo',NULL,NULL,'','2023-04-20 10:00:00',1,NULL,'2023-04-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(72,NULL,40727,NULL,NULL,'Monotributo',NULL,NULL,'','2023-05-22 10:00:00',1,NULL,'2023-05-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(73,NULL,40727,NULL,NULL,'Monotributo',NULL,NULL,'','2023-06-21 10:00:00',1,NULL,'2023-06-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(74,NULL,40727,NULL,NULL,'Monotributo',NULL,NULL,'','2023-07-20 10:00:00',1,NULL,'2023-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(75,NULL,40727,NULL,NULL,'Monotributo',NULL,NULL,'','2023-08-22 10:00:00',1,NULL,'2023-08-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(76,NULL,40727,NULL,NULL,'Monotributo',NULL,NULL,'','2023-09-20 10:00:00',1,NULL,'2023-09-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (77,NULL,40727,NULL,NULL,'Monotributo',NULL,NULL,'','2023-10-20 10:00:00',1,NULL,'2023-10-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(78,NULL,40727,NULL,NULL,'Monotributo',NULL,NULL,'','2023-11-21 10:00:00',1,NULL,'2023-11-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(79,NULL,40727,NULL,NULL,'Monotributo',NULL,NULL,'','2023-12-20 10:00:00',1,NULL,'2023-12-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(80,NULL,40727,NULL,NULL,'Monotributo - Recategorizacion',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(81,NULL,40727,NULL,NULL,'Monotributo - Recategorizacion',NULL,NULL,'','2022-07-20 10:00:00',1,NULL,'2022-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(82,NULL,40748,NULL,NULL,'Convenio Multilateral - Anual',NULL,NULL,'','2023-05-15 10:00:00',1,NULL,'2023-05-15 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(83,NULL,40748,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-01-17 10:00:00',1,NULL,'2023-01-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(84,NULL,40748,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-02-16 10:00:00',1,NULL,'2023-02-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(85,NULL,40748,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-03-16 10:00:00',1,NULL,'2023-03-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(86,NULL,40748,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-04-18 10:00:00',1,NULL,'2023-04-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(87,NULL,40748,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-05-16 10:00:00',1,NULL,'2023-05-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(88,NULL,40748,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-06-16 10:00:00',1,NULL,'2023-06-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(89,NULL,40748,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-07-18 10:00:00',1,NULL,'2023-07-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(90,NULL,40748,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-08-16 10:00:00',1,NULL,'2023-08-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(91,NULL,40748,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-09-18 10:00:00',1,NULL,'2023-09-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(92,NULL,40748,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-10-18 10:00:00',1,NULL,'2023-10-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(93,NULL,40748,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-11-16 10:00:00',1,NULL,'2023-11-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(94,NULL,40748,NULL,NULL,'Convenio Multilateral - DDJJ',NULL,NULL,'','2023-12-18 10:00:00',1,NULL,'2023-12-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(95,NULL,40748,NULL,NULL,'Monotributo',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (96,NULL,40748,NULL,NULL,'Monotributo',NULL,NULL,'','2023-02-22 10:00:00',1,NULL,'2023-02-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(97,NULL,40748,NULL,NULL,'Monotributo',NULL,NULL,'','2023-03-20 10:00:00',1,NULL,'2023-03-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(98,NULL,40748,NULL,NULL,'Monotributo',NULL,NULL,'','2023-04-20 10:00:00',1,NULL,'2023-04-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(99,NULL,40748,NULL,NULL,'Monotributo',NULL,NULL,'','2023-05-22 10:00:00',1,NULL,'2023-05-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(100,NULL,40748,NULL,NULL,'Monotributo',NULL,NULL,'','2023-06-21 10:00:00',1,NULL,'2023-06-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(101,NULL,40748,NULL,NULL,'Monotributo',NULL,NULL,'','2023-07-20 10:00:00',1,NULL,'2023-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(102,NULL,40748,NULL,NULL,'Monotributo',NULL,NULL,'','2023-08-22 10:00:00',1,NULL,'2023-08-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(103,NULL,40748,NULL,NULL,'Monotributo',NULL,NULL,'','2023-09-20 10:00:00',1,NULL,'2023-09-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(104,NULL,40748,NULL,NULL,'Monotributo',NULL,NULL,'','2023-10-20 10:00:00',1,NULL,'2023-10-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(105,NULL,40748,NULL,NULL,'Monotributo',NULL,NULL,'','2023-11-21 10:00:00',1,NULL,'2023-11-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(106,NULL,40748,NULL,NULL,'Monotributo',NULL,NULL,'','2023-12-20 10:00:00',1,NULL,'2023-12-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(107,NULL,40748,NULL,NULL,'Monotributo - Recategorizacion',NULL,NULL,'','2023-01-20 10:00:00',1,NULL,'2023-01-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(108,NULL,40748,NULL,NULL,'Monotributo - Recategorizacion',NULL,NULL,'','2022-07-20 10:00:00',1,NULL,'2022-07-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `calendar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_emails_telefonos`
--

DROP TABLE IF EXISTS `calendar_emails_telefonos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_emails_telefonos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci,
  `celular` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_emails_telefonos_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_emails_telefonos_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_emails_telefonos`
--

LOCK TABLES `calendar_emails_telefonos` WRITE;
/*!40000 ALTER TABLE `calendar_emails_telefonos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_emails_telefonos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_files`
--

DROP TABLE IF EXISTS `calendar_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_files_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_files_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_files`
--

LOCK TABLES `calendar_files` WRITE;
/*!40000 ALTER TABLE `calendar_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1`
--

DROP TABLE IF EXISTS `calendar_niv_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_1_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1`
--

LOCK TABLES `calendar_niv_1` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1_2`
--

DROP TABLE IF EXISTS `calendar_niv_1_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_2_person_id_foreign` (`person_id`),
  KEY `calendar_niv_1_2_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_niv_1_2_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_niv_1_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1_2`
--

LOCK TABLES `calendar_niv_1_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_2`
--

DROP TABLE IF EXISTS `calendar_niv_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_2_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_2`
--

LOCK TABLES `calendar_niv_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_notificaciones`
--

DROP TABLE IF EXISTS `calendar_notificaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_notificaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `start` datetime DEFAULT NULL,
  `tipo_de_notificacion_id` int(10) unsigned NOT NULL,
  `cantidad` int(10) unsigned NOT NULL,
  `unidad_de_tiempo_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_notificaciones_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_notificaciones_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_notificaciones`
--

LOCK TABLES `calendar_notificaciones` WRITE;
/*!40000 ALTER TABLE `calendar_notificaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_notificaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo`
--

DROP TABLE IF EXISTS `calendar_tur_dispo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `dia_hora` datetime(5) DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00:30',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_tur_dispo_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_tur_dispo_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo`
--

LOCK TABLES `calendar_tur_dispo` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo_datos`
--

DROP TABLE IF EXISTS `calendar_tur_dispo_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_tur_dispo_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre_ape` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_datos_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` (`calendar_tur_dispo_id`),
  CONSTRAINT `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` FOREIGN KEY (`calendar_tur_dispo_id`) REFERENCES `calendar_tur_dispo` (`id`),
  CONSTRAINT `calendar_tur_dispo_datos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo_datos`
--

LOCK TABLES `calendar_tur_dispo_datos` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1850.00,11100.00,370000.00,30,3300,NULL,'1',NULL,'2022-10-23 23:32:30',NULL),(2,'B',2750.00,16500.00,550000.00,45,5000,NULL,'1',NULL,'2022-10-23 23:32:30',NULL),(3,'C',3850.00,23100.00,770000.00,60,6700,NULL,'1',NULL,'2022-10-23 23:32:30',NULL),(4,'D',5300.00,31800.00,1060000.00,85,10000,NULL,'1',NULL,'2022-10-23 23:32:30',NULL),(5,'E',7000.00,42000.00,1400000.00,110,13000,NULL,'1',NULL,'2022-10-23 23:32:30',NULL),(6,'F',8750.00,52500.00,1750000.00,150,16500,NULL,'1',NULL,'2022-10-23 23:32:30',NULL),(7,'G',10500.00,63000.00,2100000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:32:30',NULL),(8,'H',13000.00,78000.00,2600000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:32:30',NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',2108288.01,175690.67,'No Excluida','0',30,3330,485448.92,1047.86,1047.86,4623.27,6457.26,12128.39,12128.39,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',3133941.63,261161.80,'No Excluida','0',45,5000,485448.92,2018.89,2018.89,5085.60,6457.26,13561.75,13561.75,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',4387518.23,365626.52,'No Excluida','0',60,6700,970897.79,3452.09,3190.00,5594.16,6457.26,15503.51,15241.42,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',5449094.55,454091.21,'No Excluida','0',85,10000,970897.79,5671.23,5239.75,6153.58,7673.13,19497.94,19066.46,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',6416528.72,534710.73,'No Excluida','0',110,13000,1209769.40,10787.67,8368.13,6768.94,9389.36,26945.97,24526.43,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',8020660.90,668388.41,'No Excluida','0',150,16500,1213622.14,14840.88,10926.38,7445.83,10850.90,33137.61,29223.11,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',9624793.05,802066.09,'No Excluida','0',200,20000,1456346.67,18878.58,13623.24,8190.41,11625.96,38694.95,33439.61,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',11916410.45,993034.20,'No Excluida','0',200,20000,1941795.53,43150.91,33442.08,9009.45,13951.15,66111.51,56402.68,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',13337213.22,1111434.44,'Venta de Bs Muebles','0',200,20000,1941795.53,NULL,53938.71,9910.39,17272.86,NULL,81121.96,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',15285088.04,1273757.34,'Venta de Bs Muebles','0',200,20000,1941795.53,NULL,63385.73,10901.43,19332.31,NULL,93619.47,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',16957968.71,1413164.06,'Venta de Bs Muebles','0',200,20000,1941795.53,NULL,72817.31,11991.57,22155.77,NULL,106964.65,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',1414762.00,117896.00,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL),(13,'A Exento',1414762.00,117896.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2192.15,3061.75,5253.90,5253.90,'',NULL,NULL,'0',NULL,NULL,NULL),(14,'B Exento',2103025.00,175252.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2411.36,3061.75,5473.11,5473.11,'',NULL,NULL,'0',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `chequeras_tipos`
--

DROP TABLE IF EXISTS `chequeras_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chequeras_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chequeras_tipos`
--

LOCK TABLES `chequeras_tipos` WRITE;
/*!40000 ALTER TABLE `chequeras_tipos` DISABLE KEYS */;
INSERT INTO `chequeras_tipos` VALUES (1,NULL,'Fisica',1,NULL,NULL,NULL),(2,NULL,'Electronica',1,NULL,NULL,NULL),(3,NULL,'Transferencias',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `chequeras_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cheques_transfer_emitidas`
--

DROP TABLE IF EXISTS `cheques_transfer_emitidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cheques_transfer_emitidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_cheq_id` int(10) unsigned NOT NULL,
  `fecha_emision` date NOT NULL,
  `fecha_cobro` date NOT NULL,
  `numero_cheque` int(11) NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cheques_transfer_emitidas_person_id_foreign` (`person_id`),
  KEY `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cte_tes_ban_che_id_foreign` (`cta_cte_tesoreria_banco_cheq_id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cte_tes_ban_che_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_cheq_id`) REFERENCES `cta_cte_tesoreria_banco_cheq` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cheques_transfer_emitidas`
--

LOCK TABLES `cheques_transfer_emitidas` WRITE;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,NULL,'Clave Fiscal',NULL,NULL,NULL),(2,NULL,'Clave Ciudad',NULL,NULL,NULL),(3,NULL,'Clave ARBA',NULL,NULL,NULL),(4,NULL,'Clave ANSES',NULL,NULL,NULL),(5,NULL,'Catedral',NULL,NULL,NULL),(6,NULL,'CEMIBA',NULL,NULL,NULL),(7,NULL,'COMPRA ARG',NULL,NULL,NULL),(8,NULL,'Consejo Ciencias Economicas',NULL,NULL,NULL),(9,NULL,'Correo',NULL,NULL,NULL),(10,NULL,'CUR',NULL,NULL,NULL),(11,NULL,'Firma Digital',NULL,NULL,NULL),(12,NULL,'Interbanking',NULL,NULL,NULL),(13,NULL,'Banco Citibank',NULL,NULL,NULL),(14,NULL,'Banco Ciudad',NULL,NULL,NULL),(15,NULL,'Banco Frances',NULL,NULL,NULL),(16,NULL,'Banco Galicia',NULL,NULL,NULL),(17,NULL,'Banco HSBC',NULL,NULL,NULL),(18,NULL,'Banco Itau',NULL,NULL,NULL),(19,NULL,'Banco Nacion',NULL,NULL,NULL),(20,NULL,'Banco Macro',NULL,NULL,NULL),(21,NULL,'Banco Patagonia',NULL,NULL,NULL),(22,NULL,'Banco Provincia',NULL,NULL,NULL),(23,NULL,'Banco Santander',NULL,NULL,NULL),(24,NULL,'Banco Supervielle',NULL,NULL,NULL),(25,NULL,'Seguridad e Higiene',NULL,NULL,NULL),(26,NULL,'Sindicato - ANSES',NULL,NULL,NULL),(27,NULL,'Sindicato - AOT',NULL,NULL,NULL),(28,NULL,'Sindicato - ATSA',NULL,NULL,NULL),(29,NULL,'Sindicato - Camioneros',NULL,NULL,NULL),(30,NULL,'Sindicato - Guinchero',NULL,NULL,NULL),(31,NULL,'Sindicato - IERIC',NULL,NULL,NULL),(32,NULL,'Sindicato - La Estrella',NULL,NULL,NULL),(33,NULL,'Sindicato - Nemesis',NULL,NULL,NULL),(34,NULL,'Sindicato - Pasta',NULL,NULL,NULL),(35,NULL,'Sindicato - SEC',NULL,NULL,NULL),(36,NULL,'Sindicato - SICOP',NULL,NULL,NULL),(37,NULL,'Sindicato - SOCAYA',NULL,NULL,NULL),(38,NULL,'Sindicato - UTHGRA',NULL,NULL,NULL),(39,NULL,'Sindicato - INACAP',NULL,NULL,NULL),(40,NULL,'Sindicato - Otro',NULL,NULL,NULL),(41,NULL,'Otra',NULL,NULL,NULL),(42,NULL,'Prisma - Firma Digital',NULL,NULL,NULL),(43,NULL,'Sindicato - FATSA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
INSERT INTO `claves_details` VALUES (12,7479,NULL,'Flor056544',NULL,1,40722,1,'2022-07-29 22:19:52','2022-07-29 22:19:52',NULL),(41,7479,NULL,'Impuestos2022',NULL,1,40727,1,'2022-08-02 18:46:07','2022-08-02 18:46:07',NULL),(45,7479,NULL,'Impuestos2022',NULL,1,40748,1,'2022-08-11 19:32:36','2022-08-11 19:32:36',NULL),(46,7479,NULL,'Lasheras1790*',NULL,1,40719,1,'2023-06-29 21:37:57','2023-06-29 21:37:57',NULL);
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2022-07-29 18:55:22','2022-07-29 18:55:22',NULL),(2,NULL,'Articulo 6',6,0,'2022-07-29 18:55:22','2022-07-29 18:55:22',NULL),(3,NULL,'Articulo 7',7,0,'2022-07-29 18:55:22','2022-07-29 18:55:22',NULL),(4,NULL,'Articulo 8',8,0,'2022-07-29 18:55:22','2022-07-29 18:55:22',NULL),(5,NULL,'Articulo 9',9,0,'2022-07-29 18:55:22','2022-07-29 18:55:22',NULL),(6,NULL,'Articulo 10',10,0,'2022-07-29 18:55:22','2022-07-29 18:55:22',NULL),(7,NULL,'Articulo 11',11,0,'2022-07-29 18:55:22','2022-07-29 18:55:22',NULL),(8,NULL,'Articulo 12',12,0,'2022-07-29 18:55:22','2022-07-29 18:55:22',NULL),(9,NULL,'Articulo 13',13,0,'2022-07-29 18:55:22','2022-07-29 18:55:22',NULL),(10,NULL,'Articulo 14',14,1,'2022-07-29 18:55:22','2022-07-29 18:55:22',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores`
--

DROP TABLE IF EXISTS `cobradores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores`
--

LOCK TABLES `cobradores` WRITE;
/*!40000 ALTER TABLE `cobradores` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_datos`
--

DROP TABLE IF EXISTS `cobradores_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `url_panel` longtext COLLATE utf8mb4_unicode_ci,
  `usuario` text COLLATE utf8mb4_unicode_ci,
  `clave` text COLLATE utf8mb4_unicode_ci,
  `numero_de_soporte` text COLLATE utf8mb4_unicode_ci,
  `inicial_create_user` text COLLATE utf8mb4_unicode_ci,
  `imp_min_p_retirar` int(11) DEFAULT NULL,
  `secret_recarga` text COLLATE utf8mb4_unicode_ci,
  `secret_on_off` text COLLATE utf8mb4_unicode_ci,
  `clave_new_user` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_datos_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_datos_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_datos`
--

LOCK TABLES `cobradores_datos` WRITE;
/*!40000 ALTER TABLE `cobradores_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_metodos`
--

DROP TABLE IF EXISTS `cobradores_metodos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_metodos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cobradores_metodos_descripcion_unique` (`descripcion`),
  KEY `cobradores_metodos_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_metodos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_metodos`
--

LOCK TABLES `cobradores_metodos` WRITE;
/*!40000 ALTER TABLE `cobradores_metodos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_metodos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_on_off`
--

DROP TABLE IF EXISTS `cobradores_on_off`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_on_off` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `on_off` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_on_off_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_on_off_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_on_off`
--

LOCK TABLES `cobradores_on_off` WRITE;
/*!40000 ALTER TABLE `cobradores_on_off` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_on_off` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condicion_frente_al_iva`
--

DROP TABLE IF EXISTS `condicion_frente_al_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condicion_frente_al_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo_afip` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_comprobantes_a` tinyint(1) NOT NULL DEFAULT '0',
  `show_comprobantes_b` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condicion_frente_al_iva`
--

LOCK TABLES `condicion_frente_al_iva` WRITE;
/*!40000 ALTER TABLE `condicion_frente_al_iva` DISABLE KEYS */;
INSERT INTO `condicion_frente_al_iva` VALUES (1,NULL,1,'IVA Responsable Inscripto',1,0,1,NULL,NULL,NULL),(2,NULL,2,'IVA Responsable no Inscripto',0,0,1,NULL,NULL,NULL),(3,NULL,3,'IVA no Responsable',0,0,1,NULL,NULL,NULL),(4,NULL,4,'IVA Sujeto Exento',0,1,1,NULL,NULL,NULL),(5,NULL,5,'Consumidor Final',0,1,1,NULL,NULL,NULL),(6,NULL,6,'Responsable Monotributo',1,0,1,NULL,NULL,NULL),(7,NULL,7,'Sujeto no Categorizado',0,1,1,NULL,NULL,NULL),(8,NULL,8,'Proveedor del Exterior',0,1,1,NULL,NULL,NULL),(9,NULL,9,'Cliente del Exterior',0,1,1,NULL,NULL,NULL),(10,NULL,10,'IVA Liberado – Ley Nº 19.640',0,1,1,NULL,NULL,NULL),(11,NULL,11,'IVA Responsable Inscripto – Agente de Percepción',0,0,1,NULL,NULL,NULL),(12,NULL,12,'Pequeño Contribuyente Eventual',0,0,1,NULL,NULL,NULL),(13,NULL,13,'Monotributista Social',1,0,1,NULL,NULL,NULL),(14,NULL,14,'Pequeño Contribuyente Eventual Social',0,0,1,NULL,NULL,NULL),(15,NULL,NULL,'Monotributista Trabajador Independiente Promovido',1,0,1,NULL,NULL,NULL),(16,NULL,NULL,'IVA No Alcanzado',0,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `condicion_frente_al_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones_venta`
--

LOCK TABLES `condiciones_venta` WRITE;
/*!40000 ALTER TABLE `condiciones_venta` DISABLE KEYS */;
INSERT INTO `condiciones_venta` VALUES (1,'Contado',NULL,NULL),(2,'Tarjeta de Debito',NULL,NULL),(3,'Tarjeta de Credito',NULL,NULL),(4,'Cuenta Corriente',NULL,NULL),(5,'Cheque',NULL,NULL),(6,'Ticket',NULL,NULL),(7,'Transferencia',NULL,NULL),(8,'Otra',NULL,NULL);
/*!40000 ALTER TABLE `condiciones_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas`
--

DROP TABLE IF EXISTS `consultas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas`
--

LOCK TABLES `consultas` WRITE;
/*!40000 ALTER TABLE `consultas` DISABLE KEYS */;
INSERT INTO `consultas` VALUES (1,NULL,'Estado Liquidaciones',1,NULL,NULL,NULL),(2,NULL,'Consumo',1,NULL,NULL,NULL),(3,NULL,'Resultado Liquidacion Hijas',1,'2023-03-12 23:42:00','2023-03-12 23:42:00',NULL);
/*!40000 ALTER TABLE `consultas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas_aux`
--

DROP TABLE IF EXISTS `consultas_aux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas_aux` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `consulta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `estado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consultas_aux_consulta_id_foreign` (`consulta_id`),
  KEY `consultas_aux_person_id_foreign` (`person_id`),
  CONSTRAINT `consultas_aux_consulta_id_foreign` FOREIGN KEY (`consulta_id`) REFERENCES `consultas` (`id`),
  CONSTRAINT `consultas_aux_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas_aux`
--

LOCK TABLES `consultas_aux` WRITE;
/*!40000 ALTER TABLE `consultas_aux` DISABLE KEYS */;
INSERT INTO `consultas_aux` VALUES (1,NULL,1,NULL,'[{\"id\":40722,\"user_id\":7479,\"field_name1\":\"ALVAREZ FLORENCIA\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-40275454-6\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2022-07-29T22:10:13.000000Z\",\"updated_at\":\"2022-07-29T22:10:13.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":5,\"user_id\":7479,\"person_id\":40722,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2022-07-29T22:10:14.000000Z\",\"updated_at\":\"2022-07-30T01:19:52.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"1000.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":0,\"obligation_electronic_receipt\":0,\"obligation_iibb\":4,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2022-05\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":null,\"person_id_administrador\":40722,\"person_id_titular\":40722,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-07-29T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":1,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":null,\"periods\":[{\"id\":4532,\"user_id\":null,\"code\":\"2022-06\",\"year\":2022,\"period_number\":6,\"date_from\":\"2022-06-01\",\"date_to\":\"2022-06-30\",\"created_at\":null,\"updated_at\":null,\"person_id\":40722,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40719,\"user_id\":7479,\"field_name1\":\"Gramajo Valeria\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-27178730-3\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2020-11-27T06:11:08.000000Z\",\"updated_at\":\"2022-07-30T01:46:24.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":2,\"user_id\":7479,\"person_id\":40719,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2022-07-29T21:55:31.000000Z\",\"updated_at\":\"2022-07-30T01:51:09.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":0,\"obligation_electronic_receipt\":0,\"obligation_iibb\":4,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2022-1\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":2,\"person_id_administrador\":40719,\"person_id_titular\":40719,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-07-29T03:00:00.000000Z\",\"iibb\":\"27271787303\",\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":1,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":null,\"periods\":[{\"id\":8,\"user_id\":null,\"code\":\"2022-06\",\"year\":2022,\"period_number\":6,\"date_from\":\"2022-06-01\",\"date_to\":\"2022-06-30\",\"created_at\":null,\"updated_at\":null,\"person_id\":40719,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]}]',1,'2022-07-29 22:59:55','2022-07-29 22:59:55',NULL);
/*!40000 ALTER TABLE `consultas_aux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos`
--

DROP TABLE IF EXISTS `conta_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `debe_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `haber_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `ctactecheque_id` int(10) unsigned DEFAULT NULL,
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `adjunto` text COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `radioChecked` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `CuentaTipo_id` int(10) unsigned DEFAULT NULL,
  `CentroCosto_id` int(10) unsigned DEFAULT NULL,
  `pagado` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_person_id_foreign` (`person_id`),
  KEY `conta_asientos_period_id_foreign` (`period_id`),
  KEY `conta_asientos_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `conta_asientos_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `conta_asientos_ctactecheque_id_foreign` (`ctactecheque_id`),
  KEY `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` (`haber_cta_cte_tesoreria_cuenta_id`),
  KEY `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` (`debe_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `conta_asientos_ctactecheque_id_foreign` FOREIGN KEY (`ctactecheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `conta_asientos_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`debe_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`haber_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos`
--

LOCK TABLES `conta_asientos` WRITE;
/*!40000 ALTER TABLE `conta_asientos` DISABLE KEYS */;
INSERT INTO `conta_asientos` VALUES (1,7479,40722,NULL,2,NULL,NULL,NULL,NULL,'2022-07-28','2022-07-28',1000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2022-07-29 21:00:53','2022-07-29 21:06:38','2022-07-29 21:06:38'),(2,7479,40722,NULL,2,NULL,NULL,NULL,NULL,'2022-07-29','2022-07-29',1000.00,NULL,'Honorario Mensual 2022-06',1,1,NULL,NULL,NULL,'2022-07-29 21:06:14','2022-07-30 16:05:37','2022-07-30 16:05:37'),(3,7479,40722,NULL,2,NULL,NULL,NULL,NULL,'2022-07-30','2022-07-30',1000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2022-07-30 16:03:09','2022-07-30 16:03:27','2022-07-30 16:03:27'),(4,7479,40722,NULL,2,NULL,NULL,NULL,NULL,'2022-07-30','2022-07-30',1000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2022-07-30 16:05:14','2022-07-30 16:05:32','2022-07-30 16:05:32'),(5,7479,40722,NULL,2,NULL,NULL,NULL,NULL,'2023-06-29','2023-06-29',1000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-06-29 21:57:37','2023-06-29 21:57:37',NULL),(6,7479,40727,NULL,2,NULL,NULL,NULL,NULL,'2023-06-29','2023-06-29',35.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-06-29 21:57:37','2023-06-29 21:57:37',NULL),(7,7479,40722,NULL,2,NULL,NULL,NULL,NULL,'2023-06-29','2023-06-29',1000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-06-29 22:24:59','2023-06-29 22:24:59',NULL),(8,7479,40727,NULL,2,NULL,NULL,NULL,NULL,'2023-06-29','2023-06-29',35.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-06-29 22:24:59','2023-10-14 15:48:54','2023-10-14 15:48:54'),(9,7479,40727,NULL,2,13,480,NULL,NULL,'2023-06-29','2023-10-14',35.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2023-10-14 15:48:54','2023-10-14 15:48:54',NULL);
/*!40000 ALTER TABLE `conta_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos_details`
--

DROP TABLE IF EXISTS `conta_asientos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_details_conta_asiento_id_foreign` (`conta_asiento_id`),
  KEY `conta_asientos_details_person_id_foreign` (`person_id`),
  KEY `conta_asientos_details_period_id_foreign` (`period_id`),
  KEY `conta_asientos_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_details_saldo_id_foreign` (`saldo_id`),
  KEY `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_details_conta_asiento_id_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_asientos_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos_details`
--

LOCK TABLES `conta_asientos_details` WRITE;
/*!40000 ALTER TABLE `conta_asientos_details` DISABLE KEYS */;
INSERT INTO `conta_asientos_details` VALUES (1,7479,1,40722,NULL,2,13,1,1000.00,'2022-07-29 21:00:53','2022-07-29 21:06:38','2022-07-29 21:06:38'),(2,7479,1,40722,NULL,2,480,2,1000.00,'2022-07-29 21:00:53','2022-07-29 21:06:38','2022-07-29 21:06:38'),(3,7479,2,40722,NULL,2,13,1,1000.00,'2022-07-29 21:06:14','2022-07-30 16:05:37','2022-07-30 16:05:37'),(4,7479,2,40722,NULL,2,480,2,1000.00,'2022-07-29 21:06:14','2022-07-30 16:05:37','2022-07-30 16:05:37'),(5,7479,3,40722,NULL,2,13,1,1000.00,'2022-07-30 16:03:09','2022-07-30 16:03:27','2022-07-30 16:03:27'),(6,7479,3,40722,NULL,2,480,2,1000.00,'2022-07-30 16:03:09','2022-07-30 16:03:27','2022-07-30 16:03:27'),(7,7479,4,40722,NULL,2,13,1,1000.00,'2022-07-30 16:05:14','2022-07-30 16:05:32','2022-07-30 16:05:32'),(8,7479,4,40722,NULL,2,480,2,1000.00,'2022-07-30 16:05:14','2022-07-30 16:05:32','2022-07-30 16:05:32'),(9,7479,5,40722,NULL,2,13,1,1000.00,'2023-06-29 21:57:37','2023-06-29 21:57:37',NULL),(10,7479,5,40722,NULL,2,480,2,1000.00,'2023-06-29 21:57:37','2023-06-29 21:57:37',NULL),(11,7479,6,40727,NULL,2,13,1,35.00,'2023-06-29 21:57:37','2023-06-29 21:57:37',NULL),(12,7479,6,40727,NULL,2,480,2,35.00,'2023-06-29 21:57:37','2023-06-29 21:57:37',NULL),(13,7479,7,40722,NULL,2,13,1,1000.00,'2023-06-29 22:24:59','2023-06-29 22:24:59',NULL),(14,7479,7,40722,NULL,2,480,2,1000.00,'2023-06-29 22:24:59','2023-06-29 22:24:59',NULL),(15,7479,8,40727,NULL,2,13,1,35.00,'2023-06-29 22:24:59','2023-10-14 15:48:54','2023-10-14 15:48:54'),(16,7479,8,40727,NULL,2,480,2,35.00,'2023-06-29 22:24:59','2023-10-14 15:48:54','2023-10-14 15:48:54'),(17,7479,9,40727,NULL,2,13,1,35.00,'2023-10-14 15:48:54','2023-10-14 15:48:54',NULL),(18,7479,9,40727,NULL,2,480,2,35.00,'2023-10-14 15:48:54','2023-10-14 15:48:54',NULL);
/*!40000 ALTER TABLE `conta_asientos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costo_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_centro_costo_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costo_plan_cuenta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_centro_costo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` (`conta_centro_costo_id`),
  KEY `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` (`conta_plan_cuenta_id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` FOREIGN KEY (`conta_centro_costo_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` FOREIGN KEY (`conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costo_plan_cuenta`
--

LOCK TABLES `conta_centro_costo_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costos`
--

DROP TABLE IF EXISTS `conta_centro_costos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costos_person_id_foreign` (`person_id`),
  CONSTRAINT `conta_centro_costos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costos`
--

LOCK TABLES `conta_centro_costos` WRITE;
/*!40000 ALTER TABLE `conta_centro_costos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_plan_cuenta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo` int(11) NOT NULL,
  `tipo_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `padre` int(11) NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rubro` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `no_editable` int(11) NOT NULL DEFAULT '1',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_plan_cuenta_tipo_cuenta_id_foreign` (`tipo_cuenta_id`),
  KEY `conta_plan_cuenta_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `conta_plan_cuenta_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_plan_cuenta_tipo_cuenta_id_foreign` FOREIGN KEY (`tipo_cuenta_id`) REFERENCES `conta_tipo_cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1027 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_plan_cuenta`
--

LOCK TABLES `conta_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_plan_cuenta` VALUES (1,NULL,1000000,1,1,0,'ACTIVO','Activo',NULL,1,1,0,0,0,0,NULL),(2,NULL,1100000,2,1,1000000,'ACTIVO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(3,NULL,1110000,3,1,1100000,'CAJA Y BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(4,NULL,1110100,4,1,1110000,'CAJAS','Activo',NULL,1,1,0,0,0,0,NULL),(5,NULL,1110101,5,1,1110100,'Caja Oficina','Activo',NULL,0,1,0,0,0,0,NULL),(6,NULL,1110102,5,1,1110100,'Caja Casa','Activo',NULL,0,1,0,0,0,0,NULL),(7,NULL,1110103,5,1,1110100,'Caja Dolares Casa','Activo',NULL,0,1,0,0,0,0,NULL),(8,NULL,1110104,5,1,1110100,'Banco Santander 015-372795/5','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(9,NULL,1110200,4,1,1110000,'BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(10,NULL,1110201,5,1,1110200,'Banco Santander Rio Cta Corriente','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(11,NULL,1110202,5,1,1110200,'Banco Santander Rio Cta Corriente DOLARES','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(12,NULL,1130000,3,1,1100000,'CREDITOS POR VENTAS','Activo',NULL,1,1,0,0,0,0,NULL),(13,NULL,1130101,5,1,1130100,'Clientes - Deudores','Activo',NULL,1,2,0,0,0,1,NULL),(14,NULL,1130102,5,1,1130100,'Deudores por ventas comunes','Activo',NULL,1,1,0,0,0,1,NULL),(15,NULL,1130103,5,1,1130100,'Deudores por ventas morosos','Activo',NULL,1,1,0,0,0,1,NULL),(16,NULL,1130104,5,1,1130100,'Deudores en gestión judicial','Activo',NULL,1,1,0,0,0,1,NULL),(17,NULL,1130105,5,1,1130100,'Previsión deudores incobrables','Activo',NULL,1,1,0,0,0,1,NULL),(18,NULL,1140000,3,1,1100000,'OTROS CREDITOS','Activo',NULL,1,1,0,0,0,0,NULL),(19,NULL,1140100,4,1,1140000,'Retenciones Sufridas','Activo',NULL,1,1,0,0,0,0,NULL),(20,NULL,1140301,5,1,1140300,'Anticipos Impuesto a las Ganancias','Activo',NULL,1,2,0,0,1,1,NULL),(21,NULL,1140102,5,1,1140100,'Retenciones Ingr. Brutos','Activo',NULL,0,1,0,0,0,0,NULL),(22,NULL,1140329,5,1,1140300,'Anticipo Impto.Ganancia Mínima Presunta','Activo',NULL,1,1,0,0,0,1,NULL),(23,NULL,1140105,5,1,1140100,'Retenciones Impuesto a las Ganancias','Activo',NULL,1,2,1,0,0,1,NULL),(24,NULL,1140106,5,1,1140100,'Impuesto a las Ganancias (Saldo a favor)','Activo',NULL,1,1,0,0,0,1,NULL),(25,NULL,1140107,5,1,1140100,'Retenciones de IVA','Activo',NULL,1,2,1,0,0,1,NULL),(26,NULL,1140200,4,1,1140000,'CREDITOS DIVERSOS','Activo',NULL,1,1,0,0,0,0,NULL),(27,NULL,1140201,5,1,1140200,'Anticipos de proveedores','Activo',NULL,1,1,0,0,0,1,NULL),(28,NULL,1140205,5,1,1140200,'Depósito en garantía alquileres','Activo',NULL,1,1,0,0,0,1,NULL),(29,NULL,1140206,5,1,1140200,'Derechos adquiridos a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(30,NULL,1140207,5,1,1140200,'Intereses a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(31,NULL,1140208,5,1,1140200,'Cuentas a rendir - Directores','Activo',NULL,1,1,0,0,0,1,NULL),(32,NULL,1140210,5,1,1140200,'Alquileres no devengados','Activo',NULL,1,1,0,0,0,1,NULL),(33,NULL,1150000,3,1,1100000,'BIENES DE CAMBIO','Activo',NULL,1,1,0,0,0,0,NULL),(34,NULL,1150400,4,1,1150000,'MERCADERIA DE REVENTA','Activo',NULL,1,1,0,0,0,0,NULL),(35,NULL,1200000,2,1,1000000,'ACTIVO NO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(36,NULL,1220000,3,1,1200000,'BIENES DE USO','Activo',NULL,1,1,0,0,0,0,NULL),(37,NULL,1220100,4,1,1220000,'EQUIPOS DE COMPUTACION','Activo',NULL,1,1,0,0,0,0,NULL),(38,NULL,1220101,5,1,1220100,'Equipos de computación valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(39,NULL,1220102,5,1,1220100,'Equipos de computación ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(40,NULL,1220108,5,1,1220100,'Amortización Acumulada Equipos de comput.','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(41,NULL,1220200,4,1,1220000,'INSTALACIONES','Activo',NULL,1,1,0,0,0,0,NULL),(42,NULL,1220201,5,1,1220200,'Instalaciones valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(43,NULL,1220202,5,1,1220200,'Instalaciones ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(44,NULL,1220206,5,1,1220200,'Amortización Acumulada Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(45,NULL,1220300,4,1,1220000,'MUEBLES Y UTILES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (46,NULL,1220301,5,1,1220300,'Muebles y utiles valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(47,NULL,1220302,5,1,1220300,'Muebles y utiles ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(48,NULL,1220306,5,1,1220300,'Amortización Acumulada Muebles y Útiles','Activo',NULL,1,1,0,0,0,1,NULL),(49,NULL,1230000,3,1,1200000,'ACTIVOS INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(50,NULL,1230101,5,1,1230100,'Gastos de organización valores historicos','Activo',NULL,1,1,0,0,0,1,NULL),(51,NULL,1230102,5,1,1230100,'Gastos de organización ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(52,NULL,1230103,5,1,1230100,'Amortización acumulada gs. de organización','Activo',NULL,1,1,0,0,0,1,NULL),(53,NULL,2000000,1,2,0,'PASIVO','Pasivo',NULL,1,1,0,0,0,0,NULL),(54,NULL,2100000,2,2,2000000,'PASIVO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(55,NULL,2110000,3,2,2100000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(56,NULL,2110100,4,2,2110000,'Comerciales','Pasivo',NULL,1,1,0,0,0,0,NULL),(57,NULL,2110101,5,2,2110100,'Proveedores en Cta. Cte. locales','Pasivo',NULL,1,2,0,0,0,1,NULL),(58,NULL,2110102,5,2,2110100,'Proveedores en cta. cte. exterior','Pasivo',NULL,1,1,0,0,0,1,NULL),(59,NULL,2110103,5,2,2110100,'Derechos de exhibición a devengar','Pasivo',NULL,1,1,0,0,0,1,NULL),(60,NULL,2110104,5,2,2110100,'Cheques emitidos ','Pasivo',NULL,1,2,1,1,1,1,NULL),(61,NULL,2110200,4,2,2110000,'REMUNERACIONES Y CARGAS SOCIALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(62,NULL,2110201,5,2,2110200,'Sueldos y Jornales a pagar','Pasivo',NULL,1,2,0,0,1,1,NULL),(63,NULL,2110202,5,2,2110200,'Cargas sociales a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(64,NULL,2110203,5,2,2110200,'Sindicatos a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(65,NULL,2110300,4,2,2110000,'CARGAS FISCALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(67,NULL,2110301,5,2,2110300,'IVA Debito Fiscal','Pasivo',NULL,1,2,0,0,0,1,NULL),(68,NULL,1140222,5,1,1140200,'IVA Credito Fiscal','Activo',NULL,1,2,0,0,0,1,NULL),(69,NULL,2110303,5,2,2110300,'Impuestos Internos','Pasivo',NULL,1,1,0,0,0,1,NULL),(70,NULL,2110304,5,2,2110300,'Impuestos al Combustible','Pasivo',NULL,1,1,0,0,0,1,NULL),(71,NULL,2110601,5,2,2110600,'IVA Retenciones de terceros','Pasivo',NULL,1,1,0,0,0,1,NULL),(72,NULL,2110306,5,2,2110300,'IVA Percepciones realiz.por terceros','Pasivo',NULL,1,2,0,0,0,1,NULL),(73,NULL,2110307,5,2,2110300,'IVA Saldo a favor','Pasivo',NULL,1,1,0,0,0,1,NULL),(74,NULL,2110308,5,2,2110300,'IVA a pagar','Pasivo',NULL,1,2,0,0,0,1,NULL),(75,NULL,2110309,5,2,2110300,'Percepciones Ingresos Brutos','Pasivo',NULL,1,1,0,0,0,1,NULL),(76,NULL,2110310,5,2,2110300,'Otros Pagos AFIP','Pasivo',NULL,1,1,0,0,0,1,NULL),(78,NULL,2110350,5,2,2110300,'Impuesto a los Ingresos Brutos Pasivo','Pasivo',NULL,1,1,0,0,0,1,NULL),(79,NULL,2110313,5,2,2110300,'Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(80,NULL,2110314,5,2,2110300,'Impuesto a la Ganancia Mínima Presunta','Pasivo',NULL,1,1,0,0,0,1,NULL),(81,NULL,2110602,5,2,2110600,'AFIP - Retenciones Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(82,NULL,2110316,5,2,2110300,'AFIP - Plan de Facilidades Decreto 338/02','Pasivo',NULL,1,1,0,0,0,1,NULL),(83,NULL,2200000,2,2,2000000,'PASIVO NO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(84,NULL,3000000,1,2,0,'PATRIMONIO NETO','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(85,NULL,3100000,2,2,3000000,'APORTE DE LOS PROPIETARIOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(86,NULL,3110100,4,2,3110000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(87,NULL,3110101,5,2,3110100,'Acciones en circulación','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(88,NULL,3110102,5,2,3110100,'Ajuste del Capital','Patrimonio Neto',NULL,1,2,0,0,0,1,NULL),(89,NULL,3110103,5,2,3110100,'Aportes Irrevocables Futuras Suscripciones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(90,NULL,3400000,2,2,3000000,'RESULTADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(91,NULL,3410101,5,2,3410100,'Resultado del ejercicio','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (92,NULL,3410102,5,2,3410100,'Resultado ejercicios anteriores','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(93,NULL,3410103,5,2,3410100,'A.R.E.A.','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(94,NULL,4000000,1,2,0,'INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(95,NULL,4100000,2,2,4000000,'INGRESOS ORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(96,NULL,4110101,5,2,4110100,'VENTAS','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(97,NULL,4110102,5,2,4110100,'Honorarios','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(98,NULL,4110103,5,2,4110100,'Sueldo Vane','Result. Positivo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(99,NULL,4110104,5,2,4110100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(100,NULL,4110105,5,2,4110100,'Reintegros por exportaciones','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(101,NULL,4120000,3,2,4100000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(102,NULL,4120101,5,2,4120100,'Intereses Cobrados','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(103,NULL,4120102,5,2,4120100,'Diferencias de cambio','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(104,NULL,4120103,5,2,4120100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(107,NULL,5000000,1,1,0,'GASTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(108,NULL,5100000,2,1,5000000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(109,NULL,5110100,4,1,5110000,'ASIENTO DE SUELDO','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(110,NULL,5110101,5,1,5110100,'Sueldos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(111,NULL,5110102,5,1,5110100,'Contribuciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(112,NULL,5110103,5,1,5110100,'Sindicato','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(113,NULL,5120100,4,1,5120000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(114,NULL,5120101,5,1,5120100,'ACA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(115,NULL,5120102,5,1,5120100,'Aereos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(116,NULL,5120103,5,1,5120100,'Alquiler','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(117,NULL,5120104,5,1,5120100,'AGUA AYSA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(118,NULL,5120105,5,1,5120100,'TV Cablevision','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(119,NULL,5120106,5,1,5120100,'Caja Jubilacion Consejo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(120,NULL,5120107,5,1,5120100,'Celulares','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(121,NULL,5120108,5,1,5120100,'Cheques','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(122,NULL,5120109,5,1,5120100,'Club la Nacion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(123,NULL,5120110,5,1,5120100,'Comida','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(124,NULL,5120111,5,1,5120100,'Diario Clarin','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(125,NULL,5120112,5,1,5120100,'Digital Ocean','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(126,NULL,5120113,5,1,5120100,'Fletes y acarreos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(127,NULL,5120114,5,1,5120100,'Luz Edesur','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(128,NULL,5120115,5,1,5120100,'Movilidad y Viáticos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(129,NULL,5120116,5,1,5120100,'Mantenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(130,NULL,5120117,5,1,5120100,'IVA No Computable','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(131,NULL,5120118,5,1,5120100,'Entretenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(132,NULL,5120119,5,1,5120100,'Amortización Bienes de Uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(133,NULL,5120120,5,1,5120100,'Errepar','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(134,NULL,5120121,5,1,5120100,'Hosting Página Web To Webs','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(135,NULL,5120122,5,1,5120100,'Gastos varios','Result. Negativo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (136,NULL,5120123,5,1,5120100,'Ajuste por redondeo','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(137,NULL,5120124,5,1,5120100,'Deudores Incobrables','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(138,NULL,5120125,5,1,5120100,'Faby Goncalves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(139,NULL,5130100,4,1,5130000,'GASTOS FINANCIEROS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(140,NULL,5130101,5,1,5130100,'Intereses y Gastos bancarios','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(141,NULL,5130102,5,1,5130100,'Intereses Proveedores','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(142,NULL,5130103,5,1,5130100,'Damian Financiera','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(143,NULL,5130104,5,1,5130100,'Diferencias de cambio','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(144,NULL,5130105,5,1,5130100,'Diferencia de Cambio Bces. en M.Extranjera','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(145,NULL,5130106,5,1,5130100,'Diferencia tipo cambio Vendedor/Comprador','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(146,NULL,5130107,5,1,5130100,'Diferencia por conversion en Bce. en Mon. Extranj.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(147,NULL,5130108,5,1,5130100,'Diferencia de cambio CMV','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(148,NULL,5130109,5,1,5130100,'Diferencia de cambio PT','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(149,NULL,5130110,5,1,5130100,'Resultado por Exposición a la Inflación','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(150,NULL,5130111,5,1,5130100,'Diferencia de cambio PE','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(151,NULL,5130112,5,1,5130100,'Diferencia de cambio Ds.Vtas.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(152,NULL,5130113,5,1,5130100,'Diferencia de cambio ME','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(153,NULL,5130114,5,1,5130100,'Descuentos otorgados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(154,NULL,5140100,4,1,5140000,'IMPUESTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(155,NULL,5140101,5,1,5140100,'Impuesto a las Ganancias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(156,NULL,5140164,5,1,5140100,'Impuesto a los Ingresos Brutos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(157,NULL,5140102,5,1,5140100,'Impuesto al Debito y Credito Bancario','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(158,NULL,5200000,2,1,5000000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(159,NULL,5210101,5,1,5210100,'Pérdida por venta bienes de uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(160,NULL,5210102,5,1,5210100,'Inversiones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(161,NULL,5210103,5,1,5210100,'Amortizaciones extraordinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(162,NULL,1140103,5,1,1140100,'Retenciones SUSS','Activo',NULL,1,2,1,0,0,1,NULL),(163,NULL,1110122,5,1,1110100,'Banco Patagonia Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(164,NULL,1110106,5,1,1110100,'Banco HSBC','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(165,NULL,1110123,5,1,1110100,'Banco Ciudad Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(166,NULL,1110124,5,1,1110100,'Banco Nacion Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(167,NULL,1110109,5,1,1110100,'Banco Galicia Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(168,NULL,1110110,5,1,1110100,'Banco Frances Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(169,NULL,1110111,5,1,1110100,'Banco Patagonia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(170,NULL,1110112,5,1,1110100,'Banco Ciudad In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(171,NULL,1110113,5,1,1110100,'Banco Provincia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(172,NULL,1110114,5,1,1110100,'Banco Macro PedimeOnline','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(173,NULL,1110115,5,1,1110100,'Banco Patagonia Problema Resuelto','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (174,NULL,1110116,5,1,1110100,'Banco Patagonia Graciela','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(175,NULL,1110117,5,1,1110100,'Banco Patagonia Omar','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(176,NULL,1110118,5,1,1110100,'Cheques','Activo',NULL,1,2,1,1,1,0,NULL),(177,NULL,5120126,5,1,5120100,'Gisela Larzabal','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(178,NULL,5120127,5,1,5120100,'Google','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(179,NULL,5120128,5,1,5120100,'Seguro Moto','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(180,NULL,5120129,5,1,5120100,'Sueldo Agustina','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(181,NULL,5120130,5,1,5120100,'Sueldo Betty','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(182,NULL,5120131,5,1,5120100,'Sueldo Elizabet','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(183,NULL,5120132,5,1,5120100,'Sueldo Florencia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(184,NULL,5120133,5,1,5120100,'Sueldo Graciela','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(185,NULL,5120134,5,1,5120100,'Sueldo Franco Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(186,NULL,5120135,5,1,5120100,'Sueldo Santiago Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(187,NULL,5120136,5,1,5120100,'Sueldo Jose Luis','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(188,NULL,5120137,5,1,5120100,'Publicidad','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(189,NULL,5120138,5,1,5120100,'Las Nieves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(190,NULL,5120139,5,1,5120100,'Sueldo Lidia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(191,NULL,5120140,5,1,5120100,'Cargas Sociales','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(192,NULL,5120141,5,1,5120100,'Honorarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(193,NULL,5120142,5,1,5120100,'Telefono Fijo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(194,NULL,5120143,5,1,5120100,'ONE DRIVE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(195,NULL,5120144,5,1,5120100,'OSDE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(196,NULL,5120145,5,1,5120100,'SAS Constitucion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(197,NULL,5120146,5,1,5120100,'Seguro de Vida Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(198,NULL,5120147,5,1,5120100,'Seguros','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(199,NULL,5120148,5,1,5120100,'Internet','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(200,NULL,5120149,5,1,5120100,'Seguro de Retiro Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(201,NULL,5140165,5,1,5140100,'Monotributo','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(202,NULL,5140104,5,1,5140100,'IVA In Time SRL','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(203,NULL,5140105,5,1,5140100,'Autonomos','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(204,NULL,5140106,5,1,5140100,'Multas Impositivas','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(207,NULL,5120150,5,1,5120100,'Vanesa Gastos','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(208,NULL,5140166,5,1,5140100,'Impuesto a los Ingresos Brutos - BS AS','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(209,NULL,5140107,5,1,5140100,'SIRCREB','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(210,NULL,5140108,5,1,5140100,'Consejo Ciencias Economicas','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(211,NULL,5120152,5,1,5120100,'Albano Andres','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(212,NULL,5120153,5,1,5120100,'Tarjeta Visa','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(213,NULL,5120154,5,1,5120100,'Tarjeta American Express','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(214,NULL,5120155,5,1,5120100,'Tarjeta Mastercard','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(215,NULL,5120156,5,1,5120100,'Imp. Municipales','Result. Negativo',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (216,NULL,5120157,5,1,5120100,'Perc/Ret. Imp. Ganancias','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(217,NULL,5120158,5,1,5120100,'Compras','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(218,NULL,4110106,5,2,4110100,'Ventas No Gravadas','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(219,NULL,6110103,5,1,6110100,'Pagos AFIP','Movimiento',NULL,1,2,0,0,1,1,NULL),(220,NULL,5140167,5,1,5140100,'Perc IVA -RG3337','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(221,NULL,5140109,5,1,5140100,'Imps. Internos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(222,NULL,5140110,5,1,5140100,'Imp. Gasoil','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(223,NULL,5140111,5,1,5140100,'Imp. Hídricos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(224,NULL,5140112,5,1,5140100,'ITC','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(225,NULL,5140113,5,1,5140100,'Perc IIBB  Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(226,NULL,5140114,5,1,5140100,'Perc IIBB  Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(227,NULL,5140115,5,1,5140100,'Perc IIBB  Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(228,NULL,5140116,5,1,5140100,'Perc IIBB  Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(229,NULL,5140117,5,1,5140100,'Perc IIBB  Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(230,NULL,5140118,5,1,5140100,'Perc IIBB  Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(231,NULL,5140119,5,1,5140100,'Perc IIBB  Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(232,NULL,5140120,5,1,5140100,'Perc IIBB  Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(233,NULL,5140121,5,1,5140100,'Perc IIBB  Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(234,NULL,5140122,5,1,5140100,'Perc IIBB  Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(235,NULL,5140123,5,1,5140100,'Perc IIBB  La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(236,NULL,5140124,5,1,5140100,'Perc IIBB  La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(237,NULL,5140125,5,1,5140100,'Perc IIBB  Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(238,NULL,5140126,5,1,5140100,'Perc IIBB  Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(239,NULL,5140127,5,1,5140100,'Perc IIBB  Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(240,NULL,5140128,5,1,5140100,'Perc IIBB  Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(241,NULL,5140129,5,1,5140100,'Perc IIBB  Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(242,NULL,5140130,5,1,5140100,'Perc IIBB  Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(243,NULL,5140131,5,1,5140100,'Perc IIBB  San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(244,NULL,5140132,5,1,5140100,'Perc IIBB  San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(245,NULL,5140133,5,1,5140100,'Perc IIBB  Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(246,NULL,5140134,5,1,5140100,'Perc IIBB  Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(247,NULL,5140135,5,1,5140100,'Perc IIBB  Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(248,NULL,5140136,5,1,5140100,'Perc IIBB  Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(249,NULL,5140137,5,1,5140100,'Perc IIBB  Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(250,NULL,5140138,5,1,5140100,'Compras No Gravadas','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(251,NULL,1140108,5,1,1140100,'Retenciones de IIBB Buenos Aires','Activo',NULL,1,2,1,0,0,1,NULL),(252,NULL,1140109,5,1,1140100,'Retenciones de IIBB Capital Federal','Activo',NULL,1,2,1,0,0,1,NULL),(253,NULL,1140110,5,1,1140100,'Retenciones de IIBB Catamarca','Activo',NULL,1,2,1,0,0,1,NULL),(254,NULL,1140111,5,1,1140100,'Retenciones de IIBB Chaco','Activo',NULL,1,2,1,0,0,1,NULL),(255,NULL,1140112,5,1,1140100,'Retenciones de IIBB Chubut','Activo',NULL,1,2,1,0,0,1,NULL),(256,NULL,1140113,5,1,1140100,'Retenciones de IIBB Córdoba','Activo',NULL,1,2,1,0,0,1,NULL),(257,NULL,1140114,5,1,1140100,'Retenciones de IIBB Corrientes','Activo',NULL,1,2,1,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (258,NULL,1140115,5,1,1140100,'Retenciones de IIBB Entre Ríos','Activo',NULL,1,2,1,0,0,1,NULL),(259,NULL,1140116,5,1,1140100,'Retenciones de IIBB Formosa','Activo',NULL,1,2,1,0,0,1,NULL),(260,NULL,1140117,5,1,1140100,'Retenciones de IIBB Jujuy','Activo',NULL,1,2,1,0,0,1,NULL),(261,NULL,1140118,5,1,1140100,'Retenciones de IIBB La Pampa','Activo',NULL,1,2,1,0,0,1,NULL),(262,NULL,1140119,5,1,1140100,'Retenciones de IIBB La Rioja','Activo',NULL,1,2,1,0,0,1,NULL),(263,NULL,1140120,5,1,1140100,'Retenciones de IIBB Mendoza','Activo',NULL,1,2,1,0,0,1,NULL),(264,NULL,1140121,5,1,1140100,'Retenciones de IIBB Misiones','Activo',NULL,1,2,1,0,0,1,NULL),(265,NULL,1140122,5,1,1140100,'Retenciones de IIBB Neuquén','Activo',NULL,1,2,1,0,0,1,NULL),(266,NULL,1140123,5,1,1140100,'Retenciones de IIBB Pascua Lama','Activo',NULL,1,2,1,0,0,1,NULL),(267,NULL,1140124,5,1,1140100,'Retenciones de IIBB Río Negro','Activo',NULL,1,2,1,0,0,1,NULL),(268,NULL,1140125,5,1,1140100,'Retenciones de IIBB Salta','Activo',NULL,1,2,1,0,0,1,NULL),(269,NULL,1140126,5,1,1140100,'Retenciones de IIBB San Juan','Activo',NULL,1,2,1,0,0,1,NULL),(270,NULL,1140127,5,1,1140100,'Retenciones de IIBB San Luis','Activo',NULL,1,2,1,0,0,1,NULL),(271,NULL,1140128,5,1,1140100,'Retenciones de IIBB Santa Cruz','Activo',NULL,1,2,1,0,0,1,NULL),(272,NULL,1140129,5,1,1140100,'Retenciones de IIBB Santa Fe','Activo',NULL,1,2,1,0,0,1,NULL),(273,NULL,1140130,5,1,1140100,'Retenciones de IIBB Santiago del Estero','Activo',NULL,1,2,1,0,0,1,NULL),(274,NULL,1140131,5,1,1140100,'Retenciones de IIBB Tierra del Fuego','Activo',NULL,1,2,1,0,0,1,NULL),(275,NULL,1140132,5,1,1140100,'Retenciones de IIBB Tucuman','Activo',NULL,1,2,1,0,0,1,NULL),(276,NULL,5140168,5,1,5140100,'SIRCREB Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(277,NULL,5140139,5,1,5140100,'SIRCREB Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(278,NULL,5140140,5,1,5140100,'SIRCREB Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(279,NULL,5140141,5,1,5140100,'SIRCREB Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(280,NULL,5140142,5,1,5140100,'SIRCREB Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(281,NULL,5140143,5,1,5140100,'SIRCREB Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(282,NULL,5140144,5,1,5140100,'SIRCREB Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(283,NULL,5140145,5,1,5140100,'SIRCREB Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(284,NULL,5140146,5,1,5140100,'SIRCREB Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(285,NULL,5140147,5,1,5140100,'SIRCREB Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(286,NULL,5140148,5,1,5140100,'SIRCREB La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(287,NULL,5140149,5,1,5140100,'SIRCREB La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(288,NULL,5140150,5,1,5140100,'SIRCREB Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(289,NULL,5140151,5,1,5140100,'SIRCREB Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(290,NULL,5140152,5,1,5140100,'SIRCREB Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(291,NULL,5140153,5,1,5140100,'SIRCREB Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(292,NULL,5140154,5,1,5140100,'SIRCREB Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(293,NULL,5140155,5,1,5140100,'SIRCREB Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(294,NULL,5140156,5,1,5140100,'SIRCREB San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(295,NULL,5140157,5,1,5140100,'SIRCREB San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(296,NULL,5140158,5,1,5140100,'SIRCREB Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(297,NULL,5140159,5,1,5140100,'SIRCREB Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(298,NULL,5140160,5,1,5140100,'SIRCREB Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(299,NULL,5140161,5,1,5140100,'SIRCREB Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(300,NULL,5140162,5,1,5140100,'SIRCREB Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (301,NULL,1140326,5,1,1140300,'IIBB a Favor Buenos Aires','Activo',NULL,1,2,0,0,0,1,NULL),(302,NULL,1140302,5,1,1140300,'IIBB a Favor Capital Federal','Activo',NULL,1,2,0,0,0,1,NULL),(303,NULL,1140303,5,1,1140300,'IIBB a Favor Catamarca','Activo',NULL,1,2,0,0,0,1,NULL),(304,NULL,1140304,5,1,1140300,'IIBB a Favor Chaco','Activo',NULL,1,2,0,0,0,1,NULL),(305,NULL,1140305,5,1,1140300,'IIBB a Favor Chubut','Activo',NULL,1,2,0,0,0,1,NULL),(306,NULL,1140306,5,1,1140300,'IIBB a Favor Córdoba','Activo',NULL,1,2,0,0,0,1,NULL),(307,NULL,1140307,5,1,1140300,'IIBB a Favor Corrientes','Activo',NULL,1,2,0,0,0,1,NULL),(308,NULL,1140308,5,1,1140300,'IIBB a Favor Entre Ríos','Activo',NULL,1,2,0,0,0,1,NULL),(309,NULL,1140309,5,1,1140300,'IIBB a Favor Formosa','Activo',NULL,1,2,0,0,0,1,NULL),(310,NULL,1140310,5,1,1140300,'IIBB a Favor Jujuy','Activo',NULL,1,2,0,0,0,1,NULL),(311,NULL,1140311,5,1,1140300,'IIBB a Favor La Pampa','Activo',NULL,1,2,0,0,0,1,NULL),(312,NULL,1140312,5,1,1140300,'IIBB a Favor La Rioja','Activo',NULL,1,2,0,0,0,1,NULL),(313,NULL,1140313,5,1,1140300,'IIBB a Favor Mendoza','Activo',NULL,1,2,0,0,0,1,NULL),(314,NULL,1140314,5,1,1140300,'IIBB a Favor Misiones','Activo',NULL,1,2,0,0,0,1,NULL),(315,NULL,1140315,5,1,1140300,'IIBB a Favor Neuquén','Activo',NULL,1,2,0,0,0,1,NULL),(316,NULL,1140316,5,1,1140300,'IIBB a Favor Pascua Lama','Activo',NULL,1,2,0,0,0,1,NULL),(317,NULL,1140317,5,1,1140300,'IIBB a Favor Río Negro','Activo',NULL,1,2,0,0,0,1,NULL),(318,NULL,1140318,5,1,1140300,'IIBB a Favor Salta','Activo',NULL,1,2,0,0,0,1,NULL),(319,NULL,1140319,5,1,1140300,'IIBB a Favor San Juan','Activo',NULL,1,2,0,0,0,1,NULL),(320,NULL,1140320,5,1,1140300,'IIBB a Favor San Luis','Activo',NULL,1,2,0,0,0,1,NULL),(321,NULL,1140321,5,1,1140300,'IIBB a Favor Santa Cruz','Activo',NULL,1,2,0,0,0,1,NULL),(322,NULL,1140322,5,1,1140300,'IIBB a Favor Santa Fe','Activo',NULL,1,2,0,0,0,1,NULL),(323,NULL,1140323,5,1,1140300,'IIBB a Favor Santiago del Estero','Activo',NULL,1,2,0,0,0,1,NULL),(324,NULL,1140324,5,1,1140300,'IIBB a Favor Tierra del Fuego','Activo',NULL,1,2,0,0,0,1,NULL),(325,NULL,1140325,5,1,1140300,'IIBB a Favor Tucuman','Activo',NULL,1,2,0,0,0,1,NULL),(326,NULL,2110317,5,2,2110300,'IIBB a Pagar Buenos Aires','Pasivo',NULL,1,2,0,0,0,1,NULL),(327,NULL,2110318,5,2,2110300,'IIBB a Pagar Capital Federal','Pasivo',NULL,1,2,0,0,0,1,NULL),(328,NULL,2110319,5,2,2110300,'IIBB a Pagar Catamarca','Pasivo',NULL,1,2,0,0,0,1,NULL),(329,NULL,2110320,5,2,2110300,'IIBB a Pagar Chaco','Pasivo',NULL,1,2,0,0,0,1,NULL),(330,NULL,2110321,5,2,2110300,'IIBB a Pagar Chubut','Pasivo',NULL,1,2,0,0,0,1,NULL),(331,NULL,2110322,5,2,2110300,'IIBB a Pagar Córdoba','Pasivo',NULL,1,2,0,0,0,1,NULL),(332,NULL,2110323,5,2,2110300,'IIBB a Pagar Corrientes','Pasivo',NULL,1,2,0,0,0,1,NULL),(333,NULL,2110324,5,2,2110300,'IIBB a Pagar Entre Ríos','Pasivo',NULL,1,2,0,0,0,1,NULL),(334,NULL,2110325,5,2,2110300,'IIBB a Pagar Formosa','Pasivo',NULL,1,2,0,0,0,1,NULL),(335,NULL,2110326,5,2,2110300,'IIBB a Pagar Jujuy','Pasivo',NULL,1,2,0,0,0,1,NULL),(336,NULL,2110327,5,2,2110300,'IIBB a Pagar La Pampa','Pasivo',NULL,1,2,0,0,0,1,NULL),(337,NULL,2110328,5,2,2110300,'IIBB a Pagar La Rioja','Pasivo',NULL,1,2,0,0,0,1,NULL),(338,NULL,2110329,5,2,2110300,'IIBB a Pagar Mendoza','Pasivo',NULL,1,2,0,0,0,1,NULL),(339,NULL,2110330,5,2,2110300,'IIBB a Pagar Misiones','Pasivo',NULL,1,2,0,0,0,1,NULL),(340,NULL,2110331,5,2,2110300,'IIBB a Pagar Neuquén','Pasivo',NULL,1,2,0,0,0,1,NULL),(341,NULL,2110332,5,2,2110300,'IIBB a Pagar Pascua Lama','Pasivo',NULL,1,2,0,0,0,1,NULL),(342,NULL,2110333,5,2,2110300,'IIBB a Pagar Río Negro','Pasivo',NULL,1,2,0,0,0,1,NULL),(343,NULL,2110334,5,2,2110300,'IIBB a Pagar Salta','Pasivo',NULL,1,2,0,0,0,1,NULL),(344,NULL,2110335,5,2,2110300,'IIBB a Pagar San Juan','Pasivo',NULL,1,2,0,0,0,1,NULL),(345,NULL,2110336,5,2,2110300,'IIBB a Pagar San Luis','Pasivo',NULL,1,2,0,0,0,1,NULL),(346,NULL,2110337,5,2,2110300,'IIBB a Pagar Santa Cruz','Pasivo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (347,NULL,2110338,5,2,2110300,'IIBB a Pagar Santa Fe','Pasivo',NULL,1,2,0,0,0,1,NULL),(348,NULL,2110339,5,2,2110300,'IIBB a Pagar Santiago del Estero','Pasivo',NULL,1,2,0,0,0,1,NULL),(349,NULL,2110340,5,2,2110300,'IIBB a Pagar Tierra del Fuego','Pasivo',NULL,1,2,0,0,0,1,NULL),(350,NULL,2110341,5,2,2110300,'IIBB a Pagar Tucuman','Pasivo',NULL,1,2,0,0,0,1,NULL),(351,NULL,6110101,5,1,6110100,'BANCO SIRCREB','Movimiento',NULL,1,2,0,0,1,1,NULL),(352,NULL,6110102,5,1,6110100,'Compensacion','Movimiento',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22'),(353,NULL,1140327,5,1,1140300,'IVA Saldo Tecnico','Activo',NULL,1,2,0,0,0,1,NULL),(354,NULL,1140328,5,1,1140300,'IVA Saldo Libre Disponibilidad','Activo',NULL,1,2,0,0,0,1,NULL),(355,NULL,6000000,1,1,0,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(356,NULL,6100000,2,1,6000000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(357,NULL,6110000,3,1,6100000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(358,NULL,4110000,3,2,4100000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(359,NULL,1110120,5,1,1110100,'Caja en Pesos','Activo',NULL,1,2,1,1,1,0,NULL),(360,NULL,1140211,5,1,1140200,'Retenciones Bancarias de Ganancias a Favor','Activo',NULL,1,2,0,0,1,1,NULL),(361,NULL,1220104,5,1,1220100,'Equipos de Computación','Activo',NULL,1,1,0,0,0,1,NULL),(362,NULL,1220105,5,1,1220100,'Computadoras','Activo',NULL,1,1,0,0,0,1,NULL),(363,NULL,1220304,5,1,1220300,'Muebles y Utiles','Activo',NULL,1,1,0,0,0,1,NULL),(364,NULL,2110105,5,2,2110100,'Anticipo de Clientes','Pasivo',NULL,1,2,0,0,1,1,NULL),(365,NULL,2110401,5,2,2110400,'Provision Honorarios','Pasivo',NULL,1,1,0,0,0,1,NULL),(366,NULL,2110106,5,2,2110100,'Cta. Cte Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(367,NULL,2110107,5,2,2110100,'Provisión Honorarios Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(368,NULL,2110110,5,2,2110100,'Cuenta Particular Socio 1','Pasivo',NULL,1,1,0,0,0,1,NULL),(369,NULL,3110104,5,2,3110100,'Capital','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(370,NULL,1120000,3,1,1100000,'INVERSIONES','Activo',NULL,1,1,0,0,0,0,NULL),(371,NULL,1160000,3,1,1100000,'OTROS ACTIVOS','Activo',NULL,1,1,0,0,0,0,NULL),(372,NULL,1160100,4,1,1160000,'OTROS','Activo',NULL,1,1,0,0,0,0,NULL),(373,NULL,2110400,4,2,2110000,'Provision de Honorarios','Pasivo',NULL,1,1,0,0,0,0,NULL),(374,NULL,3410100,4,1,3410000,'RESULTADOS ACUMULADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(375,NULL,3420000,3,1,3400000,'GANACIAS RESERVADAS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(376,NULL,3420100,4,1,3420000,'Rerva Legal','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(377,NULL,1220400,4,1,1220000,'INMUEBLES','Activo',NULL,1,1,0,0,0,0,NULL),(378,NULL,1220500,4,1,1220000,'RODADOS','Activo',NULL,1,1,0,0,0,0,NULL),(379,NULL,1220600,4,1,1220000,'MAQUINARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(380,NULL,1220204,5,1,1220200,'Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(381,NULL,3420101,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(382,NULL,3420102,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(383,NULL,3410105,5,2,3410100,'Resultado no asignado','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(384,NULL,1110121,5,1,1110100,'Caja en Dolares','Activo',NULL,1,2,1,1,1,0,NULL),(385,NULL,1120100,4,1,1120000,'TEMPORARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(386,NULL,1120101,5,1,1120100,'PLAZO FIJO','Activo',NULL,1,1,0,0,0,1,NULL),(387,NULL,1120200,4,1,1120000,'PERMANENTES','Activo',NULL,1,1,0,0,0,0,NULL),(388,NULL,1120201,5,1,1120200,'ACCIONES','Activo',NULL,1,1,0,0,0,1,NULL),(389,NULL,1220401,5,1,1220400,'Inmuebles','Activo',NULL,1,1,0,0,0,1,NULL),(390,NULL,1220501,5,1,1220500,'Vehiculos','Activo',NULL,1,1,0,0,0,1,NULL),(391,NULL,1220601,5,1,1220600,'Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(392,NULL,1150401,5,1,1150400,'MERCADERIAS','Activo',NULL,1,1,0,0,0,1,NULL),(393,NULL,1160101,5,1,1160100,'OTROS','Activo',NULL,1,1,0,0,0,1,NULL),(394,NULL,1230100,4,1,1230000,'INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (395,NULL,2110119,5,2,2110100,'Cuenta Particular Socio 2','Pasivo',NULL,1,1,0,0,0,1,NULL),(396,NULL,5120160,5,1,5120100,'Comisiones Y gastos Bancarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(397,NULL,4110100,4,2,4110000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(398,NULL,4120100,4,2,4120000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(399,NULL,5110000,3,1,5100000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(400,NULL,5120000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(401,NULL,5130000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(402,NULL,5140000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(403,NULL,5210000,3,1,5200000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(404,NULL,5210100,4,1,5210000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(405,NULL,6110100,4,1,6110000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(406,NULL,1130100,4,1,1130000,'Operaciones Ordinarias','Activo',NULL,1,1,0,0,0,0,NULL),(407,NULL,3110000,3,2,3100000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(408,NULL,3410000,3,2,3400000,'RESULTADOS ANTERIORES','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(409,NULL,5110101,5,2,5110000,'IVA Crédito Fiscal No computable','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(410,NULL,1110203,5,1,1110200,'Banco ICBC Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(411,NULL,2110342,5,2,2110300,'Provisión Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(412,NULL,5120107,5,2,5120000,'Amortización Muebles y Útiles','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(413,NULL,5120102,5,2,5120000,'Amortización Equipos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(414,NULL,1220109,5,1,1220100,'Amortizacion Acumulada Equipos','Activo',NULL,1,1,0,0,0,1,NULL),(415,NULL,1220602,5,1,1220600,'Amortización Acumulada Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(416,NULL,1160102,5,1,1160100,'Materias Primas','Activo',NULL,1,1,0,0,0,1,NULL),(417,NULL,1110204,5,1,1110200,'Banco Itaú Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(418,NULL,2110113,5,2,2110100,'Deudas Bancarias','Pasivo',NULL,1,2,0,1,1,1,NULL),(419,NULL,1220502,5,1,1220500,'Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(420,NULL,1220503,5,1,1220500,'Amortización Acumulada Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(421,NULL,5120105,5,2,5120000,'Amortización Rodados','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(422,NULL,5120109,5,2,5120000,'Amortización Maquinarias','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(423,NULL,1220504,5,1,1220500,'Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(424,NULL,1220505,5,1,1220500,'Amortización Acumulada Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(425,NULL,1110205,5,1,1110200,'Banco Galicia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(426,NULL,3420101,5,2,3420000,'Reserva Facultativa','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(427,NULL,1140212,5,1,1140200,'Créditos por Impuestos Diferidos','Activo',NULL,1,1,0,0,0,1,NULL),(428,NULL,1160103,5,1,1160100,'Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(429,NULL,1160104,5,1,1160100,'Amortizacion Acumulada Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(430,NULL,1140213,5,1,1140200,'Intereses a devengar AGIP','Activo',NULL,1,1,0,0,0,1,NULL),(431,NULL,2110343,5,2,2110300,'PFP IIBB','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(432,NULL,1140330,5,1,1140300,'Pago a Cuenta ITC','Activo',NULL,1,2,0,0,0,1,NULL),(433,NULL,2110114,5,2,2110100,'Préstamo','Pasivo',NULL,1,2,0,1,1,1,NULL),(434,NULL,1160106,5,1,1160100,'Productos','Activo',NULL,1,1,0,0,0,1,NULL),(435,NULL,2110345,5,2,2110300,'Intereses a devengar PFP','Pasivo',NULL,1,1,0,0,0,1,NULL),(436,NULL,1110206,5,1,1110200,'Banco Provincia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(437,NULL,1140215,5,1,1140200,'Imp. Ley 25413 Cred 0.6%','Activo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (438,NULL,2110402,5,2,2110400,'Honorarios Directorio a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(439,NULL,3110101,5,2,3110100,'Reserva para Futuras Inversiones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(440,NULL,1130106,5,1,1130100,'TEAC - Trabajos Ejecutados a Certificar','Activo',NULL,1,1,0,0,0,1,NULL),(441,NULL,2110115,5,2,2110100,'Leasing','Pasivo',NULL,1,2,0,1,1,1,NULL),(442,NULL,1110207,5,1,1110200,'Banco Comafi Cta. Cte','Activo',NULL,1,2,1,1,1,0,NULL),(443,NULL,2110500,4,2,2110000,'Deudas Financieras','Pasivo',NULL,1,1,0,0,0,0,NULL),(444,NULL,2110501,5,2,2110500,'Banco Santander Rio Cta Cte','Pasivo',NULL,1,1,0,0,0,1,NULL),(446,NULL,2210000,3,2,2200000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(447,NULL,2210100,4,2,2210000,'Otras Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(448,NULL,2210101,5,2,2210100,'Planes de Pagos AFIP','Pasivo',NULL,1,2,0,1,1,1,NULL),(449,NULL,2110502,5,2,2110500,'Leasing','Pasivo',NULL,1,1,0,0,0,1,NULL),(450,NULL,6110101,5,1,6110000,'Cheques Rechazados','Movimiento',NULL,1,2,0,0,1,1,NULL),(451,NULL,1110208,5,1,1110200,'Banco Patagonia Taxes Software','Activo',NULL,1,2,1,1,1,0,NULL),(452,NULL,1110209,5,1,1110200,'Banco Macro Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(453,NULL,1120202,5,1,1120200,'Inversión Central Caribe','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(454,NULL,1120102,5,1,1120100,'Otras Inversiones','Activo',NULL,1,1,0,0,0,1,NULL),(455,NULL,1140216,5,1,1140200,'Otros Créditos','Activo',NULL,1,1,0,0,0,1,NULL),(456,NULL,2110403,5,2,2110400,'Provisión Honorarios Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(457,NULL,1110210,5,1,1110200,'Cheque Diferido Banco Santander Rio','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(458,NULL,1110211,5,1,1110200,'Cheque Diferido Banco Macro','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(459,NULL,2110204,5,2,2110200,'Moratoria SUSS a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(460,NULL,2110344,5,2,2110300,'Impuestos Municipales a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(461,NULL,5110103,5,2,5110000,'Amortización Instalaciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(462,NULL,5120110,5,2,5120000,'Amortización Equipos de comput.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(463,NULL,2110118,5,2,2110100,'Cuenta Particular Socio 3','Pasivo',NULL,1,1,0,0,0,1,NULL),(464,NULL,2110120,5,2,2110100,'Cuenta Particular Socio 4','Pasivo',NULL,1,1,0,0,0,1,NULL),(465,NULL,3110102,5,2,3110100,'Otras Reservas','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(466,NULL,1140331,5,1,1140300,'IGMP (Saldo a Favor)','Activo',NULL,1,1,0,0,0,1,NULL),(467,NULL,5110104,5,2,5110000,'Interés','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(468,NULL,1150402,5,1,1150400,'Productos en Proceso','Activo',NULL,1,1,0,0,0,1,NULL),(469,NULL,2110205,5,2,2110200,'Depósitos en Garantía Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(470,NULL,2110346,5,2,2110300,'Fondos Embargados','Pasivo',NULL,1,1,0,0,0,1,NULL),(471,NULL,2110347,5,2,2110300,'Cuota Solid.','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(472,NULL,1140332,5,1,1140300,'Anticipo Honorarios Directores','Activo',NULL,1,1,0,0,0,1,NULL),(473,NULL,2110348,5,2,2110300,'SICORE a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(474,NULL,1110212,5,1,1110200,'Banco Credicoop Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(475,NULL,1110213,5,1,1110200,'Banco Superville Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(476,NULL,5110105,5,2,5110000,'RECPAM','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(477,NULL,1110125,5,1,1110100,'Caja Reales','Activo',NULL,1,2,1,1,1,0,NULL),(478,NULL,5140169,5,1,5140100,'CO2 - Imp. Al Carbono','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(479,NULL,1140300,4,1,1140000,'Anticipo de Impuestos','Activo',NULL,1,1,0,0,0,0,NULL),(480,NULL,2110600,4,2,2110000,'Retenciones Efectuadas','Pasivo',NULL,1,1,0,0,0,0,NULL),(481,NULL,4200000,2,2,4000000,'INGRESOS EXTRAORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(1001,NULL,5140170,5,1,5140100,'SIRTAC Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (1002,NULL,5140171,5,1,5140100,'SIRTAC Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1003,NULL,5140172,5,1,5140100,'SIRTAC Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1004,NULL,5140173,5,1,5140100,'SIRTAC Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1005,NULL,5140174,5,1,5140100,'SIRTAC Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1006,NULL,5140175,5,1,5140100,'SIRTAC Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1007,NULL,5140176,5,1,5140100,'SIRTAC Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1008,NULL,5140177,5,1,5140100,'SIRTAC La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1009,NULL,5140178,5,1,5140100,'SIRTAC La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1010,NULL,5140179,5,1,5140100,'SIRTAC Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1011,NULL,5140180,5,1,5140100,'SIRTAC Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1012,NULL,5140181,5,1,5140100,'SIRTAC Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1013,NULL,5140182,5,1,5140100,'SIRTAC Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1014,NULL,5140183,5,1,5140100,'SIRTAC Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1015,NULL,5140184,5,1,5140100,'SIRTAC San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1016,NULL,5140185,5,1,5140100,'SIRTAC San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1017,NULL,5140186,5,1,5140100,'SIRTAC Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1018,NULL,5140187,5,1,5140100,'SIRTAC Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1019,NULL,5140188,5,1,5140100,'SIRTAC Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1020,NULL,5140189,5,1,5140100,'SIRTAC Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1021,NULL,5140190,5,1,5140100,'SIRTAC Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1022,NULL,5140191,5,1,5140100,'SIRTAC Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1023,NULL,5140192,5,1,5140100,'SIRTAC Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1024,NULL,5140193,5,1,5140100,'SIRTAC Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1025,NULL,5140194,5,1,5140100,'SIRTAC Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1026,NULL,6110104,5,1,6110100,'BANCO SIRTAC','Movimiento',NULL,1,2,0,0,1,1,NULL);
/*!40000 ALTER TABLE `conta_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_asientos`
--

DROP TABLE IF EXISTS `conta_tipo_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_asientos`
--

LOCK TABLES `conta_tipo_asientos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_asientos` DISABLE KEYS */;
INSERT INTO `conta_tipo_asientos` VALUES (1,'Sueldos',NULL,NULL,NULL,11),(2,'Ingresos',NULL,NULL,NULL,9),(3,'Egresos',NULL,NULL,NULL,10),(4,'Amortizaciones',NULL,NULL,NULL,4),(5,'Banco',NULL,NULL,NULL,15),(6,'Ganancias',NULL,NULL,NULL,12),(7,'Retenciones',NULL,NULL,NULL,13),(8,'SIRCREB',NULL,NULL,NULL,14),(9,'Compensaciones',NULL,NULL,NULL,16),(10,'Pagos AFIP',NULL,NULL,NULL,17),(11,'Ajustes',NULL,NULL,NULL,3),(12,'Saldos Iniciales',NULL,NULL,NULL,1),(13,'Cancelacion de Iniciales',NULL,NULL,NULL,2),(14,'Patrimonio Neto',NULL,NULL,NULL,8),(15,'Liquidaciones IVA',NULL,NULL,NULL,18),(16,'Liquidacion IIBB',NULL,NULL,NULL,19),(17,'Asientos de Cierre',NULL,NULL,NULL,5),(18,'Reclasificacion',NULL,NULL,NULL,6),(19,'Otros',NULL,NULL,NULL,7),(20,'Cobranzas','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(21,'Pagos','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(22,'Tesoreria','2019-10-19 02:10:24','2019-10-19 02:10:24',NULL,NULL),(23,'Ajuste por Inflacion','2020-03-01 06:39:20','2020-03-01 06:39:20',NULL,NULL),(24,'SIRTAC','2023-10-16 21:13:49','2023-10-16 21:13:49',NULL,20);
/*!40000 ALTER TABLE `conta_tipo_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_cuentas`
--

DROP TABLE IF EXISTS `conta_tipo_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_cuentas`
--

LOCK TABLES `conta_tipo_cuentas` WRITE;
/*!40000 ALTER TABLE `conta_tipo_cuentas` DISABLE KEYS */;
INSERT INTO `conta_tipo_cuentas` VALUES (1,'Rubro',NULL,NULL,NULL),(2,'SubRubro',NULL,NULL,NULL),(3,'Grupo',NULL,NULL,NULL),(4,'SubGrupo',NULL,NULL,NULL),(5,'Cuenta',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_saldos`
--

DROP TABLE IF EXISTS `conta_tipo_saldos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_saldos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `saldo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_saldos`
--

LOCK TABLES `conta_tipo_saldos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_saldos` DISABLE KEYS */;
INSERT INTO `conta_tipo_saldos` VALUES (1,'Deudor',NULL,NULL,NULL),(2,'Acreedor',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_saldos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_cuits_afip`
--

DROP TABLE IF EXISTS `control_cuits_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_cuits_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `control_cuits_afip_person_id_foreign` (`person_id`),
  CONSTRAINT `control_cuits_afip_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_cuits_afip`
--

LOCK TABLES `control_cuits_afip` WRITE;
/*!40000 ALTER TABLE `control_cuits_afip` DISABLE KEYS */;
/*!40000 ALTER TABLE `control_cuits_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_general`
--

DROP TABLE IF EXISTS `control_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_general` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `control_general_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_general`
--

LOCK TABLES `control_general` WRITE;
/*!40000 ALTER TABLE `control_general` DISABLE KEYS */;
INSERT INTO `control_general` VALUES (1,'Ingresos - Egresos - Resultado',1,'Proyeccion Ganancias','control_general/proyecGanancias',NULL,NULL),(2,'IVA',2,'IVA','control_general/iva',NULL,NULL),(3,'IIBB',3,'IIBB','control_general/iibb',NULL,NULL),(4,'Por Mes',4,'Vto. Impuestos','control_general/vto',NULL,NULL),(5,'Por Impuesto',4,'Vto. Impuestos','control_general/vtoPorImpuestos',NULL,NULL);
/*!40000 ALTER TABLE `control_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente`
--

DROP TABLE IF EXISTS `cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `compensado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_cliente_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_cliente_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=372 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente`
--

LOCK TABLES `cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente` VALUES (1,7479,2,40722,40723,13,4532,1,0,'2022-06-12','2022-06-12',114134.00,1,1.00,'Factura C N°: 0001-00000001',NULL,'2022-07-29 19:26:36','2022-07-29 20:20:19','2022-07-29 20:20:19'),(2,7479,2,40722,40723,13,4532,1,0,'2022-06-12','2022-06-12',107000.00,1,1.00,'Factura C N°: 0001-00000002',NULL,'2022-07-29 19:26:36','2022-07-29 20:20:06','2022-07-29 20:20:06'),(3,7479,2,40722,40723,13,4532,1,0,'2022-06-15','2022-06-15',114134.00,1,1.00,'Factura C N°: 0001-00000003',NULL,'2022-07-29 19:26:36','2022-07-29 20:19:55','2022-07-29 20:19:55'),(4,7479,2,40722,40723,13,4532,1,0,'2022-06-15','2022-06-15',107000.00,1,1.00,'Factura C N°: 0001-00000004',NULL,'2022-07-29 19:26:36','2022-07-29 20:19:36','2022-07-29 20:19:36'),(5,7479,3,40722,40724,57,4532,2,0,'2022-06-01','2022-06-01',1910.34,1,1.00,'Factura C N°: 0002-00000489',NULL,'2022-07-29 19:28:35','2022-08-02 18:57:56','2022-08-02 18:57:56'),(6,7479,3,40722,40725,57,4532,2,0,'2022-06-30','2022-06-30',7710.00,1,1.00,'Factura B N°: 0003-00245807',NULL,'2022-07-29 19:28:35','2022-08-02 18:57:56','2022-08-02 18:57:56'),(7,7479,2,40722,40723,13,4532,1,0,'2022-06-15','2022-06-15',107000.00,1,1.00,'Factura C N°: 0001-00000004',NULL,'2022-07-29 20:19:36','2022-08-02 18:57:51','2022-08-02 18:57:51'),(8,7479,2,40722,40723,13,4532,1,0,'2022-06-15','2022-06-15',114134.00,1,1.00,'Factura C N°: 0001-00000003',NULL,'2022-07-29 20:19:55','2022-08-02 18:57:51','2022-08-02 18:57:51'),(9,7479,2,40722,40723,13,4532,1,0,'2022-06-12','2022-06-12',107000.00,1,1.00,'Factura C N°: 0001-00000002',NULL,'2022-07-29 20:20:06','2022-08-02 18:57:51','2022-08-02 18:57:51'),(10,7479,2,40722,40723,13,4532,1,0,'2022-06-12','2022-06-12',114134.00,1,1.00,'Factura C N°: 0001-00000001',NULL,'2022-07-29 20:20:19','2022-08-02 18:57:51','2022-08-02 18:57:51'),(11,7479,2,40719,40726,13,8,1,0,'2022-06-12','2022-06-12',1000.00,1,1.00,'Factura C N°: 0001-00000165',NULL,'2022-07-29 22:54:43','2022-07-29 23:20:05','2022-07-29 23:20:05'),(12,7479,2,40719,40727,13,8,1,0,'2022-06-12','2022-06-12',1000.00,1,1.00,'Factura C N°: 0001-00000166',NULL,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(13,7479,2,40719,40728,13,8,1,0,'2022-06-12','2022-06-12',1000.00,1,1.00,'Factura C N°: 0001-00000167',NULL,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(14,7479,2,40719,40729,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000172',NULL,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(15,7479,2,40719,40730,13,8,1,0,'2022-06-15','2022-06-15',700.00,1,1.00,'Factura C N°: 0001-00000168',NULL,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(16,7479,2,40719,40731,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000169',NULL,'2022-07-29 22:54:43','2022-07-29 22:55:57','2022-07-29 22:55:57'),(17,7479,2,40719,40732,13,8,1,0,'2022-06-15','2022-06-15',2000.00,1,1.00,'Factura C N°: 0001-00000170',NULL,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(18,7479,2,40719,40733,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000171',NULL,'2022-07-29 22:54:43','2022-07-29 23:20:06','2022-07-29 23:20:06'),(19,7479,2,40719,40734,13,8,1,0,'2022-06-17','2022-06-17',1800.00,1,1.00,'Factura C N°: 0001-00000173',NULL,'2022-07-29 22:54:43','2022-07-29 23:19:50','2022-07-29 23:19:50'),(20,7479,2,40719,40735,13,8,1,0,'2022-06-18','2022-06-18',2000.00,1,1.00,'Factura C N°: 0001-00000174',NULL,'2022-07-29 22:54:43','2022-07-29 23:19:46','2022-07-29 23:19:46'),(21,7479,2,40719,40736,13,8,1,0,'2022-06-21','2022-06-21',1400.00,1,1.00,'Factura C N°: 0001-00000175',NULL,'2022-07-29 22:54:43','2022-07-29 23:19:42','2022-07-29 23:19:42'),(22,7479,2,40719,40737,13,8,1,0,'2022-06-21','2022-06-21',700.00,1,1.00,'Factura C N°: 0001-00000176',NULL,'2022-07-29 22:54:43','2022-07-29 23:19:38','2022-07-29 23:19:38');
INSERT INTO `cta_cte_cliente` VALUES (23,7479,2,40719,40738,13,8,1,0,'2022-06-21','2022-06-21',1000.00,1,1.00,'Factura C N°: 0001-00000177',NULL,'2022-07-29 22:54:43','2022-07-29 23:19:35','2022-07-29 23:19:35'),(24,7479,2,40719,40731,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000169',NULL,'2022-07-29 22:55:57','2022-07-29 23:20:06','2022-07-29 23:20:06'),(25,7479,2,40719,40726,13,8,1,0,'2022-06-12','2022-06-12',1000.00,1,1.00,'Factura C N°: 0001-00000165',NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(26,7479,2,40719,40727,13,8,1,0,'2022-06-12','2022-06-12',1000.00,1,1.00,'Factura C N°: 0001-00000166',NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(27,7479,2,40719,40728,13,8,1,0,'2022-06-12','2022-06-12',1000.00,1,1.00,'Factura C N°: 0001-00000167',NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(28,7479,2,40719,40729,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000172',NULL,'2022-07-30 11:23:29','2022-07-30 11:26:42','2022-07-30 11:26:42'),(29,7479,2,40719,40730,13,8,1,0,'2022-06-15','2022-06-15',700.00,1,1.00,'Factura C N°: 0001-00000168',NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(30,7479,2,40719,40731,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000169',NULL,'2022-07-30 11:23:29','2022-07-30 11:26:16','2022-07-30 11:26:16'),(31,7479,2,40719,40732,13,8,1,0,'2022-06-15','2022-06-15',2000.00,1,1.00,'Factura C N°: 0001-00000170',NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(32,7479,2,40719,40733,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000171',NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(33,7479,2,40719,40734,13,8,1,0,'2022-06-17','2022-06-17',1800.00,1,1.00,'Factura C N°: 0001-00000173',NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(34,7479,2,40719,40735,13,8,1,0,'2022-06-18','2022-06-18',2000.00,1,1.00,'Factura C N°: 0001-00000174',NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(35,7479,2,40719,40736,13,8,1,0,'2022-06-21','2022-06-21',1400.00,1,1.00,'Factura C N°: 0001-00000175',NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(36,7479,2,40719,40737,13,8,1,0,'2022-06-21','2022-06-21',700.00,1,1.00,'Factura C N°: 0001-00000176',NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(37,7479,2,40719,40738,13,8,1,0,'2022-06-21','2022-06-21',1000.00,1,1.00,'Factura C N°: 0001-00000177',NULL,'2022-07-30 11:23:29','2022-07-30 12:30:19','2022-07-30 12:30:19'),(38,7479,3,40719,40739,57,8,2,0,'2022-06-16','2022-06-16',520.00,1,1.00,'Factura C N°: 0002-00000623',NULL,'2022-07-30 11:23:49','2022-07-30 13:18:42','2022-07-30 13:18:42'),(39,7479,2,40719,40731,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000169',NULL,'2022-07-30 11:26:16','2022-07-30 12:30:19','2022-07-30 12:30:19'),(40,7479,2,40719,40729,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000172',NULL,'2022-07-30 11:26:42','2022-07-30 12:30:19','2022-07-30 12:30:19'),(41,7479,2,40719,40740,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000178',NULL,'2022-07-30 12:20:39','2022-07-30 12:30:29','2022-07-30 12:30:29'),(42,7479,2,40719,40731,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000179',NULL,'2022-07-30 12:20:39','2022-07-30 12:30:29','2022-07-30 12:30:29'),(43,7479,2,40719,40730,13,9,1,0,'2022-07-15','2022-07-15',700.00,1,1.00,'Factura C N°: 0001-00000180',NULL,'2022-07-30 12:20:39','2022-07-30 12:30:30','2022-07-30 12:30:30'),(44,7479,2,40719,40726,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000181',NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30');
INSERT INTO `cta_cte_cliente` VALUES (45,7479,2,40719,40736,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000182',NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(46,7479,2,40719,40741,13,9,1,0,'2022-07-15','2022-07-15',6000.00,1,1.00,'Factura C N°: 0001-00000183',NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(47,7479,2,40719,40742,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000184',NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(48,7479,2,40719,40737,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000185',NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(49,7479,2,40719,40743,13,9,1,0,'2022-07-15','2022-07-15',800.00,1,1.00,'Factura C N°: 0001-00000186',NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(50,7479,2,40719,40727,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000187',NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(51,7479,2,40719,40744,13,9,1,0,'2022-07-16','2022-07-16',3000.00,1,1.00,'Factura C N°: 0001-00000188',NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(52,7479,2,40719,40738,13,9,1,0,'2022-07-17','2022-07-17',1000.00,1,1.00,'Factura C N°: 0001-00000189',NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(53,7479,2,40719,40745,13,9,1,0,'2022-07-19','2022-07-19',1000.00,1,1.00,'Factura C N°: 0001-00000190',NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(54,7479,2,40719,40746,13,9,1,0,'2022-07-20','2022-07-20',3000.00,1,1.00,'Factura C N°: 0001-00000191',NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(55,7479,2,40719,40728,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000192',NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(56,7479,2,40719,40734,13,9,1,0,'2022-07-21','2022-07-21',800.00,1,1.00,'Factura C N°: 0001-00000193',NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(57,7479,2,40719,40747,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000194',NULL,'2022-07-30 12:20:40','2022-07-30 12:30:30','2022-07-30 12:30:30'),(58,7479,2,40719,40740,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000178',NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(59,7479,2,40719,40731,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000179',NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(60,7479,2,40719,40730,13,9,1,0,'2022-07-15','2022-07-15',700.00,1,1.00,'Factura C N°: 0001-00000180',NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(61,7479,2,40719,40726,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000181',NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(62,7479,2,40719,40736,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000182',NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(63,7479,2,40719,40741,13,9,1,0,'2022-07-15','2022-07-15',6000.00,1,1.00,'Factura C N°: 0001-00000183',NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(64,7479,2,40719,40742,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000184',NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(65,7479,2,40719,40737,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000185',NULL,'2022-07-30 12:31:18','2022-07-30 13:08:02','2022-07-30 13:08:02'),(66,7479,2,40719,40743,13,9,1,0,'2022-07-15','2022-07-15',800.00,1,1.00,'Factura C N°: 0001-00000186',NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03');
INSERT INTO `cta_cte_cliente` VALUES (67,7479,2,40719,40727,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000187',NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(68,7479,2,40719,40744,13,9,1,0,'2022-07-16','2022-07-16',3000.00,1,1.00,'Factura C N°: 0001-00000188',NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(69,7479,2,40719,40738,13,9,1,0,'2022-07-17','2022-07-17',1000.00,1,1.00,'Factura C N°: 0001-00000189',NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(70,7479,2,40719,40745,13,9,1,0,'2022-07-19','2022-07-19',1000.00,1,1.00,'Factura C N°: 0001-00000190',NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(71,7479,2,40719,40746,13,9,1,0,'2022-07-20','2022-07-20',3000.00,1,1.00,'Factura C N°: 0001-00000191',NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(72,7479,2,40719,40728,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000192',NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(73,7479,2,40719,40734,13,9,1,0,'2022-07-21','2022-07-21',800.00,1,1.00,'Factura C N°: 0001-00000193',NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(74,7479,2,40719,40747,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000194',NULL,'2022-07-30 12:31:18','2022-07-30 13:08:03','2022-07-30 13:08:03'),(75,7479,2,40719,40726,13,8,1,0,'2022-06-12','2022-06-12',1000.00,1,1.00,'Factura C N°: 0001-00000165',NULL,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(76,7479,2,40719,40727,13,8,1,0,'2022-06-12','2022-06-12',1000.00,1,1.00,'Factura C N°: 0001-00000166',NULL,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(77,7479,2,40719,40728,13,8,1,0,'2022-06-12','2022-06-12',1000.00,1,1.00,'Factura C N°: 0001-00000167',NULL,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(78,7479,2,40719,40729,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000172',NULL,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(79,7479,2,40719,40730,13,8,1,0,'2022-06-15','2022-06-15',700.00,1,1.00,'Factura C N°: 0001-00000168',NULL,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(80,7479,2,40719,40731,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000169',NULL,'2022-07-30 13:09:53','2022-07-30 13:18:35','2022-07-30 13:18:35'),(81,7479,2,40719,40732,13,8,1,0,'2022-06-15','2022-06-15',2000.00,1,1.00,'Factura C N°: 0001-00000170',NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(82,7479,2,40719,40733,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000171',NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(83,7479,2,40719,40734,13,8,1,0,'2022-06-17','2022-06-17',1800.00,1,1.00,'Factura C N°: 0001-00000173',NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(84,7479,2,40719,40735,13,8,1,0,'2022-06-18','2022-06-18',2000.00,1,1.00,'Factura C N°: 0001-00000174',NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(85,7479,2,40719,40736,13,8,1,0,'2022-06-21','2022-06-21',1400.00,1,1.00,'Factura C N°: 0001-00000175',NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(86,7479,2,40719,40737,13,8,1,0,'2022-06-21','2022-06-21',700.00,1,1.00,'Factura C N°: 0001-00000176',NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(87,7479,2,40719,40738,13,8,1,0,'2022-06-21','2022-06-21',1000.00,1,1.00,'Factura C N°: 0001-00000177',NULL,'2022-07-30 13:09:54','2022-07-30 13:18:35','2022-07-30 13:18:35'),(88,7479,2,40719,40726,13,8,1,0,'2022-06-12','2022-06-12',1000.00,1,1.00,'Factura C N°: 0001-00000165',NULL,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17');
INSERT INTO `cta_cte_cliente` VALUES (89,7479,2,40719,40727,13,8,1,0,'2022-06-12','2022-06-12',1000.00,1,1.00,'Factura C N°: 0001-00000166',NULL,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(90,7479,2,40719,40728,13,8,1,0,'2022-06-12','2022-06-12',1000.00,1,1.00,'Factura C N°: 0001-00000167',NULL,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(91,7479,2,40719,40729,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000172',NULL,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(92,7479,2,40719,40730,13,8,1,0,'2022-06-15','2022-06-15',700.00,1,1.00,'Factura C N°: 0001-00000168',NULL,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(93,7479,2,40719,40731,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000169',NULL,'2022-07-30 13:30:31','2022-07-30 13:35:17','2022-07-30 13:35:17'),(94,7479,2,40719,40732,13,8,1,0,'2022-06-15','2022-06-15',2000.00,1,1.00,'Factura C N°: 0001-00000170',NULL,'2022-07-30 13:30:31','2022-07-30 13:35:18','2022-07-30 13:35:18'),(95,7479,2,40719,40733,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000171',NULL,'2022-07-30 13:30:31','2022-07-30 13:35:18','2022-07-30 13:35:18'),(96,7479,2,40719,40734,13,8,1,0,'2022-06-17','2022-06-17',1800.00,1,1.00,'Factura C N°: 0001-00000173',NULL,'2022-07-30 13:30:32','2022-07-30 13:35:18','2022-07-30 13:35:18'),(97,7479,2,40719,40735,13,8,1,0,'2022-06-18','2022-06-18',2000.00,1,1.00,'Factura C N°: 0001-00000174',NULL,'2022-07-30 13:30:32','2022-07-30 13:35:18','2022-07-30 13:35:18'),(98,7479,2,40719,40736,13,8,1,0,'2022-06-21','2022-06-21',1400.00,1,1.00,'Factura C N°: 0001-00000175',NULL,'2022-07-30 13:30:32','2022-07-30 13:35:18','2022-07-30 13:35:18'),(99,7479,2,40719,40737,13,8,1,0,'2022-06-21','2022-06-21',700.00,1,1.00,'Factura C N°: 0001-00000176',NULL,'2022-07-30 13:30:32','2022-07-30 13:35:18','2022-07-30 13:35:18'),(100,7479,2,40719,40738,13,8,1,0,'2022-06-21','2022-06-21',1000.00,1,1.00,'Factura C N°: 0001-00000177',NULL,'2022-07-30 13:30:32','2022-07-30 13:35:18','2022-07-30 13:35:18'),(101,7479,3,40719,40739,57,8,2,0,'2022-06-16','2022-06-16',520.00,1,1.00,'Factura C N°: 0002-00000623',NULL,'2022-07-30 13:30:46','2022-07-30 14:16:08','2022-07-30 14:16:08'),(102,7479,2,40719,40726,13,8,1,0,'2022-06-12','2022-06-12',1000.00,1,1.00,'Factura C N°: 0001-00000165',NULL,'2022-07-30 13:35:51','2022-07-30 13:40:56','2022-07-30 13:40:56'),(103,7479,2,40719,40727,13,8,1,0,'2022-06-12','2022-06-12',1000.00,1,1.00,'Factura C N°: 0001-00000166',NULL,'2022-07-30 13:35:51','2022-07-30 13:40:53','2022-07-30 13:40:53'),(104,7479,2,40719,40728,13,8,1,0,'2022-06-12','2022-06-12',1000.00,1,1.00,'Factura C N°: 0001-00000167',NULL,'2022-07-30 13:35:51','2022-07-30 13:40:49','2022-07-30 13:40:49'),(105,7479,2,40719,40729,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000172',NULL,'2022-07-30 13:35:51','2022-07-30 13:40:37','2022-07-30 13:40:37'),(106,7479,2,40719,40730,13,8,1,0,'2022-06-15','2022-06-15',700.00,1,1.00,'Factura C N°: 0001-00000168',NULL,'2022-07-30 13:35:51','2022-07-30 13:40:45','2022-07-30 13:40:45'),(107,7479,2,40719,40731,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000169',NULL,'2022-07-30 13:35:51','2022-07-30 13:40:41','2022-07-30 13:40:41'),(108,7479,2,40719,40732,13,8,1,0,'2022-06-15','2022-06-15',2000.00,1,1.00,'Factura C N°: 0001-00000170',NULL,'2022-07-30 13:35:51','2022-07-30 13:41:00','2022-07-30 13:41:00'),(109,7479,2,40719,40733,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000171',NULL,'2022-07-30 13:35:51','2022-07-30 13:41:04','2022-07-30 13:41:04'),(110,7479,2,40719,40734,13,8,1,0,'2022-06-17','2022-06-17',1800.00,1,1.00,'Factura C N°: 0001-00000173',NULL,'2022-07-30 13:35:51','2022-07-30 13:41:08','2022-07-30 13:41:08');
INSERT INTO `cta_cte_cliente` VALUES (111,7479,2,40719,40735,13,8,1,0,'2022-06-18','2022-06-18',2000.00,1,1.00,'Factura C N°: 0001-00000174',NULL,'2022-07-30 13:35:51','2022-07-30 13:41:12','2022-07-30 13:41:12'),(112,7479,2,40719,40736,13,8,1,0,'2022-06-21','2022-06-21',1400.00,1,1.00,'Factura C N°: 0001-00000175',NULL,'2022-07-30 13:35:51','2022-07-30 13:41:15','2022-07-30 13:41:15'),(113,7479,2,40719,40737,13,8,1,0,'2022-06-21','2022-06-21',700.00,1,1.00,'Factura C N°: 0001-00000176',NULL,'2022-07-30 13:35:51','2022-07-30 13:41:19','2022-07-30 13:41:19'),(114,7479,2,40719,40738,13,8,1,0,'2022-06-21','2022-06-21',1000.00,1,1.00,'Factura C N°: 0001-00000177',NULL,'2022-07-30 13:35:51','2022-07-30 13:42:12','2022-07-30 13:42:12'),(115,7479,2,40719,40738,13,8,1,0,'2022-06-21','2022-06-21',1000.00,1,1.00,'Factura C N°: 0001-00000177',NULL,'2022-07-30 13:42:12','2022-07-30 13:47:34','2022-07-30 13:47:34'),(116,7479,2,40719,40726,13,8,1,0,'2022-06-12','2022-06-12',1000.00,1,1.00,'Factura C N°: 0001-00000165',NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(117,7479,2,40719,40727,13,8,1,0,'2022-06-12','2022-06-12',1000.00,1,1.00,'Factura C N°: 0001-00000166',NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(118,7479,2,40719,40728,13,8,1,0,'2022-06-12','2022-06-12',1000.00,1,1.00,'Factura C N°: 0001-00000167',NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(119,7479,2,40719,40729,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000172',NULL,'2022-07-30 13:48:32','2022-07-30 14:03:39','2022-07-30 14:03:39'),(120,7479,2,40719,40730,13,8,1,0,'2022-06-15','2022-06-15',700.00,1,1.00,'Factura C N°: 0001-00000168',NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(121,7479,2,40719,40731,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000169',NULL,'2022-07-30 13:48:32','2022-07-30 14:03:18','2022-07-30 14:03:18'),(122,7479,2,40719,40732,13,8,1,0,'2022-06-15','2022-06-15',2000.00,1,1.00,'Factura C N°: 0001-00000170',NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(123,7479,2,40719,40733,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000171',NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(124,7479,2,40719,40734,13,8,1,0,'2022-06-17','2022-06-17',1800.00,1,1.00,'Factura C N°: 0001-00000173',NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(125,7479,2,40719,40735,13,8,1,0,'2022-06-18','2022-06-18',2000.00,1,1.00,'Factura C N°: 0001-00000174',NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(126,7479,2,40719,40736,13,8,1,0,'2022-06-21','2022-06-21',1400.00,1,1.00,'Factura C N°: 0001-00000175',NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(127,7479,2,40719,40737,13,8,1,0,'2022-06-21','2022-06-21',700.00,1,1.00,'Factura C N°: 0001-00000176',NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(128,7479,2,40719,40738,13,8,1,0,'2022-06-21','2022-06-21',1000.00,1,1.00,'Factura C N°: 0001-00000177',NULL,'2022-07-30 13:48:32','2022-07-30 14:15:59','2022-07-30 14:15:59'),(129,7479,2,40719,40731,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000169',NULL,'2022-07-30 14:03:18','2022-07-30 14:15:59','2022-07-30 14:15:59'),(130,7479,2,40719,40729,13,8,1,0,'2022-06-15','2022-06-15',1000.00,1,1.00,'Factura C N°: 0001-00000172',NULL,'2022-07-30 14:03:39','2022-07-30 14:15:59','2022-07-30 14:15:59'),(131,7479,2,40719,40740,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000178',NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(132,7479,2,40719,40731,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000179',NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28');
INSERT INTO `cta_cte_cliente` VALUES (133,7479,2,40719,40730,13,9,1,0,'2022-07-15','2022-07-15',700.00,1,1.00,'Factura C N°: 0001-00000180',NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(134,7479,2,40719,40726,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000181',NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(135,7479,2,40719,40736,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000182',NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(136,7479,2,40719,40741,13,9,1,0,'2022-07-15','2022-07-15',6000.00,1,1.00,'Factura C N°: 0001-00000183',NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(137,7479,2,40719,40742,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000184',NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(138,7479,2,40719,40737,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000185',NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(139,7479,2,40719,40743,13,9,1,0,'2022-07-15','2022-07-15',800.00,1,1.00,'Factura C N°: 0001-00000186',NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(140,7479,2,40719,40727,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000187',NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(141,7479,2,40719,40744,13,9,1,0,'2022-07-16','2022-07-16',3000.00,1,1.00,'Factura C N°: 0001-00000188',NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(142,7479,2,40719,40738,13,9,1,0,'2022-07-17','2022-07-17',1000.00,1,1.00,'Factura C N°: 0001-00000189',NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(143,7479,2,40719,40745,13,9,1,0,'2022-07-19','2022-07-19',1000.00,1,1.00,'Factura C N°: 0001-00000190',NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(144,7479,2,40719,40746,13,9,1,0,'2022-07-20','2022-07-20',3000.00,1,1.00,'Factura C N°: 0001-00000191',NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(145,7479,2,40719,40728,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000192',NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(146,7479,2,40719,40734,13,9,1,0,'2022-07-21','2022-07-21',800.00,1,1.00,'Factura C N°: 0001-00000193',NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(147,7479,2,40719,40747,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000194',NULL,'2022-07-30 14:16:39','2022-07-30 14:18:28','2022-07-30 14:18:28'),(148,7479,2,40719,40740,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000178',NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(149,7479,2,40719,40731,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000179',NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(150,7479,2,40719,40730,13,9,1,0,'2022-07-15','2022-07-15',700.00,1,1.00,'Factura C N°: 0001-00000180',NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(151,7479,2,40719,40726,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000181',NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(152,7479,2,40719,40736,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000182',NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(153,7479,2,40719,40741,13,9,1,0,'2022-07-15','2022-07-15',6000.00,1,1.00,'Factura C N°: 0001-00000183',NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(154,7479,2,40719,40742,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000184',NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44');
INSERT INTO `cta_cte_cliente` VALUES (155,7479,2,40719,40737,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000185',NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(156,7479,2,40719,40743,13,9,1,0,'2022-07-15','2022-07-15',800.00,1,1.00,'Factura C N°: 0001-00000186',NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(157,7479,2,40719,40727,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000187',NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(158,7479,2,40719,40744,13,9,1,0,'2022-07-16','2022-07-16',3000.00,1,1.00,'Factura C N°: 0001-00000188',NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(159,7479,2,40719,40738,13,9,1,0,'2022-07-17','2022-07-17',1000.00,1,1.00,'Factura C N°: 0001-00000189',NULL,'2022-07-30 14:18:56','2022-07-30 14:26:44','2022-07-30 14:26:44'),(160,7479,2,40719,40745,13,9,1,0,'2022-07-19','2022-07-19',1000.00,1,1.00,'Factura C N°: 0001-00000190',NULL,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44'),(161,7479,2,40719,40746,13,9,1,0,'2022-07-20','2022-07-20',3000.00,1,1.00,'Factura C N°: 0001-00000191',NULL,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44'),(162,7479,2,40719,40728,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000192',NULL,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44'),(163,7479,2,40719,40734,13,9,1,0,'2022-07-21','2022-07-21',800.00,1,1.00,'Factura C N°: 0001-00000193',NULL,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44'),(164,7479,2,40719,40747,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000194',NULL,'2022-07-30 14:18:57','2022-07-30 14:26:44','2022-07-30 14:26:44'),(165,7479,2,40719,40740,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000178',NULL,'2022-07-30 14:28:08','2022-07-30 15:46:07','2022-07-30 15:46:07'),(166,7479,2,40719,40731,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000179',NULL,'2022-07-30 14:28:08','2022-07-30 15:46:07','2022-07-30 15:46:07'),(167,7479,2,40719,40730,13,9,1,0,'2022-07-15','2022-07-15',700.00,1,1.00,'Factura C N°: 0001-00000180',NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(168,7479,2,40719,40726,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000181',NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(169,7479,2,40719,40736,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000182',NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(170,7479,2,40719,40741,13,9,1,0,'2022-07-15','2022-07-15',6000.00,1,1.00,'Factura C N°: 0001-00000183',NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(171,7479,2,40719,40742,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000184',NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(172,7479,2,40719,40737,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000185',NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(173,7479,2,40719,40743,13,9,1,0,'2022-07-15','2022-07-15',800.00,1,1.00,'Factura C N°: 0001-00000186',NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(174,7479,2,40719,40727,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000187',NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(175,7479,2,40719,40744,13,9,1,0,'2022-07-16','2022-07-16',3000.00,1,1.00,'Factura C N°: 0001-00000188',NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(176,7479,2,40719,40738,13,9,1,0,'2022-07-17','2022-07-17',1000.00,1,1.00,'Factura C N°: 0001-00000189',NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07');
INSERT INTO `cta_cte_cliente` VALUES (177,7479,2,40719,40745,13,9,1,0,'2022-07-19','2022-07-19',1000.00,1,1.00,'Factura C N°: 0001-00000190',NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(178,7479,2,40719,40746,13,9,1,0,'2022-07-20','2022-07-20',3000.00,1,1.00,'Factura C N°: 0001-00000191',NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(179,7479,2,40719,40728,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000192',NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(180,7479,2,40719,40734,13,9,1,0,'2022-07-21','2022-07-21',800.00,1,1.00,'Factura C N°: 0001-00000193',NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(181,7479,2,40719,40747,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000194',NULL,'2022-07-30 14:28:09','2022-07-30 15:46:07','2022-07-30 15:46:07'),(182,7479,2,40719,40740,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000178',NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(183,7479,2,40719,40731,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000179',NULL,'2022-07-30 15:51:22','2022-07-30 15:53:14','2022-07-30 15:53:14'),(184,7479,2,40719,40730,13,9,1,0,'2022-07-15','2022-07-15',700.00,1,1.00,'Factura C N°: 0001-00000180',NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(185,7479,2,40719,40726,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000181',NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(186,7479,2,40719,40736,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000182',NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(187,7479,2,40719,40741,13,9,1,0,'2022-07-15','2022-07-15',6000.00,1,1.00,'Factura C N°: 0001-00000183',NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(188,7479,2,40719,40742,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000184',NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(189,7479,2,40719,40737,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000185',NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(190,7479,2,40719,40743,13,9,1,0,'2022-07-15','2022-07-15',800.00,1,1.00,'Factura C N°: 0001-00000186',NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(191,7479,2,40719,40727,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000187',NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(192,7479,2,40719,40744,13,9,1,0,'2022-07-16','2022-07-16',3000.00,1,1.00,'Factura C N°: 0001-00000188',NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(193,7479,2,40719,40738,13,9,1,0,'2022-07-17','2022-07-17',1000.00,1,1.00,'Factura C N°: 0001-00000189',NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(194,7479,2,40719,40745,13,9,1,0,'2022-07-19','2022-07-19',1000.00,1,1.00,'Factura C N°: 0001-00000190',NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(195,7479,2,40719,40746,13,9,1,0,'2022-07-20','2022-07-20',3000.00,1,1.00,'Factura C N°: 0001-00000191',NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(196,7479,2,40719,40728,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000192',NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(197,7479,2,40719,40734,13,9,1,0,'2022-07-21','2022-07-21',800.00,1,1.00,'Factura C N°: 0001-00000193',NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34'),(198,7479,2,40719,40747,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000194',NULL,'2022-07-30 15:51:22','2022-07-30 15:57:34','2022-07-30 15:57:34');
INSERT INTO `cta_cte_cliente` VALUES (199,7479,2,40719,40731,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000179',NULL,'2022-07-30 15:53:14','2022-07-30 15:57:34','2022-07-30 15:57:34'),(200,7479,2,40719,40740,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000178',NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(201,7479,2,40719,40731,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000179',NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(202,7479,2,40719,40730,13,9,1,0,'2022-07-15','2022-07-15',700.00,1,1.00,'Factura C N°: 0001-00000180',NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(203,7479,2,40719,40726,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000181',NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(204,7479,2,40719,40736,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000182',NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(205,7479,2,40719,40741,13,9,1,0,'2022-07-15','2022-07-15',6000.00,1,1.00,'Factura C N°: 0001-00000183',NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(206,7479,2,40719,40742,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000184',NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(207,7479,2,40719,40737,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000185',NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(208,7479,2,40719,40743,13,9,1,0,'2022-07-15','2022-07-15',800.00,1,1.00,'Factura C N°: 0001-00000186',NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(209,7479,2,40719,40727,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000187',NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(210,7479,2,40719,40744,13,9,1,0,'2022-07-16','2022-07-16',3000.00,1,1.00,'Factura C N°: 0001-00000188',NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(211,7479,2,40719,40738,13,9,1,0,'2022-07-17','2022-07-17',1000.00,1,1.00,'Factura C N°: 0001-00000189',NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(212,7479,2,40719,40745,13,9,1,0,'2022-07-19','2022-07-19',1000.00,1,1.00,'Factura C N°: 0001-00000190',NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(213,7479,2,40719,40746,13,9,1,0,'2022-07-20','2022-07-20',3000.00,1,1.00,'Factura C N°: 0001-00000191',NULL,'2022-07-30 16:00:49','2022-07-30 16:07:09','2022-07-30 16:07:09'),(214,7479,2,40719,40728,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000192',NULL,'2022-07-30 16:00:50','2022-07-30 16:07:09','2022-07-30 16:07:09'),(215,7479,2,40719,40734,13,9,1,0,'2022-07-21','2022-07-21',800.00,1,1.00,'Factura C N°: 0001-00000193',NULL,'2022-07-30 16:00:50','2022-07-30 16:07:09','2022-07-30 16:07:09'),(216,7479,2,40719,40747,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000194',NULL,'2022-07-30 16:00:50','2022-07-30 16:07:09','2022-07-30 16:07:09'),(217,7479,2,40719,40740,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000178',NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(218,7479,2,40719,40731,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000179',NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(219,7479,2,40719,40730,13,9,1,0,'2022-07-15','2022-07-15',700.00,1,1.00,'Factura C N°: 0001-00000180',NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(220,7479,2,40719,40726,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000181',NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03');
INSERT INTO `cta_cte_cliente` VALUES (221,7479,2,40719,40736,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000182',NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(222,7479,2,40719,40741,13,9,1,0,'2022-07-15','2022-07-15',6000.00,1,1.00,'Factura C N°: 0001-00000183',NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(223,7479,2,40719,40742,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000184',NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(224,7479,2,40719,40737,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000185',NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(225,7479,2,40719,40743,13,9,1,0,'2022-07-15','2022-07-15',800.00,1,1.00,'Factura C N°: 0001-00000186',NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(226,7479,2,40719,40727,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000187',NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(227,7479,2,40719,40744,13,9,1,0,'2022-07-16','2022-07-16',3000.00,1,1.00,'Factura C N°: 0001-00000188',NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(228,7479,2,40719,40738,13,9,1,0,'2022-07-17','2022-07-17',1000.00,1,1.00,'Factura C N°: 0001-00000189',NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(229,7479,2,40719,40745,13,9,1,0,'2022-07-19','2022-07-19',1000.00,1,1.00,'Factura C N°: 0001-00000190',NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(230,7479,2,40719,40746,13,9,1,0,'2022-07-20','2022-07-20',3000.00,1,1.00,'Factura C N°: 0001-00000191',NULL,'2022-07-30 16:09:42','2022-07-30 16:19:03','2022-07-30 16:19:03'),(231,7479,2,40719,40728,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000192',NULL,'2022-07-30 16:09:43','2022-07-30 16:19:03','2022-07-30 16:19:03'),(232,7479,2,40719,40734,13,9,1,0,'2022-07-21','2022-07-21',800.00,1,1.00,'Factura C N°: 0001-00000193',NULL,'2022-07-30 16:09:43','2022-07-30 16:19:03','2022-07-30 16:19:03'),(233,7479,2,40719,40747,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000194',NULL,'2022-07-30 16:09:43','2022-07-30 16:19:03','2022-07-30 16:19:03'),(234,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',56000.00,1,1.00,'Factura C N°: 0002-00000093',NULL,'2022-07-30 16:29:21','2022-07-30 18:55:49','2022-07-30 18:55:49'),(235,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',15000.00,1,1.00,'Factura C N°: 0002-00000094',NULL,'2022-07-30 16:29:21','2022-07-30 18:55:49','2022-07-30 18:55:49'),(236,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',20000.00,1,1.00,'Factura C N°: 0002-00000095',NULL,'2022-07-30 16:29:21','2022-07-30 18:55:49','2022-07-30 18:55:49'),(237,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',15000.00,1,1.00,'Factura C N°: 0002-00000096',NULL,'2022-07-30 16:29:21','2022-07-30 18:55:49','2022-07-30 18:55:49'),(238,7479,2,40748,40749,13,7707,1,0,'2022-05-05','2022-05-05',27000.00,1,1.00,'Factura C N°: 0002-00000088',NULL,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18'),(239,7479,2,40748,40750,13,7707,1,0,'2022-05-16','2022-05-16',25000.00,1,1.00,'Factura C N°: 0002-00000089',NULL,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18'),(240,7479,2,40748,40749,13,7707,1,0,'2022-05-21','2022-05-21',36000.00,1,1.00,'Factura C N°: 0002-00000090',NULL,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18'),(241,7479,2,40748,40749,13,7707,1,0,'2022-05-27','2022-05-27',75000.00,1,1.00,'Factura C N°: 0002-00000091',NULL,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18'),(242,7479,2,40748,40751,13,7707,1,0,'2022-05-30','2022-05-30',6000.00,1,1.00,'Factura C N°: 0002-00000092',NULL,'2022-07-30 16:33:51','2022-07-30 17:23:18','2022-07-30 17:23:18');
INSERT INTO `cta_cte_cliente` VALUES (243,7479,2,40748,40749,13,7707,1,0,'2022-05-05','2022-05-05',0.00,1,1.00,'Factura C N°: 0002-00000088',NULL,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(244,7479,2,40748,40750,13,7707,1,0,'2022-05-16','2022-05-16',0.00,1,1.00,'Factura C N°: 0002-00000089',NULL,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(245,7479,2,40748,40749,13,7707,1,0,'2022-05-21','2022-05-21',0.00,1,1.00,'Factura C N°: 0002-00000090',NULL,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(246,7479,2,40748,40749,13,7707,1,0,'2022-05-27','2022-05-27',0.00,1,1.00,'Factura C N°: 0002-00000091',NULL,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(247,7479,2,40748,40751,13,7707,1,0,'2022-05-30','2022-05-30',0.00,1,1.00,'Factura C N°: 0002-00000092',NULL,'2022-07-30 17:23:53','2022-07-30 17:27:10','2022-07-30 17:27:10'),(248,7479,2,40748,40749,13,7707,1,0,'2022-05-05','2022-05-05',27000.00,1,1.00,'Factura C N°: 0002-00000088',NULL,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49'),(249,7479,2,40748,40750,13,7707,1,0,'2022-05-16','2022-05-16',25000.00,1,1.00,'Factura C N°: 0002-00000089',NULL,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49'),(250,7479,2,40748,40749,13,7707,1,0,'2022-05-21','2022-05-21',36000.00,1,1.00,'Factura C N°: 0002-00000090',NULL,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49'),(251,7479,2,40748,40749,13,7707,1,0,'2022-05-27','2022-05-27',75000.00,1,1.00,'Factura C N°: 0002-00000091',NULL,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49'),(252,7479,2,40748,40751,13,7707,1,0,'2022-05-30','2022-05-30',6000.00,1,1.00,'Factura C N°: 0002-00000092',NULL,'2022-07-30 17:28:26','2022-07-30 18:55:49','2022-07-30 18:55:49'),(253,7479,2,40748,40749,13,7707,1,0,'2022-05-05','2022-05-05',27000.00,1,1.00,'Factura C N°: 0002-00000088',NULL,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(254,7479,2,40748,40750,13,7707,1,0,'2022-05-16','2022-05-16',25000.00,1,1.00,'Factura C N°: 0002-00000089',NULL,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(255,7479,2,40748,40749,13,7707,1,0,'2022-05-21','2022-05-21',36000.00,1,1.00,'Factura C N°: 0002-00000090',NULL,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(256,7479,2,40748,40749,13,7707,1,0,'2022-05-27','2022-05-27',75000.00,1,1.00,'Factura C N°: 0002-00000091',NULL,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(257,7479,2,40748,40751,13,7707,1,0,'2022-05-30','2022-05-30',6000.00,1,1.00,'Factura C N°: 0002-00000092',NULL,'2022-07-30 18:59:21','2022-08-02 20:17:21','2022-08-02 20:17:21'),(258,7479,2,40727,40752,13,7710,1,0,'2022-06-23','2022-06-23',176600.00,1,1.00,'Factura C N°: 0001-00000038',NULL,'2022-07-30 19:15:16','2022-08-01 18:59:34','2022-08-01 18:59:34'),(259,7479,3,40727,40753,57,7710,2,0,'2022-06-02','2022-06-02',43.59,1,1.00,'Factura B N°: 5015-02372738',NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(260,7479,3,40727,40719,57,7710,2,0,'2022-06-12','2022-06-12',1000.00,1,1.00,'Factura C N°: 0001-00000166',NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(261,7479,3,40727,40754,57,7710,2,0,'2022-06-13','2022-06-13',500.00,1,1.00,'Factura B N°: 2221-12169022',NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(262,7479,3,40727,40755,57,7710,2,0,'2022-06-13','2022-06-13',41998.00,1,1.00,'Factura B N°: 2369-00000061',NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(263,7479,3,40727,40756,57,7710,2,0,'2022-06-30','2022-06-30',4999.00,1,1.00,'Factura B N°: 0003-00004120',NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(264,7479,3,40727,40757,57,7710,2,0,'2022-06-30','2022-06-30',12499.00,1,1.00,'Factura B N°: 0020-00002011',NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL);
INSERT INTO `cta_cte_cliente` VALUES (265,7479,2,40727,40752,13,7710,1,0,'2022-06-23','2022-06-23',176600.00,1,1.00,'Factura C N°: 0001-00000038',NULL,'2022-08-01 18:59:34','2022-08-01 19:56:34','2022-08-01 19:56:34'),(266,7479,2,40727,40752,13,7710,1,0,'2022-06-23','2022-06-23',176600.00,1,1.00,'Factura C N°: 0001-00000038',NULL,'2022-08-01 19:57:38','2022-08-01 20:01:30','2022-08-01 20:01:30'),(267,7479,2,40727,40752,13,7710,1,0,'2022-06-23','2022-06-23',176600.00,1,1.00,'Factura C N°: 0001-00000038',NULL,'2022-08-01 20:03:12','2022-08-01 20:11:56','2022-08-01 20:11:56'),(268,7479,2,40727,40752,13,7710,1,0,'2022-06-23','2022-06-23',176600.00,1,1.00,'Factura C N°: 0001-00000038',NULL,'2022-08-01 20:25:12','2022-08-01 20:25:52','2022-08-01 20:25:52'),(269,7479,2,40727,40752,13,7710,1,0,'2022-06-23','2022-06-23',176600.00,1,1.00,'Factura C N°: 0001-00000038',NULL,'2022-08-01 20:25:52','2022-08-01 20:26:48','2022-08-01 20:26:48'),(270,7479,2,40727,40752,13,7710,1,0,'2022-06-23','2022-06-23',176600.00,1,1.00,'Factura C N°: 0001-00000038',NULL,'2022-08-01 20:26:48','2022-08-01 20:26:56','2022-08-01 20:26:56'),(271,7479,2,40727,40752,13,7710,1,0,'2022-06-23','2022-06-23',176600.00,1,1.00,'Factura C N°: 0001-00000038',NULL,'2022-08-01 20:26:56','2022-08-01 20:27:34','2022-08-01 20:27:34'),(272,7479,2,40727,40752,13,7710,1,0,'2022-06-23','2022-06-23',176600.00,1,1.00,'Factura C N°: 0001-00000038',NULL,'2022-08-01 20:27:34','2022-08-02 18:38:32','2022-08-02 18:38:32'),(273,7479,2,40727,40752,13,7711,1,0,'2022-07-15','2022-07-15',176600.00,1,1.00,'Factura C N°: 0001-00000039',NULL,'2022-08-02 18:31:06','2022-08-02 18:38:28','2022-08-02 18:38:28'),(274,7479,2,40727,40752,13,7711,1,0,'2022-07-15','2022-07-15',176600.00,1,1.00,'Factura C N°: 0001-00000039',NULL,'2022-08-02 18:46:50','2022-08-04 21:51:28','2022-08-04 21:51:28'),(275,7479,2,40722,40723,13,4533,1,0,'2022-07-03','2022-07-03',17120.00,1,1.00,'Factura C N°: 0001-00000005',NULL,'2022-08-02 18:56:19','2022-08-02 18:57:51','2022-08-02 18:57:51'),(276,7479,2,40722,40723,13,4533,1,0,'2022-07-03','2022-07-03',124120.00,1,1.00,'Factura C N°: 0001-00000006',NULL,'2022-08-02 18:56:19','2022-08-02 18:57:51','2022-08-02 18:57:51'),(277,7479,2,40719,40740,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000178',NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(278,7479,2,40719,40731,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000179',NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(279,7479,2,40719,40730,13,9,1,0,'2022-07-15','2022-07-15',700.00,1,1.00,'Factura C N°: 0001-00000180',NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(280,7479,2,40719,40726,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000181',NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(281,7479,2,40719,40736,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000182',NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(282,7479,2,40719,40741,13,9,1,0,'2022-07-15','2022-07-15',6000.00,1,1.00,'Factura C N°: 0001-00000183',NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(283,7479,2,40719,40742,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000184',NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(284,7479,2,40719,40737,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000185',NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(285,7479,2,40719,40743,13,9,1,0,'2022-07-15','2022-07-15',800.00,1,1.00,'Factura C N°: 0001-00000186',NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(286,7479,2,40719,40727,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000187',NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24');
INSERT INTO `cta_cte_cliente` VALUES (287,7479,2,40719,40744,13,9,1,0,'2022-07-16','2022-07-16',3000.00,1,1.00,'Factura C N°: 0001-00000188',NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(288,7479,2,40719,40738,13,9,1,0,'2022-07-17','2022-07-17',1000.00,1,1.00,'Factura C N°: 0001-00000189',NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(289,7479,2,40719,40745,13,9,1,0,'2022-07-19','2022-07-19',1000.00,1,1.00,'Factura C N°: 0001-00000190',NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(290,7479,2,40719,40746,13,9,1,0,'2022-07-20','2022-07-20',3000.00,1,1.00,'Factura C N°: 0001-00000191',NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(291,7479,2,40719,40728,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000192',NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(292,7479,2,40719,40734,13,9,1,0,'2022-07-21','2022-07-21',800.00,1,1.00,'Factura C N°: 0001-00000193',NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(293,7479,2,40719,40747,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000194',NULL,'2022-08-02 19:01:50','2022-08-11 18:10:24','2022-08-11 18:10:24'),(294,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',56000.00,1,1.00,'Factura C N°: 0002-00000093',NULL,'2022-08-02 20:20:13','2022-08-02 20:22:12','2022-08-02 20:22:12'),(295,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',15000.00,1,1.00,'Factura C N°: 0002-00000094',NULL,'2022-08-02 20:20:13','2022-08-02 20:22:12','2022-08-02 20:22:12'),(296,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',20000.00,1,1.00,'Factura C N°: 0002-00000095',NULL,'2022-08-02 20:20:13','2022-08-02 20:22:12','2022-08-02 20:22:12'),(297,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',15000.00,1,1.00,'Factura C N°: 0002-00000096',NULL,'2022-08-02 20:20:13','2022-08-02 20:22:12','2022-08-02 20:22:12'),(298,7479,2,40727,40752,13,7711,1,0,'2022-07-15','2022-07-15',176600.00,1,1.00,'Factura C N°: 0001-00000039',NULL,'2022-08-04 21:54:19','2022-08-04 22:00:22','2022-08-04 22:00:22'),(299,7479,2,40727,40752,13,7711,1,0,'2022-07-15','2022-07-15',176600.00,1,1.00,'Factura C N°: 0001-00000039',NULL,'2022-08-04 22:01:23','2022-08-04 22:04:12','2022-08-04 22:04:12'),(300,7479,2,40727,40752,13,7711,1,0,'2022-07-15','2022-07-15',176600.00,1,1.00,'Factura C N°: 0001-00000039',NULL,'2022-08-06 11:10:13','2022-08-06 11:17:48','2022-08-06 11:17:48'),(301,7479,2,40727,40752,13,7711,1,0,'2022-07-15','2022-07-15',176600.00,1,1.00,'Factura C N°: 0001-00000039',NULL,'2022-08-06 11:26:42','2022-08-11 18:41:16','2022-08-11 18:41:16'),(302,7479,2,40719,40740,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000178',NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(303,7479,2,40719,40731,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000179',NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(304,7479,2,40719,40730,13,9,1,0,'2022-07-15','2022-07-15',700.00,1,1.00,'Factura C N°: 0001-00000180',NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(305,7479,2,40719,40726,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000181',NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(306,7479,2,40719,40736,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000182',NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(307,7479,2,40719,40741,13,9,1,0,'2022-07-15','2022-07-15',6000.00,1,1.00,'Factura C N°: 0001-00000183',NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(308,7479,2,40719,40742,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000184',NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52');
INSERT INTO `cta_cte_cliente` VALUES (309,7479,2,40719,40737,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000185',NULL,'2022-08-11 18:14:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(310,7479,2,40719,40743,13,9,1,0,'2022-07-15','2022-07-15',800.00,1,1.00,'Factura C N°: 0001-00000186',NULL,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(311,7479,2,40719,40727,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000187',NULL,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(312,7479,2,40719,40744,13,9,1,0,'2022-07-16','2022-07-16',3000.00,1,1.00,'Factura C N°: 0001-00000188',NULL,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(313,7479,2,40719,40738,13,9,1,0,'2022-07-17','2022-07-17',1000.00,1,1.00,'Factura C N°: 0001-00000189',NULL,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(314,7479,2,40719,40745,13,9,1,0,'2022-07-19','2022-07-19',1000.00,1,1.00,'Factura C N°: 0001-00000190',NULL,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(315,7479,2,40719,40746,13,9,1,0,'2022-07-20','2022-07-20',3000.00,1,1.00,'Factura C N°: 0001-00000191',NULL,'2022-08-11 18:14:45','2022-08-11 18:27:52','2022-08-11 18:27:52'),(316,7479,2,40719,40728,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000192',NULL,'2022-08-11 18:14:45','2022-08-11 18:27:44','2022-08-11 18:27:44'),(317,7479,2,40719,40734,13,9,1,0,'2022-07-21','2022-07-21',800.00,1,1.00,'Factura C N°: 0001-00000193',NULL,'2022-08-11 18:14:45','2022-08-11 18:27:36','2022-08-11 18:27:36'),(318,7479,2,40719,40747,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000194',NULL,'2022-08-11 18:14:45','2022-08-11 18:27:18','2022-08-11 18:27:18'),(319,7479,2,40719,40747,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000194',NULL,'2022-08-11 18:27:18','2022-08-11 18:27:52','2022-08-11 18:27:52'),(320,7479,2,40719,40734,13,9,1,0,'2022-07-21','2022-07-21',800.00,1,1.00,'Factura C N°: 0001-00000193',NULL,'2022-08-11 18:27:36','2022-08-11 18:27:52','2022-08-11 18:27:52'),(321,7479,2,40719,40728,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000192',NULL,'2022-08-11 18:27:44','2022-08-11 18:27:52','2022-08-11 18:27:52'),(322,7479,2,40719,40740,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000178',NULL,'2022-08-11 18:29:38','2023-06-29 21:42:51','2023-06-29 21:42:51'),(323,7479,2,40719,40731,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000179',NULL,'2022-08-11 18:29:38','2023-06-29 21:42:48','2023-06-29 21:42:48'),(324,7479,2,40719,40730,13,9,1,0,'2022-07-15','2022-07-15',700.00,1,1.00,'Factura C N°: 0001-00000180',NULL,'2022-08-11 18:29:38','2023-06-29 21:42:44','2023-06-29 21:42:44'),(325,7479,2,40719,40726,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000181',NULL,'2022-08-11 18:29:38','2023-06-29 21:42:41','2023-06-29 21:42:41'),(326,7479,2,40719,40736,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000182',NULL,'2022-08-11 18:29:38','2023-06-29 21:42:37','2023-06-29 21:42:37'),(327,7479,2,40719,40741,13,9,1,0,'2022-07-15','2022-07-15',6000.00,1,1.00,'Factura C N°: 0001-00000183',NULL,'2022-08-11 18:29:38','2023-06-29 21:42:32','2023-06-29 21:42:32'),(328,7479,2,40719,40742,13,9,1,0,'2022-07-15','2022-07-15',2000.00,1,1.00,'Factura C N°: 0001-00000184',NULL,'2022-08-11 18:29:38','2023-06-29 21:42:21','2023-06-29 21:42:21'),(329,7479,2,40719,40737,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000185',NULL,'2022-08-11 18:29:38','2023-06-29 21:42:17','2023-06-29 21:42:17'),(330,7479,2,40719,40743,13,9,1,0,'2022-07-15','2022-07-15',800.00,1,1.00,'Factura C N°: 0001-00000186',NULL,'2022-08-11 18:29:38','2023-06-29 21:42:14','2023-06-29 21:42:14');
INSERT INTO `cta_cte_cliente` VALUES (331,7479,2,40719,40727,13,9,1,0,'2022-07-15','2022-07-15',1000.00,1,1.00,'Factura C N°: 0001-00000187',NULL,'2022-08-11 18:29:38','2023-06-29 21:42:11','2023-06-29 21:42:11'),(332,7479,2,40719,40744,13,9,1,0,'2022-07-16','2022-07-16',3000.00,1,1.00,'Factura C N°: 0001-00000188',NULL,'2022-08-11 18:29:38','2023-06-29 21:42:07','2023-06-29 21:42:07'),(333,7479,2,40719,40738,13,9,1,0,'2022-07-17','2022-07-17',1000.00,1,1.00,'Factura C N°: 0001-00000189',NULL,'2022-08-11 18:29:38','2023-06-29 21:42:04','2023-06-29 21:42:04'),(334,7479,2,40719,40745,13,9,1,0,'2022-07-19','2022-07-19',1000.00,1,1.00,'Factura C N°: 0001-00000190',NULL,'2022-08-11 18:29:38','2023-06-29 21:42:00','2023-06-29 21:42:00'),(335,7479,2,40719,40746,13,9,1,0,'2022-07-20','2022-07-20',3000.00,1,1.00,'Factura C N°: 0001-00000191',NULL,'2022-08-11 18:29:38','2023-06-29 21:41:56','2023-06-29 21:41:56'),(336,7479,2,40719,40728,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000192',NULL,'2022-08-11 18:29:38','2023-06-29 21:14:24','2023-06-29 21:14:24'),(337,7479,2,40719,40734,13,9,1,0,'2022-07-21','2022-07-21',800.00,1,1.00,'Factura C N°: 0001-00000193',NULL,'2022-08-11 18:29:39','2023-06-29 21:14:21','2023-06-29 21:14:21'),(338,7479,2,40719,40747,13,9,1,0,'2022-07-21','2022-07-21',1000.00,1,1.00,'Factura C N°: 0001-00000194',NULL,'2022-08-11 18:29:39','2023-06-29 21:14:17','2023-06-29 21:14:17'),(339,7479,2,40727,40752,13,7711,1,0,'2022-07-15','2022-07-15',176600.00,1,1.00,'Factura C N°: 0001-00000039',NULL,'2022-08-11 18:41:57','2022-08-23 18:32:46','2022-08-23 18:32:46'),(340,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',56000.00,1,1.00,'Factura C N°: 0002-00000093',NULL,'2022-08-11 19:03:30','2022-08-12 18:44:46','2022-08-12 18:44:46'),(341,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',15000.00,1,1.00,'Factura C N°: 0002-00000094',NULL,'2022-08-11 19:03:30','2022-08-12 18:44:37','2022-08-12 18:44:37'),(342,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',20000.00,1,1.00,'Factura C N°: 0002-00000095',NULL,'2022-08-11 19:03:30','2022-08-12 18:44:29','2022-08-12 18:44:29'),(343,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',15000.00,1,1.00,'Factura C N°: 0002-00000096',NULL,'2022-08-11 19:03:30','2022-08-12 18:44:21','2022-08-12 18:44:21'),(344,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',15000.00,1,1.00,'Factura C N°: 0002-00000096',NULL,'2022-08-12 18:44:21','2022-08-12 18:45:40','2022-08-12 18:45:40'),(345,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',20000.00,1,1.00,'Factura C N°: 0002-00000095',NULL,'2022-08-12 18:44:29','2022-08-12 18:45:40','2022-08-12 18:45:40'),(346,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',15000.00,1,1.00,'Factura C N°: 0002-00000094',NULL,'2022-08-12 18:44:37','2022-08-12 18:45:40','2022-08-12 18:45:40'),(347,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',56000.00,1,1.00,'Factura C N°: 0002-00000093',NULL,'2022-08-12 18:44:46','2022-08-12 18:45:40','2022-08-12 18:45:40'),(348,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',56000.00,1,1.00,'Factura C N°: 0002-00000093',NULL,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(349,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',15000.00,1,1.00,'Factura C N°: 0002-00000094',NULL,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(350,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',20000.00,1,1.00,'Factura C N°: 0002-00000095',NULL,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(351,7479,2,40748,40749,13,6121,1,0,'2022-07-26','2022-07-26',15000.00,1,1.00,'Factura C N°: 0002-00000096',NULL,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(352,7479,2,40727,40752,13,7712,1,0,'2022-08-18','2022-08-18',176600.00,1,1.00,'Factura C N°: 0001-00000040',NULL,'2022-08-23 18:35:45','2022-08-23 18:36:27','2022-08-23 18:36:27');
INSERT INTO `cta_cte_cliente` VALUES (353,7479,2,40727,40752,13,7712,1,0,'2022-08-18','2022-08-18',176600.00,1,1.00,'Factura C N°: 0001-00000040',NULL,'2022-08-23 18:36:27','2022-08-23 18:47:09','2022-08-23 18:47:09'),(354,7479,2,40727,40752,13,7712,1,0,'2022-08-18','2022-08-18',176000.00,1,1.00,'Factura C N°: 0001-00000040',NULL,'2022-08-23 18:47:09','2022-08-23 18:47:09',NULL),(355,7479,2,40719,40726,13,23,1,0,'2023-06-15','2023-06-15',3500.00,1,1.00,'Factura C N°: 0001-00000355',NULL,'2023-06-29 21:50:05','2023-06-29 21:50:05',NULL),(356,7479,2,40719,40728,13,23,1,0,'2023-06-15','2023-06-15',3500.00,1,1.00,'Factura C N°: 0001-00000356',NULL,'2023-06-29 21:50:05','2023-06-29 22:16:53','2023-06-29 22:16:53'),(357,7479,2,40719,40743,13,23,1,0,'2023-06-15','2023-06-15',3500.00,1,1.00,'Factura C N°: 0001-00000357',NULL,'2023-06-29 21:50:05','2023-06-29 22:16:49','2023-06-29 22:16:49'),(358,7479,2,40719,40758,13,23,1,0,'2023-06-15','2023-06-15',4000.00,1,1.00,'Factura C N°: 0001-00000358',NULL,'2023-06-29 21:50:05','2023-06-29 22:16:46','2023-06-29 22:16:46'),(359,7479,2,40719,40729,13,23,1,0,'2023-06-15','2023-06-15',3500.00,1,1.00,'Factura C N°: 0001-00000359',NULL,'2023-06-29 21:50:05','2023-06-29 22:16:42','2023-06-29 22:16:42'),(360,7479,2,40719,40742,13,23,1,0,'2023-06-15','2023-06-15',9500.00,1,1.00,'Factura C N°: 0001-00000360',NULL,'2023-06-29 21:50:05','2023-06-29 22:16:39','2023-06-29 22:16:39'),(361,7479,2,40719,40727,13,23,1,0,'2023-06-16','2023-06-16',3500.00,1,1.00,'Factura C N°: 0001-00000361',NULL,'2023-06-29 21:50:05','2023-06-29 22:16:34','2023-06-29 22:16:34'),(362,7479,2,40719,40759,13,23,1,0,'2023-06-18','2023-06-18',10000.00,1,1.00,'Factura C N°: 0001-00000362',NULL,'2023-06-29 21:50:06','2023-06-29 22:00:49','2023-06-29 22:00:49'),(363,7479,2,40719,40722,13,23,1,0,'2023-06-20','2023-06-20',3500.00,1,1.00,'Factura C N°: 0001-00000363',NULL,'2023-06-29 21:50:06','2023-06-29 22:16:28','2023-06-29 22:16:28'),(364,7479,2,40719,40738,13,23,1,0,'2023-06-22','2023-06-22',3500.00,1,1.00,'Factura C N°: 0001-00000364',NULL,'2023-06-29 21:50:06','2023-06-29 22:16:24','2023-06-29 22:16:24'),(365,7479,2,40719,40736,13,23,1,0,'2023-06-22','2023-06-22',3500.00,1,1.00,'Factura C N°: 0001-00000365',NULL,'2023-06-29 21:50:06','2023-06-29 22:16:20','2023-06-29 22:16:20'),(366,7479,2,40719,40760,13,23,1,0,'2023-06-23','2023-06-23',48000.00,1,1.00,'Factura C N°: 0001-00000366',NULL,'2023-06-29 21:50:06','2023-06-29 22:16:13','2023-06-29 22:16:13'),(367,7479,2,40719,40747,13,23,1,0,'2023-06-24','2023-06-24',3500.00,1,1.00,'Factura C N°: 0001-00000367',NULL,'2023-06-29 21:50:06','2023-06-29 22:16:09','2023-06-29 22:16:09'),(368,7479,2,40719,40761,13,23,1,0,'2023-06-26','2023-06-26',35000.00,1,1.00,'Factura C N°: 0001-00000368',NULL,'2023-06-29 21:50:06','2023-06-29 22:16:06','2023-06-29 22:16:06'),(369,7479,2,40719,40762,13,23,1,0,'2023-06-29','2023-06-29',3500.00,1,1.00,'Factura C N°: 0001-00000369',NULL,'2023-06-29 21:50:06','2023-06-29 22:16:02','2023-06-29 22:16:02'),(370,7479,2,40719,40763,13,23,1,0,'2023-06-29','2023-06-29',4000.00,1,1.00,'Factura C N°: 0001-00000370',NULL,'2023-06-29 21:50:06','2023-06-29 22:16:17','2023-06-29 22:16:17'),(371,7479,2,40719,40759,13,23,1,0,'2023-06-18','2023-06-18',10000.00,1,1.00,'Factura C N°: 0001-00000362',NULL,'2023-06-29 22:00:49','2023-06-29 22:16:31','2023-06-29 22:16:31');
/*!40000 ALTER TABLE `cta_cte_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_details`
--

DROP TABLE IF EXISTS `cta_cte_cliente_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_details_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_cliente_details_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_details_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_details_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_details_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_details`
--

LOCK TABLES `cta_cte_cliente_details` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_pivot_receipt`
--

DROP TABLE IF EXISTS `cta_cte_cliente_pivot_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_pivot_receipt` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `receipt_id` int(11) DEFAULT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=372 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_pivot_receipt`
--

LOCK TABLES `cta_cte_cliente_pivot_receipt` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (1,7479,1,1,NULL,'2022-07-29 19:26:36','2022-07-29 20:20:19','2022-07-29 20:20:19'),(2,7479,2,2,NULL,'2022-07-29 19:26:36','2022-07-29 20:20:06','2022-07-29 20:20:06'),(3,7479,3,3,NULL,'2022-07-29 19:26:36','2022-07-29 20:19:55','2022-07-29 20:19:55'),(4,7479,4,4,NULL,'2022-07-29 19:26:36','2022-07-29 20:19:36','2022-07-29 20:19:36'),(5,7479,5,5,NULL,'2022-07-29 19:28:35','2022-07-29 19:28:35',NULL),(6,7479,6,6,NULL,'2022-07-29 19:28:35','2022-07-29 19:28:35',NULL),(7,7479,7,4,NULL,'2022-07-29 20:19:36','2022-07-29 20:19:36',NULL),(8,7479,8,3,NULL,'2022-07-29 20:19:55','2022-07-29 20:19:55',NULL),(9,7479,9,2,NULL,'2022-07-29 20:20:06','2022-07-29 20:20:06',NULL),(10,7479,10,1,NULL,'2022-07-29 20:20:19','2022-07-29 20:20:19',NULL),(11,7479,11,7,NULL,'2022-07-29 22:54:43','2022-07-29 22:54:43',NULL),(12,7479,12,8,NULL,'2022-07-29 22:54:43','2022-07-29 22:54:43',NULL),(13,7479,13,9,NULL,'2022-07-29 22:54:43','2022-07-29 22:54:43',NULL),(14,7479,14,10,NULL,'2022-07-29 22:54:43','2022-07-29 22:54:43',NULL),(15,7479,15,11,NULL,'2022-07-29 22:54:43','2022-07-29 22:54:43',NULL),(16,7479,16,12,NULL,'2022-07-29 22:54:43','2022-07-29 22:55:57','2022-07-29 22:55:57'),(17,7479,17,13,NULL,'2022-07-29 22:54:43','2022-07-29 22:54:43',NULL),(18,7479,18,14,NULL,'2022-07-29 22:54:43','2022-07-29 22:54:43',NULL),(19,7479,19,15,NULL,'2022-07-29 22:54:43','2022-07-29 22:54:43',NULL),(20,7479,20,16,NULL,'2022-07-29 22:54:43','2022-07-29 22:54:43',NULL),(21,7479,21,17,NULL,'2022-07-29 22:54:43','2022-07-29 22:54:43',NULL),(22,7479,22,18,NULL,'2022-07-29 22:54:43','2022-07-29 22:54:43',NULL),(23,7479,23,19,NULL,'2022-07-29 22:54:43','2022-07-29 22:54:43',NULL),(24,7479,24,12,NULL,'2022-07-29 22:55:57','2022-07-29 22:55:57',NULL),(25,7479,25,22,NULL,'2022-07-30 11:23:29','2022-07-30 11:23:29',NULL),(26,7479,26,23,NULL,'2022-07-30 11:23:29','2022-07-30 11:23:29',NULL),(27,7479,27,24,NULL,'2022-07-30 11:23:29','2022-07-30 11:23:29',NULL),(28,7479,28,25,NULL,'2022-07-30 11:23:29','2022-07-30 11:26:42','2022-07-30 11:26:42'),(29,7479,29,26,NULL,'2022-07-30 11:23:29','2022-07-30 11:23:29',NULL),(30,7479,30,27,NULL,'2022-07-30 11:23:29','2022-07-30 11:26:16','2022-07-30 11:26:16'),(31,7479,31,28,NULL,'2022-07-30 11:23:29','2022-07-30 11:23:29',NULL),(32,7479,32,29,NULL,'2022-07-30 11:23:29','2022-07-30 11:23:29',NULL),(33,7479,33,30,NULL,'2022-07-30 11:23:29','2022-07-30 11:23:29',NULL),(34,7479,34,31,NULL,'2022-07-30 11:23:29','2022-07-30 11:23:29',NULL),(35,7479,35,32,NULL,'2022-07-30 11:23:29','2022-07-30 11:23:29',NULL),(36,7479,36,33,NULL,'2022-07-30 11:23:29','2022-07-30 11:23:29',NULL),(37,7479,37,34,NULL,'2022-07-30 11:23:29','2022-07-30 11:23:29',NULL),(38,7479,38,35,NULL,'2022-07-30 11:23:49','2022-07-30 11:23:49',NULL),(39,7479,39,27,NULL,'2022-07-30 11:26:16','2022-07-30 11:26:16',NULL),(40,7479,40,25,NULL,'2022-07-30 11:26:42','2022-07-30 11:26:42',NULL),(41,7479,41,36,NULL,'2022-07-30 12:20:39','2022-07-30 12:20:39',NULL),(42,7479,42,37,NULL,'2022-07-30 12:20:39','2022-07-30 12:20:39',NULL),(43,7479,43,38,NULL,'2022-07-30 12:20:39','2022-07-30 12:20:39',NULL),(44,7479,44,39,NULL,'2022-07-30 12:20:40','2022-07-30 12:20:40',NULL),(45,7479,45,40,NULL,'2022-07-30 12:20:40','2022-07-30 12:20:40',NULL),(46,7479,46,41,NULL,'2022-07-30 12:20:40','2022-07-30 12:20:40',NULL),(47,7479,47,42,NULL,'2022-07-30 12:20:40','2022-07-30 12:20:40',NULL),(48,7479,48,43,NULL,'2022-07-30 12:20:40','2022-07-30 12:20:40',NULL),(49,7479,49,44,NULL,'2022-07-30 12:20:40','2022-07-30 12:20:40',NULL),(50,7479,50,45,NULL,'2022-07-30 12:20:40','2022-07-30 12:20:40',NULL),(51,7479,51,46,NULL,'2022-07-30 12:20:40','2022-07-30 12:20:40',NULL),(52,7479,52,47,NULL,'2022-07-30 12:20:40','2022-07-30 12:20:40',NULL),(53,7479,53,48,NULL,'2022-07-30 12:20:40','2022-07-30 12:20:40',NULL),(54,7479,54,49,NULL,'2022-07-30 12:20:40','2022-07-30 12:20:40',NULL),(55,7479,55,50,NULL,'2022-07-30 12:20:40','2022-07-30 12:20:40',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (56,7479,56,51,NULL,'2022-07-30 12:20:40','2022-07-30 12:20:40',NULL),(57,7479,57,52,NULL,'2022-07-30 12:20:40','2022-07-30 12:20:40',NULL),(58,7479,58,53,NULL,'2022-07-30 12:31:18','2022-07-30 12:31:18',NULL),(59,7479,59,54,NULL,'2022-07-30 12:31:18','2022-07-30 12:31:18',NULL),(60,7479,60,55,NULL,'2022-07-30 12:31:18','2022-07-30 12:31:18',NULL),(61,7479,61,56,NULL,'2022-07-30 12:31:18','2022-07-30 12:31:18',NULL),(62,7479,62,57,NULL,'2022-07-30 12:31:18','2022-07-30 12:31:18',NULL),(63,7479,63,58,NULL,'2022-07-30 12:31:18','2022-07-30 12:31:18',NULL),(64,7479,64,59,NULL,'2022-07-30 12:31:18','2022-07-30 12:31:18',NULL),(65,7479,65,60,NULL,'2022-07-30 12:31:18','2022-07-30 12:31:18',NULL),(66,7479,66,61,NULL,'2022-07-30 12:31:18','2022-07-30 12:31:18',NULL),(67,7479,67,62,NULL,'2022-07-30 12:31:18','2022-07-30 12:31:18',NULL),(68,7479,68,63,NULL,'2022-07-30 12:31:18','2022-07-30 12:31:18',NULL),(69,7479,69,64,NULL,'2022-07-30 12:31:18','2022-07-30 12:31:18',NULL),(70,7479,70,65,NULL,'2022-07-30 12:31:18','2022-07-30 12:31:18',NULL),(71,7479,71,66,NULL,'2022-07-30 12:31:18','2022-07-30 12:31:18',NULL),(72,7479,72,67,NULL,'2022-07-30 12:31:18','2022-07-30 12:31:18',NULL),(73,7479,73,68,NULL,'2022-07-30 12:31:18','2022-07-30 12:31:18',NULL),(74,7479,74,69,NULL,'2022-07-30 12:31:18','2022-07-30 12:31:18',NULL),(75,7479,75,70,NULL,'2022-07-30 13:09:53','2022-07-30 13:09:53',NULL),(76,7479,76,71,NULL,'2022-07-30 13:09:53','2022-07-30 13:09:53',NULL),(77,7479,77,72,NULL,'2022-07-30 13:09:53','2022-07-30 13:09:53',NULL),(78,7479,78,73,NULL,'2022-07-30 13:09:53','2022-07-30 13:09:53',NULL),(79,7479,79,74,NULL,'2022-07-30 13:09:53','2022-07-30 13:09:53',NULL),(80,7479,80,75,NULL,'2022-07-30 13:09:53','2022-07-30 13:09:53',NULL),(81,7479,81,76,NULL,'2022-07-30 13:09:54','2022-07-30 13:09:54',NULL),(82,7479,82,77,NULL,'2022-07-30 13:09:54','2022-07-30 13:09:54',NULL),(83,7479,83,78,NULL,'2022-07-30 13:09:54','2022-07-30 13:09:54',NULL),(84,7479,84,79,NULL,'2022-07-30 13:09:54','2022-07-30 13:09:54',NULL),(85,7479,85,80,NULL,'2022-07-30 13:09:54','2022-07-30 13:09:54',NULL),(86,7479,86,81,NULL,'2022-07-30 13:09:54','2022-07-30 13:09:54',NULL),(87,7479,87,82,NULL,'2022-07-30 13:09:54','2022-07-30 13:09:54',NULL),(88,7479,88,83,NULL,'2022-07-30 13:30:31','2022-07-30 13:30:31',NULL),(89,7479,89,84,NULL,'2022-07-30 13:30:31','2022-07-30 13:30:31',NULL),(90,7479,90,85,NULL,'2022-07-30 13:30:31','2022-07-30 13:30:31',NULL),(91,7479,91,86,NULL,'2022-07-30 13:30:31','2022-07-30 13:30:31',NULL),(92,7479,92,87,NULL,'2022-07-30 13:30:31','2022-07-30 13:30:31',NULL),(93,7479,93,88,NULL,'2022-07-30 13:30:31','2022-07-30 13:30:31',NULL),(94,7479,94,89,NULL,'2022-07-30 13:30:31','2022-07-30 13:30:31',NULL),(95,7479,95,90,NULL,'2022-07-30 13:30:31','2022-07-30 13:30:31',NULL),(96,7479,96,91,NULL,'2022-07-30 13:30:32','2022-07-30 13:30:32',NULL),(97,7479,97,92,NULL,'2022-07-30 13:30:32','2022-07-30 13:30:32',NULL),(98,7479,98,93,NULL,'2022-07-30 13:30:32','2022-07-30 13:30:32',NULL),(99,7479,99,94,NULL,'2022-07-30 13:30:32','2022-07-30 13:30:32',NULL),(100,7479,100,95,NULL,'2022-07-30 13:30:32','2022-07-30 13:30:32',NULL),(101,7479,101,96,NULL,'2022-07-30 13:30:46','2022-07-30 13:30:46',NULL),(102,7479,102,97,NULL,'2022-07-30 13:35:51','2022-07-30 13:35:51',NULL),(103,7479,103,98,NULL,'2022-07-30 13:35:51','2022-07-30 13:35:51',NULL),(104,7479,104,99,NULL,'2022-07-30 13:35:51','2022-07-30 13:35:51',NULL),(105,7479,105,100,NULL,'2022-07-30 13:35:51','2022-07-30 13:35:51',NULL),(106,7479,106,101,NULL,'2022-07-30 13:35:51','2022-07-30 13:35:51',NULL),(107,7479,107,102,NULL,'2022-07-30 13:35:51','2022-07-30 13:35:51',NULL),(108,7479,108,103,NULL,'2022-07-30 13:35:51','2022-07-30 13:35:51',NULL),(109,7479,109,104,NULL,'2022-07-30 13:35:51','2022-07-30 13:35:51',NULL),(110,7479,110,105,NULL,'2022-07-30 13:35:51','2022-07-30 13:35:51',NULL),(111,7479,111,106,NULL,'2022-07-30 13:35:51','2022-07-30 13:35:51',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (112,7479,112,107,NULL,'2022-07-30 13:35:51','2022-07-30 13:35:51',NULL),(113,7479,113,108,NULL,'2022-07-30 13:35:51','2022-07-30 13:35:51',NULL),(114,7479,114,109,NULL,'2022-07-30 13:35:51','2022-07-30 13:42:12','2022-07-30 13:42:12'),(115,7479,115,109,NULL,'2022-07-30 13:42:12','2022-07-30 13:42:12',NULL),(116,7479,116,110,NULL,'2022-07-30 13:48:32','2022-07-30 13:48:32',NULL),(117,7479,117,111,NULL,'2022-07-30 13:48:32','2022-07-30 13:48:32',NULL),(118,7479,118,112,NULL,'2022-07-30 13:48:32','2022-07-30 13:48:32',NULL),(119,7479,119,113,NULL,'2022-07-30 13:48:32','2022-07-30 14:03:39','2022-07-30 14:03:39'),(120,7479,120,114,NULL,'2022-07-30 13:48:32','2022-07-30 13:48:32',NULL),(121,7479,121,115,NULL,'2022-07-30 13:48:32','2022-07-30 14:03:18','2022-07-30 14:03:18'),(122,7479,122,116,NULL,'2022-07-30 13:48:32','2022-07-30 13:48:32',NULL),(123,7479,123,117,NULL,'2022-07-30 13:48:32','2022-07-30 13:48:32',NULL),(124,7479,124,118,NULL,'2022-07-30 13:48:32','2022-07-30 13:48:32',NULL),(125,7479,125,119,NULL,'2022-07-30 13:48:32','2022-07-30 13:48:32',NULL),(126,7479,126,120,NULL,'2022-07-30 13:48:32','2022-07-30 13:48:32',NULL),(127,7479,127,121,NULL,'2022-07-30 13:48:32','2022-07-30 13:48:32',NULL),(128,7479,128,122,NULL,'2022-07-30 13:48:32','2022-07-30 13:48:32',NULL),(129,7479,129,115,NULL,'2022-07-30 14:03:18','2022-07-30 14:03:18',NULL),(130,7479,130,113,NULL,'2022-07-30 14:03:39','2022-07-30 14:03:39',NULL),(131,7479,131,123,NULL,'2022-07-30 14:16:39','2022-07-30 14:16:39',NULL),(132,7479,132,124,NULL,'2022-07-30 14:16:39','2022-07-30 14:16:39',NULL),(133,7479,133,125,NULL,'2022-07-30 14:16:39','2022-07-30 14:16:39',NULL),(134,7479,134,126,NULL,'2022-07-30 14:16:39','2022-07-30 14:16:39',NULL),(135,7479,135,127,NULL,'2022-07-30 14:16:39','2022-07-30 14:16:39',NULL),(136,7479,136,128,NULL,'2022-07-30 14:16:39','2022-07-30 14:16:39',NULL),(137,7479,137,129,NULL,'2022-07-30 14:16:39','2022-07-30 14:16:39',NULL),(138,7479,138,130,NULL,'2022-07-30 14:16:39','2022-07-30 14:16:39',NULL),(139,7479,139,131,NULL,'2022-07-30 14:16:39','2022-07-30 14:16:39',NULL),(140,7479,140,132,NULL,'2022-07-30 14:16:39','2022-07-30 14:16:39',NULL),(141,7479,141,133,NULL,'2022-07-30 14:16:39','2022-07-30 14:16:39',NULL),(142,7479,142,134,NULL,'2022-07-30 14:16:39','2022-07-30 14:16:39',NULL),(143,7479,143,135,NULL,'2022-07-30 14:16:39','2022-07-30 14:16:39',NULL),(144,7479,144,136,NULL,'2022-07-30 14:16:39','2022-07-30 14:16:39',NULL),(145,7479,145,137,NULL,'2022-07-30 14:16:39','2022-07-30 14:16:39',NULL),(146,7479,146,138,NULL,'2022-07-30 14:16:39','2022-07-30 14:16:39',NULL),(147,7479,147,139,NULL,'2022-07-30 14:16:39','2022-07-30 14:16:39',NULL),(148,7479,148,140,NULL,'2022-07-30 14:18:56','2022-07-30 14:18:56',NULL),(149,7479,149,141,NULL,'2022-07-30 14:18:56','2022-07-30 14:18:56',NULL),(150,7479,150,142,NULL,'2022-07-30 14:18:56','2022-07-30 14:18:56',NULL),(151,7479,151,143,NULL,'2022-07-30 14:18:56','2022-07-30 14:18:56',NULL),(152,7479,152,144,NULL,'2022-07-30 14:18:56','2022-07-30 14:18:56',NULL),(153,7479,153,145,NULL,'2022-07-30 14:18:56','2022-07-30 14:18:56',NULL),(154,7479,154,146,NULL,'2022-07-30 14:18:56','2022-07-30 14:18:56',NULL),(155,7479,155,147,NULL,'2022-07-30 14:18:56','2022-07-30 14:18:56',NULL),(156,7479,156,148,NULL,'2022-07-30 14:18:56','2022-07-30 14:18:56',NULL),(157,7479,157,149,NULL,'2022-07-30 14:18:56','2022-07-30 14:18:56',NULL),(158,7479,158,150,NULL,'2022-07-30 14:18:56','2022-07-30 14:18:56',NULL),(159,7479,159,151,NULL,'2022-07-30 14:18:56','2022-07-30 14:18:56',NULL),(160,7479,160,152,NULL,'2022-07-30 14:18:57','2022-07-30 14:18:57',NULL),(161,7479,161,153,NULL,'2022-07-30 14:18:57','2022-07-30 14:18:57',NULL),(162,7479,162,154,NULL,'2022-07-30 14:18:57','2022-07-30 14:18:57',NULL),(163,7479,163,155,NULL,'2022-07-30 14:18:57','2022-07-30 14:18:57',NULL),(164,7479,164,156,NULL,'2022-07-30 14:18:57','2022-07-30 14:18:57',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (165,7479,165,157,NULL,'2022-07-30 14:28:08','2022-07-30 14:28:08',NULL),(166,7479,166,158,NULL,'2022-07-30 14:28:08','2022-07-30 14:28:08',NULL),(167,7479,167,159,NULL,'2022-07-30 14:28:09','2022-07-30 14:28:09',NULL),(168,7479,168,160,NULL,'2022-07-30 14:28:09','2022-07-30 14:28:09',NULL),(169,7479,169,161,NULL,'2022-07-30 14:28:09','2022-07-30 14:28:09',NULL),(170,7479,170,162,NULL,'2022-07-30 14:28:09','2022-07-30 14:28:09',NULL),(171,7479,171,163,NULL,'2022-07-30 14:28:09','2022-07-30 14:28:09',NULL),(172,7479,172,164,NULL,'2022-07-30 14:28:09','2022-07-30 14:28:09',NULL),(173,7479,173,165,NULL,'2022-07-30 14:28:09','2022-07-30 14:28:09',NULL),(174,7479,174,166,NULL,'2022-07-30 14:28:09','2022-07-30 14:28:09',NULL),(175,7479,175,167,NULL,'2022-07-30 14:28:09','2022-07-30 14:28:09',NULL),(176,7479,176,168,NULL,'2022-07-30 14:28:09','2022-07-30 14:28:09',NULL),(177,7479,177,169,NULL,'2022-07-30 14:28:09','2022-07-30 14:28:09',NULL),(178,7479,178,170,NULL,'2022-07-30 14:28:09','2022-07-30 14:28:09',NULL),(179,7479,179,171,NULL,'2022-07-30 14:28:09','2022-07-30 14:28:09',NULL),(180,7479,180,172,NULL,'2022-07-30 14:28:09','2022-07-30 14:28:09',NULL),(181,7479,181,173,NULL,'2022-07-30 14:28:09','2022-07-30 14:28:09',NULL),(182,7479,182,174,NULL,'2022-07-30 15:51:22','2022-07-30 15:51:22',NULL),(183,7479,183,175,NULL,'2022-07-30 15:51:22','2022-07-30 15:53:14','2022-07-30 15:53:14'),(184,7479,184,176,NULL,'2022-07-30 15:51:22','2022-07-30 15:51:22',NULL),(185,7479,185,177,NULL,'2022-07-30 15:51:22','2022-07-30 15:51:22',NULL),(186,7479,186,178,NULL,'2022-07-30 15:51:22','2022-07-30 15:51:22',NULL),(187,7479,187,179,NULL,'2022-07-30 15:51:22','2022-07-30 15:51:22',NULL),(188,7479,188,180,NULL,'2022-07-30 15:51:22','2022-07-30 15:51:22',NULL),(189,7479,189,181,NULL,'2022-07-30 15:51:22','2022-07-30 15:51:22',NULL),(190,7479,190,182,NULL,'2022-07-30 15:51:22','2022-07-30 15:51:22',NULL),(191,7479,191,183,NULL,'2022-07-30 15:51:22','2022-07-30 15:51:22',NULL),(192,7479,192,184,NULL,'2022-07-30 15:51:22','2022-07-30 15:51:22',NULL),(193,7479,193,185,NULL,'2022-07-30 15:51:22','2022-07-30 15:51:22',NULL),(194,7479,194,186,NULL,'2022-07-30 15:51:22','2022-07-30 15:51:22',NULL),(195,7479,195,187,NULL,'2022-07-30 15:51:22','2022-07-30 15:51:22',NULL),(196,7479,196,188,NULL,'2022-07-30 15:51:22','2022-07-30 15:51:22',NULL),(197,7479,197,189,NULL,'2022-07-30 15:51:22','2022-07-30 15:51:22',NULL),(198,7479,198,190,NULL,'2022-07-30 15:51:22','2022-07-30 15:51:22',NULL),(199,7479,199,175,NULL,'2022-07-30 15:53:14','2022-07-30 15:53:14',NULL),(200,7479,200,191,NULL,'2022-07-30 16:00:49','2022-07-30 16:00:49',NULL),(201,7479,201,192,NULL,'2022-07-30 16:00:49','2022-07-30 16:00:49',NULL),(202,7479,202,193,NULL,'2022-07-30 16:00:49','2022-07-30 16:00:49',NULL),(203,7479,203,194,NULL,'2022-07-30 16:00:49','2022-07-30 16:00:49',NULL),(204,7479,204,195,NULL,'2022-07-30 16:00:49','2022-07-30 16:00:49',NULL),(205,7479,205,196,NULL,'2022-07-30 16:00:49','2022-07-30 16:00:49',NULL),(206,7479,206,197,NULL,'2022-07-30 16:00:49','2022-07-30 16:00:49',NULL),(207,7479,207,198,NULL,'2022-07-30 16:00:49','2022-07-30 16:00:49',NULL),(208,7479,208,199,NULL,'2022-07-30 16:00:49','2022-07-30 16:00:49',NULL),(209,7479,209,200,NULL,'2022-07-30 16:00:49','2022-07-30 16:00:49',NULL),(210,7479,210,201,NULL,'2022-07-30 16:00:49','2022-07-30 16:00:49',NULL),(211,7479,211,202,NULL,'2022-07-30 16:00:49','2022-07-30 16:00:49',NULL),(212,7479,212,203,NULL,'2022-07-30 16:00:49','2022-07-30 16:00:49',NULL),(213,7479,213,204,NULL,'2022-07-30 16:00:49','2022-07-30 16:00:49',NULL),(214,7479,214,205,NULL,'2022-07-30 16:00:50','2022-07-30 16:00:50',NULL),(215,7479,215,206,NULL,'2022-07-30 16:00:50','2022-07-30 16:00:50',NULL),(216,7479,216,207,NULL,'2022-07-30 16:00:50','2022-07-30 16:00:50',NULL),(217,7479,217,208,NULL,'2022-07-30 16:09:42','2022-07-30 16:09:42',NULL),(218,7479,218,209,NULL,'2022-07-30 16:09:42','2022-07-30 16:09:42',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (219,7479,219,210,NULL,'2022-07-30 16:09:42','2022-07-30 16:09:42',NULL),(220,7479,220,211,NULL,'2022-07-30 16:09:42','2022-07-30 16:09:42',NULL),(221,7479,221,212,NULL,'2022-07-30 16:09:42','2022-07-30 16:09:42',NULL),(222,7479,222,213,NULL,'2022-07-30 16:09:42','2022-07-30 16:09:42',NULL),(223,7479,223,214,NULL,'2022-07-30 16:09:42','2022-07-30 16:09:42',NULL),(224,7479,224,215,NULL,'2022-07-30 16:09:42','2022-07-30 16:09:42',NULL),(225,7479,225,216,NULL,'2022-07-30 16:09:42','2022-07-30 16:09:42',NULL),(226,7479,226,217,NULL,'2022-07-30 16:09:42','2022-07-30 16:09:42',NULL),(227,7479,227,218,NULL,'2022-07-30 16:09:42','2022-07-30 16:09:42',NULL),(228,7479,228,219,NULL,'2022-07-30 16:09:42','2022-07-30 16:09:42',NULL),(229,7479,229,220,NULL,'2022-07-30 16:09:42','2022-07-30 16:09:42',NULL),(230,7479,230,221,NULL,'2022-07-30 16:09:42','2022-07-30 16:09:42',NULL),(231,7479,231,222,NULL,'2022-07-30 16:09:43','2022-07-30 16:09:43',NULL),(232,7479,232,223,NULL,'2022-07-30 16:09:43','2022-07-30 16:09:43',NULL),(233,7479,233,224,NULL,'2022-07-30 16:09:43','2022-07-30 16:09:43',NULL),(234,7479,234,225,NULL,'2022-07-30 16:29:21','2022-07-30 16:29:21',NULL),(235,7479,235,226,NULL,'2022-07-30 16:29:21','2022-07-30 16:29:21',NULL),(236,7479,236,227,NULL,'2022-07-30 16:29:21','2022-07-30 16:29:21',NULL),(237,7479,237,228,NULL,'2022-07-30 16:29:21','2022-07-30 16:29:21',NULL),(238,7479,238,229,NULL,'2022-07-30 16:33:51','2022-07-30 16:33:51',NULL),(239,7479,239,230,NULL,'2022-07-30 16:33:51','2022-07-30 16:33:51',NULL),(240,7479,240,231,NULL,'2022-07-30 16:33:51','2022-07-30 16:33:51',NULL),(241,7479,241,232,NULL,'2022-07-30 16:33:51','2022-07-30 16:33:51',NULL),(242,7479,242,233,NULL,'2022-07-30 16:33:51','2022-07-30 16:33:51',NULL),(243,7479,243,234,NULL,'2022-07-30 17:23:53','2022-07-30 17:23:53',NULL),(244,7479,244,235,NULL,'2022-07-30 17:23:53','2022-07-30 17:23:53',NULL),(245,7479,245,236,NULL,'2022-07-30 17:23:53','2022-07-30 17:23:53',NULL),(246,7479,246,237,NULL,'2022-07-30 17:23:53','2022-07-30 17:23:53',NULL),(247,7479,247,238,NULL,'2022-07-30 17:23:53','2022-07-30 17:23:53',NULL),(248,7479,248,239,NULL,'2022-07-30 17:28:26','2022-07-30 17:28:26',NULL),(249,7479,249,240,NULL,'2022-07-30 17:28:26','2022-07-30 17:28:26',NULL),(250,7479,250,241,NULL,'2022-07-30 17:28:26','2022-07-30 17:28:26',NULL),(251,7479,251,242,NULL,'2022-07-30 17:28:26','2022-07-30 17:28:26',NULL),(252,7479,252,243,NULL,'2022-07-30 17:28:26','2022-07-30 17:28:26',NULL),(253,7479,253,244,NULL,'2022-07-30 18:59:21','2022-07-30 18:59:21',NULL),(254,7479,254,245,NULL,'2022-07-30 18:59:21','2022-07-30 18:59:21',NULL),(255,7479,255,246,NULL,'2022-07-30 18:59:21','2022-07-30 18:59:21',NULL),(256,7479,256,247,NULL,'2022-07-30 18:59:21','2022-07-30 18:59:21',NULL),(257,7479,257,248,NULL,'2022-07-30 18:59:21','2022-07-30 18:59:21',NULL),(258,7479,258,249,NULL,'2022-07-30 19:15:16','2022-08-01 18:59:34','2022-08-01 18:59:34'),(259,7479,259,250,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(260,7479,260,251,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(261,7479,261,252,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(262,7479,262,253,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(263,7479,263,254,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(264,7479,264,255,NULL,'2022-07-30 19:15:28','2022-07-30 19:15:28',NULL),(265,7479,265,249,NULL,'2022-08-01 18:59:34','2022-08-01 18:59:34',NULL),(266,7479,266,256,NULL,'2022-08-01 19:57:38','2022-08-01 19:57:38',NULL),(267,7479,267,257,NULL,'2022-08-01 20:03:12','2022-08-01 20:03:12',NULL),(268,7479,268,258,NULL,'2022-08-01 20:25:12','2022-08-01 20:25:52','2022-08-01 20:25:52'),(269,7479,269,258,NULL,'2022-08-01 20:25:52','2022-08-01 20:26:48','2022-08-01 20:26:48'),(270,7479,270,258,NULL,'2022-08-01 20:26:48','2022-08-01 20:26:56','2022-08-01 20:26:56'),(271,7479,271,258,NULL,'2022-08-01 20:26:56','2022-08-01 20:27:34','2022-08-01 20:27:34');
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (272,7479,272,258,NULL,'2022-08-01 20:27:34','2022-08-01 20:27:34',NULL),(273,7479,273,259,NULL,'2022-08-02 18:31:06','2022-08-02 18:31:06',NULL),(274,7479,274,261,NULL,'2022-08-02 18:46:50','2022-08-02 18:46:50',NULL),(275,7479,275,262,NULL,'2022-08-02 18:56:19','2022-08-02 18:56:19',NULL),(276,7479,276,263,NULL,'2022-08-02 18:56:19','2022-08-02 18:56:19',NULL),(277,7479,277,264,NULL,'2022-08-02 19:01:50','2022-08-02 19:01:50',NULL),(278,7479,278,265,NULL,'2022-08-02 19:01:50','2022-08-02 19:01:50',NULL),(279,7479,279,266,NULL,'2022-08-02 19:01:50','2022-08-02 19:01:50',NULL),(280,7479,280,267,NULL,'2022-08-02 19:01:50','2022-08-02 19:01:50',NULL),(281,7479,281,268,NULL,'2022-08-02 19:01:50','2022-08-02 19:01:50',NULL),(282,7479,282,269,NULL,'2022-08-02 19:01:50','2022-08-02 19:01:50',NULL),(283,7479,283,270,NULL,'2022-08-02 19:01:50','2022-08-02 19:01:50',NULL),(284,7479,284,271,NULL,'2022-08-02 19:01:50','2022-08-02 19:01:50',NULL),(285,7479,285,272,NULL,'2022-08-02 19:01:50','2022-08-02 19:01:50',NULL),(286,7479,286,273,NULL,'2022-08-02 19:01:50','2022-08-02 19:01:50',NULL),(287,7479,287,274,NULL,'2022-08-02 19:01:50','2022-08-02 19:01:50',NULL),(288,7479,288,275,NULL,'2022-08-02 19:01:50','2022-08-02 19:01:50',NULL),(289,7479,289,276,NULL,'2022-08-02 19:01:50','2022-08-02 19:01:50',NULL),(290,7479,290,277,NULL,'2022-08-02 19:01:50','2022-08-02 19:01:50',NULL),(291,7479,291,278,NULL,'2022-08-02 19:01:50','2022-08-02 19:01:50',NULL),(292,7479,292,279,NULL,'2022-08-02 19:01:50','2022-08-02 19:01:50',NULL),(293,7479,293,280,NULL,'2022-08-02 19:01:50','2022-08-02 19:01:50',NULL),(294,7479,294,281,NULL,'2022-08-02 20:20:13','2022-08-02 20:20:13',NULL),(295,7479,295,282,NULL,'2022-08-02 20:20:13','2022-08-02 20:20:13',NULL),(296,7479,296,283,NULL,'2022-08-02 20:20:13','2022-08-02 20:20:13',NULL),(297,7479,297,284,NULL,'2022-08-02 20:20:13','2022-08-02 20:20:13',NULL),(298,7479,298,289,NULL,'2022-08-04 21:54:19','2022-08-04 21:54:19',NULL),(299,7479,299,290,NULL,'2022-08-04 22:01:23','2022-08-04 22:01:23',NULL),(300,7479,300,292,NULL,'2022-08-06 11:10:13','2022-08-06 11:10:13',NULL),(301,7479,301,293,NULL,'2022-08-06 11:26:42','2022-08-06 11:26:42',NULL),(302,7479,302,294,NULL,'2022-08-11 18:14:44','2022-08-11 18:14:44',NULL),(303,7479,303,295,NULL,'2022-08-11 18:14:44','2022-08-11 18:14:44',NULL),(304,7479,304,296,NULL,'2022-08-11 18:14:44','2022-08-11 18:14:44',NULL),(305,7479,305,297,NULL,'2022-08-11 18:14:44','2022-08-11 18:14:44',NULL),(306,7479,306,298,NULL,'2022-08-11 18:14:44','2022-08-11 18:14:44',NULL),(307,7479,307,299,NULL,'2022-08-11 18:14:44','2022-08-11 18:14:44',NULL),(308,7479,308,300,NULL,'2022-08-11 18:14:44','2022-08-11 18:14:44',NULL),(309,7479,309,301,NULL,'2022-08-11 18:14:44','2022-08-11 18:14:44',NULL),(310,7479,310,302,NULL,'2022-08-11 18:14:45','2022-08-11 18:14:45',NULL),(311,7479,311,303,NULL,'2022-08-11 18:14:45','2022-08-11 18:14:45',NULL),(312,7479,312,304,NULL,'2022-08-11 18:14:45','2022-08-11 18:14:45',NULL),(313,7479,313,305,NULL,'2022-08-11 18:14:45','2022-08-11 18:14:45',NULL),(314,7479,314,306,NULL,'2022-08-11 18:14:45','2022-08-11 18:14:45',NULL),(315,7479,315,307,NULL,'2022-08-11 18:14:45','2022-08-11 18:14:45',NULL),(316,7479,316,308,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:44','2022-08-11 18:27:44'),(317,7479,317,309,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:36','2022-08-11 18:27:36'),(318,7479,318,310,NULL,'2022-08-11 18:14:45','2022-08-11 18:27:18','2022-08-11 18:27:18'),(319,7479,319,310,NULL,'2022-08-11 18:27:18','2022-08-11 18:27:18',NULL),(320,7479,320,309,NULL,'2022-08-11 18:27:36','2022-08-11 18:27:36',NULL),(321,7479,321,308,NULL,'2022-08-11 18:27:44','2022-08-11 18:27:44',NULL),(322,7479,322,311,NULL,'2022-08-11 18:29:38','2022-08-11 18:29:38',NULL),(323,7479,323,312,NULL,'2022-08-11 18:29:38','2022-08-11 18:29:38',NULL),(324,7479,324,313,NULL,'2022-08-11 18:29:38','2022-08-11 18:29:38',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (325,7479,325,314,NULL,'2022-08-11 18:29:38','2022-08-11 18:29:38',NULL),(326,7479,326,315,NULL,'2022-08-11 18:29:38','2022-08-11 18:29:38',NULL),(327,7479,327,316,NULL,'2022-08-11 18:29:38','2022-08-11 18:29:38',NULL),(328,7479,328,317,NULL,'2022-08-11 18:29:38','2022-08-11 18:29:38',NULL),(329,7479,329,318,NULL,'2022-08-11 18:29:38','2022-08-11 18:29:38',NULL),(330,7479,330,319,NULL,'2022-08-11 18:29:38','2022-08-11 18:29:38',NULL),(331,7479,331,320,NULL,'2022-08-11 18:29:38','2022-08-11 18:29:38',NULL),(332,7479,332,321,NULL,'2022-08-11 18:29:38','2022-08-11 18:29:38',NULL),(333,7479,333,322,NULL,'2022-08-11 18:29:38','2022-08-11 18:29:38',NULL),(334,7479,334,323,NULL,'2022-08-11 18:29:38','2022-08-11 18:29:38',NULL),(335,7479,335,324,NULL,'2022-08-11 18:29:38','2022-08-11 18:29:38',NULL),(336,7479,336,325,NULL,'2022-08-11 18:29:38','2022-08-11 18:29:38',NULL),(337,7479,337,326,NULL,'2022-08-11 18:29:39','2022-08-11 18:29:39',NULL),(338,7479,338,327,NULL,'2022-08-11 18:29:39','2022-08-11 18:29:39',NULL),(339,7479,339,328,NULL,'2022-08-11 18:41:57','2022-08-11 18:41:57',NULL),(340,7479,340,329,NULL,'2022-08-11 19:03:30','2022-08-12 18:44:46','2022-08-12 18:44:46'),(341,7479,341,330,NULL,'2022-08-11 19:03:30','2022-08-12 18:44:37','2022-08-12 18:44:37'),(342,7479,342,331,NULL,'2022-08-11 19:03:30','2022-08-12 18:44:29','2022-08-12 18:44:29'),(343,7479,343,332,NULL,'2022-08-11 19:03:30','2022-08-12 18:44:21','2022-08-12 18:44:21'),(344,7479,344,332,NULL,'2022-08-12 18:44:21','2022-08-12 18:44:21',NULL),(345,7479,345,331,NULL,'2022-08-12 18:44:29','2022-08-12 18:44:29',NULL),(346,7479,346,330,NULL,'2022-08-12 18:44:37','2022-08-12 18:44:37',NULL),(347,7479,347,329,NULL,'2022-08-12 18:44:46','2022-08-12 18:44:46',NULL),(348,7479,348,333,NULL,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(349,7479,349,334,NULL,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(350,7479,350,335,NULL,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(351,7479,351,336,NULL,'2022-08-12 18:46:35','2022-08-12 18:46:35',NULL),(352,7479,352,337,NULL,'2022-08-23 18:35:45','2022-08-23 18:36:27','2022-08-23 18:36:27'),(353,7479,353,337,NULL,'2022-08-23 18:36:27','2022-08-23 18:47:09','2022-08-23 18:47:09'),(354,7479,354,337,NULL,'2022-08-23 18:47:09','2022-08-23 18:47:09',NULL),(355,7479,355,338,NULL,'2023-06-29 21:50:05','2023-06-29 21:50:05',NULL),(356,7479,356,339,NULL,'2023-06-29 21:50:05','2023-06-29 21:50:05',NULL),(357,7479,357,340,NULL,'2023-06-29 21:50:05','2023-06-29 21:50:05',NULL),(358,7479,358,341,NULL,'2023-06-29 21:50:05','2023-06-29 21:50:05',NULL),(359,7479,359,342,NULL,'2023-06-29 21:50:05','2023-06-29 21:50:05',NULL),(360,7479,360,343,NULL,'2023-06-29 21:50:05','2023-06-29 21:50:05',NULL),(361,7479,361,344,NULL,'2023-06-29 21:50:05','2023-06-29 21:50:05',NULL),(362,7479,362,345,NULL,'2023-06-29 21:50:06','2023-06-29 22:00:49','2023-06-29 22:00:49'),(363,7479,363,346,NULL,'2023-06-29 21:50:06','2023-06-29 21:50:06',NULL),(364,7479,364,347,NULL,'2023-06-29 21:50:06','2023-06-29 21:50:06',NULL),(365,7479,365,348,NULL,'2023-06-29 21:50:06','2023-06-29 21:50:06',NULL),(366,7479,366,349,NULL,'2023-06-29 21:50:06','2023-06-29 21:50:06',NULL),(367,7479,367,350,NULL,'2023-06-29 21:50:06','2023-06-29 21:50:06',NULL),(368,7479,368,351,NULL,'2023-06-29 21:50:06','2023-06-29 21:50:06',NULL),(369,7479,369,352,NULL,'2023-06-29 21:50:06','2023-06-29 21:50:06',NULL),(370,7479,370,353,NULL,'2023-06-29 21:50:06','2023-06-29 21:50:06',NULL),(371,7479,371,345,NULL,'2023-06-29 22:00:49','2023-06-29 22:00:49',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `ticket_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `cta_cte_tesoreria_moneda_id_foreign` (`moneda_id`),
  KEY `cta_cte_tesoreria_ticket_id_foreign` (`ticket_id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `cta_cte_tesoreria_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_ticket_id_foreign` FOREIGN KEY (`ticket_id`) REFERENCES `tickets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria`
--

LOCK TABLES `cta_cte_tesoreria` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_cheq`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_cheq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_cheq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `chequera_tipo_id` int(10) unsigned NOT NULL,
  `serie` text COLLATE utf8mb4_unicode_ci,
  `numero_cheque` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_cheq_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` (`cta_cte_tesoreria_banco_id`),
  KEY `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` (`chequera_tipo_id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` FOREIGN KEY (`chequera_tipo_id`) REFERENCES `chequeras_tipos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_cheq`
--

LOCK TABLES `cta_cte_tesoreria_banco_cheq` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_claves`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_claves_person_id_foreign` (`person_id`),
  KEY `ct_cuenta_id` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ct_banco_id` (`cta_cte_tesoreria_banco_id`),
  CONSTRAINT `ct_banco_id` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `ct_cuenta_id` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_claves_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_claves`
--

LOCK TABLES `cta_cte_tesoreria_banco_claves` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_claves` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_bancos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `ctacte_banco_id` int(10) unsigned NOT NULL,
  `persona_empresa` int(11) NOT NULL DEFAULT '1',
  `zone_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id_diferido` int(10) unsigned DEFAULT NULL,
  `cuenta_contable_id_pend_acred` int(10) unsigned DEFAULT NULL,
  `numero_cuenta` text COLLATE utf8mb4_unicode_ci,
  `cbu` text COLLATE utf8mb4_unicode_ci,
  `alias` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_bancos_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` (`ctacte_banco_id`),
  KEY `cta_cte_tesoreria_bancos_zone_id_foreign` (`zone_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` (`cuenta_contable_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` (`cuenta_contable_id_diferido`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` (`cuenta_contable_id_pend_acred`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` FOREIGN KEY (`ctacte_banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` FOREIGN KEY (`cuenta_contable_id_diferido`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` FOREIGN KEY (`cuenta_contable_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` FOREIGN KEY (`cuenta_contable_id_pend_acred`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_bancos`
--

LOCK TABLES `cta_cte_tesoreria_bancos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuenta_tipos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuenta_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuenta_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuenta_tipos`
--

LOCK TABLES `cta_cte_tesoreria_cuenta_tipos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuenta_tipos` VALUES (1,NULL,'CAJA',1,NULL,NULL,NULL),(2,NULL,'BANCOS',1,NULL,NULL,NULL),(3,NULL,'CHEQUES',1,NULL,NULL,NULL),(4,NULL,'RETENCIONES',1,NULL,NULL,NULL),(5,NULL,'PERCEPCIONES',1,NULL,NULL,NULL),(6,NULL,'RESULTADO NEGATIVO',1,NULL,NULL,NULL),(7,NULL,'RESULTADO POSITIVO',1,NULL,NULL,NULL),(8,NULL,'MOVIMIENTO',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuentas`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_tipo_id` int(10) unsigned NOT NULL DEFAULT '8',
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cuit` text COLLATE utf8mb4_unicode_ci,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_cuentas_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `cta_tes_tipo_id_foreign` (`cta_cte_tesoreria_cuenta_tipo_id`),
  KEY `cta_cte_tesoreria_cuentas_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_tes_tipo_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_tipo_id`) REFERENCES `cta_cte_tesoreria_cuenta_tipos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=757 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuentas`
--

LOCK TABLES `cta_cte_tesoreria_cuentas` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (13,NULL,1,13,NULL,8,'Clientes - Deudores',NULL,0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(20,NULL,1,20,NULL,8,'Anticipos Impuesto a las Ganancias',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(23,NULL,1,23,NULL,4,'Retenciones Impuesto a las Ganancias',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(25,NULL,1,25,NULL,4,'Retenciones de IVA',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(57,NULL,1,57,NULL,8,'Proveedores en Cta. Cte. locales',NULL,0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(60,NULL,1,60,NULL,3,'Cheques emitidos ',NULL,0,1,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(62,NULL,1,62,NULL,8,'Sueldos y Jornales a pagar',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(140,NULL,1,140,NULL,6,'Intereses y Gastos bancarios',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(162,NULL,1,162,NULL,4,'Retenciones SUSS',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(176,NULL,1,176,NULL,3,'Cheques en Cartera',NULL,1,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(201,NULL,1,201,NULL,6,'Monotributo',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(203,NULL,1,203,NULL,6,'Autonomos',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(219,NULL,1,219,NULL,8,'Pagos AFIP',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(251,NULL,1,251,NULL,4,'Retenciones de IIBB Buenos Aires',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(252,NULL,1,252,NULL,4,'Retenciones de IIBB Capital Federal',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(253,NULL,1,253,NULL,4,'Retenciones de IIBB Catamarca',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(254,NULL,1,254,NULL,4,'Retenciones de IIBB Chaco',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(255,NULL,1,255,NULL,4,'Retenciones de IIBB Chubut',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(256,NULL,1,256,NULL,4,'Retenciones de IIBB Córdoba',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(257,NULL,1,257,NULL,4,'Retenciones de IIBB Corrientes',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(258,NULL,1,258,NULL,4,'Retenciones de IIBB Entre Ríos',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(259,NULL,1,259,NULL,4,'Retenciones de IIBB Formosa',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(260,NULL,1,260,NULL,4,'Retenciones de IIBB Jujuy',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(261,NULL,1,261,NULL,4,'Retenciones de IIBB La Pampa',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(262,NULL,1,262,NULL,4,'Retenciones de IIBB La Rioja',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(263,NULL,1,263,NULL,4,'Retenciones de IIBB Mendoza',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(264,NULL,1,264,NULL,4,'Retenciones de IIBB Misiones',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(265,NULL,1,265,NULL,4,'Retenciones de IIBB Neuquén',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(266,NULL,1,266,NULL,4,'Retenciones de IIBB Pascua Lama',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(267,NULL,1,267,NULL,4,'Retenciones de IIBB Río Negro',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(268,NULL,1,268,NULL,4,'Retenciones de IIBB Salta',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(269,NULL,1,269,NULL,4,'Retenciones de IIBB San Juan',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(270,NULL,1,270,NULL,4,'Retenciones de IIBB San Luis',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (271,NULL,1,271,NULL,4,'Retenciones de IIBB Santa Cruz',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(272,NULL,1,272,NULL,4,'Retenciones de IIBB Santa Fe',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(273,NULL,1,273,NULL,4,'Retenciones de IIBB Santiago del Estero',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(274,NULL,1,274,NULL,4,'Retenciones de IIBB Tierra del Fuego',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(275,NULL,1,275,NULL,4,'Retenciones de IIBB Tucuman',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(351,NULL,1,351,NULL,8,'BANCO SIRCREB',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(359,NULL,1,359,NULL,8,'Caja en Pesos',NULL,0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:13:03','2023-03-20 23:13:03'),(360,NULL,1,360,NULL,8,'Retenciones Bancarias de Ganancias a Favor',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(364,NULL,1,364,NULL,8,'Anticipo de Clientes',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(384,NULL,1,384,NULL,8,'Caja en Dolares',NULL,0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:13:03','2023-03-20 23:13:03'),(409,NULL,1,409,NULL,6,'IVA Crédito Fiscal No computable',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(418,NULL,1,418,NULL,8,'Deudas Bancarias',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(433,NULL,1,433,NULL,8,'Préstamo',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(441,NULL,1,441,NULL,8,'Leasing',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(448,NULL,1,448,NULL,8,'Planes de Pagos AFIP',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(450,NULL,1,450,NULL,3,'Cheques Rechazados',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(467,NULL,1,467,NULL,6,'Interés',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:00:58',NULL),(468,NULL,1,14,NULL,8,'Deudores por ventas comunes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(469,NULL,1,15,NULL,8,'Deudores por ventas morosos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(470,NULL,1,16,NULL,8,'Deudores en gestión judicial',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(471,NULL,1,17,NULL,8,'Previsión deudores incobrables',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(472,NULL,1,22,NULL,8,'Anticipo Impto.Ganancia Mínima Presunta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(473,NULL,1,24,NULL,4,'Impuesto a las Ganancias (Saldo a favor)',NULL,0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:53:51',NULL),(474,NULL,1,27,NULL,8,'Anticipos de proveedores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(475,NULL,1,28,NULL,8,'Depósito en garantía alquileres',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(476,NULL,1,29,NULL,8,'Derechos adquiridos a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(477,NULL,1,30,NULL,8,'Intereses a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(478,NULL,1,31,NULL,8,'Cuentas a rendir - Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(479,NULL,1,32,NULL,8,'Alquileres no devengados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(480,NULL,1,38,NULL,8,'Equipos de computación valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(481,NULL,1,39,NULL,8,'Equipos de computación ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(482,NULL,1,40,NULL,8,'Amortización Acumulada Equipos de comput.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (483,NULL,1,42,NULL,8,'Instalaciones valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(484,NULL,1,43,NULL,8,'Instalaciones ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(485,NULL,1,44,NULL,8,'Amortización Acumulada Instalaciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(486,NULL,1,46,NULL,8,'Muebles y utiles valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(487,NULL,1,47,NULL,8,'Muebles y utiles ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(488,NULL,1,48,NULL,8,'Amortización Acumulada Muebles y Útiles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(489,NULL,1,50,NULL,8,'Gastos de organización valores historicos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(490,NULL,1,51,NULL,8,'Gastos de organización ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(491,NULL,1,52,NULL,8,'Amortización acumulada gs. de organización',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(492,NULL,1,58,NULL,8,'Proveedores en cta. cte. exterior',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(493,NULL,1,59,NULL,8,'Derechos de exhibición a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(494,NULL,1,63,NULL,8,'Cargas sociales a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(495,NULL,1,64,NULL,8,'Sindicatos a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(496,NULL,1,67,NULL,8,'IVA Debito Fiscal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(497,NULL,1,68,NULL,8,'IVA Credito Fiscal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(498,NULL,1,69,NULL,8,'Impuestos Internos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(499,NULL,1,70,NULL,8,'Impuestos al Combustible',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(500,NULL,1,71,NULL,8,'IVA Retenciones de terceros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(501,NULL,1,72,NULL,5,'IVA Percepciones realiz.por terceros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(502,NULL,1,73,NULL,8,'IVA Saldo a favor',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(503,NULL,1,74,NULL,8,'IVA a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(504,NULL,1,75,NULL,5,'Percepciones Ingresos Brutos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(505,NULL,1,76,NULL,8,'Otros Pagos AFIP',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(506,NULL,1,78,NULL,8,'Impuesto a los Ingresos Brutos Pasivo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(507,NULL,1,79,NULL,8,'Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(508,NULL,1,80,NULL,8,'Impuesto a la Ganancia Mínima Presunta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(509,NULL,1,81,NULL,8,'AFIP - Retenciones Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(510,NULL,1,82,NULL,8,'AFIP - Plan de Facilidades Decreto 338/02',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(511,NULL,1,87,NULL,8,'Acciones en circulación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(512,NULL,1,88,NULL,8,'Ajuste del Capital',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(513,NULL,1,89,NULL,8,'Aportes Irrevocables Futuras Suscripciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(514,NULL,1,91,NULL,8,'Resultado del ejercicio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (515,NULL,1,92,NULL,8,'Resultado ejercicios anteriores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(516,NULL,1,93,NULL,8,'A.R.E.A.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(517,NULL,1,96,NULL,7,'VENTAS',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(518,NULL,1,97,NULL,7,'Honorarios',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(519,NULL,1,99,NULL,7,'Descuentos obtenidos',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(520,NULL,1,100,NULL,7,'Reintegros por exportaciones',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(521,NULL,1,102,NULL,7,'Intereses Cobrados',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(522,NULL,1,103,NULL,7,'Diferencias de cambio',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(523,NULL,1,104,NULL,7,'Descuentos obtenidos',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(524,NULL,1,110,NULL,6,'Sueldos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(525,NULL,1,111,NULL,6,'Contribuciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(526,NULL,1,112,NULL,6,'Sindicato',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(527,NULL,1,114,NULL,8,'ACA',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(528,NULL,1,115,NULL,6,'Aereos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(529,NULL,1,116,NULL,6,'Alquiler',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(530,NULL,1,117,NULL,8,'AGUA AYSA',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(531,NULL,1,118,NULL,8,'TV Cablevision',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(532,NULL,1,119,NULL,1,'Caja Jubilacion Consejo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(533,NULL,1,120,NULL,6,'Celulares',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(534,NULL,1,121,NULL,3,'Cheques',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(535,NULL,1,123,NULL,8,'Comida',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(536,NULL,1,126,NULL,6,'Fletes y acarreos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(537,NULL,1,127,NULL,8,'Luz Edesur',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(538,NULL,1,128,NULL,6,'Movilidad y Viáticos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(539,NULL,1,129,NULL,8,'Mantenimiento',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(540,NULL,1,130,NULL,8,'IVA No Computable',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(541,NULL,1,131,NULL,8,'Entretenimiento',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(542,NULL,1,132,NULL,6,'Amortización Bienes de Uso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(543,NULL,1,135,NULL,6,'Gastos varios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(544,NULL,1,136,NULL,6,'Ajuste por redondeo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(545,NULL,1,137,NULL,6,'Deudores Incobrables',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(546,NULL,1,141,NULL,6,'Intereses Proveedores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(547,NULL,1,143,NULL,6,'Diferencias de cambio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(548,NULL,1,144,NULL,8,'Diferencia de Cambio Bces. en M.Extranjera',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(549,NULL,1,145,NULL,6,'Diferencia tipo cambio Vendedor/Comprador',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (550,NULL,1,146,NULL,8,'Diferencia por conversion en Bce. en Mon. Extranj.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(551,NULL,1,147,NULL,8,'Diferencia de cambio CMV',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(552,NULL,1,148,NULL,8,'Diferencia de cambio PT',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(553,NULL,1,149,NULL,8,'Resultado por Exposición a la Inflación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(554,NULL,1,150,NULL,8,'Diferencia de cambio PE',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(555,NULL,1,151,NULL,8,'Diferencia de cambio Ds.Vtas.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(556,NULL,1,152,NULL,6,'Diferencia de cambio ME',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(557,NULL,1,153,NULL,6,'Descuentos otorgados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(558,NULL,1,155,NULL,6,'Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(559,NULL,1,156,NULL,6,'Impuesto a los Ingresos Brutos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(560,NULL,1,157,NULL,6,'Impuesto al Debito y Credito Bancario',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(561,NULL,1,159,NULL,6,'Pérdida por venta bienes de uso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(562,NULL,1,160,NULL,6,'Inversiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(563,NULL,1,161,NULL,6,'Amortizaciones extraordinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(564,NULL,1,178,NULL,8,'Google',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(565,NULL,1,188,NULL,6,'Publicidad',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(566,NULL,1,191,NULL,6,'Cargas Sociales',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(567,NULL,1,192,NULL,6,'Honorarios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(568,NULL,1,193,NULL,6,'Telefono Fijo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(569,NULL,1,198,NULL,6,'Seguros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(570,NULL,1,199,NULL,6,'Internet',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(571,NULL,1,204,NULL,6,'Multas Impositivas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(572,NULL,1,208,NULL,6,'Impuesto a los Ingresos Brutos - BS AS',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(573,NULL,1,209,NULL,6,'SIRCREB',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(574,NULL,1,212,NULL,6,'Tarjeta Visa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(575,NULL,1,213,NULL,6,'Tarjeta American Express',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(576,NULL,1,214,NULL,6,'Tarjeta Mastercard',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(577,NULL,1,215,NULL,8,'Tarjeta Shopping',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(578,NULL,1,216,NULL,6,'Tarjeta Cencosud',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(579,NULL,1,217,NULL,6,'Compras',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(580,NULL,1,218,NULL,7,'Ventas No Gravadas',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(581,NULL,1,220,NULL,5,'Perc IVA -RG3337',NULL,0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:53:51',NULL),(582,NULL,1,221,NULL,6,'Imps. Internos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(583,NULL,1,222,NULL,6,'Imp. Gasoil',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (584,NULL,1,223,NULL,6,'Imp. Hídricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(585,NULL,1,224,NULL,6,'ITC',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(586,NULL,1,225,NULL,5,'Perc IIBB  Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(587,NULL,1,226,NULL,5,'Perc IIBB  Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(588,NULL,1,227,NULL,5,'Perc IIBB  Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(589,NULL,1,228,NULL,5,'Perc IIBB  Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(590,NULL,1,229,NULL,5,'Perc IIBB  Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(591,NULL,1,230,NULL,5,'Perc IIBB  Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(592,NULL,1,231,NULL,5,'Perc IIBB  Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(593,NULL,1,232,NULL,5,'Perc IIBB  Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(594,NULL,1,233,NULL,5,'Perc IIBB  Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(595,NULL,1,234,NULL,5,'Perc IIBB  Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(596,NULL,1,235,NULL,5,'Perc IIBB  La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(597,NULL,1,236,NULL,5,'Perc IIBB  La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(598,NULL,1,237,NULL,5,'Perc IIBB  Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(599,NULL,1,238,NULL,5,'Perc IIBB  Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(600,NULL,1,239,NULL,5,'Perc IIBB  Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(601,NULL,1,240,NULL,5,'Perc IIBB  Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(602,NULL,1,241,NULL,5,'Perc IIBB  Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(603,NULL,1,242,NULL,5,'Perc IIBB  Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(604,NULL,1,243,NULL,5,'Perc IIBB  San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:58',NULL),(605,NULL,1,244,NULL,5,'Perc IIBB  San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(606,NULL,1,245,NULL,5,'Perc IIBB  Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(607,NULL,1,246,NULL,5,'Perc IIBB  Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(608,NULL,1,247,NULL,5,'Perc IIBB  Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(609,NULL,1,248,NULL,5,'Perc IIBB  Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(610,NULL,1,249,NULL,5,'Perc IIBB  Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(611,NULL,1,250,NULL,6,'Compras No Gravadas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(612,NULL,1,276,NULL,6,'SIRCREB Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(613,NULL,1,277,NULL,6,'SIRCREB Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(614,NULL,1,278,NULL,6,'SIRCREB Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(615,NULL,1,279,NULL,6,'SIRCREB Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(616,NULL,1,280,NULL,6,'SIRCREB Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(617,NULL,1,281,NULL,6,'SIRCREB Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(618,NULL,1,282,NULL,6,'SIRCREB Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (619,NULL,1,283,NULL,6,'SIRCREB Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(620,NULL,1,284,NULL,6,'SIRCREB Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(621,NULL,1,285,NULL,6,'SIRCREB Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(622,NULL,1,286,NULL,6,'SIRCREB La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(623,NULL,1,287,NULL,6,'SIRCREB La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(624,NULL,1,288,NULL,6,'SIRCREB Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(625,NULL,1,289,NULL,6,'SIRCREB Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(626,NULL,1,290,NULL,6,'SIRCREB Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(627,NULL,1,291,NULL,6,'SIRCREB Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(628,NULL,1,292,NULL,6,'SIRCREB Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(629,NULL,1,293,NULL,6,'SIRCREB Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(630,NULL,1,294,NULL,6,'SIRCREB San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(631,NULL,1,295,NULL,6,'SIRCREB San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(632,NULL,1,296,NULL,6,'SIRCREB Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(633,NULL,1,297,NULL,6,'SIRCREB Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(634,NULL,1,298,NULL,6,'SIRCREB Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(635,NULL,1,299,NULL,6,'SIRCREB Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(636,NULL,1,300,NULL,6,'SIRCREB Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(637,NULL,1,301,NULL,8,'IIBB a Favor Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(638,NULL,1,302,NULL,8,'IIBB a Favor Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(639,NULL,1,303,NULL,8,'IIBB a Favor Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(640,NULL,1,304,NULL,8,'IIBB a Favor Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(641,NULL,1,305,NULL,8,'IIBB a Favor Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(642,NULL,1,306,NULL,8,'IIBB a Favor Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(643,NULL,1,307,NULL,8,'IIBB a Favor Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(644,NULL,1,308,NULL,8,'IIBB a Favor Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(645,NULL,1,309,NULL,8,'IIBB a Favor Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(646,NULL,1,310,NULL,8,'IIBB a Favor Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(647,NULL,1,311,NULL,8,'IIBB a Favor La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(648,NULL,1,312,NULL,8,'IIBB a Favor La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(649,NULL,1,313,NULL,8,'IIBB a Favor Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:00:59',NULL),(650,NULL,1,314,NULL,8,'IIBB a Favor Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(651,NULL,1,315,NULL,8,'IIBB a Favor Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(652,NULL,1,316,NULL,8,'IIBB a Favor Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(653,NULL,1,317,NULL,8,'IIBB a Favor Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (654,NULL,1,318,NULL,8,'IIBB a Favor Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(655,NULL,1,319,NULL,8,'IIBB a Favor San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(656,NULL,1,320,NULL,8,'IIBB a Favor San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(657,NULL,1,321,NULL,8,'IIBB a Favor Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(658,NULL,1,322,NULL,8,'IIBB a Favor Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(659,NULL,1,323,NULL,8,'IIBB a Favor Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(660,NULL,1,324,NULL,8,'IIBB a Favor Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(661,NULL,1,325,NULL,8,'IIBB a Favor Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(662,NULL,1,326,NULL,8,'IIBB a Pagar Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(663,NULL,1,327,NULL,8,'IIBB a Pagar Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(664,NULL,1,328,NULL,8,'IIBB a Pagar Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(665,NULL,1,329,NULL,8,'IIBB a Pagar Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(666,NULL,1,330,NULL,8,'IIBB a Pagar Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(667,NULL,1,331,NULL,8,'IIBB a Pagar Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(668,NULL,1,332,NULL,8,'IIBB a Pagar Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(669,NULL,1,333,NULL,8,'IIBB a Pagar Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(670,NULL,1,334,NULL,8,'IIBB a Pagar Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(671,NULL,1,335,NULL,8,'IIBB a Pagar Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(672,NULL,1,336,NULL,8,'IIBB a Pagar La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(673,NULL,1,337,NULL,8,'IIBB a Pagar La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(674,NULL,1,338,NULL,8,'IIBB a Pagar Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(675,NULL,1,339,NULL,8,'IIBB a Pagar Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(676,NULL,1,340,NULL,8,'IIBB a Pagar Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(677,NULL,1,341,NULL,8,'IIBB a Pagar Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(678,NULL,1,342,NULL,8,'IIBB a Pagar Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(679,NULL,1,343,NULL,8,'IIBB a Pagar Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(680,NULL,1,344,NULL,8,'IIBB a Pagar San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(681,NULL,1,345,NULL,8,'IIBB a Pagar San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(682,NULL,1,346,NULL,8,'IIBB a Pagar Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(683,NULL,1,347,NULL,8,'IIBB a Pagar Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(684,NULL,1,348,NULL,8,'IIBB a Pagar Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(685,NULL,1,349,NULL,8,'IIBB a Pagar Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(686,NULL,1,350,NULL,8,'IIBB a Pagar Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(687,NULL,1,352,NULL,8,'Compensacion',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (688,NULL,1,353,NULL,8,'IVA Saldo Tecnico',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(689,NULL,1,354,NULL,8,'IVA Saldo Libre Disponibilidad',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(690,NULL,1,361,NULL,8,'Equipos de Computación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(691,NULL,1,362,NULL,8,'Computadoras',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(692,NULL,1,363,NULL,8,'Muebles y Utiles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(693,NULL,1,365,NULL,8,'Provision Honorarios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(694,NULL,1,366,NULL,8,'Cta. Cte Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(695,NULL,1,367,NULL,8,'Provisión Honorarios Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(696,NULL,1,368,NULL,8,'Cuenta Particular Socio 1',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(697,NULL,1,369,NULL,8,'Capital',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(698,NULL,1,380,NULL,8,'Instalaciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(699,NULL,1,381,NULL,8,'Reserva Legal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(700,NULL,1,382,NULL,8,'Reserva Legal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(701,NULL,1,383,NULL,8,'Resultado no asignado',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(702,NULL,1,386,NULL,8,'PLAZO FIJO',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(703,NULL,1,388,NULL,8,'ACCIONES',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(704,NULL,1,389,NULL,8,'Inmuebles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(705,NULL,1,390,NULL,8,'Vehiculos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(706,NULL,1,391,NULL,8,'Maquinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(707,NULL,1,392,NULL,8,'MERCADERIAS',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(708,NULL,1,393,NULL,8,'OTROS',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(709,NULL,1,395,NULL,8,'Cuenta Particular Socio 2',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(710,NULL,1,396,NULL,6,'Comisiones Y gastos Bancarios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(711,NULL,1,411,NULL,8,'Provisión Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(712,NULL,1,412,NULL,6,'Amortización Muebles y Útiles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(713,NULL,1,413,NULL,6,'Amortización Equipos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(714,NULL,1,414,NULL,8,'Amortizacion Acumulada Equipos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(715,NULL,1,415,NULL,8,'Amortización Acumulada Maquinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(716,NULL,1,416,NULL,8,'Materias Primas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(717,NULL,1,419,NULL,8,'Rodados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(718,NULL,1,420,NULL,8,'Amortización Acumulada Rodados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(719,NULL,1,421,NULL,8,'Amortización Rodados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(720,NULL,1,422,NULL,8,'Amortización Maquinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(721,NULL,1,423,NULL,8,'Accesorios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(722,NULL,1,424,NULL,8,'Amortización Acumulada Accesorios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (723,NULL,1,426,NULL,8,'Reserva Facultativa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(724,NULL,1,427,NULL,8,'Créditos por Impuestos Diferidos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(725,NULL,1,428,NULL,8,'Fondo de Comercio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(726,NULL,1,429,NULL,8,'Amortizacion Acumulada Fondo de Comercio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(727,NULL,1,430,NULL,8,'Intereses a devengar AGIP',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(728,NULL,1,431,NULL,8,'PFP IIBB',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(729,NULL,1,434,NULL,8,'Productos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(730,NULL,1,435,NULL,8,'Intereses a devengar PFP',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(731,NULL,1,437,NULL,8,'Imp. Ley 25413 Cred 0.6%',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(732,NULL,1,438,NULL,8,'Honorarios Directorio a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(733,NULL,1,439,NULL,8,'Reserva para Futuras Inversiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(734,NULL,1,440,NULL,8,'TEAC - Trabajos Ejecutados a Certificar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(735,NULL,1,444,NULL,8,'Banco Santander Rio Cta Cte',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(736,NULL,1,449,NULL,8,'Leasing',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(737,NULL,1,453,NULL,8,'Inversión Central Caribe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(738,NULL,1,454,NULL,8,'Otras Inversiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(739,NULL,1,455,NULL,8,'Otros Créditos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(740,NULL,1,456,NULL,8,'Provisión Honorarios Socio Gerente',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(741,NULL,1,459,NULL,8,'Moratoria SUSS a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(742,NULL,1,460,NULL,8,'Impuestos Municipales a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(743,NULL,1,461,NULL,6,'Amortización Instalaciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(744,NULL,1,462,NULL,8,'Amortización Equipos de comput.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(745,NULL,1,463,NULL,8,'Cuenta Particular Socio 3',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(746,NULL,1,464,NULL,8,'Cuenta Particular Socio 4',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(747,NULL,1,465,NULL,8,'Otras Reservas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(748,NULL,1,466,NULL,8,'IGMP (Saldo a Favor)',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(749,NULL,1,468,NULL,8,'Productos en Proceso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(750,NULL,1,469,NULL,8,'Depósitos en Garantía Socio Gerente',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(751,NULL,1,470,NULL,8,'Fondos Embargados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(752,NULL,1,471,NULL,8,'Cuota Solid.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(753,NULL,1,472,NULL,8,'Anticipo Honorarios Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(754,NULL,1,473,NULL,8,'SICORE a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(755,NULL,1,476,NULL,6,'RECPAM',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL),(756,NULL,1,478,NULL,6,'CO2 - Imp. Al Carbono',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:00:59',NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_detail`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `is_conciliado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_detail_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_detail_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_detail`
--

LOCK TABLES `cta_cte_tesoreria_detail` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos`
--

DROP TABLE IF EXISTS `ctacte_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigoBCRA` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos`
--

LOCK TABLES `ctacte_bancos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos` DISABLE KEYS */;
INSERT INTO `ctacte_bancos` VALUES (1,NULL,'BANCO DE GALICIA Y BUENOS AIRES S.A.',7,NULL,NULL,NULL),(2,NULL,'BANCO DE LA NACION ARGENTINA',11,NULL,NULL,NULL),(3,NULL,'BANCO DE LA PROVINCIA DE BUENOS AIRES',14,NULL,NULL,NULL),(4,NULL,'INDUSTRIAL AND COMMERCIAL BANK OF CHINA',15,NULL,NULL,NULL),(5,NULL,'CITIBANK N.A.',16,NULL,NULL,NULL),(6,NULL,'BBVA BANCO FRANCES S.A.',17,NULL,NULL,NULL),(7,NULL,'THE BANK OF TOKYO-MITSUBISHI UFJ, LTD.',18,NULL,NULL,NULL),(8,NULL,'BANCO DE LA PROVINCIA DE CORDOBA S.A.',20,NULL,NULL,NULL),(9,NULL,'BANCO SUPERVIELLE S.A.',27,NULL,NULL,NULL),(10,NULL,'BANCO DE LA CIUDAD DE BUENOS AIRES',29,NULL,NULL,NULL),(11,NULL,'BANCO PATAGONIA S.A.',34,NULL,NULL,NULL),(12,NULL,'BANCO HIPOTECARIO S.A.',44,NULL,NULL,NULL),(13,NULL,'BANCO DE SAN JUAN S.A.',45,NULL,NULL,NULL),(14,NULL,'BANCO DEL TUCUMAN S.A.',60,NULL,NULL,NULL),(15,NULL,'BANCO MUNICIPAL DE ROSARIO',65,NULL,NULL,NULL),(16,NULL,'BANCO SANTANDER RIO S.A.',72,NULL,NULL,NULL),(17,NULL,'BANCO DEL CHUBUT S.A.',83,NULL,NULL,NULL),(18,NULL,'BANCO DE SANTA CRUZ S.A.',86,NULL,NULL,NULL),(19,NULL,'BANCO DE LA PAMPA SOCIEDAD DE ECONOMÍA M',93,NULL,NULL,NULL),(20,NULL,'BANCO DE CORRIENTES S.A.',94,NULL,NULL,NULL),(21,NULL,'BANCO PROVINCIA DEL NEUQUÉN SOCIEDAD ANÓ',97,NULL,NULL,NULL),(22,NULL,'BANCO INTERFINANZAS S.A.',147,NULL,NULL,NULL),(23,NULL,'HSBC BANK ARGENTINA S.A.',150,NULL,NULL,NULL),(24,NULL,'JPMORGAN CHASE BANK, NATIONAL ASSOCIATIO',165,NULL,NULL,NULL),(25,NULL,'BANCO CREDICOOP COOPERATIVO LIMITADO',191,NULL,NULL,NULL),(26,NULL,'BANCO DE VALORES S.A.',198,NULL,NULL,NULL),(27,NULL,'BANCO ROELA S.A.',247,NULL,NULL,NULL),(28,NULL,'BANCO MARIVA S.A.',254,NULL,NULL,NULL),(29,NULL,'BANCO ITAU ARGENTINA S.A.',259,NULL,NULL,NULL),(30,NULL,'BANK OF AMERICA, NATIONAL ASSOCIATION',262,NULL,NULL,NULL),(31,NULL,'BNP PARIBAS',266,NULL,NULL,NULL),(32,NULL,'BANCO PROVINCIA DE TIERRA DEL FUEGO',268,NULL,NULL,NULL),(33,NULL,'BANCO DE LA REPUBLICA ORIENTAL DEL URUGU',269,NULL,NULL,NULL),(34,NULL,'BANCO SAENZ S.A.',277,NULL,NULL,NULL),(35,NULL,'BANCO MERIDIAN S.A.',281,NULL,NULL,NULL),(36,NULL,'BANCO MACRO S.A.',285,NULL,NULL,NULL),(37,NULL,'BANCO COMAFI SOCIEDAD ANONIMA',299,NULL,NULL,NULL),(38,NULL,'BANCO DE INVERSION Y COMERCIO EXTERIOR S',300,NULL,NULL,NULL),(39,NULL,'BANCO PIANO S.A.',301,NULL,NULL,NULL),(40,NULL,'BANCO JULIO SOCIEDAD ANONIMA',305,NULL,NULL,NULL),(41,NULL,'BANCO RIOJA SOCIEDAD ANONIMA UNIPERSONAL',309,NULL,NULL,NULL),(42,NULL,'BANCO DEL SOL S.A.',310,NULL,NULL,NULL),(43,NULL,'NUEVO BANCO DEL CHACO S. A.',311,NULL,NULL,NULL),(44,NULL,'BANCO VOII S.A.',312,NULL,NULL,NULL),(45,NULL,'BANCO DE FORMOSA S.A.',315,NULL,NULL,NULL),(46,NULL,'BANCO CMF S.A.',319,NULL,NULL,NULL),(47,NULL,'BANCO DE SANTIAGO DEL ESTERO S.A.',321,NULL,NULL,NULL),(48,NULL,'BANCO INDUSTRIAL S.A.',322,NULL,NULL,NULL),(49,NULL,'NUEVO BANCO DE SANTA FE SOCIEDAD ANONIMA',330,NULL,NULL,NULL),(50,NULL,'BANCO CETELEM ARGENTINA S.A.',331,NULL,NULL,NULL),(51,NULL,'BANCO DE SERVICIOS FINANCIEROS S.A.',332,NULL,NULL,NULL),(52,NULL,'BANCO BRADESCO ARGENTINA S.A.U.',336,NULL,NULL,NULL),(53,NULL,'BANCO DE SERVICIOS Y TRANSACCIONES S.A.',338,NULL,NULL,NULL),(54,NULL,'RCI BANQUE S.A.',339,NULL,NULL,NULL),(55,NULL,'BACS BANCO DE CREDITO Y SECURITIZACION S',340,NULL,NULL,NULL),(56,NULL,'BANCO MASVENTAS S.A.',341,NULL,NULL,NULL),(57,NULL,'BANCO WANAP S.A.',384,NULL,NULL,NULL),(58,NULL,'NUEVO BANCO DE ENTRE RÍOS S.A.',386,NULL,NULL,NULL),(59,NULL,'BANCO COLUMBIA S.A.',389,NULL,NULL,NULL),(60,NULL,'BANCO BICA S.A.',426,NULL,NULL,NULL),(61,NULL,'BANCO COINAG S.A.',431,NULL,NULL,NULL),(62,NULL,'BANCO DE COMERCIO S.A.',432,NULL,NULL,NULL),(63,NULL,'FORD CREDIT COMPAÑIA FINANCIERA S.A.',44059,NULL,NULL,NULL),(64,NULL,'COMPAÑIA FINANCIERA ARGENTINA S.A.',44077,NULL,NULL,NULL),(65,NULL,'VOLKWAGEN FINANCIAL SERVICES CIA.FIN.S.A',44088,NULL,NULL,NULL),(66,NULL,'CORDIAL COMPAÑÍA FINANCIERA S.A.',44090,NULL,NULL,NULL),(67,NULL,'FCA COMPAÑIA FINANCIERA S.A.',44092,NULL,NULL,NULL);
INSERT INTO `ctacte_bancos` VALUES (68,NULL,'GPAT COMPAÑIA FINANCIERA S.A.',44093,NULL,NULL,NULL),(69,NULL,'MERCEDES-BENZ COMPAÑÍA FINANCIERA ARGENT',44094,NULL,NULL,NULL),(70,NULL,'ROMBO COMPAÑÍA FINANCIERA S.A.',44095,NULL,NULL,NULL),(71,NULL,'JOHN DEERE CREDIT COMPAÑÍA FINANCIERA S.',44096,NULL,NULL,NULL),(72,NULL,'PSA FINANCE ARGENTINA COMPAÑÍA FINANCIER',44098,NULL,NULL,NULL),(73,NULL,'TOYOTA COMPAÑÍA FINANCIERA DE ARGENTINA',44099,NULL,NULL,NULL),(74,NULL,'FINANDINO COMPAÑIA FINANCIERA S.A.',44100,NULL,NULL,NULL),(75,NULL,'MONTEMAR COMPAÑIA FINANCIERA S.A.',45056,NULL,NULL,NULL),(76,NULL,'MULTIFINANZAS COMPAÑIA FINANCIERA S.A.',45072,NULL,NULL,NULL),(77,NULL,'CAJA DE CREDITO \"CUENCA\" COOPERATIVA LIM',65203,NULL,NULL,NULL),(78,NULL,'MERCADO PAGO',NULL,NULL,NULL,NULL),(79,NULL,'UALA',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctacte_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos_datos`
--

DROP TABLE IF EXISTS `ctacte_bancos_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos_datos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `num_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cbu` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_bancos_datos_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  CONSTRAINT `ctacte_bancos_datos_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos_datos`
--

LOCK TABLES `ctacte_bancos_datos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_bancos_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_cheques`
--

DROP TABLE IF EXISTS `ctacte_cheques`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_cheques` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `asiento_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) DEFAULT NULL,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_cobro` date DEFAULT NULL,
  `banco_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `cuit` text COLLATE utf8mb4_unicode_ci,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abierto_cruzado` int(11) NOT NULL DEFAULT '1',
  `is_no_a_la_orden` tinyint(1) NOT NULL DEFAULT '0',
  `numero` int(10) unsigned DEFAULT NULL,
  `foto` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_cheques_asiento_id_foreign` (`asiento_id`),
  KEY `ctacte_cheques_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  KEY `ctacte_cheques_banco_id_foreign` (`banco_id`),
  KEY `ctacte_cheques_person_id_foreign` (`person_id`),
  KEY `ctacte_cheques_cta_cte_cliente_id2_foreign` (`cta_cte_cliente_id2`),
  KEY `ctacte_cheques_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesorer_id` (`cta_cte_tesoreria_id`),
  KEY `ctacte_cheques_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `ctacte_cheques_nf_cta_cte_id2_foreign` (`nf_cta_cte_id2`),
  KEY `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_tesorer_id` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `ctacte_cheques_banco_id_foreign` FOREIGN KEY (`banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id2_foreign` FOREIGN KEY (`cta_cte_cliente_id2`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctacte_cheques_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id2_foreign` FOREIGN KEY (`nf_cta_cte_id2`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_cheques`
--

LOCK TABLES `ctacte_cheques` WRITE;
/*!40000 ALTER TABLE `ctacte_cheques` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_cheques` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_centrocosto`
--

DROP TABLE IF EXISTS `ctactegastos_centrocosto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_centrocosto` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_centrocosto`
--

LOCK TABLES `ctactegastos_centrocosto` WRITE;
/*!40000 ALTER TABLE `ctactegastos_centrocosto` DISABLE KEYS */;
INSERT INTO `ctactegastos_centrocosto` VALUES (1,NULL,'OFICINA',NULL,NULL,NULL),(2,NULL,'FIJO',NULL,NULL,NULL),(3,NULL,'VARIABLE',NULL,NULL,NULL),(4,NULL,'GISELA',NULL,NULL,NULL),(5,NULL,'LIA',NULL,NULL,NULL),(6,NULL,'PADRES',NULL,NULL,NULL),(7,NULL,'CASA',NULL,NULL,NULL),(8,NULL,'VANESA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_centrocosto` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_cuenta_tipo`
--

DROP TABLE IF EXISTS `ctactegastos_cuenta_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_cuenta_tipo` (
  `idCuentaTipo` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `idTipo` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`idCuentaTipo`),
  KEY `ctactegastos_cuenta_tipo_idtipo_foreign` (`idTipo`),
  KEY `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_idtipo_foreign` FOREIGN KEY (`idTipo`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_cuenta_tipo`
--

LOCK TABLES `ctactegastos_cuenta_tipo` WRITE;
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` DISABLE KEYS */;
INSERT INTO `ctactegastos_cuenta_tipo` VALUES (1,NULL,NULL,3,NULL,NULL,NULL),(2,NULL,NULL,6,NULL,NULL,NULL),(3,NULL,NULL,3,NULL,NULL,NULL),(4,NULL,NULL,4,NULL,NULL,NULL),(5,NULL,NULL,5,NULL,NULL,NULL),(6,NULL,NULL,3,NULL,NULL,NULL),(7,NULL,NULL,4,NULL,NULL,NULL),(8,NULL,NULL,3,NULL,NULL,NULL),(9,NULL,NULL,4,NULL,NULL,NULL),(10,NULL,NULL,7,NULL,NULL,NULL),(11,NULL,NULL,8,NULL,NULL,NULL),(12,NULL,NULL,3,NULL,NULL,NULL),(13,NULL,NULL,3,NULL,NULL,NULL),(14,NULL,NULL,4,NULL,NULL,NULL),(15,NULL,NULL,1,NULL,NULL,NULL),(16,NULL,NULL,2,NULL,NULL,NULL),(17,NULL,NULL,5,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_mensuales`
--

DROP TABLE IF EXISTS `ctactegastos_mensuales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_mensuales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `CuentaTipo_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `TipoDeGasto_id` int(10) unsigned NOT NULL,
  `CentroCosto_id` int(10) unsigned NOT NULL,
  `gasto_cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `monto` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctactegastos_mensuales_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `ctactegastos_mensuales_tipodegasto_id_foreign` (`TipoDeGasto_id`),
  KEY `ctactegastos_mensuales_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` (`gasto_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_mensuales_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`gasto_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_tipodegasto_id_foreign` FOREIGN KEY (`TipoDeGasto_id`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_mensuales`
--

LOCK TABLES `ctactegastos_mensuales` WRITE;
/*!40000 ALTER TABLE `ctactegastos_mensuales` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctactegastos_mensuales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_tiposdegastos`
--

DROP TABLE IF EXISTS `ctactegastos_tiposdegastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_tiposdegastos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_tiposdegastos`
--

LOCK TABLES `ctactegastos_tiposdegastos` WRITE;
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` DISABLE KEYS */;
INSERT INTO `ctactegastos_tiposdegastos` VALUES (1,NULL,'Oficina',NULL,NULL,NULL),(2,NULL,'Personales',NULL,NULL,NULL),(3,NULL,'Tarjeta VISA',NULL,NULL,NULL),(4,NULL,'Tarjeta Mastercard',NULL,NULL,NULL),(5,NULL,'Debito Automatico',NULL,NULL,NULL),(6,NULL,'American Express',NULL,NULL,NULL),(7,NULL,'Tarjeta Shopping',NULL,NULL,NULL),(8,NULL,'Tarjeta Cencosud',NULL,NULL,NULL),(9,NULL,'Tarjeta Coto',NULL,NULL,NULL),(10,NULL,'Tarjeta Nativa',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos`
--

DROP TABLE IF EXISTS `cursos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fecha` date DEFAULT NULL,
  `hora` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profesor` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cant_clases` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjuntos` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_zoom` longtext COLLATE utf8mb4_unicode_ci,
  `cod_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contraseña_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_youtube` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `materiales` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos`
--

LOCK TABLES `cursos` WRITE;
/*!40000 ALTER TABLE `cursos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos_detail`
--

DROP TABLE IF EXISTS `cursos_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `curso_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cursos_detail_curso_id_foreign` (`curso_id`),
  CONSTRAINT `cursos_detail_curso_id_foreign` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos_detail`
--

LOCK TABLES `cursos_detail` WRITE;
/*!40000 ALTER TABLE `cursos_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `data_types`
--

DROP TABLE IF EXISTS `data_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `data_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `data_types_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `data_types`
--

LOCK TABLES `data_types` WRITE;
/*!40000 ALTER TABLE `data_types` DISABLE KEYS */;
INSERT INTO `data_types` VALUES (1,'Comprobantes XLS',1,'Importación','XLS','data/imports/receipts/xls',NULL,NULL),(2,'CITI-Ventas',1,'Importación','TXT','data/imports/receipts/CitiVentas',NULL,NULL),(3,'CITI Compras',2,'Exportación','TXT','data/exports/receipts/citi',NULL,NULL),(4,'CITI Ventas',2,'Exportación','TXT','data/exports/receipts/CitiVentasExport',NULL,NULL),(5,'Convenio Multilateral',2,'Exportación','TXT','data/exports/receipts/convenio',NULL,NULL),(6,'Libro IVA Digital',2,'Exportación','TXT','data/exports/receipts/libro_iva_digital',NULL,'2019-11-20 21:43:44'),(7,'Mis Comprobantes',1,'Importacion','','data/imports/receipts/mis_comprobantes',NULL,NULL),(8,'Consulta AFIP',3,'AFIP','','data/afip/index','2019-12-06 14:49:55','2019-12-06 14:49:55');
/*!40000 ALTER TABLE `data_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_estados`
--

DROP TABLE IF EXISTS `dc_estados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_estados` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_estados`
--

LOCK TABLES `dc_estados` WRITE;
/*!40000 ALTER TABLE `dc_estados` DISABLE KEYS */;
INSERT INTO `dc_estados` VALUES (1,NULL,'BORRADOR',1,NULL,'2023-08-06 23:55:26',NULL),(2,NULL,'TERMINADO',1,NULL,'2023-08-06 23:55:26',NULL),(3,NULL,'ELIMINADO',1,NULL,'2023-08-13 09:16:11',NULL),(4,NULL,'PAGADO',1,NULL,'2023-08-06 23:55:26','2023-08-06 23:55:26'),(5,NULL,'CONCILIADO',1,NULL,'2023-08-06 23:55:26','2023-08-06 23:55:26');
/*!40000 ALTER TABLE `dc_estados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas`
--

DROP TABLE IF EXISTS `dc_firmas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_firmante_dc` tinyint(1) NOT NULL DEFAULT '0',
  `show_create_dc` tinyint(1) NOT NULL DEFAULT '0',
  `faltan_firmas` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas`
--

LOCK TABLES `dc_firmas` WRITE;
/*!40000 ALTER TABLE `dc_firmas` DISABLE KEYS */;
INSERT INTO `dc_firmas` VALUES (1,NULL,'NO',1,1,0,1,NULL,'2023-08-06 23:55:27',NULL),(2,NULL,'RECHAZADO',1,1,0,1,NULL,'2023-08-06 23:55:27',NULL),(3,NULL,'ACEPTADO',1,0,0,1,NULL,'2023-08-06 23:55:27',NULL),(4,NULL,'FALTAN FIRMAS',0,0,1,1,'2023-08-06 23:55:27','2023-08-06 23:55:27',NULL),(5,NULL,'EMITIDO',1,0,0,1,'2023-10-12 08:05:18','2023-10-12 08:05:18',NULL);
/*!40000 ALTER TABLE `dc_firmas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas_ordenes`
--

DROP TABLE IF EXISTS `dc_firmas_ordenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas_ordenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `user_id_que_firma` int(10) unsigned NOT NULL,
  `dc_firma_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_firmas_ordenes_person_id_foreign` (`person_id`),
  KEY `dc_firmas_ordenes_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_firmas_ordenes_dc_firma_id_foreign` (`dc_firma_id`),
  CONSTRAINT `dc_firmas_ordenes_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_firmas_ordenes_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_firmas_ordenes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas_ordenes`
--

LOCK TABLES `dc_firmas_ordenes` WRITE;
/*!40000 ALTER TABLE `dc_firmas_ordenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_firmas_ordenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas_reglas`
--

DROP TABLE IF EXISTS `dc_firmas_reglas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas_reglas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL,
  `grupos_users_ids` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_firmas_reglas_person_id_foreign` (`person_id`),
  KEY `dc_firmas_reglas_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_firmas_reglas_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_firmas_reglas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas_reglas`
--

LOCK TABLES `dc_firmas_reglas` WRITE;
/*!40000 ALTER TABLE `dc_firmas_reglas` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_firmas_reglas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_de_pago`
--

DROP TABLE IF EXISTS `dc_orden_de_pago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_de_pago` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-09-28 16:29:20',
  `dc_orden_id` bigint(20) unsigned NOT NULL DEFAULT '10',
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dc_estado_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `dc_firma_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_de_pago_person_id_foreign` (`person_id`),
  KEY `dc_orden_de_pago_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `dc_orden_de_pago_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_orden_de_pago_dc_firma_id_foreign` (`dc_firma_id`),
  KEY `dc_orden_de_pago_dc_estado_id_foreign` (`dc_estado_id`),
  CONSTRAINT `dc_orden_de_pago_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `dc_orden_de_pago_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_orden_de_pago_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_orden_de_pago_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_orden_de_pago_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_de_pago`
--

LOCK TABLES `dc_orden_de_pago` WRITE;
/*!40000 ALTER TABLE `dc_orden_de_pago` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_de_pago` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_de_pago_receipts`
--

DROP TABLE IF EXISTS `dc_orden_de_pago_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_de_pago_receipts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_de_pago_id` bigint(20) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_de_pago_receipts_dc_orden_de_pago_id_foreign` (`dc_orden_de_pago_id`),
  KEY `dc_orden_de_pago_receipts_receipt_id_foreign` (`receipt_id`),
  CONSTRAINT `dc_orden_de_pago_receipts_dc_orden_de_pago_id_foreign` FOREIGN KEY (`dc_orden_de_pago_id`) REFERENCES `dc_orden_de_pago` (`id`),
  CONSTRAINT `dc_orden_de_pago_receipts_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_de_pago_receipts`
--

LOCK TABLES `dc_orden_de_pago_receipts` WRITE;
/*!40000 ALTER TABLE `dc_orden_de_pago_receipts` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_de_pago_receipts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_files`
--

DROP TABLE IF EXISTS `dc_orden_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `file` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_files_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_orden_files_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_files`
--

LOCK TABLES `dc_orden_files` WRITE;
/*!40000 ALTER TABLE `dc_orden_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes`
--

DROP TABLE IF EXISTS `dc_ordenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_tipo_id` bigint(20) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `titulo` text COLLATE utf8mb4_unicode_ci,
  `sucursal` int(11) NOT NULL DEFAULT '1',
  `numero` int(11) NOT NULL,
  `sector` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `solicitante` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `syj_empleado_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `fecha_entrega` date DEFAULT NULL,
  `fecha_asignacion` datetime DEFAULT NULL,
  `fecha_cumplido` datetime DEFAULT NULL,
  `condicion_venta_id` int(10) unsigned DEFAULT NULL,
  `is_pago_adelantado` tinyint(1) DEFAULT NULL,
  `forma_de_entrega_id` int(10) unsigned DEFAULT NULL,
  `plazo_de_pago_id` int(10) unsigned DEFAULT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(16,2) NOT NULL DEFAULT '1.00',
  `neto` decimal(16,2) NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `total` decimal(16,2) NOT NULL,
  `facturada` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dc_estado_id` bigint(20) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_cc_id` bigint(20) unsigned DEFAULT NULL,
  `origendestinoable_type` text COLLATE utf8mb4_unicode_ci,
  `origendestinoable_id` int(10) unsigned DEFAULT NULL,
  `is_multiples_ot` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `dc_orden_origen_destino_id` bigint(20) unsigned DEFAULT NULL,
  `is_completado` tinyint(1) NOT NULL DEFAULT '0',
  `dc_firma_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_dc_orden_tipo_id_foreign` (`dc_orden_tipo_id`),
  KEY `dc_ordenes_person_id_foreign` (`person_id`),
  KEY `dc_ordenes_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `dc_ordenes_dc_estado_id_foreign` (`dc_estado_id`),
  KEY `dc_ordenes_conta_cc_id_foreign` (`conta_cc_id`),
  KEY `dc_ordenes_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `dc_ordenes_dc_orden_origen_destino_id_foreign` (`dc_orden_origen_destino_id`),
  KEY `dc_ordenes_moneda_id_foreign` (`moneda_id`),
  KEY `dc_ordenes_dc_firma_id_foreign` (`dc_firma_id`),
  KEY `dc_ordenes_syj_empleado_id_foreign` (`syj_empleado_id`),
  CONSTRAINT `dc_ordenes_conta_cc_id_foreign` FOREIGN KEY (`conta_cc_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `dc_ordenes_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `dc_ordenes_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_ordenes_dc_orden_origen_destino_id_foreign` FOREIGN KEY (`dc_orden_origen_destino_id`) REFERENCES `dc_ordenes_origen_destino` (`id`),
  CONSTRAINT `dc_ordenes_dc_orden_tipo_id_foreign` FOREIGN KEY (`dc_orden_tipo_id`) REFERENCES `dc_ordenes_tipos` (`id`),
  CONSTRAINT `dc_ordenes_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `dc_ordenes_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `dc_ordenes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_ordenes_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_ordenes_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes`
--

LOCK TABLES `dc_ordenes` WRITE;
/*!40000 ALTER TABLE `dc_ordenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_compra_req`
--

DROP TABLE IF EXISTS `dc_ordenes_compra_req`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_compra_req` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_compra_req_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_compra_req_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_compra_req_dc_orden_req_id_foreign` (`dc_orden_req_id`),
  KEY `dc_ordenes_compra_req_dc_orden_req_detail_id_foreign` (`dc_orden_req_detail_id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_req_detail_id_foreign` FOREIGN KEY (`dc_orden_req_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_req_id_foreign` FOREIGN KEY (`dc_orden_req_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_compra_req`
--

LOCK TABLES `dc_ordenes_compra_req` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_compra_req` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_compra_req` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_details`
--

DROP TABLE IF EXISTS `dc_ordenes_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_origen_destino_id` bigint(20) unsigned DEFAULT NULL,
  `origendestinoable_id` int(10) unsigned DEFAULT NULL,
  `origendestinoable_type` text COLLATE utf8mb4_unicode_ci,
  `cantidades` decimal(16,2) NOT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id_destino` bigint(20) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `neto` decimal(16,2) NOT NULL,
  `desc_porc` decimal(16,2) DEFAULT NULL,
  `descuento` decimal(16,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `subtotal` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_details_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_details_inv_producto_id_foreign` (`inv_producto_id`),
  KEY `dc_ordenes_details_system_tax_id_foreign` (`system_tax_id`),
  KEY `dc_ordenes_details_inv_producto_id_destino_foreign` (`inv_producto_id_destino`),
  KEY `dc_ordenes_details_dc_orden_origen_destino_id_foreign` (`dc_orden_origen_destino_id`),
  CONSTRAINT `dc_ordenes_details_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_details_dc_orden_origen_destino_id_foreign` FOREIGN KEY (`dc_orden_origen_destino_id`) REFERENCES `dc_ordenes_origen_destino` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_producto_id_destino_foreign` FOREIGN KEY (`inv_producto_id_destino`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `dc_ordenes_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_details`
--

LOCK TABLES `dc_ordenes_details` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_facturada`
--

DROP TABLE IF EXISTS `dc_ordenes_facturada`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_facturada` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_facturada_person_id_foreign` (`person_id`),
  KEY `dc_ordenes_facturada_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_facturada_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  CONSTRAINT `dc_ordenes_facturada_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_facturada_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `dc_ordenes_facturada_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_facturada`
--

LOCK TABLES `dc_ordenes_facturada` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_facturada` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_facturada` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_ingreso_compra`
--

DROP TABLE IF EXISTS `dc_ordenes_ingreso_compra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_ingreso_compra` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_compra_id_foreign` (`dc_orden_compra_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_compra_detail_id_foreign` (`dc_orden_compra_detail_id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_compra_detail_id_foreign` FOREIGN KEY (`dc_orden_compra_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_compra_id_foreign` FOREIGN KEY (`dc_orden_compra_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_ingreso_compra`
--

LOCK TABLES `dc_ordenes_ingreso_compra` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_ingreso_compra` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_ingreso_compra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_origen_destino`
--

DROP TABLE IF EXISTS `dc_ordenes_origen_destino`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_origen_destino` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `modelo` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_deposito` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_origen_destino`
--

LOCK TABLES `dc_ordenes_origen_destino` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_origen_destino` DISABLE KEYS */;
INSERT INTO `dc_ordenes_origen_destino` VALUES (1,NULL,'Orden de Trabajo','App\\Models\\Inventario\\InvOrdenTrabajo',0,1,NULL,NULL,NULL),(2,NULL,'Centro de Costos','App\\Models\\Inventario\\InvOrdenTrabajoHorasTipo',0,1,NULL,'2023-09-12 22:17:18',NULL),(3,NULL,'Deposito','App\\Models\\Inventario\\InvDeposito',1,1,NULL,'2024-05-07 20:11:37',NULL),(4,NULL,'Empleado','App\\Models\\SyJEmpleado',0,0,NULL,'2023-07-03 22:08:00',NULL);
/*!40000 ALTER TABLE `dc_ordenes_origen_destino` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_revocadas`
--

DROP TABLE IF EXISTS `dc_ordenes_revocadas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_revocadas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `comentario` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_revocadas_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_ordenes_revocadas_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_revocadas`
--

LOCK TABLES `dc_ordenes_revocadas` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_revocadas` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_revocadas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_servicio_compra`
--

DROP TABLE IF EXISTS `dc_ordenes_servicio_compra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_servicio_compra` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_compra_id_foreign` (`dc_orden_compra_id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_compra_detail_id_foreign` (`dc_orden_compra_detail_id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_compra_detail_id_foreign` FOREIGN KEY (`dc_orden_compra_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_compra_id_foreign` FOREIGN KEY (`dc_orden_compra_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_servicio_compra`
--

LOCK TABLES `dc_ordenes_servicio_compra` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_servicio_compra` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_servicio_compra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_tipos`
--

DROP TABLE IF EXISTS `dc_ordenes_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `usabilidad` longtext COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_tipos`
--

LOCK TABLES `dc_ordenes_tipos` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_tipos` DISABLE KEYS */;
INSERT INTO `dc_ordenes_tipos` VALUES (1,NULL,'ORDEN DE COMPRAS',NULL,1,NULL,'2022-09-09 16:51:24',NULL),(2,NULL,'ORDEN DE VENTAS',NULL,1,NULL,'2022-09-09 16:51:24',NULL),(3,NULL,'PRESUPUESTO',NULL,1,NULL,NULL,NULL),(4,NULL,'REQUERIMIENTO',NULL,1,NULL,NULL,NULL),(5,NULL,'REMITO DE INGRESO',NULL,1,NULL,'2023-06-12 23:26:40',NULL),(6,NULL,'REMITO DE EGRESO',NULL,1,NULL,NULL,NULL),(7,NULL,'REMITO INTERNO',NULL,1,NULL,NULL,NULL),(8,NULL,'REMITO DE INGRESO','Es lo mismo que un remito de ingreso, \n        pero los productosa ingresar provienen de una Orden de Compra',1,NULL,NULL,NULL),(9,NULL,'REMITO DE SERVICIO','Es un remito de Ingreso de un servicio que se\n        asigna directo a una OT',1,NULL,NULL,NULL),(10,NULL,'ORDEN DE PAGO',NULL,1,'2023-09-28 16:29:20','2023-09-28 16:29:20',NULL),(11,NULL,'ANULACION REQUERIMIENTOS',NULL,1,'2024-04-02 23:06:34','2024-04-02 23:06:34',NULL),(12,NULL,'ANULACION COMPRAS PRODUCTOS',NULL,1,'2024-04-02 23:06:34','2024-04-02 23:06:34',NULL),(13,NULL,'ANULACION COMPRAS SERVICIOS',NULL,1,'2024-04-02 23:06:34','2024-04-02 23:06:34',NULL),(14,NULL,'REMITO DE GASTO',NULL,1,'2024-05-07 20:11:37','2024-05-07 20:11:37',NULL);
/*!40000 ALTER TABLE `dc_ordenes_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `deudas_impositivas`
--

DROP TABLE IF EXISTS `deudas_impositivas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `deudas_impositivas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `vto_impuesto_id` int(10) unsigned NOT NULL,
  `periodo_deuda` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `deudas_impositivas_vto_impuesto_id_foreign` (`vto_impuesto_id`),
  KEY `deudas_impositivas_person_id_foreign` (`person_id`),
  CONSTRAINT `deudas_impositivas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `deudas_impositivas_vto_impuesto_id_foreign` FOREIGN KEY (`vto_impuesto_id`) REFERENCES `vto_impuestos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `deudas_impositivas`
--

LOCK TABLES `deudas_impositivas` WRITE;
/*!40000 ALTER TABLE `deudas_impositivas` DISABLE KEYS */;
/*!40000 ALTER TABLE `deudas_impositivas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ejer_anteriores`
--

DROP TABLE IF EXISTS `ejer_anteriores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ejer_anteriores` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `anio` int(11) NOT NULL,
  `ventas` decimal(16,2) DEFAULT NULL,
  `compras` decimal(16,2) DEFAULT NULL,
  `sueldos` decimal(16,2) DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `apagar` decimal(16,2) DEFAULT NULL,
  `afavor` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ejer_anteriores_person_id_foreign` (`person_id`),
  CONSTRAINT `ejer_anteriores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ejer_anteriores`
--

LOCK TABLES `ejer_anteriores` WRITE;
/*!40000 ALTER TABLE `ejer_anteriores` DISABLE KEYS */;
/*!40000 ALTER TABLE `ejer_anteriores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estado_civil`
--

DROP TABLE IF EXISTS `estado_civil`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estado_civil` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `estado_civil_descripcion_unique` (`descripcion`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estado_civil`
--

LOCK TABLES `estado_civil` WRITE;
/*!40000 ALTER TABLE `estado_civil` DISABLE KEYS */;
INSERT INTO `estado_civil` VALUES (1,NULL,'Separado Legal',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(2,NULL,'Separado de Hecho',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(3,NULL,'Divorciado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(4,NULL,'Convivencia',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(5,NULL,'Soltero',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(6,NULL,'Casado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(7,NULL,'Viudo',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `estado_civil` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva`
--

DROP TABLE IF EXISTS `fa_masiva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva`
--

LOCK TABLES `fa_masiva` WRITE;
/*!40000 ALTER TABLE `fa_masiva` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_detalle`
--

DROP TABLE IF EXISTS `fa_masiva_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_detalle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fa_masiva_id` int(11) NOT NULL,
  `cliente_id` int(11) NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL DEFAULT '1',
  `zone_id` int(10) unsigned NOT NULL DEFAULT '22',
  `activity_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `concepto_id` int(10) unsigned NOT NULL DEFAULT '1',
  `taxable_iibb` int(10) unsigned NOT NULL DEFAULT '2',
  `renglon1` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe1` decimal(20,2) DEFAULT NULL,
  `renglon2` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe2` decimal(20,2) DEFAULT NULL,
  `renglon3` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe3` decimal(20,2) DEFAULT NULL,
  `punto_venta_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date DEFAULT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_detalle_concepto_id_foreign` (`concepto_id`),
  KEY `fa_masiva_detalle_system_tax_id_foreign` (`system_tax_id`),
  KEY `fa_masiva_detalle_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  KEY `fa_masiva_detalle_zone_id_foreign` (`zone_id`),
  KEY `fa_masiva_detalle_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fa_masiva_detalle_activity_id_foreign` (`activity_id`),
  CONSTRAINT `fa_masiva_detalle_activity_id_foreign` FOREIGN KEY (`activity_id`) REFERENCES `activities` (`id`),
  CONSTRAINT `fa_masiva_detalle_concepto_id_foreign` FOREIGN KEY (`concepto_id`) REFERENCES `fact_elec_conceptos_afip` (`id`),
  CONSTRAINT `fa_masiva_detalle_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `fac_elec_cond_frente_iva` (`id`),
  CONSTRAINT `fa_masiva_detalle_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`),
  CONSTRAINT `fa_masiva_detalle_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`),
  CONSTRAINT `fa_masiva_detalle_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_detalle`
--

LOCK TABLES `fa_masiva_detalle` WRITE;
/*!40000 ALTER TABLE `fa_masiva_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_stock`
--

DROP TABLE IF EXISTS `fa_masiva_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_stock_person_id_foreign` (`person_id`),
  KEY `fa_masiva_stock_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `fa_masiva_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fa_masiva_stock_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_stock`
--

LOCK TABLES `fa_masiva_stock` WRITE;
/*!40000 ALTER TABLE `fa_masiva_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_cond_frente_iva`
--

DROP TABLE IF EXISTS `fac_elec_cond_frente_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_cond_frente_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_cond_frente_iva_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_cond_frente_iva`
--

LOCK TABLES `fac_elec_cond_frente_iva` WRITE;
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` DISABLE KEYS */;
INSERT INTO `fac_elec_cond_frente_iva` VALUES (1,'IVA Responsable Inscripto','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'IVA Sujeto Exento','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Consumidor Final','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Responsable Monotributo','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Proveedor del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Cliente del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'IVA Liberado - Ley Nº 19.640','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'IVA Responsable Inscripto - Agente de Percepción','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Monotributista Social','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'IVA No Alcanzado','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_unidad_medidas`
--

DROP TABLE IF EXISTS `fac_elec_unidad_medidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_unidad_medidas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_unidad_medidas_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_unidad_medidas`
--

LOCK TABLES `fac_elec_unidad_medidas` WRITE;
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` DISABLE KEYS */;
INSERT INTO `fac_elec_unidad_medidas` VALUES (1,'Grs','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'Kg','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Mts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Mts2','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Mts3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Lts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'1000 Kwh','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'Unidades','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Pares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'Doc','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(11,'Quilates','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(12,'Millares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(13,'Milimetros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(14,'Mm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(15,'Km','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(16,'Hectolitros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(17,'Cm','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(18,'Cm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_conceptos_afip`
--

DROP TABLE IF EXISTS `fact_elec_conceptos_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_conceptos_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_comprobante_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_conceptos_afip`
--

LOCK TABLES `fact_elec_conceptos_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_conceptos_afip` VALUES (1,1,'Producto','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'Productos y Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_perc_ret`
--

DROP TABLE IF EXISTS `fact_elec_perc_ret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_perc_ret` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` int(10) unsigned NOT NULL,
  `other_tax_id` int(10) unsigned NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_perc_ret_other_tax_id_foreign` (`other_tax_id`),
  CONSTRAINT `fact_elec_perc_ret_other_tax_id_foreign` FOREIGN KEY (`other_tax_id`) REFERENCES `other_taxes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_perc_ret`
--

LOCK TABLES `fact_elec_perc_ret` WRITE;
/*!40000 ALTER TABLE `fact_elec_perc_ret` DISABLE KEYS */;
INSERT INTO `fact_elec_perc_ret` VALUES (1,NULL,'Per./Ret de Imp. a las Ganancias',1,1032,1,NULL,NULL,NULL),(2,NULL,'Per./Ret de IVA',1,1000,1,NULL,NULL,NULL),(3,NULL,'Per./Ret de IIBB',2,1006,1,NULL,NULL,NULL),(4,NULL,'Impuestos Internos',4,1001,1,NULL,NULL,NULL),(5,NULL,'Impuestos Municipales',3,1031,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `fact_elec_perc_ret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_perc_ret_details`
--

DROP TABLE IF EXISTS `fact_elec_perc_ret_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_perc_ret_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fact_elec_perc_ret_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `detalle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zone_id` int(10) unsigned DEFAULT NULL,
  `base_imponible` decimal(16,2) DEFAULT NULL,
  `alicuota` decimal(16,2) DEFAULT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_perc_ret_details_fact_elec_perc_ret_id_foreign` (`fact_elec_perc_ret_id`),
  KEY `fact_elec_perc_ret_details_person_id_foreign` (`person_id`),
  KEY `fact_elec_perc_ret_details_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `fact_elec_perc_ret_details_zone_id_foreign` (`zone_id`),
  CONSTRAINT `fact_elec_perc_ret_details_fact_elec_perc_ret_id_foreign` FOREIGN KEY (`fact_elec_perc_ret_id`) REFERENCES `fact_elec_perc_ret` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_perc_ret_details`
--

LOCK TABLES `fact_elec_perc_ret_details` WRITE;
/*!40000 ALTER TABLE `fact_elec_perc_ret_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_perc_ret_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_puntos_venta`
--

DROP TABLE IF EXISTS `fact_elec_puntos_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_puntos_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `direccion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `codigo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '0000',
  `codigo_postal` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_puntos_venta_person_id_foreign` (`person_id`),
  CONSTRAINT `fact_elec_puntos_venta_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_puntos_venta`
--

LOCK TABLES `fact_elec_puntos_venta` WRITE;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipt_details`
--

DROP TABLE IF EXISTS `fact_elec_receipt_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipt_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cantidad` decimal(20,2) NOT NULL,
  `unidad_medida` text COLLATE utf8mb4_unicode_ci,
  `precio_unitario` decimal(20,2) NOT NULL,
  `neto_gravado` decimal(20,2) NOT NULL,
  `bonificacion_porcentaje` decimal(20,2) DEFAULT NULL,
  `bonificacion_monto` decimal(20,2) DEFAULT NULL,
  `bonificacion_subtotal` decimal(20,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `iva_monto` decimal(20,2) DEFAULT NULL,
  `iva_subtotal` decimal(20,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `codigo` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipt_details_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `fact_elec_receipt_details_system_tax_id_foreign` (`system_tax_id`),
  CONSTRAINT `fact_elec_receipt_details_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `fact_elec_receipt_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipt_details`
--

LOCK TABLES `fact_elec_receipt_details` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipt_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_receipt_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipts`
--

DROP TABLE IF EXISTS `fact_elec_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date NOT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `concepto_id` int(10) unsigned NOT NULL,
  `punto_venta_id` int(10) unsigned NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL,
  `condiciones_venta` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comprobante_asoc` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `cae` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cae_vencimiento` date DEFAULT NULL,
  `nro_comprobante_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_proceso_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_receptor` int(10) unsigned NOT NULL,
  `condicion_venta_id` int(11) DEFAULT NULL,
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `opcion_transferencia` longtext COLLATE utf8mb4_unicode_ci,
  `referencia` text COLLATE utf8mb4_unicode_ci,
  `alias_cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_otros_tributos` decimal(16,2) DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipts_user_id_foreign` (`user_id`),
  KEY `fact_elec_receipts_punto_venta_id_foreign` (`punto_venta_id`),
  KEY `fact_elec_receipts_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fact_elec_receipts_person_id_foreign` (`person_id`),
  KEY `fact_elec_receipts_person_id_receptor_foreign` (`person_id_receptor`),
  KEY `fact_elec_receipts_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  KEY `fact_elec_receipts_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `fact_elec_receipts_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `condicion_frente_al_iva` (`id`),
  CONSTRAINT `fact_elec_receipts_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_receptor_foreign` FOREIGN KEY (`person_id_receptor`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_punto_venta_id_foreign` FOREIGN KEY (`punto_venta_id`) REFERENCES `fact_elec_puntos_venta` (`id`),
  CONSTRAINT `fact_elec_receipts_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipts`
--

LOCK TABLES `fact_elec_receipts` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipts` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_receipts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_tipos_docs_afip`
--

DROP TABLE IF EXISTS `fact_elec_tipos_docs_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_tipos_docs_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_tipo_doc_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_tipos_docs_afip`
--

LOCK TABLES `fact_elec_tipos_docs_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_tipos_docs_afip` VALUES (1,1,'CI Buenos Aires','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'CI Catamarca','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'CI Córdoba','2019-03-13 13:29:34','2019-03-13 13:29:34'),(4,4,'CI Corrientes','2019-03-13 13:29:34','2019-03-13 13:29:34'),(5,5,'CI Entre Ríos','2019-03-13 13:29:34','2019-03-13 13:29:34'),(6,6,'CI Jujuy','2019-03-13 13:29:34','2019-03-13 13:29:34'),(7,7,'CI Mendoza','2019-03-13 13:29:34','2019-03-13 13:29:34'),(8,8,'CI La Rioja','2019-03-13 13:29:34','2019-03-13 13:29:34'),(9,9,'CI Salta','2019-03-13 13:29:34','2019-03-13 13:29:34'),(10,10,'CI San Juan','2019-03-13 13:29:34','2019-03-13 13:29:34'),(11,11,'CI San Luis','2019-03-13 13:29:34','2019-03-13 13:29:34'),(12,12,'CI Santa Fe','2019-03-13 13:29:34','2019-03-13 13:29:34'),(13,13,'CI Santiago del Estero','2019-03-13 13:29:34','2019-03-13 13:29:34'),(14,14,'CI Tucumán','2019-03-13 13:29:34','2019-03-13 13:29:34'),(16,16,'CI Chaco','2019-03-13 13:29:34','2019-03-13 13:29:34'),(17,17,'CI Chubut','2019-03-13 13:29:34','2019-03-13 13:29:34'),(18,18,'CI Formosa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(19,19,'CI Misiones','2019-03-13 13:29:34','2019-03-13 13:29:34'),(20,20,'CI Neuquén','2019-03-13 13:29:34','2019-03-13 13:29:34'),(21,21,'CI La Pampa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(22,22,'CI Río Negro','2019-03-13 13:29:34','2019-03-13 13:29:34'),(23,23,'CI Santa Cruz','2019-03-13 13:29:34','2019-03-13 13:29:34'),(24,24,'CI Tierra del Fuego','2019-03-13 13:29:34','2019-03-13 13:29:34'),(80,80,'CUIT','2019-03-13 13:29:34','2019-03-13 13:29:34'),(86,86,'CUIL','2019-03-13 13:29:34','2019-03-13 13:29:34'),(87,87,'CDI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(89,89,'LE','2019-03-13 13:29:34','2019-03-13 13:29:34'),(90,90,'LC','2019-03-13 13:29:34','2019-03-13 13:29:34'),(91,91,'CI Extranjera','2019-03-13 13:29:34','2019-03-13 13:29:34'),(92,92,'en trámite','2019-03-13 13:29:34','2019-03-13 13:29:34'),(93,93,'Acta Nacimiento','2019-03-13 13:29:34','2019-03-13 13:29:34'),(94,94,'Pasaporte','2019-03-13 13:29:34','2019-03-13 13:29:34'),(95,95,'CI Bs. As. RNP','2019-03-13 13:29:34','2019-03-13 13:29:34'),(96,96,'DNI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(97,0,'CI Policía Federal','2019-03-13 13:29:34','2019-03-13 13:29:34'),(99,99,'Doc. (Otro)','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
INSERT INTO `failed_jobs` VALUES (1,NULL,'finance','finance','{\"uuid\":\"dec75f74-2188-44e8-8966-94679caea606\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":9:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":4:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:11:\\\"controlador\\\";s:55:\\\"\\\\App\\\\Http\\\\Controllers\\\\Data\\\\BOTMisComprobantesController\\\";s:6:\\\"metodo\\\";s:21:\\\"Execute_Bot_Descargar\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":11:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:4:\\\"user\\\";O:8:\\\"App\\\\User\\\":28:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:6:\\\"tusers\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:6:\\\"idUser\\\";s:11:\\\"\\u0000*\\u0000fillable\\\";a:12:{i:0;s:6:\\\"nombre\\\";i:1;s:9:\\\"loginUser\\\";i:2;s:9:\\\"emailUser\\\";i:3;s:5:\\\"clave\\\";i:4;s:9:\\\"claveUser\\\";i:5;s:10:\\\"statusUser\\\";i:6;s:12:\\\"user_type_id\\\";i:7;s:5:\\\"firma\\\";i:8;s:15:\\\"suscrip_plan_id\\\";i:9;s:7:\\\"importe\\\";i:10;s:6:\\\"avatar\\\";i:11;s:18:\\\"es_empresa_externa\\\";}s:9:\\\"\\u0000*\\u0000hidden\\\";a:4:{i:0;s:8:\\\"password\\\";i:1;s:14:\\\"remember_token\\\";i:2;s:9:\\\"claveUser\\\";i:3;s:5:\\\"clave\\\";}s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:17:{s:6:\\\"idUser\\\";i:7479;s:6:\\\"nombre\\\";s:15:\\\"Gramajo Valeria\\\";s:9:\\\"loginUser\\\";s:16:\\\"vag730@gmail.com\\\";s:9:\\\"emailUser\\\";s:16:\\\"vag730@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27271787303\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$22PcHpDd5yh.X\\/iVCxAAJeeMbXZL\\/LfNDf33f7B8V9FiXlwHpR4Hy\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";s:6:\\\"person\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:21:{s:2:\\\"id\\\";i:47165;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:15:\\\"Gramajo Valeria\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-27178730-3\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:21:{s:2:\\\"id\\\";i:47165;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:15:\\\"Gramajo Valeria\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-27178730-3\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}s:11:\\\"\\u0000*\\u0000original\\\";a:16:{s:6:\\\"idUser\\\";i:7479;s:6:\\\"nombre\\\";s:15:\\\"Gramajo Valeria\\\";s:9:\\\"loginUser\\\";s:16:\\\"vag730@gmail.com\\\";s:9:\\\"emailUser\\\";s:16:\\\"vag730@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27271787303\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$22PcHpDd5yh.X\\/iVCxAAJeeMbXZL\\/LfNDf33f7B8V9FiXlwHpR4Hy\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:1:{i:0;s:1:\\\"*\\\";}s:20:\\\"\\u0000*\\u0000rememberTokenName\\\";s:14:\\\"remember_token\\\";}s:15:\\\"cuit_user_admin\\\";s:15:\\\"\'27-27178730-3\'\\\";s:23:\\\"cuit_administrador_afip\\\";s:11:\\\"27402754546\\\";s:12:\\\"clave_fiscal\\\";s:10:\\\"Flor056544\\\";s:12:\\\"cuit_empresa\\\";s:13:\\\"27-40275454-6\\\";s:5:\\\"sitio\\\";s:12:\\\"taxes.com.ar\\\";s:9:\\\"operacion\\\";s:9:\\\"Recibidos\\\";s:7:\\\"periodo\\\";s:10:\\\"Mes Pasado\\\";s:12:\\\"path_of_file\\\";O:21:\\\"App\\\\Models\\\\PathOfFile\\\":28:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:12:\\\"path_of_file\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:1;s:13:\\\"\\u0000*\\u0000attributes\\\";a:6:{s:7:\\\"user_id\\\";i:7479;s:20:\\\"path_of_file_name_id\\\";i:6;s:11:\\\"descripcion\\\";s:51:\\\"ALVAREZ FLORENCIA Comprobantes Recibidos Mes Pasado\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 19:20:54\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 19:20:54\\\";s:2:\\\"id\\\";i:2;}s:11:\\\"\\u0000*\\u0000original\\\";a:6:{s:7:\\\"user_id\\\";i:7479;s:20:\\\"path_of_file_name_id\\\";i:6;s:11:\\\"descripcion\\\";s:51:\\\"ALVAREZ FLORENCIA Comprobantes Recibidos Mes Pasado\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 19:20:54\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 19:20:54\\\";s:2:\\\"id\\\";i:2;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:1:{i:0;s:10:\\\"deleted_at\\\";}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}s:4:\\\"path\\\";s:14:\\\"27-27178730-3\\/\\\";}}s:3:\\\"job\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";s:7:\\\"finance\\\";s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}','Symfony\\Component\\Process\\Exception\\ProcessTimedOutException: The process \"node /home/forge/taxes.com.ar/resources/js/puppeteer/ImportarMisComprobantes.js 27402754546 Flor056544 27-40275454-6 Recibidos \"Mes Pasado\" \'27-27178730-3\'\" exceeded the timeout of 60 seconds. in /home/forge/taxes.com.ar/vendor/symfony/process/Process.php:1213\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(425): Symfony\\Component\\Process\\Process->checkTimeout()\n#1 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(249): Symfony\\Component\\Process\\Process->wait()\n#2 /home/forge/taxes.com.ar/app/Http/Controllers/Data/BOTMisComprobantesController.php(94): Symfony\\Component\\Process\\Process->run()\n#3 /home/forge/taxes.com.ar/app/Jobs/QueueGenerica.php(36): App\\Http\\Controllers\\Data\\BOTMisComprobantesController->Execute_Bot_Descargar(Object(Illuminate\\Support\\Collection))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): App\\Jobs\\QueueGenerica->handle()\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(94): Illuminate\\Container\\Container->call(Array)\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#12 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(98): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(83): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(App\\Jobs\\QueueGenerica), false)\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#15 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#16 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(85): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(59): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(App\\Queue\\DatabaseJob), Object(App\\Jobs\\QueueGenerica))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(App\\Queue\\DatabaseJob), Array)\n#19 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(26): Illuminate\\Queue\\Jobs\\Job->fire()\n#20 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#21 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'finance\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#22 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(265): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#23 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->runNextJob(\'finance\', \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#24 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'finance\', \'finance\')\n#25 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#26 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#27 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#28 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#29 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#30 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#31 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#32 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#33 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#34 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#35 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#36 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#37 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#38 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#39 {main}','2022-07-29 19:21:55',NULL);
INSERT INTO `failed_jobs` VALUES (2,NULL,'finance','finance','{\"uuid\":\"6b6791ed-a657-4f1f-a843-a4a01b5313e2\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":9:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":5:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:11:\\\"controlador\\\";s:53:\\\"\\\\App\\\\Http\\\\Controllers\\\\Taxes\\\\BOTCopiarEnAfipController\\\";s:6:\\\"metodo\\\";s:26:\\\"Execute_Bot_Copiar_en_Afip\\\";s:12:\\\"metodo_error\\\";s:15:\\\"error_queue_bot\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":7:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:4:\\\"user\\\";O:8:\\\"App\\\\User\\\":28:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:6:\\\"tusers\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:6:\\\"idUser\\\";s:11:\\\"\\u0000*\\u0000fillable\\\";a:12:{i:0;s:6:\\\"nombre\\\";i:1;s:9:\\\"loginUser\\\";i:2;s:9:\\\"emailUser\\\";i:3;s:5:\\\"clave\\\";i:4;s:9:\\\"claveUser\\\";i:5;s:10:\\\"statusUser\\\";i:6;s:12:\\\"user_type_id\\\";i:7;s:5:\\\"firma\\\";i:8;s:15:\\\"suscrip_plan_id\\\";i:9;s:7:\\\"importe\\\";i:10;s:6:\\\"avatar\\\";i:11;s:18:\\\"es_empresa_externa\\\";}s:9:\\\"\\u0000*\\u0000hidden\\\";a:4:{i:0;s:8:\\\"password\\\";i:1;s:14:\\\"remember_token\\\";i:2;s:9:\\\"claveUser\\\";i:3;s:5:\\\"clave\\\";}s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:17:{s:6:\\\"idUser\\\";i:7479;s:6:\\\"nombre\\\";s:15:\\\"Gramajo Valeria\\\";s:9:\\\"loginUser\\\";s:16:\\\"vag730@gmail.com\\\";s:9:\\\"emailUser\\\";s:16:\\\"vag730@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27271787303\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$22PcHpDd5yh.X\\/iVCxAAJeeMbXZL\\/LfNDf33f7B8V9FiXlwHpR4Hy\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";s:6:\\\"person\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:21:{s:2:\\\"id\\\";i:47165;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:15:\\\"Gramajo Valeria\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-27178730-3\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:21:{s:2:\\\"id\\\";i:47165;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:15:\\\"Gramajo Valeria\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-27178730-3\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}s:11:\\\"\\u0000*\\u0000original\\\";a:16:{s:6:\\\"idUser\\\";i:7479;s:6:\\\"nombre\\\";s:15:\\\"Gramajo Valeria\\\";s:9:\\\"loginUser\\\";s:16:\\\"vag730@gmail.com\\\";s:9:\\\"emailUser\\\";s:16:\\\"vag730@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27271787303\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$22PcHpDd5yh.X\\/iVCxAAJeeMbXZL\\/LfNDf33f7B8V9FiXlwHpR4Hy\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:1:{i:0;s:1:\\\"*\\\";}s:20:\\\"\\u0000*\\u0000rememberTokenName\\\";s:14:\\\"remember_token\\\";}s:23:\\\"cuit_administrador_afip\\\";s:11:\\\"27402754546\\\";s:12:\\\"clave_fiscal\\\";s:10:\\\"Flor056544\\\";s:5:\\\"sitio\\\";s:12:\\\"taxes.com.ar\\\";s:6:\\\"settle\\\";O:28:\\\"App\\\\Models\\\\PeriodLiquidation\\\":28:{s:8:\\\"\\u0000*\\u0000table\\\";s:19:\\\"period_liquidations\\\";s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:9:\\\"\\u0000*\\u0000hidden\\\";a:2:{i:0;s:10:\\\"created_at\\\";i:1;s:10:\\\"updated_at\\\";}s:10:\\\"\\u0000*\\u0000appends\\\";a:1:{i:0;s:15:\\\"files_relations\\\";}s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:10:{s:2:\\\"id\\\";i:4;s:7:\\\"user_id\\\";i:7479;s:8:\\\"apply_to\\\";s:4:\\\"iibb\\\";s:9:\\\"period_id\\\";i:4532;s:9:\\\"person_id\\\";i:40722;s:6:\\\"status\\\";i:1;s:11:\\\"auxiliar_id\\\";i:3619;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 19:34:01\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 19:34:16\\\";s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:10:{s:2:\\\"id\\\";i:4;s:7:\\\"user_id\\\";i:7479;s:8:\\\"apply_to\\\";s:4:\\\"iibb\\\";s:9:\\\"period_id\\\";i:4532;s:9:\\\"person_id\\\";i:40722;s:6:\\\"status\\\";i:1;s:11:\\\"auxiliar_id\\\";i:3619;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 19:34:01\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 19:34:16\\\";s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:2:{s:11:\\\"auxiliar_id\\\";i:3619;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 19:34:16\\\";}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:1:{i:0;s:10:\\\"deleted_at\\\";}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}s:8:\\\"auxiliar\\\";O:19:\\\"App\\\\Models\\\\Auxiliar\\\":27:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:8:\\\"auxiliar\\\";s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:1;s:13:\\\"\\u0000*\\u0000attributes\\\";a:5:{s:11:\\\"descripcion\\\";s:7576:\\\"{\\\"group_person_zone_actividad\\\":[{\\\"id\\\":7,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"actividad_id\\\":856,\\\"calculo_iibb\\\":1,\\\"coef\\\":\\\"0.00000\\\",\\\"alicuota\\\":\\\"0.00000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T22:20:13.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:20:13.000000Z\\\",\\\"deleted_at\\\":null,\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null},\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null}}],\\\"person\\\":{\\\"id\\\":40722,\\\"user_id\\\":7479,\\\"field_name1\\\":\\\"ALVAREZ FLORENCIA\\\",\\\"field_name2\\\":null,\\\"document_type\\\":\\\"cuit\\\",\\\"document\\\":\\\"27-40275454-6\\\",\\\"cond_frente_al_iva_id\\\":null,\\\"country_id\\\":null,\\\"state_id\\\":null,\\\"zone_id\\\":null,\\\"plan_cuenta_id\\\":null,\\\"iva_creditos_tipo_id\\\":null,\\\"created_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"activity_id\\\":null,\\\"address\\\":null,\\\"person_type_id\\\":1,\\\"fa_iva_condition_id\\\":null,\\\"fa_codigo_postal\\\":null,\\\"email\\\":null,\\\"deleted_at\\\":null,\\\"person_config\\\":{\\\"id\\\":5,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"period_id\\\":null,\\\"zone_id\\\":null,\\\"settle_calc_by_coef\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:10:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:20:13.000000Z\\\",\\\"active\\\":2,\\\"enviarMail\\\":1,\\\"honorario\\\":\\\"0.00\\\",\\\"cta_cte_tesoreria_cuenta_id\\\":null,\\\"month_close\\\":12,\\\"iva_condition_id\\\":1,\\\"obligation_sell\\\":1,\\\"obligation_buy\\\":1,\\\"obligation_iva\\\":0,\\\"obligation_electronic_receipt\\\":0,\\\"obligation_iibb\\\":4,\\\"obligation_other_taxes\\\":null,\\\"liquidation_start_period\\\":\\\"2022-05\\\",\\\"obligation_salaries\\\":0,\\\"empleada_domestica\\\":0,\\\"prorratear_iva\\\":0,\\\"is_itc\\\":0,\\\"priority_order\\\":null,\\\"person_id_administrador\\\":40722,\\\"person_id_titular\\\":40722,\\\"logo_path\\\":null,\\\"certificado_afip_path\\\":null,\\\"llave_afip_path\\\":null,\\\"access_electronic_receipt\\\":0,\\\"ruta_logo_fa\\\":null,\\\"inicio_actividades\\\":\\\"2022-07-29T03:00:00.000000Z\\\",\\\"iibb\\\":null,\\\"fe_leyenda\\\":null,\\\"atencion_iva\\\":0,\\\"atencion_iva_comentario\\\":null,\\\"atencion_iibb\\\":1,\\\"atencion_iibb_comentario\\\":null,\\\"deleted_at\\\":null}},\\\"settle\\\":{\\\"id\\\":4,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period\\\":{\\\"id\\\":4532,\\\"user_id\\\":null,\\\"code\\\":\\\"2022-06\\\",\\\"year\\\":2022,\\\"period_number\\\":6,\\\"date_from\\\":\\\"2022-06-01\\\",\\\"date_to\\\":\\\"2022-06-30\\\",\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"person_id\\\":40722,\\\"conta_status\\\":0,\\\"deleted_at\\\":null,\\\"syj_periods_status_id\\\":1,\\\"syj_sin_asiento\\\":0,\\\"syj_asiento_modificado\\\":0,\\\"syj_periods_status_emp_dom_id\\\":1}},\\\"registros\\\":{\\\"id\\\":4,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period_liquidation_iibb\\\":[{\\\"id\\\":7,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":4,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"base_amount\\\":\\\"442268.00\\\",\\\"impuesto\\\":\\\"0.00\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"0.00\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":22,\\\"name\\\":\\\"Capital Federal\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"01\\\",\\\"sircreb_plan_cuenta_id\\\":277,\\\"codigo_cm\\\":901,\\\"codigo_afip\\\":\\\"0\\\"},\\\"details\\\":[{\\\"id\\\":7,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":4,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"0.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"0.00\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":8,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":4,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"0.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":442268,\\\"tax_amount\\\":0,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]},{\\\"id\\\":8,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":4,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"base_amount\\\":\\\"442268.00\\\",\\\"impuesto\\\":\\\"0.00\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"0.00\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":23,\\\"name\\\":\\\"Buenos Aires\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"02\\\",\\\"sircreb_plan_cuenta_id\\\":276,\\\"codigo_cm\\\":902,\\\"codigo_afip\\\":\\\"1\\\"},\\\"details\\\":[{\\\"id\\\":7,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":4,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"0.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":442268,\\\"tax_amount\\\":0,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":8,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":4,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"0.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"0.00\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]}]}}\\\";s:7:\\\"user_id\\\";i:7479;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 19:34:16\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 19:34:16\\\";s:2:\\\"id\\\";i:3619;}s:11:\\\"\\u0000*\\u0000original\\\";a:5:{s:11:\\\"descripcion\\\";s:7576:\\\"{\\\"group_person_zone_actividad\\\":[{\\\"id\\\":7,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"actividad_id\\\":856,\\\"calculo_iibb\\\":1,\\\"coef\\\":\\\"0.00000\\\",\\\"alicuota\\\":\\\"0.00000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T22:20:13.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:20:13.000000Z\\\",\\\"deleted_at\\\":null,\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null},\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null}}],\\\"person\\\":{\\\"id\\\":40722,\\\"user_id\\\":7479,\\\"field_name1\\\":\\\"ALVAREZ FLORENCIA\\\",\\\"field_name2\\\":null,\\\"document_type\\\":\\\"cuit\\\",\\\"document\\\":\\\"27-40275454-6\\\",\\\"cond_frente_al_iva_id\\\":null,\\\"country_id\\\":null,\\\"state_id\\\":null,\\\"zone_id\\\":null,\\\"plan_cuenta_id\\\":null,\\\"iva_creditos_tipo_id\\\":null,\\\"created_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"activity_id\\\":null,\\\"address\\\":null,\\\"person_type_id\\\":1,\\\"fa_iva_condition_id\\\":null,\\\"fa_codigo_postal\\\":null,\\\"email\\\":null,\\\"deleted_at\\\":null,\\\"person_config\\\":{\\\"id\\\":5,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"period_id\\\":null,\\\"zone_id\\\":null,\\\"settle_calc_by_coef\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:10:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:20:13.000000Z\\\",\\\"active\\\":2,\\\"enviarMail\\\":1,\\\"honorario\\\":\\\"0.00\\\",\\\"cta_cte_tesoreria_cuenta_id\\\":null,\\\"month_close\\\":12,\\\"iva_condition_id\\\":1,\\\"obligation_sell\\\":1,\\\"obligation_buy\\\":1,\\\"obligation_iva\\\":0,\\\"obligation_electronic_receipt\\\":0,\\\"obligation_iibb\\\":4,\\\"obligation_other_taxes\\\":null,\\\"liquidation_start_period\\\":\\\"2022-05\\\",\\\"obligation_salaries\\\":0,\\\"empleada_domestica\\\":0,\\\"prorratear_iva\\\":0,\\\"is_itc\\\":0,\\\"priority_order\\\":null,\\\"person_id_administrador\\\":40722,\\\"person_id_titular\\\":40722,\\\"logo_path\\\":null,\\\"certificado_afip_path\\\":null,\\\"llave_afip_path\\\":null,\\\"access_electronic_receipt\\\":0,\\\"ruta_logo_fa\\\":null,\\\"inicio_actividades\\\":\\\"2022-07-29T03:00:00.000000Z\\\",\\\"iibb\\\":null,\\\"fe_leyenda\\\":null,\\\"atencion_iva\\\":0,\\\"atencion_iva_comentario\\\":null,\\\"atencion_iibb\\\":1,\\\"atencion_iibb_comentario\\\":null,\\\"deleted_at\\\":null}},\\\"settle\\\":{\\\"id\\\":4,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period\\\":{\\\"id\\\":4532,\\\"user_id\\\":null,\\\"code\\\":\\\"2022-06\\\",\\\"year\\\":2022,\\\"period_number\\\":6,\\\"date_from\\\":\\\"2022-06-01\\\",\\\"date_to\\\":\\\"2022-06-30\\\",\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"person_id\\\":40722,\\\"conta_status\\\":0,\\\"deleted_at\\\":null,\\\"syj_periods_status_id\\\":1,\\\"syj_sin_asiento\\\":0,\\\"syj_asiento_modificado\\\":0,\\\"syj_periods_status_emp_dom_id\\\":1}},\\\"registros\\\":{\\\"id\\\":4,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period_liquidation_iibb\\\":[{\\\"id\\\":7,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":4,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"base_amount\\\":\\\"442268.00\\\",\\\"impuesto\\\":\\\"0.00\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"0.00\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":22,\\\"name\\\":\\\"Capital Federal\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"01\\\",\\\"sircreb_plan_cuenta_id\\\":277,\\\"codigo_cm\\\":901,\\\"codigo_afip\\\":\\\"0\\\"},\\\"details\\\":[{\\\"id\\\":7,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":4,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"0.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"0.00\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":8,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":4,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"0.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":442268,\\\"tax_amount\\\":0,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]},{\\\"id\\\":8,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":4,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"base_amount\\\":\\\"442268.00\\\",\\\"impuesto\\\":\\\"0.00\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"0.00\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":23,\\\"name\\\":\\\"Buenos Aires\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"02\\\",\\\"sircreb_plan_cuenta_id\\\":276,\\\"codigo_cm\\\":902,\\\"codigo_afip\\\":\\\"1\\\"},\\\"details\\\":[{\\\"id\\\":7,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":4,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"0.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":442268,\\\"tax_amount\\\":0,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":8,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":4,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"0.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"0.00\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:34:01.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]}]}}\\\";s:7:\\\"user_id\\\";i:7479;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 19:34:16\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 19:34:16\\\";s:2:\\\"id\\\";i:3619;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}}s:3:\\\"job\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";s:7:\\\"finance\\\";s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}','Symfony\\Component\\Process\\Exception\\ProcessTimedOutException: The process \"node /home/forge/taxes.com.ar/resources/js/puppeteer/CMCopiarValoresEnDDJJ.js 27402754546 Flor056544 3619\" exceeded the timeout of 60 seconds. in /home/forge/taxes.com.ar/vendor/symfony/process/Process.php:1213\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(425): Symfony\\Component\\Process\\Process->checkTimeout()\n#1 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(249): Symfony\\Component\\Process\\Process->wait()\n#2 /home/forge/taxes.com.ar/app/Http/Controllers/Taxes/BOTCopiarEnAfipController.php(83): Symfony\\Component\\Process\\Process->run()\n#3 /home/forge/taxes.com.ar/app/Jobs/QueueGenerica.php(36): App\\Http\\Controllers\\Taxes\\BOTCopiarEnAfipController->Execute_Bot_Copiar_en_Afip(Object(Illuminate\\Support\\Collection))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): App\\Jobs\\QueueGenerica->handle()\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(94): Illuminate\\Container\\Container->call(Array)\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#12 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(98): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(83): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(App\\Jobs\\QueueGenerica), false)\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#15 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#16 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(85): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(59): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(App\\Queue\\DatabaseJob), Object(App\\Jobs\\QueueGenerica))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(App\\Queue\\DatabaseJob), Array)\n#19 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(26): Illuminate\\Queue\\Jobs\\Job->fire()\n#20 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#21 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'finance\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#22 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(265): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#23 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->runNextJob(\'finance\', \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#24 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'finance\', \'finance\')\n#25 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#26 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#27 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#28 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#29 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#30 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#31 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#32 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#33 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#34 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#35 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#36 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#37 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#38 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#39 {main}','2022-07-29 19:35:17',NULL);
INSERT INTO `failed_jobs` VALUES (3,NULL,'finance','finance','{\"uuid\":\"4d231483-7a40-4ec7-9218-d59d9082e757\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":9:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":5:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:11:\\\"controlador\\\";s:53:\\\"\\\\App\\\\Http\\\\Controllers\\\\Taxes\\\\BOTCopiarEnAfipController\\\";s:6:\\\"metodo\\\";s:26:\\\"Execute_Bot_Copiar_en_Afip\\\";s:12:\\\"metodo_error\\\";s:15:\\\"error_queue_bot\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":7:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:4:\\\"user\\\";O:8:\\\"App\\\\User\\\":28:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:6:\\\"tusers\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:6:\\\"idUser\\\";s:11:\\\"\\u0000*\\u0000fillable\\\";a:12:{i:0;s:6:\\\"nombre\\\";i:1;s:9:\\\"loginUser\\\";i:2;s:9:\\\"emailUser\\\";i:3;s:5:\\\"clave\\\";i:4;s:9:\\\"claveUser\\\";i:5;s:10:\\\"statusUser\\\";i:6;s:12:\\\"user_type_id\\\";i:7;s:5:\\\"firma\\\";i:8;s:15:\\\"suscrip_plan_id\\\";i:9;s:7:\\\"importe\\\";i:10;s:6:\\\"avatar\\\";i:11;s:18:\\\"es_empresa_externa\\\";}s:9:\\\"\\u0000*\\u0000hidden\\\";a:4:{i:0;s:8:\\\"password\\\";i:1;s:14:\\\"remember_token\\\";i:2;s:9:\\\"claveUser\\\";i:3;s:5:\\\"clave\\\";}s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:17:{s:6:\\\"idUser\\\";i:7479;s:6:\\\"nombre\\\";s:15:\\\"Gramajo Valeria\\\";s:9:\\\"loginUser\\\";s:16:\\\"vag730@gmail.com\\\";s:9:\\\"emailUser\\\";s:16:\\\"vag730@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27271787303\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$22PcHpDd5yh.X\\/iVCxAAJeeMbXZL\\/LfNDf33f7B8V9FiXlwHpR4Hy\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";s:6:\\\"person\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:21:{s:2:\\\"id\\\";i:47165;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:15:\\\"Gramajo Valeria\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-27178730-3\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:21:{s:2:\\\"id\\\";i:47165;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:15:\\\"Gramajo Valeria\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-27178730-3\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}s:11:\\\"\\u0000*\\u0000original\\\";a:16:{s:6:\\\"idUser\\\";i:7479;s:6:\\\"nombre\\\";s:15:\\\"Gramajo Valeria\\\";s:9:\\\"loginUser\\\";s:16:\\\"vag730@gmail.com\\\";s:9:\\\"emailUser\\\";s:16:\\\"vag730@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27271787303\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$22PcHpDd5yh.X\\/iVCxAAJeeMbXZL\\/LfNDf33f7B8V9FiXlwHpR4Hy\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:1:{i:0;s:1:\\\"*\\\";}s:20:\\\"\\u0000*\\u0000rememberTokenName\\\";s:14:\\\"remember_token\\\";}s:23:\\\"cuit_administrador_afip\\\";s:11:\\\"27402754546\\\";s:12:\\\"clave_fiscal\\\";s:10:\\\"Flor056544\\\";s:5:\\\"sitio\\\";s:12:\\\"taxes.com.ar\\\";s:6:\\\"settle\\\";O:28:\\\"App\\\\Models\\\\PeriodLiquidation\\\":28:{s:8:\\\"\\u0000*\\u0000table\\\";s:19:\\\"period_liquidations\\\";s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:9:\\\"\\u0000*\\u0000hidden\\\";a:2:{i:0;s:10:\\\"created_at\\\";i:1;s:10:\\\"updated_at\\\";}s:10:\\\"\\u0000*\\u0000appends\\\";a:1:{i:0;s:15:\\\"files_relations\\\";}s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:10:{s:2:\\\"id\\\";i:5;s:7:\\\"user_id\\\";i:7479;s:8:\\\"apply_to\\\";s:4:\\\"iibb\\\";s:9:\\\"period_id\\\";i:4532;s:9:\\\"person_id\\\";i:40722;s:6:\\\"status\\\";i:1;s:11:\\\"auxiliar_id\\\";i:3620;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 19:49:14\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 19:49:41\\\";s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:10:{s:2:\\\"id\\\";i:5;s:7:\\\"user_id\\\";i:7479;s:8:\\\"apply_to\\\";s:4:\\\"iibb\\\";s:9:\\\"period_id\\\";i:4532;s:9:\\\"person_id\\\";i:40722;s:6:\\\"status\\\";i:1;s:11:\\\"auxiliar_id\\\";i:3620;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 19:49:14\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 19:49:41\\\";s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:2:{s:11:\\\"auxiliar_id\\\";i:3620;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 19:49:41\\\";}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:1:{i:0;s:10:\\\"deleted_at\\\";}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}s:8:\\\"auxiliar\\\";O:19:\\\"App\\\\Models\\\\Auxiliar\\\":27:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:8:\\\"auxiliar\\\";s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:1;s:13:\\\"\\u0000*\\u0000attributes\\\";a:5:{s:11:\\\"descripcion\\\";s:7579:\\\"{\\\"group_person_zone_actividad\\\":[{\\\"id\\\":9,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"actividad_id\\\":856,\\\"calculo_iibb\\\":1,\\\"coef\\\":\\\"0.00000\\\",\\\"alicuota\\\":\\\"0.00000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T22:48:51.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:48:51.000000Z\\\",\\\"deleted_at\\\":null,\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null},\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null}}],\\\"person\\\":{\\\"id\\\":40722,\\\"user_id\\\":7479,\\\"field_name1\\\":\\\"ALVAREZ FLORENCIA\\\",\\\"field_name2\\\":null,\\\"document_type\\\":\\\"cuit\\\",\\\"document\\\":\\\"27-40275454-6\\\",\\\"cond_frente_al_iva_id\\\":null,\\\"country_id\\\":null,\\\"state_id\\\":null,\\\"zone_id\\\":null,\\\"plan_cuenta_id\\\":null,\\\"iva_creditos_tipo_id\\\":null,\\\"created_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"activity_id\\\":null,\\\"address\\\":null,\\\"person_type_id\\\":1,\\\"fa_iva_condition_id\\\":null,\\\"fa_codigo_postal\\\":null,\\\"email\\\":null,\\\"deleted_at\\\":null,\\\"person_config\\\":{\\\"id\\\":5,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"period_id\\\":null,\\\"zone_id\\\":null,\\\"settle_calc_by_coef\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:10:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:48:51.000000Z\\\",\\\"active\\\":2,\\\"enviarMail\\\":1,\\\"honorario\\\":\\\"0.00\\\",\\\"cta_cte_tesoreria_cuenta_id\\\":null,\\\"month_close\\\":12,\\\"iva_condition_id\\\":1,\\\"obligation_sell\\\":1,\\\"obligation_buy\\\":1,\\\"obligation_iva\\\":0,\\\"obligation_electronic_receipt\\\":0,\\\"obligation_iibb\\\":4,\\\"obligation_other_taxes\\\":null,\\\"liquidation_start_period\\\":\\\"2022-05\\\",\\\"obligation_salaries\\\":0,\\\"empleada_domestica\\\":0,\\\"prorratear_iva\\\":0,\\\"is_itc\\\":0,\\\"priority_order\\\":null,\\\"person_id_administrador\\\":40722,\\\"person_id_titular\\\":40722,\\\"logo_path\\\":null,\\\"certificado_afip_path\\\":null,\\\"llave_afip_path\\\":null,\\\"access_electronic_receipt\\\":0,\\\"ruta_logo_fa\\\":null,\\\"inicio_actividades\\\":\\\"2022-07-29T03:00:00.000000Z\\\",\\\"iibb\\\":null,\\\"fe_leyenda\\\":null,\\\"atencion_iva\\\":0,\\\"atencion_iva_comentario\\\":null,\\\"atencion_iibb\\\":1,\\\"atencion_iibb_comentario\\\":null,\\\"deleted_at\\\":null}},\\\"settle\\\":{\\\"id\\\":5,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period\\\":{\\\"id\\\":4532,\\\"user_id\\\":null,\\\"code\\\":\\\"2022-06\\\",\\\"year\\\":2022,\\\"period_number\\\":6,\\\"date_from\\\":\\\"2022-06-01\\\",\\\"date_to\\\":\\\"2022-06-30\\\",\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"person_id\\\":40722,\\\"conta_status\\\":0,\\\"deleted_at\\\":null,\\\"syj_periods_status_id\\\":1,\\\"syj_sin_asiento\\\":0,\\\"syj_asiento_modificado\\\":0,\\\"syj_periods_status_emp_dom_id\\\":1}},\\\"registros\\\":{\\\"id\\\":5,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period_liquidation_iibb\\\":[{\\\"id\\\":9,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":5,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"base_amount\\\":\\\"442268.00\\\",\\\"impuesto\\\":\\\"0.00\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"0.00\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":22,\\\"name\\\":\\\"Capital Federal\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"01\\\",\\\"sircreb_plan_cuenta_id\\\":277,\\\"codigo_cm\\\":901,\\\"codigo_afip\\\":\\\"0\\\"},\\\"details\\\":[{\\\"id\\\":9,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":5,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"0.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"0.00\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":10,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":5,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"0.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":442268,\\\"tax_amount\\\":0,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]},{\\\"id\\\":10,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":5,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"base_amount\\\":\\\"442268.00\\\",\\\"impuesto\\\":\\\"0.00\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"0.00\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":23,\\\"name\\\":\\\"Buenos Aires\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"02\\\",\\\"sircreb_plan_cuenta_id\\\":276,\\\"codigo_cm\\\":902,\\\"codigo_afip\\\":\\\"1\\\"},\\\"details\\\":[{\\\"id\\\":9,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":5,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"0.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":442268,\\\"tax_amount\\\":0,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":10,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":5,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"0.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"0.00\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]}]}}\\\";s:7:\\\"user_id\\\";i:7479;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 19:49:41\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 19:49:41\\\";s:2:\\\"id\\\";i:3620;}s:11:\\\"\\u0000*\\u0000original\\\";a:5:{s:11:\\\"descripcion\\\";s:7579:\\\"{\\\"group_person_zone_actividad\\\":[{\\\"id\\\":9,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"actividad_id\\\":856,\\\"calculo_iibb\\\":1,\\\"coef\\\":\\\"0.00000\\\",\\\"alicuota\\\":\\\"0.00000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T22:48:51.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:48:51.000000Z\\\",\\\"deleted_at\\\":null,\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null},\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null}}],\\\"person\\\":{\\\"id\\\":40722,\\\"user_id\\\":7479,\\\"field_name1\\\":\\\"ALVAREZ FLORENCIA\\\",\\\"field_name2\\\":null,\\\"document_type\\\":\\\"cuit\\\",\\\"document\\\":\\\"27-40275454-6\\\",\\\"cond_frente_al_iva_id\\\":null,\\\"country_id\\\":null,\\\"state_id\\\":null,\\\"zone_id\\\":null,\\\"plan_cuenta_id\\\":null,\\\"iva_creditos_tipo_id\\\":null,\\\"created_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"activity_id\\\":null,\\\"address\\\":null,\\\"person_type_id\\\":1,\\\"fa_iva_condition_id\\\":null,\\\"fa_codigo_postal\\\":null,\\\"email\\\":null,\\\"deleted_at\\\":null,\\\"person_config\\\":{\\\"id\\\":5,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"period_id\\\":null,\\\"zone_id\\\":null,\\\"settle_calc_by_coef\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:10:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:48:51.000000Z\\\",\\\"active\\\":2,\\\"enviarMail\\\":1,\\\"honorario\\\":\\\"0.00\\\",\\\"cta_cte_tesoreria_cuenta_id\\\":null,\\\"month_close\\\":12,\\\"iva_condition_id\\\":1,\\\"obligation_sell\\\":1,\\\"obligation_buy\\\":1,\\\"obligation_iva\\\":0,\\\"obligation_electronic_receipt\\\":0,\\\"obligation_iibb\\\":4,\\\"obligation_other_taxes\\\":null,\\\"liquidation_start_period\\\":\\\"2022-05\\\",\\\"obligation_salaries\\\":0,\\\"empleada_domestica\\\":0,\\\"prorratear_iva\\\":0,\\\"is_itc\\\":0,\\\"priority_order\\\":null,\\\"person_id_administrador\\\":40722,\\\"person_id_titular\\\":40722,\\\"logo_path\\\":null,\\\"certificado_afip_path\\\":null,\\\"llave_afip_path\\\":null,\\\"access_electronic_receipt\\\":0,\\\"ruta_logo_fa\\\":null,\\\"inicio_actividades\\\":\\\"2022-07-29T03:00:00.000000Z\\\",\\\"iibb\\\":null,\\\"fe_leyenda\\\":null,\\\"atencion_iva\\\":0,\\\"atencion_iva_comentario\\\":null,\\\"atencion_iibb\\\":1,\\\"atencion_iibb_comentario\\\":null,\\\"deleted_at\\\":null}},\\\"settle\\\":{\\\"id\\\":5,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period\\\":{\\\"id\\\":4532,\\\"user_id\\\":null,\\\"code\\\":\\\"2022-06\\\",\\\"year\\\":2022,\\\"period_number\\\":6,\\\"date_from\\\":\\\"2022-06-01\\\",\\\"date_to\\\":\\\"2022-06-30\\\",\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"person_id\\\":40722,\\\"conta_status\\\":0,\\\"deleted_at\\\":null,\\\"syj_periods_status_id\\\":1,\\\"syj_sin_asiento\\\":0,\\\"syj_asiento_modificado\\\":0,\\\"syj_periods_status_emp_dom_id\\\":1}},\\\"registros\\\":{\\\"id\\\":5,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period_liquidation_iibb\\\":[{\\\"id\\\":9,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":5,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"base_amount\\\":\\\"442268.00\\\",\\\"impuesto\\\":\\\"0.00\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"0.00\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":22,\\\"name\\\":\\\"Capital Federal\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"01\\\",\\\"sircreb_plan_cuenta_id\\\":277,\\\"codigo_cm\\\":901,\\\"codigo_afip\\\":\\\"0\\\"},\\\"details\\\":[{\\\"id\\\":9,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":5,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"0.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"0.00\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":10,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":5,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"0.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":442268,\\\"tax_amount\\\":0,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]},{\\\"id\\\":10,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":5,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"base_amount\\\":\\\"442268.00\\\",\\\"impuesto\\\":\\\"0.00\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"0.00\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":23,\\\"name\\\":\\\"Buenos Aires\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"02\\\",\\\"sircreb_plan_cuenta_id\\\":276,\\\"codigo_cm\\\":902,\\\"codigo_afip\\\":\\\"1\\\"},\\\"details\\\":[{\\\"id\\\":9,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":5,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"0.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":442268,\\\"tax_amount\\\":0,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":10,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":5,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"0.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"0.00\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:49:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]}]}}\\\";s:7:\\\"user_id\\\";i:7479;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 19:49:41\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 19:49:41\\\";s:2:\\\"id\\\";i:3620;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}}s:3:\\\"job\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";s:7:\\\"finance\\\";s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}','Symfony\\Component\\Process\\Exception\\ProcessTimedOutException: The process \"node /home/forge/taxes.com.ar/resources/js/puppeteer/CMCopiarValoresEnDDJJ.js 27402754546 Flor056544 3620\" exceeded the timeout of 60 seconds. in /home/forge/taxes.com.ar/vendor/symfony/process/Process.php:1213\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(425): Symfony\\Component\\Process\\Process->checkTimeout()\n#1 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(249): Symfony\\Component\\Process\\Process->wait()\n#2 /home/forge/taxes.com.ar/app/Http/Controllers/Taxes/BOTCopiarEnAfipController.php(83): Symfony\\Component\\Process\\Process->run()\n#3 /home/forge/taxes.com.ar/app/Jobs/QueueGenerica.php(36): App\\Http\\Controllers\\Taxes\\BOTCopiarEnAfipController->Execute_Bot_Copiar_en_Afip(Object(Illuminate\\Support\\Collection))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): App\\Jobs\\QueueGenerica->handle()\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(94): Illuminate\\Container\\Container->call(Array)\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#12 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(98): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(83): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(App\\Jobs\\QueueGenerica), false)\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#15 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#16 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(85): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(59): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(App\\Queue\\DatabaseJob), Object(App\\Jobs\\QueueGenerica))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(App\\Queue\\DatabaseJob), Array)\n#19 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(26): Illuminate\\Queue\\Jobs\\Job->fire()\n#20 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#21 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'finance\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#22 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(265): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#23 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->runNextJob(\'finance\', \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#24 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'finance\', \'finance\')\n#25 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#26 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#27 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#28 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#29 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#30 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#31 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#32 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#33 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#34 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#35 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#36 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#37 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#38 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#39 {main}','2022-07-29 19:50:42',NULL);
INSERT INTO `failed_jobs` VALUES (4,NULL,'finance','finance','{\"uuid\":\"bff30205-8fa4-4c98-bd98-f03679d66f49\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":9:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":5:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:11:\\\"controlador\\\";s:53:\\\"\\\\App\\\\Http\\\\Controllers\\\\Taxes\\\\BOTCopiarEnAfipController\\\";s:6:\\\"metodo\\\";s:26:\\\"Execute_Bot_Copiar_en_Afip\\\";s:12:\\\"metodo_error\\\";s:15:\\\"error_queue_bot\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":7:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:4:\\\"user\\\";O:8:\\\"App\\\\User\\\":28:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:6:\\\"tusers\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:6:\\\"idUser\\\";s:11:\\\"\\u0000*\\u0000fillable\\\";a:12:{i:0;s:6:\\\"nombre\\\";i:1;s:9:\\\"loginUser\\\";i:2;s:9:\\\"emailUser\\\";i:3;s:5:\\\"clave\\\";i:4;s:9:\\\"claveUser\\\";i:5;s:10:\\\"statusUser\\\";i:6;s:12:\\\"user_type_id\\\";i:7;s:5:\\\"firma\\\";i:8;s:15:\\\"suscrip_plan_id\\\";i:9;s:7:\\\"importe\\\";i:10;s:6:\\\"avatar\\\";i:11;s:18:\\\"es_empresa_externa\\\";}s:9:\\\"\\u0000*\\u0000hidden\\\";a:4:{i:0;s:8:\\\"password\\\";i:1;s:14:\\\"remember_token\\\";i:2;s:9:\\\"claveUser\\\";i:3;s:5:\\\"clave\\\";}s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:17:{s:6:\\\"idUser\\\";i:7479;s:6:\\\"nombre\\\";s:15:\\\"Gramajo Valeria\\\";s:9:\\\"loginUser\\\";s:16:\\\"vag730@gmail.com\\\";s:9:\\\"emailUser\\\";s:16:\\\"vag730@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27271787303\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$22PcHpDd5yh.X\\/iVCxAAJeeMbXZL\\/LfNDf33f7B8V9FiXlwHpR4Hy\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";s:6:\\\"person\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:21:{s:2:\\\"id\\\";i:47165;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:15:\\\"Gramajo Valeria\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-27178730-3\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:21:{s:2:\\\"id\\\";i:47165;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:15:\\\"Gramajo Valeria\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-27178730-3\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}s:11:\\\"\\u0000*\\u0000original\\\";a:16:{s:6:\\\"idUser\\\";i:7479;s:6:\\\"nombre\\\";s:15:\\\"Gramajo Valeria\\\";s:9:\\\"loginUser\\\";s:16:\\\"vag730@gmail.com\\\";s:9:\\\"emailUser\\\";s:16:\\\"vag730@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27271787303\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$22PcHpDd5yh.X\\/iVCxAAJeeMbXZL\\/LfNDf33f7B8V9FiXlwHpR4Hy\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:1:{i:0;s:1:\\\"*\\\";}s:20:\\\"\\u0000*\\u0000rememberTokenName\\\";s:14:\\\"remember_token\\\";}s:23:\\\"cuit_administrador_afip\\\";s:11:\\\"27402754546\\\";s:12:\\\"clave_fiscal\\\";s:10:\\\"Flor056544\\\";s:5:\\\"sitio\\\";s:12:\\\"taxes.com.ar\\\";s:6:\\\"settle\\\";O:28:\\\"App\\\\Models\\\\PeriodLiquidation\\\":28:{s:8:\\\"\\u0000*\\u0000table\\\";s:19:\\\"period_liquidations\\\";s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:9:\\\"\\u0000*\\u0000hidden\\\";a:2:{i:0;s:10:\\\"created_at\\\";i:1;s:10:\\\"updated_at\\\";}s:10:\\\"\\u0000*\\u0000appends\\\";a:1:{i:0;s:15:\\\"files_relations\\\";}s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:10:{s:2:\\\"id\\\";i:9;s:7:\\\"user_id\\\";i:7479;s:8:\\\"apply_to\\\";s:4:\\\"iibb\\\";s:9:\\\"period_id\\\";i:4532;s:9:\\\"person_id\\\";i:40722;s:6:\\\"status\\\";i:1;s:11:\\\"auxiliar_id\\\";i:3621;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 20:06:52\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 20:07:12\\\";s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:10:{s:2:\\\"id\\\";i:9;s:7:\\\"user_id\\\";i:7479;s:8:\\\"apply_to\\\";s:4:\\\"iibb\\\";s:9:\\\"period_id\\\";i:4532;s:9:\\\"person_id\\\";i:40722;s:6:\\\"status\\\";i:1;s:11:\\\"auxiliar_id\\\";i:3621;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 20:06:52\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 20:07:12\\\";s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:2:{s:11:\\\"auxiliar_id\\\";i:3621;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 20:07:12\\\";}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:1:{i:0;s:10:\\\"deleted_at\\\";}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}s:8:\\\"auxiliar\\\";O:19:\\\"App\\\\Models\\\\Auxiliar\\\":27:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:8:\\\"auxiliar\\\";s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:1;s:13:\\\"\\u0000*\\u0000attributes\\\";a:5:{s:11:\\\"descripcion\\\";s:7603:\\\"{\\\"group_person_zone_actividad\\\":[{\\\"id\\\":17,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"actividad_id\\\":856,\\\"calculo_iibb\\\":1,\\\"coef\\\":\\\"0.00000\\\",\\\"alicuota\\\":\\\"3.50000\\\",\\\"cm_articulo_regimen_id\\\":10,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T23:06:38.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T23:06:38.000000Z\\\",\\\"deleted_at\\\":null,\\\"cm_articulo_regimen\\\":{\\\"id\\\":10,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 14\\\",\\\"codigo\\\":14,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null},\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null}}],\\\"person\\\":{\\\"id\\\":40722,\\\"user_id\\\":7479,\\\"field_name1\\\":\\\"ALVAREZ FLORENCIA\\\",\\\"field_name2\\\":null,\\\"document_type\\\":\\\"cuit\\\",\\\"document\\\":\\\"27-40275454-6\\\",\\\"cond_frente_al_iva_id\\\":null,\\\"country_id\\\":null,\\\"state_id\\\":null,\\\"zone_id\\\":null,\\\"plan_cuenta_id\\\":null,\\\"iva_creditos_tipo_id\\\":null,\\\"created_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"activity_id\\\":null,\\\"address\\\":null,\\\"person_type_id\\\":1,\\\"fa_iva_condition_id\\\":null,\\\"fa_codigo_postal\\\":null,\\\"email\\\":null,\\\"deleted_at\\\":null,\\\"person_config\\\":{\\\"id\\\":5,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"period_id\\\":null,\\\"zone_id\\\":null,\\\"settle_calc_by_coef\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:10:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T23:06:38.000000Z\\\",\\\"active\\\":2,\\\"enviarMail\\\":1,\\\"honorario\\\":\\\"0.00\\\",\\\"cta_cte_tesoreria_cuenta_id\\\":null,\\\"month_close\\\":12,\\\"iva_condition_id\\\":1,\\\"obligation_sell\\\":1,\\\"obligation_buy\\\":1,\\\"obligation_iva\\\":0,\\\"obligation_electronic_receipt\\\":0,\\\"obligation_iibb\\\":4,\\\"obligation_other_taxes\\\":null,\\\"liquidation_start_period\\\":\\\"2022-05\\\",\\\"obligation_salaries\\\":0,\\\"empleada_domestica\\\":0,\\\"prorratear_iva\\\":0,\\\"is_itc\\\":0,\\\"priority_order\\\":null,\\\"person_id_administrador\\\":40722,\\\"person_id_titular\\\":40722,\\\"logo_path\\\":null,\\\"certificado_afip_path\\\":null,\\\"llave_afip_path\\\":null,\\\"access_electronic_receipt\\\":0,\\\"ruta_logo_fa\\\":null,\\\"inicio_actividades\\\":\\\"2022-07-29T03:00:00.000000Z\\\",\\\"iibb\\\":null,\\\"fe_leyenda\\\":null,\\\"atencion_iva\\\":0,\\\"atencion_iva_comentario\\\":null,\\\"atencion_iibb\\\":1,\\\"atencion_iibb_comentario\\\":null,\\\"deleted_at\\\":null}},\\\"settle\\\":{\\\"id\\\":9,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period\\\":{\\\"id\\\":4532,\\\"user_id\\\":null,\\\"code\\\":\\\"2022-06\\\",\\\"year\\\":2022,\\\"period_number\\\":6,\\\"date_from\\\":\\\"2022-06-01\\\",\\\"date_to\\\":\\\"2022-06-30\\\",\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"person_id\\\":40722,\\\"conta_status\\\":0,\\\"deleted_at\\\":null,\\\"syj_periods_status_id\\\":1,\\\"syj_sin_asiento\\\":0,\\\"syj_asiento_modificado\\\":0,\\\"syj_periods_status_emp_dom_id\\\":1}},\\\"registros\\\":{\\\"id\\\":9,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period_liquidation_iibb\\\":[{\\\"id\\\":17,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":9,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"base_amount\\\":\\\"442268.00\\\",\\\"impuesto\\\":\\\"0.00\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"0.00\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":22,\\\"name\\\":\\\"Capital Federal\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"01\\\",\\\"sircreb_plan_cuenta_id\\\":277,\\\"codigo_cm\\\":901,\\\"codigo_afip\\\":\\\"0\\\"},\\\"details\\\":[{\\\"id\\\":17,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":9,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"3.5000\\\",\\\"cm_articulo_regimen_id\\\":10,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"0.00\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":10,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 14\\\",\\\"codigo\\\":14,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":18,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":9,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":10,\\\"base_amount\\\":442268,\\\"tax_amount\\\":0,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":10,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 14\\\",\\\"codigo\\\":14,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]},{\\\"id\\\":18,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":9,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"base_amount\\\":\\\"442268.00\\\",\\\"impuesto\\\":\\\"0.00\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"0.00\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":23,\\\"name\\\":\\\"Buenos Aires\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"02\\\",\\\"sircreb_plan_cuenta_id\\\":276,\\\"codigo_cm\\\":902,\\\"codigo_afip\\\":\\\"1\\\"},\\\"details\\\":[{\\\"id\\\":17,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":9,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"3.5000\\\",\\\"cm_articulo_regimen_id\\\":10,\\\"base_amount\\\":442268,\\\"tax_amount\\\":0,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":10,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 14\\\",\\\"codigo\\\":14,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":18,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":9,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":10,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"0.00\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":10,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 14\\\",\\\"codigo\\\":14,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]}]}}\\\";s:7:\\\"user_id\\\";i:7479;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 20:07:12\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 20:07:12\\\";s:2:\\\"id\\\";i:3621;}s:11:\\\"\\u0000*\\u0000original\\\";a:5:{s:11:\\\"descripcion\\\";s:7603:\\\"{\\\"group_person_zone_actividad\\\":[{\\\"id\\\":17,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"actividad_id\\\":856,\\\"calculo_iibb\\\":1,\\\"coef\\\":\\\"0.00000\\\",\\\"alicuota\\\":\\\"3.50000\\\",\\\"cm_articulo_regimen_id\\\":10,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T23:06:38.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T23:06:38.000000Z\\\",\\\"deleted_at\\\":null,\\\"cm_articulo_regimen\\\":{\\\"id\\\":10,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 14\\\",\\\"codigo\\\":14,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null},\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null}}],\\\"person\\\":{\\\"id\\\":40722,\\\"user_id\\\":7479,\\\"field_name1\\\":\\\"ALVAREZ FLORENCIA\\\",\\\"field_name2\\\":null,\\\"document_type\\\":\\\"cuit\\\",\\\"document\\\":\\\"27-40275454-6\\\",\\\"cond_frente_al_iva_id\\\":null,\\\"country_id\\\":null,\\\"state_id\\\":null,\\\"zone_id\\\":null,\\\"plan_cuenta_id\\\":null,\\\"iva_creditos_tipo_id\\\":null,\\\"created_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"activity_id\\\":null,\\\"address\\\":null,\\\"person_type_id\\\":1,\\\"fa_iva_condition_id\\\":null,\\\"fa_codigo_postal\\\":null,\\\"email\\\":null,\\\"deleted_at\\\":null,\\\"person_config\\\":{\\\"id\\\":5,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"period_id\\\":null,\\\"zone_id\\\":null,\\\"settle_calc_by_coef\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:10:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T23:06:38.000000Z\\\",\\\"active\\\":2,\\\"enviarMail\\\":1,\\\"honorario\\\":\\\"0.00\\\",\\\"cta_cte_tesoreria_cuenta_id\\\":null,\\\"month_close\\\":12,\\\"iva_condition_id\\\":1,\\\"obligation_sell\\\":1,\\\"obligation_buy\\\":1,\\\"obligation_iva\\\":0,\\\"obligation_electronic_receipt\\\":0,\\\"obligation_iibb\\\":4,\\\"obligation_other_taxes\\\":null,\\\"liquidation_start_period\\\":\\\"2022-05\\\",\\\"obligation_salaries\\\":0,\\\"empleada_domestica\\\":0,\\\"prorratear_iva\\\":0,\\\"is_itc\\\":0,\\\"priority_order\\\":null,\\\"person_id_administrador\\\":40722,\\\"person_id_titular\\\":40722,\\\"logo_path\\\":null,\\\"certificado_afip_path\\\":null,\\\"llave_afip_path\\\":null,\\\"access_electronic_receipt\\\":0,\\\"ruta_logo_fa\\\":null,\\\"inicio_actividades\\\":\\\"2022-07-29T03:00:00.000000Z\\\",\\\"iibb\\\":null,\\\"fe_leyenda\\\":null,\\\"atencion_iva\\\":0,\\\"atencion_iva_comentario\\\":null,\\\"atencion_iibb\\\":1,\\\"atencion_iibb_comentario\\\":null,\\\"deleted_at\\\":null}},\\\"settle\\\":{\\\"id\\\":9,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period\\\":{\\\"id\\\":4532,\\\"user_id\\\":null,\\\"code\\\":\\\"2022-06\\\",\\\"year\\\":2022,\\\"period_number\\\":6,\\\"date_from\\\":\\\"2022-06-01\\\",\\\"date_to\\\":\\\"2022-06-30\\\",\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"person_id\\\":40722,\\\"conta_status\\\":0,\\\"deleted_at\\\":null,\\\"syj_periods_status_id\\\":1,\\\"syj_sin_asiento\\\":0,\\\"syj_asiento_modificado\\\":0,\\\"syj_periods_status_emp_dom_id\\\":1}},\\\"registros\\\":{\\\"id\\\":9,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period_liquidation_iibb\\\":[{\\\"id\\\":17,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":9,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"base_amount\\\":\\\"442268.00\\\",\\\"impuesto\\\":\\\"0.00\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"0.00\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":22,\\\"name\\\":\\\"Capital Federal\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"01\\\",\\\"sircreb_plan_cuenta_id\\\":277,\\\"codigo_cm\\\":901,\\\"codigo_afip\\\":\\\"0\\\"},\\\"details\\\":[{\\\"id\\\":17,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":9,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"3.5000\\\",\\\"cm_articulo_regimen_id\\\":10,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"0.00\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":10,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 14\\\",\\\"codigo\\\":14,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":18,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":9,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":10,\\\"base_amount\\\":442268,\\\"tax_amount\\\":0,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":10,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 14\\\",\\\"codigo\\\":14,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]},{\\\"id\\\":18,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":9,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"base_amount\\\":\\\"442268.00\\\",\\\"impuesto\\\":\\\"0.00\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"0.00\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":23,\\\"name\\\":\\\"Buenos Aires\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"02\\\",\\\"sircreb_plan_cuenta_id\\\":276,\\\"codigo_cm\\\":902,\\\"codigo_afip\\\":\\\"1\\\"},\\\"details\\\":[{\\\"id\\\":17,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":9,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"3.5000\\\",\\\"cm_articulo_regimen_id\\\":10,\\\"base_amount\\\":442268,\\\"tax_amount\\\":0,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":10,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 14\\\",\\\"codigo\\\":14,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":18,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":9,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.0000\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":10,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"0.00\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T23:06:52.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":10,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 14\\\",\\\"codigo\\\":14,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]}]}}\\\";s:7:\\\"user_id\\\";i:7479;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 20:07:12\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 20:07:12\\\";s:2:\\\"id\\\";i:3621;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}}s:3:\\\"job\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";s:7:\\\"finance\\\";s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}','Symfony\\Component\\Process\\Exception\\ProcessTimedOutException: The process \"node /home/forge/taxes.com.ar/resources/js/puppeteer/CMCopiarValoresEnDDJJ.js 27402754546 Flor056544 3621\" exceeded the timeout of 60 seconds. in /home/forge/taxes.com.ar/vendor/symfony/process/Process.php:1213\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(425): Symfony\\Component\\Process\\Process->checkTimeout()\n#1 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(249): Symfony\\Component\\Process\\Process->wait()\n#2 /home/forge/taxes.com.ar/app/Http/Controllers/Taxes/BOTCopiarEnAfipController.php(83): Symfony\\Component\\Process\\Process->run()\n#3 /home/forge/taxes.com.ar/app/Jobs/QueueGenerica.php(36): App\\Http\\Controllers\\Taxes\\BOTCopiarEnAfipController->Execute_Bot_Copiar_en_Afip(Object(Illuminate\\Support\\Collection))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): App\\Jobs\\QueueGenerica->handle()\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(94): Illuminate\\Container\\Container->call(Array)\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#12 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(98): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(83): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(App\\Jobs\\QueueGenerica), false)\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#15 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#16 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(85): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(59): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(App\\Queue\\DatabaseJob), Object(App\\Jobs\\QueueGenerica))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(App\\Queue\\DatabaseJob), Array)\n#19 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(26): Illuminate\\Queue\\Jobs\\Job->fire()\n#20 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#21 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'finance\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#22 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(265): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#23 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->runNextJob(\'finance\', \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#24 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'finance\', \'finance\')\n#25 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#26 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#27 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#28 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#29 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#30 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#31 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#32 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#33 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#34 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#35 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#36 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#37 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#38 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#39 {main}','2022-07-29 20:08:13',NULL);
INSERT INTO `failed_jobs` VALUES (5,NULL,'finance','finance','{\"uuid\":\"a39578e1-479f-49f7-afd0-d4226984caaa\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":9:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":5:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:11:\\\"controlador\\\";s:53:\\\"\\\\App\\\\Http\\\\Controllers\\\\Taxes\\\\BOTCopiarEnAfipController\\\";s:6:\\\"metodo\\\";s:26:\\\"Execute_Bot_Copiar_en_Afip\\\";s:12:\\\"metodo_error\\\";s:15:\\\"error_queue_bot\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":7:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:4:\\\"user\\\";O:8:\\\"App\\\\User\\\":28:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:6:\\\"tusers\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:6:\\\"idUser\\\";s:11:\\\"\\u0000*\\u0000fillable\\\";a:12:{i:0;s:6:\\\"nombre\\\";i:1;s:9:\\\"loginUser\\\";i:2;s:9:\\\"emailUser\\\";i:3;s:5:\\\"clave\\\";i:4;s:9:\\\"claveUser\\\";i:5;s:10:\\\"statusUser\\\";i:6;s:12:\\\"user_type_id\\\";i:7;s:5:\\\"firma\\\";i:8;s:15:\\\"suscrip_plan_id\\\";i:9;s:7:\\\"importe\\\";i:10;s:6:\\\"avatar\\\";i:11;s:18:\\\"es_empresa_externa\\\";}s:9:\\\"\\u0000*\\u0000hidden\\\";a:4:{i:0;s:8:\\\"password\\\";i:1;s:14:\\\"remember_token\\\";i:2;s:9:\\\"claveUser\\\";i:3;s:5:\\\"clave\\\";}s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:17:{s:6:\\\"idUser\\\";i:7479;s:6:\\\"nombre\\\";s:15:\\\"Gramajo Valeria\\\";s:9:\\\"loginUser\\\";s:16:\\\"vag730@gmail.com\\\";s:9:\\\"emailUser\\\";s:16:\\\"vag730@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27271787303\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$22PcHpDd5yh.X\\/iVCxAAJeeMbXZL\\/LfNDf33f7B8V9FiXlwHpR4Hy\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";s:6:\\\"person\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:21:{s:2:\\\"id\\\";i:47165;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:15:\\\"Gramajo Valeria\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-27178730-3\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:21:{s:2:\\\"id\\\";i:47165;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:15:\\\"Gramajo Valeria\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-27178730-3\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}s:11:\\\"\\u0000*\\u0000original\\\";a:16:{s:6:\\\"idUser\\\";i:7479;s:6:\\\"nombre\\\";s:15:\\\"Gramajo Valeria\\\";s:9:\\\"loginUser\\\";s:16:\\\"vag730@gmail.com\\\";s:9:\\\"emailUser\\\";s:16:\\\"vag730@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27271787303\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$22PcHpDd5yh.X\\/iVCxAAJeeMbXZL\\/LfNDf33f7B8V9FiXlwHpR4Hy\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:1:{i:0;s:1:\\\"*\\\";}s:20:\\\"\\u0000*\\u0000rememberTokenName\\\";s:14:\\\"remember_token\\\";}s:23:\\\"cuit_administrador_afip\\\";s:11:\\\"27402754546\\\";s:12:\\\"clave_fiscal\\\";s:10:\\\"Flor056544\\\";s:5:\\\"sitio\\\";s:12:\\\"taxes.com.ar\\\";s:6:\\\"settle\\\";O:28:\\\"App\\\\Models\\\\PeriodLiquidation\\\":28:{s:8:\\\"\\u0000*\\u0000table\\\";s:19:\\\"period_liquidations\\\";s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:9:\\\"\\u0000*\\u0000hidden\\\";a:2:{i:0;s:10:\\\"created_at\\\";i:1;s:10:\\\"updated_at\\\";}s:10:\\\"\\u0000*\\u0000appends\\\";a:1:{i:0;s:15:\\\"files_relations\\\";}s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:10:{s:2:\\\"id\\\";i:20;s:7:\\\"user_id\\\";i:7479;s:8:\\\"apply_to\\\";s:4:\\\"iibb\\\";s:9:\\\"period_id\\\";i:4532;s:9:\\\"person_id\\\";i:40722;s:6:\\\"status\\\";i:1;s:11:\\\"auxiliar_id\\\";i:3622;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 22:20:10\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 22:21:58\\\";s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:10:{s:2:\\\"id\\\";i:20;s:7:\\\"user_id\\\";i:7479;s:8:\\\"apply_to\\\";s:4:\\\"iibb\\\";s:9:\\\"period_id\\\";i:4532;s:9:\\\"person_id\\\";i:40722;s:6:\\\"status\\\";i:1;s:11:\\\"auxiliar_id\\\";i:3622;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 22:20:10\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 22:21:58\\\";s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:2:{s:11:\\\"auxiliar_id\\\";i:3622;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 22:21:58\\\";}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:1:{i:0;s:10:\\\"deleted_at\\\";}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}s:8:\\\"auxiliar\\\";O:19:\\\"App\\\\Models\\\\Auxiliar\\\":27:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:8:\\\"auxiliar\\\";s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:1;s:13:\\\"\\u0000*\\u0000attributes\\\";a:5:{s:11:\\\"descripcion\\\";s:7781:\\\"{\\\"group_person_zone_actividad\\\":[{\\\"id\\\":29,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"actividad_id\\\":856,\\\"calculo_iibb\\\":1,\\\"coef\\\":\\\"0.20000\\\",\\\"alicuota\\\":\\\"3.50000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-30T01:19:52.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:19:52.000000Z\\\",\\\"deleted_at\\\":null,\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null},\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"}}],\\\"person\\\":{\\\"id\\\":40722,\\\"user_id\\\":7479,\\\"field_name1\\\":\\\"ALVAREZ FLORENCIA\\\",\\\"field_name2\\\":null,\\\"document_type\\\":\\\"cuit\\\",\\\"document\\\":\\\"27-40275454-6\\\",\\\"cond_frente_al_iva_id\\\":null,\\\"country_id\\\":null,\\\"state_id\\\":null,\\\"zone_id\\\":null,\\\"plan_cuenta_id\\\":null,\\\"iva_creditos_tipo_id\\\":null,\\\"created_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"activity_id\\\":null,\\\"address\\\":null,\\\"person_type_id\\\":1,\\\"fa_iva_condition_id\\\":null,\\\"fa_codigo_postal\\\":null,\\\"email\\\":null,\\\"deleted_at\\\":null,\\\"person_config\\\":{\\\"id\\\":5,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"period_id\\\":null,\\\"zone_id\\\":null,\\\"settle_calc_by_coef\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:10:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:19:52.000000Z\\\",\\\"active\\\":2,\\\"enviarMail\\\":1,\\\"honorario\\\":\\\"1000.00\\\",\\\"cta_cte_tesoreria_cuenta_id\\\":null,\\\"month_close\\\":12,\\\"iva_condition_id\\\":1,\\\"obligation_sell\\\":1,\\\"obligation_buy\\\":1,\\\"obligation_iva\\\":0,\\\"obligation_electronic_receipt\\\":0,\\\"obligation_iibb\\\":4,\\\"obligation_other_taxes\\\":null,\\\"liquidation_start_period\\\":\\\"2022-05\\\",\\\"obligation_salaries\\\":0,\\\"empleada_domestica\\\":0,\\\"prorratear_iva\\\":0,\\\"is_itc\\\":0,\\\"priority_order\\\":null,\\\"person_id_administrador\\\":40722,\\\"person_id_titular\\\":40722,\\\"logo_path\\\":null,\\\"certificado_afip_path\\\":null,\\\"llave_afip_path\\\":null,\\\"access_electronic_receipt\\\":0,\\\"ruta_logo_fa\\\":null,\\\"inicio_actividades\\\":\\\"2022-07-29T03:00:00.000000Z\\\",\\\"iibb\\\":null,\\\"fe_leyenda\\\":null,\\\"atencion_iva\\\":0,\\\"atencion_iva_comentario\\\":null,\\\"atencion_iibb\\\":1,\\\"atencion_iibb_comentario\\\":null,\\\"deleted_at\\\":null}},\\\"settle\\\":{\\\"id\\\":20,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period\\\":{\\\"id\\\":4532,\\\"user_id\\\":null,\\\"code\\\":\\\"2022-06\\\",\\\"year\\\":2022,\\\"period_number\\\":6,\\\"date_from\\\":\\\"2022-06-01\\\",\\\"date_to\\\":\\\"2022-06-30\\\",\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"person_id\\\":40722,\\\"conta_status\\\":0,\\\"deleted_at\\\":null,\\\"syj_periods_status_id\\\":1,\\\"syj_sin_asiento\\\":0,\\\"syj_asiento_modificado\\\":0,\\\"syj_periods_status_emp_dom_id\\\":1}},\\\"registros\\\":{\\\"id\\\":20,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period_liquidation_iibb\\\":[{\\\"id\\\":39,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":20,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"base_amount\\\":442268,\\\"impuesto\\\":10614.432,\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":10614.432,\\\"a_favor\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":22,\\\"name\\\":\\\"Capital Federal\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"01\\\",\\\"sircreb_plan_cuenta_id\\\":277,\\\"codigo_cm\\\":901,\\\"codigo_afip\\\":\\\"0\\\"},\\\"details\\\":[{\\\"id\\\":40,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":20,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.2000\\\",\\\"aliquot\\\":\\\"3.5000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"3095.88\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":41,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":20,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.8000\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":442268,\\\"tax_amount\\\":10614.432,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]},{\\\"id\\\":40,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":20,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"base_amount\\\":442268,\\\"impuesto\\\":3095.8760000000007,\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":3095.8760000000007,\\\"a_favor\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":23,\\\"name\\\":\\\"Buenos Aires\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"02\\\",\\\"sircreb_plan_cuenta_id\\\":276,\\\"codigo_cm\\\":902,\\\"codigo_afip\\\":\\\"1\\\"},\\\"details\\\":[{\\\"id\\\":40,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":20,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.2000\\\",\\\"aliquot\\\":\\\"3.5000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":442268,\\\"tax_amount\\\":3095.8760000000007,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":41,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":20,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.8000\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"10614.43\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]}]}}\\\";s:7:\\\"user_id\\\";i:7479;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 22:21:58\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 22:21:58\\\";s:2:\\\"id\\\";i:3622;}s:11:\\\"\\u0000*\\u0000original\\\";a:5:{s:11:\\\"descripcion\\\";s:7781:\\\"{\\\"group_person_zone_actividad\\\":[{\\\"id\\\":29,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"actividad_id\\\":856,\\\"calculo_iibb\\\":1,\\\"coef\\\":\\\"0.20000\\\",\\\"alicuota\\\":\\\"3.50000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-30T01:19:52.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:19:52.000000Z\\\",\\\"deleted_at\\\":null,\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null},\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"}}],\\\"person\\\":{\\\"id\\\":40722,\\\"user_id\\\":7479,\\\"field_name1\\\":\\\"ALVAREZ FLORENCIA\\\",\\\"field_name2\\\":null,\\\"document_type\\\":\\\"cuit\\\",\\\"document\\\":\\\"27-40275454-6\\\",\\\"cond_frente_al_iva_id\\\":null,\\\"country_id\\\":null,\\\"state_id\\\":null,\\\"zone_id\\\":null,\\\"plan_cuenta_id\\\":null,\\\"iva_creditos_tipo_id\\\":null,\\\"created_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"activity_id\\\":null,\\\"address\\\":null,\\\"person_type_id\\\":1,\\\"fa_iva_condition_id\\\":null,\\\"fa_codigo_postal\\\":null,\\\"email\\\":null,\\\"deleted_at\\\":null,\\\"person_config\\\":{\\\"id\\\":5,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"period_id\\\":null,\\\"zone_id\\\":null,\\\"settle_calc_by_coef\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:10:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:19:52.000000Z\\\",\\\"active\\\":2,\\\"enviarMail\\\":1,\\\"honorario\\\":\\\"1000.00\\\",\\\"cta_cte_tesoreria_cuenta_id\\\":null,\\\"month_close\\\":12,\\\"iva_condition_id\\\":1,\\\"obligation_sell\\\":1,\\\"obligation_buy\\\":1,\\\"obligation_iva\\\":0,\\\"obligation_electronic_receipt\\\":0,\\\"obligation_iibb\\\":4,\\\"obligation_other_taxes\\\":null,\\\"liquidation_start_period\\\":\\\"2022-05\\\",\\\"obligation_salaries\\\":0,\\\"empleada_domestica\\\":0,\\\"prorratear_iva\\\":0,\\\"is_itc\\\":0,\\\"priority_order\\\":null,\\\"person_id_administrador\\\":40722,\\\"person_id_titular\\\":40722,\\\"logo_path\\\":null,\\\"certificado_afip_path\\\":null,\\\"llave_afip_path\\\":null,\\\"access_electronic_receipt\\\":0,\\\"ruta_logo_fa\\\":null,\\\"inicio_actividades\\\":\\\"2022-07-29T03:00:00.000000Z\\\",\\\"iibb\\\":null,\\\"fe_leyenda\\\":null,\\\"atencion_iva\\\":0,\\\"atencion_iva_comentario\\\":null,\\\"atencion_iibb\\\":1,\\\"atencion_iibb_comentario\\\":null,\\\"deleted_at\\\":null}},\\\"settle\\\":{\\\"id\\\":20,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period\\\":{\\\"id\\\":4532,\\\"user_id\\\":null,\\\"code\\\":\\\"2022-06\\\",\\\"year\\\":2022,\\\"period_number\\\":6,\\\"date_from\\\":\\\"2022-06-01\\\",\\\"date_to\\\":\\\"2022-06-30\\\",\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"person_id\\\":40722,\\\"conta_status\\\":0,\\\"deleted_at\\\":null,\\\"syj_periods_status_id\\\":1,\\\"syj_sin_asiento\\\":0,\\\"syj_asiento_modificado\\\":0,\\\"syj_periods_status_emp_dom_id\\\":1}},\\\"registros\\\":{\\\"id\\\":20,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period_liquidation_iibb\\\":[{\\\"id\\\":39,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":20,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"base_amount\\\":442268,\\\"impuesto\\\":10614.432,\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":10614.432,\\\"a_favor\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":22,\\\"name\\\":\\\"Capital Federal\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"01\\\",\\\"sircreb_plan_cuenta_id\\\":277,\\\"codigo_cm\\\":901,\\\"codigo_afip\\\":\\\"0\\\"},\\\"details\\\":[{\\\"id\\\":40,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":20,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.2000\\\",\\\"aliquot\\\":\\\"3.5000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"3095.88\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":41,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":20,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.8000\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":442268,\\\"tax_amount\\\":10614.432,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]},{\\\"id\\\":40,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":20,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"base_amount\\\":442268,\\\"impuesto\\\":3095.8760000000007,\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":3095.8760000000007,\\\"a_favor\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":23,\\\"name\\\":\\\"Buenos Aires\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"02\\\",\\\"sircreb_plan_cuenta_id\\\":276,\\\"codigo_cm\\\":902,\\\"codigo_afip\\\":\\\"1\\\"},\\\"details\\\":[{\\\"id\\\":40,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":20,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.2000\\\",\\\"aliquot\\\":\\\"3.5000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":442268,\\\"tax_amount\\\":3095.8760000000007,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":41,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":20,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.8000\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"10614.43\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:20:10.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]}]}}\\\";s:7:\\\"user_id\\\";i:7479;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 22:21:58\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 22:21:58\\\";s:2:\\\"id\\\";i:3622;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}}s:3:\\\"job\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";s:7:\\\"finance\\\";s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}','Symfony\\Component\\Process\\Exception\\ProcessTimedOutException: The process \"node /home/forge/taxes.com.ar/resources/js/puppeteer/CMCopiarValoresEnDDJJ.js 27402754546 Flor056544 3622\" exceeded the timeout of 60 seconds. in /home/forge/taxes.com.ar/vendor/symfony/process/Process.php:1213\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(425): Symfony\\Component\\Process\\Process->checkTimeout()\n#1 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(249): Symfony\\Component\\Process\\Process->wait()\n#2 /home/forge/taxes.com.ar/app/Http/Controllers/Taxes/BOTCopiarEnAfipController.php(83): Symfony\\Component\\Process\\Process->run()\n#3 /home/forge/taxes.com.ar/app/Jobs/QueueGenerica.php(36): App\\Http\\Controllers\\Taxes\\BOTCopiarEnAfipController->Execute_Bot_Copiar_en_Afip(Object(Illuminate\\Support\\Collection))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): App\\Jobs\\QueueGenerica->handle()\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(94): Illuminate\\Container\\Container->call(Array)\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#12 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(98): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(83): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(App\\Jobs\\QueueGenerica), false)\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#15 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#16 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(85): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(59): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(App\\Queue\\DatabaseJob), Object(App\\Jobs\\QueueGenerica))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(App\\Queue\\DatabaseJob), Array)\n#19 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(26): Illuminate\\Queue\\Jobs\\Job->fire()\n#20 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#21 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'finance\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#22 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(265): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#23 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->runNextJob(\'finance\', \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#24 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'finance\', \'finance\')\n#25 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#26 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#27 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#28 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#29 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#30 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#31 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#32 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#33 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#34 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#35 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#36 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#37 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#38 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#39 {main}','2022-07-29 22:22:58',NULL);
INSERT INTO `failed_jobs` VALUES (6,NULL,'finance','finance','{\"uuid\":\"daca6b70-6346-4578-873e-ab556c944f7a\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":9:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":5:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:11:\\\"controlador\\\";s:53:\\\"\\\\App\\\\Http\\\\Controllers\\\\Taxes\\\\BOTCopiarEnAfipController\\\";s:6:\\\"metodo\\\";s:26:\\\"Execute_Bot_Copiar_en_Afip\\\";s:12:\\\"metodo_error\\\";s:15:\\\"error_queue_bot\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":7:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:4:\\\"user\\\";O:8:\\\"App\\\\User\\\":28:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:6:\\\"tusers\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:6:\\\"idUser\\\";s:11:\\\"\\u0000*\\u0000fillable\\\";a:12:{i:0;s:6:\\\"nombre\\\";i:1;s:9:\\\"loginUser\\\";i:2;s:9:\\\"emailUser\\\";i:3;s:5:\\\"clave\\\";i:4;s:9:\\\"claveUser\\\";i:5;s:10:\\\"statusUser\\\";i:6;s:12:\\\"user_type_id\\\";i:7;s:5:\\\"firma\\\";i:8;s:15:\\\"suscrip_plan_id\\\";i:9;s:7:\\\"importe\\\";i:10;s:6:\\\"avatar\\\";i:11;s:18:\\\"es_empresa_externa\\\";}s:9:\\\"\\u0000*\\u0000hidden\\\";a:4:{i:0;s:8:\\\"password\\\";i:1;s:14:\\\"remember_token\\\";i:2;s:9:\\\"claveUser\\\";i:3;s:5:\\\"clave\\\";}s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:17:{s:6:\\\"idUser\\\";i:7479;s:6:\\\"nombre\\\";s:15:\\\"Gramajo Valeria\\\";s:9:\\\"loginUser\\\";s:16:\\\"vag730@gmail.com\\\";s:9:\\\"emailUser\\\";s:16:\\\"vag730@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27271787303\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$22PcHpDd5yh.X\\/iVCxAAJeeMbXZL\\/LfNDf33f7B8V9FiXlwHpR4Hy\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";s:6:\\\"person\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:21:{s:2:\\\"id\\\";i:47165;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:15:\\\"Gramajo Valeria\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-27178730-3\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:21:{s:2:\\\"id\\\";i:47165;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:15:\\\"Gramajo Valeria\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-27178730-3\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}s:11:\\\"\\u0000*\\u0000original\\\";a:16:{s:6:\\\"idUser\\\";i:7479;s:6:\\\"nombre\\\";s:15:\\\"Gramajo Valeria\\\";s:9:\\\"loginUser\\\";s:16:\\\"vag730@gmail.com\\\";s:9:\\\"emailUser\\\";s:16:\\\"vag730@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27271787303\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$22PcHpDd5yh.X\\/iVCxAAJeeMbXZL\\/LfNDf33f7B8V9FiXlwHpR4Hy\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:1:{i:0;s:1:\\\"*\\\";}s:20:\\\"\\u0000*\\u0000rememberTokenName\\\";s:14:\\\"remember_token\\\";}s:23:\\\"cuit_administrador_afip\\\";s:11:\\\"27402754546\\\";s:12:\\\"clave_fiscal\\\";s:10:\\\"Flor056544\\\";s:5:\\\"sitio\\\";s:12:\\\"taxes.com.ar\\\";s:6:\\\"settle\\\";O:28:\\\"App\\\\Models\\\\PeriodLiquidation\\\":28:{s:8:\\\"\\u0000*\\u0000table\\\";s:19:\\\"period_liquidations\\\";s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:9:\\\"\\u0000*\\u0000hidden\\\";a:2:{i:0;s:10:\\\"created_at\\\";i:1;s:10:\\\"updated_at\\\";}s:10:\\\"\\u0000*\\u0000appends\\\";a:1:{i:0;s:15:\\\"files_relations\\\";}s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:10:{s:2:\\\"id\\\";i:21;s:7:\\\"user_id\\\";i:7479;s:8:\\\"apply_to\\\";s:4:\\\"iibb\\\";s:9:\\\"period_id\\\";i:4532;s:9:\\\"person_id\\\";i:40722;s:6:\\\"status\\\";i:1;s:11:\\\"auxiliar_id\\\";i:3623;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 22:25:07\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 22:25:18\\\";s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:10:{s:2:\\\"id\\\";i:21;s:7:\\\"user_id\\\";i:7479;s:8:\\\"apply_to\\\";s:4:\\\"iibb\\\";s:9:\\\"period_id\\\";i:4532;s:9:\\\"person_id\\\";i:40722;s:6:\\\"status\\\";i:1;s:11:\\\"auxiliar_id\\\";i:3623;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 22:25:07\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 22:25:18\\\";s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:2:{s:11:\\\"auxiliar_id\\\";i:3623;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 22:25:18\\\";}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:1:{i:0;s:10:\\\"deleted_at\\\";}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}s:8:\\\"auxiliar\\\";O:19:\\\"App\\\\Models\\\\Auxiliar\\\":27:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:8:\\\"auxiliar\\\";s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:1;s:13:\\\"\\u0000*\\u0000attributes\\\";a:5:{s:11:\\\"descripcion\\\";s:7773:\\\"{\\\"group_person_zone_actividad\\\":[{\\\"id\\\":29,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"actividad_id\\\":856,\\\"calculo_iibb\\\":1,\\\"coef\\\":\\\"0.20000\\\",\\\"alicuota\\\":\\\"3.50000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-30T01:19:52.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:19:52.000000Z\\\",\\\"deleted_at\\\":null,\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null},\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"}}],\\\"person\\\":{\\\"id\\\":40722,\\\"user_id\\\":7479,\\\"field_name1\\\":\\\"ALVAREZ FLORENCIA\\\",\\\"field_name2\\\":null,\\\"document_type\\\":\\\"cuit\\\",\\\"document\\\":\\\"27-40275454-6\\\",\\\"cond_frente_al_iva_id\\\":null,\\\"country_id\\\":null,\\\"state_id\\\":null,\\\"zone_id\\\":null,\\\"plan_cuenta_id\\\":null,\\\"iva_creditos_tipo_id\\\":null,\\\"created_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"activity_id\\\":null,\\\"address\\\":null,\\\"person_type_id\\\":1,\\\"fa_iva_condition_id\\\":null,\\\"fa_codigo_postal\\\":null,\\\"email\\\":null,\\\"deleted_at\\\":null,\\\"person_config\\\":{\\\"id\\\":5,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"period_id\\\":null,\\\"zone_id\\\":null,\\\"settle_calc_by_coef\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:10:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:19:52.000000Z\\\",\\\"active\\\":2,\\\"enviarMail\\\":1,\\\"honorario\\\":\\\"1000.00\\\",\\\"cta_cte_tesoreria_cuenta_id\\\":null,\\\"month_close\\\":12,\\\"iva_condition_id\\\":1,\\\"obligation_sell\\\":1,\\\"obligation_buy\\\":1,\\\"obligation_iva\\\":0,\\\"obligation_electronic_receipt\\\":0,\\\"obligation_iibb\\\":4,\\\"obligation_other_taxes\\\":null,\\\"liquidation_start_period\\\":\\\"2022-05\\\",\\\"obligation_salaries\\\":0,\\\"empleada_domestica\\\":0,\\\"prorratear_iva\\\":0,\\\"is_itc\\\":0,\\\"priority_order\\\":null,\\\"person_id_administrador\\\":40722,\\\"person_id_titular\\\":40722,\\\"logo_path\\\":null,\\\"certificado_afip_path\\\":null,\\\"llave_afip_path\\\":null,\\\"access_electronic_receipt\\\":0,\\\"ruta_logo_fa\\\":null,\\\"inicio_actividades\\\":\\\"2022-07-29T03:00:00.000000Z\\\",\\\"iibb\\\":null,\\\"fe_leyenda\\\":null,\\\"atencion_iva\\\":0,\\\"atencion_iva_comentario\\\":null,\\\"atencion_iibb\\\":1,\\\"atencion_iibb_comentario\\\":null,\\\"deleted_at\\\":null}},\\\"settle\\\":{\\\"id\\\":21,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period\\\":{\\\"id\\\":4532,\\\"user_id\\\":null,\\\"code\\\":\\\"2022-06\\\",\\\"year\\\":2022,\\\"period_number\\\":6,\\\"date_from\\\":\\\"2022-06-01\\\",\\\"date_to\\\":\\\"2022-06-30\\\",\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"person_id\\\":40722,\\\"conta_status\\\":0,\\\"deleted_at\\\":null,\\\"syj_periods_status_id\\\":1,\\\"syj_sin_asiento\\\":0,\\\"syj_asiento_modificado\\\":0,\\\"syj_periods_status_emp_dom_id\\\":1}},\\\"registros\\\":{\\\"id\\\":21,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period_liquidation_iibb\\\":[{\\\"id\\\":41,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":21,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"base_amount\\\":\\\"442268.00\\\",\\\"impuesto\\\":\\\"10614.43\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"10614.43\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":22,\\\"name\\\":\\\"Capital Federal\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"01\\\",\\\"sircreb_plan_cuenta_id\\\":277,\\\"codigo_cm\\\":901,\\\"codigo_afip\\\":\\\"0\\\"},\\\"details\\\":[{\\\"id\\\":42,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":21,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.2000\\\",\\\"aliquot\\\":\\\"3.5000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"3095.88\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":43,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":21,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.8000\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":442268,\\\"tax_amount\\\":10614.43,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]},{\\\"id\\\":42,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":21,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"base_amount\\\":\\\"442268.00\\\",\\\"impuesto\\\":\\\"3095.88\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"3095.88\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":23,\\\"name\\\":\\\"Buenos Aires\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"02\\\",\\\"sircreb_plan_cuenta_id\\\":276,\\\"codigo_cm\\\":902,\\\"codigo_afip\\\":\\\"1\\\"},\\\"details\\\":[{\\\"id\\\":42,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":21,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.2000\\\",\\\"aliquot\\\":\\\"3.5000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":442268,\\\"tax_amount\\\":3095.88,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":43,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":21,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.8000\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"10614.43\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]}]}}\\\";s:7:\\\"user_id\\\";i:7479;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 22:25:18\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 22:25:18\\\";s:2:\\\"id\\\";i:3623;}s:11:\\\"\\u0000*\\u0000original\\\";a:5:{s:11:\\\"descripcion\\\";s:7773:\\\"{\\\"group_person_zone_actividad\\\":[{\\\"id\\\":29,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"actividad_id\\\":856,\\\"calculo_iibb\\\":1,\\\"coef\\\":\\\"0.20000\\\",\\\"alicuota\\\":\\\"3.50000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-30T01:19:52.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:19:52.000000Z\\\",\\\"deleted_at\\\":null,\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null},\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"}}],\\\"person\\\":{\\\"id\\\":40722,\\\"user_id\\\":7479,\\\"field_name1\\\":\\\"ALVAREZ FLORENCIA\\\",\\\"field_name2\\\":null,\\\"document_type\\\":\\\"cuit\\\",\\\"document\\\":\\\"27-40275454-6\\\",\\\"cond_frente_al_iva_id\\\":null,\\\"country_id\\\":null,\\\"state_id\\\":null,\\\"zone_id\\\":null,\\\"plan_cuenta_id\\\":null,\\\"iva_creditos_tipo_id\\\":null,\\\"created_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T22:10:13.000000Z\\\",\\\"activity_id\\\":null,\\\"address\\\":null,\\\"person_type_id\\\":1,\\\"fa_iva_condition_id\\\":null,\\\"fa_codigo_postal\\\":null,\\\"email\\\":null,\\\"deleted_at\\\":null,\\\"person_config\\\":{\\\"id\\\":5,\\\"user_id\\\":7479,\\\"person_id\\\":40722,\\\"period_id\\\":null,\\\"zone_id\\\":null,\\\"settle_calc_by_coef\\\":0,\\\"created_at\\\":\\\"2022-07-29T22:10:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:19:52.000000Z\\\",\\\"active\\\":2,\\\"enviarMail\\\":1,\\\"honorario\\\":\\\"1000.00\\\",\\\"cta_cte_tesoreria_cuenta_id\\\":null,\\\"month_close\\\":12,\\\"iva_condition_id\\\":1,\\\"obligation_sell\\\":1,\\\"obligation_buy\\\":1,\\\"obligation_iva\\\":0,\\\"obligation_electronic_receipt\\\":0,\\\"obligation_iibb\\\":4,\\\"obligation_other_taxes\\\":null,\\\"liquidation_start_period\\\":\\\"2022-05\\\",\\\"obligation_salaries\\\":0,\\\"empleada_domestica\\\":0,\\\"prorratear_iva\\\":0,\\\"is_itc\\\":0,\\\"priority_order\\\":null,\\\"person_id_administrador\\\":40722,\\\"person_id_titular\\\":40722,\\\"logo_path\\\":null,\\\"certificado_afip_path\\\":null,\\\"llave_afip_path\\\":null,\\\"access_electronic_receipt\\\":0,\\\"ruta_logo_fa\\\":null,\\\"inicio_actividades\\\":\\\"2022-07-29T03:00:00.000000Z\\\",\\\"iibb\\\":null,\\\"fe_leyenda\\\":null,\\\"atencion_iva\\\":0,\\\"atencion_iva_comentario\\\":null,\\\"atencion_iibb\\\":1,\\\"atencion_iibb_comentario\\\":null,\\\"deleted_at\\\":null}},\\\"settle\\\":{\\\"id\\\":21,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period\\\":{\\\"id\\\":4532,\\\"user_id\\\":null,\\\"code\\\":\\\"2022-06\\\",\\\"year\\\":2022,\\\"period_number\\\":6,\\\"date_from\\\":\\\"2022-06-01\\\",\\\"date_to\\\":\\\"2022-06-30\\\",\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"person_id\\\":40722,\\\"conta_status\\\":0,\\\"deleted_at\\\":null,\\\"syj_periods_status_id\\\":1,\\\"syj_sin_asiento\\\":0,\\\"syj_asiento_modificado\\\":0,\\\"syj_periods_status_emp_dom_id\\\":1}},\\\"registros\\\":{\\\"id\\\":21,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period_liquidation_iibb\\\":[{\\\"id\\\":41,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":21,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"base_amount\\\":\\\"442268.00\\\",\\\"impuesto\\\":\\\"10614.43\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"10614.43\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":22,\\\"name\\\":\\\"Capital Federal\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"01\\\",\\\"sircreb_plan_cuenta_id\\\":277,\\\"codigo_cm\\\":901,\\\"codigo_afip\\\":\\\"0\\\"},\\\"details\\\":[{\\\"id\\\":42,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":21,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.2000\\\",\\\"aliquot\\\":\\\"3.5000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"3095.88\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":43,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":21,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.8000\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":442268,\\\"tax_amount\\\":10614.43,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]},{\\\"id\\\":42,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":21,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"base_amount\\\":\\\"442268.00\\\",\\\"impuesto\\\":\\\"3095.88\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"3095.88\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":23,\\\"name\\\":\\\"Buenos Aires\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"02\\\",\\\"sircreb_plan_cuenta_id\\\":276,\\\"codigo_cm\\\":902,\\\"codigo_afip\\\":\\\"1\\\"},\\\"details\\\":[{\\\"id\\\":42,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":21,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.2000\\\",\\\"aliquot\\\":\\\"3.5000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":442268,\\\"tax_amount\\\":3095.88,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":43,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":21,\\\"period_id\\\":4532,\\\"person_id\\\":40722,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":856,\\\"coef\\\":\\\"0.8000\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"442268.00\\\",\\\"tax_amount\\\":\\\"10614.43\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:25:07.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":856,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T23:12:16.000000Z\\\",\\\"name\\\":\\\"Servicios generales de la Administraci\\u00f3n P\\u00fablica\\\",\\\"codigo_afip\\\":\\\"841100\\\",\\\"codigo_cm\\\":\\\"841100\\\"},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]}]}}\\\";s:7:\\\"user_id\\\";i:7479;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 22:25:18\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 22:25:18\\\";s:2:\\\"id\\\";i:3623;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}}s:3:\\\"job\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";s:7:\\\"finance\\\";s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}','Symfony\\Component\\Process\\Exception\\ProcessTimedOutException: The process \"node /home/forge/taxes.com.ar/resources/js/puppeteer/CMCopiarValoresEnDDJJ.js 27402754546 Flor056544 3623\" exceeded the timeout of 60 seconds. in /home/forge/taxes.com.ar/vendor/symfony/process/Process.php:1213\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(425): Symfony\\Component\\Process\\Process->checkTimeout()\n#1 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(249): Symfony\\Component\\Process\\Process->wait()\n#2 /home/forge/taxes.com.ar/app/Http/Controllers/Taxes/BOTCopiarEnAfipController.php(83): Symfony\\Component\\Process\\Process->run()\n#3 /home/forge/taxes.com.ar/app/Jobs/QueueGenerica.php(36): App\\Http\\Controllers\\Taxes\\BOTCopiarEnAfipController->Execute_Bot_Copiar_en_Afip(Object(Illuminate\\Support\\Collection))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): App\\Jobs\\QueueGenerica->handle()\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(94): Illuminate\\Container\\Container->call(Array)\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#12 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(98): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(83): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(App\\Jobs\\QueueGenerica), false)\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#15 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#16 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(85): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(59): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(App\\Queue\\DatabaseJob), Object(App\\Jobs\\QueueGenerica))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(App\\Queue\\DatabaseJob), Array)\n#19 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(26): Illuminate\\Queue\\Jobs\\Job->fire()\n#20 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#21 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'finance\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#22 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(265): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#23 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->runNextJob(\'finance\', \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#24 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'finance\', \'finance\')\n#25 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#26 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#27 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#28 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#29 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#30 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#31 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#32 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#33 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#34 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#35 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#36 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#37 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#38 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#39 {main}','2022-07-29 22:26:18',NULL);
INSERT INTO `failed_jobs` VALUES (7,NULL,'finance','finance','{\"uuid\":\"fa889a8c-3060-47dd-a174-6a9df1ab06f4\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":9:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":4:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:11:\\\"controlador\\\";s:55:\\\"\\\\App\\\\Http\\\\Controllers\\\\Data\\\\BOTMisComprobantesController\\\";s:6:\\\"metodo\\\";s:21:\\\"Execute_Bot_Descargar\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":11:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:4:\\\"user\\\";O:8:\\\"App\\\\User\\\":28:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:6:\\\"tusers\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:6:\\\"idUser\\\";s:11:\\\"\\u0000*\\u0000fillable\\\";a:12:{i:0;s:6:\\\"nombre\\\";i:1;s:9:\\\"loginUser\\\";i:2;s:9:\\\"emailUser\\\";i:3;s:5:\\\"clave\\\";i:4;s:9:\\\"claveUser\\\";i:5;s:10:\\\"statusUser\\\";i:6;s:12:\\\"user_type_id\\\";i:7;s:5:\\\"firma\\\";i:8;s:15:\\\"suscrip_plan_id\\\";i:9;s:7:\\\"importe\\\";i:10;s:6:\\\"avatar\\\";i:11;s:18:\\\"es_empresa_externa\\\";}s:9:\\\"\\u0000*\\u0000hidden\\\";a:4:{i:0;s:8:\\\"password\\\";i:1;s:14:\\\"remember_token\\\";i:2;s:9:\\\"claveUser\\\";i:3;s:5:\\\"clave\\\";}s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:17:{s:6:\\\"idUser\\\";i:7479;s:6:\\\"nombre\\\";s:15:\\\"Gramajo Valeria\\\";s:9:\\\"loginUser\\\";s:16:\\\"vag730@gmail.com\\\";s:9:\\\"emailUser\\\";s:16:\\\"vag730@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27271787303\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$22PcHpDd5yh.X\\/iVCxAAJeeMbXZL\\/LfNDf33f7B8V9FiXlwHpR4Hy\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";s:6:\\\"person\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:21:{s:2:\\\"id\\\";i:47165;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:15:\\\"Gramajo Valeria\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-27178730-3\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:21:{s:2:\\\"id\\\";i:47165;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:15:\\\"Gramajo Valeria\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-27178730-3\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}s:11:\\\"\\u0000*\\u0000original\\\";a:16:{s:6:\\\"idUser\\\";i:7479;s:6:\\\"nombre\\\";s:15:\\\"Gramajo Valeria\\\";s:9:\\\"loginUser\\\";s:16:\\\"vag730@gmail.com\\\";s:9:\\\"emailUser\\\";s:16:\\\"vag730@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27271787303\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$22PcHpDd5yh.X\\/iVCxAAJeeMbXZL\\/LfNDf33f7B8V9FiXlwHpR4Hy\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:1:{i:0;s:1:\\\"*\\\";}s:20:\\\"\\u0000*\\u0000rememberTokenName\\\";s:14:\\\"remember_token\\\";}s:15:\\\"cuit_user_admin\\\";s:15:\\\"\'27-27178730-3\'\\\";s:23:\\\"cuit_administrador_afip\\\";s:11:\\\"27271787303\\\";s:12:\\\"clave_fiscal\\\";s:13:\\\"Lasheras1790*\\\";s:12:\\\"cuit_empresa\\\";s:13:\\\"27-27178730-3\\\";s:5:\\\"sitio\\\";s:12:\\\"taxes.com.ar\\\";s:9:\\\"operacion\\\";s:8:\\\"Emitidos\\\";s:7:\\\"periodo\\\";s:10:\\\"Mes Pasado\\\";s:12:\\\"path_of_file\\\";O:21:\\\"App\\\\Models\\\\PathOfFile\\\":28:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:12:\\\"path_of_file\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:1;s:13:\\\"\\u0000*\\u0000attributes\\\";a:6:{s:7:\\\"user_id\\\";i:7479;s:20:\\\"path_of_file_name_id\\\";i:6;s:11:\\\"descripcion\\\";s:48:\\\"Gramajo Valeria Comprobantes Emitidos Mes Pasado\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 22:52:33\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 22:52:33\\\";s:2:\\\"id\\\";i:3;}s:11:\\\"\\u0000*\\u0000original\\\";a:6:{s:7:\\\"user_id\\\";i:7479;s:20:\\\"path_of_file_name_id\\\";i:6;s:11:\\\"descripcion\\\";s:48:\\\"Gramajo Valeria Comprobantes Emitidos Mes Pasado\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 22:52:33\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 22:52:33\\\";s:2:\\\"id\\\";i:3;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:1:{i:0;s:10:\\\"deleted_at\\\";}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}s:4:\\\"path\\\";s:14:\\\"27-27178730-3\\/\\\";}}s:3:\\\"job\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";s:7:\\\"finance\\\";s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}','Symfony\\Component\\Process\\Exception\\ProcessTimedOutException: The process \"node /home/forge/taxes.com.ar/resources/js/puppeteer/ImportarMisComprobantes.js 27271787303 Lasheras1790* 27-27178730-3 Emitidos \"Mes Pasado\" \'27-27178730-3\'\" exceeded the timeout of 60 seconds. in /home/forge/taxes.com.ar/vendor/symfony/process/Process.php:1213\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(425): Symfony\\Component\\Process\\Process->checkTimeout()\n#1 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(249): Symfony\\Component\\Process\\Process->wait()\n#2 /home/forge/taxes.com.ar/app/Http/Controllers/Data/BOTMisComprobantesController.php(94): Symfony\\Component\\Process\\Process->run()\n#3 /home/forge/taxes.com.ar/app/Jobs/QueueGenerica.php(36): App\\Http\\Controllers\\Data\\BOTMisComprobantesController->Execute_Bot_Descargar(Object(Illuminate\\Support\\Collection))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): App\\Jobs\\QueueGenerica->handle()\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(94): Illuminate\\Container\\Container->call(Array)\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#12 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(98): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(83): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(App\\Jobs\\QueueGenerica), false)\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#15 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#16 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(85): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(59): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(App\\Queue\\DatabaseJob), Object(App\\Jobs\\QueueGenerica))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(App\\Queue\\DatabaseJob), Array)\n#19 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(26): Illuminate\\Queue\\Jobs\\Job->fire()\n#20 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#21 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'finance\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#22 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(265): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#23 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->runNextJob(\'finance\', \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#24 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'finance\', \'finance\')\n#25 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#26 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#27 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#28 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#29 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#30 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#31 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#32 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#33 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#34 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#35 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#36 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#37 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#38 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#39 {main}','2022-07-29 22:53:35',NULL);
INSERT INTO `failed_jobs` VALUES (8,NULL,'finance','finance','{\"uuid\":\"318bdcd9-3359-45ab-9ab1-a6fad4074990\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":9:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":5:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:11:\\\"controlador\\\";s:53:\\\"\\\\App\\\\Http\\\\Controllers\\\\Taxes\\\\BOTCopiarEnAfipController\\\";s:6:\\\"metodo\\\";s:26:\\\"Execute_Bot_Copiar_en_Afip\\\";s:12:\\\"metodo_error\\\";s:15:\\\"error_queue_bot\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":7:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:4:\\\"user\\\";O:8:\\\"App\\\\User\\\":28:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:6:\\\"tusers\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:6:\\\"idUser\\\";s:11:\\\"\\u0000*\\u0000fillable\\\";a:12:{i:0;s:6:\\\"nombre\\\";i:1;s:9:\\\"loginUser\\\";i:2;s:9:\\\"emailUser\\\";i:3;s:5:\\\"clave\\\";i:4;s:9:\\\"claveUser\\\";i:5;s:10:\\\"statusUser\\\";i:6;s:12:\\\"user_type_id\\\";i:7;s:5:\\\"firma\\\";i:8;s:15:\\\"suscrip_plan_id\\\";i:9;s:7:\\\"importe\\\";i:10;s:6:\\\"avatar\\\";i:11;s:18:\\\"es_empresa_externa\\\";}s:9:\\\"\\u0000*\\u0000hidden\\\";a:4:{i:0;s:8:\\\"password\\\";i:1;s:14:\\\"remember_token\\\";i:2;s:9:\\\"claveUser\\\";i:3;s:5:\\\"clave\\\";}s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:17:{s:6:\\\"idUser\\\";i:7479;s:6:\\\"nombre\\\";s:15:\\\"Gramajo Valeria\\\";s:9:\\\"loginUser\\\";s:16:\\\"vag730@gmail.com\\\";s:9:\\\"emailUser\\\";s:16:\\\"vag730@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27271787303\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$22PcHpDd5yh.X\\/iVCxAAJeeMbXZL\\/LfNDf33f7B8V9FiXlwHpR4Hy\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";s:6:\\\"person\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:21:{s:2:\\\"id\\\";i:47165;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:15:\\\"Gramajo Valeria\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-27178730-3\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:21:{s:2:\\\"id\\\";i:47165;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:15:\\\"Gramajo Valeria\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-27178730-3\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}s:11:\\\"\\u0000*\\u0000original\\\";a:16:{s:6:\\\"idUser\\\";i:7479;s:6:\\\"nombre\\\";s:15:\\\"Gramajo Valeria\\\";s:9:\\\"loginUser\\\";s:16:\\\"vag730@gmail.com\\\";s:9:\\\"emailUser\\\";s:16:\\\"vag730@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27271787303\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$22PcHpDd5yh.X\\/iVCxAAJeeMbXZL\\/LfNDf33f7B8V9FiXlwHpR4Hy\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:1:{i:0;s:1:\\\"*\\\";}s:20:\\\"\\u0000*\\u0000rememberTokenName\\\";s:14:\\\"remember_token\\\";}s:23:\\\"cuit_administrador_afip\\\";s:11:\\\"27271787303\\\";s:12:\\\"clave_fiscal\\\";s:13:\\\"Lasheras1790*\\\";s:5:\\\"sitio\\\";s:12:\\\"taxes.com.ar\\\";s:6:\\\"settle\\\";O:28:\\\"App\\\\Models\\\\PeriodLiquidation\\\":28:{s:8:\\\"\\u0000*\\u0000table\\\";s:19:\\\"period_liquidations\\\";s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:9:\\\"\\u0000*\\u0000hidden\\\";a:2:{i:0;s:10:\\\"created_at\\\";i:1;s:10:\\\"updated_at\\\";}s:10:\\\"\\u0000*\\u0000appends\\\";a:1:{i:0;s:15:\\\"files_relations\\\";}s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:10:{s:2:\\\"id\\\";i:27;s:7:\\\"user_id\\\";i:7479;s:8:\\\"apply_to\\\";s:4:\\\"iibb\\\";s:9:\\\"period_id\\\";i:8;s:9:\\\"person_id\\\";i:40719;s:6:\\\"status\\\";i:1;s:11:\\\"auxiliar_id\\\";i:3624;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 23:14:31\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 23:14:48\\\";s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:10:{s:2:\\\"id\\\";i:27;s:7:\\\"user_id\\\";i:7479;s:8:\\\"apply_to\\\";s:4:\\\"iibb\\\";s:9:\\\"period_id\\\";i:8;s:9:\\\"person_id\\\";i:40719;s:6:\\\"status\\\";i:1;s:11:\\\"auxiliar_id\\\";i:3624;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 23:14:31\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 23:14:48\\\";s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:2:{s:11:\\\"auxiliar_id\\\";i:3624;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 23:14:48\\\";}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:1:{i:0;s:10:\\\"deleted_at\\\";}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}s:8:\\\"auxiliar\\\";O:19:\\\"App\\\\Models\\\\Auxiliar\\\":27:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:8:\\\"auxiliar\\\";s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:1;s:13:\\\"\\u0000*\\u0000attributes\\\";a:5:{s:11:\\\"descripcion\\\";s:7772:\\\"{\\\"group_person_zone_actividad\\\":[{\\\"id\\\":41,\\\"user_id\\\":7479,\\\"person_id\\\":40719,\\\"zone_id\\\":23,\\\"actividad_id\\\":850,\\\"calculo_iibb\\\":2,\\\"coef\\\":\\\"0.91040\\\",\\\"alicuota\\\":\\\"4.00000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-30T02:14:13.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T02:14:13.000000Z\\\",\\\"deleted_at\\\":null,\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null},\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null}}],\\\"person\\\":{\\\"id\\\":40719,\\\"user_id\\\":7479,\\\"field_name1\\\":\\\"Gramajo Valeria\\\",\\\"field_name2\\\":null,\\\"document_type\\\":\\\"cuit\\\",\\\"document\\\":\\\"27-27178730-3\\\",\\\"cond_frente_al_iva_id\\\":null,\\\"country_id\\\":null,\\\"state_id\\\":null,\\\"zone_id\\\":null,\\\"plan_cuenta_id\\\":null,\\\"iva_creditos_tipo_id\\\":null,\\\"created_at\\\":\\\"2020-11-27T06:11:08.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:46:24.000000Z\\\",\\\"activity_id\\\":null,\\\"address\\\":null,\\\"person_type_id\\\":1,\\\"fa_iva_condition_id\\\":null,\\\"fa_codigo_postal\\\":null,\\\"email\\\":null,\\\"deleted_at\\\":null,\\\"person_config\\\":{\\\"id\\\":2,\\\"user_id\\\":7479,\\\"person_id\\\":40719,\\\"period_id\\\":null,\\\"zone_id\\\":null,\\\"settle_calc_by_coef\\\":0,\\\"created_at\\\":\\\"2022-07-29T21:55:31.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T02:14:13.000000Z\\\",\\\"active\\\":2,\\\"enviarMail\\\":1,\\\"honorario\\\":\\\"0.00\\\",\\\"cta_cte_tesoreria_cuenta_id\\\":null,\\\"month_close\\\":12,\\\"iva_condition_id\\\":1,\\\"obligation_sell\\\":1,\\\"obligation_buy\\\":1,\\\"obligation_iva\\\":0,\\\"obligation_electronic_receipt\\\":0,\\\"obligation_iibb\\\":4,\\\"obligation_other_taxes\\\":null,\\\"liquidation_start_period\\\":\\\"2022-1\\\",\\\"obligation_salaries\\\":0,\\\"empleada_domestica\\\":0,\\\"prorratear_iva\\\":0,\\\"is_itc\\\":0,\\\"priority_order\\\":2,\\\"person_id_administrador\\\":40719,\\\"person_id_titular\\\":40719,\\\"logo_path\\\":null,\\\"certificado_afip_path\\\":null,\\\"llave_afip_path\\\":null,\\\"access_electronic_receipt\\\":0,\\\"ruta_logo_fa\\\":null,\\\"inicio_actividades\\\":\\\"2022-07-29T03:00:00.000000Z\\\",\\\"iibb\\\":\\\"27271787303\\\",\\\"fe_leyenda\\\":null,\\\"atencion_iva\\\":0,\\\"atencion_iva_comentario\\\":null,\\\"atencion_iibb\\\":1,\\\"atencion_iibb_comentario\\\":null,\\\"deleted_at\\\":null}},\\\"settle\\\":{\\\"id\\\":27,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period\\\":{\\\"id\\\":8,\\\"user_id\\\":null,\\\"code\\\":\\\"2022-06\\\",\\\"year\\\":2022,\\\"period_number\\\":6,\\\"date_from\\\":\\\"2022-06-01\\\",\\\"date_to\\\":\\\"2022-06-30\\\",\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"person_id\\\":40719,\\\"conta_status\\\":0,\\\"deleted_at\\\":null,\\\"syj_periods_status_id\\\":1,\\\"syj_sin_asiento\\\":0,\\\"syj_asiento_modificado\\\":0,\\\"syj_periods_status_emp_dom_id\\\":1}},\\\"registros\\\":{\\\"id\\\":27,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period_liquidation_iibb\\\":[{\\\"id\\\":53,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":27,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":22,\\\"base_amount\\\":\\\"1000.00\\\",\\\"impuesto\\\":\\\"2.69\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"2.69\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":22,\\\"name\\\":\\\"Capital Federal\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"01\\\",\\\"sircreb_plan_cuenta_id\\\":277,\\\"codigo_cm\\\":901,\\\"codigo_afip\\\":\\\"0\\\"},\\\"details\\\":[{\\\"id\\\":54,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":27,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":2,\\\"actividad_id\\\":850,\\\"coef\\\":\\\"0.9104\\\",\\\"aliquot\\\":\\\"4.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"14600.00\\\",\\\"tax_amount\\\":\\\"531.67\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":55,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":27,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":2,\\\"actividad_id\\\":850,\\\"coef\\\":\\\"0.0896\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":1000,\\\"tax_amount\\\":2.69,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]},{\\\"id\\\":54,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":27,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":23,\\\"base_amount\\\":\\\"14600.00\\\",\\\"impuesto\\\":\\\"531.67\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"531.67\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":23,\\\"name\\\":\\\"Buenos Aires\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"02\\\",\\\"sircreb_plan_cuenta_id\\\":276,\\\"codigo_cm\\\":902,\\\"codigo_afip\\\":\\\"1\\\"},\\\"details\\\":[{\\\"id\\\":54,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":27,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":2,\\\"actividad_id\\\":850,\\\"coef\\\":\\\"0.9104\\\",\\\"aliquot\\\":\\\"4.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":14600,\\\"tax_amount\\\":531.67,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":55,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":27,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":2,\\\"actividad_id\\\":850,\\\"coef\\\":\\\"0.0896\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"1000.00\\\",\\\"tax_amount\\\":\\\"2.69\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]}]}}\\\";s:7:\\\"user_id\\\";i:7479;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 23:14:48\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 23:14:48\\\";s:2:\\\"id\\\";i:3624;}s:11:\\\"\\u0000*\\u0000original\\\";a:5:{s:11:\\\"descripcion\\\";s:7772:\\\"{\\\"group_person_zone_actividad\\\":[{\\\"id\\\":41,\\\"user_id\\\":7479,\\\"person_id\\\":40719,\\\"zone_id\\\":23,\\\"actividad_id\\\":850,\\\"calculo_iibb\\\":2,\\\"coef\\\":\\\"0.91040\\\",\\\"alicuota\\\":\\\"4.00000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-30T02:14:13.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T02:14:13.000000Z\\\",\\\"deleted_at\\\":null,\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null},\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null}}],\\\"person\\\":{\\\"id\\\":40719,\\\"user_id\\\":7479,\\\"field_name1\\\":\\\"Gramajo Valeria\\\",\\\"field_name2\\\":null,\\\"document_type\\\":\\\"cuit\\\",\\\"document\\\":\\\"27-27178730-3\\\",\\\"cond_frente_al_iva_id\\\":null,\\\"country_id\\\":null,\\\"state_id\\\":null,\\\"zone_id\\\":null,\\\"plan_cuenta_id\\\":null,\\\"iva_creditos_tipo_id\\\":null,\\\"created_at\\\":\\\"2020-11-27T06:11:08.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:46:24.000000Z\\\",\\\"activity_id\\\":null,\\\"address\\\":null,\\\"person_type_id\\\":1,\\\"fa_iva_condition_id\\\":null,\\\"fa_codigo_postal\\\":null,\\\"email\\\":null,\\\"deleted_at\\\":null,\\\"person_config\\\":{\\\"id\\\":2,\\\"user_id\\\":7479,\\\"person_id\\\":40719,\\\"period_id\\\":null,\\\"zone_id\\\":null,\\\"settle_calc_by_coef\\\":0,\\\"created_at\\\":\\\"2022-07-29T21:55:31.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T02:14:13.000000Z\\\",\\\"active\\\":2,\\\"enviarMail\\\":1,\\\"honorario\\\":\\\"0.00\\\",\\\"cta_cte_tesoreria_cuenta_id\\\":null,\\\"month_close\\\":12,\\\"iva_condition_id\\\":1,\\\"obligation_sell\\\":1,\\\"obligation_buy\\\":1,\\\"obligation_iva\\\":0,\\\"obligation_electronic_receipt\\\":0,\\\"obligation_iibb\\\":4,\\\"obligation_other_taxes\\\":null,\\\"liquidation_start_period\\\":\\\"2022-1\\\",\\\"obligation_salaries\\\":0,\\\"empleada_domestica\\\":0,\\\"prorratear_iva\\\":0,\\\"is_itc\\\":0,\\\"priority_order\\\":2,\\\"person_id_administrador\\\":40719,\\\"person_id_titular\\\":40719,\\\"logo_path\\\":null,\\\"certificado_afip_path\\\":null,\\\"llave_afip_path\\\":null,\\\"access_electronic_receipt\\\":0,\\\"ruta_logo_fa\\\":null,\\\"inicio_actividades\\\":\\\"2022-07-29T03:00:00.000000Z\\\",\\\"iibb\\\":\\\"27271787303\\\",\\\"fe_leyenda\\\":null,\\\"atencion_iva\\\":0,\\\"atencion_iva_comentario\\\":null,\\\"atencion_iibb\\\":1,\\\"atencion_iibb_comentario\\\":null,\\\"deleted_at\\\":null}},\\\"settle\\\":{\\\"id\\\":27,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period\\\":{\\\"id\\\":8,\\\"user_id\\\":null,\\\"code\\\":\\\"2022-06\\\",\\\"year\\\":2022,\\\"period_number\\\":6,\\\"date_from\\\":\\\"2022-06-01\\\",\\\"date_to\\\":\\\"2022-06-30\\\",\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"person_id\\\":40719,\\\"conta_status\\\":0,\\\"deleted_at\\\":null,\\\"syj_periods_status_id\\\":1,\\\"syj_sin_asiento\\\":0,\\\"syj_asiento_modificado\\\":0,\\\"syj_periods_status_emp_dom_id\\\":1}},\\\"registros\\\":{\\\"id\\\":27,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period_liquidation_iibb\\\":[{\\\"id\\\":53,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":27,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":22,\\\"base_amount\\\":\\\"1000.00\\\",\\\"impuesto\\\":\\\"2.69\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"2.69\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":22,\\\"name\\\":\\\"Capital Federal\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"01\\\",\\\"sircreb_plan_cuenta_id\\\":277,\\\"codigo_cm\\\":901,\\\"codigo_afip\\\":\\\"0\\\"},\\\"details\\\":[{\\\"id\\\":54,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":27,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":2,\\\"actividad_id\\\":850,\\\"coef\\\":\\\"0.9104\\\",\\\"aliquot\\\":\\\"4.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"14600.00\\\",\\\"tax_amount\\\":\\\"531.67\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":55,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":27,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":2,\\\"actividad_id\\\":850,\\\"coef\\\":\\\"0.0896\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":1000,\\\"tax_amount\\\":2.69,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]},{\\\"id\\\":54,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":27,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":23,\\\"base_amount\\\":\\\"14600.00\\\",\\\"impuesto\\\":\\\"531.67\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"0.00\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":\\\"531.67\\\",\\\"a_favor\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":23,\\\"name\\\":\\\"Buenos Aires\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"02\\\",\\\"sircreb_plan_cuenta_id\\\":276,\\\"codigo_cm\\\":902,\\\"codigo_afip\\\":\\\"1\\\"},\\\"details\\\":[{\\\"id\\\":54,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":27,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":2,\\\"actividad_id\\\":850,\\\"coef\\\":\\\"0.9104\\\",\\\"aliquot\\\":\\\"4.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":14600,\\\"tax_amount\\\":531.67,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":55,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":27,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":2,\\\"actividad_id\\\":850,\\\"coef\\\":\\\"0.0896\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"1000.00\\\",\\\"tax_amount\\\":\\\"2.69\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T02:14:31.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]}]}}\\\";s:7:\\\"user_id\\\";i:7479;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 23:14:48\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 23:14:48\\\";s:2:\\\"id\\\";i:3624;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}}s:3:\\\"job\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";s:7:\\\"finance\\\";s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}','Symfony\\Component\\Process\\Exception\\ProcessTimedOutException: The process \"node /home/forge/taxes.com.ar/resources/js/puppeteer/CMCopiarValoresEnDDJJ.js 27271787303 Lasheras1790* 3624\" exceeded the timeout of 60 seconds. in /home/forge/taxes.com.ar/vendor/symfony/process/Process.php:1213\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(425): Symfony\\Component\\Process\\Process->checkTimeout()\n#1 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(249): Symfony\\Component\\Process\\Process->wait()\n#2 /home/forge/taxes.com.ar/app/Http/Controllers/Taxes/BOTCopiarEnAfipController.php(83): Symfony\\Component\\Process\\Process->run()\n#3 /home/forge/taxes.com.ar/app/Jobs/QueueGenerica.php(36): App\\Http\\Controllers\\Taxes\\BOTCopiarEnAfipController->Execute_Bot_Copiar_en_Afip(Object(Illuminate\\Support\\Collection))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): App\\Jobs\\QueueGenerica->handle()\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(94): Illuminate\\Container\\Container->call(Array)\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#12 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(98): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(83): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(App\\Jobs\\QueueGenerica), false)\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#15 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#16 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(85): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(59): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(App\\Queue\\DatabaseJob), Object(App\\Jobs\\QueueGenerica))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(App\\Queue\\DatabaseJob), Array)\n#19 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(26): Illuminate\\Queue\\Jobs\\Job->fire()\n#20 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#21 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'finance\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#22 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(265): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#23 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->runNextJob(\'finance\', \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#24 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'finance\', \'finance\')\n#25 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#26 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#27 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#28 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#29 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#30 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#31 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#32 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#33 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#34 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#35 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#36 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#37 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#38 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#39 {main}','2022-07-29 23:15:49',NULL);
INSERT INTO `failed_jobs` VALUES (9,NULL,'finance','finance','{\"uuid\":\"4dc5a928-6de3-4bd5-b2b6-3521bce5790b\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":9:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":5:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:11:\\\"controlador\\\";s:53:\\\"\\\\App\\\\Http\\\\Controllers\\\\Taxes\\\\BOTCopiarEnAfipController\\\";s:6:\\\"metodo\\\";s:26:\\\"Execute_Bot_Copiar_en_Afip\\\";s:12:\\\"metodo_error\\\";s:15:\\\"error_queue_bot\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":7:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:4:\\\"user\\\";O:8:\\\"App\\\\User\\\":28:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:6:\\\"tusers\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:6:\\\"idUser\\\";s:11:\\\"\\u0000*\\u0000fillable\\\";a:12:{i:0;s:6:\\\"nombre\\\";i:1;s:9:\\\"loginUser\\\";i:2;s:9:\\\"emailUser\\\";i:3;s:5:\\\"clave\\\";i:4;s:9:\\\"claveUser\\\";i:5;s:10:\\\"statusUser\\\";i:6;s:12:\\\"user_type_id\\\";i:7;s:5:\\\"firma\\\";i:8;s:15:\\\"suscrip_plan_id\\\";i:9;s:7:\\\"importe\\\";i:10;s:6:\\\"avatar\\\";i:11;s:18:\\\"es_empresa_externa\\\";}s:9:\\\"\\u0000*\\u0000hidden\\\";a:4:{i:0;s:8:\\\"password\\\";i:1;s:14:\\\"remember_token\\\";i:2;s:9:\\\"claveUser\\\";i:3;s:5:\\\"clave\\\";}s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:17:{s:6:\\\"idUser\\\";i:7479;s:6:\\\"nombre\\\";s:15:\\\"Gramajo Valeria\\\";s:9:\\\"loginUser\\\";s:16:\\\"vag730@gmail.com\\\";s:9:\\\"emailUser\\\";s:16:\\\"vag730@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27271787303\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$22PcHpDd5yh.X\\/iVCxAAJeeMbXZL\\/LfNDf33f7B8V9FiXlwHpR4Hy\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";s:6:\\\"person\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:21:{s:2:\\\"id\\\";i:47165;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:15:\\\"Gramajo Valeria\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-27178730-3\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:21:{s:2:\\\"id\\\";i:47165;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:15:\\\"Gramajo Valeria\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-27178730-3\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-11-27 00:11:08\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}s:11:\\\"\\u0000*\\u0000original\\\";a:16:{s:6:\\\"idUser\\\";i:7479;s:6:\\\"nombre\\\";s:15:\\\"Gramajo Valeria\\\";s:9:\\\"loginUser\\\";s:16:\\\"vag730@gmail.com\\\";s:9:\\\"emailUser\\\";s:16:\\\"vag730@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27271787303\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$22PcHpDd5yh.X\\/iVCxAAJeeMbXZL\\/LfNDf33f7B8V9FiXlwHpR4Hy\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-29 18:55:00\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:1:{i:0;s:1:\\\"*\\\";}s:20:\\\"\\u0000*\\u0000rememberTokenName\\\";s:14:\\\"remember_token\\\";}s:23:\\\"cuit_administrador_afip\\\";s:11:\\\"27271787303\\\";s:12:\\\"clave_fiscal\\\";s:13:\\\"Lasheras1790*\\\";s:5:\\\"sitio\\\";s:12:\\\"taxes.com.ar\\\";s:6:\\\"settle\\\";O:28:\\\"App\\\\Models\\\\PeriodLiquidation\\\":28:{s:8:\\\"\\u0000*\\u0000table\\\";s:19:\\\"period_liquidations\\\";s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:9:\\\"\\u0000*\\u0000hidden\\\";a:2:{i:0;s:10:\\\"created_at\\\";i:1;s:10:\\\"updated_at\\\";}s:10:\\\"\\u0000*\\u0000appends\\\";a:1:{i:0;s:15:\\\"files_relations\\\";}s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:10:{s:2:\\\"id\\\";i:41;s:7:\\\"user_id\\\";i:7479;s:8:\\\"apply_to\\\";s:4:\\\"iibb\\\";s:9:\\\"period_id\\\";i:8;s:9:\\\"person_id\\\";i:40719;s:6:\\\"status\\\";i:1;s:11:\\\"auxiliar_id\\\";i:3625;s:10:\\\"created_at\\\";s:19:\\\"2022-07-30 11:31:14\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-30 11:32:09\\\";s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:10:{s:2:\\\"id\\\";i:41;s:7:\\\"user_id\\\";i:7479;s:8:\\\"apply_to\\\";s:4:\\\"iibb\\\";s:9:\\\"period_id\\\";i:8;s:9:\\\"person_id\\\";i:40719;s:6:\\\"status\\\";i:1;s:11:\\\"auxiliar_id\\\";i:3625;s:10:\\\"created_at\\\";s:19:\\\"2022-07-30 11:31:14\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-07-30 11:32:09\\\";s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:2:{s:11:\\\"auxiliar_id\\\";i:3625;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-30 11:32:09\\\";}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:1:{i:0;s:10:\\\"deleted_at\\\";}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}s:8:\\\"auxiliar\\\";O:19:\\\"App\\\\Models\\\\Auxiliar\\\":27:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:8:\\\"auxiliar\\\";s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:1;s:13:\\\"\\u0000*\\u0000attributes\\\";a:5:{s:11:\\\"descripcion\\\";s:7767:\\\"{\\\"group_person_zone_actividad\\\":[{\\\"id\\\":49,\\\"user_id\\\":7479,\\\"person_id\\\":40719,\\\"zone_id\\\":23,\\\"actividad_id\\\":850,\\\"calculo_iibb\\\":1,\\\"coef\\\":\\\"0.91040\\\",\\\"alicuota\\\":\\\"4.00000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-30T14:30:57.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T14:30:57.000000Z\\\",\\\"deleted_at\\\":null,\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null},\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null}}],\\\"person\\\":{\\\"id\\\":40719,\\\"user_id\\\":7479,\\\"field_name1\\\":\\\"Gramajo Valeria\\\",\\\"field_name2\\\":null,\\\"document_type\\\":\\\"cuit\\\",\\\"document\\\":\\\"27-27178730-3\\\",\\\"cond_frente_al_iva_id\\\":null,\\\"country_id\\\":null,\\\"state_id\\\":null,\\\"zone_id\\\":null,\\\"plan_cuenta_id\\\":null,\\\"iva_creditos_tipo_id\\\":null,\\\"created_at\\\":\\\"2020-11-27T06:11:08.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:46:24.000000Z\\\",\\\"activity_id\\\":null,\\\"address\\\":null,\\\"person_type_id\\\":1,\\\"fa_iva_condition_id\\\":null,\\\"fa_codigo_postal\\\":null,\\\"email\\\":null,\\\"deleted_at\\\":null,\\\"person_config\\\":{\\\"id\\\":2,\\\"user_id\\\":7479,\\\"person_id\\\":40719,\\\"period_id\\\":null,\\\"zone_id\\\":null,\\\"settle_calc_by_coef\\\":0,\\\"created_at\\\":\\\"2022-07-29T21:55:31.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T14:30:57.000000Z\\\",\\\"active\\\":2,\\\"enviarMail\\\":1,\\\"honorario\\\":\\\"0.00\\\",\\\"cta_cte_tesoreria_cuenta_id\\\":null,\\\"month_close\\\":12,\\\"iva_condition_id\\\":1,\\\"obligation_sell\\\":1,\\\"obligation_buy\\\":1,\\\"obligation_iva\\\":0,\\\"obligation_electronic_receipt\\\":0,\\\"obligation_iibb\\\":4,\\\"obligation_other_taxes\\\":null,\\\"liquidation_start_period\\\":\\\"2022-1\\\",\\\"obligation_salaries\\\":0,\\\"empleada_domestica\\\":0,\\\"prorratear_iva\\\":0,\\\"is_itc\\\":0,\\\"priority_order\\\":2,\\\"person_id_administrador\\\":40719,\\\"person_id_titular\\\":40719,\\\"logo_path\\\":null,\\\"certificado_afip_path\\\":null,\\\"llave_afip_path\\\":null,\\\"access_electronic_receipt\\\":0,\\\"ruta_logo_fa\\\":null,\\\"inicio_actividades\\\":\\\"2022-07-29T03:00:00.000000Z\\\",\\\"iibb\\\":\\\"27271787303\\\",\\\"fe_leyenda\\\":null,\\\"atencion_iva\\\":0,\\\"atencion_iva_comentario\\\":null,\\\"atencion_iibb\\\":1,\\\"atencion_iibb_comentario\\\":null,\\\"deleted_at\\\":null}},\\\"settle\\\":{\\\"id\\\":41,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period\\\":{\\\"id\\\":8,\\\"user_id\\\":null,\\\"code\\\":\\\"2022-06\\\",\\\"year\\\":2022,\\\"period_number\\\":6,\\\"date_from\\\":\\\"2022-06-01\\\",\\\"date_to\\\":\\\"2022-06-30\\\",\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"person_id\\\":40719,\\\"conta_status\\\":0,\\\"deleted_at\\\":null,\\\"syj_periods_status_id\\\":1,\\\"syj_sin_asiento\\\":0,\\\"syj_asiento_modificado\\\":0,\\\"syj_periods_status_emp_dom_id\\\":1}},\\\"registros\\\":{\\\"id\\\":41,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period_liquidation_iibb\\\":[{\\\"id\\\":81,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":41,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":22,\\\"base_amount\\\":\\\"15600.00\\\",\\\"impuesto\\\":\\\"41.93\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"19.36\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":22.57,\\\"a_favor\\\":0,\\\"created_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":22,\\\"name\\\":\\\"Capital Federal\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"01\\\",\\\"sircreb_plan_cuenta_id\\\":277,\\\"codigo_cm\\\":901,\\\"codigo_afip\\\":\\\"0\\\"},\\\"details\\\":[{\\\"id\\\":82,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":41,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":850,\\\"coef\\\":\\\"0.9104\\\",\\\"aliquot\\\":\\\"4.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"15600.00\\\",\\\"tax_amount\\\":\\\"568.09\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":83,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":41,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":850,\\\"coef\\\":\\\"0.0896\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":15600,\\\"tax_amount\\\":41.93,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]},{\\\"id\\\":82,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":41,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":23,\\\"base_amount\\\":\\\"15600.00\\\",\\\"impuesto\\\":\\\"568.09\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"23.64\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":544.45,\\\"a_favor\\\":0,\\\"created_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":23,\\\"name\\\":\\\"Buenos Aires\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"02\\\",\\\"sircreb_plan_cuenta_id\\\":276,\\\"codigo_cm\\\":902,\\\"codigo_afip\\\":\\\"1\\\"},\\\"details\\\":[{\\\"id\\\":82,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":41,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":850,\\\"coef\\\":\\\"0.9104\\\",\\\"aliquot\\\":\\\"4.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":15600,\\\"tax_amount\\\":568.09,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":83,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":41,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":850,\\\"coef\\\":\\\"0.0896\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"15600.00\\\",\\\"tax_amount\\\":\\\"41.93\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]}]}}\\\";s:7:\\\"user_id\\\";i:7479;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-30 11:32:09\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-07-30 11:32:09\\\";s:2:\\\"id\\\";i:3625;}s:11:\\\"\\u0000*\\u0000original\\\";a:5:{s:11:\\\"descripcion\\\";s:7767:\\\"{\\\"group_person_zone_actividad\\\":[{\\\"id\\\":49,\\\"user_id\\\":7479,\\\"person_id\\\":40719,\\\"zone_id\\\":23,\\\"actividad_id\\\":850,\\\"calculo_iibb\\\":1,\\\"coef\\\":\\\"0.91040\\\",\\\"alicuota\\\":\\\"4.00000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-30T14:30:57.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T14:30:57.000000Z\\\",\\\"deleted_at\\\":null,\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null},\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null}}],\\\"person\\\":{\\\"id\\\":40719,\\\"user_id\\\":7479,\\\"field_name1\\\":\\\"Gramajo Valeria\\\",\\\"field_name2\\\":null,\\\"document_type\\\":\\\"cuit\\\",\\\"document\\\":\\\"27-27178730-3\\\",\\\"cond_frente_al_iva_id\\\":null,\\\"country_id\\\":null,\\\"state_id\\\":null,\\\"zone_id\\\":null,\\\"plan_cuenta_id\\\":null,\\\"iva_creditos_tipo_id\\\":null,\\\"created_at\\\":\\\"2020-11-27T06:11:08.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T01:46:24.000000Z\\\",\\\"activity_id\\\":null,\\\"address\\\":null,\\\"person_type_id\\\":1,\\\"fa_iva_condition_id\\\":null,\\\"fa_codigo_postal\\\":null,\\\"email\\\":null,\\\"deleted_at\\\":null,\\\"person_config\\\":{\\\"id\\\":2,\\\"user_id\\\":7479,\\\"person_id\\\":40719,\\\"period_id\\\":null,\\\"zone_id\\\":null,\\\"settle_calc_by_coef\\\":0,\\\"created_at\\\":\\\"2022-07-29T21:55:31.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T14:30:57.000000Z\\\",\\\"active\\\":2,\\\"enviarMail\\\":1,\\\"honorario\\\":\\\"0.00\\\",\\\"cta_cte_tesoreria_cuenta_id\\\":null,\\\"month_close\\\":12,\\\"iva_condition_id\\\":1,\\\"obligation_sell\\\":1,\\\"obligation_buy\\\":1,\\\"obligation_iva\\\":0,\\\"obligation_electronic_receipt\\\":0,\\\"obligation_iibb\\\":4,\\\"obligation_other_taxes\\\":null,\\\"liquidation_start_period\\\":\\\"2022-1\\\",\\\"obligation_salaries\\\":0,\\\"empleada_domestica\\\":0,\\\"prorratear_iva\\\":0,\\\"is_itc\\\":0,\\\"priority_order\\\":2,\\\"person_id_administrador\\\":40719,\\\"person_id_titular\\\":40719,\\\"logo_path\\\":null,\\\"certificado_afip_path\\\":null,\\\"llave_afip_path\\\":null,\\\"access_electronic_receipt\\\":0,\\\"ruta_logo_fa\\\":null,\\\"inicio_actividades\\\":\\\"2022-07-29T03:00:00.000000Z\\\",\\\"iibb\\\":\\\"27271787303\\\",\\\"fe_leyenda\\\":null,\\\"atencion_iva\\\":0,\\\"atencion_iva_comentario\\\":null,\\\"atencion_iibb\\\":1,\\\"atencion_iibb_comentario\\\":null,\\\"deleted_at\\\":null}},\\\"settle\\\":{\\\"id\\\":41,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period\\\":{\\\"id\\\":8,\\\"user_id\\\":null,\\\"code\\\":\\\"2022-06\\\",\\\"year\\\":2022,\\\"period_number\\\":6,\\\"date_from\\\":\\\"2022-06-01\\\",\\\"date_to\\\":\\\"2022-06-30\\\",\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"person_id\\\":40719,\\\"conta_status\\\":0,\\\"deleted_at\\\":null,\\\"syj_periods_status_id\\\":1,\\\"syj_sin_asiento\\\":0,\\\"syj_asiento_modificado\\\":0,\\\"syj_periods_status_emp_dom_id\\\":1}},\\\"registros\\\":{\\\"id\\\":41,\\\"user_id\\\":7479,\\\"apply_to\\\":\\\"iibb\\\",\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period_liquidation_iibb\\\":[{\\\"id\\\":81,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":41,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":22,\\\"base_amount\\\":\\\"15600.00\\\",\\\"impuesto\\\":\\\"41.93\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"19.36\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":22.57,\\\"a_favor\\\":0,\\\"created_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":22,\\\"name\\\":\\\"Capital Federal\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"01\\\",\\\"sircreb_plan_cuenta_id\\\":277,\\\"codigo_cm\\\":901,\\\"codigo_afip\\\":\\\"0\\\"},\\\"details\\\":[{\\\"id\\\":82,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":41,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":850,\\\"coef\\\":\\\"0.9104\\\",\\\"aliquot\\\":\\\"4.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"15600.00\\\",\\\"tax_amount\\\":\\\"568.09\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":83,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":41,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":850,\\\"coef\\\":\\\"0.0896\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":15600,\\\"tax_amount\\\":41.93,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]},{\\\"id\\\":82,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":41,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":23,\\\"base_amount\\\":\\\"15600.00\\\",\\\"impuesto\\\":\\\"568.09\\\",\\\"saldo_a_favor_ant\\\":0,\\\"sircreb\\\":\\\"23.64\\\",\\\"percepciones\\\":\\\"0.00\\\",\\\"retenciones\\\":\\\"0.00\\\",\\\"a_pagar\\\":544.45,\\\"a_favor\\\":0,\\\"created_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"zone\\\":{\\\"id\\\":23,\\\"name\\\":\\\"Buenos Aires\\\",\\\"sifere_coef\\\":\\\"0.00\\\",\\\"iibb_aliquot\\\":\\\"0.00\\\",\\\"iibb_perception_id\\\":null,\\\"retention_id\\\":null,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2022-07-29T21:55:25.000000Z\\\",\\\"code\\\":\\\"02\\\",\\\"sircreb_plan_cuenta_id\\\":276,\\\"codigo_cm\\\":902,\\\"codigo_afip\\\":\\\"1\\\"},\\\"details\\\":[{\\\"id\\\":82,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":41,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":23,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":850,\\\"coef\\\":\\\"0.9104\\\",\\\"aliquot\\\":\\\"4.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":15600,\\\"tax_amount\\\":568.09,\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}},{\\\"id\\\":83,\\\"user_id\\\":7479,\\\"period_liquidation_id\\\":41,\\\"period_id\\\":8,\\\"person_id\\\":40719,\\\"zone_id\\\":22,\\\"calculo_iibb\\\":1,\\\"actividad_id\\\":850,\\\"coef\\\":\\\"0.0896\\\",\\\"aliquot\\\":\\\"3.0000\\\",\\\"cm_articulo_regimen_id\\\":1,\\\"base_amount\\\":\\\"15600.00\\\",\\\"tax_amount\\\":\\\"41.93\\\",\\\"previous_period_balance\\\":\\\"0.00\\\",\\\"sircreb_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"balance\\\":0,\\\"created_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-30T14:31:14.000000Z\\\",\\\"deleted_at\\\":null,\\\"actividad\\\":{\\\"id\\\":850,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Servicios de fotocopiado, preparaci\\u00f3n de documentos y otros servicios de apoyo de oficina\\\",\\\"codigo_afip\\\":\\\"821900\\\",\\\"codigo_cm\\\":null},\\\"cm_articulo_regimen\\\":{\\\"id\\\":1,\\\"user_id\\\":null,\\\"descripcion\\\":\\\"Articulo 2\\\",\\\"codigo\\\":2,\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-07-29T21:55:22.000000Z\\\",\\\"deleted_at\\\":null}}]}]}}\\\";s:7:\\\"user_id\\\";i:7479;s:10:\\\"updated_at\\\";s:19:\\\"2022-07-30 11:32:09\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-07-30 11:32:09\\\";s:2:\\\"id\\\";i:3625;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}}s:3:\\\"job\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";s:7:\\\"finance\\\";s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}','Symfony\\Component\\Process\\Exception\\ProcessTimedOutException: The process \"node /home/forge/taxes.com.ar/resources/js/puppeteer/CMCopiarValoresEnDDJJ.js 27271787303 Lasheras1790* 3625\" exceeded the timeout of 60 seconds. in /home/forge/taxes.com.ar/vendor/symfony/process/Process.php:1213\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(425): Symfony\\Component\\Process\\Process->checkTimeout()\n#1 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(249): Symfony\\Component\\Process\\Process->wait()\n#2 /home/forge/taxes.com.ar/app/Http/Controllers/Taxes/BOTCopiarEnAfipController.php(83): Symfony\\Component\\Process\\Process->run()\n#3 /home/forge/taxes.com.ar/app/Jobs/QueueGenerica.php(36): App\\Http\\Controllers\\Taxes\\BOTCopiarEnAfipController->Execute_Bot_Copiar_en_Afip(Object(Illuminate\\Support\\Collection))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): App\\Jobs\\QueueGenerica->handle()\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(94): Illuminate\\Container\\Container->call(Array)\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#12 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(98): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(83): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(App\\Jobs\\QueueGenerica), false)\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#15 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#16 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(85): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(59): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(App\\Queue\\DatabaseJob), Object(App\\Jobs\\QueueGenerica))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(App\\Queue\\DatabaseJob), Array)\n#19 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(26): Illuminate\\Queue\\Jobs\\Job->fire()\n#20 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#21 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'finance\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#22 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(265): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#23 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->runNextJob(\'finance\', \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#24 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'finance\', \'finance\')\n#25 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#26 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#27 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#28 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#29 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#30 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#31 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#32 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#33 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#34 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#35 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#36 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#37 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#38 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#39 {main}','2022-07-30 11:33:09',NULL);
INSERT INTO `failed_jobs` VALUES (10,NULL,'finance','finance','{\"uuid\":\"6349d3dc-3af9-41db-8f26-418094699354\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":9:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":5:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:11:\\\"controlador\\\";s:53:\\\"\\\\App\\\\Http\\\\Controllers\\\\Taxes\\\\BOTCopiarEnAfipController\\\";s:6:\\\"metodo\\\";s:26:\\\"Execute_Bot_Copiar_en_Afip\\\";s:12:\\\"metodo_error\\\";s:15:\\\"error_queue_bot\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":7:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:4:\\\"user\\\";O:8:\\\"App\\\\User\\\":28:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:6:\\\"tusers\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:6:\\\"idUser\\\";s:11:\\\"\\u0000*\\u0000fillable\\\";a:12:{i:0;s:6:\\\"nombre\\\";i:1;s:9:\\\"loginUser\\\";i:2;s:9:\\\"emailUser\\\";i:3;s:5:\\\"clave\\\";i:4;s:9:\\\"claveUser\\\";i:5;s:10:\\\"statusUser\\\