-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-27789193-5
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-08-05 09:30:07','Actividad Generica 1','000001',NULL),(2,NULL,'2022-08-05 09:30:07','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'Estudio5233',NULL,1,40723,'2023-02-09'),(2,NULL,'Estudio5233',NULL,1,40723,'2023-02-09'),(3,NULL,'Estudio5233',NULL,1,40723,'2023-02-10'),(4,NULL,'Estudio5233',NULL,1,40723,'2023-02-10'),(5,NULL,'Estudio5623',NULL,1,40723,'2023-02-10'),(6,NULL,'Estudio5623',NULL,1,40723,'2023-02-10'),(7,NULL,'Estudio5623',NULL,1,40723,'2023-02-10'),(8,NULL,'Estudio5623',NULL,1,40723,'2023-07-03'),(9,NULL,'Estudio5623',NULL,1,40723,'2025-07-07');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'laura@estudiopetrini.com.ar',NULL,'',1,40720,'2022-10-25'),(2,'laura@estudiopetrini.com.ar',NULL,'',1,40721,'2022-10-25'),(3,'laura@estudiopetrini.com.ar',NULL,'',1,40720,'2022-10-25'),(4,'laura@estudiopetrini.com.ar',NULL,'',1,40720,'2022-10-25'),(5,'laura@estudiopetrini.com.ar',NULL,'',1,40721,'2022-10-25'),(6,'laura@estudiopetrini.com.ar',NULL,'',1,40720,'2022-10-25'),(7,'laura@estudiopetrini.com.ar',NULL,'',1,40720,'2022-10-25'),(8,'laura@estudiopetrini.com.ar',NULL,'',1,40720,'2022-10-25'),(9,'laura@estudiopetrini.com.ar',NULL,'',1,40720,'2022-10-25'),(10,'laura@estudiopetrini.com.ar',NULL,'',1,40720,'2022-10-25'),(11,'laura@estudiopetrini.com.ar',NULL,'',1,40720,'2022-10-25'),(12,'laura@estudiopetrini.com.ar',NULL,'',1,40720,'2022-10-25'),(13,'laura@estudiopetrini.com.ar',NULL,'',1,40720,'2022-10-25'),(14,'laura@estudiopetrini.com.ar',NULL,'',1,40720,'2022-10-25'),(15,'laura@estudiopetrini.com.ar',NULL,'',1,40720,'2022-10-25'),(16,'laura@estudiopetrini.com.ar',NULL,'',1,40721,'2023-01-19'),(17,'laura@estudiopetrini.com.ar',NULL,'',1,40720,'2023-01-26'),(18,'laura@estudiopetrini.com.ar',NULL,'',1,40721,'2023-02-01'),(19,'laura@estudiopetrini.com.ar',NULL,'',1,40720,'2023-06-02');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=198 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7503,40720,1515,1,1,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-09-30',NULL,92014.56,NULL,NULL,1,'2023-01-11 17:03:00','2023-01-19 17:59:35','2023-01-19 17:59:35'),(2,7503,40723,6282,2,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',11554.29,NULL,NULL,1,'2023-02-06 10:22:33','2023-02-09 15:24:58','2023-02-09 15:24:58'),(3,7503,40723,6282,2,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',33880.00,NULL,NULL,1,'2023-02-06 10:22:33','2023-02-09 15:08:26','2023-02-09 15:08:26'),(4,7503,40723,6283,2,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',32700.00,NULL,NULL,1,'2023-02-06 10:24:44','2023-02-09 15:25:10','2023-02-09 15:25:10'),(5,7503,40723,6283,2,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',10623.80,NULL,NULL,1,'2023-02-06 10:24:44','2023-02-09 15:25:14','2023-02-09 15:25:14'),(6,7503,40723,6283,3,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',513.39,NULL,NULL,1,'2023-02-06 10:26:06','2023-02-06 10:30:07','2023-02-06 10:30:07'),(7,7503,40723,6283,3,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',18530.75,NULL,NULL,1,'2023-02-06 10:26:06','2023-02-06 10:29:59','2023-02-06 10:29:59'),(8,7503,40723,6283,3,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',7999.00,NULL,NULL,1,'2023-02-06 10:26:06','2023-02-06 10:29:52','2023-02-06 10:29:52'),(9,7503,40723,6283,3,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',5578.90,NULL,NULL,1,'2023-02-06 10:26:06','2023-02-06 10:29:45','2023-02-06 10:29:45'),(10,7503,40723,6283,3,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',299.00,NULL,NULL,1,'2023-02-06 10:26:06','2023-02-06 10:29:38','2023-02-06 10:29:38'),(11,7503,40723,6283,3,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',279.65,NULL,NULL,1,'2023-02-06 10:26:06','2023-02-06 10:29:22','2023-02-06 10:29:22'),(12,7503,40723,6283,3,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',25619.40,NULL,NULL,1,'2023-02-06 10:26:06','2023-02-06 10:29:14','2023-02-06 10:29:14'),(13,7503,40723,6282,3,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',513.39,NULL,NULL,1,'2023-02-06 10:31:07','2023-02-09 15:26:35','2023-02-09 15:26:35'),(14,7503,40723,6282,3,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',18530.75,NULL,NULL,1,'2023-02-06 10:31:08','2023-02-07 14:39:42','2023-02-07 14:39:42'),(15,7503,40723,6282,3,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',7999.00,NULL,NULL,1,'2023-02-06 10:31:08','2023-02-09 15:26:27','2023-02-09 15:26:27'),(16,7503,40723,6282,3,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',5578.90,NULL,NULL,1,'2023-02-06 10:31:08','2023-02-09 15:25:36','2023-02-09 15:25:36'),(17,7503,40723,6282,3,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',299.00,NULL,NULL,1,'2023-02-06 10:31:08','2023-02-09 15:26:23','2023-02-09 15:26:23'),(18,7503,40723,6282,3,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',279.65,NULL,NULL,1,'2023-02-06 10:31:08','2023-02-09 15:26:16','2023-02-09 15:26:16'),(19,7503,40723,6282,3,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',25619.40,NULL,NULL,1,'2023-02-06 10:31:08','2023-02-07 14:40:23','2023-02-07 14:40:23'),(20,7503,40723,6283,3,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',204.00,NULL,NULL,1,'2023-02-06 10:31:45','2023-02-09 15:26:12','2023-02-09 15:26:12');
INSERT INTO `balance_libro` VALUES (21,7503,40723,6283,3,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1815.00,NULL,NULL,1,'2023-02-06 10:31:45','2023-02-09 15:26:09','2023-02-09 15:26:09'),(22,7503,40723,6283,3,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',12766.97,NULL,NULL,1,'2023-02-06 10:31:45','2023-02-09 15:25:54','2023-02-09 15:25:54'),(23,7503,40723,6283,3,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3150.18,NULL,NULL,1,'2023-02-06 10:31:45','2023-02-09 15:26:01','2023-02-09 15:26:01'),(24,7503,40723,6283,3,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8302.28,NULL,NULL,1,'2023-02-06 10:31:45','2023-02-09 15:25:49','2023-02-09 15:25:49'),(25,7503,40723,6283,3,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',68.00,NULL,NULL,1,'2023-02-06 10:31:45','2023-02-09 15:25:57','2023-02-09 15:25:57'),(26,7503,40723,6283,3,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',100.00,NULL,NULL,1,'2023-02-06 10:31:45','2023-02-09 15:25:32','2023-02-09 15:25:32'),(27,7503,40723,6283,3,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',7691.84,NULL,NULL,1,'2023-02-06 10:31:45','2023-02-09 15:25:24','2023-02-09 15:25:24'),(30,7503,40723,6282,3,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',18530.75,NULL,NULL,1,'2023-02-07 14:39:42','2023-02-09 15:26:30','2023-02-09 15:26:30'),(31,7503,40723,6282,3,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',25619.40,NULL,NULL,1,'2023-02-07 14:40:23','2023-02-09 15:25:40','2023-02-09 15:25:40'),(32,7503,40723,6282,7,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'0000-00-00','0000-00-00',72.00,NULL,NULL,1,'2023-02-07 14:46:03','2023-02-09 15:26:48','2023-02-09 15:26:48'),(33,7503,40723,6282,7,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1621-12-23','1621-12-23',7.00,NULL,NULL,1,'2023-02-07 14:46:03','2023-02-09 15:26:43','2023-02-09 15:26:43'),(34,7503,40723,6282,2,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',33880.00,NULL,NULL,1,'2023-02-09 15:08:26','2023-02-09 15:25:05','2023-02-09 15:25:05'),(35,7503,40723,6282,3,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',513.39,NULL,NULL,1,'2023-02-09 15:31:05','2023-02-09 15:56:51','2023-02-09 15:56:51'),(36,7503,40723,6282,3,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',18530.75,NULL,NULL,1,'2023-02-09 15:31:05','2023-02-09 15:35:18','2023-02-09 15:35:18'),(37,7503,40723,6282,3,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',7999.00,NULL,NULL,1,'2023-02-09 15:31:05','2023-02-09 15:50:23','2023-02-09 15:50:23'),(38,7503,40723,6282,3,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',5578.90,NULL,NULL,1,'2023-02-09 15:31:06','2023-02-09 15:56:44','2023-02-09 15:56:44'),(39,7503,40723,6282,3,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',299.00,NULL,NULL,1,'2023-02-09 15:31:06','2023-02-09 15:56:40','2023-02-09 15:56:40'),(40,7503,40723,6282,3,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',279.65,NULL,NULL,1,'2023-02-09 15:31:06','2023-02-09 15:56:36','2023-02-09 15:56:36'),(41,7503,40723,6282,3,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',25619.40,NULL,NULL,1,'2023-02-09 15:31:06','2023-02-09 15:33:13','2023-02-09 15:33:13'),(42,7503,40723,6282,3,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',25619.40,NULL,NULL,1,'2023-02-09 15:33:13','2023-02-09 15:34:42','2023-02-09 15:34:42');
INSERT INTO `balance_libro` VALUES (43,7503,40723,6282,3,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',25619.40,NULL,NULL,1,'2023-02-09 15:34:42','2023-02-09 15:56:31','2023-02-09 15:56:31'),(44,7503,40723,6282,3,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',18530.75,NULL,NULL,1,'2023-02-09 15:35:18','2023-02-09 15:56:47','2023-02-09 15:56:47'),(45,7503,40723,6282,2,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',11554.29,NULL,NULL,1,'2023-02-09 15:43:51','2023-02-09 16:44:55','2023-02-09 16:44:55'),(46,7503,40723,6282,2,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',33880.00,NULL,NULL,1,'2023-02-09 15:43:51','2023-02-09 15:44:21','2023-02-09 15:44:21'),(47,7503,40723,6282,2,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',33880.00,NULL,NULL,1,'2023-02-09 15:44:21','2023-02-09 16:44:51','2023-02-09 16:44:51'),(48,7503,40723,6282,3,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',513.39,NULL,NULL,1,'2023-02-09 16:16:04','2023-02-09 16:16:50','2023-02-09 16:16:50'),(49,7503,40723,6282,3,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',18530.75,NULL,NULL,1,'2023-02-09 16:16:04','2023-02-09 16:17:36','2023-02-09 16:17:36'),(50,7503,40723,6282,3,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',7999.00,NULL,NULL,1,'2023-02-09 16:16:05','2023-02-09 16:16:45','2023-02-09 16:16:45'),(51,7503,40723,6282,3,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',5578.90,NULL,NULL,1,'2023-02-09 16:16:05','2023-02-09 16:16:33','2023-02-09 16:16:33'),(52,7503,40723,6282,3,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',299.00,NULL,NULL,1,'2023-02-09 16:16:05','2023-02-09 16:16:23','2023-02-09 16:16:23'),(53,7503,40723,6282,3,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',279.65,NULL,NULL,1,'2023-02-09 16:16:05','2023-02-09 16:16:38','2023-02-09 16:16:38'),(54,7503,40723,6282,3,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',25619.40,NULL,NULL,1,'2023-02-09 16:16:05','2023-02-09 16:17:08','2023-02-09 16:17:08'),(55,7503,40723,6282,3,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',25619.40,NULL,NULL,1,'2023-02-09 16:17:08','2023-02-09 16:45:03','2023-02-09 16:45:03'),(56,7503,40723,6282,3,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',18530.75,NULL,NULL,1,'2023-02-09 16:17:36','2023-02-09 16:45:07','2023-02-09 16:45:07'),(57,7503,40723,6283,2,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',32700.00,NULL,NULL,1,'2023-02-09 16:48:36','2023-02-10 15:41:05','2023-02-10 15:41:05'),(58,7503,40723,6283,2,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',10623.80,NULL,NULL,1,'2023-02-09 16:48:36','2023-02-10 15:40:55','2023-02-10 15:40:55'),(59,7503,40723,6283,3,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8302.28,NULL,NULL,1,'2023-02-09 16:51:04','2023-02-09 16:53:01','2023-02-09 16:53:01'),(60,7503,40723,6283,3,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',7691.84,NULL,NULL,1,'2023-02-09 16:51:04','2023-02-09 16:59:46','2023-02-09 16:59:46'),(61,7503,40723,6283,3,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8302.28,NULL,NULL,1,'2023-02-09 16:53:01','2023-02-09 17:42:06','2023-02-09 17:42:06'),(62,7503,40723,6283,3,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',7691.84,NULL,NULL,1,'2023-02-09 16:59:46','2023-02-09 17:42:02','2023-02-09 17:42:02');
INSERT INTO `balance_libro` VALUES (63,7503,40723,6283,15,135,'App\\Models\\PeriodLiquidation',NULL,135,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7519.01,NULL,NULL,1,'2023-02-09 17:05:23','2023-02-09 17:21:37','2023-02-09 17:21:37'),(64,7503,40723,6283,3,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',204.00,NULL,NULL,1,'2023-02-09 17:26:29','2023-02-09 17:41:59','2023-02-09 17:41:59'),(65,7503,40723,6283,3,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1815.00,NULL,NULL,1,'2023-02-09 17:26:29','2023-02-09 17:41:54','2023-02-09 17:41:54'),(66,7503,40723,6283,3,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',12766.97,NULL,NULL,1,'2023-02-09 17:26:29','2023-02-09 17:41:49','2023-02-09 17:41:49'),(67,7503,40723,6283,3,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3150.18,NULL,NULL,1,'2023-02-09 17:26:29','2023-02-09 17:41:39','2023-02-09 17:41:39'),(68,7503,40723,6283,3,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',68.00,NULL,NULL,1,'2023-02-09 17:26:29','2023-02-09 17:41:22','2023-02-09 17:41:22'),(69,7503,40723,6283,3,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',100.00,NULL,NULL,1,'2023-02-09 17:26:29','2023-02-09 17:41:16','2023-02-09 17:41:16'),(70,7503,40723,6283,3,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',204.00,NULL,NULL,1,'2023-02-09 17:42:44','2023-02-10 15:42:14','2023-02-10 15:42:14'),(71,7503,40723,6283,3,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1815.00,NULL,NULL,1,'2023-02-09 17:42:44','2023-02-10 15:42:07','2023-02-10 15:42:07'),(72,7503,40723,6283,3,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',12766.97,NULL,NULL,1,'2023-02-09 17:42:44','2023-02-10 15:42:00','2023-02-10 15:42:00'),(73,7503,40723,6283,3,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3150.18,NULL,NULL,1,'2023-02-09 17:42:44','2023-02-10 15:41:53','2023-02-10 15:41:53'),(74,7503,40723,6283,3,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8302.28,NULL,NULL,1,'2023-02-09 17:42:44','2023-02-09 17:43:34','2023-02-09 17:43:34'),(75,7503,40723,6283,3,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',68.00,NULL,NULL,1,'2023-02-09 17:42:44','2023-02-10 15:41:35','2023-02-10 15:41:35'),(76,7503,40723,6283,3,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',100.00,NULL,NULL,1,'2023-02-09 17:42:44','2023-02-10 15:41:27','2023-02-10 15:41:27'),(77,7503,40723,6283,3,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',7691.84,NULL,NULL,1,'2023-02-09 17:42:44','2023-02-09 17:44:15','2023-02-09 17:44:15'),(78,7503,40723,6283,3,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8302.28,NULL,NULL,1,'2023-02-09 17:43:34','2023-02-10 15:41:45','2023-02-10 15:41:45'),(79,7503,40723,6283,3,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',7691.84,NULL,NULL,1,'2023-02-09 17:44:15','2023-02-09 17:48:14','2023-02-09 17:48:14'),(80,7503,40723,6283,3,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',7691.84,NULL,NULL,1,'2023-02-09 17:48:14','2023-02-10 15:41:19','2023-02-10 15:41:19'),(81,7503,40723,6283,15,161,'App\\Models\\PeriodLiquidation',NULL,161,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7519.01,NULL,NULL,1,'2023-02-09 17:49:09','2023-02-09 19:54:37','2023-02-09 19:54:37');
INSERT INTO `balance_libro` VALUES (82,7503,40723,6283,15,161,'App\\Models\\PeriodLiquidation',NULL,161,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7519.01,NULL,NULL,1,'2023-02-09 20:04:24','2023-02-09 20:04:32','2023-02-09 20:04:32'),(83,7503,40723,6283,15,161,'App\\Models\\PeriodLiquidation',NULL,161,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7519.01,NULL,NULL,1,'2023-02-09 20:31:51','2023-02-09 20:32:05','2023-02-09 20:32:05'),(84,7503,40723,6283,2,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',32700.00,NULL,NULL,1,'2023-02-10 15:45:44','2023-02-10 15:45:44',NULL),(85,7503,40723,6283,2,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',10623.80,NULL,NULL,1,'2023-02-10 15:45:44','2023-02-10 15:45:44',NULL),(86,7503,40723,6283,3,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8302.28,NULL,NULL,1,'2023-02-10 15:46:31','2023-02-10 15:47:46','2023-02-10 15:47:46'),(87,7503,40723,6283,3,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',7691.84,NULL,NULL,1,'2023-02-10 15:46:31','2023-02-10 16:01:41','2023-02-10 16:01:41'),(88,7503,40723,6283,3,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8302.28,NULL,NULL,1,'2023-02-10 15:47:46','2023-02-10 15:47:46',NULL),(89,7503,40723,6283,3,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',7691.84,NULL,NULL,1,'2023-02-10 16:01:41','2023-02-10 16:01:41',NULL),(90,7503,40722,4529,2,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',352273.80,NULL,NULL,1,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(91,7503,40722,4529,2,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',636476.94,NULL,NULL,1,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(92,7503,40722,4529,2,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',330876.93,NULL,NULL,1,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(93,7503,40722,4529,2,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',650600.08,NULL,NULL,1,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(94,7503,40722,4529,2,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',451760.12,NULL,NULL,1,'2023-03-21 10:02:49','2023-03-21 10:02:49',NULL),(95,7503,40722,4529,2,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',102221.66,NULL,NULL,1,'2023-03-21 10:02:49','2023-03-21 10:02:49',NULL),(96,7503,40722,4529,2,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',115975.16,NULL,NULL,1,'2023-03-21 10:02:49','2023-03-21 10:02:49',NULL),(97,7503,40722,4529,2,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-21 10:02:49','2023-03-21 10:07:52','2023-03-21 10:07:52'),(98,7503,40722,4529,3,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',5288.04,NULL,NULL,1,'2023-03-21 10:06:12','2023-03-21 10:12:36','2023-03-21 10:12:36'),(99,7503,40722,4529,3,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',11160.00,NULL,NULL,1,'2023-03-21 10:06:12','2023-03-21 10:12:03','2023-03-21 10:12:03'),(100,7503,40722,4529,3,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',6046.74,NULL,NULL,1,'2023-03-21 10:06:12','2023-03-21 10:11:38','2023-03-21 10:11:38'),(101,7503,40722,4529,3,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',22151.50,NULL,NULL,1,'2023-03-21 10:06:12','2023-03-21 10:06:12',NULL);
INSERT INTO `balance_libro` VALUES (102,7503,40722,4529,3,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',49630.00,NULL,NULL,1,'2023-03-21 10:06:13','2023-03-21 10:06:13',NULL),(103,7503,40722,4529,3,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',35060.00,NULL,NULL,1,'2023-03-21 10:06:13','2023-03-21 10:06:13',NULL),(104,7503,40722,4529,3,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',10007.86,NULL,NULL,1,'2023-03-21 10:06:13','2023-03-21 10:11:04','2023-03-21 10:11:04'),(105,7503,40722,4529,3,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',19950.00,NULL,NULL,1,'2023-03-21 10:06:13','2023-03-21 10:06:13',NULL),(106,7503,40722,4529,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',70792.14,NULL,NULL,1,'2023-03-21 10:06:13','2023-03-21 10:09:47','2023-03-21 10:09:47'),(107,7503,40722,4529,3,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',8990.00,NULL,NULL,1,'2023-03-21 10:06:13','2023-03-21 10:09:29','2023-03-21 10:09:29'),(108,7503,40722,4529,3,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',8100.99,NULL,NULL,1,'2023-03-21 10:06:13','2023-03-21 10:09:03','2023-03-21 10:09:03'),(109,7503,40722,4529,3,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',8100.99,NULL,NULL,1,'2023-03-21 10:09:03','2023-03-21 10:09:03',NULL),(110,7503,40722,4529,3,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',8990.00,NULL,NULL,1,'2023-03-21 10:09:29','2023-03-21 10:09:29',NULL),(111,7503,40722,4529,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',70792.14,NULL,NULL,1,'2023-03-21 10:09:47','2023-03-21 10:09:47',NULL),(112,7503,40722,4529,3,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',10005.87,NULL,NULL,1,'2023-03-21 10:11:04','2023-03-21 10:11:04',NULL),(113,7503,40722,4529,3,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',6046.74,NULL,NULL,1,'2023-03-21 10:11:38','2023-03-21 10:11:38',NULL),(114,7503,40722,4529,3,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',11160.00,NULL,NULL,1,'2023-03-21 10:12:03','2023-03-21 10:12:03',NULL),(115,7503,40722,4529,3,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',5288.04,NULL,NULL,1,'2023-03-21 10:12:36','2023-03-21 10:12:36',NULL),(116,7503,40722,4529,3,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',8968.40,NULL,NULL,1,'2023-03-21 10:16:27','2023-03-21 10:16:27',NULL),(117,7503,40722,4529,7,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',701.65,NULL,NULL,1,'2023-03-21 10:36:10','2023-03-21 10:36:10',NULL),(118,7503,40722,4529,7,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',85.25,NULL,NULL,1,'2023-03-21 10:37:57','2023-03-21 10:37:57',NULL),(119,7503,40722,4529,15,221,'App\\Models\\PeriodLiquidation',NULL,221,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',458213.98,NULL,NULL,1,'2023-03-21 10:41:45','2023-03-21 10:41:45',NULL),(120,7503,40722,4529,16,222,'App\\Models\\PeriodLiquidation',NULL,222,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1318.92,NULL,NULL,1,'2023-03-21 10:41:51','2023-03-21 10:41:51',NULL),(121,7503,40722,4530,2,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1210.00,NULL,NULL,1,'2023-03-21 12:40:38','2023-03-21 12:40:38',NULL),(122,7503,40722,4530,2,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',307818.80,NULL,NULL,1,'2023-03-21 12:40:38','2023-03-21 12:40:38',NULL);
INSERT INTO `balance_libro` VALUES (123,7503,40722,4530,3,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',17800.00,NULL,NULL,1,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(124,7503,40722,4530,3,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',12000.00,NULL,NULL,1,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(125,7503,40722,4530,3,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',10780.00,NULL,NULL,1,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(126,7503,40722,4530,3,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',30779.00,NULL,NULL,1,'2023-03-21 12:41:00','2023-03-21 12:44:25','2023-03-21 12:44:25'),(127,7503,40722,4530,3,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',8460.01,NULL,NULL,1,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(128,7503,40722,4530,3,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',9902.68,NULL,NULL,1,'2023-03-21 12:41:00','2023-03-21 12:44:08','2023-03-21 12:44:08'),(129,7503,40722,4530,3,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',70351.18,NULL,NULL,1,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(130,7503,40722,4530,3,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',8960.00,NULL,NULL,1,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(131,7503,40722,4530,3,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',518.59,NULL,NULL,1,'2023-03-21 12:41:00','2023-03-21 12:43:41','2023-03-21 12:43:41'),(132,7503,40722,4530,3,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',2092.99,NULL,NULL,1,'2023-03-21 12:41:01','2023-03-21 12:41:01',NULL),(133,7503,40722,4530,3,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',3429.37,NULL,NULL,1,'2023-03-21 12:41:01','2023-03-21 12:41:01',NULL),(134,7503,40722,4530,3,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',11119.26,NULL,NULL,1,'2023-03-21 12:41:01','2023-03-21 12:43:12','2023-03-21 12:43:12'),(135,7503,40722,4530,3,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',11119.26,NULL,NULL,1,'2023-03-21 12:43:12','2023-03-21 12:43:12',NULL),(136,7503,40722,4530,3,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',518.59,NULL,NULL,1,'2023-03-21 12:43:41','2023-03-21 12:43:41',NULL),(137,7503,40722,4530,3,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',9902.68,NULL,NULL,1,'2023-03-21 12:44:08','2023-03-21 12:44:08',NULL),(138,7503,40722,4530,3,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',30779.00,NULL,NULL,1,'2023-03-21 12:44:25','2023-03-21 12:44:25',NULL),(139,7503,40722,4530,3,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',3999.92,NULL,NULL,1,'2023-03-21 12:46:28','2023-03-21 12:46:28',NULL),(140,7503,40722,4530,3,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',7900.60,NULL,NULL,1,'2023-03-21 12:48:27','2023-03-21 12:48:27',NULL),(141,7503,40722,4530,3,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',2000.10,NULL,NULL,1,'2023-03-21 12:49:18','2023-03-21 12:49:18',NULL),(142,7503,40722,4530,15,239,'App\\Models\\PeriodLiquidation',NULL,239,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',53633.10,NULL,NULL,1,'2023-05-18 08:40:48','2023-05-18 08:40:48',NULL),(143,7503,40722,4531,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2333349.11,NULL,NULL,1,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL);
INSERT INTO `balance_libro` VALUES (144,7503,40722,4531,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',841002.60,NULL,NULL,1,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(145,7503,40722,4531,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',104049.74,NULL,NULL,1,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(146,7503,40722,4531,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',1118306.95,NULL,NULL,1,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(147,7503,40722,4531,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',163039.37,NULL,NULL,1,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(148,7503,40722,4531,2,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',1210.00,NULL,NULL,1,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(149,7503,40722,4531,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',2669636.19,NULL,NULL,1,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(150,7503,40722,4531,3,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',0.00,NULL,NULL,1,'2023-05-18 08:57:13','2023-05-18 09:14:17','2023-05-18 09:14:17'),(151,7503,40722,4531,3,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',287925.86,NULL,NULL,1,'2023-05-18 08:57:13','2023-05-18 09:13:53','2023-05-18 09:13:53'),(152,7503,40722,4531,3,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',13001.00,NULL,NULL,1,'2023-05-18 08:57:13','2023-05-18 09:13:12','2023-05-18 09:13:12'),(153,7503,40722,4531,3,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',119.00,NULL,NULL,1,'2023-05-18 08:57:13','2023-05-18 09:02:27','2023-05-18 09:02:27'),(154,7503,40722,4531,3,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',163.00,NULL,NULL,1,'2023-05-18 08:57:13','2023-05-18 09:02:17','2023-05-18 09:02:17'),(155,7503,40722,4531,3,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',163.00,NULL,NULL,1,'2023-05-18 08:57:13','2023-05-18 09:02:07','2023-05-18 09:02:07'),(156,7503,40722,4531,3,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',6884.00,NULL,NULL,1,'2023-05-18 08:57:13','2023-05-18 09:12:54','2023-05-18 09:12:54'),(157,7503,40722,4531,3,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',128680.60,NULL,NULL,1,'2023-05-18 08:57:13','2023-05-18 09:12:32','2023-05-18 09:12:32'),(158,7503,40722,4531,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',6046.74,NULL,NULL,1,'2023-05-18 08:57:13','2023-05-18 09:12:08','2023-05-18 09:12:08'),(159,7503,40722,4531,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',2185816.60,NULL,NULL,1,'2023-05-18 08:57:13','2023-05-18 09:11:34','2023-05-18 09:11:34'),(160,7503,40722,4531,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',5000.00,NULL,NULL,1,'2023-05-18 08:57:13','2023-05-18 09:01:47','2023-05-18 09:01:47'),(161,7503,40722,4531,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',5000.00,NULL,NULL,1,'2023-05-18 08:57:13','2023-05-18 09:01:33','2023-05-18 09:01:33'),(162,7503,40722,4531,3,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',6476.00,NULL,NULL,1,'2023-05-18 08:57:13','2023-05-18 09:01:13','2023-05-18 09:01:13'),(163,7503,40722,4531,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',46249.77,NULL,NULL,1,'2023-05-18 08:57:13','2023-05-18 09:10:46','2023-05-18 09:10:46');
INSERT INTO `balance_libro` VALUES (164,7503,40722,4531,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',24276.94,NULL,NULL,1,'2023-05-18 08:57:13','2023-05-18 09:09:49','2023-05-18 09:09:49'),(165,7503,40722,4531,3,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',4846.36,NULL,NULL,1,'2023-05-18 08:57:13','2023-05-18 08:57:13',NULL),(166,7503,40722,4531,3,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',5500.00,NULL,NULL,1,'2023-05-18 08:57:13','2023-05-18 09:00:54','2023-05-18 09:00:54'),(167,7503,40722,4531,3,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',40499.98,NULL,NULL,1,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(168,7503,40722,4531,3,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',40499.98,NULL,NULL,1,'2023-05-18 08:57:14','2023-05-18 09:07:22','2023-05-18 09:07:22'),(169,7503,40722,4531,3,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',7708.22,NULL,NULL,1,'2023-05-18 08:57:14','2023-05-18 09:06:30','2023-05-18 09:06:30'),(170,7503,40722,4531,3,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',5225.00,NULL,NULL,1,'2023-05-18 08:57:14','2023-05-18 09:05:45','2023-05-18 09:05:45'),(171,7503,40722,4531,3,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',95.00,NULL,NULL,1,'2023-05-18 08:57:14','2023-05-18 09:00:07','2023-05-18 09:00:07'),(172,7503,40722,4531,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',239.00,NULL,NULL,1,'2023-05-18 08:57:14','2023-05-18 09:00:17','2023-05-18 09:00:17'),(173,7503,40722,4531,3,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',68689.51,NULL,NULL,1,'2023-05-18 08:57:14','2023-05-18 09:04:23','2023-05-18 09:04:23'),(174,7503,40722,4531,3,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1662.00,NULL,NULL,1,'2023-05-18 08:57:14','2023-05-18 08:59:56','2023-05-18 08:59:56'),(175,7503,40722,4531,3,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',30330.83,NULL,NULL,1,'2023-05-18 08:57:14','2023-05-18 08:59:47','2023-05-18 08:59:47'),(176,7503,40722,4531,3,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',1500.00,NULL,NULL,1,'2023-05-18 08:57:14','2023-05-18 09:00:36','2023-05-18 09:00:36'),(177,7503,40722,4531,3,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',14500.00,NULL,NULL,1,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(178,7503,40722,4531,3,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',15998.14,NULL,NULL,1,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(179,7503,40722,4531,3,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',762.00,NULL,NULL,1,'2023-05-18 08:57:14','2023-05-18 08:59:39','2023-05-18 08:59:39'),(180,7503,40722,4531,3,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',91250.00,NULL,NULL,1,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(181,7503,40722,4531,3,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',10500.00,NULL,NULL,1,'2023-05-18 08:57:14','2023-05-18 08:59:29','2023-05-18 08:59:29'),(182,7503,40722,4531,3,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',68689.51,NULL,NULL,1,'2023-05-18 09:04:23','2023-05-18 09:04:23',NULL),(183,7503,40722,4531,3,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',5225.00,NULL,NULL,1,'2023-05-18 09:05:45','2023-05-18 09:05:45',NULL);
INSERT INTO `balance_libro` VALUES (184,7503,40722,4531,3,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',7708.22,NULL,NULL,1,'2023-05-18 09:06:30','2023-05-18 09:06:30',NULL),(185,7503,40722,4531,3,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',40499.98,NULL,NULL,1,'2023-05-18 09:07:22','2023-05-18 09:07:22',NULL),(186,7503,40722,4531,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',46249.77,NULL,NULL,1,'2023-05-18 09:10:46','2023-05-18 09:10:46',NULL),(187,7503,40722,4531,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',2185816.60,NULL,NULL,1,'2023-05-18 09:11:34','2023-05-18 09:11:34',NULL),(188,7503,40722,4531,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',6046.74,NULL,NULL,1,'2023-05-18 09:12:08','2023-05-18 09:12:08',NULL),(189,7503,40722,4531,3,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',128680.60,NULL,NULL,1,'2023-05-18 09:12:32','2023-05-18 09:12:32',NULL),(190,7503,40722,4531,3,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',6884.00,NULL,NULL,1,'2023-05-18 09:12:54','2023-05-18 09:12:54',NULL),(191,7503,40722,4531,3,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',13001.00,NULL,NULL,1,'2023-05-18 09:13:12','2023-05-18 09:13:12',NULL),(192,7503,40722,4531,3,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',652.12,NULL,NULL,1,'2023-05-18 09:16:47','2023-05-18 09:23:56','2023-05-18 09:23:56'),(193,7503,40722,4531,3,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',61441.77,NULL,NULL,1,'2023-05-18 09:18:51','2023-05-18 09:18:51',NULL),(194,7503,40722,4531,3,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',12076.00,NULL,NULL,1,'2023-05-18 09:21:27','2023-05-18 09:21:27',NULL),(195,7503,40722,4531,3,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',6741.19,NULL,NULL,1,'2023-05-18 09:23:12','2023-05-18 09:23:12',NULL),(196,7503,40722,4531,3,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',62775.80,NULL,NULL,1,'2023-05-18 09:23:56','2023-05-18 09:23:56',NULL),(197,7503,40722,4531,15,307,'App\\Models\\PeriodLiquidation',NULL,307,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1254896.38,NULL,NULL,1,'2023-05-18 09:25:00','2023-05-18 09:25:00',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=676 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7503,1,40720,1515,1,110,1,92014.56,NULL,'2023-01-11 17:03:00','2023-01-19 17:59:35','2023-01-19 17:59:35'),(2,7503,1,40720,1515,1,111,1,0.00,NULL,'2023-01-11 17:03:00','2023-01-19 17:59:35','2023-01-19 17:59:35'),(3,7503,1,40720,1515,1,112,1,0.00,NULL,'2023-01-11 17:03:00','2023-01-19 17:59:35','2023-01-19 17:59:35'),(4,7503,1,40720,1515,1,62,2,92014.56,NULL,'2023-01-11 17:03:00','2023-01-19 17:59:35','2023-01-19 17:59:35'),(5,7503,1,40720,1515,1,63,2,0.00,NULL,'2023-01-11 17:03:00','2023-01-19 17:59:35','2023-01-19 17:59:35'),(6,7503,1,40720,1515,1,64,2,0.00,NULL,'2023-01-11 17:03:00','2023-01-19 17:59:35','2023-01-19 17:59:35'),(7,7503,1,40720,1515,1,63,1,0.00,NULL,'2023-01-11 17:03:00','2023-01-19 17:59:35','2023-01-19 17:59:35'),(8,7503,1,40720,1515,1,162,2,0.00,NULL,'2023-01-11 17:03:00','2023-01-19 17:59:35','2023-01-19 17:59:35'),(9,7503,2,40723,6282,2,96,2,9549.00,NULL,'2023-02-06 10:22:33','2023-02-09 15:24:58','2023-02-09 15:24:58'),(10,7503,2,40723,6282,2,67,2,2005.29,NULL,'2023-02-06 10:22:33','2023-02-09 15:24:58','2023-02-09 15:24:58'),(11,7503,2,40723,6282,2,13,1,11554.29,NULL,'2023-02-06 10:22:33','2023-02-09 15:24:58','2023-02-09 15:24:58'),(12,7503,3,40723,6282,2,96,2,28000.00,NULL,'2023-02-06 10:22:33','2023-02-09 15:08:26','2023-02-09 15:08:26'),(13,7503,3,40723,6282,2,67,2,5880.00,NULL,'2023-02-06 10:22:33','2023-02-09 15:08:26','2023-02-09 15:08:26'),(14,7503,3,40723,6282,2,13,1,33880.00,NULL,'2023-02-06 10:22:33','2023-02-09 15:08:26','2023-02-09 15:08:26'),(15,7503,4,40723,6283,2,96,2,27024.79,NULL,'2023-02-06 10:24:44','2023-02-09 15:25:10','2023-02-09 15:25:10'),(16,7503,4,40723,6283,2,67,2,5675.21,NULL,'2023-02-06 10:24:44','2023-02-09 15:25:10','2023-02-09 15:25:10'),(17,7503,4,40723,6283,2,13,1,32700.00,NULL,'2023-02-06 10:24:44','2023-02-09 15:25:10','2023-02-09 15:25:10'),(18,7503,5,40723,6283,2,96,2,8780.00,NULL,'2023-02-06 10:24:44','2023-02-09 15:25:14','2023-02-09 15:25:14'),(19,7503,5,40723,6283,2,67,2,1843.80,NULL,'2023-02-06 10:24:44','2023-02-09 15:25:14','2023-02-09 15:25:14'),(20,7503,5,40723,6283,2,13,1,10623.80,NULL,'2023-02-06 10:24:44','2023-02-09 15:25:14','2023-02-09 15:25:14'),(21,7503,6,40723,6283,3,217,1,391.91,NULL,'2023-02-06 10:26:06','2023-02-06 10:30:07','2023-02-06 10:30:07'),(22,7503,6,40723,6283,3,68,1,82.30,NULL,'2023-02-06 10:26:06','2023-02-06 10:30:07','2023-02-06 10:30:07'),(23,7503,6,40723,6283,3,217,1,39.18,NULL,'2023-02-06 10:26:06','2023-02-06 10:30:07','2023-02-06 10:30:07'),(24,7503,6,40723,6283,3,57,2,513.39,NULL,'2023-02-06 10:26:06','2023-02-06 10:30:07','2023-02-06 10:30:07'),(25,7503,7,40723,6283,3,217,1,14944.15,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:59','2023-02-06 10:29:59'),(26,7503,7,40723,6283,3,68,1,3138.27,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:59','2023-02-06 10:29:59'),(27,7503,7,40723,6283,3,217,1,448.33,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:59','2023-02-06 10:29:59'),(28,7503,7,40723,6283,3,57,2,18530.75,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:59','2023-02-06 10:29:59'),(29,7503,8,40723,6283,3,217,2,6610.74,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:52','2023-02-06 10:29:52'),(30,7503,8,40723,6283,3,67,2,1388.26,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:52','2023-02-06 10:29:52'),(31,7503,8,40723,6283,3,57,1,7999.00,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:52','2023-02-06 10:29:52'),(32,7503,9,40723,6283,3,217,1,4610.66,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:45','2023-02-06 10:29:45'),(33,7503,9,40723,6283,3,68,1,968.24,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:45','2023-02-06 10:29:45'),(34,7503,9,40723,6283,3,57,2,5578.90,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:45','2023-02-06 10:29:45'),(35,7503,10,40723,6283,3,217,1,247.11,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:38','2023-02-06 10:29:38'),(36,7503,10,40723,6283,3,68,1,51.89,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:38','2023-02-06 10:29:38');
INSERT INTO `balance_libro_details` VALUES (37,7503,10,40723,6283,3,57,2,299.00,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:38','2023-02-06 10:29:38'),(38,7503,11,40723,6283,3,217,1,213.48,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:22','2023-02-06 10:29:22'),(39,7503,11,40723,6283,3,68,1,44.83,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:22','2023-02-06 10:29:22'),(40,7503,11,40723,6283,3,217,1,21.34,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:22','2023-02-06 10:29:22'),(41,7503,11,40723,6283,3,57,2,279.65,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:22','2023-02-06 10:29:22'),(42,7503,12,40723,6283,3,217,1,19860.00,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:14','2023-02-06 10:29:14'),(43,7503,12,40723,6283,3,68,1,4170.60,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:14','2023-02-06 10:29:14'),(44,7503,12,40723,6283,3,217,1,1588.80,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:14','2023-02-06 10:29:14'),(45,7503,12,40723,6283,3,57,2,25619.40,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:14','2023-02-06 10:29:14'),(46,7503,13,40723,6282,3,217,1,391.91,NULL,'2023-02-06 10:31:07','2023-02-09 15:26:35','2023-02-09 15:26:35'),(47,7503,13,40723,6282,3,68,1,82.30,NULL,'2023-02-06 10:31:07','2023-02-09 15:26:35','2023-02-09 15:26:35'),(48,7503,13,40723,6282,3,217,1,39.18,NULL,'2023-02-06 10:31:07','2023-02-09 15:26:35','2023-02-09 15:26:35'),(49,7503,13,40723,6282,3,57,2,513.39,NULL,'2023-02-06 10:31:07','2023-02-09 15:26:35','2023-02-09 15:26:35'),(50,7503,14,40723,6282,3,217,1,14944.15,NULL,'2023-02-06 10:31:08','2023-02-07 14:39:42','2023-02-07 14:39:42'),(51,7503,14,40723,6282,3,68,1,3138.27,NULL,'2023-02-06 10:31:08','2023-02-07 14:39:42','2023-02-07 14:39:42'),(52,7503,14,40723,6282,3,217,1,448.33,NULL,'2023-02-06 10:31:08','2023-02-07 14:39:42','2023-02-07 14:39:42'),(53,7503,14,40723,6282,3,57,2,18530.75,NULL,'2023-02-06 10:31:08','2023-02-07 14:39:42','2023-02-07 14:39:42'),(54,7503,15,40723,6282,3,217,2,6610.74,NULL,'2023-02-06 10:31:08','2023-02-09 15:26:27','2023-02-09 15:26:27'),(55,7503,15,40723,6282,3,67,2,1388.26,NULL,'2023-02-06 10:31:08','2023-02-09 15:26:27','2023-02-09 15:26:27'),(56,7503,15,40723,6282,3,57,1,7999.00,NULL,'2023-02-06 10:31:08','2023-02-09 15:26:27','2023-02-09 15:26:27'),(57,7503,16,40723,6282,3,217,1,4610.66,NULL,'2023-02-06 10:31:08','2023-02-09 15:25:36','2023-02-09 15:25:36'),(58,7503,16,40723,6282,3,68,1,968.24,NULL,'2023-02-06 10:31:08','2023-02-09 15:25:36','2023-02-09 15:25:36'),(59,7503,16,40723,6282,3,57,2,5578.90,NULL,'2023-02-06 10:31:08','2023-02-09 15:25:36','2023-02-09 15:25:36'),(60,7503,17,40723,6282,3,217,1,247.11,NULL,'2023-02-06 10:31:08','2023-02-09 15:26:23','2023-02-09 15:26:23'),(61,7503,17,40723,6282,3,68,1,51.89,NULL,'2023-02-06 10:31:08','2023-02-09 15:26:23','2023-02-09 15:26:23'),(62,7503,17,40723,6282,3,57,2,299.00,NULL,'2023-02-06 10:31:08','2023-02-09 15:26:23','2023-02-09 15:26:23'),(63,7503,18,40723,6282,3,217,1,213.48,NULL,'2023-02-06 10:31:08','2023-02-09 15:26:16','2023-02-09 15:26:16'),(64,7503,18,40723,6282,3,68,1,44.83,NULL,'2023-02-06 10:31:08','2023-02-09 15:26:16','2023-02-09 15:26:16'),(65,7503,18,40723,6282,3,217,1,21.34,NULL,'2023-02-06 10:31:08','2023-02-09 15:26:16','2023-02-09 15:26:16'),(66,7503,18,40723,6282,3,57,2,279.65,NULL,'2023-02-06 10:31:08','2023-02-09 15:26:16','2023-02-09 15:26:16'),(67,7503,19,40723,6282,3,217,1,19860.00,NULL,'2023-02-06 10:31:08','2023-02-07 14:40:23','2023-02-07 14:40:23'),(68,7503,19,40723,6282,3,68,1,4170.60,NULL,'2023-02-06 10:31:08','2023-02-07 14:40:23','2023-02-07 14:40:23'),(69,7503,19,40723,6282,3,217,1,1588.80,NULL,'2023-02-06 10:31:08','2023-02-07 14:40:23','2023-02-07 14:40:23'),(70,7503,19,40723,6282,3,57,2,25619.40,NULL,'2023-02-06 10:31:08','2023-02-07 14:40:23','2023-02-07 14:40:23'),(71,7503,20,40723,6283,3,217,1,168.60,NULL,'2023-02-06 10:31:45','2023-02-09 15:26:12','2023-02-09 15:26:12'),(72,7503,20,40723,6283,3,68,1,35.40,NULL,'2023-02-06 10:31:45','2023-02-09 15:26:12','2023-02-09 15:26:12');
INSERT INTO `balance_libro_details` VALUES (73,7503,20,40723,6283,3,57,2,204.00,NULL,'2023-02-06 10:31:45','2023-02-09 15:26:12','2023-02-09 15:26:12'),(74,7503,21,40723,6283,3,217,1,1500.00,NULL,'2023-02-06 10:31:45','2023-02-09 15:26:09','2023-02-09 15:26:09'),(75,7503,21,40723,6283,3,68,1,315.00,NULL,'2023-02-06 10:31:45','2023-02-09 15:26:09','2023-02-09 15:26:09'),(76,7503,21,40723,6283,3,57,2,1815.00,NULL,'2023-02-06 10:31:45','2023-02-09 15:26:09','2023-02-09 15:26:09'),(77,7503,22,40723,6283,3,217,1,10933.56,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:54','2023-02-09 15:25:54'),(78,7503,22,40723,6283,3,68,1,1833.41,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:54','2023-02-09 15:25:54'),(79,7503,22,40723,6283,3,57,2,12766.97,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:54','2023-02-09 15:25:54'),(80,7503,23,40723,6283,3,217,1,2603.45,NULL,'2023-02-06 10:31:45','2023-02-09 15:26:01','2023-02-09 15:26:01'),(81,7503,23,40723,6283,3,68,1,546.72,NULL,'2023-02-06 10:31:45','2023-02-09 15:26:01','2023-02-09 15:26:01'),(82,7503,23,40723,6283,3,217,1,0.01,NULL,'2023-02-06 10:31:45','2023-02-09 15:26:01','2023-02-09 15:26:01'),(83,7503,23,40723,6283,3,57,2,3150.18,NULL,'2023-02-06 10:31:45','2023-02-09 15:26:01','2023-02-09 15:26:01'),(84,7503,24,40723,6283,3,217,1,6695.39,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:49','2023-02-09 15:25:49'),(85,7503,24,40723,6283,3,68,1,1406.03,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:49','2023-02-09 15:25:49'),(86,7503,24,40723,6283,3,217,1,200.86,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:49','2023-02-09 15:25:49'),(87,7503,24,40723,6283,3,57,2,8302.28,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:49','2023-02-09 15:25:49'),(88,7503,25,40723,6283,3,217,1,56.20,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:57','2023-02-09 15:25:57'),(89,7503,25,40723,6283,3,68,1,11.80,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:57','2023-02-09 15:25:57'),(90,7503,25,40723,6283,3,57,2,68.00,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:57','2023-02-09 15:25:57'),(91,7503,26,40723,6283,3,217,1,79.89,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:32','2023-02-09 15:25:32'),(92,7503,26,40723,6283,3,68,1,16.78,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:32','2023-02-09 15:25:32'),(93,7503,26,40723,6283,3,217,1,3.33,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:32','2023-02-09 15:25:32'),(94,7503,26,40723,6283,3,57,2,100.00,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:32','2023-02-09 15:25:32'),(95,7503,27,40723,6283,3,217,1,5441.34,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:24','2023-02-09 15:25:24'),(96,7503,27,40723,6283,3,68,1,1142.68,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:24','2023-02-09 15:25:24'),(97,7503,27,40723,6283,3,217,1,1107.82,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:24','2023-02-09 15:25:24'),(98,7503,27,40723,6283,3,57,2,7691.84,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:24','2023-02-09 15:25:24'),(103,7503,30,40723,6282,3,217,1,14944.15,NULL,'2023-02-07 14:39:42','2023-02-09 15:26:30','2023-02-09 15:26:30'),(104,7503,30,40723,6282,3,68,1,3138.27,NULL,'2023-02-07 14:39:42','2023-02-09 15:26:30','2023-02-09 15:26:30'),(105,7503,30,40723,6282,3,226,1,448.33,NULL,'2023-02-07 14:39:42','2023-02-09 15:26:30','2023-02-09 15:26:30'),(106,7503,30,40723,6282,3,57,2,18530.75,NULL,'2023-02-07 14:39:42','2023-02-09 15:26:30','2023-02-09 15:26:30'),(107,7503,31,40723,6282,3,217,1,19860.00,NULL,'2023-02-07 14:40:23','2023-02-09 15:25:40','2023-02-09 15:25:40'),(108,7503,31,40723,6282,3,68,1,4170.60,NULL,'2023-02-07 14:40:23','2023-02-09 15:25:40','2023-02-09 15:25:40'),(109,7503,31,40723,6282,3,225,1,1588.80,NULL,'2023-02-07 14:40:23','2023-02-09 15:25:40','2023-02-09 15:25:40'),(110,7503,31,40723,6282,3,57,2,25619.40,NULL,'2023-02-07 14:40:23','2023-02-09 15:25:40','2023-02-09 15:25:40'),(111,7503,32,40723,6282,7,252,1,72.00,NULL,'2023-02-07 14:46:03','2023-02-09 15:26:48','2023-02-09 15:26:48'),(112,7503,32,40723,6282,7,13,2,72.00,NULL,'2023-02-07 14:46:03','2023-02-09 15:26:48','2023-02-09 15:26:48');
INSERT INTO `balance_libro_details` VALUES (113,7503,33,40723,6282,7,252,1,7.00,NULL,'2023-02-07 14:46:03','2023-02-09 15:26:43','2023-02-09 15:26:43'),(114,7503,33,40723,6282,7,13,2,7.00,NULL,'2023-02-07 14:46:03','2023-02-09 15:26:43','2023-02-09 15:26:43'),(115,7503,34,40723,6282,2,96,2,28000.00,NULL,'2023-02-09 15:08:26','2023-02-09 15:25:05','2023-02-09 15:25:05'),(116,7503,34,40723,6282,2,67,2,5880.00,NULL,'2023-02-09 15:08:26','2023-02-09 15:25:05','2023-02-09 15:25:05'),(117,7503,34,40723,6282,2,13,1,33880.00,NULL,'2023-02-09 15:08:26','2023-02-09 15:25:05','2023-02-09 15:25:05'),(118,7503,35,40723,6282,3,217,1,391.91,NULL,'2023-02-09 15:31:05','2023-02-09 15:56:51','2023-02-09 15:56:51'),(119,7503,35,40723,6282,3,68,1,82.30,NULL,'2023-02-09 15:31:05','2023-02-09 15:56:51','2023-02-09 15:56:51'),(120,7503,35,40723,6282,3,217,1,39.18,NULL,'2023-02-09 15:31:05','2023-02-09 15:56:51','2023-02-09 15:56:51'),(121,7503,35,40723,6282,3,57,2,513.39,NULL,'2023-02-09 15:31:05','2023-02-09 15:56:51','2023-02-09 15:56:51'),(122,7503,36,40723,6282,3,217,1,14944.15,NULL,'2023-02-09 15:31:05','2023-02-09 15:35:18','2023-02-09 15:35:18'),(123,7503,36,40723,6282,3,68,1,3138.27,NULL,'2023-02-09 15:31:05','2023-02-09 15:35:18','2023-02-09 15:35:18'),(124,7503,36,40723,6282,3,217,1,448.33,NULL,'2023-02-09 15:31:05','2023-02-09 15:35:18','2023-02-09 15:35:18'),(125,7503,36,40723,6282,3,57,2,18530.75,NULL,'2023-02-09 15:31:05','2023-02-09 15:35:18','2023-02-09 15:35:18'),(126,7503,37,40723,6282,3,217,2,6610.74,NULL,'2023-02-09 15:31:05','2023-02-09 15:50:23','2023-02-09 15:50:23'),(127,7503,37,40723,6282,3,67,2,1388.26,NULL,'2023-02-09 15:31:05','2023-02-09 15:50:23','2023-02-09 15:50:23'),(128,7503,37,40723,6282,3,57,1,7999.00,NULL,'2023-02-09 15:31:05','2023-02-09 15:50:23','2023-02-09 15:50:23'),(129,7503,38,40723,6282,3,217,1,4610.66,NULL,'2023-02-09 15:31:06','2023-02-09 15:56:44','2023-02-09 15:56:44'),(130,7503,38,40723,6282,3,68,1,968.24,NULL,'2023-02-09 15:31:06','2023-02-09 15:56:44','2023-02-09 15:56:44'),(131,7503,38,40723,6282,3,57,2,5578.90,NULL,'2023-02-09 15:31:06','2023-02-09 15:56:44','2023-02-09 15:56:44'),(132,7503,39,40723,6282,3,217,1,247.11,NULL,'2023-02-09 15:31:06','2023-02-09 15:56:40','2023-02-09 15:56:40'),(133,7503,39,40723,6282,3,68,1,51.89,NULL,'2023-02-09 15:31:06','2023-02-09 15:56:40','2023-02-09 15:56:40'),(134,7503,39,40723,6282,3,57,2,299.00,NULL,'2023-02-09 15:31:06','2023-02-09 15:56:40','2023-02-09 15:56:40'),(135,7503,40,40723,6282,3,217,1,213.48,NULL,'2023-02-09 15:31:06','2023-02-09 15:56:36','2023-02-09 15:56:36'),(136,7503,40,40723,6282,3,68,1,44.83,NULL,'2023-02-09 15:31:06','2023-02-09 15:56:36','2023-02-09 15:56:36'),(137,7503,40,40723,6282,3,217,1,21.34,NULL,'2023-02-09 15:31:06','2023-02-09 15:56:36','2023-02-09 15:56:36'),(138,7503,40,40723,6282,3,57,2,279.65,NULL,'2023-02-09 15:31:06','2023-02-09 15:56:36','2023-02-09 15:56:36'),(139,7503,41,40723,6282,3,217,1,19860.00,NULL,'2023-02-09 15:31:06','2023-02-09 15:33:13','2023-02-09 15:33:13'),(140,7503,41,40723,6282,3,68,1,4170.60,NULL,'2023-02-09 15:31:06','2023-02-09 15:33:13','2023-02-09 15:33:13'),(141,7503,41,40723,6282,3,217,1,1588.80,NULL,'2023-02-09 15:31:06','2023-02-09 15:33:13','2023-02-09 15:33:13'),(142,7503,41,40723,6282,3,57,2,25619.40,NULL,'2023-02-09 15:31:06','2023-02-09 15:33:13','2023-02-09 15:33:13'),(143,7503,42,40723,6282,3,217,1,19860.00,NULL,'2023-02-09 15:33:13','2023-02-09 15:34:42','2023-02-09 15:34:42'),(144,7503,42,40723,6282,3,68,1,4170.60,NULL,'2023-02-09 15:33:13','2023-02-09 15:34:42','2023-02-09 15:34:42'),(145,7503,42,40723,6282,3,225,1,1588.80,NULL,'2023-02-09 15:33:13','2023-02-09 15:34:42','2023-02-09 15:34:42'),(146,7503,42,40723,6282,3,57,2,25619.40,NULL,'2023-02-09 15:33:13','2023-02-09 15:34:42','2023-02-09 15:34:42'),(147,7503,43,40723,6282,3,217,1,19860.00,NULL,'2023-02-09 15:34:42','2023-02-09 15:56:31','2023-02-09 15:56:31'),(148,7503,43,40723,6282,3,68,1,4170.60,NULL,'2023-02-09 15:34:42','2023-02-09 15:56:31','2023-02-09 15:56:31');
INSERT INTO `balance_libro_details` VALUES (149,7503,43,40723,6282,3,225,1,1588.80,NULL,'2023-02-09 15:34:42','2023-02-09 15:56:31','2023-02-09 15:56:31'),(150,7503,43,40723,6282,3,57,2,25619.40,NULL,'2023-02-09 15:34:42','2023-02-09 15:56:31','2023-02-09 15:56:31'),(151,7503,44,40723,6282,3,217,1,14944.15,NULL,'2023-02-09 15:35:18','2023-02-09 15:56:47','2023-02-09 15:56:47'),(152,7503,44,40723,6282,3,68,1,3138.27,NULL,'2023-02-09 15:35:18','2023-02-09 15:56:47','2023-02-09 15:56:47'),(153,7503,44,40723,6282,3,226,1,448.33,NULL,'2023-02-09 15:35:18','2023-02-09 15:56:47','2023-02-09 15:56:47'),(154,7503,44,40723,6282,3,57,2,18530.75,NULL,'2023-02-09 15:35:18','2023-02-09 15:56:47','2023-02-09 15:56:47'),(155,7503,45,40723,6282,2,96,2,9549.00,NULL,'2023-02-09 15:43:51','2023-02-09 16:44:55','2023-02-09 16:44:55'),(156,7503,45,40723,6282,2,67,2,2005.29,NULL,'2023-02-09 15:43:51','2023-02-09 16:44:55','2023-02-09 16:44:55'),(157,7503,45,40723,6282,2,13,1,11554.29,NULL,'2023-02-09 15:43:51','2023-02-09 16:44:55','2023-02-09 16:44:55'),(158,7503,46,40723,6282,2,96,2,28000.00,NULL,'2023-02-09 15:43:51','2023-02-09 15:44:21','2023-02-09 15:44:21'),(159,7503,46,40723,6282,2,67,2,5880.00,NULL,'2023-02-09 15:43:51','2023-02-09 15:44:21','2023-02-09 15:44:21'),(160,7503,46,40723,6282,2,13,1,33880.00,NULL,'2023-02-09 15:43:51','2023-02-09 15:44:21','2023-02-09 15:44:21'),(161,7503,47,40723,6282,2,96,2,28000.00,NULL,'2023-02-09 15:44:21','2023-02-09 16:44:51','2023-02-09 16:44:51'),(162,7503,47,40723,6282,2,67,2,5880.00,NULL,'2023-02-09 15:44:21','2023-02-09 16:44:51','2023-02-09 16:44:51'),(163,7503,47,40723,6282,2,13,1,33880.00,NULL,'2023-02-09 15:44:21','2023-02-09 16:44:51','2023-02-09 16:44:51'),(164,7503,48,40723,6282,3,217,1,391.91,NULL,'2023-02-09 16:16:04','2023-02-09 16:16:50','2023-02-09 16:16:50'),(165,7503,48,40723,6282,3,68,1,82.30,NULL,'2023-02-09 16:16:04','2023-02-09 16:16:50','2023-02-09 16:16:50'),(166,7503,48,40723,6282,3,217,1,39.18,NULL,'2023-02-09 16:16:04','2023-02-09 16:16:50','2023-02-09 16:16:50'),(167,7503,48,40723,6282,3,57,2,513.39,NULL,'2023-02-09 16:16:04','2023-02-09 16:16:50','2023-02-09 16:16:50'),(168,7503,49,40723,6282,3,217,1,14944.15,NULL,'2023-02-09 16:16:04','2023-02-09 16:17:36','2023-02-09 16:17:36'),(169,7503,49,40723,6282,3,68,1,3138.27,NULL,'2023-02-09 16:16:04','2023-02-09 16:17:36','2023-02-09 16:17:36'),(170,7503,49,40723,6282,3,217,1,448.33,NULL,'2023-02-09 16:16:04','2023-02-09 16:17:36','2023-02-09 16:17:36'),(171,7503,49,40723,6282,3,57,2,18530.75,NULL,'2023-02-09 16:16:04','2023-02-09 16:17:36','2023-02-09 16:17:36'),(172,7503,50,40723,6282,3,217,2,6610.74,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:45','2023-02-09 16:16:45'),(173,7503,50,40723,6282,3,67,2,1388.26,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:45','2023-02-09 16:16:45'),(174,7503,50,40723,6282,3,57,1,7999.00,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:45','2023-02-09 16:16:45'),(175,7503,51,40723,6282,3,217,1,4610.66,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:33','2023-02-09 16:16:33'),(176,7503,51,40723,6282,3,68,1,968.24,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:33','2023-02-09 16:16:33'),(177,7503,51,40723,6282,3,57,2,5578.90,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:33','2023-02-09 16:16:33'),(178,7503,52,40723,6282,3,217,1,247.11,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:23','2023-02-09 16:16:23'),(179,7503,52,40723,6282,3,68,1,51.89,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:23','2023-02-09 16:16:23'),(180,7503,52,40723,6282,3,57,2,299.00,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:23','2023-02-09 16:16:23'),(181,7503,53,40723,6282,3,217,1,213.48,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:38','2023-02-09 16:16:38'),(182,7503,53,40723,6282,3,68,1,44.83,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:38','2023-02-09 16:16:38'),(183,7503,53,40723,6282,3,217,1,21.34,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:38','2023-02-09 16:16:38'),(184,7503,53,40723,6282,3,57,2,279.65,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:38','2023-02-09 16:16:38');
INSERT INTO `balance_libro_details` VALUES (185,7503,54,40723,6282,3,217,1,19860.00,NULL,'2023-02-09 16:16:05','2023-02-09 16:17:08','2023-02-09 16:17:08'),(186,7503,54,40723,6282,3,68,1,4170.60,NULL,'2023-02-09 16:16:05','2023-02-09 16:17:08','2023-02-09 16:17:08'),(187,7503,54,40723,6282,3,217,1,1588.80,NULL,'2023-02-09 16:16:05','2023-02-09 16:17:08','2023-02-09 16:17:08'),(188,7503,54,40723,6282,3,57,2,25619.40,NULL,'2023-02-09 16:16:05','2023-02-09 16:17:08','2023-02-09 16:17:08'),(189,7503,55,40723,6282,3,217,1,19860.00,NULL,'2023-02-09 16:17:08','2023-02-09 16:45:03','2023-02-09 16:45:03'),(190,7503,55,40723,6282,3,68,1,4170.60,NULL,'2023-02-09 16:17:08','2023-02-09 16:45:03','2023-02-09 16:45:03'),(191,7503,55,40723,6282,3,225,1,1588.80,NULL,'2023-02-09 16:17:08','2023-02-09 16:45:03','2023-02-09 16:45:03'),(192,7503,55,40723,6282,3,57,2,25619.40,NULL,'2023-02-09 16:17:08','2023-02-09 16:45:03','2023-02-09 16:45:03'),(193,7503,56,40723,6282,3,217,1,14944.15,NULL,'2023-02-09 16:17:36','2023-02-09 16:45:07','2023-02-09 16:45:07'),(194,7503,56,40723,6282,3,68,1,3138.27,NULL,'2023-02-09 16:17:36','2023-02-09 16:45:07','2023-02-09 16:45:07'),(195,7503,56,40723,6282,3,226,1,448.33,NULL,'2023-02-09 16:17:36','2023-02-09 16:45:07','2023-02-09 16:45:07'),(196,7503,56,40723,6282,3,57,2,18530.75,NULL,'2023-02-09 16:17:36','2023-02-09 16:45:07','2023-02-09 16:45:07'),(197,7503,57,40723,6283,2,96,2,27024.79,NULL,'2023-02-09 16:48:36','2023-02-10 15:41:05','2023-02-10 15:41:05'),(198,7503,57,40723,6283,2,67,2,5675.21,NULL,'2023-02-09 16:48:36','2023-02-10 15:41:05','2023-02-10 15:41:05'),(199,7503,57,40723,6283,2,13,1,32700.00,NULL,'2023-02-09 16:48:36','2023-02-10 15:41:05','2023-02-10 15:41:05'),(200,7503,58,40723,6283,2,96,2,8780.00,NULL,'2023-02-09 16:48:36','2023-02-10 15:40:55','2023-02-10 15:40:55'),(201,7503,58,40723,6283,2,67,2,1843.80,NULL,'2023-02-09 16:48:36','2023-02-10 15:40:55','2023-02-10 15:40:55'),(202,7503,58,40723,6283,2,13,1,10623.80,NULL,'2023-02-09 16:48:36','2023-02-10 15:40:55','2023-02-10 15:40:55'),(203,7503,59,40723,6283,3,217,1,6695.39,NULL,'2023-02-09 16:51:04','2023-02-09 16:53:01','2023-02-09 16:53:01'),(204,7503,59,40723,6283,3,68,1,1406.03,NULL,'2023-02-09 16:51:04','2023-02-09 16:53:01','2023-02-09 16:53:01'),(205,7503,59,40723,6283,3,217,1,200.86,NULL,'2023-02-09 16:51:04','2023-02-09 16:53:01','2023-02-09 16:53:01'),(206,7503,59,40723,6283,3,57,2,8302.28,NULL,'2023-02-09 16:51:04','2023-02-09 16:53:01','2023-02-09 16:53:01'),(207,7503,60,40723,6283,3,217,1,5441.34,NULL,'2023-02-09 16:51:04','2023-02-09 16:59:46','2023-02-09 16:59:46'),(208,7503,60,40723,6283,3,68,1,1142.68,NULL,'2023-02-09 16:51:04','2023-02-09 16:59:46','2023-02-09 16:59:46'),(209,7503,60,40723,6283,3,217,1,1107.82,NULL,'2023-02-09 16:51:04','2023-02-09 16:59:46','2023-02-09 16:59:46'),(210,7503,60,40723,6283,3,57,2,7691.84,NULL,'2023-02-09 16:51:04','2023-02-09 16:59:46','2023-02-09 16:59:46'),(211,7503,61,40723,6283,3,217,1,6695.39,NULL,'2023-02-09 16:53:01','2023-02-09 17:42:06','2023-02-09 17:42:06'),(212,7503,61,40723,6283,3,68,1,1406.03,NULL,'2023-02-09 16:53:01','2023-02-09 17:42:06','2023-02-09 17:42:06'),(213,7503,61,40723,6283,3,226,1,200.86,NULL,'2023-02-09 16:53:01','2023-02-09 17:42:06','2023-02-09 17:42:06'),(214,7503,61,40723,6283,3,57,2,8302.28,NULL,'2023-02-09 16:53:01','2023-02-09 17:42:06','2023-02-09 17:42:06'),(215,7503,62,40723,6283,3,217,1,5441.34,NULL,'2023-02-09 16:59:46','2023-02-09 17:42:02','2023-02-09 17:42:02'),(216,7503,62,40723,6283,3,68,1,1142.68,NULL,'2023-02-09 16:59:46','2023-02-09 17:42:02','2023-02-09 17:42:02'),(217,7503,62,40723,6283,3,224,1,917.07,NULL,'2023-02-09 16:59:46','2023-02-09 17:42:02','2023-02-09 17:42:02'),(218,7503,62,40723,6283,3,226,1,190.75,NULL,'2023-02-09 16:59:46','2023-02-09 17:42:02','2023-02-09 17:42:02'),(219,7503,62,40723,6283,3,57,2,7691.84,NULL,'2023-02-09 16:59:46','2023-02-09 17:42:02','2023-02-09 17:42:02');
INSERT INTO `balance_libro_details` VALUES (220,7503,63,40723,6283,15,67,1,7519.01,NULL,'2023-02-09 17:05:23','2023-02-09 17:21:37','2023-02-09 17:21:37'),(221,7503,63,40723,6283,15,68,2,2548.71,NULL,'2023-02-09 17:05:23','2023-02-09 17:21:37','2023-02-09 17:21:37'),(222,7503,63,40723,6283,15,74,2,4970.29,NULL,'2023-02-09 17:05:23','2023-02-09 17:21:37','2023-02-09 17:21:37'),(223,7503,63,40723,6283,15,136,2,0.01,NULL,'2023-02-09 17:05:23','2023-02-09 17:21:37','2023-02-09 17:21:37'),(224,7503,64,40723,6283,3,217,1,168.60,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:59','2023-02-09 17:41:59'),(225,7503,64,40723,6283,3,68,1,35.40,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:59','2023-02-09 17:41:59'),(226,7503,64,40723,6283,3,57,2,204.00,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:59','2023-02-09 17:41:59'),(227,7503,65,40723,6283,3,217,1,1500.00,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:54','2023-02-09 17:41:54'),(228,7503,65,40723,6283,3,68,1,315.00,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:54','2023-02-09 17:41:54'),(229,7503,65,40723,6283,3,57,2,1815.00,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:54','2023-02-09 17:41:54'),(230,7503,66,40723,6283,3,217,1,10933.56,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:49','2023-02-09 17:41:49'),(231,7503,66,40723,6283,3,68,1,1833.41,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:49','2023-02-09 17:41:49'),(232,7503,66,40723,6283,3,57,2,12766.97,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:49','2023-02-09 17:41:49'),(233,7503,67,40723,6283,3,217,1,2603.45,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:39','2023-02-09 17:41:39'),(234,7503,67,40723,6283,3,68,1,546.72,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:39','2023-02-09 17:41:39'),(235,7503,67,40723,6283,3,217,1,0.01,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:39','2023-02-09 17:41:39'),(236,7503,67,40723,6283,3,57,2,3150.18,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:39','2023-02-09 17:41:39'),(237,7503,68,40723,6283,3,217,1,56.20,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:22','2023-02-09 17:41:22'),(238,7503,68,40723,6283,3,68,1,11.80,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:22','2023-02-09 17:41:22'),(239,7503,68,40723,6283,3,57,2,68.00,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:22','2023-02-09 17:41:22'),(240,7503,69,40723,6283,3,217,1,79.89,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:16','2023-02-09 17:41:16'),(241,7503,69,40723,6283,3,68,1,16.78,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:16','2023-02-09 17:41:16'),(242,7503,69,40723,6283,3,217,1,3.33,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:16','2023-02-09 17:41:16'),(243,7503,69,40723,6283,3,57,2,100.00,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:16','2023-02-09 17:41:16'),(244,7503,70,40723,6283,3,217,1,204.00,NULL,'2023-02-09 17:42:44','2023-02-10 15:42:14','2023-02-10 15:42:14'),(245,7503,70,40723,6283,3,57,2,204.00,NULL,'2023-02-09 17:42:44','2023-02-10 15:42:14','2023-02-10 15:42:14'),(246,7503,71,40723,6283,3,217,1,1815.00,NULL,'2023-02-09 17:42:44','2023-02-10 15:42:07','2023-02-10 15:42:07'),(247,7503,71,40723,6283,3,57,2,1815.00,NULL,'2023-02-09 17:42:44','2023-02-10 15:42:07','2023-02-10 15:42:07'),(248,7503,72,40723,6283,3,217,1,12766.97,NULL,'2023-02-09 17:42:44','2023-02-10 15:42:00','2023-02-10 15:42:00'),(249,7503,72,40723,6283,3,57,2,12766.97,NULL,'2023-02-09 17:42:44','2023-02-10 15:42:00','2023-02-10 15:42:00'),(250,7503,73,40723,6283,3,217,1,3150.18,NULL,'2023-02-09 17:42:44','2023-02-10 15:41:53','2023-02-10 15:41:53'),(251,7503,73,40723,6283,3,57,2,3150.18,NULL,'2023-02-09 17:42:44','2023-02-10 15:41:53','2023-02-10 15:41:53'),(252,7503,74,40723,6283,3,217,1,6695.39,NULL,'2023-02-09 17:42:44','2023-02-09 17:43:34','2023-02-09 17:43:34'),(253,7503,74,40723,6283,3,68,1,1406.03,NULL,'2023-02-09 17:42:44','2023-02-09 17:43:34','2023-02-09 17:43:34'),(254,7503,74,40723,6283,3,217,1,200.86,NULL,'2023-02-09 17:42:44','2023-02-09 17:43:34','2023-02-09 17:43:34'),(255,7503,74,40723,6283,3,57,2,8302.28,NULL,'2023-02-09 17:42:44','2023-02-09 17:43:34','2023-02-09 17:43:34');
INSERT INTO `balance_libro_details` VALUES (256,7503,75,40723,6283,3,217,1,68.00,NULL,'2023-02-09 17:42:44','2023-02-10 15:41:35','2023-02-10 15:41:35'),(257,7503,75,40723,6283,3,57,2,68.00,NULL,'2023-02-09 17:42:44','2023-02-10 15:41:35','2023-02-10 15:41:35'),(258,7503,76,40723,6283,3,217,1,100.00,NULL,'2023-02-09 17:42:44','2023-02-10 15:41:27','2023-02-10 15:41:27'),(259,7503,76,40723,6283,3,57,2,100.00,NULL,'2023-02-09 17:42:44','2023-02-10 15:41:27','2023-02-10 15:41:27'),(260,7503,77,40723,6283,3,217,1,5441.34,NULL,'2023-02-09 17:42:44','2023-02-09 17:44:15','2023-02-09 17:44:15'),(261,7503,77,40723,6283,3,68,1,1142.68,NULL,'2023-02-09 17:42:44','2023-02-09 17:44:15','2023-02-09 17:44:15'),(262,7503,77,40723,6283,3,217,1,1107.82,NULL,'2023-02-09 17:42:44','2023-02-09 17:44:15','2023-02-09 17:44:15'),(263,7503,77,40723,6283,3,57,2,7691.84,NULL,'2023-02-09 17:42:44','2023-02-09 17:44:15','2023-02-09 17:44:15'),(264,7503,78,40723,6283,3,217,1,6695.39,NULL,'2023-02-09 17:43:34','2023-02-10 15:41:45','2023-02-10 15:41:45'),(265,7503,78,40723,6283,3,68,1,1406.03,NULL,'2023-02-09 17:43:34','2023-02-10 15:41:45','2023-02-10 15:41:45'),(266,7503,78,40723,6283,3,226,1,200.86,NULL,'2023-02-09 17:43:34','2023-02-10 15:41:45','2023-02-10 15:41:45'),(267,7503,78,40723,6283,3,57,2,8302.28,NULL,'2023-02-09 17:43:34','2023-02-10 15:41:45','2023-02-10 15:41:45'),(268,7503,79,40723,6283,3,217,1,5441.34,NULL,'2023-02-09 17:44:15','2023-02-09 17:48:14','2023-02-09 17:48:14'),(269,7503,79,40723,6283,3,68,1,1142.68,NULL,'2023-02-09 17:44:15','2023-02-09 17:48:14','2023-02-09 17:48:14'),(270,7503,79,40723,6283,3,224,1,917.07,NULL,'2023-02-09 17:44:15','2023-02-09 17:48:14','2023-02-09 17:48:14'),(271,7503,79,40723,6283,3,226,1,190.75,NULL,'2023-02-09 17:44:15','2023-02-09 17:48:14','2023-02-09 17:48:14'),(272,7503,79,40723,6283,3,57,2,7691.84,NULL,'2023-02-09 17:44:15','2023-02-09 17:48:14','2023-02-09 17:48:14'),(273,7503,80,40723,6283,3,217,1,5441.34,NULL,'2023-02-09 17:48:14','2023-02-10 15:41:19','2023-02-10 15:41:19'),(274,7503,80,40723,6283,3,68,1,1142.68,NULL,'2023-02-09 17:48:14','2023-02-10 15:41:19','2023-02-10 15:41:19'),(275,7503,80,40723,6283,3,221,1,917.07,NULL,'2023-02-09 17:48:14','2023-02-10 15:41:19','2023-02-10 15:41:19'),(276,7503,80,40723,6283,3,226,1,190.75,NULL,'2023-02-09 17:48:14','2023-02-10 15:41:19','2023-02-10 15:41:19'),(277,7503,80,40723,6283,3,57,2,7691.84,NULL,'2023-02-09 17:48:14','2023-02-10 15:41:19','2023-02-10 15:41:19'),(278,7503,81,40723,6283,15,67,1,7519.01,NULL,'2023-02-09 17:49:09','2023-02-09 19:54:37','2023-02-09 19:54:37'),(279,7503,81,40723,6283,15,68,2,2548.71,NULL,'2023-02-09 17:49:09','2023-02-09 19:54:37','2023-02-09 19:54:37'),(280,7503,81,40723,6283,15,74,2,4970.29,NULL,'2023-02-09 17:49:09','2023-02-09 19:54:37','2023-02-09 19:54:37'),(281,7503,81,40723,6283,15,136,2,0.01,NULL,'2023-02-09 17:49:09','2023-02-09 19:54:37','2023-02-09 19:54:37'),(282,7503,82,40723,6283,15,67,1,7519.01,NULL,'2023-02-09 20:04:24','2023-02-09 20:04:32','2023-02-09 20:04:32'),(283,7503,82,40723,6283,15,68,2,2548.71,NULL,'2023-02-09 20:04:24','2023-02-09 20:04:32','2023-02-09 20:04:32'),(284,7503,82,40723,6283,15,74,2,4970.29,NULL,'2023-02-09 20:04:24','2023-02-09 20:04:32','2023-02-09 20:04:32'),(285,7503,82,40723,6283,15,136,2,0.01,NULL,'2023-02-09 20:04:24','2023-02-09 20:04:32','2023-02-09 20:04:32'),(286,7503,83,40723,6283,15,67,1,7519.01,NULL,'2023-02-09 20:31:51','2023-02-09 20:32:05','2023-02-09 20:32:05'),(287,7503,83,40723,6283,15,68,2,2548.71,NULL,'2023-02-09 20:31:51','2023-02-09 20:32:05','2023-02-09 20:32:05'),(288,7503,83,40723,6283,15,74,2,4970.29,NULL,'2023-02-09 20:31:51','2023-02-09 20:32:05','2023-02-09 20:32:05'),(289,7503,83,40723,6283,15,136,2,0.01,NULL,'2023-02-09 20:31:51','2023-02-09 20:32:05','2023-02-09 20:32:05'),(290,7503,84,40723,6283,2,96,2,27024.79,NULL,'2023-02-10 15:45:44','2023-02-10 15:45:44',NULL),(291,7503,84,40723,6283,2,67,2,5675.21,NULL,'2023-02-10 15:45:44','2023-02-10 15:45:44',NULL);
INSERT INTO `balance_libro_details` VALUES (292,7503,84,40723,6283,2,13,1,32700.00,NULL,'2023-02-10 15:45:44','2023-02-10 15:45:44',NULL),(293,7503,85,40723,6283,2,96,2,8780.00,NULL,'2023-02-10 15:45:44','2023-02-10 15:45:44',NULL),(294,7503,85,40723,6283,2,67,2,1843.80,NULL,'2023-02-10 15:45:44','2023-02-10 15:45:44',NULL),(295,7503,85,40723,6283,2,13,1,10623.80,NULL,'2023-02-10 15:45:44','2023-02-10 15:45:44',NULL),(296,7503,86,40723,6283,3,217,1,6695.39,NULL,'2023-02-10 15:46:31','2023-02-10 15:47:46','2023-02-10 15:47:46'),(297,7503,86,40723,6283,3,68,1,1406.03,NULL,'2023-02-10 15:46:31','2023-02-10 15:47:46','2023-02-10 15:47:46'),(298,7503,86,40723,6283,3,217,1,200.86,NULL,'2023-02-10 15:46:31','2023-02-10 15:47:46','2023-02-10 15:47:46'),(299,7503,86,40723,6283,3,57,2,8302.28,NULL,'2023-02-10 15:46:31','2023-02-10 15:47:46','2023-02-10 15:47:46'),(300,7503,87,40723,6283,3,217,1,5441.34,NULL,'2023-02-10 15:46:31','2023-02-10 16:01:41','2023-02-10 16:01:41'),(301,7503,87,40723,6283,3,68,1,1142.68,NULL,'2023-02-10 15:46:31','2023-02-10 16:01:41','2023-02-10 16:01:41'),(302,7503,87,40723,6283,3,217,1,1107.82,NULL,'2023-02-10 15:46:31','2023-02-10 16:01:41','2023-02-10 16:01:41'),(303,7503,87,40723,6283,3,57,2,7691.84,NULL,'2023-02-10 15:46:31','2023-02-10 16:01:41','2023-02-10 16:01:41'),(304,7503,88,40723,6283,3,217,1,6695.39,NULL,'2023-02-10 15:47:46','2023-02-10 15:47:46',NULL),(305,7503,88,40723,6283,3,68,1,1406.03,NULL,'2023-02-10 15:47:46','2023-02-10 15:47:46',NULL),(306,7503,88,40723,6283,3,226,1,200.86,NULL,'2023-02-10 15:47:46','2023-02-10 15:47:46',NULL),(307,7503,88,40723,6283,3,57,2,8302.28,NULL,'2023-02-10 15:47:46','2023-02-10 15:47:46',NULL),(308,7503,89,40723,6283,3,217,1,5441.34,NULL,'2023-02-10 16:01:41','2023-02-10 16:01:41',NULL),(309,7503,89,40723,6283,3,68,1,1142.68,NULL,'2023-02-10 16:01:41','2023-02-10 16:01:41',NULL),(310,7503,89,40723,6283,3,217,1,917.07,NULL,'2023-02-10 16:01:42','2023-02-10 16:01:42',NULL),(311,7503,89,40723,6283,3,226,1,190.75,NULL,'2023-02-10 16:01:42','2023-02-10 16:01:42',NULL),(312,7503,89,40723,6283,3,57,2,7691.84,NULL,'2023-02-10 16:01:42','2023-02-10 16:01:42',NULL),(313,7503,90,40722,4529,2,96,2,291135.89,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(314,7503,90,40722,4529,2,67,2,61137.92,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(315,7503,90,40722,4529,2,218,2,-0.01,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(316,7503,90,40722,4529,2,13,1,352273.80,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(317,7503,91,40722,4529,2,96,2,526014.00,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(318,7503,91,40722,4529,2,67,2,110462.94,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(319,7503,91,40722,4529,2,13,1,636476.94,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(320,7503,92,40722,4529,2,96,2,273452.01,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(321,7503,92,40722,4529,2,67,2,57424.92,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(322,7503,92,40722,4529,2,13,1,330876.93,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(323,7503,93,40722,4529,2,96,2,537686.01,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(324,7503,93,40722,4529,2,67,2,112914.07,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(325,7503,93,40722,4529,2,13,1,650600.08,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(326,7503,94,40722,4529,2,96,2,373355.47,NULL,'2023-03-21 10:02:49','2023-03-21 10:02:49',NULL),(327,7503,94,40722,4529,2,67,2,78404.65,NULL,'2023-03-21 10:02:49','2023-03-21 10:02:49',NULL),(328,7503,94,40722,4529,2,13,1,451760.12,NULL,'2023-03-21 10:02:49','2023-03-21 10:02:49',NULL),(329,7503,95,40722,4529,2,96,2,84480.71,NULL,'2023-03-21 10:02:49','2023-03-21 10:02:49',NULL),(330,7503,95,40722,4529,2,67,2,17740.95,NULL,'2023-03-21 10:02:49','2023-03-21 10:02:49',NULL),(331,7503,95,40722,4529,2,13,1,102221.66,NULL,'2023-03-21 10:02:49','2023-03-21 10:02:49',NULL);
INSERT INTO `balance_libro_details` VALUES (332,7503,96,40722,4529,2,96,2,95847.24,NULL,'2023-03-21 10:02:49','2023-03-21 10:02:49',NULL),(333,7503,96,40722,4529,2,67,2,20127.92,NULL,'2023-03-21 10:02:49','2023-03-21 10:02:49',NULL),(334,7503,96,40722,4529,2,13,1,115975.16,NULL,'2023-03-21 10:02:49','2023-03-21 10:02:49',NULL),(335,7503,97,40722,4529,2,218,1,0.00,NULL,'2023-03-21 10:02:49','2023-03-21 10:07:52','2023-03-21 10:07:52'),(336,7503,97,40722,4529,2,13,2,0.00,NULL,'2023-03-21 10:02:49','2023-03-21 10:07:52','2023-03-21 10:07:52'),(337,7503,98,40722,4529,3,217,1,4115.21,NULL,'2023-03-21 10:06:12','2023-03-21 10:12:36','2023-03-21 10:12:36'),(338,7503,98,40722,4529,3,68,1,864.19,NULL,'2023-03-21 10:06:12','2023-03-21 10:12:36','2023-03-21 10:12:36'),(339,7503,98,40722,4529,3,217,1,308.64,NULL,'2023-03-21 10:06:12','2023-03-21 10:12:36','2023-03-21 10:12:36'),(340,7503,98,40722,4529,3,57,2,5288.04,NULL,'2023-03-21 10:06:12','2023-03-21 10:12:36','2023-03-21 10:12:36'),(341,7503,99,40722,4529,3,217,1,10099.55,NULL,'2023-03-21 10:06:12','2023-03-21 10:12:03','2023-03-21 10:12:03'),(342,7503,99,40722,4529,3,68,1,1060.45,NULL,'2023-03-21 10:06:12','2023-03-21 10:12:03','2023-03-21 10:12:03'),(343,7503,99,40722,4529,3,57,2,11160.00,NULL,'2023-03-21 10:06:12','2023-03-21 10:12:03','2023-03-21 10:12:03'),(344,7503,100,40722,4529,3,217,1,4799.00,NULL,'2023-03-21 10:06:12','2023-03-21 10:11:38','2023-03-21 10:11:38'),(345,7503,100,40722,4529,3,68,1,1007.79,NULL,'2023-03-21 10:06:12','2023-03-21 10:11:38','2023-03-21 10:11:38'),(346,7503,100,40722,4529,3,217,1,239.95,NULL,'2023-03-21 10:06:12','2023-03-21 10:11:38','2023-03-21 10:11:38'),(347,7503,100,40722,4529,3,57,2,6046.74,NULL,'2023-03-21 10:06:12','2023-03-21 10:11:38','2023-03-21 10:11:38'),(348,7503,101,40722,4529,3,217,1,17238.52,NULL,'2023-03-21 10:06:12','2023-03-21 10:06:12',NULL),(349,7503,101,40722,4529,3,68,1,3620.09,NULL,'2023-03-21 10:06:12','2023-03-21 10:06:12',NULL),(350,7503,101,40722,4529,3,217,1,1292.89,NULL,'2023-03-21 10:06:12','2023-03-21 10:06:12',NULL),(351,7503,101,40722,4529,3,57,2,22151.50,NULL,'2023-03-21 10:06:12','2023-03-21 10:06:12',NULL),(352,7503,102,40722,4529,3,217,1,41016.53,NULL,'2023-03-21 10:06:13','2023-03-21 10:06:13',NULL),(353,7503,102,40722,4529,3,68,1,8613.47,NULL,'2023-03-21 10:06:13','2023-03-21 10:06:13',NULL),(354,7503,102,40722,4529,3,57,2,49630.00,NULL,'2023-03-21 10:06:13','2023-03-21 10:06:13',NULL),(355,7503,103,40722,4529,3,217,1,28975.20,NULL,'2023-03-21 10:06:13','2023-03-21 10:06:13',NULL),(356,7503,103,40722,4529,3,68,1,6084.80,NULL,'2023-03-21 10:06:13','2023-03-21 10:06:13',NULL),(357,7503,103,40722,4529,3,57,2,35060.00,NULL,'2023-03-21 10:06:13','2023-03-21 10:06:13',NULL),(358,7503,104,40722,4529,3,217,1,7010.83,NULL,'2023-03-21 10:06:13','2023-03-21 10:11:04','2023-03-21 10:11:04'),(359,7503,104,40722,4529,3,68,1,1472.28,NULL,'2023-03-21 10:06:13','2023-03-21 10:11:04','2023-03-21 10:11:04'),(360,7503,104,40722,4529,3,217,1,1524.75,NULL,'2023-03-21 10:06:13','2023-03-21 10:11:04','2023-03-21 10:11:04'),(361,7503,104,40722,4529,3,57,2,10007.86,NULL,'2023-03-21 10:06:13','2023-03-21 10:11:04','2023-03-21 10:11:04'),(362,7503,105,40722,4529,3,217,1,16487.60,NULL,'2023-03-21 10:06:13','2023-03-21 10:06:13',NULL),(363,7503,105,40722,4529,3,68,1,3462.40,NULL,'2023-03-21 10:06:13','2023-03-21 10:06:13',NULL),(364,7503,105,40722,4529,3,57,2,19950.00,NULL,'2023-03-21 10:06:13','2023-03-21 10:06:13',NULL),(365,7503,106,40722,4529,3,217,1,58505.90,NULL,'2023-03-21 10:06:13','2023-03-21 10:09:47','2023-03-21 10:09:47'),(366,7503,106,40722,4529,3,68,1,12286.24,NULL,'2023-03-21 10:06:13','2023-03-21 10:09:47','2023-03-21 10:09:47'),(367,7503,106,40722,4529,3,57,2,70792.14,NULL,'2023-03-21 10:06:13','2023-03-21 10:09:47','2023-03-21 10:09:47'),(368,7503,107,40722,4529,3,217,1,7429.75,NULL,'2023-03-21 10:06:13','2023-03-21 10:09:29','2023-03-21 10:09:29'),(369,7503,107,40722,4529,3,68,1,1560.25,NULL,'2023-03-21 10:06:13','2023-03-21 10:09:29','2023-03-21 10:09:29');
INSERT INTO `balance_libro_details` VALUES (370,7503,107,40722,4529,3,57,2,8990.00,NULL,'2023-03-21 10:06:13','2023-03-21 10:09:29','2023-03-21 10:09:29'),(371,7503,108,40722,4529,3,217,1,6016.84,NULL,'2023-03-21 10:06:13','2023-03-21 10:09:03','2023-03-21 10:09:03'),(372,7503,108,40722,4529,3,68,1,1263.54,NULL,'2023-03-21 10:06:13','2023-03-21 10:09:03','2023-03-21 10:09:03'),(373,7503,108,40722,4529,3,217,1,820.61,NULL,'2023-03-21 10:06:13','2023-03-21 10:09:03','2023-03-21 10:09:03'),(374,7503,108,40722,4529,3,57,2,8100.99,NULL,'2023-03-21 10:06:13','2023-03-21 10:09:03','2023-03-21 10:09:03'),(375,7503,109,40722,4529,3,217,1,6016.84,NULL,'2023-03-21 10:09:03','2023-03-21 10:09:03',NULL),(376,7503,109,40722,4529,3,68,1,1263.54,NULL,'2023-03-21 10:09:03','2023-03-21 10:09:03',NULL),(377,7503,109,40722,4529,3,221,1,820.61,NULL,'2023-03-21 10:09:03','2023-03-21 10:09:03',NULL),(378,7503,109,40722,4529,3,57,2,8100.99,NULL,'2023-03-21 10:09:03','2023-03-21 10:09:03',NULL),(379,7503,110,40722,4529,3,217,1,7429.75,NULL,'2023-03-21 10:09:29','2023-03-21 10:09:29',NULL),(380,7503,110,40722,4529,3,68,1,1560.25,NULL,'2023-03-21 10:09:29','2023-03-21 10:09:29',NULL),(381,7503,110,40722,4529,3,57,2,8990.00,NULL,'2023-03-21 10:09:29','2023-03-21 10:09:29',NULL),(382,7503,111,40722,4529,3,217,1,58505.90,NULL,'2023-03-21 10:09:47','2023-03-21 10:09:47',NULL),(383,7503,111,40722,4529,3,68,1,12286.24,NULL,'2023-03-21 10:09:47','2023-03-21 10:09:47',NULL),(384,7503,111,40722,4529,3,57,2,70792.14,NULL,'2023-03-21 10:09:47','2023-03-21 10:09:47',NULL),(385,7503,112,40722,4529,3,217,1,7010.84,NULL,'2023-03-21 10:11:04','2023-03-21 10:11:04',NULL),(386,7503,112,40722,4529,3,68,1,1472.28,NULL,'2023-03-21 10:11:04','2023-03-21 10:11:04',NULL),(387,7503,112,40722,4529,3,221,1,1116.29,NULL,'2023-03-21 10:11:04','2023-03-21 10:11:04',NULL),(388,7503,112,40722,4529,3,225,1,406.46,NULL,'2023-03-21 10:11:04','2023-03-21 10:11:04',NULL),(389,7503,112,40722,4529,3,57,2,10005.87,NULL,'2023-03-21 10:11:04','2023-03-21 10:11:04',NULL),(390,7503,113,40722,4529,3,217,1,4799.00,NULL,'2023-03-21 10:11:38','2023-03-21 10:11:38',NULL),(391,7503,113,40722,4529,3,68,1,1007.79,NULL,'2023-03-21 10:11:38','2023-03-21 10:11:38',NULL),(392,7503,113,40722,4529,3,225,1,239.95,NULL,'2023-03-21 10:11:38','2023-03-21 10:11:38',NULL),(393,7503,113,40722,4529,3,57,2,6046.74,NULL,'2023-03-21 10:11:38','2023-03-21 10:11:38',NULL),(394,7503,114,40722,4529,3,217,1,10099.55,NULL,'2023-03-21 10:12:03','2023-03-21 10:12:03',NULL),(395,7503,114,40722,4529,3,68,1,1060.45,NULL,'2023-03-21 10:12:03','2023-03-21 10:12:03',NULL),(396,7503,114,40722,4529,3,57,2,11160.00,NULL,'2023-03-21 10:12:03','2023-03-21 10:12:03',NULL),(397,7503,115,40722,4529,3,217,1,4115.21,NULL,'2023-03-21 10:12:36','2023-03-21 10:12:36',NULL),(398,7503,115,40722,4529,3,68,1,864.19,NULL,'2023-03-21 10:12:36','2023-03-21 10:12:36',NULL),(399,7503,115,40722,4529,3,225,1,205.76,NULL,'2023-03-21 10:12:36','2023-03-21 10:12:36',NULL),(400,7503,115,40722,4529,3,226,1,102.88,NULL,'2023-03-21 10:12:36','2023-03-21 10:12:36',NULL),(401,7503,115,40722,4529,3,57,2,5288.04,NULL,'2023-03-21 10:12:36','2023-03-21 10:12:36',NULL),(402,7503,116,40722,4529,3,217,1,6319.33,NULL,'2023-03-21 10:16:27','2023-03-21 10:16:27',NULL),(403,7503,116,40722,4529,3,68,1,1327.06,NULL,'2023-03-21 10:16:27','2023-03-21 10:16:27',NULL),(404,7503,116,40722,4529,3,221,1,958.14,NULL,'2023-03-21 10:16:27','2023-03-21 10:16:27',NULL),(405,7503,116,40722,4529,3,225,1,363.87,NULL,'2023-03-21 10:16:27','2023-03-21 10:16:27',NULL),(406,7503,116,40722,4529,3,57,2,8968.40,NULL,'2023-03-21 10:16:27','2023-03-21 10:16:27',NULL),(407,7503,117,40722,4529,7,25,1,701.65,NULL,'2023-03-21 10:36:10','2023-03-21 10:36:10',NULL),(408,7503,117,40722,4529,7,13,2,701.65,NULL,'2023-03-21 10:36:10','2023-03-21 10:36:10',NULL),(409,7503,118,40722,4529,7,25,1,85.25,NULL,'2023-03-21 10:37:57','2023-03-21 10:37:57',NULL),(410,7503,118,40722,4529,7,13,2,85.25,NULL,'2023-03-21 10:37:57','2023-03-21 10:37:57',NULL);
INSERT INTO `balance_libro_details` VALUES (411,7503,119,40722,4529,15,67,1,458213.98,NULL,'2023-03-21 10:41:45','2023-03-21 10:41:45',NULL),(412,7503,119,40722,4529,15,68,2,42622.54,NULL,'2023-03-21 10:41:45','2023-03-21 10:41:45',NULL),(413,7503,119,40722,4529,15,25,2,786.90,NULL,'2023-03-21 10:41:45','2023-03-21 10:41:45',NULL),(414,7503,119,40722,4529,15,74,2,414804.54,NULL,'2023-03-21 10:41:45','2023-03-21 10:41:45',NULL),(415,7503,120,40722,4529,16,226,2,102.88,NULL,'2023-03-21 10:41:51','2023-03-21 10:41:51',NULL),(416,7503,120,40722,4529,16,302,1,102.88,NULL,'2023-03-21 10:41:51','2023-03-21 10:41:51',NULL),(417,7503,120,40722,4529,16,225,2,1216.04,NULL,'2023-03-21 10:41:51','2023-03-21 10:41:51',NULL),(418,7503,120,40722,4529,16,301,1,1216.04,NULL,'2023-03-21 10:41:51','2023-03-21 10:41:51',NULL),(419,7503,121,40722,4530,2,96,2,1000.00,NULL,'2023-03-21 12:40:38','2023-03-21 12:40:38',NULL),(420,7503,121,40722,4530,2,67,2,210.00,NULL,'2023-03-21 12:40:38','2023-03-21 12:40:38',NULL),(421,7503,121,40722,4530,2,13,1,1210.00,NULL,'2023-03-21 12:40:38','2023-03-21 12:40:38',NULL),(422,7503,122,40722,4530,2,96,2,254395.70,NULL,'2023-03-21 12:40:38','2023-03-21 12:40:38',NULL),(423,7503,122,40722,4530,2,67,2,53423.10,NULL,'2023-03-21 12:40:38','2023-03-21 12:40:38',NULL),(424,7503,122,40722,4530,2,13,1,307818.80,NULL,'2023-03-21 12:40:38','2023-03-21 12:40:38',NULL),(425,7503,123,40722,4530,3,217,1,14710.74,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(426,7503,123,40722,4530,3,68,1,3089.26,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(427,7503,123,40722,4530,3,57,2,17800.00,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(428,7503,124,40722,4530,3,217,1,9917.36,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(429,7503,124,40722,4530,3,68,1,2082.64,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(430,7503,124,40722,4530,3,57,2,12000.00,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(431,7503,125,40722,4530,3,217,1,8909.09,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(432,7503,125,40722,4530,3,68,1,1870.91,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(433,7503,125,40722,4530,3,57,2,10780.00,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(434,7503,126,40722,4530,3,217,1,27854.30,NULL,'2023-03-21 12:41:00','2023-03-21 12:44:25','2023-03-21 12:44:25'),(435,7503,126,40722,4530,3,68,1,2924.70,NULL,'2023-03-21 12:41:00','2023-03-21 12:44:25','2023-03-21 12:44:25'),(436,7503,126,40722,4530,3,57,2,30779.00,NULL,'2023-03-21 12:41:00','2023-03-21 12:44:25','2023-03-21 12:44:25'),(437,7503,127,40722,4530,3,217,1,6991.74,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(438,7503,127,40722,4530,3,68,1,1468.27,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(439,7503,127,40722,4530,3,57,2,8460.01,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(440,7503,128,40722,4530,3,217,1,6957.22,NULL,'2023-03-21 12:41:00','2023-03-21 12:44:08','2023-03-21 12:44:08'),(441,7503,128,40722,4530,3,68,1,1461.02,NULL,'2023-03-21 12:41:00','2023-03-21 12:44:08','2023-03-21 12:44:08'),(442,7503,128,40722,4530,3,217,1,1484.44,NULL,'2023-03-21 12:41:00','2023-03-21 12:44:08','2023-03-21 12:44:08'),(443,7503,128,40722,4530,3,57,2,9902.68,NULL,'2023-03-21 12:41:00','2023-03-21 12:44:08','2023-03-21 12:44:08'),(444,7503,129,40722,4530,3,217,1,58141.47,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(445,7503,129,40722,4530,3,68,1,12209.71,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(446,7503,129,40722,4530,3,57,2,70351.18,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(447,7503,130,40722,4530,3,217,1,7404.96,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(448,7503,130,40722,4530,3,68,1,1555.04,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(449,7503,130,40722,4530,3,57,2,8960.00,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(450,7503,131,40722,4530,3,217,1,413.22,NULL,'2023-03-21 12:41:00','2023-03-21 12:43:41','2023-03-21 12:43:41');
INSERT INTO `balance_libro_details` VALUES (451,7503,131,40722,4530,3,68,1,86.78,NULL,'2023-03-21 12:41:00','2023-03-21 12:43:41','2023-03-21 12:43:41'),(452,7503,131,40722,4530,3,217,1,18.59,NULL,'2023-03-21 12:41:00','2023-03-21 12:43:41','2023-03-21 12:43:41'),(453,7503,131,40722,4530,3,57,2,518.59,NULL,'2023-03-21 12:41:00','2023-03-21 12:43:41','2023-03-21 12:43:41'),(454,7503,132,40722,4530,3,217,1,1729.74,NULL,'2023-03-21 12:41:01','2023-03-21 12:41:01',NULL),(455,7503,132,40722,4530,3,68,1,363.25,NULL,'2023-03-21 12:41:01','2023-03-21 12:41:01',NULL),(456,7503,132,40722,4530,3,57,2,2092.99,NULL,'2023-03-21 12:41:01','2023-03-21 12:41:01',NULL),(457,7503,133,40722,4530,3,217,1,2834.19,NULL,'2023-03-21 12:41:01','2023-03-21 12:41:01',NULL),(458,7503,133,40722,4530,3,68,1,595.18,NULL,'2023-03-21 12:41:01','2023-03-21 12:41:01',NULL),(459,7503,133,40722,4530,3,57,2,3429.37,NULL,'2023-03-21 12:41:01','2023-03-21 12:41:01',NULL),(460,7503,134,40722,4530,3,217,1,7882.67,NULL,'2023-03-21 12:41:01','2023-03-21 12:43:12','2023-03-21 12:43:12'),(461,7503,134,40722,4530,3,68,1,1655.36,NULL,'2023-03-21 12:41:01','2023-03-21 12:43:12','2023-03-21 12:43:12'),(462,7503,134,40722,4530,3,217,1,1581.23,NULL,'2023-03-21 12:41:01','2023-03-21 12:43:12','2023-03-21 12:43:12'),(463,7503,134,40722,4530,3,57,2,11119.26,NULL,'2023-03-21 12:41:01','2023-03-21 12:43:12','2023-03-21 12:43:12'),(464,7503,135,40722,4530,3,217,1,7882.67,NULL,'2023-03-21 12:43:12','2023-03-21 12:43:12',NULL),(465,7503,135,40722,4530,3,68,1,1655.36,NULL,'2023-03-21 12:43:12','2023-03-21 12:43:12',NULL),(466,7503,135,40722,4530,3,221,1,1130.57,NULL,'2023-03-21 12:43:12','2023-03-21 12:43:12',NULL),(467,7503,135,40722,4530,3,225,1,450.66,NULL,'2023-03-21 12:43:12','2023-03-21 12:43:12',NULL),(468,7503,135,40722,4530,3,57,2,11119.26,NULL,'2023-03-21 12:43:12','2023-03-21 12:43:12',NULL),(469,7503,136,40722,4530,3,217,1,413.22,NULL,'2023-03-21 12:43:41','2023-03-21 12:43:41',NULL),(470,7503,136,40722,4530,3,68,1,86.78,NULL,'2023-03-21 12:43:41','2023-03-21 12:43:41',NULL),(471,7503,136,40722,4530,3,221,1,18.59,NULL,'2023-03-21 12:43:41','2023-03-21 12:43:41',NULL),(472,7503,136,40722,4530,3,57,2,518.59,NULL,'2023-03-21 12:43:41','2023-03-21 12:43:41',NULL),(473,7503,137,40722,4530,3,217,1,6957.22,NULL,'2023-03-21 12:44:08','2023-03-21 12:44:08',NULL),(474,7503,137,40722,4530,3,68,1,1461.02,NULL,'2023-03-21 12:44:08','2023-03-21 12:44:08',NULL),(475,7503,137,40722,4530,3,221,1,1082.46,NULL,'2023-03-21 12:44:08','2023-03-21 12:44:08',NULL),(476,7503,137,40722,4530,3,225,1,401.98,NULL,'2023-03-21 12:44:08','2023-03-21 12:44:08',NULL),(477,7503,137,40722,4530,3,57,2,9902.68,NULL,'2023-03-21 12:44:08','2023-03-21 12:44:08',NULL),(478,7503,138,40722,4530,3,217,1,27854.30,NULL,'2023-03-21 12:44:25','2023-03-21 12:44:25',NULL),(479,7503,138,40722,4530,3,68,1,2924.70,NULL,'2023-03-21 12:44:25','2023-03-21 12:44:25',NULL),(480,7503,138,40722,4530,3,57,2,30779.00,NULL,'2023-03-21 12:44:25','2023-03-21 12:44:25',NULL),(481,7503,139,40722,4530,3,217,1,2923.28,NULL,'2023-03-21 12:46:28','2023-03-21 12:46:28',NULL),(482,7503,139,40722,4530,3,68,1,613.89,NULL,'2023-03-21 12:46:28','2023-03-21 12:46:28',NULL),(483,7503,139,40722,4530,3,221,1,462.75,NULL,'2023-03-21 12:46:28','2023-03-21 12:46:28',NULL),(484,7503,139,40722,4530,3,57,2,3999.92,NULL,'2023-03-21 12:46:28','2023-03-21 12:46:28',NULL),(485,7503,140,40722,4530,3,217,1,5779.72,NULL,'2023-03-21 12:48:27','2023-03-21 12:48:27',NULL),(486,7503,140,40722,4530,3,68,1,1213.74,NULL,'2023-03-21 12:48:27','2023-03-21 12:48:27',NULL),(487,7503,140,40722,4530,3,221,1,907.14,NULL,'2023-03-21 12:48:27','2023-03-21 12:48:27',NULL),(488,7503,140,40722,4530,3,57,2,7900.60,NULL,'2023-03-21 12:48:27','2023-03-21 12:48:27',NULL),(489,7503,141,40722,4530,3,217,1,1473.11,NULL,'2023-03-21 12:49:18','2023-03-21 12:49:18',NULL),(490,7503,141,40722,4530,3,68,1,309.35,NULL,'2023-03-21 12:49:18','2023-03-21 12:49:18',NULL);
INSERT INTO `balance_libro_details` VALUES (491,7503,141,40722,4530,3,221,1,217.64,NULL,'2023-03-21 12:49:18','2023-03-21 12:49:18',NULL),(492,7503,141,40722,4530,3,57,2,2000.10,NULL,'2023-03-21 12:49:18','2023-03-21 12:49:18',NULL),(493,7503,142,40722,4530,15,67,1,53633.10,NULL,'2023-05-18 08:40:48','2023-05-18 08:40:48',NULL),(494,7503,142,40722,4530,15,68,2,31499.09,NULL,'2023-05-18 08:40:48','2023-05-18 08:40:48',NULL),(495,7503,142,40722,4530,15,74,2,22134.01,NULL,'2023-05-18 08:40:48','2023-05-18 08:40:48',NULL),(496,7503,143,40722,4531,2,96,2,1928387.24,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(497,7503,143,40722,4531,2,67,2,404961.87,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(498,7503,143,40722,4531,2,13,1,2333349.11,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(499,7503,144,40722,4531,2,96,2,695043.47,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(500,7503,144,40722,4531,2,67,2,145959.13,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(501,7503,144,40722,4531,2,13,1,841002.60,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(502,7503,145,40722,4531,2,96,2,85991.52,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(503,7503,145,40722,4531,2,67,2,18058.22,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(504,7503,145,40722,4531,2,13,1,104049.74,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(505,7503,146,40722,4531,2,96,2,924220.62,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(506,7503,146,40722,4531,2,67,2,194086.33,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(507,7503,146,40722,4531,2,13,1,1118306.95,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(508,7503,147,40722,4531,2,96,2,134743.28,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(509,7503,147,40722,4531,2,67,2,28296.09,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(510,7503,147,40722,4531,2,13,1,163039.37,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(511,7503,148,40722,4531,2,96,2,1000.00,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(512,7503,148,40722,4531,2,67,2,210.00,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(513,7503,148,40722,4531,2,13,1,1210.00,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(514,7503,149,40722,4531,2,96,2,2206310.90,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(515,7503,149,40722,4531,2,67,2,463325.29,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(516,7503,149,40722,4531,2,13,1,2669636.19,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(517,7503,150,40722,4531,3,250,1,0.00,NULL,'2023-05-18 08:57:13','2023-05-18 09:14:17','2023-05-18 09:14:17'),(518,7503,150,40722,4531,3,57,2,0.00,NULL,'2023-05-18 08:57:13','2023-05-18 09:14:17','2023-05-18 09:14:17'),(519,7503,151,40722,4531,3,217,1,228512.59,NULL,'2023-05-18 08:57:13','2023-05-18 09:13:53','2023-05-18 09:13:53'),(520,7503,151,40722,4531,3,68,1,47987.64,NULL,'2023-05-18 08:57:13','2023-05-18 09:13:53','2023-05-18 09:13:53'),(521,7503,151,40722,4531,3,217,1,11425.63,NULL,'2023-05-18 08:57:13','2023-05-18 09:13:53','2023-05-18 09:13:53'),(522,7503,151,40722,4531,3,57,2,287925.86,NULL,'2023-05-18 08:57:13','2023-05-18 09:13:53','2023-05-18 09:13:53'),(523,7503,152,40722,4531,3,217,1,11765.61,NULL,'2023-05-18 08:57:13','2023-05-18 09:13:12','2023-05-18 09:13:12'),(524,7503,152,40722,4531,3,68,1,1235.39,NULL,'2023-05-18 08:57:13','2023-05-18 09:13:12','2023-05-18 09:13:12'),(525,7503,152,40722,4531,3,57,2,13001.00,NULL,'2023-05-18 08:57:13','2023-05-18 09:13:12','2023-05-18 09:13:12'),(526,7503,153,40722,4531,3,250,1,119.00,NULL,'2023-05-18 08:57:13','2023-05-18 09:02:27','2023-05-18 09:02:27'),(527,7503,153,40722,4531,3,57,2,119.00,NULL,'2023-05-18 08:57:13','2023-05-18 09:02:27','2023-05-18 09:02:27'),(528,7503,154,40722,4531,3,217,1,134.71,NULL,'2023-05-18 08:57:13','2023-05-18 09:02:17','2023-05-18 09:02:17'),(529,7503,154,40722,4531,3,68,1,28.29,NULL,'2023-05-18 08:57:13','2023-05-18 09:02:17','2023-05-18 09:02:17');
INSERT INTO `balance_libro_details` VALUES (530,7503,154,40722,4531,3,57,2,163.00,NULL,'2023-05-18 08:57:13','2023-05-18 09:02:17','2023-05-18 09:02:17'),(531,7503,155,40722,4531,3,217,1,134.71,NULL,'2023-05-18 08:57:13','2023-05-18 09:02:07','2023-05-18 09:02:07'),(532,7503,155,40722,4531,3,68,1,28.29,NULL,'2023-05-18 08:57:13','2023-05-18 09:02:07','2023-05-18 09:02:07'),(533,7503,155,40722,4531,3,57,2,163.00,NULL,'2023-05-18 08:57:13','2023-05-18 09:02:07','2023-05-18 09:02:07'),(534,7503,156,40722,4531,3,217,1,5689.26,NULL,'2023-05-18 08:57:13','2023-05-18 09:12:54','2023-05-18 09:12:54'),(535,7503,156,40722,4531,3,68,1,1194.74,NULL,'2023-05-18 08:57:13','2023-05-18 09:12:54','2023-05-18 09:12:54'),(536,7503,156,40722,4531,3,57,2,6884.00,NULL,'2023-05-18 08:57:13','2023-05-18 09:12:54','2023-05-18 09:12:54'),(537,7503,157,40722,4531,3,217,1,106347.60,NULL,'2023-05-18 08:57:13','2023-05-18 09:12:32','2023-05-18 09:12:32'),(538,7503,157,40722,4531,3,68,1,22333.00,NULL,'2023-05-18 08:57:13','2023-05-18 09:12:32','2023-05-18 09:12:32'),(539,7503,157,40722,4531,3,57,2,128680.60,NULL,'2023-05-18 08:57:13','2023-05-18 09:12:32','2023-05-18 09:12:32'),(540,7503,158,40722,4531,3,217,1,4799.00,NULL,'2023-05-18 08:57:13','2023-05-18 09:12:08','2023-05-18 09:12:08'),(541,7503,158,40722,4531,3,68,1,1007.79,NULL,'2023-05-18 08:57:13','2023-05-18 09:12:08','2023-05-18 09:12:08'),(542,7503,158,40722,4531,3,217,1,239.95,NULL,'2023-05-18 08:57:13','2023-05-18 09:12:08','2023-05-18 09:12:08'),(543,7503,158,40722,4531,3,57,2,6046.74,NULL,'2023-05-18 08:57:13','2023-05-18 09:12:08','2023-05-18 09:12:08'),(544,7503,159,40722,4531,3,217,1,1806460.00,NULL,'2023-05-18 08:57:13','2023-05-18 09:11:34','2023-05-18 09:11:34'),(545,7503,159,40722,4531,3,68,1,379356.60,NULL,'2023-05-18 08:57:13','2023-05-18 09:11:34','2023-05-18 09:11:34'),(546,7503,159,40722,4531,3,57,2,2185816.60,NULL,'2023-05-18 08:57:13','2023-05-18 09:11:34','2023-05-18 09:11:34'),(547,7503,160,40722,4531,3,250,1,5000.00,NULL,'2023-05-18 08:57:13','2023-05-18 09:01:47','2023-05-18 09:01:47'),(548,7503,160,40722,4531,3,57,2,5000.00,NULL,'2023-05-18 08:57:13','2023-05-18 09:01:47','2023-05-18 09:01:47'),(549,7503,161,40722,4531,3,250,1,5000.00,NULL,'2023-05-18 08:57:13','2023-05-18 09:01:33','2023-05-18 09:01:33'),(550,7503,161,40722,4531,3,57,2,5000.00,NULL,'2023-05-18 08:57:13','2023-05-18 09:01:33','2023-05-18 09:01:33'),(551,7503,162,40722,4531,3,250,1,6476.00,NULL,'2023-05-18 08:57:13','2023-05-18 09:01:13','2023-05-18 09:01:13'),(552,7503,162,40722,4531,3,57,2,6476.00,NULL,'2023-05-18 08:57:13','2023-05-18 09:01:13','2023-05-18 09:01:13'),(553,7503,163,40722,4531,3,217,1,35992.04,NULL,'2023-05-18 08:57:13','2023-05-18 09:10:46','2023-05-18 09:10:46'),(554,7503,163,40722,4531,3,68,1,7558.33,NULL,'2023-05-18 08:57:13','2023-05-18 09:10:46','2023-05-18 09:10:46'),(555,7503,163,40722,4531,3,217,1,2699.40,NULL,'2023-05-18 08:57:13','2023-05-18 09:10:46','2023-05-18 09:10:46'),(556,7503,163,40722,4531,3,57,2,46249.77,NULL,'2023-05-18 08:57:13','2023-05-18 09:10:46','2023-05-18 09:10:46'),(557,7503,164,40722,4531,3,217,1,19115.70,NULL,'2023-05-18 08:57:13','2023-05-18 09:09:49','2023-05-18 09:09:49'),(558,7503,164,40722,4531,3,68,1,4014.30,NULL,'2023-05-18 08:57:13','2023-05-18 09:09:49','2023-05-18 09:09:49'),(559,7503,164,40722,4531,3,217,1,1146.94,NULL,'2023-05-18 08:57:13','2023-05-18 09:09:49','2023-05-18 09:09:49'),(560,7503,164,40722,4531,3,57,2,24276.94,NULL,'2023-05-18 08:57:13','2023-05-18 09:09:49','2023-05-18 09:09:49'),(561,7503,165,40722,4531,3,217,1,4005.26,NULL,'2023-05-18 08:57:13','2023-05-18 08:57:13',NULL),(562,7503,165,40722,4531,3,68,1,841.10,NULL,'2023-05-18 08:57:13','2023-05-18 08:57:13',NULL),(563,7503,165,40722,4531,3,57,2,4846.36,NULL,'2023-05-18 08:57:13','2023-05-18 08:57:13',NULL),(564,7503,166,40722,4531,3,250,1,5500.00,NULL,'2023-05-18 08:57:13','2023-05-18 09:00:54','2023-05-18 09:00:54'),(565,7503,166,40722,4531,3,57,2,5500.00,NULL,'2023-05-18 08:57:13','2023-05-18 09:00:54','2023-05-18 09:00:54');
INSERT INTO `balance_libro_details` VALUES (566,7503,167,40722,4531,3,217,1,33471.06,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(567,7503,167,40722,4531,3,68,1,7028.92,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(568,7503,167,40722,4531,3,57,2,40499.98,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(569,7503,168,40722,4531,3,217,1,33471.06,NULL,'2023-05-18 08:57:14','2023-05-18 09:07:22','2023-05-18 09:07:22'),(570,7503,168,40722,4531,3,68,1,7028.92,NULL,'2023-05-18 08:57:14','2023-05-18 09:07:22','2023-05-18 09:07:22'),(571,7503,168,40722,4531,3,57,2,40499.98,NULL,'2023-05-18 08:57:14','2023-05-18 09:07:22','2023-05-18 09:07:22'),(572,7503,169,40722,4531,3,217,1,5998.61,NULL,'2023-05-18 08:57:14','2023-05-18 09:06:30','2023-05-18 09:06:30'),(573,7503,169,40722,4531,3,68,1,1259.71,NULL,'2023-05-18 08:57:14','2023-05-18 09:06:30','2023-05-18 09:06:30'),(574,7503,169,40722,4531,3,217,1,449.90,NULL,'2023-05-18 08:57:14','2023-05-18 09:06:30','2023-05-18 09:06:30'),(575,7503,169,40722,4531,3,57,2,7708.22,NULL,'2023-05-18 08:57:14','2023-05-18 09:06:30','2023-05-18 09:06:30'),(576,7503,170,40722,4531,3,217,1,3429.60,NULL,'2023-05-18 08:57:14','2023-05-18 09:05:45','2023-05-18 09:05:45'),(577,7503,170,40722,4531,3,68,1,720.22,NULL,'2023-05-18 08:57:14','2023-05-18 09:05:45','2023-05-18 09:05:45'),(578,7503,170,40722,4531,3,217,1,1075.18,NULL,'2023-05-18 08:57:14','2023-05-18 09:05:45','2023-05-18 09:05:45'),(579,7503,170,40722,4531,3,57,2,5225.00,NULL,'2023-05-18 08:57:14','2023-05-18 09:05:45','2023-05-18 09:05:45'),(580,7503,171,40722,4531,3,217,1,78.51,NULL,'2023-05-18 08:57:14','2023-05-18 09:00:07','2023-05-18 09:00:07'),(581,7503,171,40722,4531,3,68,1,16.49,NULL,'2023-05-18 08:57:14','2023-05-18 09:00:07','2023-05-18 09:00:07'),(582,7503,171,40722,4531,3,57,2,95.00,NULL,'2023-05-18 08:57:14','2023-05-18 09:00:07','2023-05-18 09:00:07'),(583,7503,172,40722,4531,3,217,1,197.52,NULL,'2023-05-18 08:57:14','2023-05-18 09:00:17','2023-05-18 09:00:17'),(584,7503,172,40722,4531,3,68,1,41.48,NULL,'2023-05-18 08:57:14','2023-05-18 09:00:17','2023-05-18 09:00:17'),(585,7503,172,40722,4531,3,57,2,239.00,NULL,'2023-05-18 08:57:14','2023-05-18 09:00:17','2023-05-18 09:00:17'),(586,7503,173,40722,4531,3,217,1,56768.19,NULL,'2023-05-18 08:57:14','2023-05-18 09:04:23','2023-05-18 09:04:23'),(587,7503,173,40722,4531,3,68,1,11921.32,NULL,'2023-05-18 08:57:14','2023-05-18 09:04:23','2023-05-18 09:04:23'),(588,7503,173,40722,4531,3,57,2,68689.51,NULL,'2023-05-18 08:57:14','2023-05-18 09:04:23','2023-05-18 09:04:23'),(589,7503,174,40722,4531,3,217,1,1373.55,NULL,'2023-05-18 08:57:14','2023-05-18 08:59:56','2023-05-18 08:59:56'),(590,7503,174,40722,4531,3,68,1,288.45,NULL,'2023-05-18 08:57:14','2023-05-18 08:59:56','2023-05-18 08:59:56'),(591,7503,174,40722,4531,3,57,2,1662.00,NULL,'2023-05-18 08:57:14','2023-05-18 08:59:56','2023-05-18 08:59:56'),(592,7503,175,40722,4531,3,217,1,25066.80,NULL,'2023-05-18 08:57:14','2023-05-18 08:59:47','2023-05-18 08:59:47'),(593,7503,175,40722,4531,3,68,1,5264.03,NULL,'2023-05-18 08:57:14','2023-05-18 08:59:47','2023-05-18 08:59:47'),(594,7503,175,40722,4531,3,57,2,30330.83,NULL,'2023-05-18 08:57:14','2023-05-18 08:59:47','2023-05-18 08:59:47'),(595,7503,176,40722,4531,3,217,1,1239.67,NULL,'2023-05-18 08:57:14','2023-05-18 09:00:36','2023-05-18 09:00:36'),(596,7503,176,40722,4531,3,68,1,260.33,NULL,'2023-05-18 08:57:14','2023-05-18 09:00:36','2023-05-18 09:00:36'),(597,7503,176,40722,4531,3,57,2,1500.00,NULL,'2023-05-18 08:57:14','2023-05-18 09:00:36','2023-05-18 09:00:36'),(598,7503,177,40722,4531,3,217,1,11983.47,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(599,7503,177,40722,4531,3,68,1,2516.53,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(600,7503,177,40722,4531,3,57,2,14500.00,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(601,7503,178,40722,4531,3,217,1,13221.60,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL);
INSERT INTO `balance_libro_details` VALUES (602,7503,178,40722,4531,3,68,1,2776.54,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(603,7503,178,40722,4531,3,57,2,15998.14,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(604,7503,179,40722,4531,3,217,1,689.59,NULL,'2023-05-18 08:57:14','2023-05-18 08:59:39','2023-05-18 08:59:39'),(605,7503,179,40722,4531,3,68,1,72.41,NULL,'2023-05-18 08:57:14','2023-05-18 08:59:39','2023-05-18 08:59:39'),(606,7503,179,40722,4531,3,57,2,762.00,NULL,'2023-05-18 08:57:14','2023-05-18 08:59:39','2023-05-18 08:59:39'),(607,7503,180,40722,4531,3,217,1,75413.22,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(608,7503,180,40722,4531,3,68,1,15836.78,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(609,7503,180,40722,4531,3,57,2,91250.00,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(610,7503,181,40722,4531,3,217,1,8677.69,NULL,'2023-05-18 08:57:14','2023-05-18 08:59:29','2023-05-18 08:59:29'),(611,7503,181,40722,4531,3,68,1,1822.31,NULL,'2023-05-18 08:57:14','2023-05-18 08:59:29','2023-05-18 08:59:29'),(612,7503,181,40722,4531,3,57,2,10500.00,NULL,'2023-05-18 08:57:14','2023-05-18 08:59:29','2023-05-18 08:59:29'),(613,7503,182,40722,4531,3,217,1,56768.19,NULL,'2023-05-18 09:04:23','2023-05-18 09:04:23',NULL),(614,7503,182,40722,4531,3,68,1,11921.32,NULL,'2023-05-18 09:04:23','2023-05-18 09:04:23',NULL),(615,7503,182,40722,4531,3,57,2,68689.51,NULL,'2023-05-18 09:04:23','2023-05-18 09:04:23',NULL),(616,7503,183,40722,4531,3,217,1,3429.60,NULL,'2023-05-18 09:05:45','2023-05-18 09:05:45',NULL),(617,7503,183,40722,4531,3,68,1,720.22,NULL,'2023-05-18 09:05:45','2023-05-18 09:05:45',NULL),(618,7503,183,40722,4531,3,220,1,102.89,NULL,'2023-05-18 09:05:45','2023-05-18 09:05:45',NULL),(619,7503,183,40722,4531,3,221,1,665.18,NULL,'2023-05-18 09:05:45','2023-05-18 09:05:45',NULL),(620,7503,183,40722,4531,3,225,1,204.74,NULL,'2023-05-18 09:05:45','2023-05-18 09:05:45',NULL),(621,7503,183,40722,4531,3,226,1,102.37,NULL,'2023-05-18 09:05:45','2023-05-18 09:05:45',NULL),(622,7503,183,40722,4531,3,57,2,5225.00,NULL,'2023-05-18 09:05:45','2023-05-18 09:05:45',NULL),(623,7503,184,40722,4531,3,217,1,5998.61,NULL,'2023-05-18 09:06:30','2023-05-18 09:06:30',NULL),(624,7503,184,40722,4531,3,68,1,1259.71,NULL,'2023-05-18 09:06:30','2023-05-18 09:06:30',NULL),(625,7503,184,40722,4531,3,225,1,299.93,NULL,'2023-05-18 09:06:30','2023-05-18 09:06:30',NULL),(626,7503,184,40722,4531,3,226,1,149.97,NULL,'2023-05-18 09:06:30','2023-05-18 09:06:30',NULL),(627,7503,184,40722,4531,3,57,2,7708.22,NULL,'2023-05-18 09:06:30','2023-05-18 09:06:30',NULL),(628,7503,185,40722,4531,3,217,1,33471.06,NULL,'2023-05-18 09:07:22','2023-05-18 09:07:22',NULL),(629,7503,185,40722,4531,3,68,1,7028.92,NULL,'2023-05-18 09:07:22','2023-05-18 09:07:22',NULL),(630,7503,185,40722,4531,3,57,2,40499.98,NULL,'2023-05-18 09:07:22','2023-05-18 09:07:22',NULL),(631,7503,186,40722,4531,3,217,1,35992.04,NULL,'2023-05-18 09:10:46','2023-05-18 09:10:46',NULL),(632,7503,186,40722,4531,3,68,1,7558.33,NULL,'2023-05-18 09:10:46','2023-05-18 09:10:46',NULL),(633,7503,186,40722,4531,3,225,1,1799.60,NULL,'2023-05-18 09:10:46','2023-05-18 09:10:46',NULL),(634,7503,186,40722,4531,3,226,1,899.80,NULL,'2023-05-18 09:10:46','2023-05-18 09:10:46',NULL),(635,7503,186,40722,4531,3,57,2,46249.77,NULL,'2023-05-18 09:10:46','2023-05-18 09:10:46',NULL),(636,7503,187,40722,4531,3,217,1,1806460.00,NULL,'2023-05-18 09:11:34','2023-05-18 09:11:34',NULL),(637,7503,187,40722,4531,3,68,1,379356.60,NULL,'2023-05-18 09:11:34','2023-05-18 09:11:34',NULL),(638,7503,187,40722,4531,3,57,2,2185816.60,NULL,'2023-05-18 09:11:34','2023-05-18 09:11:34',NULL),(639,7503,188,40722,4531,3,217,1,4799.00,NULL,'2023-05-18 09:12:08','2023-05-18 09:12:08',NULL),(640,7503,188,40722,4531,3,68,1,1007.79,NULL,'2023-05-18 09:12:08','2023-05-18 09:12:08',NULL),(641,7503,188,40722,4531,3,225,1,239.95,NULL,'2023-05-18 09:12:08','2023-05-18 09:12:08',NULL);
INSERT INTO `balance_libro_details` VALUES (642,7503,188,40722,4531,3,57,2,6046.74,NULL,'2023-05-18 09:12:08','2023-05-18 09:12:08',NULL),(643,7503,189,40722,4531,3,217,1,106347.60,NULL,'2023-05-18 09:12:32','2023-05-18 09:12:32',NULL),(644,7503,189,40722,4531,3,68,1,22333.00,NULL,'2023-05-18 09:12:32','2023-05-18 09:12:32',NULL),(645,7503,189,40722,4531,3,57,2,128680.60,NULL,'2023-05-18 09:12:32','2023-05-18 09:12:32',NULL),(646,7503,190,40722,4531,3,217,1,5689.26,NULL,'2023-05-18 09:12:54','2023-05-18 09:12:54',NULL),(647,7503,190,40722,4531,3,68,1,1194.74,NULL,'2023-05-18 09:12:54','2023-05-18 09:12:54',NULL),(648,7503,190,40722,4531,3,57,2,6884.00,NULL,'2023-05-18 09:12:54','2023-05-18 09:12:54',NULL),(649,7503,191,40722,4531,3,217,1,11765.61,NULL,'2023-05-18 09:13:12','2023-05-18 09:13:12',NULL),(650,7503,191,40722,4531,3,68,1,1235.39,NULL,'2023-05-18 09:13:12','2023-05-18 09:13:12',NULL),(651,7503,191,40722,4531,3,57,2,13001.00,NULL,'2023-05-18 09:13:12','2023-05-18 09:13:12',NULL),(652,7503,192,40722,4531,3,217,1,538.94,NULL,'2023-05-18 09:16:47','2023-05-18 09:23:56','2023-05-18 09:23:56'),(653,7503,192,40722,4531,3,68,1,113.18,NULL,'2023-05-18 09:16:47','2023-05-18 09:23:56','2023-05-18 09:23:56'),(654,7503,192,40722,4531,3,57,2,652.12,NULL,'2023-05-18 09:16:47','2023-05-18 09:23:56','2023-05-18 09:23:56'),(655,7503,193,40722,4531,3,217,1,52647.10,NULL,'2023-05-18 09:18:51','2023-05-18 09:18:51',NULL),(656,7503,193,40722,4531,3,68,1,5527.95,NULL,'2023-05-18 09:18:51','2023-05-18 09:18:51',NULL),(657,7503,193,40722,4531,3,221,1,3266.72,NULL,'2023-05-18 09:18:51','2023-05-18 09:18:51',NULL),(658,7503,193,40722,4531,3,57,2,61441.77,NULL,'2023-05-18 09:18:51','2023-05-18 09:18:51',NULL),(659,7503,194,40722,4531,3,217,1,10928.49,NULL,'2023-05-18 09:21:27','2023-05-18 09:21:27',NULL),(660,7503,194,40722,4531,3,68,1,1147.49,NULL,'2023-05-18 09:21:27','2023-05-18 09:21:27',NULL),(661,7503,194,40722,4531,3,221,1,0.02,NULL,'2023-05-18 09:21:27','2023-05-18 09:21:27',NULL),(662,7503,194,40722,4531,3,57,2,12076.00,NULL,'2023-05-18 09:21:27','2023-05-18 09:21:27',NULL),(663,7503,195,40722,4531,3,217,1,5246.07,NULL,'2023-05-18 09:23:12','2023-05-18 09:23:12',NULL),(664,7503,195,40722,4531,3,68,1,1101.67,NULL,'2023-05-18 09:23:12','2023-05-18 09:23:12',NULL),(665,7503,195,40722,4531,3,225,1,262.30,NULL,'2023-05-18 09:23:12','2023-05-18 09:23:12',NULL),(666,7503,195,40722,4531,3,226,1,131.15,NULL,'2023-05-18 09:23:12','2023-05-18 09:23:12',NULL),(667,7503,195,40722,4531,3,57,2,6741.19,NULL,'2023-05-18 09:23:12','2023-05-18 09:23:12',NULL),(668,7503,196,40722,4531,3,217,1,53894.80,NULL,'2023-05-18 09:23:56','2023-05-18 09:23:56',NULL),(669,7503,196,40722,4531,3,68,1,5658.95,NULL,'2023-05-18 09:23:56','2023-05-18 09:23:56',NULL),(670,7503,196,40722,4531,3,221,1,3222.05,NULL,'2023-05-18 09:23:56','2023-05-18 09:23:56',NULL),(671,7503,196,40722,4531,3,57,2,62775.80,NULL,'2023-05-18 09:23:56','2023-05-18 09:23:56',NULL),(672,7503,197,40722,4531,15,67,1,1254896.38,NULL,'2023-05-18 09:25:00','2023-05-18 09:25:00',NULL),(673,7503,197,40722,4531,15,68,2,476051.95,NULL,'2023-05-18 09:25:00','2023-05-18 09:25:00',NULL),(674,7503,197,40722,4531,15,220,2,102.89,NULL,'2023-05-18 09:25:00','2023-05-18 09:25:00',NULL),(675,7503,197,40722,4531,15,74,2,778741.54,NULL,'2023-05-18 09:25:00','2023-05-18 09:25:00',NULL);
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bind_apibank_credentials`
--

DROP TABLE IF EXISTS `bind_apibank_credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bind_apibank_credentials` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'Usuario que configuró las credenciales',
  `person_id` int(10) unsigned NOT NULL COMMENT 'Empresa',
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL COMMENT 'Cuenta de tesorería vinculada',
  `env` enum('sandbox','prod') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Ambiente: sandbox o producción',
  `username` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Usuario de Bind APIBank',
  `password` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Password encriptado con Laravel Crypt',
  `cert_path` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Path absoluto al certificado SSL del cliente (.crt)',
  `key_path` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Path absoluto a la llave privada SSL (.key)',
  `key_password` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Password de la llave privada (si está protegida con password)',
  `jwt_token` text COLLATE utf8mb4_unicode_ci COMMENT 'Token JWT actual',
  `jwt_expires_at` datetime DEFAULT NULL COMMENT 'Fecha de expiración del token JWT',
  `bind_account_id` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'ID de cuenta en Bind (obtenido al hacer login)',
  `active` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Credencial activa?',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_bind_apibank_cred_person` (`person_id`),
  KEY `idx_bind_apibank_cred_cuenta` (`cta_cte_tesoreria_cuenta_id`),
  KEY `idx_bind_apibank_cred_active` (`active`),
  KEY `idx_bind_apibank_cred_bind_acc` (`bind_account_id`),
  KEY `idx_bind_apibank_cred_person_active` (`person_id`,`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bind_apibank_credentials`
--

LOCK TABLES `bind_apibank_credentials` WRITE;
/*!40000 ALTER TABLE `bind_apibank_credentials` DISABLE KEYS */;
/*!40000 ALTER TABLE `bind_apibank_credentials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bind_apibank_movements`
--

DROP TABLE IF EXISTS `bind_apibank_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bind_apibank_movements` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'Usuario que ejecutó la sincronización',
  `person_id` int(10) unsigned NOT NULL COMMENT 'Empresa',
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL COMMENT 'Cuenta de tesorería',
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL COMMENT 'Movimiento en tesorería (vinculación bidireccional)',
  `bind_movement_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'ID único del movimiento en Bind',
  `type` enum('in','out','fee') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Tipo: in=transferencia entrante, out=transferencia saliente, fee=comisión',
  `status` enum('settled','pending','failed') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Estado del movimiento',
  `amount` decimal(15,2) NOT NULL COMMENT 'Monto del movimiento',
  `currency` char(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ARS' COMMENT 'Moneda (ARS, USD)',
  `from_cbu_cvu` varchar(22) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'CBU/CVU origen',
  `from_titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Titular de la cuenta origen',
  `from_cuit` varchar(13) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'CUIT del titular origen',
  `to_cbu_cvu` varchar(22) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'CBU/CVU destino',
  `to_titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Titular de la cuenta destino',
  `to_cuit` varchar(13) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'CUIT del titular destino',
  `concept` text COLLATE utf8mb4_unicode_ci COMMENT 'Concepto/descripción del movimiento',
  `reference` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Referencia del movimiento',
  `executed_at` datetime DEFAULT NULL COMMENT 'Fecha de ejecución del movimiento en Bind',
  `raw_response` json DEFAULT NULL COMMENT 'Respuesta completa de la API de Bind (para auditoría)',
  `is_synced_to_treasury` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ya sincronizado a tesorería?',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_bind_apibank_mov_bind_id` (`bind_movement_id`),
  KEY `idx_bind_apibank_mov_person` (`person_id`),
  KEY `idx_bind_apibank_mov_cuenta` (`cta_cte_tesoreria_cuenta_id`),
  KEY `idx_bind_apibank_mov_tesoreria` (`cta_cte_tesoreria_id`),
  KEY `idx_bind_apibank_mov_synced` (`is_synced_to_treasury`),
  KEY `idx_bind_apibank_mov_executed` (`executed_at`),
  KEY `idx_bind_apibank_mov_type_status` (`type`,`status`),
  KEY `idx_bind_apibank_mov_person_synced` (`person_id`,`is_synced_to_treasury`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bind_apibank_movements`
--

LOCK TABLES `bind_apibank_movements` WRITE;
/*!40000 ALTER TABLE `bind_apibank_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `bind_apibank_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bind_apibank_sync_logs`
--

DROP TABLE IF EXISTS `bind_apibank_sync_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bind_apibank_sync_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'Usuario que ejecutó la sincronización',
  `person_id` int(10) unsigned NOT NULL COMMENT 'Empresa',
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL COMMENT 'Cuenta sincronizada',
  `sync_type` enum('movements','balance','transfers','webhook') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Tipo de sincronización: movements=movimientos, balance=saldo, transfers=transferencias, webhook=desde webhook',
  `last_sync_at` datetime NOT NULL COMMENT 'Fecha/hora de la sincronización',
  `records_synced` int(11) NOT NULL DEFAULT '0' COMMENT 'Cantidad de registros sincronizados',
  `status` enum('success','error') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Estado de la sincronización',
  `error_message` text COLLATE utf8mb4_unicode_ci COMMENT 'Mensaje de error (si status=error)',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_bind_apibank_sync_person` (`person_id`),
  KEY `idx_bind_apibank_sync_cuenta` (`cta_cte_tesoreria_cuenta_id`),
  KEY `idx_bind_apibank_sync_type` (`sync_type`),
  KEY `idx_bind_apibank_sync_last` (`last_sync_at`),
  KEY `idx_bind_apibank_sync_type_status` (`sync_type`,`status`),
  KEY `idx_bind_apibank_sync_person_type` (`person_id`,`sync_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bind_apibank_sync_logs`
--

LOCK TABLES `bind_apibank_sync_logs` WRITE;
/*!40000 ALTER TABLE `bind_apibank_sync_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bind_apibank_sync_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bind_apibank_transfers`
--

DROP TABLE IF EXISTS `bind_apibank_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bind_apibank_transfers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'Usuario que ejecutó la transferencia',
  `person_id` int(10) unsigned NOT NULL COMMENT 'Empresa',
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL COMMENT 'Cuenta origen de la transferencia',
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL COMMENT 'Movimiento en tesorería resultante (vinculación)',
  `bind_transfer_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'ID de transferencia en Bind',
  `numero_operacion` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Número de operación bancaria',
  `cbu_origin` varchar(22) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'CBU origen (nuestra cuenta)',
  `cbu_destination` varchar(22) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'CBU destino',
  `alias_destination` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Alias destino (alternativo a CBU)',
  `amount` decimal(15,2) NOT NULL COMMENT 'Monto de la transferencia',
  `currency` char(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ARS' COMMENT 'Moneda (ARS, USD)',
  `concept` text COLLATE utf8mb4_unicode_ci COMMENT 'Concepto de la transferencia',
  `reference` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Referencia interna (ej: FAC-001-1234)',
  `type` enum('INMEDIATA','PROGRAMADA') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'INMEDIATA' COMMENT 'Tipo de transferencia',
  `status` enum('PENDIENTE','APROBADA','RECHAZADA','CANCELADA') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'PENDIENTE' COMMENT 'Estado de la transferencia',
  `scheduled_at` datetime DEFAULT NULL COMMENT 'Fecha programada (si type=PROGRAMADA)',
  `executed_at` datetime DEFAULT NULL COMMENT 'Fecha de ejecución real',
  `comision` decimal(15,2) DEFAULT '0.00' COMMENT 'Comisión cobrada por Bind',
  `iva_comision` decimal(15,2) DEFAULT '0.00' COMMENT 'IVA de la comisión',
  `total_debitado` decimal(15,2) DEFAULT NULL COMMENT 'Total debitado (monto + comisión + IVA)',
  `raw_response` json DEFAULT NULL COMMENT 'Respuesta completa de la API de Bind',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_bind_apibank_trf_person` (`person_id`),
  KEY `idx_bind_apibank_trf_cuenta` (`cta_cte_tesoreria_cuenta_id`),
  KEY `idx_bind_apibank_trf_tesoreria` (`cta_cte_tesoreria_id`),
  KEY `idx_bind_apibank_trf_status` (`status`),
  KEY `idx_bind_apibank_trf_bind_id` (`bind_transfer_id`),
  KEY `idx_bind_apibank_trf_executed` (`executed_at`),
  KEY `idx_bind_apibank_trf_type_status` (`type`,`status`),
  KEY `idx_bind_apibank_trf_person_status` (`person_id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bind_apibank_transfers`
--

LOCK TABLES `bind_apibank_transfers` WRITE;
/*!40000 ALTER TABLE `bind_apibank_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `bind_apibank_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2022-08-05 09:30:06',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2022-08-05 09:30:06',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2022-08-05 09:30:06',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-08-05 09:30:06','2022-08-05 09:30:06',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-08-05 09:30:18','2022-08-05 09:30:18',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-08-05 09:30:18','2022-08-05 09:30:18',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-08-05 09:30:18','2022-08-05 09:30:18',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-08-05 09:30:18','2022-08-05 09:30:18',NULL),(11,2021,6000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-08-05 09:30:29','2022-08-05 09:30:29',NULL),(12,2021,6000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-08-05 09:30:29','2022-08-05 09:30:29',NULL),(13,2021,6000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-08-05 09:30:29','2022-08-05 09:30:29',NULL),(14,2021,6000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-08-05 09:30:29','2022-08-05 09:30:29',NULL),(15,2022,11282141.08,0.00,5641070.54,0.00,0.0050,0.00,'2023-05-30 15:03:19','2023-05-30 15:03:19',NULL),(16,2022,11282141.08,5641070.54,12222319.51,28205.35,0.0075,5641070.54,'2023-05-30 15:03:19','2023-05-30 15:03:19',NULL),(17,2022,11282141.08,12222319.51,33846423.25,77564.72,0.0100,12222319.51,'2023-05-30 15:03:19','2023-05-30 15:03:19',NULL),(18,2022,11282141.08,33846423.25,188035684.71,293802.76,0.0125,33846423.25,'2023-05-30 15:03:19','2023-05-30 15:03:19',NULL),(19,2022,11282141.08,188035684.71,564107054.14,2221171.53,0.0150,188035684.71,'2023-05-30 15:03:19','2023-05-30 15:03:19',NULL),(20,2022,11282141.08,564107054.14,999999999999.00,7682242.07,0.0175,564107054.14,'2023-05-30 15:03:19','2023-05-30 15:03:19',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar`
--

DROP TABLE IF EXISTS `calendar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `ws_telefono_id` bigint(20) unsigned DEFAULT NULL,
  `inv_ot_id` bigint(20) unsigned DEFAULT NULL,
  `calendar_tur_dispo_dato_id` bigint(20) unsigned DEFAULT NULL,
  `title` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion_text` longtext COLLATE utf8mb4_unicode_ci,
  `url` text COLLATE utf8mb4_unicode_ci,
  `start` datetime DEFAULT NULL,
  `startEditable` tinyint(1) NOT NULL DEFAULT '1',
  `startStr` text COLLATE utf8mb4_unicode_ci,
  `end` datetime DEFAULT NULL,
  `endStr` text COLLATE utf8mb4_unicode_ci,
  `allDay` tinyint(1) NOT NULL DEFAULT '1',
  `allow` tinyint(1) DEFAULT NULL,
  `backgroundColor` text COLLATE utf8mb4_unicode_ci,
  `borderColor` text COLLATE utf8mb4_unicode_ci,
  `classNames` longtext COLLATE utf8mb4_unicode_ci,
  `constraint` text COLLATE utf8mb4_unicode_ci,
  `display` text COLLATE utf8mb4_unicode_ci,
  `durationEditable` tinyint(1) NOT NULL DEFAULT '1',
  `extendedProps` longtext COLLATE utf8mb4_unicode_ci,
  `groupId` text COLLATE utf8mb4_unicode_ci,
  `overlap` text COLLATE utf8mb4_unicode_ci,
  `source` longtext COLLATE utf8mb4_unicode_ci,
  `textColor` text COLLATE utf8mb4_unicode_ci,
  `is_impuesto_from_taxes` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_person_id_foreign` (`person_id`),
  KEY `calendar_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `calendar_ws_telefono_id_foreign` (`ws_telefono_id`),
  KEY `calendar_calendar_tur_dispo_dato_id_foreign` (`calendar_tur_dispo_dato_id`),
  KEY `calendar_inv_ot_id_foreign` (`inv_ot_id`),
  CONSTRAINT `calendar_calendar_tur_dispo_dato_id_foreign` FOREIGN KEY (`calendar_tur_dispo_dato_id`) REFERENCES `calendar_tur_dispo_datos` (`id`),
  CONSTRAINT `calendar_inv_ot_id_foreign` FOREIGN KEY (`inv_ot_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `calendar_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_ws_telefono_id_foreign` FOREIGN KEY (`ws_telefono_id`) REFERENCES `ws_telefonos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar`
--

LOCK TABLES `calendar` WRITE;
/*!40000 ALTER TABLE `calendar` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_emails_telefonos`
--

DROP TABLE IF EXISTS `calendar_emails_telefonos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_emails_telefonos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci,
  `celular` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_emails_telefonos_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_emails_telefonos_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_emails_telefonos`
--

LOCK TABLES `calendar_emails_telefonos` WRITE;
/*!40000 ALTER TABLE `calendar_emails_telefonos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_emails_telefonos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_files`
--

DROP TABLE IF EXISTS `calendar_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_files_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_files_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_files`
--

LOCK TABLES `calendar_files` WRITE;
/*!40000 ALTER TABLE `calendar_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1`
--

DROP TABLE IF EXISTS `calendar_niv_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_1_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1`
--

LOCK TABLES `calendar_niv_1` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1_2`
--

DROP TABLE IF EXISTS `calendar_niv_1_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_2_person_id_foreign` (`person_id`),
  KEY `calendar_niv_1_2_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_niv_1_2_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_niv_1_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1_2`
--

LOCK TABLES `calendar_niv_1_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_2`
--

DROP TABLE IF EXISTS `calendar_niv_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_2_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_2`
--

LOCK TABLES `calendar_niv_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_notificaciones`
--

DROP TABLE IF EXISTS `calendar_notificaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_notificaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `start` datetime DEFAULT NULL,
  `tipo_de_notificacion_id` int(10) unsigned NOT NULL,
  `cantidad` int(10) unsigned NOT NULL,
  `unidad_de_tiempo_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_notificaciones_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_notificaciones_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_notificaciones`
--

LOCK TABLES `calendar_notificaciones` WRITE;
/*!40000 ALTER TABLE `calendar_notificaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_notificaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo`
--

DROP TABLE IF EXISTS `calendar_tur_dispo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `dia_hora` datetime(5) DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00:30',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_tur_dispo_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_tur_dispo_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo`
--

LOCK TABLES `calendar_tur_dispo` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo_datos`
--

DROP TABLE IF EXISTS `calendar_tur_dispo_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_tur_dispo_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre_ape` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_datos_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` (`calendar_tur_dispo_id`),
  CONSTRAINT `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` FOREIGN KEY (`calendar_tur_dispo_id`) REFERENCES `calendar_tur_dispo` (`id`),
  CONSTRAINT `calendar_tur_dispo_datos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo_datos`
--

LOCK TABLES `calendar_tur_dispo_datos` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1850.00,11100.00,370000.00,30,3300,NULL,'1',NULL,'2022-10-23 23:32:43',NULL),(2,'B',2750.00,16500.00,550000.00,45,5000,NULL,'1',NULL,'2022-10-23 23:32:43',NULL),(3,'C',3850.00,23100.00,770000.00,60,6700,NULL,'1',NULL,'2022-10-23 23:32:43',NULL),(4,'D',5300.00,31800.00,1060000.00,85,10000,NULL,'1',NULL,'2022-10-23 23:32:43',NULL),(5,'E',7000.00,42000.00,1400000.00,110,13000,NULL,'1',NULL,'2022-10-23 23:32:43',NULL),(6,'F',8750.00,52500.00,1750000.00,150,16500,NULL,'1',NULL,'2022-10-23 23:32:43',NULL),(7,'G',10500.00,63000.00,2100000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:32:43',NULL),(8,'H',13000.00,78000.00,2600000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:32:43',NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',8992597.87,749383.16,'No Excluida','0',30,3330,2091301.83,4182.60,4182.60,13663.17,19239.97,37085.74,37085.74,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',13175201.52,1097933.46,'No Excluida','0',45,5000,2091301.83,7946.95,7946.95,15029.49,19239.97,42216.41,42216.41,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',18473166.15,1539430.51,'No Excluida','0',60,6700,2858112.50,13663.17,12547.81,16532.44,19239.97,49435.58,48320.22,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',22934610.05,1911217.50,'No Excluida','0',85,10000,2858112.50,22307.22,20773.60,18185.68,22864.90,63357.80,61824.18,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',26977793.60,2248149.47,'No Excluida','0',110,13000,3624923.17,41826.04,33181.99,20004.25,27884.02,89714.31,81070.26,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',33809379.57,2817448.30,'No Excluida','0',150,16500,3624923.17,58835.29,43220.24,22004.67,32066.63,112906.59,97291.54,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',40431835.35,3369319.61,'No Excluida','0',200,20000,4322023.77,107074.65,53537.32,30806.54,34576.19,172457.38,118920.05,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',61344853.64,5112071.14,'No Excluida','0',200,20000,6273905.49,306724.27,153362.13,43129.16,41547.19,391400.62,238038.48,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',68664410.05,5722034.17,'Venta de Bs Muebles','0',200,20000,6273905.49,609963.03,243985.21,60380.82,51306.61,721650.46,355672.64,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',78632948.76,6552745.73,'Venta de Bs Muebles','0',200,20000,6273905.49,731955.63,292782.26,84533.15,57580.51,874069.29,434895.92,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',94805682.90,7900473.58,'Venta de Bs Muebles','0',200,20000,6273905.49,1024737.89,341579.30,118346.41,65806.30,1208890.60,525732.01,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',1414762.00,117896.00,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL),(13,'A Exento',1414762.00,117896.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2192.15,3061.75,5253.90,5253.90,'',NULL,NULL,'0',NULL,NULL,NULL),(14,'B Exento',2103025.00,175252.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2411.36,3061.75,5473.11,5473.11,'',NULL,NULL,'0',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `chequeras_tipos`
--

DROP TABLE IF EXISTS `chequeras_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chequeras_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chequeras_tipos`
--

LOCK TABLES `chequeras_tipos` WRITE;
/*!40000 ALTER TABLE `chequeras_tipos` DISABLE KEYS */;
INSERT INTO `chequeras_tipos` VALUES (1,NULL,'Fisica',1,NULL,NULL,NULL),(2,NULL,'Electronica',1,NULL,NULL,NULL),(3,NULL,'Transferencias',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `chequeras_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cheques_transfer_emitidas`
--

DROP TABLE IF EXISTS `cheques_transfer_emitidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cheques_transfer_emitidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_cheq_id` int(10) unsigned NOT NULL,
  `fecha_emision` date NOT NULL,
  `fecha_cobro` date NOT NULL,
  `numero_cheque` int(11) NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cheques_transfer_emitidas_person_id_foreign` (`person_id`),
  KEY `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cte_tes_ban_che_id_foreign` (`cta_cte_tesoreria_banco_cheq_id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cte_tes_ban_che_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_cheq_id`) REFERENCES `cta_cte_tesoreria_banco_cheq` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cheques_transfer_emitidas`
--

LOCK TABLES `cheques_transfer_emitidas` WRITE;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,NULL,'Clave Fiscal',NULL,NULL,NULL),(2,NULL,'Clave Ciudad',NULL,NULL,NULL),(3,NULL,'Clave ARBA',NULL,NULL,NULL),(4,NULL,'Clave ANSES',NULL,NULL,NULL),(5,NULL,'Catedral',NULL,NULL,NULL),(6,NULL,'CEMIBA',NULL,NULL,NULL),(7,NULL,'COMPRA ARG',NULL,NULL,NULL),(8,NULL,'Consejo Ciencias Economicas',NULL,NULL,NULL),(9,NULL,'Correo',NULL,NULL,NULL),(10,NULL,'CUR',NULL,NULL,NULL),(11,NULL,'Firma Digital',NULL,NULL,NULL),(12,NULL,'Interbanking',NULL,NULL,NULL),(13,NULL,'Banco Citibank',NULL,NULL,NULL),(14,NULL,'Banco Ciudad',NULL,NULL,NULL),(15,NULL,'Banco Frances',NULL,NULL,NULL),(16,NULL,'Banco Galicia',NULL,NULL,NULL),(17,NULL,'Banco HSBC',NULL,NULL,NULL),(18,NULL,'Banco Itau',NULL,NULL,NULL),(19,NULL,'Banco Nacion',NULL,NULL,NULL),(20,NULL,'Banco Macro',NULL,NULL,NULL),(21,NULL,'Banco Patagonia',NULL,NULL,NULL),(22,NULL,'Banco Provincia',NULL,NULL,NULL),(23,NULL,'Banco Santander',NULL,NULL,NULL),(24,NULL,'Banco Supervielle',NULL,NULL,NULL),(25,NULL,'Seguridad e Higiene',NULL,NULL,NULL),(26,NULL,'Sindicato - ANSES',NULL,NULL,NULL),(27,NULL,'Sindicato - AOT',NULL,NULL,NULL),(28,NULL,'Sindicato - ATSA',NULL,NULL,NULL),(29,NULL,'Sindicato - Camioneros',NULL,NULL,NULL),(30,NULL,'Sindicato - Guinchero',NULL,NULL,NULL),(31,NULL,'Sindicato - IERIC',NULL,NULL,NULL),(32,NULL,'Sindicato - La Estrella',NULL,NULL,NULL),(33,NULL,'Sindicato - Nemesis',NULL,NULL,NULL),(34,NULL,'Sindicato - Pasta',NULL,NULL,NULL),(35,NULL,'Sindicato - SEC',NULL,NULL,NULL),(36,NULL,'Sindicato - SICOP',NULL,NULL,NULL),(37,NULL,'Sindicato - SOCAYA',NULL,NULL,NULL),(38,NULL,'Sindicato - UTHGRA',NULL,NULL,NULL),(39,NULL,'Sindicato - INACAP',NULL,NULL,NULL),(40,NULL,'Sindicato - Otro',NULL,NULL,NULL),(41,NULL,'Otra',NULL,NULL,NULL),(42,NULL,'Prisma - Firma Digital',NULL,NULL,NULL),(43,NULL,'Sindicato - FATSA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
INSERT INTO `claves_details` VALUES (10,7503,NULL,'Estudio5623',NULL,1,40723,1,'2025-07-07 11:21:24','2025-07-07 11:21:24',NULL);
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2022-08-05 09:30:19','2022-08-05 09:30:19',NULL),(2,NULL,'Articulo 6',6,0,'2022-08-05 09:30:19','2022-08-05 09:30:19',NULL),(3,NULL,'Articulo 7',7,0,'2022-08-05 09:30:19','2022-08-05 09:30:19',NULL),(4,NULL,'Articulo 8',8,0,'2022-08-05 09:30:19','2022-08-05 09:30:19',NULL),(5,NULL,'Articulo 9',9,0,'2022-08-05 09:30:19','2022-08-05 09:30:19',NULL),(6,NULL,'Articulo 10',10,0,'2022-08-05 09:30:19','2022-08-05 09:30:19',NULL),(7,NULL,'Articulo 11',11,0,'2022-08-05 09:30:19','2022-08-05 09:30:19',NULL),(8,NULL,'Articulo 12',12,0,'2022-08-05 09:30:19','2022-08-05 09:30:19',NULL),(9,NULL,'Articulo 13',13,0,'2022-08-05 09:30:19','2022-08-05 09:30:19',NULL),(10,NULL,'Articulo 14',14,1,'2022-08-05 09:30:19','2022-08-05 09:30:19',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores`
--

DROP TABLE IF EXISTS `cobradores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores`
--

LOCK TABLES `cobradores` WRITE;
/*!40000 ALTER TABLE `cobradores` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_datos`
--

DROP TABLE IF EXISTS `cobradores_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `url_panel` longtext COLLATE utf8mb4_unicode_ci,
  `usuario` text COLLATE utf8mb4_unicode_ci,
  `clave` text COLLATE utf8mb4_unicode_ci,
  `numero_de_soporte` text COLLATE utf8mb4_unicode_ci,
  `inicial_create_user` text COLLATE utf8mb4_unicode_ci,
  `imp_min_p_retirar` int(11) DEFAULT NULL,
  `secret_recarga` text COLLATE utf8mb4_unicode_ci,
  `secret_on_off` text COLLATE utf8mb4_unicode_ci,
  `clave_new_user` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_datos_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_datos_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_datos`
--

LOCK TABLES `cobradores_datos` WRITE;
/*!40000 ALTER TABLE `cobradores_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_metodos`
--

DROP TABLE IF EXISTS `cobradores_metodos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_metodos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cobradores_metodos_descripcion_unique` (`descripcion`),
  KEY `cobradores_metodos_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_metodos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_metodos`
--

LOCK TABLES `cobradores_metodos` WRITE;
/*!40000 ALTER TABLE `cobradores_metodos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_metodos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_on_off`
--

DROP TABLE IF EXISTS `cobradores_on_off`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_on_off` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `on_off` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_on_off_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_on_off_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_on_off`
--

LOCK TABLES `cobradores_on_off` WRITE;
/*!40000 ALTER TABLE `cobradores_on_off` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_on_off` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conciliaciones`
--

DROP TABLE IF EXISTS `conciliaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conciliaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `fecha` datetime NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_conciliado` decimal(13,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conciliaciones_person_id_foreign` (`person_id`),
  CONSTRAINT `conciliaciones_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conciliaciones`
--

LOCK TABLES `conciliaciones` WRITE;
/*!40000 ALTER TABLE `conciliaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `conciliaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conciliaciones_details`
--

DROP TABLE IF EXISTS `conciliaciones_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conciliaciones_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conciliacion_id` bigint(20) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conciliaciones_details_person_id_foreign` (`person_id`),
  KEY `conciliaciones_details_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  CONSTRAINT `conciliaciones_details_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `conciliaciones_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conciliaciones_details`
--

LOCK TABLES `conciliaciones_details` WRITE;
/*!40000 ALTER TABLE `conciliaciones_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `conciliaciones_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condicion_frente_al_iva`
--

DROP TABLE IF EXISTS `condicion_frente_al_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condicion_frente_al_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo_afip` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_comprobantes_a` tinyint(1) NOT NULL DEFAULT '0',
  `show_comprobantes_b` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condicion_frente_al_iva`
--

LOCK TABLES `condicion_frente_al_iva` WRITE;
/*!40000 ALTER TABLE `condicion_frente_al_iva` DISABLE KEYS */;
INSERT INTO `condicion_frente_al_iva` VALUES (1,NULL,1,'IVA Responsable Inscripto',1,0,1,NULL,NULL,NULL),(2,NULL,2,'IVA Responsable no Inscripto',0,0,1,NULL,'2025-02-11 16:32:24','2025-02-11 16:32:24'),(3,NULL,3,'IVA no Responsable',0,0,1,NULL,'2025-02-11 16:32:24','2025-02-11 16:32:24'),(4,NULL,4,'IVA Sujeto Exento',0,1,1,NULL,NULL,NULL),(5,NULL,5,'Consumidor Final',0,1,1,NULL,NULL,NULL),(6,NULL,6,'Responsable Monotributo',1,0,1,NULL,NULL,NULL),(7,NULL,7,'Sujeto no Categorizado',0,1,1,NULL,NULL,NULL),(8,NULL,8,'Proveedor del Exterior',0,1,1,NULL,NULL,NULL),(9,NULL,9,'Cliente del Exterior',0,1,1,NULL,NULL,NULL),(10,NULL,10,'IVA Liberado – Ley Nº 19.640',0,1,1,NULL,NULL,NULL),(11,NULL,11,'IVA Responsable Inscripto – Agente de Percepción',0,0,1,NULL,'2025-02-11 16:32:24','2025-02-11 16:32:24'),(12,NULL,12,'Pequeño Contribuyente Eventual',0,0,1,NULL,'2025-02-11 16:32:24','2025-02-11 16:32:24'),(13,NULL,13,'Monotributista Social',1,0,1,NULL,NULL,NULL),(14,NULL,14,'Pequeño Contribuyente Eventual Social',0,0,1,NULL,'2025-02-11 16:32:24','2025-02-11 16:32:24'),(15,NULL,15,'IVA No Alcanzado',0,1,1,NULL,'2025-02-11 19:32:24',NULL),(16,NULL,NULL,'Monotributista Trabajador Independiente Promovido',1,0,1,NULL,'2025-02-11 16:32:24','2025-02-11 16:32:24');
/*!40000 ALTER TABLE `condicion_frente_al_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones_venta`
--

LOCK TABLES `condiciones_venta` WRITE;
/*!40000 ALTER TABLE `condiciones_venta` DISABLE KEYS */;
INSERT INTO `condiciones_venta` VALUES (1,'Contado',NULL,NULL),(2,'Tarjeta de Debito',NULL,NULL),(3,'Tarjeta de Credito',NULL,NULL),(4,'Cuenta Corriente',NULL,NULL),(5,'Cheque',NULL,NULL),(6,'Ticket',NULL,NULL),(7,'Transferencia',NULL,NULL),(8,'Otra',NULL,NULL);
/*!40000 ALTER TABLE `condiciones_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas`
--

DROP TABLE IF EXISTS `consultas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas`
--

LOCK TABLES `consultas` WRITE;
/*!40000 ALTER TABLE `consultas` DISABLE KEYS */;
INSERT INTO `consultas` VALUES (1,NULL,'Estado Liquidaciones',1,NULL,NULL,NULL),(2,NULL,'Consumo',1,NULL,NULL,NULL),(3,NULL,'Resultado Liquidacion Hijas',1,'2023-03-12 23:42:08','2023-03-12 23:42:08',NULL),(4,NULL,'Tablero Control',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `consultas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas_aux`
--

DROP TABLE IF EXISTS `consultas_aux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas_aux` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `consulta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `estado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consultas_aux_consulta_id_foreign` (`consulta_id`),
  KEY `consultas_aux_person_id_foreign` (`person_id`),
  CONSTRAINT `consultas_aux_consulta_id_foreign` FOREIGN KEY (`consulta_id`) REFERENCES `consultas` (`id`),
  CONSTRAINT `consultas_aux_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas_aux`
--

LOCK TABLES `consultas_aux` WRITE;
/*!40000 ALTER TABLE `consultas_aux` DISABLE KEYS */;
INSERT INTO `consultas_aux` VALUES (1,NULL,1,NULL,'[{\"id\":40721,\"user_id\":7503,\"field_name1\":\"PROTECCION UNITORCO SRL\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"30-71218705-7\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2022-10-25T14:41:53.000000Z\",\"updated_at\":\"2022-10-25T14:41:53.000000Z\",\"activity_id\":null,\"address\":\"caama\\u00f1o 1003 depto 39 pilar\",\"person_type_id\":2,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"status_liq_sueldos\":\"Sin Usar\",\"status_liq_domestica\":\"Sin Usar\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":4,\"user_id\":7503,\"person_id\":40721,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2022-10-25T14:41:53.000000Z\",\"updated_at\":\"2022-10-25T17:34:44.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":10,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":4,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2022-09\",\"obligation_salaries\":1,\"empleada_domestica\":1,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":1,\"person_id_administrador\":40721,\"person_id_titular\":40721,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-10-25T03:00:00.000000Z\",\"iibb\":\"30712187057\",\"fe_leyenda\":null,\"atencion_iva\":1,\"atencion_iva_comentario\":null,\"atencion_iibb\":1,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":null,\"periods\":[{\"id\":3022,\"user_id\":null,\"code\":\"2022-09\",\"year\":2022,\"period_number\":9,\"date_from\":\"2022-09-01\",\"date_to\":\"2022-09-30\",\"created_at\":null,\"updated_at\":null,\"person_id\":40721,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40720,\"user_id\":7503,\"field_name1\":\"UNITORCO SRL\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"33-70855939-9\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2022-10-25T14:34:02.000000Z\",\"updated_at\":\"2022-10-25T14:34:02.000000Z\",\"activity_id\":null,\"address\":\"caama\\u00f1o 1103 depto 39 pilar\",\"person_type_id\":2,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"status_liq_sueldos\":\"Sin Usar\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":3,\"user_id\":7503,\"person_id\":40720,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2022-10-25T14:34:02.000000Z\",\"updated_at\":\"2022-10-25T23:27:06.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":4,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2022-09\",\"obligation_salaries\":1,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":1,\"person_id_administrador\":40720,\"person_id_titular\":40720,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2003-11-01T03:00:00.000000Z\",\"iibb\":\"33708559399\",\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":null,\"periods\":[{\"id\":1515,\"user_id\":null,\"code\":\"2022-09\",\"year\":2022,\"period_number\":9,\"date_from\":\"2022-09-01\",\"date_to\":\"2022-09-30\",\"created_at\":null,\"updated_at\":null,\"person_id\":40720,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]}]',1,'2022-10-25 20:28:05','2022-10-25 20:28:05',NULL);
/*!40000 ALTER TABLE `consultas_aux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos`
--

DROP TABLE IF EXISTS `conta_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `debe_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `haber_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `ctactecheque_id` int(10) unsigned DEFAULT NULL,
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `adjunto` text COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `radioChecked` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `CuentaTipo_id` int(10) unsigned DEFAULT NULL,
  `CentroCosto_id` int(10) unsigned DEFAULT NULL,
  `pagado` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_person_id_foreign` (`person_id`),
  KEY `conta_asientos_period_id_foreign` (`period_id`),
  KEY `conta_asientos_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `conta_asientos_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `conta_asientos_ctactecheque_id_foreign` (`ctactecheque_id`),
  KEY `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` (`haber_cta_cte_tesoreria_cuenta_id`),
  KEY `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` (`debe_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `conta_asientos_ctactecheque_id_foreign` FOREIGN KEY (`ctactecheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `conta_asientos_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`debe_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`haber_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos`
--

LOCK TABLES `conta_asientos` WRITE;
/*!40000 ALTER TABLE `conta_asientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos_details`
--

DROP TABLE IF EXISTS `conta_asientos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_details_conta_asiento_id_foreign` (`conta_asiento_id`),
  KEY `conta_asientos_details_person_id_foreign` (`person_id`),
  KEY `conta_asientos_details_period_id_foreign` (`period_id`),
  KEY `conta_asientos_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_details_saldo_id_foreign` (`saldo_id`),
  KEY `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_details_conta_asiento_id_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_asientos_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos_details`
--

LOCK TABLES `conta_asientos_details` WRITE;
/*!40000 ALTER TABLE `conta_asientos_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costo_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_centro_costo_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costo_plan_cuenta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_centro_costo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` (`conta_centro_costo_id`),
  KEY `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` (`conta_plan_cuenta_id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` FOREIGN KEY (`conta_centro_costo_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` FOREIGN KEY (`conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costo_plan_cuenta`
--

LOCK TABLES `conta_centro_costo_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costos`
--

DROP TABLE IF EXISTS `conta_centro_costos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costos_person_id_foreign` (`person_id`),
  CONSTRAINT `conta_centro_costos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costos`
--

LOCK TABLES `conta_centro_costos` WRITE;
/*!40000 ALTER TABLE `conta_centro_costos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_plan_cuenta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo` int(11) NOT NULL,
  `tipo_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `padre` int(11) NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rubro` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cpcuenta_type_tc_id` bigint(20) unsigned DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `no_editable` int(11) NOT NULL DEFAULT '1',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_plan_cuenta_tipo_cuenta_id_foreign` (`tipo_cuenta_id`),
  KEY `conta_plan_cuenta_saldo_id_foreign` (`saldo_id`),
  KEY `conta_plan_cuenta_cpcuenta_type_tc_id_foreign` (`cpcuenta_type_tc_id`),
  CONSTRAINT `conta_plan_cuenta_cpcuenta_type_tc_id_foreign` FOREIGN KEY (`cpcuenta_type_tc_id`) REFERENCES `cpcuenta_types_tc` (`id`),
  CONSTRAINT `conta_plan_cuenta_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_plan_cuenta_tipo_cuenta_id_foreign` FOREIGN KEY (`tipo_cuenta_id`) REFERENCES `conta_tipo_cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1433 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_plan_cuenta`
--

LOCK TABLES `conta_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_plan_cuenta` VALUES (1,NULL,1000000,1,1,0,'ACTIVO','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(2,NULL,1100000,2,1,1000000,'ACTIVO CORRIENTE','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(3,NULL,1110000,3,1,1100000,'CAJA Y BANCOS','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(4,NULL,1110100,4,1,1110000,'CAJAS','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(5,NULL,1110101,5,1,1110100,'Caja Oficina','Activo',NULL,NULL,0,1,0,0,0,0,NULL),(6,NULL,1110102,5,1,1110100,'Caja Casa','Activo',NULL,NULL,0,1,0,0,0,0,NULL),(7,NULL,1110103,5,1,1110100,'Caja Dolares Casa','Activo',NULL,NULL,0,1,0,0,0,0,NULL),(8,NULL,1110104,5,1,1110100,'Banco Santander 015-372795/5','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(9,NULL,1110200,4,1,1110000,'BANCOS','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(10,NULL,1110201,5,1,1110200,'Banco Santander Rio Cta Corriente','Activo',NULL,NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(11,NULL,1110202,5,1,1110200,'Banco Santander Rio Cta Corriente DOLARES','Activo',NULL,NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(12,NULL,1130000,3,1,1100000,'CREDITOS POR VENTAS','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(13,NULL,1130101,5,1,1130100,'Clientes - Deudores','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(14,NULL,1130102,5,1,1130100,'Deudores por ventas comunes','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(15,NULL,1130103,5,1,1130100,'Deudores por ventas morosos','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(16,NULL,1130104,5,1,1130100,'Deudores en gestión judicial','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(17,NULL,1130105,5,1,1130100,'Previsión deudores incobrables','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(18,NULL,1140000,3,1,1100000,'OTROS CREDITOS','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(19,NULL,1140100,4,1,1140000,'Retenciones Sufridas','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(20,NULL,1140301,5,1,1140300,'Anticipos Impuesto a las Ganancias','Activo',4,NULL,1,2,0,0,1,1,NULL),(21,NULL,1140102,5,1,1140100,'Retenciones Ingr. Brutos','Activo',NULL,NULL,0,1,0,0,0,0,NULL),(22,NULL,1140329,5,1,1140300,'Anticipo Impto.Ganancia Mínima Presunta','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(23,NULL,1140105,5,1,1140100,'Retenciones Impuesto a las Ganancias','Activo',3,NULL,1,2,1,0,0,1,NULL),(24,NULL,1140106,5,1,1140100,'Impuesto a las Ganancias (Saldo a favor)','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(25,NULL,1140107,5,1,1140100,'Retenciones de IVA','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(26,NULL,1140200,4,1,1140000,'CREDITOS DIVERSOS','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(27,NULL,1140201,5,1,1140200,'Anticipos de proveedores','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(28,NULL,1140205,5,1,1140200,'Depósito en garantía alquileres','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(29,NULL,1140206,5,1,1140200,'Derechos adquiridos a devengar','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(30,NULL,1140207,5,1,1140200,'Intereses a devengar','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(31,NULL,1140208,5,1,1140200,'Cuentas a rendir - Directores','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(32,NULL,1140210,5,1,1140200,'Alquileres no devengados','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(33,NULL,1150000,3,1,1100000,'BIENES DE CAMBIO','Activo',5,NULL,1,1,0,0,0,0,NULL),(34,NULL,1150400,4,1,1150000,'MERCADERIA DE REVENTA','Activo',5,NULL,1,1,0,0,0,0,NULL),(35,NULL,1200000,2,1,1000000,'ACTIVO NO CORRIENTE','Activo',5,NULL,1,1,0,0,0,0,NULL),(36,NULL,1220000,3,1,1200000,'BIENES DE USO','Activo',5,NULL,1,1,0,0,0,0,NULL),(37,NULL,1220100,4,1,1220000,'EQUIPOS DE COMPUTACION','Activo',5,NULL,1,1,0,0,0,0,NULL),(38,NULL,1220101,5,1,1220100,'Equipos de computación valores históricos','Activo',5,NULL,1,1,0,0,0,1,NULL),(39,NULL,1220102,5,1,1220100,'Equipos de computación ajuste','Activo',5,NULL,1,1,0,0,0,1,NULL),(40,NULL,1220108,5,1,1220100,'Amortización Acumulada Equipos de comput.','Activo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(41,NULL,1220200,4,1,1220000,'INSTALACIONES','Activo',5,NULL,1,1,0,0,0,0,NULL),(42,NULL,1220201,5,1,1220200,'Instalaciones valores históricos','Activo',5,NULL,1,1,0,0,0,1,NULL),(43,NULL,1220202,5,1,1220200,'Instalaciones ajuste','Activo',5,NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (44,NULL,1220206,5,1,1220200,'Amortización Acumulada Instalaciones','Activo',5,NULL,1,1,0,0,0,1,NULL),(45,NULL,1220300,4,1,1220000,'MUEBLES Y UTILES','Activo',5,NULL,1,1,0,0,0,0,NULL),(46,NULL,1220301,5,1,1220300,'Muebles y utiles valores históricos','Activo',5,NULL,1,1,0,0,0,1,NULL),(47,NULL,1220302,5,1,1220300,'Muebles y utiles ajuste','Activo',5,NULL,1,1,0,0,0,1,NULL),(48,NULL,1220306,5,1,1220300,'Amortización Acumulada Muebles y Útiles','Activo',5,NULL,1,1,0,0,0,1,NULL),(49,NULL,1230000,3,1,1200000,'ACTIVOS INTANGIBLES','Activo',5,NULL,1,1,0,0,0,0,NULL),(50,NULL,1230101,5,1,1230100,'Gastos de organización valores historicos','Activo',5,NULL,1,1,0,0,0,1,NULL),(51,NULL,1230102,5,1,1230100,'Gastos de organización ajuste','Activo',5,NULL,1,1,0,0,0,1,NULL),(52,NULL,1230103,5,1,1230100,'Amortización acumulada gs. de organización','Activo',5,NULL,1,1,0,0,0,1,NULL),(53,NULL,2000000,1,2,0,'PASIVO','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(54,NULL,2100000,2,2,2000000,'PASIVO CORRIENTE','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(55,NULL,2110000,3,2,2100000,'Deudas','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(56,NULL,2110100,4,2,2110000,'Comerciales','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(57,NULL,2110101,5,2,2110100,'Proveedores en Cta. Cte. locales','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(58,NULL,2110102,5,2,2110100,'Proveedores en cta. cte. exterior','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(59,NULL,2110103,5,2,2110100,'Derechos de exhibición a devengar','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(60,NULL,2110104,5,2,2110100,'Cheques emitidos ','Pasivo',NULL,NULL,1,2,1,1,1,1,NULL),(61,NULL,2110200,4,2,2110000,'REMUNERACIONES Y CARGAS SOCIALES','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(62,NULL,2110201,5,2,2110200,'Sueldos y Jornales a pagar','Pasivo',NULL,NULL,1,2,0,0,1,1,NULL),(63,NULL,2110202,5,2,2110200,'Cargas sociales a pagar','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(64,NULL,2110203,5,2,2110200,'Sindicatos a Pagar','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(65,NULL,2110300,4,2,2110000,'CARGAS FISCALES','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(67,NULL,2110301,5,2,2110300,'IVA Debito Fiscal','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(68,NULL,1140222,5,1,1140200,'IVA Credito Fiscal','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(69,NULL,2110303,5,2,2110300,'Impuestos Internos','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(70,NULL,2110304,5,2,2110300,'Impuestos al Combustible','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(71,NULL,2110601,5,2,2110600,'IVA Retenciones de terceros','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(72,NULL,2110306,5,2,2110300,'IVA Percepciones realiz.por terceros','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(73,NULL,2110307,5,2,2110300,'IVA Saldo a favor','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(74,NULL,2110308,5,2,2110300,'IVA a pagar','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(75,NULL,2110309,5,2,2110300,'Percepciones Ingresos Brutos','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(76,NULL,2110310,5,2,2110300,'Otros Pagos AFIP','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(78,NULL,2110350,5,2,2110300,'Impuesto a los Ingresos Brutos Pasivo','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(79,NULL,2110313,5,2,2110300,'Impuesto a las Ganancias','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(80,NULL,2110314,5,2,2110300,'Impuesto a la Ganancia Mínima Presunta','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(81,NULL,2110602,5,2,2110600,'AFIP - Retenciones Impuesto a las Ganancias','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(82,NULL,2110316,5,2,2110300,'AFIP - Plan de Facilidades Decreto 338/02','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(83,NULL,2200000,2,2,2000000,'PASIVO NO CORRIENTE','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(84,NULL,3000000,1,2,0,'PATRIMONIO NETO','Patrimonio Neto',NULL,NULL,1,1,0,0,0,0,NULL),(85,NULL,3100000,2,2,3000000,'APORTE DE LOS PROPIETARIOS','Patrimonio Neto',NULL,NULL,1,1,0,0,0,0,NULL),(86,NULL,3110100,4,2,3110000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,NULL,1,1,0,0,0,0,NULL),(87,NULL,3110101,5,2,3110100,'Acciones en circulación','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (88,NULL,3110102,5,2,3110100,'Ajuste del Capital','Patrimonio Neto',NULL,NULL,1,2,0,0,0,1,NULL),(89,NULL,3110103,5,2,3110100,'Aportes Irrevocables Futuras Suscripciones','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(90,NULL,3400000,2,2,3000000,'RESULTADOS','Patrimonio Neto',NULL,NULL,1,1,0,0,0,0,NULL),(91,NULL,3410101,5,2,3410100,'Resultado del ejercicio','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(92,NULL,3410102,5,2,3410100,'Resultado ejercicios anteriores','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(93,NULL,3410103,5,2,3410100,'A.R.E.A.','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(94,NULL,4000000,1,2,0,'INGRESOS','Result. Positivo',NULL,NULL,1,1,0,0,0,0,NULL),(95,NULL,4100000,2,2,4000000,'INGRESOS ORDINARIOS','Result. Positivo',NULL,NULL,1,1,0,0,0,0,NULL),(96,NULL,4110101,5,2,4110100,'VENTAS','Result. Positivo',NULL,NULL,1,2,0,0,0,1,NULL),(97,NULL,4110102,5,2,4110100,'Honorarios','Result. Positivo',NULL,NULL,1,1,0,0,0,1,NULL),(98,NULL,4110103,5,2,4110100,'Sueldo Vane','Result. Positivo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(99,NULL,4110104,5,2,4110100,'Descuentos obtenidos','Result. Positivo',NULL,NULL,1,1,0,0,0,1,NULL),(100,NULL,4110105,5,2,4110100,'Reintegros por exportaciones','Result. Positivo',NULL,NULL,1,1,0,0,0,1,NULL),(101,NULL,4120000,3,2,4100000,'OTROS INGRESOS','Result. Positivo',NULL,NULL,1,1,0,0,0,0,NULL),(102,NULL,4120101,5,2,4120100,'Intereses Cobrados','Result. Positivo',NULL,NULL,1,1,0,0,0,1,NULL),(103,NULL,4120102,5,2,4120100,'Diferencias de cambio','Result. Positivo',NULL,NULL,1,1,0,0,0,1,NULL),(104,NULL,4120103,5,2,4120100,'Descuentos obtenidos','Result. Positivo',NULL,NULL,1,1,0,0,0,1,NULL),(107,NULL,5000000,1,1,0,'GASTOS','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(108,NULL,5100000,2,1,5000000,'GASTOS ORDINARIOS','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(109,NULL,5110100,4,1,5110000,'ASIENTO DE SUELDO','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(110,NULL,5110101,5,1,5110100,'Sueldos','Result. Negativo',2,NULL,1,2,0,0,0,1,NULL),(111,NULL,5110102,5,1,5110100,'Contribuciones','Result. Negativo',2,NULL,1,2,0,0,0,1,NULL),(112,NULL,5110103,5,1,5110100,'Sindicato','Result. Negativo',2,NULL,1,2,0,0,0,1,NULL),(113,NULL,5120100,4,1,5120000,'GASTOS DE OPERACION','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(114,NULL,5120101,5,1,5120100,'ACA','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(115,NULL,5120102,5,1,5120100,'Aereos','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(116,NULL,5120103,5,1,5120100,'Alquiler','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(117,NULL,5120104,5,1,5120100,'AGUA AYSA','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(118,NULL,5120105,5,1,5120100,'TV Cablevision','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(119,NULL,5120106,5,1,5120100,'Caja Jubilacion Consejo','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(120,NULL,5120107,5,1,5120100,'Celulares','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(121,NULL,5120108,5,1,5120100,'Cheques','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(122,NULL,5120109,5,1,5120100,'Club la Nacion','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(123,NULL,5120110,5,1,5120100,'Comida','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(124,NULL,5120111,5,1,5120100,'Diario Clarin','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(125,NULL,5120112,5,1,5120100,'Digital Ocean','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(126,NULL,5120113,5,1,5120100,'Fletes y acarreos','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(127,NULL,5120114,5,1,5120100,'Luz Edesur','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(128,NULL,5120115,5,1,5120100,'Movilidad y Viáticos','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(129,NULL,5120116,5,1,5120100,'Mantenimiento','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (130,NULL,5120117,5,1,5120100,'IVA No Computable','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(131,NULL,5120118,5,1,5120100,'Entretenimiento','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(132,NULL,5120119,5,1,5120100,'Amortización Bienes de Uso','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(133,NULL,5120120,5,1,5120100,'Errepar','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(134,NULL,5120121,5,1,5120100,'Hosting Página Web To Webs','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(135,NULL,5120122,5,1,5120100,'Gastos varios','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(136,NULL,5120123,5,1,5120100,'Ajuste por redondeo','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(137,NULL,5120124,5,1,5120100,'Deudores Incobrables','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(138,NULL,5120125,5,1,5120100,'Faby Goncalves','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(139,NULL,5130100,4,1,5130000,'GASTOS FINANCIEROS','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(140,NULL,5130101,5,1,5130100,'Intereses y Gastos bancarios','Result. Negativo',NULL,NULL,1,2,0,0,1,1,NULL),(141,NULL,5130102,5,1,5130100,'Intereses Proveedores','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(142,NULL,5130103,5,1,5130100,'Damian Financiera','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(143,NULL,5130104,5,1,5130100,'Diferencias de cambio','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(144,NULL,5130105,5,1,5130100,'Diferencia de Cambio Bces. en M.Extranjera','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(145,NULL,5130106,5,1,5130100,'Diferencia tipo cambio Vendedor/Comprador','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(146,NULL,5130107,5,1,5130100,'Diferencia por conversion en Bce. en Mon. Extranj.','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(147,NULL,5130108,5,1,5130100,'Diferencia de cambio CMV','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(148,NULL,5130109,5,1,5130100,'Diferencia de cambio PT','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(149,NULL,5130110,5,1,5130100,'Resultado por Exposición a la Inflación','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(150,NULL,5130111,5,1,5130100,'Diferencia de cambio PE','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(151,NULL,5130112,5,1,5130100,'Diferencia de cambio Ds.Vtas.','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(152,NULL,5130113,5,1,5130100,'Diferencia de cambio ME','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(153,NULL,5130114,5,1,5130100,'Descuentos otorgados','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(154,NULL,5140100,4,1,5140000,'IMPUESTOS','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(155,NULL,5140101,5,1,5140100,'Impuesto a las Ganancias','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(156,NULL,5140164,5,1,5140100,'Impuesto a los Ingresos Brutos','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(157,NULL,5140102,5,1,5140100,'Impuesto al Debito y Credito Bancario','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(158,NULL,5200000,2,1,5000000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(159,NULL,5210101,5,1,5210100,'Pérdida por venta bienes de uso','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(160,NULL,5210102,5,1,5210100,'Inversiones','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(161,NULL,5210103,5,1,5210100,'Amortizaciones extraordinarias','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(162,NULL,1140103,5,1,1140100,'Retenciones SUSS','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(163,NULL,1110122,5,1,1110100,'Banco Patagonia Cta. Cte.','Activo',NULL,NULL,0,1,0,0,0,0,NULL),(164,NULL,1110106,5,1,1110100,'Banco HSBC','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(165,NULL,1110123,5,1,1110100,'Banco Ciudad Cta. Cte.','Activo',NULL,NULL,0,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (166,NULL,1110124,5,1,1110100,'Banco Nacion Cta. Cte.','Activo',NULL,NULL,0,1,0,0,0,0,NULL),(167,NULL,1110109,5,1,1110100,'Banco Galicia Vane','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(168,NULL,1110110,5,1,1110100,'Banco Frances Vane','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(169,NULL,1110111,5,1,1110100,'Banco Patagonia In Time SRL','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(170,NULL,1110112,5,1,1110100,'Banco Ciudad In Time SRL','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(171,NULL,1110113,5,1,1110100,'Banco Provincia In Time SRL','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(172,NULL,1110114,5,1,1110100,'Banco Macro PedimeOnline','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(173,NULL,1110115,5,1,1110100,'Banco Patagonia Problema Resuelto','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(174,NULL,1110116,5,1,1110100,'Banco Patagonia Graciela','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(175,NULL,1110117,5,1,1110100,'Banco Patagonia Omar','Activo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(176,NULL,1110118,5,1,1110100,'Cheques','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(177,NULL,5120126,5,1,5120100,'Gisela Larzabal','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(178,NULL,5120127,5,1,5120100,'Google','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(179,NULL,5120128,5,1,5120100,'Seguro Moto','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(180,NULL,5120129,5,1,5120100,'Sueldo Agustina','Result. Negativo',NULL,NULL,0,1,0,0,0,0,NULL),(181,NULL,5120130,5,1,5120100,'Sueldo Betty','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(182,NULL,5120131,5,1,5120100,'Sueldo Elizabet','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(183,NULL,5120132,5,1,5120100,'Sueldo Florencia','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(184,NULL,5120133,5,1,5120100,'Sueldo Graciela','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(185,NULL,5120134,5,1,5120100,'Sueldo Franco Sanchez','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(186,NULL,5120135,5,1,5120100,'Sueldo Santiago Sanchez','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(187,NULL,5120136,5,1,5120100,'Sueldo Jose Luis','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(188,NULL,5120137,5,1,5120100,'Publicidad','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(189,NULL,5120138,5,1,5120100,'Las Nieves','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(190,NULL,5120139,5,1,5120100,'Sueldo Lidia','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(191,NULL,5120140,5,1,5120100,'Cargas Sociales','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(192,NULL,5120141,5,1,5120100,'Honorarios','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(193,NULL,5120142,5,1,5120100,'Telefono Fijo','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(194,NULL,5120143,5,1,5120100,'ONE DRIVE','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(195,NULL,5120144,5,1,5120100,'OSDE','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(196,NULL,5120145,5,1,5120100,'SAS Constitucion','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(197,NULL,5120146,5,1,5120100,'Seguro de Vida Zurich','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(198,NULL,5120147,5,1,5120100,'Seguros','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(199,NULL,5120148,5,1,5120100,'Internet','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(200,NULL,5120149,5,1,5120100,'Seguro de Retiro Zurich','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(201,NULL,5140165,5,1,5140100,'Monotributo','Result. Negativo',NULL,NULL,1,2,0,0,1,1,NULL),(202,NULL,5140104,5,1,5140100,'IVA In Time SRL','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(203,NULL,5140105,5,1,5140100,'Autonomos','Result. Negativo',NULL,NULL,1,2,0,0,1,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (204,NULL,5140106,5,1,5140100,'Multas Impositivas','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(207,NULL,5120150,5,1,5120100,'Vanesa Gastos','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(208,NULL,5140166,5,1,5140100,'Impuesto a los Ingresos Brutos - BS AS','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(209,NULL,5140107,5,1,5140100,'SIRCREB','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(210,NULL,5140108,5,1,5140100,'Consejo Ciencias Economicas','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(211,NULL,5120152,5,1,5120100,'Albano Andres','Result. Negativo',NULL,NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(212,NULL,5120153,5,1,5120100,'Tarjeta Visa','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(213,NULL,5120154,5,1,5120100,'Tarjeta American Express','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(214,NULL,5120155,5,1,5120100,'Tarjeta Mastercard','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(215,NULL,5120156,5,1,5120100,'Imp. Municipales Sufrida','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(216,NULL,5120157,5,1,5120100,'Perc/Ret. Imp. Ganancias Sufrida','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(217,NULL,5120158,5,1,5120100,'Compras','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(218,NULL,4110106,5,2,4110100,'Ventas No Gravadas','Result. Positivo',1,NULL,1,2,0,0,0,1,NULL),(219,NULL,6110103,5,1,6110100,'Pagos AFIP','Movimiento',NULL,NULL,1,2,0,0,1,1,NULL),(220,NULL,5140167,5,1,5140100,'Perc IVA -RG3337 Sufrida','Result. Negativo',6,NULL,1,2,0,0,0,1,NULL),(221,NULL,5140109,5,1,5140100,'Imps. Internos Sufrida','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(222,NULL,5140110,5,1,5140100,'Imp. Gasoil Sufrida','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(223,NULL,5140111,5,1,5140100,'Imp. Hídricos Sufrida','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(224,NULL,5140112,5,1,5140100,'ITC Sufrida','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(225,NULL,5140113,5,1,5140100,'Perc IIBB  Buenos Aires Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(226,NULL,5140114,5,1,5140100,'Perc IIBB  Capital Federal Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(227,NULL,5140115,5,1,5140100,'Perc IIBB  Catamarca Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(228,NULL,5140116,5,1,5140100,'Perc IIBB  Chaco Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(229,NULL,5140117,5,1,5140100,'Perc IIBB  Chubut Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(230,NULL,5140118,5,1,5140100,'Perc IIBB  Córdoba Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(231,NULL,5140119,5,1,5140100,'Perc IIBB  Corrientes Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(232,NULL,5140120,5,1,5140100,'Perc IIBB  Entre Ríos Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(233,NULL,5140121,5,1,5140100,'Perc IIBB  Formosa Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(234,NULL,5140122,5,1,5140100,'Perc IIBB  Jujuy Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(235,NULL,5140123,5,1,5140100,'Perc IIBB  La Pampa Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(236,NULL,5140124,5,1,5140100,'Perc IIBB  La Rioja Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(237,NULL,5140125,5,1,5140100,'Perc IIBB  Mendoza Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(238,NULL,5140126,5,1,5140100,'Perc IIBB  Misiones Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(239,NULL,5140127,5,1,5140100,'Perc IIBB  Neuquén Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(240,NULL,5140128,5,1,5140100,'Perc IIBB  Pascua Lama Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(241,NULL,5140129,5,1,5140100,'Perc IIBB  Río Negro Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(242,NULL,5140130,5,1,5140100,'Perc IIBB  Salta Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(243,NULL,5140131,5,1,5140100,'Perc IIBB  San Juan Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(244,NULL,5140132,5,1,5140100,'Perc IIBB  San Luis Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (245,NULL,5140133,5,1,5140100,'Perc IIBB  Santa Cruz Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(246,NULL,5140134,5,1,5140100,'Perc IIBB  Santa Fe Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(247,NULL,5140135,5,1,5140100,'Perc IIBB  Santiago del Estero Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(248,NULL,5140136,5,1,5140100,'Perc IIBB  Tierra del Fuego Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(249,NULL,5140137,5,1,5140100,'Perc IIBB  Tucuman Sufrida','Result. Negativo',7,NULL,1,2,0,0,0,1,NULL),(250,NULL,5140138,5,1,5140100,'Compras No Gravadas','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(251,NULL,1140108,5,1,1140100,'Retenciones de IIBB Buenos Aires','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(252,NULL,1140109,5,1,1140100,'Retenciones de IIBB Capital Federal','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(253,NULL,1140110,5,1,1140100,'Retenciones de IIBB Catamarca','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(254,NULL,1140111,5,1,1140100,'Retenciones de IIBB Chaco','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(255,NULL,1140112,5,1,1140100,'Retenciones de IIBB Chubut','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(256,NULL,1140113,5,1,1140100,'Retenciones de IIBB Córdoba','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(257,NULL,1140114,5,1,1140100,'Retenciones de IIBB Corrientes','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(258,NULL,1140115,5,1,1140100,'Retenciones de IIBB Entre Ríos','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(259,NULL,1140116,5,1,1140100,'Retenciones de IIBB Formosa','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(260,NULL,1140117,5,1,1140100,'Retenciones de IIBB Jujuy','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(261,NULL,1140118,5,1,1140100,'Retenciones de IIBB La Pampa','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(262,NULL,1140119,5,1,1140100,'Retenciones de IIBB La Rioja','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(263,NULL,1140120,5,1,1140100,'Retenciones de IIBB Mendoza','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(264,NULL,1140121,5,1,1140100,'Retenciones de IIBB Misiones','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(265,NULL,1140122,5,1,1140100,'Retenciones de IIBB Neuquén','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(266,NULL,1140123,5,1,1140100,'Retenciones de IIBB Pascua Lama','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(267,NULL,1140124,5,1,1140100,'Retenciones de IIBB Río Negro','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(268,NULL,1140125,5,1,1140100,'Retenciones de IIBB Salta','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(269,NULL,1140126,5,1,1140100,'Retenciones de IIBB San Juan','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(270,NULL,1140127,5,1,1140100,'Retenciones de IIBB San Luis','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(271,NULL,1140128,5,1,1140100,'Retenciones de IIBB Santa Cruz','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(272,NULL,1140129,5,1,1140100,'Retenciones de IIBB Santa Fe','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(273,NULL,1140130,5,1,1140100,'Retenciones de IIBB Santiago del Estero','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(274,NULL,1140131,5,1,1140100,'Retenciones de IIBB Tierra del Fuego','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(275,NULL,1140132,5,1,1140100,'Retenciones de IIBB Tucuman','Activo',NULL,NULL,1,2,1,0,0,1,NULL),(276,NULL,5140168,5,1,5140100,'SIRCREB Buenos Aires','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(277,NULL,5140139,5,1,5140100,'SIRCREB Capital Federal','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(278,NULL,5140140,5,1,5140100,'SIRCREB Catamarca','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(279,NULL,5140141,5,1,5140100,'SIRCREB Chaco','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(280,NULL,5140142,5,1,5140100,'SIRCREB Chubut','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(281,NULL,5140143,5,1,5140100,'SIRCREB Córdoba','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(282,NULL,5140144,5,1,5140100,'SIRCREB Corrientes','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(283,NULL,5140145,5,1,5140100,'SIRCREB Entre Ríos','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(284,NULL,5140146,5,1,5140100,'SIRCREB Formosa','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (285,NULL,5140147,5,1,5140100,'SIRCREB Jujuy','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(286,NULL,5140148,5,1,5140100,'SIRCREB La Pampa','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(287,NULL,5140149,5,1,5140100,'SIRCREB La Rioja','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(288,NULL,5140150,5,1,5140100,'SIRCREB Mendoza','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(289,NULL,5140151,5,1,5140100,'SIRCREB Misiones','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(290,NULL,5140152,5,1,5140100,'SIRCREB Neuquén','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(291,NULL,5140153,5,1,5140100,'SIRCREB Pascua Lama','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(292,NULL,5140154,5,1,5140100,'SIRCREB Río Negro','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(293,NULL,5140155,5,1,5140100,'SIRCREB Salta','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(294,NULL,5140156,5,1,5140100,'SIRCREB San Juan','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(295,NULL,5140157,5,1,5140100,'SIRCREB San Luis','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(296,NULL,5140158,5,1,5140100,'SIRCREB Santa Cruz','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(297,NULL,5140159,5,1,5140100,'SIRCREB Santa Fe','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(298,NULL,5140160,5,1,5140100,'SIRCREB Santiago del Estero','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(299,NULL,5140161,5,1,5140100,'SIRCREB Tierra del Fuego','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(300,NULL,5140162,5,1,5140100,'SIRCREB Tucuman','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(301,NULL,1140326,5,1,1140300,'IIBB a Favor Buenos Aires','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(302,NULL,1140302,5,1,1140300,'IIBB a Favor Capital Federal','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(303,NULL,1140303,5,1,1140300,'IIBB a Favor Catamarca','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(304,NULL,1140304,5,1,1140300,'IIBB a Favor Chaco','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(305,NULL,1140305,5,1,1140300,'IIBB a Favor Chubut','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(306,NULL,1140306,5,1,1140300,'IIBB a Favor Córdoba','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(307,NULL,1140307,5,1,1140300,'IIBB a Favor Corrientes','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(308,NULL,1140308,5,1,1140300,'IIBB a Favor Entre Ríos','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(309,NULL,1140309,5,1,1140300,'IIBB a Favor Formosa','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(310,NULL,1140310,5,1,1140300,'IIBB a Favor Jujuy','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(311,NULL,1140311,5,1,1140300,'IIBB a Favor La Pampa','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(312,NULL,1140312,5,1,1140300,'IIBB a Favor La Rioja','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(313,NULL,1140313,5,1,1140300,'IIBB a Favor Mendoza','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(314,NULL,1140314,5,1,1140300,'IIBB a Favor Misiones','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(315,NULL,1140315,5,1,1140300,'IIBB a Favor Neuquén','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(316,NULL,1140316,5,1,1140300,'IIBB a Favor Pascua Lama','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(317,NULL,1140317,5,1,1140300,'IIBB a Favor Río Negro','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(318,NULL,1140318,5,1,1140300,'IIBB a Favor Salta','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(319,NULL,1140319,5,1,1140300,'IIBB a Favor San Juan','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(320,NULL,1140320,5,1,1140300,'IIBB a Favor San Luis','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(321,NULL,1140321,5,1,1140300,'IIBB a Favor Santa Cruz','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(322,NULL,1140322,5,1,1140300,'IIBB a Favor Santa Fe','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(323,NULL,1140323,5,1,1140300,'IIBB a Favor Santiago del Estero','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(324,NULL,1140324,5,1,1140300,'IIBB a Favor Tierra del Fuego','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(325,NULL,1140325,5,1,1140300,'IIBB a Favor Tucuman','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(326,NULL,2110317,5,2,2110300,'IIBB a Pagar Buenos Aires','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (327,NULL,2110318,5,2,2110300,'IIBB a Pagar Capital Federal','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(328,NULL,2110319,5,2,2110300,'IIBB a Pagar Catamarca','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(329,NULL,2110320,5,2,2110300,'IIBB a Pagar Chaco','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(330,NULL,2110321,5,2,2110300,'IIBB a Pagar Chubut','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(331,NULL,2110322,5,2,2110300,'IIBB a Pagar Córdoba','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(332,NULL,2110323,5,2,2110300,'IIBB a Pagar Corrientes','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(333,NULL,2110324,5,2,2110300,'IIBB a Pagar Entre Ríos','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(334,NULL,2110325,5,2,2110300,'IIBB a Pagar Formosa','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(335,NULL,2110326,5,2,2110300,'IIBB a Pagar Jujuy','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(336,NULL,2110327,5,2,2110300,'IIBB a Pagar La Pampa','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(337,NULL,2110328,5,2,2110300,'IIBB a Pagar La Rioja','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(338,NULL,2110329,5,2,2110300,'IIBB a Pagar Mendoza','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(339,NULL,2110330,5,2,2110300,'IIBB a Pagar Misiones','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(340,NULL,2110331,5,2,2110300,'IIBB a Pagar Neuquén','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(341,NULL,2110332,5,2,2110300,'IIBB a Pagar Pascua Lama','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(342,NULL,2110333,5,2,2110300,'IIBB a Pagar Río Negro','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(343,NULL,2110334,5,2,2110300,'IIBB a Pagar Salta','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(344,NULL,2110335,5,2,2110300,'IIBB a Pagar San Juan','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(345,NULL,2110336,5,2,2110300,'IIBB a Pagar San Luis','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(346,NULL,2110337,5,2,2110300,'IIBB a Pagar Santa Cruz','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(347,NULL,2110338,5,2,2110300,'IIBB a Pagar Santa Fe','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(348,NULL,2110339,5,2,2110300,'IIBB a Pagar Santiago del Estero','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(349,NULL,2110340,5,2,2110300,'IIBB a Pagar Tierra del Fuego','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(350,NULL,2110341,5,2,2110300,'IIBB a Pagar Tucuman','Pasivo',NULL,NULL,1,2,0,0,0,1,NULL),(351,NULL,6110101,5,1,6110100,'BANCO SIRCREB','Movimiento',NULL,NULL,1,2,0,0,1,1,NULL),(352,NULL,6110102,5,1,6110100,'Compensacion','Movimiento',NULL,NULL,1,2,0,0,0,1,NULL),(353,NULL,1140327,5,1,1140300,'IVA Saldo Tecnico','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(354,NULL,1140328,5,1,1140300,'IVA Saldo Libre Disponibilidad','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(355,NULL,6000000,1,1,0,'Movimiento','Movimiento',NULL,NULL,1,1,0,0,0,0,NULL),(356,NULL,6100000,2,1,6000000,'Movimiento','Movimiento',NULL,NULL,1,1,0,0,0,0,NULL),(357,NULL,6110000,3,1,6100000,'Movimiento','Movimiento',NULL,NULL,1,1,0,0,0,0,NULL),(358,NULL,4110000,3,2,4100000,'Ingresos Operativos','Result. Positivo',NULL,NULL,1,1,0,0,0,0,NULL),(359,NULL,1110120,5,1,1110100,'Caja en Pesos','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(360,NULL,1140211,5,1,1140200,'Retenciones Bancarias de Ganancias a Favor','Activo',3,NULL,1,2,0,0,1,1,NULL),(361,NULL,1220104,5,1,1220100,'Equipos de Computación','Activo',5,NULL,1,1,0,0,0,1,NULL),(362,NULL,1220105,5,1,1220100,'Computadoras','Activo',5,NULL,1,1,0,0,0,1,NULL),(363,NULL,1220304,5,1,1220300,'Muebles y Utiles','Activo',5,NULL,1,1,0,0,0,1,NULL),(364,NULL,2110105,5,2,2110100,'Anticipo de Clientes','Pasivo',NULL,NULL,1,2,0,0,1,1,NULL),(365,NULL,2110401,5,2,2110400,'Provision Honorarios','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(366,NULL,2110106,5,2,2110100,'Cta. Cte Directores','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(367,NULL,2110107,5,2,2110100,'Provisión Honorarios Directores','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(368,NULL,2110110,5,2,2110100,'Cuenta Particular Socio 1','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(369,NULL,3110104,5,2,3110100,'Capital','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(370,NULL,1120000,3,1,1100000,'INVERSIONES','Activo',NULL,NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (371,NULL,1160000,3,1,1100000,'OTROS ACTIVOS','Activo',5,NULL,1,1,0,0,0,0,NULL),(372,NULL,1160100,4,1,1160000,'OTROS','Activo',5,NULL,1,1,0,0,0,0,NULL),(373,NULL,2110400,4,2,2110000,'Provision de Honorarios','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(374,NULL,3410100,4,1,3410000,'RESULTADOS ACUMULADOS','Patrimonio Neto',NULL,NULL,1,1,0,0,0,0,NULL),(375,NULL,3420000,3,1,3400000,'GANACIAS RESERVADAS','Patrimonio Neto',NULL,NULL,1,1,0,0,0,0,NULL),(376,NULL,3420100,4,1,3420000,'Rerva Legal','Patrimonio Neto',NULL,NULL,1,1,0,0,0,0,NULL),(377,NULL,1220400,4,1,1220000,'INMUEBLES','Activo',5,NULL,1,1,0,0,0,0,NULL),(378,NULL,1220500,4,1,1220000,'RODADOS','Activo',5,NULL,1,1,0,0,0,0,NULL),(379,NULL,1220600,4,1,1220000,'MAQUINARIAS','Activo',5,NULL,1,1,0,0,0,0,NULL),(380,NULL,1220204,5,1,1220200,'Instalaciones','Activo',5,NULL,1,1,0,0,0,1,NULL),(381,NULL,3420101,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(382,NULL,3420102,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(383,NULL,3410105,5,2,3410100,'Resultado no asignado','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(384,NULL,1110121,5,1,1110100,'Caja en Dolares','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(385,NULL,1120100,4,1,1120000,'TEMPORARIAS','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(386,NULL,1120101,5,1,1120100,'PLAZO FIJO','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(387,NULL,1120200,4,1,1120000,'PERMANENTES','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(388,NULL,1120201,5,1,1120200,'ACCIONES','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(389,NULL,1220401,5,1,1220400,'Inmuebles','Activo',5,NULL,1,1,0,0,0,1,NULL),(390,NULL,1220501,5,1,1220500,'Vehiculos','Activo',5,NULL,1,1,0,0,0,1,NULL),(391,NULL,1220601,5,1,1220600,'Maquinarias','Activo',5,NULL,1,1,0,0,0,1,NULL),(392,NULL,1150401,5,1,1150400,'MERCADERIAS','Activo',5,NULL,1,1,0,0,0,1,NULL),(393,NULL,1160101,5,1,1160100,'OTROS','Activo',5,NULL,1,1,0,0,0,1,NULL),(394,NULL,1230100,4,1,1230000,'INTANGIBLES','Activo',5,NULL,1,1,0,0,0,0,NULL),(395,NULL,2110119,5,2,2110100,'Cuenta Particular Socio 2','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(396,NULL,5120160,5,1,5120100,'Comisiones Y gastos Bancarios','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(397,NULL,4110100,4,2,4110000,'Ingresos Operativos','Result. Positivo',NULL,NULL,1,1,0,0,0,0,NULL),(398,NULL,4120100,4,2,4120000,'OTROS INGRESOS','Result. Positivo',NULL,NULL,1,1,0,0,0,0,NULL),(399,NULL,5110000,3,1,5100000,'GASTOS ORDINARIOS','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(400,NULL,5120000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(401,NULL,5130000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(402,NULL,5140000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(403,NULL,5210000,3,1,5200000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(404,NULL,5210100,4,1,5210000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,NULL,1,1,0,0,0,0,NULL),(405,NULL,6110100,4,1,6110000,'Movimiento','Movimiento',NULL,NULL,1,1,0,0,0,0,NULL),(406,NULL,1130100,4,1,1130000,'Operaciones Ordinarias','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(407,NULL,3110000,3,2,3100000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,NULL,1,1,0,0,0,0,NULL),(408,NULL,3410000,3,2,3400000,'RESULTADOS ANTERIORES','Patrimonio Neto',NULL,NULL,1,1,0,0,0,0,NULL),(409,NULL,5110101,5,2,5110000,'IVA Crédito Fiscal No computable','Result. Negativo',NULL,NULL,1,2,0,0,1,1,NULL),(410,NULL,1110203,5,1,1110200,'Banco ICBC Cta. Cte.','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(411,NULL,2110342,5,2,2110300,'Provisión Impuesto a las Ganancias','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(412,NULL,5120107,5,2,5120000,'Amortización Muebles y Útiles','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(413,NULL,5120102,5,2,5120000,'Amortización Equipos','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(414,NULL,1220109,5,1,1220100,'Amortizacion Acumulada Equipos','Activo',5,NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (415,NULL,1220602,5,1,1220600,'Amortización Acumulada Maquinarias','Activo',5,NULL,1,1,0,0,0,1,NULL),(416,NULL,1160102,5,1,1160100,'Materias Primas','Activo',5,NULL,1,1,0,0,0,1,NULL),(417,NULL,1110204,5,1,1110200,'Banco Itaú Cta. Cte.','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(418,NULL,2110113,5,2,2110100,'Deudas Bancarias','Pasivo',NULL,NULL,1,2,0,1,1,1,NULL),(419,NULL,1220502,5,1,1220500,'Rodados','Activo',5,NULL,1,1,0,0,0,1,NULL),(420,NULL,1220503,5,1,1220500,'Amortización Acumulada Rodados','Activo',5,NULL,1,1,0,0,0,1,NULL),(421,NULL,5120105,5,2,5120000,'Amortización Rodados','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(422,NULL,5120109,5,2,5120000,'Amortización Maquinarias','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(423,NULL,1220504,5,1,1220500,'Accesorios','Activo',5,NULL,1,1,0,0,0,1,NULL),(424,NULL,1220505,5,1,1220500,'Amortización Acumulada Accesorios','Activo',5,NULL,1,1,0,0,0,1,NULL),(425,NULL,1110205,5,1,1110200,'Banco Galicia Cta. Cte.','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(426,NULL,3420101,5,2,3420000,'Reserva Facultativa','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(427,NULL,1140212,5,1,1140200,'Créditos por Impuestos Diferidos','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(428,NULL,1160103,5,1,1160100,'Fondo de Comercio','Activo',5,NULL,1,1,0,0,0,1,NULL),(429,NULL,1160104,5,1,1160100,'Amortizacion Acumulada Fondo de Comercio','Activo',5,NULL,1,1,0,0,0,1,NULL),(430,NULL,1140213,5,1,1140200,'Intereses a devengar AGIP','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(431,NULL,2110343,5,2,2110300,'PFP IIBB','Pasivo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(432,NULL,1140330,5,1,1140300,'Pago a Cuenta ITC','Activo',NULL,NULL,1,2,0,0,0,1,NULL),(433,NULL,2110114,5,2,2110100,'Préstamo','Pasivo',NULL,NULL,1,2,0,1,1,1,NULL),(434,NULL,1160106,5,1,1160100,'Productos','Activo',5,NULL,1,1,0,0,0,1,NULL),(435,NULL,2110345,5,2,2110300,'Intereses a devengar PFP','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(436,NULL,1110206,5,1,1110200,'Banco Provincia Cta. Cte.','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(437,NULL,1140215,5,1,1140200,'Imp. Ley 25413 Cred 0.6%','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(438,NULL,2110402,5,2,2110400,'Honorarios Directorio a Pagar','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(439,NULL,3110101,5,2,3110100,'Reserva para Futuras Inversiones','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(440,NULL,1130106,5,1,1130100,'TEAC - Trabajos Ejecutados a Certificar','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(441,NULL,2110115,5,2,2110100,'Leasing','Pasivo',NULL,NULL,1,2,0,1,1,1,NULL),(442,NULL,1110207,5,1,1110200,'Banco Comafi Cta. Cte','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(443,NULL,2110500,4,2,2110000,'Deudas Financieras','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(444,NULL,2110501,5,2,2110500,'Banco Santander Rio Cta Cte','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(446,NULL,2210000,3,2,2200000,'Deudas','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(447,NULL,2210100,4,2,2210000,'Otras Deudas','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(448,NULL,2210101,5,2,2210100,'Planes de Pagos AFIP','Pasivo',NULL,NULL,1,2,0,1,1,1,NULL),(449,NULL,2110502,5,2,2110500,'Leasing','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(450,NULL,6110101,5,1,6110000,'Cheques Rechazados','Movimiento',NULL,NULL,1,2,0,0,1,1,NULL),(451,NULL,1110208,5,1,1110200,'Banco Patagonia Taxes Software','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(452,NULL,1110209,5,1,1110200,'Banco Macro Cta. Cte.','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(453,NULL,1120202,5,1,1120200,'Inversión Central Caribe','Activo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(454,NULL,1120102,5,1,1120100,'Otras Inversiones','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(455,NULL,1140216,5,1,1140200,'Otros Créditos','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(456,NULL,2110403,5,2,2110400,'Provisión Honorarios Socio Gerente','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(457,NULL,1110210,5,1,1110200,'Cheque Diferido Banco Santander Rio','Activo',NULL,NULL,1,2,1,1,1,0,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (458,NULL,1110211,5,1,1110200,'Cheque Diferido Banco Macro','Activo',NULL,NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(459,NULL,2110204,5,2,2110200,'Moratoria SUSS a pagar','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(460,NULL,2110344,5,2,2110300,'Impuestos Municipales a Pagar','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(461,NULL,5110103,5,2,5110000,'Amortización Instalaciones','Result. Negativo',NULL,NULL,1,1,0,0,0,1,NULL),(462,NULL,5120110,5,2,5120000,'Amortización Equipos de comput.','Result. Negativo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(463,NULL,2110118,5,2,2110100,'Cuenta Particular Socio 3','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(464,NULL,2110120,5,2,2110100,'Cuenta Particular Socio 4','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(465,NULL,3110102,5,2,3110100,'Otras Reservas','Patrimonio Neto',NULL,NULL,1,1,0,0,0,1,NULL),(466,NULL,1140331,5,1,1140300,'IGMP (Saldo a Favor)','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(467,NULL,5110104,5,2,5110000,'Interés','Result. Negativo',NULL,NULL,1,2,0,0,1,1,NULL),(468,NULL,1150402,5,1,1150400,'Productos en Proceso','Activo',5,NULL,1,1,0,0,0,1,NULL),(469,NULL,2110205,5,2,2110200,'Depósitos en Garantía Socio Gerente','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(470,NULL,2110346,5,2,2110300,'Fondos Embargados','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(471,NULL,2110347,5,2,2110300,'Cuota Solid.','Pasivo',NULL,NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(472,NULL,1140332,5,1,1140300,'Anticipo Honorarios Directores','Activo',NULL,NULL,1,1,0,0,0,1,NULL),(473,NULL,2110348,5,2,2110300,'SICORE a Pagar','Pasivo',NULL,NULL,1,1,0,0,0,1,NULL),(474,NULL,1110212,5,1,1110200,'Banco Credicoop Cta. Cte.','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(475,NULL,1110213,5,1,1110200,'Banco Superville Cta. Cte.','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(476,NULL,5110105,5,2,5110000,'RECPAM','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(477,NULL,1110125,5,1,1110100,'Caja Reales','Activo',NULL,NULL,1,2,1,1,1,0,NULL),(478,NULL,5140169,5,1,5140100,'CO2 - Imp. Al Carbono Sufrida','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(479,NULL,1140300,4,1,1140000,'Anticipo de Impuestos','Activo',NULL,NULL,1,1,0,0,0,0,NULL),(480,NULL,2110600,4,2,2110000,'Retenciones Efectuadas','Pasivo',NULL,NULL,1,1,0,0,0,0,NULL),(481,NULL,4200000,2,2,4000000,'INGRESOS EXTRAORDINARIOS','Result. Positivo',NULL,NULL,1,1,0,0,0,0,NULL),(1001,NULL,5140170,5,1,5140100,'SIRTAC Córdoba','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1002,NULL,5140171,5,1,5140100,'SIRTAC Corrientes','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1003,NULL,5140172,5,1,5140100,'SIRTAC Chaco','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1004,NULL,5140173,5,1,5140100,'SIRTAC Chubut','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1005,NULL,5140174,5,1,5140100,'SIRTAC Entre Ríos','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1006,NULL,5140175,5,1,5140100,'SIRTAC Formosa','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1007,NULL,5140176,5,1,5140100,'SIRTAC Jujuy','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1008,NULL,5140177,5,1,5140100,'SIRTAC La Pampa','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1009,NULL,5140178,5,1,5140100,'SIRTAC La Rioja','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1010,NULL,5140179,5,1,5140100,'SIRTAC Mendoza','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1011,NULL,5140180,5,1,5140100,'SIRTAC Misiones','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1012,NULL,5140181,5,1,5140100,'SIRTAC Neuquén','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1013,NULL,5140182,5,1,5140100,'SIRTAC Río Negro','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1014,NULL,5140183,5,1,5140100,'SIRTAC Salta','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1015,NULL,5140184,5,1,5140100,'SIRTAC San Juan','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1016,NULL,5140185,5,1,5140100,'SIRTAC San Luis','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1017,NULL,5140186,5,1,5140100,'SIRTAC Santa Cruz','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (1018,NULL,5140187,5,1,5140100,'SIRTAC Santa Fe','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1019,NULL,5140188,5,1,5140100,'SIRTAC Santiago del Estero','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1020,NULL,5140189,5,1,5140100,'SIRTAC Tierra del Fuego','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1021,NULL,5140190,5,1,5140100,'SIRTAC Tucuman','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1022,NULL,5140191,5,1,5140100,'SIRTAC Capital Federal','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1023,NULL,5140192,5,1,5140100,'SIRTAC Buenos Aires','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1024,NULL,5140193,5,1,5140100,'SIRTAC Catamarca','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1025,NULL,5140194,5,1,5140100,'SIRTAC Pascua Lama','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1026,NULL,6110104,5,1,6110100,'BANCO SIRTAC','Movimiento',NULL,NULL,1,2,0,0,1,1,NULL),(1400,NULL,5140267,5,1,5140100,'Perc IVA -RG3337 Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1401,NULL,5140209,5,1,5140100,'Imps. Internos Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1402,NULL,5140210,5,1,5140100,'Imp. Gasoil Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1403,NULL,5140211,5,1,5140100,'Imp. Hídricos Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1404,NULL,5140212,5,1,5140100,'ITC Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1405,NULL,5140213,5,1,5140100,'Perc IIBB  Buenos Aires Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1406,NULL,5140214,5,1,5140100,'Perc IIBB  Capital Federal Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1407,NULL,5140215,5,1,5140100,'Perc IIBB  Catamarca Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1408,NULL,5140216,5,1,5140100,'Perc IIBB  Chaco Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1409,NULL,5140217,5,1,5140100,'Perc IIBB  Chubut Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1410,NULL,5140218,5,1,5140100,'Perc IIBB  Córdoba Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1411,NULL,5140219,5,1,5140100,'Perc IIBB  Corrientes Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1412,NULL,5140220,5,1,5140100,'Perc IIBB  Entre Ríos Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1413,NULL,5140221,5,1,5140100,'Perc IIBB  Formosa Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1414,NULL,5140222,5,1,5140100,'Perc IIBB  Jujuy Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1415,NULL,5140223,5,1,5140100,'Perc IIBB  La Pampa Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1416,NULL,5140224,5,1,5140100,'Perc IIBB  La Rioja Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1417,NULL,5140225,5,1,5140100,'Perc IIBB  Mendoza Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1418,NULL,5140226,5,1,5140100,'Perc IIBB  Misiones Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1419,NULL,5140227,5,1,5140100,'Perc IIBB  Neuquén Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1420,NULL,5140228,5,1,5140100,'Perc IIBB  Pascua Lama Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1421,NULL,5140229,5,1,5140100,'Perc IIBB  Río Negro Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1422,NULL,5140230,5,1,5140100,'Perc IIBB  Salta Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1423,NULL,5140231,5,1,5140100,'Perc IIBB  San Juan Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1424,NULL,5140232,5,1,5140100,'Perc IIBB  San Luis Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1425,NULL,5140233,5,1,5140100,'Perc IIBB  Santa Cruz Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1426,NULL,5140234,5,1,5140100,'Perc IIBB  Santa Fe Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1427,NULL,5140235,5,1,5140100,'Perc IIBB  Santiago del Estero Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (1428,NULL,5140236,5,1,5140100,'Perc IIBB  Tierra del Fuego Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1429,NULL,5140237,5,1,5140100,'Perc IIBB  Tucuman Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1430,NULL,5140269,5,1,5140100,'CO2 - Imp. Al Carbono Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1431,NULL,5120256,5,1,5120100,'Imp. Municipales Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL),(1432,NULL,5120257,5,1,5120100,'Perc/Ret. Imp. Ganancias Efectuada','Result. Negativo',NULL,NULL,1,2,0,0,0,1,NULL);
/*!40000 ALTER TABLE `conta_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_asientos`
--

DROP TABLE IF EXISTS `conta_tipo_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_asientos`
--

LOCK TABLES `conta_tipo_asientos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_asientos` DISABLE KEYS */;
INSERT INTO `conta_tipo_asientos` VALUES (1,'Sueldos',NULL,NULL,NULL,11),(2,'Ingresos',NULL,NULL,NULL,9),(3,'Egresos',NULL,NULL,NULL,10),(4,'Amortizaciones',NULL,NULL,NULL,4),(5,'Banco',NULL,NULL,NULL,15),(6,'Ganancias',NULL,NULL,NULL,12),(7,'Retenciones',NULL,NULL,NULL,13),(8,'SIRCREB',NULL,NULL,NULL,14),(9,'Compensaciones',NULL,NULL,NULL,16),(10,'Pagos AFIP',NULL,NULL,NULL,17),(11,'Ajustes',NULL,NULL,NULL,3),(12,'Saldos Iniciales',NULL,NULL,NULL,1),(13,'Cancelacion de Iniciales',NULL,NULL,NULL,2),(14,'Patrimonio Neto',NULL,NULL,NULL,8),(15,'Liquidaciones IVA',NULL,NULL,NULL,18),(16,'Liquidacion IIBB',NULL,NULL,NULL,19),(17,'Asientos de Cierre',NULL,NULL,NULL,5),(18,'Reclasificacion',NULL,NULL,NULL,6),(19,'Otros',NULL,NULL,NULL,7),(20,'Cobranzas','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(21,'Pagos','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(22,'Tesoreria','2019-10-19 02:10:24','2019-10-19 02:10:24',NULL,NULL),(23,'Ajuste por Inflacion','2020-03-01 06:39:20','2020-03-01 06:39:20',NULL,NULL),(24,'SIRTAC','2023-10-16 21:13:55','2023-10-16 21:13:55',NULL,20),(25,'Compensaciones Compras',NULL,NULL,NULL,NULL),(26,'Compensaciones Ventas',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_cuentas`
--

DROP TABLE IF EXISTS `conta_tipo_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_cuentas`
--

LOCK TABLES `conta_tipo_cuentas` WRITE;
/*!40000 ALTER TABLE `conta_tipo_cuentas` DISABLE KEYS */;
INSERT INTO `conta_tipo_cuentas` VALUES (1,'Rubro',NULL,NULL,NULL),(2,'SubRubro',NULL,NULL,NULL),(3,'Grupo',NULL,NULL,NULL),(4,'SubGrupo',NULL,NULL,NULL),(5,'Cuenta',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_saldos`
--

DROP TABLE IF EXISTS `conta_tipo_saldos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_saldos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `saldo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_saldos`
--

LOCK TABLES `conta_tipo_saldos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_saldos` DISABLE KEYS */;
INSERT INTO `conta_tipo_saldos` VALUES (1,'Deudor',NULL,NULL,NULL),(2,'Acreedor',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_saldos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_cuits_afip`
--

DROP TABLE IF EXISTS `control_cuits_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_cuits_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `control_cuits_afip_person_id_foreign` (`person_id`),
  CONSTRAINT `control_cuits_afip_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_cuits_afip`
--

LOCK TABLES `control_cuits_afip` WRITE;
/*!40000 ALTER TABLE `control_cuits_afip` DISABLE KEYS */;
/*!40000 ALTER TABLE `control_cuits_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_general`
--

DROP TABLE IF EXISTS `control_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_general` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `control_general_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_general`
--

LOCK TABLES `control_general` WRITE;
/*!40000 ALTER TABLE `control_general` DISABLE KEYS */;
INSERT INTO `control_general` VALUES (1,'Ingresos - Egresos - Resultado',1,'Proyeccion Ganancias','control_general/proyecGanancias',NULL,NULL),(2,'IVA',2,'IVA','control_general/iva',NULL,NULL),(3,'IIBB',3,'IIBB','control_general/iibb',NULL,NULL),(4,'Por Mes',4,'Vto. Impuestos','control_general/vto',NULL,NULL),(5,'Por Impuesto',4,'Vto. Impuestos','control_general/vtoPorImpuestos',NULL,NULL);
/*!40000 ALTER TABLE `control_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpc_nivel_1`
--

DROP TABLE IF EXISTS `cpc_nivel_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpc_nivel_1` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cpc_nivel_1_person_id_foreign` (`person_id`),
  CONSTRAINT `cpc_nivel_1_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpc_nivel_1`
--

LOCK TABLES `cpc_nivel_1` WRITE;
/*!40000 ALTER TABLE `cpc_nivel_1` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpc_nivel_1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpc_nivel_2`
--

DROP TABLE IF EXISTS `cpc_nivel_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpc_nivel_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cpc_nivel_1_id` bigint(20) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cpc_nivel_2_person_id_foreign` (`person_id`),
  KEY `cpc_nivel_2_cpc_nivel_1_id_foreign` (`cpc_nivel_1_id`),
  CONSTRAINT `cpc_nivel_2_cpc_nivel_1_id_foreign` FOREIGN KEY (`cpc_nivel_1_id`) REFERENCES `cpc_nivel_1` (`id`),
  CONSTRAINT `cpc_nivel_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpc_nivel_2`
--

LOCK TABLES `cpc_nivel_2` WRITE;
/*!40000 ALTER TABLE `cpc_nivel_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpc_nivel_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpc_nivel_2_details`
--

DROP TABLE IF EXISTS `cpc_nivel_2_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpc_nivel_2_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cpc_nivel_2_id` bigint(20) unsigned NOT NULL,
  `cuenta_contable_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cpc_nivel_2_details_person_id_foreign` (`person_id`),
  KEY `cpc_nivel_2_details_cpc_nivel_2_id_foreign` (`cpc_nivel_2_id`),
  KEY `cpc_nivel_2_details_cuenta_contable_id_foreign` (`cuenta_contable_id`),
  CONSTRAINT `cpc_nivel_2_details_cpc_nivel_2_id_foreign` FOREIGN KEY (`cpc_nivel_2_id`) REFERENCES `cpc_nivel_2` (`id`),
  CONSTRAINT `cpc_nivel_2_details_cuenta_contable_id_foreign` FOREIGN KEY (`cuenta_contable_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cpc_nivel_2_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpc_nivel_2_details`
--

LOCK TABLES `cpc_nivel_2_details` WRITE;
/*!40000 ALTER TABLE `cpc_nivel_2_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpc_nivel_2_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpcuenta_types_tc`
--

DROP TABLE IF EXISTS `cpcuenta_types_tc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpcuenta_types_tc` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpcuenta_types_tc`
--

LOCK TABLES `cpcuenta_types_tc` WRITE;
/*!40000 ALTER TABLE `cpcuenta_types_tc` DISABLE KEYS */;
INSERT INTO `cpcuenta_types_tc` VALUES (1,NULL,'Ingresos No Gravados',1,NULL,NULL,NULL),(2,NULL,'Sueldos',1,NULL,NULL,NULL),(3,NULL,'Retenciones de Ganancias',1,NULL,NULL,NULL),(4,NULL,'Anticipos de Ganancias',1,NULL,NULL,NULL),(5,NULL,'Bienes Activados',1,NULL,NULL,NULL),(6,NULL,'Percepciones de IVA',1,NULL,NULL,NULL),(7,NULL,'Percepciones de IIBB',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cpcuenta_types_tc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente`
--

DROP TABLE IF EXISTS `cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `is_no_fiscal` tinyint(1) DEFAULT '0',
  `user_id_que_firma` int(10) unsigned DEFAULT NULL,
  `numero` bigint(20) DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `compensado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_cliente_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_cliente_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=183 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente`
--

LOCK TABLES `cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente` VALUES (1,7503,0,NULL,1,2,40723,40724,13,6282,1,0,'2022-12-05','2022-12-05',11554.29,1,1.00,'Factura A N°: 0003-00001229',NULL,NULL,'2023-02-06 10:22:33','2023-02-09 15:24:58','2023-02-09 15:24:58'),(2,7503,0,NULL,2,2,40723,40725,13,6282,1,0,'2022-12-29','2022-12-29',33880.00,1,1.00,'Factura A N°: 0003-00001230',NULL,NULL,'2023-02-06 10:22:33','2023-02-09 15:08:26','2023-02-09 15:08:26'),(3,7503,0,NULL,3,2,40723,40726,13,6283,1,0,'2023-01-02','2023-01-02',32700.00,1,1.00,'Factura B N°: 0003-00000458',NULL,NULL,'2023-02-06 10:24:44','2023-02-09 15:25:10','2023-02-09 15:25:10'),(4,7503,0,NULL,4,2,40723,40724,13,6283,1,0,'2023-01-17','2023-01-17',10623.80,1,1.00,'Factura A N°: 0003-00001231',NULL,NULL,'2023-02-06 10:24:44','2023-02-09 15:25:14','2023-02-09 15:25:14'),(5,7503,0,NULL,5,3,40723,40727,57,6283,2,0,'2022-12-05','2022-12-05',513.39,1,1.00,'Factura B N°: 5015-03284338',NULL,NULL,'2023-02-06 10:26:06','2023-02-06 10:30:07','2023-02-06 10:30:07'),(6,7503,0,NULL,6,3,40723,40728,57,6283,2,0,'2022-12-05','2022-12-05',18530.75,1,1.00,'Factura A N°: 0008-00055488',NULL,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:59','2023-02-06 10:29:59'),(7,7503,0,NULL,7,3,40723,40729,57,6283,1,0,'2022-12-06','2022-12-06',7999.00,1,1.00,'Nota de crédito B N°: 15451-00024152',NULL,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:52','2023-02-06 10:29:52'),(8,7503,0,NULL,8,3,40723,40730,57,6283,2,0,'2022-12-16','2022-12-16',5578.90,1,1.00,'Factura B N°: 2188-02979348',NULL,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:45','2023-02-06 10:29:45'),(9,7503,0,NULL,9,3,40723,40731,57,6283,2,0,'2022-12-17','2022-12-17',299.00,1,1.00,'Factura B N°: 0629-25011178',NULL,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:38','2023-02-06 10:29:38'),(10,7503,0,NULL,10,3,40723,40727,57,6283,2,0,'2022-12-19','2022-12-19',279.65,1,1.00,'Factura B N°: 5015-03356494',NULL,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:22','2023-02-06 10:29:22'),(11,7503,0,NULL,11,3,40723,40732,57,6283,2,0,'2022-12-30','2022-12-30',25619.40,1,1.00,'Factura A N°: 0003-00024153',NULL,NULL,'2023-02-06 10:26:06','2023-02-06 10:29:14','2023-02-06 10:29:14'),(12,7503,0,NULL,12,3,40723,40727,57,6282,2,0,'2022-12-05','2022-12-05',513.39,1,1.00,'Factura B N°: 5015-03284338',NULL,NULL,'2023-02-06 10:31:07','2023-02-09 15:26:35','2023-02-09 15:26:35'),(13,7503,0,NULL,13,3,40723,40728,57,6282,2,0,'2022-12-05','2022-12-05',18530.75,1,1.00,'Factura A N°: 0008-00055488',NULL,NULL,'2023-02-06 10:31:08','2023-02-07 14:39:42','2023-02-07 14:39:42'),(14,7503,0,NULL,14,3,40723,40729,57,6282,1,0,'2022-12-06','2022-12-06',7999.00,1,1.00,'Nota de crédito B N°: 15451-00024152',NULL,NULL,'2023-02-06 10:31:08','2023-02-09 15:26:27','2023-02-09 15:26:27'),(15,7503,0,NULL,15,3,40723,40730,57,6282,2,0,'2022-12-16','2022-12-16',5578.90,1,1.00,'Factura B N°: 2188-02979348',NULL,NULL,'2023-02-06 10:31:08','2023-02-09 15:25:36','2023-02-09 15:25:36'),(16,7503,0,NULL,16,3,40723,40731,57,6282,2,0,'2022-12-17','2022-12-17',299.00,1,1.00,'Factura B N°: 0629-25011178',NULL,NULL,'2023-02-06 10:31:08','2023-02-09 15:26:23','2023-02-09 15:26:23'),(17,7503,0,NULL,17,3,40723,40727,57,6282,2,0,'2022-12-19','2022-12-19',279.65,1,1.00,'Factura B N°: 5015-03356494',NULL,NULL,'2023-02-06 10:31:08','2023-02-09 15:26:16','2023-02-09 15:26:16'),(18,7503,0,NULL,18,3,40723,40732,57,6282,2,0,'2022-12-30','2022-12-30',25619.40,1,1.00,'Factura A N°: 0003-00024153',NULL,NULL,'2023-02-06 10:31:08','2023-02-07 14:40:23','2023-02-07 14:40:23'),(19,7503,0,NULL,19,3,40723,40731,57,6283,2,0,'2023-01-03','2023-01-03',204.00,1,1.00,'Factura B N°: 0629-25429251',NULL,NULL,'2023-02-06 10:31:45','2023-02-09 15:26:12','2023-02-09 15:26:12'),(20,7503,0,NULL,20,3,40723,40733,57,6283,2,0,'2023-01-03','2023-01-03',1815.00,1,1.00,'Factura B N°: 0050-18401620',NULL,NULL,'2023-02-06 10:31:45','2023-02-09 15:26:09','2023-02-09 15:26:09');
INSERT INTO `cta_cte_cliente` VALUES (21,7503,0,NULL,21,3,40723,40730,57,6283,2,0,'2023-01-06','2023-01-06',12766.97,1,1.00,'Factura B N°: 2963-00004480',NULL,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:54','2023-02-09 15:25:54'),(22,7503,0,NULL,22,3,40723,40734,57,6283,2,0,'2023-01-14','2023-01-14',3150.18,1,1.00,'Factura B N°: 0033-00061531',NULL,NULL,'2023-02-06 10:31:45','2023-02-09 15:26:01','2023-02-09 15:26:01'),(23,7503,0,NULL,23,3,40723,40728,57,6283,2,0,'2023-01-16','2023-01-16',8302.28,1,1.00,'Factura A N°: 0008-00056492',NULL,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:49','2023-02-09 15:25:49'),(24,7503,0,NULL,24,3,40723,40731,57,6283,2,0,'2023-01-17','2023-01-17',68.00,1,1.00,'Factura B N°: 0629-25741343',NULL,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:57','2023-02-09 15:25:57'),(25,7503,0,NULL,25,3,40723,40735,57,6283,2,0,'2023-01-18','2023-01-18',100.00,1,1.00,'Factura B N°: 1309-00514235',NULL,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:32','2023-02-09 15:25:32'),(26,7503,0,NULL,26,3,40723,40736,57,6283,2,0,'2023-01-28','2023-01-28',7691.84,1,1.00,'Factura A N°: 7850-00010577',NULL,NULL,'2023-02-06 10:31:45','2023-02-09 15:25:24','2023-02-09 15:25:24'),(27,7503,0,NULL,27,3,40723,40728,57,6282,2,0,'2022-12-05','2022-12-05',18530.75,1,1.00,'Factura A N°: 0008-00055488',NULL,NULL,'2023-02-07 14:39:42','2023-02-09 15:26:30','2023-02-09 15:26:30'),(28,7503,0,NULL,28,3,40723,40732,57,6282,2,0,'2022-12-30','2022-12-30',25619.40,1,1.00,'Factura A N°: 0003-00024153',NULL,NULL,'2023-02-07 14:40:23','2023-02-09 15:25:40','2023-02-09 15:25:40'),(29,7503,0,NULL,29,2,40723,40725,13,6282,1,0,'2022-12-29','2022-12-29',33880.00,1,1.00,'Factura A N°: 0003-00001230',NULL,NULL,'2023-02-09 15:08:26','2023-02-09 15:25:05','2023-02-09 15:25:05'),(30,7503,0,NULL,30,3,40723,40727,57,6282,2,0,'2022-12-05','2022-12-05',513.39,1,1.00,'Factura B N°: 5015-03284338',NULL,NULL,'2023-02-09 15:31:05','2023-02-09 15:56:51','2023-02-09 15:56:51'),(31,7503,0,NULL,31,3,40723,40728,57,6282,2,0,'2022-12-05','2022-12-05',18530.75,1,1.00,'Factura A N°: 0008-00055488',NULL,NULL,'2023-02-09 15:31:05','2023-02-09 15:35:18','2023-02-09 15:35:18'),(32,7503,0,NULL,32,3,40723,40729,57,6282,1,0,'2022-12-06','2022-12-06',7999.00,1,1.00,'Nota de crédito B N°: 15451-00024152',NULL,NULL,'2023-02-09 15:31:05','2023-02-09 15:50:23','2023-02-09 15:50:23'),(33,7503,0,NULL,33,3,40723,40730,57,6282,2,0,'2022-12-16','2022-12-16',5578.90,1,1.00,'Factura B N°: 2188-02979348',NULL,NULL,'2023-02-09 15:31:06','2023-02-09 15:56:44','2023-02-09 15:56:44'),(34,7503,0,NULL,34,3,40723,40731,57,6282,2,0,'2022-12-17','2022-12-17',299.00,1,1.00,'Factura B N°: 0629-25011178',NULL,NULL,'2023-02-09 15:31:06','2023-02-09 15:56:40','2023-02-09 15:56:40'),(35,7503,0,NULL,35,3,40723,40727,57,6282,2,0,'2022-12-19','2022-12-19',279.65,1,1.00,'Factura B N°: 5015-03356494',NULL,NULL,'2023-02-09 15:31:06','2023-02-09 15:56:36','2023-02-09 15:56:36'),(36,7503,0,NULL,36,3,40723,40732,57,6282,2,0,'2022-12-30','2022-12-30',25619.40,1,1.00,'Factura A N°: 0003-00024153',NULL,NULL,'2023-02-09 15:31:06','2023-02-09 15:33:13','2023-02-09 15:33:13'),(37,7503,0,NULL,37,3,40723,40732,57,6282,2,0,'2022-12-30','2022-12-30',25619.40,1,1.00,'Factura A N°: 0003-00024153',NULL,NULL,'2023-02-09 15:33:13','2023-02-09 15:34:42','2023-02-09 15:34:42'),(38,7503,0,NULL,38,3,40723,40732,57,6282,2,0,'2022-12-30','2022-12-30',25619.40,1,1.00,'Factura A N°: 0003-00024153',NULL,NULL,'2023-02-09 15:34:42','2023-02-09 15:56:31','2023-02-09 15:56:31'),(39,7503,0,NULL,39,3,40723,40728,57,6282,2,0,'2022-12-05','2022-12-05',18530.75,1,1.00,'Factura A N°: 0008-00055488',NULL,NULL,'2023-02-09 15:35:18','2023-02-09 15:56:47','2023-02-09 15:56:47'),(40,7503,0,NULL,40,2,40723,40724,13,6282,1,0,'2022-12-05','2022-12-05',11554.29,1,1.00,'Factura A N°: 0003-00001229',NULL,NULL,'2023-02-09 15:43:51','2023-02-09 16:44:55','2023-02-09 16:44:55');
INSERT INTO `cta_cte_cliente` VALUES (41,7503,0,NULL,41,2,40723,40725,13,6282,1,0,'2022-12-29','2022-12-29',33880.00,1,1.00,'Factura A N°: 0003-00001230',NULL,NULL,'2023-02-09 15:43:51','2023-02-09 15:44:21','2023-02-09 15:44:21'),(42,7503,0,NULL,42,2,40723,40725,13,6282,1,0,'2022-12-29','2022-12-29',33880.00,1,1.00,'Factura A N°: 0003-00001230',NULL,NULL,'2023-02-09 15:44:21','2023-02-09 16:44:51','2023-02-09 16:44:51'),(43,7503,0,NULL,43,3,40723,40727,57,6282,2,0,'2022-12-05','2022-12-05',513.39,1,1.00,'Factura B N°: 5015-03284338',NULL,NULL,'2023-02-09 16:16:04','2023-02-09 16:16:50','2023-02-09 16:16:50'),(44,7503,0,NULL,44,3,40723,40728,57,6282,2,0,'2022-12-05','2022-12-05',18530.75,1,1.00,'Factura A N°: 0008-00055488',NULL,NULL,'2023-02-09 16:16:04','2023-02-09 16:17:36','2023-02-09 16:17:36'),(45,7503,0,NULL,45,3,40723,40729,57,6282,1,0,'2022-12-06','2022-12-06',7999.00,1,1.00,'Nota de crédito B N°: 15451-00024152',NULL,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:45','2023-02-09 16:16:45'),(46,7503,0,NULL,46,3,40723,40730,57,6282,2,0,'2022-12-16','2022-12-16',5578.90,1,1.00,'Factura B N°: 2188-02979348',NULL,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:33','2023-02-09 16:16:33'),(47,7503,0,NULL,47,3,40723,40731,57,6282,2,0,'2022-12-17','2022-12-17',299.00,1,1.00,'Factura B N°: 0629-25011178',NULL,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:23','2023-02-09 16:16:23'),(48,7503,0,NULL,48,3,40723,40727,57,6282,2,0,'2022-12-19','2022-12-19',279.65,1,1.00,'Factura B N°: 5015-03356494',NULL,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:38','2023-02-09 16:16:38'),(49,7503,0,NULL,49,3,40723,40732,57,6282,2,0,'2022-12-30','2022-12-30',25619.40,1,1.00,'Factura A N°: 0003-00024153',NULL,NULL,'2023-02-09 16:16:05','2023-02-09 16:17:08','2023-02-09 16:17:08'),(50,7503,0,NULL,50,3,40723,40732,57,6282,2,0,'2022-12-30','2022-12-30',25619.40,1,1.00,'Factura A N°: 0003-00024153',NULL,NULL,'2023-02-09 16:17:08','2023-02-09 16:45:03','2023-02-09 16:45:03'),(51,7503,0,NULL,51,3,40723,40728,57,6282,2,0,'2022-12-05','2022-12-05',18530.75,1,1.00,'Factura A N°: 0008-00055488',NULL,NULL,'2023-02-09 16:17:36','2023-02-09 16:45:07','2023-02-09 16:45:07'),(52,7503,0,NULL,52,2,40723,40726,13,6283,1,0,'2023-01-02','2023-01-02',32700.00,1,1.00,'Factura B N°: 0003-00000458',NULL,NULL,'2023-02-09 16:48:36','2023-02-10 15:41:05','2023-02-10 15:41:05'),(53,7503,0,NULL,53,2,40723,40724,13,6283,1,0,'2023-01-17','2023-01-17',10623.80,1,1.00,'Factura A N°: 0003-00001231',NULL,NULL,'2023-02-09 16:48:36','2023-02-10 15:40:55','2023-02-10 15:40:55'),(54,7503,0,NULL,54,3,40723,40728,57,6283,2,0,'2023-01-16','2023-01-16',8302.28,1,1.00,'Factura A N°: 0008-00056492',NULL,NULL,'2023-02-09 16:51:04','2023-02-09 16:53:01','2023-02-09 16:53:01'),(55,7503,0,NULL,55,3,40723,40736,57,6283,2,0,'2023-01-28','2023-01-28',7691.84,1,1.00,'Factura A N°: 7850-00010577',NULL,NULL,'2023-02-09 16:51:04','2023-02-09 16:59:46','2023-02-09 16:59:46'),(56,7503,0,NULL,56,3,40723,40728,57,6283,2,0,'2023-01-16','2023-01-16',8302.28,1,1.00,'Factura A N°: 0008-00056492',NULL,NULL,'2023-02-09 16:53:01','2023-02-09 17:42:06','2023-02-09 17:42:06'),(57,7503,0,NULL,57,3,40723,40736,57,6283,2,0,'2023-01-28','2023-01-28',7691.84,1,1.00,'Factura A N°: 7850-00010577',NULL,NULL,'2023-02-09 16:59:46','2023-02-09 17:42:02','2023-02-09 17:42:02'),(58,7503,0,NULL,58,3,40723,40731,57,6283,2,0,'2023-01-03','2023-01-03',204.00,1,1.00,'Factura B N°: 0629-25429251',NULL,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:59','2023-02-09 17:41:59'),(59,7503,0,NULL,59,3,40723,40733,57,6283,2,0,'2023-01-03','2023-01-03',1815.00,1,1.00,'Factura B N°: 0050-18401620',NULL,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:54','2023-02-09 17:41:54'),(60,7503,0,NULL,60,3,40723,40730,57,6283,2,0,'2023-01-06','2023-01-06',12766.97,1,1.00,'Factura B N°: 2963-00004480',NULL,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:49','2023-02-09 17:41:49');
INSERT INTO `cta_cte_cliente` VALUES (61,7503,0,NULL,61,3,40723,40734,57,6283,2,0,'2023-01-14','2023-01-14',3150.18,1,1.00,'Factura B N°: 0033-00061531',NULL,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:39','2023-02-09 17:41:39'),(62,7503,0,NULL,62,3,40723,40731,57,6283,2,0,'2023-01-17','2023-01-17',68.00,1,1.00,'Factura B N°: 0629-25741343',NULL,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:22','2023-02-09 17:41:22'),(63,7503,0,NULL,63,3,40723,40735,57,6283,2,0,'2023-01-18','2023-01-18',100.00,1,1.00,'Factura B N°: 1309-00514235',NULL,NULL,'2023-02-09 17:26:29','2023-02-09 17:41:16','2023-02-09 17:41:16'),(64,7503,0,NULL,64,3,40723,40731,57,6283,2,0,'2023-01-03','2023-01-03',204.00,1,1.00,'Factura B N°: 0629-25429251',NULL,NULL,'2023-02-09 17:42:44','2023-02-10 15:42:14','2023-02-10 15:42:14'),(65,7503,0,NULL,65,3,40723,40733,57,6283,2,0,'2023-01-03','2023-01-03',1815.00,1,1.00,'Factura B N°: 0050-18401620',NULL,NULL,'2023-02-09 17:42:44','2023-02-10 15:42:07','2023-02-10 15:42:07'),(66,7503,0,NULL,66,3,40723,40730,57,6283,2,0,'2023-01-06','2023-01-06',12766.97,1,1.00,'Factura B N°: 2963-00004480',NULL,NULL,'2023-02-09 17:42:44','2023-02-10 15:42:00','2023-02-10 15:42:00'),(67,7503,0,NULL,67,3,40723,40734,57,6283,2,0,'2023-01-14','2023-01-14',3150.18,1,1.00,'Factura B N°: 0033-00061531',NULL,NULL,'2023-02-09 17:42:44','2023-02-10 15:41:53','2023-02-10 15:41:53'),(68,7503,0,NULL,68,3,40723,40728,57,6283,2,0,'2023-01-16','2023-01-16',8302.28,1,1.00,'Factura A N°: 0008-00056492',NULL,NULL,'2023-02-09 17:42:44','2023-02-09 17:43:34','2023-02-09 17:43:34'),(69,7503,0,NULL,69,3,40723,40731,57,6283,2,0,'2023-01-17','2023-01-17',68.00,1,1.00,'Factura B N°: 0629-25741343',NULL,NULL,'2023-02-09 17:42:44','2023-02-10 15:41:35','2023-02-10 15:41:35'),(70,7503,0,NULL,70,3,40723,40735,57,6283,2,0,'2023-01-18','2023-01-18',100.00,1,1.00,'Factura B N°: 1309-00514235',NULL,NULL,'2023-02-09 17:42:44','2023-02-10 15:41:27','2023-02-10 15:41:27'),(71,7503,0,NULL,71,3,40723,40736,57,6283,2,0,'2023-01-28','2023-01-28',7691.84,1,1.00,'Factura A N°: 7850-00010577',NULL,NULL,'2023-02-09 17:42:44','2023-02-09 17:44:15','2023-02-09 17:44:15'),(72,7503,0,NULL,72,3,40723,40728,57,6283,2,0,'2023-01-16','2023-01-16',8302.28,1,1.00,'Factura A N°: 0008-00056492',NULL,NULL,'2023-02-09 17:43:34','2023-02-10 15:41:45','2023-02-10 15:41:45'),(73,7503,0,NULL,73,3,40723,40736,57,6283,2,0,'2023-01-28','2023-01-28',7691.84,1,1.00,'Factura A N°: 7850-00010577',NULL,NULL,'2023-02-09 17:44:15','2023-02-09 17:48:14','2023-02-09 17:48:14'),(74,7503,0,NULL,74,3,40723,40736,57,6283,2,0,'2023-01-28','2023-01-28',7691.84,1,1.00,'Factura A N°: 7850-00010577',NULL,NULL,'2023-02-09 17:48:14','2023-02-10 15:41:19','2023-02-10 15:41:19'),(75,7503,0,NULL,75,2,40723,40726,13,6283,1,0,'2023-01-02','2023-01-02',32700.00,1,1.00,'Factura B N°: 0003-00000458',NULL,NULL,'2023-02-10 15:45:44','2023-02-10 15:45:44',NULL),(76,7503,0,NULL,76,2,40723,40724,13,6283,1,0,'2023-01-17','2023-01-17',10623.80,1,1.00,'Factura A N°: 0003-00001231',NULL,NULL,'2023-02-10 15:45:44','2023-02-10 15:45:44',NULL),(77,7503,0,NULL,77,3,40723,40728,57,6283,2,0,'2023-01-16','2023-01-16',8302.28,1,1.00,'Factura A N°: 0008-00056492',NULL,NULL,'2023-02-10 15:46:31','2023-02-10 15:47:46','2023-02-10 15:47:46'),(78,7503,0,NULL,78,3,40723,40736,57,6283,2,0,'2023-01-28','2023-01-28',7691.84,1,1.00,'Factura A N°: 7850-00010577',NULL,NULL,'2023-02-10 15:46:31','2023-02-10 16:01:42','2023-02-10 16:01:42'),(79,7503,0,NULL,79,3,40723,40728,57,6283,2,0,'2023-01-16','2023-01-16',8302.28,1,1.00,'Factura A N°: 0008-00056492',NULL,NULL,'2023-02-10 15:47:46','2023-02-10 15:47:46',NULL),(80,7503,0,NULL,80,3,40723,40736,57,6283,2,0,'2023-01-28','2023-01-28',7691.84,1,1.00,'Factura A N°: 7850-00010577',NULL,NULL,'2023-02-10 16:01:42','2023-02-10 16:01:42',NULL),(81,7503,0,NULL,81,2,40722,40737,13,4529,1,0,'2023-01-02','2023-01-02',352273.80,1,1.00,'Factura A N°: 0003-00000194',NULL,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL);
INSERT INTO `cta_cte_cliente` VALUES (82,7503,0,NULL,82,2,40722,40738,13,4529,1,0,'2023-01-16','2023-01-16',636476.94,1,1.00,'Factura A N°: 0003-00000195',NULL,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(83,7503,0,NULL,83,2,40722,40737,13,4529,1,0,'2023-01-17','2023-01-17',330876.93,1,1.00,'Factura A N°: 0003-00000196',NULL,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(84,7503,0,NULL,84,2,40722,40737,13,4529,1,0,'2023-01-18','2023-01-18',650600.08,1,1.00,'Factura A N°: 0003-00000197',NULL,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(85,7503,0,NULL,85,2,40722,40737,13,4529,1,0,'2023-01-18','2023-01-18',451760.12,1,1.00,'Factura A N°: 0003-00000198',NULL,NULL,'2023-03-21 10:02:49','2023-03-21 10:02:49',NULL),(86,7503,0,NULL,86,2,40722,40737,13,4529,1,0,'2023-01-23','2023-01-23',102221.66,1,1.00,'Factura A N°: 0003-00000199',NULL,NULL,'2023-03-21 10:02:49','2023-03-21 10:02:49',NULL),(87,7503,0,NULL,87,2,40722,40737,13,4529,1,0,'2023-01-27','2023-01-27',115975.16,1,1.00,'Factura A N°: 0003-00000200',NULL,NULL,'2023-03-21 10:02:49','2023-03-21 10:02:49',NULL),(88,7503,0,NULL,88,2,40722,40739,13,4529,2,0,'1969-12-31','1969-12-31',0.00,1,1.00,'Recibo E N°: 0000-00000000',NULL,NULL,'2023-03-21 10:02:49','2023-03-21 10:07:52','2023-03-21 10:07:52'),(89,7503,0,NULL,89,3,40722,40740,57,4529,2,0,'2023-01-01','2023-01-01',5288.04,1,1.00,'Factura A N°: 1007-03545677',NULL,NULL,'2023-03-21 10:06:12','2023-03-21 10:12:36','2023-03-21 10:12:36'),(90,7503,0,NULL,90,3,40722,40741,57,4529,2,0,'2023-01-01','2023-01-01',11160.00,1,1.00,'Factura A N°: 0016-00090006',NULL,NULL,'2023-03-21 10:06:12','2023-03-21 10:12:03','2023-03-21 10:12:03'),(91,7503,0,NULL,91,3,40722,40742,57,4529,2,0,'2023-01-03','2023-01-03',6046.74,1,1.00,'Factura A N°: 0001-00156507',NULL,NULL,'2023-03-21 10:06:12','2023-03-21 10:11:38','2023-03-21 10:11:38'),(92,7503,0,NULL,92,3,40722,40743,57,4529,2,0,'2023-01-05','2023-01-05',22151.50,1,1.00,'Factura A N°: 0072-00001806',NULL,NULL,'2023-03-21 10:06:12','2023-03-21 10:06:12',NULL),(93,7503,0,NULL,93,3,40722,40744,57,4529,2,0,'2023-01-07','2023-01-07',49630.00,1,1.00,'Factura A N°: 0006-00001335',NULL,NULL,'2023-03-21 10:06:13','2023-03-21 10:06:13',NULL),(94,7503,0,NULL,94,3,40722,40745,57,4529,2,0,'2023-01-16','2023-01-16',35060.00,1,1.00,'Factura A N°: 0001-00001002',NULL,NULL,'2023-03-21 10:06:13','2023-03-21 10:06:13',NULL),(95,7503,0,NULL,95,3,40722,40736,57,4529,2,0,'2023-01-17','2023-01-17',10007.86,1,1.00,'Factura A N°: 8460-00015155',NULL,NULL,'2023-03-21 10:06:13','2023-03-21 10:11:04','2023-03-21 10:11:04'),(96,7503,0,NULL,96,3,40722,40746,57,4529,2,0,'2023-01-18','2023-01-18',19950.00,1,1.00,'Factura A N°: 0006-00001414',NULL,NULL,'2023-03-21 10:06:13','2023-03-21 10:06:13',NULL),(97,7503,0,NULL,97,3,40722,40747,57,4529,2,0,'2023-01-27','2023-01-27',70792.14,1,1.00,'Factura A N°: 0004-00014708',NULL,NULL,'2023-03-21 10:06:13','2023-03-21 10:09:47','2023-03-21 10:09:47'),(98,7503,0,NULL,98,3,40722,40748,57,4529,2,0,'2023-01-28','2023-01-28',8990.00,1,1.00,'Factura A N°: 0343-00011744',NULL,NULL,'2023-03-21 10:06:13','2023-03-21 10:09:29','2023-03-21 10:09:29'),(99,7503,0,NULL,99,3,40722,40736,57,4529,2,0,'2023-01-30','2023-01-30',8100.99,1,1.00,'Factura A N°: 8752-00003504',NULL,NULL,'2023-03-21 10:06:13','2023-03-21 10:09:03','2023-03-21 10:09:03'),(100,7503,0,NULL,100,3,40722,40736,57,4529,2,0,'2023-01-30','2023-01-30',8100.99,1,1.00,'Factura A N°: 8752-00003504',NULL,NULL,'2023-03-21 10:09:03','2023-03-21 10:09:03',NULL),(101,7503,0,NULL,101,3,40722,40748,57,4529,2,0,'2023-01-28','2023-01-28',8990.00,1,1.00,'Factura A N°: 0343-00011744',NULL,NULL,'2023-03-21 10:09:29','2023-03-21 10:09:29',NULL),(102,7503,0,NULL,102,3,40722,40747,57,4529,2,0,'2023-01-27','2023-01-27',70792.14,1,1.00,'Factura A N°: 0004-00014708',NULL,NULL,'2023-03-21 10:09:47','2023-03-21 10:09:47',NULL);
INSERT INTO `cta_cte_cliente` VALUES (103,7503,0,NULL,103,3,40722,40736,57,4529,2,0,'2023-01-17','2023-01-17',10005.87,1,1.00,'Factura A N°: 8460-00015155',NULL,NULL,'2023-03-21 10:11:04','2023-03-21 10:11:04',NULL),(104,7503,0,NULL,104,3,40722,40742,57,4529,2,0,'2023-01-03','2023-01-03',6046.74,1,1.00,'Factura A N°: 0001-00156507',NULL,NULL,'2023-03-21 10:11:38','2023-03-21 10:11:38',NULL),(105,7503,0,NULL,105,3,40722,40741,57,4529,2,0,'2023-01-01','2023-01-01',11160.00,1,1.00,'Factura A N°: 0016-00090006',NULL,NULL,'2023-03-21 10:12:03','2023-03-21 10:12:03',NULL),(106,7503,0,NULL,106,3,40722,40740,57,4529,2,0,'2023-01-01','2023-01-01',5288.04,1,1.00,'Factura A N°: 1007-03545677',NULL,NULL,'2023-03-21 10:12:36','2023-03-21 10:12:36',NULL),(107,7503,0,NULL,107,3,40722,40749,57,4529,2,0,'2023-01-30','2023-01-30',8968.40,1,1.00,'Tique Factura A N°: 0012-00004024',NULL,NULL,'2023-03-21 10:16:27','2023-03-21 10:16:27',NULL),(108,7503,0,NULL,108,2,40722,40752,13,4530,1,0,'2023-02-28','2023-02-28',1210.00,1,1.00,'Factura A N°: 0003-00000201',NULL,NULL,'2023-03-21 12:40:38','2023-03-21 12:40:38',NULL),(109,7503,0,NULL,109,2,40722,40737,13,4530,1,0,'2023-02-28','2023-02-28',307818.80,1,1.00,'Factura A N°: 0003-00000202',NULL,NULL,'2023-03-21 12:40:38','2023-03-21 12:40:38',NULL),(110,7503,0,NULL,110,3,40722,40753,57,4530,2,0,'2023-02-01','2023-02-01',17800.00,1,1.00,'Factura A N°: 0001-00002041',NULL,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(111,7503,0,NULL,111,3,40722,40754,57,4530,2,0,'2023-02-02','2023-02-02',12000.00,1,1.00,'Factura A N°: 0004-00000461',NULL,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(112,7503,0,NULL,112,3,40722,40755,57,4530,2,0,'2023-02-07','2023-02-07',10780.00,1,1.00,'Factura A N°: 0008-00043248',NULL,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(113,7503,0,NULL,113,3,40722,40756,57,4530,2,0,'2023-02-07','2023-02-07',30779.00,1,1.00,'Factura A N°: 0030-00000602',NULL,NULL,'2023-03-21 12:41:00','2023-03-21 12:44:25','2023-03-21 12:44:25'),(114,7503,0,NULL,114,3,40722,40757,57,4530,2,0,'2023-02-09','2023-02-09',8460.01,1,1.00,'Factura A N°: 0011-00016496',NULL,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(115,7503,0,NULL,115,3,40722,40736,57,4530,2,0,'2023-02-10','2023-02-10',9902.68,1,1.00,'Factura A N°: 7788-00009160',NULL,NULL,'2023-03-21 12:41:00','2023-03-21 12:44:08','2023-03-21 12:44:08'),(116,7503,0,NULL,116,3,40722,40758,57,4530,2,0,'2023-02-17','2023-02-17',70351.18,1,1.00,'Factura A N°: 0002-00009934',NULL,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(117,7503,0,NULL,117,3,40722,40757,57,4530,2,0,'2023-02-17','2023-02-17',8960.00,1,1.00,'Factura A N°: 0011-00016702',NULL,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(118,7503,0,NULL,118,3,40722,40759,57,4530,2,0,'2023-02-20','2023-02-20',518.59,1,1.00,'Factura A N°: 0104-03031652',NULL,NULL,'2023-03-21 12:41:00','2023-03-21 12:43:41','2023-03-21 12:43:41'),(119,7503,0,NULL,119,3,40722,40760,57,4530,2,0,'2023-02-22','2023-02-22',2092.99,1,1.00,'Factura A N°: 0002-00002043',NULL,NULL,'2023-03-21 12:41:01','2023-03-21 12:41:01',NULL),(120,7503,0,NULL,120,3,40722,40761,57,4530,2,0,'2023-02-23','2023-02-23',3429.37,1,1.00,'Factura A N°: 0006-00002080',NULL,NULL,'2023-03-21 12:41:01','2023-03-21 12:41:01',NULL),(121,7503,0,NULL,121,3,40722,40736,57,4530,2,0,'2023-02-24','2023-02-24',11119.26,1,1.00,'Factura A N°: 8456-00011517',NULL,NULL,'2023-03-21 12:41:01','2023-03-21 12:43:12','2023-03-21 12:43:12'),(122,7503,0,NULL,122,3,40722,40736,57,4530,2,0,'2023-02-24','2023-02-24',11119.26,1,1.00,'Factura A N°: 8456-00011517',NULL,NULL,'2023-03-21 12:43:12','2023-03-21 12:43:12',NULL),(123,7503,0,NULL,123,3,40722,40759,57,4530,2,0,'2023-02-20','2023-02-20',518.59,1,1.00,'Factura A N°: 0104-03031652',NULL,NULL,'2023-03-21 12:43:41','2023-03-21 12:43:41',NULL),(124,7503,0,NULL,124,3,40722,40736,57,4530,2,0,'2023-02-10','2023-02-10',9902.68,1,1.00,'Factura A N°: 7788-00009160',NULL,NULL,'2023-03-21 12:44:08','2023-03-21 12:44:08',NULL);
INSERT INTO `cta_cte_cliente` VALUES (125,7503,0,NULL,125,3,40722,40756,57,4530,2,0,'2023-02-07','2023-02-07',30779.00,1,1.00,'Factura A N°: 0030-00000602',NULL,NULL,'2023-03-21 12:44:25','2023-03-21 12:44:25',NULL),(126,7503,0,NULL,126,3,40722,40762,57,4530,2,0,'2023-02-08','2023-02-08',3999.92,1,1.00,'Tique Factura A N°: 0011-00006698',NULL,NULL,'2023-03-21 12:46:28','2023-03-21 12:46:28',NULL),(127,7503,0,NULL,127,3,40722,40763,57,4530,2,0,'2023-02-08','2023-02-08',7900.60,1,1.00,'Tique Factura A N°: 0011-00012097',NULL,NULL,'2023-03-21 12:48:27','2023-03-21 12:48:27',NULL),(128,7503,0,NULL,128,3,40722,40764,57,4530,2,0,'2023-02-23','2023-02-23',2000.10,1,1.00,'Tique Factura A N°: 0013-00014916',NULL,NULL,'2023-03-21 12:49:18','2023-03-21 12:49:18',NULL),(129,7503,0,NULL,129,2,40722,40737,13,4531,1,0,'2023-03-01','2023-03-01',2333349.11,1,1.00,'Factura A N°: 0003-00000203',NULL,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(130,7503,0,NULL,130,2,40722,40737,13,4531,1,0,'2023-03-01','2023-03-01',841002.60,1,1.00,'Factura A N°: 0003-00000204',NULL,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(131,7503,0,NULL,131,2,40722,40737,13,4531,1,0,'2023-03-02','2023-03-02',104049.74,1,1.00,'Factura A N°: 0003-00000205',NULL,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(132,7503,0,NULL,132,2,40722,40737,13,4531,1,0,'2023-03-15','2023-03-15',1118306.95,1,1.00,'Factura A N°: 0003-00000206',NULL,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(133,7503,0,NULL,133,2,40722,40737,13,4531,1,0,'2023-03-22','2023-03-22',163039.37,1,1.00,'Factura A N°: 0003-00000207',NULL,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(134,7503,0,NULL,134,2,40722,40752,13,4531,1,0,'2023-03-23','2023-03-23',1210.00,1,1.00,'Factura A N°: 0003-00000208',NULL,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(135,7503,0,NULL,135,2,40722,40737,13,4531,1,0,'2023-03-23','2023-03-23',2669636.19,1,1.00,'Factura A N°: 0003-00000209',NULL,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(136,7503,0,NULL,136,3,40722,40740,57,4531,2,0,'2023-03-01','2023-03-01',0.00,1,1.00,'Factura A N°: 1007-03582009',NULL,NULL,'2023-05-18 08:57:13','2023-05-18 09:14:17','2023-05-18 09:14:17'),(137,7503,0,NULL,137,3,40722,40765,57,4531,2,0,'2023-03-01','2023-03-01',287925.86,1,1.00,'Factura A N°: 0014-00051306',NULL,NULL,'2023-05-18 08:57:13','2023-05-18 09:13:53','2023-05-18 09:13:53'),(138,7503,0,NULL,138,3,40722,40741,57,4531,2,0,'2023-03-01','2023-03-01',13001.00,1,1.00,'Factura A N°: 0016-00092289',NULL,NULL,'2023-05-18 08:57:13','2023-05-18 09:13:12','2023-05-18 09:13:12'),(139,7503,0,NULL,139,3,40722,40766,57,4531,2,0,'2023-03-02','2023-03-02',119.00,1,1.00,'Factura C N°: 0061-00800125',NULL,NULL,'2023-05-18 08:57:13','2023-05-18 09:02:27','2023-05-18 09:02:27'),(140,7503,0,NULL,140,3,40722,40731,57,4531,2,0,'2023-03-02','2023-03-02',163.00,1,1.00,'Factura B N°: 0629-26861171',NULL,NULL,'2023-05-18 08:57:13','2023-05-18 09:02:17','2023-05-18 09:02:17'),(141,7503,0,NULL,141,3,40722,40767,57,4531,2,0,'2023-03-02','2023-03-02',163.00,1,1.00,'Factura B N°: 0711-30960047',NULL,NULL,'2023-05-18 08:57:13','2023-05-18 09:02:07','2023-05-18 09:02:07'),(142,7503,0,NULL,142,3,40722,40768,57,4531,2,0,'2023-03-02','2023-03-02',6884.00,1,1.00,'Factura A N°: 0006-00001072',NULL,NULL,'2023-05-18 08:57:13','2023-05-18 09:12:54','2023-05-18 09:12:54'),(143,7503,0,NULL,143,3,40722,40769,57,4531,2,0,'2023-03-02','2023-03-02',128680.60,1,1.00,'Factura A N°: 0125-00002528',NULL,NULL,'2023-05-18 08:57:13','2023-05-18 09:12:32','2023-05-18 09:12:32'),(144,7503,0,NULL,144,3,40722,40742,57,4531,2,0,'2023-03-02','2023-03-02',6046.74,1,1.00,'Factura A N°: 0001-00190502',NULL,NULL,'2023-05-18 08:57:13','2023-05-18 09:12:08','2023-05-18 09:12:08'),(145,7503,0,NULL,145,3,40722,40770,57,4531,2,0,'2023-03-03','2023-03-03',2185816.60,1,1.00,'Factura A N°: 0006-00000300',NULL,NULL,'2023-05-18 08:57:13','2023-05-18 09:11:34','2023-05-18 09:11:34');
INSERT INTO `cta_cte_cliente` VALUES (146,7503,0,NULL,146,3,40722,40719,57,4531,2,0,'2023-03-04','2023-03-04',5000.00,1,1.00,'RECIBO C N°: 0002-00000714',NULL,NULL,'2023-05-18 08:57:13','2023-05-18 09:01:47','2023-05-18 09:01:47'),(147,7503,0,NULL,147,3,40722,40719,57,4531,2,0,'2023-03-04','2023-03-04',5000.00,1,1.00,'RECIBO C N°: 0002-00000703',NULL,NULL,'2023-05-18 08:57:13','2023-05-18 09:01:33','2023-05-18 09:01:33'),(148,7503,0,NULL,148,3,40722,40771,57,4531,2,0,'2023-03-08','2023-03-08',6476.00,1,1.00,'Factura C N°: 0400-06025145',NULL,NULL,'2023-05-18 08:57:13','2023-05-18 09:01:13','2023-05-18 09:01:13'),(149,7503,0,NULL,149,3,40722,40743,57,4531,2,0,'2023-03-09','2023-03-09',46249.77,1,1.00,'Factura A N°: 0127-00001121',NULL,NULL,'2023-05-18 08:57:13','2023-05-18 09:10:46','2023-05-18 09:10:46'),(150,7503,0,NULL,150,3,40722,40772,57,4531,2,0,'2023-03-10','2023-03-10',24276.94,1,1.00,'Factura A N°: 0426-00000080',NULL,NULL,'2023-05-18 08:57:13','2023-05-18 09:09:49','2023-05-18 09:09:49'),(151,7503,0,NULL,151,3,40722,40773,57,4531,2,0,'2023-03-13','2023-03-13',4846.36,1,1.00,'Factura A N°: 0005-00011293',NULL,NULL,'2023-05-18 08:57:13','2023-05-18 08:57:13',NULL),(152,7503,0,NULL,152,3,40722,40719,57,4531,2,0,'2023-03-14','2023-03-14',5500.00,1,1.00,'RECIBO C N°: 0002-00000729',NULL,NULL,'2023-05-18 08:57:14','2023-05-18 09:00:54','2023-05-18 09:00:54'),(153,7503,0,NULL,153,3,40722,40774,57,4531,2,0,'2023-03-15','2023-03-15',40499.98,1,1.00,'Factura A N°: 0013-00003108',NULL,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(154,7503,0,NULL,154,3,40722,40774,57,4531,2,0,'2023-03-15','2023-03-15',40499.98,1,1.00,'Factura A N°: 0013-00003107',NULL,NULL,'2023-05-18 08:57:14','2023-05-18 09:07:22','2023-05-18 09:07:22'),(155,7503,0,NULL,155,3,40722,40743,57,4531,2,0,'2023-03-16','2023-03-16',7708.22,1,1.00,'Factura A N°: 0127-00001142',NULL,NULL,'2023-05-18 08:57:14','2023-05-18 09:06:30','2023-05-18 09:06:30'),(156,7503,0,NULL,156,3,40722,40775,57,4531,2,0,'2023-03-16','2023-03-16',5225.00,1,1.00,'Factura A N°: 2002-00052304',NULL,NULL,'2023-05-18 08:57:14','2023-05-18 09:05:45','2023-05-18 09:05:45'),(157,7503,0,NULL,157,3,40722,40731,57,4531,2,0,'2023-03-17','2023-03-17',95.00,1,1.00,'Factura B N°: 0629-27147531',NULL,NULL,'2023-05-18 08:57:14','2023-05-18 09:00:07','2023-05-18 09:00:07'),(158,7503,0,NULL,158,3,40722,40767,57,4531,2,0,'2023-03-17','2023-03-17',239.00,1,1.00,'Factura B N°: 0711-31395461',NULL,NULL,'2023-05-18 08:57:14','2023-05-18 09:00:17','2023-05-18 09:00:17'),(159,7503,0,NULL,159,3,40722,40776,57,4531,2,0,'2023-03-17','2023-03-17',68689.51,1,1.00,'Factura A N°: 0001-00007124',NULL,NULL,'2023-05-18 08:57:14','2023-05-18 09:04:23','2023-05-18 09:04:23'),(160,7503,0,NULL,160,3,40722,40777,57,4531,2,0,'2023-03-20','2023-03-20',1662.00,1,1.00,'Factura B N°: 0113-13303030',NULL,NULL,'2023-05-18 08:57:14','2023-05-18 08:59:56','2023-05-18 08:59:56'),(161,7503,0,NULL,161,3,40722,40778,57,4531,2,0,'2023-03-21','2023-03-21',30330.83,1,1.00,'Factura B N°: 0009-00000902',NULL,NULL,'2023-05-18 08:57:14','2023-05-18 08:59:47','2023-05-18 08:59:47'),(162,7503,0,NULL,162,3,40722,40779,57,4531,2,0,'2023-03-22','2023-03-22',1500.00,1,1.00,'Factura B N°: 0060-00205688',NULL,NULL,'2023-05-18 08:57:14','2023-05-18 09:00:36','2023-05-18 09:00:36'),(163,7503,0,NULL,163,3,40722,40780,57,4531,2,0,'2023-03-22','2023-03-22',14500.00,1,1.00,'Factura A N°: 0004-00006889',NULL,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(164,7503,0,NULL,164,3,40722,40781,57,4531,2,0,'2023-03-24','2023-03-24',15998.14,1,1.00,'Factura A N°: 0082-00003439',NULL,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(165,7503,0,NULL,165,3,40722,40782,57,4531,2,0,'2023-03-26','2023-03-26',762.00,1,1.00,'Factura B N°: 0062-00018537',NULL,NULL,'2023-05-18 08:57:14','2023-05-18 08:59:39','2023-05-18 08:59:39'),(166,7503,0,NULL,166,3,40722,40783,57,4531,2,0,'2023-03-27','2023-03-27',91250.00,1,1.00,'Factura A N°: 0011-00001372',NULL,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL);
INSERT INTO `cta_cte_cliente` VALUES (167,7503,0,NULL,167,3,40722,40784,57,4531,2,0,'2023-03-28','2023-03-28',10500.00,1,1.00,'Factura B N°: 0007-00012140',NULL,NULL,'2023-05-18 08:57:14','2023-05-18 08:59:29','2023-05-18 08:59:29'),(168,7503,0,NULL,168,3,40722,40776,57,4531,2,0,'2023-03-17','2023-03-17',68689.51,1,1.00,'Factura A N°: 0001-00007124',NULL,NULL,'2023-05-18 09:04:23','2023-05-18 09:04:23',NULL),(169,7503,0,NULL,169,3,40722,40775,57,4531,2,0,'2023-03-16','2023-03-16',5225.00,1,1.00,'Factura A N°: 2002-00052304',NULL,NULL,'2023-05-18 09:05:45','2023-05-18 09:05:45',NULL),(170,7503,0,NULL,170,3,40722,40743,57,4531,2,0,'2023-03-16','2023-03-16',7708.22,1,1.00,'Factura A N°: 0127-00001142',NULL,NULL,'2023-05-18 09:06:30','2023-05-18 09:06:30',NULL),(171,7503,0,NULL,171,3,40722,40774,57,4531,2,0,'2023-03-15','2023-03-15',40499.98,1,1.00,'Factura A N°: 0013-00003107',NULL,NULL,'2023-05-18 09:07:22','2023-05-18 09:07:22',NULL),(172,7503,0,NULL,172,3,40722,40743,57,4531,2,0,'2023-03-09','2023-03-09',46249.77,1,1.00,'Factura A N°: 0127-00001121',NULL,NULL,'2023-05-18 09:10:46','2023-05-18 09:10:46',NULL),(173,7503,0,NULL,173,3,40722,40770,57,4531,2,0,'2023-03-03','2023-03-03',2185816.60,1,1.00,'Factura A N°: 0006-00000300',NULL,NULL,'2023-05-18 09:11:34','2023-05-18 09:11:34',NULL),(174,7503,0,NULL,174,3,40722,40742,57,4531,2,0,'2023-03-02','2023-03-02',6046.74,1,1.00,'Factura A N°: 0001-00190502',NULL,NULL,'2023-05-18 09:12:08','2023-05-18 09:12:08',NULL),(175,7503,0,NULL,175,3,40722,40769,57,4531,2,0,'2023-03-02','2023-03-02',128680.60,1,1.00,'Factura A N°: 0125-00002528',NULL,NULL,'2023-05-18 09:12:32','2023-05-18 09:12:32',NULL),(176,7503,0,NULL,176,3,40722,40768,57,4531,2,0,'2023-03-02','2023-03-02',6884.00,1,1.00,'Factura A N°: 0006-00001072',NULL,NULL,'2023-05-18 09:12:54','2023-05-18 09:12:54',NULL),(177,7503,0,NULL,177,3,40722,40741,57,4531,2,0,'2023-03-01','2023-03-01',13001.00,1,1.00,'Factura A N°: 0016-00092289',NULL,NULL,'2023-05-18 09:13:12','2023-05-18 09:13:12',NULL),(178,7503,0,NULL,178,3,40722,40785,57,4531,2,0,'2023-03-04','2023-03-04',652.12,1,1.00,'Factura A N°: 0001-00885319',NULL,NULL,'2023-05-18 09:16:47','2023-05-18 09:23:56','2023-05-18 09:23:56'),(179,7503,0,NULL,179,3,40722,40785,57,4531,2,0,'2023-03-24','2023-03-24',61441.77,1,1.00,'Factura A N°: 0001-00891806',NULL,NULL,'2023-05-18 09:18:51','2023-05-18 09:18:51',NULL),(180,7503,0,NULL,180,3,40722,40741,57,4531,2,0,'2023-02-01','2023-02-01',12076.00,1,1.00,'Factura A N°: 0016-00091147',NULL,NULL,'2023-05-18 09:21:27','2023-05-18 09:21:27',NULL),(181,7503,0,NULL,181,3,40722,40786,57,4531,2,0,'2023-02-02','2023-02-02',6741.19,1,1.00,'Factura A N°: 0007-00022014',NULL,NULL,'2023-05-18 09:23:12','2023-05-18 09:23:12',NULL),(182,7503,0,NULL,182,3,40722,40785,57,4531,2,0,'2023-03-04','2023-03-04',62775.80,1,1.00,'Factura A N°: 0001-00885319',NULL,NULL,'2023-05-18 09:23:56','2023-05-18 09:23:56',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_details`
--

DROP TABLE IF EXISTS `cta_cte_cliente_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_details_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_cliente_details_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_details_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_details_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_details_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_details`
--

LOCK TABLES `cta_cte_cliente_details` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_pivot_receipt`
--

DROP TABLE IF EXISTS `cta_cte_cliente_pivot_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_pivot_receipt` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `receipt_id` int(11) DEFAULT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `is_a_cuenta` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `cccpr_a_cuenta_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_cccpr_a_cuenta_id` (`cccpr_a_cuenta_id`),
  CONSTRAINT `fk_cccpr_a_cuenta_id` FOREIGN KEY (`cccpr_a_cuenta_id`) REFERENCES `cta_cte_cliente_pivot_receipt` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=183 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_pivot_receipt`
--

LOCK TABLES `cta_cte_cliente_pivot_receipt` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (1,7503,1,1,NULL,0,NULL,'2023-02-06 10:22:33','2023-02-06 10:22:33',NULL),(2,7503,2,2,NULL,0,NULL,'2023-02-06 10:22:33','2023-02-09 15:08:26','2023-02-09 15:08:26'),(3,7503,3,3,NULL,0,NULL,'2023-02-06 10:24:44','2023-02-06 10:24:44',NULL),(4,7503,4,4,NULL,0,NULL,'2023-02-06 10:24:44','2023-02-06 10:24:44',NULL),(5,7503,5,5,NULL,0,NULL,'2023-02-06 10:26:06','2023-02-06 10:26:06',NULL),(6,7503,6,6,NULL,0,NULL,'2023-02-06 10:26:06','2023-02-06 10:26:06',NULL),(7,7503,7,7,NULL,0,NULL,'2023-02-06 10:26:06','2023-02-06 10:26:06',NULL),(8,7503,8,8,NULL,0,NULL,'2023-02-06 10:26:06','2023-02-06 10:26:06',NULL),(9,7503,9,9,NULL,0,NULL,'2023-02-06 10:26:06','2023-02-06 10:26:06',NULL),(10,7503,10,10,NULL,0,NULL,'2023-02-06 10:26:06','2023-02-06 10:26:06',NULL),(11,7503,11,11,NULL,0,NULL,'2023-02-06 10:26:06','2023-02-06 10:26:06',NULL),(12,7503,12,12,NULL,0,NULL,'2023-02-06 10:31:07','2023-02-06 10:31:07',NULL),(13,7503,13,13,NULL,0,NULL,'2023-02-06 10:31:08','2023-02-07 14:39:42','2023-02-07 14:39:42'),(14,7503,14,14,NULL,0,NULL,'2023-02-06 10:31:08','2023-02-06 10:31:08',NULL),(15,7503,15,15,NULL,0,NULL,'2023-02-06 10:31:08','2023-02-06 10:31:08',NULL),(16,7503,16,16,NULL,0,NULL,'2023-02-06 10:31:08','2023-02-06 10:31:08',NULL),(17,7503,17,17,NULL,0,NULL,'2023-02-06 10:31:08','2023-02-06 10:31:08',NULL),(18,7503,18,18,NULL,0,NULL,'2023-02-06 10:31:08','2023-02-07 14:40:23','2023-02-07 14:40:23'),(19,7503,19,19,NULL,0,NULL,'2023-02-06 10:31:45','2023-02-06 10:31:45',NULL),(20,7503,20,20,NULL,0,NULL,'2023-02-06 10:31:45','2023-02-06 10:31:45',NULL),(21,7503,21,21,NULL,0,NULL,'2023-02-06 10:31:45','2023-02-06 10:31:45',NULL),(22,7503,22,22,NULL,0,NULL,'2023-02-06 10:31:45','2023-02-06 10:31:45',NULL),(23,7503,23,23,NULL,0,NULL,'2023-02-06 10:31:45','2023-02-06 10:31:45',NULL),(24,7503,24,24,NULL,0,NULL,'2023-02-06 10:31:45','2023-02-06 10:31:45',NULL),(25,7503,25,25,NULL,0,NULL,'2023-02-06 10:31:45','2023-02-06 10:31:45',NULL),(26,7503,26,26,NULL,0,NULL,'2023-02-06 10:31:45','2023-02-06 10:31:45',NULL),(27,7503,27,13,NULL,0,NULL,'2023-02-07 14:39:42','2023-02-07 14:39:42',NULL),(28,7503,28,18,NULL,0,NULL,'2023-02-07 14:40:23','2023-02-07 14:40:23',NULL),(29,7503,29,2,NULL,0,NULL,'2023-02-09 15:08:26','2023-02-09 15:08:26',NULL),(30,7503,30,31,NULL,0,NULL,'2023-02-09 15:31:05','2023-02-09 15:31:05',NULL),(31,7503,31,32,NULL,0,NULL,'2023-02-09 15:31:05','2023-02-09 15:35:18','2023-02-09 15:35:18'),(32,7503,32,33,NULL,0,NULL,'2023-02-09 15:31:05','2023-02-09 15:31:05',NULL),(33,7503,33,34,NULL,0,NULL,'2023-02-09 15:31:06','2023-02-09 15:31:06',NULL),(34,7503,34,35,NULL,0,NULL,'2023-02-09 15:31:06','2023-02-09 15:31:06',NULL),(35,7503,35,36,NULL,0,NULL,'2023-02-09 15:31:06','2023-02-09 15:31:06',NULL),(36,7503,36,37,NULL,0,NULL,'2023-02-09 15:31:06','2023-02-09 15:33:13','2023-02-09 15:33:13'),(37,7503,37,37,NULL,0,NULL,'2023-02-09 15:33:13','2023-02-09 15:34:42','2023-02-09 15:34:42'),(38,7503,38,37,NULL,0,NULL,'2023-02-09 15:34:42','2023-02-09 15:34:42',NULL),(39,7503,39,32,NULL,0,NULL,'2023-02-09 15:35:18','2023-02-09 15:35:18',NULL),(40,7503,40,38,NULL,0,NULL,'2023-02-09 15:43:51','2023-02-09 15:43:51',NULL),(41,7503,41,39,NULL,0,NULL,'2023-02-09 15:43:51','2023-02-09 15:44:21','2023-02-09 15:44:21'),(42,7503,42,39,NULL,0,NULL,'2023-02-09 15:44:21','2023-02-09 15:44:21',NULL),(43,7503,43,40,NULL,0,NULL,'2023-02-09 16:16:04','2023-02-09 16:16:04',NULL),(44,7503,44,41,NULL,0,NULL,'2023-02-09 16:16:04','2023-02-09 16:17:36','2023-02-09 16:17:36'),(45,7503,45,42,NULL,0,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:05',NULL),(46,7503,46,43,NULL,0,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:05',NULL),(47,7503,47,44,NULL,0,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:05',NULL),(48,7503,48,45,NULL,0,NULL,'2023-02-09 16:16:05','2023-02-09 16:16:05',NULL),(49,7503,49,46,NULL,0,NULL,'2023-02-09 16:16:05','2023-02-09 16:17:08','2023-02-09 16:17:08'),(50,7503,50,46,NULL,0,NULL,'2023-02-09 16:17:08','2023-02-09 16:17:08',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (51,7503,51,41,NULL,0,NULL,'2023-02-09 16:17:36','2023-02-09 16:17:36',NULL),(52,7503,52,47,NULL,0,NULL,'2023-02-09 16:48:36','2023-02-09 16:48:36',NULL),(53,7503,53,48,NULL,0,NULL,'2023-02-09 16:48:36','2023-02-09 16:48:36',NULL),(54,7503,54,49,NULL,0,NULL,'2023-02-09 16:51:04','2023-02-09 16:53:01','2023-02-09 16:53:01'),(55,7503,55,50,NULL,0,NULL,'2023-02-09 16:51:04','2023-02-09 16:59:46','2023-02-09 16:59:46'),(56,7503,56,49,NULL,0,NULL,'2023-02-09 16:53:01','2023-02-09 16:53:01',NULL),(57,7503,57,50,NULL,0,NULL,'2023-02-09 16:59:46','2023-02-09 16:59:46',NULL),(58,7503,58,51,NULL,0,NULL,'2023-02-09 17:26:29','2023-02-09 17:26:29',NULL),(59,7503,59,52,NULL,0,NULL,'2023-02-09 17:26:29','2023-02-09 17:26:29',NULL),(60,7503,60,53,NULL,0,NULL,'2023-02-09 17:26:29','2023-02-09 17:26:29',NULL),(61,7503,61,54,NULL,0,NULL,'2023-02-09 17:26:29','2023-02-09 17:26:29',NULL),(62,7503,62,55,NULL,0,NULL,'2023-02-09 17:26:29','2023-02-09 17:26:29',NULL),(63,7503,63,56,NULL,0,NULL,'2023-02-09 17:26:29','2023-02-09 17:26:29',NULL),(64,7503,64,57,NULL,0,NULL,'2023-02-09 17:42:44','2023-02-09 17:42:44',NULL),(65,7503,65,58,NULL,0,NULL,'2023-02-09 17:42:44','2023-02-09 17:42:44',NULL),(66,7503,66,59,NULL,0,NULL,'2023-02-09 17:42:44','2023-02-09 17:42:44',NULL),(67,7503,67,60,NULL,0,NULL,'2023-02-09 17:42:44','2023-02-09 17:42:44',NULL),(68,7503,68,61,NULL,0,NULL,'2023-02-09 17:42:44','2023-02-09 17:43:34','2023-02-09 17:43:34'),(69,7503,69,62,NULL,0,NULL,'2023-02-09 17:42:44','2023-02-09 17:42:44',NULL),(70,7503,70,63,NULL,0,NULL,'2023-02-09 17:42:44','2023-02-09 17:42:44',NULL),(71,7503,71,64,NULL,0,NULL,'2023-02-09 17:42:44','2023-02-09 17:44:15','2023-02-09 17:44:15'),(72,7503,72,61,NULL,0,NULL,'2023-02-09 17:43:34','2023-02-09 17:43:34',NULL),(73,7503,73,64,NULL,0,NULL,'2023-02-09 17:44:15','2023-02-09 17:48:14','2023-02-09 17:48:14'),(74,7503,74,64,NULL,0,NULL,'2023-02-09 17:48:14','2023-02-09 17:48:14',NULL),(75,7503,75,65,NULL,0,NULL,'2023-02-10 15:45:44','2023-02-10 15:45:44',NULL),(76,7503,76,66,NULL,0,NULL,'2023-02-10 15:45:44','2023-02-10 15:45:44',NULL),(77,7503,77,67,NULL,0,NULL,'2023-02-10 15:46:31','2023-02-10 15:47:46','2023-02-10 15:47:46'),(78,7503,78,68,NULL,0,NULL,'2023-02-10 15:46:31','2023-02-10 16:01:42','2023-02-10 16:01:42'),(79,7503,79,67,NULL,0,NULL,'2023-02-10 15:47:46','2023-02-10 15:47:46',NULL),(80,7503,80,68,NULL,0,NULL,'2023-02-10 16:01:42','2023-02-10 16:01:42',NULL),(81,7503,81,69,NULL,0,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(82,7503,82,70,NULL,0,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(83,7503,83,71,NULL,0,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(84,7503,84,72,NULL,0,NULL,'2023-03-21 10:02:48','2023-03-21 10:02:48',NULL),(85,7503,85,73,NULL,0,NULL,'2023-03-21 10:02:49','2023-03-21 10:02:49',NULL),(86,7503,86,74,NULL,0,NULL,'2023-03-21 10:02:49','2023-03-21 10:02:49',NULL),(87,7503,87,75,NULL,0,NULL,'2023-03-21 10:02:49','2023-03-21 10:02:49',NULL),(88,7503,88,76,NULL,0,NULL,'2023-03-21 10:02:49','2023-03-21 10:02:49',NULL),(89,7503,89,77,NULL,0,NULL,'2023-03-21 10:06:12','2023-03-21 10:12:36','2023-03-21 10:12:36'),(90,7503,90,78,NULL,0,NULL,'2023-03-21 10:06:12','2023-03-21 10:12:03','2023-03-21 10:12:03'),(91,7503,91,79,NULL,0,NULL,'2023-03-21 10:06:12','2023-03-21 10:11:38','2023-03-21 10:11:38'),(92,7503,92,80,NULL,0,NULL,'2023-03-21 10:06:12','2023-03-21 10:06:12',NULL),(93,7503,93,81,NULL,0,NULL,'2023-03-21 10:06:13','2023-03-21 10:06:13',NULL),(94,7503,94,82,NULL,0,NULL,'2023-03-21 10:06:13','2023-03-21 10:06:13',NULL),(95,7503,95,83,NULL,0,NULL,'2023-03-21 10:06:13','2023-03-21 10:11:04','2023-03-21 10:11:04'),(96,7503,96,84,NULL,0,NULL,'2023-03-21 10:06:13','2023-03-21 10:06:13',NULL),(97,7503,97,85,NULL,0,NULL,'2023-03-21 10:06:13','2023-03-21 10:09:47','2023-03-21 10:09:47'),(98,7503,98,86,NULL,0,NULL,'2023-03-21 10:06:13','2023-03-21 10:09:29','2023-03-21 10:09:29');
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (99,7503,99,87,NULL,0,NULL,'2023-03-21 10:06:13','2023-03-21 10:09:03','2023-03-21 10:09:03'),(100,7503,100,87,NULL,0,NULL,'2023-03-21 10:09:03','2023-03-21 10:09:03',NULL),(101,7503,101,86,NULL,0,NULL,'2023-03-21 10:09:29','2023-03-21 10:09:29',NULL),(102,7503,102,85,NULL,0,NULL,'2023-03-21 10:09:47','2023-03-21 10:09:47',NULL),(103,7503,103,83,NULL,0,NULL,'2023-03-21 10:11:04','2023-03-21 10:11:04',NULL),(104,7503,104,79,NULL,0,NULL,'2023-03-21 10:11:38','2023-03-21 10:11:38',NULL),(105,7503,105,78,NULL,0,NULL,'2023-03-21 10:12:03','2023-03-21 10:12:03',NULL),(106,7503,106,77,NULL,0,NULL,'2023-03-21 10:12:36','2023-03-21 10:12:36',NULL),(107,7503,107,88,NULL,0,NULL,'2023-03-21 10:16:27','2023-03-21 10:16:27',NULL),(108,7503,108,91,NULL,0,NULL,'2023-03-21 12:40:38','2023-03-21 12:40:38',NULL),(109,7503,109,92,NULL,0,NULL,'2023-03-21 12:40:38','2023-03-21 12:40:38',NULL),(110,7503,110,93,NULL,0,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(111,7503,111,94,NULL,0,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(112,7503,112,95,NULL,0,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(113,7503,113,96,NULL,0,NULL,'2023-03-21 12:41:00','2023-03-21 12:44:25','2023-03-21 12:44:25'),(114,7503,114,97,NULL,0,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(115,7503,115,98,NULL,0,NULL,'2023-03-21 12:41:00','2023-03-21 12:44:08','2023-03-21 12:44:08'),(116,7503,116,99,NULL,0,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(117,7503,117,100,NULL,0,NULL,'2023-03-21 12:41:00','2023-03-21 12:41:00',NULL),(118,7503,118,101,NULL,0,NULL,'2023-03-21 12:41:00','2023-03-21 12:43:41','2023-03-21 12:43:41'),(119,7503,119,102,NULL,0,NULL,'2023-03-21 12:41:01','2023-03-21 12:41:01',NULL),(120,7503,120,103,NULL,0,NULL,'2023-03-21 12:41:01','2023-03-21 12:41:01',NULL),(121,7503,121,104,NULL,0,NULL,'2023-03-21 12:41:01','2023-03-21 12:43:12','2023-03-21 12:43:12'),(122,7503,122,104,NULL,0,NULL,'2023-03-21 12:43:12','2023-03-21 12:43:12',NULL),(123,7503,123,101,NULL,0,NULL,'2023-03-21 12:43:41','2023-03-21 12:43:41',NULL),(124,7503,124,98,NULL,0,NULL,'2023-03-21 12:44:08','2023-03-21 12:44:08',NULL),(125,7503,125,96,NULL,0,NULL,'2023-03-21 12:44:25','2023-03-21 12:44:25',NULL),(126,7503,126,105,NULL,0,NULL,'2023-03-21 12:46:28','2023-03-21 12:46:28',NULL),(127,7503,127,106,NULL,0,NULL,'2023-03-21 12:48:27','2023-03-21 12:48:27',NULL),(128,7503,128,107,NULL,0,NULL,'2023-03-21 12:49:18','2023-03-21 12:49:18',NULL),(129,7503,129,108,NULL,0,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(130,7503,130,109,NULL,0,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(131,7503,131,110,NULL,0,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(132,7503,132,111,NULL,0,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(133,7503,133,112,NULL,0,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(134,7503,134,113,NULL,0,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(135,7503,135,114,NULL,0,NULL,'2023-05-18 08:56:41','2023-05-18 08:56:41',NULL),(136,7503,136,115,NULL,0,NULL,'2023-05-18 08:57:13','2023-05-18 08:57:13',NULL),(137,7503,137,116,NULL,0,NULL,'2023-05-18 08:57:13','2023-05-18 08:57:13',NULL),(138,7503,138,117,NULL,0,NULL,'2023-05-18 08:57:13','2023-05-18 09:13:12','2023-05-18 09:13:12'),(139,7503,139,118,NULL,0,NULL,'2023-05-18 08:57:13','2023-05-18 08:57:13',NULL),(140,7503,140,119,NULL,0,NULL,'2023-05-18 08:57:13','2023-05-18 08:57:13',NULL),(141,7503,141,120,NULL,0,NULL,'2023-05-18 08:57:13','2023-05-18 08:57:13',NULL),(142,7503,142,121,NULL,0,NULL,'2023-05-18 08:57:13','2023-05-18 09:12:54','2023-05-18 09:12:54'),(143,7503,143,122,NULL,0,NULL,'2023-05-18 08:57:13','2023-05-18 09:12:32','2023-05-18 09:12:32'),(144,7503,144,123,NULL,0,NULL,'2023-05-18 08:57:13','2023-05-18 09:12:08','2023-05-18 09:12:08'),(145,7503,145,124,NULL,0,NULL,'2023-05-18 08:57:13','2023-05-18 09:11:34','2023-05-18 09:11:34'),(146,7503,146,125,NULL,0,NULL,'2023-05-18 08:57:13','2023-05-18 08:57:13',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (147,7503,147,126,NULL,0,NULL,'2023-05-18 08:57:13','2023-05-18 08:57:13',NULL),(148,7503,148,127,NULL,0,NULL,'2023-05-18 08:57:13','2023-05-18 08:57:13',NULL),(149,7503,149,128,NULL,0,NULL,'2023-05-18 08:57:13','2023-05-18 09:10:46','2023-05-18 09:10:46'),(150,7503,150,129,NULL,0,NULL,'2023-05-18 08:57:13','2023-05-18 08:57:13',NULL),(151,7503,151,130,NULL,0,NULL,'2023-05-18 08:57:13','2023-05-18 08:57:13',NULL),(152,7503,152,131,NULL,0,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(153,7503,153,132,NULL,0,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(154,7503,154,133,NULL,0,NULL,'2023-05-18 08:57:14','2023-05-18 09:07:22','2023-05-18 09:07:22'),(155,7503,155,134,NULL,0,NULL,'2023-05-18 08:57:14','2023-05-18 09:06:30','2023-05-18 09:06:30'),(156,7503,156,135,NULL,0,NULL,'2023-05-18 08:57:14','2023-05-18 09:05:45','2023-05-18 09:05:45'),(157,7503,157,136,NULL,0,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(158,7503,158,137,NULL,0,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(159,7503,159,138,NULL,0,NULL,'2023-05-18 08:57:14','2023-05-18 09:04:23','2023-05-18 09:04:23'),(160,7503,160,139,NULL,0,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(161,7503,161,140,NULL,0,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(162,7503,162,141,NULL,0,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(163,7503,163,142,NULL,0,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(164,7503,164,143,NULL,0,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(165,7503,165,144,NULL,0,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(166,7503,166,145,NULL,0,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(167,7503,167,146,NULL,0,NULL,'2023-05-18 08:57:14','2023-05-18 08:57:14',NULL),(168,7503,168,138,NULL,0,NULL,'2023-05-18 09:04:23','2023-05-18 09:04:23',NULL),(169,7503,169,135,NULL,0,NULL,'2023-05-18 09:05:45','2023-05-18 09:05:45',NULL),(170,7503,170,134,NULL,0,NULL,'2023-05-18 09:06:30','2023-05-18 09:06:30',NULL),(171,7503,171,133,NULL,0,NULL,'2023-05-18 09:07:22','2023-05-18 09:07:22',NULL),(172,7503,172,128,NULL,0,NULL,'2023-05-18 09:10:46','2023-05-18 09:10:46',NULL),(173,7503,173,124,NULL,0,NULL,'2023-05-18 09:11:34','2023-05-18 09:11:34',NULL),(174,7503,174,123,NULL,0,NULL,'2023-05-18 09:12:08','2023-05-18 09:12:08',NULL),(175,7503,175,122,NULL,0,NULL,'2023-05-18 09:12:32','2023-05-18 09:12:32',NULL),(176,7503,176,121,NULL,0,NULL,'2023-05-18 09:12:54','2023-05-18 09:12:54',NULL),(177,7503,177,117,NULL,0,NULL,'2023-05-18 09:13:12','2023-05-18 09:13:12',NULL),(178,7503,178,147,NULL,0,NULL,'2023-05-18 09:16:47','2023-05-18 09:23:56','2023-05-18 09:23:56'),(179,7503,179,148,NULL,0,NULL,'2023-05-18 09:18:51','2023-05-18 09:18:51',NULL),(180,7503,180,149,NULL,0,NULL,'2023-05-18 09:21:27','2023-05-18 09:21:27',NULL),(181,7503,181,150,NULL,0,NULL,'2023-05-18 09:23:12','2023-05-18 09:23:12',NULL),(182,7503,182,147,NULL,0,NULL,'2023-05-18 09:23:56','2023-05-18 09:23:56',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bind_apibank_movement_id` bigint(20) unsigned DEFAULT NULL COMMENT 'FK soft a bind_apibank_movements (movimiento que originó este registro)',
  `bind_apibank_transfer_id` bigint(20) unsigned DEFAULT NULL COMMENT 'FK soft a bind_apibank_transfers (transferencia que originó este registro)',
  `bind_sync_status` enum('pending','synced','error') COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Estado de sincronización: pending=pendiente, synced=sincronizado, error=error al sincronizar',
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `ticket_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `cta_cte_tesoreria_moneda_id_foreign` (`moneda_id`),
  KEY `cta_cte_tesoreria_ticket_id_foreign` (`ticket_id`),
  KEY `idx_cct_bind_apibank_mov` (`bind_apibank_movement_id`),
  KEY `idx_cct_bind_apibank_trf` (`bind_apibank_transfer_id`),
  KEY `idx_cct_bind_sync_status` (`bind_sync_status`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `cta_cte_tesoreria_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_ticket_id_foreign` FOREIGN KEY (`ticket_id`) REFERENCES `tickets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria`
--

LOCK TABLES `cta_cte_tesoreria` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_cheq`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_cheq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_cheq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `chequera_tipo_id` int(10) unsigned NOT NULL,
  `serie` text COLLATE utf8mb4_unicode_ci,
  `numero_cheque` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_cheq_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` (`cta_cte_tesoreria_banco_id`),
  KEY `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` (`chequera_tipo_id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` FOREIGN KEY (`chequera_tipo_id`) REFERENCES `chequeras_tipos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_cheq`
--

LOCK TABLES `cta_cte_tesoreria_banco_cheq` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_claves`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `descripcion_name` text COLLATE utf8mb4_unicode_ci,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_claves_person_id_foreign` (`person_id`),
  KEY `ct_cuenta_id` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ct_banco_id` (`cta_cte_tesoreria_banco_id`),
  CONSTRAINT `ct_banco_id` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `ct_cuenta_id` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_claves_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_claves`
--

LOCK TABLES `cta_cte_tesoreria_banco_claves` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_claves` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_comentarios`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_comentarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_comentarios` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `fecha` datetime NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_comentarios_person_id_foreign` (`person_id`),
  KEY `ct_cuentas_id` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ct_bancos_id` (`cta_cte_tesoreria_banco_id`),
  CONSTRAINT `ct_bancos_id` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `ct_cuentas_id` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_comentarios_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_comentarios`
--

LOCK TABLES `cta_cte_tesoreria_banco_comentarios` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_comentarios` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_comentarios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_estados`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_estados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_estados` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_estados`
--

LOCK TABLES `cta_cte_tesoreria_banco_estados` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_estados` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_banco_estados` VALUES (1,NULL,'Habilitado',0,NULL,NULL,NULL),(2,NULL,'En Proceso',0,NULL,NULL,NULL),(3,NULL,'Bloqueado',0,NULL,NULL,NULL),(4,NULL,'Reconocimiento',0,NULL,NULL,NULL),(5,NULL,'Inhabilitado',0,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_estados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_bancos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `ctacte_banco_id` int(10) unsigned NOT NULL,
  `persona_empresa` int(11) NOT NULL DEFAULT '1',
  `zone_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id_diferido` int(10) unsigned DEFAULT NULL,
  `cuenta_contable_id_pend_acred` int(10) unsigned DEFAULT NULL,
  `numero_cuenta` text COLLATE utf8mb4_unicode_ci,
  `cbu` text COLLATE utf8mb4_unicode_ci,
  `alias` text COLLATE utf8mb4_unicode_ci,
  `cta_cte_tesoreria_banco_estado_id` int(10) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_bancos_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` (`ctacte_banco_id`),
  KEY `cta_cte_tesoreria_bancos_zone_id_foreign` (`zone_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` (`cuenta_contable_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` (`cuenta_contable_id_diferido`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` (`cuenta_contable_id_pend_acred`),
  KEY `cta_cte_tesoreria_bancos_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `ct_banco_estado_id` (`cta_cte_tesoreria_banco_estado_id`),
  CONSTRAINT `ct_banco_estado_id` FOREIGN KEY (`cta_cte_tesoreria_banco_estado_id`) REFERENCES `cta_cte_tesoreria_banco_estados` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` FOREIGN KEY (`ctacte_banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` FOREIGN KEY (`cuenta_contable_id_diferido`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` FOREIGN KEY (`cuenta_contable_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` FOREIGN KEY (`cuenta_contable_id_pend_acred`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_bancos`
--

LOCK TABLES `cta_cte_tesoreria_bancos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuenta_tipos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuenta_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuenta_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuenta_tipos`
--

LOCK TABLES `cta_cte_tesoreria_cuenta_tipos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuenta_tipos` VALUES (1,NULL,'CAJA',1,NULL,NULL,NULL),(2,NULL,'BANCOS',1,NULL,NULL,NULL),(3,NULL,'CHEQUES',1,NULL,NULL,NULL),(4,NULL,'RETENCIONES EFECTUADAS',1,NULL,'2024-05-26 20:58:26',NULL),(5,NULL,'PERCEPCIONES EFECTUADAS',1,NULL,'2024-05-26 20:58:26',NULL),(6,NULL,'RESULTADO NEGATIVO',1,NULL,NULL,NULL),(7,NULL,'RESULTADO POSITIVO',1,NULL,NULL,NULL),(8,NULL,'MOVIMIENTO',1,NULL,NULL,NULL),(9,NULL,'RETENCIONES SUFRIDAS',1,NULL,NULL,NULL),(10,NULL,'PERCEPCIONES SUFRIDAS',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuentas`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bind_apibank_enabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Tiene Bind APIBank habilitado?',
  `bind_account_id` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'ID de cuenta en Bind APIBank (obtenido al configurar)',
  `user_id` int(10) unsigned DEFAULT NULL,
  `is_no_fiscal` tinyint(1) DEFAULT '0',
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_tipo_id` int(10) unsigned NOT NULL DEFAULT '8',
  `retention_type_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cuit` text COLLATE utf8mb4_unicode_ci,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_cuentas_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `cta_tes_tipo_id_foreign` (`cta_cte_tesoreria_cuenta_tipo_id`),
  KEY `cta_cte_tesoreria_cuentas_moneda_id_foreign` (`moneda_id`),
  KEY `cta_cte_tesoreria_cuentas_retention_type_id_foreign` (`retention_type_id`),
  KEY `idx_cctc_bind_apibank_enabled` (`bind_apibank_enabled`),
  KEY `idx_cctc_bind_account_id` (`bind_account_id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_retention_type_id_foreign` FOREIGN KEY (`retention_type_id`) REFERENCES `retention_types` (`id`),
  CONSTRAINT `cta_tes_tipo_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_tipo_id`) REFERENCES `cta_cte_tesoreria_cuenta_tipos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=757 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuentas`
--

LOCK TABLES `cta_cte_tesoreria_cuentas` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (13,0,NULL,NULL,0,1,13,NULL,8,NULL,'Clientes - Deudores',NULL,0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(20,0,NULL,NULL,0,1,20,NULL,8,NULL,'Anticipos Impuesto a las Ganancias',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(23,0,NULL,NULL,0,1,23,NULL,4,NULL,'Retenciones Impuesto a las Ganancias',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(25,0,NULL,NULL,0,1,25,NULL,4,NULL,'Retenciones de IVA',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(57,0,NULL,NULL,0,1,57,NULL,8,NULL,'Proveedores en Cta. Cte. locales',NULL,0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(60,0,NULL,NULL,0,1,60,NULL,3,NULL,'Cheques emitidos ',NULL,0,1,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(62,0,NULL,NULL,0,1,62,NULL,8,NULL,'Sueldos y Jornales a pagar',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(140,0,NULL,NULL,0,1,140,NULL,6,NULL,'Intereses y Gastos bancarios',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(162,0,NULL,NULL,0,1,162,NULL,4,NULL,'Retenciones SUSS',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(176,0,NULL,NULL,0,1,176,NULL,3,NULL,'Cheques en Cartera',NULL,1,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(201,0,NULL,NULL,0,1,201,NULL,6,NULL,'Monotributo',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(203,0,NULL,NULL,0,1,203,NULL,6,NULL,'Autonomos',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(219,0,NULL,NULL,0,1,219,NULL,8,NULL,'Pagos AFIP',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(251,0,NULL,NULL,0,1,251,NULL,4,NULL,'Retenciones de IIBB Buenos Aires',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(252,0,NULL,NULL,0,1,252,NULL,4,NULL,'Retenciones de IIBB Capital Federal',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(253,0,NULL,NULL,0,1,253,NULL,4,NULL,'Retenciones de IIBB Catamarca',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(254,0,NULL,NULL,0,1,254,NULL,4,NULL,'Retenciones de IIBB Chaco',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(255,0,NULL,NULL,0,1,255,NULL,4,NULL,'Retenciones de IIBB Chubut',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(256,0,NULL,NULL,0,1,256,NULL,4,NULL,'Retenciones de IIBB Córdoba',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(257,0,NULL,NULL,0,1,257,NULL,4,NULL,'Retenciones de IIBB Corrientes',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(258,0,NULL,NULL,0,1,258,NULL,4,NULL,'Retenciones de IIBB Entre Ríos',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(259,0,NULL,NULL,0,1,259,NULL,4,NULL,'Retenciones de IIBB Formosa',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(260,0,NULL,NULL,0,1,260,NULL,4,NULL,'Retenciones de IIBB Jujuy',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(261,0,NULL,NULL,0,1,261,NULL,4,NULL,'Retenciones de IIBB La Pampa',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(262,0,NULL,NULL,0,1,262,NULL,4,NULL,'Retenciones de IIBB La Rioja',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(263,0,NULL,NULL,0,1,263,NULL,4,NULL,'Retenciones de IIBB Mendoza',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(264,0,NULL,NULL,0,1,264,NULL,4,NULL,'Retenciones de IIBB Misiones',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(265,0,NULL,NULL,0,1,265,NULL,4,NULL,'Retenciones de IIBB Neuquén',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(266,0,NULL,NULL,0,1,266,NULL,4,NULL,'Retenciones de IIBB Pascua Lama',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (267,0,NULL,NULL,0,1,267,NULL,4,NULL,'Retenciones de IIBB Río Negro',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(268,0,NULL,NULL,0,1,268,NULL,4,NULL,'Retenciones de IIBB Salta',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(269,0,NULL,NULL,0,1,269,NULL,4,NULL,'Retenciones de IIBB San Juan',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(270,0,NULL,NULL,0,1,270,NULL,4,NULL,'Retenciones de IIBB San Luis',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(271,0,NULL,NULL,0,1,271,NULL,4,NULL,'Retenciones de IIBB Santa Cruz',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(272,0,NULL,NULL,0,1,272,NULL,4,NULL,'Retenciones de IIBB Santa Fe',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(273,0,NULL,NULL,0,1,273,NULL,4,NULL,'Retenciones de IIBB Santiago del Estero',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(274,0,NULL,NULL,0,1,274,NULL,4,NULL,'Retenciones de IIBB Tierra del Fuego',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(275,0,NULL,NULL,0,1,275,NULL,4,NULL,'Retenciones de IIBB Tucuman',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(351,0,NULL,NULL,0,1,351,NULL,8,NULL,'BANCO SIRCREB',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(359,0,NULL,NULL,0,1,359,NULL,8,NULL,'Caja en Pesos',NULL,0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:13:09','2023-03-20 23:13:09'),(360,0,NULL,NULL,0,1,360,NULL,8,NULL,'Retenciones Bancarias de Ganancias a Favor',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(364,0,NULL,NULL,0,1,364,NULL,8,NULL,'Anticipo de Clientes',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(384,0,NULL,NULL,0,1,384,NULL,8,NULL,'Caja en Dolares',NULL,0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:13:09','2023-03-20 23:13:09'),(409,0,NULL,NULL,0,1,409,NULL,6,NULL,'IVA Crédito Fiscal No computable',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(418,0,NULL,NULL,0,1,418,NULL,8,NULL,'Deudas Bancarias',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(433,0,NULL,NULL,0,1,433,NULL,8,NULL,'Préstamo',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(441,0,NULL,NULL,0,1,441,NULL,8,NULL,'Leasing',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(448,0,NULL,NULL,0,1,448,NULL,8,NULL,'Planes de Pagos AFIP',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(450,0,NULL,NULL,0,1,450,NULL,3,NULL,'Cheques Rechazados',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(467,0,NULL,NULL,0,1,467,NULL,6,NULL,'Interés',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:01:34',NULL),(468,0,NULL,NULL,0,1,14,NULL,8,NULL,'Deudores por ventas comunes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:34',NULL),(469,0,NULL,NULL,0,1,15,NULL,8,NULL,'Deudores por ventas morosos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:34',NULL),(470,0,NULL,NULL,0,1,16,NULL,8,NULL,'Deudores en gestión judicial',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:34',NULL),(471,0,NULL,NULL,0,1,17,NULL,8,NULL,'Previsión deudores incobrables',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:34',NULL),(472,0,NULL,NULL,0,1,22,NULL,8,NULL,'Anticipo Impto.Ganancia Mínima Presunta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:34',NULL),(473,0,NULL,NULL,0,1,24,NULL,4,NULL,'Impuesto a las Ganancias (Saldo a favor)',NULL,0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:53:56',NULL),(474,0,NULL,NULL,0,1,27,NULL,8,NULL,'Anticipos de proveedores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(475,0,NULL,NULL,0,1,28,NULL,8,NULL,'Depósito en garantía alquileres',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (476,0,NULL,NULL,0,1,29,NULL,8,NULL,'Derechos adquiridos a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(477,0,NULL,NULL,0,1,30,NULL,8,NULL,'Intereses a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(478,0,NULL,NULL,0,1,31,NULL,8,NULL,'Cuentas a rendir - Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(479,0,NULL,NULL,0,1,32,NULL,8,NULL,'Alquileres no devengados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(480,0,NULL,NULL,0,1,38,NULL,8,NULL,'Equipos de computación valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(481,0,NULL,NULL,0,1,39,NULL,8,NULL,'Equipos de computación ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(482,0,NULL,NULL,0,1,40,NULL,8,NULL,'Amortización Acumulada Equipos de comput.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(483,0,NULL,NULL,0,1,42,NULL,8,NULL,'Instalaciones valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(484,0,NULL,NULL,0,1,43,NULL,8,NULL,'Instalaciones ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(485,0,NULL,NULL,0,1,44,NULL,8,NULL,'Amortización Acumulada Instalaciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(486,0,NULL,NULL,0,1,46,NULL,8,NULL,'Muebles y utiles valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(487,0,NULL,NULL,0,1,47,NULL,8,NULL,'Muebles y utiles ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(488,0,NULL,NULL,0,1,48,NULL,8,NULL,'Amortización Acumulada Muebles y Útiles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(489,0,NULL,NULL,0,1,50,NULL,8,NULL,'Gastos de organización valores historicos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(490,0,NULL,NULL,0,1,51,NULL,8,NULL,'Gastos de organización ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(491,0,NULL,NULL,0,1,52,NULL,8,NULL,'Amortización acumulada gs. de organización',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(492,0,NULL,NULL,0,1,58,NULL,8,NULL,'Proveedores en cta. cte. exterior',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(493,0,NULL,NULL,0,1,59,NULL,8,NULL,'Derechos de exhibición a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(494,0,NULL,NULL,0,1,63,NULL,8,NULL,'Cargas sociales a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(495,0,NULL,NULL,0,1,64,NULL,8,NULL,'Sindicatos a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(496,0,NULL,NULL,0,1,67,NULL,8,NULL,'IVA Debito Fiscal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(497,0,NULL,NULL,0,1,68,NULL,8,NULL,'IVA Credito Fiscal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(498,0,NULL,NULL,0,1,69,NULL,8,NULL,'Impuestos Internos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(499,0,NULL,NULL,0,1,70,NULL,8,NULL,'Impuestos al Combustible',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(500,0,NULL,NULL,0,1,71,NULL,8,NULL,'IVA Retenciones de terceros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(501,0,NULL,NULL,0,1,72,NULL,5,NULL,'IVA Percepciones realiz.por terceros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(502,0,NULL,NULL,0,1,73,NULL,8,NULL,'IVA Saldo a favor',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(503,0,NULL,NULL,0,1,74,NULL,8,NULL,'IVA a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(504,0,NULL,NULL,0,1,75,NULL,5,NULL,'Percepciones Ingresos Brutos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (505,0,NULL,NULL,0,1,76,NULL,8,NULL,'Otros Pagos AFIP',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(506,0,NULL,NULL,0,1,78,NULL,8,NULL,'Impuesto a los Ingresos Brutos Pasivo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(507,0,NULL,NULL,0,1,79,NULL,8,NULL,'Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(508,0,NULL,NULL,0,1,80,NULL,8,NULL,'Impuesto a la Ganancia Mínima Presunta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(509,0,NULL,NULL,0,1,81,NULL,8,NULL,'AFIP - Retenciones Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(510,0,NULL,NULL,0,1,82,NULL,8,NULL,'AFIP - Plan de Facilidades Decreto 338/02',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(511,0,NULL,NULL,0,1,87,NULL,8,NULL,'Acciones en circulación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(512,0,NULL,NULL,0,1,88,NULL,8,NULL,'Ajuste del Capital',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(513,0,NULL,NULL,0,1,89,NULL,8,NULL,'Aportes Irrevocables Futuras Suscripciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(514,0,NULL,NULL,0,1,91,NULL,8,NULL,'Resultado del ejercicio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(515,0,NULL,NULL,0,1,92,NULL,8,NULL,'Resultado ejercicios anteriores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(516,0,NULL,NULL,0,1,93,NULL,8,NULL,'A.R.E.A.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(517,0,NULL,NULL,0,1,96,NULL,7,NULL,'VENTAS',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(518,0,NULL,NULL,0,1,97,NULL,7,NULL,'Honorarios',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(519,0,NULL,NULL,0,1,99,NULL,7,NULL,'Descuentos obtenidos',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(520,0,NULL,NULL,0,1,100,NULL,7,NULL,'Reintegros por exportaciones',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(521,0,NULL,NULL,0,1,102,NULL,7,NULL,'Intereses Cobrados',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(522,0,NULL,NULL,0,1,103,NULL,7,NULL,'Diferencias de cambio',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(523,0,NULL,NULL,0,1,104,NULL,7,NULL,'Descuentos obtenidos',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(524,0,NULL,NULL,0,1,110,NULL,6,NULL,'Sueldos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(525,0,NULL,NULL,0,1,111,NULL,6,NULL,'Contribuciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(526,0,NULL,NULL,0,1,112,NULL,6,NULL,'Sindicato',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(527,0,NULL,NULL,0,1,114,NULL,8,NULL,'ACA',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(528,0,NULL,NULL,0,1,115,NULL,6,NULL,'Aereos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(529,0,NULL,NULL,0,1,116,NULL,6,NULL,'Alquiler',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(530,0,NULL,NULL,0,1,117,NULL,8,NULL,'AGUA AYSA',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(531,0,NULL,NULL,0,1,118,NULL,8,NULL,'TV Cablevision',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(532,0,NULL,NULL,0,1,119,NULL,1,NULL,'Caja Jubilacion Consejo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(533,0,NULL,NULL,0,1,120,NULL,6,NULL,'Celulares',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(534,0,NULL,NULL,0,1,121,NULL,3,NULL,'Cheques',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(535,0,NULL,NULL,0,1,123,NULL,8,NULL,'Comida',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (536,0,NULL,NULL,0,1,126,NULL,6,NULL,'Fletes y acarreos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(537,0,NULL,NULL,0,1,127,NULL,8,NULL,'Luz Edesur',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(538,0,NULL,NULL,0,1,128,NULL,6,NULL,'Movilidad y Viáticos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(539,0,NULL,NULL,0,1,129,NULL,8,NULL,'Mantenimiento',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(540,0,NULL,NULL,0,1,130,NULL,8,NULL,'IVA No Computable',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(541,0,NULL,NULL,0,1,131,NULL,8,NULL,'Entretenimiento',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(542,0,NULL,NULL,0,1,132,NULL,6,NULL,'Amortización Bienes de Uso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(543,0,NULL,NULL,0,1,135,NULL,6,NULL,'Gastos varios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(544,0,NULL,NULL,0,1,136,NULL,6,NULL,'Ajuste por redondeo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(545,0,NULL,NULL,0,1,137,NULL,6,NULL,'Deudores Incobrables',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(546,0,NULL,NULL,0,1,141,NULL,6,NULL,'Intereses Proveedores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(547,0,NULL,NULL,0,1,143,NULL,6,NULL,'Diferencias de cambio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(548,0,NULL,NULL,0,1,144,NULL,8,NULL,'Diferencia de Cambio Bces. en M.Extranjera',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(549,0,NULL,NULL,0,1,145,NULL,6,NULL,'Diferencia tipo cambio Vendedor/Comprador',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(550,0,NULL,NULL,0,1,146,NULL,8,NULL,'Diferencia por conversion en Bce. en Mon. Extranj.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(551,0,NULL,NULL,0,1,147,NULL,8,NULL,'Diferencia de cambio CMV',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(552,0,NULL,NULL,0,1,148,NULL,8,NULL,'Diferencia de cambio PT',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(553,0,NULL,NULL,0,1,149,NULL,8,NULL,'Resultado por Exposición a la Inflación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(554,0,NULL,NULL,0,1,150,NULL,8,NULL,'Diferencia de cambio PE',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(555,0,NULL,NULL,0,1,151,NULL,8,NULL,'Diferencia de cambio Ds.Vtas.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(556,0,NULL,NULL,0,1,152,NULL,6,NULL,'Diferencia de cambio ME',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(557,0,NULL,NULL,0,1,153,NULL,6,NULL,'Descuentos otorgados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(558,0,NULL,NULL,0,1,155,NULL,6,NULL,'Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(559,0,NULL,NULL,0,1,156,NULL,6,NULL,'Impuesto a los Ingresos Brutos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(560,0,NULL,NULL,0,1,157,NULL,6,NULL,'Impuesto al Debito y Credito Bancario',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(561,0,NULL,NULL,0,1,159,NULL,6,NULL,'Pérdida por venta bienes de uso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(562,0,NULL,NULL,0,1,160,NULL,6,NULL,'Inversiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(563,0,NULL,NULL,0,1,161,NULL,6,NULL,'Amortizaciones extraordinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(564,0,NULL,NULL,0,1,178,NULL,8,NULL,'Google',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(565,0,NULL,NULL,0,1,188,NULL,6,NULL,'Publicidad',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (566,0,NULL,NULL,0,1,191,NULL,6,NULL,'Cargas Sociales',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(567,0,NULL,NULL,0,1,192,NULL,6,NULL,'Honorarios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(568,0,NULL,NULL,0,1,193,NULL,6,NULL,'Telefono Fijo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(569,0,NULL,NULL,0,1,198,NULL,6,NULL,'Seguros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(570,0,NULL,NULL,0,1,199,NULL,6,NULL,'Internet',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(571,0,NULL,NULL,0,1,204,NULL,6,NULL,'Multas Impositivas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(572,0,NULL,NULL,0,1,208,NULL,6,NULL,'Impuesto a los Ingresos Brutos - BS AS',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(573,0,NULL,NULL,0,1,209,NULL,6,NULL,'SIRCREB',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(574,0,NULL,NULL,0,1,212,NULL,6,NULL,'Tarjeta Visa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(575,0,NULL,NULL,0,1,213,NULL,6,NULL,'Tarjeta American Express',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(576,0,NULL,NULL,0,1,214,NULL,6,NULL,'Tarjeta Mastercard',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(577,0,NULL,NULL,0,1,215,NULL,8,NULL,'Tarjeta Shopping',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(578,0,NULL,NULL,0,1,216,NULL,6,NULL,'Tarjeta Cencosud',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(579,0,NULL,NULL,0,1,217,NULL,6,NULL,'Compras',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(580,0,NULL,NULL,0,1,218,NULL,7,NULL,'Ventas No Gravadas',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(581,0,NULL,NULL,0,1,220,NULL,5,NULL,'Perc IVA -RG3337',NULL,0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:53:56',NULL),(582,0,NULL,NULL,0,1,221,NULL,6,NULL,'Imps. Internos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(583,0,NULL,NULL,0,1,222,NULL,6,NULL,'Imp. Gasoil',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(584,0,NULL,NULL,0,1,223,NULL,6,NULL,'Imp. Hídricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(585,0,NULL,NULL,0,1,224,NULL,6,NULL,'ITC',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(586,0,NULL,NULL,0,1,225,NULL,5,NULL,'Perc IIBB  Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(587,0,NULL,NULL,0,1,226,NULL,5,NULL,'Perc IIBB  Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(588,0,NULL,NULL,0,1,227,NULL,5,NULL,'Perc IIBB  Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(589,0,NULL,NULL,0,1,228,NULL,5,NULL,'Perc IIBB  Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(590,0,NULL,NULL,0,1,229,NULL,5,NULL,'Perc IIBB  Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(591,0,NULL,NULL,0,1,230,NULL,5,NULL,'Perc IIBB  Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(592,0,NULL,NULL,0,1,231,NULL,5,NULL,'Perc IIBB  Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(593,0,NULL,NULL,0,1,232,NULL,5,NULL,'Perc IIBB  Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(594,0,NULL,NULL,0,1,233,NULL,5,NULL,'Perc IIBB  Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(595,0,NULL,NULL,0,1,234,NULL,5,NULL,'Perc IIBB  Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(596,0,NULL,NULL,0,1,235,NULL,5,NULL,'Perc IIBB  La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(597,0,NULL,NULL,0,1,236,NULL,5,NULL,'Perc IIBB  La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (598,0,NULL,NULL,0,1,237,NULL,5,NULL,'Perc IIBB  Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(599,0,NULL,NULL,0,1,238,NULL,5,NULL,'Perc IIBB  Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(600,0,NULL,NULL,0,1,239,NULL,5,NULL,'Perc IIBB  Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(601,0,NULL,NULL,0,1,240,NULL,5,NULL,'Perc IIBB  Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(602,0,NULL,NULL,0,1,241,NULL,5,NULL,'Perc IIBB  Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(603,0,NULL,NULL,0,1,242,NULL,5,NULL,'Perc IIBB  Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(604,0,NULL,NULL,0,1,243,NULL,5,NULL,'Perc IIBB  San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(605,0,NULL,NULL,0,1,244,NULL,5,NULL,'Perc IIBB  San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(606,0,NULL,NULL,0,1,245,NULL,5,NULL,'Perc IIBB  Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(607,0,NULL,NULL,0,1,246,NULL,5,NULL,'Perc IIBB  Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(608,0,NULL,NULL,0,1,247,NULL,5,NULL,'Perc IIBB  Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(609,0,NULL,NULL,0,1,248,NULL,5,NULL,'Perc IIBB  Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(610,0,NULL,NULL,0,1,249,NULL,5,NULL,'Perc IIBB  Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(611,0,NULL,NULL,0,1,250,NULL,6,NULL,'Compras No Gravadas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(612,0,NULL,NULL,0,1,276,NULL,6,NULL,'SIRCREB Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(613,0,NULL,NULL,0,1,277,NULL,6,NULL,'SIRCREB Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(614,0,NULL,NULL,0,1,278,NULL,6,NULL,'SIRCREB Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(615,0,NULL,NULL,0,1,279,NULL,6,NULL,'SIRCREB Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(616,0,NULL,NULL,0,1,280,NULL,6,NULL,'SIRCREB Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(617,0,NULL,NULL,0,1,281,NULL,6,NULL,'SIRCREB Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(618,0,NULL,NULL,0,1,282,NULL,6,NULL,'SIRCREB Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(619,0,NULL,NULL,0,1,283,NULL,6,NULL,'SIRCREB Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(620,0,NULL,NULL,0,1,284,NULL,6,NULL,'SIRCREB Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(621,0,NULL,NULL,0,1,285,NULL,6,NULL,'SIRCREB Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(622,0,NULL,NULL,0,1,286,NULL,6,NULL,'SIRCREB La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(623,0,NULL,NULL,0,1,287,NULL,6,NULL,'SIRCREB La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(624,0,NULL,NULL,0,1,288,NULL,6,NULL,'SIRCREB Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(625,0,NULL,NULL,0,1,289,NULL,6,NULL,'SIRCREB Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(626,0,NULL,NULL,0,1,290,NULL,6,NULL,'SIRCREB Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(627,0,NULL,NULL,0,1,291,NULL,6,NULL,'SIRCREB Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(628,0,NULL,NULL,0,1,292,NULL,6,NULL,'SIRCREB Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (629,0,NULL,NULL,0,1,293,NULL,6,NULL,'SIRCREB Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(630,0,NULL,NULL,0,1,294,NULL,6,NULL,'SIRCREB San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(631,0,NULL,NULL,0,1,295,NULL,6,NULL,'SIRCREB San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(632,0,NULL,NULL,0,1,296,NULL,6,NULL,'SIRCREB Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(633,0,NULL,NULL,0,1,297,NULL,6,NULL,'SIRCREB Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(634,0,NULL,NULL,0,1,298,NULL,6,NULL,'SIRCREB Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(635,0,NULL,NULL,0,1,299,NULL,6,NULL,'SIRCREB Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(636,0,NULL,NULL,0,1,300,NULL,6,NULL,'SIRCREB Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(637,0,NULL,NULL,0,1,301,NULL,8,NULL,'IIBB a Favor Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(638,0,NULL,NULL,0,1,302,NULL,8,NULL,'IIBB a Favor Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(639,0,NULL,NULL,0,1,303,NULL,8,NULL,'IIBB a Favor Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(640,0,NULL,NULL,0,1,304,NULL,8,NULL,'IIBB a Favor Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(641,0,NULL,NULL,0,1,305,NULL,8,NULL,'IIBB a Favor Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(642,0,NULL,NULL,0,1,306,NULL,8,NULL,'IIBB a Favor Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(643,0,NULL,NULL,0,1,307,NULL,8,NULL,'IIBB a Favor Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(644,0,NULL,NULL,0,1,308,NULL,8,NULL,'IIBB a Favor Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(645,0,NULL,NULL,0,1,309,NULL,8,NULL,'IIBB a Favor Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(646,0,NULL,NULL,0,1,310,NULL,8,NULL,'IIBB a Favor Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(647,0,NULL,NULL,0,1,311,NULL,8,NULL,'IIBB a Favor La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(648,0,NULL,NULL,0,1,312,NULL,8,NULL,'IIBB a Favor La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(649,0,NULL,NULL,0,1,313,NULL,8,NULL,'IIBB a Favor Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:01:35',NULL),(650,0,NULL,NULL,0,1,314,NULL,8,NULL,'IIBB a Favor Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(651,0,NULL,NULL,0,1,315,NULL,8,NULL,'IIBB a Favor Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(652,0,NULL,NULL,0,1,316,NULL,8,NULL,'IIBB a Favor Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(653,0,NULL,NULL,0,1,317,NULL,8,NULL,'IIBB a Favor Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(654,0,NULL,NULL,0,1,318,NULL,8,NULL,'IIBB a Favor Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(655,0,NULL,NULL,0,1,319,NULL,8,NULL,'IIBB a Favor San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(656,0,NULL,NULL,0,1,320,NULL,8,NULL,'IIBB a Favor San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(657,0,NULL,NULL,0,1,321,NULL,8,NULL,'IIBB a Favor Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(658,0,NULL,NULL,0,1,322,NULL,8,NULL,'IIBB a Favor Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (659,0,NULL,NULL,0,1,323,NULL,8,NULL,'IIBB a Favor Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(660,0,NULL,NULL,0,1,324,NULL,8,NULL,'IIBB a Favor Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(661,0,NULL,NULL,0,1,325,NULL,8,NULL,'IIBB a Favor Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(662,0,NULL,NULL,0,1,326,NULL,8,NULL,'IIBB a Pagar Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(663,0,NULL,NULL,0,1,327,NULL,8,NULL,'IIBB a Pagar Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(664,0,NULL,NULL,0,1,328,NULL,8,NULL,'IIBB a Pagar Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(665,0,NULL,NULL,0,1,329,NULL,8,NULL,'IIBB a Pagar Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(666,0,NULL,NULL,0,1,330,NULL,8,NULL,'IIBB a Pagar Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(667,0,NULL,NULL,0,1,331,NULL,8,NULL,'IIBB a Pagar Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(668,0,NULL,NULL,0,1,332,NULL,8,NULL,'IIBB a Pagar Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(669,0,NULL,NULL,0,1,333,NULL,8,NULL,'IIBB a Pagar Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(670,0,NULL,NULL,0,1,334,NULL,8,NULL,'IIBB a Pagar Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(671,0,NULL,NULL,0,1,335,NULL,8,NULL,'IIBB a Pagar Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(672,0,NULL,NULL,0,1,336,NULL,8,NULL,'IIBB a Pagar La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(673,0,NULL,NULL,0,1,337,NULL,8,NULL,'IIBB a Pagar La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(674,0,NULL,NULL,0,1,338,NULL,8,NULL,'IIBB a Pagar Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(675,0,NULL,NULL,0,1,339,NULL,8,NULL,'IIBB a Pagar Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(676,0,NULL,NULL,0,1,340,NULL,8,NULL,'IIBB a Pagar Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(677,0,NULL,NULL,0,1,341,NULL,8,NULL,'IIBB a Pagar Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(678,0,NULL,NULL,0,1,342,NULL,8,NULL,'IIBB a Pagar Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(679,0,NULL,NULL,0,1,343,NULL,8,NULL,'IIBB a Pagar Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(680,0,NULL,NULL,0,1,344,NULL,8,NULL,'IIBB a Pagar San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(681,0,NULL,NULL,0,1,345,NULL,8,NULL,'IIBB a Pagar San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(682,0,NULL,NULL,0,1,346,NULL,8,NULL,'IIBB a Pagar Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(683,0,NULL,NULL,0,1,347,NULL,8,NULL,'IIBB a Pagar Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(684,0,NULL,NULL,0,1,348,NULL,8,NULL,'IIBB a Pagar Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(685,0,NULL,NULL,0,1,349,NULL,8,NULL,'IIBB a Pagar Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(686,0,NULL,NULL,0,1,350,NULL,8,NULL,'IIBB a Pagar Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(687,0,NULL,NULL,0,1,352,NULL,8,NULL,'Compensacion',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(688,0,NULL,NULL,0,1,353,NULL,8,NULL,'IVA Saldo Tecnico',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (689,0,NULL,NULL,0,1,354,NULL,8,NULL,'IVA Saldo Libre Disponibilidad',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(690,0,NULL,NULL,0,1,361,NULL,8,NULL,'Equipos de Computación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(691,0,NULL,NULL,0,1,362,NULL,8,NULL,'Computadoras',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(692,0,NULL,NULL,0,1,363,NULL,8,NULL,'Muebles y Utiles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(693,0,NULL,NULL,0,1,365,NULL,8,NULL,'Provision Honorarios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(694,0,NULL,NULL,0,1,366,NULL,8,NULL,'Cta. Cte Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(695,0,NULL,NULL,0,1,367,NULL,8,NULL,'Provisión Honorarios Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(696,0,NULL,NULL,0,1,368,NULL,8,NULL,'Cuenta Particular Socio 1',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(697,0,NULL,NULL,0,1,369,NULL,8,NULL,'Capital',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(698,0,NULL,NULL,0,1,380,NULL,8,NULL,'Instalaciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(699,0,NULL,NULL,0,1,381,NULL,8,NULL,'Reserva Legal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(700,0,NULL,NULL,0,1,382,NULL,8,NULL,'Reserva Legal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(701,0,NULL,NULL,0,1,383,NULL,8,NULL,'Resultado no asignado',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(702,0,NULL,NULL,0,1,386,NULL,8,NULL,'PLAZO FIJO',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:35',NULL),(703,0,NULL,NULL,0,1,388,NULL,8,NULL,'ACCIONES',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(704,0,NULL,NULL,0,1,389,NULL,8,NULL,'Inmuebles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(705,0,NULL,NULL,0,1,390,NULL,8,NULL,'Vehiculos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(706,0,NULL,NULL,0,1,391,NULL,8,NULL,'Maquinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(707,0,NULL,NULL,0,1,392,NULL,8,NULL,'MERCADERIAS',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(708,0,NULL,NULL,0,1,393,NULL,8,NULL,'OTROS',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(709,0,NULL,NULL,0,1,395,NULL,8,NULL,'Cuenta Particular Socio 2',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(710,0,NULL,NULL,0,1,396,NULL,6,NULL,'Comisiones Y gastos Bancarios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(711,0,NULL,NULL,0,1,411,NULL,8,NULL,'Provisión Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(712,0,NULL,NULL,0,1,412,NULL,6,NULL,'Amortización Muebles y Útiles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(713,0,NULL,NULL,0,1,413,NULL,6,NULL,'Amortización Equipos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(714,0,NULL,NULL,0,1,414,NULL,8,NULL,'Amortizacion Acumulada Equipos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(715,0,NULL,NULL,0,1,415,NULL,8,NULL,'Amortización Acumulada Maquinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(716,0,NULL,NULL,0,1,416,NULL,8,NULL,'Materias Primas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(717,0,NULL,NULL,0,1,419,NULL,8,NULL,'Rodados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(718,0,NULL,NULL,0,1,420,NULL,8,NULL,'Amortización Acumulada Rodados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(719,0,NULL,NULL,0,1,421,NULL,8,NULL,'Amortización Rodados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (720,0,NULL,NULL,0,1,422,NULL,8,NULL,'Amortización Maquinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(721,0,NULL,NULL,0,1,423,NULL,8,NULL,'Accesorios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(722,0,NULL,NULL,0,1,424,NULL,8,NULL,'Amortización Acumulada Accesorios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(723,0,NULL,NULL,0,1,426,NULL,8,NULL,'Reserva Facultativa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(724,0,NULL,NULL,0,1,427,NULL,8,NULL,'Créditos por Impuestos Diferidos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(725,0,NULL,NULL,0,1,428,NULL,8,NULL,'Fondo de Comercio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(726,0,NULL,NULL,0,1,429,NULL,8,NULL,'Amortizacion Acumulada Fondo de Comercio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(727,0,NULL,NULL,0,1,430,NULL,8,NULL,'Intereses a devengar AGIP',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(728,0,NULL,NULL,0,1,431,NULL,8,NULL,'PFP IIBB',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(729,0,NULL,NULL,0,1,434,NULL,8,NULL,'Productos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(730,0,NULL,NULL,0,1,435,NULL,8,NULL,'Intereses a devengar PFP',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(731,0,NULL,NULL,0,1,437,NULL,8,NULL,'Imp. Ley 25413 Cred 0.6%',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(732,0,NULL,NULL,0,1,438,NULL,8,NULL,'Honorarios Directorio a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(733,0,NULL,NULL,0,1,439,NULL,8,NULL,'Reserva para Futuras Inversiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(734,0,NULL,NULL,0,1,440,NULL,8,NULL,'TEAC - Trabajos Ejecutados a Certificar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(735,0,NULL,NULL,0,1,444,NULL,8,NULL,'Banco Santander Rio Cta Cte',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(736,0,NULL,NULL,0,1,449,NULL,8,NULL,'Leasing',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(737,0,NULL,NULL,0,1,453,NULL,8,NULL,'Inversión Central Caribe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(738,0,NULL,NULL,0,1,454,NULL,8,NULL,'Otras Inversiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(739,0,NULL,NULL,0,1,455,NULL,8,NULL,'Otros Créditos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(740,0,NULL,NULL,0,1,456,NULL,8,NULL,'Provisión Honorarios Socio Gerente',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(741,0,NULL,NULL,0,1,459,NULL,8,NULL,'Moratoria SUSS a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(742,0,NULL,NULL,0,1,460,NULL,8,NULL,'Impuestos Municipales a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(743,0,NULL,NULL,0,1,461,NULL,6,NULL,'Amortización Instalaciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(744,0,NULL,NULL,0,1,462,NULL,8,NULL,'Amortización Equipos de comput.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(745,0,NULL,NULL,0,1,463,NULL,8,NULL,'Cuenta Particular Socio 3',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(746,0,NULL,NULL,0,1,464,NULL,8,NULL,'Cuenta Particular Socio 4',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(747,0,NULL,NULL,0,1,465,NULL,8,NULL,'Otras Reservas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(748,0,NULL,NULL,0,1,466,NULL,8,NULL,'IGMP (Saldo a Favor)',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(749,0,NULL,NULL,0,1,468,NULL,8,NULL,'Productos en Proceso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (750,0,NULL,NULL,0,1,469,NULL,8,NULL,'Depósitos en Garantía Socio Gerente',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(751,0,NULL,NULL,0,1,470,NULL,8,NULL,'Fondos Embargados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(752,0,NULL,NULL,0,1,471,NULL,8,NULL,'Cuota Solid.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(753,0,NULL,NULL,0,1,472,NULL,8,NULL,'Anticipo Honorarios Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(754,0,NULL,NULL,0,1,473,NULL,8,NULL,'SICORE a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(755,0,NULL,NULL,0,1,476,NULL,6,NULL,'RECPAM',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL),(756,0,NULL,NULL,0,1,478,NULL,6,NULL,'CO2 - Imp. Al Carbono',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:01:36',NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_detail`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `is_conciliado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_detail_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_detail_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_detail`
--

LOCK TABLES `cta_cte_tesoreria_detail` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos`
--

DROP TABLE IF EXISTS `ctacte_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigoBCRA` int(11) DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos`
--

LOCK TABLES `ctacte_bancos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos` DISABLE KEYS */;
INSERT INTO `ctacte_bancos` VALUES (1,NULL,'BANCO DE GALICIA Y BUENOS AIRES S.A.',7,'30-50000173-5',NULL,NULL,NULL),(2,NULL,'BANCO DE LA NACION ARGENTINA',11,'30-50001091-2',NULL,NULL,NULL),(3,NULL,'BANCO DE LA PROVINCIA DE BUENOS AIRES',14,'33-99924210-9',NULL,NULL,NULL),(4,NULL,'INDUSTRIAL AND COMMERCIAL BANK OF CHINA',15,'30-70944784-6',NULL,NULL,NULL),(5,NULL,'CITIBANK N.A.',16,'30-50000562-5',NULL,NULL,NULL),(6,NULL,'BBVA BANCO FRANCES S.A.',17,'30-50000319-3',NULL,NULL,NULL),(7,NULL,'THE BANK OF TOKYO-MITSUBISHI UFJ, LTD.',18,'30-50001183-8',NULL,NULL,NULL),(8,NULL,'BANCO DE LA PROVINCIA DE CORDOBA S.A.',20,'30-99922856-5',NULL,NULL,NULL),(9,NULL,'BANCO SUPERVIELLE S.A.',27,'33-50000517-9',NULL,NULL,NULL),(10,NULL,'BANCO DE LA CIUDAD DE BUENOS AIRES',29,'30-99903208-3',NULL,NULL,NULL),(11,NULL,'BANCO PATAGONIA S.A.',34,'30-50000661-3',NULL,NULL,NULL),(12,NULL,'BANCO HIPOTECARIO S.A.',44,'30-50001107-2',NULL,NULL,NULL),(13,NULL,'BANCO DE SAN JUAN S.A.',45,'30-50000944-2',NULL,NULL,NULL),(14,NULL,'BANCO DEL TUCUMAN S.A.',60,'30-51794820-5',NULL,NULL,NULL),(15,NULL,'BANCO MUNICIPAL DE ROSARIO',65,'33-99918181-9',NULL,NULL,NULL),(16,NULL,'BANCO SANTANDER RIO S.A.',72,'30-50000845-4',NULL,NULL,NULL),(17,NULL,'BANCO DEL CHUBUT S.A.',83,'30-50001299-0',NULL,NULL,NULL),(18,NULL,'BANCO DE SANTA CRUZ S.A.',86,'30-50009880-1',NULL,NULL,NULL),(19,NULL,'BANCO DE LA PAMPA SOCIEDAD DE ECONOMÍA M',93,'30-50001251-6',NULL,NULL,NULL),(20,NULL,'BANCO DE CORRIENTES S.A.',94,'30-50001060-2',NULL,NULL,NULL),(21,NULL,'BANCO PROVINCIA DEL NEUQUÉN SOCIEDAD ANÓ',97,'30-50001404-7',NULL,NULL,NULL),(22,NULL,'BANCO INTERFINANZAS S.A.',147,'30-52271441-7',NULL,NULL,NULL),(23,NULL,'HSBC BANK ARGENTINA S.A.',150,'33-53718600-9',NULL,NULL,NULL),(24,NULL,'JPMORGAN CHASE BANK, NATIONAL ASSOCIATIO',165,'30-58313794-3',NULL,NULL,NULL),(25,NULL,'BANCO CREDICOOP COOPERATIVO LIMITADO',191,'30-57142135-2',NULL,NULL,NULL),(26,NULL,'BANCO DE VALORES S.A.',198,'30-57612427-5',NULL,NULL,NULL),(27,NULL,'BANCO ROELA S.A.',247,'30-53561044-0',NULL,NULL,NULL),(28,NULL,'BANCO MARIVA S.A.',254,'30-51642044-4',NULL,NULL,NULL),(29,NULL,'BANCO ITAU ARGENTINA S.A.',259,'30-58018941-1',NULL,NULL,NULL),(30,NULL,'BANK OF AMERICA, NATIONAL ASSOCIATION',262,'30-50005055-8',NULL,NULL,NULL),(31,NULL,'BNP PARIBAS',266,'30-58472756-6',NULL,NULL,NULL),(32,NULL,'BANCO PROVINCIA DE TIERRA DEL FUEGO',268,'30-57565578-1',NULL,NULL,NULL),(33,NULL,'BANCO DE LA REPUBLICA ORIENTAL DEL URUGU',269,'30-58833784-3',NULL,NULL,NULL),(34,NULL,'BANCO SAENZ S.A.',277,'30-53467243-4',NULL,NULL,NULL),(35,NULL,'BANCO MERIDIAN S.A.',281,'30-53448749-1',NULL,NULL,NULL),(36,NULL,'BANCO MACRO S.A.',285,'30-50001008-4',NULL,NULL,NULL),(37,NULL,'BANCO COMAFI SOCIEDAD ANONIMA',299,'30-60473101-8',NULL,NULL,NULL),(38,NULL,'BANCO DE INVERSION Y COMERCIO EXTERIOR S',300,'30-65112908-3',NULL,NULL,NULL),(39,NULL,'BANCO PIANO S.A.',301,'30-56915176-3',NULL,NULL,NULL),(40,NULL,'BANCO JULIO SOCIEDAD ANONIMA',305,'30-65744121-6',NULL,NULL,NULL),(41,NULL,'BANCO RIOJA SOCIEDAD ANONIMA UNIPERSONAL',309,'30-67185933-9',NULL,NULL,NULL),(42,NULL,'BANCO DEL SOL S.A.',310,'30-67793756-0',NULL,NULL,NULL),(43,NULL,'NUEVO BANCO DEL CHACO S. A.',311,'30-67015779-9',NULL,NULL,NULL),(44,NULL,'BANCO VOII S.A.',312,'30-54674163-6',NULL,NULL,NULL),(45,NULL,'BANCO DE FORMOSA S.A.',315,'30-67137590-0',NULL,NULL,NULL),(46,NULL,'BANCO CMF S.A.',319,'30-57661429-9',NULL,NULL,NULL),(47,NULL,'BANCO DE SANTIAGO DEL ESTERO S.A.',321,'33-68666464-9',NULL,NULL,NULL),(48,NULL,'BANCO INDUSTRIAL S.A.',322,'30-68502995-9',NULL,NULL,NULL),(49,NULL,'NUEVO BANCO DE SANTA FE SOCIEDAD ANONIMA',330,'30-69243266-1',NULL,NULL,NULL),(50,NULL,'BANCO CETELEM ARGENTINA S.A.',331,'30-69730636-2',NULL,NULL,NULL),(51,NULL,'BANCO DE SERVICIOS FINANCIEROS S.A.',332,'30-69726589-5',NULL,NULL,NULL),(52,NULL,'BANCO BRADESCO ARGENTINA S.A.U.',336,'30-70125555-7',NULL,NULL,NULL),(53,NULL,'BANCO DE SERVICIOS Y TRANSACCIONES S.A.',338,'30-70496099-5',NULL,NULL,NULL);
INSERT INTO `ctacte_bancos` VALUES (54,NULL,'RCI BANQUE S.A.',339,'30-70710834-3',NULL,NULL,NULL),(55,NULL,'BACS BANCO DE CREDITO Y SECURITIZACION S',340,'30-70722741-5',NULL,NULL,NULL),(56,NULL,'BANCO MASVENTAS S.A.',341,'30-54061826-3',NULL,NULL,NULL),(57,NULL,'BANCO WANAP S.A.',384,'30-71565463-2',NULL,NULL,NULL),(58,NULL,'NUEVO BANCO DE ENTRE RÍOS S.A.',386,'33-70799551-9',NULL,NULL,NULL),(59,NULL,'BANCO COLUMBIA S.A.',389,'30-51763749-8',NULL,NULL,NULL),(60,NULL,'BANCO BICA S.A.',426,'30-71233123-9',NULL,NULL,NULL),(61,NULL,'BANCO COINAG S.A.',431,'30-71419596-0',NULL,NULL,NULL),(62,NULL,'BANCO DE COMERCIO S.A.',432,'30-54203363-7',NULL,NULL,NULL),(63,NULL,'FORD CREDIT COMPAÑIA FINANCIERA S.A.',44059,'30-51654454-2',NULL,NULL,NULL),(64,NULL,'COMPAÑIA FINANCIERA ARGENTINA S.A.',44077,'30-53800640-4',NULL,NULL,NULL),(65,NULL,'VOLKWAGEN FINANCIAL SERVICES CIA.FIN.S.A',44088,'30-68241957-8',NULL,NULL,NULL),(66,NULL,'CORDIAL COMPAÑÍA FINANCIERA S.A.',44090,'30-70181085-2',NULL,NULL,NULL),(67,NULL,'FCA COMPAÑIA FINANCIERA S.A.',44092,'30-69230488-4',NULL,NULL,NULL),(68,NULL,'GPAT COMPAÑIA FINANCIERA S.A.',44093,'30-67856482-2',NULL,NULL,NULL),(69,NULL,'MERCEDES-BENZ COMPAÑÍA FINANCIERA ARGENT',44094,'30-70700229-4',NULL,NULL,NULL),(70,NULL,'ROMBO COMPAÑÍA FINANCIERA S.A.',44095,'33-70712490-9',NULL,NULL,NULL),(71,NULL,'JOHN DEERE CREDIT COMPAÑÍA FINANCIERA S.',44096,'30-70702485-9',NULL,NULL,NULL),(72,NULL,'PSA FINANCE ARGENTINA COMPAÑÍA FINANCIER',44098,'30-70784736-7',NULL,NULL,NULL),(73,NULL,'TOYOTA COMPAÑÍA FINANCIERA DE ARGENTINA',44099,'30-70900042-6',NULL,NULL,NULL),(74,NULL,'FINANDINO COMPAÑIA FINANCIERA S.A.',44100,'30-71259240-7',NULL,NULL,NULL),(75,NULL,'MONTEMAR COMPAÑIA FINANCIERA S.A.',45056,'30-58138551-6',NULL,NULL,NULL),(76,NULL,'MULTIFINANZAS COMPAÑIA FINANCIERA S.A.',45072,'30-62828435-7',NULL,NULL,NULL),(77,NULL,'CAJA DE CREDITO \"CUENCA\" COOPERATIVA LIM',65203,'30-71622694-4',NULL,NULL,NULL),(78,NULL,'MERCADO PAGO',NULL,NULL,NULL,NULL,NULL),(79,NULL,'UALA',NULL,NULL,NULL,NULL,NULL),(80,NULL,'ICBC',NULL,NULL,NULL,NULL,NULL),(81,NULL,'BMA SAU',NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctacte_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos_datos`
--

DROP TABLE IF EXISTS `ctacte_bancos_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos_datos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `num_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cbu` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_bancos_datos_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  CONSTRAINT `ctacte_bancos_datos_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos_datos`
--

LOCK TABLES `ctacte_bancos_datos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_bancos_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_cheques`
--

DROP TABLE IF EXISTS `ctacte_cheques`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_cheques` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `asiento_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id2` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) DEFAULT NULL,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_cobro` date DEFAULT NULL,
  `banco_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `cuit` text COLLATE utf8mb4_unicode_ci,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abierto_cruzado` int(11) NOT NULL DEFAULT '1',
  `is_no_a_la_orden` tinyint(1) NOT NULL DEFAULT '0',
  `numero` int(10) unsigned DEFAULT NULL,
  `foto` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_cheques_asiento_id_foreign` (`asiento_id`),
  KEY `ctacte_cheques_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  KEY `ctacte_cheques_banco_id_foreign` (`banco_id`),
  KEY `ctacte_cheques_person_id_foreign` (`person_id`),
  KEY `ctacte_cheques_cta_cte_cliente_id2_foreign` (`cta_cte_cliente_id2`),
  KEY `ctacte_cheques_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesorer_id` (`cta_cte_tesoreria_id`),
  KEY `ctacte_cheques_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `ctacte_cheques_nf_cta_cte_id2_foreign` (`nf_cta_cte_id2`),
  KEY `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ctacte_cheques_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `ctacte_cheques_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  CONSTRAINT `cta_cte_tesorer_id` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `ctacte_cheques_banco_id_foreign` FOREIGN KEY (`banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id2_foreign` FOREIGN KEY (`cta_cte_cliente_id2`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `ctacte_cheques_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id2_foreign` FOREIGN KEY (`nf_cta_cte_id2`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_cheques`
--

LOCK TABLES `ctacte_cheques` WRITE;
/*!40000 ALTER TABLE `ctacte_cheques` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_cheques` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_centrocosto`
--

DROP TABLE IF EXISTS `ctactegastos_centrocosto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_centrocosto` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_centrocosto`
--

LOCK TABLES `ctactegastos_centrocosto` WRITE;
/*!40000 ALTER TABLE `ctactegastos_centrocosto` DISABLE KEYS */;
INSERT INTO `ctactegastos_centrocosto` VALUES (1,NULL,'OFICINA',NULL,NULL,NULL),(2,NULL,'FIJO',NULL,NULL,NULL),(3,NULL,'VARIABLE',NULL,NULL,NULL),(4,NULL,'GISELA',NULL,NULL,NULL),(5,NULL,'LIA',NULL,NULL,NULL),(6,NULL,'PADRES',NULL,NULL,NULL),(7,NULL,'CASA',NULL,NULL,NULL),(8,NULL,'VANESA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_centrocosto` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_cuenta_tipo`
--

DROP TABLE IF EXISTS `ctactegastos_cuenta_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_cuenta_tipo` (
  `idCuentaTipo` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `idTipo` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`idCuentaTipo`),
  KEY `ctactegastos_cuenta_tipo_idtipo_foreign` (`idTipo`),
  KEY `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_idtipo_foreign` FOREIGN KEY (`idTipo`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_cuenta_tipo`
--

LOCK TABLES `ctactegastos_cuenta_tipo` WRITE;
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` DISABLE KEYS */;
INSERT INTO `ctactegastos_cuenta_tipo` VALUES (1,NULL,NULL,3,NULL,NULL,NULL),(2,NULL,NULL,6,NULL,NULL,NULL),(3,NULL,NULL,3,NULL,NULL,NULL),(4,NULL,NULL,4,NULL,NULL,NULL),(5,NULL,NULL,5,NULL,NULL,NULL),(6,NULL,NULL,3,NULL,NULL,NULL),(7,NULL,NULL,4,NULL,NULL,NULL),(8,NULL,NULL,3,NULL,NULL,NULL),(9,NULL,NULL,4,NULL,NULL,NULL),(10,NULL,NULL,7,NULL,NULL,NULL),(11,NULL,NULL,8,NULL,NULL,NULL),(12,NULL,NULL,3,NULL,NULL,NULL),(13,NULL,NULL,3,NULL,NULL,NULL),(14,NULL,NULL,4,NULL,NULL,NULL),(15,NULL,NULL,1,NULL,NULL,NULL),(16,NULL,NULL,2,NULL,NULL,NULL),(17,NULL,NULL,5,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_mensuales`
--

DROP TABLE IF EXISTS `ctactegastos_mensuales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_mensuales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `CuentaTipo_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `TipoDeGasto_id` int(10) unsigned NOT NULL,
  `CentroCosto_id` int(10) unsigned NOT NULL,
  `gasto_cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `monto` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctactegastos_mensuales_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `ctactegastos_mensuales_tipodegasto_id_foreign` (`TipoDeGasto_id`),
  KEY `ctactegastos_mensuales_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` (`gasto_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_mensuales_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`gasto_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_tipodegasto_id_foreign` FOREIGN KEY (`TipoDeGasto_id`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_mensuales`
--

LOCK TABLES `ctactegastos_mensuales` WRITE;
/*!40000 ALTER TABLE `ctactegastos_mensuales` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctactegastos_mensuales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_tiposdegastos`
--

DROP TABLE IF EXISTS `ctactegastos_tiposdegastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_tiposdegastos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_tiposdegastos`
--

LOCK TABLES `ctactegastos_tiposdegastos` WRITE;
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` DISABLE KEYS */;
INSERT INTO `ctactegastos_tiposdegastos` VALUES (1,NULL,'Oficina',NULL,NULL,NULL),(2,NULL,'Personales',NULL,NULL,NULL),(3,NULL,'Tarjeta VISA',NULL,NULL,NULL),(4,NULL,'Tarjeta Mastercard',NULL,NULL,NULL),(5,NULL,'Debito Automatico',NULL,NULL,NULL),(6,NULL,'American Express',NULL,NULL,NULL),(7,NULL,'Tarjeta Shopping',NULL,NULL,NULL),(8,NULL,'Tarjeta Cencosud',NULL,NULL,NULL),(9,NULL,'Tarjeta Coto',NULL,NULL,NULL),(10,NULL,'Tarjeta Nativa',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos`
--

DROP TABLE IF EXISTS `cursos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fecha` date DEFAULT NULL,
  `hora` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profesor` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cant_clases` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjuntos` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_zoom` longtext COLLATE utf8mb4_unicode_ci,
  `cod_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contraseña_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_youtube` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `materiales` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos`
--

LOCK TABLES `cursos` WRITE;
/*!40000 ALTER TABLE `cursos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos_detail`
--

DROP TABLE IF EXISTS `cursos_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `curso_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cursos_detail_curso_id_foreign` (`curso_id`),
  CONSTRAINT `cursos_detail_curso_id_foreign` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos_detail`
--

LOCK TABLES `cursos_detail` WRITE;
/*!40000 ALTER TABLE `cursos_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `data_types`
--

DROP TABLE IF EXISTS `data_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `data_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `data_types_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `data_types`
--

LOCK TABLES `data_types` WRITE;
/*!40000 ALTER TABLE `data_types` DISABLE KEYS */;
INSERT INTO `data_types` VALUES (1,'Comprobantes XLS',1,'Importación','XLS','data/imports/receipts/xls',NULL,NULL),(2,'CITI-Ventas',1,'Importación','TXT','data/imports/receipts/CitiVentas',NULL,NULL),(3,'CITI Compras',2,'Exportación','TXT','data/exports/receipts/citi',NULL,NULL),(4,'CITI Ventas',2,'Exportación','TXT','data/exports/receipts/CitiVentasExport',NULL,NULL),(5,'Convenio Multilateral',2,'Exportación','TXT','data/exports/receipts/convenio',NULL,NULL),(6,'Libro IVA Digital',2,'Exportación','TXT','data/exports/receipts/libro_iva_digital',NULL,'2019-11-20 21:43:44'),(7,'Mis Comprobantes',1,'Importacion','','data/imports/receipts/mis_comprobantes',NULL,NULL),(8,'Consulta AFIP',3,'AFIP','','data/afip/index','2019-12-06 14:49:55','2019-12-06 14:49:55');
/*!40000 ALTER TABLE `data_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_estados`
--

DROP TABLE IF EXISTS `dc_estados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_estados` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_estados`
--

LOCK TABLES `dc_estados` WRITE;
/*!40000 ALTER TABLE `dc_estados` DISABLE KEYS */;
INSERT INTO `dc_estados` VALUES (1,NULL,'BORRADOR',1,NULL,'2023-08-06 23:55:40',NULL),(2,NULL,'TERMINADO',1,NULL,'2023-08-06 23:55:40',NULL),(3,NULL,'ELIMINADO',1,NULL,'2023-08-13 09:16:18',NULL),(4,NULL,'PAGADO',1,NULL,'2023-08-06 23:55:40','2023-08-06 23:55:40'),(5,NULL,'CONCILIADO',1,NULL,'2023-08-06 23:55:40','2023-08-06 23:55:40');
/*!40000 ALTER TABLE `dc_estados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_estados_decisiones`
--

DROP TABLE IF EXISTS `dc_estados_decisiones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_estados_decisiones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_tipo_id` bigint(20) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_estados_decisiones_dc_orden_tipo_id_foreign` (`dc_orden_tipo_id`),
  CONSTRAINT `dc_estados_decisiones_dc_orden_tipo_id_foreign` FOREIGN KEY (`dc_orden_tipo_id`) REFERENCES `dc_ordenes_tipos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_estados_decisiones`
--

LOCK TABLES `dc_estados_decisiones` WRITE;
/*!40000 ALTER TABLE `dc_estados_decisiones` DISABLE KEYS */;
INSERT INTO `dc_estados_decisiones` VALUES (1,NULL,3,'Pendiente',1,NULL,NULL,NULL),(2,NULL,3,'Aprobado',1,NULL,NULL,NULL),(3,NULL,3,'Rechazado',1,NULL,NULL,NULL),(4,NULL,3,'Cancelado',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_estados_decisiones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas`
--

DROP TABLE IF EXISTS `dc_firmas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_firmante_dc` tinyint(1) NOT NULL DEFAULT '0',
  `show_create_dc` tinyint(1) NOT NULL DEFAULT '0',
  `faltan_firmas` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas`
--

LOCK TABLES `dc_firmas` WRITE;
/*!40000 ALTER TABLE `dc_firmas` DISABLE KEYS */;
INSERT INTO `dc_firmas` VALUES (1,NULL,'NO',1,1,0,1,NULL,'2023-08-06 23:55:40',NULL),(2,NULL,'RECHAZADO',1,1,0,1,NULL,'2023-08-06 23:55:40',NULL),(3,NULL,'ACEPTADO',1,0,0,1,NULL,'2023-08-06 23:55:40',NULL),(4,NULL,'FALTAN FIRMAS',0,0,1,1,'2023-08-06 23:55:40','2023-08-06 23:55:40',NULL),(5,NULL,'EMITIDO',1,0,0,1,'2023-10-12 08:05:27','2023-10-12 08:05:27',NULL);
/*!40000 ALTER TABLE `dc_firmas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas_ordenes`
--

DROP TABLE IF EXISTS `dc_firmas_ordenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas_ordenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `user_id_que_firma` int(10) unsigned NOT NULL,
  `dc_firma_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_firmas_ordenes_person_id_foreign` (`person_id`),
  KEY `dc_firmas_ordenes_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_firmas_ordenes_dc_firma_id_foreign` (`dc_firma_id`),
  CONSTRAINT `dc_firmas_ordenes_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_firmas_ordenes_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_firmas_ordenes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas_ordenes`
--

LOCK TABLES `dc_firmas_ordenes` WRITE;
/*!40000 ALTER TABLE `dc_firmas_ordenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_firmas_ordenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas_reglas`
--

DROP TABLE IF EXISTS `dc_firmas_reglas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas_reglas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL,
  `grupos_users_ids` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_firmas_reglas_person_id_foreign` (`person_id`),
  KEY `dc_firmas_reglas_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_firmas_reglas_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_firmas_reglas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas_reglas`
--

LOCK TABLES `dc_firmas_reglas` WRITE;
/*!40000 ALTER TABLE `dc_firmas_reglas` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_firmas_reglas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_de_pago`
--

DROP TABLE IF EXISTS `dc_orden_de_pago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_de_pago` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-09-28 16:29:26',
  `dc_orden_id` bigint(20) unsigned NOT NULL DEFAULT '10',
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dc_estado_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `dc_firma_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_de_pago_person_id_foreign` (`person_id`),
  KEY `dc_orden_de_pago_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `dc_orden_de_pago_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_orden_de_pago_dc_firma_id_foreign` (`dc_firma_id`),
  KEY `dc_orden_de_pago_dc_estado_id_foreign` (`dc_estado_id`),
  CONSTRAINT `dc_orden_de_pago_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `dc_orden_de_pago_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_orden_de_pago_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_orden_de_pago_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_orden_de_pago_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_de_pago`
--

LOCK TABLES `dc_orden_de_pago` WRITE;
/*!40000 ALTER TABLE `dc_orden_de_pago` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_de_pago` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_de_pago_cheques`
--

DROP TABLE IF EXISTS `dc_orden_de_pago_cheques`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_de_pago_cheques` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_de_pago_id` bigint(20) unsigned NOT NULL,
  `ctacte_cheque_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_de_pago_cheques_dc_orden_de_pago_id_foreign` (`dc_orden_de_pago_id`),
  KEY `dc_orden_de_pago_cheques_ctacte_cheque_id_foreign` (`ctacte_cheque_id`),
  CONSTRAINT `dc_orden_de_pago_cheques_ctacte_cheque_id_foreign` FOREIGN KEY (`ctacte_cheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `dc_orden_de_pago_cheques_dc_orden_de_pago_id_foreign` FOREIGN KEY (`dc_orden_de_pago_id`) REFERENCES `dc_orden_de_pago` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_de_pago_cheques`
--

LOCK TABLES `dc_orden_de_pago_cheques` WRITE;
/*!40000 ALTER TABLE `dc_orden_de_pago_cheques` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_de_pago_cheques` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_de_pago_receipts`
--

DROP TABLE IF EXISTS `dc_orden_de_pago_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_de_pago_receipts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_de_pago_id` bigint(20) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_de_pago_receipts_dc_orden_de_pago_id_foreign` (`dc_orden_de_pago_id`),
  KEY `dc_orden_de_pago_receipts_receipt_id_foreign` (`receipt_id`),
  CONSTRAINT `dc_orden_de_pago_receipts_dc_orden_de_pago_id_foreign` FOREIGN KEY (`dc_orden_de_pago_id`) REFERENCES `dc_orden_de_pago` (`id`),
  CONSTRAINT `dc_orden_de_pago_receipts_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_de_pago_receipts`
--

LOCK TABLES `dc_orden_de_pago_receipts` WRITE;
/*!40000 ALTER TABLE `dc_orden_de_pago_receipts` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_de_pago_receipts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_files`
--

DROP TABLE IF EXISTS `dc_orden_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `file` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_files_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_orden_files_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_files`
--

LOCK TABLES `dc_orden_files` WRITE;
/*!40000 ALTER TABLE `dc_orden_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes`
--

DROP TABLE IF EXISTS `dc_ordenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_tipo_id` bigint(20) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `titulo` text COLLATE utf8mb4_unicode_ci,
  `sucursal` int(11) NOT NULL DEFAULT '1',
  `numero` int(11) NOT NULL,
  `numero_text` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sector` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `solicitante` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `syj_empleado_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `fecha_entrega` date DEFAULT NULL,
  `fecha_asignacion` datetime DEFAULT NULL,
  `fecha_cumplido` datetime DEFAULT NULL,
  `condicion_venta_id` int(10) unsigned DEFAULT NULL,
  `is_pago_adelantado` tinyint(1) DEFAULT NULL,
  `is_garantia` tinyint(1) NOT NULL DEFAULT '0',
  `forma_de_entrega_id` int(10) unsigned DEFAULT NULL,
  `plazo_de_pago_id` int(10) unsigned DEFAULT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(16,2) NOT NULL DEFAULT '1.00',
  `neto` decimal(16,2) NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `total` decimal(16,2) NOT NULL,
  `facturada` decimal(16,2) NOT NULL DEFAULT '0.00',
  `is_pagada` tinyint(1) NOT NULL,
  `garantia` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mant_oferta` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comen_para_cliente` text COLLATE utf8mb4_unicode_ci,
  `comentario` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dc_ov_origen_id` bigint(20) unsigned DEFAULT NULL,
  `dc_ov_status_cobranza_id` bigint(20) unsigned DEFAULT NULL,
  `dc_ov_status_factura_id` bigint(20) unsigned DEFAULT NULL,
  `dc_ov_status_entrega_id` bigint(20) unsigned DEFAULT NULL,
  `dc_ov_status_venta_id` bigint(20) unsigned DEFAULT NULL,
  `dc_estado_id` bigint(20) unsigned NOT NULL,
  `dc_estado_decision_id` bigint(20) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_cc_id` bigint(20) unsigned DEFAULT NULL,
  `origendestinoable_type` text COLLATE utf8mb4_unicode_ci,
  `origendestinoable_id` int(10) unsigned DEFAULT NULL,
  `is_multiples_ot` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `dc_orden_origen_destino_id` bigint(20) unsigned DEFAULT NULL,
  `is_completado` tinyint(1) NOT NULL DEFAULT '0',
  `is_credit` tinyint(1) DEFAULT NULL,
  `dc_firma_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_dc_orden_tipo_id_foreign` (`dc_orden_tipo_id`),
  KEY `dc_ordenes_person_id_foreign` (`person_id`),
  KEY `dc_ordenes_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `dc_ordenes_dc_estado_id_foreign` (`dc_estado_id`),
  KEY `dc_ordenes_conta_cc_id_foreign` (`conta_cc_id`),
  KEY `dc_ordenes_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `dc_ordenes_dc_orden_origen_destino_id_foreign` (`dc_orden_origen_destino_id`),
  KEY `dc_ordenes_moneda_id_foreign` (`moneda_id`),
  KEY `dc_ordenes_dc_firma_id_foreign` (`dc_firma_id`),
  KEY `dc_ordenes_syj_empleado_id_foreign` (`syj_empleado_id`),
  KEY `dc_ordenes_dc_estado_decision_id_foreign` (`dc_estado_decision_id`),
  KEY `dc_ordenes_dc_ov_origen_id_foreign` (`dc_ov_origen_id`),
  KEY `dc_ordenes_dc_ov_status_venta_id_foreign` (`dc_ov_status_venta_id`),
  KEY `dc_ordenes_dc_ov_status_entrega_id_foreign` (`dc_ov_status_entrega_id`),
  KEY `dc_ordenes_dc_ov_status_factura_id_foreign` (`dc_ov_status_factura_id`),
  KEY `dc_ordenes_dc_ov_status_cobranza_id_foreign` (`dc_ov_status_cobranza_id`),
  CONSTRAINT `dc_ordenes_conta_cc_id_foreign` FOREIGN KEY (`conta_cc_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `dc_ordenes_dc_estado_decision_id_foreign` FOREIGN KEY (`dc_estado_decision_id`) REFERENCES `dc_estados_decisiones` (`id`),
  CONSTRAINT `dc_ordenes_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `dc_ordenes_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_ordenes_dc_orden_origen_destino_id_foreign` FOREIGN KEY (`dc_orden_origen_destino_id`) REFERENCES `dc_ordenes_origen_destino` (`id`),
  CONSTRAINT `dc_ordenes_dc_orden_tipo_id_foreign` FOREIGN KEY (`dc_orden_tipo_id`) REFERENCES `dc_ordenes_tipos` (`id`),
  CONSTRAINT `dc_ordenes_dc_ov_origen_id_foreign` FOREIGN KEY (`dc_ov_origen_id`) REFERENCES `dc_ov_origenes` (`id`),
  CONSTRAINT `dc_ordenes_dc_ov_status_cobranza_id_foreign` FOREIGN KEY (`dc_ov_status_cobranza_id`) REFERENCES `dc_ov_status_cobranza` (`id`),
  CONSTRAINT `dc_ordenes_dc_ov_status_entrega_id_foreign` FOREIGN KEY (`dc_ov_status_entrega_id`) REFERENCES `dc_ov_status_entrega` (`id`),
  CONSTRAINT `dc_ordenes_dc_ov_status_factura_id_foreign` FOREIGN KEY (`dc_ov_status_factura_id`) REFERENCES `dc_ov_status_factura` (`id`),
  CONSTRAINT `dc_ordenes_dc_ov_status_venta_id_foreign` FOREIGN KEY (`dc_ov_status_venta_id`) REFERENCES `dc_ov_status_venta` (`id`),
  CONSTRAINT `dc_ordenes_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `dc_ordenes_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `dc_ordenes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_ordenes_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_ordenes_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes`
--

LOCK TABLES `dc_ordenes` WRITE;
/*!40000 ALTER TABLE `dc_ordenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_compra_coti`
--

DROP TABLE IF EXISTS `dc_ordenes_compra_coti`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_compra_coti` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_coti_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_compra_coti_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_compra_coti_dc_orden_coti_id_foreign` (`dc_orden_coti_id`),
  CONSTRAINT `dc_ordenes_compra_coti_dc_orden_coti_id_foreign` FOREIGN KEY (`dc_orden_coti_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_compra_coti_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_compra_coti`
--

LOCK TABLES `dc_ordenes_compra_coti` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_compra_coti` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_compra_coti` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_compra_req`
--

DROP TABLE IF EXISTS `dc_ordenes_compra_req`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_compra_req` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_compra_req_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_compra_req_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_compra_req_dc_orden_req_id_foreign` (`dc_orden_req_id`),
  KEY `dc_ordenes_compra_req_dc_orden_req_detail_id_foreign` (`dc_orden_req_detail_id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_req_detail_id_foreign` FOREIGN KEY (`dc_orden_req_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_req_id_foreign` FOREIGN KEY (`dc_orden_req_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_compra_req`
--

LOCK TABLES `dc_ordenes_compra_req` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_compra_req` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_compra_req` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_cotizacion_req`
--

DROP TABLE IF EXISTS `dc_ordenes_cotizacion_req`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_cotizacion_req` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_cotizacion_req_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_cotizacion_req_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_cotizacion_req_dc_orden_req_id_foreign` (`dc_orden_req_id`),
  KEY `dc_ordenes_cotizacion_req_dc_orden_req_detail_id_foreign` (`dc_orden_req_detail_id`),
  CONSTRAINT `dc_ordenes_cotizacion_req_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_cotizacion_req_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_cotizacion_req_dc_orden_req_detail_id_foreign` FOREIGN KEY (`dc_orden_req_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_cotizacion_req_dc_orden_req_id_foreign` FOREIGN KEY (`dc_orden_req_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_cotizacion_req`
--

LOCK TABLES `dc_ordenes_cotizacion_req` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_cotizacion_req` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_cotizacion_req` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_details`
--

DROP TABLE IF EXISTS `dc_ordenes_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_origen_destino_id` bigint(20) unsigned DEFAULT NULL,
  `origendestinoable_id` int(10) unsigned DEFAULT NULL,
  `origendestinoable_type` text COLLATE utf8mb4_unicode_ci,
  `cantidades` decimal(16,2) NOT NULL,
  `inv_deposito_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id_destino` bigint(20) unsigned DEFAULT NULL,
  `prod_variant_id` bigint(20) unsigned DEFAULT NULL,
  `inv_deposito_id_destino` bigint(20) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `neto` decimal(16,2) NOT NULL,
  `desc_porc` decimal(16,2) DEFAULT NULL,
  `descuento` decimal(16,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `subtotal` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_details_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_details_inv_producto_id_foreign` (`inv_producto_id`),
  KEY `dc_ordenes_details_system_tax_id_foreign` (`system_tax_id`),
  KEY `dc_ordenes_details_inv_producto_id_destino_foreign` (`inv_producto_id_destino`),
  KEY `dc_ordenes_details_dc_orden_origen_destino_id_foreign` (`dc_orden_origen_destino_id`),
  KEY `dc_ordenes_details_inv_deposito_id_foreign` (`inv_deposito_id`),
  KEY `dc_ordenes_details_inv_deposito_id_destino_foreign` (`inv_deposito_id_destino`),
  KEY `dc_ordenes_details_prod_variant_id_foreign` (`prod_variant_id`),
  CONSTRAINT `dc_ordenes_details_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_details_dc_orden_origen_destino_id_foreign` FOREIGN KEY (`dc_orden_origen_destino_id`) REFERENCES `dc_ordenes_origen_destino` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_deposito_id_destino_foreign` FOREIGN KEY (`inv_deposito_id_destino`) REFERENCES `inv_depositos` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_deposito_id_foreign` FOREIGN KEY (`inv_deposito_id`) REFERENCES `inv_depositos` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_producto_id_destino_foreign` FOREIGN KEY (`inv_producto_id_destino`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `dc_ordenes_details_prod_variant_id_foreign` FOREIGN KEY (`prod_variant_id`) REFERENCES `prod_variants` (`id`) ON DELETE SET NULL,
  CONSTRAINT `dc_ordenes_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_details`
--

LOCK TABLES `dc_ordenes_details` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_facturada`
--

DROP TABLE IF EXISTS `dc_ordenes_facturada`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_facturada` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(11) DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_facturada_person_id_foreign` (`person_id`),
  KEY `dc_ordenes_facturada_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_facturada_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `dc_ordenes_facturada_receipt_id_foreign` (`receipt_id`),
  CONSTRAINT `dc_ordenes_facturada_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_facturada_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_ordenes_facturada_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_facturada`
--

LOCK TABLES `dc_ordenes_facturada` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_facturada` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_facturada` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_ingreso_compra`
--

DROP TABLE IF EXISTS `dc_ordenes_ingreso_compra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_ingreso_compra` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_compra_id_foreign` (`dc_orden_compra_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_compra_detail_id_foreign` (`dc_orden_compra_detail_id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_compra_detail_id_foreign` FOREIGN KEY (`dc_orden_compra_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_compra_id_foreign` FOREIGN KEY (`dc_orden_compra_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_ingreso_compra`
--

LOCK TABLES `dc_ordenes_ingreso_compra` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_ingreso_compra` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_ingreso_compra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_ingxdev_rem_egr`
--

DROP TABLE IF EXISTS `dc_ordenes_ingxdev_rem_egr`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_ingxdev_rem_egr` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_rem_egr_id` bigint(20) unsigned NOT NULL,
  `dc_orden_rem_egr_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_ingxdev_rem_egr_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_ingxdev_rem_egr_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_ingxdev_rem_egr_dc_orden_rem_egr_id_foreign` (`dc_orden_rem_egr_id`),
  KEY `dc_ordenes_ingxdev_rem_egr_dc_orden_rem_egr_detail_id_foreign` (`dc_orden_rem_egr_detail_id`),
  CONSTRAINT `dc_ordenes_ingxdev_rem_egr_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_ingxdev_rem_egr_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_ingxdev_rem_egr_dc_orden_rem_egr_detail_id_foreign` FOREIGN KEY (`dc_orden_rem_egr_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_ingxdev_rem_egr_dc_orden_rem_egr_id_foreign` FOREIGN KEY (`dc_orden_rem_egr_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_ingxdev_rem_egr`
--

LOCK TABLES `dc_ordenes_ingxdev_rem_egr` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_ingxdev_rem_egr` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_ingxdev_rem_egr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_logs`
--

DROP TABLE IF EXISTS `dc_ordenes_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `loggable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `loggable_id` bigint(20) unsigned NOT NULL,
  `related_id` bigint(20) unsigned DEFAULT NULL,
  `related_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_logs_loggable_type_loggable_id_index` (`loggable_type`,`loggable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_logs`
--

LOCK TABLES `dc_ordenes_logs` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_origen_destino`
--

DROP TABLE IF EXISTS `dc_ordenes_origen_destino`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_origen_destino` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `modelo` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_deposito` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_origen_destino`
--

LOCK TABLES `dc_ordenes_origen_destino` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_origen_destino` DISABLE KEYS */;
INSERT INTO `dc_ordenes_origen_destino` VALUES (1,NULL,'Orden de Trabajo','App\\Models\\Inventario\\InvOrdenTrabajo',0,1,NULL,NULL,NULL),(2,NULL,'Centro de Costos','App\\Models\\Inventario\\InvOrdenTrabajoHorasTipo',0,1,NULL,'2023-09-12 22:17:29',NULL),(3,NULL,'Deposito','App\\Models\\Inventario\\InvDeposito',1,1,NULL,'2024-05-07 20:11:43',NULL),(4,NULL,'Empleado','App\\Models\\SyJEmpleado',0,0,NULL,'2023-07-03 22:08:06',NULL);
/*!40000 ALTER TABLE `dc_ordenes_origen_destino` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_pdf_templates`
--

DROP TABLE IF EXISTS `dc_ordenes_pdf_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_pdf_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_tipo_id` bigint(20) unsigned NOT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `vista_blade` text COLLATE utf8mb4_unicode_ci,
  `pdf_base_path` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tipo_plantilla` enum('blade','pdf_base') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'blade',
  `configuracion` json DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_person_tipo_template` (`person_id`,`dc_orden_tipo_id`),
  KEY `dc_ordenes_pdf_templates_dc_orden_tipo_id_foreign` (`dc_orden_tipo_id`),
  CONSTRAINT `dc_ordenes_pdf_templates_dc_orden_tipo_id_foreign` FOREIGN KEY (`dc_orden_tipo_id`) REFERENCES `dc_ordenes_tipos` (`id`),
  CONSTRAINT `dc_ordenes_pdf_templates_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_pdf_templates`
--

LOCK TABLES `dc_ordenes_pdf_templates` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_pdf_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_pdf_templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_revocadas`
--

DROP TABLE IF EXISTS `dc_ordenes_revocadas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_revocadas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `comentario` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_revocadas_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_ordenes_revocadas_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_revocadas`
--

LOCK TABLES `dc_ordenes_revocadas` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_revocadas` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_revocadas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_servicio_compra`
--

DROP TABLE IF EXISTS `dc_ordenes_servicio_compra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_servicio_compra` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_compra_id_foreign` (`dc_orden_compra_id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_compra_detail_id_foreign` (`dc_orden_compra_detail_id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_compra_detail_id_foreign` FOREIGN KEY (`dc_orden_compra_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_compra_id_foreign` FOREIGN KEY (`dc_orden_compra_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_servicio_compra`
--

LOCK TABLES `dc_ordenes_servicio_compra` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_servicio_compra` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_servicio_compra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_tipos`
--

DROP TABLE IF EXISTS `dc_ordenes_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `usabilidad` longtext COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_tipos`
--

LOCK TABLES `dc_ordenes_tipos` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_tipos` DISABLE KEYS */;
INSERT INTO `dc_ordenes_tipos` VALUES (1,NULL,'ORDEN DE COMPRAS',NULL,1,NULL,'2022-09-09 16:51:30',NULL),(2,NULL,'ORDEN DE VENTAS',NULL,1,NULL,'2022-09-09 16:51:30',NULL),(3,NULL,'PRESUPUESTO',NULL,1,NULL,NULL,NULL),(4,NULL,'REQUERIMIENTO',NULL,1,NULL,NULL,NULL),(5,NULL,'REMITO DE INGRESO',NULL,1,NULL,'2023-06-12 23:26:47',NULL),(6,NULL,'REMITO DE EGRESO',NULL,1,NULL,NULL,NULL),(7,NULL,'REMITO INTERNO',NULL,1,NULL,NULL,NULL),(8,NULL,'REMITO DE INGRESO','Es lo mismo que un remito de ingreso, \n        pero los productosa ingresar provienen de una Orden de Compra',1,NULL,NULL,NULL),(9,NULL,'REMITO DE SERVICIO','Es un remito de Ingreso de un servicio que se\n        asigna directo a una OT',1,NULL,NULL,NULL),(10,NULL,'ORDEN DE PAGO',NULL,1,'2023-09-28 16:29:26','2023-09-28 16:29:26',NULL),(11,NULL,'ANULACION REQUERIMIENTOS',NULL,1,'2024-04-02 23:06:49','2024-04-02 23:06:49',NULL),(12,NULL,'ANULACION COMPRAS PRODUCTOS',NULL,1,'2024-04-02 23:06:49','2024-04-02 23:06:49',NULL),(13,NULL,'ANULACION COMPRAS SERVICIOS',NULL,1,'2024-04-02 23:06:49','2024-04-02 23:06:49',NULL),(14,NULL,'REMITO DE GASTO',NULL,1,'2024-05-07 20:11:43','2024-05-07 20:11:43',NULL),(15,NULL,'COTIZACIONES',NULL,1,'2024-06-26 07:53:04','2024-06-26 07:53:04',NULL),(16,NULL,'REMITO INGRESO-DEVOLUCION',NULL,1,'2024-09-02 13:17:23','2024-09-02 13:17:23',NULL),(17,NULL,'REMITO EGRESO-DEVOLUCION',NULL,1,'2024-10-17 08:50:54','2024-10-17 08:50:54',NULL),(18,NULL,'REMITO','Es un remito de servicio, que no tiene ni ingreso ni egreso',1,'2024-12-03 21:45:34','2024-12-03 21:45:34',NULL),(19,NULL,'Remito de Cliente','Se usa en las Ordenes de Venta para demostrar que se entrego mercaderia al cliente',1,NULL,NULL,NULL),(20,NULL,'Orden de Compra de Cliente','Es la OC que envia el cliente para que se le haga el pedido',1,NULL,NULL,NULL),(21,NULL,'Solicitud de Facturacion','Es un documento que se usa para que se pueda facturar',1,NULL,NULL,NULL),(22,NULL,'Ordenes de Compra','Es una OC para Empresas',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_ordenes_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_cta_cte_cliente`
--

DROP TABLE IF EXISTS `dc_ov_cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_cta_cte_cliente` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_cta_cte_cliente_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ov_cta_cte_cliente_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  CONSTRAINT `dc_ov_cta_cte_cliente_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `dc_ov_cta_cte_cliente_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_cta_cte_cliente`
--

LOCK TABLES `dc_ov_cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `dc_ov_cta_cte_cliente` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_cta_cte_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_fact_electronicas`
--

DROP TABLE IF EXISTS `dc_ov_fact_electronicas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_fact_electronicas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `fact_elec_receipt_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_fact_electronicas_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ov_fact_electronicas_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  CONSTRAINT `dc_ov_fact_electronicas_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ov_fact_electronicas_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_fact_electronicas`
--

LOCK TABLES `dc_ov_fact_electronicas` WRITE;
/*!40000 ALTER TABLE `dc_ov_fact_electronicas` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_fact_electronicas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_oc_presupuestos`
--

DROP TABLE IF EXISTS `dc_ov_oc_presupuestos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_oc_presupuestos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_presupuesto_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_oc_presupuestos_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ov_oc_presupuestos_dc_orden_presupuesto_id_foreign` (`dc_orden_presupuesto_id`),
  CONSTRAINT `dc_ov_oc_presupuestos_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ov_oc_presupuestos_dc_orden_presupuesto_id_foreign` FOREIGN KEY (`dc_orden_presupuesto_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_oc_presupuestos`
--

LOCK TABLES `dc_ov_oc_presupuestos` WRITE;
/*!40000 ALTER TABLE `dc_ov_oc_presupuestos` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_oc_presupuestos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_ocs`
--

DROP TABLE IF EXISTS `dc_ov_ocs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_ocs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_ocs_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ov_ocs_dc_orden_compra_id_foreign` (`dc_orden_compra_id`),
  CONSTRAINT `dc_ov_ocs_dc_orden_compra_id_foreign` FOREIGN KEY (`dc_orden_compra_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ov_ocs_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_ocs`
--

LOCK TABLES `dc_ov_ocs` WRITE;
/*!40000 ALTER TABLE `dc_ov_ocs` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_ocs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_origenes`
--

DROP TABLE IF EXISTS `dc_ov_origenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_origenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_origenes`
--

LOCK TABLES `dc_ov_origenes` WRITE;
/*!40000 ALTER TABLE `dc_ov_origenes` DISABLE KEYS */;
INSERT INTO `dc_ov_origenes` VALUES (1,NULL,'Taller',1,NULL,NULL,NULL),(2,NULL,'Comercial',1,NULL,NULL,NULL),(3,NULL,'Repuestos',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_ov_origenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_origenes_users`
--

DROP TABLE IF EXISTS `dc_ov_origenes_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_origenes_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dc_ov_origen_id` bigint(20) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_origenes_users_dc_ov_origen_id_foreign` (`dc_ov_origen_id`),
  CONSTRAINT `dc_ov_origenes_users_dc_ov_origen_id_foreign` FOREIGN KEY (`dc_ov_origen_id`) REFERENCES `dc_ov_origenes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_origenes_users`
--

LOCK TABLES `dc_ov_origenes_users` WRITE;
/*!40000 ALTER TABLE `dc_ov_origenes_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_origenes_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_ots`
--

DROP TABLE IF EXISTS `dc_ov_ots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_ots` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `ot_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_ots_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ov_ots_ot_id_foreign` (`ot_id`),
  CONSTRAINT `dc_ov_ots_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ov_ots_ot_id_foreign` FOREIGN KEY (`ot_id`) REFERENCES `inv_orden_trabajos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_ots`
--

LOCK TABLES `dc_ov_ots` WRITE;
/*!40000 ALTER TABLE `dc_ov_ots` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_ots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_pres_clientes`
--

DROP TABLE IF EXISTS `dc_ov_pres_clientes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_pres_clientes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_pres_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_pres_clientes_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ov_pres_clientes_dc_orden_pres_id_foreign` (`dc_orden_pres_id`),
  CONSTRAINT `dc_ov_pres_clientes_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ov_pres_clientes_dc_orden_pres_id_foreign` FOREIGN KEY (`dc_orden_pres_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_pres_clientes`
--

LOCK TABLES `dc_ov_pres_clientes` WRITE;
/*!40000 ALTER TABLE `dc_ov_pres_clientes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_pres_clientes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_rem_clientes`
--

DROP TABLE IF EXISTS `dc_ov_rem_clientes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_rem_clientes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_rem_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_rem_clientes_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ov_rem_clientes_dc_orden_rem_id_foreign` (`dc_orden_rem_id`),
  CONSTRAINT `dc_ov_rem_clientes_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ov_rem_clientes_dc_orden_rem_id_foreign` FOREIGN KEY (`dc_orden_rem_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_rem_clientes`
--

LOCK TABLES `dc_ov_rem_clientes` WRITE;
/*!40000 ALTER TABLE `dc_ov_rem_clientes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_rem_clientes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_remc_occ`
--

DROP TABLE IF EXISTS `dc_ov_remc_occ`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_remc_occ` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `dc_orden_id` bigint(20) unsigned DEFAULT NULL,
  `dc_orden_detail_id` bigint(20) unsigned DEFAULT NULL,
  `dc_occ_id` bigint(20) unsigned DEFAULT NULL,
  `dc_occ_detail_id` bigint(20) unsigned DEFAULT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_remc_occ_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ov_remc_occ_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ov_remc_occ_dc_occ_id_foreign` (`dc_occ_id`),
  KEY `dc_ov_remc_occ_dc_occ_detail_id_foreign` (`dc_occ_detail_id`),
  CONSTRAINT `dc_ov_remc_occ_dc_occ_detail_id_foreign` FOREIGN KEY (`dc_occ_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ov_remc_occ_dc_occ_id_foreign` FOREIGN KEY (`dc_occ_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ov_remc_occ_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ov_remc_occ_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_remc_occ`
--

LOCK TABLES `dc_ov_remc_occ` WRITE;
/*!40000 ALTER TABLE `dc_ov_remc_occ` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_remc_occ` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_sol_facturacion`
--

DROP TABLE IF EXISTS `dc_ov_sol_facturacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_sol_facturacion` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_sol_facturacion_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ov_sol_facturacion_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ov_sol_facturacion_dc_sol_facturacion_id_foreign` (`dc_sol_facturacion_id`),
  CONSTRAINT `dc_ov_sol_facturacion_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ov_sol_facturacion_dc_sol_facturacion_id_foreign` FOREIGN KEY (`dc_sol_facturacion_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_sol_facturacion`
--

LOCK TABLES `dc_ov_sol_facturacion` WRITE;
/*!40000 ALTER TABLE `dc_ov_sol_facturacion` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ov_sol_facturacion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_status_cobranza`
--

DROP TABLE IF EXISTS `dc_ov_status_cobranza`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_status_cobranza` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_status_cobranza`
--

LOCK TABLES `dc_ov_status_cobranza` WRITE;
/*!40000 ALTER TABLE `dc_ov_status_cobranza` DISABLE KEYS */;
INSERT INTO `dc_ov_status_cobranza` VALUES (1,NULL,'Pendiente',1,NULL,NULL,NULL),(2,NULL,'Parcial',1,NULL,NULL,NULL),(3,NULL,'Completa',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_ov_status_cobranza` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_status_entrega`
--

DROP TABLE IF EXISTS `dc_ov_status_entrega`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_status_entrega` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_status_entrega`
--

LOCK TABLES `dc_ov_status_entrega` WRITE;
/*!40000 ALTER TABLE `dc_ov_status_entrega` DISABLE KEYS */;
INSERT INTO `dc_ov_status_entrega` VALUES (1,NULL,'Pendiente',1,NULL,NULL,NULL),(2,NULL,'Parcial',1,NULL,NULL,NULL),(3,NULL,'Completa',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_ov_status_entrega` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_status_factura`
--

DROP TABLE IF EXISTS `dc_ov_status_factura`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_status_factura` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_status_factura`
--

LOCK TABLES `dc_ov_status_factura` WRITE;
/*!40000 ALTER TABLE `dc_ov_status_factura` DISABLE KEYS */;
INSERT INTO `dc_ov_status_factura` VALUES (1,NULL,'Pendiente',1,NULL,NULL,NULL),(2,NULL,'Facturable',1,NULL,NULL,NULL),(3,NULL,'Facturado Parcialmente',1,NULL,NULL,NULL),(4,NULL,'Facturado Totalmente',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_ov_status_factura` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ov_status_venta`
--

DROP TABLE IF EXISTS `dc_ov_status_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ov_status_venta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ov_status_venta`
--

LOCK TABLES `dc_ov_status_venta` WRITE;
/*!40000 ALTER TABLE `dc_ov_status_venta` DISABLE KEYS */;
INSERT INTO `dc_ov_status_venta` VALUES (1,NULL,'Pendiente',1,NULL,NULL,NULL),(2,NULL,'Presupuesto',1,NULL,NULL,NULL),(3,NULL,'Venta',1,NULL,NULL,NULL),(4,NULL,'Rechazada',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_ov_status_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_sol_fac_occ`
--

DROP TABLE IF EXISTS `dc_sol_fac_occ`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_sol_fac_occ` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL COMMENT 'Solicitud Facturación (tipo 21)',
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL COMMENT 'Detalle de SF',
  `dc_occ_id` bigint(20) unsigned NOT NULL COMMENT 'OC Cliente (tipo 20)',
  `dc_occ_detail_id` bigint(20) unsigned NOT NULL COMMENT 'Detalle de OCC',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_sf` (`dc_orden_id`),
  KEY `idx_occ` (`dc_occ_id`),
  KEY `dc_sol_fac_occ_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_sol_fac_occ_dc_occ_detail_id_foreign` (`dc_occ_detail_id`),
  CONSTRAINT `dc_sol_fac_occ_dc_occ_detail_id_foreign` FOREIGN KEY (`dc_occ_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_sol_fac_occ_dc_occ_id_foreign` FOREIGN KEY (`dc_occ_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_sol_fac_occ_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_sol_fac_occ_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_sol_fac_occ`
--

LOCK TABLES `dc_sol_fac_occ` WRITE;
/*!40000 ALTER TABLE `dc_sol_fac_occ` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_sol_fac_occ` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `despachos`
--

DROP TABLE IF EXISTS `despachos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `despachos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL,
  `fecha` datetime NOT NULL DEFAULT '2025-04-28 16:06:28',
  `is_ponderacion_autom` tinyint(1) NOT NULL DEFAULT '1',
  `is_garantia` tinyint(1) NOT NULL DEFAULT '0',
  `numero` int(10) unsigned DEFAULT NULL,
  `comentario` longtext COLLATE utf8mb4_unicode_ci,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_parte_1` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_parte_2` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_parte_3` decimal(16,2) NOT NULL DEFAULT '0.00',
  `cotizacion` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `despachos_person_id_foreign` (`person_id`),
  KEY `despachos_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `despachos_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `despachos_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `despachos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `despachos_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `despachos`
--

LOCK TABLES `despachos` WRITE;
/*!40000 ALTER TABLE `despachos` DISABLE KEYS */;
/*!40000 ALTER TABLE `despachos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `despachos_cierres`
--

DROP TABLE IF EXISTS `despachos_cierres`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `despachos_cierres` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `despacho_id` bigint(20) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `costo_antes` decimal(16,2) NOT NULL DEFAULT '0.00',
  `cantidades` decimal(16,2) DEFAULT '0.00',
  `precio_x_cantidad` decimal(16,2) DEFAULT '0.00',
  `ratio` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `incremento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `incremento_x_cantidad` decimal(16,2) DEFAULT '0.00',
  `costo_despues` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `despachos_cierres_despacho_id_foreign` (`despacho_id`),
  KEY `despachos_cierres_receipt_id_foreign` (`receipt_id`),
  KEY `despachos_cierres_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `despachos_cierres_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `despachos_cierres_inv_producto_id_foreign` (`inv_producto_id`),
  CONSTRAINT `despachos_cierres_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `despachos_cierres_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `despachos_cierres_despacho_id_foreign` FOREIGN KEY (`despacho_id`) REFERENCES `despachos` (`id`),
  CONSTRAINT `despachos_cierres_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `despachos_cierres_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `despachos_cierres`
--

LOCK TABLES `despachos_cierres` WRITE;
/*!40000 ALTER TABLE `despachos_cierres` DISABLE KEYS */;
/*!40000 ALTER TABLE `despachos_cierres` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `despachos_details`
--

DROP TABLE IF EXISTS `despachos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `despachos_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `despacho_id` bigint(20) unsigned NOT NULL,
  `despacho_parte_id` bigint(20) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `porcentaje_ponderacion` decimal(8,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `despachos_details_despacho_id_foreign` (`despacho_id`),
  KEY `despachos_details_despacho_parte_id_foreign` (`despacho_parte_id`),
  KEY `despachos_details_receipt_id_foreign` (`receipt_id`),
  CONSTRAINT `despachos_details_despacho_id_foreign` FOREIGN KEY (`despacho_id`) REFERENCES `despachos` (`id`),
  CONSTRAINT `despachos_details_despacho_parte_id_foreign` FOREIGN KEY (`despacho_parte_id`) REFERENCES `despachos_partes` (`id`),
  CONSTRAINT `despachos_details_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `despachos_details`
--

LOCK TABLES `despachos_details` WRITE;
/*!40000 ALTER TABLE `despachos_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `despachos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `despachos_files`
--

DROP TABLE IF EXISTS `despachos_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `despachos_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `despacho_id` bigint(20) unsigned NOT NULL,
  `descripcion` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name_original` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `despachos_files_despacho_id_foreign` (`despacho_id`),
  CONSTRAINT `despachos_files_despacho_id_foreign` FOREIGN KEY (`despacho_id`) REFERENCES `despachos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `despachos_files`
--

LOCK TABLES `despachos_files` WRITE;
/*!40000 ALTER TABLE `despachos_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `despachos_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `despachos_partes`
--

DROP TABLE IF EXISTS `despachos_partes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `despachos_partes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `despachos_partes`
--

LOCK TABLES `despachos_partes` WRITE;
/*!40000 ALTER TABLE `despachos_partes` DISABLE KEYS */;
INSERT INTO `despachos_partes` VALUES (1,NULL,'Facturas del Proveedor',1,NULL,NULL,NULL),(2,NULL,'Despachos de Importacion',1,NULL,NULL,NULL),(3,NULL,'Facturas de Logistica',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `despachos_partes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `deudas_impositivas`
--

DROP TABLE IF EXISTS `deudas_impositivas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `deudas_impositivas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `vto_impuesto_id` int(10) unsigned NOT NULL,
  `periodo_deuda` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `deudas_impositivas_vto_impuesto_id_foreign` (`vto_impuesto_id`),
  KEY `deudas_impositivas_person_id_foreign` (`person_id`),
  CONSTRAINT `deudas_impositivas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `deudas_impositivas_vto_impuesto_id_foreign` FOREIGN KEY (`vto_impuesto_id`) REFERENCES `vto_impuestos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `deudas_impositivas`
--

LOCK TABLES `deudas_impositivas` WRITE;
/*!40000 ALTER TABLE `deudas_impositivas` DISABLE KEYS */;
/*!40000 ALTER TABLE `deudas_impositivas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ejer_anteriores`
--

DROP TABLE IF EXISTS `ejer_anteriores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ejer_anteriores` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `anio` int(11) NOT NULL,
  `ventas` decimal(16,2) DEFAULT NULL,
  `compras` decimal(16,2) DEFAULT NULL,
  `sueldos` decimal(16,2) DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `apagar` decimal(16,2) DEFAULT NULL,
  `afavor` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ejer_anteriores_person_id_foreign` (`person_id`),
  CONSTRAINT `ejer_anteriores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ejer_anteriores`
--

LOCK TABLES `ejer_anteriores` WRITE;
/*!40000 ALTER TABLE `ejer_anteriores` DISABLE KEYS */;
/*!40000 ALTER TABLE `ejer_anteriores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estado_civil`
--

DROP TABLE IF EXISTS `estado_civil`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estado_civil` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `estado_civil_descripcion_unique` (`descripcion`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estado_civil`
--

LOCK TABLES `estado_civil` WRITE;
/*!40000 ALTER TABLE `estado_civil` DISABLE KEYS */;
INSERT INTO `estado_civil` VALUES (1,NULL,'Separado Legal',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(2,NULL,'Separado de Hecho',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(3,NULL,'Divorciado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(4,NULL,'Convivencia',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(5,NULL,'Soltero',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(6,NULL,'Casado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(7,NULL,'Viudo',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `estado_civil` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva`
--

DROP TABLE IF EXISTS `fa_masiva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva`
--

LOCK TABLES `fa_masiva` WRITE;
/*!40000 ALTER TABLE `fa_masiva` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_detalle`
--

DROP TABLE IF EXISTS `fa_masiva_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_detalle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fa_masiva_id` int(11) NOT NULL,
  `cliente_id` int(11) NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL DEFAULT '1',
  `zone_id` int(10) unsigned NOT NULL DEFAULT '22',
  `activity_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `concepto_id` int(10) unsigned NOT NULL DEFAULT '1',
  `taxable_iibb` int(10) unsigned NOT NULL DEFAULT '2',
  `renglon1` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe1` decimal(20,2) DEFAULT NULL,
  `renglon2` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe2` decimal(20,2) DEFAULT NULL,
  `renglon3` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe3` decimal(20,2) DEFAULT NULL,
  `punto_venta_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date DEFAULT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_detalle_concepto_id_foreign` (`concepto_id`),
  KEY `fa_masiva_detalle_system_tax_id_foreign` (`system_tax_id`),
  KEY `fa_masiva_detalle_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  KEY `fa_masiva_detalle_zone_id_foreign` (`zone_id`),
  KEY `fa_masiva_detalle_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fa_masiva_detalle_activity_id_foreign` (`activity_id`),
  CONSTRAINT `fa_masiva_detalle_activity_id_foreign` FOREIGN KEY (`activity_id`) REFERENCES `activities` (`id`),
  CONSTRAINT `fa_masiva_detalle_concepto_id_foreign` FOREIGN KEY (`concepto_id`) REFERENCES `fact_elec_conceptos_afip` (`id`),
  CONSTRAINT `fa_masiva_detalle_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `fac_elec_cond_frente_iva` (`id`),
  CONSTRAINT `fa_masiva_detalle_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`),
  CONSTRAINT `fa_masiva_detalle_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`),
  CONSTRAINT `fa_masiva_detalle_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_detalle`
--

LOCK TABLES `fa_masiva_detalle` WRITE;
/*!40000 ALTER TABLE `fa_masiva_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_stock`
--

DROP TABLE IF EXISTS `fa_masiva_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_stock_person_id_foreign` (`person_id`),
  KEY `fa_masiva_stock_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `fa_masiva_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fa_masiva_stock_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_stock`
--

LOCK TABLES `fa_masiva_stock` WRITE;
/*!40000 ALTER TABLE `fa_masiva_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_cond_frente_iva`
--

DROP TABLE IF EXISTS `fac_elec_cond_frente_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_cond_frente_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_cond_frente_iva_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_cond_frente_iva`
--

LOCK TABLES `fac_elec_cond_frente_iva` WRITE;
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` DISABLE KEYS */;
INSERT INTO `fac_elec_cond_frente_iva` VALUES (1,'IVA Responsable Inscripto','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'IVA Sujeto Exento','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Consumidor Final','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Responsable Monotributo','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Proveedor del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Cliente del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'IVA Liberado - Ley Nº 19.640','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'IVA Responsable Inscripto - Agente de Percepción','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Monotributista Social','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'IVA No Alcanzado','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_unidad_medidas`
--

DROP TABLE IF EXISTS `fac_elec_unidad_medidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_unidad_medidas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_unidad_medidas_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_unidad_medidas`
--

LOCK TABLES `fac_elec_unidad_medidas` WRITE;
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` DISABLE KEYS */;
INSERT INTO `fac_elec_unidad_medidas` VALUES (1,'Grs','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'Kg','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Mts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Mts2','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Mts3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Lts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'1000 Kwh','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'Unidades','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Pares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'Doc','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(11,'Quilates','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(12,'Millares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(13,'Milimetros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(14,'Mm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(15,'Km','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(16,'Hectolitros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(17,'Cm','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(18,'Cm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_conceptos_afip`
--

DROP TABLE IF EXISTS `fact_elec_conceptos_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_conceptos_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_comprobante_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_conceptos_afip`
--

LOCK TABLES `fact_elec_conceptos_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_conceptos_afip` VALUES (1,1,'Producto','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'Productos y Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_perc_ret`
--

DROP TABLE IF EXISTS `fact_elec_perc_ret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_perc_ret` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` int(10) unsigned NOT NULL,
  `other_tax_id` int(10) unsigned NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_perc_ret_other_tax_id_foreign` (`other_tax_id`),
  CONSTRAINT `fact_elec_perc_ret_other_tax_id_foreign` FOREIGN KEY (`other_tax_id`) REFERENCES `other_taxes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_perc_ret`
--

LOCK TABLES `fact_elec_perc_ret` WRITE;
/*!40000 ALTER TABLE `fact_elec_perc_ret` DISABLE KEYS */;
INSERT INTO `fact_elec_perc_ret` VALUES (1,NULL,'Per./Ret de Imp. a las Ganancias',1,1032,1,NULL,NULL,NULL),(2,NULL,'Per./Ret de IVA',1,1000,1,NULL,NULL,NULL),(3,NULL,'Per./Ret de IIBB',2,1006,1,NULL,NULL,NULL),(4,NULL,'Impuestos Internos',4,1001,1,NULL,NULL,NULL),(5,NULL,'Impuestos Municipales',3,1031,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `fact_elec_perc_ret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_perc_ret_details`
--

DROP TABLE IF EXISTS `fact_elec_perc_ret_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_perc_ret_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fact_elec_perc_ret_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `detalle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zone_id` int(10) unsigned DEFAULT NULL,
  `base_imponible` decimal(16,2) DEFAULT NULL,
  `alicuota` decimal(16,2) DEFAULT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_perc_ret_details_fact_elec_perc_ret_id_foreign` (`fact_elec_perc_ret_id`),
  KEY `fact_elec_perc_ret_details_person_id_foreign` (`person_id`),
  KEY `fact_elec_perc_ret_details_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `fact_elec_perc_ret_details_zone_id_foreign` (`zone_id`),
  CONSTRAINT `fact_elec_perc_ret_details_fact_elec_perc_ret_id_foreign` FOREIGN KEY (`fact_elec_perc_ret_id`) REFERENCES `fact_elec_perc_ret` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_perc_ret_details`
--

LOCK TABLES `fact_elec_perc_ret_details` WRITE;
/*!40000 ALTER TABLE `fact_elec_perc_ret_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_perc_ret_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_puntos_venta`
--

DROP TABLE IF EXISTS `fact_elec_puntos_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_puntos_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `direccion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `codigo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '0000',
  `codigo_postal` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_puntos_venta_person_id_foreign` (`person_id`),
  CONSTRAINT `fact_elec_puntos_venta_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_puntos_venta`
--

LOCK TABLES `fact_elec_puntos_venta` WRITE;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipt_details`
--

DROP TABLE IF EXISTS `fact_elec_receipt_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipt_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cantidad` decimal(20,2) NOT NULL,
  `unidad_medida` text COLLATE utf8mb4_unicode_ci,
  `precio_unitario` decimal(20,2) NOT NULL,
  `neto_gravado` decimal(20,2) NOT NULL,
  `bonificacion_porcentaje` decimal(20,2) DEFAULT NULL,
  `bonificacion_monto` decimal(20,2) DEFAULT NULL,
  `bonificacion_subtotal` decimal(20,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `iva_monto` decimal(20,2) DEFAULT NULL,
  `iva_subtotal` decimal(20,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `codigo` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipt_details_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `fact_elec_receipt_details_system_tax_id_foreign` (`system_tax_id`),
  CONSTRAINT `fact_elec_receipt_details_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `fact_elec_receipt_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipt_details`
--

LOCK TABLES `fact_elec_receipt_details` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipt_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_receipt_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipts`
--

DROP TABLE IF EXISTS `fact_elec_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date NOT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `concepto_id` int(10) unsigned NOT NULL,
  `punto_venta_id` int(10) unsigned NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL,
  `condiciones_venta` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comprobante_asoc` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `cae` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cae_vencimiento` date DEFAULT NULL,
  `nro_comprobante_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_proceso_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_receptor` int(10) unsigned NOT NULL,
  `condicion_venta_id` int(11) DEFAULT NULL,
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `opcion_transferencia` longtext COLLATE utf8mb4_unicode_ci,
  `referencia` text COLLATE utf8mb4_unicode_ci,
  `alias_cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_otros_tributos` decimal(16,2) DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipts_user_id_foreign` (`user_id`),
  KEY `fact_elec_receipts_punto_venta_id_foreign` (`punto_venta_id`),
  KEY `fact_elec_receipts_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fact_elec_receipts_person_id_foreign` (`person_id`),
  KEY `fact_elec_receipts_person_id_receptor_foreign` (`person_id_receptor`),
  KEY `fact_elec_receipts_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  KEY `fact_elec_receipts_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `fact_elec_receipts_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `condicion_frente_al_iva` (`id`),
  CONSTRAINT `fact_elec_receipts_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_receptor_foreign` FOREIGN KEY (`person_id_receptor`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_punto_venta_id_foreign` FOREIGN KEY (`punto_venta_id`) REFERENCES `fact_elec_puntos_venta` (`id`),
  CONSTRAINT `fact_elec_receipts_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipts`
--

LOCK TABLES `fact_elec_receipts` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipts` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_receipts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_tipos_docs_afip`
--

DROP TABLE IF EXISTS `fact_elec_tipos_docs_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_tipos_docs_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_tipo_doc_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_tipos_docs_afip`
--

LOCK TABLES `fact_elec_tipos_docs_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_tipos_docs_afip` VALUES (1,1,'CI Buenos Aires','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'CI Catamarca','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'CI Córdoba','2019-03-13 13:29:34','2019-03-13 13:29:34'),(4,4,'CI Corrientes','2019-03-13 13:29:34','2019-03-13 13:29:34'),(5,5,'CI Entre Ríos','2019-03-13 13:29:34','2019-03-13 13:29:34'),(6,6,'CI Jujuy','2019-03-13 13:29:34','2019-03-13 13:29:34'),(7,7,'CI Mendoza','2019-03-13 13:29:34','2019-03-13 13:29:34'),(8,8,'CI La Rioja','2019-03-13 13:29:34','2019-03-13 13:29:34'),(9,9,'CI Salta','2019-03-13 13:29:34','2019-03-13 13:29:34'),(10,10,'CI San Juan','2019-03-13 13:29:34','2019-03-13 13:29:34'),(11,11,'CI San Luis','2019-03-13 13:29:34','2019-03-13 13:29:34'),(12,12,'CI Santa Fe','2019-03-13 13:29:34','2019-03-13 13:29:34'),(13,13,'CI Santiago del Estero','2019-03-13 13:29:34','2019-03-13 13:29:34'),(14,14,'CI Tucumán','2019-03-13 13:29:34','2019-03-13 13:29:34'),(16,16,'CI Chaco','2019-03-13 13:29:34','2019-03-13 13:29:34'),(17,17,'CI Chubut','2019-03-13 13:29:34','2019-03-13 13:29:34'),(18,18,'CI Formosa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(19,19,'CI Misiones','2019-03-13 13:29:34','2019-03-13 13:29:34'),(20,20,'CI Neuquén','2019-03-13 13:29:34','2019-03-13 13:29:34'),(21,21,'CI La Pampa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(22,22,'CI Río Negro','2019-03-13 13:29:34','2019-03-13 13:29:34'),(23,23,'CI Santa Cruz','2019-03-13 13:29:34','2019-03-13 13:29:34'),(24,24,'CI Tierra del Fuego','2019-03-13 13:29:34','2019-03-13 13:29:34'),(80,80,'CUIT','2019-03-13 13:29:34','2019-03-13 13:29:34'),(86,86,'CUIL','2019-03-13 13:29:34','2019-03-13 13:29:34'),(87,87,'CDI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(89,89,'LE','2019-03-13 13:29:34','2019-03-13 13:29:34'),(90,90,'LC','2019-03-13 13:29:34','2019-03-13 13:29:34'),(91,91,'CI Extranjera','2019-03-13 13:29:34','2019-03-13 13:29:34'),(92,92,'en trámite','2019-03-13 13:29:34','2019-03-13 13:29:34'),(93,93,'Acta Nacimiento','2019-03-13 13:29:34','2019-03-13 13:29:34'),(94,94,'Pasaporte','2019-03-13 13:29:34','2019-03-13 13:29:34'),(95,95,'CI Bs. As. RNP','2019-03-13 13:29:34','2019-03-13 13:29:34'),(96,96,'DNI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(97,0,'CI Policía Federal','2019-03-13 13:29:34','2019-03-13 13:29:34'),(99,99,'Doc. (Otro)','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
INSERT INTO `failed_jobs` VALUES (1,NULL,'database','finance','{\"uuid\":\"6808ada5-151e-428b-966e-b323dda00975\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":2:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":5:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:11:\\\"controlador\\\";s:50:\\\"\\\\App\\\\Http\\\\Controllers\\\\Sueldo\\\\SyJCalcularController\\\";s:6:\\\"metodo\\\";s:26:\\\"execute_liquidacion_masiva\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":4:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:9:\\\"registros\\\";a:41:{i:0;s:5:\\\"25846\\\";i:1;s:5:\\\"25847\\\";i:2;s:5:\\\"25848\\\";i:3;s:5:\\\"25849\\\";i:4;s:5:\\\"25850\\\";i:5;s:5:\\\"25851\\\";i:6;s:5:\\\"25852\\\";i:7;s:5:\\\"25854\\\";i:8;s:5:\\\"25855\\\";i:9;s:5:\\\"25856\\\";i:10;s:5:\\\"25857\\\";i:11;s:5:\\\"25858\\\";i:12;s:5:\\\"25859\\\";i:13;s:5:\\\"25860\\\";i:14;s:5:\\\"25861\\\";i:15;s:5:\\\"25862\\\";i:16;s:5:\\\"25863\\\";i:17;s:5:\\\"25866\\\";i:18;s:5:\\\"25867\\\";i:19;s:5:\\\"25869\\\";i:20;s:5:\\\"25870\\\";i:21;s:5:\\\"25871\\\";i:22;s:5:\\\"25872\\\";i:23;s:5:\\\"25873\\\";i:24;s:5:\\\"25874\\\";i:25;s:5:\\\"25875\\\";i:26;s:5:\\\"25876\\\";i:27;s:5:\\\"25877\\\";i:28;s:5:\\\"25878\\\";i:29;s:5:\\\"25879\\\";i:30;s:5:\\\"25880\\\";i:31;s:5:\\\"25882\\\";i:32;s:5:\\\"25883\\\";i:33;s:5:\\\"25884\\\";i:34;s:5:\\\"25892\\\";i:35;s:5:\\\"25894\\\";i:36;s:5:\\\"25895\\\";i:37;s:5:\\\"25896\\\";i:38;s:5:\\\"25899\\\";i:39;s:5:\\\"25900\\\";i:40;s:5:\\\"26014\\\";}s:5:\\\"queue\\\";b:1;}}s:5:\\\"queue\\\";s:7:\\\"finance\\\";}\"}}','Illuminate\\Queue\\MaxAttemptsExceededException: App\\Jobs\\QueueGenerica has been attempted too many times. in /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/MaxAttemptsExceededException.php:24\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(785): Illuminate\\Queue\\MaxAttemptsExceededException::forJob()\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(519): Illuminate\\Queue\\Worker->maxAttemptsExceededException()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(428): Illuminate\\Queue\\Worker->markJobAsFailedIfAlreadyExceedsMaxAttempts()\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(389): Illuminate\\Queue\\Worker->process()\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(176): Illuminate\\Queue\\Worker->runJob()\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon()\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure()\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod()\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(662): Illuminate\\Container\\BoundMethod::call()\n#12 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(211): Illuminate\\Container\\Container->call()\n#13 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(326): Illuminate\\Console\\Command->execute()\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(180): Symfony\\Component\\Console\\Command\\Command->run()\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(1096): Illuminate\\Console\\Command->run()\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(324): Symfony\\Component\\Console\\Application->doRunCommand()\n#17 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(175): Symfony\\Component\\Console\\Application->doRun()\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(201): Symfony\\Component\\Console\\Application->run()\n#19 /home/forge/taxes.com.ar/artisan(33): Illuminate\\Foundation\\Console\\Kernel->handle()\n#20 {main}','2024-12-05 09:34:34',NULL);
INSERT INTO `failed_jobs` VALUES (2,NULL,'database','finance','{\"uuid\":\"3b6f27e3-e078-4f1e-b257-634b4bdb1b63\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":2:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":5:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:11:\\\"controlador\\\";s:69:\\\"\\\\App\\\\Http\\\\Controllers\\\\FacturaElectronica\\\\FacturaElectronicaController\\\";s:6:\\\"metodo\\\";s:22:\\\"iterando_para_facturar\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":10:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:7:\\\"request\\\";a:27:{s:11:\\\"enviar_mail\\\";a:30:{i:0;N;i:1;N;i:2;N;i:3;N;i:4;N;i:5;N;i:6;N;i:7;N;i:8;N;i:9;N;i:10;N;i:11;N;i:12;N;i:13;N;i:14;N;i:15;N;i:16;N;i:17;N;i:18;N;i:19;N;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;N;i:28;N;i:29;N;}s:10:\\\"show_stock\\\";a:30:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;i:5;b:0;i:6;b:0;i:7;b:0;i:8;b:0;i:9;b:0;i:10;b:0;i:11;b:0;i:12;b:0;i:13;b:0;i:14;b:0;i:15;b:0;i:16;b:0;i:17;b:0;i:18;b:0;i:19;b:0;i:20;b:0;i:21;b:0;i:22;b:0;i:23;b:0;i:24;b:0;i:25;b:0;i:26;b:0;i:27;b:0;i:28;b:0;i:29;b:0;}s:9:\\\"productos\\\";a:30:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;i:5;b:0;i:6;b:0;i:7;b:0;i:8;b:0;i:9;b:0;i:10;b:0;i:11;b:0;i:12;b:0;i:13;b:0;i:14;b:0;i:15;b:0;i:16;b:0;i:17;b:0;i:18;b:0;i:19;b:0;i:20;b:0;i:21;b:0;i:22;b:0;i:23;b:0;i:24;b:0;i:25;b:0;i:26;b:0;i:27;b:0;i:28;b:0;i:29;b:0;}s:15:\\\"type_receipt_id\\\";a:30:{i:0;i:7;i:1;i:7;i:2;i:7;i:3;i:7;i:4;i:7;i:5;i:7;i:6;i:7;i:7;i:7;i:8;i:7;i:9;i:7;i:10;i:7;i:11;i:7;i:12;i:7;i:13;i:7;i:14;i:7;i:15;i:7;i:16;i:7;i:17;i:7;i:18;i:7;i:19;i:7;i:20;i:7;i:21;i:7;i:22;i:7;i:23;i:7;i:24;i:7;i:25;i:7;i:26;i:7;i:27;i:7;i:28;i:7;i:29;i:7;}s:15:\\\"cond_frente_iva\\\";a:30:{i:0;i:6;i:1;i:6;i:2;i:6;i:3;i:6;i:4;i:6;i:5;i:6;i:6;i:6;i:7;i:6;i:8;i:6;i:9;i:6;i:10;i:6;i:11;i:6;i:12;i:6;i:13;i:6;i:14;i:6;i:15;i:6;i:16;i:6;i:17;i:1;i:18;i:6;i:19;i:6;i:20;i:6;i:21;i:6;i:22;i:6;i:23;i:6;i:24;i:6;i:25;i:6;i:26;i:6;i:27;i:6;i:28;i:6;i:29;i:6;}s:12:\\\"taxable_iibb\\\";a:30:{i:0;i:2;i:1;i:2;i:2;i:2;i:3;i:2;i:4;i:2;i:5;i:2;i:6;i:2;i:7;i:2;i:8;i:2;i:9;i:2;i:10;i:2;i:11;i:2;i:12;i:2;i:13;i:2;i:14;i:2;i:15;i:2;i:16;i:2;i:17;i:2;i:18;i:2;i:19;i:2;i:20;i:2;i:21;i:2;i:22;i:2;i:23;i:2;i:24;i:2;i:25;i:2;i:26;i:2;i:27;i:2;i:28;i:2;i:29;i:2;}s:15:\\\"descripcionItem\\\";a:30:{i:0;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:1;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:2;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:3;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:4;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:5;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:6;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:7;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:8;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:9;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:10;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:11;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:12;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:13;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:14;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:15;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:16;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:17;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:18;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:19;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:20;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:21;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:22;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:23;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:24;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:25;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:26;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:27;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:28;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";i:29;s:41:\\\"Honorarios Profesionales - Noviembre 2024\\\";}s:9:\\\"body_mail\\\";a:30:{i:0;N;i:1;N;i:2;N;i:3;N;i:4;N;i:5;N;i:6;N;i:7;N;i:8;N;i:9;N;i:10;N;i:11;N;i:12;N;i:13;N;i:14;N;i:15;N;i:16;N;i:17;N;i:18;N;i:19;N;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;N;i:28;N;i:29;N;}s:14:\\\"subtotalPUItem\\\";a:30:{i:0;s:8:\\\"12000.00\\\";i:1;s:8:\\\"12000.00\\\";i:2;s:8:\\\"12000.00\\\";i:3;s:8:\\\"23000.00\\\";i:4;s:8:\\\"12000.00\\\";i:5;s:8:\\\"12000.00\\\";i:6;s:8:\\\"12000.00\\\";i:7;s:8:\\\"12000.00\\\";i:8;s:8:\\\"12000.00\\\";i:9;s:8:\\\"12000.00\\\";i:10;s:8:\\\"12000.00\\\";i:11;s:8:\\\"12000.00\\\";i:12;s:8:\\\"12000.00\\\";i:13;s:8:\\\"12000.00\\\";i:14;s:8:\\\"12000.00\\\";i:15;s:8:\\\"12000.00\\\";i:16;s:8:\\\"12000.00\\\";i:17;s:8:\\\"39000.00\\\";i:18;s:8:\\\"17000.00\\\";i:19;s:8:\\\"12000.00\\\";i:20;s:8:\\\"12000.00\\\";i:21;s:8:\\\"12000.00\\\";i:22;s:8:\\\"12000.00\\\";i:23;s:8:\\\"12000.00\\\";i:24;s:8:\\\"17000.00\\\";i:25;s:8:\\\"12000.00\\\";i:26;s:8:\\\"12000.00\\\";i:27;s:8:\\\"12000.00\\\";i:28;s:8:\\\"12000.00\\\";i:29;s:8:\\\"12000.00\\\";}s:15:\\\"ivaAlicuotaItem\\\";a:30:{i:0;i:7;i:1;i:7;i:2;i:7;i:3;i:7;i:4;i:7;i:5;i:7;i:6;i:7;i:7;i:7;i:8;i:7;i:9;i:7;i:10;i:7;i:11;i:7;i:12;i:7;i:13;i:7;i:14;i:7;i:15;i:7;i:16;i:7;i:17;i:7;i:18;i:7;i:19;i:7;i:20;i:7;i:21;i:7;i:22;i:7;i:23;i:7;i:24;i:7;i:25;i:7;i:26;i:7;i:27;i:7;i:28;i:7;i:29;i:7;}s:10:\\\"cliente_id\\\";a:30:{i:0;i:40818;i:1;i:40856;i:2;i:40819;i:3;i:40857;i:4;i:40858;i:5;i:40860;i:6;i:40861;i:7;i:40862;i:8;i:40863;i:9;i:40864;i:10;i:40865;i:11;i:40866;i:12;i:40867;i:13;i:40868;i:14;i:40869;i:15;i:40870;i:16;i:40871;i:17;i:40873;i:18;i:40874;i:19;i:40875;i:20;i:40876;i:21;i:40877;i:22;i:40878;i:23;i:40879;i:24;i:40881;i:25;i:40882;i:26;i:40883;i:27;i:40884;i:28;i:40885;i:29;i:40887;}s:7:\\\"zone_id\\\";a:30:{i:0;i:23;i:1;i:23;i:2;i:23;i:3;i:23;i:4;i:23;i:5;i:23;i:6;i:23;i:7;i:23;i:8;i:23;i:9;i:23;i:10;i:23;i:11;i:23;i:12;i:23;i:13;i:23;i:14;i:23;i:15;i:23;i:16;i:23;i:17;i:23;i:18;i:23;i:19;i:23;i:20;i:23;i:21;i:23;i:22;i:23;i:23;i:23;i:24;i:23;i:25;i:23;i:26;i:23;i:27;i:23;i:28;i:23;i:29;i:23;}s:11:\\\"activity_id\\\";a:30:{i:0;i:796;i:1;i:796;i:2;i:796;i:3;i:796;i:4;i:796;i:5;i:796;i:6;i:796;i:7;i:796;i:8;i:796;i:9;i:796;i:10;i:796;i:11;i:796;i:12;i:796;i:13;i:796;i:14;i:796;i:15;i:796;i:16;i:796;i:17;i:796;i:18;i:796;i:19;i:796;i:20;i:796;i:21;i:796;i:22;i:796;i:23;i:796;i:24;i:796;i:25;i:796;i:26;i:796;i:27;i:796;i:28;i:796;i:29;i:796;}s:11:\\\"concepto_id\\\";a:30:{i:0;i:2;i:1;i:2;i:2;i:2;i:3;i:2;i:4;i:2;i:5;i:2;i:6;i:2;i:7;i:2;i:8;i:2;i:9;i:2;i:10;i:2;i:11;i:2;i:12;i:2;i:13;i:2;i:14;i:2;i:15;i:2;i:16;i:2;i:17;i:2;i:18;i:2;i:19;i:2;i:20;i:2;i:21;i:2;i:22;i:2;i:23;i:2;i:24;i:2;i:25;i:2;i:26;i:2;i:27;i:2;i:28;i:2;i:29;i:2;}s:14:\\\"punto_venta_id\\\";a:30:{i:0;i:3;i:1;i:3;i:2;i:3;i:3;i:3;i:4;i:3;i:5;i:3;i:6;i:3;i:7;i:3;i:8;i:3;i:9;i:3;i:10;i:3;i:11;i:3;i:12;i:3;i:13;i:3;i:14;i:3;i:15;i:3;i:16;i:3;i:17;i:3;i:18;i:3;i:19;i:3;i:20;i:3;i:21;i:3;i:22;i:3;i:23;i:3;i:24;i:3;i:25;i:3;i:26;i:3;i:27;i:3;i:28;i:3;i:29;i:3;}s:10:\\\"cond_venta\\\";a:30:{i:0;i:4;i:1;i:4;i:2;i:4;i:3;i:4;i:4;i:4;i:5;i:4;i:6;i:4;i:7;i:4;i:8;i:4;i:9;i:4;i:10;i:4;i:11;i:4;i:12;i:4;i:13;i:4;i:14;i:4;i:15;i:4;i:16;i:4;i:17;i:4;i:18;i:4;i:19;i:4;i:20;i:4;i:21;i:4;i:22;i:4;i:23;i:4;i:24;i:4;i:25;i:4;i:26;i:4;i:27;i:4;i:28;i:4;i:29;i:4;}s:17:\\\"fecha_comprobante\\\";a:30:{i:0;s:10:\\\"12-05-2024\\\";i:1;s:10:\\\"12-05-2024\\\";i:2;s:10:\\\"12-05-2024\\\";i:3;s:10:\\\"12-05-2024\\\";i:4;s:10:\\\"12-05-2024\\\";i:5;s:10:\\\"12-05-2024\\\";i:6;s:10:\\\"12-05-2024\\\";i:7;s:10:\\\"12-05-2024\\\";i:8;s:10:\\\"12-05-2024\\\";i:9;s:10:\\\"12-05-2024\\\";i:10;s:10:\\\"12-05-2024\\\";i:11;s:10:\\\"12-05-2024\\\";i:12;s:10:\\\"12-05-2024\\\";i:13;s:10:\\\"12-05-2024\\\";i:14;s:10:\\\"12-05-2024\\\";i:15;s:10:\\\"12-05-2024\\\";i:16;s:10:\\\"12-05-2024\\\";i:17;s:10:\\\"12-05-2024\\\";i:18;s:10:\\\"12-05-2024\\\";i:19;s:10:\\\"12-05-2024\\\";i:20;s:10:\\\"12-05-2024\\\";i:21;s:10:\\\"12-05-2024\\\";i:22;s:10:\\\"12-05-2024\\\";i:23;s:10:\\\"12-05-2024\\\";i:24;s:10:\\\"12-05-2024\\\";i:25;s:10:\\\"12-05-2024\\\";i:26;s:10:\\\"12-05-2024\\\";i:27;s:10:\\\"12-05-2024\\\";i:28;s:10:\\\"12-05-2024\\\";i:29;s:10:\\\"12-05-2024\\\";}s:21:\\\"fecha_facturado_desde\\\";a:30:{i:0;s:10:\\\"11-01-2024\\\";i:1;s:10:\\\"11-01-2024\\\";i:2;s:10:\\\"11-01-2024\\\";i:3;s:10:\\\"11-01-2024\\\";i:4;s:10:\\\"11-01-2024\\\";i:5;s:10:\\\"11-01-2024\\\";i:6;s:10:\\\"11-01-2024\\\";i:7;s:10:\\\"11-01-2024\\\";i:8;s:10:\\\"11-01-2024\\\";i:9;s:10:\\\"11-01-2024\\\";i:10;s:10:\\\"11-01-2024\\\";i:11;s:10:\\\"11-01-2024\\\";i:12;s:10:\\\"11-01-2024\\\";i:13;s:10:\\\"11-01-2024\\\";i:14;s:10:\\\"11-01-2024\\\";i:15;s:10:\\\"11-01-2024\\\";i:16;s:10:\\\"11-01-2024\\\";i:17;s:10:\\\"11-01-2024\\\";i:18;s:10:\\\"11-01-2024\\\";i:19;s:10:\\\"11-01-2024\\\";i:20;s:10:\\\"11-01-2024\\\";i:21;s:10:\\\"11-01-2024\\\";i:22;s:10:\\\"11-01-2024\\\";i:23;s:10:\\\"11-01-2024\\\";i:24;s:10:\\\"11-01-2024\\\";i:25;s:10:\\\"11-01-2024\\\";i:26;s:10:\\\"11-01-2024\\\";i:27;s:10:\\\"11-01-2024\\\";i:28;s:10:\\\"11-01-2024\\\";i:29;s:10:\\\"11-01-2024\\\";}s:21:\\\"fecha_facturado_hasta\\\";a:30:{i:0;s:10:\\\"11-30-2024\\\";i:1;s:10:\\\"11-30-2024\\\";i:2;s:10:\\\"11-30-2024\\\";i:3;s:10:\\\"11-30-2024\\\";i:4;s:10:\\\"11-30-2024\\\";i:5;s:10:\\\"11-30-2024\\\";i:6;s:10:\\\"11-30-2024\\\";i:7;s:10:\\\"11-30-2024\\\";i:8;s:10:\\\"11-30-2024\\\";i:9;s:10:\\\"11-30-2024\\\";i:10;s:10:\\\"11-30-2024\\\";i:11;s:10:\\\"11-30-2024\\\";i:12;s:10:\\\"11-30-2024\\\";i:13;s:10:\\\"11-30-2024\\\";i:14;s:10:\\\"11-30-2024\\\";i:15;s:10:\\\"11-30-2024\\\";i:16;s:10:\\\"11-30-2024\\\";i:17;s:10:\\\"11-30-2024\\\";i:18;s:10:\\\"11-30-2024\\\";i:19;s:10:\\\"11-30-2024\\\";i:20;s:10:\\\"11-30-2024\\\";i:21;s:10:\\\"11-30-2024\\\";i:22;s:10:\\\"11-30-2024\\\";i:23;s:10:\\\"11-30-2024\\\";i:24;s:10:\\\"11-30-2024\\\";i:25;s:10:\\\"11-30-2024\\\";i:26;s:10:\\\"11-30-2024\\\";i:27;s:10:\\\"11-30-2024\\\";i:28;s:10:\\\"11-30-2024\\\";i:29;s:10:\\\"11-30-2024\\\";}s:22:\\\"fecha_vencimiento_pago\\\";a:30:{i:0;s:10:\\\"12-05-2024\\\";i:1;s:10:\\\"12-05-2024\\\";i:2;s:10:\\\"12-05-2024\\\";i:3;s:10:\\\"12-05-2024\\\";i:4;s:10:\\\"12-05-2024\\\";i:5;s:10:\\\"12-05-2024\\\";i:6;s:10:\\\"12-05-2024\\\";i:7;s:10:\\\"12-05-2024\\\";i:8;s:10:\\\"12-05-2024\\\";i:9;s:10:\\\"12-05-2024\\\";i:10;s:10:\\\"12-05-2024\\\";i:11;s:10:\\\"12-05-2024\\\";i:12;s:10:\\\"12-05-2024\\\";i:13;s:10:\\\"12-05-2024\\\";i:14;s:10:\\\"12-05-2024\\\";i:15;s:10:\\\"12-05-2024\\\";i:16;s:10:\\\"12-05-2024\\\";i:17;s:10:\\\"12-05-2024\\\";i:18;s:10:\\\"12-05-2024\\\";i:19;s:10:\\\"12-05-2024\\\";i:20;s:10:\\\"12-05-2024\\\";i:21;s:10:\\\"12-05-2024\\\";i:22;s:10:\\\"12-05-2024\\\";i:23;s:10:\\\"12-05-2024\\\";i:24;s:10:\\\"12-05-2024\\\";i:25;s:10:\\\"12-05-2024\\\";i:26;s:10:\\\"12-05-2024\\\";i:27;s:10:\\\"12-05-2024\\\";i:28;s:10:\\\"12-05-2024\\\";i:29;s:10:\\\"12-05-2024\\\";}s:10:\\\"codigoItem\\\";a:30:{i:0;N;i:1;N;i:2;N;i:3;N;i:4;N;i:5;N;i:6;N;i:7;N;i:8;N;i:9;N;i:10;N;i:11;N;i:12;N;i:13;N;i:14;N;i:15;N;i:16;N;i:17;N;i:18;N;i:19;N;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;N;i:28;N;i:29;N;}s:16:\\\"unidadMedidaItem\\\";a:30:{i:0;i:8;i:1;i:8;i:2;i:8;i:3;i:8;i:4;i:8;i:5;i:8;i:6;i:8;i:7;i:8;i:8;i:8;i:9;i:8;i:10;i:8;i:11;i:8;i:12;i:8;i:13;i:8;i:14;i:8;i:15;i:8;i:16;i:8;i:17;i:8;i:18;i:8;i:19;i:8;i:20;i:8;i:21;i:8;i:22;i:8;i:23;i:8;i:24;i:8;i:25;i:8;i:26;i:8;i:27;i:8;i:28;i:8;i:29;i:8;}s:12:\\\"cantidadItem\\\";a:30:{i:0;i:1;i:1;i:1;i:2;i:1;i:3;i:1;i:4;i:1;i:5;i:1;i:6;i:1;i:7;i:1;i:8;i:1;i:9;i:1;i:10;i:1;i:11;i:1;i:12;i:1;i:13;i:1;i:14;i:1;i:15;i:1;i:16;i:1;i:17;i:1;i:18;i:1;i:19;i:1;i:20;i:1;i:21;i:1;i:22;i:1;i:23;i:1;i:24;i:1;i:25;i:1;i:26;i:1;i:27;i:1;i:28;i:1;i:29;i:1;}s:18:\\\"precioUnitarioItem\\\";a:30:{i:0;s:8:\\\"12000.00\\\";i:1;s:8:\\\"12000.00\\\";i:2;s:8:\\\"12000.00\\\";i:3;s:8:\\\"23000.00\\\";i:4;s:8:\\\"12000.00\\\";i:5;s:8:\\\"12000.00\\\";i:6;s:8:\\\"12000.00\\\";i:7;s:8:\\\"12000.00\\\";i:8;s:8:\\\"12000.00\\\";i:9;s:8:\\\"12000.00\\\";i:10;s:8:\\\"12000.00\\\";i:11;s:8:\\\"12000.00\\\";i:12;s:8:\\\"12000.00\\\";i:13;s:8:\\\"12000.00\\\";i:14;s:8:\\\"12000.00\\\";i:15;s:8:\\\"12000.00\\\";i:16;s:8:\\\"12000.00\\\";i:17;s:8:\\\"39000.00\\\";i:18;s:8:\\\"17000.00\\\";i:19;s:8:\\\"12000.00\\\";i:20;s:8:\\\"12000.00\\\";i:21;s:8:\\\"12000.00\\\";i:22;s:8:\\\"12000.00\\\";i:23;s:8:\\\"12000.00\\\";i:24;s:8:\\\"17000.00\\\";i:25;s:8:\\\"12000.00\\\";i:26;s:8:\\\"12000.00\\\";i:27;s:8:\\\"12000.00\\\";i:28;s:8:\\\"12000.00\\\";i:29;s:8:\\\"12000.00\\\";}s:23:\\\"porcentajeDescuentoItem\\\";a:30:{i:0;i:0;i:1;i:0;i:2;i:0;i:3;i:0;i:4;i:0;i:5;i:0;i:6;i:0;i:7;i:0;i:8;i:0;i:9;i:0;i:10;i:0;i:11;i:0;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;i:0;i:21;i:0;i:22;i:0;i:23;i:0;i:24;i:0;i:25;i:0;i:26;i:0;i:27;i:0;i:28;i:0;i:29;i:0;}s:13:\\\"descuentoItem\\\";a:30:{i:0;i:0;i:1;i:0;i:2;i:0;i:3;i:0;i:4;i:0;i:5;i:0;i:6;i:0;i:7;i:0;i:8;i:0;i:9;i:0;i:10;i:0;i:11;i:0;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;i:0;i:21;i:0;i:22;i:0;i:23;i:0;i:24;i:0;i:25;i:0;i:26;i:0;i:27;i:0;i:28;i:0;i:29;i:0;}s:14:\\\"subtotalIAItem\\\";a:30:{i:0;s:4:\\\"0.00\\\";i:1;s:4:\\\"0.00\\\";i:2;s:4:\\\"0.00\\\";i:3;s:4:\\\"0.00\\\";i:4;s:4:\\\"0.00\\\";i:5;s:4:\\\"0.00\\\";i:6;s:4:\\\"0.00\\\";i:7;s:4:\\\"0.00\\\";i:8;s:4:\\\"0.00\\\";i:9;s:4:\\\"0.00\\\";i:10;s:4:\\\"0.00\\\";i:11;s:4:\\\"0.00\\\";i:12;s:4:\\\"0.00\\\";i:13;s:4:\\\"0.00\\\";i:14;s:4:\\\"0.00\\\";i:15;s:4:\\\"0.00\\\";i:16;s:4:\\\"0.00\\\";i:17;s:4:\\\"0.00\\\";i:18;s:4:\\\"0.00\\\";i:19;s:4:\\\"0.00\\\";i:20;s:4:\\\"0.00\\\";i:21;s:4:\\\"0.00\\\";i:22;s:4:\\\"0.00\\\";i:23;s:4:\\\"0.00\\\";i:24;s:4:\\\"0.00\\\";i:25;s:4:\\\"0.00\\\";i:26;s:4:\\\"0.00\\\";i:27;s:4:\\\"0.00\\\";i:28;s:4:\\\"0.00\\\";i:29;s:4:\\\"0.00\\\";}}s:4:\\\"afip\\\";O:24:\\\"App\\\\Services\\\\Afip\\\\MiAfip\\\":10:{s:9:\\\"WSAA_WSDL\\\";s:61:\\\"\\/home\\/forge\\/taxes.com.ar\\/app\\/Services\\/Afip\\/Afip_res\\/wsaa.wsdl\\\";s:8:\\\"WSAA_URL\\\";s:45:\\\"https:\\/\\/wsaa.afip.gov.ar\\/ws\\/services\\/LoginCms\\\";s:4:\\\"CERT\\\";s:71:\\\"\\/home\\/forge\\/taxes.com.ar\\/storage\\/afip\\/claves\\/30716251248\\/2024\\/taxes.crt\\\";s:10:\\\"PRIVATEKEY\\\";s:71:\\\"\\/home\\/forge\\/taxes.com.ar\\/storage\\/afip\\/claves\\/30716251248\\/2024\\/taxes.key\\\";s:10:\\\"PASSPHRASE\\\";s:5:\\\"xxxxx\\\";s:10:\\\"RES_FOLDER\\\";s:38:\\\"\\/home\\/forge\\/taxes.com.ar\\/storage\\/afip\\/\\\";s:9:\\\"TA_FOLDER\\\";s:50:\\\"\\/home\\/forge\\/taxes.com.ar\\/storage\\/afip\\/xmlgenerados\\\";s:4:\\\"CUIT\\\";s:11:\\\"20322087978\\\";s:14:\\\"implemented_ws\\\";a:5:{i:0;s:17:\\\"ElectronicBilling\\\";i:1;s:17:\\\"RegisterScopeFour\\\";i:2;s:17:\\\"RegisterScopeFive\\\";i:3;s:16:\\\"RegisterScopeTen\\\";i:4;s:21:\\\"VentanillaElectronica\\\";}s:7:\\\"options\\\";a:7:{s:4:\\\"CUIT\\\";s:11:\\\"20322087978\\\";s:10:\\\"res_folder\\\";s:38:\\\"\\/home\\/forge\\/taxes.com.ar\\/storage\\/afip\\/\\\";s:9:\\\"ta_folder\\\";s:50:\\\"\\/home\\/forge\\/taxes.com.ar\\/storage\\/afip\\/xmlgenerados\\\";s:4:\\\"cert\\\";s:33:\\\"claves\\/30716251248\\/2024\\/taxes.crt\\\";s:3:\\\"key\\\";s:33:\\\"claves\\/30716251248\\/2024\\/taxes.key\\\";s:10:\\\"production\\\";b:1;s:10:\\\"passphrase\\\";s:5:\\\"xxxxx\\\";}}s:6:\\\"person\\\";O:17:\\\"App\\\\Models\\\\Person\\\":30:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:27:{s:2:\\\"id\\\";i:40817;s:7:\\\"user_id\\\";i:10927;s:11:\\\"field_name1\\\";s:15:\\\"giacoia gerardo\\\";s:12:\\\"fantasy_name\\\";N;s:6:\\\"codigo\\\";N;s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"20-32208797-8\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2024-10-07 20:24:19\\\";s:10:\\\"updated_at\\\";s:19:\\\"2024-10-17 08:19:40\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:12:\\\"localidad_id\\\";N;s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:10:\\\"comentario\\\";N;s:5:\\\"email\\\";N;s:18:\\\"iva_per_regimen_id\\\";N;s:18:\\\"iva_ret_regimen_id\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:27:{s:2:\\\"id\\\";i:40817;s:7:\\\"user_id\\\";i:10927;s:11:\\\"field_name1\\\";s:15:\\\"giacoia gerardo\\\";s:12:\\\"fantasy_name\\\";N;s:6:\\\"codigo\\\";N;s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"20-32208797-8\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2024-10-07 20:24:19\\\";s:10:\\\"updated_at\\\";s:19:\\\"2024-10-17 08:19:40\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:12:\\\"localidad_id\\\";N;s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:10:\\\"comentario\\\";N;s:5:\\\"email\\\";N;s:18:\\\"iva_per_regimen_id\\\";N;s:18:\\\"iva_ret_regimen_id\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}}s:12:\\\"puntosVentas\\\";O:39:\\\"Illuminate\\\\Database\\\\Eloquent\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:1:{i:0;O:24:\\\"App\\\\Models\\\\FAPuntosVenta\\\":30:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:22:\\\"fact_elec_puntos_venta\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:12:{s:2:\\\"id\\\";i:3;s:7:\\\"user_id\\\";i:10927;s:9:\\\"direccion\\\";s:10:\\\"Acosta 470\\\";s:10:\\\"created_at\\\";s:19:\\\"2024-10-16 13:16:02\\\";s:10:\\\"updated_at\\\";s:19:\\\"2024-10-21 14:24:23\\\";s:9:\\\"person_id\\\";i:40817;s:6:\\\"codigo\\\";s:1:\\\"2\\\";s:13:\\\"codigo_postal\\\";s:4:\\\"6450\\\";s:7:\\\"zone_id\\\";i:23;s:4:\\\"logo\\\";N;s:10:\\\"habilitado\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:12:{s:2:\\\"id\\\";i:3;s:7:\\\"user_id\\\";i:10927;s:9:\\\"direccion\\\";s:10:\\\"Acosta 470\\\";s:10:\\\"created_at\\\";s:19:\\\"2024-10-16 13:16:02\\\";s:10:\\\"updated_at\\\";s:19:\\\"2024-10-21 14:24:23\\\";s:9:\\\"person_id\\\";i:40817;s:6:\\\"codigo\\\";s:1:\\\"2\\\";s:13:\\\"codigo_postal\\\";s:4:\\\"6450\\\";s:7:\\\"zone_id\\\";i:23;s:4:\\\"logo\\\";N;s:10:\\\"habilitado\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}}}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}s:10:\\\"mailDetail\\\";O:21:\\\"App\\\\Models\\\\MailDetail\\\":30:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"mails_details\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:11:{s:2:\\\"id\\\";i:8;s:7:\\\"user_id\\\";i:10927;s:4:\\\"mail\\\";s:26:\\\"GIACOIAGERARDO@HOTMAIL.COM\\\";s:8:\\\"telefono\\\";s:10:\\\"2396426326\\\";s:10:\\\"comentario\\\";s:0:\\\"\\\";s:7:\\\"mail_id\\\";i:1;s:9:\\\"person_id\\\";i:40817;s:6:\\\"status\\\";i:1;s:10:\\\"created_at\\\";s:19:\\\"2024-10-17 08:19:40\\\";s:10:\\\"updated_at\\\";s:19:\\\"2024-10-17 08:19:40\\\";s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:11:{s:2:\\\"id\\\";i:8;s:7:\\\"user_id\\\";i:10927;s:4:\\\"mail\\\";s:26:\\\"GIACOIAGERARDO@HOTMAIL.COM\\\";s:8:\\\"telefono\\\";s:10:\\\"2396426326\\\";s:10:\\\"comentario\\\";s:0:\\\"\\\";s:7:\\\"mail_id\\\";i:1;s:9:\\\"person_id\\\";i:40817;s:6:\\\"status\\\";i:1;s:10:\\\"created_at\\\";s:19:\\\"2024-10-17 08:19:40\\\";s:10:\\\"updated_at\\\";s:19:\\\"2024-10-17 08:19:40\\\";s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}}s:4:\\\"user\\\";O:8:\\\"App\\\\User\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:6:\\\"tusers\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:6:\\\"idUser\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:18:{s:6:\\\"idUser\\\";i:10927;s:6:\\\"nombre\\\";s:9:\\\"giacoia 1\\\";s:9:\\\"loginUser\\\";s:26:\\\"GIACOIAGERARDO@HOTMAIL.COM\\\";s:9:\\\"emailUser\\\";s:26:\\\"GIACOIAGERARDO@HOTMAIL.COM\\\";s:5:\\\"clave\\\";s:11:\\\"20322087978\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$iraRXOE\\/LXb39iv.I4kp7.8nbsW5uveWbqNfBEGmVh.hn82agQlQ6\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:9:\\\"api_token\\\";N;s:14:\\\"remember_token\\\";s:60:\\\"3IjoSJVawnWYVicn5Xkkr1PQaykTTGbdzqmF5buI1nzZIfFgzfjHMY0xLF3N\\\";s:10:\\\"created_at\\\";s:19:\\\"2024-10-07 17:24:20\\\";s:10:\\\"updated_at\\\";s:19:\\\"2024-10-07 17:24:20\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:11:\\\"hidden_menu\\\";i:0;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";}s:11:\\\"\\u0000*\\u0000original\\\";a:18:{s:6:\\\"idUser\\\";i:10927;s:6:\\\"nombre\\\";s:9:\\\"giacoia 1\\\";s:9:\\\"loginUser\\\";s:26:\\\"GIACOIAGERARDO@HOTMAIL.COM\\\";s:9:\\\"emailUser\\\";s:26:\\\"GIACOIAGERARDO@HOTMAIL.COM\\\";s:5:\\\"clave\\\";s:11:\\\"20322087978\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$iraRXOE\\/LXb39iv.I4kp7.8nbsW5uveWbqNfBEGmVh.hn82agQlQ6\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:9:\\\"api_token\\\";N;s:14:\\\"remember_token\\\";s:60:\\\"3IjoSJVawnWYVicn5Xkkr1PQaykTTGbdzqmF5buI1nzZIfFgzfjHMY0xLF3N\\\";s:10:\\\"created_at\\\";s:19:\\\"2024-10-07 17:24:20\\\";s:10:\\\"updated_at\\\";s:19:\\\"2024-10-07 17:24:20\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:11:\\\"hidden_menu\\\";i:0;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:1:{i:0;s:24:\\\"usuario_madre_habilitado\\\";}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:4:{i:0;s:8:\\\"password\\\";i:1;s:14:\\\"remember_token\\\";i:2;s:9:\\\"claveUser\\\";i:3;s:5:\\\"clave\\\";}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:12:{i:0;s:6:\\\"nombre\\\";i:1;s:9:\\\"loginUser\\\";i:2;s:9:\\\"emailUser\\\";i:3;s:5:\\\"clave\\\";i:4;s:9:\\\"claveUser\\\";i:5;s:10:\\\"statusUser\\\";i:6;s:12:\\\"user_type_id\\\";i:7;s:5:\\\"firma\\\";i:8;s:15:\\\"suscrip_plan_id\\\";i:9;s:7:\\\"importe\\\";i:10;s:6:\\\"avatar\\\";i:11;s:18:\\\"es_empresa_externa\\\";}s:10:\\\"\\u0000*\\u0000guarded\\\";a:1:{i:0;s:1:\\\"*\\\";}s:20:\\\"\\u0000*\\u0000rememberTokenName\\\";s:14:\\\"remember_token\\\";}s:12:\\\"enviar_email\\\";b:1;s:5:\\\"email\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":10:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:4:\\\"from\\\";s:24:\\\"informacion@taxes.com.ar\\\";s:2:\\\"to\\\";s:26:\\\"GIACOIAGERARDO@HOTMAIL.COM\\\";s:4:\\\"name\\\";s:14:\\\"Taxes Software\\\";s:5:\\\"vista\\\";s:23:\\\"emails.mail_fin_proceso\\\";s:7:\\\"subject\\\";s:39:\\\"Facturacion Masiva - Proceso Finalizado\\\";s:7:\\\"empresa\\\";s:15:\\\"giacoia gerardo\\\";s:7:\\\"proceso\\\";s:18:\\\"Facturacion Masiva\\\";s:5:\\\"notas\\\";s:41:\\\"Controlar las facturas que se realizaron!\\\";}}}s:5:\\\"queue\\\";s:7:\\\"finance\\\";}\"}}','Illuminate\\Queue\\MaxAttemptsExceededException: App\\Jobs\\QueueGenerica has been attempted too many times. in /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/MaxAttemptsExceededException.php:24\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(785): Illuminate\\Queue\\MaxAttemptsExceededException::forJob()\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(519): Illuminate\\Queue\\Worker->maxAttemptsExceededException()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(428): Illuminate\\Queue\\Worker->markJobAsFailedIfAlreadyExceedsMaxAttempts()\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(389): Illuminate\\Queue\\Worker->process()\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(176): Illuminate\\Queue\\Worker->runJob()\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon()\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure()\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod()\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(662): Illuminate\\Container\\BoundMethod::call()\n#12 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(211): Illuminate\\Container\\Container->call()\n#13 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(326): Illuminate\\Console\\Command->execute()\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(180): Symfony\\Component\\Console\\Command\\Command->run()\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(1096): Illuminate\\Console\\Command->run()\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(324): Symfony\\Component\\Console\\Application->doRunCommand()\n#17 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(175): Symfony\\Component\\Console\\Application->doRun()\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(201): Symfony\\Component\\Console\\Application->run()\n#19 /home/forge/taxes.com.ar/artisan(33): Illuminate\\Foundation\\Console\\Kernel->handle()\n#20 {main}','2024-12-05 09:59:50',NULL);
INSERT INTO `failed_jobs` VALUES (3,NULL,'database','finance','{\"uuid\":\"737c4a82-dacb-418a-9436-f50bd36ab71e\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":2:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":5:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:11:\\\"controlador\\\";s:50:\\\"\\\\App\\\\Http\\\\Controllers\\\\Sueldo\\\\SyJCalcularController\\\";s:6:\\\"metodo\\\";s:26:\\\"execute_liquidacion_masiva\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":4:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:9:\\\"registros\\\";a:16:{i:0;s:5:\\\"39787\\\";i:1;s:5:\\\"39788\\\";i:2;s:5:\\\"39789\\\";i:3;s:5:\\\"39790\\\";i:4;s:5:\\\"39791\\\";i:5;s:5:\\\"39792\\\";i:6;s:5:\\\"39793\\\";i:7;s:5:\\\"39794\\\";i:8;s:5:\\\"39795\\\";i:9;s:5:\\\"39796\\\";i:10;s:5:\\\"39797\\\";i:11;s:5:\\\"39798\\\";i:12;s:5:\\\"39799\\\";i:13;s:5:\\\"39800\\\";i:14;s:5:\\\"39801\\\";i:15;s:5:\\\"39802\\\";}s:5:\\\"queue\\\";b:1;}}s:5:\\\"queue\\\";s:7:\\\"finance\\\";}\"}}','Illuminate\\Queue\\MaxAttemptsExceededException: App\\Jobs\\QueueGenerica has been attempted too many times. in /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/MaxAttemptsExceededException.php:24\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(785): Illuminate\\Queue\\MaxAttemptsExceededException::forJob()\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(519): Illuminate\\Queue\\Worker->maxAttemptsExceededException()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(428): Illuminate\\Queue\\Worker->markJobAsFailedIfAlreadyExceedsMaxAttempts()\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(389): Illuminate\\Queue\\Worker->process()\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(176): Illuminate\\Queue\\Worker->runJob()\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon()\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure()\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod()\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(662): Illuminate\\Container\\BoundMethod::call()\n#12 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(211): Illuminate\\Container\\Container->call()\n#13 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(326): Illuminate\\Console\\Command->execute()\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(180): Symfony\\Component\\Console\\Command\\Command->run()\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(1096): Illuminate\\Console\\Command->run()\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(324): Symfony\\Component\\Console\\Application->doRunCommand()\n#17 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(175): Symfony\\Component\\Console\\Application->doRun()\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(201): Symfony\\Component\\Console\\Application->run()\n#19 /home/forge/taxes.com.ar/artisan(33): Illuminate\\Foundation\\Console\\Kernel->handle()\n#20 {main}','2025-01-02 14:49:08',NULL);
INSERT INTO `failed_jobs` VALUES (4,NULL,'database','finance','{\"uuid\":\"a530cb77-6a90-48c7-a6be-90740b384359\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":2:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":5:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:11:\\\"controlador\\\";s:61:\\\"\\\\App\\\\Http\\\\Controllers\\\\Sueldo\\\\LSDExportarLiquidacionController\\\";s:6:\\\"metodo\\\";s:32:\\\"execute_exportar_liquidacion_TXT\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":5:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:7:\\\"request\\\";a:5:{s:14:\\\"liquidacion_id\\\";s:4:\\\"1077\\\";s:9:\\\"person_id\\\";s:5:\\\"40721\\\";s:7:\\\"periodo\\\";s:6:\\\"2025-1\\\";s:18:\\\"numero_liquidacion\\\";s:1:\\\"5\\\";s:25:\\\"liquidaciones_ya_enviadas\\\";a:2:{i:0;s:4:\\\"1098\\\";i:1;s:4:\\\"1099\\\";}}s:4:\\\"user\\\";O:8:\\\"App\\\\User\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:6:\\\"tusers\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:6:\\\"idUser\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:18:{s:6:\\\"idUser\\\";i:9229;s:6:\\\"nombre\\\";s:4:\\\"ENZO\\\";s:9:\\\"loginUser\\\";s:30:\\\"estudiosr.sociedades@gmail.com\\\";s:9:\\\"emailUser\\\";s:30:\\\"estudiosr.sociedades@gmail.com\\\";s:5:\\\"clave\\\";s:7:\\\"Enzo123\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$WR75AwRlfDzo4jPwX9AbQuqc4oDKzPDtV\\/UqOTElYnQZyTBWLyM8W\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:9:\\\"api_token\\\";N;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2023-07-05 15:14:28\\\";s:10:\\\"updated_at\\\";s:19:\\\"2023-07-05 15:14:28\\\";s:12:\\\"user_type_id\\\";i:3;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";N;s:11:\\\"hidden_menu\\\";i:0;s:7:\\\"importe\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:18:{s:6:\\\"idUser\\\";i:9229;s:6:\\\"nombre\\\";s:4:\\\"ENZO\\\";s:9:\\\"loginUser\\\";s:30:\\\"estudiosr.sociedades@gmail.com\\\";s:9:\\\"emailUser\\\";s:30:\\\"estudiosr.sociedades@gmail.com\\\";s:5:\\\"clave\\\";s:7:\\\"Enzo123\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$WR75AwRlfDzo4jPwX9AbQuqc4oDKzPDtV\\/UqOTElYnQZyTBWLyM8W\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:9:\\\"api_token\\\";N;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2023-07-05 15:14:28\\\";s:10:\\\"updated_at\\\";s:19:\\\"2023-07-05 15:14:28\\\";s:12:\\\"user_type_id\\\";i:3;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";N;s:11:\\\"hidden_menu\\\";i:0;s:7:\\\"importe\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:1:{i:0;s:24:\\\"usuario_madre_habilitado\\\";}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:4:{i:0;s:8:\\\"password\\\";i:1;s:14:\\\"remember_token\\\";i:2;s:9:\\\"claveUser\\\";i:3;s:5:\\\"clave\\\";}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:12:{i:0;s:6:\\\"nombre\\\";i:1;s:9:\\\"loginUser\\\";i:2;s:9:\\\"emailUser\\\";i:3;s:5:\\\"clave\\\";i:4;s:9:\\\"claveUser\\\";i:5;s:10:\\\"statusUser\\\";i:6;s:12:\\\"user_type_id\\\";i:7;s:5:\\\"firma\\\";i:8;s:15:\\\"suscrip_plan_id\\\";i:9;s:7:\\\"importe\\\";i:10;s:6:\\\"avatar\\\";i:11;s:18:\\\"es_empresa_externa\\\";}s:10:\\\"\\u0000*\\u0000guarded\\\";a:1:{i:0;s:1:\\\"*\\\";}s:20:\\\"\\u0000*\\u0000rememberTokenName\\\";s:14:\\\"remember_token\\\";}s:12:\\\"path_of_file\\\";O:21:\\\"App\\\\Models\\\\PathOfFile\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:12:\\\"path_of_file\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:1;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:6:{s:9:\\\"person_id\\\";i:40721;s:7:\\\"user_id\\\";i:9229;s:20:\\\"path_of_file_name_id\\\";i:14;s:10:\\\"updated_at\\\";s:19:\\\"2025-02-05 16:55:18\\\";s:10:\\\"created_at\\\";s:19:\\\"2025-02-05 16:55:18\\\";s:2:\\\"id\\\";i:213;}s:11:\\\"\\u0000*\\u0000original\\\";a:6:{s:9:\\\"person_id\\\";i:40721;s:7:\\\"user_id\\\";i:9229;s:20:\\\"path_of_file_name_id\\\";i:14;s:10:\\\"updated_at\\\";s:19:\\\"2025-02-05 16:55:18\\\";s:10:\\\"created_at\\\";s:19:\\\"2025-02-05 16:55:18\\\";s:2:\\\"id\\\";i:213;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}}}s:5:\\\"queue\\\";s:7:\\\"finance\\\";}\"}}','Illuminate\\Queue\\MaxAttemptsExceededException: App\\Jobs\\QueueGenerica has been attempted too many times. in /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/MaxAttemptsExceededException.php:24\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(785): Illuminate\\Queue\\MaxAttemptsExceededException::forJob()\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(519): Illuminate\\Queue\\Worker->maxAttemptsExceededException()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(428): Illuminate\\Queue\\Worker->markJobAsFailedIfAlreadyExceedsMaxAttempts()\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(389): Illuminate\\Queue\\Worker->process()\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(176): Illuminate\\Queue\\Worker->runJob()\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon()\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure()\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod()\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(662): Illuminate\\Container\\BoundMethod::call()\n#12 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(211): Illuminate\\Container\\Container->call()\n#13 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(326): Illuminate\\Console\\Command->execute()\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(180): Symfony\\Component\\Console\\Command\\Command->run()\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(1096): Illuminate\\Console\\Command->run()\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(324): Symfony\\Component\\Console\\Application->doRunCommand()\n#17 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(175): Symfony\\Component\\Console\\Application->doRun()\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(201): Symfony\\Component\\Console\\Application->run()\n#19 /home/forge/taxes.com.ar/artisan(33): Illuminate\\Foundation\\Console\\Kernel->handle()\n#20 {main}','2025-02-05 16:56:49',NULL);
INSERT INTO `failed_jobs` VALUES (5,NULL,'database','finance','{\"uuid\":\"f397d1de-e406-4056-8c2b-87eae9fc5222\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":2:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":5:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:11:\\\"controlador\\\";s:46:\\\"\\\\App\\\\Http\\\\Controllers\\\\Data\\\\PortalIVAController\\\";s:6:\\\"metodo\\\";s:27:\\\"execute_importar_portal_iva\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":14:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:3:\\\"row\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:349:{i:1;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59654;i:4;i:59654;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:22650;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"18719,01\\\";i:28;s:7:\\\"3930,99\\\";i:29;N;i:30;N;i:31;s:8:\\\"18719,01\\\";i:32;i:3931;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:2;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59655;i:4;i:59655;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19421,49\\\";i:28;s:7:\\\"4078,51\\\";i:29;N;i:30;N;i:31;s:8:\\\"19421,49\\\";i:32;s:6:\\\"4078,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:3;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59656;i:4;i:59656;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:32100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"26528,93\\\";i:28;s:7:\\\"5571,07\\\";i:29;N;i:30;N;i:31;s:8:\\\"26528,93\\\";i:32;s:6:\\\"5571,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:4;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59657;i:4;i:59657;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:5;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59658;i:4;i:59658;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"3223,14\\\";i:28;s:6:\\\"676,86\\\";i:29;N;i:30;N;i:31;s:7:\\\"3223,14\\\";i:32;s:5:\\\"676,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:6;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59659;i:4;i:59659;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:28750;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"23760,33\\\";i:28;s:7:\\\"4989,67\\\";i:29;N;i:30;N;i:31;s:8:\\\"23760,33\\\";i:32;s:6:\\\"4989,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:7;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59660;i:4;i:59660;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11700;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9669,42\\\";i:28;s:7:\\\"2030,58\\\";i:29;N;i:30;N;i:31;s:7:\\\"9669,42\\\";i:32;s:6:\\\"2030,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:8;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59661;i:4;i:59661;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"2479,34\\\";i:28;s:6:\\\"520,66\\\";i:29;N;i:30;N;i:31;s:7:\\\"2479,34\\\";i:32;s:5:\\\"520,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:9;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59662;i:4;i:59662;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:12000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9917,36\\\";i:28;s:7:\\\"2082,64\\\";i:29;N;i:30;N;i:31;s:7:\\\"9917,36\\\";i:32;s:6:\\\"2082,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:10;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59663;i:4;i:59663;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:27000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"22314,05\\\";i:28;s:7:\\\"4685,95\\\";i:29;N;i:30;N;i:31;s:8:\\\"22314,05\\\";i:32;i:4686;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:11;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59664;i:4;i:59664;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:34550;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"28553,72\\\";i:28;s:7:\\\"5996,28\\\";i:29;N;i:30;N;i:31;s:8:\\\"28553,72\\\";i:32;s:6:\\\"5996,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:12;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59665;i:4;i:59665;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:2400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"1983,47\\\";i:28;s:6:\\\"416,53\\\";i:29;N;i:30;N;i:31;s:7:\\\"1983,47\\\";i:32;s:5:\\\"416,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:13;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59666;i:4;i:59666;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:26050;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"21528,93\\\";i:28;s:7:\\\"4521,07\\\";i:29;N;i:30;N;i:31;s:8:\\\"21528,93\\\";i:32;s:6:\\\"4521,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:14;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59667;i:4;i:59667;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:15;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59668;i:4;i:59668;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:32600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"26942,15\\\";i:28;s:7:\\\"5657,85\\\";i:29;N;i:30;N;i:31;s:8:\\\"26942,15\\\";i:32;s:6:\\\"5657,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:16;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59669;i:4;i:59669;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:16200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"13388,43\\\";i:28;s:7:\\\"2811,57\\\";i:29;N;i:30;N;i:31;s:8:\\\"13388,43\\\";i:32;s:6:\\\"2811,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:17;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59670;i:4;i:59670;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:26200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"21652,89\\\";i:28;s:7:\\\"4547,11\\\";i:29;N;i:30;N;i:31;s:8:\\\"21652,89\\\";i:32;s:6:\\\"4547,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:18;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59671;i:4;i:59671;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:30800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"25454,55\\\";i:28;s:7:\\\"5345,45\\\";i:29;N;i:30;N;i:31;s:8:\\\"25454,55\\\";i:32;s:6:\\\"5345,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:19;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59672;i:4;i:59672;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19669,42\\\";i:28;s:7:\\\"4130,58\\\";i:29;N;i:30;N;i:31;s:8:\\\"19669,42\\\";i:32;s:6:\\\"4130,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:20;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59673;i:4;i:59673;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:6600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"5454,55\\\";i:28;s:7:\\\"1145,45\\\";i:29;N;i:30;N;i:31;s:7:\\\"5454,55\\\";i:32;s:6:\\\"1145,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:21;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59674;i:4;i:59674;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7700;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"6363,64\\\";i:28;s:7:\\\"1336,36\\\";i:29;N;i:30;N;i:31;s:7:\\\"6363,64\\\";i:32;s:6:\\\"1336,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:22;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59675;i:4;i:59675;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19421,49\\\";i:28;s:7:\\\"4078,51\\\";i:29;N;i:30;N;i:31;s:8:\\\"19421,49\\\";i:32;s:6:\\\"4078,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:23;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59676;i:4;i:59676;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:28750;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"23760,33\\\";i:28;s:7:\\\"4989,67\\\";i:29;N;i:30;N;i:31;s:8:\\\"23760,33\\\";i:32;s:6:\\\"4989,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:24;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59677;i:4;i:59677;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:20200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"16694,21\\\";i:28;s:7:\\\"3505,79\\\";i:29;N;i:30;N;i:31;s:8:\\\"16694,21\\\";i:32;s:6:\\\"3505,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:25;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59678;i:4;i:59678;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"8595,04\\\";i:28;s:7:\\\"1804,96\\\";i:29;N;i:30;N;i:31;s:7:\\\"8595,04\\\";i:32;i:1805;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:26;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59679;i:4;i:59679;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:26000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"21487,6\\\";i:28;s:6:\\\"4512,4\\\";i:29;N;i:30;N;i:31;s:7:\\\"21487,6\\\";i:32;s:6:\\\"4512,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:27;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59680;i:4;i:59680;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19669,42\\\";i:28;s:7:\\\"4130,58\\\";i:29;N;i:30;N;i:31;s:8:\\\"19669,42\\\";i:32;s:6:\\\"4130,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:28;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59681;i:4;i:59681;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:16200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"13388,43\\\";i:28;s:7:\\\"2811,57\\\";i:29;N;i:30;N;i:31;s:8:\\\"13388,43\\\";i:32;s:6:\\\"2811,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:29;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59682;i:4;i:59682;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23350;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19297,52\\\";i:28;s:7:\\\"4052,48\\\";i:29;N;i:30;N;i:31;s:8:\\\"19297,52\\\";i:32;s:6:\\\"4052,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:30;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59683;i:4;i:59683;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:6:\\\"6115,7\\\";i:28;s:6:\\\"1284,3\\\";i:29;N;i:30;N;i:31;s:6:\\\"6115,7\\\";i:32;s:6:\\\"1284,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:31;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59684;i:4;i:59684;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"2479,34\\\";i:28;s:6:\\\"520,66\\\";i:29;N;i:30;N;i:31;s:7:\\\"2479,34\\\";i:32;s:5:\\\"520,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:32;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59685;i:4;i:59685;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19669,42\\\";i:28;s:7:\\\"4130,58\\\";i:29;N;i:30;N;i:31;s:8:\\\"19669,42\\\";i:32;s:6:\\\"4130,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:33;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59686;i:4;i:59686;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:22800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"18842,98\\\";i:28;s:7:\\\"3957,02\\\";i:29;N;i:30;N;i:31;s:8:\\\"18842,98\\\";i:32;i:3957;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:34;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59687;i:4;i:59687;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:19800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"16363,64\\\";i:28;s:7:\\\"3436,36\\\";i:29;N;i:30;N;i:31;s:8:\\\"16363,64\\\";i:32;s:6:\\\"3436,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:35;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59688;i:4;i:59688;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3700;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"3057,85\\\";i:28;s:6:\\\"642,15\\\";i:29;N;i:30;N;i:31;s:7:\\\"3057,85\\\";i:32;s:5:\\\"642,2\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:36;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59689;i:4;i:59689;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:6:\\\"9256,2\\\";i:28;s:6:\\\"1943,8\\\";i:29;N;i:30;N;i:31;s:6:\\\"9256,2\\\";i:32;s:6:\\\"1943,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:37;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59690;i:4;i:59690;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:6000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"4958,68\\\";i:28;s:7:\\\"1041,32\\\";i:29;N;i:30;N;i:31;s:7:\\\"4958,68\\\";i:32;s:6:\\\"1041,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:38;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59691;i:4;i:59691;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:6:\\\"6115,7\\\";i:28;s:6:\\\"1284,3\\\";i:29;N;i:30;N;i:31;s:6:\\\"6115,7\\\";i:32;s:6:\\\"1284,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:39;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59692;i:4;i:59692;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:25100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"20743,8\\\";i:28;s:6:\\\"4356,2\\\";i:29;N;i:30;N;i:31;s:7:\\\"20743,8\\\";i:32;s:6:\\\"4356,2\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:40;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59693;i:4;i:59693;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:14000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11570,25\\\";i:28;s:7:\\\"2429,75\\\";i:29;N;i:30;N;i:31;s:8:\\\"11570,25\\\";i:32;s:6:\\\"2429,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:41;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59694;i:4;i:59694;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"3223,14\\\";i:28;s:6:\\\"676,86\\\";i:29;N;i:30;N;i:31;s:7:\\\"3223,14\\\";i:32;s:5:\\\"676,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:42;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59695;i:4;i:59695;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:1500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"1239,67\\\";i:28;s:6:\\\"260,33\\\";i:29;N;i:30;N;i:31;s:7:\\\"1239,67\\\";i:32;s:5:\\\"260,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:43;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59696;i:4;i:59696;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:6300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"5206,61\\\";i:28;s:7:\\\"1093,39\\\";i:29;N;i:30;N;i:31;s:7:\\\"5206,61\\\";i:32;s:6:\\\"1093,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:44;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59697;i:4;i:59697;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:16000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"13223,14\\\";i:28;s:7:\\\"2776,86\\\";i:29;N;i:30;N;i:31;s:8:\\\"13223,14\\\";i:32;s:6:\\\"2776,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:45;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59698;i:4;i:59698;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"14876,03\\\";i:28;s:7:\\\"3123,97\\\";i:29;N;i:30;N;i:31;s:8:\\\"14876,03\\\";i:32;i:3124;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:46;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59699;i:4;i:59699;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:14300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11818,18\\\";i:28;s:7:\\\"2481,82\\\";i:29;N;i:30;N;i:31;s:8:\\\"11818,18\\\";i:32;s:6:\\\"2481,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:47;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59700;i:4;i:59700;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:6:\\\"3140,5\\\";i:28;s:5:\\\"659,5\\\";i:29;N;i:30;N;i:31;s:6:\\\"3140,5\\\";i:32;s:5:\\\"659,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:48;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59701;i:4;i:59701;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:9600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"7933,88\\\";i:28;s:7:\\\"1666,12\\\";i:29;N;i:30;N;i:31;s:7:\\\"7933,88\\\";i:32;s:6:\\\"1666,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:49;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59702;i:4;i:59702;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:25300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"20909,09\\\";i:28;s:7:\\\"4390,91\\\";i:29;N;i:30;N;i:31;s:8:\\\"20909,09\\\";i:32;s:6:\\\"4390,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:50;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59703;i:4;i:59703;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"5950,41\\\";i:28;s:7:\\\"1249,59\\\";i:29;N;i:30;N;i:31;s:7:\\\"5950,41\\\";i:32;s:6:\\\"1249,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:51;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59704;i:4;i:59704;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9173,55\\\";i:28;s:7:\\\"1926,45\\\";i:29;N;i:30;N;i:31;s:7:\\\"9173,55\\\";i:32;s:6:\\\"1926,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:52;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59705;i:4;i:59705;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:20450;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"16900,83\\\";i:28;s:7:\\\"3549,17\\\";i:29;N;i:30;N;i:31;s:8:\\\"16900,83\\\";i:32;s:6:\\\"3549,2\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:53;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59706;i:4;i:59706;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:6600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"5454,55\\\";i:28;s:7:\\\"1145,45\\\";i:29;N;i:30;N;i:31;s:7:\\\"5454,55\\\";i:32;s:6:\\\"1145,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:54;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59707;i:4;i:59707;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19669,42\\\";i:28;s:7:\\\"4130,58\\\";i:29;N;i:30;N;i:31;s:8:\\\"19669,42\\\";i:32;s:6:\\\"4130,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:55;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59708;i:4;i:59708;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:1500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"1239,67\\\";i:28;s:6:\\\"260,33\\\";i:29;N;i:30;N;i:31;s:7:\\\"1239,67\\\";i:32;s:5:\\\"260,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:56;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59709;i:4;i:59709;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"2479,34\\\";i:28;s:6:\\\"520,66\\\";i:29;N;i:30;N;i:31;s:7:\\\"2479,34\\\";i:32;s:5:\\\"520,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:57;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59710;i:4;i:59710;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:6:\\\"6115,7\\\";i:28;s:6:\\\"1284,3\\\";i:29;N;i:30;N;i:31;s:6:\\\"6115,7\\\";i:32;s:6:\\\"1284,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:58;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59711;i:4;i:59711;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:14300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11818,18\\\";i:28;s:7:\\\"2481,82\\\";i:29;N;i:30;N;i:31;s:8:\\\"11818,18\\\";i:32;s:6:\\\"2481,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:59;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59712;i:4;i:59712;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:43050;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"35578,51\\\";i:28;s:7:\\\"7471,49\\\";i:29;N;i:30;N;i:31;s:8:\\\"35578,51\\\";i:32;s:6:\\\"7471,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:60;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59713;i:4;i:59713;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"2479,34\\\";i:28;s:6:\\\"520,66\\\";i:29;N;i:30;N;i:31;s:7:\\\"2479,34\\\";i:32;s:5:\\\"520,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:61;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59714;i:4;i:59714;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:16200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"13388,43\\\";i:28;s:7:\\\"2811,57\\\";i:29;N;i:30;N;i:31;s:8:\\\"13388,43\\\";i:32;s:6:\\\"2811,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:62;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59715;i:4;i:59715;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:20850;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"17231,4\\\";i:28;s:6:\\\"3618,6\\\";i:29;N;i:30;N;i:31;s:7:\\\"17231,4\\\";i:32;s:6:\\\"3618,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:63;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59716;i:4;i:59716;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:24100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19917,36\\\";i:28;s:7:\\\"4182,64\\\";i:29;N;i:30;N;i:31;s:8:\\\"19917,36\\\";i:32;s:6:\\\"4182,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:64;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59717;i:4;i:59717;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"8264,46\\\";i:28;s:7:\\\"1735,54\\\";i:29;N;i:30;N;i:31;s:7:\\\"8264,46\\\";i:32;s:6:\\\"1735,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:65;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59718;i:4;i:59718;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"8925,62\\\";i:28;s:7:\\\"1874,38\\\";i:29;N;i:30;N;i:31;s:7:\\\"8925,62\\\";i:32;s:6:\\\"1874,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:66;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59719;i:4;i:59719;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:19300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15950,41\\\";i:28;s:7:\\\"3349,59\\\";i:29;N;i:30;N;i:31;s:8:\\\"15950,41\\\";i:32;s:6:\\\"3349,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:67;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59720;i:4;i:59720;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:32100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"26528,93\\\";i:28;s:7:\\\"5571,07\\\";i:29;N;i:30;N;i:31;s:8:\\\"26528,93\\\";i:32;s:6:\\\"5571,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:68;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59721;i:4;i:59721;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:51950;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"42933,88\\\";i:28;s:7:\\\"9016,12\\\";i:29;N;i:30;N;i:31;s:8:\\\"42933,88\\\";i:32;s:6:\\\"9016,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:69;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59722;i:4;i:59722;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:29900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"24710,74\\\";i:28;s:7:\\\"5189,26\\\";i:29;N;i:30;N;i:31;s:8:\\\"24710,74\\\";i:32;s:6:\\\"5189,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:70;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59723;i:4;i:59723;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:6400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"5289,26\\\";i:28;s:7:\\\"1110,74\\\";i:29;N;i:30;N;i:31;s:7:\\\"5289,26\\\";i:32;s:6:\\\"1110,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:71;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59724;i:4;i:59724;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:13300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"10991,74\\\";i:28;s:7:\\\"2308,26\\\";i:29;N;i:30;N;i:31;s:8:\\\"10991,74\\\";i:32;s:6:\\\"2308,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:72;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59725;i:4;i:59725;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:42050;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"34752,07\\\";i:28;s:7:\\\"7297,93\\\";i:29;N;i:30;N;i:31;s:8:\\\"34752,07\\\";i:32;s:6:\\\"7297,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:73;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59726;i:4;i:59726;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:49600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"40991,74\\\";i:28;s:7:\\\"8608,26\\\";i:29;N;i:30;N;i:31;s:8:\\\"40991,74\\\";i:32;s:6:\\\"8608,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:74;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59727;i:4;i:59727;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:24500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"20247,93\\\";i:28;s:7:\\\"4252,07\\\";i:29;N;i:30;N;i:31;s:8:\\\"20247,93\\\";i:32;s:6:\\\"4252,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:75;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59728;i:4;i:59728;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:28750;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"23760,33\\\";i:28;s:7:\\\"4989,67\\\";i:29;N;i:30;N;i:31;s:8:\\\"23760,33\\\";i:32;s:6:\\\"4989,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:76;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59729;i:4;i:59729;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:6:\\\"3140,5\\\";i:28;s:5:\\\"659,5\\\";i:29;N;i:30;N;i:31;s:6:\\\"3140,5\\\";i:32;s:5:\\\"659,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:77;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59730;i:4;i:59730;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:17600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"14545,45\\\";i:28;s:7:\\\"3054,55\\\";i:29;N;i:30;N;i:31;s:8:\\\"14545,45\\\";i:32;s:6:\\\"3054,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:78;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59731;i:4;i:59731;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:19300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15950,41\\\";i:28;s:7:\\\"3349,59\\\";i:29;N;i:30;N;i:31;s:8:\\\"15950,41\\\";i:32;s:6:\\\"3349,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:79;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59732;i:4;i:59732;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:19300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15950,41\\\";i:28;s:7:\\\"3349,59\\\";i:29;N;i:30;N;i:31;s:8:\\\"15950,41\\\";i:32;s:6:\\\"3349,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:80;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"8\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59733;i:4;i:59733;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9090,91\\\";i:28;s:7:\\\"1909,09\\\";i:29;N;i:30;N;i:31;s:7:\\\"9090,91\\\";i:32;s:6:\\\"1909,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:81;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"9\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59734;i:4;i:59734;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:30900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"25537,19\\\";i:28;s:7:\\\"5362,81\\\";i:29;N;i:30;N;i:31;s:8:\\\"25537,19\\\";i:32;s:6:\\\"5362,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:82;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"9\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59735;i:4;i:59735;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:13700;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11322,31\\\";i:28;s:7:\\\"2377,69\\\";i:29;N;i:30;N;i:31;s:8:\\\"11322,31\\\";i:32;s:6:\\\"2377,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:83;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"9\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59736;i:4;i:59736;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:2800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"2314,05\\\";i:28;s:6:\\\"485,95\\\";i:29;N;i:30;N;i:31;s:7:\\\"2314,05\\\";i:32;i:486;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:84;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"9\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59737;i:4;i:59737;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:30000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"24793,39\\\";i:28;s:7:\\\"5206,61\\\";i:29;N;i:30;N;i:31;s:8:\\\"24793,39\\\";i:32;s:6:\\\"5206,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:85;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"9\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59738;i:4;i:59738;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:28750;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"23760,33\\\";i:28;s:7:\\\"4989,67\\\";i:29;N;i:30;N;i:31;s:8:\\\"23760,33\\\";i:32;s:6:\\\"4989,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:86;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"9\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59739;i:4;i:59739;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11700;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9669,42\\\";i:28;s:7:\\\"2030,58\\\";i:29;N;i:30;N;i:31;s:7:\\\"9669,42\\\";i:32;s:6:\\\"2030,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:87;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"9\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59740;i:4;i:59740;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:40550;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"33512,4\\\";i:28;s:6:\\\"7037,6\\\";i:29;N;i:30;N;i:31;s:7:\\\"33512,4\\\";i:32;s:6:\\\"7037,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:88;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"9\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59741;i:4;i:59741;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:27000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"22314,05\\\";i:28;s:7:\\\"4685,95\\\";i:29;N;i:30;N;i:31;s:8:\\\"22314,05\\\";i:32;i:4686;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:89;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"9\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59742;i:4;i:59742;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18650;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15413,22\\\";i:28;s:7:\\\"3236,78\\\";i:29;N;i:30;N;i:31;s:8:\\\"15413,22\\\";i:32;s:6:\\\"3236,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:90;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"9\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59743;i:4;i:59743;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:17200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"14214,88\\\";i:28;s:7:\\\"2985,12\\\";i:29;N;i:30;N;i:31;s:8:\\\"14214,88\\\";i:32;s:6:\\\"2985,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:91;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"9\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59744;i:4;i:59744;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:19700;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"16280,99\\\";i:28;s:7:\\\"3419,01\\\";i:29;N;i:30;N;i:31;s:8:\\\"16280,99\\\";i:32;i:3419;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:92;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"9\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59745;i:4;i:59745;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"2479,34\\\";i:28;s:6:\\\"520,66\\\";i:29;N;i:30;N;i:31;s:7:\\\"2479,34\\\";i:32;s:5:\\\"520,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:93;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"9\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59746;i:4;i:59746;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:13700;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11322,31\\\";i:28;s:7:\\\"2377,69\\\";i:29;N;i:30;N;i:31;s:8:\\\"11322,31\\\";i:32;s:6:\\\"2377,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:94;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"9\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59747;i:4;i:59747;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9752,07\\\";i:28;s:7:\\\"2047,93\\\";i:29;N;i:30;N;i:31;s:7:\\\"9752,07\\\";i:32;s:6:\\\"2047,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:95;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:8:\\\"9\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59748;i:4;i:59748;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"2727,27\\\";i:28;s:6:\\\"572,73\\\";i:29;N;i:30;N;i:31;s:7:\\\"2727,27\\\";i:32;s:5:\\\"572,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:96;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59749;i:4;i:59749;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:15400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"12727,27\\\";i:28;s:7:\\\"2672,73\\\";i:29;N;i:30;N;i:31;s:8:\\\"12727,27\\\";i:32;s:6:\\\"2672,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:97;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59750;i:4;i:59750;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:19000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15702,48\\\";i:28;s:7:\\\"3297,52\\\";i:29;N;i:30;N;i:31;s:8:\\\"15702,48\\\";i:32;s:6:\\\"3297,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:98;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59751;i:4;i:59751;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:19100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15785,12\\\";i:28;s:7:\\\"3314,88\\\";i:29;N;i:30;N;i:31;s:8:\\\"15785,12\\\";i:32;s:6:\\\"3314,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:99;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59752;i:4;i:59752;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:5300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"4380,17\\\";i:28;s:6:\\\"919,83\\\";i:29;N;i:30;N;i:31;s:7:\\\"4380,17\\\";i:32;s:5:\\\"919,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:100;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59753;i:4;i:59753;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9008,26\\\";i:28;s:7:\\\"1891,74\\\";i:29;N;i:30;N;i:31;s:7:\\\"9008,26\\\";i:32;s:6:\\\"1891,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:101;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59754;i:4;i:59754;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9090,91\\\";i:28;s:7:\\\"1909,09\\\";i:29;N;i:30;N;i:31;s:7:\\\"9090,91\\\";i:32;s:6:\\\"1909,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:102;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59755;i:4;i:59755;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19421,49\\\";i:28;s:7:\\\"4078,51\\\";i:29;N;i:30;N;i:31;s:8:\\\"19421,49\\\";i:32;s:6:\\\"4078,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:103;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59756;i:4;i:59756;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:1500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"1239,67\\\";i:28;s:6:\\\"260,33\\\";i:29;N;i:30;N;i:31;s:7:\\\"1239,67\\\";i:32;s:5:\\\"260,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:104;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59757;i:4;i:59757;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"5950,41\\\";i:28;s:7:\\\"1249,59\\\";i:29;N;i:30;N;i:31;s:7:\\\"5950,41\\\";i:32;s:6:\\\"1249,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:105;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59758;i:4;i:59758;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:4500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"3719,01\\\";i:28;s:6:\\\"780,99\\\";i:29;N;i:30;N;i:31;s:7:\\\"3719,01\\\";i:32;i:781;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:106;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59759;i:4;i:59759;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19669,42\\\";i:28;s:7:\\\"4130,58\\\";i:29;N;i:30;N;i:31;s:8:\\\"19669,42\\\";i:32;s:6:\\\"4130,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:107;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59760;i:4;i:59760;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"2479,34\\\";i:28;s:6:\\\"520,66\\\";i:29;N;i:30;N;i:31;s:7:\\\"2479,34\\\";i:32;s:5:\\\"520,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:108;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59761;i:4;i:59761;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:1500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"1239,67\\\";i:28;s:6:\\\"260,33\\\";i:29;N;i:30;N;i:31;s:7:\\\"1239,67\\\";i:32;s:5:\\\"260,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:109;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59762;i:4;i:59762;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9586,78\\\";i:28;s:7:\\\"2013,22\\\";i:29;N;i:30;N;i:31;s:7:\\\"9586,78\\\";i:32;s:6:\\\"2013,2\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:110;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59763;i:4;i:59763;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:6600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"5454,55\\\";i:28;s:7:\\\"1145,45\\\";i:29;N;i:30;N;i:31;s:7:\\\"5454,55\\\";i:32;s:6:\\\"1145,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:111;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59764;i:4;i:59764;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"2479,34\\\";i:28;s:6:\\\"520,66\\\";i:29;N;i:30;N;i:31;s:7:\\\"2479,34\\\";i:32;s:5:\\\"520,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:112;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59765;i:4;i:59765;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"6280,99\\\";i:28;s:7:\\\"1319,01\\\";i:29;N;i:30;N;i:31;s:7:\\\"6280,99\\\";i:32;i:1319;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:113;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59766;i:4;i:59766;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:114;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59767;i:4;i:59767;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9090,91\\\";i:28;s:7:\\\"1909,09\\\";i:29;N;i:30;N;i:31;s:7:\\\"9090,91\\\";i:32;s:6:\\\"1909,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:115;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59768;i:4;i:59768;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:13400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11074,38\\\";i:28;s:7:\\\"2325,62\\\";i:29;N;i:30;N;i:31;s:8:\\\"11074,38\\\";i:32;s:6:\\\"2325,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:116;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59769;i:4;i:59769;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:6:\\\"6115,7\\\";i:28;s:6:\\\"1284,3\\\";i:29;N;i:30;N;i:31;s:6:\\\"6115,7\\\";i:32;s:6:\\\"1284,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:117;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59770;i:4;i:59770;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19669,42\\\";i:28;s:7:\\\"4130,58\\\";i:29;N;i:30;N;i:31;s:8:\\\"19669,42\\\";i:32;s:6:\\\"4130,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:118;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59771;i:4;i:59771;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:9100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"7520,66\\\";i:28;s:7:\\\"1579,34\\\";i:29;N;i:30;N;i:31;s:7:\\\"7520,66\\\";i:32;s:6:\\\"1579,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:119;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59772;i:4;i:59772;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:14000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11570,25\\\";i:28;s:7:\\\"2429,75\\\";i:29;N;i:30;N;i:31;s:8:\\\"11570,25\\\";i:32;s:6:\\\"2429,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:120;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59773;i:4;i:59773;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:34500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"28512,4\\\";i:28;s:6:\\\"5987,6\\\";i:29;N;i:30;N;i:31;s:7:\\\"28512,4\\\";i:32;s:6:\\\"5987,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:121;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59774;i:4;i:59774;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23850;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19710,74\\\";i:28;s:7:\\\"4139,26\\\";i:29;N;i:30;N;i:31;s:8:\\\"19710,74\\\";i:32;s:6:\\\"4139,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:122;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59775;i:4;i:59775;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:14000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11570,25\\\";i:28;s:7:\\\"2429,75\\\";i:29;N;i:30;N;i:31;s:8:\\\"11570,25\\\";i:32;s:6:\\\"2429,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:123;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59776;i:4;i:59776;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:14100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11652,89\\\";i:28;s:7:\\\"2447,11\\\";i:29;N;i:30;N;i:31;s:8:\\\"11652,89\\\";i:32;s:6:\\\"2447,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:124;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59777;i:4;i:59777;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:25900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"21404,96\\\";i:28;s:7:\\\"4495,04\\\";i:29;N;i:30;N;i:31;s:8:\\\"21404,96\\\";i:32;i:4495;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:125;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59778;i:4;i:59778;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19669,42\\\";i:28;s:7:\\\"4130,58\\\";i:29;N;i:30;N;i:31;s:8:\\\"19669,42\\\";i:32;s:6:\\\"4130,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:126;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59779;i:4;i:59779;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:6:\\\"3140,5\\\";i:28;s:5:\\\"659,5\\\";i:29;N;i:30;N;i:31;s:6:\\\"3140,5\\\";i:32;s:5:\\\"659,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:127;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59780;i:4;i:59780;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:128;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"10\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59781;i:4;i:59781;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:16200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"13388,43\\\";i:28;s:7:\\\"2811,57\\\";i:29;N;i:30;N;i:31;s:8:\\\"13388,43\\\";i:32;s:6:\\\"2811,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:129;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59782;i:4;i:59782;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:130;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59783;i:4;i:59783;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:14300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11818,18\\\";i:28;s:7:\\\"2481,82\\\";i:29;N;i:30;N;i:31;s:8:\\\"11818,18\\\";i:32;s:6:\\\"2481,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:131;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59784;i:4;i:59784;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:5300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"4380,17\\\";i:28;s:6:\\\"919,83\\\";i:29;N;i:30;N;i:31;s:7:\\\"4380,17\\\";i:32;s:5:\\\"919,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:132;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59785;i:4;i:59785;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"8760,33\\\";i:28;s:7:\\\"1839,67\\\";i:29;N;i:30;N;i:31;s:7:\\\"8760,33\\\";i:32;s:6:\\\"1839,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:133;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59786;i:4;i:59786;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:26000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"21487,6\\\";i:28;s:6:\\\"4512,4\\\";i:29;N;i:30;N;i:31;s:7:\\\"21487,6\\\";i:32;s:6:\\\"4512,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:134;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59787;i:4;i:59787;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:6:\\\"8512,4\\\";i:28;s:6:\\\"1787,6\\\";i:29;N;i:30;N;i:31;s:6:\\\"8512,4\\\";i:32;s:6:\\\"1787,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:135;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59788;i:4;i:59788;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"8760,33\\\";i:28;s:7:\\\"1839,67\\\";i:29;N;i:30;N;i:31;s:7:\\\"8760,33\\\";i:32;s:6:\\\"1839,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:136;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59789;i:4;i:59789;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:16200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"13388,43\\\";i:28;s:7:\\\"2811,57\\\";i:29;N;i:30;N;i:31;s:8:\\\"13388,43\\\";i:32;s:6:\\\"2811,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:137;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59790;i:4;i:59790;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19669,42\\\";i:28;s:7:\\\"4130,58\\\";i:29;N;i:30;N;i:31;s:8:\\\"19669,42\\\";i:32;s:6:\\\"4130,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:138;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59791;i:4;i:59791;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:14300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11818,18\\\";i:28;s:7:\\\"2481,82\\\";i:29;N;i:30;N;i:31;s:8:\\\"11818,18\\\";i:32;s:6:\\\"2481,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:139;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59792;i:4;i:59792;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:2400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"1983,47\\\";i:28;s:6:\\\"416,53\\\";i:29;N;i:30;N;i:31;s:7:\\\"1983,47\\\";i:32;s:5:\\\"416,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:140;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59793;i:4;i:59793;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"2479,34\\\";i:28;s:6:\\\"520,66\\\";i:29;N;i:30;N;i:31;s:7:\\\"2479,34\\\";i:32;s:5:\\\"520,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:141;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59794;i:4;i:59794;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:2400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"1983,47\\\";i:28;s:6:\\\"416,53\\\";i:29;N;i:30;N;i:31;s:7:\\\"1983,47\\\";i:32;s:5:\\\"416,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:142;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59795;i:4;i:59795;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:2400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"1983,47\\\";i:28;s:6:\\\"416,53\\\";i:29;N;i:30;N;i:31;s:7:\\\"1983,47\\\";i:32;s:5:\\\"416,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:143;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59796;i:4;i:59796;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"2975,21\\\";i:28;s:6:\\\"624,79\\\";i:29;N;i:30;N;i:31;s:7:\\\"2975,21\\\";i:32;s:5:\\\"624,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:144;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59797;i:4;i:59797;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:27100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"22396,69\\\";i:28;s:7:\\\"4703,31\\\";i:29;N;i:30;N;i:31;s:8:\\\"22396,69\\\";i:32;s:6:\\\"4703,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:145;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59798;i:4;i:59798;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:35800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"29586,78\\\";i:28;s:7:\\\"6213,22\\\";i:29;N;i:30;N;i:31;s:8:\\\"29586,78\\\";i:32;s:6:\\\"6213,2\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:146;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59799;i:4;i:59799;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:19300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15950,41\\\";i:28;s:7:\\\"3349,59\\\";i:29;N;i:30;N;i:31;s:8:\\\"15950,41\\\";i:32;s:6:\\\"3349,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:147;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59800;i:4;i:59800;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:27700;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"22892,56\\\";i:28;s:7:\\\"4807,44\\\";i:29;N;i:30;N;i:31;s:8:\\\"22892,56\\\";i:32;s:6:\\\"4807,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:148;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59801;i:4;i:59801;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:24400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"20165,29\\\";i:28;s:7:\\\"4234,71\\\";i:29;N;i:30;N;i:31;s:8:\\\"20165,29\\\";i:32;s:6:\\\"4234,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:149;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59802;i:4;i:59802;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7700;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"6363,64\\\";i:28;s:7:\\\"1336,36\\\";i:29;N;i:30;N;i:31;s:7:\\\"6363,64\\\";i:32;s:6:\\\"1336,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:150;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59803;i:4;i:59803;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:17400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"14380,17\\\";i:28;s:7:\\\"3019,83\\\";i:29;N;i:30;N;i:31;s:8:\\\"14380,17\\\";i:32;s:6:\\\"3019,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:151;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59804;i:4;i:59804;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:14300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11818,18\\\";i:28;s:7:\\\"2481,82\\\";i:29;N;i:30;N;i:31;s:8:\\\"11818,18\\\";i:32;s:6:\\\"2481,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:152;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59805;i:4;i:59805;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:8100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"6694,21\\\";i:28;s:7:\\\"1405,79\\\";i:29;N;i:30;N;i:31;s:7:\\\"6694,21\\\";i:32;s:6:\\\"1405,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:153;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59806;i:4;i:59806;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3700;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"3057,85\\\";i:28;s:6:\\\"642,15\\\";i:29;N;i:30;N;i:31;s:7:\\\"3057,85\\\";i:32;s:5:\\\"642,2\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:154;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59807;i:4;i:59807;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:14600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"12066,12\\\";i:28;s:7:\\\"2533,88\\\";i:29;N;i:30;N;i:31;s:8:\\\"12066,12\\\";i:32;s:6:\\\"2533,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:155;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59808;i:4;i:59808;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:4300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"3553,72\\\";i:28;s:6:\\\"746,28\\\";i:29;N;i:30;N;i:31;s:7:\\\"3553,72\\\";i:32;s:5:\\\"746,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:156;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59809;i:4;i:59809;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:28750;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"23760,33\\\";i:28;s:7:\\\"4989,67\\\";i:29;N;i:30;N;i:31;s:8:\\\"23760,33\\\";i:32;s:6:\\\"4989,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:157;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59810;i:4;i:59810;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:16200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"13388,43\\\";i:28;s:7:\\\"2811,57\\\";i:29;N;i:30;N;i:31;s:8:\\\"13388,43\\\";i:32;s:6:\\\"2811,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:158;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59811;i:4;i:59811;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"8264,46\\\";i:28;s:7:\\\"1735,54\\\";i:29;N;i:30;N;i:31;s:7:\\\"8264,46\\\";i:32;s:6:\\\"1735,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:159;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59812;i:4;i:59812;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:12000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9917,36\\\";i:28;s:7:\\\"2082,64\\\";i:29;N;i:30;N;i:31;s:7:\\\"9917,36\\\";i:32;s:6:\\\"2082,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:160;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59813;i:4;i:59813;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:6800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"5619,83\\\";i:28;s:7:\\\"1180,17\\\";i:29;N;i:30;N;i:31;s:7:\\\"5619,83\\\";i:32;s:6:\\\"1180,2\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:161;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59814;i:4;i:59814;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9421,49\\\";i:28;s:7:\\\"1978,51\\\";i:29;N;i:30;N;i:31;s:7:\\\"9421,49\\\";i:32;s:6:\\\"1978,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:162;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59815;i:4;i:59815;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:28750;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"23760,33\\\";i:28;s:7:\\\"4989,67\\\";i:29;N;i:30;N;i:31;s:8:\\\"23760,33\\\";i:32;s:6:\\\"4989,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:163;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59816;i:4;i:59816;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:6:\\\"6115,7\\\";i:28;s:6:\\\"1284,3\\\";i:29;N;i:30;N;i:31;s:6:\\\"6115,7\\\";i:32;s:6:\\\"1284,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:164;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59817;i:4;i:59817;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:5300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"4380,17\\\";i:28;s:6:\\\"919,83\\\";i:29;N;i:30;N;i:31;s:7:\\\"4380,17\\\";i:32;s:5:\\\"919,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:165;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59818;i:4;i:59818;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:19300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15950,41\\\";i:28;s:7:\\\"3349,59\\\";i:29;N;i:30;N;i:31;s:8:\\\"15950,41\\\";i:32;s:6:\\\"3349,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:166;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"11\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59819;i:4;i:59819;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:167;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59820;i:4;i:59820;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:17400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"14380,17\\\";i:28;s:7:\\\"3019,83\\\";i:29;N;i:30;N;i:31;s:8:\\\"14380,17\\\";i:32;s:6:\\\"3019,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:168;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59821;i:4;i:59821;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"8347,11\\\";i:28;s:7:\\\"1752,89\\\";i:29;N;i:30;N;i:31;s:7:\\\"8347,11\\\";i:32;s:6:\\\"1752,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:169;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59822;i:4;i:59822;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"15371,9\\\";i:28;s:6:\\\"3228,1\\\";i:29;N;i:30;N;i:31;s:7:\\\"15371,9\\\";i:32;s:6:\\\"3228,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:170;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59823;i:4;i:59823;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9008,26\\\";i:28;s:7:\\\"1891,74\\\";i:29;N;i:30;N;i:31;s:7:\\\"9008,26\\\";i:32;s:6:\\\"1891,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:171;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59824;i:4;i:59824;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:16000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"13223,14\\\";i:28;s:7:\\\"2776,86\\\";i:29;N;i:30;N;i:31;s:8:\\\"13223,14\\\";i:32;s:6:\\\"2776,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:172;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59825;i:4;i:59825;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:14300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11818,18\\\";i:28;s:7:\\\"2481,82\\\";i:29;N;i:30;N;i:31;s:8:\\\"11818,18\\\";i:32;s:6:\\\"2481,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:173;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59826;i:4;i:59826;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:14300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11818,18\\\";i:28;s:7:\\\"2481,82\\\";i:29;N;i:30;N;i:31;s:8:\\\"11818,18\\\";i:32;s:6:\\\"2481,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:174;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59827;i:4;i:59827;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:32900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"27190,08\\\";i:28;s:7:\\\"5709,92\\\";i:29;N;i:30;N;i:31;s:8:\\\"27190,08\\\";i:32;s:6:\\\"5709,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:175;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59828;i:4;i:59828;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:13700;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11322,31\\\";i:28;s:7:\\\"2377,69\\\";i:29;N;i:30;N;i:31;s:8:\\\"11322,31\\\";i:32;s:6:\\\"2377,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:176;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59829;i:4;i:59829;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:4800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"3966,94\\\";i:28;s:6:\\\"833,06\\\";i:29;N;i:30;N;i:31;s:7:\\\"3966,94\\\";i:32;s:5:\\\"833,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:177;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59830;i:4;i:59830;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:1500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"1239,67\\\";i:28;s:6:\\\"260,33\\\";i:29;N;i:30;N;i:31;s:7:\\\"1239,67\\\";i:32;s:5:\\\"260,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:178;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59831;i:4;i:59831;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:179;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59832;i:4;i:59832;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19669,42\\\";i:28;s:7:\\\"4130,58\\\";i:29;N;i:30;N;i:31;s:8:\\\"19669,42\\\";i:32;s:6:\\\"4130,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:180;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59833;i:4;i:59833;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:13400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11074,38\\\";i:28;s:7:\\\"2325,62\\\";i:29;N;i:30;N;i:31;s:8:\\\"11074,38\\\";i:32;s:6:\\\"2325,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:181;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59834;i:4;i:59834;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:28750;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"23760,33\\\";i:28;s:7:\\\"4989,67\\\";i:29;N;i:30;N;i:31;s:8:\\\"23760,33\\\";i:32;s:6:\\\"4989,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:182;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59835;i:4;i:59835;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"6198,35\\\";i:28;s:7:\\\"1301,65\\\";i:29;N;i:30;N;i:31;s:7:\\\"6198,35\\\";i:32;s:6:\\\"1301,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:183;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59836;i:4;i:59836;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:16200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"13388,43\\\";i:28;s:7:\\\"2811,57\\\";i:29;N;i:30;N;i:31;s:8:\\\"13388,43\\\";i:32;s:6:\\\"2811,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:184;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59837;i:4;i:59837;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:5800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"4793,39\\\";i:28;s:7:\\\"1006,61\\\";i:29;N;i:30;N;i:31;s:7:\\\"4793,39\\\";i:32;s:6:\\\"1006,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:185;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59838;i:4;i:59838;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:186;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59839;i:4;i:59839;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:27000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"22314,05\\\";i:28;s:7:\\\"4685,95\\\";i:29;N;i:30;N;i:31;s:8:\\\"22314,05\\\";i:32;i:4686;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:187;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59840;i:4;i:59840;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:6000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"4958,68\\\";i:28;s:7:\\\"1041,32\\\";i:29;N;i:30;N;i:31;s:7:\\\"4958,68\\\";i:32;s:6:\\\"1041,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:188;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59841;i:4;i:59841;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:14300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11818,18\\\";i:28;s:7:\\\"2481,82\\\";i:29;N;i:30;N;i:31;s:8:\\\"11818,18\\\";i:32;s:6:\\\"2481,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:189;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59842;i:4;i:59842;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:12600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"10413,22\\\";i:28;s:7:\\\"2186,78\\\";i:29;N;i:30;N;i:31;s:8:\\\"10413,22\\\";i:32;s:6:\\\"2186,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:190;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59843;i:4;i:59843;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"8264,46\\\";i:28;s:7:\\\"1735,54\\\";i:29;N;i:30;N;i:31;s:7:\\\"8264,46\\\";i:32;s:6:\\\"1735,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:191;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59844;i:4;i:59844;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"6528,93\\\";i:28;s:7:\\\"1371,07\\\";i:29;N;i:30;N;i:31;s:7:\\\"6528,93\\\";i:32;s:6:\\\"1371,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:192;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59845;i:4;i:59845;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"14958,68\\\";i:28;s:7:\\\"3141,32\\\";i:29;N;i:30;N;i:31;s:8:\\\"14958,68\\\";i:32;s:6:\\\"3141,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:193;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59846;i:4;i:59846;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:19350;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15991,74\\\";i:28;s:7:\\\"3358,26\\\";i:29;N;i:30;N;i:31;s:8:\\\"15991,74\\\";i:32;s:6:\\\"3358,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:194;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59847;i:4;i:59847;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:195;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59848;i:4;i:59848;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:33000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"27272,73\\\";i:28;s:7:\\\"5727,27\\\";i:29;N;i:30;N;i:31;s:8:\\\"27272,73\\\";i:32;s:6:\\\"5727,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:196;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59849;i:4;i:59849;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:28750;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"23760,33\\\";i:28;s:7:\\\"4989,67\\\";i:29;N;i:30;N;i:31;s:8:\\\"23760,33\\\";i:32;s:6:\\\"4989,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:197;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59850;i:4;i:59850;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:4800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"3966,94\\\";i:28;s:6:\\\"833,06\\\";i:29;N;i:30;N;i:31;s:7:\\\"3966,94\\\";i:32;s:5:\\\"833,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:198;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59851;i:4;i:59851;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:15700;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"12975,21\\\";i:28;s:7:\\\"2724,79\\\";i:29;N;i:30;N;i:31;s:8:\\\"12975,21\\\";i:32;s:6:\\\"2724,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:199;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59852;i:4;i:59852;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:16200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"13388,43\\\";i:28;s:7:\\\"2811,57\\\";i:29;N;i:30;N;i:31;s:8:\\\"13388,43\\\";i:32;s:6:\\\"2811,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:200;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59853;i:4;i:59853;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:1900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"1570,25\\\";i:28;s:6:\\\"329,75\\\";i:29;N;i:30;N;i:31;s:7:\\\"1570,25\\\";i:32;s:5:\\\"329,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:201;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59854;i:4;i:59854;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:25200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"20826,45\\\";i:28;s:7:\\\"4373,55\\\";i:29;N;i:30;N;i:31;s:8:\\\"20826,45\\\";i:32;s:6:\\\"4373,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:202;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59855;i:4;i:59855;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"6280,99\\\";i:28;s:7:\\\"1319,01\\\";i:29;N;i:30;N;i:31;s:7:\\\"6280,99\\\";i:32;i:1319;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:203;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59856;i:4;i:59856;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"8347,11\\\";i:28;s:7:\\\"1752,89\\\";i:29;N;i:30;N;i:31;s:7:\\\"8347,11\\\";i:32;s:6:\\\"1752,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:204;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59857;i:4;i:59857;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9421,49\\\";i:28;s:7:\\\"1978,51\\\";i:29;N;i:30;N;i:31;s:7:\\\"9421,49\\\";i:32;s:6:\\\"1978,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:205;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59858;i:4;i:59858;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:206;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59859;i:4;i:59859;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:21800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"18016,53\\\";i:28;s:7:\\\"3783,47\\\";i:29;N;i:30;N;i:31;s:8:\\\"18016,53\\\";i:32;s:6:\\\"3783,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:207;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59860;i:4;i:59860;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:32200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"26611,57\\\";i:28;s:7:\\\"5588,43\\\";i:29;N;i:30;N;i:31;s:8:\\\"26611,57\\\";i:32;s:6:\\\"5588,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:208;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59861;i:4;i:59861;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:19800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"16363,64\\\";i:28;s:7:\\\"3436,36\\\";i:29;N;i:30;N;i:31;s:8:\\\"16363,64\\\";i:32;s:6:\\\"3436,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:209;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59862;i:4;i:59862;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:210;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59863;i:4;i:59863;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9421,49\\\";i:28;s:7:\\\"1978,51\\\";i:29;N;i:30;N;i:31;s:7:\\\"9421,49\\\";i:32;s:6:\\\"1978,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:211;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59864;i:4;i:59864;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:38100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"31487,6\\\";i:28;s:6:\\\"6612,4\\\";i:29;N;i:30;N;i:31;s:7:\\\"31487,6\\\";i:32;s:6:\\\"6612,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:212;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59865;i:4;i:59865;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:6300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"5206,61\\\";i:28;s:7:\\\"1093,39\\\";i:29;N;i:30;N;i:31;s:7:\\\"5206,61\\\";i:32;s:6:\\\"1093,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:213;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59866;i:4;i:59866;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:21100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"17438,02\\\";i:28;s:7:\\\"3661,98\\\";i:29;N;i:30;N;i:31;s:8:\\\"17438,02\\\";i:32;i:3662;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:214;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59867;i:4;i:59867;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:4800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"3966,94\\\";i:28;s:6:\\\"833,06\\\";i:29;N;i:30;N;i:31;s:7:\\\"3966,94\\\";i:32;s:5:\\\"833,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:215;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59868;i:4;i:59868;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"8760,33\\\";i:28;s:7:\\\"1839,67\\\";i:29;N;i:30;N;i:31;s:7:\\\"8760,33\\\";i:32;s:6:\\\"1839,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:216;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59869;i:4;i:59869;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:16500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"13636,36\\\";i:28;s:7:\\\"2863,64\\\";i:29;N;i:30;N;i:31;s:8:\\\"13636,36\\\";i:32;s:6:\\\"2863,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:217;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59870;i:4;i:59870;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:36450;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"30123,97\\\";i:28;s:7:\\\"6326,03\\\";i:29;N;i:30;N;i:31;s:8:\\\"30123,97\\\";i:32;i:6326;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:218;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59871;i:4;i:59871;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:5300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"4380,17\\\";i:28;s:6:\\\"919,83\\\";i:29;N;i:30;N;i:31;s:7:\\\"4380,17\\\";i:32;s:5:\\\"919,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:219;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59872;i:4;i:59872;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:21900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"18099,17\\\";i:28;s:7:\\\"3800,83\\\";i:29;N;i:30;N;i:31;s:8:\\\"18099,17\\\";i:32;s:6:\\\"3800,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:220;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59873;i:4;i:59873;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:2400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"1983,47\\\";i:28;s:6:\\\"416,53\\\";i:29;N;i:30;N;i:31;s:7:\\\"1983,47\\\";i:32;s:5:\\\"416,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:221;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59874;i:4;i:59874;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:19500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"16115,7\\\";i:28;s:6:\\\"3384,3\\\";i:29;N;i:30;N;i:31;s:7:\\\"16115,7\\\";i:32;s:6:\\\"3384,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:222;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59875;i:4;i:59875;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19669,42\\\";i:28;s:7:\\\"4130,58\\\";i:29;N;i:30;N;i:31;s:8:\\\"19669,42\\\";i:32;s:6:\\\"4130,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:223;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59876;i:4;i:59876;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"5950,41\\\";i:28;s:7:\\\"1249,59\\\";i:29;N;i:30;N;i:31;s:7:\\\"5950,41\\\";i:32;s:6:\\\"1249,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:224;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59877;i:4;i:59877;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19504,13\\\";i:28;s:7:\\\"4095,87\\\";i:29;N;i:30;N;i:31;s:8:\\\"19504,13\\\";i:32;s:6:\\\"4095,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:225;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59878;i:4;i:59878;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:19300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15950,41\\\";i:28;s:7:\\\"3349,59\\\";i:29;N;i:30;N;i:31;s:8:\\\"15950,41\\\";i:32;s:6:\\\"3349,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:226;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59879;i:4;i:59879;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"5950,41\\\";i:28;s:7:\\\"1249,59\\\";i:29;N;i:30;N;i:31;s:7:\\\"5950,41\\\";i:32;s:6:\\\"1249,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:227;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"12\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59880;i:4;i:59880;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"8595,04\\\";i:28;s:7:\\\"1804,96\\\";i:29;N;i:30;N;i:31;s:7:\\\"8595,04\\\";i:32;i:1805;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:228;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59881;i:4;i:59881;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"3223,14\\\";i:28;s:6:\\\"676,86\\\";i:29;N;i:30;N;i:31;s:7:\\\"3223,14\\\";i:32;s:5:\\\"676,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:229;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59882;i:4;i:59882;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9421,49\\\";i:28;s:7:\\\"1978,51\\\";i:29;N;i:30;N;i:31;s:7:\\\"9421,49\\\";i:32;s:6:\\\"1978,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:230;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59883;i:4;i:59883;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:41600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"34380,17\\\";i:28;s:7:\\\"7219,83\\\";i:29;N;i:30;N;i:31;s:8:\\\"34380,17\\\";i:32;s:6:\\\"7219,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:231;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59884;i:4;i:59884;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:14000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11570,25\\\";i:28;s:7:\\\"2429,75\\\";i:29;N;i:30;N;i:31;s:8:\\\"11570,25\\\";i:32;s:6:\\\"2429,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:232;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59885;i:4;i:59885;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:5600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:6:\\\"4628,1\\\";i:28;s:5:\\\"971,9\\\";i:29;N;i:30;N;i:31;s:6:\\\"4628,1\\\";i:32;s:5:\\\"971,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:233;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59886;i:4;i:59886;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:9250;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"7644,63\\\";i:28;s:7:\\\"1605,37\\\";i:29;N;i:30;N;i:31;s:7:\\\"7644,63\\\";i:32;s:6:\\\"1605,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:234;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59887;i:4;i:59887;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"8429,75\\\";i:28;s:7:\\\"1770,25\\\";i:29;N;i:30;N;i:31;s:7:\\\"8429,75\\\";i:32;s:6:\\\"1770,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:235;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59888;i:4;i:59888;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"6528,93\\\";i:28;s:7:\\\"1371,07\\\";i:29;N;i:30;N;i:31;s:7:\\\"6528,93\\\";i:32;s:6:\\\"1371,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:236;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59889;i:4;i:59889;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:13300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"10991,74\\\";i:28;s:7:\\\"2308,26\\\";i:29;N;i:30;N;i:31;s:8:\\\"10991,74\\\";i:32;s:6:\\\"2308,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:237;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59890;i:4;i:59890;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:238;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59891;i:4;i:59891;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"2975,21\\\";i:28;s:6:\\\"624,79\\\";i:29;N;i:30;N;i:31;s:7:\\\"2975,21\\\";i:32;s:5:\\\"624,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:239;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59892;i:4;i:59892;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19669,42\\\";i:28;s:7:\\\"4130,58\\\";i:29;N;i:30;N;i:31;s:8:\\\"19669,42\\\";i:32;s:6:\\\"4130,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:240;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59893;i:4;i:59893;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"2975,21\\\";i:28;s:6:\\\"624,79\\\";i:29;N;i:30;N;i:31;s:7:\\\"2975,21\\\";i:32;s:5:\\\"624,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:241;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59894;i:4;i:59894;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:17700;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"14628,1\\\";i:28;s:6:\\\"3071,9\\\";i:29;N;i:30;N;i:31;s:7:\\\"14628,1\\\";i:32;s:6:\\\"3071,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:242;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59895;i:4;i:59895;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19752,07\\\";i:28;s:7:\\\"4147,93\\\";i:29;N;i:30;N;i:31;s:8:\\\"19752,07\\\";i:32;s:6:\\\"4147,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:243;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59896;i:4;i:59896;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:6:\\\"3140,5\\\";i:28;s:5:\\\"659,5\\\";i:29;N;i:30;N;i:31;s:6:\\\"3140,5\\\";i:32;s:5:\\\"659,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:244;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59897;i:4;i:59897;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:20600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"17024,79\\\";i:28;s:7:\\\"3575,21\\\";i:29;N;i:30;N;i:31;s:8:\\\"17024,79\\\";i:32;s:6:\\\"3575,2\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:245;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59898;i:4;i:59898;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:46350;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"38305,79\\\";i:28;s:7:\\\"8044,21\\\";i:29;N;i:30;N;i:31;s:8:\\\"38305,79\\\";i:32;s:6:\\\"8044,2\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:246;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59899;i:4;i:59899;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:5800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"4793,39\\\";i:28;s:7:\\\"1006,61\\\";i:29;N;i:30;N;i:31;s:7:\\\"4793,39\\\";i:32;s:6:\\\"1006,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:247;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59900;i:4;i:59900;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:8100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"6694,21\\\";i:28;s:7:\\\"1405,79\\\";i:29;N;i:30;N;i:31;s:7:\\\"6694,21\\\";i:32;s:6:\\\"1405,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:248;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59901;i:4;i:59901;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:4800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"3966,94\\\";i:28;s:6:\\\"833,06\\\";i:29;N;i:30;N;i:31;s:7:\\\"3966,94\\\";i:32;s:5:\\\"833,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:249;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59902;i:4;i:59902;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9338,84\\\";i:28;s:7:\\\"1961,16\\\";i:29;N;i:30;N;i:31;s:7:\\\"9338,84\\\";i:32;s:6:\\\"1961,2\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:250;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59903;i:4;i:59903;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19669,42\\\";i:28;s:7:\\\"4130,58\\\";i:29;N;i:30;N;i:31;s:8:\\\"19669,42\\\";i:32;s:6:\\\"4130,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:251;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59904;i:4;i:59904;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:13300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"10991,74\\\";i:28;s:7:\\\"2308,26\\\";i:29;N;i:30;N;i:31;s:8:\\\"10991,74\\\";i:32;s:6:\\\"2308,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:252;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59905;i:4;i:59905;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19669,42\\\";i:28;s:7:\\\"4130,58\\\";i:29;N;i:30;N;i:31;s:8:\\\"19669,42\\\";i:32;s:6:\\\"4130,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:253;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59906;i:4;i:59906;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:14600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"12066,12\\\";i:28;s:7:\\\"2533,88\\\";i:29;N;i:30;N;i:31;s:8:\\\"12066,12\\\";i:32;s:6:\\\"2533,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:254;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59907;i:4;i:59907;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"5950,41\\\";i:28;s:7:\\\"1249,59\\\";i:29;N;i:30;N;i:31;s:7:\\\"5950,41\\\";i:32;s:6:\\\"1249,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:255;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59908;i:4;i:59908;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"2975,21\\\";i:28;s:6:\\\"624,79\\\";i:29;N;i:30;N;i:31;s:7:\\\"2975,21\\\";i:32;s:5:\\\"624,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:256;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59909;i:4;i:59909;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:6:\\\"3140,5\\\";i:28;s:5:\\\"659,5\\\";i:29;N;i:30;N;i:31;s:6:\\\"3140,5\\\";i:32;s:5:\\\"659,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:257;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59910;i:4;i:59910;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:28750;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"23760,33\\\";i:28;s:7:\\\"4989,67\\\";i:29;N;i:30;N;i:31;s:8:\\\"23760,33\\\";i:32;s:6:\\\"4989,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:258;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59911;i:4;i:59911;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"5950,41\\\";i:28;s:7:\\\"1249,59\\\";i:29;N;i:30;N;i:31;s:7:\\\"5950,41\\\";i:32;s:6:\\\"1249,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:259;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59912;i:4;i:59912;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:260;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59913;i:4;i:59913;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:13300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"10991,74\\\";i:28;s:7:\\\"2308,26\\\";i:29;N;i:30;N;i:31;s:8:\\\"10991,74\\\";i:32;s:6:\\\"2308,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:261;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59914;i:4;i:59914;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:5400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"4462,81\\\";i:28;s:6:\\\"937,19\\\";i:29;N;i:30;N;i:31;s:7:\\\"4462,81\\\";i:32;s:5:\\\"937,2\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:262;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59915;i:4;i:59915;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9421,49\\\";i:28;s:7:\\\"1978,51\\\";i:29;N;i:30;N;i:31;s:7:\\\"9421,49\\\";i:32;s:6:\\\"1978,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:263;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59916;i:4;i:59916;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:8600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"7107,44\\\";i:28;s:7:\\\"1492,56\\\";i:29;N;i:30;N;i:31;s:7:\\\"7107,44\\\";i:32;s:6:\\\"1492,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:264;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59917;i:4;i:59917;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:2400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"1983,47\\\";i:28;s:6:\\\"416,53\\\";i:29;N;i:30;N;i:31;s:7:\\\"1983,47\\\";i:32;s:5:\\\"416,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:265;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59918;i:4;i:59918;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:9600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"7933,88\\\";i:28;s:7:\\\"1666,12\\\";i:29;N;i:30;N;i:31;s:7:\\\"7933,88\\\";i:32;s:6:\\\"1666,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:266;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59919;i:4;i:59919;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:14300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11818,18\\\";i:28;s:7:\\\"2481,82\\\";i:29;N;i:30;N;i:31;s:8:\\\"11818,18\\\";i:32;s:6:\\\"2481,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:267;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59920;i:4;i:59920;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:6100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"5041,32\\\";i:28;s:7:\\\"1058,68\\\";i:29;N;i:30;N;i:31;s:7:\\\"5041,32\\\";i:32;s:6:\\\"1058,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:268;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59921;i:4;i:59921;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:17700;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"14628,1\\\";i:28;s:6:\\\"3071,9\\\";i:29;N;i:30;N;i:31;s:7:\\\"14628,1\\\";i:32;s:6:\\\"3071,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:269;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59922;i:4;i:59922;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:6:\\\"6115,7\\\";i:28;s:6:\\\"1284,3\\\";i:29;N;i:30;N;i:31;s:6:\\\"6115,7\\\";i:32;s:6:\\\"1284,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:270;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59923;i:4;i:59923;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:1500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"1239,67\\\";i:28;s:6:\\\"260,33\\\";i:29;N;i:30;N;i:31;s:7:\\\"1239,67\\\";i:32;s:5:\\\"260,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:271;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59924;i:4;i:59924;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:17600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"14545,45\\\";i:28;s:7:\\\"3054,55\\\";i:29;N;i:30;N;i:31;s:8:\\\"14545,45\\\";i:32;s:6:\\\"3054,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:272;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59925;i:4;i:59925;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"14876,03\\\";i:28;s:7:\\\"3123,97\\\";i:29;N;i:30;N;i:31;s:8:\\\"14876,03\\\";i:32;i:3124;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:273;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59926;i:4;i:59926;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:6:\\\"9256,2\\\";i:28;s:6:\\\"1943,8\\\";i:29;N;i:30;N;i:31;s:6:\\\"9256,2\\\";i:32;s:6:\\\"1943,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:274;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59927;i:4;i:59927;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3700;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"3057,85\\\";i:28;s:6:\\\"642,15\\\";i:29;N;i:30;N;i:31;s:7:\\\"3057,85\\\";i:32;s:5:\\\"642,2\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:275;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59928;i:4;i:59928;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:43050;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"35578,51\\\";i:28;s:7:\\\"7471,49\\\";i:29;N;i:30;N;i:31;s:8:\\\"35578,51\\\";i:32;s:6:\\\"7471,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:276;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59929;i:4;i:59929;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"5950,41\\\";i:28;s:7:\\\"1249,59\\\";i:29;N;i:30;N;i:31;s:7:\\\"5950,41\\\";i:32;s:6:\\\"1249,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:277;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59930;i:4;i:59930;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:27000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"22314,05\\\";i:28;s:7:\\\"4685,95\\\";i:29;N;i:30;N;i:31;s:8:\\\"22314,05\\\";i:32;i:4686;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:278;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59931;i:4;i:59931;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:279;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59932;i:4;i:59932;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:14900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"12314,05\\\";i:28;s:7:\\\"2585,95\\\";i:29;N;i:30;N;i:31;s:8:\\\"12314,05\\\";i:32;i:2586;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:280;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59933;i:4;i:59933;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:25900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"21404,96\\\";i:28;s:7:\\\"4495,04\\\";i:29;N;i:30;N;i:31;s:8:\\\"21404,96\\\";i:32;i:4495;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:281;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59934;i:4;i:59934;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:282;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59935;i:4;i:59935;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:1500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"1239,67\\\";i:28;s:6:\\\"260,33\\\";i:29;N;i:30;N;i:31;s:7:\\\"1239,67\\\";i:32;s:5:\\\"260,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:283;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59936;i:4;i:59936;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"8760,33\\\";i:28;s:7:\\\"1839,67\\\";i:29;N;i:30;N;i:31;s:7:\\\"8760,33\\\";i:32;s:6:\\\"1839,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:284;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59937;i:4;i:59937;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:37550;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"31033,06\\\";i:28;s:7:\\\"6516,94\\\";i:29;N;i:30;N;i:31;s:8:\\\"31033,06\\\";i:32;s:6:\\\"6516,9\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:285;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59938;i:4;i:59938;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:12900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"10661,16\\\";i:28;s:7:\\\"2238,84\\\";i:29;N;i:30;N;i:31;s:8:\\\"10661,16\\\";i:32;s:6:\\\"2238,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:286;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59939;i:4;i:59939;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7700;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"6363,64\\\";i:28;s:7:\\\"1336,36\\\";i:29;N;i:30;N;i:31;s:7:\\\"6363,64\\\";i:32;s:6:\\\"1336,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:287;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59940;i:4;i:59940;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:15600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"12892,56\\\";i:28;s:7:\\\"2707,44\\\";i:29;N;i:30;N;i:31;s:8:\\\"12892,56\\\";i:32;s:6:\\\"2707,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:288;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59941;i:4;i:59941;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7700;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"6363,64\\\";i:28;s:7:\\\"1336,36\\\";i:29;N;i:30;N;i:31;s:7:\\\"6363,64\\\";i:32;s:6:\\\"1336,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:289;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"13\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59942;i:4;i:59942;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:19300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15950,41\\\";i:28;s:7:\\\"3349,59\\\";i:29;N;i:30;N;i:31;s:8:\\\"15950,41\\\";i:32;s:6:\\\"3349,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:290;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59943;i:4;i:59943;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9421,49\\\";i:28;s:7:\\\"1978,51\\\";i:29;N;i:30;N;i:31;s:7:\\\"9421,49\\\";i:32;s:6:\\\"1978,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:291;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59944;i:4;i:59944;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:15900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"13140,5\\\";i:28;s:6:\\\"2759,5\\\";i:29;N;i:30;N;i:31;s:7:\\\"13140,5\\\";i:32;s:6:\\\"2759,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:292;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59945;i:4;i:59945;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:5300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"4380,17\\\";i:28;s:6:\\\"919,83\\\";i:29;N;i:30;N;i:31;s:7:\\\"4380,17\\\";i:32;s:5:\\\"919,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:293;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59946;i:4;i:59946;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:24300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"20082,64\\\";i:28;s:7:\\\"4217,36\\\";i:29;N;i:30;N;i:31;s:8:\\\"20082,64\\\";i:32;s:6:\\\"4217,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:294;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59947;i:4;i:59947;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:17400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"14380,17\\\";i:28;s:7:\\\"3019,83\\\";i:29;N;i:30;N;i:31;s:8:\\\"14380,17\\\";i:32;s:6:\\\"3019,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:295;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59948;i:4;i:59948;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"8760,33\\\";i:28;s:7:\\\"1839,67\\\";i:29;N;i:30;N;i:31;s:7:\\\"8760,33\\\";i:32;s:6:\\\"1839,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:296;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59949;i:4;i:59949;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:8900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"7355,37\\\";i:28;s:7:\\\"1544,63\\\";i:29;N;i:30;N;i:31;s:7:\\\"7355,37\\\";i:32;s:6:\\\"1544,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:297;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59950;i:4;i:59950;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:1500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"1239,67\\\";i:28;s:6:\\\"260,33\\\";i:29;N;i:30;N;i:31;s:7:\\\"1239,67\\\";i:32;s:5:\\\"260,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:298;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59951;i:4;i:59951;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"8760,33\\\";i:28;s:7:\\\"1839,67\\\";i:29;N;i:30;N;i:31;s:7:\\\"8760,33\\\";i:32;s:6:\\\"1839,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:299;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59952;i:4;i:59952;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:13300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"10991,74\\\";i:28;s:7:\\\"2308,26\\\";i:29;N;i:30;N;i:31;s:8:\\\"10991,74\\\";i:32;s:6:\\\"2308,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:300;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59953;i:4;i:59953;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"5950,41\\\";i:28;s:7:\\\"1249,59\\\";i:29;N;i:30;N;i:31;s:7:\\\"5950,41\\\";i:32;s:6:\\\"1249,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:301;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59954;i:4;i:59954;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:4800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"3966,94\\\";i:28;s:6:\\\"833,06\\\";i:29;N;i:30;N;i:31;s:7:\\\"3966,94\\\";i:32;s:5:\\\"833,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:302;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59955;i:4;i:59955;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:14300;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"11818,18\\\";i:28;s:7:\\\"2481,82\\\";i:29;N;i:30;N;i:31;s:8:\\\"11818,18\\\";i:32;s:6:\\\"2481,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:303;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59956;i:4;i:59956;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:304;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59957;i:4;i:59957;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:4800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"3966,94\\\";i:28;s:6:\\\"833,06\\\";i:29;N;i:30;N;i:31;s:7:\\\"3966,94\\\";i:32;s:5:\\\"833,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:305;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59958;i:4;i:59958;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:4800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"3966,94\\\";i:28;s:6:\\\"833,06\\\";i:29;N;i:30;N;i:31;s:7:\\\"3966,94\\\";i:32;s:5:\\\"833,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:306;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59959;i:4;i:59959;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19669,42\\\";i:28;s:7:\\\"4130,58\\\";i:29;N;i:30;N;i:31;s:8:\\\"19669,42\\\";i:32;s:6:\\\"4130,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:307;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59960;i:4;i:59960;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:8800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"7272,73\\\";i:28;s:7:\\\"1527,27\\\";i:29;N;i:30;N;i:31;s:7:\\\"7272,73\\\";i:32;s:6:\\\"1527,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:308;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59961;i:4;i:59961;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:309;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59962;i:4;i:59962;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:1500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"1239,67\\\";i:28;s:6:\\\"260,33\\\";i:29;N;i:30;N;i:31;s:7:\\\"1239,67\\\";i:32;s:5:\\\"260,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:310;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59963;i:4;i:59963;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:311;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59964;i:4;i:59964;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:16200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"13388,43\\\";i:28;s:7:\\\"2811,57\\\";i:29;N;i:30;N;i:31;s:8:\\\"13388,43\\\";i:32;s:6:\\\"2811,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:312;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59965;i:4;i:59965;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9421,49\\\";i:28;s:7:\\\"1978,51\\\";i:29;N;i:30;N;i:31;s:7:\\\"9421,49\\\";i:32;s:6:\\\"1978,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:313;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59966;i:4;i:59966;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19669,42\\\";i:28;s:7:\\\"4130,58\\\";i:29;N;i:30;N;i:31;s:8:\\\"19669,42\\\";i:32;s:6:\\\"4130,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:314;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59967;i:4;i:59967;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:4800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"3966,94\\\";i:28;s:6:\\\"833,06\\\";i:29;N;i:30;N;i:31;s:7:\\\"3966,94\\\";i:32;s:5:\\\"833,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:315;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59968;i:4;i:59968;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:4600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"3801,65\\\";i:28;s:6:\\\"798,35\\\";i:29;N;i:30;N;i:31;s:7:\\\"3801,65\\\";i:32;s:5:\\\"798,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:316;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59969;i:4;i:59969;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"2479,34\\\";i:28;s:6:\\\"520,66\\\";i:29;N;i:30;N;i:31;s:7:\\\"2479,34\\\";i:32;s:5:\\\"520,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:317;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59970;i:4;i:59970;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:28750;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"23760,33\\\";i:28;s:7:\\\"4989,67\\\";i:29;N;i:30;N;i:31;s:8:\\\"23760,33\\\";i:32;s:6:\\\"4989,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:318;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59971;i:4;i:59971;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9173,55\\\";i:28;s:7:\\\"1926,45\\\";i:29;N;i:30;N;i:31;s:7:\\\"9173,55\\\";i:32;s:6:\\\"1926,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:319;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59972;i:4;i:59972;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:320;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59973;i:4;i:59973;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:15600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"12892,56\\\";i:28;s:7:\\\"2707,44\\\";i:29;N;i:30;N;i:31;s:8:\\\"12892,56\\\";i:32;s:6:\\\"2707,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:321;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59974;i:4;i:59974;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11700;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9669,42\\\";i:28;s:7:\\\"2030,58\\\";i:29;N;i:30;N;i:31;s:7:\\\"9669,42\\\";i:32;s:6:\\\"2030,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:322;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59975;i:4;i:59975;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:16200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"13388,43\\\";i:28;s:7:\\\"2811,57\\\";i:29;N;i:30;N;i:31;s:8:\\\"13388,43\\\";i:32;s:6:\\\"2811,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:323;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59976;i:4;i:59976;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9586,78\\\";i:28;s:7:\\\"2013,22\\\";i:29;N;i:30;N;i:31;s:7:\\\"9586,78\\\";i:32;s:6:\\\"2013,2\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:324;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59977;i:4;i:59977;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"8760,33\\\";i:28;s:7:\\\"1839,67\\\";i:29;N;i:30;N;i:31;s:7:\\\"8760,33\\\";i:32;s:6:\\\"1839,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:325;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59978;i:4;i:59978;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:26100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"21570,25\\\";i:28;s:7:\\\"4529,75\\\";i:29;N;i:30;N;i:31;s:8:\\\"21570,25\\\";i:32;s:6:\\\"4529,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:326;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59979;i:4;i:59979;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:10600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"8760,33\\\";i:28;s:7:\\\"1839,67\\\";i:29;N;i:30;N;i:31;s:7:\\\"8760,33\\\";i:32;s:6:\\\"1839,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:327;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59980;i:4;i:59980;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:4500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"3719,01\\\";i:28;s:6:\\\"780,99\\\";i:29;N;i:30;N;i:31;s:7:\\\"3719,01\\\";i:32;i:781;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:328;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59981;i:4;i:59981;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:15600;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"12892,56\\\";i:28;s:7:\\\"2707,44\\\";i:29;N;i:30;N;i:31;s:8:\\\"12892,56\\\";i:32;s:6:\\\"2707,4\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:329;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59982;i:4;i:59982;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:31150;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"25743,8\\\";i:28;s:6:\\\"5406,2\\\";i:29;N;i:30;N;i:31;s:7:\\\"25743,8\\\";i:32;s:6:\\\"5406,2\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:330;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59983;i:4;i:59983;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:3000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"2479,34\\\";i:28;s:6:\\\"520,66\\\";i:29;N;i:30;N;i:31;s:7:\\\"2479,34\\\";i:32;s:5:\\\"520,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:331;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59984;i:4;i:59984;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:1500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"1239,67\\\";i:28;s:6:\\\"260,33\\\";i:29;N;i:30;N;i:31;s:7:\\\"1239,67\\\";i:32;s:5:\\\"260,3\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:332;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59985;i:4;i:59985;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:26100;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"21570,25\\\";i:28;s:7:\\\"4529,75\\\";i:29;N;i:30;N;i:31;s:8:\\\"21570,25\\\";i:32;s:6:\\\"4529,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:333;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59986;i:4;i:59986;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9421,49\\\";i:28;s:7:\\\"1978,51\\\";i:29;N;i:30;N;i:31;s:7:\\\"9421,49\\\";i:32;s:6:\\\"1978,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:334;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59987;i:4;i:59987;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:52750;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"43595,04\\\";i:28;s:7:\\\"9154,96\\\";i:29;N;i:30;N;i:31;s:8:\\\"43595,04\\\";i:32;i:9155;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:335;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59988;i:4;i:59988;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"6528,93\\\";i:28;s:7:\\\"1371,07\\\";i:29;N;i:30;N;i:31;s:7:\\\"6528,93\\\";i:32;s:6:\\\"1371,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:336;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59989;i:4;i:59989;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:38850;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"32107,44\\\";i:28;s:7:\\\"6742,56\\\";i:29;N;i:30;N;i:31;s:8:\\\"32107,44\\\";i:32;s:6:\\\"6742,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:337;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59990;i:4;i:59990;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:7200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"5950,41\\\";i:28;s:7:\\\"1249,59\\\";i:29;N;i:30;N;i:31;s:7:\\\"5950,41\\\";i:32;s:6:\\\"1249,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:338;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59991;i:4;i:59991;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:1900;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"1570,25\\\";i:28;s:6:\\\"329,75\\\";i:29;N;i:30;N;i:31;s:7:\\\"1570,25\\\";i:32;s:5:\\\"329,8\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:339;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59992;i:4;i:59992;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:28750;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"23760,33\\\";i:28;s:7:\\\"4989,67\\\";i:29;N;i:30;N;i:31;s:8:\\\"23760,33\\\";i:32;s:6:\\\"4989,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:340;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59993;i:4;i:59993;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:16200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"13388,43\\\";i:28;s:7:\\\"2811,57\\\";i:29;N;i:30;N;i:31;s:8:\\\"13388,43\\\";i:32;s:6:\\\"2811,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:341;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59994;i:4;i:59994;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:27000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"22314,05\\\";i:28;s:7:\\\"4685,95\\\";i:29;N;i:30;N;i:31;s:8:\\\"22314,05\\\";i:32;i:4686;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:342;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59995;i:4;i:59995;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19669,42\\\";i:28;s:7:\\\"4130,58\\\";i:29;N;i:30;N;i:31;s:8:\\\"19669,42\\\";i:32;s:6:\\\"4130,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:343;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59996;i:4;i:59996;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:18200;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"15041,32\\\";i:28;s:7:\\\"3158,68\\\";i:29;N;i:30;N;i:31;s:8:\\\"15041,32\\\";i:32;s:6:\\\"3158,7\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:344;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59997;i:4;i:59997;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:20400;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"16859,5\\\";i:28;s:6:\\\"3540,5\\\";i:29;N;i:30;N;i:31;s:7:\\\"16859,5\\\";i:32;s:6:\\\"3540,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:345;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59998;i:4;i:59998;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:11700;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"9669,42\\\";i:28;s:7:\\\"2030,58\\\";i:29;N;i:30;N;i:31;s:7:\\\"9669,42\\\";i:32;s:6:\\\"2030,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:346;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:59999;i:4;i:59999;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:23500;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:8:\\\"19421,49\\\";i:28;s:7:\\\"4078,51\\\";i:29;N;i:30;N;i:31;s:8:\\\"19421,49\\\";i:32;s:6:\\\"4078,5\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:347;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"14\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:60000;i:4;i:60000;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:4800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"3966,94\\\";i:28;s:6:\\\"833,06\\\";i:29;N;i:30;N;i:31;s:7:\\\"3966,94\\\";i:32;s:5:\\\"833,1\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:348;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"15\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:60001;i:4;i:60001;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:9000;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"7438,02\\\";i:28;s:7:\\\"1561,98\\\";i:29;N;i:30;N;i:31;s:7:\\\"7438,02\\\";i:32;i:1562;}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}i:349;O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:33:{i:0;s:9:\\\"15\\/2\\/2025\\\";i:1;i:6;i:2;i:7;i:3;i:60002;i:4;i:60002;i:5;i:96;i:6;i:99999999;i:7;N;i:8;N;i:9;i:14800;i:10;s:3:\\\"PES\\\";i:11;i:1;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;N;i:21;N;i:22;N;i:23;N;i:24;N;i:25;N;i:26;N;i:27;s:7:\\\"12231,4\\\";i:28;s:6:\\\"2568,6\\\";i:29;N;i:30;N;i:31;s:7:\\\"12231,4\\\";i:32;s:6:\\\"2568,6\\\";}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}}s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;}s:11:\\\"ReceiptType\\\";O:39:\\\"Illuminate\\\\Database\\\\Eloquent\\\\Collection\\\":2:{s:8:\\\"\\u0000*\\u0000items\\\";a:71:{i:0;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:1;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2019-07-29 22:19:32\\\";s:4:\\\"name\\\";s:9:\\\"Factura A\\\";s:4:\\\"code\\\";s:1:\\\"1\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:1;s:4:\\\"tipo\\\";s:7:\\\"Factura\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:1;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2019-07-29 22:19:32\\\";s:4:\\\"name\\\";s:9:\\\"Factura A\\\";s:4:\\\"code\\\";s:1:\\\"1\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:1;s:4:\\\"tipo\\\";s:7:\\\"Factura\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:1;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:2;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2019-07-29 22:19:32\\\";s:4:\\\"name\\\";s:17:\\\"Nota de débito A\\\";s:4:\\\"code\\\";s:1:\\\"2\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:2;s:4:\\\"tipo\\\";s:15:\\\"Nota de Débito\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:2;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2019-07-29 22:19:32\\\";s:4:\\\"name\\\";s:17:\\\"Nota de débito A\\\";s:4:\\\"code\\\";s:1:\\\"2\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:2;s:4:\\\"tipo\\\";s:15:\\\"Nota de Débito\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:2;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:3;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2019-07-29 22:19:32\\\";s:4:\\\"name\\\";s:18:\\\"Nota de crédito A\\\";s:4:\\\"code\\\";s:1:\\\"3\\\";s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";N;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:3;s:4:\\\"tipo\\\";s:16:\\\"Nota de Crédito\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:3;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2019-07-29 22:19:32\\\";s:4:\\\"name\\\";s:18:\\\"Nota de crédito A\\\";s:4:\\\"code\\\";s:1:\\\"3\\\";s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";N;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:3;s:4:\\\"tipo\\\";s:16:\\\"Nota de Crédito\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:3;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:4;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:9:\\\"Factura B\\\";s:4:\\\"code\\\";s:1:\\\"6\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:2;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:6;s:4:\\\"tipo\\\";s:7:\\\"Factura\\\";s:5:\\\"letra\\\";s:1:\\\"B\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:4;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:9:\\\"Factura B\\\";s:4:\\\"code\\\";s:1:\\\"6\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:2;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:6;s:4:\\\"tipo\\\";s:7:\\\"Factura\\\";s:5:\\\"letra\\\";s:1:\\\"B\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:4;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:5;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:17:\\\"Nota de débito B\\\";s:4:\\\"code\\\";s:1:\\\"7\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:2;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:7;s:4:\\\"tipo\\\";s:15:\\\"Nota de Débito\\\";s:5:\\\"letra\\\";s:1:\\\"B\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:5;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:17:\\\"Nota de débito B\\\";s:4:\\\"code\\\";s:1:\\\"7\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:2;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:7;s:4:\\\"tipo\\\";s:15:\\\"Nota de Débito\\\";s:5:\\\"letra\\\";s:1:\\\"B\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:5;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:6;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:18:\\\"Nota de crédito B\\\";s:4:\\\"code\\\";s:1:\\\"8\\\";s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";N;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:8;s:4:\\\"tipo\\\";s:16:\\\"Nota de Crédito\\\";s:5:\\\"letra\\\";s:1:\\\"B\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:6;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:18:\\\"Nota de crédito B\\\";s:4:\\\"code\\\";s:1:\\\"8\\\";s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";N;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:8;s:4:\\\"tipo\\\";s:16:\\\"Nota de Crédito\\\";s:5:\\\"letra\\\";s:1:\\\"B\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:6;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:7;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2019-07-29 22:19:32\\\";s:4:\\\"name\\\";s:9:\\\"Factura C\\\";s:4:\\\"code\\\";s:2:\\\"11\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:0;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:1;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:11;s:4:\\\"tipo\\\";s:7:\\\"Factura\\\";s:5:\\\"letra\\\";s:1:\\\"C\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:7;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2019-07-29 22:19:32\\\";s:4:\\\"name\\\";s:9:\\\"Factura C\\\";s:4:\\\"code\\\";s:2:\\\"11\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:0;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:1;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:11;s:4:\\\"tipo\\\";s:7:\\\"Factura\\\";s:5:\\\"letra\\\";s:1:\\\"C\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:7;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:8;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2019-07-29 22:19:32\\\";s:4:\\\"name\\\";s:17:\\\"Nota de débito C\\\";s:4:\\\"code\\\";s:2:\\\"12\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:0;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:1;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:12;s:4:\\\"tipo\\\";s:15:\\\"Nota de Débito\\\";s:5:\\\"letra\\\";s:1:\\\"C\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:8;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2019-07-29 22:19:32\\\";s:4:\\\"name\\\";s:17:\\\"Nota de débito C\\\";s:4:\\\"code\\\";s:2:\\\"12\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:0;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:1;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:12;s:4:\\\"tipo\\\";s:15:\\\"Nota de Débito\\\";s:5:\\\"letra\\\";s:1:\\\"C\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:8;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:9;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2019-07-29 22:19:32\\\";s:4:\\\"name\\\";s:18:\\\"Nota de crédito C\\\";s:4:\\\"code\\\";s:2:\\\"13\\\";s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";N;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:1;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:13;s:4:\\\"tipo\\\";s:16:\\\"Nota de Crédito\\\";s:5:\\\"letra\\\";s:1:\\\"C\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:9;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2019-07-29 22:19:32\\\";s:4:\\\"name\\\";s:18:\\\"Nota de crédito C\\\";s:4:\\\"code\\\";s:2:\\\"13\\\";s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";N;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:1;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:13;s:4:\\\"tipo\\\";s:16:\\\"Nota de Crédito\\\";s:5:\\\"letra\\\";s:1:\\\"C\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:9;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:10;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";N;s:4:\\\"name\\\";s:8:\\\"RECIBO A\\\";s:4:\\\"code\\\";s:1:\\\"4\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:4;s:4:\\\"tipo\\\";s:6:\\\"RECIBO\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:10;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";N;s:4:\\\"name\\\";s:8:\\\"RECIBO A\\\";s:4:\\\"code\\\";s:1:\\\"4\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:4;s:4:\\\"tipo\\\";s:6:\\\"RECIBO\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:10;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:11;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:8:\\\"RECIBO B\\\";s:4:\\\"code\\\";s:1:\\\"9\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:2;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:9;s:4:\\\"tipo\\\";s:6:\\\"RECIBO\\\";s:5:\\\"letra\\\";s:1:\\\"B\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:11;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:8:\\\"RECIBO B\\\";s:4:\\\"code\\\";s:1:\\\"9\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:2;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:9;s:4:\\\"tipo\\\";s:6:\\\"RECIBO\\\";s:5:\\\"letra\\\";s:1:\\\"B\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:11;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:12;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";N;s:4:\\\"name\\\";s:8:\\\"RECIBO C\\\";s:4:\\\"code\\\";s:2:\\\"15\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:0;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:1;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:15;s:4:\\\"tipo\\\";s:6:\\\"RECIBO\\\";s:5:\\\"letra\\\";s:1:\\\"C\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:12;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";N;s:4:\\\"name\\\";s:8:\\\"RECIBO C\\\";s:4:\\\"code\\\";s:2:\\\"15\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:0;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:1;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:15;s:4:\\\"tipo\\\";s:6:\\\"RECIBO\\\";s:5:\\\"letra\\\";s:1:\\\"C\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:12;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:13;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2020-02-27 02:46:40\\\";s:4:\\\"name\\\";s:9:\\\"Factura E\\\";s:4:\\\"code\\\";s:2:\\\"19\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:0;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:19;s:4:\\\"tipo\\\";s:7:\\\"Factura\\\";s:5:\\\"letra\\\";s:1:\\\"E\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:13;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2020-02-27 02:46:40\\\";s:4:\\\"name\\\";s:9:\\\"Factura E\\\";s:4:\\\"code\\\";s:2:\\\"19\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:0;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:19;s:4:\\\"tipo\\\";s:7:\\\"Factura\\\";s:5:\\\"letra\\\";s:1:\\\"E\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:13;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:14;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2020-02-27 02:46:40\\\";s:4:\\\"name\\\";s:17:\\\"Nota de débito E\\\";s:4:\\\"code\\\";s:2:\\\"20\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:0;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:20;s:4:\\\"tipo\\\";s:15:\\\"Nota de Débito\\\";s:5:\\\"letra\\\";s:1:\\\"E\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:14;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2020-02-27 02:46:40\\\";s:4:\\\"name\\\";s:17:\\\"Nota de débito E\\\";s:4:\\\"code\\\";s:2:\\\"20\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:0;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:20;s:4:\\\"tipo\\\";s:15:\\\"Nota de Débito\\\";s:5:\\\"letra\\\";s:1:\\\"E\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:14;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:15;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2020-02-27 02:46:40\\\";s:4:\\\"name\\\";s:18:\\\"Nota de Crédito E\\\";s:4:\\\"code\\\";s:2:\\\"21\\\";s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";N;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:21;s:4:\\\"tipo\\\";s:16:\\\"Nota de Crédito\\\";s:5:\\\"letra\\\";s:1:\\\"E\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:15;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2020-02-27 02:46:40\\\";s:4:\\\"name\\\";s:18:\\\"Nota de Crédito E\\\";s:4:\\\"code\\\";s:2:\\\"21\\\";s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";N;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:21;s:4:\\\"tipo\\\";s:16:\\\"Nota de Crédito\\\";s:5:\\\"letra\\\";s:1:\\\"E\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:15;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:16;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2021-09-16 15:06:56\\\";s:4:\\\"name\\\";s:9:\\\"Factura M\\\";s:4:\\\"code\\\";s:2:\\\"51\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:51;s:4:\\\"tipo\\\";s:7:\\\"Factura\\\";s:5:\\\"letra\\\";s:1:\\\"M\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:16;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2021-09-16 15:06:56\\\";s:4:\\\"name\\\";s:9:\\\"Factura M\\\";s:4:\\\"code\\\";s:2:\\\"51\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:51;s:4:\\\"tipo\\\";s:7:\\\"Factura\\\";s:5:\\\"letra\\\";s:1:\\\"M\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:16;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:17;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2020-02-27 02:46:40\\\";s:4:\\\"name\\\";s:23:\\\"Despacho de Importacion\\\";s:4:\\\"code\\\";s:2:\\\"66\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";N;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:0;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:66;s:4:\\\"tipo\\\";N;s:5:\\\"letra\\\";N;s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:17;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2020-02-27 02:46:40\\\";s:4:\\\"name\\\";s:23:\\\"Despacho de Importacion\\\";s:4:\\\"code\\\";s:2:\\\"66\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";N;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:0;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:66;s:4:\\\"tipo\\\";N;s:5:\\\"letra\\\";N;s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:17;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:18;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2021-09-16 15:06:56\\\";s:4:\\\"name\\\";s:17:\\\"Nota de Credito M\\\";s:4:\\\"code\\\";s:2:\\\"53\\\";s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";N;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:53;s:4:\\\"tipo\\\";s:16:\\\"Nota de Crédito\\\";s:5:\\\"letra\\\";s:1:\\\"M\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:18;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2021-09-16 15:06:56\\\";s:4:\\\"name\\\";s:17:\\\"Nota de Credito M\\\";s:4:\\\"code\\\";s:2:\\\"53\\\";s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";N;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:53;s:4:\\\"tipo\\\";s:16:\\\"Nota de Crédito\\\";s:5:\\\"letra\\\";s:1:\\\"M\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:18;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:19;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2021-09-16 15:06:56\\\";s:4:\\\"name\\\";s:16:\\\"Nota de Debito M\\\";s:4:\\\"code\\\";s:2:\\\"52\\\";s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:52;s:4:\\\"tipo\\\";s:15:\\\"Nota de Débito\\\";s:5:\\\"letra\\\";s:1:\\\"M\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:19;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";s:19:\\\"2021-09-16 15:06:56\\\";s:4:\\\"name\\\";s:16:\\\"Nota de Debito M\\\";s:4:\\\"code\\\";s:2:\\\"52\\\";s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:52;s:4:\\\"tipo\\\";s:15:\\\"Nota de Débito\\\";s:5:\\\"letra\\\";s:1:\\\"M\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:19;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:20;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";N;s:4:\\\"name\\\";s:8:\\\"Recibo M\\\";s:4:\\\"code\\\";s:2:\\\"54\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:54;s:4:\\\"tipo\\\";s:6:\\\"RECIBO\\\";s:5:\\\"letra\\\";s:1:\\\"M\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:20;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";N;s:4:\\\"name\\\";s:8:\\\"Recibo M\\\";s:4:\\\"code\\\";s:2:\\\"54\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:54;s:4:\\\"tipo\\\";s:6:\\\"RECIBO\\\";s:5:\\\"letra\\\";s:1:\\\"M\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:20;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:21;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";N;s:4:\\\"name\\\";s:8:\\\"Recibo E\\\";s:4:\\\"code\\\";N;s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";i:0;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";N;s:4:\\\"tipo\\\";s:6:\\\"RECIBO\\\";s:5:\\\"letra\\\";s:1:\\\"E\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:21;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";N;s:10:\\\"updated_at\\\";N;s:4:\\\"name\\\";s:8:\\\"Recibo E\\\";s:4:\\\"code\\\";N;s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";i:0;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";N;s:4:\\\"tipo\\\";s:6:\\\"RECIBO\\\";s:5:\\\"letra\\\";s:1:\\\"E\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:21;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:22;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-05-14 21:22:16\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:30:\\\"Liquidacion Primaria de Granos\\\";s:4:\\\"code\\\";s:2:\\\"33\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:33;s:4:\\\"tipo\\\";s:30:\\\"Liquidacion Primaria de Granos\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:1;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:22;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-05-14 21:22:16\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:30:\\\"Liquidacion Primaria de Granos\\\";s:4:\\\"code\\\";s:2:\\\"33\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:33;s:4:\\\"tipo\\\";s:30:\\\"Liquidacion Primaria de Granos\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:1;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:22;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:23;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:4:\\\"name\\\";s:48:\\\"FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A\\\";s:4:\\\"code\\\";s:3:\\\"201\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:201;s:4:\\\"tipo\\\";s:46:\\\"FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE)\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:23;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:4:\\\"name\\\";s:48:\\\"FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A\\\";s:4:\\\"code\\\";s:3:\\\"201\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:201;s:4:\\\"tipo\\\";s:46:\\\"FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE)\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:23;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:24;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:4:\\\"name\\\";s:43:\\\"NOTA DE DEBITO ELECTRÓNICA MiPyMEs (FCE) A\\\";s:4:\\\"code\\\";s:3:\\\"202\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:202;s:4:\\\"tipo\\\";s:50:\\\"NOTA DEBITO DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE)\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:24;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:4:\\\"name\\\";s:43:\\\"NOTA DE DEBITO ELECTRÓNICA MiPyMEs (FCE) A\\\";s:4:\\\"code\\\";s:3:\\\"202\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:202;s:4:\\\"tipo\\\";s:50:\\\"NOTA DEBITO DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE)\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:24;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:25;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:4:\\\"name\\\";s:44:\\\"NOTA DE CREDITO ELECTRÓNICA MiPyMEs (FCE) A\\\";s:4:\\\"code\\\";s:3:\\\"203\\\";s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";N;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:203;s:4:\\\"tipo\\\";s:51:\\\"NOTA CREDITO DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE)\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:25;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:4:\\\"name\\\";s:44:\\\"NOTA DE CREDITO ELECTRÓNICA MiPyMEs (FCE) A\\\";s:4:\\\"code\\\";s:3:\\\"203\\\";s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";N;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:203;s:4:\\\"tipo\\\";s:51:\\\"NOTA CREDITO DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE)\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:25;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:26;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:48:\\\"FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) B\\\";s:4:\\\"code\\\";s:3:\\\"206\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:2;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:206;s:4:\\\"tipo\\\";s:46:\\\"FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE)\\\";s:5:\\\"letra\\\";s:1:\\\"B\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:26;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:48:\\\"FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) B\\\";s:4:\\\"code\\\";s:3:\\\"206\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:2;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:206;s:4:\\\"tipo\\\";s:46:\\\"FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE)\\\";s:5:\\\"letra\\\";s:1:\\\"B\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:26;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:27;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:43:\\\"NOTA DE DEBITO ELECTRÓNICA MiPyMEs (FCE) B\\\";s:4:\\\"code\\\";s:3:\\\"207\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:2;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:207;s:4:\\\"tipo\\\";s:50:\\\"NOTA DEBITO DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE)\\\";s:5:\\\"letra\\\";s:1:\\\"B\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:27;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:43:\\\"NOTA DE DEBITO ELECTRÓNICA MiPyMEs (FCE) B\\\";s:4:\\\"code\\\";s:3:\\\"207\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:2;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:207;s:4:\\\"tipo\\\";s:50:\\\"NOTA DEBITO DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE)\\\";s:5:\\\"letra\\\";s:1:\\\"B\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:27;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:28;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:44:\\\"NOTA DE CREDITO ELECTRÓNICA MiPyMEs (FCE) B\\\";s:4:\\\"code\\\";s:3:\\\"208\\\";s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";N;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:208;s:4:\\\"tipo\\\";s:51:\\\"NOTA CREDITO DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE)\\\";s:5:\\\"letra\\\";s:1:\\\"B\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:28;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:44:\\\"NOTA DE CREDITO ELECTRÓNICA MiPyMEs (FCE) B\\\";s:4:\\\"code\\\";s:3:\\\"208\\\";s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";N;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:208;s:4:\\\"tipo\\\";s:51:\\\"NOTA CREDITO DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE)\\\";s:5:\\\"letra\\\";s:1:\\\"B\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:28;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:29;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:4:\\\"name\\\";s:48:\\\"FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) C\\\";s:4:\\\"code\\\";s:3:\\\"211\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:0;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:1;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:211;s:4:\\\"tipo\\\";s:46:\\\"FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE)\\\";s:5:\\\"letra\\\";s:1:\\\"C\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:29;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:4:\\\"name\\\";s:48:\\\"FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) C\\\";s:4:\\\"code\\\";s:3:\\\"211\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:0;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:1;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:211;s:4:\\\"tipo\\\";s:46:\\\"FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE)\\\";s:5:\\\"letra\\\";s:1:\\\"C\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:29;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:30;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:4:\\\"name\\\";s:43:\\\"NOTA DE DEBITO ELECTRÓNICA MiPyMEs (FCE) C\\\";s:4:\\\"code\\\";s:3:\\\"212\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:0;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:1;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:212;s:4:\\\"tipo\\\";s:50:\\\"NOTA DEBITO DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE)\\\";s:5:\\\"letra\\\";s:1:\\\"C\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:30;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:4:\\\"name\\\";s:43:\\\"NOTA DE DEBITO ELECTRÓNICA MiPyMEs (FCE) C\\\";s:4:\\\"code\\\";s:3:\\\"212\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:0;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:1;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:212;s:4:\\\"tipo\\\";s:50:\\\"NOTA DEBITO DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE)\\\";s:5:\\\"letra\\\";s:1:\\\"C\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:30;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:31;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:4:\\\"name\\\";s:45:\\\"NOTA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) C\\\";s:4:\\\"code\\\";s:3:\\\"213\\\";s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";N;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:1;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:213;s:4:\\\"tipo\\\";s:51:\\\"NOTA CREDITO DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE)\\\";s:5:\\\"letra\\\";s:1:\\\"C\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:31;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2019-11-05 19:00:05\\\";s:4:\\\"name\\\";s:45:\\\"NOTA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) C\\\";s:4:\\\"code\\\";s:3:\\\"213\\\";s:6:\\\"credit\\\";i:1;s:17:\\\"agroup_iva_module\\\";N;s:16:\\\"sell_no_taxabled\\\";i:1;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:1;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:213;s:4:\\\"tipo\\\";s:51:\\\"NOTA CREDITO DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE)\\\";s:5:\\\"letra\\\";s:1:\\\"C\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:31;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:32;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-01-28 01:59:55\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:24:\\\"Tique (Informe Diario Z)\\\";s:4:\\\"code\\\";s:2:\\\"83\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:2;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:83;s:4:\\\"tipo\\\";s:23:\\\"Cierre Diario Informe Z\\\";s:5:\\\"letra\\\";s:1:\\\"Z\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:32;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-01-28 01:59:55\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:24:\\\"Tique (Informe Diario Z)\\\";s:4:\\\"code\\\";s:2:\\\"83\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:2;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:83;s:4:\\\"tipo\\\";s:23:\\\"Cierre Diario Informe Z\\\";s:5:\\\"letra\\\";s:1:\\\"Z\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:32;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:33;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-02-19 04:48:11\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-02-19 04:48:11\\\";s:4:\\\"name\\\";s:71:\\\"Comprobantes de Compra de Bienes No Registrables a Consumidores Finales\\\";s:4:\\\"code\\\";s:2:\\\"49\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:49;s:4:\\\"tipo\\\";s:48:\\\"Comprobantes de Compra de Bienes No Registrables\\\";s:5:\\\"letra\\\";s:22:\\\"a Consumidores Finales\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:33;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-02-19 04:48:11\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-02-19 04:48:11\\\";s:4:\\\"name\\\";s:71:\\\"Comprobantes de Compra de Bienes No Registrables a Consumidores Finales\\\";s:4:\\\"code\\\";s:2:\\\"49\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:0;s:19:\\\"afip_comprobante_id\\\";i:49;s:4:\\\"tipo\\\";s:48:\\\"Comprobantes de Compra de Bienes No Registrables\\\";s:5:\\\"letra\\\";s:22:\\\"a Consumidores Finales\\\";s:17:\\\"facta_electronica\\\";i:0;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:33;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:34;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-09-14 11:47:42\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-08-17 11:20:17\\\";s:4:\\\"name\\\";s:37:\\\"Cuenta de Venta y Líquido Producto A\\\";s:4:\\\"code\\\";s:2:\\\"60\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:60;s:4:\\\"tipo\\\";s:37:\\\"Cuentas de Venta y Liquido Producto A\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:34;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-09-14 11:47:42\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-08-17 11:20:17\\\";s:4:\\\"name\\\";s:37:\\\"Cuenta de Venta y Líquido Producto A\\\";s:4:\\\"code\\\";s:2:\\\"60\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:60;s:4:\\\"tipo\\\";s:37:\\\"Cuentas de Venta y Liquido Producto A\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:34;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:35;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-09-14 11:47:42\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-08-17 11:20:17\\\";s:4:\\\"name\\\";s:37:\\\"Cuenta de Venta y Líquido Producto B\\\";s:4:\\\"code\\\";s:2:\\\"61\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:2;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:61;s:4:\\\"tipo\\\";s:37:\\\"Cuentas de Venta y Liquido Producto B\\\";s:5:\\\"letra\\\";s:1:\\\"B\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:35;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-09-14 11:47:42\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-08-17 11:20:17\\\";s:4:\\\"name\\\";s:37:\\\"Cuenta de Venta y Líquido Producto B\\\";s:4:\\\"code\\\";s:2:\\\"61\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:2;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:1;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:61;s:4:\\\"tipo\\\";s:37:\\\"Cuentas de Venta y Liquido Producto B\\\";s:5:\\\"letra\\\";s:1:\\\"B\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:1;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:35;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:36;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-09-14 11:47:42\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:15:\\\"Liquidaciones A\\\";s:4:\\\"code\\\";s:2:\\\"63\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:63;s:4:\\\"tipo\\\";s:15:\\\"Liquidaciones A\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:36;s:7:\\\"user_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2020-09-14 11:47:42\\\";s:10:\\\"updated_at\\\";s:19:\\\"2020-09-14 11:47:43\\\";s:4:\\\"name\\\";s:15:\\\"Liquidaciones A\\\";s:4:\\\"code\\\";s:2:\\\"63\\\";s:6:\\\"credit\\\";i:0;s:17:\\\"agroup_iva_module\\\";i:1;s:16:\\\"sell_no_taxabled\\\";i:0;s:15:\\\"buy_no_taxabled\\\";i:0;s:16:\\\"iva_condition_id\\\";i:2;s:11:\\\"is_fce_pyme\\\";i:1;s:19:\\\"afip_comprobante_id\\\";i:63;s:4:\\\"tipo\\\";s:15:\\\"Liquidaciones A\\\";s:5:\\\"letra\\\";s:1:\\\"A\\\";s:17:\\\"facta_electronica\\\";i:1;s:12:\\\"is_stock_lpg\\\";i:0;s:15:\\\"show_from_total\\\";i:0;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:1:{s:10:\\\"deleted_at\\\";s:8:\\\"datetime\\\";}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:21:\\\"\\u0000*\\u0000attributeCastCache\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:13:\\\"usesUniqueIds\\\";b:0;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}i:36;O:22:\\\"App\\\\Models\\\\ReceiptType\\\":31:{s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:13:\\\"receipt_types\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:19:\\\"preventsLazyLoading\\\";b:0;s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:28:\\\"\\u0000*\\u0000escapeWhenCastingToString\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:37;s:7